####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Teapot.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.0',
  head=head(
    children=[
    meta(content='Teapot.x3d',name='title'),
    meta(content='IndexedFaceSet example.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='4 May 2003',name='created'),
    meta(content='5 May 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Teapot.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='Teapot.x3d'),
    Viewpoint(description='1M view',position=(0.0,0.0,1.0)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(rotation=(1,0,0,-1.57),scale=(0.1,0.1,0.1),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,0.0))),
        geometry=IndexedFaceSet(coordIndex=[0,1,2,3,-1,4,0,3,5,-1,6,4,5,7,-1,8,6,7,9,-1,10,8,9,11,-1,3,2,12,13,-1,5,3,13,14,-1,7,5,14,15,-1,9,7,15,16,-1,11,9,16,17,-1,13,12,18,19,-1,14,13,19,20,-1,15,14,20,21,-1,16,15,21,22,-1,17,16,22,23,-1,19,18,24,25,-1,20,19,25,26,-1,21,20,26,27,-1,22,21,27,28,-1,23,22,28,29,-1,25,24,30,31,-1,26,25,31,32,-1,27,26,32,33,-1,28,27,33,34,-1,29,28,34,35,-1,31,30,36,37,-1,32,31,37,38,-1,33,32,38,39,-1,34,33,39,40,-1,35,34,40,41,-1,37,36,42,43,-1,38,37,43,44,-1,39,38,44,45,-1,40,39,45,46,-1,41,40,46,47,-1,43,42,48,49,-1,44,43,49,50,-1,45,44,50,51,-1,46,45,51,52,-1,47,46,52,53,-1,49,48,54,55,-1,50,49,55,56,-1,51,50,56,57,-1,52,51,57,58,-1,53,52,58,59,-1,55,54,60,61,-1,56,55,61,62,-1,57,56,62,63,-1,58,57,63,64,-1,59,58,64,65,-1,61,60,66,67,-1,62,61,67,68,-1,63,62,68,69,-1,64,63,69,70,-1,65,64,70,71,-1,67,66,1,0,-1,68,67,0,4,-1,69,68,4,6,-1,70,69,6,8,-1,71,70,8,10,-1,72,10,11,73,-1,74,72,73,75,-1,76,74,75,77,-1,78,76,77,79,-1,80,78,79,81,-1,82,80,81,83,-1,73,11,17,84,-1,75,73,84,85,-1,77,75,85,86,-1,79,77,86,87,-1,81,79,87,88,-1,83,81,88,89,-1,84,17,23,90,-1,85,84,90,91,-1,86,85,91,92,-1,87,86,92,93,-1,88,87,93,94,-1,89,88,94,95,-1,90,23,29,96,-1,91,90,96,97,-1,92,91,97,98,-1,93,92,98,99,-1,94,93,99,100,-1,95,94,100,101,-1,96,29,35,102,-1,97,96,102,103,-1,98,97,103,104,-1,99,98,104,105,-1,100,99,105,106,-1,101,100,106,107,-1,102,35,41,108,-1,103,102,108,109,-1,104,103,109,110,-1,105,104,110,111,-1,106,105,111,112,-1,107,106,112,113,-1,108,41,47,114,-1,109,108,114,115,-1,110,109,115,116,-1,111,110,116,117,-1,112,111,117,118,-1,113,112,118,119,-1,114,47,53,120,-1,115,114,120,121,-1,116,115,121,122,-1,117,116,122,123,-1,118,117,123,124,-1,119,118,124,125,-1,120,53,59,126,-1,121,120,126,127,-1,122,121,127,128,-1,123,122,128,129,-1,124,123,129,130,-1,125,124,130,131,-1,126,59,65,132,-1,127,126,132,133,-1,128,127,133,134,-1,129,128,134,135,-1,130,129,135,136,-1,131,130,136,137,-1,132,65,71,138,-1,133,132,138,139,-1,134,133,139,140,-1,135,134,140,141,-1,136,135,141,142,-1,137,136,142,143,-1,138,71,10,72,-1,139,138,72,74,-1,140,139,74,76,-1,141,140,76,78,-1,142,141,78,80,-1,143,142,80,82,-1,119,125,131,137,143,82,83,89,95,101,107,113,-1,1,153,144,2,-1,2,144,145,12,-1,12,146,147,18,-1,18,148,876,24,-1,24,876,149,30,-1,30,149,150,36,-1,36,150,42,-1,42,1179,154,48,-1,48,154,1180,54,-1,54,151,152,60,-1,60,155,66,-1,66,153,1,-1,146,12,145,-1,148,18,147,-1,1179,42,150,-1,54,1180,151,-1,60,152,155,-1,66,155,153,-1,156,157,158,159,-1,160,156,159,161,-1,162,160,161,163,-1,164,162,163,165,-1,166,164,165,167,-1,159,158,168,169,-1,161,159,169,170,-1,163,161,170,171,-1,165,163,171,172,-1,167,165,172,173,-1,169,168,174,175,-1,170,169,175,176,-1,171,170,176,177,-1,172,171,177,178,-1,173,172,178,179,-1,175,174,180,181,-1,176,175,181,182,-1,177,176,182,183,-1,178,177,183,184,-1,179,178,184,185,-1,181,180,186,187,-1,182,181,187,188,-1,183,182,188,189,-1,184,183,189,190,-1,185,184,190,191,-1,187,186,192,193,-1,188,187,193,194,-1,189,188,194,195,-1,190,189,195,196,-1,191,190,196,197,-1,193,192,198,199,-1,194,193,199,200,-1,195,194,200,201,-1,196,195,201,202,-1,197,196,202,203,-1,199,198,204,205,-1,200,199,205,206,-1,201,200,206,207,-1,202,201,207,208,-1,203,202,208,209,-1,205,204,210,211,-1,206,205,211,212,-1,207,206,212,213,-1,208,207,213,214,-1,209,208,214,215,-1,211,210,216,217,-1,212,211,217,218,-1,213,212,218,219,-1,214,213,219,220,-1,215,214,220,221,-1,217,216,222,223,-1,218,217,223,224,-1,219,218,224,225,-1,220,219,225,226,-1,221,220,226,227,-1,223,222,157,156,-1,224,223,156,160,-1,225,224,160,162,-1,226,225,162,164,-1,227,226,164,166,-1,228,166,167,229,-1,230,228,229,231,-1,232,230,231,233,-1,234,232,233,235,-1,236,234,235,237,-1,229,167,173,238,-1,231,229,238,239,-1,233,231,239,240,-1,235,233,240,241,-1,237,235,241,242,-1,238,173,179,243,-1,239,238,243,244,-1,240,239,244,245,-1,241,240,245,246,-1,242,241,246,247,-1,243,179,185,248,-1,244,243,248,249,-1,245,244,249,250,-1,246,245,250,251,-1,247,246,251,252,-1,248,185,191,253,-1,249,248,253,254,-1,250,249,254,255,-1,251,250,255,256,-1,252,251,256,257,-1,253,191,197,258,-1,254,253,258,259,-1,255,254,259,260,-1,256,255,260,261,-1,257,256,261,262,-1,258,197,203,263,-1,259,258,263,264,-1,260,259,264,265,-1,261,260,265,266,-1,262,261,266,267,-1,263,203,209,268,-1,264,263,268,269,-1,265,264,269,270,-1,266,265,270,271,-1,267,266,271,272,-1,268,209,215,273,-1,269,268,273,274,-1,270,269,274,275,-1,271,270,275,276,-1,272,271,276,277,-1,273,215,221,278,-1,274,273,278,279,-1,275,274,279,280,-1,276,275,280,281,-1,277,276,281,282,-1,278,221,227,283,-1,279,278,283,284,-1,280,279,284,285,-1,281,280,285,286,-1,282,281,286,287,-1,283,227,166,228,-1,284,283,228,230,-1,285,284,230,232,-1,286,285,232,234,-1,287,286,234,236,-1,157,288,289,158,-1,158,289,290,168,-1,168,291,174,-1,174,291,292,180,-1,180,292,293,186,-1,186,293,294,192,-1,192,294,198,-1,198,295,296,204,-1,204,296,297,210,-1,210,297,216,-1,216,298,299,222,-1,222,300,288,157,-1,1188,237,242,1181,-1,1181,242,247,1182,-1,1182,247,252,1183,-1,1183,252,257,-1,301,257,262,1184,-1,1184,262,267,-1,1187,267,272,-1,1187,272,277,1185,-1,1185,277,282,302,-1,1186,282,287,-1,304,287,236,303,-1,168,290,291,-1,295,198,294,-1,298,216,297,-1,222,299,300,-1,257,301,1183,-1,267,875,1184,-1,875,267,1187,-1,302,282,1186,-1,1186,287,304,-1,305,306,307,308,-1,309,305,308,310,-1,311,309,310,312,-1,313,311,312,314,-1,315,313,314,316,-1,317,315,316,318,-1,308,307,319,320,-1,310,308,320,321,-1,312,310,321,322,-1,314,312,322,323,-1,316,314,323,324,-1,318,316,324,325,-1,320,319,326,327,-1,321,320,327,328,-1,322,321,328,329,-1,323,322,329,330,-1,324,323,330,331,-1,325,324,331,332,-1,327,326,333,334,-1,328,327,334,335,-1,329,328,335,336,-1,330,329,336,337,-1,331,330,337,338,-1,332,331,338,339,-1,334,333,340,341,-1,335,334,341,342,-1,336,335,342,343,-1,337,336,343,344,-1,338,337,344,345,-1,339,338,345,346,-1,341,340,347,348,-1,342,341,348,349,-1,343,342,349,350,-1,344,343,350,351,-1,345,344,351,352,-1,346,345,352,353,-1,348,347,354,355,-1,349,348,355,356,-1,350,349,356,357,-1,351,350,357,358,-1,352,351,358,359,-1,353,352,359,360,-1,355,354,361,362,-1,356,355,362,363,-1,357,356,363,364,-1,358,357,364,365,-1,359,358,365,366,-1,360,359,366,367,-1,362,361,368,369,-1,363,362,369,370,-1,364,363,370,371,-1,365,364,371,372,-1,366,365,372,373,-1,367,366,373,374,-1,369,368,375,376,-1,370,369,376,377,-1,371,370,377,378,-1,372,371,378,379,-1,373,372,379,380,-1,374,373,380,381,-1,376,375,382,383,-1,377,376,383,384,-1,378,377,384,385,-1,379,378,385,386,-1,380,379,386,387,-1,381,380,387,388,-1,383,382,389,390,-1,384,383,390,391,-1,385,384,391,392,-1,386,385,392,393,-1,387,386,393,394,-1,388,387,394,395,-1,390,389,396,397,-1,391,390,397,398,-1,392,391,398,399,-1,393,392,399,400,-1,394,393,400,401,-1,395,394,401,402,-1,397,396,403,404,-1,398,397,404,405,-1,399,398,405,406,-1,400,399,406,407,-1,401,400,407,408,-1,402,401,408,409,-1,404,403,410,411,-1,405,404,411,412,-1,406,405,412,413,-1,407,406,413,414,-1,408,407,414,415,-1,409,408,415,416,-1,411,410,417,418,-1,412,411,418,419,-1,413,412,419,420,-1,414,413,420,421,-1,415,414,421,422,-1,416,415,422,423,-1,418,417,424,425,-1,419,418,425,426,-1,420,419,426,427,-1,421,420,427,428,-1,422,421,428,429,-1,423,422,429,430,-1,425,424,431,432,-1,426,425,432,433,-1,427,426,433,434,-1,428,427,434,435,-1,429,428,435,436,-1,430,429,436,437,-1,432,431,438,439,-1,433,432,439,440,-1,434,433,440,441,-1,435,434,441,442,-1,436,435,442,443,-1,437,436,443,444,-1,439,438,445,446,-1,440,439,446,447,-1,441,440,447,448,-1,442,441,448,449,-1,443,442,449,450,-1,444,443,450,451,-1,446,445,452,453,-1,447,446,453,454,-1,448,447,454,455,-1,449,448,455,456,-1,450,449,456,457,-1,451,450,457,458,-1,453,452,459,460,-1,454,453,460,461,-1,455,454,461,462,-1,456,455,462,463,-1,457,456,463,464,-1,458,457,464,465,-1,460,459,466,467,-1,461,460,467,468,-1,462,461,468,469,-1,463,462,469,470,-1,464,463,470,471,-1,465,464,471,472,-1,467,466,306,305,-1,468,467,305,309,-1,469,468,309,311,-1,470,469,311,313,-1,471,470,313,315,-1,472,471,315,317,-1,473,317,318,474,-1,475,473,474,476,-1,477,475,476,478,-1,474,318,325,479,-1,476,474,479,480,-1,478,476,480,481,-1,482,478,481,483,-1,484,482,483,485,-1,486,484,485,487,-1,479,325,332,488,-1,480,479,488,489,-1,481,480,489,490,-1,483,481,490,491,-1,485,483,491,492,-1,487,485,492,493,-1,488,332,339,494,-1,489,488,494,495,-1,490,489,495,496,-1,491,490,496,497,-1,492,491,497,498,-1,493,492,498,499,-1,494,339,346,500,-1,495,494,500,501,-1,496,495,501,502,-1,497,496,502,503,-1,498,497,503,504,-1,499,498,504,505,-1,500,346,353,506,-1,501,500,506,507,-1,502,501,507,508,-1,503,502,508,509,-1,504,503,509,510,-1,505,504,510,511,-1,506,353,360,512,-1,507,506,512,513,-1,508,507,513,514,-1,509,508,514,515,-1,510,509,515,516,-1,511,510,516,517,-1,512,360,367,518,-1,513,512,518,519,-1,514,513,519,520,-1,515,514,520,521,-1,516,515,521,522,-1,517,516,522,523,-1,518,367,374,524,-1,519,518,524,525,-1,520,519,525,526,-1,521,520,526,527,-1,522,521,527,528,-1,523,522,528,529,-1,524,374,381,530,-1,525,524,530,531,-1,526,525,531,532,-1,527,526,532,533,-1,528,527,533,534,-1,529,528,534,535,-1,530,381,388,536,-1,531,530,536,537,-1,532,531,537,538,-1,533,532,538,539,-1,534,533,539,540,-1,535,534,540,541,-1,538,537,542,543,-1,539,538,543,544,-1,540,539,544,545,-1,543,542,546,547,-1,544,543,547,548,-1,545,544,548,549,-1,550,402,409,551,-1,546,550,551,552,-1,547,546,552,553,-1,548,547,553,554,-1,549,548,554,555,-1,556,549,555,557,-1,551,409,416,558,-1,552,551,558,559,-1,553,552,559,560,-1,554,553,560,561,-1,555,554,561,562,-1,557,555,562,563,-1,558,416,423,564,-1,559,558,564,565,-1,560,559,565,566,-1,561,560,566,567,-1,562,561,567,568,-1,563,562,568,569,-1,564,423,430,570,-1,565,564,570,571,-1,566,565,571,572,-1,567,566,572,573,-1,568,567,573,574,-1,569,568,574,575,-1,570,430,437,576,-1,571,570,576,577,-1,572,571,577,578,-1,573,572,578,579,-1,574,573,579,580,-1,575,574,580,581,-1,576,437,444,582,-1,577,576,582,583,-1,578,577,583,584,-1,579,578,584,585,-1,580,579,585,586,-1,581,580,586,587,-1,582,444,451,588,-1,583,582,588,589,-1,584,583,589,590,-1,585,584,590,591,-1,586,585,591,592,-1,587,586,592,593,-1,588,451,458,594,-1,589,588,594,595,-1,590,589,595,596,-1,591,590,596,597,-1,592,591,597,598,-1,593,592,598,599,-1,594,458,465,600,-1,595,594,600,601,-1,596,595,601,602,-1,597,596,602,603,-1,598,597,603,604,-1,599,598,604,605,-1,600,465,472,606,-1,601,600,606,607,-1,602,601,607,608,-1,603,602,608,609,-1,604,603,609,610,-1,605,604,610,611,-1,606,472,317,473,-1,607,606,473,475,-1,608,607,475,477,-1,612,613,614,615,-1,616,612,615,617,-1,618,616,617,619,-1,620,618,619,621,-1,622,486,487,623,-1,614,622,623,624,-1,615,614,624,625,-1,617,615,625,626,-1,619,617,626,627,-1,621,619,627,628,-1,623,487,493,629,-1,624,623,629,630,-1,625,624,630,631,-1,626,625,631,632,-1,627,626,632,633,-1,628,627,633,634,-1,629,493,499,635,-1,630,629,635,636,-1,631,630,636,637,-1,632,631,637,638,-1,633,632,638,639,-1,634,633,639,640,-1,635,499,505,641,-1,636,635,641,642,-1,637,636,642,643,-1,638,637,643,644,-1,639,638,644,645,-1,640,639,645,646,-1,641,505,511,647,-1,642,641,647,648,-1,643,642,648,649,-1,644,643,649,650,-1,645,644,650,651,-1,646,645,651,652,-1,647,511,517,653,-1,648,647,653,654,-1,649,648,654,655,-1,650,649,655,656,-1,651,650,656,657,-1,652,651,657,658,-1,653,517,523,659,-1,654,653,659,660,-1,655,654,660,661,-1,656,655,661,662,-1,657,656,662,663,-1,658,657,663,664,-1,659,523,529,665,-1,660,659,665,666,-1,661,660,666,667,-1,662,661,667,668,-1,663,662,668,669,-1,664,663,669,670,-1,665,529,535,671,-1,666,665,671,672,-1,667,666,672,673,-1,668,667,673,674,-1,669,668,674,675,-1,670,669,675,676,-1,671,535,541,677,-1,672,671,677,678,-1,673,672,678,679,-1,674,673,679,680,-1,675,674,680,681,-1,676,675,681,682,-1,679,678,683,684,-1,680,679,684,685,-1,681,680,685,686,-1,682,681,686,687,-1,684,683,688,689,-1,685,684,689,690,-1,686,685,690,691,-1,687,686,691,692,-1,693,556,557,694,-1,688,693,694,695,-1,689,688,695,696,-1,690,689,696,697,-1,691,690,697,698,-1,692,691,698,699,-1,694,557,563,700,-1,695,694,700,701,-1,696,695,701,702,-1,697,696,702,703,-1,698,697,703,704,-1,699,698,704,705,-1,700,563,569,706,-1,701,700,706,707,-1,702,701,707,708,-1,703,702,708,709,-1,704,703,709,710,-1,705,704,710,711,-1,706,569,575,712,-1,707,706,712,713,-1,708,707,713,714,-1,709,708,714,715,-1,710,709,715,716,-1,711,710,716,717,-1,712,575,581,718,-1,713,712,718,719,-1,714,713,719,720,-1,715,714,720,721,-1,716,715,721,722,-1,717,716,722,723,-1,718,581,587,724,-1,719,718,724,725,-1,720,719,725,726,-1,721,720,726,727,-1,722,721,727,728,-1,723,722,728,729,-1,724,587,593,730,-1,725,724,730,731,-1,726,725,731,732,-1,727,726,732,733,-1,728,727,733,734,-1,729,728,734,735,-1,730,593,599,736,-1,731,730,736,737,-1,732,731,737,738,-1,733,732,738,739,-1,734,733,739,740,-1,735,734,740,741,-1,736,599,605,742,-1,737,736,742,743,-1,738,737,743,744,-1,739,738,744,745,-1,740,739,745,746,-1,741,740,746,747,-1,742,605,611,748,-1,743,742,748,749,-1,744,743,749,750,-1,745,744,750,751,-1,746,745,751,752,-1,747,746,752,753,-1,750,749,613,612,-1,751,750,612,616,-1,752,751,616,618,-1,753,752,618,620,-1,754,755,756,-1,757,754,756,758,-1,759,757,758,760,-1,761,759,760,762,-1,763,761,762,764,-1,620,763,764,753,-1,756,755,765,-1,758,756,765,766,-1,760,758,766,767,-1,762,760,767,768,-1,764,762,768,769,-1,753,764,769,747,-1,765,755,770,-1,766,765,770,771,-1,767,766,771,772,-1,768,767,772,773,-1,769,768,773,774,-1,747,769,774,741,-1,770,755,775,-1,771,770,775,776,-1,772,771,776,777,-1,773,772,777,778,-1,774,773,778,779,-1,741,774,779,735,-1,775,755,780,-1,776,775,780,781,-1,777,776,781,782,-1,778,777,782,783,-1,779,778,783,784,-1,735,779,784,729,-1,780,755,785,-1,781,780,785,786,-1,782,781,786,787,-1,783,782,787,788,-1,784,783,788,789,-1,729,784,789,723,-1,785,755,790,-1,786,785,790,791,-1,787,786,791,792,-1,788,787,792,793,-1,789,788,793,794,-1,723,789,794,717,-1,790,755,795,-1,791,790,795,796,-1,792,791,796,797,-1,793,792,797,798,-1,794,793,798,799,-1,717,794,799,711,-1,795,755,800,-1,796,795,800,801,-1,797,796,801,802,-1,798,797,802,803,-1,799,798,803,804,-1,711,799,804,705,-1,800,755,805,-1,801,800,805,806,-1,802,801,806,807,-1,803,802,807,808,-1,804,803,808,809,-1,705,804,809,699,-1,805,755,810,-1,806,805,810,811,-1,807,806,811,812,-1,808,807,812,813,-1,809,808,813,814,-1,699,809,814,692,-1,810,755,815,-1,811,810,815,816,-1,812,811,816,817,-1,813,812,817,818,-1,814,813,818,819,-1,692,814,819,687,-1,815,755,820,-1,816,815,820,821,-1,817,816,821,822,-1,818,817,822,823,-1,819,818,823,824,-1,687,819,824,682,-1,820,755,825,-1,821,820,825,826,-1,822,821,826,827,-1,823,822,827,828,-1,824,823,828,829,-1,682,824,829,676,-1,825,755,830,-1,826,825,830,831,-1,827,826,831,832,-1,828,827,832,833,-1,829,828,833,834,-1,676,829,834,670,-1,830,755,835,-1,831,830,835,836,-1,832,831,836,837,-1,833,832,837,838,-1,834,833,838,839,-1,670,834,839,664,-1,835,755,840,-1,836,835,840,841,-1,837,836,841,842,-1,838,837,842,843,-1,839,838,843,844,-1,664,839,844,658,-1,840,755,845,-1,841,840,845,846,-1,842,841,846,847,-1,843,842,847,848,-1,844,843,848,849,-1,658,844,849,652,-1,845,755,850,-1,846,845,850,851,-1,847,846,851,852,-1,848,847,852,853,-1,849,848,853,854,-1,652,849,854,646,-1,850,755,855,-1,851,850,855,856,-1,852,851,856,857,-1,853,852,857,858,-1,854,853,858,859,-1,646,854,859,640,-1,855,755,860,-1,856,855,860,861,-1,857,856,861,862,-1,858,857,862,863,-1,859,858,863,864,-1,640,859,864,634,-1,860,755,865,-1,861,860,865,866,-1,862,861,866,867,-1,863,862,867,868,-1,864,863,868,869,-1,634,864,869,628,-1,865,755,870,-1,866,865,870,871,-1,867,866,871,872,-1,868,867,872,873,-1,869,868,873,874,-1,628,869,874,621,-1,870,755,754,-1,871,870,754,757,-1,872,871,757,759,-1,873,872,759,761,-1,874,873,761,763,-1,621,874,763,620,-1,536,388,291,-1,537,536,289,-1,537,289,288,542,-1,541,540,545,304,1188,-1,402,550,295,-1,294,395,402,295,-1,546,542,298,-1,297,550,546,298,-1,1186,545,549,556,-1,678,677,1183,301,683,-1,388,395,292,-1,388,292,291,-1,300,542,288,-1,289,536,290,-1,295,550,296,-1,542,299,298,-1,304,545,1186,-1,1184,683,301,-1,693,875,1187,-1,1187,556,693,-1,683,1184,875,-1,683,875,693,688,-1,395,294,293,-1,536,291,290,-1,550,297,296,-1,542,300,299,-1,302,556,1185,-1,556,1187,1185,-1,1183,677,1182,-1,677,1181,1182,-1,1186,556,302,-1,145,482,146,-1,147,484,148,-1,608,477,155,-1,609,608,155,-1,610,609,152,151,-1,876,486,622,-1,613,150,622,614,-1,749,748,150,613,-1,477,144,153,-1,153,155,477,-1,482,145,144,-1,477,478,144,-1,144,478,482,-1,482,484,146,-1,146,484,147,-1,148,484,1178,-1,484,486,148,1178,-1,148,486,876,-1,609,155,152,-1,610,151,1180,-1,154,611,1180,-1,611,610,1180,-1,622,149,876,-1,748,611,1179,-1,150,748,1179,-1,622,150,149,-1,1179,611,154,-1,466,459,877,-1,326,319,878,-1,466,877,878,319,307,306,-1,333,326,879,-1,879,326,878,-1,340,333,880,-1,880,333,879,-1,347,340,881,-1,881,340,880,-1,354,347,882,-1,882,347,881,-1,361,354,883,-1,883,354,882,-1,368,361,884,-1,884,361,883,-1,375,368,885,-1,885,368,884,-1,382,375,886,-1,886,375,885,-1,389,382,887,-1,887,382,886,-1,396,389,888,-1,888,389,887,-1,403,396,889,-1,889,396,888,-1,410,403,890,-1,890,403,889,-1,417,410,891,-1,891,410,890,-1,424,417,892,-1,892,417,891,-1,431,424,893,-1,893,424,892,-1,438,431,894,-1,894,431,893,-1,445,438,895,-1,895,438,894,-1,452,445,896,-1,896,445,895,-1,459,452,897,-1,897,452,896,-1,898,459,897,-1,899,459,898,-1,877,459,900,-1,900,459,899,-1,901,902,903,904,-1,905,901,904,906,-1,907,905,906,908,-1,909,907,908,910,-1,911,909,910,912,-1,904,903,913,914,-1,906,904,914,915,-1,908,906,915,916,-1,910,908,916,917,-1,912,910,917,918,-1,914,913,919,920,-1,915,914,920,921,-1,916,915,921,922,-1,917,916,922,923,-1,918,917,923,924,-1,920,919,925,926,-1,921,920,926,927,-1,922,921,927,928,-1,923,922,928,929,-1,924,923,929,930,-1,926,925,931,932,-1,927,926,932,933,-1,928,927,933,934,-1,929,928,934,935,-1,930,929,935,936,-1,932,931,937,938,-1,933,932,938,939,-1,934,933,939,940,-1,935,934,940,941,-1,936,935,941,942,-1,938,937,943,944,-1,939,938,944,945,-1,940,939,945,946,-1,941,940,946,947,-1,942,941,947,948,-1,944,943,949,950,-1,945,944,950,951,-1,946,945,951,952,-1,947,946,952,953,-1,948,947,953,954,-1,950,949,955,956,-1,951,950,956,957,-1,952,951,957,958,-1,953,952,958,959,-1,954,953,959,960,-1,956,955,961,962,-1,957,956,962,963,-1,958,957,963,964,-1,959,958,964,965,-1,960,959,965,966,-1,962,961,967,968,-1,963,962,968,969,-1,964,963,969,970,-1,965,964,970,971,-1,966,965,971,972,-1,968,967,973,974,-1,969,968,974,975,-1,970,969,975,976,-1,971,970,976,977,-1,972,971,977,978,-1,974,973,979,980,-1,975,974,980,981,-1,976,975,981,982,-1,977,976,982,983,-1,978,977,983,984,-1,980,979,985,986,-1,981,980,986,987,-1,982,981,987,988,-1,983,982,988,989,-1,984,983,989,990,-1,986,985,991,992,-1,987,986,992,993,-1,988,987,993,994,-1,989,988,994,995,-1,990,989,995,996,-1,992,991,997,998,-1,993,992,998,999,-1,994,993,999,1000,-1,995,994,1000,1001,-1,996,995,1001,1002,-1,998,997,1003,1004,-1,999,998,1004,1005,-1,1000,999,1005,1006,-1,1001,1000,1006,1007,-1,1002,1001,1007,1008,-1,1004,1003,1009,1010,-1,1005,1004,1010,1011,-1,1006,1005,1011,1012,-1,1007,1006,1012,1013,-1,1008,1007,1013,1014,-1,1010,1009,1015,1016,-1,1011,1010,1016,1017,-1,1012,1011,1017,1018,-1,1013,1012,1018,1019,-1,1014,1013,1019,1020,-1,1016,1015,1021,1022,-1,1017,1016,1022,1023,-1,1018,1017,1023,1024,-1,1019,1018,1024,1025,-1,1020,1019,1025,1026,-1,1022,1021,1027,1028,-1,1023,1022,1028,1029,-1,1024,1023,1029,1030,-1,1025,1024,1030,1031,-1,1026,1025,1031,1032,-1,1028,1027,1033,1034,-1,1029,1028,1034,1035,-1,1030,1029,1035,1036,-1,1031,1030,1036,1037,-1,1032,1031,1037,1038,-1,1034,1033,1039,1040,-1,1035,1034,1040,1041,-1,1036,1035,1041,1042,-1,1037,1036,1042,1043,-1,1038,1037,1043,1044,-1,1040,1039,902,901,-1,1041,1040,901,905,-1,1042,1041,905,907,-1,1043,1042,907,909,-1,1044,1043,909,911,-1,902,1045,1046,903,-1,903,1047,1048,913,-1,913,1048,1049,919,-1,919,1049,1050,925,-1,925,1050,1051,931,-1,931,1051,937,-1,937,1052,943,-1,943,1053,949,-1,949,1054,955,-1,955,1055,961,-1,961,1056,1057,967,-1,967,1058,1059,973,-1,973,1060,1061,979,-1,979,1062,1063,985,-1,985,1064,991,-1,991,1065,997,-1,997,1066,1003,-1,1003,1079,1067,1009,-1,1009,1068,1069,1015,-1,1015,1070,1071,1021,-1,1021,1072,1073,1027,-1,1027,1074,1075,1033,-1,1033,1076,1077,1039,-1,1039,1078,1045,902,-1,1047,903,1046,-1,1052,937,1051,-1,1053,943,1052,-1,1054,949,1053,-1,1055,955,1054,-1,1056,961,1055,-1,1058,967,1057,-1,1060,973,1059,-1,1062,979,1061,-1,1064,985,1063,-1,1065,991,1064,-1,1066,997,1065,-1,1079,1003,1066,-1,1068,1009,1067,-1,1070,1015,1069,-1,1072,1021,1071,-1,1074,1027,1073,-1,1076,1033,1075,-1,1080,1039,1077,-1,1039,1080,1078,-1,1081,1082,1083,-1,1084,1081,1083,1085,-1,1086,1084,1085,1087,-1,1088,1086,1087,1089,-1,1083,1082,1090,-1,1085,1083,1090,1091,-1,1087,1085,1091,1092,-1,1089,1087,1092,1093,-1,1090,1082,1094,-1,1091,1090,1094,1095,-1,1092,1091,1095,1096,-1,1093,1092,1096,1097,-1,1094,1082,1098,-1,1095,1094,1098,1099,-1,1096,1095,1099,1100,-1,1097,1096,1100,1101,-1,1098,1082,1102,-1,1099,1098,1102,1103,-1,1100,1099,1103,1104,-1,1101,1100,1104,1105,-1,1102,1082,1106,-1,1103,1102,1106,1107,-1,1104,1103,1107,1108,-1,1105,1104,1108,1109,-1,1106,1082,1110,-1,1107,1106,1110,1111,-1,1108,1107,1111,1112,-1,1109,1108,1112,1113,-1,1110,1082,1114,-1,1111,1110,1114,1115,-1,1112,1111,1115,1116,-1,1113,1112,1116,1117,-1,1114,1082,1118,-1,1115,1114,1118,1119,-1,1116,1115,1119,1120,-1,1117,1116,1120,1121,-1,1118,1082,1122,-1,1119,1118,1122,1123,-1,1120,1119,1123,1124,-1,1121,1120,1124,1125,-1,1122,1082,1126,-1,1123,1122,1126,1127,-1,1124,1123,1127,1128,-1,1125,1124,1128,1129,-1,1126,1082,1130,-1,1127,1126,1130,1131,-1,1128,1127,1131,1132,-1,1129,1128,1132,1133,-1,1130,1082,1134,-1,1131,1130,1134,1135,-1,1132,1131,1135,1136,-1,1133,1132,1136,1137,-1,1134,1082,1138,-1,1135,1134,1138,1139,-1,1136,1135,1139,1140,-1,1137,1136,1140,1141,-1,1138,1082,1142,-1,1139,1138,1142,1143,-1,1140,1139,1143,1144,-1,1141,1140,1144,1145,-1,1142,1082,1146,-1,1143,1142,1146,1147,-1,1144,1143,1147,1148,-1,1145,1144,1148,1149,-1,1146,1082,1150,-1,1147,1146,1150,1151,-1,1148,1147,1151,1152,-1,1149,1148,1152,1153,-1,1150,1082,1154,-1,1151,1150,1154,1155,-1,1152,1151,1155,1156,-1,1153,1152,1156,1157,-1,1154,1082,1158,-1,1155,1154,1158,1159,-1,1156,1155,1159,1160,-1,1157,1156,1160,1161,-1,1158,1082,1162,-1,1159,1158,1162,1163,-1,1160,1159,1163,1164,-1,1161,1160,1164,1165,-1,1162,1082,1166,-1,1163,1162,1166,1167,-1,1164,1163,1167,1168,-1,1165,1164,1168,1169,-1,1166,1082,1170,-1,1167,1166,1170,1171,-1,1168,1167,1171,1172,-1,1169,1168,1172,1173,-1,1170,1082,1174,-1,1171,1170,1174,1175,-1,1172,1171,1175,1176,-1,1173,1172,1176,1177,-1,1174,1082,1081,-1,1175,1174,1081,1084,-1,1176,1175,1084,1086,-1,1177,1176,1086,1088,-1,1045,1088,1089,1046,-1,1046,1089,1093,1047,-1,1048,1093,1097,-1,1049,1097,1101,-1,1050,1101,1105,-1,1051,1105,1109,1052,-1,1052,1109,1113,1053,-1,1053,1113,1117,1054,-1,1054,1117,1121,1055,-1,1055,1121,1125,1056,-1,1057,1125,1129,1058,-1,1059,1129,1133,1060,-1,1061,1133,1137,1062,-1,1063,1137,1141,1064,-1,1064,1141,1145,1065,-1,1065,1145,1149,1066,-1,1066,1149,1153,1079,-1,1067,1157,1161,1068,-1,1069,1161,1165,1070,-1,1071,1165,1169,1072,-1,1073,1169,1173,1074,-1,1075,1173,1177,1076,-1,1077,1177,1088,1080,-1,1078,1088,1045,-1,1093,1048,1047,-1,1097,1049,1048,-1,1101,1050,1049,-1,1105,1051,1050,-1,1125,1057,1056,-1,1129,1059,1058,-1,1133,1061,1060,-1,1137,1063,1062,-1,1157,1067,1079,-1,1161,1069,1068,-1,1165,1071,1070,-1,1169,1073,1072,-1,1173,1075,1074,-1,1177,1077,1076,-1,1088,1078,1080,-1,877,911,912,878,-1,878,912,918,879,-1,879,918,924,880,-1,880,924,930,881,-1,881,930,936,882,-1,882,936,942,883,-1,883,942,948,884,-1,884,948,954,885,-1,885,954,960,886,-1,886,960,966,887,-1,887,966,972,888,-1,888,972,978,889,-1,889,978,984,890,-1,890,984,990,891,-1,891,990,996,892,-1,892,996,1002,893,-1,893,1002,1008,894,-1,894,1008,1014,895,-1,895,1014,1020,896,-1,896,1020,1026,897,-1,897,1026,1032,898,-1,898,1032,1038,899,-1,899,1038,1044,900,-1,900,1044,911,877,-1,1153,1157,1079,-1,236,237,1188,304,303,-1,1188,1181,541,-1,1181,677,541,-1,293,292,395,-1],
          coord=Coordinate(point=[(2.29765,-0.020555,1.61927),(2.08608,-0.020555,1.48455),(2.09966,-0.282914,1.43337),(2.3174,-0.251277,1.58018),(2.41478,-0.020555,1.80816),(2.437,-0.210148,1.78177),(2.49024,-0.020556,2.02205),(2.51493,-0.16902,2.00744),(2.57682,-0.020556,2.23177),(2.60768,-0.137383,2.22647),(2.7273,-0.020556,2.40818),(2.77174,-0.124729,2.40818),(2.13361,-0.440329,1.30539),(2.36679,-0.38971,1.48244),(2.49256,-0.323904,1.7158),(2.57666,-0.258099,1.97092),(2.68486,-0.20748,2.21323),(2.88286,-0.187232,2.40818),(2.17774,-0.492801,1.13904),(2.43098,-0.435854,1.35536),(2.56478,-0.361823,1.63003),(2.65693,-0.287792,1.92344),(2.78517,-0.230845,2.19601),(3.0273,-0.208066,2.40818),(2.22188,-0.440329,0.972698),(2.49518,-0.38971,1.2283),(2.63702,-0.323905,1.54427),(2.73718,-0.258099,1.87596),(2.88548,-0.20748,2.17879),(3.17176,-0.187233,2.40818),(2.25583,-0.282914,0.844738),(2.54456,-0.251278,1.13057),(2.69258,-0.210149,1.4783),(2.7989,-0.169021,1.83944),(2.96264,-0.137384,2.16554),(3.28288,-0.12473,2.40818),(2.26941,-0.020555,0.793553),(2.56432,-0.020556,1.09147),(2.7148,-0.020556,1.45191),(2.8236,-0.020557,1.82483),(2.9935,-0.020557,2.16024),(3.32732,-0.020558,2.40818),(2.25583,0.241804,0.844738),(2.54456,0.210166,1.13057),(2.69258,0.169037,1.4783),(2.7989,0.127908,1.83944),(2.96264,0.09627,2.16554),(3.28288,0.083615,2.40818),(2.22188,0.399219,0.972698),(2.49518,0.348599,1.2283),(2.63702,0.282793,1.54427),(2.73718,0.216987,1.87596),(2.88548,0.166367,2.17879),(3.17174,0.146118,2.40818),(2.17774,0.451691,1.13904),(2.43098,0.394744,1.35536),(2.56478,0.320712,1.63003),(2.65693,0.24668,1.92344),(2.78517,0.189732,2.19601),(3.0273,0.166952,2.40818),(2.13361,0.399219,1.30539),(2.36679,0.3486,1.48244),(2.49256,0.282793,1.7158),(2.57666,0.216987,1.97092),(2.68486,0.166368,2.21323),(2.88286,0.146119,2.40818),(2.09966,0.241804,1.43337),(2.3174,0.210166,1.58018),(2.437,0.169037,1.78177),(2.51493,0.127909,2.00744),(2.60768,0.096271,2.22647),(2.77174,0.083616,2.40818),(2.77637,-0.020556,2.43943),(2.82371,-0.121594,2.44011),(2.81989,-0.020557,2.45818),(2.86708,-0.113539,2.45941),(2.8523,-0.020557,2.46443),(2.89698,-0.102592,2.46599),(2.86804,-0.020557,2.45818),(2.90851,-0.090776,2.45972),(2.86156,-0.020557,2.43943),(2.89679,-0.080118,2.44049),(2.8273,-0.020557,2.40818),(2.85693,-0.072642,2.40818),(2.94204,-0.182139,2.44179),(2.98505,-0.168712,2.4625),(3.00867,-0.149731,2.4699),(3.00967,-0.127969,2.46358),(2.98486,-0.106209,2.44314),(2.931,-0.087227,2.40818),(3.09588,-0.20225,2.44399),(3.13841,-0.186538,2.46651),(3.15386,-0.163533,2.47498),(3.14119,-0.135841,2.4686),(3.09935,-0.106065,2.44659),(3.0273,-0.07681,2.40818),(3.24973,-0.181986,2.44618),(3.29179,-0.167479,2.47053),(3.29908,-0.145564,2.48005),(3.27272,-0.118093,2.47361),(3.21386,-0.086919,2.45004),(3.1236,-0.053892,2.40818),(3.36807,-0.121402,2.44787),(3.40976,-0.111997,2.47361),(3.41077,-0.097385,2.48396),(3.37389,-0.078431,2.47747),(3.30193,-0.056006,2.45269),(3.19769,-0.030975,2.40818),(3.4154,-0.020558,2.44854),(3.45695,-0.020558,2.47485),(3.45545,-0.020558,2.48552),(3.41436,-0.020558,2.47901),(3.33716,-0.020558,2.45375),(3.22732,-0.020558,2.40818),(3.36807,0.080527,2.44787),(3.40976,0.072811,2.47361),(3.41077,0.062779,2.48396),(3.37389,0.052749,2.47747),(3.30193,0.045032,2.45269),(3.19769,0.041946,2.40818),(3.24973,0.141178,2.44618),(3.29179,0.128833,2.47053),(3.29908,0.112782,2.48005),(3.27272,0.096732,2.47361),(3.21386,0.084386,2.45004),(3.1236,0.079448,2.40818),(3.09588,0.161396,2.44399),(3.13841,0.147507,2.46651),(3.15386,0.12945,2.47498),(3.14119,0.111394,2.4686),(3.09935,0.097505,2.44659),(3.0273,0.091948,2.40818),(2.94204,0.14118,2.44179),(2.98505,0.128833,2.4625),(3.00867,0.112783,2.4699),(3.00967,0.096733,2.46358),(2.98486,0.084386,2.44314),(2.931,0.079448,2.40818),(2.82371,0.080529,2.44011),(2.86708,0.072812,2.45941),(2.89698,0.06278,2.46599),(2.90851,0.05275,2.45972),(2.89679,0.045033,2.44049),(2.85693,0.041947,2.40818),(1.89553,-0.290398,1.398575),(1.89954,-0.315755,1.3763),(1.908988,-0.451177,1.255584),(1.93165,-0.485733,1.13497),(1.934577,-0.503458,1.073493),(1.947755,-0.290894,0.741731),(1.972072,-0.033261,0.695299),(1.93399,0.447403,1.13497),(1.910815,0.410988,1.25892),(1.911268,-0.015285,1.460255),(1.956823,0.409601,0.894072),(1.89836,0.25745,1.394873),(-2.15237,-0.010736,2.02949),(-1.8806,-0.010737,2.03678),(-1.8831,-0.135741,2.05337),(-2.16252,-0.135741,2.04554),(-2.36857,-0.010736,2.00969),(-2.38431,-0.135741,2.02428),(-2.52644,-0.010736,1.97115),(-2.54592,-0.13574,1.98288),(-2.6232,-0.010736,1.90761),(-2.64478,-0.13574,1.91463),(-2.65608,-0.010736,1.81281),(-2.6783,-0.13574,1.81281),(-1.88936,-0.210744,2.09484),(-2.18789,-0.210743,2.08566),(-2.42366,-0.210742,2.06074),(-2.59462,-0.210742,2.0122),(-2.69871,-0.210742,1.93219),(-2.73386,-0.210743,1.81281),(-1.8975,-0.235745,2.14876),(-2.22088,-0.235744,2.13782),(-2.47482,-0.235744,2.10813),(-2.65793,-0.235744,2.05032),(-2.76881,-0.235744,1.95501),(-2.80608,-0.235744,1.81281),(-1.90563,-0.210743,2.20267),(-2.25388,-0.210743,2.18998),(-2.52598,-0.210742,2.15553),(-2.72124,-0.210742,2.08844),(-2.83892,-0.210742,1.97783),(-2.8783,-0.210743,1.81281),(-1.91189,-0.135741,2.24415),(-2.27925,-0.135741,2.2301),(-2.56533,-0.13574,2.19199),(-2.76993,-0.13574,2.11776),(-2.89285,-0.13574,1.99538),(-2.93387,-0.13574,1.81281),(-1.91439,-0.010737,2.26074),(-2.2894,-0.010736,2.24615),(-2.58107,-0.010736,2.20657),(-2.78941,-0.010735,2.12949),(-2.91442,-0.010735,2.0024),(-2.95609,-0.010735,1.81281),(-1.91189,0.114268,2.24415),(-2.27925,0.114269,2.2301),(-2.56533,0.114269,2.19199),(-2.76993,0.114269,2.11776),(-2.89285,0.114269,1.99538),(-2.93387,0.114268,1.81281),(-1.90563,0.18927,2.20267),(-2.25388,0.18927,2.18998),(-2.52598,0.189271,2.15553),(-2.72124,0.189271,2.08844),(-2.83892,0.189271,1.97783),(-2.87831,0.189271,1.81281),(-1.8975,0.214271,2.14876),(-2.22088,0.214271,2.13782),(-2.47482,0.214271,2.10813),(-2.65793,0.214272,2.05032),(-2.76881,0.214272,1.95501),(-2.80608,0.214272,1.81281),(-1.88936,0.18927,2.09484),(-2.18789,0.18927,2.08566),(-2.42366,0.189271,2.06074),(-2.59462,0.189271,2.0122),(-2.69871,0.189271,1.93219),(-2.73386,0.189271,1.81281),(-1.8831,0.114267,2.05337),(-2.16252,0.114267,2.04554),(-2.38431,0.114268,2.02428),(-2.54592,0.114268,1.98288),(-2.64478,0.114268,1.91463),(-2.6783,0.114268,1.81281),(-2.63894,-0.010736,1.68364),(-2.66026,-0.13574,1.67679),(-2.5857,-0.010736,1.52947),(-2.60436,-0.13574,1.51815),(-2.49357,-0.010737,1.3628),(-2.50792,-0.13574,1.34856),(-2.35977,-0.010737,1.19613),(-2.36828,-0.135742,1.17967),(-2.18153,-0.010737,1.04197),(-2.18275,-0.135742,1.02313),(-2.71355,-0.210743,1.65965),(-2.65099,-0.210743,1.48986),(-2.5438,-0.210743,1.31297),(-2.38954,-0.210744,1.13852),(-2.18579,-0.210745,0.976023),(-2.78282,-0.235744,1.63738),(-2.71164,-0.235744,1.45308),(-2.59044,-0.235744,1.26671),(-2.41718,-0.235745,1.08502),(-2.18975,-0.235745,0.914792),(-2.85208,-0.210743,1.6151),(-2.77227,-0.210743,1.4163),(-2.63709,-0.210743,1.22044),(-2.44482,-0.210743,1.03152),(-2.19371,-0.210745,0.853559),(-2.90538,-0.13574,1.59796),(-2.81891,-0.13574,1.38801),(-2.67297,-0.135741,1.18485),(-2.46608,-0.135742,0.990368),(-2.19675,-0.135742,0.806459),(-2.92669,-0.010736,1.59111),(-2.83756,-0.010736,1.37669),(-2.68733,-0.010736,1.17061),(-2.47459,-0.010737,0.973907),(-2.19797,-0.010738,0.787618),(-2.90538,0.114268,1.59796),(-2.81891,0.114268,1.38801),(-2.67298,0.114268,1.18485),(-2.46608,0.114268,0.990369),(-2.19675,0.114266,0.806459),(-2.85208,0.189271,1.6151),(-2.77227,0.189271,1.4163),(-2.63709,0.18927,1.22044),(-2.44482,0.18927,1.03152),(-2.19371,0.189269,0.85356),(-2.78282,0.214272,1.63738),(-2.71164,0.214272,1.45308),(-2.59044,0.214271,1.26671),(-2.41718,0.21427,1.08502),(-2.18975,0.21427,0.914792),(-2.71355,0.189271,1.65965),(-2.651,0.189271,1.48986),(-2.5438,0.189271,1.31297),(-2.38954,0.18927,1.13852),(-2.18579,0.189269,0.976023),(-2.66026,0.114268,1.67679),(-2.60436,0.114268,1.51815),(-2.50792,0.114268,1.34856),(-2.36828,0.114268,1.17967),(-2.18275,0.114266,1.02313),(-1.65716,-0.010737,2.03749),(-1.63327,-0.13574,2.05422),(-1.60471,-0.210735,2.09589),(-1.579065,-0.233867,2.14599),(-1.5546,-0.210753,2.20418),(-1.54477,-0.135748,2.2458),(-1.55336,-0.010506,2.262355),(-1.54489,0.114267,2.24579),(-1.55474,0.189265,2.20417),(-1.579195,0.212398,2.145985),(-1.60484,0.18927,2.09588),(-1.63341,0.114278,2.05418),(-1.6572,-0.010272,2.03754),(-1.912645,-0.134656,0.659653),(-1.949962,0.189417,0.846571),(-1.98417,-0.010585,0.930191),(-1.98423,-0.010504,0.929557),(1.39499,-0.010276,2.45878),(1.41362,-0.010276,2.40409),(1.36436,-0.386212,2.40409),(1.34638,-0.381208,2.45878),(1.39788,-0.010276,2.49159),(1.34917,-0.381985,2.49159),(1.41674,-0.010276,2.50253),(1.36738,-0.387051,2.50253),(1.44603,-0.010276,2.49159),(1.39563,-0.394914,2.49159),(1.48017,-0.010276,2.45878),(1.42857,-0.404082,2.45878),(1.51362,-0.010276,2.40409),(1.46084,-0.413065,2.40409),(1.22488,-0.721701,2.40409),(1.20876,-0.712232,2.45878),(1.21126,-0.713703,2.49159),(1.22758,-0.723289,2.50253),(1.25292,-0.738169,2.49159),(1.28246,-0.75552,2.45878),(1.3114,-0.772517,2.40409),(1.00762,-1.0043,2.40409),(0.994385,-0.991071,2.45878),(0.996439,-0.993125,2.49159),(1.00983,-1.00652,2.50253),(1.03063,-1.02731,2.49159),(1.05487,-1.05155,2.45878),(1.07862,-1.0753,2.40409),(0.725017,-1.22157,2.40409),(0.715548,-1.20545,2.45878),(0.717019,-1.20795,2.49159),(0.726605,-1.22427,2.50253),(0.741485,-1.24961,2.49159),(0.758836,-1.27915,2.45878),(0.775833,-1.30809,2.40409),(0.38953,-1.36105,2.40409),(0.384526,-1.34307,2.45878),(0.385303,-1.34586,2.49159),(0.390369,-1.36407,2.50253),(0.398232,-1.39232,2.49159),(0.4074,-1.42526,2.45878),(0.416382,-1.45753,2.40409),(0.013597,-1.41031,2.40409),(0.013597,-1.39168,2.45878),(0.013597,-1.39457,2.49159),(0.013597,-1.41343,2.50253),(0.013597,-1.44272,2.49159),(0.013597,-1.47686,2.45878),(0.013597,-1.51031,2.40409),(-0.362337,-1.36105,2.40409),(-0.357332,-1.34307,2.45878),(-0.35811,-1.34586,2.49159),(-0.363176,-1.36407,2.50253),(-0.371039,-1.39232,2.49159),(-0.380207,-1.42526,2.45878),(-0.389189,-1.45753,2.40409),(-0.697824,-1.22156,2.40409),(-0.688355,-1.20544,2.45878),(-0.689826,-1.20794,2.49159),(-0.699412,-1.22426,2.50253),(-0.714292,-1.2496,2.49159),(-0.731643,-1.27915,2.45878),(-0.74864,-1.30809,2.40409),(-0.980423,-1.0043,2.40409),(-0.967193,-0.991068,2.45878),(-0.969247,-0.993122,2.49159),(-0.982642,-1.00652,2.50253),(-1.00343,-1.02731,2.49159),(-1.02767,-1.05155,2.45878),(-1.05142,-1.0753,2.40409),(-1.19769,-0.721698,2.40409),(-1.18157,-0.712229,2.45878),(-1.18407,-0.7137,2.49159),(-1.20039,-0.723286,2.50253),(-1.22573,-0.738166,2.49159),(-1.25527,-0.755517,2.45878),(-1.28421,-0.772514,2.40409),(-1.33717,-0.386208,2.40409),(-1.31919,-0.381204,2.45878),(-1.32198,-0.381981,2.49159),(-1.34019,-0.387047,2.50253),(-1.36844,-0.39491,2.49159),(-1.40138,-0.404079,2.45878),(-1.43365,-0.413061,2.40409),(-1.38643,-0.010273,2.40409),(-1.3678,-0.010273,2.45878),(-1.37069,-0.010273,2.49159),(-1.38955,-0.010273,2.50253),(-1.41884,-0.010273,2.49159),(-1.45298,-0.010273,2.45878),(-1.48643,-0.010273,2.40409),(-1.33717,0.365663,2.40409),(-1.31919,0.360659,2.45878),(-1.32198,0.361436,2.49159),(-1.34019,0.366502,2.50253),(-1.36844,0.374365,2.49159),(-1.40138,0.383533,2.45878),(-1.43365,0.392516,2.40409),(-1.19769,0.701152,2.40409),(-1.18157,0.691683,2.45878),(-1.18407,0.693154,2.49159),(-1.20039,0.70274,2.50253),(-1.22573,0.71762,2.49159),(-1.25527,0.734971,2.45878),(-1.28421,0.751968,2.40409),(-0.980425,0.983752,2.40409),(-0.967195,0.970522,2.45878),(-0.969249,0.972576,2.49159),(-0.982644,0.985971,2.50253),(-1.00344,1.00676,2.49159),(-1.02768,1.031,2.45878),(-1.05143,1.05475,2.40409),(-0.697827,1.20102,2.40409),(-0.688358,1.1849,2.45878),(-0.689829,1.1874,2.49159),(-0.699415,1.20372,2.50253),(-0.714296,1.22906,2.49159),(-0.731646,1.2586,2.45878),(-0.748643,1.28754,2.40409),(-0.36234,1.3405,2.40409),(-0.357336,1.32252,2.45878),(-0.358113,1.32531,2.49159),(-0.363179,1.34352,2.50253),(-0.371042,1.37177,2.49159),(-0.38021,1.40471,2.45878),(-0.389193,1.43698,2.40409),(0.013593,1.38976,2.40409),(0.013593,1.37113,2.45878),(0.013593,1.37402,2.49159),(0.013593,1.39288,2.50253),(0.013593,1.42217,2.49159),(0.013593,1.45631,2.45878),(0.013593,1.48976,2.40409),(0.389526,1.3405,2.40409),(0.384522,1.32252,2.45878),(0.385299,1.32531,2.49159),(0.390365,1.34352,2.50253),(0.398228,1.37177,2.49159),(0.407397,1.40471,2.45878),(0.416379,1.43698,2.40409),(0.725014,1.20102,2.40409),(0.715545,1.18489,2.45878),(0.717016,1.18739,2.49159),(0.726602,1.20372,2.50253),(0.741482,1.22906,2.49159),(0.758832,1.2586,2.45878),(0.77583,1.28754,2.40409),(1.00761,0.983749,2.40409),(0.994382,0.970519,2.45878),(0.996436,0.972573,2.49159),(1.00983,0.985968,2.50253),(1.03062,1.00676,2.49159),(1.05486,1.031,2.45878),(1.07861,1.05475,2.40409),(1.22488,0.701149,2.40409),(1.20876,0.69168,2.45878),(1.21126,0.693151,2.49159),(1.22758,0.702737,2.50253),(1.25292,0.717617,2.49159),(1.28246,0.734968,2.45878),(1.3114,0.751965,2.40409),(1.36436,0.365659,2.40409),(1.34638,0.360655,2.45878),(1.34917,0.361432,2.49159),(1.36738,0.366498,2.50253),(1.39563,0.374361,2.49159),(1.42857,0.38353,2.45878),(1.46084,0.392512,2.40409),(1.63747,-0.010277,2.14193),(1.58034,-0.44632,2.14193),(1.75437,-0.010277,1.88186),(1.69312,-0.477709,1.88186),(1.85738,-0.010277,1.62595),(1.79251,-0.50537,1.62596),(1.41854,-0.83545,2.14193),(1.51969,-0.894853,1.88186),(1.60882,-0.947198,1.62596),(1.87179,-0.527437,1.3763),(1.67991,-0.988957,1.3763),(1.92428,-0.542044,1.13497),(1.72698,-1.0166,1.13497),(1.94326,-0.547328,0.90407),(1.744,-1.0266,0.90407),(1.16655,-1.16324,2.14193),(1.24955,-1.24624,1.88186),(1.32268,-1.31937,1.62595),(1.38103,-1.37772,1.3763),(1.41965,-1.41634,1.13497),(1.43363,-1.43031,0.90407),(0.838766,-1.41523,2.14194),(0.898168,-1.51637,1.88186),(0.950514,-1.60551,1.62596),(0.992273,-1.6766,1.3763),(1.01992,-1.72367,1.13497),(1.02992,-1.74069,0.904071),(0.449638,-1.57702,2.14194),(0.481027,-1.68981,1.88186),(0.508688,-1.7892,1.62595),(0.530755,-1.86848,1.3763),(0.545363,-1.92097,1.13497),(0.550646,-1.93995,0.904071),(0.013597,-1.63416,2.14194),(0.013598,-1.75106,1.88186),(0.013598,-1.85407,1.62595),(0.013598,-1.93625,1.3763),(0.013599,-1.99064,1.13497),(0.013599,-2.01033,0.904072),(-0.422443,-1.57702,2.14194),(-0.453832,-1.68981,1.88186),(-0.481492,-1.7892,1.62596),(-0.503559,-1.86848,1.3763),(-0.518166,-1.92097,1.13497),(-0.523448,-1.93995,0.904072),(-0.811572,-1.41523,2.14194),(-0.870974,-1.51637,1.88186),(-0.923318,-1.6055,1.62596),(-0.965077,-1.6766,1.3763),(-0.992721,-1.72367,1.13498),(-1.00272,-1.74069,0.904073),(-1.13936,-1.16323,2.14194),(-1.22236,-1.24623,1.88186),(-1.29549,-1.31937,1.62595),(-1.35384,-1.37772,1.3763),(-1.39246,-1.41634,1.13498),(-1.40643,-1.43031,0.904073),(-1.39135,-0.835447,2.14194),(-1.49249,-0.894849,1.88186),(-1.58162,-0.947194,1.62596),(-1.65271,-0.988953,1.3763),(-1.69979,-1.0166,1.13498),(-1.71681,-1.0266,0.904073),(-1.55314,-0.446316,2.14194),(-1.66593,-0.477705,1.88186),(-1.76532,-0.505366,1.62595),(-1.8446,-0.527432,1.3763),(-1.89709,-0.54204,1.13498),(-1.91607,-0.547323,0.904074),(-1.72718,-0.010272,1.88186),(-1.83019,-0.010272,1.62595),(-1.91237,-0.010272,1.3763),(-1.96676,-0.010272,1.13498),(-1.66593,0.45716,1.88186),(-1.76532,0.484821,1.62596),(-1.8446,0.506888,1.3763),(-1.89709,0.521495,1.13498),(-1.55315,0.425771,2.14194),(-1.39135,0.814901,2.14194),(-1.49249,0.874304,1.88186),(-1.58163,0.926649,1.62596),(-1.65272,0.968408,1.3763),(-1.69979,0.996053,1.13498),(-1.91607,0.526778,0.904074),(-1.71681,1.00605,0.904073),(-1.13936,1.14269,2.14194),(-1.22236,1.22569,1.88186),(-1.29549,1.29882,1.62595),(-1.35384,1.35717,1.3763),(-1.39246,1.39579,1.13498),(-1.40643,1.40976,0.904073),(-0.811575,1.39468,2.14194),(-0.870977,1.49582,1.88186),(-0.923322,1.58496,1.62596),(-0.965081,1.65605,1.3763),(-0.992725,1.70312,1.13498),(-1.00273,1.72014,0.904073),(-0.422447,1.55648,2.14194),(-0.453837,1.66926,1.88186),(-0.481497,1.76865,1.62595),(-0.503563,1.84793,1.3763),(-0.51817,1.90042,1.13497),(-0.523453,1.9194,0.904072),(0.013593,1.61361,2.14194),(0.013593,1.73051,1.88186),(0.013593,1.83352,1.62595),(0.013593,1.9157,1.3763),(0.013594,1.9701,1.13497),(0.013594,1.98978,0.904072),(0.449633,1.55647,2.14194),(0.481023,1.66926,1.88186),(0.508684,1.76865,1.62596),(0.53075,1.84793,1.3763),(0.545358,1.90042,1.13497),(0.550641,1.9194,0.904071),(0.838762,1.39468,2.14194),(0.898164,1.49582,1.88186),(0.950509,1.58495,1.62596),(0.992268,1.65605,1.3763),(1.01991,1.70312,1.13497),(1.02991,1.72014,0.904071),(1.16655,1.14268,2.14193),(1.24955,1.22569,1.88186),(1.32268,1.29882,1.62595),(1.38103,1.35717,1.3763),(1.41965,1.39579,1.13497),(1.43362,1.40976,0.90407),(1.41854,0.814898,2.14193),(1.51968,0.8743,1.88186),(1.60881,0.926645,1.62596),(1.67991,0.968404,1.3763),(1.72698,0.996049,1.13497),(1.744,1.00605,0.90407),(1.58033,0.425766,2.14193),(1.69312,0.457156,1.88186),(1.79251,0.484817,1.62595),(1.87179,0.506883,1.3763),(1.92428,0.52149,1.13497),(1.94326,0.526774,0.90407),(1.76363,-0.010277,0.388439),(1.884,-0.010277,0.526288),(1.81819,-0.512519,0.526288),(1.70206,-0.480196,0.388439),(1.64326,-0.010277,0.281841),(1.58592,-0.447874,0.281841),(1.55067,-0.010277,0.204409),(1.49659,-0.42301,0.204409),(1.51363,-0.010277,0.154062),(1.46085,-0.413065,0.154062),(1.90753,-0.537382,0.697471),(1.71196,-1.00778,0.697471),(1.63185,-0.960726,0.526288),(1.5277,-0.899558,0.388439),(1.42355,-0.83839,0.281841),(1.34344,-0.791339,0.204409),(1.3114,-0.772517,0.154062),(1.40732,-1.40401,0.697471),(1.34158,-1.33827,0.526288),(1.25612,-1.25281,0.38844),(1.17066,-1.16735,0.281841),(1.10492,-1.1016,0.20441),(1.07862,-1.0753,0.154062),(1.01109,-1.70865,0.697471),(0.964042,-1.62854,0.526288),(0.902875,-1.52438,0.38844),(0.841708,-1.42024,0.281842),(0.794657,-1.34013,0.20441),(0.775835,-1.30809,0.154062),(0.540701,-1.90422,0.697472),(0.515838,-1.81488,0.526289),(0.483515,-1.69875,0.38844),(0.451193,-1.5826,0.281842),(0.42633,-1.49327,0.20441),(0.416385,-1.45753,0.154063),(0.013599,-1.97328,0.697472),(0.013599,-1.88069,0.526289),(0.013599,-1.76032,0.388441),(0.013599,-1.63995,0.281843),(0.013599,-1.54735,0.204411),(0.013599,-1.51031,0.154063),(-0.513503,-1.90422,0.697473),(-0.48864,-1.81488,0.52629),(-0.456317,-1.69875,0.388441),(-0.423995,-1.5826,0.281843),(-0.399132,-1.49327,0.204411),(-0.389187,-1.45753,0.154063),(-0.983896,-1.70865,0.697473),(-0.936844,-1.62853,0.52629),(-0.875677,-1.52438,0.388442),(-0.81451,-1.42024,0.281843),(-0.767459,-1.34013,0.204411),(-0.748638,-1.30809,0.154064),(-1.38013,-1.40401,0.697474),(-1.31439,-1.33827,0.526291),(-1.22893,-1.2528,0.388442),(-1.14346,-1.16734,0.281844),(-1.07772,-1.1016,0.204412),(-1.05142,-1.0753,0.154064),(-1.68476,-1.00777,0.697474),(-1.60465,-0.960722,0.526291),(-1.5005,-0.899554,0.388442),(-1.39636,-0.838387,0.281844),(-1.31625,-0.791336,0.204412),(-1.28421,-0.772514,0.154064),(-1.88034,-0.537377,0.697474),(-1.791,-0.512514,0.526291),(-1.67486,-0.480191,0.388442),(-1.55872,-0.44787,0.281844),(-1.46939,-0.423006,0.204412),(-1.43365,-0.413061,0.154065),(-1.85681,-0.010272,0.526291),(-1.73644,-0.010272,0.388442),(-1.61606,-0.010273,0.281844),(-1.52347,-0.010273,0.204412),(-1.48643,-0.010273,0.154065),(-1.791,0.491969,0.526291),(-1.67487,0.459646,0.388442),(-1.55872,0.427325,0.281844),(-1.46939,0.402461,0.204412),(-1.43365,0.392515,0.154065),(-1.88034,0.516833,0.697474),(-1.68477,0.987229,0.697474),(-1.60466,0.940177,0.526291),(-1.5005,0.879009,0.388442),(-1.39636,0.817841,0.281844),(-1.31625,0.77079,0.204412),(-1.28421,0.751968,0.154064),(-1.38013,1.38346,0.697474),(-1.31439,1.31772,0.526291),(-1.22893,1.23226,0.388442),(-1.14347,1.1468,0.281844),(-1.07773,1.08105,0.204412),(-1.05142,1.05475,0.154064),(-0.983901,1.6881,0.697473),(-0.936848,1.60799,0.52629),(-0.875681,1.50383,0.388442),(-0.814514,1.39969,0.281843),(-0.767463,1.31958,0.204412),(-0.748641,1.28754,0.154064),(-0.513508,1.88367,0.697473),(-0.488644,1.79433,0.52629),(-0.456321,1.6782,0.388441),(-0.423999,1.56206,0.281843),(-0.399136,1.47272,0.204411),(-0.38919,1.43698,0.154064),(0.013594,1.95274,0.697472),(0.013594,1.86014,0.526289),(0.013595,1.73977,0.388441),(0.013595,1.6194,0.281843),(0.013595,1.5268,0.204411),(0.013595,1.48976,0.154063),(0.540696,1.88367,0.697472),(0.515833,1.79433,0.526289),(0.483511,1.6782,0.38844),(0.451189,1.56205,0.281842),(0.426326,1.47272,0.20441),(0.416381,1.43698,0.154063),(1.01109,1.6881,0.697471),(0.964038,1.60799,0.526289),(0.902871,1.50383,0.38844),(0.841704,1.39969,0.281842),(0.794653,1.31958,0.20441),(0.775832,1.28754,0.154062),(1.40732,1.38346,0.697471),(1.34158,1.31772,0.526288),(1.25612,1.23226,0.38844),(1.17066,1.14679,0.281842),(1.10492,1.08105,0.20441),(1.07862,1.05475,0.154062),(1.71196,0.987224,0.697471),(1.63185,0.940172,0.526288),(1.52769,0.879005,0.388439),(1.42355,0.817838,0.281841),(1.34344,0.770786,0.20441),(1.3114,0.751965,0.154062),(1.90753,0.516828,0.697471),(1.81819,0.491965,0.526288),(1.70206,0.459642,0.388439),(1.58592,0.42732,0.281841),(1.49658,0.402457,0.204409),(1.46084,0.392512,0.154062),(0.619512,-0.010275,0.009964),(0.013597,-0.010275,0.004061),(0.598192,0.152425,0.009964),(1.03584,-0.010276,0.026283),(0.999871,0.264217,0.026283),(1.29799,-0.010276,0.050936),(1.2528,0.334611,0.050936),(1.4414,-0.010276,0.081839),(1.39116,0.373118,0.081839),(1.50148,-0.010277,0.116908),(1.44912,0.389249,0.116908),(0.537825,0.297621,0.009964),(0.898025,0.509177,0.026283),(1.12484,0.642393,0.050936),(1.24891,0.715265,0.081839),(1.30088,0.74579,0.116909),(0.443796,0.419927,0.009964),(0.739388,0.715521,0.026283),(0.925519,0.901653,0.050936),(1.02734,1.00347,0.081839),(1.06999,1.04612,0.116909),(0.32149,0.513956,0.009964),(0.533046,0.874159,0.026283),(0.666261,1.10097,0.050936),(0.739132,1.22505,0.08184),(0.769657,1.27702,0.116909),(0.176296,0.574324,0.009964),(0.288087,0.976005,0.026284),(0.35848,1.22894,0.050937),(0.396988,1.3673,0.08184),(0.413118,1.42526,0.116909),(0.013596,0.595644,0.009965),(0.013596,1.01197,0.026284),(0.013596,1.27413,0.050937),(0.013595,1.41754,0.08184),(0.013595,1.47761,0.11691),(-0.149103,0.574324,0.009965),(-0.260895,0.976006,0.026284),(-0.331289,1.22894,0.050937),(-0.369797,1.3673,0.081841),(-0.385927,1.42526,0.11691),(-0.294297,0.513957,0.009965),(-0.505854,0.87416,0.026284),(-0.63907,1.10097,0.050938),(-0.711941,1.22505,0.081841),(-0.742466,1.27702,0.11691),(-0.416603,0.419928,0.009965),(-0.712196,0.715523,0.026284),(-0.898327,0.901656,0.050938),(-1.00014,1.00347,0.081841),(-1.04279,1.04612,0.116911),(-0.510631,0.297622,0.009965),(-0.870832,0.50918,0.026284),(-1.09764,0.642396,0.050938),(-1.22172,0.715268,0.081841),(-1.27369,0.745793,0.116911),(-0.570998,0.152426,0.009965),(-0.972677,0.26422,0.026285),(-1.22561,0.334614,0.050938),(-1.36397,0.373122,0.081842),(-1.42193,0.389252,0.116911),(-0.592317,-0.010274,0.009965),(-1.00864,-0.010273,0.026285),(-1.2708,-0.010273,0.050938),(-1.41421,-0.010273,0.081842),(-1.47428,-0.010273,0.116911),(-0.570998,-0.172974,0.009965),(-0.972676,-0.284766,0.026285),(-1.22561,-0.35516,0.050938),(-1.36397,-0.393667,0.081842),(-1.42193,-0.409798,0.116911),(-0.51063,-0.31817,0.009965),(-0.870831,-0.529727,0.026284),(-1.09764,-0.662943,0.050938),(-1.22172,-0.735814,0.081841),(-1.27369,-0.766339,0.116911),(-0.416601,-0.440476,0.009965),(-0.712194,-0.73607,0.026284),(-0.898325,-0.922202,0.050938),(-1.00014,-1.02402,0.081841),(-1.04279,-1.06667,0.116911),(-0.294296,-0.534505,0.009965),(-0.505852,-0.894708,0.026284),(-0.639067,-1.12152,0.050938),(-0.711938,-1.24559,0.081841),(-0.742463,-1.29757,0.11691),(-0.149101,-0.594873,0.009965),(-0.260893,-0.996554,0.026284),(-0.331286,-1.24949,0.050937),(-0.369793,-1.38785,0.081841),(-0.385924,-1.44581,0.11691),(0.013598,-0.616193,0.009964),(0.013598,-1.03252,0.026284),(0.013599,-1.29468,0.050937),(0.013599,-1.43809,0.08184),(0.013599,-1.49816,0.11691),(0.176297,-0.594874,0.009964),(0.28809,-0.996555,0.026283),(0.358483,-1.24949,0.050937),(0.396991,-1.38785,0.08184),(0.413122,-1.44581,0.116909),(0.321492,-0.534506,0.009964),(0.533048,-0.89471,0.026283),(0.666264,-1.12152,0.050936),(0.739136,-1.2456,0.08184),(0.76966,-1.29757,0.116909),(0.443797,-0.440477,0.009964),(0.73939,-0.736072,0.026283),(0.925522,-0.922205,0.050936),(1.02734,-1.02402,0.081839),(1.06999,-1.06667,0.116909),(0.537826,-0.318171,0.009964),(0.898027,-0.529729,0.026283),(1.12484,-0.662945,0.050936),(1.24891,-0.735817,0.081839),(1.30088,-0.766342,0.116908),(0.598193,-0.172975,0.009964),(0.999871,-0.284769,0.026283),(1.2528,-0.355163,0.050936),(1.39116,-0.393671,0.081839),(1.44912,-0.409802,0.116908),(-1.91334,0.11445,0.66102),(1.954391,-0.453258,0.897392),(1.25754,-0.003273,2.40409),(1.21402,-0.335372,2.40409),(1.09081,-0.631744,2.40409),(0.898885,-0.88139,2.40409),(0.649246,-1.07332,2.40409),(0.352883,-1.19653,2.40409),(0.020793,-1.24006,2.40409),(-0.311297,-1.19653,2.40409),(-0.607661,-1.07332,2.40409),(-0.8573,-0.881383,2.40409),(-1.04922,-0.631735,2.40409),(-1.17244,-0.335363,2.40409),(-1.21596,-0.003264,2.40409),(-1.17244,0.328835,2.40409),(-1.04923,0.625206,2.40409),(-0.857304,0.87485,2.40409),(-0.607665,1.06678,2.40409),(-0.311304,1.19,2.40409),(0.020784,1.23352,2.40409),(0.352873,1.19,2.40409),(0.649235,1.06677,2.40409),(0.898874,0.874844,2.40409),(1.0908,0.625197,2.40409),(1.21402,0.328826,2.40409),(0.371746,-0.00327,2.58031),(0.220806,-0.00327,2.64421),(0.213768,-0.05698,2.64421),(0.359398,-0.097511,2.58031),(0.594914,-0.003271,2.53309),(0.574714,-0.157439,2.53309),(0.845863,-0.003272,2.4942),(0.816833,-0.224826,2.4942),(1.08015,-0.003272,2.45531),(1.04287,-0.287737,2.45531),(1.25331,-0.003273,2.40809),(1.20994,-0.334236,2.40809),(0.193841,-0.104911,2.64421),(0.324433,-0.181613,2.58031),(0.517515,-0.295021,2.53309),(0.734632,-0.422543,2.4942),(0.937328,-0.541597,2.45531),(1.08715,-0.629594,2.40809),(0.162802,-0.145286,2.64421),(0.269969,-0.252456,2.58031),(0.42842,-0.410912,2.53309),(0.606594,-0.589091,2.4942),(0.772933,-0.755435,2.45531),(0.89588,-0.878386,2.40809),(0.122428,-0.176327,2.64421),(0.199127,-0.306921,2.58031),(0.312532,-0.500009,2.53309),(0.440051,-0.717133,2.4942),(0.559101,-0.919835,2.45531),(0.647095,-1.06966,2.40809),(0.074498,-0.196255,2.64421),(0.115028,-0.341888,2.58031),(0.174954,-0.557211,2.53309),(0.242339,-0.799337,2.4942),(0.305249,-1.02538,2.45531),(0.351747,-1.19245,2.40809),(0.020789,-0.203293,2.64421),(0.02079,-0.354236,2.58031),(0.020791,-0.577411,2.53309),(0.020792,-0.828367,2.4942),(0.020793,-1.06265,2.45531),(0.020793,-1.23583,2.40809),(-0.03292,-0.196254,2.64421),(-0.073449,-0.341888,2.58031),(-0.133373,-0.557209,2.53309),(-0.200756,-0.799335,2.4942),(-0.263664,-1.02538,2.45531),(-0.310161,-1.19245,2.40809),(-0.08085,-0.176326,2.64421),(-0.157548,-0.30692,2.58031),(-0.270951,-0.500007,2.53309),(-0.398468,-0.71713,2.4942),(-0.517517,-0.919831,2.45531),(-0.60551,-1.06965,2.40809),(-0.121224,-0.145285,2.64421),(-0.22839,-0.252454,2.58031),(-0.386839,-0.410909,2.53309),(-0.565012,-0.589087,2.4942),(-0.731351,-0.75543,2.45531),(-0.854296,-0.878378,2.40809),(-0.152264,-0.104911,2.64421),(-0.282854,-0.181611,2.58031),(-0.475935,-0.295016,2.53309),(-0.693052,-0.422538,2.4942),(-0.895747,-0.541591,2.45531),(-1.04556,-0.629585,2.40809),(-0.172192,-0.056979,2.64421),(-0.317821,-0.097508,2.58031),(-0.533136,-0.157435,2.53309),(-0.775254,-0.22482,2.4942),(-1.00129,-0.287729,2.45531),(-1.16836,-0.334227,2.40809),(-0.179229,-0.003268,2.64421),(-0.330169,-0.003267,2.58031),(-0.553337,-0.003267,2.53309),(-0.804286,-0.003265,2.4942),(-1.03857,-0.003264,2.45531),(-1.21173,-0.003264,2.40809),(-0.172192,0.050442,2.64421),(-0.317821,0.090974,2.58031),(-0.533137,0.150902,2.53309),(-0.775256,0.218289,2.4942),(-1.0013,0.2812,2.45531),(-1.16836,0.327699,2.40809),(-0.152265,0.098374,2.64421),(-0.282855,0.175075,2.58031),(-0.475937,0.288484,2.53309),(-0.693055,0.416006,2.4942),(-0.89575,0.53506,2.45531),(-1.04557,0.623057,2.40809),(-0.121225,0.138748,2.64421),(-0.228392,0.245919,2.58031),(-0.386843,0.404374,2.53309),(-0.565016,0.582554,2.4942),(-0.731355,0.748898,2.45531),(-0.854302,0.871849,2.40809),(-0.080852,0.169789,2.64421),(-0.157551,0.300384,2.58031),(-0.270954,0.493471,2.53309),(-0.398474,0.710596,2.4942),(-0.517525,0.913298,2.45531),(-0.605517,1.06312,2.40808),(-0.032921,0.189717,2.64421),(-0.073451,0.335351,2.58031),(-0.133378,0.550674,2.53309),(-0.200762,0.7928,2.4942),(-0.263672,1.01884,2.45531),(-0.31017,1.18592,2.40808),(0.020788,0.196755,2.64421),(0.020787,0.347699,2.58031),(0.020786,0.570874,2.53309),(0.020785,0.82183,2.4942),(0.020785,1.05612,2.45531),(0.020784,1.22929,2.40808),(0.074496,0.189717,2.64421),(0.115026,0.33535,2.58031),(0.17495,0.550672,2.53309),(0.242333,0.792798,2.4942),(0.305241,1.01884,2.45531),(0.351738,1.18592,2.40808),(0.122426,0.169789,2.64421),(0.199126,0.300383,2.58031),(0.312528,0.49347,2.53309),(0.440046,0.710593,2.4942),(0.559095,0.913294,2.45531),(0.647087,1.06312,2.40808),(0.1628,0.138748,2.64421),(0.269967,0.245917,2.58031),(0.428417,0.404371,2.53309),(0.606589,0.58255,2.4942),(0.772927,0.748893,2.45531),(0.895873,0.871842,2.40808),(0.193841,0.098373,2.64421),(0.324431,0.175074,2.58031),(0.517512,0.288479,2.53309),(0.734629,0.416001,2.4942),(0.937324,0.535054,2.45531),(1.08714,0.623049,2.40808),(0.213768,0.050441,2.64421),(0.359397,0.090971,2.58031),(0.574713,0.150898,2.53309),(0.816832,0.218283,2.4942),(1.04287,0.281192,2.45531),(1.20994,0.32769,2.40809),(0.203545,-0.00327,2.69558),(0.199081,-0.037468,2.69556),(0.19586,-0.052025,2.69947),(0.179617,-0.089849,2.700955),(0.151066,-0.128112,2.703455),(0.113417,-0.157699,2.704895),(0.068287,-0.176594,2.70516),(0.017587,-0.182732,2.70415),(-0.032798,-0.175476,2.701855),(-0.07733,-0.156157,2.698535),(-0.114399,-0.12662,2.69451),(-0.138281,-0.096722,2.69236),(-0.146656,-0.080639,2.68766),(-0.158102,-0.05308,2.68768),(-0.162055,-0.035155,2.68289),(-0.166234,-0.003268,2.68288),(-0.165479,0.014016,2.67841),(-0.161122,0.04738,2.67837),(-0.156617,0.061662,2.67443),(-0.140353,0.09817,2.672875),(-0.111925,0.134889,2.670365),(-0.075145,0.163216,2.668985),(0.014387,0.187572,2.66901),(0.020788,0.187867,2.67066),(0.061344,0.182573,2.67064),(0.071873,0.180234,2.67347),(0.104183,0.16683,2.67344),(0.116825,0.160222,2.67716),(0.141573,0.141208,2.67715),(0.153929,0.129876,2.68149),(0.171844,0.106555,2.6815),(0.181637,0.091226,2.68624),(0.193016,0.063794,2.68626),(0.202784,0.014013,2.69109),(-0.031445,0.181446,2.6688),(0.198573,0.046237,2.69109),(0.293129,0.014011,3.00734),(0.014385,0.014012,3.03026),(0.28337,-0.061081,3.00734),(0.3774,0.014011,2.94693),(0.364689,-0.083779,2.94693),(0.339432,0.014011,2.8615),(0.328047,-0.073534,2.86151),(0.251456,0.014012,2.76357),(0.243146,-0.049803,2.76357),(0.255705,-0.127947,3.00734),(0.328659,-0.170858,2.94693),(0.295778,-0.151501,2.86151),(0.219595,-0.106658,2.76357),(0.212554,-0.184167,3.00734),(0.27246,-0.244074,2.94693),(0.24545,-0.217063,2.86151),(0.182873,-0.154482,2.76357),(0.156338,-0.227319,3.00734),(0.199247,-0.300276,2.94693),(0.179891,-0.267393,2.86151),(0.135051,-0.191206,2.76357),(0.089475,-0.254985,3.00734),(0.112172,-0.336308,2.94693),(0.101928,-0.299664,2.86151),(0.078199,-0.214759,2.76357),(0.014387,-0.264745,3.00734),(0.014387,-0.349019,2.94693),(0.014387,-0.311049,2.86151),(0.014387,-0.223068,2.76357),(-0.060702,-0.254985,3.00734),(-0.083398,-0.336307,2.94693),(-0.073154,-0.299663,2.86151),(-0.049425,-0.214757,2.76357),(-0.127565,-0.227318,3.00734),(-0.170473,-0.300274,2.94693),(-0.151118,-0.267391,2.86151),(-0.106277,-0.191205,2.76357),(-0.183782,-0.184165,3.00734),(-0.243687,-0.244072,2.94693),(-0.216677,-0.21706,2.86151),(-0.1541,-0.15448,2.76357),(-0.226933,-0.127944,3.00734),(-0.299886,-0.170855,2.94693),(-0.267005,-0.151498,2.86151),(-0.190823,-0.106656,2.76357),(-0.254598,-0.061079,3.00734),(-0.335918,-0.083775,2.94693),(-0.299275,-0.073531,2.86151),(-0.214374,-0.049801,2.76357),(-0.264358,0.014013,3.00734),(-0.348629,0.014014,2.94693),(-0.310661,0.014014,2.86151),(-0.222685,0.014014,2.76357),(-0.254599,0.089106,3.00734),(-0.335919,0.111804,2.94693),(-0.299276,0.10156,2.86151),(-0.214375,0.077829,2.76357),(-0.226935,0.155971,3.00734),(-0.299888,0.198883,2.94693),(-0.267007,0.179526,2.8615),(-0.190824,0.134684,2.76357),(-0.183784,0.212191,3.00734),(-0.243689,0.2721,2.94693),(-0.216679,0.245088,2.8615),(-0.154102,0.182509,2.76357),(-0.127567,0.255344,3.00734),(-0.170476,0.328301,2.94693),(-0.15112,0.295419,2.8615),(-0.106279,0.219233,2.76357),(-0.060705,0.283009,3.00734),(-0.083401,0.364333,2.94693),(-0.073157,0.32769,2.8615),(-0.049428,0.242785,2.76357),(0.014384,0.292769,3.00734),(0.014384,0.377044,2.94693),(0.014384,0.339074,2.8615),(0.014384,0.251095,2.76357),(0.089473,0.283009,3.00734),(0.112169,0.364332,2.94693),(0.101925,0.327688,2.8615),(0.078197,0.242784,2.76357),(0.156335,0.255342,3.00734),(0.199244,0.328299,2.94693),(0.179889,0.295417,2.8615),(0.135049,0.219231,2.76357),(0.212552,0.212189,3.00734),(0.272458,0.272097,2.94693),(0.245448,0.245086,2.8615),(0.182872,0.182507,2.76357),(0.255704,0.155968,3.00734),(0.328657,0.198879,2.94693),(0.295777,0.179524,2.8615),(0.219594,0.134682,2.76357),(0.283369,0.089103,3.00734),(0.364689,0.1118,2.94693),(0.328046,0.101557,2.8615),(0.243146,0.077827,2.76357),(1.93423,-0.505114,1.07504),(1.950924,0.249317,0.744),(1.936893,0.463669,1.075849),(-1.949447,-0.210261,0.843925),(-1.934253,-0.235498,0.777606),(-1.925976,-0.204917,0.709047),(-1.921309,-0.010686,0.64565),(-1.93454,0.21382,0.778369),(-1.970293,0.11237,0.904121),(-1.926619,0.182483,0.711259),(-1.969687,-0.134504,0.901423)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Teapot.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Teapot.py load and self-test diagnostics complete.")
