package Basic.ExperimentalBinaryCompression;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Compressed IndexedFaceSet example. </p>
 <p> Related links: Catalog page <a href="../../../ExperimentalBinaryCompression/LionCompressedIndex.html" target="_blank">LionCompressed</a>,  source <a href="../../../ExperimentalBinaryCompression/LionCompressed.java">LionCompressed.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/LionCompressed.x3d">LionCompressed.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Compressed IndexedFaceSet example. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Martin Isenburg </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 4 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 5 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D VRML binary compression </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/LionCompressed.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/LionCompressed.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Martin Isenburg
 */

public class LionCompressed
{
	/** Default constructor to create this object. */
	public LionCompressed ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("LionCompressed.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Compressed IndexedFaceSet example."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Martin Isenburg"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("4 May 2003"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("5 May 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D VRML binary compression"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/LionCompressed.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("LionCompressed.x3d"))
    .addChild(new ExternProtoDeclare("CompressedIndexedFaceSet").setName("CompressedIndexedFaceSet").setAppinfo("An ASCII-compressed IndexedFaceSet").setUrl(new String[] {"CodedCompressedPrototypes.x3d#CompressedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CompressedIndexedFaceSet","CodedCompressedPrototypes.wrl#CompressedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CompressedIndexedFaceSet"})
      .addField(new field().setName("code").setType(field.TYPE_SFSTRING).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("ASCII-compressed coordIndex and texCoordIndex values"))
      .addField(new field().setName("box_tex").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("bounding box of texture coordinates (always 4 values minU minV maxU maxV)"))
      .addField(new field().setName("bits_tex").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("number of quantization bits for texture coordinates"))
      .addField(new field().setName("box").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("bounding box of coordinates (always 6 values minX minY minZ maxX maxY maxZ)"))
      .addField(new field().setName("bits").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("number of quantization bits for coordinates")))
    .addChild(new Viewpoint().setDescription("1M view").setPosition(0.0,0.0,1.0))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.025,0.025,0.025)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"lion.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/lion.jpg"})))
        .setGeometry(new ProtoInstance("CompressedIndexedFaceSet").setContainerField("geometry")
          .addFieldValue(new fieldValue().setName("box_tex").setValue(new double[] {0.0215,0.0284,0.9799,0.9784}))
          .addFieldValue(new fieldValue().setName("bits_tex").setValue(10))
          .addFieldValue(new fieldValue().setName("code").setValue("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"))
          .addFieldValue(new fieldValue().setName("box").setValue(new double[] {-4.1757,-8.3377,-10.0,4.1757,8.3377,10.0}))
          .addFieldValue(new fieldValue().setName("bits").setValue(12))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return LionCompressed model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new LionCompressed().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ExperimentalBinaryCompression.LionCompressed\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ExperimentalBinaryCompression.LionCompressed self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ExperimentalBinaryCompression/LionCompressed_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ExperimentalBinaryCompression/LionCompressed_JavaExport.x3d"; 
                String filenameX3DV = "ExperimentalBinaryCompression/LionCompressed_JavaExport.x3dv"; 
                String filenameJSON = "ExperimentalBinaryCompression/LionCompressed_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
