####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python LionCoded.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='LionCoded.x3d',name='title'),
    meta(content='ASCII-coded IndexedFaceSet example.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='4 May 2003',name='created'),
    meta(content='5 May 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/LionCoded.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='LionCoded.x3d'),
    ExternProtoDeclare(appinfo='An ASCII-coded IndexedFaceSet',name='CodedIndexedFaceSet',url=["CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","CodedCompressedPrototypes.wrl#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CodedIndexedFaceSet"],
      field=[
      field(accessType='initializeOnly',appinfo='ASCII-coded coordIndex and texCoordIndex values',name='code',type='MFInt32'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for Coordinate values',name='pos',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for TextureCoordinate values',name='tex',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='Coordinate node',name='coord',type='SFNode'),
      field(accessType='initializeOnly',appinfo='TextureCoordinate node',name='texCoord',type='SFNode')]),
    Viewpoint(description='1M view',position=(0.0,0.0,1.0)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(scale=(0.025,0.025,0.025),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,1.0,1.0)),
          texture=ImageTexture(url=["lion.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/lion.jpg"])),
        geometry=ProtoInstance(name='CodedIndexedFaceSet',
          fieldValue=[
          fieldValue(name='tex',value=0.0037583),
          fieldValue(name='code',value=[82310,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,6,0,0,0,0,6,6,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,6,0,6,0,0,6,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,6,0,6,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,6,0,0,0,0,6,6,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,3,1,2,0,6,0,0,6,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,6,0,3,2,6,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,5,5,0,6,0,0,0,0,6,6,0,0,0,0,0,0,6,0,6,6,0,0,6,5,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,0,7,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,5,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,3,0,1,1,2,0,5,6,0,0,6,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,5,0,5,0,5,0,6,0,0,0,0,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,5,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,0,6,0,0,6,6,0,0,5,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,7,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,5,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,5,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,-1,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,5,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,6,0,0,0,0,3,0,5,3,2,0,6,0,6,0,6,0,0,0,6,0,5,-1,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,5,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,3,0,5,1,1,2,0,6,0,6,0,6,0,0,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,5,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,5,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,3,0,0,6,1,1,1,2,0,6,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,6,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,6,3,0,0,0,6,0,6,0,0,0,0,0,6,0,6,6,0,0,6,5,0,0,6,0,3,2,5,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,6,0,1,1,2,0,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,6,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,5,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,3,0,0,6,1,1,1,2,0,6,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,6,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,6,0,0,6,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,10,0,0,0,0,0,0,0,0,3,0,0,0,6,5,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,3,0,0,6,1,1,1,2,0,6,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,6,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,0,6,5,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,3,0,0,6,1,1,1,2,0,6,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,6,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,6,0,0,5,0,6,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,10,0,0,0,0,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,0,0,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,0,3,0,0,6,2,0,5,0,6,0,6,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,3,0,0,6,1,1,1,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,6,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,0,6,0,6,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,6,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,5,0,6,0,0,6,0,0,0,0,3,0,5,0,0,6,0,0,0,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,0,3,0,0,6,2,0,5,0,6,0,6,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,10,0,0,0,0,0,0,0,0,3,0,5,0,0,0,0,0,6,0,6,0,6,0,0,5,6,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,6,0,0,0,0,6,3,0,5,1,2,0,5,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,6,0,0,0,6,0,0,5,6,0,0,6,0,6,0,0,0,6,6,0,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,6,0,0,0,0,6,3,2,0,5,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,6,0,0,0,6,0,0,5,0,0,0,6,6,0,5,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,0,6,6,0,6,0,0,0,6,0,0,6,0,5,0,0,6,0,5,0,6,0,0,3,0,0,0,5,0,0,0,6,0,0,5,6,0,6,0,6,0,0,6,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,6,0,0,0,5,6,0,0,0,0,0,6,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,5,0,0,5,0,0,0,6,6,0,0,5,5,0,5,0,0,6,0,6,0,0,1,1,1,1,1,2,0,5,0,6,0,6,0,0,6,0,0,5,0,0,0,6,6,0,0,5,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,5,0,0,5,0,6,0,0,5,0,0,0,6,6,0,0,5,0,6,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,5,0,6,0,0,0,6,0,6,0,0,5,0,0,5,6,0,0,6,0,0,0,5,5,0,6,0,0,0,6,0,6,0,0,5,0,5,0,0,5,5,0,0,6,0,5,0,5,0,6,0,0,0,0,3,0,5,0,0,6,0,0,0,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,0,3,0,0,6,2,0,5,0,6,0,6,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,3,0,0,6,1,1,1,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,6,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,0,6,0,6,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,6,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,5,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,10,0,0,0,0,0,0,0,0,3,0,5,0,0,0,0,0,6,0,6,0,6,0,0,5,6,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,3,2,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,6,0,0,0,6,0,0,0,0,5,0,0,0,6,0,0,5,6,0,6,6,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,0,5,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,0,0,6,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,5,0,5,0,0,5,0,0,0,6,6,0,0,5,5,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,3,0,5,0,0,0,0,0,6,0,6,0,6,0,0,5,6,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,6,0,0,0,0,6,3,2,0,5,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,6,0,0,0,6,0,0,5,0,0,0,6,6,0,5,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,3,2,0,0,6,0,6,0,6,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,5,2,0,5,0,6,6,0,0,0,6,0,5,0,0,5,0,6,0,0,5,0,0,0,6,6,0,0,5,0,6,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,5,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,0,6,0,5,0,0,5,0,0,5,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,5,0,0,0,3,0,0,0,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,6,3,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,6,0,5,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,0,6,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,0,6,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,5,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,5,0,5,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,6,0,5,0,3,2,0,6,6,0,6,0,0,6,0,0,6,7,0,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,0,8,0,0,0,0,6,6,0,0,5,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,0,7,0,0,0,0,7,6,0,0,0,6,0,3,0,0,0,0,0,0,0,0,3,2,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,3,0,5,0,3,2,0,6,0,6,3,0,0,0,6,0,6,1,0,0,6,0,0,6,3,2,0,6,6,0,0,6,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,3,2,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,1,1,1,1,1,2,0,6,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,6,0,6,0,0,5,0,6,0,6,0,6,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,3,2,6,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,0,0,6,6,0,0,0,7,0,0,0,0,8,0,0,3,2,5,0,6,0,0,6,0,0,6,0,0,6,0,0,3,2,0,5,6,0,6,0,0,6,0,0,5,6,0,0,7,0,0,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,5,0,3,0,0,3,1,1,1,1,2,0,6,0,6,0,6,0,0,6,3,2,0,0,7,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,6,6,0,6,0,0,6,0,0,0,0,0,0,3,2,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,3,2,0,0,6,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,3,2,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,1,2,0,6,0,6,6,0,0,0,6,0,6,0,0,0,5,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,7,0,0,0,0,6,0,0,7,0,0,6,0,0,0,6,0,5,0,6,0,6,0,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,0,6,0,0,5,6,0,6,0,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,5,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,5,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,7,0,0,0,5,0,5,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,5,0,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,6,0,0,7,0,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,0,8,0,0,0,7,0,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,7,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,5,0,5,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,3,2,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,11,0,0,0,0,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,0,0,7,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,3,2,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,5,0,5,0,5,0,6,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,5,6,0,0,0,6,0,6,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,6,0,3,2,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,5,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,11,0,0,0,0,0,0,2,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,1,2,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,7,0,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,5,0,5,5,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,0,6,0,5,5,0,0,6,0,6,0,0,6,0,0,3,2,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,0,5,0,7,0,6,0,0,5,0,0,5,5,0,6,0,0,0,6,0,5,0,0,6,0,0,7,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,7,0,0,0,6,0,6,0,0,5,0,0,5,0,5,6,0,0,0,0,6,0,6,0,0,7,0,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,0,0,0,0,6,0,6,0,6,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,0,0,0,0,6,0,6,0,6,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,7,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,7,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,6,0,6,0,5,0,3,0,0,5,0,6,2,0,0,6,0,6,0,0,0,6,6,0,6,0,0,6,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,6,0,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,5,0,0,0,6,0,6,0,0,6,0,3,1,3,1,1,1,2,0,6,0,0,6,0,0,6,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,3,1,2,5,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,0,5,6,6,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,6,0,6,3,3,2,0,6,0,0,0,6,0,0,3,0,0,0,5,6,2,0,6,0,6,6,0,5,0,6,0,0,0,6,6,0,0,5,0,0,6,0,0,6,5,0,0,0,6,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,0,6,0,0,5,6,0,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,3,1,2,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,0,5,0,0,0,0,6,0,6,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,3,1,2,6,5,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,1,1,1,1,1,1,1,1,1,1,1,1,2,0,6,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,5,2,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,5,0,6,3,2,0,6,0,0,6,0,6,0,5,0,0,5,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,5,0,6,0,6,0,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,0,5,0,6,0,6,0,6,0,6,0,6,5,0,0,6,0,6,0,6,5,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,0,6,0,0,5,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,5,0,0,5,5,0,6,0,0,6,3,2,0,6,0,6,0,5,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,5,5,0,6,0,0,0,6,0,0,6,3,2,0,6,0,0,6,6,0,0,0,6,0,0,5,5,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,3,2,0,6,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,5,0,0,5,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,5,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,5,0,5,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,5,0,5,0,0,0,6,6,0,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,5,0,6,0,0,0,0,6,6,0,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,5,0,5,0,6,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,0,6,5,0,6,0,0,0,6,0,6,0,0,0,5,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,0,5,5,0,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,0,6,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,5,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,0,6,0,0,5,6,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,5,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,5,0,5,0,5,0,5,0,5,0,5,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,6,0,0,5,6,0,0,0,0,30,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,5,0,6,0,6,0,0,0,5,5,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,0,5,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,0,0,6,5,0,0,6,0,0,6,0,5,0,0,0,6,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,5,0,0,6,0,0,0,5,0,0,6,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,5,0,6,0,0,0,6,0,5,0,0,5,0,6,0,0,5,0,5,0,6,0,0,5,5,0,0,6,0,6,0,0,5,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,3,1,2,0,6,5,0,0,6,0,0,6,0,0,0,6,5,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,5,0,5,6,0,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,6,0,0,5,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,6,0,0,5,0,6,0,5,0,5,6,0,0,6,0,0,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,5,0,6,0,0,6,0,0,5,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,6,0,0,0,5,0,6,0,5,0,5,0,6,0,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,6,0,0,5,0,0,5,6,0,0,0,6,0,6,0,0,0,5,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,6,0,6,0,6,0,0,0,0,0,6,0,6,6,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,5,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,6,0,6,0,6,0,0,0,0,0,6,0,6,6,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,0,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,5,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,6,0,6,0,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,14,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,14,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,14,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,14,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,10,3,0,0,0,0,0,0,0,0,10,0,6,5,2,6,1,1,2,0,0,0,10,0,0,6,0,6,0,0,6,0,0,6,0,6,0,5,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,0,6,5,0,0,6,0,6,6,0,0,0,6,0,6,0,6,6,6,0,0,0,6,0,0,6,6,0,0,6,0,6,0,0,6,6,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,11368,6,-1,11369,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,11378,6,-1,11379,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,6,-1,11388,6,-1,11389,0,0,6,0,0,0,0,10,0,0,0,6,0,0,6,6,0,6,0,6,0,0,0,0,0,13,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,0,6,6,0,6,6,0,6,6,6,0,0,6,0,0,6,6,0,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,6,0,0,6,0,6,6,6,0,6,0,6,6,6,0,6,0,6,6,6,0,6,6,6,6,0,6,6,0,6,6,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,6,0,6,0,0,0,6,0,5,0,0,0,0,5,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,5,5,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,5,5,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,5,0,6,0,5,0,6,0,0,5,5,0,0,5,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,3,2,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,5,5,0,0,6,0,6,0,0,0,6,0,5,0,0,5,5,0,0,5,5,0,0,6,0,0,5,0,6,0,6,0,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,3,0,0,0,3,3,1,2,0,0,6,0,0,5,0,6,5,3,0,3,1,2,0,6,0,0,5,0,6,5,3,3,2,3,2,6,3,2,0,6,0,5,5,0,3,2,0,6,6,0,0,0,6,0,0,0,0,6,6,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,6,0,0,0,6,0,0,0,6,6,6,6,0,6,0,0,0,0,3,2,6,0,0,5,0,6,0,5,0,6,0,0,6,6,6,0,0,6,0,6,6,0,6,6,0,0,7,0,0,0,0,0,6,0,6,0,0,5,0,6,0,6,0,0,0,0,6,3,1,1,1,1,1,1,2,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,0,6,7,0,0,0,0,6,0,0,6,6,6,6,0,0,0,0,6,6,0,0,6,6,0,5,0,0,0,5,6,6,0,0,0,0,6,6,6,6,0,6,0,0,0,6,0,0,6,6,0,6,6,0,6,0,0,0,0,6,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,6,0,6,0,6,0,0,5,5,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,6,6,0,6,0,6,6,6,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,6,0,6,0,0,6,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,6,6,0,6,0,6,0,6,0,0,6,0,0,6,6,0,0,0,0,6,0,6,0,0,0,0,6,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,6,6,0,0,6,0,0,6,6,6,0,6,0,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,5,6,0,0,6,0,6,0,0,6,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,0,0,3,1,1,2,0,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,14,0,0,0,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,1,1,1,1,2,0,6,0,6,0,0,6,0,3,1,1,1,1,1,1,1,0,0,6,0,0,6,0,0,14,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,1,1,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,0,6,5,0,0,6,6,6,0,0,6,0,0,6,6,6,0,6,0,3,2,6,6,6,0,6,0,0,6,6,6,0,6,0,0,0,6,6,0,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,0,6,6,0,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,5,5,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,5,0,0,6,0,6,0,0,6,0,6,5,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,5,0,5,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,6,0,0,6,6,0,0,0,6,0,0,6,0,0,5,5,0,5,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,5,5,0,5,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,3,1,0,3,2,0,0,6,6,0,3,1,2,6,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,5,5,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,6,0,3,1,1,1,1,2,6,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,5,5,0,6,0,0,6,0,6,0,0,0,3,2,6,0,6,0,0,6,0,0,0,6,0,5,5,0,0,6,0,5,0,0,0,7,0,0,5,6,0,0,0,5,6,0,0,0,0,5,6,0,0,5,6,0,0,6,0,6,0,6,0,6,3,2,0,5,0,6,0,3,2,0,5,6,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,5,0,0,5,6,0,6,0,0,0,5,6,0,0,0,5,0,0,7,0,5,0,0,6,0,5,0,0,5,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,0,6,6,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,5,0,6,0,0,0,0,5,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,5,0,0,0,6,0,6,0,0,5,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,5,6,0,0,0,0,6,6,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,5,0,0,5,6,0,6,0,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,1,1,1,1,1,2,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,5,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,6,0,6,0,6,6,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,5,0,6,0,0,0,6,5,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,5,0,0,0,6,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,5,5,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,5,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,5,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,5,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,3,2,5,0,6,0,5,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,5,3,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,5,0,0,6,0,3,1,1,2,0,0,7,0,6,0,3,2,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,6,6,6,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,6,0,6,6,0,0,6,0,5,0,6,6,0,6,0,6,5,0,6,0,1,1,0,0,0,3,1,1,1,2,0,5,0,6,0,6,6,0,0,6,3,1,2,0,6,0,6,0,0,6,6,0,0,6,0,0,5,6,0,0,0,7,6,6,6,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,5,0,6,0,0,5,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,7,6,0,6,0,6,0,5,0,5,0,0,6,0,0,0,5,6,0,0,0,5,6,0,0,6,0,6,6,0,5,3,1,2,0,6,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,2,0,5,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,3,0,0,3,1,1,1,2,0,5,0,6,0,6,3,0,0,6,0,0,5,0,6,0,0,0,3,1,1,1,2,0,7,0,6,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,3,2,5,0,6,0,0,5,6,6,6,0,6,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,6,6,0,0,6,6,6,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,1,2,0,6,0,6,3,1,2,0,6,0,0,6,6,0,0,0,6,0,0,5,6,0,0,6,0,6,0,5,0,6,0,5,3,1,2,0,6,0,5,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,0,5,6,0,0,6,0,5,0,5,0,7,0,6,6,0,6,0,6,0,0,6,0,0,6,0,5,0,0,0,6,5,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,7,0,6,6,0,6,0,6,6,0,6,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,2,0,5,6,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,6,0,6,0,6,0,6,0,5,0,0,6,0,5,0,0,0,6,6,0,0,6,0,0,0,5,0,5,0,5,5,0,5,0,5,0,0,5,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,6,0,6,0,6,0,0,5,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,0,5,6,0,6,0,0,6,6,0,6,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,0,5,5,0,5,0,5,0,0,5,0,5,0,5,6,0,0,6,0,0,6,0,0,5,0,5,5,0,6,0,0,0,6,0,0,6,6,0,6,0,6,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,6,6,6,6,0,0,0,6,0,6,0,6,5,0,0,6,0,0,6,0,0,6,0,5,0,6,0,1,2,0,6,0,5,6,0,0,0,0,6,6,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,6,0,6,0,0,0,6,0,6,0,6,6,0,0,6,0,6,6,6,0,6,0,0,0,0,6,6,0,0,6,0,6,0,5,6,0,6,0,0,6,0,6,0,5,6,0,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,6,6,0,0,6,0,5,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,0,7,0,0,6,0,0,7,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,7,0,0,6,0,0,0,7,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,0,6,0,6,6,0,5,0,6,0,6,0,0,0,6,6,6,6,0,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,0,6,0,6,0,5,6,0,6,0,0,6,0,6,0,5,0,6,0,0,6,6,6,0,0,6,0,6,6,6,0,6,0,0,0,6,0,6,6,0,6,0,0,1,2,0,6,0,5,6,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,6,0,0,0,6,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,6,0,6,6,0,6,0,0,0,6,6,6,0,0,6,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,6,0,6,6,0,0,5,0,0,5,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,0,6,6,0,0,0,7,6,0,6,0,6,0,0,0,5,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,0,5,6,0,7,0,0,6,6,0,6,0,6,0,0,0,6,6,0,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,6,0,6,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,5,0,6,0,6,0,0,5,0,0,5,0,5,6,6,6,6,0,0,0,6,0,6,6,0,0,0,6,0,5,0,5,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,6,0,6,0,0,5,6,6,0,6,0,6,0,0,0,6,0,0,6,0,3,2,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,3,2,6,0,0,5,0,6,0,0,6,0,6,0,0,0,5,6,6,6,0,6,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,5,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,5,0,5,0,0,6,0,6,0,6,6,0,0,0,6,0,5,0,5,5,6,0,0,0,6,6,6,0,0,0,6,0,0,5,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,6,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,6,6,0,6,0,6,0,6,0,6,5,0,0,5,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,5,5,0,6,0,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,6,6,0,6,0,6,6,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,5,6,0,6,6,0,6,0,5,6,6,0,6,0,0,0,0,0,6,6,6,0,6,0,6,0,0,0,0,5,6,0,0,5,0,0,6,0,0,6,0,6,0,0,5,6,6,6,0,0,0,0,6,6,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,6,6,0,6,0,0,6,6,0,6,6,0,6,0,0,5,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,5,6,0,0,0,6,0,6,6,6,6,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,6,6,0,6,0,0,6,6,0,6,6,0,0,0,6,0,0,6,0,5,0,6,0,0,0,5,6,0,0,0,0,6,5,6,6,0,6,0,0,0,6,6,6,0,6,0,0,0,6,0,6,0,6,0,5,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,6,6,0,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,0,6,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,0,6,0,6,0,6,0,0,0,5,0,0,6,0,6,0,6,6,6,0,0,6,0,6,0,6,0,6,0,0,6,0,6,0,6,0,0,0,6,0,0,5,6,0,0,5,0,0,5,0,5,6,0,0,0,0,6,0,6,0,5,6,6,0,0,6,0,0,6,6,6,0,6,0,0,0,0,6,6,6,0,6,0,5,6,0,0,6,0,6,0,0,0,6,0,5,6,0,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,5,6,0,0,6,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,0,6,6,6,0,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,5,0,0,6,5,0,0,6,6,6,0,0,0,6,0,0,6,6,6,0,6,0,5,6,6,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,6,6,0,0,0,5,0,5,5,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,5,0,6,5,0,0,0,6,0,6,0,0,5,6,0,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,7,0,0,0,6,0,0,6,0,0,7,0,0,0,6,0,5,0,0,6,0,0,5,0,6,0,6,0,0,0,5,0,6,0,0,0,6,5,0,0,0,0,5,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,5,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,5,6,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,0,5,0,6,6,0,0,3,2,0,6,5,0,6,0,0,0,7,0,0,0,5,0,6,0,5,0,6,0,0,0,0,6,0,6,0,6,0,0,0,7,0,0,0,6,0,0,0,7,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,0,7,0,0,6,0,0,7,0,0,6,0,0,0,6,0,0,0,6,6,0,0,5,0,0,6,0,0,5,0,7,0,0,6,0,0,5,0,0,6,0,0,3,2,5,6,0,0,0,6,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,6,6,0,0,5,0,0,5,0,5,5,0,6,0,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,0,6,6,0,0,5,0,0,0,5,6,0,0,6,0,6,0,6,0,0,0,6,0,6,0,0,0,0,0,5,6,0,6,0,6,0,0,5,0,0,6,0,0,5,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,0,7,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,7,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,6,0,0,5,0,6,0,5,0,6,0,0,0,6,0,0,0,5,0,6,6,0,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,5,0,0,6,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,0,0,0,0,6,0,6,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,0,6,6,0,0,3,2,5,0,5,6,0,0,0,0,6,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,0,0,0,6,0,6,5,0,6,0,5,0,0,6,0,5,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,0,0,0,6,0,6,0,6,6,0,0,0,5,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,7,0,0,0,0,6,6,0,0,6,0,0,0,5,6,0,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,6,0,0,0,5,6,0,0,6,0,0,0,0,6,0,7,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,7,0,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,7,0,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,5,0,3,2,6,0,0,6,0,5,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,7,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,7,0,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,0,0,0,6,0,6,5,0,6,0,5,0,0,6,0,5,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,0,0,5,6,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,5,0,6,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,0,0,0,0,6,0,6,5,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,5,0,0,6,0,5,0,0,6,0,0,5,0,6,0,0,5,0,6,0,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,0,5,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,0,6,5,0,0,6,0,0,6,0,6,0,0,0,0,7,0,0,6,0,0,7,0,0,0,6,0,0,8,0,0,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,5,0,0,0,6,0,0,6,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,8,0,0,0,0,6,0,0,7,0,0,0,6,0,0,7,0,0,3,2,6,0,0,7,0,0,0,0,6,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,0,6,0,7,0,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,5,0,0,0,6,0,0,6,5,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,6,0,0,5,0,0,0,6,7,0,0,0,0,6,0,0,7,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,7,0,0,0,6,0,7,0,0,0,0,0,6,5,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,5,0,0,3,2,6,0,0,6,5,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,5,0,0,6,0,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,6,0,0,0,0,6,5,0,0,6,0,5,3,2,0,5,5,3,2,0,5,5,0,5,0,6,0,5,0,0,0,6,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,6,0,0,6,0,0,3,2,5,0,6,0,0,0,6,6,0,0,0,5,6,0,0,5,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,5,0,0,0,5,6,0,0,6,0,0,5,5,0,6,0,0,0,5,6,0,0,5,0,0,6,0,0,6,0,5,0,5,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,5,0,6,0,0,0,5,6,0,0,5,0,0,5,0,6,0,6,0,0,5,3,1,0,3,0,0,0,0,0,0,0,10,0,6,0,5,0,0,0,0,0,0,0,0,10,0,6,0,0,0,0,0,0,0,0,0,10,0,6,3,1,2,0,0,6,0,6,0,6,0,6,0,6,0,0,6,0,3,2,0,6,5,6,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,6,0,6,6,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,6,0,6,0,6,0,6,0,0,6,0,0,0,0,0,10,0,0,6,0,0,6,6,0,6,0,6,0,0,0,0,0,14,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,0,6,6,0,6,6,0,6,6,0,6,0,0,6,0,0,0,0,10,0,0,0,6,6,0,0,0,0,6,0,6,6,6,0,6,0,6,-1,14202,6,-1,14203,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,14212,6,-1,14213,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,14222,6,-1,14223,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,6,6,6,0,0,6,0,0,0,0,5,6,6,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,6,0,0,6,0,6,6,6,0,6,0,6,6,6,0,6,0,6,6,6,0,6,6,6,6,0,6,6,0,6,6,0,5,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,6,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,6,6,0,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,6,6,0,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,0,6,0,6,0,0,0,5,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,0,6,3,2,6,0,0,5,5,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,0,5,5,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,3,2,6,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,3,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,5,0,6,0,1,1,2,6,1,1,2,0,6,0,5,6,0,0,5,0,0,0,6,0,6,0,6,0,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,6,0,0,0,6,0,0,0,6,5,0,6,0,0,0,5,0,6,0,0,0,3,0,0,0,0,0,0,10,3,0,0,0,0,0,0,0,10,3,0,0,0,0,0,0,0,0,10,0,6,5,2,6,1,2,0,6,3,1,2,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,2,0,0,6,5,0,0,6,0,6,6,0,0,0,6,0,6,0,6,6,6,0,0,0,6,0,0,6,6,0,0,6,0,6,0,6,6,6,0,0,6,0,0,0,6,6,6,6,0,0,6,0,0,0,6,0,6,3,2,0,6,0,0,5,0,6,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,6,6,6,0,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,14637,6,-1,14638,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,14647,6,-1,14648,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,6,-1,14657,6,-1,14658,0,0,6,0,0,0,0,10,0,0,0,6,0,0,6,6,0,6,0,6,0,0,0,0,0,14,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,0,6,6,0,6,6,0,6,6,0,6,0,0,6,0,0,10,0,0,0,0,0,6,6,0,0,0,6,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,6,6,0,6,0,0,0,6,6,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,6,0,0,6,0,6,6,6,0,6,0,6,6,6,0,6,0,6,6,6,0,6,6,6,6,0,6,6,0,6,6,0,5,6,6,0,6,0,0,6,0,6,0,0,0,0,6,6,6,6,0,6,0,6,0,6,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,0,0,6,0,6,0,6,0,0,6,0,6,0,6,0,0,6,0,6,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,5,0,0,5,5,0,0,6,0,5,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,3,2,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,3,2,0,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,3,2,5,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,1,1,2,0,0,6,0,0,5,6,6,5,0,0,5,7,0,0,0,5,0,5,0,0,6,0,0,6,0,5,0,5,0,7,0,0,0,0,5,5,0,6,0,6,5,0,5,0,5,0,7,0,0,0,0,6,6,0,0,6,0,6,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,0,6,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,7,0,0,0,5,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,0,5,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,5,0,0,0,6,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,0,6,5,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,6,0,0,0,5,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,0,5,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,5,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,5,6,0,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,5,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,5,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,5,0,0,0,6,6,0,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,0,6,5,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,0,0,5,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,0,5,0,6,6,0,0,0,0,6,6,0,0,3,0,0,6,0,0,3,1,1,2,0,6,0,6,5,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,1,2,6,0,5,0,6,0,6,0,0,3,0,0,0,0,0,0,0,10,0,6,0,5,0,0,0,0,0,0,0,0,10,0,6,3,0,0,0,0,0,0,10,1,2,3,2,0,6,0,6,0,6,0,0,6,0,3,2,0,6,5,6,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,6,0,6,6,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,6,0,6,0,6,0,0,0,6,0,0,0,0,13,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,6,6,6,0,0,6,6,0,6,6,0,6,6,0,6,0,0,6,0,0,0,0,10,0,0,0,6,6,0,0,0,0,6,0,6,6,6,0,6,0,6,-1,15500,6,-1,15501,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,15510,6,-1,15511,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,-1,15520,6,-1,15521,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,0,6,6,6,6,0,0,6,0,6,0,6,0,6,0,0,5,6,0,6,6,0,6,0,6,6,6,0,6,0,6,6,6,0,6,6,6,6,0,6,6,0,6,6,0,5,6,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,6,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,6,6,0,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,3,2,5,0,5,6,0,0,6,0,6,0,0,0,5,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,5,6,0,0,0,6,0,0,6,0,6,0,6,0,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,5,0,0,6,0,6,0,6,0,0,0,0,5,5,0,5,0,6,0,0,5,0,6,0,0,5,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,3,2,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,0,6,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,5,6,0,0,0,6,0,0,5,0,6,0,5,0,0,5,5,0,0,5,5,0,0,6,0,6,0,0,0,6,0,5,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,3,1,1,1,2,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,6,0,6,0,6,1,2,0,6,6,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,5,6,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,6,0,5,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,6,1,2,0,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,5,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,5,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,5,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,3,2,0,6,0,6,0,6,0,0,0,6,0,5,0,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,5,5,0,0,6,0,6,0,0,0,6,0,3,2,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,0,6,0,3,2,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,3,2,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,5,0,5,6,0,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,5,0,5,6,0,0,6,0,0,0,6,0,0,6,0,6,0,0,6,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,0,6,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,5,0,5,6,0,0,6,0,0,0,5,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,5,5,0,5,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,5,5,0,5,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,5,5,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,0,6,6,6,0,6,0,6,6,6,0,6,0,6,0,6,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,3,1,2,5,0,6,0,0,5,6,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,0,5,0,5,0,6,0,3,2,6,0,0,6,0,0,6,0,5,0,0,0,5,0,6,6,0,0,6,0,5,5,0,6,0,0,0,5,5,0,5,0,0,6,0,0,6,0,5,0,5,0,0,5,0,0,5,6,0,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,6,0,0,6,6,0,0,0,5,6,0,0,0,0,0,5,6,0,6,0,6,0,0,0,0,0,5,6,0,5,5,0,0,5,0,0,5,6,0,0,5,3,2,6,0,0,6,0,0,5,0,0,5,6,0,0,5,0,5,5,0,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,6,0,0,0,5,5,0,0,0,5,6,0,0,6,0,5,0,0,5,6,0,0,6,0,0,6,0,0,0,6,0,0,6,6,0,0,6,0,0,6,0,0,0,5,0,5,5,0,0,0,5,6,0,0,5,0,5,6,0,0,6,0,0,0,6,0,6,0,0,0,0,0,5,6,6,0,0,0,5,0,6,0,0,5,6,0,0,5,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,6,0,0,5,0,0,5,5,0,5,0,0,6,0,6,0,0,0,6,0,5,0,0,6,0,5,0,5,0,6,0,0,0,0,2]),
          fieldValue(name='texCoord',
            children=[
            TextureCoordinate(point=[(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(25.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,3.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-4.0,1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-3.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(25.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-3.0,0.0),(1.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-4.0,2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-3.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,3.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(46.0,170.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(1.0,1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,-1.0),(2.0,0.0),(0.0,0.0),(-2.0,0.0),(1.0,-2.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,5.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-5.0,5.0),(2.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,9.0),(2.0,0.0),(0.0,1.0),(-2.0,0.0),(0.0,-2.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(27.0,5.0),(1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(2.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,-2.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(5.0,5.0),(2.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,-1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,5.0),(2.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,-1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,9.0),(2.0,1.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-2.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-63.0,-138.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,9.0),(2.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(-3.0,1.0),(-2.0,2.0),(1.0,2.0),(0.0,0.0),(3.0,-1.0),(2.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(-2.0,1.0),(-2.0,1.0),(-4.0,2.0),(-1.0,1.0),(0.0,2.0),(1.0,2.0),(1.0,1.0),(0.0,0.0),(2.0,-1.0),(3.0,-2.0),(2.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(-1.0,-1.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(-3.0,1.0),(-4.0,1.0),(-2.0,2.0),(-1.0,2.0),(1.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(2.0,-2.0),(3.0,-1.0),(3.0,-2.0),(1.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(-3.0,1.0),(-4.0,1.0),(-3.0,1.0),(-1.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,2.0),(2.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(1.0,-1.0),(2.0,-2.0),(3.0,-2.0),(3.0,-1.0),(1.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(-1.0,1.0),(-3.0,1.0),(-4.0,1.0),(-2.0,2.0),(-2.0,2.0),(0.0,0.0),(1.0,1.0),(1.0,1.0),(1.0,2.0),(0.0,1.0),(0.0,-1.0),(3.0,-2.0),(2.0,-1.0),(3.0,-2.0),(2.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(-3.0,1.0),(-3.0,2.0),(-3.0,1.0),(-1.0,2.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(2.0,-2.0),(2.0,-2.0),(3.0,-1.0),(2.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(-4.0,2.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(3.0,0.0),(-3.0,0.0),(4.0,-1.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-10.0,11.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(2.0,-1.0),(3.0,-2.0),(3.0,-1.0),(1.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,2.0),(-1.0,1.0),(-2.0,1.0),(-3.0,2.0),(-2.0,1.0),(-2.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,-2.0),(3.0,-1.0),(3.0,-2.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,1.0),(-3.0,2.0),(-3.0,1.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-2.0),(3.0,-1.0),(3.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(-3.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(2.0,0.0),(-2.0,0.0),(2.0,-2.0),(-1.0,-13.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-16.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(15.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,0.0),(-3.0,1.0),(-3.0,1.0),(-3.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(3.0,-2.0),(3.0,0.0),(3.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-2.0,0.0),(-4.0,1.0),(-2.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(3.0,0.0),(3.0,-2.0),(3.0,-1.0),(3.0,0.0),(1.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-3.0,0.0),(-3.0,2.0),(-2.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(3.0,-1.0),(3.0,-2.0),(2.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(-2.0,1.0),(3.0,0.0),(-3.0,1.0),(10.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-14.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(14.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-3.0,0.0),(-3.0,2.0),(-3.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,-1.0),(3.0,-1.0),(4.0,-1.0),(2.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-2.0,1.0),(-3.0,1.0),(-3.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(3.0,-1.0),(4.0,-1.0),(2.0,-1.0),(1.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,1.0),(-4.0,1.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(4.0,-2.0),(1.0,0.0),(-1.0,-1.0),(0.0,0.0),(-2.0,1.0),(-2.0,1.0),(2.0,0.0),(-3.0,1.0),(-4.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-11.0,7.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,9.0),(2.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,2.0),(-1.0,1.0),(-2.0,1.0),(-3.0,0.0),(0.0,-1.0),(0.0,-2.0),(3.0,-2.0),(3.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,2.0),(1.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,1.0),(-1.0,1.0),(-2.0,1.0),(-3.0,2.0),(-2.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,-2.0),(0.0,-2.0),(2.0,-1.0),(4.0,-2.0),(2.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(1.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(-2.0,1.0),(-1.0,1.0),(-3.0,2.0),(-3.0,1.0),(-2.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-2.0),(0.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(2.0,-2.0),(2.0,-2.0),(4.0,-1.0),(3.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(-2.0,1.0),(-1.0,1.0),(-3.0,1.0),(-3.0,2.0),(-2.0,2.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-2.0),(-1.0,-2.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(2.0,-2.0),(3.0,-1.0),(4.0,-1.0),(3.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,2.0),(-1.0,1.0),(-2.0,1.0),(-3.0,2.0),(-2.0,1.0),(-3.0,2.0),(0.0,0.0),(0.0,-2.0),(-1.0,-2.0),(-1.0,-1.0),(0.0,-1.0),(1.0,0.0),(2.0,-2.0),(2.0,-2.0),(4.0,-1.0),(3.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(-3.0,1.0),(-3.0,1.0),(-2.0,2.0),(-2.0,1.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(2.0,-2.0),(3.0,-1.0),(3.0,-2.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(-4.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(3.0,-1.0),(-3.0,1.0),(4.0,-1.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-10.0,11.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(2.0,-1.0),(3.0,-2.0),(3.0,-1.0),(1.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,2.0),(-1.0,1.0),(-1.0,1.0),(-3.0,2.0),(-3.0,1.0),(-2.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(2.0,-2.0),(2.0,-1.0),(3.0,-2.0),(2.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(-1.0,2.0),(-3.0,1.0),(-3.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,-2.0),(3.0,-1.0),(3.0,-2.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(-3.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(2.0,0.0),(-2.0,1.0),(2.0,-2.0),(-16.0,-15.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(14.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,0.0),(-3.0,1.0),(-3.0,1.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,-1.0),(4.0,0.0),(2.0,0.0),(2.0,0.0),(1.0,1.0),(1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-2.0,0.0),(-3.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(3.0,0.0),(2.0,0.0),(1.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(-2.0,0.0),(-3.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(2.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(4.0,4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-14.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(3.0,-1.0),(3.0,-2.0),(3.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(-2.0,1.0),(-4.0,1.0),(-3.0,1.0),(-2.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(3.0,-1.0),(3.0,-1.0),(2.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(-2.0,1.0),(-4.0,1.0),(-3.0,1.0),(-2.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(3.0,0.0),(2.0,-2.0),(4.0,-1.0),(2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-2.0,0.0),(-4.0,2.0),(-2.0,0.0),(0.0,-1.0),(0.0,0.0),(3.0,-2.0),(2.0,0.0),(-2.0,1.0),(2.0,0.0),(-7.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-7.0,24.0),(0.0,-1.0),(11.0,-8.0),(-2.0,2.0),(-2.0,1.0),(0.0,1.0),(0.0,1.0),(-6.0,6.0),(0.0,1.0),(0.0,4.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,2.0),(-2.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,-6.0),(0.0,-3.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(2.0,-1.0),(8.0,-5.0),(0.0,-1.0),(5.0,-4.0),(0.0,1.0),(0.0,-2.0),(-1.0,2.0),(0.0,2.0),(-2.0,0.0),(0.0,4.0),(0.0,0.0),(-1.0,3.0),(0.0,4.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,5.0),(-4.0,4.0),(-3.0,3.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-5.0),(2.0,-5.0),(0.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,-3.0),(1.0,-2.0),(0.0,2.0),(0.0,-2.0),(9.0,-3.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(6.0,-2.0),(0.0,1.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-3.0),(0.0,-3.0),(-1.0,4.0),(-1.0,2.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,4.0),(-1.0,3.0),(0.0,4.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,3.0),(-5.0,4.0),(-4.0,4.0),(-2.0,2.0),(0.0,-3.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,-1.0),(0.0,-1.0),(1.0,-6.0),(0.0,-4.0),(0.0,-1.0),(0.0,-1.0),(2.0,-6.0),(0.0,-1.0),(2.0,-2.0),(0.0,-1.0),(-2.0,3.0),(0.0,0.0),(0.0,2.0),(0.0,-1.0),(1.0,-1.0),(1.0,-3.0),(8.0,-3.0),(5.0,-3.0),(1.0,-2.0),(0.0,0.0),(0.0,3.0),(0.0,2.0),(0.0,-2.0),(0.0,0.0),(0.0,-4.0),(1.0,-2.0),(0.0,0.0),(-1.0,4.0),(0.0,2.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,3.0),(-2.0,3.0),(0.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,5.0),(-2.0,4.0),(-6.0,6.0),(-4.0,3.0),(-2.0,1.0),(1.0,-4.0),(4.0,-9.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(-2.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,-3.0),(0.0,-3.0),(1.0,-1.0),(1.0,-4.0),(0.0,-1.0),(1.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(-2.0,2.0),(0.0,0.0),(-1.0,3.0),(1.0,-2.0),(1.0,-3.0),(7.0,-3.0),(5.0,-3.0),(2.0,-3.0),(0.0,0.0),(0.0,3.0),(0.0,-3.0),(0.0,3.0),(0.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,3.0),(-1.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,2.0),(-1.0,1.0),(0.0,4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,3.0),(-1.0,4.0),(-1.0,4.0),(-7.0,6.0),(-4.0,3.0),(-2.0,0.0),(2.0,-4.0),(2.0,-7.0),(2.0,-5.0),(1.0,2.0),(2.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(-2.0,-1.0),(0.0,-2.0),(0.0,-2.0),(2.0,-4.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,-2.0),(-1.0,2.0),(0.0,0.0),(-2.0,2.0),(0.0,-1.0),(0.0,1.0),(1.0,-2.0),(6.0,-3.0),(4.0,-4.0),(2.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,-2.0),(0.0,0.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-1.0,2.0),(-2.0,3.0),(-1.0,4.0),(-1.0,4.0),(-2.0,2.0),(-7.0,6.0),(-3.0,1.0),(-1.0,0.0),(1.0,-5.0),(1.0,-6.0),(3.0,-5.0),(4.0,-8.0),(0.0,-1.0),(-1.0,2.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(2.0,-4.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(5.0,-4.0),(4.0,-3.0),(2.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(-1.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,-9.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,2.0),(-1.0,2.0),(-1.0,3.0),(-2.0,4.0),(0.0,4.0),(-2.0,1.0),(-7.0,6.0),(-3.0,0.0),(0.0,0.0),(0.0,-4.0),(2.0,-6.0),(1.0,-4.0),(0.0,-1.0),(1.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(10.0,-7.0),(1.0,-3.0),(-2.0,2.0),(-4.0,3.0),(-4.0,3.0),(1.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(6.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(1.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,1.0),(0.0,2.0),(0.0,3.0),(0.0,0.0),(0.0,1.0),(0.0,3.0),(-1.0,2.0),(0.0,1.0),(-1.0,3.0),(-2.0,3.0),(0.0,4.0),(-2.0,3.0),(-2.0,1.0),(-8.0,6.0),(-2.0,0.0),(-1.0,-1.0),(0.0,-3.0),(2.0,-6.0),(0.0,-1.0),(2.0,-2.0),(1.0,-2.0),(0.0,-1.0),(0.0,0.0),(1.0,-2.0),(1.0,-2.0),(5.0,-2.0),(0.0,2.0),(5.0,-3.0),(2.0,-4.0),(0.0,-3.0),(0.0,-1.0),(0.0,1.0),(0.0,2.0),(0.0,3.0),(0.0,0.0),(0.0,0.0),(-1.0,4.0),(0.0,2.0),(-2.0,3.0),(-1.0,4.0),(0.0,3.0),(-4.0,2.0),(-9.0,5.0),(-2.0,0.0),(0.0,-1.0),(0.0,-3.0),(2.0,-3.0),(1.0,-2.0),(0.0,-1.0),(0.0,0.0),(1.0,-2.0),(0.0,-2.0),(0.0,2.0),(8.0,-3.0),(5.0,-3.0),(2.0,-3.0),(0.0,0.0),(0.0,-4.0),(0.0,-2.0),(-1.0,3.0),(0.0,4.0),(0.0,0.0),(0.0,0.0),(-1.0,4.0),(-1.0,4.0),(0.0,3.0),(-6.0,3.0),(-9.0,2.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(1.0,-1.0),(8.0,-3.0),(6.0,-3.0),(1.0,-3.0),(0.0,-2.0),(0.0,4.0),(-1.0,0.0),(0.0,0.0),(0.0,3.0),(-1.0,2.0),(-6.0,2.0),(0.0,-1.0),(0.0,-1.0),(7.0,-2.0),(0.0,-1.0),(0.0,1.0),(1.0,0.0),(132.0,110.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(8.0,-4.0),(0.0,0.0),(0.0,0.0),(-3.0,2.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(-12.0,4.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(3.0,-3.0),(0.0,0.0),(0.0,0.0),(4.0,-2.0),(0.0,0.0),(0.0,0.0),(3.0,-3.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(0.0,0.0),(-12.0,8.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(-14.0,3.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(8.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(-14.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,2.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,-1.0),(0.0,0.0),(-13.0,-5.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(-13.0,4.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,1.0),(6.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,1.0),(0.0,0.0),(-14.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,2.0),(0.0,0.0),(0.0,0.0),(3.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,2.0),(0.0,0.0),(0.0,0.0),(3.0,3.0),(2.0,1.0),(0.0,0.0),(0.0,0.0),(-3.0,-2.0),(0.0,0.0),(-10.0,-7.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-10.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,1.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(9.0,3.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(-14.0,-3.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,1.0),(0.0,0.0),(0.0,0.0),(8.0,3.0),(0.0,0.0),(0.0,0.0),(-3.0,-2.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-13.0,0.0),(0.0,0.0),(0.0,0.0),(5.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-5.0,-3.0),(0.0,0.0),(0.0,0.0),(6.0,0.0),(-3.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(-6.0,1.0),(0.0,0.0),(0.0,0.0),(6.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(-8.0,2.0),(0.0,0.0),(0.0,0.0),(6.0,2.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(-6.0,-6.0),(0.0,0.0),(0.0,0.0),(2.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,-3.0),(0.0,0.0),(0.0,0.0),(5.0,-4.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-6.0,8.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(1.0,0.0),(0.0,0.0),(1.0,-3.0),(0.0,0.0),(0.0,0.0),(2.0,-3.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-4.0,9.0),(0.0,0.0),(0.0,0.0),(2.0,-2.0),(0.0,0.0),(0.0,0.0),(2.0,-2.0),(1.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(-9.0,4.0),(0.0,0.0),(0.0,0.0),(2.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,0.0),(0.0,0.0),(5.0,-5.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(-1.0,1.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(-7.0,7.0),(1.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,-3.0),(0.0,0.0),(0.0,0.0),(5.0,-4.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-12.0,7.0),(0.0,0.0),(0.0,0.0),(-3.0,-1.0),(-1.0,0.0),(0.0,0.0),(-3.0,-1.0),(0.0,0.0),(0.0,0.0),(-8.0,-4.0),(0.0,0.0),(0.0,0.0),(3.0,2.0),(2.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(12.0,4.0),(0.0,0.0),(0.0,0.0),(-3.0,-1.0),(0.0,0.0),(0.0,0.0),(-3.0,-3.0),(0.0,0.0),(0.0,0.0),(-8.0,-6.0),(0.0,0.0),(0.0,0.0),(2.0,2.0),(3.0,2.0),(0.0,0.0),(0.0,0.0),(-3.0,-2.0),(1.0,0.0),(11.0,8.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,-1.0),(0.0,0.0),(0.0,0.0),(-4.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(14.0,3.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(14.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,1.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,1.0),(0.0,0.0),(0.0,0.0),(-3.0,2.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(13.0,-5.0),(0.0,0.0),(0.0,0.0),(-4.0,-1.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,-2.0),(2.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(13.0,4.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(14.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,2.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(-8.0,6.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(2.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(0.0,0.0),(10.0,-7.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(10.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(-9.0,3.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(1.0,0.0),(13.0,-3.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(-4.0,1.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(0.0,0.0),(13.0,0.0),(0.0,0.0),(0.0,0.0),(-5.0,1.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(5.0,-3.0),(0.0,0.0),(0.0,0.0),(-6.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(6.0,1.0),(0.0,0.0),(0.0,0.0),(-6.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(8.0,2.0),(0.0,0.0),(0.0,0.0),(-6.0,2.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(5.0,-6.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,-3.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(6.0,8.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,-3.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(4.0,9.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-7.0,-2.0),(0.0,0.0),(0.0,0.0),(2.0,1.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(9.0,4.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,0.0),(0.0,-1.0),(-3.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(1.0,0.0),(6.0,7.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(-1.0,0.0),(0.0,0.0),(-1.0,-3.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-171.0,-95.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-4.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(1.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-2.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,-1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,15.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-3.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,3.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,2.0),(-1.0,0.0),(0.0,1.0),(1.0,0.0),(2.0,0.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,14.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(2.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-2.0,0.0),(0.0,1.0),(-1.0,2.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-2.0),(0.0,-1.0),(1.0,0.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,8.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,2.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-2.0),(-1.0,-1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,3.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(-2.0,0.0),(-1.0,1.0),(0.0,3.0),(0.0,1.0),(2.0,0.0),(1.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,1.0),(0.0,3.0),(1.0,1.0),(2.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(-2.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,0.0),(-1.0,0.0),(5.0,-26.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(-2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(-1.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,7.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,2.0),(1.0,2.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(0.0,-2.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,17.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,0.0),(-2.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,1.0),(2.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(-1.0,0.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(0.0,2.0),(2.0,0.0),(0.0,1.0),(-1.0,3.0),(0.0,0.0),(0.0,-3.0),(0.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,-1.0),(-1.0,1.0),(-27.0,-10.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(1.0,1.0),(2.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,15.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,-3.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(2.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,-1.0),(-1.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,14.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(2.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(0.0,-2.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-2.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,7.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(2.0,0.0),(1.0,0.0),(0.0,-1.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,1.0),(1.0,3.0),(1.0,0.0),(2.0,-1.0),(0.0,-1.0),(-1.0,-2.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,1.0),(0.0,3.0),(2.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,-2.0),(-1.0,0.0),(-1.0,0.0),(0.0,2.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(15.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-7.0,-1.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(4.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-4.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-10.0,-24.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,1.0),(0.0,2.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-2.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(0.0,2.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(0.0,1.0),(-3.0,0.0),(0.0,1.0),(1.0,2.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,2.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(1.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-2.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,6.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,1.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(1.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,2.0),(1.0,1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-2.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(2.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,17.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(2.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(2.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,2.0),(-1.0,1.0),(-2.0,0.0),(0.0,-1.0),(0.0,-3.0),(1.0,-1.0),(2.0,0.0),(0.0,-1.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(-2.0,0.0),(0.0,-1.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(-2.0,0.0),(0.0,-2.0),(0.0,2.0),(20.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(-9.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(86.0,-73.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-10.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(4.0,8.0),(-1.0,-2.0),(-1.0,-2.0),(-1.0,-2.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(2.0,2.0),(1.0,2.0),(1.0,2.0),(0.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,3.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(0.0,2.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(-4.0,-9.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,-9.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-11.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-10.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-7.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-2.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,-1.0),(2.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,-1.0),(1.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,1.0),(-1.0,0.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(2.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-9.0,10.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-8.0,0.0),(-3.0,0.0),(-4.0,1.0),(2.0,1.0),(0.0,0.0),(-3.0,-1.0),(1.0,-1.0),(0.0,0.0),(4.0,0.0),(0.0,-1.0),(0.0,0.0),(4.0,1.0),(2.0,1.0),(0.0,1.0),(-1.0,0.0),(-3.0,0.0),(0.0,1.0),(-3.0,22.0),(2.0,-1.0),(0.0,-1.0),(4.0,-3.0),(0.0,0.0),(0.0,1.0),(-4.0,6.0),(0.0,1.0),(-3.0,0.0),(-3.0,0.0),(0.0,-2.0),(-4.0,-2.0),(5.0,0.0),(3.0,0.0),(0.0,-2.0),(1.0,-3.0),(5.0,-2.0),(2.0,-1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-2.0,3.0),(0.0,2.0),(-4.0,4.0),(-3.0,1.0),(-4.0,0.0),(-4.0,0.0),(0.0,-2.0),(0.0,-2.0),(-2.0,-3.0),(1.0,-1.0),(0.0,0.0),(2.0,1.0),(5.0,-1.0),(0.0,-3.0),(0.0,-5.0),(4.0,0.0),(4.0,-1.0),(-5.0,-13.0),(-2.0,0.0),(3.0,0.0),(0.0,-1.0),(6.0,1.0),(-2.0,0.0),(0.0,1.0),(0.0,1.0),(3.0,11.0),(2.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(-2.0,1.0),(0.0,1.0),(-1.0,3.0),(-4.0,3.0),(-4.0,1.0),(-4.0,0.0),(-5.0,0.0),(-1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(0.0,2.0),(2.0,0.0),(0.0,-4.0),(1.0,-5.0),(5.0,-1.0),(3.0,0.0),(4.0,0.0),(3.0,1.0),(0.0,-3.0),(0.0,-2.0),(-3.0,-1.0),(-2.0,-1.0),(1.0,-2.0),(-5.0,0.0),(-2.0,-1.0),(-1.0,0.0),(1.0,-1.0),(0.0,0.0),(4.0,-1.0),(4.0,1.0),(3.0,1.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,1.0),(0.0,1.0),(2.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(1.0,2.0),(0.0,-1.0),(0.0,2.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,9.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-6.0,7.0),(0.0,0.0),(0.0,-1.0),(3.0,-2.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-2.0),(0.0,-2.0),(4.0,-2.0),(2.0,-4.0),(0.0,3.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(-1.0,3.0),(-1.0,2.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,-3.0),(0.0,-2.0),(4.0,-4.0),(4.0,-3.0),(0.0,-2.0),(1.0,1.0),(0.0,-1.0),(-2.0,2.0),(-4.0,4.0),(-4.0,1.0),(0.0,1.0),(-4.0,0.0),(0.0,-1.0),(-7.0,0.0),(0.0,-2.0),(1.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,-4.0),(6.0,-1.0),(5.0,-2.0),(3.0,0.0),(-4.0,-1.0),(-3.0,0.0),(0.0,-2.0),(-2.0,-1.0),(0.0,0.0),(1.0,-2.0),(3.0,0.0),(-2.0,-1.0),(5.0,0.0),(3.0,0.0),(3.0,2.0),(2.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(1.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,3.0),(0.0,2.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(-2.0,0.0),(2.0,-1.0),(0.0,1.0),(0.0,0.0),(0.0,3.0),(0.0,3.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(-1.0,3.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,3.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(-4.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,-2.0),(0.0,-4.0),(0.0,-1.0),(4.0,-4.0),(0.0,-2.0),(0.0,0.0),(3.0,-1.0),(0.0,1.0),(0.0,1.0),(0.0,3.0),(-4.0,2.0),(-4.0,3.0),(-4.0,1.0),(-6.0,2.0),(-1.0,-2.0),(0.0,-3.0),(0.0,0.0),(1.0,-3.0),(0.0,-2.0),(1.0,-1.0),(2.0,-3.0),(1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-4.0),(0.0,-2.0),(-3.0,0.0),(0.0,0.0),(8.0,-2.0),(4.0,-1.0),(3.0,0.0),(-4.0,-1.0),(-8.0,0.0),(0.0,0.0),(4.0,0.0),(2.0,-2.0),(1.0,-1.0),(4.0,0.0),(1.0,0.0),(2.0,1.0),(3.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(-1.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,4.0),(-1.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(1.0,-2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-4.0,1.0),(-2.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-3.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(0.0,-3.0),(0.0,-1.0),(0.0,-2.0),(3.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-4.0,4.0),(-4.0,2.0),(-7.0,3.0),(2.0,-4.0),(2.0,-5.0),(0.0,-2.0),(1.0,-2.0),(5.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-3.0),(0.0,-4.0),(0.0,0.0),(5.0,0.0),(2.0,0.0),(-3.0,-1.0),(0.0,0.0),(1.0,-1.0),(3.0,0.0),(1.0,0.0),(2.0,1.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,2.0),(-1.0,3.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(-1.0,1.0),(-4.0,2.0),(-1.0,-1.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-2.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,-3.0),(0.0,1.0),(-1.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(-2.0,0.0),(0.0,-2.0),(0.0,-3.0),(4.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-3.0),(1.0,-3.0),(2.0,0.0),(4.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(-1.0,1.0),(-1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-2.0),(0.0,-1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(-1.0,3.0),(-2.0,1.0),(0.0,-3.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(-5.0,2.0),(0.0,-3.0),(0.0,-3.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(-1.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,-2.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(10.0,-2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,2.0),(-1.0,3.0),(0.0,2.0),(0.0,-1.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(-4.0,2.0),(-4.0,2.0),(1.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-3.0),(0.0,-4.0),(0.0,-2.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,-3.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(7.0,-2.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,2.0),(-1.0,1.0),(0.0,3.0),(0.0,2.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,0.0),(-2.0,2.0),(-4.0,1.0),(0.0,-1.0),(-3.0,4.0),(1.0,2.0),(0.0,1.0),(1.0,0.0),(0.0,-4.0),(0.0,-3.0),(0.0,-3.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(5.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,2.0),(-1.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,-2.0),(0.0,-2.0),(-1.0,0.0),(-2.0,1.0),(0.0,-2.0),(-4.0,3.0),(-3.0,4.0),(1.0,1.0),(0.0,1.0),(0.0,-3.0),(1.0,-3.0),(0.0,-1.0),(1.0,1.0),(0.0,0.0),(7.0,-3.0),(0.0,-2.0),(0.0,-1.0),(-13.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-3.0),(4.0,-6.0),(-1.0,1.0),(-4.0,0.0),(1.0,-2.0),(-3.0,0.0),(0.0,-1.0),(1.0,-1.0),(2.0,0.0),(0.0,0.0),(3.0,0.0),(4.0,0.0),(0.0,-1.0),(0.0,0.0),(3.0,1.0),(2.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,1.0),(-3.0,6.0),(-1.0,3.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(10.0,0.0),(0.0,0.0),(0.0,2.0),(-1.0,2.0),(0.0,1.0),(0.0,-2.0),(0.0,-3.0),(-1.0,0.0),(0.0,0.0),(-2.0,2.0),(-4.0,2.0),(0.0,0.0),(-1.0,0.0),(-2.0,3.0),(1.0,1.0),(0.0,-3.0),(0.0,-2.0),(-1.0,0.0),(-4.0,1.0),(-4.0,1.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-4.0),(0.0,-3.0),(5.0,-2.0),(5.0,0.0),(1.0,0.0),(0.0,0.0),(-3.0,0.0),(-9.0,0.0),(0.0,0.0),(4.0,0.0),(1.0,-2.0),(2.0,-1.0),(5.0,0.0),(2.0,0.0),(1.0,-1.0),(0.0,0.0),(2.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,-2.0),(0.0,0.0),(-3.0,3.0),(0.0,1.0),(-4.0,1.0),(-1.0,0.0),(-3.0,1.0),(-3.0,5.0),(0.0,-4.0),(-7.0,4.0),(0.0,-3.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(1.0,-4.0),(0.0,-4.0),(7.0,-3.0),(4.0,0.0),(0.0,0.0),(3.0,0.0),(-4.0,0.0),(0.0,0.0),(2.0,-1.0),(3.0,1.0),(3.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,2.0),(0.0,1.0),(0.0,1.0),(-3.0,2.0),(-4.0,1.0),(-4.0,4.0),(0.0,3.0),(-4.0,1.0),(-6.0,2.0),(-1.0,-1.0),(0.0,-4.0),(1.0,-4.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(0.0,-4.0),(0.0,-4.0),(7.0,-1.0),(-1.0,1.0),(5.0,-1.0),(4.0,0.0),(3.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,3.0),(-1.0,1.0),(-1.0,2.0),(-2.0,2.0),(-4.0,2.0),(-4.0,2.0),(-4.0,1.0),(-7.0,1.0),(0.0,-3.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-5.0),(0.0,-3.0),(3.0,0.0),(5.0,-1.0),(3.0,0.0),(4.0,0.0),(3.0,1.0),(2.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,2.0),(1.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,3.0),(-1.0,2.0),(-1.0,1.0),(-2.0,2.0),(-4.0,4.0),(-4.0,1.0),(-4.0,0.0),(-6.0,0.0),(2.0,-1.0),(1.0,0.0),(0.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-3.0),(0.0,-4.0),(5.0,-2.0),(4.0,0.0),(5.0,-1.0),(2.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-2.0,1.0),(-1.0,3.0),(-4.0,3.0),(-4.0,1.0),(-3.0,0.0),(0.0,0.0),(0.0,-2.0),(1.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,-3.0),(4.0,0.0),(5.0,-2.0),(2.0,-2.0),(2.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(-2.0,1.0),(-2.0,3.0),(-4.0,4.0),(-2.0,0.0),(0.0,-2.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(2.0,0.0),(5.0,-4.0),(1.0,-2.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-2.0,3.0),(-4.0,4.0),(0.0,-1.0),(0.0,-2.0),(5.0,-4.0),(0.0,-1.0),(9.0,-37.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(2.0,1.0),(1.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,4.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-5.0,0.0),(0.0,2.0),(-1.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-3.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,1.0),(0.0,3.0),(0.0,1.0),(0.0,0.0),(3.0,-2.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(5.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-4.0,3.0),(-4.0,1.0),(-2.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-2.0),(-2.0,-3.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,3.0),(0.0,2.0),(-1.0,0.0),(0.0,0.0),(3.0,0.0),(4.0,-2.0),(4.0,-2.0),(1.0,0.0),(1.0,0.0),(2.0,2.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,-2.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(-3.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,1.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(3.0,0.0),(0.0,0.0),(3.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,-3.0),(-3.0,0.0),(0.0,-1.0),(-2.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(3.0,3.0),(0.0,1.0),(3.0,0.0),(1.0,3.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,-4.0),(0.0,0.0),(-1.0,-2.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(1.0,2.0),(0.0,0.0),(0.0,3.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-5.0,-5.0),(5.0,7.0),(-36.0,28.0),(-7.0,0.0),(-6.0,0.0),(-1.0,-1.0),(5.0,0.0),(8.0,0.0),(7.0,0.0),(4.0,-5.0),(2.0,-14.0),(3.0,-4.0),(0.0,1.0),(0.0,0.0),(-2.0,6.0),(0.0,3.0),(-1.0,13.0),(-5.0,3.0),(0.0,0.0),(-3.0,2.0),(-1.0,0.0),(-5.0,0.0),(-6.0,-1.0),(-6.0,-3.0),(-25.0,-21.0),(21.0,19.0),(0.0,0.0),(3.0,0.0),(5.0,0.0),(6.0,0.0),(-4.0,-5.0),(7.0,0.0),(4.0,4.0),(4.0,-7.0),(4.0,-11.0),(5.0,-7.0),(2.0,-1.0),(-2.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,3.0),(0.0,1.0),(-1.0,2.0),(-1.0,6.0),(-1.0,12.0),(0.0,1.0),(-5.0,3.0),(-3.0,3.0),(-2.0,2.0),(-1.0,0.0),(0.0,1.0),(-3.0,-2.0),(2.0,5.0),(-8.0,-6.0),(-7.0,-3.0),(-4.0,-3.0),(-28.0,-18.0),(46.0,19.0),(-7.0,0.0),(0.0,3.0),(6.0,0.0),(5.0,0.0),(1.0,0.0),(2.0,-3.0),(0.0,0.0),(6.0,-3.0),(1.0,-13.0),(1.0,-9.0),(0.0,0.0),(0.0,0.0),(-3.0,5.0),(0.0,2.0),(-3.0,12.0),(-4.0,5.0),(-7.0,0.0),(-8.0,0.0),(-4.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,3.0),(7.0,3.0),(7.0,5.0),(-2.0,-5.0),(4.0,2.0),(0.0,-1.0),(1.0,0.0),(2.0,-3.0),(3.0,-3.0),(4.0,-3.0),(0.0,-1.0),(2.0,-12.0),(1.0,-6.0),(1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(-3.0,2.0),(-5.0,7.0),(-4.0,11.0),(-4.0,6.0),(-4.0,-4.0),(-6.0,1.0),(4.0,4.0),(-7.0,0.0),(-5.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,2.0),(-29.0,-19.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(7.0,-3.0),(5.0,-4.0),(0.0,0.0),(0.0,0.0),(-6.0,5.0),(-7.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,1.0),(1.0,1.0),(2.0,2.0),(3.0,2.0),(1.0,1.0),(0.0,0.0),(2.0,1.0),(5.0,2.0),(1.0,0.0),(4.0,2.0),(2.0,1.0),(1.0,0.0),(3.0,0.0),(0.0,0.0),(2.0,-1.0),(4.0,0.0),(0.0,-1.0),(6.0,-1.0),(6.0,-1.0),(5.0,-5.0),(1.0,0.0),(6.0,-11.0),(7.0,-6.0),(10.0,0.0),(-4.0,0.0),(-3.0,1.0),(1.0,0.0),(-2.0,1.0),(-2.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(-1.0,6.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(0.0,5.0),(-1.0,0.0),(0.0,0.0),(-1.0,2.0),(0.0,-1.0),(-4.0,5.0),(-2.0,3.0),(-4.0,2.0),(0.0,1.0),(0.0,4.0),(0.0,4.0),(-1.0,0.0),(-6.0,-8.0),(-11.0,-6.0),(-3.0,-3.0),(-7.0,-6.0),(-1.0,0.0),(-2.0,-1.0),(-6.0,-1.0),(-3.0,0.0),(-5.0,-1.0),(-3.0,-2.0),(-1.0,0.0),(-1.0,-1.0),(-3.0,-2.0),(-4.0,-2.0),(-1.0,-1.0),(-3.0,-1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(34.0,13.0),(7.0,6.0),(3.0,3.0),(11.0,6.0),(6.0,7.0),(0.0,0.0),(0.0,-5.0),(0.0,-4.0),(1.0,-1.0),(4.0,-2.0),(2.0,-3.0),(4.0,-4.0),(0.0,1.0),(1.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,-6.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-2.0),(0.0,-2.0),(2.0,-6.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-3.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(2.0,-2.0),(2.0,-1.0),(5.0,0.0),(-4.0,0.0),(-4.0,0.0),(-3.0,0.0),(-7.0,7.0),(-6.0,10.0),(-1.0,0.0),(-5.0,6.0),(-6.0,1.0),(-6.0,1.0),(0.0,1.0),(-4.0,0.0),(-2.0,0.0),(0.0,0.0),(-3.0,0.0),(-1.0,0.0),(0.0,2.0),(-2.0,-1.0),(-6.0,-1.0),(-3.0,0.0),(-5.0,-1.0),(-3.0,-2.0),(-1.0,0.0),(-1.0,-1.0),(-3.0,-2.0),(-4.0,-2.0),(-1.0,-1.0),(-3.0,-1.0),(0.0,-1.0),(10.0,-3.0),(8.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(6.0,-5.0),(5.0,-4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-6.0,5.0),(-5.0,5.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,1.0),(2.0,1.0),(1.0,1.0),(0.0,0.0),(1.0,1.0),(2.0,1.0),(5.0,3.0),(3.0,-1.0),(0.0,0.0),(-2.0,2.0),(4.0,4.0),(1.0,0.0),(3.0,-1.0),(6.0,-1.0),(7.0,-1.0),(5.0,-6.0),(6.0,-10.0),(0.0,0.0),(7.0,-7.0),(9.0,0.0),(0.0,0.0),(0.0,2.0),(3.0,0.0),(1.0,1.0),(-1.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-3.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,2.0),(-2.0,2.0),(0.0,1.0),(-1.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(1.0,1.0),(0.0,1.0),(0.0,3.0),(-1.0,8.0),(-1.0,5.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,2.0),(-2.0,3.0),(-2.0,3.0),(-3.0,3.0),(-2.0,0.0),(-1.0,4.0),(0.0,3.0),(-1.0,0.0),(-6.0,-7.0),(-11.0,-7.0),(-2.0,-2.0),(-7.0,-6.0),(-3.0,-2.0),(-4.0,0.0),(-2.0,1.0),(-5.0,0.0),(-4.0,-2.0),(-4.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(-4.0,-2.0),(-3.0,-2.0),(0.0,0.0),(-2.0,-1.0),(-4.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,1.0),(4.0,0.0),(2.0,1.0),(0.0,0.0),(3.0,2.0),(4.0,2.0),(1.0,0.0),(1.0,1.0),(4.0,1.0),(4.0,1.0),(5.0,-1.0),(2.0,0.0),(4.0,1.0),(3.0,2.0),(7.0,6.0),(2.0,2.0),(11.0,7.0),(6.0,6.0),(1.0,-1.0),(0.0,-3.0),(1.0,-4.0),(2.0,0.0),(3.0,-3.0),(2.0,-3.0),(2.0,-3.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(1.0,-5.0),(0.0,-8.0),(-1.0,-3.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(2.0,-2.0),(1.0,-2.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(3.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(-3.0,0.0),(0.0,-1.0),(0.0,0.0),(-9.0,1.0),(-7.0,7.0),(0.0,0.0),(-6.0,10.0),(-5.0,6.0),(-7.0,1.0),(-6.0,1.0),(-3.0,0.0),(-1.0,0.0),(-7.0,0.0),(-4.0,-2.0),(-1.0,0.0),(-5.0,-2.0),(-2.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-3.0,-2.0),(-2.0,-2.0),(-1.0,-1.0),(0.0,-1.0),(7.0,-3.0),(6.0,-4.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(6.0,-5.0),(5.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(-6.0,3.0),(-6.0,4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(1.0,1.0),(1.0,2.0),(1.0,0.0),(1.0,1.0),(2.0,1.0),(2.0,2.0),(0.0,0.0),(4.0,-1.0),(0.0,4.0),(0.0,1.0),(1.0,4.0),(6.0,-1.0),(6.0,-1.0),(6.0,-6.0),(7.0,-10.0),(7.0,-8.0),(0.0,2.0),(0.0,0.0),(8.0,0.0),(4.0,1.0),(2.0,1.0),(1.0,1.0),(1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,-2.0),(-1.0,0.0),(-2.0,0.0),(-2.0,0.0),(-1.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(-2.0,4.0),(-1.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,4.0),(-1.0,9.0),(0.0,4.0),(-1.0,2.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,3.0),(-1.0,3.0),(-4.0,3.0),(-2.0,1.0),(0.0,3.0),(0.0,3.0),(-2.0,0.0),(-6.0,-7.0),(-11.0,-7.0),(-2.0,-1.0),(-6.0,-7.0),(-4.0,-1.0),(-2.0,0.0),(-2.0,0.0),(-4.0,0.0),(-6.0,0.0),(-4.0,-1.0),(-1.0,-1.0),(-2.0,-1.0),(-3.0,-1.0),(-2.0,-1.0),(-1.0,-1.0),(-2.0,0.0),(-5.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(1.0,1.0),(1.0,0.0),(1.0,0.0),(5.0,1.0),(2.0,0.0),(1.0,1.0),(2.0,1.0),(3.0,1.0),(2.0,1.0),(1.0,1.0),(4.0,0.0),(6.0,0.0),(4.0,0.0),(2.0,0.0),(2.0,0.0),(4.0,2.0),(6.0,7.0),(2.0,1.0),(11.0,7.0),(6.0,6.0),(1.0,-1.0),(0.0,-3.0),(1.0,-3.0),(2.0,-1.0),(4.0,-3.0),(1.0,-3.0),(2.0,-3.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-2.0),(1.0,-2.0),(0.0,-4.0),(0.0,-9.0),(0.0,-4.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(1.0,-2.0),(1.0,-1.0),(2.0,-4.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,1.0),(2.0,0.0),(1.0,0.0),(0.0,1.0),(1.0,-1.0),(1.0,-1.0),(-1.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(-2.0,-1.0),(-4.0,-1.0),(-7.0,0.0),(0.0,-1.0),(0.0,2.0),(-8.0,7.0),(-7.0,10.0),(-6.0,6.0),(-6.0,1.0),(-6.0,0.0),(-1.0,-4.0),(-3.0,0.0),(0.0,0.0),(-3.0,1.0),(-1.0,0.0),(-5.0,-4.0),(-2.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-2.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,-1.0),(5.0,-5.0),(0.0,0.0),(5.0,-3.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(6.0,-3.0),(7.0,-4.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(-8.0,4.0),(-5.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,1.0),(1.0,0.0),(1.0,2.0),(1.0,1.0),(1.0,2.0),(2.0,2.0),(2.0,2.0),(6.0,-1.0),(0.0,1.0),(2.0,5.0),(1.0,0.0),(9.0,-5.0),(7.0,-11.0),(0.0,0.0),(8.0,-7.0),(9.0,0.0),(0.0,1.0),(0.0,2.0),(4.0,1.0),(2.0,2.0),(1.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-4.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-3.0,4.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(0.0,5.0),(-1.0,8.0),(0.0,3.0),(-1.0,3.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,3.0),(-1.0,3.0),(-4.0,3.0),(-2.0,1.0),(0.0,3.0),(-1.0,2.0),(-1.0,0.0),(-6.0,-7.0),(-11.0,-6.0),(-1.0,-1.0),(-8.0,-7.0),(-3.0,-2.0),(-2.0,0.0),(-2.0,1.0),(-4.0,0.0),(-6.0,0.0),(-4.0,-2.0),(-1.0,0.0),(-1.0,-1.0),(-4.0,-2.0),(-2.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-5.0,-1.0),(-1.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,1.0),(5.0,1.0),(2.0,0.0),(1.0,1.0),(2.0,0.0),(4.0,2.0),(1.0,1.0),(1.0,0.0),(4.0,1.0),(6.0,0.0),(4.0,-1.0),(2.0,0.0),(2.0,1.0),(3.0,2.0),(8.0,7.0),(1.0,1.0),(11.0,6.0),(6.0,6.0),(1.0,0.0),(1.0,-3.0),(0.0,-3.0),(2.0,-1.0),(4.0,-3.0),(1.0,-3.0),(2.0,-3.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-2.0),(1.0,-3.0),(0.0,-3.0),(0.0,-8.0),(0.0,-5.0),(0.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(1.0,-1.0),(3.0,-3.0),(1.0,0.0),(1.0,0.0),(4.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,-1.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(-1.0,-1.0),(-2.0,-2.0),(-4.0,-1.0),(0.0,-2.0),(0.0,0.0),(-9.0,1.0),(-8.0,7.0),(0.0,0.0),(-7.0,11.0),(-9.0,4.0),(-1.0,-1.0),(-8.0,0.0),(0.0,-3.0),(-4.0,1.0),(0.0,0.0),(-2.0,-3.0),(-2.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(-1.0,-2.0),(-1.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(4.0,-4.0),(0.0,-1.0),(6.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(8.0,-4.0),(6.0,-3.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-7.0,3.0),(-7.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(1.0,0.0),(3.0,4.0),(1.0,1.0),(7.0,-4.0),(0.0,0.0),(1.0,1.0),(2.0,3.0),(1.0,1.0),(2.0,4.0),(8.0,-11.0),(8.0,-6.0),(9.0,0.0),(4.0,1.0),(0.0,1.0),(2.0,3.0),(2.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(-7.0,-1.0),(-4.0,5.0),(0.0,14.0),(-1.0,11.0),(-1.0,0.0),(-7.0,7.0),(-4.0,5.0),(-11.0,-9.0),(-19.0,-10.0),(-14.0,-2.0),(-7.0,-4.0),(-5.0,-1.0),(5.0,0.0),(-5.0,0.0),(6.0,2.0),(7.0,4.0),(14.0,2.0),(19.0,10.0),(11.0,8.0),(4.0,-6.0),(7.0,-7.0),(1.0,0.0),(1.0,-11.0),(0.0,-14.0),(4.0,-4.0),(7.0,1.0),(3.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-2.0,-1.0),(-2.0,-3.0),(0.0,-1.0),(-4.0,0.0),(-9.0,1.0),(-8.0,6.0),(-8.0,10.0),(-2.0,-4.0),(-9.0,4.0),(0.0,0.0),(-6.0,1.0),(-2.0,-3.0),(-2.0,-2.0),(-1.0,-2.0),(-1.0,-1.0),(-1.0,-2.0),(-1.0,0.0),(0.0,-1.0),(6.0,-4.0),(0.0,0.0),(7.0,-4.0),(1.0,0.0),(6.0,-3.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-5.0,1.0),(-6.0,2.0),(0.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,1.0),(1.0,2.0),(8.0,-7.0),(1.0,1.0),(0.0,0.0),(1.0,1.0),(1.0,3.0),(1.0,0.0),(2.0,0.0),(9.0,-5.0),(9.0,0.0),(5.0,1.0),(2.0,2.0),(0.0,1.0),(2.0,3.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-4.0,0.0),(-1.0,1.0),(2.0,-1.0),(4.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-3.0),(0.0,-1.0),(-3.0,-2.0),(-5.0,0.0),(-9.0,1.0),(-9.0,5.0),(-2.0,0.0),(-8.0,6.0),(-2.0,-3.0),(-1.0,0.0),(-7.0,4.0),(-1.0,-2.0),(-3.0,-4.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(8.0,-6.0),(0.0,-1.0),(6.0,-3.0),(0.0,0.0),(5.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-4.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(9.0,-2.0),(0.0,0.0),(0.0,2.0),(1.0,0.0),(7.0,0.0),(0.0,1.0),(0.0,1.0),(-6.0,0.0),(3.0,0.0),(10.0,0.0),(6.0,1.0),(3.0,2.0),(2.0,4.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(-2.0,-4.0),(-3.0,-2.0),(-6.0,0.0),(-9.0,0.0),(3.0,-1.0),(0.0,1.0),(-7.0,0.0),(-7.0,5.0),(-1.0,-3.0),(-1.0,0.0),(0.0,0.0),(-8.0,7.0),(-1.0,-1.0),(0.0,-3.0),(0.0,-1.0),(-2.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(7.0,-4.0),(0.0,0.0),(5.0,-2.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,0.0),(1.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,2.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(8.0,-1.0),(1.0,-1.0),(1.0,0.0),(1.0,1.0),(0.0,1.0),(3.0,1.0),(-1.0,2.0),(0.0,0.0),(1.0,1.0),(5.0,0.0),(5.0,1.0),(2.0,3.0),(1.0,1.0),(0.0,3.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-3.0),(-1.0,-1.0),(-2.0,-3.0),(-5.0,-1.0),(-5.0,0.0),(-1.0,-1.0),(0.0,0.0),(-4.0,0.0),(-7.0,0.0),(0.0,-1.0),(0.0,-1.0),(-9.0,4.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(6.0,-2.0),(0.0,0.0),(3.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(3.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,1.0),(0.0,0.0),(4.0,0.0),(1.0,0.0),(1.0,0.0),(2.0,0.0),(1.0,1.0),(2.0,1.0),(0.0,2.0),(4.0,2.0),(3.0,2.0),(1.0,2.0),(1.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-3.0),(0.0,-2.0),(-2.0,-1.0),(-1.0,-2.0),(-3.0,-2.0),(-4.0,-2.0),(-3.0,-2.0),(-4.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-9.0,2.0),(-1.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,-2.0),(4.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(4.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(2.0,0.0),(3.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(2.0,1.0),(4.0,2.0),(0.0,2.0),(3.0,3.0),(1.0,1.0),(1.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(-1.0,-2.0),(-1.0,-1.0),(-3.0,-3.0),(-3.0,-3.0),(-3.0,-1.0),(-1.0,0.0),(-2.0,0.0),(-4.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,-1.0),(-2.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(-4.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(6.0,0.0),(1.0,-1.0),(1.0,0.0),(2.0,0.0),(2.0,1.0),(3.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,1.0),(4.0,4.0),(2.0,1.0),(1.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,-1.0),(-1.0,-2.0),(-3.0,-4.0),(-4.0,-2.0),(-2.0,-1.0),(-1.0,0.0),(-3.0,0.0),(-1.0,0.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(5.0,1.0),(5.0,3.0),(2.0,3.0),(0.0,0.0),(0.0,0.0),(-1.0,-3.0),(-4.0,-4.0),(-1.0,-1.0),(-1.0,0.0),(-3.0,-1.0),(0.0,0.0),(-2.0,0.0),(-1.0,1.0),(1.0,1.0),(0.0,0.0),(5.0,2.0),(4.0,2.0),(0.0,-1.0),(-4.0,-3.0),(-1.0,0.0),(-1.0,-1.0),(6.0,15.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,5.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-9.0,10.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-15.0,-22.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(0.0,1.0),(2.0,0.0),(1.0,1.0),(0.0,1.0),(-1.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(-2.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(3.0,0.0),(2.0,1.0),(1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,0.0),(-1.0,0.0),(-2.0,0.0),(-4.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(4.0,1.0),(3.0,0.0),(2.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-2.0,0.0),(-3.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(4.0,0.0),(3.0,1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(-4.0,0.0),(-2.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(3.0,0.0),(3.0,0.0),(4.0,1.0),(2.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,0.0),(-4.0,0.0),(-2.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(3.0,0.0),(3.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-5.0,0.0),(-2.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(2.0,0.0),(-2.0,1.0),(15.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(118.0,221.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,-15.0),(4.0,16.0),(-3.0,-18.0),(3.0,16.0),(-4.0,-17.0),(4.0,16.0),(-5.0,-17.0),(3.0,15.0),(-5.0,-16.0),(4.0,16.0),(-5.0,-16.0),(3.0,16.0),(-4.0,-14.0),(3.0,15.0),(-4.0,-14.0),(4.0,16.0),(-3.0,-14.0),(3.0,16.0),(-2.0,-15.0),(4.0,16.0),(-2.0,-15.0),(4.0,16.0),(1.0,-1.0),(-4.0,-16.0),(1.0,1.0),(2.0,-2.0),(0.0,-3.0),(-1.0,-2.0),(-2.0,-2.0),(-2.0,0.0),(-3.0,0.0),(-1.0,2.0),(0.0,3.0),(1.0,3.0),(1.0,2.0),(3.0,0.0),(1.0,1.0),(3.0,-1.0),(2.0,-2.0),(0.0,-4.0),(-1.0,-3.0),(-3.0,-3.0),(-3.0,0.0),(-3.0,1.0),(-2.0,2.0),(0.0,3.0),(1.0,4.0),(2.0,3.0),(0.0,0.0),(4.0,1.0),(4.0,-1.0),(3.0,-3.0),(0.0,-4.0),(-1.0,-4.0),(-3.0,-4.0),(-4.0,0.0),(-4.0,1.0),(-3.0,3.0),(0.0,4.0),(1.0,4.0),(1.0,0.0),(3.0,4.0),(4.0,0.0),(4.0,-1.0),(3.0,-3.0),(0.0,-5.0),(-1.0,-4.0),(-3.0,-4.0),(-5.0,0.0),(-4.0,1.0),(-3.0,3.0),(0.0,4.0),(1.0,0.0),(0.0,0.0),(1.0,5.0),(4.0,3.0),(4.0,1.0),(4.0,-1.0),(4.0,-4.0),(0.0,-4.0),(-2.0,-5.0),(-3.0,-3.0),(-5.0,-1.0),(-4.0,1.0),(-2.0,3.0),(1.0,0.0),(0.0,0.0),(0.0,4.0),(1.0,4.0),(-1.0,1.0),(4.0,4.0),(4.0,0.0),(4.0,-1.0),(3.0,-3.0),(0.0,-5.0),(-1.0,-4.0),(-3.0,-4.0),(-5.0,0.0),(-3.0,1.0),(1.0,0.0),(0.0,1.0),(-2.0,2.0),(0.0,4.0),(1.0,3.0),(2.0,3.0),(0.0,2.0),(4.0,0.0),(4.0,-1.0),(2.0,-3.0),(0.0,-4.0),(-1.0,-4.0),(-3.0,-3.0),(-3.0,-1.0),(0.0,1.0),(0.0,1.0),(-2.0,1.0),(-1.0,2.0),(0.0,3.0),(0.0,2.0),(2.0,2.0),(2.0,1.0),(0.0,1.0),(4.0,-1.0),(2.0,-2.0),(0.0,-4.0),(-1.0,-3.0),(-3.0,-2.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(-2.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(1.0,1.0),(2.0,1.0),(2.0,0.0),(0.0,1.0),(2.0,-2.0),(0.0,-3.0),(-1.0,-2.0),(-1.0,1.0),(-2.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,-1.0),(2.0,1.0),(16.0,20.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,-16.0),(-4.0,15.0),(3.0,-14.0),(-3.0,16.0),(4.0,-14.0),(-4.0,15.0),(5.0,-14.0),(-4.0,16.0),(5.0,-15.0),(-3.0,15.0),(5.0,-16.0),(-4.0,15.0),(5.0,-16.0),(-3.0,15.0),(4.0,-17.0),(-4.0,16.0),(3.0,-17.0),(-3.0,15.0),(2.0,-17.0),(-3.0,16.0),(2.0,-16.0),(-5.0,16.0),(0.0,0.0),(3.0,-16.0),(-1.0,-1.0),(-2.0,2.0),(0.0,2.0),(1.0,3.0),(1.0,1.0),(3.0,0.0),(2.0,0.0),(2.0,-2.0),(0.0,-3.0),(0.0,-3.0),(-2.0,-2.0),(-3.0,0.0),(0.0,-1.0),(-4.0,1.0),(-2.0,3.0),(0.0,3.0),(1.0,4.0),(2.0,2.0),(3.0,0.0),(4.0,-1.0),(2.0,-3.0),(0.0,-4.0),(-1.0,-3.0),(-2.0,-2.0),(0.0,-2.0),(-4.0,0.0),(-4.0,1.0),(-3.0,4.0),(0.0,4.0),(1.0,4.0),(3.0,3.0),(3.0,0.0),(4.0,-2.0),(3.0,-3.0),(1.0,-4.0),(-1.0,-4.0),(0.0,-1.0),(-3.0,-3.0),(-5.0,0.0),(-4.0,1.0),(-3.0,4.0),(-1.0,4.0),(1.0,5.0),(3.0,3.0),(5.0,0.0),(4.0,-1.0),(3.0,-4.0),(1.0,-4.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-5.0),(-3.0,-3.0),(-4.0,0.0),(-5.0,2.0),(-3.0,3.0),(-1.0,5.0),(1.0,4.0),(3.0,4.0),(5.0,0.0),(4.0,-2.0),(3.0,-3.0),(-1.0,-1.0),(-1.0,-1.0),(1.0,-4.0),(0.0,-4.0),(0.0,0.0),(-3.0,-3.0),(-4.0,0.0),(-5.0,1.0),(-3.0,4.0),(0.0,4.0),(1.0,5.0),(3.0,3.0),(4.0,0.0),(3.0,-1.0),(-1.0,-1.0),(0.0,-2.0),(2.0,-3.0),(0.0,-3.0),(0.0,-4.0),(-2.0,-2.0),(1.0,-1.0),(-4.0,0.0),(-4.0,2.0),(-3.0,3.0),(0.0,4.0),(1.0,4.0),(2.0,3.0),(3.0,0.0),(0.0,-2.0),(0.0,-2.0),(3.0,-1.0),(1.0,-2.0),(0.0,-2.0),(0.0,-3.0),(-2.0,-2.0),(-2.0,-1.0),(0.0,0.0),(-3.0,1.0),(-3.0,3.0),(0.0,3.0),(1.0,4.0),(2.0,1.0),(1.0,-1.0),(0.0,-2.0),(2.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,-1.0),(-2.0,0.0),(-2.0,0.0),(0.0,-1.0),(-2.0,2.0),(0.0,3.0),(1.0,2.0),(1.0,-2.0),(2.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(1.0,1.0),(-2.0,1.0),(-117.0,13.0),(1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,-2.0),(0.0,0.0),(2.0,-1.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-4.0,5.0),(2.0,-1.0),(0.0,0.0),(-3.0,1.0),(0.0,-2.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,8.0),(0.0,-2.0),(0.0,1.0),(-1.0,1.0),(-1.0,-2.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,9.0),(1.0,-1.0),(0.0,0.0),(-1.0,1.0),(-2.0,-1.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(26.0,-4.0),(2.0,0.0),(0.0,-1.0),(-2.0,0.0),(0.0,-2.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,5.0),(2.0,1.0),(0.0,0.0),(-2.0,-2.0),(1.0,-1.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,7.0),(1.0,2.0),(-1.0,0.0),(0.0,-3.0),(1.0,-1.0),(1.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,7.0),(0.0,2.0),(0.0,0.0),(0.0,-2.0),(1.0,-1.0),(1.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-78.0,-13.0),(0.0,0.0),(-1.0,0.0),(0.0,3.0),(-2.0,0.0),(0.0,-2.0),(-2.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,2.0),(1.0,1.0),(-33.0,34.0),(33.0,-34.0),(-1.0,0.0),(-1.0,-2.0),(-2.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,2.0),(2.0,1.0),(0.0,0.0),(0.0,0.0),(-34.0,32.0),(2.0,0.0),(34.0,-34.0),(2.0,-1.0),(-33.0,35.0),(0.0,0.0),(35.0,-37.0),(0.0,0.0),(2.0,0.0),(1.0,-1.0),(-2.0,-1.0),(-30.0,39.0),(30.0,-39.0),(-29.0,39.0),(28.0,-40.0),(-28.0,40.0),(28.0,-40.0),(-28.0,40.0),(26.0,-40.0),(-30.0,40.0),(30.0,-38.0),(-27.0,38.0),(24.0,-40.0),(-24.0,40.0),(23.0,-40.0),(-23.0,40.0),(22.0,-39.0),(-25.0,39.0),(24.0,-37.0),(-28.0,37.0),(29.0,-35.0),(-27.0,35.0),(25.0,-36.0),(-26.0,36.0),(24.0,-35.0),(-25.0,35.0),(25.0,-35.0),(-28.0,35.0),(30.0,-33.0),(-32.0,33.0),(34.0,-31.0),(-1.0,0.0),(2.0,0.0),(1.0,1.0),(0.0,0.0),(-38.0,30.0),(39.0,-30.0),(-38.0,30.0),(37.0,-32.0),(-35.0,32.0),(36.0,-33.0),(-34.0,33.0),(36.0,-35.0),(-34.0,35.0),(35.0,-35.0),(-34.0,35.0),(36.0,-36.0),(-36.0,36.0),(1.0,0.0),(37.0,-37.0),(0.0,0.0),(-35.0,37.0),(0.0,0.0),(3.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,0.0),(-1.0,0.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(-3.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(32.0,-31.0),(-32.0,31.0),(33.0,-30.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(4.0,2.0),(0.0,-1.0),(0.0,0.0),(-42.0,28.0),(1.0,0.0),(42.0,-28.0),(-44.0,28.0),(45.0,-27.0),(-43.0,27.0),(46.0,-29.0),(-42.0,29.0),(44.0,-32.0),(0.0,-2.0),(-40.0,34.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(5.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-4.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(33.0,-30.0),(-35.0,30.0),(37.0,-28.0),(4.0,2.0),(-45.0,26.0),(1.0,0.0),(2.0,0.0),(4.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,-2.0),(7.0,0.0),(5.0,-1.0),(4.0,-1.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(-5.0,1.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(-1.0,0.0),(1.0,5.0),(-2.0,0.0),(0.0,0.0),(-3.0,0.0),(1.0,0.0),(2.0,0.0),(-1.0,0.0),(-1.0,-3.0),(-4.0,-4.0),(2.0,-1.0),(3.0,0.0),(2.0,3.0),(8.0,-1.0),(4.0,-1.0),(2.0,-2.0),(0.0,-2.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(-1.0,0.0),(-3.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(-4.0,2.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,1.0),(-1.0,2.0),(2.0,4.0),(-2.0,2.0),(0.0,1.0),(0.0,0.0),(-2.0,-1.0),(-4.0,-6.0),(0.0,-1.0),(2.0,0.0),(3.0,-2.0),(2.0,0.0),(2.0,0.0),(0.0,1.0),(0.0,1.0),(6.0,-2.0),(2.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,1.0),(-2.0,0.0),(-3.0,2.0),(-1.0,3.0),(-1.0,4.0),(-1.0,3.0),(-4.0,-6.0),(0.0,-2.0),(0.0,-3.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,0.0),(2.0,0.0),(2.0,0.0),(3.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,0.0),(-2.0,1.0),(-3.0,0.0),(-2.0,1.0),(-3.0,3.0),(0.0,-2.0),(0.0,-3.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,1.0),(2.0,0.0),(3.0,0.0),(1.0,0.0),(4.0,-1.0),(2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(-1.0,2.0),(-2.0,0.0),(-2.0,0.0),(-2.0,0.0),(-3.0,1.0),(-2.0,0.0),(-1.0,-3.0),(-1.0,-3.0),(-2.0,0.0),(1.0,1.0),(2.0,1.0),(3.0,1.0),(4.0,1.0),(5.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,0.0),(-3.0,0.0),(-3.0,0.0),(-1.0,0.0),(-2.0,0.0),(-2.0,-12.0),(-3.0,0.0),(1.0,0.0),(3.0,1.0),(2.0,2.0),(5.0,3.0),(5.0,1.0),(1.0,0.0),(0.0,-3.0),(-1.0,-1.0),(-3.0,-1.0),(-3.0,-1.0),(-4.0,-1.0),(0.0,-10.0),(-2.0,0.0),(-3.0,0.0),(-1.0,0.0),(0.0,1.0),(4.0,2.0),(3.0,2.0),(7.0,3.0),(3.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,-1.0),(-2.0,-1.0),(-3.0,0.0),(-3.0,-3.0),(0.0,-1.0),(-4.0,-5.0),(-2.0,0.0),(-4.0,0.0),(-1.0,0.0),(0.0,0.0),(4.0,4.0),(3.0,3.0),(7.0,2.0),(4.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,-1.0),(-1.0,-1.0),(1.0,-4.0),(-3.0,-3.0),(-4.0,-4.0),(-3.0,0.0),(-2.0,0.0),(-3.0,0.0),(0.0,0.0),(4.0,4.0),(3.0,3.0),(7.0,3.0),(3.0,0.0),(3.0,0.0),(0.0,0.0),(-1.0,-1.0),(-1.0,-1.0),(147.0,-192.0),(3.0,-1.0),(2.0,-2.0),(-3.0,1.0),(-3.0,-2.0),(0.0,2.0),(-4.0,-1.0),(2.0,2.0),(0.0,1.0),(85.0,103.0),(-82.0,-98.0),(81.0,101.0),(2.0,-3.0),(-76.0,-98.0),(76.0,97.0),(-77.0,-104.0),(0.0,-2.0),(0.0,-2.0),(1.0,-1.0),(10.0,-2.0),(0.0,2.0),(-10.0,2.0),(-3.0,0.0),(2.0,-2.0),(-7.0,0.0),(-5.0,0.0),(1.0,2.0),(-3.0,-1.0),(-10.0,-2.0),(2.0,-1.0),(9.0,3.0),(2.0,1.0),(0.0,2.0),(88.0,105.0),(-89.0,-103.0),(0.0,6.0),(89.0,99.0),(-3.0,2.0),(0.0,-1.0),(-16.0,-94.0),(15.0,95.0),(-12.0,-94.0),(1.0,0.0),(11.0,94.0),(-5.0,-92.0),(5.0,93.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(2.0,-4.0),(0.0,-2.0),(-66.0,-106.0),(0.0,-2.0),(3.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-5.0,1.0),(72.0,108.0),(-72.0,-110.0),(73.0,110.0),(-80.0,-108.0),(72.0,95.0),(1.0,2.0),(2.0,2.0),(2.0,3.0),(2.0,3.0),(1.0,2.0),(0.0,2.0),(0.0,0.0),(-87.0,-108.0),(87.0,107.0),(-94.0,-108.0),(93.0,108.0),(-100.0,-110.0),(0.0,1.0),(-6.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,1.0),(2.0,1.0),(0.0,2.0),(100.0,106.0),(-1.0,2.0),(-2.0,4.0),(0.0,0.0),(-1.0,0.0),(-24.0,-93.0),(24.0,93.0),(0.0,-1.0),(-18.0,-95.0),(0.0,0.0),(3.0,-1.0),(0.0,0.0),(3.0,1.0),(6.0,2.0),(0.0,1.0),(5.0,2.0),(0.0,1.0),(-2.0,91.0),(2.0,-1.0),(2.0,-1.0),(1.0,-2.0),(2.0,-3.0),(0.0,-1.0),(-62.0,-107.0),(62.0,106.0),(-62.0,-109.0),(62.0,110.0),(-61.0,-108.0),(63.0,107.0),(-65.0,-110.0),(0.0,0.0),(66.0,110.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,-2.0),(-2.0,-3.0),(-2.0,-3.0),(-2.0,-2.0),(-1.0,-3.0),(-13.0,-1.0),(1.0,0.0),(1.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(2.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-1.0),(-2.0,0.0),(1.0,-1.0),(1.0,0.0),(3.0,1.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(-8.0,-2.0),(-3.0,3.0),(1.0,0.0),(1.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(-1.0,0.0),(-3.0,0.0),(-1.0,0.0),(0.0,2.0),(3.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(5.0,1.0),(2.0,2.0),(1.0,3.0),(2.0,2.0),(2.0,3.0),(2.0,3.0),(0.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-104.0,-110.0),(104.0,110.0),(-105.0,-110.0),(103.0,111.0),(-104.0,-108.0),(104.0,107.0),(-104.0,-109.0),(0.0,3.0),(104.0,108.0),(-1.0,1.0),(-2.0,3.0),(-1.0,2.0),(-2.0,1.0),(-2.0,0.0),(-25.0,-92.0),(0.0,-1.0),(6.0,-2.0),(0.0,-1.0),(4.0,-1.0),(0.0,1.0),(4.0,0.0),(4.0,0.0),(1.0,-1.0),(3.0,2.0),(0.0,1.0),(6.0,0.0),(3.0,0.0),(0.0,1.0),(0.0,1.0),(-6.0,92.0),(2.0,-1.0),(2.0,-2.0),(2.0,-2.0),(1.0,-3.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(-1.0,-2.0),(-2.0,-2.0),(-1.0,-2.0),(-2.0,-3.0),(-2.0,-3.0),(-1.0,-1.0),(-5.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(-2.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(1.0,-1.0),(1.0,-1.0),(0.0,0.0),(2.0,4.0),(1.0,2.0),(2.0,3.0),(2.0,3.0),(1.0,2.0),(2.0,2.0),(0.0,2.0),(-1.0,0.0),(0.0,2.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-2.0,3.0),(-2.0,2.0),(-2.0,2.0),(-2.0,0.0),(-27.0,-93.0),(1.0,-1.0),(0.0,0.0),(3.0,0.0),(5.0,0.0),(0.0,-2.0),(4.0,-2.0),(4.0,-1.0),(0.0,-4.0),(0.0,15.0),(3.0,-1.0),(-4.0,0.0),(-4.0,0.0),(-4.0,-1.0),(1.0,1.0),(0.0,2.0),(4.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(1.0,-1.0),(3.0,0.0),(0.0,-2.0),(0.0,-1.0),(-5.0,0.0),(-4.0,0.0),(-4.0,0.0),(0.0,0.0),(-6.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(1.0,1.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(5.0,0.0),(0.0,0.0),(0.0,1.0),(4.0,94.0),(2.0,-1.0),(0.0,-2.0),(-3.0,-85.0),(0.0,-1.0),(0.0,-2.0),(0.0,-4.0),(4.0,0.0),(0.0,-1.0),(0.0,0.0),(4.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-2.0,0.0),(-5.0,0.0),(-5.0,0.0),(0.0,-3.0),(-5.0,-8.0),(0.0,8.0),(-5.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,3.0),(0.0,2.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,4.0),(0.0,2.0),(0.0,1.0),(9.0,85.0),(-1.0,2.0),(-3.0,1.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(3.0,-1.0),(1.0,-2.0),(2.0,-85.0),(0.0,-1.0),(0.0,-2.0),(2.0,-4.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-3.0),(0.0,-1.0),(-1.0,0.0),(-5.0,0.0),(-1.0,-7.0),(-4.0,0.0),(0.0,-9.0),(0.0,0.0),(7.0,2.0),(-2.0,8.0),(4.0,2.0),(6.0,3.0),(5.0,1.0),(0.0,1.0),(0.0,1.0),(-11.0,92.0),(2.0,-1.0),(3.0,-2.0),(2.0,-2.0),(2.0,-3.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,-2.0),(-2.0,-3.0),(-2.0,-2.0),(-2.0,-3.0),(-1.0,-2.0),(-1.0,0.0),(-2.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(2.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,0.0),(-2.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,3.0),(2.0,3.0),(2.0,2.0),(2.0,3.0),(0.0,2.0),(0.0,0.0),(0.0,2.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,3.0),(-2.0,2.0),(-3.0,2.0),(-2.0,0.0),(-28.0,-93.0),(1.0,-1.0),(0.0,-1.0),(5.0,-1.0),(5.0,-3.0),(3.0,-2.0),(-2.0,-8.0),(-1.0,-7.0),(0.0,0.0),(2.0,6.0),(-4.0,0.0),(0.0,8.0),(-1.0,1.0),(1.0,2.0),(0.0,1.0),(0.0,6.0),(0.0,3.0),(0.0,2.0),(1.0,0.0),(0.0,2.0),(-1.0,0.0),(0.0,1.0),(-1.0,3.0),(-1.0,2.0),(0.0,1.0),(15.0,85.0),(-2.0,2.0),(-2.0,1.0),(-3.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(3.0,0.0),(2.0,-2.0),(2.0,-2.0),(9.0,-85.0),(0.0,-1.0),(-1.0,-2.0),(-1.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(1.0,0.0),(0.0,-2.0),(0.0,-3.0),(0.0,-6.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,-8.0),(-5.0,0.0),(2.0,-6.0),(-8.0,0.0),(0.0,-2.0),(0.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,4.0),(9.0,3.0),(2.0,4.0),(0.0,6.0),(5.0,4.0),(5.0,4.0),(0.0,2.0),(0.0,0.0),(-14.0,94.0),(2.0,-2.0),(3.0,-2.0),(3.0,-2.0),(2.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(-2.0,-3.0),(-2.0,-2.0),(0.0,-1.0),(-2.0,-2.0),(-2.0,0.0),(-2.0,-2.0),(0.0,1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,-2.0),(0.0,-2.0),(1.0,-3.0),(3.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-3.0,1.0),(0.0,3.0),(0.0,2.0),(2.0,1.0),(1.0,0.0),(1.0,-1.0),(0.0,0.0),(2.0,2.0),(2.0,0.0),(2.0,3.0),(0.0,1.0),(2.0,2.0),(1.0,3.0),(0.0,2.0),(-1.0,0.0),(0.0,1.0),(-2.0,3.0),(-3.0,2.0),(-3.0,2.0),(-2.0,1.0),(-27.0,-95.0),(1.0,0.0),(0.0,-2.0),(5.0,-4.0),(4.0,-4.0),(-1.0,-6.0),(0.0,-3.0),(2.0,-5.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(-3.0,1.0),(0.0,0.0),(-2.0,1.0),(3.0,5.0),(0.0,3.0),(0.0,2.0),(0.0,0.0),(1.0,8.0),(0.0,5.0),(0.0,4.0),(0.0,0.0),(-1.0,2.0),(-3.0,2.0),(0.0,2.0),(0.0,0.0),(14.0,88.0),(-1.0,1.0),(-1.0,1.0),(-3.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,-1.0),(3.0,0.0),(1.0,-1.0),(1.0,-1.0),(15.0,-88.0),(-1.0,0.0),(0.0,-2.0),(-4.0,-2.0),(0.0,-2.0),(0.0,0.0),(1.0,-4.0),(0.0,-5.0),(1.0,-8.0),(1.0,0.0),(0.0,-2.0),(0.0,-3.0),(1.0,-5.0),(-2.0,-1.0),(0.0,0.0),(-3.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(4.0,6.0),(4.0,5.0),(0.0,5.0),(5.0,4.0),(0.0,2.0),(0.0,0.0),(-17.0,96.0),(2.0,-3.0),(3.0,-2.0),(3.0,-2.0),(2.0,-3.0),(-2.0,-3.0),(-2.0,-1.0),(-1.0,-2.0),(-3.0,-1.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,-4.0),(0.0,-2.0),(1.0,-4.0),(3.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,-2.0),(-2.0,-2.0),(-13.0,-4.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-50.0,-35.0),(50.0,35.0),(-48.0,-35.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(50.0,36.0),(-52.0,-35.0),(53.0,36.0),(0.0,0.0),(1.0,0.0),(3.0,0.0),(-4.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-50.0,-35.0),(50.0,35.0),(0.0,0.0),(-50.0,-36.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(-2.0,-1.0),(0.0,0.0),(-5.0,3.0),(58.0,34.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-4.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(2.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(5.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-12.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-72.0,-37.0),(72.0,37.0),(-77.0,-37.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,0.0),(74.0,37.0),(-74.0,-38.0),(75.0,38.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(4.0,0.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-1.0),(-2.0,-3.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(-68.0,-35.0),(-6.0,-3.0),(0.0,1.0),(-2.0,1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(76.0,37.0),(-76.0,-37.0),(77.0,38.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(3.0,0.0),(1.0,0.0),(5.0,1.0),(1.0,0.0),(2.0,2.0),(2.0,2.0),(0.0,2.0),(0.0,1.0),(-1.0,0.0),(0.0,1.0),(-3.0,1.0),(0.0,4.0),(1.0,2.0),(1.0,4.0),(2.0,0.0),(1.0,1.0),(3.0,1.0),(1.0,2.0),(2.0,1.0),(1.0,3.0),(-3.0,3.0),(-3.0,2.0),(-3.0,2.0),(-2.0,2.0),(-26.0,-97.0),(1.0,0.0),(0.0,-2.0),(4.0,-4.0),(0.0,-5.0),(0.0,-3.0),(3.0,-4.0),(0.0,0.0),(-2.0,1.0),(-1.0,4.0),(1.0,1.0),(3.0,5.0),(0.0,1.0),(1.0,8.0),(0.0,6.0),(-3.0,0.0),(0.0,3.0),(0.0,1.0),(0.0,1.0),(13.0,90.0),(-2.0,1.0),(0.0,1.0),(-2.0,1.0),(-1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(1.0,0.0),(1.0,0.0),(2.0,-1.0),(0.0,-1.0),(2.0,-1.0),(16.0,-90.0),(0.0,-1.0),(0.0,-1.0),(0.0,-3.0),(-3.0,0.0),(0.0,-6.0),(2.0,-8.0),(0.0,-1.0),(2.0,-5.0),(0.0,-1.0),(-2.0,-4.0),(0.0,0.0),(0.0,1.0),(4.0,4.0),(3.0,5.0),(1.0,0.0),(0.0,4.0),(0.0,1.0),(0.0,0.0),(-19.0,98.0),(2.0,-3.0),(3.0,-2.0),(1.0,-2.0),(-3.0,-3.0),(0.0,-2.0),(0.0,-2.0),(-1.0,0.0),(-2.0,-1.0),(-1.0,-3.0),(0.0,-2.0),(0.0,-3.0),(1.0,-4.0),(0.0,-1.0),(2.0,-1.0),(-1.0,-2.0),(-2.0,-2.0),(-2.0,-2.0),(-3.0,0.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(-2.0,0.0),(-57.0,-31.0),(57.0,31.0),(0.0,-2.0),(-52.0,-33.0),(0.0,0.0),(1.0,0.0),(1.0,1.0),(1.0,1.0),(1.0,0.0),(0.0,1.0),(4.0,2.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-1.0,1.0),(0.0,1.0),(-2.0,-4.0),(-1.0,-1.0),(0.0,-1.0),(-3.0,5.0),(-2.0,-1.0),(-2.0,-1.0),(56.0,32.0),(-57.0,-33.0),(57.0,32.0),(0.0,0.0),(-54.0,-34.0),(2.0,0.0),(52.0,33.0),(-53.0,-34.0),(2.0,0.0),(-2.0,-1.0),(53.0,35.0),(-51.0,-38.0),(51.0,37.0),(-48.0,-41.0),(48.0,40.0),(-45.0,-46.0),(46.0,44.0),(-1.0,-2.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,1.0),(1.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(1.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(-1.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(-1.0,0.0),(0.0,0.0),(-3.0,0.0),(1.0,0.0),(1.0,-1.0),(-81.0,-42.0),(80.0,45.0),(-77.0,-39.0),(76.0,41.0),(-73.0,-37.0),(73.0,39.0),(0.0,0.0),(-72.0,-36.0),(-2.0,2.0),(74.0,34.0),(-72.0,-35.0),(0.0,0.0),(2.0,2.0),(70.0,34.0),(-67.0,-33.0),(67.0,34.0),(0.0,0.0),(-69.0,-33.0),(-3.0,1.0),(-2.0,0.0),(-7.0,-1.0),(-2.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,0.0),(1.0,1.0),(2.0,0.0),(0.0,-1.0),(2.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(1.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(74.0,35.0),(-69.0,-30.0),(70.0,32.0),(0.0,0.0),(2.0,0.0),(2.0,0.0),(2.0,0.0),(0.0,0.0),(1.0,0.0),(2.0,1.0),(2.0,2.0),(2.0,2.0),(0.0,2.0),(-2.0,1.0),(0.0,1.0),(-1.0,4.0),(0.0,3.0),(0.0,2.0),(2.0,3.0),(2.0,1.0),(0.0,0.0),(0.0,2.0),(1.0,2.0),(2.0,3.0),(-2.0,2.0),(-3.0,2.0),(-2.0,2.0),(-24.0,-99.0),(1.0,0.0),(0.0,-1.0),(0.0,-4.0),(0.0,0.0),(2.0,-4.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,6.0),(1.0,3.0),(1.0,5.0),(0.0,0.0),(0.0,4.0),(0.0,1.0),(12.0,92.0),(-1.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-1.0,0.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(1.0,0.0),(2.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(19.0,-93.0),(0.0,-1.0),(0.0,-4.0),(0.0,0.0),(2.0,-5.0),(0.0,-3.0),(1.0,-6.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(2.0,4.0),(1.0,2.0),(0.0,0.0),(-22.0,101.0),(3.0,-4.0),(1.0,-2.0),(-1.0,-3.0),(-1.0,-1.0),(1.0,-2.0),(-1.0,-1.0),(-2.0,-3.0),(0.0,-3.0),(0.0,-4.0),(0.0,-1.0),(0.0,-5.0),(-1.0,-2.0),(-1.0,-2.0),(-2.0,0.0),(-3.0,0.0),(-60.0,-25.0),(59.0,26.0),(-1.0,-2.0),(-56.0,-31.0),(1.0,2.0),(3.0,3.0),(1.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(5.0,-3.0),(0.0,0.0),(2.0,-2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,-1.0),(0.0,-1.0),(-6.0,3.0),(-1.0,1.0),(-1.0,-1.0),(-1.0,-4.0),(4.0,-3.0),(2.0,-1.0),(-1.0,0.0),(0.0,-3.0),(3.0,-5.0),(3.0,-5.0),(41.0,43.0),(-38.0,-43.0),(37.0,43.0),(0.0,0.0),(-1.0,2.0),(-1.0,2.0),(-1.0,1.0),(0.0,0.0),(2.0,-3.0),(1.0,-2.0),(2.0,-2.0),(0.0,-1.0),(2.0,0.0),(1.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,1.0),(0.0,1.0),(-2.0,2.0),(-1.0,2.0),(-1.0,2.0),(1.0,0.0),(1.0,-2.0),(1.0,-2.0),(0.0,-2.0),(-83.0,-43.0),(84.0,44.0),(0.0,0.0),(-81.0,-44.0),(3.0,6.0),(2.0,5.0),(0.0,2.0),(-1.0,0.0),(3.0,2.0),(3.0,3.0),(-2.0,3.0),(-1.0,0.0),(-1.0,-1.0),(-6.0,-2.0),(0.0,1.0),(-1.0,1.0),(-1.0,0.0),(0.0,-1.0),(0.0,2.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(2.0,2.0),(0.0,-1.0),(6.0,3.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(2.0,-1.0),(3.0,-2.0),(1.0,-1.0),(70.0,32.0),(-68.0,-25.0),(70.0,27.0),(1.0,-1.0),(3.0,0.0),(2.0,1.0),(1.0,2.0),(0.0,2.0),(0.0,5.0),(0.0,1.0),(0.0,4.0),(1.0,3.0),(2.0,3.0),(0.0,1.0),(-1.0,2.0),(2.0,1.0),(0.0,3.0),(-2.0,2.0),(-3.0,3.0),(-21.0,-102.0),(1.0,0.0),(1.0,-1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(3.0,5.0),(11.0,97.0),(-12.0,-97.0),(2.0,5.0),(11.0,95.0),(-2.0,1.0),(-1.0,1.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,0.0),(2.0,-1.0),(2.0,-1.0),(20.0,-94.0),(-21.0,92.0),(23.0,-98.0),(0.0,0.0),(2.0,-5.0),(0.0,-1.0),(0.0,0.0),(-23.0,101.0),(24.0,-102.0),(0.0,0.0),(-23.0,102.0),(2.0,-6.0),(-1.0,-1.0),(-1.0,-2.0),(2.0,-1.0),(-2.0,-4.0),(0.0,-4.0),(0.0,-6.0),(-3.0,-2.0),(-2.0,-2.0),(-1.0,0.0),(-1.0,-3.0),(-57.0,-25.0),(55.0,26.0),(-51.0,-23.0),(50.0,24.0),(-47.0,-22.0),(2.0,-4.0),(2.0,3.0),(3.0,-6.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-2.0),(1.0,-1.0),(37.0,30.0),(-40.0,-24.0),(40.0,24.0),(-43.0,-26.0),(-2.0,-3.0),(0.0,-2.0),(5.0,-4.0),(0.0,-1.0),(-1.0,0.0),(1.0,-2.0),(2.0,-4.0),(4.0,-4.0),(35.0,39.0),(-31.0,-31.0),(29.0,35.0),(-1.0,2.0),(0.0,2.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,-3.0),(1.0,-3.0),(2.0,-2.0),(1.0,-2.0),(1.0,-1.0),(1.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-2.0,0.0),(-1.0,1.0),(-1.0,1.0),(-1.0,2.0),(-2.0,2.0),(-1.0,3.0),(0.0,3.0),(0.0,0.0),(0.0,1.0),(0.0,-2.0),(0.0,-1.0),(-84.0,-37.0),(86.0,35.0),(1.0,-3.0),(-84.0,-40.0),(5.0,4.0),(1.0,5.0),(0.0,1.0),(0.0,0.0),(1.0,2.0),(4.0,3.0),(0.0,2.0),(72.0,30.0),(-74.0,-26.0),(74.0,26.0),(-77.0,-26.0),(-2.0,-5.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(3.0,6.0),(2.0,-2.0),(75.0,27.0),(-73.0,-22.0),(74.0,21.0),(-71.0,-25.0),(3.0,-2.0),(71.0,27.0),(1.0,2.0),(1.0,0.0),(2.0,3.0),(2.0,2.0),(0.0,6.0),(1.0,4.0),(1.0,4.0),(-2.0,1.0),(2.0,2.0),(0.0,1.0),(-3.0,5.0),(-18.0,-102.0),(17.0,102.0),(-17.0,-101.0),(16.0,102.0),(-16.0,-100.0),(0.0,1.0),(15.0,100.0),(-2.0,2.0),(0.0,2.0),(-1.0,1.0),(-1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(2.0,-1.0),(0.0,-1.0),(0.0,-2.0),(3.0,-2.0),(26.0,-100.0),(0.0,0.0),(-26.0,100.0),(-1.0,-3.0),(1.0,0.0),(0.0,-1.0),(-1.0,-3.0),(0.0,-4.0),(2.0,-3.0),(-1.0,-6.0),(-2.0,-4.0),(-3.0,-3.0),(-1.0,1.0),(-2.0,-2.0),(-43.0,-18.0),(42.0,16.0),(-40.0,-22.0),(40.0,22.0),(-41.0,-22.0),(0.0,-1.0),(41.0,24.0),(0.0,0.0),(0.0,-3.0),(-41.0,-25.0),(41.0,25.0),(-36.0,-27.0),(36.0,26.0),(-34.0,-28.0),(34.0,28.0),(-37.0,-27.0),(36.0,27.0),(-36.0,-29.0),(3.0,-3.0),(33.0,32.0),(-1.0,2.0),(-1.0,3.0),(0.0,0.0),(0.0,-2.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(2.0,-3.0),(1.0,-2.0),(2.0,-2.0),(1.0,-2.0),(1.0,-1.0),(0.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,1.0),(0.0,0.0),(-1.0,1.0),(-1.0,2.0),(-2.0,2.0),(-1.0,2.0),(-1.0,3.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(2.0,-4.0),(0.0,-2.0),(-81.0,-32.0),(81.0,33.0),(-78.0,-29.0),(79.0,29.0),(-80.0,-28.0),(80.0,28.0),(-82.0,-29.0),(82.0,30.0),(-80.0,-29.0),(5.0,3.0),(75.0,27.0),(0.0,2.0),(0.0,-1.0),(-75.0,-24.0),(75.0,24.0),(-76.0,-22.0),(76.0,22.0),(-77.0,-23.0),(3.0,6.0),(76.0,20.0),(2.0,1.0),(1.0,-1.0),(3.0,4.0),(2.0,4.0),(0.0,6.0),(-2.0,3.0),(1.0,4.0),(0.0,3.0),(-1.0,1.0),(-1.0,0.0),(-1.0,1.0),(-2.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-2.0,0.0),(0.0,0.0),(1.0,1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(1.0,0.0),(1.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(1.0,-2.0),(-1.0,-3.0),(1.0,-1.0),(1.0,-1.0),(-1.0,-4.0),(0.0,-4.0),(-2.0,-6.0),(-1.0,-2.0),(-2.0,1.0),(0.0,-3.0),(-1.0,-2.0),(-1.0,0.0),(0.0,0.0),(-1.0,2.0),(0.0,-1.0),(1.0,-4.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-4.0),(1.0,-2.0),(1.0,-1.0),(1.0,-2.0),(2.0,-2.0),(0.0,0.0),(2.0,-1.0),(2.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,1.0),(-2.0,1.0),(0.0,0.0),(-2.0,2.0),(-1.0,2.0),(-1.0,1.0),(-1.0,2.0),(0.0,4.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,-2.0),(2.0,-2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,4.0),(0.0,0.0),(2.0,-2.0),(0.0,1.0),(1.0,0.0),(0.0,2.0),(0.0,2.0),(3.0,-1.0),(1.0,3.0),(2.0,6.0),(0.0,4.0),(0.0,4.0),(-2.0,1.0),(-1.0,1.0),(-3.0,2.0),(-1.0,0.0),(1.0,2.0),(1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-2.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-2.0,-1.0),(0.0,-2.0),(1.0,0.0),(0.0,-3.0),(2.0,-1.0),(0.0,-1.0),(-1.0,-3.0),(-2.0,-5.0),(-2.0,0.0),(0.0,-5.0),(0.0,-2.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(1.0,-4.0),(1.0,-3.0),(1.0,-2.0),(2.0,-2.0),(2.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(-2.0,1.0),(-2.0,2.0),(-1.0,2.0),(-1.0,3.0),(0.0,4.0),(0.0,1.0),(0.0,1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,3.0),(0.0,4.0),(2.0,0.0),(2.0,6.0),(0.0,3.0),(-1.0,1.0),(-2.0,1.0),(-3.0,1.0),(-1.0,1.0),(-1.0,1.0),(3.0,1.0),(2.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,-2.0),(-2.0,-2.0),(-2.0,-1.0),(2.0,-1.0),(0.0,-1.0),(-2.0,-3.0),(2.0,-1.0),(3.0,-1.0),(-2.0,-3.0),(-2.0,-3.0),(0.0,-4.0),(-1.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(1.0,-2.0),(0.0,-4.0),(1.0,0.0),(0.0,-3.0),(1.0,-2.0),(2.0,-2.0),(2.0,-2.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(-2.0,2.0),(-2.0,2.0),(-1.0,2.0),(0.0,3.0),(-1.0,0.0),(0.0,4.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(2.0,0.0),(0.0,4.0),(2.0,3.0),(1.0,3.0),(-4.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(4.0,1.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-2.0),(0.0,0.0),(-3.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-1.0),(-1.0,-1.0),(0.0,0.0),(0.0,-3.0),(2.0,0.0),(1.0,0.0),(-1.0,-4.0),(-1.0,-1.0),(-1.0,-3.0),(2.0,0.0),(1.0,-2.0),(0.0,-1.0),(0.0,-4.0),(1.0,-2.0),(0.0,-2.0),(1.0,-1.0),(1.0,-3.0),(0.0,-1.0),(0.0,0.0),(2.0,-2.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(-1.0,2.0),(-1.0,3.0),(-1.0,1.0),(0.0,2.0),(-1.0,2.0),(0.0,4.0),(0.0,1.0),(-1.0,2.0),(-1.0,0.0),(2.0,3.0),(1.0,1.0),(0.0,4.0),(-2.0,0.0),(-1.0,0.0),(1.0,3.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(1.0,1.0),(2.0,1.0),(2.0,0.0),(1.0,2.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,-1.0),(-1.0,-2.0),(-2.0,0.0),(-2.0,-1.0),(0.0,-1.0),(2.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,-2.0),(-1.0,0.0),(-2.0,0.0),(0.0,-2.0),(2.0,-1.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-1.0,-3.0),(1.0,-2.0),(1.0,0.0),(0.0,-1.0),(1.0,-2.0),(0.0,-4.0),(1.0,-2.0),(0.0,-3.0),(2.0,-1.0),(0.0,-2.0),(1.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(-1.0,2.0),(0.0,2.0),(-2.0,1.0),(0.0,3.0),(-1.0,2.0),(0.0,4.0),(-1.0,2.0),(0.0,1.0),(-1.0,0.0),(0.0,2.0),(1.0,3.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,2.0),(2.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,2.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(2.0,2.0),(1.0,1.0),(2.0,1.0),(0.0,1.0),(1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(-1.0,3.0),(0.0,2.0),(1.0,-1.0),(0.0,-2.0),(1.0,-3.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(-2.0,-1.0),(0.0,-1.0),(-2.0,-1.0),(-1.0,-1.0),(-1.0,-2.0),(0.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(-3.0,0.0),(-1.0,-1.0),(0.0,-2.0),(1.0,-1.0),(2.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-2.0,-1.0),(-1.0,-1.0),(0.0,-1.0),(2.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(0.0,-2.0),(0.0,-2.0),(0.0,-3.0),(0.0,-2.0),(-1.0,-1.0),(-1.0,-1.0),(4.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(-1.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(-3.0,2.0),(2.0,1.0),(0.0,1.0),(0.0,2.0),(-1.0,3.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,2.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(0.0,2.0),(2.0,1.0),(1.0,1.0),(0.0,1.0),(-2.0,1.0),(-2.0,1.0),(0.0,1.0),(1.0,2.0),(1.0,1.0),(0.0,0.0),(1.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(1.0,2.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,-2.0),(1.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(0.0,-1.0),(-2.0,-2.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,-3.0),(-1.0,-2.0),(-1.0,-1.0),(-1.0,-1.0),(2.0,-1.0),(-1.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(1.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,2.0),(0.0,2.0),(-2.0,1.0),(2.0,1.0),(1.0,1.0),(0.0,2.0),(0.0,3.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(-2.0,0.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(1.0,2.0),(0.0,1.0),(-2.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,2.0),(-1.0,0.0),(1.0,2.0),(1.0,2.0),(1.0,3.0),(1.0,2.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(1.0,2.0),(-1.0,1.0),(-1.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-2.0),(2.0,-2.0),(0.0,-1.0),(-1.0,-2.0),(1.0,-1.0),(0.0,-1.0),(-1.0,-2.0),(-1.0,-2.0),(-1.0,-3.0),(-1.0,-2.0),(-1.0,-2.0),(-3.0,-1.0),(4.0,-1.0),(0.0,-2.0),(0.0,-2.0),(1.0,-1.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(-1.0,-3.0),(0.0,-2.0),(-1.0,-1.0),(-1.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(1.0,2.0),(0.0,2.0),(1.0,2.0),(1.0,1.0),(0.0,2.0),(0.0,3.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(-2.0,1.0),(0.0,2.0),(0.0,2.0),(-3.0,1.0),(1.0,2.0),(1.0,2.0),(1.0,2.0),(1.0,2.0),(1.0,3.0),(-1.0,1.0),(1.0,3.0),(-1.0,2.0),(0.0,2.0),(1.0,2.0),(-1.0,2.0),(1.0,1.0),(-1.0,4.0),(0.0,2.0),(0.0,-3.0),(1.0,-4.0),(-1.0,-1.0),(1.0,-2.0),(-1.0,-2.0),(1.0,-2.0),(0.0,-2.0),(-1.0,-3.0),(1.0,-1.0),(-2.0,-3.0),(-1.0,-2.0),(-1.0,-2.0),(-1.0,-1.0),(-3.0,0.0),(-1.0,-1.0),(2.0,-3.0),(0.0,-2.0),(4.0,-3.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(-2.0,-1.0),(0.0,-3.0),(-1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-3.0),(0.0,-2.0),(-1.0,-2.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(1.0,2.0),(0.0,2.0),(1.0,3.0),(0.0,2.0),(0.0,1.0),(1.0,2.0),(0.0,3.0),(1.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,1.0),(-4.0,3.0),(0.0,2.0),(-2.0,3.0),(2.0,1.0),(1.0,2.0),(1.0,2.0),(1.0,3.0),(-2.0,2.0),(2.0,3.0),(0.0,3.0),(1.0,2.0),(-1.0,3.0),(1.0,3.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(-1.0,3.0),(1.0,-3.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(-1.0,-3.0),(1.0,-3.0),(-1.0,-2.0),(0.0,-3.0),(-2.0,-3.0),(2.0,-2.0),(-2.0,-3.0),(-1.0,-1.0),(-5.0,1.0),(-1.0,-4.0),(2.0,-3.0),(-1.0,-3.0),(3.0,-2.0),(0.0,-2.0),(-1.0,-1.0),(-2.0,-3.0),(0.0,-3.0),(-1.0,-2.0),(-1.0,-3.0),(0.0,-3.0),(0.0,-2.0),(0.0,-1.0),(1.0,0.0),(-1.0,1.0),(0.0,1.0),(0.0,2.0),(1.0,3.0),(1.0,3.0),(1.0,2.0),(0.0,3.0),(2.0,3.0),(0.0,1.0),(0.0,2.0),(-3.0,2.0),(1.0,3.0),(-2.0,3.0),(2.0,4.0),(2.0,4.0),(2.0,5.0),(1.0,3.0),(2.0,6.0),(0.0,3.0),(0.0,1.0),(0.0,2.0),(-1.0,1.0),(0.0,1.0),(-2.0,5.0),(1.0,-3.0),(0.0,0.0),(-1.0,3.0),(1.0,-4.0),(2.0,-2.0),(0.0,-1.0),(0.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,-3.0),(-2.0,-6.0),(-1.0,-3.0),(-2.0,-4.0),(-5.0,130.0),(-104.0,-49.0),(0.0,0.0),(1.0,-1.0),(0.0,-2.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-1.0,2.0),(0.0,1.0),(0.0,1.0),(107.0,49.0),(0.0,0.0),(-108.0,-50.0),(0.0,0.0),(0.0,-3.0),(-1.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,2.0),(1.0,2.0),(0.0,1.0),(111.0,49.0),(-1.0,0.0),(-112.0,-50.0),(0.0,0.0),(0.0,-3.0),(-2.0,-1.0),(-1.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,3.0),(1.0,1.0),(0.0,1.0),(114.0,48.0),(-115.0,-47.0),(1.0,1.0),(0.0,0.0),(110.0,46.0),(-109.0,-46.0),(109.0,47.0),(-109.0,-49.0),(112.0,49.0),(-110.0,-49.0),(111.0,49.0),(-110.0,-50.0),(110.0,50.0),(-107.0,-50.0),(107.0,50.0),(-106.0,-49.0),(105.0,49.0),(-105.0,-47.0),(102.0,47.0),(0.0,-1.0),(-101.0,-47.0),(0.0,0.0),(3.0,-2.0),(-2.0,1.0),(103.0,48.0),(-103.0,-48.0),(108.0,48.0),(-107.0,-51.0),(110.0,51.0),(-110.0,-54.0),(110.0,54.0),(-110.0,-54.0),(110.0,54.0),(-111.0,-53.0),(108.0,53.0),(-110.0,-51.0),(114.0,51.0),(-114.0,-54.0),(116.0,54.0),(-118.0,-55.0),(118.0,55.0),(-119.0,-55.0),(117.0,55.0),(-118.0,-54.0),(114.0,54.0),(-115.0,-52.0),(119.0,52.0),(-120.0,-54.0),(120.0,54.0),(-122.0,-54.0),(122.0,54.0),(-123.0,-54.0),(121.0,54.0),(-121.0,-53.0),(0.0,3.0),(117.0,50.0),(-4.0,0.0),(-113.0,-47.0),(115.0,47.0),(-117.0,-49.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(1.0,2.0),(2.0,1.0),(0.0,0.0),(1.0,0.0),(106.0,45.0),(0.0,0.0),(-106.0,-45.0),(104.0,45.0),(-103.0,-44.0),(102.0,44.0),(-99.0,-43.0),(99.0,43.0),(-96.0,-44.0),(1.0,-1.0),(98.0,45.0),(0.0,-1.0),(-98.0,-44.0),(0.0,0.0),(2.0,0.0),(2.0,-4.0),(0.0,-1.0),(0.0,0.0),(102.0,49.0),(-102.0,-49.0),(0.0,0.0),(103.0,49.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-4.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-117.0,-49.0),(116.0,49.0),(-116.0,-48.0),(111.0,48.0),(-110.0,-45.0),(2.0,3.0),(105.0,42.0),(0.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(-94.0,-42.0),(101.0,42.0),(-99.0,-48.0),(1.0,-1.0),(101.0,49.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(5.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,0.0),(0.0,0.0),(-4.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(7.0,0.0),(0.0,-1.0),(2.0,0.0),(0.0,-5.0),(2.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,-1.0),(5.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(-2.0,0.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(-1.0,1.0),(-4.0,1.0),(-5.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,1.0),(-1.0,0.0),(-2.0,0.0),(-5.0,0.0),(0.0,0.0),(-5.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,1.0),(0.0,0.0),(2.0,0.0),(3.0,-1.0),(3.0,-2.0),(-3.0,-5.0),(3.0,-2.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,-1.0),(3.0,-1.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(-1.0,2.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,1.0),(-1.0,2.0),(-2.0,2.0),(0.0,0.0),(0.0,1.0),(-3.0,1.0),(-5.0,2.0),(-3.0,0.0),(-2.0,-2.0),(0.0,0.0),(-4.0,-2.0),(5.0,5.0),(0.0,0.0),(0.0,0.0),(3.0,-4.0),(1.0,-3.0),(2.0,-4.0),(3.0,-2.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,1.0),(-2.0,2.0),(-1.0,0.0),(-1.0,1.0),(-2.0,1.0),(-5.0,-3.0),(-1.0,1.0),(-1.0,-1.0),(-2.0,2.0),(0.0,1.0),(1.0,1.0),(0.0,0.0),(3.0,-4.0),(5.0,-4.0),(3.0,-2.0),(1.0,0.0),(-2.0,2.0),(-2.0,0.0),(-2.0,1.0),(-1.0,0.0),(-1.0,-1.0),(-2.0,2.0),(-1.0,-2.0),(-1.0,3.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,2.0),(2.0,-4.0),(2.0,-1.0),(4.0,-3.0),(3.0,-1.0),(1.0,0.0),(-1.0,1.0),(-2.0,1.0),(-2.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-3.0,1.0),(-3.0,1.0),(-3.0,1.0),(0.0,0.0),(2.0,0.0),(2.0,-1.0),(4.0,-2.0),(4.0,-2.0),(4.0,0.0),(1.0,0.0),(-1.0,0.0),(-3.0,0.0),(0.0,0.0),(-2.0,0.0),(-3.0,1.0),(-3.0,1.0),(-2.0,1.0),(-4.0,1.0),(0.0,0.0),(2.0,0.0),(3.0,-2.0),(3.0,-1.0),(5.0,-2.0),(3.0,-1.0),(2.0,0.0),(-1.0,0.0),(0.0,-1.0),(-3.0,0.0),(-3.0,0.0),(-3.0,0.0),(-3.0,1.0),(-3.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(3.0,-2.0),(4.0,-1.0),(4.0,-1.0),(3.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(-3.0,0.0),(-3.0,0.0),(-4.0,0.0),(-2.0,1.0),(-3.0,1.0),(-3.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(3.0,-2.0),(4.0,-1.0),(4.0,-1.0),(3.0,0.0),(0.0,-5.0),(2.0,0.0),(0.0,0.0),(-3.0,0.0),(-4.0,0.0),(-4.0,0.0),(-3.0,1.0),(-3.0,0.0),(-2.0,1.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(3.0,-2.0),(4.0,0.0),(2.0,-1.0),(3.0,0.0),(1.0,-8.0),(3.0,0.0),(2.0,0.0),(0.0,0.0),(-4.0,0.0),(-4.0,0.0),(-4.0,1.0),(-4.0,1.0),(-4.0,1.0),(-2.0,1.0),(0.0,-1.0),(0.0,0.0),(3.0,-1.0),(2.0,-1.0),(5.0,-1.0),(2.0,0.0),(0.0,-12.0),(5.0,-12.0),(0.0,12.0),(5.0,0.0),(0.0,1.0),(-4.0,1.0),(-3.0,0.0),(-5.0,1.0),(-5.0,0.0),(-6.0,0.0),(-4.0,0.0),(0.0,0.0),(1.0,0.0),(4.0,-1.0),(3.0,0.0),(6.0,-2.0),(0.0,-12.0),(5.0,-1.0),(1.0,-4.0),(3.0,-1.0),(7.0,-59.0),(0.0,0.0),(-2.0,-7.0),(0.0,-4.0),(5.0,-3.0),(2.0,-5.0),(-2.0,-3.0),(-2.0,-4.0),(-1.0,-4.0),(0.0,-3.0),(0.0,-2.0),(0.0,-1.0),(1.0,-1.0),(-1.0,2.0),(0.0,1.0),(1.0,2.0),(0.0,3.0),(1.0,4.0),(2.0,4.0),(1.0,3.0),(-3.0,5.0),(-4.0,3.0),(1.0,4.0),(1.0,7.0),(0.0,0.0),(-123.0,77.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,2.0),(0.0,1.0),(-1.0,0.0),(0.0,-2.0),(-1.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,2.0),(1.0,2.0),(136.0,51.0),(-138.0,-52.0),(0.0,0.0),(0.0,-2.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(1.0,3.0),(1.0,0.0),(0.0,1.0),(137.0,49.0),(1.0,0.0),(-136.0,-51.0),(3.0,0.0),(133.0,51.0),(-1.0,0.0),(-130.0,-50.0),(130.0,50.0),(-128.0,-50.0),(128.0,50.0),(-126.0,-50.0),(-1.0,1.0),(126.0,49.0),(3.0,0.0),(-128.0,-51.0),(132.0,51.0),(-133.0,-54.0),(135.0,54.0),(-135.0,-55.0),(135.0,55.0),(-136.0,-56.0),(136.0,56.0),(-137.0,-55.0),(133.0,55.0),(-135.0,-53.0),(139.0,53.0),(-140.0,-56.0),(142.0,56.0),(-143.0,-57.0),(143.0,57.0),(-144.0,-57.0),(142.0,57.0),(-144.0,-55.0),(140.0,55.0),(-140.0,-53.0),(143.0,53.0),(-145.0,-55.0),(145.0,55.0),(-146.0,-55.0),(146.0,55.0),(-146.0,-55.0),(143.0,55.0),(-143.0,-53.0),(138.0,53.0),(-138.0,-51.0),(-1.0,0.0),(2.0,2.0),(1.0,1.0),(0.0,0.0),(133.0,48.0),(-132.0,-48.0),(132.0,49.0),(-132.0,-50.0),(135.0,50.0),(-134.0,-51.0),(135.0,51.0),(-132.0,-51.0),(132.0,51.0),(-131.0,-51.0),(131.0,51.0),(-129.0,-51.0),(128.0,51.0),(-128.0,-48.0),(125.0,48.0),(0.0,-1.0),(-124.0,-48.0),(0.0,0.0),(1.0,-2.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(126.0,50.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(4.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-1.0,0.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-4.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-142.0,-51.0),(142.0,51.0),(-142.0,-51.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(2.0,3.0),(2.0,-1.0),(0.0,1.0),(130.0,46.0),(0.0,0.0),(-129.0,-47.0),(126.0,47.0),(-126.0,-45.0),(126.0,45.0),(-123.0,-44.0),(124.0,44.0),(-120.0,-46.0),(0.0,0.0),(122.0,46.0),(0.0,-1.0),(-122.0,-45.0),(1.0,0.0),(0.0,0.0),(2.0,-1.0),(120.0,46.0),(-120.0,-47.0),(1.0,-2.0),(124.0,49.0),(0.0,0.0),(0.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,0.0),(4.0,0.0),(3.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-5.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,0.0),(0.0,0.0),(-142.0,-50.0),(140.0,50.0),(-139.0,-48.0),(3.0,4.0),(129.0,44.0),(-1.0,0.0),(0.0,0.0),(1.0,0.0),(-119.0,-44.0),(119.0,44.0),(0.0,0.0),(3.0,0.0),(0.0,-1.0),(0.0,-1.0),(6.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(1.0,0.0),(5.0,-1.0),(4.0,-1.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(1.0,-1.0),(1.0,0.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-5.0,0.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(0.0,5.0),(-3.0,0.0),(0.0,0.0),(-7.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(0.0,0.0),(0.0,-2.0),(3.0,-1.0),(5.0,-2.0),(2.0,-1.0),(0.0,-1.0),(0.0,0.0),(3.0,-2.0),(1.0,-2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(1.0,-1.0),(0.0,-1.0),(0.0,0.0),(-2.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,1.0),(-3.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-2.0,2.0),(3.0,5.0),(-4.0,2.0),(-3.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(3.0,-2.0),(2.0,-2.0),(1.0,-1.0),(1.0,0.0),(2.0,-2.0),(0.0,-1.0),(1.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,1.0),(-3.0,2.0),(-2.0,4.0),(-1.0,3.0),(-3.0,3.0),(0.0,0.0),(0.0,-1.0),(-4.0,-5.0),(2.0,-2.0),(1.0,-2.0),(2.0,-2.0),(1.0,-1.0),(2.0,-1.0),(2.0,0.0),(1.0,-1.0),(-2.0,1.0),(-3.0,2.0),(-5.0,4.0),(-3.0,3.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(3.0,-2.0),(0.0,-3.0),(1.0,2.0),(2.0,-3.0),(2.0,0.0),(2.0,-1.0),(2.0,-1.0),(0.0,0.0),(-2.0,1.0),(-3.0,1.0),(-4.0,3.0),(-2.0,1.0),(-2.0,3.0),(-1.0,-2.0),(0.0,0.0),(1.0,-1.0),(2.0,-1.0),(-2.0,-3.0),(3.0,-1.0),(3.0,-1.0),(2.0,0.0),(2.0,-1.0),(3.0,0.0),(0.0,0.0),(-2.0,0.0),(-4.0,1.0),(-4.0,2.0),(-4.0,2.0),(-2.0,0.0),(-1.0,0.0),(0.0,0.0),(0.0,-2.0),(4.0,-1.0),(2.0,-1.0),(3.0,-1.0),(3.0,-1.0),(2.0,0.0),(3.0,0.0),(0.0,0.0),(-3.0,0.0),(-3.0,1.0),(-5.0,2.0),(-3.0,1.0),(-3.0,1.0),(-1.0,0.0),(0.0,-4.0),(0.0,0.0),(0.0,-1.0),(3.0,-1.0),(3.0,-1.0),(3.0,-1.0),(3.0,0.0),(3.0,0.0),(2.0,0.0),(0.0,0.0),(-2.0,0.0),(-3.0,1.0),(-4.0,1.0),(-4.0,1.0),(-3.0,1.0),(-1.0,-3.0),(-1.0,0.0),(0.0,0.0),(0.0,-1.0),(4.0,-1.0),(2.0,-1.0),(3.0,0.0),(4.0,0.0),(3.0,0.0),(2.0,0.0),(0.0,0.0),(-3.0,0.0),(-3.0,0.0),(-4.0,1.0),(-4.0,0.0),(-1.0,-6.0),(-3.0,1.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(3.0,0.0),(3.0,0.0),(4.0,0.0),(4.0,0.0),(2.0,0.0),(-1.0,0.0),(-2.0,0.0),(-3.0,0.0),(-3.0,0.0),(-2.0,0.0),(-1.0,-8.0),(-5.0,1.0),(-2.0,1.0),(-2.0,1.0),(0.0,0.0),(0.0,0.0),(3.0,-2.0),(4.0,-1.0),(4.0,-1.0),(4.0,0.0),(4.0,0.0),(3.0,0.0),(-1.0,0.0),(-2.0,0.0),(-3.0,0.0),(-4.0,0.0),(0.0,-12.0),(2.0,-16.0),(-1.0,4.0),(-5.0,1.0),(0.0,12.0),(-6.0,2.0),(-3.0,0.0),(-4.0,0.0),(0.0,0.0),(0.0,0.0),(5.0,0.0),(6.0,-1.0),(5.0,0.0),(5.0,-1.0),(3.0,0.0),(3.0,-1.0),(-1.0,-1.0),(-4.0,0.0),(1.0,-12.0),(0.0,-5.0),(11.0,-52.0),(3.0,13.0),(6.0,-6.0),(0.0,3.0),(-2.0,6.0),(-1.0,4.0),(0.0,2.0),(0.0,0.0),(0.0,-1.0),(1.0,-2.0),(1.0,-4.0),(1.0,-6.0),(0.0,-2.0),(-7.0,6.0),(-3.0,-13.0),(-1.0,34.0),(0.0,0.0),(-2.0,4.0),(-3.0,16.0),(0.0,5.0),(0.0,2.0),(-4.0,1.0),(-1.0,0.0),(-6.0,1.0),(-7.0,0.0),(-8.0,0.0),(-3.0,0.0),(0.0,0.0),(1.0,-1.0),(4.0,-1.0),(4.0,-1.0),(0.0,-5.0),(7.0,-2.0),(2.0,-7.0),(7.0,0.0),(5.0,0.0),(0.0,-5.0),(1.0,-3.0),(1.0,-3.0),(2.0,-13.0),(-1.0,-22.0),(-2.0,-7.0),(-2.0,-7.0),(-4.0,-10.0),(2.0,-1.0),(4.0,-3.0),(-3.0,-10.0),(0.0,-3.0),(0.0,0.0),(0.0,1.0),(1.0,3.0),(2.0,10.0),(-5.0,3.0),(-1.0,1.0),(5.0,10.0),(2.0,7.0),(2.0,7.0),(0.0,22.0),(-3.0,13.0),(-7.0,10.0),(-7.0,0.0),(-2.0,8.0),(-7.0,2.0),(0.0,5.0),(-4.0,1.0),(-4.0,1.0),(0.0,0.0),(1.0,0.0),(3.0,0.0),(8.0,0.0),(7.0,-1.0),(6.0,-1.0),(1.0,0.0),(4.0,-1.0),(0.0,-2.0),(0.0,-5.0),(0.0,-7.0),(0.0,-5.0),(1.0,-3.0),(2.0,-1.0),(2.0,-3.0),(0.0,0.0),(1.0,-13.0),(5.0,0.0),(0.0,1.0),(-1.0,-1.0),(-5.0,1.0),(-1.0,13.0),(-1.0,2.0),(-2.0,4.0),(-1.0,3.0),(1.0,-1.0),(-2.0,6.0),(0.0,8.0),(-4.0,0.0),(-7.0,1.0),(-7.0,0.0),(-8.0,0.0),(-4.0,0.0),(0.0,0.0),(1.0,-1.0),(3.0,-1.0),(-2.0,-9.0),(8.0,-1.0),(1.0,-5.0),(9.0,0.0),(7.0,0.0),(1.0,-3.0),(1.0,-3.0),(3.0,-14.0),(1.0,0.0),(-2.0,-21.0),(-2.0,-6.0),(-2.0,-7.0),(-4.0,-10.0),(-4.0,-8.0),(3.0,-3.0),(2.0,-1.0),(0.0,-3.0),(0.0,-1.0),(0.0,2.0),(0.0,3.0),(-3.0,1.0),(-2.0,3.0),(5.0,8.0),(4.0,10.0),(2.0,7.0),(2.0,6.0),(1.0,20.0),(-2.0,0.0),(-3.0,15.0),(-1.0,3.0),(-1.0,2.0),(-7.0,0.0),(-9.0,0.0),(-1.0,6.0),(-7.0,1.0),(2.0,9.0),(-4.0,1.0),(0.0,0.0),(1.0,0.0),(4.0,0.0),(8.0,0.0),(7.0,0.0),(7.0,-2.0),(4.0,0.0),(0.0,-8.0),(1.0,-5.0),(-1.0,1.0),(2.0,-4.0),(2.0,-4.0),(1.0,-2.0),(2.0,0.0),(2.0,0.0),(-3.0,1.0),(-5.0,8.0),(-2.0,-1.0),(0.0,1.0),(-1.0,2.0),(0.0,2.0),(-1.0,4.0),(-8.0,1.0),(-7.0,0.0),(-10.0,-1.0),(-6.0,-2.0),(0.0,0.0),(0.0,-1.0),(-1.0,-5.0),(6.0,-2.0),(1.0,-3.0),(8.0,-1.0),(10.0,0.0),(1.0,-3.0),(0.0,-14.0),(-3.0,-15.0),(9.0,-3.0),(-2.0,-9.0),(-2.0,-5.0),(-3.0,-9.0),(-5.0,-6.0),(1.0,-4.0),(1.0,-4.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,2.0),(-1.0,4.0),(0.0,4.0),(6.0,6.0),(3.0,9.0),(2.0,5.0),(1.0,9.0),(-9.0,3.0),(3.0,15.0),(-1.0,14.0),(-1.0,3.0),(-10.0,0.0),(-8.0,1.0),(-1.0,3.0),(-5.0,2.0),(2.0,5.0),(0.0,1.0),(0.0,0.0),(6.0,2.0),(10.0,0.0),(7.0,-1.0),(8.0,-1.0),(1.0,-4.0),(0.0,-2.0),(1.0,-2.0),(0.0,0.0),(2.0,1.0),(2.0,0.0),(-8.0,4.0),(-3.0,0.0),(-2.0,0.0),(0.0,0.0),(-1.0,1.0),(0.0,1.0),(-7.0,0.0),(-12.0,-3.0),(-6.0,-1.0),(-1.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(0.0,-2.0),(9.0,-4.0),(2.0,-2.0),(7.0,1.0),(1.0,-12.0),(-3.0,-14.0),(-4.0,-13.0),(8.0,-3.0),(-3.0,-8.0),(-1.0,-10.0),(0.0,-5.0),(0.0,-3.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,3.0),(0.0,5.0),(2.0,10.0),(2.0,8.0),(-8.0,3.0),(5.0,13.0),(2.0,14.0),(-2.0,11.0),(-7.0,-1.0),(-2.0,3.0),(-8.0,4.0),(0.0,2.0),(0.0,1.0),(2.0,2.0),(1.0,2.0),(6.0,1.0),(12.0,2.0),(7.0,-1.0),(0.0,-1.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(-6.0,0.0),(0.0,0.0),(-1.0,0.0),(-14.0,1.0),(0.0,-3.0),(13.0,1.0),(-1.0,0.0),(0.0,1.0),(0.0,0.0),(-13.0,-4.0),(-7.0,0.0),(-1.0,-3.0),(-2.0,-2.0),(0.0,-1.0),(1.0,-1.0),(0.0,-2.0),(7.0,-3.0),(0.0,-6.0),(4.0,-2.0),(-1.0,-12.0),(-2.0,-16.0),(0.0,-10.0),(2.0,0.0),(-1.0,-10.0),(0.0,-5.0),(0.0,-3.0),(1.0,0.0),(2.0,0.0),(-3.0,0.0),(0.0,0.0),(0.0,4.0),(1.0,5.0),(0.0,10.0),(-2.0,0.0),(1.0,10.0),(2.0,16.0),(0.0,12.0),(-4.0,2.0),(0.0,6.0),(-8.0,3.0),(0.0,2.0),(0.0,1.0),(1.0,1.0),(2.0,2.0),(1.0,3.0),(7.0,0.0),(13.0,3.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-13.0,0.0),(1.0,4.0),(0.0,0.0),(-8.0,0.0),(-1.0,0.0),(0.0,-4.0),(0.0,-2.0),(7.0,0.0),(0.0,-2.0),(0.0,0.0),(-7.0,-3.0),(-3.0,-1.0),(-1.0,0.0),(0.0,-3.0),(0.0,0.0),(1.0,-7.0),(1.0,0.0),(3.0,-12.0),(0.0,-2.0),(2.0,-1.0),(-3.0,-16.0),(0.0,-10.0),(0.0,-5.0),(4.0,-5.0),(0.0,-5.0),(1.0,-3.0),(1.0,0.0),(1.0,0.0),(-2.0,0.0),(-1.0,0.0),(0.0,4.0),(0.0,5.0),(-4.0,5.0),(1.0,5.0),(0.0,10.0),(2.0,16.0),(-3.0,1.0),(0.0,2.0),(-3.0,12.0),(-1.0,0.0),(0.0,7.0),(0.0,0.0),(1.0,3.0),(1.0,0.0),(3.0,1.0),(6.0,2.0),(0.0,0.0),(0.0,3.0),(-7.0,0.0),(0.0,2.0),(0.0,3.0),(-12.0,-1.0),(0.0,0.0),(-1.0,-1.0),(0.0,-1.0),(0.0,-3.0),(12.0,-5.0),(-3.0,-1.0),(0.0,-3.0),(1.0,0.0),(0.0,-7.0),(0.0,0.0),(0.0,-8.0),(1.0,-3.0),(0.0,-3.0),(-1.0,-17.0),(0.0,-11.0),(1.0,-3.0),(2.0,-7.0),(1.0,-3.0),(1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,0.0),(-1.0,4.0),(-2.0,7.0),(0.0,3.0),(0.0,11.0),(1.0,17.0),(0.0,3.0),(-2.0,3.0),(0.0,8.0),(0.0,0.0),(0.0,7.0),(0.0,0.0),(1.0,3.0),(2.0,1.0),(-12.0,5.0),(0.0,3.0),(-11.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-3.0),(1.0,-6.0),(10.0,-2.0),(1.0,-10.0),(7.0,0.0),(1.0,-8.0),(0.0,-6.0),(0.0,0.0),(-2.0,-17.0),(0.0,-10.0),(0.0,-3.0),(0.0,-4.0),(1.0,-3.0),(2.0,-1.0),(1.0,0.0),(-2.0,0.0),(-2.0,2.0),(0.0,3.0),(0.0,4.0),(0.0,3.0),(0.0,10.0),(2.0,17.0),(0.0,0.0),(0.0,6.0),(-2.0,7.0),(-7.0,0.0),(-1.0,11.0),(-10.0,2.0),(-1.0,6.0),(-17.0,0.0),(0.0,3.0),(1.0,1.0),(0.0,0.0),(-1.0,0.0),(-1.0,-2.0),(0.0,-2.0),(-84.0,77.0),(63.0,-30.0),(0.0,0.0),(1.0,0.0),(2.0,-2.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,1.0),(-1.0,1.0),(-1.0,0.0),(-59.0,31.0),(0.0,0.0),(60.0,-32.0),(0.0,-1.0),(1.0,-1.0),(0.0,-2.0),(0.0,-1.0),(-1.0,0.0),(-1.0,0.0),(-2.0,2.0),(0.0,2.0),(-1.0,0.0),(-53.0,33.0),(52.0,-36.0),(0.0,-1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-1.0,2.0),(2.0,1.0),(1.0,0.0),(0.0,1.0),(-52.0,33.0),(50.0,-33.0),(-50.0,33.0),(52.0,-33.0),(-52.0,33.0),(53.0,-33.0),(-54.0,33.0),(56.0,-31.0),(-58.0,31.0),(59.0,-29.0),(-61.0,29.0),(60.0,-28.0),(-63.0,28.0),(0.0,0.0),(65.0,-28.0),(0.0,0.0),(4.0,0.0),(-3.0,0.0),(-64.0,28.0),(64.0,-29.0),(-62.0,29.0),(65.0,-31.0),(-62.0,31.0),(63.0,-33.0),(-62.0,33.0),(62.0,-33.0),(-61.0,33.0),(59.0,-33.0),(-61.0,33.0),(59.0,-32.0),(-55.0,32.0),(56.0,-35.0),(-53.0,35.0),(52.0,-37.0),(-52.0,37.0),(51.0,-37.0),(-51.0,37.0),(50.0,-37.0),(-53.0,37.0),(50.0,-35.0),(-46.0,35.0),(46.0,-38.0),(-46.0,38.0),(44.0,-38.0),(-44.0,38.0),(44.0,-38.0),(-45.0,38.0),(44.0,-37.0),(-47.0,37.0),(46.0,-35.0),(1.0,1.0),(-50.0,34.0),(-2.0,0.0),(0.0,0.0),(51.0,-32.0),(-55.0,32.0),(54.0,-29.0),(-58.0,29.0),(60.0,-26.0),(-62.0,26.0),(66.0,-26.0),(0.0,0.0),(-65.0,26.0),(0.0,0.0),(67.0,-26.0),(0.0,0.0),(1.0,1.0),(4.0,-2.0),(0.0,-1.0),(0.0,0.0),(-68.0,28.0),(68.0,-28.0),(0.0,0.0),(-68.0,28.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(3.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,0.0),(2.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,0.0),(-3.0,0.0),(-4.0,0.0),(0.0,0.0),(-5.0,0.0),(-5.0,0.0),(-2.0,0.0),(0.0,0.0),(69.0,-24.0),(-65.0,24.0),(71.0,-27.0),(0.0,0.0),(-70.0,27.0),(0.0,-1.0),(2.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(2.0,0.0),(1.0,0.0),(0.0,0.0),(1.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,0.0),(-5.0,0.0),(-6.0,0.0),(0.0,0.0),(-4.0,0.0),(-3.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(1.0,0.0),(-1.0,-6.0),(2.0,0.0),(3.0,0.0),(0.0,0.0),(1.0,0.0),(5.0,0.0),(2.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(-2.0,1.0),(-4.0,1.0),(-5.0,1.0),(-7.0,0.0),(-3.0,1.0),(-1.0,-3.0),(-6.0,-3.0),(4.0,6.0),(1.0,0.0),(0.0,0.0),(1.0,-2.0),(1.0,-2.0),(-2.0,-4.0),(2.0,-2.0),(2.0,-1.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(4.0,-1.0),(1.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(3.0,-1.0),(1.0,1.0),(0.0,1.0),(0.0,0.0),(1.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,3.0),(-2.0,2.0),(-4.0,1.0),(-8.0,0.0),(-2.0,-3.0),(-3.0,1.0),(-2.0,0.0),(-1.0,-1.0),(-2.0,0.0),(-1.0,0.0),(1.0,2.0),(4.0,5.0),(1.0,-4.0),(1.0,-4.0),(1.0,-3.0),(3.0,-2.0),(2.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,1.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,2.0),(-3.0,1.0),(-6.0,1.0),(0.0,-2.0),(0.0,0.0),(-2.0,0.0),(-2.0,0.0),(-2.0,-2.0),(-1.0,0.0),(-1.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,1.0),(3.0,-4.0),(2.0,-1.0),(3.0,0.0),(2.0,0.0),(2.0,0.0),(1.0,0.0),(1.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,1.0),(-1.0,0.0),(-1.0,1.0),(-1.0,0.0),(0.0,0.0),(-1.0,0.0),(-3.0,0.0),(-2.0,0.0),(0.0,-2.0),(-3.0,-1.0),(-2.0,0.0),(-2.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(1.0,-1.0),(1.0,2.0),(2.0,-1.0),(3.0,-1.0),(2.0,0.0),(2.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,1.0),(0.0,2.0),(0.0,0.0),(-1.0,0.0),(0.0,0.0),(-2.0,1.0),(-4.0,0.0),(0.0,-3.0),(-4.0,-2.0),(-3.0,-1.0),(-2.0,-1.0),(0.0,0.0),(3.0,0.0),(3.0,0.0),(2.0,0.0),(1.0,0.0),(3.0,0.0),(3.0,0.0),(1.0,1.0),(0.0,1.0),(-1.0,1.0),(0.0,0.0),(0.0,-9.0),(-5.0,-1.0),(-5.0,-3.0),(-2.0,-2.0),(-3.0,0.0),(0.0,0.0),(4.0,0.0),(3.0,1.0),(4.0,1.0),(3.0,1.0),(3.0,1.0),(0.0,1.0),(0.0,2.0),(2.0,-9.0),(-1.0,0.0),(-2.0,-1.0),(-3.0,0.0),(-7.0,-3.0),(-3.0,-2.0),(-3.0,-2.0),(0.0,0.0),(2.0,1.0),(3.0,0.0),(2.0,0.0),(4.0,3.0),(4.0,3.0),(3.0,0.0),(2.0,0.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(-2.0,0.0),(-4.0,0.0),(-7.0,-3.0),(-3.0,-3.0),(-3.0,-3.0),(0.0,0.0),(2.0,1.0),(4.0,0.0),(2.0,0.0),(4.0,5.0),(4.0,2.0),(2.0,0.0),(2.0,-3.0),(2.0,1.0),(0.0,0.0),(-1.0,-1.0),(-3.0,0.0),(-3.0,0.0),(-7.0,-3.0),(-3.0,-3.0),(-3.0,-3.0),(1.0,0.0),(3.0,0.0),(2.0,1.0),(3.0,0.0),(4.0,4.0),(3.0,2.0),(2.0,-4.0),(2.0,1.0),(37.0,-48.0),(4.0,-2.0),(6.0,-1.0),(0.0,-4.0),(11.0,2.0),(26.0,15.0),(1.0,-11.0),(18.0,0.0),(0.0,-6.0),(0.0,-1.0),(11.0,0.0),(0.0,-7.0),(3.0,-17.0),(0.0,-9.0),(0.0,-4.0),(0.0,-3.0),(1.0,-4.0),(2.0,-1.0),(1.0,0.0),(-2.0,0.0),(-2.0,2.0),(-1.0,4.0),(0.0,3.0),(0.0,4.0),(0.0,9.0),(-3.0,17.0),(0.0,6.0),(-10.0,0.0),(0.0,2.0),(0.0,5.0),(-19.0,0.0),(-1.0,11.0),(-26.0,-16.0),(-10.0,-1.0),(0.0,5.0),(-7.0,1.0),(-4.0,2.0),(-37.0,47.0),(-2.0,-2.0),(-2.0,-2.0),(-2.0,-1.0),(-3.0,-3.0),(-2.0,0.0),(-2.0,-1.0),(-3.0,0.0),(0.0,0.0),(3.0,4.0),(3.0,4.0),(7.0,3.0),(3.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,0.0),(12.0,-14.0),(10.0,-14.0),(6.0,-8.0),(2.0,-8.0),(3.0,-3.0),(2.0,-2.0),(4.0,-2.0),(7.0,0.0),(10.0,1.0),(12.0,8.0),(0.0,7.0),(0.0,4.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-1.0,-2.0),(0.0,-4.0),(0.0,-7.0),(-12.0,-8.0),(-10.0,0.0),(-7.0,1.0),(-4.0,2.0),(-2.0,2.0),(-3.0,3.0),(-2.0,8.0),(-6.0,8.0),(-10.0,14.0),(-11.0,13.0),(0.0,0.0),(-1.0,0.0),(-3.0,-1.0),(-3.0,0.0),(-7.0,-3.0),(-3.0,-4.0),(-2.0,-3.0),(0.0,0.0),(4.0,1.0),(2.0,1.0),(2.0,0.0),(3.0,3.0),(2.0,0.0),(8.0,-14.0),(5.0,3.0),(2.0,0.0),(11.0,-13.0),(6.0,-9.0),(1.0,-2.0),(2.0,2.0),(2.0,-7.0),(1.0,-2.0),(0.0,-3.0),(1.0,-3.0),(3.0,-3.0),(0.0,-5.0),(9.0,1.0),(10.0,3.0),(13.0,4.0),(0.0,-4.0),(16.0,2.0),(0.0,-3.0),(1.0,-6.0),(15.0,3.0),(0.0,-7.0),(1.0,-15.0),(1.0,-8.0),(1.0,-3.0),(0.0,-3.0),(1.0,-4.0),(1.0,-1.0),(0.0,0.0),(-1.0,1.0),(-1.0,1.0),(-1.0,4.0),(0.0,3.0),(-1.0,3.0),(-1.0,8.0),(-1.0,15.0),(0.0,6.0),(-15.0,-3.0),(-1.0,7.0),(0.0,2.0),(-16.0,-2.0),(0.0,4.0),(-13.0,-5.0),(-10.0,-3.0),(-8.0,0.0),(0.0,6.0),(-4.0,3.0),(0.0,3.0),(0.0,3.0),(-2.0,2.0),(-2.0,6.0),(-2.0,-2.0),(-1.0,3.0),(-6.0,9.0),(-11.0,12.0),(-2.0,-1.0),(-5.0,-3.0),(-1.0,-1.0),(-5.0,-1.0),(-3.0,1.0),(-4.0,1.0),(-2.0,0.0),(0.0,1.0),(2.0,2.0),(0.0,1.0),(4.0,2.0),(10.0,2.0),(9.0,0.0),(1.0,0.0),(10.0,-13.0),(7.0,-8.0),(1.0,-3.0),(0.0,-6.0),(2.0,-3.0),(1.0,-2.0),(5.0,-2.0),(7.0,0.0),(10.0,3.0),(0.0,9.0),(0.0,3.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-3.0),(-1.0,-9.0),(-10.0,-2.0),(-7.0,1.0),(-5.0,2.0),(-1.0,2.0),(-2.0,3.0),(0.0,6.0),(-1.0,3.0),(-7.0,8.0),(-10.0,12.0),(-1.0,-1.0),(-9.0,0.0),(-10.0,-2.0),(-4.0,-2.0),(0.0,-1.0),(-1.0,-2.0),(1.0,-1.0),(2.0,0.0),(4.0,-1.0),(3.0,0.0),(5.0,1.0),(3.0,-12.0),(6.0,1.0),(2.0,0.0),(6.0,1.0),(6.0,-9.0),(0.0,-2.0),(0.0,-9.0),(4.0,1.0),(2.0,3.0),(0.0,-6.0),(0.0,-5.0),(0.0,-7.0),(5.0,-1.0),(9.0,1.0),(12.0,3.0),(1.0,-2.0),(12.0,4.0),(0.0,-13.0),(1.0,-9.0),(15.0,9.0),(1.0,-10.0),(1.0,-9.0),(0.0,-3.0),(1.0,-3.0),(0.0,-2.0),(1.0,-2.0),(1.0,0.0),(-2.0,1.0),(-1.0,2.0),(0.0,2.0),(-1.0,3.0),(0.0,3.0),(-1.0,9.0),(-1.0,9.0),(-15.0,-9.0),(-1.0,10.0),(0.0,12.0),(-12.0,-4.0),(-1.0,2.0),(-12.0,-4.0),(-9.0,0.0),(-4.0,2.0),(0.0,7.0),(0.0,5.0),(-1.0,5.0),(-2.0,-4.0),(-3.0,0.0),(0.0,10.0),(-1.0,2.0),(-6.0,8.0),(-6.0,-2.0),(-2.0,0.0),(-6.0,0.0),(-7.0,0.0),(-3.0,1.0),(-3.0,2.0),(-1.0,1.0),(0.0,1.0),(0.0,1.0),(1.0,1.0),(5.0,2.0),(13.0,1.0),(13.0,-2.0),(4.0,-7.0),(1.0,-2.0),(2.0,-5.0),(2.0,-2.0),(2.0,-2.0),(6.0,0.0),(6.0,2.0),(0.0,3.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,-3.0),(0.0,-3.0),(-7.0,-1.0),(-6.0,1.0),(-2.0,2.0),(-2.0,2.0),(-2.0,5.0),(-1.0,2.0),(-4.0,7.0),(-13.0,1.0),(-13.0,-2.0),(-5.0,-2.0),(0.0,-1.0),(0.0,-1.0),(1.0,-1.0),(1.0,-1.0),(3.0,-2.0),(3.0,-1.0),(1.0,-10.0),(5.0,0.0),(6.0,1.0),(4.0,1.0),(2.0,0.0),(1.0,-3.0),(0.0,-9.0),(0.0,-12.0),(0.0,6.0),(9.0,2.0),(3.0,2.0),(1.0,-6.0),(0.0,-5.0),(5.0,-2.0),(9.0,1.0),(-1.0,-10.0),(14.0,1.0),(0.0,-9.0),(14.0,0.0),(0.0,-6.0),(0.0,-3.0),(1.0,-3.0),(0.0,-3.0),(1.0,-1.0),(0.0,-1.0),(-1.0,2.0),(-1.0,1.0),(0.0,3.0),(-1.0,3.0),(0.0,3.0),(0.0,5.0),(-13.0,0.0),(0.0,9.0),(-14.0,-1.0),(1.0,10.0),(-10.0,-1.0),(-5.0,3.0),(0.0,5.0),(-1.0,5.0),(-3.0,-3.0),(-9.0,-7.0),(0.0,6.0),(0.0,7.0),(0.0,9.0),(-1.0,2.0),(-2.0,0.0),(-4.0,-2.0),(-6.0,0.0),(-5.0,0.0),(-4.0,1.0),(-3.0,2.0),(-1.0,0.0),(-1.0,3.0),(1.0,2.0),(2.0,3.0),(6.0,2.0),(12.0,2.0),(5.0,0.0),(9.0,-2.0),(1.0,-3.0),(2.0,-4.0),(-3.0,0.0),(6.0,-2.0),(3.0,-1.0),(4.0,1.0),(-1.0,3.0),(0.0,0.0),(0.0,-1.0),(1.0,-3.0),(-5.0,0.0),(-8.0,3.0),(5.0,-1.0),(-2.0,2.0),(-3.0,4.0),(-1.0,3.0),(-9.0,1.0),(-5.0,0.0),(-12.0,-3.0),(-6.0,-2.0),(-2.0,-3.0),(0.0,-2.0),(2.0,-3.0),(1.0,0.0),(3.0,-2.0),(0.0,-3.0),(4.0,0.0),(4.0,0.0),(6.0,1.0),(6.0,1.0),(0.0,-9.0),(0.0,-7.0),(0.0,-6.0),(2.0,-5.0),(9.0,6.0),(2.0,-6.0),(5.0,-5.0),(-1.0,-8.0),(7.0,-3.0),(0.0,-5.0),(16.0,0.0),(0.0,-3.0),(0.0,-3.0),(0.0,-2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,3.0),(0.0,3.0),(-16.0,0.0),(0.0,5.0),(-7.0,3.0),(1.0,8.0),(-6.0,5.0),(-2.0,5.0),(-9.0,-6.0),(-1.0,6.0),(0.0,6.0),(0.0,7.0),(-1.0,8.0),(-6.0,-2.0),(-6.0,0.0),(-4.0,0.0),(-4.0,1.0),(-3.0,2.0),(-2.0,3.0),(1.0,2.0),(2.0,2.0),(7.0,3.0),(12.0,2.0),(5.0,0.0),(3.0,-4.0),(-2.0,-3.0),(10.0,0.0),(-2.0,0.0),(2.0,0.0),(-10.0,1.0),(2.0,3.0),(-4.0,3.0),(-5.0,0.0),(-12.0,-3.0),(-7.0,-3.0),(-2.0,-2.0),(0.0,-2.0),(3.0,-3.0),(0.0,-10.0),(3.0,-2.0),(3.0,0.0),(8.0,0.0),(-1.0,-5.0),(0.0,-4.0),(0.0,-5.0),(8.0,-6.0),(9.0,-4.0),(-2.0,-6.0),(8.0,-3.0),(-1.0,-5.0),(10.0,-2.0),(-1.0,-2.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(1.0,1.0),(0.0,2.0),(-10.0,2.0),(1.0,5.0),(-8.0,3.0),(2.0,6.0),(-10.0,4.0),(-7.0,6.0),(0.0,5.0),(1.0,4.0),(0.0,4.0),(-9.0,0.0),(-3.0,0.0),(-3.0,3.0),(-4.0,3.0),(1.0,3.0),(3.0,6.0),(9.0,4.0),(11.0,2.0),(2.0,-2.0),(0.0,-1.0),(-1.0,2.0),(-2.0,1.0),(-11.0,-3.0),(-9.0,-4.0),(-3.0,-6.0),(-1.0,-3.0),(0.0,-5.0),(5.0,-3.0),(4.0,-2.0),(2.0,0.0),(0.0,-5.0),(1.0,-5.0),(3.0,-3.0),(6.0,-6.0),(-2.0,-6.0),(10.0,-5.0),(0.0,-2.0),(10.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-10.0,3.0),(0.0,2.0),(-10.0,5.0),(2.0,6.0),(-7.0,6.0),(-3.0,3.0),(-1.0,5.0),(0.0,5.0),(-2.0,0.0),(-4.0,2.0),(-4.0,3.0),(0.0,3.0),(5.0,5.0),(9.0,5.0),(0.0,-1.0),(0.0,1.0),(-10.0,-6.0),(-5.0,-5.0),(0.0,-5.0),(0.0,-3.0),(5.0,-2.0),(4.0,-2.0),(0.0,-7.0),(2.0,-7.0),(7.0,-10.0),(0.0,-2.0),(11.0,-3.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-11.0,3.0),(0.0,2.0),(-8.0,10.0),(-2.0,7.0),(0.0,7.0),(-4.0,2.0),(-4.0,2.0),(0.0,3.0),(4.0,4.0),(-3.0,-11.0),(-2.0,-3.0),(0.0,-2.0),(4.0,-1.0),(0.0,-5.0),(1.0,-6.0),(3.0,-4.0),(10.0,-7.0),(0.0,0.0),(0.0,1.0),(-11.0,7.0),(-3.0,4.0),(-1.0,6.0),(0.0,5.0),(-3.0,1.0),(0.0,1.0),(0.0,-8.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(3.0,-4.0),(3.0,-5.0),(2.0,-2.0),(-3.0,3.0),(-3.0,5.0),(-2.0,4.0),(131.0,121.0),(-131.0,-122.0),(130.0,123.0),(-131.0,-121.0),(132.0,122.0),(-131.0,-122.0),(130.0,121.0),(-131.0,-121.0),(132.0,120.0),(-131.0,-122.0),(132.0,120.0),(-130.0,-123.0),(132.0,120.0),(-128.0,-125.0),(130.0,123.0),(-129.0,-125.0),(127.0,127.0),(-129.0,-125.0),(-3.0,5.0),(130.0,124.0),(-2.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(1.0,-2.0),(1.0,-3.0),(0.0,0.0),(0.0,1.0),(-5.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(0.0,0.0),(-4.0,0.0),(-1.0,1.0),(0.0,2.0),(0.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-2.0),(0.0,-2.0),(-6.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(0.0,-1.0),(-6.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(-1.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,-2.0),(-5.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-1.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(-6.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-5.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,1.0),(-5.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(-5.0,0.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(-5.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(-4.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(-4.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(0.0,-1.0),(-3.0,0.0),(0.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(0.0,0.0),(0.0,1.0),(-1.0,1.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,-1.0),(-6.0,0.0),(-6.0,0.0),(4.0,0.0),(3.0,0.0),(0.0,-2.0),(-2.0,-2.0),(2.0,1.0),(0.0,0.0),(0.0,0.0),(-2.0,-1.0),(2.0,3.0),(-1.0,2.0),(0.0,0.0),(0.0,2.0),(0.0,1.0),(-3.0,0.0),(3.0,0.0),(0.0,0.0),(0.0,-2.0),(-4.0,0.0),(0.0,0.0),(0.0,-2.0),(-2.0,0.0),(4.0,-2.0),(0.0,-3.0),(0.0,0.0),(0.0,1.0),(-1.0,3.0),(-3.0,2.0),(3.0,0.0),(-1.0,0.0),(0.0,2.0),(0.0,0.0),(0.0,1.0),(0.0,0.0),(-2.0,0.0),(0.0,0.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-3.0,-1.0),(0.0,-1.0),(0.0,0.0),(0.0,-1.0),(-2.0,-1.0),(0.0,-1.0),(1.0,0.0),(2.0,-1.0),(-1.0,0.0),(0.0,-2.0),(2.0,0.0),(0.0,0.0),(-2.0,0.0),(2.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,1.0),(1.0,2.0),(0.0,0.0),(-1.0,2.0),(0.0,1.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-2.0,-2.0),(0.0,-1.0),(-1.0,-1.0),(0.0,0.0),(1.0,0.0),(0.0,-2.0),(-1.0,0.0),(0.0,0.0),(0.0,0.0),(1.0,1.0),(0.0,1.0),(-1.0,0.0),(0.0,0.0),(1.0,2.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(-1.0,-1.0),(-2.0,-1.0),(1.0,1.0),(-1.0,-2.0),(0.0,0.0),(2.0,0.0),(0.0,0.0),(-1.0,0.0),(0.0,1.0),(0.0,1.0),(0.0,0.0),(-1.0,-2.0),(0.0,-1.0),(0.0,1.0),(0.0,0.0),(0.7762,0.0558)])]),
          fieldValue(name='pos',value=0.004884),
          fieldValue(name='coord',
            children=[
            Coordinate(point=[(-8.0,-9.0,4.0),(-7.0,-7.0,5.0),(-3.0,0.0,5.0),(8.0,7.0,-5.0),(9.0,8.0,-6.0),(5.0,-2.0,-1.0),(1.0,0.0,-1.0),(0.0,-5.0,-3.0),(-7.0,-9.0,4.0),(-8.0,-7.0,7.0),(-2.0,-1.0,3.0),(8.0,7.0,-5.0),(7.0,9.0,-4.0),(-7.0,-24.0,31.0),(3.0,7.0,-5.0),(3.0,0.0,-2.0),(-1.0,-5.0,1.0),(-10.0,-10.0,7.0),(-10.0,-3.0,5.0),(-3.0,0.0,2.0),(7.0,3.0,-3.0),(-13.0,-7.0,30.0),(11.0,6.0,-4.0),(5.0,6.0,-5.0),(3.0,0.0,0.0),(-4.0,-7.0,6.0),(-11.0,-7.0,3.0),(-9.0,-4.0,3.0),(-5.0,0.0,0.0),(-33.0,-4.0,38.0),(9.0,6.0,-2.0),(14.0,8.0,-2.0),(7.0,4.0,-6.0),(2.0,0.0,2.0),(-8.0,-5.0,9.0),(-13.0,-9.0,1.0),(-9.0,-5.0,2.0),(-33.0,5.0,40.0),(-1.0,1.0,-3.0),(7.0,6.0,-3.0),(11.0,10.0,-2.0),(8.0,5.0,-6.0),(0.0,0.0,4.0),(-7.0,-7.0,8.0),(-11.0,-9.0,1.0),(-25.0,14.0,51.0),(-6.0,-8.0,0.0),(-1.0,1.0,-2.0),(5.0,9.0,-1.0),(9.0,10.0,-2.0),(3.0,5.0,-5.0),(2.0,-1.0,3.0),(-3.0,-5.0,5.0),(-27.0,23.0,49.0),(-7.0,-12.0,3.0),(-5.0,-8.0,1.0),(0.0,1.0,-3.0),(3.0,10.0,-1.0),(8.0,12.0,-2.0),(2.0,7.0,-2.0),(2.0,0.0,1.0),(-24.0,16.0,35.0),(0.0,-9.0,2.0),(-6.0,-12.0,2.0),(-4.0,-9.0,0.0),(-1.0,2.0,-1.0),(4.0,10.0,-1.0),(5.0,12.0,-2.0),(0.0,8.0,-1.0),(-26.0,-5.0,32.0),(-6.0,-7.0,9.0),(0.0,-2.0,1.0),(1.0,0.0,0.0),(2.0,1.0,-1.0),(6.0,7.0,-8.0),(-2.0,-9.0,5.0),(-3.0,-12.0,1.0),(-5.0,-10.0,0.0),(-2.0,2.0,-2.0),(5.0,11.0,-1.0),(4.0,11.0,-1.0),(-7.0,-8.0,9.0),(0.0,-2.0,2.0),(2.0,0.0,0.0),(0.0,0.0,0.0),(-4.0,-13.0,1.0),(-5.0,-10.0,0.0),(-2.0,2.0,-1.0),(5.0,10.0,0.0),(0.0,-2.0,2.0),(0.0,-1.0,0.0),(-5.0,-10.0,0.0),(0.0,1.0,-1.0),(204.0,22.0,-332.0),(-3.0,-6.0,4.0),(-4.0,-5.0,7.0),(-1.0,1.0,5.0),(5.0,6.0,-8.0),(3.0,4.0,-6.0),(5.0,-1.0,-1.0),(1.0,0.0,-1.0),(0.0,-8.0,0.0),(-4.0,-10.0,8.0),(-5.0,-5.0,9.0),(0.0,1.0,3.0),(5.0,7.0,-9.0),(5.0,8.0,-7.0),(0.0,-16.0,34.0),(2.0,6.0,-9.0),(3.0,2.0,-3.0),(-1.0,-7.0,3.0),(-8.0,-11.0,15.0),(-9.0,-6.0,12.0),(-3.0,0.0,4.0),(6.0,5.0,-9.0),(-6.0,-1.0,32.0),(9.0,9.0,-13.0),(3.0,5.0,-9.0),(3.0,1.0,-2.0),(-2.0,-6.0,10.0),(-9.0,-9.0,11.0),(-9.0,-6.0,11.0),(-5.0,0.0,2.0),(-24.0,1.0,44.0),(7.0,6.0,-9.0),(14.0,11.0,-13.0),(5.0,3.0,-10.0),(2.0,1.0,2.0),(-4.0,-3.0,11.0),(-13.0,-12.0,12.0),(-8.0,-6.0,8.0),(-27.0,6.0,38.0),(-2.0,0.0,-2.0),(6.0,8.0,-7.0),(11.0,12.0,-11.0),(6.0,8.0,-10.0),(2.0,0.0,3.0),(-5.0,-7.0,11.0),(-11.0,-12.0,10.0),(-23.0,15.0,42.0),(-6.0,-10.0,5.0),(-3.0,0.0,-1.0),(6.0,10.0,-6.0),(8.0,10.0,-9.0),(1.0,7.0,-7.0),(3.0,0.0,3.0),(-1.0,-6.0,7.0),(-32.0,26.0,45.0),(-7.0,-12.0,5.0),(-3.0,-8.0,2.0),(-2.0,1.0,0.0),(3.0,8.0,-3.0),(6.0,12.0,-5.0),(1.0,6.0,-3.0),(3.0,0.0,0.0),(-32.0,20.0,36.0),(0.0,-6.0,2.0),(-2.0,-11.0,2.0),(-2.0,-9.0,2.0),(0.0,0.0,0.0),(1.0,10.0,-3.0),(1.0,11.0,-2.0),(0.0,6.0,-1.0),(-27.0,4.0,29.0),(-3.0,-5.0,7.0),(0.0,0.0,0.0),(1.0,1.0,0.0),(1.0,1.0,-2.0),(4.0,3.0,-6.0),(1.0,-6.0,2.0),(-1.0,-12.0,5.0),(0.0,-11.0,3.0),(0.0,0.0,0.0),(0.0,11.0,-5.0),(-1.0,12.0,-2.0),(-3.0,-5.0,7.0),(0.0,0.0,0.0),(1.0,0.0,0.0),(0.0,0.0,0.0),(0.0,-13.0,4.0),(-1.0,-12.0,5.0),(0.0,0.0,0.0),(0.0,11.0,-4.0),(0.0,0.0,1.0),(0.0,0.0,0.0),(-1.0,-12.0,4.0),(0.0,0.0,0.0),(8.0,52.0,-38.0),(0.0,0.0,0.0),(0.0,-1.0,0.0),(0.0,-5.0,3.0),(0.0,-1.0,2.0),(1.0,-1.0,0.0),(1.0,1.0,-1.0),(0.0,5.0,-3.0),(7.0,0.0,-8.0),(0.0,1.0,-1.0),(-2.0,0.0,0.0),(0.0,-1.0,0.0),(0.0,-4.0,3.0),(1.0,-2.0,1.0),(1.0,0.0,0.0),(0.0,0.0,0.0),(29.0,-9.0,-29.0),(0.0,4.0,-2.0),(-1.0,2.0,-1.0),(-3.0,0.0,0.0),(0.0,-1.0,0.0),(0.0,-4.0,3.0),(1.0,-2.0,1.0),(2.0,-1.0,0.0),(27.0,-15.0,-27.0),(1.0,0.0,-1.0),(0.0,6.0,-2.0),(-1.0,2.0,-2.0),(-3.0,0.0,0.0),(-1.0,-1.0,0.0),(0.0,-5.0,3.0),(1.0,-2.0,0.0),(31.0,-27.0,-46.0),(2.0,0.0,2.0),(2.0,2.0,-1.0),(1.0,6.0,-6.0),(-1.0,2.0,-3.0),(-3.0,0.0,-2.0),(-2.0,-2.0,0.0),(0.0,-7.0,6.0),(37.0,-17.0,-54.0),(0.0,0.0,5.0),(2.0,0.0,1.0),(2.0,2.0,-1.0),(3.0,6.0,-7.0),(0.0,1.0,-4.0),(-1.0,-1.0,-3.0),(-1.0,-2.0,0.0),(24.0,-13.0,-37.0),(-2.0,-6.0,8.0),(0.0,0.0,4.0),(2.0,0.0,1.0),(2.0,2.0,-2.0),(2.0,6.0,-9.0),(-1.0,0.0,-2.0),(0.0,0.0,-2.0),(10.0,-1.0,-31.0),(-2.0,-3.0,2.0),(-3.0,-5.0,9.0),(1.0,-1.0,1.0),(3.0,0.0,-1.0),(2.0,2.0,-3.0),(3.0,7.0,-7.0),(0.0,1.0,-2.0),(2.0,6.0,-30.0),(-9.0,12.0,-27.0),(-9.0,3.0,-5.0),(-1.0,-2.0,4.0),(9.0,-4.0,5.0),(7.0,-11.0,27.0),(-2.0,-4.0,2.0),(-4.0,-9.0,10.0),(1.0,-1.0,1.0),(3.0,1.0,-3.0),(3.0,4.0,-5.0),(2.0,9.0,-7.0),(-9.0,11.0,-28.0),(-10.0,3.0,-5.0),(-2.0,-4.0,8.0),(7.0,-4.0,5.0),(-3.0,-13.0,9.0),(0.0,-1.0,0.0),(2.0,2.0,-2.0),(2.0,5.0,-6.0),(-9.0,2.0,-5.0),(-4.0,-4.0,8.0),(0.0,-2.0,0.0),(1.0,2.0,-4.0),(-792.0,-11.0,-253.0),(2.0,-8.0,11.0),(4.0,-5.0,8.0),(0.0,1.0,-7.0),(-3.0,6.0,-10.0),(-3.0,7.0,-9.0),(-3.0,-10.0,-3.0),(-1.0,7.0,3.0),(0.0,0.0,3.0),(1.0,-9.0,0.0),(3.0,-7.0,9.0),(3.0,-5.0,7.0),(0.0,1.0,-6.0),(-2.0,3.0,-9.0),(-15.0,-16.0,32.0),(-3.0,7.0,-12.0),(-1.0,7.0,0.0),(1.0,0.0,4.0),(0.0,-7.0,7.0),(6.0,-6.0,10.0),(3.0,-5.0,8.0),(-1.0,-1.0,-6.0),(-9.0,0.0,39.0),(-6.0,4.0,-10.0),(-6.0,7.0,-8.0),(0.0,3.0,-6.0),(4.0,0.0,2.0),(0.0,-4.0,7.0),(6.0,-6.0,11.0),(6.0,-3.0,8.0),(2.0,5.0,56.0),(-4.0,0.0,0.0),(-6.0,6.0,-6.0),(-10.0,8.0,-10.0),(0.0,2.0,-11.0),(4.0,0.0,-1.0),(1.0,-3.0,10.0),(10.0,-6.0,12.0),(5.0,15.0,60.0),(3.0,-7.0,6.0),(-3.0,0.0,1.0),(-4.0,7.0,-6.0),(-8.0,10.0,-8.0),(-1.0,6.0,-11.0),(3.0,0.0,-2.0),(2.0,-6.0,12.0),(-3.0,27.0,67.0),(5.0,-10.0,6.0),(3.0,-9.0,4.0),(-4.0,0.0,-1.0),(-3.0,9.0,-3.0),(-5.0,10.0,-6.0),(1.0,7.0,-6.0),(4.0,1.0,0.0),(0.0,37.0,67.0),(0.0,-8.0,4.0),(4.0,-13.0,6.0),(1.0,-9.0,2.0),(-4.0,-1.0,0.0),(-2.0,9.0,-4.0),(-2.0,13.0,-5.0),(1.0,9.0,-4.0),(8.0,23.0,49.0),(10.0,-5.0,48.0),(0.0,-8.0,11.0),(1.0,0.0,1.0),(2.0,1.0,0.0),(0.0,1.0,-2.0),(-1.0,9.0,-11.0),(-11.0,4.0,-46.0),(-1.0,-9.0,2.0),(3.0,-12.0,3.0),(0.0,-11.0,2.0),(-2.0,0.0,0.0),(-2.0,10.0,-3.0),(-1.0,11.0,-2.0),(8.0,-4.0,47.0),(1.0,-9.0,12.0),(1.0,0.0,1.0),(2.0,1.0,0.0),(0.0,2.0,-2.0),(0.0,7.0,-10.0),(2.0,-12.0,4.0),(1.0,-12.0,1.0),(-4.0,0.0,0.0),(-1.0,10.0,-1.0),(1.0,-9.0,10.0),(0.0,0.0,1.0),(2.0,1.0,0.0),(1.0,0.0,-1.0),(1.0,-12.0,3.0),(-2.0,-1.0,0.0),(0.0,0.0,0.0),(2.0,0.0,0.0),(2.0,-40.0,-434.0),(-1.0,-6.0,6.0),(0.0,-5.0,9.0),(2.0,-1.0,-6.0),(1.0,6.0,-8.0),(0.0,5.0,-6.0),(-5.0,-11.0,-3.0),(0.0,8.0,2.0),(0.0,2.0,1.0),(-2.0,-10.0,3.0),(-1.0,-6.0,8.0),(0.0,-6.0,10.0),(1.0,-1.0,-4.0),(0.0,3.0,-9.0),(-22.0,-7.0,30.0),(3.0,7.0,-18.0),(1.0,6.0,-2.0),(0.0,0.0,5.0),(-4.0,-6.0,9.0),(-1.0,-6.0,16.0),(0.0,-5.0,12.0),(0.0,0.0,-6.0),(-16.0,7.0,37.0),(0.0,3.0,-14.0),(0.0,8.0,-17.0),(4.0,2.0,-8.0),(1.0,0.0,4.0),(-3.0,-4.0,10.0),(0.0,-6.0,17.0),(0.0,-3.0,15.0),(-6.0,12.0,55.0),(-4.0,1.0,-2.0),(-1.0,6.0,-12.0),(-2.0,8.0,-19.0),(2.0,1.0,-13.0),(3.0,-1.0,1.0),(-1.0,-2.0,14.0),(3.0,-7.0,20.0),(1.0,17.0,55.0),(0.0,-7.0,8.0),(-4.0,1.0,0.0),(-1.0,9.0,-10.0),(-2.0,12.0,-16.0),(2.0,3.0,-14.0),(3.0,-1.0,0.0),(-1.0,-4.0,14.0),(0.0,25.0,61.0),(0.0,-11.0,12.0),(0.0,-6.0,7.0),(-4.0,0.0,-2.0),(0.0,8.0,-7.0),(-1.0,11.0,-12.0),(3.0,5.0,-7.0),(5.0,0.0,1.0),(5.0,38.0,70.0),(-1.0,-6.0,4.0),(1.0,-12.0,7.0),(-1.0,-8.0,3.0),(-2.0,0.0,-1.0),(0.0,9.0,-5.0),(-1.0,12.0,-7.0),(2.0,7.0,-3.0),(16.0,27.0,55.0),(14.0,4.0,46.0),(0.0,-5.0,8.0),(0.0,-1.0,1.0),(0.0,0.0,0.0),(1.0,1.0,-1.0),(0.0,4.0,-8.0),(-14.0,-4.0,-45.0),(-2.0,-6.0,1.0),(-1.0,-11.0,3.0),(-2.0,-9.0,2.0),(0.0,0.0,-2.0),(1.0,10.0,-2.0),(1.0,12.0,-2.0),(12.0,3.0,45.0),(0.0,-5.0,9.0),(0.0,-1.0,1.0),(1.0,0.0,0.0),(0.0,1.0,-1.0),(0.0,4.0,-8.0),(-4.0,-12.0,3.0),(-5.0,-11.0,1.0),(0.0,1.0,-1.0),(3.0,10.0,-3.0),(0.0,-5.0,11.0),(0.0,-1.0,1.0),(0.0,0.0,0.0),(0.0,0.0,0.0),(-3.0,-11.0,4.0),(0.0,0.0,-1.0),(0.0,-1.0,2.0),(0.0,0.0,0.0),(19.0,50.0,-38.0),(-2.0,0.0,0.0),(-2.0,-2.0,1.0),(-1.0,-5.0,3.0),(0.0,0.0,0.0),(2.0,1.0,0.0),(3.0,2.0,0.0),(1.0,4.0,-2.0),(-4.0,0.0,-13.0),(0.0,0.0,0.0),(-3.0,-1.0,-1.0),(-2.0,-2.0,0.0),(-1.0,-3.0,2.0),(1.0,0.0,2.0),(2.0,1.0,0.0),(1.0,0.0,0.0),(-15.0,-11.0,-48.0),(1.0,4.0,-2.0),(-1.0,0.0,-1.0),(-2.0,-1.0,0.0),(-2.0,-2.0,1.0),(0.0,-4.0,2.0),(0.0,0.0,1.0),(2.0,0.0,0.0),(-12.0,-22.0,-42.0),(2.0,2.0,-1.0),(1.0,5.0,-2.0),(-1.0,0.0,-1.0),(-4.0,0.0,0.0),(-2.0,-2.0,1.0),(0.0,-5.0,2.0),(0.0,-2.0,0.0),(-6.0,-38.0,-65.0),(3.0,0.0,-1.0),(3.0,2.0,-2.0),(2.0,6.0,-8.0),(-2.0,1.0,0.0),(-3.0,0.0,1.0),(-3.0,-2.0,2.0),(-3.0,-6.0,7.0),(-1.0,-30.0,-74.0),(2.0,-2.0,1.0),(3.0,0.0,-2.0),(2.0,1.0,-4.0),(0.0,3.0,-9.0),(0.0,2.0,-1.0),(-4.0,1.0,2.0),(-1.0,0.0,2.0),(2.0,-27.0,-54.0),(-2.0,-4.0,8.0),(1.0,-1.0,3.0),(3.0,0.0,-2.0),(2.0,1.0,-2.0),(2.0,3.0,-9.0),(-1.0,2.0,-2.0),(-2.0,0.0,0.0),(10.0,-10.0,-38.0),(-1.0,-2.0,2.0),(-1.0,-5.0,9.0),(0.0,-1.0,5.0),(2.0,0.0,1.0),(1.0,2.0,-1.0),(2.0,4.0,-11.0),(0.0,2.0,-4.0),(16.0,-2.0,-26.0),(23.0,8.0,-18.0),(10.0,4.0,0.0),(0.0,1.0,-3.0),(-11.0,-4.0,0.0),(-24.0,-8.0,18.0),(-1.0,-3.0,1.0),(-1.0,-8.0,9.0),(0.0,-1.0,4.0),(0.0,1.0,5.0),(1.0,1.0,-1.0),(3.0,6.0,-10.0),(22.0,6.0,-17.0),(9.0,5.0,0.0),(2.0,2.0,-9.0),(-12.0,-4.0,0.0),(-2.0,-12.0,11.0),(0.0,-3.0,5.0),(0.0,0.0,4.0),(1.0,3.0,-1.0),(9.0,4.0,0.0),(2.0,0.0,-9.0),(-2.0,-3.0,7.0),(0.0,0.0,4.0),(223.0,1975.0,531.0),(31.0,-13.0,30.0),(3.0,39.0,10.0),(-31.0,13.0,-31.0),(32.0,8.0,-29.0),(-2.0,-39.0,-10.0),(32.0,-12.0,30.0),(2.0,39.0,10.0),(-6.0,7.0,-17.0),(-7.0,2.0,-7.0),(-4.0,-14.0,-13.0),(0.0,-18.0,-7.0),(20.0,-7.0,20.0),(0.0,18.0,6.0),(10.0,9.0,-10.0),(-9.0,15.0,2.0),(-7.0,2.0,-6.0),(-1.0,-11.0,-13.0),(4.0,-14.0,-7.0),(16.0,-6.0,15.0),(14.0,18.0,-10.0),(-6.0,9.0,11.0),(-11.0,10.0,2.0),(-4.0,1.0,-5.0),(0.0,-6.0,-13.0),(8.0,-8.0,-9.0),(11.0,17.0,-1.0),(11.0,-4.0,11.0),(-6.0,5.0,10.0),(-11.0,7.0,2.0),(-3.0,1.0,-4.0),(1.0,-2.0,-12.0),(5.0,12.0,0.0),(8.0,-3.0,-6.0),(10.0,-4.0,10.0),(-6.0,2.0,9.0),(-11.0,4.0,2.0),(-2.0,2.0,-3.0),(6.0,32.0,6.0),(0.0,8.0,2.0),(-2.0,-19.0,-6.0),(-1.0,-13.0,-2.0),(1.0,2.0,-10.0),(9.0,0.0,-5.0),(8.0,-4.0,9.0),(-6.0,0.0,8.0),(-9.0,1.0,2.0),(2.0,13.0,2.0),(0.0,11.0,3.0),(0.0,9.0,2.0),(-1.0,8.0,2.0),(0.0,1.0,-1.0),(0.0,4.0,-1.0),(0.0,-10.0,-7.0),(-1.0,-8.0,-5.0),(0.0,-11.0,-5.0),(9.0,0.0,-2.0),(5.0,-3.0,6.0),(-4.0,-1.0,7.0),(-1.0,12.0,3.0),(-2.0,9.0,3.0),(-3.0,10.0,4.0),(1.0,-1.0,-5.0),(0.0,0.0,-1.0),(2.0,-6.0,-7.0),(1.0,-8.0,-4.0),(4.0,-1.0,4.0),(-3.0,7.0,4.0),(-128.0,-67.0,-99.0),(54.0,-13.0,16.0),(1.0,35.0,18.0),(-53.0,15.0,-16.0),(22.0,20.0,-35.0),(-1.0,-36.0,-18.0),(54.0,-13.0,16.0),(0.0,36.0,18.0),(-16.0,9.0,-13.0),(-12.0,2.0,-4.0),(-9.0,-11.0,-14.0),(0.0,-15.0,-10.0),(34.0,-8.0,10.0),(0.0,15.0,10.0),(5.0,13.0,-9.0),(-12.0,13.0,8.0),(-11.0,2.0,-3.0),(-6.0,-8.0,-15.0),(3.0,-11.0,-11.0),(28.0,-7.0,7.0),(8.0,23.0,-7.0),(-3.0,5.0,13.0),(-13.0,7.0,8.0),(-9.0,1.0,-2.0),(-4.0,-2.0,-15.0),(6.0,-5.0,-12.0),(8.0,19.0,0.0),(19.0,-4.0,6.0),(-2.0,1.0,12.0),(-13.0,4.0,7.0),(-7.0,2.0,-2.0),(-4.0,1.0,-12.0),(4.0,12.0,1.0),(7.0,0.0,-8.0),(17.0,-5.0,5.0),(-2.0,0.0,11.0),(-12.0,1.0,5.0),(-6.0,2.0,-1.0),(5.0,31.0,12.0),(0.0,7.0,4.0),(-1.0,-18.0,-10.0),(-2.0,-11.0,-5.0),(-3.0,5.0,-9.0),(8.0,1.0,-7.0),(14.0,-4.0,5.0),(-2.0,-4.0,9.0),(-11.0,0.0,4.0),(1.0,13.0,5.0),(0.0,10.0,6.0),(-1.0,8.0,4.0),(-1.0,7.0,4.0),(-2.0,0.0,0.0),(-1.0,5.0,0.0),(-1.0,-8.0,-10.0),(-1.0,-7.0,-6.0),(-1.0,-9.0,-7.0),(8.0,2.0,-4.0),(9.0,-3.0,3.0),(0.0,-3.0,7.0),(-2.0,10.0,6.0),(-2.0,8.0,6.0),(-4.0,8.0,7.0),(0.0,0.0,-5.0),(-2.0,0.0,-1.0),(1.0,-4.0,-8.0),(0.0,-6.0,-6.0),(7.0,-1.0,2.0),(-2.0,5.0,7.0),(-180.0,-148.0,2.0),(57.0,-7.0,0.0),(3.0,43.0,20.0),(-57.0,8.0,0.0),(9.0,22.0,-40.0),(-3.0,-44.0,-20.0),(57.0,-7.0,0.0),(3.0,43.0,20.0),(-20.0,8.0,-8.0),(-13.0,1.0,0.0),(-13.0,-16.0,-12.0),(0.0,-19.0,-11.0),(37.0,-4.0,0.0),(1.0,19.0,11.0),(0.0,14.0,-10.0),(-10.0,14.0,12.0),(-12.0,1.0,0.0),(-9.0,-11.0,-13.0),(1.0,-15.0,-14.0),(30.0,-3.0,0.0),(3.0,25.0,-8.0),(0.0,8.0,14.0),(-11.0,8.0,13.0),(-9.0,0.0,0.0),(-8.0,-5.0,-14.0),(3.0,-7.0,-14.0),(5.0,23.0,-1.0),(22.0,-2.0,0.0),(0.0,3.0,13.0),(-10.0,4.0,10.0),(-8.0,0.0,0.0),(-7.0,0.0,-10.0),(3.0,14.0,1.0),(4.0,0.0,-10.0),(19.0,-2.0,0.0),(0.0,0.0,11.0),(-10.0,1.0,9.0),(-6.0,1.0,0.0),(5.0,37.0,13.0),(1.0,9.0,5.0),(-3.0,-22.0,-11.0),(-2.0,-14.0,-6.0),(-5.0,4.0,-7.0),(5.0,2.0,-9.0),(15.0,-2.0,0.0),(1.0,-4.0,10.0),(-9.0,-1.0,7.0),(1.0,16.0,6.0),(0.0,12.0,5.0),(0.0,9.0,6.0),(0.0,9.0,6.0),(-2.0,0.0,0.0),(-2.0,5.0,0.0),(-3.0,-11.0,-10.0),(-2.0,-8.0,-7.0),(-1.0,-11.0,-7.0),(5.0,2.0,-6.0),(11.0,-2.0,0.0),(2.0,-3.0,7.0),(-1.0,13.0,7.0),(-2.0,9.0,7.0),(-2.0,10.0,9.0),(-1.0,-1.0,-6.0),(-3.0,0.0,0.0),(-2.0,-6.0,-8.0),(0.0,-7.0,-7.0),(8.0,0.0,0.0),(-1.0,6.0,8.0),(-155.0,-149.0,17.0),(57.0,0.0,-2.0),(-1.0,24.0,28.0),(-57.0,0.0,1.0),(5.0,34.0,-30.0),(0.0,-24.0,-27.0),(57.0,1.0,-2.0),(-1.0,24.0,27.0),(-21.0,5.0,-5.0),(-13.0,0.0,0.0),(-10.0,-8.0,-13.0),(0.0,-8.0,-15.0),(37.0,0.0,-1.0),(-2.0,9.0,14.0),(0.0,16.0,-6.0),(-11.0,3.0,14.0),(-13.0,0.0,0.0),(-8.0,-4.0,-13.0),(2.0,-4.0,-15.0),(30.0,0.0,-2.0),(-1.0,22.0,-2.0),(0.0,0.0,14.0),(-10.0,0.0,13.0),(-10.0,0.0,0.0),(-7.0,1.0,-12.0),(2.0,0.0,-14.0),(3.0,19.0,3.0),(22.0,0.0,0.0),(0.0,-3.0,12.0),(-10.0,-2.0,10.0),(-8.0,0.0,0.0),(-7.0,3.0,-9.0),(1.0,11.0,4.0),(4.0,4.0,-10.0),(19.0,0.0,0.0),(0.0,-5.0,10.0),(-9.0,-3.0,9.0),(-6.0,0.0,0.0),(0.0,23.0,19.0),(0.0,4.0,6.0),(0.0,-12.0,-14.0),(-1.0,-8.0,-8.0),(-6.0,5.0,-6.0),(4.0,6.0,-8.0),(16.0,0.0,0.0),(1.0,-6.0,8.0),(-9.0,-5.0,7.0),(0.0,9.0,8.0),(-1.0,7.0,7.0),(0.0,5.0,7.0),(-1.0,4.0,7.0),(-3.0,0.0,0.0),(-2.0,3.0,1.0),(-2.0,-4.0,-11.0),(-1.0,-4.0,-7.0),(-1.0,-6.0,-9.0),(5.0,5.0,-6.0),(11.0,0.0,0.0),(3.0,-5.0,6.0),(-3.0,7.0,9.0),(-2.0,4.0,7.0),(-3.0,4.0,11.0),(-2.0,0.0,-5.0),(-2.0,0.0,0.0),(-1.0,-1.0,-9.0),(0.0,-2.0,-7.0),(7.0,0.0,0.0),(-1.0,2.0,8.0),(-124.0,-187.0,88.0),(53.0,-3.0,-9.0),(4.0,22.0,27.0),(-53.0,4.0,10.0),(4.0,34.0,-30.0),(-4.0,-23.0,-27.0),(54.0,-3.0,-10.0),(3.0,22.0,26.0),(-20.0,9.0,0.0),(-12.0,0.0,1.0),(-12.0,-7.0,-12.0),(-2.0,-8.0,-15.0),(35.0,-2.0,-6.0),(1.0,9.0,14.0),(0.0,15.0,-5.0),(-8.0,4.0,16.0),(-12.0,0.0,1.0),(-9.0,-2.0,-12.0),(0.0,-5.0,-15.0),(28.0,-1.0,-6.0),(1.0,22.0,-2.0),(1.0,-1.0,15.0),(-9.0,0.0,14.0),(-9.0,1.0,1.0),(-8.0,2.0,-11.0),(1.0,1.0,-14.0),(5.0,17.0,3.0),(20.0,-2.0,-3.0),(1.0,-3.0,11.0),(-9.0,-2.0,12.0),(-7.0,1.0,1.0),(-7.0,4.0,-8.0),(3.0,10.0,4.0),(2.0,4.0,-11.0),(18.0,-1.0,-2.0),(1.0,-5.0,9.0),(-8.0,-3.0,10.0),(-6.0,0.0,1.0),(5.0,22.0,19.0),(1.0,4.0,6.0),(-3.0,-11.0,-14.0),(-2.0,-8.0,-8.0),(-6.0,7.0,-5.0),(4.0,5.0,-8.0),(14.0,-1.0,-2.0),(1.0,-7.0,7.0),(-7.0,-4.0,8.0),(1.0,9.0,8.0),(1.0,6.0,8.0),(0.0,5.0,6.0),(0.0,3.0,7.0),(-2.0,0.0,1.0),(-1.0,3.0,1.0),(-4.0,-3.0,-10.0),(-2.0,-4.0,-7.0),(-2.0,-4.0,-9.0),(4.0,4.0,-6.0),(11.0,0.0,-1.0),(2.0,-6.0,4.0),(-1.0,6.0,10.0),(0.0,4.0,8.0),(-2.0,3.0,10.0),(-2.0,1.0,-4.0),(-2.0,0.0,0.0),(-3.0,-1.0,-8.0),(0.0,-1.0,-8.0),(7.0,0.0,-1.0),(0.0,1.0,8.0),(786.0,-240.0,-286.0),(42.0,-7.0,-15.0),(4.0,38.0,-12.0),(-42.0,7.0,14.0),(-17.0,-8.0,-40.0),(-4.0,-38.0,12.0),(42.0,-7.0,-16.0),(4.0,37.0,-13.0),(-14.0,-17.0,-1.0),(-5.0,19.0,0.0),(-10.0,1.0,4.0),(-12.0,-16.0,5.0),(-3.0,-18.0,3.0),(26.0,-5.0,-10.0),(-8.0,6.0,-19.0),(5.0,16.0,1.0),(-4.0,16.0,3.0),(-9.0,1.0,3.0),(-11.0,-13.0,1.0),(-4.0,-16.0,-1.0),(-3.0,9.0,-23.0),(19.0,-3.0,-5.0),(6.0,12.0,5.0),(-3.0,13.0,7.0),(-7.0,0.0,2.0),(-12.0,-8.0,-3.0),(-1.0,9.0,-15.0),(-3.0,-9.0,-7.0),(17.0,-3.0,-5.0),(5.0,9.0,6.0),(-3.0,9.0,9.0),(-5.0,2.0,1.0),(-1.0,6.0,-9.0),(-10.0,-4.0,-4.0),(-2.0,-6.0,-8.0),(15.0,-2.0,-4.0),(5.0,6.0,7.0),(-2.0,6.0,8.0),(2.0,31.0,-15.0),(0.0,8.0,-1.0),(-3.0,-20.0,6.0),(0.0,-11.0,5.0),(-5.0,0.0,1.0),(-9.0,-2.0,-5.0),(0.0,-3.0,-10.0),(11.0,-2.0,-3.0),(6.0,3.0,7.0),(1.0,14.0,-4.0),(1.0,12.0,-2.0),(1.0,9.0,0.0),(0.0,12.0,1.0),(-2.0,-4.0,3.0),(-2.0,0.0,0.0),(-2.0,-8.0,2.0),(-2.0,-9.0,2.0),(-1.0,-10.0,3.0),(-7.0,0.0,-4.0),(0.0,-2.0,-9.0),(8.0,-1.0,-3.0),(2.0,13.0,0.0),(2.0,9.0,1.0),(0.0,9.0,2.0),(-1.0,0.0,1.0),(0.0,4.0,3.0),(-5.0,-12.0,1.0),(-2.0,-8.0,0.0),(0.0,0.0,-6.0),(3.0,7.0,1.0),(71.0,-118.0,11.0),(58.0,0.0,4.0),(1.0,39.0,-4.0),(-57.0,0.0,-5.0),(-3.0,-1.0,-46.0),(-1.0,-40.0,5.0),(58.0,0.0,4.0),(1.0,39.0,-5.0),(-12.0,-17.0,-10.0),(-10.0,17.0,0.0),(-14.0,0.0,-2.0),(-13.0,-17.0,-2.0),(-1.0,-19.0,0.0),(37.0,0.0,2.0),(-3.0,8.0,-20.0),(1.0,16.0,5.0),(-8.0,14.0,2.0),(-13.0,0.0,-1.0),(-10.0,-14.0,-5.0),(0.0,-16.0,-5.0),(2.0,14.0,-20.0),(26.0,0.0,2.0),(1.0,11.0,9.0),(-8.0,10.0,7.0),(-10.0,0.0,-1.0),(-9.0,-9.0,-9.0),(1.0,12.0,-13.0),(1.0,-8.0,-9.0),(22.0,0.0,2.0),(2.0,9.0,10.0),(-8.0,7.0,7.0),(-7.0,0.0,-1.0),(0.0,8.0,-7.0),(-8.0,-4.0,-9.0),(1.0,-5.0,-9.0),(20.0,0.0,2.0),(2.0,5.0,10.0),(-7.0,5.0,7.0),(0.0,8.0,-4.0),(0.0,13.0,-3.0),(0.0,11.0,-2.0),(0.0,10.0,0.0),(0.0,7.0,0.0),(-2.0,0.0,0.0),(-2.0,-8.0,0.0),(-1.0,-10.0,1.0),(-1.0,-11.0,1.0),(-1.0,-13.0,2.0),(-7.0,-1.0,-9.0),(2.0,-1.0,-9.0),(16.0,0.0,2.0),(2.0,2.0,9.0),(0.0,14.0,-1.0),(-1.0,12.0,0.0),(-1.0,9.0,1.0),(-2.0,11.0,2.0),(-2.0,-2.0,-3.0),(-3.0,0.0,0.0),(-1.0,3.0,2.0),(-4.0,-13.0,-3.0),(-2.0,-9.0,-1.0),(-2.0,-12.0,0.0),(3.0,0.0,-7.0),(11.0,0.0,1.0),(-1.0,14.0,1.0),(0.0,8.0,2.0),(-6.0,0.0,-1.0),(-1.0,-9.0,-2.0),(65.0,-123.0,138.0),(54.0,4.0,21.0),(1.0,46.0,-8.0),(-52.0,-4.0,-22.0),(10.0,-4.0,-43.0),(-1.0,-46.0,7.0),(53.0,4.0,21.0),(2.0,46.0,-8.0),(-8.0,-22.0,-13.0),(-11.0,20.0,-4.0),(-12.0,-1.0,-5.0),(-11.0,-22.0,-3.0),(0.0,-22.0,0.0),(35.0,2.0,13.0),(1.0,9.0,-21.0),(0.0,19.0,2.0),(-9.0,17.0,0.0),(-12.0,-1.0,-5.0),(-8.0,-19.0,-6.0),(2.0,-18.0,-3.0),(8.0,15.0,-20.0),(23.0,1.0,9.0),(-1.0,15.0,8.0),(-10.0,11.0,3.0),(-9.0,0.0,-4.0),(-6.0,-13.0,-10.0),(5.0,14.0,-14.0),(4.0,-9.0,-7.0),(19.0,2.0,9.0),(0.0,10.0,9.0),(-10.0,7.0,3.0),(-7.0,0.0,-3.0),(2.0,10.0,-7.0),(-5.0,-6.0,-11.0),(4.0,-6.0,-7.0),(17.0,2.0,7.0),(0.0,7.0,10.0),(-9.0,4.0,4.0),(1.0,10.0,-5.0),(0.0,16.0,-4.0),(0.0,13.0,-3.0),(0.0,11.0,-1.0),(0.0,9.0,0.0),(-2.0,-1.0,-1.0),(-1.0,-10.0,0.0),(-1.0,-11.0,2.0),(-1.0,-13.0,2.0),(-2.0,-15.0,3.0),(-4.0,-3.0,-11.0),(5.0,-2.0,-8.0),(14.0,1.0,6.0),(0.0,4.0,10.0),(0.0,16.0,-3.0),(-1.0,15.0,-2.0),(-2.0,11.0,0.0),(-3.0,13.0,0.0),(0.0,-4.0,-4.0),(-3.0,0.0,0.0),(-3.0,4.0,2.0),(-2.0,-15.0,-3.0),(-1.0,-11.0,-1.0),(-2.0,-15.0,0.0),(6.0,0.0,-5.0),(10.0,1.0,4.0),(-2.0,16.0,0.0),(-1.0,10.0,1.0),(-5.0,-1.0,-3.0),(0.0,-10.0,-1.0),(38.0,-108.0,132.0),(50.0,-1.0,28.0),(-2.0,36.0,7.0),(-49.0,2.0,-27.0),(16.0,9.0,-42.0),(1.0,-35.0,-7.0),(50.0,-1.0,27.0),(-1.0,35.0,8.0),(-5.0,-12.0,-19.0),(-12.0,15.0,0.0),(-12.0,0.0,-6.0),(-7.0,-15.0,-13.0),(1.0,-16.0,-6.0),(33.0,0.0,17.0),(3.0,12.0,-16.0),(-2.0,13.0,9.0),(-11.0,11.0,3.0),(-11.0,0.0,-6.0),(-5.0,-11.0,-13.0),(3.0,-12.0,-9.0),(9.0,17.0,-13.0),(21.0,0.0,13.0),(-2.0,7.0,12.0),(-12.0,7.0,5.0),(-9.0,0.0,-5.0),(-4.0,-6.0,-15.0),(5.0,14.0,-7.0),(6.0,-4.0,-9.0),(18.0,0.0,11.0),(-2.0,4.0,12.0),(-11.0,4.0,4.0),(-6.0,0.0,-4.0),(1.0,9.0,-3.0),(-3.0,-1.0,-12.0),(5.0,-2.0,-9.0),(17.0,0.0,10.0),(-2.0,2.0,11.0),(-11.0,2.0,5.0),(0.0,30.0,2.0),(0.0,7.0,1.0),(0.0,-18.0,-4.0),(0.0,-11.0,-1.0),(-5.0,0.0,-3.0),(-3.0,1.0,-12.0),(6.0,0.0,-7.0),(13.0,0.0,8.0),(-1.0,0.0,11.0),(-1.0,12.0,2.0),(-3.0,11.0,3.0),(-2.0,8.0,3.0),(-4.0,8.0,4.0),(-3.0,-4.0,-1.0),(-1.0,0.0,-1.0),(0.0,-7.0,-4.0),(0.0,-8.0,-2.0),(0.0,-9.0,-3.0),(-3.0,2.0,-9.0),(6.0,1.0,-5.0),(9.0,0.0,5.0),(-3.0,12.0,5.0),(-2.0,6.0,5.0),(-4.0,6.0,4.0),(-2.0,0.0,0.0),(-3.0,1.0,3.0),(0.0,-9.0,-8.0),(0.0,-7.0,-5.0),(4.0,3.0,-3.0),(-1.0,6.0,6.0),(-18.0,-113.0,186.0),(45.0,7.0,30.0),(-7.0,33.0,6.0),(-44.0,-6.0,-30.0),(16.0,10.0,-41.0),(6.0,-33.0,-6.0),(45.0,7.0,29.0),(-6.0,33.0,6.0),(-2.0,-12.0,-19.0),(-13.0,11.0,0.0),(-10.0,-1.0,-7.0),(-4.0,-16.0,-12.0),(3.0,-14.0,-5.0),(30.0,4.0,18.0),(2.0,12.0,-17.0),(-4.0,12.0,9.0),(-13.0,9.0,2.0),(-9.0,-1.0,-6.0),(-3.0,-13.0,-13.0),(6.0,-11.0,-8.0),(6.0,17.0,-13.0),(20.0,3.0,13.0),(-5.0,8.0,11.0),(-12.0,4.0,5.0),(-8.0,-1.0,-5.0),(-1.0,-6.0,-15.0),(3.0,13.0,-7.0),(6.0,-3.0,-9.0),(17.0,3.0,11.0),(-4.0,4.0,12.0),(-11.0,2.0,3.0),(-5.0,0.0,-4.0),(0.0,8.0,-3.0),(-3.0,-2.0,-13.0),(7.0,-1.0,-8.0),(14.0,2.0,10.0),(-3.0,2.0,12.0),(-10.0,1.0,4.0),(-4.0,29.0,1.0),(-2.0,6.0,0.0),(4.0,-17.0,-3.0),(1.0,-11.0,-1.0),(-4.0,0.0,-3.0),(-3.0,0.0,-11.0),(7.0,1.0,-7.0),(11.0,1.0,8.0),(-1.0,0.0,11.0),(-4.0,13.0,1.0),(-4.0,10.0,3.0),(-3.0,7.0,2.0),(-6.0,7.0,4.0),(-1.0,-4.0,-1.0),(-1.0,0.0,-1.0),(2.0,-7.0,-3.0),(1.0,-8.0,-3.0),(1.0,-8.0,-2.0),(-3.0,0.0,-9.0),(6.0,3.0,-5.0),(8.0,1.0,6.0),(-4.0,11.0,4.0),(-4.0,6.0,5.0),(-4.0,5.0,4.0),(-2.0,0.0,-1.0),(-3.0,1.0,3.0),(2.0,-10.0,-8.0),(0.0,-6.0,-4.0),(4.0,3.0,-3.0),(-2.0,5.0,5.0),(-269.0,-1556.0,-2.0),(1.0,1.0,0.0),(0.0,3.0,-1.0),(-2.0,7.0,-2.0),(-3.0,1.0,0.0),(-1.0,-2.0,1.0),(0.0,-4.0,1.0),(3.0,-7.0,0.0),(7.0,-5.0,-7.0),(1.0,0.0,0.0),(2.0,1.0,-1.0),(0.0,3.0,-1.0),(-2.0,5.0,-1.0),(-2.0,0.0,0.0),(-2.0,-2.0,1.0),(0.0,-2.0,0.0),(17.0,-15.0,-30.0),(2.0,-6.0,1.0),(1.0,0.0,-2.0),(2.0,2.0,-1.0),(0.0,3.0,-1.0),(-2.0,6.0,0.0),(-2.0,0.0,1.0),(-1.0,-2.0,0.0),(9.0,-12.0,-36.0),(0.0,-3.0,1.0),(2.0,-6.0,2.0),(2.0,0.0,0.0),(3.0,1.0,-1.0),(0.0,3.0,-2.0),(-2.0,7.0,-2.0),(-2.0,0.0,0.0),(36.0,-35.0,-97.0),(-3.0,-1.0,0.0),(0.0,-3.0,1.0),(0.0,-7.0,6.0),(2.0,0.0,0.0),(3.0,0.0,-1.0),(1.0,3.0,-4.0),(-1.0,6.0,-2.0),(-13.0,-11.0,-33.0),(-2.0,1.0,-1.0),(-3.0,-1.0,0.0),(-1.0,-2.0,2.0),(0.0,-6.0,2.0),(3.0,-2.0,0.0),(3.0,1.0,-1.0),(0.0,1.0,-1.0),(-11.0,-8.0,-16.0),(-2.0,6.0,-4.0),(-1.0,1.0,0.0),(-3.0,0.0,1.0),(-1.0,-2.0,3.0),(2.0,-7.0,2.0),(2.0,-2.0,0.0),(2.0,0.0,-1.0),(-10.0,-13.0,-2.0),(-1.0,3.0,-4.0),(-1.0,7.0,-1.0),(-1.0,2.0,0.0),(-2.0,0.0,1.0),(0.0,-2.0,1.0),(1.0,-7.0,5.0),(1.0,-3.0,1.0),(-11.0,-11.0,1.0),(-14.0,-10.0,6.0),(-7.0,-2.0,4.0),(1.0,-1.0,0.0),(9.0,1.0,-6.0),(12.0,12.0,-7.0),(0.0,1.0,-2.0),(-2.0,7.0,-3.0),(-2.0,3.0,0.0),(0.0,0.0,1.0),(0.0,-1.0,4.0),(1.0,-6.0,3.0),(-15.0,-10.0,6.0),(-5.0,-3.0,3.0),(0.0,-2.0,-2.0),(8.0,1.0,-4.0),(-4.0,7.0,-4.0),(-2.0,4.0,0.0),(-1.0,1.0,0.0),(0.0,0.0,2.0),(-5.0,-3.0,5.0),(-1.0,-3.0,-3.0),(0.0,4.0,0.0),(0.0,1.0,2.0),(-5.0,165.0,30.0),(43.0,-38.0,-51.0),(-3.0,-12.0,-14.0),(-4.0,-17.0,-6.0),(-11.0,-15.0,0.0),(-18.0,-16.0,10.0),(-10.0,0.0,10.0),(2.0,-23.0,7.0),(11.0,1.0,-10.0),(20.0,16.0,-11.0),(12.0,12.0,-1.0),(9.0,16.0,7.0),(4.0,11.0,17.0),(-38.0,37.0,64.0),(-9.0,19.0,45.0),(-28.0,30.0,-27.0),(-27.0,25.0,-22.0),(25.0,-20.0,-34.0),(50.0,-37.0,-43.0),(2.0,-14.0,-12.0),(-4.0,-17.0,-3.0),(-8.0,-15.0,1.0),(-16.0,-19.0,9.0),(-6.0,0.0,7.0),(-1.0,2.0,-1.0),(-1.0,-2.0,-1.0),(1.0,-4.0,1.0),(3.0,-23.0,5.0),(1.0,-23.0,8.0),(3.0,-24.0,8.0),(4.0,-13.0,5.0),(3.0,-4.0,5.0),(-1.0,6.0,1.0),(-2.0,4.0,-4.0),(-4.0,14.0,-7.0),(5.0,0.0,-5.0),(19.0,16.0,-14.0),(14.0,11.0,-3.0),(13.0,14.0,5.0),(8.0,11.0,18.0),(7.0,12.0,32.0),(-44.0,40.0,93.0),(-12.0,19.0,30.0),(-25.0,31.0,-25.0),(-33.0,30.0,-28.0),(-27.0,27.0,-17.0),(-1.0,4.0,-2.0),(25.0,-22.0,-31.0),(69.0,-42.0,-59.0),(9.0,-15.0,-17.0),(0.0,-13.0,-11.0),(-3.0,-18.0,-3.0),(-9.0,-15.0,1.0),(-14.0,-21.0,5.0),(1.0,-3.0,-1.0),(0.0,-4.0,1.0),(4.0,-21.0,5.0),(1.0,-26.0,10.0),(-1.0,-18.0,7.0),(0.0,-2.0,3.0),(0.0,-3.0,0.0),(3.0,-12.0,5.0),(2.0,-3.0,6.0),(-1.0,4.0,2.0),(-4.0,5.0,-4.0),(15.0,17.0,-12.0),(12.0,10.0,-3.0),(12.0,12.0,2.0),(9.0,11.0,15.0),(11.0,11.0,35.0),(-40.0,38.0,98.0),(-10.0,17.0,35.0),(-23.0,28.0,17.0),(-11.0,20.0,-18.0),(-27.0,34.0,-28.0),(-27.0,32.0,-19.0),(-17.0,26.0,-9.0),(-1.0,5.0,-3.0),(0.0,11.0,8.0),(3.0,0.0,-1.0),(1.0,-10.0,-8.0),(14.0,-31.0,-28.0),(26.0,-22.0,-32.0),(70.0,-43.0,-58.0),(6.0,-15.0,-18.0),(0.0,-12.0,-13.0),(-2.0,-21.0,-4.0),(-9.0,-17.0,2.0),(1.0,-5.0,1.0),(8.0,-24.0,2.0),(1.0,-27.0,6.0),(-2.0,-18.0,6.0),(0.0,-2.0,4.0),(0.0,-3.0,0.0),(-1.0,-10.0,7.0),(1.0,-3.0,4.0),(0.0,3.0,2.0),(13.0,11.0,-3.0),(10.0,12.0,3.0),(10.0,11.0,16.0),(12.0,11.0,35.0),(-41.0,39.0,98.0),(-11.0,17.0,36.0),(-23.0,28.0,21.0),(-9.0,12.0,-1.0),(-4.0,2.0,-6.0),(-11.0,20.0,-20.0),(-25.0,32.0,-27.0),(-27.0,35.0,-13.0),(-11.0,25.0,-9.0),(4.0,2.0,-1.0),(1.0,-11.0,-9.0),(16.0,-31.0,-28.0),(26.0,-21.0,-31.0),(68.0,-42.0,-59.0),(7.0,-16.0,-18.0),(0.0,-13.0,-14.0),(-2.0,-21.0,-2.0),(10.0,-25.0,3.0),(4.0,-29.0,5.0),(-1.0,-20.0,5.0),(-1.0,-2.0,1.0),(0.0,-2.0,0.0),(0.0,-12.0,6.0),(1.0,-2.0,6.0),(13.0,14.0,4.0),(12.0,11.0,18.0),(10.0,12.0,33.0),(-41.0,40.0,97.0),(-12.0,18.0,37.0),(-24.0,28.0,18.0),(-9.0,11.0,3.0),(-4.0,4.0,-7.0),(-11.0,17.0,-20.0),(-26.0,33.0,-26.0),(-25.0,33.0,-12.0),(7.0,-11.0,-8.0),(25.0,-32.0,-22.0),(27.0,-20.0,-28.0),(61.0,-44.0,-68.0),(1.0,-14.0,-22.0),(0.0,-14.0,-12.0),(9.0,-30.0,5.0),(0.0,-20.0,4.0),(0.0,-3.0,2.0),(1.0,-2.0,0.0),(0.0,-11.0,4.0),(11.0,12.0,17.0),(9.0,11.0,34.0),(-42.0,42.0,95.0),(-12.0,16.0,34.0),(-25.0,28.0,16.0),(-10.0,13.0,-11.0),(-3.0,4.0,-3.0),(-3.0,5.0,-3.0),(-19.0,24.0,-20.0),(32.0,-31.0,-16.0),(20.0,-19.0,-26.0),(48.0,-43.0,-81.0),(-1.0,-14.0,-29.0),(3.0,-20.0,5.0),(-2.0,-2.0,1.0),(3.0,-2.0,0.0),(7.0,12.0,33.0),(-43.0,41.0,93.0),(-13.0,18.0,29.0),(-3.0,2.0,-2.0),(-1.0,4.0,-6.0),(14.0,-18.0,-26.0),(44.0,-42.0,-90.0),(0.0,-3.0,0.0),(-44.0,41.0,92.0),(-38.0,-31.0,-147.0),(3.0,-5.0,0.0),(4.0,-6.0,2.0),(0.0,3.0,0.0),(-3.0,6.0,0.0),(-4.0,6.0,0.0),(2.0,1.0,-11.0),(2.0,-3.0,0.0),(3.0,-6.0,2.0),(4.0,-6.0,0.0),(1.0,0.0,6.0),(0.0,1.0,0.0),(-2.0,3.0,-5.0),(-4.0,7.0,-1.0),(7.0,20.0,-7.0),(-4.0,4.0,-2.0),(2.0,-2.0,-1.0),(4.0,-5.0,0.0),(4.0,-9.0,2.0),(0.0,-1.0,4.0),(0.0,1.0,1.0),(0.0,5.0,-2.0),(-114.0,169.0,150.0),(0.0,-5.0,2.0),(1.0,1.0,-1.0),(-1.0,6.0,-2.0),(-4.0,6.0,-3.0),(-4.0,2.0,-2.0),(0.0,-1.0,0.0),(3.0,-3.0,3.0),(5.0,-8.0,2.0),(2.0,-10.0,-9.0),(17.0,-28.0,-27.0),(23.0,-15.0,-29.0),(71.0,-43.0,-59.0),(6.0,-16.0,-18.0),(2.0,-17.0,-8.0),(-2.0,-20.0,-3.0),(-8.0,7.0,-1.0),(-5.0,5.0,0.0),(3.0,-1.0,-2.0),(6.0,-6.0,3.0),(8.0,-7.0,1.0),(1.0,-5.0,1.0),(-3.0,0.0,2.0),(1.0,21.0,3.0),(-1.0,17.0,8.0),(-6.0,16.0,18.0),(-68.0,42.0,60.0),(-26.0,17.0,29.0),(-18.0,28.0,27.0),(-3.0,11.0,6.0),(2.0,1.0,-1.0),(-1.0,6.0,-2.0),(-4.0,6.0,-3.0),(-4.0,3.0,-2.0),(-2.0,-2.0,1.0),(4.0,-5.0,1.0),(1.0,-9.0,-9.0),(14.0,-27.0,-28.0),(19.0,-15.0,-32.0),(71.0,-41.0,-55.0),(8.0,-16.0,-17.0),(2.0,-17.0,-8.0),(-5.0,6.0,-1.0),(3.0,0.0,0.0),(7.0,-6.0,2.0),(10.0,-8.0,2.0),(1.0,-6.0,2.0),(0.0,17.0,11.0),(-6.0,16.0,16.0),(-71.0,43.0,58.0),(-25.0,17.0,32.0),(-20.0,28.0,24.0),(-1.0,6.0,-3.0),(-5.0,6.0,-3.0),(-5.0,2.0,-2.0),(-1.0,-2.0,0.0),(13.0,-25.0,-30.0),(18.0,-14.0,-32.0),(68.0,-39.0,-53.0),(10.0,-17.0,-17.0),(3.0,0.0,-1.0),(7.0,-6.0,2.0),(11.0,-7.0,4.0),(-7.0,16.0,18.0),(-71.0,42.0,57.0),(-23.0,16.0,31.0),(-9.0,7.0,-6.0),(-5.0,4.0,-3.0),(19.0,-14.0,-32.0),(68.0,-39.0,-54.0),(8.0,-7.0,2.0),(-70.0,40.0,56.0),(95.0,-271.0,252.0),(-1.0,-9.0,2.0),(1.0,0.0,0.0),(2.0,10.0,-2.0),(1.0,11.0,-4.0),(-2.0,7.0,-2.0),(0.0,0.0,0.0),(1.0,-7.0,2.0),(-10.0,20.0,-281.0),(-2.0,-6.0,4.0),(-1.0,-7.0,2.0),(3.0,0.0,4.0),(1.0,6.0,-4.0),(1.0,6.0,-4.0),(3.0,-1.0,-4.0),(-1.0,0.0,-1.0),(-1.0,-4.0,-5.0),(-1.0,-8.0,2.0),(0.0,-6.0,5.0),(1.0,0.0,4.0),(1.0,6.0,-5.0),(2.0,5.0,-1.0),(17.0,-18.0,6.0),(-2.0,8.0,0.0),(1.0,0.0,-4.0),(0.0,-7.0,-1.0),(-1.0,-8.0,5.0),(-2.0,-6.0,5.0),(0.0,0.0,2.0),(2.0,6.0,-2.0),(19.0,-7.0,8.0),(15.0,-13.0,20.0),(9.0,-3.0,33.0),(10.0,7.0,45.0),(-40.0,32.0,81.0),(-15.0,12.0,38.0),(-9.0,-6.0,39.0),(-1.0,-7.0,8.0),(-1.0,-11.0,3.0),(-2.0,-10.0,3.0),(3.0,0.0,0.0),(2.0,10.0,-2.0),(1.0,11.0,-5.0),(-2.0,7.0,-2.0),(-2.0,1.0,0.0),(1.0,8.0,-9.0),(10.0,5.0,-38.0),(16.0,-13.0,-39.0),(40.0,-34.0,-84.0),(-11.0,-4.0,-44.0),(-13.0,4.0,-31.0),(-14.0,11.0,-19.0),(4.0,0.0,-1.0),(0.0,-6.0,1.0),(-3.0,-9.0,5.0),(-4.0,-6.0,2.0),(0.0,0.0,3.0),(2.0,6.0,-3.0),(13.0,-14.0,21.0),(9.0,-4.0,34.0),(8.0,8.0,46.0),(-37.0,31.0,80.0),(-12.0,12.0,36.0),(-9.0,-6.0,38.0),(-1.0,-9.0,2.0),(3.0,-1.0,0.0),(2.0,10.0,-3.0),(0.0,10.0,-3.0),(0.0,7.0,-3.0),(10.0,5.0,-38.0),(16.0,-12.0,-38.0),(40.0,-34.0,-84.0),(-10.0,-4.0,-45.0),(-12.0,2.0,-30.0),(3.0,-7.0,3.0),(-6.0,-9.0,5.0),(-4.0,-7.0,3.0),(-2.0,0.0,3.0),(6.0,-2.0,33.0),(-19.0,20.0,74.0),(-8.0,17.0,50.0),(-11.0,11.0,35.0),(3.0,0.0,0.0),(2.0,9.0,-3.0),(3.0,9.0,-4.0),(15.0,-12.0,-37.0),(39.0,-33.0,-82.0),(-10.0,-7.0,-43.0),(-6.0,-10.0,5.0),(-5.0,-5.0,5.0),(-20.0,21.0,74.0),(-6.0,15.0,49.0),(3.0,7.0,-3.0),(36.0,-29.0,-79.0),(-42.0,68.0,146.0),(2.0,-9.0,3.0),(0.0,0.0,-1.0),(-3.0,10.0,-4.0),(-3.0,12.0,-4.0),(-2.0,4.0,0.0),(0.0,0.0,1.0),(2.0,-6.0,0.0),(-23.0,-16.0,-263.0),(1.0,-5.0,1.0),(1.0,-3.0,4.0),(2.0,0.0,3.0),(-2.0,5.0,-4.0),(-1.0,3.0,-3.0),(3.0,-1.0,-3.0),(1.0,-1.0,-3.0),(0.0,-5.0,-3.0),(3.0,-7.0,4.0),(2.0,-4.0,4.0),(1.0,0.0,3.0),(-3.0,6.0,-5.0),(0.0,4.0,-3.0),(23.0,-11.0,5.0),(-5.0,6.0,-1.0),(-1.0,1.0,-2.0),(3.0,-6.0,-2.0),(7.0,-11.0,6.0),(3.0,-6.0,7.0),(0.0,-1.0,3.0),(-3.0,8.0,-5.0),(17.0,1.0,4.0),(23.0,-7.0,21.0),(16.0,-2.0,23.0),(7.0,7.0,40.0),(-44.0,36.0,85.0),(-21.0,14.0,40.0),(-9.0,0.0,35.0),(0.0,-4.0,9.0),(3.0,-12.0,4.0),(2.0,-9.0,3.0),(0.0,1.0,-3.0),(-3.0,10.0,-3.0),(-2.0,12.0,-3.0),(-3.0,4.0,0.0),(0.0,0.0,0.0),(0.0,3.0,-9.0),(12.0,-1.0,-34.0),(21.0,-13.0,-43.0),(41.0,-35.0,-88.0),(-10.0,-6.0,-40.0),(-17.0,1.0,-22.0),(-22.0,8.0,-18.0),(2.0,0.0,-2.0),(7.0,-6.0,3.0),(2.0,-10.0,7.0),(2.0,-9.0,3.0),(-1.0,0.0,3.0),(-3.0,8.0,-6.0),(24.0,-11.0,22.0),(12.0,0.0,28.0),(6.0,9.0,39.0),(-44.0,36.0,82.0),(-19.0,15.0,36.0),(-8.0,-2.0,35.0),(2.0,-7.0,2.0),(0.0,1.0,-1.0),(-2.0,8.0,-3.0),(-2.0,10.0,-3.0),(-1.0,4.0,-1.0),(12.0,-1.0,-34.0),(22.0,-13.0,-44.0),(42.0,-36.0,-88.0),(-11.0,-4.0,-40.0),(-16.0,0.0,-21.0),(7.0,-6.0,6.0),(3.0,-13.0,5.0),(1.0,-8.0,5.0),(-2.0,-1.0,3.0),(12.0,-1.0,28.0),(4.0,9.0,40.0),(-44.0,37.0,79.0),(-17.0,15.0,33.0),(1.0,0.0,0.0),(-1.0,9.0,-3.0),(0.0,8.0,-3.0),(22.0,-15.0,-40.0),(45.0,-37.0,-85.0),(-8.0,-5.0,-39.0),(0.0,-12.0,10.0),(1.0,-9.0,7.0),(4.0,9.0,40.0),(-44.0,37.0,77.0),(0.0,7.0,-4.0),(45.0,-36.0,-79.0),(-83.0,79.0,132.0),(-1.0,1.0,0.0),(-1.0,0.0,0.0),(0.0,-1.0,1.0),(2.0,-4.0,2.0),(1.0,-1.0,1.0),(1.0,0.0,0.0),(1.0,0.0,-2.0),(2.0,0.0,-10.0),(-1.0,4.0,-1.0),(-1.0,1.0,0.0),(-2.0,0.0,0.0),(0.0,-1.0,1.0),(2.0,-3.0,2.0),(1.0,-2.0,0.0),(2.0,0.0,-1.0),(16.0,-5.0,-36.0),(0.0,1.0,0.0),(-2.0,4.0,-2.0),(-1.0,1.0,0.0),(-2.0,0.0,0.0),(0.0,-1.0,1.0),(1.0,-4.0,2.0),(2.0,-1.0,0.0),(17.0,-9.0,-33.0),(2.0,0.0,0.0),(0.0,0.0,-1.0),(-2.0,5.0,-1.0),(-2.0,1.0,0.0),(-3.0,0.0,0.0),(0.0,-1.0,1.0),(3.0,-4.0,1.0),(38.0,-34.0,-84.0),(3.0,-3.0,1.0),(3.0,0.0,-2.0),(0.0,2.0,-1.0),(-4.0,8.0,-2.0),(-4.0,1.0,0.0),(-3.0,0.0,0.0),(-1.0,-2.0,0.0),(-13.0,-6.0,-38.0),(5.0,-6.0,3.0),(4.0,-1.0,0.0),(2.0,0.0,0.0),(0.0,2.0,0.0),(-5.0,6.0,-5.0),(-3.0,1.0,0.0),(-4.0,0.0,0.0),(-14.0,-2.0,-19.0),(0.0,-2.0,2.0),(4.0,-5.0,1.0),(3.0,-2.0,0.0),(3.0,0.0,0.0),(0.0,3.0,0.0),(-5.0,6.0,-3.0),(-3.0,2.0,0.0),(-19.0,5.0,-13.0),(-20.0,6.0,-7.0),(-22.0,6.0,0.0),(-9.0,2.0,2.0),(2.0,-2.0,3.0),(9.0,-3.0,-3.0),(22.0,-7.0,3.0),(18.0,-5.0,7.0),(0.0,-1.0,1.0),(4.0,-6.0,1.0),(2.0,-1.0,-2.0),(2.0,0.0,-2.0),(-1.0,3.0,-2.0),(-5.0,6.0,-2.0),(-21.0,6.0,-6.0),(-22.0,6.0,-1.0),(-10.0,2.0,3.0),(3.0,-4.0,4.0),(7.0,-1.0,-1.0),(23.0,-8.0,1.0),(4.0,-5.0,1.0),(0.0,0.0,-1.0),(0.0,0.0,-1.0),(-1.0,2.0,-3.0),(-23.0,5.0,-1.0),(-10.0,2.0,4.0),(2.0,-3.0,5.0),(9.0,-2.0,-3.0),(0.0,-1.0,0.0),(-1.0,2.0,-2.0),(-9.0,2.0,2.0),(0.0,0.0,2.0),(-788.0,113.0,-44.0),(1.0,0.0,2.0),(2.0,1.0,1.0),(2.0,7.0,0.0),(0.0,3.0,-1.0),(-1.0,0.0,-2.0),(-2.0,-1.0,-1.0),(-3.0,-7.0,-1.0),(-2.0,-10.0,-12.0),(0.0,-3.0,1.0),(2.0,0.0,3.0),(1.0,1.0,0.0),(2.0,6.0,0.0),(0.0,2.0,0.0),(-1.0,1.0,-2.0),(-2.0,-1.0,-2.0),(0.0,-23.0,-41.0),(-2.0,-8.0,0.0),(0.0,-3.0,1.0),(1.0,-1.0,3.0),(2.0,3.0,1.0),(2.0,7.0,1.0),(0.0,3.0,-2.0),(0.0,1.0,-2.0),(9.0,-24.0,-43.0),(-1.0,-1.0,0.0),(-2.0,-7.0,0.0),(0.0,-3.0,2.0),(1.0,0.0,3.0),(2.0,1.0,0.0),(2.0,7.0,0.0),(1.0,2.0,-2.0),(53.0,-3.0,-18.0),(-2.0,0.0,0.0),(-2.0,-2.0,0.0),(-2.0,-7.0,1.0),(0.0,-2.0,3.0),(3.0,0.0,1.0),(2.0,1.0,0.0),(3.0,6.0,-3.0),(27.0,-15.0,-17.0),(-1.0,2.0,-2.0),(-3.0,0.0,0.0),(-2.0,-2.0,0.0),(-1.0,-8.0,0.0),(1.0,-2.0,0.0),(3.0,0.0,3.0),(2.0,1.0,0.0),(18.0,-9.0,-7.0),(2.0,6.0,-2.0),(-1.0,0.0,-2.0),(-3.0,0.0,-1.0),(-2.0,-2.0,0.0),(0.0,-6.0,1.0),(0.0,-1.0,2.0),(2.0,0.0,3.0),(11.0,-13.0,1.0),(2.0,3.0,0.0),(2.0,6.0,-3.0),(0.0,0.0,-2.0),(-2.0,-1.0,-1.0),(-3.0,-4.0,0.0),(-2.0,-7.0,2.0),(1.0,0.0,1.0),(9.0,-15.0,5.0),(11.0,-11.0,9.0),(4.0,-1.0,6.0),(0.0,3.0,0.0),(-4.0,2.0,-5.0),(-9.0,11.0,-8.0),(2.0,4.0,0.0),(4.0,8.0,0.0),(0.0,0.0,-3.0),(-2.0,-3.0,-1.0),(-2.0,-4.0,0.0),(-4.0,-8.0,1.0),(12.0,-10.0,9.0),(5.0,-2.0,7.0),(0.0,7.0,1.0),(-3.0,1.0,-5.0),(5.0,8.0,-1.0),(1.0,1.0,0.0),(0.0,-2.0,-2.0),(-1.0,-5.0,0.0),(5.0,0.0,6.0),(1.0,6.0,2.0),(1.0,0.0,-1.0),(-1.0,-2.0,0.0),(-30.0,161.0,0.0),(7.0,-20.0,-18.0),(6.0,-16.0,-10.0),(7.0,-19.0,-3.0),(8.0,-17.0,3.0),(13.0,-17.0,12.0),(5.0,1.0,10.0),(5.0,24.0,-2.0),(-4.0,-1.0,-8.0),(-9.0,21.0,-12.0),(-7.0,17.0,-1.0),(-2.0,21.0,3.0),(-3.0,15.0,11.0),(0.0,19.0,15.0),(-24.0,11.0,-1.0),(-5.0,-11.0,35.0),(-61.0,-49.0,-30.0),(41.0,-9.0,-5.0),(14.0,-20.0,-19.0),(11.0,-15.0,-11.0),(8.0,-20.0,-2.0),(13.0,-13.0,6.0),(14.0,-14.0,15.0),(3.0,-1.0,10.0),(-6.0,-25.0,2.0),(-7.0,-12.0,1.0),(-4.0,-6.0,0.0),(3.0,-4.0,-1.0),(3.0,3.0,-2.0),(9.0,16.0,-1.0),(7.0,25.0,-2.0),(4.0,24.0,-3.0),(3.0,23.0,-1.0),(0.0,5.0,0.0),(0.0,3.0,0.0),(-5.0,-1.0,-8.0),(-10.0,21.0,-10.0),(-6.0,18.0,-2.0),(-2.0,22.0,3.0),(-2.0,15.0,11.0),(0.0,19.0,16.0),(-22.0,12.0,-3.0),(2.0,30.0,50.0),(-1.0,-5.0,-1.0),(-28.0,-29.0,-2.0),(-38.0,-35.0,2.0),(-29.0,-32.0,4.0),(4.0,-25.0,-39.0),(46.0,-9.0,-11.0),(20.0,-19.0,-21.0),(17.0,-14.0,-9.0),(11.0,-18.0,0.0),(11.0,-13.0,8.0),(11.0,-14.0,16.0),(-5.0,-15.0,3.0),(-4.0,-3.0,0.0),(0.0,-6.0,-3.0),(6.0,6.0,-2.0),(3.0,11.0,-1.0),(0.0,3.0,0.0),(4.0,4.0,-3.0),(3.0,19.0,-4.0),(4.0,26.0,-4.0),(6.0,23.0,0.0),(0.0,5.0,0.0),(-12.0,22.0,-11.0),(-7.0,19.0,-2.0),(-3.0,23.0,3.0),(0.0,17.0,12.0),(1.0,20.0,16.0),(-24.0,11.0,-3.0),(4.0,31.0,50.0),(0.0,35.0,41.0),(0.0,11.0,9.0),(2.0,-2.0,2.0),(0.0,-12.0,-9.0),(0.0,-5.0,1.0),(-20.0,-27.0,-4.0),(-33.0,-35.0,-2.0),(-33.0,-34.0,5.0),(-19.0,-20.0,9.0),(-6.0,-34.0,-37.0),(5.0,-27.0,-40.0),(54.0,-7.0,-17.0),(24.0,-19.0,-20.0),(18.0,-12.0,-7.0),(13.0,-14.0,2.0),(8.0,-11.0,5.0),(-5.0,-4.0,0.0),(-2.0,-5.0,-3.0),(6.0,4.0,-2.0),(1.0,12.0,-3.0),(0.0,3.0,0.0),(2.0,2.0,-3.0),(0.0,19.0,-4.0),(6.0,29.0,-1.0),(7.0,27.0,3.0),(-7.0,19.0,-3.0),(-4.0,24.0,2.0),(-1.0,17.0,13.0),(-1.0,19.0,15.0),(-22.0,12.0,-3.0),(4.0,31.0,50.0),(2.0,35.0,42.0),(0.0,11.0,10.0),(2.0,-3.0,2.0),(-17.0,-28.0,-2.0),(-26.0,-34.0,-7.0),(-33.0,-34.0,6.0),(-20.0,-18.0,10.0),(-7.0,-2.0,4.0),(-7.0,-12.0,-8.0),(-7.0,-37.0,-39.0),(6.0,-28.0,-41.0),(54.0,-7.0,-20.0),(25.0,-18.0,-19.0),(19.0,-13.0,-6.0),(10.0,-14.0,0.0),(-4.0,-2.0,-3.0),(5.0,4.0,-3.0),(0.0,12.0,-4.0),(1.0,2.0,0.0),(0.0,4.0,-1.0),(0.0,19.0,-2.0),(9.0,33.0,1.0),(-7.0,24.0,5.0),(-7.0,16.0,9.0),(-6.0,20.0,16.0),(-26.0,11.0,-1.0),(6.0,30.0,47.0),(12.0,36.0,42.0),(0.0,11.0,11.0),(-26.0,-34.0,-7.0),(-33.0,-34.0,6.0),(-19.0,-17.0,9.0),(-7.0,-4.0,3.0),(-8.0,-13.0,-9.0),(-6.0,-35.0,-39.0),(5.0,-28.0,-41.0),(51.0,-8.0,-16.0),(26.0,-18.0,-19.0),(19.0,-13.0,-9.0),(2.0,7.0,-3.0),(0.0,12.0,-1.0),(1.0,2.0,0.0),(0.0,3.0,-1.0),(3.0,22.0,0.0),(-12.0,16.0,10.0),(-15.0,19.0,21.0),(-38.0,11.0,3.0),(4.0,26.0,40.0),(15.0,36.0,40.0),(-25.0,-25.0,3.0),(-3.0,-5.0,1.0),(-5.0,-3.0,1.0),(-14.0,-13.0,3.0),(-7.0,-34.0,-38.0),(6.0,-28.0,-41.0),(48.0,-7.0,-13.0),(22.0,-18.0,-18.0),(3.0,12.0,-2.0),(1.0,3.0,2.0),(0.0,4.0,0.0),(-19.0,19.0,19.0),(-43.0,10.0,8.0),(-4.0,23.0,38.0),(-1.0,-4.0,2.0),(-3.0,-2.0,1.0),(5.0,-25.0,-40.0),(44.0,-8.0,-9.0),(2.0,2.0,0.0),(-43.0,9.0,9.0),(140.0,-12.0,-16.0),(3.0,6.0,2.0),(0.0,3.0,0.0),(-4.0,-6.0,-1.0),(-5.0,-8.0,-2.0),(0.0,-2.0,0.0),(0.0,1.0,-4.0),(3.0,0.0,-2.0),(6.0,7.0,0.0),(3.0,7.0,1.0),(-2.0,1.0,1.0),(-5.0,-5.0,0.0),(-4.0,-7.0,-1.0),(-2.0,-1.0,1.0),(-3.0,17.0,-8.0),(-1.0,-2.0,-2.0),(4.0,3.0,-1.0),(5.0,9.0,0.0),(7.0,7.0,3.0),(0.0,2.0,0.0),(-6.0,-6.0,0.0),(-6.0,-5.0,-1.0),(-20.0,165.0,124.0),(6.0,6.0,0.0),(3.0,5.0,0.0),(-1.0,0.0,-1.0),(-4.0,-5.0,0.0),(-6.0,-6.0,0.0),(-1.0,-6.0,2.0),(1.0,0.0,0.0),(2.0,3.0,-2.0),(-1.0,-11.0,-10.0),(-3.0,-31.0,-42.0),(0.0,-24.0,-45.0),(20.0,-14.0,1.0),(0.0,-21.0,-17.0),(1.0,-20.0,-10.0),(0.0,-24.0,-3.0),(-3.0,-6.0,1.0),(-1.0,0.0,-3.0),(2.0,6.0,0.0),(7.0,7.0,3.0),(7.0,5.0,0.0),(1.0,1.0,2.0),(-5.0,-5.0,0.0),(2.0,25.0,3.0),(1.0,21.0,9.0),(1.0,20.0,16.0),(-23.0,15.0,0.0),(0.0,22.0,46.0),(0.0,30.0,40.0),(0.0,12.0,10.0),(3.0,4.0,-1.0),(-1.0,1.0,-1.0),(-4.0,-5.0,0.0),(-6.0,-6.0,0.0),(-1.0,-6.0,2.0),(1.0,-1.0,0.0),(0.0,-12.0,-9.0),(-8.0,-32.0,-43.0),(-1.0,-24.0,-47.0),(21.0,-15.0,-1.0),(0.0,-21.0,-16.0),(4.0,-18.0,-7.0),(-2.0,1.0,-2.0),(2.0,7.0,0.0),(10.0,8.0,2.0),(7.0,5.0,1.0),(3.0,0.0,1.0),(1.0,20.0,10.0),(2.0,22.0,19.0),(-24.0,14.0,-3.0),(-2.0,22.0,45.0),(-1.0,29.0,40.0),(-1.0,0.0,-2.0),(-5.0,-4.0,0.0),(-7.0,-6.0,0.0),(-2.0,-6.0,1.0),(-7.0,-32.0,-43.0),(-2.0,-26.0,-48.0),(23.0,-13.0,2.0),(0.0,-20.0,-16.0),(4.0,8.0,0.0),(12.0,8.0,2.0),(7.0,6.0,0.0),(3.0,22.0,19.0),(-24.0,13.0,-2.0),(-1.0,21.0,44.0),(-7.0,-5.0,0.0),(-10.0,-7.0,-2.0),(-1.0,-24.0,-46.0),(23.0,-13.0,2.0),(12.0,8.0,1.0),(-23.0,14.0,-1.0),(-205.0,-251.0,157.0),(0.0,-11.0,3.0),(0.0,-9.0,3.0),(1.0,0.0,0.0),(0.0,10.0,-3.0),(0.0,11.0,-4.0),(2.0,7.0,0.0),(-1.0,0.0,-1.0),(0.0,0.0,-1.0),(-2.0,-8.0,1.0),(0.0,-11.0,4.0),(0.0,-8.0,3.0),(2.0,1.0,0.0),(0.0,10.0,-3.0),(0.0,11.0,-3.0),(3.0,7.0,-1.0),(4.0,6.0,-9.0),(-2.0,-1.0,0.0),(-2.0,-7.0,1.0),(0.0,-12.0,2.0),(0.0,-8.0,4.0),(2.0,2.0,0.0),(0.0,9.0,-2.0),(0.0,11.0,-4.0),(184.0,8.0,-150.0),(0.0,-7.0,2.0),(0.0,-5.0,2.0),(3.0,0.0,-3.0),(0.0,6.0,-2.0),(0.0,7.0,-2.0),(-3.0,-8.0,-4.0),(-20.0,-23.0,-3.0),(-20.0,-14.0,0.0),(-25.0,-12.0,7.0),(-27.0,-3.0,17.0),(-47.0,-7.0,-2.0),(-23.0,30.0,52.0),(-9.0,25.0,44.0),(1.0,7.0,-1.0),(-2.0,-2.0,0.0),(-1.0,-8.0,1.0),(1.0,-10.0,4.0),(1.0,-7.0,4.0),(1.0,1.0,1.0),(0.0,8.0,-4.0),(10.0,-26.0,-42.0),(24.0,-29.0,-52.0),(39.0,-9.0,-31.0),(35.0,20.0,12.0),(24.0,15.0,-7.0),(18.0,14.0,0.0),(21.0,22.0,3.0),(0.0,-5.0,2.0),(3.0,1.0,-3.0),(0.0,5.0,-2.0),(-1.0,7.0,-2.0),(-4.0,5.0,3.0),(0.0,0.0,0.0),(-18.0,-21.0,-3.0),(-18.0,-13.0,0.0),(-25.0,-13.0,5.0),(-26.0,0.0,16.0),(-38.0,6.0,29.0),(-34.0,14.0,19.0),(-2.0,-2.0,-1.0),(-1.0,-7.0,4.0),(1.0,-11.0,7.0),(1.0,-7.0,5.0),(2.0,1.0,0.0),(26.0,-29.0,-50.0),(37.0,-9.0,-33.0),(28.0,3.0,-21.0),(32.0,33.0,25.0),(17.0,14.0,-1.0),(1.0,0.0,-2.0),(0.0,7.0,-3.0),(3.0,10.0,-4.0),(-3.0,4.0,2.0),(-21.0,-14.0,1.0),(-27.0,-15.0,5.0),(-26.0,0.0,16.0),(-37.0,6.0,29.0),(-12.0,-23.0,-28.0),(2.0,-10.0,8.0),(3.0,-8.0,5.0),(36.0,-9.0,-33.0),(29.0,3.0,-24.0),(32.0,33.0,26.0),(-1.0,8.0,-2.0),(-3.0,7.0,-3.0),(-27.0,-13.0,6.0),(-34.0,-22.0,-16.0),(3.0,-9.0,8.0),(35.0,21.0,13.0),(65.0,62.0,0.0),(4.0,5.0,-1.0),(1.0,4.0,-1.0),(-3.0,0.0,3.0),(-3.0,-4.0,0.0),(-2.0,-5.0,0.0),(-2.0,-11.0,-6.0),(0.0,-1.0,-2.0),(6.0,5.0,-1.0),(3.0,8.0,-1.0),(0.0,6.0,4.0),(-3.0,0.0,1.0),(0.0,-6.0,-3.0),(-4.0,-6.0,0.0),(-27.0,-19.0,-6.0),(-5.0,-6.0,2.0),(3.0,1.0,-4.0),(6.0,8.0,0.0),(7.0,10.0,0.0),(1.0,5.0,2.0),(-1.0,-1.0,0.0),(-5.0,-6.0,-1.0),(-165.0,40.0,151.0),(2.0,5.0,0.0),(0.0,0.0,-1.0),(-3.0,-5.0,0.0),(-4.0,-12.0,2.0),(-3.0,-10.0,0.0),(0.0,0.0,0.0),(4.0,11.0,0.0),(5.0,12.0,-2.0),(5.0,2.0,-9.0),(8.0,-11.0,-39.0),(6.0,-27.0,-50.0),(34.0,-11.0,-18.0),(32.0,-7.0,-26.0),(25.0,-2.0,-8.0),(29.0,6.0,-2.0),(-6.0,-11.0,1.0),(-5.0,-7.0,2.0),(2.0,0.0,-4.0),(5.0,10.0,0.0),(6.0,12.0,-1.0),(5.0,6.0,1.0),(0.0,-3.0,2.0),(-28.0,-5.0,2.0),(-26.0,4.0,7.0),(-33.0,7.0,25.0),(-38.0,8.0,18.0),(-6.0,28.0,53.0),(-9.0,9.0,40.0),(-5.0,-3.0,6.0),(0.0,0.0,-1.0),(-2.0,-5.0,0.0),(-4.0,-12.0,0.0),(-3.0,-10.0,1.0),(0.0,0.0,1.0),(4.0,11.0,0.0),(5.0,2.0,-9.0),(11.0,-9.0,-38.0),(5.0,-29.0,-46.0),(30.0,-13.0,-17.0),(30.0,-9.0,-25.0),(26.0,0.0,-14.0),(-6.0,-9.0,3.0),(-1.0,0.0,-4.0),(6.0,11.0,-2.0),(6.0,14.0,0.0),(7.0,6.0,1.0),(-27.0,3.0,6.0),(-32.0,7.0,26.0),(-36.0,7.0,15.0),(-6.0,28.0,53.0),(-8.0,10.0,41.0),(-3.0,-5.0,0.0),(-3.0,-11.0,1.0),(-3.0,-11.0,1.0),(0.0,-1.0,0.0),(13.0,-7.0,-38.0),(16.0,-15.0,-15.0),(8.0,-43.0,-78.0),(29.0,-12.0,-30.0),(-2.0,0.0,-2.0),(13.0,30.0,33.0),(7.0,14.0,-7.0),(-30.0,9.0,27.0),(-34.0,8.0,15.0),(-6.0,27.0,53.0),(-1.0,-9.0,2.0),(-1.0,-9.0,1.0),(6.0,-27.0,-45.0),(17.0,-30.0,-48.0),(13.0,27.0,29.0),(-29.0,11.0,16.0),(2.0,64.0,75.0),(-1.0,0.0,-1.0),(-1.0,-2.0,0.0),(-2.0,-4.0,2.0),(0.0,0.0,1.0),(1.0,1.0,0.0),(1.0,2.0,0.0),(3.0,3.0,-1.0),(2.0,-1.0,-11.0),(0.0,0.0,-1.0),(-1.0,-1.0,-1.0),(-1.0,-1.0,0.0),(-2.0,-4.0,1.0),(0.0,0.0,1.0),(2.0,1.0,1.0),(1.0,1.0,0.0),(6.0,-17.0,-44.0),(1.0,4.0,-1.0),(0.0,0.0,-1.0),(-2.0,-1.0,-1.0),(-1.0,-2.0,0.0),(-1.0,-3.0,1.0),(0.0,0.0,1.0),(1.0,0.0,1.0),(6.0,-18.0,-41.0),(2.0,2.0,0.0),(2.0,4.0,-1.0),(0.0,0.0,-1.0),(-2.0,0.0,-2.0),(-2.0,-2.0,0.0),(-2.0,-5.0,1.0),(0.0,-1.0,0.0),(36.0,-6.0,-8.0),(3.0,0.0,2.0),(3.0,3.0,0.0),(4.0,7.0,0.0),(0.0,1.0,0.0),(-3.0,0.0,-2.0),(-3.0,-3.0,-1.0),(-4.0,-7.0,-1.0),(34.0,-6.0,-20.0),(0.0,-1.0,0.0),(4.0,0.0,2.0),(3.0,2.0,0.0),(5.0,7.0,0.0),(-1.0,1.0,0.0),(-3.0,-1.0,-2.0),(-3.0,-2.0,0.0),(26.0,-3.0,-8.0),(-5.0,-7.0,0.0),(1.0,-2.0,0.0),(1.0,0.0,3.0),(3.0,3.0,0.0),(5.0,7.0,1.0),(0.0,2.0,-1.0),(-2.0,0.0,-1.0),(21.0,2.0,-1.0),(-1.0,-2.0,-1.0),(-5.0,-6.0,0.0),(0.0,-2.0,1.0),(0.0,0.0,1.0),(3.0,2.0,2.0),(4.0,7.0,1.0),(2.0,3.0,0.0),(20.0,4.0,2.0),(21.0,8.0,8.0),(6.0,3.0,4.0),(0.0,0.0,0.0),(-6.0,-2.0,-6.0),(-22.0,-10.0,-9.0),(-2.0,-2.0,0.0),(-3.0,-7.0,0.0),(-2.0,-2.0,1.0),(-1.0,-1.0,2.0),(2.0,3.0,0.0),(6.0,8.0,1.0),(20.0,6.0,7.0),(7.0,4.0,5.0),(1.0,0.0,-2.0),(-6.0,-2.0,-6.0),(-4.0,-8.0,1.0),(-3.0,-4.0,1.0),(0.0,0.0,2.0),(1.0,2.0,0.0),(7.0,3.0,4.0),(3.0,1.0,-1.0),(-3.0,-3.0,1.0),(-2.0,-1.0,1.0),(455.0,395.0,229.0),(12.0,-6.0,9.0),(21.0,-104.0,-149.0),(59.0,-40.0,0.0),(-62.0,63.0,36.0),(-10.0,7.0,-1.0),(-13.0,13.0,-14.0),(-19.0,86.0,108.0),(-21.0,26.0,-21.0),(-56.0,62.0,-9.0),(-15.0,-4.0,-17.0),(-16.0,9.0,-15.0),(-50.0,12.0,-9.0),(0.0,29.0,39.0),(38.0,26.0,37.0),(13.0,-9.0,15.0),(13.0,-1.0,15.0),(47.0,-82.0,0.0),(31.0,-49.0,6.0),(12.0,-22.0,5.0),(13.0,-9.0,14.0),(22.0,-27.0,7.0),(9.0,-8.0,-26.0),(22.0,-78.0,-122.0),(32.0,-23.0,18.0),(43.0,-50.0,-70.0),(30.0,-28.0,-1.0),(-30.0,-19.0,-3.0),(-33.0,27.0,2.0),(-16.0,29.0,6.0),(-12.0,6.0,5.0),(-47.0,64.0,0.0),(34.0,-3.0,-1.0),(-66.0,49.0,-7.0),(-50.0,65.0,2.0),(-23.0,10.0,-2.0),(-19.0,0.0,-23.0),(-59.0,25.0,-3.0),(-55.0,-29.0,-34.0),(-1.0,90.0,105.0),(16.0,61.0,68.0),(15.0,41.0,59.0),(23.0,-1.0,-2.0),(21.0,11.0,18.0),(10.0,-10.0,7.0),(9.0,-10.0,15.0),(23.0,-74.0,1.0),(40.0,-75.0,-21.0),(18.0,-31.0,-2.0),(20.0,-23.0,15.0),(32.0,-25.0,12.0),(0.0,-61.0,-1.0),(48.0,-31.0,-5.0),(-1.0,49.0,7.0),(15.0,-36.0,3.0),(41.0,-49.0,-138.0),(8.0,-16.0,12.0),(14.0,-6.0,6.0),(23.0,-24.0,0.0),(49.0,-53.0,-91.0),(-19.0,29.0,1.0),(-15.0,4.0,-1.0),(-12.0,-17.0,-13.0),(-17.0,7.0,-7.0),(-3.0,-49.0,-1.0),(-4.0,-54.0,-5.0),(-9.0,56.0,6.0),(-33.0,29.0,1.0),(-15.0,29.0,7.0),(-13.0,2.0,2.0),(-16.0,2.0,-6.0),(3.0,57.0,11.0),(-60.0,57.0,-5.0),(-50.0,59.0,-16.0),(-21.0,22.0,10.0),(-14.0,-1.0,-21.0),(-62.0,11.0,-25.0),(-64.0,-18.0,-21.0),(-25.0,2.0,11.0),(-4.0,46.0,14.0),(10.0,79.0,98.0),(17.0,59.0,71.0),(19.0,39.0,51.0),(-9.0,-57.0,-12.0),(16.0,12.0,8.0),(23.0,-13.0,-12.0),(22.0,21.0,28.0),(12.0,-10.0,0.0),(9.0,-21.0,11.0),(36.0,-92.0,-13.0),(39.0,-60.0,2.0),(17.0,-13.0,4.0),(15.0,-16.0,15.0),(0.0,-87.0,-21.0),(29.0,-27.0,5.0),(53.0,-16.0,-4.0),(14.0,-38.0,-7.0),(-1.0,61.0,29.0),(16.0,-7.0,-6.0),(-7.0,44.0,15.0),(12.0,-9.0,-1.0),(18.0,-30.0,-5.0),(28.0,-40.0,-6.0),(48.0,-35.0,-94.0),(46.0,-63.0,-91.0),(-12.0,-28.0,-15.0),(-14.0,2.0,-12.0),(-20.0,38.0,1.0),(-12.0,43.0,2.0),(-2.0,-37.0,-2.0),(-17.0,0.0,3.0),(-4.0,-57.0,-2.0),(-6.0,-36.0,-10.0),(-15.0,9.0,-10.0),(-12.0,51.0,7.0),(-31.0,27.0,0.0),(-14.0,24.0,3.0),(-12.0,0.0,1.0),(-18.0,6.0,-7.0),(-21.0,39.0,8.0),(4.0,48.0,18.0),(-40.0,48.0,-2.0),(-16.0,14.0,0.0),(-20.0,2.0,-12.0),(-62.0,4.0,-17.0),(-67.0,-6.0,-14.0),(-21.0,-1.0,0.0),(-15.0,-13.0,-8.0),(-39.0,70.0,-35.0),(-14.0,61.0,25.0),(13.0,95.0,120.0),(16.0,52.0,69.0),(21.0,30.0,52.0),(-10.0,-68.0,-15.0),(-20.0,-136.0,-74.0),(18.0,8.0,-10.0),(16.0,1.0,1.0),(36.0,-22.0,-21.0),(29.0,20.0,35.0),(16.0,-4.0,5.0),(13.0,-10.0,19.0),(30.0,-49.0,24.0),(33.0,-41.0,23.0),(16.0,-9.0,1.0),(-2.0,-68.0,-36.0),(18.0,-8.0,15.0),(31.0,-17.0,6.0),(52.0,-11.0,5.0),(15.0,-33.0,-9.0),(50.0,-13.0,-21.0),(-35.0,49.0,47.0),(8.0,-3.0,10.0),(0.0,55.0,20.0),(16.0,-33.0,-8.0),(33.0,-36.0,-4.0),(45.0,-35.0,-95.0),(46.0,-65.0,-77.0),(-11.0,-42.0,-19.0),(-19.0,0.0,-11.0),(-22.0,49.0,-2.0),(-6.0,-48.0,1.0),(-11.0,45.0,-1.0),(-5.0,-39.0,-5.0),(-10.0,-25.0,-11.0),(-15.0,6.0,1.0),(-17.0,11.0,-7.0),(-11.0,36.0,0.0),(-30.0,28.0,-1.0),(-16.0,23.0,4.0),(-9.0,3.0,4.0),(-16.0,6.0,-6.0),(-21.0,26.0,2.0),(-37.0,22.0,-1.0),(1.0,52.0,12.0),(-16.0,4.0,0.0),(-19.0,2.0,-8.0),(-61.0,3.0,-16.0),(-62.0,-5.0,-14.0),(-19.0,-3.0,-1.0),(-15.0,-4.0,-7.0),(-40.0,-30.0,-16.0),(-9.0,49.0,14.0),(-41.0,54.0,-39.0),(-2.0,54.0,7.0),(-21.0,120.0,137.0),(27.0,38.0,72.0),(41.0,23.0,60.0),(-17.0,-74.0,-31.0),(-16.0,-110.0,-45.0),(7.0,-88.0,-34.0),(37.0,30.0,-14.0),(20.0,4.0,-18.0),(17.0,-2.0,1.0),(37.0,-19.0,-3.0),(24.0,22.0,25.0),(15.0,1.0,8.0),(10.0,-6.0,25.0),(28.0,-31.0,35.0),(34.0,-33.0,7.0),(2.0,-59.0,-32.0),(18.0,0.0,3.0),(16.0,-8.0,12.0),(29.0,-12.0,7.0),(53.0,-2.0,5.0),(16.0,-22.0,-1.0),(49.0,-20.0,-30.0),(-40.0,-33.0,-24.0),(46.0,28.0,35.0),(-1.0,41.0,38.0),(16.0,-24.0,-12.0),(-33.0,46.0,47.0),(68.0,-47.0,-34.0),(38.0,-49.0,-75.0),(11.0,-41.0,-46.0),(-12.0,-37.0,-21.0),(-21.0,3.0,-8.0),(2.0,-17.0,-6.0),(-21.0,26.0,-3.0),(-11.0,-22.0,-6.0),(-19.0,-25.0,4.0),(-19.0,28.0,-4.0),(-6.0,14.0,3.0),(-15.0,12.0,-5.0),(-18.0,33.0,-4.0),(-26.0,25.0,0.0),(-18.0,18.0,1.0),(-6.0,12.0,3.0),(-13.0,5.0,-4.0),(-17.0,18.0,0.0),(-32.0,15.0,-6.0),(-15.0,11.0,2.0),(0.0,35.0,5.0),(-15.0,2.0,-9.0),(-60.0,0.0,-13.0),(-60.0,-3.0,-15.0),(-21.0,-3.0,0.0),(-15.0,-4.0,-10.0),(-35.0,-23.0,-15.0),(-21.0,-27.0,-10.0),(-4.0,32.0,4.0),(-7.0,44.0,14.0),(-5.0,62.0,13.0),(1.0,62.0,7.0),(-55.0,17.0,-28.0),(-22.0,108.0,135.0),(16.0,24.0,53.0),(38.0,10.0,39.0),(-22.0,-75.0,-18.0),(-4.0,-98.0,-27.0),(14.0,-84.0,-47.0),(-119.0,-139.0,-107.0),(10.0,4.0,-5.0),(55.0,-35.0,-4.0),(-45.0,46.0,17.0),(10.0,26.0,13.0),(46.0,6.0,28.0),(32.0,15.0,12.0),(20.0,9.0,0.0),(16.0,1.0,9.0),(33.0,21.0,15.0),(36.0,15.0,-7.0),(18.0,9.0,-8.0),(13.0,-6.0,7.0),(28.0,-6.0,4.0),(21.0,11.0,17.0),(16.0,7.0,4.0),(7.0,-9.0,19.0),(26.0,-14.0,27.0),(0.0,-66.0,-28.0),(31.0,-6.0,4.0),(15.0,0.0,-2.0),(13.0,-6.0,8.0),(59.0,-12.0,-10.0),(36.0,-3.0,6.0),(12.0,-12.0,4.0),(14.0,-14.0,8.0),(15.0,-15.0,4.0),(41.0,29.0,21.0),(25.0,3.0,21.0),(34.0,-54.0,-60.0),(15.0,-31.0,-40.0),(-8.0,-27.0,-21.0),(-9.0,-6.0,-11.0),(-12.0,-13.0,-7.0),(-28.0,-16.0,0.0),(-20.0,15.0,5.0),(-20.0,27.0,-3.0),(-3.0,16.0,1.0),(-15.0,11.0,-5.0),(-20.0,32.0,-4.0),(-25.0,25.0,0.0),(-18.0,18.0,2.0),(-4.0,13.0,3.0),(-15.0,4.0,-4.0),(-16.0,18.0,0.0),(-34.0,12.0,-8.0),(-14.0,14.0,0.0),(-17.0,-7.0,-7.0),(1.0,11.0,-7.0),(-54.0,-2.0,-14.0),(-57.0,-1.0,-12.0),(-20.0,-1.0,0.0),(-16.0,-12.0,-9.0),(-35.0,-18.0,-8.0),(-17.0,-20.0,-8.0),(-101.0,-135.0,-36.0),(-17.0,-30.0,-2.0),(24.0,49.0,8.0),(16.0,14.0,2.0),(20.0,36.0,3.0),(27.0,29.0,10.0),(17.0,20.0,9.0),(1.0,12.0,4.0),(-11.0,29.0,-4.0),(-7.0,33.0,4.0),(-10.0,47.0,15.0),(-3.0,62.0,11.0),(-28.0,45.0,-40.0),(-17.0,24.0,28.0),(-22.0,103.0,130.0),(10.0,17.0,46.0),(29.0,6.0,30.0),(-16.0,-59.0,-11.0),(0.0,-95.0,-29.0),(14.0,-78.0,-44.0),(-20.0,-7.0,2.0),(-30.0,-21.0,-16.0),(-46.0,-15.0,-29.0),(-4.0,-39.0,-22.0),(-14.0,-3.0,-6.0),(-12.0,-2.0,5.0),(-6.0,-29.0,-20.0),(-6.0,-100.0,-85.0),(13.0,-29.0,2.0),(16.0,-36.0,-14.0),(-20.0,77.0,48.0),(-18.0,50.0,29.0),(35.0,-6.0,-6.0),(53.0,-29.0,5.0),(14.0,17.0,4.0),(14.0,15.0,2.0),(14.0,14.0,2.0),(35.0,4.0,16.0),(26.0,7.0,12.0),(17.0,8.0,1.0),(11.0,1.0,13.0),(25.0,12.0,18.0),(77.0,7.0,10.0),(29.0,2.0,-6.0),(12.0,15.0,-55.0),(-53.0,-2.0,-12.0),(-20.0,7.0,-2.0),(-15.0,-16.0,-7.0),(-33.0,-15.0,-7.0),(-18.0,-20.0,-8.0),(-15.0,-4.0,-3.0),(-1.0,-14.0,-4.0),(-17.0,-21.0,-9.0),(-26.0,-28.0,-10.0),(-21.0,-35.0,-5.0),(-15.0,-13.0,-1.0),(-4.0,-19.0,-3.0),(-20.0,-31.0,-4.0),(-17.0,-18.0,-12.0),(-24.0,16.0,-10.0),(23.0,33.0,3.0),(14.0,39.0,2.0),(14.0,9.0,9.0),(16.0,11.0,0.0),(16.0,41.0,4.0),(30.0,32.0,11.0),(13.0,26.0,10.0),(-10.0,37.0,6.0),(-6.0,46.0,13.0),(0.0,57.0,8.0),(-27.0,40.0,-44.0),(-26.0,27.0,37.0),(-25.0,101.0,136.0),(9.0,13.0,49.0),(19.0,-8.0,25.0),(-12.0,-51.0,-7.0),(0.0,-90.0,-31.0),(-31.0,-31.0,-18.0),(-44.0,-23.0,-39.0),(-6.0,-44.0,-22.0),(-14.0,-6.0,-11.0),(-9.0,-3.0,3.0),(-6.0,-32.0,-21.0),(-24.0,-38.0,-27.0),(24.0,-48.0,-45.0),(-22.0,37.0,-49.0),(25.0,-33.0,12.0),(17.0,-49.0,-11.0),(11.0,-55.0,-2.0),(17.0,-25.0,-2.0),(5.0,11.0,0.0),(22.0,32.0,5.0),(13.0,45.0,7.0),(17.0,3.0,3.0),(16.0,10.0,-1.0),(12.0,55.0,11.0),(31.0,32.0,12.0),(-6.0,41.0,9.0),(-1.0,57.0,10.0),(1.0,55.0,8.0),(-60.0,24.0,-7.0),(-29.0,94.0,146.0),(4.0,7.0,32.0),(7.0,-7.0,23.0),(-7.0,-58.0,-6.0),(-45.0,-38.0,-42.0),(-13.0,-44.0,-21.0),(-10.0,-10.0,-17.0),(-10.0,-6.0,0.0),(-9.0,-37.0,-22.0),(-23.0,-40.0,-30.0),(0.0,42.0,19.0),(13.0,-58.0,-123.0),(31.0,-33.0,1.0),(18.0,-34.0,-10.0),(18.0,0.0,-5.0),(-1.0,-67.0,0.0),(12.0,-45.0,2.0),(16.0,46.0,6.0),(12.0,54.0,4.0),(17.0,2.0,8.0),(19.0,3.0,0.0),(10.0,63.0,10.0),(-2.0,58.0,8.0),(-1.0,53.0,8.0),(-59.0,30.0,6.0),(-32.0,72.0,168.0),(-21.0,-37.0,-8.0),(-7.0,-18.0,-17.0),(-13.0,-10.0,-10.0),(-11.0,-33.0,-20.0),(20.0,-60.0,-137.0),(39.0,-29.0,-7.0),(23.0,-41.0,-13.0),(4.0,-49.0,-2.0),(14.0,59.0,7.0),(11.0,0.0,10.0),(19.0,1.0,2.0),(2.0,56.0,3.0),(-20.0,29.0,5.0),(-52.0,26.0,11.0),(-12.0,-17.0,4.0),(-15.0,-5.0,-2.0),(45.0,-26.0,-15.0),(18.0,-22.0,-12.0),(15.0,6.0,7.0),(-15.0,23.0,10.0),(458.0,-130.0,-275.0),(0.0,0.0,2.0),(0.0,1.0,0.0),(34.0,-6.0,17.0),(0.0,-2.0,-1.0),(0.0,0.0,2.0),(33.0,-11.0,18.0),(1.0,1.0,0.0),(0.0,-2.0,-1.0),(83.0,-56.0,58.0),(0.0,1.0,1.0),(-1.0,-1.0,0.0),(-21.0,19.0,-19.0),(-30.0,21.0,-20.0),(0.0,0.0,1.0),(1.0,1.0,0.0),(29.0,-21.0,21.0),(-1.0,-1.0,0.0),(-133.0,58.0,-76.0),(0.0,1.0,0.0),(0.0,-1.0,-1.0),(37.0,-14.0,0.0),(0.0,0.0,1.0),(0.0,1.0,0.0),(36.0,-20.0,-1.0),(0.0,-1.0,-1.0),(0.0,-1.0,1.0),(35.0,-23.0,-1.0),(1.0,1.0,0.0),(0.0,-1.0,-2.0),(33.0,-28.0,-1.0),(24.0,-23.0,0.0),(0.0,0.0,2.0),(-1.0,-1.0,0.0),(-23.0,24.0,0.0),(0.0,2.0,0.0),(-134.0,81.0,-7.0),(0.0,2.0,-1.0),(1.0,-1.0,-1.0),(37.0,5.0,6.0),(0.0,0.0,2.0),(0.0,1.0,0.0),(37.0,0.0,5.0),(0.0,-1.0,-1.0),(0.0,-1.0,2.0),(37.0,-4.0,6.0),(1.0,1.0,0.0),(0.0,-1.0,-1.0),(37.0,-10.0,8.0),(27.0,-9.0,6.0),(-1.0,0.0,1.0),(0.0,-1.0,0.0),(-27.0,10.0,-6.0),(0.0,2.0,0.0),(-154.0,17.0,5.0),(0.0,2.0,0.0),(0.0,-1.0,-1.0),(37.0,-2.0,8.0),(0.0,0.0,2.0),(0.0,2.0,0.0),(36.0,0.0,12.0),(0.0,-1.0,-1.0),(0.0,-1.0,2.0),(91.0,12.0,56.0),(0.0,1.0,-1.0),(-1.0,0.0,1.0),(-24.0,-7.0,-19.0),(-32.0,-4.0,-21.0),(0.0,2.0,0.0),(1.0,0.0,-1.0),(32.0,4.0,21.0),(-1.0,1.0,1.0),(-134.0,0.0,-89.0),(0.0,-1.0,0.0),(0.0,0.0,2.0),(37.0,4.0,9.0),(0.0,2.0,-1.0),(0.0,-1.0,0.0),(35.0,7.0,13.0),(0.0,0.0,2.0),(0.0,2.0,0.0),(33.0,10.0,15.0),(1.0,-1.0,0.0),(0.0,0.0,2.0),(31.0,14.0,19.0),(23.0,13.0,16.0),(0.0,1.0,-1.0),(-1.0,0.0,0.0),(-22.0,-13.0,-17.0),(0.0,-2.0,-1.0),(-133.0,-49.0,-75.0),(0.0,2.0,0.0),(1.0,0.0,-1.0),(37.0,-2.0,4.0),(0.0,-1.0,1.0),(0.0,1.0,1.0),(39.0,-5.0,0.0),(0.0,0.0,-2.0),(0.0,-2.0,0.0),(38.0,-8.0,-2.0),(0.0,1.0,1.0),(0.0,0.0,-2.0),(37.0,-12.0,-6.0),(0.0,-1.0,1.0),(0.0,2.0,1.0),(-156.0,41.0,-9.0),(0.0,0.0,-2.0),(0.0,-2.0,1.0),(38.0,0.0,0.0),(0.0,2.0,0.0),(1.0,0.0,-3.0),(38.0,2.0,-2.0),(0.0,-1.0,1.0),(0.0,2.0,0.0),(38.0,7.0,-6.0),(37.0,10.0,-7.0),(-37.0,-11.0,6.0),(0.0,-1.0,0.0),(37.0,11.0,-8.0),(0.0,1.0,0.0),(-161.0,-8.0,36.0),(0.0,-1.0,0.0),(0.0,2.0,2.0),(36.0,15.0,0.0),(0.0,0.0,-2.0),(1.0,-1.0,0.0),(34.0,20.0,0.0),(0.0,1.0,1.0),(0.0,1.0,-3.0),(34.0,23.0,-1.0),(0.0,-1.0,1.0),(0.0,1.0,1.0),(32.0,29.0,-3.0),(23.0,24.0,-3.0),(0.0,-1.0,-2.0),(-1.0,1.0,0.0),(-23.0,-25.0,3.0),(0.0,-2.0,0.0),(-119.0,-79.0,-3.0),(0.0,1.0,-1.0),(0.0,-1.0,-1.0),(39.0,0.0,-8.0),(0.0,0.0,1.0),(0.0,2.0,-1.0),(38.0,0.0,-13.0),(0.0,-1.0,0.0),(1.0,0.0,1.0),(36.0,1.0,-18.0),(0.0,2.0,-1.0),(0.0,-2.0,0.0),(-121.0,-7.0,54.0),(0.0,0.0,-1.0),(0.0,-1.0,0.0),(36.0,1.0,10.0),(0.0,1.0,1.0),(1.0,1.0,-1.0),(36.0,5.0,10.0),(0.0,-1.0,0.0),(0.0,1.0,2.0),(95.0,40.0,28.0),(0.0,0.0,-2.0),(-1.0,1.0,0.0),(-25.0,-17.0,-7.0),(-34.0,-14.0,-10.0),(0.0,0.0,-1.0),(1.0,-1.0,0.0),(33.0,15.0,9.0),(0.0,1.0,0.0),(-137.0,-49.0,-53.0),(0.0,1.0,-1.0),(0.0,0.0,0.0),(36.0,4.0,10.0),(0.0,0.0,1.0),(0.0,2.0,0.0),(35.0,6.0,13.0),(0.0,-1.0,0.0),(0.0,0.0,2.0),(88.0,39.0,52.0),(0.0,1.0,-1.0),(-1.0,0.0,0.0),(-23.0,-15.0,-17.0),(-30.0,-14.0,-19.0),(0.0,1.0,-1.0),(0.0,0.0,0.0),(31.0,14.0,19.0),(-1.0,1.0,1.0),(-141.0,-12.0,-72.0),(0.0,-1.0,1.0),(0.0,2.0,1.0),(39.0,15.0,-18.0),(37.0,18.0,-19.0),(-37.0,-19.0,18.0),(1.0,-1.0,0.0),(36.0,19.0,-20.0),(0.0,1.0,0.0),(-70.0,-47.0,40.0),(0.0,-1.0,1.0),(0.0,2.0,0.0),(38.0,1.0,-16.0),(36.0,2.0,-18.0),(-36.0,-4.0,17.0),(0.0,-1.0,1.0),(37.0,4.0,-20.0),(-1.0,1.0,-1.0),(-70.0,9.0,-7.0),(0.0,0.0,1.0),(0.0,1.0,0.0),(39.0,0.0,-6.0),(37.0,2.0,-8.0),(-37.0,-4.0,7.0),(0.0,0.0,1.0),(37.0,2.0,-10.0),(0.0,2.0,0.0),(-96.0,10.0,26.0),(0.0,-1.0,1.0),(0.0,2.0,0.0),(38.0,18.0,-10.0),(36.0,22.0,-12.0),(-35.0,-23.0,10.0),(0.0,0.0,0.0),(36.0,22.0,-12.0),(-1.0,1.0,0.0),(-54.0,-475.0,42.0),(1.0,0.0,0.0),(0.0,0.0,-1.0),(14.0,-24.0,3.0),(0.0,0.0,2.0),(2.0,0.0,0.0),(15.0,-23.0,5.0),(-1.0,0.0,0.0),(0.0,-1.0,1.0),(52.0,-54.0,33.0),(1.0,0.0,0.0),(0.0,1.0,0.0),(-17.0,13.0,-12.0),(-18.0,20.0,-12.0),(1.0,0.0,0.0),(0.0,-1.0,-1.0),(18.0,-19.0,13.0),(0.0,1.0,0.0),(-64.0,94.0,-42.0),(0.0,0.0,-1.0),(-1.0,-1.0,0.0),(14.0,-24.0,-5.0),(1.0,0.0,0.0),(0.0,0.0,-2.0),(15.0,-23.0,-6.0),(0.0,0.0,1.0),(1.0,0.0,0.0),(19.0,-21.0,-8.0),(21.0,-18.0,-8.0),(-22.0,18.0,7.0),(0.0,-1.0,0.0),(22.0,-18.0,-8.0),(0.0,1.0,0.0),(-65.0,94.0,35.0),(-1.0,-1.0,0.0),(1.0,0.0,0.0),(23.0,-18.0,-1.0),(0.0,0.0,-1.0),(-1.0,-1.0,0.0),(26.0,-15.0,-1.0),(1.0,0.0,1.0),(0.0,0.0,-2.0),(28.0,-13.0,0.0),(0.0,0.0,0.0),(0.0,0.0,0.0),(31.0,-11.0,-1.0),(24.0,-6.0,0.0),(0.0,0.0,-1.0),(0.0,1.0,0.0),(-25.0,6.0,1.0),(-1.0,0.0,0.0),(-102.0,51.0,7.0),(0.0,0.0,-1.0),(-1.0,0.0,0.0),(13.0,-25.0,2.0),(1.0,0.0,1.0),(1.0,0.0,0.0),(15.0,-23.0,2.0),(-1.0,-1.0,0.0),(0.0,0.0,2.0),(59.0,-54.0,15.0),(0.0,0.0,-1.0),(0.0,1.0,0.0),(-19.0,13.0,-4.0),(-21.0,19.0,-6.0),(0.0,0.0,-1.0),(0.0,-1.0,0.0),(21.0,-18.0,6.0),(1.0,1.0,0.0),(-79.0,83.0,-17.0),(0.0,0.0,0.0),(0.0,0.0,-1.0),(15.0,-24.0,0.0),(0.0,0.0,1.0),(2.0,0.0,0.0),(16.0,-23.0,1.0),(0.0,0.0,0.0),(0.0,-1.0,1.0),(54.0,-58.0,23.0),(0.0,1.0,-1.0),(0.0,0.0,0.0),(-17.0,15.0,-8.0),(-19.0,21.0,-9.0),(1.0,0.0,0.0),(0.0,-1.0,-1.0),(19.0,-20.0,9.0),(0.0,1.0,1.0),(-309.0,457.0,0.0),(0.0,0.0,2.0),(0.0,-2.0,0.0),(-38.0,-8.0,3.0),(0.0,0.0,-1.0),(0.0,1.0,1.0),(-37.0,-16.0,5.0),(0.0,-2.0,0.0),(0.0,0.0,-1.0),(-94.0,-64.0,22.0),(0.0,0.0,1.0),(0.0,2.0,-1.0),(26.0,19.0,-9.0),(33.0,24.0,-7.0),(0.0,1.0,2.0),(0.0,-2.0,0.0),(-34.0,-23.0,7.0),(0.0,2.0,-1.0),(148.0,71.0,-19.0),(0.0,0.0,1.0),(0.0,-2.0,0.0),(-33.0,-17.0,-14.0),(0.0,1.0,-1.0),(-1.0,0.0,1.0),(-31.0,-23.0,-15.0),(0.0,-1.0,0.0),(0.0,0.0,-2.0),(-78.0,-84.0,-36.0),(0.0,0.0,2.0),(0.0,2.0,0.0),(22.0,25.0,8.0),(27.0,31.0,13.0),(-1.0,0.0,1.0),(0.0,-2.0,0.0),(-28.0,-30.0,-12.0),(0.0,2.0,0.0),(119.0,94.0,42.0),(0.0,-1.0,0.0),(0.0,1.0,-2.0),(-37.0,2.0,-8.0),(0.0,1.0,1.0),(0.0,-3.0,0.0),(-36.0,-2.0,-9.0),(0.0,1.0,-1.0),(-1.0,0.0,1.0),(-36.0,-8.0,-8.0),(0.0,-2.0,0.0),(0.0,0.0,-2.0),(-36.0,-13.0,-7.0),(-27.0,-12.0,-4.0),(0.0,0.0,2.0),(0.0,2.0,0.0),(27.0,12.0,5.0),(1.0,-1.0,0.0),(137.0,33.0,62.0),(0.0,0.0,1.0),(0.0,-2.0,-1.0),(-37.0,-3.0,-6.0),(0.0,1.0,0.0),(0.0,0.0,1.0),(-38.0,-3.0,-2.0),(0.0,-1.0,-1.0),(0.0,0.0,0.0),(-38.0,0.0,2.0),(0.0,0.0,2.0),(0.0,-2.0,0.0),(-39.0,1.0,6.0),(-29.0,2.0,8.0),(0.0,2.0,0.0),(0.0,-1.0,-2.0),(30.0,-2.0,-7.0),(0.0,1.0,0.0),(157.0,13.0,-30.0),(0.0,1.0,1.0),(0.0,-1.0,0.0),(-38.0,1.0,-4.0),(0.0,0.0,-2.0),(0.0,2.0,1.0),(-38.0,3.0,-1.0),(0.0,-1.0,0.0),(0.0,1.0,-1.0),(-38.0,7.0,2.0),(0.0,1.0,1.0),(0.0,-1.0,1.0),(-38.0,10.0,5.0),(-28.0,11.0,6.0),(0.0,1.0,-1.0),(0.0,-1.0,-1.0),(29.0,-10.0,-6.0),(0.0,0.0,1.0),(155.0,-36.0,-20.0),(0.0,0.0,1.0),(0.0,-2.0,-1.0),(-36.0,-4.0,-11.0),(0.0,2.0,0.0),(-1.0,-1.0,2.0),(-34.0,-9.0,-15.0),(0.0,0.0,-1.0),(0.0,1.0,-1.0),(-34.0,-12.0,-17.0),(-30.0,-14.0,-19.0),(31.0,13.0,21.0),(0.0,-1.0,-1.0),(-32.0,-14.0,-20.0),(0.0,1.0,2.0),(144.0,54.0,49.0),(0.0,1.0,0.0),(0.0,0.0,1.0),(-35.0,-4.0,-15.0),(0.0,-1.0,-2.0),(0.0,1.0,-1.0),(-34.0,-1.0,-17.0),(0.0,0.0,1.0),(0.0,-1.0,-1.0),(-33.0,4.0,-20.0),(0.0,2.0,0.0),(-1.0,0.0,1.0),(-31.0,7.0,-22.0),(0.0,-1.0,-1.0),(1.0,2.0,0.0),(134.0,4.0,96.0),(0.0,0.0,-1.0),(0.0,2.0,-1.0),(-35.0,12.0,-12.0),(0.0,-1.0,1.0),(0.0,-1.0,-2.0),(-33.0,17.0,-14.0),(0.0,2.0,0.0),(-1.0,0.0,1.0),(-84.0,68.0,-43.0),(0.0,0.0,-1.0),(0.0,-1.0,1.0),(22.0,-22.0,13.0),(31.0,-26.0,15.0),(0.0,0.0,-2.0),(0.0,2.0,0.0),(-31.0,25.0,-15.0),(0.0,-2.0,1.0),(119.0,-68.0,43.0),(0.0,-2.0,0.0),(0.0,0.0,-2.0),(-33.0,-2.0,-21.0),(0.0,1.0,1.0),(-1.0,-2.0,0.0),(-30.0,-3.0,-28.0),(-27.0,0.0,-30.0),(28.0,2.0,29.0),(-1.0,0.0,0.0),(-27.0,-1.0,-31.0),(1.0,-1.0,0.0),(91.0,2.0,98.0),(0.0,0.0,-2.0),(0.0,1.0,0.0),(-37.0,-2.0,-4.0),(0.0,-1.0,1.0),(0.0,0.0,-2.0),(-38.0,2.0,-4.0),(0.0,1.0,0.0),(0.0,0.0,1.0),(-102.0,31.0,-11.0),(0.0,1.0,-1.0),(0.0,-2.0,0.0),(28.0,-12.0,4.0),(37.0,-12.0,3.0),(0.0,0.0,-2.0),(0.0,2.0,0.0),(-36.0,11.0,-3.0),(0.0,-2.0,0.0),(151.0,-34.0,2.0),(0.0,1.0,2.0),(0.0,-1.0,0.0),(-38.0,1.0,-5.0),(0.0,0.0,-1.0),(0.0,2.0,1.0),(-38.0,4.0,-1.0),(0.0,-2.0,0.0),(0.0,1.0,-1.0),(-38.0,7.0,2.0),(0.0,1.0,2.0),(0.0,-1.0,0.0),(-38.0,11.0,6.0),(-28.0,11.0,5.0),(0.0,1.0,0.0),(0.0,-1.0,-2.0),(29.0,-10.0,-5.0),(0.0,1.0,0.0),(158.0,0.0,-11.0),(0.0,2.0,0.0),(-1.0,0.0,1.0),(-30.0,12.0,-32.0),(-27.0,15.0,-32.0),(28.0,-17.0,31.0),(0.0,2.0,-1.0),(-28.0,15.0,-32.0),(0.0,-2.0,1.0),(54.0,-40.0,65.0),(0.0,1.0,-1.0),(-1.0,0.0,1.0),(-29.0,-3.0,-29.0),(-27.0,0.0,-31.0),(28.0,-1.0,31.0),(0.0,1.0,-2.0),(-28.0,0.0,-31.0),(0.0,-1.0,1.0),(68.0,16.0,20.0),(0.0,2.0,-1.0),(-1.0,0.0,1.0),(-33.0,-4.0,-20.0),(-31.0,-1.0,-23.0),(32.0,-1.0,22.0),(0.0,1.0,-1.0),(-32.0,-1.0,-23.0),(0.0,0.0,1.0),(78.0,18.0,60.0),(0.0,2.0,0.0),(-1.0,0.0,1.0),(-33.0,15.0,-25.0),(-29.0,19.0,-24.0),(30.0,-21.0,23.0),(0.0,2.0,-1.0),(-31.0,19.0,-24.0),(0.0,-2.0,0.0),(74.0,-467.0,66.0),(0.0,0.0,1.0),(0.0,-1.0,0.0),(-12.0,-25.0,-2.0),(0.0,0.0,-1.0),(-2.0,0.0,1.0),(-14.0,-24.0,0.0),(0.0,0.0,0.0),(0.0,0.0,-1.0),(-18.0,-23.0,3.0),(0.0,0.0,0.0),(0.0,-1.0,1.0),(-20.0,-21.0,5.0),(-18.0,-15.0,4.0),(0.0,0.0,-1.0),(1.0,0.0,-1.0),(16.0,16.0,-4.0),(0.0,0.0,0.0),(69.0,100.0,-16.0),(-2.0,0.0,0.0),(0.0,0.0,1.0),(-7.0,-25.0,-11.0),(1.0,0.0,0.0),(-1.0,0.0,-1.0),(-10.0,-24.0,-12.0),(0.0,-1.0,1.0),(1.0,0.0,-1.0),(-13.0,-22.0,-14.0),(-1.0,0.0,0.0),(-1.0,0.0,1.0),(-14.0,-20.0,-16.0),(1.0,0.0,-1.0),(0.0,1.0,0.0),(38.0,98.0,57.0),(1.0,0.0,-1.0),(-2.0,0.0,-1.0),(-18.0,-21.0,-9.0),(0.0,-1.0,1.0),(0.0,0.0,-1.0),(-22.0,-17.0,-11.0),(-1.0,0.0,0.0),(0.0,0.0,1.0),(-72.0,-37.0,-34.0),(0.0,0.0,-1.0),(1.0,0.0,1.0),(21.0,9.0,11.0),(27.0,13.0,11.0),(0.0,0.0,-1.0),(-1.0,0.0,0.0),(-26.0,-13.0,-12.0),(1.0,0.0,1.0),(88.0,60.0,44.0),(-1.0,0.0,0.0),(0.0,-1.0,0.0),(-10.0,-26.0,-2.0),(0.0,0.0,-2.0),(-1.0,0.0,0.0),(-13.0,-24.0,-1.0),(0.0,-1.0,0.0),(0.0,0.0,-1.0),(-17.0,-22.0,-2.0),(-1.0,0.0,0.0),(0.0,-1.0,1.0),(-20.0,-21.0,-3.0),(-17.0,-15.0,-1.0),(0.0,0.0,-1.0),(1.0,0.0,0.0),(17.0,16.0,2.0),(-1.0,0.0,0.0),(72.0,90.0,12.0),(0.0,0.0,1.0),(0.0,-1.0,0.0),(-12.0,-24.0,-7.0),(0.0,0.0,0.0),(-1.0,0.0,0.0),(-14.0,-24.0,-4.0),(1.0,-1.0,0.0),(-1.0,0.0,-1.0),(-17.0,-23.0,-1.0),(0.0,0.0,1.0),(0.0,-1.0,1.0),(-19.0,-23.0,1.0),(-17.0,-16.0,1.0),(0.0,1.0,-1.0),(1.0,0.0,-1.0),(15.0,16.0,-1.0),(0.0,1.0,1.0),(185.0,431.0,259.0),(0.0,3.0,0.0),(0.0,1.0,2.0),(3.0,-1.0,2.0),(-1.0,-2.0,-2.0),(0.0,-4.0,0.0),(-2.0,-1.0,-2.0),(-4.0,0.0,-2.0),(0.0,3.0,0.0),(-1.0,2.0,0.0),(-3.0,2.0,2.0),(-4.0,3.0,5.0),(-4.0,3.0,11.0),(8.0,1.0,2.0),(5.0,-3.0,-9.0),(5.0,-1.0,2.0),(1.0,-6.0,1.0),(2.0,-2.0,-7.0),(6.0,-19.0,-15.0),(0.0,-5.0,0.0),(-4.0,0.0,-1.0),(0.0,5.0,-1.0),(0.0,7.0,7.0),(-4.0,6.0,8.0),(-2.0,3.0,2.0),(-1.0,0.0,-3.0),(-4.0,0.0,-2.0),(-3.0,1.0,-2.0),(-1.0,3.0,0.0),(-3.0,1.0,1.0),(-4.0,2.0,6.0),(-4.0,2.0,10.0),(1.0,2.0,2.0),(12.0,2.0,5.0),(3.0,0.0,0.0),(1.0,-6.0,2.0),(3.0,-9.0,2.0),(5.0,-2.0,-10.0),(2.0,-4.0,-11.0),(2.0,-5.0,-8.0),(1.0,-7.0,1.0),(-2.0,-4.0,0.0),(-5.0,0.0,-2.0),(-3.0,3.0,-2.0),(0.0,6.0,-1.0),(1.0,4.0,0.0),(-6.0,6.0,7.0),(-2.0,3.0,2.0),(-4.0,2.0,-1.0),(-4.0,1.0,5.0),(-4.0,2.0,11.0),(1.0,2.0,2.0),(12.0,2.0,5.0),(2.0,-9.0,3.0),(2.0,-12.0,3.0),(4.0,1.0,0.0),(5.0,-3.0,-10.0),(1.0,-3.0,-12.0),(-3.0,-6.0,0.0),(-6.0,-1.0,-3.0),(-5.0,4.0,-2.0),(-2.0,10.0,-2.0),(-8.0,3.0,8.0),(-4.0,2.0,10.0),(3.0,1.0,3.0),(2.0,-12.0,4.0),(2.0,-9.0,3.0),(1.0,-6.0,3.0),(12.0,3.0,3.0),(0.0,7.0,-2.0),(2.0,0.0,-1.0),(5.0,-3.0,-10.0),(1.0,-1.0,-7.0),(-3.0,1.0,-3.0),(0.0,-3.0,-3.0),(-5.0,0.0,-1.0),(-3.0,2.0,2.0),(-11.0,6.0,3.0),(-4.0,1.0,10.0),(4.0,-8.0,4.0),(1.0,-7.0,2.0),(5.0,-1.0,3.0),(8.0,2.0,3.0),(3.0,4.0,0.0),(5.0,-3.0,-11.0),(1.0,0.0,-7.0),(-1.0,0.0,-5.0),(0.0,3.0,-1.0),(-2.0,-2.0,-3.0),(-4.0,0.0,-1.0),(-4.0,0.0,1.0),(-4.0,1.0,2.0),(-3.0,0.0,6.0),(1.0,-7.0,3.0),(5.0,-2.0,3.0),(8.0,3.0,2.0),(1.0,0.0,-8.0),(0.0,1.0,-5.0),(0.0,2.0,-2.0),(-3.0,-1.0,-1.0),(-4.0,-2.0,1.0),(-3.0,-1.0,3.0),(4.0,-1.0,1.0),(3.0,2.0,-4.0),(1.0,69.0,-31.0),(-3.0,0.0,-2.0),(0.0,5.0,-1.0),(3.0,1.0,2.0),(-11.0,22.0,9.0),(0.0,-2.0,0.0),(0.0,-3.0,0.0),(-3.0,0.0,-2.0),(-1.0,3.0,0.0),(-1.0,2.0,0.0),(-3.0,2.0,0.0),(-4.0,3.0,5.0),(-6.0,2.0,10.0),(8.0,2.0,4.0),(6.0,-3.0,-10.0),(4.0,-3.0,-5.0),(2.0,-1.0,2.0),(0.0,-3.0,-2.0),(0.0,-3.0,1.0),(-2.0,-2.0,0.0),(0.0,-1.0,2.0),(-4.0,0.0,-6.0),(-3.0,1.0,-2.0),(0.0,4.0,0.0),(-4.0,1.0,0.0),(-5.0,2.0,5.0),(-5.0,2.0,10.0),(1.0,2.0,2.0),(11.0,2.0,6.0),(3.0,0.0,0.0),(6.0,-3.0,-9.0),(1.0,-6.0,1.0),(2.0,-2.0,-6.0),(0.0,-7.0,-4.0),(5.0,-6.0,-6.0),(2.0,-3.0,2.0),(0.0,-6.0,1.0),(-2.0,-4.0,0.0),(-4.0,-1.0,-2.0),(-2.0,3.0,-3.0),(0.0,7.0,-1.0),(1.0,4.0,0.0),(-7.0,5.0,7.0),(-3.0,4.0,1.0),(-3.0,2.0,-2.0),(-5.0,1.0,5.0),(-6.0,2.0,10.0),(1.0,2.0,2.0),(12.0,2.0,7.0),(2.0,0.0,0.0),(3.0,-9.0,3.0),(7.0,-3.0,-9.0),(3.0,-4.0,-10.0),(0.0,-10.0,2.0),(-3.0,-6.0,0.0),(-6.0,-1.0,-4.0),(-4.0,4.0,-3.0),(-1.0,10.0,-3.0),(-9.0,3.0,7.0),(-6.0,2.0,10.0),(3.0,2.0,3.0),(12.0,2.0,7.0),(1.0,-11.0,4.0),(4.0,0.0,0.0),(6.0,-3.0,-10.0),(0.0,-10.0,-8.0),(0.0,-3.0,-3.0),(-5.0,0.0,-1.0),(-3.0,2.0,2.0),(-11.0,7.0,0.0),(-5.0,2.0,10.0),(2.0,0.0,3.0),(1.0,-9.0,3.0),(1.0,-6.0,3.0),(11.0,4.0,6.0),(0.0,6.0,-3.0),(2.0,0.0,0.0),(7.0,-3.0,-10.0),(2.0,-2.0,-6.0),(0.0,-2.0,-4.0),(-2.0,-1.0,-4.0),(-3.0,0.0,-1.0),(-4.0,0.0,0.0),(-4.0,1.0,2.0),(-5.0,1.0,5.0),(-6.0,2.0,10.0),(1.0,-7.0,2.0),(4.0,-2.0,4.0),(8.0,3.0,4.0),(3.0,3.0,0.0),(7.0,-3.0,-9.0),(1.0,-1.0,-7.0),(0.0,0.0,-5.0),(-1.0,0.0,-4.0),(-4.0,-1.0,-1.0),(-3.0,-1.0,1.0),(-5.0,-1.0,2.0),(-4.0,0.0,6.0),(5.0,-2.0,3.0),(7.0,2.0,4.0),(4.0,0.0,-7.0),(0.0,1.0,-5.0),(-5.0,-2.0,-2.0),(-3.0,-1.0,3.0),(-1.0,95.0,-31.0),(0.0,2.0,0.0),(0.0,2.0,2.0),(3.0,-2.0,2.0),(-1.0,-2.0,-2.0),(0.0,-3.0,0.0),(-2.0,-1.0,-2.0),(-3.0,0.0,-2.0),(0.0,3.0,0.0),(-2.0,2.0,0.0),(-2.0,2.0,0.0),(-5.0,3.0,5.0),(-5.0,2.0,10.0),(7.0,2.0,4.0),(7.0,-3.0,-9.0),(4.0,-2.0,3.0),(0.0,-6.0,1.0),(3.0,-2.0,-6.0),(7.0,-19.0,-15.0),(0.0,-5.0,1.0),(-3.0,0.0,-2.0),(0.0,5.0,-1.0),(-1.0,7.0,7.0),(-4.0,6.0,7.0),(-3.0,3.0,2.0),(0.0,0.0,-3.0),(-4.0,0.0,-3.0),(-3.0,1.0,-2.0),(0.0,4.0,0.0),(-3.0,1.0,0.0),(-5.0,2.0,5.0),(-6.0,2.0,10.0),(1.0,2.0,2.0),(11.0,2.0,7.0),(3.0,0.0,0.0),(1.0,-6.0,2.0),(3.0,-9.0,3.0),(6.0,-3.0,-10.0),(3.0,-4.0,-10.0),(3.0,-5.0,-8.0),(0.0,-6.0,1.0),(-1.0,-4.0,0.0),(-5.0,-1.0,-3.0),(-2.0,3.0,-2.0),(0.0,7.0,-1.0),(1.0,4.0,0.0),(-7.0,5.0,7.0),(-2.0,4.0,1.0),(-4.0,2.0,-2.0),(-5.0,1.0,5.0),(-5.0,2.0,10.0),(0.0,1.0,2.0),(12.0,3.0,7.0),(1.0,-10.0,3.0),(1.0,-11.0,4.0),(5.0,0.0,0.0),(6.0,-3.0,-10.0),(2.0,-2.0,-11.0),(-2.0,-6.0,0.0),(-7.0,-1.0,-4.0),(-4.0,4.0,-3.0),(-1.0,10.0,-3.0),(-9.0,2.0,7.0),(-5.0,3.0,10.0),(2.0,1.0,3.0),(1.0,-13.0,4.0),(1.0,-9.0,3.0),(1.0,-6.0,3.0),(11.0,3.0,5.0),(0.0,7.0,-2.0),(3.0,0.0,0.0),(6.0,-3.0,-10.0),(2.0,-1.0,-6.0),(-2.0,1.0,-4.0),(0.0,-3.0,-3.0),(-4.0,0.0,-1.0),(-3.0,2.0,2.0),(-12.0,7.0,0.0),(-5.0,1.0,10.0),(3.0,-8.0,4.0),(0.0,-7.0,2.0),(4.0,-2.0,4.0),(8.0,2.0,4.0),(3.0,4.0,0.0),(7.0,-3.0,-9.0),(2.0,0.0,-7.0),(0.0,0.0,-5.0),(-1.0,3.0,-2.0),(-1.0,-1.0,-3.0),(-4.0,0.0,-1.0),(-3.0,0.0,0.0),(-5.0,1.0,2.0),(-4.0,0.0,5.0),(1.0,-7.0,3.0),(4.0,-2.0,3.0),(7.0,2.0,4.0),(4.0,0.0,-7.0),(0.0,2.0,-5.0),(0.0,1.0,-3.0),(-3.0,-1.0,-1.0),(-4.0,-1.0,0.0),(-3.0,-1.0,3.0),(3.0,-2.0,2.0),(3.0,2.0,-4.0),(18.0,59.0,-87.0),(-1.0,0.0,-1.0),(0.0,2.0,-2.0),(2.0,1.0,1.0),(0.0,3.0,4.0),(0.0,-3.0,3.0),(-2.0,-3.0,1.0),(-4.0,-1.0,-1.0),(-1.0,2.0,-3.0),(0.0,3.0,-4.0),(2.0,3.0,-1.0),(3.0,2.0,2.0),(-1.0,4.0,3.0),(2.0,-2.0,4.0),(0.0,-5.0,5.0),(-3.0,-4.0,2.0),(-5.0,-1.0,-2.0),(-2.0,2.0,-5.0),(0.0,4.0,-4.0),(2.0,5.0,-2.0),(-3.0,5.0,4.0),(6.0,1.0,2.0),(4.0,-3.0,5.0),(0.0,-6.0,6.0),(-4.0,-5.0,2.0),(-6.0,-1.0,-2.0),(-4.0,2.0,-5.0),(0.0,6.0,-5.0),(-4.0,4.0,4.0),(3.0,6.0,-1.0),(8.0,2.0,2.0),(5.0,-3.0,6.0),(0.0,-7.0,6.0),(-4.0,-7.0,2.0),(-7.0,-2.0,-2.0),(-6.0,4.0,-5.0),(-4.0,1.0,6.0),(-1.0,11.0,-7.0),(4.0,6.0,-1.0),(9.0,3.0,3.0),(6.0,-4.0,5.0),(1.0,-10.0,7.0),(-4.0,-8.0,1.0),(-9.0,-2.0,-1.0),(-3.0,0.0,5.0),(-7.0,5.0,-4.0),(-2.0,13.0,-5.0),(3.0,9.0,0.0),(10.0,3.0,3.0),(7.0,-5.0,4.0),(3.0,-13.0,5.0),(-4.0,-8.0,1.0),(-4.0,1.0,11.0),(-11.0,-3.0,-3.0),(-7.0,6.0,-4.0),(-3.0,14.0,-3.0),(3.0,10.0,0.0),(10.0,3.0,3.0),(8.0,-6.0,4.0),(3.0,-14.0,4.0),(-7.0,2.0,17.0),(-3.0,-9.0,0.0),(-10.0,-3.0,-3.0),(-8.0,6.0,-3.0),(-3.0,15.0,-4.0),(3.0,9.0,0.0),(10.0,3.0,3.0),(7.0,-5.0,4.0),(-1.0,-2.0,1.0),(3.0,-13.0,3.0),(-3.0,-8.0,0.0),(-9.0,-2.0,-2.0),(-6.0,4.0,-4.0),(-3.0,13.0,-2.0),(3.0,9.0,0.0),(9.0,2.0,1.0),(42.0,-152.0,-56.0),(0.0,0.0,-3.0),(0.0,-1.0,-2.0),(-4.0,-2.0,1.0),(1.0,1.0,3.0),(0.0,-1.0,3.0),(3.0,2.0,1.0),(4.0,1.0,1.0),(1.0,1.0,-3.0),(1.0,0.0,-2.0),(2.0,-1.0,-3.0),(4.0,-5.0,-5.0),(3.0,-10.0,-5.0),(-9.0,-2.0,-2.0),(-4.0,10.0,6.0),(-5.0,-3.0,1.0),(-1.0,-3.0,6.0),(-1.0,7.0,4.0),(-4.0,11.0,24.0),(0.0,-2.0,5.0),(4.0,1.0,0.0),(0.0,2.0,-4.0),(-1.0,-4.0,-9.0),(3.0,-8.0,-9.0),(2.0,0.0,-4.0),(1.0,3.0,0.0),(5.0,1.0,1.0),(3.0,2.0,-1.0),(0.0,1.0,-3.0),(4.0,-1.0,-1.0),(4.0,-5.0,-4.0),(3.0,-11.0,-6.0),(-1.0,-2.0,-2.0),(-13.0,-3.0,-3.0),(-4.0,0.0,0.0),(0.0,-3.0,6.0),(-4.0,-5.0,9.0),(-4.0,10.0,5.0),(-1.0,10.0,8.0),(-2.0,8.0,7.0),(0.0,-4.0,7.0),(2.0,0.0,4.0),(6.0,1.0,0.0),(2.0,3.0,-2.0),(0.0,4.0,-7.0),(-1.0,0.0,-4.0),(6.0,-7.0,-8.0),(2.0,0.0,-4.0),(4.0,1.0,-2.0),(4.0,-6.0,-3.0),(4.0,-10.0,-5.0),(-2.0,-2.0,-2.0),(-14.0,-4.0,-4.0),(-1.0,-6.0,10.0),(-2.0,-6.0,11.0),(-5.0,1.0,0.0),(-4.0,10.0,6.0),(0.0,10.0,5.0),(3.0,0.0,7.0),(8.0,2.0,1.0),(5.0,3.0,-4.0),(1.0,5.0,-10.0),(8.0,-8.0,-5.0),(3.0,-11.0,-6.0),(-3.0,-2.0,-1.0),(-2.0,-7.0,12.0),(-1.0,-6.0,9.0),(-2.0,-4.0,5.0),(-12.0,-2.0,-4.0),(0.0,4.0,-6.0),(-3.0,1.0,0.0),(-4.0,10.0,6.0),(-1.0,7.0,3.0),(4.0,3.0,0.0),(0.0,3.0,4.0),(5.0,0.0,1.0),(3.0,-2.0,-3.0),(11.0,-1.0,-8.0),(4.0,-11.0,-5.0),(-4.0,-6.0,8.0),(-1.0,-4.0,6.0),(-5.0,-3.0,1.0),(-9.0,-1.0,-2.0),(-4.0,1.0,-4.0),(-4.0,10.0,6.0),(-1.0,8.0,3.0),(2.0,4.0,0.0),(0.0,3.0,-2.0),(3.0,2.0,2.0),(4.0,0.0,0.0),(4.0,-1.0,0.0),(4.0,-2.0,-2.0),(3.0,-6.0,-2.0),(-1.0,-4.0,7.0),(-5.0,-4.0,1.0),(-9.0,-1.0,-2.0),(-1.0,8.0,1.0),(0.0,5.0,0.0),(0.0,4.0,0.0),(4.0,0.0,1.0),(4.0,-2.0,1.0),(3.0,-4.0,0.0),(-5.0,-1.0,1.0),(-1.0,5.0,-1.0),(7.0,52.0,-88.0),(0.0,0.0,-3.0),(0.0,-1.0,-2.0),(-3.0,-2.0,1.0),(1.0,2.0,3.0),(0.0,-1.0,3.0),(3.0,2.0,1.0),(4.0,1.0,1.0),(0.0,0.0,-3.0),(1.0,0.0,-2.0),(3.0,0.0,-3.0),(3.0,-6.0,-5.0),(4.0,-10.0,-5.0),(-9.0,-1.0,-2.0),(-5.0,9.0,6.0),(-5.0,-3.0,1.0),(0.0,-2.0,6.0),(-2.0,6.0,4.0),(-3.0,12.0,24.0),(0.0,-2.0,5.0),(3.0,1.0,0.0),(0.0,2.0,-5.0),(0.0,-5.0,-8.0),(3.0,-7.0,-9.0),(2.0,-1.0,-4.0),(0.0,3.0,0.0),(5.0,1.0,1.0),(3.0,2.0,-1.0),(1.0,1.0,-3.0),(3.0,-1.0,-2.0),(4.0,-5.0,-3.0),(4.0,-11.0,-6.0),(-2.0,-1.0,-2.0),(-13.0,-3.0,-3.0),(-3.0,0.0,0.0),(-1.0,-4.0,6.0),(-4.0,-5.0,9.0),(-4.0,10.0,5.0),(-1.0,11.0,8.0),(-1.0,7.0,7.0),(0.0,-4.0,6.0),(2.0,0.0,4.0),(5.0,1.0,1.0),(3.0,3.0,-2.0),(0.0,4.0,-7.0),(-1.0,0.0,-4.0),(5.0,-6.0,-8.0),(2.0,-1.0,-5.0),(5.0,1.0,-1.0),(4.0,-6.0,-3.0),(3.0,-10.0,-6.0),(-1.0,-2.0,-1.0),(-14.0,-4.0,-4.0),(-2.0,-5.0,10.0),(-2.0,-7.0,11.0),(-4.0,1.0,0.0),(-4.0,10.0,6.0),(0.0,11.0,5.0),(3.0,-1.0,7.0),(7.0,2.0,1.0),(5.0,3.0,-4.0),(2.0,5.0,-10.0),(7.0,-8.0,-5.0),(4.0,-10.0,-6.0),(-4.0,-3.0,-1.0),(-1.0,-7.0,12.0),(-2.0,-5.0,8.0),(-1.0,-5.0,6.0),(-13.0,-2.0,-4.0),(0.0,4.0,-6.0),(-2.0,1.0,0.0),(-5.0,11.0,6.0),(0.0,6.0,3.0),(3.0,3.0,0.0),(0.0,3.0,4.0),(6.0,0.0,1.0),(2.0,-2.0,-3.0),(12.0,-1.0,-8.0),(3.0,-10.0,-5.0),(-3.0,-6.0,8.0),(-1.0,-4.0,6.0),(-5.0,-4.0,1.0),(-9.0,-1.0,-2.0),(-4.0,1.0,-4.0),(-5.0,10.0,6.0),(0.0,8.0,3.0),(1.0,5.0,0.0),(1.0,2.0,-2.0),(2.0,3.0,2.0),(4.0,0.0,0.0),(4.0,-1.0,0.0),(4.0,-3.0,-2.0),(3.0,-6.0,-2.0),(-1.0,-4.0,6.0),(-5.0,-4.0,2.0),(-9.0,-1.0,-2.0),(-1.0,8.0,1.0),(0.0,6.0,0.0),(1.0,3.0,0.0),(4.0,0.0,1.0),(4.0,-2.0,1.0),(2.0,-3.0,0.0),(-4.0,-2.0,1.0),(-2.0,5.0,-1.0),(-14.0,109.0,-37.0),(1.0,-3.0,0.0),(2.0,0.0,0.0),(0.0,4.0,0.0),(3.0,1.0,-4.0),(-3.0,2.0,-1.0),(-4.0,-1.0,-1.0),(-1.0,-3.0,0.0),(1.0,-6.0,0.0),(3.0,-2.0,1.0),(4.0,1.0,0.0),(2.0,2.0,0.0),(3.0,0.0,-5.0),(-1.0,7.0,0.0),(-4.0,3.0,-1.0),(-6.0,0.0,-1.0),(-2.0,-6.0,0.0),(1.0,-6.0,0.0),(4.0,-4.0,0.0),(6.0,0.0,1.0),(2.0,-2.0,-6.0),(3.0,6.0,0.0),(-1.0,9.0,0.0),(-5.0,4.0,-1.0),(-7.0,0.0,-2.0),(-2.0,-7.0,0.0),(1.0,-8.0,0.0),(5.0,-6.0,0.0),(1.0,-3.0,-6.0),(9.0,1.0,2.0),(3.0,8.0,0.0),(-1.0,11.0,-1.0),(-6.0,5.0,-2.0),(-9.0,-1.0,-2.0),(-3.0,-7.0,0.0),(1.0,-11.0,0.0),(1.0,-4.0,-6.0),(6.0,-6.0,3.0),(11.0,2.0,1.0),(4.0,8.0,0.0),(-2.0,12.0,-3.0),(-6.0,5.0,-3.0),(-10.0,-1.0,-2.0),(-4.0,-7.0,0.0),(2.0,-4.0,-12.0),(3.0,-6.0,-13.0),(0.0,-14.0,8.0),(-3.0,7.0,13.0),(7.0,-6.0,5.0),(11.0,1.0,1.0),(5.0,8.0,-2.0),(-1.0,14.0,-6.0),(-5.0,5.0,-5.0),(-11.0,-1.0,-3.0),(4.0,-6.0,-15.0),(5.0,-10.0,-16.0),(-6.0,-8.0,3.0),(0.0,-15.0,8.0),(5.0,-6.0,6.0),(-4.0,11.0,17.0),(11.0,1.0,2.0),(6.0,8.0,-3.0),(0.0,15.0,-9.0),(-5.0,5.0,-5.0),(5.0,-10.0,-18.0),(-1.0,-3.0,0.0),(-10.0,-1.0,-2.0),(-5.0,-7.0,3.0),(0.0,-13.0,8.0),(5.0,-5.0,5.0),(11.0,1.0,2.0),(0.0,0.0,2.0),(5.0,8.0,-3.0),(0.0,13.0,-9.0),(-1.0,-2.0,0.0),(0.0,-12.0,8.0),(-203.0,-98.0,182.0),(0.0,-2.0,0.0),(-3.0,2.0,1.0),(-1.0,2.0,2.0),(4.0,2.0,0.0),(0.0,3.0,7.0),(1.0,1.0,10.0),(8.0,-1.0,0.0),(-1.0,-3.0,-11.0),(-1.0,-3.0,-7.0),(-2.0,-2.0,-2.0),(-1.0,-3.0,0.0),(0.0,-1.0,1.0),(-4.0,1.0,0.0),(-3.0,0.0,1.0),(-3.0,1.0,3.0),(0.0,1.0,6.0),(1.0,6.0,-1.0),(1.0,3.0,12.0),(2.0,0.0,1.0),(13.0,-3.0,0.0),(1.0,-1.0,-2.0),(0.0,-3.0,-12.0),(-2.0,-2.0,-6.0),(-2.0,-1.0,-1.0),(-1.0,-4.0,0.0),(-3.0,0.0,1.0),(-5.0,0.0,0.0),(-1.0,-1.0,1.0),(0.0,-4.0,-3.0),(0.0,-6.0,-9.0),(0.0,-6.0,-4.0),(2.0,0.0,0.0),(-1.0,-5.0,1.0),(-3.0,1.0,0.0),(-2.0,8.0,5.0),(-2.0,5.0,10.0),(-2.0,4.0,10.0),(0.0,3.0,11.0),(4.0,9.0,-2.0),(2.0,0.0,1.0),(15.0,-3.0,0.0),(0.0,-1.0,-1.0),(0.0,-3.0,-12.0),(-2.0,-1.0,-6.0),(-4.0,-2.0,0.0),(-1.0,-4.0,-4.0),(-1.0,-6.0,-8.0),(1.0,-4.0,1.0),(-1.0,-6.0,2.0),(-4.0,-2.0,0.0),(-5.0,1.0,0.0),(-2.0,4.0,0.0),(-2.0,1.0,10.0),(-2.0,2.0,11.0),(0.0,2.0,12.0),(4.0,0.0,0.0),(3.0,12.0,-2.0),(14.0,-3.0,0.0),(3.0,-1.0,-2.0),(-1.0,-3.0,-12.0),(-4.0,-3.0,-9.0),(-2.0,-10.0,2.0),(-5.0,-4.0,1.0),(-7.0,1.0,0.0),(-1.0,-2.0,4.0),(-4.0,-1.0,1.0),(0.0,2.0,7.0),(1.0,2.0,12.0),(1.0,0.0,2.0),(0.0,-7.0,1.0),(13.0,-2.0,0.0),(2.0,8.0,-2.0),(1.0,8.0,-2.0),(3.0,-1.0,-2.0),(0.0,-3.0,-12.0),(-9.0,-7.0,-6.0),(-2.0,-2.0,-3.0),(-5.0,0.0,0.0),(0.0,-1.0,0.0),(-3.0,0.0,2.0),(0.0,-3.0,1.0),(-3.0,0.0,4.0),(0.0,1.0,7.0),(0.0,2.0,12.0),(4.0,-4.0,0.0),(9.0,-1.0,0.0),(5.0,3.0,-1.0),(0.0,6.0,-2.0),(0.0,-3.0,-11.0),(-2.0,-2.0,-8.0),(-2.0,-1.0,-3.0),(-4.0,0.0,-1.0),(0.0,-2.0,0.0),(-4.0,0.0,0.0),(-1.0,-2.0,3.0),(-2.0,-2.0,4.0),(0.0,0.0,7.0),(9.0,-1.0,0.0),(5.0,3.0,-1.0),(-2.0,0.0,-7.0),(-2.0,0.0,-3.0),(-2.0,-1.0,0.0),(1.0,-1.0,3.0),(8.0,98.0,-24.0),(0.0,3.0,0.0),(0.0,3.0,2.0),(1.0,3.0,7.0),(2.0,2.0,10.0),(8.0,-2.0,-1.0),(-2.0,-3.0,-11.0),(-2.0,-3.0,-7.0),(-2.0,-2.0,-1.0),(-1.0,-2.0,0.0),(-1.0,-2.0,1.0),(-4.0,1.0,1.0),(-2.0,0.0,0.0),(0.0,4.0,0.0),(-1.0,2.0,3.0),(0.0,3.0,6.0),(2.0,2.0,12.0),(3.0,0.0,0.0),(13.0,-2.0,-2.0),(1.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-3.0,-3.0,-6.0),(-3.0,-1.0,-1.0),(0.0,-3.0,1.0),(-3.0,-1.0,0.0),(-5.0,0.0,0.0),(-4.0,-17.0,-14.0),(3.0,0.0,0.0),(0.0,-5.0,2.0),(-3.0,1.0,0.0),(2.0,11.0,4.0),(1.0,7.0,9.0),(0.0,4.0,3.0),(-3.0,3.0,0.0),(0.0,2.0,7.0),(2.0,2.0,11.0),(2.0,0.0,1.0),(14.0,-2.0,-2.0),(1.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-3.0,-2.0,-6.0),(-4.0,-2.0,0.0),(-1.0,-4.0,-3.0),(-2.0,-6.0,-7.0),(1.0,-3.0,0.0),(-1.0,-7.0,2.0),(-3.0,-2.0,1.0),(-5.0,1.0,0.0),(-1.0,3.0,0.0),(0.0,7.0,-1.0),(-1.0,5.0,9.0),(0.0,4.0,11.0),(2.0,2.0,12.0),(4.0,0.0,0.0),(14.0,-2.0,-2.0),(3.0,-2.0,-3.0),(-2.0,-3.0,-11.0),(-6.0,-3.0,-9.0),(-1.0,-10.0,3.0),(-5.0,-3.0,2.0),(-7.0,1.0,0.0),(-3.0,6.0,0.0),(-1.0,2.0,12.0),(2.0,2.0,11.0),(4.0,0.0,1.0),(-1.0,-9.0,3.0),(0.0,-8.0,1.0),(13.0,-1.0,-2.0),(1.0,7.0,-2.0),(2.0,8.0,-3.0),(2.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-9.0,-7.0,-5.0),(-2.0,-1.0,-2.0),(-5.0,1.0,0.0),(-1.0,1.0,4.0),(-3.0,-1.0,2.0),(0.0,3.0,7.0),(1.0,2.0,11.0),(0.0,-7.0,2.0),(4.0,-5.0,0.0),(9.0,0.0,-2.0),(5.0,3.0,-1.0),(0.0,6.0,-2.0),(-2.0,-3.0,-12.0),(-3.0,-2.0,-7.0),(-3.0,-1.0,-3.0),(-4.0,0.0,0.0),(-3.0,1.0,0.0),(-3.0,0.0,3.0),(-1.0,-3.0,1.0),(-1.0,0.0,4.0),(0.0,0.0,8.0),(4.0,-5.0,0.0),(9.0,0.0,-2.0),(4.0,3.0,-2.0),(-2.0,0.0,-7.0),(-3.0,1.0,-4.0),(-4.0,0.0,0.0),(-4.0,0.0,0.0),(0.0,-2.0,3.0),(0.0,-2.0,4.0),(6.0,0.0,-2.0),(0.0,2.0,-4.0),(6.0,94.0,-25.0),(0.0,-1.0,0.0),(-3.0,1.0,1.0),(-1.0,2.0,2.0),(4.0,2.0,-1.0),(1.0,3.0,7.0),(2.0,2.0,10.0),(8.0,-1.0,-1.0),(-2.0,-3.0,-11.0),(-2.0,-3.0,-7.0),(-2.0,-3.0,-1.0),(-1.0,-2.0,0.0),(-1.0,-2.0,1.0),(-4.0,1.0,0.0),(-3.0,1.0,2.0),(-1.0,0.0,3.0),(0.0,2.0,6.0),(1.0,6.0,-1.0),(2.0,2.0,12.0),(3.0,0.0,0.0),(13.0,-2.0,-2.0),(1.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-3.0,-2.0,-7.0),(-3.0,-2.0,0.0),(0.0,-3.0,1.0),(-3.0,-1.0,1.0),(-5.0,0.0,0.0),(-1.0,0.0,2.0),(-1.0,-4.0,-3.0),(-1.0,-6.0,-9.0),(0.0,-7.0,-5.0),(2.0,0.0,0.0),(0.0,-4.0,2.0),(-4.0,0.0,0.0),(-1.0,9.0,6.0),(-1.0,4.0,9.0),(0.0,5.0,11.0),(2.0,2.0,10.0),(3.0,9.0,-2.0),(3.0,0.0,1.0),(14.0,-2.0,-2.0),(0.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-3.0,-2.0,-6.0),(-4.0,-1.0,0.0),(-1.0,-4.0,-3.0),(-2.0,-6.0,-7.0),(1.0,-4.0,0.0),(-1.0,-7.0,2.0),(-3.0,-2.0,1.0),(-5.0,1.0,1.0),(-2.0,4.0,0.0),(-1.0,1.0,10.0),(-1.0,3.0,11.0),(2.0,2.0,12.0),(5.0,0.0,0.0),(1.0,11.0,-4.0),(14.0,-2.0,-2.0),(3.0,-1.0,-2.0),(-2.0,-3.0,-11.0),(-6.0,-3.0,-9.0),(-1.0,-10.0,3.0),(-4.0,-4.0,2.0),(-8.0,0.0,1.0),(0.0,-1.0,4.0),(-3.0,-1.0,2.0),(0.0,2.0,7.0),(2.0,2.0,11.0),(2.0,0.0,2.0),(0.0,-7.0,1.0),(13.0,-2.0,-2.0),(2.0,8.0,-2.0),(1.0,7.0,-3.0),(2.0,0.0,-2.0),(-2.0,-3.0,-12.0),(-9.0,-8.0,-4.0),(-2.0,-1.0,-3.0),(-5.0,0.0,0.0),(0.0,-2.0,0.0),(-3.0,1.0,3.0),(-1.0,-3.0,1.0),(-1.0,0.0,4.0),(0.0,1.0,8.0),(3.0,2.0,11.0),(3.0,-4.0,0.0),(9.0,-1.0,-2.0),(5.0,3.0,-1.0),(0.0,6.0,-2.0),(-2.0,-3.0,-12.0),(-3.0,-2.0,-7.0),(-3.0,-1.0,-3.0),(-3.0,0.0,0.0),(-1.0,-3.0,0.0),(-4.0,0.0,1.0),(0.0,-2.0,3.0),(0.0,-1.0,4.0),(0.0,0.0,7.0),(9.0,-1.0,-1.0),(4.0,3.0,-2.0),(-2.0,0.0,-7.0),(-3.0,0.0,-3.0),(-2.0,-2.0,1.0),(1.0,-1.0,3.0),(12.0,60.0,-93.0),(-2.0,1.0,0.0),(1.0,2.0,-2.0),(3.0,0.0,1.0),(2.0,2.0,3.0),(-1.0,-4.0,4.0),(-3.0,-1.0,1.0),(-4.0,1.0,-1.0),(-1.0,3.0,-2.0),(2.0,4.0,-4.0),(3.0,0.0,-1.0),(3.0,0.0,1.0),(2.0,4.0,4.0),(1.0,-4.0,3.0),(-1.0,-5.0,4.0),(-5.0,-1.0,2.0),(-5.0,1.0,0.0),(-1.0,4.0,-3.0),(1.0,5.0,-5.0),(5.0,3.0,-2.0),(0.0,4.0,5.0),(7.0,-2.0,1.0),(1.0,-5.0,4.0),(-2.0,-6.0,5.0),(-5.0,-2.0,2.0),(-7.0,2.0,0.0),(-2.0,5.0,-4.0),(2.0,6.0,-5.0),(0.0,5.0,6.0),(6.0,2.0,-3.0),(8.0,-2.0,1.0),(2.0,-6.0,4.0),(-2.0,-7.0,6.0),(-7.0,-3.0,3.0),(-8.0,2.0,-1.0),(-3.0,6.0,-3.0),(-1.0,3.0,6.0),(4.0,10.0,-5.0),(7.0,3.0,-2.0),(10.0,-2.0,1.0),(2.0,-7.0,3.0),(-3.0,-11.0,6.0),(-8.0,-3.0,2.0),(-9.0,2.0,0.0),(-1.0,1.0,6.0),(-3.0,9.0,-2.0),(4.0,13.0,-4.0),(8.0,4.0,0.0),(11.0,-3.0,1.0),(2.0,-8.0,2.0),(-4.0,-13.0,4.0),(-7.0,-5.0,1.0),(-1.0,2.0,12.0),(-11.0,3.0,-1.0),(-2.0,9.0,-1.0),(4.0,15.0,-2.0),(8.0,6.0,0.0),(11.0,-3.0,1.0),(2.0,-9.0,1.0),(-4.0,-15.0,3.0),(-1.0,2.0,19.0),(-8.0,-5.0,0.0),(-11.0,3.0,-1.0),(-2.0,9.0,-2.0),(4.0,16.0,-2.0),(8.0,5.0,0.0),(11.0,-3.0,1.0),(2.0,-9.0,1.0),(-2.0,0.0,2.0),(-3.0,-14.0,2.0),(-7.0,-4.0,0.0),(-10.0,2.0,-1.0),(-1.0,8.0,-1.0),(3.0,14.0,-2.0),(7.0,4.0,0.0),(10.0,-2.0,0.0),(93.0,-7.0,-28.0),(0.0,3.0,1.0),(2.0,-2.0,1.0),(0.0,2.0,4.0),(-1.0,4.0,9.0),(-2.0,5.0,14.0),(0.0,-5.0,1.0),(3.0,-6.0,-14.0),(0.0,-4.0,-9.0),(0.0,-1.0,-4.0),(-2.0,-1.0,0.0),(0.0,2.0,-3.0),(-6.0,1.0,-1.0),(0.0,4.0,0.0),(-1.0,3.0,1.0),(0.0,1.0,4.0),(6.0,0.0,1.0),(-2.0,5.0,9.0),(-3.0,4.0,14.0),(-1.0,0.0,8.0),(0.0,-5.0,1.0),(2.0,-4.0,-7.0),(3.0,-6.0,-14.0),(1.0,-3.0,-9.0),(-6.0,0.0,-1.0),(0.0,0.0,-4.0),(-3.0,2.0,-1.0),(0.0,4.0,-1.0),(0.0,3.0,4.0),(0.0,6.0,9.0),(-3.0,5.0,14.0),(-1.0,0.0,8.0),(0.0,-5.0,1.0),(2.0,-5.0,-7.0),(2.0,-6.0,-14.0),(-2.0,0.0,-10.0),(0.0,2.0,2.0),(0.0,3.0,-2.0),(-1.0,-1.0,-4.0),(-2.0,0.0,0.0),(0.0,2.0,0.0),(3.0,-1.0,4.0),(-2.0,5.0,8.0),(-3.0,6.0,14.0),(-1.0,0.0,8.0),(0.0,-3.0,0.0),(2.0,-4.0,-7.0),(3.0,-6.0,-14.0),(1.0,-3.0,-9.0),(-1.0,-1.0,-2.0),(-3.0,-1.0,0.0),(0.0,2.0,-2.0),(-5.0,1.0,-1.0),(0.0,4.0,0.0),(-1.0,2.0,0.0),(0.0,1.0,2.0),(6.0,0.0,1.0),(-1.0,5.0,9.0),(-4.0,5.0,14.0),(0.0,-1.0,8.0),(0.0,-5.0,0.0),(1.0,-4.0,-6.0),(3.0,-6.0,-14.0),(1.0,-3.0,-9.0),(-6.0,0.0,-1.0),(0.0,0.0,-2.0),(-3.0,3.0,-1.0),(0.0,4.0,-1.0),(0.0,1.0,2.0),(0.0,7.0,8.0),(-3.0,5.0,15.0),(0.0,0.0,8.0),(0.0,-5.0,0.0),(1.0,-5.0,-6.0),(2.0,-6.0,-14.0),(-1.0,0.0,-9.0),(-1.0,1.0,1.0),(0.0,3.0,-2.0),(0.0,-1.0,-2.0),(0.0,0.0,-1.0),(-1.0,6.0,10.0),(-3.0,6.0,15.0),(-1.0,0.0,7.0),(0.0,-3.0,0.0),(2.0,-4.0,-6.0),(3.0,-6.0,-15.0),(0.0,-3.0,-8.0),(0.0,-1.0,-3.0),(-3.0,-1.0,0.0),(0.0,1.0,-1.0),(-4.0,1.0,-1.0),(0.0,3.0,-1.0),(4.0,0.0,1.0),(0.0,3.0,1.0),(0.0,2.0,2.0),(-2.0,4.0,8.0),(-3.0,5.0,14.0),(0.0,0.0,8.0),(0.0,-5.0,1.0),(1.0,-4.0,-6.0),(3.0,-6.0,-15.0),(1.0,-4.0,-8.0),(-6.0,0.0,-1.0),(0.0,0.0,-3.0),(-2.0,2.0,-1.0),(0.0,4.0,0.0),(2.0,2.0,0.0),(-1.0,2.0,2.0),(-2.0,5.0,8.0),(-3.0,5.0,14.0),(0.0,-1.0,8.0),(0.0,-4.0,1.0),(1.0,-5.0,-7.0),(2.0,-5.0,-14.0),(-2.0,1.0,-1.0),(1.0,-4.0,-9.0),(0.0,0.0,-2.0),(0.0,4.0,-1.0),(0.0,2.0,3.0),(-2.0,4.0,8.0),(-3.0,5.0,14.0),(0.0,-5.0,1.0),(-38.0,-10.0,-26.0),(3.0,-5.0,-9.0),(1.0,-1.0,-3.0),(3.0,2.0,0.0),(1.0,-2.0,0.0),(4.0,1.0,1.0),(0.0,-4.0,0.0),(-5.0,-2.0,0.0),(-1.0,0.0,1.0),(-3.0,1.0,0.0),(-1.0,2.0,4.0),(-3.0,4.0,9.0),(-2.0,5.0,13.0),(0.0,5.0,-1.0),(4.0,3.0,0.0),(3.0,-6.0,-15.0),(2.0,-3.0,-8.0),(7.0,1.0,1.0),(0.0,-3.0,-3.0),(2.0,-1.0,2.0),(0.0,-4.0,1.0),(-3.0,-2.0,0.0),(0.0,0.0,3.0),(-7.0,-1.0,-1.0),(-2.0,4.0,10.0),(-3.0,6.0,14.0),(-1.0,5.0,5.0),(0.0,5.0,0.0),(7.0,1.0,0.0),(2.0,0.0,-8.0),(3.0,-6.0,-14.0),(4.0,-5.0,-6.0),(0.0,1.0,2.0),(0.0,-5.0,1.0),(0.0,0.0,-2.0),(-5.0,1.0,9.0),(-3.0,6.0,15.0),(-1.0,4.0,5.0),(4.0,2.0,0.0),(0.0,2.0,0.0),(1.0,-1.0,-8.0),(3.0,-6.0,-14.0),(3.0,-4.0,-8.0),(0.0,-1.0,-1.0),(0.0,-3.0,1.0),(-2.0,0.0,2.0),(-2.0,4.0,9.0),(-2.0,5.0,14.0),(2.0,4.0,8.0),(7.0,2.0,1.0),(4.0,1.0,1.0),(3.0,0.0,1.0),(7.0,0.0,0.0),(1.0,-4.0,-6.0),(3.0,-7.0,-14.0),(1.0,-3.0,-9.0),(0.0,0.0,-2.0),(0.0,1.0,-2.0),(-4.0,0.0,-1.0),(0.0,3.0,0.0),(4.0,1.0,1.0),(0.0,3.0,0.0),(0.0,2.0,2.0),(-1.0,4.0,8.0),(-3.0,5.0,15.0),(-2.0,0.0,7.0),(-7.0,-1.0,-2.0),(-3.0,-1.0,0.0),(-4.0,0.0,-1.0),(-6.0,-2.0,-2.0),(2.0,0.0,-8.0),(3.0,-6.0,-14.0),(2.0,-4.0,-8.0),(1.0,-2.0,-2.0),(0.0,-1.0,0.0),(5.0,0.0,2.0),(0.0,-4.0,0.0),(-6.0,-1.0,0.0),(0.0,-1.0,1.0),(-1.0,1.0,3.0),(-2.0,4.0,8.0),(-2.0,6.0,14.0),(7.0,1.0,2.0),(3.0,2.0,0.0),(3.0,-1.0,1.0),(4.0,-6.0,-15.0),(1.0,-4.0,-8.0),(0.0,0.0,-2.0),(-1.0,2.0,-2.0),(0.0,4.0,0.0),(2.0,2.0,0.0),(-1.0,2.0,2.0),(-2.0,4.0,8.0),(-3.0,6.0,13.0),(-4.0,-2.0,0.0),(-2.0,0.0,-1.0),(3.0,-6.0,-15.0),(2.0,-4.0,-8.0),(0.0,-2.0,-1.0),(2.0,-2.0,1.0),(-1.0,-4.0,2.0),(-3.0,-1.0,0.0),(0.0,0.0,2.0),(0.0,4.0,8.0),(3.0,2.0,0.0),(2.0,-3.0,-9.0),(0.0,5.0,0.0),(-2.0,4.0,7.0),(1.0,-5.0,-7.0),(0.0,-4.0,1.0),(0.0,2.0,1.0),(0.0,3.0,-1.0),(-54.0,-152.0,-39.0),(0.0,0.0,2.0),(3.0,-2.0,-1.0),(2.0,-1.0,-2.0),(-3.0,2.0,-3.0),(0.0,-6.0,-5.0),(-1.0,-10.0,-7.0),(-9.0,2.0,0.0),(1.0,10.0,7.0),(1.0,6.0,5.0),(1.0,0.0,4.0),(0.0,-1.0,3.0),(0.0,-1.0,1.0),(4.0,-1.0,0.0),(4.0,-2.0,0.0),(2.0,-2.0,0.0),(1.0,-6.0,-4.0),(0.0,2.0,-6.0),(-1.0,-10.0,-7.0),(-3.0,0.0,-1.0),(-14.0,2.0,-1.0),(-1.0,2.0,1.0),(1.0,10.0,7.0),(1.0,6.0,5.0),(3.0,0.0,3.0),(0.0,-2.0,3.0),(2.0,-1.0,2.0),(5.0,-1.0,1.0),(0.0,-2.0,0.0),(0.0,1.0,5.0),(-1.0,8.0,9.0),(-1.0,3.0,7.0),(-4.0,0.0,0.0),(0.0,-3.0,5.0),(4.0,0.0,0.0),(4.0,-4.0,-10.0),(2.0,-8.0,-7.0),(2.0,-10.0,-7.0),(-1.0,-10.0,-7.0),(0.0,5.0,-9.0),(-2.0,0.0,-2.0),(-15.0,2.0,0.0),(-1.0,2.0,1.0),(1.0,11.0,7.0),(2.0,5.0,4.0),(3.0,-1.0,3.0),(0.0,2.0,5.0),(1.0,6.0,9.0),(-4.0,-2.0,3.0),(0.0,-4.0,7.0),(2.0,-2.0,3.0),(5.0,0.0,0.0),(4.0,0.0,-3.0),(1.0,-10.0,-4.0),(2.0,-11.0,-6.0),(-1.0,-11.0,-6.0),(-4.0,0.0,-1.0),(2.0,7.0,-12.0),(-15.0,3.0,-1.0),(-4.0,2.0,1.0),(1.0,10.0,7.0),(4.0,8.0,8.0),(-1.0,-6.0,9.0),(3.0,-3.0,6.0),(8.0,-1.0,0.0),(0.0,-5.0,1.0),(3.0,-3.0,1.0),(0.0,-6.0,-4.0),(-1.0,-11.0,-7.0),(-2.0,-1.0,0.0),(-2.0,-3.0,6.0),(-13.0,2.0,-2.0),(1.0,4.0,-7.0),(0.0,5.0,-7.0),(-3.0,3.0,0.0),(1.0,10.0,7.0),(7.0,2.0,12.0),(2.0,2.0,4.0),(4.0,-1.0,0.0),(0.0,0.0,2.0),(3.0,-2.0,0.0),(0.0,-2.0,3.0),(2.0,-5.0,-1.0),(0.0,-8.0,-3.0),(-1.0,-10.0,-7.0),(-6.0,0.0,2.0),(-9.0,1.0,-1.0),(-3.0,3.0,-3.0),(1.0,4.0,-6.0),(1.0,11.0,7.0),(2.0,6.0,5.0),(3.0,3.0,3.0),(3.0,0.0,2.0),(0.0,-2.0,2.0),(3.0,0.0,1.0),(0.0,-4.0,1.0),(0.0,-5.0,0.0),(0.0,-7.0,-3.0),(-9.0,1.0,-1.0),(-3.0,3.0,-3.0),(2.0,7.0,3.0),(3.0,3.0,1.0),(1.0,-1.0,2.0),(-1.0,-4.0,0.0),(24.0,58.0,-85.0),(1.0,0.0,-3.0),(1.0,-1.0,-3.0),(0.0,-6.0,-6.0),(-1.0,-9.0,-6.0),(-8.0,1.0,0.0),(0.0,11.0,6.0),(1.0,5.0,6.0),(2.0,0.0,3.0),(0.0,0.0,3.0),(0.0,-2.0,2.0),(4.0,0.0,0.0),(3.0,-1.0,0.0),(1.0,1.0,-3.0),(2.0,-2.0,-3.0),(0.0,-6.0,-4.0),(-1.0,-11.0,-7.0),(-2.0,0.0,-2.0),(-14.0,2.0,0.0),(-2.0,2.0,1.0),(1.0,11.0,7.0),(2.0,5.0,5.0),(2.0,1.0,3.0),(0.0,-2.0,3.0),(2.0,-2.0,2.0),(5.0,0.0,0.0),(-1.0,10.0,22.0),(-4.0,0.0,0.0),(0.0,-3.0,4.0),(4.0,-1.0,0.0),(1.0,-1.0,-13.0),(2.0,-7.0,-9.0),(0.0,-1.0,-5.0),(4.0,0.0,-2.0),(0.0,-7.0,-4.0),(-1.0,-10.0,-7.0),(-2.0,0.0,-1.0),(-15.0,2.0,-1.0),(-1.0,2.0,2.0),(1.0,10.0,6.0),(2.0,5.0,5.0),(3.0,-1.0,2.0),(0.0,2.0,6.0),(1.0,6.0,9.0),(-3.0,-2.0,3.0),(-1.0,-4.0,6.0),(3.0,-2.0,3.0),(5.0,0.0,0.0),(3.0,2.0,-3.0),(1.0,3.0,-6.0),(3.0,-9.0,-7.0),(2.0,-10.0,-7.0),(-1.0,-10.0,-7.0),(-5.0,0.0,-2.0),(-15.0,2.0,0.0),(-3.0,2.0,0.0),(1.0,11.0,7.0),(3.0,8.0,8.0),(0.0,-6.0,10.0),(3.0,-4.0,5.0),(8.0,0.0,0.0),(5.0,1.0,-5.0),(1.0,-11.0,-5.0),(-1.0,-11.0,-7.0),(-4.0,-1.0,0.0),(-2.0,-5.0,8.0),(-2.0,-3.0,6.0),(-13.0,2.0,-1.0),(1.0,4.0,-7.0),(1.0,6.0,-7.0),(-3.0,2.0,0.0),(1.0,11.0,7.0),(7.0,2.0,11.0),(1.0,1.0,4.0),(6.0,-1.0,0.0),(1.0,-2.0,-3.0),(3.0,-3.0,2.0),(0.0,-7.0,-5.0),(-1.0,-11.0,-5.0),(-1.0,-4.0,6.0),(-5.0,0.0,2.0),(-10.0,1.0,-1.0),(-3.0,3.0,-4.0),(1.0,4.0,-5.0),(1.0,11.0,7.0),(2.0,6.0,4.0),(3.0,3.0,3.0),(4.0,0.0,2.0),(4.0,0.0,0.0),(3.0,-3.0,-1.0),(0.0,-2.0,3.0),(1.0,-5.0,-1.0),(0.0,-7.0,-2.0),(-5.0,-1.0,3.0),(-10.0,2.0,-1.0),(-3.0,3.0,-4.0),(2.0,7.0,4.0),(3.0,4.0,1.0),(4.0,1.0,1.0),(4.0,-1.0,0.0),(0.0,-3.0,1.0),(0.0,-5.0,0.0),(-7.0,2.0,-1.0),(2.0,5.0,0.0),(17.0,107.0,-31.0),(0.0,3.0,0.0),(-2.0,0.0,-1.0),(0.0,-4.0,0.0),(0.0,-4.0,-4.0),(4.0,0.0,1.0),(2.0,4.0,0.0),(0.0,5.0,0.0),(-3.0,3.0,-1.0),(-4.0,0.0,0.0),(-2.0,-4.0,-1.0),(0.0,-5.0,0.0),(0.0,-2.0,-6.0),(3.0,-4.0,0.0),(6.0,0.0,1.0),(3.0,5.0,1.0),(0.0,7.0,0.0),(-4.0,4.0,-1.0),(-5.0,0.0,-1.0),(-4.0,-4.0,0.0),(0.0,0.0,-7.0),(0.0,-10.0,0.0),(4.0,-5.0,0.0),(8.0,0.0,1.0),(3.0,6.0,0.0),(0.0,9.0,0.0),(-4.0,5.0,0.0),(-6.0,0.0,-1.0),(0.0,0.0,-9.0),(-5.0,-6.0,0.0),(0.0,-11.0,1.0),(4.0,-7.0,1.0),(9.0,0.0,1.0),(5.0,8.0,0.0),(0.0,10.0,-1.0),(-3.0,6.0,-1.0),(1.0,-1.0,-10.0),(-11.0,0.0,-1.0),(-6.0,-7.0,0.0),(0.0,-13.0,3.0),(5.0,-7.0,2.0),(11.0,0.0,1.0),(6.0,8.0,-1.0),(1.0,12.0,-2.0),(2.0,-3.0,-12.0),(-5.0,7.0,-4.0),(-12.0,0.0,-1.0),(-7.0,-7.0,3.0),(0.0,-14.0,6.0),(5.0,-7.0,4.0),(11.0,0.0,1.0),(7.0,6.0,-2.0),(2.0,-6.0,-13.0),(1.0,14.0,-9.0),(-5.0,7.0,-5.0),(-12.0,0.0,-1.0),(-7.0,-7.0,4.0),(-1.0,-14.0,8.0),(6.0,-8.0,5.0),(12.0,0.0,1.0),(2.0,-10.0,-17.0),(7.0,7.0,-4.0),(1.0,15.0,-8.0),(-5.0,7.0,-5.0),(-12.0,0.0,-1.0),(-7.0,-7.0,3.0),(-1.0,-15.0,9.0),(5.0,-6.0,4.0),(1.0,0.0,-2.0),(11.0,0.0,1.0),(6.0,6.0,-3.0),(0.0,13.0,-8.0),(-4.0,6.0,-4.0),(-11.0,0.0,-1.0),(-6.0,-6.0,3.0),(0.0,-12.0,8.0),(119.0,18.0,38.0),(1.0,-2.0,-1.0),(3.0,1.0,0.0),(1.0,-2.0,-4.0),(3.0,-4.0,-9.0),(2.0,-6.0,-14.0),(0.0,4.0,-1.0),(-3.0,7.0,14.0),(-2.0,4.0,9.0),(-2.0,1.0,3.0),(-3.0,1.0,-1.0),(-1.0,0.0,2.0),(-4.0,0.0,-2.0),(0.0,-4.0,1.0),(0.0,-3.0,-1.0),(0.0,-1.0,-3.0),(7.0,-1.0,2.0),(2.0,-4.0,-9.0),(3.0,-7.0,-14.0),(1.0,0.0,-8.0),(0.0,4.0,-1.0),(-1.0,6.0,5.0),(-3.0,7.0,14.0),(-3.0,3.0,9.0),(-6.0,1.0,-2.0),(-1.0,0.0,4.0),(-2.0,-2.0,0.0),(0.0,-3.0,1.0),(0.0,-2.0,-4.0),(0.0,-1.0,-3.0),(5.0,-5.0,-4.0),(3.0,-7.0,-14.0),(1.0,-1.0,-8.0),(0.0,5.0,-1.0),(-1.0,6.0,5.0),(-3.0,7.0,14.0),(-5.0,0.0,9.0),(0.0,0.0,-2.0),(-1.0,1.0,1.0),(-1.0,1.0,1.0),(-3.0,1.0,-1.0),(-1.0,-2.0,2.0),(-4.0,0.0,-1.0),(0.0,-3.0,2.0),(5.0,0.0,1.0),(1.0,-2.0,0.0),(3.0,1.0,0.0),(1.0,-1.0,-2.0),(2.0,-4.0,-8.0),(3.0,-7.0,-14.0),(1.0,-1.0,-8.0),(0.0,2.0,0.0),(-2.0,5.0,6.0),(-3.0,7.0,13.0),(-3.0,2.0,-2.0),(-2.0,3.0,8.0),(-7.0,0.0,-1.0),(0.0,0.0,2.0),(-2.0,-2.0,0.0),(0.0,-3.0,2.0),(3.0,-3.0,1.0),(0.0,-1.0,-1.0),(6.0,0.0,2.0),(2.0,-4.0,-9.0),(3.0,-6.0,-14.0),(1.0,-1.0,-8.0),(0.0,5.0,-1.0),(-1.0,6.0,4.0),(-7.0,0.0,-2.0),(-3.0,7.0,15.0),(-4.0,0.0,8.0),(0.0,-1.0,-2.0),(0.0,-3.0,3.0),(0.0,0.0,1.0),(4.0,-6.0,-6.0),(4.0,-7.0,-15.0),(0.0,0.0,-7.0),(0.0,3.0,-3.0),(-3.0,0.0,0.0),(-2.0,1.0,-1.0),(1.0,4.0,7.0),(-3.0,7.0,14.0),(-3.0,2.0,9.0),(0.0,0.0,3.0),(0.0,-3.0,1.0),(1.0,-1.0,-2.0),(2.0,-5.0,-9.0),(3.0,-6.0,-14.0),(1.0,-2.0,-7.0),(-4.0,0.0,0.0),(-6.0,0.0,-2.0),(0.0,4.0,-2.0),(-50.0,11.0,33.0),(0.0,0.0,-3.0),(-2.0,-2.0,1.0),(0.0,-2.0,-5.0),(2.0,-4.0,-9.0),(2.0,-6.0,-13.0),(-1.0,-4.0,3.0),(-3.0,7.0,13.0),(0.0,4.0,10.0),(0.0,1.0,4.0),(2.0,0.0,0.0),(0.0,2.0,0.0),(6.0,1.0,0.0),(1.0,4.0,-1.0),(0.0,0.0,-4.0),(1.0,-1.0,-4.0),(-6.0,-1.0,0.0),(1.0,-4.0,-9.0),(3.0,-6.0,-14.0),(1.0,-6.0,-4.0),(0.0,-4.0,2.0),(-2.0,2.0,8.0),(-3.0,6.0,14.0),(-1.0,5.0,9.0),(6.0,1.0,0.0),(0.0,2.0,3.0),(3.0,2.0,-1.0),(0.0,3.0,-3.0),(1.0,-1.0,-4.0),(0.0,-2.0,-11.0),(3.0,-7.0,-14.0),(0.0,-6.0,-4.0),(0.0,-3.0,3.0),(-2.0,1.0,7.0),(-2.0,7.0,14.0),(2.0,6.0,8.0),(1.0,0.0,-3.0),(0.0,4.0,-2.0),(0.0,0.0,2.0),(0.0,0.0,2.0),(1.0,-3.0,-12.0),(4.0,-7.0,-14.0),(0.0,-5.0,-4.0),(0.0,-2.0,1.0),(-2.0,2.0,7.0),(-3.0,7.0,14.0),(0.0,4.0,9.0),(0.0,1.0,2.0),(3.0,-1.0,0.0),(0.0,3.0,0.0),(5.0,0.0,0.0),(0.0,3.0,-2.0),(-5.0,0.0,0.0),(0.0,1.0,-2.0),(1.0,-1.0,-3.0),(1.0,-3.0,-9.0),(3.0,-7.0,-14.0),(1.0,-6.0,-4.0),(-1.0,-3.0,3.0),(-1.0,1.0,7.0),(-3.0,7.0,14.0),(-1.0,4.0,9.0),(6.0,1.0,0.0),(0.0,1.0,1.0),(2.0,2.0,-1.0),(0.0,4.0,-2.0),(-2.0,0.0,-1.0),(1.0,0.0,-2.0),(3.0,-3.0,-9.0),(3.0,-6.0,-14.0),(1.0,-6.0,-5.0),(3.0,0.0,1.0),(4.0,1.0,0.0),(7.0,1.0,1.0),(1.0,3.0,6.0),(-2.0,-8.0,-5.0),(-7.0,-1.0,0.0),(-4.0,0.0,0.0),(-3.0,0.0,0.0),(-2.0,2.0,8.0),(-2.0,6.0,14.0),(1.0,6.0,6.0),(1.0,4.0,-2.0),(2.0,-3.0,-9.0),(3.0,-6.0,-14.0),(4.0,2.0,0.0),(7.0,1.0,1.0),(6.0,0.0,1.0),(6.0,0.0,2.0),(-3.0,7.0,14.0),(-2.0,2.0,9.0),(-1.0,0.0,3.0),(0.0,-1.0,1.0),(-5.0,0.0,0.0),(0.0,-4.0,2.0),(5.0,0.0,0.0),(1.0,-2.0,0.0),(1.0,-2.0,-2.0),(2.0,-3.0,-9.0),(2.0,-6.0,-14.0),(-7.0,0.0,-2.0),(-3.0,2.0,-1.0),(-4.0,-3.0,0.0),(-7.0,0.0,-1.0),(-3.0,2.0,0.0),(-3.0,6.0,14.0),(-1.0,4.0,5.0),(0.0,4.0,-1.0),(0.0,1.0,1.0),(4.0,1.0,-1.0),(2.0,-2.0,-8.0),(7.0,0.0,1.0),(3.0,-1.0,2.0),(2.0,2.0,0.0),(-1.0,2.0,9.0),(-1.0,0.0,2.0),(-2.0,-2.0,1.0),(0.0,-4.0,2.0),(3.0,-1.0,1.0),(0.0,-2.0,-3.0),(1.0,-2.0,-8.0),(-3.0,1.0,-2.0),(-4.0,-2.0,0.0),(-7.0,0.0,0.0),(-4.0,5.0,7.0),(0.0,1.0,2.0),(1.0,4.0,-2.0),(3.0,2.0,0.0),(6.0,0.0,0.0),(1.0,0.0,-2.0),(2.0,-2.0,2.0),(0.0,-5.0,2.0),(-4.0,-1.0,0.0),(-6.0,0.0,0.0),(0.0,1.0,1.0),(0.0,2.0,0.0),(1.0,3.0,-1.0),(5.0,0.0,0.0),(2.0,0.0,0.0),(0.0,-4.0,2.0),(-2.0,-1.0,1.0),(0.0,2.0,0.0),(50.0,-734.0,31.0),(3.0,0.0,0.0),(7.0,0.0,2.0),(0.0,0.0,2.0),(-1.0,0.0,2.0),(-4.0,0.0,0.0),(-6.0,0.0,-3.0),(-1.0,0.0,-2.0),(-4.0,7.0,-6.0),(2.0,0.0,-2.0),(3.0,0.0,0.0),(6.0,0.0,2.0),(0.0,0.0,2.0),(-2.0,0.0,2.0),(-3.0,0.0,0.0),(-6.0,0.0,-2.0),(-10.0,24.0,-16.0),(-1.0,0.0,-1.0),(2.0,0.0,-2.0),(4.0,1.0,0.0),(7.0,0.0,1.0),(0.0,0.0,2.0),(-2.0,0.0,2.0),(-3.0,0.0,0.0),(-9.0,22.0,-9.0),(-7.0,0.0,0.0),(-1.0,0.0,-2.0),(2.0,0.0,-2.0),(3.0,0.0,-1.0),(8.0,1.0,1.0),(0.0,0.0,2.0),(-1.0,0.0,2.0),(-8.0,37.0,3.0),(-3.0,0.0,1.0),(-7.0,-1.0,0.0),(-1.0,0.0,-2.0),(1.0,0.0,-3.0),(3.0,1.0,-1.0),(8.0,0.0,0.0),(1.0,1.0,2.0),(-6.0,31.0,5.0),(-1.0,0.0,3.0),(-3.0,-1.0,1.0),(-7.0,0.0,0.0),(-1.0,0.0,-2.0),(1.0,0.0,-3.0),(3.0,0.0,-1.0),(6.0,1.0,0.0),(-5.0,23.0,5.0),(-13.0,11.0,8.0),(15.0,-12.0,-6.0),(-1.0,-1.0,3.0),(-3.0,-1.0,1.0),(-7.0,0.0,0.0),(-1.0,0.0,-2.0),(1.0,1.0,-3.0),(2.0,1.0,-1.0),(-14.0,11.0,9.0),(-14.0,5.0,13.0),(8.0,0.0,1.0),(3.0,-1.0,0.0),(13.0,-4.0,-13.0),(0.0,-2.0,3.0),(-2.0,-2.0,1.0),(-8.0,0.0,0.0),(-2.0,0.0,-2.0),(-1.0,2.0,-2.0),(-14.0,4.0,13.0),(-13.0,0.0,18.0),(2.0,1.0,0.0),(8.0,1.0,3.0),(3.0,-1.0,2.0),(-3.0,-5.0,11.0),(2.0,-1.0,0.0),(4.0,4.0,-11.0),(11.0,1.0,-19.0),(-1.0,-2.0,0.0),(-8.0,0.0,-1.0),(-3.0,0.0,-1.0),(-14.0,-2.0,18.0),(-4.0,-3.0,10.0),(-1.0,2.0,0.0),(1.0,2.0,0.0),(9.0,0.0,3.0),(4.0,-4.0,0.0),(3.0,4.0,-9.0),(-8.0,-1.0,-2.0),(-4.0,-5.0,10.0),(242.0,-159.0,38.0),(-3.0,0.0,2.0),(-4.0,0.0,0.0),(-26.0,1.0,-16.0),(-30.0,4.0,-21.0),(-31.0,6.0,-17.0),(-19.0,0.0,-6.0),(-3.0,-3.0,-1.0),(4.0,0.0,-4.0),(4.0,3.0,2.0),(19.0,-1.0,6.0),(31.0,-6.0,17.0),(29.0,-4.0,20.0),(25.0,0.0,15.0),(-53.0,108.0,-53.0),(-9.0,26.0,-4.0),(24.0,-62.0,14.0),(13.0,-31.0,18.0),(19.0,-34.0,21.0),(3.0,0.0,2.0),(-2.0,0.0,2.0),(-5.0,0.0,-1.0),(-26.0,1.0,-17.0),(-30.0,6.0,-22.0),(-31.0,5.0,-18.0),(-21.0,0.0,-4.0),(-2.0,-2.0,-3.0),(4.0,0.0,-3.0),(8.0,2.0,1.0),(13.0,0.0,5.0),(3.0,0.0,2.0),(4.0,-1.0,1.0),(23.0,-4.0,13.0),(32.0,-6.0,23.0),(-19.0,36.0,-25.0),(-14.0,28.0,-17.0),(-13.0,34.0,-7.0),(-11.0,29.0,-2.0),(-8.0,22.0,0.0),(26.0,-1.0,15.0),(4.0,-1.0,2.0),(9.0,-22.0,3.0),(11.0,-26.0,4.0),(13.0,-35.0,10.0),(13.0,-31.0,17.0),(-3.0,1.0,2.0),(-5.0,0.0,-1.0),(-26.0,2.0,-22.0),(-30.0,3.0,-22.0),(-31.0,1.0,-13.0),(-21.0,-3.0,-2.0),(-3.0,-2.0,-3.0),(4.0,0.0,-4.0),(8.0,3.0,0.0),(14.0,3.0,4.0),(2.0,0.0,2.0),(5.0,-1.0,1.0),(22.0,-1.0,9.0),(-13.0,24.0,-13.0),(-14.0,34.0,-4.0),(-9.0,31.0,0.0),(-8.0,25.0,2.0),(-16.0,15.0,5.0),(29.0,-2.0,10.0),(25.0,-3.0,14.0),(3.0,0.0,2.0),(-18.0,5.0,8.0),(-24.0,-1.0,16.0),(-2.0,-12.0,12.0),(2.0,-3.0,0.0),(3.0,12.0,-11.0),(24.0,1.0,-16.0),(16.0,-6.0,-7.0),(18.0,-13.0,0.0),(9.0,-21.0,2.0),(10.0,-26.0,5.0),(13.0,-35.0,9.0),(-5.0,0.0,-1.0),(-26.0,-1.0,-21.0),(-30.0,0.0,-19.0),(-31.0,-2.0,-11.0),(-21.0,-2.0,-1.0),(-3.0,-2.0,-4.0),(3.0,0.0,-4.0),(9.0,3.0,1.0),(14.0,2.0,3.0),(3.0,0.0,1.0),(3.0,0.0,0.0),(-13.0,35.0,-1.0),(-8.0,32.0,1.0),(-7.0,25.0,3.0),(-17.0,16.0,8.0),(-14.0,3.0,14.0),(20.0,1.0,0.0),(27.0,-1.0,7.0),(23.0,-3.0,13.0),(-24.0,-2.0,16.0),(-3.0,-12.0,12.0),(4.0,-4.0,0.0),(3.0,12.0,-10.0),(23.0,0.0,-16.0),(16.0,-5.0,-7.0),(17.0,-13.0,0.0),(9.0,-21.0,2.0),(9.0,-26.0,3.0),(-26.0,-2.0,-18.0),(-30.0,0.0,-16.0),(-29.0,0.0,-8.0),(-20.0,-1.0,2.0),(-3.0,-2.0,-5.0),(3.0,0.0,-5.0),(9.0,2.0,0.0),(13.0,1.0,2.0),(1.0,1.0,3.0),(-7.0,31.0,1.0),(-8.0,25.0,3.0),(-16.0,15.0,8.0),(-15.0,1.0,15.0),(-22.0,-9.0,24.0),(4.0,2.0,-1.0),(20.0,2.0,0.0),(26.0,3.0,3.0),(-4.0,-11.0,15.0),(3.0,-4.0,0.0),(5.0,11.0,-14.0),(21.0,4.0,-19.0),(15.0,-6.0,-9.0),(16.0,-14.0,-2.0),(8.0,-21.0,0.0),(-29.0,1.0,-14.0),(-27.0,0.0,-5.0),(-19.0,0.0,3.0),(-3.0,-2.0,-4.0),(2.0,0.0,-6.0),(9.0,2.0,0.0),(11.0,0.0,1.0),(-7.0,25.0,3.0),(-16.0,16.0,9.0),(-16.0,2.0,15.0),(-22.0,-10.0,26.0),(0.0,-6.0,10.0),(25.0,0.0,3.0),(3.0,-4.0,0.0),(5.0,10.0,-14.0),(21.0,8.0,-24.0),(13.0,-5.0,-11.0),(14.0,-13.0,-4.0),(-27.0,0.0,-3.0),(-18.0,-2.0,4.0),(-3.0,-1.0,-4.0),(2.0,2.0,-7.0),(7.0,4.0,0.0),(-17.0,13.0,10.0),(-16.0,0.0,17.0),(-22.0,-7.0,22.0),(-3.0,-6.0,7.0),(-4.0,-3.0,0.0),(4.0,-4.0,1.0),(6.0,2.0,1.0),(14.0,2.0,2.0),(2.0,6.0,-9.0),(22.0,9.0,-24.0),(12.0,-1.0,-13.0),(-16.0,-6.0,6.0),(-4.0,0.0,-5.0),(-1.0,4.0,-5.0),(-15.0,0.0,16.0),(-22.0,-7.0,22.0),(4.0,-4.0,3.0),(5.0,2.0,1.0),(21.0,4.0,-19.0),(-4.0,0.0,-4.0),(215.0,-158.0,97.0),(3.0,1.0,8.0),(-1.0,0.0,0.0),(-5.0,-2.0,-7.0),(-5.0,-1.0,-9.0),(-5.0,0.0,-2.0),(1.0,0.0,-1.0),(5.0,1.0,1.0),(0.0,1.0,0.0),(6.0,1.0,9.0),(3.0,1.0,7.0),(-2.0,0.0,2.0),(-4.0,-2.0,-7.0),(-6.0,-1.0,-9.0),(-5.0,0.0,-2.0),(1.0,0.0,-3.0),(-5.0,6.0,-6.0),(6.0,1.0,2.0),(6.0,2.0,10.0),(3.0,1.0,8.0),(-2.0,0.0,1.0),(-5.0,-2.0,-7.0),(-5.0,-2.0,-10.0),(-6.0,0.0,-2.0),(-16.0,31.0,-28.0),(2.0,0.0,-1.0),(7.0,1.0,4.0),(6.0,3.0,12.0),(5.0,1.0,10.0),(-3.0,0.0,1.0),(-5.0,-2.0,-9.0),(-6.0,-1.0,-12.0),(-9.0,29.0,-16.0),(-6.0,0.0,-6.0),(2.0,0.0,-3.0),(8.0,1.0,6.0),(7.0,3.0,15.0),(4.0,1.0,10.0),(-2.0,0.0,2.0),(-5.0,-1.0,-10.0),(-14.0,33.0,-13.0),(-7.0,-2.0,-14.0),(-7.0,0.0,-5.0),(2.0,0.0,-2.0),(8.0,1.0,5.0),(8.0,2.0,13.0),(5.0,2.0,11.0),(-3.0,0.0,2.0),(-12.0,25.0,-7.0),(-5.0,-1.0,-7.0),(-8.0,-3.0,-12.0),(-7.0,0.0,-5.0),(2.0,0.0,-2.0),(8.0,1.0,4.0),(8.0,3.0,12.0),(5.0,1.0,7.0),(-15.0,20.0,-4.0),(-24.0,13.0,-2.0),(-20.0,3.0,3.0),(-24.0,-3.0,6.0),(-5.0,-12.0,4.0),(3.0,-2.0,0.0),(5.0,11.0,-4.0),(23.0,2.0,-5.0),(19.0,-3.0,0.0),(21.0,-11.0,2.0),(-6.0,-1.0,-8.0),(-8.0,-2.0,-11.0),(-6.0,0.0,-1.0),(2.0,1.0,-3.0),(7.0,1.0,1.0),(7.0,2.0,10.0),(-23.0,13.0,-1.0),(-20.0,5.0,3.0),(-25.0,-2.0,8.0),(-4.0,-13.0,4.0),(3.0,-3.0,0.0),(5.0,12.0,-4.0),(23.0,2.0,-6.0),(18.0,-5.0,-2.0),(-7.0,0.0,-9.0),(-6.0,-1.0,-2.0),(1.0,2.0,-3.0),(5.0,2.0,2.0),(-22.0,6.0,6.0),(-22.0,-3.0,8.0),(-4.0,-12.0,5.0),(2.0,-3.0,0.0),(5.0,12.0,-5.0),(23.0,2.0,-7.0),(-6.0,-3.0,-1.0),(-2.0,2.0,-2.0),(-20.0,-6.0,10.0),(0.0,-2.0,0.0),(-240.0,-174.0,0.0),(0.0,0.0,-2.0),(7.0,0.0,-6.0),(8.0,-1.0,-5.0),(5.0,0.0,0.0),(0.0,1.0,2.0),(-6.0,0.0,0.0),(-6.0,1.0,6.0),(0.0,1.0,1.0),(-7.0,0.0,5.0),(0.0,0.0,-5.0),(7.0,-1.0,-5.0),(7.0,-1.0,-6.0),(6.0,0.0,0.0),(0.0,1.0,3.0),(-4.0,0.0,0.0),(5.0,7.0,-2.0),(-8.0,1.0,7.0),(-6.0,0.0,5.0),(0.0,0.0,-4.0),(6.0,-1.0,-6.0),(7.0,-1.0,-7.0),(6.0,0.0,0.0),(1.0,0.0,3.0),(13.0,31.0,-21.0),(-7.0,1.0,2.0),(-8.0,2.0,10.0),(-7.0,0.0,7.0),(0.0,0.0,-4.0),(6.0,-2.0,-7.0),(9.0,-1.0,-11.0),(7.0,0.0,-2.0),(12.0,30.0,-13.0),(0.0,1.0,4.0),(-9.0,0.0,3.0),(-12.0,2.0,12.0),(-7.0,0.0,6.0),(0.0,0.0,-4.0),(7.0,-1.0,-7.0),(12.0,-1.0,-12.0),(18.0,37.0,-4.0),(9.0,0.0,0.0),(0.0,1.0,4.0),(-9.0,0.0,2.0),(-12.0,1.0,10.0),(-9.0,0.0,6.0),(0.0,0.0,-4.0),(9.0,0.0,-6.0),(11.0,28.0,0.0),(12.0,0.0,-10.0),(9.0,0.0,0.0),(0.0,0.0,4.0),(-9.0,0.0,2.0),(-12.0,1.0,9.0),(-8.0,0.0,4.0),(0.0,0.0,-3.0),(13.0,23.0,0.0),(20.0,15.0,3.0),(-12.0,-17.0,-9.0),(11.0,0.0,-7.0),(7.0,0.0,0.0),(0.0,0.0,4.0),(-7.0,0.0,0.0),(-12.0,0.0,8.0),(-7.0,1.0,5.0),(20.0,15.0,4.0),(16.0,5.0,7.0),(21.0,-1.0,11.0),(4.0,-11.0,5.0),(1.0,4.0,0.0),(-4.0,11.0,-7.0),(-20.0,1.0,-12.0),(6.0,1.0,-6.0),(-15.0,-8.0,-8.0),(9.0,0.0,-6.0),(6.0,-2.0,1.0),(-1.0,-1.0,3.0),(-7.0,1.0,0.0),(-8.0,0.0,7.0),(15.0,5.0,7.0),(21.0,0.0,12.0),(4.0,-11.0,5.0),(1.0,4.0,0.0),(-3.0,12.0,-6.0),(7.0,0.0,-4.0),(-17.0,1.0,-13.0),(4.0,-5.0,0.0),(-2.0,-2.0,1.0),(-6.0,2.0,0.0),(20.0,0.0,13.0),(4.0,-11.0,6.0),(1.0,3.0,0.0),(-1.0,4.0,-6.0),(-1.0,-3.0,0.0),(-111.0,-184.0,-51.0),(1.0,0.0,-2.0),(8.0,0.0,-1.0),(10.0,0.0,-1.0),(4.0,1.0,3.0),(0.0,0.0,1.0),(-5.0,0.0,-2.0),(-10.0,0.0,2.0),(0.0,0.0,1.0),(-7.0,0.0,0.0),(1.0,0.0,-4.0),(8.0,0.0,-1.0),(10.0,0.0,-1.0),(4.0,1.0,3.0),(-1.0,0.0,3.0),(-4.0,0.0,-2.0),(6.0,7.0,0.0),(-11.0,0.0,2.0),(-8.0,0.0,1.0),(1.0,0.0,-4.0),(9.0,0.0,-2.0),(11.0,0.0,-1.0),(4.0,0.0,3.0),(0.0,0.0,2.0),(19.0,33.0,-13.0),(-7.0,0.0,0.0),(-13.0,0.0,4.0),(-9.0,0.0,2.0),(0.0,0.0,-4.0),(11.0,-1.0,-3.0),(13.0,0.0,-3.0),(7.0,0.0,1.0),(14.0,32.0,-6.0),(-2.0,0.0,3.0),(-10.0,0.0,-1.0),(-16.0,0.0,4.0),(-9.0,0.0,1.0),(1.0,0.0,-4.0),(10.0,0.0,-2.0),(17.0,0.0,-3.0),(14.0,39.0,6.0),(8.0,0.0,3.0),(-1.0,0.0,3.0),(-9.0,0.0,-2.0),(-17.0,0.0,2.0),(-10.0,0.0,0.0),(1.0,0.0,-4.0),(12.0,0.0,0.0),(6.0,30.0,5.0),(16.0,0.0,-1.0),(7.0,1.0,4.0),(-1.0,0.0,3.0),(-9.0,-2.0,-2.0),(-15.0,0.0,0.0),(-9.0,0.0,0.0),(1.0,0.0,-3.0),(8.0,24.0,5.0),(14.0,17.0,14.0),(-4.0,-17.0,-14.0),(14.0,1.0,0.0),(6.0,1.0,4.0),(-2.0,-1.0,3.0),(-6.0,-1.0,-3.0),(-15.0,-1.0,0.0),(-9.0,0.0,0.0),(15.0,16.0,14.0),(10.0,7.0,14.0),(17.0,0.0,22.0),(6.0,-9.0,8.0),(0.0,3.0,0.0),(-7.0,10.0,-9.0),(-14.0,0.0,-23.0),(8.0,2.0,-1.0),(-9.0,-9.0,-15.0),(12.0,1.0,0.0),(5.0,-1.0,4.0),(-2.0,-2.0,2.0),(-7.0,0.0,-3.0),(-10.0,-1.0,0.0),(9.0,8.0,15.0),(16.0,0.0,22.0),(5.0,-10.0,8.0),(0.0,3.0,0.0),(-6.0,13.0,-8.0),(7.0,0.0,0.0),(-8.0,0.0,-21.0),(3.0,-5.0,3.0),(-2.0,-2.0,0.0),(-5.0,2.0,-4.0),(12.0,0.0,22.0),(4.0,-10.0,8.0),(0.0,3.0,0.0),(0.0,4.0,-5.0),(0.0,-3.0,0.0),(-72.0,-162.0,-48.0),(0.0,0.0,-3.0),(2.0,0.0,-1.0),(9.0,1.0,1.0),(2.0,0.0,2.0),(0.0,0.0,2.0),(-1.0,0.0,1.0),(-8.0,0.0,-1.0),(8.0,7.0,-4.0),(-3.0,0.0,-2.0),(0.0,0.0,-2.0),(2.0,1.0,-1.0),(8.0,0.0,1.0),(2.0,0.0,2.0),(0.0,0.0,3.0),(0.0,0.0,0.0),(19.0,25.0,-9.0),(-8.0,0.0,-2.0),(-3.0,0.0,-2.0),(0.0,0.0,-3.0),(2.0,0.0,0.0),(8.0,0.0,2.0),(3.0,0.0,2.0),(1.0,1.0,2.0),(7.0,23.0,-4.0),(-2.0,0.0,0.0),(-7.0,0.0,-2.0),(-2.0,0.0,-2.0),(0.0,0.0,-3.0),(2.0,0.0,0.0),(7.0,0.0,2.0),(3.0,0.0,2.0),(3.0,37.0,6.0),(0.0,0.0,3.0),(-2.0,0.0,0.0),(-7.0,0.0,-3.0),(-1.0,0.0,-2.0),(0.0,0.0,-4.0),(2.0,0.0,0.0),(7.0,0.0,3.0),(4.0,32.0,7.0),(1.0,0.0,3.0),(0.0,0.0,4.0),(-2.0,0.0,0.0),(-7.0,0.0,-3.0),(0.0,0.0,-3.0),(0.0,0.0,-4.0),(2.0,0.0,0.0),(4.0,24.0,7.0),(6.0,11.0,12.0),(0.0,-13.0,-9.0),(0.0,0.0,3.0),(0.0,-1.0,3.0),(-3.0,0.0,0.0),(-6.0,1.0,-3.0),(0.0,0.0,-2.0),(0.0,1.0,-3.0),(6.0,12.0,13.0),(4.0,6.0,17.0),(3.0,0.0,0.0),(6.0,-1.0,1.0),(-4.0,-6.0,-16.0),(1.0,-1.0,2.0),(-2.0,-2.0,3.0),(-3.0,0.0,0.0),(-6.0,1.0,-3.0),(0.0,1.0,-2.0),(3.0,4.0,17.0),(2.0,-1.0,23.0),(1.0,-3.0,11.0),(1.0,3.0,0.0),(0.0,4.0,-12.0),(4.0,0.0,0.0),(9.0,0.0,1.0),(1.0,-1.0,0.0),(-5.0,0.0,-22.0),(-2.0,-3.0,1.0),(-4.0,-1.0,0.0),(-6.0,0.0,-1.0),(3.0,0.0,23.0),(0.0,-3.0,11.0),(4.0,4.0,0.0),(9.0,0.0,0.0),(1.0,-1.0,0.0),(-2.0,-2.0,0.0),(0.0,3.0,-10.0),(-3.0,-1.0,0.0),(0.0,-3.0,11.0),(339.0,5.0,171.0),(0.0,0.0,1.0),(-1.0,-1.0,0.0),(-1.0,-2.0,-1.0),(0.0,-2.0,-5.0),(0.0,0.0,-1.0),(0.0,2.0,0.0),(0.0,2.0,1.0),(-4.0,2.0,8.0),(1.0,1.0,3.0),(0.0,0.0,1.0),(-1.0,-2.0,0.0),(-1.0,-1.0,-1.0),(0.0,-1.0,-4.0),(0.0,0.0,0.0),(0.0,2.0,0.0),(-19.0,5.0,15.0),(1.0,2.0,1.0),(2.0,2.0,4.0),(0.0,0.0,2.0),(-1.0,-2.0,0.0),(-1.0,-1.0,-1.0),(-2.0,-3.0,-5.0),(0.0,0.0,0.0),(-14.0,8.0,9.0),(1.0,2.0,0.0),(1.0,2.0,1.0),(1.0,1.0,4.0),(0.0,0.0,1.0),(-1.0,-1.0,0.0),(-1.0,-2.0,-1.0),(-2.0,-2.0,-4.0),(-20.0,15.0,0.0),(0.0,0.0,-2.0),(1.0,2.0,0.0),(0.0,2.0,1.0),(1.0,2.0,4.0),(0.0,0.0,2.0),(0.0,-2.0,0.0),(-1.0,-1.0,-1.0),(-17.0,12.0,-2.0),(0.0,-1.0,-4.0),(0.0,0.0,-2.0),(0.0,1.0,-1.0),(1.0,2.0,1.0),(0.0,2.0,4.0),(0.0,0.0,2.0),(-1.0,-1.0,1.0),(-13.0,9.0,-1.0),(0.0,-1.0,-1.0),(0.0,-2.0,-4.0),(0.0,0.0,-2.0),(0.0,1.0,-1.0),(1.0,1.0,1.0),(0.0,3.0,4.0),(0.0,0.0,2.0),(-9.0,10.0,3.0),(-3.0,11.0,0.0),(1.0,11.0,-3.0),(3.0,4.0,-2.0),(0.0,0.0,2.0),(-4.0,-4.0,4.0),(-1.0,-12.0,1.0),(4.0,-11.0,-1.0),(-1.0,-1.0,0.0),(0.0,-2.0,-5.0),(0.0,0.0,-3.0),(1.0,0.0,-1.0),(0.0,1.0,0.0),(0.0,3.0,5.0),(-4.0,10.0,0.0),(1.0,10.0,-3.0),(3.0,4.0,-2.0),(-1.0,2.0,4.0),(-4.0,-4.0,4.0),(-1.0,-12.0,2.0),(-2.0,-3.0,-6.0),(0.0,-1.0,-3.0),(1.0,0.0,-2.0),(0.0,1.0,0.0),(-1.0,11.0,-4.0),(3.0,3.0,-3.0),(-1.0,2.0,4.0),(-3.0,-4.0,4.0),(0.0,-1.0,-4.0),(0.0,0.0,-2.0),(2.0,3.0,-3.0),(-1.0,0.0,1.0),(-19.0,-34.0,-44.0),(0.0,0.0,-1.0),(-3.0,1.0,2.0),(0.0,2.0,3.0),(0.0,9.0,10.0),(7.0,6.0,8.0),(10.0,9.0,10.0),(6.0,5.0,11.0),(4.0,0.0,3.0),(1.0,-3.0,-3.0),(-3.0,-1.0,-5.0),(-7.0,-5.0,-9.0),(-10.0,-8.0,-9.0),(-5.0,-7.0,-8.0),(4.0,-27.0,-11.0),(11.0,-13.0,-7.0),(-19.0,25.0,16.0),(-2.0,12.0,4.0),(-2.0,-6.0,-11.0),(0.0,0.0,-1.0),(-2.0,1.0,2.0),(0.0,2.0,2.0),(3.0,6.0,10.0),(10.0,7.0,11.0),(8.0,8.0,8.0),(2.0,1.0,1.0),(0.0,1.0,2.0),(4.0,5.0,8.0),(4.0,0.0,4.0),(1.0,-1.0,-5.0),(-4.0,-2.0,-4.0),(-6.0,-6.0,-9.0),(-9.0,-10.0,-9.0),(0.0,-12.0,0.0),(8.0,-11.0,-5.0),(11.0,-12.0,-7.0),(12.0,-12.0,0.0),(-6.0,-9.0,-17.0),(-6.0,-4.0,-16.0),(-9.0,10.0,2.0),(-9.0,13.0,5.0),(-8.0,11.0,7.0),(0.0,-1.0,-1.0),(-2.0,1.0,2.0),(0.0,2.0,4.0),(2.0,7.0,16.0),(8.0,8.0,14.0),(6.0,7.0,9.0),(2.0,1.0,2.0),(1.0,1.0,2.0),(2.0,5.0,6.0),(4.0,0.0,3.0),(1.0,-2.0,-5.0),(-3.0,-1.0,-5.0),(-5.0,-5.0,-5.0),(6.0,-10.0,-1.0),(10.0,-12.0,-4.0),(13.0,-11.0,1.0),(14.0,-13.0,2.0),(-6.0,-11.0,-18.0),(-7.0,-8.0,-22.0),(-10.0,-4.0,-20.0),(-2.0,-1.0,-2.0),(-9.0,11.0,6.0),(-10.0,9.0,3.0),(-7.0,14.0,4.0),(-2.0,0.0,1.0),(0.0,2.0,3.0),(2.0,8.0,17.0),(8.0,8.0,19.0),(5.0,8.0,12.0),(2.0,1.0,2.0),(0.0,0.0,2.0),(2.0,6.0,7.0),(3.0,0.0,3.0),(1.0,0.0,-4.0),(-3.0,0.0,-6.0),(10.0,-10.0,-1.0),(13.0,-10.0,1.0),(16.0,-14.0,2.0),(19.0,-16.0,-1.0),(-6.0,-8.0,-10.0),(-8.0,-11.0,-21.0),(-11.0,-6.0,-25.0),(-12.0,-5.0,-22.0),(-1.0,-2.0,-3.0),(10.0,-9.0,-11.0),(13.0,-12.0,-17.0),(2.0,-3.0,-5.0),(-1.0,-1.0,0.0),(-3.0,3.0,6.0),(-13.0,12.0,17.0),(-10.0,9.0,12.0),(-11.0,14.0,10.0),(-9.0,11.0,6.0),(-9.0,10.0,2.0),(0.0,1.0,2.0),(4.0,7.0,14.0),(7.0,11.0,20.0),(5.0,7.0,14.0),(1.0,2.0,1.0),(1.0,0.0,3.0),(2.0,6.0,9.0),(3.0,2.0,4.0),(1.0,2.0,-3.0),(12.0,-11.0,1.0),(15.0,-14.0,2.0),(20.0,-15.0,-1.0),(13.0,-9.0,-13.0),(-2.0,0.0,-4.0),(-7.0,-8.0,-10.0),(-8.0,-11.0,-24.0),(-13.0,-6.0,-25.0),(-11.0,-5.0,-19.0),(13.0,-12.0,-17.0),(2.0,-3.0,-5.0),(-2.0,-2.0,1.0),(-2.0,3.0,5.0),(-14.0,12.0,17.0),(-9.0,9.0,13.0),(-11.0,14.0,10.0),(-10.0,11.0,5.0),(7.0,5.0,17.0),(7.0,11.0,20.0),(4.0,7.0,14.0),(1.0,2.0,1.0),(1.0,1.0,3.0),(2.0,5.0,8.0),(2.0,2.0,5.0),(16.0,-13.0,1.0),(20.0,-16.0,-2.0),(14.0,-9.0,-13.0),(16.0,-11.0,-24.0),(3.0,-2.0,-9.0),(1.0,3.0,0.0),(-4.0,2.0,8.0),(-3.0,0.0,-3.0),(-8.0,-7.0,-12.0),(-11.0,-9.0,-23.0),(-11.0,-8.0,-20.0),(2.0,-3.0,-5.0),(-2.0,-3.0,1.0),(-2.0,3.0,6.0),(-13.0,11.0,19.0),(-9.0,8.0,15.0),(-13.0,14.0,9.0),(9.0,9.0,24.0),(4.0,8.0,13.0),(1.0,2.0,2.0),(1.0,0.0,2.0),(2.0,4.0,7.0),(20.0,-16.0,-2.0),(12.0,-8.0,-12.0),(15.0,-11.0,-24.0),(5.0,0.0,-8.0),(2.0,3.0,-1.0),(-9.0,-6.0,-12.0),(-12.0,-10.0,-20.0),(-1.0,-2.0,1.0),(-2.0,4.0,10.0),(-11.0,8.0,23.0),(-10.0,10.0,16.0),(6.0,7.0,15.0),(1.0,1.0,2.0),(0.0,0.0,2.0),(12.0,-8.0,-13.0),(15.0,-11.0,-24.0),(0.0,-1.0,-10.0),(-4.0,0.0,5.0),(-12.0,11.0,26.0),(1.0,1.0,1.0),(12.0,-10.0,-24.0),(-98.0,73.0,6.0),(3.0,0.0,-5.0),(2.0,0.0,-4.0),(-4.0,1.0,2.0),(-3.0,0.0,5.0),(-1.0,1.0,5.0),(-6.0,0.0,0.0),(4.0,-2.0,0.0),(0.0,0.0,-1.0),(-2.0,0.0,-1.0),(1.0,0.0,-5.0),(1.0,0.0,-4.0),(-2.0,1.0,2.0),(-2.0,0.0,4.0),(1.0,-11.0,-12.0),(0.0,0.0,7.0),(3.0,0.0,1.0),(1.0,-1.0,-2.0),(-1.0,0.0,-4.0),(2.0,-1.0,-6.0),(1.0,0.0,-4.0),(-2.0,0.0,1.0),(6.0,-11.0,-10.0),(-1.0,0.0,5.0),(0.0,0.0,6.0),(1.0,2.0,3.0),(1.0,0.0,-1.0),(0.0,-2.0,-4.0),(1.0,0.0,-6.0),(1.0,0.0,-5.0),(2.0,-13.0,-11.0),(-1.0,-2.0,2.0),(2.0,0.0,6.0),(2.0,0.0,8.0),(2.0,3.0,2.0),(1.0,1.0,-1.0),(-2.0,-3.0,-4.0),(-1.0,0.0,-8.0),(5.0,-10.0,-7.0),(-2.0,0.0,-6.0),(0.0,-2.0,1.0),(2.0,-1.0,7.0),(2.0,0.0,10.0),(3.0,2.0,4.0),(1.0,1.0,-1.0),(-2.0,-2.0,-5.0),(7.0,-11.0,-6.0),(-4.0,2.0,-11.0),(-2.0,0.0,-6.0),(0.0,-2.0,0.0),(2.0,-2.0,8.0),(4.0,-1.0,11.0),(3.0,2.0,5.0),(1.0,1.0,-1.0),(9.0,-13.0,-11.0),(-4.0,0.0,-5.0),(-4.0,3.0,-11.0),(-2.0,0.0,-5.0),(0.0,-2.0,0.0),(2.0,-2.0,7.0),(4.0,-1.0,11.0),(4.0,0.0,4.0),(11.0,-7.0,-10.0),(11.0,-8.0,-20.0),(3.0,-1.0,-6.0),(0.0,0.0,-1.0),(0.0,1.0,0.0),(0.0,1.0,1.0),(-3.0,2.0,7.0),(-12.0,7.0,18.0),(-3.0,-1.0,-4.0),(-4.0,2.0,-9.0),(-2.0,1.0,-5.0),(0.0,-2.0,0.0),(2.0,-2.0,7.0),(4.0,-2.0,7.0),(13.0,-7.0,-18.0),(2.0,-2.0,-7.0),(1.0,0.0,0.0),(0.0,1.0,0.0),(-1.0,1.0,1.0),(-2.0,3.0,5.0),(-3.0,1.0,-7.0),(-1.0,0.0,-5.0),(0.0,-2.0,0.0),(1.0,-1.0,6.0),(3.0,-2.0,-7.0),(1.0,0.0,-1.0),(0.0,2.0,0.0),(0.0,0.0,0.0),(-1.0,1.0,-5.0),(0.0,-1.0,0.0),(0.0,0.0,-1.0),(0.0,1.0,0.0),(-36.0,122.0,152.0),(4.0,5.0,3.0),(4.0,3.0,2.0),(2.0,0.0,1.0),(-4.0,-4.0,-3.0),(-4.0,-5.0,-2.0),(-3.0,0.0,3.0),(-1.0,1.0,0.0),(-3.0,3.0,3.0),(3.0,5.0,3.0),(4.0,3.0,2.0),(2.0,0.0,0.0),(-3.0,-4.0,-2.0),(-3.0,-4.0,-2.0),(7.0,4.0,18.0),(0.0,-3.0,-4.0),(-3.0,0.0,1.0),(0.0,4.0,3.0),(4.0,5.0,3.0),(4.0,4.0,0.0),(2.0,0.0,0.0),(-2.0,-3.0,-1.0),(9.0,2.0,10.0),(-4.0,-7.0,-2.0),(-1.0,-3.0,-3.0),(-1.0,0.0,2.0),(1.0,4.0,4.0),(4.0,6.0,2.0),(3.0,5.0,0.0),(2.0,1.0,-1.0),(16.0,3.0,10.0),(-3.0,-5.0,-2.0),(-5.0,-8.0,-2.0),(-2.0,-3.0,-3.0),(0.0,0.0,2.0),(3.0,3.0,4.0),(4.0,8.0,2.0),(3.0,5.0,2.0),(20.0,0.0,3.0),(0.0,0.0,-2.0),(-4.0,-6.0,-1.0),(-4.0,-8.0,-1.0),(-3.0,-5.0,-3.0),(0.0,0.0,3.0),(4.0,4.0,4.0),(4.0,8.0,1.0),(26.0,-1.0,3.0),(3.0,7.0,0.0),(0.0,0.0,-2.0),(-4.0,-7.0,0.0),(-5.0,-10.0,0.0),(-3.0,-4.0,-2.0),(0.0,0.0,3.0),(4.0,4.0,3.0),(34.0,0.0,14.0),(4.0,9.0,2.0),(2.0,6.0,0.0),(0.0,0.0,-2.0),(-3.0,-6.0,-1.0),(-4.0,-9.0,-2.0),(-2.0,-5.0,-3.0),(0.0,0.0,2.0),(27.0,1.0,12.0),(2.0,4.0,4.0),(3.0,7.0,0.0),(1.0,5.0,0.0),(-1.0,0.0,-2.0),(-2.0,-5.0,0.0),(-2.0,-8.0,-1.0),(-1.0,-4.0,-3.0),(29.0,5.0,4.0),(7.0,1.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(-1.0,-1.0,0.0),(-6.0,0.0,0.0),(1.0,3.0,2.0),(2.0,6.0,0.0),(1.0,4.0,-1.0),(0.0,0.0,-1.0),(-2.0,-5.0,0.0),(-1.0,-5.0,0.0),(7.0,2.0,1.0),(0.0,0.0,0.0),(0.0,0.0,2.0),(0.0,0.0,0.0),(3.0,5.0,-1.0),(1.0,5.0,0.0),(0.0,0.0,-2.0),(-1.0,-4.0,1.0),(1.0,0.0,1.0),(0.0,0.0,0.0),(1.0,4.0,0.0),(0.0,0.0,-2.0),(-178.0,-23.0,-91.0),(2.0,2.0,3.0),(4.0,1.0,3.0),(2.0,-1.0,0.0),(-4.0,-2.0,-4.0),(-3.0,-1.0,-2.0),(-3.0,0.0,3.0),(-1.0,0.0,0.0),(-1.0,3.0,5.0),(3.0,4.0,6.0),(4.0,0.0,2.0),(1.0,0.0,0.0),(-4.0,-3.0,-4.0),(-2.0,-3.0,-3.0),(6.0,-1.0,17.0),(0.0,-1.0,-5.0),(-3.0,0.0,0.0),(0.0,2.0,5.0),(5.0,4.0,6.0),(4.0,2.0,3.0),(2.0,0.0,0.0),(-2.0,-3.0,-3.0),(7.0,-2.0,10.0),(-4.0,-5.0,-6.0),(-2.0,-2.0,-4.0),(-1.0,0.0,0.0),(1.0,2.0,6.0),(4.0,5.0,5.0),(3.0,4.0,4.0),(3.0,0.0,0.0),(13.0,-2.0,12.0),(-4.0,-4.0,-5.0),(-4.0,-7.0,-7.0),(-1.0,-1.0,-5.0),(-1.0,-1.0,2.0),(2.0,2.0,5.0),(4.0,6.0,7.0),(3.0,3.0,5.0),(19.0,-3.0,8.0),(0.0,1.0,-2.0),(-4.0,-5.0,-5.0),(-5.0,-7.0,-7.0),(-3.0,-2.0,-5.0),(0.0,-1.0,2.0),(3.0,2.0,6.0),(5.0,7.0,7.0),(23.0,-6.0,8.0),(5.0,6.0,3.0),(0.0,1.0,-2.0),(-5.0,-6.0,-4.0),(-6.0,-8.0,-6.0),(-3.0,-4.0,-5.0),(0.0,-1.0,2.0),(4.0,3.0,6.0),(34.0,-5.0,7.0),(5.0,9.0,6.0),(3.0,6.0,3.0),(0.0,1.0,-1.0),(-3.0,-6.0,-4.0),(-5.0,-9.0,-6.0),(-3.0,-3.0,-5.0),(0.0,-1.0,1.0),(29.0,0.0,6.0),(2.0,3.0,5.0),(3.0,7.0,7.0),(2.0,7.0,4.0),(0.0,0.0,0.0),(-2.0,-6.0,-6.0),(-4.0,-8.0,-6.0),(-1.0,-1.0,-4.0),(30.0,3.0,11.0),(7.0,1.0,3.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(-1.0,0.0,0.0),(-6.0,0.0,-3.0),(1.0,1.0,4.0),(3.0,7.0,6.0),(2.0,4.0,4.0),(0.0,1.0,0.0),(-3.0,-5.0,-5.0),(-1.0,-5.0,-5.0),(7.0,0.0,3.0),(0.0,0.0,0.0),(-1.0,-1.0,0.0),(0.0,0.0,0.0),(3.0,6.0,6.0),(2.0,5.0,3.0),(0.0,0.0,0.0),(-2.0,-4.0,-3.0),(1.0,0.0,0.0),(0.0,0.0,1.0),(1.0,4.0,3.0),(0.0,0.0,0.0),(-30.0,-19.0,-35.0),(0.0,0.0,-2.0),(0.0,0.0,-1.0),(1.0,1.0,1.0),(2.0,3.0,6.0),(1.0,0.0,3.0),(0.0,-1.0,0.0),(-1.0,-1.0,-1.0),(-9.0,-3.0,-5.0),(-2.0,-2.0,-5.0),(0.0,0.0,-3.0),(0.0,1.0,0.0),(1.0,1.0,0.0),(2.0,2.0,6.0),(0.0,0.0,2.0),(0.0,0.0,1.0),(-27.0,-5.0,-10.0),(0.0,-1.0,0.0),(-2.0,-3.0,-5.0),(0.0,0.0,-2.0),(0.0,0.0,-2.0),(1.0,1.0,1.0),(1.0,3.0,5.0),(0.0,0.0,2.0),(-21.0,0.0,0.0),(0.0,-1.0,1.0),(-1.0,-1.0,-1.0),(-1.0,-2.0,-4.0),(0.0,0.0,-2.0),(0.0,1.0,-1.0),(0.0,1.0,0.0),(1.0,3.0,4.0),(-28.0,8.0,-3.0),(0.0,0.0,3.0),(-1.0,-1.0,1.0),(0.0,-1.0,0.0),(-1.0,-1.0,-5.0),(0.0,0.0,-3.0),(0.0,1.0,-1.0),(0.0,1.0,0.0),(-21.0,10.0,-9.0),(0.0,0.0,4.0),(0.0,0.0,3.0),(0.0,0.0,1.0),(0.0,-2.0,-1.0),(-1.0,-1.0,-4.0),(0.0,0.0,-3.0),(0.0,1.0,-1.0),(-13.0,7.0,-5.0),(0.0,1.0,0.0),(0.0,1.0,5.0),(0.0,0.0,2.0),(-1.0,-1.0,0.0),(-1.0,-1.0,0.0),(0.0,-1.0,-4.0),(0.0,0.0,-2.0),(-10.0,4.0,-9.0),(-8.0,4.0,-11.0),(-5.0,4.0,-17.0),(1.0,2.0,-7.0),(1.0,0.0,2.0),(0.0,-2.0,7.0),(6.0,-5.0,16.0),(7.0,-2.0,10.0),(1.0,1.0,1.0),(1.0,1.0,4.0),(-1.0,0.0,2.0),(-2.0,-1.0,0.0),(-1.0,-1.0,-1.0),(-1.0,-1.0,-4.0),(-7.0,4.0,-11.0),(-5.0,5.0,-17.0),(0.0,2.0,-7.0),(4.0,0.0,2.0),(0.0,-2.0,7.0),(5.0,-3.0,16.0),(1.0,2.0,5.0),(0.0,0.0,1.0),(-2.0,-1.0,0.0),(-2.0,0.0,-2.0),(-3.0,6.0,-16.0),(1.0,2.0,-7.0),(4.0,0.0,3.0),(-1.0,-1.0,7.0),(0.0,0.0,0.0),(-2.0,0.0,0.0),(2.0,2.0,-7.0),(1.0,0.0,0.0),(-589.0,-69.0,-5.0),(9.0,-23.0,53.0),(-3.0,8.0,62.0),(33.0,24.0,-33.0),(-2.0,12.0,5.0),(-40.0,-28.0,43.0),(-1.0,-14.0,-11.0),(-13.0,-1.0,-1.0),(3.0,-8.0,-72.0),(-13.0,22.0,-5.0),(28.0,-21.0,9.0),(-12.0,25.0,-55.0),(-1.0,25.0,-31.0),(9.0,4.0,7.0),(36.0,27.0,23.0),(2.0,-23.0,32.0),(-1.0,13.0,3.0),(-9.0,12.0,19.0),(-16.0,24.0,14.0),(-9.0,-13.0,65.0),(19.0,-26.0,-16.0),(-42.0,-17.0,32.0),(-34.0,-3.0,-5.0),(20.0,-32.0,-14.0),(0.0,0.0,-26.0),(10.0,-3.0,-5.0),(-1.0,16.0,-41.0),(-7.0,29.0,-55.0),(1.0,-24.0,-6.0),(9.0,-11.0,0.0),(0.0,26.0,-32.0),(14.0,47.0,-16.0),(15.0,3.0,4.0),(10.0,0.0,3.0),(20.0,18.0,-6.0),(24.0,6.0,8.0),(-2.0,8.0,11.0),(3.0,-7.0,5.0),(-25.0,-32.0,32.0),(-5.0,19.0,8.0),(21.0,243.0,129.0),(-1.0,-26.0,-2.0),(-7.0,-11.0,-3.0),(-1.0,-15.0,0.0),(-12.0,-23.0,-4.0),(-13.0,-22.0,-6.0),(-13.0,-8.0,-3.0),(-1.0,-13.0,0.0),(-12.0,-20.0,-4.0),(8.0,-45.0,0.0),(2.0,9.0,-54.0),(4.0,-54.0,-16.0),(7.0,102.0,38.0),(10.0,18.0,11.0),(0.0,12.0,2.0),(12.0,7.0,4.0),(13.0,20.0,4.0),(12.0,23.0,5.0),(0.0,13.0,0.0),(7.0,9.0,2.0),(4.0,22.0,1.0),(609.0,-258.0,114.0),(-18.0,-12.0,49.0),(25.0,4.0,-61.0),(-10.0,-23.0,1.0),(28.0,18.0,-62.0),(9.0,21.0,-37.0),(-1.0,-8.0,43.0),(-5.0,24.0,4.0),(1.0,340.0,77.0),(-3.0,-26.0,0.0),(10.0,-22.0,6.0),(24.0,-39.0,-60.0),(-9.0,13.0,-5.0),(1.0,12.0,-6.0),(-15.0,46.0,93.0),(-14.0,37.0,-39.0),(6.0,-7.0,40.0),(-34.0,1.0,34.0),(18.0,-31.0,3.0),(1.0,-25.0,2.0),(-32.0,6.0,59.0),(51.0,-6.0,-101.0),(11.0,-18.0,5.0),(16.0,-40.0,0.0),(16.0,-14.0,-84.0),(-7.0,-19.0,-31.0),(-10.0,26.0,-2.0),(-11.0,9.0,-1.0),(0.0,10.0,-6.0),(-8.0,26.0,1.0),(0.0,27.0,29.0),(-11.0,27.0,1.0),(-15.0,41.0,42.0),(0.0,3.0,48.0),(-41.0,4.0,31.0),(-23.0,-1.0,66.0),(14.0,-26.0,0.0),(13.0,-29.0,5.0),(-50.0,-42.0,40.0),(14.0,-7.0,-4.0),(11.0,-17.0,1.0),(44.0,21.0,-34.0),(33.0,-3.0,-60.0),(18.0,-45.0,1.0),(-3.0,-77.0,2.0),(16.0,13.0,-43.0),(17.0,5.0,-79.0),(-10.0,0.0,-41.0),(-1.0,-29.0,-4.0),(-7.0,31.0,-23.0),(-3.0,30.0,1.0),(-8.0,20.0,0.0),(-10.0,8.0,0.0),(0.0,10.0,-8.0),(-5.0,24.0,2.0),(-5.0,23.0,1.0),(4.0,14.0,26.0),(-12.0,13.0,0.0),(-1.0,24.0,26.0),(-19.0,36.0,41.0),(-3.0,7.0,47.0),(-42.0,4.0,33.0),(-53.0,15.0,101.0),(-28.0,-39.0,22.0),(8.0,-11.0,2.0),(33.0,-39.0,-15.0),(-22.0,-32.0,1.0),(17.0,-25.0,3.0),(10.0,-13.0,-5.0),(4.0,-19.0,5.0),(22.0,-22.0,2.0),(22.0,23.0,0.0),(46.0,13.0,-38.0),(-9.0,-58.0,11.0),(-1.0,-67.0,-6.0),(36.0,-17.0,-65.0),(23.0,14.0,-51.0),(12.0,2.0,-60.0),(-21.0,-15.0,-62.0),(-4.0,-24.0,-15.0),(6.0,-25.0,37.0),(-9.0,-24.0,56.0),(0.0,-19.0,-36.0),(-24.0,-16.0,68.0),(-36.0,-27.0,40.0),(-16.0,0.0,29.0),(-11.0,-11.0,-18.0),(-11.0,-1.0,-9.0),(33.0,-7.0,-81.0),(29.0,19.0,-61.0),(9.0,22.0,-36.0),(-14.0,39.0,-27.0),(16.0,0.0,2.0),(4.0,9.0,0.0),(15.0,-39.0,35.0),(-5.0,22.0,-2.0),(20.0,10.0,13.0),(-9.0,27.0,-25.0),(-12.0,8.0,-18.0),(1.0,6.0,4.0),(2.0,19.0,10.0),(2.0,14.0,8.0),(15.0,49.0,5.0),(-10.0,-26.0,-12.0),(4.0,28.0,3.0),(1.0,30.0,4.0),(-5.0,27.0,0.0),(-14.0,6.0,0.0),(-3.0,6.0,-9.0),(-1.0,25.0,2.0),(-2.0,25.0,1.0),(-10.0,9.0,4.0),(2.0,22.0,11.0),(1.0,14.0,-5.0),(2.0,20.0,23.0),(-9.0,26.0,0.0),(9.0,-8.0,27.0),(-19.0,29.0,48.0),(-17.0,14.0,43.0),(-7.0,13.0,-5.0),(-22.0,6.0,36.0),(2.0,-14.0,6.0),(-73.0,17.0,120.0),(-27.0,-43.0,6.0),(-13.0,-22.0,-8.0),(9.0,-20.0,-1.0),(2.0,-16.0,6.0),(-6.0,-19.0,-41.0),(16.0,-21.0,10.0),(19.0,-22.0,5.0),(8.0,-18.0,-10.0),(3.0,-19.0,1.0),(20.0,-17.0,12.0),(0.0,-65.0,-6.0),(26.0,6.0,22.0),(22.0,18.0,0.0),(-2.0,-61.0,-4.0),(46.0,-23.0,-85.0),(33.0,0.0,-70.0),(23.0,4.0,-60.0),(-12.0,-25.0,62.0),(-23.0,-7.0,67.0),(-6.0,-29.0,-29.0),(-52.0,-37.0,52.0),(-29.0,0.0,-11.0),(-2.0,-20.0,-31.0),(4.0,-2.0,-23.0),(-15.0,14.0,-61.0),(45.0,-26.0,-11.0),(27.0,18.0,-59.0),(8.0,21.0,-33.0),(-13.0,37.0,-30.0),(-17.0,14.0,-15.0),(1.0,6.0,-1.0),(-25.0,2.0,-3.0),(31.0,-7.0,6.0),(6.0,3.0,5.0),(7.0,8.0,0.0),(20.0,1.0,4.0),(0.0,20.0,8.0),(2.0,18.0,8.0),(1.0,25.0,-2.0),(1.0,29.0,1.0),(-9.0,21.0,-3.0),(-9.0,11.0,3.0),(-3.0,8.0,-7.0),(-5.0,22.0,1.0),(-3.0,17.0,1.0),(-8.0,11.0,6.0),(0.0,11.0,-7.0),(28.0,47.0,12.0),(-6.0,32.0,2.0),(4.0,12.0,13.0),(-17.0,-26.0,-2.0),(-23.0,-16.0,-12.0),(-46.0,139.0,41.0),(-18.0,22.0,-6.0),(-14.0,4.0,-4.0),(-7.0,11.0,-10.0),(-93.0,103.0,50.0),(-8.0,-3.0,-5.0),(22.0,-2.0,13.0),(25.0,-31.0,-42.0),(22.0,-15.0,10.0),(19.0,-24.0,8.0),(4.0,-14.0,6.0),(10.0,-3.0,7.0),(19.0,-26.0,9.0),(24.0,-36.0,17.0),(24.0,-19.0,-37.0),(-6.0,-14.0,-29.0),(9.0,-43.0,-4.0),(-20.0,47.0,-11.0),(-24.0,27.0,0.0),(-18.0,33.0,5.0),(-18.0,2.0,-2.0),(-13.0,7.0,-6.0),(-18.0,46.0,2.0),(-31.0,22.0,-1.0),(-18.0,19.0,3.0),(21.0,0.0,16.0),(-10.0,0.0,-2.0),(-7.0,8.0,-4.0),(-24.0,25.0,39.0),(-14.0,5.0,-10.0),(-48.0,-8.0,-8.0),(-14.0,-5.0,-8.0),(-14.0,6.0,-7.0),(-50.0,-6.0,-5.0),(-44.0,5.0,-15.0),(4.0,-13.0,21.0),(-13.0,-7.0,1.0),(51.0,0.0,4.0),(35.0,8.0,12.0),(15.0,-6.0,8.0),(11.0,5.0,7.0),(41.0,9.0,14.0),(24.0,-3.0,4.0),(5.0,-6.0,3.0),(10.0,1.0,5.0),(18.0,0.0,2.0),(29.0,-9.0,5.0),(11.0,-17.0,8.0),(7.0,-10.0,-1.0),(12.0,-3.0,5.0),(12.0,-19.0,8.0),(21.0,-34.0,12.0),(8.0,-41.0,4.0),(42.0,-42.0,-33.0),(24.0,-22.0,-42.0),(0.0,-42.0,-7.0),(-4.0,-25.0,-3.0),(-1.0,-3.0,2.0),(1.0,-16.0,-40.0),(4.0,18.0,2.0),(-18.0,4.0,-12.0),(3.0,38.0,8.0),(-29.0,40.0,-1.0),(-19.0,39.0,4.0),(-16.0,0.0,2.0),(-15.0,0.0,-8.0),(-17.0,42.0,5.0),(-32.0,20.0,-1.0),(-18.0,22.0,1.0),(-11.0,0.0,4.0),(-4.0,42.0,0.0),(-9.0,4.0,-4.0),(4.0,6.0,7.0),(-65.0,28.0,-7.0),(-21.0,-7.0,-3.0),(-19.0,1.0,-7.0),(-58.0,0.0,-6.0),(-50.0,-7.0,-16.0),(-23.0,-3.0,0.0),(31.0,1.0,31.0),(-13.0,6.0,1.0),(-46.0,7.0,-12.0),(-20.0,-8.0,0.0),(-4.0,-25.0,-42.0),(16.0,19.0,65.0),(20.0,1.0,6.0),(42.0,-9.0,7.0),(14.0,-11.0,26.0),(13.0,-1.0,-5.0),(13.0,5.0,4.0),(20.0,-4.0,3.0),(22.0,5.0,8.0),(11.0,-5.0,1.0),(9.0,1.0,11.0),(23.0,-9.0,14.0),(30.0,1.0,1.0),(13.0,-3.0,-1.0),(13.0,0.0,5.0),(26.0,8.0,0.0),(0.0,-36.0,-1.0),(46.0,9.0,-1.0),(10.0,-27.0,4.0),(13.0,0.0,0.0),(6.0,0.0,10.0),(12.0,-27.0,5.0),(0.0,-52.0,0.0),(30.0,-28.0,18.0),(41.0,-37.0,-35.0),(-6.0,-31.0,-2.0),(0.0,-5.0,2.0),(39.0,6.0,-49.0),(23.0,17.0,4.0),(21.0,41.0,10.0),(-22.0,11.0,39.0),(-30.0,36.0,37.0),(-19.0,13.0,40.0),(-38.0,41.0,85.0),(-20.0,-25.0,42.0),(-30.0,-34.0,11.0),(-5.0,-13.0,-4.0),(-29.0,-37.0,-28.0),(1.0,-28.0,5.0),(28.0,-25.0,-22.0),(-15.0,-51.0,-44.0),(3.0,-19.0,0.0),(14.0,-26.0,6.0),(16.0,-23.0,2.0),(11.0,-5.0,0.0),(4.0,-15.0,0.0),(14.0,-17.0,5.0),(4.0,-51.0,-9.0),(2.0,-52.0,-1.0),(16.0,22.0,47.0),(23.0,0.0,28.0),(54.0,-23.0,-103.0),(37.0,5.0,-80.0),(8.0,6.0,-60.0),(-9.0,-22.0,60.0),(-52.0,-23.0,148.0),(-32.0,0.0,-9.0),(-17.0,8.0,-73.0),(-3.0,-25.0,-30.0),(0.0,-18.0,-36.0),(24.0,16.0,-67.0),(2.0,-12.0,-3.0),(11.0,21.0,-35.0),(-11.0,30.0,-51.0),(-3.0,8.0,11.0),(-1.0,3.0,-5.0),(5.0,6.0,-2.0),(32.0,-2.0,4.0),(0.0,13.0,4.0),(0.0,18.0,5.0),(0.0,26.0,-4.0),(0.0,29.0,1.0),(-12.0,19.0,-3.0),(-3.0,12.0,5.0),(-1.0,10.0,-5.0),(-7.0,20.0,1.0),(-3.0,11.0,2.0),(-3.0,7.0,6.0),(-1.0,5.0,-5.0),(-1.0,13.0,0.0),(31.0,34.0,9.0),(-20.0,5.0,2.0),(-15.0,-6.0,1.0),(-4.0,11.0,-3.0),(-22.0,26.0,-1.0),(-5.0,31.0,15.0),(-17.0,36.0,1.0),(-18.0,-1.0,-1.0),(-13.0,4.0,-11.0),(-18.0,40.0,10.0),(-32.0,20.0,2.0),(-18.0,19.0,2.0),(-11.0,-2.0,1.0),(-14.0,2.0,-4.0),(-1.0,45.0,5.0),(-18.0,26.0,2.0),(-47.0,15.0,-2.0),(-17.0,0.0,1.0),(-16.0,1.0,-6.0),(-60.0,-4.0,-9.0),(-58.0,-3.0,-15.0),(-17.0,-3.0,0.0),(-12.0,0.0,-9.0),(-7.0,38.0,0.0),(-13.0,-23.0,-13.0),(-36.0,-17.0,-8.0),(-9.0,-4.0,0.0),(16.0,11.0,7.0),(8.0,25.0,41.0),(7.0,-7.0,22.0),(-9.0,1.0,1.0),(12.0,-26.0,20.0),(15.0,1.0,1.0),(11.0,4.0,7.0),(27.0,-2.0,12.0),(0.0,-36.0,0.0),(27.0,12.0,-1.0),(13.0,2.0,-7.0),(14.0,0.0,7.0),(19.0,-3.0,2.0),(22.0,4.0,7.0),(11.0,0.0,0.0),(9.0,-3.0,13.0),(25.0,-10.0,15.0),(29.0,-2.0,1.0),(16.0,5.0,-2.0),(11.0,2.0,3.0),(0.0,-51.0,-1.0),(27.0,1.0,0.0),(42.0,10.0,-1.0),(13.0,-27.0,5.0),(13.0,0.0,2.0),(6.0,-1.0,8.0),(-1.0,-39.0,1.0),(15.0,-25.0,7.0),(22.0,-23.0,13.0),(33.0,-31.0,-28.0),(-1.0,-5.0,1.0),(22.0,6.0,-5.0),(23.0,12.0,2.0),(-23.0,40.0,38.0),(-24.0,25.0,47.0),(-79.0,69.0,126.0),(-20.0,-63.0,-36.0),(3.0,-72.0,-56.0),(2.0,-32.0,6.0),(3.0,-30.0,-4.0),(38.0,-37.0,-62.0),(8.0,-9.0,2.0),(0.0,-13.0,1.0),(15.0,-21.0,1.0),(15.0,-19.0,2.0),(13.0,-4.0,4.0),(2.0,-13.0,2.0),(13.0,-16.0,1.0),(-1.0,-41.0,-3.0),(8.0,-47.0,-10.0),(28.0,2.0,28.0),(36.0,7.0,-83.0),(5.0,8.0,-57.0),(-7.0,-23.0,57.0),(-47.0,-4.0,-5.0),(-3.0,-26.0,-24.0),(8.0,24.0,-45.0),(0.0,-19.0,-11.0),(-13.0,23.0,-41.0),(0.0,31.0,0.0),(3.0,-4.0,-4.0),(5.0,2.0,-5.0),(0.0,20.0,4.0),(0.0,23.0,-2.0),(1.0,25.0,1.0),(-9.0,16.0,0.0),(0.0,11.0,4.0),(-6.0,6.0,-5.0),(-6.0,19.0,2.0),(-1.0,10.0,1.0),(0.0,6.0,7.0),(-5.0,3.0,-4.0),(-2.0,10.0,0.0),(-12.0,19.0,1.0),(27.0,18.0,0.0),(-21.0,29.0,-4.0),(-13.0,33.0,-1.0),(0.0,25.0,16.0),(-16.0,0.0,-3.0),(-12.0,7.0,-13.0),(-18.0,39.0,9.0),(-31.0,18.0,-1.0),(-18.0,18.0,8.0),(-13.0,-1.0,3.0),(-13.0,4.0,-6.0),(-26.0,25.0,8.0),(-3.0,30.0,11.0),(-41.0,14.0,0.0),(-17.0,-2.0,2.0),(-16.0,1.0,-7.0),(-61.0,-4.0,-7.0),(-56.0,-2.0,-16.0),(-17.0,-3.0,0.0),(-14.0,0.0,-9.0),(-34.0,-17.0,-15.0),(-9.0,42.0,0.0),(-10.0,-27.0,-8.0),(-14.0,-1.0,0.0),(-8.0,0.0,-7.0),(-2.0,42.0,5.0),(17.0,13.0,8.0),(6.0,27.0,45.0),(-13.0,-5.0,1.0),(4.0,-5.0,14.0),(6.0,-18.0,15.0),(0.0,-37.0,0.0),(24.0,-2.0,10.0),(16.0,-1.0,3.0),(9.0,-5.0,8.0),(0.0,-51.0,0.0),(26.0,7.0,10.0),(30.0,13.0,-1.0),(12.0,2.0,-6.0),(13.0,0.0,6.0),(21.0,-3.0,3.0),(20.0,4.0,7.0),(13.0,0.0,0.0),(9.0,-2.0,12.0),(22.0,-11.0,14.0),(31.0,-4.0,2.0),(14.0,3.0,-4.0),(0.0,-37.0,0.0),(14.0,0.0,4.0),(25.0,0.0,0.0),(44.0,10.0,-2.0),(11.0,-25.0,5.0),(14.0,0.0,2.0),(0.0,-39.0,-7.0),(-31.0,-29.0,-10.0),(38.0,24.0,20.0),(13.0,-15.0,9.0),(44.0,-21.0,21.0),(-19.0,6.0,38.0),(-33.0,-32.0,-11.0),(4.0,-36.0,0.0),(-4.0,0.0,-46.0),(2.0,-19.0,0.0),(8.0,-7.0,1.0),(1.0,-13.0,0.0),(14.0,-19.0,1.0),(14.0,-16.0,2.0),(14.0,-4.0,2.0),(2.0,-12.0,-2.0),(16.0,-16.0,-6.0),(24.0,-41.0,-14.0),(11.0,-52.0,-16.0),(-3.0,-1.0,-40.0),(-13.0,23.0,-59.0),(0.0,24.0,-3.0),(1.0,25.0,1.0),(-8.0,18.0,-1.0),(1.0,11.0,3.0),(-8.0,6.0,-3.0),(-6.0,18.0,2.0),(-1.0,9.0,2.0),(3.0,8.0,4.0),(-7.0,2.0,-2.0),(-2.0,9.0,0.0),(-23.0,37.0,0.0),(3.0,10.0,-8.0),(-17.0,27.0,-2.0),(-8.0,14.0,3.0),(12.0,26.0,-3.0),(-13.0,7.0,-9.0),(-17.0,32.0,2.0),(-31.0,20.0,0.0),(-16.0,16.0,4.0),(-10.0,-1.0,3.0),(-14.0,6.0,-3.0),(-25.0,19.0,9.0),(-35.0,12.0,5.0),(-6.0,31.0,9.0),(-16.0,-3.0,1.0),(-17.0,1.0,-4.0),(-61.0,-5.0,-4.0),(-57.0,-1.0,-20.0),(-16.0,-3.0,-2.0),(-14.0,1.0,-9.0),(-32.0,-16.0,-15.0),(-13.0,-24.0,-14.0),(-7.0,25.0,13.0),(-16.0,-3.0,-1.0),(-9.0,1.0,-6.0),(-12.0,-19.0,-7.0),(-2.0,41.0,4.0),(-2.0,45.0,3.0),(10.0,22.0,16.0),(-54.0,-58.0,2.0),(-14.0,-4.0,0.0),(22.0,21.0,-4.0),(20.0,24.0,2.0),(11.0,37.0,54.0),(0.0,-37.0,0.0),(-3.0,-56.0,0.0),(39.0,-9.0,20.0),(22.0,0.0,11.0),(14.0,-1.0,2.0),(0.0,-39.0,0.0),(12.0,-2.0,10.0),(26.0,10.0,10.0),(29.0,11.0,-2.0),(13.0,4.0,-3.0),(12.0,-1.0,4.0),(20.0,-3.0,4.0),(21.0,5.0,6.0),(14.0,1.0,1.0),(8.0,-4.0,11.0),(24.0,-10.0,14.0),(30.0,-8.0,1.0),(0.0,-32.0,-6.0),(15.0,2.0,-3.0),(14.0,-3.0,5.0),(26.0,-1.0,-1.0),(44.0,8.0,-5.0),(12.0,-19.0,8.0),(-26.0,-29.0,-7.0),(12.0,-12.0,8.0),(14.0,-12.0,9.0),(20.0,-21.0,13.0),(24.0,-16.0,-131.0),(-5.0,16.0,0.0),(-13.0,8.0,-6.0),(2.0,10.0,-6.0),(-20.0,27.0,-3.0),(-28.0,19.0,0.0),(-18.0,12.0,3.0),(-7.0,10.0,6.0),(-12.0,4.0,-3.0),(-17.0,11.0,4.0),(-33.0,11.0,0.0),(-18.0,6.0,10.0),(0.0,24.0,1.0),(-16.0,1.0,-6.0),(-62.0,-7.0,-2.0),(-56.0,1.0,-21.0),(-16.0,-2.0,-1.0),(-13.0,0.0,-11.0),(-30.0,-15.0,-17.0),(-15.0,-20.0,-17.0),(-14.0,-5.0,0.0),(-9.0,24.0,14.0),(-9.0,1.0,-8.0),(-11.0,-21.0,-14.0),(-28.0,-19.0,-9.0),(-6.0,27.0,17.0),(-3.0,41.0,8.0),(-3.0,42.0,2.0),(-13.0,-26.0,-7.0),(-14.0,-14.0,5.0),(-16.0,-6.0,-3.0),(-20.0,-24.0,0.0),(15.0,29.0,34.0),(15.0,57.0,52.0),(-29.0,-35.0,1.0),(48.0,56.0,-4.0),(13.0,3.0,0.0),(8.0,10.0,5.0),(0.0,-49.0,-4.0),(-2.0,-56.0,-1.0),(-1.0,-42.0,0.0),(16.0,29.0,1.0),(38.0,-8.0,21.0),(24.0,2.0,10.0),(0.0,-38.0,-4.0),(15.0,2.0,1.0),(11.0,-1.0,10.0),(26.0,10.0,13.0),(29.0,9.0,-3.0),(14.0,6.0,-5.0),(11.0,-4.0,7.0),(22.0,-1.0,2.0),(19.0,4.0,7.0),(14.0,3.0,0.0),(8.0,-6.0,11.0),(23.0,-7.0,14.0),(0.0,-37.0,-11.0),(27.0,-2.0,-2.0),(13.0,2.0,-3.0),(12.0,-3.0,4.0),(23.0,0.0,0.0),(29.0,2.0,1.0),(42.0,-21.0,-102.0),(-28.0,19.0,0.0),(-16.0,11.0,2.0),(-6.0,11.0,5.0),(-11.0,2.0,0.0),(-19.0,13.0,5.0),(-31.0,8.0,0.0),(-15.0,9.0,6.0),(-18.0,-5.0,-6.0),(-3.0,16.0,-7.0),(-57.0,-6.0,-4.0),(-53.0,0.0,-18.0),(-19.0,-2.0,0.0),(-11.0,-7.0,-15.0),(-28.0,-14.0,-12.0),(-14.0,-13.0,-11.0),(-11.0,-5.0,0.0),(-2.0,-8.0,-9.0),(-16.0,31.0,-5.0),(-13.0,-18.0,-10.0),(-27.0,-22.0,-11.0),(-11.0,-33.0,-8.0),(-9.0,19.0,6.0),(-5.0,26.0,17.0),(-4.0,40.0,11.0),(-1.0,39.0,6.0),(-17.0,-10.0,0.0),(-17.0,-3.0,-5.0),(-12.0,-35.0,-12.0),(-19.0,-29.0,-7.0),(-17.0,-5.0,10.0),(-9.0,18.0,18.0),(12.0,27.0,39.0),(-8.0,-32.0,2.0),(26.0,52.0,44.0),(37.0,36.0,0.0),(16.0,28.0,0.0),(10.0,-2.0,-7.0),(-2.0,-55.0,0.0),(-1.0,-42.0,-1.0),(3.0,-40.0,-4.0),(29.0,-30.0,4.0),(-18.0,36.0,-1.0),(16.0,20.0,-1.0),(37.0,-6.0,23.0),(14.0,-32.0,-6.0),(21.0,2.0,10.0),(13.0,4.0,1.0),(9.0,-1.0,9.0),(23.0,5.0,13.0),(70.0,2.0,9.0),(3.0,5.0,-13.0),(10.0,39.0,-58.0),(-52.0,0.0,-20.0),(-17.0,5.0,-1.0),(-13.0,-11.0,-12.0),(-27.0,-11.0,-12.0),(-14.0,-15.0,-12.0),(-14.0,-3.0,-4.0),(-2.0,-11.0,-7.0),(-16.0,-12.0,-8.0),(-2.0,10.0,-6.0),(-24.0,-22.0,-11.0),(-19.0,-30.0,-3.0),(-16.0,-11.0,0.0),(-11.0,26.0,-7.0),(-9.0,19.0,10.0),(-5.0,28.0,13.0),(-4.0,44.0,9.0),(-14.0,0.0,-9.0),(-13.0,-41.0,-10.0),(-25.0,-45.0,-9.0),(-19.0,-1.0,10.0),(-9.0,28.0,24.0),(1.0,-45.0,-5.0),(7.0,31.0,49.0),(27.0,48.0,42.0),(36.0,30.0,-1.0),(16.0,27.0,0.0),(0.0,-43.0,0.0),(2.0,-45.0,-5.0),(32.0,-30.0,5.0),(15.0,13.0,-2.0),(12.0,11.0,-2.0),(1.0,-24.0,-103.0),(-21.0,-29.0,-4.0),(-16.0,-11.0,0.0),(-3.0,-16.0,-2.0),(-27.0,16.0,117.0),(22.0,-6.0,-127.0),(-19.0,35.0,-8.0),(-12.0,23.0,14.0),(-5.0,30.0,12.0),(-13.0,-40.0,-10.0),(-16.0,-40.0,-10.0),(-22.0,-8.0,4.0),(6.0,-16.0,0.0),(-14.0,20.0,29.0),(7.0,19.0,51.0),(0.0,-4.0,3.0),(7.0,12.0,4.0),(21.0,39.0,35.0),(28.0,25.0,-2.0),(0.0,-37.0,-2.0),(32.0,-28.0,5.0),(-41.0,-15.0,30.0),(-22.0,33.0,35.0),(-1.0,-35.0,3.0),(12.0,-24.0,13.0),(-7.0,-6.0,-2.0),(0.0,-21.0,-2.0),(-13.0,-28.0,-4.0),(-14.0,-26.0,-5.0),(-11.0,-6.0,-4.0),(0.0,-17.0,-3.0),(-13.0,-20.0,-3.0),(9.0,-56.0,-8.0),(10.0,-55.0,-2.0),(0.0,-19.0,-52.0),(17.0,14.0,-92.0),(-45.0,2.0,-15.0),(-9.0,-28.0,44.0),(-21.0,-12.0,116.0),(-35.0,-1.0,-8.0),(-20.0,15.0,-50.0),(28.0,-38.0,-15.0),(24.0,-29.0,-29.0),(-1.0,22.0,-58.0),(3.0,24.0,-35.0),(23.0,-5.0,-1.0),(-2.0,-24.0,-1.0),(20.0,51.0,-22.0),(28.0,19.0,1.0),(7.0,-8.0,2.0),(8.0,0.0,-1.0),(4.0,7.0,0.0),(26.0,7.0,7.0),(1.0,3.0,9.0),(-3.0,18.0,5.0),(0.0,5.0,5.0),(-2.0,9.0,1.0),(-1.0,26.0,-3.0),(-4.0,25.0,1.0),(6.0,18.0,1.0),(-4.0,11.0,2.0),(9.0,8.0,1.0),(2.0,19.0,3.0),(0.0,9.0,3.0),(-5.0,7.0,2.0),(7.0,3.0,0.0),(1.0,10.0,2.0),(18.0,40.0,9.0),(-4.0,9.0,-8.0),(-17.0,28.0,-9.0),(-12.0,20.0,6.0),(-20.0,-30.0,-6.0),(-3.0,-10.0,1.0),(-28.0,22.0,45.0),(-13.0,20.0,-4.0),(9.0,6.0,48.0),(18.0,-2.0,14.0),(-1.0,8.0,24.0),(1.0,16.0,33.0),(-34.0,78.0,2.0),(0.0,-9.0,63.0),(-5.0,-39.0,6.0),(-1.0,-29.0,3.0),(1.0,-20.0,-9.0),(-1.0,-19.0,0.0),(-18.0,-23.0,-1.0),(-17.0,-27.0,-6.0),(4.0,-21.0,-14.0),(4.0,-10.0,20.0),(-24.0,-20.0,-2.0),(13.0,-72.0,-6.0),(17.0,-64.0,-6.0),(12.0,-41.0,-73.0),(-1.0,3.0,-68.0),(-30.0,-3.0,-4.0),(9.0,13.0,-45.0),(-7.0,-27.0,45.0),(-33.0,6.0,10.0),(24.0,-27.0,-24.0),(5.0,29.0,-41.0),(15.0,31.0,-26.0),(9.0,-18.0,-10.0),(15.0,17.0,-7.0),(2.0,-6.0,-3.0),(21.0,-4.0,-1.0),(32.0,6.0,8.0),(29.0,8.0,9.0),(0.0,15.0,3.0),(-5.0,19.0,2.0),(-1.0,25.0,-1.0),(-4.0,24.0,1.0),(6.0,17.0,1.0),(-2.0,11.0,4.0),(7.0,9.0,-1.0),(3.0,19.0,3.0),(0.0,10.0,2.0),(-4.0,6.0,5.0),(7.0,3.0,-2.0),(0.0,10.0,2.0),(8.0,20.0,5.0),(-26.0,18.0,-10.0),(-30.0,18.0,-1.0),(-11.0,13.0,5.0),(-28.0,14.0,3.0),(-10.0,26.0,35.0),(8.0,4.0,47.0),(5.0,52.0,36.0),(-21.0,53.0,-3.0),(1.0,20.0,35.0),(-31.0,40.0,56.0),(11.0,-17.0,41.0),(-6.0,-70.0,-8.0),(9.0,-56.0,-4.0),(-5.0,-23.0,-7.0),(-4.0,-17.0,2.0),(-13.0,-30.0,-7.0),(-14.0,-31.0,-8.0),(-2.0,-15.0,-9.0),(-4.0,-20.0,0.0),(-17.0,-28.0,-9.0),(15.0,-57.0,23.0),(15.0,-69.0,-3.0),(19.0,-41.0,-85.0),(-24.0,29.0,2.0),(3.0,-15.0,-55.0),(1.0,6.0,-53.0),(23.0,27.0,-33.0),(22.0,6.0,-14.0),(7.0,-11.0,-5.0),(25.0,-11.0,-6.0),(34.0,4.0,6.0),(-4.0,18.0,4.0),(-1.0,28.0,-3.0),(-4.0,29.0,0.0),(10.0,22.0,2.0),(0.0,12.0,5.0),(3.0,10.0,-4.0),(5.0,22.0,4.0),(0.0,11.0,3.0),(-1.0,6.0,6.0),(3.0,7.0,-4.0),(0.0,13.0,0.0),(-35.0,33.0,-4.0),(-29.0,48.0,3.0),(-11.0,11.0,10.0),(-13.0,22.0,18.0),(-7.0,20.0,22.0),(7.0,21.0,39.0),(-6.0,31.0,37.0),(-8.0,-4.0,-10.0),(-24.0,39.0,111.0),(17.0,-32.0,27.0),(-2.0,-49.0,-6.0),(-8.0,-13.0,-14.0),(-8.0,-14.0,-4.0),(-9.0,-32.0,-3.0),(-10.0,-34.0,-3.0),(-7.0,-10.0,-12.0),(-8.0,-23.0,-6.0),(-12.0,-38.0,-5.0),(15.0,-58.0,25.0),(13.0,-70.0,-4.0),(-19.0,17.0,-38.0),(7.0,-29.0,-54.0),(0.0,2.0,-37.0),(17.0,5.0,-48.0),(21.0,36.0,-35.0),(18.0,12.0,-18.0),(19.0,-24.0,-6.0),(29.0,-32.0,2.0),(-2.0,27.0,-1.0),(-5.0,31.0,0.0),(8.0,23.0,0.0),(5.0,11.0,6.0),(6.0,11.0,-4.0),(2.0,22.0,2.0),(1.0,19.0,3.0),(3.0,10.0,6.0),(2.0,13.0,-4.0),(-34.0,46.0,0.0),(-13.0,21.0,10.0),(-15.0,17.0,20.0),(-7.0,24.0,20.0),(0.0,41.0,45.0),(-2.0,21.0,36.0),(-1.0,-5.0,-7.0),(-25.0,17.0,107.0),(-2.0,-23.0,-32.0),(-12.0,-11.0,-12.0),(-10.0,-29.0,-9.0),(-12.0,-35.0,-5.0),(-1.0,-22.0,-4.0),(-11.0,-30.0,-4.0),(-7.0,-30.0,22.0),(6.0,-66.0,7.0),(9.0,-35.0,-60.0),(0.0,1.0,-27.0),(19.0,1.0,-63.0),(25.0,3.0,-27.0),(17.0,9.0,-16.0),(19.0,-21.0,-9.0),(-6.0,32.0,3.0),(2.0,27.0,2.0),(12.0,8.0,5.0),(6.0,9.0,-7.0),(-1.0,27.0,2.0),(-1.0,24.0,2.0),(7.0,11.0,7.0),(-10.0,19.0,9.0),(-16.0,12.0,20.0),(-6.0,31.0,20.0),(0.0,47.0,40.0),(-13.0,18.0,33.0),(21.0,7.0,37.0),(-17.0,-7.0,-6.0),(-21.0,-29.0,-7.0),(-18.0,-35.0,-6.0),(-1.0,-30.0,0.0),(-13.0,-22.0,-5.0),(-15.0,-51.0,-7.0),(6.0,1.0,-29.0),(19.0,-29.0,-62.0),(22.0,-22.0,-24.0),(23.0,4.0,-16.0),(6.0,24.0,3.0),(9.0,8.0,4.0),(2.0,13.0,-6.0),(2.0,24.0,2.0),(2.0,24.0,3.0),(-18.0,10.0,22.0),(-10.0,36.0,25.0),(0.0,54.0,39.0),(-17.0,11.0,29.0),(-16.0,-27.0,-5.0),(-6.0,-34.0,-4.0),(6.0,-28.0,-2.0),(-10.0,-20.0,-2.0),(15.0,6.0,-11.0),(3.0,-51.0,-51.0),(15.0,-25.0,-25.0),(11.0,11.0,3.0),(0.0,13.0,-4.0),(3.0,25.0,3.0),(-11.0,32.0,23.0),(-4.0,72.0,47.0),(-10.0,-21.0,5.0),(5.0,-31.0,0.0),(2.0,-63.0,-54.0),(-1.0,11.0,-5.0),(564.0,-537.0,-131.0),(11.0,0.0,0.0),(10.0,0.0,2.0),(9.0,5.0,6.0),(11.0,0.0,3.0),(15.0,10.0,9.0),(14.0,12.0,13.0),(6.0,7.0,12.0),(14.0,5.0,10.0),(5.0,-31.0,40.0),(-13.0,-6.0,-7.0),(-7.0,-8.0,-7.0),(-14.0,-10.0,-10.0),(-15.0,-10.0,-8.0),(-11.0,-1.0,-2.0),(-9.0,-7.0,-4.0),(-9.0,0.0,-4.0),(-13.0,3.0,-2.0),(-4.0,-5.0,-2.0),(-11.0,0.0,-3.0),(-10.0,1.0,-4.0),(-6.0,4.0,0.0),(-12.0,-4.0,-3.0),(-37.0,0.0,-9.0),(-37.0,-5.0,-6.0),(-13.0,3.0,-2.0),(-4.0,-6.0,-2.0),(-11.0,-1.0,-1.0),(-10.0,0.0,-1.0),(-6.0,4.0,0.0),(-10.0,-6.0,-3.0),(-11.0,0.0,0.0),(-9.0,6.0,0.0),(-12.0,0.0,-1.0),(-18.0,8.0,1.0),(-18.0,8.0,3.0),(-8.0,6.0,4.0),(-14.0,4.0,0.0),(9.0,35.0,-36.0),(16.0,-4.0,-4.0),(11.0,-6.0,-9.0),(17.0,-9.0,-6.0),(18.0,-8.0,-2.0),(12.0,0.0,1.0),(8.0,-2.0,-1.0),(10.0,0.0,2.0),(13.0,2.0,3.0),(4.0,-3.0,-1.0),(11.0,1.0,1.0),(9.0,1.0,1.0),(5.0,4.0,4.0),(12.0,-2.0,0.0),(30.0,3.0,4.0),(30.0,-1.0,8.0),(11.0,3.0,3.0),(6.0,-3.0,0.0),(9.0,0.0,3.0),(11.0,0.0,1.0),(5.0,81.0,-61.0),(6.0,1.0,6.0),(10.0,-2.0,2.0),(7.0,-3.0,8.0),(7.0,1.0,9.0),(12.0,-2.0,2.0),(19.0,5.0,5.0),(20.0,4.0,7.0),(10.0,0.0,9.0),(18.0,-1.0,9.0),(22.0,6.0,14.0),(-18.0,-25.0,80.0),(18.0,24.0,2.0),(5.0,-4.0,20.0),(0.0,15.0,0.0),(-7.0,14.0,48.0),(-4.0,-12.0,-2.0),(5.0,-19.0,-16.0),(-12.0,-39.0,-3.0),(-43.0,-25.0,17.0),(-16.0,-7.0,-1.0),(-7.0,-9.0,0.0),(-14.0,-14.0,-9.0),(-13.0,-15.0,-10.0),(-10.0,-1.0,-2.0),(-9.0,-7.0,0.0),(-8.0,-1.0,-6.0),(-10.0,3.0,-2.0),(-5.0,-7.0,0.0),(-10.0,0.0,-5.0),(-9.0,0.0,-3.0),(-5.0,4.0,-2.0),(-12.0,-5.0,-1.0),(-30.0,0.0,-8.0),(-31.0,-4.0,-5.0),(-12.0,3.0,-4.0),(-4.0,-6.0,0.0),(-10.0,-1.0,0.0),(-10.0,0.0,0.0),(-5.0,5.0,-3.0),(-10.0,-5.0,0.0),(-10.0,1.0,1.0),(-9.0,5.0,-4.0),(-11.0,0.0,-1.0),(-18.0,12.0,3.0),(-16.0,12.0,1.0),(-9.0,8.0,-2.0),(-16.0,4.0,-6.0),(-40.0,21.0,-35.0),(-20.0,39.0,-1.0),(-1.0,17.0,16.0),(-7.0,12.0,-1.0),(10.0,-11.0,-46.0),(2.0,-13.0,1.0),(9.0,7.0,-17.0),(21.0,-23.0,5.0),(4.0,29.0,-82.0),(27.0,-4.0,-4.0),(20.0,3.0,0.0),(12.0,0.0,-5.0),(22.0,-2.0,2.0),(20.0,-2.0,2.0),(11.0,2.0,2.0),(10.0,0.0,-5.0),(9.0,4.0,-4.0),(10.0,2.0,1.0),(9.0,0.0,-2.0),(15.0,1.0,2.0),(16.0,4.0,0.0),(6.0,2.0,5.0),(9.0,-1.0,-1.0),(17.0,1.0,6.0),(17.0,0.0,1.0),(7.0,2.0,4.0),(9.0,-3.0,-2.0),(14.0,-1.0,6.0),(8.0,62.0,-23.0),(14.0,0.0,5.0),(6.0,0.0,7.0),(11.0,-1.0,4.0),(8.0,-3.0,8.0),(6.0,-1.0,11.0),(12.0,0.0,0.0),(15.0,8.0,6.0),(11.0,6.0,6.0),(6.0,-3.0,8.0),(10.0,0.0,2.0),(4.0,7.0,12.0),(7.0,7.0,18.0),(39.0,-49.0,22.0),(-3.0,1.0,24.0),(-7.0,6.0,9.0),(-49.0,25.0,57.0),(3.0,21.0,68.0),(22.0,-4.0,50.0),(-5.0,-5.0,-8.0),(-5.0,-8.0,-20.0),(-15.0,-31.0,-11.0),(-30.0,-42.0,24.0),(-20.0,-14.0,9.0),(-11.0,-6.0,0.0),(-15.0,-18.0,-4.0),(-17.0,-15.0,0.0),(-7.0,-6.0,-8.0),(-10.0,-3.0,1.0),(-9.0,0.0,-2.0),(-7.0,-4.0,-8.0),(-6.0,0.0,3.0),(-9.0,-2.0,-3.0),(-7.0,-1.0,-2.0),(-3.0,-1.0,-6.0),(-10.0,-1.0,2.0),(-20.0,0.0,-6.0),(-19.0,-3.0,-3.0),(-10.0,-1.0,-6.0),(-4.0,0.0,5.0),(-8.0,0.0,-1.0),(-9.0,0.0,-1.0),(-4.0,0.0,-5.0),(-10.0,1.0,4.0),(-9.0,-1.0,-2.0),(-9.0,2.0,-5.0),(-11.0,4.0,4.0),(-17.0,11.0,-9.0),(-21.0,16.0,-1.0),(-10.0,4.0,-7.0),(-19.0,11.0,-16.0),(-29.0,42.0,-35.0),(-24.0,28.0,4.0),(-10.0,4.0,16.0),(-9.0,4.0,4.0),(37.0,12.0,-37.0),(25.0,-15.0,-61.0),(-27.0,-24.0,-70.0),(-2.0,-6.0,-11.0),(7.0,0.0,-24.0),(41.0,52.0,-6.0),(14.0,-7.0,-13.0),(8.0,-5.0,-8.0),(10.0,2.0,1.0),(8.0,2.0,-6.0),(14.0,-6.0,0.0),(16.0,-5.0,0.0),(11.0,1.0,4.0),(10.0,3.0,-8.0),(11.0,4.0,-4.0),(11.0,1.0,0.0),(8.0,1.0,-3.0),(15.0,1.0,0.0),(19.0,1.0,4.0),(9.0,0.0,8.0),(9.0,1.0,-3.0),(16.0,8.0,1.0),(15.0,-7.0,5.0),(8.0,0.0,6.0),(10.0,1.0,-3.0),(-2.0,42.0,6.0),(19.0,0.0,3.0),(14.0,0.0,5.0),(6.0,-1.0,7.0),(10.0,0.0,5.0),(7.0,-2.0,8.0),(5.0,-3.0,11.0),(7.0,3.0,1.0),(7.0,5.0,6.0),(5.0,2.0,7.0),(2.0,-2.0,7.0),(4.0,3.0,1.0),(0.0,5.0,12.0),(10.0,9.0,18.0),(0.0,8.0,19.0),(31.0,-39.0,-7.0),(-5.0,-1.0,13.0),(-33.0,-12.0,32.0),(-6.0,2.0,-5.0),(20.0,-16.0,50.0),(4.0,15.0,69.0),(-2.0,-1.0,-18.0),(-6.0,-12.0,0.0),(-29.0,-39.0,27.0),(-13.0,-20.0,-3.0),(-12.0,-5.0,-2.0),(-17.0,-17.0,-7.0),(-17.0,-13.0,-6.0),(-4.0,-13.0,-3.0),(-11.0,4.0,0.0),(-7.0,-1.0,-5.0),(-5.0,-9.0,-2.0),(-7.0,6.0,0.0),(-7.0,0.0,-3.0),(-7.0,-1.0,-2.0),(-1.0,-7.0,-2.0),(-11.0,6.0,0.0),(-17.0,0.0,-5.0),(-16.0,-3.0,-2.0),(-9.0,-7.0,-3.0),(-3.0,6.0,0.0),(-7.0,0.0,-1.0),(-8.0,-1.0,0.0),(-4.0,-7.0,-2.0),(-8.0,8.0,0.0),(-8.0,-1.0,1.0),(-10.0,-5.0,-4.0),(-7.0,13.0,0.0),(-19.0,10.0,-2.0),(-21.0,14.0,-1.0),(-14.0,3.0,-4.0),(-16.0,18.0,-3.0),(-26.0,39.0,-38.0),(-7.0,10.0,-1.0),(-7.0,-1.0,15.0),(27.0,-8.0,-61.0),(31.0,22.0,-38.0),(-9.0,-2.0,2.0),(-18.0,11.0,-43.0),(0.0,0.0,-14.0),(23.0,41.0,19.0),(9.0,-8.0,-19.0),(17.0,-9.0,-12.0),(4.0,-4.0,-11.0),(5.0,-2.0,0.0),(5.0,3.0,-5.0),(7.0,-3.0,-5.0),(9.0,-4.0,-2.0),(7.0,-2.0,2.0),(8.0,5.0,-9.0),(10.0,2.0,-5.0),(12.0,0.0,-1.0),(7.0,3.0,-3.0),(15.0,2.0,1.0),(19.0,0.0,5.0),(9.0,-2.0,7.0),(9.0,5.0,-4.0),(16.0,7.0,2.0),(16.0,-6.0,4.0),(5.0,-4.0,8.0),(-3.0,18.0,17.0),(8.0,6.0,3.0),(19.0,0.0,-2.0),(11.0,-1.0,3.0),(5.0,-4.0,4.0),(7.0,3.0,8.0),(5.0,-3.0,7.0),(5.0,-6.0,9.0),(1.0,6.0,5.0),(6.0,1.0,4.0),(5.0,0.0,5.0),(1.0,-3.0,7.0),(0.0,5.0,3.0),(0.0,3.0,10.0),(6.0,5.0,15.0),(4.0,7.0,17.0),(6.0,-2.0,10.0),(25.0,-8.0,-5.0),(-17.0,-47.0,6.0),(16.0,-17.0,48.0),(0.0,-9.0,1.0),(-7.0,-49.0,30.0),(-6.0,-22.0,-1.0),(-15.0,-1.0,-7.0),(-18.0,-10.0,-8.0),(-15.0,-9.0,-6.0),(-5.0,-10.0,-4.0),(-11.0,1.0,-2.0),(-8.0,-1.0,-4.0),(-6.0,-7.0,-2.0),(-7.0,6.0,0.0),(-8.0,-1.0,-3.0),(-8.0,0.0,-2.0),(-2.0,-6.0,-2.0),(-12.0,7.0,-1.0),(-25.0,0.0,-6.0),(-25.0,-4.0,-4.0),(-10.0,-7.0,-3.0),(-3.0,5.0,0.0),(-9.0,-1.0,-1.0),(-8.0,0.0,-1.0),(-6.0,-7.0,-2.0),(-7.0,6.0,0.0),(-9.0,0.0,0.0),(-11.0,-2.0,-2.0),(-7.0,10.0,0.0),(-17.0,7.0,0.0),(-21.0,6.0,0.0),(-15.0,-1.0,0.0),(-10.0,22.0,-2.0),(-5.0,52.0,-32.0),(0.0,10.0,-2.0),(27.0,21.0,-37.0),(-17.0,46.0,-12.0),(21.0,9.0,14.0),(10.0,2.0,-7.0),(11.0,-7.0,-15.0),(11.0,-5.0,-12.0),(4.0,-2.0,-8.0),(1.0,-4.0,-4.0),(4.0,3.0,-5.0),(6.0,0.0,-3.0),(8.0,-1.0,-2.0),(3.0,-4.0,-4.0),(7.0,7.0,-6.0),(8.0,2.0,-5.0),(10.0,-2.0,-4.0),(5.0,6.0,-2.0),(11.0,1.0,2.0),(16.0,1.0,9.0),(10.0,-5.0,0.0),(7.0,9.0,0.0),(16.0,4.0,3.0),(16.0,-3.0,3.0),(-4.0,-8.0,10.0),(7.0,-7.0,0.0),(8.0,6.0,4.0),(18.0,1.0,0.0),(9.0,-1.0,3.0),(6.0,-3.0,1.0),(6.0,2.0,9.0),(6.0,-2.0,8.0),(7.0,-5.0,6.0),(2.0,5.0,6.0),(4.0,1.0,6.0),(4.0,0.0,7.0),(4.0,-2.0,3.0),(-2.0,4.0,6.0),(0.0,2.0,9.0),(4.0,4.0,14.0),(5.0,6.0,16.0),(7.0,0.0,8.0),(12.0,-47.0,-3.0),(1.0,-9.0,0.0),(2.0,-33.0,19.0),(0.0,-27.0,11.0),(-14.0,-2.0,-7.0),(-18.0,-11.0,-9.0),(-14.0,-12.0,-7.0),(-5.0,-10.0,-4.0),(-11.0,4.0,-1.0),(-10.0,1.0,-7.0),(-6.0,-6.0,-4.0),(-6.0,5.0,0.0),(-8.0,0.0,-2.0),(-8.0,0.0,-2.0),(-2.0,-5.0,-3.0),(-11.0,7.0,0.0),(-21.0,0.0,-5.0),(-20.0,-3.0,-3.0),(-10.0,-7.0,-3.0),(-3.0,5.0,0.0),(-8.0,-1.0,-1.0),(-8.0,0.0,-1.0),(-5.0,-6.0,-2.0),(-8.0,5.0,2.0),(-10.0,-4.0,2.0),(-10.0,-3.0,-2.0),(-7.0,10.0,1.0),(-17.0,10.0,1.0),(-21.0,9.0,1.0),(-16.0,1.0,0.0),(0.0,28.0,-12.0),(6.0,35.0,-16.0),(0.0,8.0,1.0),(5.0,47.0,6.0),(11.0,0.0,-6.0),(10.0,-5.0,-13.0),(10.0,-4.0,-11.0),(4.0,-2.0,-8.0),(0.0,-3.0,-6.0),(5.0,2.0,-2.0),(6.0,0.0,-4.0),(7.0,-1.0,-4.0),(4.0,-4.0,-5.0),(8.0,7.0,-3.0),(9.0,2.0,-5.0),(9.0,-1.0,-5.0),(6.0,5.0,1.0),(9.0,0.0,1.0),(17.0,0.0,6.0),(9.0,-4.0,0.0),(6.0,8.0,4.0),(12.0,4.0,1.0),(-9.0,-116.0,73.0),(284.0,522.0,619.0),(-52.0,-20.0,93.0),(-38.0,-8.0,75.0),(3.0,-23.0,34.0),(39.0,14.0,-63.0),(51.0,14.0,-106.0),(60.0,-1.0,-133.0),(0.0,-73.0,-65.0),(-31.0,-168.0,-40.0),(0.0,-30.0,8.0),(-18.0,-70.0,-84.0),(-9.0,16.0,0.0),(0.0,12.0,0.0),(20.0,123.0,51.0),(16.0,168.0,27.0),(21.0,40.0,69.0),(-9.0,11.0,-17.0),(-54.0,61.0,75.0),(7.0,-23.0,29.0),(-39.0,3.0,66.0),(-43.0,-25.0,84.0),(-27.0,-48.0,83.0),(-16.0,-51.0,55.0),(4.0,-8.0,11.0),(28.0,20.0,-37.0),(37.0,14.0,-56.0),(48.0,7.0,-102.0),(-31.0,-77.0,62.0),(57.0,-6.0,-103.0),(30.0,65.0,-69.0),(6.0,-100.0,-58.0),(-11.0,-157.0,-62.0),(-21.0,-89.0,-114.0),(-35.0,-21.0,-70.0),(-3.0,41.0,35.0),(-8.0,17.0,13.0),(0.0,8.0,3.0),(-21.0,-13.0,-19.0),(0.0,47.0,16.0),(18.0,19.0,11.0),(20.0,29.0,11.0),(18.0,78.0,54.0),(8.0,167.0,19.0),(-15.0,10.0,-9.0),(36.0,46.0,55.0),(-54.0,65.0,75.0),(-23.0,36.0,29.0),(4.0,-20.0,24.0),(-10.0,34.0,-9.0),(-2.0,-47.0,53.0),(-13.0,87.0,-49.0),(-38.0,-102.0,119.0),(-25.0,-57.0,107.0),(-20.0,-52.0,49.0),(-501.0,-293.0,316.0),(9.0,0.0,3.0),(9.0,-44.0,-112.0),(-129.0,57.0,88.0),(-10.0,5.0,-3.0),(37.0,-14.0,17.0),(41.0,-1.0,6.0),(32.0,-2.0,-1.0),(19.0,-43.0,-110.0),(25.0,-73.0,-86.0),(11.0,-2.0,1.0),(9.0,1.0,4.0),(-22.0,73.0,87.0),(6.0,40.0,126.0),(39.0,-5.0,13.0),(30.0,3.0,1.0),(12.0,4.0,2.0),(5.0,1.0,1.0),(28.0,0.0,3.0),(35.0,6.0,-11.0),(33.0,11.0,-12.0),(43.0,29.0,-18.0),(43.0,32.0,-35.0),(6.0,6.0,-7.0),(3.0,2.0,-8.0),(25.0,19.0,-23.0),(44.0,34.0,-56.0),(14.0,7.0,-17.0),(45.0,30.0,-54.0),(9.0,20.0,-25.0),(6.0,11.0,-11.0),(37.0,8.0,-32.0),(10.0,0.0,1.0),(18.0,-10.0,-27.0),(34.0,5.0,-47.0),(-12.0,-14.0,1.0),(44.0,-6.0,-81.0),(59.0,-5.0,-94.0),(29.0,-88.0,-79.0),(10.0,15.0,-10.0),(0.0,-155.0,-93.0),(-16.0,-94.0,-158.0),(-86.0,10.0,-148.0),(-37.0,5.0,-59.0),(78.0,7.0,140.0),(-51.0,-2.0,-43.0),(18.0,16.0,30.0),(7.0,32.0,42.0),(-2.0,14.0,16.0),(-15.0,4.0,-8.0),(0.0,7.0,4.0),(1.0,40.0,16.0),(0.0,18.0,3.0),(11.0,4.0,10.0),(16.0,16.0,8.0),(15.0,24.0,8.0),(19.0,83.0,51.0),(-11.0,37.0,-13.0),(-13.0,27.0,-9.0),(-5.0,11.0,-4.0),(-31.0,34.0,-17.0),(-78.0,71.0,-6.0),(43.0,-15.0,15.0),(12.0,0.0,4.0),(-23.0,47.0,-1.0),(65.0,-25.0,22.0),(48.0,59.0,50.0),(0.0,45.0,28.0),(-18.0,28.0,49.0),(-45.0,29.0,44.0),(-25.0,61.0,-18.0),(-53.0,73.0,-23.0),(7.0,-5.0,18.0),(7.0,-122.0,108.0),(-30.0,-102.0,154.0),(-18.0,-48.0,51.0),(-44.0,-100.0,87.0),(-7.0,-14.0,17.0),(-1.0,-13.0,26.0),(-47.0,-20.0,86.0),(-17.0,2.0,34.0),(-30.0,-32.0,81.0),(-25.0,-25.0,39.0),(-1.0,-5.0,9.0),(-8.0,-6.0,10.0),(-43.0,-34.0,45.0),(-49.0,-25.0,36.0),(-25.0,-14.0,13.0),(-41.0,-3.0,31.0),(-32.0,-6.0,5.0),(-7.0,-2.0,1.0),(-21.0,-2.0,12.0),(-37.0,0.0,24.0),(-43.0,0.0,1.0),(-31.0,6.0,-8.0),(-8.0,1.0,-7.0),(-11.0,0.0,3.0),(-31.0,-1.0,-8.0),(-37.0,4.0,-22.0),(-24.0,6.0,-39.0),(-12.0,5.0,-21.0),(-96.0,226.0,-969.0),(-12.0,7.0,116.0),(24.0,53.0,-75.0),(-9.0,-5.0,103.0),(18.0,-19.0,-190.0),(22.0,21.0,-20.0),(13.0,-35.0,-9.0),(-15.0,-12.0,8.0),(59.0,-52.0,-39.0),(48.0,-198.0,-11.0),(-8.0,-56.0,11.0),(70.0,-68.0,-39.0),(0.0,-12.0,0.0),(-5.0,-16.0,-4.0),(-64.0,66.0,48.0),(-78.0,232.0,9.0),(-44.0,83.0,47.0),(-41.0,-7.0,75.0),(-20.0,15.0,130.0),(-1.0,2.0,81.0),(21.0,21.0,-28.0),(1.0,4.0,25.0),(16.0,46.0,6.0),(35.0,38.0,-115.0),(30.0,80.0,-130.0),(-36.0,-86.0,33.0),(28.0,43.0,-49.0),(-12.0,-39.0,0.0),(17.0,17.0,-19.0),(1.0,-50.0,-43.0),(18.0,-33.0,-4.0),(62.0,-61.0,-23.0),(-18.0,-11.0,-1.0),(38.0,-196.0,-11.0),(48.0,-78.0,-27.0),(27.0,-28.0,0.0),(23.0,-15.0,0.0),(12.0,-45.0,-11.0),(-25.0,9.0,3.0),(2.0,-9.0,-2.0),(1.0,-17.0,-13.0),(14.0,-37.0,-25.0),(-55.0,10.0,34.0),(-87.0,83.0,66.0),(-76.0,186.0,34.0),(-43.0,113.0,49.0),(-14.0,-72.0,57.0),(-24.0,24.0,79.0),(8.0,68.0,-74.0),(-20.0,21.0,125.0),(0.0,-1.0,77.0),(3.0,-12.0,51.0),(10.0,8.0,-8.0),(22.0,44.0,4.0),(23.0,-36.0,107.0),(-3.0,-10.0,18.0),(16.0,101.0,-123.0),(13.0,42.0,-56.0),(52.0,78.0,-160.0),(60.0,111.0,-90.0),(12.0,5.0,-12.0),(-51.0,-83.0,-20.0),(-31.0,-66.0,0.0),(0.0,-16.0,-19.0),(30.0,-17.0,-15.0),(13.0,-55.0,-20.0),(69.0,-72.0,-14.0),(71.0,30.0,9.0),(-22.0,-54.0,-7.0),(12.0,1.0,2.0),(44.0,20.0,5.0),(-74.0,-89.0,-25.0),(-31.0,-43.0,-1.0),(-4.0,-11.0,0.0),(-11.0,-30.0,0.0),(-7.0,-40.0,3.0),(49.0,-85.0,-25.0),(21.0,-21.0,0.0),(19.0,-14.0,0.0),(14.0,-2.0,-2.0),(3.0,-17.0,-2.0),(15.0,-39.0,-12.0),(2.0,-7.0,-3.0),(-16.0,-6.0,0.0),(6.0,-13.0,-14.0),(25.0,-27.0,-29.0),(28.0,-10.0,-19.0),(3.0,-4.0,-37.0),(50.0,15.0,-39.0),(-113.0,-21.0,92.0),(-53.0,-34.0,29.0),(-100.0,85.0,96.0),(-90.0,179.0,62.0),(3.0,-17.0,11.0),(-44.0,99.0,70.0),(-18.0,27.0,80.0),(-13.0,31.0,101.0),(-9.0,14.0,-9.0),(2.0,6.0,68.0),(2.0,20.0,37.0),(9.0,-1.0,5.0),(15.0,-2.0,54.0),(-1.0,-10.0,15.0),(17.0,31.0,39.0),(1.0,-11.0,107.0),(3.0,3.0,46.0),(-10.0,-30.0,91.0),(2.0,-30.0,46.0),(-3.0,-5.0,9.0),(1.0,-7.0,12.0),(14.0,-40.0,59.0),(27.0,-34.0,56.0),(13.0,-17.0,22.0),(24.0,-9.0,47.0),(28.0,-11.0,19.0),(35.0,-51.0,-143.0),(42.0,-45.0,-105.0),(11.0,-5.0,-2.0),(18.0,-4.0,6.0),(32.0,-5.0,6.0),(29.0,-72.0,-85.0),(39.0,-78.0,-85.0),(18.0,-5.0,6.0),(7.0,-1.0,1.0),(6.0,1.0,2.0),(18.0,4.0,2.0),(-13.0,75.0,93.0),(-20.0,69.0,88.0),(32.0,0.0,8.0),(20.0,1.0,4.0),(9.0,2.0,7.0),(24.0,-4.0,-5.0),(40.0,3.0,-13.0),(23.0,5.0,-7.0),(31.0,4.0,-11.0),(22.0,14.0,5.0),(35.0,17.0,-13.0),(22.0,10.0,-15.0),(3.0,4.0,-4.0),(1.0,9.0,-6.0),(46.0,22.0,-24.0),(68.0,59.0,-54.0),(20.0,6.0,-13.0),(30.0,-24.0,-33.0),(15.0,6.0,3.0),(2.0,86.0,-6.0),(7.0,20.0,-18.0),(29.0,-11.0,-40.0),(44.0,-4.0,-80.0),(61.0,-7.0,-96.0),(28.0,-84.0,-74.0),(8.0,-152.0,-102.0),(0.0,9.0,-5.0),(-10.0,-97.0,-158.0),(-56.0,-6.0,-159.0),(0.0,9.0,-1.0),(-15.0,19.0,0.0),(-40.0,4.0,-63.0),(-25.0,11.0,-24.0),(-22.0,16.0,-12.0),(13.0,-12.0,24.0),(-7.0,3.0,13.0),(13.0,-9.0,16.0),(34.0,-6.0,57.0),(5.0,3.0,21.0),(-19.0,8.0,-17.0),(4.0,2.0,12.0),(14.0,15.0,32.0),(10.0,31.0,44.0),(-16.0,12.0,-6.0),(7.0,20.0,20.0),(3.0,35.0,13.0),(2.0,15.0,4.0),(3.0,19.0,7.0),(8.0,11.0,7.0),(15.0,16.0,11.0),(12.0,22.0,5.0),(-5.0,25.0,-8.0),(-4.0,8.0,-4.0),(-9.0,51.0,-4.0),(-44.0,103.0,21.0),(-75.0,67.0,-9.0),(3.0,23.0,11.0),(17.0,-4.0,9.0),(28.0,0.0,9.0),(18.0,21.0,11.0),(29.0,41.0,23.0),(21.0,47.0,23.0),(7.0,32.0,47.0),(-42.0,24.0,60.0),(-30.0,55.0,-5.0),(-43.0,50.0,-17.0),(-2.0,5.0,19.0),(21.0,-113.0,106.0),(-24.0,-119.0,164.0),(-12.0,-32.0,38.0),(-44.0,-99.0,85.0),(-17.0,-37.0,45.0),(-31.0,-14.0,47.0),(-12.0,4.0,32.0),(-19.0,19.0,76.0),(-11.0,-32.0,53.0),(-34.0,-25.0,64.0),(-3.0,-6.0,14.0),(-6.0,-5.0,13.0),(-38.0,-28.0,48.0),(-48.0,-22.0,35.0),(-10.0,-5.0,4.0),(-21.0,-5.0,21.0),(-49.0,-6.0,41.0),(-33.0,-3.0,15.0),(-8.0,0.0,3.0),(-19.0,-1.0,20.0),(-40.0,0.0,21.0),(-29.0,1.0,2.0),(-36.0,1.0,-11.0),(-10.0,0.0,-7.0),(-12.0,1.0,1.0),(-37.0,3.0,-7.0),(-24.0,3.0,-17.0),(-28.0,5.0,-37.0),(-10.0,4.0,-27.0),(-5.0,1.0,-7.0),(-25.0,8.0,-29.0),(-25.0,12.0,-59.0),(-10.0,9.0,-29.0),(-7.0,7.0,-8.0),(-24.0,28.0,-53.0),(-9.0,33.0,-60.0),(0.0,9.0,-15.0),(5.0,5.0,-14.0),(2.0,31.0,-73.0),(18.0,28.0,-52.0),(10.0,-22.0,-86.0),(0.0,-8.0,-36.0),(-4.0,11.0,-63.0),(10.0,31.0,-51.0),(11.0,91.0,-101.0),(9.0,26.0,-41.0),(62.0,95.0,-166.0),(69.0,106.0,-80.0),(6.0,-8.0,-20.0),(-41.0,-56.0,-16.0),(-25.0,-63.0,-17.0),(13.0,-11.0,-28.0),(52.0,-23.0,0.0),(28.0,-58.0,-11.0),(36.0,-48.0,-5.0),(25.0,-20.0,-1.0),(25.0,2.0,4.0),(20.0,5.0,0.0),(6.0,-24.0,-7.0),(-75.0,-84.0,-21.0),(-22.0,-116.0,-33.0),(-2.0,-56.0,0.0),(-2.0,-7.0,1.0),(-2.0,-27.0,3.0),(18.0,-22.0,0.0),(19.0,-12.0,0.0),(11.0,-10.0,-2.0),(9.0,-18.0,-4.0),(5.0,-14.0,-3.0),(14.0,-34.0,-8.0),(15.0,-16.0,-13.0),(-13.0,-17.0,-2.0),(28.0,-23.0,-32.0),(26.0,-9.0,-24.0),(6.0,0.0,-8.0),(-22.0,-11.0,8.0),(13.0,0.0,-18.0),(48.0,17.0,-38.0),(14.0,12.0,-10.0),(-4.0,-3.0,-15.0),(-4.0,-3.0,-13.0),(23.0,19.0,-3.0),(-51.0,-36.0,16.0),(-55.0,-17.0,40.0),(-10.0,-21.0,-3.0),(1.0,-9.0,1.0),(-92.0,-20.0,99.0),(-96.0,87.0,100.0),(-2.0,-8.0,3.0),(-94.0,175.0,73.0),(-40.0,95.0,65.0),(-19.0,29.0,84.0),(-13.0,30.0,102.0),(1.0,20.0,56.0),(-4.0,-16.0,19.0),(15.0,21.0,111.0),(11.0,-23.0,77.0),(5.0,-5.0,26.0),(10.0,-33.0,76.0),(10.0,-21.0,37.0),(-1.0,-2.0,8.0),(3.0,-6.0,11.0),(18.0,-36.0,53.0),(28.0,-37.0,35.0),(21.0,-16.0,26.0),(29.0,-12.0,25.0),(48.0,-51.0,-112.0),(49.0,-74.0,-81.0),(20.0,-1.0,6.0),(13.0,-3.0,-1.0),(12.0,2.0,4.0),(38.0,-69.0,-87.0),(21.0,-61.0,-91.0),(22.0,-21.0,15.0),(22.0,-9.0,9.0),(8.0,0.0,3.0),(7.0,2.0,3.0),(20.0,11.0,6.0),(22.0,21.0,0.0),(-32.0,54.0,77.0),(-14.0,64.0,93.0),(13.0,-3.0,1.0),(8.0,1.0,8.0),(24.0,-1.0,2.0),(33.0,-8.0,3.0),(15.0,8.0,-12.0),(7.0,4.0,-3.0),(12.0,7.0,2.0),(35.0,6.0,-6.0),(16.0,9.0,1.0),(38.0,15.0,-6.0),(31.0,22.0,-12.0),(10.0,12.0,-6.0),(5.0,8.0,-11.0),(46.0,27.0,-14.0),(40.0,42.0,-18.0),(16.0,1.0,1.0),(30.0,-25.0,-47.0),(33.0,64.0,-3.0),(14.0,9.0,10.0),(12.0,69.0,-7.0),(52.0,6.0,-89.0),(51.0,-9.0,-85.0),(37.0,-83.0,-83.0),(13.0,-148.0,-117.0),(-6.0,-90.0,-170.0),(4.0,-34.0,-2.0),(-20.0,40.0,7.0),(-59.0,-2.0,-160.0),(-43.0,21.0,-66.0),(-36.0,20.0,-32.0),(-26.0,21.0,-19.0),(-24.0,20.0,-13.0),(4.0,0.0,-11.0),(0.0,9.0,30.0),(3.0,3.0,13.0),(17.0,-29.0,7.0),(-1.0,0.0,16.0),(11.0,-5.0,22.0),(24.0,-8.0,47.0),(-8.0,15.0,4.0),(6.0,-4.0,13.0),(4.0,0.0,13.0),(6.0,11.0,21.0),(-11.0,6.0,-12.0),(9.0,47.0,51.0),(13.0,18.0,25.0),(8.0,33.0,16.0),(5.0,38.0,8.0),(7.0,17.0,4.0),(14.0,26.0,10.0),(-4.0,66.0,-6.0),(-46.0,113.0,22.0),(-66.0,51.0,-8.0),(-13.0,32.0,4.0),(5.0,23.0,13.0),(25.0,-10.0,11.0),(18.0,-1.0,5.0),(12.0,15.0,9.0),(24.0,36.0,18.0),(19.0,49.0,20.0),(14.0,39.0,45.0),(-40.0,26.0,64.0),(-30.0,48.0,-3.0),(-44.0,44.0,-18.0),(-2.0,7.0,21.0),(28.0,-112.0,110.0),(-24.0,-120.0,164.0),(-10.0,-21.0,29.0),(-44.0,-101.0,87.0),(-24.0,-39.0,46.0),(-21.0,-12.0,31.0),(-8.0,11.0,22.0),(-13.0,10.0,66.0),(-37.0,-3.0,88.0),(-15.0,-28.0,47.0),(-2.0,-9.0,23.0),(-11.0,-10.0,22.0),(-33.0,-26.0,45.0),(-43.0,-13.0,27.0),(-10.0,-3.0,4.0),(-28.0,-6.0,33.0),(-61.0,-8.0,53.0),(-20.0,-1.0,7.0),(-11.0,-3.0,7.0),(-19.0,-4.0,21.0),(-40.0,0.0,18.0),(-26.0,2.0,3.0),(-34.0,4.0,-16.0),(-11.0,0.0,-6.0),(-11.0,2.0,0.0),(-38.0,0.0,-1.0),(-23.0,1.0,-17.0),(-27.0,4.0,-35.0),(-8.0,8.0,-27.0),(-7.0,4.0,-12.0),(-16.0,4.0,-16.0),(-30.0,16.0,-76.0),(-10.0,10.0,-42.0),(-7.0,5.0,-8.0),(-26.0,19.0,-44.0),(-4.0,30.0,-55.0),(0.0,13.0,-24.0),(9.0,10.0,-22.0),(13.0,28.0,-47.0),(5.0,3.0,-101.0),(11.0,-15.0,-72.0),(0.0,-14.0,-26.0),(-3.0,10.0,-43.0),(4.0,34.0,-55.0),(11.0,92.0,-102.0),(6.0,18.0,-32.0),(67.0,98.0,-167.0),(73.0,103.0,-78.0),(6.0,-11.0,-23.0),(-42.0,-49.0,-15.0),(-21.0,-56.0,-20.0),(15.0,-14.0,-29.0),(54.0,-34.0,3.0),(27.0,-56.0,-9.0),(30.0,-42.0,-6.0),(17.0,-14.0,0.0),(17.0,3.0,3.0),(28.0,12.0,1.0),(6.0,-25.0,-8.0),(-12.0,-36.0,-8.0),(-64.0,-64.0,-18.0),(-21.0,-127.0,-35.0),(5.0,-69.0,3.0),(22.0,-23.0,-2.0),(10.0,-16.0,0.0),(15.0,-38.0,-4.0),(17.0,-29.0,-8.0),(23.0,-13.0,-16.0),(33.0,-40.0,-40.0),(-13.0,-9.0,6.0),(15.0,-8.0,-17.0),(7.0,3.0,-10.0),(8.0,6.0,-9.0),(-3.0,-16.0,-7.0),(35.0,17.0,-33.0),(16.0,9.0,-16.0),(3.0,0.0,-15.0),(16.0,32.0,0.0),(8.0,-4.0,-12.0),(11.0,-8.0,-14.0),(0.0,0.0,-12.0),(-27.0,-22.0,16.0),(-30.0,-24.0,8.0),(-38.0,-27.0,15.0),(-56.0,-35.0,44.0),(-92.0,-24.0,98.0),(-10.0,-9.0,-11.0),(3.0,-34.0,-2.0),(-104.0,115.0,115.0),(-96.0,167.0,81.0),(-42.0,99.0,77.0),(-19.0,33.0,73.0),(-12.0,20.0,112.0),(7.0,-75.0,12.0),(3.0,10.0,48.0),(14.0,-5.0,5.0),(7.0,35.0,54.0),(9.0,-4.0,24.0),(25.0,-53.0,90.0),(27.0,-22.0,50.0),(-3.0,-8.0,6.0),(2.0,-4.0,6.0),(12.0,-9.0,27.0),(23.0,-18.0,31.0),(22.0,-16.0,7.0),(23.0,-7.0,28.0),(15.0,-9.0,16.0),(34.0,-77.0,-86.0),(7.0,-6.0,19.0),(32.0,-71.0,-74.0),(35.0,11.0,0.0),(16.0,-3.0,7.0),(12.0,-1.0,1.0),(19.0,-66.0,-94.0),(65.0,-72.0,-117.0),(18.0,0.0,7.0),(16.0,-21.0,14.0),(29.0,-9.0,11.0),(11.0,0.0,5.0),(11.0,3.0,4.0),(27.0,14.0,11.0),(17.0,24.0,-1.0),(17.0,2.0,8.0),(-67.0,64.0,109.0),(-34.0,55.0,73.0),(11.0,1.0,5.0),(14.0,2.0,2.0),(27.0,-12.0,18.0),(16.0,10.0,-2.0),(7.0,5.0,0.0),(17.0,5.0,0.0),(46.0,18.0,-1.0),(21.0,5.0,-6.0),(44.0,24.0,-2.0),(22.0,20.0,-11.0),(25.0,29.0,-11.0),(45.0,35.0,-18.0),(36.0,47.0,-16.0),(61.0,-12.0,-65.0),(20.0,9.0,0.0),(39.0,83.0,-32.0),(21.0,16.0,0.0),(61.0,-74.0,-126.0),(26.0,-155.0,-130.0),(-15.0,-6.0,4.0),(-4.0,-86.0,-181.0),(-49.0,0.0,-170.0),(11.0,9.0,-3.0),(-13.0,33.0,6.0),(-52.0,18.0,-66.0),(-34.0,23.0,-31.0),(-25.0,25.0,-22.0),(0.0,-5.0,-13.0),(-25.0,17.0,-18.0),(-19.0,10.0,-4.0),(1.0,9.0,17.0),(-2.0,1.0,13.0),(10.0,10.0,21.0),(5.0,4.0,14.0),(10.0,-7.0,13.0),(15.0,-6.0,31.0),(0.0,14.0,0.0),(24.0,-33.0,67.0),(-4.0,1.0,4.0),(6.0,1.0,18.0),(10.0,49.0,56.0),(13.0,18.0,23.0),(7.0,29.0,14.0),(4.0,38.0,8.0),(7.0,16.0,4.0),(14.0,34.0,7.0),(-2.0,64.0,-4.0),(-43.0,108.0,20.0),(-67.0,49.0,-8.0),(-16.0,39.0,4.0),(5.0,21.0,13.0),(26.0,-11.0,11.0),(15.0,-1.0,5.0),(11.0,13.0,8.0),(22.0,38.0,21.0),(18.0,46.0,17.0),(14.0,43.0,41.0),(-39.0,29.0,62.0),(-29.0,45.0,-3.0),(-41.0,40.0,-12.0),(-2.0,7.0,21.0),(27.0,-114.0,114.0),(-21.0,-113.0,154.0),(-9.0,-20.0,28.0),(-47.0,-110.0,96.0),(-23.0,-34.0,43.0),(-20.0,-11.0,29.0),(-8.0,10.0,23.0),(-13.0,8.0,61.0),(-34.0,-2.0,86.0),(-21.0,-29.0,58.0),(0.0,-7.0,18.0),(-11.0,-10.0,21.0),(-34.0,-26.0,47.0),(-39.0,-12.0,24.0),(-10.0,-3.0,4.0),(-27.0,-6.0,33.0),(-64.0,-10.0,55.0),(-17.0,-2.0,6.0),(-12.0,-2.0,7.0),(-17.0,-5.0,21.0),(-45.0,0.0,20.0),(-23.0,3.0,0.0),(-33.0,4.0,-17.0),(-8.0,0.0,-9.0),(-13.0,1.0,4.0),(-34.0,0.0,0.0),(-22.0,0.0,-13.0),(-30.0,6.0,-38.0),(-7.0,7.0,-27.0),(-7.0,4.0,-12.0),(-15.0,4.0,-14.0),(-31.0,19.0,-79.0),(-9.0,10.0,-42.0),(-7.0,4.0,-8.0),(-23.0,18.0,-39.0),(-7.0,33.0,-58.0),(2.0,11.0,-23.0),(7.0,8.0,-16.0),(14.0,30.0,-59.0),(4.0,1.0,-100.0),(12.0,-13.0,-66.0),(0.0,-13.0,-26.0),(-3.0,7.0,-38.0),(4.0,32.0,-53.0),(13.0,98.0,-114.0),(7.0,18.0,-29.0),(60.0,91.0,-156.0),(77.0,107.0,-84.0),(8.0,-12.0,-23.0),(-40.0,-47.0,-18.0),(-17.0,-51.0,-20.0),(13.0,-16.0,-26.0),(54.0,-39.0,3.0),(25.0,-53.0,-7.0),(31.0,-44.0,-7.0),(13.0,-11.0,0.0),(15.0,3.0,3.0),(29.0,13.0,1.0),(6.0,-24.0,-9.0),(-17.0,-44.0,-10.0),(-62.0,-61.0,-17.0),(-19.0,-122.0,-32.0),(6.0,-66.0,2.0),(22.0,-32.0,0.0),(10.0,-16.0,0.0),(14.0,-36.0,-4.0),(16.0,-28.0,-8.0),(21.0,-12.0,-13.0),(37.0,-39.0,-45.0),(11.0,0.0,-14.0),(-3.0,0.0,-5.0),(40.0,43.0,-52.0),(0.0,-14.0,0.0),(24.0,12.0,-22.0),(13.0,7.0,-9.0),(11.0,-4.0,-10.0),(17.0,-9.0,-16.0),(3.0,0.0,-13.0),(8.0,-9.0,-15.0),(-19.0,-12.0,-2.0),(-29.0,-18.0,7.0),(-4.0,5.0,13.0),(-31.0,-29.0,11.0),(-37.0,-29.0,15.0),(-64.0,-32.0,39.0),(-2.0,-36.0,-10.0),(9.0,-8.0,9.0),(-83.0,-26.0,111.0),(-97.0,73.0,116.0),(-16.0,6.0,-8.0),(-102.0,173.0,96.0),(-51.0,107.0,122.0),(16.0,-18.0,8.0),(-15.0,11.0,124.0),(24.0,-64.0,20.0),(-5.0,40.0,64.0),(15.0,-2.0,9.0),(20.0,-40.0,41.0),(30.0,-26.0,42.0),(-2.0,-6.0,12.0),(5.0,-12.0,13.0),(17.0,-20.0,28.0),(32.0,-16.0,30.0),(15.0,-9.0,8.0),(28.0,-6.0,28.0),(12.0,-9.0,3.0),(25.0,-67.0,-63.0),(6.0,-4.0,4.0),(22.0,-72.0,-94.0),(15.0,-7.0,12.0),(36.0,14.0,1.0),(11.0,-3.0,5.0),(67.0,-74.0,-120.0),(82.0,-38.0,-77.0),(17.0,-5.0,2.0),(21.0,-15.0,1.0),(10.0,-1.0,10.0),(5.0,2.0,9.0),(11.0,0.0,-3.0),(14.0,4.0,0.0),(12.0,19.0,12.0),(9.0,8.0,9.0),(-16.0,42.0,105.0),(-65.0,63.0,110.0),(12.0,2.0,1.0),(30.0,-12.0,19.0),(18.0,9.0,0.0),(7.0,5.0,-1.0),(18.0,4.0,0.0),(43.0,27.0,-1.0),(11.0,1.0,0.0),(12.0,-9.0,1.0),(32.0,25.0,1.0),(17.0,14.0,-12.0),(57.0,56.0,-23.0),(52.0,37.0,-11.0),(54.0,-66.0,-80.0),(9.0,-1.0,0.0),(15.0,15.0,-7.0),(33.0,53.0,-29.0),(23.0,27.0,-13.0),(27.0,61.0,-44.0),(23.0,-157.0,-122.0),(-4.0,-82.0,-177.0),(-49.0,-1.0,-178.0),(-38.0,24.0,-73.0),(-2.0,19.0,9.0),(-42.0,40.0,-41.0),(-27.0,26.0,-28.0),(-33.0,11.0,-21.0),(-23.0,1.0,-4.0),(2.0,4.0,2.0),(-17.0,14.0,4.0),(7.0,11.0,8.0),(8.0,12.0,16.0),(2.0,4.0,11.0),(18.0,1.0,26.0),(5.0,5.0,13.0),(-5.0,-2.0,3.0),(28.0,-8.0,44.0),(-13.0,-41.0,98.0),(35.0,74.0,98.0),(16.0,205.0,25.0),(-108.0,149.0,-3.0),(32.0,0.0,24.0),(15.0,114.0,120.0),(-42.0,87.0,42.0),(-10.0,-150.0,177.0),(-99.0,-177.0,265.0),(-71.0,-34.0,191.0),(-87.0,-56.0,96.0),(-93.0,-29.0,58.0),(-82.0,9.0,-107.0),(-118.0,6.0,57.0),(-55.0,44.0,-96.0),(-26.0,68.0,-125.0),(25.0,30.0,-210.0),(50.0,147.0,-301.0),(85.0,129.0,-169.0),(-5.0,-106.0,-70.0),(111.0,-102.0,-24.0),(37.0,3.0,-6.0),(-92.0,-173.0,-39.0),(60.0,-208.0,-10.0),(77.0,-58.0,-67.0),(11.0,52.0,-96.0),(39.0,14.0,-29.0),(-3.0,0.0,-5.0),(10.0,-4.0,-10.0),(27.0,0.0,-17.0),(6.0,-4.0,-9.0),(15.0,-11.0,-12.0),(10.0,-10.0,-4.0),(-14.0,-15.0,-10.0),(3.0,-4.0,-1.0),(-24.0,-3.0,-3.0),(-37.0,-14.0,7.0),(-34.0,-28.0,15.0),(-45.0,-49.0,22.0),(2.0,-18.0,-9.0),(-50.0,-38.0,53.0),(-85.0,-25.0,119.0),(-96.0,68.0,114.0),(-103.0,174.0,89.0),(3.0,-65.0,42.0),(-41.0,92.0,122.0),(16.0,-8.0,7.0),(-2.0,34.0,99.0),(20.0,-47.0,35.0),(25.0,-31.0,44.0),(13.0,-26.0,23.0),(11.0,-20.0,24.0),(34.0,-22.0,28.0),(15.0,-4.0,20.0),(36.0,-16.0,28.0),(25.0,-74.0,-96.0),(15.0,-3.0,10.0),(91.0,-77.0,-108.0),(33.0,4.0,7.0),(89.0,-43.0,-84.0),(84.0,-12.0,-57.0),(2.0,9.0,8.0),(2.0,-2.0,11.0),(9.0,3.0,-8.0),(12.0,-7.0,-2.0),(5.0,22.0,94.0),(-18.0,47.0,113.0),(29.0,-1.0,17.0),(28.0,-8.0,-14.0),(30.0,15.0,-5.0),(8.0,1.0,1.0),(11.0,-9.0,5.0),(10.0,4.0,0.0),(21.0,32.0,-3.0),(7.0,7.0,0.0),(16.0,-3.0,0.0),(67.0,30.0,-8.0),(14.0,16.0,22.0),(41.0,46.0,-8.0),(55.0,-107.0,-125.0),(4.0,18.0,-10.0),(9.0,0.0,-4.0),(7.0,14.0,-6.0),(10.0,42.0,-16.0),(9.0,16.0,-16.0),(34.0,5.0,-31.0),(-2.0,-66.0,-185.0),(-43.0,0.0,-184.0),(-33.0,22.0,-82.0),(-31.0,44.0,-53.0),(-10.0,14.0,16.0),(-34.0,39.0,-26.0),(-33.0,15.0,-19.0),(-29.0,5.0,-7.0),(-25.0,10.0,7.0),(10.0,0.0,15.0),(-10.0,18.0,5.0),(8.0,7.0,9.0),(17.0,8.0,15.0),(0.0,4.0,7.0),(-3.0,-3.0,6.0),(-37.0,-26.0,60.0),(-88.0,21.0,12.0),(-73.0,-30.0,-46.0),(-17.0,27.0,-70.0),(0.0,1.0,-6.0),(4.0,-4.0,-7.0),(22.0,-7.0,-7.0),(10.0,-6.0,-5.0),(-5.0,-17.0,-9.0),(14.0,0.0,-9.0),(-20.0,-12.0,-17.0),(-29.0,-8.0,-2.0),(-36.0,-18.0,5.0),(-39.0,-42.0,11.0),(-1.0,-15.0,-18.0),(-41.0,-50.0,39.0),(-46.0,-37.0,62.0),(-81.0,-25.0,124.0),(-93.0,47.0,122.0),(12.0,-1.0,34.0),(-108.0,122.0,105.0),(12.0,-47.0,33.0),(9.0,-12.0,10.0),(-35.0,98.0,98.0),(37.0,-35.0,42.0),(32.0,-51.0,54.0),(3.0,-10.0,21.0),(29.0,-23.0,17.0),(9.0,10.0,7.0),(8.0,-1.0,7.0),(116.0,-110.0,-123.0),(16.0,-9.0,23.0),(113.0,-57.0,-86.0),(4.0,16.0,21.0),(90.0,-11.0,-58.0),(29.0,2.0,-17.0),(4.0,9.0,-1.0),(-9.0,10.0,24.0),(3.0,0.0,0.0),(2.0,0.0,1.0),(10.0,-11.0,-24.0),(5.0,-6.0,7.0),(10.0,3.0,32.0),(7.0,21.0,95.0),(22.0,-13.0,-11.0),(31.0,14.0,1.0),(11.0,0.0,0.0),(13.0,-13.0,1.0),(12.0,4.0,1.0),(25.0,35.0,1.0),(10.0,5.0,1.0),(25.0,-4.0,1.0),(70.0,27.0,8.0),(11.0,2.0,4.0),(20.0,-7.0,6.0),(11.0,-45.0,-189.0),(37.0,10.0,-5.0),(2.0,20.0,7.0),(-8.0,21.0,-19.0),(-74.0,-6.0,-153.0),(-1.0,10.0,3.0),(11.0,13.0,-14.0),(76.0,5.0,154.0),(21.0,17.0,-44.0),(-17.0,3.0,-202.0),(-29.0,20.0,-87.0),(-27.0,44.0,-61.0),(-42.0,51.0,-25.0),(6.0,12.0,7.0),(-34.0,18.0,-15.0),(-32.0,10.0,-10.0),(-31.0,12.0,3.0),(-14.0,12.0,8.0),(12.0,-1.0,20.0),(4.0,9.0,14.0),(-1.0,-2.0,6.0),(-22.0,-4.0,-31.0),(-33.0,0.0,-29.0),(-10.0,-1.0,-3.0),(-12.0,0.0,0.0),(-40.0,-3.0,14.0),(-32.0,3.0,19.0),(1.0,0.0,-7.0),(10.0,-8.0,-10.0),(18.0,3.0,-14.0),(-9.0,-15.0,-14.0),(-27.0,-14.0,-14.0),(-32.0,-12.0,-1.0),(-35.0,-22.0,0.0),(10.0,-11.0,-3.0),(-45.0,-55.0,8.0),(-41.0,-50.0,47.0),(-44.0,-35.0,69.0),(-59.0,-27.0,149.0),(120.0,2.0,-34.0),(8.0,-12.0,17.0),(-122.0,-7.0,59.0),(-119.0,62.0,92.0),(11.0,-44.0,16.0),(8.0,-14.0,7.0),(3.0,4.0,8.0),(-102.0,135.0,109.0),(3.0,-23.0,4.0),(35.0,-42.0,28.0),(35.0,-17.0,-9.0),(49.0,-19.0,49.0),(13.0,4.0,9.0),(8.0,-6.0,5.0),(21.0,-30.0,17.0),(8.0,-2.0,7.0),(12.0,11.0,2.0),(106.0,-61.0,-84.0),(4.0,1.0,6.0),(98.0,-30.0,-78.0),(17.0,-3.0,22.0),(-1.0,12.0,12.0),(0.0,5.0,12.0),(46.0,1.0,-34.0),(1.0,17.0,8.0),(0.0,3.0,11.0),(7.0,-3.0,-9.0),(11.0,-14.0,-3.0),(13.0,5.0,57.0),(10.0,-4.0,-10.0),(9.0,-9.0,-9.0),(23.0,8.0,-7.0),(10.0,0.0,-2.0),(15.0,-11.0,-5.0),(13.0,3.0,-3.0),(30.0,29.0,-12.0),(11.0,8.0,-6.0),(26.0,2.0,8.0),(66.0,26.0,-28.0),(17.0,2.0,14.0),(-65.0,-19.0,-174.0),(13.0,-10.0,-17.0),(21.0,-4.0,-13.0),(19.0,18.0,-12.0),(4.0,18.0,6.0),(-37.0,22.0,-85.0),(-9.0,14.0,40.0),(16.0,10.0,-2.0),(61.0,15.0,1.0),(-34.0,12.0,-94.0),(-28.0,27.0,-71.0),(-37.0,43.0,-39.0),(-27.0,22.0,-16.0),(37.0,44.0,2.0),(-32.0,12.0,-12.0),(-33.0,18.0,-1.0),(-12.0,15.0,11.0),(0.0,4.0,9.0),(-31.0,0.0,-26.0),(-11.0,0.0,-4.0),(-11.0,-1.0,1.0),(-38.0,-4.0,11.0),(4.0,-3.0,-9.0),(-7.0,-17.0,-15.0),(-29.0,-20.0,-10.0),(-32.0,-15.0,0.0),(39.0,-41.0,12.0),(-31.0,-24.0,5.0),(-45.0,-47.0,23.0),(-41.0,-36.0,55.0),(-49.0,-27.0,74.0),(62.0,-6.0,23.0),(13.0,-7.0,10.0),(-44.0,-22.0,50.0),(-112.0,-17.0,74.0),(-7.0,-27.0,9.0),(10.0,-17.0,-2.0),(-108.0,50.0,114.0),(29.0,-22.0,29.0),(17.0,11.0,6.0),(11.0,0.0,2.0),(61.0,-10.0,38.0),(15.0,10.0,13.0),(9.0,-4.0,7.0),(25.0,-29.0,18.0),(10.0,-2.0,7.0),(100.0,-26.0,-85.0),(5.0,14.0,11.0),(73.0,-4.0,-41.0),(1.0,2.0,8.0),(4.0,2.0,13.0),(2.0,13.0,10.0),(1.0,18.0,6.0),(1.0,1.0,0.0),(2.0,-1.0,0.0),(8.0,-17.0,-2.0),(8.0,-12.0,-7.0),(12.0,-1.0,-7.0),(4.0,-1.0,-5.0),(8.0,-9.0,-15.0),(11.0,2.0,-11.0),(34.0,21.0,-40.0),(10.0,4.0,-9.0),(7.0,-1.0,-8.0),(17.0,0.0,-11.0),(35.0,20.0,-19.0),(17.0,19.0,-4.0),(-44.0,-3.0,-83.0),(5.0,1.0,-7.0),(10.0,-3.0,-20.0),(25.0,7.0,-29.0),(27.0,25.0,-8.0),(-15.0,28.0,-49.0),(19.0,23.0,19.0),(-22.0,30.0,-61.0),(-30.0,45.0,-40.0),(-20.0,26.0,-23.0),(-14.0,25.0,-19.0),(-24.0,33.0,-10.0),(-11.0,35.0,3.0),(-6.0,-4.0,-1.0),(-5.0,-4.0,-3.0),(-5.0,0.0,-1.0),(-4.0,0.0,0.0),(-7.0,5.0,0.0),(-6.0,1.0,-2.0),(-5.0,-36.0,-6.0),(-24.0,-35.0,2.0),(-18.0,-26.0,12.0),(-25.0,-29.0,14.0),(-36.0,-49.0,27.0),(-29.0,-36.0,49.0),(-9.0,-36.0,46.0),(-46.0,-37.0,63.0),(10.0,-17.0,-2.0),(17.0,-15.0,21.0),(-105.0,-5.0,111.0),(6.0,20.0,16.0),(22.0,1.0,0.0),(44.0,-13.0,51.0),(24.0,3.0,7.0),(7.0,-5.0,12.0),(24.0,-24.0,29.0),(88.0,-1.0,-49.0),(4.0,0.0,16.0),(16.0,12.0,-9.0),(0.0,14.0,11.0),(1.0,21.0,11.0),(0.0,0.0,0.0),(0.0,-1.0,-1.0),(10.0,-20.0,-7.0),(9.0,-12.0,-7.0),(7.0,3.0,-18.0),(24.0,22.0,-78.0),(8.0,3.0,-16.0),(4.0,-10.0,-9.0),(8.0,-1.0,-22.0),(30.0,18.0,-20.0),(-19.0,8.0,-49.0),(12.0,15.0,-7.0),(5.0,3.0,-7.0),(11.0,2.0,-20.0),(28.0,19.0,-31.0),(-14.0,41.0,-55.0),(26.0,26.0,6.0),(-25.0,54.0,-41.0),(-18.0,29.0,-18.0),(-15.0,22.0,-15.0),(-19.0,32.0,-10.0),(-10.0,-10.0,3.0),(-9.0,-7.0,8.0),(-3.0,0.0,0.0),(-2.0,1.0,-1.0),(-5.0,7.0,-12.0),(-9.0,7.0,-5.0),(-19.0,-35.0,3.0),(-18.0,-23.0,8.0),(-21.0,-30.0,11.0),(-30.0,-59.0,29.0),(-23.0,-42.0,36.0),(-20.0,-33.0,42.0),(30.0,-23.0,20.0),(16.0,-4.0,37.0),(-65.0,-16.0,60.0),(8.0,10.0,18.0),(7.0,-1.0,8.0),(19.0,-17.0,13.0),(31.0,-12.0,31.0),(11.0,4.0,16.0),(3.0,2.0,9.0),(6.0,-2.0,9.0),(42.0,17.0,-37.0),(-10.0,-19.0,78.0),(5.0,16.0,5.0),(0.0,18.0,11.0),(0.0,0.0,0.0),(1.0,-1.0,0.0),(8.0,-17.0,-9.0),(21.0,26.0,-98.0),(10.0,0.0,-28.0),(3.0,-10.0,-13.0),(5.0,-3.0,-30.0),(-8.0,25.0,-32.0),(16.0,17.0,-46.0),(12.0,9.0,-6.0),(3.0,5.0,-9.0),(9.0,9.0,-22.0),(-24.0,74.0,-51.0),(36.0,19.0,-23.0),(-15.0,34.0,-13.0),(-10.0,21.0,-6.0),(-21.0,-3.0,17.0),(-4.0,0.0,0.0),(-4.0,0.0,-2.0),(-12.0,1.0,-23.0),(-11.0,-22.0,3.0),(-16.0,-36.0,7.0),(-29.0,-69.0,33.0),(-19.0,-45.0,48.0),(26.0,-17.0,41.0),(4.0,-1.0,23.0),(-32.0,-12.0,42.0),(5.0,-2.0,8.0),(18.0,-15.0,11.0),(28.0,-12.0,32.0),(2.0,4.0,24.0),(-2.0,9.0,9.0),(17.0,18.0,-26.0),(2.0,0.0,29.0),(2.0,12.0,-1.0),(3.0,0.0,1.0),(1.0,0.0,-1.0),(10.0,3.0,-56.0),(2.0,32.0,-70.0),(7.0,66.0,-80.0),(2.0,60.0,-39.0),(-6.0,3.0,0.0),(-5.0,-4.0,-1.0),(-9.0,-46.0,8.0),(-22.0,-78.0,41.0),(6.0,-8.0,26.0),(2.0,-5.0,9.0),(-26.0,-28.0,44.0),(14.0,-12.0,12.0),(19.0,-9.0,34.0),(0.0,5.0,30.0),(7.0,23.0,-15.0),(4.0,7.0,0.0),(6.0,38.0,-81.0),(1.0,65.0,-71.0),(-4.0,-13.0,2.0),(-11.0,-84.0,56.0),(10.0,-14.0,50.0),(1.0,33.0,-25.0),(-329.0,206.0,-117.0),(0.0,1.0,-1.0),(0.0,1.0,-1.0),(3.0,-2.0,-4.0),(1.0,-2.0,0.0),(0.0,0.0,1.0),(-1.0,0.0,2.0),(-1.0,1.0,4.0),(1.0,1.0,7.0),(-1.0,2.0,0.0),(0.0,0.0,-1.0),(0.0,0.0,-1.0),(3.0,-1.0,-3.0),(2.0,-1.0,0.0),(0.0,-1.0,1.0),(0.0,0.0,1.0),(11.0,5.0,21.0),(-3.0,1.0,3.0),(-1.0,2.0,0.0),(0.0,1.0,-1.0),(0.0,0.0,-1.0),(3.0,-2.0,-3.0),(2.0,-1.0,0.0),(1.0,-1.0,1.0),(8.0,7.0,15.0),(0.0,0.0,1.0),(-4.0,3.0,2.0),(-1.0,1.0,0.0),(0.0,1.0,0.0),(1.0,0.0,-2.0),(3.0,-2.0,-2.0),(2.0,-1.0,0.0),(17.0,16.0,7.0),(0.0,-1.0,1.0),(-1.0,0.0,2.0),(-3.0,3.0,2.0),(-1.0,2.0,0.0),(0.0,0.0,-1.0),(1.0,0.0,-2.0),(4.0,-1.0,-2.0),(14.0,14.0,3.0),(0.0,-2.0,0.0),(0.0,0.0,2.0),(0.0,0.0,2.0),(-3.0,2.0,2.0),(0.0,2.0,0.0),(0.0,1.0,-1.0),(1.0,0.0,-1.0),(11.0,10.0,3.0),(2.0,-1.0,-3.0),(0.0,-2.0,0.0),(0.0,-1.0,2.0),(-1.0,0.0,2.0),(-2.0,3.0,3.0),(0.0,1.0,0.0),(0.0,1.0,-1.0),(6.0,10.0,4.0),(1.0,0.0,-2.0),(2.0,-2.0,-3.0),(0.0,-1.0,0.0),(0.0,0.0,2.0),(-1.0,1.0,3.0),(-2.0,2.0,4.0),(0.0,1.0,0.0),(1.0,11.0,1.0),(-2.0,12.0,-2.0),(-2.0,4.0,-6.0),(1.0,-1.0,-1.0),(3.0,-4.0,5.0),(2.0,-12.0,2.0),(1.0,-1.0,-3.0),(4.0,-1.0,-3.0),(0.0,0.0,0.0),(0.0,1.0,3.0),(-1.0,0.0,2.0),(-5.0,2.0,3.0),(-1.0,12.0,-3.0),(-2.0,4.0,-5.0),(1.0,-2.0,-3.0),(3.0,-4.0,4.0),(7.0,-1.0,-5.0),(1.0,0.0,0.0),(-1.0,1.0,3.0),(-2.0,1.0,2.0),(-1.0,3.0,-6.0),(1.0,-1.0,-3.0),(1.0,0.0,0.0),(0.0,1.0,1.0),(23.0,-16.0,-15.0),(-13.0,7.0,5.0),(-10.0,3.0,5.0),(-4.0,1.0,3.0),(1.0,2.0,2.0),(5.0,0.0,-1.0),(10.0,-4.0,-8.0),(13.0,-7.0,-6.0),(10.0,-6.0,-4.0),(4.0,-7.0,-9.0),(0.0,-2.0,-3.0),(-2.0,-1.0,-2.0),(-1.0,1.0,2.0),(-2.0,6.0,11.0),(4.0,-2.0,3.0),(0.0,-13.0,-5.0),(-4.0,-11.0,-10.0),(-6.0,-14.0,-11.0),(-12.0,-12.0,-4.0),(-11.0,7.0,14.0),(12.0,13.0,4.0),(6.0,13.0,11.0),(4.0,10.0,6.0),(-2.0,13.0,1.0),(-13.0,8.0,4.0),(-10.0,5.0,6.0),(-4.0,0.0,2.0),(0.0,0.0,4.0),(6.0,0.0,-3.0),(7.0,-3.0,-5.0),(1.0,-2.0,-2.0),(3.0,-1.0,-1.0),(10.0,-6.0,-4.0),(13.0,-5.0,-5.0),(6.0,-5.0,-8.0),(0.0,-1.0,-2.0),(-1.0,-1.0,-2.0),(0.0,0.0,1.0),(1.0,-14.0,-11.0),(-3.0,-12.0,-11.0),(-5.0,-14.0,-8.0),(-7.0,-11.0,-5.0),(-7.0,-11.0,-8.0),(-17.0,3.0,16.0),(-14.0,6.0,17.0),(-11.0,7.0,13.0),(13.0,16.0,3.0),(11.0,12.0,4.0),(6.0,13.0,9.0),(4.0,10.0,3.0),(-8.0,5.0,2.0),(-3.0,0.0,3.0),(0.0,0.0,4.0),(4.0,0.0,-2.0),(5.0,-5.0,-5.0),(1.0,0.0,-1.0),(2.0,0.0,0.0),(11.0,-6.0,-6.0),(13.0,-6.0,-10.0),(7.0,-6.0,-14.0),(0.0,-2.0,-4.0),(-1.0,-1.0,-3.0),(-4.0,-12.0,-9.0),(-3.0,-14.0,-7.0),(-7.0,-11.0,-6.0),(-6.0,-11.0,-9.0),(-5.0,-14.0,-12.0),(-3.0,2.0,1.0),(-20.0,3.0,16.0),(-19.0,4.0,19.0),(-14.0,6.0,15.0),(-9.0,7.0,8.0),(17.0,18.0,7.0),(13.0,16.0,4.0),(12.0,11.0,4.0),(6.0,10.0,5.0),(-5.0,-1.0,4.0),(0.0,0.0,4.0),(5.0,0.0,-3.0),(5.0,-5.0,-6.0),(1.0,0.0,-1.0),(2.0,-1.0,-1.0),(10.0,-6.0,-9.0),(15.0,-6.0,-15.0),(7.0,-6.0,-14.0),(0.0,-2.0,-3.0),(-4.0,-16.0,-7.0),(-7.0,-11.0,-6.0),(-6.0,-11.0,-9.0),(-5.0,-14.0,-13.0),(-4.0,-11.0,-15.0),(-4.0,-12.0,-20.0),(0.0,-3.0,-6.0),(0.0,2.0,0.0),(0.0,4.0,6.0),(4.0,12.0,21.0),(-3.0,2.0,1.0),(-19.0,4.0,13.0),(-22.0,5.0,18.0),(-15.0,6.0,18.0),(-11.0,6.0,7.0),(-3.0,0.0,2.0),(8.0,9.0,17.0),(16.0,18.0,8.0),(14.0,15.0,4.0),(10.0,10.0,4.0),(0.0,-2.0,2.0),(5.0,-2.0,-4.0),(5.0,-4.0,-7.0),(2.0,0.0,-2.0),(1.0,-1.0,-1.0),(10.0,-6.0,-10.0),(15.0,-8.0,-15.0),(8.0,-6.0,-11.0),(-8.0,-12.0,-6.0),(-6.0,-12.0,-9.0),(-6.0,-14.0,-13.0),(-3.0,-10.0,-15.0),(-5.0,-12.0,-21.0),(0.0,-3.0,-6.0),(-1.0,3.0,0.0),(0.0,4.0,6.0),(-17.0,5.0,12.0),(-20.0,7.0,14.0),(-19.0,7.0,16.0),(-13.0,6.0,8.0),(-3.0,-1.0,1.0),(0.0,-3.0,-9.0),(2.0,-2.0,1.0),(0.0,2.0,10.0),(7.0,8.0,28.0),(8.0,9.0,16.0),(15.0,17.0,10.0),(14.0,16.0,3.0),(4.0,-3.0,-3.0),(6.0,-4.0,-7.0),(0.0,0.0,-2.0),(2.0,-2.0,-1.0),(10.0,-6.0,-10.0),(12.0,-8.0,-16.0),(-10.0,-13.0,-6.0),(-9.0,-15.0,-13.0),(-2.0,-8.0,-18.0),(-3.0,-11.0,-22.0),(0.0,-2.0,-7.0),(-1.0,3.0,0.0),(-19.0,7.0,13.0),(-19.0,9.0,15.0),(-12.0,3.0,8.0),(2.0,-2.0,1.0),(1.0,1.0,10.0),(6.0,8.0,27.0),(7.0,8.0,15.0),(16.0,17.0,8.0),(6.0,-5.0,-6.0),(1.0,0.0,-2.0),(2.0,-1.0,-1.0),(8.0,-6.0,-10.0),(-13.0,-16.0,-11.0),(-5.0,-7.0,-18.0),(0.0,-9.0,-26.0),(2.0,-3.0,-8.0),(-20.0,8.0,15.0),(-2.0,3.0,10.0),(5.0,8.0,28.0),(7.0,6.0,14.0),(2.0,0.0,-2.0),(1.0,-1.0,-1.0),(-7.0,-8.0,-16.0),(-4.0,-7.0,-27.0),(-1.0,2.0,2.0),(4.0,8.0,28.0),(79.0,74.0,17.0),(0.0,-1.0,-5.0),(-1.0,0.0,-6.0),(-1.0,-1.0,-2.0),(1.0,1.0,6.0),(0.0,0.0,6.0),(3.0,0.0,3.0),(1.0,1.0,1.0),(3.0,1.0,0.0),(1.0,0.0,-4.0),(0.0,-1.0,-6.0),(-2.0,-1.0,-2.0),(0.0,0.0,6.0),(0.0,0.0,4.0),(3.0,-10.0,-11.0),(-2.0,1.0,3.0),(1.0,0.0,1.0),(3.0,0.0,-1.0),(1.0,-1.0,-7.0),(0.0,-1.0,-6.0),(-2.0,-1.0,-2.0),(0.0,0.0,4.0),(-2.0,-10.0,-11.0),(-2.0,0.0,6.0),(-1.0,1.0,4.0),(1.0,0.0,0.0),(3.0,-2.0,-3.0),(1.0,0.0,-6.0),(1.0,0.0,-5.0),(-1.0,0.0,-2.0),(2.0,-14.0,-10.0),(-4.0,0.0,4.0),(-5.0,0.0,7.0),(-3.0,2.0,3.0),(2.0,-2.0,0.0),(3.0,-2.0,-2.0),(5.0,1.0,-7.0),(3.0,0.0,-4.0),(-2.0,-10.0,-10.0),(-1.0,1.0,-1.0),(-4.0,-1.0,6.0),(-6.0,-1.0,7.0),(-4.0,0.0,4.0),(1.0,-2.0,1.0),(5.0,0.0,-4.0),(5.0,1.0,-8.0),(-3.0,-12.0,-9.0),(4.0,2.0,-6.0),(-1.0,1.0,-1.0),(-4.0,-1.0,7.0),(-7.0,-2.0,8.0),(-5.0,0.0,4.0),(1.0,-2.0,1.0),(4.0,-1.0,-4.0),(-2.0,-12.0,-13.0),(7.0,3.0,-9.0),(3.0,1.0,-5.0),(0.0,2.0,0.0),(-5.0,-2.0,5.0),(-7.0,-3.0,8.0),(-5.0,0.0,4.0),(0.0,-2.0,0.0),(-4.0,-8.0,-13.0),(5.0,0.0,-3.0),(6.0,3.0,-6.0),(4.0,2.0,-5.0),(-1.0,1.0,0.0),(-4.0,-2.0,5.0),(-7.0,-2.0,6.0),(-5.0,0.0,2.0),(-2.0,-8.0,-22.0),(1.0,-2.0,-7.0),(0.0,-1.0,0.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,1.0,6.0),(4.0,0.0,-3.0),(5.0,2.0,-5.0),(3.0,1.0,-6.0),(-1.0,1.0,0.0),(-4.0,-1.0,6.0),(-4.0,-2.0,4.0),(0.0,-3.0,-6.0),(0.0,0.0,0.0),(1.0,-1.0,0.0),(0.0,0.0,0.0),(5.0,2.0,-6.0),(2.0,1.0,-5.0),(-1.0,1.0,-1.0),(-2.0,-1.0,5.0),(0.0,-1.0,0.0),(0.0,0.0,0.0),(2.0,1.0,-5.0),(0.0,1.0,0.0),(-36.0,119.0,151.0),(-5.0,3.0,1.0),(-4.0,4.0,0.0),(3.0,0.0,0.0),(5.0,-4.0,0.0),(4.0,-4.0,-1.0),(0.0,0.0,4.0),(-1.0,0.0,0.0),(0.0,3.0,4.0),(-5.0,4.0,1.0),(-3.0,3.0,0.0),(3.0,0.0,0.0),(5.0,-3.0,0.0),(2.0,-3.0,-1.0),(-12.0,0.0,13.0),(0.0,-3.0,-3.0),(-2.0,1.0,0.0),(-3.0,3.0,3.0),(-5.0,5.0,0.0),(-3.0,3.0,0.0),(3.0,0.0,2.0),(4.0,-4.0,1.0),(-14.0,0.0,4.0),(4.0,-6.0,0.0),(2.0,-1.0,-3.0),(-1.0,1.0,-1.0),(-4.0,3.0,3.0),(-4.0,5.0,0.0),(-3.0,4.0,0.0),(1.0,-1.0,2.0),(-21.0,1.0,2.0),(5.0,-5.0,0.0),(5.0,-7.0,0.0),(3.0,-2.0,-3.0),(0.0,1.0,-1.0),(-4.0,3.0,1.0),(-5.0,7.0,0.0),(-5.0,4.0,0.0),(-19.0,-3.0,-3.0),(0.0,-1.0,3.0),(4.0,-5.0,1.0),(6.0,-8.0,0.0),(5.0,-3.0,-2.0),(0.0,1.0,-2.0),(-5.0,4.0,1.0),(-6.0,7.0,-1.0),(-25.0,-5.0,-6.0),(-5.0,6.0,0.0),(0.0,-1.0,2.0),(5.0,-7.0,2.0),(6.0,-10.0,1.0),(5.0,-3.0,-1.0),(0.0,2.0,-1.0),(-6.0,3.0,0.0),(-36.0,-6.0,0.0),(-5.0,9.0,0.0),(-4.0,5.0,0.0),(0.0,-1.0,2.0),(4.0,-6.0,0.0),(5.0,-9.0,0.0),(5.0,-3.0,-3.0),(0.0,0.0,-1.0),(-28.0,-3.0,0.0),(-3.0,2.0,1.0),(-4.0,7.0,0.0),(-3.0,6.0,0.0),(0.0,-2.0,2.0),(3.0,-5.0,0.0),(4.0,-8.0,0.0),(2.0,-2.0,-3.0),(-27.0,1.0,-8.0),(-7.0,2.0,-2.0),(0.0,0.0,0.0),(0.0,0.0,-1.0),(1.0,0.0,0.0),(6.0,0.0,2.0),(-3.0,2.0,1.0),(-2.0,6.0,0.0),(-3.0,4.0,-1.0),(0.0,-1.0,2.0),(3.0,-6.0,1.0),(2.0,-5.0,0.0),(-7.0,2.0,-2.0),(0.0,0.0,-1.0),(0.0,2.0,-1.0),(0.0,0.0,0.0),(-3.0,5.0,-1.0),(-2.0,4.0,0.0),(0.0,-1.0,2.0),(2.0,-3.0,0.0),(-1.0,0.0,0.0),(0.0,0.0,-2.0),(-2.0,5.0,0.0),(0.0,0.0,0.0),(196.0,5.0,-11.0),(-4.0,1.0,2.0),(-4.0,2.0,1.0),(3.0,0.0,0.0),(4.0,-1.0,-1.0),(4.0,-1.0,-1.0),(0.0,1.0,8.0),(-1.0,-2.0,-5.0),(-1.0,0.0,0.0),(-1.0,2.0,5.0),(-4.0,1.0,3.0),(-4.0,2.0,2.0),(2.0,0.0,0.0),(4.0,-1.0,-1.0),(-12.0,-4.0,13.0),(7.0,-3.0,-4.0),(0.0,-2.0,-4.0),(-2.0,1.0,0.0),(-3.0,1.0,5.0),(-7.0,3.0,3.0),(-4.0,2.0,2.0),(2.0,0.0,1.0),(-10.0,-5.0,6.0),(5.0,-3.0,-3.0),(6.0,-4.0,-3.0),(2.0,0.0,-4.0),(-2.0,1.0,0.0),(-3.0,1.0,4.0),(-7.0,4.0,3.0),(-4.0,2.0,3.0),(-17.0,-5.0,6.0),(2.0,-2.0,1.0),(5.0,-3.0,-4.0),(7.0,-5.0,-4.0),(3.0,0.0,-4.0),(-1.0,2.0,-1.0),(-4.0,1.0,4.0),(-7.0,3.0,4.0),(-18.0,-6.0,1.0),(-5.0,2.0,3.0),(0.0,-2.0,1.0),(6.0,-4.0,-3.0),(8.0,-5.0,-4.0),(4.0,-1.0,-5.0),(0.0,2.0,-1.0),(-5.0,1.0,5.0),(-23.0,-11.0,0.0),(-9.0,7.0,2.0),(-5.0,4.0,2.0),(0.0,-2.0,1.0),(7.0,-5.0,-2.0),(8.0,-7.0,-3.0),(4.0,0.0,-3.0),(0.0,1.0,-2.0),(-33.0,-11.0,-6.0),(-5.0,3.0,4.0),(-9.0,8.0,3.0),(-4.0,3.0,3.0),(0.0,-1.0,0.0),(6.0,-5.0,-3.0),(8.0,-8.0,-3.0),(4.0,-3.0,-4.0),(-28.0,-3.0,-6.0),(-31.0,0.0,-3.0),(-7.0,0.0,0.0),(-1.0,0.0,0.0),(0.0,1.0,0.0),(1.0,0.0,0.0),(8.0,0.0,0.0),(29.0,1.0,4.0),(-3.0,2.0,2.0),(-6.0,6.0,5.0),(-4.0,3.0,2.0),(1.0,-1.0,0.0),(4.0,-4.0,-2.0),(6.0,-7.0,-5.0),(-31.0,0.0,-3.0),(-7.0,0.0,0.0),(-1.0,0.0,0.0),(0.0,1.0,0.0),(1.0,1.0,0.0),(7.0,0.0,0.0),(-5.0,3.0,4.0),(-3.0,4.0,1.0),(1.0,-2.0,0.0),(3.0,-3.0,-2.0),(-7.0,0.0,0.0),(-1.0,0.0,0.0),(0.0,1.0,0.0),(0.0,0.0,0.0),(-3.0,3.0,2.0),(0.0,-1.0,0.0),(-1.0,0.0,0.0),(0.0,0.0,0.0),(41.0,-10.0,-18.0),(0.0,0.0,2.0),(-2.0,1.0,2.0),(-4.0,2.0,3.0),(-1.0,1.0,0.0),(1.0,0.0,-2.0),(1.0,-1.0,-1.0),(5.0,-2.0,-4.0),(9.0,-1.0,-1.0),(0.0,-1.0,0.0),(0.0,0.0,2.0),(-2.0,0.0,2.0),(-4.0,3.0,3.0),(0.0,0.0,0.0),(0.0,0.0,-1.0),(2.0,0.0,-1.0),(28.0,-1.0,0.0),(4.0,-2.0,-2.0),(0.0,-1.0,0.0),(0.0,0.0,1.0),(-2.0,0.0,2.0),(-4.0,2.0,3.0),(0.0,2.0,0.0),(1.0,0.0,-1.0),(20.0,2.0,7.0),(1.0,-1.0,-2.0),(4.0,-2.0,-2.0),(0.0,-1.0,0.0),(-1.0,0.0,2.0),(-1.0,1.0,2.0),(-4.0,2.0,3.0),(0.0,1.0,0.0),(27.0,12.0,8.0),(0.0,1.0,-2.0),(2.0,0.0,-2.0),(3.0,-2.0,-3.0),(0.0,-1.0,0.0),(-1.0,-1.0,2.0),(-1.0,0.0,2.0),(-2.0,2.0,3.0),(22.0,13.0,-1.0),(0.0,1.0,0.0),(0.0,1.0,-2.0),(1.0,0.0,-2.0),(2.0,-1.0,-3.0),(0.0,-2.0,0.0),(0.0,0.0,2.0),(0.0,0.0,2.0),(14.0,9.0,1.0),(-2.0,2.0,2.0),(0.0,1.0,0.0),(0.0,0.0,-2.0),(0.0,0.0,-2.0),(2.0,-1.0,-2.0),(1.0,-1.0,0.0),(1.0,-1.0,1.0),(11.0,6.0,-3.0),(-1.0,1.0,2.0),(-3.0,1.0,3.0),(-1.0,1.0,0.0),(0.0,0.0,-2.0),(0.0,0.0,-2.0),(3.0,-2.0,-3.0),(1.0,0.0,0.0),(10.0,6.0,-6.0),(11.0,7.0,-13.0),(1.0,2.0,-6.0),(2.0,0.0,0.0),(-2.0,-3.0,7.0),(-12.0,-6.0,13.0),(0.0,0.0,2.0),(-3.0,2.0,3.0),(-2.0,0.0,0.0),(-1.0,0.0,-1.0),(0.0,0.0,-1.0),(4.0,-1.0,-4.0),(10.0,7.0,-12.0),(1.0,2.0,-6.0),(4.0,0.0,0.0),(-2.0,-3.0,7.0),(-5.0,4.0,5.0),(-4.0,0.0,0.0),(-1.0,0.0,0.0),(1.0,0.0,-1.0),(0.0,2.0,-6.0),(5.0,1.0,0.0),(-4.0,0.0,1.0),(-1.0,-1.0,0.0),(282.0,-367.0,277.0),(0.0,3.0,0.0),(-1.0,0.0,0.0),(-8.0,-1.0,4.0),(-4.0,-2.0,0.0),(0.0,-3.0,0.0),(3.0,0.0,-1.0),(8.0,0.0,-4.0),(9.0,-1.0,-11.0),(2.0,2.0,0.0),(0.0,3.0,0.0),(-2.0,0.0,1.0),(-6.0,-1.0,2.0),(-2.0,-2.0,0.0),(0.0,-3.0,0.0),(1.0,-1.0,-1.0),(18.0,-2.0,-47.0),(6.0,3.0,-2.0),(2.0,2.0,0.0),(0.0,3.0,0.0),(-2.0,0.0,1.0),(-6.0,-3.0,3.0),(-2.0,-2.0,0.0),(0.0,-2.0,-1.0),(8.0,3.0,-44.0),(1.0,0.0,-1.0),(6.0,3.0,-2.0),(1.0,3.0,0.0),(0.0,3.0,0.0),(-1.0,0.0,1.0),(-6.0,-4.0,2.0),(-2.0,-1.0,0.0),(2.0,20.0,-69.0),(0.0,-3.0,0.0),(1.0,0.0,0.0),(6.0,4.0,0.0),(1.0,2.0,0.0),(-1.0,4.0,0.0),(-1.0,0.0,0.0),(-5.0,-3.0,0.0),(1.0,19.0,-51.0),(-1.0,-3.0,0.0),(1.0,-3.0,0.0),(1.0,0.0,0.0),(6.0,4.0,2.0),(1.0,3.0,0.0),(0.0,4.0,-1.0),(-1.0,1.0,0.0),(2.0,14.0,-25.0),(-5.0,-4.0,-2.0),(-1.0,-2.0,-2.0),(1.0,-2.0,-1.0),(2.0,0.0,0.0),(6.0,3.0,3.0),(0.0,3.0,1.0),(0.0,3.0,1.0),(8.0,18.0,-11.0),(-3.0,0.0,0.0),(-6.0,-3.0,-2.0),(0.0,-2.0,-3.0),(1.0,-1.0,-3.0),(2.0,0.0,0.0),(7.0,3.0,3.0),(1.0,2.0,1.0),(9.0,19.0,-1.0),(4.0,23.0,4.0),(0.0,10.0,7.0),(-2.0,-1.0,2.0),(0.0,-10.0,-7.0),(-6.0,-22.0,-4.0),(-4.0,0.0,0.0),(-7.0,-3.0,-1.0),(0.0,0.0,-3.0),(3.0,0.0,-3.0),(2.0,0.0,0.0),(8.0,2.0,2.0),(5.0,23.0,5.0),(-1.0,11.0,7.0),(-4.0,-2.0,5.0),(0.0,-9.0,-7.0),(-9.0,-1.0,-1.0),(0.0,0.0,-2.0),(1.0,0.0,-3.0),(4.0,1.0,0.0),(-1.0,10.0,6.0),(-4.0,-1.0,5.0),(-1.0,0.0,-1.0),(2.0,0.0,-2.0),(-42.0,-23.0,3.0),(21.0,13.0,3.0),(13.0,4.0,3.0),(6.0,1.0,1.0),(2.0,1.0,-6.0),(-4.0,0.0,-3.0),(-15.0,-4.0,-2.0),(-21.0,-12.0,-2.0),(-19.0,-14.0,-6.0),(-20.0,-14.0,-2.0),(-4.0,-5.0,3.0),(0.0,-1.0,4.0),(3.0,1.0,0.0),(19.0,14.0,0.0),(1.0,-11.0,-15.0),(-9.0,-30.0,-9.0),(-8.0,-19.0,4.0),(-12.0,-18.0,16.0),(-8.0,-10.0,28.0),(28.0,7.0,3.0),(6.0,14.0,-31.0),(10.0,20.0,-17.0),(7.0,21.0,-3.0),(6.0,29.0,18.0),(20.0,18.0,7.0),(13.0,8.0,5.0),(5.0,0.0,2.0),(4.0,0.0,-6.0),(-6.0,0.0,-5.0),(-10.0,-5.0,-2.0),(-3.0,-2.0,0.0),(-3.0,-2.0,-2.0),(-15.0,-13.0,-5.0),(-22.0,-15.0,-9.0),(-19.0,-8.0,-2.0),(-4.0,-4.0,1.0),(0.0,0.0,4.0),(1.0,1.0,0.0),(-12.0,-30.0,-6.0),(-10.0,-19.0,3.0),(-15.0,-16.0,14.0),(-10.0,-8.0,24.0),(-9.0,-7.0,37.0),(28.0,3.0,18.0),(31.0,4.0,11.0),(24.0,8.0,1.0),(6.0,16.0,-56.0),(5.0,16.0,-31.0),(8.0,21.0,-14.0),(6.0,22.0,0.0),(9.0,10.0,12.0),(5.0,-1.0,0.0),(4.0,0.0,-7.0),(-5.0,0.0,-5.0),(-9.0,-8.0,-6.0),(-3.0,-2.0,0.0),(-2.0,-1.0,-2.0),(-15.0,-13.0,-5.0),(-23.0,-16.0,0.0),(-22.0,-8.0,0.0),(-5.0,-2.0,1.0),(-1.0,-2.0,5.0),(-10.0,-18.0,2.0),(-16.0,-16.0,14.0),(-11.0,-8.0,24.0),(-10.0,-8.0,35.0),(-11.0,-9.0,50.0),(4.0,1.0,5.0),(28.0,4.0,28.0),(31.0,2.0,17.0),(30.0,2.0,6.0),(18.0,8.0,0.0),(4.0,22.0,-73.0),(3.0,18.0,-54.0),(5.0,16.0,-27.0),(7.0,21.0,-11.0),(5.0,-2.0,0.0),(1.0,-3.0,-6.0),(-5.0,-1.0,-7.0),(-9.0,-8.0,-3.0),(-2.0,-1.0,0.0),(-3.0,-4.0,0.0),(-15.0,-12.0,-2.0),(-25.0,-14.0,0.0),(-25.0,-7.0,-1.0),(-4.0,-2.0,1.0),(-16.0,-17.0,15.0),(-12.0,-8.0,26.0),(-10.0,-8.0,34.0),(-14.0,-11.0,49.0),(-15.0,-7.0,36.0),(-24.0,-4.0,17.0),(-8.0,0.0,1.0),(1.0,3.0,0.0),(10.0,0.0,0.0),(24.0,4.0,-16.0),(4.0,2.0,5.0),(29.0,4.0,32.0),(32.0,6.0,22.0),(32.0,3.0,4.0),(20.0,5.0,4.0),(4.0,-1.0,3.0),(11.0,5.0,-47.0),(4.0,21.0,-72.0),(2.0,19.0,-54.0),(5.0,15.0,-28.0),(0.0,-5.0,-3.0),(-7.0,-4.0,-6.0),(-8.0,-8.0,-1.0),(-2.0,0.0,0.0),(-3.0,-3.0,-2.0),(-17.0,-11.0,0.0),(-27.0,-11.0,-2.0),(-27.0,-6.0,-1.0),(-12.0,-8.0,25.0),(-10.0,-8.0,36.0),(-13.0,-11.0,52.0),(-15.0,-7.0,35.0),(-24.0,-4.0,17.0),(-9.0,0.0,0.0),(2.0,4.0,3.0),(9.0,0.0,1.0),(28.0,4.0,31.0),(28.0,9.0,31.0),(27.0,7.0,20.0),(20.0,4.0,8.0),(3.0,-1.0,4.0),(-14.0,2.0,7.0),(0.0,-5.0,-2.0),(14.0,-3.0,-8.0),(33.0,-1.0,-46.0),(12.0,5.0,-47.0),(4.0,20.0,-70.0),(3.0,18.0,-55.0),(-7.0,-4.0,-4.0),(-9.0,-6.0,-1.0),(-2.0,0.0,0.0),(-3.0,-4.0,0.0),(-18.0,-9.0,-1.0),(-31.0,-8.0,-3.0),(-10.0,-8.0,46.0),(-13.0,-10.0,61.0),(-15.0,-6.0,37.0),(-25.0,-5.0,19.0),(-8.0,0.0,-1.0),(2.0,4.0,3.0),(27.0,10.0,33.0),(27.0,9.0,24.0),(16.0,4.0,11.0),(0.0,-6.0,-3.0),(9.0,-5.0,-9.0),(34.0,-1.0,-45.0),(11.0,4.0,-45.0),(4.0,18.0,-70.0),(-10.0,-4.0,-1.0),(-3.0,0.0,0.0),(-3.0,-2.0,-1.0),(-19.0,-6.0,-1.0),(-12.0,-12.0,69.0),(-14.0,-3.0,41.0),(-29.0,-1.0,29.0),(-12.0,0.0,-2.0),(27.0,8.0,23.0),(13.0,-2.0,-2.0),(33.0,-1.0,-43.0),(11.0,2.0,-41.0),(-2.0,0.0,-1.0),(-4.0,-2.0,0.0),(-13.0,-1.0,41.0),(-32.0,2.0,41.0),(4.0,1.0,1.0),(32.0,-1.0,-42.0),(-6.0,94.0,-200.0),(-7.0,0.0,0.0),(-6.0,0.0,0.0),(0.0,-3.0,4.0),(6.0,-1.0,0.0),(6.0,0.0,0.0),(0.0,-1.0,-17.0),(2.0,-1.0,10.0),(0.0,1.0,-3.0),(-2.0,4.0,-12.0),(-7.0,1.0,-1.0),(-6.0,-1.0,2.0),(-1.0,-2.0,3.0),(6.0,-1.0,0.0),(-16.0,-22.0,-7.0),(9.0,-1.0,1.0),(5.0,2.0,5.0),(1.0,0.0,-4.0),(-5.0,1.0,-7.0),(-9.0,0.0,-1.0),(-7.0,1.0,1.0),(-2.0,-1.0,3.0),(-14.0,-14.0,0.0),(8.0,-4.0,2.0),(9.0,-3.0,2.0),(6.0,1.0,4.0),(0.0,-2.0,-3.0),(-6.0,-1.0,-5.0),(-9.0,4.0,-2.0),(-7.0,4.0,-2.0),(-23.0,-13.0,10.0),(0.0,2.0,2.0),(9.0,-5.0,3.0),(13.0,-6.0,5.0),(6.0,1.0,2.0),(0.0,-3.0,-2.0),(-7.0,-1.0,-3.0),(-13.0,5.0,-4.0),(-16.0,-7.0,20.0),(-8.0,6.0,-2.0),(1.0,2.0,1.0),(9.0,-6.0,4.0),(13.0,-8.0,6.0),(8.0,-1.0,3.0),(-1.0,-3.0,-1.0),(-9.0,0.0,-3.0),(-11.0,-9.0,30.0),(-13.0,8.0,-8.0),(-8.0,7.0,-3.0),(1.0,2.0,1.0),(9.0,-8.0,4.0),(13.0,-8.0,8.0),(7.0,0.0,5.0),(-1.0,-3.0,0.0),(-14.0,-9.0,46.0),(-9.0,1.0,-9.0),(-12.0,9.0,-12.0),(-9.0,7.0,-6.0),(1.0,2.0,1.0),(10.0,-8.0,7.0),(12.0,-8.0,12.0),(8.0,-1.0,9.0),(-12.0,-3.0,36.0),(-25.0,2.0,16.0),(-10.0,2.0,-1.0),(-1.0,0.0,-1.0),(0.0,-2.0,0.0),(1.0,-1.0,0.0),(10.0,-3.0,0.0),(24.0,-1.0,-16.0),(-9.0,0.0,-9.0),(-11.0,8.0,-13.0),(-7.0,8.0,-8.0),(1.0,2.0,1.0),(8.0,-8.0,9.0),(10.0,-7.0,13.0),(-24.0,3.0,17.0),(-9.0,2.0,0.0),(-1.0,0.0,0.0),(0.0,-2.0,-1.0),(2.0,-1.0,0.0),(8.0,-2.0,0.0),(-9.0,8.0,-8.0),(-8.0,8.0,-6.0),(0.0,3.0,1.0),(8.0,-8.0,7.0),(-9.0,3.0,0.0),(-1.0,-1.0,0.0),(0.0,-2.0,0.0),(0.0,0.0,-1.0),(-8.0,9.0,-4.0),(0.0,3.0,0.0),(-1.0,0.0,0.0),(0.0,-1.0,-1.0),(16.0,506.0,-338.0),(-1.0,-3.0,0.0),(-2.0,-2.0,0.0),(-3.0,-1.0,0.0),(-3.0,1.0,1.0),(-3.0,2.0,1.0),(0.0,2.0,2.0),(1.0,4.0,0.0),(2.0,2.0,0.0),(3.0,0.0,0.0),(3.0,0.0,-1.0),(3.0,-1.0,0.0),(11.0,6.0,2.0),(2.0,-9.0,-4.0),(-2.0,-9.0,-3.0),(-6.0,-8.0,0.0),(-9.0,-2.0,0.0),(-10.0,1.0,3.0),(-7.0,5.0,4.0),(-2.0,9.0,4.0),(1.0,9.0,3.0),(7.0,7.0,0.0),(9.0,3.0,-1.0),(9.0,0.0,-1.0),(6.0,7.0,7.0),(12.0,-9.0,-6.0),(4.0,-13.0,-6.0),(-3.0,-15.0,-5.0),(-10.0,-12.0,-1.0),(-14.0,-5.0,1.0),(-16.0,2.0,4.0),(-11.0,8.0,6.0),(-4.0,14.0,6.0),(3.0,15.0,5.0),(10.0,12.0,1.0),(14.0,6.0,0.0),(1.0,5.0,11.0),(20.0,-3.0,-6.0),(16.0,-11.0,-8.0),(5.0,-18.0,-8.0),(-3.0,-19.0,-7.0),(-14.0,-16.0,-1.0),(-19.0,-7.0,1.0),(-20.0,2.0,5.0),(-15.0,12.0,8.0),(-6.0,18.0,8.0),(4.0,19.0,7.0),(12.0,16.0,3.0),(-1.0,1.0,12.0),(23.0,9.0,-2.0),(24.0,-3.0,-6.0),(18.0,-14.0,-10.0),(7.0,-21.0,-9.0),(-5.0,-23.0,-8.0),(-15.0,-18.0,-3.0),(-23.0,-8.0,2.0),(-24.0,2.0,6.0),(-18.0,14.0,10.0),(-7.0,21.0,9.0),(4.0,22.0,8.0),(-1.0,-2.0,13.0),(17.0,20.0,2.0),(25.0,10.0,-1.0),(26.0,-3.0,-7.0),(20.0,-15.0,-10.0),(8.0,-23.0,-11.0),(-5.0,-25.0,-9.0),(-17.0,-21.0,-2.0),(-25.0,-9.0,1.0),(-26.0,3.0,7.0),(-20.0,15.0,10.0),(-8.0,22.0,11.0),(1.0,-5.0,12.0),(4.0,-3.0,11.0),(1.0,30.0,-2.0),(18.0,21.0,3.0),(26.0,10.0,-2.0),(26.0,-3.0,-7.0),(21.0,-16.0,-11.0),(8.0,-23.0,-11.0),(-5.0,-26.0,-8.0),(-18.0,-21.0,-3.0),(-26.0,-10.0,1.0),(-26.0,3.0,8.0),(-20.0,14.0,10.0),(4.0,-3.0,12.0),(5.0,-1.0,11.0),(-7.0,21.0,10.0),(4.0,23.0,7.0),(-6.0,6.0,-9.0),(18.0,21.0,3.0),(24.0,9.0,-2.0),(26.0,-3.0,-7.0),(20.0,-15.0,-10.0),(8.0,-23.0,-11.0),(-5.0,-25.0,-8.0),(-17.0,-21.0,-3.0),(-25.0,-9.0,2.0),(-25.0,3.0,7.0),(5.0,0.0,12.0),(4.0,2.0,11.0),(-16.0,12.0,8.0),(-5.0,18.0,9.0),(4.0,19.0,6.0),(12.0,16.0,2.0),(-5.0,9.0,-7.0),(22.0,8.0,-1.0),(24.0,-2.0,-7.0),(18.0,-14.0,-9.0),(7.0,-21.0,-10.0),(-4.0,-23.0,-8.0),(-16.0,-19.0,-2.0),(-22.0,-8.0,2.0),(2.0,3.0,12.0),(0.0,6.0,11.0),(-15.0,2.0,4.0),(-12.0,9.0,6.0),(-4.0,13.0,7.0),(3.0,15.0,5.0),(10.0,12.0,1.0),(13.0,6.0,-1.0),(-1.0,11.0,-4.0),(20.0,-2.0,-6.0),(15.0,-12.0,-8.0),(6.0,-18.0,-8.0),(-4.0,-19.0,-6.0),(-13.0,-15.0,-2.0),(-4.0,4.0,11.0),(-5.0,6.0,11.0),(-9.0,-3.0,0.0),(-9.0,1.0,3.0),(-7.0,5.0,3.0),(-3.0,9.0,4.0),(2.0,9.0,3.0),(6.0,7.0,1.0),(10.0,3.0,-1.0),(9.0,0.0,-2.0),(4.0,11.0,-3.0),(11.0,-9.0,-6.0),(4.0,-13.0,-6.0),(-2.0,-14.0,-4.0),(-9.0,2.0,9.0),(-11.0,2.0,6.0),(-2.0,-2.0,0.0),(-3.0,-1.0,1.0),(-3.0,1.0,0.0),(-3.0,2.0,2.0),(0.0,2.0,1.0),(1.0,4.0,1.0),(2.0,2.0,0.0),(3.0,0.0,-1.0),(3.0,0.0,0.0),(3.0,-1.0,-2.0),(9.0,8.0,-2.0),(2.0,-9.0,-3.0),(-10.0,-2.0,4.0),(282.0,51.0,-36.0),(0.0,3.0,2.0),(2.0,1.0,2.0),(2.0,0.0,2.0),(3.0,-1.0,1.0),(3.0,-2.0,0.0),(0.0,-3.0,-1.0),(0.0,-3.0,-2.0),(-2.0,-2.0,-2.0),(-3.0,0.0,-2.0),(-3.0,1.0,-1.0),(-2.0,2.0,-1.0),(-10.0,-6.0,-4.0),(-2.0,9.0,2.0),(0.0,9.0,5.0),(5.0,6.0,6.0),(8.0,1.0,6.0),(8.0,-3.0,4.0),(7.0,-7.0,0.0),(3.0,-9.0,-2.0),(-1.0,-9.0,-5.0),(-5.0,-6.0,-6.0),(-7.0,0.0,-6.0),(-9.0,1.0,-4.0),(-6.0,-10.0,-2.0),(-11.0,11.0,-1.0),(-5.0,15.0,3.0),(1.0,14.0,8.0),(8.0,9.0,10.0),(12.0,2.0,9.0),(14.0,-5.0,7.0),(11.0,-11.0,1.0),(4.0,-14.0,-3.0),(-1.0,-14.0,-8.0),(-7.0,-10.0,-10.0),(-13.0,-2.0,-8.0),(-3.0,-12.0,2.0),(-17.0,7.0,-9.0),(-15.0,14.0,-1.0),(-7.0,19.0,4.0),(2.0,18.0,10.0),(10.0,13.0,13.0),(16.0,3.0,12.0),(18.0,-7.0,9.0),(15.0,-14.0,2.0),(6.0,-19.0,-5.0),(-1.0,-18.0,-9.0),(-10.0,-13.0,-12.0),(-2.0,-10.0,6.0),(-19.0,-3.0,-14.0),(-21.0,7.0,-11.0),(-17.0,17.0,-2.0),(-8.0,23.0,5.0),(2.0,21.0,12.0),(12.0,15.0,15.0),(19.0,3.0,15.0),(21.0,-7.0,11.0),(17.0,-17.0,2.0),(8.0,-22.0,-5.0),(-2.0,-22.0,-11.0),(-2.0,-7.0,9.0),(-13.0,-16.0,-16.0),(-21.0,-4.0,-17.0),(-23.0,8.0,-11.0),(-19.0,19.0,-2.0),(-9.0,24.0,5.0),(2.0,24.0,13.0),(13.0,16.0,17.0),(21.0,4.0,16.0),(23.0,-8.0,11.0),(19.0,-19.0,3.0),(9.0,-24.0,-5.0),(-6.0,-5.0,11.0),(-6.0,-5.0,8.0),(4.0,-20.0,-22.0),(-13.0,-17.0,-18.0),(-22.0,-3.0,-16.0),(-23.0,8.0,-12.0),(-20.0,19.0,-2.0),(-9.0,25.0,5.0),(2.0,25.0,13.0),(13.0,17.0,18.0),(22.0,4.0,17.0),(24.0,-9.0,11.0),(18.0,-19.0,4.0),(-7.0,-6.0,9.0),(-8.0,-6.0,5.0),(8.0,-22.0,-5.0),(-1.0,-21.0,-12.0),(9.0,1.0,-8.0),(-14.0,-16.0,-17.0),(-21.0,-4.0,-16.0),(-23.0,8.0,-11.0),(-19.0,19.0,-3.0),(-8.0,25.0,6.0),(1.0,23.0,13.0),(14.0,17.0,17.0),(21.0,3.0,16.0),(22.0,-8.0,11.0),(-8.0,-8.0,7.0),(-6.0,-10.0,4.0),(14.0,-14.0,2.0),(7.0,-19.0,-5.0),(-2.0,-18.0,-10.0),(-9.0,-13.0,-13.0),(9.0,-2.0,-8.0),(-19.0,-3.0,-15.0),(-21.0,7.0,-10.0),(-18.0,17.0,-2.0),(-8.0,23.0,5.0),(2.0,21.0,11.0),(12.0,15.0,16.0),(18.0,4.0,15.0),(-4.0,-11.0,5.0),(-2.0,-12.0,3.0),(13.0,-5.0,7.0),(12.0,-11.0,1.0),(4.0,-15.0,-3.0),(-1.0,-13.0,-8.0),(-8.0,-10.0,-10.0),(-11.0,-3.0,-9.0),(5.0,-5.0,-10.0),(-18.0,7.0,-9.0),(-14.0,14.0,-1.0),(-7.0,19.0,4.0),(2.0,18.0,10.0),(10.0,12.0,13.0),(1.0,-11.0,6.0),(3.0,-11.0,4.0),(8.0,1.0,6.0),(8.0,-3.0,4.0),(7.0,-7.0,0.0),(3.0,-9.0,-2.0),(-1.0,-9.0,-4.0),(-5.0,-6.0,-6.0),(-8.0,-1.0,-6.0),(-8.0,2.0,-4.0),(0.0,-5.0,-12.0),(-11.0,11.0,-1.0),(-5.0,14.0,4.0),(1.0,13.0,7.0),(6.0,-8.0,8.0),(9.0,-7.0,6.0),(1.0,2.0,2.0),(3.0,0.0,2.0),(3.0,-1.0,1.0),(2.0,-2.0,0.0),(0.0,-4.0,-1.0),(0.0,-2.0,-1.0),(-2.0,-2.0,-3.0),(-2.0,0.0,-2.0),(-3.0,1.0,-1.0),(-2.0,1.0,0.0),(-7.0,-3.0,-10.0),(-3.0,8.0,2.0),(8.0,-1.0,9.0),(-1051.0,1682.0,2408.0),(56.0,-3.0,0.0),(0.0,36.0,-18.0),(-54.0,4.0,-1.0),(6.0,-18.0,-41.0),(-1.0,-36.0,18.0),(56.0,-4.0,0.0),(0.0,35.0,-19.0),(-20.0,0.0,-7.0),(-13.0,0.0,0.0),(-11.0,-16.0,5.0),(0.0,-19.0,5.0),(36.0,-2.0,0.0),(0.0,18.0,-6.0),(0.0,0.0,-18.0),(-10.0,16.0,0.0),(-12.0,0.0,0.0),(-8.0,-15.0,1.0),(1.0,-17.0,1.0),(29.0,-2.0,0.0),(1.0,6.0,-24.0),(0.0,14.0,4.0),(-10.0,14.0,3.0),(-10.0,0.0,0.0),(-7.0,-12.0,-4.0),(3.0,-14.0,-4.0),(4.0,10.0,-18.0),(21.0,-1.0,0.0),(0.0,11.0,6.0),(-10.0,10.0,5.0),(-8.0,0.0,-1.0),(-6.0,-8.0,-5.0),(2.0,8.0,-10.0),(3.0,-9.0,-6.0),(19.0,0.0,0.0),(0.0,8.0,7.0),(-9.0,8.0,5.0),(-6.0,0.0,0.0),(1.0,7.0,-6.0),(1.0,11.0,-8.0),(1.0,10.0,-5.0),(0.0,8.0,-4.0),(0.0,9.0,-2.0),(-1.0,2.0,-2.0),(-3.0,-12.0,1.0),(-1.0,-9.0,2.0),(-2.0,-11.0,5.0),(-1.0,-13.0,5.0),(4.0,-6.0,-7.0),(15.0,0.0,0.0),(1.0,5.0,9.0),(-8.0,5.0,6.0),(0.0,11.0,-8.0),(0.0,10.0,-5.0),(0.0,9.0,-4.0),(0.0,8.0,-2.0),(1.0,3.0,-3.0),(-1.0,-5.0,-2.0),(-3.0,0.0,0.0),(-1.0,-8.0,0.0),(-1.0,-10.0,0.0),(0.0,-13.0,3.0),(11.0,0.0,0.0),(1.0,3.0,7.0),(-2.0,12.0,-5.0),(-1.0,8.0,-2.0),(-1.0,-1.0,-3.0),(0.0,-9.0,0.0),(-151.0,-35.0,115.0),(66.0,-16.0,-15.0),(2.0,37.0,-20.0),(-66.0,17.0,13.0),(-7.0,-18.0,-40.0),(-2.0,-37.0,20.0),(66.0,-17.0,-14.0),(3.0,38.0,-22.0),(-27.0,3.0,-1.0),(-15.0,3.0,3.0),(-16.0,-14.0,9.0),(-1.0,-19.0,7.0),(43.0,-11.0,-10.0),(0.0,19.0,-7.0),(-4.0,0.0,-16.0),(-9.0,20.0,0.0),(-15.0,2.0,3.0),(-13.0,-13.0,5.0),(0.0,-18.0,2.0),(34.0,-8.0,-8.0),(-5.0,7.0,-24.0),(4.0,14.0,3.0),(-8.0,16.0,5.0),(-11.0,2.0,1.0),(-14.0,-10.0,0.0),(0.0,-14.0,-3.0),(2.0,10.0,-21.0),(25.0,-6.0,-4.0),(3.0,11.0,4.0),(-8.0,12.0,7.0),(-9.0,1.0,1.0),(-11.0,-5.0,-2.0),(1.0,8.0,-11.0),(1.0,-10.0,-8.0),(22.0,-5.0,-4.0),(4.0,8.0,6.0),(-9.0,10.0,8.0),(-7.0,2.0,1.0),(1.0,7.0,-7.0),(2.0,11.0,-9.0),(1.0,11.0,-6.0),(1.0,8.0,-5.0),(1.0,9.0,-2.0),(-2.0,3.0,-3.0),(-5.0,-12.0,3.0),(-3.0,-9.0,4.0),(-3.0,-11.0,6.0),(-2.0,-13.0,7.0),(2.0,-7.0,-9.0),(18.0,-3.0,-3.0),(4.0,4.0,7.0),(-7.0,7.0,8.0),(0.0,12.0,-8.0),(1.0,10.0,-6.0),(0.0,9.0,-4.0),(0.0,9.0,-3.0),(2.0,2.0,-4.0),(-3.0,-3.0,-1.0),(-3.0,0.0,1.0),(-4.0,-9.0,0.0),(-2.0,-9.0,2.0),(-2.0,-14.0,3.0),(13.0,-2.0,-2.0),(4.0,2.0,6.0),(-1.0,13.0,-5.0),(0.0,8.0,-3.0),(-4.0,0.0,-2.0),(0.0,-10.0,0.0),(-100.0,-31.0,194.0),(36.0,-26.0,-28.0),(16.0,33.0,0.0),(-36.0,26.0,27.0),(-11.0,6.0,-43.0),(-15.0,-33.0,0.0),(35.0,-25.0,-27.0),(16.0,32.0,0.0),(-19.0,12.0,1.0),(-10.0,5.0,6.0),(-16.0,-8.0,1.0),(-9.0,-15.0,-3.0),(29.0,-17.0,-15.0),(7.0,15.0,2.0),(-3.0,8.0,-14.0),(0.0,16.0,11.0),(-9.0,5.0,4.0),(-15.0,-6.0,-1.0),(-7.0,-13.0,-7.0),(22.0,-13.0,-13.0),(0.0,15.0,-16.0),(8.0,7.0,8.0),(-1.0,12.0,13.0),(-7.0,3.0,3.0),(-14.0,-2.0,-4.0),(-5.0,-8.0,-10.0),(5.0,14.0,-12.0),(17.0,-9.0,-9.0),(7.0,3.0,9.0),(-2.0,9.0,12.0),(-6.0,3.0,3.0),(-11.0,0.0,-5.0),(4.0,9.0,-5.0),(-2.0,-3.0,-10.0),(14.0,-8.0,-8.0),(6.0,1.0,8.0),(-3.0,6.0,12.0),(-4.0,3.0,2.0),(14.0,27.0,-4.0),(3.0,6.0,0.0),(-9.0,-16.0,0.0),(-6.0,-10.0,1.0),(-8.0,3.0,-4.0),(0.0,-1.0,-11.0),(11.0,-7.0,-6.0),(5.0,-1.0,8.0),(-2.0,3.0,11.0),(5.0,12.0,-1.0),(4.0,9.0,0.0),(4.0,8.0,1.0),(2.0,6.0,2.0),(-2.0,1.0,0.0),(0.0,4.0,-1.0),(-8.0,-8.0,-3.0),(-5.0,-6.0,-1.0),(-6.0,-9.0,0.0),(1.0,0.0,-10.0),(8.0,-6.0,-4.0),(5.0,-2.0,7.0),(4.0,11.0,2.0),(3.0,8.0,2.0),(3.0,9.0,5.0),(-3.0,0.0,-3.0),(-3.0,0.0,1.0),(-5.0,-5.0,-4.0),(-5.0,-6.0,-3.0),(7.0,-3.0,-3.0),(2.0,6.0,4.0),(-58.0,-23.0,214.0),(32.0,-26.0,-34.0),(15.0,29.0,-2.0),(-32.0,27.0,33.0),(-21.0,4.0,-38.0),(-15.0,-29.0,3.0),(32.0,-26.0,-34.0),(15.0,29.0,-3.0),(-16.0,11.0,6.0),(-8.0,5.0,8.0),(-14.0,-6.0,4.0),(-9.0,-13.0,-1.0),(21.0,-17.0,-21.0),(8.0,14.0,1.0),(-6.0,6.0,-12.0),(3.0,15.0,9.0),(-7.0,5.0,8.0),(-15.0,-6.0,1.0),(-7.0,-11.0,-5.0),(15.0,-13.0,-18.0),(-3.0,13.0,-15.0),(10.0,7.0,6.0),(2.0,11.0,13.0),(-5.0,3.0,5.0),(-14.0,-2.0,-2.0),(-7.0,-7.0,-8.0),(2.0,12.0,-13.0),(12.0,-9.0,-12.0),(9.0,3.0,7.0),(1.0,8.0,13.0),(-4.0,4.0,3.0),(-11.0,0.0,-1.0),(2.0,8.0,-6.0),(-5.0,-3.0,-10.0),(11.0,-8.0,-10.0),(8.0,1.0,7.0),(0.0,6.0,12.0),(-3.0,3.0,3.0),(2.0,6.0,-4.0),(5.0,10.0,-3.0),(4.0,8.0,-1.0),(5.0,6.0,0.0),(3.0,5.0,0.0),(0.0,4.0,0.0),(-8.0,-7.0,0.0),(-6.0,-6.0,0.0),(-6.0,-7.0,1.0),(-6.0,-10.0,1.0),(-3.0,-1.0,-10.0),(9.0,-8.0,-9.0),(6.0,0.0,7.0),(0.0,3.0,11.0),(5.0,10.0,-3.0),(4.0,8.0,0.0),(4.0,7.0,0.0),(3.0,6.0,1.0),(2.0,2.0,-3.0),(-5.0,0.0,-1.0),(-1.0,0.0,0.0),(-7.0,-4.0,-2.0),(-5.0,-6.0,-2.0),(-7.0,-8.0,-1.0),(6.0,-6.0,-5.0),(7.0,-1.0,4.0),(4.0,9.0,2.0),(3.0,7.0,1.0),(-4.0,2.0,-3.0),(-4.0,-7.0,-2.0),(1226.0,-53.0,450.0),(38.0,-14.0,38.0),(15.0,38.0,0.0),(-38.0,13.0,-38.0),(24.0,-5.0,-39.0),(-15.0,-38.0,0.0),(39.0,-13.0,38.0),(14.0,36.0,0.0),(-7.0,-14.0,-18.0),(-2.0,20.0,-4.0),(-9.0,2.0,-9.0),(-13.0,-14.0,-11.0),(-5.0,-18.0,-3.0),(25.0,-8.0,24.0),(11.0,6.0,-18.0),(3.0,16.0,6.0),(-4.0,17.0,-1.0),(-9.0,2.0,-8.0),(-9.0,-12.0,-12.0),(-1.0,-15.0,-5.0),(18.0,9.0,-14.0),(16.0,-5.0,17.0),(0.0,11.0,10.0),(-7.0,13.0,0.0),(-7.0,2.0,-6.0),(-4.0,-7.0,-14.0),(12.0,9.0,-9.0),(4.0,-9.0,-7.0),(14.0,-4.0,15.0),(-1.0,8.0,10.0),(-9.0,9.0,1.0),(-4.0,2.0,-5.0),(6.0,7.0,-4.0),(-1.0,-2.0,-13.0),(5.0,-7.0,-7.0),(12.0,-4.0,13.0),(-3.0,5.0,11.0),(-7.0,7.0,0.0),(14.0,31.0,-3.0),(2.0,7.0,0.0),(-7.0,-19.0,0.0),(-6.0,-11.0,1.0),(-4.0,0.0,-4.0),(0.0,0.0,-12.0),(7.0,-3.0,-6.0),(9.0,-3.0,10.0),(-1.0,2.0,10.0),(4.0,14.0,0.0),(3.0,12.0,0.0),(1.0,9.0,1.0),(0.0,11.0,2.0),(-4.0,-3.0,-1.0),(-1.0,0.0,-1.0),(-3.0,-8.0,-3.0),(-4.0,-8.0,-1.0),(-4.0,-10.0,0.0),(0.0,1.0,-10.0),(7.0,-3.0,-4.0),(7.0,-2.0,8.0),(3.0,14.0,2.0),(0.0,9.0,3.0),(-1.0,8.0,2.0),(-2.0,1.0,-1.0),(-2.0,3.0,1.0),(-4.0,-11.0,-6.0),(-3.0,-8.0,-3.0),(6.0,0.0,-2.0),(1.0,7.0,4.0),(-22.0,-105.0,99.0),(36.0,-9.0,58.0),(16.0,40.0,-1.0),(-35.0,9.0,-60.0),(32.0,-11.0,-29.0),(-16.0,-40.0,2.0),(36.0,-8.0,59.0),(16.0,39.0,-2.0),(-5.0,-18.0,-18.0),(-2.0,20.0,-10.0),(-9.0,2.0,-14.0),(-12.0,-17.0,-14.0),(-5.0,-20.0,-1.0),(23.0,-5.0,38.0),(16.0,5.0,-15.0),(2.0,18.0,3.0),(-5.0,17.0,-7.0),(-7.0,1.0,-13.0),(-8.0,-14.0,-13.0),(-1.0,-17.0,-3.0),(21.0,8.0,-11.0),(15.0,-3.0,27.0),(-1.0,14.0,7.0),(-8.0,14.0,-4.0),(-6.0,0.0,-10.0),(-3.0,-10.0,-16.0),(15.0,10.0,-7.0),(5.0,-10.0,-3.0),(13.0,-3.0,23.0),(-3.0,10.0,7.0),(-9.0,10.0,-4.0),(-4.0,1.0,-8.0),(7.0,7.0,-3.0),(0.0,-4.0,-15.0),(7.0,-8.0,-3.0),(11.0,-2.0,20.0),(-4.0,7.0,8.0),(-9.0,7.0,-3.0),(17.0,32.0,-6.0),(2.0,8.0,0.0),(-8.0,-20.0,2.0),(-6.0,-12.0,1.0),(-3.0,0.0,-6.0),(1.0,-2.0,-14.0),(8.0,-4.0,-2.0),(9.0,-2.0,16.0),(-4.0,4.0,9.0),(6.0,14.0,-2.0),(3.0,13.0,-2.0),(0.0,10.0,-1.0),(0.0,12.0,0.0),(-4.0,-3.0,-1.0),(-2.0,0.0,-3.0),(-2.0,-9.0,-1.0),(-4.0,-9.0,0.0),(-4.0,-11.0,0.0),(1.0,-1.0,-12.0),(8.0,-2.0,0.0),(7.0,-1.0,11.0),(2.0,14.0,0.0),(0.0,10.0,1.0),(-2.0,9.0,0.0),(-1.0,0.0,-2.0),(-3.0,4.0,0.0),(-4.0,-12.0,-5.0),(-2.0,-10.0,-2.0),(7.0,0.0,0.0),(1.0,9.0,3.0),(-83.0,-116.0,127.0),(5.0,6.0,52.0),(-8.0,35.0,0.0),(-5.0,-6.0,-52.0),(40.0,10.0,-19.0),(8.0,-35.0,0.0),(4.0,7.0,52.0),(-7.0,35.0,0.0),(18.0,-15.0,-12.0),(-9.0,13.0,-9.0),(-2.0,-1.0,-13.0),(4.0,-16.0,-13.0),(7.0,-15.0,-2.0),(8.0,3.0,36.0),(13.0,12.0,-11.0),(-8.0,13.0,3.0),(-11.0,9.0,-6.0),(-2.0,-1.0,-12.0),(6.0,-12.0,-13.0),(9.0,-12.0,-2.0),(15.0,18.0,-5.0),(5.0,2.0,26.0),(-11.0,8.0,4.0),(-12.0,5.0,-5.0),(-1.0,-1.0,-9.0),(8.0,-7.0,-13.0),(7.0,14.0,-3.0),(11.0,-3.0,-3.0),(4.0,2.0,23.0),(-10.0,4.0,5.0),(-11.0,3.0,-5.0),(-1.0,0.0,-7.0),(3.0,8.0,-2.0),(6.0,-2.0,-12.0),(10.0,-1.0,-2.0),(4.0,2.0,20.0),(-9.0,2.0,5.0),(-10.0,1.0,-4.0),(-3.0,30.0,-2.0),(-2.0,7.0,0.0),(5.0,-18.0,0.0),(0.0,-12.0,0.0),(0.0,0.0,-5.0),(6.0,1.0,-12.0),(9.0,1.0,-1.0),(3.0,1.0,16.0),(-8.0,0.0,6.0),(-3.0,12.0,-1.0),(-4.0,11.0,0.0),(-4.0,7.0,-1.0),(-7.0,8.0,0.0),(-1.0,-4.0,-2.0),(0.0,0.0,-2.0),(4.0,-7.0,-2.0),(2.0,-8.0,-1.0),(2.0,-9.0,0.0),(4.0,1.0,-9.0),(8.0,2.0,0.0),(2.0,1.0,11.0),(-6.0,11.0,1.0),(-5.0,7.0,0.0),(-6.0,5.0,0.0),(-1.0,0.0,-3.0),(-4.0,1.0,0.0),(6.0,-10.0,-5.0),(3.0,-7.0,-1.0),(5.0,3.0,1.0),(-5.0,6.0,2.0),(-119.0,-90.0,117.0),(-1.0,7.0,52.0),(-5.0,32.0,-1.0),(1.0,-6.0,-54.0),(43.0,4.0,-8.0),(5.0,-32.0,1.0),(-1.0,7.0,53.0),(-5.0,32.0,-2.0),(13.0,-13.0,-11.0),(-4.0,11.0,-11.0),(0.0,-2.0,-13.0),(6.0,-15.0,-10.0),(5.0,-14.0,0.0),(0.0,4.0,34.0),(16.0,9.0,-7.0),(-8.0,13.0,1.0),(-7.0,9.0,-9.0),(1.0,-2.0,-11.0),(8.0,-12.0,-10.0),(8.0,-12.0,0.0),(15.0,14.0,-1.0),(0.0,3.0,24.0),(-11.0,9.0,2.0),(-9.0,5.0,-8.0),(0.0,-1.0,-9.0),(10.0,-8.0,-10.0),(9.0,12.0,-1.0),(10.0,-4.0,0.0),(0.0,2.0,21.0),(-11.0,6.0,2.0),(-9.0,2.0,-6.0),(1.0,0.0,-8.0),(4.0,7.0,-1.0),(8.0,-3.0,-8.0),(10.0,-1.0,0.0),(-1.0,2.0,18.0),(-10.0,3.0,3.0),(-9.0,1.0,-6.0),(0.0,27.0,-3.0),(0.0,7.0,0.0),(3.0,-17.0,1.0),(0.0,-11.0,0.0),(0.0,0.0,-5.0),(8.0,0.0,-8.0),(9.0,0.0,1.0),(0.0,2.0,14.0),(-10.0,0.0,4.0),(-2.0,12.0,-2.0),(-3.0,9.0,-2.0),(-3.0,7.0,-1.0),(-5.0,8.0,-2.0),(0.0,-4.0,-2.0),(0.0,0.0,-2.0),(3.0,-7.0,-1.0),(1.0,-7.0,0.0),(2.0,-9.0,0.0),(6.0,0.0,-7.0),(7.0,2.0,2.0),(0.0,1.0,10.0),(-5.0,10.0,-1.0),(-5.0,7.0,-1.0),(-5.0,5.0,-1.0),(0.0,0.0,-2.0),(-4.0,1.0,-1.0),(6.0,-9.0,-4.0),(3.0,-7.0,0.0),(5.0,2.0,2.0),(-5.0,6.0,0.0),(-1152.0,-110.0,-712.0),(-9.0,0.0,-3.0),(-21.0,2.0,-8.0),(-15.0,20.0,41.0),(-30.0,14.0,30.0),(-3.0,1.0,-8.0),(6.0,-16.0,-37.0),(-21.0,-12.0,-43.0),(-28.0,0.0,-13.0),(-12.0,4.0,2.0),(-25.0,16.0,25.0),(1.0,17.0,44.0),(27.0,9.0,36.0),(-2.0,0.0,9.0),(-16.0,2.0,-3.0),(-5.0,3.0,-5.0),(-15.0,-11.0,-34.0),(-33.0,-4.0,-30.0),(-26.0,5.0,-1.0),(-3.0,3.0,5.0),(9.0,14.0,39.0),(34.0,10.0,45.0),(21.0,-5.0,0.0),(3.0,-2.0,7.0),(122.0,-39.0,-31.0),(4.0,0.0,-8.0),(36.0,-4.0,9.0),(32.0,-11.0,-9.0),(-19.0,-13.0,-41.0),(1.0,-5.0,-1.0),(-13.0,-4.0,-21.0),(-10.0,0.0,-3.0),(-25.0,3.0,-7.0),(-25.0,19.0,34.0),(-31.0,-14.0,-51.0),(-31.0,1.0,-15.0),(-15.0,4.0,2.0),(-28.0,18.0,29.0),(0.0,19.0,49.0),(-38.0,-5.0,-35.0),(-30.0,6.0,-1.0),(-3.0,3.0,5.0),(10.0,16.0,45.0),(38.0,13.0,52.0),(-2.0,5.0,1.0),(-50.0,5.0,-14.0),(78.0,0.0,44.0),(6.0,-4.0,2.0),(11.0,1.0,-2.0),(-5.0,-11.0,-30.0),(28.0,-14.0,-20.0),(50.0,-17.0,-12.0),(28.0,-3.0,6.0),(37.0,-6.0,6.0),(8.0,-8.0,-5.0),(36.0,-13.0,-11.0),(8.0,-11.0,2.0),(-24.0,-15.0,-49.0),(-16.0,-5.0,-25.0),(-18.0,1.0,-6.0),(-33.0,5.0,-5.0),(-10.0,13.0,28.0),(-29.0,-11.0,-44.0),(-38.0,1.0,-19.0),(-21.0,6.0,3.0),(-34.0,21.0,34.0),(0.0,11.0,30.0),(-23.0,-2.0,-21.0),(-39.0,8.0,0.0),(-8.0,6.0,11.0),(11.0,19.0,51.0),(22.0,7.0,30.0),(-34.0,4.0,-9.0),(3.0,13.0,7.0),(-10.0,4.0,6.0),(6.0,5.0,3.0),(-2.0,4.0,9.0),(14.0,7.0,26.0),(61.0,14.0,68.0),(20.0,-16.0,-27.0),(7.0,-2.0,7.0),(11.0,0.0,-6.0),(26.0,7.0,35.0),(56.0,-14.0,-4.0),(61.0,-25.0,-30.0),(2.0,-21.0,-51.0),(10.0,-7.0,0.0),(16.0,-5.0,-2.0),(4.0,-9.0,5.0),(11.0,-7.0,7.0),(7.0,-26.0,-59.0),(-25.0,-15.0,-52.0),(-19.0,-7.0,-29.0),(-26.0,2.0,-9.0),(-40.0,7.0,-4.0),(-11.0,1.0,-2.0),(-11.0,-2.0,-13.0),(-45.0,1.0,-22.0),(-28.0,8.0,4.0),(-39.0,24.0,39.0),(0.0,4.0,11.0),(-9.0,0.0,-8.0),(-47.0,10.0,0.0),(-14.0,10.0,18.0),(11.0,21.0,58.0),(7.0,3.0,9.0),(-11.0,1.0,-2.0),(-24.0,10.0,12.0),(9.0,8.0,5.0),(-4.0,8.0,17.0),(13.0,6.0,-3.0),(15.0,9.0,30.0),(71.0,15.0,79.0),(53.0,-8.0,9.0),(64.0,-16.0,-5.0),(70.0,-29.0,-33.0),(2.0,-6.0,13.0),(2.0,-3.0,11.0),(-8.0,-15.0,28.0),(34.0,-45.0,-81.0),(1.0,-29.0,-57.0),(-21.0,-36.0,-53.0),(-25.0,-20.0,-35.0),(-31.0,-10.0,-14.0),(-32.0,-3.0,-1.0),(-13.0,4.0,-2.0),(-12.0,-7.0,-12.0),(-57.0,-3.0,-15.0),(-29.0,7.0,5.0),(-34.0,23.0,29.0),(0.0,7.0,10.0),(-10.0,-3.0,-6.0),(-51.0,12.0,10.0),(-13.0,18.0,19.0),(12.0,33.0,70.0),(7.0,6.0,7.0),(-12.0,0.0,-1.0),(-35.0,12.0,24.0),(-5.0,18.0,19.0),(31.0,59.0,-41.0),(20.0,12.0,38.0),(11.0,2.0,-7.0),(74.0,16.0,84.0),(58.0,-8.0,9.0),(67.0,-17.0,-4.0),(1.0,-3.0,13.0),(-2.0,-21.0,34.0),(-6.0,-34.0,86.0),(24.0,-25.0,-15.0),(22.0,-18.0,-17.0),(15.0,32.0,-53.0),(35.0,-64.0,-78.0),(-1.0,-38.0,-61.0),(-20.0,-35.0,-16.0),(-35.0,-30.0,-9.0),(-27.0,-3.0,-4.0),(-30.0,17.0,-10.0),(-3.0,10.0,3.0),(-6.0,-10.0,-2.0),(-39.0,-19.0,5.0),(-31.0,3.0,4.0),(-28.0,32.0,17.0),(0.0,9.0,5.0),(-9.0,-7.0,-1.0),(-36.0,-1.0,11.0),(-23.0,18.0,11.0),(-3.0,38.0,30.0),(5.0,8.0,6.0),(-11.0,-2.0,0.0),(-20.0,8.0,10.0),(-7.0,22.0,19.0),(14.0,41.0,26.0),(-17.0,40.0,-68.0),(43.0,31.0,28.0),(64.0,25.0,33.0),(63.0,-9.0,11.0),(15.0,-3.0,34.0),(8.0,-46.0,97.0),(-4.0,-21.0,23.0),(41.0,-12.0,-23.0),(32.0,-43.0,-12.0),(18.0,-20.0,-16.0),(1.0,-4.0,-20.0),(0.0,9.0,-11.0),(4.0,13.0,-12.0),(21.0,-53.0,-51.0),(-9.0,-29.0,-44.0),(-29.0,-20.0,-6.0),(-25.0,-5.0,-1.0),(-37.0,3.0,-2.0),(-27.0,0.0,2.0),(-27.0,2.0,3.0),(-38.0,11.0,9.0),(-17.0,6.0,6.0),(-24.0,11.0,10.0),(-22.0,18.0,14.0),(-15.0,41.0,28.0),(0.0,45.0,0.0),(16.0,57.0,-4.0),(78.0,47.0,9.0),(15.0,-46.0,102.0),(-1.0,-23.0,19.0),(-16.0,-44.0,29.0),(20.0,0.0,8.0),(20.0,0.0,4.0),(19.0,-5.0,-7.0),(17.0,-10.0,-18.0),(18.0,-8.0,-15.0),(11.0,-13.0,1.0),(44.0,-3.0,-17.0),(11.0,-12.0,-19.0),(0.0,-30.0,-38.0),(1.0,-4.0,-15.0),(-2.0,0.0,-10.0),(-1.0,-16.0,-4.0),(-12.0,-11.0,-11.0),(-18.0,-7.0,-17.0),(-18.0,-1.0,-8.0),(-41.0,2.0,-5.0),(4.0,-12.0,13.0),(-36.0,16.0,-7.0),(-38.0,4.0,6.0),(-22.0,11.0,18.0),(-20.0,17.0,16.0),(-10.0,28.0,36.0),(0.0,18.0,9.0),(5.0,59.0,25.0),(2.0,-17.0,16.0),(9.0,-48.0,30.0),(26.0,3.0,26.0),(23.0,-5.0,21.0),(20.0,2.0,4.0),(20.0,-1.0,-8.0),(18.0,-7.0,-24.0),(30.0,-5.0,-20.0),(44.0,-5.0,-21.0),(13.0,-11.0,-20.0),(1.0,-33.0,-44.0),(-4.0,-22.0,-20.0),(-11.0,-1.0,-12.0),(-20.0,-5.0,-18.0),(-17.0,-1.0,-8.0),(-21.0,-30.0,12.0),(-17.0,-4.0,1.0),(-32.0,34.0,-8.0),(-30.0,8.0,12.0),(-21.0,11.0,15.0),(-19.0,18.0,20.0),(-14.0,26.0,32.0),(-3.0,25.0,10.0),(0.0,-39.0,38.0),(13.0,-35.0,45.0),(27.0,1.0,50.0),(44.0,16.0,4.0),(32.0,-1.0,-35.0),(26.0,-1.0,-24.0),(56.0,-7.0,-42.0),(1.0,-48.0,-67.0),(-16.0,-15.0,-19.0),(-39.0,-13.0,-12.0),(-32.0,-4.0,0.0),(-25.0,3.0,13.0),(-30.0,11.0,24.0),(-23.0,18.0,31.0),(-10.0,11.0,14.0),(-15.0,14.0,21.0),(-32.0,-151.0,87.0),(47.0,20.0,70.0),(43.0,-5.0,12.0),(27.0,-7.0,-35.0),(48.0,15.0,-20.0),(39.0,5.0,-74.0),(0.0,-12.0,-83.0),(-14.0,-1.0,-22.0),(-56.0,-31.0,-19.0),(-37.0,-5.0,15.0),(-33.0,7.0,24.0),(-37.0,7.0,38.0),(-34.0,0.0,47.0),(-27.0,-116.0,45.0),(20.0,3.0,38.0),(39.0,13.0,65.0),(7.0,7.0,23.0),(38.0,4.0,12.0),(46.0,0.0,-45.0),(70.0,13.0,-29.0),(27.0,-7.0,-96.0),(-17.0,-13.0,-58.0),(-11.0,-6.0,-33.0),(-20.0,-4.0,-21.0),(-50.0,-2.0,-17.0),(-41.0,6.0,26.0),(-30.0,5.0,28.0),(-32.0,-11.0,52.0),(1.0,-21.0,-1.0),(-52.0,-26.0,65.0),(21.0,8.0,39.0),(36.0,9.0,64.0),(9.0,4.0,38.0),(34.0,4.0,12.0),(55.0,22.0,-61.0),(71.0,11.0,-35.0),(26.0,-8.0,-97.0),(-17.0,-11.0,-52.0),(-11.0,-13.0,-36.0),(-19.0,0.0,-22.0),(-55.0,0.0,-21.0),(-38.0,5.0,26.0),(-29.0,0.0,30.0),(-4.0,-63.0,0.0),(-25.0,-14.0,46.0),(-44.0,-21.0,61.0),(22.0,5.0,43.0),(40.0,4.0,55.0),(6.0,7.0,49.0),(32.0,3.0,13.0),(50.0,23.0,-55.0),(61.0,20.0,-39.0),(26.0,-3.0,-98.0),(-19.0,-11.0,-57.0),(-13.0,-13.0,-42.0),(-20.0,3.0,-19.0),(-55.0,0.0,-15.0),(-34.0,-2.0,25.0),(-8.0,-62.0,0.0),(-23.0,-10.0,31.0),(-14.0,-11.0,36.0),(-10.0,-6.0,19.0),(-31.0,-15.0,46.0),(24.0,2.0,48.0),(42.0,0.0,45.0),(5.0,9.0,59.0),(29.0,4.0,16.0),(48.0,22.0,-48.0),(50.0,30.0,-46.0),(23.0,1.0,-97.0),(-19.0,-9.0,-62.0),(-15.0,-12.0,-47.0),(-20.0,4.0,-18.0),(-55.0,1.0,-9.0),(2.0,-244.0,-74.0),(18.0,-228.0,-40.0),(2.0,-65.0,-15.0),(786.0,-41.0,-141.0),(-26.0,-24.0,-62.0),(-2.0,-11.0,-81.0),(-10.0,-63.0,-7.0),(36.0,34.0,-106.0),(-98.0,-792.0,-2035.0),(-8.0,-2.0,-1.0),(-7.0,1.0,3.0),(-1.0,0.0,1.0),(4.0,-1.0,-4.0),(0.0,4.0,-2.0),(4.0,0.0,0.0),(5.0,9.0,1.0),(6.0,0.0,1.0),(2.0,-5.0,2.0),(535.0,39.0,109.0),(7.0,-7.0,2.0),(3.0,0.0,2.0),(1.0,-3.0,4.0),(1.0,3.0,3.0),(-4.0,-4.0,-7.0),(-3.0,0.0,-2.0),(-9.0,1.0,-2.0),(-3.0,5.0,-1.0),(1.0,6.0,-1.0),(-221.0,513.0,-409.0),(11.0,-2.0,0.0),(4.0,-3.0,-13.0),(9.0,-4.0,2.0),(-20.0,5.0,-5.0),(2.0,-6.0,-16.0),(-14.0,4.0,14.0),(-9.0,-5.0,0.0),(7.0,9.0,15.0),(7.0,14.0,19.0),(23.0,5.0,1.0),(-10.0,27.0,38.0),(13.0,-49.0,-53.0),(0.0,-9.0,-1.0),(1.0,-4.0,-9.0),(7.0,-4.0,-4.0),(33.0,-9.0,17.0),(4.0,6.0,-2.0),(-35.0,10.0,-19.0),(-12.0,4.0,-10.0),(13.0,-8.0,-16.0),(-24.0,2.0,-6.0),(-24.0,-4.0,-3.0),(6.0,9.0,21.0),(-16.0,-6.0,3.0),(-37.0,-14.0,5.0),(4.0,-5.0,3.0),(36.0,13.0,-3.0),(3.0,5.0,7.0),(-2.0,4.0,9.0),(-1.0,9.0,0.0),(-6.0,21.0,13.0),(-6.0,27.0,41.0),(20.0,-5.0,6.0),(-2.0,6.0,13.0),(20.0,7.0,5.0),(-2.0,-1.0,3.0),(33.0,12.0,17.0),(5.0,0.0,-8.0),(7.0,-4.0,-14.0),(3.0,-11.0,-10.0),(11.0,-39.0,-35.0),(0.0,-27.0,-9.0),(-1.0,-7.0,0.0),(12.0,-5.0,1.0),(0.0,0.0,-4.0),(4.0,4.0,-1.0),(0.0,-6.0,-22.0),(-18.0,5.0,-21.0),(0.0,-5.0,-2.0),(-23.0,6.0,-11.0),(-31.0,-189.0,67.0),(-1.0,-33.0,15.0),(4.0,74.0,-36.0),(2.0,39.0,-20.0),(2.0,44.0,-22.0),(0.0,37.0,-9.0),(0.0,18.0,-4.0),(-1.0,14.0,1.0),(-25.0,-6.0,-2.0),(-26.0,-8.0,2.0),(0.0,5.0,2.0),(-25.0,-7.0,13.0),(-7.0,5.0,20.0),(2.0,-4.0,3.0),(0.0,1.0,3.0),(10.0,7.0,3.0),(-3.0,6.0,0.0),(-4.0,28.0,8.0),(-7.0,39.0,36.0),(-1.0,11.0,10.0),(1.0,4.0,16.0),(1.0,0.0,8.0),(37.0,-9.0,-7.0),(2.0,-1.0,5.0),(19.0,-8.0,3.0),(0.0,-4.0,-1.0),(18.0,8.0,4.0),(28.0,11.0,17.0),(1.0,6.0,2.0),(23.0,11.0,46.0),(5.0,1.0,-1.0),(15.0,-9.0,-20.0),(7.0,-14.0,-28.0),(1.0,-21.0,-24.0),(-4.0,-36.0,-37.0),(-2.0,-19.0,-11.0),(0.0,-10.0,1.0),(2.0,6.0,-4.0),(0.0,-7.0,-24.0),(-1.0,0.0,-2.0),(-5.0,-18.0,-4.0),(-10.0,4.0,-13.0),(-24.0,8.0,-15.0),(2.0,-20.0,4.0),(-2.0,-34.0,12.0),(0.0,-38.0,19.0),(-4.0,-40.0,18.0),(-1.0,-40.0,20.0),(-6.0,-37.0,15.0),(-1.0,-34.0,18.0),(-26.0,3.0,-8.0),(-26.0,-6.0,-3.0),(3.0,36.0,-18.0),(-2.0,36.0,-17.0),(3.0,41.0,-20.0),(0.0,40.0,-18.0),(4.0,38.0,-18.0),(0.0,33.0,-13.0),(1.0,19.0,-2.0),(-28.0,-10.0,6.0),(-14.0,-4.0,8.0),(-8.0,18.0,1.0),(-1.0,0.0,2.0),(-9.0,5.0,21.0),(1.0,-5.0,5.0),(-1.0,11.0,-2.0),(-8.0,18.0,11.0),(-21.0,35.0,32.0),(-9.0,21.0,22.0),(-4.0,14.0,28.0),(5.0,8.0,25.0),(4.0,-1.0,1.0),(40.0,-8.0,-34.0),(2.0,-7.0,-1.0),(32.0,-7.0,-4.0),(-9.0,9.0,19.0),(25.0,-2.0,3.0),(23.0,4.0,7.0),(2.0,-11.0,7.0),(19.0,9.0,17.0),(0.0,11.0,-10.0),(29.0,2.0,29.0),(12.0,-8.0,27.0),(1.0,7.0,0.0),(5.0,1.0,-1.0),(25.0,-7.0,-26.0),(5.0,-19.0,-35.0),(0.0,-25.0,-32.0),(-18.0,-41.0,-36.0),(-4.0,-14.0,-10.0),(-2.0,-6.0,0.0),(2.0,-10.0,5.0),(0.0,12.0,-10.0),(-1.0,-7.0,-21.0),(-2.0,-2.0,-7.0),(-1.0,-15.0,0.0),(-9.0,-2.0,-12.0),(0.0,-27.0,9.0),(1.0,-32.0,13.0),(-4.0,-41.0,17.0),(-1.0,-41.0,19.0),(-10.0,-39.0,16.0),(-1.0,-40.0,16.0),(105.0,-14.0,176.0),(-17.0,11.0,-8.0),(-25.0,6.0,-20.0),(-20.0,-12.0,-26.0),(1.0,-4.0,-3.0),(11.0,-25.0,-6.0),(14.0,-10.0,5.0),(-23.0,24.0,-3.0),(-1.0,6.0,1.0),(20.0,8.0,-36.0),(-4.0,3.0,3.0),(0.0,3.0,4.0),(16.0,10.0,13.0),(25.0,-5.0,17.0),(14.0,-15.0,13.0),(2.0,-7.0,0.0),(-9.0,-4.0,43.0),(-2.0,-25.0,-18.0),(-21.0,-5.0,-24.0),(11.0,20.0,-44.0),(-12.0,2.0,-9.0),(-9.0,9.0,-2.0),(-7.0,10.0,0.0),(0.0,0.0,-2.0),(-6.0,0.0,-3.0),(-6.0,6.0,4.0),(9.0,-1.0,2.0),(-3.0,4.0,4.0),(-1.0,4.0,4.0),(16.0,10.0,14.0),(25.0,-6.0,17.0),(15.0,-14.0,11.0),(3.0,-8.0,0.0),(-4.0,-15.0,-15.0),(3.0,2.0,-5.0),(-19.0,-1.0,-26.0),(-13.0,2.0,-8.0),(-10.0,8.0,-3.0),(-1.0,-2.0,-2.0),(-30.0,6.0,-14.0),(-17.0,-5.0,-15.0),(-12.0,-13.0,-14.0),(-20.0,-11.0,-12.0),(-21.0,3.0,-7.0),(-28.0,1.0,-9.0),(-29.0,-4.0,-2.0),(-168.0,29.0,107.0),(-17.0,-11.0,0.0),(48.0,20.0,-10.0),(30.0,-9.0,-16.0),(0.0,-4.0,-3.0),(0.0,-7.0,-3.0),(0.0,-6.0,-3.0),(-6.0,-13.0,-4.0),(-14.0,-11.0,0.0),(8.0,23.0,-43.0),(-10.0,-10.0,0.0),(-14.0,-3.0,4.0),(-4.0,-19.0,45.0),(-30.0,5.0,14.0),(-10.0,23.0,15.0),(8.0,5.0,-44.0),(3.0,7.0,0.0),(16.0,16.0,-6.0),(29.0,7.0,-6.0),(21.0,-10.0,-6.0),(0.0,-3.0,-4.0),(-2.0,-4.0,-4.0),(-1.0,-3.0,-4.0),(0.0,1.0,-3.0),(6.0,-1.0,-1.0),(-11.0,-11.0,-6.0),(-2.0,2.0,1.0),(-10.0,-10.0,-1.0),(-15.0,-3.0,3.0),(-27.0,0.0,17.0),(2.0,-2.0,6.0),(-10.0,15.0,11.0),(2.0,8.0,0.0),(18.0,16.0,-5.0),(29.0,7.0,-5.0),(20.0,-9.0,-7.0),(0.0,-4.0,-5.0),(0.0,-3.0,-3.0),(9.0,1.0,0.0),(17.0,-10.0,-14.0),(22.0,-3.0,-8.0),(17.0,-11.0,-8.0),(24.0,-10.0,-3.0),(0.0,50.0,-14.0),(1.0,39.0,-16.0),(-5.0,39.0,-20.0),(2.0,41.0,-18.0),(0.0,40.0,-18.0),(3.0,33.0,-12.0),(-1.0,27.0,-8.0),(-12.0,1.0,8.0),(-2.0,15.0,-1.0),(-5.0,1.0,6.0),(-9.0,6.0,20.0),(0.0,-2.0,4.0),(-3.0,-10.0,4.0),(0.0,17.0,-4.0),(-9.0,13.0,7.0),(-34.0,39.0,26.0),(-14.0,24.0,29.0),(-8.0,19.0,34.0),(12.0,9.0,34.0),(4.0,-2.0,2.0),(2.0,-6.0,0.0),(21.0,9.0,-21.0),(37.0,0.0,-15.0),(-3.0,-11.0,9.0),(26.0,-8.0,-8.0),(27.0,-5.0,3.0),(2.0,-29.0,-9.0),(-4.0,-53.0,36.0),(41.0,11.0,16.0),(-7.0,53.0,-42.0),(20.0,13.0,22.0),(22.0,11.0,49.0),(24.0,9.0,26.0),(1.0,7.0,0.0),(5.0,1.0,-1.0),(32.0,-9.0,-31.0),(5.0,-26.0,-42.0),(-2.0,-28.0,-39.0),(-30.0,-40.0,-38.0),(-7.0,-9.0,-8.0),(-1.0,-4.0,-2.0),(0.0,0.0,-5.0),(-1.0,-7.0,-17.0),(1.0,-22.0,8.0),(-4.0,-6.0,-15.0),(0.0,-29.0,13.0),(-3.0,-41.0,20.0),(-1.0,-42.0,22.0),(-6.0,-42.0,14.0),(0.0,-38.0,16.0),(8.0,3.0,18.0),(21.0,-10.0,31.0),(0.0,1.0,5.0),(-2.0,6.0,4.0),(12.0,-7.0,3.0),(4.0,6.0,0.0),(22.0,12.0,20.0),(27.0,-5.0,19.0),(19.0,-16.0,13.0),(1.0,-14.0,0.0),(-2.0,-18.0,-20.0),(-22.0,-3.0,-30.0),(-16.0,3.0,-10.0),(-16.0,-16.0,-16.0),(-11.0,15.0,0.0),(-17.0,-7.0,-11.0),(-18.0,-22.0,-12.0),(-32.0,-27.0,-6.0),(-22.0,-5.0,-2.0),(-24.0,3.0,-5.0),(-24.0,-5.0,-4.0),(-21.0,4.0,-7.0),(-35.0,24.0,-7.0),(-23.0,20.0,5.0),(-20.0,4.0,2.0),(-9.0,-15.0,-3.0),(-22.0,14.0,9.0),(-18.0,-4.0,2.0),(-32.0,1.0,20.0),(-10.0,18.0,16.0),(1.0,14.0,-1.0),(21.0,17.0,-4.0),(32.0,7.0,-7.0),(28.0,-11.0,-10.0),(5.0,-4.0,2.0),(10.0,7.0,0.0),(0.0,-7.0,-4.0),(3.0,0.0,-5.0),(30.0,13.0,-20.0),(15.0,-2.0,-14.0),(1.0,39.0,-15.0),(-2.0,42.0,-16.0),(3.0,41.0,-22.0),(2.0,42.0,-20.0),(2.0,29.0,-11.0),(-10.0,5.0,12.0),(3.0,22.0,-8.0),(-10.0,6.0,17.0),(-2.0,0.0,4.0),(-2.0,5.0,2.0),(-10.0,8.0,5.0),(-45.0,37.0,22.0),(-20.0,27.0,36.0),(-11.0,25.0,40.0),(17.0,11.0,41.0),(4.0,-2.0,2.0),(1.0,-6.0,0.0),(34.0,-7.0,-16.0),(39.0,-8.0,-36.0),(28.0,-12.0,-12.0),(-20.0,-54.0,38.0),(-13.0,-47.0,38.0),(35.0,160.0,61.0),(21.0,2.0,6.0),(-24.0,3.0,2.0),(-22.0,-6.0,-11.0),(-29.0,-5.0,2.0),(0.0,-6.0,1.0),(1.0,15.0,4.0),(25.0,3.0,1.0),(0.0,3.0,9.0),(21.0,1.0,13.0),(-1.0,-1.0,7.0),(4.0,0.0,-17.0),(23.0,1.0,5.0),(3.0,-3.0,-7.0),(24.0,-1.0,8.0),(3.0,-8.0,-4.0),(0.0,-5.0,0.0),(-27.0,0.0,-12.0),(-23.0,-2.0,-7.0),(-25.0,0.0,-2.0),(-6.0,-11.0,25.0),(-35.0,-3.0,2.0),(-10.0,0.0,5.0),(8.0,8.0,-19.0),(0.0,10.0,-1.0),(3.0,8.0,4.0),(2.0,4.0,3.0),(9.0,1.0,-4.0),(0.0,1.0,9.0),(27.0,0.0,3.0),(0.0,-1.0,8.0),(0.0,5.0,-3.0),(15.0,64.0,10.0),(-5.0,18.0,27.0),(11.0,-39.0,-47.0),(0.0,-5.0,0.0),(0.0,-9.0,0.0),(0.0,-28.0,12.0),(19.0,0.0,6.0),(0.0,-4.0,3.0),(2.0,2.0,-8.0),(26.0,1.0,7.0),(3.0,-2.0,-8.0),(7.0,0.0,8.0),(5.0,-4.0,-3.0),(4.0,-7.0,-2.0),(0.0,-10.0,3.0),(0.0,-7.0,19.0),(-8.0,0.0,-10.0),(-32.0,0.0,-13.0),(-27.0,2.0,1.0),(0.0,-19.0,3.0),(-31.0,-9.0,-13.0),(6.0,-48.0,-3.0),(-36.0,46.0,4.0),(-8.0,2.0,7.0),(1.0,0.0,17.0),(1.0,22.0,-7.0),(-3.0,11.0,-12.0),(3.0,10.0,-9.0),(3.0,2.0,7.0),(4.0,3.0,-1.0),(10.0,4.0,-5.0),(3.0,0.0,6.0),(-4.0,5.0,-4.0),(6.0,0.0,0.0),(9.0,28.0,-9.0),(-1.0,9.0,0.0),(-4.0,4.0,1.0),(-1.0,20.0,25.0),(-4.0,18.0,33.0),(-13.0,-2.0,46.0),(-14.0,-3.0,0.0),(30.0,4.0,0.0),(22.0,-1.0,0.0),(21.0,3.0,10.0),(14.0,0.0,5.0),(12.0,-2.0,5.0),(-7.0,4.0,-54.0),(11.0,-18.0,-32.0),(9.0,-20.0,-23.0),(-2.0,-5.0,-2.0),(0.0,-8.0,0.0),(8.0,-27.0,14.0),(5.0,0.0,1.0),(-5.0,-5.0,2.0),(6.0,0.0,-4.0),(8.0,-4.0,10.0),(3.0,-2.0,2.0),(5.0,-3.0,-6.0),(-1.0,-9.0,10.0),(-6.0,-12.0,11.0),(2.0,-21.0,5.0),(6.0,0.0,-16.0),(-5.0,-2.0,-9.0),(-27.0,0.0,-12.0),(-1.0,-49.0,-4.0),(-33.0,4.0,6.0),(-1.0,-59.0,18.0),(-1.0,-45.0,18.0),(-52.0,1.0,-8.0),(21.0,38.0,-28.0),(-31.0,0.0,-5.0),(3.0,55.0,-16.0),(-8.0,1.0,5.0),(-3.0,8.0,28.0),(-2.0,6.0,25.0),(1.0,35.0,-15.0),(3.0,23.0,-9.0),(0.0,10.0,-10.0),(4.0,5.0,4.0),(3.0,10.0,-11.0),(-5.0,1.0,0.0),(2.0,4.0,-4.0),(-6.0,25.0,-15.0),(-7.0,8.0,2.0),(-2.0,4.0,1.0),(0.0,20.0,28.0),(-1.0,17.0,37.0),(-7.0,-6.0,39.0),(-9.0,-20.0,5.0),(2.0,-1.0,14.0),(11.0,19.0,-4.0),(8.0,6.0,0.0),(0.0,-14.0,21.0),(14.0,17.0,-20.0),(10.0,-2.0,5.0),(26.0,0.0,2.0),(24.0,3.0,7.0),(11.0,2.0,0.0),(7.0,-16.0,24.0),(7.0,14.0,-20.0),(7.0,-6.0,5.0),(10.0,-17.0,7.0),(7.0,3.0,-13.0),(-9.0,18.0,-9.0),(8.0,6.0,-39.0),(15.0,-18.0,-34.0),(12.0,-19.0,-26.0),(-2.0,-5.0,-2.0),(-4.0,-8.0,-2.0),(-9.0,-26.0,12.0),(0.0,-3.0,4.0),(-4.0,-2.0,-1.0),(1.0,-10.0,11.0),(5.0,-4.0,-2.0),(-3.0,-11.0,10.0),(0.0,-22.0,10.0),(-1.0,-36.0,14.0),(8.0,-5.0,-26.0),(8.0,-8.0,-26.0),(-4.0,-1.0,-6.0),(0.0,-55.0,16.0),(-30.0,-3.0,-7.0),(12.0,-37.0,35.0),(-50.0,-12.0,-16.0),(7.0,-19.0,-27.0),(3.0,-1.0,-16.0),(8.0,5.0,-41.0),(7.0,37.0,-42.0),(50.0,19.0,12.0),(14.0,27.0,13.0),(0.0,39.0,-34.0),(21.0,21.0,43.0),(24.0,26.0,13.0),(1.0,7.0,0.0),(5.0,2.0,-1.0),(34.0,-21.0,-27.0),(7.0,-26.0,-44.0),(-1.0,-26.0,-44.0),(-39.0,-35.0,-48.0),(-4.0,-6.0,-5.0),(-2.0,-8.0,-17.0),(0.0,-29.0,3.0),(-2.0,-43.0,21.0),(-1.0,-31.0,19.0),(-1.0,-11.0,6.0),(-5.0,-41.0,14.0),(14.0,10.0,34.0),(10.0,-47.0,15.0),(14.0,17.0,11.0),(23.0,4.0,22.0),(25.0,-4.0,21.0),(24.0,-28.0,18.0),(3.0,-26.0,0.0),(-9.0,-35.0,-24.0),(-28.0,-9.0,-41.0),(-14.0,5.0,-12.0),(-15.0,-16.0,-3.0),(-16.0,11.0,-16.0),(-10.0,-15.0,-6.0),(-14.0,-16.0,-3.0),(-21.0,-32.0,5.0),(-19.0,-29.0,9.0),(-22.0,5.0,-3.0),(-22.0,5.0,-3.0),(-21.0,-8.0,-6.0),(-21.0,-6.0,-5.0),(-16.0,29.0,-17.0),(-21.0,30.0,-14.0),(-15.0,14.0,0.0),(-14.0,14.0,1.0),(-19.0,-13.0,8.0),(-16.0,15.0,-3.0),(-17.0,-6.0,7.0),(-43.0,6.0,26.0),(-19.0,34.0,19.0),(1.0,26.0,0.0),(27.0,30.0,-9.0),(31.0,6.0,-10.0),(30.0,-3.0,-11.0),(18.0,-14.0,-5.0),(12.0,47.0,-11.0),(25.0,-8.0,-26.0),(-3.0,42.0,-15.0),(1.0,11.0,-7.0),(3.0,31.0,-18.0),(3.0,43.0,-21.0),(-2.0,28.0,-3.0),(-10.0,8.0,16.0),(-5.0,5.0,3.0),(-58.0,32.0,29.0),(-19.0,26.0,40.0),(-11.0,25.0,44.0),(19.0,22.0,37.0),(4.0,-2.0,2.0),(2.0,-6.0,-1.0),(29.0,-24.0,-2.0),(37.0,-19.0,-30.0),(-10.0,-40.0,32.0),(-11.0,-31.0,39.0),(24.0,-34.0,-5.0),(-9.0,-4.0,38.0),(-3.0,5.0,17.0),(-6.0,7.0,32.0),(-23.0,1.0,-2.0),(1.0,4.0,2.0),(-14.0,2.0,1.0),(17.0,39.0,-28.0),(-4.0,9.0,25.0),(-5.0,8.0,23.0),(1.0,1.0,7.0),(10.0,51.0,-9.0),(2.0,36.0,-16.0),(3.0,24.0,-10.0),(-5.0,0.0,-1.0),(0.0,11.0,-11.0),(-21.0,15.0,-2.0),(-4.0,6.0,6.0),(-3.0,5.0,0.0),(-3.0,9.0,21.0),(-1.0,9.0,21.0),(1.0,0.0,38.0),(6.0,2.0,17.0),(11.0,2.0,15.0),(1.0,18.0,-1.0),(21.0,6.0,4.0),(33.0,5.0,2.0),(31.0,-3.0,11.0),(22.0,-5.0,4.0),(2.0,-17.0,2.0),(16.0,-1.0,-11.0),(13.0,0.0,-13.0),(14.0,0.0,-35.0),(7.0,-9.0,-20.0),(6.0,-9.0,-20.0),(-2.0,-5.0,-1.0),(-1.0,-6.0,-7.0),(-19.0,-17.0,-4.0),(-4.0,-12.0,9.0),(-4.0,0.0,0.0),(1.0,-23.0,11.0),(-1.0,-37.0,17.0),(10.0,-49.0,11.0),(5.0,-2.0,-7.0),(3.0,-8.0,-23.0),(7.0,-9.0,-24.0),(8.0,-37.0,34.0),(-11.0,-4.0,-8.0),(1.0,-3.0,-1.0),(-22.0,-4.0,-6.0),(7.0,-7.0,-33.0),(5.0,-4.0,-16.0),(6.0,6.0,-38.0),(17.0,35.0,14.0),(20.0,31.0,31.0),(3.0,39.0,-43.0),(27.0,26.0,12.0),(2.0,7.0,2.0),(4.0,2.0,-1.0),(32.0,-33.0,-24.0),(10.0,-25.0,-46.0),(0.0,-24.0,-47.0),(-46.0,-33.0,-55.0),(2.0,-44.0,25.0),(0.0,-26.0,16.0),(0.0,-18.0,11.0),(25.0,-32.0,43.0),(21.0,-4.0,21.0),(26.0,-11.0,27.0),(27.0,-52.0,18.0),(3.0,-32.0,0.0),(-14.0,-48.0,-25.0),(-35.0,-15.0,-47.0),(-10.0,-16.0,0.0),(-21.0,11.0,-23.0),(-11.0,-16.0,0.0),(-14.0,-32.0,9.0),(-16.0,-30.0,12.0),(-13.0,-40.0,21.0),(25.0,-2.0,25.0),(-47.0,10.0,-41.0),(-26.0,1.0,-3.0),(-17.0,2.0,-2.0),(-17.0,-5.0,-5.0),(-25.0,-3.0,-6.0),(-24.0,-9.0,6.0),(-32.0,-5.0,13.0),(24.0,46.0,-39.0),(-12.0,28.0,-18.0),(-12.0,31.0,-14.0),(-13.0,13.0,-3.0),(-26.0,-12.0,13.0),(-11.0,16.0,-4.0),(-52.0,11.0,31.0),(-25.0,46.0,16.0),(1.0,33.0,0.0),(27.0,54.0,-8.0),(34.0,13.0,-15.0),(27.0,6.0,-11.0),(37.0,36.0,-31.0),(3.0,18.0,-11.0),(4.0,25.0,-15.0),(6.0,45.0,-22.0),(-67.0,28.0,33.0),(-19.0,24.0,44.0),(-10.0,25.0,46.0),(17.0,34.0,33.0),(4.0,-2.0,2.0),(3.0,-7.0,-1.0),(31.0,-23.0,0.0),(-10.0,-41.0,42.0),(-8.0,-25.0,22.0),(27.0,-18.0,-11.0),(-2.0,-7.0,14.0),(-15.0,0.0,34.0),(-17.0,13.0,26.0),(7.0,10.0,-5.0),(13.0,28.0,4.0),(0.0,11.0,1.0),(12.0,49.0,-7.0),(1.0,35.0,-15.0),(-27.0,0.0,9.0),(4.0,24.0,-13.0),(-4.0,5.0,6.0),(-2.0,5.0,0.0),(1.0,6.0,24.0),(0.0,16.0,7.0),(1.0,3.0,28.0),(6.0,2.0,18.0),(12.0,0.0,13.0),(17.0,2.0,11.0),(-1.0,25.0,3.0),(36.0,5.0,8.0),(36.0,-3.0,6.0),(2.0,-24.0,-3.0),(21.0,0.0,-4.0),(16.0,1.0,-8.0),(12.0,-2.0,-13.0),(12.0,-3.0,-26.0),(5.0,-15.0,-6.0),(9.0,-6.0,-22.0),(-2.0,-5.0,-1.0),(-1.0,-6.0,-6.0),(1.0,-23.0,15.0),(-22.0,-1.0,-19.0),(-1.0,-36.0,16.0),(13.0,-48.0,11.0),(2.0,-11.0,-1.0),(15.0,-26.0,2.0),(5.0,-10.0,7.0),(-5.0,-14.0,-32.0),(0.0,0.0,-37.0),(2.0,8.0,-13.0),(20.0,20.0,22.0),(19.0,31.0,5.0),(-2.0,-1.0,5.0),(8.0,31.0,-36.0),(1.0,7.0,2.0),(5.0,2.0,0.0),(34.0,-37.0,-31.0),(7.0,-27.0,-43.0),(-2.0,-27.0,-42.0),(-10.0,-37.0,33.0),(4.0,-29.0,13.0),(-2.0,-24.0,-19.0),(16.0,-12.0,21.0),(23.0,-15.0,26.0),(33.0,-47.0,23.0),(6.0,-22.0,-1.0),(2.0,-41.0,-6.0),(-24.0,-50.0,-34.0),(-3.0,-14.0,6.0),(-50.0,-19.0,-58.0),(-10.0,-31.0,11.0),(-13.0,-30.0,15.0),(19.0,-28.0,37.0),(96.0,-55.0,139.0),(1.0,0.0,-2.0),(2.0,0.0,2.0),(2.0,3.0,0.0),(0.0,0.0,3.0),(-2.0,-2.0,0.0),(-3.0,0.0,0.0),(-4.0,2.0,-1.0),(0.0,0.0,-4.0),(0.0,0.0,-3.0),(3.0,3.0,0.0),(4.0,-2.0,2.0),(1.0,2.0,1.0),(0.0,1.0,4.0),(-1.0,-1.0,2.0),(-2.0,-3.0,1.0),(-3.0,4.0,0.0),(7.0,1.0,9.0),(1.0,1.0,3.0),(-5.0,-2.0,-8.0),(-4.0,1.0,-4.0),(-10.0,2.0,-1.0),(-1.0,0.0,-2.0),(-1.0,-1.0,-5.0),(-3.0,5.0,-2.0),(-20.0,16.0,0.0),(25.0,-12.0,-2.0),(5.0,0.0,1.0),(8.0,-8.0,2.0),(1.0,1.0,4.0),(0.0,0.0,3.0),(0.0,1.0,2.0),(4.0,0.0,3.0),(2.0,0.0,4.0),(2.0,3.0,5.0),(0.0,2.0,4.0),(0.0,3.0,4.0),(-2.0,-5.0,0.0),(0.0,-2.0,-3.0),(-6.0,5.0,3.0),(-5.0,0.0,-4.0),(-4.0,-4.0,-9.0),(0.0,-4.0,-4.0),(-28.0,16.0,-7.0),(-1.0,0.0,-3.0),(-16.0,10.0,-25.0),(-4.0,-2.0,-42.0),(11.0,-5.0,45.0),(16.0,-9.0,0.0),(8.0,-6.0,5.0),(34.0,-52.0,-6.0),(7.0,-7.0,3.0),(-19.0,23.0,0.0),(-14.0,19.0,0.0),(-7.0,10.0,4.0),(-3.0,0.0,-33.0),(-9.0,8.0,-9.0),(-17.0,10.0,-5.0),(-3.0,-2.0,-21.0),(-10.0,9.0,-6.0),(-3.0,12.0,-10.0),(-10.0,-7.0,-6.0),(12.0,-1.0,13.0),(8.0,6.0,22.0),(8.0,2.0,43.0),(15.0,-6.0,22.0),(6.0,0.0,0.0),(20.0,-18.0,6.0),(1.0,1.0,3.0),(4.0,0.0,4.0),(0.0,4.0,5.0),(4.0,4.0,10.0),(3.0,-1.0,4.0),(0.0,4.0,5.0),(-4.0,2.0,3.0),(-14.0,23.0,9.0),(13.0,-28.0,-9.0),(1.0,-7.0,-2.0),(-16.0,19.0,9.0),(-8.0,-1.0,-9.0),(-11.0,-9.0,-20.0),(-2.0,-3.0,-3.0),(16.0,-5.0,-1.0),(7.0,-5.0,4.0),(-5.0,-1.0,-7.0),(10.0,0.0,29.0),(-8.0,-7.0,-28.0),(8.0,-11.0,3.0),(14.0,-17.0,-2.0),(18.0,-25.0,-8.0),(36.0,-25.0,11.0),(10.0,0.0,12.0),(-22.0,-4.0,-37.0),(-5.0,-2.0,-17.0),(-10.0,10.0,-9.0),(-7.0,8.0,-4.0),(-13.0,15.0,-3.0),(-13.0,15.0,0.0),(-16.0,20.0,-4.0),(-2.0,0.0,-17.0),(-17.0,16.0,-7.0),(-4.0,-2.0,-3.0),(-18.0,12.0,-7.0),(-11.0,7.0,-6.0),(-4.0,3.0,-5.0),(-26.0,2.0,-23.0),(-32.0,-4.0,-20.0),(-16.0,-2.0,-10.0),(-15.0,-1.0,-13.0),(-23.0,1.0,-11.0),(-25.0,0.0,-3.0),(-15.0,4.0,-5.0),(-15.0,-7.0,-1.0),(-25.0,-2.0,-6.0),(-25.0,-1.0,1.0),(-19.0,0.0,6.0),(-18.0,0.0,4.0),(-38.0,0.0,6.0),(-55.0,-13.0,16.0),(-11.0,2.0,17.0),(-16.0,-13.0,0.0),(-11.0,-9.0,4.0),(-35.0,-50.0,10.0),(-6.0,-9.0,1.0),(15.0,26.0,6.0),(11.0,20.0,5.0),(3.0,12.0,7.0),(1.0,7.0,-1.0),(10.0,7.0,-1.0),(12.0,9.0,6.0),(-51.0,-36.0,5.0),(-1.0,2.0,-2.0),(2.0,-1.0,-1.0),(2.0,-2.0,1.0),(2.0,0.0,-1.0),(0.0,0.0,3.0),(-1.0,1.0,3.0),(4.0,4.0,1.0),(7.0,7.0,3.0),(-2.0,0.0,1.0),(-21.0,-4.0,4.0),(-2.0,1.0,3.0),(6.0,-2.0,-7.0),(4.0,0.0,-2.0),(4.0,1.0,-2.0),(0.0,-1.0,-1.0),(-3.0,-3.0,-1.0),(-1.0,3.0,-2.0),(0.0,0.0,-3.0),(2.0,0.0,-2.0),(2.0,-2.0,0.0),(3.0,4.0,0.0),(3.0,-4.0,3.0),(0.0,-1.0,2.0),(9.0,7.0,3.0),(18.0,19.0,8.0),(1.0,6.0,-1.0),(-4.0,-7.0,3.0),(-26.0,-18.0,-3.0),(-1.0,4.0,4.0),(-8.0,1.0,7.0),(-6.0,0.0,1.0),(-1.0,2.0,3.0),(-4.0,-4.0,-6.0),(-1.0,3.0,-2.0),(1.0,-3.0,-4.0),(3.0,-2.0,-4.0),(2.0,0.0,-3.0),(5.0,0.0,-2.0),(5.0,0.0,-2.0),(0.0,0.0,-1.0),(0.0,1.0,-3.0),(2.0,-1.0,-2.0),(8.0,9.0,1.0),(5.0,0.0,1.0),(3.0,-4.0,3.0),(36.0,29.0,-7.0),(20.0,0.0,-37.0),(13.0,-2.0,-19.0),(12.0,0.0,-3.0),(7.0,8.0,-6.0),(-14.0,-13.0,10.0),(-12.0,-8.0,1.0),(-17.0,-13.0,0.0),(-6.0,2.0,2.0),(-17.0,-18.0,0.0),(-8.0,0.0,14.0),(-15.0,-21.0,-2.0),(-9.0,-17.0,-6.0),(-11.0,-17.0,0.0),(-8.0,-10.0,1.0),(-10.0,-12.0,5.0),(-25.0,-1.0,30.0),(-14.0,-2.0,7.0),(31.0,5.0,-24.0),(16.0,30.0,21.0),(12.0,24.0,14.0),(8.0,21.0,7.0),(7.0,11.0,0.0),(-17.0,2.0,22.0),(18.0,6.0,-22.0),(-7.0,0.0,3.0),(9.0,6.0,0.0),(12.0,6.0,8.0),(-5.0,3.0,2.0),(-16.0,4.0,13.0),(-11.0,0.0,5.0),(-1.0,8.0,2.0),(-8.0,-22.0,-14.0),(-3.0,5.0,-2.0),(0.0,-2.0,-4.0),(1.0,-3.0,-5.0),(6.0,1.0,-2.0),(7.0,-2.0,-7.0),(2.0,-4.0,-5.0),(4.0,2.0,-2.0),(2.0,0.0,-1.0),(19.0,21.0,2.0),(6.0,0.0,2.0),(19.0,9.0,-15.0),(23.0,0.0,-36.0),(16.0,-3.0,-18.0),(3.0,9.0,-5.0),(42.0,13.0,-24.0),(28.0,31.0,-27.0),(-9.0,28.0,-19.0),(-8.0,31.0,-14.0),(-70.0,13.0,34.0),(-1.0,14.0,-7.0),(-40.0,48.0,22.0),(-2.0,40.0,7.0),(4.0,23.0,2.0),(35.0,50.0,-11.0),(30.0,17.0,-15.0),(21.0,14.0,-13.0),(-11.0,23.0,16.0),(5.0,30.0,-12.0),(0.0,37.0,-34.0),(-20.0,25.0,39.0),(-11.0,27.0,42.0),(17.0,39.0,41.0),(4.0,-2.0,2.0),(2.0,-7.0,-2.0),(-4.0,-30.0,31.0),(1.0,-2.0,6.0),(15.0,-30.0,14.0),(-6.0,1.0,24.0),(-7.0,1.0,24.0),(-5.0,1.0,24.0),(8.0,45.0,-25.0),(4.0,16.0,0.0),(10.0,31.0,-4.0),(-5.0,-1.0,7.0),(0.0,30.0,-9.0),(-2.0,5.0,1.0),(3.0,3.0,20.0),(-2.0,-10.0,9.0),(6.0,18.0,0.0),(1.0,20.0,-7.0),(1.0,2.0,21.0),(7.0,0.0,16.0),(12.0,-1.0,14.0),(18.0,2.0,11.0),(35.0,17.0,7.0),(37.0,-14.0,7.0),(21.0,0.0,-4.0),(16.0,3.0,-8.0),(12.0,-1.0,-12.0),(9.0,-2.0,-19.0),(0.0,-19.0,9.0),(7.0,-17.0,2.0),(0.0,10.0,-11.0),(11.0,-4.0,-17.0),(-2.0,-4.0,-1.0),(-1.0,-30.0,9.0),(0.0,1.0,-9.0),(10.0,-31.0,10.0),(5.0,-15.0,0.0),(2.0,-45.0,28.0),(3.0,-1.0,-26.0),(4.0,-2.0,-25.0),(3.0,0.0,-24.0),(9.0,23.0,19.0),(13.0,18.0,-28.0),(5.0,2.0,0.0),(34.0,-40.0,-40.0),(4.0,-29.0,-37.0),(-1.0,-36.0,16.0),(12.0,-19.0,14.0),(0.0,-24.0,-32.0),(20.0,-18.0,25.0),(39.0,-42.0,28.0),(11.0,-44.0,-2.0),(3.0,-48.0,-11.0),(3.0,-17.0,10.0),(-41.0,-72.0,-42.0),(-9.0,-36.0,17.0),(-2.0,-24.0,8.0),(4.0,-13.0,27.0),(11.0,6.0,41.0),(8.0,10.0,23.0),(9.0,-29.0,8.0),(1.0,6.0,11.0),(9.0,10.0,23.0),(6.0,1.0,10.0),(0.0,5.0,10.0),(5.0,0.0,1.0),(23.0,-14.0,6.0),(-1.0,5.0,3.0),(11.0,-12.0,1.0),(0.0,3.0,3.0),(0.0,4.0,3.0),(-1.0,4.0,4.0),(-1.0,-5.0,0.0),(1.0,-4.0,-2.0),(-7.0,5.0,3.0),(-4.0,0.0,-3.0),(-2.0,-7.0,-8.0),(0.0,-4.0,-4.0),(-24.0,12.0,-6.0),(-4.0,5.0,-2.0),(-3.0,-4.0,-6.0),(-4.0,-15.0,-10.0),(19.0,-11.0,-1.0),(9.0,-8.0,5.0),(-8.0,2.0,4.0),(3.0,-12.0,-4.0),(13.0,-20.0,-3.0),(19.0,-24.0,-9.0),(11.0,0.0,15.0),(31.0,-16.0,-2.0),(-1.0,22.0,20.0),(3.0,32.0,29.0),(3.0,24.0,21.0),(6.0,-2.0,4.0),(2.0,-35.0,-27.0),(-1.0,-30.0,-29.0),(-3.0,-21.0,-22.0),(-6.0,-13.0,-15.0),(-8.0,-8.0,-19.0),(-12.0,-2.0,-23.0),(-11.0,4.0,-15.0),(-10.0,9.0,-10.0),(-11.0,13.0,-7.0),(-13.0,15.0,-3.0),(-15.0,18.0,-6.0),(-3.0,-1.0,-2.0),(-17.0,20.0,-7.0),(-6.0,-2.0,0.0),(-16.0,9.0,-4.0),(-19.0,10.0,-6.0),(-17.0,1.0,-1.0),(0.0,9.0,-6.0),(-5.0,0.0,-6.0),(-22.0,-6.0,-8.0),(-31.0,-7.0,-18.0),(-20.0,-2.0,-13.0),(-10.0,-2.0,-9.0),(-19.0,-3.0,-5.0),(-43.0,-6.0,-2.0),(-41.0,4.0,-14.0),(-19.0,0.0,-2.0),(-13.0,1.0,4.0),(-23.0,1.0,5.0),(-36.0,4.0,3.0),(-24.0,3.0,0.0),(-7.0,-2.0,4.0),(-1.0,-8.0,4.0),(-17.0,-3.0,-5.0),(-19.0,-11.0,-2.0),(-15.0,-10.0,-3.0),(-5.0,1.0,-1.0),(-18.0,-21.0,0.0),(-3.0,1.0,0.0),(-14.0,-21.0,0.0),(-12.0,-16.0,0.0),(-11.0,-15.0,2.0),(-10.0,-13.0,5.0),(-13.0,-6.0,10.0),(-17.0,-1.0,16.0),(-14.0,4.0,13.0),(-10.0,10.0,12.0),(-13.0,18.0,18.0),(-13.0,25.0,24.0),(-10.0,33.0,21.0),(7.0,2.0,0.0),(13.0,-23.0,-17.0),(15.0,-26.0,-23.0),(8.0,-19.0,-18.0),(25.0,21.0,14.0),(15.0,2.0,-8.0),(12.0,26.0,16.0),(7.0,21.0,7.0),(-1.0,12.0,4.0),(-5.0,-2.0,-8.0),(10.0,10.0,0.0),(14.0,13.0,9.0),(-16.0,15.0,10.0),(-3.0,-6.0,0.0),(-23.0,-15.0,-3.0),(-1.0,6.0,4.0),(-6.0,3.0,6.0),(-4.0,0.0,0.0),(-4.0,-5.0,-5.0),(-1.0,4.0,2.0),(0.0,4.0,-2.0),(1.0,-5.0,-3.0),(1.0,-2.0,-3.0),(2.0,-2.0,-1.0),(8.0,13.0,1.0),(1.0,-5.0,-2.0),(21.0,19.0,4.0),(6.0,-1.0,0.0),(4.0,-3.0,-4.0),(-1.0,-1.0,-5.0),(10.0,1.0,-7.0),(16.0,-6.0,-17.0),(6.0,-5.0,-9.0),(7.0,33.0,-4.0),(16.0,-9.0,-18.0),(26.0,-4.0,-33.0),(12.0,16.0,-24.0),(-2.0,24.0,-9.0),(-5.0,35.0,-18.0),(-59.0,67.0,22.0),(6.0,17.0,-9.0),(-6.0,48.0,12.0),(7.0,45.0,4.0),(43.0,46.0,-13.0),(26.0,21.0,-14.0),(-14.0,23.0,29.0),(14.0,20.0,-10.0),(1.0,35.0,-14.0),(-12.0,29.0,36.0),(14.0,41.0,49.0),(4.0,-1.0,2.0),(2.0,-18.0,31.0),(-4.0,4.0,14.0),(-3.0,4.0,14.0),(-2.0,4.0,14.0),(15.0,29.0,1.0),(-3.0,4.0,0.0),(9.0,32.0,-5.0),(-6.0,7.0,33.0),(-5.0,1.0,21.0),(6.0,9.0,-3.0),(11.0,11.0,-11.0),(6.0,15.0,-5.0),(7.0,0.0,16.0),(10.0,0.0,17.0),(19.0,-1.0,9.0),(36.0,0.0,9.0),(37.0,4.0,5.0),(20.0,3.0,-1.0),(17.0,1.0,-12.0),(12.0,0.0,-12.0),(4.0,-15.0,8.0),(7.0,-11.0,15.0),(5.0,-8.0,4.0),(4.0,-2.0,-23.0),(6.0,-7.0,-31.0),(9.0,-31.0,9.0),(-2.0,-4.0,-1.0),(18.0,-27.0,4.0),(3.0,-4.0,-14.0),(2.0,-3.0,-13.0),(5.0,1.0,0.0),(3.0,-4.0,-14.0),(40.0,-66.0,-50.0),(14.0,-20.0,9.0),(27.0,-30.0,28.0),(4.0,-13.0,-35.0),(40.0,-53.0,24.0),(15.0,-59.0,0.0),(-2.0,-72.0,-19.0),(-5.0,-32.0,26.0),(-15.0,-49.0,17.0),(4.0,13.0,23.0),(-9.0,-42.0,9.0),(9.0,9.0,26.0),(9.0,14.0,22.0),(9.0,-22.0,6.0),(5.0,13.0,13.0),(19.0,-27.0,-5.0),(3.0,0.0,3.0),(-1.0,6.0,4.0),(-4.0,1.0,3.0),(-1.0,-6.0,1.0),(2.0,-7.0,0.0),(-17.0,21.0,8.0),(-6.0,-5.0,-8.0),(-5.0,-13.0,-17.0),(0.0,-9.0,-3.0),(22.0,-13.0,-1.0),(6.0,-7.0,1.0),(-9.0,2.0,6.0),(1.0,-8.0,1.0),(12.0,-18.0,-1.0),(22.0,-18.0,-2.0),(6.0,33.0,30.0),(5.0,27.0,22.0),(17.0,19.0,20.0),(-7.0,21.0,9.0),(14.0,-24.0,-5.0),(-1.0,-2.0,5.0),(7.0,-41.0,-26.0),(2.0,-35.0,-27.0),(-2.0,-30.0,-30.0),(-3.0,-21.0,-23.0),(-5.0,-13.0,-15.0),(-9.0,-8.0,-20.0),(-13.0,-3.0,-23.0),(-10.0,4.0,-16.0),(-10.0,11.0,-10.0),(-12.0,12.0,-7.0),(-12.0,16.0,-4.0),(-13.0,4.0,1.0),(-8.0,13.0,-7.0),(-19.0,8.0,0.0),(-17.0,6.0,-3.0),(-22.0,4.0,-4.0),(-19.0,0.0,-1.0),(-23.0,0.0,-3.0),(0.0,8.0,-6.0),(-18.0,-8.0,-5.0),(-27.0,-11.0,-12.0),(-14.0,-1.0,-13.0),(-20.0,-6.0,-1.0),(-45.0,-3.0,-11.0),(-46.0,0.0,-7.0),(-19.0,4.0,-6.0),(-19.0,0.0,6.0),(-29.0,8.0,0.0),(-20.0,6.0,-1.0),(-1.0,-9.0,5.0),(-22.0,-3.0,-6.0),(-19.0,0.0,-7.0),(-21.0,-6.0,-4.0),(-16.0,-9.0,-4.0),(-17.0,-8.0,-7.0),(-9.0,-14.0,3.0),(-10.0,-5.0,-6.0),(-12.0,-17.0,0.0),(-11.0,-16.0,3.0),(-10.0,-13.0,5.0),(-14.0,-6.0,11.0),(-17.0,-1.0,16.0),(-15.0,4.0,14.0),(-11.0,10.0,11.0),(-12.0,18.0,19.0),(-13.0,26.0,24.0),(-11.0,32.0,24.0),(-8.0,37.0,22.0),(0.0,4.0,-5.0),(7.0,3.0,0.0),(0.0,21.0,10.0),(25.0,-37.0,-19.0),(15.0,-22.0,-16.0),(20.0,-27.0,-23.0),(16.0,21.0,11.0),(8.0,20.0,5.0),(0.0,7.0,-2.0),(-6.0,-2.0,-8.0),(5.0,9.0,1.0),(17.0,16.0,10.0),(-2.0,8.0,3.0),(-14.0,11.0,13.0),(-8.0,1.0,3.0),(-9.0,-21.0,-13.0),(0.0,8.0,1.0),(-1.0,5.0,-3.0),(-1.0,-3.0,-5.0),(0.0,-3.0,-3.0),(5.0,1.0,0.0),(11.0,28.0,11.0),(12.0,-11.0,-10.0),(7.0,24.0,-3.0),(17.0,-10.0,-16.0),(18.0,-5.0,-19.0),(-11.0,44.0,-12.0),(14.0,-12.0,-19.0),(-11.0,50.0,-23.0),(1.0,31.0,-26.0),(-15.0,71.0,17.0),(10.0,61.0,3.0),(41.0,56.0,-7.0),(-10.0,12.0,34.0),(33.0,34.0,-17.0),(15.0,21.0,-2.0),(11.0,68.0,61.0),(-4.0,4.0,14.0),(-3.0,4.0,15.0),(-4.0,4.0,14.0),(-2.0,20.0,33.0),(19.0,34.0,-1.0),(-6.0,7.0,23.0),(9.0,2.0,15.0),(10.0,8.0,-3.0),(1.0,9.0,-5.0),(11.0,10.0,-9.0),(13.0,-1.0,16.0),(19.0,-3.0,10.0),(37.0,-3.0,14.0),(39.0,7.0,0.0),(21.0,5.0,-1.0),(18.0,2.0,-10.0),(7.0,-11.0,13.0),(0.0,-8.0,6.0),(9.0,-8.0,6.0),(14.0,-1.0,-11.0),(3.0,-8.0,-24.0),(21.0,-32.0,10.0),(11.0,-19.0,-32.0),(3.0,-4.0,-14.0),(20.0,-33.0,13.0),(6.0,-9.0,-14.0),(7.0,-9.0,-14.0),(43.0,-46.0,22.0),(33.0,-54.0,10.0),(15.0,-28.0,-40.0),(22.0,-79.0,3.0),(2.0,-65.0,19.0),(-9.0,-53.0,23.0),(10.0,22.0,28.0),(-5.0,-36.0,19.0),(11.0,-22.0,8.0),(-4.0,1.0,4.0),(-1.0,-7.0,4.0),(1.0,13.0,15.0),(-1.0,-32.0,-23.0),(26.0,-8.0,-1.0),(6.0,-6.0,2.0),(-12.0,2.0,7.0),(0.0,-5.0,4.0),(11.0,-14.0,2.0),(16.0,31.0,30.0),(0.0,46.0,26.0),(1.0,10.0,9.0),(18.0,-27.0,-5.0),(-2.0,-3.0,5.0),(-10.0,-11.0,-6.0),(10.0,-23.0,-10.0),(6.0,-40.0,-26.0),(-7.0,-24.0,-21.0),(-3.0,-30.0,-30.0),(5.0,-22.0,-21.0),(-5.0,-13.0,-16.0),(-16.0,-1.0,-13.0),(-11.0,-6.0,-25.0),(-8.0,2.0,-19.0),(-8.0,8.0,-12.0),(-9.0,11.0,-9.0),(-28.0,15.0,10.0),(-5.0,7.0,-14.0),(-22.0,6.0,0.0),(-23.0,2.0,-2.0),(-24.0,1.0,-3.0),(-23.0,0.0,-2.0),(-23.0,-5.0,-6.0),(-24.0,-13.0,-10.0),(-27.0,-7.0,-9.0),(-47.0,-4.0,-12.0),(-47.0,0.0,-7.0),(-29.0,5.0,-2.0),(-27.0,10.0,0.0),(-24.0,3.0,-4.0),(-22.0,-4.0,-7.0),(-23.0,-3.0,-6.0),(-22.0,-4.0,-7.0),(-21.0,-7.0,-8.0),(-6.0,-10.0,10.0),(-22.0,-16.0,-19.0),(-10.0,-13.0,6.0),(-8.0,-11.0,8.0),(-14.0,-3.0,14.0),(-17.0,0.0,18.0),(-18.0,-2.0,6.0),(-10.0,10.0,12.0),(-5.0,21.0,21.0),(-16.0,24.0,23.0),(-16.0,21.0,15.0),(-8.0,38.0,23.0),(0.0,24.0,11.0),(-12.0,10.0,-1.0),(0.0,2.0,-4.0),(10.0,28.0,11.0),(6.0,-9.0,-7.0),(15.0,-42.0,-20.0),(29.0,-25.0,-18.0),(8.0,16.0,2.0),(0.0,6.0,-4.0),(-8.0,-2.0,-10.0),(6.0,7.0,1.0),(21.0,13.0,12.0),(-13.0,26.0,18.0),(8.0,-11.0,-13.0),(-2.0,8.0,-5.0),(-1.0,-1.0,-5.0),(10.0,26.0,-3.0),(-2.0,39.0,-19.0),(21.0,-18.0,-21.0),(-5.0,58.0,-25.0),(5.0,65.0,-16.0),(14.0,80.0,4.0),(-4.0,29.0,44.0),(30.0,57.0,0.0),(43.0,50.0,-4.0),(0.0,9.0,16.0),(0.0,9.0,16.0),(0.0,9.0,16.0),(4.0,18.0,36.0),(5.0,20.0,22.0),(2.0,18.0,-4.0),(6.0,17.0,-3.0),(8.0,0.0,19.0),(14.0,-3.0,29.0),(16.0,19.0,-18.0),(10.0,8.0,-6.0),(2.0,0.0,-2.0),(0.0,6.0,-6.0),(21.0,-4.0,13.0),(39.0,-1.0,13.0),(40.0,6.0,1.0),(24.0,4.0,-2.0),(-1.0,-6.0,6.0),(0.0,1.0,3.0),(8.0,-8.0,10.0),(5.0,-17.0,21.0),(28.0,4.0,-22.0),(15.0,0.0,-14.0),(6.0,-17.0,7.0),(1.0,-17.0,4.0),(15.0,-20.0,-19.0),(20.0,-16.0,-31.0),(55.0,-45.0,36.0),(3.0,-9.0,-20.0),(2.0,-10.0,-18.0),(34.0,-58.0,1.0),(34.0,-59.0,2.0),(22.0,-87.0,16.0),(-6.0,-33.0,12.0),(3.0,21.0,37.0),(-7.0,-42.0,-12.0),(-5.0,-25.0,9.0),(-2.0,-7.0,11.0),(-2.0,-9.0,3.0),(7.0,37.0,31.0),(6.0,-17.0,-6.0),(22.0,-51.0,-33.0),(0.0,6.0,8.0),(-10.0,0.0,7.0),(1.0,-5.0,4.0),(13.0,-12.0,1.0),(-3.0,46.0,27.0),(-3.0,23.0,16.0),(-3.0,0.0,4.0),(19.0,-21.0,-5.0),(-11.0,-12.0,-5.0),(-16.0,-47.0,-23.0),(8.0,-24.0,-10.0),(-9.0,-23.0,-21.0),(-7.0,-27.0,-27.0),(2.0,-22.0,-21.0),(-13.0,-3.0,-15.0),(-6.0,-12.0,-28.0),(-6.0,-3.0,-22.0),(-3.0,4.0,-15.0),(-29.0,10.0,7.0),(-1.0,3.0,-18.0),(-23.0,1.0,-1.0),(-24.0,0.0,-1.0),(-25.0,0.0,-1.0),(-24.0,-5.0,-7.0),(-24.0,-12.0,-12.0),(-28.0,-8.0,-10.0),(-46.0,-7.0,-3.0),(-46.0,4.0,-16.0),(-28.0,4.0,0.0),(-29.0,9.0,1.0),(-25.0,2.0,-4.0),(-22.0,-3.0,-8.0),(-23.0,-3.0,-8.0),(-23.0,-2.0,-8.0),(-5.0,-6.0,16.0),(-24.0,-12.0,-18.0),(-7.0,-5.0,14.0),(-11.0,1.0,17.0),(-15.0,7.0,23.0),(-17.0,0.0,8.0),(-7.0,20.0,20.0),(-21.0,23.0,20.0),(-17.0,19.0,13.0),(0.0,23.0,12.0),(-30.0,44.0,11.0),(-13.0,9.0,0.0),(12.0,24.0,11.0),(-1.0,-1.0,-6.0),(6.0,-22.0,-14.0),(14.0,-43.0,-21.0),(10.0,15.0,3.0),(1.0,6.0,-3.0),(-6.0,-3.0,-10.0),(4.0,-2.0,-5.0),(0.0,50.0,37.0),(0.0,16.0,6.0),(24.0,-33.0,-25.0),(-3.0,11.0,-4.0),(1.0,9.0,-10.0),(-5.0,28.0,-9.0),(-16.0,39.0,7.0),(20.0,-15.0,-32.0),(-5.0,36.0,-14.0),(21.0,92.0,-5.0),(27.0,62.0,11.0),(26.0,61.0,11.0),(-6.0,9.0,18.0),(-7.0,9.0,19.0),(0.0,19.0,39.0),(-20.0,-8.0,30.0),(38.0,34.0,-8.0),(35.0,24.0,-7.0),(6.0,7.0,12.0),(14.0,15.0,-2.0),(7.0,15.0,-2.0),(5.0,6.0,4.0),(12.0,-4.0,29.0),(14.0,8.0,0.0),(16.0,20.0,-18.0),(3.0,-2.0,-1.0),(14.0,-2.0,4.0),(43.0,2.0,9.0),(44.0,3.0,9.0),(16.0,3.0,1.0),(0.0,1.0,3.0),(4.0,-18.0,23.0),(11.0,-6.0,4.0),(30.0,5.0,-22.0),(7.0,-7.0,-1.0),(5.0,-13.0,5.0),(13.0,-14.0,7.0),(13.0,-7.0,-8.0),(27.0,-19.0,21.0),(30.0,-27.0,21.0),(-1.0,4.0,-36.0),(45.0,-44.0,21.0),(12.0,-12.0,-27.0),(1.0,-15.0,-23.0),(35.0,-39.0,27.0),(32.0,-79.0,20.0),(2.0,19.0,25.0),(-12.0,-75.0,-8.0),(-6.0,-37.0,-7.0),(-1.0,-7.0,10.0),(0.0,19.0,23.0),(-3.0,-14.0,-5.0),(7.0,-31.0,-18.0),(-4.0,0.0,5.0),(6.0,-6.0,2.0),(-6.0,24.0,18.0),(-4.0,1.0,5.0),(-9.0,-26.0,-9.0),(19.0,-15.0,-5.0),(-16.0,-49.0,-22.0),(-14.0,-38.0,-25.0),(-13.0,-28.0,-25.0),(-9.0,-22.0,-28.0),(-4.0,-15.0,-32.0),(-3.0,-6.0,-24.0),(-25.0,0.0,1.0),(0.0,1.0,-19.0),(-24.0,0.0,0.0),(-25.0,-1.0,0.0),(-25.0,-6.0,-7.0),(-25.0,-11.0,-15.0),(-28.0,-7.0,-10.0),(-2.0,-5.0,17.0),(-45.0,-8.0,-1.0),(-43.0,4.0,-17.0),(0.0,5.0,-18.0),(-30.0,4.0,0.0),(-28.0,8.0,3.0),(-27.0,1.0,-3.0),(-22.0,-2.0,-10.0),(-24.0,-2.0,-9.0),(-5.0,-4.0,17.0),(-23.0,0.0,-11.0),(-11.0,3.0,22.0),(-16.0,11.0,26.0),(-19.0,17.0,22.0),(-25.0,23.0,17.0),(-27.0,34.0,14.0),(-30.0,46.0,11.0),(13.0,15.0,12.0),(-15.0,23.0,1.0),(-2.0,0.0,-5.0),(6.0,-22.0,-16.0),(4.0,8.0,0.0),(-2.0,0.0,-5.0),(-6.0,31.0,19.0),(-5.0,12.0,1.0),(11.0,-16.0,-20.0),(0.0,9.0,-8.0),(-14.0,37.0,5.0),(-22.0,74.0,0.0),(16.0,-14.0,-21.0),(30.0,89.0,-6.0),(40.0,45.0,-10.0),(-10.0,13.0,22.0),(-4.0,9.0,28.0),(-14.0,-2.0,34.0),(-4.0,7.0,24.0),(2.0,18.0,15.0),(37.0,26.0,-23.0),(50.0,38.0,-14.0),(32.0,25.0,10.0),(20.0,13.0,2.0),(17.0,9.0,2.0),(10.0,4.0,5.0),(12.0,8.0,0.0),(18.0,-1.0,6.0),(47.0,-8.0,17.0),(52.0,14.0,3.0),(18.0,2.0,1.0),(12.0,-7.0,5.0),(12.0,-3.0,0.0),(17.0,-8.0,4.0),(18.0,-10.0,7.0),(36.0,-22.0,3.0),(37.0,-28.0,34.0),(21.0,-17.0,36.0),(13.0,-18.0,-13.0),(9.0,-10.0,-23.0),(29.0,-43.0,18.0),(-12.0,1.0,24.0),(37.0,-6.0,-75.0),(24.0,-47.0,20.0),(0.0,-49.0,22.0),(-4.0,-52.0,-2.0),(-11.0,0.0,19.0),(0.0,-32.0,-11.0),(0.0,-14.0,-10.0),(-3.0,-2.0,3.0),(-5.0,0.0,5.0),(-12.0,-14.0,-3.0),(-6.0,-22.0,-10.0),(-13.0,-52.0,-22.0),(17.0,-1.0,-1.0),(-16.0,-41.0,-23.0),(-17.0,-32.0,-23.0),(-10.0,-24.0,-29.0),(-4.0,-18.0,-34.0),(-26.0,0.0,3.0),(-2.0,-9.0,-29.0),(-25.0,-2.0,0.0),(-26.0,-6.0,-7.0),(-25.0,-11.0,-17.0),(-8.0,-6.0,18.0),(-25.0,-7.0,-3.0),(-43.0,-7.0,-4.0),(-42.0,2.0,-14.0),(-25.0,4.0,-7.0),(-3.0,6.0,-20.0),(-30.0,7.0,5.0),(-27.0,2.0,-3.0),(-24.0,0.0,-10.0),(-11.0,4.0,25.0),(-23.0,0.0,-13.0),(-18.0,13.0,30.0),(-22.0,20.0,22.0),(-29.0,26.0,13.0),(-28.0,37.0,12.0),(15.0,3.0,9.0),(-29.0,49.0,10.0),(-13.0,20.0,5.0),(-14.0,12.0,-3.0),(-3.0,0.0,-6.0),(-1.0,2.0,-3.0),(-6.0,12.0,9.0),(-10.0,32.0,7.0),(-2.0,2.0,-20.0),(-12.0,52.0,0.0),(4.0,55.0,-19.0),(26.0,55.0,-7.0),(-4.0,-3.0,53.0),(0.0,0.0,27.0),(12.0,26.0,1.0),(-6.0,-23.0,11.0),(10.0,36.0,-11.0),(0.0,10.0,0.0),(1.0,18.0,14.0),(14.0,15.0,-3.0),(37.0,25.0,-21.0),(14.0,11.0,0.0),(27.0,22.0,-2.0),(32.0,24.0,4.0),(24.0,13.0,0.0),(22.0,7.0,5.0),(15.0,-6.0,13.0),(22.0,4.0,-3.0),(41.0,-16.0,25.0),(52.0,22.0,-6.0),(16.0,-2.0,11.0),(21.0,8.0,-5.0),(23.0,-5.0,3.0),(21.0,-10.0,10.0),(34.0,-20.0,9.0),(24.0,-18.0,14.0),(12.0,-8.0,4.0),(20.0,-16.0,37.0),(11.0,-11.0,7.0),(14.0,-19.0,-12.0),(0.0,-11.0,0.0),(7.0,-11.0,2.0),(0.0,-19.0,17.0),(3.0,-21.0,9.0),(7.0,4.0,-5.0),(13.0,-36.0,11.0),(11.0,0.0,-15.0),(16.0,-4.0,-23.0),(11.0,-49.0,3.0),(-14.0,-8.0,19.0),(-17.0,-48.0,13.0),(20.0,-3.0,-25.0),(5.0,-28.0,-20.0),(-12.0,-14.0,-4.0),(-36.0,-56.0,-25.0),(-6.0,-22.0,-10.0),(-20.0,-34.0,-15.0),(20.0,-9.0,-7.0),(-21.0,-34.0,-21.0),(-12.0,-27.0,-29.0),(-27.0,1.0,7.0),(-2.0,-23.0,-42.0),(-17.0,-4.0,6.0),(-12.0,-14.0,-10.0),(-6.0,-5.0,-16.0),(-33.0,-17.0,16.0),(-22.0,-8.0,-3.0),(-41.0,-5.0,-14.0),(-42.0,0.0,-3.0),(-24.0,4.0,-7.0),(-29.0,14.0,-29.0),(-11.0,3.0,14.0),(-16.0,11.0,2.0),(-14.0,2.0,-11.0),(-20.0,19.0,36.0),(-22.0,-4.0,-17.0),(-25.0,22.0,22.0),(-32.0,30.0,9.0),(15.0,11.0,14.0),(-31.0,30.0,5.0),(-12.0,20.0,5.0),(-51.0,49.0,4.0),(-15.0,12.0,-2.0),(-4.0,27.0,18.0),(6.0,3.0,25.0),(-19.0,46.0,-16.0),(-5.0,10.0,-20.0),(4.0,52.0,2.0),(3.0,2.0,25.0),(3.0,1.0,16.0),(11.0,37.0,-4.0),(4.0,-4.0,7.0),(10.0,4.0,1.0),(6.0,29.0,-4.0),(4.0,12.0,0.0),(1.0,29.0,2.0),(0.0,11.0,0.0),(13.0,14.0,-2.0),(12.0,9.0,1.0),(-1.0,-8.0,17.0),(7.0,-8.0,16.0),(23.0,29.0,-4.0),(0.0,13.0,-16.0),(6.0,10.0,-16.0),(26.0,21.0,-6.0),(31.0,22.0,-1.0),(23.0,12.0,-1.0),(9.0,-4.0,13.0),(10.0,-11.0,16.0),(43.0,-2.0,-2.0),(34.0,-8.0,19.0),(9.0,-1.0,16.0),(31.0,15.0,-19.0),(35.0,8.0,18.0),(20.0,13.0,-11.0),(15.0,4.0,-8.0),(19.0,-10.0,12.0),(28.0,-17.0,13.0),(21.0,-17.0,16.0),(-6.0,-7.0,17.0),(-7.0,-11.0,15.0),(20.0,-22.0,15.0),(17.0,8.0,-15.0),(9.0,5.0,-15.0),(13.0,-8.0,4.0),(11.0,-11.0,8.0),(0.0,-11.0,0.0),(7.0,-28.0,0.0),(7.0,-11.0,2.0),(4.0,-25.0,11.0),(-13.0,-3.0,8.0),(-15.0,-6.0,22.0),(21.0,-30.0,11.0),(14.0,-2.0,-20.0),(10.0,1.0,-8.0),(6.0,4.0,1.0),(11.0,-17.0,3.0),(15.0,-8.0,-15.0),(-2.0,-18.0,-4.0),(0.0,-16.0,0.0),(-17.0,-46.0,14.0),(1.0,-17.0,-4.0),(18.0,-4.0,-26.0),(-7.0,-9.0,-3.0),(-13.0,-30.0,-16.0),(-29.0,-51.0,-21.0),(-22.0,-38.0,-21.0),(-26.0,-40.0,-18.0),(11.0,-8.0,-16.0),(-30.0,-33.0,-22.0),(-11.0,-21.0,-10.0),(-12.0,-14.0,-9.0),(-24.0,-21.0,-17.0),(-34.0,-14.0,3.0),(-39.0,-10.0,-14.0),(-42.0,4.0,-3.0),(-32.0,8.0,-17.0),(-33.0,17.0,6.0),(-16.0,12.0,3.0),(-17.0,18.0,4.0),(-40.0,26.0,7.0),(2.0,9.0,19.0),(-38.0,34.0,3.0),(-33.0,32.0,8.0),(-43.0,45.0,4.0),(-22.0,28.0,6.0),(-8.0,7.0,0.0),(7.0,4.0,27.0),(-4.0,17.0,2.0),(-19.0,47.0,-17.0),(-2.0,15.0,1.0),(-6.0,18.0,2.0),(6.0,7.0,17.0),(8.0,18.0,3.0),(6.0,-4.0,2.0),(5.0,-1.0,9.0),(5.0,4.0,17.0),(16.0,33.0,0.0),(-5.0,7.0,-19.0),(10.0,19.0,2.0),(1.0,17.0,-2.0),(2.0,30.0,1.0),(3.0,13.0,3.0),(11.0,-5.0,19.0),(14.0,12.0,2.0),(20.0,29.0,-4.0),(10.0,18.0,-8.0),(5.0,15.0,-15.0),(17.0,14.0,-5.0),(29.0,19.0,-3.0),(5.0,-8.0,15.0),(11.0,-2.0,9.0),(33.0,3.0,1.0),(24.0,-1.0,11.0),(5.0,14.0,6.0),(3.0,33.0,4.0),(45.0,30.0,5.0),(-1.0,13.0,13.0),(45.0,-41.0,2.0),(2.0,-32.0,-4.0),(6.0,-13.0,-3.0),(-2.0,9.0,-8.0),(31.0,0.0,12.0),(15.0,4.0,-3.0),(13.0,9.0,-11.0),(24.0,-16.0,16.0),(12.0,-10.0,11.0),(-5.0,-12.0,16.0),(7.0,-16.0,12.0),(19.0,-24.0,16.0),(16.0,-8.0,3.0),(21.0,5.0,-15.0),(6.0,-14.0,-1.0),(8.0,-28.0,1.0),(0.0,-16.0,5.0),(-16.0,-11.0,22.0),(4.0,-15.0,13.0),(22.0,-25.0,9.0),(16.0,-15.0,0.0),(13.0,-9.0,-17.0),(17.0,-1.0,-16.0),(-3.0,-18.0,-1.0),(-17.0,-19.0,16.0),(-20.0,-20.0,19.0),(-2.0,-23.0,0.0),(19.0,7.0,-25.0),(17.0,9.0,-20.0),(1.0,-16.0,0.0),(0.0,-16.0,-4.0),(-7.0,-8.0,-4.0),(-14.0,-26.0,-5.0),(-6.0,-26.0,-12.0),(-16.0,-41.0,-16.0),(-14.0,-33.0,-16.0),(-12.0,-8.0,16.0),(-22.0,-22.0,24.0),(7.0,-16.0,-68.0),(-14.0,-21.0,-6.0),(-14.0,-23.0,-4.0),(-19.0,-25.0,-8.0),(-24.0,-23.0,-14.0),(-26.0,-15.0,-9.0),(-41.0,-10.0,9.0),(-37.0,3.0,-27.0),(-28.0,10.0,-1.0),(-32.0,18.0,1.0),(-25.0,20.0,-1.0),(-20.0,21.0,-3.0),(-18.0,18.0,-1.0),(-18.0,12.0,58.0),(-17.0,19.0,-29.0),(-7.0,7.0,-18.0),(-26.0,30.0,8.0),(-27.0,37.0,4.0),(-14.0,24.0,5.0),(-19.0,24.0,-1.0),(-9.0,6.0,0.0),(-4.0,18.0,3.0),(-1.0,14.0,1.0),(9.0,-10.0,21.0),(8.0,-5.0,23.0),(-7.0,22.0,-3.0),(-14.0,20.0,-20.0),(-13.0,19.0,-17.0),(-5.0,17.0,0.0),(10.0,1.0,17.0),(3.0,8.0,15.0),(11.0,18.0,8.0),(18.0,28.0,1.0),(6.0,17.0,-6.0),(6.0,0.0,0.0),(2.0,17.0,-4.0),(1.0,30.0,0.0),(3.0,15.0,3.0),(16.0,15.0,2.0),(24.0,35.0,-5.0),(13.0,22.0,-8.0),(16.0,13.0,-3.0),(27.0,1.0,10.0),(39.0,13.0,5.0),(-1.0,10.0,7.0),(4.0,24.0,6.0),(8.0,19.0,3.0),(28.0,18.0,0.0),(-1.0,5.0,5.0),(0.0,14.0,7.0),(0.0,23.0,8.0),(43.0,24.0,2.0),(35.0,-22.0,16.0),(4.0,-24.0,-7.0),(3.0,-14.0,-6.0),(3.0,-5.0,-4.0),(23.0,-15.0,11.0),(9.0,-19.0,0.0),(4.0,-22.0,-4.0),(2.0,-10.0,-6.0),(37.0,-8.0,12.0),(0.0,9.0,-9.0),(13.0,-10.0,11.0),(7.0,-17.0,13.0),(23.0,-29.0,18.0),(19.0,-12.0,4.0),(6.0,-14.0,0.0),(8.0,-30.0,4.0),(1.0,-16.0,7.0),(4.0,-16.0,13.0),(22.0,-24.0,11.0),(15.0,-15.0,0.0),(-2.0,-12.0,0.0),(18.0,-7.0,-15.0),(0.0,-12.0,1.0),(-21.0,-27.0,20.0),(-9.0,-17.0,6.0),(-1.0,-16.0,0.0),(4.0,-8.0,-7.0),(18.0,-2.0,-26.0),(-3.0,-13.0,-8.0),(-12.0,-26.0,-4.0),(-11.0,-31.0,-7.0),(-9.0,-35.0,-8.0),(-14.0,-29.0,4.0),(-22.0,-23.0,19.0),(-18.0,-24.0,13.0),(5.0,-11.0,-45.0),(-22.0,-29.0,11.0),(-23.0,-28.0,0.0),(-24.0,-26.0,-8.0),(-24.0,-17.0,-7.0),(-32.0,-8.0,-27.0),(-40.0,1.0,7.0),(-28.0,11.0,-6.0),(-30.0,21.0,-6.0),(-25.0,22.0,-13.0),(-23.0,25.0,-17.0),(-14.0,10.0,34.0),(-16.0,20.0,-19.0),(-17.0,21.0,-24.0),(-18.0,26.0,-9.0),(-19.0,32.0,2.0),(-18.0,29.0,0.0),(-17.0,23.0,-1.0),(-7.0,13.0,3.0),(5.0,1.0,25.0),(0.0,10.0,5.0),(-5.0,15.0,-2.0),(-8.0,15.0,-8.0),(-16.0,27.0,-20.0),(-1.0,11.0,-1.0),(8.0,9.0,17.0),(-5.0,11.0,-2.0),(12.0,18.0,7.0),(18.0,27.0,1.0),(13.0,14.0,14.0),(11.0,28.0,-2.0),(4.0,31.0,-4.0),(16.0,33.0,-3.0),(29.0,36.0,-5.0),(35.0,28.0,-2.0),(3.0,13.0,12.0),(9.0,14.0,6.0),(37.0,40.0,-2.0),(-7.0,9.0,7.0),(0.0,29.0,10.0),(7.0,19.0,5.0),(31.0,13.0,-1.0),(0.0,6.0,4.0),(38.0,15.0,2.0),(32.0,-14.0,15.0),(3.0,-6.0,-3.0),(25.0,-11.0,14.0),(9.0,-19.0,-1.0),(1.0,-29.0,-11.0),(-2.0,-9.0,-8.0),(31.0,-36.0,18.0),(9.0,-13.0,-3.0),(10.0,-12.0,-8.0),(29.0,-24.0,18.0),(25.0,-33.0,21.0),(14.0,-31.0,16.0),(3.0,-29.0,8.0),(10.0,-26.0,11.0),(18.0,-23.0,14.0),(-31.0,11.0,51.0),(42.0,-38.0,-51.0),(-5.0,-34.0,0.0),(9.0,5.0,-24.0),(0.0,-12.0,1.0),(-9.0,-17.0,7.0),(-1.0,-16.0,0.0),(4.0,-8.0,-7.0),(-3.0,-13.0,-4.0),(-11.0,-23.0,0.0),(-8.0,-31.0,-3.0),(-9.0,-35.0,-2.0),(-12.0,-30.0,1.0),(-17.0,-25.0,6.0),(-17.0,-22.0,5.0),(-20.0,-34.0,0.0),(-29.0,-32.0,4.0),(-27.0,-27.0,-7.0),(-23.0,-16.0,-11.0),(-33.0,-13.0,-12.0),(-36.0,8.0,-13.0),(-26.0,10.0,-6.0),(-29.0,21.0,-8.0),(-26.0,25.0,-18.0),(-25.0,29.0,-9.0),(-16.0,19.0,-12.0),(-17.0,21.0,-12.0),(-17.0,27.0,-6.0),(-16.0,34.0,-2.0),(-16.0,28.0,-2.0),(-13.0,22.0,-5.0),(-6.0,11.0,1.0),(0.0,9.0,5.0),(-6.0,15.0,-2.0),(-8.0,16.0,-8.0),(-1.0,12.0,-1.0),(8.0,15.0,14.0),(-7.0,34.0,-3.0),(7.0,29.0,5.0),(-5.0,15.0,45.0),(22.0,24.0,-7.0),(13.0,28.0,-11.0),(5.0,28.0,-14.0),(17.0,31.0,-7.0),(30.0,36.0,-3.0),(-2.0,24.0,11.0),(37.0,37.0,-4.0),(-7.0,36.0,9.0),(5.0,25.0,7.0),(50.0,28.0,0.0),(-12.0,20.0,6.0),(37.0,21.0,0.0),(-6.0,50.0,11.0),(47.0,46.0,10.0),(39.0,-45.0,11.0),(-4.0,-51.0,-13.0),(33.0,-19.0,18.0),(-9.0,-19.0,-12.0),(44.0,-25.0,23.0),(6.0,-24.0,-4.0),(-1.0,-37.0,-12.0),(29.0,-33.0,23.0),(3.0,-22.0,-15.0),(27.0,-33.0,26.0),(11.0,-31.0,22.0),(-4.0,-26.0,20.0),(2.0,-24.0,20.0),(-17.0,17.0,42.0),(8.0,-23.0,20.0),(26.0,-41.0,-32.0),(-7.0,-19.0,11.0),(30.0,-43.0,-60.0),(-4.0,-21.0,6.0),(-1.0,-22.0,-9.0),(-10.0,-24.0,1.0),(-15.0,-16.0,19.0),(-14.0,-37.0,10.0),(-12.0,-26.0,3.0),(-13.0,-21.0,0.0),(-19.0,-28.0,1.0),(-25.0,-42.0,-1.0),(-25.0,-35.0,-5.0),(-25.0,-28.0,-9.0),(-24.0,-17.0,-8.0),(-38.0,-4.0,1.0),(-29.0,-1.0,-27.0),(-26.0,12.0,-10.0),(-29.0,23.0,-12.0),(-28.0,30.0,-12.0),(-27.0,39.0,-13.0),(-17.0,25.0,-11.0),(-14.0,20.0,-8.0),(-12.0,27.0,-8.0),(-12.0,35.0,-13.0),(-4.0,17.0,-19.0),(-11.0,22.0,-6.0),(-8.0,24.0,5.0),(-3.0,20.0,-6.0),(-16.0,46.0,50.0),(-1.0,21.0,-10.0),(-8.0,45.0,34.0),(23.0,25.0,-11.0),(14.0,28.0,-13.0),(4.0,29.0,-16.0),(23.0,31.0,-17.0),(-23.0,39.0,28.0),(48.0,39.0,-27.0),(-4.0,40.0,12.0),(40.0,34.0,-8.0),(-12.0,38.0,16.0),(55.0,39.0,-6.0),(1.0,31.0,6.0),(35.0,23.0,3.0),(1.0,3.0,4.0),(45.0,20.0,9.0),(-43.0,41.0,12.0),(87.0,-61.0,1.0),(2.0,-3.0,-3.0),(26.0,-22.0,11.0),(7.0,-30.0,-2.0),(34.0,-39.0,28.0),(2.0,-35.0,-18.0),(25.0,-34.0,29.0),(5.0,-37.0,-11.0),(16.0,-38.0,52.0),(5.0,-35.0,-36.0),(5.0,-30.0,33.0),(-9.0,-28.0,20.0),(-28.0,29.0,66.0),(22.0,-56.0,44.0),(12.0,-51.0,-44.0),(-10.0,-33.0,23.0),(22.0,-27.0,-47.0),(-6.0,-25.0,7.0),(-14.0,-22.0,12.0),(-22.0,-39.0,17.0),(-15.0,-34.0,4.0),(-20.0,-26.0,5.0),(-33.0,-57.0,1.0),(-29.0,-45.0,-4.0),(-29.0,-29.0,-10.0),(-23.0,-19.0,-9.0),(-22.0,-16.0,-31.0),(-42.0,10.0,6.0),(-28.0,14.0,-12.0),(-32.0,23.0,-14.0),(-32.0,40.0,-21.0),(-32.0,54.0,-27.0),(-14.0,25.0,-16.0),(-13.0,31.0,-11.0),(-9.0,42.0,-22.0),(-5.0,21.0,-14.0),(-4.0,26.0,-7.0),(-26.0,31.0,43.0),(6.0,35.0,-19.0),(-41.0,47.0,25.0),(41.0,59.0,-24.0),(2.0,46.0,-19.0),(24.0,74.0,-17.0),(22.0,49.0,-7.0),(83.0,86.0,1.0),(53.0,46.0,-3.0),(-5.0,8.0,6.0),(35.0,25.0,1.0),(-45.0,18.0,1.0),(0.0,15.0,10.0),(-7.0,29.0,16.0),(5.0,61.0,35.0),(46.0,-65.0,-36.0),(45.0,4.0,30.0),(-6.0,59.0,26.0),(9.0,-87.0,-41.0),(6.0,-12.0,-6.0),(40.0,-22.0,-11.0),(24.0,-25.0,10.0),(2.0,-7.0,-5.0),(37.0,-46.0,27.0),(5.0,-71.0,58.0),(16.0,-47.0,23.0),(13.0,-70.0,29.0),(14.0,21.0,120.0),(6.0,2.0,13.0),(-19.0,-95.0,15.0),(-9.0,-51.0,13.0),(6.0,-44.0,-65.0),(0.0,-57.0,-32.0),(-22.0,-45.0,20.0),(-30.0,-54.0,14.0),(-37.0,-63.0,5.0),(-36.0,-47.0,-3.0),(-30.0,-29.0,-10.0),(-26.0,-19.0,-11.0),(-20.0,-22.0,-34.0),(-44.0,18.0,8.0),(-29.0,14.0,-11.0),(-34.0,23.0,-16.0),(-34.0,41.0,-25.0),(-38.0,60.0,-32.0),(-23.0,54.0,-30.0),(-6.0,44.0,-25.0),(-40.0,61.0,24.0),(-41.0,59.0,65.0),(0.0,53.0,-16.0),(4.0,93.0,-27.0),(-12.0,5.0,8.0),(19.0,89.0,-36.0),(73.0,200.0,-24.0),(102.0,-115.0,-82.0),(23.0,46.0,8.0),(7.0,87.0,33.0),(17.0,65.0,34.0),(16.0,25.0,16.0),(51.0,12.0,0.0),(46.0,-17.0,19.0),(15.0,-25.0,-6.0),(15.0,-61.0,-18.0),(21.0,-80.0,-12.0),(27.0,-41.0,13.0),(57.0,100.0,110.0),(37.0,-194.0,70.0),(45.0,458.0,73.0),(-46.0,8.0,-20.0),(137.0,18.0,104.0),(-81.0,34.0,-41.0),(276.0,1108.0,-85.0),(4.0,3.0,-7.0),(21.0,-1.0,2.0),(35.0,-6.0,-45.0),(9.0,-4.0,-41.0),(-3.0,0.0,-5.0),(-27.0,2.0,0.0),(-34.0,4.0,29.0),(-15.0,3.0,34.0),(-7.0,-3.0,4.0),(-16.0,2.0,1.0),(-1.0,2.0,-10.0),(30.0,-5.0,-36.0),(1.0,-4.0,-46.0),(-26.0,0.0,-30.0),(-12.0,0.0,-3.0),(-29.0,3.0,13.0),(-21.0,5.0,43.0),(6.0,2.0,40.0),(-6.0,-2.0,7.0),(-33.0,2.0,4.0),(-2.0,3.0,-9.0),(20.0,-5.0,-44.0),(-14.0,-2.0,-46.0),(-30.0,0.0,-15.0),(-8.0,1.0,3.0),(-12.0,2.0,20.0),(-18.0,5.0,47.0),(21.0,1.0,32.0),(-3.0,-2.0,8.0),(-17.0,8.0,48.0),(-14.0,-2.0,-30.0),(18.0,-1.0,33.0),(12.0,3.0,2.0),(11.0,-5.0,-43.0),(41.0,-2.0,2.0),(28.0,-2.0,-2.0),(51.0,0.0,19.0),(27.0,0.0,25.0),(-6.0,3.0,31.0),(11.0,-4.0,1.0),(7.0,3.0,-1.0),(28.0,-4.0,-28.0),(51.0,-4.0,-10.0),(-54.0,-1.0,6.0),(40.0,-7.0,-52.0),(10.0,-4.0,-47.0),(-4.0,0.0,-6.0),(-30.0,2.0,0.0),(-38.0,4.0,32.0),(1.0,-5.0,-52.0),(-29.0,0.0,-35.0),(-15.0,0.0,-3.0),(-32.0,3.0,15.0),(-27.0,5.0,49.0),(-16.0,-2.0,-53.0),(-34.0,0.0,-17.0),(-10.0,1.0,2.0),(-13.0,3.0,23.0),(-22.0,6.0,55.0),(-6.0,4.0,50.0),(-20.0,-1.0,-29.0),(1.0,5.0,6.0),(-10.0,0.0,0.0),(-3.0,2.0,14.0),(5.0,4.0,54.0),(26.0,2.0,48.0),(19.0,-2.0,-18.0),(3.0,-3.0,7.0),(12.0,3.0,-2.0),(0.0,1.0,24.0),(60.0,-1.0,32.0),(56.0,-2.0,9.0),(27.0,-5.0,-35.0),(10.0,-3.0,7.0),(8.0,3.0,-6.0),(20.0,1.0,31.0),(64.0,-10.0,-67.0),(13.0,-3.0,-27.0),(-2.0,0.0,-10.0),(5.0,-5.0,-4.0),(-10.0,0.0,-7.0),(1.0,-10.0,-9.0),(-35.0,2.0,6.0),(25.0,-4.0,-31.0),(10.0,-5.0,-54.0),(-9.0,0.0,-13.0),(-39.0,2.0,-2.0),(-23.0,2.0,19.0),(0.0,-3.0,-32.0),(-34.0,-1.0,-41.0),(-22.0,1.0,-4.0),(-39.0,4.0,17.0),(-16.0,2.0,30.0),(-10.0,-1.0,-32.0),(-41.0,1.0,-22.0),(-19.0,1.0,5.0),(-15.0,3.0,27.0),(-23.0,7.0,58.0),(-1.0,2.0,30.0),(-20.0,-1.0,-26.0),(-5.0,1.0,-1.0),(-6.0,1.0,9.0),(5.0,10.0,9.0),(-4.0,1.0,17.0),(6.0,6.0,61.0),(30.0,2.0,57.0),(22.0,-1.0,5.0),(68.0,-1.0,37.0),(65.0,-2.0,11.0),(54.0,-4.0,-4.0),(73.0,-11.0,-78.0),(16.0,-4.0,-29.0),(10.0,-10.0,1.0),(-4.0,-1.0,-20.0),(8.0,-7.0,-6.0),(-26.0,0.0,-15.0),(-10.0,0.0,1.0),(8.0,-1.0,-10.0),(12.0,-7.0,-61.0),(-15.0,0.0,-20.0),(-48.0,3.0,-4.0),(-9.0,0.0,7.0),(0.0,-1.0,-12.0),(-39.0,-1.0,-47.0),(-28.0,1.0,-6.0),(-46.0,5.0,20.0),(-6.0,0.0,11.0),(-3.0,0.0,-12.0),(-49.0,1.0,-25.0),(-27.0,2.0,7.0),(-18.0,4.0,31.0),(-24.0,6.0,60.0),(0.0,1.0,13.0),(-6.0,0.0,-11.0),(-9.0,0.0,-3.0),(-16.0,2.0,7.0),(-11.0,3.0,32.0),(11.0,7.0,1.0),(6.0,5.0,66.0),(34.0,3.0,63.0),(25.0,-1.0,6.0),(68.0,-1.0,37.0),(68.0,-3.0,12.0),(59.0,-4.0,-5.0),(77.0,-11.0,-81.0),(9.0,-7.0,6.0),(21.0,-5.0,-39.0),(11.0,-74.0,23.0),(-8.0,-9.0,-25.0),(-34.0,5.0,-27.0),(-10.0,1.0,1.0),(7.0,-5.0,-10.0),(11.0,-15.0,-75.0),(-16.0,-6.0,-24.0),(-51.0,5.0,-14.0),(-10.0,3.0,6.0),(0.0,-4.0,-13.0),(-36.0,-5.0,-36.0),(-29.0,3.0,-7.0),(-55.0,14.0,15.0),(-6.0,5.0,10.0),(-5.0,-3.0,-12.0),(-39.0,9.0,-28.0),(-24.0,9.0,6.0),(-27.0,21.0,54.0),(-14.0,24.0,68.0),(0.0,5.0,13.0),(-6.0,2.0,-15.0),(-9.0,9.0,-11.0),(-18.0,1.0,4.0),(-19.0,6.0,29.0),(12.0,11.0,85.0),(3.0,11.0,-12.0),(37.0,3.0,69.0),(28.0,-1.0,7.0),(3.0,-22.0,27.0),(66.0,21.0,10.0),(71.0,-3.0,12.0),(65.0,-4.0,-5.0),(59.0,-31.0,-37.0),(36.0,-32.0,-33.0),(-33.0,-51.0,52.0),(8.0,-34.0,-37.0),(-12.0,-12.0,-25.0),(-19.0,0.0,-13.0),(-9.0,3.0,0.0),(3.0,-7.0,-8.0),(-9.0,-26.0,-40.0),(-25.0,-6.0,-15.0),(-33.0,14.0,-11.0),(-7.0,8.0,2.0),(-2.0,-9.0,-8.0),(-32.0,-16.0,-27.0),(-30.0,6.0,-6.0),(-33.0,30.0,0.0),(-4.0,9.0,5.0),(-5.0,-8.0,-7.0),(-39.0,-12.0,-9.0),(-26.0,9.0,3.0),(-17.0,32.0,16.0),(-13.0,36.0,23.0),(-12.0,1.0,-11.0),(-17.0,7.0,0.0),(-20.0,17.0,30.0),(17.0,37.0,77.0),(40.0,19.0,51.0),(-3.0,-37.0,25.0),(32.0,3.0,8.0),(61.0,28.0,14.0),(-9.0,-60.0,77.0),(69.0,78.0,-59.0),(55.0,-4.0,4.0),(66.0,-62.0,-20.0),(8.0,-53.0,-8.0),(-7.0,-54.0,-21.0),(-25.0,-29.0,-43.0),(-26.0,-8.0,-23.0),(-15.0,-1.0,-9.0),(-28.0,2.0,-12.0),(-39.0,6.0,-9.0),(-17.0,6.0,-2.0),(-36.0,14.0,0.0),(-37.0,5.0,0.0),(-33.0,17.0,1.0),(-24.0,25.0,14.0),(-21.0,4.0,3.0),(-19.0,17.0,7.0),(7.0,33.0,35.0),(29.0,-54.0,79.0),(39.0,25.0,26.0),(-4.0,-17.0,17.0),(51.0,27.0,45.0),(43.0,9.0,15.0),(4.0,25.0,-21.0),(35.0,-3.0,6.0),(76.0,-60.0,-13.0),(4.0,-65.0,-56.0),(-12.0,-33.0,-49.0),(-43.0,-7.0,-33.0),(-83.0,25.0,-3.0),(-82.0,16.0,10.0),(-21.0,15.0,17.0),(-14.0,16.0,20.0),(-1.0,-22.0,17.0),(22.0,31.0,28.0),(-2.0,-32.0,15.0),(19.0,36.0,22.0),(50.0,23.0,50.0),(46.0,5.0,13.0),(32.0,-13.0,-3.0),(4.0,34.0,-18.0),(61.0,-48.0,-7.0),(15.0,-19.0,-13.0),(1.0,-49.0,-57.0),(-13.0,-24.0,-52.0),(-36.0,-6.0,-34.0),(-79.0,19.0,-7.0),(-83.0,16.0,16.0),(-23.0,11.0,20.0),(0.0,-24.0,12.0),(-14.0,13.0,33.0),(15.0,14.0,41.0),(15.0,16.0,40.0),(50.0,24.0,65.0),(32.0,2.0,13.0),(48.0,0.0,-17.0),(43.0,-26.0,-23.0),(39.0,-28.0,-37.0),(0.0,-32.0,-59.0),(-13.0,-16.0,-53.0),(-30.0,-5.0,-37.0),(-75.0,13.0,-11.0),(-83.0,15.0,22.0),(0.0,-20.0,5.0),(-29.0,11.0,26.0),(-14.0,12.0,33.0),(13.0,16.0,41.0),(13.0,16.0,42.0),(50.0,25.0,66.0),(36.0,1.0,13.0),(50.0,-1.0,-18.0),(38.0,-25.0,-23.0),(40.0,-30.0,-37.0),(0.0,-31.0,-61.0),(-15.0,-16.0,-53.0),(-27.0,-6.0,-38.0),(-76.0,12.0,-14.0),(-8.0,-34.0,3.0),(-77.0,9.0,26.0),(-28.0,7.0,32.0),(-17.0,7.0,38.0),(12.0,15.0,44.0),(13.0,15.0,44.0),(49.0,24.0,59.0),(26.0,0.0,7.0),(29.0,0.0,0.0),(40.0,-1.0,-10.0),(44.0,-27.0,-32.0),(30.0,-28.0,-46.0),(0.0,-15.0,-55.0),(-18.0,-10.0,-47.0),(-26.0,-6.0,-38.0),(-8.0,-35.0,6.0),(-75.0,6.0,-26.0),(-76.0,7.0,29.0),(-27.0,7.0,36.0),(-18.0,7.0,41.0),(12.0,16.0,45.0),(12.0,15.0,44.0),(51.0,22.0,59.0),(26.0,0.0,4.0),(28.0,0.0,-1.0),(41.0,-1.0,-10.0),(38.0,-24.0,-28.0),(32.0,-31.0,-46.0),(0.0,-13.0,-64.0),(-19.0,-7.0,-42.0),(-17.0,-77.0,7.0),(-20.0,0.0,-41.0),(-67.0,10.0,-32.0),(-76.0,1.0,35.0),(-27.0,3.0,44.0),(-19.0,2.0,48.0),(9.0,12.0,45.0),(9.0,12.0,45.0),(42.0,29.0,52.0),(34.0,2.0,6.0),(30.0,-5.0,-1.0),(30.0,-12.0,-10.0),(40.0,-20.0,-22.0),(18.0,-18.0,-63.0),(16.0,-6.0,-19.0),(-6.0,-9.0,-43.0),(-3.0,-108.0,0.0),(-18.0,-5.0,-43.0),(-25.0,-5.0,-41.0),(-69.0,-9.0,-31.0),(-90.0,6.0,36.0),(-31.0,7.0,47.0),(-21.0,14.0,51.0),(12.0,18.0,57.0),(14.0,26.0,56.0),(44.0,23.0,63.0),(34.0,-4.0,7.0),(30.0,-6.0,-4.0),(42.0,-14.0,-22.0),(36.0,-29.0,-26.0),(17.0,-10.0,-65.0),(19.0,-4.0,-25.0),(-5.0,-171.0,26.0),(1.0,-17.0,-73.0),(-17.0,-170.0,-4.0),(-26.0,166.0,-81.0),(-80.0,18.0,-38.0),(-99.0,17.0,40.0),(-27.0,10.0,36.0),(-32.0,13.0,59.0),(-7.0,15.0,74.0),(24.0,16.0,91.0),(37.0,7.0,68.0),(57.0,-3.0,14.0),(28.0,-5.0,-4.0),(61.0,-24.0,-38.0),(39.0,-8.0,-36.0),(16.0,-24.0,-75.0),(-19.0,-167.0,13.0),(23.0,-21.0,-63.0),(-13.0,-63.0,-10.0),(3.0,-5.0,-45.0),(-48.0,16.0,-74.0),(-27.0,-87.0,3.0),(43.0,144.0,-10.0),(-93.0,31.0,-27.0),(-109.0,15.0,31.0),(-3.0,1.0,5.0),(-58.0,29.0,76.0),(-4.0,17.0,89.0),(39.0,9.0,122.0),(48.0,5.0,61.0),(54.0,-7.0,24.0),(27.0,-8.0,-2.0),(60.0,-28.0,-40.0),(41.0,-21.0,-44.0),(-9.0,-68.0,6.0),(11.0,-26.0,-100.0),(-20.0,-114.0,-16.0),(20.0,9.0,-94.0),(-64.0,-42.0,-95.0),(-12.0,-34.0,-17.0),(-36.0,-188.0,-132.0),(-41.0,-331.0,-1.0),(-41.0,-90.0,16.0),(-40.0,-89.0,17.0),(-29.0,-152.0,60.0),(-15.0,-11.0,-32.0),(-6.0,-34.0,-62.0),(-90.0,-132.0,11.0),(-70.0,-49.0,-13.0),(-43.0,-18.0,-24.0),(-51.0,12.0,-15.0),(-71.0,40.0,-40.0),(-83.0,128.0,-64.0),(-54.0,47.0,55.0),(-32.0,16.0,21.0),(9.0,152.0,-67.0),(-22.0,92.0,-36.0),(-22.0,92.0,-35.0),(-3.0,316.0,-6.0),(28.0,224.0,61.0),(127.0,1198.0,528.0),(33.0,8.0,-17.0),(3.0,25.0,-45.0),(-2.0,11.0,-20.0),(-7.0,3.0,-4.0),(-33.0,0.0,2.0),(-33.0,-16.0,31.0),(0.0,-23.0,41.0),(-34.0,4.0,-12.0),(-2.0,8.0,-5.0),(23.0,15.0,-29.0),(-1.0,24.0,-43.0),(-20.0,13.0,-20.0),(-13.0,1.0,-2.0),(-36.0,-7.0,15.0),(-17.0,-20.0,37.0),(10.0,-23.0,40.0),(-6.0,-6.0,4.0),(-14.0,4.0,-8.0),(-3.0,7.0,-2.0),(0.0,19.0,-34.0),(-18.0,21.0,-35.0),(-24.0,5.0,-8.0),(-5.0,-1.0,3.0),(-9.0,-20.0,36.0),(12.0,-29.0,49.0),(20.0,-4.0,5.0),(1.0,-7.0,5.0),(130.0,-12.0,9.0),(44.0,-9.0,13.0),(20.0,-13.0,22.0),(31.0,7.0,-16.0),(-13.0,16.0,-27.0),(3.0,29.0,-51.0),(-2.0,13.0,-23.0),(-8.0,3.0,-5.0),(-38.0,0.0,2.0),(-38.0,-17.0,35.0),(-1.0,28.0,-49.0),(-23.0,14.0,-24.0),(-15.0,1.0,-1.0),(-41.0,-7.0,17.0),(-22.0,-22.0,41.0),(-20.0,24.0,-41.0),(-28.0,6.0,-9.0),(-6.0,-1.0,3.0),(-10.0,-23.0,42.0),(13.0,-32.0,56.0),(-4.0,3.0,3.0),(-41.0,16.0,-26.0),(54.0,-36.0,60.0),(6.0,-5.0,1.0),(11.0,2.0,4.0),(7.0,15.0,-28.0),(36.0,2.0,-8.0),(54.0,-4.0,3.0),(24.0,-9.0,14.0),(37.0,-8.0,12.0),(-8.0,-22.0,38.0),(12.0,-4.0,0.0),(4.0,3.0,2.0),(26.0,10.0,-20.0),(28.0,5.0,-13.0),(9.0,-2.0,3.0),(-2.0,-6.0,12.0),(8.0,5.0,-19.0),(8.0,-4.0,-11.0),(-3.0,5.0,-9.0),(-5.0,0.0,0.0),(-29.0,-6.0,13.0),(14.0,14.0,-26.0),(3.0,30.0,-54.0),(-2.0,16.0,-27.0),(-14.0,7.0,-10.0),(-47.0,0.0,3.0),(-23.0,-11.0,21.0),(-1.0,17.0,-31.0),(-28.0,18.0,-28.0),(-21.0,2.0,-2.0),(-49.0,-9.0,19.0),(-13.0,-13.0,26.0),(-13.0,15.0,-26.0),(-36.0,7.0,-10.0),(-14.0,-3.0,6.0),(-12.0,-26.0,47.0),(7.0,-19.0,33.0),(-29.0,12.0,-18.0),(-3.0,2.0,14.0),(-11.0,0.0,2.0),(3.0,0.0,8.0),(-6.0,-4.0,7.0),(1.0,-14.0,26.0),(27.0,-44.0,77.0),(32.0,8.0,-18.0),(4.0,-8.0,6.0),(13.0,4.0,0.0),(8.0,-23.0,39.0),(55.0,-9.0,11.0),(68.0,-1.0,-3.0),(11.0,9.0,-18.0),(8.0,-6.0,3.0),(7.0,5.0,-1.0),(8.0,-12.0,21.0),(46.0,13.0,-29.0),(1.0,-4.0,0.0),(32.0,24.0,-46.0),(10.0,-11.0,-2.0),(10.0,-7.0,-1.0),(2.0,17.0,-30.0),(-11.0,7.0,-11.0),(-10.0,0.0,0.0),(-9.0,-2.0,6.0),(6.0,5.0,-11.0),(4.0,32.0,-56.0),(-3.0,18.0,-32.0),(-21.0,10.0,-15.0),(-55.0,0.0,3.0),(-9.0,-3.0,7.0),(0.0,6.0,-11.0),(-32.0,20.0,-33.0),(-29.0,3.0,-4.0),(-55.0,-10.0,23.0),(-5.0,-4.0,9.0),(-5.0,5.0,-10.0),(-45.0,10.0,-13.0),(-22.0,-5.0,11.0),(-14.0,-30.0,53.0),(1.0,-5.0,10.0),(-9.0,3.0,-5.0),(-29.0,0.0,3.0),(5.0,0.0,13.0),(-12.0,-6.0,13.0),(11.0,5.0,8.0),(1.0,-17.0,30.0),(32.0,-52.0,89.0),(46.0,-15.0,23.0),(63.0,-11.0,13.0),(78.0,-2.0,-2.0),(21.0,-3.0,3.0),(2.0,-13.0,4.0),(58.0,17.0,-36.0),(7.0,-10.0,3.0),(-3.0,-15.0,4.0),(48.0,31.0,-67.0),(-5.0,15.0,-32.0),(-15.0,6.0,-9.0),(-14.0,-11.0,1.0),(-11.0,-6.0,7.0),(6.0,2.0,-13.0),(16.0,19.0,-69.0),(-2.0,19.0,-62.0),(-19.0,1.0,-16.0),(-49.0,-10.0,3.0),(-9.0,0.0,8.0),(-1.0,2.0,-13.0),(-43.0,12.0,-37.0),(-30.0,2.0,-5.0),(-48.0,-3.0,18.0),(-5.0,-1.0,11.0),(-7.0,2.0,-11.0),(-51.0,3.0,-8.0),(-25.0,-1.0,17.0),(-21.0,-30.0,68.0),(1.0,-1.0,12.0),(-9.0,1.0,-5.0),(-43.0,-7.0,6.0),(-17.0,-1.0,22.0),(26.0,67.0,29.0),(1.0,-21.0,39.0),(11.0,5.0,2.0),(33.0,-54.0,93.0),(51.0,-17.0,26.0),(67.0,-12.0,14.0),(76.0,-1.0,-3.0),(0.0,-12.0,6.0),(27.0,-4.0,5.0),(-10.0,-32.0,2.0),(58.0,-2.0,-36.0),(47.0,4.0,-73.0),(-7.0,6.0,-40.0),(-15.0,0.0,-8.0),(-16.0,-3.0,3.0),(-3.0,-14.0,-43.0),(-10.0,-12.0,-36.0),(-23.0,2.0,-15.0),(-38.0,17.0,2.0),(-7.0,3.0,7.0),(-2.0,-4.0,-11.0),(-31.0,-13.0,-28.0),(-30.0,1.0,-8.0),(-40.0,10.0,19.0),(-5.0,2.0,9.0),(-5.0,-3.0,-10.0),(-36.0,-6.0,-9.0),(-28.0,5.0,8.0),(-24.0,3.0,41.0),(0.0,0.0,11.0),(-9.0,0.0,-5.0),(-23.0,0.0,3.0),(-21.0,2.0,22.0),(-7.0,6.0,49.0),(-3.0,77.0,-20.0),(19.0,-2.0,56.0),(39.0,-10.0,65.0),(56.0,-19.0,29.0),(69.0,-12.0,15.0),(61.0,-33.0,1.0),(-7.0,-41.0,-2.0),(32.0,-9.0,2.0),(51.0,-16.0,-38.0),(19.0,-11.0,-43.0),(-15.0,-4.0,-23.0),(-19.0,4.0,-11.0),(-16.0,-7.0,-32.0),(-30.0,-2.0,-22.0),(-33.0,7.0,-16.0),(-33.0,-1.0,-20.0),(-17.0,0.0,-7.0),(-39.0,2.0,-9.0),(-30.0,0.0,-1.0),(-18.0,2.0,3.0),(-33.0,3.0,12.0),(-40.0,9.0,41.0),(-11.0,35.0,44.0),(7.0,37.0,40.0),(53.0,20.0,73.0),(52.0,-11.0,16.0),(58.0,-23.0,-3.0),(-28.0,-92.0,25.0),(63.0,-22.0,-29.0),(46.0,-20.0,-21.0),(11.0,-13.0,-27.0),(-5.0,0.0,-29.0),(-12.0,2.0,-29.0),(-69.0,17.0,-44.0),(-77.0,3.0,-39.0),(-53.0,3.0,15.0),(-31.0,6.0,52.0),(-16.0,23.0,80.0),(66.0,19.0,70.0),(33.0,-5.0,9.0),(-6.0,-33.0,1.0),(45.0,-12.0,-2.0),(64.0,-16.0,-32.0),(23.0,-17.0,-20.0),(-4.0,-35.0,-7.0),(35.0,17.0,-25.0),(-1.0,5.0,-33.0),(-14.0,8.0,-31.0),(-67.0,20.0,-48.0),(-75.0,3.0,-31.0),(-48.0,-1.0,17.0),(-33.0,-1.0,48.0),(-20.0,11.0,72.0),(9.0,4.0,25.0),(53.0,16.0,53.0),(-6.0,-39.0,-5.0),(29.0,0.0,21.0),(47.0,-11.0,1.0),(64.0,-9.0,-33.0),(-7.0,-45.0,10.0),(30.0,3.0,-34.0),(31.0,5.0,-33.0),(1.0,10.0,-37.0),(-15.0,12.0,-32.0),(-64.0,24.0,-54.0),(-73.0,5.0,-24.0),(-43.0,-4.0,21.0),(-35.0,-10.0,44.0),(-24.0,-3.0,62.0),(19.0,-8.0,57.0),(30.0,-4.0,47.0),(36.0,-24.0,27.0),(34.0,-5.0,0.0),(0.0,-21.0,0.0),(73.0,-1.0,-46.0),(29.0,4.0,-35.0),(29.0,4.0,-36.0),(0.0,11.0,-37.0),(-14.0,13.0,-34.0),(-61.0,23.0,-53.0),(-75.0,4.0,-22.0),(-40.0,-5.0,23.0),(-37.0,-9.0,43.0),(-25.0,-5.0,64.0),(20.0,-7.0,58.0),(25.0,-3.0,45.0),(36.0,-24.0,30.0),(-13.0,-44.0,-27.0),(25.0,-9.0,10.0),(27.0,-4.0,2.0),(69.0,-4.0,-41.0),(30.0,6.0,-37.0),(30.0,5.0,-37.0),(0.0,19.0,-38.0),(-10.0,19.0,-38.0),(-58.0,29.0,-51.0),(-78.0,4.0,-14.0),(-41.0,-7.0,23.0),(-37.0,-10.0,34.0),(-23.0,-15.0,49.0),(8.0,-9.0,61.0),(25.0,-8.0,54.0),(-1.0,-40.0,-14.0),(32.0,-16.0,22.0),(25.0,-9.0,10.0),(25.0,-6.0,3.0),(71.0,-3.0,-39.0),(29.0,6.0,-37.0),(30.0,5.0,-38.0),(0.0,21.0,-41.0),(-8.0,20.0,-41.0),(-55.0,33.0,-51.0),(-79.0,3.0,-9.0),(-40.0,-9.0,25.0),(-36.0,-9.0,29.0),(-26.0,-23.0,55.0),(8.0,-7.0,62.0),(3.0,-94.0,-29.0),(26.0,-7.0,42.0),(24.0,-4.0,25.0),(26.0,-6.0,13.0),(34.0,-9.0,4.0),(58.0,-9.0,-41.0),(28.0,10.0,-37.0),(27.0,9.0,-37.0),(3.0,28.0,-44.0),(-5.0,28.0,-43.0),(-51.0,39.0,-53.0),(-76.0,-4.0,-3.0),(-35.0,-14.0,24.0),(-32.0,-16.0,28.0),(-24.0,-13.0,36.0),(6.0,-9.0,22.0),(0.0,-108.0,-40.0),(-12.0,-29.0,59.0),(22.0,-1.0,49.0),(29.0,-12.0,39.0),(25.0,-6.0,16.0),(34.0,-3.0,8.0),(67.0,0.0,-46.0),(36.0,2.0,-52.0),(33.0,10.0,-48.0),(3.0,21.0,-53.0),(-7.0,27.0,-50.0),(-64.0,40.0,-60.0),(-75.0,12.0,5.0),(-40.0,-9.0,25.0),(-36.0,-11.0,29.0),(-21.0,-25.0,49.0),(-14.0,-154.0,-77.0),(16.0,-142.0,-108.0),(13.0,-50.0,-39.0),(-20.0,30.0,106.0),(-4.0,147.0,80.0),(-15.0,-23.0,76.0),(19.0,-24.0,46.0),(38.0,-18.0,62.0),(24.0,-6.0,16.0),(58.0,-6.0,9.0),(63.0,17.0,-42.0),(60.0,24.0,-68.0),(24.0,27.0,-66.0),(-2.0,29.0,-63.0),(-7.0,18.0,-41.0),(-72.0,35.0,-74.0),(-89.0,-10.0,-9.0),(-76.0,-25.0,50.0),(8.0,-142.0,-96.0),(9.0,-58.0,-37.0),(18.0,-104.0,-50.0),(83.0,9.0,-51.0),(-111.0,-43.0,150.0),(-21.0,93.0,76.0),(-31.0,-33.0,94.0),(-2.0,61.0,30.0),(19.0,-18.0,60.0),(37.0,-15.0,67.0),(23.0,-1.0,15.0),(60.0,1.0,3.0),(70.0,11.0,-32.0),(89.0,41.0,-81.0),(32.0,32.0,-78.0),(-18.0,32.0,-93.0),(-1.0,2.0,-5.0),(-82.0,35.0,-73.0),(-94.0,-13.0,-39.0),(9.0,-65.0,-41.0),(36.0,-202.0,-86.0),(12.0,-56.0,-17.0),(108.0,-16.0,-7.0),(12.0,-75.0,-18.0),(50.0,12.0,11.0),(-58.0,-214.0,-38.0),(135.0,-6.0,-23.0),(108.0,18.0,12.0),(96.0,-26.0,36.0),(116.0,18.0,103.0),(-24.0,186.0,25.0),(20.0,1.0,64.0),(0.0,55.0,44.0),(0.0,49.0,39.0),(78.0,-28.0,0.0),(15.0,63.0,23.0),(27.0,90.0,3.0),(-105.0,11.0,19.0),(-64.0,31.0,88.0),(-2.0,17.0,89.0),(38.0,8.0,135.0),(49.0,2.0,67.0),(56.0,-10.0,27.0),(27.0,-7.0,-2.0),(58.0,-26.0,-41.0),(-32.0,-143.0,49.0),(57.0,-9.0,-98.0),(-8.0,-91.0,-16.0),(14.0,19.0,-127.0),(11.0,14.0,-100.0),(-10.0,-34.0,-23.0),(-9.0,-32.0,-25.0),(-2.0,-193.0,-94.0),(-46.0,36.0,-46.0),(-40.0,-308.0,15.0),(-38.0,-91.0,14.0),(-38.0,-91.0,15.0),(-32.0,-138.0,51.0),(-83.0,-111.0,39.0),(-58.0,-44.0,-57.0),(-15.0,-12.0,-42.0),(-85.0,-44.0,-6.0),(-50.0,-19.0,-23.0),(-59.0,16.0,-16.0),(-73.0,40.0,-45.0),(-44.0,18.0,30.0),(-84.0,52.0,17.0),(-43.0,109.0,-83.0),(4.0,138.0,-59.0),(-21.0,94.0,-33.0),(-19.0,95.0,-31.0),(4.0,290.0,-21.0),(-14.0,10.0,56.0),(7.0,217.0,25.0),(-11.0,51.0,16.0),(-13.0,52.0,21.0),(-37.0,-31.0,92.0),(-46.0,-3.0,124.0),(-5.0,43.0,33.0),(16.0,13.0,102.0),(-11.0,64.0,32.0),(36.0,-15.0,66.0),(23.0,-1.0,15.0),(62.0,2.0,3.0),(74.0,17.0,-34.0),(94.0,48.0,-90.0),(34.0,31.0,-77.0),(-18.0,38.0,-107.0),(-81.0,24.0,-78.0),(25.0,-115.0,-68.0),(18.0,-97.0,-50.0),(71.0,25.0,50.0),(8.0,-65.0,-39.0),(4.0,-66.0,-32.0),(-1.0,-70.0,-18.0),(89.0,0.0,-4.0),(102.0,-9.0,-15.0),(95.0,-4.0,59.0),(-18.0,131.0,92.0),(69.0,-33.0,109.0),(17.0,5.0,10.0),(11.0,26.0,18.0),(11.0,24.0,17.0),(12.0,35.0,14.0),(-63.0,20.0,87.0),(-4.0,18.0,97.0),(23.0,-11.0,162.0),(40.0,-38.0,95.0),(63.0,-19.0,27.0),(26.0,-7.0,-2.0),(-21.0,-100.0,18.0),(65.0,-19.0,-70.0),(-6.0,-53.0,-19.0),(68.0,13.0,-110.0),(14.0,25.0,-126.0),(0.0,-41.0,-23.0),(1.0,-187.0,-66.0),(-63.0,-218.0,27.0),(-10.0,-21.0,-135.0),(-49.0,-121.0,15.0),(-25.0,-62.0,8.0),(-34.0,-123.0,40.0),(-53.0,-86.0,59.0),(-56.0,-56.0,-29.0),(-65.0,-48.0,-31.0),(-101.0,-31.0,-46.0),(-60.0,-3.0,-19.0),(-65.0,8.0,-14.0),(-113.0,32.0,-20.0),(-71.0,53.0,-10.0),(-62.0,62.0,-6.0),(-9.0,80.0,-84.0),(-2.0,126.0,-52.0),(-13.0,66.0,-19.0),(-24.0,125.0,-36.0),(-55.0,55.0,121.0),(19.0,222.0,-18.0),(15.0,188.0,24.0),(-1.0,49.0,11.0),(-44.0,1.0,124.0),(11.0,7.0,129.0),(0.0,54.0,6.0),(32.0,17.0,88.0),(4.0,32.0,-13.0),(23.0,-1.0,15.0),(64.0,-8.0,5.0),(74.0,-10.0,-39.0),(91.0,56.0,-100.0),(38.0,34.0,-85.0),(-13.0,24.0,-131.0),(17.0,-51.0,-34.0),(12.0,-34.0,-18.0),(13.0,-36.0,-13.0),(16.0,-7.0,3.0),(81.0,-31.0,-10.0),(80.0,-18.0,-24.0),(-15.0,60.0,113.0),(51.0,2.0,89.0),(57.0,-27.0,95.0),(15.0,3.0,13.0),(6.0,12.0,6.0),(6.0,12.0,5.0),(-8.0,8.0,94.0),(18.0,-48.0,184.0),(38.0,-39.0,99.0),(61.0,-42.0,34.0),(-8.0,-51.0,6.0),(22.0,-10.0,-5.0),(-10.0,-38.0,7.0),(76.0,-28.0,-121.0),(15.0,-36.0,-37.0),(55.0,53.0,-80.0),(-10.0,-168.0,-59.0),(-62.0,-177.0,-6.0),(-73.0,-187.0,50.0),(28.0,-27.0,-112.0),(-51.0,-114.0,26.0),(-76.0,-122.0,5.0),(-44.0,-69.0,-14.0),(-65.0,-47.0,-23.0),(-101.0,-2.0,-43.0),(-67.0,13.0,-34.0),(-79.0,-5.0,0.0),(-118.0,12.0,-19.0),(-68.0,54.0,-18.0),(-39.0,75.0,-10.0),(-52.0,131.0,-48.0),(-17.0,120.0,-46.0),(-18.0,42.0,128.0),(-12.0,194.0,-77.0),(-2.0,191.0,-15.0),(6.0,177.0,21.0),(4.0,-38.0,104.0),(6.0,42.0,33.0),(24.0,48.0,135.0),(3.0,36.0,-17.0),(21.0,5.0,14.0),(5.0,36.0,-17.0),(76.0,9.0,-5.0),(78.0,-14.0,-64.0),(94.0,41.0,-107.0),(36.0,38.0,-84.0),(8.0,-13.0,-15.0),(9.0,-15.0,-14.0),(17.0,-5.0,-11.0),(72.0,-38.0,-32.0),(-28.0,1.0,86.0),(79.0,8.0,16.0),(50.0,-4.0,124.0),(-11.0,10.0,102.0),(43.0,-69.0,119.0),(33.0,20.0,-190.0),(9.0,3.0,6.0),(9.0,10.0,7.0),(6.0,15.0,7.0),(14.0,-83.0,193.0),(38.0,-27.0,104.0),(-14.0,-46.0,1.0),(71.0,-39.0,43.0),(-7.0,-23.0,6.0),(24.0,-4.0,-9.0),(-19.0,-39.0,-8.0),(74.0,-16.0,-106.0),(-30.0,-84.0,-15.0),(63.0,-14.0,-56.0),(-40.0,-152.0,-34.0),(-60.0,-210.0,17.0),(-42.0,-127.0,2.0),(11.0,-6.0,-37.0),(-71.0,-133.0,-6.0),(-44.0,-65.0,-8.0),(-64.0,-48.0,-23.0),(-86.0,3.0,-35.0),(-87.0,21.0,-53.0),(-108.0,-6.0,5.0),(-94.0,11.0,-9.0),(-68.0,58.0,-17.0),(-36.0,74.0,-18.0),(-46.0,142.0,-26.0),(-3.0,7.0,43.0),(-15.0,133.0,-17.0),(-8.0,223.0,-29.0),(-1.0,179.0,-2.0),(34.0,18.0,76.0),(-11.0,89.0,-14.0),(24.0,32.0,125.0),(-9.0,43.0,-9.0),(19.0,3.0,18.0),(2.0,21.0,-14.0),(89.0,17.0,-12.0),(-2.0,34.0,-13.0),(83.0,-5.0,-79.0),(100.0,40.0,-122.0),(8.0,-11.0,-12.0),(10.0,-8.0,-7.0),(8.0,-2.0,-3.0),(-49.0,-16.0,157.0),(80.0,49.0,18.0),(85.0,17.0,-3.0),(-24.0,-9.0,113.0),(78.0,-13.0,36.0),(74.0,-58.0,24.0),(-14.0,-58.0,101.0),(23.0,9.0,-106.0),(31.0,-48.0,10.0),(15.0,4.0,-3.0),(8.0,-59.0,92.0),(4.0,-25.0,30.0),(22.0,1.0,22.0),(4.0,-40.0,3.0),(37.0,-10.0,6.0),(-11.0,-89.0,-39.0),(22.0,0.0,-12.0),(12.0,-140.0,-60.0),(2.0,-25.0,-12.0),(38.0,-5.0,-34.0),(-57.0,-206.0,25.0),(-46.0,-140.0,-6.0),(-48.0,-71.0,-10.0),(7.0,-65.0,-60.0),(-47.0,-63.0,-8.0),(-65.0,-41.0,-23.0),(-83.0,7.0,-38.0),(-85.0,20.0,-48.0),(-103.0,-4.0,2.0),(-92.0,8.0,-6.0),(-66.0,53.0,-14.0),(-37.0,70.0,-15.0),(-4.0,68.0,66.0),(-38.0,77.0,-14.0),(-20.0,146.0,-11.0),(2.0,228.0,-33.0),(21.0,2.0,52.0),(3.0,32.0,5.0),(22.0,162.0,37.0),(13.0,-1.0,21.0),(-2.0,104.0,9.0),(38.0,2.0,9.0),(16.0,38.0,-11.0),(28.0,-9.0,-8.0),(23.0,17.0,-28.0),(59.0,31.0,-87.0),(10.0,-6.0,10.0),(41.0,31.0,-2.0),(-25.0,9.0,107.0),(22.0,11.0,14.0),(82.0,43.0,8.0),(-36.0,-17.0,174.0),(76.0,0.0,5.0),(71.0,-9.0,27.0),(86.0,-27.0,27.0),(43.0,-40.0,14.0),(42.0,-130.0,-90.0),(6.0,-27.0,32.0),(15.0,-35.0,15.0),(13.0,-2.0,-9.0),(12.0,-91.0,-17.0),(5.0,0.0,0.0),(4.0,-93.0,-26.0),(28.0,-43.0,-29.0),(2.0,-32.0,-10.0),(-19.0,-216.0,22.0),(-55.0,-144.0,-13.0),(-24.0,-45.0,-21.0),(-30.0,-94.0,-41.0),(-57.0,-52.0,-27.0),(-98.0,12.0,-41.0),(-92.0,14.0,-41.0),(-102.0,3.0,-8.0),(-106.0,6.0,-9.0),(-53.0,63.0,0.0),(-30.0,99.0,26.0),(-21.0,47.0,9.0),(-31.0,154.0,-9.0),(35.0,237.0,-15.0),(5.0,38.0,5.0),(22.0,48.0,33.0),(18.0,107.0,9.0),(5.0,0.0,2.0),(27.0,97.0,1.0),(9.0,0.0,13.0),(29.0,31.0,-16.0),(26.0,17.0,-29.0),(0.0,61.0,196.0),(49.0,31.0,7.0),(-37.0,25.0,177.0),(63.0,22.0,13.0),(94.0,-11.0,12.0),(95.0,3.0,28.0),(58.0,-30.0,13.0),(55.0,-45.0,0.0),(59.0,-86.0,-12.0),(22.0,-38.0,-140.0),(22.0,-151.0,-10.0),(15.0,-36.0,-56.0),(11.0,-91.0,-35.0),(-3.0,-50.0,-9.0),(4.0,-1.0,-7.0),(-8.0,-240.0,31.0),(-59.0,-131.0,-18.0),(-28.0,-42.0,-10.0),(-40.0,-47.0,-15.0),(-55.0,-46.0,-24.0),(-71.0,-23.0,-44.0),(-91.0,9.0,-49.0),(-102.0,7.0,2.0),(-78.0,37.0,6.0),(-52.0,55.0,-3.0),(-34.0,54.0,-4.0),(-22.0,46.0,-2.0),(-38.0,139.0,-6.0),(49.0,238.0,-17.0),(1.0,0.0,8.0),(10.0,89.0,-5.0),(19.0,103.0,22.0),(-17.0,-23.0,100.0),(45.0,143.0,32.0),(-38.0,34.0,137.0),(66.0,75.0,42.0),(-148.0,-12.0,265.0),(48.0,39.0,17.0),(95.0,20.0,0.0),(107.0,-12.0,23.0),(107.0,3.0,26.0),(77.0,-26.0,41.0),(50.0,-44.0,5.0),(42.0,-92.0,-15.0),(-66.0,-72.0,188.0),(97.0,-100.0,-225.0),(82.0,9.0,-270.0),(3.0,-78.0,8.0),(0.0,-32.0,4.0),(32.0,7.0,-143.0),(5.0,-90.0,0.0),(-9.0,-238.0,-47.0),(-59.0,-125.0,-20.0),(-30.0,-43.0,-11.0),(-40.0,-44.0,-16.0),(-56.0,-44.0,-24.0),(-68.0,-22.0,-43.0),(-84.0,6.0,-44.0),(-95.0,9.0,1.0),(-73.0,34.0,6.0),(-53.0,53.0,-3.0),(-35.0,50.0,-3.0),(-25.0,48.0,-3.0),(-41.0,133.0,-4.0),(11.0,237.0,52.0),(24.0,87.0,11.0),(-40.0,-15.0,140.0),(9.0,32.0,0.0),(20.0,75.0,0.0),(-93.0,-22.0,265.0),(21.0,169.0,49.0),(-54.0,-250.0,339.0),(-6.0,-74.0,-8.0),(-22.0,-1.0,164.0),(-7.0,64.0,4.0),(-48.0,40.0,152.0),(-55.0,21.0,98.0),(-26.0,-50.0,96.0),(-17.0,-4.0,-11.0),(29.0,0.0,-23.0),(22.0,63.0,-59.0),(52.0,-23.0,-103.0),(47.0,-38.0,-148.0),(35.0,163.0,-298.0),(47.0,99.0,21.0),(55.0,45.0,11.0),(89.0,30.0,8.0),(89.0,-10.0,23.0),(91.0,7.0,18.0),(80.0,-32.0,30.0),(49.0,-46.0,9.0),(64.0,-248.0,143.0),(-30.0,-32.0,102.0),(3.0,9.0,79.0),(20.0,24.0,60.0),(5.0,28.0,31.0),(8.0,29.0,32.0),(390.0,1173.0,533.0),(9.0,1.0,-2.0),(13.0,-3.0,15.0),(56.0,-12.0,-11.0),(33.0,-8.0,-25.0),(0.0,0.0,-6.0),(-19.0,4.0,-18.0),(-45.0,10.0,0.0),(-33.0,7.0,16.0),(-8.0,-1.0,-2.0),(-12.0,2.0,-9.0),(6.0,2.0,-9.0),(45.0,-10.0,-8.0),(30.0,-8.0,-34.0),(0.0,0.0,-39.0),(-8.0,2.0,-11.0),(-29.0,6.0,-8.0),(-45.0,11.0,18.0),(-20.0,4.0,35.0),(-9.0,-1.0,1.0),(-23.0,8.0,-27.0),(25.0,-6.0,-18.0),(18.0,-4.0,-44.0),(-21.0,4.0,-9.0),(-8.0,2.0,-3.0),(-21.0,5.0,6.0),(-41.0,9.0,18.0),(17.0,-3.0,32.0),(26.0,-9.0,28.0),(-2.0,5.0,8.0),(-29.0,5.0,-21.0),(54.0,-11.0,38.0),(26.0,-5.0,48.0),(4.0,0.0,37.0),(-24.0,6.0,19.0),(6.0,-5.0,8.0),(6.0,2.0,4.0),(39.0,-9.0,-3.0),(45.0,-9.0,25.0),(-45.0,5.0,-31.0),(63.0,-15.0,-13.0),(38.0,-9.0,-29.0),(0.0,0.0,-7.0),(-22.0,5.0,-20.0),(-49.0,10.0,0.0),(34.0,-9.0,-39.0),(0.0,0.0,-46.0),(-9.0,2.0,-12.0),(-33.0,7.0,-9.0),(-56.0,13.0,17.0),(7.0,-2.0,-47.0),(-23.0,5.0,-12.0),(-10.0,2.0,-4.0),(-23.0,6.0,7.0),(-47.0,10.0,21.0),(15.0,-2.0,36.0),(-38.0,10.0,24.0),(6.0,2.0,9.0),(-34.0,8.0,42.0),(22.0,-3.0,70.0),(35.0,-7.0,44.0),(44.0,-10.0,-9.0),(2.0,-4.0,12.0),(9.0,2.0,1.0),(-4.0,1.0,36.0),(91.0,-21.0,-10.0),(27.0,-6.0,-11.0),(4.0,-1.0,-9.0),(6.0,-6.0,0.0),(-3.0,0.0,-12.0),(6.0,-10.0,-7.0),(-31.0,6.0,-18.0),(39.0,-9.0,-8.0),(42.0,-10.0,-33.0),(1.0,0.0,-16.0),(-27.0,5.0,-28.0),(-31.0,6.0,0.0),(21.0,-5.0,-24.0),(0.0,0.0,-53.0),(-12.0,2.0,-18.0),(-41.0,9.0,-12.0),(-49.0,11.0,14.0),(12.0,-3.0,-32.0),(-27.0,6.0,-18.0),(-17.0,4.0,-8.0),(-28.0,6.0,8.0),(-50.0,12.0,22.0),(-30.0,8.0,50.0),(6.0,8.0,4.0),(-30.0,8.0,63.0),(26.0,-4.0,79.0),(40.0,-8.0,52.0),(43.0,-9.0,30.0),(105.0,-24.0,-11.0),(31.0,-8.0,-12.0),(5.0,-11.0,8.0),(9.0,-2.0,-18.0),(9.0,-8.0,0.0),(-9.0,1.0,-28.0),(-9.0,1.0,-6.0),(12.0,-3.0,-3.0),(49.0,-12.0,-38.0),(1.0,0.0,-25.0),(-34.0,7.0,-34.0),(-11.0,2.0,0.0),(8.0,-2.0,-10.0),(0.0,-1.0,-60.0),(-17.0,4.0,-24.0),(-47.0,10.0,-14.0),(-16.0,4.0,2.0),(-9.0,2.0,-8.0),(-31.0,6.0,-26.0),(-24.0,6.0,-11.0),(-33.0,7.0,9.0),(-52.0,13.0,23.0),(-36.0,9.0,54.0),(-30.0,9.0,78.0),(10.0,4.0,-3.0),(24.0,-4.0,81.0),(43.0,-9.0,54.0),(47.0,-10.0,34.0),(110.0,-25.0,-12.0),(1.0,-7.0,10.0),(40.0,-10.0,-15.0),(-14.0,-73.0,24.0),(8.0,-10.0,-24.0),(-7.0,6.0,-43.0),(-9.0,2.0,-7.0),(11.0,-6.0,-2.0),(56.0,-21.0,-50.0),(2.0,-7.0,-29.0),(-29.0,9.0,-44.0),(-10.0,5.0,-1.0),(6.0,-6.0,-10.0),(-5.0,-3.0,-52.0),(-16.0,5.0,-25.0),(-48.0,20.0,-22.0),(-17.0,7.0,1.0),(-10.0,0.0,-9.0),(-22.0,15.0,-19.0),(-30.0,17.0,-6.0),(-41.0,21.0,14.0),(-48.0,29.0,34.0),(-38.0,14.0,49.0),(-32.0,15.0,92.0),(41.0,17.0,63.0),(-25.0,-26.0,15.0),(33.0,14.0,52.0),(-79.0,-58.0,41.0),(116.0,62.0,-51.0),(52.0,-12.0,38.0),(64.0,-39.0,10.0),(45.0,-38.0,-1.0),(-65.0,-44.0,16.0),(27.0,-37.0,-23.0),(4.0,-12.0,-26.0),(-6.0,1.0,-23.0),(-7.0,5.0,-6.0),(8.0,-9.0,-3.0),(15.0,-28.0,-37.0),(-9.0,-5.0,-28.0),(-16.0,16.0,-31.0),(-5.0,9.0,-2.0),(2.0,-9.0,-7.0),(-8.0,-15.0,-41.0),(-19.0,8.0,-25.0),(-21.0,33.0,-21.0),(-6.0,10.0,1.0),(0.0,-8.0,-9.0),(-30.0,-7.0,-19.0),(-21.0,12.0,-14.0),(-25.0,38.0,-5.0),(-22.0,36.0,11.0),(-43.0,23.0,54.0),(-27.0,30.0,97.0),(-31.0,-44.0,32.0),(3.0,6.0,33.0),(7.0,10.0,39.0),(-10.0,-11.0,7.0),(12.0,-8.0,47.0),(32.0,-7.0,29.0),(15.0,26.0,-4.0),(87.0,56.0,-38.0),(56.0,-69.0,25.0),(0.0,-59.0,-7.0),(-2.0,-41.0,-19.0),(4.0,-27.0,-42.0),(-5.0,-5.0,-31.0),(-10.0,0.0,-27.0),(-7.0,1.0,-17.0),(-20.0,5.0,-35.0),(-15.0,8.0,-21.0),(-17.0,11.0,-19.0),(-27.0,7.0,-24.0),(-17.0,15.0,-14.0),(-23.0,27.0,-7.0),(-35.0,22.0,34.0),(-19.0,30.0,67.0),(-7.0,-17.0,5.0),(-10.0,-9.0,3.0),(-12.0,0.0,20.0),(1.0,8.0,30.0),(-7.0,-32.0,37.0),(10.0,7.0,10.0),(0.0,-2.0,25.0),(0.0,0.0,27.0),(9.0,-3.0,19.0),(17.0,-7.0,10.0),(20.0,-5.0,7.0),(58.0,-1.0,6.0),(15.0,18.0,-3.0),(15.0,-52.0,-36.0),(5.0,-14.0,-14.0),(16.0,-16.0,-40.0),(-3.0,-4.0,-30.0),(-2.0,0.0,-30.0),(-21.0,11.0,-31.0),(-18.0,7.0,-25.0),(-14.0,-11.0,1.0),(-20.0,23.0,-26.0),(-17.0,7.0,-5.0),(-25.0,10.0,3.0),(-14.0,11.0,3.0),(-2.0,14.0,8.0),(-9.0,-1.0,5.0),(-9.0,0.0,13.0),(-25.0,20.0,38.0),(-6.0,3.0,24.0),(-6.0,-24.0,4.0),(15.0,-15.0,43.0),(5.0,-10.0,35.0),(-2.0,-4.0,30.0),(7.0,-7.0,19.0),(17.0,-8.0,8.0),(31.0,1.0,3.0),(35.0,-7.0,-3.0),(15.0,-39.0,-14.0),(30.0,42.0,-10.0),(3.0,-21.0,-19.0),(11.0,-12.0,-40.0),(0.0,-6.0,-32.0),(-5.0,0.0,-27.0),(-12.0,5.0,-31.0),(-31.0,-21.0,-28.0),(-10.0,11.0,-11.0),(-3.0,36.0,-10.0),(-17.0,6.0,-4.0),(-28.0,7.0,2.0),(-16.0,3.0,1.0),(-15.0,17.0,18.0),(-27.0,20.0,44.0),(-16.0,-45.0,9.0),(7.0,-22.0,66.0),(0.0,-12.0,34.0),(-1.0,-17.0,44.0),(32.0,-30.0,18.0),(55.0,0.0,-15.0),(29.0,-5.0,-33.0),(4.0,-5.0,-28.0),(3.0,-4.0,-20.0),(3.0,-1.0,-43.0),(-3.0,5.0,-40.0),(-8.0,8.0,-25.0),(-22.0,15.0,-19.0),(-35.0,23.0,-11.0),(-22.0,15.0,8.0),(-21.0,-114.0,-11.0),(-58.0,-5.0,62.0),(-26.0,-33.0,71.0),(16.0,-34.0,39.0),(-5.0,-9.0,43.0),(40.0,-8.0,20.0),(80.0,-20.0,-24.0),(36.0,1.0,-30.0),(11.0,21.0,-52.0),(1.0,13.0,-53.0),(-5.0,9.0,-40.0),(-13.0,21.0,-32.0),(-50.0,43.0,-11.0),(0.0,-127.0,-28.0),(-28.0,7.0,2.0),(-33.0,3.0,17.0),(-51.0,6.0,34.0),(-49.0,-22.0,85.0),(24.0,-43.0,58.0),(0.0,-24.0,60.0),(36.0,-14.0,14.0),(20.0,-5.0,-14.0),(72.0,-13.0,-23.0),(40.0,0.0,-14.0),(9.0,34.0,-62.0),(17.0,31.0,-52.0),(0.0,10.0,-41.0),(-9.0,13.0,-47.0),(-2.0,-19.0,-5.0),(-51.0,15.0,-19.0),(-29.0,2.0,2.0),(-33.0,9.0,22.0),(-48.0,6.0,28.0),(-51.0,-21.0,86.0),(22.0,-42.0,64.0),(-8.0,-52.0,67.0),(33.0,-12.0,12.0),(32.0,0.0,-22.0),(70.0,-8.0,-23.0),(42.0,-6.0,-16.0),(13.0,55.0,-67.0),(15.0,25.0,-51.0),(1.0,14.0,-39.0),(-1.0,-57.0,-20.0),(-5.0,19.0,-39.0),(-48.0,16.0,-25.0),(-28.0,0.0,0.0),(-38.0,9.0,24.0),(-52.0,4.0,31.0),(-52.0,-25.0,83.0),(12.0,-48.0,58.0),(2.0,-51.0,63.0),(34.0,-11.0,8.0),(35.0,0.0,-33.0),(65.0,-5.0,-14.0),(44.0,-3.0,-17.0),(10.0,49.0,-60.0),(17.0,29.0,-41.0),(-2.0,-65.0,-27.0),(6.0,22.0,-31.0),(-47.0,-476.0,-419.0),(-20.0,-26.0,-22.0),(57.0,131.0,108.0),(32.0,190.0,144.0),(-25.0,208.0,155.0),(-45.0,15.0,-31.0),(-27.0,0.0,-2.0),(-43.0,8.0,27.0),(-56.0,3.0,32.0),(-51.0,-30.0,82.0),(6.0,-56.0,53.0),(6.0,-49.0,57.0),(34.0,-9.0,4.0),(39.0,1.0,-43.0),(60.0,-4.0,-6.0),(49.0,0.0,-20.0),(6.0,36.0,-44.0),(5.0,12.0,-16.0),(7.0,-220.0,-110.0),(30.0,30.0,-59.0),(7.0,20.0,-34.0),(-15.0,-190.0,-156.0),(-38.0,-106.0,-83.0),(-18.0,-28.0,-24.0),(-91.0,-31.0,-73.0),(-9.0,-24.0,-27.0),(5.0,-49.0,14.0),(-37.0,-39.0,-24.0),(-32.0,-37.0,-64.0),(-12.0,-75.0,16.0),(33.0,17.0,-120.0),(47.0,61.0,-108.0),(-21.0,105.0,-148.0),(45.0,-73.0,-6.0),(51.0,64.0,-213.0),(6.0,-35.0,-7.0),(18.0,-111.0,-23.0),(49.0,62.0,-208.0),(20.0,-97.0,17.0),(-28.0,-203.0,-31.0),(-61.0,-108.0,-36.0),(-34.0,-40.0,-17.0),(-50.0,-43.0,-23.0),(-67.0,-42.0,-31.0),(-62.0,-12.0,-29.0),(-63.0,-3.0,-32.0),(-69.0,14.0,-1.0),(-64.0,20.0,-2.0),(-67.0,51.0,-3.0),(-49.0,50.0,-1.0),(-32.0,44.0,0.0),(-56.0,115.0,8.0),(-10.0,206.0,24.0),(46.0,92.0,2.0),(-82.0,-72.0,203.0),(16.0,109.0,31.0),(4.0,31.0,10.0),(-68.0,-85.0,223.0),(41.0,72.0,24.0),(-21.0,-119.0,140.0),(-14.0,-26.0,168.0),(-16.0,10.0,185.0),(-10.0,80.0,-3.0),(-57.0,26.0,81.0),(-53.0,-7.0,51.0),(10.0,17.0,0.0),(-47.0,37.0,41.0),(-61.0,-13.0,26.0),(-1.0,14.0,9.0),(5.0,63.0,8.0),(-12.0,229.0,58.0),(-21.0,-7.0,36.0),(-20.0,-6.0,72.0),(-6.0,-1.0,22.0),(-14.0,0.0,62.0),(20.0,24.0,53.0),(45.0,29.0,54.0),(14.0,12.0,33.0),(33.0,18.0,20.0),(34.0,12.0,-20.0),(39.0,13.0,-4.0),(29.0,0.0,-46.0),(7.0,-25.0,-148.0),(-35.0,-50.0,-138.0),(-20.0,0.0,-19.0),(12.0,-221.0,-48.0),(-13.0,-74.0,-33.0),(9.0,-14.0,3.0),(16.0,-29.0,7.0),(14.0,-3.0,-24.0),(28.0,66.0,-47.0),(53.0,-19.0,-109.0),(38.0,-37.0,-173.0),(29.0,38.0,-153.0),(13.0,113.0,19.0),(37.0,50.0,18.0),(91.0,38.0,20.0),(130.0,10.0,29.0),(139.0,-8.0,29.0),(90.0,-34.0,21.0),(40.0,-51.0,0.0),(14.0,-113.0,-10.0),(-37.0,-60.0,97.0),(-13.0,4.0,86.0),(19.0,21.0,65.0),(13.0,30.0,26.0),(21.0,29.0,27.0),(64.0,64.0,19.0),(29.0,31.0,18.0),(9.0,106.0,88.0),(23.0,183.0,138.0),(-29.0,3.0,1.0),(-111.0,29.0,98.0),(-87.0,-11.0,121.0),(-6.0,-21.0,52.0),(29.0,-28.0,21.0),(14.0,-28.0,29.0),(37.0,-24.0,-4.0),(30.0,-9.0,-22.0),(65.0,-31.0,-29.0),(45.0,-17.0,-39.0),(24.0,19.0,-53.0),(-35.0,-178.0,-52.0),(28.0,-1.0,-81.0),(8.0,6.0,-18.0),(30.0,16.0,-87.0),(-38.0,-101.0,-82.0),(-13.0,-26.0,-22.0),(-40.0,-118.0,-5.0),(-3.0,24.0,-47.0),(-21.0,47.0,-42.0),(-39.0,-73.0,-16.0),(-39.0,-72.0,-15.0),(-12.0,-94.0,21.0),(-31.0,-27.0,-75.0),(44.0,27.0,-113.0),(64.0,58.0,-140.0),(3.0,-30.0,-11.0),(7.0,100.0,-135.0),(-10.0,-168.0,-54.0),(5.0,-139.0,-28.0),(73.0,152.0,-160.0),(-24.0,-136.0,-33.0),(-49.0,-121.0,-34.0),(-32.0,-38.0,-16.0),(-51.0,-36.0,-21.0),(-55.0,-29.0,-20.0),(-48.0,-16.0,-23.0),(-82.0,-10.0,-51.0),(-93.0,20.0,8.0),(-51.0,22.0,0.0),(-56.0,35.0,-6.0),(-50.0,42.0,-3.0),(-32.0,41.0,2.0),(-46.0,123.0,13.0),(-23.0,137.0,21.0),(-12.0,-178.0,188.0),(-3.0,141.0,28.0),(-30.0,164.0,46.0),(-1.0,-110.0,144.0),(2.0,27.0,9.0),(-5.0,-19.0,208.0),(7.0,-11.0,157.0),(-55.0,15.0,75.0),(-10.0,101.0,5.0),(-61.0,55.0,56.0),(-42.0,16.0,27.0),(-34.0,-19.0,23.0),(-16.0,-21.0,35.0),(-29.0,64.0,14.0),(-3.0,14.0,10.0),(5.0,65.0,7.0),(-24.0,13.0,92.0),(-4.0,0.0,21.0),(-14.0,30.0,79.0),(-7.0,34.0,85.0),(32.0,24.0,56.0),(49.0,31.0,53.0),(31.0,15.0,17.0),(29.0,13.0,9.0),(20.0,10.0,15.0),(48.0,9.0,-13.0),(46.0,6.0,-80.0),(15.0,-49.0,-178.0),(-67.0,-88.0,-179.0),(1.0,-87.0,-10.0),(16.0,-14.0,10.0),(22.0,-22.0,-12.0),(16.0,-3.0,-22.0),(16.0,117.0,-35.0),(45.0,-16.0,-149.0),(47.0,-18.0,-180.0),(30.0,48.0,15.0),(78.0,60.0,23.0),(115.0,0.0,37.0),(124.0,7.0,7.0),(91.0,-51.0,8.0),(32.0,-48.0,-1.0),(-10.0,-33.0,76.0),(0.0,5.0,62.0),(30.0,28.0,36.0),(27.0,23.0,31.0),(45.0,46.0,40.0),(33.0,24.0,12.0),(25.0,94.0,64.0),(-146.0,64.0,135.0),(-88.0,0.0,165.0),(-6.0,-37.0,80.0),(33.0,-23.0,25.0),(23.0,-13.0,-4.0),(28.0,-20.0,1.0),(34.0,-21.0,-4.0),(63.0,-40.0,-28.0),(50.0,-28.0,-33.0),(-57.0,-142.0,-17.0),(18.0,0.0,-60.0),(52.0,8.0,-75.0),(14.0,16.0,-66.0),(4.0,4.0,-20.0),(-11.0,-30.0,-17.0),(-38.0,-122.0,-18.0),(-52.0,-90.0,-8.0),(-49.0,-86.0,-6.0),(88.0,112.0,-109.0),(1.0,41.0,-47.0),(-37.0,-79.0,-15.0),(-43.0,-64.0,-13.0),(-27.0,-27.0,-79.0),(46.0,28.0,-123.0),(-48.0,-142.0,6.0),(64.0,38.0,-185.0),(-14.0,-136.0,-17.0),(53.0,56.0,-172.0),(-35.0,-94.0,-21.0),(-29.0,-42.0,-11.0),(-45.0,-40.0,-17.0),(-48.0,-31.0,-20.0),(-46.0,-20.0,-17.0),(-88.0,-12.0,-38.0),(-92.0,16.0,-2.0),(-49.0,22.0,-5.0),(-51.0,33.0,-3.0),(-46.0,40.0,-3.0),(-33.0,42.0,1.0),(-39.0,94.0,6.0),(-7.0,-76.0,202.0),(-12.0,139.0,7.0),(7.0,-22.0,225.0),(-40.0,162.0,-12.0),(8.0,-11.0,167.0),(-52.0,16.0,80.0),(-59.0,60.0,37.0),(-48.0,73.0,37.0),(-6.0,-54.0,32.0),(7.0,-63.0,111.0),(59.0,-78.0,-19.0),(-121.0,160.0,41.0),(-55.0,104.0,43.0),(-4.0,16.0,7.0),(-5.0,-5.0,21.0),(-14.0,-16.0,71.0),(21.0,-25.0,87.0),(-2.0,0.0,64.0),(33.0,16.0,60.0),(50.0,44.0,55.0),(8.0,5.0,4.0),(62.0,42.0,34.0),(44.0,42.0,-13.0),(40.0,46.0,-34.0),(43.0,17.0,-104.0),(19.0,-23.0,-169.0),(-21.0,-27.0,-73.0),(-73.0,-64.0,-126.0),(16.0,-15.0,11.0),(27.0,-22.0,-17.0),(-2.0,138.0,-21.0),(63.0,3.0,106.0),(-30.0,-11.0,-145.0),(62.0,-7.0,-186.0),(76.0,30.0,-10.0),(129.0,15.0,37.0),(133.0,-1.0,10.0),(92.0,-57.0,-21.0),(11.0,-23.0,55.0),(17.0,21.0,36.0),(-100.0,30.0,68.0),(140.0,-7.0,-31.0),(51.0,48.0,49.0),(31.0,24.0,14.0),(-115.0,65.0,96.0),(-55.0,14.0,58.0),(-80.0,-26.0,154.0),(-9.0,-34.0,92.0),(17.0,-46.0,35.0),(33.0,-42.0,23.0),(69.0,-48.0,-12.0),(8.0,-5.0,-1.0),(61.0,-42.0,-36.0),(-11.0,-39.0,-2.0),(51.0,-14.0,-44.0),(19.0,-1.0,-59.0),(48.0,9.0,-77.0),(18.0,23.0,-79.0),(-36.0,-118.0,-18.0),(-52.0,-90.0,-9.0),(-52.0,-87.0,-7.0),(-7.0,-72.0,-36.0),(58.0,90.0,-107.0),(-52.0,-77.0,-37.0),(-19.0,-60.0,-89.0),(-22.0,-97.0,19.0),(10.0,-40.0,-119.0),(-8.0,-74.0,10.0),(45.0,12.0,-248.0),(-28.0,-42.0,-9.0),(-41.0,-38.0,-1.0),(-45.0,-30.0,-5.0),(-47.0,-18.0,-7.0),(-78.0,-1.0,-40.0),(-83.0,-3.0,14.0),(-48.0,16.0,-10.0),(-46.0,28.0,-12.0),(-43.0,37.0,-16.0),(-30.0,39.0,-1.0),(0.0,-18.0,273.0),(-16.0,82.0,-13.0),(-25.0,52.0,118.0),(-23.0,120.0,-11.0),(-47.0,57.0,98.0),(-71.0,71.0,60.0),(35.0,-116.0,92.0),(-26.0,57.0,60.0),(-60.0,79.0,20.0),(-62.0,81.0,21.0),(-56.0,106.0,47.0),(-5.0,-41.0,69.0),(26.0,-44.0,79.0),(0.0,-3.0,69.0),(33.0,15.0,66.0),(44.0,52.0,63.0),(69.0,48.0,44.0),(47.0,47.0,-11.0),(50.0,35.0,-27.0),(35.0,34.0,-115.0),(25.0,-24.0,-161.0),(-24.0,-33.0,-84.0),(10.0,-49.0,-18.0),(11.0,99.0,62.0),(53.0,35.0,-255.0),(143.0,3.0,-4.0),(146.0,-12.0,-39.0),(-19.0,3.0,140.0),(105.0,45.0,-35.0),(24.0,56.0,44.0),(-65.0,17.0,68.0),(-77.0,-35.0,151.0),(-15.0,-39.0,101.0),(37.0,-36.0,41.0),(36.0,-47.0,26.0),(82.0,-52.0,-15.0),(-55.0,-149.0,-12.0),(73.0,-37.0,-38.0),(55.0,-4.0,-31.0),(68.0,6.0,-114.0),(-40.0,-60.0,7.0),(-40.0,-59.0,6.0),(-32.0,-62.0,-19.0),(-14.0,-79.0,-109.0),(18.0,-47.0,-143.0),(-24.0,-83.0,39.0),(1.0,-39.0,-136.0),(-18.0,-72.0,23.0),(7.0,-6.0,-155.0),(-31.0,-32.0,4.0),(-38.0,-27.0,6.0),(-47.0,-17.0,-6.0),(-76.0,-3.0,-16.0),(-78.0,-6.0,-5.0),(-48.0,11.0,-7.0),(-39.0,22.0,-17.0),(-35.0,33.0,-13.0),(-32.0,2.0,151.0),(-20.0,81.0,-32.0),(-40.0,31.0,133.0),(-24.0,100.0,-40.0),(-24.0,30.0,160.0),(-52.0,34.0,126.0),(-44.0,51.0,28.0),(-44.0,57.0,1.0),(-43.0,57.0,2.0),(36.0,-47.0,121.0),(43.0,-3.0,44.0),(50.0,37.0,83.0),(43.0,73.0,95.0),(54.0,44.0,13.0),(19.0,37.0,-67.0),(12.0,106.0,-92.0),(13.0,97.0,-125.0),(72.0,-15.0,-17.0),(93.0,10.0,-187.0),(54.0,25.0,-2.0),(63.0,33.0,32.0),(-40.0,-48.0,146.0),(-22.0,-65.0,121.0),(19.0,-60.0,55.0),(73.0,-44.0,21.0),(-29.0,-79.0,10.0),(83.0,-46.0,-49.0),(71.0,-33.0,-46.0),(56.0,-7.0,-27.0),(-26.0,-61.0,2.0),(-24.0,-65.0,-20.0),(-14.0,-52.0,-51.0),(-16.0,-77.0,-99.0),(-38.0,-79.0,31.0),(34.0,-60.0,-152.0),(-36.0,-32.0,1.0),(24.0,-38.0,-159.0),(-46.0,-16.0,-2.0),(-50.0,-11.0,-6.0),(-69.0,-6.0,-15.0),(-71.0,-2.0,-4.0),(-51.0,5.0,-7.0),(-47.0,10.0,-10.0),(-22.0,38.0,158.0),(-39.0,27.0,-11.0),(-14.0,56.0,149.0),(-39.0,73.0,-36.0),(-50.0,42.0,102.0),(-33.0,31.0,63.0),(-37.0,50.0,33.0),(-31.0,52.0,13.0),(46.0,1.0,41.0),(49.0,23.0,77.0),(43.0,55.0,102.0),(67.0,10.0,-26.0),(48.0,72.0,-19.0),(4.0,146.0,-101.0),(58.0,-18.0,-33.0),(73.0,107.0,-126.0),(-31.0,-105.0,143.0),(45.0,-61.0,67.0),(-36.0,-78.0,15.0),(85.0,-34.0,10.0),(91.0,-25.0,-49.0),(70.0,-30.0,-54.0),(-38.0,-93.0,0.0),(-28.0,-99.0,-38.0),(3.0,-135.0,-117.0),(-48.0,-30.0,-2.0),(25.0,-39.0,-161.0),(-50.0,-16.0,-4.0),(-67.0,-14.0,-5.0),(-67.0,6.0,-13.0),(-50.0,10.0,-9.0),(-22.0,36.0,156.0),(-51.0,22.0,-12.0),(-43.0,95.0,115.0),(-51.0,70.0,45.0),(-45.0,77.0,25.0),(47.0,15.0,78.0),(50.0,17.0,62.0),(71.0,40.0,28.0),(65.0,175.0,-117.0),(10.0,-160.0,31.0),(30.0,-21.0,45.0),(64.0,-19.0,4.0),(79.0,-12.0,-46.0),(-23.0,-69.0,2.0),(-7.0,-88.0,-20.0),(18.0,-56.0,-42.0),(-23.0,-87.0,-166.0),(-74.0,-22.0,-13.0),(-77.0,12.0,-10.0),(-72.0,46.0,142.0),(0.0,40.0,50.0),(-30.0,66.0,28.0),(-35.0,55.0,4.0),(58.0,7.0,70.0),(55.0,63.0,8.0),(27.0,-84.0,-20.0),(22.0,16.0,-8.0),(19.0,-1.0,12.0),(31.0,-18.0,-1.0),(27.0,-49.0,-31.0),(-3.0,-62.0,-57.0),(-44.0,-45.0,-47.0),(-58.0,21.0,28.0),(-24.0,40.0,54.0),(7.0,52.0,41.0),(10.0,-3.0,4.0),(12.0,41.0,14.0),(21.0,21.0,-2.0),(21.0,-8.0,7.0),(24.0,-25.0,-8.0),(18.0,-33.0,-28.0),(0.0,-60.0,-52.0),(-35.0,-40.0,-33.0),(-46.0,22.0,19.0),(-19.0,43.0,50.0),(0.0,0.0,40.0),(-1.0,39.0,30.0),(12.0,44.0,11.0),(21.0,14.0,0.0),(21.0,-9.0,6.0),(24.0,-25.0,-7.0),(12.0,-38.0,-26.0),(-7.0,-55.0,-30.0),(-28.0,-22.0,-17.0),(-32.0,13.0,8.0),(9.0,-16.0,50.0),(-22.0,36.0,29.0),(-1.0,32.0,25.0),(16.0,25.0,21.0),(20.0,11.0,1.0),(23.0,-6.0,-1.0),(22.0,-20.0,-21.0),(6.0,-32.0,-24.0),(-12.0,-40.0,-30.0),(-23.0,-18.0,-16.0),(2.0,-40.0,112.0),(-23.0,12.0,12.0),(-21.0,29.0,27.0),(-4.0,29.0,25.0),(17.0,25.0,16.0),(22.0,8.0,4.0),(24.0,-5.0,-5.0),(20.0,-21.0,-16.0),(0.0,-30.0,-25.0),(-14.0,-32.0,-26.0),(4.0,-68.0,130.0),(-21.0,-12.0,-10.0),(-23.0,11.0,12.0),(-18.0,26.0,26.0),(-2.0,27.0,26.0),(17.0,22.0,17.0),(23.0,7.0,5.0),(24.0,-6.0,-6.0),(17.0,-20.0,-18.0),(0.0,-27.0,-25.0),(3.0,-84.0,111.0),(-19.0,-20.0,-28.0),(-20.0,-6.0,-12.0),(-25.0,10.0,16.0),(-12.0,22.0,29.0),(2.0,22.0,31.0),(18.0,15.0,20.0),(24.0,4.0,5.0),(23.0,-8.0,-8.0),(13.0,-17.0,-21.0),(-1.0,-89.0,105.0),(-2.0,-18.0,-30.0),(-17.0,-16.0,-27.0),(-23.0,-6.0,-10.0),(-22.0,8.0,13.0),(-13.0,16.0,27.0),(0.0,19.0,30.0),(16.0,14.0,21.0),(24.0,3.0,6.0),(23.0,-5.0,-7.0),(0.0,-102.0,84.0),(13.0,-12.0,-23.0),(-2.0,-15.0,-30.0),(-17.0,-13.0,-26.0),(-23.0,-4.0,-9.0),(-23.0,6.0,13.0),(-11.0,13.0,26.0),(0.0,15.0,31.0),(16.0,11.0,21.0),(24.0,3.0,7.0),(5.0,-99.0,62.0),(22.0,-3.0,-10.0),(11.0,-9.0,-23.0),(-2.0,-12.0,-29.0),(-17.0,-11.0,-25.0),(-23.0,-3.0,-8.0),(-22.0,4.0,13.0),(-11.0,10.0,26.0),(2.0,12.0,30.0),(16.0,9.0,21.0),(16.0,-134.0,60.0),(24.0,3.0,4.0),(20.0,1.0,-11.0),(10.0,0.0,-25.0),(-4.0,-2.0,-30.0),(-18.0,-3.0,-24.0),(-23.0,-3.0,-7.0),(-20.0,0.0,14.0),(-9.0,0.0,27.0),(4.0,0.0,31.0),(15.0,-99.0,21.0),(17.0,0.0,20.0),(23.0,1.0,3.0),(21.0,2.0,-12.0),(8.0,1.0,-24.0),(-5.0,0.0,-28.0),(-18.0,0.0,-23.0),(-23.0,0.0,-5.0),(-20.0,-2.0,14.0),(-8.0,-2.0,26.0),(6.0,-94.0,10.0),(5.0,-3.0,27.0),(25.0,-7.0,20.0),(23.0,-2.0,0.0),(17.0,2.0,-16.0),(3.0,6.0,-19.0),(-6.0,4.0,-27.0),(-18.0,3.0,-21.0),(-22.0,1.0,-4.0),(-20.0,-1.0,14.0),(-3.0,-70.0,5.0),(-8.0,-11.0,23.0),(6.0,-15.0,24.0),(17.0,-13.0,13.0),(23.0,-6.0,0.0),(19.0,2.0,-14.0),(7.0,10.0,-22.0),(-6.0,16.0,-24.0),(-18.0,14.0,-14.0),(-22.0,7.0,-1.0),(-18.0,-72.0,-26.0),(-19.0,-6.0,12.0),(-8.0,-12.0,20.0),(7.0,-17.0,23.0),(17.0,-13.0,11.0),(23.0,-7.0,-1.0),(19.0,4.0,-14.0),(6.0,11.0,-21.0),(-6.0,17.0,-23.0),(-19.0,14.0,-11.0),(-19.0,-61.0,-31.0),(-19.0,10.0,5.0),(-18.0,-8.0,9.0),(-13.0,-11.0,20.0),(12.0,-17.0,22.0),(15.0,-9.0,11.0),(26.0,-5.0,-3.0),(21.0,3.0,-16.0),(3.0,8.0,-19.0),(-4.0,15.0,-25.0),(-2.0,-9.0,-4.0),(-24.0,9.0,-6.0),(-20.0,9.0,1.0),(-17.0,-7.0,13.0),(-13.0,-8.0,23.0),(13.0,-10.0,23.0),(17.0,-3.0,13.0),(27.0,-3.0,-1.0),(20.0,1.0,-17.0),(3.0,1.0,-22.0),(13.0,-62.0,-62.0),(4.0,-81.0,-50.0),(-17.0,-65.0,-24.0),(19.0,151.0,69.0),(-32.0,16.0,-32.0),(-36.0,-28.0,-86.0),(6.0,49.0,66.0),(-43.0,7.0,2.0),(-34.0,-3.0,27.0),(-44.0,-46.0,-50.0),(34.0,28.0,88.0),(-2.0,-15.0,45.0),(8.0,-5.0,-1.0),(9.0,-10.0,24.0),(42.0,-21.0,29.0),(41.0,-3.0,-14.0),(-19.0,-86.0,-35.0),(60.0,85.0,17.0),(12.0,17.0,-51.0),(2.0,-93.0,-38.0),(-6.0,1.0,-2.0),(-8.0,19.0,-28.0),(-18.0,-60.0,-24.0),(3.0,88.0,-12.0),(-52.0,42.0,-35.0),(-53.0,11.0,6.0),(-43.0,-6.0,31.0),(-18.0,-39.0,64.0),(-8.0,-88.0,11.0),(10.0,65.0,27.0),(10.0,-3.0,0.0),(10.0,-20.0,27.0),(-2.0,0.0,5.0),(54.0,-18.0,28.0),(6.0,-2.0,-2.0),(-10.0,-46.0,-45.0),(35.0,1.0,-15.0),(35.0,-6.0,-11.0),(28.0,46.0,36.0),(5.0,1.0,-2.0),(-23.0,-47.0,-43.0),(-29.0,-19.0,-37.0),(54.0,23.0,-6.0),(-11.0,4.0,0.0),(-36.0,-23.0,-26.0),(-27.0,-6.0,-36.0),(20.0,19.0,11.0),(31.0,42.0,-9.0),(5.0,-1.0,-6.0),(-70.0,-14.0,-16.0),(19.0,59.0,-10.0),(-5.0,0.0,7.0),(-47.0,16.0,5.0),(1.0,-64.0,14.0),(-41.0,53.0,15.0),(-8.0,0.0,-2.0),(15.0,-61.0,-2.0),(-38.0,22.0,59.0),(8.0,0.0,1.0),(12.0,-20.0,32.0),(15.0,-14.0,21.0),(-7.0,-4.0,7.0),(41.0,-27.0,-32.0),(6.0,22.0,47.0),(10.0,2.0,-6.0),(35.0,1.0,-16.0),(35.0,-7.0,-12.0),(-29.0,-13.0,-40.0),(13.0,0.0,-28.0),(-24.0,-14.0,-17.0),(-6.0,9.0,-16.0),(22.0,18.0,6.0),(-36.0,23.0,-19.0),(-13.0,-25.0,-14.0),(-18.0,4.0,1.0),(-13.0,-3.0,11.0),(2.0,26.0,19.0),(-15.0,-21.0,39.0),(-6.0,-3.0,2.0),(5.0,-20.0,-20.0),(5.0,8.0,45.0),(8.0,3.0,-1.0),(29.0,-2.0,11.0),(23.0,0.0,-8.0),(-11.0,-15.0,-27.0),(-19.0,-30.0,-44.0),(39.0,23.0,33.0),(-31.0,-16.0,-48.0),(-4.0,4.0,-11.0),(14.0,36.0,14.0),(-20.0,7.0,-1.0),(-15.0,-6.0,16.0),(-6.0,-8.0,20.0),(5.0,-9.0,17.0),(15.0,-5.0,10.0),(1.0,-18.0,-56.0),(-10.0,6.0,-26.0),(-7.0,-3.0,15.0),(4.0,-3.0,13.0),(1.87,8.301,-8.639)])])]))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for LionCoded.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python LionCoded.py load and self-test diagnostics complete.")
