package Basic.ExperimentalBinaryCompression;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> IndexedFaceSet example. </p>
 <p> Related links: Catalog page <a href="../../../ExperimentalBinaryCompression/LionIndex.html" target="_blank">Lion</a>,  source <a href="../../../ExperimentalBinaryCompression/Lion.java">Lion.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/Lion.x3d">Lion.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> IndexedFaceSet example. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Martin Isenburg </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 4 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 5 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D VRML binary compression </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Lion.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Lion.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Martin Isenburg
 */

public class Lion
{
	/** Default constructor to create this object. */
	public Lion ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Lion.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("IndexedFaceSet example."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Martin Isenburg"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("4 May 2003"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("5 May 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D VRML binary compression"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Lion.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("Lion.x3d"))
    .addChild(new Viewpoint().setDescription("1M view").setPosition(0.0,0.0,1.0))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.025,0.025,0.025)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"lion.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/lion.jpg"})))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_20_coordIndex()).setTexCoordIndex(getIndexedFaceSet_5_20_texCoordIndex())
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_20_point()))
          .setCoord(new Coordinate().setPoint(getCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_20_coordIndex_1()
		{
			int[] value = {135,157,53,21,-1,21,53,52,23,-1,23,52,15366,15355,-1,147,148,28,27,-1,27,28,34,33,-1,33,34,15360,15359,-1,37,45,155,150,-1,130,152,38,6,-1,6,38,39,8,-1,8,39,40,10,-1,10,40,41,2,-1,4,2,41,-1,42,46,45,37,-1,19,117,61,15348,-1,15387,19,15348,15386,-1,132,16,53,157,-1,117,19,0,-1,15310,15362,47,15363,-1,51,122,123,50,-1,4,51,50,48,-1,25,145,146,26,-1,31,25,26,32,-1,15357,31,32,15358,-1,54,121,18,49,-1,49,50,123,54,-1,47,46,42,43,-1,19,15387,49,18,-1,17,52,53,16,-1,52,17,15347,15366,-1,48,15311,4,-1,60,51,4,-1,60,1,122,51,-1,121,124,0,18,-1,48,50,49,15383,-1,15387,15382,15383,49,-1,15379,15311,48,15383,-1,44,15311,15364,15363,-1,43,44,15363,47,-1,46,47,15362,36,-1,36,30,45,46,-1,155,45,30,139,-1,15311,44,3,-1,3,44,43,9,-1,9,43,42,7,-1,7,42,37,5,-1,62,60,4,41,-1,120,62,41,40,-1,59,120,40,39,-1,119,59,39,38,-1,160,119,38,152,-1,5,37,150,129,-1,35,36,15362,15361,-1,34,35,15361,15360,-1,32,33,15359,15358,-1,31,15357,15346,14,-1,29,30,36,35,-1,28,29,35,34,-1,26,27,33,32,-1,25,31,14,13,-1,149,139,30,29,-1,148,149,29,28,-1,146,147,27,26,-1,145,25,13,131,-1,24,20,118,57,-1,22,24,57,58,-1,136,22,58,192,-1,23,15355,20,24,-1,21,23,24,22,-1,135,21,22,136,-1,20,15314,56,118,-1,15314,20,15343,-1,15355,15342,15343,20,-1,11,15352,15315,15312,-1,15313,15351,15352,11,-1,15316,15348,61,15312,-1,19,18,0,-1,17,15,15345,15347,-1,16,12,15,17,-1,12,16,132,131,-1,14,15,12,13,-1,15346,15345,15,14,-1,13,12,131,-1,15313,56,15314,-1,11,55,56,15313,-1,15312,61,55,11,-1,3,4,15311,-1,9,10,2,3,-1,7,8,10,9,-1,5,6,8,7,-1,129,130,6,5,-1,3,2,4,-1,82,115,191,169,-1,84,114,115,82,-1,14598,14609,114,84,-1,88,89,182,181,-1,94,95,89,88,-1,14602,14603,95,94,-1,184,189,106,98,-1,67,99,186,164,-1,69,100,99,67,-1,71,101,100,69,-1,63,102,101,71,-1,102,63,65,-1,98,106,107,103,-1,14591,61,117,80,-1,14629,14591,80,14630,-1,191,115,77,166,-1,0,80,117,-1,14606,108,14605,14553,-1,111,126,125,113,-1,109,111,113,65,-1,87,180,179,86,-1,93,87,86,92,-1,14601,93,92,14600,-1,110,79,112,116,-1,116,126,111,110,-1,104,103,107,108,-1,79,110,14630,80,-1,77,115,114,78,-1,14609,14590,78,114,-1,65,14554,109,-1,65,113,60,-1,113,125,1,60,-1,79,0,124,112,-1,14626,110,111,109,-1,110,14626,14625,14630,-1,14626,109,14554,14622,-1,14606,14607,14554,105,-1,108,14606,105,104,-1,97,14605,108,107,-1,107,106,91,97,-1,173,91,106,189,-1,64,105,14554,-1,70,104,105,64,-1,68,103,104,70,-1,66,98,103,68,-1,102,65,60,62,-1,101,102,62,120,-1,100,101,120,59,-1,99,100,59,119,-1,186,99,119,160,-1,163,184,98,66,-1,14604,14605,97,96,-1,14603,14604,96,95,-1,14601,14602,94,93,-1,75,14589,14600,92,-1,96,97,91,90,-1,95,96,90,89,-1,93,94,88,87,-1,74,75,92,86,-1,90,91,173,183,-1,89,90,183,182,-1,87,88,181,180,-1,165,74,86,179,-1,57,118,81,85,-1,58,57,85,83,-1,192,58,83,170,-1,85,81,14598,84,-1,83,85,84,82,-1,170,83,82,169,-1,118,56,14557,81,-1,14586,81,14557,-1,81,14586,14585,14598,-1,14555,14558,14595,72,-1,72,14595,14594,14556,-1,14555,61,14591,14559,-1,0,79,80,-1,14590,14588,76,78,-1,78,76,73,77,-1,165,166,77,73,-1,74,73,76,75,-1,75,76,14588,14589,-1,165,73,74,-1,14557,56,14556,-1,14556,56,55,72,-1,72,55,61,14555,-1,14554,65,64,-1,64,63,71,70,-1,70,71,69,68,-1,68,69,67,66,-1,66,67,164,163,-1,65,63,64,-1,116,16066,16065,126,-1,125,126,16065,16071,-1,1,125,16071,16072,-1,16066,116,112,16068,-1,16053,16068,112,124,-1,123,16055,16056,54,-1,16061,16055,123,122,-1,16072,16061,122,1,-1,16058,121,54,16056,-1,124,121,16058,16053,-1,252,294,156,133,-1,133,156,157,135,-1,266,267,143,142,-1,142,143,148,147,-1,153,154,271,270,-1,150,155,154,153,-1,128,151,152,130,-1,218,269,151,128,-1,140,132,157,156,-1,146,145,141,-1,132,140,131,-1,264,140,156,294,-1,154,155,139,137};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_2()
		{
			int[] value = {-1,271,154,137,257,-1,129,150,153,127,-1,217,127,153,270,-1,158,160,152,151,-1,198,158,151,269,-1,144,138,139,149,-1,143,144,149,148,-1,141,142,147,146,-1,140,141,145,131,-1,268,258,138,144,-1,267,268,144,143,-1,265,266,142,141,-1,264,265,141,140,-1,137,139,138,-1,257,137,138,258,-1,134,136,192,159,-1,253,134,159,307,-1,133,135,136,134,-1,252,133,134,253,-1,127,128,130,129,-1,217,218,128,127,-1,167,190,407,365,-1,169,191,190,167,-1,176,177,380,379,-1,181,182,177,176,-1,383,384,188,187,-1,187,188,189,184,-1,164,186,185,162,-1,162,185,382,331,-1,190,191,166,174,-1,175,179,180,-1,165,174,166,-1,407,190,174,377,-1,171,173,189,188,-1,370,171,188,384,-1,161,187,184,163,-1,383,187,161,330,-1,185,186,160,158,-1,382,185,158,198,-1,183,173,172,178,-1,182,183,178,177,-1,180,181,176,175,-1,165,179,175,174,-1,178,172,371,381,-1,177,178,381,380,-1,175,176,379,378,-1,174,175,378,377,-1,172,173,171,-1,371,172,171,370,-1,159,192,170,168,-1,307,159,168,366,-1,168,170,169,167,-1,366,168,167,365,-1,163,164,162,161,-1,161,162,331,330,-1,3751,3725,297,-1,300,295,298,-1,3751,297,3785,-1,247,300,298,-1,295,300,304,-1,416,297,296,-1,296,299,298,295,-1,3725,299,296,297,-1,277,3726,3737,-1,220,2914,2943,-1,2907,2851,293,250,-1,250,293,294,252,-1,261,263,267,266,-1,2927,263,261,-1,289,291,292,290,-1,270,271,291,289,-1,288,249,221,222,-1,216,282,269,218,-1,283,284,197,418,-1,284,283,213,212,-1,212,213,214,211,-1,211,214,290,288,-1,292,249,288,290,-1,249,292,255,248,-1,2906,2903,248,255,-1,255,2926,2906,-1,276,287,286,275,-1,305,310,287,276,-1,275,286,224,227,-1,225,226,227,224,-1,226,225,281,274,-1,274,281,280,273,-1,2936,2931,273,280,-1,247,277,2862,-1,3726,277,247,299,3725,-1,304,300,247,308,-1,247,298,299,-1,416,3785,297,-1,295,304,416,296,-1,259,264,294,293,-1,2852,259,293,2851,-1,254,255,292,291,-1,257,254,291,271,-1,215,289,290,214,-1,217,270,289,215,-1,211,288,222,210,-1,225,223,219,281,-1,286,209,210,224,-1,282,216,213,283,-1,306,198,269,282,-1,311,197,284,285,-1,310,311,285,287,-1,209,286,287,285,-1,212,209,285,284,-1,306,282,283,418,-1,219,220,279,-1,2935,279,220,2943,-1,280,281,219,279,-1,2935,2936,280,279,-1,202,200,240,-1,278,202,240,237,-1,236,243,278,237,-1,278,243,232,233,-1,202,278,233,205,-1,239,203,204,2869,-1,2933,239,2869,2871,-1,201,238,199,-1,2862,238,239,2933,-1,238,2862,277,-1,308,247,2911,195,-1,303,195,2911,2912,-1,415,303,2912,2913,-1,3737,3727,238,277,-1,245,196,305,276,-1,244,245,276,275,-1,228,244,275,227,-1,272,229,226,274,-1,208,272,274,273,-1,2929,208,273,2931,-1,242,417,196,245,-1,242,243,236,235,-1,232,243,241,230,-1,234,231,229,272,-1,207,234,272,208,-1,2870,206,208,2929,-1,262,256,258,268,-1,263,262,268,267,-1,260,261,266,265,-1,259,260,265,264,-1,2927,2926,256,262,-1,2927,262,263,-1,2918,2927,261,260,-1,2852,2918,260,259,-1,254,257,258,256,-1,255,254,256,2926,-1,415,2913,2910,302,-1,194,302,2910,2909,-1,251,253,307,414,-1,246,251,414,301,-1,2908,246,301,193,-1,2909,2908,193,194,-1,250,252,253,251,-1,2907,250,251,246,-1,2914,220,248,2903,-1,220,221,249,248,-1,2862,2863,2911,247,-1,2853,2907,246,2908,-1,417,242,235,309,-1,230,241,244,228,-1,241,242,245,244,-1,242,241,243,-1,3735,240,200,3704,-1,3735,3709,237,240,-1,238,201,203,239,-1,199,238,3727,3703,-1,3708,236,237,3709,-1,3707,235,236,3708,-1,3788,309,235,3707,-1,204,206,2870,2869,-1,233,234,207,205,-1,232,231,234,233,-1,230,231,232,-1,228,229,231,230,-1,227,226,229,228,-1,210,223,225,224,-1,222,223,210,-1,221,219,223,222,-1,220,219,221,-1,215,216,218,217,-1,214,213,216,215,-1,210,209,212,211,-1,206,207,208,-1,204,205,207,206,-1,203,202,205,204,-1,201,202,203,-1,199,200,202,201,-1,3702,3704,200,199,-1,3703,3702,199,-1,410,3812,3838,-1,411,408,413,-1,3785,410,3838,-1,411,413,360,-1,304,413,408,-1,409,410,416,-1,408,411,412,409,-1,410,409,412,3812,-1,3824,3813,390,-1,2090,2061,333,-1,363,406,1998,2054,-1,365,407,406,363,-1,379,380,376,374,-1,374,376,2074,-1,403};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_3()
		{
			int[] value = {405,404,402,-1,402,404,384,383,-1,335,334,362,401,-1,331,382,395,329,-1,418,197,397,396,-1,325,326,396,397,-1,324,327,326,325,-1,401,403,327,324,-1,403,401,362,405,-1,361,368,405,362,-1,368,361,2050,2053,-1,2053,2073,368,-1,388,399,400,389,-1,389,400,310,305,-1,340,337,399,388,-1,337,340,339,338,-1,387,394,338,339,-1,386,393,394,387,-1,393,386,2078,2083,-1,2009,390,360,-1,3812,412,360,390,3813,-1,308,360,413,304,-1,412,411,360,-1,410,3785,416,-1,409,416,304,408,-1,406,407,377,372,-1,1998,406,372,1999,-1,404,405,368,367,-1,384,404,367,370,-1,327,403,402,328,-1,328,402,383,330,-1,323,335,401,324,-1,394,332,336,338,-1,337,323,322,399,-1,396,326,329,395,-1,395,382,198,306,-1,398,397,197,311,-1,400,398,311,310,-1,398,400,399,322,-1,397,398,322,325,-1,418,396,395,306,-1,392,333,332,-1,2090,333,392,2082,-1,392,332,394,393,-1,392,393,2083,2082,-1,353,313,315,-1,350,353,315,391,-1,350,391,356,349,-1,346,345,356,391,-1,318,346,391,315,-1,2016,317,316,352,-1,2018,2016,352,2080,-1,312,351,314,-1,2080,352,351,2009,-1,390,2009,351,-1,195,2058,360,308,-1,2059,2058,195,303,-1,2060,2059,303,415,-1,390,351,3814,3824,-1,389,305,196,358,-1,388,389,358,357,-1,340,388,357,341,-1,387,339,342,385,-1,386,387,385,321,-1,2078,386,321,2076,-1,358,196,417,355,-1,348,349,356,355,-1,343,354,356,345,-1,385,342,344,347,-1,321,385,347,320,-1,2076,321,319,2017,-1,381,371,369,375,-1,380,381,375,376,-1,378,379,374,373,-1,377,378,373,372,-1,375,369,2073,2074,-1,376,375,2074,-1,373,374,2074,2065,-1,372,373,2065,1999,-1,369,371,370,367,-1,2073,369,367,368,-1,302,2057,2060,415,-1,2056,2057,302,194,-1,414,307,366,364,-1,301,414,364,359,-1,193,301,359,2055,-1,194,193,2055,2056,-1,364,366,365,363,-1,359,364,363,2054,-1,2050,361,333,2061,-1,361,362,334,333,-1,360,2058,2010,2009,-1,2055,359,2054,2000,-1,309,348,355,417,-1,341,357,354,343,-1,357,358,355,354,-1,356,354,355,-1,3791,313,353,3822,-1,353,350,3796,3822,-1,352,316,314,351,-1,3790,3814,351,312,-1,3796,350,349,3795,-1,3795,349,348,3794,-1,3794,348,309,3788,-1,2016,2017,319,317,-1,318,320,347,346,-1,346,347,344,345,-1,345,344,343,-1,343,344,342,341,-1,341,342,339,340,-1,337,338,336,323,-1,323,336,335,-1,335,336,332,334,-1,334,332,333,-1,330,331,329,328,-1,328,329,326,327,-1,324,325,322,323,-1,321,320,319,-1,319,320,318,317,-1,317,318,315,316,-1,316,315,314,-1,314,315,313,312,-1,312,313,3791,3789,-1,312,3789,3790,-1,3991,4011,419,3959,-1,4011,3960,419,-1,419,4024,4022,3959,-1,3960,420,4024,419,-1,3960,4009,4027,420,-1,4024,420,3937,3930,-1,3930,3937,4026,4025,-1,420,4027,4008,3937,-1,424,423,422,-1,439,438,437,436,-1,443,442,441,440,-1,447,446,445,444,-1,451,450,449,448,-1,455,454,453,452,-1,459,458,457,456,-1,426,454,460,-1,427,450,461,-1,428,442,445,-1,429,463,462,-1,431,465,464,-1,425,466,1251,-1,470,469,468,467,-1,474,473,472,471,-1,478,477,476,475,-1,458,425,457,-1,457,425,426,479,-1,457,479,480,456,-1,479,426,460,-1,479,460,481,480,-1,454,426,453,-1,455,481,460,454,-1,461,453,426,427,-1,482,452,453,461,-1,450,427,449,-1,451,482,461,450,-1,427,446,449,-1,446,427,428,445,-1,447,448,449,446,-1,442,428,441,-1,443,444,445,442,-1,441,428,429,483,-1,441,483,484,440,-1,483,429,485,-1,483,485,486,484,-1,429,487,485,-1,488,486,485,487,-1,487,429,489,-1,489,490,488,487,-1,489,429,462,-1,489,462,473,490,-1,429,430,438,463,-1,472,473,462,463,-1,438,430,437,-1,439,472,463,438,-1,430,491,437,-1,492,436,437,491,-1,491,430,431,464,-1,464,475,492,491,-1,431,432,493,465,-1,478,475,464,465,-1,432,434,493,-1,494,478,465,493,-1,435,494,493,434,-1,425,458,466,-1,495,1279,1251,466,-1,459,495,466,458,-1,499,498,497,496,-1,503,502,501,500,-1,490,505,504,488,-1,509,508,507,506,-1,516,515,514,513,-1,511,512,518,517,-1,433,510,520,519,-1,519,520,521,-1,522,517,518,-1,522,523,467,-1,469,470,525,524,-1,481,455,527,526,-1,529,528,526,527,-1,528,529,422,423,-1,533,532,531,530,-1,535,534,444,443,-1,537,536,534,535,-1,530,531,536,537,-1,473};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_4()
		{
			int[] value = {474,505,490,-1,488,504,539,486,-1,543,542,541,540,-1,544,542,543,-1,548,547,546,545,-1,474,471,547,548,-1,439,549,471,472,-1,553,552,551,550,-1,436,554,549,439,-1,494,555,477,478,-1,476,477,557,556,-1,550,551,558,-1,435,559,555,494,-1,475,476,560,492,-1,492,560,554,436,-1,500,563,562,561,-1,567,566,565,564,-1,569,568,552,553,-1,571,570,1279,495,-1,573,572,570,571,-1,575,574,572,573,-1,577,421,1355,576,-1,574,575,579,578,-1,578,579,576,1355,-1,580,567,564,581,-1,566,583,582,565,-1,581,564,562,584,-1,564,565,561,562,-1,565,582,585,561,-1,503,500,561,585,-1,563,584,562,-1,584,586,581,-1,588,586,584,587,-1,589,587,584,563,-1,592,591,589,590,-1,587,589,591,593,-1,591,554,560,593,-1,556,588,587,593,-1,560,476,556,593,-1,559,550,558,555,-1,558,551,586,588,-1,555,558,557,477,-1,558,588,556,557,-1,592,549,554,591,-1,551,552,581,586,-1,540,595,594,543,-1,543,594,596,544,-1,596,597,545,544,-1,545,597,598,548,-1,474,548,598,-1,547,471,549,592,-1,547,592,590,546,-1,590,500,501,546,-1,585,599,502,503,-1,600,599,585,582,-1,542,600,601,541,-1,601,600,582,583,-1,594,602,603,-1,605,603,602,604,-1,609,608,607,606,-1,533,608,609,506,-1,613,612,611,610,-1,537,611,612,530,-1,610,611,615,614,-1,535,615,611,537,-1,615,535,443,440,-1,440,484,486,539,-1,504,616,614,539,-1,616,617,613,610,-1,607,613,617,618,-1,607,618,619,606,-1,621,619,618,620,-1,620,618,617,622,-1,622,617,616,623,-1,623,505,474,598,-1,598,597,622,623,-1,597,596,620,622,-1,596,594,603,620,-1,605,620,603,-1,621,620,605,-1,624,621,605,604,-1,619,621,624,625,-1,606,619,625,538,-1,533,530,612,608,-1,608,612,613,607,-1,433,519,627,626,-1,509,506,609,-1,507,627,629,628,-1,521,629,627,519,-1,631,468,469,630,-1,469,633,632,630,-1,469,524,633,-1,451,448,633,524,-1,531,631,630,536,-1,536,630,632,534,-1,534,632,447,444,-1,532,628,631,531,-1,532,533,506,-1,468,629,521,-1,629,468,631,628,-1,635,634,459,456,-1,571,495,459,634,-1,573,571,634,636,-1,634,635,637,636,-1,636,637,639,638,-1,573,636,638,575,-1,643,642,641,640,-1,576,643,644,577,-1,496,646,645,499,-1,496,497,647,424,-1,423,424,647,648,-1,423,648,649,528,-1,529,651,650,422,-1,528,649,652,526,-1,649,637,635,652,-1,652,635,456,480,-1,526,652,480,481,-1,653,527,455,452,-1,653,452,482,525,-1,470,651,653,525,-1,482,451,524,525,-1,650,651,470,467,-1,467,468,521,522,-1,523,654,650,467,-1,646,654,523,514,-1,518,513,523,522,-1,520,517,522,521,-1,517,520,510,511,-1,513,518,512,516,-1,515,645,646,514,-1,651,529,527,653,-1,609,606,538,509,-1,626,627,507,508,-1,648,639,637,649,-1,648,647,641,639,-1,505,623,616,504,-1,502,599,544,501,-1,599,600,542,544,-1,643,640,655,644,-1,498,655,640,497,-1,497,640,641,647,-1,575,638,642,579,-1,579,642,643,576,-1,642,638,639,641,-1,633,448,447,632,-1,422,650,654,424,-1,424,654,646,496,-1,545,546,501,544,-1,506,507,628,532,-1,563,500,590,589,-1,614,615,440,539,-1,616,610,614,-1,513,514,523,-1,656,657,4250,4251,-1,1902,658,659,1905,-1,660,661,4252,4253,-1,4254,4250,657,662,-1,4255,663,4256,4257,-1,663,664,4262,4256,-1,664,665,666,4262,-1,4263,667,4269,4264,-1,665,661,660,666,-1,667,662,657,4269,-1,4269,657,656,4270,-1,4270,656,4251,4271,-1,4273,658,1902,5665,-1,4278,668,658,4273,-1,668,669,659,658,-1,660,4253,4279,670,-1,670,4279,4254,662,-1,666,660,670,671,-1,671,670,662,667,-1,4262,666,671,4280,-1,4280,671,667,4263,-1,672,5672,673,-1,5672,674,673,-1,675,676,677,678,-1,676,679,680,677,-1,679,676,681,682,-1,683,681,676,675,-1,4293,681,683,684,-1,682,681,4293,4294,-1,5672,672,685,4310,-1,4311,4310,685,686,-1,687,1948,1905,659,-1,688,1950,1948,687,-1,4325,689,663,4255,-1,690,661,691,-1,692,661,690,-1,4326,4252,661,692,-1,692,693,4332,4326,-1,690,694,693,692,-1,691,695,694,690,-1,4334,696,689,4325,-1,1961,1962,697,674,-1,672,698,699,685,-1,685,699,700,686,-1,1962,1968,701,697,-1,698,702,703,699,-1,699,703,704,700,-1,696,705,706,689,-1,689,706,664,663,-1,5672,1961,674,-1,706,707,665,664,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_5()
		{
			int[] value = {1968,1967,708,701,-1,702,709,710,703,-1,703,710,711,704,-1,705,712,707,706,-1,707,691,661,665,-1,4376,4293,684,4377,-1,1967,1950,688,708,-1,709,678,677,710,-1,710,677,680,711,-1,712,695,691,707,-1,4311,686,713,4378,-1,4378,713,4334,4367,-1,686,700,714,713,-1,713,714,696,4334,-1,700,704,715,714,-1,714,715,705,696,-1,704,711,716,715,-1,715,716,712,705,-1,711,680,717,716,-1,716,717,695,712,-1,680,679,718,717,-1,717,718,694,695,-1,679,682,719,718,-1,718,719,693,694,-1,682,4294,4379,719,-1,719,4379,4332,693,-1,4379,4380,4333,4332,-1,4377,684,668,4278,-1,684,683,669,668,-1,683,675,720,669,-1,669,720,687,659,-1,675,678,721,720,-1,720,721,688,687,-1,708,688,721,722,-1,722,721,678,709,-1,701,708,722,723,-1,723,722,709,702,-1,697,701,723,724,-1,724,723,702,698,-1,674,697,724,673,-1,673,724,698,672,-1,725,726,727,728,-1,729,730,4428,4427,-1,731,732,730,729,-1,733,734,732,731,-1,735,736,734,733,-1,737,738,736,735,-1,739,740,738,737,-1,4429,4430,740,739,-1,730,741,4449,4428,-1,732,742,741,730,-1,734,743,742,732,-1,736,744,743,734,-1,738,745,744,736,-1,740,746,745,738,-1,4430,4450,746,740,-1,742,743,744,745,-1,4449,741,746,4450,-1,745,746,741,742,-1,747,748,4408,4407,-1,748,747,726,725,-1,739,747,4407,4429,-1,737,726,747,739,-1,735,727,726,737,-1,733,728,727,735,-1,731,725,728,733,-1,729,748,725,731,-1,4427,4408,748,729,-1,4511,749,750,4512,-1,4512,750,751,4513,-1,4513,751,752,4514,-1,4514,752,753,4515,-1,4515,753,754,4516,-1,4517,755,756,4518,-1,749,757,758,750,-1,750,758,759,751,-1,751,759,760,752,-1,752,760,761,753,-1,753,761,762,754,-1,755,763,764,756,-1,757,765,766,758,-1,758,766,767,759,-1,759,767,768,760,-1,760,768,769,761,-1,761,769,770,762,-1,763,771,772,764,-1,769,768,767,766,-1,757,773,774,765,-1,749,775,773,757,-1,4511,4523,775,749,-1,776,777,4545,4544,-1,778,779,777,776,-1,770,780,779,778,-1,765,774,780,770,-1,773,781,782,774,-1,775,783,781,773,-1,4523,784,783,775,-1,4524,4546,784,4523,-1,777,785,4560,4545,-1,779,786,785,777,-1,780,787,786,779,-1,774,782,787,780,-1,785,788,4571,4560,-1,786,789,788,785,-1,787,790,789,786,-1,782,791,790,787,-1,781,792,791,782,-1,783,793,792,781,-1,784,4572,793,783,-1,4546,4573,4572,784,-1,788,755,4517,4571,-1,789,763,755,788,-1,790,771,763,789,-1,791,772,771,790,-1,792,764,772,791,-1,793,756,764,792,-1,4572,4518,756,793,-1,766,765,770,769,-1,794,4587,4516,754,-1,776,4544,4587,794,-1,795,794,754,762,-1,778,776,794,795,-1,795,762,770,-1,770,778,795,-1,796,797,4605,4604,-1,798,799,797,796,-1,800,801,799,798,-1,802,803,804,805,-1,806,807,808,809,-1,810,811,807,806,-1,4606,4607,811,810,-1,799,801,808,807,-1,807,811,797,799,-1,811,4607,4605,797,-1,808,803,802,809,-1,801,804,803,808,-1,800,805,804,801,-1,4630,812,813,4631,-1,812,814,815,813,-1,814,816,817,815,-1,798,818,819,800,-1,796,820,818,798,-1,4604,4634,820,796,-1,810,821,4649,4606,-1,806,822,821,810,-1,809,823,822,806,-1,805,824,825,802,-1,818,815,817,819,-1,820,813,815,818,-1,4634,4631,813,820,-1,821,812,4630,4649,-1,822,814,812,821,-1,823,816,814,822,-1,824,826,827,825,-1,823,825,827,816,-1,809,802,825,823,-1,819,824,805,800,-1,817,826,824,819,-1,816,827,826,817,-1,4667,4666,828,829,-1,829,828,830,831,-1,831,830,832,833,-1,834,835,836,837,-1,838,839,840,841,-1,841,840,842,843,-1,843,842,4668,4669,-1,840,839,832,830,-1,830,828,842,840,-1,828,4666,4668,842,-1,838,837,836,839,-1,839,836,835,832,-1,832,835,834,833,-1,4690,4692,4693,4691,-1,4692,844,845,4693,-1,844,846,847,845,-1,846,848,849,847,-1,833,850,851,831,-1,831,851,852,829,-1,829,852,4696,4667,-1,4669,4711,853,843,-1,843,853,854,841,-1,841,854,855,838,-1,837,856,857,834,-1,850,848,846,851,-1,851,846,844,852,-1,852,844,4692,4696,-1,4711,4693,845,853,-1,853,845,847,854,-1,854,847,849,855,-1,856,858,859,857,-1,849,858,856,855,-1,855,856,837,838,-1,833,834,857,850,-1,850,857,859,848,-1,848,859,858,849,-1,4729,4728,860,861,-1,861,860,862,863,-1,863,862,864,865,-1,866,867,868,869,-1,870,871,872,873,-1,873,872};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_6()
		{
			int[] value = {874,875,-1,875,874,4730,4731,-1,872,871,864,862,-1,862,860,874,872,-1,860,4728,4730,874,-1,870,869,868,871,-1,871,868,867,864,-1,864,867,866,865,-1,4754,876,877,4755,-1,876,878,879,877,-1,878,880,881,879,-1,865,882,883,863,-1,863,883,884,861,-1,861,884,4758,4729,-1,4731,4773,885,875,-1,875,885,886,873,-1,873,886,887,870,-1,869,888,889,866,-1,882,880,878,883,-1,883,878,876,884,-1,884,876,4754,4758,-1,4773,4755,877,885,-1,885,877,879,886,-1,886,879,881,887,-1,888,890,891,889,-1,881,890,888,887,-1,887,888,869,870,-1,865,866,889,882,-1,882,889,891,880,-1,880,891,890,881,-1,892,893,894,895,-1,4803,4802,896,897,-1,897,896,898,899,-1,899,898,900,901,-1,901,900,902,903,-1,903,902,904,905,-1,905,904,906,907,-1,907,906,4804,4805,-1,4802,4824,908,896,-1,896,908,909,898,-1,898,909,910,900,-1,900,910,911,902,-1,902,911,912,904,-1,904,912,913,906,-1,906,913,4825,4804,-1,912,911,910,909,-1,4825,913,908,4824,-1,909,908,913,912,-1,4785,4784,914,915,-1,895,894,915,914,-1,4805,4785,915,907,-1,907,915,894,905,-1,905,894,893,903,-1,903,893,892,901,-1,901,892,895,899,-1,899,895,914,897,-1,897,914,4784,4803,-1,916,917,918,919,-1,920,919,918,-1,917,916,921,-1,921,916,922,923,-1,923,922,924,925,-1,925,924,926,927,-1,927,926,928,929,-1,929,928,930,931,-1,931,930,932,933,-1,933,932,934,935,-1,935,934,936,937,-1,937,936,938,939,-1,940,941,942,943,-1,944,945,946,947,-1,947,946,948,949,-1,949,948,950,951,-1,951,950,952,953,-1,953,952,954,955,-1,955,954,956,957,-1,957,956,958,959,-1,959,958,960,961,-1,961,960,919,920,-1,919,960,922,916,-1,958,956,926,924,-1,956,954,928,926,-1,946,945,938,936,-1,936,934,948,946,-1,934,932,950,948,-1,954,952,930,928,-1,952,950,932,930,-1,960,958,924,922,-1,944,943,942,945,-1,945,942,941,938,-1,938,941,940,939,-1,962,963,964,965,-1,963,966,967,964,-1,966,968,969,967,-1,968,970,971,969,-1,970,972,973,971,-1,972,974,975,973,-1,974,976,977,975,-1,976,978,979,977,-1,978,980,981,979,-1,965,982,983,962,-1,939,984,985,937,-1,937,985,986,935,-1,935,986,987,933,-1,933,987,988,931,-1,931,988,989,929,-1,929,989,990,927,-1,927,990,991,925,-1,925,991,992,923,-1,923,992,993,921,-1,921,993,994,917,-1,917,994,995,918,-1,918,995,996,920,-1,920,996,997,961,-1,961,997,998,959,-1,959,998,999,957,-1,957,999,1000,955,-1,955,1000,1001,953,-1,953,1001,1002,951,-1,951,1002,1003,949,-1,949,1003,1004,947,-1,947,1004,1005,944,-1,943,1006,1007,940,-1,984,980,978,985,-1,985,978,976,986,-1,986,976,974,987,-1,987,974,972,988,-1,988,972,970,989,-1,989,970,968,990,-1,990,968,966,991,-1,991,966,963,992,-1,992,963,962,993,-1,993,962,983,994,-1,994,983,982,995,-1,995,982,965,996,-1,996,965,964,997,-1,997,964,967,998,-1,998,967,969,999,-1,999,969,971,1000,-1,1000,971,973,1001,-1,1001,973,975,1002,-1,1002,975,977,1003,-1,1003,977,979,1004,-1,1004,979,981,1005,-1,1006,1008,1009,1007,-1,981,1008,1006,1005,-1,1005,1006,943,944,-1,939,940,1007,984,-1,984,1007,1009,980,-1,980,1009,1008,981,-1,1010,1011,1012,1013,-1,1014,1013,1012,-1,1011,1010,1015,-1,1015,1010,1016,1017,-1,1017,1016,1018,1019,-1,1019,1018,1020,1021,-1,1021,1020,1022,1023,-1,1023,1022,1024,1025,-1,1025,1024,1026,1027,-1,1027,1026,1028,1029,-1,1029,1028,1030,1031,-1,1031,1030,1032,1033,-1,1034,1035,1036,1037,-1,1038,1039,1040,1041,-1,1041,1040,1042,1043,-1,1043,1042,1044,1045,-1,1045,1044,1046,1047,-1,1047,1046,1048,1049,-1,1049,1048,1050,1051,-1,1051,1050,1052,1053,-1,1053,1052,1054,1055,-1,1055,1054,1013,1014,-1,1013,1054,1016,1010,-1,1052,1050,1020,1018,-1,1050,1048,1022,1020,-1,1040,1039,1032,1030,-1,1030,1028,1042,1040,-1,1028,1026,1044,1042,-1,1048,1046,1024,1022,-1,1046,1044,1026,1024,-1,1054,1052,1018,1016,-1,1038,1037,1036,1039,-1,1039,1036,1035,1032,-1,1032,1035,1034,1033,-1,1056,1057,1058,1059,-1,1057,1060,1061,1058,-1,1060,1062,1063,1061,-1,1062,1064,1065,1063,-1,1064,1066,1067,1065,-1,1066,1068,1069,1067,-1,1068,1070,1071,1069,-1,1070,1072,1073,1071,-1,1072,1074,1075,1073,-1,1059,1076,1077,1056,-1,1033,1078,1079,1031,-1,1031,1079,1080,1029,-1,1029,1080,1081,1027,-1,1027,1081,1082,1025,-1,1025,1082,1083,1023,-1,1023,1083,1084,1021,-1,1021,1084,1085,1019,-1,1019};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_7()
		{
			int[] value = {1085,1086,1017,-1,1017,1086,1087,1015,-1,1015,1087,1088,1011,-1,1011,1088,1089,1012,-1,1012,1089,1090,1014,-1,1014,1090,1091,1055,-1,1055,1091,1092,1053,-1,1053,1092,1093,1051,-1,1051,1093,1094,1049,-1,1049,1094,1095,1047,-1,1047,1095,1096,1045,-1,1045,1096,1097,1043,-1,1043,1097,1098,1041,-1,1041,1098,1099,1038,-1,1037,1100,1101,1034,-1,1078,1074,1072,1079,-1,1079,1072,1070,1080,-1,1080,1070,1068,1081,-1,1081,1068,1066,1082,-1,1082,1066,1064,1083,-1,1083,1064,1062,1084,-1,1084,1062,1060,1085,-1,1085,1060,1057,1086,-1,1086,1057,1056,1087,-1,1087,1056,1077,1088,-1,1088,1077,1076,1089,-1,1089,1076,1059,1090,-1,1090,1059,1058,1091,-1,1091,1058,1061,1092,-1,1092,1061,1063,1093,-1,1093,1063,1065,1094,-1,1094,1065,1067,1095,-1,1095,1067,1069,1096,-1,1096,1069,1071,1097,-1,1097,1071,1073,1098,-1,1098,1073,1075,1099,-1,1100,1102,1103,1101,-1,1075,1102,1100,1099,-1,1099,1100,1037,1038,-1,1033,1034,1101,1078,-1,1078,1101,1103,1074,-1,1074,1103,1102,1075,-1,1104,1105,1106,1107,-1,1108,1109,1110,1111,-1,1112,1113,1114,1115,-1,1116,1117,1118,1119,-1,1120,1121,1122,1123,-1,1123,1122,1124,1125,-1,1125,1124,1126,1127,-1,1127,1126,1128,1129,-1,1129,1128,1130,1131,-1,1131,1130,1132,1133,-1,1133,1132,1134,1135,-1,1135,1134,1136,1137,-1,1137,1136,1138,1139,-1,1139,1138,1140,1141,-1,1141,1140,1142,1143,-1,1143,1142,1144,1145,-1,1145,1144,1146,1147,-1,1147,1146,1148,1149,-1,1149,1148,1150,1151,-1,1151,1150,1152,1153,-1,1153,1152,1154,1155,-1,1155,1154,1156,1157,-1,1157,1156,1158,1159,-1,1159,1158,1160,1161,-1,1161,1160,1162,1163,-1,1163,1162,1121,1120,-1,1121,1164,1165,1122,-1,1122,1165,1166,1124,-1,1124,1166,1167,1126,-1,1126,1167,1168,1128,-1,1128,1168,1169,1130,-1,1130,1169,1107,1132,-1,1132,1107,1106,1134,-1,1134,1106,1170,1136,-1,1136,1170,1171,1138,-1,1138,1171,1172,1140,-1,1140,1172,1173,1142,-1,1142,1173,1174,1144,-1,1144,1174,1175,1146,-1,1146,1175,1176,1148,-1,1148,1176,1177,1150,-1,1150,1177,1105,1152,-1,1152,1105,1104,1154,-1,1154,1104,1178,1156,-1,1156,1178,1179,1158,-1,1158,1179,1180,1160,-1,1160,1180,1181,1162,-1,1162,1181,1164,1121,-1,1175,1174,1173,1172,-1,1177,1176,1171,1170,-1,1172,1171,1176,1175,-1,1105,1177,1170,1106,-1,1169,1168,1179,1178,-1,1178,1104,1107,1169,-1,1167,1166,1181,1180,-1,1180,1179,1168,1167,-1,1166,1165,1164,1181,-1,1119,1118,1182,1183,-1,1115,1114,1183,1182,-1,1111,1110,1184,1185,-1,1117,1116,1185,1184,-1,1186,1187,1188,1189,-1,1109,1108,1189,1188,-1,1190,1191,1187,1186,-1,1123,1191,1190,1120,-1,1120,1190,1186,1163,-1,1163,1186,1189,1161,-1,1161,1189,1108,1159,-1,1159,1108,1111,1157,-1,1157,1111,1185,1155,-1,1155,1185,1116,1153,-1,1153,1116,1119,1151,-1,1151,1119,1183,1149,-1,1149,1183,1114,1147,-1,1147,1114,1113,1145,-1,1145,1113,1112,1143,-1,1143,1112,1115,1141,-1,1141,1115,1182,1139,-1,1139,1182,1118,1137,-1,1137,1118,1117,1135,-1,1135,1117,1184,1133,-1,1133,1184,1110,1131,-1,1131,1110,1109,1129,-1,1129,1109,1188,1127,-1,1127,1188,1187,1125,-1,1125,1187,1191,1123,-1,4896,1192,4895,4894,-1,4849,1194,1193,4848,-1,4862,1195,1194,4849,-1,4893,4898,4897,4892,-1,1192,1196,4895,-1,1194,1198,1197,1193,-1,1195,1199,1198,1194,-1,4896,4912,1200,1192,-1,1192,1200,1201,1196,-1,1196,4918,4917,4895,-1,1201,4919,4918,1196,-1,1198,4921,4920,1197,-1,1199,4922,4921,1198,-1,4936,4918,4919,4935,-1,4947,1202,1200,4912,-1,4848,1193,1202,4947,-1,1202,1203,1201,1200,-1,1193,1197,1203,1202,-1,1203,4948,4919,1201,-1,1197,4920,4948,1203,-1,1204,4961,4922,1199,-1,4897,4923,4961,1204,-1,4962,1204,1199,1195,-1,4892,4897,1204,4962,-1,4963,4962,1195,4862,-1,4984,4896,4894,4983,-1,1207,1206,1205,-1,1219,1218,1217,1216,-1,1223,1222,1221,1220,-1,1227,1226,1225,1224,-1,1231,1230,1229,1228,-1,1235,1234,1233,1232,-1,1239,1238,1237,1236,-1,1243,1242,1241,1240,-1,1244,1237,1214,-1,1245,1233,1213,-1,1230,1225,1212,-1,1247,1246,1211,-1,1249,1248,1209,-1,1251,1250,425,-1,1255,1254,1253,1252,-1,1259,1258,1257,1256,-1,1261,5084,5083,1260,-1,1242,425,1241,-1,1262,1214,425,1242,-1,1243,1263,1262,1242,-1,1244,1214,1262,-1,1263,1264,1244,1262,-1,1238,1214,1237,-1,1237,1244,1264,1236,-1,1213,1214,1238,1245,-1,1245,1238,1239,1265,-1,1234,1213,1233,-1,1233,1245,1265,1232,-1,1234,1229,1213,-1,1230,1212,1213,1229,-1,1229,1234,1235,1228,-1,1226,1212,1225,-1,1225,1230,1231,1224,-1,1266,1211,1212,1226,-1,1227,1267,1266,1226,-1,1268,1211,1266,-1,1267,1269,1268,1266,-1,1268,1270,1211,-1,1270,1268,1269,1271,-1,1272,1211,1270,-1,1270,1271,1273,1272,-1,1247,1211,1272,-1,1273,1257,1247,1272,-1,1246,1221,1210,1211,-1,1246,1247,1257,1258,-1,1222,1210,1221,-1,1221,1246,1258,1220,-1,1222,1274,1210,-1,1274,1222,1223,1275,-1,1249,1209,1210,1274,-1,1274};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_8()
		{
			int[] value = {1275,1261,1249,-1,1248,1276,1208,1209,-1,1248,1249,1261,1260,-1,1276,1217,1208,-1,1276,1248,1260,1277,-1,1218,1208,1217,-1,1217,1276,1277,1216,-1,1250,1241,425,-1,1250,1251,1279,1278,-1,1241,1250,1278,1240,-1,1283,1282,1281,1280,-1,1287,1286,1285,1284,-1,1271,1289,1288,1273,-1,1293,1292,1291,1290,-1,1300,1299,1298,1297,-1,1302,1301,1295,1296,-1,1304,1303,1294,1215,-1,1305,1303,1304,-1,1301,1302,1306,-1,1255,1307,1306,-1,1309,1308,1252,1253,-1,1311,1310,1236,1264,-1,1310,1311,1313,1312,-1,1206,1207,1312,1313,-1,1317,1316,1315,1314,-1,1224,1231,1319,1318,-1,1318,1319,1321,1320,-1,1320,1321,1316,1317,-1,1273,1288,1256,1257,-1,1269,1323,1289,1271,-1,1327,1326,1325,1324,-1,1324,1325,1328,-1,1332,1331,1330,1329,-1,1329,1330,1259,1256,-1,1258,1259,1333,1220,-1,1337,1336,1335,1334,-1,1220,1333,1338,1223,-1,1260,5083,5151,1277,-1,5154,1336,1337,-1,1277,5151,1339,1216,-1,1216,1339,1340,1219,-1,1275,1341,5084,1261,-1,1223,1338,1341,1275,-1,1344,1343,1342,1287,-1,1348,1347,1346,1345,-1,1334,1335,1350,1349,-1,1278,1279,570,1351,-1,1351,570,572,1352,-1,1352,572,574,1353,-1,1356,1355,421,1354,-1,578,1357,1353,574,-1,1355,1356,1357,578,-1,1335,1360,1359,1350,-1,1360,1348,1345,1359,-1,1347,1362,1361,1346,-1,1363,1343,1348,1360,-1,1343,1344,1347,1348,-1,1344,1364,1362,1347,-1,1364,1344,1287,1284,-1,1343,1363,1342,-1,1360,1365,1363,-1,1367,1363,1365,1366,-1,1342,1363,1367,1368,-1,1371,1368,1370,1369,-1,1372,1370,1368,1367,-1,1372,1341,1338,1370,-1,1372,1367,1366,5153,-1,1372,5153,5084,1341,-1,1339,1337,1358,1340,-1,5151,5154,1337,1339,-1,1366,1365,1336,5154,-1,5152,5153,1366,5154,-1,1370,1338,1333,1369,-1,1337,1334,1358,-1,1365,1360,1335,1336,-1,1324,1374,1373,1327,-1,1328,1375,1374,1324,-1,1328,1332,1376,1375,-1,1329,1377,1376,1332,-1,1377,1329,1256,-1,1369,1333,1259,1330,-1,1331,1371,1369,1330,-1,1331,1286,1287,1371,-1,1284,1285,1378,1364,-1,1362,1364,1378,1379,-1,1326,1380,1379,1325,-1,1361,1362,1379,1380,-1,1382,1381,1374,-1,1384,1381,1382,1383,-1,1388,1387,1386,1385,-1,1293,1385,1386,1314,-1,1392,1391,1390,1389,-1,1317,1390,1391,1320,-1,1394,1393,1391,1392,-1,1320,1391,1393,1318,-1,1227,1224,1318,1393,-1,1323,1269,1267,1227,-1,1323,1394,1395,1289,-1,1392,1389,1396,1395,-1,1397,1396,1389,1387,-1,1388,1398,1397,1387,-1,1400,1397,1398,1399,-1,1401,1396,1397,1400,-1,1402,1395,1396,1401,-1,1377,1256,1288,1402,-1,1402,1401,1376,1377,-1,1401,1400,1375,1376,-1,1400,1382,1374,1375,-1,1382,1400,1383,-1,1383,1400,1399,-1,1384,1383,1399,1403,-1,1404,1403,1399,1398,-1,1322,1404,1398,1388,-1,1386,1390,1317,1314,-1,1387,1389,1390,1386,-1,1405,1406,1304,1215,-1,1385,1293,1290,-1,1408,1407,1406,1292,-1,1304,1406,1407,1305,-1,1410,1253,1254,1409,-1,1410,1412,1411,1253,-1,1411,1309,1253,-1,1309,1411,1235,1232,-1,1321,1410,1409,1316,-1,1319,1412,1410,1321,-1,1231,1228,1412,1319,-1,1316,1409,1408,1315,-1,1293,1314,1315,-1,1305,1407,1254,-1,1408,1409,1254,1407,-1,1243,1240,1414,1413,-1,1414,1240,1278,1351,-1,1415,1414,1351,1352,-1,1415,1416,1413,1414,-1,1418,1417,1416,1415,-1,1353,1418,1415,1352,-1,1422,1421,1420,1419,-1,1354,1423,1419,1356,-1,1280,1424,1425,1283,-1,1205,1426,1282,1283,-1,1427,1426,1205,1206,-1,1313,1428,1427,1206,-1,1207,1430,1429,1312,-1,1311,1431,1428,1313,-1,1431,1413,1416,1428,-1,1263,1243,1413,1431,-1,1264,1263,1431,1311,-1,1239,1236,1310,1432,-1,1308,1265,1239,1432,-1,1308,1432,1429,1252,-1,1308,1309,1232,1265,-1,1255,1252,1429,1430,-1,1306,1305,1254,1255,-1,1255,1430,1433,1307,-1,1299,1307,1433,1425,-1,1306,1307,1300,1301,-1,1305,1306,1302,1303,-1,1296,1294,1303,1302,-1,1297,1295,1301,1300,-1,1299,1425,1424,1298,-1,1432,1310,1312,1429,-1,1290,1322,1388,1385,-1,1291,1292,1406,1405,-1,1428,1416,1417,1427,-1,1417,1421,1426,1427,-1,1289,1395,1402,1288,-1,1286,1328,1378,1285,-1,1328,1325,1379,1378,-1,1423,1434,1422,1419,-1,1282,1422,1434,1281,-1,1426,1421,1422,1282,-1,1357,1420,1418,1353,-1,1356,1419,1420,1357,-1,1421,1417,1418,1420,-1,1412,1228,1235,1411,-1,1205,1433,1430,1207,-1,1283,1425,1433,1205,-1,1328,1286,1331,1332,-1,1315,1408,1292,1293,-1,1368,1371,1287,1342,-1,1323,1227,1393,1394,-1,1394,1392,1395,-1,1307,1299,1300,-1,1438,1437,1436,1435,-1,5238,5239,1440,1439,-1,1439,1440,1442,1441,-1,1441,1442,1444,1443,-1,1443,1444,1446,1445,-1,1445,1446,1448,1447,-1,1447,1448,1450,1449,-1,1449,1450,5241,5240,-1,5239,5260,1451,1440,-1,1440,1451,1452,1442,-1,1442,1452,1453,1444,-1,1444,1453,1454,1446,-1,1446,1454,1455,1448,-1,1448,1455,1456,1450,-1,1450,1456,5261,5241,-1,1455,1454,1453,1452,-1,5261,1456,1451,5260,-1,1452,1451,1456,1455,-1,5218,5219,1458,1457,-1,1435,1436,1457,1458,-1,5240,5218,1457,1449,-1,1449,1457};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_9()
		{
			int[] value = {1436,1447,-1,1447,1436,1437,1445,-1,1445,1437,1438,1443,-1,1443,1438,1435,1441,-1,1441,1435,1458,1439,-1,1439,1458,5219,5238,-1,5323,1460,1459,5322,-1,5324,1461,1460,5323,-1,5325,1462,1461,5324,-1,5326,1463,1462,5325,-1,5327,1464,1463,5326,-1,5329,1466,1465,5328,-1,1460,1468,1467,1459,-1,1461,1469,1468,1460,-1,1462,1470,1469,1461,-1,1463,1471,1470,1462,-1,1464,1472,1471,1463,-1,1466,1474,1473,1465,-1,1468,1476,1475,1467,-1,1469,1477,1476,1468,-1,1470,1478,1477,1469,-1,1471,1479,1478,1470,-1,1472,1480,1479,1471,-1,1474,1482,1481,1473,-1,1476,1477,1478,1479,-1,1475,1484,1483,1467,-1,1467,1483,5334,1459,-1,1459,5334,5335,5322,-1,5356,5357,1486,1485,-1,1485,1486,1488,1487,-1,1487,1488,1489,1480,-1,1480,1489,1484,1475,-1,1484,1491,1490,1483,-1,1483,1490,5358,5334,-1,5357,5374,1492,1486,-1,1486,1492,1493,1488,-1,1488,1493,1494,1489,-1,1489,1494,1491,1484,-1,5374,5385,1495,1492,-1,1492,1495,1496,1493,-1,1493,1496,1497,1494,-1,1494,1497,1498,1491,-1,1491,1498,1499,1490,-1,1490,1499,5386,5358,-1,5385,5328,1465,1495,-1,1495,1465,1473,1496,-1,1496,1473,1481,1497,-1,1497,1481,1482,1498,-1,1498,1482,1474,1499,-1,1499,1474,1466,5386,-1,5386,1466,5329,5387,-1,1479,1480,1475,1476,-1,1464,5327,5402,1500,-1,1500,5402,5356,1485,-1,1472,1464,1500,1501,-1,1501,1500,1485,1487,-1,1480,1472,1501,-1,1501,1487,1480,-1,5419,5420,1503,1502,-1,1502,1503,1505,1504,-1,1504,1505,1507,1506,-1,1511,1510,1509,1508,-1,1515,1514,1513,1512,-1,1512,1513,1517,1516,-1,1516,1517,5422,5421,-1,1513,1514,1507,1505,-1,1505,1503,1517,1513,-1,1503,5420,5422,1517,-1,1515,1508,1509,1514,-1,1514,1509,1510,1507,-1,1507,1510,1511,1506,-1,5446,1519,1518,5445,-1,1519,1521,1520,1518,-1,1521,1523,1522,1520,-1,1506,1525,1524,1504,-1,1504,1524,1526,1502,-1,1502,1526,5449,5419,-1,5421,5464,1527,1516,-1,1516,1527,1528,1512,-1,1512,1528,1529,1515,-1,1508,1531,1530,1511,-1,1525,1523,1521,1524,-1,1524,1521,1519,1526,-1,1526,1519,5446,5449,-1,5464,5445,1518,1527,-1,1527,1518,1520,1528,-1,1528,1520,1522,1529,-1,1531,1533,1532,1530,-1,1522,1533,1531,1529,-1,1529,1531,1508,1515,-1,1506,1511,1530,1525,-1,1525,1530,1532,1523,-1,1523,1532,1533,1522,-1,1535,1534,5481,5482,-1,1537,1536,1534,1535,-1,1539,1538,1536,1537,-1,1543,1542,1541,1540,-1,1547,1546,1545,1544,-1,1549,1548,1546,1547,-1,5484,5483,1548,1549,-1,1536,1538,1545,1546,-1,1546,1548,1534,1536,-1,1548,5483,5481,1534,-1,1545,1542,1543,1544,-1,1538,1541,1542,1545,-1,1539,1540,1541,1538,-1,5502,5504,5503,5501,-1,5504,1551,1550,5503,-1,1551,1553,1552,1550,-1,1553,1555,1554,1552,-1,1555,1557,1556,1554,-1,1557,1559,1558,1556,-1,1537,1561,1560,1539,-1,1535,1562,1561,1537,-1,5482,1563,1562,1535,-1,5480,5507,1563,5482,-1,5486,1564,5519,5488,-1,5484,1565,1564,5486,-1,1549,1566,1565,5484,-1,1547,1567,1566,1549,-1,1544,1568,1567,1547,-1,1540,1570,1569,1543,-1,1561,1556,1558,1560,-1,1562,1554,1556,1561,-1,1563,1552,1554,1562,-1,5507,1550,1552,1563,-1,5508,5503,1550,5507,-1,1564,1551,5504,5519,-1,1565,1553,1551,1564,-1,1566,1555,1553,1565,-1,1567,1557,1555,1566,-1,1568,1559,1557,1567,-1,1570,1572,1571,1569,-1,1568,1569,1571,1559,-1,1544,1543,1569,1568,-1,1560,1570,1540,1539,-1,1558,1572,1570,1560,-1,1559,1571,1572,1558,-1,1574,1573,5536,5537,-1,1576,1575,1573,1574,-1,1578,1577,1575,1576,-1,1582,1581,1580,1579,-1,1586,1585,1584,1583,-1,1588,1587,1585,1586,-1,5539,5538,1587,1588,-1,1575,1577,1584,1585,-1,1585,1587,1573,1575,-1,1587,5538,5536,1573,-1,1584,1581,1582,1583,-1,1577,1580,1581,1584,-1,1578,1579,1580,1577,-1,5559,5561,5560,5558,-1,5565,1590,1589,5564,-1,1590,1592,1591,1589,-1,1576,1594,1593,1578,-1,1574,5568,1594,1576,-1,5537,5569,5568,1574,-1,1588,1595,5584,5539,-1,1586,1596,1595,1588,-1,1583,1597,1596,1586,-1,1579,1599,1598,1582,-1,1594,1589,1591,1593,-1,5568,5564,1589,1594,-1,1595,5565,5563,5584,-1,1596,1590,5565,1595,-1,1597,1592,1590,1596,-1,1599,1601,1600,1598,-1,1597,1598,1600,1592,-1,1583,1582,1598,1597,-1,1593,1599,1579,1578,-1,1591,1601,1599,1593,-1,1592,1600,1601,1591,-1,1605,1604,1603,1602,-1,1607,1606,5613,5614,-1,1609,1608,1606,1607,-1,1611,1610,1608,1609,-1,1613,1612,1610,1611,-1,1615,1614,1612,1613,-1,1617,1616,1614,1615,-1,5616,5615,1616,1617,-1,1606,1618,5635,5613,-1,1608,1619,1618,1606,-1,1610,1620,1619,1608,-1,1612,1621,1620,1610,-1,1614,1622,1621,1612,-1,1616,1623,1622,1614,-1,5615,5636,1623,1616,-1,1619,1620,1621,1622,-1,5635,1618,1623,5636,-1,1622,1623,1618,1619,-1,1625,1624,5595,5596,-1,1624,1625,1604,1605,-1,1617,1625,5596,5616,-1,1615,1604,1625,1617,-1,1613,1603,1604,1615,-1,1611,1602,1603,1613,-1,1609,1605,1602,1611,-1,1607,1624,1605,1609,-1,5614,5595,1624,1607,-1,1629,1628,1627,1626,-1,1628,1629,1630,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_10()
		{
			int[] value = {1631,1626,1627,-1,1633,1632,1626,1631,-1,1635,1634,1632,1633,-1,1637,1636,1634,1635,-1,1639,1638,1636,1637,-1,1641,1640,1638,1639,-1,1643,1642,1640,1641,-1,1645,1644,1642,1643,-1,1647,1646,1644,1645,-1,1649,1648,1646,1647,-1,1653,1652,1651,1650,-1,1657,1656,1655,1654,-1,1659,1658,1656,1657,-1,1661,1660,1658,1659,-1,1663,1662,1660,1661,-1,1665,1664,1662,1663,-1,1667,1666,1664,1665,-1,1669,1668,1666,1667,-1,1671,1670,1668,1669,-1,1630,1629,1670,1671,-1,1626,1632,1670,1629,-1,1634,1636,1666,1668,-1,1636,1638,1664,1666,-1,1646,1648,1655,1656,-1,1656,1658,1644,1646,-1,1658,1660,1642,1644,-1,1638,1640,1662,1664,-1,1640,1642,1660,1662,-1,1632,1634,1668,1670,-1,1655,1652,1653,1654,-1,1648,1651,1652,1655,-1,1649,1650,1651,1648,-1,1675,1674,1673,1672,-1,1674,1677,1676,1673,-1,1677,1679,1678,1676,-1,1679,1681,1680,1678,-1,1681,1683,1682,1680,-1,1683,1685,1684,1682,-1,1685,1687,1686,1684,-1,1687,1689,1688,1686,-1,1689,1691,1690,1688,-1,1672,1693,1692,1675,-1,1647,1695,1694,1649,-1,1645,1696,1695,1647,-1,1643,1697,1696,1645,-1,1641,1698,1697,1643,-1,1639,1699,1698,1641,-1,1637,1700,1699,1639,-1,1635,1701,1700,1637,-1,1633,1702,1701,1635,-1,1631,1703,1702,1633,-1,1627,1704,1703,1631,-1,1628,1705,1704,1627,-1,1630,1706,1705,1628,-1,1671,1707,1706,1630,-1,1669,1708,1707,1671,-1,1667,1709,1708,1669,-1,1665,1710,1709,1667,-1,1663,1711,1710,1665,-1,1661,1712,1711,1663,-1,1659,1713,1712,1661,-1,1657,1714,1713,1659,-1,1654,1715,1714,1657,-1,1650,1717,1716,1653,-1,1695,1688,1690,1694,-1,1696,1686,1688,1695,-1,1697,1684,1686,1696,-1,1698,1682,1684,1697,-1,1699,1680,1682,1698,-1,1700,1678,1680,1699,-1,1701,1676,1678,1700,-1,1702,1673,1676,1701,-1,1703,1672,1673,1702,-1,1704,1693,1672,1703,-1,1705,1692,1693,1704,-1,1706,1675,1692,1705,-1,1707,1674,1675,1706,-1,1708,1677,1674,1707,-1,1709,1679,1677,1708,-1,1710,1681,1679,1709,-1,1711,1683,1681,1710,-1,1712,1685,1683,1711,-1,1713,1687,1685,1712,-1,1714,1689,1687,1713,-1,1715,1691,1689,1714,-1,1717,1719,1718,1716,-1,1715,1716,1718,1691,-1,1654,1653,1716,1715,-1,1694,1717,1650,1649,-1,1690,1719,1717,1694,-1,1691,1718,1719,1690,-1,1723,1722,1721,1720,-1,1722,1723,1724,-1,1725,1720,1721,-1,1727,1726,1720,1725,-1,1729,1728,1726,1727,-1,1731,1730,1728,1729,-1,1733,1732,1730,1731,-1,1735,1734,1732,1733,-1,1737,1736,1734,1735,-1,1739,1738,1736,1737,-1,1741,1740,1738,1739,-1,1743,1742,1740,1741,-1,1747,1746,1745,1744,-1,1751,1750,1749,1748,-1,1753,1752,1750,1751,-1,1755,1754,1752,1753,-1,1757,1756,1754,1755,-1,1759,1758,1756,1757,-1,1761,1760,1758,1759,-1,1763,1762,1760,1761,-1,1765,1764,1762,1763,-1,1724,1723,1764,1765,-1,1720,1726,1764,1723,-1,1728,1730,1760,1762,-1,1730,1732,1758,1760,-1,1740,1742,1749,1750,-1,1750,1752,1738,1740,-1,1752,1754,1736,1738,-1,1732,1734,1756,1758,-1,1734,1736,1754,1756,-1,1726,1728,1762,1764,-1,1749,1746,1747,1748,-1,1742,1745,1746,1749,-1,1743,1744,1745,1742,-1,1769,1768,1767,1766,-1,1768,1771,1770,1767,-1,1771,1773,1772,1770,-1,1773,1775,1774,1772,-1,1775,1777,1776,1774,-1,1777,1779,1778,1776,-1,1779,1781,1780,1778,-1,1781,1783,1782,1780,-1,1783,1785,1784,1782,-1,1766,1787,1786,1769,-1,1741,1789,1788,1743,-1,1739,1790,1789,1741,-1,1737,1791,1790,1739,-1,1735,1792,1791,1737,-1,1733,1793,1792,1735,-1,1731,1794,1793,1733,-1,1729,1795,1794,1731,-1,1727,1796,1795,1729,-1,1725,1797,1796,1727,-1,1721,1798,1797,1725,-1,1722,1799,1798,1721,-1,1724,1800,1799,1722,-1,1765,1801,1800,1724,-1,1763,1802,1801,1765,-1,1761,1803,1802,1763,-1,1759,1804,1803,1761,-1,1757,1805,1804,1759,-1,1755,1806,1805,1757,-1,1753,1807,1806,1755,-1,1751,1808,1807,1753,-1,1748,1809,1808,1751,-1,1744,1811,1810,1747,-1,1789,1782,1784,1788,-1,1790,1780,1782,1789,-1,1791,1778,1780,1790,-1,1792,1776,1778,1791,-1,1793,1774,1776,1792,-1,1794,1772,1774,1793,-1,1795,1770,1772,1794,-1,1796,1767,1770,1795,-1,1797,1766,1767,1796,-1,1798,1787,1766,1797,-1,1799,1786,1787,1798,-1,1800,1769,1786,1799,-1,1801,1768,1769,1800,-1,1802,1771,1768,1801,-1,1803,1773,1771,1802,-1,1804,1775,1773,1803,-1,1805,1777,1775,1804,-1,1806,1779,1777,1805,-1,1807,1781,1779,1806,-1,1808,1783,1781,1807,-1,1809,1785,1783,1808,-1,1811,1813,1812,1810,-1,1809,1810,1812,1785,-1,1748,1747,1810,1809,-1,1788,1811,1744,1743,-1,1784,1813,1811,1788,-1,1785,1812,1813,1784,-1,1817,1816,1815,1814,-1,1821,1820,1819,1818,-1,1825,1824,1823,1822,-1,1829,1828,1827,1826,-1,1833,1832,1831,1830,-1,1835,1834,1832,1833,-1,1837,1836,1834,1835,-1,1839,1838,1836,1837,-1,1841,1840,1838,1839,-1,1843,1842,1840,1841,-1,1845,1844,1842,1843,-1,1847,1846,1844,1845,-1,1849,1848,1846,1847,-1,1851,1850,1848,1849,-1,1853,1852,1850,1851,-1,1855,1854,1852,1853,-1,1857,1856,1854};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_11()
		{
			int[] value = {1855,-1,1859,1858,1856,1857,-1,1861,1860,1858,1859,-1,1863,1862,1860,1861,-1,1865,1864,1862,1863,-1,1867,1866,1864,1865,-1,1869,1868,1866,1867,-1,1871,1870,1868,1869,-1,1873,1872,1870,1871,-1,1830,1831,1872,1873,-1,1832,1875,1874,1831,-1,1834,1876,1875,1832,-1,1836,1877,1876,1834,-1,1838,1878,1877,1836,-1,1840,1879,1878,1838,-1,1842,1817,1879,1840,-1,1844,1816,1817,1842,-1,1846,1880,1816,1844,-1,1848,1881,1880,1846,-1,1850,1882,1881,1848,-1,1852,1883,1882,1850,-1,1854,1884,1883,1852,-1,1856,1885,1884,1854,-1,1858,1886,1885,1856,-1,1860,1887,1886,1858,-1,1862,1815,1887,1860,-1,1864,1814,1815,1862,-1,1866,1888,1814,1864,-1,1868,1889,1888,1866,-1,1870,1890,1889,1868,-1,1872,1891,1890,1870,-1,1831,1874,1891,1872,-1,1882,1883,1884,1885,-1,1880,1881,1886,1887,-1,1885,1886,1881,1882,-1,1816,1880,1887,1815,-1,1888,1889,1878,1879,-1,1879,1817,1814,1888,-1,1890,1891,1876,1877,-1,1877,1878,1889,1890,-1,1891,1874,1875,1876,-1,1893,1892,1828,1829,-1,1892,1893,1824,1825,-1,1895,1894,1820,1821,-1,1894,1895,1826,1827,-1,1899,1898,1897,1896,-1,1898,1899,1818,1819,-1,1896,1897,1901,1900,-1,1830,1900,1901,1833,-1,1873,1896,1900,1830,-1,1871,1899,1896,1873,-1,1869,1818,1899,1871,-1,1867,1821,1818,1869,-1,1865,1895,1821,1867,-1,1863,1826,1895,1865,-1,1861,1829,1826,1863,-1,1859,1893,1829,1861,-1,1857,1824,1893,1859,-1,1855,1823,1824,1857,-1,1853,1822,1823,1855,-1,1851,1825,1822,1853,-1,1849,1892,1825,1851,-1,1847,1828,1892,1849,-1,1845,1827,1828,1847,-1,1843,1894,1827,1845,-1,1841,1820,1894,1843,-1,1839,1819,1820,1841,-1,1837,1898,1819,1839,-1,1835,1897,1898,1837,-1,1833,1901,1897,1835,-1,1905,1904,1903,1902,-1,5654,5653,1907,1906,-1,1908,5650,5651,5655,-1,1912,1911,1910,1909,-1,5656,1915,1914,1913,-1,1911,1917,1916,1910,-1,1915,1919,1918,1914,-1,5657,1919,1915,5660,-1,1917,1921,1920,1916,-1,1919,1923,1922,1918,-1,5657,5661,1923,1919,-1,1921,1906,1907,1920,-1,1923,5650,1908,1922,-1,5661,5649,5650,1923,-1,5662,5652,5649,5661,-1,5665,1902,1903,5664,-1,5668,5667,1924,-1,5664,1903,1925,5670,-1,1903,1904,1926,1925,-1,1927,5671,5654,1906,-1,1908,5655,5671,1927,-1,1928,1927,1906,1921,-1,1922,1908,1927,1928,-1,1929,1928,1921,1917,-1,1918,1922,1928,1929,-1,1930,1929,1917,1911,-1,1914,1918,1929,1930,-1,1931,1930,1911,1912,-1,1913,1914,1930,1931,-1,1933,5672,1932,-1,1933,1934,5672,-1,1938,1937,1936,1935,-1,1937,1940,1939,1936,-1,1942,1941,1936,1939,-1,1935,1936,1941,1943,-1,1944,1943,1941,5683,-1,5684,5683,1941,1942,-1,5702,1945,1932,5672,-1,1946,1945,5702,5703,-1,1904,1905,1948,1947,-1,1947,1948,1950,1949,-1,1912,1909,5711,5668,-1,5667,5712,5656,1913,-1,1909,1910,1952,1951,-1,1954,1907,1953,-1,1953,1907,1955,-1,1955,1907,5653,5717,-1,5717,5723,1956,1955,-1,1955,1956,1957,1953,-1,1953,1957,1958,1954,-1,1951,1952,1960,1959,-1,1934,1963,1962,1961,-1,1945,1965,1964,1932,-1,1946,1966,1965,1945,-1,1963,1969,1968,1962,-1,1965,1971,1970,1964,-1,1966,1972,1971,1965,-1,1952,1974,1973,1960,-1,1910,1916,1974,1952,-1,1934,1961,5672,-1,1959,5760,5759,1951,-1,1951,5759,5711,1909,-1,1916,1920,1975,1974,-1,1969,1976,1967,1968,-1,1971,1978,1977,1970,-1,1972,1979,1978,1971,-1,1974,1975,1980,1973,-1,1920,1907,1954,1975,-1,5770,1944,5683,5769,-1,1976,1949,1950,1967,-1,1978,1937,1938,1977,-1,1979,1940,1937,1978,-1,1975,1954,1958,1980,-1,5771,1981,1946,5703,-1,5760,1959,1981,5771,-1,1981,1982,1966,1946,-1,1959,1960,1982,1981,-1,1982,1983,1972,1966,-1,1960,1973,1983,1982,-1,1983,1984,1979,1972,-1,1973,1980,1984,1983,-1,1984,1985,1940,1979,-1,1980,1958,1985,1984,-1,1985,1986,1939,1940,-1,1958,1957,1986,1985,-1,1986,1987,1942,1939,-1,1957,1956,1987,1986,-1,1987,5772,5684,1942,-1,1956,5723,5772,1987,-1,5723,5724,5773,5772,-1,5670,1925,1944,5770,-1,1925,1926,1943,1944,-1,1926,1988,1935,1943,-1,1904,1947,1988,1926,-1,1988,1989,1938,1935,-1,1947,1949,1989,1988,-1,1990,1989,1949,1976,-1,1977,1938,1989,1990,-1,1991,1990,1976,1969,-1,1970,1977,1990,1991,-1,1992,1991,1969,1963,-1,1964,1970,1991,1992,-1,1933,1992,1963,1934,-1,1932,1964,1992,1933,-1,1924,1931,1912,5668,-1,5667,1913,1931,1924,-1,5656,5660,1915,-1,1995,2027,2039,2038,-1,2063,2088,2087,2070,-1,2062,2089,2088,2063,-1,2061,2090,2089,2062,-1,2070,2087,1993,2071,-1,2039,2027,2146,2164,-1,1997,1996,2068,2069,-1,2007,2043,2006,-1,1997,2069,2043,2007,-1,2068,1996,2064,2046,-1,2046,2064,2066,2047,-1,2004,2006,2015,-1,2043,2069,2041,-1,2047,2066,2052,-1,2038,2071,1993,1995,-1,2054,1998,2001,2000,-1,1999,2064,1996,-1,1994,1993,2087,2085,-1,2074,2073,2053,2052,-1,2065,2074,2052,2066,-1,2089,2090,2082,-1,2088,2089,2082,2081,-1,2087,2088,2081,2085,-1,2083,2078,2077,2084,-1,2086,2084,2077,2025,-1,1994,2086,2025,-1,2086,1994};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_12()
		{
			int[] value = {2085,-1,2084,2086,2085,2081,-1,2083,2084,2081,2082,-1,2020,2018,2080,2072,-1,2072,2080,2009,2079,-1,2034,2072,2079,2033,-1,2033,2079,2008,2011,2031,-1,2009,2008,2079,-1,2028,2045,2035,2029,-1,2031,2011,2013,2028,-1,2077,2078,2076,2075,-1,2025,2077,2075,2023,-1,2075,2076,2017,2019,-1,2023,2075,2019,2020,-1,2146,2027,2026,2147,-1,2147,2026,2024,2149,-1,2149,2024,2022,2151,-1,2151,2022,2021,2153,-1,2021,2020,2072,2034,-1,2037,2042,2040,2162,-1,2162,2040,2039,2164,-1,2044,2042,2037,2036,-1,1997,2001,1998,-1,2001,1997,2007,2002,-1,2041,2067,2071,2038,-1,2035,2045,2044,2036,-1,2049,2070,2071,2067,-1,2048,2063,2070,2049,-1,2069,2068,2067,2041,-1,2046,2049,2067,2068,-1,2065,2066,2064,1999,-1,2048,2051,2062,2063,-1,2051,2050,2061,2062,-1,2005,2014,2060,2057,-1,2014,2012,2059,2060,-1,2058,2059,2012,2010,-1,2057,2056,2003,2005,-1,2056,2055,2000,2003,-1,2047,2052,2051,2048,-1,2052,2053,2050,2051,-1,2048,2049,2046,2047,-1,2028,2013,2015,2045,-1,2045,2015,2006,2044,-1,2044,2006,2043,2042,-1,2042,2043,2041,2040,-1,2040,2041,2038,2039,-1,2162,2163,2161,2037,-1,2037,2161,2160,2036,-1,2036,2160,2159,2035,-1,2035,2159,2158,2029,-1,2029,2158,2030,-1,2030,2158,2157,2032,-1,2032,2157,2156,2155,-1,2153,2021,2034,2155,-1,2155,2034,2033,2032,-1,2032,2033,2031,2030,-1,2030,2031,2028,2029,-1,2027,1995,1994,2026,-1,2026,1994,2025,2024,-1,2024,2025,2023,2022,-1,2022,2023,2020,2021,-1,2020,2019,2018,-1,2018,2019,2017,2016,-1,2011,2008,2010,-1,2005,2004,2015,2014,-1,2014,2015,2013,2012,-1,2012,2013,2011,2010,-1,2010,2008,2009,-1,2002,2007,2006,2004,-1,2004,2005,2003,2002,-1,2002,2003,2000,2001,-1,1998,1999,1996,1997,-1,1995,1993,1994,-1,2145,2165,2164,2146,-1,2165,2145,2235,2198,-1,2198,2235,2234,2196,-1,2196,2234,2233,2194,-1,2194,2233,2232,2192,-1,2192,2232,2231,2188,-1,2188,2231,2230,2189,-1,2189,2230,2229,2186,-1,2186,2229,2109,-1,2124,2123,2168,-1,2220,2227,2236,2219,-1,2226,2228,2227,2220,-1,2234,2235,2228,2226,-1,2197,2199,2198,2196,-1,2184,2185,2199,2197,-1,2178,2177,2185,2184,-1,2177,2178,2176,2175,-1,2175,2176,2124,2168,-1,2219,2236,2212,2211,-1,2211,2212,2208,2206,-1,2206,2208,2207,2205,-1,2205,2207,2167,2170,-1,2168,2123,2170,2167,-1,2200,2213,2092,2201,-1,2221,2222,2213,2200,-1,2229,2230,2222,2221,-1,2187,2190,2189,2186,-1,2183,2182,2190,2187,-1,2182,2183,2122,2119,-1,2119,2122,2121,2120,-1,2134,2131,2120,2121,-1,2131,2134,2133,2132,-1,2132,2133,2174,2173,-1,2166,2203,2173,2174,-1,2144,2141,2203,2166,-1,2141,2144,2143,2142,-1,2201,2092,2142,2143,-1,2152,2236,2227,2150,-1,2092,2091,2140,2142,-1,2154,2212,2236,2152,-1,2211,2210,2217,2219,-1,2210,2209,2215,2217,-1,2209,2091,2093,2215,-1,2207,2156,2157,2167,-1,2136,2205,2170,2169,-1,2204,2136,2169,2171,-1,2202,2204,2171,2172,-1,2203,2202,2172,2173,-1,2098,2166,2174,2099,-1,2235,2145,2148,2228,-1,2233,2234,2226,2225,-1,2232,2233,2225,2224,-1,2231,2232,2224,2223,-1,2230,2231,2223,2222,-1,2109,2229,2221,2111,-1,2228,2148,2150,2227,-1,2225,2226,2220,2218,-1,2224,2225,2218,2216,-1,2223,2224,2216,2214,-1,2222,2223,2214,2213,-1,2111,2221,2200,2094,-1,2218,2220,2219,2217,-1,2216,2218,2217,2215,-1,2214,2216,2215,2093,-1,2213,2214,2093,2092,-1,2212,2154,2208,-1,2210,2211,2206,2135,-1,2209,2210,2135,2138,-1,2091,2209,2138,2140,-1,2095,2201,2143,2096,-1,2208,2154,2156,2207,-1,2135,2206,2205,2136,-1,2137,2136,2204,-1,2139,2137,2204,2202,-1,2141,2139,2202,2203,-1,2201,2095,2094,2200,-1,2185,2161,2163,2199,-1,2180,2184,2197,2195,-1,2179,2180,2195,2193,-1,2181,2179,2193,2191,-1,2182,2181,2191,2190,-1,2105,2183,2187,2107,-1,2199,2163,2165,2198,-1,2195,2197,2196,2194,-1,2193,2195,2194,2192,-1,2191,2193,2192,2188,-1,2190,2191,2188,2189,-1,2107,2187,2186,2109,-1,2177,2160,2161,2185,-1,2114,2178,2184,2180,-1,2122,2183,2105,2103,-1,2117,2181,2182,2119,-1,2115,2179,2181,2117,-1,2114,2180,2179,2115,-1,2178,2114,2113,2176,-1,2160,2177,2175,2159,-1,2129,2118,2120,2131,-1,2127,2116,2118,2129,-1,2125,2113,2116,2127,-1,2176,2113,2125,2124,-1,2159,2175,2168,2158,-1,2133,2100,2099,2174,-1,2130,2132,2173,2172,-1,2128,2130,2172,2171,-1,2126,2128,2171,2169,-1,2123,2126,2169,2170,-1,2158,2168,2167,2157,-1,2144,2166,2098,2097,-1,2106,2601,2602,2104,-1,2108,2599,2601,2106,-1,2110,2597,2599,2108,-1,2112,2595,2597,2110,-1,2592,2104,2602,-1,2102,2101,2134,2121,-1,2164,2165,2163,2162,-1,2155,2156,2154,2153,-1,2153,2154,2152,2151,-1,2151,2152,2150,2149,-1,2149,2150,2148,2147,-1,2147,2148,2145,2146,-1,2097,2096,2143,2144,-1,2141,2142,2140,2139,-1,2139,2140,2138,2137,-1,2137,2138,2135,2136,-1,2101,2100,2133,2134,-1,2131,2132,2130,2129,-1,2129,2130,2128,2127,-1,2127,2128,2126,2125,-1,2125,2126,2123,2124,-1,2103,2102,2121,2122};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_13()
		{
			int[] value = {-1,2119,2120,2118,2117,-1,2117,2118,2116,2115,-1,2115,2116,2113,2114,-1,2595,2112,2584,-1,2112,2111,2094,2584,-1,2110,2109,2111,2112,-1,2108,2107,2109,2110,-1,2106,2105,2107,2108,-1,2104,2103,2105,2106,-1,2592,2102,2103,2104,-1,2591,2101,2102,2592,-1,2101,2591,2590,2100,-1,2100,2590,2589,2099,-1,2588,2098,2099,2589,-1,2098,2588,2587,2097,-1,2097,2587,2586,2096,-1,2096,2586,2585,2095,-1,2095,2585,2584,2094,-1,2093,2091,2092,-1,2238,2258,2304,2239,-1,2258,2260,2262,2304,-1,2259,2286,2303,2261,-1,2286,2237,2240,2303,-1,2239,2304,2302,2241,-1,2304,2262,2264,2302,-1,2261,2303,2301,2263,-1,2303,2240,2242,2301,-1,2241,2302,2300,2243,-1,2302,2264,2266,2300,-1,2263,2301,2299,2265,-1,2301,2242,2244,2299,-1,2243,2300,2298,2245,-1,2300,2266,2268,2298,-1,2265,2299,2297,2267,-1,2299,2244,2246,2297,-1,2245,2298,2296,2247,-1,2298,2268,2270,2296,-1,2267,2297,2295,2269,-1,2297,2246,2248,2295,-1,2247,2296,2294,2249,-1,2296,2270,2272,2294,-1,2269,2295,2293,2271,-1,2295,2248,2250,2293,-1,2249,2294,2292,2251,-1,2294,2272,2274,2292,-1,2271,2293,2291,2273,-1,2293,2250,2252,2291,-1,2251,2292,2290,2253,-1,2292,2274,2276,2290,-1,2273,2291,2289,2275,-1,2291,2252,2254,2289,-1,2253,2290,2288,2255,-1,2290,2276,2278,2288,-1,2275,2289,2287,2277,-1,2289,2254,2256,2287,-1,2255,2288,2281,2257,-1,2288,2278,2280,2281,-1,2277,2287,2279,-1,2287,2256,2257,2279,-1,2238,2237,2286,2259,-1,2285,2284,2283,2282,-1,2257,2283,2284,2279,-1,2285,2282,2281,2280,-1,2280,2279,2284,2285,-1,2282,2283,2257,2281,-1,2279,2280,2278,2277,-1,2277,2278,2276,2275,-1,2275,2276,2274,2273,-1,2273,2274,2272,2271,-1,2271,2272,2270,2269,-1,2269,2270,2268,2267,-1,2267,2268,2266,2265,-1,2265,2266,2264,2263,-1,2263,2264,2262,2261,-1,2261,2262,2260,2259,-1,2259,2260,2258,2238,-1,2257,2256,2255,-1,2255,2256,2254,2253,-1,2253,2254,2252,2251,-1,2251,2252,2250,2249,-1,2249,2250,2248,2247,-1,2247,2248,2246,2245,-1,2245,2246,2244,2243,-1,2243,2244,2242,2241,-1,2241,2242,2240,2239,-1,2239,2240,2237,2238,-1,2306,2326,2372,2307,-1,2326,2328,2330,2372,-1,2327,2354,2371,2329,-1,2354,2305,2308,2371,-1,2307,2372,2370,2309,-1,2372,2330,2332,2370,-1,2329,2371,2369,2331,-1,2371,2308,2310,2369,-1,2309,2370,2368,2311,-1,2370,2332,2334,2368,-1,2331,2369,2367,2333,-1,2369,2310,2312,2367,-1,2311,2368,2366,2313,-1,2368,2334,2336,2366,-1,2333,2367,2365,2335,-1,2367,2312,2314,2365,-1,2313,2366,2364,2315,-1,2366,2336,2338,2364,-1,2335,2365,2363,2337,-1,2365,2314,2316,2363,-1,2315,2364,2362,2317,-1,2364,2338,2340,2362,-1,2337,2363,2361,2339,-1,2363,2316,2318,2361,-1,2317,2362,2360,2319,-1,2362,2340,2342,2360,-1,2339,2361,2359,2341,-1,2361,2318,2320,2359,-1,2319,2360,2358,2321,-1,2360,2342,2344,2358,-1,2341,2359,2357,2343,-1,2359,2320,2322,2357,-1,2321,2358,2356,2323,-1,2358,2344,2346,2356,-1,2343,2357,2355,2345,-1,2357,2322,2324,2355,-1,2323,2356,2349,2325,-1,2356,2346,2348,2349,-1,2345,2355,2347,-1,2355,2324,2325,2347,-1,2306,2305,2354,2327,-1,2353,2352,2351,2350,-1,2325,2351,2352,2347,-1,2353,2350,2349,2348,-1,2348,2347,2352,2353,-1,2350,2351,2325,2349,-1,2347,2348,2346,2345,-1,2345,2346,2344,2343,-1,2343,2344,2342,2341,-1,2341,2342,2340,2339,-1,2339,2340,2338,2337,-1,2337,2338,2336,2335,-1,2335,2336,2334,2333,-1,2333,2334,2332,2331,-1,2331,2332,2330,2329,-1,2329,2330,2328,2327,-1,2327,2328,2326,2306,-1,2325,2324,2323,-1,2323,2324,2322,2321,-1,2321,2322,2320,2319,-1,2319,2320,2318,2317,-1,2317,2318,2316,2315,-1,2315,2316,2314,2313,-1,2313,2314,2312,2311,-1,2311,2312,2310,2309,-1,2309,2310,2308,2307,-1,2307,2308,2305,2306,-1,2374,2394,2440,2375,-1,2394,2396,2398,2440,-1,2395,2422,2439,2397,-1,2422,2373,2376,2439,-1,2375,2440,2438,2377,-1,2440,2398,2400,2438,-1,2397,2439,2437,2399,-1,2439,2376,2378,2437,-1,2377,2438,2436,2379,-1,2438,2400,2402,2436,-1,2399,2437,2435,2401,-1,2437,2378,2380,2435,-1,2379,2436,2434,2381,-1,2436,2402,2404,2434,-1,2401,2435,2433,2403,-1,2435,2380,2382,2433,-1,2381,2434,2432,2383,-1,2434,2404,2406,2432,-1,2403,2433,2431,2405,-1,2433,2382,2384,2431,-1,2383,2432,2430,2385,-1,2432,2406,2408,2430,-1,2405,2431,2429,2407,-1,2431,2384,2386,2429,-1,2385,2430,2428,2387,-1,2430,2408,2410,2428,-1,2407,2429,2427,2409,-1,2429,2386,2388,2427,-1,2387,2428,2426,2389,-1,2428,2410,2412,2426,-1,2409,2427,2425,2411,-1,2427,2388,2390,2425,-1,2389,2426,2424,2391,-1,2426,2412,2414,2424,-1,2411,2425,2423,2413,-1,2425,2390,2392,2423,-1,2391,2424,2417,2393,-1,2424,2414,2416,2417,-1,2413,2423,2415,-1,2423,2392,2393,2415,-1,2374,2373,2422,2395,-1,2421,2420,2419,2418,-1,2393,2419,2420,2415,-1,2421,2418,2417,2416,-1,2416,2415,2420,2421,-1,2418,2419,2393,2417,-1,2415,2416,2414,2413,-1,2413,2414,2412,2411,-1,2411};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_14()
		{
			int[] value = {2412,2410,2409,-1,2409,2410,2408,2407,-1,2407,2408,2406,2405,-1,2405,2406,2404,2403,-1,2403,2404,2402,2401,-1,2401,2402,2400,2399,-1,2399,2400,2398,2397,-1,2397,2398,2396,2395,-1,2395,2396,2394,2374,-1,2393,2392,2391,-1,2391,2392,2390,2389,-1,2389,2390,2388,2387,-1,2387,2388,2386,2385,-1,2385,2386,2384,2383,-1,2383,2384,2382,2381,-1,2381,2382,2380,2379,-1,2379,2380,2378,2377,-1,2377,2378,2376,2375,-1,2375,2376,2373,2374,-1,2442,2462,2508,2443,-1,2462,2464,2466,2508,-1,2463,2490,2507,2465,-1,2490,2441,2444,2507,-1,2443,2508,2506,2445,-1,2508,2466,2468,2506,-1,2465,2507,2505,2467,-1,2507,2444,2446,2505,-1,2445,2506,2504,2447,-1,2506,2468,2470,2504,-1,2467,2505,2503,2469,-1,2505,2446,2448,2503,-1,2447,2504,2502,2449,-1,2504,2470,2472,2502,-1,2469,2503,2501,2471,-1,2503,2448,2450,2501,-1,2449,2502,2500,2451,-1,2502,2472,2474,2500,-1,2471,2501,2499,2473,-1,2501,2450,2452,2499,-1,2451,2500,2498,2453,-1,2500,2474,2476,2498,-1,2473,2499,2497,2475,-1,2499,2452,2454,2497,-1,2453,2498,2496,2455,-1,2498,2476,2478,2496,-1,2475,2497,2495,2477,-1,2497,2454,2456,2495,-1,2455,2496,2494,2457,-1,2496,2478,2480,2494,-1,2477,2495,2493,2479,-1,2495,2456,2458,2493,-1,2457,2494,2492,2459,-1,2494,2480,2482,2492,-1,2479,2493,2491,2481,-1,2493,2458,2460,2491,-1,2459,2492,2485,2461,-1,2492,2482,2484,2485,-1,2481,2491,2483,-1,2491,2460,2461,2483,-1,2442,2441,2490,2463,-1,2489,2488,2487,2486,-1,2461,2487,2488,2483,-1,2489,2486,2485,2484,-1,2484,2483,2488,2489,-1,2486,2487,2461,2485,-1,2483,2484,2482,2481,-1,2481,2482,2480,2479,-1,2479,2480,2478,2477,-1,2477,2478,2476,2475,-1,2475,2476,2474,2473,-1,2473,2474,2472,2471,-1,2471,2472,2470,2469,-1,2469,2470,2468,2467,-1,2467,2468,2466,2465,-1,2465,2466,2464,2463,-1,2463,2464,2462,2442,-1,2461,2460,2459,-1,2459,2460,2458,2457,-1,2457,2458,2456,2455,-1,2455,2456,2454,2453,-1,2453,2454,2452,2451,-1,2451,2452,2450,2449,-1,2449,2450,2448,2447,-1,2447,2448,2446,2445,-1,2445,2446,2444,2443,-1,2443,2444,2441,2442,-1,2510,2530,2576,2511,-1,2530,2532,2534,2576,-1,2531,2558,2575,2533,-1,2558,2509,2512,2575,-1,2511,2576,2574,2513,-1,2576,2534,2536,2574,-1,2533,2575,2573,2535,-1,2575,2512,2514,2573,-1,2513,2574,2572,2515,-1,2574,2536,2538,2572,-1,2535,2573,2571,2537,-1,2573,2514,2516,2571,-1,2515,2572,2570,2517,-1,2572,2538,2540,2570,-1,2537,2571,2569,2539,-1,2571,2516,2518,2569,-1,2517,2570,2568,2519,-1,2570,2540,2542,2568,-1,2539,2569,2567,2541,-1,2569,2518,2520,2567,-1,2519,2568,2566,2521,-1,2568,2542,2544,2566,-1,2541,2567,2565,2543,-1,2567,2520,2522,2565,-1,2521,2566,2564,2523,-1,2566,2544,2546,2564,-1,2543,2565,2563,2545,-1,2565,2522,2524,2563,-1,2523,2564,2562,2525,-1,2564,2546,2548,2562,-1,2545,2563,2561,2547,-1,2563,2524,2526,2561,-1,2525,2562,2560,2527,-1,2562,2548,2550,2560,-1,2547,2561,2559,2549,-1,2561,2526,2528,2559,-1,2527,2560,2553,2529,-1,2560,2550,2552,2553,-1,2549,2559,2551,-1,2559,2528,2529,2551,-1,2510,2509,2558,2531,-1,2557,2556,2555,2554,-1,2529,2555,2556,2551,-1,2557,2554,2553,2552,-1,2552,2551,2556,2557,-1,2554,2555,2529,2553,-1,2551,2552,2550,2549,-1,2549,2550,2548,2547,-1,2547,2548,2546,2545,-1,2545,2546,2544,2543,-1,2543,2544,2542,2541,-1,2541,2542,2540,2539,-1,2539,2540,2538,2537,-1,2537,2538,2536,2535,-1,2535,2536,2534,2533,-1,2533,2534,2532,2531,-1,2531,2532,2530,2510,-1,2529,2528,2527,-1,2527,2528,2526,2525,-1,2525,2526,2524,2523,-1,2523,2524,2522,2521,-1,2521,2522,2520,2519,-1,2519,2520,2518,2517,-1,2517,2518,2516,2515,-1,2515,2516,2514,2513,-1,2513,2514,2512,2511,-1,2511,2512,2509,2510,-1,2608,2613,2614,2609,-1,2606,2579,2612,2607,-1,2579,2606,2605,2611,-1,2609,2614,2593,-1,2617,2600,2598,2616,-1,2594,2615,2578,2596,-1,2603,2581,2580,2604,-1,2604,2580,2611,2605,-1,2607,2612,2613,2608,-1,2614,2615,2594,2593,-1,2616,2598,2596,2578,-1,2582,2610,2581,2603,-1,2593,2584,2585,2609,-1,2609,2585,2586,2608,-1,2608,2586,2587,2607,-1,2607,2587,2588,2606,-1,2583,2600,2617,2577,-1,2606,2588,2589,2605,-1,2605,2589,2590,2604,-1,2604,2590,2591,2603,-1,2603,2591,2592,2582,-1,2582,2592,2602,2583,-1,2583,2602,2601,2600,-1,2600,2601,2599,2598,-1,2598,2599,2597,2596,-1,2596,2597,2595,2594,-1,2594,2595,2584,2593,-1,2577,2610,2582,2583,-1,2843,2771,2742,-1,2825,2770,2771,2842,-1,2768,2769,2824,2789,-1,2765,2766,2790,2823,-1,2763,2764,2822,2792,-1,2760,2761,2793,2819,-1,2758,2759,2818,2795,-1,2755,2756,2796,2817,-1,2843,2742,2845,2840,-1,2805,2825,2842,2841,-1,2789,2824,2807,2772,-1,2823,2790,2787,2821,-1,2792,2822,2820,2775,-1,2819,2793,2786,2815,-1,2795,2818,2814,2778,-1,2817,2796,2785,2802,-1,2806,2839,2613,-1,2807,2806,2773,2772,-1,2821,2787,2773,2808,-1,2775,2820,2809,2776,-1,2815,2786,2776,2810};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_15()
		{
			int[] value = {-1,2778,2814,2811,2779,-1,2827,2837,2804,2803,-1,2841,2839,2806,2805,-1,2615,2614,2840,2845,-1,2779,2811,2611,-1,2579,2776,2809,-1,2612,2773,2806,2613,-1,2579,2808,2773,2612,-1,2836,2617,2616,2844,-1,2826,2578,2615,2845,-1,2617,2836,2834,-1,2798,2797,2581,-1,2580,2827,2803,2611,-1,2579,2611,2810,2776,-1,2675,2673,2672,2670,2668,2667,2678,2677,-1,2845,2742,2741,2826,-1,2743,2744,2835,-1,2781,2752,2753,2838,-1,2837,2827,2797,2782,-1,2836,2844,2743,2835,-1,2797,2801,2782,-1,2833,2745,2746,2831,-1,2829,2828,2834,2833,-1,2743,2844,2826,-1,2844,2616,2578,2826,-1,2837,2782,2781,2838,-1,2782,2801,2813,2784,-1,2771,2843,2842,-1,2843,2840,2841,2842,-1,2841,2840,2839,-1,2840,2614,2613,2839,-1,2754,2816,2838,2753,-1,2816,2804,2837,2838,-1,2830,2832,2812,2800,-1,2799,2830,2800,2798,-1,2833,2834,2836,2835,-1,2745,2833,2835,2744,-1,2750,2784,2813,2749,-1,2748,2812,2832,2747,-1,2785,2779,2803,2802,-1,2803,2779,2611,-1,2828,2577,2617,2834,-1,2831,2829,2833,-1,2747,2832,2831,2746,-1,2832,2830,2829,2831,-1,2830,2799,2828,2829,-1,2799,2610,2577,2828,-1,2797,2827,2580,-1,2826,2741,2743,-1,2770,2825,2824,2769,-1,2825,2805,2807,2824,-1,2823,2821,2820,2822,-1,2765,2823,2822,2764,-1,2821,2808,2809,2820,-1,2760,2819,2818,2759,-1,2819,2815,2814,2818,-1,2755,2817,2816,2754,-1,2817,2802,2804,2816,-1,2815,2810,2811,2814,-1,2749,2813,2812,2748,-1,2813,2801,2800,2812,-1,2811,2810,2611,-1,2809,2808,2579,-1,2807,2805,2806,-1,2804,2802,2803,-1,2801,2797,2798,2800,-1,2610,2799,2798,2581,-1,2797,2580,2581,-1,2751,2752,2781,2783,-1,2750,2751,2783,2784,-1,2794,2796,2756,2757,-1,2795,2794,2757,2758,-1,2780,2785,2796,2794,-1,2778,2780,2794,2795,-1,2791,2793,2761,2762,-1,2792,2791,2762,2763,-1,2777,2786,2793,2791,-1,2775,2777,2791,2792,-1,2788,2790,2766,2767,-1,2789,2788,2767,2768,-1,2774,2787,2790,2788,-1,2772,2774,2788,2789,-1,2774,2773,2787,-1,2777,2776,2786,-1,2780,2779,2785,-1,2783,2782,2784,-1,2783,2781,2782,-1,2780,2778,2779,-1,2777,2775,2776,-1,2774,2772,2773,-1,2740,2711,2742,2771,-1,2739,2740,2771,2770,-1,2738,2739,2770,2769,-1,2737,2738,2769,2768,-1,2736,2737,2768,2767,-1,2735,2736,2767,2766,-1,2734,2735,2766,2765,-1,2733,2734,2765,2764,-1,2732,2733,2764,2763,-1,2731,2732,2763,2762,-1,2730,2731,2762,2761,-1,2729,2730,2761,2760,-1,2728,2729,2760,2759,-1,2727,2728,2759,2758,-1,2726,2727,2758,2757,-1,2725,2726,2757,2756,-1,2724,2725,2756,2755,-1,2723,2724,2755,2754,-1,2722,2723,2754,2753,-1,2721,2722,2753,2752,-1,2720,2721,2752,2751,-1,2719,2720,2751,2750,-1,2718,2719,2750,2749,-1,2717,2718,2749,2748,-1,2716,2717,2748,2747,-1,2715,2716,2747,2746,-1,2714,2715,2746,2745,-1,2713,2714,2745,2744,-1,2712,2713,2744,2743,-1,2710,2712,2743,2741,-1,2711,2710,2741,2742,-1,2624,2626,2711,2740,-1,2622,2624,2740,2739,-1,2618,2622,2739,2738,-1,2619,2618,2738,2737,-1,2632,2619,2737,2736,-1,2640,2632,2736,2735,-1,2638,2640,2735,2734,-1,2634,2638,2734,2733,-1,2635,2634,2733,2732,-1,2647,2635,2732,2731,-1,2671,2647,2731,2730,-1,2669,2671,2730,2729,-1,2665,2669,2729,2728,-1,2666,2665,2728,2727,-1,2657,2666,2727,2726,-1,2655,2657,2726,2725,-1,2653,2655,2725,2724,-1,2649,2653,2724,2723,-1,2650,2649,2723,2722,-1,2663,2650,2722,2721,-1,2704,2663,2721,2720,-1,2702,2704,2720,2719,-1,2700,2702,2719,2718,-1,2717,2700,2718,-1,2696,2700,2717,2716,-1,2697,2696,2716,2715,-1,2708,2697,2715,2714,-1,2679,2708,2714,2713,-1,2680,2679,2713,2712,-1,2694,2680,2712,2710,-1,2626,2694,2710,2711,-1,2660,2658,2656,2654,2652,2651,2664,2662,-1,2644,2642,2641,2639,2637,2636,2648,2646,-1,2629,2627,2625,2623,2621,2620,2633,2631,-1,2682,2681,2695,2693,2692,2691,2690,2689,2688,2687,2686,2684,-1,2706,2705,2703,2701,2699,2698,2709,2707,-1,2630,2632,2643,-1,2643,2645,2674,-1,2676,2657,2659,-1,2663,2704,2685,2661,-1,2683,2708,2679,-1,2694,2626,2628,-1,2645,2647,2674,-1,2709,2698,2697,2708,-1,2707,2709,2708,2683,-1,2706,2707,2683,2685,-1,2705,2706,2685,2704,-1,2703,2705,2704,2702,-1,2701,2703,2702,2700,-1,2699,2701,2700,2696,-1,2698,2699,2696,2697,-1,2695,2681,2680,2694,-1,2693,2695,2694,2628,-1,2692,2693,2628,2630,-1,2691,2692,2630,2643,-1,2690,2691,2643,2674,-1,2689,2690,2674,2676,-1,2688,2689,2676,2659,-1,2687,2688,2659,2661,-1,2686,2687,2661,2685,-1,2684,2686,2685,2683,-1,2682,2684,2683,2679,-1,2681,2682,2679,2680,-1,2678,2667,2666,2657,-1,2677,2678,2657,2676,-1,2675,2677,2676,2674,-1,2673,2675,2674,2647,-1,2672,2673,2647,2671,-1,2670,2672,2671,2669,-1,2668,2670,2669,2665,-1,2667,2668,2665,2666,-1,2664,2651,2650,2663,-1,2662,2664,2663,2661,-1,2660,2662,2661,2659,-1,2658,2660,2659,2657,-1,2656,2658,2657,2655,-1,2654,2656,2655,2653,-1,2652,2654,2653,2649,-1,2651,2652,2649,2650,-1,2648,2636,2635,2647};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_16()
		{
			int[] value = {-1,2646,2648,2647,2645,-1,2644,2646,2645,2643,-1,2642,2644,2643,2632,-1,2641,2642,2632,2640,-1,2639,2641,2640,2638,-1,2637,2639,2638,2634,-1,2636,2637,2634,2635,-1,2633,2620,2619,2632,-1,2631,2633,2632,2630,-1,2629,2631,2630,2628,-1,2627,2629,2628,2626,-1,2625,2627,2626,2624,-1,2623,2625,2624,2622,-1,2621,2623,2622,2618,-1,2620,2621,2618,2619,-1,2891,2892,2880,2848,-1,2923,2940,2941,2916,-1,2916,2941,2942,2915,-1,2915,2942,2943,2914,-1,2924,2846,2940,2923,-1,3017,2999,2880,2892,-1,2922,2921,2849,2850,-1,2859,2896,2860,-1,2860,2896,2922,2850,-1,2899,2917,2849,2921,-1,2900,2919,2917,2899,-1,2868,2859,2857,-1,2894,2922,2896,-1,2905,2919,2900,-1,2848,2846,2924,2891,-1,2853,2854,2851,2907,-1,2849,2917,2852,-1,2938,2940,2846,2847,-1,2905,2906,2926,2927,-1,2919,2905,2927,2918,-1,2935,2943,2942,-1,2934,2935,2942,2941,-1,2938,2934,2941,2940,-1,2937,2930,2931,2936,-1,2878,2930,2937,2939,-1,2878,2939,2847,-1,2938,2847,2939,-1,2934,2938,2939,2937,-1,2935,2934,2937,2936,-1,2925,2933,2871,2873,-1,2932,2862,2933,2925,-1,2886,2932,2925,2887,-1,2884,2864,2861,2932,2886,-1,2932,2861,2862,-1,2882,2888,2898,2881,-1,2881,2866,2864,2884,-1,2928,2929,2931,2930,-1,2876,2928,2930,2878,-1,2872,2870,2929,2928,-1,2873,2872,2928,2876,-1,3000,2879,2880,2999,-1,3002,2877,2879,3000,-1,3004,2875,2877,3002,-1,3006,2874,2875,3004,-1,2887,2925,2873,2874,-1,3015,2893,2895,2890,-1,3017,2892,2893,3015,-1,2889,2890,2895,2897,-1,2851,2854,2850,-1,2855,2860,2850,2854,-1,2891,2924,2920,2894,-1,2889,2897,2898,2888,-1,2920,2924,2923,2902,-1,2902,2923,2916,2901,-1,2894,2920,2921,2922,-1,2921,2920,2902,2899,-1,2852,2917,2919,2918,-1,2916,2915,2904,2901,-1,2915,2914,2903,2904,-1,2910,2913,2867,2858,-1,2913,2912,2865,2867,-1,2863,2865,2912,2911,-1,2858,2856,2909,2910,-1,2856,2853,2908,2909,-1,2901,2904,2905,2900,-1,2904,2903,2906,2905,-1,2900,2899,2902,2901,-1,2898,2868,2866,2881,-1,2897,2859,2868,2898,-1,2895,2896,2859,2897,-1,2893,2894,2896,2895,-1,2892,2891,2894,2893,-1,2890,3014,3016,3015,-1,2889,3013,3014,2890,-1,2888,3012,3013,2889,-1,2882,3011,3012,2888,-1,2883,3011,2882,-1,2885,3010,3011,2883,-1,3008,3009,3010,2885,-1,3008,2887,2874,3006,-1,2885,2886,2887,3008,-1,2883,2884,2886,2885,-1,2882,2881,2884,2883,-1,2879,2847,2848,2880,-1,2877,2878,2847,2879,-1,2875,2876,2878,2877,-1,2874,2873,2876,2875,-1,2871,2872,2873,-1,2869,2870,2872,2871,-1,2863,2861,2864,-1,2867,2868,2857,2858,-1,2865,2866,2868,2867,-1,2863,2864,2866,2865,-1,2862,2861,2863,-1,2857,2859,2860,2855,-1,2855,2856,2858,2857,-1,2854,2853,2856,2855,-1,2850,2849,2852,2851,-1,2847,2846,2848,-1,2999,3017,3018,2998,-1,3051,3088,2998,3018,-1,3049,3087,3088,3051,-1,3047,3086,3087,3049,-1,3045,3085,3086,3047,-1,3041,3084,3085,3045,-1,3042,3083,3084,3041,-1,3039,3082,3083,3042,-1,2962,3082,3039,-1,3021,2976,2977,-1,3072,3089,3080,3073,-1,3073,3080,3081,3079,-1,3079,3081,3088,3087,-1,3049,3051,3052,3050,-1,3050,3052,3038,3037,-1,3037,3038,3030,3031,-1,3028,3029,3031,3030,-1,3021,2977,3029,3028,-1,3064,3065,3089,3072,-1,3059,3061,3065,3064,-1,3058,3060,3061,3059,-1,3023,3020,3060,3058,-1,3020,3023,2976,3021,-1,3054,2945,3066,3053,-1,3053,3066,3075,3074,-1,3074,3075,3083,3082,-1,3039,3042,3043,3040,-1,3040,3043,3035,3036,-1,2972,2975,3036,3035,-1,2973,2974,2975,2972,-1,2974,2973,2984,2987,-1,2985,2986,2987,2984,-1,3026,3027,2986,2985,-1,3027,3026,3056,3019,-1,3019,3056,2994,2997,-1,2995,2996,2997,2994,-1,2996,2995,2945,3054,-1,3003,3080,3089,3005,-1,2995,2993,2944,2945,-1,3005,3089,3065,3007,-1,3072,3070,3063,3064,-1,3070,3068,3062,3063,-1,3068,2946,2944,3062,-1,3020,3010,3009,3060,-1,3022,3023,3058,2989,-1,3024,3022,2989,3057,-1,3025,3024,3057,3055,-1,3026,3025,3055,3056,-1,2952,3027,3019,2951,-1,3081,3001,2998,3088,-1,3078,3079,3087,3086,-1,3077,3078,3086,3085,-1,3076,3077,3085,3084,-1,3075,3076,3084,3083,-1,2964,3074,3082,2962,-1,3080,3003,3001,3081,-1,3071,3073,3079,3078,-1,3069,3071,3078,3077,-1,3067,3069,3077,3076,-1,3066,3067,3076,3075,-1,2947,3053,3074,2964,-1,3070,3072,3073,3071,-1,3068,3070,3071,3069,-1,2946,3068,3069,3067,-1,2945,2946,3067,3066,-1,3061,3007,3065,-1,2988,3059,3064,3063,-1,2991,2988,3063,3062,-1,2993,2991,3062,2944,-1,2949,2996,3054,2948,-1,3060,3009,3007,3061,-1,2989,3058,3059,2988,-1,3057,2989,2990,-1,3055,3057,2990,2992,-1,3056,3055,2992,2994,-1,3053,2947,2948,3054,-1,3052,3016,3014,3038,-1,3048,3050,3037,3033,-1,3046,3048,3033,3032,-1,3044,3046,3032,3034,-1,3043,3044,3034,3035,-1,2960,3040,3036,2958,-1,3051,3018,3016,3052,-1,3047,3049,3050,3048,-1,3045,3047,3048,3046,-1,3041,3045,3046,3044,-1,3042,3041,3044,3043,-1,2962,3039,3040,2960,-1,3038,3014,3013,3030,-1,3033,3037};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_17()
		{
			int[] value = {3031,2967,-1,2956,2958,3036,2975,-1,2972,3035,3034,2970,-1,2970,3034,3032,2968,-1,2968,3032,3033,2967,-1,3029,2966,2967,3031,-1,3012,3028,3030,3013,-1,2984,2973,2971,2982,-1,2982,2971,2969,2980,-1,2980,2969,2966,2978,-1,2977,2978,2966,3029,-1,3011,3021,3028,3012,-1,3027,2952,2953,2986,-1,3025,3026,2985,2983,-1,3024,3025,2983,2981,-1,3022,3024,2981,2979,-1,3023,3022,2979,2976,-1,3010,3020,3021,3011,-1,2950,2951,3019,2997,-1,2957,3455,3454,2959,-1,2959,3454,3452,2961,-1,2961,3452,3450,2963,-1,2963,3450,3448,2965,-1,3455,2957,3445,-1,2974,2987,2954,2955,-1,3015,3016,3018,3017,-1,3006,3007,3009,3008,-1,3004,3005,3007,3006,-1,3002,3003,3005,3004,-1,3000,3001,3003,3002,-1,2999,2998,3001,3000,-1,2997,2996,2949,2950,-1,2992,2993,2995,2994,-1,2990,2991,2993,2992,-1,2989,2988,2991,2990,-1,2987,2986,2953,2954,-1,2982,2983,2985,2984,-1,2980,2981,2983,2982,-1,2978,2979,2981,2980,-1,2977,2976,2979,2978,-1,2975,2974,2955,2956,-1,2970,2971,2973,2972,-1,2968,2969,2971,2970,-1,2967,2966,2969,2968,-1,3437,2965,3448,-1,3437,2947,2964,2965,-1,2965,2964,2962,2963,-1,2963,2962,2960,2961,-1,2961,2960,2958,2959,-1,2959,2958,2956,2957,-1,2957,2956,2955,3445,-1,3445,2955,2954,3444,-1,2953,3443,3444,2954,-1,2952,3442,3443,2953,-1,3442,2952,2951,3441,-1,2950,3440,3441,2951,-1,2949,3439,3440,2950,-1,2948,3438,3439,2949,-1,2947,3437,3438,2948,-1,2945,2944,2946,-1,3092,3157,3111,3091,-1,3157,3115,3113,3111,-1,3114,3156,3139,3112,-1,3156,3093,3090,3139,-1,3094,3155,3157,3092,-1,3155,3117,3115,3157,-1,3116,3154,3156,3114,-1,3154,3095,3093,3156,-1,3096,3153,3155,3094,-1,3153,3119,3117,3155,-1,3118,3152,3154,3116,-1,3152,3097,3095,3154,-1,3098,3151,3153,3096,-1,3151,3121,3119,3153,-1,3120,3150,3152,3118,-1,3150,3099,3097,3152,-1,3100,3149,3151,3098,-1,3149,3123,3121,3151,-1,3122,3148,3150,3120,-1,3148,3101,3099,3150,-1,3102,3147,3149,3100,-1,3147,3125,3123,3149,-1,3124,3146,3148,3122,-1,3146,3103,3101,3148,-1,3104,3145,3147,3102,-1,3145,3127,3125,3147,-1,3126,3144,3146,3124,-1,3144,3105,3103,3146,-1,3106,3143,3145,3104,-1,3143,3129,3127,3145,-1,3128,3142,3144,3126,-1,3142,3107,3105,3144,-1,3108,3141,3143,3106,-1,3141,3131,3129,3143,-1,3130,3140,3142,3128,-1,3140,3109,3107,3142,-1,3110,3134,3141,3108,-1,3134,3133,3131,3141,-1,3132,3140,3130,-1,3132,3110,3109,3140,-1,3112,3139,3090,3091,-1,3135,3136,3137,3138,-1,3132,3137,3136,3110,-1,3133,3134,3135,3138,-1,3138,3137,3132,3133,-1,3134,3110,3136,3135,-1,3130,3131,3133,3132,-1,3128,3129,3131,3130,-1,3126,3127,3129,3128,-1,3124,3125,3127,3126,-1,3122,3123,3125,3124,-1,3120,3121,3123,3122,-1,3118,3119,3121,3120,-1,3116,3117,3119,3118,-1,3114,3115,3117,3116,-1,3112,3113,3115,3114,-1,3091,3111,3113,3112,-1,3108,3109,3110,-1,3106,3107,3109,3108,-1,3104,3105,3107,3106,-1,3102,3103,3105,3104,-1,3100,3101,3103,3102,-1,3098,3099,3101,3100,-1,3096,3097,3099,3098,-1,3094,3095,3097,3096,-1,3092,3093,3095,3094,-1,3091,3090,3093,3092,-1,3160,3225,3179,3159,-1,3225,3183,3181,3179,-1,3182,3224,3207,3180,-1,3224,3161,3158,3207,-1,3162,3223,3225,3160,-1,3223,3185,3183,3225,-1,3184,3222,3224,3182,-1,3222,3163,3161,3224,-1,3164,3221,3223,3162,-1,3221,3187,3185,3223,-1,3186,3220,3222,3184,-1,3220,3165,3163,3222,-1,3166,3219,3221,3164,-1,3219,3189,3187,3221,-1,3188,3218,3220,3186,-1,3218,3167,3165,3220,-1,3168,3217,3219,3166,-1,3217,3191,3189,3219,-1,3190,3216,3218,3188,-1,3216,3169,3167,3218,-1,3170,3215,3217,3168,-1,3215,3193,3191,3217,-1,3192,3214,3216,3190,-1,3214,3171,3169,3216,-1,3172,3213,3215,3170,-1,3213,3195,3193,3215,-1,3194,3212,3214,3192,-1,3212,3173,3171,3214,-1,3174,3211,3213,3172,-1,3211,3197,3195,3213,-1,3196,3210,3212,3194,-1,3210,3175,3173,3212,-1,3176,3209,3211,3174,-1,3209,3199,3197,3211,-1,3198,3208,3210,3196,-1,3208,3177,3175,3210,-1,3178,3202,3209,3176,-1,3202,3201,3199,3209,-1,3200,3208,3198,-1,3200,3178,3177,3208,-1,3180,3207,3158,3159,-1,3203,3204,3205,3206,-1,3200,3205,3204,3178,-1,3201,3202,3203,3206,-1,3206,3205,3200,3201,-1,3202,3178,3204,3203,-1,3198,3199,3201,3200,-1,3196,3197,3199,3198,-1,3194,3195,3197,3196,-1,3192,3193,3195,3194,-1,3190,3191,3193,3192,-1,3188,3189,3191,3190,-1,3186,3187,3189,3188,-1,3184,3185,3187,3186,-1,3182,3183,3185,3184,-1,3180,3181,3183,3182,-1,3159,3179,3181,3180,-1,3176,3177,3178,-1,3174,3175,3177,3176,-1,3172,3173,3175,3174,-1,3170,3171,3173,3172,-1,3168,3169,3171,3170,-1,3166,3167,3169,3168,-1,3164,3165,3167,3166,-1,3162,3163,3165,3164,-1,3160,3161,3163,3162,-1,3159,3158,3161,3160,-1,3228,3293,3247,3227,-1,3293,3251,3249,3247,-1,3250,3292,3275,3248,-1,3292,3229,3226,3275,-1,3230,3291,3293,3228,-1,3291,3253,3251,3293,-1,3252,3290,3292,3250,-1,3290,3231,3229,3292};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_18()
		{
			int[] value = {-1,3232,3289,3291,3230,-1,3289,3255,3253,3291,-1,3254,3288,3290,3252,-1,3288,3233,3231,3290,-1,3234,3287,3289,3232,-1,3287,3257,3255,3289,-1,3256,3286,3288,3254,-1,3286,3235,3233,3288,-1,3236,3285,3287,3234,-1,3285,3259,3257,3287,-1,3258,3284,3286,3256,-1,3284,3237,3235,3286,-1,3238,3283,3285,3236,-1,3283,3261,3259,3285,-1,3260,3282,3284,3258,-1,3282,3239,3237,3284,-1,3240,3281,3283,3238,-1,3281,3263,3261,3283,-1,3262,3280,3282,3260,-1,3280,3241,3239,3282,-1,3242,3279,3281,3240,-1,3279,3265,3263,3281,-1,3264,3278,3280,3262,-1,3278,3243,3241,3280,-1,3244,3277,3279,3242,-1,3277,3267,3265,3279,-1,3266,3276,3278,3264,-1,3276,3245,3243,3278,-1,3246,3270,3277,3244,-1,3270,3269,3267,3277,-1,3268,3276,3266,-1,3268,3246,3245,3276,-1,3248,3275,3226,3227,-1,3271,3272,3273,3274,-1,3268,3273,3272,3246,-1,3269,3270,3271,3274,-1,3274,3273,3268,3269,-1,3270,3246,3272,3271,-1,3266,3267,3269,3268,-1,3264,3265,3267,3266,-1,3262,3263,3265,3264,-1,3260,3261,3263,3262,-1,3258,3259,3261,3260,-1,3256,3257,3259,3258,-1,3254,3255,3257,3256,-1,3252,3253,3255,3254,-1,3250,3251,3253,3252,-1,3248,3249,3251,3250,-1,3227,3247,3249,3248,-1,3244,3245,3246,-1,3242,3243,3245,3244,-1,3240,3241,3243,3242,-1,3238,3239,3241,3240,-1,3236,3237,3239,3238,-1,3234,3235,3237,3236,-1,3232,3233,3235,3234,-1,3230,3231,3233,3232,-1,3228,3229,3231,3230,-1,3227,3226,3229,3228,-1,3296,3361,3315,3295,-1,3361,3319,3317,3315,-1,3318,3360,3343,3316,-1,3360,3297,3294,3343,-1,3298,3359,3361,3296,-1,3359,3321,3319,3361,-1,3320,3358,3360,3318,-1,3358,3299,3297,3360,-1,3300,3357,3359,3298,-1,3357,3323,3321,3359,-1,3322,3356,3358,3320,-1,3356,3301,3299,3358,-1,3302,3355,3357,3300,-1,3355,3325,3323,3357,-1,3324,3354,3356,3322,-1,3354,3303,3301,3356,-1,3304,3353,3355,3302,-1,3353,3327,3325,3355,-1,3326,3352,3354,3324,-1,3352,3305,3303,3354,-1,3306,3351,3353,3304,-1,3351,3329,3327,3353,-1,3328,3350,3352,3326,-1,3350,3307,3305,3352,-1,3308,3349,3351,3306,-1,3349,3331,3329,3351,-1,3330,3348,3350,3328,-1,3348,3309,3307,3350,-1,3310,3347,3349,3308,-1,3347,3333,3331,3349,-1,3332,3346,3348,3330,-1,3346,3311,3309,3348,-1,3312,3345,3347,3310,-1,3345,3335,3333,3347,-1,3334,3344,3346,3332,-1,3344,3313,3311,3346,-1,3314,3338,3345,3312,-1,3338,3337,3335,3345,-1,3336,3344,3334,-1,3336,3314,3313,3344,-1,3316,3343,3294,3295,-1,3339,3340,3341,3342,-1,3336,3341,3340,3314,-1,3337,3338,3339,3342,-1,3342,3341,3336,3337,-1,3338,3314,3340,3339,-1,3334,3335,3337,3336,-1,3332,3333,3335,3334,-1,3330,3331,3333,3332,-1,3328,3329,3331,3330,-1,3326,3327,3329,3328,-1,3324,3325,3327,3326,-1,3322,3323,3325,3324,-1,3320,3321,3323,3322,-1,3318,3319,3321,3320,-1,3316,3317,3319,3318,-1,3295,3315,3317,3316,-1,3312,3313,3314,-1,3310,3311,3313,3312,-1,3308,3309,3311,3310,-1,3306,3307,3309,3308,-1,3304,3305,3307,3306,-1,3302,3303,3305,3304,-1,3300,3301,3303,3302,-1,3298,3299,3301,3300,-1,3296,3297,3299,3298,-1,3295,3294,3297,3296,-1,3364,3429,3383,3363,-1,3429,3387,3385,3383,-1,3386,3428,3411,3384,-1,3428,3365,3362,3411,-1,3366,3427,3429,3364,-1,3427,3389,3387,3429,-1,3388,3426,3428,3386,-1,3426,3367,3365,3428,-1,3368,3425,3427,3366,-1,3425,3391,3389,3427,-1,3390,3424,3426,3388,-1,3424,3369,3367,3426,-1,3370,3423,3425,3368,-1,3423,3393,3391,3425,-1,3392,3422,3424,3390,-1,3422,3371,3369,3424,-1,3372,3421,3423,3370,-1,3421,3395,3393,3423,-1,3394,3420,3422,3392,-1,3420,3373,3371,3422,-1,3374,3419,3421,3372,-1,3419,3397,3395,3421,-1,3396,3418,3420,3394,-1,3418,3375,3373,3420,-1,3376,3417,3419,3374,-1,3417,3399,3397,3419,-1,3398,3416,3418,3396,-1,3416,3377,3375,3418,-1,3378,3415,3417,3376,-1,3415,3401,3399,3417,-1,3400,3414,3416,3398,-1,3414,3379,3377,3416,-1,3380,3413,3415,3378,-1,3413,3403,3401,3415,-1,3402,3412,3414,3400,-1,3412,3381,3379,3414,-1,3382,3406,3413,3380,-1,3406,3405,3403,3413,-1,3404,3412,3402,-1,3404,3382,3381,3412,-1,3384,3411,3362,3363,-1,3407,3408,3409,3410,-1,3404,3409,3408,3382,-1,3405,3406,3407,3410,-1,3410,3409,3404,3405,-1,3406,3382,3408,3407,-1,3402,3403,3405,3404,-1,3400,3401,3403,3402,-1,3398,3399,3401,3400,-1,3396,3397,3399,3398,-1,3394,3395,3397,3396,-1,3392,3393,3395,3394,-1,3390,3391,3393,3392,-1,3388,3389,3391,3390,-1,3386,3387,3389,3388,-1,3384,3385,3387,3386,-1,3363,3383,3385,3384,-1,3380,3381,3382,-1,3378,3379,3381,3380,-1,3376,3377,3379,3378,-1,3374,3375,3377,3376,-1,3372,3373,3375,3374,-1,3370,3371,3373,3372,-1,3368,3369,3371,3370,-1,3366,3367,3369,3368,-1,3364,3365,3367,3366,-1,3363,3362,3365,3364,-1,3462,3467,3466,3461,-1,3460,3465,3432,3459,-1,3464,3458,3459,3432,-1,3446,3467,3462,-1,3469,3451,3453,3470,-1,3449,3431,3468,3447,-1,3457,3433,3434,3456,-1,3458,3464,3433,3457,-1,3461};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_19()
		{
			int[] value = {3466,3465,3460,-1,3446,3447,3468,3467,-1,3431,3449,3451,3469,-1,3456,3434,3463,3435,-1,3462,3438,3437,3446,-1,3461,3439,3438,3462,-1,3460,3440,3439,3461,-1,3459,3441,3440,3460,-1,3430,3470,3453,3436,-1,3458,3442,3441,3459,-1,3457,3443,3442,3458,-1,3456,3444,3443,3457,-1,3435,3445,3444,3456,-1,3436,3455,3445,3435,-1,3453,3454,3455,3436,-1,3451,3452,3454,3453,-1,3449,3450,3452,3451,-1,3447,3448,3450,3449,-1,3446,3437,3448,3447,-1,3436,3435,3463,3430,-1,3595,3624,3696,-1,3695,3624,3623,3678,-1,3642,3677,3622,3621,-1,3676,3643,3619,3618,-1,3645,3675,3617,3616,-1,3672,3646,3614,3613,-1,3648,3671,3612,3611,-1,3670,3649,3609,3608,-1,3693,3698,3595,3696,-1,3694,3695,3678,3658,-1,3625,3660,3677,3642,-1,3674,3640,3643,3676,-1,3628,3673,3675,3645,-1,3668,3639,3646,3672,-1,3631,3667,3671,3648,-1,3655,3638,3649,3670,-1,3466,3692,3659,-1,3625,3626,3659,3660,-1,3661,3626,3640,3674,-1,3629,3662,3673,3628,-1,3663,3629,3639,3668,-1,3632,3664,3667,3631,-1,3656,3657,3690,3680,-1,3658,3659,3692,3694,-1,3698,3693,3467,3468,-1,3464,3664,3632,-1,3662,3629,3432,-1,3466,3659,3626,3465,-1,3465,3626,3661,3432,-1,3697,3469,3470,3689,-1,3698,3468,3431,3679,-1,3687,3689,3470,-1,3434,3650,3651,-1,3464,3656,3680,3433,-1,3629,3663,3464,3432,-1,3530,3531,3520,3521,3523,3525,3526,3528,-1,3679,3594,3595,3698,-1,3688,3597,3596,-1,3691,3606,3605,3634,-1,3635,3650,3680,3690,-1,3688,3596,3697,3689,-1,3635,3654,3650,-1,3684,3599,3598,3686,-1,3686,3687,3681,3682,-1,3679,3697,3596,-1,3679,3431,3469,3697,-1,3691,3634,3635,3690,-1,3637,3666,3654,3635,-1,3695,3696,3624,-1,3695,3694,3693,3696,-1,3692,3693,3694,-1,3692,3466,3467,3693,-1,3606,3691,3669,3607,-1,3691,3690,3657,3669,-1,3653,3665,3685,3683,-1,3651,3653,3683,3652,-1,3688,3689,3687,3686,-1,3597,3688,3686,3598,-1,3602,3666,3637,3603,-1,3600,3685,3665,3601,-1,3655,3656,3632,3638,-1,3464,3632,3656,-1,3687,3470,3430,3681,-1,3686,3682,3684,-1,3599,3684,3685,3600,-1,3684,3682,3683,3685,-1,3682,3681,3652,3683,-1,3681,3430,3463,3652,-1,3433,3680,3650,-1,3596,3594,3679,-1,3622,3677,3678,3623,-1,3677,3660,3658,3678,-1,3675,3673,3674,3676,-1,3617,3675,3676,3618,-1,3673,3662,3661,3674,-1,3612,3671,3672,3613,-1,3671,3667,3668,3672,-1,3607,3669,3670,3608,-1,3669,3657,3655,3670,-1,3667,3664,3663,3668,-1,3601,3665,3666,3602,-1,3665,3653,3654,3666,-1,3464,3663,3664,-1,3432,3661,3662,-1,3659,3658,3660,-1,3656,3655,3657,-1,3653,3651,3650,3654,-1,3434,3651,3652,3463,-1,3434,3433,3650,-1,3636,3634,3605,3604,-1,3637,3636,3604,3603,-1,3610,3609,3649,3647,-1,3611,3610,3647,3648,-1,3647,3649,3638,3633,-1,3648,3647,3633,3631,-1,3615,3614,3646,3644,-1,3616,3615,3644,3645,-1,3644,3646,3639,3630,-1,3645,3644,3630,3628,-1,3620,3619,3643,3641,-1,3621,3620,3641,3642,-1,3641,3643,3640,3627,-1,3642,3641,3627,3625,-1,3640,3626,3627,-1,3639,3629,3630,-1,3638,3632,3633,-1,3637,3635,3636,-1,3635,3634,3636,-1,3632,3631,3633,-1,3629,3628,3630,-1,3626,3625,3627,-1,3624,3595,3564,3593,-1,3623,3624,3593,3592,-1,3622,3623,3592,3591,-1,3621,3622,3591,3590,-1,3620,3621,3590,3589,-1,3619,3620,3589,3588,-1,3618,3619,3588,3587,-1,3617,3618,3587,3586,-1,3616,3617,3586,3585,-1,3615,3616,3585,3584,-1,3614,3615,3584,3583,-1,3613,3614,3583,3582,-1,3612,3613,3582,3581,-1,3611,3612,3581,3580,-1,3610,3611,3580,3579,-1,3609,3610,3579,3578,-1,3608,3609,3578,3577,-1,3607,3608,3577,3576,-1,3606,3607,3576,3575,-1,3605,3606,3575,3574,-1,3604,3605,3574,3573,-1,3603,3604,3573,3572,-1,3602,3603,3572,3571,-1,3601,3602,3571,3570,-1,3600,3601,3570,3569,-1,3599,3600,3569,3568,-1,3598,3599,3568,3567,-1,3597,3598,3567,3566,-1,3596,3597,3566,3565,-1,3594,3596,3565,3563,-1,3595,3594,3563,3564,-1,3593,3564,3479,3477,-1,3592,3593,3477,3475,-1,3591,3592,3475,3471,-1,3590,3591,3471,3472,-1,3589,3590,3472,3485,-1,3588,3589,3485,3493,-1,3587,3588,3493,3491,-1,3586,3587,3491,3487,-1,3585,3586,3487,3488,-1,3584,3585,3488,3500,-1,3583,3584,3500,3524,-1,3582,3583,3524,3522,-1,3581,3582,3522,3518,-1,3580,3581,3518,3519,-1,3579,3580,3519,3510,-1,3578,3579,3510,3508,-1,3577,3578,3508,3506,-1,3576,3577,3506,3502,-1,3575,3576,3502,3503,-1,3574,3575,3503,3516,-1,3573,3574,3516,3557,-1,3572,3573,3557,3555,-1,3571,3572,3555,3553,-1,3571,3553,3570,-1,3569,3570,3553,3549,-1,3568,3569,3549,3550,-1,3567,3568,3550,3561,-1,3566,3567,3561,3532,-1,3565,3566,3532,3533,-1,3563,3565,3533,3547,-1,3564,3563,3547,3479,-1,3515,3517,3504,3505,3507,3509,3511,3513,-1,3499,3501,3489,3490,3492,3494,3495,3497,-1,3484,3486,3473,3474,3476,3478,3480,3482,-1,3537,3539,3540,3541,3542,3543,3544,3545,3546,3548,3534,3535,-1,3560,3562,3551,3552,3554,3556,3558,3559,-1,3496,3485,3483,-1,3527,3498,3496,-1,3512,3510,3529,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_20()
		{
			int[] value = {3514,3538,3557,3516,-1,3532,3561,3536,-1,3481,3479,3547,-1,3527,3500,3498,-1,3561,3550,3551,3562,-1,3536,3561,3562,3560,-1,3538,3536,3560,3559,-1,3557,3538,3559,3558,-1,3555,3557,3558,3556,-1,3553,3555,3556,3554,-1,3549,3553,3554,3552,-1,3550,3549,3552,3551,-1,3547,3533,3534,3548,-1,3481,3547,3548,3546,-1,3483,3481,3546,3545,-1,3496,3483,3545,3544,-1,3527,3496,3544,3543,-1,3529,3527,3543,3542,-1,3512,3529,3542,3541,-1,3514,3512,3541,3540,-1,3538,3514,3540,3539,-1,3536,3538,3539,3537,-1,3532,3536,3537,3535,-1,3533,3532,3535,3534,-1,3510,3519,3520,3531,-1,3529,3510,3531,3530,-1,3527,3529,3530,3528,-1,3500,3527,3528,3526,-1,3524,3500,3526,3525,-1,3522,3524,3525,3523,-1,3518,3522,3523,3521,-1,3519,3518,3521,3520,-1,3516,3503,3504,3517,-1,3514,3516,3517,3515,-1,3512,3514,3515,3513,-1,3510,3512,3513,3511,-1,3508,3510,3511,3509,-1,3506,3508,3509,3507,-1,3502,3506,3507,3505,-1,3503,3502,3505,3504,-1,3500,3488,3489,3501,-1,3498,3500,3501,3499,-1,3496,3498,3499,3497,-1,3485,3496,3497,3495,-1,3493,3485,3495,3494,-1,3491,3493,3494,3492,-1,3487,3491,3492,3490,-1,3488,3487,3490,3489,-1,3485,3472,3473,3486,-1,3483,3485,3486,3484,-1,3481,3483,3484,3482,-1,3479,3481,3482,3480,-1,3477,3479,3480,3478,-1,3475,3477,3478,3476,-1,3471,3475,3476,3474,-1,3472,3471,3474,3473,-1,3781,3713,3718,3778,-1,3776,3716,3782,3779,-1,3717,3714,3767,3721,-1,3720,3768,3773,3770,-1,3777,3719,3736,-1,3715,3774,3724,3750,-1,3775,3780,3737,-1,3703,3727,3757,-1,3771,3740,3760,-1,3730,3729,3758,3761,-1,3755,3728,3731,3762,-1,3766,3712,3745,3742,-1,3732,3765,3743,-1,3744,3734,3752,3747,-1,3764,3754,3763,-1,3706,3746,3753,3705,-1,6690,3738,6694,6830,-1,3741,3739,3769,3772,-1,3713,3781,3700,-1,3699,3782,3716,-1,3714,3717,3718,3713,-1,3783,3767,3714,-1,3721,3767,3768,3720,-1,3717,3721,3722,3719,-1,3715,3750,3786,-1,3719,3777,3778,3718,-1,3779,3782,3781,3778,-1,3716,3776,3774,3715,-1,3776,3779,3780,3775,-1,3725,3751,3750,3724,-1,3724,3774,3775,3726,-1,3737,3780,3777,3736,-1,3736,3756,3757,3727,-1,3723,3759,3756,3722,-1,3759,3760,3761,3758,-1,3703,3757,3758,3729,-1,3729,3730,3731,3728,-1,3730,3761,6832,6411,-1,3712,3766,6838,6408,-1,6416,6839,3765,3732,-1,6406,6417,3732,3711,-1,3734,3744,3745,3733,-1,6409,6433,3733,3712,-1,3742,3745,3709,-1,3743,3765,3766,3742,-1,3735,3748,3743,-1,3711,3748,3749,3710,-1,3728,3755,3702,-1,3704,3754,3749,-1,6432,6765,3752,3734,-1,3705,3753,6766,6025,-1,3707,3746,3706,-1,3744,3747,3708,-1,3747,3752,3753,3746,-1,3741,3772,3701,-1,3787,3773,3768,-1,3770,3773,3772,3769,-1,3720,3770,3771,3723,-1,3739,3741,6694,3738,-1,6691,6693,3738,6690,-1,6693,6833,3760,3740,-1,3740,3771,3769,3739,-1,3755,3762,3763,3754,-1,6410,6835,3762,3731,-1,6834,6836,3764,3763,-1,3710,3764,6837,6407,-1,3764,3710,3749,3754,-1,3743,3748,3711,3732,-1,3712,3733,3745,-1,3737,3726,3775,-1,3719,3722,3756,3736,-1,3760,3759,3723,3771,-1,3700,3781,3782,3699,-1,3778,3777,3780,3779,-1,3775,3774,3776,-1,3701,3772,3773,3787,-1,3770,3769,3771,-1,3767,3783,3787,3768,-1,6839,6838,3766,3765,-1,3764,6836,6837,-1,6835,6834,3763,3762,-1,6833,6832,3761,3760,-1,3757,3756,3759,3758,-1,3704,3702,3755,3754,-1,3752,6765,6766,3753,-1,3786,3750,3751,3785,-1,3748,3735,3704,3749,-1,3746,3707,3708,3747,-1,6025,8264,3784,3705,-1,3708,3709,3745,3744,-1,3742,3709,3735,3743,-1,3701,6852,6694,3741,-1,3739,3738,6693,3740,-1,3707,3706,3870,3788,-1,3737,3736,3727,-1,6433,6432,3734,3733,-1,6416,3732,6417,-1,3731,3730,6411,6410,-1,3702,3703,3729,3728,-1,3725,3724,3726,-1,3721,3720,3723,3722,-1,3718,3717,3719,-1,3716,3715,3786,3699,-1,3700,3783,3714,3713,-1,3712,6408,6409,-1,6407,6406,3711,3710,-1,3784,3870,3706,3705,-1,3865,3805,3800,3868,-1,3866,3869,3803,3863,-1,3808,3854,3801,3804,-1,3857,3860,3855,3807,-1,3823,3806,3864,-1,3837,3811,3861,3802,-1,3824,3867,3862,-1,3844,3814,3790,-1,3847,3827,3858,-1,3848,3845,3816,3817,-1,3849,3818,3815,3842,-1,3829,3832,3799,3853,-1,3830,3852,3819,-1,3834,3839,3821,3831,-1,3850,3841,3851,-1,3792,3840,3833,3793,-1,8224,8088,3825,8084,-1,3859,3856,3826,3828,-1,3700,3868,3800,-1,3803,3869,3699,-1,3800,3805,3804,3801,-1,3801,3854,3783,-1,3807,3855,3854,3808,-1,3806,3809,3808,3804,-1,3786,3837,3802,-1,3805,3865,3864,3806,-1,3865,3868,3869,3866,-1,3802,3861,3863,3803,-1,3862,3867,3866,3863,-1,3811,3837,3838,3812,-1,3813,3862,3861,3811,-1,3823,3864,3867,3824,-1,3814,3844,3843,3823,-1,3809,3843,3846,3810,-1,3845,3848,3847,3846,-1,3816,3845,3844,3790,-1,3815,3818,3817,3816,-1,7805,8226,3848,3817,-1,7802,8232,3853,3799,-1,3819,3852,8233,7810,-1,3798,3819,7811,7800,-1,3820,3832,3831,3821,-1,3799,3820,7827,7803,-1,3796,3832,3829,-1,3829,3853,3852,3830,-1,3830,3835};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_21()
		{
			int[] value = {3822,-1,3797,3836,3835,3798,-1,3789,3842,3815,-1,3836,3841,3791,-1,3821,3839,8159,7826,-1,7419,8160,3840,3792,-1,3793,3833,3794,-1,3795,3834,3831,-1,3833,3840,3839,3834,-1,3701,3859,3828,-1,3855,3860,3787,-1,3856,3859,3860,3857,-1,3810,3858,3857,3807,-1,3825,8088,3828,3826,-1,8084,3825,8087,8085,-1,3827,3847,8227,8087,-1,3826,3856,3858,3827,-1,3841,3850,3849,3842,-1,3818,3849,8229,7804,-1,3850,3851,8230,8228,-1,7801,8231,3851,3797,-1,3841,3836,3797,3851,-1,3819,3798,3835,3830,-1,3832,3820,3799,-1,3862,3813,3824,-1,3823,3843,3809,3806,-1,3858,3810,3846,3847,-1,3699,3869,3868,3700,-1,3866,3867,3864,3865,-1,3863,3861,3862,-1,3787,3860,3859,3701,-1,3858,3856,3857,-1,3855,3787,3783,3854,-1,3852,3853,8232,8233,-1,8231,8230,3851,-1,3849,3850,8228,8229,-1,3847,3848,8226,8227,-1,3845,3846,3843,3844,-1,3841,3842,3789,3791,-1,3840,8160,8159,3839,-1,3785,3838,3837,3786,-1,3836,3791,3822,3835,-1,3834,3795,3794,3833,-1,3792,3784,8264,7419,-1,3831,3832,3796,3795,-1,3830,3822,3796,3829,-1,3828,8088,6852,3701,-1,3827,8087,3825,3826,-1,3788,3870,3793,3794,-1,3814,3823,3824,-1,3820,3821,7826,7827,-1,7811,3819,7810,-1,7804,7805,3817,3818,-1,3815,3816,3790,3789,-1,3813,3811,3812,-1,3809,3810,3807,3808,-1,3806,3804,3805,-1,3699,3786,3802,3803,-1,3800,3801,3783,3700,-1,7803,7802,3799,-1,3797,3798,7800,7801,-1,3792,3793,3870,3784,-1,3962,3964,3963,-1,3952,3951,3886,3953,-1,3995,4021,4023,3883,-1,4079,3968,4081,-1,3881,4080,4082,3966,-1,4091,3877,3997,4093,-1,4094,3995,3883,4092,-1,4068,3949,10402,10869,-1,4066,3886,3951,4067,-1,3897,4098,3898,4097,3899,3900,10460,10461,10397,10451,10399,10879,10429,10878,10430,10810,10574,10809,10400,10435,10864,4838,3958,4017,3896,4016,-1,3874,3911,4074,4076,-1,4075,4073,3913,3888,-1,3888,3913,3914,3875,-1,3911,3921,4072,4074,-1,4073,4071,3923,3913,-1,4091,4089,3927,3877,-1,4023,4025,3931,3883,-1,3883,3931,4090,4092,-1,4089,4087,3933,3927,-1,4025,4026,3938,3931,-1,3931,3938,4088,4090,-1,3914,3913,3923,3924,-1,3875,3914,4053,4052,-1,4052,4051,3935,3936,3875,-1,3921,3940,4070,4072,-1,4071,4069,3942,3923,-1,3923,3942,3943,3924,-1,3924,3943,3944,3925,-1,3940,3949,4068,4070,-1,4069,4067,3951,3942,-1,3942,3951,3952,3943,-1,3943,3952,3953,3944,-1,3962,4033,4031,3964,-1,4034,3881,3966,4032,-1,3935,3962,3963,3936,-1,4011,4010,4009,3960,-1,4026,4028,4007,3938,-1,3938,4007,4086,4088,-1,4087,4085,4005,3933,-1,4016,4019,3974,3897,-1,3897,3974,4096,4098,-1,4097,4095,3976,3899,-1,3968,3984,4083,4081,-1,4082,4084,3986,3966,-1,3966,3986,4030,4032,-1,4031,4029,3988,3964,-1,3964,3988,3989,3963,-1,3963,3989,3990,3936,-1,3936,3990,3970,3875,-1,4019,4021,3995,3974,-1,3974,3995,4094,4096,-1,4095,4093,3997,3976,-1,3984,4005,4085,4083,-1,4084,4086,4007,3986,-1,3986,4007,4028,4030,-1,4029,4027,4009,3988,-1,3988,4009,4010,3989,-1,3989,4010,4011,3990,-1,3990,4011,3991,3970,-1,3915,4051,4052,-1,3915,4052,4053,-1,3915,4053,3916,-1,3904,4077,4078,-1,3896,3973,4019,4016,-1,3973,3994,4021,4019,-1,3994,3876,4023,4021,-1,4022,4024,3930,3876,-1,3876,3930,4025,4023,-1,3937,4008,4028,4026,-1,4030,4028,4008,3987,-1,3987,4008,4027,4029,-1,4032,4030,3987,3965,-1,3965,3987,4029,4031,-1,4031,4033,3961,3965,-1,3965,3961,4034,4032,-1,4068,10869,3885,3950,-1,3950,3885,4066,4067,-1,4070,4068,3950,3941,-1,3941,3950,4067,4069,-1,4072,4070,3941,3922,-1,3922,3941,4069,4071,-1,4074,4072,3922,3912,-1,3912,3922,4071,4073,-1,4076,4074,3912,3887,-1,3887,3912,4073,4075,-1,4079,4081,3967,3882,-1,3882,3967,4082,4080,-1,4081,4083,3985,3967,-1,3967,3985,4084,4082,-1,4083,4085,4006,3985,-1,3985,4006,4086,4084,-1,4088,4086,4006,3932,-1,3932,4006,4085,4087,-1,4090,4088,3932,3926,-1,3926,3932,4087,4089,-1,4092,4090,3926,3884,-1,3884,3926,4089,4091,-1,4091,4093,3996,3884,-1,3884,3996,4094,4092,-1,4096,4094,3996,3975,-1,3975,3996,4093,4095,-1,4098,4096,3975,3898,-1,3898,3975,4095,4097,-1,4064,4967,3879,-1,4967,4065,3879,-1,4054,3871,3956,4056,-1,10452,10577,10576,3969,-1,3871,4047,4045,3956,-1,4047,3871,10404,4049,-1,3968,4079,10884,10398,-1,10851,10404,3871,4054,-1,4049,10404,10567,10815,-1,10437,10561,3953,3886,-1,4967,4064,3873,3901,-1,4036,3901,3873,4037,-1,3888,3875,4838,3905,-1,3992,3991,3959,3993,-1,3889,4000,3999,3998,-1,4013,4012,3880,10613,-1,4055,4993,10569,10852,-1,4057,3954,4993,4055,-1,3880,10794,10796,10613,-1,4033,3962,10575,10799,-1,10433,10885,4080,3881,-1,4078,4099,3874,4076,-1,4075,3888,3905,4077,-1,10867,10437,3886,4066,-1,3969,3968,10398,10452,-1,3998,3997,3877,3889,-1,3895,3910,3911,3874,-1,3892,3949,3948,-1,3890,3949,3892,-1,10456,10402,3949,3890,-1,3890,4050,10816,10456,-1,3892,4048,4050,3890,-1,3948,4046,4048,3892,-1,4038,4040,3910,3895,-1,5006,3906,4063,4065,-1,4064,4062,3908,3873,-1,3873};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_22()
		{
			int[] value = {3908,4039,4037,-1,10832,10530,3935,4051,-1,3906,5011,4061,4063,-1,4062,4060,3918,3908,-1,3908,3918,4041,4039,-1,4040,4042,3920,3910,-1,3910,3920,3921,3911,-1,4967,5006,4065,-1,3877,3927,3928,3889,-1,3889,3928,4001,4000,-1,4012,4015,3929,3880,-1,3880,3929,10652,10651,10795,10794,-1,3927,3933,3934,3928,-1,3928,3934,4002,4001,-1,4015,4014,10635,3929,-1,3929,10635,10634,10653,10652,-1,3895,3903,4035,4038,-1,3874,4099,3903,3895,-1,3920,3939,3940,3921,-1,3925,3944,10553,10513,-1,5011,5028,4059,4061,-1,4060,4058,3946,3918,-1,3918,3946,4043,4041,-1,4042,4044,3939,3920,-1,3939,3948,3949,3940,-1,3944,3953,10561,10553,-1,5028,3954,4057,4059,-1,4058,4056,3956,3946,-1,3946,3956,4045,4043,-1,4044,4046,3948,3939,-1,3959,4022,4020,3993,-1,10800,10433,3881,4034,-1,10530,10575,3962,3935,-1,3933,4005,4004,3934,-1,3934,4004,4003,4002,-1,3875,3970,3971,4838,-1,4838,3971,3972,3958,-1,3958,3972,4018,4017,-1,3899,3976,3977,3900,-1,3900,3977,3978,10460,-1,10460,3978,3979,10419,-1,10419,3979,3980,10514,-1,10514,3980,3981,10525,-1,10525,3981,3982,10576,-1,10576,3982,3983,3969,-1,3969,3983,3984,3968,-1,3970,3991,3992,3971,-1,3971,3992,3993,3972,-1,3972,3993,4020,4018,-1,3976,3997,3998,3977,-1,3977,3998,3999,3978,-1,3978,3999,4000,3979,-1,3979,4000,4001,3980,-1,3980,4001,4002,3981,-1,3981,4002,4003,3982,-1,3982,4003,4004,3983,-1,3983,4004,4005,3984,-1,10585,4012,4013,10586,-1,10586,4013,10613,10587,-1,10610,10635,4014,10611,-1,10611,4014,4015,10612,-1,10612,4015,4012,10585,-1,4017,4018,3973,3896,-1,4018,4020,3994,3973,-1,4020,4022,3876,3994,-1,4033,10799,10571,3961,-1,3961,10571,10800,4034,-1,4036,4037,3894,3902,-1,3902,3894,4038,4035,-1,4037,4039,3909,3894,-1,3894,3909,4040,4038,-1,4039,4041,3919,3909,-1,3909,3919,4042,4040,-1,4041,4043,3947,3919,-1,3919,3947,4044,4042,-1,4043,4045,3957,3947,-1,3947,3957,4046,4044,-1,4045,4047,3893,3957,-1,3957,3893,4048,4046,-1,4047,4049,3891,3893,-1,3893,3891,4050,4048,-1,4049,10815,10457,3891,-1,3891,10457,10816,4050,-1,10832,4051,3915,10505,-1,10505,3915,3916,10831,-1,10851,4054,3878,10426,-1,10426,3878,4055,10852,-1,4054,4056,3955,3878,-1,3878,3955,4057,4055,-1,4059,4057,3955,3945,-1,3945,3955,4056,4058,-1,4061,4059,3945,3917,-1,3917,3945,4058,4060,-1,4063,4061,3917,3907,-1,3907,3917,4060,4062,-1,4065,4063,3907,3879,-1,3879,3907,4062,4064,-1,10869,10868,10438,3885,-1,3885,10438,10867,4066,-1,4078,4076,3887,3904,-1,3904,3887,4075,4077,-1,10884,4079,3882,10434,-1,10434,3882,4080,10885,-1,10401,10458,10822,10459,10821,10403,10848,10405,10847,10406,3872,4967,3901,4036,3902,4035,3903,4099,-1,4103,4102,4101,-1,4109,4108,4107,-1,4114,4113,4112,-1,4116,4115,433,-1,4120,4119,4118,4117,-1,435,434,4122,4121,-1,4104,4119,4123,-1,4120,4125,4101,4124,-1,434,432,4122,-1,4122,432,4126,-1,4122,4126,4127,4121,-1,4126,432,4128,-1,4126,4128,4129,4127,-1,4128,432,4104,4123,-1,4128,4123,4124,4129,-1,4119,4104,4118,-1,4120,4124,4123,4119,-1,4118,4104,4105,4130,-1,4118,4130,4131,4117,-1,4130,4105,4132,-1,4130,4132,4133,4131,-1,4132,4105,4106,4134,-1,4132,4134,4135,4133,-1,4134,4106,4136,-1,4134,4136,4137,4135,-1,4139,4138,498,499,-1,4141,4140,4138,4139,-1,4129,4143,4142,4127,-1,4148,4147,4146,4145,-1,4115,4149,510,433,-1,512,511,4151,4150,-1,4140,4141,4152,-1,4155,4152,4154,4153,-1,4157,4156,4116,-1,4149,4115,4159,4158,-1,4156,4157,4162,4161,-1,4158,4159,4163,4164,-1,4167,4166,4165,-1,509,538,4165,4168,-1,4144,4110,4166,4167,-1,4169,4170,4171,-1,4174,4173,4172,-1,4178,4177,4176,4175,-1,4182,4181,4180,4179,-1,4180,4103,4125,4179,-1,4117,4183,4125,4120,-1,4135,4184,4133,-1,4133,4184,4185,4131,-1,4131,4185,4183,4117,-1,4137,4186,4184,4135,-1,4190,4189,4188,4187,-1,4146,4191,4192,4145,-1,4121,4193,559,435,-1,568,569,4195,4194,-1,4196,566,567,-1,4189,4190,4196,4197,-1,4177,4178,4194,4195,-1,4127,4142,4193,4121,-1,4124,4101,4143,4129,-1,4199,421,577,4198,-1,4200,5161,4199,4198,-1,4201,4100,5161,4200,-1,4100,4201,4153,-1,4101,4102,4202,4143,-1,4204,4193,4142,4203,-1,4195,4202,4102,4177,-1,4178,4189,4197,4194,-1,567,580,4197,4196,-1,4197,580,568,4194,-1,569,4203,4202,4195,-1,569,553,4204,4203,-1,568,580,581,552,-1,4193,4204,550,559,-1,4204,553,550,-1,4192,4205,4206,4145,-1,4145,4206,4207,4148,-1,541,601,4208,4147,-1,583,566,4196,4209,-1,4148,4207,595,540,-1,4146,4147,4208,4210,-1,4210,4208,4209,4107,-1,4146,4210,4211,4191,-1,4108,4211,4210,4107,-1,4187,4109,4107,4190,-1,4107,4209,4196,4190,-1,4214,4184,4186,4213,-1,4214,4185,4184,-1,4179,4214,4213,4182,-1,4125,4183,4214,4179,-1,4102,4103,4180,-1,4178,4175,4188,4189,-1,4212,4102,4180,4181,-1,4102,4212,4176,4177,-1,4217,4216,4215,-1,4215,4216,4219,4218,-1,4206,4205,4220,4221,-1,4221,4220,4173,4174,-1,4174,4172,4218};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_23()
		{
			int[] value = {4219,-1,4222,4207,4206,4221,-1,4219,4224,4223,4174,-1,4222,602,594,595,-1,4222,595,4207,-1,4228,4227,4111,4226,-1,4228,4165,4227,-1,4166,4110,4111,4227,-1,4216,4217,4144,4167,-1,4224,4229,625,624,-1,4224,624,604,4223,-1,4228,4226,4225,4230,-1,4230,4168,4165,4228,-1,4166,4227,4165,-1,4230,4225,4169,4171,-1,4165,538,625,4229,-1,4165,4229,4216,4167,-1,4233,4231,4232,4114,-1,4112,4234,4233,4114,-1,4112,4113,4168,4171,-1,4239,4160,4235,4238,-1,4158,4164,4160,4239,-1,4156,4161,4163,4159,-1,4116,4156,4159,4115,-1,4116,433,626,4240,-1,4116,4240,4232,4157,-1,4152,4155,4241,4140,-1,4198,577,644,4242,-1,4200,4244,4243,4201,-1,4200,4198,4242,4244,-1,4153,4243,4155,-1,4152,4237,4236,4154,-1,4237,4152,4141,4245,-1,4245,4141,4139,4246,-1,4246,4139,499,645,-1,4149,4158,4239,4151,-1,4149,4151,511,510,-1,4151,4239,4238,4150,-1,4247,516,512,4150,-1,4246,645,515,4248,-1,4248,515,516,4247,-1,4238,4245,4246,4248,-1,4238,4235,4237,4245,-1,4247,4150,4238,-1,4216,4229,4224,4219,-1,4230,4171,4168,-1,4248,4247,4238,-1,4223,604,602,4222,-1,4222,4221,4174,4223,-1,4234,4112,4171,4170,-1,4232,4231,4162,4157,-1,4232,4240,4113,4114,-1,508,509,4168,4113,-1,4240,626,508,4113,-1,4202,4203,4142,4143,-1,4201,4243,4153,-1,644,655,4249,4242,-1,4244,4242,4249,4241,-1,4138,4140,4241,4249,-1,4138,4249,655,498,-1,4155,4243,4244,4241,-1,540,541,4147,4148,-1,4209,4208,601,583,-1,4125,4103,4101,-1,4214,4183,4185,-1,4258,4259,4260,4261,-1,4259,4263,4264,4260,-1,4265,4266,4267,4268,-1,4268,4260,4264,4265,-1,4264,4269,4270,4265,-1,4265,4270,4271,4266,-1,4272,4273,5665,5666,-1,4274,4275,4276,-1,4277,4278,4273,4272,-1,4256,4262,4280,4281,-1,4281,4280,4263,4259,-1,4257,4256,4281,4282,-1,4282,4281,4259,4258,-1,4283,4284,4285,-1,4286,4287,4288,4289,-1,4289,4288,4290,4291,-1,4285,4291,4290,4283,-1,4285,4292,4291,-1,4295,4296,4251,4250,-1,4294,4293,4297,-1,4298,4287,4286,4296,4295,-1,4299,4300,4284,4301,-1,4302,4303,4304,4305,-1,4304,4303,4306,4307,-1,4308,4309,5700,5701,-1,4312,4313,4314,4315,-1,4316,4317,4318,-1,4253,4252,4317,4316,-1,4276,4319,4255,4257,-1,4258,4261,4320,4275,-1,4321,4295,4250,4254,-1,4322,4298,4295,4321,-1,4323,4299,4301,4324,-1,4327,4317,4252,4326,-1,4328,4314,4313,4329,-1,4329,4330,4331,4328,-1,4326,4332,4333,4327,-1,4335,4299,4323,4336,-1,4337,4315,4314,4338,-1,4338,4314,4328,4339,-1,4339,4328,4331,4340,-1,4341,4305,4304,4342,-1,4342,4304,4307,4343,-1,4344,4308,5701,5735,-1,4283,4345,4301,4284,-1,4301,4345,4346,4324,-1,4312,4347,4348,4313,-1,4313,4348,4349,4329,-1,4329,4349,4350,4330,-1,4302,4351,4352,4303,-1,4303,4352,4353,4306,-1,4309,4354,5746,5700,-1,4283,4290,4355,4345,-1,4345,4355,4356,4346,-1,4347,4357,4358,4348,-1,4348,4358,4359,4349,-1,4349,4359,4360,4350,-1,4351,4361,4362,4352,-1,4352,4362,4363,4353,-1,4354,4272,5666,5746,-1,4267,4266,4365,4364,-1,4291,4292,4364,4365,-1,4325,4366,4367,4334,-1,4255,4319,4366,4325,-1,4266,4271,4368,4365,-1,4365,4368,4289,4291,-1,4290,4288,4369,4355,-1,4355,4369,4370,4356,-1,4357,4371,4372,4358,-1,4358,4372,4373,4359,-1,4359,4373,4374,4360,-1,4361,4375,4376,4362,-1,4362,4376,4377,4363,-1,4271,4251,4296,4368,-1,4368,4296,4286,4289,-1,4288,4287,4298,4369,-1,4369,4298,4322,4370,-1,4371,4318,4317,4372,-1,4372,4317,4327,4373,-1,4373,4327,4333,4374,-1,4375,4297,4293,4376,-1,4294,4297,4380,4379,-1,4374,4333,4380,4381,-1,4381,4380,4297,4375,-1,4340,4331,4382,4383,-1,4383,4382,4305,4341,-1,4302,4305,4382,4384,-1,4384,4382,4331,4330,-1,4330,4350,4385,4384,-1,4384,4385,4351,4302,-1,4350,4360,4386,4385,-1,4385,4386,4361,4351,-1,4360,4374,4381,4386,-1,4386,4381,4375,4361,-1,4363,4377,4278,4277,-1,4353,4363,4277,4387,-1,4387,4277,4272,4354,-1,4306,4353,4387,4388,-1,4388,4387,4354,4309,-1,4307,4306,4388,4389,-1,4389,4388,4309,4308,-1,4343,4307,4389,4390,-1,4390,4389,4308,4344,-1,4356,4370,4391,4392,-1,4392,4391,4371,4357,-1,4346,4356,4392,4393,-1,4393,4392,4357,4347,-1,4324,4346,4393,4394,-1,4394,4393,4347,4312,-1,4312,4315,4395,4394,-1,4394,4395,4323,4324,-1,4336,4323,4395,4396,-1,4396,4395,4315,4337,-1,4370,4322,4397,4391,-1,4391,4397,4318,4371,-1,4316,4318,4397,4398,-1,4398,4397,4322,4321,-1,4253,4316,4398,4279,-1,4279,4398,4321,4254,-1,4276,4257,4282,4274,-1,4274,4282,4258,4275,-1,4300,4299,4335,-1,4260,4268,4261,-1,4267,4364,4292,4285,4284,4300,4335,4336,4396,4337,4338,4339,4340,4383,4341,4342,4343,4390,4344,5735,5756,5672,4310,4311,4378,4367,4366,4319,4276,4275,4320,4261,4268,-1,4399,4400,4401,4402,-1,4403,4404,4405,4406,-1,4407,4408,4409,4410,-1,4411,4412,4413,4414,-1,4415,4416,4412,4411,-1,4417,4418,4416,4415,-1,4419,4420,4418,4417,-1,4421,4422,4420,4419,-1,4423,4424,4422,4421,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_24()
		{
			int[] value = {4425,4426,4424,4423,-1,4427,4428,4426,4425,-1,4431,4432,4430,4429,-1,4433,4434,4432,4431,-1,4435,4436,4434,4433,-1,4437,4438,4436,4435,-1,4439,4440,4438,4437,-1,4441,4442,4440,4439,-1,4414,4413,4442,4441,-1,4412,4443,4444,4413,-1,4416,4445,4443,4412,-1,4418,4446,4445,4416,-1,4420,4447,4446,4418,-1,4422,4448,4447,4420,-1,4424,4399,4448,4422,-1,4426,4400,4399,4424,-1,4428,4449,4400,4426,-1,4432,4401,4450,4430,-1,4434,4402,4401,4432,-1,4436,4451,4402,4434,-1,4438,4452,4451,4436,-1,4440,4453,4452,4438,-1,4442,4454,4453,4440,-1,4413,4444,4454,4442,-1,4400,4449,4450,4401,-1,4451,4452,4447,4448,-1,4448,4399,4402,4451,-1,4453,4454,4445,4446,-1,4446,4447,4452,4453,-1,4454,4444,4443,4445,-1,4455,4456,4404,4403,-1,4456,4455,4410,4409,-1,4457,4458,4459,4460,-1,4458,4457,4406,4405,-1,4460,4459,4461,4462,-1,4414,4462,4461,4411,-1,4441,4460,4462,4414,-1,4439,4457,4460,4441,-1,4437,4406,4457,4439,-1,4435,4403,4406,4437,-1,4433,4455,4403,4435,-1,4431,4410,4455,4433,-1,4429,4407,4410,4431,-1,4425,4409,4408,4427,-1,4423,4456,4409,4425,-1,4421,4404,4456,4423,-1,4419,4405,4404,4421,-1,4417,4458,4405,4419,-1,4415,4459,4458,4417,-1,4411,4461,4459,4415,-1,4463,4464,4465,4466,-1,4466,4465,4467,4468,-1,4468,4467,4469,4470,-1,4470,4469,4471,4472,-1,4472,4471,4473,4474,-1,4475,4476,4477,4478,-1,4464,4479,4480,4465,-1,4465,4480,4481,4467,-1,4467,4481,4482,4469,-1,4469,4482,4483,4471,-1,4471,4483,4484,4473,-1,4476,4485,4486,4477,-1,4479,4487,4488,4480,-1,4480,4488,4489,4481,-1,4481,4489,4490,4482,-1,4482,4490,4491,4483,-1,4483,4491,4492,4484,-1,4485,4493,4494,4486,-1,4487,4495,4496,4488,-1,4488,4496,4497,4489,-1,4489,4497,4498,4490,-1,4490,4498,4499,4491,-1,4491,4499,4500,4492,-1,4493,4501,4502,4494,-1,4495,4503,4504,4496,-1,4496,4504,4505,4497,-1,4497,4505,4506,4498,-1,4498,4506,4507,4499,-1,4499,4507,4508,4500,-1,4501,4509,4510,4502,-1,4503,4511,4512,4504,-1,4504,4512,4513,4505,-1,4505,4513,4514,4506,-1,4506,4514,4515,4507,-1,4507,4515,4516,4508,-1,4509,4517,4518,4510,-1,4519,4520,4521,4522,-1,4503,4524,4523,4511,-1,4495,4525,4524,4503,-1,4487,4526,4525,4495,-1,4479,4527,4526,4487,-1,4464,4528,4527,4479,-1,4463,4529,4528,4464,-1,4521,4530,4531,4522,-1,4532,4533,4534,4535,-1,4536,4537,4533,4532,-1,4538,4539,4537,4536,-1,4540,4541,4539,4538,-1,4542,4543,4541,4540,-1,4544,4545,4543,4542,-1,4525,4547,4546,4524,-1,4526,4548,4547,4525,-1,4527,4549,4548,4526,-1,4528,4550,4549,4527,-1,4529,4551,4550,4528,-1,4530,4552,4553,4531,-1,4533,4554,4555,4534,-1,4537,4556,4554,4533,-1,4539,4557,4556,4537,-1,4541,4558,4557,4539,-1,4543,4559,4558,4541,-1,4545,4560,4559,4543,-1,4551,4561,4562,4550,-1,4552,4563,4564,4553,-1,4554,4565,4566,4555,-1,4556,4567,4565,4554,-1,4557,4568,4567,4556,-1,4558,4569,4568,4557,-1,4559,4570,4569,4558,-1,4560,4571,4570,4559,-1,4547,4574,4573,4546,-1,4548,4575,4574,4547,-1,4549,4576,4575,4548,-1,4550,4562,4576,4549,-1,4561,4478,4477,4562,-1,4563,4577,4578,4564,-1,4565,4476,4475,4566,-1,4567,4485,4476,4565,-1,4568,4493,4485,4567,-1,4569,4501,4493,4568,-1,4570,4509,4501,4569,-1,4571,4517,4509,4570,-1,4573,4510,4518,4572,-1,4574,4502,4510,4573,-1,4575,4494,4502,4574,-1,4576,4486,4494,4575,-1,4562,4477,4486,4576,-1,4519,4579,4580,4520,-1,4472,4520,4580,4470,-1,4474,4521,4520,4472,-1,4534,4530,4521,4535,-1,4555,4552,4530,4534,-1,4566,4563,4552,4555,-1,4475,4577,4563,4566,-1,4478,4578,4577,4475,-1,4561,4564,4578,4478,-1,4551,4553,4564,4561,-1,4529,4531,4553,4551,-1,4463,4522,4531,4529,-1,4466,4519,4522,4463,-1,4468,4579,4519,4466,-1,4470,4580,4579,4468,-1,4581,4582,4484,4492,-1,4538,4536,4582,4581,-1,4582,4583,4473,4484,-1,4536,4532,4583,4582,-1,4583,4584,4474,4473,-1,4532,4535,4584,4583,-1,4585,4581,4492,4500,-1,4540,4538,4581,4585,-1,4586,4585,4500,4508,-1,4542,4540,4585,4586,-1,4587,4586,4508,4516,-1,4544,4542,4586,4587,-1,4584,4521,4474,-1,4584,4535,4521,-1,4588,4589,4590,4591,-1,4589,4588,4592,-1,4593,4591,4590,-1,4594,4595,4591,4593,-1,4596,4597,4595,4594,-1,4598,4599,4597,4596,-1,4600,4601,4599,4598,-1,4602,4603,4601,4600,-1,4604,4605,4603,4602,-1,4608,4609,4607,4606,-1,4610,4611,4609,4608,-1,4612,4613,4611,4610,-1,4614,4615,4613,4612,-1,4616,4617,4615,4614,-1,4592,4588,4617,4616,-1,4591,4595,4617,4588,-1,4597,4599,4613,4615,-1,4599,4601,4611,4613,-1,4601,4603,4609,4611,-1,4603,4605,4607,4609,-1,4595,4597,4615,4617,-1,4618,4619,4620,4621,-1,4619,4622,4623,4620,-1,4622,4624,4625,4623,-1,4624,4626,4627,4625,-1,4626,4628,4629,4627,-1,4628,4630,4631,4629,-1,4621,4632,4633,4618,-1,4602,4635,4634,4604,-1,4600,4636,4635,4602,-1,4598,4637,4636,4600,-1,4596,4638,4637,4598,-1,4594,4639,4638,4596,-1,4593,4640,4639,4594,-1,4590,4641,4640,4593};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_25()
		{
			int[] value = {-1,4589,4642,4641,4590,-1,4592,4643,4642,4589,-1,4616,4644,4643,4592,-1,4614,4645,4644,4616,-1,4612,4646,4645,4614,-1,4610,4647,4646,4612,-1,4608,4648,4647,4610,-1,4606,4649,4648,4608,-1,4635,4629,4631,4634,-1,4636,4627,4629,4635,-1,4637,4625,4627,4636,-1,4638,4623,4625,4637,-1,4639,4620,4623,4638,-1,4640,4621,4620,4639,-1,4641,4632,4621,4640,-1,4642,4633,4632,4641,-1,4643,4618,4633,4642,-1,4644,4619,4618,4643,-1,4645,4622,4619,4644,-1,4646,4624,4622,4645,-1,4647,4626,4624,4646,-1,4648,4628,4626,4647,-1,4649,4630,4628,4648,-1,4650,4651,4652,4653,-1,4654,4653,4652,-1,4651,4650,4655,-1,4655,4650,4656,4657,-1,4657,4656,4658,4659,-1,4659,4658,4660,4661,-1,4661,4660,4662,4663,-1,4663,4662,4664,4665,-1,4665,4664,4666,4667,-1,4669,4668,4670,4671,-1,4671,4670,4672,4673,-1,4673,4672,4674,4675,-1,4675,4674,4676,4677,-1,4677,4676,4678,4679,-1,4679,4678,4653,4654,-1,4653,4678,4656,4650,-1,4676,4674,4660,4658,-1,4674,4672,4662,4660,-1,4672,4670,4664,4662,-1,4670,4668,4666,4664,-1,4678,4676,4658,4656,-1,4680,4681,4682,4683,-1,4681,4684,4685,4682,-1,4684,4686,4687,4685,-1,4686,4688,4689,4687,-1,4688,4690,4691,4689,-1,4683,4694,4695,4680,-1,4667,4696,4697,4665,-1,4665,4697,4698,4663,-1,4663,4698,4699,4661,-1,4661,4699,4700,4659,-1,4659,4700,4701,4657,-1,4657,4701,4702,4655,-1,4655,4702,4703,4651,-1,4651,4703,4704,4652,-1,4652,4704,4705,4654,-1,4654,4705,4706,4679,-1,4679,4706,4707,4677,-1,4677,4707,4708,4675,-1,4675,4708,4709,4673,-1,4673,4709,4710,4671,-1,4671,4710,4711,4669,-1,4696,4692,4690,4697,-1,4697,4690,4688,4698,-1,4698,4688,4686,4699,-1,4699,4686,4684,4700,-1,4700,4684,4681,4701,-1,4701,4681,4680,4702,-1,4702,4680,4695,4703,-1,4703,4695,4694,4704,-1,4704,4694,4683,4705,-1,4705,4683,4682,4706,-1,4706,4682,4685,4707,-1,4707,4685,4687,4708,-1,4708,4687,4689,4709,-1,4709,4689,4691,4710,-1,4710,4691,4693,4711,-1,4712,4713,4714,4715,-1,4716,4715,4714,-1,4713,4712,4717,-1,4717,4712,4718,4719,-1,4719,4718,4720,4721,-1,4721,4720,4722,4723,-1,4723,4722,4724,4725,-1,4725,4724,4726,4727,-1,4727,4726,4728,4729,-1,4731,4730,4732,4733,-1,4733,4732,4734,4735,-1,4735,4734,4736,4737,-1,4737,4736,4738,4739,-1,4739,4738,4740,4741,-1,4741,4740,4715,4716,-1,4715,4740,4718,4712,-1,4738,4736,4722,4720,-1,4736,4734,4724,4722,-1,4734,4732,4726,4724,-1,4732,4730,4728,4726,-1,4740,4738,4720,4718,-1,4742,4743,4744,4745,-1,4743,4746,4747,4744,-1,4746,4748,4749,4747,-1,4748,4750,4751,4749,-1,4750,4752,4753,4751,-1,4752,4754,4755,4753,-1,4745,4756,4757,4742,-1,4729,4758,4759,4727,-1,4727,4759,4760,4725,-1,4725,4760,4761,4723,-1,4723,4761,4762,4721,-1,4721,4762,4763,4719,-1,4719,4763,4764,4717,-1,4717,4764,4765,4713,-1,4713,4765,4766,4714,-1,4714,4766,4767,4716,-1,4716,4767,4768,4741,-1,4741,4768,4769,4739,-1,4739,4769,4770,4737,-1,4737,4770,4771,4735,-1,4735,4771,4772,4733,-1,4733,4772,4773,4731,-1,4758,4754,4752,4759,-1,4759,4752,4750,4760,-1,4760,4750,4748,4761,-1,4761,4748,4746,4762,-1,4762,4746,4743,4763,-1,4763,4743,4742,4764,-1,4764,4742,4757,4765,-1,4765,4757,4756,4766,-1,4766,4756,4745,4767,-1,4767,4745,4744,4768,-1,4768,4744,4747,4769,-1,4769,4747,4749,4770,-1,4770,4749,4751,4771,-1,4771,4751,4753,4772,-1,4772,4753,4755,4773,-1,4774,4775,4776,4777,-1,4778,4779,4780,4781,-1,4782,4783,4784,4785,-1,4786,4787,4788,4789,-1,4789,4788,4790,4791,-1,4791,4790,4792,4793,-1,4793,4792,4794,4795,-1,4795,4794,4796,4797,-1,4797,4796,4798,4799,-1,4799,4798,4800,4801,-1,4801,4800,4802,4803,-1,4805,4804,4806,4807,-1,4807,4806,4808,4809,-1,4809,4808,4810,4811,-1,4811,4810,4812,4813,-1,4813,4812,4814,4815,-1,4815,4814,4816,4817,-1,4817,4816,4787,4786,-1,4787,4818,4819,4788,-1,4788,4819,4820,4790,-1,4790,4820,4821,4792,-1,4792,4821,4822,4794,-1,4794,4822,4823,4796,-1,4796,4823,4777,4798,-1,4798,4777,4776,4800,-1,4800,4776,4824,4802,-1,4804,4825,4775,4806,-1,4806,4775,4774,4808,-1,4808,4774,4826,4810,-1,4810,4826,4827,4812,-1,4812,4827,4828,4814,-1,4814,4828,4829,4816,-1,4816,4829,4818,4787,-1,4775,4825,4824,4776,-1,4823,4822,4827,4826,-1,4826,4774,4777,4823,-1,4821,4820,4829,4828,-1,4828,4827,4822,4821,-1,4820,4819,4818,4829,-1,4781,4780,4830,4831,-1,4783,4782,4831,4830,-1,4832,4833,4834,4835,-1,4779,4778,4835,4834,-1,4836,4837,4833,4832,-1,4789,4837,4836,4786,-1,4786,4836,4832,4817,-1,4817,4832,4835,4815,-1,4815,4835,4778,4813,-1,4813,4778,4781,4811,-1,4811,4781,4831,4809,-1,4809,4831,4782,4807,-1,4807,4782,4785,4805,-1,4803,4784,4783,4801,-1,4801,4783,4830,4799,-1,4799,4830,4780,4797,-1,4797,4780,4779,4795,-1,4795,4779,4834,4793,-1,4793,4834,4833,4791,-1,4791,4833,4837,4789,-1,10831,3916,3925,10513,-1,3916,4053,3925,-1,4053,3914,3924,3925,-1,10864,10436,10863,10401};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_26()
		{
			int[] value = {4099,4078,4077,3905,4838,-1,4841,4840,4839,-1,4845,4844,4843,4842,-1,4849,4848,4847,4846,-1,4852,4851,4850,-1,4856,4855,4854,4853,-1,4860,4859,4858,4857,-1,4862,4849,4846,4861,-1,12446,12445,4864,4863,-1,4866,4843,4844,4865,-1,4877,4876,4875,4874,4873,12461,12460,12459,12458,12457,12456,12455,12454,12453,12452,12451,12450,12449,12448,12447,4872,4871,4870,4869,4868,4867,-1,4881,4880,4879,4878,-1,4885,4884,4883,4882,-1,4887,4886,4884,4885,-1,4880,4889,4888,4879,-1,4884,4891,4890,4883,-1,4858,4893,4892,4857,-1,4899,4891,4884,4886,-1,4901,4900,4886,4887,-1,4887,4904,4903,4902,4901,-1,4889,4906,4905,4888,-1,4891,4908,4907,4890,-1,4899,4909,4908,4891,-1,4911,4910,4909,4899,-1,4906,4863,4864,4905,-1,4908,4843,4866,4907,-1,4909,4842,4843,4908,-1,4910,4845,4842,4909,-1,4840,4914,4913,4839,-1,4916,4856,4853,4915,-1,4904,4841,4839,4903,-1,4898,4924,4923,4897,-1,4867,4926,4925,4877,-1,4868,4927,4926,4867,-1,4871,4929,4928,4870,-1,4852,4931,4930,4851,-1,4856,4933,4932,4855,-1,4916,4934,4933,4856,-1,4840,4936,4935,4914,-1,4841,4937,4936,4840,-1,4904,4938,4937,4841,-1,4887,4939,4938,4904,-1,4926,4846,4847,4925,-1,4927,4861,4846,4926,-1,4929,4859,4860,4928,-1,4931,4923,4924,4930,-1,4933,4921,4922,4932,-1,4934,4920,4921,4933,-1,4937,4917,4918,4936,-1,4938,4895,4917,4937,-1,4939,4894,4895,4938,-1,4901,4902,4940,-1,4900,4901,4940,-1,4941,4900,4940,-1,4944,4943,4942,-1,4877,4925,4945,4876,-1,4925,4847,4946,4945,-1,4847,4848,4947,4946,-1,4949,4948,4920,4934,-1,4935,4919,4948,4949,-1,4950,4949,4934,4916,-1,4914,4935,4949,4950,-1,4950,4951,4913,4914,-1,4916,4915,4951,4950,-1,4953,4952,12446,4863,-1,4866,4865,4952,4953,-1,4954,4953,4863,4906,-1,4907,4866,4953,4954,-1,4955,4954,4906,4889,-1,4890,4907,4954,4955,-1,4956,4955,4889,4880,-1,4883,4890,4955,4956,-1,4957,4956,4880,4881,-1,4882,4883,4956,4957,-1,4959,4958,4852,4850,-1,4854,4855,4958,4959,-1,4958,4960,4931,4852,-1,4855,4932,4960,4958,-1,4960,4961,4923,4931,-1,4932,4922,4961,4960,-1,4857,4892,4962,4963,-1,4963,4964,4860,4857,-1,4862,4861,4964,4963,-1,4965,4964,4861,4927,-1,4928,4860,4964,4965,-1,4869,4965,4927,4868,-1,4870,4928,4965,4869,-1,4968,4967,4966,-1,4968,4969,4967,-1,4973,4972,4971,4970,-1,4974,12539,12538,12537,-1,4972,4976,4975,4971,-1,4977,12542,4971,4975,-1,12544,12543,4850,4851,-1,4970,4971,12542,12545,-1,12548,12546,12542,4977,-1,4844,4845,12550,12549,-1,4979,4978,4966,4967,-1,4981,4978,4979,4980,-1,4982,4873,4887,4885,-1,4988,4987,4986,4985,-1,12577,4991,4990,4989,-1,12444,10569,4993,4992,-1,4992,4993,3954,4994,-1,12577,12579,12578,4991,-1,12585,12586,4839,4913,-1,4853,4854,12588,12587,-1,4881,4878,4995,4944,-1,4943,4982,4885,4882,-1,4865,4844,12549,12600,-1,12537,12544,4851,4974,-1,4985,4858,4859,4988,-1,4878,4879,4997,4996,-1,4999,4864,4998,-1,4998,4864,5000,-1,5000,4864,12445,12604,-1,12604,12610,5001,5000,-1,5000,5001,5002,4998,-1,4998,5002,5003,4999,-1,4996,4997,5005,5004,-1,4969,5007,3906,5006,-1,4978,5009,5008,4966,-1,4981,5010,5009,4978,-1,4902,4903,12632,12631,-1,5007,5012,5011,3906,-1,5009,5014,5013,5008,-1,5010,5015,5014,5009,-1,4997,5017,5016,5005,-1,4879,4888,5017,4997,-1,4969,5006,4967,-1,4985,5018,4893,4858,-1,4986,5019,5018,4985,-1,4991,5021,5020,4990,-1,12578,12647,12470,12471,5021,4991,-1,5018,5022,4898,4893,-1,5019,5023,5022,5018,-1,5021,12660,5024,5020,-1,12471,12472,12661,12660,5021,-1,5004,5026,5025,4996,-1,4996,5025,4995,4878,-1,4888,4905,5027,5017,-1,12644,12673,4910,4911,-1,5012,5029,5028,5011,-1,5014,5031,5030,5013,-1,5015,5032,5031,5014,-1,5017,5027,5033,5016,-1,4905,4864,4999,5027,-1,12673,12550,4845,4910,-1,5029,4994,3954,5028,-1,5031,4972,4973,5030,-1,5032,4976,4972,5031,-1,5027,4999,5003,5033,-1,4984,5034,4912,4896,-1,4915,4853,12587,12683,-1,4903,4839,12586,12632,-1,5022,5035,4924,4898,-1,5023,5036,5035,5022,-1,4873,5037,4939,4887,-1,4874,5038,5037,4873,-1,4875,5039,5038,4874,-1,4872,5040,4929,4871,-1,12447,5041,5040,4872,-1,12575,5042,5041,12447,-1,12645,5043,5042,12575,-1,12659,5044,5043,12645,-1,12539,5045,5044,12659,-1,4974,5046,5045,12539,-1,4851,4930,5046,4974,-1,5037,4983,4894,4939,-1,5038,4984,4983,5037,-1,5039,5034,4984,5038,-1,5040,4988,4859,4929,-1,5041,4987,4988,5040,-1,5042,4986,4987,5041,-1,5043,5019,4986,5042,-1,5044,5023,5019,5043,-1,5045,5036,5023,5044,-1,5046,5035,5036,5045,-1,4930,4924,5035,5046,-1,12689,4989,4990,12688,-1,12690,12577,4989,12689,-1,12698,5024,12660,12697,-1,12699,5020,5024,12698,-1,12688,4990,5020,12699,-1,4876,4945,5039,4875,-1,4945,4946,5034,5039,-1,4946,4947,4912,5034,-1,4951,12709,12585,4913,-1,4915,12683,12709,4951,-1,5048,5047,4981,4980,-1,5026,5004,5047,5048,-1,5047,5049,5010,4981,-1,5004,5005,5049,5047,-1,5049,5050,5015,5010,-1,5005,5016,5050,5049,-1,5050,5051,5032,5015,-1,5016,5033,5051,5050};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_27()
		{
			int[] value = {-1,5051,5052,4976,5032,-1,5033,5003,5052,5051,-1,5052,5053,4975,4976,-1,5003,5002,5053,5052,-1,5053,5054,4977,4975,-1,5002,5001,5054,5053,-1,5054,12714,12548,4977,-1,5001,12610,12714,5054,-1,12722,4940,4902,12631,-1,12643,4941,4940,12722,-1,12523,5055,4970,12545,-1,12444,4992,5055,12523,-1,5055,5056,4973,4970,-1,4992,4994,5056,5055,-1,5057,5056,4994,5029,-1,5030,4973,5056,5057,-1,5058,5057,5029,5012,-1,5013,5030,5057,5058,-1,5059,5058,5012,5007,-1,5008,5013,5058,5059,-1,4968,5059,5007,4969,-1,4966,5008,5059,4968,-1,4952,12734,12597,12446,-1,4865,12600,12734,4952,-1,4942,4957,4881,4944,-1,4943,4882,4957,4942,-1,12739,4959,4850,12543,-1,12588,4854,4959,12739,-1,4995,5025,5026,5048,4980,4979,4967,3872,10406,12619,12726,12618,12617,12616,12718,12615,12614,12613,-1,12644,4911,4941,12643,-1,4911,4900,4941,-1,4911,4899,4886,4900,-1,4873,4982,4943,4944,4995,12613,12612,12732,12461,-1,5062,5061,5060,-1,5068,5067,5066,-1,5073,5072,5071,-1,1215,5075,5074,-1,5079,5078,5077,5076,-1,5080,5077,5065,-1,5082,5062,5081,5076,-1,5085,1208,1218,-1,1219,5086,5085,1218,-1,5087,1208,5085,-1,5086,5088,5087,5085,-1,5080,5065,1208,5087,-1,5088,5082,5080,5087,-1,5078,5065,5077,-1,5077,5080,5082,5076,-1,5089,5064,5065,5078,-1,5079,5090,5089,5078,-1,5091,5064,5089,-1,5090,5092,5091,5089,-1,5093,5063,5064,5091,-1,5092,5094,5093,5091,-1,5095,5063,5093,-1,5094,5096,5095,5093,-1,1280,1281,5098,5097,-1,5097,5098,5100,5099,-1,5086,5102,5101,5088,-1,5107,5106,5105,5104,-1,1215,1294,5108,5075,-1,5110,5109,1296,1295,-1,5111,5099,5100,-1,4153,5113,5111,5112,-1,5074,5115,5114,-1,5117,5116,5075,5108,-1,5120,5119,5114,5115,-1,5121,5122,5116,5117,-1,5125,5124,5123,-1,5126,5125,1322,1290,-1,5123,5124,5070,5103,-1,5129,5127,5128,-1,5132,5131,5130,-1,5136,5135,5134,5133,-1,5140,5139,5138,5137,-1,5140,5081,5060,5139,-1,5076,5081,5141,5079,-1,5092,5142,5094,-1,5090,5143,5142,5092,-1,5079,5141,5143,5090,-1,5094,5142,5144,5096,-1,5148,5147,5146,5145,-1,5107,5149,5150,5106,-1,5153,5152,5083,5084,-1,5156,5155,1349,1350,-1,1345,1346,5157,-1,5158,5157,5145,5146,-1,5155,5156,5133,5134,-1,1219,1340,5102,5086,-1,5088,5101,5062,5082,-1,5159,1354,421,4199,-1,5159,4199,5161,5160,-1,5160,5161,4100,5162,-1,4153,5162,4100,-1,5101,5163,5061,5062,-1,5164,5102,1340,1358,-1,5134,5061,5163,5155,-1,5156,5158,5146,5133,-1,5157,5158,1359,1345,-1,5156,1350,1359,5158,-1,5155,5163,5164,1349,-1,5164,1358,1334,1349,-1,5083,5152,5154,5151,-1,5107,5166,5165,5149,-1,5104,5167,5166,5107,-1,5105,5168,1380,1326,-1,5169,5157,1346,1361,-1,1327,1373,5167,5104,-1,5170,5168,5105,5106,-1,5068,5169,5168,5170,-1,5150,5171,5170,5106,-1,5068,5170,5171,5067,-1,5145,5068,5066,5148,-1,5145,5157,5169,5068,-1,5173,5144,5142,5174,-1,5142,5143,5174,-1,5137,5173,5174,5140,-1,5140,5174,5141,5081,-1,5139,5060,5061,-1,5146,5147,5136,5133,-1,5138,5139,5061,5172,-1,5134,5135,5172,5061,-1,5177,5176,5175,-1,5179,5178,5176,5177,-1,5181,5180,5165,5166,-1,5130,5131,5180,5181,-1,5178,5179,5132,5130,-1,5181,5166,5167,5182,-1,5130,5184,5183,5178,-1,1373,1374,1381,5182,-1,5167,1373,5182,-1,5186,5069,5188,5187,-1,5188,5125,5187,-1,5188,5069,5070,5124,-1,5123,5103,5175,5176,-1,1403,1404,5189,5183,-1,5184,1384,1403,5183,-1,5190,5185,5186,5187,-1,5187,5125,5126,5190,-1,5125,5188,5124,-1,5129,5128,5185,5190,-1,5189,1404,1322,5125,-1,5123,5176,5189,5125,-1,5071,5193,5191,5192,-1,5071,5192,5194,5073,-1,5129,5126,5072,5073,-1,5199,5195,5118,5198,-1,5198,5118,5121,5117,-1,5116,5122,5120,5115,-1,5075,5116,5115,5074,-1,5200,1405,1215,5074,-1,5114,5193,5200,5074,-1,5100,5201,5112,5111,-1,5202,1423,1354,5159,-1,5162,5204,5203,5160,-1,5203,5202,5159,5160,-1,5112,5204,4153,-1,5113,5196,5197,5111,-1,5205,5099,5111,5197,-1,5206,5097,5099,5205,-1,1424,1280,5097,5206,-1,5109,5198,5117,5108,-1,1294,1296,5109,5108,-1,5110,5199,5198,5109,-1,5110,1295,1297,5207,-1,5208,1298,1424,5206,-1,5207,1297,1298,5208,-1,5208,5206,5205,5199,-1,5205,5197,5195,5199,-1,5199,5110,5207,-1,5178,5183,5189,5176,-1,5126,5129,5190,-1,5199,5207,5208,-1,5182,1381,1384,5184,-1,5184,5130,5181,5182,-1,5127,5129,5073,5194,-1,5114,5119,5191,5193,-1,5071,5072,5200,5193,-1,5072,5126,1290,1291,-1,5072,1291,1405,5200,-1,5101,5102,5164,5163,-1,4153,5204,5162,-1,5202,5209,1434,1423,-1,5201,5209,5202,5203,-1,5209,5201,5100,5098,-1,1281,1434,5209,5098,-1,5201,5203,5204,5112,-1,5104,5105,1326,1327,-1,1361,1380,5168,5169,-1,5062,5060,5081,-1,5143,5141,5174,-1,5213,5212,5211,5210,-1,5217,5216,5215,5214,-1,5221,5220,5219,5218,-1,5225,5224,5223,5222,-1,5222,5223,5227,5226,-1,5226,5227,5229,5228,-1,5228,5229,5231,5230,-1,5230,5231,5233,5232,-1,5232,5233,5235,5234,-1,5234,5235,5237,5236,-1,5236,5237,5239,5238,-1,5240,5241};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_28()
		{
			int[] value = {5243,5242,-1,5242,5243,5245,5244,-1,5244,5245,5247,5246,-1,5246,5247,5249,5248,-1,5248,5249,5251,5250,-1,5250,5251,5253,5252,-1,5252,5253,5224,5225,-1,5224,5255,5254,5223,-1,5223,5254,5256,5227,-1,5227,5256,5257,5229,-1,5229,5257,5258,5231,-1,5231,5258,5259,5233,-1,5233,5259,5210,5235,-1,5235,5210,5211,5237,-1,5237,5211,5260,5239,-1,5241,5261,5212,5243,-1,5243,5212,5213,5245,-1,5245,5213,5262,5247,-1,5247,5262,5263,5249,-1,5249,5263,5264,5251,-1,5251,5264,5265,5253,-1,5253,5265,5255,5224,-1,5212,5261,5260,5211,-1,5259,5258,5263,5262,-1,5262,5213,5210,5259,-1,5257,5256,5265,5264,-1,5264,5263,5258,5257,-1,5256,5254,5255,5265,-1,5214,5215,5267,5266,-1,5220,5221,5266,5267,-1,5271,5270,5269,5268,-1,5216,5217,5268,5269,-1,5273,5272,5270,5271,-1,5222,5272,5273,5225,-1,5225,5273,5271,5252,-1,5252,5271,5268,5250,-1,5250,5268,5217,5248,-1,5248,5217,5214,5246,-1,5246,5214,5266,5244,-1,5244,5266,5221,5242,-1,5242,5221,5218,5240,-1,5238,5219,5220,5236,-1,5236,5220,5267,5234,-1,5234,5267,5215,5232,-1,5232,5215,5216,5230,-1,5230,5216,5269,5228,-1,5228,5269,5270,5226,-1,5226,5270,5272,5222,-1,5277,5276,5275,5274,-1,5279,5278,5276,5277,-1,5281,5280,5278,5279,-1,5283,5282,5280,5281,-1,5285,5284,5282,5283,-1,5289,5288,5287,5286,-1,5276,5291,5290,5275,-1,5278,5292,5291,5276,-1,5280,5293,5292,5278,-1,5282,5294,5293,5280,-1,5284,5295,5294,5282,-1,5288,5297,5296,5287,-1,5291,5299,5298,5290,-1,5292,5300,5299,5291,-1,5293,5301,5300,5292,-1,5294,5302,5301,5293,-1,5295,5303,5302,5294,-1,5297,5305,5304,5296,-1,5299,5307,5306,5298,-1,5300,5308,5307,5299,-1,5301,5309,5308,5300,-1,5302,5310,5309,5301,-1,5303,5311,5310,5302,-1,5305,5313,5312,5304,-1,5307,5315,5314,5306,-1,5308,5316,5315,5307,-1,5309,5317,5316,5308,-1,5310,5318,5317,5309,-1,5311,5319,5318,5310,-1,5313,5321,5320,5312,-1,5315,5323,5322,5314,-1,5316,5324,5323,5315,-1,5317,5325,5324,5316,-1,5318,5326,5325,5317,-1,5319,5327,5326,5318,-1,5321,5329,5328,5320,-1,5333,5332,5331,5330,-1,5322,5335,5336,5314,-1,5314,5336,5337,5306,-1,5306,5337,5338,5298,-1,5298,5338,5339,5290,-1,5290,5339,5340,5275,-1,5275,5340,5341,5274,-1,5333,5343,5342,5332,-1,5347,5346,5345,5344,-1,5344,5345,5349,5348,-1,5348,5349,5351,5350,-1,5350,5351,5353,5352,-1,5352,5353,5355,5354,-1,5354,5355,5357,5356,-1,5334,5358,5359,5335,-1,5335,5359,5360,5336,-1,5336,5360,5361,5337,-1,5337,5361,5362,5338,-1,5338,5362,5363,5339,-1,5339,5363,5364,5340,-1,5340,5364,5365,5341,-1,5343,5367,5366,5342,-1,5346,5369,5368,5345,-1,5345,5368,5370,5349,-1,5349,5370,5371,5351,-1,5351,5371,5372,5353,-1,5353,5372,5373,5355,-1,5355,5373,5374,5357,-1,5364,5376,5375,5365,-1,5367,5378,5377,5366,-1,5369,5380,5379,5368,-1,5368,5379,5381,5370,-1,5370,5381,5382,5371,-1,5371,5382,5383,5372,-1,5372,5383,5384,5373,-1,5373,5384,5385,5374,-1,5358,5386,5387,5359,-1,5359,5387,5388,5360,-1,5360,5388,5389,5361,-1,5361,5389,5390,5362,-1,5362,5390,5391,5363,-1,5363,5391,5376,5364,-1,5376,5288,5289,5375,-1,5378,5393,5392,5377,-1,5380,5286,5287,5379,-1,5379,5287,5296,5381,-1,5381,5296,5304,5382,-1,5382,5304,5312,5383,-1,5383,5312,5320,5384,-1,5384,5320,5328,5385,-1,5387,5329,5321,5388,-1,5388,5321,5313,5389,-1,5389,5313,5305,5390,-1,5390,5305,5297,5391,-1,5391,5297,5288,5376,-1,5331,5395,5394,5330,-1,5281,5395,5331,5283,-1,5283,5331,5332,5285,-1,5347,5332,5342,5346,-1,5346,5342,5366,5369,-1,5369,5366,5377,5380,-1,5380,5377,5392,5286,-1,5286,5392,5393,5289,-1,5289,5393,5378,5375,-1,5375,5378,5367,5365,-1,5365,5367,5343,5341,-1,5341,5343,5333,5274,-1,5274,5333,5330,5277,-1,5277,5330,5394,5279,-1,5279,5394,5395,5281,-1,5303,5295,5397,5396,-1,5396,5397,5348,5350,-1,5295,5284,5398,5397,-1,5397,5398,5344,5348,-1,5284,5285,5399,5398,-1,5398,5399,5347,5344,-1,5311,5303,5396,5400,-1,5400,5396,5350,5352,-1,5319,5311,5400,5401,-1,5401,5400,5352,5354,-1,5327,5319,5401,5402,-1,5402,5401,5354,5356,-1,5285,5332,5399,-1,5332,5347,5399,-1,5406,5405,5404,5403,-1,5407,5403,5404,-1,5405,5406,5408,-1,5408,5406,5410,5409,-1,5409,5410,5412,5411,-1,5411,5412,5414,5413,-1,5413,5414,5416,5415,-1,5415,5416,5418,5417,-1,5417,5418,5420,5419,-1,5421,5422,5424,5423,-1,5423,5424,5426,5425,-1,5425,5426,5428,5427,-1,5427,5428,5430,5429,-1,5429,5430,5432,5431,-1,5431,5432,5403,5407,-1,5403,5432,5410,5406,-1,5430,5428,5414,5412,-1,5428,5426,5416,5414,-1,5426,5424,5418,5416,-1,5424,5422,5420,5418,-1,5432,5430,5412,5410,-1,5436,5435,5434,5433,-1,5435,5438,5437,5434,-1,5438,5440,5439,5437,-1,5440,5442,5441,5439,-1,5442,5444,5443,5441,-1,5444,5446,5445,5443,-1,5433,5448,5447,5436,-1,5419,5449,5450,5417,-1,5417,5450,5451,5415,-1,5415,5451,5452,5413,-1,5413,5452,5453,5411,-1,5411,5453,5454,5409,-1,5409};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_29()
		{
			int[] value = {5454,5455,5408,-1,5408,5455,5456,5405,-1,5405,5456,5457,5404,-1,5404,5457,5458,5407,-1,5407,5458,5459,5431,-1,5431,5459,5460,5429,-1,5429,5460,5461,5427,-1,5427,5461,5462,5425,-1,5425,5462,5463,5423,-1,5423,5463,5464,5421,-1,5449,5446,5444,5450,-1,5450,5444,5442,5451,-1,5451,5442,5440,5452,-1,5452,5440,5438,5453,-1,5453,5438,5435,5454,-1,5454,5435,5436,5455,-1,5455,5436,5447,5456,-1,5456,5447,5448,5457,-1,5457,5448,5433,5458,-1,5458,5433,5434,5459,-1,5459,5434,5437,5460,-1,5460,5437,5439,5461,-1,5461,5439,5441,5462,-1,5462,5441,5443,5463,-1,5463,5443,5445,5464,-1,5468,5467,5466,5465,-1,5467,5468,5469,-1,5470,5465,5466,-1,5472,5471,5465,5470,-1,5474,5473,5471,5472,-1,5476,5475,5473,5474,-1,5478,5477,5475,5476,-1,5480,5479,5477,5478,-1,5482,5481,5479,5480,-1,5486,5485,5483,5484,-1,5488,5487,5485,5486,-1,5490,5489,5487,5488,-1,5492,5491,5489,5490,-1,5494,5493,5491,5492,-1,5469,5468,5493,5494,-1,5465,5471,5493,5468,-1,5473,5475,5489,5491,-1,5475,5477,5487,5489,-1,5477,5479,5485,5487,-1,5479,5481,5483,5485,-1,5471,5473,5491,5493,-1,5498,5497,5496,5495,-1,5497,5500,5499,5496,-1,5500,5502,5501,5499,-1,5495,5506,5505,5498,-1,5478,5508,5507,5480,-1,5476,5509,5508,5478,-1,5474,5510,5509,5476,-1,5472,5511,5510,5474,-1,5470,5512,5511,5472,-1,5466,5513,5512,5470,-1,5467,5514,5513,5466,-1,5469,5515,5514,5467,-1,5494,5516,5515,5469,-1,5492,5517,5516,5494,-1,5490,5518,5517,5492,-1,5488,5519,5518,5490,-1,5509,5501,5503,5508,-1,5510,5499,5501,5509,-1,5511,5496,5499,5510,-1,5512,5495,5496,5511,-1,5513,5506,5495,5512,-1,5514,5505,5506,5513,-1,5515,5498,5505,5514,-1,5516,5497,5498,5515,-1,5517,5500,5497,5516,-1,5518,5502,5500,5517,-1,5519,5504,5502,5518,-1,5523,5522,5521,5520,-1,5522,5523,5524,-1,5525,5520,5521,-1,5527,5526,5520,5525,-1,5529,5528,5526,5527,-1,5531,5530,5528,5529,-1,5533,5532,5530,5531,-1,5535,5534,5532,5533,-1,5537,5536,5534,5535,-1,5541,5540,5538,5539,-1,5543,5542,5540,5541,-1,5545,5544,5542,5543,-1,5547,5546,5544,5545,-1,5549,5548,5546,5547,-1,5524,5523,5548,5549,-1,5520,5526,5548,5523,-1,5528,5530,5544,5546,-1,5530,5532,5542,5544,-1,5532,5534,5540,5542,-1,5534,5536,5538,5540,-1,5526,5528,5546,5548,-1,5553,5552,5551,5550,-1,5552,5555,5554,5551,-1,5555,5557,5556,5554,-1,5557,5559,5558,5556,-1,5561,5563,5562,5560,-1,5563,5565,5564,5562,-1,5550,5567,5566,5553,-1,5535,5570,5569,5537,-1,5533,5571,5570,5535,-1,5531,5572,5571,5533,-1,5529,5573,5572,5531,-1,5527,5574,5573,5529,-1,5525,5575,5574,5527,-1,5521,5576,5575,5525,-1,5522,5577,5576,5521,-1,5524,5578,5577,5522,-1,5549,5579,5578,5524,-1,5547,5580,5579,5549,-1,5545,5581,5580,5547,-1,5543,5582,5581,5545,-1,5541,5583,5582,5543,-1,5539,5584,5583,5541,-1,5569,5562,5564,5568,-1,5570,5560,5562,5569,-1,5571,5558,5560,5570,-1,5572,5556,5558,5571,-1,5573,5554,5556,5572,-1,5574,5551,5554,5573,-1,5575,5550,5551,5574,-1,5576,5567,5550,5575,-1,5577,5566,5567,5576,-1,5578,5553,5566,5577,-1,5579,5552,5553,5578,-1,5580,5555,5552,5579,-1,5581,5557,5555,5580,-1,5582,5559,5557,5581,-1,5583,5561,5559,5582,-1,5584,5563,5561,5583,-1,5588,5587,5586,5585,-1,5592,5591,5590,5589,-1,5596,5595,5594,5593,-1,5600,5599,5598,5597,-1,5602,5601,5599,5600,-1,5604,5603,5601,5602,-1,5606,5605,5603,5604,-1,5608,5607,5605,5606,-1,5610,5609,5607,5608,-1,5612,5611,5609,5610,-1,5614,5613,5611,5612,-1,5618,5617,5615,5616,-1,5620,5619,5617,5618,-1,5622,5621,5619,5620,-1,5624,5623,5621,5622,-1,5626,5625,5623,5624,-1,5628,5627,5625,5626,-1,5597,5598,5627,5628,-1,5599,5630,5629,5598,-1,5601,5631,5630,5599,-1,5603,5632,5631,5601,-1,5605,5633,5632,5603,-1,5607,5634,5633,5605,-1,5609,5588,5634,5607,-1,5611,5587,5588,5609,-1,5613,5635,5587,5611,-1,5617,5586,5636,5615,-1,5619,5585,5586,5617,-1,5621,5637,5585,5619,-1,5623,5638,5637,5621,-1,5625,5639,5638,5623,-1,5627,5640,5639,5625,-1,5598,5629,5640,5627,-1,5587,5635,5636,5586,-1,5637,5638,5633,5634,-1,5634,5588,5585,5637,-1,5639,5640,5631,5632,-1,5632,5633,5638,5639,-1,5640,5629,5630,5631,-1,5642,5641,5591,5592,-1,5641,5642,5593,5594,-1,5646,5645,5644,5643,-1,5645,5646,5589,5590,-1,5643,5644,5648,5647,-1,5597,5647,5648,5600,-1,5628,5643,5647,5597,-1,5626,5646,5643,5628,-1,5624,5589,5646,5626,-1,5622,5592,5589,5624,-1,5620,5642,5592,5622,-1,5618,5593,5642,5620,-1,5616,5596,5593,5618,-1,5612,5594,5595,5614,-1,5610,5641,5594,5612,-1,5608,5591,5641,5610,-1,5606,5590,5591,5608,-1,5604,5645,5590,5606,-1,5602,5644,5645,5604,-1,5600,5648,5644,5602,-1,5652,5651,5650,5649,-1,5660,5659,5658,5657,-1,5658,5662,5661,5657,-1,5666,5665,5664,5663,-1,5663,5664,5670,5669,-1,5675,5674,5673,-1,5679,5678,5677,5676,-1,5681,5680,5678,5679,-1,5673,5680,5681,5675,-1,5681,5682,5675,-1,5651,5652};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_30()
		{
			int[] value = {5686,5685,-1,5687,5683,5684,-1,5685,5686,5676,5677,5688,-1,5691,5674,5690,5689,-1,5695,5694,5693,5692,-1,5697,5696,5693,5694,-1,5701,5700,5699,5698,-1,5707,5706,5705,5704,-1,5710,5709,5708,-1,5708,5709,5653,5654,-1,5655,5651,5685,5713,-1,5713,5685,5688,5714,-1,5716,5691,5689,5715,-1,5717,5653,5709,5718,-1,5720,5705,5706,5719,-1,5719,5722,5721,5720,-1,5718,5724,5723,5717,-1,5726,5715,5689,5725,-1,5728,5706,5707,5727,-1,5729,5719,5706,5728,-1,5730,5722,5719,5729,-1,5732,5694,5695,5731,-1,5733,5697,5694,5732,-1,5735,5701,5698,5734,-1,5674,5691,5736,5673,-1,5716,5737,5736,5691,-1,5705,5739,5738,5704,-1,5720,5740,5739,5705,-1,5721,5741,5740,5720,-1,5693,5743,5742,5692,-1,5696,5744,5743,5693,-1,5700,5746,5745,5699,-1,5736,5747,5680,5673,-1,5737,5748,5747,5736,-1,5739,5750,5749,5738,-1,5740,5751,5750,5739,-1,5741,5752,5751,5740,-1,5743,5754,5753,5742,-1,5744,5755,5754,5743,-1,5746,5666,5663,5745,-1,5758,5757,5658,5659,-1,5757,5758,5682,5681,-1,5757,5761,5662,5658,-1,5681,5679,5761,5757,-1,5747,5762,5678,5680,-1,5748,5763,5762,5747,-1,5750,5765,5764,5749,-1,5751,5766,5765,5750,-1,5752,5767,5766,5751,-1,5754,5769,5768,5753,-1,5755,5770,5769,5754,-1,5761,5686,5652,5662,-1,5679,5676,5686,5761,-1,5762,5688,5677,5678,-1,5763,5714,5688,5762,-1,5765,5709,5710,5764,-1,5766,5718,5709,5765,-1,5767,5724,5718,5766,-1,5769,5683,5687,5768,-1,5772,5773,5687,5684,-1,5774,5773,5724,5767,-1,5768,5687,5773,5774,-1,5776,5775,5722,5730,-1,5731,5695,5775,5776,-1,5777,5775,5695,5692,-1,5721,5722,5775,5777,-1,5777,5778,5741,5721,-1,5692,5742,5778,5777,-1,5778,5779,5752,5741,-1,5742,5753,5779,5778,-1,5779,5774,5767,5752,-1,5753,5768,5774,5779,-1,5669,5670,5770,5755,-1,5780,5669,5755,5744,-1,5745,5663,5669,5780,-1,5781,5780,5744,5696,-1,5699,5745,5780,5781,-1,5782,5781,5696,5697,-1,5698,5699,5781,5782,-1,5783,5782,5697,5733,-1,5734,5698,5782,5783,-1,5785,5784,5763,5748,-1,5749,5764,5784,5785,-1,5786,5785,5748,5737,-1,5738,5749,5785,5786,-1,5787,5786,5737,5716,-1,5704,5738,5786,5787,-1,5787,5788,5707,5704,-1,5716,5715,5788,5787,-1,5789,5788,5715,5726,-1,5727,5707,5788,5789,-1,5784,5790,5714,5763,-1,5764,5710,5790,5784,-1,5791,5790,5710,5708,-1,5713,5714,5790,5791,-1,5671,5791,5708,5654,-1,5655,5713,5791,5671,-1,5725,5689,5690,-1,5660,5656,5712,5667,5668,5711,5759,5760,5771,5703,5702,5672,5756,5735,5734,5783,5733,5732,5731,5776,5730,5729,5728,5727,5789,5726,5725,5690,5674,5675,5682,5758,5659,-1,5857,5845,7187,7188,-1,5859,5858,5799,8251,-1,5845,5857,5853,5844,-1,5858,5859,5849,5850,-1,5843,5854,5842,5841,-1,5851,5852,5826,5827,-1,5827,5842,5854,5851,-1,5853,5857,5858,5850,-1,5857,7188,5799,5858,-1,5798,5856,5855,6860,-1,5856,5828,5848,5855,-1,5833,5840,5847,5829,-1,5833,5829,5832,-1,5828,5856,5846,5830,-1,5856,5798,7186,5846,-1,5855,5848,5837,5835,-1,6860,5855,5835,5797,-1,5844,5853,5854,5843,-1,5853,5850,5851,5854,-1,5850,5849,5852,5851,-1,5830,5832,5829,-1,5848,5828,5829,5847,-1,5839,5837,5848,5847,-1,5839,5847,5840,-1,7187,5845,5846,7186,-1,5845,5844,5830,5846,-1,5844,5843,5832,5830,-1,5841,5831,5832,5843,-1,8250,5834,5823,6859,-1,5834,5836,5822,5823,-1,5836,5838,5819,5822,-1,5821,5819,5838,-1,5808,5809,5842,5827,-1,5809,5811,5841,5842,-1,5811,5813,5831,5841,-1,5813,5815,5833,5831,-1,5815,5817,5840,5833,-1,5839,5840,5817,5821,5838,-1,5838,5836,5837,5839,-1,5836,5834,5835,5837,-1,5834,8250,5797,5835,-1,5832,5831,5833,-1,5829,5828,5830,-1,5827,5826,5825,5808,-1,5820,5822,5819,-1,5818,5821,5817,-1,5807,5808,5825,-1,5823,5824,6858,6859,-1,5822,5820,5824,5823,-1,5820,5819,5821,5818,-1,5815,5816,5818,5817,-1,5813,5814,5816,5815,-1,5811,5812,5814,5813,-1,5809,5810,5812,5811,-1,5808,5807,5810,5809,-1,5883,5884,5885,5876,5877,-1,5886,5873,5874,-1,5886,5865,5863,5873,-1,5866,7191,7192,5864,-1,5804,5868,6863,-1,5864,7192,8257,5862,-1,5880,5879,5874,5871,-1,5886,5874,5879,5876,-1,5865,5886,5876,5885,-1,5867,5865,5885,5884,-1,5869,5867,5884,5883,-1,5882,5869,5883,5877,-1,5877,5878,5881,5882,-1,5878,5880,5881,-1,5880,5878,5879,-1,5877,5876,5879,5878,-1,5868,5804,7191,5866,-1,5875,5872,5873,-1,5862,8257,6864,5861,-1,5873,5863,5860,5875,-1,5872,5871,5874,5873,-1,5868,5869,5870,6863,-1,5866,5867,5869,5868,-1,5864,5865,5867,5866,-1,5862,5863,5865,5864,-1,5861,5860,5863,5862,-1,5983,5972,5962,5961,-1,8256,5983,5961,8255,-1,5982,8248,5795,5971,-1,5981,5982,5971,5970,-1,5980,5981,5970,5969,-1,5979,5980,5969,5968,-1,5978,5979,5968,5967,-1,5977,5978,5967,5965,-1,5976,5977,5965,5966,-1,5899,5976,5966,5900,-1,5975,5898,5896,5890,-1,5974,5975,5890,5887,-1,5919,5974,5887,5918,-1,5973,5910,5911,5963,-1,5907,5973,5963,5905,-1,5972,5908,5906,5962,-1,5964,5948,6861,8252,-1,5800,5956};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_31()
		{
			int[] value = {5959,6862,-1,5900,5966,5930,5928,-1,5971,5795,5796,5940,-1,5970,5971,5940,5941,-1,5969,5970,5941,5942,-1,5968,5969,5942,5945,-1,5967,5968,5945,5944,-1,5965,5967,5944,5943,-1,5966,5965,5943,5930,-1,5901,5900,5928,-1,5892,5894,5890,5896,-1,5948,5964,5960,5947,-1,5946,5960,5894,5893,-1,5964,8252,6862,5959,-1,5960,5964,5959,5957,-1,5894,5960,5957,5958,-1,5889,5894,5958,5888,-1,5918,5887,5888,5917,-1,5963,5911,5913,5949,-1,5905,5963,5949,5904,-1,5962,5906,5902,5923,-1,5961,5962,5923,5922,-1,8255,5961,5922,7190,-1,8249,5939,5940,5796,-1,5938,5940,5939,-1,5936,5937,5941,-1,5960,5946,5947,-1,5956,5954,5957,5959,-1,5888,5958,5952,-1,5954,5952,5958,5957,-1,5916,5915,5914,-1,5916,5953,5950,5915,-1,5953,5955,5951,5950,-1,5955,7189,8253,5951,-1,7189,5955,5956,5800,-1,5955,5953,5954,5956,-1,5953,5916,5952,5954,-1,5916,5917,5888,5952,-1,5913,5915,5903,5949,-1,5925,5920,5903,-1,5925,5926,5921,5920,-1,5926,5801,5802,5921,-1,8254,5927,5951,8253,-1,5927,5924,5950,5951,-1,5924,5903,5915,5950,-1,5903,5904,5949,-1,5894,5889,5890,-1,5859,8251,6861,5948,-1,5849,5859,5948,5947,-1,5852,5849,5947,5946,-1,5946,5893,5826,5852,-1,5934,5942,5935,-1,5934,5933,5945,5942,-1,5933,5932,5944,5945,-1,5932,5931,5943,5944,-1,5931,5929,5930,5943,-1,5901,5928,5929,-1,5941,5937,5935,5942,-1,5940,5938,5936,5941,-1,5893,5901,5826,-1,5891,5901,5893,-1,5826,5901,5825,-1,5820,5936,5938,-1,5818,5935,5937,-1,5824,5939,8249,6858,-1,5820,5938,5939,5824,-1,5936,5820,5818,5937,-1,5816,5934,5935,5818,-1,5814,5933,5934,5816,-1,5812,5932,5933,5814,-1,5810,5931,5932,5812,-1,5807,5929,5931,5810,-1,5825,5929,5807,-1,5825,5901,5929,-1,5929,5928,5930,-1,5801,5926,5927,8254,-1,5926,5925,5924,5927,-1,5903,5924,5925,-1,5920,5923,5902,-1,5920,5921,5922,5923,-1,5922,5921,5802,7190,-1,5902,5903,5920,-1,5918,5912,5909,5919,-1,5917,5914,5912,5918,-1,5916,5914,5917,-1,5913,5914,5915,-1,5911,5912,5914,5913,-1,5910,5909,5912,5911,-1,5905,5906,5908,5907,-1,5904,5902,5906,5905,-1,5903,5902,5904,-1,5895,5900,5901,5891,-1,5897,5899,5900,5895,-1,5895,5896,5898,5897,-1,5891,5892,5896,5895,-1,5893,5894,5892,-1,5892,5891,5893,-1,5889,5887,5890,-1,5888,5887,5889,-1,8261,6870,6329,-1,6038,6037,6683,6492,-1,6044,6043,6733,6393,-1,6041,6040,6387,6732,-1,6784,6137,6139,6778,-1,6138,6016,6017,6292,-1,6777,6140,6143,6788,-1,6142,6825,6793,-1,6791,6144,6147,6284,-1,6146,6145,6794,6281,-1,6283,6148,6151,6695,-1,6150,6149,6282,6700,-1,6698,6152,6155,6629,-1,6154,6153,6701,6626,-1,6632,6156,6159,6806,-1,6158,6157,6627,6808,-1,6161,6168,6183,-1,6167,6162,6243,6177,-1,6173,6164,6180,-1,6165,6172,6182,-1,6246,6163,6174,6184,-1,6169,6176,6181,-1,6175,6170,6190,6187,6186,-1,6171,6166,6178,6224,6193,-1,6581,6662,6657,-1,6185,6188,6530,6715,-1,6255,6189,6191,6583,-1,6586,6192,6225,6250,-1,6223,6195,6585,6247,-1,6584,6196,6199,6258,-1,6198,6197,6251,-1,6252,6229,6814,6385,-1,6239,6203,6205,6587,-1,6201,6230,6204,-1,6590,6206,6219,6234,-1,6217,6209,6589,6231,-1,6588,6210,6213,6242,-1,6212,6211,6235,-1,6214,6711,6815,-1,6208,6215,6238,-1,6237,6232,6654,6543,-1,6194,6221,6254,-1,6253,6222,6248,6658,-1,6218,6207,6227,-1,6259,6713,6764,-1,6712,6260,5986,5987,-1,6440,6437,6735,6685,-1,6684,6266,6269,6491,-1,6268,6267,6686,6747,-1,6490,6270,6386,-1,6272,6826,6642,6828,-1,6795,6273,6705,6280,-1,6704,6274,6277,6709,-1,6276,6275,6829,6822,6596,-1,6790,6285,6288,6664,-1,6287,6286,6696,6786,-1,6019,6022,6679,6775,-1,6731,6388,6392,-1,6389,6395,6734,-1,6394,6390,6014,6015,6730,-1,6264,6736,6751,6403,6689,-1,6397,6750,6737,6438,6434,-1,6753,6398,6402,-1,6399,6405,6752,-1,6404,6400,6833,6693,6691,6688,-1,6396,6412,6411,6832,6401,-1,6835,6410,6413,6842,6845,-1,6841,6414,6740,6474,-1,6408,6838,6650,6644,-1,6839,6416,6419,6649,-1,6406,6448,6443,6418,6417,-1,6708,6278,6597,6634,6601,-1,6648,6420,6422,6820,-1,6444,6461,6457,-1,6425,6824,6774,6680,-1,6641,6427,6429,6646,-1,6431,6428,6681,6851,-1,6433,6409,6645,6430,-1,5999,6477,6473,-1,6441,6436,6439,-1,6456,6445,6449,-1,6447,6407,6837,6760,6451,-1,6446,6452,6455,-1,6450,6758,6466,6465,-1,6458,6743,6633,6595,-1,6742,6459,6462,-1,6467,6476,6537,6762,-1,6261,6761,6262,-1,6479,6468,6472,-1,6469,6475,6478,-1,6009,6481,6484,6008,-1,6483,6482,6486,6720,-1,6011,6485,6718,-1,6001,6495,6000,-1,6032,6494,6493,-1,6497,6033,6728,6501,-1,6722,6496,6498,6724,-1,6719,6487,6721,6725,-1,6723,6499,6502,6744,-1,6013,6500,6729,6012,-1,6706,6567,6678,-1,6635,6539,6561,6799,6604,-1,6560,6540,6593,6544,-1,6542,6651,6554,6559,-1,6545,6553,6652,6655,-1,6555,6547,6656,-1,6546,6556,6816,-1,6548,6802,6819,6557,-1,6551,6668,6798,6558,-1,6714,6563,6639,6579,-1,6663,6289,6610,6637,6564,-1,6665};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_32()
		{
			int[] value = {6565,6770,6776,-1,6675,6536,6703,6710,-1,6534,6614,6574,6569,-1,6677,6568,6571,6618,-1,6812,6666,6817,6810,-1,6617,6572,6575,6813,-1,6578,6573,6615,6670,-1,6669,6598,6797,-1,6549,6660,6612,6623,-1,6609,6290,6787,6622,-1,6661,6582,6636,6611,-1,6562,6768,6769,6566,6638,-1,6613,6535,6673,6606,-1,6607,6600,6672,6616,-1,6796,6599,6608,6603,-1,6707,6602,6605,6674,-1,6676,6619,6625,6702,-1,6628,6620,6811,6807,-1,6805,6160,6818,6803,-1,6621,6785,6697,6630,-1,6800,6624,6631,6804,-1,6640,6647,6821,6827,-1,6850,6682,6023,6024,-1,6853,5792,6749,-1,6746,6687,6692,6831,-1,6767,6717,6781,6772,-1,6840,6756,6844,-1,6843,6757,6847,-1,6848,6759,6836,6834,6846,-1,6779,6782,6020,6021,-1,6037,6038,6036,-1,6031,6044,6030,-1,6040,6041,6039,-1,6043,6044,6042,-1,6016,6138,6139,6137,-1,6141,6142,6143,6140,-1,6145,6146,6147,6144,-1,6149,6150,6151,6148,-1,6153,6154,6155,6152,-1,6157,6158,6159,6156,-1,6162,6167,6168,6161,-1,6161,6183,6180,6164,-1,6165,6182,6183,6168,-1,6164,6173,6174,6163,-1,6173,6180,6181,6176,-1,6170,6175,6176,6169,-1,6169,6181,6182,6172,-1,6166,6171,6172,6165,-1,6167,6177,6178,6166,-1,6177,6243,6244,6179,-1,6163,6246,6243,6162,-1,6185,6245,6246,6184,-1,6175,6186,6184,6174,-1,6186,6187,6188,6185,-1,6179,6226,6224,6178,-1,6187,6190,6191,6189,-1,6171,6193,6190,6170,-1,6193,6224,6225,6192,-1,6192,6586,6583,6191,-1,6196,6584,6585,6195,-1,6189,6255,6256,6188,-1,6255,6583,6584,6258,-1,6197,6198,6199,6196,-1,6200,6257,6258,6199,-1,6201,6204,6205,6203,-1,6206,6590,6587,6205,-1,6210,6588,6589,6209,-1,6203,6239,6240,6202,-1,6239,6587,6588,6242,-1,6211,6212,6213,6210,-1,6214,6241,6242,6213,-1,6212,6235,6236,6214,-1,6208,6238,6235,6211,-1,6216,6237,6238,6215,-1,6209,6217,6215,6208,-1,6217,6231,6232,6216,-1,6231,6589,6590,6234,-1,6247,6585,6586,6250,-1,6226,6249,6250,6225,-1,6195,6223,6221,6194,-1,6223,6247,6248,6222,-1,6198,6251,6252,6200,-1,6194,6254,6251,6197,-1,6222,6253,6254,6221,-1,6204,6230,6227,6207,-1,6202,6229,6230,6201,-1,6229,6252,6253,6228,-1,6207,6218,6219,6206,-1,6218,6227,6228,6220,-1,6220,6233,6234,6219,-1,6260,6712,6713,6259,-1,6035,6263,6034,-1,6034,6685,6683,6037,-1,6266,6684,6685,6265,-1,6038,6492,6489,6040,-1,6492,6683,6684,6491,-1,6267,6268,6269,6266,-1,6270,6490,6491,6269,-1,6142,6793,6794,6145,-1,6273,6795,6792,6272,-1,6275,6276,6277,6274,-1,6146,6281,6282,6149,-1,6281,6794,6795,6280,-1,6148,6283,6284,6147,-1,6286,6287,6288,6285,-1,6138,6292,6293,6141,-1,6018,6291,6292,6017,-1,6241,6815,6814,6240,-1,6712,5987,6815,6711,-1,6257,6385,6384,6256,-1,6385,6814,5984,-1,6294,6530,6384,-1,6387,6489,6490,6386,-1,6388,6731,6732,6387,-1,6041,6732,6733,6043,-1,6393,6733,6734,6395,-1,7182,6745,6271,-1,6390,6394,6395,6389,-1,6389,6734,6731,6392,-1,6386,6391,6392,6388,-1,6391,6745,6014,6390,-1,6265,6735,6736,6264,-1,6737,6750,6751,6736,-1,6398,6753,6750,6397,-1,6403,6751,6752,6405,-1,6400,6404,6405,6399,-1,6399,6752,6753,6402,-1,6396,6401,6402,6398,-1,6401,6832,6833,6400,-1,6411,6412,6413,6410,-1,6397,6415,6412,6396,-1,6415,6739,6740,6414,-1,6417,6418,6419,6416,-1,6276,6596,6597,6278,-1,6421,6424,6422,6420,-1,6291,6775,6773,6293,-1,6774,6824,6825,6773,-1,6793,6825,6826,6792,-1,6426,6826,6824,6425,-1,6428,6431,6429,6427,-1,6431,6432,6433,6430,-1,5998,6442,6440,6263,-1,6438,6737,6735,6437,-1,6437,6440,6441,6439,-1,6435,6738,6739,6434,-1,6434,6438,6439,6436,-1,6436,6441,6442,6435,-1,6418,6443,6444,6421,-1,6443,6448,6449,6445,-1,6407,6447,6448,6406,-1,6447,6451,6452,6446,-1,6445,6456,6453,6444,-1,6446,6455,6456,6449,-1,6450,6454,6455,6452,-1,6424,6457,6458,6423,-1,6457,6461,6462,6459,-1,6460,6741,6742,6462,-1,6459,6742,6743,6458,-1,6259,6764,6761,6261,-1,6741,6762,6763,6743,-1,6262,6761,6762,6537,-1,6461,6463,6464,6460,-1,6454,6465,6463,6453,-1,6465,6466,6467,6464,-1,6466,6471,6472,6468,-1,6477,5999,6537,6476,-1,6468,6479,6476,6467,-1,6469,6478,6479,6472,-1,6474,6740,6738,6473,-1,6473,6477,6478,6475,-1,6470,6474,6475,6469,-1,6481,6009,6007,-1,6482,6483,6484,6481,-1,6485,6011,6008,6484,-1,6483,6720,6718,6485,-1,6493,6494,6495,6001,-1,6033,6497,6494,6032,-1,6496,6722,6000,6495,-1,6719,6725,6726,6718,-1,6722,6724,6725,6721,-1,6723,6744,6010,6726,-1,7184,6744,6502,-1,6030,6727,6728,6033,-1,6394,6730,6727,6393,-1,6730,6015,6012,6729,-1,6499,6723,6724,6498,-1,6497,6501,6498,6496,-1,6501,6728,6729,6500,-1,6500,6013,6502,6499,-1,6280,6705,6706,6279,-1,6274,6704,6705,6273,-1,6595,6633,6634,6597,-1,6592,6713,6711,6591,-1,6237,6594,6591,6236,-1,6539,6635,6633,6538,-1,6538,6763,6764,6541,-1,6541,6592,6593,6540,-1,6544,6593,6594,6543,-1,6543,6654,6651,6542,-1,6233,6653,6654,6232,-1,6653,6658,6655,6652,-1,6249,6657,6658,6248,-1,6545,6655,6656};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_33()
		{
			int[] value = {6547,-1,6547,6555,6556,6546,-1,6548,6557,6555,6550,-1,6554,6651,6652,6553,-1,6546,6552,6553,6545,-1,6551,6558,6559,6554,-1,6540,6560,6561,6539,-1,6542,6559,6560,6544,-1,6295,6715,6530,-1,6563,6714,6296,-1,6289,6663,6664,6288,-1,6144,6791,6788,6143,-1,6285,6790,6791,6284,-1,6665,6789,6790,6664,-1,6565,6665,6663,6564,-1,6567,6706,6703,6570,-1,6534,6569,6570,6536,-1,6569,6574,6571,6568,-1,6557,6819,6816,6556,-1,6667,6816,6817,6666,-1,6552,6667,6668,6551,-1,6573,6578,6575,6572,-1,6577,6669,6666,6576,-1,6550,6659,6660,6549,-1,6657,6662,6659,6656,-1,6290,6609,6610,6289,-1,6612,6660,6661,6611,-1,6611,6636,6637,6610,-1,6562,6638,6639,6563,-1,6564,6637,6638,6566,-1,6580,6715,6714,6579,-1,6579,6639,6636,6582,-1,6582,6661,6662,6581,-1,6245,6580,6581,6244,-1,6558,6798,6799,6561,-1,6669,6797,6798,6668,-1,6535,6613,6614,6534,-1,6574,6614,6615,6573,-1,6578,6670,6671,6577,-1,6616,6672,6670,6615,-1,6599,6796,6797,6598,-1,6598,6671,6672,6600,-1,6704,6709,6710,6703,-1,6278,6708,6709,6277,-1,6536,6675,6673,6535,-1,6675,6710,6707,6674,-1,6606,6673,6674,6605,-1,6600,6607,6608,6599,-1,6607,6616,6613,6606,-1,6602,6707,6708,6601,-1,6601,6634,6635,6604,-1,6604,6799,6796,6603,-1,6603,6608,6605,6602,-1,6568,6677,6678,6567,-1,6279,6699,6700,6282,-1,6676,6702,6699,6678,-1,6150,6700,6701,6153,-1,6626,6701,6702,6625,-1,6154,6626,6627,6157,-1,6628,6807,6808,6627,-1,6810,6817,6818,6809,-1,6158,6808,6809,6160,-1,6807,6811,6812,6810,-1,6576,6812,6813,6575,-1,6572,6617,6618,6571,-1,6617,6813,6811,6620,-1,6620,6628,6625,6619,-1,6619,6676,6677,6618,-1,6283,6695,6696,6286,-1,6152,6698,6695,6151,-1,6697,6785,6786,6696,-1,6287,6786,6787,6290,-1,6803,6818,6819,6802,-1,6549,6801,6802,6548,-1,6800,6804,6805,6803,-1,6160,6805,6806,6159,-1,6630,6697,6698,6629,-1,6156,6632,6629,6155,-1,6632,6806,6804,6631,-1,6622,6787,6785,6621,-1,6621,6630,6631,6624,-1,6624,6800,6801,6623,-1,6609,6622,6623,6612,-1,6427,6641,6642,6426,-1,6640,6827,6828,6642,-1,6272,6828,6829,6275,-1,6423,6823,6820,6422,-1,6596,6822,6823,6595,-1,6822,6829,6827,6821,-1,6648,6820,6821,6647,-1,6650,6838,6839,6649,-1,6420,6648,6649,6419,-1,6644,6650,6647,6643,-1,6641,6646,6643,6640,-1,6430,6645,6646,6429,-1,6408,6644,6645,6409,-1,6680,6774,6775,6679,-1,6679,6022,6023,6682,-1,6425,6680,6681,6428,-1,6682,6850,6851,6681,-1,6271,6748,6749,5792,-1,6268,6747,6748,6270,-1,6687,6746,6747,6686,-1,6264,6689,6686,6267,-1,6404,6688,6689,6403,-1,6688,6691,6692,6687,-1,6746,6831,6853,6749,-1,6690,6830,6831,6692,-1,6852,6830,6694,-1,6297,6768,6562,-1,6717,6767,6298,-1,6414,6841,6842,6413,-1,6471,6754,6755,6470,-1,6756,6840,6841,6755,-1,6754,6849,6847,6757,-1,6757,6843,6844,6756,-1,6843,6847,6848,6846,-1,6840,6844,6845,6842,-1,6835,6845,6846,6834,-1,6759,6848,6849,6758,-1,6451,6760,6758,6450,-1,6760,6837,6836,6759,-1,6777,6788,6789,6776,-1,6140,6777,6778,6139,-1,6137,6784,8262,-1,6779,6021,6784,6778,-1,6329,6870,6783,6330,-1,6716,6780,6781,6717,-1,6780,6783,6020,6782,-1,6566,6769,6770,6565,-1,6767,6772,6769,6768,-1,6772,6781,6782,6771,-1,6771,6779,6776,6770,-1,6487,6719,6720,6486,-1,6005,6486,6482,-1,6003,6721,6487,-1,6851,6765,6432,6431,-1,6850,6766,6765,6851,-1,6024,6025,6766,6850,-1,6775,6291,6018,6019,-1,6640,6643,6647,-1,6826,6426,6642,-1,6272,6792,6826,-1,6142,6141,6293,6773,6825,-1,6716,6330,6783,6780,-1,6779,6771,6782,-1,6188,6256,6384,6530,-1,6715,6580,6245,6185,-1,6214,6236,6591,6711,-1,6815,6241,6214,-1,6229,6202,6814,-1,6385,6200,6252,-1,6202,6240,6814,-1,6385,6257,6200,-1,6669,6577,6671,6598,-1,6812,6576,6666,-1,6160,6809,6818,-1,6623,6801,6549,-1,6776,6789,6665,-1,6685,6034,6263,6440,-1,6735,6265,6685,-1,6474,6470,6755,6841,-1,6849,6754,6471,6466,-1,6457,6424,6421,6444,-1,6271,6745,6391,6386,-1,6434,6739,6415,6397,-1,6758,6849,6466,-1,6465,6454,6450,-1,6444,6453,6463,6461,-1,6473,6738,6435,6442,-1,6762,6741,6460,6464,-1,6595,6823,6423,6458,-1,6743,6763,6538,6633,-1,6040,6489,6387,-1,6393,6727,6030,6044,-1,6386,6270,6748,6271,-1,6718,6726,6010,6011,-1,6762,6464,6467,-1,6473,6442,5998,5999,-1,6713,6592,6541,6764,-1,6816,6667,6552,6546,-1,6656,6659,6550,6555,-1,6653,6233,6220,-1,6220,6228,6653,-1,6658,6653,6228,6253,-1,6237,6216,6232,-1,6543,6594,6237,-1,6657,6244,6581,-1,6657,6249,6226,6179,6244,-1,6678,6699,6279,6706,-1,6536,6570,6703,-1,6716,6299,6300,6330,-1,6533,6089,6365,-1,6848,6847,6849,-1,6844,6843,6846,6845,-1,6841,6840,6842,-1,6852,6853,6831,6830,-1,6828,6827,6829,-1,6825,6824,6826,-1,6821,6820,6823,6822,-1,6817,6816,6819,6818,-1,5984,6814,6815,5987,-1,6812,6811,6813,-1,6808,6807,6810,6809,-1,6805,6804,6806,-1,6801,6800,6803,6802,-1,6797,6796,6799,6798,-1,6793,6792,6795,6794,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_34()
		{
			int[] value = {6789,6788,6791,6790,-1,6786,6785,6787,-1,6022,7200,6872,6023,-1,7197,8262,6784,6021,-1,6870,7196,6020,6783,-1,6781,6780,6782,-1,6777,6776,6779,6778,-1,6774,6773,6775,-1,6770,6769,6772,6771,-1,6298,6767,6768,6297,-1,6762,6761,6764,6763,-1,6047,5995,5997,6035,-1,6048,6047,6035,6036,-1,5899,6039,6042,5976,-1,5979,6001,6002,5980,-1,5981,5980,6002,6004,-1,5982,6006,6857,8248,-1,6759,6758,6760,-1,6755,6754,6757,6756,-1,6751,6750,6753,6752,-1,6747,6746,6749,6748,-1,6014,6745,7182,8246,-1,6012,6015,5793,7183,-1,6744,7184,5794,6010,-1,6742,6741,6743,-1,6739,6738,6740,-1,6736,6735,6737,-1,6732,6731,6734,6733,-1,6728,6727,6730,6729,-1,6724,6723,6726,6725,-1,6721,6003,6000,6722,-1,6719,6718,6720,-1,8247,6008,6011,6855,-1,5805,8261,6329,6301,-1,8260,7195,6313,6332,-1,7194,8260,6332,6333,-1,6868,8259,6335,6337,-1,6867,8258,6339,6341,-1,6865,6866,6343,6345,-1,7193,6865,6345,6328,-1,6299,6716,6717,6298,-1,6078,6098,6096,6076,-1,6093,6312,6331,6074,-1,6532,6306,6095,6097,-1,6336,6351,6338,-1,6350,6086,6087,6363,-1,6348,6358,6509,6347,-1,6325,6347,6509,6324,-1,6362,6088,6090,6361,-1,6507,6356,6315,6316,-1,6126,6128,6480,6359,-1,6120,6122,6361,6090,-1,6118,6120,6090,6091,-1,6082,6102,6100,6080,-1,6105,6528,6103,-1,6527,6528,6105,6107,-1,6531,6532,6097,6099,-1,6080,6100,6098,6078,-1,6296,6714,6715,6295,-1,6712,6711,6713,-1,6027,6504,5990,5992,-1,6046,6503,6504,6027,-1,6119,5975,5974,6121,-1,6123,6121,5974,5919,-1,6129,6127,5910,5973,-1,5973,5907,6131,6129,-1,6089,6533,6111,-1,6526,6109,6111,6533,-1,6708,6707,6710,6709,-1,6704,6703,6706,6705,-1,6700,6699,6702,6701,-1,6696,6695,6698,6697,-1,6314,6319,6321,6316,-1,6521,6522,6376,6513,-1,6691,6690,6692,-1,6687,6686,6689,6688,-1,6684,6683,6685,-1,6680,6679,6682,6681,-1,6677,6676,6678,-1,6674,6673,6675,-1,6671,6670,6672,-1,6667,6666,6669,6668,-1,6664,6663,6665,-1,6660,6659,6662,6661,-1,6656,6655,6658,6657,-1,6652,6651,6654,6653,-1,6648,6647,6650,6649,-1,6644,6643,6646,6645,-1,6641,6640,6642,-1,6637,6636,6639,6638,-1,6634,6633,6635,-1,6630,6629,6632,6631,-1,6626,6625,6628,6627,-1,6622,6621,6624,6623,-1,6618,6617,6620,6619,-1,6614,6613,6616,6615,-1,6610,6609,6612,6611,-1,6606,6605,6608,6607,-1,6602,6601,6604,6603,-1,6599,6598,6600,-1,6596,6595,6597,-1,6592,6591,6594,6593,-1,6588,6587,6590,6589,-1,6584,6583,6586,6585,-1,6580,6579,6582,6581,-1,6576,6575,6578,6577,-1,6572,6571,6574,6573,-1,6568,6567,6570,6569,-1,6565,6564,6566,-1,6297,6562,6563,6296,-1,6559,6558,6561,6560,-1,6556,6555,6557,-1,6552,6551,6554,6553,-1,6549,6548,6550,-1,6546,6545,6547,-1,6543,6542,6544,-1,6539,6538,6541,6540,-1,6537,5999,5996,6262,-1,6535,6534,6536,-1,6312,6352,6334,6331,-1,6529,6531,6099,6101,-1,6381,6526,6533,6380,-1,6533,6365,6379,6380,-1,6305,6306,6532,6373,-1,6373,6532,6531,6371,-1,6371,6531,6529,6369,-1,6369,6529,6528,6368,-1,6367,6527,6526,6381,-1,6353,6377,6379,6365,-1,6311,6308,6377,6353,-1,6527,6367,6368,6528,-1,6295,6530,6294,-1,5988,6112,5985,-1,6082,6084,6104,6102,-1,6103,6528,6529,6101,-1,6084,6113,6106,6104,-1,6113,6114,6108,6106,-1,5991,5988,5985,-1,6114,6116,6110,6108,-1,6109,6526,6527,6107,-1,6376,6375,6511,6513,-1,6382,6378,6519,6518,-1,6383,6382,6518,6517,-1,6366,6383,6517,6516,-1,6366,6516,6512,-1,6370,6515,6372,-1,6374,6372,6515,6514,-1,6510,6304,6374,6514,-1,6378,6379,6525,6523,-1,6377,6376,6522,6524,-1,6379,6377,6524,6525,-1,6523,6520,6519,6378,-1,6522,6523,6525,6524,-1,6523,6522,6521,6520,-1,6370,6068,6515,-1,6521,6513,6060,6058,-1,6520,6521,6058,6056,-1,6519,6520,6056,6054,-1,6518,6519,6054,6050,-1,6517,6518,6050,6051,-1,6516,6517,6051,6072,-1,6512,6516,6072,6070,-1,6512,6070,6068,-1,6514,6515,6068,6066,-1,6510,6514,6066,6064,-1,6513,6511,6062,6060,-1,6512,6370,6366,-1,6370,6512,6068,-1,6303,6309,6310,6307,-1,6304,6510,6511,6375,-1,6510,6064,6062,6511,-1,6351,6364,6085,6086,-1,6327,6346,6326,-1,6324,6509,6506,6323,-1,6358,6355,6506,6509,-1,6363,6087,6088,6362,-1,6085,6364,6365,6089,-1,5870,6505,6488,6136,-1,5869,5882,6505,5870,-1,5882,5881,6320,6505,-1,6508,6506,6507,-1,6508,6507,6316,-1,6316,6321,6322,6508,-1,6508,6322,6323,6506,-1,6314,6315,6359,6480,-1,6506,6355,6356,6507,-1,5870,6136,5803,6863,-1,6133,5908,5972,6135,-1,6488,6505,6320,6318,-1,5983,8256,5803,6136,-1,5898,5975,6503,6046,-1,6116,6118,6091,6110,-1,5989,5990,6504,6115,-1,6504,6503,6117,6115,-1,6503,5975,6119,6117,-1,7184,6502,6013,6854,-1,6499,6498,6501,6500,-1,6495,6494,6497,6496,-1,6001,5979,5978,6493,-1,5977,5976,6042,6031,-1,6032,6493,5978,5977,6031,-1,6490,6489,6492,6491,-1,6039,5899,6048,6036,-1,6128,6130,6317,6480,-1,5972,5983,6135,-1,6132,6134,6488,6318,-1,6134,6136,6488,-1,6487,6486,6005,6003,-1,6009};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_35()
		{
			int[] value = {6856,7185,6007,-1,6484,6483,6485,-1,6481,6007,6005,6482,-1,6006,5982,5981,6004,-1,6319,6314,6480,6317,-1,6477,6476,6479,6478,-1,6474,6473,6475,-1,6470,6469,6472,6471,-1,6467,6466,6468,-1,6464,6463,6465,-1,6461,6460,6462,-1,6458,6457,6459,-1,6454,6453,6456,6455,-1,6451,6450,6452,-1,6447,6446,6449,6448,-1,6444,6443,6445,-1,6441,6440,6442,-1,6438,6437,6439,-1,6435,6434,6436,-1,6430,6429,6431,-1,6426,6425,6428,6427,-1,6423,6422,6424,-1,6419,6418,6421,6420,-1,6413,6412,6415,6414,-1,6404,6403,6405,-1,6400,6399,6402,6401,-1,6397,6396,6398,-1,6394,6393,6395,-1,6390,6389,6392,6391,-1,6387,6386,6388,-1,5985,6029,5991,-1,6294,6384,6385,5984,-1,6367,6383,6366,-1,6381,6382,6383,6367,-1,6380,6378,6382,6381,-1,6379,6378,6380,-1,6308,6376,6377,-1,6309,6375,6376,6308,-1,6303,6304,6375,6309,-1,6373,6374,6304,6305,-1,6371,6372,6374,6373,-1,6369,6370,6372,6371,-1,6368,6366,6370,6369,-1,6367,6366,6368,-1,6364,6353,6365,-1,6351,6352,6353,6364,-1,6336,6334,6352,6351,-1,8259,7194,6333,6335,-1,6363,6354,6349,6350,-1,6362,6357,6354,6363,-1,6361,6360,6357,6362,-1,6122,6124,6360,6361,-1,6124,6126,6359,6360,-1,6315,6357,6360,6359,-1,6358,6354,6355,-1,6349,6354,6358,6348,-1,6866,6867,6341,6343,-1,6356,6357,6315,-1,6355,6354,6357,6356,-1,8258,6868,6337,6339,-1,5919,5909,6125,6123,-1,6127,6125,5909,5910,-1,6312,6311,6353,6352,-1,6093,6094,6307,6310,-1,6086,6338,6351,-1,6350,6340,6338,6086,-1,6349,6342,6340,6350,-1,6348,6344,6342,6349,-1,6347,6346,6344,6348,-1,6326,6346,6347,6325,-1,6345,6346,6327,6328,-1,6343,6344,6346,6345,-1,6341,6342,6344,6343,-1,6339,6340,6342,6341,-1,6337,6338,6340,6339,-1,6335,6336,6338,6337,-1,6333,6334,6336,6335,-1,6332,6331,6334,6333,-1,6074,6331,6332,6313,-1,6301,6329,6330,6300,-1,6328,5861,6864,7193,-1,6327,5860,5861,6328,-1,6326,5875,5860,6327,-1,6325,5875,6326,-1,6324,5872,5875,6325,-1,6323,5871,5872,6324,-1,6322,5880,5871,6323,-1,6321,5881,5880,6322,-1,6319,6320,5881,6321,-1,6317,6318,6320,6319,-1,6130,6132,6318,6317,-1,5907,5908,6133,6131,-1,6315,6314,6316,-1,6074,6075,6092,6093,-1,6313,6302,6073,6074,-1,7195,6869,6302,6313,-1,6310,6311,6312,6093,-1,6309,6308,6311,6310,-1,6076,6096,6092,6075,-1,6095,6306,6307,6094,-1,6305,6303,6307,6306,-1,6304,6303,6305,-1,6301,6302,6869,5805,-1,6300,6073,6302,6301,-1,6299,6077,6073,6300,-1,6298,6079,6077,6299,-1,6297,6079,6298,-1,6296,6081,6079,6297,-1,6295,6112,6081,6296,-1,6294,5985,6112,6295,-1,5984,5985,6294,-1,5986,6029,5985,-1,6028,6029,5986,6260,-1,6292,6291,6293,-1,6017,6871,8263,6018,-1,6288,6287,6290,6289,-1,6284,6283,6286,6285,-1,6280,6279,6282,6281,-1,6277,6276,6278,-1,6273,6272,6275,6274,-1,6271,5792,7182,-1,6269,6268,6270,-1,6265,6264,6267,6266,-1,6263,6035,5997,5998,-1,5996,5994,6028,6261,6262,-1,6260,6259,6261,6028,-1,6256,6255,6258,6257,-1,6252,6251,6254,6253,-1,6248,6247,6250,6249,-1,6244,6243,6246,6245,-1,6240,6239,6242,6241,-1,6236,6235,6238,6237,-1,6232,6231,6234,6233,-1,6228,6227,6230,6229,-1,6225,6224,6226,-1,6222,6221,6223,-1,6219,6218,6220,-1,6216,6215,6217,-1,6213,6212,6214,-1,6209,6208,6211,6210,-1,6205,6204,6207,6206,-1,6202,6201,6203,-1,6199,6198,6200,-1,6195,6194,6197,6196,-1,6191,6190,6193,6192,-1,6188,6187,6189,-1,6185,6184,6186,-1,6181,6180,6183,6182,-1,6178,6177,6179,-1,6174,6173,6176,6175,-1,6170,6169,6172,6171,-1,6166,6165,6168,6167,-1,6162,6161,6164,6163,-1,6159,6158,6160,-1,6155,6154,6157,6156,-1,6151,6150,6153,6152,-1,6147,6146,6149,6148,-1,6143,6142,6145,6144,-1,6139,6138,6141,6140,-1,8262,7198,6016,6137,-1,6134,6135,5983,6136,-1,6132,6133,6135,6134,-1,6130,6131,6133,6132,-1,6128,6129,6131,6130,-1,6126,6127,6129,6128,-1,6124,6125,6127,6126,-1,6122,6123,6125,6124,-1,6120,6121,6123,6122,-1,6118,6119,6121,6120,-1,6116,6117,6119,6118,-1,6114,6115,6117,6116,-1,6113,5989,6115,6114,-1,6084,5988,5989,6113,-1,6083,6112,5988,6084,-1,6081,6112,6083,-1,6111,6091,6089,-1,6109,6110,6091,6111,-1,6107,6108,6110,6109,-1,6105,6106,6108,6107,-1,6103,6104,6106,6105,-1,6101,6102,6104,6103,-1,6099,6100,6102,6101,-1,6097,6098,6100,6099,-1,6095,6096,6098,6097,-1,6094,6092,6096,6095,-1,6093,6092,6094,-1,6088,6089,6091,6090,-1,6087,6085,6089,6088,-1,6086,6085,6087,-1,6082,6083,6084,-1,6080,6081,6083,6082,-1,6078,6079,6081,6080,-1,6076,6077,6079,6078,-1,6075,6073,6077,6076,-1,6074,6073,6075,-1,6071,6052,6049,6053,6055,6057,6059,6061,6063,6065,6067,6069,-1,6051,6052,6071,6072,-1,6072,6071,6069,6070,-1,6070,6069,6067,6068,-1,6068,6067,6065,6066,-1,6066,6065,6063,6064,-1,6064,6063,6061,6062,-1,6062,6061,6059,6060,-1,6060,6059,6057,6058,-1,6058,6057,6055,6056,-1,6056,6055,6053,6054,-1,6054,6053,6049,6050,-1,6050,6049,6052,6051,-1,6045,6048,5899,5897,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_36()
		{
			int[] value = {6026,6047,6048,6045,-1,6026,5993,5995,6047,-1,6045,6046,6027,6026,-1,5897,5898,6046,6045,-1,6042,6044,6031,-1,6039,6041,6043,6042,-1,6036,6038,6040,6039,-1,6035,6034,6037,6036,-1,6031,6030,6033,6032,-1,5994,5991,6029,6028,-1,5993,6026,6027,5992,-1,6025,6024,5806,8264,-1,6872,5806,6024,6023,-1,6022,6019,7199,7200,-1,7196,7197,6021,6020,-1,8263,7199,6019,6018,-1,6017,6016,7198,6871,-1,6015,6014,8246,5793,-1,7183,6854,6013,6012,-1,6011,6010,5794,6855,-1,8247,6856,6009,6008,-1,6006,6007,7185,6857,-1,6004,6005,6007,6006,-1,6002,6003,6005,6004,-1,6001,6000,6003,6002,-1,5997,5996,5999,5998,-1,5995,5996,5997,-1,5993,5994,5996,5995,-1,5992,5991,5994,5993,-1,5990,5991,5992,-1,5989,5988,5991,5990,-1,5985,5984,5987,5986,-1,6873,6874,6875,-1,6876,6877,6878,-1,6875,6879,6880,6873,-1,6873,6880,6881,6874,-1,6874,6881,6879,6875,-1,6880,6882,6883,6881,-1,6881,6883,6884,6879,-1,6879,6884,6882,6880,-1,6883,6885,6886,6884,-1,6884,6886,6887,6882,-1,6882,6887,6885,6883,-1,6887,6888,6889,6885,-1,6885,6889,6890,6886,-1,6886,6890,6888,6887,-1,6889,6878,6877,6890,-1,6888,6876,6878,6889,-1,6890,6877,6876,6888,-1,6891,6892,6893,-1,6894,6895,6896,-1,6893,6897,6898,6891,-1,6891,6898,6899,6892,-1,6892,6899,6897,6893,-1,6898,6900,6901,6899,-1,6899,6901,6902,6897,-1,6897,6902,6900,6898,-1,6901,6903,6904,6902,-1,6902,6904,6905,6900,-1,6900,6905,6903,6901,-1,6905,6906,6907,6903,-1,6903,6907,6908,6904,-1,6904,6908,6906,6905,-1,6907,6896,6895,6908,-1,6906,6894,6896,6907,-1,6908,6895,6894,6906,-1,6909,6910,6911,-1,6912,6913,6914,-1,6911,6915,6916,6909,-1,6909,6916,6917,6910,-1,6910,6917,6915,6911,-1,6916,6918,6919,6917,-1,6917,6919,6920,6915,-1,6915,6920,6918,6916,-1,6919,6921,6922,6920,-1,6920,6922,6923,6918,-1,6918,6923,6921,6919,-1,6923,6924,6925,6921,-1,6921,6925,6926,6922,-1,6922,6926,6924,6923,-1,6925,6914,6913,6926,-1,6924,6912,6914,6925,-1,6926,6913,6912,6924,-1,6927,6928,6929,-1,6930,6931,6932,-1,6929,6933,6934,6927,-1,6927,6934,6935,6928,-1,6928,6935,6933,6929,-1,6934,6936,6937,6935,-1,6935,6937,6938,6933,-1,6933,6938,6936,6934,-1,6937,6939,6940,6938,-1,6938,6940,6941,6936,-1,6936,6941,6939,6937,-1,6941,6942,6943,6939,-1,6939,6943,6944,6940,-1,6940,6944,6942,6941,-1,6943,6932,6931,6944,-1,6942,6930,6932,6943,-1,6944,6931,6930,6942,-1,6945,6946,6947,-1,6948,6949,6950,-1,6947,6951,6952,6945,-1,6945,6952,6953,6946,-1,6946,6953,6951,6947,-1,6952,6954,6955,6953,-1,6953,6955,6956,6951,-1,6951,6956,6954,6952,-1,6955,6957,6958,6956,-1,6956,6958,6959,6954,-1,6954,6959,6957,6955,-1,6959,6960,6961,6957,-1,6957,6961,6962,6958,-1,6958,6962,6960,6959,-1,6961,6950,6949,6962,-1,6960,6948,6950,6961,-1,6962,6949,6948,6960,-1,6963,6964,6965,-1,6965,6966,6967,6963,-1,6963,6967,6968,6964,-1,6964,6968,6966,6965,-1,6967,6969,6970,6968,-1,6968,6970,6971,6966,-1,6966,6971,6969,6967,-1,6970,6972,6973,6971,-1,6971,6973,6974,6969,-1,6969,6974,6972,6970,-1,6974,6975,6976,6972,-1,6972,6976,6977,6973,-1,6973,6977,6975,6974,-1,6978,6979,6980,-1,6980,6981,6982,6978,-1,6978,6982,6983,6979,-1,6979,6983,6981,6980,-1,6982,6984,6985,6983,-1,6983,6985,6986,6981,-1,6981,6986,6984,6982,-1,6985,6987,6988,6986,-1,6986,6988,6989,6984,-1,6984,6989,6987,6985,-1,6989,6990,6991,6987,-1,6987,6991,6992,6988,-1,6988,6992,6990,6989,-1,6993,6994,6995,-1,6996,6997,6998,6999,-1,6999,6998,7000,7001,-1,7001,7000,6997,6996,-1,6998,7002,7003,7000,-1,7000,7003,7004,6997,-1,6997,7004,7002,6998,-1,7003,7005,7006,7004,-1,7004,7006,7007,7002,-1,7002,7007,7005,7003,-1,7007,7008,7009,7005,-1,7005,7009,7010,7006,-1,7006,7010,7008,7007,-1,7009,6995,6994,7010,-1,7008,6993,6995,7009,-1,7010,6994,6993,7008,-1,7011,7012,7013,-1,7013,7014,7015,7011,-1,7011,7015,7016,7012,-1,7012,7016,7014,7013,-1,7015,7017,7018,7016,-1,7016,7018,7019,7014,-1,7014,7019,7017,7015,-1,7018,7020,7021,7019,-1,7019,7021,7022,7017,-1,7017,7022,7020,7018,-1,7023,7024,7025,-1,7026,7027,7028,-1,7025,7029,7030,7023,-1,7023,7030,7031,7024,-1,7024,7031,7029,7025,-1,7030,7032,7033,7031,-1,7031,7033,7034,7029,-1,7029,7034,7032,7030,-1,7033,7035,7036,7034,-1,7034,7036,7037,7032,-1,7032,7037,7035,7033,-1,7037,7038,7039,7035,-1,7035,7039,7040,7036,-1,7036,7040,7038,7037,-1,7039,7028,7027,7040,-1,7038,7026,7028,7039,-1,7040,7027,7026,7038,-1,7041,7042,7043,-1,7044,7045,7046,-1,7043,7047,7048,7041,-1,7041,7048,7049,7042,-1,7042,7049,7047,7043,-1,7048,7050,7051,7049,-1,7049,7051,7052,7047,-1,7047,7052,7050,7048,-1,7051,7053,7054,7052,-1,7052,7054,7055,7050,-1,7050,7055,7053,7051,-1,7055,7056,7057,7053,-1,7053,7057,7058,7054,-1,7054,7058,7056,7055,-1,7057,7046,7045,7058,-1,7056,7044,7046,7057,-1,7058,7045,7044,7056,-1,7059,7060,7061,7062,-1,7062};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_37()
		{
			int[] value = {7061,7063,7064,-1,7064,7063,7060,7059,-1,7061,7065,7066,7063,-1,7063,7066,7067,7060,-1,7060,7067,7065,7061,-1,7068,7069,7070,-1,7070,7071,7072,7068,-1,7068,7072,7073,7069,-1,7069,7073,7071,7070,-1,7072,7074,7075,7073,-1,7073,7075,7076,7071,-1,7071,7076,7074,7072,-1,7077,7078,7079,-1,7079,7080,7081,7077,-1,7077,7081,7082,7078,-1,7078,7082,7080,7079,-1,7081,7083,7084,7082,-1,7082,7084,7085,7080,-1,7080,7085,7083,7081,-1,7086,7087,7088,-1,7088,7089,7090,7086,-1,7086,7090,7091,7087,-1,7087,7091,7089,7088,-1,7090,7092,7093,7091,-1,7091,7093,7094,7089,-1,7089,7094,7092,7090,-1,6977,6976,6975,-1,6992,6991,6990,-1,7022,7021,7020,-1,7067,7066,7065,-1,7076,7075,7074,-1,7085,7084,7083,-1,7001,6996,6999,-1,7064,7059,7062,-1,7095,7096,7097,-1,7098,7099,7100,-1,7097,7101,7102,7095,-1,7095,7102,7103,7096,-1,7096,7103,7101,7097,-1,7102,7104,7105,7103,-1,7103,7105,7106,7101,-1,7101,7106,7104,7102,-1,7105,7107,7108,7106,-1,7106,7108,7109,7104,-1,7104,7109,7107,7105,-1,7109,7110,7111,7107,-1,7107,7111,7112,7108,-1,7108,7112,7110,7109,-1,7111,7100,7099,7112,-1,7110,7098,7100,7111,-1,7112,7099,7098,7110,-1,7113,7114,7115,-1,7115,7116,7117,7113,-1,7113,7117,7118,7114,-1,7114,7118,7116,7115,-1,7117,7119,7120,7118,-1,7118,7120,7121,7116,-1,7116,7121,7119,7117,-1,7120,7122,7123,7121,-1,7121,7123,7124,7119,-1,7119,7124,7122,7120,-1,7124,7125,7126,7122,-1,7122,7126,7127,7123,-1,7123,7127,7125,7124,-1,7128,7129,7130,-1,7131,7132,7133,7134,-1,7134,7133,7135,7136,-1,7136,7135,7132,7131,-1,7133,7137,7138,7135,-1,7135,7138,7139,7132,-1,7132,7139,7137,7133,-1,7138,7140,7141,7139,-1,7139,7141,7142,7137,-1,7137,7142,7140,7138,-1,7142,7143,7144,7140,-1,7140,7144,7145,7141,-1,7141,7145,7143,7142,-1,7144,7130,7129,7145,-1,7143,7128,7130,7144,-1,7145,7129,7128,7143,-1,7146,7147,7148,-1,7149,7150,7151,-1,7148,7152,7153,7146,-1,7146,7153,7154,7147,-1,7147,7154,7152,7148,-1,7153,7155,7156,7154,-1,7154,7156,7157,7152,-1,7152,7157,7155,7153,-1,7156,7158,7159,7157,-1,7157,7159,7160,7155,-1,7155,7160,7158,7156,-1,7160,7161,7162,7158,-1,7158,7162,7163,7159,-1,7159,7163,7161,7160,-1,7162,7151,7150,7163,-1,7161,7149,7151,7162,-1,7163,7150,7149,7161,-1,7164,7165,7166,-1,7167,7168,7169,-1,7166,7170,7171,7164,-1,7164,7171,7172,7165,-1,7165,7172,7170,7166,-1,7171,7173,7174,7172,-1,7172,7174,7175,7170,-1,7170,7175,7173,7171,-1,7174,7176,7177,7175,-1,7175,7177,7178,7173,-1,7173,7178,7176,7174,-1,7178,7179,7180,7176,-1,7176,7180,7181,7177,-1,7177,7181,7179,7178,-1,7180,7169,7168,7181,-1,7179,7167,7169,7180,-1,7181,7168,7167,7179,-1,7127,7126,7125,-1,7136,7131,7134,-1,7188,7187,7239,7251,-1,8251,5799,7252,7253,-1,7238,7247,7251,7239,-1,7244,7243,7253,7252,-1,7235,7236,7248,7237,-1,7221,7220,7246,7245,-1,7245,7248,7236,7221,-1,7244,7252,7251,7247,-1,7252,5799,7188,7251,-1,6860,7249,7250,5798,-1,7249,7242,7222,7250,-1,7223,7241,7234,7227,-1,7226,7223,7227,-1,7224,7240,7250,7222,-1,7240,7186,5798,7250,-1,7229,7231,7242,7249,-1,5797,7229,7249,6860,-1,7237,7248,7247,7238,-1,7248,7245,7244,7247,-1,7245,7246,7243,7244,-1,7223,7226,7224,-1,7241,7223,7222,7242,-1,7241,7242,7231,7233,-1,7234,7241,7233,-1,7186,7240,7239,7187,-1,7240,7224,7238,7239,-1,7224,7226,7237,7238,-1,7237,7226,7225,7235,-1,6859,7217,7228,8250,-1,7217,7216,7230,7228,-1,7216,7213,7232,7230,-1,7232,7213,7215,-1,7221,7236,7203,7202,-1,7236,7235,7205,7203,-1,7235,7225,7207,7205,-1,7225,7227,7209,7207,-1,7227,7234,7211,7209,-1,7232,7215,7211,7234,7233,-1,7233,7231,7230,7232,-1,7231,7229,7228,7230,-1,7229,5797,8250,7228,-1,7227,7225,7226,-1,7224,7222,7223,-1,7202,7219,7220,7221,-1,7213,7216,7214,-1,7211,7215,7212,-1,7219,7202,7201,-1,6859,6858,7218,7217,-1,7217,7218,7214,7216,-1,7212,7215,7213,7214,-1,7211,7212,7210,7209,-1,7209,7210,7208,7207,-1,7207,7208,7206,7205,-1,7205,7206,7204,7203,-1,7203,7204,7201,7202,-1,7271,7270,7279,7278,7277,-1,7268,7267,7280,-1,7267,7257,7259,7280,-1,7258,7192,7191,7260,-1,6863,7262,5804,-1,7256,8257,7192,7258,-1,7265,7268,7273,7274,-1,7270,7273,7268,7280,-1,7279,7270,7280,7259,-1,7278,7279,7259,7261,-1,7277,7278,7261,7263,-1,7271,7277,7263,7276,-1,7276,7275,7272,7271,-1,7275,7274,7272,-1,7273,7272,7274,-1,7272,7273,7270,7271,-1,7260,7191,5804,7262,-1,7267,7266,7269,-1,7255,6864,8257,7256,-1,7269,7254,7257,7267,-1,7267,7268,7265,7266,-1,6863,7264,7263,7262,-1,7262,7263,7261,7260,-1,7260,7261,7259,7258,-1,7258,7259,7257,7256,-1,7256,7257,7254,7255,-1,7355,7356,7366,7377,-1,8255,7355,7377,8256,-1,7365,5795,8248,7376,-1,7364,7365,7376,7375,-1,7363,7364,7375,7374,-1,7362,7363,7374,7373,-1,7361,7362,7373,7372,-1,7359,7361,7372,7371,-1,7360,7359,7371,7370,-1,7294,7360,7370,7293};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_38()
		{
			int[] value = {-1,7284,7290,7292,7369,-1,7281,7284,7369,7368,-1,7312,7281,7368,7313,-1,7357,7305,7304,7367,-1,7299,7357,7367,7301,-1,7356,7300,7302,7366,-1,8252,6861,7342,7358,-1,6862,7353,7350,5800,-1,7322,7324,7360,7294,-1,7334,5796,5795,7365,-1,7335,7334,7365,7364,-1,7336,7335,7364,7363,-1,7339,7336,7363,7362,-1,7338,7339,7362,7361,-1,7337,7338,7361,7359,-1,7324,7337,7359,7360,-1,7322,7294,7295,-1,7290,7284,7288,7286,-1,7341,7354,7358,7342,-1,7287,7288,7354,7340,-1,7353,6862,8252,7358,-1,7351,7353,7358,7354,-1,7352,7351,7354,7288,-1,7282,7352,7288,7283,-1,7311,7282,7281,7312,-1,7343,7307,7305,7357,-1,7298,7343,7357,7299,-1,7317,7296,7300,7356,-1,7316,7317,7356,7355,-1,7190,7316,7355,8255,-1,5796,7334,7333,8249,-1,7333,7334,7332,-1,7335,7331,7330,-1,7341,7340,7354,-1,7353,7351,7348,7350,-1,7346,7352,7282,-1,7351,7352,7346,7348,-1,7308,7309,7310,-1,7309,7344,7347,7310,-1,7344,7345,7349,7347,-1,7345,8253,7189,7349,-1,5800,7350,7349,7189,-1,7350,7348,7347,7349,-1,7348,7346,7310,7347,-1,7346,7282,7311,7310,-1,7343,7297,7309,7307,-1,7297,7314,7319,-1,7314,7315,7320,7319,-1,7315,5802,5801,7320,-1,8253,7345,7321,8254,-1,7345,7344,7318,7321,-1,7344,7309,7297,7318,-1,7343,7298,7297,-1,7284,7283,7288,-1,7342,6861,8251,7253,-1,7341,7342,7253,7243,-1,7340,7341,7243,7246,-1,7246,7220,7287,7340,-1,7329,7336,7328,-1,7336,7339,7327,7328,-1,7339,7338,7326,7327,-1,7338,7337,7325,7326,-1,7337,7324,7323,7325,-1,7323,7322,7295,-1,7336,7329,7331,7335,-1,7335,7330,7332,7334,-1,7220,7295,7287,-1,7287,7295,7285,-1,7219,7295,7220,-1,7332,7330,7214,-1,7331,7329,7212,-1,6858,8249,7333,7218,-1,7218,7333,7332,7214,-1,7331,7212,7214,7330,-1,7212,7329,7328,7210,-1,7210,7328,7327,7208,-1,7208,7327,7326,7206,-1,7206,7326,7325,7204,-1,7204,7325,7323,7201,-1,7201,7323,7219,-1,7323,7295,7219,-1,7324,7322,7323,-1,8254,7321,7320,5801,-1,7321,7318,7319,7320,-1,7319,7318,7297,-1,7296,7317,7314,-1,7317,7316,7315,7314,-1,7190,5802,7315,7316,-1,7314,7297,7296,-1,7313,7303,7306,7312,-1,7312,7306,7308,7311,-1,7311,7308,7310,-1,7309,7308,7307,-1,7307,7308,7306,7305,-1,7305,7306,7303,7304,-1,7301,7302,7300,7299,-1,7299,7300,7296,7298,-1,7298,7296,7297,-1,7285,7295,7294,7289,-1,7289,7294,7293,7291,-1,7291,7292,7290,7289,-1,7289,7290,7286,7285,-1,7286,7288,7287,-1,7287,7285,7286,-1,7284,7281,7283,-1,7283,7281,7282,-1,7723,6870,8261,-1,7886,8077,7431,7432,-1,7787,8127,7437,7438,-1,8126,7781,7434,7435,-1,8172,7533,7531,8178,-1,7686,7411,7410,7532,-1,8182,7537,7534,8171,-1,8187,8219,7536,-1,7678,7541,7538,8185,-1,7675,8188,7539,7540,-1,8089,7545,7542,7677,-1,8094,7676,7543,7544,-1,8023,7549,7546,8092,-1,8020,8095,7547,7548,-1,8200,7553,7550,8026,-1,8202,8021,7551,7552,-1,7577,7562,7555,-1,7571,7637,7556,7561,-1,7574,7558,7567,-1,7576,7566,7559,-1,7578,7568,7557,7640,-1,7575,7570,7563,-1,7580,7581,7584,7564,7569,-1,7587,7618,7572,7560,7565,-1,8051,8056,7975,-1,8109,7924,7582,7579,-1,7977,7585,7583,7649,-1,7644,7619,7586,7980,-1,7641,7979,7589,7617,-1,7652,7593,7590,7978,-1,7645,7591,7592,-1,7779,8208,7623,7646,-1,7981,7599,7597,7633,-1,7598,7624,7595,-1,7628,7613,7600,7984,-1,7625,7983,7603,7611,-1,7636,7607,7604,7982,-1,7629,7605,7606,-1,8209,8105,7608,-1,7632,7609,7602,-1,7937,8048,7626,7631,-1,7648,7615,7588,-1,8052,7642,7616,7647,-1,7621,7601,7612,-1,8158,8107,7653,-1,7381,7380,7654,8106,-1,8079,8129,7831,7834,-1,7885,7663,7660,8078,-1,8141,8080,7661,7662,-1,7780,7664,7884,-1,8222,8036,8220,7666,-1,7674,8099,7667,8189,-1,8103,7671,7668,8098,-1,7990,8216,8223,7669,7670,-1,8058,7682,7679,8184,-1,8180,8090,7680,7681,-1,8169,8073,7416,7413,-1,7786,7782,8125,-1,8128,7789,7783,-1,8124,7409,7408,7784,7788,-1,8083,7797,8145,8130,7658,-1,7828,7832,8131,8144,7791,-1,7796,7792,8147,-1,8146,7799,7793,-1,8082,8085,8087,8227,7794,7798,-1,7795,8226,7805,7806,7790,-1,8239,8236,7807,7804,8229,-1,7868,8134,7808,8235,-1,8038,8044,8232,7802,-1,8043,7813,7810,8233,-1,7811,7812,7837,7842,7800,-1,7995,8028,7991,7672,8102,-1,8214,7816,7814,8042,-1,7851,7855,7838,-1,8074,8168,8218,7819,-1,8040,7823,7821,8035,-1,8245,8075,7822,7825,-1,7824,8039,7803,7827,-1,7867,7871,7393,-1,7833,7830,7835,-1,7843,7839,7850,-1,7845,8154,8231,7801,7841,-1,7849,7846,7840,-1,7859,7860,8152,7844,-1,7989,8027,8137,7852,-1,7856,7853,8136,-1,8156,7931,7870,7861,-1,7656,8155,7655,-1,7866,7862,7873,-1,7872,7869,7863,-1,7402,7878,7875,7403,-1,8114,7880,7876,7877,-1,8112,7879,7405,-1,7394,7889,7395,-1,7887,7888,7426,-1,7895,8122,7427,7891,-1,8118,7892,7890,8116,-1,8119,8115,7881,8113,-1,8138,7896,7893,8117,-1,7406,8123,7894,7407,-1,8072,7961,8100,-1,7998,8193,7955,7933,8029,-1,7938,7987,7934,7954,-1,7953,7948};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_39()
		{
			int[] value = {8045,7936,-1,8049,8046,7947,7939,-1,8050,7941,7949,-1,8210,7950,7940,-1,7951,8213,8196,7942,-1,7952,8192,8062,7945,-1,7973,8033,7957,8108,-1,7958,8031,8004,7683,8057,-1,8170,8164,7959,8059,-1,8104,8097,7930,8069,-1,7963,7968,8008,7928,-1,8012,7965,7962,8071,-1,8204,8211,8060,8206,-1,8207,7969,7966,8011,-1,8064,8009,7967,7972,-1,8191,7992,8063,-1,8017,8006,8054,7943,-1,8016,8181,7684,8003,-1,8005,8030,7976,8055,-1,8032,7960,8163,8162,7956,-1,8000,8067,7929,8007,-1,8010,8066,7994,8001,-1,7997,8002,7993,8190,-1,8068,7999,7996,8101,-1,8096,8019,8013,8070,-1,8201,8205,8014,8022,-1,8197,8212,7554,8199,-1,8024,8091,8179,8015,-1,8198,8025,8018,8194,-1,8221,8215,8041,8034,-1,7418,7417,8076,8244,-1,8143,5792,6853,-1,8225,8086,8081,8140,-1,8166,8175,8111,8161,-1,8238,8150,8234,-1,8241,8151,8237,-1,8240,8228,8230,8153,8242,-1,7415,7414,8176,8173,-1,7430,7432,7431,-1,7424,7438,7425,-1,7433,7435,7434,-1,7436,7438,7437,-1,7531,7533,7532,7410,-1,7534,7537,7536,7535,-1,7538,7541,7540,7539,-1,7542,7545,7544,7543,-1,7546,7549,7548,7547,-1,7550,7553,7552,7551,-1,7555,7562,7561,7556,-1,7558,7574,7577,7555,-1,7562,7577,7576,7559,-1,7557,7568,7567,7558,-1,7570,7575,7574,7567,-1,7563,7570,7569,7564,-1,7566,7576,7575,7563,-1,7559,7566,7565,7560,-1,7560,7572,7571,7561,-1,7573,7638,7637,7571,-1,7556,7637,7640,7557,-1,7578,7640,7639,7579,-1,7568,7578,7580,7569,-1,7579,7582,7581,7580,-1,7572,7618,7620,7573,-1,7583,7585,7584,7581,-1,7564,7584,7587,7565,-1,7586,7619,7618,7587,-1,7585,7977,7980,7586,-1,7589,7979,7978,7590,-1,7582,7650,7649,7583,-1,7652,7978,7977,7649,-1,7590,7593,7592,7591,-1,7593,7652,7651,7594,-1,7597,7599,7598,7595,-1,7599,7981,7984,7600,-1,7603,7983,7982,7604,-1,7596,7634,7633,7597,-1,7636,7982,7981,7633,-1,7604,7607,7606,7605,-1,7607,7636,7635,7608,-1,7608,7630,7629,7606,-1,7605,7629,7632,7602,-1,7609,7632,7631,7610,-1,7602,7609,7611,7603,-1,7610,7626,7625,7611,-1,7628,7984,7983,7625,-1,7644,7980,7979,7641,-1,7619,7644,7643,7620,-1,7588,7615,7617,7589,-1,7616,7642,7641,7617,-1,7594,7646,7645,7592,-1,7591,7645,7648,7588,-1,7615,7648,7647,7616,-1,7601,7621,7624,7598,-1,7595,7624,7623,7596,-1,7622,7647,7646,7623,-1,7600,7613,7612,7601,-1,7614,7622,7621,7612,-1,7613,7628,7627,7614,-1,7653,8107,8106,7654,-1,7428,7657,7429,-1,7431,8077,8079,7428,-1,7659,8079,8078,7660,-1,7434,7883,7886,7432,-1,7885,8078,8077,7886,-1,7660,7663,7662,7661,-1,7663,7885,7884,7664,-1,7539,8188,8187,7536,-1,7666,8186,8189,7667,-1,7668,7671,7670,7669,-1,7543,7676,7675,7540,-1,7674,8189,8188,7675,-1,7541,7678,7677,7542,-1,7679,7682,7681,7680,-1,7535,7687,7686,7532,-1,7411,7686,7685,7412,-1,7634,8208,8209,7635,-1,8105,8209,7381,8106,-1,7650,7778,7779,7651,-1,7378,8208,7779,-1,7778,7924,7688,-1,7780,7884,7883,7781,-1,7781,8126,8125,7782,-1,7437,8127,8126,7435,-1,7789,8128,8127,7787,-1,7665,8139,7182,-1,7783,7789,7788,7784,-1,7786,8125,8128,7783,-1,7782,7786,7785,7780,-1,7784,7408,8139,7785,-1,7658,8130,8129,7659,-1,8130,8145,8144,8131,-1,7791,8144,8147,7792,-1,7799,8146,8145,7797,-1,7793,7799,7798,7794,-1,7796,8147,8146,7793,-1,7792,7796,7795,7790,-1,7794,8227,8226,7795,-1,7804,7807,7806,7805,-1,7790,7806,7809,7791,-1,7808,8134,8133,7809,-1,7810,7813,7812,7811,-1,7672,7991,7990,7670,-1,7814,7816,7818,7815,-1,7687,8167,8169,7685,-1,8167,8219,8218,8168,-1,8186,8220,8219,8187,-1,7819,8218,8220,7820,-1,7821,7823,7825,7822,-1,7824,7827,7826,7825,-1,7657,7834,7836,7392,-1,7831,8129,8131,7832,-1,7833,7835,7834,7831,-1,7828,8133,8132,7829,-1,7830,7833,7832,7828,-1,7829,7836,7835,7830,-1,7815,7838,7837,7812,-1,7839,7843,7842,7837,-1,7800,7842,7841,7801,-1,7840,7846,7845,7841,-1,7838,7847,7850,7839,-1,7843,7850,7849,7840,-1,7846,7849,7848,7844,-1,7817,7852,7851,7818,-1,7853,7856,7855,7851,-1,7856,8136,8135,7854,-1,7852,8137,8136,7853,-1,7655,8155,8158,7653,-1,8137,8157,8156,8135,-1,7931,8156,8155,7656,-1,7854,7858,7857,7855,-1,7847,7857,7859,7848,-1,7858,7861,7860,7859,-1,7862,7866,7865,7860,-1,7870,7931,7393,7871,-1,7861,7870,7873,7862,-1,7866,7873,7872,7863,-1,7867,8132,8134,7868,-1,7869,7872,7871,7867,-1,7863,7869,7868,7864,-1,7401,7403,7875,-1,7875,7878,7877,7876,-1,7878,7402,7405,7879,-1,7879,8112,8114,7877,-1,7395,7889,7888,7887,-1,7426,7888,7891,7427,-1,7889,7394,8116,7890,-1,8112,8120,8119,8113,-1,8115,8119,8118,8116,-1,8120,7404,8138,8117,-1,7896,8138,7184,-1,7427,8122,8121,7424,-1,7787,8121,8124,7788,-1,8123,7406,7409,8124,-1,7892,8118,8117,7893,-1,7890,7892,7895,7891,-1,7894,8123,8122,7895,-1,7893,7896,7407,7894,-1,7673,8100,8099,7674,-1,7667,8099,8098,7668,-1,7991,8028,8027,7989,-1,7985,8105,8107,7986,-1,7630,7985,7988,7631,-1,7932,8027,8029,7933,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_40()
		{
			int[] value = {7935,8158,8157,7932,-1,7934,7987,7986,7935,-1,7937,7988,7987,7938,-1,7936,8045,8048,7937,-1,7626,8048,8047,7627,-1,8046,8049,8052,8047,-1,7642,8052,8051,7643,-1,7941,8050,8049,7939,-1,7940,7950,7949,7941,-1,7944,7949,7951,7942,-1,7947,8046,8045,7948,-1,7939,7947,7946,7940,-1,7948,7953,7952,7945,-1,7933,7955,7954,7934,-1,7938,7954,7953,7936,-1,7924,8109,7689,-1,7690,8108,7957,-1,7682,8058,8057,7683,-1,7537,8182,8185,7538,-1,7678,8185,8184,7679,-1,8058,8184,8183,8059,-1,7958,8057,8059,7959,-1,7964,8097,8100,7961,-1,7930,7964,7963,7928,-1,7962,7965,7968,7963,-1,7950,8210,8213,7951,-1,8060,8211,8210,8061,-1,7945,8062,8061,7946,-1,7966,7969,7972,7967,-1,7970,8060,8063,7971,-1,7943,8054,8053,7944,-1,8050,8053,8056,8051,-1,7683,8004,8003,7684,-1,8005,8055,8054,8006,-1,8004,8031,8030,8005,-1,7957,8033,8032,7956,-1,7960,8032,8031,7958,-1,7973,8108,8109,7974,-1,7976,8030,8033,7973,-1,7975,8056,8055,7976,-1,7638,7975,7974,7639,-1,7955,8193,8192,7952,-1,8062,8192,8191,8063,-1,7928,8008,8007,7929,-1,7967,8009,8008,7968,-1,7971,8065,8064,7972,-1,8009,8064,8066,8010,-1,7992,8191,8190,7993,-1,7994,8066,8065,7992,-1,8097,8104,8103,8098,-1,7671,8103,8102,7672,-1,7929,8067,8069,7930,-1,8068,8101,8104,8069,-1,7999,8068,8067,8000,-1,7993,8002,8001,7994,-1,8000,8007,8010,8001,-1,7995,8102,8101,7996,-1,7998,8029,8028,7995,-1,7997,8190,8193,7998,-1,7996,7999,8002,7997,-1,7961,8072,8071,7962,-1,7676,8094,8093,7673,-1,8072,8093,8096,8070,-1,7547,8095,8094,7544,-1,8019,8096,8095,8020,-1,7551,8021,8020,7548,-1,8021,8202,8201,8022,-1,8203,8212,8211,8204,-1,7554,8203,8202,7552,-1,8204,8206,8205,8201,-1,7969,8207,8206,7970,-1,7965,8012,8011,7966,-1,8014,8205,8207,8011,-1,8013,8019,8022,8014,-1,8012,8071,8070,8013,-1,7680,8090,8089,7677,-1,7545,8089,8092,7546,-1,8090,8180,8179,8091,-1,7684,8181,8180,7681,-1,8196,8213,8212,8197,-1,7942,8196,8195,7943,-1,8197,8199,8198,8194,-1,7553,8200,8199,7554,-1,8023,8092,8091,8024,-1,7549,8023,8026,7550,-1,8025,8198,8200,8026,-1,8015,8179,8181,8016,-1,8018,8025,8024,8015,-1,8017,8195,8194,8018,-1,8006,8017,8016,8003,-1,7820,8036,8035,7821,-1,8036,8222,8221,8034,-1,7669,8223,8222,7666,-1,7816,8214,8217,7817,-1,7989,8217,8216,7990,-1,8215,8221,8223,8216,-1,8041,8215,8214,8042,-1,8043,8233,8232,8044,-1,7813,8043,8042,7814,-1,8037,8041,8044,8038,-1,8034,8037,8040,8035,-1,7823,8040,8039,7824,-1,7803,8039,8038,7802,-1,8073,8169,8168,8074,-1,8076,7417,7416,8073,-1,7822,8075,8074,7819,-1,8075,8245,8244,8076,-1,5792,8143,8142,7665,-1,7664,8142,8141,7662,-1,8080,8141,8140,8081,-1,7661,8080,8083,7658,-1,7797,8083,8082,7798,-1,8081,8086,8085,8082,-1,8143,6853,8225,8140,-1,8086,8225,8224,8084,-1,8088,8224,6852,-1,7956,8162,7691,-1,7692,8161,8111,-1,7807,8236,8235,7808,-1,7864,8149,8148,7865,-1,8149,8235,8234,8150,-1,8151,8241,8243,8148,-1,8150,8238,8237,8151,-1,8240,8242,8241,8237,-1,8236,8239,8238,8234,-1,8228,8240,8239,8229,-1,8152,8243,8242,8153,-1,7844,8152,8154,7845,-1,8153,8230,8231,8154,-1,8170,8183,8182,8171,-1,7533,8172,8171,7534,-1,8262,8178,7531,-1,8172,8178,7415,8173,-1,7724,8177,6870,7723,-1,8111,8175,8174,8110,-1,8176,7414,8177,8174,-1,7959,8164,8163,7960,-1,8162,8163,8166,8161,-1,8165,8176,8175,8166,-1,8164,8170,8173,8165,-1,7880,8114,8113,7881,-1,7876,7880,7399,-1,7881,8115,7397,-1,7825,7826,8159,8245,-1,8245,8159,8160,8244,-1,8244,8160,7419,7418,-1,7413,7412,7685,8169,-1,8041,8037,8034,-1,8036,7820,8220,-1,8220,8186,7666,-1,8219,8167,7687,7535,7536,-1,8174,8177,7724,8110,-1,8176,8165,8173,-1,7924,7778,7650,7582,-1,7579,7639,7974,8109,-1,8105,7985,7630,7608,-1,7608,7635,8209,-1,8208,7596,7623,-1,7646,7594,7779,-1,8208,7634,7596,-1,7594,7651,7779,-1,7992,8065,7971,8063,-1,8060,7970,8206,-1,8212,8203,7554,-1,7943,8195,8017,-1,8059,8183,8170,-1,7834,7657,7428,8079,-1,8079,7659,8129,-1,8235,8149,7864,7868,-1,7860,7865,8148,8243,-1,7838,7815,7818,7851,-1,7780,7785,8139,7665,-1,7791,7809,8133,7828,-1,7860,8243,8152,-1,7844,7848,7859,-1,7855,7857,7847,7838,-1,7836,7829,8132,7867,-1,7858,7854,8135,8156,-1,7852,7817,8217,7989,-1,8027,7932,8157,8137,-1,7781,7883,7434,-1,7438,7424,8121,7787,-1,7665,8142,7664,7780,-1,7405,7404,8120,8112,-1,7861,7858,8156,-1,7393,7392,7836,7867,-1,8158,7935,7986,8107,-1,7940,7946,8061,8210,-1,7949,7944,8053,8050,-1,7614,7627,8047,-1,8047,7622,7614,-1,7647,7622,8047,8052,-1,7626,7610,7631,-1,7631,7988,7937,-1,7975,7638,8051,-1,7638,7573,7620,7643,8051,-1,8100,7673,8093,8072,-1,8097,7964,7930,-1,7724,7694,7693,8110,-1,7759,7483,7927,-1,8243,8241,8242,-1,8239,8240,8237,8238,-1,8236,8234,8235,-1,8224,8225,6853,6852,-1,8223,8221,8222,-1,8220,8218,8219,-1,8216,8217,8214,8215,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_41()
		{
			int[] value = {8212,8213,8210,8211,-1,7381,8209,8208,7378,-1,8207,8205,8206,-1,8203,8204,8201,8202,-1,8200,8198,8199,-1,8196,8197,8194,8195,-1,8192,8193,8190,8191,-1,8188,8189,8186,8187,-1,8184,8185,8182,8183,-1,8181,8179,8180,-1,7417,6872,7200,7416,-1,7415,8178,8262,7197,-1,8177,7414,7196,6870,-1,8176,8174,8175,-1,8172,8173,8170,8171,-1,8169,8167,8168,-1,8165,8166,8163,8164,-1,7691,8162,8161,7692,-1,8157,8158,8155,8156,-1,7429,7391,7389,7441,-1,7430,7429,7441,7442,-1,7370,7436,7433,7293,-1,7374,7396,7395,7373,-1,7398,7396,7374,7375,-1,8248,6857,7400,7376,-1,8154,8152,8153,-1,8150,8151,8148,8149,-1,8146,8147,8144,8145,-1,8142,8143,8140,8141,-1,8246,7182,8139,7408,-1,7183,5793,7409,7406,-1,7404,5794,7184,8138,-1,8137,8135,8136,-1,8134,8132,8133,-1,8131,8129,8130,-1,8127,8128,8125,8126,-1,8123,8124,8121,8122,-1,8119,8120,8117,8118,-1,8116,7394,7397,8115,-1,8114,8112,8113,-1,6855,7405,7402,8247,-1,7695,7723,8261,5805,-1,7726,7707,7195,8260,-1,7727,7726,8260,7194,-1,7731,7729,8259,6868,-1,7735,7733,8258,6867,-1,7739,7737,6866,6865,-1,7722,7739,6865,7193,-1,7692,8111,8110,7693,-1,7470,7490,7492,7472,-1,7468,7725,7706,7487,-1,7491,7489,7700,7926,-1,7732,7745,7730,-1,7757,7481,7480,7744,-1,7741,7903,7752,7742,-1,7718,7903,7741,7719,-1,7755,7484,7482,7756,-1,7710,7709,7750,7901,-1,7753,7874,7522,7520,-1,7484,7755,7516,7514,-1,7485,7484,7514,7512,-1,7474,7494,7496,7476,-1,7497,7922,7499,-1,7501,7499,7922,7921,-1,7493,7491,7926,7925,-1,7472,7492,7494,7474,-1,7689,8109,8108,7690,-1,8107,8105,8106,-1,7386,7384,7898,7421,-1,7421,7898,7897,7440,-1,7515,7368,7369,7513,-1,7313,7368,7515,7517,-1,7367,7304,7521,7523,-1,7523,7525,7301,7367,-1,7505,7927,7483,-1,7927,7505,7503,7920,-1,8103,8104,8101,8102,-1,8099,8100,8097,8098,-1,8095,8096,8093,8094,-1,8091,8092,8089,8090,-1,7710,7715,7713,7708,-1,7907,7770,7916,7915,-1,8086,8084,8085,-1,8082,8083,8080,8081,-1,8079,8077,8078,-1,8075,8076,8073,8074,-1,8072,8070,8071,-1,8069,8067,8068,-1,8066,8064,8065,-1,8062,8063,8060,8061,-1,8059,8057,8058,-1,8055,8056,8053,8054,-1,8051,8052,8049,8050,-1,8047,8048,8045,8046,-1,8043,8044,8041,8042,-1,8039,8040,8037,8038,-1,8036,8034,8035,-1,8032,8033,8030,8031,-1,8029,8027,8028,-1,8025,8026,8023,8024,-1,8021,8022,8019,8020,-1,8017,8018,8015,8016,-1,8013,8014,8011,8012,-1,8009,8010,8007,8008,-1,8005,8006,8003,8004,-1,8001,8002,7999,8000,-1,7997,7998,7995,7996,-1,7994,7992,7993,-1,7991,7989,7990,-1,7987,7988,7985,7986,-1,7983,7984,7981,7982,-1,7979,7980,7977,7978,-1,7975,7976,7973,7974,-1,7971,7972,7969,7970,-1,7967,7968,7965,7966,-1,7963,7964,7961,7962,-1,7960,7958,7959,-1,7690,7957,7956,7691,-1,7954,7955,7952,7953,-1,7951,7949,7950,-1,7947,7948,7945,7946,-1,7944,7942,7943,-1,7941,7939,7940,-1,7938,7936,7937,-1,7934,7935,7932,7933,-1,7656,7390,7393,7931,-1,7930,7928,7929,-1,7725,7728,7746,7706,-1,7495,7493,7925,7923,-1,7774,7927,7920,7775,-1,7774,7773,7759,7927,-1,7767,7926,7700,7699,-1,7765,7925,7926,7767,-1,7763,7923,7925,7765,-1,7762,7922,7923,7763,-1,7775,7920,7921,7761,-1,7759,7773,7771,7747,-1,7747,7771,7702,7705,-1,7922,7762,7761,7921,-1,7688,7924,7689,-1,7379,7506,7382,-1,7496,7498,7478,7476,-1,7495,7923,7922,7497,-1,7498,7500,7507,7478,-1,7500,7502,7508,7507,-1,7379,7382,7385,-1,7502,7504,7510,7508,-1,7501,7921,7920,7503,-1,7907,7905,7769,7770,-1,7912,7913,7772,7776,-1,7911,7912,7776,7777,-1,7910,7911,7777,7760,-1,7906,7910,7760,-1,7766,7909,7764,-1,7908,7909,7766,7768,-1,7908,7768,7698,7904,-1,7917,7919,7773,7772,-1,7918,7916,7770,7771,-1,7919,7918,7771,7773,-1,7772,7913,7914,7917,-1,7918,7919,7917,7916,-1,7914,7915,7916,7917,-1,7909,7462,7764,-1,7452,7454,7907,7915,-1,7450,7452,7915,7914,-1,7448,7450,7914,7913,-1,7444,7448,7913,7912,-1,7445,7444,7912,7911,-1,7466,7445,7911,7910,-1,7464,7466,7910,7906,-1,7462,7464,7906,-1,7460,7462,7909,7908,-1,7458,7460,7908,7904,-1,7454,7456,7905,7907,-1,7760,7764,7906,-1,7462,7906,7764,-1,7701,7704,7703,7697,-1,7769,7905,7904,7698,-1,7905,7456,7458,7904,-1,7480,7479,7758,7745,-1,7720,7740,7721,-1,7717,7900,7903,7718,-1,7903,7900,7749,7752,-1,7756,7482,7481,7757,-1,7483,7759,7758,7479,-1,7530,7882,7899,7264,-1,7264,7899,7276,7263,-1,7899,7714,7275,7276,-1,7901,7900,7902,-1,7710,7901,7902,-1,7902,7716,7715,7710,-1,7900,7717,7716,7902,-1,7874,7753,7709,7708,-1,7901,7750,7749,7900,-1,6863,5803,7530,7264,-1,7529,7366,7302,7527,-1,7712,7714,7899,7882,-1,7530,5803,8256,7377,-1,7440,7897,7369,7292,-1,7504,7485,7512,7510,-1,7509,7898,7384,7383,-1,7509,7511,7897,7898,-1,7511,7513,7369,7897,-1,6854,7407,7896,7184,-1,7894,7895,7892,7893,-1,7890,7891,7888,7889,-1,7887,7372,7373,7395,-1,7425,7436,7370,7371,-1,7425,7371};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_42()
		{
			int[] value = {7372,7887,7426,-1,7885,7886,7883,7884,-1,7430,7442,7293,7433,-1,7874,7711,7524,7522,-1,7529,7377,7366,-1,7712,7882,7528,7526,-1,7882,7530,7528,-1,7397,7399,7880,7881,-1,7401,7185,6856,7403,-1,7879,7877,7878,-1,7876,7399,7401,7875,-1,7398,7375,7376,7400,-1,7711,7874,7708,7713,-1,7872,7873,7870,7871,-1,7869,7867,7868,-1,7865,7866,7863,7864,-1,7862,7860,7861,-1,7859,7857,7858,-1,7856,7854,7855,-1,7853,7851,7852,-1,7849,7850,7847,7848,-1,7846,7844,7845,-1,7842,7843,7840,7841,-1,7839,7837,7838,-1,7836,7834,7835,-1,7833,7831,7832,-1,7830,7828,7829,-1,7825,7823,7824,-1,7821,7822,7819,7820,-1,7818,7816,7817,-1,7814,7815,7812,7813,-1,7808,7809,7806,7807,-1,7799,7797,7798,-1,7795,7796,7793,7794,-1,7792,7790,7791,-1,7789,7787,7788,-1,7785,7786,7783,7784,-1,7782,7780,7781,-1,7385,7423,7379,-1,7378,7779,7778,7688,-1,7760,7777,7761,-1,7761,7777,7776,7775,-1,7775,7776,7772,7774,-1,7774,7772,7773,-1,7771,7770,7702,-1,7702,7770,7769,7703,-1,7703,7769,7698,7697,-1,7699,7698,7768,7767,-1,7767,7768,7766,7765,-1,7765,7766,7764,7763,-1,7763,7764,7760,7762,-1,7762,7760,7761,-1,7759,7747,7758,-1,7758,7747,7746,7745,-1,7745,7746,7728,7730,-1,7729,7727,7194,8259,-1,7744,7743,7748,7757,-1,7757,7748,7751,7756,-1,7756,7751,7754,7755,-1,7755,7754,7518,7516,-1,7754,7753,7520,7518,-1,7753,7754,7751,7709,-1,7749,7748,7752,-1,7742,7752,7748,7743,-1,7737,7735,6867,6866,-1,7709,7751,7750,-1,7750,7751,7748,7749,-1,7733,7731,6868,8258,-1,7517,7519,7303,7313,-1,7304,7303,7519,7521,-1,7746,7747,7705,7706,-1,7704,7701,7488,7487,-1,7745,7732,7480,-1,7480,7732,7734,7744,-1,7744,7734,7736,7743,-1,7743,7736,7738,7742,-1,7742,7738,7740,7741,-1,7719,7741,7740,7720,-1,7722,7721,7740,7739,-1,7739,7740,7738,7737,-1,7737,7738,7736,7735,-1,7735,7736,7734,7733,-1,7733,7734,7732,7731,-1,7731,7732,7730,7729,-1,7729,7730,7728,7727,-1,7727,7728,7725,7726,-1,7707,7726,7725,7468,-1,7694,7724,7723,7695,-1,7193,6864,7255,7722,-1,7722,7255,7254,7721,-1,7721,7254,7269,7720,-1,7720,7269,7719,-1,7719,7269,7266,7718,-1,7718,7266,7265,7717,-1,7717,7265,7274,7716,-1,7716,7274,7275,7715,-1,7715,7275,7714,7713,-1,7713,7714,7712,7711,-1,7711,7712,7526,7524,-1,7525,7527,7302,7301,-1,7710,7708,7709,-1,7487,7486,7469,7468,-1,7468,7467,7696,7707,-1,7707,7696,6869,7195,-1,7487,7706,7705,7704,-1,7704,7705,7702,7703,-1,7469,7486,7490,7470,-1,7488,7701,7700,7489,-1,7700,7701,7697,7699,-1,7699,7697,7698,-1,5805,6869,7696,7695,-1,7695,7696,7467,7694,-1,7694,7467,7471,7693,-1,7693,7471,7473,7692,-1,7692,7473,7691,-1,7691,7473,7475,7690,-1,7690,7475,7506,7689,-1,7689,7506,7379,7688,-1,7688,7379,7378,-1,7379,7423,7380,-1,7654,7380,7423,7422,-1,7687,7685,7686,-1,7412,8263,6871,7411,-1,7683,7684,7681,7682,-1,7679,7680,7677,7678,-1,7675,7676,7673,7674,-1,7672,7670,7671,-1,7668,7669,7666,7667,-1,7182,5792,7665,-1,7664,7662,7663,-1,7660,7661,7658,7659,-1,7392,7391,7429,7657,-1,7656,7655,7422,7388,7390,-1,7422,7655,7653,7654,-1,7651,7652,7649,7650,-1,7647,7648,7645,7646,-1,7643,7644,7641,7642,-1,7639,7640,7637,7638,-1,7635,7636,7633,7634,-1,7631,7632,7629,7630,-1,7627,7628,7625,7626,-1,7623,7624,7621,7622,-1,7620,7618,7619,-1,7617,7615,7616,-1,7614,7612,7613,-1,7611,7609,7610,-1,7608,7606,7607,-1,7604,7605,7602,7603,-1,7600,7601,7598,7599,-1,7597,7595,7596,-1,7594,7592,7593,-1,7590,7591,7588,7589,-1,7586,7587,7584,7585,-1,7583,7581,7582,-1,7580,7578,7579,-1,7576,7577,7574,7575,-1,7573,7571,7572,-1,7569,7570,7567,7568,-1,7565,7566,7563,7564,-1,7561,7562,7559,7560,-1,7557,7558,7555,7556,-1,7554,7552,7553,-1,7550,7551,7548,7549,-1,7546,7547,7544,7545,-1,7542,7543,7540,7541,-1,7538,7539,7536,7537,-1,7534,7535,7532,7533,-1,7531,7410,7198,8262,-1,7530,7377,7529,7528,-1,7528,7529,7527,7526,-1,7526,7527,7525,7524,-1,7524,7525,7523,7522,-1,7522,7523,7521,7520,-1,7520,7521,7519,7518,-1,7518,7519,7517,7516,-1,7516,7517,7515,7514,-1,7514,7515,7513,7512,-1,7512,7513,7511,7510,-1,7510,7511,7509,7508,-1,7508,7509,7383,7507,-1,7507,7383,7382,7478,-1,7478,7382,7506,7477,-1,7477,7506,7475,-1,7483,7485,7505,-1,7505,7485,7504,7503,-1,7503,7504,7502,7501,-1,7501,7502,7500,7499,-1,7499,7500,7498,7497,-1,7497,7498,7496,7495,-1,7495,7496,7494,7493,-1,7493,7494,7492,7491,-1,7491,7492,7490,7489,-1,7489,7490,7486,7488,-1,7488,7486,7487,-1,7484,7485,7483,7482,-1,7482,7483,7479,7481,-1,7481,7479,7480,-1,7478,7477,7476,-1,7476,7477,7475,7474,-1,7474,7475,7473,7472,-1,7472,7473,7471,7470,-1,7470,7471,7467,7469,-1,7469,7467,7468,-1,7463,7461,7459,7457,7455,7453,7451,7449,7447,7443,7446,7465,-1,7466,7465,7446,7445,-1,7464,7463,7465,7466,-1,7462,7461,7463,7464,-1,7460,7459,7461,7462,-1,7458,7457,7459,7460,-1,7456,7455};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_43()
		{
			int[] value = {7457,7458,-1,7454,7453,7455,7456,-1,7452,7451,7453,7454,-1,7450,7449,7451,7452,-1,7448,7447,7449,7450,-1,7444,7443,7447,7448,-1,7445,7446,7443,7444,-1,7291,7293,7442,7439,-1,7439,7442,7441,7420,-1,7441,7389,7387,7420,-1,7420,7421,7440,7439,-1,7439,7440,7292,7291,-1,7425,7438,7436,-1,7436,7437,7435,7433,-1,7433,7434,7432,7430,-1,7430,7431,7428,7429,-1,7426,7427,7424,7425,-1,7422,7423,7385,7388,-1,7386,7421,7420,7387,-1,8264,5806,7418,7419,-1,7417,7418,5806,6872,-1,7200,7199,7413,7416,-1,7414,7415,7197,7196,-1,7412,7413,7199,8263,-1,6871,7198,7410,7411,-1,5793,8246,7408,7409,-1,7406,7407,6854,7183,-1,6855,5794,7404,7405,-1,7402,7403,6856,8247,-1,6857,7185,7401,7400,-1,7400,7401,7399,7398,-1,7398,7399,7397,7396,-1,7396,7397,7394,7395,-1,7392,7393,7390,7391,-1,7391,7390,7389,-1,7389,7390,7388,7387,-1,7387,7388,7385,7386,-1,7386,7385,7384,-1,7384,7385,7382,7383,-1,7380,7381,7378,7379,-1,8267,8266,8265,-1,8270,8269,8268,-1,8265,8272,8271,8267,-1,8266,8273,8272,8265,-1,8267,8271,8273,8266,-1,8273,8275,8274,8272,-1,8271,8276,8275,8273,-1,8272,8274,8276,8271,-1,8276,8278,8277,8275,-1,8274,8279,8278,8276,-1,8275,8277,8279,8274,-1,8277,8281,8280,8279,-1,8278,8282,8281,8277,-1,8279,8280,8282,8278,-1,8282,8269,8270,8281,-1,8281,8270,8268,8280,-1,8280,8268,8269,8282,-1,8285,8284,8283,-1,8288,8287,8286,-1,8283,8290,8289,8285,-1,8284,8291,8290,8283,-1,8285,8289,8291,8284,-1,8291,8293,8292,8290,-1,8289,8294,8293,8291,-1,8290,8292,8294,8289,-1,8294,8296,8295,8293,-1,8292,8297,8296,8294,-1,8293,8295,8297,8292,-1,8295,8299,8298,8297,-1,8296,8300,8299,8295,-1,8297,8298,8300,8296,-1,8300,8287,8288,8299,-1,8299,8288,8286,8298,-1,8298,8286,8287,8300,-1,8303,8302,8301,-1,8306,8305,8304,-1,8301,8308,8307,8303,-1,8302,8309,8308,8301,-1,8303,8307,8309,8302,-1,8309,8311,8310,8308,-1,8307,8312,8311,8309,-1,8308,8310,8312,8307,-1,8312,8314,8313,8311,-1,8310,8315,8314,8312,-1,8311,8313,8315,8310,-1,8313,8317,8316,8315,-1,8314,8318,8317,8313,-1,8315,8316,8318,8314,-1,8318,8305,8306,8317,-1,8317,8306,8304,8316,-1,8316,8304,8305,8318,-1,8321,8320,8319,-1,8324,8323,8322,-1,8319,8326,8325,8321,-1,8320,8327,8326,8319,-1,8321,8325,8327,8320,-1,8327,8329,8328,8326,-1,8325,8330,8329,8327,-1,8326,8328,8330,8325,-1,8330,8332,8331,8329,-1,8328,8333,8332,8330,-1,8329,8331,8333,8328,-1,8331,8335,8334,8333,-1,8332,8336,8335,8331,-1,8333,8334,8336,8332,-1,8336,8323,8324,8335,-1,8335,8324,8322,8334,-1,8334,8322,8323,8336,-1,8339,8338,8337,-1,8342,8341,8340,-1,8337,8344,8343,8339,-1,8338,8345,8344,8337,-1,8339,8343,8345,8338,-1,8345,8347,8346,8344,-1,8343,8348,8347,8345,-1,8344,8346,8348,8343,-1,8348,8350,8349,8347,-1,8346,8351,8350,8348,-1,8347,8349,8351,8346,-1,8349,8353,8352,8351,-1,8350,8354,8353,8349,-1,8351,8352,8354,8350,-1,8354,8341,8342,8353,-1,8353,8342,8340,8352,-1,8352,8340,8341,8354,-1,8357,8356,8355,-1,8355,8359,8358,8357,-1,8356,8360,8359,8355,-1,8357,8358,8360,8356,-1,8360,8362,8361,8359,-1,8358,8363,8362,8360,-1,8359,8361,8363,8358,-1,8363,8365,8364,8362,-1,8361,8366,8365,8363,-1,8362,8364,8366,8361,-1,8364,8368,8367,8366,-1,8365,8369,8368,8364,-1,8366,8367,8369,8365,-1,8372,8371,8370,-1,8370,8374,8373,8372,-1,8371,8375,8374,8370,-1,8372,8373,8375,8371,-1,8375,8377,8376,8374,-1,8373,8378,8377,8375,-1,8374,8376,8378,8373,-1,8378,8380,8379,8377,-1,8376,8381,8380,8378,-1,8377,8379,8381,8376,-1,8379,8383,8382,8381,-1,8380,8384,8383,8379,-1,8381,8382,8384,8380,-1,8387,8386,8385,-1,8391,8390,8389,8388,-1,8393,8392,8390,8391,-1,8388,8389,8392,8393,-1,8392,8395,8394,8390,-1,8389,8396,8395,8392,-1,8390,8394,8396,8389,-1,8396,8398,8397,8395,-1,8394,8399,8398,8396,-1,8395,8397,8399,8394,-1,8397,8401,8400,8399,-1,8398,8402,8401,8397,-1,8399,8400,8402,8398,-1,8402,8386,8387,8401,-1,8401,8387,8385,8400,-1,8400,8385,8386,8402,-1,8405,8404,8403,-1,8403,8407,8406,8405,-1,8404,8408,8407,8403,-1,8405,8406,8408,8404,-1,8408,8410,8409,8407,-1,8406,8411,8410,8408,-1,8407,8409,8411,8406,-1,8411,8413,8412,8410,-1,8409,8414,8413,8411,-1,8410,8412,8414,8409,-1,8417,8416,8415,-1,8420,8419,8418,-1,8415,8422,8421,8417,-1,8416,8423,8422,8415,-1,8417,8421,8423,8416,-1,8423,8425,8424,8422,-1,8421,8426,8425,8423,-1,8422,8424,8426,8421,-1,8426,8428,8427,8425,-1,8424,8429,8428,8426,-1,8425,8427,8429,8424,-1,8427,8431,8430,8429,-1,8428,8432,8431,8427,-1,8429,8430,8432,8428,-1,8432,8419,8420,8431,-1,8431,8420,8418,8430,-1,8430,8418,8419,8432,-1,8435,8434,8433,-1,8438,8437,8436,-1,8433,8440,8439,8435,-1,8434,8441,8440,8433,-1,8435,8439,8441,8434,-1,8441,8443,8442,8440,-1,8439,8444,8443,8441,-1,8440,8442,8444,8439,-1,8444,8446,8445,8443,-1,8442,8447,8446,8444,-1,8443,8445,8447};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_44()
		{
			int[] value = {8442,-1,8445,8449,8448,8447,-1,8446,8450,8449,8445,-1,8447,8448,8450,8446,-1,8450,8437,8438,8449,-1,8449,8438,8436,8448,-1,8448,8436,8437,8450,-1,8454,8453,8452,8451,-1,8456,8455,8453,8454,-1,8451,8452,8455,8456,-1,8455,8458,8457,8453,-1,8452,8459,8458,8455,-1,8453,8457,8459,8452,-1,8462,8461,8460,-1,8460,8464,8463,8462,-1,8461,8465,8464,8460,-1,8462,8463,8465,8461,-1,8465,8467,8466,8464,-1,8463,8468,8467,8465,-1,8464,8466,8468,8463,-1,8471,8470,8469,-1,8469,8473,8472,8471,-1,8470,8474,8473,8469,-1,8471,8472,8474,8470,-1,8474,8476,8475,8473,-1,8472,8477,8476,8474,-1,8473,8475,8477,8472,-1,8480,8479,8478,-1,8478,8482,8481,8480,-1,8479,8483,8482,8478,-1,8480,8481,8483,8479,-1,8483,8485,8484,8482,-1,8481,8486,8485,8483,-1,8482,8484,8486,8481,-1,8367,8368,8369,-1,8382,8383,8384,-1,8412,8413,8414,-1,8457,8458,8459,-1,8466,8467,8468,-1,8475,8476,8477,-1,8391,8388,8393,-1,8454,8451,8456,-1,8489,8488,8487,-1,8492,8491,8490,-1,8487,8494,8493,8489,-1,8488,8495,8494,8487,-1,8489,8493,8495,8488,-1,8495,8497,8496,8494,-1,8493,8498,8497,8495,-1,8494,8496,8498,8493,-1,8498,8500,8499,8497,-1,8496,8501,8500,8498,-1,8497,8499,8501,8496,-1,8499,8503,8502,8501,-1,8500,8504,8503,8499,-1,8501,8502,8504,8500,-1,8504,8491,8492,8503,-1,8503,8492,8490,8502,-1,8502,8490,8491,8504,-1,8507,8506,8505,-1,8505,8509,8508,8507,-1,8506,8510,8509,8505,-1,8507,8508,8510,8506,-1,8510,8512,8511,8509,-1,8508,8513,8512,8510,-1,8509,8511,8513,8508,-1,8513,8515,8514,8512,-1,8511,8516,8515,8513,-1,8512,8514,8516,8511,-1,8514,8518,8517,8516,-1,8515,8519,8518,8514,-1,8516,8517,8519,8515,-1,8522,8521,8520,-1,8526,8525,8524,8523,-1,8528,8527,8525,8526,-1,8523,8524,8527,8528,-1,8527,8530,8529,8525,-1,8524,8531,8530,8527,-1,8525,8529,8531,8524,-1,8531,8533,8532,8530,-1,8529,8534,8533,8531,-1,8530,8532,8534,8529,-1,8532,8536,8535,8534,-1,8533,8537,8536,8532,-1,8534,8535,8537,8533,-1,8537,8521,8522,8536,-1,8536,8522,8520,8535,-1,8535,8520,8521,8537,-1,8540,8539,8538,-1,8543,8542,8541,-1,8538,8545,8544,8540,-1,8539,8546,8545,8538,-1,8540,8544,8546,8539,-1,8546,8548,8547,8545,-1,8544,8549,8548,8546,-1,8545,8547,8549,8544,-1,8549,8551,8550,8548,-1,8547,8552,8551,8549,-1,8548,8550,8552,8547,-1,8550,8554,8553,8552,-1,8551,8555,8554,8550,-1,8552,8553,8555,8551,-1,8555,8542,8543,8554,-1,8554,8543,8541,8553,-1,8553,8541,8542,8555,-1,8558,8557,8556,-1,8561,8560,8559,-1,8556,8563,8562,8558,-1,8557,8564,8563,8556,-1,8558,8562,8564,8557,-1,8564,8566,8565,8563,-1,8562,8567,8566,8564,-1,8563,8565,8567,8562,-1,8567,8569,8568,8566,-1,8565,8570,8569,8567,-1,8566,8568,8570,8565,-1,8568,8572,8571,8570,-1,8569,8573,8572,8568,-1,8570,8571,8573,8569,-1,8573,8560,8561,8572,-1,8572,8561,8559,8571,-1,8571,8559,8560,8573,-1,8517,8518,8519,-1,8526,8523,8528,-1,8576,8577,8578,8575,-1,8580,8581,8582,8579,-1,8584,8585,8586,8583,-1,8588,8589,8590,8587,-1,8592,8593,8594,8591,-1,8596,8597,8598,8595,-1,8600,8601,8602,8599,-1,8604,8605,8606,8603,-1,8608,8609,8610,8607,-1,8612,8613,8614,8611,-1,8616,8617,8618,8615,-1,8620,8621,8622,8619,-1,8624,8625,8626,8623,-1,8628,8629,8630,8627,-1,8632,8633,8634,8631,-1,8636,8637,8638,8635,-1,8640,8641,8642,8639,-1,8644,8645,8646,8643,-1,8648,8649,8650,8647,-1,8652,8653,8654,8651,-1,8656,8657,8658,8655,-1,8660,8661,8662,8659,-1,8664,8665,8666,8663,-1,8668,8669,8670,8667,-1,8672,8673,8674,8671,-1,8676,8677,8678,8675,-1,8673,8625,8676,-1,8669,8626,8672,-1,8665,8623,8668,-1,8677,8624,8664,-1,8657,8585,8660,-1,8653,8586,8656,-1,8649,8583,8652,-1,8661,8584,8648,-1,8641,8609,8644,-1,8637,8610,8640,-1,8633,8607,8636,-1,8645,8608,8632,-1,8674,8675,8581,8628,-1,8621,8582,8678,8663,-1,8617,8579,8620,-1,8629,8580,8616,-1,8642,8643,8577,8612,-1,8605,8578,8646,8631,-1,8601,8575,8604,-1,8613,8576,8600,-1,8630,8615,8587,8595,-1,8671,8627,8598,8670,-1,8622,8666,8667,8593,-1,8592,8588,8618,8619,-1,8614,8599,8589,8591,-1,8639,8611,8594,8638,-1,8606,8634,8635,8597,-1,8596,8590,8602,8603,-1,8625,8624,8677,8676,-1,8626,8625,8673,8672,-1,8676,8675,8674,8673,-1,8623,8626,8669,8668,-1,8672,8671,8670,8669,-1,8624,8623,8665,8664,-1,8668,8667,8666,8665,-1,8664,8663,8678,8677,-1,8585,8584,8661,8660,-1,8586,8585,8657,8656,-1,8660,8659,8658,8657,-1,8583,8586,8653,8652,-1,8656,8655,8654,8653,-1,8584,8583,8649,8648,-1,8652,8651,8650,8649,-1,8648,8647,8662,8661,-1,8609,8608,8645,8644,-1,8610,8609,8641,8640,-1,8644,8643,8642,8641,-1,8607,8610,8637,8636,-1,8640,8639,8638,8637,-1,8608,8607,8633,8632,-1,8636,8635,8634,8633,-1,8632,8631,8646,8645,-1,8581,8580,8629,8628,-1,8582,8581,8675,8678,-1,8628,8627,8671,8674,-1,8579,8582,8621,8620,-1,8663,8666,8622,8621,-1,8580,8579,8617,8616,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_45()
		{
			int[] value = {8620,8619,8618,8617,-1,8616,8615,8630,8629,-1,8577,8576,8613,8612,-1,8578,8577,8643,8646,-1,8612,8611,8639,8642,-1,8575,8578,8605,8604,-1,8631,8634,8606,8605,-1,8576,8575,8601,8600,-1,8604,8603,8602,8601,-1,8600,8599,8614,8613,-1,8589,8588,8592,8591,-1,8587,8590,8596,8595,-1,8659,8662,8594,8593,-1,8651,8654,8598,8597,-1,8615,8618,8588,8587,-1,8627,8630,8595,8598,-1,8667,8670,8655,8658,-1,8619,8622,8593,8592,-1,8599,8602,8590,8589,-1,8611,8614,8591,8594,-1,8635,8638,8647,8650,-1,8603,8606,8597,8596,-1,8662,8647,8638,8594,-1,8658,8659,8593,8667,-1,8654,8655,8670,8598,-1,8650,8651,8597,8635,-1,8680,8681,8682,8679,-1,8684,8685,8686,8683,-1,8688,8689,8690,8687,-1,8692,8693,8694,8691,-1,8696,8697,8698,8695,-1,8700,8701,8702,8699,-1,8704,8705,8706,8703,-1,8708,8709,8710,8707,-1,8712,8713,8714,8711,-1,8716,8717,8718,8715,-1,8720,8721,8722,8719,-1,8724,8725,8726,8723,-1,8728,8729,8730,8727,-1,8732,8733,8734,8731,-1,8736,8737,8738,8735,-1,8740,8741,8742,8739,-1,8744,8745,8746,8743,-1,8748,8749,8750,8747,-1,8752,8753,8754,8751,-1,8756,8757,8758,8755,-1,8760,8761,8762,8759,-1,8764,8765,8766,8763,-1,8768,8769,8770,8767,-1,8772,8773,8774,8771,-1,8776,8777,8778,8775,-1,8780,8781,8782,8779,-1,8777,8729,8780,-1,8773,8730,8776,-1,8769,8727,8772,-1,8781,8728,8768,-1,8761,8689,8764,-1,8757,8690,8760,-1,8753,8687,8756,-1,8765,8688,8752,-1,8745,8713,8748,-1,8741,8714,8744,-1,8737,8711,8740,-1,8749,8712,8736,-1,8778,8779,8685,8732,-1,8725,8686,8782,8767,-1,8721,8683,8724,-1,8733,8684,8720,-1,8746,8747,8681,8716,-1,8709,8682,8750,8735,-1,8705,8679,8708,-1,8717,8680,8704,-1,8734,8719,8691,8699,-1,8775,8731,8702,8774,-1,8726,8770,8771,8697,-1,8696,8692,8722,8723,-1,8718,8703,8693,8695,-1,8743,8715,8698,8742,-1,8710,8738,8739,8701,-1,8700,8694,8706,8707,-1,8729,8728,8781,8780,-1,8730,8729,8777,8776,-1,8780,8779,8778,8777,-1,8727,8730,8773,8772,-1,8776,8775,8774,8773,-1,8728,8727,8769,8768,-1,8772,8771,8770,8769,-1,8768,8767,8782,8781,-1,8689,8688,8765,8764,-1,8690,8689,8761,8760,-1,8764,8763,8762,8761,-1,8687,8690,8757,8756,-1,8760,8759,8758,8757,-1,8688,8687,8753,8752,-1,8756,8755,8754,8753,-1,8752,8751,8766,8765,-1,8713,8712,8749,8748,-1,8714,8713,8745,8744,-1,8748,8747,8746,8745,-1,8711,8714,8741,8740,-1,8744,8743,8742,8741,-1,8712,8711,8737,8736,-1,8740,8739,8738,8737,-1,8736,8735,8750,8749,-1,8685,8684,8733,8732,-1,8686,8685,8779,8782,-1,8732,8731,8775,8778,-1,8683,8686,8725,8724,-1,8767,8770,8726,8725,-1,8684,8683,8721,8720,-1,8724,8723,8722,8721,-1,8720,8719,8734,8733,-1,8681,8680,8717,8716,-1,8682,8681,8747,8750,-1,8716,8715,8743,8746,-1,8679,8682,8709,8708,-1,8735,8738,8710,8709,-1,8680,8679,8705,8704,-1,8708,8707,8706,8705,-1,8704,8703,8718,8717,-1,8693,8692,8696,8695,-1,8691,8694,8700,8699,-1,8763,8766,8698,8697,-1,8755,8758,8702,8701,-1,8719,8722,8692,8691,-1,8731,8734,8699,8702,-1,8771,8774,8759,8762,-1,8723,8726,8697,8696,-1,8703,8706,8694,8693,-1,8715,8718,8695,8698,-1,8739,8742,8751,8754,-1,8707,8710,8701,8700,-1,8766,8751,8742,8698,-1,8762,8763,8697,8771,-1,8758,8759,8774,8702,-1,8754,8755,8701,8739,-1,8784,8785,8786,8783,-1,8788,8789,8790,8787,-1,8792,8793,8794,8791,-1,8796,8797,8798,8795,-1,8800,8801,8802,8799,-1,8804,8805,8806,8803,-1,8808,8809,8810,8807,-1,8812,8813,8814,8811,-1,8816,8817,8818,8815,-1,8820,8821,8822,8819,-1,8824,8825,8826,8823,-1,8828,8829,8830,8827,-1,8832,8833,8834,8831,-1,8836,8837,8838,8835,-1,8840,8841,8842,8839,-1,8844,8845,8846,8843,-1,8848,8849,8850,8847,-1,8852,8853,8854,8851,-1,8856,8857,8858,8855,-1,8860,8861,8862,8859,-1,8864,8865,8866,8863,-1,8868,8869,8870,8867,-1,8872,8873,8874,8871,-1,8876,8877,8878,8875,-1,8880,8881,8882,8879,-1,8884,8885,8886,8883,-1,8881,8833,8884,-1,8877,8834,8880,-1,8873,8831,8876,-1,8885,8832,8872,-1,8865,8793,8868,-1,8861,8794,8864,-1,8857,8791,8860,-1,8869,8792,8856,-1,8849,8817,8852,-1,8845,8818,8848,-1,8841,8815,8844,-1,8853,8816,8840,-1,8882,8883,8789,8836,-1,8829,8790,8886,8871,-1,8825,8787,8828,-1,8837,8788,8824,-1,8850,8851,8785,8820,-1,8813,8786,8854,8839,-1,8809,8783,8812,-1,8821,8784,8808,-1,8838,8823,8795,8803,-1,8879,8835,8806,8878,-1,8830,8874,8875,8801,-1,8800,8796,8826,8827,-1,8822,8807,8797,8799,-1,8847,8819,8802,8846,-1,8814,8842,8843,8805,-1,8804,8798,8810,8811,-1,8833,8832,8885,8884,-1,8834,8833,8881,8880,-1,8884,8883,8882,8881,-1,8831,8834,8877,8876,-1,8880,8879,8878,8877,-1,8832,8831,8873,8872,-1,8876,8875,8874,8873,-1,8872,8871,8886,8885,-1,8793,8792,8869,8868,-1,8794,8793,8865,8864,-1,8868,8867,8866,8865,-1,8791,8794,8861,8860,-1,8864,8863,8862,8861,-1,8792,8791,8857,8856,-1,8860,8859,8858,8857,-1,8856,8855,8870,8869,-1,8817,8816};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_46()
		{
			int[] value = {8853,8852,-1,8818,8817,8849,8848,-1,8852,8851,8850,8849,-1,8815,8818,8845,8844,-1,8848,8847,8846,8845,-1,8816,8815,8841,8840,-1,8844,8843,8842,8841,-1,8840,8839,8854,8853,-1,8789,8788,8837,8836,-1,8790,8789,8883,8886,-1,8836,8835,8879,8882,-1,8787,8790,8829,8828,-1,8871,8874,8830,8829,-1,8788,8787,8825,8824,-1,8828,8827,8826,8825,-1,8824,8823,8838,8837,-1,8785,8784,8821,8820,-1,8786,8785,8851,8854,-1,8820,8819,8847,8850,-1,8783,8786,8813,8812,-1,8839,8842,8814,8813,-1,8784,8783,8809,8808,-1,8812,8811,8810,8809,-1,8808,8807,8822,8821,-1,8797,8796,8800,8799,-1,8795,8798,8804,8803,-1,8867,8870,8802,8801,-1,8859,8862,8806,8805,-1,8823,8826,8796,8795,-1,8835,8838,8803,8806,-1,8875,8878,8863,8866,-1,8827,8830,8801,8800,-1,8807,8810,8798,8797,-1,8819,8822,8799,8802,-1,8843,8846,8855,8858,-1,8811,8814,8805,8804,-1,8870,8855,8846,8802,-1,8866,8867,8801,8875,-1,8862,8863,8878,8806,-1,8858,8859,8805,8843,-1,8888,8889,8890,8887,-1,8892,8893,8894,8891,-1,8896,8897,8898,8895,-1,8900,8901,8902,8899,-1,8904,8905,8906,8903,-1,8908,8909,8910,8907,-1,8912,8913,8914,8911,-1,8916,8917,8918,8915,-1,8920,8921,8922,8919,-1,8924,8925,8926,8923,-1,8928,8929,8930,8927,-1,8932,8933,8934,8931,-1,8936,8937,8938,8935,-1,8940,8941,8942,8939,-1,8944,8945,8946,8943,-1,8948,8949,8950,8947,-1,8952,8953,8954,8951,-1,8949,8897,8952,-1,8945,8898,8948,-1,8941,8895,8944,-1,8953,8896,8940,-1,8933,8950,8951,8936,-1,8929,8946,8947,8932,-1,8925,8942,8943,8928,-1,8937,8954,8939,8924,-1,8917,8934,8935,8920,-1,8913,8930,8931,8916,-1,8909,8926,8927,8912,-1,8921,8938,8923,8908,-1,8893,8906,8914,8915,-1,8894,8918,8919,8901,-1,8889,8902,8922,8907,-1,8890,8910,8911,8905,-1,8897,8896,8953,8952,-1,8898,8897,8949,8948,-1,8952,8951,8950,8949,-1,8895,8898,8945,8944,-1,8948,8947,8946,8945,-1,8896,8895,8941,8940,-1,8944,8943,8942,8941,-1,8940,8939,8954,8953,-1,8951,8954,8937,8936,-1,8947,8950,8933,8932,-1,8936,8935,8934,8933,-1,8943,8946,8929,8928,-1,8932,8931,8930,8929,-1,8939,8942,8925,8924,-1,8928,8927,8926,8925,-1,8924,8923,8938,8937,-1,8935,8938,8921,8920,-1,8931,8934,8917,8916,-1,8920,8919,8918,8917,-1,8927,8930,8913,8912,-1,8916,8915,8914,8913,-1,8923,8926,8909,8908,-1,8912,8911,8910,8909,-1,8908,8907,8922,8921,-1,8919,8922,8902,8901,-1,8911,8914,8906,8905,-1,8893,8892,8903,8906,-1,8894,8893,8915,8918,-1,8891,8894,8901,8900,-1,8889,8888,8899,8902,-1,8890,8889,8907,8910,-1,8887,8890,8905,8904,-1,8956,8957,8958,8959,8960,8961,8962,8955,-1,8956,8955,8892,8891,-1,8955,8962,8903,8892,-1,8962,8961,8904,8903,-1,8961,8960,8887,8904,-1,8960,8959,8888,8887,-1,8959,8958,8899,8888,-1,8958,8957,8900,8899,-1,8957,8956,8891,8900,-1,8964,8965,8966,8963,-1,8968,8969,8970,8967,-1,8972,8973,8974,8971,-1,8976,8977,8978,8975,-1,8980,8981,8982,8979,-1,8984,8985,8986,8983,-1,8988,8989,8990,8987,-1,8992,8993,8994,8991,-1,8996,8997,8998,8995,-1,9000,9001,9002,8999,-1,9004,9005,9006,9003,-1,9008,9009,9010,9007,-1,9012,9013,9014,9011,-1,9016,9017,9018,9015,-1,9020,9021,9022,9019,-1,9024,9025,9026,9023,-1,9028,9029,9030,9027,-1,9032,9033,9034,9031,-1,9036,9037,9038,9035,-1,9040,9041,9042,9039,-1,9043,9044,9951,9948,-1,9046,9047,9048,9045,-1,9043,9047,8968,-1,9040,9044,8967,-1,9036,9041,8970,-1,9046,9037,8969,-1,9028,9033,8984,-1,9024,9029,8983,-1,9020,9025,8986,-1,9032,9021,8985,-1,9012,9017,8996,-1,9008,9013,8995,-1,9004,9009,8998,-1,9016,9005,8997,-1,9018,9011,9001,8964,-1,8963,8992,9006,9015,-1,9049,8993,8966,-1,9000,9050,8965,-1,8989,9051,9034,-1,9052,8980,9031,-1,9054,8981,9055,9053,-1,8988,9057,9058,9056,-1,9060,8978,9059,-1,8975,9967,9951,9039,-1,9948,9478,8972,9048,-1,8973,9062,9061,-1,9064,8987,9065,9063,-1,8990,9023,9066,-1,8979,9067,9026,-1,9069,9070,8982,9068,-1,8969,8968,9047,9046,-1,8968,8967,9044,9043,-1,9048,9047,9043,9948,-1,8967,8970,9041,9040,-1,9951,9044,9040,9039,-1,8970,8969,9037,9036,-1,9042,9041,9036,9035,-1,9038,9037,9046,9045,-1,8985,8984,9033,9032,-1,8984,8983,9029,9028,-1,9034,9033,9028,9027,-1,8983,8986,9025,9024,-1,9030,9029,9024,9023,-1,8986,8985,9021,9020,-1,9026,9025,9020,9019,-1,9022,9021,9032,9031,-1,8997,8996,9017,9016,-1,8996,8995,9013,9012,-1,9018,9017,9012,9011,-1,8995,8998,9009,9008,-1,9014,9013,9008,9007,-1,8998,8997,9005,9004,-1,9010,9009,9004,9003,-1,9006,9005,9016,9015,-1,8965,8964,9001,9000,-1,8964,8963,9015,9018,-1,9002,9001,9011,9014,-1,8963,8966,8993,8992,-1,9003,9006,8992,8991,-1,8966,8965,9050,9049,-1,8994,8993,9049,9071,-1,9072,9050,9000,8999,-1,9056,9051,8989,8988,-1,9073,9074,9031,9034,-1,8990,8989,9027,9030,-1,9052,9055,8981,8980,-1,9019,9022,8980,8979,-1,8982,8981,9054,9068,-1,9064,9057,8988,8987,-1,9061,9075,8974,8973,-1,9076,9059};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_47()
		{
			int[] value = {8978,8977,-1,9045,9048,8972,8971,-1,9039,9042,8976,8975,-1,9062,9060,9059,9061,-1,9060,9967,8975,8978,-1,9478,9062,8973,8972,-1,8987,8990,9066,9065,-1,9023,9026,9078,9077,-1,8979,8982,9070,9067,-1,9042,9035,8976,-1,9019,8979,9026,-1,9022,9031,8980,-1,9003,8991,9010,-1,9014,9007,9002,-1,9027,8989,9034,-1,9030,9023,8990,-1,9045,8971,9038,-1,9076,8977,9070,9069,-1,8977,8976,9067,9070,-1,9078,9026,9067,-1,9074,9052,9031,-1,8991,8994,9055,9052,-1,8994,9071,9053,9055,-1,8976,9035,9067,-1,8991,9052,9010,-1,8971,9066,9038,-1,8971,8974,9065,9066,-1,8974,9075,9063,9065,-1,9072,8999,9056,9058,-1,8999,9002,9051,9056,-1,9002,9007,9051,-1,9023,9077,9066,-1,9034,9051,9073,-1,9007,9073,9051,-1,9007,9010,9074,9073,-1,9035,9038,9077,9078,-1,9038,9066,9077,-1,9035,9078,9067,-1,9010,9052,9074,-1,9071,9072,9058,9053,-1,9069,9063,9075,9076,-1,9063,9069,9068,9064,-1,9061,9059,9076,9075,-1,9053,9058,9057,9054,-1,9064,9068,9054,9057,-1,9049,9050,9072,9071,-1,9080,9081,9082,9079,-1,9084,9085,9086,9083,-1,9088,9089,9090,9087,-1,9092,9093,9094,9091,-1,9096,9097,9098,9095,-1,9100,9101,9102,9099,-1,9104,9105,9106,9103,-1,9108,9109,9110,9107,-1,9112,9113,9114,9111,-1,9116,9117,9118,9115,-1,9120,9121,9122,9119,-1,9124,9125,9126,9123,-1,9128,9129,9130,9127,-1,9132,9133,9134,9131,-1,9136,9137,9138,9135,-1,9140,9141,9142,9139,-1,9144,9145,9146,9143,-1,9148,9149,9150,9147,-1,9152,9153,9154,9151,-1,9156,9157,9158,9155,-1,9160,9161,9162,9159,-1,9164,9165,9166,9163,-1,9168,9169,9170,9167,-1,9172,9173,9174,9171,-1,9176,9177,9178,9175,-1,9180,9181,9182,9179,-1,9176,9181,9128,-1,9172,9177,9127,-1,9168,9173,9130,-1,9180,9169,9129,-1,9160,9165,9088,-1,9156,9161,9087,-1,9152,9157,9090,-1,9164,9153,9089,-1,9144,9149,9112,-1,9140,9145,9111,-1,9136,9141,9114,-1,9148,9137,9113,-1,9182,9175,9133,9084,-1,9083,9124,9170,9179,-1,9120,9125,9086,-1,9132,9121,9085,-1,9150,9143,9117,9080,-1,9079,9108,9138,9147,-1,9104,9109,9082,-1,9116,9105,9081,-1,9122,9131,9102,9094,-1,9134,9178,9171,9099,-1,9167,9123,9096,9174,-1,9093,9097,9126,9119,-1,9106,9115,9098,9092,-1,9118,9146,9139,9095,-1,9135,9107,9100,9142,-1,9091,9101,9110,9103,-1,9129,9128,9181,9180,-1,9128,9127,9177,9176,-1,9182,9181,9176,9175,-1,9127,9130,9173,9172,-1,9178,9177,9172,9171,-1,9130,9129,9169,9168,-1,9174,9173,9168,9167,-1,9170,9169,9180,9179,-1,9089,9088,9165,9164,-1,9088,9087,9161,9160,-1,9166,9165,9160,9159,-1,9087,9090,9157,9156,-1,9162,9161,9156,9155,-1,9090,9089,9153,9152,-1,9158,9157,9152,9151,-1,9154,9153,9164,9163,-1,9113,9112,9149,9148,-1,9112,9111,9145,9144,-1,9150,9149,9144,9143,-1,9111,9114,9141,9140,-1,9146,9145,9140,9139,-1,9114,9113,9137,9136,-1,9142,9141,9136,9135,-1,9138,9137,9148,9147,-1,9085,9084,9133,9132,-1,9084,9083,9179,9182,-1,9134,9133,9175,9178,-1,9083,9086,9125,9124,-1,9167,9170,9124,9123,-1,9086,9085,9121,9120,-1,9126,9125,9120,9119,-1,9122,9121,9132,9131,-1,9081,9080,9117,9116,-1,9080,9079,9147,9150,-1,9118,9117,9143,9146,-1,9079,9082,9109,9108,-1,9135,9138,9108,9107,-1,9082,9081,9105,9104,-1,9110,9109,9104,9103,-1,9106,9105,9116,9115,-1,9093,9092,9098,9097,-1,9091,9094,9102,9101,-1,9163,9166,9096,9095,-1,9155,9158,9100,9099,-1,9119,9122,9094,9093,-1,9131,9134,9099,9102,-1,9171,9174,9159,9162,-1,9123,9126,9097,9096,-1,9103,9106,9092,9091,-1,9115,9118,9095,9098,-1,9139,9142,9151,9154,-1,9107,9110,9101,9100,-1,9154,9163,9095,9139,-1,9166,9159,9174,9096,-1,9162,9155,9099,9171,-1,9158,9151,9142,9100,-1,9184,9185,9186,9183,-1,9188,9189,9190,9187,-1,9192,9193,9194,9191,-1,9196,9197,9198,9195,-1,9200,9201,9202,9199,-1,9204,9205,9206,9203,-1,9208,9209,9210,9207,-1,9212,9213,9214,9211,-1,9216,9217,9218,9215,-1,9220,9221,9222,9219,-1,9224,9225,9226,9223,-1,9228,9229,9230,9227,-1,9232,9233,9234,9231,-1,9236,9237,9238,9235,-1,9240,9241,9242,9239,-1,9244,9245,9246,9243,-1,9248,9249,9250,9247,-1,9252,9253,9254,9251,-1,9256,9257,9258,9255,-1,9260,9261,9262,9259,-1,9264,9265,9266,9263,-1,9268,9269,9270,9267,-1,9272,9273,9274,9271,-1,9276,9277,9278,9275,-1,9280,9281,9282,9279,-1,9284,9285,9286,9283,-1,9280,9285,9232,-1,9276,9281,9231,-1,9272,9277,9234,-1,9284,9273,9233,-1,9264,9269,9192,-1,9260,9265,9191,-1,9256,9261,9194,-1,9268,9257,9193,-1,9248,9253,9216,-1,9244,9249,9215,-1,9240,9245,9218,-1,9252,9241,9217,-1,9286,9279,9237,9188,-1,9187,9228,9274,9283,-1,9224,9229,9190,-1,9236,9225,9189,-1,9254,9247,9221,9184,-1,9183,9212,9242,9251,-1,9208,9213,9186,-1,9220,9209,9185,-1,9226,9235,9206,9198,-1,9238,9282,9275,9203,-1,9271,9227,9200,9278,-1,9197,9201,9230,9223,-1,9210,9219,9202,9196,-1,9222,9250,9243,9199,-1,9239,9211,9204,9246,-1,9195,9205,9214,9207,-1,9233,9232,9285,9284};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_48()
		{
			int[] value = {-1,9232,9231,9281,9280,-1,9286,9285,9280,9279,-1,9231,9234,9277,9276,-1,9282,9281,9276,9275,-1,9234,9233,9273,9272,-1,9278,9277,9272,9271,-1,9274,9273,9284,9283,-1,9193,9192,9269,9268,-1,9192,9191,9265,9264,-1,9270,9269,9264,9263,-1,9191,9194,9261,9260,-1,9266,9265,9260,9259,-1,9194,9193,9257,9256,-1,9262,9261,9256,9255,-1,9258,9257,9268,9267,-1,9217,9216,9253,9252,-1,9216,9215,9249,9248,-1,9254,9253,9248,9247,-1,9215,9218,9245,9244,-1,9250,9249,9244,9243,-1,9218,9217,9241,9240,-1,9246,9245,9240,9239,-1,9242,9241,9252,9251,-1,9189,9188,9237,9236,-1,9188,9187,9283,9286,-1,9238,9237,9279,9282,-1,9187,9190,9229,9228,-1,9271,9274,9228,9227,-1,9190,9189,9225,9224,-1,9230,9229,9224,9223,-1,9226,9225,9236,9235,-1,9185,9184,9221,9220,-1,9184,9183,9251,9254,-1,9222,9221,9247,9250,-1,9183,9186,9213,9212,-1,9239,9242,9212,9211,-1,9186,9185,9209,9208,-1,9214,9213,9208,9207,-1,9210,9209,9220,9219,-1,9197,9196,9202,9201,-1,9195,9198,9206,9205,-1,9267,9270,9200,9199,-1,9259,9262,9204,9203,-1,9223,9226,9198,9197,-1,9235,9238,9203,9206,-1,9275,9278,9263,9266,-1,9227,9230,9201,9200,-1,9207,9210,9196,9195,-1,9219,9222,9199,9202,-1,9243,9246,9255,9258,-1,9211,9214,9205,9204,-1,9258,9267,9199,9243,-1,9270,9263,9278,9200,-1,9266,9259,9203,9275,-1,9262,9255,9246,9204,-1,9288,9289,9290,9287,-1,9292,9293,9294,9291,-1,9296,9297,9298,9295,-1,9300,9301,9302,9299,-1,9304,9305,9306,9303,-1,9308,9309,9310,9307,-1,9312,9313,9314,9311,-1,9316,9317,9318,9315,-1,9320,9321,9322,9319,-1,9324,9325,9326,9323,-1,9328,9329,9330,9327,-1,9332,9333,9334,9331,-1,9336,9337,9338,9335,-1,9340,9341,9342,9339,-1,9344,9345,9346,9343,-1,9348,9349,9350,9347,-1,9352,9353,9354,9351,-1,9348,9353,9296,-1,9344,9349,9295,-1,9340,9345,9298,-1,9352,9341,9297,-1,9347,9332,9337,9354,-1,9343,9328,9333,9350,-1,9339,9324,9329,9346,-1,9351,9336,9325,9342,-1,9331,9316,9321,9338,-1,9327,9312,9317,9334,-1,9323,9308,9313,9330,-1,9335,9320,9309,9326,-1,9303,9292,9318,9311,-1,9315,9291,9300,9322,-1,9299,9288,9310,9319,-1,9307,9287,9304,9314,-1,9297,9296,9353,9352,-1,9296,9295,9349,9348,-1,9354,9353,9348,9347,-1,9295,9298,9345,9344,-1,9350,9349,9344,9343,-1,9298,9297,9341,9340,-1,9346,9345,9340,9339,-1,9342,9341,9352,9351,-1,9351,9354,9337,9336,-1,9347,9350,9333,9332,-1,9338,9337,9332,9331,-1,9343,9346,9329,9328,-1,9334,9333,9328,9327,-1,9339,9342,9325,9324,-1,9330,9329,9324,9323,-1,9326,9325,9336,9335,-1,9335,9338,9321,9320,-1,9331,9334,9317,9316,-1,9322,9321,9316,9315,-1,9327,9330,9313,9312,-1,9318,9317,9312,9311,-1,9323,9326,9309,9308,-1,9314,9313,9308,9307,-1,9310,9309,9320,9319,-1,9319,9322,9300,9299,-1,9311,9314,9304,9303,-1,9293,9292,9303,9306,-1,9292,9291,9315,9318,-1,9291,9294,9301,9300,-1,9289,9288,9299,9302,-1,9288,9287,9307,9310,-1,9287,9290,9305,9304,-1,9356,9357,9358,9359,9360,9361,9362,9355,-1,9362,9361,9294,9293,-1,9355,9362,9293,9306,-1,9356,9355,9306,9305,-1,9357,9356,9305,9290,-1,9358,9357,9290,9289,-1,9359,9358,9289,9302,-1,9360,9359,9302,9301,-1,9361,9360,9301,9294,-1,9364,9365,9366,9363,-1,9368,9369,9370,9367,-1,9371,9372,9367,9370,-1,9374,9375,9376,9373,-1,9377,9378,9369,9368,-1,9378,9377,9373,9376,-1,9363,9366,9372,9371,-1,9380,9381,9379,-1,9383,9384,9382,-1,9386,9387,9385,-1,9386,9383,9382,9387,-1,9380,9388,9389,9381,-1,9388,9390,9389,-1,9391,9389,9390,-1,9392,9385,9387,-1,9393,9390,9388,-1,9393,9394,9395,9390,-1,9394,9363,9371,9395,-1,9376,9396,9397,9378,-1,9396,9398,9385,9397,-1,9398,9386,9385,-1,9399,9380,9379,-1,9400,9384,9383,-1,9366,9401,9402,9372,-1,9401,9399,9379,9402,-1,9381,9403,9379,-1,9382,9384,9404,-1,9400,9405,9406,9384,-1,9405,9373,9377,9406,-1,9407,9386,9398,-1,9408,9409,9392,-1,9411,9391,9410,-1,9412,9393,9388,-1,9413,9380,9399,-1,9414,9415,9403,-1,9417,9404,9416,-1,9418,9400,9383,-1,9419,9416,9384,9406,-1,9404,9392,9387,9382,-1,9409,9420,9397,9385,-1,10271,9479,9422,9421,-1,10270,10269,9425,9424,-1,10269,10271,9375,9374,-1,9418,9426,9424,9400,-1,9427,9407,9398,9422,-1,9374,9373,9405,9425,-1,9376,9375,9421,9396,-1,9370,9369,9420,9428,-1,9429,9419,9368,9367,-1,9414,9417,9416,9415,-1,9402,9379,9415,9429,-1,9410,9409,9408,9411,-1,9381,9389,9391,9403,-1,9390,9395,9428,9410,-1,9364,9363,9394,9430,-1,9431,9401,9366,9365,-1,9432,9433,9365,9364,-1,9435,9413,9399,9434,-1,9433,9436,9434,9431,-1,9438,9393,9412,9437,-1,9436,9440,9441,9439,-1,9440,9432,9430,9438,-1,9443,9435,9439,9442,-1,9445,9380,9413,9444,-1,9446,9447,9444,9443,-1,9449,9412,9388,9448,-1,9447,9450,9448,9445,-1,9452,9441,9437,9451,-1,9450,9453,9451,9449,-1,9453,9446,9442,9452,-1,9455,9414,9403,9454,-1,9457,9404,9417,9456,-1,9458,9459,9456,9455,-1,9461,9408,9392,9460,-1,9459,9462,9460,9457};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_49()
		{
			int[] value = {-1,9464,9391,9411,9463,-1,9462,9465,9463,9461,-1,9465,9458,9454,9464,-1,9467,9386,9407,9466,-1,9469,9418,9383,9468,-1,9470,9471,9468,9467,-1,9473,8574,9426,9472,-1,9471,9474,9472,9469,-1,9476,9427,9423,9475,-1,9474,9477,9475,9473,-1,9477,9470,9466,9476,-1,9406,9377,9368,9419,-1,9416,9404,9384,-1,9409,9385,9392,-1,9420,9369,9378,9397,-1,9421,9375,10271,-1,9479,9423,9427,9422,-1,10270,9424,9426,8574,-1,10269,9374,9425,-1,9370,9428,9395,9371,-1,9429,9367,9372,9402,-1,9379,9403,9415,-1,9410,9391,9390,-1,9430,9432,9364,-1,9365,9433,9431,-1,9434,9436,9439,9435,-1,9437,9441,9440,9438,-1,9442,9446,9443,-1,9444,9447,9445,-1,9448,9450,9449,-1,9451,9453,9452,-1,9454,9458,9455,-1,9456,9459,9457,-1,9460,9462,9461,-1,9463,9465,9464,-1,9466,9470,9467,-1,9468,9471,9469,-1,9472,9474,9473,-1,9475,9477,9476,-1,9476,9466,9407,9427,-1,9473,9475,9423,8574,-1,9469,9472,9426,9418,-1,9467,9468,9383,9386,-1,9464,9454,9403,9391,-1,9461,9463,9411,9408,-1,9457,9460,9392,9404,-1,9455,9456,9417,9414,-1,9452,9442,9439,9441,-1,9449,9451,9437,9412,-1,9445,9448,9388,9380,-1,9443,9444,9413,9435,-1,9438,9430,9394,9393,-1,9446,9453,9450,9447,-1,9431,9434,9399,9401,-1,9410,9428,9420,9409,-1,9458,9465,9462,9459,-1,9429,9415,9416,9419,-1,9405,9400,9424,9425,-1,9421,9422,9398,9396,-1,9470,9477,9474,9471,-1,9432,9440,9436,9433,-1,9480,9483,9482,9481,-1,9484,9487,9486,9485,-1,9488,9491,9490,9489,-1,9492,9495,9494,9493,-1,9496,9499,9498,9497,-1,9500,9503,9502,9501,-1,9504,9507,9506,9505,-1,9508,9511,9510,9509,-1,9512,9515,9514,9513,-1,9516,9519,9518,9517,-1,9520,9523,9522,9521,-1,9524,9527,9526,9525,-1,9528,9531,9530,9529,-1,9532,9535,9534,9533,-1,9536,9539,9538,9537,-1,9540,9543,9542,9541,-1,9544,9547,9546,9545,-1,9548,9551,9550,9549,-1,9552,9555,9554,9553,-1,9556,9559,9558,9557,-1,9560,9563,9562,9561,-1,9564,9567,9566,9565,-1,9568,9571,9570,9569,-1,9572,9575,9574,9573,-1,9576,9579,9578,9577,-1,9580,9583,9582,9581,-1,9581,9530,9578,-1,9577,9531,9574,-1,9573,9528,9570,-1,9569,9529,9582,-1,9565,9490,9562,-1,9561,9491,9558,-1,9557,9488,9554,-1,9553,9489,9566,-1,9549,9514,9546,-1,9545,9515,9542,-1,9541,9512,9538,-1,9537,9513,9550,-1,9533,9486,9580,9579,-1,9568,9583,9487,9526,-1,9525,9484,9522,-1,9521,9485,9534,-1,9517,9482,9548,9547,-1,9536,9551,9483,9510,-1,9509,9480,9506,-1,9505,9481,9518,-1,9500,9492,9520,9535,-1,9575,9503,9532,9576,-1,9498,9572,9571,9527,-1,9524,9523,9493,9497,-1,9496,9494,9504,9519,-1,9543,9499,9516,9544,-1,9502,9540,9539,9511,-1,9508,9507,9495,9501,-1,9581,9582,9529,9530,-1,9577,9578,9530,9531,-1,9578,9579,9580,9581,-1,9573,9574,9531,9528,-1,9574,9575,9576,9577,-1,9569,9570,9528,9529,-1,9570,9571,9572,9573,-1,9582,9583,9568,9569,-1,9565,9566,9489,9490,-1,9561,9562,9490,9491,-1,9562,9563,9564,9565,-1,9557,9558,9491,9488,-1,9558,9559,9560,9561,-1,9553,9554,9488,9489,-1,9554,9555,9556,9557,-1,9566,9567,9552,9553,-1,9549,9550,9513,9514,-1,9545,9546,9514,9515,-1,9546,9547,9548,9549,-1,9541,9542,9515,9512,-1,9542,9543,9544,9545,-1,9537,9538,9512,9513,-1,9538,9539,9540,9541,-1,9550,9551,9536,9537,-1,9533,9534,9485,9486,-1,9583,9580,9486,9487,-1,9579,9576,9532,9533,-1,9525,9526,9487,9484,-1,9526,9527,9571,9568,-1,9521,9522,9484,9485,-1,9522,9523,9524,9525,-1,9534,9535,9520,9521,-1,9517,9518,9481,9482,-1,9551,9548,9482,9483,-1,9547,9544,9516,9517,-1,9509,9510,9483,9480,-1,9510,9511,9539,9536,-1,9505,9506,9480,9481,-1,9506,9507,9508,9509,-1,9518,9519,9504,9505,-1,9496,9497,9493,9494,-1,9500,9501,9495,9492,-1,9498,9499,9567,9564,-1,9502,9503,9559,9556,-1,9492,9493,9523,9520,-1,9503,9500,9535,9532,-1,9563,9560,9575,9572,-1,9497,9498,9527,9524,-1,9494,9495,9507,9504,-1,9499,9496,9519,9516,-1,9555,9552,9543,9540,-1,9501,9502,9511,9508,-1,9499,9543,9552,9567,-1,9572,9498,9564,9563,-1,9503,9575,9560,9559,-1,9540,9502,9556,9555,-1,9584,9587,9586,9585,-1,9588,9591,9590,9589,-1,9592,9595,9594,9593,-1,9596,9599,9598,9597,-1,9600,9603,9602,9601,-1,9604,9607,9606,9605,-1,9608,9611,9610,9609,-1,9612,9615,9614,9613,-1,9616,9619,9618,9617,-1,9620,9623,9622,9621,-1,9624,9627,9626,9625,-1,9628,9631,9630,9629,-1,9632,9635,9634,9633,-1,9636,9639,9638,9637,-1,9640,9643,9642,9641,-1,9644,9647,9646,9645,-1,9648,9651,9650,9649,-1,9652,9655,9654,9653,-1,9656,9659,9658,9657,-1,9660,9663,9662,9661,-1,9664,9667,9666,9665,-1,9668,9671,9670,9669,-1,9672,9675,9674,9673,-1,9676,9679,9678,9677,-1,9680,9683,9682,9681,-1,9684,9687,9686,9685,-1,9685,9634,9682,-1,9681,9635,9678,-1,9677,9632,9674,-1,9673,9633,9686,-1,9669,9594,9666,-1,9665,9595,9662,-1,9661,9592,9658,-1,9657,9593,9670,-1,9653,9618,9650,-1,9649,9619,9646,-1,9645,9616,9642,-1,9641,9617,9654,-1,9637,9590};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_50()
		{
			int[] value = {9684,9683,-1,9672,9687,9591,9630,-1,9629,9588,9626,-1,9625,9589,9638,-1,9621,9586,9652,9651,-1,9640,9655,9587,9614,-1,9613,9584,9610,-1,9609,9585,9622,-1,9604,9596,9624,9639,-1,9679,9607,9636,9680,-1,9602,9676,9675,9631,-1,9628,9627,9597,9601,-1,9600,9598,9608,9623,-1,9647,9603,9620,9648,-1,9606,9644,9643,9615,-1,9612,9611,9599,9605,-1,9685,9686,9633,9634,-1,9681,9682,9634,9635,-1,9682,9683,9684,9685,-1,9677,9678,9635,9632,-1,9678,9679,9680,9681,-1,9673,9674,9632,9633,-1,9674,9675,9676,9677,-1,9686,9687,9672,9673,-1,9669,9670,9593,9594,-1,9665,9666,9594,9595,-1,9666,9667,9668,9669,-1,9661,9662,9595,9592,-1,9662,9663,9664,9665,-1,9657,9658,9592,9593,-1,9658,9659,9660,9661,-1,9670,9671,9656,9657,-1,9653,9654,9617,9618,-1,9649,9650,9618,9619,-1,9650,9651,9652,9653,-1,9645,9646,9619,9616,-1,9646,9647,9648,9649,-1,9641,9642,9616,9617,-1,9642,9643,9644,9645,-1,9654,9655,9640,9641,-1,9637,9638,9589,9590,-1,9687,9684,9590,9591,-1,9683,9680,9636,9637,-1,9629,9630,9591,9588,-1,9630,9631,9675,9672,-1,9625,9626,9588,9589,-1,9626,9627,9628,9629,-1,9638,9639,9624,9625,-1,9621,9622,9585,9586,-1,9655,9652,9586,9587,-1,9651,9648,9620,9621,-1,9613,9614,9587,9584,-1,9614,9615,9643,9640,-1,9609,9610,9584,9585,-1,9610,9611,9612,9613,-1,9622,9623,9608,9609,-1,9600,9601,9597,9598,-1,9604,9605,9599,9596,-1,9602,9603,9671,9668,-1,9606,9607,9663,9660,-1,9596,9597,9627,9624,-1,9607,9604,9639,9636,-1,9667,9664,9679,9676,-1,9601,9602,9631,9628,-1,9598,9599,9611,9608,-1,9603,9600,9623,9620,-1,9659,9656,9647,9644,-1,9605,9606,9615,9612,-1,9603,9647,9656,9671,-1,9676,9602,9668,9667,-1,9607,9679,9664,9663,-1,9644,9606,9660,9659,-1,9688,9691,9690,9689,-1,9692,9695,9694,9693,-1,9696,9699,9698,9697,-1,9700,9703,9702,9701,-1,9704,9707,9706,9705,-1,9708,9711,9710,9709,-1,9712,9715,9714,9713,-1,9716,9719,9718,9717,-1,9720,9723,9722,9721,-1,9724,9727,9726,9725,-1,9728,9731,9730,9729,-1,9732,9735,9734,9733,-1,9736,9739,9738,9737,-1,9740,9743,9742,9741,-1,9744,9747,9746,9745,-1,9748,9751,9750,9749,-1,9752,9755,9754,9753,-1,9756,9759,9758,9757,-1,9760,9763,9762,9761,-1,9764,9767,9766,9765,-1,9768,9771,9770,9769,-1,9772,9775,9774,9773,-1,9776,9779,9778,9777,-1,9780,9783,9782,9781,-1,9784,9787,9786,9785,-1,9788,9791,9790,9789,-1,9789,9738,9786,-1,9785,9739,9782,-1,9781,9736,9778,-1,9777,9737,9790,-1,9773,9698,9770,-1,9769,9699,9766,-1,9765,9696,9762,-1,9761,9697,9774,-1,9757,9722,9754,-1,9753,9723,9750,-1,9749,9720,9746,-1,9745,9721,9758,-1,9741,9694,9788,9787,-1,9776,9791,9695,9734,-1,9733,9692,9730,-1,9729,9693,9742,-1,9725,9690,9756,9755,-1,9744,9759,9691,9718,-1,9717,9688,9714,-1,9713,9689,9726,-1,9708,9700,9728,9743,-1,9783,9711,9740,9784,-1,9706,9780,9779,9735,-1,9732,9731,9701,9705,-1,9704,9702,9712,9727,-1,9751,9707,9724,9752,-1,9710,9748,9747,9719,-1,9716,9715,9703,9709,-1,9789,9790,9737,9738,-1,9785,9786,9738,9739,-1,9786,9787,9788,9789,-1,9781,9782,9739,9736,-1,9782,9783,9784,9785,-1,9777,9778,9736,9737,-1,9778,9779,9780,9781,-1,9790,9791,9776,9777,-1,9773,9774,9697,9698,-1,9769,9770,9698,9699,-1,9770,9771,9772,9773,-1,9765,9766,9699,9696,-1,9766,9767,9768,9769,-1,9761,9762,9696,9697,-1,9762,9763,9764,9765,-1,9774,9775,9760,9761,-1,9757,9758,9721,9722,-1,9753,9754,9722,9723,-1,9754,9755,9756,9757,-1,9749,9750,9723,9720,-1,9750,9751,9752,9753,-1,9745,9746,9720,9721,-1,9746,9747,9748,9749,-1,9758,9759,9744,9745,-1,9741,9742,9693,9694,-1,9791,9788,9694,9695,-1,9787,9784,9740,9741,-1,9733,9734,9695,9692,-1,9734,9735,9779,9776,-1,9729,9730,9692,9693,-1,9730,9731,9732,9733,-1,9742,9743,9728,9729,-1,9725,9726,9689,9690,-1,9759,9756,9690,9691,-1,9755,9752,9724,9725,-1,9717,9718,9691,9688,-1,9718,9719,9747,9744,-1,9713,9714,9688,9689,-1,9714,9715,9716,9717,-1,9726,9727,9712,9713,-1,9704,9705,9701,9702,-1,9708,9709,9703,9700,-1,9706,9707,9775,9772,-1,9710,9711,9767,9764,-1,9700,9701,9731,9728,-1,9711,9708,9743,9740,-1,9771,9768,9783,9780,-1,9705,9706,9735,9732,-1,9702,9703,9715,9712,-1,9707,9704,9727,9724,-1,9763,9760,9751,9748,-1,9709,9710,9719,9716,-1,9707,9751,9760,9775,-1,9780,9706,9772,9771,-1,9711,9783,9768,9767,-1,9748,9710,9764,9763,-1,9792,9795,9794,9793,-1,9796,9799,9798,9797,-1,9800,9803,9802,9801,-1,9804,9807,9806,9805,-1,9808,9811,9810,9809,-1,9812,9815,9814,9813,-1,9816,9819,9818,9817,-1,9820,9823,9822,9821,-1,9824,9827,9826,9825,-1,9828,9831,9830,9829,-1,9832,9835,9834,9833,-1,9836,9839,9838,9837,-1,9840,9843,9842,9841,-1,9844,9847,9846,9845,-1,9848,9851,9850,9849,-1,9852,9855,9854,9853,-1,9856,9859,9858,9857,-1,9857,9802,9854,-1,9853,9803,9850,-1,9849,9800,9846,-1,9845,9801,9858,-1,9841,9856,9855,9838,-1,9837,9852,9851,9834,-1,9833};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_51()
		{
			int[] value = {9848,9847,9830,-1,9829,9844,9859,9842,-1,9825,9840,9839,9822,-1,9821,9836,9835,9818,-1,9817,9832,9831,9814,-1,9813,9828,9843,9826,-1,9820,9819,9811,9798,-1,9806,9824,9823,9799,-1,9812,9827,9807,9794,-1,9810,9816,9815,9795,-1,9857,9858,9801,9802,-1,9853,9854,9802,9803,-1,9854,9855,9856,9857,-1,9849,9850,9803,9800,-1,9850,9851,9852,9853,-1,9845,9846,9800,9801,-1,9846,9847,9848,9849,-1,9858,9859,9844,9845,-1,9841,9842,9859,9856,-1,9837,9838,9855,9852,-1,9838,9839,9840,9841,-1,9833,9834,9851,9848,-1,9834,9835,9836,9837,-1,9829,9830,9847,9844,-1,9830,9831,9832,9833,-1,9842,9843,9828,9829,-1,9825,9826,9843,9840,-1,9821,9822,9839,9836,-1,9822,9823,9824,9825,-1,9817,9818,9835,9832,-1,9818,9819,9820,9821,-1,9813,9814,9831,9828,-1,9814,9815,9816,9817,-1,9826,9827,9812,9813,-1,9806,9807,9827,9824,-1,9810,9811,9819,9816,-1,9811,9808,9797,9798,-1,9823,9820,9798,9799,-1,9805,9806,9799,9796,-1,9807,9804,9793,9794,-1,9815,9812,9794,9795,-1,9809,9810,9795,9792,-1,9860,9867,9866,9865,9864,9863,9862,9861,-1,9796,9797,9860,9861,-1,9797,9808,9867,9860,-1,9808,9809,9866,9867,-1,9809,9792,9865,9866,-1,9792,9793,9864,9865,-1,9793,9804,9863,9864,-1,9804,9805,9862,9863,-1,9805,9796,9861,9862,-1,9868,9871,9870,9869,-1,9872,9875,9874,9873,-1,9876,9879,9878,9877,-1,9880,9883,9882,9881,-1,9884,9887,9886,9885,-1,9888,9891,9890,9889,-1,9892,9895,9894,9893,-1,9896,9899,9898,9897,-1,9900,9903,9902,9901,-1,9904,9907,9906,9905,-1,9908,9911,9910,9909,-1,9912,9915,9914,9913,-1,9916,9919,9918,9917,-1,9920,9923,9922,9921,-1,9924,9927,9926,9925,-1,9928,9931,9930,9929,-1,9932,9935,9934,9933,-1,9936,9939,9938,9937,-1,9940,9943,9942,9941,-1,9944,9947,9946,9945,-1,9948,9951,9950,9949,-1,9952,9955,9954,9953,-1,9873,9954,9949,-1,9872,9950,9945,-1,9875,9946,9941,-1,9874,9942,9953,-1,9889,9938,9933,-1,9888,9934,9929,-1,9891,9930,9925,-1,9890,9926,9937,-1,9901,9922,9917,-1,9900,9918,9913,-1,9903,9914,9909,-1,9902,9910,9921,-1,9869,9906,9916,9923,-1,9920,9911,9897,9868,-1,9871,9898,9956,-1,9870,9957,9905,-1,9939,9958,9894,-1,9936,9885,9959,-1,9960,9962,9886,9961,-1,9963,9965,9964,9893,-1,9966,9883,9060,-1,9944,9951,9967,9880,-1,9955,9877,9478,9948,-1,9968,9062,9878,-1,9969,9971,9892,9970,-1,9972,9928,9895,-1,9931,9973,9884,-1,9974,9887,9976,9975,-1,9953,9954,9873,9874,-1,9949,9950,9872,9873,-1,9948,9949,9954,9955,-1,9945,9946,9875,9872,-1,9944,9945,9950,9951,-1,9941,9942,9874,9875,-1,9940,9941,9946,9947,-1,9952,9953,9942,9943,-1,9937,9938,9889,9890,-1,9933,9934,9888,9889,-1,9932,9933,9938,9939,-1,9929,9930,9891,9888,-1,9928,9929,9934,9935,-1,9925,9926,9890,9891,-1,9924,9925,9930,9931,-1,9936,9937,9926,9927,-1,9921,9922,9901,9902,-1,9917,9918,9900,9901,-1,9916,9917,9922,9923,-1,9913,9914,9903,9900,-1,9912,9913,9918,9919,-1,9909,9910,9902,9903,-1,9908,9909,9914,9915,-1,9920,9921,9910,9911,-1,9905,9906,9869,9870,-1,9923,9920,9868,9869,-1,9919,9916,9906,9907,-1,9897,9898,9871,9868,-1,9896,9897,9911,9908,-1,9956,9957,9870,9871,-1,9977,9956,9898,9899,-1,9904,9905,9957,9978,-1,9893,9894,9958,9963,-1,9939,9936,9980,9979,-1,9935,9932,9894,9895,-1,9885,9886,9962,9959,-1,9884,9885,9927,9924,-1,9974,9961,9886,9887,-1,9892,9893,9964,9970,-1,9878,9879,9981,9968,-1,9882,9883,9966,9982,-1,9876,9877,9955,9952,-1,9880,9881,9947,9944,-1,9968,9966,9060,9062,-1,9883,9880,9967,9060,-1,9877,9878,9062,9478,-1,9971,9972,9895,9892,-1,9983,9984,9931,9928,-1,9973,9976,9887,9884,-1,9881,9940,9947,-1,9931,9884,9924,-1,9885,9936,9927,-1,9915,9896,9908,-1,9907,9912,9919,-1,9939,9894,9932,-1,9895,9928,9935,-1,9943,9876,9952,-1,9975,9976,9882,9982,-1,9976,9973,9881,9882,-1,9973,9931,9984,-1,9936,9959,9980,-1,9959,9962,9899,9896,-1,9962,9960,9977,9899,-1,9973,9940,9881,-1,9915,9959,9896,-1,9943,9972,9876,-1,9972,9971,9879,9876,-1,9971,9969,9981,9879,-1,9965,9963,9904,9978,-1,9963,9958,9907,9904,-1,9958,9912,9907,-1,9972,9983,9928,-1,9979,9958,9939,-1,9958,9979,9912,-1,9979,9980,9915,9912,-1,9984,9983,9943,9940,-1,9983,9972,9943,-1,9973,9984,9940,-1,9980,9959,9915,-1,9960,9965,9978,9977,-1,9982,9981,9969,9975,-1,9970,9974,9975,9969,-1,9981,9982,9966,9968,-1,9961,9964,9965,9960,-1,9964,9961,9974,9970,-1,9977,9978,9957,9956,-1,9985,9988,9987,9986,-1,9989,9992,9991,9990,-1,9993,9996,9995,9994,-1,9997,10000,9999,9998,-1,10001,10004,10003,10002,-1,10005,10008,10007,10006,-1,10009,10012,10011,10010,-1,10013,10016,10015,10014,-1,10017,10020,10019,10018,-1,10021,10024,10023,10022,-1,10025,10028,10027,10026,-1,10029,10032,10031,10030,-1,10033,10036,10035,10034,-1,10037,10040,10039,10038,-1,10041,10044,10043,10042,-1,10045,10048,10047,10046,-1,10049,10052,10051,10050,-1,10053,10056,10055,10054,-1,10057,10060,10059,10058,-1,10061,10064,10063,10062,-1,10065,10068};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_52()
		{
			int[] value = {10067,10066,-1,10069,10072,10071,10070,-1,10073,10076,10075,10074,-1,10077,10080,10079,10078,-1,10081,10084,10083,10082,-1,10085,10088,10087,10086,-1,10034,10087,10082,-1,10033,10083,10078,-1,10036,10079,10074,-1,10035,10075,10086,-1,9994,10071,10066,-1,9993,10067,10062,-1,9996,10063,10058,-1,9995,10059,10070,-1,10018,10055,10050,-1,10017,10051,10046,-1,10020,10047,10042,-1,10019,10043,10054,-1,9990,10039,10081,10088,-1,10085,10076,10030,9989,-1,9992,10031,10026,-1,9991,10027,10038,-1,9986,10023,10049,10056,-1,10053,10044,10014,9985,-1,9988,10015,10010,-1,9987,10011,10022,-1,10000,10008,10037,10028,-1,10005,10077,10084,10040,-1,10080,10002,10029,10073,-1,10025,10032,10003,9999,-1,9998,10004,10021,10012,-1,10001,10045,10052,10024,-1,10048,10006,10013,10041,-1,10009,10016,10007,9997,-1,10086,10087,10034,10035,-1,10082,10083,10033,10034,-1,10081,10082,10087,10088,-1,10078,10079,10036,10033,-1,10077,10078,10083,10084,-1,10074,10075,10035,10036,-1,10073,10074,10079,10080,-1,10085,10086,10075,10076,-1,10070,10071,9994,9995,-1,10066,10067,9993,9994,-1,10065,10066,10071,10072,-1,10062,10063,9996,9993,-1,10061,10062,10067,10068,-1,10058,10059,9995,9996,-1,10057,10058,10063,10064,-1,10069,10070,10059,10060,-1,10054,10055,10018,10019,-1,10050,10051,10017,10018,-1,10049,10050,10055,10056,-1,10046,10047,10020,10017,-1,10045,10046,10051,10052,-1,10042,10043,10019,10020,-1,10041,10042,10047,10048,-1,10053,10054,10043,10044,-1,10038,10039,9990,9991,-1,10088,10085,9989,9990,-1,10084,10081,10039,10040,-1,10030,10031,9992,9989,-1,10029,10030,10076,10073,-1,10026,10027,9991,9992,-1,10025,10026,10031,10032,-1,10037,10038,10027,10028,-1,10022,10023,9986,9987,-1,10056,10053,9985,9986,-1,10052,10049,10023,10024,-1,10014,10015,9988,9985,-1,10013,10014,10044,10041,-1,10010,10011,9987,9988,-1,10009,10010,10015,10016,-1,10021,10022,10011,10012,-1,10003,10004,9998,9999,-1,10007,10008,10000,9997,-1,10001,10002,10072,10069,-1,10005,10006,10064,10061,-1,9999,10000,10028,10025,-1,10008,10005,10040,10037,-1,10068,10065,10080,10077,-1,10002,10003,10032,10029,-1,9997,9998,10012,10009,-1,10004,10001,10024,10021,-1,10060,10057,10048,10045,-1,10006,10007,10016,10013,-1,10045,10001,10069,10060,-1,10002,10080,10065,10072,-1,10077,10005,10061,10068,-1,10006,10048,10057,10064,-1,10089,10092,10091,10090,-1,10093,10096,10095,10094,-1,10097,10100,10099,10098,-1,10101,10104,10103,10102,-1,10105,10108,10107,10106,-1,10109,10112,10111,10110,-1,10113,10116,10115,10114,-1,10117,10120,10119,10118,-1,10121,10124,10123,10122,-1,10125,10128,10127,10126,-1,10129,10132,10131,10130,-1,10133,10136,10135,10134,-1,10137,10140,10139,10138,-1,10141,10144,10143,10142,-1,10145,10148,10147,10146,-1,10149,10152,10151,10150,-1,10153,10156,10155,10154,-1,10157,10160,10159,10158,-1,10161,10164,10163,10162,-1,10165,10168,10167,10166,-1,10169,10172,10171,10170,-1,10173,10176,10175,10174,-1,10177,10180,10179,10178,-1,10181,10184,10183,10182,-1,10185,10188,10187,10186,-1,10189,10192,10191,10190,-1,10138,10191,10186,-1,10137,10187,10182,-1,10140,10183,10178,-1,10139,10179,10190,-1,10098,10175,10170,-1,10097,10171,10166,-1,10100,10167,10162,-1,10099,10163,10174,-1,10122,10159,10154,-1,10121,10155,10150,-1,10124,10151,10146,-1,10123,10147,10158,-1,10094,10143,10185,10192,-1,10189,10180,10134,10093,-1,10096,10135,10130,-1,10095,10131,10142,-1,10090,10127,10153,10160,-1,10157,10148,10118,10089,-1,10092,10119,10114,-1,10091,10115,10126,-1,10104,10112,10141,10132,-1,10109,10181,10188,10144,-1,10184,10106,10133,10177,-1,10129,10136,10107,10103,-1,10102,10108,10125,10116,-1,10105,10149,10156,10128,-1,10152,10110,10117,10145,-1,10113,10120,10111,10101,-1,10190,10191,10138,10139,-1,10186,10187,10137,10138,-1,10185,10186,10191,10192,-1,10182,10183,10140,10137,-1,10181,10182,10187,10188,-1,10178,10179,10139,10140,-1,10177,10178,10183,10184,-1,10189,10190,10179,10180,-1,10174,10175,10098,10099,-1,10170,10171,10097,10098,-1,10169,10170,10175,10176,-1,10166,10167,10100,10097,-1,10165,10166,10171,10172,-1,10162,10163,10099,10100,-1,10161,10162,10167,10168,-1,10173,10174,10163,10164,-1,10158,10159,10122,10123,-1,10154,10155,10121,10122,-1,10153,10154,10159,10160,-1,10150,10151,10124,10121,-1,10149,10150,10155,10156,-1,10146,10147,10123,10124,-1,10145,10146,10151,10152,-1,10157,10158,10147,10148,-1,10142,10143,10094,10095,-1,10192,10189,10093,10094,-1,10188,10185,10143,10144,-1,10134,10135,10096,10093,-1,10133,10134,10180,10177,-1,10130,10131,10095,10096,-1,10129,10130,10135,10136,-1,10141,10142,10131,10132,-1,10126,10127,10090,10091,-1,10160,10157,10089,10090,-1,10156,10153,10127,10128,-1,10118,10119,10092,10089,-1,10117,10118,10148,10145,-1,10114,10115,10091,10092,-1,10113,10114,10119,10120,-1,10125,10126,10115,10116,-1,10107,10108,10102,10103,-1,10111,10112,10104,10101,-1,10105,10106,10176,10173,-1,10109,10110,10168,10165,-1,10103,10104,10132,10129,-1,10112,10109,10144,10141,-1,10172,10169,10184,10181,-1,10106,10107,10136,10133,-1,10101,10102,10116,10113,-1,10108,10105,10128,10125,-1,10164,10161,10152,10149,-1,10110,10111,10120,10117,-1,10149,10105,10173,10164,-1,10106,10184,10169,10176,-1,10181,10109,10165,10172,-1,10110,10152,10161,10168,-1,10193,10196,10195,10194,-1,10197,10200,10199,10198,-1,10201,10204,10203,10202,-1,10205,10208,10207,10206,-1,10209,10212,10211,10210,-1,10213,10216,10215,10214,-1,10217,10220,10219,10218};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_53()
		{
			int[] value = {-1,10221,10224,10223,10222,-1,10225,10228,10227,10226,-1,10229,10232,10231,10230,-1,10233,10236,10235,10234,-1,10237,10240,10239,10238,-1,10241,10244,10243,10242,-1,10245,10248,10247,10246,-1,10249,10252,10251,10250,-1,10253,10256,10255,10254,-1,10257,10260,10259,10258,-1,10202,10259,10254,-1,10201,10255,10250,-1,10204,10251,10246,-1,10203,10247,10258,-1,10260,10243,10238,10253,-1,10256,10239,10234,10249,-1,10252,10235,10230,10245,-1,10248,10231,10242,10257,-1,10244,10227,10222,10237,-1,10240,10223,10218,10233,-1,10236,10219,10214,10229,-1,10232,10215,10226,10241,-1,10217,10224,10198,10209,-1,10228,10206,10197,10221,-1,10225,10216,10194,10205,-1,10220,10210,10193,10213,-1,10258,10259,10202,10203,-1,10254,10255,10201,10202,-1,10253,10254,10259,10260,-1,10250,10251,10204,10201,-1,10249,10250,10255,10256,-1,10246,10247,10203,10204,-1,10245,10246,10251,10252,-1,10257,10258,10247,10248,-1,10242,10243,10260,10257,-1,10238,10239,10256,10253,-1,10237,10238,10243,10244,-1,10234,10235,10252,10249,-1,10233,10234,10239,10240,-1,10230,10231,10248,10245,-1,10229,10230,10235,10236,-1,10241,10242,10231,10232,-1,10226,10227,10244,10241,-1,10222,10223,10240,10237,-1,10221,10222,10227,10228,-1,10218,10219,10236,10233,-1,10217,10218,10223,10224,-1,10214,10215,10232,10229,-1,10213,10214,10219,10220,-1,10225,10226,10215,10216,-1,10205,10206,10228,10225,-1,10209,10210,10220,10217,-1,10212,10209,10198,10199,-1,10224,10221,10197,10198,-1,10206,10207,10200,10197,-1,10208,10205,10194,10195,-1,10216,10213,10193,10194,-1,10210,10211,10196,10193,-1,10261,10268,10267,10266,10265,10264,10263,10262,-1,10199,10200,10267,10268,-1,10212,10199,10268,10261,-1,10211,10212,10261,10262,-1,10196,10211,10262,10263,-1,10195,10196,10263,10264,-1,10208,10195,10264,10265,-1,10207,10208,10265,10266,-1,10200,10207,10266,10267,-1,10272,10275,10274,10273,-1,10276,10279,10278,10277,-1,10279,10276,10281,10280,-1,10282,10285,10284,10283,-1,10277,10278,10287,10286,-1,10285,10282,10286,10287,-1,10280,10281,10275,10272,-1,10288,10290,10289,-1,10291,10293,10292,-1,10294,10296,10295,-1,10296,10291,10292,10295,-1,10290,10298,10297,10289,-1,10298,10299,10297,-1,10299,10298,10300,-1,10296,10294,10301,-1,10297,10299,10302,-1,10299,10304,10303,10302,-1,10304,10280,10272,10303,-1,10287,10306,10305,10285,-1,10306,10294,10307,10305,-1,10294,10295,10307,-1,10288,10289,10308,-1,10292,10293,10309,-1,10281,10311,10310,10275,-1,10311,10288,10308,10310,-1,10288,10312,10290,-1,10313,10293,10291,-1,10293,10315,10314,10309,-1,10315,10286,10282,10314,-1,10307,10295,10316,-1,10301,10318,10317,-1,10319,10300,10320,-1,10297,10302,10321,-1,10308,10289,10322,-1,10312,10324,10323,-1,10325,10313,10326,-1,10292,10309,10327,-1,10315,10293,10325,10328,-1,10291,10296,10301,10313,-1,10294,10306,10329,10318,-1,10330,10331,9479,10271,-1,10332,10333,10269,10270,-1,10283,10284,10271,10269,-1,10309,10332,10334,10327,-1,10331,10307,10316,10335,-1,10333,10314,10282,10283,-1,10305,10330,10284,10285,-1,10336,10329,10278,10279,-1,10276,10277,10328,10337,-1,10324,10325,10326,10323,-1,10337,10324,10288,10311,-1,10320,10317,10318,10319,-1,10312,10300,10298,10290,-1,10319,10336,10304,10299,-1,10338,10303,10272,10273,-1,10274,10275,10310,10339,-1,10273,10274,10341,10340,-1,10342,10308,10322,10343,-1,10339,10342,10344,10341,-1,10345,10321,10302,10346,-1,10347,10349,10348,10344,-1,10346,10338,10340,10348,-1,10350,10347,10343,10351,-1,10352,10322,10289,10353,-1,10351,10352,10355,10354,-1,10356,10297,10321,10357,-1,10353,10356,10358,10355,-1,10359,10345,10349,10360,-1,10357,10359,10361,10358,-1,10360,10350,10354,10361,-1,10362,10312,10323,10363,-1,10364,10326,10313,10365,-1,10363,10364,10367,10366,-1,10368,10301,10317,10369,-1,10365,10368,10370,10367,-1,10371,10320,10300,10372,-1,10369,10371,10373,10370,-1,10372,10362,10366,10373,-1,10374,10316,10295,10375,-1,10376,10292,10327,10377,-1,10375,10376,10379,10378,-1,10380,10334,8574,10381,-1,10377,10380,10382,10379,-1,10383,9423,10335,10384,-1,10381,10383,10385,10382,-1,10384,10374,10378,10385,-1,10328,10277,10286,10315,-1,10293,10313,10325,-1,10301,10294,10318,-1,10306,10287,10278,10329,-1,10271,10284,10330,-1,10331,10335,9423,9479,-1,8574,10334,10332,10270,-1,10333,10283,10269,-1,10280,10304,10336,10279,-1,10311,10281,10276,10337,-1,10324,10312,10288,-1,10299,10300,10319,-1,10273,10340,10338,-1,10339,10341,10274,-1,10343,10347,10344,10342,-1,10346,10348,10349,10345,-1,10351,10354,10350,-1,10353,10355,10352,-1,10357,10358,10356,-1,10360,10361,10359,-1,10363,10366,10362,-1,10365,10367,10364,-1,10369,10370,10368,-1,10372,10373,10371,-1,10375,10378,10374,-1,10377,10379,10376,-1,10381,10382,10380,-1,10384,10385,10383,-1,10335,10316,10374,10384,-1,8574,9423,10383,10381,-1,10327,10334,10380,10377,-1,10295,10292,10376,10375,-1,10300,10312,10362,10372,-1,10317,10320,10371,10369,-1,10313,10301,10368,10365,-1,10323,10326,10364,10363,-1,10349,10347,10350,10360,-1,10321,10345,10359,10357,-1,10289,10297,10356,10353,-1,10343,10322,10352,10351,-1,10302,10303,10338,10346,-1,10355,10358,10361,10354,-1,10310,10308,10342,10339,-1,10318,10329,10336,10319,-1,10367,10370,10373,10366,-1,10328,10325,10324,10337,-1,10333,10332,10309,10314,-1,10305,10307,10331,10330,-1,10379,10382,10385,10378,-1,10341,10344,10348,10340,-1,12442,10850,10852,10569,-1,10837,10840,12464,12465,-1,10840,10850,12442,12464,-1,10785,10784,10640,10642,-1,10651,10652,10653,10654};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_54()
		{
			int[] value = {-1,10785,10642,10637,10783,-1,10643,10644,10641,10640,-1,10644,10643,10645,10646,-1,10647,10648,10646,10645,-1,10649,10650,10648,10647,-1,10650,10649,10651,10654,-1,10671,10672,10673,-1,10657,10658,10802,10804,-1,10881,10883,10658,10657,-1,10661,10662,10882,10880,-1,10663,10664,10662,10661,-1,10665,10666,10664,10663,-1,10666,10665,10667,10668,-1,10669,10670,10668,10667,-1,10671,10673,10670,10669,-1,10803,10801,10674,10675,-1,10529,10675,10674,-1,10786,10783,10637,-1,10640,10641,10642,-1,10639,10784,10785,-1,10638,10639,10785,10783,-1,10396,10638,10783,10786,-1,10789,10787,10396,-1,10396,10788,10789,-1,10804,10802,10655,10656,-1,10656,10655,10801,10803,-1,10512,10560,10840,10837,-1,10560,10568,10850,10840,-1,10568,10426,10852,10850,-1,10883,10881,10659,10660,-1,10660,10659,10880,10882,-1,10834,10552,10497,-1,10552,10835,10497,-1,10888,10889,10886,10887,-1,10887,10886,10890,10891,-1,10497,10891,10890,10834,-1,10497,10833,10891,-1,10712,10538,10447,10714,-1,10758,10756,10446,10535,-1,10446,10756,10750,10546,-1,10731,10733,10691,10693,-1,10526,10668,10670,10527,-1,10717,12755,10541,10715,-1,10567,10404,10851,10849,-1,10757,10533,10548,10751,-1,10759,10533,10757,-1,10714,10447,10543,10716,-1,10882,10662,10398,10884,-1,10815,10567,10817,-1,10562,10889,10888,10561,10437,-1,10577,10452,10664,10666,-1,12764,10472,10719,10722,-1,10723,10718,10408,10474,-1,10474,10408,10726,10725,-1,10724,10727,10695,10698,-1,10445,10749,10753,10477,-1,10752,10748,10449,10479,-1,10428,10413,10483,10482,-1,10483,10413,10453,10484,-1,10877,10485,10414,10875,-1,10489,10551,10552,10439,-1,10826,10417,10494,10824,-1,10494,10417,10844,10846,-1,10845,10843,12574,10496,-1,10460,10419,10420,10461,-1,10616,10422,10423,10617,-1,10617,10423,10765,10767,-1,10619,10766,10764,10443,-1,10743,10681,10683,10741,-1,10773,10549,10532,10776,-1,10774,10480,10412,10772,-1,10779,10422,10616,10780,-1,10670,10673,10528,10527,-1,10482,10637,10642,10428,-1,10812,10415,10488,10808,-1,10799,10575,10674,10801,-1,10658,10883,10885,10433,-1,10487,10876,10874,10432,-1,10859,10416,10491,10861,-1,10868,10564,10866,-1,10869,10402,10564,10868,-1,10865,10562,10437,10867,-1,10862,10489,10439,10860,-1,10735,10689,10691,10733,-1,10715,10541,10540,10713,-1,10707,12813,12814,10705,-1,10704,10622,10448,10706,-1,10443,10682,10680,10619,-1,10446,10690,10688,10535,-1,10546,10692,10690,10446,-1,10477,10699,10694,10445,-1,10447,10732,10730,10543,-1,10538,10734,10732,10447,-1,10622,10742,10740,10448,-1,10449,10412,10480,10479,-1,10533,10532,10549,10548,-1,10453,10414,10485,10484,-1,10452,10398,10662,10664,-1,10565,10564,10402,10456,-1,10492,10491,10416,10454,-1,10454,10825,10823,10492,-1,10456,10816,10818,10565,-1,10720,10723,10474,10389,-1,10389,10474,10725,10729,-1,10728,10724,10698,10697,-1,10696,10699,10477,10444,-1,10444,10477,10753,10755,-1,10754,10752,10479,10450,-1,10450,10479,10480,10395,-1,10395,10480,10774,10775,-1,10786,10637,10482,10788,-1,10789,10788,10482,10483,10397,-1,10397,10483,10484,10451,-1,10451,10484,10485,10399,-1,10399,10485,10877,10879,-1,10878,10876,10487,10430,-1,10808,10488,10400,10809,-1,10400,10488,10551,10489,10435,-1,10435,10489,10862,10864,-1,10863,10861,10491,10401,-1,10401,10491,10492,10458,-1,10458,10492,10823,10822,-1,10821,10824,10494,10403,-1,10403,10494,10846,10848,-1,10847,10845,10496,10406,-1,10834,10498,10439,10552,-1,10439,10498,10858,10860,-1,10859,10857,10500,10416,-1,10416,10500,10501,10454,-1,10454,10501,10827,10825,-1,10826,10828,10503,10417,-1,10417,10503,10842,10844,-1,10843,10841,12630,12574,-1,10835,10552,10415,10524,-1,10834,10890,10506,10498,-1,10498,10506,10854,10858,-1,10857,10853,10508,10500,-1,10500,10508,10509,10501,-1,10501,10509,10829,10827,-1,10828,10830,10511,10503,-1,10503,10511,10838,10842,-1,10841,10837,12465,12630,-1,10891,10833,10831,10513,-1,10419,10514,10515,10420,-1,10791,10645,10643,10790,-1,10642,10517,10518,10428,-1,10428,10518,10519,10413,-1,10413,10519,10520,10453,-1,10453,10520,10521,10414,-1,10414,10521,10871,10875,-1,10874,10870,10523,10432,-1,10814,10524,10415,10812,-1,10514,10525,10526,10515,-1,10516,10528,10673,10672,10517,-1,10517,10672,10671,10518,-1,10518,10669,10667,10519,-1,10578,10665,10663,10579,-1,10579,10663,10661,10580,-1,10580,10661,10880,10872,-1,10873,10881,10657,10582,-1,10803,10675,10584,10805,-1,10651,10649,10793,10795,-1,10779,10778,10631,10422,-1,10422,10631,10630,10423,-1,10423,10630,10763,10765,-1,10764,10762,10628,10443,-1,10443,10628,10684,10682,-1,10683,10685,10739,10741,-1,10740,10738,10625,10448,-1,10448,10625,10708,10706,-1,10707,10709,12857,12813,-1,10472,12755,10717,10719,-1,10718,10716,10543,10408,-1,10408,10543,10730,10726,-1,10727,10731,10693,10695,-1,10694,10692,10546,10445,-1,10445,10546,10750,10749,-1,10748,10751,10548,10449,-1,10449,10548,10549,10412,-1,10412,10549,10773,10772,-1,10640,10784,10790,10643,-1,10517,10644,10646,10516,-1,12858,12764,10722,10721,-1,10529,10530,10832,10836,-1,10524,10529,10836,10835,-1,10551,10488,10415,10552,-1,10513,10553,10887,10891,-1,10890,10886,10554,10506,-1,10506,10554,10855,10854,-1,10853,10856,10556,10508,-1,10508,10556,10557,10509,-1,10509,10557,10820,10829,-1,10830,10819,10559,10511,-1,10511,10559,10839,10838,-1,10553,10561,10888,10887,-1,10886,10889,10562,10554,-1,10554,10562,10865,10855,-1,10856,10866,10564,10556,-1,10556,10564,10565,10557,-1,10557,10565,10818,10820,-1,10819,10817,10567,10559,-1,10559,10567,10849};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_55()
		{
			int[] value = {10839,-1,10802,10658,10433,10800,-1,10806,10582,10657,10804,-1,10811,10432,10523,10813,-1,10807,10487,10432,10811,-1,10810,10430,10487,10807,-1,10529,10674,10575,10530,-1,10525,10576,10577,10526,-1,10526,10577,10666,10668,-1,10667,10665,10578,10519,-1,10519,10578,10579,10520,-1,10520,10579,10580,10521,-1,10521,10580,10872,10871,-1,10870,10873,10582,10523,-1,10523,10582,10806,10813,-1,10814,10805,10584,10524,-1,10524,10584,10675,10529,-1,10420,10585,10586,10461,-1,10461,10586,10587,10462,-1,10462,10587,10797,10798,-1,10782,10781,10589,10463,-1,10463,10589,10590,10464,-1,10464,10590,10769,10771,-1,10770,10768,10592,10466,-1,10466,10592,10678,10677,-1,10676,10679,10745,10747,-1,10746,10744,10595,10469,-1,10469,10595,10702,10701,-1,10700,10703,10597,10471,-1,10540,10598,10711,10713,-1,10712,10710,10600,10538,-1,10538,10600,10736,10734,-1,10735,10737,10687,10689,-1,10688,10686,10603,10535,-1,10535,10603,10760,10758,-1,10759,10761,10605,10533,-1,10533,10605,10606,10532,-1,10532,10606,10777,10776,-1,10791,10792,10647,10645,-1,10646,10648,10608,10516,-1,10516,10608,10609,10528,-1,10528,10609,10610,10527,-1,10527,10610,10611,10526,-1,10526,10611,10612,10515,-1,10515,10612,10585,10420,-1,10587,10613,10796,10797,-1,10781,10780,10616,10589,-1,10589,10616,10617,10590,-1,10590,10617,10767,10769,-1,10768,10766,10619,10592,-1,10592,10619,10680,10678,-1,10679,10681,10743,10745,-1,10744,10742,10622,10595,-1,10595,10622,10704,10702,-1,10703,10705,12814,10597,-1,10598,12857,10709,10711,-1,10710,10708,10625,10600,-1,10600,10625,10738,10736,-1,10737,10739,10685,10687,-1,10686,10684,10628,10603,-1,10603,10628,10762,10760,-1,10761,10630,10605,-1,10605,10630,10631,10606,-1,10606,10631,10778,10777,-1,10792,10793,10649,10647,-1,10648,10650,10636,10608,-1,10608,10636,10634,10609,-1,10609,10634,10635,10610,-1,10636,10654,10653,10634,-1,10650,10654,10636,-1,10644,10517,10641,-1,10642,10641,10517,-1,10671,10669,10518,-1,10677,10678,10593,10467,-1,10467,10593,10679,10676,-1,10678,10680,10620,10593,-1,10593,10620,10681,10679,-1,10680,10682,10425,10620,-1,10620,10425,10683,10681,-1,10682,10684,10627,10425,-1,10425,10627,10685,10683,-1,10687,10685,10627,10602,-1,10602,10627,10684,10686,-1,10689,10687,10602,10536,-1,10536,10602,10686,10688,-1,10688,10690,10390,10536,-1,10536,10390,10691,10689,-1,10693,10691,10390,10545,-1,10545,10390,10690,10692,-1,10695,10693,10545,10410,-1,10410,10545,10692,10694,-1,10697,10698,10476,10392,-1,10392,10476,10699,10696,-1,10698,10695,10410,10476,-1,10476,10410,10694,10699,-1,10701,10702,10596,10470,-1,10470,10596,10703,10700,-1,10702,10704,10623,10596,-1,10596,10623,10705,10703,-1,10707,10705,10623,10442,-1,10442,10623,10704,10706,-1,10706,10708,10624,10442,-1,10442,10624,10709,10707,-1,10711,10709,10624,10599,-1,10599,10624,10708,10710,-1,10713,10711,10599,10539,-1,10539,10599,10710,10712,-1,10712,10714,10386,10539,-1,10539,10386,10715,10713,-1,10717,10715,10386,10542,-1,10542,10386,10714,10716,-1,10719,10717,10542,10407,-1,10407,10542,10716,10718,-1,10721,10722,10473,10387,-1,10387,10473,10723,10720,-1,10722,10719,10407,10473,-1,10473,10407,10718,10723,-1,10725,10726,10409,10475,-1,10475,10409,10727,10724,-1,10729,10725,10475,10391,-1,10391,10475,10724,10728,-1,10726,10730,10544,10409,-1,10409,10544,10731,10727,-1,10730,10732,10388,10544,-1,10544,10388,10733,10731,-1,10732,10734,10537,10388,-1,10388,10537,10735,10733,-1,10734,10736,10601,10537,-1,10537,10601,10737,10735,-1,10736,10738,10626,10601,-1,10601,10626,10739,10737,-1,10741,10739,10626,10441,-1,10441,10626,10738,10740,-1,10743,10741,10441,10621,-1,10621,10441,10740,10742,-1,10745,10743,10621,10594,-1,10594,10621,10742,10744,-1,10747,10745,10594,10468,-1,10468,10594,10744,10746,-1,10749,10750,10547,10411,-1,10411,10547,10751,10748,-1,10753,10749,10411,10478,-1,10478,10411,10748,10752,-1,10755,10753,10478,10394,-1,10394,10478,10752,10754,-1,10750,10756,10393,10547,-1,10547,10393,10757,10751,-1,10756,10758,10534,10393,-1,10393,10534,10759,10757,-1,10758,10760,10604,10534,-1,10534,10604,10761,10759,-1,10760,10762,10629,10604,-1,10604,10629,10763,10761,-1,10765,10763,10629,10424,-1,10424,10629,10762,10764,-1,10767,10765,10424,10618,-1,10618,10424,10764,10766,-1,10769,10767,10618,10591,-1,10591,10618,10766,10768,-1,10771,10769,10591,10465,-1,10465,10591,10768,10770,-1,10772,10773,12439,12438,-1,12438,10481,10774,10772,-1,10775,10774,10481,10893,-1,12441,12439,10773,10776,-1,10776,10777,10607,12441,-1,10777,10778,10632,10607,-1,10427,10632,10778,10779,-1,10779,10780,10615,10427,-1,10588,10615,10780,10781,-1,12440,10588,10781,10782,-1,10421,10794,10795,-1,10396,10786,10788,-1,10639,10550,10790,10784,-1,10791,10790,10550,10531,-1,10531,12437,10792,10791,-1,12437,10633,10793,10792,-1,10795,10793,10633,10421,-1,10796,10794,10421,10614,-1,10797,10796,10614,12436,-1,10798,10797,12436,12435,-1,10497,10835,10836,-1,10799,10801,10655,10571,-1,10571,10655,10802,10800,-1,10803,10805,10583,10656,-1,10656,10583,10806,10804,-1,10808,10809,10574,10573,-1,10573,10574,10810,10807,-1,10812,10808,10573,10572,-1,10572,10573,10807,10811,-1,10814,10812,10572,10570,-1,10570,10572,10811,10813,-1,10813,10806,10583,10570,-1,10570,10583,10805,10814,-1,10815,10817,10566,10457,-1,10457,10566,10818,10816,-1,10820,10818,10566,10558,-1,10558,10566,10817,10819,-1,10822,10823,10493,10459,-1,10459,10493,10824,10821,-1,10826,10824,10493,10455,-1,10455,10493,10823,10825,-1,10825};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_56()
		{
			int[] value = {10827,10502,10455,-1,10455,10502,10828,10826,-1,10827,10829,10510,10502,-1,10502,10510,10830,10828,-1,10829,10820,10558,10510,-1,10510,10558,10819,10830,-1,10836,10832,10505,10497,-1,10497,10505,10831,10833,-1,10838,10839,10560,10512,-1,10842,10838,10512,10504,-1,10504,10512,10837,10841,-1,10844,10842,10504,10418,-1,10418,10504,10841,10843,-1,10846,10844,10418,10495,-1,10495,10418,10843,10845,-1,10848,10846,10495,10405,-1,10405,10495,10845,10847,-1,10839,10849,10568,10560,-1,10849,10851,10426,10568,-1,10854,10855,10555,10507,-1,10507,10555,10856,10853,-1,10858,10854,10507,10499,-1,10499,10507,10853,10857,-1,10860,10858,10499,10440,-1,10440,10499,10857,10859,-1,10859,10861,10490,10440,-1,10440,10490,10862,10860,-1,10864,10862,10490,10436,-1,10436,10490,10861,10863,-1,10855,10865,10563,10555,-1,10555,10563,10866,10856,-1,10868,10866,10563,10438,-1,10438,10563,10865,10867,-1,10871,10872,10581,10522,-1,10522,10581,10873,10870,-1,10875,10871,10522,10431,-1,10431,10522,10870,10874,-1,10877,10875,10431,10486,-1,10486,10431,10874,10876,-1,10879,10877,10486,10429,-1,10429,10486,10876,10878,-1,10872,10880,10659,10581,-1,10581,10659,10881,10873,-1,10882,10884,10434,10660,-1,10660,10434,10885,10883,-1,10892,10464,10771,10465,10770,10466,10677,10467,10676,10747,10468,10746,10469,10701,10470,10700,10471,12959,12858,10721,10387,10720,10389,10729,10391,10728,10697,10392,10696,10444,10755,10394,10754,10450,10395,10775,10893,-1,10900,10899,10898,-1,10906,10905,10904,-1,10907,4111,4110,-1,10910,10909,10908,-1,10913,10912,10911,-1,10916,10915,10914,-1,10919,10918,10917,-1,10922,10917,10921,10920,-1,10926,10925,10924,10923,-1,10930,10929,10928,10927,-1,10934,10933,10932,10931,-1,10937,10936,10935,-1,10939,10938,13003,-1,10897,10941,10940,13006,-1,4136,4106,10942,-1,4136,10942,10943,4137,-1,10942,4106,10944,-1,10942,10944,10945,10943,-1,10944,4106,10901,10946,-1,10944,10946,10947,10945,-1,10948,10946,10901,-1,10947,10946,10948,10949,-1,10948,10901,10950,-1,10951,10950,10901,-1,10936,10949,10948,10950,-1,10901,10952,10951,-1,10953,10936,10950,10951,-1,10954,10953,10951,10952,-1,10952,10901,10902,10955,-1,10955,10956,10954,10952,-1,10957,10955,10902,-1,10958,10956,10955,10957,-1,10959,10957,10902,-1,10960,10958,10957,10959,-1,10961,10959,10902,10903,-1,10960,10959,10961,10909,-1,10961,10903,10962,-1,10961,10962,10915,10909,-1,10962,10963,10917,10915,-1,10963,10962,10903,-1,10964,10963,10903,-1,10917,10963,10964,10921,-1,10965,10964,10903,12963,-1,12963,13031,10965,-1,10966,10921,10964,10965,-1,13033,10966,10965,13031,-1,10969,10968,10910,10967,-1,10973,10972,10971,10970,-1,10972,10973,10968,10969,-1,10975,10974,10970,10971,-1,10976,10913,10974,10975,-1,10912,10913,10976,-1,10912,10977,10911,-1,10980,10977,10979,10978,-1,10977,10980,10981,10911,-1,10915,10916,10908,10909,-1,10899,10982,10898,-1,10898,10982,10984,10983,-1,10987,10986,10985,10906,-1,10990,10989,10988,-1,4110,4144,10991,10907,-1,10993,10992,10922,10920,-1,10995,10994,10911,10981,-1,10998,10985,10997,10996,-1,10906,10985,10998,10905,-1,11001,10904,11000,10999,-1,11005,11004,11003,11002,-1,11009,11008,11007,11006,-1,11013,11012,11011,11010,-1,10926,11015,11014,10925,-1,11017,11016,10925,11014,-1,11015,10926,11019,11018,-1,11014,11015,11021,11020,-1,11023,11020,11022,-1,11027,11026,11025,11024,-1,11024,11025,11029,11028,-1,11016,11017,11026,11027,-1,11033,11032,11031,11030,-1,11035,11034,10927,-1,10929,10930,11010,11011,-1,10927,10928,10940,10941,-1,11039,11038,11037,11036,-1,11043,11042,11041,11040,-1,11040,11041,11038,11039,-1,11045,11044,11042,11043,-1,10993,11046,11044,11045,-1,10966,11048,11047,10921,-1,11049,11048,10966,-1,11053,11052,11051,11050,-1,11054,11049,10966,-1,11054,11056,11055,-1,10966,13033,10896,11054,-1,11019,11059,11058,11057,-1,11022,11020,11021,-1,11036,11037,11061,11060,-1,10987,11064,11063,11062,-1,11003,11004,10978,10979,-1,10956,11066,11065,10954,-1,11067,11066,10956,10958,-1,11069,10958,11068,-1,10960,11070,11068,10958,-1,10909,11071,11070,10960,-1,10994,10995,11072,-1,10996,10997,10971,10972,-1,10922,10919,10917,-1,10921,11047,10920,-1,11074,11073,11062,11063,-1,11075,11009,4160,-1,11013,4161,4162,11012,-1,4164,4163,11030,11031,-1,4170,4169,11077,11076,-1,11077,10923,10924,11076,-1,10943,11078,4186,4137,-1,4181,4182,11080,11079,-1,10945,11080,11078,10943,-1,4188,11082,11081,4187,-1,11083,11082,4175,4176,-1,11085,11084,10934,10931,-1,10933,10934,11087,11086,-1,11087,10947,10949,11086,-1,10932,10933,10937,10935,-1,10936,10937,11086,10949,-1,10953,11088,10935,10936,-1,10931,10932,11090,11089,-1,10954,11065,11088,10953,-1,11089,11090,11092,11091,-1,11091,11092,11005,11002,-1,4109,11094,11093,4108,-1,4192,4191,10983,10984,-1,10916,10914,11095,-1,10917,10918,10914,10915,-1,11098,11097,13164,11096,-1,11022,11100,10894,11099,-1,11102,11101,11100,11022,-1,11103,10895,11101,11102,-1,11056,13169,10895,11103,-1,10939,13003,13170,11104,-1,11105,13173,13003,10938,-1,10941,10897,13173,11105,-1,13164,13006,10940,11096,-1,4153,4154,11104,13170,-1,10919,11107,11106,-1,11106,11107,11109,11108,-1,10916,11095,11111,11110,-1,10914,10918,11112,11095,-1,10984,11113,4205,4192,-1,11093,11114,4211,4108,-1,10983,4191,4211,11114,-1,10912,11114,11093,-1,11116,11093,11094,11115,-1,11094,4109,11117,-1,11117,4109,4187,11081,-1,11085,10931,11089,11118,-1,11118,11089,11091,11119,-1,11091,11002,11115,11119,-1,11088,11065,11005};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_57()
		{
			int[] value = {11092,-1,11088,11092,11090,-1,11088,11090,10932,10935,-1,10937,10933,11086,-1,11079,10945,11121,11120,-1,11121,11087,10934,11084,-1,11083,4176,4212,11120,-1,4188,4175,11082,-1,11080,4182,4213,11078,-1,11078,4213,4186,-1,4212,4181,11079,11120,-1,4172,4173,11073,11074,-1,4215,4218,11123,11122,-1,11124,4217,4215,11122,-1,11123,11060,11061,11122,-1,11123,4218,4172,11074,-1,11073,4173,4220,11125,-1,4205,11113,11125,4220,-1,4169,4225,11126,11077,-1,10907,11127,4226,4111,-1,11030,4163,4161,11013,-1,4162,4231,11128,11012,-1,11130,11129,4233,4234,-1,4160,11131,11075,-1,11006,4235,4160,11009,-1,11006,11007,4236,-1,4237,4235,11006,4236,-1,11123,11074,11063,11060,-1,11073,11125,11132,11062,-1,11125,11113,11133,11132,-1,10912,10976,10900,11114,-1,10900,10898,10983,11114,-1,11132,10987,11062,-1,11132,11133,10986,10987,-1,10906,11134,11064,10987,-1,11134,11039,11036,11064,-1,11039,11134,11001,11040,-1,10904,11001,11134,10906,-1,11001,10999,11043,11040,-1,11045,11043,10999,11135,-1,10920,11047,11046,10993,-1,11137,11136,11108,11000,-1,11111,11139,11138,11110,-1,10969,11138,10996,10972,-1,10971,10997,10899,10975,-1,11071,11140,10995,11070,-1,11068,11070,10995,10981,-1,11067,10958,11069,-1,11004,11066,11067,10978,-1,10976,10975,10899,10900,-1,11063,11064,11036,11060,-1,10967,11110,11138,10969,-1,10988,11141,10907,10991,-1,11142,10990,10991,11124,-1,11122,11143,11142,11124,-1,11061,11037,11144,11143,-1,11148,11147,11146,11145,-1,11148,11150,11149,11147,-1,10989,11052,11053,-1,10989,11053,11141,10988,-1,10990,11142,11151,10989,-1,10988,10991,10990,-1,11122,11061,11143,-1,11021,11153,11152,11022,-1,11022,11152,11102,-1,11057,11154,11018,11019,-1,10924,11155,11076,-1,11077,11126,11059,10923,-1,11058,11126,11127,11156,-1,11157,11153,11018,11154,-1,11158,11152,11153,11157,-1,11159,11102,11152,11158,-1,11103,11102,11159,11160,-1,11056,11103,11160,11055,-1,11054,10896,13169,11056,-1,11054,11055,11161,11049,-1,11055,11160,11162,11161,-1,11160,11159,11163,11162,-1,11158,11164,11163,11159,-1,11157,11165,11164,11158,-1,11157,11154,11051,11165,-1,11051,11154,11057,11050,-1,11050,11057,11058,11156,-1,11051,11052,11146,11165,-1,11165,11146,11147,11164,-1,11164,11147,11149,11163,-1,11150,11166,11149,-1,11163,11149,11166,11162,-1,11162,11166,11167,11161,-1,11161,11167,11048,11049,-1,11166,11150,11042,11044,-1,11166,11044,11046,11167,-1,11042,11150,11148,11041,-1,11148,11145,11038,11041,-1,11038,11145,11144,11037,-1,10927,10941,11105,11035,-1,11035,11105,10938,11008,-1,11096,10940,10928,11168,-1,11098,11096,11168,11029,-1,11028,11029,11168,11169,-1,11011,11170,11169,10929,-1,11033,11010,10930,-1,11010,11033,11030,11013,-1,11172,11171,11129,-1,11172,11129,11130,11173,-1,11173,11130,11076,11155,-1,11027,11173,11155,11016,-1,11025,11098,11029,-1,11026,11174,11098,11025,-1,11099,11098,11174,-1,11174,11023,11022,11099,-1,11017,11023,11174,11026,-1,11023,11017,11014,11020,-1,11021,11015,11018,11153,-1,10926,10923,11059,11019,-1,11016,11155,10924,10925,-1,11171,11028,11169,11170,-1,11172,11024,11028,11171,-1,11173,11027,11024,11172,-1,11011,11012,11128,11170,-1,11008,10938,10939,11007,-1,11131,11034,11035,11075,-1,11005,11065,11066,11004,-1,11137,11000,10904,10905,-1,10905,10998,11139,11137,-1,11138,11139,10998,10996,-1,11111,11136,11137,11139,-1,10992,11107,10919,10922,-1,11107,10992,11135,11109,-1,11135,10999,11000,11109,-1,11000,11108,11109,-1,11106,11108,11136,11112,-1,11106,11112,10918,10919,-1,11136,11111,11095,11112,-1,11047,11048,11167,11046,-1,4144,4217,11124,10991,-1,11143,11144,11052,11151,-1,11050,11156,11141,11053,-1,11099,10894,11097,11098,-1,10997,10985,10986,10899,-1,10982,11133,11113,10984,-1,10899,10986,11133,10982,-1,10916,11110,10967,10908,-1,11126,4225,4226,11127,-1,11156,11127,10907,11141,-1,11052,11144,11145,11146,-1,11116,11115,11002,11003,-1,10977,10912,10979,-1,11116,11003,10979,10912,-1,10913,10911,10994,10974,-1,10974,10994,11072,10970,-1,10973,11140,11071,10968,-1,10968,11071,10910,-1,11071,10909,10910,-1,4234,4170,11076,11130,-1,11031,11032,11034,11131,-1,11131,4160,4164,11031,-1,11128,4231,4233,11129,-1,11170,11128,11129,11171,-1,4236,11007,10939,11104,-1,11104,4154,4236,-1,10908,10967,10910,-1,10992,10993,11045,11135,-1,11009,11075,11035,11008,-1,11168,10928,10929,11169,-1,11032,11033,10930,10927,-1,10927,11034,11032,-1,11116,10912,11093,-1,11079,11080,10945,-1,10945,10947,11087,11121,-1,11068,10981,10980,11069,-1,11069,10980,10978,11067,-1,10995,11140,11072,-1,11072,11140,10973,10970,-1,11115,11094,11117,11119,-1,11119,11117,11081,11118,-1,11118,11081,11082,11085,-1,11085,11082,11083,11084,-1,11084,11083,11120,11121,-1,11052,10989,11151,-1,11058,11059,11126,-1,11151,11142,11143,-1,11227,11232,11233,11230,-1,11210,11184,11182,11212,-1,11194,11200,11198,11196,-1,11204,11190,11188,11206,-1,11176,11262,11241,11217,-1,11177,11261,11262,11176,-1,11179,11260,11261,11177,-1,11181,11259,11260,11179,-1,11183,11258,11259,11181,-1,11185,11257,11258,11183,-1,11187,11256,11257,11185,-1,11189,11255,11256,11187,-1,11191,11254,11255,11189,-1,11193,11253,11254,11191,-1,11195,11252,11253,11193,-1,11197,11251,11252,11195,-1,11199,11250,11251,11197,-1,11201,11249,11250,11199,-1,11203,11248,11249,11201,-1,11205,11247,11248,11203,-1,11207,11246,11247,11205,-1,11209,11245,11246,11207,-1,11211,11244,11245,11209,-1,11213,11243,11244,11211,-1,11215,11242,11243,11213};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_58()
		{
			int[] value = {-1,11217,11241,11242,11215,-1,11262,11222,11219,11241,-1,11261,11221,11222,11262,-1,11260,11224,11221,11261,-1,11259,11223,11224,11260,-1,11258,11228,11223,11259,-1,11257,11227,11228,11258,-1,11256,11232,11227,11257,-1,11255,11231,11232,11256,-1,11254,11238,11231,11255,-1,11253,11237,11238,11254,-1,11252,11239,11237,11253,-1,11251,11240,11239,11252,-1,11250,11236,11240,11251,-1,11249,11235,11236,11250,-1,11248,11234,11235,11249,-1,11247,11233,11234,11248,-1,11246,11230,11233,11247,-1,11245,11229,11230,11246,-1,11244,11226,11229,11245,-1,11243,11225,11226,11244,-1,11242,11220,11225,11243,-1,11241,11219,11220,11242,-1,11237,11239,11240,11236,-1,11231,11238,11235,11234,-1,11236,11235,11238,11237,-1,11232,11231,11234,11233,-1,11229,11226,11223,11228,-1,11228,11227,11230,11229,-1,11225,11220,11221,11224,-1,11224,11223,11226,11225,-1,11220,11219,11222,11221,-1,11202,11192,11190,11204,-1,11192,11202,11200,11194,-1,11208,11186,11184,11210,-1,11186,11208,11206,11188,-1,11214,11180,11178,11216,-1,11180,11214,11212,11182,-1,11216,11178,11175,11218,-1,11217,11218,11175,11176,-1,11215,11216,11218,11217,-1,11213,11214,11216,11215,-1,11211,11212,11214,11213,-1,11209,11210,11212,11211,-1,11207,11208,11210,11209,-1,11205,11206,11208,11207,-1,11203,11204,11206,11205,-1,11201,11202,11204,11203,-1,11199,11200,11202,11201,-1,11197,11198,11200,11199,-1,11195,11196,11198,11197,-1,11193,11194,11196,11195,-1,11191,11192,11194,11193,-1,11189,11190,11192,11191,-1,11187,11188,11190,11189,-1,11185,11186,11188,11187,-1,11183,11184,11186,11185,-1,11181,11182,11184,11183,-1,11179,11180,11182,11181,-1,11177,11178,11180,11179,-1,11176,11175,11178,11177,-1,11298,11393,11434,11296,-1,11296,11434,11433,11294,-1,11294,11433,11432,11293,-1,11293,11432,11431,11316,-1,11316,11431,11288,11270,-1,11308,11356,11321,11306,-1,11393,11394,11430,11434,-1,11434,11430,11429,11433,-1,11433,11429,11428,11432,-1,11432,11428,11427,11431,-1,11431,11427,11291,11288,-1,11356,11354,11324,11321,-1,11394,11395,11426,11430,-1,11430,11426,11425,11429,-1,11429,11425,11424,11428,-1,11428,11424,11423,11427,-1,11427,11423,11285,11291,-1,11354,11352,11326,11324,-1,11395,11396,11422,11426,-1,11426,11422,11421,11425,-1,11425,11421,11420,11424,-1,11424,11420,11419,11423,-1,11423,11419,11282,11285,-1,11352,11350,11328,11326,-1,11396,11397,11418,11422,-1,11422,11418,11417,11421,-1,11421,11417,11416,11420,-1,11420,11416,11415,11419,-1,11419,11415,11279,11282,-1,11350,11348,11330,11328,-1,11397,11398,11414,11418,-1,11418,11414,11413,11417,-1,11417,11413,11412,11416,-1,11416,11412,11411,11415,-1,11415,11411,11276,11279,-1,11348,11346,11332,11330,-1,11398,11399,11410,11414,-1,11414,11410,11409,11413,-1,11413,11409,11408,11412,-1,11412,11408,11407,11411,-1,11411,11407,11273,11276,-1,11346,11344,11334,11332,-1,11399,11400,11406,11410,-1,11410,11406,11405,11409,-1,11409,11405,11404,11408,-1,11408,11404,11403,11407,-1,11407,11403,11266,11273,-1,11344,11342,11336,11334,-1,11400,11318,11319,11406,-1,11406,11319,11402,11405,-1,11405,11402,11401,11404,-1,11404,11401,11320,11403,-1,11403,11320,11264,11266,-1,11342,11340,11338,11336,-1,11297,11317,11269,11299,-1,11320,11401,11402,11319,-1,11400,11392,11375,11318,-1,11399,11391,11392,11400,-1,11398,11390,11391,11399,-1,11397,11389,11390,11398,-1,11396,11388,11389,11397,-1,11395,11387,11388,11396,-1,11394,11386,11387,11395,-1,11393,11385,11386,11394,-1,11298,11300,11385,11393,-1,11269,11315,11301,11299,-1,11286,11384,11314,11267,-1,11289,11383,11384,11286,-1,11283,11382,11383,11289,-1,11280,11381,11382,11283,-1,11277,11380,11381,11280,-1,11274,11379,11380,11277,-1,11271,11378,11379,11274,-1,11263,11377,11378,11271,-1,11264,11376,11377,11263,-1,11318,11375,11376,11264,-1,11392,11364,11365,11375,-1,11391,11363,11364,11392,-1,11390,11362,11363,11391,-1,11389,11361,11362,11390,-1,11388,11360,11361,11389,-1,11387,11359,11360,11388,-1,11386,11358,11359,11387,-1,11385,11357,11358,11386,-1,11300,11302,11357,11385,-1,11315,11313,11303,11301,-1,11384,11374,11312,11314,-1,11383,11373,11374,11384,-1,11382,11372,11373,11383,-1,11381,11371,11372,11382,-1,11380,11370,11371,11381,-1,11379,11369,11370,11380,-1,11378,11368,11369,11379,-1,11377,11367,11368,11378,-1,11376,11366,11367,11377,-1,11375,11365,11366,11376,-1,11302,11304,11322,11357,-1,11313,11311,11305,11303,-1,11374,11355,11310,11312,-1,11373,11353,11355,11374,-1,11372,11351,11353,11373,-1,11371,11349,11351,11372,-1,11370,11347,11349,11371,-1,11369,11345,11347,11370,-1,11368,11343,11345,11369,-1,11367,11341,11343,11368,-1,11366,11339,11341,11367,-1,11365,11337,11339,11366,-1,11364,11335,11337,11365,-1,11363,11333,11335,11364,-1,11362,11331,11333,11363,-1,11361,11329,11331,11362,-1,11360,11327,11329,11361,-1,11359,11325,11327,11360,-1,11358,11323,11325,11359,-1,11357,11322,11323,11358,-1,11304,11306,11321,11322,-1,11311,11309,11307,11305,-1,11355,11356,11308,11310,-1,11353,11354,11356,11355,-1,11351,11352,11354,11353,-1,11349,11350,11352,11351,-1,11347,11348,11350,11349,-1,11345,11346,11348,11347,-1,11343,11344,11346,11345,-1,11341,11342,11344,11343,-1,11339,11340,11342,11341,-1,11337,11338,11340,11339,-1,11335,11336,11338,11337,-1,11333,11334,11336,11335,-1,11331,11332,11334,11333,-1,11329,11330,11332,11331,-1,11327,11328,11330,11329,-1,11325,11326,11328,11327,-1,11323,11324,11326,11325,-1,11322,11321,11324,11323,-1,11319,11318,11264,11320,-1,11297,11295,11292,11317,-1,11316,11317,11292,11293};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_59()
		{
			int[] value = {-1,11270,11269,11317,11316,-1,11314,11315,11269,11267,-1,11312,11313,11315,11314,-1,11310,11311,11313,11312,-1,11308,11309,11311,11310,-1,11306,11307,11309,11308,-1,11304,11305,11307,11306,-1,11302,11303,11305,11304,-1,11300,11301,11303,11302,-1,11298,11299,11301,11300,-1,11296,11297,11299,11298,-1,11294,11295,11297,11296,-1,11293,11292,11295,11294,-1,11284,11290,11291,11285,-1,11283,11289,11290,11284,-1,11290,11287,11288,11291,-1,11289,11286,11287,11290,-1,11287,11268,11270,11288,-1,11286,11267,11268,11287,-1,11281,11284,11285,11282,-1,11280,11283,11284,11281,-1,11278,11281,11282,11279,-1,11277,11280,11281,11278,-1,11275,11278,11279,11276,-1,11274,11277,11278,11275,-1,11272,11275,11276,11273,-1,11271,11274,11275,11272,-1,11265,11272,11273,11266,-1,11263,11271,11272,11265,-1,11268,11269,11270,-1,11268,11267,11269,-1,11265,11266,11264,-1,11264,11263,11265,-1,11528,11496,11497,11527,-1,11496,11528,11495,-1,11498,11527,11497,-1,11499,11512,11527,11498,-1,11500,11511,11512,11499,-1,11501,11525,11511,11500,-1,11502,11519,11525,11501,-1,11503,11516,11519,11502,-1,11504,11515,11516,11503,-1,11505,11522,11515,11504,-1,11506,11524,11522,11505,-1,11441,11507,11524,11506,-1,11443,11510,11508,11442,-1,11487,11523,11509,11444,-1,11488,11521,11523,11487,-1,11489,11518,11521,11488,-1,11490,11517,11518,11489,-1,11491,11520,11517,11490,-1,11492,11526,11520,11491,-1,11493,11514,11526,11492,-1,11494,11513,11514,11493,-1,11495,11528,11513,11494,-1,11527,11512,11513,11528,-1,11511,11525,11526,11514,-1,11525,11519,11520,11526,-1,11524,11507,11509,11523,-1,11523,11521,11522,11524,-1,11521,11518,11515,11522,-1,11519,11516,11517,11520,-1,11516,11515,11518,11517,-1,11512,11511,11514,11513,-1,11509,11510,11443,11444,-1,11507,11508,11510,11509,-1,11441,11442,11508,11507,-1,11464,11462,11472,11470,-1,11462,11460,11474,11472,-1,11460,11458,11476,11474,-1,11458,11456,11478,11476,-1,11456,11454,11480,11478,-1,11454,11452,11482,11480,-1,11452,11450,11484,11482,-1,11450,11448,11486,11484,-1,11448,11436,11437,11486,-1,11470,11468,11466,11464,-1,11506,11485,11439,11441,-1,11505,11483,11485,11506,-1,11504,11481,11483,11505,-1,11503,11479,11481,11504,-1,11502,11477,11479,11503,-1,11501,11475,11477,11502,-1,11500,11473,11475,11501,-1,11499,11471,11473,11500,-1,11498,11469,11471,11499,-1,11497,11467,11469,11498,-1,11496,11465,11467,11497,-1,11495,11463,11465,11496,-1,11494,11461,11463,11495,-1,11493,11459,11461,11494,-1,11492,11457,11459,11493,-1,11491,11455,11457,11492,-1,11490,11453,11455,11491,-1,11489,11451,11453,11490,-1,11488,11449,11451,11489,-1,11487,11447,11449,11488,-1,11444,11445,11447,11487,-1,11442,11440,11446,11443,-1,11485,11486,11437,11439,-1,11483,11484,11486,11485,-1,11481,11482,11484,11483,-1,11479,11480,11482,11481,-1,11477,11478,11480,11479,-1,11475,11476,11478,11477,-1,11473,11474,11476,11475,-1,11471,11472,11474,11473,-1,11469,11470,11472,11471,-1,11467,11468,11470,11469,-1,11465,11466,11468,11467,-1,11463,11464,11466,11465,-1,11461,11462,11464,11463,-1,11459,11460,11462,11461,-1,11457,11458,11460,11459,-1,11455,11456,11458,11457,-1,11453,11454,11456,11455,-1,11451,11452,11454,11453,-1,11449,11450,11452,11451,-1,11447,11448,11450,11449,-1,11445,11436,11448,11447,-1,11440,11438,11435,11446,-1,11445,11446,11435,11436,-1,11444,11443,11446,11445,-1,11439,11440,11442,11441,-1,11437,11438,11440,11439,-1,11436,11435,11438,11437,-1,11622,11591,11590,11621,-1,11589,11621,11590,-1,11591,11622,11592,-1,11592,11622,11607,11593,-1,11593,11607,11608,11594,-1,11594,11608,11620,11595,-1,11595,11620,11614,11596,-1,11596,11614,11611,11597,-1,11597,11611,11612,11598,-1,11598,11612,11615,11599,-1,11599,11615,11617,11600,-1,11600,11617,11602,11536,-1,11535,11601,11603,11540,-1,11539,11604,11618,11581,-1,11581,11618,11616,11582,-1,11582,11616,11609,11583,-1,11583,11609,11610,11584,-1,11584,11610,11613,11585,-1,11585,11613,11619,11586,-1,11586,11619,11605,11587,-1,11587,11605,11606,11588,-1,11588,11606,11621,11589,-1,11621,11606,11607,11622,-1,11605,11619,11620,11608,-1,11619,11613,11614,11620,-1,11618,11604,11602,11617,-1,11617,11615,11616,11618,-1,11615,11612,11609,11616,-1,11613,11610,11611,11614,-1,11610,11609,11612,11611,-1,11606,11605,11608,11607,-1,11539,11540,11603,11604,-1,11604,11603,11601,11602,-1,11602,11601,11535,11536,-1,11563,11565,11555,11557,-1,11565,11567,11553,11555,-1,11567,11569,11551,11553,-1,11569,11571,11549,11551,-1,11571,11573,11547,11549,-1,11573,11575,11545,11547,-1,11575,11577,11543,11545,-1,11577,11579,11541,11543,-1,11579,11530,11531,11541,-1,11557,11559,11561,11563,-1,11536,11534,11580,11600,-1,11600,11580,11578,11599,-1,11599,11578,11576,11598,-1,11598,11576,11574,11597,-1,11597,11574,11572,11596,-1,11596,11572,11570,11595,-1,11595,11570,11568,11594,-1,11594,11568,11566,11593,-1,11593,11566,11564,11592,-1,11592,11564,11562,11591,-1,11591,11562,11560,11590,-1,11590,11560,11558,11589,-1,11589,11558,11556,11588,-1,11588,11556,11554,11587,-1,11587,11554,11552,11586,-1,11586,11552,11550,11585,-1,11585,11550,11548,11584,-1,11584,11548,11546,11583,-1,11583,11546,11544,11582,-1,11582,11544,11542,11581,-1,11581,11542,11538,11539,-1,11540,11537,11533,11535,-1,11534,11530,11579,11580,-1,11580,11579,11577,11578,-1,11578,11577,11575,11576,-1,11576,11575,11573,11574,-1,11574,11573,11571,11572,-1,11572,11571,11569,11570,-1,11570,11569,11567,11568,-1,11568,11567,11565,11566,-1,11566,11565,11563,11564,-1,11564,11563};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_60()
		{
			int[] value = {11561,11562,-1,11562,11561,11559,11560,-1,11560,11559,11557,11558,-1,11558,11557,11555,11556,-1,11556,11555,11553,11554,-1,11554,11553,11551,11552,-1,11552,11551,11549,11550,-1,11550,11549,11547,11548,-1,11548,11547,11545,11546,-1,11546,11545,11543,11544,-1,11544,11543,11541,11542,-1,11542,11541,11531,11538,-1,11537,11532,11529,11533,-1,11531,11532,11537,11538,-1,11538,11537,11540,11539,-1,11536,11535,11533,11534,-1,11534,11533,11529,11530,-1,11530,11529,11532,11531,-1,11716,11685,11684,11715,-1,11683,11715,11684,-1,11685,11716,11686,-1,11686,11716,11701,11687,-1,11687,11701,11702,11688,-1,11688,11702,11714,11689,-1,11689,11714,11708,11690,-1,11690,11708,11705,11691,-1,11691,11705,11706,11692,-1,11692,11706,11709,11693,-1,11693,11709,11711,11694,-1,11694,11711,11696,11630,-1,11629,11695,11697,11634,-1,11633,11698,11712,11675,-1,11675,11712,11710,11676,-1,11676,11710,11703,11677,-1,11677,11703,11704,11678,-1,11678,11704,11707,11679,-1,11679,11707,11713,11680,-1,11680,11713,11699,11681,-1,11681,11699,11700,11682,-1,11682,11700,11715,11683,-1,11715,11700,11701,11716,-1,11699,11713,11714,11702,-1,11713,11707,11708,11714,-1,11712,11698,11696,11711,-1,11711,11709,11710,11712,-1,11709,11706,11703,11710,-1,11707,11704,11705,11708,-1,11704,11703,11706,11705,-1,11700,11699,11702,11701,-1,11633,11634,11697,11698,-1,11698,11697,11695,11696,-1,11696,11695,11629,11630,-1,11657,11659,11649,11651,-1,11659,11661,11647,11649,-1,11661,11663,11645,11647,-1,11663,11665,11643,11645,-1,11665,11667,11641,11643,-1,11667,11669,11639,11641,-1,11669,11671,11637,11639,-1,11671,11673,11635,11637,-1,11673,11624,11625,11635,-1,11651,11653,11655,11657,-1,11630,11628,11674,11694,-1,11694,11674,11672,11693,-1,11693,11672,11670,11692,-1,11692,11670,11668,11691,-1,11691,11668,11666,11690,-1,11690,11666,11664,11689,-1,11689,11664,11662,11688,-1,11688,11662,11660,11687,-1,11687,11660,11658,11686,-1,11686,11658,11656,11685,-1,11685,11656,11654,11684,-1,11684,11654,11652,11683,-1,11683,11652,11650,11682,-1,11682,11650,11648,11681,-1,11681,11648,11646,11680,-1,11680,11646,11644,11679,-1,11679,11644,11642,11678,-1,11678,11642,11640,11677,-1,11677,11640,11638,11676,-1,11676,11638,11636,11675,-1,11675,11636,11632,11633,-1,11634,11631,11627,11629,-1,11628,11624,11673,11674,-1,11674,11673,11671,11672,-1,11672,11671,11669,11670,-1,11670,11669,11667,11668,-1,11668,11667,11665,11666,-1,11666,11665,11663,11664,-1,11664,11663,11661,11662,-1,11662,11661,11659,11660,-1,11660,11659,11657,11658,-1,11658,11657,11655,11656,-1,11656,11655,11653,11654,-1,11654,11653,11651,11652,-1,11652,11651,11649,11650,-1,11650,11649,11647,11648,-1,11648,11647,11645,11646,-1,11646,11645,11643,11644,-1,11644,11643,11641,11642,-1,11642,11641,11639,11640,-1,11640,11639,11637,11638,-1,11638,11637,11635,11636,-1,11636,11635,11625,11632,-1,11631,11626,11623,11627,-1,11625,11626,11631,11632,-1,11632,11631,11634,11633,-1,11630,11629,11627,11628,-1,11628,11627,11623,11624,-1,11624,11623,11626,11625,-1,11769,11774,11775,11772,-1,11753,11723,11725,11751,-1,11737,11739,11741,11735,-1,11747,11729,11731,11745,-1,11760,11784,11804,11719,-1,11719,11804,11803,11718,-1,11718,11803,11802,11722,-1,11722,11802,11801,11724,-1,11724,11801,11800,11726,-1,11726,11800,11799,11728,-1,11728,11799,11798,11730,-1,11730,11798,11797,11732,-1,11732,11797,11796,11734,-1,11734,11796,11795,11736,-1,11736,11795,11794,11738,-1,11738,11794,11793,11740,-1,11740,11793,11792,11742,-1,11742,11792,11791,11744,-1,11744,11791,11790,11746,-1,11746,11790,11789,11748,-1,11748,11789,11788,11750,-1,11750,11788,11787,11752,-1,11752,11787,11786,11754,-1,11754,11786,11785,11756,-1,11756,11785,11783,11758,-1,11758,11783,11784,11760,-1,11784,11764,11761,11804,-1,11804,11761,11762,11803,-1,11803,11762,11767,11802,-1,11802,11767,11768,11801,-1,11801,11768,11771,11800,-1,11800,11771,11772,11799,-1,11799,11772,11775,11798,-1,11798,11775,11776,11797,-1,11797,11776,11777,11796,-1,11796,11777,11778,11795,-1,11795,11778,11782,11794,-1,11794,11782,11781,11793,-1,11793,11781,11779,11792,-1,11792,11779,11780,11791,-1,11791,11780,11773,11790,-1,11790,11773,11774,11789,-1,11789,11774,11769,11788,-1,11788,11769,11770,11787,-1,11787,11770,11765,11786,-1,11786,11765,11766,11785,-1,11785,11766,11763,11783,-1,11783,11763,11764,11784,-1,11779,11781,11782,11778,-1,11773,11780,11777,11776,-1,11778,11777,11780,11779,-1,11774,11773,11776,11775,-1,11771,11768,11765,11770,-1,11770,11769,11772,11771,-1,11767,11762,11763,11766,-1,11766,11765,11768,11767,-1,11762,11761,11764,11763,-1,11745,11731,11733,11743,-1,11735,11741,11743,11733,-1,11751,11725,11727,11749,-1,11729,11747,11749,11727,-1,11757,11717,11721,11755,-1,11723,11753,11755,11721,-1,11759,11720,11717,11757,-1,11719,11720,11759,11760,-1,11760,11759,11757,11758,-1,11758,11757,11755,11756,-1,11756,11755,11753,11754,-1,11754,11753,11751,11752,-1,11752,11751,11749,11750,-1,11750,11749,11747,11748,-1,11748,11747,11745,11746,-1,11746,11745,11743,11744,-1,11744,11743,11741,11742,-1,11742,11741,11739,11740,-1,11740,11739,11737,11738,-1,11738,11737,11735,11736,-1,11736,11735,11733,11734,-1,11734,11733,11731,11732,-1,11732,11731,11729,11730,-1,11730,11729,11727,11728,-1,11728,11727,11725,11726,-1,11726,11725,11723,11724,-1,11724,11723,11721,11722,-1,11722,11721,11717,11718,-1,11718,11717,11720,11719,-1,11805,11806,11807,11808,-1,11809,11810,11811,11812,-1,11813,11814,11815,11816,-1,11817,11818,11819,11820};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_61()
		{
			int[] value = {-1,11821,11822,11823,11824,-1,11825,11826,11822,11821,-1,11827,11828,11826,11825,-1,11829,11830,11828,11827,-1,11831,11832,11830,11829,-1,11833,11834,11832,11831,-1,11835,11836,11834,11833,-1,11837,11838,11836,11835,-1,11839,11840,11838,11837,-1,11841,11842,11840,11839,-1,11843,11844,11842,11841,-1,11845,11846,11844,11843,-1,11847,11848,11846,11845,-1,11849,11850,11848,11847,-1,11851,11852,11850,11849,-1,11853,11854,11852,11851,-1,11855,11856,11854,11853,-1,11857,11858,11856,11855,-1,11859,11860,11858,11857,-1,11861,11862,11860,11859,-1,11863,11864,11862,11861,-1,11824,11823,11864,11863,-1,11822,11865,11866,11823,-1,11826,11867,11865,11822,-1,11828,11868,11867,11826,-1,11830,11869,11868,11828,-1,11832,11870,11869,11830,-1,11834,11805,11870,11832,-1,11836,11806,11805,11834,-1,11838,11871,11806,11836,-1,11840,11872,11871,11838,-1,11842,11873,11872,11840,-1,11844,11874,11873,11842,-1,11846,11875,11874,11844,-1,11848,11876,11875,11846,-1,11850,11877,11876,11848,-1,11852,11878,11877,11850,-1,11854,11807,11878,11852,-1,11856,11808,11807,11854,-1,11858,11879,11808,11856,-1,11860,11880,11879,11858,-1,11862,11881,11880,11860,-1,11864,11882,11881,11862,-1,11823,11866,11882,11864,-1,11873,11874,11875,11876,-1,11871,11872,11877,11878,-1,11876,11877,11872,11873,-1,11806,11871,11878,11807,-1,11879,11880,11869,11870,-1,11870,11805,11808,11879,-1,11881,11882,11867,11868,-1,11868,11869,11880,11881,-1,11882,11866,11865,11867,-1,11883,11884,11818,11817,-1,11884,11883,11814,11813,-1,11885,11886,11810,11809,-1,11886,11885,11820,11819,-1,11887,11888,11889,11890,-1,11888,11887,11812,11811,-1,11890,11889,11891,11892,-1,11824,11892,11891,11821,-1,11863,11890,11892,11824,-1,11861,11887,11890,11863,-1,11859,11812,11887,11861,-1,11857,11809,11812,11859,-1,11855,11885,11809,11857,-1,11853,11820,11885,11855,-1,11851,11817,11820,11853,-1,11849,11883,11817,11851,-1,11847,11814,11883,11849,-1,11845,11815,11814,11847,-1,11843,11816,11815,11845,-1,11841,11813,11816,11843,-1,11839,11884,11813,11841,-1,11837,11818,11884,11839,-1,11835,11819,11818,11837,-1,11833,11886,11819,11835,-1,11831,11810,11886,11833,-1,11829,11811,11810,11831,-1,11827,11888,11811,11829,-1,11825,11889,11888,11827,-1,11821,11891,11889,11825,-1,11893,11894,11895,11896,-1,11896,11895,11897,11898,-1,11898,11897,11899,11900,-1,11900,11899,11901,11902,-1,11902,11901,11903,11904,-1,11905,11906,11907,11908,-1,11894,11909,11910,11895,-1,11895,11910,11911,11897,-1,11897,11911,11912,11899,-1,11899,11912,11913,11901,-1,11901,11913,11914,11903,-1,11906,11915,11916,11907,-1,11909,11917,11918,11910,-1,11910,11918,11919,11911,-1,11911,11919,11920,11912,-1,11912,11920,11921,11913,-1,11913,11921,11922,11914,-1,11915,11923,11924,11916,-1,11917,11925,11926,11918,-1,11918,11926,11927,11919,-1,11919,11927,11928,11920,-1,11920,11928,11929,11921,-1,11921,11929,11930,11922,-1,11923,11931,11932,11924,-1,11925,11933,11934,11926,-1,11926,11934,11935,11927,-1,11927,11935,11936,11928,-1,11928,11936,11937,11929,-1,11929,11937,11938,11930,-1,11931,11939,11940,11932,-1,11933,11941,11942,11934,-1,11934,11942,11943,11935,-1,11935,11943,11944,11936,-1,11936,11944,11945,11937,-1,11937,11945,11946,11938,-1,11939,11947,11948,11940,-1,11941,11949,11950,11942,-1,11942,11950,11951,11943,-1,11943,11951,11952,11944,-1,11944,11952,11953,11945,-1,11945,11953,11954,11946,-1,11947,11955,11956,11948,-1,11949,11957,11958,11950,-1,11950,11958,11959,11951,-1,11951,11959,11960,11952,-1,11952,11960,11961,11953,-1,11953,11961,11962,11954,-1,11955,11963,11964,11956,-1,11957,11965,11966,11958,-1,11958,11966,11967,11959,-1,11959,11967,11968,11960,-1,11960,11968,11969,11961,-1,11961,11969,11970,11962,-1,11963,11971,11972,11964,-1,11973,11974,11975,11976,-1,11969,11968,11967,11966,-1,11957,11977,11978,11965,-1,11949,11979,11977,11957,-1,11941,11980,11979,11949,-1,11933,11981,11980,11941,-1,11925,11982,11981,11933,-1,11917,11983,11982,11925,-1,11909,11984,11983,11917,-1,11894,11985,11984,11909,-1,11893,11986,11985,11894,-1,11975,11987,11988,11976,-1,11989,11990,11991,11992,-1,11993,11994,11990,11989,-1,11995,11996,11994,11993,-1,11997,11998,11996,11995,-1,11999,12000,11998,11997,-1,12001,12002,12000,11999,-1,12003,12004,12002,12001,-1,12005,12006,12004,12003,-1,11970,12007,12006,12005,-1,11965,11978,12007,11970,-1,11977,12008,12009,11978,-1,11979,12010,12008,11977,-1,11980,12011,12010,11979,-1,11981,12012,12011,11980,-1,11982,12013,12012,11981,-1,11983,12014,12013,11982,-1,11984,12015,12014,11983,-1,11985,12016,12015,11984,-1,11986,12017,12016,11985,-1,11987,12018,12019,11988,-1,11990,12020,12021,11991,-1,11994,12022,12020,11990,-1,11996,12023,12022,11994,-1,11998,12024,12023,11996,-1,12000,12025,12024,11998,-1,12002,12026,12025,12000,-1,12004,12027,12026,12002,-1,12006,12028,12027,12004,-1,12007,12029,12028,12006,-1,11978,12009,12029,12007,-1,12017,12030,12031,12016,-1,12018,12032,12033,12019,-1,12020,12034,12035,12021,-1,12022,12036,12034,12020,-1,12023,12037,12036,12022,-1,12024,12038,12037,12023,-1,12025,12039,12038,12024,-1,12026,12040,12039,12025,-1,12027,12041,12040,12026,-1,12028,12042,12041,12027,-1,12029,12043,12042,12028,-1,12009,12044,12043,12029,-1,12008,12045,12044,12009,-1,12010,12046,12045,12008,-1,12011,12047,12046,12010,-1,12012,12048,12047,12011,-1,12013,12049,12048,12012,-1,12014,12050,12049,12013,-1,12015,12051,12050,12014,-1,12016,12031,12051,12015,-1,12030,11908,11907,12031,-1,12032,12052,12053,12033};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_62()
		{
			int[] value = {-1,12034,11906,11905,12035,-1,12036,11915,11906,12034,-1,12037,11923,11915,12036,-1,12038,11931,11923,12037,-1,12039,11939,11931,12038,-1,12040,11947,11939,12039,-1,12041,11955,11947,12040,-1,12042,11963,11955,12041,-1,12043,11971,11963,12042,-1,12044,11972,11971,12043,-1,12045,11964,11972,12044,-1,12046,11956,11964,12045,-1,12047,11948,11956,12046,-1,12048,11940,11948,12047,-1,12049,11932,11940,12048,-1,12050,11924,11932,12049,-1,12051,11916,11924,12050,-1,12031,11907,11916,12051,-1,11966,11965,11970,11969,-1,11973,12054,12055,11974,-1,11902,11974,12055,11900,-1,11904,11975,11974,11902,-1,11991,11987,11975,11992,-1,12021,12018,11987,11991,-1,12035,12032,12018,12021,-1,11905,12052,12032,12035,-1,11908,12053,12052,11905,-1,12030,12033,12053,11908,-1,12017,12019,12033,12030,-1,11986,11988,12019,12017,-1,11893,11976,11988,11986,-1,11896,11973,11976,11893,-1,11898,12054,11973,11896,-1,11900,12055,12054,11898,-1,12056,12057,11914,11922,-1,11995,11993,12057,12056,-1,12057,12058,11903,11914,-1,11993,11989,12058,12057,-1,12058,12059,11904,11903,-1,11989,11992,12059,12058,-1,12060,12056,11922,11930,-1,11997,11995,12056,12060,-1,12061,12060,11930,11938,-1,11999,11997,12060,12061,-1,12062,12061,11938,11946,-1,12001,11999,12061,12062,-1,12063,12062,11946,11954,-1,12003,12001,12062,12063,-1,12064,12063,11954,11962,-1,12005,12003,12063,12064,-1,12059,11975,11904,-1,12059,11992,11975,-1,12064,11962,11970,-1,11970,12005,12064,-1,12065,12066,12067,12068,-1,12066,12065,12069,-1,12070,12068,12067,-1,12071,12072,12068,12070,-1,12073,12074,12072,12071,-1,12075,12076,12074,12073,-1,12077,12078,12076,12075,-1,12079,12080,12078,12077,-1,12081,12082,12080,12079,-1,12083,12084,12082,12081,-1,12085,12086,12084,12083,-1,12087,12088,12086,12085,-1,12089,12090,12091,12092,-1,12093,12094,12095,12096,-1,12097,12098,12094,12093,-1,12099,12100,12098,12097,-1,12101,12102,12100,12099,-1,12103,12104,12102,12101,-1,12105,12106,12104,12103,-1,12107,12108,12106,12105,-1,12109,12110,12108,12107,-1,12069,12065,12110,12109,-1,12068,12072,12110,12065,-1,12074,12076,12106,12108,-1,12076,12078,12104,12106,-1,12086,12088,12095,12094,-1,12094,12098,12084,12086,-1,12098,12100,12082,12084,-1,12078,12080,12102,12104,-1,12080,12082,12100,12102,-1,12072,12074,12108,12110,-1,12095,12090,12089,12096,-1,12088,12091,12090,12095,-1,12087,12092,12091,12088,-1,12111,12112,12113,12114,-1,12112,12115,12116,12113,-1,12115,12117,12118,12116,-1,12117,12119,12120,12118,-1,12119,12121,12122,12120,-1,12121,12123,12124,12122,-1,12123,12125,12126,12124,-1,12125,12127,12128,12126,-1,12127,12129,12130,12128,-1,12114,12131,12132,12111,-1,12085,12133,12134,12087,-1,12083,12135,12133,12085,-1,12081,12136,12135,12083,-1,12079,12137,12136,12081,-1,12077,12138,12137,12079,-1,12075,12139,12138,12077,-1,12073,12140,12139,12075,-1,12071,12141,12140,12073,-1,12070,12142,12141,12071,-1,12067,12143,12142,12070,-1,12066,12144,12143,12067,-1,12069,12145,12144,12066,-1,12109,12146,12145,12069,-1,12107,12147,12146,12109,-1,12105,12148,12147,12107,-1,12103,12149,12148,12105,-1,12101,12150,12149,12103,-1,12099,12151,12150,12101,-1,12097,12152,12151,12099,-1,12093,12153,12152,12097,-1,12096,12154,12153,12093,-1,12092,12155,12156,12089,-1,12133,12128,12130,12134,-1,12135,12126,12128,12133,-1,12136,12124,12126,12135,-1,12137,12122,12124,12136,-1,12138,12120,12122,12137,-1,12139,12118,12120,12138,-1,12140,12116,12118,12139,-1,12141,12113,12116,12140,-1,12142,12114,12113,12141,-1,12143,12131,12114,12142,-1,12144,12132,12131,12143,-1,12145,12111,12132,12144,-1,12146,12112,12111,12145,-1,12147,12115,12112,12146,-1,12148,12117,12115,12147,-1,12149,12119,12117,12148,-1,12150,12121,12119,12149,-1,12151,12123,12121,12150,-1,12152,12125,12123,12151,-1,12153,12127,12125,12152,-1,12154,12129,12127,12153,-1,12155,12157,12158,12156,-1,12154,12156,12158,12129,-1,12096,12089,12156,12154,-1,12134,12155,12092,12087,-1,12130,12157,12155,12134,-1,12129,12158,12157,12130,-1,12159,12160,12161,12162,-1,12163,12162,12161,-1,12160,12159,12164,-1,12164,12159,12165,12166,-1,12166,12165,12167,12168,-1,12168,12167,12169,12170,-1,12170,12169,12171,12172,-1,12172,12171,12173,12174,-1,12174,12173,12175,12176,-1,12176,12175,12177,12178,-1,12178,12177,12179,12180,-1,12180,12179,12181,12182,-1,12183,12184,12185,12186,-1,12187,12188,12189,12190,-1,12190,12189,12191,12192,-1,12192,12191,12193,12194,-1,12194,12193,12195,12196,-1,12196,12195,12197,12198,-1,12198,12197,12199,12200,-1,12200,12199,12201,12202,-1,12202,12201,12203,12204,-1,12204,12203,12162,12163,-1,12162,12203,12165,12159,-1,12201,12199,12169,12167,-1,12199,12197,12171,12169,-1,12189,12188,12181,12179,-1,12179,12177,12191,12189,-1,12177,12175,12193,12191,-1,12197,12195,12173,12171,-1,12195,12193,12175,12173,-1,12203,12201,12167,12165,-1,12187,12186,12185,12188,-1,12188,12185,12184,12181,-1,12181,12184,12183,12182,-1,12205,12206,12207,12208,-1,12206,12209,12210,12207,-1,12209,12211,12212,12210,-1,12211,12213,12214,12212,-1,12213,12215,12216,12214,-1,12215,12217,12218,12216,-1,12217,12219,12220,12218,-1,12219,12221,12222,12220,-1,12221,12223,12224,12222,-1,12208,12225,12226,12205,-1,12182,12227,12228,12180,-1,12180,12228,12229,12178,-1,12178,12229,12230,12176,-1,12176,12230,12231,12174,-1,12174,12231,12232,12172,-1,12172,12232,12233,12170,-1,12170,12233,12234,12168,-1,12168,12234,12235,12166,-1,12166,12235,12236,12164,-1,12164,12236,12237,12160,-1,12160,12237};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_63()
		{
			int[] value = {12238,12161,-1,12161,12238,12239,12163,-1,12163,12239,12240,12204,-1,12204,12240,12241,12202,-1,12202,12241,12242,12200,-1,12200,12242,12243,12198,-1,12198,12243,12244,12196,-1,12196,12244,12245,12194,-1,12194,12245,12246,12192,-1,12192,12246,12247,12190,-1,12190,12247,12248,12187,-1,12186,12249,12250,12183,-1,12227,12223,12221,12228,-1,12228,12221,12219,12229,-1,12229,12219,12217,12230,-1,12230,12217,12215,12231,-1,12231,12215,12213,12232,-1,12232,12213,12211,12233,-1,12233,12211,12209,12234,-1,12234,12209,12206,12235,-1,12235,12206,12205,12236,-1,12236,12205,12226,12237,-1,12237,12226,12225,12238,-1,12238,12225,12208,12239,-1,12239,12208,12207,12240,-1,12240,12207,12210,12241,-1,12241,12210,12212,12242,-1,12242,12212,12214,12243,-1,12243,12214,12216,12244,-1,12244,12216,12218,12245,-1,12245,12218,12220,12246,-1,12246,12220,12222,12247,-1,12247,12222,12224,12248,-1,12249,12251,12252,12250,-1,12224,12251,12249,12248,-1,12248,12249,12186,12187,-1,12182,12183,12250,12227,-1,12227,12250,12252,12223,-1,12223,12252,12251,12224,-1,12253,12254,12255,12256,-1,12257,12256,12255,-1,12254,12253,12258,-1,12258,12253,12259,12260,-1,12260,12259,12261,12262,-1,12262,12261,12263,12264,-1,12264,12263,12265,12266,-1,12266,12265,12267,12268,-1,12268,12267,12269,12270,-1,12270,12269,12271,12272,-1,12272,12271,12273,12274,-1,12274,12273,12275,12276,-1,12277,12278,12279,12280,-1,12281,12282,12283,12284,-1,12284,12283,12285,12286,-1,12286,12285,12287,12288,-1,12288,12287,12289,12290,-1,12290,12289,12291,12292,-1,12292,12291,12293,12294,-1,12294,12293,12295,12296,-1,12296,12295,12297,12298,-1,12298,12297,12256,12257,-1,12256,12297,12259,12253,-1,12295,12293,12263,12261,-1,12293,12291,12265,12263,-1,12283,12282,12275,12273,-1,12273,12271,12285,12283,-1,12271,12269,12287,12285,-1,12291,12289,12267,12265,-1,12289,12287,12269,12267,-1,12297,12295,12261,12259,-1,12281,12280,12279,12282,-1,12282,12279,12278,12275,-1,12275,12278,12277,12276,-1,12299,12300,12301,12302,-1,12300,12303,12304,12301,-1,12303,12305,12306,12304,-1,12305,12307,12308,12306,-1,12307,12309,12310,12308,-1,12309,12311,12312,12310,-1,12311,12313,12314,12312,-1,12313,12315,12316,12314,-1,12315,12317,12318,12316,-1,12302,12319,12320,12299,-1,12276,12321,12322,12274,-1,12274,12322,12323,12272,-1,12272,12323,12324,12270,-1,12270,12324,12325,12268,-1,12268,12325,12326,12266,-1,12266,12326,12327,12264,-1,12264,12327,12328,12262,-1,12262,12328,12329,12260,-1,12260,12329,12330,12258,-1,12258,12330,12331,12254,-1,12254,12331,12332,12255,-1,12255,12332,12333,12257,-1,12257,12333,12334,12298,-1,12298,12334,12335,12296,-1,12296,12335,12336,12294,-1,12294,12336,12337,12292,-1,12292,12337,12338,12290,-1,12290,12338,12339,12288,-1,12288,12339,12340,12286,-1,12286,12340,12341,12284,-1,12284,12341,12342,12281,-1,12280,12343,12344,12277,-1,12321,12317,12315,12322,-1,12322,12315,12313,12323,-1,12323,12313,12311,12324,-1,12324,12311,12309,12325,-1,12325,12309,12307,12326,-1,12326,12307,12305,12327,-1,12327,12305,12303,12328,-1,12328,12303,12300,12329,-1,12329,12300,12299,12330,-1,12330,12299,12320,12331,-1,12331,12320,12319,12332,-1,12332,12319,12302,12333,-1,12333,12302,12301,12334,-1,12334,12301,12304,12335,-1,12335,12304,12306,12336,-1,12336,12306,12308,12337,-1,12337,12308,12310,12338,-1,12338,12310,12312,12339,-1,12339,12312,12314,12340,-1,12340,12314,12316,12341,-1,12341,12316,12318,12342,-1,12343,12345,12346,12344,-1,12318,12345,12343,12342,-1,12342,12343,12280,12281,-1,12276,12277,12344,12321,-1,12321,12344,12346,12317,-1,12317,12346,12345,12318,-1,12347,12348,12349,12350,-1,12351,12352,12353,12354,-1,12355,12356,12357,12358,-1,12359,12360,12361,12362,-1,12363,12364,12365,12366,-1,12366,12365,12367,12368,-1,12368,12367,12369,12370,-1,12370,12369,12371,12372,-1,12372,12371,12373,12374,-1,12374,12373,12375,12376,-1,12376,12375,12377,12378,-1,12378,12377,12379,12380,-1,12380,12379,12381,12382,-1,12382,12381,12383,12384,-1,12384,12383,12385,12386,-1,12386,12385,12387,12388,-1,12388,12387,12389,12390,-1,12390,12389,12391,12392,-1,12392,12391,12393,12394,-1,12394,12393,12395,12396,-1,12396,12395,12397,12398,-1,12398,12397,12399,12400,-1,12400,12399,12401,12402,-1,12402,12401,12403,12404,-1,12404,12403,12405,12406,-1,12406,12405,12364,12363,-1,12364,12407,12408,12365,-1,12365,12408,12409,12367,-1,12367,12409,12410,12369,-1,12369,12410,12411,12371,-1,12371,12411,12412,12373,-1,12373,12412,12350,12375,-1,12375,12350,12349,12377,-1,12377,12349,12413,12379,-1,12379,12413,12414,12381,-1,12381,12414,12415,12383,-1,12383,12415,12416,12385,-1,12385,12416,12417,12387,-1,12387,12417,12418,12389,-1,12389,12418,12419,12391,-1,12391,12419,12420,12393,-1,12393,12420,12348,12395,-1,12395,12348,12347,12397,-1,12397,12347,12421,12399,-1,12399,12421,12422,12401,-1,12401,12422,12423,12403,-1,12403,12423,12424,12405,-1,12405,12424,12407,12364,-1,12418,12417,12416,12415,-1,12420,12419,12414,12413,-1,12415,12414,12419,12418,-1,12348,12420,12413,12349,-1,12412,12411,12422,12421,-1,12421,12347,12350,12412,-1,12410,12409,12424,12423,-1,12423,12422,12411,12410,-1,12409,12408,12407,12424,-1,12362,12361,12425,12426,-1,12358,12357,12426,12425,-1,12354,12353,12427,12428,-1,12360,12359,12428,12427,-1,12429,12430,12431,12432,-1,12352,12351,12432,12431,-1,12433,12434,12430,12429,-1,12366,12434,12433,12363,-1,12363,12433,12429,12406,-1,12406,12429,12432,12404,-1,12404,12432,12351,12402,-1,12402,12351,12354,12400};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_64()
		{
			int[] value = {-1,12400,12354,12428,12398,-1,12398,12428,12359,12396,-1,12396,12359,12362,12394,-1,12394,12362,12426,12392,-1,12392,12426,12357,12390,-1,12390,12357,12356,12388,-1,12388,12356,12355,12386,-1,12386,12355,12358,12384,-1,12384,12358,12425,12382,-1,12382,12425,12361,12380,-1,12380,12361,12360,12378,-1,12378,12360,12427,12376,-1,12376,12427,12353,12374,-1,12374,12353,12352,12372,-1,12372,12352,12431,12370,-1,12370,12431,12430,12368,-1,12368,12430,12434,12366,-1,10462,10798,10787,10789,10397,10461,-1,10892,10463,10464,-1,10798,12435,10638,10396,10787,-1,12435,10531,10550,10639,10638,-1,12435,12436,12437,10531,-1,12436,10614,10421,10633,12437,-1,12438,12439,10463,-1,12439,12440,10782,10463,-1,12439,12441,10588,12440,-1,12441,10607,10632,10588,-1,10632,10427,10615,10588,-1,10761,10763,10630,-1,10892,10893,10481,12438,10463,-1,10569,12444,12443,12442,-1,12465,12464,12463,12462,-1,12464,12442,12443,12463,-1,12469,12468,12467,12466,-1,12473,12472,12471,12470,-1,12475,12474,12469,12466,-1,12468,12478,12477,12476,-1,12480,12479,12476,12477,-1,12479,12480,12482,12481,-1,12481,12482,12484,12483,-1,12473,12470,12483,12484,-1,12487,12486,12485,-1,12491,12490,12489,12488,-1,12488,12489,12493,12492,-1,12497,12496,12495,12494,-1,12494,12495,12499,12498,-1,12498,12499,12501,12500,-1,12503,12502,12500,12501,-1,12502,12503,12505,12504,-1,12504,12505,12487,12485,-1,12509,12508,12507,12506,-1,12508,12509,12510,-1,12474,12475,12511,-1,12469,12478,12468,-1,12466,12467,12512,-1,12475,12466,12512,12513,-1,12511,12475,12513,12514,-1,12514,12516,12515,-1,12515,12517,12514,-1,12519,12518,12490,12491,-1,12506,12507,12518,12519,-1,12462,12463,12521,12520,-1,12463,12443,12522,12521,-1,12443,12444,12523,12522,-1,12525,12524,12492,12493,-1,12496,12497,12524,12525,-1,12528,12527,12526,-1,12528,12529,12527,-1,12533,12532,12531,12530,-1,12535,12534,12532,12533,-1,12526,12534,12535,12528,-1,12535,12536,12528,-1,12541,12505,12503,12540,-1,12547,12545,12542,12546,-1,12543,12544,12495,12496,-1,12551,12546,12548,-1,12549,12550,12530,12531,12552,-1,12501,12499,12537,12538,-1,12556,12555,12554,12553,-1,12558,12557,12554,12555,-1,12562,12561,12560,12559,-1,12565,12527,12564,12563,-1,12569,12568,12567,12566,-1,12571,12570,12567,12568,-1,10496,12574,12573,12572,-1,12448,12576,12575,12447,-1,12541,12580,12487,12505,-1,12553,12469,12474,12556,-1,12584,12583,12582,12581,-1,12507,12508,12586,12585,-1,12587,12588,12493,12489,-1,12592,12591,12590,12589,-1,12596,12595,12594,12593,-1,12599,12598,12597,-1,12597,12598,12445,12446,-1,12600,12549,12552,12601,-1,12603,12565,12563,12602,-1,12558,12560,12561,12557,-1,12499,12495,12544,12537,-1,12604,12445,12598,12605,-1,12607,12594,12595,12606,-1,12606,12609,12608,12607,-1,12605,12611,12610,12604,-1,12517,12556,12474,12511,-1,12449,12555,12556,12517,12515,-1,12450,12558,12555,12449,-1,12451,12560,12558,12450,-1,12452,12559,12560,12451,-1,12455,12589,12590,12454,-1,12458,12459,12583,12584,-1,12460,12563,12564,12583,12459,-1,12461,12602,12563,12460,-1,12613,12595,12596,12612,-1,12614,12606,12595,12613,-1,12615,12609,12606,12614,-1,12617,12568,12569,12616,-1,12618,12571,12568,12617,-1,10406,10496,12572,12619,-1,12527,12565,12620,12526,-1,12603,12621,12620,12565,-1,12594,12623,12622,12593,-1,12607,12624,12623,12594,-1,12608,12625,12624,12607,-1,12567,12627,12626,12566,-1,12570,12628,12627,12567,-1,12574,12630,12629,12573,-1,12633,12582,12527,12529,-1,12620,12634,12534,12526,-1,12621,12635,12634,12620,-1,12623,12637,12636,12622,-1,12624,12638,12637,12623,-1,12625,12639,12638,12624,-1,12627,12641,12640,12626,-1,12628,12642,12641,12627,-1,12630,12465,12462,12629,-1,12644,12643,12536,12535,-1,12576,12646,12645,12575,-1,12649,12476,12479,12648,-1,12553,12651,12650,12469,-1,12554,12652,12651,12553,-1,12557,12653,12652,12554,-1,12561,12654,12653,12557,-1,12562,12655,12654,12561,-1,12592,12657,12656,12591,-1,12581,12582,12633,12658,-1,12646,12540,12659,12645,-1,12650,12486,12487,12580,12662,-1,12651,12485,12486,12650,-1,12652,12502,12504,12651,-1,12664,12498,12500,12663,-1,12665,12494,12498,12664,-1,12666,12497,12494,12665,-1,12668,12488,12492,12667,-1,12670,12669,12509,12506,-1,12647,12671,12483,12470,-1,12476,12649,12467,12468,-1,12662,12480,12477,12650,-1,12672,12631,12632,12510,-1,12529,12672,12510,12633,-1,12527,12582,12583,12564,-1,12535,12533,12673,12644,-1,12634,12674,12532,12534,-1,12635,12675,12674,12634,-1,12637,12677,12676,12636,-1,12638,12678,12677,12637,-1,12639,12679,12678,12638,-1,12641,12681,12680,12640,-1,12642,12682,12681,12641,-1,12533,12530,12550,12673,-1,12674,12552,12531,12532,-1,12675,12601,12552,12674,-1,12677,12598,12599,12676,-1,12678,12605,12598,12677,-1,12679,12611,12605,12678,-1,12681,12546,12551,12680,-1,12682,12547,12546,12681,-1,12683,12587,12489,12490,-1,12491,12488,12668,12684,-1,12686,12657,12592,12685,-1,12685,12592,12589,12687,-1,12687,12589,12455,12456,-1,12632,12586,12508,12510,-1,12540,12538,12539,12659,-1,12503,12501,12538,12540,-1,12652,12663,12500,12502,-1,12653,12664,12663,12652,-1,12654,12665,12664,12653,-1,12655,12666,12665,12654,-1,12657,12668,12667,12656,-1,12686,12684,12668,12657,-1,12633,12669,12670,12658,-1,12510,12509,12669,12633,-1,12448,12689,12688,12576,-1,12691,12690,12689,12448,-1,12693,12692,12690,12691,-1,12479,12481,12694,12648,-1,12662,12695,12482,12480,-1,12580,12696,12695,12662,-1,12541,12697,12696,12580,-1,12540,12698,12697,12541,-1,12646,12699,12698,12540};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_65()
		{
			int[] value = {-1,12576,12688,12699,12646,-1,12692,12579,12577,12690,-1,12481,12483,12671,12694,-1,12695,12700,12484,12482,-1,12696,12661,12700,12695,-1,12697,12660,12661,12696,-1,12661,12472,12473,12700,-1,12700,12473,12484,-1,12478,12650,12477,-1,12650,12478,12469,-1,12651,12504,12485,-1,12647,12578,12701,-1,12517,12511,12514,-1,12467,12649,12702,12512,-1,12703,12702,12649,12648,-1,12648,12694,12704,12703,-1,12694,12671,12705,12704,-1,12701,12705,12671,12647,-1,12706,12701,12578,12579,-1,12707,12706,12579,12692,-1,12708,12707,12692,12693,-1,12672,12529,12528,-1,12709,12518,12507,12585,-1,12683,12490,12518,12709,-1,12519,12710,12670,12506,-1,12491,12684,12710,12519,-1,12711,12457,12458,12584,-1,12687,12456,12457,12711,-1,12712,12711,12584,12581,-1,12685,12687,12711,12712,-1,12713,12712,12581,12658,-1,12686,12685,12712,12713,-1,12713,12710,12684,12686,-1,12658,12670,12710,12713,-1,12714,12715,12551,12548,-1,12610,12611,12715,12714,-1,12716,12715,12611,12679,-1,12680,12551,12715,12716,-1,12718,12717,12609,12615,-1,12616,12569,12717,12718,-1,12719,12717,12569,12566,-1,12608,12609,12717,12719,-1,12719,12720,12625,12608,-1,12566,12626,12720,12719,-1,12720,12721,12639,12625,-1,12626,12640,12721,12720,-1,12721,12716,12679,12639,-1,12640,12680,12716,12721,-1,12528,12722,12631,12672,-1,12536,12643,12722,12528,-1,12520,12521,12682,12642,-1,12723,12520,12642,12628,-1,12629,12462,12520,12723,-1,12724,12723,12628,12570,-1,12573,12629,12723,12724,-1,12725,12724,12570,12571,-1,12572,12573,12724,12725,-1,12726,12725,12571,12618,-1,12619,12572,12725,12726,-1,12521,12522,12547,12682,-1,12522,12523,12545,12547,-1,12728,12727,12675,12635,-1,12636,12676,12727,12728,-1,12729,12728,12635,12621,-1,12622,12636,12728,12729,-1,12730,12729,12621,12603,-1,12593,12622,12729,12730,-1,12730,12731,12596,12593,-1,12603,12602,12731,12730,-1,12732,12731,12602,12461,-1,12612,12596,12731,12732,-1,12727,12733,12601,12675,-1,12676,12599,12733,12727,-1,12734,12733,12599,12597,-1,12600,12601,12733,12734,-1,12736,12735,12666,12655,-1,12656,12667,12735,12736,-1,12737,12736,12655,12562,-1,12591,12656,12736,12737,-1,12738,12737,12562,12559,-1,12590,12591,12737,12738,-1,12453,12738,12559,12452,-1,12454,12590,12738,12453,-1,12735,12524,12497,12666,-1,12667,12492,12524,12735,-1,12525,12739,12543,12496,-1,12493,12588,12739,12525,-1,12448,12449,12515,12516,12693,12691,-1,12516,12514,12513,12708,12693,-1,12513,12512,12702,12703,12708,-1,12703,12704,12707,12708,-1,12704,12705,12701,12706,12707,-1,12743,12742,12741,12740,-1,12747,12746,12745,12744,-1,12749,12748,12745,12746,-1,12753,12752,12751,12750,-1,12756,10541,12755,12754,-1,12760,12759,12758,12757,-1,12757,12758,12761,-1,12763,12762,12742,12743,-1,12766,12765,10472,12764,-1,12770,12769,12768,12767,-1,12772,12771,12769,12770,-1,12776,12775,12774,12773,-1,12780,12779,12778,12777,-1,12784,12783,12782,12781,-1,12788,12787,12786,12785,-1,12790,12789,12787,12788,-1,12794,12793,12792,12791,-1,12798,12797,12796,12795,-1,12802,12801,12800,12799,-1,12806,12805,12804,12803,-1,12808,12785,12786,12807,-1,12751,12752,12810,12809,-1,12811,10540,10541,12756,-1,12815,12814,12813,12812,-1,12819,12818,12817,12816,-1,12791,12821,12820,12794,-1,12747,12823,12822,12746,-1,12746,12822,12824,12749,-1,12777,12826,12825,12780,-1,12762,12828,12827,12742,-1,12742,12827,12829,12741,-1,12818,12831,12830,12817,-1,12784,12804,12805,12783,-1,12759,12800,12801,12758,-1,12833,12770,12767,12832,-1,12834,12772,12770,12833,-1,12836,12776,12773,12835,-1,12838,12780,12825,12837,-1,12839,12779,12780,12838,-1,12841,12784,12781,12840,-1,12842,12804,12784,12841,-1,12843,12803,12804,12842,-1,12786,12845,12844,12807,-1,12787,12846,12845,12786,-1,12789,12847,12846,12787,-1,12794,12849,12848,12793,-1,12820,12850,12849,12794,-1,12798,12852,12851,12797,-1,12818,12854,12853,12831,-1,12819,12855,12854,12818,-1,12813,12857,12856,12812,-1,12765,12754,12755,10472,-1,12769,12762,12763,12768,-1,12771,12828,12762,12769,-1,12775,12753,12750,12774,-1,12777,12749,12824,12826,-1,12778,12748,12749,12777,-1,12783,12759,12760,12782,-1,12805,12800,12759,12783,-1,12806,12799,12800,12805,-1,12859,12766,12764,12858,-1,12863,12862,12861,12860,-1,12865,12864,12862,12863,-1,12867,12866,12864,12865,-1,12871,12870,12869,12868,-1,12873,12872,12870,12871,-1,12877,12876,12875,12874,-1,12881,12880,12879,12878,-1,12883,12882,12880,12881,-1,10471,10597,12885,12884,-1,12811,12886,10598,10540,-1,12741,12888,12887,12740,-1,12829,12889,12888,12741,-1,12810,12891,12890,12809,-1,12747,12893,12892,12823,-1,12744,12894,12893,12747,-1,12758,12896,12895,12761,-1,12801,12897,12896,12758,-1,12802,12898,12897,12801,-1,12862,12785,12808,12861,-1,12864,12788,12785,12862,-1,12866,12790,12788,12864,-1,12870,12791,12792,12869,-1,12872,12821,12791,12870,-1,12876,12795,12796,12875,-1,12880,12817,12830,12879,-1,12882,12816,12817,12880,-1,10597,12814,12815,12885,-1,12886,12856,12857,10598,-1,12888,12854,12855,12887,-1,12889,12853,12854,12888,-1,12891,12851,12852,12890,-1,12893,12849,12850,12892,-1,12894,12848,12849,12893,-1,12896,12846,12895,-1,12897,12845,12846,12896,-1,12898,12844,12845,12897,-1,12900,12899,12872,12873,-1,12874,12875,12899,12900,-1,12899,12901,12821,12872,-1,12875,12796,12901,12899,-1,12901,12902,12820,12821,-1,12796,12797,12902,12901,-1,12902,12903,12850,12820,-1,12797,12851,12903,12902,-1,12904,12903,12851,12891,-1,12892,12850,12903,12904,-1,12905,12904,12891,12810,-1,12823,12892,12904};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_66()
		{
			int[] value = {12905,-1,12905,12906,12822,12823,-1,12810,12752,12906,12905,-1,12907,12906,12752,12753,-1,12824,12822,12906,12907,-1,12908,12907,12753,12775,-1,12826,12824,12907,12908,-1,12910,12909,12776,12836,-1,12837,12825,12909,12910,-1,12909,12908,12775,12776,-1,12825,12826,12908,12909,-1,12912,12911,12882,12883,-1,12884,12885,12911,12912,-1,12911,12913,12816,12882,-1,12885,12815,12913,12911,-1,12914,12913,12815,12812,-1,12819,12816,12913,12914,-1,12914,12915,12855,12819,-1,12812,12856,12915,12914,-1,12916,12915,12856,12886,-1,12887,12855,12915,12916,-1,12917,12916,12886,12811,-1,12740,12887,12916,12917,-1,12917,12918,12743,12740,-1,12811,12756,12918,12917,-1,12919,12918,12756,12754,-1,12763,12743,12918,12919,-1,12920,12919,12754,12765,-1,12768,12763,12919,12920,-1,12922,12921,12766,12859,-1,12832,12767,12921,12922,-1,12921,12920,12765,12766,-1,12767,12768,12920,12921,-1,12924,12923,12771,12772,-1,12773,12774,12923,12924,-1,12925,12924,12772,12834,-1,12835,12773,12924,12925,-1,12923,12926,12828,12771,-1,12774,12750,12926,12923,-1,12926,12927,12827,12828,-1,12750,12751,12927,12926,-1,12927,12928,12829,12827,-1,12751,12809,12928,12927,-1,12928,12929,12889,12829,-1,12809,12890,12929,12928,-1,12929,12930,12853,12889,-1,12890,12852,12930,12929,-1,12931,12930,12852,12798,-1,12831,12853,12930,12931,-1,12932,12931,12798,12795,-1,12830,12831,12931,12932,-1,12933,12932,12795,12876,-1,12879,12830,12932,12933,-1,12934,12933,12876,12877,-1,12878,12879,12933,12934,-1,12936,12935,12748,12778,-1,12782,12760,12935,12936,-1,12937,12936,12778,12779,-1,12781,12782,12936,12937,-1,12938,12937,12779,12839,-1,12840,12781,12937,12938,-1,12935,12939,12745,12748,-1,12760,12757,12939,12935,-1,12939,12940,12744,12745,-1,12757,12761,12940,12939,-1,12940,12941,12894,12744,-1,12761,12895,12941,12940,-1,12941,12942,12848,12894,-1,12895,12847,12942,12941,-1,12943,12942,12847,12789,-1,12793,12848,12942,12943,-1,12944,12943,12789,12790,-1,12792,12793,12943,12944,-1,12945,12944,12790,12866,-1,12869,12792,12944,12945,-1,12946,12945,12866,12867,-1,12868,12869,12945,12946,-1,12948,12947,12799,12806,-1,12806,12803,12949,12948,-1,12950,12949,12803,12843,-1,12802,12799,12947,12951,-1,12951,12952,12898,12802,-1,12952,12953,12844,12898,-1,12807,12844,12953,12954,-1,12954,12955,12808,12807,-1,12861,12808,12955,12956,-1,12860,12861,12956,12957,-1,12950,12843,12842,12841,12840,12938,12839,12838,12837,12910,12836,12835,12925,12834,12833,12832,12922,12859,12858,12959,10471,12884,12912,12883,12881,12878,12934,12877,12874,12900,12873,12871,12868,12946,12867,12865,12958,-1,12865,12863,12958,-1,12863,12947,12948,-1,12863,12860,12957,12947,-1,12957,12956,12951,12947,-1,12956,12953,12952,12951,-1,12956,12955,12954,12953,-1,12846,12847,12895,-1,12863,12948,12949,12950,12958,-1,12962,12961,12960,-1,12969,12968,12967,-1,5070,5069,12970,-1,12973,12972,12971,-1,12976,12975,12974,-1,12979,12978,12977,-1,12982,12981,12980,-1,12985,12984,12982,12983,-1,12989,12988,12987,12986,-1,12993,12992,12991,12990,-1,12997,12996,12995,12994,-1,13000,12999,12998,-1,13003,13002,13001,-1,13006,13005,13004,10897,-1,13007,5063,5095,-1,5096,13008,13007,5095,-1,13009,5063,13007,-1,13008,13010,13009,13007,-1,13011,12966,5063,13009,-1,13010,13012,13011,13009,-1,12966,13011,13013,-1,13014,13013,13011,13012,-1,13015,12966,13013,-1,12966,13015,13016,-1,13015,13013,13014,12999,-1,13016,13017,12966,-1,13016,13015,12999,13018,-1,13017,13016,13018,13019,-1,13020,12965,12966,13017,-1,13017,13019,13021,13020,-1,12965,13020,13022,-1,13022,13020,13021,13023,-1,12965,13022,13024,-1,13024,13022,13023,13025,-1,12964,12965,13024,13026,-1,12972,13026,13024,13025,-1,13027,12964,13026,-1,12972,12978,13027,13026,-1,12978,12982,13028,13027,-1,12964,13027,13028,-1,12964,13028,13029,-1,12984,13029,13028,12982,-1,12963,12964,13029,13030,-1,13030,13031,12963,-1,13030,13029,12984,13032,-1,13031,13030,13032,13033,-1,13036,12971,13035,13034,-1,13040,13039,13038,13037,-1,13034,13035,13037,13038,-1,13039,13040,13042,13041,-1,13041,13042,12974,13043,-1,13043,12974,12975,-1,12976,13044,12975,-1,13047,13046,13044,13045,-1,12976,13048,13045,13044,-1,12972,12973,12977,12978,-1,12962,13049,12961,-1,13051,13050,13049,12962,-1,12967,13054,13053,13052,-1,13057,13056,13055,-1,12970,13058,5103,5070,-1,12985,12983,13060,13059,-1,13048,12976,13062,13061,-1,13065,13064,13054,13063,-1,12968,13063,13054,12967,-1,13068,13067,12969,13066,-1,13072,13071,13070,13069,-1,13076,13075,13074,13073,-1,13080,13079,13078,13077,-1,12987,13082,13081,12986,-1,13082,12987,13084,13083,-1,13086,13085,12986,13081,-1,13088,13087,13081,13082,-1,13090,13088,13089,-1,13094,13093,13092,13091,-1,13096,13095,13093,13094,-1,13091,13092,13083,13084,-1,13100,13099,13098,13097,-1,12993,13102,13101,-1,13079,13080,12990,12991,-1,13004,13005,12992,12993,-1,13106,13105,13104,13103,-1,13110,13109,13108,13107,-1,13103,13104,13109,13110,-1,13107,13108,13112,13111,-1,13111,13112,13113,13059,-1,12984,13115,13114,13032,-1,13032,13114,13116,-1,13120,13119,13118,13117,-1,13032,13116,13121,-1,13123,13122,13121,-1,13121,10896,13033,13032,-1,13126,13125,13124,13085,-1,13087,13088,13090,-1,13128,13127,13105,13106,-1,13131,13130,13129,13052,-1,13046,13047,13070,13071,-1,13019,13133,13132,13021,-1,13023,13021,13132,13134,-1,13136,13023,13135,-1,13023,13136,13137,13025,-1,13025,13137,13138,12972,-1,13139,13061,13062,-1,13038,13039,13064,13065,-1,12982,12980,12983,-1,12985};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_67()
		{
			int[] value = {13115,12984,-1,13130,13131,13141,13140,-1,5118,13073,13142,-1,13078,5119,5120,13077,-1,13099,13100,5122,5121,-1,13144,13143,5128,5127,-1,13144,12988,12989,13143,-1,5096,5144,13145,13008,-1,13147,13146,5137,5138,-1,13008,13145,13146,13010,-1,5148,13149,13148,5147,-1,5135,5136,13148,13150,-1,12997,12994,13152,13151,-1,13154,13153,12994,12995,-1,13154,13014,13012,13153,-1,13000,12998,12995,12996,-1,13014,13154,12998,12999,-1,12999,13000,13155,13018,-1,13157,13156,12996,12997,-1,13018,13155,13133,13019,-1,13159,13158,13156,13157,-1,13072,13069,13158,13159,-1,5067,13161,13160,5066,-1,13050,13051,5150,5149,-1,13162,12979,12977,-1,12978,12979,12981,12982,-1,13165,13164,11097,13163,-1,13166,10894,11100,13090,-1,13090,11100,11101,13167,-1,13167,11101,10895,13168,-1,13168,10895,13169,13122,-1,13171,13170,13003,13001,-1,13002,13003,13173,13172,-1,13172,13173,10897,13004,-1,13165,13005,13006,13164,-1,13170,13171,5113,4153,-1,13175,13174,12980,-1,13177,13176,13174,13175,-1,13179,13178,13162,12977,-1,13162,13180,12981,12979,-1,5149,5165,13181,13050,-1,5067,5171,13182,13161,-1,13182,5171,5150,13051,-1,13161,13182,12975,-1,13184,13160,13161,13183,-1,13185,5066,13160,-1,13149,5148,5066,13185,-1,13186,13157,12997,13151,-1,13187,13159,13157,13186,-1,13187,13184,13072,13159,-1,13158,13069,13133,13155,-1,13156,13158,13155,-1,13000,12996,13156,13155,-1,13154,12995,12998,-1,13189,13188,13010,13147,-1,13152,12994,13153,13188,-1,13189,5172,5135,13150,-1,13148,5136,5147,-1,13145,5173,5137,13146,-1,5144,5173,13145,-1,13189,13147,5138,5172,-1,13140,13141,5131,5132,-1,13191,13190,5179,5177,-1,13191,5177,5175,13192,-1,13191,13127,13128,13190,-1,13140,5132,5179,13190,-1,13193,5180,5131,13141,-1,5180,13193,13181,5165,-1,13143,13194,5185,5128,-1,5069,5186,13195,12970,-1,13077,5120,5122,13100,-1,13078,13196,5191,5119,-1,5194,5192,13198,13197,-1,13142,13199,5118,-1,13073,5118,5195,13076,-1,5196,13075,13076,-1,5196,13076,5195,5197,-1,13128,13130,13140,13190,-1,13131,13200,13193,13141,-1,13200,13201,13181,13193,-1,13182,12960,13043,12975,-1,13182,13051,12962,12960,-1,13131,13052,13200,-1,13052,13053,13201,13200,-1,13052,13129,13202,12967,-1,13129,13106,13103,13202,-1,13110,13066,13202,13103,-1,12967,13202,13066,12969,-1,13110,13107,13068,13066,-1,13203,13068,13107,13111,-1,13059,13113,13115,12985,-1,13067,13177,13205,13204,-1,13179,13207,13206,13178,-1,13038,13065,13207,13034,-1,13041,12961,13064,13039,-1,13137,13061,13208,13138,-1,13048,13061,13137,13136,-1,13135,13023,13134,-1,13047,13134,13132,13070,-1,12960,12961,13041,13043,-1,13128,13106,13129,13130,-1,13034,13207,13179,13036,-1,13058,12970,13209,13057,-1,13192,13058,13055,13210,-1,13192,13210,13211,13191,-1,13211,13212,13105,13127,-1,13216,13215,13214,13213,-1,13214,13218,13217,13213,-1,13117,13118,13056,-1,13057,13209,13117,13056,-1,13056,13219,13210,13055,-1,13055,13058,13057,-1,13211,13127,13191,-1,13090,13221,13220,13087,-1,13167,13221,13090,-1,13085,13086,13222,13126,-1,13144,13223,12988,-1,12989,13124,13194,13143,-1,13224,13195,13194,13125,-1,13222,13086,13220,13225,-1,13225,13220,13221,13226,-1,13226,13221,13167,13227,-1,13228,13227,13167,13168,-1,13123,13228,13168,13122,-1,13122,13169,10896,13121,-1,13116,13229,13123,13121,-1,13229,13230,13228,13123,-1,13230,13231,13227,13228,-1,13227,13231,13232,13226,-1,13226,13232,13233,13225,-1,13233,13119,13222,13225,-1,13120,13126,13222,13119,-1,13224,13125,13126,13120,-1,13233,13215,13118,13119,-1,13232,13214,13215,13233,-1,13231,13218,13214,13232,-1,13218,13234,13217,-1,13230,13234,13218,13231,-1,13229,13235,13234,13230,-1,13116,13114,13235,13229,-1,13112,13108,13217,13234,-1,13235,13113,13112,13234,-1,13109,13213,13217,13108,-1,13109,13104,13216,13213,-1,13105,13212,13216,13104,-1,13101,13172,13004,12993,-1,13074,13002,13172,13101,-1,13236,12992,13005,13165,-1,13095,13236,13165,13163,-1,13237,13236,13095,13096,-1,12991,13237,13238,13079,-1,12990,13080,13097,-1,13077,13100,13097,13080,-1,13198,13240,13239,-1,13241,13197,13198,13239,-1,13223,13144,13197,13241,-1,13084,13223,13241,13091,-1,13095,13163,13093,-1,13093,13163,13242,13092,-1,13242,13163,13166,-1,13166,13090,13089,13242,-1,13092,13242,13089,13083,-1,13088,13082,13083,13089,-1,13220,13086,13081,13087,-1,13085,13124,12989,12986,-1,12987,12988,13223,13084,-1,13238,13237,13096,13240,-1,13240,13096,13094,13239,-1,13239,13094,13091,13241,-1,13238,13196,13078,13079,-1,13075,13001,13002,13074,-1,13142,13101,13102,13199,-1,13070,13132,13133,13069,-1,12968,12969,13067,13204,-1,13204,13206,13063,12968,-1,13065,13063,13206,13207,-1,13206,13204,13205,13178,-1,12983,12980,13174,13060,-1,13176,13203,13060,13174,-1,13176,13067,13068,13203,-1,13176,13177,13067,-1,13180,13205,13177,13175,-1,12980,12981,13180,13175,-1,13180,13162,13178,13205,-1,13113,13235,13114,13115,-1,13058,13192,5175,5103,-1,13219,13118,13212,13211,-1,13117,13209,13224,13120,-1,13163,11097,10894,13166,-1,12961,13053,13054,13064,-1,13050,13181,13201,13049,-1,13049,13201,13053,12961,-1,12973,13036,13179,12977,-1,13195,5186,5185,13194,-1,13209,12970,13195,13224,-1,13215,13216,13212,13118,-1,13071,13072,13184,13183,-1,13046,12975,13044,-1,12975,13046,13071,13183,-1,13042,13062,12976,12974,-1,13040,13139,13062,13042,-1,13035,13138,13208,13037,-1,12971,13138,13035,-1,12971,12972,13138,-1,13197,13144,5127,5194,-1,13199,13102,13098,13099};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_68()
		{
			int[] value = {-1,13099,5121,5118,13199,-1,13198,5192,5191,13196,-1,13240,13198,13196,13238,-1,13171,13001,13075,5196,-1,5196,5113,13171,-1,12971,13036,12973,-1,13203,13111,13059,13060,-1,13074,13101,13142,13073,-1,13237,12991,12992,13236,-1,12993,12990,13097,13098,-1,13098,13102,12993,-1,13161,12975,13183,-1,13010,13146,13147,-1,13188,13153,13012,13010,-1,13135,13045,13048,13136,-1,13134,13047,13045,13135,-1,13139,13208,13061,-1,13040,13037,13208,13139,-1,13187,13185,13160,13184,-1,13186,13149,13185,13187,-1,13151,13148,13149,13186,-1,13152,13150,13148,13151,-1,13188,13189,13150,13152,-1,13219,13056,13118,-1,13194,13124,13125,-1,13211,13210,13219,-1,13246,13245,13244,13243,-1,13250,13249,13248,13247,-1,13254,13253,13252,13251,-1,13258,13257,13256,13255,-1,13262,13261,13260,13259,-1,13259,13260,13264,13263,-1,13263,13264,13266,13265,-1,13265,13266,13268,13267,-1,13267,13268,13270,13269,-1,13269,13270,13272,13271,-1,13271,13272,13274,13273,-1,13273,13274,13276,13275,-1,13275,13276,13278,13277,-1,13277,13278,13280,13279,-1,13279,13280,13282,13281,-1,13281,13282,13284,13283,-1,13283,13284,13286,13285,-1,13285,13286,13288,13287,-1,13287,13288,13290,13289,-1,13289,13290,13292,13291,-1,13291,13292,13294,13293,-1,13293,13294,13296,13295,-1,13295,13296,13298,13297,-1,13297,13298,13300,13299,-1,13299,13300,13302,13301,-1,13301,13302,13261,13262,-1,13261,13304,13303,13260,-1,13260,13303,13305,13264,-1,13264,13305,13306,13266,-1,13266,13306,13307,13268,-1,13268,13307,13308,13270,-1,13270,13308,13243,13272,-1,13272,13243,13244,13274,-1,13274,13244,13309,13276,-1,13276,13309,13310,13278,-1,13278,13310,13311,13280,-1,13280,13311,13312,13282,-1,13282,13312,13313,13284,-1,13284,13313,13314,13286,-1,13286,13314,13315,13288,-1,13288,13315,13316,13290,-1,13290,13316,13245,13292,-1,13292,13245,13246,13294,-1,13294,13246,13317,13296,-1,13296,13317,13318,13298,-1,13298,13318,13319,13300,-1,13300,13319,13320,13302,-1,13302,13320,13304,13261,-1,13314,13313,13312,13311,-1,13316,13315,13310,13309,-1,13311,13310,13315,13314,-1,13245,13316,13309,13244,-1,13308,13307,13318,13317,-1,13317,13246,13243,13308,-1,13306,13305,13320,13319,-1,13319,13318,13307,13306,-1,13305,13303,13304,13320,-1,13255,13256,13322,13321,-1,13251,13252,13321,13322,-1,13247,13248,13324,13323,-1,13257,13258,13323,13324,-1,13328,13327,13326,13325,-1,13249,13250,13325,13326,-1,13330,13329,13327,13328,-1,13259,13329,13330,13262,-1,13262,13330,13328,13301,-1,13301,13328,13325,13299,-1,13299,13325,13250,13297,-1,13297,13250,13247,13295,-1,13295,13247,13323,13293,-1,13293,13323,13258,13291,-1,13291,13258,13255,13289,-1,13289,13255,13321,13287,-1,13287,13321,13252,13285,-1,13285,13252,13253,13283,-1,13283,13253,13254,13281,-1,13281,13254,13251,13279,-1,13279,13251,13322,13277,-1,13277,13322,13256,13275,-1,13275,13256,13257,13273,-1,13273,13257,13324,13271,-1,13271,13324,13248,13269,-1,13269,13248,13249,13267,-1,13267,13249,13326,13265,-1,13265,13326,13327,13263,-1,13263,13327,13329,13259,-1,13334,13333,13332,13331,-1,13336,13335,13333,13334,-1,13338,13337,13335,13336,-1,13340,13339,13337,13338,-1,13342,13341,13339,13340,-1,13346,13345,13344,13343,-1,13333,13348,13347,13332,-1,13335,13349,13348,13333,-1,13337,13350,13349,13335,-1,13339,13351,13350,13337,-1,13341,13352,13351,13339,-1,13345,13354,13353,13344,-1,13348,13356,13355,13347,-1,13349,13357,13356,13348,-1,13350,13358,13357,13349,-1,13351,13359,13358,13350,-1,13352,13360,13359,13351,-1,13354,13362,13361,13353,-1,13356,13364,13363,13355,-1,13357,13365,13364,13356,-1,13358,13366,13365,13357,-1,13359,13367,13366,13358,-1,13360,13368,13367,13359,-1,13362,13370,13369,13361,-1,13364,13372,13371,13363,-1,13365,13373,13372,13364,-1,13366,13374,13373,13365,-1,13367,13375,13374,13366,-1,13368,13376,13375,13367,-1,13370,13378,13377,13369,-1,13372,13380,13379,13371,-1,13373,13381,13380,13372,-1,13374,13382,13381,13373,-1,13375,13383,13382,13374,-1,13376,13384,13383,13375,-1,13378,13386,13385,13377,-1,13380,13388,13387,13379,-1,13381,13389,13388,13380,-1,13382,13390,13389,13381,-1,13383,13391,13390,13382,-1,13384,13392,13391,13383,-1,13386,13394,13393,13385,-1,13388,13396,13395,13387,-1,13389,13397,13396,13388,-1,13390,13398,13397,13389,-1,13391,13399,13398,13390,-1,13392,13400,13399,13391,-1,13394,13402,13401,13393,-1,13396,13404,13403,13395,-1,13397,13405,13404,13396,-1,13398,13406,13405,13397,-1,13399,13407,13406,13398,-1,13400,13408,13407,13399,-1,13402,13410,13409,13401,-1,13414,13413,13412,13411,-1,13404,13405,13406,13407,-1,13403,13416,13415,13395,-1,13395,13415,13417,13387,-1,13387,13417,13418,13379,-1,13379,13418,13419,13371,-1,13371,13419,13420,13363,-1,13363,13420,13421,13355,-1,13355,13421,13422,13347,-1,13347,13422,13423,13332,-1,13332,13423,13424,13331,-1,13414,13426,13425,13413,-1,13430,13429,13428,13427,-1,13427,13428,13432,13431,-1,13431,13432,13434,13433,-1,13433,13434,13436,13435,-1,13435,13436,13438,13437,-1,13437,13438,13440,13439,-1,13439,13440,13442,13441,-1,13441,13442,13444,13443,-1,13443,13444,13445,13408,-1,13408,13445,13416,13403,-1,13416,13447,13446,13415,-1,13415,13446,13448,13417,-1,13417,13448,13449,13418,-1,13418,13449,13450,13419,-1,13419,13450,13451,13420,-1,13420,13451,13452,13421,-1,13421,13452,13453,13422,-1,13422,13453,13454,13423,-1,13423,13454,13455,13424,-1,13426,13457,13456,13425,-1,13429,13459,13458,13428,-1,13428,13458,13460,13432,-1,13432,13460,13461,13434,-1,13434,13461,13462};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_69()
		{
			int[] value = {13436,-1,13436,13462,13463,13438,-1,13438,13463,13464,13440,-1,13440,13464,13465,13442,-1,13442,13465,13466,13444,-1,13444,13466,13467,13445,-1,13445,13467,13447,13416,-1,13454,13469,13468,13455,-1,13457,13471,13470,13456,-1,13459,13473,13472,13458,-1,13458,13472,13474,13460,-1,13460,13474,13475,13461,-1,13461,13475,13476,13462,-1,13462,13476,13477,13463,-1,13463,13477,13478,13464,-1,13464,13478,13479,13465,-1,13465,13479,13480,13466,-1,13466,13480,13481,13467,-1,13467,13481,13482,13447,-1,13447,13482,13483,13446,-1,13446,13483,13484,13448,-1,13448,13484,13485,13449,-1,13449,13485,13486,13450,-1,13450,13486,13487,13451,-1,13451,13487,13488,13452,-1,13452,13488,13489,13453,-1,13453,13489,13469,13454,-1,13469,13345,13346,13468,-1,13471,13491,13490,13470,-1,13473,13343,13344,13472,-1,13472,13344,13353,13474,-1,13474,13353,13361,13475,-1,13475,13361,13369,13476,-1,13476,13369,13377,13477,-1,13477,13377,13385,13478,-1,13478,13385,13393,13479,-1,13479,13393,13401,13480,-1,13480,13401,13409,13481,-1,13481,13409,13410,13482,-1,13482,13410,13402,13483,-1,13483,13402,13394,13484,-1,13484,13394,13386,13485,-1,13485,13386,13378,13486,-1,13486,13378,13370,13487,-1,13487,13370,13362,13488,-1,13488,13362,13354,13489,-1,13489,13354,13345,13469,-1,13407,13408,13403,13404,-1,13412,13493,13492,13411,-1,13338,13493,13412,13340,-1,13340,13412,13413,13342,-1,13430,13413,13425,13429,-1,13429,13425,13456,13459,-1,13459,13456,13470,13473,-1,13473,13470,13490,13343,-1,13343,13490,13491,13346,-1,13346,13491,13471,13468,-1,13468,13471,13457,13455,-1,13455,13457,13426,13424,-1,13424,13426,13414,13331,-1,13331,13414,13411,13334,-1,13334,13411,13492,13336,-1,13336,13492,13493,13338,-1,13360,13352,13495,13494,-1,13494,13495,13431,13433,-1,13352,13341,13496,13495,-1,13495,13496,13427,13431,-1,13341,13342,13497,13496,-1,13496,13497,13430,13427,-1,13368,13360,13494,13498,-1,13498,13494,13433,13435,-1,13376,13368,13498,13499,-1,13499,13498,13435,13437,-1,13384,13376,13499,13500,-1,13500,13499,13437,13439,-1,13392,13384,13500,13501,-1,13501,13500,13439,13441,-1,13400,13392,13501,13502,-1,13502,13501,13441,13443,-1,13342,13413,13497,-1,13413,13430,13497,-1,13408,13400,13502,-1,13502,13443,13408,-1,13506,13505,13504,13503,-1,13507,13503,13504,-1,13505,13506,13508,-1,13508,13506,13510,13509,-1,13509,13510,13512,13511,-1,13511,13512,13514,13513,-1,13513,13514,13516,13515,-1,13515,13516,13518,13517,-1,13517,13518,13520,13519,-1,13519,13520,13522,13521,-1,13521,13522,13524,13523,-1,13523,13524,13526,13525,-1,13530,13529,13528,13527,-1,13534,13533,13532,13531,-1,13531,13532,13536,13535,-1,13535,13536,13538,13537,-1,13537,13538,13540,13539,-1,13539,13540,13542,13541,-1,13541,13542,13544,13543,-1,13543,13544,13546,13545,-1,13545,13546,13548,13547,-1,13547,13548,13503,13507,-1,13503,13548,13510,13506,-1,13546,13544,13514,13512,-1,13544,13542,13516,13514,-1,13532,13533,13526,13524,-1,13524,13522,13536,13532,-1,13522,13520,13538,13536,-1,13542,13540,13518,13516,-1,13540,13538,13520,13518,-1,13548,13546,13512,13510,-1,13534,13527,13528,13533,-1,13533,13528,13529,13526,-1,13526,13529,13530,13525,-1,13552,13551,13550,13549,-1,13551,13554,13553,13550,-1,13554,13556,13555,13553,-1,13556,13558,13557,13555,-1,13558,13560,13559,13557,-1,13560,13562,13561,13559,-1,13562,13564,13563,13561,-1,13564,13566,13565,13563,-1,13566,13568,13567,13565,-1,13549,13570,13569,13552,-1,13525,13572,13571,13523,-1,13523,13571,13573,13521,-1,13521,13573,13574,13519,-1,13519,13574,13575,13517,-1,13517,13575,13576,13515,-1,13515,13576,13577,13513,-1,13513,13577,13578,13511,-1,13511,13578,13579,13509,-1,13509,13579,13580,13508,-1,13508,13580,13581,13505,-1,13505,13581,13582,13504,-1,13504,13582,13583,13507,-1,13507,13583,13584,13547,-1,13547,13584,13585,13545,-1,13545,13585,13586,13543,-1,13543,13586,13587,13541,-1,13541,13587,13588,13539,-1,13539,13588,13589,13537,-1,13537,13589,13590,13535,-1,13535,13590,13591,13531,-1,13531,13591,13592,13534,-1,13527,13594,13593,13530,-1,13572,13568,13566,13571,-1,13571,13566,13564,13573,-1,13573,13564,13562,13574,-1,13574,13562,13560,13575,-1,13575,13560,13558,13576,-1,13576,13558,13556,13577,-1,13577,13556,13554,13578,-1,13578,13554,13551,13579,-1,13579,13551,13552,13580,-1,13580,13552,13569,13581,-1,13581,13569,13570,13582,-1,13582,13570,13549,13583,-1,13583,13549,13550,13584,-1,13584,13550,13553,13585,-1,13585,13553,13555,13586,-1,13586,13555,13557,13587,-1,13587,13557,13559,13588,-1,13588,13559,13561,13589,-1,13589,13561,13563,13590,-1,13590,13563,13565,13591,-1,13591,13565,13567,13592,-1,13594,13596,13595,13593,-1,13567,13596,13594,13592,-1,13592,13594,13527,13534,-1,13525,13530,13593,13572,-1,13572,13593,13595,13568,-1,13568,13595,13596,13567,-1,13600,13599,13598,13597,-1,13599,13600,13601,-1,13602,13597,13598,-1,13604,13603,13597,13602,-1,13606,13605,13603,13604,-1,13608,13607,13605,13606,-1,13610,13609,13607,13608,-1,13612,13611,13609,13610,-1,13614,13613,13611,13612,-1,13616,13615,13613,13614,-1,13618,13617,13615,13616,-1,13620,13619,13617,13618,-1,13624,13623,13622,13621,-1,13628,13627,13626,13625,-1,13630,13629,13627,13628,-1,13632,13631,13629,13630,-1,13634,13633,13631,13632,-1,13636,13635,13633,13634,-1,13638,13637,13635,13636,-1,13640,13639,13637,13638,-1,13642,13641,13639,13640,-1,13601,13600,13641,13642,-1,13597,13603,13641,13600,-1,13605,13607,13637,13639,-1,13607,13609,13635,13637,-1,13617,13619,13626,13627,-1,13627};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_70()
		{
			int[] value = {13629,13615,13617,-1,13629,13631,13613,13615,-1,13609,13611,13633,13635,-1,13611,13613,13631,13633,-1,13603,13605,13639,13641,-1,13626,13623,13624,13625,-1,13619,13622,13623,13626,-1,13620,13621,13622,13619,-1,13646,13645,13644,13643,-1,13645,13648,13647,13644,-1,13648,13650,13649,13647,-1,13650,13652,13651,13649,-1,13652,13654,13653,13651,-1,13654,13656,13655,13653,-1,13656,13658,13657,13655,-1,13658,13660,13659,13657,-1,13660,13662,13661,13659,-1,13643,13664,13663,13646,-1,13618,13666,13665,13620,-1,13616,13667,13666,13618,-1,13614,13668,13667,13616,-1,13612,13669,13668,13614,-1,13610,13670,13669,13612,-1,13608,13671,13670,13610,-1,13606,13672,13671,13608,-1,13604,13673,13672,13606,-1,13602,13674,13673,13604,-1,13598,13675,13674,13602,-1,13599,13676,13675,13598,-1,13601,13677,13676,13599,-1,13642,13678,13677,13601,-1,13640,13679,13678,13642,-1,13638,13680,13679,13640,-1,13636,13681,13680,13638,-1,13634,13682,13681,13636,-1,13632,13683,13682,13634,-1,13630,13684,13683,13632,-1,13628,13685,13684,13630,-1,13625,13686,13685,13628,-1,13621,13688,13687,13624,-1,13666,13659,13661,13665,-1,13667,13657,13659,13666,-1,13668,13655,13657,13667,-1,13669,13653,13655,13668,-1,13670,13651,13653,13669,-1,13671,13649,13651,13670,-1,13672,13647,13649,13671,-1,13673,13644,13647,13672,-1,13674,13643,13644,13673,-1,13675,13664,13643,13674,-1,13676,13663,13664,13675,-1,13677,13646,13663,13676,-1,13678,13645,13646,13677,-1,13679,13648,13645,13678,-1,13680,13650,13648,13679,-1,13681,13652,13650,13680,-1,13682,13654,13652,13681,-1,13683,13656,13654,13682,-1,13684,13658,13656,13683,-1,13685,13660,13658,13684,-1,13686,13662,13660,13685,-1,13688,13690,13689,13687,-1,13686,13687,13689,13662,-1,13625,13624,13687,13686,-1,13665,13688,13621,13620,-1,13661,13690,13688,13665,-1,13662,13689,13690,13661,-1,13694,13693,13692,13691,-1,13693,13694,13695,-1,13696,13691,13692,-1,13698,13697,13691,13696,-1,13700,13699,13697,13698,-1,13702,13701,13699,13700,-1,13704,13703,13701,13702,-1,13706,13705,13703,13704,-1,13708,13707,13705,13706,-1,13710,13709,13707,13708,-1,13712,13711,13709,13710,-1,13714,13713,13711,13712,-1,13718,13717,13716,13715,-1,13722,13721,13720,13719,-1,13724,13723,13721,13722,-1,13726,13725,13723,13724,-1,13728,13727,13725,13726,-1,13730,13729,13727,13728,-1,13732,13731,13729,13730,-1,13734,13733,13731,13732,-1,13736,13735,13733,13734,-1,13695,13694,13735,13736,-1,13691,13697,13735,13694,-1,13699,13701,13731,13733,-1,13701,13703,13729,13731,-1,13711,13713,13720,13721,-1,13721,13723,13709,13711,-1,13723,13725,13707,13709,-1,13703,13705,13727,13729,-1,13705,13707,13725,13727,-1,13697,13699,13733,13735,-1,13720,13717,13718,13719,-1,13713,13716,13717,13720,-1,13714,13715,13716,13713,-1,13740,13739,13738,13737,-1,13739,13742,13741,13738,-1,13742,13744,13743,13741,-1,13744,13746,13745,13743,-1,13746,13748,13747,13745,-1,13748,13750,13749,13747,-1,13750,13752,13751,13749,-1,13752,13754,13753,13751,-1,13754,13756,13755,13753,-1,13737,13758,13757,13740,-1,13712,13760,13759,13714,-1,13710,13761,13760,13712,-1,13708,13762,13761,13710,-1,13706,13763,13762,13708,-1,13704,13764,13763,13706,-1,13702,13765,13764,13704,-1,13700,13766,13765,13702,-1,13698,13767,13766,13700,-1,13696,13768,13767,13698,-1,13692,13769,13768,13696,-1,13693,13770,13769,13692,-1,13695,13771,13770,13693,-1,13736,13772,13771,13695,-1,13734,13773,13772,13736,-1,13732,13774,13773,13734,-1,13730,13775,13774,13732,-1,13728,13776,13775,13730,-1,13726,13777,13776,13728,-1,13724,13778,13777,13726,-1,13722,13779,13778,13724,-1,13719,13780,13779,13722,-1,13715,13782,13781,13718,-1,13760,13753,13755,13759,-1,13761,13751,13753,13760,-1,13762,13749,13751,13761,-1,13763,13747,13749,13762,-1,13764,13745,13747,13763,-1,13765,13743,13745,13764,-1,13766,13741,13743,13765,-1,13767,13738,13741,13766,-1,13768,13737,13738,13767,-1,13769,13758,13737,13768,-1,13770,13757,13758,13769,-1,13771,13740,13757,13770,-1,13772,13739,13740,13771,-1,13773,13742,13739,13772,-1,13774,13744,13742,13773,-1,13775,13746,13744,13774,-1,13776,13748,13746,13775,-1,13777,13750,13748,13776,-1,13778,13752,13750,13777,-1,13779,13754,13752,13778,-1,13780,13756,13754,13779,-1,13782,13784,13783,13781,-1,13780,13781,13783,13756,-1,13719,13718,13781,13780,-1,13759,13782,13715,13714,-1,13755,13784,13782,13759,-1,13756,13783,13784,13755,-1,13788,13787,13786,13785,-1,13792,13791,13790,13789,-1,13796,13795,13794,13793,-1,13800,13799,13798,13797,-1,13804,13803,13802,13801,-1,13806,13805,13803,13804,-1,13808,13807,13805,13806,-1,13810,13809,13807,13808,-1,13812,13811,13809,13810,-1,13814,13813,13811,13812,-1,13816,13815,13813,13814,-1,13818,13817,13815,13816,-1,13820,13819,13817,13818,-1,13822,13821,13819,13820,-1,13824,13823,13821,13822,-1,13826,13825,13823,13824,-1,13828,13827,13825,13826,-1,13830,13829,13827,13828,-1,13832,13831,13829,13830,-1,13834,13833,13831,13832,-1,13836,13835,13833,13834,-1,13838,13837,13835,13836,-1,13840,13839,13837,13838,-1,13842,13841,13839,13840,-1,13844,13843,13841,13842,-1,13801,13802,13843,13844,-1,13803,13846,13845,13802,-1,13805,13847,13846,13803,-1,13807,13848,13847,13805,-1,13809,13849,13848,13807,-1,13811,13850,13849,13809,-1,13813,13788,13850,13811,-1,13815,13787,13788,13813,-1,13817,13851,13787,13815,-1,13819,13852,13851,13817,-1,13821,13853,13852,13819,-1,13823,13854,13853,13821,-1,13825,13855,13854,13823,-1,13827,13856,13855,13825,-1,13829,13857,13856,13827,-1,13831,13858,13857};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_71()
		{
			int[] value = {13829,-1,13833,13786,13858,13831,-1,13835,13785,13786,13833,-1,13837,13859,13785,13835,-1,13839,13860,13859,13837,-1,13841,13861,13860,13839,-1,13843,13862,13861,13841,-1,13802,13845,13862,13843,-1,13853,13854,13855,13856,-1,13851,13852,13857,13858,-1,13856,13857,13852,13853,-1,13787,13851,13858,13786,-1,13859,13860,13849,13850,-1,13850,13788,13785,13859,-1,13861,13862,13847,13848,-1,13848,13849,13860,13861,-1,13862,13845,13846,13847,-1,13864,13863,13799,13800,-1,13863,13864,13795,13796,-1,13866,13865,13791,13792,-1,13865,13866,13797,13798,-1,13870,13869,13868,13867,-1,13869,13870,13789,13790,-1,13867,13868,13872,13871,-1,13801,13871,13872,13804,-1,13844,13867,13871,13801,-1,13842,13870,13867,13844,-1,13840,13789,13870,13842,-1,13838,13792,13789,13840,-1,13836,13866,13792,13838,-1,13834,13797,13866,13836,-1,13832,13800,13797,13834,-1,13830,13864,13800,13832,-1,13828,13795,13864,13830,-1,13826,13794,13795,13828,-1,13824,13793,13794,13826,-1,13822,13796,13793,13824,-1,13820,13863,13796,13822,-1,13818,13799,13863,13820,-1,13816,13798,13799,13818,-1,13814,13865,13798,13816,-1,13812,13791,13865,13814,-1,13810,13790,13791,13812,-1,13808,13869,13790,13810,-1,13806,13868,13869,13808,-1,13804,13872,13868,13806,-1,13876,13875,13874,13873,-1,13880,13879,13878,13877,-1,13884,13883,13882,13881,-1,13888,13887,13886,13885,-1,13892,13891,13890,13889,-1,13889,13890,13894,13893,-1,13893,13894,13896,13895,-1,13895,13896,13898,13897,-1,13897,13898,13900,13899,-1,13899,13900,13902,13901,-1,13901,13902,13904,13903,-1,13903,13904,13906,13905,-1,13905,13906,13908,13907,-1,13907,13908,13910,13909,-1,13909,13910,13912,13911,-1,13911,13912,13914,13913,-1,13913,13914,13916,13915,-1,13915,13916,13918,13917,-1,13917,13918,13920,13919,-1,13919,13920,13922,13921,-1,13921,13922,13924,13923,-1,13923,13924,13926,13925,-1,13925,13926,13928,13927,-1,13927,13928,13930,13929,-1,13929,13930,13932,13931,-1,13931,13932,13891,13892,-1,13891,13934,13933,13890,-1,13890,13933,13935,13894,-1,13894,13935,13936,13896,-1,13896,13936,13937,13898,-1,13898,13937,13938,13900,-1,13900,13938,13873,13902,-1,13902,13873,13874,13904,-1,13904,13874,13939,13906,-1,13906,13939,13940,13908,-1,13908,13940,13941,13910,-1,13910,13941,13942,13912,-1,13912,13942,13943,13914,-1,13914,13943,13944,13916,-1,13916,13944,13945,13918,-1,13918,13945,13946,13920,-1,13920,13946,13875,13922,-1,13922,13875,13876,13924,-1,13924,13876,13947,13926,-1,13926,13947,13948,13928,-1,13928,13948,13949,13930,-1,13930,13949,13950,13932,-1,13932,13950,13934,13891,-1,13944,13943,13942,13941,-1,13946,13945,13940,13939,-1,13941,13940,13945,13944,-1,13875,13946,13939,13874,-1,13938,13937,13948,13947,-1,13947,13876,13873,13938,-1,13936,13935,13950,13949,-1,13949,13948,13937,13936,-1,13935,13933,13934,13950,-1,13885,13886,13952,13951,-1,13881,13882,13951,13952,-1,13877,13878,13954,13953,-1,13887,13888,13953,13954,-1,13958,13957,13956,13955,-1,13879,13880,13955,13956,-1,13960,13959,13957,13958,-1,13889,13959,13960,13892,-1,13892,13960,13958,13931,-1,13931,13958,13955,13929,-1,13929,13955,13880,13927,-1,13927,13880,13877,13925,-1,13925,13877,13953,13923,-1,13923,13953,13888,13921,-1,13921,13888,13885,13919,-1,13919,13885,13951,13917,-1,13917,13951,13882,13915,-1,13915,13882,13883,13913,-1,13913,13883,13884,13911,-1,13911,13884,13881,13909,-1,13909,13881,13952,13907,-1,13907,13952,13886,13905,-1,13905,13886,13887,13903,-1,13903,13887,13954,13901,-1,13901,13954,13878,13899,-1,13899,13878,13879,13897,-1,13897,13879,13956,13895,-1,13895,13956,13957,13893,-1,13893,13957,13959,13889,-1,13964,13963,13962,13961,-1,13966,13965,13963,13964,-1,13968,13967,13965,13966,-1,13970,13969,13967,13968,-1,13972,13971,13969,13970,-1,13976,13975,13974,13973,-1,13963,13978,13977,13962,-1,13965,13979,13978,13963,-1,13967,13980,13979,13965,-1,13969,13981,13980,13967,-1,13971,13982,13981,13969,-1,13975,13984,13983,13974,-1,13978,13986,13985,13977,-1,13979,13987,13986,13978,-1,13980,13988,13987,13979,-1,13981,13989,13988,13980,-1,13982,13990,13989,13981,-1,13984,13992,13991,13983,-1,13986,13994,13993,13985,-1,13987,13995,13994,13986,-1,13988,13996,13995,13987,-1,13989,13997,13996,13988,-1,13990,13998,13997,13989,-1,13992,14000,13999,13991,-1,13994,14002,14001,13993,-1,13995,14003,14002,13994,-1,13996,14004,14003,13995,-1,13997,14005,14004,13996,-1,13998,14006,14005,13997,-1,14000,14008,14007,13999,-1,14002,14010,14009,14001,-1,14003,14011,14010,14002,-1,14004,14012,14011,14003,-1,14005,14013,14012,14004,-1,14006,14014,14013,14005,-1,14008,14016,14015,14007,-1,14010,14018,14017,14009,-1,14011,14019,14018,14010,-1,14012,14020,14019,14011,-1,14013,14021,14020,14012,-1,14014,14022,14021,14013,-1,14016,14024,14023,14015,-1,14018,14026,14025,14017,-1,14019,14027,14026,14018,-1,14020,14028,14027,14019,-1,14021,14029,14028,14020,-1,14022,14030,14029,14021,-1,14024,14032,14031,14023,-1,14026,14034,14033,14025,-1,14027,14035,14034,14026,-1,14028,14036,14035,14027,-1,14029,14037,14036,14028,-1,14030,14038,14037,14029,-1,14032,14040,14039,14031,-1,14044,14043,14042,14041,-1,14034,14035,14036,14037,-1,14033,14046,14045,14025,-1,14025,14045,14047,14017,-1,14017,14047,14048,14009,-1,14009,14048,14049,14001,-1,14001,14049,14050,13993,-1,13993,14050,14051,13985,-1,13985,14051,14052,13977,-1,13977,14052,14053,13962,-1,13962,14053,14054,13961,-1,14044,14056,14055,14043,-1,14060,14059,14058,14057,-1,14057,14058,14062,14061,-1,14061,14062,14064};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_72()
		{
			int[] value = {14063,-1,14063,14064,14066,14065,-1,14065,14066,14068,14067,-1,14067,14068,14070,14069,-1,14069,14070,14072,14071,-1,14071,14072,14074,14073,-1,14073,14074,14075,14038,-1,14038,14075,14046,14033,-1,14046,14077,14076,14045,-1,14045,14076,14078,14047,-1,14047,14078,14079,14048,-1,14048,14079,14080,14049,-1,14049,14080,14081,14050,-1,14050,14081,14082,14051,-1,14051,14082,14083,14052,-1,14052,14083,14084,14053,-1,14053,14084,14085,14054,-1,14056,14087,14086,14055,-1,14059,14089,14088,14058,-1,14058,14088,14090,14062,-1,14062,14090,14091,14064,-1,14064,14091,14092,14066,-1,14066,14092,14093,14068,-1,14068,14093,14094,14070,-1,14070,14094,14095,14072,-1,14072,14095,14096,14074,-1,14074,14096,14097,14075,-1,14075,14097,14077,14046,-1,14084,14099,14098,14085,-1,14087,14101,14100,14086,-1,14089,14103,14102,14088,-1,14088,14102,14104,14090,-1,14090,14104,14105,14091,-1,14091,14105,14106,14092,-1,14092,14106,14107,14093,-1,14093,14107,14108,14094,-1,14094,14108,14109,14095,-1,14095,14109,14110,14096,-1,14096,14110,14111,14097,-1,14097,14111,14112,14077,-1,14077,14112,14113,14076,-1,14076,14113,14114,14078,-1,14078,14114,14115,14079,-1,14079,14115,14116,14080,-1,14080,14116,14117,14081,-1,14081,14117,14118,14082,-1,14082,14118,14119,14083,-1,14083,14119,14099,14084,-1,14099,13975,13976,14098,-1,14101,14121,14120,14100,-1,14103,13973,13974,14102,-1,14102,13974,13983,14104,-1,14104,13983,13991,14105,-1,14105,13991,13999,14106,-1,14106,13999,14007,14107,-1,14107,14007,14015,14108,-1,14108,14015,14023,14109,-1,14109,14023,14031,14110,-1,14110,14031,14039,14111,-1,14111,14039,14040,14112,-1,14112,14040,14032,14113,-1,14113,14032,14024,14114,-1,14114,14024,14016,14115,-1,14115,14016,14008,14116,-1,14116,14008,14000,14117,-1,14117,14000,13992,14118,-1,14118,13992,13984,14119,-1,14119,13984,13975,14099,-1,14037,14038,14033,14034,-1,14042,14123,14122,14041,-1,13968,14123,14042,13970,-1,13970,14042,14043,13972,-1,14060,14043,14055,14059,-1,14059,14055,14086,14089,-1,14089,14086,14100,14103,-1,14103,14100,14120,13973,-1,13973,14120,14121,13976,-1,13976,14121,14101,14098,-1,14098,14101,14087,14085,-1,14085,14087,14056,14054,-1,14054,14056,14044,13961,-1,13961,14044,14041,13964,-1,13964,14041,14122,13966,-1,13966,14122,14123,13968,-1,13990,13982,14125,14124,-1,14124,14125,14061,14063,-1,13982,13971,14126,14125,-1,14125,14126,14057,14061,-1,13971,13972,14127,14126,-1,14126,14127,14060,14057,-1,13998,13990,14124,14128,-1,14128,14124,14063,14065,-1,14006,13998,14128,14129,-1,14129,14128,14065,14067,-1,14014,14006,14129,14130,-1,14130,14129,14067,14069,-1,14022,14014,14130,14131,-1,14131,14130,14069,14071,-1,14030,14022,14131,14132,-1,14132,14131,14071,14073,-1,13972,14043,14127,-1,14043,14060,14127,-1,14038,14030,14132,-1,14132,14073,14038,-1,14136,14135,14134,14133,-1,14137,14133,14134,-1,14135,14136,14138,-1,14138,14136,14140,14139,-1,14139,14140,14142,14141,-1,14141,14142,14144,14143,-1,14143,14144,14146,14145,-1,14145,14146,14148,14147,-1,14147,14148,14150,14149,-1,14149,14150,14152,14151,-1,14151,14152,14154,14153,-1,14153,14154,14156,14155,-1,14160,14159,14158,14157,-1,14164,14163,14162,14161,-1,14161,14162,14166,14165,-1,14165,14166,14168,14167,-1,14167,14168,14170,14169,-1,14169,14170,14172,14171,-1,14171,14172,14174,14173,-1,14173,14174,14176,14175,-1,14175,14176,14178,14177,-1,14177,14178,14133,14137,-1,14133,14178,14140,14136,-1,14176,14174,14144,14142,-1,14174,14172,14146,14144,-1,14162,14163,14156,14154,-1,14154,14152,14166,14162,-1,14152,14150,14168,14166,-1,14172,14170,14148,14146,-1,14170,14168,14150,14148,-1,14178,14176,14142,14140,-1,14164,14157,14158,14163,-1,14163,14158,14159,14156,-1,14156,14159,14160,14155,-1,14182,14181,14180,14179,-1,14181,14184,14183,14180,-1,14184,14186,14185,14183,-1,14186,14188,14187,14185,-1,14188,14190,14189,14187,-1,14190,14192,14191,14189,-1,14192,14194,14193,14191,-1,14194,14196,14195,14193,-1,14196,14198,14197,14195,-1,14179,14200,14199,14182,-1,14155,14202,14201,14153,-1,14153,14201,14203,14151,-1,14151,14203,14204,14149,-1,14149,14204,14205,14147,-1,14147,14205,14206,14145,-1,14145,14206,14207,14143,-1,14143,14207,14208,14141,-1,14141,14208,14209,14139,-1,14139,14209,14210,14138,-1,14138,14210,14211,14135,-1,14135,14211,14212,14134,-1,14134,14212,14213,14137,-1,14137,14213,14214,14177,-1,14177,14214,14215,14175,-1,14175,14215,14216,14173,-1,14173,14216,14217,14171,-1,14171,14217,14218,14169,-1,14169,14218,14219,14167,-1,14167,14219,14220,14165,-1,14165,14220,14221,14161,-1,14161,14221,14222,14164,-1,14157,14224,14223,14160,-1,14202,14198,14196,14201,-1,14201,14196,14194,14203,-1,14203,14194,14192,14204,-1,14204,14192,14190,14205,-1,14205,14190,14188,14206,-1,14206,14188,14186,14207,-1,14207,14186,14184,14208,-1,14208,14184,14181,14209,-1,14209,14181,14182,14210,-1,14210,14182,14199,14211,-1,14211,14199,14200,14212,-1,14212,14200,14179,14213,-1,14213,14179,14180,14214,-1,14214,14180,14183,14215,-1,14215,14183,14185,14216,-1,14216,14185,14187,14217,-1,14217,14187,14189,14218,-1,14218,14189,14191,14219,-1,14219,14191,14193,14220,-1,14220,14193,14195,14221,-1,14221,14195,14197,14222,-1,14224,14226,14225,14223,-1,14197,14226,14224,14222,-1,14222,14224,14157,14164,-1,14155,14160,14223,14202,-1,14202,14223,14225,14198,-1,14198,14225,14226,14197,-1,14227,14240,14241,14228,-1,14228,14241,14242,14229,-1,14229,14242,14243,14230,-1,14230,14243,14244,14231,-1,14231,14244,14245,14232};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_73()
		{
			int[] value = {-1,14232,14245,14246,14233,-1,14233,14246,14247,14234,-1,14234,14247,14248,14235,-1,14235,14248,14249,14236,-1,14236,14249,14250,14237,-1,14237,14250,14251,14238,-1,14238,14251,14252,14239,-1,14240,14253,14254,14241,-1,14241,14254,14255,14242,-1,14242,14255,14256,14243,-1,14243,14256,14257,14244,-1,14244,14257,14258,14245,-1,14245,14258,14259,14246,-1,14246,14259,14260,14247,-1,14247,14260,14261,14248,-1,14248,14261,14262,14249,-1,14249,14262,14263,14250,-1,14250,14263,14264,14251,-1,14251,14264,14265,14252,-1,14253,14266,14267,14254,-1,14254,14267,14268,14255,-1,14255,14268,14269,14256,-1,14256,14269,14270,14257,-1,14257,14270,14271,14258,-1,14258,14271,14272,14259,-1,14259,14272,14273,14260,-1,14260,14273,14274,14261,-1,14261,14274,14275,14262,-1,14262,14275,14276,14263,-1,14263,14276,14277,14264,-1,14264,14277,14278,14265,-1,14266,14279,14280,14267,-1,14267,14280,14281,14268,-1,14268,14281,14282,14269,-1,14269,14282,14283,14270,-1,14270,14283,14284,14271,-1,14271,14284,14285,14272,-1,14272,14285,14286,14273,-1,14273,14286,14287,14274,-1,14274,14287,14288,14275,-1,14275,14288,14289,14276,-1,14276,14289,14290,14277,-1,14277,14290,14291,14278,-1,14279,14292,14293,14280,-1,14280,14293,14294,14281,-1,14281,14294,14295,14282,-1,14282,14295,14296,14283,-1,14283,14296,14297,14284,-1,14284,14297,14298,14285,-1,14285,14298,14299,14286,-1,14286,14299,14300,14287,-1,14287,14300,14301,14288,-1,14288,14301,14302,14289,-1,14289,14302,14303,14290,-1,14290,14303,14304,14291,-1,14292,14305,14306,14293,-1,14293,14306,14307,14294,-1,14294,14307,14308,14295,-1,14295,14308,14309,14296,-1,14296,14309,14310,14297,-1,14297,14310,14311,14298,-1,14298,14311,14312,14299,-1,14299,14312,14313,14300,-1,14300,14313,14314,14301,-1,14301,14314,14315,14302,-1,14302,14315,14316,14303,-1,14303,14316,14317,14304,-1,14305,14318,14319,14306,-1,14306,14319,14320,14307,-1,14307,14320,14321,14308,-1,14308,14321,14322,14309,-1,14309,14322,14323,14310,-1,14310,14323,14324,14311,-1,14311,14324,14325,14312,-1,14312,14325,14326,14313,-1,14313,14326,14327,14314,-1,14314,14327,14328,14315,-1,14315,14328,14329,14316,-1,14316,14329,14330,14317,-1,14318,14331,14332,14319,-1,14319,14332,14333,14320,-1,14320,14333,14334,14321,-1,14321,14334,14335,14322,-1,14322,14335,14336,14323,-1,14323,14336,14337,14324,-1,14324,14337,14338,14325,-1,14325,14338,14339,14326,-1,14326,14339,14340,14327,-1,14327,14340,14341,14328,-1,14328,14341,14342,14329,-1,14329,14342,14343,14330,-1,14331,14344,14345,14332,-1,14332,14345,14346,14333,-1,14333,14346,14347,14334,-1,14334,14347,14348,14335,-1,14335,14348,14349,14336,-1,14336,14349,14350,14337,-1,14337,14350,14351,14338,-1,14338,14351,14352,14339,-1,14339,14352,14353,14340,-1,14340,14353,14354,14341,-1,14341,14354,14355,14342,-1,14342,14355,14356,14343,-1,14344,14357,14358,14345,-1,14345,14358,14359,14346,-1,14346,14359,14360,14347,-1,14347,14360,14361,14348,-1,14348,14361,14362,14349,-1,14349,14362,14363,14350,-1,14350,14363,14364,14351,-1,14351,14364,14365,14352,-1,14352,14365,14366,14353,-1,14353,14366,14367,14354,-1,14354,14367,14368,14355,-1,14355,14368,14369,14356,-1,14357,14370,14371,14358,-1,14358,14371,14372,14359,-1,14359,14372,14373,14360,-1,14360,14373,14374,14361,-1,14361,14374,14375,14362,-1,14362,14375,14376,14363,-1,14363,14376,14377,14364,-1,14364,14377,14378,14365,-1,14365,14378,14379,14366,-1,14366,14379,14380,14367,-1,14367,14380,14381,14368,-1,14368,14381,14382,14369,-1,14370,14227,14228,14371,-1,14371,14228,14229,14372,-1,14372,14229,14230,14373,-1,14373,14230,14231,14374,-1,14374,14231,14232,14375,-1,14375,14232,14233,14376,-1,14376,14233,14234,14377,-1,14377,14234,14235,14378,-1,14378,14235,14236,14379,-1,14379,14236,14237,14380,-1,14380,14237,14238,14381,-1,14381,14238,14239,14382,-1,14370,14357,14344,14331,14318,14305,14292,14279,14266,14253,14240,14227,-1,14252,14265,14278,14291,14304,14317,14330,14343,14356,14369,14382,14239,-1,14384,14397,14396,14383,-1,14385,14398,14397,14384,-1,14386,14399,14398,14385,-1,14387,14400,14399,14386,-1,14388,14401,14400,14387,-1,14389,14402,14401,14388,-1,14390,14403,14402,14389,-1,14391,14404,14403,14390,-1,14392,14405,14404,14391,-1,14393,14406,14405,14392,-1,14394,14407,14406,14393,-1,14395,14408,14407,14394,-1,14397,14410,14409,14396,-1,14398,14411,14410,14397,-1,14399,14412,14411,14398,-1,14400,14413,14412,14399,-1,14401,14414,14413,14400,-1,14402,14415,14414,14401,-1,14403,14416,14415,14402,-1,14404,14417,14416,14403,-1,14405,14418,14417,14404,-1,14406,14419,14418,14405,-1,14407,14420,14419,14406,-1,14408,14421,14420,14407,-1,14410,14423,14422,14409,-1,14411,14424,14423,14410,-1,14412,14425,14424,14411,-1,14413,14426,14425,14412,-1,14414,14427,14426,14413,-1,14415,14428,14427,14414,-1,14416,14429,14428,14415,-1,14417,14430,14429,14416,-1,14418,14431,14430,14417,-1,14419,14432,14431,14418,-1,14420,14433,14432,14419,-1,14421,14434,14433,14420,-1,14423,14436,14435,14422,-1,14424,14437,14436,14423,-1,14425,14438,14437,14424,-1,14426,14439,14438,14425,-1,14427,14440,14439,14426,-1,14428,14441,14440,14427,-1,14429,14442,14441,14428,-1,14430,14443,14442,14429,-1,14431,14444,14443,14430,-1,14432,14445,14444,14431,-1,14433,14446,14445,14432,-1,14434,14447,14446,14433,-1,14436,14449,14448,14435,-1,14437,14450,14449,14436,-1,14438,14451,14450,14437,-1,14439,14452,14451,14438,-1,14440,14453,14452,14439,-1,14441,14454,14453,14440,-1,14442,14455,14454,14441,-1,14443,14456,14455};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_74()
		{
			int[] value = {14442,-1,14444,14457,14456,14443,-1,14445,14458,14457,14444,-1,14446,14459,14458,14445,-1,14447,14460,14459,14446,-1,14449,14462,14461,14448,-1,14450,14463,14462,14449,-1,14451,14464,14463,14450,-1,14452,14465,14464,14451,-1,14453,14466,14465,14452,-1,14454,14467,14466,14453,-1,14455,14468,14467,14454,-1,14456,14469,14468,14455,-1,14457,14470,14469,14456,-1,14458,14471,14470,14457,-1,14459,14472,14471,14458,-1,14460,14473,14472,14459,-1,14462,14475,14474,14461,-1,14463,14476,14475,14462,-1,14464,14477,14476,14463,-1,14465,14478,14477,14464,-1,14466,14479,14478,14465,-1,14467,14480,14479,14466,-1,14468,14481,14480,14467,-1,14469,14482,14481,14468,-1,14470,14483,14482,14469,-1,14471,14484,14483,14470,-1,14472,14485,14484,14471,-1,14473,14486,14485,14472,-1,14475,14488,14487,14474,-1,14476,14489,14488,14475,-1,14477,14490,14489,14476,-1,14478,14491,14490,14477,-1,14479,14492,14491,14478,-1,14480,14493,14492,14479,-1,14481,14494,14493,14480,-1,14482,14495,14494,14481,-1,14483,14496,14495,14482,-1,14484,14497,14496,14483,-1,14485,14498,14497,14484,-1,14486,14499,14498,14485,-1,14488,14501,14500,14487,-1,14489,14502,14501,14488,-1,14490,14503,14502,14489,-1,14491,14504,14503,14490,-1,14492,14505,14504,14491,-1,14493,14506,14505,14492,-1,14494,14507,14506,14493,-1,14495,14508,14507,14494,-1,14496,14509,14508,14495,-1,14497,14510,14509,14496,-1,14498,14511,14510,14497,-1,14499,14512,14511,14498,-1,14501,14514,14513,14500,-1,14502,14515,14514,14501,-1,14503,14516,14515,14502,-1,14504,14517,14516,14503,-1,14505,14518,14517,14504,-1,14506,14519,14518,14505,-1,14507,14520,14519,14506,-1,14508,14521,14520,14507,-1,14509,14522,14521,14508,-1,14510,14523,14522,14509,-1,14511,14524,14523,14510,-1,14512,14525,14524,14511,-1,14514,14527,14526,14513,-1,14515,14528,14527,14514,-1,14516,14529,14528,14515,-1,14517,14530,14529,14516,-1,14518,14531,14530,14517,-1,14519,14532,14531,14518,-1,14520,14533,14532,14519,-1,14521,14534,14533,14520,-1,14522,14535,14534,14521,-1,14523,14536,14535,14522,-1,14524,14537,14536,14523,-1,14525,14538,14537,14524,-1,14527,14384,14383,14526,-1,14528,14385,14384,14527,-1,14529,14386,14385,14528,-1,14530,14387,14386,14529,-1,14531,14388,14387,14530,-1,14532,14389,14388,14531,-1,14533,14390,14389,14532,-1,14534,14391,14390,14533,-1,14535,14392,14391,14534,-1,14536,14393,14392,14535,-1,14537,14394,14393,14536,-1,14538,14395,14394,14537,-1,14383,14396,14409,14422,14435,14448,14461,14474,14487,14500,14513,14526,-1,14395,14538,14525,14512,14499,14486,14473,14460,14447,14434,14421,14408,-1,14585,14583,14609,14598,-1,14583,14585,14584,14549,-1,14549,14584,14608,14546,-1,14603,14602,14611,-1,14623,14698,14706,-1,14628,14708,14662,14592,-1,14623,14706,14708,14628,-1,14592,14662,14664,14593,-1,14593,14664,14660,14597,-1,14597,14660,14659,14596,-1,14596,14659,14638,14599,-1,14637,14608,14599,14638,-1,14608,14637,14668,14546,-1,14681,14547,14546,14668,-1,14680,14545,14547,14681,-1,14683,14610,14545,14680,-1,14687,14542,14541,14684,-1,14688,14614,14542,14687,-1,14640,14615,14614,14688,-1,14639,14627,14615,14640,-1,14693,14617,14627,14639,-1,14694,14618,14617,14693,-1,14698,14623,14618,14694,-1,14683,14684,14541,14610,-1,14540,14576,14610,14541,-1,14573,14571,14551,14613,-1,14571,14573,14539,14572,-1,14542,14614,14572,14539,-1,14613,14551,14550,-1,14624,14629,14630,14625,-1,14620,14624,14625,14622,-1,14600,14578,14577,14601,-1,14629,14561,14559,14591,-1,14562,14628,14592,14560,-1,14594,14587,14557,-1,14597,14595,14558,14593,-1,14569,14567,14619,14616,-1,14571,14569,14616,14551,-1,14561,14629,14624,14563,-1,14628,14562,14564,14623,-1,14607,14552,14621,-1,14619,14621,14552,14616,-1,14627,14568,14570,14615,-1,14568,14627,14617,-1,14622,14625,14626,-1,14563,14624,14620,14565,-1,14623,14564,14566,14618,-1,14622,14554,14607,14621,-1,14620,14622,14621,14619,-1,14565,14620,14619,14567,-1,14618,14566,14568,14617,-1,14553,14605,14550,-1,14612,14550,14605,14604,-1,14611,14612,14604,14603,-1,14601,14611,14602,-1,14550,14612,14613,-1,14553,14552,14607,14606,-1,14616,14552,14551,-1,14615,14570,14572,14614,-1,14573,14613,14612,14574,-1,14574,14612,14611,14575,-1,14575,14611,14601,14577,-1,14576,14543,14545,14610,-1,14578,14600,14589,14579,-1,14583,14582,14590,14609,-1,14584,14587,14599,14608,-1,14587,14594,14596,14599,-1,14556,14594,14557,-1,14595,14597,14596,14594,-1,14593,14558,14560,14592,-1,14548,14547,14581,-1,14580,14588,14590,14582,-1,14579,14589,14588,14580,-1,14547,14545,14544,14581,-1,14557,14587,14586,-1,14586,14587,14584,14585,-1,14583,14549,14548,14582,-1,14582,14548,14581,14580,-1,14580,14581,14544,14579,-1,14579,14544,14543,14578,-1,14578,14543,14577,-1,14577,14543,14576,14575,-1,14575,14576,14540,14574,-1,14574,14540,14539,14573,-1,14571,14572,14570,14569,-1,14569,14570,14568,14567,-1,14567,14568,14566,14565,-1,14565,14566,14564,14563,-1,14563,14564,14562,14561,-1,14561,14562,14560,14559,-1,14559,14560,14558,14555,-1,14552,14553,14550,14551,-1,14548,14549,14546,14547,-1,14545,14543,14544,-1,14541,14542,14539,14540,-1,14674,14669,14754,14753,-1,14676,14633,14669,14674,-1,14633,14676,14678,14636,-1,14636,14678,14681,14668,-1,14682,14685,14684,14683,-1,14700,14672,14685,14682,-1,14672,14700,14699,14673,-1,14653,14652,14673,14699,-1,14652,14653,14744,14745,-1,14686,14641,14688,14687,-1,14671,14644,14641,14686,-1,14670,14701,14644,14671,-1,14701,14670,14651,-1,14754,14669,14632,14755,-1,14655,14665,14656,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_75()
		{
			int[] value = {14707,14656,14665,14663,-1,14708,14707,14663,14662,-1,14664,14663,14661,14660,-1,14707,14708,14706,14705,-1,14705,14656,14707,-1,14697,14704,14706,14698,-1,14702,14647,14646,14658,-1,14703,14702,14658,14657,-1,14657,14704,14697,14703,-1,14706,14704,14705,-1,14656,14705,14704,14657,-1,14696,14703,14697,-1,14703,14696,14695,14702,-1,14647,14702,14695,14648,-1,14639,14642,14643,14693,-1,14642,14641,14644,-1,14689,14645,14644,14701,-1,14650,14689,14701,14651,-1,14671,14686,14685,14672,-1,14651,14670,14673,14652,-1,14700,14682,14679,14677,-1,14699,14700,14677,14675,-1,14653,14699,14675,14752,-1,14697,14698,14694,14692,-1,14696,14697,14692,14691,-1,14695,14696,14691,14690,-1,14648,14695,14690,14649,-1,14692,14694,14693,14643,-1,14691,14692,14643,14645,-1,14690,14691,14645,14689,-1,14649,14690,14689,14650,-1,14641,14640,14688,-1,14686,14687,14684,14685,-1,14682,14683,14680,14679,-1,14680,14681,14678,14679,-1,14677,14679,14678,14676,-1,14675,14677,14676,14674,-1,14752,14675,14674,14753,-1,14672,14673,14670,14671,-1,14757,14756,14631,14667,-1,14666,14667,14631,14634,-1,14661,14666,14634,14635,-1,14631,14756,14755,14632,-1,14632,14669,14633,-1,14635,14634,14633,14636,-1,14659,14635,14638,-1,14636,14668,14637,-1,14655,14654,14757,14667,-1,14665,14655,14667,14666,-1,14665,14666,14661,14663,-1,14664,14662,14663,-1,14660,14661,14635,14659,-1,14654,14655,14658,14646,-1,14657,14658,14655,14656,-1,14646,14749,14727,14654,-1,14654,14727,14730,14757,-1,14752,14742,14744,14653,-1,14652,14745,14748,14651,-1,14651,14748,14733,14650,-1,14650,14733,14732,14649,-1,14649,14732,14751,14648,-1,14648,14751,14750,14647,-1,14647,14750,14749,14646,-1,14644,14645,14643,14642,-1,14641,14642,14639,14640,-1,14637,14638,14635,14636,-1,14633,14634,14631,14632,-1,14803,14788,14802,-1,14808,14785,14767,14807,-1,15294,14764,15081,-1,14740,14737,14724,14780,-1,14760,14768,14780,14724,-1,14737,14740,14739,14738,-1,14753,14754,14738,14739,-1,14768,14760,14710,-1,14743,14746,14745,14744,-1,14791,14793,14746,14743,-1,14790,14792,14793,14791,-1,14792,14790,14709,-1,14778,14795,14794,14758,-1,14721,14762,14764,-1,14773,14765,14763,14798,-1,14786,14770,14766,14772,-1,14788,14789,14769,14779,-1,14794,14795,15294,15288,-1,15294,14796,14764,-1,15081,14764,14762,-1,14763,14765,14711,-1,14766,14770,14712,-1,14785,14784,14767,-1,14770,14786,14785,14808,-1,14771,14786,14772,-1,14765,14773,14772,14766,-1,14773,14798,14774,-1,14762,14721,14798,14763,-1,14722,14796,14795,14778,-1,14767,14716,14806,14807,-1,14802,14788,14779,-1,14800,14801,14779,14769,-1,14758,14794,15082,14759,-1,14761,14778,14758,-1,14759,14710,14760,-1,14710,14799,14768,-1,14792,14709,14804,-1,14803,14789,14788,-1,14803,14709,14790,-1,14710,14759,15082,15290,-1,14796,14722,14721,-1,14721,14764,14796,-1,14716,14767,14784,-1,14716,14784,14713,-1,14769,14789,14781,-1,14751,14732,14731,14787,-1,14750,14751,14787,14797,-1,14749,14750,14797,14775,-1,14727,14749,14775,14728,-1,14777,14797,14787,-1,14721,14719,14774,14798,-1,14797,14777,14776,14775,-1,14790,14789,14803,-1,14796,15294,14795,-1,15288,15082,14794,-1,14714,14734,14747,14783,-1,14783,14747,14746,14793,-1,14782,14783,14793,14792,-1,14805,14782,14792,14804,-1,14743,14741,14781,14791,-1,14790,14791,14781,14789,-1,14713,14777,14787,14731,-1,14771,14777,14713,14784,-1,14786,14771,14784,14785,-1,14713,14731,14734,14714,-1,14715,14714,14783,14782,-1,14715,14782,14805,-1,14781,14741,14740,14780,-1,14769,14781,14780,14768,-1,14801,14802,14779,-1,14720,14722,14778,14761,-1,14717,14720,14761,14723,-1,14723,14726,14729,14717,-1,14723,14761,14760,14724,-1,14724,14737,14725,-1,14718,14776,14774,14719,-1,14728,14718,14717,14729,-1,14777,14771,14774,14776,-1,14776,14718,14728,14775,-1,14773,14774,14771,14772,-1,14808,14712,14770,-1,14800,14769,14768,14799,-1,14765,14766,14712,14711,-1,14762,14763,14711,15081,-1,14760,14761,14758,14759,-1,14757,14730,14735,14756,-1,14756,14735,14736,14755,-1,14755,14736,14738,14754,-1,14753,14739,14742,14752,-1,14734,14733,14748,14747,-1,14747,14748,14745,14746,-1,14743,14744,14742,14741,-1,14741,14742,14739,14740,-1,14737,14738,14736,14725,-1,14735,14726,14725,14736,-1,14730,14729,14726,14735,-1,14733,14734,14731,14732,-1,14729,14730,14727,14728,-1,14725,14726,14723,14724,-1,14721,14722,14720,14719,-1,14719,14720,14717,14718,-1,14805,14806,14716,14715,-1,14715,14716,14713,14714,-1,15291,15085,14710,15290,-1,15287,14799,14710,15085,-1,15086,14800,14799,15287,-1,15286,14801,14800,15086,-1,15087,14802,14801,15286,-1,15088,14803,14802,15087,-1,15089,14709,14803,15088,-1,15284,14804,14709,15089,-1,15090,14805,14804,15284,-1,15285,14806,14805,15090,-1,15091,14807,14806,15285,-1,15092,14808,14807,15091,-1,15093,14712,14808,15092,-1,15094,14711,14712,15093,-1,15083,15081,14711,15094,-1,14810,14830,14876,14811,-1,14830,14832,14834,14876,-1,14831,14858,14875,14833,-1,14858,14809,14812,14875,-1,14811,14876,14874,14813,-1,14876,14834,14836,14874,-1,14833,14875,14873,14835,-1,14875,14812,14814,14873,-1,14813,14874,14872,14815,-1,14874,14836,14838,14872,-1,14835,14873,14871,14837,-1,14873,14814,14816,14871,-1,14815,14872,14870,14817,-1,14872,14838,14840,14870,-1,14837,14871,14869,14839,-1,14871,14816,14818,14869,-1,14817,14870,14868,14819,-1,14870,14840,14842,14868,-1,14839,14869,14867,14841,-1,14869,14818,14820,14867,-1,14819,14868,14866,14821,-1,14868,14842,14844,14866,-1,14841,14867,14865,14843,-1,14867};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_76()
		{
			int[] value = {14820,14822,14865,-1,14821,14866,14864,14823,-1,14866,14844,14846,14864,-1,14843,14865,14863,14845,-1,14865,14822,14824,14863,-1,14823,14864,14862,14825,-1,14864,14846,14848,14862,-1,14845,14863,14861,14847,-1,14863,14824,14826,14861,-1,14825,14862,14860,14827,-1,14862,14848,14850,14860,-1,14847,14861,14859,14849,-1,14861,14826,14828,14859,-1,14827,14860,14853,14829,-1,14860,14850,14852,14853,-1,14849,14859,14851,-1,14859,14828,14829,14851,-1,14810,14809,14858,14831,-1,14857,14856,14855,14854,-1,14829,14855,14856,14851,-1,14857,14854,14853,14852,-1,14852,14851,14856,14857,-1,14854,14855,14829,14853,-1,14851,14852,14850,14849,-1,14849,14850,14848,14847,-1,14847,14848,14846,14845,-1,14845,14846,14844,14843,-1,14843,14844,14842,14841,-1,14841,14842,14840,14839,-1,14839,14840,14838,14837,-1,14837,14838,14836,14835,-1,14835,14836,14834,14833,-1,14833,14834,14832,14831,-1,14831,14832,14830,14810,-1,14829,14828,14827,-1,14827,14828,14826,14825,-1,14825,14826,14824,14823,-1,14823,14824,14822,14821,-1,14821,14822,14820,14819,-1,14819,14820,14818,14817,-1,14817,14818,14816,14815,-1,14815,14816,14814,14813,-1,14813,14814,14812,14811,-1,14811,14812,14809,14810,-1,14878,14898,14944,14879,-1,14898,14900,14902,14944,-1,14899,14926,14943,14901,-1,14926,14877,14880,14943,-1,14879,14944,14942,14881,-1,14944,14902,14904,14942,-1,14901,14943,14941,14903,-1,14943,14880,14882,14941,-1,14881,14942,14940,14883,-1,14942,14904,14906,14940,-1,14903,14941,14939,14905,-1,14941,14882,14884,14939,-1,14883,14940,14938,14885,-1,14940,14906,14908,14938,-1,14905,14939,14937,14907,-1,14939,14884,14886,14937,-1,14885,14938,14936,14887,-1,14938,14908,14910,14936,-1,14907,14937,14935,14909,-1,14937,14886,14888,14935,-1,14887,14936,14934,14889,-1,14936,14910,14912,14934,-1,14909,14935,14933,14911,-1,14935,14888,14890,14933,-1,14889,14934,14932,14891,-1,14934,14912,14914,14932,-1,14911,14933,14931,14913,-1,14933,14890,14892,14931,-1,14891,14932,14930,14893,-1,14932,14914,14916,14930,-1,14913,14931,14929,14915,-1,14931,14892,14894,14929,-1,14893,14930,14928,14895,-1,14930,14916,14918,14928,-1,14915,14929,14927,14917,-1,14929,14894,14896,14927,-1,14895,14928,14921,14897,-1,14928,14918,14920,14921,-1,14917,14927,14919,-1,14927,14896,14897,14919,-1,14878,14877,14926,14899,-1,14925,14924,14923,14922,-1,14897,14923,14924,14919,-1,14925,14922,14921,14920,-1,14920,14919,14924,14925,-1,14922,14923,14897,14921,-1,14919,14920,14918,14917,-1,14917,14918,14916,14915,-1,14915,14916,14914,14913,-1,14913,14914,14912,14911,-1,14911,14912,14910,14909,-1,14909,14910,14908,14907,-1,14907,14908,14906,14905,-1,14905,14906,14904,14903,-1,14903,14904,14902,14901,-1,14901,14902,14900,14899,-1,14899,14900,14898,14878,-1,14897,14896,14895,-1,14895,14896,14894,14893,-1,14893,14894,14892,14891,-1,14891,14892,14890,14889,-1,14889,14890,14888,14887,-1,14887,14888,14886,14885,-1,14885,14886,14884,14883,-1,14883,14884,14882,14881,-1,14881,14882,14880,14879,-1,14879,14880,14877,14878,-1,14946,14966,15012,14947,-1,14966,14968,14970,15012,-1,14967,14994,15011,14969,-1,14994,14945,14948,15011,-1,14947,15012,15010,14949,-1,15012,14970,14972,15010,-1,14969,15011,15009,14971,-1,15011,14948,14950,15009,-1,14949,15010,15008,14951,-1,15010,14972,14974,15008,-1,14971,15009,15007,14973,-1,15009,14950,14952,15007,-1,14951,15008,15006,14953,-1,15008,14974,14976,15006,-1,14973,15007,15005,14975,-1,15007,14952,14954,15005,-1,14953,15006,15004,14955,-1,15006,14976,14978,15004,-1,14975,15005,15003,14977,-1,15005,14954,14956,15003,-1,14955,15004,15002,14957,-1,15004,14978,14980,15002,-1,14977,15003,15001,14979,-1,15003,14956,14958,15001,-1,14957,15002,15000,14959,-1,15002,14980,14982,15000,-1,14979,15001,14999,14981,-1,15001,14958,14960,14999,-1,14959,15000,14998,14961,-1,15000,14982,14984,14998,-1,14981,14999,14997,14983,-1,14999,14960,14962,14997,-1,14961,14998,14996,14963,-1,14998,14984,14986,14996,-1,14983,14997,14995,14985,-1,14997,14962,14964,14995,-1,14963,14996,14989,14965,-1,14996,14986,14988,14989,-1,14985,14995,14987,-1,14995,14964,14965,14987,-1,14946,14945,14994,14967,-1,14993,14992,14991,14990,-1,14965,14991,14992,14987,-1,14993,14990,14989,14988,-1,14988,14987,14992,14993,-1,14990,14991,14965,14989,-1,14987,14988,14986,14985,-1,14985,14986,14984,14983,-1,14983,14984,14982,14981,-1,14981,14982,14980,14979,-1,14979,14980,14978,14977,-1,14977,14978,14976,14975,-1,14975,14976,14974,14973,-1,14973,14974,14972,14971,-1,14971,14972,14970,14969,-1,14969,14970,14968,14967,-1,14967,14968,14966,14946,-1,14965,14964,14963,-1,14963,14964,14962,14961,-1,14961,14962,14960,14959,-1,14959,14960,14958,14957,-1,14957,14958,14956,14955,-1,14955,14956,14954,14953,-1,14953,14954,14952,14951,-1,14951,14952,14950,14949,-1,14949,14950,14948,14947,-1,14947,14948,14945,14946,-1,15014,15034,15080,15015,-1,15034,15036,15038,15080,-1,15035,15062,15079,15037,-1,15062,15013,15016,15079,-1,15015,15080,15078,15017,-1,15080,15038,15040,15078,-1,15037,15079,15077,15039,-1,15079,15016,15018,15077,-1,15017,15078,15076,15019,-1,15078,15040,15042,15076,-1,15039,15077,15075,15041,-1,15077,15018,15020,15075,-1,15019,15076,15074,15021,-1,15076,15042,15044,15074,-1,15041,15075,15073,15043,-1,15075,15020,15022,15073,-1,15021,15074,15072,15023,-1,15074,15044,15046,15072,-1,15043,15073,15071,15045,-1,15073,15022,15024,15071,-1,15023,15072,15070,15025,-1,15072,15046,15048,15070,-1,15045,15071,15069,15047,-1,15071,15024};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_77()
		{
			int[] value = {15026,15069,-1,15025,15070,15068,15027,-1,15070,15048,15050,15068,-1,15047,15069,15067,15049,-1,15069,15026,15028,15067,-1,15027,15068,15066,15029,-1,15068,15050,15052,15066,-1,15049,15067,15065,15051,-1,15067,15028,15030,15065,-1,15029,15066,15064,15031,-1,15066,15052,15054,15064,-1,15051,15065,15063,15053,-1,15065,15030,15032,15063,-1,15031,15064,15057,15033,-1,15064,15054,15056,15057,-1,15053,15063,15055,-1,15063,15032,15033,15055,-1,15014,15013,15062,15035,-1,15061,15060,15059,15058,-1,15033,15059,15060,15055,-1,15061,15058,15057,15056,-1,15056,15055,15060,15061,-1,15058,15059,15033,15057,-1,15055,15056,15054,15053,-1,15053,15054,15052,15051,-1,15051,15052,15050,15049,-1,15049,15050,15048,15047,-1,15047,15048,15046,15045,-1,15045,15046,15044,15043,-1,15043,15044,15042,15041,-1,15041,15042,15040,15039,-1,15039,15040,15038,15037,-1,15037,15038,15036,15035,-1,15035,15036,15034,15014,-1,15033,15032,15031,-1,15031,15032,15030,15029,-1,15029,15030,15028,15027,-1,15027,15028,15026,15025,-1,15025,15026,15024,15023,-1,15023,15024,15022,15021,-1,15021,15022,15020,15019,-1,15019,15020,15018,15017,-1,15017,15018,15016,15015,-1,15015,15016,15013,15014,-1,15290,15082,15288,15289,-1,15294,15081,15083,15295,-1,15290,15289,15292,15291,-1,15289,15288,15084,15292,-1,15295,15084,15288,15294,-1,15227,15089,15088,15259,-1,15281,15248,15095,15233,-1,15280,15281,15233,15232,-1,15204,15280,15232,15202,-1,15179,15204,15202,15177,-1,15141,15179,15177,15172,-1,15279,15222,15199,-1,15271,15221,15222,15278,-1,15219,15220,15270,15240,-1,15216,15217,15241,15269,-1,15214,15215,15268,15243,-1,15211,15212,15244,15265,-1,15209,15210,15264,15246,-1,15206,15207,15247,15263,-1,15279,15199,15283,15276,-1,15253,15271,15278,15277,-1,15240,15270,15255,15223,-1,15269,15241,15238,15267,-1,15243,15268,15266,15226,-1,15265,15244,15237,15261,-1,15246,15264,15260,15229,-1,15263,15247,15236,15251,-1,15255,15254,15224,15223,-1,15267,15238,15224,15256,-1,15226,15266,15257,15227,-1,15261,15237,15227,15259,-1,15229,15260,15258,15230,-1,15248,15273,15250,15249,-1,15277,15275,15254,15253,-1,15093,15092,15276,15283,-1,15230,15258,15087,-1,15089,15227,15257,-1,15285,15090,15224,15254,-1,15295,15083,15282,-1,15272,15094,15093,15283,-1,15153,15151,15150,15148,15146,15145,15156,15155,-1,15283,15199,15198,15272,-1,15200,15201,15235,-1,15280,15204,15203,15274,-1,15248,15281,15273,-1,15234,15282,15200,15235,-1,15200,15282,15272,-1,15282,15083,15094,15272,-1,15273,15281,15280,15274,-1,15222,15279,15278,-1,15279,15276,15277,15278,-1,15277,15276,15275,-1,15276,15092,15091,15275,-1,15205,15262,15274,15203,-1,15262,15250,15273,15274,-1,15236,15230,15252,15251,-1,15286,15086,15249,15252,-1,15234,15233,15095,15293,-1,15272,15198,15200,-1,15221,15271,15270,15220,-1,15271,15253,15255,15270,-1,15269,15267,15266,15268,-1,15216,15269,15268,15215,-1,15267,15256,15257,15266,-1,15211,15265,15264,15210,-1,15265,15261,15260,15264,-1,15206,15263,15262,15205,-1,15263,15251,15250,15262,-1,15261,15259,15258,15260,-1,15088,15087,15258,15259,-1,15257,15256,15284,15089,-1,15255,15253,15254,-1,15252,15249,15250,15251,-1,15287,15085,15095,15248,-1,15235,15201,15202,15232,-1,15245,15247,15207,15208,-1,15246,15245,15208,15209,-1,15231,15236,15247,15245,-1,15229,15231,15245,15246,-1,15242,15244,15212,15213,-1,15243,15242,15213,15214,-1,15228,15237,15244,15242,-1,15226,15228,15242,15243,-1,15239,15241,15217,15218,-1,15240,15239,15218,15219,-1,15225,15238,15241,15239,-1,15223,15225,15239,15240,-1,15225,15224,15238,-1,15228,15227,15237,-1,15231,15230,15236,-1,15234,15235,15232,15233,-1,15231,15229,15230,-1,15228,15226,15227,-1,15225,15223,15224,-1,15197,15174,15199,15222,-1,15196,15197,15222,15221,-1,15195,15196,15221,15220,-1,15194,15195,15220,15219,-1,15193,15194,15219,15218,-1,15192,15193,15218,15217,-1,15191,15192,15217,15216,-1,15190,15191,15216,15215,-1,15189,15190,15215,15214,-1,15188,15189,15214,15213,-1,15187,15188,15213,15212,-1,15186,15187,15212,15211,-1,15185,15186,15211,15210,-1,15184,15185,15210,15209,-1,15183,15184,15209,15208,-1,15182,15183,15208,15207,-1,15181,15182,15207,15206,-1,15180,15181,15206,15205,-1,15178,15180,15205,15203,-1,15179,15178,15203,15204,-1,15176,15177,15202,15201,-1,15175,15176,15201,15200,-1,15173,15175,15200,15198,-1,15174,15173,15198,15199,-1,15102,15104,15174,15197,-1,15100,15102,15197,15196,-1,15096,15100,15196,15195,-1,15097,15096,15195,15194,-1,15110,15097,15194,15193,-1,15118,15110,15193,15192,-1,15116,15118,15192,15191,-1,15112,15116,15191,15190,-1,15113,15112,15190,15189,-1,15125,15113,15189,15188,-1,15149,15125,15188,15187,-1,15147,15149,15187,15186,-1,15143,15147,15186,15185,-1,15144,15143,15185,15184,-1,15135,15144,15184,15183,-1,15133,15135,15183,15182,-1,15131,15133,15182,15181,-1,15127,15131,15181,15180,-1,15128,15127,15180,15178,-1,15141,15128,15178,15179,-1,15157,15172,15177,15176,-1,15158,15157,15176,15175,-1,15170,15158,15175,15173,-1,15104,15170,15173,15174,-1,15138,15136,15134,15132,15130,15129,15142,15140,-1,15122,15120,15119,15117,15115,15114,15126,15124,-1,15107,15105,15103,15101,15099,15098,15111,15109,-1,15159,15171,15169,15168,15167,15166,15165,15164,15163,15162,15160,-1,15108,15110,15121,-1,15121,15123,15152,-1,15154,15135,15137,-1,15141,15172,15161,15139,-1,15170,15104,15106,-1,15123,15125,15152,-1,15172,15157,15161,-1,15171,15159,15158,15170,-1,15169,15171,15170,15106,-1,15168,15169,15106,15108,-1,15167,15168,15108,15121};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_78()
		{
			int[] value = {-1,15166,15167,15121,15152,-1,15165,15166,15152,15154,-1,15164,15165,15154,15137,-1,15163,15164,15137,15139,-1,15162,15163,15139,15161,-1,15160,15162,15161,15157,-1,15159,15160,15157,15158,-1,15156,15145,15144,15135,-1,15155,15156,15135,15154,-1,15153,15155,15154,15152,-1,15151,15153,15152,15125,-1,15150,15151,15125,15149,-1,15148,15150,15149,15147,-1,15146,15148,15147,15143,-1,15145,15146,15143,15144,-1,15142,15129,15128,15141,-1,15140,15142,15141,15139,-1,15138,15140,15139,15137,-1,15136,15138,15137,15135,-1,15134,15136,15135,15133,-1,15132,15134,15133,15131,-1,15130,15132,15131,15127,-1,15129,15130,15127,15128,-1,15126,15114,15113,15125,-1,15124,15126,15125,15123,-1,15122,15124,15123,15121,-1,15120,15122,15121,15110,-1,15119,15120,15110,15118,-1,15117,15119,15118,15116,-1,15115,15117,15116,15112,-1,15114,15115,15112,15113,-1,15111,15098,15097,15110,-1,15109,15111,15110,15108,-1,15107,15109,15108,15106,-1,15105,15107,15106,15104,-1,15103,15105,15104,15102,-1,15101,15103,15102,15100,-1,15099,15101,15100,15096,-1,15098,15099,15096,15097,-1,15085,15291,15095,-1,15256,15224,15090,15284,-1,15254,15275,15091,15285,-1,15252,15230,15087,15286,-1,15248,15249,15086,15287,-1,15291,15292,15293,15095,-1,15292,15084,15293,-1,15293,15084,15234,-1,15282,15234,15084,15295,-1,15355,15366,15340,15342,-1,15306,15341,15342,15340,-1,15303,15365,15341,15306,-1,15368,15359,15360,-1,15463,15455,15380,-1,15349,15419,15465,15385,-1,15385,15465,15463,15380,-1,15350,15421,15419,15349,-1,15354,15417,15421,15350,-1,15353,15416,15417,15354,-1,15356,15395,15416,15353,-1,15395,15356,15365,15394,-1,15303,15425,15394,15365,-1,15425,15303,15304,15438,-1,15438,15304,15302,15437,-1,15437,15302,15367,15440,-1,15441,15298,15299,15444,-1,15444,15299,15371,15445,-1,15445,15371,15372,15397,-1,15397,15372,15384,15396,-1,15396,15384,15374,15450,-1,15450,15374,15375,15451,-1,15451,15375,15380,15455,-1,15367,15298,15441,15440,-1,15298,15367,15333,15297,-1,15370,15308,15328,15330,-1,15329,15296,15330,15328,-1,15296,15329,15371,15299,-1,15307,15308,15370,-1,15382,15387,15386,15381,-1,15379,15382,15381,15377,-1,15358,15334,15335,15357,-1,15348,15316,15318,15386,-1,15317,15349,15385,15319,-1,15314,15344,15351,-1,15350,15315,15352,15354,-1,15373,15376,15324,15326,-1,15308,15373,15326,15328,-1,15320,15381,15386,15318,-1,15380,15321,15319,15385,-1,15378,15309,15364,-1,15373,15309,15378,15376,-1,15372,15327,15325,15384,-1,15374,15384,15325,-1,15383,15382,15379,-1,15322,15377,15381,15320,-1,15375,15323,15321,15380,-1,15378,15364,15311,15379,-1,15376,15378,15379,15377,-1,15324,15376,15377,15322,-1,15374,15325,15323,15375,-1,15307,15362,15310,-1,15361,15362,15307,15369,-1,15360,15361,15369,15368,-1,15359,15368,15358,-1,15370,15369,15307,-1,15363,15364,15309,15310,-1,15308,15309,15373,-1,15371,15329,15327,15372,-1,15331,15369,15370,15330,-1,15332,15368,15369,15331,-1,15334,15358,15368,15332,-1,15367,15302,15300,15333,-1,15336,15346,15357,15335,-1,15366,15347,15339,15340,-1,15365,15356,15344,15341,-1,15356,15353,15351,15344,-1,15314,15351,15313,-1,15351,15353,15354,15352,-1,15349,15317,15315,15350,-1,15338,15304,15305,-1,15339,15347,15345,15337,-1,15337,15345,15346,15336,-1,15338,15301,15302,15304,-1,15343,15344,15314,-1,15342,15341,15344,15343,-1,15339,15305,15306,15340,-1,15337,15338,15305,15339,-1,15336,15301,15338,15337,-1,15335,15300,15301,15336,-1,15334,15300,15335,-1,15332,15333,15300,15334,-1,15331,15297,15333,15332,-1,15330,15296,15297,15331,-1,15326,15327,15329,15328,-1,15324,15325,15327,15326,-1,15322,15323,15325,15324,-1,15320,15321,15323,15322,-1,15318,15319,15321,15320,-1,15316,15317,15319,15318,-1,15312,15315,15317,15316,-1,15308,15307,15310,15309,-1,15304,15303,15306,15305,-1,15301,15300,15302,-1,15297,15296,15299,15298,-1,15510,15511,15426,15431,-1,15431,15426,15390,15433,-1,15393,15435,15433,15390,-1,15425,15438,15435,15393,-1,15440,15441,15442,15439,-1,15439,15442,15429,15457,-1,15430,15456,15457,15429,-1,15456,15430,15409,15410,-1,15502,15501,15410,15409,-1,15444,15445,15398,15443,-1,15443,15398,15401,15428,-1,15428,15401,15458,15427,-1,15408,15427,15458,-1,15512,15389,15426,15511,-1,15413,15422,15412,-1,15420,15422,15413,15464,-1,15419,15420,15464,15465,-1,15417,15418,15420,15421,-1,15462,15463,15465,15464,-1,15464,15413,15462,-1,15455,15463,15461,15454,-1,15415,15403,15404,15459,-1,15414,15415,15459,15460,-1,15460,15454,15461,15414,-1,15462,15461,15463,-1,15414,15461,15462,15413,-1,15454,15460,15453,-1,15459,15452,15453,15460,-1,15405,15452,15459,15404,-1,15450,15400,15399,15396,-1,15401,15398,15399,-1,15458,15401,15402,15446,-1,15408,15458,15446,15407,-1,15429,15442,15443,15428,-1,15409,15430,15427,15408,-1,15434,15436,15439,15457,-1,15432,15434,15457,15456,-1,15509,15432,15456,15410,-1,15449,15451,15455,15454,-1,15448,15449,15454,15453,-1,15447,15448,15453,15452,-1,15406,15447,15452,15405,-1,15400,15450,15451,15449,-1,15402,15400,15449,15448,-1,15446,15402,15448,15447,-1,15407,15446,15447,15406,-1,15445,15397,15398,-1,15442,15441,15444,15443,-1,15436,15437,15440,15439,-1,15436,15435,15438,15437,-1,15433,15435,15436,15434,-1,15431,15433,15434,15432,-1,15510,15431,15432,15509,-1,15428,15427,15430,15429,-1,15424,15388,15513,15514,-1,15391,15388,15424,15423,-1,15392,15391,15423,15418,-1,15389,15512,15513,15388,-1,15390,15426,15389,-1,15393,15390,15391,15392,-1,15395,15392,15416,-1,15394,15425,15393,-1,15424,15514,15411};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_79()
		{
			int[] value = {15412,-1,15423,15424,15412,15422,-1,15420,15418,15423,15422,-1,15420,15419,15421,-1,15416,15392,15418,15417,-1,15403,15415,15412,15411,-1,15413,15412,15415,15414,-1,15411,15484,15506,15403,-1,15514,15487,15484,15411,-1,15410,15501,15499,15509,-1,15408,15505,15502,15409,-1,15407,15490,15505,15408,-1,15406,15489,15490,15407,-1,15405,15508,15489,15406,-1,15404,15507,15508,15405,-1,15403,15506,15507,15404,-1,15399,15400,15402,15401,-1,15397,15396,15399,15398,-1,15393,15392,15395,15394,-1,15389,15388,15391,15390,-1,15559,15545,15560,-1,15564,15524,15542,15565,-1,15838,15521,16051,-1,15537,15481,15494,15497,-1,15481,15537,15525,15517,-1,15495,15496,15497,15494,-1,15496,15495,15511,15510,-1,15467,15517,15525,-1,15501,15502,15503,15500,-1,15500,15503,15550,15548,-1,15548,15550,15549,15547,-1,15466,15547,15549,-1,15515,15551,15552,15535,-1,15521,15519,15478,-1,15555,15520,15522,15530,-1,15529,15523,15527,15543,-1,15536,15526,15546,15545,-1,16045,16051,15552,15551,-1,15521,15553,16051,-1,15519,15521,15838,-1,15468,15522,15520,-1,15469,15527,15523,-1,15524,15541,15542,-1,15565,15542,15543,15527,-1,15529,15543,15528,-1,15523,15529,15530,15522,-1,15531,15555,15530,-1,15520,15555,15478,15519,-1,15535,15552,15553,15479,-1,15564,15563,15473,15524,-1,15536,15545,15559,-1,15526,15536,15558,15557,-1,15516,15839,15551,15515,-1,15515,15535,15518,-1,15517,15467,15516,-1,15525,15556,15467,-1,15561,15466,15549,-1,15545,15546,15560,-1,15547,15466,15560,-1,16047,15839,15516,15467,-1,15478,15479,15553,-1,15553,15521,15478,-1,15541,15524,15473,-1,15470,15541,15473,-1,15538,15546,15526,-1,15544,15488,15489,15508,-1,15554,15544,15508,15507,-1,15532,15554,15507,15506,-1,15485,15532,15506,15484,-1,15544,15554,15534,-1,15555,15531,15476,15478,-1,15532,15533,15534,15554,-1,15560,15546,15547,-1,15552,16051,15553,-1,15551,15839,16045,-1,15540,15504,15491,15471,-1,15550,15503,15504,15540,-1,15549,15550,15540,15539,-1,15561,15549,15539,15562,-1,15548,15538,15498,15500,-1,15546,15538,15548,15547,-1,15488,15544,15534,15470,-1,15541,15470,15534,15528,-1,15542,15541,15528,15543,-1,15471,15491,15488,15470,-1,15539,15540,15471,15472,-1,15562,15539,15472,-1,15537,15497,15498,15538,-1,15525,15537,15538,15526,-1,15536,15559,15558,-1,15518,15535,15479,15477,-1,15480,15518,15477,15474,-1,15474,15486,15483,15480,-1,15481,15517,15518,15480,-1,15482,15494,15481,-1,15476,15531,15533,15475,-1,15486,15474,15475,15485,-1,15533,15531,15528,15534,-1,15532,15485,15475,15533,-1,15529,15528,15531,15530,-1,15527,15469,15565,-1,15556,15525,15526,15557,-1,15468,15469,15523,15522,-1,15838,15468,15520,15519,-1,15516,15515,15518,15517,-1,15513,15492,15487,15514,-1,15512,15493,15492,15513,-1,15511,15495,15493,15512,-1,15509,15499,15496,15510,-1,15504,15505,15490,15491,-1,15503,15502,15505,15504,-1,15498,15499,15501,15500,-1,15497,15496,15499,15498,-1,15482,15493,15495,15494,-1,15493,15482,15483,15492,-1,15492,15483,15486,15487,-1,15489,15488,15491,15490,-1,15485,15484,15487,15486,-1,15481,15480,15483,15482,-1,15476,15477,15479,15478,-1,15475,15474,15477,15476,-1,15472,15473,15563,15562,-1,15471,15470,15473,15472,-1,16047,15467,15842,16048,-1,15842,15467,15556,16044,-1,16044,15556,15557,15843,-1,15843,15557,15558,16043,-1,16043,15558,15559,15844,-1,15844,15559,15560,15845,-1,15845,15560,15466,15846,-1,15846,15466,15561,16041,-1,16041,15561,15562,15847,-1,15847,15562,15563,16042,-1,16042,15563,15564,15848,-1,15848,15564,15565,15849,-1,15849,15565,15469,15850,-1,15850,15469,15468,15851,-1,15851,15468,15838,15840,-1,15568,15633,15587,15567,-1,15633,15591,15589,15587,-1,15590,15632,15615,15588,-1,15632,15569,15566,15615,-1,15570,15631,15633,15568,-1,15631,15593,15591,15633,-1,15592,15630,15632,15590,-1,15630,15571,15569,15632,-1,15572,15629,15631,15570,-1,15629,15595,15593,15631,-1,15594,15628,15630,15592,-1,15628,15573,15571,15630,-1,15574,15627,15629,15572,-1,15627,15597,15595,15629,-1,15596,15626,15628,15594,-1,15626,15575,15573,15628,-1,15576,15625,15627,15574,-1,15625,15599,15597,15627,-1,15598,15624,15626,15596,-1,15624,15577,15575,15626,-1,15578,15623,15625,15576,-1,15623,15601,15599,15625,-1,15600,15622,15624,15598,-1,15622,15579,15577,15624,-1,15580,15621,15623,15578,-1,15621,15603,15601,15623,-1,15602,15620,15622,15600,-1,15620,15581,15579,15622,-1,15582,15619,15621,15580,-1,15619,15605,15603,15621,-1,15604,15618,15620,15602,-1,15618,15583,15581,15620,-1,15584,15617,15619,15582,-1,15617,15607,15605,15619,-1,15606,15616,15618,15604,-1,15616,15585,15583,15618,-1,15586,15610,15617,15584,-1,15610,15609,15607,15617,-1,15608,15616,15606,-1,15608,15586,15585,15616,-1,15588,15615,15566,15567,-1,15611,15612,15613,15614,-1,15608,15613,15612,15586,-1,15609,15610,15611,15614,-1,15614,15613,15608,15609,-1,15610,15586,15612,15611,-1,15606,15607,15609,15608,-1,15604,15605,15607,15606,-1,15602,15603,15605,15604,-1,15600,15601,15603,15602,-1,15598,15599,15601,15600,-1,15596,15597,15599,15598,-1,15594,15595,15597,15596,-1,15592,15593,15595,15594,-1,15590,15591,15593,15592,-1,15588,15589,15591,15590,-1,15567,15587,15589,15588,-1,15584,15585,15586,-1,15582,15583,15585,15584,-1,15580,15581,15583,15582,-1,15578,15579,15581,15580,-1,15576,15577,15579,15578,-1,15574,15575,15577,15576,-1,15572,15573,15575,15574,-1,15570,15571,15573,15572,-1,15568,15569,15571,15570,-1,15567,15566,15569,15568,-1,15636,15701,15655,15635,-1,15701,15659,15657,15655,-1,15658,15700,15683};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_80()
		{
			int[] value = {15656,-1,15700,15637,15634,15683,-1,15638,15699,15701,15636,-1,15699,15661,15659,15701,-1,15660,15698,15700,15658,-1,15698,15639,15637,15700,-1,15640,15697,15699,15638,-1,15697,15663,15661,15699,-1,15662,15696,15698,15660,-1,15696,15641,15639,15698,-1,15642,15695,15697,15640,-1,15695,15665,15663,15697,-1,15664,15694,15696,15662,-1,15694,15643,15641,15696,-1,15644,15693,15695,15642,-1,15693,15667,15665,15695,-1,15666,15692,15694,15664,-1,15692,15645,15643,15694,-1,15646,15691,15693,15644,-1,15691,15669,15667,15693,-1,15668,15690,15692,15666,-1,15690,15647,15645,15692,-1,15648,15689,15691,15646,-1,15689,15671,15669,15691,-1,15670,15688,15690,15668,-1,15688,15649,15647,15690,-1,15650,15687,15689,15648,-1,15687,15673,15671,15689,-1,15672,15686,15688,15670,-1,15686,15651,15649,15688,-1,15652,15685,15687,15650,-1,15685,15675,15673,15687,-1,15674,15684,15686,15672,-1,15684,15653,15651,15686,-1,15654,15678,15685,15652,-1,15678,15677,15675,15685,-1,15676,15684,15674,-1,15676,15654,15653,15684,-1,15656,15683,15634,15635,-1,15679,15680,15681,15682,-1,15676,15681,15680,15654,-1,15677,15678,15679,15682,-1,15682,15681,15676,15677,-1,15678,15654,15680,15679,-1,15674,15675,15677,15676,-1,15672,15673,15675,15674,-1,15670,15671,15673,15672,-1,15668,15669,15671,15670,-1,15666,15667,15669,15668,-1,15664,15665,15667,15666,-1,15662,15663,15665,15664,-1,15660,15661,15663,15662,-1,15658,15659,15661,15660,-1,15656,15657,15659,15658,-1,15635,15655,15657,15656,-1,15652,15653,15654,-1,15650,15651,15653,15652,-1,15648,15649,15651,15650,-1,15646,15647,15649,15648,-1,15644,15645,15647,15646,-1,15642,15643,15645,15644,-1,15640,15641,15643,15642,-1,15638,15639,15641,15640,-1,15636,15637,15639,15638,-1,15635,15634,15637,15636,-1,15704,15769,15723,15703,-1,15769,15727,15725,15723,-1,15726,15768,15751,15724,-1,15768,15705,15702,15751,-1,15706,15767,15769,15704,-1,15767,15729,15727,15769,-1,15728,15766,15768,15726,-1,15766,15707,15705,15768,-1,15708,15765,15767,15706,-1,15765,15731,15729,15767,-1,15730,15764,15766,15728,-1,15764,15709,15707,15766,-1,15710,15763,15765,15708,-1,15763,15733,15731,15765,-1,15732,15762,15764,15730,-1,15762,15711,15709,15764,-1,15712,15761,15763,15710,-1,15761,15735,15733,15763,-1,15734,15760,15762,15732,-1,15760,15713,15711,15762,-1,15714,15759,15761,15712,-1,15759,15737,15735,15761,-1,15736,15758,15760,15734,-1,15758,15715,15713,15760,-1,15716,15757,15759,15714,-1,15757,15739,15737,15759,-1,15738,15756,15758,15736,-1,15756,15717,15715,15758,-1,15718,15755,15757,15716,-1,15755,15741,15739,15757,-1,15740,15754,15756,15738,-1,15754,15719,15717,15756,-1,15720,15753,15755,15718,-1,15753,15743,15741,15755,-1,15742,15752,15754,15740,-1,15752,15721,15719,15754,-1,15722,15746,15753,15720,-1,15746,15745,15743,15753,-1,15744,15752,15742,-1,15744,15722,15721,15752,-1,15724,15751,15702,15703,-1,15747,15748,15749,15750,-1,15744,15749,15748,15722,-1,15745,15746,15747,15750,-1,15750,15749,15744,15745,-1,15746,15722,15748,15747,-1,15742,15743,15745,15744,-1,15740,15741,15743,15742,-1,15738,15739,15741,15740,-1,15736,15737,15739,15738,-1,15734,15735,15737,15736,-1,15732,15733,15735,15734,-1,15730,15731,15733,15732,-1,15728,15729,15731,15730,-1,15726,15727,15729,15728,-1,15724,15725,15727,15726,-1,15703,15723,15725,15724,-1,15720,15721,15722,-1,15718,15719,15721,15720,-1,15716,15717,15719,15718,-1,15714,15715,15717,15716,-1,15712,15713,15715,15714,-1,15710,15711,15713,15712,-1,15708,15709,15711,15710,-1,15706,15707,15709,15708,-1,15704,15705,15707,15706,-1,15703,15702,15705,15704,-1,15772,15837,15791,15771,-1,15837,15795,15793,15791,-1,15794,15836,15819,15792,-1,15836,15773,15770,15819,-1,15774,15835,15837,15772,-1,15835,15797,15795,15837,-1,15796,15834,15836,15794,-1,15834,15775,15773,15836,-1,15776,15833,15835,15774,-1,15833,15799,15797,15835,-1,15798,15832,15834,15796,-1,15832,15777,15775,15834,-1,15778,15831,15833,15776,-1,15831,15801,15799,15833,-1,15800,15830,15832,15798,-1,15830,15779,15777,15832,-1,15780,15829,15831,15778,-1,15829,15803,15801,15831,-1,15802,15828,15830,15800,-1,15828,15781,15779,15830,-1,15782,15827,15829,15780,-1,15827,15805,15803,15829,-1,15804,15826,15828,15802,-1,15826,15783,15781,15828,-1,15784,15825,15827,15782,-1,15825,15807,15805,15827,-1,15806,15824,15826,15804,-1,15824,15785,15783,15826,-1,15786,15823,15825,15784,-1,15823,15809,15807,15825,-1,15808,15822,15824,15806,-1,15822,15787,15785,15824,-1,15788,15821,15823,15786,-1,15821,15811,15809,15823,-1,15810,15820,15822,15808,-1,15820,15789,15787,15822,-1,15790,15814,15821,15788,-1,15814,15813,15811,15821,-1,15812,15820,15810,-1,15812,15790,15789,15820,-1,15792,15819,15770,15771,-1,15815,15816,15817,15818,-1,15812,15817,15816,15790,-1,15813,15814,15815,15818,-1,15818,15817,15812,15813,-1,15814,15790,15816,15815,-1,15810,15811,15813,15812,-1,15808,15809,15811,15810,-1,15806,15807,15809,15808,-1,15804,15805,15807,15806,-1,15802,15803,15805,15804,-1,15800,15801,15803,15802,-1,15798,15799,15801,15800,-1,15796,15797,15799,15798,-1,15794,15795,15797,15796,-1,15792,15793,15795,15794,-1,15771,15791,15793,15792,-1,15788,15789,15790,-1,15786,15787,15789,15788,-1,15784,15785,15787,15786,-1,15782,15783,15785,15784,-1,15780,15781,15783,15782,-1,15778,15779,15781,15780,-1,15776,15777,15779,15778,-1,15774,15775,15777,15776,-1,15772,15773,15775,15774,-1,15771,15770,15773,15772,-1,16046,16045,15839,16047,-1,16052,15840,15838,16051,-1,16048,16049,16046,16047};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_81()
		{
			int[] value = {-1,16049,15841,16045,16046,-1,16051,16045,15841,16052,-1,16016,15845,15846,15984,-1,15990,15852,16005,16038,-1,15989,15990,16038,16037,-1,15959,15989,16037,15961,-1,15934,15959,15961,15936,-1,15929,15934,15936,15898,-1,15956,15979,16036,-1,16035,15979,15978,16028,-1,15997,16027,15977,15976,-1,16026,15998,15974,15973,-1,16000,16025,15972,15971,-1,16022,16001,15969,15968,-1,16003,16021,15967,15966,-1,16020,16004,15964,15963,-1,16033,16040,15956,16036,-1,16034,16035,16028,16010,-1,15980,16012,16027,15997,-1,16024,15995,15998,16026,-1,15983,16023,16025,16000,-1,16018,15994,16001,16022,-1,15986,16017,16021,16003,-1,16008,15993,16004,16020,-1,15980,15981,16011,16012,-1,16013,15981,15995,16024,-1,15984,16014,16023,15983,-1,16016,15984,15994,16018,-1,15987,16015,16017,15986,-1,16006,16007,16030,16005,-1,16010,16011,16032,16034,-1,16040,16033,15849,15850,-1,15844,16015,15987,-1,16014,15984,15846,-1,16011,15981,15847,16042,-1,16039,15840,16052,-1,16040,15850,15851,16029,-1,15912,15913,15902,15903,15905,15907,15908,15910,-1,16029,15955,15956,16040,-1,15992,15958,15957,-1,16031,15960,15961,16037,-1,16030,16038,16005,-1,15992,15957,16039,15991,-1,16029,16039,15957,-1,16029,15851,15840,16039,-1,16031,16037,16038,16030,-1,16035,16036,15979,-1,16035,16034,16033,16036,-1,16032,16033,16034,-1,16032,15848,15849,16033,-1,15960,16031,16019,15962,-1,16031,16030,16007,16019,-1,16008,16009,15987,15993,-1,16009,16006,15843,16043,-1,16050,15852,15990,15991,-1,15957,15955,16029,-1,15977,16027,16028,15978,-1,16027,16012,16010,16028,-1,16025,16023,16024,16026,-1,15972,16025,16026,15973,-1,16023,16014,16013,16024,-1,15967,16021,16022,15968,-1,16021,16017,16018,16022,-1,15962,16019,16020,15963,-1,16019,16007,16008,16020,-1,16017,16015,16016,16018,-1,16016,16015,15844,15845,-1,15846,16041,16013,16014,-1,16011,16010,16012,-1,16008,16007,16006,16009,-1,16005,15852,15842,16044,-1,15989,15959,15958,15992,-1,15965,15964,16004,16002,-1,15966,15965,16002,16003,-1,16002,16004,15993,15988,-1,16003,16002,15988,15986,-1,15970,15969,16001,15999,-1,15971,15970,15999,16000,-1,15999,16001,15994,15985,-1,16000,15999,15985,15983,-1,15975,15974,15998,15996,-1,15976,15975,15996,15997,-1,15996,15998,15995,15982,-1,15997,15996,15982,15980,-1,15995,15981,15982,-1,15994,15984,15985,-1,15993,15987,15988,-1,15990,15989,15992,15991,-1,15987,15986,15988,-1,15984,15983,15985,-1,15981,15980,15982,-1,15979,15956,15931,15954,-1,15978,15979,15954,15953,-1,15977,15978,15953,15952,-1,15976,15977,15952,15951,-1,15975,15976,15951,15950,-1,15974,15975,15950,15949,-1,15973,15974,15949,15948,-1,15972,15973,15948,15947,-1,15971,15972,15947,15946,-1,15970,15971,15946,15945,-1,15969,15970,15945,15944,-1,15968,15969,15944,15943,-1,15967,15968,15943,15942,-1,15966,15967,15942,15941,-1,15965,15966,15941,15940,-1,15964,15965,15940,15939,-1,15963,15964,15939,15938,-1,15962,15963,15938,15937,-1,15960,15962,15937,15935,-1,15961,15960,15935,15936,-1,15958,15959,15934,15933,-1,15957,15958,15933,15932,-1,15955,15957,15932,15930,-1,15956,15955,15930,15931,-1,15954,15931,15861,15859,-1,15953,15954,15859,15857,-1,15952,15953,15857,15853,-1,15951,15952,15853,15854,-1,15950,15951,15854,15867,-1,15949,15950,15867,15875,-1,15948,15949,15875,15873,-1,15947,15948,15873,15869,-1,15946,15947,15869,15870,-1,15945,15946,15870,15882,-1,15944,15945,15882,15906,-1,15943,15944,15906,15904,-1,15942,15943,15904,15900,-1,15941,15942,15900,15901,-1,15940,15941,15901,15892,-1,15939,15940,15892,15890,-1,15938,15939,15890,15888,-1,15937,15938,15888,15884,-1,15935,15937,15884,15885,-1,15936,15935,15885,15898,-1,15933,15934,15929,15914,-1,15932,15933,15914,15915,-1,15930,15932,15915,15927,-1,15931,15930,15927,15861,-1,15897,15899,15886,15887,15889,15891,15893,15895,-1,15881,15883,15871,15872,15874,15876,15877,15879,-1,15866,15868,15855,15856,15858,15860,15862,15864,-1,15917,15919,15920,15921,15922,15923,15924,15925,15926,15928,15916,-1,15878,15867,15865,-1,15909,15880,15878,-1,15894,15892,15911,-1,15896,15918,15929,15898,-1,15863,15861,15927,-1,15909,15882,15880,-1,15918,15914,15929,-1,15927,15915,15916,15928,-1,15863,15927,15928,15926,-1,15865,15863,15926,15925,-1,15878,15865,15925,15924,-1,15909,15878,15924,15923,-1,15911,15909,15923,15922,-1,15894,15911,15922,15921,-1,15896,15894,15921,15920,-1,15918,15896,15920,15919,-1,15914,15918,15919,15917,-1,15915,15914,15917,15916,-1,15892,15901,15902,15913,-1,15911,15892,15913,15912,-1,15909,15911,15912,15910,-1,15882,15909,15910,15908,-1,15906,15882,15908,15907,-1,15904,15906,15907,15905,-1,15900,15904,15905,15903,-1,15901,15900,15903,15902,-1,15898,15885,15886,15899,-1,15896,15898,15899,15897,-1,15894,15896,15897,15895,-1,15892,15894,15895,15893,-1,15890,15892,15893,15891,-1,15888,15890,15891,15889,-1,15884,15888,15889,15887,-1,15885,15884,15887,15886,-1,15882,15870,15871,15883,-1,15880,15882,15883,15881,-1,15878,15880,15881,15879,-1,15867,15878,15879,15877,-1,15875,15867,15877,15876,-1,15873,15875,15876,15874,-1,15869,15873,15874,15872,-1,15870,15869,15872,15871,-1,15867,15854,15855,15868,-1,15865,15867,15868,15866,-1,15863,15865,15866,15864,-1,15861,15863,15864,15862,-1,15859,15861,15862,15860,-1,15857,15859,15860,15858,-1,15853,15857,15858,15856,-1,15854,15853,15856,15855,-1,15852,16048,15842,-1,16041,15847,15981,16013,-1,16042,15848,16032,16011,-1,16043,15844,15987,16009,-1,16044,15843,16006,16005,-1,15852,16050,16049,16048,-1,16050,15841,16049,-1,15991};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_82()
		{
			int[] value = {15841,16050,-1,16052,15841,15991,16039,-1,16062,16059,16073,16075,-1,16059,16057,16074,16073,-1,16057,16054,16076,16074,-1,16069,16062,16075,16080,-1,16067,16069,16080,16079,-1,16064,16067,16079,16082,-1,16054,16060,16077,16076,-1,16060,16063,16078,16077,-1,16070,16064,16082,16081,-1,16063,16070,16081,16078,-1,16090,16093,16094,16083,-1,16083,16094,16095,16084,-1,16084,16095,16096,16085,-1,16085,16096,16097,16086,-1,16086,16097,16098,16087,-1,16087,16098,16099,16088,-1,16073,16088,16089,16075,-1,16089,16100,16101,16091,-1,16091,16101,16102,16092,-1,16092,16102,16093,16090,-1,16091,16080,16075,16089,-1,16092,16079,16080,16091,-1,16090,16082,16079,16092,-1,16083,16081,16082,16090,-1,16084,16078,16081,16083,-1,16085,16077,16078,16084,-1,16086,16076,16077,16085,-1,16087,16074,16076,16086,-1,16088,16073,16074,16087,-1,16088,16099,16100,16089,-1,16070,16063,16072,16071,-1,16064,16070,16071,16065,-1,16053,16062,16069,16068,-1,16068,16069,16067,16066,-1,16066,16067,16064,16065,-1,16061,16072,16063,16060,-1,16055,16061,16060,16054,-1,16058,16059,16062,16053,-1,16056,16057,16059,16058,-1,16055,16054,16057,16056,-1,16120,16103,16104,16113,-1,16113,16104,16105,16114,-1,16114,16105,16106,16115,-1,16115,16106,16107,16116,-1,16116,16107,16108,16117,-1,16117,16108,16109,16118,-1,16118,16109,16110,16119,-1,16119,16110,16111,16121,-1,16121,16111,16112,16122,-1,16122,16112,16103,16120,-1,16105,16134,16135,16106,-1,16136,16107,16106,16135,-1,16137,16108,16107,16136,-1,16138,16109,16108,16137,-1,16139,16110,16109,16138,-1,16141,16111,16110,16139,-1,16142,16112,16111,16141,-1,16140,16103,16112,16142,-1,16133,16104,16103,16140,-1,16134,16105,16104,16133,-1,16121,16101,16100,16119,-1,16122,16102,16101,16121,-1,16120,16093,16102,16122,-1,16113,16094,16093,16120,-1,16114,16095,16094,16113,-1,16115,16096,16095,16114,-1,16116,16097,16096,16115,-1,16117,16098,16097,16116,-1,16118,16099,16098,16117,-1,16119,16100,16099,16118,-1,16135,16126,16127,16136,-1,16136,16127,16128,16137,-1,16137,16128,16129,16138,-1,16138,16129,16130,16139,-1,16125,16144,16145,16126,-1,16126,16145,16146,16127,-1,16127,16146,16147,16128,-1,16128,16147,16148,16129,-1,16129,16148,16149,16130,-1,16134,16125,16126,16135,-1,16148,16159,16160,16149,-1,16147,16158,16159,16148,-1,16146,16157,16158,16147,-1,16145,16156,16157,16146,-1,16144,16155,16156,16145,-1,16140,16123,16124,16133,-1,16133,16124,16125,16134,-1,16139,16130,16131,16141,-1,16141,16131,16132,16142,-1,16142,16132,16123,16140,-1,16123,16150,16143,16124,-1,16124,16143,16144,16125,-1,16130,16149,16151,16131,-1,16151,16161,16162,16152,-1,16132,16152,16150,16123,-1,16149,16160,16161,16151,-1,16143,16154,16155,16144,-1,16150,16153,16154,16143,-1,16152,16162,16153,16150,-1,16152,16132,16131,16151,-1,16184,16183,16169,16168,-1,16167,16166,16189,16187,-1,16168,16167,16187,16184,-1,16170,16169,16183,16193,-1,16166,16165,16191,16189,-1,16155,16174,16175,16156,-1,16156,16175,16176,16157,-1,16157,16176,16177,16158,-1,16158,16177,16178,16159,-1,16159,16178,16179,16160,-1,16177,16168,16169,16178,-1,16176,16167,16168,16177,-1,16175,16166,16167,16176,-1,16174,16165,16166,16175,-1,16178,16169,16170,16179,-1,16164,16163,16257,16259,-1,16165,16164,16259,16191,-1,16172,16171,16255,16254,-1,16163,16172,16254,16257,-1,16193,16255,16171,16170,-1,16153,16182,16173,16154,-1,16154,16173,16174,16155,-1,16160,16179,16180,16161,-1,16161,16180,16181,16162,-1,16162,16181,16182,16153,-1,16173,16164,16165,16174,-1,16182,16163,16164,16173,-1,16181,16172,16163,16182,-1,16180,16171,16172,16181,-1,16179,16170,16171,16180,-1,16183,16184,16185,16186,-1,16184,16187,16188,16185,-1,16193,16183,16186,16194,-1,16252,16253,16254,16255,-1,16253,16256,16257,16254,-1,16194,16252,16255,16193,-1,16195,16196,16197,-1,16198,16197,16196,-1,16199,16198,16196,16200,-1,16205,16206,16207,-1,16207,16208,16209,16205,-1,16210,16211,16195,-1,16217,16218,16219,-1,16220,16218,16217,-1,16221,16222,16185,-1,16221,16199,16200,16222,-1,16196,16211,16223,16224,-1,16200,16196,16224,16225,-1,16222,16200,16225,16226,-1,16226,16185,16222,-1,16227,16228,16229,16230,-1,16231,16230,16229,-1,16228,16226,16225,-1,16225,16224,16229,16228,-1,16224,16232,16231,16229,-1,16232,16207,16230,16231,-1,16207,16206,16227,16230,-1,16227,16206,16233,-1,16234,16223,16211,-1,16210,16235,16234,16211,-1,16235,16236,16223,16234,-1,16223,16236,16224,-1,16241,16236,16235,-1,16242,16218,16241,-1,16241,16235,16243,16242,-1,16242,16219,16218,-1,16232,16236,16241,16218,-1,16246,16232,16218,16220,-1,16236,16232,16224,-1,16211,16196,16195,-1,16208,16207,16232,16246,-1,16198,16199,16197,-1,16249,16206,16205,16209,-1,16233,16226,16228,16227,-1,16221,16204,16197,16199,-1,16251,16233,16206,16249,-1,16186,16185,16226,16233,-1,16185,16188,16204,16221,-1,16194,16186,16233,16251,-1,16244,16219,16242,16243,-1,16260,16261,16262,-1,16261,16260,16263,-1,16264,16261,16263,16265,-1,16270,16271,16272,-1,16272,16209,16208,16270,-1,16262,16273,16274,-1,16219,16278,16217,-1,16217,16278,16220,-1,16253,16279,16280,-1,16279,16264,16265,16280,-1,16281,16282,16273,16261,-1,16283,16281,16261,16264,-1,16284,16283,16264,16279,-1,16279,16253,16284,-1,16285,16286,16287,16288,-1,16286,16285,16289,-1,16283,16284,16287,-1,16287,16286,16281,16283,-1,16286,16289,16290,16281,-1,16289,16285,16270,16290,-1,16285,16288,16271,16270,-1,16291,16271,16288,-1,16273,16282,16292,-1,16273,16292,16293,16274,-1,16292,16282,16294};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_83()
		{
			int[] value = {16293,-1,16281,16294,16282,-1,16293,16294,16299,-1,16299,16278,16300,-1,16300,16301,16293,16299,-1,16278,16219,16300,-1,16278,16299,16294,16290,-1,16220,16278,16290,16246,-1,16281,16290,16294,-1,16262,16261,16273,-1,16246,16290,16270,16208,-1,16260,16265,16263,-1,16209,16272,16271,16249,-1,16288,16287,16284,16291,-1,16265,16260,16269,16280,-1,16249,16271,16291,16251,-1,16291,16284,16253,16252,-1,16280,16269,16256,16253,-1,16251,16291,16252,16194,-1,16301,16300,16219,16244,-1,16187,16189,16190,16188,-1,16189,16191,16192,16190,-1,16256,16258,16259,16257,-1,16258,16192,16191,16259,-1,16201,16202,16203,-1,16201,16203,16204,-1,16197,16204,16203,-1,16212,16213,16214,16215,-1,16214,16213,16216,-1,16237,16238,16239,-1,16239,16203,16240,-1,16240,16216,16237,16239,-1,16216,16195,16238,16237,-1,16238,16195,16197,-1,16210,16195,16216,-1,16243,16235,16213,-1,16213,16212,16244,16243,-1,16210,16216,16213,16235,-1,16216,16245,16215,16214,-1,16240,16247,16245,16216,-1,16197,16203,16239,16238,-1,16203,16248,16247,16240,-1,16201,16204,16202,-1,16202,16250,16248,16203,-1,16188,16190,16202,16204,-1,16190,16192,16250,16202,-1,16266,16267,16268,-1,16269,16266,16268,-1,16266,16269,16260,-1,16215,16275,16276,16212,-1,16277,16276,16275,-1,16295,16296,16297,-1,16298,16266,16295,-1,16295,16297,16277,16298,-1,16297,16296,16262,16277,-1,16260,16262,16296,-1,16277,16262,16274,-1,16276,16293,16301,-1,16301,16244,16212,16276,-1,16293,16276,16277,16274,-1,16275,16215,16245,16277,-1,16277,16245,16247,16298,-1,16296,16295,16266,16260,-1,16298,16247,16248,16266,-1,16267,16269,16268,-1,16266,16248,16250,16267,-1,16269,16267,16258,16256,-1,16267,16250,16192,16258,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_20_texCoordIndex_1()
		{
			int[] value = {0,180,1,2,-1,2,1,3,4,-1,4,3,5,15619,-1,7,6,8,9,-1,9,8,10,11,-1,11,10,15626,15627,-1,12,13,188,187,-1,14,15,16,17,-1,17,16,18,19,-1,19,18,20,21,-1,21,20,22,23,-1,24,23,22,-1,25,26,13,12,-1,27,28,29,30,-1,15661,27,30,31,-1,192,32,1,180,-1,28,27,33,-1,15666,34,35,15667,-1,36,37,38,39,-1,24,36,39,40,-1,43,42,41,44,-1,45,43,44,46,-1,15668,45,46,15669,-1,47,48,49,50,-1,50,39,38,47,-1,35,26,25,51,-1,27,15661,50,49,-1,53,3,1,32,-1,3,53,55,5,-1,40,15684,24,-1,56,36,24,-1,56,57,37,36,-1,48,58,33,49,-1,40,39,50,15685,-1,15661,15662,15685,50,-1,15664,15684,40,15685,-1,59,15684,15690,15667,-1,51,59,15667,35,-1,26,35,34,60,-1,60,61,13,26,-1,188,13,61,62,-1,15684,59,63,-1,63,59,51,64,-1,64,51,25,65,-1,65,25,12,66,-1,67,56,24,22,-1,68,67,22,20,-1,69,68,20,18,-1,70,69,18,16,-1,71,70,16,15,-1,66,12,187,198,-1,72,60,34,15695,-1,10,72,15695,15626,-1,46,11,15627,15669,-1,45,15668,15701,73,-1,74,61,60,72,-1,8,74,72,10,-1,44,9,11,46,-1,43,45,73,75,-1,201,62,61,74,-1,6,201,74,8,-1,41,7,9,44,-1,42,43,75,54,-1,76,77,78,79,-1,80,76,79,81,-1,205,80,81,206,-1,4,15619,77,76,-1,2,4,76,80,-1,0,2,80,205,-1,77,15675,83,78,-1,15675,77,15703,-1,15619,15621,15703,77,-1,84,15679,15678,85,-1,82,15677,15679,84,-1,52,30,29,85,-1,27,49,33,-1,53,87,86,55,-1,32,88,87,53,-1,88,32,192,54,-1,73,87,88,75,-1,15701,86,87,73,-1,75,88,54,-1,82,83,15675,-1,84,89,83,82,-1,85,29,89,84,-1,63,24,15684,-1,64,21,23,63,-1,65,19,21,64,-1,66,17,19,65,-1,198,14,17,66,-1,63,23,24,-1,90,91,212,211,-1,92,93,91,90,-1,95,14835,93,92,-1,96,97,216,215,-1,98,99,97,96,-1,14840,14841,99,98,-1,100,219,101,102,-1,103,104,220,221,-1,105,106,104,103,-1,107,108,106,105,-1,109,110,108,107,-1,110,109,111,-1,102,101,112,113,-1,14881,29,28,114,-1,14882,14881,114,115,-1,212,91,118,119,-1,33,114,28,-1,120,121,14885,122,-1,123,124,125,126,-1,127,123,126,111,-1,128,227,226,129,-1,130,128,129,131,-1,14886,130,131,132,-1,133,134,135,136,-1,136,124,123,133,-1,137,113,112,121,-1,134,133,115,114,-1,118,91,93,139,-1,14835,14901,139,93,-1,111,140,127,-1,111,126,56,-1,126,125,57,56,-1,134,33,58,135,-1,141,133,123,127,-1,133,141,116,115,-1,141,127,140,117,-1,120,14904,140,143,-1,121,120,143,137,-1,144,14885,121,112,-1,112,101,145,144,-1,231,145,101,219,-1,146,143,140,-1,147,137,143,146,-1,148,113,137,147,-1,149,102,113,148,-1,110,111,56,67,-1,108,110,67,68,-1,106,108,68,69,-1,104,106,69,70,-1,220,104,70,71,-1,150,100,102,149,-1,14912,14885,144,151,-1,14841,14912,151,99,-1,14886,14840,98,130,-1,152,142,132,131,-1,151,144,145,153,-1,99,151,153,97,-1,130,98,96,128,-1,154,152,131,129,-1,153,145,231,155,-1,97,153,155,216,-1,128,96,215,227,-1,228,154,129,226,-1,79,78,156,157,-1,81,79,157,158,-1,206,81,158,159,-1,157,156,95,92,-1,158,157,92,90,-1,159,158,90,211,-1,78,83,14895,156,-1,14919,156,14895,-1,156,14919,94,95,-1,14920,138,14896,160,-1,160,14896,14893,14918,-1,14920,29,14881,14890,-1,33,134,114,-1,14901,14924,161,139,-1,139,161,162,118,-1,228,119,118,162,-1,154,162,161,152,-1,152,161,14924,142,-1,228,162,154,-1,14895,83,14918,-1,14918,83,89,160,-1,160,89,29,14920,-1,140,111,146,-1,146,109,107,147,-1,147,107,105,148,-1,148,105,103,149,-1,149,103,221,150,-1,111,109,146,-1,165,16438,164,166,-1,167,166,164,163,-1,168,167,163,16437,-1,16438,165,169,16439,-1,170,16439,169,171,-1,172,16441,173,174,-1,16440,16441,172,175,-1,16437,16440,175,168,-1,16442,176,174,173,-1,171,176,16442,170,-1,177,254,178,179,-1,179,178,180,0,-1,182,181,183,184,-1,184,183,6,7,-1,185,186,263,262,-1,187,188,186,185,-1,189,190,15,14,-1,191,264,190,189,-1,193,192,180,178,-1,41,42,194,-1,192,193,54,-1,298,193,178,254,-1,186,188,62,197};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_2()
		{
			int[] value = {-1,263,186,197,195,-1,198,187,185,199,-1,302,199,185,262,-1,200,71,15,190,-1,196,200,190,264,-1,202,203,62,201,-1,183,202,201,6,-1,194,184,7,41,-1,193,194,42,54,-1,351,352,203,202,-1,181,351,202,183,-1,204,182,184,194,-1,298,204,194,193,-1,197,62,203,-1,195,197,203,352,-1,207,205,206,208,-1,358,207,208,359,-1,179,0,205,207,-1,177,179,207,358,-1,199,189,14,198,-1,302,191,189,199,-1,209,210,382,383,-1,211,212,210,209,-1,213,214,385,384,-1,215,216,214,213,-1,393,392,217,218,-1,218,217,219,100,-1,221,220,222,223,-1,223,222,394,395,-1,210,212,119,224,-1,225,226,227,-1,228,224,119,-1,382,210,224,229,-1,232,231,219,217,-1,428,232,217,392,-1,233,218,100,150,-1,393,218,233,230,-1,222,220,71,200,-1,394,222,200,196,-1,155,231,234,235,-1,216,155,235,214,-1,227,215,213,225,-1,228,226,225,224,-1,235,234,236,237,-1,214,235,237,385,-1,225,213,384,470,-1,224,225,470,229,-1,234,231,232,-1,236,234,232,428,-1,208,206,159,238,-1,359,208,238,476,-1,238,159,211,209,-1,476,238,209,383,-1,150,221,223,233,-1,233,223,395,230,-1,3868,3869,239,-1,240,241,242,-1,3868,239,3920,-1,244,240,242,-1,241,240,245,-1,246,239,247,-1,247,248,242,241,-1,3869,248,247,239,-1,249,3921,3872,-1,251,250,2960,-1,2981,2980,252,253,-1,253,252,254,177,-1,255,256,181,182,-1,257,256,255,-1,258,259,260,261,-1,262,263,259,258,-1,265,266,267,268,-1,269,270,264,191,-1,271,272,273,274,-1,272,271,275,276,-1,276,275,277,278,-1,278,277,261,265,-1,260,266,265,261,-1,266,260,279,280,-1,2982,281,280,279,-1,279,2983,2982,-1,282,283,284,285,-1,286,287,283,282,-1,285,284,288,289,-1,290,291,289,288,-1,291,290,292,293,-1,293,292,294,295,-1,2984,2985,295,294,-1,244,249,2986,-1,3921,249,244,248,3869,-1,245,240,244,297,-1,244,242,248,-1,246,3920,239,-1,241,245,246,247,-1,299,298,254,252,-1,296,299,252,2980,-1,300,279,260,259,-1,195,300,259,263,-1,301,258,261,277,-1,302,262,258,301,-1,278,265,268,303,-1,290,304,305,292,-1,284,306,303,288,-1,270,269,275,271,-1,307,196,264,270,-1,308,273,272,309,-1,287,308,309,283,-1,306,284,283,309,-1,276,306,309,272,-1,307,270,271,274,-1,305,251,310,-1,2989,310,251,2960,-1,294,292,305,310,-1,2989,2984,294,310,-1,312,313,314,-1,315,312,314,316,-1,317,318,315,316,-1,315,318,319,320,-1,312,315,320,321,-1,322,323,324,325,-1,2995,322,325,326,-1,327,328,329,-1,2986,328,322,2995,-1,328,2986,249,-1,297,244,330,331,-1,332,331,330,333,-1,334,332,333,3004,-1,3872,3874,328,249,-1,335,336,286,282,-1,337,335,282,285,-1,338,337,285,289,-1,339,340,291,293,-1,341,339,293,295,-1,3010,341,295,2985,-1,342,343,336,335,-1,342,318,317,344,-1,319,318,345,346,-1,347,348,340,339,-1,349,347,339,341,-1,3013,350,341,3010,-1,353,354,352,351,-1,256,353,351,181,-1,355,255,182,204,-1,299,355,204,298,-1,257,2983,354,353,-1,257,353,256,-1,311,257,255,355,-1,296,311,355,299,-1,300,195,352,354,-1,279,300,354,2983,-1,334,3004,3029,356,-1,357,356,3029,3030,-1,360,358,359,361,-1,362,360,361,363,-1,3031,362,363,364,-1,3030,3031,364,357,-1,253,177,358,360,-1,2981,253,360,362,-1,250,251,280,281,-1,251,267,266,280,-1,2986,365,330,244,-1,2978,2981,362,3031,-1,343,342,344,366,-1,346,345,337,338,-1,345,342,335,337,-1,342,345,318,-1,3929,314,313,3934,-1,3929,3928,316,314,-1,328,327,323,322,-1,329,328,3874,3873,-1,3936,317,316,3928,-1,243,344,317,3936,-1,3942,366,344,243,-1,324,350,3013,325,-1,320,347,349,321,-1,319,348,347,320,-1,346,348,319,-1,338,340,348,346,-1,289,291,340,338,-1,303,304,290,288,-1,268,304,303,-1,267,305,304,268,-1,251,305,267,-1,301,269,191,302,-1,277,275,269,301,-1,303,306,276,278,-1,350,349,341,-1,324,321,349,350,-1,323,312,321,324,-1,327,312,323,-1,329,313,312,327,-1,3933,3934,313,329,-1,3873,3933,329,-1,367,368,3968,-1,369,370,371,-1,3920,367,3968,-1,369,371,372,-1,245,371,370,-1,373,367,246,-1,370,369,374,373,-1,367,373,374,368,-1,3969,4015,375,-1,2073,2072,376,-1,380,381,378,377,-1,383,382,381,380,-1,384,385,386,387,-1,387,386,2093,-1,388};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_3()
		{
			int[] value = {389,390,391,-1,391,390,392,393,-1,396,397,398,399,-1,395,394,400,401,-1,274,273,402,403,-1,404,405,403,402,-1,406,407,405,404,-1,399,388,407,406,-1,388,399,398,389,-1,408,409,389,398,-1,409,408,2094,410,-1,410,411,409,-1,412,413,414,415,-1,415,414,287,286,-1,416,417,413,412,-1,417,416,418,419,-1,420,421,419,418,-1,422,423,421,420,-1,423,422,424,2095,-1,425,375,372,-1,368,374,372,375,4015,-1,297,372,371,245,-1,374,369,372,-1,367,3920,246,-1,373,246,245,370,-1,381,382,229,426,-1,378,381,426,2096,-1,390,389,409,427,-1,392,390,427,428,-1,407,388,391,429,-1,429,391,393,230,-1,430,396,399,406,-1,421,431,432,419,-1,417,430,433,413,-1,403,405,401,400,-1,400,394,196,307,-1,434,402,273,308,-1,414,434,308,287,-1,434,414,413,433,-1,402,434,433,404,-1,274,403,400,307,-1,435,376,431,-1,2073,376,435,436,-1,435,431,421,423,-1,435,423,2095,436,-1,437,438,439,-1,440,437,439,441,-1,440,441,442,443,-1,444,445,442,441,-1,446,444,441,439,-1,2105,447,448,449,-1,2106,2105,449,2107,-1,450,451,452,-1,2107,449,451,425,-1,375,425,451,-1,331,2116,372,297,-1,2117,2116,331,332,-1,453,2117,332,334,-1,375,451,3973,3969,-1,415,286,336,454,-1,412,415,454,455,-1,416,412,455,456,-1,420,418,457,458,-1,422,420,458,459,-1,424,422,459,460,-1,454,336,343,461,-1,462,443,442,461,-1,463,464,442,445,-1,458,457,465,466,-1,459,458,466,467,-1,460,459,468,469,-1,237,236,471,472,-1,385,237,472,386,-1,470,384,387,473,-1,229,470,473,426,-1,472,471,411,2093,-1,386,472,2093,-1,473,387,2093,2099,-1,426,473,2099,2096,-1,471,236,428,427,-1,411,471,427,409,-1,356,474,453,334,-1,475,474,356,357,-1,361,359,476,477,-1,363,361,477,478,-1,364,363,478,479,-1,357,364,479,475,-1,477,476,383,380,-1,478,477,380,377,-1,2094,408,376,2072,-1,408,398,397,376,-1,372,2116,2140,425,-1,479,478,377,379,-1,366,462,461,343,-1,456,455,464,463,-1,455,454,461,464,-1,442,464,461,-1,4027,438,437,4023,-1,437,440,4021,4023,-1,449,448,452,451,-1,3974,3973,451,450,-1,4021,440,443,4029,-1,4029,443,462,4028,-1,4028,462,366,3942,-1,2105,469,468,447,-1,446,467,466,444,-1,444,466,465,445,-1,445,465,463,-1,463,465,457,456,-1,456,457,418,416,-1,417,419,432,430,-1,430,432,396,-1,396,432,431,397,-1,397,431,376,-1,230,395,401,429,-1,429,401,405,407,-1,406,404,433,430,-1,459,467,468,-1,468,467,446,447,-1,447,446,439,448,-1,448,439,452,-1,452,439,438,450,-1,450,438,4027,4026,-1,450,4026,3974,-1,480,4090,481,4091,-1,4090,4097,481,-1,481,482,4114,4091,-1,4097,483,482,481,-1,4097,484,4120,483,-1,482,483,485,4150,-1,4150,485,4098,4092,-1,483,4120,4151,485,-1,486,487,488,-1,489,490,491,492,-1,493,494,495,496,-1,497,498,499,500,-1,501,502,503,504,-1,505,506,507,508,-1,509,510,511,512,-1,513,506,514,-1,515,502,516,-1,517,494,499,-1,518,519,520,-1,521,522,523,-1,524,525,526,-1,527,528,529,530,-1,531,532,533,534,-1,535,536,537,538,-1,510,524,511,-1,511,524,513,539,-1,511,539,540,512,-1,539,513,514,-1,539,514,541,540,-1,506,513,507,-1,505,541,514,506,-1,516,507,513,515,-1,542,508,507,516,-1,502,515,503,-1,501,542,516,502,-1,515,498,503,-1,498,515,517,499,-1,497,504,503,498,-1,494,517,495,-1,493,500,499,494,-1,495,517,518,543,-1,495,543,544,496,-1,543,518,545,-1,543,545,546,544,-1,518,547,545,-1,548,546,545,547,-1,547,518,549,-1,549,550,548,547,-1,549,518,520,-1,549,520,532,550,-1,518,551,490,519,-1,533,532,520,519,-1,490,551,491,-1,489,533,519,490,-1,551,552,491,-1,553,492,491,552,-1,552,551,521,523,-1,523,538,553,552,-1,521,4304,554,522,-1,535,538,523,522,-1,4304,4297,554,-1,555,535,522,554,-1,4296,555,554,4297,-1,524,510,525,-1,556,557,526,525,-1,509,556,525,510,-1,4316,4317,558,559,-1,560,561,562,563,-1,550,564,565,548,-1,4324,4325,566,567,-1,4336,4337,568,569,-1,4333,4332,570,571,-1,4291,4331,572,573,-1,573,572,574,-1,575,571,570,-1,575,576,530,-1,528,527,577,578,-1,541,505,579,580,-1,581,582,580,579,-1,582,581,488,487,-1,583,584,585,586,-1,587,588,500,493,-1,589,590,588,587,-1,586,585,590,589,-1,532};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_4()
		{
			int[] value = {531,564,550,-1,548,565,591,546,-1,592,593,4360,4361,-1,594,593,592,-1,595,596,597,598,-1,531,534,596,595,-1,489,599,534,533,-1,4362,600,601,4363,-1,492,602,599,489,-1,555,603,536,535,-1,537,536,604,605,-1,4363,601,606,-1,4296,4364,603,555,-1,538,537,607,553,-1,553,607,602,492,-1,563,608,609,610,-1,4366,4367,611,612,-1,4368,4369,600,4362,-1,613,614,557,556,-1,615,616,614,613,-1,617,618,616,615,-1,4374,4375,619,620,-1,618,617,621,622,-1,622,621,620,619,-1,4385,4366,612,623,-1,4367,4386,624,611,-1,623,612,609,625,-1,612,611,610,609,-1,611,624,626,610,-1,560,563,610,626,-1,608,625,609,-1,625,627,623,-1,628,627,625,629,-1,630,629,625,608,-1,631,632,630,633,-1,629,630,632,634,-1,632,602,607,634,-1,605,628,629,634,-1,607,537,605,634,-1,4364,4363,606,603,-1,606,601,627,628,-1,603,606,604,536,-1,606,628,605,604,-1,631,599,602,632,-1,601,600,623,627,-1,4361,4389,635,592,-1,592,635,636,594,-1,636,637,598,594,-1,598,637,638,595,-1,531,595,638,-1,596,534,599,631,-1,596,631,633,597,-1,633,563,562,597,-1,626,639,561,560,-1,640,639,626,624,-1,593,640,4390,4360,-1,4390,640,624,4386,-1,635,4401,641,-1,642,641,4401,4402,-1,643,644,645,646,-1,583,644,643,567,-1,647,648,649,650,-1,589,649,648,586,-1,650,649,651,652,-1,587,651,649,589,-1,651,587,493,496,-1,496,544,546,591,-1,565,653,652,591,-1,653,654,647,650,-1,645,647,654,655,-1,645,655,656,646,-1,657,656,655,658,-1,658,655,654,659,-1,659,654,653,660,-1,660,564,531,638,-1,638,637,659,660,-1,637,636,658,659,-1,636,635,641,658,-1,642,658,641,-1,657,658,642,-1,4405,657,642,4402,-1,656,657,4405,4406,-1,646,656,4406,4347,-1,583,586,648,644,-1,644,648,647,645,-1,4291,573,661,4413,-1,4324,567,643,-1,566,661,662,663,-1,574,662,661,573,-1,664,529,528,665,-1,528,666,667,665,-1,528,578,666,-1,501,504,666,578,-1,585,664,665,590,-1,590,665,667,588,-1,588,667,497,500,-1,584,663,664,585,-1,584,583,567,-1,529,662,574,-1,662,529,664,663,-1,668,669,509,512,-1,613,556,509,669,-1,615,613,669,670,-1,669,668,671,670,-1,670,671,672,673,-1,615,670,673,617,-1,674,675,676,677,-1,620,674,4416,4374,-1,559,678,4422,4316,-1,559,558,679,486,-1,487,486,679,680,-1,487,680,681,582,-1,581,682,683,488,-1,582,681,684,580,-1,681,671,668,684,-1,684,668,512,540,-1,580,684,540,541,-1,685,579,505,508,-1,685,508,542,577,-1,527,682,685,577,-1,542,501,578,577,-1,683,682,527,530,-1,530,529,574,575,-1,576,686,683,530,-1,678,686,576,568,-1,570,569,576,575,-1,572,571,575,574,-1,571,572,4331,4333,-1,569,570,4332,4336,-1,4337,4422,678,568,-1,682,581,579,685,-1,643,646,4347,4324,-1,4413,661,566,4325,-1,680,672,671,681,-1,680,679,676,672,-1,564,660,653,565,-1,561,639,594,562,-1,639,640,593,594,-1,674,677,4425,4416,-1,4317,4425,677,558,-1,558,677,676,679,-1,617,673,675,621,-1,621,675,674,620,-1,675,673,672,676,-1,666,504,497,667,-1,488,683,686,486,-1,486,686,678,559,-1,598,597,562,594,-1,567,566,663,584,-1,608,563,633,630,-1,652,651,496,591,-1,653,650,652,-1,569,568,576,-1,687,688,4427,4428,-1,689,690,691,692,-1,693,694,4429,4430,-1,4431,4427,688,695,-1,696,697,4432,4433,-1,697,698,4438,4432,-1,698,700,701,4438,-1,699,702,4444,4439,-1,700,694,693,701,-1,702,695,688,4444,-1,4444,688,687,4445,-1,4445,687,4428,4446,-1,4448,690,689,4449,-1,703,704,690,4448,-1,704,705,691,690,-1,693,4430,4455,706,-1,706,4455,4431,695,-1,701,693,706,707,-1,707,706,695,702,-1,4438,701,707,4456,-1,4456,707,702,699,-1,708,4459,709,-1,4459,710,709,-1,711,712,713,714,-1,712,715,716,713,-1,715,712,717,718,-1,719,717,712,711,-1,4470,717,719,720,-1,718,717,4470,721,-1,4459,708,722,723,-1,4488,723,722,724,-1,725,726,692,691,-1,727,728,726,725,-1,4502,729,697,696,-1,730,694,731,-1,732,694,730,-1,4503,4429,694,732,-1,732,734,733,4503,-1,730,735,734,732,-1,731,736,735,730,-1,737,738,729,4502,-1,739,740,741,710,-1,708,742,743,722,-1,722,743,744,724,-1,740,745,746,741,-1,742,747,748,743,-1,743,748,749,744,-1,738,750,751,729,-1,729,751,698,697,-1,4459,739,710,-1,751,753,700,698,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_5()
		{
			int[] value = {745,755,756,746,-1,747,757,758,748,-1,748,758,759,749,-1,750,760,753,751,-1,753,731,694,700,-1,4552,4470,720,754,-1,755,728,727,756,-1,757,714,713,758,-1,758,713,716,759,-1,760,736,731,753,-1,4488,724,761,4553,-1,4553,761,737,752,-1,724,744,762,761,-1,761,762,738,737,-1,744,749,763,762,-1,762,763,750,738,-1,749,759,764,763,-1,763,764,760,750,-1,759,716,765,764,-1,764,765,736,760,-1,716,715,766,765,-1,765,766,735,736,-1,715,718,767,766,-1,766,767,734,735,-1,718,721,768,767,-1,767,768,733,734,-1,768,4554,4509,733,-1,754,720,704,703,-1,720,719,705,704,-1,719,711,769,705,-1,705,769,725,691,-1,711,714,770,769,-1,769,770,727,725,-1,756,727,770,771,-1,771,770,714,757,-1,746,756,771,772,-1,772,771,757,747,-1,741,746,772,773,-1,773,772,747,742,-1,710,741,773,709,-1,709,773,742,708,-1,774,775,776,777,-1,779,780,4602,4601,-1,781,782,780,779,-1,783,784,782,781,-1,785,786,784,783,-1,787,788,786,785,-1,789,790,788,787,-1,4603,791,790,789,-1,780,792,4622,4602,-1,782,793,792,780,-1,784,794,793,782,-1,786,795,794,784,-1,788,796,795,786,-1,790,797,796,788,-1,791,798,797,790,-1,793,794,795,796,-1,4622,792,797,798,-1,796,797,792,793,-1,799,800,4582,778,-1,800,799,775,774,-1,789,799,778,4603,-1,787,775,799,789,-1,785,776,775,787,-1,783,777,776,785,-1,781,774,777,783,-1,779,800,774,781,-1,4601,4582,800,779,-1,801,803,804,4683,-1,4683,804,805,4684,-1,4684,805,806,4685,-1,4685,806,807,4686,-1,4686,807,808,4687,-1,802,809,810,4688,-1,803,811,812,804,-1,804,812,813,805,-1,805,813,814,806,-1,806,814,815,807,-1,807,815,816,808,-1,809,817,818,810,-1,811,819,820,812,-1,812,820,821,813,-1,813,821,822,814,-1,814,822,823,815,-1,815,823,824,816,-1,817,825,826,818,-1,823,822,821,820,-1,811,827,828,819,-1,803,829,827,811,-1,801,830,829,803,-1,833,834,4712,832,-1,835,836,834,833,-1,824,837,836,835,-1,819,828,837,824,-1,827,838,839,828,-1,829,840,838,827,-1,830,841,840,829,-1,831,842,841,830,-1,834,843,4726,4712,-1,836,844,843,834,-1,837,845,844,836,-1,828,839,845,837,-1,843,846,4737,4726,-1,844,847,846,843,-1,845,848,847,844,-1,839,849,848,845,-1,838,850,849,839,-1,840,851,850,838,-1,841,4738,851,840,-1,842,4739,4738,841,-1,846,809,802,4737,-1,847,817,809,846,-1,848,825,817,847,-1,849,826,825,848,-1,850,818,826,849,-1,851,810,818,850,-1,4738,4688,810,851,-1,820,819,824,823,-1,852,4753,4687,808,-1,833,832,4753,852,-1,853,852,808,816,-1,835,833,852,853,-1,853,816,824,-1,824,835,853,-1,855,856,4770,854,-1,857,858,856,855,-1,859,860,858,857,-1,861,862,863,864,-1,865,866,867,868,-1,869,870,866,865,-1,4771,4772,870,869,-1,858,860,867,866,-1,866,870,856,858,-1,870,4772,4770,856,-1,867,862,861,868,-1,860,863,862,867,-1,859,864,863,860,-1,871,872,873,4795,-1,872,874,875,873,-1,874,876,877,875,-1,857,878,879,859,-1,855,880,878,857,-1,854,4798,880,855,-1,869,881,4813,4771,-1,865,882,881,869,-1,868,883,882,865,-1,864,884,885,861,-1,878,875,877,879,-1,880,873,875,878,-1,4798,4795,873,880,-1,881,872,871,4813,-1,882,874,872,881,-1,883,876,874,882,-1,884,886,887,885,-1,883,885,887,876,-1,868,861,885,883,-1,879,884,864,859,-1,877,886,884,879,-1,876,887,886,877,-1,4830,888,889,890,-1,890,889,891,892,-1,892,891,893,894,-1,895,896,897,898,-1,899,900,901,902,-1,902,901,903,904,-1,904,903,4831,905,-1,901,900,893,891,-1,891,889,903,901,-1,889,888,4831,903,-1,899,898,897,900,-1,900,897,896,893,-1,893,896,895,894,-1,4852,906,4854,4853,-1,906,907,908,4854,-1,907,909,910,908,-1,909,911,912,910,-1,894,913,914,892,-1,892,914,915,890,-1,890,915,4857,4830,-1,905,4872,916,904,-1,904,916,917,902,-1,902,917,918,899,-1,898,919,920,895,-1,913,911,909,914,-1,914,909,907,915,-1,915,907,906,4857,-1,4872,4854,908,916,-1,916,908,910,917,-1,917,910,912,918,-1,919,921,922,920,-1,912,921,919,918,-1,918,919,898,899,-1,894,895,920,913,-1,913,920,922,911,-1,911,922,921,912,-1,4889,923,924,925,-1,925,924,926,927,-1,927,926,928,929,-1,930,931,932,933,-1,934,935,936,937,-1,937,936};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_6()
		{
			int[] value = {938,939,-1,939,938,4890,940,-1,936,935,928,926,-1,926,924,938,936,-1,924,923,4890,938,-1,934,933,932,935,-1,935,932,931,928,-1,928,931,930,929,-1,941,942,943,4913,-1,942,944,945,943,-1,944,946,947,945,-1,929,948,949,927,-1,927,949,950,925,-1,925,950,4916,4889,-1,940,4931,951,939,-1,939,951,952,937,-1,937,952,953,934,-1,933,954,955,930,-1,948,946,944,949,-1,949,944,942,950,-1,950,942,941,4916,-1,4931,4913,943,951,-1,951,943,945,952,-1,952,945,947,953,-1,954,956,957,955,-1,947,956,954,953,-1,953,954,933,934,-1,929,930,955,948,-1,948,955,957,946,-1,946,957,956,947,-1,958,959,960,961,-1,964,963,965,966,-1,966,965,967,968,-1,968,967,969,970,-1,970,969,971,972,-1,972,971,973,974,-1,974,973,975,976,-1,976,975,4959,4960,-1,963,977,978,965,-1,965,978,979,967,-1,967,979,980,969,-1,969,980,981,971,-1,971,981,982,973,-1,973,982,983,975,-1,975,983,4979,4959,-1,982,981,980,979,-1,4979,983,978,977,-1,979,978,983,982,-1,4942,962,984,985,-1,961,960,985,984,-1,4960,4942,985,976,-1,976,985,960,974,-1,974,960,959,972,-1,972,959,958,970,-1,970,958,961,968,-1,968,961,984,966,-1,966,984,962,964,-1,986,987,988,989,-1,990,989,988,-1,987,986,991,-1,991,986,992,993,-1,993,992,994,995,-1,995,994,996,997,-1,997,996,998,999,-1,999,998,1000,1001,-1,1001,1000,1002,1003,-1,1003,1002,1004,1005,-1,1005,1004,1006,1007,-1,1007,1006,1008,1009,-1,1010,1011,1012,1013,-1,1014,1015,1016,1017,-1,1017,1016,1018,1019,-1,1019,1018,1020,1021,-1,1021,1020,1022,1023,-1,1023,1022,1024,1025,-1,1025,1024,1026,1027,-1,1027,1026,1028,1029,-1,1029,1028,1030,1031,-1,1031,1030,989,990,-1,989,1030,992,986,-1,1028,1026,996,994,-1,1026,1024,998,996,-1,1016,1015,1008,1006,-1,1006,1004,1018,1016,-1,1004,1002,1020,1018,-1,1024,1022,1000,998,-1,1022,1020,1002,1000,-1,1030,1028,994,992,-1,1014,1013,1012,1015,-1,1015,1012,1011,1008,-1,1008,1011,1010,1009,-1,1032,1033,1034,1035,-1,1033,1036,1037,1034,-1,1036,1038,1039,1037,-1,1038,1040,1041,1039,-1,1040,1042,1043,1041,-1,1042,1044,1045,1043,-1,1044,1046,1047,1045,-1,1046,1048,1049,1047,-1,1048,1050,1051,1049,-1,1035,1052,1053,1032,-1,1009,1054,1055,1007,-1,1007,1055,1056,1005,-1,1005,1056,1057,1003,-1,1003,1057,1058,1001,-1,1001,1058,1059,999,-1,999,1059,1060,997,-1,997,1060,1061,995,-1,995,1061,1062,993,-1,993,1062,1063,991,-1,991,1063,1064,987,-1,987,1064,1065,988,-1,988,1065,1066,990,-1,990,1066,1067,1031,-1,1031,1067,1068,1029,-1,1029,1068,1069,1027,-1,1027,1069,1070,1025,-1,1025,1070,1071,1023,-1,1023,1071,1072,1021,-1,1021,1072,1073,1019,-1,1019,1073,1074,1017,-1,1017,1074,1075,1014,-1,1013,1076,1077,1010,-1,1054,1050,1048,1055,-1,1055,1048,1046,1056,-1,1056,1046,1044,1057,-1,1057,1044,1042,1058,-1,1058,1042,1040,1059,-1,1059,1040,1038,1060,-1,1060,1038,1036,1061,-1,1061,1036,1033,1062,-1,1062,1033,1032,1063,-1,1063,1032,1053,1064,-1,1064,1053,1052,1065,-1,1065,1052,1035,1066,-1,1066,1035,1034,1067,-1,1067,1034,1037,1068,-1,1068,1037,1039,1069,-1,1069,1039,1041,1070,-1,1070,1041,1043,1071,-1,1071,1043,1045,1072,-1,1072,1045,1047,1073,-1,1073,1047,1049,1074,-1,1074,1049,1051,1075,-1,1076,1078,1079,1077,-1,1051,1078,1076,1075,-1,1075,1076,1013,1014,-1,1009,1010,1077,1054,-1,1054,1077,1079,1050,-1,1050,1079,1078,1051,-1,1080,1081,1082,1083,-1,1084,1083,1082,-1,1081,1080,1085,-1,1085,1080,1086,1087,-1,1087,1086,1088,1089,-1,1089,1088,1090,1091,-1,1091,1090,1092,1093,-1,1093,1092,1094,1095,-1,1095,1094,1096,1097,-1,1097,1096,1098,1099,-1,1099,1098,1100,1101,-1,1101,1100,1102,1103,-1,1104,1105,1106,1107,-1,1108,1109,1110,1111,-1,1111,1110,1112,1113,-1,1113,1112,1114,1115,-1,1115,1114,1116,1117,-1,1117,1116,1118,1119,-1,1119,1118,1120,1121,-1,1121,1120,1122,1123,-1,1123,1122,1124,1125,-1,1125,1124,1083,1084,-1,1083,1124,1086,1080,-1,1122,1120,1090,1088,-1,1120,1118,1092,1090,-1,1110,1109,1102,1100,-1,1100,1098,1112,1110,-1,1098,1096,1114,1112,-1,1118,1116,1094,1092,-1,1116,1114,1096,1094,-1,1124,1122,1088,1086,-1,1108,1107,1106,1109,-1,1109,1106,1105,1102,-1,1102,1105,1104,1103,-1,1126,1127,1128,1129,-1,1127,1130,1131,1128,-1,1130,1132,1133,1131,-1,1132,1134,1135,1133,-1,1134,1136,1137,1135,-1,1136,1138,1139,1137,-1,1138,1140,1141,1139,-1,1140,1142,1143,1141,-1,1142,1144,1145,1143,-1,1129,1146,1147,1126,-1,1103,1148,1149,1101,-1,1101,1149,1150,1099,-1,1099,1150,1151,1097,-1,1097,1151,1152,1095,-1,1095,1152,1153,1093,-1,1093,1153,1154,1091,-1,1091,1154,1155,1089,-1,1089};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_7()
		{
			int[] value = {1155,1156,1087,-1,1087,1156,1157,1085,-1,1085,1157,1158,1081,-1,1081,1158,1159,1082,-1,1082,1159,1160,1084,-1,1084,1160,1161,1125,-1,1125,1161,1162,1123,-1,1123,1162,1163,1121,-1,1121,1163,1164,1119,-1,1119,1164,1165,1117,-1,1117,1165,1166,1115,-1,1115,1166,1167,1113,-1,1113,1167,1168,1111,-1,1111,1168,1169,1108,-1,1107,1170,1171,1104,-1,1148,1144,1142,1149,-1,1149,1142,1140,1150,-1,1150,1140,1138,1151,-1,1151,1138,1136,1152,-1,1152,1136,1134,1153,-1,1153,1134,1132,1154,-1,1154,1132,1130,1155,-1,1155,1130,1127,1156,-1,1156,1127,1126,1157,-1,1157,1126,1147,1158,-1,1158,1147,1146,1159,-1,1159,1146,1129,1160,-1,1160,1129,1128,1161,-1,1161,1128,1131,1162,-1,1162,1131,1133,1163,-1,1163,1133,1135,1164,-1,1164,1135,1137,1165,-1,1165,1137,1139,1166,-1,1166,1139,1141,1167,-1,1167,1141,1143,1168,-1,1168,1143,1145,1169,-1,1170,1172,1173,1171,-1,1145,1172,1170,1169,-1,1169,1170,1107,1108,-1,1103,1104,1171,1148,-1,1148,1171,1173,1144,-1,1144,1173,1172,1145,-1,1174,1175,1176,1177,-1,1178,1179,1180,1181,-1,1182,1183,1184,1185,-1,1186,1187,1188,1189,-1,1190,1191,1192,1193,-1,1193,1192,1194,1195,-1,1195,1194,1196,1197,-1,1197,1196,1198,1199,-1,1199,1198,1200,1201,-1,1201,1200,1202,1203,-1,1203,1202,1204,1205,-1,1205,1204,1206,1207,-1,1207,1206,1208,1209,-1,1209,1208,1210,1211,-1,1211,1210,1212,1213,-1,1213,1212,1214,1215,-1,1215,1214,1216,1217,-1,1217,1216,1218,1219,-1,1219,1218,1220,1221,-1,1221,1220,1222,1223,-1,1223,1222,1224,1225,-1,1225,1224,1226,1227,-1,1227,1226,1228,1229,-1,1229,1228,1230,1231,-1,1231,1230,1232,1233,-1,1233,1232,1191,1190,-1,1191,1234,1235,1192,-1,1192,1235,1236,1194,-1,1194,1236,1237,1196,-1,1196,1237,1238,1198,-1,1198,1238,1239,1200,-1,1200,1239,1177,1202,-1,1202,1177,1176,1204,-1,1204,1176,1240,1206,-1,1206,1240,1241,1208,-1,1208,1241,1242,1210,-1,1210,1242,1243,1212,-1,1212,1243,1244,1214,-1,1214,1244,1245,1216,-1,1216,1245,1246,1218,-1,1218,1246,1247,1220,-1,1220,1247,1175,1222,-1,1222,1175,1174,1224,-1,1224,1174,1248,1226,-1,1226,1248,1249,1228,-1,1228,1249,1250,1230,-1,1230,1250,1251,1232,-1,1232,1251,1234,1191,-1,1245,1244,1243,1242,-1,1247,1246,1241,1240,-1,1242,1241,1246,1245,-1,1175,1247,1240,1176,-1,1239,1238,1249,1248,-1,1248,1174,1177,1239,-1,1237,1236,1251,1250,-1,1250,1249,1238,1237,-1,1236,1235,1234,1251,-1,1189,1188,1252,1253,-1,1185,1184,1253,1252,-1,1181,1180,1254,1255,-1,1187,1186,1255,1254,-1,1256,1257,1258,1259,-1,1179,1178,1259,1258,-1,1260,1261,1257,1256,-1,1193,1261,1260,1190,-1,1190,1260,1256,1233,-1,1233,1256,1259,1231,-1,1231,1259,1178,1229,-1,1229,1178,1181,1227,-1,1227,1181,1255,1225,-1,1225,1255,1186,1223,-1,1223,1186,1189,1221,-1,1221,1189,1253,1219,-1,1219,1253,1184,1217,-1,1217,1184,1183,1215,-1,1215,1183,1182,1213,-1,1213,1182,1185,1211,-1,1211,1185,1252,1209,-1,1209,1252,1188,1207,-1,1207,1188,1187,1205,-1,1205,1187,1254,1203,-1,1203,1254,1180,1201,-1,1201,1180,1179,1199,-1,1199,1179,1258,1197,-1,1197,1258,1257,1195,-1,1195,1257,1261,1193,-1,5047,1264,5048,1265,-1,1262,1266,1267,4999,-1,1263,1268,1266,1262,-1,5045,5049,1269,5046,-1,1264,1270,5048,-1,1266,1271,1272,1267,-1,1268,1273,1271,1266,-1,5047,5063,1274,1264,-1,1264,1274,1275,1270,-1,1270,5068,5069,5048,-1,1275,5070,5068,1270,-1,1271,5071,1276,1272,-1,1273,5072,5071,1271,-1,5084,5068,5070,5085,-1,5098,1278,1274,5063,-1,4999,1267,1278,5098,-1,1278,1279,1275,1274,-1,1267,1272,1279,1278,-1,1279,5099,5070,1275,-1,1272,1276,5099,1279,-1,1280,5112,5072,1273,-1,1269,1277,5112,1280,-1,5113,1280,1273,1268,-1,5046,1269,1280,5113,-1,5114,5113,1268,1263,-1,5137,5047,1265,5138,-1,1281,1282,1283,-1,5244,5245,1284,1285,-1,1286,1287,1288,1289,-1,1290,1291,1292,1293,-1,1294,1295,1296,1297,-1,1298,1299,1300,1301,-1,1302,1303,1304,1305,-1,1306,1307,1308,1309,-1,1310,1304,1311,-1,1312,1300,1313,-1,1295,1292,1314,-1,1315,1316,1317,-1,1318,1319,1320,-1,526,1321,524,-1,1322,1323,1324,1325,-1,1326,1327,1328,1329,-1,1330,5250,5251,1331,-1,1307,524,1308,-1,1332,1311,524,1307,-1,1306,1333,1332,1307,-1,1310,1311,1332,-1,1333,1334,1310,1332,-1,1303,1311,1304,-1,1304,1310,1334,1305,-1,1313,1311,1303,1312,-1,1312,1303,1302,1335,-1,1299,1313,1300,-1,1300,1312,1335,1301,-1,1299,1296,1313,-1,1295,1314,1313,1296,-1,1296,1299,1298,1297,-1,1291,1314,1292,-1,1292,1295,1294,1293,-1,1336,1317,1314,1291,-1,1290,1337,1336,1291,-1,1338,1317,1336,-1,1337,1339,1338,1336,-1,1338,1340,1317,-1,1340,1338,1339,1341,-1,1342,1317,1340,-1,1340,1341,1343,1342,-1,1315,1317,1342,-1,1343,1328,1315,1342,-1,1316,1288,1344,1317,-1,1316,1315,1328,1327,-1,1287,1344,1288,-1,1288,1316,1327,1289,-1,1287,1345,1344,-1,1345,1287,1286,1346,-1,1318,1320,1344,1345,-1,1345};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_8()
		{
			int[] value = {1346,1330,1318,-1,1319,1347,5252,1320,-1,1319,1318,1330,1331,-1,1347,1284,5252,-1,1347,1319,1331,1348,-1,5245,5252,1284,-1,1284,1347,1348,1285,-1,1321,1308,524,-1,1321,526,557,1349,-1,1308,1321,1349,1309,-1,1350,1351,5264,5265,-1,1352,1353,1354,1355,-1,1341,1356,1357,1343,-1,1358,1359,5272,5273,-1,1360,1361,5284,5285,-1,1362,1363,5283,5282,-1,1364,1365,5278,5237,-1,1366,1365,1364,-1,1363,1362,1367,-1,1322,1368,1367,-1,1369,1370,1325,1324,-1,1371,1372,1305,1334,-1,1372,1371,1373,1374,-1,1282,1281,1374,1373,-1,1375,1376,1377,1378,-1,1293,1294,1379,1380,-1,1380,1379,1381,1382,-1,1382,1381,1376,1375,-1,1343,1357,1329,1328,-1,1339,1383,1356,1341,-1,5308,5309,1384,1385,-1,1385,1384,1386,-1,1387,1388,1389,1390,-1,1390,1389,1326,1329,-1,1327,1326,1391,1289,-1,1392,1393,1394,1395,-1,1289,1391,1396,1286,-1,1331,5251,1397,1348,-1,1398,1393,1392,-1,1348,1397,1399,1285,-1,1285,1399,5312,5244,-1,1346,1400,5250,1330,-1,1286,1396,1400,1346,-1,1401,1402,1403,1352,-1,1404,1405,5313,5314,-1,1395,1394,5315,5316,-1,1349,557,614,1406,-1,1406,614,616,1407,-1,1407,616,618,1408,-1,1409,619,4375,5321,-1,622,1410,1408,618,-1,619,1409,1410,622,-1,1394,1411,5328,5315,-1,1411,1404,5314,5328,-1,1405,1412,5329,5313,-1,1413,1402,1404,1411,-1,1402,1401,1405,1404,-1,1401,1414,1412,1405,-1,1414,1401,1352,1355,-1,1402,1413,1403,-1,1411,1415,1413,-1,1416,1413,1415,1417,-1,1403,1413,1416,1418,-1,1419,1418,1420,1421,-1,1422,1420,1418,1416,-1,1422,1400,1396,1420,-1,1422,1416,1417,5310,-1,1422,5310,5250,1400,-1,1399,1392,5327,5312,-1,1397,1398,1392,1399,-1,1417,1415,1393,1398,-1,5311,5310,1417,1398,-1,1420,1396,1391,1421,-1,1392,1395,5327,-1,1415,1411,1394,1393,-1,1385,1423,5332,5308,-1,1386,1424,1423,1385,-1,1386,1387,1425,1424,-1,1390,1426,1425,1387,-1,1426,1390,1329,-1,1421,1391,1326,1389,-1,1388,1419,1421,1389,-1,1388,1353,1352,1419,-1,1355,1354,1427,1414,-1,1412,1414,1427,1428,-1,5309,5333,1428,1384,-1,5329,1412,1428,5333,-1,1429,5344,1423,-1,5345,5344,1429,1430,-1,1431,1432,1433,1434,-1,1358,1434,1433,1378,-1,1435,1436,1437,1438,-1,1375,1437,1436,1382,-1,1439,1440,1436,1435,-1,1382,1436,1440,1380,-1,1290,1293,1380,1440,-1,1383,1339,1337,1290,-1,1383,1439,1441,1356,-1,1435,1438,1442,1441,-1,1443,1442,1438,1432,-1,1431,1444,1443,1432,-1,1445,1443,1444,1446,-1,1447,1442,1443,1445,-1,1448,1441,1442,1447,-1,1426,1329,1357,1448,-1,1448,1447,1425,1426,-1,1447,1445,1424,1425,-1,1445,1429,1423,1424,-1,1429,1445,1430,-1,1430,1445,1446,-1,5345,1430,1446,5348,-1,5349,5348,1446,1444,-1,5296,5349,1444,1431,-1,1433,1437,1375,1378,-1,1432,1438,1437,1433,-1,5357,1449,1364,5237,-1,1434,1358,5273,-1,1450,1451,1449,1359,-1,1364,1449,1451,1366,-1,1452,1324,1323,1453,-1,1452,1454,1455,1324,-1,1455,1369,1324,-1,1369,1455,1298,1301,-1,1381,1452,1453,1376,-1,1379,1454,1452,1381,-1,1294,1297,1454,1379,-1,1376,1453,1450,1377,-1,1358,1378,1377,-1,1366,1451,1323,-1,1450,1453,1323,1451,-1,1306,1309,1456,1457,-1,1456,1309,1349,1406,-1,1458,1456,1406,1407,-1,1458,1459,1457,1456,-1,1460,1461,1459,1458,-1,1408,1460,1458,1407,-1,1462,1463,1464,1465,-1,5321,5359,1465,1409,-1,5265,5365,1466,1350,-1,1283,1467,1351,1350,-1,1468,1467,1283,1282,-1,1373,1469,1468,1282,-1,1281,1470,1471,1374,-1,1371,1472,1469,1373,-1,1472,1457,1459,1469,-1,1333,1306,1457,1472,-1,1334,1333,1472,1371,-1,1302,1305,1372,1473,-1,1370,1335,1302,1473,-1,1370,1473,1471,1325,-1,1370,1369,1301,1335,-1,1322,1325,1471,1470,-1,1367,1366,1323,1322,-1,1322,1470,1474,1368,-1,1361,1368,1474,1466,-1,1367,1368,1360,1363,-1,1366,1367,1362,1365,-1,5282,5278,1365,1362,-1,5285,5283,1363,1360,-1,1361,1466,5365,5284,-1,1473,1372,1374,1471,-1,5273,5296,1431,1434,-1,5272,1359,1449,5357,-1,1469,1459,1461,1468,-1,1461,1463,1467,1468,-1,1356,1441,1448,1357,-1,1353,1386,1427,1354,-1,1386,1384,1428,1427,-1,5359,5368,1462,1465,-1,1351,1462,5368,5264,-1,1467,1463,1462,1351,-1,1410,1464,1460,1408,-1,1409,1465,1464,1410,-1,1463,1461,1460,1464,-1,1454,1297,1298,1455,-1,1283,1474,1470,1281,-1,1350,1466,1474,1283,-1,1386,1353,1388,1387,-1,1377,1450,1359,1358,-1,1418,1419,1352,1403,-1,1383,1290,1440,1439,-1,1439,1435,1441,-1,1368,1361,1360,-1,1475,1476,1477,1478,-1,1481,1480,1482,1483,-1,1483,1482,1484,1485,-1,1485,1484,1486,1487,-1,1487,1486,1488,1489,-1,1489,1488,1490,1491,-1,1491,1490,1492,1493,-1,1493,1492,5397,5398,-1,1480,1494,1495,1482,-1,1482,1495,1496,1484,-1,1484,1496,1497,1486,-1,1486,1497,1498,1488,-1,1488,1498,1499,1490,-1,1490,1499,1500,1492,-1,1492,1500,5417,5397,-1,1499,1498,1497,1496,-1,5417,1500,1495,1494,-1,1496,1495,1500,1499,-1,5380,1479,1501,1502,-1,1478,1477,1502,1501,-1,5398,5380,1502,1493,-1,1493,1502};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_9()
		{
			int[] value = {1477,1491,-1,1491,1477,1476,1489,-1,1489,1476,1475,1487,-1,1487,1475,1478,1485,-1,1485,1478,1501,1483,-1,1483,1501,1479,1481,-1,1503,1509,1510,5478,-1,1504,1511,1509,1503,-1,1505,1512,1511,1504,-1,1506,1513,1512,1505,-1,1507,1514,1513,1506,-1,1508,1515,1516,5479,-1,1509,1517,1518,1510,-1,1511,1519,1517,1509,-1,1512,1520,1519,1511,-1,1513,1521,1520,1512,-1,1514,1522,1521,1513,-1,1515,1523,1524,1516,-1,1517,1525,1526,1518,-1,1519,1527,1525,1517,-1,1520,1528,1527,1519,-1,1521,1529,1528,1520,-1,1522,1530,1529,1521,-1,1523,1531,1532,1524,-1,1525,1527,1528,1529,-1,1526,1533,1534,1518,-1,1518,1534,5484,1510,-1,1510,5484,5485,5478,-1,5506,1535,1536,1537,-1,1537,1536,1538,1539,-1,1539,1538,1540,1530,-1,1530,1540,1533,1526,-1,1533,1541,1542,1534,-1,1534,1542,5507,5484,-1,1535,1543,1544,1536,-1,1536,1544,1545,1538,-1,1538,1545,1546,1540,-1,1540,1546,1541,1533,-1,1543,5533,1547,1544,-1,1544,1547,1548,1545,-1,1545,1548,1549,1546,-1,1546,1549,1550,1541,-1,1541,1550,1551,1542,-1,1542,1551,5534,5507,-1,5533,5479,1516,1547,-1,1547,1516,1524,1548,-1,1548,1524,1532,1549,-1,1549,1532,1531,1550,-1,1550,1531,1523,1551,-1,1551,1523,1515,5534,-1,5534,1515,1508,5535,-1,1529,1530,1526,1525,-1,1514,1507,5550,1552,-1,1552,5550,5506,1537,-1,1522,1514,1552,1553,-1,1553,1552,1537,1539,-1,1530,1522,1553,-1,1553,1539,1530,-1,5567,1554,1555,1556,-1,1556,1555,1557,1558,-1,1558,1557,1559,1560,-1,1561,1562,1563,1564,-1,1565,1566,1567,1568,-1,1568,1567,1569,1570,-1,1570,1569,5568,1571,-1,1567,1566,1559,1557,-1,1557,1555,1569,1567,-1,1555,1554,5568,1569,-1,1565,1564,1563,1566,-1,1566,1563,1562,1559,-1,1559,1562,1561,1560,-1,1572,1573,1574,5591,-1,1573,1575,1576,1574,-1,1575,1577,1578,1576,-1,1560,1579,1580,1558,-1,1558,1580,1581,1556,-1,1556,1581,5594,5567,-1,1571,5609,1582,1570,-1,1570,1582,1583,1568,-1,1568,1583,1584,1565,-1,1564,1585,1586,1561,-1,1579,1577,1575,1580,-1,1580,1575,1573,1581,-1,1581,1573,1572,5594,-1,5609,5591,1574,1582,-1,1582,1574,1576,1583,-1,1583,1576,1578,1584,-1,1585,1587,1588,1586,-1,1578,1587,1585,1584,-1,1584,1585,1564,1565,-1,1560,1561,1586,1579,-1,1579,1586,1588,1577,-1,1577,1588,1587,1578,-1,1590,1591,5626,5625,-1,1592,1593,1591,1590,-1,1594,1595,1593,1592,-1,1596,1597,1598,1599,-1,1600,1601,1602,1603,-1,1604,1605,1601,1600,-1,5627,5628,1605,1604,-1,1593,1595,1602,1601,-1,1601,1605,1591,1593,-1,1605,5628,5626,1591,-1,1602,1597,1596,1603,-1,1595,1598,1597,1602,-1,1594,1599,1598,1595,-1,5645,1606,5647,5646,-1,1606,1607,1608,5647,-1,1607,1609,1610,1608,-1,1609,1611,1612,1610,-1,1611,1613,1614,1612,-1,1613,1615,1616,1614,-1,1592,1617,1618,1594,-1,1590,1619,1617,1592,-1,5625,1620,1619,1590,-1,1589,1621,1620,5625,-1,5629,1622,5661,5631,-1,5627,1623,1622,5629,-1,1604,1624,1623,5627,-1,1600,1625,1624,1604,-1,1603,1626,1625,1600,-1,1599,1627,1628,1596,-1,1617,1614,1616,1618,-1,1619,1612,1614,1617,-1,1620,1610,1612,1619,-1,1621,1608,1610,1620,-1,5650,5647,1608,1621,-1,1622,1607,1606,5661,-1,1623,1609,1607,1622,-1,1624,1611,1609,1623,-1,1625,1613,1611,1624,-1,1626,1615,1613,1625,-1,1627,1629,1630,1628,-1,1626,1628,1630,1615,-1,1603,1596,1628,1626,-1,1618,1627,1599,1594,-1,1616,1629,1627,1618,-1,1615,1630,1629,1616,-1,1632,1633,5678,1631,-1,1634,1635,1633,1632,-1,1636,1637,1635,1634,-1,1638,1639,1640,1641,-1,1642,1643,1644,1645,-1,1646,1647,1643,1642,-1,5679,5680,1647,1646,-1,1635,1637,1644,1643,-1,1643,1647,1633,1635,-1,1647,5680,5678,1633,-1,1644,1639,1638,1645,-1,1637,1640,1639,1644,-1,1636,1641,1640,1637,-1,5699,5701,5702,5700,-1,5704,1649,1650,5705,-1,1649,1651,1652,1650,-1,1634,1653,1654,1636,-1,1632,5708,1653,1634,-1,1631,5709,5708,1632,-1,1646,1655,5724,5679,-1,1642,1656,1655,1646,-1,1645,1657,1656,1642,-1,1641,1658,1659,1638,-1,1653,1650,1652,1654,-1,5708,5705,1650,1653,-1,1655,5704,1648,5724,-1,1656,1649,5704,1655,-1,1657,1651,1649,1656,-1,1658,1660,1661,1659,-1,1657,1659,1661,1651,-1,1645,1638,1659,1657,-1,1654,1658,1641,1636,-1,1652,1660,1658,1654,-1,1651,1661,1660,1652,-1,1662,1663,1664,1665,-1,1667,1668,5753,5752,-1,1669,1670,1668,1667,-1,1671,1672,1670,1669,-1,1673,1674,1672,1671,-1,1675,1676,1674,1673,-1,1677,1678,1676,1675,-1,5754,1679,1678,1677,-1,1668,1680,5773,5753,-1,1670,1681,1680,1668,-1,1672,1682,1681,1670,-1,1674,1683,1682,1672,-1,1676,1684,1683,1674,-1,1678,1685,1684,1676,-1,1679,1686,1685,1678,-1,1681,1682,1683,1684,-1,5773,1680,1685,1686,-1,1684,1685,1680,1681,-1,1687,1688,5733,1666,-1,1688,1687,1663,1662,-1,1677,1687,1666,5754,-1,1675,1663,1687,1677,-1,1673,1664,1663,1675,-1,1671,1665,1664,1673,-1,1669,1662,1665,1671,-1,1667,1688,1662,1669,-1,5752,5733,1688,1667,-1,1689,1690,1691,1692,-1,1690,1689,1693,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_10()
		{
			int[] value = {1694,1692,1691,-1,1695,1696,1692,1694,-1,1697,1698,1696,1695,-1,1699,1700,1698,1697,-1,1701,1702,1700,1699,-1,1703,1704,1702,1701,-1,1705,1706,1704,1703,-1,1707,1708,1706,1705,-1,1709,1710,1708,1707,-1,1711,1712,1710,1709,-1,1713,1714,1715,1716,-1,1717,1718,1719,1720,-1,1721,1722,1718,1717,-1,1723,1724,1722,1721,-1,1725,1726,1724,1723,-1,1727,1728,1726,1725,-1,1729,1730,1728,1727,-1,1731,1732,1730,1729,-1,1733,1734,1732,1731,-1,1693,1689,1734,1733,-1,1692,1696,1734,1689,-1,1698,1700,1730,1732,-1,1700,1702,1728,1730,-1,1710,1712,1719,1718,-1,1718,1722,1708,1710,-1,1722,1724,1706,1708,-1,1702,1704,1726,1728,-1,1704,1706,1724,1726,-1,1696,1698,1732,1734,-1,1719,1714,1713,1720,-1,1712,1715,1714,1719,-1,1711,1716,1715,1712,-1,1735,1736,1737,1738,-1,1736,1739,1740,1737,-1,1739,1741,1742,1740,-1,1741,1743,1744,1742,-1,1743,1745,1746,1744,-1,1745,1747,1748,1746,-1,1747,1749,1750,1748,-1,1749,1751,1752,1750,-1,1751,1753,1754,1752,-1,1738,1755,1756,1735,-1,1709,1757,1758,1711,-1,1707,1759,1757,1709,-1,1705,1760,1759,1707,-1,1703,1761,1760,1705,-1,1701,1762,1761,1703,-1,1699,1763,1762,1701,-1,1697,1764,1763,1699,-1,1695,1765,1764,1697,-1,1694,1766,1765,1695,-1,1691,1767,1766,1694,-1,1690,1768,1767,1691,-1,1693,1769,1768,1690,-1,1733,1770,1769,1693,-1,1731,1771,1770,1733,-1,1729,1772,1771,1731,-1,1727,1773,1772,1729,-1,1725,1774,1773,1727,-1,1723,1775,1774,1725,-1,1721,1776,1775,1723,-1,1717,1777,1776,1721,-1,1720,1778,1777,1717,-1,1716,1779,1780,1713,-1,1757,1752,1754,1758,-1,1759,1750,1752,1757,-1,1760,1748,1750,1759,-1,1761,1746,1748,1760,-1,1762,1744,1746,1761,-1,1763,1742,1744,1762,-1,1764,1740,1742,1763,-1,1765,1737,1740,1764,-1,1766,1738,1737,1765,-1,1767,1755,1738,1766,-1,1768,1756,1755,1767,-1,1769,1735,1756,1768,-1,1770,1736,1735,1769,-1,1771,1739,1736,1770,-1,1772,1741,1739,1771,-1,1773,1743,1741,1772,-1,1774,1745,1743,1773,-1,1775,1747,1745,1774,-1,1776,1749,1747,1775,-1,1777,1751,1749,1776,-1,1778,1753,1751,1777,-1,1779,1781,1782,1780,-1,1778,1780,1782,1753,-1,1720,1713,1780,1778,-1,1758,1779,1716,1711,-1,1754,1781,1779,1758,-1,1753,1782,1781,1754,-1,1783,1784,1785,1786,-1,1784,1783,1787,-1,1788,1786,1785,-1,1789,1790,1786,1788,-1,1791,1792,1790,1789,-1,1793,1794,1792,1791,-1,1795,1796,1794,1793,-1,1797,1798,1796,1795,-1,1799,1800,1798,1797,-1,1801,1802,1800,1799,-1,1803,1804,1802,1801,-1,1805,1806,1804,1803,-1,1807,1808,1809,1810,-1,1811,1812,1813,1814,-1,1815,1816,1812,1811,-1,1817,1818,1816,1815,-1,1819,1820,1818,1817,-1,1821,1822,1820,1819,-1,1823,1824,1822,1821,-1,1825,1826,1824,1823,-1,1827,1828,1826,1825,-1,1787,1783,1828,1827,-1,1786,1790,1828,1783,-1,1792,1794,1824,1826,-1,1794,1796,1822,1824,-1,1804,1806,1813,1812,-1,1812,1816,1802,1804,-1,1816,1818,1800,1802,-1,1796,1798,1820,1822,-1,1798,1800,1818,1820,-1,1790,1792,1826,1828,-1,1813,1808,1807,1814,-1,1806,1809,1808,1813,-1,1805,1810,1809,1806,-1,1829,1830,1831,1832,-1,1830,1833,1834,1831,-1,1833,1835,1836,1834,-1,1835,1837,1838,1836,-1,1837,1839,1840,1838,-1,1839,1841,1842,1840,-1,1841,1843,1844,1842,-1,1843,1845,1846,1844,-1,1845,1847,1848,1846,-1,1832,1849,1850,1829,-1,1803,1851,1852,1805,-1,1801,1853,1851,1803,-1,1799,1854,1853,1801,-1,1797,1855,1854,1799,-1,1795,1856,1855,1797,-1,1793,1857,1856,1795,-1,1791,1858,1857,1793,-1,1789,1859,1858,1791,-1,1788,1860,1859,1789,-1,1785,1861,1860,1788,-1,1784,1862,1861,1785,-1,1787,1863,1862,1784,-1,1827,1864,1863,1787,-1,1825,1865,1864,1827,-1,1823,1866,1865,1825,-1,1821,1867,1866,1823,-1,1819,1868,1867,1821,-1,1817,1869,1868,1819,-1,1815,1870,1869,1817,-1,1811,1871,1870,1815,-1,1814,1872,1871,1811,-1,1810,1873,1874,1807,-1,1851,1846,1848,1852,-1,1853,1844,1846,1851,-1,1854,1842,1844,1853,-1,1855,1840,1842,1854,-1,1856,1838,1840,1855,-1,1857,1836,1838,1856,-1,1858,1834,1836,1857,-1,1859,1831,1834,1858,-1,1860,1832,1831,1859,-1,1861,1849,1832,1860,-1,1862,1850,1849,1861,-1,1863,1829,1850,1862,-1,1864,1830,1829,1863,-1,1865,1833,1830,1864,-1,1866,1835,1833,1865,-1,1867,1837,1835,1866,-1,1868,1839,1837,1867,-1,1869,1841,1839,1868,-1,1870,1843,1841,1869,-1,1871,1845,1843,1870,-1,1872,1847,1845,1871,-1,1873,1875,1876,1874,-1,1872,1874,1876,1847,-1,1814,1807,1874,1872,-1,1852,1873,1810,1805,-1,1848,1875,1873,1852,-1,1847,1876,1875,1848,-1,1877,1878,1879,1880,-1,1881,1882,1883,1884,-1,1885,1886,1887,1888,-1,1889,1890,1891,1892,-1,1893,1894,1895,1896,-1,1897,1898,1894,1893,-1,1899,1900,1898,1897,-1,1901,1902,1900,1899,-1,1903,1904,1902,1901,-1,1905,1906,1904,1903,-1,1907,1908,1906,1905,-1,1909,1910,1908,1907,-1,1911,1912,1910,1909,-1,1913,1914,1912,1911,-1,1915,1916,1914,1913,-1,1917,1918,1916,1915,-1,1919,1920,1918};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_11()
		{
			int[] value = {1917,-1,1921,1922,1920,1919,-1,1923,1924,1922,1921,-1,1925,1926,1924,1923,-1,1927,1928,1926,1925,-1,1929,1930,1928,1927,-1,1931,1932,1930,1929,-1,1933,1934,1932,1931,-1,1935,1936,1934,1933,-1,1896,1895,1936,1935,-1,1894,1937,1938,1895,-1,1898,1939,1937,1894,-1,1900,1940,1939,1898,-1,1902,1941,1940,1900,-1,1904,1942,1941,1902,-1,1906,1877,1942,1904,-1,1908,1878,1877,1906,-1,1910,1943,1878,1908,-1,1912,1944,1943,1910,-1,1914,1945,1944,1912,-1,1916,1946,1945,1914,-1,1918,1947,1946,1916,-1,1920,1948,1947,1918,-1,1922,1949,1948,1920,-1,1924,1950,1949,1922,-1,1926,1879,1950,1924,-1,1928,1880,1879,1926,-1,1930,1951,1880,1928,-1,1932,1952,1951,1930,-1,1934,1953,1952,1932,-1,1936,1954,1953,1934,-1,1895,1938,1954,1936,-1,1945,1946,1947,1948,-1,1943,1944,1949,1950,-1,1948,1949,1944,1945,-1,1878,1943,1950,1879,-1,1951,1952,1941,1942,-1,1942,1877,1880,1951,-1,1953,1954,1939,1940,-1,1940,1941,1952,1953,-1,1954,1938,1937,1939,-1,1955,1956,1890,1889,-1,1956,1955,1886,1885,-1,1957,1958,1882,1881,-1,1958,1957,1892,1891,-1,1959,1960,1961,1962,-1,1960,1959,1884,1883,-1,1962,1961,1963,1964,-1,1896,1964,1963,1893,-1,1935,1962,1964,1896,-1,1933,1959,1962,1935,-1,1931,1884,1959,1933,-1,1929,1881,1884,1931,-1,1927,1957,1881,1929,-1,1925,1892,1957,1927,-1,1923,1889,1892,1925,-1,1921,1955,1889,1923,-1,1919,1886,1955,1921,-1,1917,1887,1886,1919,-1,1915,1888,1887,1917,-1,1913,1885,1888,1915,-1,1911,1956,1885,1913,-1,1909,1890,1956,1911,-1,1907,1891,1890,1909,-1,1905,1958,1891,1907,-1,1903,1882,1958,1905,-1,1901,1883,1882,1903,-1,1899,1960,1883,1901,-1,1897,1961,1960,1899,-1,1893,1963,1961,1897,-1,692,1967,1968,689,-1,5788,1969,1970,1971,-1,1972,1965,5787,5789,-1,1973,1974,1975,1976,-1,5790,1977,1978,1979,-1,1974,1980,1981,1975,-1,1977,1982,1983,1978,-1,1984,1982,1977,5791,-1,1980,1985,1986,1981,-1,1982,1987,1988,1983,-1,1984,1989,1987,1982,-1,1985,1971,1970,1986,-1,1987,1965,1972,1988,-1,1989,1966,1965,1987,-1,5794,5786,1966,1989,-1,4449,689,1968,5795,-1,5797,1990,1991,-1,5795,1968,1992,5798,-1,1968,1967,1993,1992,-1,1994,5800,5788,1971,-1,1972,5789,5800,1994,-1,1995,1994,1971,1985,-1,1988,1972,1994,1995,-1,1996,1995,1985,1980,-1,1983,1988,1995,1996,-1,1997,1996,1980,1974,-1,1978,1983,1996,1997,-1,1998,1997,1974,1973,-1,1979,1978,1997,1998,-1,1999,4459,2000,-1,1999,2001,4459,-1,2002,2003,2004,2005,-1,2003,2006,2007,2004,-1,2008,2009,2004,2007,-1,2005,2004,2009,2010,-1,2011,2010,2009,2012,-1,5811,2012,2009,2008,-1,2013,2014,2000,4459,-1,2015,2014,2013,2016,-1,1967,692,726,2017,-1,2017,726,728,2018,-1,1973,1976,5834,5797,-1,1990,5835,5790,1979,-1,1976,1975,2019,2020,-1,2021,1970,2022,-1,2022,1970,2023,-1,2023,1970,1969,2024,-1,2024,2026,2027,2023,-1,2023,2027,2028,2022,-1,2022,2028,2029,2021,-1,2020,2019,2030,2031,-1,2001,2032,740,739,-1,2014,2033,2034,2000,-1,2015,2035,2033,2014,-1,2032,2036,745,740,-1,2033,2037,2038,2034,-1,2035,2039,2037,2033,-1,2019,2040,2041,2030,-1,1975,1981,2040,2019,-1,2001,739,4459,-1,2031,5876,5877,2020,-1,2020,5877,5834,1976,-1,1981,1986,2042,2040,-1,2036,2044,755,745,-1,2037,2045,2046,2038,-1,2039,2047,2045,2037,-1,2040,2042,2048,2041,-1,1986,1970,2021,2042,-1,5886,2011,2012,2043,-1,2044,2018,728,755,-1,2045,2003,2002,2046,-1,2047,2006,2003,2045,-1,2042,2021,2029,2048,-1,2049,2050,2015,2016,-1,5876,2031,2050,2049,-1,2050,2051,2035,2015,-1,2031,2030,2051,2050,-1,2051,2052,2039,2035,-1,2030,2041,2052,2051,-1,2052,2053,2047,2039,-1,2041,2048,2053,2052,-1,2053,2054,2006,2047,-1,2048,2029,2054,2053,-1,2054,2055,2007,2006,-1,2029,2028,2055,2054,-1,2055,2056,2008,2007,-1,2028,2027,2056,2055,-1,2056,5887,5811,2008,-1,2027,2026,5887,2056,-1,2026,2025,5888,5887,-1,5798,1992,2011,5886,-1,1992,1993,2010,2011,-1,1993,2057,2005,2010,-1,1967,2017,2057,1993,-1,2057,2058,2002,2005,-1,2017,2018,2058,2057,-1,2059,2058,2018,2044,-1,2046,2002,2058,2059,-1,2060,2059,2044,2036,-1,2038,2046,2059,2060,-1,2061,2060,2036,2032,-1,2034,2038,2060,2061,-1,1999,2061,2032,2001,-1,2000,2034,2061,1999,-1,1991,1998,1973,5797,-1,1990,1979,1998,1991,-1,5790,5791,1977,-1,2062,2063,2064,2065,-1,2066,2067,2068,2069,-1,2070,2071,2067,2066,-1,2072,2073,2071,2070,-1,2069,2068,2074,2075,-1,2064,2063,2076,2147,-1,2077,2078,2079,2080,-1,2081,2082,2083,-1,2077,2080,2082,2081,-1,2079,2078,2084,2085,-1,2085,2084,2086,2087,-1,2088,2083,2089,-1,2082,2080,2090,-1,2087,2086,2091,-1,2065,2075,2074,2062,-1,377,378,2092,379,-1,2096,2084,2078,-1,2097,2074,2068,2098,-1,2093,411,410,2091,-1,2099,2093,2091,2086,-1,2071,2073,436,-1,2067,2071,436,2100,-1,2068,2067,2100,2098,-1,2095,424,2101,2102,-1,2103,2102,2101,2104,-1,2097,2103,2104,-1,2103,2097};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_12()
		{
			int[] value = {2098,-1,2102,2103,2098,2100,-1,2095,2102,2100,436,-1,2108,2106,2107,2109,-1,2109,2107,425,2110,-1,2111,2109,2110,2112,-1,2112,2110,2113,2114,2115,-1,425,2113,2110,-1,2118,2119,2120,2121,-1,2115,2114,2122,2118,-1,2101,424,460,2123,-1,2104,2101,2123,2124,-1,2123,460,469,2125,-1,2124,2123,2125,2108,-1,2076,2063,2126,2236,-1,2236,2126,2127,2242,-1,2242,2127,2128,2247,-1,2247,2128,2129,2248,-1,2129,2108,2109,2111,-1,2130,2131,2132,2255,-1,2255,2132,2064,2147,-1,2133,2131,2130,2134,-1,2077,2092,378,-1,2092,2077,2081,2135,-1,2090,2136,2075,2065,-1,2120,2119,2133,2134,-1,2137,2069,2075,2136,-1,2138,2066,2069,2137,-1,2080,2079,2136,2090,-1,2085,2137,2136,2079,-1,2099,2086,2084,2096,-1,2138,2139,2070,2066,-1,2139,2094,2072,2070,-1,2141,2142,453,474,-1,2142,2143,2117,453,-1,2116,2117,2143,2140,-1,474,475,2144,2141,-1,475,479,379,2144,-1,2087,2091,2139,2138,-1,2091,410,2094,2139,-1,2138,2137,2085,2087,-1,2118,2122,2089,2119,-1,2119,2089,2083,2133,-1,2133,2083,2082,2131,-1,2131,2082,2090,2132,-1,2132,2090,2065,2064,-1,2255,2257,2256,2130,-1,2130,2256,2266,2134,-1,2134,2266,2272,2120,-1,2120,2272,2278,2121,-1,2121,2278,2145,-1,2145,2278,2227,2146,-1,2146,2227,2226,2295,-1,2248,2129,2111,2295,-1,2295,2111,2112,2146,-1,2146,2112,2115,2145,-1,2145,2115,2118,2121,-1,2063,2062,2097,2126,-1,2126,2097,2104,2127,-1,2127,2104,2124,2128,-1,2128,2124,2108,2129,-1,2108,2125,2106,-1,2106,2125,469,2105,-1,2114,2113,2140,-1,2141,2088,2089,2142,-1,2142,2089,2122,2143,-1,2143,2122,2114,2140,-1,2140,2113,425,-1,2135,2081,2083,2088,-1,2088,2141,2144,2135,-1,2135,2144,379,2092,-1,378,2096,2078,2077,-1,2062,2074,2097,-1,2148,2149,2147,2076,-1,2149,2148,2150,2151,-1,2151,2150,2152,2153,-1,2153,2152,2154,2155,-1,2155,2154,2156,2157,-1,2157,2156,2158,2159,-1,2159,2158,2160,2161,-1,2161,2160,2162,2163,-1,2163,2162,2164,-1,2165,2166,2167,-1,2168,2169,2170,2171,-1,2172,2173,2169,2168,-1,2152,2150,2173,2172,-1,2174,2175,2151,2153,-1,2176,2177,2175,2174,-1,2178,2179,2177,2176,-1,2179,2178,2180,2181,-1,2181,2180,2165,2167,-1,2171,2170,2182,2183,-1,2183,2182,2184,2185,-1,2185,2184,2186,2187,-1,2187,2186,2188,2189,-1,2167,2166,2189,2188,-1,2190,2191,2192,2193,-1,2194,2195,2191,2190,-1,2162,2160,2195,2194,-1,2196,2197,2161,2163,-1,2198,2199,2197,2196,-1,2199,2198,2200,2201,-1,2201,2200,2202,2203,-1,2204,2205,2203,2202,-1,2205,2204,2206,2207,-1,2207,2206,2208,2209,-1,2210,2211,2209,2208,-1,2212,2213,2211,2210,-1,2213,2212,2214,2215,-1,2193,2192,2215,2214,-1,2216,2170,2169,2217,-1,2192,2218,2219,2215,-1,2220,2182,2170,2216,-1,2183,2221,2222,2171,-1,2221,2223,2224,2222,-1,2223,2218,2225,2224,-1,2186,2226,2227,2188,-1,2228,2187,2189,2229,-1,2230,2228,2229,2231,-1,2232,2230,2231,2233,-1,2211,2232,2233,2209,-1,2234,2210,2208,2235,-1,2150,2148,2237,2173,-1,2154,2152,2172,2238,-1,2156,2154,2238,2239,-1,2158,2156,2239,2240,-1,2160,2158,2240,2195,-1,2164,2162,2194,2241,-1,2173,2237,2217,2169,-1,2238,2172,2168,2243,-1,2239,2238,2243,2244,-1,2240,2239,2244,2245,-1,2195,2240,2245,2191,-1,2241,2194,2190,2246,-1,2243,2168,2171,2222,-1,2244,2243,2222,2224,-1,2245,2244,2224,2225,-1,2191,2245,2225,2192,-1,2182,2220,2184,-1,2221,2183,2185,2249,-1,2223,2221,2249,2250,-1,2218,2223,2250,2219,-1,2251,2193,2214,2252,-1,2184,2220,2226,2186,-1,2249,2185,2187,2228,-1,2253,2228,2230,-1,2254,2253,2230,2232,-1,2213,2254,2232,2211,-1,2193,2251,2246,2190,-1,2177,2256,2257,2175,-1,2258,2176,2174,2259,-1,2260,2258,2259,2261,-1,2262,2260,2261,2263,-1,2199,2262,2263,2197,-1,2264,2198,2196,2265,-1,2175,2257,2149,2151,-1,2259,2174,2153,2155,-1,2261,2259,2155,2157,-1,2263,2261,2157,2159,-1,2197,2263,2159,2161,-1,2265,2196,2163,2164,-1,2179,2266,2256,2177,-1,2267,2178,2176,2258,-1,2200,2198,2264,2268,-1,2269,2262,2199,2201,-1,2270,2260,2262,2269,-1,2267,2258,2260,2270,-1,2178,2267,2271,2180,-1,2266,2179,2181,2272,-1,2273,2274,2203,2205,-1,2275,2276,2274,2273,-1,2277,2271,2276,2275,-1,2180,2271,2277,2165,-1,2272,2181,2167,2278,-1,2206,2279,2235,2208,-1,2280,2207,2209,2233,-1,2281,2280,2233,2231,-1,2282,2281,2231,2229,-1,2166,2282,2229,2189,-1,2278,2167,2188,2227,-1,2212,2210,2234,2283,-1,2284,2285,2320,2286,-1,2287,2288,2285,2284,-1,2289,2290,2288,2287,-1,2291,2292,2290,2289,-1,2321,2286,2320,-1,2293,2294,2204,2202,-1,2147,2149,2257,2255,-1,2295,2226,2220,2248,-1,2248,2220,2216,2247,-1,2247,2216,2217,2242,-1,2242,2217,2237,2236,-1,2236,2237,2148,2076,-1,2283,2252,2214,2212,-1,2213,2215,2219,2254,-1,2254,2219,2250,2253,-1,2253,2250,2249,2228,-1,2294,2279,2206,2204,-1,2205,2207,2280,2273,-1,2273,2280,2281,2275,-1,2275,2281,2282,2277,-1,2277,2282,2166,2165,-1,2268,2293,2202,2200};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_13()
		{
			int[] value = {-1,2201,2203,2274,2269,-1,2269,2274,2276,2270,-1,2270,2276,2271,2267,-1,2292,2291,2296,-1,2291,2241,2246,2296,-1,2289,2164,2241,2291,-1,2287,2265,2164,2289,-1,2284,2264,2265,2287,-1,2286,2268,2264,2284,-1,2321,2293,2268,2286,-1,2332,2294,2293,2321,-1,2294,2332,2331,2279,-1,2279,2331,2330,2235,-1,2327,2234,2235,2330,-1,2234,2327,2326,2283,-1,2283,2326,2325,2252,-1,2252,2325,2324,2251,-1,2251,2324,2296,2246,-1,2225,2218,2192,-1,2521,2522,2523,2524,-1,2522,2525,2526,2523,-1,2527,2528,2529,2530,-1,2528,2531,2532,2529,-1,2524,2523,2533,2534,-1,2523,2526,2535,2533,-1,2530,2529,2536,2537,-1,2529,2532,2538,2536,-1,2534,2533,2539,2540,-1,2533,2535,2541,2539,-1,2537,2536,2542,2543,-1,2536,2538,2544,2542,-1,2540,2539,2545,2546,-1,2539,2541,2547,2545,-1,2543,2542,2548,2549,-1,2542,2544,2550,2548,-1,2546,2545,2551,2552,-1,2545,2547,2553,2551,-1,2549,2548,2554,2555,-1,2548,2550,2556,2554,-1,2552,2551,2557,2558,-1,2551,2553,2559,2557,-1,2555,2554,2560,2561,-1,2554,2556,2562,2560,-1,2558,2557,2563,2564,-1,2557,2559,2565,2563,-1,2561,2560,2566,2567,-1,2560,2562,2568,2566,-1,2564,2563,2569,2570,-1,2563,2565,2571,2569,-1,2567,2566,2572,2573,-1,2566,2568,2574,2572,-1,2570,2569,2575,2576,-1,2569,2571,2577,2575,-1,2573,2572,2578,2579,-1,2572,2574,2580,2578,-1,2576,2575,2581,2582,-1,2575,2577,2583,2581,-1,2579,2578,2584,-1,2578,2580,2582,2584,-1,2521,2531,2528,2527,-1,2585,2586,2587,2588,-1,2582,2587,2586,2584,-1,2585,2588,2581,2583,-1,2583,2584,2586,2585,-1,2588,2587,2582,2581,-1,2584,2583,2577,2579,-1,2579,2577,2571,2573,-1,2573,2571,2565,2567,-1,2567,2565,2559,2561,-1,2561,2559,2553,2555,-1,2555,2553,2547,2549,-1,2549,2547,2541,2543,-1,2543,2541,2535,2537,-1,2537,2535,2526,2530,-1,2530,2526,2525,2527,-1,2527,2525,2522,2521,-1,2582,2580,2576,-1,2576,2580,2574,2570,-1,2570,2574,2568,2564,-1,2564,2568,2562,2558,-1,2558,2562,2556,2552,-1,2552,2556,2550,2546,-1,2546,2550,2544,2540,-1,2540,2544,2538,2534,-1,2534,2538,2532,2524,-1,2524,2532,2531,2521,-1,2589,2590,2591,2592,-1,2590,2593,2594,2591,-1,2595,2596,2597,2598,-1,2596,2599,2600,2597,-1,2592,2591,2601,2602,-1,2591,2594,2603,2601,-1,2598,2597,2604,2605,-1,2597,2600,2606,2604,-1,2602,2601,2607,2608,-1,2601,2603,2609,2607,-1,2605,2604,2610,2611,-1,2604,2606,2612,2610,-1,2608,2607,2613,2614,-1,2607,2609,2615,2613,-1,2611,2610,2616,2617,-1,2610,2612,2618,2616,-1,2614,2613,2619,2620,-1,2613,2615,2621,2619,-1,2617,2616,2622,2623,-1,2616,2618,2624,2622,-1,2620,2619,2625,2626,-1,2619,2621,2627,2625,-1,2623,2622,2628,2629,-1,2622,2624,2630,2628,-1,2626,2625,2631,2632,-1,2625,2627,2633,2631,-1,2629,2628,2634,2635,-1,2628,2630,2636,2634,-1,2632,2631,2637,2638,-1,2631,2633,2639,2637,-1,2635,2634,2640,2641,-1,2634,2636,2642,2640,-1,2638,2637,2643,2644,-1,2637,2639,2645,2643,-1,2641,2640,2646,2647,-1,2640,2642,2648,2646,-1,2644,2643,2649,2650,-1,2643,2645,2651,2649,-1,2647,2646,2652,-1,2646,2648,2650,2652,-1,2589,2599,2596,2595,-1,2653,2654,2655,2656,-1,2650,2655,2654,2652,-1,2653,2656,2649,2651,-1,2651,2652,2654,2653,-1,2656,2655,2650,2649,-1,2652,2651,2645,2647,-1,2647,2645,2639,2641,-1,2641,2639,2633,2635,-1,2635,2633,2627,2629,-1,2629,2627,2621,2623,-1,2623,2621,2615,2617,-1,2617,2615,2609,2611,-1,2611,2609,2603,2605,-1,2605,2603,2594,2598,-1,2598,2594,2593,2595,-1,2595,2593,2590,2589,-1,2650,2648,2644,-1,2644,2648,2642,2638,-1,2638,2642,2636,2632,-1,2632,2636,2630,2626,-1,2626,2630,2624,2620,-1,2620,2624,2618,2614,-1,2614,2618,2612,2608,-1,2608,2612,2606,2602,-1,2602,2606,2600,2592,-1,2592,2600,2599,2589,-1,2657,2658,2659,2660,-1,2658,2661,2662,2659,-1,2663,2664,2665,2666,-1,2664,2667,2668,2665,-1,2660,2659,2669,2670,-1,2659,2662,2671,2669,-1,2666,2665,2672,2673,-1,2665,2668,2674,2672,-1,2670,2669,2675,2676,-1,2669,2671,2677,2675,-1,2673,2672,2678,2679,-1,2672,2674,2680,2678,-1,2676,2675,2681,2682,-1,2675,2677,2683,2681,-1,2679,2678,2684,2685,-1,2678,2680,2686,2684,-1,2682,2681,2687,2688,-1,2681,2683,2689,2687,-1,2685,2684,2690,2691,-1,2684,2686,2692,2690,-1,2688,2687,2693,2694,-1,2687,2689,2695,2693,-1,2691,2690,2696,2697,-1,2690,2692,2698,2696,-1,2694,2693,2699,2700,-1,2693,2695,2701,2699,-1,2697,2696,2702,2703,-1,2696,2698,2704,2702,-1,2700,2699,2705,2706,-1,2699,2701,2707,2705,-1,2703,2702,2708,2709,-1,2702,2704,2710,2708,-1,2706,2705,2711,2712,-1,2705,2707,2713,2711,-1,2709,2708,2714,2715,-1,2708,2710,2716,2714,-1,2712,2711,2717,2718,-1,2711,2713,2719,2717,-1,2715,2714,2720,-1,2714,2716,2718,2720,-1,2657,2667,2664,2663,-1,2721,2722,2723,2724,-1,2718,2723,2722,2720,-1,2721,2724,2717,2719,-1,2719,2720,2722,2721,-1,2724,2723,2718,2717,-1,2720,2719,2713,2715,-1,2715,2713,2707,2709,-1,2709};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_14()
		{
			int[] value = {2707,2701,2703,-1,2703,2701,2695,2697,-1,2697,2695,2689,2691,-1,2691,2689,2683,2685,-1,2685,2683,2677,2679,-1,2679,2677,2671,2673,-1,2673,2671,2662,2666,-1,2666,2662,2661,2663,-1,2663,2661,2658,2657,-1,2718,2716,2712,-1,2712,2716,2710,2706,-1,2706,2710,2704,2700,-1,2700,2704,2698,2694,-1,2694,2698,2692,2688,-1,2688,2692,2686,2682,-1,2682,2686,2680,2676,-1,2676,2680,2674,2670,-1,2670,2674,2668,2660,-1,2660,2668,2667,2657,-1,2725,2726,2727,2728,-1,2726,2729,2730,2727,-1,2731,2732,2733,2734,-1,2732,2735,2736,2733,-1,2728,2727,2737,2738,-1,2727,2730,2739,2737,-1,2734,2733,2740,2741,-1,2733,2736,2742,2740,-1,2738,2737,2743,2744,-1,2737,2739,2745,2743,-1,2741,2740,2746,2747,-1,2740,2742,2748,2746,-1,2744,2743,2749,2750,-1,2743,2745,2751,2749,-1,2747,2746,2752,2753,-1,2746,2748,2754,2752,-1,2750,2749,2755,2756,-1,2749,2751,2757,2755,-1,2753,2752,2758,2759,-1,2752,2754,2760,2758,-1,2756,2755,2761,2762,-1,2755,2757,2763,2761,-1,2759,2758,2764,2765,-1,2758,2760,2766,2764,-1,2762,2761,2767,2768,-1,2761,2763,2769,2767,-1,2765,2764,2770,2771,-1,2764,2766,2772,2770,-1,2768,2767,2773,2774,-1,2767,2769,2775,2773,-1,2771,2770,2776,2777,-1,2770,2772,2778,2776,-1,2774,2773,2779,2780,-1,2773,2775,2781,2779,-1,2777,2776,2782,2783,-1,2776,2778,2784,2782,-1,2780,2779,2785,2786,-1,2779,2781,2787,2785,-1,2783,2782,2788,-1,2782,2784,2786,2788,-1,2725,2735,2732,2731,-1,2789,2790,2791,2792,-1,2786,2791,2790,2788,-1,2789,2792,2785,2787,-1,2787,2788,2790,2789,-1,2792,2791,2786,2785,-1,2788,2787,2781,2783,-1,2783,2781,2775,2777,-1,2777,2775,2769,2771,-1,2771,2769,2763,2765,-1,2765,2763,2757,2759,-1,2759,2757,2751,2753,-1,2753,2751,2745,2747,-1,2747,2745,2739,2741,-1,2741,2739,2730,2734,-1,2734,2730,2729,2731,-1,2731,2729,2726,2725,-1,2786,2784,2780,-1,2780,2784,2778,2774,-1,2774,2778,2772,2768,-1,2768,2772,2766,2762,-1,2762,2766,2760,2756,-1,2756,2760,2754,2750,-1,2750,2754,2748,2744,-1,2744,2748,2742,2738,-1,2738,2742,2736,2728,-1,2728,2736,2735,2725,-1,2793,2794,2795,2796,-1,2794,2797,2798,2795,-1,2799,2800,2801,2802,-1,2800,2803,2804,2801,-1,2796,2795,2805,2806,-1,2795,2798,2807,2805,-1,2802,2801,2808,2809,-1,2801,2804,2810,2808,-1,2806,2805,2811,2812,-1,2805,2807,2813,2811,-1,2809,2808,2814,2815,-1,2808,2810,2816,2814,-1,2812,2811,2817,2818,-1,2811,2813,2819,2817,-1,2815,2814,2820,2821,-1,2814,2816,2822,2820,-1,2818,2817,2823,2824,-1,2817,2819,2825,2823,-1,2821,2820,2826,2827,-1,2820,2822,2828,2826,-1,2824,2823,2829,2830,-1,2823,2825,2831,2829,-1,2827,2826,2832,2833,-1,2826,2828,2834,2832,-1,2830,2829,2835,2836,-1,2829,2831,2837,2835,-1,2833,2832,2838,2839,-1,2832,2834,2840,2838,-1,2836,2835,2841,2842,-1,2835,2837,2843,2841,-1,2839,2838,2844,2845,-1,2838,2840,2846,2844,-1,2842,2841,2847,2848,-1,2841,2843,2849,2847,-1,2845,2844,2850,2851,-1,2844,2846,2852,2850,-1,2848,2847,2853,2854,-1,2847,2849,2855,2853,-1,2851,2850,2856,-1,2850,2852,2854,2856,-1,2793,2803,2800,2799,-1,2857,2858,2859,2860,-1,2854,2859,2858,2856,-1,2857,2860,2853,2855,-1,2855,2856,2858,2857,-1,2860,2859,2854,2853,-1,2856,2855,2849,2851,-1,2851,2849,2843,2845,-1,2845,2843,2837,2839,-1,2839,2837,2831,2833,-1,2833,2831,2825,2827,-1,2827,2825,2819,2821,-1,2821,2819,2813,2815,-1,2815,2813,2807,2809,-1,2809,2807,2798,2802,-1,2802,2798,2797,2799,-1,2799,2797,2794,2793,-1,2854,2852,2848,-1,2848,2852,2846,2842,-1,2842,2846,2840,2836,-1,2836,2840,2834,2830,-1,2830,2834,2828,2824,-1,2824,2828,2822,2818,-1,2818,2822,2816,2812,-1,2812,2816,2810,2806,-1,2806,2810,2804,2796,-1,2796,2804,2803,2793,-1,2297,2298,2299,2300,-1,2301,2302,2303,2304,-1,2302,2301,2305,2306,-1,2300,2299,2307,-1,2308,2309,2310,2311,-1,2312,2313,2314,2315,-1,2316,2317,2318,2319,-1,2319,2318,2306,2305,-1,2304,2303,2298,2297,-1,2299,2313,2312,2307,-1,2311,2310,2315,2314,-1,2322,2323,2317,2316,-1,2307,2296,2324,2300,-1,2300,2324,2325,2297,-1,2297,2325,2326,2304,-1,2304,2326,2327,2301,-1,2328,2309,2308,2329,-1,2301,2327,2330,2305,-1,2305,2330,2331,2319,-1,2319,2331,2332,2316,-1,2316,2332,2321,2322,-1,2322,2321,2320,2328,-1,2328,2320,2285,2309,-1,2309,2285,2288,2310,-1,2310,2288,2290,2315,-1,2315,2290,2292,2312,-1,2312,2292,2296,2307,-1,2329,2323,2322,2328,-1,2333,2334,2335,-1,2336,2337,2334,2338,-1,2339,2340,2341,2342,-1,2343,2344,2345,2346,-1,2347,2348,2349,2350,-1,2351,2352,2353,2354,-1,2355,2356,2357,2358,-1,2359,2360,2361,2362,-1,2333,2335,2363,2364,-1,2365,2336,2338,2366,-1,2342,2341,2367,2368,-1,2346,2345,2369,2370,-1,2350,2349,2371,2372,-1,2354,2353,2373,2374,-1,2358,2357,2375,2376,-1,2362,2361,2377,2378,-1,2379,2380,2298,-1,2367,2379,2381,2368,-1,2370,2369,2381,2382,-1,2372,2371,2383,2384,-1,2374,2373,2384,2385};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_15()
		{
			int[] value = {-1,2376,2375,2386,2387,-1,2388,2389,2390,2391,-1,2366,2380,2379,2365,-1,2313,2299,2364,2363,-1,2387,2386,2306,-1,2302,2384,2383,-1,2303,2381,2379,2298,-1,2302,2382,2381,2303,-1,2392,2308,2311,2393,-1,2394,2314,2313,2363,-1,2308,2392,2395,-1,2396,2397,2317,-1,2318,2388,2391,2306,-1,2302,2306,2385,2384,-1,2861,2862,2863,2864,2865,2866,2867,2868,-1,2363,2335,2398,2394,-1,2399,2400,2401,-1,2402,2403,2404,2405,-1,2389,2388,2397,2406,-1,2392,2393,2399,2401,-1,2397,2407,2406,-1,2408,2409,2410,2411,-1,2412,2413,2395,2408,-1,2399,2393,2394,-1,2393,2311,2314,2394,-1,2389,2406,2402,2405,-1,2406,2407,2414,2415,-1,2334,2333,2338,-1,2333,2364,2366,2338,-1,2366,2364,2380,-1,2364,2299,2298,2380,-1,2416,2417,2405,2404,-1,2417,2390,2389,2405,-1,2418,2419,2420,2421,-1,2422,2418,2421,2396,-1,2408,2395,2392,2401,-1,2409,2408,2401,2400,-1,2423,2415,2414,2424,-1,2425,2420,2419,2426,-1,2377,2387,2391,2378,-1,2391,2387,2306,-1,2413,2329,2308,2395,-1,2411,2412,2408,-1,2426,2419,2411,2410,-1,2419,2418,2412,2411,-1,2418,2422,2413,2412,-1,2422,2323,2329,2413,-1,2397,2388,2318,-1,2394,2398,2399,-1,2337,2336,2341,2340,-1,2336,2365,2367,2341,-1,2346,2370,2371,2349,-1,2343,2346,2349,2348,-1,2370,2382,2383,2371,-1,2351,2354,2357,2356,-1,2354,2374,2375,2357,-1,2359,2362,2417,2416,-1,2362,2378,2390,2417,-1,2374,2385,2386,2375,-1,2424,2414,2420,2425,-1,2414,2407,2421,2420,-1,2386,2385,2306,-1,2383,2382,2302,-1,2367,2365,2379,-1,2390,2378,2391,-1,2407,2397,2396,2421,-1,2323,2422,2396,2317,-1,2397,2318,2317,-1,2427,2403,2402,2428,-1,2423,2427,2428,2415,-1,2429,2361,2360,2430,-1,2358,2429,2430,2355,-1,2431,2377,2361,2429,-1,2376,2431,2429,2358,-1,2432,2353,2352,2433,-1,2350,2432,2433,2347,-1,2434,2373,2353,2432,-1,2372,2434,2432,2350,-1,2435,2345,2344,2436,-1,2342,2435,2436,2339,-1,2437,2369,2345,2435,-1,2368,2437,2435,2342,-1,2437,2381,2369,-1,2434,2384,2373,-1,2431,2387,2377,-1,2428,2406,2415,-1,2428,2402,2406,-1,2431,2376,2387,-1,2434,2372,2384,-1,2437,2368,2381,-1,2438,2439,2335,2334,-1,2440,2438,2334,2337,-1,2441,2440,2337,2340,-1,2442,2441,2340,2339,-1,2443,2442,2339,2436,-1,2444,2443,2436,2344,-1,2445,2444,2344,2343,-1,2446,2445,2343,2348,-1,2447,2446,2348,2347,-1,2448,2447,2347,2433,-1,2449,2448,2433,2352,-1,2450,2449,2352,2351,-1,2451,2450,2351,2356,-1,2452,2451,2356,2355,-1,2453,2452,2355,2430,-1,2454,2453,2430,2360,-1,2455,2454,2360,2359,-1,2456,2455,2359,2416,-1,2457,2456,2416,2404,-1,2458,2457,2404,2403,-1,2459,2458,2403,2427,-1,2460,2459,2427,2423,-1,2461,2460,2423,2424,-1,2462,2461,2424,2425,-1,2463,2462,2425,2426,-1,2464,2463,2426,2410,-1,2465,2464,2410,2409,-1,2466,2465,2409,2400,-1,2467,2466,2400,2399,-1,2468,2467,2399,2398,-1,2439,2468,2398,2335,-1,2469,2470,2439,2438,-1,2471,2469,2438,2440,-1,2472,2471,2440,2441,-1,2473,2472,2441,2442,-1,2474,2473,2442,2443,-1,2475,2474,2443,2444,-1,2476,2475,2444,2445,-1,2477,2476,2445,2446,-1,2478,2477,2446,2447,-1,2479,2478,2447,2448,-1,2480,2479,2448,2449,-1,2481,2480,2449,2450,-1,2482,2481,2450,2451,-1,2483,2482,2451,2452,-1,2484,2483,2452,2453,-1,2485,2484,2453,2454,-1,2486,2485,2454,2455,-1,2487,2486,2455,2456,-1,2488,2487,2456,2457,-1,2489,2488,2457,2458,-1,2490,2489,2458,2459,-1,2491,2490,2459,2460,-1,2492,2491,2460,2461,-1,2462,2492,2461,-1,2493,2492,2462,2463,-1,2494,2493,2463,2464,-1,2495,2494,2464,2465,-1,2496,2495,2465,2466,-1,2497,2496,2466,2467,-1,2498,2497,2467,2468,-1,2470,2498,2468,2439,-1,2869,2870,2871,2872,2873,2874,2875,2876,-1,2877,2878,2879,2880,2881,2882,2883,2884,-1,2885,2886,2887,2888,2889,2890,2891,2892,-1,2893,2894,2895,2896,2897,2898,2899,2900,2901,2902,2903,2904,-1,2905,2906,2907,2908,2909,2910,2911,2912,-1,2499,2474,2500,-1,2500,2501,2502,-1,2503,2484,2504,-1,2489,2490,2505,2506,-1,2507,2495,2496,-1,2498,2470,2508,-1,2501,2479,2502,-1,2911,2910,2913,2914,-1,2912,2911,2914,2915,-1,2905,2912,2915,2916,-1,2906,2905,2916,2917,-1,2907,2906,2917,2918,-1,2908,2907,2918,2919,-1,2909,2908,2919,2920,-1,2910,2909,2920,2913,-1,2509,2510,2497,2498,-1,2511,2509,2498,2508,-1,2512,2511,2508,2499,-1,2513,2512,2499,2500,-1,2514,2513,2500,2502,-1,2515,2514,2502,2503,-1,2516,2515,2503,2504,-1,2517,2516,2504,2506,-1,2518,2517,2506,2505,-1,2519,2518,2505,2507,-1,2520,2519,2507,2496,-1,2510,2520,2496,2497,-1,2867,2866,2921,2922,-1,2868,2867,2922,2923,-1,2861,2868,2923,2924,-1,2862,2861,2924,2925,-1,2863,2862,2925,2926,-1,2864,2863,2926,2927,-1,2865,2864,2927,2928,-1,2866,2865,2928,2921,-1,2875,2874,2929,2930,-1,2876,2875,2930,2931,-1,2869,2876,2931,2932,-1,2870,2869,2932,2922,-1,2871,2870,2922,2933,-1,2872,2871,2933,2934,-1,2873,2872,2934,2935,-1,2874,2873,2935,2929,-1,2883,2882,2936,2925};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_16()
		{
			int[] value = {-1,2884,2883,2925,2937,-1,2877,2884,2937,2938,-1,2878,2877,2938,2939,-1,2879,2878,2939,2940,-1,2880,2879,2940,2941,-1,2881,2880,2941,2942,-1,2882,2881,2942,2936,-1,2891,2890,2943,2939,-1,2892,2891,2939,2944,-1,2885,2892,2944,2945,-1,2886,2885,2945,2946,-1,2887,2886,2946,2947,-1,2888,2887,2947,2948,-1,2889,2888,2948,2949,-1,2890,2889,2949,2943,-1,2950,2951,2952,2953,-1,2954,2955,2956,2957,-1,2957,2956,2958,2959,-1,2959,2958,2960,250,-1,2961,2962,2955,2954,-1,3044,3045,2952,2951,-1,2963,2964,2965,2966,-1,2967,2968,2969,-1,2969,2968,2963,2966,-1,2970,2971,2965,2964,-1,2972,2973,2971,2970,-1,2974,2967,2975,-1,2976,2963,2968,-1,2977,2973,2972,-1,2953,2962,2961,2950,-1,2978,2979,2980,2981,-1,2965,2971,296,-1,2987,2955,2962,2988,-1,2977,2982,2983,257,-1,2973,2977,257,311,-1,2989,2960,2958,-1,2990,2989,2958,2956,-1,2987,2990,2956,2955,-1,2991,2992,2985,2984,-1,2993,2992,2991,2994,-1,2993,2994,2988,-1,2987,2988,2994,-1,2990,2987,2994,2991,-1,2989,2990,2991,2984,-1,2996,2995,326,2997,-1,2998,2986,2995,2996,-1,2999,2998,2996,3000,-1,3001,3002,3003,2998,2999,-1,2998,3003,2986,-1,3005,3006,3007,3008,-1,3008,3009,3002,3001,-1,3011,3010,2985,2992,-1,3012,3011,2992,2993,-1,3014,3013,3010,3011,-1,2997,3014,3011,3012,-1,3015,3016,2952,3045,-1,3017,3018,3016,3015,-1,3019,3020,3018,3017,-1,3021,3022,3020,3019,-1,3000,2996,2997,3022,-1,3023,3024,3025,3026,-1,3044,2951,3024,3023,-1,3027,3026,3025,3028,-1,2980,2979,2966,-1,3032,2969,2966,2979,-1,2950,2961,3033,2976,-1,3027,3028,3007,3006,-1,3033,2961,2954,3034,-1,3034,2954,2957,3035,-1,2976,3033,2964,2963,-1,2964,3033,3034,2970,-1,296,2971,2973,311,-1,2957,2959,3036,3035,-1,2959,250,281,3036,-1,3029,3004,3037,3038,-1,3004,333,3039,3037,-1,365,3039,333,330,-1,3038,3040,3030,3029,-1,3040,2978,3031,3030,-1,3035,3036,2977,2972,-1,3036,281,2982,2977,-1,2972,2970,3034,3035,-1,3007,2974,3009,3008,-1,3028,2967,2974,3007,-1,3025,2968,2967,3028,-1,3024,2976,2968,3025,-1,2951,2950,2976,3024,-1,3026,3150,3149,3023,-1,3027,3159,3150,3026,-1,3006,3165,3159,3027,-1,3005,3171,3165,3006,-1,3041,3171,3005,-1,3042,3124,3171,3041,-1,3043,3125,3124,3042,-1,3043,3000,3022,3021,-1,3042,2999,3000,3043,-1,3041,3001,2999,3042,-1,3005,3008,3001,3041,-1,3016,2988,2953,2952,-1,3018,2993,2988,3016,-1,3020,3012,2993,3018,-1,3022,2997,3012,3020,-1,326,3014,2997,-1,325,3013,3014,326,-1,365,3003,3002,-1,3037,2974,2975,3038,-1,3039,3009,2974,3037,-1,365,3002,3009,3039,-1,2986,3003,365,-1,2975,2967,2969,3032,-1,3032,3040,3038,2975,-1,2979,2978,3040,3032,-1,2966,2965,296,2980,-1,2988,2962,2953,-1,3045,3044,3046,3047,-1,3048,3049,3047,3046,-1,3050,3051,3049,3048,-1,3052,3053,3051,3050,-1,3054,3055,3053,3052,-1,3056,3057,3055,3054,-1,3058,3059,3057,3056,-1,3060,3061,3059,3058,-1,3062,3061,3060,-1,3063,3064,3065,-1,3066,3067,3068,3069,-1,3069,3068,3070,3071,-1,3071,3070,3049,3051,-1,3050,3048,3072,3073,-1,3073,3072,3074,3075,-1,3075,3074,3076,3077,-1,3078,3079,3077,3076,-1,3063,3065,3079,3078,-1,3080,3081,3067,3066,-1,3082,3083,3081,3080,-1,3084,3085,3083,3082,-1,3086,3087,3085,3084,-1,3087,3086,3064,3063,-1,3088,3089,3090,3091,-1,3091,3090,3092,3093,-1,3093,3092,3059,3061,-1,3060,3058,3094,3095,-1,3095,3094,3096,3097,-1,3098,3099,3097,3096,-1,3100,3101,3099,3098,-1,3101,3100,3102,3103,-1,3104,3105,3103,3102,-1,3106,3107,3105,3104,-1,3107,3106,3108,3109,-1,3109,3108,3110,3111,-1,3112,3113,3111,3110,-1,3113,3112,3089,3088,-1,3114,3068,3067,3115,-1,3112,3116,3117,3089,-1,3115,3067,3081,3118,-1,3066,3119,3120,3080,-1,3119,3121,3122,3120,-1,3121,3123,3117,3122,-1,3087,3124,3125,3085,-1,3126,3086,3084,3127,-1,3128,3126,3127,3129,-1,3130,3128,3129,3131,-1,3106,3130,3131,3108,-1,3132,3107,3109,3133,-1,3070,3134,3047,3049,-1,3135,3071,3051,3053,-1,3136,3135,3053,3055,-1,3137,3136,3055,3057,-1,3092,3137,3057,3059,-1,3138,3093,3061,3062,-1,3068,3114,3134,3070,-1,3139,3069,3071,3135,-1,3140,3139,3135,3136,-1,3141,3140,3136,3137,-1,3090,3141,3137,3092,-1,3142,3091,3093,3138,-1,3119,3066,3069,3139,-1,3121,3119,3139,3140,-1,3123,3121,3140,3141,-1,3089,3123,3141,3090,-1,3083,3118,3081,-1,3143,3082,3080,3120,-1,3144,3143,3120,3122,-1,3116,3144,3122,3117,-1,3145,3113,3088,3146,-1,3085,3125,3118,3083,-1,3127,3084,3082,3143,-1,3129,3127,3147,-1,3131,3129,3147,3148,-1,3108,3131,3148,3110,-1,3091,3142,3146,3088,-1,3072,3149,3150,3074,-1,3151,3073,3075,3152,-1,3153,3151,3152,3154,-1,3155,3153,3154,3156,-1,3094,3155,3156,3096,-1,3157,3095,3097,3158,-1,3048,3046,3149,3072,-1,3052,3050,3073,3151,-1,3054,3052,3151,3153,-1,3056,3054,3153,3155,-1,3058,3056,3155,3094,-1,3062,3060,3095,3157,-1,3074,3150,3159,3076,-1,3152,3075};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_17()
		{
			int[] value = {3077,3160,-1,3161,3158,3097,3099,-1,3098,3096,3156,3162,-1,3162,3156,3154,3163,-1,3163,3154,3152,3160,-1,3079,3164,3160,3077,-1,3165,3078,3076,3159,-1,3102,3100,3166,3167,-1,3167,3166,3168,3169,-1,3169,3168,3164,3170,-1,3065,3170,3164,3079,-1,3171,3063,3078,3165,-1,3107,3132,3172,3105,-1,3130,3106,3104,3173,-1,3128,3130,3173,3174,-1,3126,3128,3174,3175,-1,3086,3126,3175,3064,-1,3124,3087,3063,3171,-1,3176,3133,3109,3111,-1,3177,3178,3209,3179,-1,3179,3209,3210,3180,-1,3180,3210,3211,3181,-1,3181,3211,3212,3182,-1,3178,3177,3183,-1,3101,3103,3184,3185,-1,3023,3149,3046,3044,-1,3021,3118,3125,3043,-1,3019,3115,3118,3021,-1,3017,3114,3115,3019,-1,3015,3134,3114,3017,-1,3045,3047,3134,3015,-1,3111,3113,3145,3176,-1,3148,3116,3112,3110,-1,3147,3144,3116,3148,-1,3127,3143,3144,3147,-1,3103,3105,3172,3184,-1,3167,3173,3104,3102,-1,3169,3174,3173,3167,-1,3170,3175,3174,3169,-1,3065,3064,3175,3170,-1,3099,3101,3185,3161,-1,3162,3166,3100,3098,-1,3163,3168,3166,3162,-1,3160,3164,3168,3163,-1,3216,3182,3212,-1,3216,3142,3138,3182,-1,3182,3138,3062,3181,-1,3181,3062,3157,3180,-1,3180,3157,3158,3179,-1,3179,3158,3161,3177,-1,3177,3161,3185,3183,-1,3183,3185,3184,3224,-1,3172,3223,3224,3184,-1,3132,3222,3223,3172,-1,3222,3132,3133,3219,-1,3176,3218,3219,3133,-1,3145,3217,3218,3176,-1,3146,3215,3217,3145,-1,3142,3216,3215,3146,-1,3089,3117,3123,-1,3413,3414,3415,3416,-1,3414,3417,3418,3415,-1,3419,3420,3421,3422,-1,3420,3423,3424,3421,-1,3425,3426,3414,3413,-1,3426,3427,3417,3414,-1,3428,3429,3420,3419,-1,3429,3430,3423,3420,-1,3431,3432,3426,3425,-1,3432,3433,3427,3426,-1,3434,3435,3429,3428,-1,3435,3436,3430,3429,-1,3437,3438,3432,3431,-1,3438,3439,3433,3432,-1,3440,3441,3435,3434,-1,3441,3442,3436,3435,-1,3443,3444,3438,3437,-1,3444,3445,3439,3438,-1,3446,3447,3441,3440,-1,3447,3448,3442,3441,-1,3449,3450,3444,3443,-1,3450,3451,3445,3444,-1,3452,3453,3447,3446,-1,3453,3454,3448,3447,-1,3455,3456,3450,3449,-1,3456,3457,3451,3450,-1,3458,3459,3453,3452,-1,3459,3460,3454,3453,-1,3461,3462,3456,3455,-1,3462,3463,3457,3456,-1,3464,3465,3459,3458,-1,3465,3466,3460,3459,-1,3467,3468,3462,3461,-1,3468,3469,3463,3462,-1,3470,3471,3465,3464,-1,3471,3472,3466,3465,-1,3473,3474,3468,3467,-1,3474,3475,3469,3468,-1,3476,3471,3470,-1,3476,3473,3472,3471,-1,3422,3421,3424,3416,-1,3477,3478,3479,3480,-1,3476,3479,3478,3473,-1,3475,3474,3477,3480,-1,3480,3479,3476,3475,-1,3474,3473,3478,3477,-1,3470,3469,3475,3476,-1,3464,3463,3469,3470,-1,3458,3457,3463,3464,-1,3452,3451,3457,3458,-1,3446,3445,3451,3452,-1,3440,3439,3445,3446,-1,3434,3433,3439,3440,-1,3428,3427,3433,3434,-1,3419,3417,3427,3428,-1,3422,3418,3417,3419,-1,3416,3415,3418,3422,-1,3467,3472,3473,-1,3461,3466,3472,3467,-1,3455,3460,3466,3461,-1,3449,3454,3460,3455,-1,3443,3448,3454,3449,-1,3437,3442,3448,3443,-1,3431,3436,3442,3437,-1,3425,3430,3436,3431,-1,3413,3423,3430,3425,-1,3416,3424,3423,3413,-1,3481,3482,3483,3484,-1,3482,3485,3486,3483,-1,3487,3488,3489,3490,-1,3488,3491,3492,3489,-1,3493,3494,3482,3481,-1,3494,3495,3485,3482,-1,3496,3497,3488,3487,-1,3497,3498,3491,3488,-1,3499,3500,3494,3493,-1,3500,3501,3495,3494,-1,3502,3503,3497,3496,-1,3503,3504,3498,3497,-1,3505,3506,3500,3499,-1,3506,3507,3501,3500,-1,3508,3509,3503,3502,-1,3509,3510,3504,3503,-1,3511,3512,3506,3505,-1,3512,3513,3507,3506,-1,3514,3515,3509,3508,-1,3515,3516,3510,3509,-1,3517,3518,3512,3511,-1,3518,3519,3513,3512,-1,3520,3521,3515,3514,-1,3521,3522,3516,3515,-1,3523,3524,3518,3517,-1,3524,3525,3519,3518,-1,3526,3527,3521,3520,-1,3527,3528,3522,3521,-1,3529,3530,3524,3523,-1,3530,3531,3525,3524,-1,3532,3533,3527,3526,-1,3533,3534,3528,3527,-1,3535,3536,3530,3529,-1,3536,3537,3531,3530,-1,3538,3539,3533,3532,-1,3539,3540,3534,3533,-1,3541,3542,3536,3535,-1,3542,3543,3537,3536,-1,3544,3539,3538,-1,3544,3541,3540,3539,-1,3490,3489,3492,3484,-1,3545,3546,3547,3548,-1,3544,3547,3546,3541,-1,3543,3542,3545,3548,-1,3548,3547,3544,3543,-1,3542,3541,3546,3545,-1,3538,3537,3543,3544,-1,3532,3531,3537,3538,-1,3526,3525,3531,3532,-1,3520,3519,3525,3526,-1,3514,3513,3519,3520,-1,3508,3507,3513,3514,-1,3502,3501,3507,3508,-1,3496,3495,3501,3502,-1,3487,3485,3495,3496,-1,3490,3486,3485,3487,-1,3484,3483,3486,3490,-1,3535,3540,3541,-1,3529,3534,3540,3535,-1,3523,3528,3534,3529,-1,3517,3522,3528,3523,-1,3511,3516,3522,3517,-1,3505,3510,3516,3511,-1,3499,3504,3510,3505,-1,3493,3498,3504,3499,-1,3481,3491,3498,3493,-1,3484,3492,3491,3481,-1,3549,3550,3551,3552,-1,3550,3553,3554,3551,-1,3555,3556,3557,3558,-1,3556,3559,3560,3557,-1,3561,3562,3550,3549,-1,3562,3563,3553,3550,-1,3564,3565,3556,3555,-1,3565,3566,3559,3556};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_18()
		{
			int[] value = {-1,3567,3568,3562,3561,-1,3568,3569,3563,3562,-1,3570,3571,3565,3564,-1,3571,3572,3566,3565,-1,3573,3574,3568,3567,-1,3574,3575,3569,3568,-1,3576,3577,3571,3570,-1,3577,3578,3572,3571,-1,3579,3580,3574,3573,-1,3580,3581,3575,3574,-1,3582,3583,3577,3576,-1,3583,3584,3578,3577,-1,3585,3586,3580,3579,-1,3586,3587,3581,3580,-1,3588,3589,3583,3582,-1,3589,3590,3584,3583,-1,3591,3592,3586,3585,-1,3592,3593,3587,3586,-1,3594,3595,3589,3588,-1,3595,3596,3590,3589,-1,3597,3598,3592,3591,-1,3598,3599,3593,3592,-1,3600,3601,3595,3594,-1,3601,3602,3596,3595,-1,3603,3604,3598,3597,-1,3604,3605,3599,3598,-1,3606,3607,3601,3600,-1,3607,3608,3602,3601,-1,3609,3610,3604,3603,-1,3610,3611,3605,3604,-1,3612,3607,3606,-1,3612,3609,3608,3607,-1,3558,3557,3560,3552,-1,3613,3614,3615,3616,-1,3612,3615,3614,3609,-1,3611,3610,3613,3616,-1,3616,3615,3612,3611,-1,3610,3609,3614,3613,-1,3606,3605,3611,3612,-1,3600,3599,3605,3606,-1,3594,3593,3599,3600,-1,3588,3587,3593,3594,-1,3582,3581,3587,3588,-1,3576,3575,3581,3582,-1,3570,3569,3575,3576,-1,3564,3563,3569,3570,-1,3555,3553,3563,3564,-1,3558,3554,3553,3555,-1,3552,3551,3554,3558,-1,3603,3608,3609,-1,3597,3602,3608,3603,-1,3591,3596,3602,3597,-1,3585,3590,3596,3591,-1,3579,3584,3590,3585,-1,3573,3578,3584,3579,-1,3567,3572,3578,3573,-1,3561,3566,3572,3567,-1,3549,3559,3566,3561,-1,3552,3560,3559,3549,-1,3617,3618,3619,3620,-1,3618,3621,3622,3619,-1,3623,3624,3625,3626,-1,3624,3627,3628,3625,-1,3629,3630,3618,3617,-1,3630,3631,3621,3618,-1,3632,3633,3624,3623,-1,3633,3634,3627,3624,-1,3635,3636,3630,3629,-1,3636,3637,3631,3630,-1,3638,3639,3633,3632,-1,3639,3640,3634,3633,-1,3641,3642,3636,3635,-1,3642,3643,3637,3636,-1,3644,3645,3639,3638,-1,3645,3646,3640,3639,-1,3647,3648,3642,3641,-1,3648,3649,3643,3642,-1,3650,3651,3645,3644,-1,3651,3652,3646,3645,-1,3653,3654,3648,3647,-1,3654,3655,3649,3648,-1,3656,3657,3651,3650,-1,3657,3658,3652,3651,-1,3659,3660,3654,3653,-1,3660,3661,3655,3654,-1,3662,3663,3657,3656,-1,3663,3664,3658,3657,-1,3665,3666,3660,3659,-1,3666,3667,3661,3660,-1,3668,3669,3663,3662,-1,3669,3670,3664,3663,-1,3671,3672,3666,3665,-1,3672,3673,3667,3666,-1,3674,3675,3669,3668,-1,3675,3676,3670,3669,-1,3677,3678,3672,3671,-1,3678,3679,3673,3672,-1,3680,3675,3674,-1,3680,3677,3676,3675,-1,3626,3625,3628,3620,-1,3681,3682,3683,3684,-1,3680,3683,3682,3677,-1,3679,3678,3681,3684,-1,3684,3683,3680,3679,-1,3678,3677,3682,3681,-1,3674,3673,3679,3680,-1,3668,3667,3673,3674,-1,3662,3661,3667,3668,-1,3656,3655,3661,3662,-1,3650,3649,3655,3656,-1,3644,3643,3649,3650,-1,3638,3637,3643,3644,-1,3632,3631,3637,3638,-1,3623,3621,3631,3632,-1,3626,3622,3621,3623,-1,3620,3619,3622,3626,-1,3671,3676,3677,-1,3665,3670,3676,3671,-1,3659,3664,3670,3665,-1,3653,3658,3664,3659,-1,3647,3652,3658,3653,-1,3641,3646,3652,3647,-1,3635,3640,3646,3641,-1,3629,3634,3640,3635,-1,3617,3627,3634,3629,-1,3620,3628,3627,3617,-1,3685,3686,3687,3688,-1,3686,3689,3690,3687,-1,3691,3692,3693,3694,-1,3692,3695,3696,3693,-1,3697,3698,3686,3685,-1,3698,3699,3689,3686,-1,3700,3701,3692,3691,-1,3701,3702,3695,3692,-1,3703,3704,3698,3697,-1,3704,3705,3699,3698,-1,3706,3707,3701,3700,-1,3707,3708,3702,3701,-1,3709,3710,3704,3703,-1,3710,3711,3705,3704,-1,3712,3713,3707,3706,-1,3713,3714,3708,3707,-1,3715,3716,3710,3709,-1,3716,3717,3711,3710,-1,3718,3719,3713,3712,-1,3719,3720,3714,3713,-1,3721,3722,3716,3715,-1,3722,3723,3717,3716,-1,3724,3725,3719,3718,-1,3725,3726,3720,3719,-1,3727,3728,3722,3721,-1,3728,3729,3723,3722,-1,3730,3731,3725,3724,-1,3731,3732,3726,3725,-1,3733,3734,3728,3727,-1,3734,3735,3729,3728,-1,3736,3737,3731,3730,-1,3737,3738,3732,3731,-1,3739,3740,3734,3733,-1,3740,3741,3735,3734,-1,3742,3743,3737,3736,-1,3743,3744,3738,3737,-1,3745,3746,3740,3739,-1,3746,3747,3741,3740,-1,3748,3743,3742,-1,3748,3745,3744,3743,-1,3694,3693,3696,3688,-1,3749,3750,3751,3752,-1,3748,3751,3750,3745,-1,3747,3746,3749,3752,-1,3752,3751,3748,3747,-1,3746,3745,3750,3749,-1,3742,3741,3747,3748,-1,3736,3735,3741,3742,-1,3730,3729,3735,3736,-1,3724,3723,3729,3730,-1,3718,3717,3723,3724,-1,3712,3711,3717,3718,-1,3706,3705,3711,3712,-1,3700,3699,3705,3706,-1,3691,3689,3699,3700,-1,3694,3690,3689,3691,-1,3688,3687,3690,3694,-1,3739,3744,3745,-1,3733,3738,3744,3739,-1,3727,3732,3738,3733,-1,3721,3726,3732,3727,-1,3715,3720,3726,3721,-1,3709,3714,3720,3715,-1,3703,3708,3714,3709,-1,3697,3702,3708,3703,-1,3685,3695,3702,3697,-1,3688,3696,3695,3685,-1,3186,3187,3188,3189,-1,3190,3191,3192,3193,-1,3194,3195,3193,3192,-1,3196,3187,3186,-1,3197,3198,3199,3200,-1,3201,3202,3203,3204,-1,3205,3206,3207,3208,-1,3195,3194,3206,3205,-1,3189};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_19()
		{
			int[] value = {3188,3191,3190,-1,3196,3204,3203,3187,-1,3202,3201,3198,3197,-1,3208,3207,3213,3214,-1,3186,3215,3216,3196,-1,3189,3217,3215,3186,-1,3190,3218,3217,3189,-1,3193,3219,3218,3190,-1,3220,3200,3199,3221,-1,3195,3222,3219,3193,-1,3205,3223,3222,3195,-1,3208,3224,3223,3205,-1,3214,3183,3224,3208,-1,3221,3178,3183,3214,-1,3199,3209,3178,3221,-1,3198,3210,3209,3199,-1,3201,3211,3210,3198,-1,3204,3212,3211,3201,-1,3196,3216,3212,3204,-1,3221,3214,3213,3220,-1,3225,3226,3227,-1,3228,3226,3229,3230,-1,3231,3232,3233,3234,-1,3235,3236,3237,3238,-1,3239,3240,3241,3242,-1,3243,3244,3245,3246,-1,3247,3248,3249,3250,-1,3251,3252,3253,3254,-1,3255,3256,3225,3227,-1,3257,3228,3230,3258,-1,3259,3260,3232,3231,-1,3261,3262,3236,3235,-1,3263,3264,3240,3239,-1,3265,3266,3244,3243,-1,3267,3268,3248,3247,-1,3269,3270,3252,3251,-1,3188,3271,3272,-1,3259,3273,3272,3260,-1,3274,3273,3262,3261,-1,3275,3276,3264,3263,-1,3277,3275,3266,3265,-1,3278,3279,3268,3267,-1,3280,3281,3282,3283,-1,3258,3272,3271,3257,-1,3256,3255,3187,3203,-1,3194,3279,3278,-1,3276,3275,3192,-1,3188,3272,3273,3191,-1,3191,3273,3274,3192,-1,3284,3197,3200,3285,-1,3256,3203,3202,3286,-1,3287,3285,3200,-1,3207,3288,3289,-1,3194,3280,3283,3206,-1,3275,3277,3194,3192,-1,3753,3754,3755,3756,3757,3758,3759,3760,-1,3286,3290,3225,3256,-1,3291,3292,3293,-1,3294,3295,3296,3297,-1,3298,3288,3283,3282,-1,3291,3293,3284,3285,-1,3298,3299,3288,-1,3300,3301,3302,3303,-1,3303,3287,3304,3305,-1,3286,3284,3293,-1,3286,3202,3197,3284,-1,3294,3297,3298,3282,-1,3306,3307,3299,3298,-1,3228,3227,3226,-1,3228,3257,3255,3227,-1,3271,3255,3257,-1,3271,3188,3187,3255,-1,3295,3294,3308,3309,-1,3294,3282,3281,3308,-1,3310,3311,3312,3313,-1,3289,3310,3313,3314,-1,3291,3285,3287,3303,-1,3292,3291,3303,3302,-1,3315,3307,3306,3316,-1,3317,3312,3311,3318,-1,3269,3280,3278,3270,-1,3194,3278,3280,-1,3287,3200,3220,3304,-1,3303,3305,3300,-1,3301,3300,3312,3317,-1,3300,3305,3313,3312,-1,3305,3304,3314,3313,-1,3304,3220,3213,3314,-1,3206,3283,3288,-1,3293,3290,3286,-1,3233,3232,3230,3229,-1,3232,3260,3258,3230,-1,3240,3264,3261,3235,-1,3241,3240,3235,3238,-1,3264,3276,3274,3261,-1,3249,3248,3243,3246,-1,3248,3268,3265,3243,-1,3309,3308,3251,3254,-1,3308,3281,3269,3251,-1,3268,3279,3277,3265,-1,3318,3311,3307,3315,-1,3311,3310,3299,3307,-1,3194,3277,3279,-1,3192,3274,3276,-1,3272,3258,3260,-1,3280,3269,3281,-1,3310,3289,3288,3299,-1,3207,3289,3314,3213,-1,3207,3206,3288,-1,3319,3297,3296,3320,-1,3306,3319,3320,3316,-1,3321,3253,3252,3322,-1,3250,3321,3322,3247,-1,3322,3252,3270,3323,-1,3247,3322,3323,3267,-1,3324,3245,3244,3325,-1,3242,3324,3325,3239,-1,3325,3244,3266,3326,-1,3239,3325,3326,3263,-1,3327,3237,3236,3328,-1,3234,3327,3328,3231,-1,3328,3236,3262,3329,-1,3231,3328,3329,3259,-1,3262,3273,3329,-1,3266,3275,3326,-1,3270,3278,3323,-1,3306,3298,3319,-1,3298,3297,3319,-1,3278,3267,3323,-1,3275,3263,3326,-1,3273,3259,3329,-1,3226,3225,3330,3331,-1,3229,3226,3331,3332,-1,3233,3229,3332,3333,-1,3234,3233,3333,3334,-1,3327,3234,3334,3335,-1,3237,3327,3335,3336,-1,3238,3237,3336,3337,-1,3241,3238,3337,3338,-1,3242,3241,3338,3339,-1,3324,3242,3339,3340,-1,3245,3324,3340,3341,-1,3246,3245,3341,3342,-1,3249,3246,3342,3343,-1,3250,3249,3343,3344,-1,3321,3250,3344,3345,-1,3253,3321,3345,3346,-1,3254,3253,3346,3347,-1,3309,3254,3347,3348,-1,3295,3309,3348,3349,-1,3296,3295,3349,3350,-1,3320,3296,3350,3351,-1,3316,3320,3351,3352,-1,3315,3316,3352,3353,-1,3318,3315,3353,3354,-1,3317,3318,3354,3355,-1,3301,3317,3355,3356,-1,3302,3301,3356,3357,-1,3292,3302,3357,3358,-1,3293,3292,3358,3359,-1,3290,3293,3359,3360,-1,3225,3290,3360,3330,-1,3331,3330,3361,3362,-1,3332,3331,3362,3363,-1,3333,3332,3363,3364,-1,3334,3333,3364,3365,-1,3335,3334,3365,3366,-1,3336,3335,3366,3367,-1,3337,3336,3367,3368,-1,3338,3337,3368,3369,-1,3339,3338,3369,3370,-1,3340,3339,3370,3371,-1,3341,3340,3371,3372,-1,3342,3341,3372,3373,-1,3343,3342,3373,3374,-1,3344,3343,3374,3375,-1,3345,3344,3375,3376,-1,3346,3345,3376,3377,-1,3347,3346,3377,3378,-1,3348,3347,3378,3379,-1,3349,3348,3379,3380,-1,3350,3349,3380,3381,-1,3351,3350,3381,3382,-1,3352,3351,3382,3383,-1,3353,3352,3383,3384,-1,3353,3384,3354,-1,3355,3354,3384,3385,-1,3356,3355,3385,3386,-1,3357,3356,3386,3387,-1,3358,3357,3387,3388,-1,3359,3358,3388,3389,-1,3360,3359,3389,3390,-1,3330,3360,3390,3361,-1,3761,3762,3763,3764,3765,3766,3767,3768,-1,3769,3770,3771,3772,3773,3774,3775,3776,-1,3777,3778,3779,3780,3781,3782,3783,3784,-1,3785,3786,3787,3788,3789,3790,3791,3792,3793,3794,3795,3796,-1,3797,3798,3799,3800,3801,3802,3803,3804,-1,3391,3366,3392,-1,3393,3394,3391,-1,3395,3376,3396,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_20()
		{
			int[] value = {3397,3398,3382,3381,-1,3388,3387,3399,-1,3400,3361,3390,-1,3393,3371,3394,-1,3805,3806,3799,3798,-1,3807,3805,3798,3797,-1,3808,3807,3797,3804,-1,3809,3808,3804,3803,-1,3810,3809,3803,3802,-1,3811,3810,3802,3801,-1,3812,3811,3801,3800,-1,3806,3812,3800,3799,-1,3390,3389,3401,3402,-1,3400,3390,3402,3403,-1,3392,3400,3403,3404,-1,3391,3392,3404,3405,-1,3393,3391,3405,3406,-1,3396,3393,3406,3407,-1,3395,3396,3407,3408,-1,3397,3395,3408,3409,-1,3398,3397,3409,3410,-1,3399,3398,3410,3411,-1,3388,3399,3411,3412,-1,3389,3388,3412,3401,-1,3813,3814,3755,3754,-1,3815,3813,3754,3753,-1,3816,3815,3753,3760,-1,3817,3816,3760,3759,-1,3818,3817,3759,3758,-1,3819,3818,3758,3757,-1,3820,3819,3757,3756,-1,3814,3820,3756,3755,-1,3821,3822,3763,3762,-1,3823,3821,3762,3761,-1,3824,3823,3761,3768,-1,3813,3824,3768,3767,-1,3825,3813,3767,3766,-1,3826,3825,3766,3765,-1,3827,3826,3765,3764,-1,3822,3827,3764,3763,-1,3817,3828,3771,3770,-1,3829,3817,3770,3769,-1,3830,3829,3769,3776,-1,3831,3830,3776,3775,-1,3832,3831,3775,3774,-1,3833,3832,3774,3773,-1,3834,3833,3773,3772,-1,3828,3834,3772,3771,-1,3831,3835,3779,3778,-1,3836,3831,3778,3777,-1,3837,3836,3777,3784,-1,3838,3837,3784,3783,-1,3839,3838,3783,3782,-1,3840,3839,3782,3781,-1,3841,3840,3781,3780,-1,3835,3841,3780,3779,-1,3845,3846,3847,3848,-1,3849,3850,3851,3852,-1,3853,3854,3855,3856,-1,3857,3858,3859,3860,-1,3861,3862,3863,-1,3864,3865,3866,3867,-1,3870,3871,3872,-1,3873,3874,3875,-1,3876,3877,3878,-1,3879,3880,3881,3882,-1,3883,3884,3885,3886,-1,3888,3889,3890,3891,-1,3892,3893,3894,-1,3898,3899,3900,3901,-1,3902,3903,3904,-1,3905,3906,3907,3908,-1,9397,3909,9398,9399,-1,3910,3911,3912,3913,-1,3846,3845,3915,-1,3916,3851,3850,-1,3854,3853,3847,3846,-1,3917,3855,3854,-1,3856,3855,3858,3857,-1,3853,3856,3918,3862,-1,3864,3867,3919,-1,3862,3861,3848,3847,-1,3852,3851,3845,3848,-1,3850,3849,3865,3864,-1,3849,3852,3871,3870,-1,3869,3868,3867,3866,-1,3866,3865,3870,3921,-1,3872,3871,3861,3863,-1,3863,3922,3875,3874,-1,3923,3924,3922,3918,-1,3924,3878,3882,3881,-1,3873,3875,3881,3880,-1,3880,3879,3885,3884,-1,3879,3882,9143,9142,-1,3889,3888,9154,9153,-1,3896,3895,3893,3892,-1,9159,9163,3892,3925,-1,3899,3898,3890,3927,-1,9188,3897,3927,3889,-1,3891,3890,3928,-1,3894,3893,3888,3891,-1,3929,3930,3894,-1,3925,3930,3931,3932,-1,3884,3883,3933,-1,3934,3903,3931,-1,3926,9500,3900,3899,-1,3908,3907,9501,3935,-1,243,3906,3905,-1,3898,3901,3936,-1,3901,3900,3907,3906,-1,3910,3913,3937,-1,3938,3859,3858,-1,3860,3859,3913,3912,-1,3857,3860,3876,3923,-1,3911,3910,9398,3909,-1,3844,3843,3909,9397,-1,3843,3842,3878,3877,-1,3877,3876,3912,3911,-1,3883,3886,3904,3903,-1,3887,9145,3886,3885,-1,9412,3914,3902,3904,-1,3932,3902,9202,9201,-1,3902,3932,3931,3903,-1,3894,3930,3925,3892,-1,3889,3927,3890,-1,3872,3921,3870,-1,3862,3918,3922,3863,-1,3878,3924,3923,3876,-1,3915,3845,3851,3916,-1,3848,3861,3871,3852,-1,3870,3865,3849,-1,3937,3913,3859,3938,-1,3860,3912,3876,-1,3855,3917,3938,3858,-1,3895,9154,3888,3893,-1,3902,3914,9202,-1,9145,9412,3904,3886,-1,3842,9143,3882,3878,-1,3875,3922,3924,3881,-1,3934,3933,3883,3903,-1,3900,9500,9501,3907,-1,3919,3867,3868,3920,-1,3930,3929,3934,3931,-1,3906,243,3936,3901,-1,3935,3939,3940,3908,-1,3936,3928,3890,3898,-1,3891,3928,3929,3894,-1,3937,9503,9398,3910,-1,3911,3909,3843,3877,-1,243,3905,3941,3942,-1,3872,3863,3874,-1,3897,3926,3899,3927,-1,3896,3892,9163,-1,3885,3879,9142,3887,-1,3933,3873,3880,3884,-1,3869,3866,3921,-1,3856,3857,3923,3918,-1,3847,3853,3862,-1,3850,3864,3919,3916,-1,3915,3917,3854,3846,-1,3889,9153,9188,-1,9201,9159,3925,3932,-1,3940,3941,3905,3908,-1,3945,3946,3947,3948,-1,3949,3950,3951,3952,-1,3953,3954,3955,3956,-1,3957,3958,3959,3960,-1,3961,3962,3963,-1,3964,3965,3966,3967,-1,3969,3970,3971,-1,3972,3973,3974,-1,3975,3976,3977,-1,3978,3979,3980,3981,-1,3982,3983,3984,3985,-1,3988,3989,3990,3991,-1,3992,3993,3994,-1,3995,3996,3997,3998,-1,4001,4002,4003,-1,4004,4005,4006,4007,-1,10246,10247,4008,4009,-1,4010,4011,4012,4013,-1,3915,3948,3947,-1,3951,3950,3916,-1,3947,3946,3956,3955,-1,3955,3954,3917,-1,3960,3959,3954,3953,-1,3962,4014,3953,3956,-1,3919,3964,3967,-1,3946,3945,3963,3962,-1,3945,3948,3950,3949,-1,3967,3966,3952,3951,-1,3971,3970,3949,3952,-1,3965,3964,3968,368,-1,4015,3971,3966,3965,-1,3961,3963,3970,3969,-1,3973,3972,4016,3961,-1,4014,4016,4017,4018,-1,3979,3978,3975,4017,-1,3980,3979,3972,3974,-1,3984,3983,3981,3980,-1,3944,3943,3978,3981,-1,3987,3986,3991,3990,-1,3994,3993,10010,10009,-1,4019,3994,10011,10015,-1,4020,3989,3998,3997,-1,3990,4020,10043,10042,-1,4021,3989,3988,-1,3988,3991,3993,3992,-1,3992,4022};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_21()
		{
			int[] value = {4023,-1,4024,4025,4022,4019,-1,4026,3985,3984,-1,4025,4002,4027,-1,3997,3996,10348,10303,-1,10349,10350,4005,4004,-1,4007,4006,4028,-1,4029,3995,3998,-1,4006,4005,3996,3995,-1,3937,4010,4013,-1,3959,3958,3938,-1,4011,4010,3958,3957,-1,4018,3977,3957,3960,-1,4008,10247,4013,4012,-1,4009,4008,9989,9988,-1,3976,3975,9990,9989,-1,4012,4011,3977,3976,-1,4002,4001,3982,3985,-1,3983,3982,10000,9999,-1,4001,4003,10260,10259,-1,4000,3999,4003,4024,-1,4002,4025,4024,4003,-1,3994,4019,4022,3992,-1,3989,4020,3990,-1,3971,4015,3969,-1,3961,4016,4014,3962,-1,3977,4018,4017,3975,-1,3916,3950,3948,3915,-1,3949,3970,3963,3945,-1,3952,3966,3971,-1,3938,3958,4010,3937,-1,3977,4011,3957,-1,3959,3938,3917,3954,-1,3993,3991,3986,10010,-1,3999,10260,4003,-1,3982,4001,10259,10000,-1,3975,3978,3943,9990,-1,3979,4017,4016,3972,-1,4002,3985,4026,4027,-1,4005,10350,10348,3996,-1,3920,3968,3964,3919,-1,4025,4027,4023,4022,-1,3995,4029,4028,4006,-1,4004,3940,3939,10349,-1,3998,3989,4021,4029,-1,3992,4023,4021,3988,-1,4013,10247,9503,3937,-1,3976,9989,4008,4012,-1,3942,3941,4007,4028,-1,3973,3961,3969,-1,4020,3997,10303,10043,-1,10011,3994,10009,-1,9999,3944,3981,3983,-1,3984,3980,3974,4026,-1,4015,3965,368,-1,4014,4018,3960,3953,-1,3962,3956,3946,-1,3916,3919,3967,3951,-1,3947,3955,3917,3915,-1,10042,3987,3990,-1,4024,4019,10015,4000,-1,4004,4007,3941,3940,-1,4030,4031,4032,-1,4033,4034,4035,4036,-1,4037,4038,4039,4040,-1,4041,4042,4043,-1,4044,4045,4046,4047,-1,4048,4049,4050,4051,-1,4052,4037,4040,4053,-1,4054,4055,4056,4057,-1,4058,4035,4034,4059,-1,4060,4061,4062,4063,4064,4065,4066,10625,10626,10627,4067,10628,10629,10630,10631,10632,10633,10634,10635,4068,10636,4069,4070,4071,4072,4073,-1,4074,4075,4076,4077,-1,4078,4079,4080,4081,-1,4081,4080,4082,4083,-1,4075,4084,4085,4076,-1,4079,4086,4087,4080,-1,4048,4088,4089,4049,-1,4039,4092,4093,4040,-1,4040,4093,4094,4053,-1,4088,4095,4096,4089,-1,4092,4098,4099,4093,-1,4093,4099,4100,4094,-1,4082,4080,4087,4101,-1,4083,4082,4102,4103,-1,4103,4104,4105,4106,4083,-1,4084,4107,4108,4085,-1,4086,4109,4110,4087,-1,4087,4110,4111,4101,-1,4101,4111,4112,4113,-1,4107,4055,4054,4108,-1,4109,4059,4034,4110,-1,4110,4034,4033,4111,-1,4111,4033,4036,4112,-1,4030,4115,4116,4031,-1,4117,4044,4047,4118,-1,4105,4030,4032,4106,-1,4090,4119,484,4097,-1,4098,4121,4122,4099,-1,4099,4122,4123,4100,-1,4095,4124,4125,4096,-1,4073,4126,4127,4060,-1,4060,4127,4128,4061,-1,4063,4129,4130,4064,-1,4042,4131,4132,4043,-1,4046,4133,4134,4047,-1,4047,4134,4135,4118,-1,4116,4136,4137,4031,-1,4031,4137,4138,4032,-1,4032,4138,4139,4106,-1,4106,4139,4140,4083,-1,4126,4038,4037,4127,-1,4127,4037,4052,4128,-1,4129,4051,4050,4130,-1,4131,4125,4124,4132,-1,4133,4123,4122,4134,-1,4134,4122,4121,4135,-1,4136,4120,484,4137,-1,4137,484,4119,4138,-1,4138,4119,4090,4139,-1,4139,4090,480,4140,-1,4142,4104,4103,-1,4142,4103,4102,-1,4142,4102,4143,-1,4144,4145,4146,-1,4072,4147,4126,4073,-1,4147,4148,4038,4126,-1,4148,4149,4039,4038,-1,4114,482,4150,4149,-1,4149,4150,4092,4039,-1,485,4151,4121,4098,-1,4135,4121,4151,4152,-1,4152,4151,4120,4136,-1,4118,4135,4152,4153,-1,4153,4152,4136,4116,-1,4116,4115,4154,4153,-1,4153,4154,4117,4118,-1,4054,4057,4155,4156,-1,4156,4155,4058,4059,-1,4108,4054,4156,4157,-1,4157,4156,4059,4109,-1,4085,4108,4157,4158,-1,4158,4157,4109,4086,-1,4076,4085,4158,4159,-1,4159,4158,4086,4079,-1,4077,4076,4159,4160,-1,4160,4159,4079,4078,-1,4041,4043,4161,4162,-1,4162,4161,4046,4045,-1,4043,4132,4163,4161,-1,4161,4163,4133,4046,-1,4132,4124,4164,4163,-1,4163,4164,4123,4133,-1,4100,4123,4164,4165,-1,4165,4164,4124,4095,-1,4094,4100,4165,4166,-1,4166,4165,4095,4088,-1,4053,4094,4166,4167,-1,4167,4166,4088,4048,-1,4048,4051,4168,4167,-1,4167,4168,4052,4053,-1,4128,4052,4168,4169,-1,4169,4168,4051,4129,-1,4061,4128,4169,4062,-1,4062,4169,4129,4063,-1,4170,4171,4172,-1,4171,4173,4172,-1,4174,4175,4176,4177,-1,10721,10722,10723,4178,-1,4175,4179,4180,4176,-1,4179,4175,10730,4181,-1,4042,4041,10731,10732,-1,10737,10730,4175,4174,-1,4181,10730,10738,10740,-1,10748,10749,4036,4035,-1,4171,4170,4182,4183,-1,4184,4183,4182,4185,-1,4081,4083,4069,4186,-1,4187,480,4091,4188,-1,4189,4190,4191,4192,-1,4193,4194,4195,10799,-1,4196,4197,10624,10623,-1,4198,4199,4197,4196,-1,4195,4200,10824,10799,-1,4115,4030,4201,10830,-1,4202,10831,4045,4044,-1,4146,4203,4074,4077,-1,4078,4081,4186,4145,-1,10843,10748,4035,4058,-1,4178,4042,10732,10721,-1,4192,4050,4049,4189,-1,4204,4205,4075,4074,-1,4206,4055,4207,-1,4208,4055,4206,-1,10871,4056,4055,4208,-1,4208,4209,10877,10871,-1,4206,4210,4209,4208,-1,4207,4211,4210,4206,-1,4212,4213,4205,4204,-1,4217,4218,4219,4173,-1,4170,4220,4221,4182,-1,4182};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_22()
		{
			int[] value = {4221,4222,4185,-1,10908,10909,4105,4104,-1,4218,4223,4224,4219,-1,4220,4225,4226,4221,-1,4221,4226,4227,4222,-1,4213,4228,4229,4205,-1,4205,4229,4084,4075,-1,4171,4217,4173,-1,4049,4089,4230,4189,-1,4189,4230,4231,4190,-1,4194,4232,4233,4195,-1,4195,4233,10645,4141,4234,4200,-1,4089,4096,4235,4230,-1,4230,4235,4236,4231,-1,4232,4237,4238,4233,-1,4233,4238,4239,10646,10645,-1,4204,4240,4241,4212,-1,4074,4203,4240,4204,-1,4229,4242,4107,4084,-1,4113,4112,10963,10921,-1,4223,4243,4244,4224,-1,4225,4245,4246,4226,-1,4226,4246,4247,4227,-1,4228,4248,4242,4229,-1,4242,4207,4055,4107,-1,4112,4036,10749,10963,-1,4243,4199,4198,4244,-1,4245,4177,4176,4246,-1,4246,4176,4180,4247,-1,4248,4211,4207,4242,-1,4091,4114,4249,4188,-1,10973,4202,4044,4117,-1,10909,4201,4030,4105,-1,4096,4125,4250,4235,-1,4235,4250,4251,4236,-1,4083,4140,4252,4069,-1,4069,4252,4253,4070,-1,4070,4253,4254,4071,-1,4064,4130,4255,4065,-1,4065,4255,4256,4066,-1,4066,4256,4257,10797,-1,10797,4257,4258,10922,-1,10922,4258,4259,10935,-1,10935,4259,4260,10723,-1,10723,4260,4261,4178,-1,4178,4261,4131,4042,-1,4140,480,4187,4252,-1,4252,4187,4188,4253,-1,4253,4188,4249,4254,-1,4130,4050,4192,4255,-1,4255,4192,4191,4256,-1,4256,4191,4190,4257,-1,4257,4190,4231,4258,-1,4258,4231,4236,4259,-1,4259,4236,4251,4260,-1,4260,4251,4250,4261,-1,4261,4250,4125,4131,-1,4262,4194,4193,10978,-1,10978,4193,10799,10979,-1,4263,4238,4237,11028,-1,11028,4237,4232,4264,-1,4264,4232,4194,4262,-1,4071,4254,4147,4072,-1,4254,4249,4148,4147,-1,4249,4114,4149,4148,-1,4115,10830,4265,4154,-1,4154,4265,10973,4117,-1,4184,4185,4266,4267,-1,4267,4266,4212,4241,-1,4185,4222,4268,4266,-1,4266,4268,4213,4212,-1,4222,4227,4269,4268,-1,4268,4269,4228,4213,-1,4227,4247,4270,4269,-1,4269,4270,4248,4228,-1,4247,4180,4271,4270,-1,4270,4271,4211,4248,-1,4180,4179,4272,4271,-1,4271,4272,4210,4211,-1,4179,4181,4273,4272,-1,4272,4273,4209,4210,-1,4181,10740,4274,4273,-1,4273,4274,10877,4209,-1,10908,4104,4142,4275,-1,4275,4142,4143,10920,-1,10737,4174,4276,10697,-1,10697,4276,4196,10623,-1,4174,4177,4277,4276,-1,4276,4277,4198,4196,-1,4244,4198,4277,4278,-1,4278,4277,4177,4245,-1,4224,4244,4278,4279,-1,4279,4278,4245,4225,-1,4219,4224,4279,4280,-1,4280,4279,4225,4220,-1,4173,4219,4280,4172,-1,4172,4280,4220,4170,-1,4057,10840,11119,4155,-1,4155,11119,10843,4058,-1,4146,4077,4160,4144,-1,4144,4160,4078,4145,-1,10731,4041,4162,11124,-1,11124,4162,4045,10831,-1,10892,4214,10893,11104,10894,4215,10895,11111,10896,4216,4281,4171,4183,4184,4267,4241,4240,4203,-1,4282,4283,4284,-1,11133,11134,4285,-1,4286,4287,4288,-1,4289,4290,4291,-1,4292,4293,4294,4295,-1,4296,4297,4298,4299,-1,4300,4293,4301,-1,4292,4302,4284,4303,-1,4297,4304,4298,-1,4298,4304,4305,-1,4298,4305,4306,4299,-1,4305,4304,4307,-1,4305,4307,4308,4306,-1,4307,4304,4300,4301,-1,4307,4301,4303,4308,-1,4293,4300,4294,-1,4292,4303,4301,4293,-1,4294,4300,4309,4310,-1,4294,4310,4311,4295,-1,4310,4309,4312,-1,4310,4312,4313,4311,-1,4312,4309,11175,4314,-1,4312,4314,4315,4313,-1,4314,11175,11176,-1,4314,11176,11177,4315,-1,4318,4319,4317,4316,-1,4320,4321,4319,4318,-1,4308,4322,4323,4306,-1,4326,4327,4328,4329,-1,4290,4330,4331,4291,-1,4332,4333,4334,4335,-1,4321,4320,4338,-1,4339,4338,11319,11320,-1,4340,4341,4289,-1,4330,4290,4342,4343,-1,4341,4340,11323,11324,-1,4343,4342,11326,11325,-1,4344,4345,4346,-1,4324,4347,4346,4348,-1,11233,11137,4345,4344,-1,11328,11327,4349,-1,4350,11331,11332,-1,4351,4352,11333,11334,-1,11335,11336,4353,4354,-1,4353,4282,4302,4354,-1,4295,4355,4302,4292,-1,4315,4356,4313,-1,4313,4356,4357,4311,-1,4311,4357,4355,4295,-1,11177,11337,4356,4315,-1,4358,4359,11341,11342,-1,4328,11358,11357,4329,-1,4299,4365,4364,4296,-1,4369,4368,4370,4371,-1,4372,4367,4366,-1,4359,4358,4372,4373,-1,4352,4351,4371,4370,-1,4306,4323,4365,4299,-1,4303,4284,4322,4308,-1,4376,4375,4374,4377,-1,4378,4379,4376,4377,-1,4380,4381,4379,4378,-1,4381,4380,11320,-1,4284,4283,4382,4322,-1,4383,4365,4323,4384,-1,4370,4382,4283,4352,-1,4351,4359,4373,4371,-1,4366,4385,4373,4372,-1,4373,4385,4369,4371,-1,4368,4384,4382,4370,-1,4368,4362,4383,4384,-1,4369,4385,623,600,-1,4365,4383,4363,4364,-1,4383,4362,4363,-1,11357,11384,4387,4329,-1,4329,4387,4388,4326,-1,4360,4390,4391,4327,-1,4386,4367,4372,4392,-1,4326,4388,4389,4361,-1,4328,4327,4391,4393,-1,4393,4391,4392,4285,-1,4328,4393,11385,11358,-1,11134,11385,4393,4285,-1,11342,11133,4285,4358,-1,4285,4392,4372,4358,-1,4394,4356,11337,11395,-1,4394,4357,4356,-1,4354,4394,11395,11335,-1,4302,4355,4394,4354,-1,4283,4282,4353,-1,4351,11334,11341,4359,-1,11394,4283,4353,11336,-1,4283,11394,11333,4352,-1,11396,4395,11397,-1,11397,4395,4396,11398,-1,4387,11384,11402,4397,-1,4397,11402,11331,4350,-1,4350,11332,11398};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_23()
		{
			int[] value = {4396,-1,4398,4388,4387,4397,-1,4396,4399,4400,4350,-1,4398,4401,635,4389,-1,4398,4389,4388,-1,4403,4404,11136,11407,-1,4403,4346,4404,-1,4345,11137,11136,4404,-1,4395,11396,11233,4344,-1,4399,4407,4406,4405,-1,4399,4405,4402,4400,-1,4403,11407,11404,4408,-1,4408,4348,4346,4403,-1,4345,4404,4346,-1,4408,11404,11328,4349,-1,4346,4347,4406,4407,-1,4346,4407,4395,4344,-1,11410,11408,4409,4286,-1,4288,11413,11410,4286,-1,4288,4287,4348,4349,-1,4411,11322,11415,4412,-1,4343,11325,11322,4411,-1,4341,11324,11326,4342,-1,4289,4341,4342,4290,-1,4289,4291,4413,4414,-1,4289,4414,4409,4340,-1,4338,4339,4415,4321,-1,4377,4374,4416,4417,-1,4378,4418,4419,4380,-1,4378,4377,4417,4418,-1,11320,4419,4339,-1,4338,4410,11416,11319,-1,4410,4338,4320,4420,-1,4420,4320,4318,4421,-1,4421,4318,4316,4422,-1,4330,4343,4411,4334,-1,4330,4334,4333,4331,-1,4334,4411,4412,4335,-1,4423,4336,4332,4335,-1,4421,4422,4337,4424,-1,4424,4337,4336,4423,-1,4412,4420,4421,4424,-1,4412,11415,4410,4420,-1,4423,4335,4412,-1,4395,4407,4399,4396,-1,4408,4349,4348,-1,4424,4423,4412,-1,4400,4402,4401,4398,-1,4398,4397,4350,4400,-1,11413,4288,4349,11327,-1,4409,11408,11323,4340,-1,4409,4414,4287,4286,-1,4325,4324,4348,4287,-1,4414,4413,4325,4287,-1,4382,4384,4323,4322,-1,4380,4419,11320,-1,4416,4425,4426,4417,-1,4418,4417,4426,4415,-1,4319,4321,4415,4426,-1,4319,4426,4425,4317,-1,4339,4419,4418,4415,-1,4361,4360,4327,4326,-1,4392,4391,4390,4386,-1,4302,4282,4284,-1,4394,4355,4357,-1,4434,4435,4436,4437,-1,4435,699,4439,4436,-1,4440,4441,4442,4443,-1,4443,4436,4439,4440,-1,4439,4444,4445,4440,-1,4440,4445,4446,4441,-1,4447,4448,4449,4450,-1,4451,4452,4453,-1,4454,703,4448,4447,-1,4432,4438,4456,4457,-1,4457,4456,699,4435,-1,4433,4432,4457,4458,-1,4458,4457,4435,4434,-1,4460,4461,4462,-1,4463,4464,4465,4466,-1,4466,4465,4467,4468,-1,4462,4468,4467,4460,-1,4462,4469,4468,-1,4471,4472,4428,4427,-1,721,4470,4473,-1,4474,4464,4463,4472,4471,-1,4475,4476,4461,4477,-1,4478,4479,4480,4481,-1,4480,4479,4482,4483,-1,4484,4485,4486,4487,-1,4489,4490,4491,4492,-1,4493,4494,4495,-1,4430,4429,4494,4493,-1,4453,4496,696,4433,-1,4434,4437,4497,4452,-1,4498,4471,4427,4431,-1,4499,4474,4471,4498,-1,4500,4475,4477,4501,-1,4504,4494,4429,4503,-1,4505,4491,4490,4506,-1,4506,4507,4508,4505,-1,4503,733,4509,4504,-1,4510,4475,4500,4511,-1,4512,4492,4491,4513,-1,4513,4491,4505,4514,-1,4514,4505,4508,4515,-1,4516,4481,4480,4517,-1,4517,4480,4483,4518,-1,4519,4484,4487,4520,-1,4460,4521,4477,4461,-1,4477,4521,4522,4501,-1,4489,4523,4524,4490,-1,4490,4524,4525,4506,-1,4506,4525,4526,4507,-1,4478,4527,4528,4479,-1,4479,4528,4529,4482,-1,4485,4530,4531,4486,-1,4460,4467,4532,4521,-1,4521,4532,4533,4522,-1,4523,4534,4535,4524,-1,4524,4535,4536,4525,-1,4525,4536,4537,4526,-1,4527,4538,4539,4528,-1,4528,4539,4540,4529,-1,4530,4447,4450,4531,-1,4442,4441,4541,4542,-1,4468,4469,4542,4541,-1,4502,4543,752,737,-1,696,4496,4543,4502,-1,4441,4446,4544,4541,-1,4541,4544,4466,4468,-1,4467,4465,4545,4532,-1,4532,4545,4546,4533,-1,4534,4547,4548,4535,-1,4535,4548,4549,4536,-1,4536,4549,4550,4537,-1,4538,4551,4552,4539,-1,4539,4552,754,4540,-1,4446,4428,4472,4544,-1,4544,4472,4463,4466,-1,4465,4464,4474,4545,-1,4545,4474,4499,4546,-1,4547,4495,4494,4548,-1,4548,4494,4504,4549,-1,4549,4504,4509,4550,-1,4551,4473,4470,4552,-1,721,4473,4554,768,-1,4550,4509,4554,4555,-1,4555,4554,4473,4551,-1,4515,4508,4556,4557,-1,4557,4556,4481,4516,-1,4478,4481,4556,4558,-1,4558,4556,4508,4507,-1,4507,4526,4559,4558,-1,4558,4559,4527,4478,-1,4526,4537,4560,4559,-1,4559,4560,4538,4527,-1,4537,4550,4555,4560,-1,4560,4555,4551,4538,-1,4540,754,703,4454,-1,4529,4540,4454,4561,-1,4561,4454,4447,4530,-1,4482,4529,4561,4562,-1,4562,4561,4530,4485,-1,4483,4482,4562,4563,-1,4563,4562,4485,4484,-1,4518,4483,4563,4564,-1,4564,4563,4484,4519,-1,4533,4546,4565,4566,-1,4566,4565,4547,4534,-1,4522,4533,4566,4567,-1,4567,4566,4534,4523,-1,4501,4522,4567,4568,-1,4568,4567,4523,4489,-1,4489,4492,4569,4568,-1,4568,4569,4500,4501,-1,4511,4500,4569,4570,-1,4570,4569,4492,4512,-1,4546,4499,4571,4565,-1,4565,4571,4495,4547,-1,4493,4495,4571,4572,-1,4572,4571,4499,4498,-1,4430,4493,4572,4455,-1,4455,4572,4498,4431,-1,4453,4433,4458,4451,-1,4451,4458,4434,4452,-1,4476,4475,4510,-1,4436,4443,4437,-1,4442,4542,4469,4462,4461,4476,4510,4511,4570,4512,4513,4514,4515,4557,4516,4517,4518,4564,4519,4520,4573,4459,723,4488,4553,752,4543,4496,4453,4452,4497,4437,4443,-1,4574,4575,4576,4577,-1,4578,4579,4580,4581,-1,778,4582,4583,4584,-1,4585,4586,4587,4588,-1,4589,4590,4586,4585,-1,4591,4592,4590,4589,-1,4593,4594,4592,4591,-1,4595,4596,4594,4593,-1,4597,4598,4596,4595,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_24()
		{
			int[] value = {4599,4600,4598,4597,-1,4601,4602,4600,4599,-1,4604,4605,791,4603,-1,4606,4607,4605,4604,-1,4608,4609,4607,4606,-1,4610,4611,4609,4608,-1,4612,4613,4611,4610,-1,4614,4615,4613,4612,-1,4588,4587,4615,4614,-1,4586,4616,4617,4587,-1,4590,4618,4616,4586,-1,4592,4619,4618,4590,-1,4594,4620,4619,4592,-1,4596,4621,4620,4594,-1,4598,4574,4621,4596,-1,4600,4575,4574,4598,-1,4602,4622,4575,4600,-1,4605,4576,798,791,-1,4607,4577,4576,4605,-1,4609,4623,4577,4607,-1,4611,4624,4623,4609,-1,4613,4625,4624,4611,-1,4615,4626,4625,4613,-1,4587,4617,4626,4615,-1,4575,4622,798,4576,-1,4623,4624,4620,4621,-1,4621,4574,4577,4623,-1,4625,4626,4618,4619,-1,4619,4620,4624,4625,-1,4626,4617,4616,4618,-1,4627,4628,4579,4578,-1,4628,4627,4584,4583,-1,4629,4630,4631,4632,-1,4630,4629,4581,4580,-1,4632,4631,4633,4634,-1,4588,4634,4633,4585,-1,4614,4632,4634,4588,-1,4612,4629,4632,4614,-1,4610,4581,4629,4612,-1,4608,4578,4581,4610,-1,4606,4627,4578,4608,-1,4604,4584,4627,4606,-1,4603,778,4584,4604,-1,4599,4583,4582,4601,-1,4597,4628,4583,4599,-1,4595,4579,4628,4597,-1,4593,4580,4579,4595,-1,4591,4630,4580,4593,-1,4589,4631,4630,4591,-1,4585,4633,4631,4589,-1,4635,4636,4637,4638,-1,4638,4637,4639,4640,-1,4640,4639,4641,4642,-1,4642,4641,4643,4644,-1,4644,4643,4645,4646,-1,4647,4648,4649,4650,-1,4636,4651,4652,4637,-1,4637,4652,4653,4639,-1,4639,4653,4654,4641,-1,4641,4654,4655,4643,-1,4643,4655,4656,4645,-1,4648,4657,4658,4649,-1,4651,4659,4660,4652,-1,4652,4660,4661,4653,-1,4653,4661,4662,4654,-1,4654,4662,4663,4655,-1,4655,4663,4664,4656,-1,4657,4665,4666,4658,-1,4659,4667,4668,4660,-1,4660,4668,4669,4661,-1,4661,4669,4670,4662,-1,4662,4670,4671,4663,-1,4663,4671,4672,4664,-1,4665,4673,4674,4666,-1,4667,4675,4676,4668,-1,4668,4676,4677,4669,-1,4669,4677,4678,4670,-1,4670,4678,4679,4671,-1,4671,4679,4680,4672,-1,4673,4681,4682,4674,-1,4675,801,4683,4676,-1,4676,4683,4684,4677,-1,4677,4684,4685,4678,-1,4678,4685,4686,4679,-1,4679,4686,4687,4680,-1,4681,802,4688,4682,-1,4689,4690,4691,4692,-1,4675,831,830,801,-1,4667,4693,831,4675,-1,4659,4694,4693,4667,-1,4651,4695,4694,4659,-1,4636,4696,4695,4651,-1,4635,4697,4696,4636,-1,4691,4698,4699,4692,-1,4700,4701,4702,4703,-1,4704,4705,4701,4700,-1,4706,4707,4705,4704,-1,4708,4709,4707,4706,-1,4710,4711,4709,4708,-1,832,4712,4711,4710,-1,4693,4713,842,831,-1,4694,4714,4713,4693,-1,4695,4715,4714,4694,-1,4696,4716,4715,4695,-1,4697,4717,4716,4696,-1,4698,4718,4719,4699,-1,4701,4720,4721,4702,-1,4705,4722,4720,4701,-1,4707,4723,4722,4705,-1,4709,4724,4723,4707,-1,4711,4725,4724,4709,-1,4712,4726,4725,4711,-1,4717,4727,4728,4716,-1,4718,4729,4730,4719,-1,4720,4731,4732,4721,-1,4722,4733,4731,4720,-1,4723,4734,4733,4722,-1,4724,4735,4734,4723,-1,4725,4736,4735,4724,-1,4726,4737,4736,4725,-1,4713,4740,4739,842,-1,4714,4741,4740,4713,-1,4715,4742,4741,4714,-1,4716,4728,4742,4715,-1,4727,4650,4649,4728,-1,4729,4743,4744,4730,-1,4731,4648,4647,4732,-1,4733,4657,4648,4731,-1,4734,4665,4657,4733,-1,4735,4673,4665,4734,-1,4736,4681,4673,4735,-1,4737,802,4681,4736,-1,4739,4682,4688,4738,-1,4740,4674,4682,4739,-1,4741,4666,4674,4740,-1,4742,4658,4666,4741,-1,4728,4649,4658,4742,-1,4689,4745,4746,4690,-1,4644,4690,4746,4642,-1,4646,4691,4690,4644,-1,4702,4698,4691,4703,-1,4721,4718,4698,4702,-1,4732,4729,4718,4721,-1,4647,4743,4729,4732,-1,4650,4744,4743,4647,-1,4727,4730,4744,4650,-1,4717,4719,4730,4727,-1,4697,4699,4719,4717,-1,4635,4692,4699,4697,-1,4638,4689,4692,4635,-1,4640,4745,4689,4638,-1,4642,4746,4745,4640,-1,4747,4748,4656,4664,-1,4706,4704,4748,4747,-1,4748,4749,4645,4656,-1,4704,4700,4749,4748,-1,4749,4750,4646,4645,-1,4700,4703,4750,4749,-1,4751,4747,4664,4672,-1,4708,4706,4747,4751,-1,4752,4751,4672,4680,-1,4710,4708,4751,4752,-1,4753,4752,4680,4687,-1,832,4710,4752,4753,-1,4750,4691,4646,-1,4750,4703,4691,-1,4754,4755,4756,4757,-1,4755,4754,4758,-1,4759,4757,4756,-1,4760,4761,4757,4759,-1,4762,4763,4761,4760,-1,4764,4765,4763,4762,-1,4766,4767,4765,4764,-1,4768,4769,4767,4766,-1,854,4770,4769,4768,-1,4773,4774,4772,4771,-1,4775,4776,4774,4773,-1,4777,4778,4776,4775,-1,4779,4780,4778,4777,-1,4781,4782,4780,4779,-1,4758,4754,4782,4781,-1,4757,4761,4782,4754,-1,4763,4765,4778,4780,-1,4765,4767,4776,4778,-1,4767,4769,4774,4776,-1,4769,4770,4772,4774,-1,4761,4763,4780,4782,-1,4783,4784,4785,4786,-1,4784,4787,4788,4785,-1,4787,4789,4790,4788,-1,4789,4791,4792,4790,-1,4791,4793,4794,4792,-1,4793,871,4795,4794,-1,4786,4796,4797,4783,-1,4768,4799,4798,854,-1,4766,4800,4799,4768,-1,4764,4801,4800,4766,-1,4762,4802,4801,4764,-1,4760,4803,4802,4762,-1,4759,4804,4803,4760,-1,4756,4805,4804,4759};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_25()
		{
			int[] value = {-1,4755,4806,4805,4756,-1,4758,4807,4806,4755,-1,4781,4808,4807,4758,-1,4779,4809,4808,4781,-1,4777,4810,4809,4779,-1,4775,4811,4810,4777,-1,4773,4812,4811,4775,-1,4771,4813,4812,4773,-1,4799,4794,4795,4798,-1,4800,4792,4794,4799,-1,4801,4790,4792,4800,-1,4802,4788,4790,4801,-1,4803,4785,4788,4802,-1,4804,4786,4785,4803,-1,4805,4796,4786,4804,-1,4806,4797,4796,4805,-1,4807,4783,4797,4806,-1,4808,4784,4783,4807,-1,4809,4787,4784,4808,-1,4810,4789,4787,4809,-1,4811,4791,4789,4810,-1,4812,4793,4791,4811,-1,4813,871,4793,4812,-1,4814,4815,4816,4817,-1,4818,4817,4816,-1,4815,4814,4819,-1,4819,4814,4820,4821,-1,4821,4820,4822,4823,-1,4823,4822,4824,4825,-1,4825,4824,4826,4827,-1,4827,4826,4828,4829,-1,4829,4828,888,4830,-1,905,4831,4832,4833,-1,4833,4832,4834,4835,-1,4835,4834,4836,4837,-1,4837,4836,4838,4839,-1,4839,4838,4840,4841,-1,4841,4840,4817,4818,-1,4817,4840,4820,4814,-1,4838,4836,4824,4822,-1,4836,4834,4826,4824,-1,4834,4832,4828,4826,-1,4832,4831,888,4828,-1,4840,4838,4822,4820,-1,4842,4843,4844,4845,-1,4843,4846,4847,4844,-1,4846,4848,4849,4847,-1,4848,4850,4851,4849,-1,4850,4852,4853,4851,-1,4845,4855,4856,4842,-1,4830,4857,4858,4829,-1,4829,4858,4859,4827,-1,4827,4859,4860,4825,-1,4825,4860,4861,4823,-1,4823,4861,4862,4821,-1,4821,4862,4863,4819,-1,4819,4863,4864,4815,-1,4815,4864,4865,4816,-1,4816,4865,4866,4818,-1,4818,4866,4867,4841,-1,4841,4867,4868,4839,-1,4839,4868,4869,4837,-1,4837,4869,4870,4835,-1,4835,4870,4871,4833,-1,4833,4871,4872,905,-1,4857,906,4852,4858,-1,4858,4852,4850,4859,-1,4859,4850,4848,4860,-1,4860,4848,4846,4861,-1,4861,4846,4843,4862,-1,4862,4843,4842,4863,-1,4863,4842,4856,4864,-1,4864,4856,4855,4865,-1,4865,4855,4845,4866,-1,4866,4845,4844,4867,-1,4867,4844,4847,4868,-1,4868,4847,4849,4869,-1,4869,4849,4851,4870,-1,4870,4851,4853,4871,-1,4871,4853,4854,4872,-1,4873,4874,4875,4876,-1,4877,4876,4875,-1,4874,4873,4878,-1,4878,4873,4879,4880,-1,4880,4879,4881,4882,-1,4882,4881,4883,4884,-1,4884,4883,4885,4886,-1,4886,4885,4887,4888,-1,4888,4887,923,4889,-1,940,4890,4891,4892,-1,4892,4891,4893,4894,-1,4894,4893,4895,4896,-1,4896,4895,4897,4898,-1,4898,4897,4899,4900,-1,4900,4899,4876,4877,-1,4876,4899,4879,4873,-1,4897,4895,4883,4881,-1,4895,4893,4885,4883,-1,4893,4891,4887,4885,-1,4891,4890,923,4887,-1,4899,4897,4881,4879,-1,4901,4902,4903,4904,-1,4902,4905,4906,4903,-1,4905,4907,4908,4906,-1,4907,4909,4910,4908,-1,4909,4911,4912,4910,-1,4911,941,4913,4912,-1,4904,4914,4915,4901,-1,4889,4916,4917,4888,-1,4888,4917,4918,4886,-1,4886,4918,4919,4884,-1,4884,4919,4920,4882,-1,4882,4920,4921,4880,-1,4880,4921,4922,4878,-1,4878,4922,4923,4874,-1,4874,4923,4924,4875,-1,4875,4924,4925,4877,-1,4877,4925,4926,4900,-1,4900,4926,4927,4898,-1,4898,4927,4928,4896,-1,4896,4928,4929,4894,-1,4894,4929,4930,4892,-1,4892,4930,4931,940,-1,4916,941,4911,4917,-1,4917,4911,4909,4918,-1,4918,4909,4907,4919,-1,4919,4907,4905,4920,-1,4920,4905,4902,4921,-1,4921,4902,4901,4922,-1,4922,4901,4915,4923,-1,4923,4915,4914,4924,-1,4924,4914,4904,4925,-1,4925,4904,4903,4926,-1,4926,4903,4906,4927,-1,4927,4906,4908,4928,-1,4928,4908,4910,4929,-1,4929,4910,4912,4930,-1,4930,4912,4913,4931,-1,4932,4933,4934,4935,-1,4936,4937,4938,4939,-1,4940,4941,962,4942,-1,4943,4944,4945,4946,-1,4946,4945,4947,4948,-1,4948,4947,4949,4950,-1,4950,4949,4951,4952,-1,4952,4951,4953,4954,-1,4954,4953,4955,4956,-1,4956,4955,4957,4958,-1,4958,4957,963,964,-1,4960,4959,4961,4962,-1,4962,4961,4963,4964,-1,4964,4963,4965,4966,-1,4966,4965,4967,4968,-1,4968,4967,4969,4970,-1,4970,4969,4971,4972,-1,4972,4971,4944,4943,-1,4944,4973,4974,4945,-1,4945,4974,4975,4947,-1,4947,4975,4976,4949,-1,4949,4976,4977,4951,-1,4951,4977,4978,4953,-1,4953,4978,4935,4955,-1,4955,4935,4934,4957,-1,4957,4934,977,963,-1,4959,4979,4933,4961,-1,4961,4933,4932,4963,-1,4963,4932,4980,4965,-1,4965,4980,4981,4967,-1,4967,4981,4982,4969,-1,4969,4982,4983,4971,-1,4971,4983,4973,4944,-1,4933,4979,977,4934,-1,4978,4977,4981,4980,-1,4980,4932,4935,4978,-1,4976,4975,4983,4982,-1,4982,4981,4977,4976,-1,4975,4974,4973,4983,-1,4939,4938,4984,4985,-1,4941,4940,4985,4984,-1,4986,4987,4988,4989,-1,4937,4936,4989,4988,-1,4990,4991,4987,4986,-1,4946,4991,4990,4943,-1,4943,4990,4986,4972,-1,4972,4986,4989,4970,-1,4970,4989,4936,4968,-1,4968,4936,4939,4966,-1,4966,4939,4985,4964,-1,4964,4985,4940,4962,-1,4962,4940,4942,4960,-1,964,962,4941,4958,-1,4958,4941,4984,4956,-1,4956,4984,4938,4954,-1,4954,4938,4937,4952,-1,4952,4937,4988,4950,-1,4950,4988,4987,4948,-1,4948,4987,4991,4946,-1,10920,4143,4113,10921,-1,4143,4102,4113,-1,4102,4082,4101,4113,-1,10636,11117,10891,10892};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_26()
		{
			int[] value = {4203,4146,4145,4186,4069,-1,4992,4993,4994,-1,4995,4996,4997,4998,-1,1262,4999,5000,5001,-1,5002,5003,5004,-1,5005,5006,5007,5008,-1,5009,5010,5011,5012,-1,1263,1262,5001,5013,-1,12722,5014,5015,5016,-1,5017,4997,4996,5018,-1,5019,5020,5021,5022,5023,12723,12724,12725,12726,12727,12728,12729,12730,12731,12732,12733,12734,12735,12736,5024,5025,5026,5027,5028,5029,5030,-1,5031,5032,5033,5034,-1,5035,5036,5037,5038,-1,5039,5040,5036,5035,-1,5032,5041,5042,5033,-1,5036,5043,5044,5037,-1,5011,5045,5046,5012,-1,5050,5043,5036,5040,-1,5051,5052,5040,5039,-1,5039,5053,5054,5055,5051,-1,5041,5056,5057,5042,-1,5043,5058,5059,5044,-1,5050,5060,5058,5043,-1,5061,5062,5060,5050,-1,5056,5016,5015,5057,-1,5058,4997,5017,5059,-1,5060,4998,4997,5058,-1,5062,4995,4998,5060,-1,4993,5064,5065,4994,-1,5066,5005,5008,5067,-1,5053,4992,4994,5054,-1,5049,5073,1277,1269,-1,5030,5074,5075,5019,-1,5029,5076,5074,5030,-1,5026,5077,5078,5027,-1,5002,5079,5080,5003,-1,5005,5081,5082,5006,-1,5066,5083,5081,5005,-1,4993,5084,5085,5064,-1,4992,5086,5084,4993,-1,5053,5087,5086,4992,-1,5039,5088,5087,5053,-1,5074,5001,5000,5075,-1,5076,5013,5001,5074,-1,5077,5010,5009,5078,-1,5079,1277,5073,5080,-1,5081,5071,5072,5082,-1,5083,1276,5071,5081,-1,5086,5069,5068,5084,-1,5087,5048,5069,5086,-1,5088,1265,5048,5087,-1,5051,5055,5091,-1,5052,5051,5091,-1,5092,5052,5091,-1,5093,5094,5095,-1,5019,5075,5096,5020,-1,5075,5000,5097,5096,-1,5000,4999,5098,5097,-1,5100,5099,1276,5083,-1,5085,5070,5099,5100,-1,5101,5100,5083,5066,-1,5064,5085,5100,5101,-1,5101,5102,5065,5064,-1,5066,5067,5102,5101,-1,5103,5104,12722,5016,-1,5017,5018,5104,5103,-1,5105,5103,5016,5056,-1,5059,5017,5103,5105,-1,5106,5105,5056,5041,-1,5044,5059,5105,5106,-1,5107,5106,5041,5032,-1,5037,5044,5106,5107,-1,5108,5107,5032,5031,-1,5038,5037,5107,5108,-1,5109,5110,5002,5004,-1,5007,5006,5110,5109,-1,5110,5111,5079,5002,-1,5006,5082,5111,5110,-1,5111,5112,1277,5079,-1,5082,5072,5112,5111,-1,5012,5046,5113,5114,-1,5114,5115,5009,5012,-1,1263,5013,5115,5114,-1,5116,5115,5013,5076,-1,5078,5009,5115,5116,-1,5028,5116,5076,5029,-1,5027,5078,5116,5028,-1,5117,4171,5118,-1,5117,5119,4171,-1,5120,5121,5122,5123,-1,5124,12808,12809,5125,-1,5121,5126,5127,5122,-1,5128,12812,5122,5127,-1,5129,5130,5004,5003,-1,5123,5122,12812,12813,-1,12816,12815,12812,5128,-1,4996,4995,12817,5131,-1,5132,5133,5118,4171,-1,5134,5133,5132,5135,-1,5136,5023,5039,5035,-1,5139,5140,5141,5142,-1,12842,5144,5145,5146,-1,12720,10624,4197,5147,-1,5147,4197,4199,5148,-1,12842,12843,12844,5144,-1,12850,5149,4994,5065,-1,5008,5007,12851,5150,-1,5031,5034,5151,5093,-1,5094,5136,5035,5038,-1,5018,4996,5131,5152,-1,5125,5129,5003,5124,-1,5142,5011,5010,5139,-1,5034,5033,5153,5154,-1,5155,5015,5156,-1,5156,5015,5157,-1,5157,5015,5014,5158,-1,5158,5159,5160,5157,-1,5157,5160,5161,5156,-1,5156,5161,5162,5155,-1,5154,5153,5163,5164,-1,5119,5168,4218,4217,-1,5133,5169,5170,5118,-1,5134,5171,5169,5133,-1,5055,5054,5172,5173,-1,5168,5174,4223,4218,-1,5169,5175,5176,5170,-1,5171,5177,5175,5169,-1,5153,5178,5179,5163,-1,5033,5042,5178,5153,-1,5119,4217,4171,-1,5142,5181,5045,5011,-1,5141,5182,5181,5142,-1,5144,5184,5185,5145,-1,12844,12899,12744,5090,5184,5144,-1,5181,5186,5049,5045,-1,5182,5187,5186,5181,-1,5184,5188,5189,5185,-1,5090,5089,12912,5188,5184,-1,5164,5190,5191,5154,-1,5154,5191,5151,5034,-1,5042,5057,5192,5178,-1,5180,12924,5062,5061,-1,5174,5193,4243,4223,-1,5175,5194,5195,5176,-1,5177,5196,5194,5175,-1,5178,5192,5197,5179,-1,5057,5015,5155,5192,-1,12924,12817,4995,5062,-1,5193,5148,4199,4243,-1,5194,5121,5120,5195,-1,5196,5126,5121,5194,-1,5192,5155,5162,5197,-1,5137,5198,5063,5047,-1,5067,5008,5150,5199,-1,5054,4994,5149,5172,-1,5186,5200,5073,5049,-1,5187,5201,5200,5186,-1,5023,5202,5088,5039,-1,5022,5203,5202,5023,-1,5021,5204,5203,5022,-1,5025,5205,5077,5026,-1,5024,5206,5205,5025,-1,5143,5207,5206,5024,-1,5183,5208,5207,5143,-1,12911,5209,5208,5183,-1,12808,5210,5209,12911,-1,5124,5211,5210,12808,-1,5003,5080,5211,5124,-1,5202,5138,1265,5088,-1,5203,5137,5138,5202,-1,5204,5198,5137,5203,-1,5205,5139,5010,5077,-1,5206,5140,5139,5205,-1,5207,5141,5140,5206,-1,5208,5182,5141,5207,-1,5209,5187,5182,5208,-1,5210,5201,5187,5209,-1,5211,5200,5201,5210,-1,5080,5073,5200,5211,-1,5212,5146,5145,12938,-1,12940,12842,5146,5212,-1,5214,5189,5188,5213,-1,12946,5185,5189,5214,-1,12938,5145,5185,12946,-1,5020,5096,5204,5021,-1,5096,5097,5198,5204,-1,5097,5098,5063,5198,-1,5102,12956,12850,5065,-1,5067,5199,12956,5102,-1,5215,5216,5134,5135,-1,5190,5164,5216,5215,-1,5216,5217,5171,5134,-1,5164,5163,5217,5216,-1,5217,5218,5177,5171,-1,5163,5179,5218,5217,-1,5218,5219,5196,5177,-1,5179,5197,5219,5218};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_27()
		{
			int[] value = {-1,5219,5220,5126,5196,-1,5197,5162,5220,5219,-1,5220,5221,5127,5126,-1,5162,5161,5221,5220,-1,5221,5222,5128,5127,-1,5161,5160,5222,5221,-1,5222,12961,12816,5128,-1,5160,5159,12961,5222,-1,5223,5091,5055,5173,-1,12897,5092,5091,5223,-1,12794,5224,5123,12813,-1,12720,5147,5224,12794,-1,5224,5225,5120,5123,-1,5147,5148,5225,5224,-1,5226,5225,5148,5193,-1,5195,5120,5225,5226,-1,5227,5226,5193,5174,-1,5176,5195,5226,5227,-1,5228,5227,5174,5168,-1,5170,5176,5227,5228,-1,5117,5228,5168,5119,-1,5118,5170,5228,5117,-1,5104,12980,12862,12722,-1,5018,5152,12980,5104,-1,5095,5108,5031,5093,-1,5094,5038,5108,5095,-1,5229,5109,5004,5130,-1,12851,5007,5109,5229,-1,5151,5191,5190,5215,5135,5132,4171,4281,4216,5167,12972,12876,12875,5166,12964,12874,12873,12872,-1,5180,5061,5092,12897,-1,5061,5052,5092,-1,5061,5050,5040,5052,-1,5023,5136,5094,5093,5151,12872,5165,12978,12723,-1,5230,5231,5232,-1,5233,13204,13205,-1,5234,5235,5236,-1,5237,5238,5239,-1,5240,5241,5242,5243,-1,5246,5242,5247,-1,5248,5230,5249,5243,-1,5253,5252,5245,-1,5244,5254,5253,5245,-1,5255,5252,5253,-1,5254,5256,5255,5253,-1,5246,5247,5252,5255,-1,5256,5248,5246,5255,-1,5241,5247,5242,-1,5242,5246,5248,5243,-1,5257,5258,5247,5241,-1,5240,5259,5257,5241,-1,5260,5258,5257,-1,5259,5261,5260,5257,-1,5262,13243,5258,5260,-1,5261,5263,5262,5260,-1,13244,13243,5262,-1,5263,13245,13244,5262,-1,5265,5264,5266,5267,-1,5267,5266,5268,5269,-1,5254,5270,5271,5256,-1,5274,5275,5276,5277,-1,5237,5278,5279,5238,-1,5280,5281,5282,5283,-1,5286,5269,5268,-1,11320,13383,5286,5287,-1,5239,5288,5289,-1,5290,5291,5238,5279,-1,13386,13387,5289,5288,-1,13389,13388,5291,5290,-1,5292,5293,5294,-1,5295,5292,5296,5273,-1,5294,5293,13206,13299,-1,5297,13393,13392,-1,13394,13395,5298,-1,13396,13397,5299,5300,-1,5301,5302,13398,13399,-1,5301,5249,5232,5302,-1,5243,5249,5303,5240,-1,5261,5304,5263,-1,5259,5305,5304,5261,-1,5240,5303,5305,5259,-1,5263,5304,13400,13245,-1,13404,13405,5306,5307,-1,5274,13421,13420,5275,-1,5310,5311,5251,5250,-1,5317,5318,5316,5315,-1,5314,5313,5319,-1,5320,5319,5307,5306,-1,5318,5317,5300,5299,-1,5244,5312,5270,5254,-1,5256,5271,5230,5248,-1,5322,5321,4375,4376,-1,5322,4376,4379,5323,-1,5323,4379,4381,5324,-1,11320,5324,4381,-1,5271,5325,5231,5230,-1,5326,5270,5312,5327,-1,5299,5231,5325,5318,-1,5317,5320,5306,5300,-1,5319,5320,5328,5314,-1,5317,5315,5328,5320,-1,5318,5325,5326,5316,-1,5326,5327,1395,5316,-1,5251,5311,1398,1397,-1,5274,5330,13437,13421,-1,5277,5331,5330,5274,-1,5276,5334,5333,5309,-1,5335,5319,5313,5329,-1,5308,5332,5331,5277,-1,5336,5334,5276,5275,-1,5233,5335,5334,5336,-1,13420,13439,5336,5275,-1,5233,5336,13439,13204,-1,5307,5233,13205,13404,-1,5307,5319,5335,5233,-1,13449,13400,5304,5337,-1,5304,5305,5337,-1,13399,13449,5337,5301,-1,5301,5337,5303,5249,-1,5302,5232,5231,-1,5306,13405,13396,5300,-1,13398,5302,5231,13448,-1,5299,13397,13448,5231,-1,13450,5338,13451,-1,13452,5339,5338,13450,-1,5340,13457,13437,5330,-1,5298,13395,13457,5340,-1,5339,13452,13394,5298,-1,5340,5330,5331,5341,-1,5298,5342,5343,5339,-1,5332,1423,5344,5341,-1,5331,5332,5341,-1,13460,13207,5346,5347,-1,5346,5292,5347,-1,5346,13207,13206,5293,-1,5294,13299,13451,5338,-1,5348,5349,5350,5343,-1,5342,5345,5348,5343,-1,5351,13459,13460,5347,-1,5347,5292,5295,5351,-1,5292,5346,5293,-1,5297,13392,13459,5351,-1,5350,5349,5296,5292,-1,5294,5338,5350,5292,-1,5236,5352,13463,13464,-1,5236,13464,13465,5234,-1,5297,5295,5235,5234,-1,5354,13469,13384,5355,-1,5355,13384,13389,5290,-1,5291,13388,13386,5288,-1,5238,5291,5288,5239,-1,5356,5357,5237,5239,-1,5289,5352,5356,5239,-1,5268,5358,5287,5286,-1,5360,5359,5321,5322,-1,5324,5361,5362,5323,-1,5362,5360,5322,5323,-1,5287,5361,11320,-1,13383,13470,5353,5286,-1,5363,5269,5286,5353,-1,5364,5267,5269,5363,-1,5365,5265,5267,5364,-1,5281,5355,5290,5279,-1,5278,5282,5281,5279,-1,5280,5354,5355,5281,-1,5280,5283,5285,5366,-1,5367,5284,5365,5364,-1,5366,5285,5284,5367,-1,5367,5364,5363,5354,-1,5363,5353,13469,5354,-1,5354,5280,5366,-1,5339,5343,5350,5338,-1,5295,5297,5351,-1,5354,5366,5367,-1,5341,5344,5345,5342,-1,5342,5298,5340,5341,-1,13393,5297,5234,13465,-1,5289,13387,13463,5352,-1,5236,5235,5356,5352,-1,5235,5295,5273,5272,-1,5235,5272,5357,5356,-1,5271,5270,5326,5325,-1,11320,5361,5324,-1,5360,5369,5368,5359,-1,5358,5369,5360,5362,-1,5369,5358,5268,5266,-1,5264,5368,5369,5266,-1,5358,5362,5361,5287,-1,5277,5276,5309,5308,-1,5329,5333,5334,5335,-1,5230,5232,5249,-1,5305,5303,5337,-1,5370,5371,5372,5373,-1,5374,5375,5376,5377,-1,5378,5379,1479,5380,-1,5381,5382,5383,5384,-1,5384,5383,5385,5386,-1,5386,5385,5387,5388,-1,5388,5387,5389,5390,-1,5390,5389,5391,5392,-1,5392,5391,5393,5394,-1,5394,5393,5395,5396,-1,5396,5395,1480,1481,-1,5398,5397};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_28()
		{
			int[] value = {5399,5400,-1,5400,5399,5401,5402,-1,5402,5401,5403,5404,-1,5404,5403,5405,5406,-1,5406,5405,5407,5408,-1,5408,5407,5409,5410,-1,5410,5409,5382,5381,-1,5382,5411,5412,5383,-1,5383,5412,5413,5385,-1,5385,5413,5414,5387,-1,5387,5414,5415,5389,-1,5389,5415,5416,5391,-1,5391,5416,5373,5393,-1,5393,5373,5372,5395,-1,5395,5372,1494,1480,-1,5397,5417,5371,5399,-1,5399,5371,5370,5401,-1,5401,5370,5418,5403,-1,5403,5418,5419,5405,-1,5405,5419,5420,5407,-1,5407,5420,5421,5409,-1,5409,5421,5411,5382,-1,5371,5417,1494,5372,-1,5416,5415,5419,5418,-1,5418,5370,5373,5416,-1,5414,5413,5421,5420,-1,5420,5419,5415,5414,-1,5413,5412,5411,5421,-1,5377,5376,5422,5423,-1,5379,5378,5423,5422,-1,5424,5425,5426,5427,-1,5375,5374,5427,5426,-1,5428,5429,5425,5424,-1,5384,5429,5428,5381,-1,5381,5428,5424,5410,-1,5410,5424,5427,5408,-1,5408,5427,5374,5406,-1,5406,5374,5377,5404,-1,5404,5377,5423,5402,-1,5402,5423,5378,5400,-1,5400,5378,5380,5398,-1,1481,1479,5379,5396,-1,5396,5379,5422,5394,-1,5394,5422,5376,5392,-1,5392,5376,5375,5390,-1,5390,5375,5426,5388,-1,5388,5426,5425,5386,-1,5386,5425,5429,5384,-1,5430,5431,5432,5433,-1,5434,5435,5431,5430,-1,5436,5437,5435,5434,-1,5438,5439,5437,5436,-1,5440,5441,5439,5438,-1,5442,5443,5444,5445,-1,5431,5446,5447,5432,-1,5435,5448,5446,5431,-1,5437,5449,5448,5435,-1,5439,5450,5449,5437,-1,5441,5451,5450,5439,-1,5443,5452,5453,5444,-1,5446,5454,5455,5447,-1,5448,5456,5454,5446,-1,5449,5457,5456,5448,-1,5450,5458,5457,5449,-1,5451,5459,5458,5450,-1,5452,5460,5461,5453,-1,5454,5462,5463,5455,-1,5456,5464,5462,5454,-1,5457,5465,5464,5456,-1,5458,5466,5465,5457,-1,5459,5467,5466,5458,-1,5460,5468,5469,5461,-1,5462,5470,5471,5463,-1,5464,5472,5470,5462,-1,5465,5473,5472,5464,-1,5466,5474,5473,5465,-1,5467,5475,5474,5466,-1,5468,5476,5477,5469,-1,5470,1503,5478,5471,-1,5472,1504,1503,5470,-1,5473,1505,1504,5472,-1,5474,1506,1505,5473,-1,5475,1507,1506,5474,-1,5476,1508,5479,5477,-1,5480,5481,5482,5483,-1,5478,5485,5486,5471,-1,5471,5486,5487,5463,-1,5463,5487,5488,5455,-1,5455,5488,5489,5447,-1,5447,5489,5490,5432,-1,5432,5490,5491,5433,-1,5480,5492,5493,5481,-1,5494,5495,5496,5497,-1,5497,5496,5498,5499,-1,5499,5498,5500,5501,-1,5501,5500,5502,5503,-1,5503,5502,5504,5505,-1,5505,5504,1535,5506,-1,5484,5507,5508,5485,-1,5485,5508,5509,5486,-1,5486,5509,5510,5487,-1,5487,5510,5511,5488,-1,5488,5511,5512,5489,-1,5489,5512,5513,5490,-1,5490,5513,5514,5491,-1,5492,5515,5516,5493,-1,5495,5517,5518,5496,-1,5496,5518,5519,5498,-1,5498,5519,5520,5500,-1,5500,5520,5521,5502,-1,5502,5521,5522,5504,-1,5504,5522,1543,1535,-1,5513,5523,5524,5514,-1,5515,5525,5526,5516,-1,5517,5527,5528,5518,-1,5518,5528,5529,5519,-1,5519,5529,5530,5520,-1,5520,5530,5531,5521,-1,5521,5531,5532,5522,-1,5522,5532,5533,1543,-1,5507,5534,5535,5508,-1,5508,5535,5536,5509,-1,5509,5536,5537,5510,-1,5510,5537,5538,5511,-1,5511,5538,5539,5512,-1,5512,5539,5523,5513,-1,5523,5443,5442,5524,-1,5525,5540,5541,5526,-1,5527,5445,5444,5528,-1,5528,5444,5453,5529,-1,5529,5453,5461,5530,-1,5530,5461,5469,5531,-1,5531,5469,5477,5532,-1,5532,5477,5479,5533,-1,5535,1508,5476,5536,-1,5536,5476,5468,5537,-1,5537,5468,5460,5538,-1,5538,5460,5452,5539,-1,5539,5452,5443,5523,-1,5482,5542,5543,5483,-1,5436,5542,5482,5438,-1,5438,5482,5481,5440,-1,5494,5481,5493,5495,-1,5495,5493,5516,5517,-1,5517,5516,5526,5527,-1,5527,5526,5541,5445,-1,5445,5541,5540,5442,-1,5442,5540,5525,5524,-1,5524,5525,5515,5514,-1,5514,5515,5492,5491,-1,5491,5492,5480,5433,-1,5433,5480,5483,5430,-1,5430,5483,5543,5434,-1,5434,5543,5542,5436,-1,5459,5451,5544,5545,-1,5545,5544,5499,5501,-1,5451,5441,5546,5544,-1,5544,5546,5497,5499,-1,5441,5440,5547,5546,-1,5546,5547,5494,5497,-1,5467,5459,5545,5548,-1,5548,5545,5501,5503,-1,5475,5467,5548,5549,-1,5549,5548,5503,5505,-1,1507,5475,5549,5550,-1,5550,5549,5505,5506,-1,5440,5481,5547,-1,5481,5494,5547,-1,5551,5552,5553,5554,-1,5555,5554,5553,-1,5552,5551,5556,-1,5556,5551,5557,5558,-1,5558,5557,5559,5560,-1,5560,5559,5561,5562,-1,5562,5561,5563,5564,-1,5564,5563,5565,5566,-1,5566,5565,1554,5567,-1,1571,5568,5569,5570,-1,5570,5569,5571,5572,-1,5572,5571,5573,5574,-1,5574,5573,5575,5576,-1,5576,5575,5577,5578,-1,5578,5577,5554,5555,-1,5554,5577,5557,5551,-1,5575,5573,5561,5559,-1,5573,5571,5563,5561,-1,5571,5569,5565,5563,-1,5569,5568,1554,5565,-1,5577,5575,5559,5557,-1,5579,5580,5581,5582,-1,5580,5583,5584,5581,-1,5583,5585,5586,5584,-1,5585,5587,5588,5586,-1,5587,5589,5590,5588,-1,5589,1572,5591,5590,-1,5582,5592,5593,5579,-1,5567,5594,5595,5566,-1,5566,5595,5596,5564,-1,5564,5596,5597,5562,-1,5562,5597,5598,5560,-1,5560,5598,5599,5558,-1,5558};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_29()
		{
			int[] value = {5599,5600,5556,-1,5556,5600,5601,5552,-1,5552,5601,5602,5553,-1,5553,5602,5603,5555,-1,5555,5603,5604,5578,-1,5578,5604,5605,5576,-1,5576,5605,5606,5574,-1,5574,5606,5607,5572,-1,5572,5607,5608,5570,-1,5570,5608,5609,1571,-1,5594,1572,5589,5595,-1,5595,5589,5587,5596,-1,5596,5587,5585,5597,-1,5597,5585,5583,5598,-1,5598,5583,5580,5599,-1,5599,5580,5579,5600,-1,5600,5579,5593,5601,-1,5601,5593,5592,5602,-1,5602,5592,5582,5603,-1,5603,5582,5581,5604,-1,5604,5581,5584,5605,-1,5605,5584,5586,5606,-1,5606,5586,5588,5607,-1,5607,5588,5590,5608,-1,5608,5590,5591,5609,-1,5610,5611,5612,5613,-1,5611,5610,5614,-1,5615,5613,5612,-1,5616,5617,5613,5615,-1,5618,5619,5617,5616,-1,5620,5621,5619,5618,-1,5622,5623,5621,5620,-1,1589,5624,5623,5622,-1,5625,5626,5624,1589,-1,5629,5630,5628,5627,-1,5631,5632,5630,5629,-1,5633,5634,5632,5631,-1,5635,5636,5634,5633,-1,5637,5638,5636,5635,-1,5614,5610,5638,5637,-1,5613,5617,5638,5610,-1,5619,5621,5634,5636,-1,5621,5623,5632,5634,-1,5623,5624,5630,5632,-1,5624,5626,5628,5630,-1,5617,5619,5636,5638,-1,5639,5640,5641,5642,-1,5640,5643,5644,5641,-1,5643,5645,5646,5644,-1,5642,5648,5649,5639,-1,5622,5650,1621,1589,-1,5620,5651,5650,5622,-1,5618,5652,5651,5620,-1,5616,5653,5652,5618,-1,5615,5654,5653,5616,-1,5612,5655,5654,5615,-1,5611,5656,5655,5612,-1,5614,5657,5656,5611,-1,5637,5658,5657,5614,-1,5635,5659,5658,5637,-1,5633,5660,5659,5635,-1,5631,5661,5660,5633,-1,5651,5646,5647,5650,-1,5652,5644,5646,5651,-1,5653,5641,5644,5652,-1,5654,5642,5641,5653,-1,5655,5648,5642,5654,-1,5656,5649,5648,5655,-1,5657,5639,5649,5656,-1,5658,5640,5639,5657,-1,5659,5643,5640,5658,-1,5660,5645,5643,5659,-1,5661,1606,5645,5660,-1,5662,5663,5664,5665,-1,5663,5662,5666,-1,5667,5665,5664,-1,5668,5669,5665,5667,-1,5670,5671,5669,5668,-1,5672,5673,5671,5670,-1,5674,5675,5673,5672,-1,5676,5677,5675,5674,-1,1631,5678,5677,5676,-1,5681,5682,5680,5679,-1,5683,5684,5682,5681,-1,5685,5686,5684,5683,-1,5687,5688,5686,5685,-1,5689,5690,5688,5687,-1,5666,5662,5690,5689,-1,5665,5669,5690,5662,-1,5671,5673,5686,5688,-1,5673,5675,5684,5686,-1,5675,5677,5682,5684,-1,5677,5678,5680,5682,-1,5669,5671,5688,5690,-1,5691,5692,5693,5694,-1,5692,5695,5696,5693,-1,5695,5697,5698,5696,-1,5697,5699,5700,5698,-1,5701,1648,5703,5702,-1,1648,5704,5705,5703,-1,5694,5706,5707,5691,-1,5676,5710,5709,1631,-1,5674,5711,5710,5676,-1,5672,5712,5711,5674,-1,5670,5713,5712,5672,-1,5668,5714,5713,5670,-1,5667,5715,5714,5668,-1,5664,5716,5715,5667,-1,5663,5717,5716,5664,-1,5666,5718,5717,5663,-1,5689,5719,5718,5666,-1,5687,5720,5719,5689,-1,5685,5721,5720,5687,-1,5683,5722,5721,5685,-1,5681,5723,5722,5683,-1,5679,5724,5723,5681,-1,5709,5703,5705,5708,-1,5710,5702,5703,5709,-1,5711,5700,5702,5710,-1,5712,5698,5700,5711,-1,5713,5696,5698,5712,-1,5714,5693,5696,5713,-1,5715,5694,5693,5714,-1,5716,5706,5694,5715,-1,5717,5707,5706,5716,-1,5718,5691,5707,5717,-1,5719,5692,5691,5718,-1,5720,5695,5692,5719,-1,5721,5697,5695,5720,-1,5722,5699,5697,5721,-1,5723,5701,5699,5722,-1,5724,1648,5701,5723,-1,5725,5726,5727,5728,-1,5729,5730,5731,5732,-1,1666,5733,5734,5735,-1,5736,5737,5738,5739,-1,5740,5741,5737,5736,-1,5742,5743,5741,5740,-1,5744,5745,5743,5742,-1,5746,5747,5745,5744,-1,5748,5749,5747,5746,-1,5750,5751,5749,5748,-1,5752,5753,5751,5750,-1,5755,5756,1679,5754,-1,5757,5758,5756,5755,-1,5759,5760,5758,5757,-1,5761,5762,5760,5759,-1,5763,5764,5762,5761,-1,5765,5766,5764,5763,-1,5739,5738,5766,5765,-1,5737,5767,5768,5738,-1,5741,5769,5767,5737,-1,5743,5770,5769,5741,-1,5745,5771,5770,5743,-1,5747,5772,5771,5745,-1,5749,5725,5772,5747,-1,5751,5726,5725,5749,-1,5753,5773,5726,5751,-1,5756,5727,1686,1679,-1,5758,5728,5727,5756,-1,5760,5774,5728,5758,-1,5762,5775,5774,5760,-1,5764,5776,5775,5762,-1,5766,5777,5776,5764,-1,5738,5768,5777,5766,-1,5726,5773,1686,5727,-1,5774,5775,5771,5772,-1,5772,5725,5728,5774,-1,5776,5777,5769,5770,-1,5770,5771,5775,5776,-1,5777,5768,5767,5769,-1,5778,5779,5730,5729,-1,5779,5778,5735,5734,-1,5780,5781,5782,5783,-1,5781,5780,5732,5731,-1,5783,5782,5784,5785,-1,5739,5785,5784,5736,-1,5765,5783,5785,5739,-1,5763,5780,5783,5765,-1,5761,5732,5780,5763,-1,5759,5729,5732,5761,-1,5757,5778,5729,5759,-1,5755,5735,5778,5757,-1,5754,1666,5735,5755,-1,5750,5734,5733,5752,-1,5748,5779,5734,5750,-1,5746,5730,5779,5748,-1,5744,5731,5730,5746,-1,5742,5781,5731,5744,-1,5740,5782,5781,5742,-1,5736,5784,5782,5740,-1,5786,5787,1965,1966,-1,5791,5792,5793,1984,-1,5793,5794,1989,1984,-1,4450,4449,5795,5796,-1,5796,5795,5798,5799,-1,5801,5802,5803,-1,5804,5805,5806,5807,-1,5808,5809,5805,5804,-1,5803,5809,5808,5801,-1,5808,5810,5801,-1,5787,5786};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_30()
		{
			int[] value = {5812,5813,-1,5814,2012,5811,-1,5813,5812,5807,5806,5815,-1,5816,5802,5817,5818,-1,5819,5820,5821,5822,-1,5823,5824,5821,5820,-1,4487,4486,5825,5826,-1,5827,5828,5829,5830,-1,5831,5832,5833,-1,5833,5832,1969,5788,-1,5789,5787,5813,5836,-1,5836,5813,5815,5837,-1,5838,5816,5818,5839,-1,2024,1969,5832,5840,-1,5841,5829,5828,5842,-1,5842,5843,5844,5841,-1,5840,2025,2026,2024,-1,5845,5839,5818,5846,-1,5847,5828,5827,5848,-1,5849,5842,5828,5847,-1,5850,5843,5842,5849,-1,5851,5820,5819,5852,-1,5853,5823,5820,5851,-1,4520,4487,5826,5854,-1,5802,5816,5855,5803,-1,5838,5856,5855,5816,-1,5829,5857,5858,5830,-1,5841,5859,5857,5829,-1,5844,5860,5859,5841,-1,5821,5861,5862,5822,-1,5824,5863,5861,5821,-1,4486,4531,5864,5825,-1,5855,5865,5809,5803,-1,5856,5866,5865,5855,-1,5857,5867,5868,5858,-1,5859,5869,5867,5857,-1,5860,5870,5869,5859,-1,5861,5871,5872,5862,-1,5863,5873,5871,5861,-1,4531,4450,5796,5864,-1,5874,5875,5793,5792,-1,5875,5874,5810,5808,-1,5875,5878,5794,5793,-1,5808,5804,5878,5875,-1,5865,5879,5805,5809,-1,5866,5880,5879,5865,-1,5867,5881,5882,5868,-1,5869,5883,5881,5867,-1,5870,5884,5883,5869,-1,5871,2043,5885,5872,-1,5873,5886,2043,5871,-1,5878,5812,5786,5794,-1,5804,5807,5812,5878,-1,5879,5815,5806,5805,-1,5880,5837,5815,5879,-1,5881,5832,5831,5882,-1,5883,5840,5832,5881,-1,5884,2025,5840,5883,-1,2043,2012,5814,5885,-1,5887,5888,5814,5811,-1,5889,5888,2025,5884,-1,5885,5814,5888,5889,-1,5890,5891,5843,5850,-1,5852,5819,5891,5890,-1,5892,5891,5819,5822,-1,5844,5843,5891,5892,-1,5892,5893,5860,5844,-1,5822,5862,5893,5892,-1,5893,5894,5870,5860,-1,5862,5872,5894,5893,-1,5894,5889,5884,5870,-1,5872,5885,5889,5894,-1,5799,5798,5886,5873,-1,5895,5799,5873,5863,-1,5864,5796,5799,5895,-1,5896,5895,5863,5824,-1,5825,5864,5895,5896,-1,5897,5896,5824,5823,-1,5826,5825,5896,5897,-1,5898,5897,5823,5853,-1,5854,5826,5897,5898,-1,5899,5900,5880,5866,-1,5868,5882,5900,5899,-1,5901,5899,5866,5856,-1,5858,5868,5899,5901,-1,5902,5901,5856,5838,-1,5830,5858,5901,5902,-1,5902,5903,5827,5830,-1,5838,5839,5903,5902,-1,5904,5903,5839,5845,-1,5848,5827,5903,5904,-1,5900,5905,5837,5880,-1,5882,5831,5905,5900,-1,5906,5905,5831,5833,-1,5836,5837,5905,5906,-1,5800,5906,5833,5788,-1,5789,5836,5906,5800,-1,5846,5818,5817,-1,5791,5790,5835,1990,5797,5834,5877,5876,2049,2016,2013,4459,4573,4520,5854,5898,5853,5851,5852,5890,5850,5849,5847,5848,5904,5845,5846,5817,5802,5801,5810,5874,5792,-1,5907,5908,5909,5910,-1,5911,5912,5913,5914,-1,5908,5907,5915,5916,-1,5912,5911,5917,5918,-1,5919,5920,5921,5922,-1,5923,5924,5925,5926,-1,5926,5921,5920,5923,-1,5915,5907,5912,5918,-1,5907,5910,5913,5912,-1,5927,5928,5929,5930,-1,5928,5931,5932,5929,-1,5933,5934,5935,5936,-1,5933,5936,5937,-1,5931,5928,5938,5939,-1,5928,5927,5940,5938,-1,5929,5932,5941,5942,-1,5930,5929,5942,5943,-1,5916,5915,5920,5919,-1,5915,5918,5923,5920,-1,5918,5917,5924,5923,-1,5939,5937,5936,-1,5932,5931,5936,5935,-1,5944,5941,5932,5935,-1,5944,5935,5934,-1,5909,5908,5938,5940,-1,5908,5916,5939,5938,-1,5916,5919,5937,5939,-1,5922,5945,5937,5919,-1,5946,5947,5948,5949,-1,5947,5950,5951,5948,-1,5950,5952,5953,5951,-1,5954,5953,5952,-1,5955,5956,5921,5926,-1,5956,5957,5922,5921,-1,5957,5958,5945,5922,-1,5958,5959,5933,5945,-1,5959,5960,5934,5933,-1,5944,5934,5960,5954,5952,-1,5952,5950,5941,5944,-1,5950,5947,5942,5941,-1,5947,5946,5943,5942,-1,5937,5945,5933,-1,5936,5931,5939,-1,5926,5925,5961,5955,-1,5962,5951,5953,-1,5963,5954,5960,-1,5964,5955,5961,-1,5948,5965,5966,5949,-1,5951,5962,5965,5948,-1,5962,5953,5954,5963,-1,5959,5967,5963,5960,-1,5958,5968,5967,5959,-1,5957,5969,5968,5958,-1,5956,5970,5969,5957,-1,5955,5964,5970,5956,-1,6234,6235,6236,6237,6238,-1,6239,6240,6241,-1,6239,6242,6243,6240,-1,6244,6245,6246,6247,-1,6248,6249,6250,-1,6247,6246,6251,6252,-1,6253,6254,6241,6255,-1,6239,6241,6254,6237,-1,6242,6239,6237,6236,-1,6256,6242,6236,6235,-1,6257,6256,6235,6234,-1,6258,6257,6234,6238,-1,6238,6259,6260,6258,-1,6259,6253,6260,-1,6253,6259,6254,-1,6238,6237,6254,6259,-1,6249,6248,6245,6244,-1,6261,6262,6240,-1,6252,6251,6263,6264,-1,6240,6243,6265,6261,-1,6262,6255,6241,6240,-1,6249,6257,6266,6250,-1,6244,6256,6257,6249,-1,6247,6242,6256,6244,-1,6252,6243,6242,6247,-1,6264,6265,6243,6252,-1,5971,5972,5973,5974,-1,5975,5971,5974,5976,-1,5977,5978,5979,5980,-1,5981,5977,5980,5982,-1,5983,5981,5982,5984,-1,5985,5983,5984,5986,-1,5987,5985,5986,5988,-1,5989,5987,5988,5990,-1,5991,5989,5990,5992,-1,5993,5991,5992,5994,-1,5995,5996,5997,5998,-1,5999,5995,5998,6000,-1,6001,5999,6000,6002,-1,6003,6004,6005,6006,-1,6007,6003,6006,6008,-1,5972,6009,6010,5973,-1,6011,6012,6013,6014,-1,6015,6016};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_31()
		{
			int[] value = {6017,6018,-1,5994,5992,6019,6020,-1,5980,5979,6021,6022,-1,5982,5980,6022,6023,-1,5984,5982,6023,6024,-1,5986,5984,6024,6025,-1,5988,5986,6025,6026,-1,5990,5988,6026,6027,-1,5992,5990,6027,6019,-1,6028,5994,6020,-1,6029,6030,5998,5997,-1,6012,6011,6031,6032,-1,6033,6031,6030,6034,-1,6011,6014,6018,6017,-1,6031,6011,6017,6035,-1,6030,6031,6035,6036,-1,6037,6030,6036,6038,-1,6002,6000,6038,6039,-1,6006,6005,6040,6041,-1,6008,6006,6041,6042,-1,5973,6010,6043,6044,-1,5974,5973,6044,6045,-1,5976,5974,6045,6046,-1,6047,6048,6022,6021,-1,6049,6022,6048,-1,6050,6051,6023,-1,6031,6033,6032,-1,6016,6052,6035,6017,-1,6038,6036,6053,-1,6052,6053,6036,6035,-1,6054,6055,6056,-1,6054,6057,6058,6055,-1,6057,6059,6060,6058,-1,6059,6061,6062,6060,-1,6061,6059,6016,6015,-1,6059,6057,6052,6016,-1,6057,6054,6053,6052,-1,6054,6039,6038,6053,-1,6040,6055,6063,6041,-1,6064,6065,6063,-1,6064,6066,6067,6065,-1,6066,6068,6069,6067,-1,6070,6071,6060,6062,-1,6071,6072,6058,6060,-1,6072,6063,6055,6058,-1,6063,6042,6041,-1,6030,6037,5998,-1,5911,5914,6013,6012,-1,5917,5911,6012,6032,-1,5924,5917,6032,6033,-1,6033,6034,5925,5924,-1,6073,6024,6074,-1,6073,6075,6025,6024,-1,6075,6076,6026,6025,-1,6076,6077,6027,6026,-1,6077,6078,6019,6027,-1,6028,6020,6078,-1,6023,6051,6074,6024,-1,6022,6049,6050,6023,-1,6034,6028,5925,-1,6079,6028,6034,-1,5925,6028,5961,-1,5962,6050,6049,-1,5963,6074,6051,-1,5965,6048,6047,5966,-1,5962,6049,6048,5965,-1,6050,5962,5963,6051,-1,5967,6073,6074,5963,-1,5968,6075,6073,5967,-1,5969,6076,6075,5968,-1,5970,6077,6076,5969,-1,5964,6078,6077,5970,-1,5961,6078,5964,-1,5961,6028,6078,-1,6078,6020,6019,-1,6068,6066,6071,6070,-1,6066,6064,6072,6071,-1,6063,6072,6064,-1,6065,6044,6043,-1,6065,6067,6045,6044,-1,6045,6067,6069,6046,-1,6043,6063,6065,-1,6002,6080,6081,6001,-1,6039,6056,6080,6002,-1,6054,6056,6039,-1,6040,6056,6055,-1,6005,6080,6056,6040,-1,6004,6081,6080,6005,-1,6008,6010,6009,6007,-1,6042,6043,6010,6008,-1,6063,6043,6042,-1,6082,5994,6028,6079,-1,6083,5993,5994,6082,-1,6082,5997,5996,6083,-1,6079,6029,5997,6082,-1,6034,6030,6029,-1,6029,6079,6034,-1,6037,6000,5998,-1,6038,6000,6037,-1,8958,8959,8960,-1,8961,8962,8963,8964,-1,8965,8966,8967,8968,-1,8969,8970,8971,8972,-1,8973,8974,8975,8976,-1,8977,8978,8979,8980,-1,8981,8982,8983,8984,-1,8985,8986,8987,-1,8988,8989,8990,8991,-1,8992,8993,8994,8995,-1,8996,8997,8998,8999,-1,9000,9001,9002,9003,-1,9004,9005,9006,9007,-1,9008,9009,9010,9011,-1,9012,9013,9014,9015,-1,9016,9017,9018,9019,-1,9020,9021,9022,-1,9023,9024,9025,9026,-1,9027,9028,9029,-1,9030,9031,9032,-1,9033,9034,9035,9036,-1,9037,9038,9039,-1,6294,6295,6296,6297,6298,-1,9040,9041,9042,9043,9044,-1,9045,9046,9047,-1,9048,9049,9050,9051,-1,6299,6300,6301,6302,-1,6303,6304,6305,6306,-1,6307,6308,6309,6310,-1,6311,6312,6313,6314,-1,6315,6316,6317,-1,6318,6319,6320,6321,-1,6322,6323,6324,6325,-1,6326,6327,6328,-1,6329,6330,6331,6332,-1,6333,6334,6335,6336,-1,6337,6338,6339,6340,-1,6341,6342,6343,-1,9052,9053,9054,-1,6344,6345,6346,-1,9055,9056,9057,9058,-1,6347,6348,6349,-1,6350,6351,6352,6353,-1,6354,6355,6356,-1,9059,9060,9061,-1,9062,9063,9064,9065,-1,9066,9067,9068,9069,-1,9070,9071,9072,9073,-1,9074,9075,9076,9077,-1,9078,9079,9080,-1,9081,9082,9083,9084,-1,9085,9086,9087,9088,-1,9089,9090,9091,9092,-1,9093,9094,9095,9096,9097,-1,9098,9099,9100,9101,-1,9102,9103,9104,9105,-1,9106,9107,9108,9109,-1,9110,9111,9112,-1,9113,9114,9115,-1,9116,9117,9118,9119,9120,-1,9121,9122,9123,9124,9125,-1,9126,9127,9128,9129,9130,-1,9131,9132,9133,-1,9134,9135,9136,-1,9137,9138,3842,3843,3844,9139,-1,9140,9141,9142,9143,9144,-1,9145,3887,9146,9147,9148,-1,9149,9150,9151,9152,-1,9153,9154,9155,9156,-1,3895,3896,9157,9158,-1,9159,9160,9161,9162,9163,-1,9164,9165,9166,9167,9168,-1,9169,9170,9171,9172,-1,9173,9174,9175,-1,9176,9177,9178,9179,-1,9180,9181,9182,9183,-1,9184,9185,9186,9187,-1,3897,9188,9189,9190,-1,9191,9192,9193,-1,9194,9195,9196,-1,9197,9198,9199,-1,9200,9201,9202,9203,9204,-1,9205,9206,9207,-1,9208,9209,9210,9211,-1,9212,9213,9214,9215,-1,9216,9217,9218,-1,9219,9220,9221,9222,-1,9223,9224,9225,-1,9226,9227,9228,-1,9229,9230,9231,-1,9232,9233,9234,9235,-1,9236,9237,9238,9239,-1,9240,9241,9242,-1,9243,9244,9245,-1,9246,9247,9248,-1,9249,9250,9251,9252,-1,9253,9254,9255,9256,-1,9257,9258,9259,9260,-1,9261,9262,9263,9264,-1,9265,9266,9267,9268,-1,9269,9270,9271,-1,9272,9273,9274,9275,9276,-1,9277,9278,9279,9280,-1,9281,9282,9283,9284,-1,6357,6358,6359,6360,-1,6361,6362,6363,-1,6364,6365,6366,-1,9285,9286,9287,9288,-1,9289,9290,9291,9292,-1,9293,9294,9295,9296,-1,9297,9298,9299,9300,9301,-1,9302};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_32()
		{
			int[] value = {9303,9304,9305,-1,9306,9307,9308,9309,-1,9310,9311,9312,9313,-1,9314,9315,9316,9317,-1,6367,6368,6369,6370,-1,9318,9319,9320,9321,-1,9322,9323,9324,9325,-1,9326,9327,9328,-1,9329,9330,9331,9332,-1,9333,9334,9335,9336,-1,9337,9338,9339,9340,-1,9341,9342,9343,9344,9345,-1,9346,9347,9348,9349,-1,9350,9351,9352,9353,-1,9354,9355,9356,9357,-1,9358,9359,9360,9361,-1,9362,9363,9364,9365,-1,9366,9367,9368,9369,-1,9370,9371,9372,9373,-1,9374,9375,9376,9377,-1,9378,9379,9380,9381,-1,9382,9383,9384,9385,-1,9386,9387,9388,9389,-1,9390,9391,9392,-1,9393,9394,9395,9396,-1,9400,9401,9402,9403,-1,9404,9405,9406,-1,9407,9408,9409,-1,9410,9411,3914,9412,9413,-1,9414,9415,9416,9417,-1,8962,8961,9418,-1,9419,8965,9420,-1,8970,8969,9421,-1,8966,8965,9422,-1,8978,8977,8975,8974,-1,9423,8985,8983,8982,-1,8993,8992,8990,8989,-1,9001,9000,8998,8997,-1,9009,9008,9006,9005,-1,9017,9016,9014,9013,-1,9024,9023,9021,9020,-1,9020,9022,9029,9028,-1,9030,9032,9022,9021,-1,9028,9027,9035,9034,-1,9027,9029,9039,9038,-1,9424,9425,9038,9037,-1,9037,9039,9032,9031,-1,9041,9040,9031,9030,-1,9023,9026,9042,9041,-1,9026,9025,9426,9427,-1,9034,9033,9025,9024,-1,9048,9428,9033,9036,-1,9425,9429,9036,9035,-1,6298,6297,6371,6372,-1,9427,9430,9043,9042,-1,6297,6296,6301,6300,-1,6373,6374,6296,6295,-1,6374,6375,6305,6304,-1,6304,6303,6302,6301,-1,6312,6311,6309,6308,-1,6300,6299,6376,6371,-1,6299,6302,6311,6314,-1,6316,6315,6313,6312,-1,6377,6378,6314,6313,-1,6326,6328,6324,6323,-1,6330,6329,6325,6324,-1,6338,6337,6335,6334,-1,6323,6322,6379,6380,-1,6322,6325,6337,6340,-1,6342,6341,6339,6338,-1,6381,6382,6340,6339,-1,6341,6343,6383,6381,-1,6344,6346,6343,6342,-1,6384,6385,6346,6345,-1,6334,6333,6345,6344,-1,6333,6336,6386,6384,-1,6336,6335,6329,6332,-1,6310,6309,6303,6306,-1,6387,6388,6306,6305,-1,6308,6307,6348,6347,-1,6307,6310,6352,6351,-1,6315,6317,6318,6377,-1,6347,6349,6317,6316,-1,6351,6350,6349,6348,-1,6328,6327,6356,6355,-1,6380,6319,6327,6326,-1,6319,6318,6350,6389,-1,6355,6354,6331,6330,-1,6354,6356,6389,6390,-1,6390,6391,6332,6331,-1,9063,9062,9060,9059,-1,9431,9432,9433,-1,9433,9069,8963,8962,-1,9071,9070,9069,9434,-1,8961,8964,9435,8970,-1,8964,8963,9070,9073,-1,9075,9074,9072,9071,-1,9079,9078,9073,9072,-1,8985,8987,8994,8993,-1,9086,9085,9436,9081,-1,9094,9093,9091,9090,-1,8992,8995,9002,9001,-1,8995,8994,9085,9088,-1,8997,8996,8991,8990,-1,9103,9102,9100,9099,-1,8977,8980,9437,9423,-1,9438,9439,8980,8979,-1,6382,6392,6320,6379,-1,9062,9065,9054,9053,-1,6378,6321,6393,6376,-1,9440,9441,9442,-1,9443,9050,9444,-1,8971,9435,9078,9080,-1,9111,9110,8972,8971,-1,8969,8972,8967,8966,-1,8968,8967,9115,9114,-1,9445,9446,9447,-1,9117,9116,9114,9113,-1,9113,9115,9110,9112,-1,9080,9448,9112,9111,-1,9448,9446,9118,9117,-1,9434,9068,9122,9121,-1,9128,9127,9123,9122,-1,9132,9131,9127,9126,-1,9124,9123,9136,9135,-1,9138,9137,9135,9134,-1,9134,9136,9131,9133,-1,9140,9144,9133,9132,-1,9144,9143,3842,9138,-1,9142,9141,9146,3887,-1,9126,9449,9141,9140,-1,9449,9450,9151,9150,-1,9163,9162,9157,3896,-1,9093,9097,9166,9165,-1,9451,9452,9171,9170,-1,9439,9109,9453,9437,-1,9178,9177,8986,9453,-1,8987,8986,9082,9436,-1,9454,9082,9177,9176,-1,9185,9184,9182,9181,-1,9184,3926,3897,9190,-1,9455,9456,9066,9432,-1,9129,9128,9068,9067,-1,9067,9066,9194,9196,-1,9457,9458,9450,9130,-1,9130,9129,9196,9195,-1,9195,9194,9456,9457,-1,9162,9161,9173,9451,-1,9161,9160,9199,9198,-1,9201,9200,9160,9159,-1,9200,9204,9206,9205,-1,9198,9197,9459,9173,-1,9205,9207,9197,9199,-1,9208,9460,9207,9206,-1,9452,9175,9212,9461,-1,9175,9174,9218,9217,-1,9462,9463,9216,9218,-1,9217,9216,9213,9212,-1,9059,9061,9224,9223,-1,9463,9222,9464,9213,-1,9225,9224,9222,9221,-1,9174,9465,9466,9462,-1,9460,9211,9465,9459,-1,9211,9210,9219,9466,-1,9210,9467,9228,9227,-1,9192,9191,9221,9220,-1,9227,9226,9220,9219,-1,9229,9231,9226,9228,-1,9152,9151,9458,9193,-1,9193,9192,9231,9230,-1,9468,9152,9230,9229,-1,9233,9232,9469,-1,9237,9236,9234,9233,-1,9241,9240,9235,9234,-1,9236,9239,9242,9241,-1,9248,9247,9244,9243,-1,9250,9249,9247,9246,-1,9254,9253,9245,9244,-1,9257,9260,9470,9242,-1,9253,9256,9260,9259,-1,9261,9264,9471,9470,-1,9472,9264,9263,-1,9420,9473,9251,9250,-1,9116,9120,9473,8968,-1,9120,9119,9268,9267,-1,9262,9261,9256,9255,-1,9249,9252,9255,9254,-1,9252,9251,9267,9266,-1,9266,9265,9263,9262,-1,9088,9087,9269,9474,-1,9090,9089,9087,9086,-1,9215,9214,9167,9166,-1,9475,9060,9053,9476,-1,9055,9477,9476,9478,-1,9273,9272,9214,9479,-1,9479,9464,9061,9480,-1,9480,9475,9279,9278,-1,9280,9279,9477,9058,-1,9058,9057,9282,9281,-1,6391,6394,6395,6386,-1,6394,6353,6360,6359,-1,6388,6396,6353,6352,-1,6357,6360,6363};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_33()
		{
			int[] value = {6362,-1,6362,6361,6365,6364,-1,9285,9288,9481,9482,-1,6397,6398,6359,6358,-1,6364,6399,6358,6357,-1,9289,9292,9284,9283,-1,9278,9277,9274,9273,-1,9281,9284,9277,9280,-1,9483,9051,9050,-1,9294,9293,9484,-1,9298,9297,9101,9100,-1,8989,8988,8984,8983,-1,9099,9098,8988,8991,-1,9302,9485,9098,9101,-1,9303,9302,9297,9301,-1,9270,9269,9308,9486,-1,9310,9313,9486,9307,-1,9313,9312,9316,9315,-1,6400,6401,6366,6365,-1,6402,6366,6369,6368,-1,6399,6402,6403,6404,-1,9323,9322,9320,9319,-1,6405,6406,6368,6407,-1,9482,9487,9330,9329,-1,9047,9046,9487,9488,-1,9334,9333,9299,9298,-1,9331,9330,9337,9340,-1,9340,9339,9300,9299,-1,9341,9345,9295,9294,-1,9301,9300,9345,9344,-1,9489,9051,9293,9296,-1,9296,9295,9339,9338,-1,9338,9337,9046,9045,-1,9428,9489,9045,9426,-1,9292,9291,9275,9274,-1,9326,9328,9291,9290,-1,9347,9346,9311,9310,-1,9312,9311,9324,9323,-1,9322,9325,9490,9491,-1,9353,9352,9325,9324,-1,9355,9354,9328,9327,-1,9327,9490,9352,9351,-1,9089,9092,9309,9308,-1,9165,9164,9092,9091,-1,9307,9306,9348,9347,-1,9306,9309,9358,9361,-1,9349,9348,9361,9360,-1,9351,9350,9356,9355,-1,9350,9353,9346,9349,-1,9359,9358,9164,9168,-1,9168,9167,9272,9276,-1,9276,9275,9354,9357,-1,9357,9356,9360,9359,-1,9315,9314,9271,9270,-1,9474,9492,9003,9002,-1,9362,9365,9492,9271,-1,9000,9003,9010,9009,-1,9011,9010,9365,9364,-1,9008,9011,9018,9017,-1,9366,9369,9019,9018,-1,6370,6369,6408,6409,-1,9016,9019,9493,9371,-1,9369,9368,9494,9495,-1,9496,9494,9321,9320,-1,9319,9318,9317,9316,-1,9318,9321,9368,9367,-1,9367,9366,9364,9363,-1,9363,9362,9314,9317,-1,8996,8999,9104,9103,-1,9005,9004,8999,8998,-1,9376,9375,9105,9104,-1,9102,9105,9335,9334,-1,9373,9372,9287,9286,-1,9329,9497,9286,9285,-1,9378,9381,9370,9373,-1,9371,9370,9015,9014,-1,9377,9376,9004,9007,-1,9013,9012,9007,9006,-1,9012,9015,9381,9380,-1,9336,9335,9375,9374,-1,9374,9377,9380,9379,-1,9379,9378,9497,9332,-1,9333,9336,9332,9331,-1,9181,9180,9083,9454,-1,9382,9385,9084,9083,-1,9081,9084,9095,9094,-1,9461,9498,9172,9171,-1,9097,9096,9498,9215,-1,9096,9095,9385,9384,-1,9169,9172,9384,9383,-1,9155,9154,3895,9158,-1,9170,9169,9158,9157,-1,9156,9155,9383,9499,-1,9180,9183,9499,9382,-1,9190,9189,9183,9182,-1,9153,9156,9189,9188,-1,9179,9178,9109,9108,-1,9108,9107,9388,9387,-1,9176,9179,9186,9185,-1,9387,9386,9187,9186,-1,9447,9502,9392,9391,-1,9074,9077,9502,9079,-1,9394,9393,9077,9076,-1,9121,9125,9076,9075,-1,9137,9139,9125,9124,-1,9139,3844,9395,9394,-1,9393,9396,9390,9392,-1,9397,9399,9396,9395,-1,9503,9399,9398,-1,9504,9342,9341,-1,9401,9400,9505,-1,9150,9149,9147,9146,-1,9467,9506,9507,9468,-1,9405,9404,9149,9507,-1,9506,9508,9409,9408,-1,9408,9407,9406,9405,-1,9407,9409,9410,9413,-1,9404,9406,9148,9147,-1,9145,9148,9413,9412,-1,9411,9410,9508,9209,-1,9204,9203,9209,9208,-1,9203,9202,3914,9411,-1,8981,8984,9485,9305,-1,8982,8981,8976,8975,-1,8974,8973,9509,-1,9414,9417,8973,8976,-1,8960,8959,9510,9511,-1,9512,9513,9402,9401,-1,9513,9510,9416,9415,-1,9344,9343,9304,9303,-1,9400,9403,9343,9342,-1,9403,9402,9415,9514,-1,9514,9414,9305,9304,-1,9258,9257,9239,9238,-1,9515,9238,9237,-1,9516,9259,9258,-1,9187,9500,3926,9184,-1,9386,9501,9500,9187,-1,9389,3935,9501,9386,-1,9109,9439,9438,9106,-1,9382,9499,9383,-1,9082,9454,9083,-1,9081,9436,9082,-1,8985,9423,9437,9453,8986,-1,9512,9511,9510,9513,-1,9414,9514,9415,-1,6371,6376,6393,6410,-1,9051,9489,9428,9048,-1,9052,9478,9476,9053,-1,6392,6382,6381,-1,6319,6380,6320,-1,6321,6377,6318,-1,6380,6379,6320,-1,6321,6378,6377,-1,9326,9491,9490,9327,-1,6367,6407,6368,-1,9371,9493,9372,-1,9332,9497,9329,-1,9305,9485,9302,-1,9069,9433,9432,9066,-1,9068,9434,9069,-1,9152,9468,9507,9149,-1,9508,9506,9467,9210,-1,9175,9452,9451,9173,-1,9447,9446,9448,9080,-1,9130,9450,9449,9126,-1,9209,9508,9210,-1,9211,9460,9208,-1,9173,9459,9465,9174,-1,9193,9458,9457,9456,-1,9222,9463,9462,9466,-1,9215,9498,9461,9212,-1,9213,9464,9479,9214,-1,8970,9435,8971,-1,8968,9473,9420,8965,-1,9080,9079,9502,9447,-1,9242,9470,9471,9240,-1,9222,9466,9219,-1,9193,9456,9455,9191,-1,9060,9475,9480,9061,-1,6366,6402,6399,6364,-1,9488,9487,9482,9481,-1,6394,6391,6390,-1,6390,6389,6394,-1,6353,6394,6389,6350,-1,9055,9517,9056,-1,9058,9477,9055,-1,9047,9426,9045,-1,9047,9518,9430,9427,9426,-1,9271,9492,9474,9269,-1,9307,9486,9308,-1,9512,9519,9520,9511,-1,9521,9522,9523,-1,9410,9409,9508,-1,9406,9407,9413,9148,-1,9149,9404,9147,-1,9503,9390,9396,9399,-1,9084,9385,9095,-1,8986,9177,9082,-1,9384,9172,9498,9096,-1,6369,6366,6401,6408,-1,9442,9441,9054,9065,-1,9494,9368,9321,-1,9019,9369,9495,9493,-1,9370,9381,9015,-1,9497,9378,9373,9286,-1,9328,9354,9275,9291,-1,8987,9436,9085,8994,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_34()
		{
			int[] value = {9485,8984,8988,9098,-1,9105,9375,9335,-1,9107,9524,9525,9388,-1,9526,9509,8973,9417,-1,8959,9527,9416,9510,-1,9402,9513,9415,-1,8981,9305,9414,8976,-1,9178,9453,9109,-1,9304,9343,9403,9514,-1,9505,9400,9342,9504,-1,9222,9224,9061,9464,-1,9528,9529,9530,9431,-1,9531,9528,9431,9418,-1,9532,9421,9422,9533,-1,9534,9243,9535,9536,-1,9537,9536,9535,9538,-1,9539,9540,9541,9542,-1,9411,9209,9203,-1,9507,9506,9408,9405,-1,9123,9127,9131,9136,-1,9077,9393,9392,9502,-1,9118,9446,9445,9543,-1,9268,9119,9544,9545,-1,9264,9472,9546,9471,-1,9216,9463,9213,-1,9450,9458,9151,-1,9122,9068,9128,-1,8972,9110,9115,8967,-1,9251,9473,9120,9267,-1,9256,9261,9470,9260,-1,9259,9516,9245,9253,-1,9257,9242,9239,-1,9547,9235,9240,9548,-1,9549,8958,8960,9550,-1,9551,9552,9553,9554,-1,9555,9551,9554,9556,-1,9557,9558,9559,9560,-1,9561,9562,9563,9564,-1,9565,9566,9567,9568,-1,9569,9565,9568,9570,-1,9519,9512,9401,9505,-1,9571,9572,9573,9574,-1,9575,9576,9577,9578,-1,9579,9580,9581,9582,-1,9583,9584,9585,-1,9586,9587,9588,9589,-1,9590,9591,9592,9593,-1,9594,9593,9592,9595,-1,9596,9597,9598,9599,-1,9600,9601,9602,9603,-1,9604,9605,9606,9607,-1,9608,9609,9599,9598,-1,9610,9608,9598,9611,-1,9612,9613,9614,9615,-1,9616,9617,9618,-1,9619,9617,9616,9620,-1,9621,9579,9582,9622,-1,9615,9614,9572,9571,-1,9484,9293,9051,9483,-1,9062,9053,9060,-1,9623,9624,9625,9626,-1,9627,9628,9624,9623,-1,9629,9630,9631,9632,-1,9633,9632,9631,9634,-1,9635,9636,9637,9638,-1,9638,9639,9640,9635,-1,9522,9521,9641,-1,9642,9643,9641,9521,-1,9164,9358,9309,9092,-1,9089,9308,9269,9087,-1,9003,9492,9365,9010,-1,9104,8999,9004,9376,-1,9644,9645,9646,9603,-1,9647,9648,9649,9650,-1,3844,9397,9395,-1,9394,9076,9125,9139,-1,9070,8963,9069,-1,9179,9108,9387,9186,-1,9314,9362,9271,-1,9361,9348,9306,-1,9490,9325,9352,-1,6402,6368,6406,6403,-1,9101,9297,9302,-1,9330,9487,9046,9337,-1,6363,6360,6353,6396,-1,6359,6398,6395,6394,-1,9169,9383,9155,9158,-1,9156,9499,9183,9189,-1,9180,9382,9083,-1,9300,9339,9295,9345,-1,9167,9214,9272,-1,9377,9007,9012,9380,-1,9011,9364,9366,9018,-1,9336,9374,9379,9332,-1,9317,9318,9367,9363,-1,9311,9346,9353,9324,-1,9299,9333,9331,9340,-1,9349,9360,9356,9350,-1,9359,9168,9276,9357,-1,9355,9327,9351,-1,9097,9215,9166,-1,9475,9476,9477,9279,-1,6337,6325,6329,6335,-1,6311,6302,6303,6309,-1,9489,9296,9338,9045,-1,9496,9320,9322,9491,-1,9319,9316,9312,9323,-1,9315,9270,9486,9313,-1,9303,9301,9344,-1,9504,9341,9294,9484,-1,9284,9292,9274,9277,-1,6365,6361,6400,-1,6399,6404,6397,6358,-1,9329,9285,9482,-1,6364,6357,6362,-1,9058,9281,9280,-1,9273,9479,9480,9278,-1,9221,9191,9651,9225,-1,9347,9310,9307,-1,9576,9652,9653,9577,-1,9654,9621,9622,9655,-1,9656,9642,9521,9657,-1,9521,9523,9658,9657,-1,9659,9580,9579,9660,-1,9660,9579,9621,9661,-1,9661,9621,9654,9662,-1,9662,9654,9617,9663,-1,9664,9619,9642,9656,-1,9665,9666,9658,9523,-1,9667,9668,9666,9665,-1,9619,9664,9663,9617,-1,9483,9050,9443,-1,9669,9670,9671,-1,9612,9672,9673,9613,-1,9618,9617,9654,9655,-1,9672,9674,9675,9673,-1,9674,9676,9677,9675,-1,9678,9669,9671,-1,9676,9679,9680,9677,-1,9643,9642,9619,9620,-1,9649,9681,9682,9650,-1,9683,9684,9685,9686,-1,9687,9683,9686,9688,-1,9689,9687,9688,9690,-1,9689,9690,9691,-1,9692,9693,9694,-1,9695,9694,9693,9696,-1,9697,9698,9695,9696,-1,9684,9658,9699,9700,-1,9666,9649,9648,9701,-1,9658,9666,9701,9699,-1,9700,9702,9685,9684,-1,9648,9700,9699,9701,-1,9700,9648,9647,9702,-1,9692,9703,9693,-1,9647,9650,9704,9705,-1,9702,9647,9705,9706,-1,9685,9702,9706,9707,-1,9686,9685,9707,9708,-1,9688,9686,9708,9709,-1,9690,9688,9709,9710,-1,9691,9690,9710,9711,-1,9691,9711,9703,-1,9696,9693,9703,9712,-1,9697,9696,9712,9713,-1,9650,9682,9714,9704,-1,9691,9692,9689,-1,9692,9691,9703,-1,9715,9716,9717,9718,-1,9698,9697,9682,9681,-1,9697,9713,9714,9682,-1,9584,9719,9720,9587,-1,9721,9722,9723,-1,9595,9592,9724,9725,-1,9591,9726,9724,9592,-1,9589,9588,9597,9596,-1,9720,9719,9523,9522,-1,9727,9728,9729,9730,-1,9731,9732,9728,9727,-1,9732,9733,9734,9728,-1,9735,9724,9600,-1,9735,9600,9603,-1,9603,9646,9736,9735,-1,9735,9736,9725,9724,-1,9644,9602,9607,9606,-1,9724,9726,9601,9600,-1,9727,9730,9737,9738,-1,9739,9740,9741,9742,-1,9729,9728,9734,9743,-1,9744,9745,9737,9730,-1,9746,9630,9628,9627,-1,9679,9610,9611,9680,-1,9747,9625,9624,9748,-1,9624,9628,9749,9748,-1,9628,9630,9629,9749,-1,9472,9263,9265,9750,-1,9262,9255,9252,9266,-1,9244,9247,9249,9254,-1,9243,9534,9751,9248,-1,9752,9533,9422,9419,-1,9246,9248,9751,9752,9419,-1,9078,9435,8964,9073,-1,9421,9532,9531,9418,-1,9605,9753,9754,9606,-1,9741,9744,9742,-1,9755,9756,9729,9743,-1,9756,9730,9729,-1,9258,9238,9515,9516,-1,9232};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_35()
		{
			int[] value = {9757,9758,9469,-1,9234,9236,9241,-1,9233,9469,9515,9237,-1,9540,9539,9537,9538,-1,9645,9644,9606,9754,-1,9192,9220,9226,9231,-1,9152,9193,9230,-1,9468,9229,9228,9467,-1,9219,9210,9227,-1,9466,9465,9211,-1,9174,9462,9218,-1,9212,9175,9217,-1,9460,9459,9197,9207,-1,9204,9208,9206,-1,9200,9205,9199,9160,-1,9173,9161,9198,-1,9194,9066,9456,-1,9129,9067,9196,-1,9457,9130,9195,-1,9190,9182,9184,-1,9454,9176,9185,9181,-1,9461,9171,9452,-1,9157,9162,9451,9170,-1,9146,9141,9449,9150,-1,9137,9124,9135,-1,9138,9134,9133,9144,-1,9126,9140,9132,-1,9116,8968,9114,-1,9117,9113,9112,9448,-1,8971,9080,9111,-1,9671,9759,9678,-1,9443,9444,9440,9442,-1,9664,9687,9689,-1,9656,9683,9687,9664,-1,9657,9684,9683,9656,-1,9658,9684,9657,-1,9668,9649,9666,-1,9716,9681,9649,9668,-1,9715,9698,9681,9716,-1,9660,9695,9698,9659,-1,9661,9694,9695,9660,-1,9662,9692,9694,9661,-1,9663,9689,9692,9662,-1,9664,9689,9663,-1,9719,9665,9523,-1,9584,9652,9665,9719,-1,9583,9653,9652,9584,-1,9558,9555,9556,9559,-1,9589,9760,9761,9586,-1,9596,9762,9760,9589,-1,9599,9763,9762,9596,-1,9609,9764,9763,9599,-1,9764,9604,9607,9763,-1,9602,9762,9763,9607,-1,9591,9760,9726,-1,9761,9760,9591,9590,-1,9566,9561,9564,9567,-1,9601,9762,9602,-1,9726,9760,9762,9601,-1,9562,9557,9560,9563,-1,9634,9765,9766,9633,-1,9636,9766,9765,9637,-1,9576,9667,9665,9652,-1,9575,9767,9718,9717,-1,9587,9585,9584,-1,9586,9768,9585,9587,-1,9761,9769,9768,9586,-1,9590,9770,9769,9761,-1,9593,9722,9770,9590,-1,9723,9722,9593,9594,-1,9568,9722,9721,9570,-1,9567,9770,9722,9568,-1,9564,9769,9770,9567,-1,9563,9768,9769,9564,-1,9560,9585,9768,9563,-1,9559,9583,9585,9560,-1,9556,9653,9583,9559,-1,9554,9577,9653,9556,-1,9578,9577,9554,9553,-1,9550,8960,9511,9520,-1,9570,9771,9772,9569,-1,9721,9773,9771,9570,-1,9723,9774,9773,9721,-1,9594,9774,9723,-1,9595,9775,9774,9594,-1,9725,9776,9775,9595,-1,9736,9777,9776,9725,-1,9646,9733,9777,9736,-1,9645,9734,9733,9646,-1,9754,9743,9734,9645,-1,9753,9755,9743,9754,-1,9639,9740,9739,9640,-1,9602,9644,9603,-1,9578,9778,9779,9575,-1,9553,9780,9781,9578,-1,9552,9782,9780,9553,-1,9717,9667,9576,9575,-1,9716,9668,9667,9717,-1,9574,9573,9779,9778,-1,9581,9580,9718,9767,-1,9659,9715,9718,9580,-1,9698,9715,9659,-1,9550,9780,9782,9549,-1,9520,9781,9780,9550,-1,9519,9783,9781,9520,-1,9505,9784,9783,9519,-1,9504,9784,9505,-1,9484,9785,9784,9504,-1,9483,9670,9785,9484,-1,9443,9671,9670,9483,-1,9442,9671,9443,-1,9064,9759,9671,-1,9786,9759,9064,9063,-1,8980,9439,9437,-1,8979,9787,9788,9438,-1,9100,9102,9334,9298,-1,8991,8996,9103,9099,-1,9088,9474,9002,8995,-1,9091,9093,9165,-1,9086,9081,9094,9090,-1,9447,9391,9445,-1,9072,9074,9079,-1,9434,9121,9075,9071,-1,9432,9431,9530,9455,-1,9651,9789,9786,9223,9225,-1,9063,9059,9223,9786,-1,6376,6299,6314,6378,-1,6318,6317,6349,6350,-1,6352,6310,6306,6388,-1,9426,9025,9033,9428,-1,6379,6322,6340,6382,-1,6383,6343,6346,6385,-1,6386,6336,6332,6391,-1,6389,6356,6327,6319,-1,6305,6375,6387,-1,6351,6348,6307,-1,6331,6354,6390,-1,6384,6345,6333,-1,6339,6341,6381,-1,6334,6344,6342,6338,-1,6324,6328,6355,6330,-1,6380,6326,6323,-1,6313,6315,6377,-1,6308,6347,6316,6312,-1,6301,6296,6374,6304,-1,6371,6297,6300,-1,9048,9036,9429,-1,9039,9029,9022,9032,-1,9042,9026,9427,-1,9035,9027,9038,9425,-1,9424,9037,9031,9040,-1,9041,9030,9021,9023,-1,9024,9020,9028,9034,-1,9014,9016,9371,-1,9006,9008,9017,9013,-1,8998,9000,9009,9005,-1,8990,8992,9001,8997,-1,8983,8985,8993,8989,-1,8975,8977,9423,8982,-1,9509,9790,8978,8974,-1,9756,9742,9744,9730,-1,9755,9739,9742,9756,-1,9753,9640,9739,9755,-1,9605,9635,9640,9753,-1,9604,9636,9635,9605,-1,9764,9766,9636,9604,-1,9609,9633,9766,9764,-1,9608,9632,9633,9609,-1,9610,9629,9632,9608,-1,9679,9749,9629,9610,-1,9676,9748,9749,9679,-1,9674,9747,9748,9676,-1,9672,9669,9747,9674,-1,9791,9670,9669,9672,-1,9785,9670,9791,-1,9641,9611,9522,-1,9643,9680,9611,9641,-1,9620,9677,9680,9643,-1,9616,9675,9677,9620,-1,9618,9673,9675,9616,-1,9655,9613,9673,9618,-1,9622,9614,9613,9655,-1,9582,9572,9614,9622,-1,9581,9573,9572,9582,-1,9767,9779,9573,9581,-1,9575,9779,9767,-1,9597,9522,9611,9598,-1,9588,9720,9522,9597,-1,9587,9720,9588,-1,9612,9791,9672,-1,9615,9785,9791,9612,-1,9571,9784,9785,9615,-1,9574,9783,9784,9571,-1,9778,9781,9783,9574,-1,9578,9781,9778,-1,9792,9793,9794,9795,9796,9797,9798,9799,9800,9801,9802,9803,-1,9709,9793,9792,9710,-1,9710,9792,9803,9711,-1,9711,9803,9802,9703,-1,9703,9802,9801,9712,-1,9712,9801,9800,9713,-1,9713,9800,9799,9714,-1,9714,9799,9798,9704,-1,9704,9798,9797,9705,-1,9705,9797,9796,9706,-1,9706,9796,9795,9707,-1,9707,9795,9794,9708,-1,9708,9794,9793,9709,-1,9804,9531,9532,9805,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_36()
		{
			int[] value = {9806,9528,9531,9804,-1,9806,9807,9529,9528,-1,9804,9627,9623,9806,-1,9805,9746,9627,9804,-1,9422,8965,9419,-1,9421,8969,8966,9422,-1,9418,8961,8970,9421,-1,9431,9433,8962,9418,-1,9419,9420,9250,9246,-1,9789,9678,9759,9786,-1,9807,9806,9623,9626,-1,3935,9389,9808,3939,-1,9525,9808,9389,9388,-1,9107,9106,9809,9524,-1,9527,9526,9417,9416,-1,9788,9809,9106,9438,-1,8979,8978,9790,9787,-1,9119,9118,9543,9544,-1,9545,9750,9265,9268,-1,9240,9471,9546,9548,-1,9547,9757,9232,9235,-1,9540,9469,9758,9541,-1,9538,9515,9469,9540,-1,9535,9516,9515,9538,-1,9243,9245,9516,9535,-1,9530,9651,9191,9455,-1,9529,9651,9530,-1,9807,9789,9651,9529,-1,9626,9678,9789,9807,-1,9625,9678,9626,-1,9747,9669,9678,9625,-1,9671,9442,9065,9064,-1,6528,6529,6530,-1,6531,6532,6533,-1,6530,6534,6535,6528,-1,6528,6535,6536,6529,-1,6529,6536,6534,6530,-1,6535,6537,6538,6536,-1,6536,6538,6539,6534,-1,6534,6539,6537,6535,-1,6538,6540,6541,6539,-1,6539,6541,6542,6537,-1,6537,6542,6540,6538,-1,6542,6543,6544,6540,-1,6540,6544,6545,6541,-1,6541,6545,6543,6542,-1,6544,6533,6532,6545,-1,6543,6531,6533,6544,-1,6545,6532,6531,6543,-1,6546,6547,6548,-1,6549,6550,6551,-1,6548,6552,6553,6546,-1,6546,6553,6554,6547,-1,6547,6554,6552,6548,-1,6553,6555,6556,6554,-1,6554,6556,6557,6552,-1,6552,6557,6555,6553,-1,6556,6558,6559,6557,-1,6557,6559,6560,6555,-1,6555,6560,6558,6556,-1,6560,6561,6562,6558,-1,6558,6562,6563,6559,-1,6559,6563,6561,6560,-1,6562,6551,6550,6563,-1,6561,6549,6551,6562,-1,6563,6550,6549,6561,-1,6564,6565,6566,-1,6567,6568,6569,-1,6566,6570,6571,6564,-1,6564,6571,6572,6565,-1,6565,6572,6570,6566,-1,6571,6573,6574,6572,-1,6572,6574,6575,6570,-1,6570,6575,6573,6571,-1,6574,6576,6577,6575,-1,6575,6577,6578,6573,-1,6573,6578,6576,6574,-1,6578,6579,6580,6576,-1,6576,6580,6581,6577,-1,6577,6581,6579,6578,-1,6580,6569,6568,6581,-1,6579,6567,6569,6580,-1,6581,6568,6567,6579,-1,6582,6583,6584,-1,6585,6586,6587,-1,6584,6588,6589,6582,-1,6582,6589,6590,6583,-1,6583,6590,6588,6584,-1,6589,6591,6592,6590,-1,6590,6592,6593,6588,-1,6588,6593,6591,6589,-1,6592,6594,6595,6593,-1,6593,6595,6596,6591,-1,6591,6596,6594,6592,-1,6596,6597,6598,6594,-1,6594,6598,6599,6595,-1,6595,6599,6597,6596,-1,6598,6587,6586,6599,-1,6597,6585,6587,6598,-1,6599,6586,6585,6597,-1,6600,6601,6602,-1,6603,6604,6605,-1,6602,6606,6607,6600,-1,6600,6607,6608,6601,-1,6601,6608,6606,6602,-1,6607,6609,6610,6608,-1,6608,6610,6611,6606,-1,6606,6611,6609,6607,-1,6610,6612,6613,6611,-1,6611,6613,6614,6609,-1,6609,6614,6612,6610,-1,6614,6615,6616,6612,-1,6612,6616,6617,6613,-1,6613,6617,6615,6614,-1,6616,6605,6604,6617,-1,6615,6603,6605,6616,-1,6617,6604,6603,6615,-1,6618,6619,6620,-1,6620,6621,6622,6618,-1,6618,6622,6623,6619,-1,6619,6623,6621,6620,-1,6622,6624,6625,6623,-1,6623,6625,6626,6621,-1,6621,6626,6624,6622,-1,6625,6627,6628,6626,-1,6626,6628,6629,6624,-1,6624,6629,6627,6625,-1,6629,6630,6631,6627,-1,6627,6631,6632,6628,-1,6628,6632,6630,6629,-1,6633,6634,6635,-1,6635,6636,6637,6633,-1,6633,6637,6638,6634,-1,6634,6638,6636,6635,-1,6637,6639,6640,6638,-1,6638,6640,6641,6636,-1,6636,6641,6639,6637,-1,6640,6642,6643,6641,-1,6641,6643,6644,6639,-1,6639,6644,6642,6640,-1,6644,6645,6646,6642,-1,6642,6646,6647,6643,-1,6643,6647,6645,6644,-1,6648,6649,6650,-1,6651,6652,6653,6654,-1,6654,6653,6655,6656,-1,6656,6655,6652,6651,-1,6653,6657,6658,6655,-1,6655,6658,6659,6652,-1,6652,6659,6657,6653,-1,6658,6660,6661,6659,-1,6659,6661,6662,6657,-1,6657,6662,6660,6658,-1,6662,6663,6664,6660,-1,6660,6664,6665,6661,-1,6661,6665,6663,6662,-1,6664,6650,6649,6665,-1,6663,6648,6650,6664,-1,6665,6649,6648,6663,-1,6666,6667,6668,-1,6668,6669,6670,6666,-1,6666,6670,6671,6667,-1,6667,6671,6669,6668,-1,6670,6672,6673,6671,-1,6671,6673,6674,6669,-1,6669,6674,6672,6670,-1,6673,6675,6676,6674,-1,6674,6676,6677,6672,-1,6672,6677,6675,6673,-1,6678,6679,6680,-1,6681,6682,6683,-1,6680,6684,6685,6678,-1,6678,6685,6686,6679,-1,6679,6686,6684,6680,-1,6685,6687,6688,6686,-1,6686,6688,6689,6684,-1,6684,6689,6687,6685,-1,6688,6690,6691,6689,-1,6689,6691,6692,6687,-1,6687,6692,6690,6688,-1,6692,6693,6694,6690,-1,6690,6694,6695,6691,-1,6691,6695,6693,6692,-1,6694,6683,6682,6695,-1,6693,6681,6683,6694,-1,6695,6682,6681,6693,-1,6696,6697,6698,-1,6699,6700,6701,-1,6698,6702,6703,6696,-1,6696,6703,6704,6697,-1,6697,6704,6702,6698,-1,6703,6705,6706,6704,-1,6704,6706,6707,6702,-1,6702,6707,6705,6703,-1,6706,6708,6709,6707,-1,6707,6709,6710,6705,-1,6705,6710,6708,6706,-1,6710,6711,6712,6708,-1,6708,6712,6713,6709,-1,6709,6713,6711,6710,-1,6712,6701,6700,6713,-1,6711,6699,6701,6712,-1,6713,6700,6699,6711,-1,6714,6715,6716,6717,-1,6717};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_37()
		{
			int[] value = {6716,6718,6719,-1,6719,6718,6715,6714,-1,6716,6720,6721,6718,-1,6718,6721,6722,6715,-1,6715,6722,6720,6716,-1,6723,6724,6725,-1,6725,6726,6727,6723,-1,6723,6727,6728,6724,-1,6724,6728,6726,6725,-1,6727,6729,6730,6728,-1,6728,6730,6731,6726,-1,6726,6731,6729,6727,-1,6732,6733,6734,-1,6734,6735,6736,6732,-1,6732,6736,6737,6733,-1,6733,6737,6735,6734,-1,6736,6738,6739,6737,-1,6737,6739,6740,6735,-1,6735,6740,6738,6736,-1,6741,6742,6743,-1,6743,6744,6745,6741,-1,6741,6745,6746,6742,-1,6742,6746,6744,6743,-1,6745,6747,6748,6746,-1,6746,6748,6749,6744,-1,6744,6749,6747,6745,-1,6632,6631,6630,-1,6647,6646,6645,-1,6677,6676,6675,-1,6722,6721,6720,-1,6731,6730,6729,-1,6740,6739,6738,-1,6656,6651,6654,-1,6719,6714,6717,-1,6972,6973,6974,-1,6975,6976,6977,-1,6974,6978,6979,6972,-1,6972,6979,6980,6973,-1,6973,6980,6978,6974,-1,6979,6981,6982,6980,-1,6980,6982,6983,6978,-1,6978,6983,6981,6979,-1,6982,6984,6985,6983,-1,6983,6985,6986,6981,-1,6981,6986,6984,6982,-1,6986,6987,6988,6984,-1,6984,6988,6989,6985,-1,6985,6989,6987,6986,-1,6988,6977,6976,6989,-1,6987,6975,6977,6988,-1,6989,6976,6975,6987,-1,6990,6991,6992,-1,6992,6993,6994,6990,-1,6990,6994,6995,6991,-1,6991,6995,6993,6992,-1,6994,6996,6997,6995,-1,6995,6997,6998,6993,-1,6993,6998,6996,6994,-1,6997,6999,7000,6998,-1,6998,7000,7001,6996,-1,6996,7001,6999,6997,-1,7001,7002,7003,6999,-1,6999,7003,7004,7000,-1,7000,7004,7002,7001,-1,7005,7006,7007,-1,7008,7009,7010,7011,-1,7011,7010,7012,7013,-1,7013,7012,7009,7008,-1,7010,7014,7015,7012,-1,7012,7015,7016,7009,-1,7009,7016,7014,7010,-1,7015,7017,7018,7016,-1,7016,7018,7019,7014,-1,7014,7019,7017,7015,-1,7019,7020,7021,7017,-1,7017,7021,7022,7018,-1,7018,7022,7020,7019,-1,7021,7007,7006,7022,-1,7020,7005,7007,7021,-1,7022,7006,7005,7020,-1,7023,7024,7025,-1,7026,7027,7028,-1,7025,7029,7030,7023,-1,7023,7030,7031,7024,-1,7024,7031,7029,7025,-1,7030,7032,7033,7031,-1,7031,7033,7034,7029,-1,7029,7034,7032,7030,-1,7033,7035,7036,7034,-1,7034,7036,7037,7032,-1,7032,7037,7035,7033,-1,7037,7038,7039,7035,-1,7035,7039,7040,7036,-1,7036,7040,7038,7037,-1,7039,7028,7027,7040,-1,7038,7026,7028,7039,-1,7040,7027,7026,7038,-1,7041,7042,7043,-1,7044,7045,7046,-1,7043,7047,7048,7041,-1,7041,7048,7049,7042,-1,7042,7049,7047,7043,-1,7048,7050,7051,7049,-1,7049,7051,7052,7047,-1,7047,7052,7050,7048,-1,7051,7053,7054,7052,-1,7052,7054,7055,7050,-1,7050,7055,7053,7051,-1,7055,7056,7057,7053,-1,7053,7057,7058,7054,-1,7054,7058,7056,7055,-1,7057,7046,7045,7058,-1,7056,7044,7046,7057,-1,7058,7045,7044,7056,-1,7004,7003,7002,-1,7013,7008,7011,-1,5910,5909,6084,6085,-1,5914,5913,6086,6087,-1,6088,6089,6085,6084,-1,6090,6091,6087,6086,-1,6092,6093,6094,6095,-1,6096,6097,6098,6099,-1,6099,6094,6093,6096,-1,6090,6086,6085,6089,-1,6086,5913,5910,6085,-1,5930,6100,6101,5927,-1,6100,6102,6103,6101,-1,6104,6105,6106,6107,-1,6108,6104,6107,-1,6109,6110,6101,6103,-1,6110,5940,5927,6101,-1,6111,6112,6102,6100,-1,5943,6111,6100,5930,-1,6095,6094,6089,6088,-1,6094,6099,6090,6089,-1,6099,6098,6091,6090,-1,6104,6108,6109,-1,6105,6104,6103,6102,-1,6105,6102,6112,6113,-1,6106,6105,6113,-1,5940,6110,6084,5909,-1,6110,6109,6088,6084,-1,6109,6108,6095,6088,-1,6095,6108,6114,6092,-1,5949,6115,6116,5946,-1,6115,6117,6118,6116,-1,6117,6119,6120,6118,-1,6120,6119,6121,-1,6096,6093,6122,6123,-1,6093,6092,6124,6122,-1,6092,6114,6125,6124,-1,6114,6107,6126,6125,-1,6107,6106,6127,6126,-1,6120,6121,6127,6106,6113,-1,6113,6112,6118,6120,-1,6112,6111,6116,6118,-1,6111,5943,5946,6116,-1,6107,6114,6108,-1,6109,6103,6104,-1,6123,6128,6097,6096,-1,6119,6117,6129,-1,6127,6121,6130,-1,6128,6123,6131,-1,5949,5966,6132,6115,-1,6115,6132,6129,6117,-1,6130,6121,6119,6129,-1,6127,6130,6133,6126,-1,6126,6133,6134,6125,-1,6125,6134,6135,6124,-1,6124,6135,6136,6122,-1,6122,6136,6131,6123,-1,6267,6268,6269,6270,6271,-1,6272,6273,6274,-1,6273,6275,6276,6274,-1,6277,6246,6245,6278,-1,6250,6279,6248,-1,6280,6251,6246,6277,-1,6281,6272,6282,6283,-1,6268,6282,6272,6274,-1,6269,6268,6274,6276,-1,6270,6269,6276,6284,-1,6271,6270,6284,6285,-1,6267,6271,6285,6286,-1,6286,6287,6288,6267,-1,6287,6283,6288,-1,6282,6288,6283,-1,6288,6282,6268,6267,-1,6278,6245,6248,6279,-1,6273,6289,6290,-1,6291,6263,6251,6280,-1,6290,6292,6275,6273,-1,6273,6272,6281,6289,-1,6250,6293,6285,6279,-1,6279,6285,6284,6278,-1,6278,6284,6276,6277,-1,6277,6276,6275,6280,-1,6280,6275,6292,6291,-1,6137,6138,6139,6140,-1,5976,6137,6140,5975,-1,6141,5979,5978,6142,-1,6143,6141,6142,6144,-1,6145,6143,6144,6146,-1,6147,6145,6146,6148,-1,6149,6147,6148,6150,-1,6151,6149,6150,6152,-1,6153,6151,6152,6154,-1,6155,6153,6154,6156};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_38()
		{
			int[] value = {-1,6157,6158,6159,6160,-1,6161,6157,6160,6162,-1,6163,6161,6162,6164,-1,6165,6166,6167,6168,-1,6169,6165,6168,6170,-1,6138,6171,6172,6139,-1,6014,6013,6173,6174,-1,6018,6175,6176,6015,-1,6177,6178,6153,6155,-1,6179,6021,5979,6141,-1,6180,6179,6141,6143,-1,6181,6180,6143,6145,-1,6182,6181,6145,6147,-1,6183,6182,6147,6149,-1,6184,6183,6149,6151,-1,6178,6184,6151,6153,-1,6177,6155,6185,-1,6158,6157,6186,6187,-1,6188,6189,6174,6173,-1,6190,6186,6189,6191,-1,6175,6018,6014,6174,-1,6192,6175,6174,6189,-1,6193,6192,6189,6186,-1,6194,6193,6186,6195,-1,6196,6194,6161,6163,-1,6197,6198,6166,6165,-1,6199,6197,6165,6169,-1,6200,6201,6171,6138,-1,6202,6200,6138,6137,-1,6046,6202,6137,5976,-1,6021,6179,6203,6047,-1,6203,6179,6204,-1,6180,6205,6206,-1,6188,6191,6189,-1,6175,6192,6207,6176,-1,6208,6193,6194,-1,6192,6193,6208,6207,-1,6209,6210,6211,-1,6210,6212,6213,6211,-1,6212,6214,6215,6213,-1,6214,6062,6061,6215,-1,6015,6176,6215,6061,-1,6176,6207,6213,6215,-1,6207,6208,6211,6213,-1,6208,6194,6196,6211,-1,6197,6216,6210,6198,-1,6216,6217,6218,-1,6217,6219,6220,6218,-1,6219,6069,6068,6220,-1,6062,6214,6221,6070,-1,6214,6212,6222,6221,-1,6212,6210,6216,6222,-1,6197,6199,6216,-1,6157,6195,6186,-1,6173,6013,5914,6087,-1,6188,6173,6087,6091,-1,6191,6188,6091,6098,-1,6098,6097,6190,6191,-1,6223,6181,6224,-1,6181,6182,6225,6224,-1,6182,6183,6226,6225,-1,6183,6184,6227,6226,-1,6184,6178,6228,6227,-1,6228,6177,6185,-1,6181,6223,6205,6180,-1,6180,6206,6204,6179,-1,6097,6185,6190,-1,6190,6185,6229,-1,6128,6185,6097,-1,6204,6206,6129,-1,6205,6223,6130,-1,5966,6047,6203,6132,-1,6132,6203,6204,6129,-1,6205,6130,6129,6206,-1,6130,6223,6224,6133,-1,6133,6224,6225,6134,-1,6134,6225,6226,6135,-1,6135,6226,6227,6136,-1,6136,6227,6228,6131,-1,6131,6228,6128,-1,6228,6185,6128,-1,6178,6177,6228,-1,6070,6221,6220,6068,-1,6221,6222,6218,6220,-1,6218,6222,6216,-1,6201,6200,6217,-1,6200,6202,6219,6217,-1,6046,6069,6219,6202,-1,6217,6216,6201,-1,6164,6230,6231,6163,-1,6163,6231,6209,6196,-1,6196,6209,6211,-1,6210,6209,6198,-1,6198,6209,6231,6166,-1,6166,6231,6230,6167,-1,6170,6172,6171,6169,-1,6169,6171,6201,6199,-1,6199,6201,6216,-1,6229,6185,6155,6232,-1,6232,6155,6156,6233,-1,6233,6159,6158,6232,-1,6232,6158,6187,6229,-1,6187,6186,6190,-1,6190,6229,6187,-1,6157,6161,6195,-1,6195,6161,6194,-1,9810,8959,8958,-1,9811,9812,9813,9814,-1,9815,9816,9817,9818,-1,9819,9820,9821,9822,-1,9823,9824,9825,9826,-1,9827,9828,9829,9830,-1,9831,9832,9833,9834,-1,9835,9836,9837,-1,9838,9839,9840,9841,-1,9842,9843,9844,9845,-1,9846,9847,9848,9849,-1,9850,9851,9852,9853,-1,9854,9855,9856,9857,-1,9858,9859,9860,9861,-1,9862,9863,9864,9865,-1,9866,9867,9868,9869,-1,9870,9871,9872,-1,9873,9874,9875,9876,-1,9877,9878,9879,-1,9880,9881,9882,-1,9883,9884,9885,9886,-1,9887,9888,9889,-1,6411,6412,6413,6414,6415,-1,9890,9891,9892,9893,9894,-1,9895,9896,9897,-1,9898,9899,9900,9901,-1,6416,6417,6418,6419,-1,6420,6421,6422,6423,-1,6424,6425,6426,6427,-1,6428,6429,6430,6431,-1,6432,6433,6434,-1,6435,6436,6437,6438,-1,6439,6440,6441,6442,-1,6443,6444,6445,-1,6446,6447,6448,6449,-1,6450,6451,6452,6453,-1,6454,6455,6456,6457,-1,6458,6459,6460,-1,9902,9903,9904,-1,6461,6462,6463,-1,9905,9906,9907,9908,-1,6464,6465,6466,-1,6467,6468,6469,6470,-1,6471,6472,6473,-1,9909,9910,9911,-1,9912,9913,9914,9915,-1,9916,9917,9918,9919,-1,9920,9921,9922,9923,-1,9924,9925,9926,9927,-1,9928,9929,9930,-1,9931,9932,9933,9934,-1,9935,9936,9937,9938,-1,9939,9940,9941,9942,-1,9943,9944,9945,9946,9947,-1,9948,9949,9950,9951,-1,9952,9953,9954,9955,-1,9956,9957,9958,9959,-1,9960,9961,9962,-1,9963,9964,9965,-1,9966,9967,9968,9969,9970,-1,9971,9972,9973,9974,9975,-1,9976,9977,9978,9979,9980,-1,9981,9982,9983,-1,9984,9985,9986,-1,9987,9988,9989,9990,9991,9992,-1,9993,3943,3944,9994,9995,-1,9996,9997,9998,9999,10000,-1,10001,10002,10003,10004,-1,10005,10006,3986,3987,-1,10007,10008,10009,10010,-1,10011,10012,10013,10014,10015,-1,10016,10017,10018,10019,10020,-1,10021,10022,10023,10024,-1,10025,10026,10027,-1,10028,10029,10030,10031,-1,10032,10033,10034,10035,-1,10036,10037,10038,10039,-1,10040,10041,10042,10043,-1,10044,10045,10046,-1,10047,10048,10049,-1,10050,10051,10052,-1,10053,10054,3999,4000,10055,-1,10056,10057,10058,-1,10059,10060,10061,10062,-1,10063,10064,10065,10066,-1,10067,10068,10069,-1,10070,10071,10072,10073,-1,10074,10075,10076,-1,10077,10078,10079,-1,10080,10081,10082,-1,10083,10084,10085,10086,-1,10087,10088,10089,10090,-1,10091,10092,10093,-1,10094,10095,10096,-1,10097,10098,10099,-1,10100,10101,10102,10103,-1,10104,10105,10106,10107,-1,10108,10109,10110,10111,-1,10112,10113,10114,10115,-1,10116,10117,10118,10119,-1,10120,10121,10122,-1,10123,10124,10125,10126,10127,-1,10128,10129,10130,10131,-1,10132,10133};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_39()
		{
			int[] value = {10134,10135,-1,6474,6475,6476,6477,-1,6478,6479,6480,-1,6481,6482,6483,-1,10136,10137,10138,10139,-1,10140,10141,10142,10143,-1,10144,10145,10146,10147,-1,10148,10149,10150,10151,10152,-1,10153,10154,10155,10156,-1,10157,10158,10159,10160,-1,10161,10162,10163,10164,-1,10165,10166,10167,10168,-1,6484,6485,6486,6487,-1,10169,10170,10171,10172,-1,10173,10174,10175,10176,-1,10177,10178,10179,-1,10180,10181,10182,10183,-1,10184,10185,10186,10187,-1,10188,10189,10190,10191,-1,10192,10193,10194,10195,10196,-1,10197,10198,10199,10200,-1,10201,10202,10203,10204,-1,10205,10206,10207,10208,-1,10209,10210,10211,10212,-1,10213,10214,10215,10216,-1,10217,10218,10219,10220,-1,10221,10222,10223,10224,-1,10225,10226,10227,10228,-1,10229,10230,10231,10232,-1,10233,10234,10235,10236,-1,10237,10238,10239,10240,-1,10241,9391,9390,-1,10242,10243,10244,10245,-1,10248,10249,10250,10251,-1,10252,10253,10254,-1,10255,10256,10257,-1,10258,10259,10260,10261,10262,-1,10263,10264,10265,10266,-1,10267,9814,9813,-1,10268,9818,10269,-1,10270,9822,9821,-1,10271,9818,9817,-1,9825,9824,9830,9829,-1,9833,9832,9837,10272,-1,9840,9839,9845,9844,-1,9848,9847,9853,9852,-1,9856,9855,9861,9860,-1,9864,9863,9869,9868,-1,9872,9871,9876,9875,-1,9878,9877,9870,9872,-1,9871,9870,9880,9882,-1,9885,9884,9879,9878,-1,9888,9887,9877,9879,-1,9889,9888,10273,10274,-1,9881,9880,9887,9889,-1,9882,9881,9894,9893,-1,9893,9892,9873,9876,-1,10275,10276,9874,9873,-1,9875,9874,9886,9885,-1,9883,9886,10277,9901,-1,9884,9883,10278,10273,-1,6488,6489,6412,6411,-1,9892,9891,10279,10275,-1,6418,6417,6413,6412,-1,6414,6413,6490,6491,-1,6422,6421,6492,6490,-1,6417,6416,6423,6422,-1,6426,6425,6431,6430,-1,6489,6493,6419,6418,-1,6428,6431,6416,6419,-1,6430,6429,6434,6433,-1,6429,6428,6494,6495,-1,6441,6440,6443,6445,-1,6440,6439,6449,6448,-1,6452,6451,6457,6456,-1,6496,6497,6442,6441,-1,6454,6457,6439,6442,-1,6456,6455,6460,6459,-1,6455,6454,6498,6499,-1,6499,6500,6458,6460,-1,6459,6458,6461,6463,-1,6462,6461,6501,6502,-1,6463,6462,6453,6452,-1,6502,6503,6450,6453,-1,6446,6449,6451,6450,-1,6420,6423,6425,6424,-1,6421,6420,6504,6505,-1,6466,6465,6427,6426,-1,6469,6468,6424,6427,-1,6495,6438,6432,6434,-1,6433,6432,6464,6466,-1,6465,6464,6470,6469,-1,6472,6471,6444,6443,-1,6445,6444,6437,6496,-1,6506,6470,6438,6437,-1,6448,6447,6473,6472,-1,6507,6506,6471,6473,-1,6447,6446,6508,6507,-1,9911,9910,9915,9914,-1,10280,10281,10282,-1,9813,9812,9916,10280,-1,10283,9916,9923,9922,-1,9821,10284,9811,9814,-1,9920,9923,9812,9811,-1,9922,9921,9927,9926,-1,9921,9920,9930,9929,-1,9844,9843,9835,9837,-1,9934,10285,9938,9937,-1,9941,9940,9947,9946,-1,9852,9851,9842,9845,-1,9935,9938,9843,9842,-1,9839,9838,9849,9848,-1,9950,9949,9955,9954,-1,10272,10286,9827,9830,-1,9828,9827,10287,10288,-1,6497,6436,6509,6498,-1,9903,9902,9912,9915,-1,6493,6510,6435,6494,-1,10289,10290,10291,-1,10292,9899,10293,-1,9928,9930,10284,9820,-1,9820,9819,9962,9961,-1,9817,9816,9819,9822,-1,9964,9963,9816,9815,-1,10294,10295,9445,-1,9965,9964,9970,9969,-1,9960,9962,9963,9965,-1,9961,9960,10296,9928,-1,9969,9968,10295,10296,-1,9975,9974,9917,10283,-1,9974,9973,9979,9978,-1,9980,9979,9983,9982,-1,9985,9984,9973,9972,-1,9986,9985,9992,9991,-1,9981,9983,9984,9986,-1,9982,9981,9993,9995,-1,9991,9990,3943,9993,-1,9999,9998,9994,3944,-1,9995,9994,10297,9980,-1,10003,10002,10298,10297,-1,10009,10008,10012,10011,-1,10019,10018,9943,9947,-1,10023,10022,10299,10300,-1,10286,10301,9956,10287,-1,10301,9836,10030,10029,-1,10285,9933,9836,9835,-1,10031,10030,9933,10302,-1,10034,10033,10039,10038,-1,10040,10043,10303,10039,-1,10281,9919,10304,10305,-1,9918,9917,9978,9977,-1,10047,10049,9919,9918,-1,9976,10298,10306,10307,-1,10048,10047,9977,9976,-1,10307,10304,10049,10048,-1,10300,10027,10013,10012,-1,10051,10050,10014,10013,-1,10015,10014,10055,4000,-1,10058,10057,10053,10055,-1,10027,10308,10052,10051,-1,10050,10052,10056,10058,-1,10057,10056,10309,10062,-1,10310,10066,10025,10299,-1,10068,10067,10026,10025,-1,10067,10069,10311,10312,-1,10066,10065,10069,10068,-1,10076,10075,9909,9911,-1,10065,10313,10070,10311,-1,10071,10070,10075,10074,-1,10312,10314,10315,10026,-1,10308,10315,10059,10309,-1,10314,10073,10060,10059,-1,10078,10077,10316,10060,-1,10072,10071,10046,10045,-1,10073,10072,10079,10078,-1,10077,10079,10080,10082,-1,10044,10306,10002,10001,-1,10081,10080,10045,10044,-1,10082,10081,10001,10317,-1,10318,10086,10085,-1,10085,10084,10090,10089,-1,10084,10083,10093,10092,-1,10092,10091,10087,10090,-1,10096,10095,10098,10097,-1,10099,10098,10103,10102,-1,10095,10094,10107,10106,-1,10091,10319,10108,10111,-1,10109,10108,10104,10107,-1,10319,10320,10112,10115,-1,10113,10112,9472,-1,10102,10101,10321,10268,-1,9815,10321,9966,9970,-1,10117,10116,9967,9966,-1,10105,10104,10115,10114,-1,10106,10105,10100,10103,-1,10118,10117,10101,10100,-1,10114,10113,10119,10118,-1,10322,10122,9936,9935,-1,9937,9936,9942,9941,-1,10018,10017,10064,10063,-1,10323,9903,9910,10324,-1,10325,10323,10326,9908,-1,10327,10064,10127,10126,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_40()
		{
			int[] value = {10328,9909,10313,10327,-1,10130,10129,10324,10328,-1,9905,10326,10129,10128,-1,10135,10134,9906,9905,-1,6503,6511,6512,6508,-1,6475,6474,6467,6512,-1,6468,6467,6513,6504,-1,6479,6478,6474,6477,-1,6483,6482,6480,6479,-1,10329,10330,10136,10139,-1,6476,6475,6514,6515,-1,6477,6476,6516,6483,-1,10133,10132,10140,10143,-1,10126,10125,10131,10130,-1,10128,10131,10132,10135,-1,9899,9898,10331,-1,10332,10147,10146,-1,9949,9948,10152,10151,-1,9832,9831,9841,9840,-1,9838,9841,9951,9950,-1,9948,9951,10333,10156,-1,10148,10152,10156,10155,-1,10334,10158,10122,10121,-1,10159,10334,10161,10164,-1,10167,10166,10162,10161,-1,6482,6481,6517,6518,-1,6486,6485,6481,6519,-1,6520,6521,6519,6516,-1,10171,10170,10176,10175,-1,6522,6486,6523,6524,-1,10183,10182,10335,10329,-1,10336,10335,9896,9895,-1,10151,10150,10187,10186,-1,10188,10191,10182,10181,-1,10150,10149,10189,10188,-1,10146,10145,10192,10196,-1,10193,10192,10149,10148,-1,10144,10147,9898,10337,-1,10190,10189,10145,10144,-1,9897,9896,10191,10190,-1,10276,9897,10337,10277,-1,10125,10124,10141,10140,-1,10142,10141,10177,10179,-1,10164,10163,10200,10199,-1,10175,10174,10163,10162,-1,10338,10339,10173,10176,-1,10174,10173,10202,10201,-1,10178,10177,10208,10207,-1,10203,10202,10339,10178,-1,10158,10157,9939,9942,-1,9940,9939,10020,10019,-1,10199,10198,10160,10159,-1,10209,10212,10157,10160,-1,10210,10209,10198,10197,-1,10207,10206,10204,10203,-1,10197,10200,10201,10204,-1,10016,10020,10212,10211,-1,10123,10127,10017,10016,-1,10205,10208,10124,10123,-1,10211,10210,10206,10205,-1,10121,10120,10168,10167,-1,9851,9850,10340,10322,-1,10120,10340,10213,10216,-1,9860,9859,9850,9853,-1,10214,10213,9859,9858,-1,9868,9867,9858,9861,-1,9867,9866,10217,10220,-1,6525,6526,6485,6484,-1,10223,10341,9866,9869,-1,10342,10343,10218,10217,-1,10170,10169,10343,10344,-1,10166,10165,10172,10171,-1,10219,10218,10169,10172,-1,10215,10214,10220,10219,-1,10165,10168,10216,10215,-1,9954,9953,9846,9849,-1,9847,9846,9857,9856,-1,9953,9952,10227,10226,-1,10186,10185,9952,9955,-1,10138,10137,10222,10221,-1,10139,10138,10345,10183,-1,10221,10224,10229,10232,-1,9863,9862,10224,10223,-1,9854,9857,10226,10225,-1,9855,9854,9865,9864,-1,10230,10229,9862,9865,-1,10228,10227,10185,10184,-1,10231,10230,10225,10228,-1,10180,10345,10232,10231,-1,10181,10180,10184,10187,-1,10302,9932,10035,10034,-1,9932,9931,10233,10236,-1,9946,9945,9931,9934,-1,10022,10021,10346,10310,-1,10063,10346,9944,9943,-1,10234,10233,9945,9944,-1,10235,10234,10021,10024,-1,10007,10010,3986,10006,-1,10008,10007,10024,10023,-1,10347,10235,10006,10005,-1,10236,10347,10032,10035,-1,10033,10032,10041,10040,-1,10042,10041,10005,3987,-1,9957,9956,10029,10028,-1,10239,10238,9958,9957,-1,10038,10037,10028,10031,-1,10037,10036,10240,10239,-1,9391,10241,10351,10294,-1,9929,10351,9924,9927,-1,9925,9924,10245,10244,-1,9926,9925,9971,9975,-1,9972,9971,9987,9992,-1,10244,10243,9988,9987,-1,10241,9390,10242,10245,-1,10243,10242,10246,4009,-1,10247,10246,9503,-1,10196,10195,10352,-1,10353,10251,10250,-1,9998,9997,10004,10003,-1,10317,10354,10355,10316,-1,10354,10004,10254,10253,-1,10256,10255,10356,10355,-1,10253,10252,10257,10256,-1,10258,10262,10255,10257,-1,9997,9996,10252,10254,-1,10259,10258,9996,10000,-1,10061,10356,10262,10261,-1,10062,10061,10054,10053,-1,10261,10260,3999,10054,-1,10153,10333,9831,9834,-1,9824,9823,9834,9833,-1,9509,9826,9825,-1,9823,9826,10263,10266,-1,10357,10358,8959,9810,-1,10250,10249,10359,10360,-1,10265,10264,10358,10359,-1,10155,10154,10194,10193,-1,10195,10194,10248,10251,-1,10361,10265,10249,10248,-1,10154,10153,10266,10361,-1,10088,10087,10111,10110,-1,10089,10088,10362,-1,10110,10109,10363,-1,10039,10303,10348,10036,-1,10036,10348,10350,10240,-1,10240,10350,10349,10237,-1,9959,10288,10287,9956,-1,10235,10347,10236,-1,9932,10302,9933,-1,9933,10285,9934,-1,9836,10301,10286,10272,9837,-1,10359,10358,10357,10360,-1,10265,10361,10266,-1,6527,6510,6493,6489,-1,9901,10277,10337,9898,-1,9903,10323,10325,9904,-1,6499,6498,6509,-1,6436,6496,6437,-1,6438,6495,6435,-1,6436,6497,6496,-1,6495,6494,6435,-1,10178,10339,10338,10179,-1,6486,6522,6487,-1,10222,10341,10223,-1,10183,10345,10180,-1,10156,10333,10153,-1,9919,10281,10280,9916,-1,9916,10283,9917,-1,10004,10354,10317,10001,-1,10060,10316,10355,10356,-1,10027,10300,10299,10025,-1,9928,10296,10295,10294,-1,9980,10297,10298,9976,-1,10060,10356,10061,-1,10062,10309,10059,-1,10026,10315,10308,10027,-1,10304,10307,10306,10044,-1,10314,10312,10311,10070,-1,10066,10310,10346,10063,-1,10064,10327,10313,10065,-1,9820,10284,9821,-1,9818,10268,10321,9815,-1,10294,10351,9929,9928,-1,10093,10320,10319,10091,-1,10073,10314,10070,-1,10046,10305,10304,10044,-1,9909,10328,10324,9910,-1,6483,6516,6519,6481,-1,10330,10329,10335,10336,-1,6507,6508,6512,-1,6512,6506,6507,-1,6470,6506,6512,6467,-1,9907,10364,9908,-1,9908,10326,9905,-1,9897,10276,9895,-1,10276,10275,10279,10365,9895,-1,10122,10322,10340,10120,-1,10158,10334,10159,-1,10357,10366,10367,10360,-1,10368,10369,10370,-1,10356,10255,10262,-1,9996,10258,10257,10252,-1,9997,10254,10004,-1,10246,10242,9390,9503,-1,9945,10233,9931,-1,9933,10030,9836,-1,9944,10346,10021,10234,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_41()
		{
			int[] value = {6526,6517,6481,6485,-1,9912,9902,10290,10289,-1,10169,10218,10343,-1,10341,10342,10217,9866,-1,9862,10229,10224,-1,10138,10221,10232,10345,-1,10141,10124,10208,10177,-1,9843,9938,10285,9835,-1,9951,9841,9831,10333,-1,10185,10227,9952,-1,10238,9525,9524,9958,-1,10263,9826,9509,9526,-1,10358,10264,9527,8959,-1,10265,10359,10249,-1,9823,10266,10153,9834,-1,9956,10301,10029,-1,10361,10248,10194,10154,-1,10352,10195,10251,10353,-1,10313,9909,10075,10070,-1,10282,10371,10372,10373,-1,10267,10282,10373,10374,-1,10375,10271,10270,10376,-1,10377,10378,10096,10379,-1,10380,10378,10377,10381,-1,9542,9541,10382,10383,-1,10054,10061,10261,-1,10253,10256,10355,10354,-1,9984,9983,9979,9973,-1,10351,10241,10245,9924,-1,9543,9445,10295,9968,-1,9545,9544,9967,10116,-1,10320,9546,9472,10112,-1,10065,10311,10069,-1,10002,10306,10298,-1,9978,9917,9974,-1,9816,9963,9962,9819,-1,10117,9966,10321,10101,-1,10108,10319,10115,10104,-1,10107,10094,10363,10109,-1,10087,10091,10111,-1,9548,10093,10083,9547,-1,10384,9810,8958,9549,-1,10385,10386,9552,9551,-1,10387,10385,9551,9555,-1,10388,10389,9558,9557,-1,10390,10391,9562,9561,-1,10392,10393,9566,9565,-1,10394,10392,9565,9569,-1,10353,10250,10360,10367,-1,10395,10396,10397,10398,-1,10399,10400,10401,10402,-1,10403,10404,10405,10406,-1,10407,10408,10409,-1,10410,10411,10412,10413,-1,10414,10415,10416,10417,-1,10418,10415,10414,10419,-1,10420,10421,10422,10423,-1,10424,10425,10426,10427,-1,10428,10429,10430,10431,-1,10421,10420,10432,10433,-1,10434,10421,10433,10435,-1,10436,10437,10438,10439,-1,10440,10441,10442,-1,10443,10442,10441,10444,-1,10445,10403,10406,10446,-1,10398,10397,10437,10436,-1,10331,9898,10147,10332,-1,9910,9903,9915,-1,10447,10448,10449,10450,-1,10450,10449,10451,10452,-1,10453,10454,10455,10456,-1,10457,10454,10453,10458,-1,10459,10460,10461,10462,-1,10462,10463,10464,10459,-1,10465,10370,10369,-1,10370,10465,10466,10467,-1,9939,10157,10212,10020,-1,9936,10122,10158,9942,-1,9859,10213,10340,9850,-1,10226,9857,9846,9953,-1,10424,10468,10469,10470,-1,10471,10472,10473,10474,-1,10243,4009,9988,-1,9987,9971,9925,10244,-1,9916,9812,9923,-1,10037,10239,9957,10028,-1,10120,10216,10168,-1,10160,10198,10209,-1,10202,10173,10339,-1,6521,6523,6486,6519,-1,10156,10152,9948,-1,10191,9896,10335,10182,-1,6513,6467,6474,6478,-1,6512,6511,6514,6475,-1,10007,10006,10235,10024,-1,10041,10032,10347,10005,-1,9932,10236,10035,-1,10192,10145,10189,10149,-1,10127,10064,10017,-1,10230,9865,9854,10225,-1,9867,10220,10214,9858,-1,10180,10231,10228,10184,-1,10215,10219,10172,10165,-1,10174,10201,10200,10163,-1,10188,10181,10187,10150,-1,10204,10206,10210,10197,-1,10205,10123,10016,10211,-1,10203,10178,10207,-1,10018,10063,9943,-1,10129,10326,10323,10324,-1,6451,6449,6439,6457,-1,6425,6423,6416,6431,-1,9897,10190,10144,10337,-1,10338,10176,10170,10344,-1,10175,10162,10166,10171,-1,10161,10334,10121,10167,-1,10193,10148,10155,-1,10332,10146,10196,10352,-1,10131,10125,10140,10132,-1,6518,6480,6482,-1,6476,6515,6520,6516,-1,10329,10139,10183,-1,6479,6477,6483,-1,10128,10135,9905,-1,10130,10328,10327,10126,-1,10074,10475,10046,10071,-1,10159,10164,10199,-1,10400,10476,10477,10401,-1,10478,10445,10446,10479,-1,10480,10370,10467,10481,-1,10480,10482,10368,10370,-1,10483,10406,10405,10484,-1,10485,10446,10406,10483,-1,10486,10479,10446,10485,-1,10487,10441,10479,10486,-1,10481,10467,10444,10488,-1,10368,10482,10489,10490,-1,10490,10489,10491,10492,-1,10441,10487,10488,10444,-1,10293,9899,10331,-1,10493,10494,10495,-1,10438,10496,10497,10439,-1,10478,10479,10441,10440,-1,10496,10498,10499,10497,-1,10498,10500,10501,10499,-1,10493,10495,10502,-1,10500,10503,10504,10501,-1,10443,10444,10467,10466,-1,10471,10505,10506,10472,-1,10507,10508,10509,10510,-1,10511,10507,10510,10512,-1,10513,10511,10512,10514,-1,10515,10513,10514,-1,10516,10517,10518,-1,10519,10517,10516,10520,-1,10519,10520,10521,10522,-1,10523,10524,10482,10509,-1,10525,10473,10472,10489,-1,10524,10525,10489,10482,-1,10509,10508,10526,10523,-1,10525,10524,10523,10473,-1,10526,10474,10473,10523,-1,10517,10527,10518,-1,10528,10529,10471,10474,-1,10530,10528,10474,10526,-1,10531,10530,10526,10508,-1,10532,10531,10508,10507,-1,10533,10532,10507,10511,-1,10534,10533,10511,10513,-1,10535,10534,10513,10515,-1,10527,10535,10515,-1,10536,10527,10517,10519,-1,10537,10536,10519,10522,-1,10529,10538,10505,10471,-1,10514,10518,10515,-1,10527,10515,10518,-1,10539,10540,10541,10542,-1,10506,10505,10522,10521,-1,10505,10538,10537,10522,-1,10412,10543,10544,10408,-1,10545,10546,10547,-1,10548,10549,10415,10418,-1,10415,10549,10550,10416,-1,10423,10422,10411,10410,-1,10369,10368,10544,10543,-1,10551,10552,10553,10554,-1,10554,10553,10555,10556,-1,10553,10557,10558,10555,-1,10427,10549,10559,-1,10424,10427,10559,-1,10559,10560,10468,10424,-1,10549,10548,10560,10559,-1,10429,10428,10425,10470,-1,10427,10426,10550,10549,-1,9738,9737,10551,10554,-1,10561,10562,10563,10564,-1,10565,10557,10553,10552,-1,10551,9737,9745,10566,-1,10452,10451,10455,10567,-1,10503,10434,10435,10504,-1,10568,10449,10448,10569,-1,10568,10570,10451,10449,-1,10570,10456,10455,10451,-1,9750,10119,10113,9472,-1,10118,10100,10105,10114,-1,10106,10103,10098,10095,-1,10097,10571,10379,10096,-1,10269,10271,10375,10572,-1,10269,10572};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_42()
		{
			int[] value = {10571,10097,10099,-1,9920,9811,10284,9930,-1,10267,10374,10376,10270,-1,10429,10573,10574,10430,-1,10561,10566,10562,-1,10565,10552,10575,10576,-1,10552,10551,10575,-1,10363,10362,10088,10110,-1,10318,9758,9757,10086,-1,10092,10090,10084,-1,10089,10362,10318,10085,-1,10380,10381,10383,10382,-1,10573,10429,10470,10469,-1,10080,10079,10072,10045,-1,10081,10044,10001,-1,10316,10077,10082,10317,-1,10078,10060,10073,-1,10059,10315,10314,-1,10067,10312,10026,-1,10068,10025,10066,-1,10056,10052,10308,10309,-1,10057,10062,10053,-1,10014,10050,10058,10055,-1,10051,10013,10027,-1,10304,9919,10049,-1,10047,9918,9977,-1,10048,9976,10307,-1,10039,10033,10040,-1,10034,10038,10031,10302,-1,10299,10022,10310,-1,10023,10300,10012,10008,-1,10003,10297,9994,9998,-1,9985,9972,9992,-1,9993,9981,9986,9991,-1,9982,9995,9980,-1,9964,9815,9970,-1,10296,9960,9965,9969,-1,9961,9928,9820,-1,10502,10577,10493,-1,10289,10291,10292,10293,-1,10514,10512,10488,-1,10488,10512,10510,10481,-1,10481,10510,10509,10480,-1,10480,10509,10482,-1,10489,10472,10491,-1,10491,10472,10506,10541,-1,10541,10506,10521,10542,-1,10484,10521,10520,10483,-1,10483,10520,10516,10485,-1,10485,10516,10518,10486,-1,10486,10518,10514,10487,-1,10487,10514,10488,-1,10368,10490,10544,-1,10544,10490,10477,10408,-1,10408,10477,10476,10409,-1,10389,10387,9555,9558,-1,10413,10578,10579,10410,-1,10410,10579,10580,10423,-1,10423,10580,10581,10420,-1,10420,10581,10582,10432,-1,10581,10428,10431,10582,-1,10428,10581,10580,10425,-1,10550,10579,10416,-1,10417,10416,10579,10578,-1,10393,10390,9561,9566,-1,10425,10580,10426,-1,10426,10580,10579,10550,-1,10391,10388,9557,9562,-1,10458,10583,10584,10457,-1,10460,10584,10583,10461,-1,10477,10490,10492,10401,-1,10540,10539,10585,10402,-1,10408,10407,10412,-1,10412,10407,10586,10413,-1,10413,10586,10587,10578,-1,10578,10587,10588,10417,-1,10417,10588,10546,10414,-1,10419,10414,10546,10545,-1,10394,10547,10546,10392,-1,10392,10546,10588,10393,-1,10393,10588,10587,10390,-1,10390,10587,10586,10391,-1,10391,10586,10407,10388,-1,10388,10407,10409,10389,-1,10389,10409,10476,10387,-1,10387,10476,10400,10385,-1,10386,10385,10400,10399,-1,10366,10357,9810,10384,-1,9569,9772,10589,10394,-1,10394,10589,10590,10547,-1,10547,10590,10591,10545,-1,10545,10591,10419,-1,10419,10591,10592,10418,-1,10418,10592,10593,10548,-1,10548,10593,10594,10560,-1,10560,10594,10558,10468,-1,10468,10558,10557,10469,-1,10469,10557,10565,10573,-1,10573,10565,10576,10574,-1,10463,10564,10563,10464,-1,10424,10470,10425,-1,10402,10595,10596,10399,-1,10399,10597,10598,10386,-1,10386,10598,9782,9552,-1,10402,10401,10492,10540,-1,10540,10492,10491,10541,-1,10596,10595,10396,10395,-1,10585,10539,10405,10404,-1,10405,10539,10542,10484,-1,10484,10542,10521,-1,9549,9782,10598,10384,-1,10384,10598,10597,10366,-1,10366,10597,10599,10367,-1,10367,10599,10600,10353,-1,10353,10600,10352,-1,10352,10600,10601,10332,-1,10332,10601,10494,10331,-1,10331,10494,10493,10293,-1,10293,10493,10289,-1,10493,10577,9913,-1,9914,9913,10577,10602,-1,10286,10287,9827,-1,10288,9788,9787,9828,-1,10151,10186,9955,9949,-1,9950,9954,9849,9838,-1,9842,9851,10322,9935,-1,10019,9947,9940,-1,9941,9946,9934,9937,-1,9445,9391,10294,-1,9929,9927,9921,-1,9922,9926,9975,10283,-1,10305,10371,10282,10281,-1,10074,10076,10602,10603,10475,-1,10602,10076,9911,9914,-1,6494,6428,6419,6493,-1,6470,6464,6432,6438,-1,6504,6420,6424,6468,-1,10277,9886,9874,10276,-1,6498,6454,6442,6497,-1,6501,6461,6458,6500,-1,6508,6446,6450,6503,-1,6437,6444,6471,6506,-1,6505,6492,6421,-1,6427,6465,6469,-1,6507,6473,6447,-1,6453,6462,6502,-1,6499,6460,6455,-1,6456,6459,6463,6452,-1,6448,6472,6443,6440,-1,6441,6445,6496,-1,6495,6434,6429,-1,6430,6433,6466,6426,-1,6422,6490,6413,6417,-1,6418,6412,6489,-1,10278,9883,9901,-1,9880,9870,9877,9887,-1,10275,9873,9892,-1,10273,9888,9879,9884,-1,9894,9881,9889,10274,-1,9876,9871,9882,9893,-1,9885,9878,9872,9875,-1,10223,9869,9863,-1,9864,9868,9861,9855,-1,9856,9860,9853,9847,-1,9848,9852,9845,9839,-1,9840,9844,9837,9832,-1,9833,10272,9830,9824,-1,9825,9829,9790,9509,-1,10551,10566,10561,10575,-1,10575,10561,10564,10576,-1,10576,10564,10463,10574,-1,10574,10463,10462,10430,-1,10430,10462,10461,10431,-1,10431,10461,10583,10582,-1,10582,10583,10458,10432,-1,10432,10458,10453,10433,-1,10433,10453,10456,10435,-1,10435,10456,10570,10504,-1,10504,10570,10568,10501,-1,10501,10568,10569,10499,-1,10499,10569,10495,10497,-1,10497,10495,10494,10604,-1,10604,10494,10601,-1,10369,10434,10465,-1,10465,10434,10503,10466,-1,10466,10503,10500,10443,-1,10443,10500,10498,10442,-1,10442,10498,10496,10440,-1,10440,10496,10438,10478,-1,10478,10438,10437,10445,-1,10445,10437,10397,10403,-1,10403,10397,10396,10404,-1,10404,10396,10595,10585,-1,10585,10595,10402,-1,10421,10434,10369,10422,-1,10422,10369,10543,10411,-1,10411,10543,10412,-1,10497,10604,10439,-1,10439,10604,10601,10436,-1,10436,10601,10600,10398,-1,10398,10600,10599,10395,-1,10395,10599,10597,10596,-1,10596,10597,10399,-1,10605,10606,10607,10608,10609,10610,10611,10612,10613,10614,10615,10616,-1,10534,10616,10615,10533,-1,10535,10605,10616,10534,-1,10527,10606,10605,10535,-1,10536,10607,10606,10527,-1,10537,10608,10607,10536,-1,10538,10609};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_43()
		{
			int[] value = {10608,10537,-1,10529,10610,10609,10538,-1,10528,10611,10610,10529,-1,10530,10612,10611,10528,-1,10531,10613,10612,10530,-1,10532,10614,10613,10531,-1,10533,10615,10614,10532,-1,10617,10376,10374,10618,-1,10618,10374,10373,10619,-1,10373,10372,10620,10619,-1,10619,10450,10452,10618,-1,10618,10452,10567,10617,-1,10269,9818,10271,-1,10271,9817,9822,10270,-1,10270,9821,9814,10267,-1,10267,9813,10280,10282,-1,10099,10102,10268,10269,-1,10602,10577,10502,10603,-1,10447,10450,10619,10620,-1,3939,9808,10237,10349,-1,10238,10237,9808,9525,-1,9524,9809,9959,9958,-1,10264,10263,9526,9527,-1,10288,9959,9809,9788,-1,9787,9790,9829,9828,-1,9544,9543,9968,9967,-1,10116,10119,9750,9545,-1,9548,9546,10320,10093,-1,10083,10086,9757,9547,-1,9541,9758,10318,10382,-1,10382,10318,10362,10380,-1,10380,10362,10363,10378,-1,10378,10363,10094,10096,-1,10305,10046,10475,10371,-1,10371,10475,10372,-1,10372,10475,10603,10620,-1,10620,10603,10502,10447,-1,10447,10502,10448,-1,10448,10502,10495,10569,-1,9913,9912,10289,10493,-1,6750,6751,6752,-1,6753,6754,6755,-1,6752,6756,6757,6750,-1,6751,6758,6756,6752,-1,6750,6757,6758,6751,-1,6758,6759,6760,6756,-1,6757,6761,6759,6758,-1,6756,6760,6761,6757,-1,6761,6762,6763,6759,-1,6760,6764,6762,6761,-1,6759,6763,6764,6760,-1,6763,6765,6766,6764,-1,6762,6767,6765,6763,-1,6764,6766,6767,6762,-1,6767,6754,6753,6765,-1,6765,6753,6755,6766,-1,6766,6755,6754,6767,-1,6768,6769,6770,-1,6771,6772,6773,-1,6770,6774,6775,6768,-1,6769,6776,6774,6770,-1,6768,6775,6776,6769,-1,6776,6777,6778,6774,-1,6775,6779,6777,6776,-1,6774,6778,6779,6775,-1,6779,6780,6781,6777,-1,6778,6782,6780,6779,-1,6777,6781,6782,6778,-1,6781,6783,6784,6782,-1,6780,6785,6783,6781,-1,6782,6784,6785,6780,-1,6785,6772,6771,6783,-1,6783,6771,6773,6784,-1,6784,6773,6772,6785,-1,6786,6787,6788,-1,6789,6790,6791,-1,6788,6792,6793,6786,-1,6787,6794,6792,6788,-1,6786,6793,6794,6787,-1,6794,6795,6796,6792,-1,6793,6797,6795,6794,-1,6792,6796,6797,6793,-1,6797,6798,6799,6795,-1,6796,6800,6798,6797,-1,6795,6799,6800,6796,-1,6799,6801,6802,6800,-1,6798,6803,6801,6799,-1,6800,6802,6803,6798,-1,6803,6790,6789,6801,-1,6801,6789,6791,6802,-1,6802,6791,6790,6803,-1,6804,6805,6806,-1,6807,6808,6809,-1,6806,6810,6811,6804,-1,6805,6812,6810,6806,-1,6804,6811,6812,6805,-1,6812,6813,6814,6810,-1,6811,6815,6813,6812,-1,6810,6814,6815,6811,-1,6815,6816,6817,6813,-1,6814,6818,6816,6815,-1,6813,6817,6818,6814,-1,6817,6819,6820,6818,-1,6816,6821,6819,6817,-1,6818,6820,6821,6816,-1,6821,6808,6807,6819,-1,6819,6807,6809,6820,-1,6820,6809,6808,6821,-1,6822,6823,6824,-1,6825,6826,6827,-1,6824,6828,6829,6822,-1,6823,6830,6828,6824,-1,6822,6829,6830,6823,-1,6830,6831,6832,6828,-1,6829,6833,6831,6830,-1,6828,6832,6833,6829,-1,6833,6834,6835,6831,-1,6832,6836,6834,6833,-1,6831,6835,6836,6832,-1,6835,6837,6838,6836,-1,6834,6839,6837,6835,-1,6836,6838,6839,6834,-1,6839,6826,6825,6837,-1,6837,6825,6827,6838,-1,6838,6827,6826,6839,-1,6840,6841,6842,-1,6842,6843,6844,6840,-1,6841,6845,6843,6842,-1,6840,6844,6845,6841,-1,6845,6846,6847,6843,-1,6844,6848,6846,6845,-1,6843,6847,6848,6844,-1,6848,6849,6850,6846,-1,6847,6851,6849,6848,-1,6846,6850,6851,6847,-1,6850,6852,6853,6851,-1,6849,6854,6852,6850,-1,6851,6853,6854,6849,-1,6855,6856,6857,-1,6857,6858,6859,6855,-1,6856,6860,6858,6857,-1,6855,6859,6860,6856,-1,6860,6861,6862,6858,-1,6859,6863,6861,6860,-1,6858,6862,6863,6859,-1,6863,6864,6865,6861,-1,6862,6866,6864,6863,-1,6861,6865,6866,6862,-1,6865,6867,6868,6866,-1,6864,6869,6867,6865,-1,6866,6868,6869,6864,-1,6870,6871,6872,-1,6873,6874,6875,6876,-1,6877,6878,6874,6873,-1,6876,6875,6878,6877,-1,6878,6879,6880,6874,-1,6875,6881,6879,6878,-1,6874,6880,6881,6875,-1,6881,6882,6883,6879,-1,6880,6884,6882,6881,-1,6879,6883,6884,6880,-1,6883,6885,6886,6884,-1,6882,6887,6885,6883,-1,6884,6886,6887,6882,-1,6887,6871,6870,6885,-1,6885,6870,6872,6886,-1,6886,6872,6871,6887,-1,6888,6889,6890,-1,6890,6891,6892,6888,-1,6889,6893,6891,6890,-1,6888,6892,6893,6889,-1,6893,6894,6895,6891,-1,6892,6896,6894,6893,-1,6891,6895,6896,6892,-1,6896,6897,6898,6894,-1,6895,6899,6897,6896,-1,6894,6898,6899,6895,-1,6900,6901,6902,-1,6903,6904,6905,-1,6902,6906,6907,6900,-1,6901,6908,6906,6902,-1,6900,6907,6908,6901,-1,6908,6909,6910,6906,-1,6907,6911,6909,6908,-1,6906,6910,6911,6907,-1,6911,6912,6913,6909,-1,6910,6914,6912,6911,-1,6909,6913,6914,6910,-1,6913,6915,6916,6914,-1,6912,6917,6915,6913,-1,6914,6916,6917,6912,-1,6917,6904,6903,6915,-1,6915,6903,6905,6916,-1,6916,6905,6904,6917,-1,6918,6919,6920,-1,6921,6922,6923,-1,6920,6924,6925,6918,-1,6919,6926,6924,6920,-1,6918,6925,6926,6919,-1,6926,6927,6928,6924,-1,6925,6929,6927,6926,-1,6924,6928,6929,6925,-1,6929,6930,6931,6927,-1,6928,6932,6930,6929,-1,6927,6931,6932};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_44()
		{
			int[] value = {6928,-1,6931,6933,6934,6932,-1,6930,6935,6933,6931,-1,6932,6934,6935,6930,-1,6935,6922,6921,6933,-1,6933,6921,6923,6934,-1,6934,6923,6922,6935,-1,6936,6937,6938,6939,-1,6940,6941,6937,6936,-1,6939,6938,6941,6940,-1,6941,6942,6943,6937,-1,6938,6944,6942,6941,-1,6937,6943,6944,6938,-1,6945,6946,6947,-1,6947,6948,6949,6945,-1,6946,6950,6948,6947,-1,6945,6949,6950,6946,-1,6950,6951,6952,6948,-1,6949,6953,6951,6950,-1,6948,6952,6953,6949,-1,6954,6955,6956,-1,6956,6957,6958,6954,-1,6955,6959,6957,6956,-1,6954,6958,6959,6955,-1,6959,6960,6961,6957,-1,6958,6962,6960,6959,-1,6957,6961,6962,6958,-1,6963,6964,6965,-1,6965,6966,6967,6963,-1,6964,6968,6966,6965,-1,6963,6967,6968,6964,-1,6968,6969,6970,6966,-1,6967,6971,6969,6968,-1,6966,6970,6971,6967,-1,6853,6852,6854,-1,6868,6867,6869,-1,6898,6897,6899,-1,6943,6942,6944,-1,6952,6951,6953,-1,6961,6960,6962,-1,6873,6876,6877,-1,6936,6939,6940,-1,7059,7060,7061,-1,7062,7063,7064,-1,7061,7065,7066,7059,-1,7060,7067,7065,7061,-1,7059,7066,7067,7060,-1,7067,7068,7069,7065,-1,7066,7070,7068,7067,-1,7065,7069,7070,7066,-1,7070,7071,7072,7068,-1,7069,7073,7071,7070,-1,7068,7072,7073,7069,-1,7072,7074,7075,7073,-1,7071,7076,7074,7072,-1,7073,7075,7076,7071,-1,7076,7063,7062,7074,-1,7074,7062,7064,7075,-1,7075,7064,7063,7076,-1,7077,7078,7079,-1,7079,7080,7081,7077,-1,7078,7082,7080,7079,-1,7077,7081,7082,7078,-1,7082,7083,7084,7080,-1,7081,7085,7083,7082,-1,7080,7084,7085,7081,-1,7085,7086,7087,7083,-1,7084,7088,7086,7085,-1,7083,7087,7088,7084,-1,7087,7089,7090,7088,-1,7086,7091,7089,7087,-1,7088,7090,7091,7086,-1,7092,7093,7094,-1,7095,7096,7097,7098,-1,7099,7100,7096,7095,-1,7098,7097,7100,7099,-1,7100,7101,7102,7096,-1,7097,7103,7101,7100,-1,7096,7102,7103,7097,-1,7103,7104,7105,7101,-1,7102,7106,7104,7103,-1,7101,7105,7106,7102,-1,7105,7107,7108,7106,-1,7104,7109,7107,7105,-1,7106,7108,7109,7104,-1,7109,7093,7092,7107,-1,7107,7092,7094,7108,-1,7108,7094,7093,7109,-1,7110,7111,7112,-1,7113,7114,7115,-1,7112,7116,7117,7110,-1,7111,7118,7116,7112,-1,7110,7117,7118,7111,-1,7118,7119,7120,7116,-1,7117,7121,7119,7118,-1,7116,7120,7121,7117,-1,7121,7122,7123,7119,-1,7120,7124,7122,7121,-1,7119,7123,7124,7120,-1,7123,7125,7126,7124,-1,7122,7127,7125,7123,-1,7124,7126,7127,7122,-1,7127,7114,7113,7125,-1,7125,7113,7115,7126,-1,7126,7115,7114,7127,-1,7128,7129,7130,-1,7131,7132,7133,-1,7130,7134,7135,7128,-1,7129,7136,7134,7130,-1,7128,7135,7136,7129,-1,7136,7137,7138,7134,-1,7135,7139,7137,7136,-1,7134,7138,7139,7135,-1,7139,7140,7141,7137,-1,7138,7142,7140,7139,-1,7137,7141,7142,7138,-1,7141,7143,7144,7142,-1,7140,7145,7143,7141,-1,7142,7144,7145,7140,-1,7145,7132,7131,7143,-1,7143,7131,7133,7144,-1,7144,7133,7132,7145,-1,7090,7089,7091,-1,7095,7098,7099,-1,7146,7147,7148,7149,-1,7150,7151,7152,7153,-1,7154,7155,7156,7157,-1,7158,7159,7160,7161,-1,7162,7163,7164,7165,-1,7166,7167,7168,7169,-1,7170,7171,7172,7173,-1,7174,7175,7176,7177,-1,7178,7179,7180,7181,-1,7182,7183,7184,7185,-1,7186,7187,7188,7189,-1,7190,7191,7192,7193,-1,7194,7195,7196,7197,-1,7198,7199,7200,7201,-1,7202,7203,7204,7205,-1,7206,7207,7208,7209,-1,7210,7211,7212,7213,-1,7214,7215,7216,7217,-1,7218,7219,7220,7221,-1,7222,7223,7224,7225,-1,7226,7227,7228,7229,-1,7230,7231,7232,7233,-1,7234,7235,7236,7237,-1,7238,7239,7240,7241,-1,7242,7243,7244,7245,-1,7246,7247,7248,7249,-1,7243,7195,7246,-1,7239,7196,7242,-1,7235,7197,7238,-1,7247,7194,7234,-1,7227,7155,7230,-1,7223,7156,7226,-1,7219,7157,7222,-1,7231,7154,7218,-1,7211,7179,7214,-1,7207,7180,7210,-1,7203,7181,7206,-1,7215,7178,7202,-1,7244,7249,7151,7198,-1,7191,7152,7248,7237,-1,7187,7153,7190,-1,7199,7150,7186,-1,7212,7217,7147,7182,-1,7175,7148,7216,7205,-1,7171,7149,7174,-1,7183,7146,7170,-1,7200,7189,7161,7169,-1,7245,7201,7168,7240,-1,7192,7236,7241,7163,-1,7162,7158,7188,7193,-1,7184,7173,7159,7165,-1,7213,7185,7164,7208,-1,7176,7204,7209,7167,-1,7166,7160,7172,7177,-1,7195,7194,7247,7246,-1,7196,7195,7243,7242,-1,7246,7249,7244,7243,-1,7197,7196,7239,7238,-1,7242,7245,7240,7239,-1,7194,7197,7235,7234,-1,7238,7241,7236,7235,-1,7234,7237,7248,7247,-1,7155,7154,7231,7230,-1,7156,7155,7227,7226,-1,7230,7233,7228,7227,-1,7157,7156,7223,7222,-1,7226,7229,7224,7223,-1,7154,7157,7219,7218,-1,7222,7225,7220,7219,-1,7218,7221,7232,7231,-1,7179,7178,7215,7214,-1,7180,7179,7211,7210,-1,7214,7217,7212,7211,-1,7181,7180,7207,7206,-1,7210,7213,7208,7207,-1,7178,7181,7203,7202,-1,7206,7209,7204,7203,-1,7202,7205,7216,7215,-1,7151,7150,7199,7198,-1,7152,7151,7249,7248,-1,7198,7201,7245,7244,-1,7153,7152,7191,7190,-1,7237,7236,7192,7191,-1,7150,7153,7187,7186,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_45()
		{
			int[] value = {7190,7193,7188,7187,-1,7186,7189,7200,7199,-1,7147,7146,7183,7182,-1,7148,7147,7217,7216,-1,7182,7185,7213,7212,-1,7149,7148,7175,7174,-1,7205,7204,7176,7175,-1,7146,7149,7171,7170,-1,7174,7177,7172,7171,-1,7170,7173,7184,7183,-1,7159,7158,7162,7165,-1,7161,7160,7166,7169,-1,7233,7232,7164,7163,-1,7225,7224,7168,7167,-1,7189,7188,7158,7161,-1,7201,7200,7169,7168,-1,7241,7240,7229,7228,-1,7193,7192,7163,7162,-1,7173,7172,7160,7159,-1,7185,7184,7165,7164,-1,7209,7208,7221,7220,-1,7177,7176,7167,7166,-1,7232,7221,7208,7164,-1,7228,7233,7163,7241,-1,7224,7229,7240,7168,-1,7220,7225,7167,7209,-1,7250,7251,7252,7253,-1,7254,7255,7256,7257,-1,7258,7259,7260,7261,-1,7262,7263,7264,7265,-1,7266,7267,7268,7269,-1,7270,7271,7272,7273,-1,7274,7275,7276,7277,-1,7278,7279,7280,7281,-1,7282,7283,7284,7285,-1,7286,7287,7288,7289,-1,7290,7291,7292,7293,-1,7294,7295,7296,7297,-1,7298,7299,7300,7301,-1,7302,7303,7304,7305,-1,7306,7307,7308,7309,-1,7310,7311,7312,7313,-1,7314,7315,7316,7317,-1,7318,7319,7320,7321,-1,7322,7323,7324,7325,-1,7326,7327,7328,7329,-1,7330,7331,7332,7333,-1,7334,7335,7336,7337,-1,7338,7339,7340,7341,-1,7342,7343,7344,7345,-1,7346,7347,7348,7349,-1,7350,7351,7352,7353,-1,7347,7299,7350,-1,7343,7300,7346,-1,7339,7301,7342,-1,7351,7298,7338,-1,7331,7259,7334,-1,7327,7260,7330,-1,7323,7261,7326,-1,7335,7258,7322,-1,7315,7283,7318,-1,7311,7284,7314,-1,7307,7285,7310,-1,7319,7282,7306,-1,7348,7353,7255,7302,-1,7295,7256,7352,7341,-1,7291,7257,7294,-1,7303,7254,7290,-1,7316,7321,7251,7286,-1,7279,7252,7320,7309,-1,7275,7253,7278,-1,7287,7250,7274,-1,7304,7293,7265,7273,-1,7349,7305,7272,7344,-1,7296,7340,7345,7267,-1,7266,7262,7292,7297,-1,7288,7277,7263,7269,-1,7317,7289,7268,7312,-1,7280,7308,7313,7271,-1,7270,7264,7276,7281,-1,7299,7298,7351,7350,-1,7300,7299,7347,7346,-1,7350,7353,7348,7347,-1,7301,7300,7343,7342,-1,7346,7349,7344,7343,-1,7298,7301,7339,7338,-1,7342,7345,7340,7339,-1,7338,7341,7352,7351,-1,7259,7258,7335,7334,-1,7260,7259,7331,7330,-1,7334,7337,7332,7331,-1,7261,7260,7327,7326,-1,7330,7333,7328,7327,-1,7258,7261,7323,7322,-1,7326,7329,7324,7323,-1,7322,7325,7336,7335,-1,7283,7282,7319,7318,-1,7284,7283,7315,7314,-1,7318,7321,7316,7315,-1,7285,7284,7311,7310,-1,7314,7317,7312,7311,-1,7282,7285,7307,7306,-1,7310,7313,7308,7307,-1,7306,7309,7320,7319,-1,7255,7254,7303,7302,-1,7256,7255,7353,7352,-1,7302,7305,7349,7348,-1,7257,7256,7295,7294,-1,7341,7340,7296,7295,-1,7254,7257,7291,7290,-1,7294,7297,7292,7291,-1,7290,7293,7304,7303,-1,7251,7250,7287,7286,-1,7252,7251,7321,7320,-1,7286,7289,7317,7316,-1,7253,7252,7279,7278,-1,7309,7308,7280,7279,-1,7250,7253,7275,7274,-1,7278,7281,7276,7275,-1,7274,7277,7288,7287,-1,7263,7262,7266,7269,-1,7265,7264,7270,7273,-1,7337,7336,7268,7267,-1,7329,7328,7272,7271,-1,7293,7292,7262,7265,-1,7305,7304,7273,7272,-1,7345,7344,7333,7332,-1,7297,7296,7267,7266,-1,7277,7276,7264,7263,-1,7289,7288,7269,7268,-1,7313,7312,7325,7324,-1,7281,7280,7271,7270,-1,7336,7325,7312,7268,-1,7332,7337,7267,7345,-1,7328,7333,7344,7272,-1,7324,7329,7271,7313,-1,7354,7355,7356,7357,-1,7358,7359,7360,7361,-1,7362,7363,7364,7365,-1,7366,7367,7368,7369,-1,7370,7371,7372,7373,-1,7374,7375,7376,7377,-1,7378,7379,7380,7381,-1,7382,7383,7384,7385,-1,7386,7387,7388,7389,-1,7390,7391,7392,7393,-1,7394,7395,7396,7397,-1,7398,7399,7400,7401,-1,7402,7403,7404,7405,-1,7406,7407,7408,7409,-1,7410,7411,7412,7413,-1,7414,7415,7416,7417,-1,7418,7419,7420,7421,-1,7422,7423,7424,7425,-1,7426,7427,7428,7429,-1,7430,7431,7432,7433,-1,7434,7435,7436,7437,-1,7438,7439,7440,7441,-1,7442,7443,7444,7445,-1,7446,7447,7448,7449,-1,7450,7451,7452,7453,-1,7454,7455,7456,7457,-1,7451,7403,7454,-1,7447,7404,7450,-1,7443,7405,7446,-1,7455,7402,7442,-1,7435,7363,7438,-1,7431,7364,7434,-1,7427,7365,7430,-1,7439,7362,7426,-1,7419,7387,7422,-1,7415,7388,7418,-1,7411,7389,7414,-1,7423,7386,7410,-1,7452,7457,7359,7406,-1,7399,7360,7456,7445,-1,7395,7361,7398,-1,7407,7358,7394,-1,7420,7425,7355,7390,-1,7383,7356,7424,7413,-1,7379,7357,7382,-1,7391,7354,7378,-1,7408,7397,7369,7377,-1,7453,7409,7376,7448,-1,7400,7444,7449,7371,-1,7370,7366,7396,7401,-1,7392,7381,7367,7373,-1,7421,7393,7372,7416,-1,7384,7412,7417,7375,-1,7374,7368,7380,7385,-1,7403,7402,7455,7454,-1,7404,7403,7451,7450,-1,7454,7457,7452,7451,-1,7405,7404,7447,7446,-1,7450,7453,7448,7447,-1,7402,7405,7443,7442,-1,7446,7449,7444,7443,-1,7442,7445,7456,7455,-1,7363,7362,7439,7438,-1,7364,7363,7435,7434,-1,7438,7441,7436,7435,-1,7365,7364,7431,7430,-1,7434,7437,7432,7431,-1,7362,7365,7427,7426,-1,7430,7433,7428,7427,-1,7426,7429,7440,7439,-1,7387,7386};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_46()
		{
			int[] value = {7423,7422,-1,7388,7387,7419,7418,-1,7422,7425,7420,7419,-1,7389,7388,7415,7414,-1,7418,7421,7416,7415,-1,7386,7389,7411,7410,-1,7414,7417,7412,7411,-1,7410,7413,7424,7423,-1,7359,7358,7407,7406,-1,7360,7359,7457,7456,-1,7406,7409,7453,7452,-1,7361,7360,7399,7398,-1,7445,7444,7400,7399,-1,7358,7361,7395,7394,-1,7398,7401,7396,7395,-1,7394,7397,7408,7407,-1,7355,7354,7391,7390,-1,7356,7355,7425,7424,-1,7390,7393,7421,7420,-1,7357,7356,7383,7382,-1,7413,7412,7384,7383,-1,7354,7357,7379,7378,-1,7382,7385,7380,7379,-1,7378,7381,7392,7391,-1,7367,7366,7370,7373,-1,7369,7368,7374,7377,-1,7441,7440,7372,7371,-1,7433,7432,7376,7375,-1,7397,7396,7366,7369,-1,7409,7408,7377,7376,-1,7449,7448,7437,7436,-1,7401,7400,7371,7370,-1,7381,7380,7368,7367,-1,7393,7392,7373,7372,-1,7417,7416,7429,7428,-1,7385,7384,7375,7374,-1,7440,7429,7416,7372,-1,7436,7441,7371,7449,-1,7432,7437,7448,7376,-1,7428,7433,7375,7417,-1,7458,7459,7460,7461,-1,7462,7463,7464,7465,-1,7466,7467,7468,7469,-1,7470,7471,7472,7473,-1,7474,7475,7476,7477,-1,7478,7479,7480,7481,-1,7482,7483,7484,7485,-1,7486,7487,7488,7489,-1,7490,7491,7492,7493,-1,7494,7495,7496,7497,-1,7498,7499,7500,7501,-1,7502,7503,7504,7505,-1,7506,7507,7508,7509,-1,7510,7511,7512,7513,-1,7514,7515,7516,7517,-1,7518,7519,7520,7521,-1,7522,7523,7524,7525,-1,7519,7467,7522,-1,7515,7468,7518,-1,7511,7469,7514,-1,7523,7466,7510,-1,7503,7520,7525,7506,-1,7499,7516,7521,7502,-1,7495,7512,7517,7498,-1,7507,7524,7513,7494,-1,7487,7504,7509,7490,-1,7483,7500,7505,7486,-1,7479,7496,7501,7482,-1,7491,7508,7497,7478,-1,7463,7476,7484,7489,-1,7464,7488,7493,7471,-1,7459,7472,7492,7481,-1,7460,7480,7485,7475,-1,7467,7466,7523,7522,-1,7468,7467,7519,7518,-1,7522,7525,7520,7519,-1,7469,7468,7515,7514,-1,7518,7521,7516,7515,-1,7466,7469,7511,7510,-1,7514,7517,7512,7511,-1,7510,7513,7524,7523,-1,7525,7524,7507,7506,-1,7521,7520,7503,7502,-1,7506,7509,7504,7503,-1,7517,7516,7499,7498,-1,7502,7505,7500,7499,-1,7513,7512,7495,7494,-1,7498,7501,7496,7495,-1,7494,7497,7508,7507,-1,7509,7508,7491,7490,-1,7505,7504,7487,7486,-1,7490,7493,7488,7487,-1,7501,7500,7483,7482,-1,7486,7489,7484,7483,-1,7497,7496,7479,7478,-1,7482,7485,7480,7479,-1,7478,7481,7492,7491,-1,7493,7492,7472,7471,-1,7485,7484,7476,7475,-1,7463,7462,7477,7476,-1,7464,7463,7489,7488,-1,7465,7464,7471,7470,-1,7459,7458,7473,7472,-1,7460,7459,7481,7480,-1,7461,7460,7475,7474,-1,7526,7527,7528,7529,7530,7531,7532,7533,-1,7526,7533,7462,7465,-1,7533,7532,7477,7462,-1,7532,7531,7474,7477,-1,7531,7530,7461,7474,-1,7530,7529,7458,7461,-1,7529,7528,7473,7458,-1,7528,7527,7470,7473,-1,7527,7526,7465,7470,-1,7534,7535,7536,7537,-1,7538,7539,7540,7541,-1,7542,7543,7544,7545,-1,7546,7547,7548,7549,-1,7550,7551,7552,7553,-1,7554,7555,7556,7557,-1,7558,7559,7560,7561,-1,7562,7563,7564,7565,-1,7566,7567,7568,7569,-1,7570,7571,7572,7573,-1,7574,7575,7576,7577,-1,7578,7579,7580,7581,-1,7582,7583,7584,7585,-1,7586,7587,7588,7589,-1,7590,7591,7592,7593,-1,7594,7595,7596,7597,-1,7598,7599,7600,7601,-1,7602,7603,7604,7605,-1,7606,7607,7608,7609,-1,7610,7611,7612,7613,-1,7614,7615,7616,7617,-1,7618,7619,7620,7621,-1,7614,7619,7538,-1,7610,7615,7541,-1,7606,7611,7540,-1,7618,7607,7539,-1,7598,7603,7554,-1,7594,7599,7557,-1,7590,7595,7556,-1,7602,7591,7555,-1,7582,7587,7566,-1,7578,7583,7569,-1,7574,7579,7568,-1,7586,7575,7567,-1,7588,7585,7571,7534,-1,7537,7562,7576,7589,-1,7622,7563,7536,-1,7570,7623,7535,-1,7559,7624,7604,-1,7625,7550,7605,-1,7626,7551,7627,7628,-1,7558,7629,7630,7631,-1,7632,7548,7633,-1,7549,7634,7616,7613,-1,7617,7635,7542,7620,-1,7543,7636,7637,-1,7638,7561,7639,7640,-1,7560,7597,7641,-1,7553,7642,7596,-1,7643,7644,7552,7645,-1,7539,7538,7619,7618,-1,7538,7541,7615,7614,-1,7620,7619,7614,7617,-1,7541,7540,7611,7610,-1,7616,7615,7610,7613,-1,7540,7539,7607,7606,-1,7612,7611,7606,7609,-1,7608,7607,7618,7621,-1,7555,7554,7603,7602,-1,7554,7557,7599,7598,-1,7604,7603,7598,7601,-1,7557,7556,7595,7594,-1,7600,7599,7594,7597,-1,7556,7555,7591,7590,-1,7596,7595,7590,7593,-1,7592,7591,7602,7605,-1,7567,7566,7587,7586,-1,7566,7569,7583,7582,-1,7588,7587,7582,7585,-1,7569,7568,7579,7578,-1,7584,7583,7578,7581,-1,7568,7567,7575,7574,-1,7580,7579,7574,7577,-1,7576,7575,7586,7589,-1,7535,7534,7571,7570,-1,7534,7537,7589,7588,-1,7572,7571,7585,7584,-1,7537,7536,7563,7562,-1,7577,7576,7562,7565,-1,7536,7535,7623,7622,-1,7564,7563,7622,7646,-1,7647,7623,7570,7573,-1,7631,7624,7559,7558,-1,7648,7649,7605,7604,-1,7560,7559,7601,7600,-1,7625,7627,7551,7550,-1,7593,7592,7550,7553,-1,7552,7551,7626,7645,-1,7638,7629,7558,7561,-1,7637,7650,7544,7543,-1,7651,7633};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_47()
		{
			int[] value = {7548,7547,-1,7621,7620,7542,7545,-1,7613,7612,7546,7549,-1,7636,7632,7633,7637,-1,7632,7634,7549,7548,-1,7635,7636,7543,7542,-1,7561,7560,7641,7639,-1,7597,7596,7652,7653,-1,7553,7552,7644,7642,-1,7612,7609,7546,-1,7593,7553,7596,-1,7592,7605,7550,-1,7577,7565,7580,-1,7584,7581,7572,-1,7601,7559,7604,-1,7600,7597,7560,-1,7621,7545,7608,-1,7651,7547,7644,7643,-1,7547,7546,7642,7644,-1,7652,7596,7642,-1,7649,7625,7605,-1,7565,7564,7627,7625,-1,7564,7646,7628,7627,-1,7546,7609,7642,-1,7565,7625,7580,-1,7545,7641,7608,-1,7545,7544,7639,7641,-1,7544,7650,7640,7639,-1,7647,7573,7631,7630,-1,7573,7572,7624,7631,-1,7572,7581,7624,-1,7597,7653,7641,-1,7604,7624,7648,-1,7581,7648,7624,-1,7581,7580,7649,7648,-1,7609,7608,7653,7652,-1,7608,7641,7653,-1,7609,7652,7642,-1,7580,7625,7649,-1,7646,7647,7630,7628,-1,7643,7640,7650,7651,-1,7640,7643,7645,7638,-1,7637,7633,7651,7650,-1,7628,7630,7629,7626,-1,7638,7645,7626,7629,-1,7622,7623,7647,7646,-1,7654,7655,7656,7657,-1,7658,7659,7660,7661,-1,7662,7663,7664,7665,-1,7666,7667,7668,7669,-1,7670,7671,7672,7673,-1,7674,7675,7676,7677,-1,7678,7679,7680,7681,-1,7682,7683,7684,7685,-1,7686,7687,7688,7689,-1,7690,7691,7692,7693,-1,7694,7695,7696,7697,-1,7698,7699,7700,7701,-1,7702,7703,7704,7705,-1,7706,7707,7708,7709,-1,7710,7711,7712,7713,-1,7714,7715,7716,7717,-1,7718,7719,7720,7721,-1,7722,7723,7724,7725,-1,7726,7727,7728,7729,-1,7730,7731,7732,7733,-1,7734,7735,7736,7737,-1,7738,7739,7740,7741,-1,7742,7743,7744,7745,-1,7746,7747,7748,7749,-1,7750,7751,7752,7753,-1,7754,7755,7756,7757,-1,7750,7755,7702,-1,7746,7751,7705,-1,7742,7747,7704,-1,7754,7743,7703,-1,7734,7739,7662,-1,7730,7735,7665,-1,7726,7731,7664,-1,7738,7727,7663,-1,7718,7723,7686,-1,7714,7719,7689,-1,7710,7715,7688,-1,7722,7711,7687,-1,7756,7753,7707,7658,-1,7661,7698,7744,7757,-1,7694,7699,7660,-1,7706,7695,7659,-1,7724,7721,7691,7654,-1,7657,7682,7712,7725,-1,7678,7683,7656,-1,7690,7679,7655,-1,7696,7709,7676,7668,-1,7708,7752,7749,7677,-1,7745,7701,7670,7748,-1,7667,7671,7700,7697,-1,7680,7693,7672,7666,-1,7692,7720,7717,7673,-1,7713,7685,7674,7716,-1,7669,7675,7684,7681,-1,7703,7702,7755,7754,-1,7702,7705,7751,7750,-1,7756,7755,7750,7753,-1,7705,7704,7747,7746,-1,7752,7751,7746,7749,-1,7704,7703,7743,7742,-1,7748,7747,7742,7745,-1,7744,7743,7754,7757,-1,7663,7662,7739,7738,-1,7662,7665,7735,7734,-1,7740,7739,7734,7737,-1,7665,7664,7731,7730,-1,7736,7735,7730,7733,-1,7664,7663,7727,7726,-1,7732,7731,7726,7729,-1,7728,7727,7738,7741,-1,7687,7686,7723,7722,-1,7686,7689,7719,7718,-1,7724,7723,7718,7721,-1,7689,7688,7715,7714,-1,7720,7719,7714,7717,-1,7688,7687,7711,7710,-1,7716,7715,7710,7713,-1,7712,7711,7722,7725,-1,7659,7658,7707,7706,-1,7658,7661,7757,7756,-1,7708,7707,7753,7752,-1,7661,7660,7699,7698,-1,7745,7744,7698,7701,-1,7660,7659,7695,7694,-1,7700,7699,7694,7697,-1,7696,7695,7706,7709,-1,7655,7654,7691,7690,-1,7654,7657,7725,7724,-1,7692,7691,7721,7720,-1,7657,7656,7683,7682,-1,7713,7712,7682,7685,-1,7656,7655,7679,7678,-1,7684,7683,7678,7681,-1,7680,7679,7690,7693,-1,7667,7666,7672,7671,-1,7669,7668,7676,7675,-1,7741,7740,7670,7673,-1,7733,7732,7674,7677,-1,7697,7696,7668,7667,-1,7709,7708,7677,7676,-1,7749,7748,7737,7736,-1,7701,7700,7671,7670,-1,7681,7680,7666,7669,-1,7693,7692,7673,7672,-1,7717,7716,7729,7728,-1,7685,7684,7675,7674,-1,7728,7741,7673,7717,-1,7740,7737,7748,7670,-1,7736,7733,7677,7749,-1,7732,7729,7716,7674,-1,7758,7759,7760,7761,-1,7762,7763,7764,7765,-1,7766,7767,7768,7769,-1,7770,7771,7772,7773,-1,7774,7775,7776,7777,-1,7778,7779,7780,7781,-1,7782,7783,7784,7785,-1,7786,7787,7788,7789,-1,7790,7791,7792,7793,-1,7794,7795,7796,7797,-1,7798,7799,7800,7801,-1,7802,7803,7804,7805,-1,7806,7807,7808,7809,-1,7810,7811,7812,7813,-1,7814,7815,7816,7817,-1,7818,7819,7820,7821,-1,7822,7823,7824,7825,-1,7826,7827,7828,7829,-1,7830,7831,7832,7833,-1,7834,7835,7836,7837,-1,7838,7839,7840,7841,-1,7842,7843,7844,7845,-1,7846,7847,7848,7849,-1,7850,7851,7852,7853,-1,7854,7855,7856,7857,-1,7858,7859,7860,7861,-1,7854,7859,7806,-1,7850,7855,7809,-1,7846,7851,7808,-1,7858,7847,7807,-1,7838,7843,7766,-1,7834,7839,7769,-1,7830,7835,7768,-1,7842,7831,7767,-1,7822,7827,7790,-1,7818,7823,7793,-1,7814,7819,7792,-1,7826,7815,7791,-1,7860,7857,7811,7762,-1,7765,7802,7848,7861,-1,7798,7803,7764,-1,7810,7799,7763,-1,7828,7825,7795,7758,-1,7761,7786,7816,7829,-1,7782,7787,7760,-1,7794,7783,7759,-1,7800,7813,7780,7772,-1,7812,7856,7853,7781,-1,7849,7805,7774,7852,-1,7771,7775,7804,7801,-1,7784,7797,7776,7770,-1,7796,7824,7821,7777,-1,7817,7789,7778,7820,-1,7773,7779,7788,7785,-1,7807,7806,7859,7858};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_48()
		{
			int[] value = {-1,7806,7809,7855,7854,-1,7860,7859,7854,7857,-1,7809,7808,7851,7850,-1,7856,7855,7850,7853,-1,7808,7807,7847,7846,-1,7852,7851,7846,7849,-1,7848,7847,7858,7861,-1,7767,7766,7843,7842,-1,7766,7769,7839,7838,-1,7844,7843,7838,7841,-1,7769,7768,7835,7834,-1,7840,7839,7834,7837,-1,7768,7767,7831,7830,-1,7836,7835,7830,7833,-1,7832,7831,7842,7845,-1,7791,7790,7827,7826,-1,7790,7793,7823,7822,-1,7828,7827,7822,7825,-1,7793,7792,7819,7818,-1,7824,7823,7818,7821,-1,7792,7791,7815,7814,-1,7820,7819,7814,7817,-1,7816,7815,7826,7829,-1,7763,7762,7811,7810,-1,7762,7765,7861,7860,-1,7812,7811,7857,7856,-1,7765,7764,7803,7802,-1,7849,7848,7802,7805,-1,7764,7763,7799,7798,-1,7804,7803,7798,7801,-1,7800,7799,7810,7813,-1,7759,7758,7795,7794,-1,7758,7761,7829,7828,-1,7796,7795,7825,7824,-1,7761,7760,7787,7786,-1,7817,7816,7786,7789,-1,7760,7759,7783,7782,-1,7788,7787,7782,7785,-1,7784,7783,7794,7797,-1,7771,7770,7776,7775,-1,7773,7772,7780,7779,-1,7845,7844,7774,7777,-1,7837,7836,7778,7781,-1,7801,7800,7772,7771,-1,7813,7812,7781,7780,-1,7853,7852,7841,7840,-1,7805,7804,7775,7774,-1,7785,7784,7770,7773,-1,7797,7796,7777,7776,-1,7821,7820,7833,7832,-1,7789,7788,7779,7778,-1,7832,7845,7777,7821,-1,7844,7841,7852,7774,-1,7840,7837,7781,7853,-1,7836,7833,7820,7778,-1,7862,7863,7864,7865,-1,7866,7867,7868,7869,-1,7870,7871,7872,7873,-1,7874,7875,7876,7877,-1,7878,7879,7880,7881,-1,7882,7883,7884,7885,-1,7886,7887,7888,7889,-1,7890,7891,7892,7893,-1,7894,7895,7896,7897,-1,7898,7899,7900,7901,-1,7902,7903,7904,7905,-1,7906,7907,7908,7909,-1,7910,7911,7912,7913,-1,7914,7915,7916,7917,-1,7918,7919,7920,7921,-1,7922,7923,7924,7925,-1,7926,7927,7928,7929,-1,7922,7927,7870,-1,7918,7923,7873,-1,7914,7919,7872,-1,7926,7915,7871,-1,7925,7906,7911,7928,-1,7921,7902,7907,7924,-1,7917,7898,7903,7920,-1,7929,7910,7899,7916,-1,7909,7890,7895,7912,-1,7905,7886,7891,7908,-1,7901,7882,7887,7904,-1,7913,7894,7883,7900,-1,7881,7866,7892,7889,-1,7893,7869,7874,7896,-1,7877,7862,7884,7897,-1,7885,7865,7878,7888,-1,7871,7870,7927,7926,-1,7870,7873,7923,7922,-1,7928,7927,7922,7925,-1,7873,7872,7919,7918,-1,7924,7923,7918,7921,-1,7872,7871,7915,7914,-1,7920,7919,7914,7917,-1,7916,7915,7926,7929,-1,7929,7928,7911,7910,-1,7925,7924,7907,7906,-1,7912,7911,7906,7909,-1,7921,7920,7903,7902,-1,7908,7907,7902,7905,-1,7917,7916,7899,7898,-1,7904,7903,7898,7901,-1,7900,7899,7910,7913,-1,7913,7912,7895,7894,-1,7909,7908,7891,7890,-1,7896,7895,7890,7893,-1,7905,7904,7887,7886,-1,7892,7891,7886,7889,-1,7901,7900,7883,7882,-1,7888,7887,7882,7885,-1,7884,7883,7894,7897,-1,7897,7896,7874,7877,-1,7889,7888,7878,7881,-1,7867,7866,7881,7880,-1,7866,7869,7893,7892,-1,7869,7868,7875,7874,-1,7863,7862,7877,7876,-1,7862,7865,7885,7884,-1,7865,7864,7879,7878,-1,7930,7931,7932,7933,7934,7935,7936,7937,-1,7936,7935,7868,7867,-1,7937,7936,7867,7880,-1,7930,7937,7880,7879,-1,7931,7930,7879,7864,-1,7932,7931,7864,7863,-1,7933,7932,7863,7876,-1,7934,7933,7876,7875,-1,7935,7934,7875,7868,-1,7938,7939,7940,7941,-1,7942,7943,7944,7945,-1,7946,7947,7945,7944,-1,7948,7949,7950,7951,-1,7952,7953,7943,7942,-1,7953,7952,7951,7950,-1,7941,7940,7947,7946,-1,7954,7955,7956,-1,7957,7958,7959,-1,7960,7961,7962,-1,7960,7957,7959,7961,-1,7954,7963,7964,7955,-1,7963,7965,7964,-1,7966,7964,7965,-1,7967,7962,7961,-1,7968,7965,7963,-1,7968,7969,7970,7965,-1,7969,7941,7946,7970,-1,7950,7971,7972,7953,-1,7971,7973,7962,7972,-1,7973,7960,7962,-1,7974,7954,7956,-1,7975,7958,7957,-1,7940,7976,7977,7947,-1,7976,7974,7956,7977,-1,7955,7978,7956,-1,7959,7958,7979,-1,7975,7980,7981,7958,-1,7980,7951,7952,7981,-1,7982,7960,7973,-1,7983,7984,7967,-1,7985,7966,7986,-1,7987,7968,7963,-1,7988,7954,7974,-1,7989,7990,7978,-1,7991,7979,7992,-1,7993,7975,7957,-1,7994,7992,7958,7981,-1,7979,7967,7961,7959,-1,7984,7995,7972,7962,-1,7996,7997,7998,7999,-1,8000,8001,8002,8003,-1,8001,7996,7949,7948,-1,7993,8004,8003,7975,-1,8005,7982,7973,7998,-1,7948,7951,7980,8002,-1,7950,7949,7999,7971,-1,7944,7943,7995,8006,-1,8007,7994,7942,7945,-1,7989,7991,7992,7990,-1,7977,7956,7990,8007,-1,7986,7984,7983,7985,-1,7955,7964,7966,7978,-1,7965,7970,8006,7986,-1,7938,7941,7969,8008,-1,8009,7976,7940,7939,-1,8010,8011,7939,7938,-1,8012,7988,7974,8013,-1,8011,8014,8013,8009,-1,8015,7968,7987,8016,-1,8014,8017,8018,8019,-1,8017,8010,8008,8015,-1,8020,8012,8019,8021,-1,8022,7954,7988,8023,-1,8024,8025,8023,8020,-1,8026,7987,7963,8027,-1,8025,8028,8027,8022,-1,8029,8018,8016,8030,-1,8028,8031,8030,8026,-1,8031,8024,8021,8029,-1,8032,7989,7978,8033,-1,8034,7979,7991,8035,-1,8036,8037,8035,8032,-1,8038,7983,7967,8039,-1,8037,8040,8039,8034};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_49()
		{
			int[] value = {-1,8041,7966,7985,8042,-1,8040,8043,8042,8038,-1,8043,8036,8033,8041,-1,8044,7960,7982,8045,-1,8046,7993,7957,8047,-1,8048,8049,8047,8044,-1,8050,8051,8004,8052,-1,8049,8053,8052,8046,-1,8054,8005,8055,8056,-1,8053,8057,8056,8050,-1,8057,8048,8045,8054,-1,7981,7952,7942,7994,-1,7992,7979,7958,-1,7984,7962,7967,-1,7995,7943,7953,7972,-1,7999,7949,7996,-1,7997,8055,8005,7998,-1,8000,8003,8004,8051,-1,8001,7948,8002,-1,7944,8006,7970,7946,-1,8007,7945,7947,7977,-1,7956,7978,7990,-1,7986,7966,7965,-1,8008,8010,7938,-1,7939,8011,8009,-1,8013,8014,8019,8012,-1,8016,8018,8017,8015,-1,8021,8024,8020,-1,8023,8025,8022,-1,8027,8028,8026,-1,8030,8031,8029,-1,8033,8036,8032,-1,8035,8037,8034,-1,8039,8040,8038,-1,8042,8043,8041,-1,8045,8048,8044,-1,8047,8049,8046,-1,8052,8053,8050,-1,8056,8057,8054,-1,8054,8045,7982,8005,-1,8050,8056,8055,8051,-1,8046,8052,8004,7993,-1,8044,8047,7957,7960,-1,8041,8033,7978,7966,-1,8038,8042,7985,7983,-1,8034,8039,7967,7979,-1,8032,8035,7991,7989,-1,8029,8021,8019,8018,-1,8026,8030,8016,7987,-1,8022,8027,7963,7954,-1,8020,8023,7988,8012,-1,8015,8008,7969,7968,-1,8024,8031,8028,8025,-1,8009,8013,7974,7976,-1,7986,8006,7995,7984,-1,8036,8043,8040,8037,-1,8007,7990,7992,7994,-1,7980,7975,8003,8002,-1,7999,7998,7973,7971,-1,8048,8057,8053,8049,-1,8010,8017,8014,8011,-1,8058,8059,8060,8061,-1,8062,8063,8064,8065,-1,8066,8067,8068,8069,-1,8070,8071,8072,8073,-1,8074,8075,8076,8077,-1,8078,8079,8080,8081,-1,8082,8083,8084,8085,-1,8086,8087,8088,8089,-1,8090,8091,8092,8093,-1,8094,8095,8096,8097,-1,8098,8099,8100,8101,-1,8102,8103,8104,8105,-1,8106,8107,8108,8109,-1,8110,8111,8112,8113,-1,8114,8115,8116,8117,-1,8118,8119,8120,8121,-1,8122,8123,8124,8125,-1,8126,8127,8128,8129,-1,8130,8131,8132,8133,-1,8134,8135,8136,8137,-1,8138,8139,8140,8141,-1,8142,8143,8144,8145,-1,8146,8147,8148,8149,-1,8150,8151,8152,8153,-1,8154,8155,8156,8157,-1,8158,8159,8160,8161,-1,8161,8108,8156,-1,8157,8107,8152,-1,8153,8106,8148,-1,8149,8109,8160,-1,8145,8068,8140,-1,8141,8067,8136,-1,8137,8066,8132,-1,8133,8069,8144,-1,8129,8092,8124,-1,8125,8091,8120,-1,8121,8090,8116,-1,8117,8093,8128,-1,8113,8064,8158,8155,-1,8146,8159,8063,8104,-1,8105,8062,8100,-1,8101,8065,8112,-1,8097,8060,8126,8123,-1,8114,8127,8059,8088,-1,8089,8058,8084,-1,8085,8061,8096,-1,8078,8070,8098,8111,-1,8151,8079,8110,8154,-1,8076,8150,8147,8103,-1,8102,8099,8073,8077,-1,8074,8072,8082,8095,-1,8119,8075,8094,8122,-1,8080,8118,8115,8087,-1,8086,8083,8071,8081,-1,8161,8160,8109,8108,-1,8157,8156,8108,8107,-1,8156,8155,8158,8161,-1,8153,8152,8107,8106,-1,8152,8151,8154,8157,-1,8149,8148,8106,8109,-1,8148,8147,8150,8153,-1,8160,8159,8146,8149,-1,8145,8144,8069,8068,-1,8141,8140,8068,8067,-1,8140,8139,8142,8145,-1,8137,8136,8067,8066,-1,8136,8135,8138,8141,-1,8133,8132,8066,8069,-1,8132,8131,8134,8137,-1,8144,8143,8130,8133,-1,8129,8128,8093,8092,-1,8125,8124,8092,8091,-1,8124,8123,8126,8129,-1,8121,8120,8091,8090,-1,8120,8119,8122,8125,-1,8117,8116,8090,8093,-1,8116,8115,8118,8121,-1,8128,8127,8114,8117,-1,8113,8112,8065,8064,-1,8159,8158,8064,8063,-1,8155,8154,8110,8113,-1,8105,8104,8063,8062,-1,8104,8103,8147,8146,-1,8101,8100,8062,8065,-1,8100,8099,8102,8105,-1,8112,8111,8098,8101,-1,8097,8096,8061,8060,-1,8127,8126,8060,8059,-1,8123,8122,8094,8097,-1,8089,8088,8059,8058,-1,8088,8087,8115,8114,-1,8085,8084,8058,8061,-1,8084,8083,8086,8089,-1,8096,8095,8082,8085,-1,8074,8077,8073,8072,-1,8078,8081,8071,8070,-1,8076,8075,8143,8142,-1,8080,8079,8135,8134,-1,8070,8073,8099,8098,-1,8079,8078,8111,8110,-1,8139,8138,8151,8150,-1,8077,8076,8103,8102,-1,8072,8071,8083,8082,-1,8075,8074,8095,8094,-1,8131,8130,8119,8118,-1,8081,8080,8087,8086,-1,8075,8119,8130,8143,-1,8150,8076,8142,8139,-1,8079,8151,8138,8135,-1,8118,8080,8134,8131,-1,8162,8163,8164,8165,-1,8166,8167,8168,8169,-1,8170,8171,8172,8173,-1,8174,8175,8176,8177,-1,8178,8179,8180,8181,-1,8182,8183,8184,8185,-1,8186,8187,8188,8189,-1,8190,8191,8192,8193,-1,8194,8195,8196,8197,-1,8198,8199,8200,8201,-1,8202,8203,8204,8205,-1,8206,8207,8208,8209,-1,8210,8211,8212,8213,-1,8214,8215,8216,8217,-1,8218,8219,8220,8221,-1,8222,8223,8224,8225,-1,8226,8227,8228,8229,-1,8230,8231,8232,8233,-1,8234,8235,8236,8237,-1,8238,8239,8240,8241,-1,8242,8243,8244,8245,-1,8246,8247,8248,8249,-1,8250,8251,8252,8253,-1,8254,8255,8256,8257,-1,8258,8259,8260,8261,-1,8262,8263,8264,8265,-1,8265,8212,8260,-1,8261,8211,8256,-1,8257,8210,8252,-1,8253,8213,8264,-1,8249,8172,8244,-1,8245,8171,8240,-1,8241,8170,8236,-1,8237,8173,8248,-1,8233,8196,8228,-1,8229,8195,8224,-1,8225,8194,8220,-1,8221,8197,8232,-1,8217,8168};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_50()
		{
			int[] value = {8262,8259,-1,8250,8263,8167,8208,-1,8209,8166,8204,-1,8205,8169,8216,-1,8201,8164,8230,8227,-1,8218,8231,8163,8192,-1,8193,8162,8188,-1,8189,8165,8200,-1,8182,8174,8202,8215,-1,8255,8183,8214,8258,-1,8180,8254,8251,8207,-1,8206,8203,8177,8181,-1,8178,8176,8186,8199,-1,8223,8179,8198,8226,-1,8184,8222,8219,8191,-1,8190,8187,8175,8185,-1,8265,8264,8213,8212,-1,8261,8260,8212,8211,-1,8260,8259,8262,8265,-1,8257,8256,8211,8210,-1,8256,8255,8258,8261,-1,8253,8252,8210,8213,-1,8252,8251,8254,8257,-1,8264,8263,8250,8253,-1,8249,8248,8173,8172,-1,8245,8244,8172,8171,-1,8244,8243,8246,8249,-1,8241,8240,8171,8170,-1,8240,8239,8242,8245,-1,8237,8236,8170,8173,-1,8236,8235,8238,8241,-1,8248,8247,8234,8237,-1,8233,8232,8197,8196,-1,8229,8228,8196,8195,-1,8228,8227,8230,8233,-1,8225,8224,8195,8194,-1,8224,8223,8226,8229,-1,8221,8220,8194,8197,-1,8220,8219,8222,8225,-1,8232,8231,8218,8221,-1,8217,8216,8169,8168,-1,8263,8262,8168,8167,-1,8259,8258,8214,8217,-1,8209,8208,8167,8166,-1,8208,8207,8251,8250,-1,8205,8204,8166,8169,-1,8204,8203,8206,8209,-1,8216,8215,8202,8205,-1,8201,8200,8165,8164,-1,8231,8230,8164,8163,-1,8227,8226,8198,8201,-1,8193,8192,8163,8162,-1,8192,8191,8219,8218,-1,8189,8188,8162,8165,-1,8188,8187,8190,8193,-1,8200,8199,8186,8189,-1,8178,8181,8177,8176,-1,8182,8185,8175,8174,-1,8180,8179,8247,8246,-1,8184,8183,8239,8238,-1,8174,8177,8203,8202,-1,8183,8182,8215,8214,-1,8243,8242,8255,8254,-1,8181,8180,8207,8206,-1,8176,8175,8187,8186,-1,8179,8178,8199,8198,-1,8235,8234,8223,8222,-1,8185,8184,8191,8190,-1,8179,8223,8234,8247,-1,8254,8180,8246,8243,-1,8183,8255,8242,8239,-1,8222,8184,8238,8235,-1,8266,8267,8268,8269,-1,8270,8271,8272,8273,-1,8274,8275,8276,8277,-1,8278,8279,8280,8281,-1,8282,8283,8284,8285,-1,8286,8287,8288,8289,-1,8290,8291,8292,8293,-1,8294,8295,8296,8297,-1,8298,8299,8300,8301,-1,8302,8303,8304,8305,-1,8306,8307,8308,8309,-1,8310,8311,8312,8313,-1,8314,8315,8316,8317,-1,8318,8319,8320,8321,-1,8322,8323,8324,8325,-1,8326,8327,8328,8329,-1,8330,8331,8332,8333,-1,8334,8335,8336,8337,-1,8338,8339,8340,8341,-1,8342,8343,8344,8345,-1,8346,8347,8348,8349,-1,8350,8351,8352,8353,-1,8354,8355,8356,8357,-1,8358,8359,8360,8361,-1,8362,8363,8364,8365,-1,8366,8367,8368,8369,-1,8369,8316,8364,-1,8365,8315,8360,-1,8361,8314,8356,-1,8357,8317,8368,-1,8353,8276,8348,-1,8349,8275,8344,-1,8345,8274,8340,-1,8341,8277,8352,-1,8337,8300,8332,-1,8333,8299,8328,-1,8329,8298,8324,-1,8325,8301,8336,-1,8321,8272,8366,8363,-1,8354,8367,8271,8312,-1,8313,8270,8308,-1,8309,8273,8320,-1,8305,8268,8334,8331,-1,8322,8335,8267,8296,-1,8297,8266,8292,-1,8293,8269,8304,-1,8286,8278,8306,8319,-1,8359,8287,8318,8362,-1,8284,8358,8355,8311,-1,8310,8307,8281,8285,-1,8282,8280,8290,8303,-1,8327,8283,8302,8330,-1,8288,8326,8323,8295,-1,8294,8291,8279,8289,-1,8369,8368,8317,8316,-1,8365,8364,8316,8315,-1,8364,8363,8366,8369,-1,8361,8360,8315,8314,-1,8360,8359,8362,8365,-1,8357,8356,8314,8317,-1,8356,8355,8358,8361,-1,8368,8367,8354,8357,-1,8353,8352,8277,8276,-1,8349,8348,8276,8275,-1,8348,8347,8350,8353,-1,8345,8344,8275,8274,-1,8344,8343,8346,8349,-1,8341,8340,8274,8277,-1,8340,8339,8342,8345,-1,8352,8351,8338,8341,-1,8337,8336,8301,8300,-1,8333,8332,8300,8299,-1,8332,8331,8334,8337,-1,8329,8328,8299,8298,-1,8328,8327,8330,8333,-1,8325,8324,8298,8301,-1,8324,8323,8326,8329,-1,8336,8335,8322,8325,-1,8321,8320,8273,8272,-1,8367,8366,8272,8271,-1,8363,8362,8318,8321,-1,8313,8312,8271,8270,-1,8312,8311,8355,8354,-1,8309,8308,8270,8273,-1,8308,8307,8310,8313,-1,8320,8319,8306,8309,-1,8305,8304,8269,8268,-1,8335,8334,8268,8267,-1,8331,8330,8302,8305,-1,8297,8296,8267,8266,-1,8296,8295,8323,8322,-1,8293,8292,8266,8269,-1,8292,8291,8294,8297,-1,8304,8303,8290,8293,-1,8282,8285,8281,8280,-1,8286,8289,8279,8278,-1,8284,8283,8351,8350,-1,8288,8287,8343,8342,-1,8278,8281,8307,8306,-1,8287,8286,8319,8318,-1,8347,8346,8359,8358,-1,8285,8284,8311,8310,-1,8280,8279,8291,8290,-1,8283,8282,8303,8302,-1,8339,8338,8327,8326,-1,8289,8288,8295,8294,-1,8283,8327,8338,8351,-1,8358,8284,8350,8347,-1,8287,8359,8346,8343,-1,8326,8288,8342,8339,-1,8370,8371,8372,8373,-1,8374,8375,8376,8377,-1,8378,8379,8380,8381,-1,8382,8383,8384,8385,-1,8386,8387,8388,8389,-1,8390,8391,8392,8393,-1,8394,8395,8396,8397,-1,8398,8399,8400,8401,-1,8402,8403,8404,8405,-1,8406,8407,8408,8409,-1,8410,8411,8412,8413,-1,8414,8415,8416,8417,-1,8418,8419,8420,8421,-1,8422,8423,8424,8425,-1,8426,8427,8428,8429,-1,8430,8431,8432,8433,-1,8434,8435,8436,8437,-1,8437,8380,8432,-1,8433,8379,8428,-1,8429,8378,8424,-1,8425,8381,8436,-1,8421,8434,8431,8416,-1,8417,8430,8427,8412,-1,8413};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_51()
		{
			int[] value = {8426,8423,8408,-1,8409,8422,8435,8420,-1,8405,8418,8415,8400,-1,8401,8414,8411,8396,-1,8397,8410,8407,8392,-1,8393,8406,8419,8404,-1,8398,8395,8387,8376,-1,8384,8402,8399,8375,-1,8390,8403,8383,8372,-1,8388,8394,8391,8371,-1,8437,8436,8381,8380,-1,8433,8432,8380,8379,-1,8432,8431,8434,8437,-1,8429,8428,8379,8378,-1,8428,8427,8430,8433,-1,8425,8424,8378,8381,-1,8424,8423,8426,8429,-1,8436,8435,8422,8425,-1,8421,8420,8435,8434,-1,8417,8416,8431,8430,-1,8416,8415,8418,8421,-1,8413,8412,8427,8426,-1,8412,8411,8414,8417,-1,8409,8408,8423,8422,-1,8408,8407,8410,8413,-1,8420,8419,8406,8409,-1,8405,8404,8419,8418,-1,8401,8400,8415,8414,-1,8400,8399,8402,8405,-1,8397,8396,8411,8410,-1,8396,8395,8398,8401,-1,8393,8392,8407,8406,-1,8392,8391,8394,8397,-1,8404,8403,8390,8393,-1,8384,8383,8403,8402,-1,8388,8387,8395,8394,-1,8387,8386,8377,8376,-1,8399,8398,8376,8375,-1,8385,8384,8375,8374,-1,8383,8382,8373,8372,-1,8391,8390,8372,8371,-1,8389,8388,8371,8370,-1,8438,8439,8440,8441,8442,8443,8444,8445,-1,8374,8377,8438,8445,-1,8377,8386,8439,8438,-1,8386,8389,8440,8439,-1,8389,8370,8441,8440,-1,8370,8373,8442,8441,-1,8373,8382,8443,8442,-1,8382,8385,8444,8443,-1,8385,8374,8445,8444,-1,8446,8447,8448,8449,-1,8450,8451,8452,8453,-1,8454,8455,8456,8457,-1,8458,8459,8460,8461,-1,8462,8463,8464,8465,-1,8466,8467,8468,8469,-1,8470,8471,8472,8473,-1,8474,8475,8476,8477,-1,8478,8479,8480,8481,-1,8482,8483,8484,8485,-1,8486,8487,8488,8489,-1,8490,8491,8492,8493,-1,8494,8495,8496,8497,-1,8498,8499,8500,8501,-1,8502,8503,8504,8505,-1,8506,8507,8508,8509,-1,8510,8511,8512,8513,-1,8514,8515,8516,8517,-1,8518,8519,8520,8521,-1,8522,8523,8524,8525,-1,7617,7616,8526,8527,-1,8528,8529,8530,8531,-1,8453,8530,8527,-1,8450,8526,8525,-1,8451,8524,8521,-1,8452,8520,8531,-1,8469,8516,8513,-1,8466,8512,8509,-1,8467,8508,8505,-1,8468,8504,8517,-1,8481,8500,8497,-1,8478,8496,8493,-1,8479,8492,8489,-1,8480,8488,8501,-1,8449,8484,8494,8499,-1,8498,8487,8477,8446,-1,8447,8476,8532,-1,8448,8533,8485,-1,8515,8534,8472,-1,8514,8465,8535,-1,8536,8537,8464,8538,-1,8539,8540,8541,8473,-1,8542,8459,7632,-1,8522,7616,7634,8458,-1,8529,8457,7635,7617,-1,8543,7636,8456,-1,8544,8545,8470,8546,-1,8547,8506,8471,-1,8507,8548,8462,-1,8549,8463,8550,8551,-1,8531,8530,8453,8452,-1,8527,8526,8450,8453,-1,7617,8527,8530,8529,-1,8525,8524,8451,8450,-1,8522,8525,8526,7616,-1,8521,8520,8452,8451,-1,8518,8521,8524,8523,-1,8528,8531,8520,8519,-1,8517,8516,8469,8468,-1,8513,8512,8466,8469,-1,8510,8513,8516,8515,-1,8509,8508,8467,8466,-1,8506,8509,8512,8511,-1,8505,8504,8468,8467,-1,8502,8505,8508,8507,-1,8514,8517,8504,8503,-1,8501,8500,8481,8480,-1,8497,8496,8478,8481,-1,8494,8497,8500,8499,-1,8493,8492,8479,8478,-1,8490,8493,8496,8495,-1,8489,8488,8480,8479,-1,8486,8489,8492,8491,-1,8498,8501,8488,8487,-1,8485,8484,8449,8448,-1,8499,8498,8446,8449,-1,8495,8494,8484,8483,-1,8477,8476,8447,8446,-1,8474,8477,8487,8486,-1,8532,8533,8448,8447,-1,8552,8532,8476,8475,-1,8482,8485,8533,8553,-1,8473,8472,8534,8539,-1,8515,8514,8554,8555,-1,8511,8510,8472,8471,-1,8465,8464,8537,8535,-1,8462,8465,8503,8502,-1,8549,8538,8464,8463,-1,8470,8473,8541,8546,-1,8456,8455,8556,8543,-1,8460,8459,8542,8557,-1,8454,8457,8529,8528,-1,8458,8461,8523,8522,-1,8543,8542,7632,7636,-1,8459,8458,7634,7632,-1,8457,8456,7636,7635,-1,8545,8547,8471,8470,-1,8558,8559,8507,8506,-1,8548,8550,8463,8462,-1,8461,8518,8523,-1,8507,8462,8502,-1,8465,8514,8503,-1,8491,8474,8486,-1,8483,8490,8495,-1,8515,8472,8510,-1,8471,8506,8511,-1,8519,8454,8528,-1,8551,8550,8460,8557,-1,8550,8548,8461,8460,-1,8548,8507,8559,-1,8514,8535,8554,-1,8535,8537,8475,8474,-1,8537,8536,8552,8475,-1,8548,8518,8461,-1,8491,8535,8474,-1,8519,8547,8454,-1,8547,8545,8455,8454,-1,8545,8544,8556,8455,-1,8540,8539,8482,8553,-1,8539,8534,8483,8482,-1,8534,8490,8483,-1,8547,8558,8506,-1,8555,8534,8515,-1,8534,8555,8490,-1,8555,8554,8491,8490,-1,8559,8558,8519,8518,-1,8558,8547,8519,-1,8548,8559,8518,-1,8554,8535,8491,-1,8536,8540,8553,8552,-1,8557,8556,8544,8551,-1,8546,8549,8551,8544,-1,8556,8557,8542,8543,-1,8538,8541,8540,8536,-1,8541,8538,8549,8546,-1,8552,8553,8533,8532,-1,8560,8561,8562,8563,-1,8564,8565,8566,8567,-1,8568,8569,8570,8571,-1,8572,8573,8574,8575,-1,8576,8577,8578,8579,-1,8580,8581,8582,8583,-1,8584,8585,8586,8587,-1,8588,8589,8590,8591,-1,8592,8593,8594,8595,-1,8596,8597,8598,8599,-1,8600,8601,8602,8603,-1,8604,8605,8606,8607,-1,8608,8609,8610,8611,-1,8612,8613,8614,8615,-1,8616,8617,8618,8619,-1,8620,8621,8622,8623,-1,8624,8625,8626,8627,-1,8628,8629,8630,8631,-1,8632,8633,8634,8635,-1,8636,8637,8638,8639,-1,8640,8641};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_52()
		{
			int[] value = {8642,8643,-1,8644,8645,8646,8647,-1,8648,8649,8650,8651,-1,8652,8653,8654,8655,-1,8656,8657,8658,8659,-1,8660,8661,8662,8663,-1,8611,8662,8659,-1,8608,8658,8655,-1,8609,8654,8651,-1,8610,8650,8663,-1,8571,8646,8643,-1,8568,8642,8639,-1,8569,8638,8635,-1,8570,8634,8647,-1,8595,8630,8627,-1,8592,8626,8623,-1,8593,8622,8619,-1,8594,8618,8631,-1,8567,8614,8656,8661,-1,8660,8649,8607,8564,-1,8565,8606,8603,-1,8566,8602,8615,-1,8563,8598,8624,8629,-1,8628,8617,8591,8560,-1,8561,8590,8587,-1,8562,8586,8599,-1,8573,8581,8612,8601,-1,8580,8652,8657,8613,-1,8653,8579,8604,8648,-1,8600,8605,8578,8574,-1,8575,8577,8596,8585,-1,8576,8620,8625,8597,-1,8621,8583,8588,8616,-1,8584,8589,8582,8572,-1,8663,8662,8611,8610,-1,8659,8658,8608,8611,-1,8656,8659,8662,8661,-1,8655,8654,8609,8608,-1,8652,8655,8658,8657,-1,8651,8650,8610,8609,-1,8648,8651,8654,8653,-1,8660,8663,8650,8649,-1,8647,8646,8571,8570,-1,8643,8642,8568,8571,-1,8640,8643,8646,8645,-1,8639,8638,8569,8568,-1,8636,8639,8642,8641,-1,8635,8634,8570,8569,-1,8632,8635,8638,8637,-1,8644,8647,8634,8633,-1,8631,8630,8595,8594,-1,8627,8626,8592,8595,-1,8624,8627,8630,8629,-1,8623,8622,8593,8592,-1,8620,8623,8626,8625,-1,8619,8618,8594,8593,-1,8616,8619,8622,8621,-1,8628,8631,8618,8617,-1,8615,8614,8567,8566,-1,8661,8660,8564,8567,-1,8657,8656,8614,8613,-1,8607,8606,8565,8564,-1,8604,8607,8649,8648,-1,8603,8602,8566,8565,-1,8600,8603,8606,8605,-1,8612,8615,8602,8601,-1,8599,8598,8563,8562,-1,8629,8628,8560,8563,-1,8625,8624,8598,8597,-1,8591,8590,8561,8560,-1,8588,8591,8617,8616,-1,8587,8586,8562,8561,-1,8584,8587,8590,8589,-1,8596,8599,8586,8585,-1,8578,8577,8575,8574,-1,8582,8581,8573,8572,-1,8576,8579,8645,8644,-1,8580,8583,8637,8636,-1,8574,8573,8601,8600,-1,8581,8580,8613,8612,-1,8641,8640,8653,8652,-1,8579,8578,8605,8604,-1,8572,8575,8585,8584,-1,8577,8576,8597,8596,-1,8633,8632,8621,8620,-1,8583,8582,8589,8588,-1,8620,8576,8644,8633,-1,8579,8653,8640,8645,-1,8652,8580,8636,8641,-1,8583,8621,8632,8637,-1,8664,8665,8666,8667,-1,8668,8669,8670,8671,-1,8672,8673,8674,8675,-1,8676,8677,8678,8679,-1,8680,8681,8682,8683,-1,8684,8685,8686,8687,-1,8688,8689,8690,8691,-1,8692,8693,8694,8695,-1,8696,8697,8698,8699,-1,8700,8701,8702,8703,-1,8704,8705,8706,8707,-1,8708,8709,8710,8711,-1,8712,8713,8714,8715,-1,8716,8717,8718,8719,-1,8720,8721,8722,8723,-1,8724,8725,8726,8727,-1,8728,8729,8730,8731,-1,8732,8733,8734,8735,-1,8736,8737,8738,8739,-1,8740,8741,8742,8743,-1,8744,8745,8746,8747,-1,8748,8749,8750,8751,-1,8752,8753,8754,8755,-1,8756,8757,8758,8759,-1,8760,8761,8762,8763,-1,8764,8765,8766,8767,-1,8715,8766,8763,-1,8712,8762,8759,-1,8713,8758,8755,-1,8714,8754,8767,-1,8675,8750,8747,-1,8672,8746,8743,-1,8673,8742,8739,-1,8674,8738,8751,-1,8699,8734,8731,-1,8696,8730,8727,-1,8697,8726,8723,-1,8698,8722,8735,-1,8671,8718,8760,8765,-1,8764,8753,8711,8668,-1,8669,8710,8707,-1,8670,8706,8719,-1,8667,8702,8728,8733,-1,8732,8721,8695,8664,-1,8665,8694,8691,-1,8666,8690,8703,-1,8677,8685,8716,8705,-1,8684,8756,8761,8717,-1,8757,8683,8708,8752,-1,8704,8709,8682,8678,-1,8679,8681,8700,8689,-1,8680,8724,8729,8701,-1,8725,8687,8692,8720,-1,8688,8693,8686,8676,-1,8767,8766,8715,8714,-1,8763,8762,8712,8715,-1,8760,8763,8766,8765,-1,8759,8758,8713,8712,-1,8756,8759,8762,8761,-1,8755,8754,8714,8713,-1,8752,8755,8758,8757,-1,8764,8767,8754,8753,-1,8751,8750,8675,8674,-1,8747,8746,8672,8675,-1,8744,8747,8750,8749,-1,8743,8742,8673,8672,-1,8740,8743,8746,8745,-1,8739,8738,8674,8673,-1,8736,8739,8742,8741,-1,8748,8751,8738,8737,-1,8735,8734,8699,8698,-1,8731,8730,8696,8699,-1,8728,8731,8734,8733,-1,8727,8726,8697,8696,-1,8724,8727,8730,8729,-1,8723,8722,8698,8697,-1,8720,8723,8726,8725,-1,8732,8735,8722,8721,-1,8719,8718,8671,8670,-1,8765,8764,8668,8671,-1,8761,8760,8718,8717,-1,8711,8710,8669,8668,-1,8708,8711,8753,8752,-1,8707,8706,8670,8669,-1,8704,8707,8710,8709,-1,8716,8719,8706,8705,-1,8703,8702,8667,8666,-1,8733,8732,8664,8667,-1,8729,8728,8702,8701,-1,8695,8694,8665,8664,-1,8692,8695,8721,8720,-1,8691,8690,8666,8665,-1,8688,8691,8694,8693,-1,8700,8703,8690,8689,-1,8682,8681,8679,8678,-1,8686,8685,8677,8676,-1,8680,8683,8749,8748,-1,8684,8687,8741,8740,-1,8678,8677,8705,8704,-1,8685,8684,8717,8716,-1,8745,8744,8757,8756,-1,8683,8682,8709,8708,-1,8676,8679,8689,8688,-1,8681,8680,8701,8700,-1,8737,8736,8725,8724,-1,8687,8686,8693,8692,-1,8724,8680,8748,8737,-1,8683,8757,8744,8749,-1,8756,8684,8740,8745,-1,8687,8725,8736,8741,-1,8768,8769,8770,8771,-1,8772,8773,8774,8775,-1,8776,8777,8778,8779,-1,8780,8781,8782,8783,-1,8784,8785,8786,8787,-1,8788,8789,8790,8791,-1,8792,8793,8794,8795};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_53()
		{
			int[] value = {-1,8796,8797,8798,8799,-1,8800,8801,8802,8803,-1,8804,8805,8806,8807,-1,8808,8809,8810,8811,-1,8812,8813,8814,8815,-1,8816,8817,8818,8819,-1,8820,8821,8822,8823,-1,8824,8825,8826,8827,-1,8828,8829,8830,8831,-1,8832,8833,8834,8835,-1,8779,8834,8831,-1,8776,8830,8827,-1,8777,8826,8823,-1,8778,8822,8835,-1,8833,8818,8815,8828,-1,8829,8814,8811,8824,-1,8825,8810,8807,8820,-1,8821,8806,8819,8832,-1,8817,8802,8799,8812,-1,8813,8798,8795,8808,-1,8809,8794,8791,8804,-1,8805,8790,8803,8816,-1,8792,8797,8775,8784,-1,8801,8783,8772,8796,-1,8800,8789,8771,8780,-1,8793,8787,8768,8788,-1,8835,8834,8779,8778,-1,8831,8830,8776,8779,-1,8828,8831,8834,8833,-1,8827,8826,8777,8776,-1,8824,8827,8830,8829,-1,8823,8822,8778,8777,-1,8820,8823,8826,8825,-1,8832,8835,8822,8821,-1,8819,8818,8833,8832,-1,8815,8814,8829,8828,-1,8812,8815,8818,8817,-1,8811,8810,8825,8824,-1,8808,8811,8814,8813,-1,8807,8806,8821,8820,-1,8804,8807,8810,8809,-1,8816,8819,8806,8805,-1,8803,8802,8817,8816,-1,8799,8798,8813,8812,-1,8796,8799,8802,8801,-1,8795,8794,8809,8808,-1,8792,8795,8798,8797,-1,8791,8790,8805,8804,-1,8788,8791,8794,8793,-1,8800,8803,8790,8789,-1,8780,8783,8801,8800,-1,8784,8787,8793,8792,-1,8785,8784,8775,8774,-1,8797,8796,8772,8775,-1,8783,8782,8773,8772,-1,8781,8780,8771,8770,-1,8789,8788,8768,8771,-1,8787,8786,8769,8768,-1,8836,8837,8838,8839,8840,8841,8842,8843,-1,8774,8773,8838,8837,-1,8785,8774,8837,8836,-1,8786,8785,8836,8843,-1,8769,8786,8843,8842,-1,8770,8769,8842,8841,-1,8781,8770,8841,8840,-1,8782,8781,8840,8839,-1,8773,8782,8839,8838,-1,8844,8845,8846,8847,-1,8848,8849,8850,8851,-1,8849,8848,8852,8853,-1,8854,8855,8856,8857,-1,8851,8850,8858,8859,-1,8855,8854,8859,8858,-1,8853,8852,8845,8844,-1,8860,8861,8862,-1,8863,8864,8865,-1,8866,8867,8868,-1,8867,8863,8865,8868,-1,8861,8869,8870,8862,-1,8869,8871,8870,-1,8871,8869,8872,-1,8867,8866,8873,-1,8870,8871,8874,-1,8871,8875,8876,8874,-1,8875,8853,8844,8876,-1,8858,8877,8878,8855,-1,8877,8866,8879,8878,-1,8866,8868,8879,-1,8860,8862,8880,-1,8865,8864,8881,-1,8852,8882,8883,8845,-1,8882,8860,8880,8883,-1,8860,8884,8861,-1,8885,8864,8863,-1,8864,8886,8887,8881,-1,8886,8859,8854,8887,-1,8879,8868,8888,-1,8873,8889,8890,-1,8891,8872,8892,-1,8870,8874,8893,-1,8880,8862,8894,-1,8884,8895,8896,-1,8897,8885,8898,-1,8865,8881,8899,-1,8886,8864,8897,8900,-1,8863,8867,8873,8885,-1,8866,8877,8901,8889,-1,8902,8903,7997,7996,-1,8904,8905,8001,8000,-1,8857,8856,7996,8001,-1,8881,8904,8906,8899,-1,8903,8879,8888,8907,-1,8905,8887,8854,8857,-1,8878,8902,8856,8855,-1,8908,8901,8850,8849,-1,8848,8851,8900,8909,-1,8895,8897,8898,8896,-1,8909,8895,8860,8882,-1,8892,8890,8889,8891,-1,8884,8872,8869,8861,-1,8891,8908,8875,8871,-1,8910,8876,8844,8847,-1,8846,8845,8883,8911,-1,8847,8846,8912,8913,-1,8914,8880,8894,8915,-1,8911,8914,8916,8912,-1,8917,8893,8874,8918,-1,8919,8920,8921,8916,-1,8918,8910,8913,8921,-1,8922,8919,8915,8923,-1,8924,8894,8862,8925,-1,8923,8924,8926,8927,-1,8928,8870,8893,8929,-1,8925,8928,8930,8926,-1,8931,8917,8920,8932,-1,8929,8931,8933,8930,-1,8932,8922,8927,8933,-1,8934,8884,8896,8935,-1,8936,8898,8885,8937,-1,8935,8936,8938,8939,-1,8940,8873,8890,8941,-1,8937,8940,8942,8938,-1,8943,8892,8872,8944,-1,8941,8943,8945,8942,-1,8944,8934,8939,8945,-1,8946,8888,8868,8947,-1,8948,8865,8899,8949,-1,8947,8948,8950,8951,-1,8952,8906,8051,8953,-1,8949,8952,8954,8950,-1,8955,8055,8907,8956,-1,8953,8955,8957,8954,-1,8956,8946,8951,8957,-1,8900,8851,8859,8886,-1,8864,8885,8897,-1,8873,8866,8889,-1,8877,8858,8850,8901,-1,7996,8856,8902,-1,8903,8907,8055,7997,-1,8051,8906,8904,8000,-1,8905,8857,8001,-1,8853,8875,8908,8849,-1,8882,8852,8848,8909,-1,8895,8884,8860,-1,8871,8872,8891,-1,8847,8913,8910,-1,8911,8912,8846,-1,8915,8919,8916,8914,-1,8918,8921,8920,8917,-1,8923,8927,8922,-1,8925,8926,8924,-1,8929,8930,8928,-1,8932,8933,8931,-1,8935,8939,8934,-1,8937,8938,8936,-1,8941,8942,8940,-1,8944,8945,8943,-1,8947,8951,8946,-1,8949,8950,8948,-1,8953,8954,8952,-1,8956,8957,8955,-1,8907,8888,8946,8956,-1,8051,8055,8955,8953,-1,8899,8906,8952,8949,-1,8868,8865,8948,8947,-1,8872,8884,8934,8944,-1,8890,8892,8943,8941,-1,8885,8873,8940,8937,-1,8896,8898,8936,8935,-1,8920,8919,8922,8932,-1,8893,8917,8931,8929,-1,8862,8870,8928,8925,-1,8915,8894,8924,8923,-1,8874,8876,8910,8918,-1,8926,8930,8933,8927,-1,8883,8880,8914,8911,-1,8889,8901,8908,8891,-1,8938,8942,8945,8939,-1,8900,8897,8895,8909,-1,8905,8904,8881,8887,-1,8878,8879,8903,8902,-1,8950,8954,8957,8951,-1,8912,8916,8921,8913,-1,10621,10622,10623,10624,-1,10637,10638,10639,10640,-1,10638,10622,10621,10639,-1,10641,10642,10643,10644,-1,4141,10645,10646,10647};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_54()
		{
			int[] value = {-1,10641,10644,10648,10649,-1,10650,10651,10652,10643,-1,10651,10650,10653,10654,-1,10655,10656,10654,10653,-1,10657,10658,10656,10655,-1,10658,10657,4141,10647,-1,10659,10660,10661,-1,10662,10663,10664,10665,-1,10666,10667,10663,10662,-1,10668,10669,10670,10671,-1,10672,10673,10669,10668,-1,10674,10675,10673,10672,-1,10675,10674,10676,10677,-1,10678,10679,10677,10676,-1,10659,10661,10679,10678,-1,10680,10681,10682,10683,-1,10684,10683,10682,-1,10685,10649,10648,-1,10643,10652,10644,-1,10686,10642,10641,-1,10687,10686,10641,10649,-1,10688,10687,10649,10685,-1,10689,10690,10688,-1,10688,10691,10689,-1,10665,10664,10692,10693,-1,10693,10692,10681,10680,-1,10694,10695,10638,10637,-1,10695,10696,10622,10638,-1,10696,10697,10623,10622,-1,10667,10666,10698,10699,-1,10699,10698,10671,10670,-1,10700,10701,10702,-1,10701,10703,10702,-1,10704,10705,10706,10707,-1,10707,10706,10708,10709,-1,10702,10709,10708,10700,-1,10702,10710,10709,-1,10711,10712,10713,10714,-1,10715,10716,10717,10718,-1,10717,10716,10719,10720,-1,10724,10725,10726,10727,-1,10728,10677,10679,10729,-1,10733,10734,10735,10736,-1,10738,10730,10737,10739,-1,10741,10742,10743,10744,-1,10745,10742,10741,-1,10714,10713,10746,10747,-1,10670,10669,10732,10731,-1,10740,10738,10750,-1,10751,10705,10704,10749,10748,-1,10722,10721,10673,10675,-1,10752,10753,10754,10755,-1,10756,10757,10758,10759,-1,10759,10758,10760,10761,-1,10762,10763,10764,10765,-1,10766,10767,10768,10769,-1,10770,10771,10772,10773,-1,10774,10775,10776,10777,-1,10776,10775,10778,10779,-1,10780,10781,10782,10783,-1,10784,10785,10701,10786,-1,10787,10788,10789,10790,-1,10789,10788,10791,10792,-1,10793,10794,10795,10796,-1,4066,10797,10798,10625,-1,10800,10801,10802,10803,-1,10803,10802,10804,10805,-1,10806,10807,10808,10809,-1,10810,10811,10812,10813,-1,10814,10815,10816,10817,-1,10818,10819,10820,10821,-1,10822,10801,10800,10823,-1,10679,10661,10825,10729,-1,10777,10648,10644,10774,-1,10826,10827,10828,10829,-1,10830,4201,10682,10681,-1,10663,10667,10831,4202,-1,10832,10833,10834,10835,-1,10836,10837,10838,10839,-1,10840,10841,10842,-1,4057,4056,10841,10840,-1,10844,10751,10748,10843,-1,10845,10784,10786,10846,-1,10847,10848,10726,10725,-1,10736,10735,10849,10850,-1,10851,10852,10853,10854,-1,10855,10856,10857,10858,-1,10809,10859,10860,10806,-1,10717,10861,10862,10718,-1,10720,10863,10861,10717,-1,10769,10864,10865,10766,-1,10713,10866,10867,10746,-1,10712,10868,10866,10713,-1,10856,10869,10870,10857,-1,10772,10820,10819,10773,-1,10742,10816,10815,10743,-1,10778,10782,10781,10779,-1,10721,10732,10669,10673,-1,10872,10841,4056,10871,-1,10873,10838,10837,10874,-1,10874,10875,10876,10873,-1,10871,10877,10878,10872,-1,10879,10756,10759,10880,-1,10880,10759,10761,10881,-1,10882,10762,10765,10883,-1,10884,10864,10769,10885,-1,10885,10769,10768,10886,-1,10887,10770,10773,10888,-1,10888,10773,10819,10889,-1,10889,10819,10818,10890,-1,10685,10648,10777,10691,-1,10689,10691,10777,10776,10626,-1,10626,10776,10779,10627,-1,10627,10779,10781,4067,-1,4067,10781,10780,10628,-1,10630,10833,10832,10631,-1,10829,10828,10635,10634,-1,10635,10828,10785,10784,4068,-1,4068,10784,10845,10636,-1,10891,10839,10838,10892,-1,10892,10838,10873,4214,-1,4214,10873,10876,10893,-1,10894,10790,10789,4215,-1,4215,10789,10792,10895,-1,10896,10793,10796,4216,-1,10700,10897,10786,10701,-1,10786,10897,10898,10846,-1,10836,10899,10900,10837,-1,10837,10900,10901,10874,-1,10874,10901,10902,10875,-1,10787,10903,10904,10788,-1,10788,10904,10905,10791,-1,10794,10906,10907,10795,-1,10703,10701,10827,10910,-1,10700,10708,10911,10897,-1,10897,10911,10912,10898,-1,10899,10913,10914,10900,-1,10900,10914,10915,10901,-1,10901,10915,10916,10902,-1,10903,10917,10918,10904,-1,10904,10918,10919,10905,-1,10906,10637,10640,10907,-1,10709,10710,10920,10921,-1,10797,10922,10923,10798,-1,10924,10653,10650,10925,-1,10644,10926,10927,10774,-1,10774,10927,10928,10775,-1,10775,10928,10929,10778,-1,10778,10929,10930,10782,-1,10782,10930,10931,10783,-1,10834,10932,10933,10835,-1,10934,10910,10827,10826,-1,10922,10935,10728,10923,-1,10936,10825,10661,10660,10926,-1,10926,10660,10659,10927,-1,10927,10678,10676,10928,-1,10937,10674,10672,10938,-1,10938,10672,10668,10939,-1,10939,10668,10671,10940,-1,10941,10666,10662,10942,-1,10680,10683,10943,10944,-1,4141,10657,10945,4234,-1,10822,10946,10947,10801,-1,10801,10947,10948,10802,-1,10802,10948,10949,10804,-1,10808,10950,10951,10809,-1,10809,10951,10952,10859,-1,10812,10953,10954,10813,-1,10870,10955,10956,10857,-1,10857,10956,10957,10858,-1,10851,10958,10959,10852,-1,10753,10734,10733,10754,-1,10757,10747,10746,10758,-1,10758,10746,10867,10760,-1,10763,10724,10727,10764,-1,10865,10863,10720,10766,-1,10766,10720,10719,10767,-1,10771,10744,10743,10772,-1,10772,10743,10815,10820,-1,10820,10815,10814,10821,-1,10643,10642,10925,10650,-1,10926,10651,10654,10936,-1,10960,10752,10755,10961,-1,10684,10909,10908,10962,-1,10910,10684,10962,10703,-1,10785,10828,10827,10701,-1,10921,10963,10707,10709,-1,10708,10706,10964,10911,-1,10911,10964,10965,10912,-1,10913,10966,10967,10914,-1,10914,10967,10968,10915,-1,10915,10968,10969,10916,-1,10917,10970,10971,10918,-1,10918,10971,10972,10919,-1,10963,10749,10704,10707,-1,10706,10705,10751,10964,-1,10964,10751,10844,10965,-1,10966,10842,10841,10967,-1,10967,10841,10872,10968,-1,10968,10872,10878,10969,-1,10970,10750,10738,10971,-1,10971,10738,10739};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_55()
		{
			int[] value = {10972,-1,10664,10663,4202,10973,-1,10974,10942,10662,10665,-1,10975,10835,10933,10976,-1,10977,10832,10835,10975,-1,10632,10631,10832,10977,-1,10684,10682,4201,10909,-1,10935,10723,10722,10728,-1,10728,10722,10675,10677,-1,10676,10674,10937,10928,-1,10928,10937,10938,10929,-1,10929,10938,10939,10930,-1,10930,10939,10940,10931,-1,10932,10941,10942,10933,-1,10933,10942,10974,10976,-1,10934,10944,10943,10910,-1,10910,10943,10683,10684,-1,10798,4262,10978,10625,-1,10625,10978,10979,10980,-1,10980,10979,10981,10982,-1,10983,10984,10985,10986,-1,10986,10985,10987,10988,-1,10988,10987,10989,10990,-1,10991,10992,10993,10994,-1,10994,10993,10995,10996,-1,10997,10998,10999,11000,-1,11001,11002,11003,11004,-1,11004,11003,11005,11006,-1,11007,11008,11009,11010,-1,10849,11011,11012,10850,-1,10711,11013,11014,10712,-1,10712,11014,11015,10868,-1,10847,11016,11017,10848,-1,10862,11018,11019,10718,-1,10718,11019,11020,10715,-1,10745,11021,11022,10742,-1,10742,11022,11023,10816,-1,10816,11023,11024,10817,-1,10924,11025,10655,10653,-1,10654,10656,11026,10936,-1,10936,11026,11027,10825,-1,10825,11027,4263,10729,-1,10729,4263,11028,10728,-1,10728,11028,4264,10923,-1,10923,4264,4262,10798,-1,10979,10799,10824,10981,-1,10984,10823,10800,10985,-1,10985,10800,10803,10987,-1,10987,10803,10805,10989,-1,10992,10807,10806,10993,-1,10993,10806,10860,10995,-1,10998,10811,10810,10999,-1,11002,10869,10856,11003,-1,11003,10856,10855,11005,-1,11008,10854,10853,11009,-1,11011,10959,10958,11012,-1,11013,10957,10956,11014,-1,11014,10956,10955,11015,-1,11016,10954,10953,11017,-1,11018,10952,10951,11019,-1,11019,10951,10950,11020,-1,11021,10948,11022,-1,11022,10948,10947,11023,-1,11023,10947,10946,11024,-1,11025,10945,10657,10655,-1,10656,10658,11029,11026,-1,11026,11029,4239,11027,-1,11027,4239,4238,4263,-1,11029,10647,10646,4239,-1,10658,10647,11029,-1,10651,10926,10652,-1,10644,10652,10926,-1,10659,10678,10927,-1,10996,10995,11030,11031,-1,11031,11030,10998,10997,-1,10995,10860,11032,11030,-1,11030,11032,10811,10998,-1,10860,10859,11033,11032,-1,11032,11033,10812,10811,-1,10859,10952,11034,11033,-1,11033,11034,10953,10812,-1,11017,10953,11034,11035,-1,11035,11034,10952,11018,-1,10848,11017,11035,11036,-1,11036,11035,11018,10862,-1,10862,10861,11037,11036,-1,11036,11037,10726,10848,-1,10727,10726,11037,11038,-1,11038,11037,10861,10863,-1,10764,10727,11038,11039,-1,11039,11038,10863,10865,-1,10883,10765,11040,11041,-1,11041,11040,10864,10884,-1,10765,10764,11039,11040,-1,11040,11039,10865,10864,-1,11006,11005,11042,11043,-1,11043,11042,11008,11007,-1,11005,10855,11044,11042,-1,11042,11044,10854,11008,-1,10851,10854,11044,11045,-1,11045,11044,10855,10858,-1,10858,10957,11046,11045,-1,11045,11046,10958,10851,-1,11012,10958,11046,11047,-1,11047,11046,10957,11013,-1,10850,11012,11047,11048,-1,11048,11047,11013,10711,-1,10711,10714,11049,11048,-1,11048,11049,10736,10850,-1,10733,10736,11049,11050,-1,11050,11049,10714,10747,-1,10754,10733,11050,11051,-1,11051,11050,10747,10757,-1,10961,10755,11052,11053,-1,11053,11052,10756,10879,-1,10755,10754,11051,11052,-1,11052,11051,10757,10756,-1,10761,10760,11054,11055,-1,11055,11054,10763,10762,-1,10881,10761,11055,11056,-1,11056,11055,10762,10882,-1,10760,10867,11057,11054,-1,11054,11057,10724,10763,-1,10867,10866,11058,11057,-1,11057,11058,10725,10724,-1,10866,10868,11059,11058,-1,11058,11059,10847,10725,-1,10868,11015,11060,11059,-1,11059,11060,11016,10847,-1,11015,10955,11061,11060,-1,11060,11061,10954,11016,-1,10813,10954,11061,11062,-1,11062,11061,10955,10870,-1,10810,10813,11062,11063,-1,11063,11062,10870,10869,-1,10999,10810,11063,11064,-1,11064,11063,10869,11002,-1,11000,10999,11064,11065,-1,11065,11064,11002,11001,-1,10767,10719,11066,11067,-1,11067,11066,10744,10771,-1,10768,10767,11067,11068,-1,11068,11067,10771,10770,-1,10886,10768,11068,11069,-1,11069,11068,10770,10887,-1,10719,10716,11070,11066,-1,11066,11070,10741,10744,-1,10716,10715,11071,11070,-1,11070,11071,10745,10741,-1,10715,11020,11072,11071,-1,11071,11072,11021,10745,-1,11020,10950,11073,11072,-1,11072,11073,10949,11021,-1,10804,10949,11073,11074,-1,11074,11073,10950,10808,-1,10805,10804,11074,11075,-1,11075,11074,10808,10807,-1,10989,10805,11075,11076,-1,11076,11075,10807,10992,-1,10990,10989,11076,11077,-1,11077,11076,10992,10991,-1,10821,10814,11078,11079,-1,11079,11080,10818,10821,-1,10890,10818,11080,11081,-1,11082,11078,10814,10817,-1,10817,11024,11083,11082,-1,11024,10946,11084,11083,-1,11085,11084,10946,10822,-1,10822,10823,11086,11085,-1,11087,11086,10823,10984,-1,11088,11087,10984,10983,-1,11089,4200,4234,-1,10688,10685,10691,-1,10686,11090,10925,10642,-1,10924,10925,11090,11091,-1,11091,11092,11025,10924,-1,11092,11093,10945,11025,-1,4234,10945,11093,11089,-1,10824,4200,11089,11094,-1,10981,10824,11094,11095,-1,10982,10981,11095,11096,-1,10702,10703,10962,-1,10830,10681,10692,4265,-1,4265,10692,10664,10973,-1,10680,10944,11097,10693,-1,10693,11097,10974,10665,-1,10829,10634,10633,11098,-1,11098,10633,10632,10977,-1,10826,10829,11098,11099,-1,11099,11098,10977,10975,-1,10934,10826,11099,11100,-1,11100,11099,10975,10976,-1,10976,10974,11097,11100,-1,11100,11097,10944,10934,-1,10740,10750,11101,4274,-1,4274,11101,10878,10877,-1,10969,10878,11101,11102,-1,11102,11101,10750,10970,-1,10893,10876,11103,11104,-1,11104,11103,10790,10894,-1,10787,10790,11103,11105,-1,11105,11103,10876,10875,-1,10875};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_56()
		{
			int[] value = {10902,11106,11105,-1,11105,11106,10903,10787,-1,10902,10916,11107,11106,-1,11106,11107,10917,10903,-1,10916,10969,11102,11107,-1,11107,11102,10970,10917,-1,10962,10908,4275,10702,-1,10702,4275,10920,10710,-1,10919,10972,10695,10694,-1,10905,10919,10694,11108,-1,11108,10694,10637,10906,-1,10791,10905,11108,11109,-1,11109,11108,10906,10794,-1,10792,10791,11109,11110,-1,11110,11109,10794,10793,-1,10895,10792,11110,11111,-1,11111,11110,10793,10896,-1,10972,10739,10696,10695,-1,10739,10737,10697,10696,-1,10912,10965,11112,11113,-1,11113,11112,10966,10913,-1,10898,10912,11113,11114,-1,11114,11113,10913,10899,-1,10846,10898,11114,11115,-1,11115,11114,10899,10836,-1,10836,10839,11116,11115,-1,11115,11116,10845,10846,-1,10636,10845,11116,11117,-1,11117,11116,10839,10891,-1,10965,10844,11118,11112,-1,11112,11118,10842,10966,-1,10840,10842,11118,11119,-1,11119,11118,10844,10843,-1,10931,10940,11120,11121,-1,11121,11120,10941,10932,-1,10783,10931,11121,11122,-1,11122,11121,10932,10834,-1,10780,10783,11122,11123,-1,11123,11122,10834,10833,-1,10628,10780,11123,10629,-1,10629,11123,10833,10630,-1,10940,10671,10698,11120,-1,11120,10698,10666,10941,-1,10670,10731,11124,10699,-1,10699,11124,10831,10667,-1,11125,10988,10990,11077,10991,10994,10996,11031,10997,11000,11065,11001,11004,11006,11043,11007,11010,11126,10960,10961,11053,10879,10880,10881,11056,10882,10883,11041,10884,10885,10886,11069,10887,10888,10889,10890,11081,-1,11127,11128,11129,-1,11130,11131,11132,-1,11135,11136,11137,-1,11138,11139,11140,-1,11141,11142,11143,-1,11144,11145,11146,-1,11147,11148,11149,-1,11150,11149,11151,11152,-1,11153,11154,11155,11156,-1,11157,11158,11159,11160,-1,11161,11162,11163,11164,-1,11165,11166,11167,-1,11168,11169,11170,-1,11171,11172,11173,11174,-1,11176,11175,11178,-1,11176,11178,11179,11177,-1,11178,11175,11180,-1,11178,11180,11181,11179,-1,11180,11175,11182,11183,-1,11180,11183,11184,11181,-1,11185,11183,11182,-1,11184,11183,11185,11186,-1,11185,11182,11187,-1,11188,11187,11182,-1,11166,11186,11185,11187,-1,11182,11189,11188,-1,11190,11166,11187,11188,-1,11191,11190,11188,11189,-1,11189,11182,11192,11193,-1,11193,11194,11191,11189,-1,11195,11193,11192,-1,11196,11194,11193,11195,-1,11197,11195,11192,-1,11198,11196,11195,11197,-1,11199,11197,11192,11200,-1,11198,11197,11199,11139,-1,11199,11200,11201,-1,11199,11201,11145,11139,-1,11201,11202,11149,11145,-1,11202,11201,11200,-1,11203,11202,11200,-1,11149,11202,11203,11151,-1,11204,11203,11200,11205,-1,11205,11206,11204,-1,11207,11151,11203,11204,-1,11208,11207,11204,11206,-1,11209,11210,11138,11211,-1,11212,11213,11214,11215,-1,11213,11212,11210,11209,-1,11216,11217,11215,11214,-1,11218,11141,11217,11216,-1,11142,11141,11218,-1,11142,11219,11143,-1,11220,11219,11221,11222,-1,11219,11220,11223,11143,-1,11145,11144,11140,11139,-1,11128,11224,11129,-1,11129,11224,11225,11226,-1,11227,11228,11229,11130,-1,11230,11231,11232,-1,11137,11233,11234,11135,-1,11235,11236,11150,11152,-1,11237,11238,11143,11223,-1,11239,11229,11240,11241,-1,11130,11229,11239,11131,-1,11242,11132,11243,11244,-1,11245,11246,11247,11248,-1,11249,11250,11251,11252,-1,11253,11254,11255,11256,-1,11153,11257,11258,11154,-1,11259,11260,11154,11258,-1,11257,11153,11261,11262,-1,11258,11257,11263,11264,-1,11265,11264,11266,-1,11267,11268,11269,11270,-1,11270,11269,11271,11272,-1,11260,11259,11268,11267,-1,11273,11274,11275,11276,-1,11277,11278,11160,-1,11158,11157,11256,11255,-1,11160,11159,11173,11172,-1,11279,11280,11281,11282,-1,11283,11284,11285,11286,-1,11286,11285,11280,11279,-1,11287,11288,11284,11283,-1,11235,11289,11288,11287,-1,11207,11290,11291,11151,-1,11292,11290,11207,-1,11293,11294,11295,11296,-1,11297,11292,11207,-1,11297,11298,11299,-1,11207,11208,11300,11297,-1,11261,11301,11302,11303,-1,11266,11264,11263,-1,11282,11281,11304,11305,-1,11227,11306,11307,11308,-1,11247,11246,11222,11221,-1,11194,11309,11310,11191,-1,11311,11309,11194,11196,-1,11312,11196,11313,-1,11198,11314,11313,11196,-1,11139,11315,11314,11198,-1,11238,11237,11316,-1,11241,11240,11214,11213,-1,11150,11147,11149,-1,11151,11291,11152,-1,11317,11318,11308,11307,-1,11321,11249,11322,-1,11253,11324,11323,11254,-1,11325,11326,11276,11275,-1,11327,11328,11329,11330,-1,11329,11156,11155,11330,-1,11179,11338,11337,11177,-1,11336,11335,11339,11340,-1,11181,11339,11338,11179,-1,11341,11343,11344,11342,-1,11345,11343,11334,11333,-1,11346,11347,11161,11164,-1,11162,11161,11348,11349,-1,11348,11184,11186,11349,-1,11163,11162,11165,11167,-1,11166,11165,11349,11186,-1,11190,11350,11167,11166,-1,11164,11163,11351,11352,-1,11191,11310,11350,11190,-1,11352,11351,11353,11354,-1,11354,11353,11245,11248,-1,11133,11355,11356,11134,-1,11357,11358,11226,11225,-1,11144,11146,11359,-1,11149,11148,11146,11145,-1,11360,11361,11362,11363,-1,11266,11364,11365,11366,-1,11367,11368,11364,11266,-1,11369,11370,11368,11367,-1,11298,11371,11370,11369,-1,11168,11170,11372,11373,-1,11374,11375,11170,11169,-1,11172,11171,11375,11374,-1,11362,11174,11173,11363,-1,11320,11319,11373,11372,-1,11147,11376,11377,-1,11377,11376,11378,11379,-1,11144,11359,11380,11381,-1,11146,11148,11382,11359,-1,11225,11383,11384,11357,-1,11356,11386,11385,11134,-1,11226,11358,11385,11386,-1,11142,11386,11356,-1,11387,11356,11355,11388,-1,11355,11133,11389,-1,11389,11133,11342,11344,-1,11346,11164,11352,11390,-1,11390,11352,11354,11391,-1,11354,11248,11388,11391,-1,11350,11310,11245};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_57()
		{
			int[] value = {11353,-1,11350,11353,11351,-1,11350,11351,11163,11167,-1,11165,11162,11349,-1,11340,11181,11392,11393,-1,11392,11348,11161,11347,-1,11345,11333,11394,11393,-1,11341,11334,11343,-1,11339,11335,11395,11338,-1,11338,11395,11337,-1,11394,11336,11340,11393,-1,11332,11331,11318,11317,-1,11397,11398,11399,11400,-1,11401,11396,11397,11400,-1,11399,11305,11304,11400,-1,11399,11398,11332,11317,-1,11318,11331,11402,11403,-1,11384,11383,11403,11402,-1,11328,11404,11405,11329,-1,11135,11406,11407,11136,-1,11276,11326,11324,11253,-1,11323,11408,11409,11254,-1,11411,11412,11410,11413,-1,11322,11414,11321,-1,11252,11415,11322,11249,-1,11252,11251,11416,-1,4410,11415,11252,11416,-1,11399,11317,11307,11305,-1,11318,11403,11417,11308,-1,11403,11383,11418,11417,-1,11142,11218,11127,11386,-1,11127,11129,11226,11386,-1,11417,11227,11308,-1,11417,11418,11228,11227,-1,11130,11419,11306,11227,-1,11419,11279,11282,11306,-1,11279,11419,11242,11286,-1,11132,11242,11419,11130,-1,11242,11244,11283,11286,-1,11287,11283,11244,11420,-1,11152,11291,11289,11235,-1,11421,11422,11379,11243,-1,11380,11423,11424,11381,-1,11209,11424,11241,11213,-1,11214,11240,11128,11216,-1,11315,11425,11237,11314,-1,11313,11314,11237,11223,-1,11311,11196,11312,-1,11246,11309,11311,11222,-1,11218,11216,11128,11127,-1,11307,11306,11282,11305,-1,11211,11381,11424,11209,-1,11232,11426,11135,11234,-1,11427,11230,11234,11401,-1,11400,11428,11427,11401,-1,11304,11281,11429,11428,-1,11430,11431,11432,11433,-1,11430,11434,11435,11431,-1,11231,11294,11293,-1,11231,11293,11426,11232,-1,11230,11427,11436,11231,-1,11232,11234,11230,-1,11400,11304,11428,-1,11263,11437,11438,11266,-1,11266,11438,11367,-1,11303,11439,11262,11261,-1,11155,11440,11330,-1,11329,11405,11301,11156,-1,11302,11405,11406,11441,-1,11442,11437,11262,11439,-1,11443,11438,11437,11442,-1,11444,11367,11438,11443,-1,11369,11367,11444,11445,-1,11298,11369,11445,11299,-1,11297,11300,11371,11298,-1,11297,11299,11446,11292,-1,11299,11445,11447,11446,-1,11445,11444,11448,11447,-1,11443,11449,11448,11444,-1,11442,11450,11449,11443,-1,11442,11439,11295,11450,-1,11295,11439,11303,11296,-1,11296,11303,11302,11441,-1,11295,11294,11432,11450,-1,11450,11432,11431,11449,-1,11449,11431,11435,11448,-1,11434,11451,11435,-1,11448,11435,11451,11447,-1,11447,11451,11452,11446,-1,11446,11452,11290,11292,-1,11451,11434,11284,11288,-1,11451,11288,11289,11452,-1,11284,11434,11430,11285,-1,11430,11433,11280,11285,-1,11280,11433,11429,11281,-1,11160,11172,11374,11277,-1,11277,11374,11169,11250,-1,11363,11173,11159,11453,-1,11360,11363,11453,11271,-1,11272,11271,11453,11454,-1,11255,11455,11454,11158,-1,11273,11256,11157,-1,11256,11273,11276,11253,-1,11456,11457,11412,-1,11456,11412,11411,11458,-1,11458,11411,11330,11440,-1,11267,11458,11440,11260,-1,11269,11360,11271,-1,11268,11459,11360,11269,-1,11366,11360,11459,-1,11459,11265,11266,11366,-1,11259,11265,11459,11268,-1,11265,11259,11258,11264,-1,11263,11257,11262,11437,-1,11153,11156,11301,11261,-1,11260,11440,11155,11154,-1,11457,11272,11454,11455,-1,11456,11270,11272,11457,-1,11458,11267,11270,11456,-1,11255,11254,11409,11455,-1,11250,11169,11168,11251,-1,11414,11278,11277,11321,-1,11245,11310,11309,11246,-1,11421,11243,11132,11131,-1,11131,11239,11423,11421,-1,11424,11423,11239,11241,-1,11380,11422,11421,11423,-1,11236,11376,11147,11150,-1,11376,11236,11420,11378,-1,11420,11244,11243,11378,-1,11243,11379,11378,-1,11377,11379,11422,11382,-1,11377,11382,11148,11147,-1,11422,11380,11359,11382,-1,11291,11290,11452,11289,-1,11233,11396,11401,11234,-1,11428,11429,11294,11436,-1,11296,11441,11426,11293,-1,11366,11365,11361,11360,-1,11240,11229,11228,11128,-1,11224,11418,11383,11225,-1,11128,11228,11418,11224,-1,11144,11381,11211,11140,-1,11405,11404,11407,11406,-1,11441,11406,11135,11426,-1,11294,11429,11433,11432,-1,11387,11388,11248,11247,-1,11219,11142,11221,-1,11387,11247,11221,11142,-1,11141,11143,11238,11217,-1,11217,11238,11316,11215,-1,11212,11425,11315,11210,-1,11210,11315,11138,-1,11315,11139,11138,-1,11413,11327,11330,11411,-1,11275,11274,11278,11414,-1,11414,11322,11325,11275,-1,11409,11408,11410,11412,-1,11455,11409,11412,11457,-1,11416,11251,11168,11373,-1,11373,11319,11416,-1,11140,11211,11138,-1,11236,11235,11287,11420,-1,11249,11321,11277,11250,-1,11453,11159,11158,11454,-1,11274,11273,11157,11160,-1,11160,11278,11274,-1,11387,11142,11356,-1,11340,11339,11181,-1,11181,11184,11348,11392,-1,11313,11223,11220,11312,-1,11312,11220,11222,11311,-1,11237,11425,11316,-1,11316,11425,11212,11215,-1,11388,11355,11389,11391,-1,11391,11389,11344,11390,-1,11390,11344,11343,11346,-1,11346,11343,11345,11347,-1,11347,11345,11393,11392,-1,11294,11231,11436,-1,11302,11301,11405,-1,11436,11427,11428,-1,11460,11461,11462,11463,-1,11464,11465,11466,11467,-1,11468,11469,11470,11471,-1,11472,11473,11474,11475,-1,11476,11477,11478,11479,-1,11480,11481,11477,11476,-1,11482,11483,11481,11480,-1,11484,11485,11483,11482,-1,11486,11487,11485,11484,-1,11488,11489,11487,11486,-1,11490,11491,11489,11488,-1,11492,11493,11491,11490,-1,11494,11495,11493,11492,-1,11496,11497,11495,11494,-1,11498,11499,11497,11496,-1,11500,11501,11499,11498,-1,11502,11503,11501,11500,-1,11504,11505,11503,11502,-1,11506,11507,11505,11504,-1,11508,11509,11507,11506,-1,11510,11511,11509,11508,-1,11512,11513,11511,11510,-1,11514,11515,11513,11512,-1,11516,11517,11515,11514,-1,11518,11519,11517,11516};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_58()
		{
			int[] value = {-1,11479,11478,11519,11518,-1,11477,11520,11521,11478,-1,11481,11522,11520,11477,-1,11483,11523,11522,11481,-1,11485,11524,11523,11483,-1,11487,11525,11524,11485,-1,11489,11460,11525,11487,-1,11491,11461,11460,11489,-1,11493,11526,11461,11491,-1,11495,11527,11526,11493,-1,11497,11528,11527,11495,-1,11499,11529,11528,11497,-1,11501,11530,11529,11499,-1,11503,11531,11530,11501,-1,11505,11532,11531,11503,-1,11507,11533,11532,11505,-1,11509,11462,11533,11507,-1,11511,11463,11462,11509,-1,11513,11534,11463,11511,-1,11515,11535,11534,11513,-1,11517,11536,11535,11515,-1,11519,11537,11536,11517,-1,11478,11521,11537,11519,-1,11528,11529,11530,11531,-1,11526,11527,11532,11533,-1,11531,11532,11527,11528,-1,11461,11526,11533,11462,-1,11534,11535,11524,11525,-1,11525,11460,11463,11534,-1,11536,11537,11522,11523,-1,11523,11524,11535,11536,-1,11537,11521,11520,11522,-1,11538,11539,11473,11472,-1,11539,11538,11469,11468,-1,11540,11541,11465,11464,-1,11541,11540,11475,11474,-1,11542,11543,11544,11545,-1,11543,11542,11467,11466,-1,11545,11544,11546,11547,-1,11479,11547,11546,11476,-1,11518,11545,11547,11479,-1,11516,11542,11545,11518,-1,11514,11467,11542,11516,-1,11512,11464,11467,11514,-1,11510,11540,11464,11512,-1,11508,11475,11540,11510,-1,11506,11472,11475,11508,-1,11504,11538,11472,11506,-1,11502,11469,11538,11504,-1,11500,11470,11469,11502,-1,11498,11471,11470,11500,-1,11496,11468,11471,11498,-1,11494,11539,11468,11496,-1,11492,11473,11539,11494,-1,11490,11474,11473,11492,-1,11488,11541,11474,11490,-1,11486,11465,11541,11488,-1,11484,11466,11465,11486,-1,11482,11543,11466,11484,-1,11480,11544,11543,11482,-1,11476,11546,11544,11480,-1,11548,11549,11550,11551,-1,11551,11550,11552,11553,-1,11553,11552,11554,11555,-1,11555,11554,11556,11557,-1,11557,11556,11558,11559,-1,11560,11561,11562,11563,-1,11549,11564,11565,11550,-1,11550,11565,11566,11552,-1,11552,11566,11567,11554,-1,11554,11567,11568,11556,-1,11556,11568,11569,11558,-1,11561,11570,11571,11562,-1,11564,11572,11573,11565,-1,11565,11573,11574,11566,-1,11566,11574,11575,11567,-1,11567,11575,11576,11568,-1,11568,11576,11577,11569,-1,11570,11578,11579,11571,-1,11572,11580,11581,11573,-1,11573,11581,11582,11574,-1,11574,11582,11583,11575,-1,11575,11583,11584,11576,-1,11576,11584,11585,11577,-1,11578,11586,11587,11579,-1,11580,11588,11589,11581,-1,11581,11589,11590,11582,-1,11582,11590,11591,11583,-1,11583,11591,11592,11584,-1,11584,11592,11593,11585,-1,11586,11594,11595,11587,-1,11588,11596,11597,11589,-1,11589,11597,11598,11590,-1,11590,11598,11599,11591,-1,11591,11599,11600,11592,-1,11592,11600,11601,11593,-1,11594,11602,11603,11595,-1,11596,11604,11605,11597,-1,11597,11605,11606,11598,-1,11598,11606,11607,11599,-1,11599,11607,11608,11600,-1,11600,11608,11609,11601,-1,11602,11610,11611,11603,-1,11604,11612,11613,11605,-1,11605,11613,11614,11606,-1,11606,11614,11615,11607,-1,11607,11615,11616,11608,-1,11608,11616,11617,11609,-1,11610,11618,11619,11611,-1,11612,11620,11621,11613,-1,11613,11621,11622,11614,-1,11614,11622,11623,11615,-1,11615,11623,11624,11616,-1,11616,11624,11625,11617,-1,11618,11626,11627,11619,-1,11628,11629,11630,11631,-1,11624,11623,11622,11621,-1,11612,11632,11633,11620,-1,11604,11634,11632,11612,-1,11596,11635,11634,11604,-1,11588,11636,11635,11596,-1,11580,11637,11636,11588,-1,11572,11638,11637,11580,-1,11564,11639,11638,11572,-1,11549,11640,11639,11564,-1,11548,11641,11640,11549,-1,11630,11642,11643,11631,-1,11644,11645,11646,11647,-1,11648,11649,11645,11644,-1,11650,11651,11649,11648,-1,11652,11653,11651,11650,-1,11654,11655,11653,11652,-1,11656,11657,11655,11654,-1,11658,11659,11657,11656,-1,11660,11661,11659,11658,-1,11625,11662,11661,11660,-1,11620,11633,11662,11625,-1,11632,11663,11664,11633,-1,11634,11665,11663,11632,-1,11635,11666,11665,11634,-1,11636,11667,11666,11635,-1,11637,11668,11667,11636,-1,11638,11669,11668,11637,-1,11639,11670,11669,11638,-1,11640,11671,11670,11639,-1,11641,11672,11671,11640,-1,11642,11673,11674,11643,-1,11645,11675,11676,11646,-1,11649,11677,11675,11645,-1,11651,11678,11677,11649,-1,11653,11679,11678,11651,-1,11655,11680,11679,11653,-1,11657,11681,11680,11655,-1,11659,11682,11681,11657,-1,11661,11683,11682,11659,-1,11662,11684,11683,11661,-1,11633,11664,11684,11662,-1,11672,11685,11686,11671,-1,11673,11687,11688,11674,-1,11675,11689,11690,11676,-1,11677,11691,11689,11675,-1,11678,11692,11691,11677,-1,11679,11693,11692,11678,-1,11680,11694,11693,11679,-1,11681,11695,11694,11680,-1,11682,11696,11695,11681,-1,11683,11697,11696,11682,-1,11684,11698,11697,11683,-1,11664,11699,11698,11684,-1,11663,11700,11699,11664,-1,11665,11701,11700,11663,-1,11666,11702,11701,11665,-1,11667,11703,11702,11666,-1,11668,11704,11703,11667,-1,11669,11705,11704,11668,-1,11670,11706,11705,11669,-1,11671,11686,11706,11670,-1,11685,11563,11562,11686,-1,11687,11707,11708,11688,-1,11689,11561,11560,11690,-1,11691,11570,11561,11689,-1,11692,11578,11570,11691,-1,11693,11586,11578,11692,-1,11694,11594,11586,11693,-1,11695,11602,11594,11694,-1,11696,11610,11602,11695,-1,11697,11618,11610,11696,-1,11698,11626,11618,11697,-1,11699,11627,11626,11698,-1,11700,11619,11627,11699,-1,11701,11611,11619,11700,-1,11702,11603,11611,11701,-1,11703,11595,11603,11702,-1,11704,11587,11595,11703,-1,11705,11579,11587,11704,-1,11706,11571,11579,11705,-1,11686,11562,11571,11706,-1,11621,11620,11625,11624,-1,11628,11709,11710,11629,-1,11557,11629,11710,11555};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_59()
		{
			int[] value = {-1,11559,11630,11629,11557,-1,11646,11642,11630,11647,-1,11676,11673,11642,11646,-1,11690,11687,11673,11676,-1,11560,11707,11687,11690,-1,11563,11708,11707,11560,-1,11685,11688,11708,11563,-1,11672,11674,11688,11685,-1,11641,11643,11674,11672,-1,11548,11631,11643,11641,-1,11551,11628,11631,11548,-1,11553,11709,11628,11551,-1,11555,11710,11709,11553,-1,11711,11712,11569,11577,-1,11650,11648,11712,11711,-1,11712,11713,11558,11569,-1,11648,11644,11713,11712,-1,11713,11714,11559,11558,-1,11644,11647,11714,11713,-1,11715,11711,11577,11585,-1,11652,11650,11711,11715,-1,11716,11715,11585,11593,-1,11654,11652,11715,11716,-1,11717,11716,11593,11601,-1,11656,11654,11716,11717,-1,11718,11717,11601,11609,-1,11658,11656,11717,11718,-1,11719,11718,11609,11617,-1,11660,11658,11718,11719,-1,11714,11630,11559,-1,11714,11647,11630,-1,11719,11617,11625,-1,11625,11660,11719,-1,11720,11721,11722,11723,-1,11721,11720,11724,-1,11725,11723,11722,-1,11726,11727,11723,11725,-1,11728,11729,11727,11726,-1,11730,11731,11729,11728,-1,11732,11733,11731,11730,-1,11734,11735,11733,11732,-1,11736,11737,11735,11734,-1,11738,11739,11737,11736,-1,11740,11741,11739,11738,-1,11742,11743,11741,11740,-1,11744,11745,11746,11747,-1,11748,11749,11750,11751,-1,11752,11753,11749,11748,-1,11754,11755,11753,11752,-1,11756,11757,11755,11754,-1,11758,11759,11757,11756,-1,11760,11761,11759,11758,-1,11762,11763,11761,11760,-1,11764,11765,11763,11762,-1,11724,11720,11765,11764,-1,11723,11727,11765,11720,-1,11729,11731,11761,11763,-1,11731,11733,11759,11761,-1,11741,11743,11750,11749,-1,11749,11753,11739,11741,-1,11753,11755,11737,11739,-1,11733,11735,11757,11759,-1,11735,11737,11755,11757,-1,11727,11729,11763,11765,-1,11750,11745,11744,11751,-1,11743,11746,11745,11750,-1,11742,11747,11746,11743,-1,11766,11767,11768,11769,-1,11767,11770,11771,11768,-1,11770,11772,11773,11771,-1,11772,11774,11775,11773,-1,11774,11776,11777,11775,-1,11776,11778,11779,11777,-1,11778,11780,11781,11779,-1,11780,11782,11783,11781,-1,11782,11784,11785,11783,-1,11769,11786,11787,11766,-1,11740,11788,11789,11742,-1,11738,11790,11788,11740,-1,11736,11791,11790,11738,-1,11734,11792,11791,11736,-1,11732,11793,11792,11734,-1,11730,11794,11793,11732,-1,11728,11795,11794,11730,-1,11726,11796,11795,11728,-1,11725,11797,11796,11726,-1,11722,11798,11797,11725,-1,11721,11799,11798,11722,-1,11724,11800,11799,11721,-1,11764,11801,11800,11724,-1,11762,11802,11801,11764,-1,11760,11803,11802,11762,-1,11758,11804,11803,11760,-1,11756,11805,11804,11758,-1,11754,11806,11805,11756,-1,11752,11807,11806,11754,-1,11748,11808,11807,11752,-1,11751,11809,11808,11748,-1,11747,11810,11811,11744,-1,11788,11783,11785,11789,-1,11790,11781,11783,11788,-1,11791,11779,11781,11790,-1,11792,11777,11779,11791,-1,11793,11775,11777,11792,-1,11794,11773,11775,11793,-1,11795,11771,11773,11794,-1,11796,11768,11771,11795,-1,11797,11769,11768,11796,-1,11798,11786,11769,11797,-1,11799,11787,11786,11798,-1,11800,11766,11787,11799,-1,11801,11767,11766,11800,-1,11802,11770,11767,11801,-1,11803,11772,11770,11802,-1,11804,11774,11772,11803,-1,11805,11776,11774,11804,-1,11806,11778,11776,11805,-1,11807,11780,11778,11806,-1,11808,11782,11780,11807,-1,11809,11784,11782,11808,-1,11810,11812,11813,11811,-1,11809,11811,11813,11784,-1,11751,11744,11811,11809,-1,11789,11810,11747,11742,-1,11785,11812,11810,11789,-1,11784,11813,11812,11785,-1,11814,11815,11816,11817,-1,11818,11817,11816,-1,11815,11814,11819,-1,11819,11814,11820,11821,-1,11821,11820,11822,11823,-1,11823,11822,11824,11825,-1,11825,11824,11826,11827,-1,11827,11826,11828,11829,-1,11829,11828,11830,11831,-1,11831,11830,11832,11833,-1,11833,11832,11834,11835,-1,11835,11834,11836,11837,-1,11838,11839,11840,11841,-1,11842,11843,11844,11845,-1,11845,11844,11846,11847,-1,11847,11846,11848,11849,-1,11849,11848,11850,11851,-1,11851,11850,11852,11853,-1,11853,11852,11854,11855,-1,11855,11854,11856,11857,-1,11857,11856,11858,11859,-1,11859,11858,11817,11818,-1,11817,11858,11820,11814,-1,11856,11854,11824,11822,-1,11854,11852,11826,11824,-1,11844,11843,11836,11834,-1,11834,11832,11846,11844,-1,11832,11830,11848,11846,-1,11852,11850,11828,11826,-1,11850,11848,11830,11828,-1,11858,11856,11822,11820,-1,11842,11841,11840,11843,-1,11843,11840,11839,11836,-1,11836,11839,11838,11837,-1,11860,11861,11862,11863,-1,11861,11864,11865,11862,-1,11864,11866,11867,11865,-1,11866,11868,11869,11867,-1,11868,11870,11871,11869,-1,11870,11872,11873,11871,-1,11872,11874,11875,11873,-1,11874,11876,11877,11875,-1,11876,11878,11879,11877,-1,11863,11880,11881,11860,-1,11837,11882,11883,11835,-1,11835,11883,11884,11833,-1,11833,11884,11885,11831,-1,11831,11885,11886,11829,-1,11829,11886,11887,11827,-1,11827,11887,11888,11825,-1,11825,11888,11889,11823,-1,11823,11889,11890,11821,-1,11821,11890,11891,11819,-1,11819,11891,11892,11815,-1,11815,11892,11893,11816,-1,11816,11893,11894,11818,-1,11818,11894,11895,11859,-1,11859,11895,11896,11857,-1,11857,11896,11897,11855,-1,11855,11897,11898,11853,-1,11853,11898,11899,11851,-1,11851,11899,11900,11849,-1,11849,11900,11901,11847,-1,11847,11901,11902,11845,-1,11845,11902,11903,11842,-1,11841,11904,11905,11838,-1,11882,11878,11876,11883,-1,11883,11876,11874,11884,-1,11884,11874,11872,11885,-1,11885,11872,11870,11886,-1,11886,11870,11868,11887,-1,11887,11868,11866,11888,-1,11888,11866,11864,11889,-1,11889,11864,11861,11890,-1,11890,11861,11860,11891,-1,11891,11860};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_60()
		{
			int[] value = {11881,11892,-1,11892,11881,11880,11893,-1,11893,11880,11863,11894,-1,11894,11863,11862,11895,-1,11895,11862,11865,11896,-1,11896,11865,11867,11897,-1,11897,11867,11869,11898,-1,11898,11869,11871,11899,-1,11899,11871,11873,11900,-1,11900,11873,11875,11901,-1,11901,11875,11877,11902,-1,11902,11877,11879,11903,-1,11904,11906,11907,11905,-1,11879,11906,11904,11903,-1,11903,11904,11841,11842,-1,11837,11838,11905,11882,-1,11882,11905,11907,11878,-1,11878,11907,11906,11879,-1,11908,11909,11910,11911,-1,11912,11911,11910,-1,11909,11908,11913,-1,11913,11908,11914,11915,-1,11915,11914,11916,11917,-1,11917,11916,11918,11919,-1,11919,11918,11920,11921,-1,11921,11920,11922,11923,-1,11923,11922,11924,11925,-1,11925,11924,11926,11927,-1,11927,11926,11928,11929,-1,11929,11928,11930,11931,-1,11932,11933,11934,11935,-1,11936,11937,11938,11939,-1,11939,11938,11940,11941,-1,11941,11940,11942,11943,-1,11943,11942,11944,11945,-1,11945,11944,11946,11947,-1,11947,11946,11948,11949,-1,11949,11948,11950,11951,-1,11951,11950,11952,11953,-1,11953,11952,11911,11912,-1,11911,11952,11914,11908,-1,11950,11948,11918,11916,-1,11948,11946,11920,11918,-1,11938,11937,11930,11928,-1,11928,11926,11940,11938,-1,11926,11924,11942,11940,-1,11946,11944,11922,11920,-1,11944,11942,11924,11922,-1,11952,11950,11916,11914,-1,11936,11935,11934,11937,-1,11937,11934,11933,11930,-1,11930,11933,11932,11931,-1,11954,11955,11956,11957,-1,11955,11958,11959,11956,-1,11958,11960,11961,11959,-1,11960,11962,11963,11961,-1,11962,11964,11965,11963,-1,11964,11966,11967,11965,-1,11966,11968,11969,11967,-1,11968,11970,11971,11969,-1,11970,11972,11973,11971,-1,11957,11974,11975,11954,-1,11931,11976,11977,11929,-1,11929,11977,11978,11927,-1,11927,11978,11979,11925,-1,11925,11979,11980,11923,-1,11923,11980,11981,11921,-1,11921,11981,11982,11919,-1,11919,11982,11983,11917,-1,11917,11983,11984,11915,-1,11915,11984,11985,11913,-1,11913,11985,11986,11909,-1,11909,11986,11987,11910,-1,11910,11987,11988,11912,-1,11912,11988,11989,11953,-1,11953,11989,11990,11951,-1,11951,11990,11991,11949,-1,11949,11991,11992,11947,-1,11947,11992,11993,11945,-1,11945,11993,11994,11943,-1,11943,11994,11995,11941,-1,11941,11995,11996,11939,-1,11939,11996,11997,11936,-1,11935,11998,11999,11932,-1,11976,11972,11970,11977,-1,11977,11970,11968,11978,-1,11978,11968,11966,11979,-1,11979,11966,11964,11980,-1,11980,11964,11962,11981,-1,11981,11962,11960,11982,-1,11982,11960,11958,11983,-1,11983,11958,11955,11984,-1,11984,11955,11954,11985,-1,11985,11954,11975,11986,-1,11986,11975,11974,11987,-1,11987,11974,11957,11988,-1,11988,11957,11956,11989,-1,11989,11956,11959,11990,-1,11990,11959,11961,11991,-1,11991,11961,11963,11992,-1,11992,11963,11965,11993,-1,11993,11965,11967,11994,-1,11994,11967,11969,11995,-1,11995,11969,11971,11996,-1,11996,11971,11973,11997,-1,11998,12000,12001,11999,-1,11973,12000,11998,11997,-1,11997,11998,11935,11936,-1,11931,11932,11999,11976,-1,11976,11999,12001,11972,-1,11972,12001,12000,11973,-1,12002,12003,12004,12005,-1,12006,12007,12008,12009,-1,12010,12011,12012,12013,-1,12014,12015,12016,12017,-1,12018,12019,12020,12021,-1,12021,12020,12022,12023,-1,12023,12022,12024,12025,-1,12025,12024,12026,12027,-1,12027,12026,12028,12029,-1,12029,12028,12030,12031,-1,12031,12030,12032,12033,-1,12033,12032,12034,12035,-1,12035,12034,12036,12037,-1,12037,12036,12038,12039,-1,12039,12038,12040,12041,-1,12041,12040,12042,12043,-1,12043,12042,12044,12045,-1,12045,12044,12046,12047,-1,12047,12046,12048,12049,-1,12049,12048,12050,12051,-1,12051,12050,12052,12053,-1,12053,12052,12054,12055,-1,12055,12054,12056,12057,-1,12057,12056,12058,12059,-1,12059,12058,12060,12061,-1,12061,12060,12019,12018,-1,12019,12062,12063,12020,-1,12020,12063,12064,12022,-1,12022,12064,12065,12024,-1,12024,12065,12066,12026,-1,12026,12066,12067,12028,-1,12028,12067,12005,12030,-1,12030,12005,12004,12032,-1,12032,12004,12068,12034,-1,12034,12068,12069,12036,-1,12036,12069,12070,12038,-1,12038,12070,12071,12040,-1,12040,12071,12072,12042,-1,12042,12072,12073,12044,-1,12044,12073,12074,12046,-1,12046,12074,12075,12048,-1,12048,12075,12003,12050,-1,12050,12003,12002,12052,-1,12052,12002,12076,12054,-1,12054,12076,12077,12056,-1,12056,12077,12078,12058,-1,12058,12078,12079,12060,-1,12060,12079,12062,12019,-1,12073,12072,12071,12070,-1,12075,12074,12069,12068,-1,12070,12069,12074,12073,-1,12003,12075,12068,12004,-1,12067,12066,12077,12076,-1,12076,12002,12005,12067,-1,12065,12064,12079,12078,-1,12078,12077,12066,12065,-1,12064,12063,12062,12079,-1,12017,12016,12080,12081,-1,12013,12012,12081,12080,-1,12009,12008,12082,12083,-1,12015,12014,12083,12082,-1,12084,12085,12086,12087,-1,12007,12006,12087,12086,-1,12088,12089,12085,12084,-1,12021,12089,12088,12018,-1,12018,12088,12084,12061,-1,12061,12084,12087,12059,-1,12059,12087,12006,12057,-1,12057,12006,12009,12055,-1,12055,12009,12083,12053,-1,12053,12083,12014,12051,-1,12051,12014,12017,12049,-1,12049,12017,12081,12047,-1,12047,12081,12012,12045,-1,12045,12012,12011,12043,-1,12043,12011,12010,12041,-1,12041,12010,12013,12039,-1,12039,12013,12080,12037,-1,12037,12080,12016,12035,-1,12035,12016,12015,12033,-1,12033,12015,12082,12031,-1,12031,12082,12008,12029,-1,12029,12008,12007,12027,-1,12027,12007,12086,12025,-1,12025,12086,12085,12023,-1,12023,12085,12089,12021,-1,12090,12091,12092,12093,-1,12094,12095,12096,12097,-1,12098,12099,12100,12101,-1,12102,12103,12104,12105};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_61()
		{
			int[] value = {-1,12106,12107,12108,12109,-1,12110,12111,12107,12106,-1,12112,12113,12111,12110,-1,12114,12115,12113,12112,-1,12116,12117,12115,12114,-1,12118,12119,12117,12116,-1,12120,12121,12119,12118,-1,12122,12123,12121,12120,-1,12124,12125,12123,12122,-1,12126,12127,12125,12124,-1,12128,12129,12127,12126,-1,12130,12131,12129,12128,-1,12132,12133,12131,12130,-1,12134,12135,12133,12132,-1,12136,12137,12135,12134,-1,12138,12139,12137,12136,-1,12140,12141,12139,12138,-1,12142,12143,12141,12140,-1,12144,12145,12143,12142,-1,12146,12147,12145,12144,-1,12148,12149,12147,12146,-1,12109,12108,12149,12148,-1,12107,12150,12151,12108,-1,12111,12152,12150,12107,-1,12113,12153,12152,12111,-1,12115,12154,12153,12113,-1,12117,12155,12154,12115,-1,12119,12090,12155,12117,-1,12121,12091,12090,12119,-1,12123,12156,12091,12121,-1,12125,12157,12156,12123,-1,12127,12158,12157,12125,-1,12129,12159,12158,12127,-1,12131,12160,12159,12129,-1,12133,12161,12160,12131,-1,12135,12162,12161,12133,-1,12137,12163,12162,12135,-1,12139,12092,12163,12137,-1,12141,12093,12092,12139,-1,12143,12164,12093,12141,-1,12145,12165,12164,12143,-1,12147,12166,12165,12145,-1,12149,12167,12166,12147,-1,12108,12151,12167,12149,-1,12158,12159,12160,12161,-1,12156,12157,12162,12163,-1,12161,12162,12157,12158,-1,12091,12156,12163,12092,-1,12164,12165,12154,12155,-1,12155,12090,12093,12164,-1,12166,12167,12152,12153,-1,12153,12154,12165,12166,-1,12167,12151,12150,12152,-1,12168,12169,12103,12102,-1,12169,12168,12099,12098,-1,12170,12171,12095,12094,-1,12171,12170,12105,12104,-1,12172,12173,12174,12175,-1,12173,12172,12097,12096,-1,12175,12174,12176,12177,-1,12109,12177,12176,12106,-1,12148,12175,12177,12109,-1,12146,12172,12175,12148,-1,12144,12097,12172,12146,-1,12142,12094,12097,12144,-1,12140,12170,12094,12142,-1,12138,12105,12170,12140,-1,12136,12102,12105,12138,-1,12134,12168,12102,12136,-1,12132,12099,12168,12134,-1,12130,12100,12099,12132,-1,12128,12101,12100,12130,-1,12126,12098,12101,12128,-1,12124,12169,12098,12126,-1,12122,12103,12169,12124,-1,12120,12104,12103,12122,-1,12118,12171,12104,12120,-1,12116,12095,12171,12118,-1,12114,12096,12095,12116,-1,12112,12173,12096,12114,-1,12110,12174,12173,12112,-1,12106,12176,12174,12110,-1,12178,12179,12180,12181,-1,12181,12180,12182,12183,-1,12183,12182,12184,12185,-1,12185,12184,12186,12187,-1,12187,12186,12188,12189,-1,12190,12191,12192,12193,-1,12179,12194,12195,12180,-1,12180,12195,12196,12182,-1,12182,12196,12197,12184,-1,12184,12197,12198,12186,-1,12186,12198,12199,12188,-1,12191,12200,12201,12192,-1,12194,12202,12203,12195,-1,12195,12203,12204,12196,-1,12196,12204,12205,12197,-1,12197,12205,12206,12198,-1,12198,12206,12207,12199,-1,12200,12208,12209,12201,-1,12202,12210,12211,12203,-1,12203,12211,12212,12204,-1,12204,12212,12213,12205,-1,12205,12213,12214,12206,-1,12206,12214,12215,12207,-1,12208,12216,12217,12209,-1,12210,12218,12219,12211,-1,12211,12219,12220,12212,-1,12212,12220,12221,12213,-1,12213,12221,12222,12214,-1,12214,12222,12223,12215,-1,12216,12224,12225,12217,-1,12218,12226,12227,12219,-1,12219,12227,12228,12220,-1,12220,12228,12229,12221,-1,12221,12229,12230,12222,-1,12222,12230,12231,12223,-1,12224,12232,12233,12225,-1,12226,12234,12235,12227,-1,12227,12235,12236,12228,-1,12228,12236,12237,12229,-1,12229,12237,12238,12230,-1,12230,12238,12239,12231,-1,12232,12240,12241,12233,-1,12234,12242,12243,12235,-1,12235,12243,12244,12236,-1,12236,12244,12245,12237,-1,12237,12245,12246,12238,-1,12238,12246,12247,12239,-1,12240,12248,12249,12241,-1,12242,12250,12251,12243,-1,12243,12251,12252,12244,-1,12244,12252,12253,12245,-1,12245,12253,12254,12246,-1,12246,12254,12255,12247,-1,12248,12256,12257,12249,-1,12258,12259,12260,12261,-1,12254,12253,12252,12251,-1,12242,12262,12263,12250,-1,12234,12264,12262,12242,-1,12226,12265,12264,12234,-1,12218,12266,12265,12226,-1,12210,12267,12266,12218,-1,12202,12268,12267,12210,-1,12194,12269,12268,12202,-1,12179,12270,12269,12194,-1,12178,12271,12270,12179,-1,12260,12272,12273,12261,-1,12274,12275,12276,12277,-1,12278,12279,12275,12274,-1,12280,12281,12279,12278,-1,12282,12283,12281,12280,-1,12284,12285,12283,12282,-1,12286,12287,12285,12284,-1,12288,12289,12287,12286,-1,12290,12291,12289,12288,-1,12255,12292,12291,12290,-1,12250,12263,12292,12255,-1,12262,12293,12294,12263,-1,12264,12295,12293,12262,-1,12265,12296,12295,12264,-1,12266,12297,12296,12265,-1,12267,12298,12297,12266,-1,12268,12299,12298,12267,-1,12269,12300,12299,12268,-1,12270,12301,12300,12269,-1,12271,12302,12301,12270,-1,12272,12303,12304,12273,-1,12275,12305,12306,12276,-1,12279,12307,12305,12275,-1,12281,12308,12307,12279,-1,12283,12309,12308,12281,-1,12285,12310,12309,12283,-1,12287,12311,12310,12285,-1,12289,12312,12311,12287,-1,12291,12313,12312,12289,-1,12292,12314,12313,12291,-1,12263,12294,12314,12292,-1,12302,12315,12316,12301,-1,12303,12317,12318,12304,-1,12305,12319,12320,12306,-1,12307,12321,12319,12305,-1,12308,12322,12321,12307,-1,12309,12323,12322,12308,-1,12310,12324,12323,12309,-1,12311,12325,12324,12310,-1,12312,12326,12325,12311,-1,12313,12327,12326,12312,-1,12314,12328,12327,12313,-1,12294,12329,12328,12314,-1,12293,12330,12329,12294,-1,12295,12331,12330,12293,-1,12296,12332,12331,12295,-1,12297,12333,12332,12296,-1,12298,12334,12333,12297,-1,12299,12335,12334,12298,-1,12300,12336,12335,12299,-1,12301,12316,12336,12300,-1,12315,12193,12192,12316,-1,12317,12337,12338,12318};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_62()
		{
			int[] value = {-1,12319,12191,12190,12320,-1,12321,12200,12191,12319,-1,12322,12208,12200,12321,-1,12323,12216,12208,12322,-1,12324,12224,12216,12323,-1,12325,12232,12224,12324,-1,12326,12240,12232,12325,-1,12327,12248,12240,12326,-1,12328,12256,12248,12327,-1,12329,12257,12256,12328,-1,12330,12249,12257,12329,-1,12331,12241,12249,12330,-1,12332,12233,12241,12331,-1,12333,12225,12233,12332,-1,12334,12217,12225,12333,-1,12335,12209,12217,12334,-1,12336,12201,12209,12335,-1,12316,12192,12201,12336,-1,12251,12250,12255,12254,-1,12258,12339,12340,12259,-1,12187,12259,12340,12185,-1,12189,12260,12259,12187,-1,12276,12272,12260,12277,-1,12306,12303,12272,12276,-1,12320,12317,12303,12306,-1,12190,12337,12317,12320,-1,12193,12338,12337,12190,-1,12315,12318,12338,12193,-1,12302,12304,12318,12315,-1,12271,12273,12304,12302,-1,12178,12261,12273,12271,-1,12181,12258,12261,12178,-1,12183,12339,12258,12181,-1,12185,12340,12339,12183,-1,12341,12342,12199,12207,-1,12280,12278,12342,12341,-1,12342,12343,12188,12199,-1,12278,12274,12343,12342,-1,12343,12344,12189,12188,-1,12274,12277,12344,12343,-1,12345,12341,12207,12215,-1,12282,12280,12341,12345,-1,12346,12345,12215,12223,-1,12284,12282,12345,12346,-1,12347,12346,12223,12231,-1,12286,12284,12346,12347,-1,12348,12347,12231,12239,-1,12288,12286,12347,12348,-1,12349,12348,12239,12247,-1,12290,12288,12348,12349,-1,12344,12260,12189,-1,12344,12277,12260,-1,12349,12247,12255,-1,12255,12290,12349,-1,12350,12351,12352,12353,-1,12351,12350,12354,-1,12355,12353,12352,-1,12356,12357,12353,12355,-1,12358,12359,12357,12356,-1,12360,12361,12359,12358,-1,12362,12363,12361,12360,-1,12364,12365,12363,12362,-1,12366,12367,12365,12364,-1,12368,12369,12367,12366,-1,12370,12371,12369,12368,-1,12372,12373,12371,12370,-1,12374,12375,12376,12377,-1,12378,12379,12380,12381,-1,12382,12383,12379,12378,-1,12384,12385,12383,12382,-1,12386,12387,12385,12384,-1,12388,12389,12387,12386,-1,12390,12391,12389,12388,-1,12392,12393,12391,12390,-1,12394,12395,12393,12392,-1,12354,12350,12395,12394,-1,12353,12357,12395,12350,-1,12359,12361,12391,12393,-1,12361,12363,12389,12391,-1,12371,12373,12380,12379,-1,12379,12383,12369,12371,-1,12383,12385,12367,12369,-1,12363,12365,12387,12389,-1,12365,12367,12385,12387,-1,12357,12359,12393,12395,-1,12380,12375,12374,12381,-1,12373,12376,12375,12380,-1,12372,12377,12376,12373,-1,12396,12397,12398,12399,-1,12397,12400,12401,12398,-1,12400,12402,12403,12401,-1,12402,12404,12405,12403,-1,12404,12406,12407,12405,-1,12406,12408,12409,12407,-1,12408,12410,12411,12409,-1,12410,12412,12413,12411,-1,12412,12414,12415,12413,-1,12399,12416,12417,12396,-1,12370,12418,12419,12372,-1,12368,12420,12418,12370,-1,12366,12421,12420,12368,-1,12364,12422,12421,12366,-1,12362,12423,12422,12364,-1,12360,12424,12423,12362,-1,12358,12425,12424,12360,-1,12356,12426,12425,12358,-1,12355,12427,12426,12356,-1,12352,12428,12427,12355,-1,12351,12429,12428,12352,-1,12354,12430,12429,12351,-1,12394,12431,12430,12354,-1,12392,12432,12431,12394,-1,12390,12433,12432,12392,-1,12388,12434,12433,12390,-1,12386,12435,12434,12388,-1,12384,12436,12435,12386,-1,12382,12437,12436,12384,-1,12378,12438,12437,12382,-1,12381,12439,12438,12378,-1,12377,12440,12441,12374,-1,12418,12413,12415,12419,-1,12420,12411,12413,12418,-1,12421,12409,12411,12420,-1,12422,12407,12409,12421,-1,12423,12405,12407,12422,-1,12424,12403,12405,12423,-1,12425,12401,12403,12424,-1,12426,12398,12401,12425,-1,12427,12399,12398,12426,-1,12428,12416,12399,12427,-1,12429,12417,12416,12428,-1,12430,12396,12417,12429,-1,12431,12397,12396,12430,-1,12432,12400,12397,12431,-1,12433,12402,12400,12432,-1,12434,12404,12402,12433,-1,12435,12406,12404,12434,-1,12436,12408,12406,12435,-1,12437,12410,12408,12436,-1,12438,12412,12410,12437,-1,12439,12414,12412,12438,-1,12440,12442,12443,12441,-1,12439,12441,12443,12414,-1,12381,12374,12441,12439,-1,12419,12440,12377,12372,-1,12415,12442,12440,12419,-1,12414,12443,12442,12415,-1,12444,12445,12446,12447,-1,12448,12447,12446,-1,12445,12444,12449,-1,12449,12444,12450,12451,-1,12451,12450,12452,12453,-1,12453,12452,12454,12455,-1,12455,12454,12456,12457,-1,12457,12456,12458,12459,-1,12459,12458,12460,12461,-1,12461,12460,12462,12463,-1,12463,12462,12464,12465,-1,12465,12464,12466,12467,-1,12468,12469,12470,12471,-1,12472,12473,12474,12475,-1,12475,12474,12476,12477,-1,12477,12476,12478,12479,-1,12479,12478,12480,12481,-1,12481,12480,12482,12483,-1,12483,12482,12484,12485,-1,12485,12484,12486,12487,-1,12487,12486,12488,12489,-1,12489,12488,12447,12448,-1,12447,12488,12450,12444,-1,12486,12484,12454,12452,-1,12484,12482,12456,12454,-1,12474,12473,12466,12464,-1,12464,12462,12476,12474,-1,12462,12460,12478,12476,-1,12482,12480,12458,12456,-1,12480,12478,12460,12458,-1,12488,12486,12452,12450,-1,12472,12471,12470,12473,-1,12473,12470,12469,12466,-1,12466,12469,12468,12467,-1,12490,12491,12492,12493,-1,12491,12494,12495,12492,-1,12494,12496,12497,12495,-1,12496,12498,12499,12497,-1,12498,12500,12501,12499,-1,12500,12502,12503,12501,-1,12502,12504,12505,12503,-1,12504,12506,12507,12505,-1,12506,12508,12509,12507,-1,12493,12510,12511,12490,-1,12467,12512,12513,12465,-1,12465,12513,12514,12463,-1,12463,12514,12515,12461,-1,12461,12515,12516,12459,-1,12459,12516,12517,12457,-1,12457,12517,12518,12455,-1,12455,12518,12519,12453,-1,12453,12519,12520,12451,-1,12451,12520,12521,12449,-1,12449,12521,12522,12445,-1,12445,12522};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_63()
		{
			int[] value = {12523,12446,-1,12446,12523,12524,12448,-1,12448,12524,12525,12489,-1,12489,12525,12526,12487,-1,12487,12526,12527,12485,-1,12485,12527,12528,12483,-1,12483,12528,12529,12481,-1,12481,12529,12530,12479,-1,12479,12530,12531,12477,-1,12477,12531,12532,12475,-1,12475,12532,12533,12472,-1,12471,12534,12535,12468,-1,12512,12508,12506,12513,-1,12513,12506,12504,12514,-1,12514,12504,12502,12515,-1,12515,12502,12500,12516,-1,12516,12500,12498,12517,-1,12517,12498,12496,12518,-1,12518,12496,12494,12519,-1,12519,12494,12491,12520,-1,12520,12491,12490,12521,-1,12521,12490,12511,12522,-1,12522,12511,12510,12523,-1,12523,12510,12493,12524,-1,12524,12493,12492,12525,-1,12525,12492,12495,12526,-1,12526,12495,12497,12527,-1,12527,12497,12499,12528,-1,12528,12499,12501,12529,-1,12529,12501,12503,12530,-1,12530,12503,12505,12531,-1,12531,12505,12507,12532,-1,12532,12507,12509,12533,-1,12534,12536,12537,12535,-1,12509,12536,12534,12533,-1,12533,12534,12471,12472,-1,12467,12468,12535,12512,-1,12512,12535,12537,12508,-1,12508,12537,12536,12509,-1,12538,12539,12540,12541,-1,12542,12541,12540,-1,12539,12538,12543,-1,12543,12538,12544,12545,-1,12545,12544,12546,12547,-1,12547,12546,12548,12549,-1,12549,12548,12550,12551,-1,12551,12550,12552,12553,-1,12553,12552,12554,12555,-1,12555,12554,12556,12557,-1,12557,12556,12558,12559,-1,12559,12558,12560,12561,-1,12562,12563,12564,12565,-1,12566,12567,12568,12569,-1,12569,12568,12570,12571,-1,12571,12570,12572,12573,-1,12573,12572,12574,12575,-1,12575,12574,12576,12577,-1,12577,12576,12578,12579,-1,12579,12578,12580,12581,-1,12581,12580,12582,12583,-1,12583,12582,12541,12542,-1,12541,12582,12544,12538,-1,12580,12578,12548,12546,-1,12578,12576,12550,12548,-1,12568,12567,12560,12558,-1,12558,12556,12570,12568,-1,12556,12554,12572,12570,-1,12576,12574,12552,12550,-1,12574,12572,12554,12552,-1,12582,12580,12546,12544,-1,12566,12565,12564,12567,-1,12567,12564,12563,12560,-1,12560,12563,12562,12561,-1,12584,12585,12586,12587,-1,12585,12588,12589,12586,-1,12588,12590,12591,12589,-1,12590,12592,12593,12591,-1,12592,12594,12595,12593,-1,12594,12596,12597,12595,-1,12596,12598,12599,12597,-1,12598,12600,12601,12599,-1,12600,12602,12603,12601,-1,12587,12604,12605,12584,-1,12561,12606,12607,12559,-1,12559,12607,12608,12557,-1,12557,12608,12609,12555,-1,12555,12609,12610,12553,-1,12553,12610,12611,12551,-1,12551,12611,12612,12549,-1,12549,12612,12613,12547,-1,12547,12613,12614,12545,-1,12545,12614,12615,12543,-1,12543,12615,12616,12539,-1,12539,12616,12617,12540,-1,12540,12617,12618,12542,-1,12542,12618,12619,12583,-1,12583,12619,12620,12581,-1,12581,12620,12621,12579,-1,12579,12621,12622,12577,-1,12577,12622,12623,12575,-1,12575,12623,12624,12573,-1,12573,12624,12625,12571,-1,12571,12625,12626,12569,-1,12569,12626,12627,12566,-1,12565,12628,12629,12562,-1,12606,12602,12600,12607,-1,12607,12600,12598,12608,-1,12608,12598,12596,12609,-1,12609,12596,12594,12610,-1,12610,12594,12592,12611,-1,12611,12592,12590,12612,-1,12612,12590,12588,12613,-1,12613,12588,12585,12614,-1,12614,12585,12584,12615,-1,12615,12584,12605,12616,-1,12616,12605,12604,12617,-1,12617,12604,12587,12618,-1,12618,12587,12586,12619,-1,12619,12586,12589,12620,-1,12620,12589,12591,12621,-1,12621,12591,12593,12622,-1,12622,12593,12595,12623,-1,12623,12595,12597,12624,-1,12624,12597,12599,12625,-1,12625,12599,12601,12626,-1,12626,12601,12603,12627,-1,12628,12630,12631,12629,-1,12603,12630,12628,12627,-1,12627,12628,12565,12566,-1,12561,12562,12629,12606,-1,12606,12629,12631,12602,-1,12602,12631,12630,12603,-1,12632,12633,12634,12635,-1,12636,12637,12638,12639,-1,12640,12641,12642,12643,-1,12644,12645,12646,12647,-1,12648,12649,12650,12651,-1,12651,12650,12652,12653,-1,12653,12652,12654,12655,-1,12655,12654,12656,12657,-1,12657,12656,12658,12659,-1,12659,12658,12660,12661,-1,12661,12660,12662,12663,-1,12663,12662,12664,12665,-1,12665,12664,12666,12667,-1,12667,12666,12668,12669,-1,12669,12668,12670,12671,-1,12671,12670,12672,12673,-1,12673,12672,12674,12675,-1,12675,12674,12676,12677,-1,12677,12676,12678,12679,-1,12679,12678,12680,12681,-1,12681,12680,12682,12683,-1,12683,12682,12684,12685,-1,12685,12684,12686,12687,-1,12687,12686,12688,12689,-1,12689,12688,12690,12691,-1,12691,12690,12649,12648,-1,12649,12692,12693,12650,-1,12650,12693,12694,12652,-1,12652,12694,12695,12654,-1,12654,12695,12696,12656,-1,12656,12696,12697,12658,-1,12658,12697,12635,12660,-1,12660,12635,12634,12662,-1,12662,12634,12698,12664,-1,12664,12698,12699,12666,-1,12666,12699,12700,12668,-1,12668,12700,12701,12670,-1,12670,12701,12702,12672,-1,12672,12702,12703,12674,-1,12674,12703,12704,12676,-1,12676,12704,12705,12678,-1,12678,12705,12633,12680,-1,12680,12633,12632,12682,-1,12682,12632,12706,12684,-1,12684,12706,12707,12686,-1,12686,12707,12708,12688,-1,12688,12708,12709,12690,-1,12690,12709,12692,12649,-1,12703,12702,12701,12700,-1,12705,12704,12699,12698,-1,12700,12699,12704,12703,-1,12633,12705,12698,12634,-1,12697,12696,12707,12706,-1,12706,12632,12635,12697,-1,12695,12694,12709,12708,-1,12708,12707,12696,12695,-1,12694,12693,12692,12709,-1,12647,12646,12710,12711,-1,12643,12642,12711,12710,-1,12639,12638,12712,12713,-1,12645,12644,12713,12712,-1,12714,12715,12716,12717,-1,12637,12636,12717,12716,-1,12718,12719,12715,12714,-1,12651,12719,12718,12648,-1,12648,12718,12714,12691,-1,12691,12714,12717,12689,-1,12689,12717,12636,12687,-1,12687,12636,12639,12685};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_64()
		{
			int[] value = {-1,12685,12639,12713,12683,-1,12683,12713,12644,12681,-1,12681,12644,12647,12679,-1,12679,12647,12711,12677,-1,12677,12711,12642,12675,-1,12675,12642,12641,12673,-1,12673,12641,12640,12671,-1,12671,12640,12643,12669,-1,12669,12643,12710,12667,-1,12667,12710,12646,12665,-1,12665,12646,12645,12663,-1,12663,12645,12712,12661,-1,12661,12712,12638,12659,-1,12659,12638,12637,12657,-1,12657,12637,12716,12655,-1,12655,12716,12715,12653,-1,12653,12715,12719,12651,-1,10980,10982,10690,10689,10626,10625,-1,11125,10986,10988,-1,10982,11096,10687,10688,10690,-1,11096,11091,11090,10686,10687,-1,11096,11095,11092,11091,-1,11095,11094,11089,11093,11092,-1,11079,11078,10986,-1,11078,11088,10983,10986,-1,11078,11082,11087,11088,-1,11082,11083,11084,11087,-1,11084,11085,11086,11087,-1,11021,10949,10948,-1,11125,11081,11080,11079,10986,-1,10624,12720,12721,10621,-1,10640,10639,12737,12738,-1,10639,10621,12721,12737,-1,12739,12740,12741,12742,-1,12743,5089,5090,12744,-1,12745,12746,12739,12742,-1,12740,12747,12748,12749,-1,12750,12751,12749,12748,-1,12751,12750,12752,12753,-1,12753,12752,12754,12755,-1,12743,12744,12755,12754,-1,12756,12757,12758,-1,12759,12760,12761,12762,-1,12762,12761,12763,12764,-1,12765,12766,12767,12768,-1,12768,12767,12769,12770,-1,12770,12769,12771,12772,-1,12773,12774,12772,12771,-1,12774,12773,12775,12776,-1,12776,12775,12756,12758,-1,12777,12778,12779,12780,-1,12778,12777,12781,-1,12746,12745,12782,-1,12739,12747,12740,-1,12742,12741,12783,-1,12745,12742,12783,12784,-1,12782,12745,12784,12785,-1,12785,12786,12787,-1,12787,12788,12785,-1,12789,12790,12760,12759,-1,12780,12779,12790,12789,-1,12738,12737,12791,12792,-1,12737,12721,12793,12791,-1,12721,12720,12794,12793,-1,12795,12796,12764,12763,-1,12766,12765,12796,12795,-1,12797,12798,12799,-1,12797,12800,12798,-1,12801,12802,12803,12804,-1,12805,12806,12802,12801,-1,12799,12806,12805,12797,-1,12805,12807,12797,-1,12810,12775,12773,12811,-1,12814,12813,12812,12815,-1,5130,5129,12767,12766,-1,12818,12815,12816,-1,5131,12817,12804,12803,12819,-1,12771,12769,5125,12809,-1,12820,12821,12822,12823,-1,12824,12825,12822,12821,-1,12826,12827,12828,12829,-1,12830,12798,12831,12832,-1,12833,12834,12835,12836,-1,12837,12838,12835,12834,-1,10796,10795,12839,12840,-1,12736,12841,5143,5024,-1,12810,12845,12756,12775,-1,12823,12739,12746,12820,-1,12846,12847,12848,12849,-1,12779,12778,5149,12850,-1,5150,12851,12763,12761,-1,12852,12853,12854,12855,-1,12856,12857,12858,12859,-1,12860,12861,12862,-1,12862,12861,5014,12722,-1,5152,5131,12819,12863,-1,12864,12830,12832,12865,-1,12824,12828,12827,12825,-1,12769,12767,5129,5125,-1,5158,5014,12861,12866,-1,12867,12858,12857,12868,-1,12868,12869,12870,12867,-1,12866,12871,5159,5158,-1,12788,12820,12746,12782,-1,12735,12821,12820,12788,12787,-1,12734,12824,12821,12735,-1,12733,12828,12824,12734,-1,12732,12829,12828,12733,-1,12729,12855,12854,12730,-1,12726,12725,12847,12846,-1,12724,12832,12831,12847,12725,-1,12723,12865,12832,12724,-1,12872,12857,12856,5165,-1,12873,12868,12857,12872,-1,12874,12869,12868,12873,-1,12875,12834,12833,5166,-1,12876,12837,12834,12875,-1,4216,10796,12840,5167,-1,12798,12830,12877,12799,-1,12864,12878,12877,12830,-1,12858,12879,12880,12859,-1,12867,12881,12879,12858,-1,12870,12882,12881,12867,-1,12835,12883,12884,12836,-1,12838,12885,12883,12835,-1,10795,10907,12886,12839,-1,12887,12848,12798,12800,-1,12877,12888,12806,12799,-1,12878,12889,12888,12877,-1,12879,12890,12891,12880,-1,12881,12892,12890,12879,-1,12882,12893,12892,12881,-1,12883,12894,12895,12884,-1,12885,12896,12894,12883,-1,10907,10640,12738,12886,-1,5180,12897,12807,12805,-1,12841,12898,5183,5143,-1,12900,12749,12751,12901,-1,12823,12902,12903,12739,-1,12822,12904,12902,12823,-1,12825,12905,12904,12822,-1,12827,12906,12905,12825,-1,12826,12907,12906,12827,-1,12852,12908,12909,12853,-1,12849,12848,12887,12910,-1,12898,12811,12911,5183,-1,12903,12757,12756,12845,12913,-1,12902,12758,12757,12903,-1,12904,12774,12776,12902,-1,12914,12770,12772,12915,-1,12916,12768,12770,12914,-1,12917,12765,12768,12916,-1,12918,12762,12764,12919,-1,12920,12921,12777,12780,-1,12899,12922,12755,12744,-1,12749,12900,12741,12740,-1,12913,12750,12748,12903,-1,12923,5173,5172,12781,-1,12800,12923,12781,12887,-1,12798,12848,12847,12831,-1,12805,12801,12924,5180,-1,12888,12925,12802,12806,-1,12889,12926,12925,12888,-1,12890,12927,12928,12891,-1,12892,12929,12927,12890,-1,12893,12930,12929,12892,-1,12894,12931,12932,12895,-1,12896,12933,12931,12894,-1,12801,12804,12817,12924,-1,12925,12819,12803,12802,-1,12926,12863,12819,12925,-1,12927,12861,12860,12928,-1,12929,12866,12861,12927,-1,12930,12871,12866,12929,-1,12931,12815,12818,12932,-1,12933,12814,12815,12931,-1,5199,5150,12761,12760,-1,12759,12762,12918,12934,-1,12935,12908,12852,12936,-1,12936,12852,12855,12937,-1,12937,12855,12729,12728,-1,5172,5149,12778,12781,-1,12811,12809,12808,12911,-1,12773,12771,12809,12811,-1,12904,12915,12772,12774,-1,12905,12914,12915,12904,-1,12906,12916,12914,12905,-1,12907,12917,12916,12906,-1,12908,12918,12919,12909,-1,12935,12934,12918,12908,-1,12887,12921,12920,12910,-1,12781,12777,12921,12887,-1,12736,5212,12938,12841,-1,12939,12940,5212,12736,-1,12941,12942,12940,12939,-1,12751,12753,12943,12901,-1,12913,12944,12752,12750,-1,12845,12945,12944,12913,-1,12810,5213,12945,12845,-1,12811,5214,5213,12810,-1,12898,12946,5214,12811};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_65()
		{
			int[] value = {-1,12841,12938,12946,12898,-1,12942,12843,12842,12940,-1,12753,12755,12922,12943,-1,12944,12947,12754,12752,-1,12945,12912,12947,12944,-1,5213,5188,12912,12945,-1,12912,5089,12743,12947,-1,12947,12743,12754,-1,12747,12903,12748,-1,12903,12747,12739,-1,12902,12776,12758,-1,12899,12844,12948,-1,12788,12782,12785,-1,12741,12900,12949,12783,-1,12950,12949,12900,12901,-1,12901,12943,12951,12950,-1,12943,12922,12952,12951,-1,12948,12952,12922,12899,-1,12953,12948,12844,12843,-1,12954,12953,12843,12942,-1,12955,12954,12942,12941,-1,12923,12800,12797,-1,12956,12790,12779,12850,-1,5199,12760,12790,12956,-1,12789,12957,12920,12780,-1,12759,12934,12957,12789,-1,12958,12727,12726,12846,-1,12937,12728,12727,12958,-1,12959,12958,12846,12849,-1,12936,12937,12958,12959,-1,12960,12959,12849,12910,-1,12935,12936,12959,12960,-1,12960,12957,12934,12935,-1,12910,12920,12957,12960,-1,12961,12962,12818,12816,-1,5159,12871,12962,12961,-1,12963,12962,12871,12930,-1,12932,12818,12962,12963,-1,12964,12965,12869,12874,-1,5166,12833,12965,12964,-1,12966,12965,12833,12836,-1,12870,12869,12965,12966,-1,12966,12967,12882,12870,-1,12836,12884,12967,12966,-1,12967,12968,12893,12882,-1,12884,12895,12968,12967,-1,12968,12963,12930,12893,-1,12895,12932,12963,12968,-1,12797,5223,5173,12923,-1,12807,12897,5223,12797,-1,12792,12791,12933,12896,-1,12969,12792,12896,12885,-1,12886,12738,12792,12969,-1,12970,12969,12885,12838,-1,12839,12886,12969,12970,-1,12971,12970,12838,12837,-1,12840,12839,12970,12971,-1,12972,12971,12837,12876,-1,5167,12840,12971,12972,-1,12791,12793,12814,12933,-1,12793,12794,12813,12814,-1,12973,12974,12926,12889,-1,12891,12928,12974,12973,-1,12975,12973,12889,12878,-1,12880,12891,12973,12975,-1,12976,12975,12878,12864,-1,12859,12880,12975,12976,-1,12976,12977,12856,12859,-1,12864,12865,12977,12976,-1,12978,12977,12865,12723,-1,5165,12856,12977,12978,-1,12974,12979,12863,12926,-1,12928,12860,12979,12974,-1,12980,12979,12860,12862,-1,5152,12863,12979,12980,-1,12981,12982,12917,12907,-1,12909,12919,12982,12981,-1,12983,12981,12907,12826,-1,12853,12909,12981,12983,-1,12984,12983,12826,12829,-1,12854,12853,12983,12984,-1,12731,12984,12829,12732,-1,12730,12854,12984,12731,-1,12982,12796,12765,12917,-1,12919,12764,12796,12982,-1,12795,5229,5130,12766,-1,12763,12851,5229,12795,-1,12736,12735,12787,12786,12941,12939,-1,12786,12785,12784,12955,12941,-1,12784,12783,12949,12950,12955,-1,12950,12951,12954,12955,-1,12951,12952,12948,12953,12954,-1,12985,12986,12987,12988,-1,12989,12990,12991,12992,-1,12993,12994,12991,12990,-1,12995,12996,12997,12998,-1,12999,10735,10734,13000,-1,13001,13002,13003,13004,-1,13004,13003,13005,-1,13006,13007,12986,12985,-1,13008,13009,10753,10752,-1,13010,13011,13012,13013,-1,13014,13015,13011,13010,-1,13016,13017,13018,13019,-1,13020,13021,13022,13023,-1,13024,13025,13026,13027,-1,13028,13029,13030,13031,-1,13032,13033,13029,13028,-1,13034,13035,13036,13037,-1,13038,13039,13040,13041,-1,13042,13043,13044,13045,-1,13046,13047,13048,13049,-1,13050,13031,13030,13051,-1,12997,12996,13052,13053,-1,13054,10849,10735,12999,-1,13055,10853,10852,13056,-1,13057,13058,13059,13060,-1,13037,13061,13062,13034,-1,12989,13063,13064,12990,-1,12990,13064,13065,12993,-1,13023,13066,13067,13020,-1,13007,13068,13069,12986,-1,12986,13069,13070,12987,-1,13058,13071,13072,13059,-1,13024,13048,13047,13025,-1,13002,13044,13043,13003,-1,13073,13010,13013,13074,-1,13075,13014,13010,13073,-1,13076,13016,13019,13077,-1,13078,13020,13067,13079,-1,13080,13021,13020,13078,-1,13081,13024,13027,13082,-1,13083,13048,13024,13081,-1,13084,13049,13048,13083,-1,13030,13085,13086,13051,-1,13029,13087,13085,13030,-1,13033,13088,13087,13029,-1,13034,13089,13090,13035,-1,13062,13091,13089,13034,-1,13038,13092,13093,13039,-1,13058,13094,13095,13071,-1,13057,13096,13094,13058,-1,10852,10959,13097,13056,-1,13009,13000,10734,10753,-1,13011,13007,13006,13012,-1,13015,13068,13007,13011,-1,13017,12995,12998,13018,-1,13023,12993,13065,13066,-1,13022,12994,12993,13023,-1,13025,13002,13001,13026,-1,13047,13044,13002,13025,-1,13046,13045,13044,13047,-1,13098,13008,10752,10960,-1,13099,13100,13101,13102,-1,13103,13104,13100,13099,-1,13105,13106,13104,13103,-1,13107,13108,13109,13110,-1,13111,13112,13108,13107,-1,13113,13114,13115,13116,-1,13117,13118,13119,13120,-1,13121,13122,13118,13117,-1,11010,11009,13123,13124,-1,13054,13125,11011,10849,-1,12987,13126,13127,12988,-1,13070,13128,13126,12987,-1,13052,13129,13130,13053,-1,12989,13131,13132,13063,-1,12992,13133,13131,12989,-1,13003,13134,13135,13005,-1,13043,13136,13134,13003,-1,13042,13137,13136,13043,-1,13100,13031,13050,13101,-1,13104,13028,13031,13100,-1,13106,13032,13028,13104,-1,13108,13037,13036,13109,-1,13112,13061,13037,13108,-1,13114,13041,13040,13115,-1,13118,13059,13072,13119,-1,13122,13060,13059,13118,-1,11009,10853,13055,13123,-1,13125,13097,10959,11011,-1,13126,13094,13096,13127,-1,13128,13095,13094,13126,-1,13129,13093,13092,13130,-1,13131,13089,13091,13132,-1,13133,13090,13089,13131,-1,13134,13087,13135,-1,13136,13085,13087,13134,-1,13137,13086,13085,13136,-1,13138,13139,13112,13111,-1,13116,13115,13139,13138,-1,13139,13140,13061,13112,-1,13115,13040,13140,13139,-1,13140,13141,13062,13061,-1,13040,13039,13141,13140,-1,13141,13142,13091,13062,-1,13039,13093,13142,13141,-1,13143,13142,13093,13129,-1,13132,13091,13142,13143,-1,13144,13143,13129,13052,-1,13063,13132,13143};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_66()
		{
			int[] value = {13144,-1,13144,13145,13064,13063,-1,13052,12996,13145,13144,-1,13146,13145,12996,12995,-1,13065,13064,13145,13146,-1,13147,13146,12995,13017,-1,13066,13065,13146,13147,-1,13148,13149,13016,13076,-1,13079,13067,13149,13148,-1,13149,13147,13017,13016,-1,13067,13066,13147,13149,-1,13150,13151,13122,13121,-1,13124,13123,13151,13150,-1,13151,13152,13060,13122,-1,13123,13055,13152,13151,-1,13153,13152,13055,13056,-1,13057,13060,13152,13153,-1,13153,13154,13096,13057,-1,13056,13097,13154,13153,-1,13155,13154,13097,13125,-1,13127,13096,13154,13155,-1,13156,13155,13125,13054,-1,12988,13127,13155,13156,-1,13156,13157,12985,12988,-1,13054,12999,13157,13156,-1,13158,13157,12999,13000,-1,13006,12985,13157,13158,-1,13159,13158,13000,13009,-1,13012,13006,13158,13159,-1,13160,13161,13008,13098,-1,13074,13013,13161,13160,-1,13161,13159,13009,13008,-1,13013,13012,13159,13161,-1,13162,13163,13015,13014,-1,13019,13018,13163,13162,-1,13164,13162,13014,13075,-1,13077,13019,13162,13164,-1,13163,13165,13068,13015,-1,13018,12998,13165,13163,-1,13165,13166,13069,13068,-1,12998,12997,13166,13165,-1,13166,13167,13070,13069,-1,12997,13053,13167,13166,-1,13167,13168,13128,13070,-1,13053,13130,13168,13167,-1,13168,13169,13095,13128,-1,13130,13092,13169,13168,-1,13170,13169,13092,13038,-1,13071,13095,13169,13170,-1,13171,13170,13038,13041,-1,13072,13071,13170,13171,-1,13172,13171,13041,13114,-1,13119,13072,13171,13172,-1,13173,13172,13114,13113,-1,13120,13119,13172,13173,-1,13174,13175,12994,13022,-1,13026,13001,13175,13174,-1,13176,13174,13022,13021,-1,13027,13026,13174,13176,-1,13177,13176,13021,13080,-1,13082,13027,13176,13177,-1,13175,13178,12991,12994,-1,13001,13004,13178,13175,-1,13178,13179,12992,12991,-1,13004,13005,13179,13178,-1,13179,13180,13133,12992,-1,13005,13135,13180,13179,-1,13180,13181,13090,13133,-1,13135,13088,13181,13180,-1,13182,13181,13088,13033,-1,13035,13090,13181,13182,-1,13183,13182,13033,13032,-1,13036,13035,13182,13183,-1,13184,13183,13032,13106,-1,13109,13036,13183,13184,-1,13185,13184,13106,13105,-1,13110,13109,13184,13185,-1,13186,13187,13045,13046,-1,13046,13049,13188,13186,-1,13189,13188,13049,13084,-1,13042,13045,13187,13190,-1,13190,13191,13137,13042,-1,13191,13192,13086,13137,-1,13051,13086,13192,13193,-1,13193,13194,13050,13051,-1,13101,13050,13194,13195,-1,13102,13101,13195,13196,-1,13189,13084,13083,13081,13082,13177,13080,13078,13079,13148,13076,13077,13164,13075,13073,13074,13160,13098,10960,11126,11010,13124,13150,13121,13117,13120,13173,13113,13116,13138,13111,13107,13110,13185,13105,13103,13197,-1,13103,13099,13197,-1,13099,13187,13186,-1,13099,13102,13196,13187,-1,13196,13195,13190,13187,-1,13195,13192,13191,13190,-1,13195,13194,13193,13192,-1,13087,13088,13135,-1,13099,13186,13188,13189,13197,-1,13198,13199,13200,-1,13201,13202,13203,-1,13206,13207,13208,-1,13209,13210,13211,-1,13212,13213,13214,-1,13215,13216,13217,-1,13218,13219,13220,-1,13221,13222,13218,13223,-1,13224,13225,13226,13227,-1,13228,13229,13230,13231,-1,13232,13233,13234,13235,-1,13236,13237,13238,-1,11170,13239,13240,-1,11174,13241,13242,11171,-1,13246,13243,13244,-1,13245,13247,13246,13244,-1,13248,13243,13246,-1,13247,13249,13248,13246,-1,13250,13251,13243,13248,-1,13249,13252,13250,13248,-1,13251,13250,13253,-1,13254,13253,13250,13252,-1,13255,13251,13253,-1,13251,13255,13256,-1,13255,13253,13254,13237,-1,13256,13257,13251,-1,13256,13255,13237,13258,-1,13257,13256,13258,13259,-1,13260,13261,13251,13257,-1,13257,13259,13262,13260,-1,13261,13260,13263,-1,13263,13260,13262,13264,-1,13261,13263,13265,-1,13265,13263,13264,13266,-1,13267,13261,13265,13268,-1,13210,13268,13265,13266,-1,13269,13267,13268,-1,13210,13216,13269,13268,-1,13216,13218,13270,13269,-1,13267,13269,13270,-1,13267,13270,13271,-1,13222,13271,13270,13218,-1,11205,13267,13271,13272,-1,13272,11206,11205,-1,13272,13271,13222,13273,-1,11206,13272,13273,11208,-1,13274,13211,13275,13276,-1,13277,13278,13279,13280,-1,13276,13275,13280,13279,-1,13278,13277,13281,13282,-1,13282,13281,13214,13283,-1,13283,13214,13213,-1,13212,13284,13213,-1,13285,13286,13284,13287,-1,13212,13288,13287,13284,-1,13210,13209,13217,13216,-1,13198,13289,13199,-1,13290,13291,13289,13198,-1,13203,13292,13293,13294,-1,13295,13296,13297,-1,13208,13298,13299,13206,-1,13221,13223,13300,13301,-1,13288,13212,13302,13303,-1,13304,13305,13292,13306,-1,13202,13306,13292,13203,-1,13307,13308,13201,13309,-1,13310,13311,13312,13313,-1,13314,13315,13316,13317,-1,13318,13319,13320,13321,-1,13226,13322,13323,13227,-1,13322,13226,13324,13325,-1,13326,13327,13227,13323,-1,13328,13329,13323,13322,-1,13330,13328,13331,-1,13332,13333,13334,13335,-1,13336,13337,13333,13332,-1,13335,13334,13325,13324,-1,13338,13339,13340,13341,-1,13228,13342,13343,-1,13319,13318,13231,13230,-1,13242,13241,13229,13228,-1,13344,13345,13346,13347,-1,13348,13349,13350,13351,-1,13347,13346,13349,13348,-1,13351,13350,13352,13353,-1,13353,13352,13354,13301,-1,13222,13355,13356,13273,-1,13273,13356,13357,-1,13358,13359,13360,13361,-1,13273,13357,13362,-1,13363,13364,13362,-1,13362,11300,11208,13273,-1,13365,13366,13367,13327,-1,13329,13328,13330,-1,13368,13369,13345,13344,-1,13370,13371,13372,13294,-1,13286,13285,13312,13311,-1,13259,13373,13374,13262,-1,13264,13262,13374,13375,-1,13376,13264,13377,-1,13264,13376,13378,13266,-1,13266,13378,13379,13210,-1,13380,13303,13302,-1,13279,13278,13305,13304,-1,13218,13220,13223,-1,13221};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_67()
		{
			int[] value = {13355,13222,-1,13371,13370,13381,13382,-1,13384,13317,13385,-1,13320,13387,13386,13321,-1,13339,13338,13388,13389,-1,13390,13391,13392,13393,-1,13390,13225,13224,13391,-1,13245,13400,13401,13247,-1,13402,13403,13399,13398,-1,13247,13401,13403,13249,-1,13404,13406,13407,13405,-1,13397,13396,13407,13408,-1,13232,13235,13409,13410,-1,13411,13412,13235,13234,-1,13411,13254,13252,13412,-1,13236,13238,13234,13233,-1,13254,13411,13238,13237,-1,13237,13236,13413,13258,-1,13414,13415,13233,13232,-1,13258,13413,13373,13259,-1,13416,13417,13415,13414,-1,13310,13313,13417,13416,-1,13204,13418,13419,13205,-1,13291,13290,13420,13421,-1,13422,13215,13217,-1,13216,13215,13219,13218,-1,13423,11362,11361,13424,-1,13425,11365,11364,13330,-1,13330,11364,11368,13426,-1,13426,11368,11370,13427,-1,13427,11370,11371,13364,-1,13428,11372,11170,13240,-1,13239,11170,11375,13429,-1,13429,11375,11171,13242,-1,13423,13241,11174,11362,-1,11372,13428,13383,11320,-1,13430,13431,13220,-1,13432,13433,13431,13430,-1,13434,13435,13422,13217,-1,13422,13436,13219,13215,-1,13421,13437,13438,13291,-1,13204,13439,13440,13418,-1,13440,13439,13420,13290,-1,13418,13440,13213,-1,13441,13419,13418,13442,-1,13443,13205,13419,-1,13406,13404,13205,13443,-1,13444,13414,13232,13410,-1,13445,13416,13414,13444,-1,13445,13441,13310,13416,-1,13417,13313,13373,13413,-1,13415,13417,13413,-1,13236,13233,13415,13413,-1,13411,13234,13238,-1,13446,13447,13249,13402,-1,13409,13235,13412,13447,-1,13446,13448,13397,13408,-1,13407,13396,13405,-1,13401,13449,13399,13403,-1,13400,13449,13401,-1,13446,13402,13398,13448,-1,13382,13381,13395,13394,-1,13453,13454,13452,13450,-1,13453,13450,13451,13455,-1,13453,13369,13368,13454,-1,13382,13394,13452,13454,-1,13456,13457,13395,13381,-1,13457,13456,13438,13437,-1,13391,13458,13459,13392,-1,13207,13460,13461,13208,-1,13321,13386,13388,13338,-1,13320,13462,13463,13387,-1,13465,13464,13466,13467,-1,13385,13468,13384,-1,13317,13384,13469,13314,-1,13470,13315,13314,-1,13470,13314,13469,5353,-1,13368,13371,13382,13454,-1,13370,13471,13456,13381,-1,13471,13472,13438,13456,-1,13440,13200,13283,13213,-1,13440,13290,13198,13200,-1,13370,13294,13471,-1,13294,13293,13472,13471,-1,13294,13372,13473,13203,-1,13372,13344,13347,13473,-1,13348,13309,13473,13347,-1,13203,13473,13309,13201,-1,13348,13351,13307,13309,-1,13474,13307,13351,13353,-1,13301,13354,13355,13221,-1,13308,13432,13475,13476,-1,13434,13477,13478,13435,-1,13279,13304,13477,13276,-1,13282,13199,13305,13278,-1,13378,13303,13479,13379,-1,13288,13303,13378,13376,-1,13377,13264,13375,-1,13285,13375,13374,13312,-1,13200,13199,13282,13283,-1,13368,13344,13372,13371,-1,13276,13477,13434,13274,-1,13298,13208,13480,13295,-1,13455,13298,13297,13481,-1,13455,13481,13482,13453,-1,13482,13483,13345,13369,-1,13484,13485,13486,13487,-1,13486,13488,13489,13487,-1,13361,13360,13296,-1,13295,13480,13361,13296,-1,13296,13490,13481,13297,-1,13297,13298,13295,-1,13482,13369,13453,-1,13330,13491,13492,13329,-1,13426,13491,13330,-1,13327,13326,13493,13365,-1,13390,13494,13225,-1,13224,13367,13458,13391,-1,13495,13461,13458,13366,-1,13493,13326,13492,13496,-1,13496,13492,13491,13497,-1,13497,13491,13426,13498,-1,13499,13498,13426,13427,-1,13363,13499,13427,13364,-1,13364,11371,11300,13362,-1,13357,13500,13363,13362,-1,13500,13501,13499,13363,-1,13501,13502,13498,13499,-1,13498,13502,13503,13497,-1,13497,13503,13504,13496,-1,13504,13359,13493,13496,-1,13358,13365,13493,13359,-1,13495,13366,13365,13358,-1,13504,13485,13360,13359,-1,13503,13486,13485,13504,-1,13502,13488,13486,13503,-1,13488,13505,13489,-1,13501,13505,13488,13502,-1,13500,13506,13505,13501,-1,13357,13356,13506,13500,-1,13352,13350,13489,13505,-1,13506,13354,13352,13505,-1,13349,13487,13489,13350,-1,13349,13346,13484,13487,-1,13345,13483,13484,13346,-1,13343,13429,13242,13228,-1,13316,13239,13429,13343,-1,13507,13229,13241,13423,-1,13337,13507,13423,13424,-1,13508,13507,13337,13336,-1,13230,13508,13509,13319,-1,13231,13318,13341,-1,13321,13338,13341,13318,-1,13466,13510,13511,-1,13512,13467,13466,13511,-1,13494,13390,13467,13512,-1,13324,13494,13512,13335,-1,13337,13424,13333,-1,13333,13424,13513,13334,-1,13513,13424,13425,-1,13425,13330,13331,13513,-1,13334,13513,13331,13325,-1,13328,13322,13325,13331,-1,13492,13326,13323,13329,-1,13327,13367,13224,13227,-1,13226,13225,13494,13324,-1,13509,13508,13336,13510,-1,13510,13336,13332,13511,-1,13511,13332,13335,13512,-1,13509,13462,13320,13319,-1,13315,13240,13239,13316,-1,13385,13343,13342,13468,-1,13312,13374,13373,13313,-1,13202,13201,13308,13476,-1,13476,13478,13306,13202,-1,13304,13306,13478,13477,-1,13478,13476,13475,13435,-1,13223,13220,13431,13300,-1,13433,13474,13300,13431,-1,13433,13308,13307,13474,-1,13433,13432,13308,-1,13436,13475,13432,13430,-1,13220,13219,13436,13430,-1,13436,13422,13435,13475,-1,13354,13506,13356,13355,-1,13298,13455,13451,13299,-1,13490,13360,13483,13482,-1,13361,13480,13495,13358,-1,13424,11361,11365,13425,-1,13199,13293,13292,13305,-1,13291,13438,13472,13289,-1,13289,13472,13293,13199,-1,13209,13274,13434,13217,-1,13461,13460,13459,13458,-1,13480,13208,13461,13495,-1,13485,13484,13483,13360,-1,13311,13310,13441,13442,-1,13286,13213,13284,-1,13213,13286,13311,13442,-1,13281,13302,13212,13214,-1,13277,13380,13302,13281,-1,13275,13379,13479,13280,-1,13211,13379,13275,-1,13211,13210,13379,-1,13467,13390,13393,13465,-1,13468,13342,13340,13339};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_68()
		{
			int[] value = {-1,13339,13389,13384,13468,-1,13466,13464,13463,13462,-1,13510,13466,13462,13509,-1,13428,13240,13315,13470,-1,13470,13383,13428,-1,13211,13274,13209,-1,13474,13353,13301,13300,-1,13316,13343,13385,13317,-1,13508,13230,13229,13507,-1,13228,13231,13341,13340,-1,13340,13342,13228,-1,13418,13213,13442,-1,13249,13403,13402,-1,13447,13412,13252,13249,-1,13377,13287,13288,13376,-1,13375,13285,13287,13377,-1,13380,13479,13303,-1,13277,13280,13479,13380,-1,13445,13443,13419,13441,-1,13444,13406,13443,13445,-1,13410,13407,13406,13444,-1,13409,13408,13407,13410,-1,13447,13446,13408,13409,-1,13490,13296,13360,-1,13458,13367,13366,-1,13482,13481,13490,-1,13514,13515,13516,13517,-1,13518,13519,13520,13521,-1,13522,13523,13524,13525,-1,13526,13527,13528,13529,-1,13530,13531,13532,13533,-1,13533,13532,13534,13535,-1,13535,13534,13536,13537,-1,13537,13536,13538,13539,-1,13539,13538,13540,13541,-1,13541,13540,13542,13543,-1,13543,13542,13544,13545,-1,13545,13544,13546,13547,-1,13547,13546,13548,13549,-1,13549,13548,13550,13551,-1,13551,13550,13552,13553,-1,13553,13552,13554,13555,-1,13555,13554,13556,13557,-1,13557,13556,13558,13559,-1,13559,13558,13560,13561,-1,13561,13560,13562,13563,-1,13563,13562,13564,13565,-1,13565,13564,13566,13567,-1,13567,13566,13568,13569,-1,13569,13568,13570,13571,-1,13571,13570,13572,13573,-1,13573,13572,13531,13530,-1,13531,13574,13575,13532,-1,13532,13575,13576,13534,-1,13534,13576,13577,13536,-1,13536,13577,13578,13538,-1,13538,13578,13579,13540,-1,13540,13579,13517,13542,-1,13542,13517,13516,13544,-1,13544,13516,13580,13546,-1,13546,13580,13581,13548,-1,13548,13581,13582,13550,-1,13550,13582,13583,13552,-1,13552,13583,13584,13554,-1,13554,13584,13585,13556,-1,13556,13585,13586,13558,-1,13558,13586,13587,13560,-1,13560,13587,13515,13562,-1,13562,13515,13514,13564,-1,13564,13514,13588,13566,-1,13566,13588,13589,13568,-1,13568,13589,13590,13570,-1,13570,13590,13591,13572,-1,13572,13591,13574,13531,-1,13585,13584,13583,13582,-1,13587,13586,13581,13580,-1,13582,13581,13586,13585,-1,13515,13587,13580,13516,-1,13579,13578,13589,13588,-1,13588,13514,13517,13579,-1,13577,13576,13591,13590,-1,13590,13589,13578,13577,-1,13576,13575,13574,13591,-1,13529,13528,13592,13593,-1,13525,13524,13593,13592,-1,13521,13520,13594,13595,-1,13527,13526,13595,13594,-1,13596,13597,13598,13599,-1,13519,13518,13599,13598,-1,13600,13601,13597,13596,-1,13533,13601,13600,13530,-1,13530,13600,13596,13573,-1,13573,13596,13599,13571,-1,13571,13599,13518,13569,-1,13569,13518,13521,13567,-1,13567,13521,13595,13565,-1,13565,13595,13526,13563,-1,13563,13526,13529,13561,-1,13561,13529,13593,13559,-1,13559,13593,13524,13557,-1,13557,13524,13523,13555,-1,13555,13523,13522,13553,-1,13553,13522,13525,13551,-1,13551,13525,13592,13549,-1,13549,13592,13528,13547,-1,13547,13528,13527,13545,-1,13545,13527,13594,13543,-1,13543,13594,13520,13541,-1,13541,13520,13519,13539,-1,13539,13519,13598,13537,-1,13537,13598,13597,13535,-1,13535,13597,13601,13533,-1,13602,13603,13604,13605,-1,13606,13607,13603,13602,-1,13608,13609,13607,13606,-1,13610,13611,13609,13608,-1,13612,13613,13611,13610,-1,13614,13615,13616,13617,-1,13603,13618,13619,13604,-1,13607,13620,13618,13603,-1,13609,13621,13620,13607,-1,13611,13622,13621,13609,-1,13613,13623,13622,13611,-1,13615,13624,13625,13616,-1,13618,13626,13627,13619,-1,13620,13628,13626,13618,-1,13621,13629,13628,13620,-1,13622,13630,13629,13621,-1,13623,13631,13630,13622,-1,13624,13632,13633,13625,-1,13626,13634,13635,13627,-1,13628,13636,13634,13626,-1,13629,13637,13636,13628,-1,13630,13638,13637,13629,-1,13631,13639,13638,13630,-1,13632,13640,13641,13633,-1,13634,13642,13643,13635,-1,13636,13644,13642,13634,-1,13637,13645,13644,13636,-1,13638,13646,13645,13637,-1,13639,13647,13646,13638,-1,13640,13648,13649,13641,-1,13642,13650,13651,13643,-1,13644,13652,13650,13642,-1,13645,13653,13652,13644,-1,13646,13654,13653,13645,-1,13647,13655,13654,13646,-1,13648,13656,13657,13649,-1,13650,13658,13659,13651,-1,13652,13660,13658,13650,-1,13653,13661,13660,13652,-1,13654,13662,13661,13653,-1,13655,13663,13662,13654,-1,13656,13664,13665,13657,-1,13658,13666,13667,13659,-1,13660,13668,13666,13658,-1,13661,13669,13668,13660,-1,13662,13670,13669,13661,-1,13663,13671,13670,13662,-1,13664,13672,13673,13665,-1,13666,13674,13675,13667,-1,13668,13676,13674,13666,-1,13669,13677,13676,13668,-1,13670,13678,13677,13669,-1,13671,13679,13678,13670,-1,13672,13680,13681,13673,-1,13682,13683,13684,13685,-1,13674,13676,13677,13678,-1,13675,13686,13687,13667,-1,13667,13687,13688,13659,-1,13659,13688,13689,13651,-1,13651,13689,13690,13643,-1,13643,13690,13691,13635,-1,13635,13691,13692,13627,-1,13627,13692,13693,13619,-1,13619,13693,13694,13604,-1,13604,13694,13695,13605,-1,13682,13696,13697,13683,-1,13698,13699,13700,13701,-1,13701,13700,13702,13703,-1,13703,13702,13704,13705,-1,13705,13704,13706,13707,-1,13707,13706,13708,13709,-1,13709,13708,13710,13711,-1,13711,13710,13712,13713,-1,13713,13712,13714,13715,-1,13715,13714,13716,13679,-1,13679,13716,13686,13675,-1,13686,13717,13718,13687,-1,13687,13718,13719,13688,-1,13688,13719,13720,13689,-1,13689,13720,13721,13690,-1,13690,13721,13722,13691,-1,13691,13722,13723,13692,-1,13692,13723,13724,13693,-1,13693,13724,13725,13694,-1,13694,13725,13726,13695,-1,13696,13727,13728,13697,-1,13699,13729,13730,13700,-1,13700,13730,13731,13702,-1,13702,13731,13732,13704,-1,13704,13732,13733};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_69()
		{
			int[] value = {13706,-1,13706,13733,13734,13708,-1,13708,13734,13735,13710,-1,13710,13735,13736,13712,-1,13712,13736,13737,13714,-1,13714,13737,13738,13716,-1,13716,13738,13717,13686,-1,13725,13739,13740,13726,-1,13727,13741,13742,13728,-1,13729,13743,13744,13730,-1,13730,13744,13745,13731,-1,13731,13745,13746,13732,-1,13732,13746,13747,13733,-1,13733,13747,13748,13734,-1,13734,13748,13749,13735,-1,13735,13749,13750,13736,-1,13736,13750,13751,13737,-1,13737,13751,13752,13738,-1,13738,13752,13753,13717,-1,13717,13753,13754,13718,-1,13718,13754,13755,13719,-1,13719,13755,13756,13720,-1,13720,13756,13757,13721,-1,13721,13757,13758,13722,-1,13722,13758,13759,13723,-1,13723,13759,13760,13724,-1,13724,13760,13739,13725,-1,13739,13615,13614,13740,-1,13741,13761,13762,13742,-1,13743,13617,13616,13744,-1,13744,13616,13625,13745,-1,13745,13625,13633,13746,-1,13746,13633,13641,13747,-1,13747,13641,13649,13748,-1,13748,13649,13657,13749,-1,13749,13657,13665,13750,-1,13750,13665,13673,13751,-1,13751,13673,13681,13752,-1,13752,13681,13680,13753,-1,13753,13680,13672,13754,-1,13754,13672,13664,13755,-1,13755,13664,13656,13756,-1,13756,13656,13648,13757,-1,13757,13648,13640,13758,-1,13758,13640,13632,13759,-1,13759,13632,13624,13760,-1,13760,13624,13615,13739,-1,13678,13679,13675,13674,-1,13684,13763,13764,13685,-1,13608,13763,13684,13610,-1,13610,13684,13683,13612,-1,13698,13683,13697,13699,-1,13699,13697,13728,13729,-1,13729,13728,13742,13743,-1,13743,13742,13762,13617,-1,13617,13762,13761,13614,-1,13614,13761,13741,13740,-1,13740,13741,13727,13726,-1,13726,13727,13696,13695,-1,13695,13696,13682,13605,-1,13605,13682,13685,13602,-1,13602,13685,13764,13606,-1,13606,13764,13763,13608,-1,13631,13623,13765,13766,-1,13766,13765,13703,13705,-1,13623,13613,13767,13765,-1,13765,13767,13701,13703,-1,13613,13612,13768,13767,-1,13767,13768,13698,13701,-1,13639,13631,13766,13769,-1,13769,13766,13705,13707,-1,13647,13639,13769,13770,-1,13770,13769,13707,13709,-1,13655,13647,13770,13771,-1,13771,13770,13709,13711,-1,13663,13655,13771,13772,-1,13772,13771,13711,13713,-1,13671,13663,13772,13773,-1,13773,13772,13713,13715,-1,13612,13683,13768,-1,13683,13698,13768,-1,13679,13671,13773,-1,13773,13715,13679,-1,13774,13775,13776,13777,-1,13778,13777,13776,-1,13775,13774,13779,-1,13779,13774,13780,13781,-1,13781,13780,13782,13783,-1,13783,13782,13784,13785,-1,13785,13784,13786,13787,-1,13787,13786,13788,13789,-1,13789,13788,13790,13791,-1,13791,13790,13792,13793,-1,13793,13792,13794,13795,-1,13795,13794,13796,13797,-1,13798,13799,13800,13801,-1,13802,13803,13804,13805,-1,13805,13804,13806,13807,-1,13807,13806,13808,13809,-1,13809,13808,13810,13811,-1,13811,13810,13812,13813,-1,13813,13812,13814,13815,-1,13815,13814,13816,13817,-1,13817,13816,13818,13819,-1,13819,13818,13777,13778,-1,13777,13818,13780,13774,-1,13816,13814,13784,13782,-1,13814,13812,13786,13784,-1,13804,13803,13796,13794,-1,13794,13792,13806,13804,-1,13792,13790,13808,13806,-1,13812,13810,13788,13786,-1,13810,13808,13790,13788,-1,13818,13816,13782,13780,-1,13802,13801,13800,13803,-1,13803,13800,13799,13796,-1,13796,13799,13798,13797,-1,13820,13821,13822,13823,-1,13821,13824,13825,13822,-1,13824,13826,13827,13825,-1,13826,13828,13829,13827,-1,13828,13830,13831,13829,-1,13830,13832,13833,13831,-1,13832,13834,13835,13833,-1,13834,13836,13837,13835,-1,13836,13838,13839,13837,-1,13823,13840,13841,13820,-1,13797,13842,13843,13795,-1,13795,13843,13844,13793,-1,13793,13844,13845,13791,-1,13791,13845,13846,13789,-1,13789,13846,13847,13787,-1,13787,13847,13848,13785,-1,13785,13848,13849,13783,-1,13783,13849,13850,13781,-1,13781,13850,13851,13779,-1,13779,13851,13852,13775,-1,13775,13852,13853,13776,-1,13776,13853,13854,13778,-1,13778,13854,13855,13819,-1,13819,13855,13856,13817,-1,13817,13856,13857,13815,-1,13815,13857,13858,13813,-1,13813,13858,13859,13811,-1,13811,13859,13860,13809,-1,13809,13860,13861,13807,-1,13807,13861,13862,13805,-1,13805,13862,13863,13802,-1,13801,13864,13865,13798,-1,13842,13838,13836,13843,-1,13843,13836,13834,13844,-1,13844,13834,13832,13845,-1,13845,13832,13830,13846,-1,13846,13830,13828,13847,-1,13847,13828,13826,13848,-1,13848,13826,13824,13849,-1,13849,13824,13821,13850,-1,13850,13821,13820,13851,-1,13851,13820,13841,13852,-1,13852,13841,13840,13853,-1,13853,13840,13823,13854,-1,13854,13823,13822,13855,-1,13855,13822,13825,13856,-1,13856,13825,13827,13857,-1,13857,13827,13829,13858,-1,13858,13829,13831,13859,-1,13859,13831,13833,13860,-1,13860,13833,13835,13861,-1,13861,13835,13837,13862,-1,13862,13837,13839,13863,-1,13864,13866,13867,13865,-1,13839,13866,13864,13863,-1,13863,13864,13801,13802,-1,13797,13798,13865,13842,-1,13842,13865,13867,13838,-1,13838,13867,13866,13839,-1,13868,13869,13870,13871,-1,13869,13868,13872,-1,13873,13871,13870,-1,13874,13875,13871,13873,-1,13876,13877,13875,13874,-1,13878,13879,13877,13876,-1,13880,13881,13879,13878,-1,13882,13883,13881,13880,-1,13884,13885,13883,13882,-1,13886,13887,13885,13884,-1,13888,13889,13887,13886,-1,13890,13891,13889,13888,-1,13892,13893,13894,13895,-1,13896,13897,13898,13899,-1,13900,13901,13897,13896,-1,13902,13903,13901,13900,-1,13904,13905,13903,13902,-1,13906,13907,13905,13904,-1,13908,13909,13907,13906,-1,13910,13911,13909,13908,-1,13912,13913,13911,13910,-1,13872,13868,13913,13912,-1,13871,13875,13913,13868,-1,13877,13879,13909,13911,-1,13879,13881,13907,13909,-1,13889,13891,13898,13897,-1,13897};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_70()
		{
			int[] value = {13901,13887,13889,-1,13901,13903,13885,13887,-1,13881,13883,13905,13907,-1,13883,13885,13903,13905,-1,13875,13877,13911,13913,-1,13898,13893,13892,13899,-1,13891,13894,13893,13898,-1,13890,13895,13894,13891,-1,13914,13915,13916,13917,-1,13915,13918,13919,13916,-1,13918,13920,13921,13919,-1,13920,13922,13923,13921,-1,13922,13924,13925,13923,-1,13924,13926,13927,13925,-1,13926,13928,13929,13927,-1,13928,13930,13931,13929,-1,13930,13932,13933,13931,-1,13917,13934,13935,13914,-1,13888,13936,13937,13890,-1,13886,13938,13936,13888,-1,13884,13939,13938,13886,-1,13882,13940,13939,13884,-1,13880,13941,13940,13882,-1,13878,13942,13941,13880,-1,13876,13943,13942,13878,-1,13874,13944,13943,13876,-1,13873,13945,13944,13874,-1,13870,13946,13945,13873,-1,13869,13947,13946,13870,-1,13872,13948,13947,13869,-1,13912,13949,13948,13872,-1,13910,13950,13949,13912,-1,13908,13951,13950,13910,-1,13906,13952,13951,13908,-1,13904,13953,13952,13906,-1,13902,13954,13953,13904,-1,13900,13955,13954,13902,-1,13896,13956,13955,13900,-1,13899,13957,13956,13896,-1,13895,13958,13959,13892,-1,13936,13931,13933,13937,-1,13938,13929,13931,13936,-1,13939,13927,13929,13938,-1,13940,13925,13927,13939,-1,13941,13923,13925,13940,-1,13942,13921,13923,13941,-1,13943,13919,13921,13942,-1,13944,13916,13919,13943,-1,13945,13917,13916,13944,-1,13946,13934,13917,13945,-1,13947,13935,13934,13946,-1,13948,13914,13935,13947,-1,13949,13915,13914,13948,-1,13950,13918,13915,13949,-1,13951,13920,13918,13950,-1,13952,13922,13920,13951,-1,13953,13924,13922,13952,-1,13954,13926,13924,13953,-1,13955,13928,13926,13954,-1,13956,13930,13928,13955,-1,13957,13932,13930,13956,-1,13958,13960,13961,13959,-1,13957,13959,13961,13932,-1,13899,13892,13959,13957,-1,13937,13958,13895,13890,-1,13933,13960,13958,13937,-1,13932,13961,13960,13933,-1,13962,13963,13964,13965,-1,13963,13962,13966,-1,13967,13965,13964,-1,13968,13969,13965,13967,-1,13970,13971,13969,13968,-1,13972,13973,13971,13970,-1,13974,13975,13973,13972,-1,13976,13977,13975,13974,-1,13978,13979,13977,13976,-1,13980,13981,13979,13978,-1,13982,13983,13981,13980,-1,13984,13985,13983,13982,-1,13986,13987,13988,13989,-1,13990,13991,13992,13993,-1,13994,13995,13991,13990,-1,13996,13997,13995,13994,-1,13998,13999,13997,13996,-1,14000,14001,13999,13998,-1,14002,14003,14001,14000,-1,14004,14005,14003,14002,-1,14006,14007,14005,14004,-1,13966,13962,14007,14006,-1,13965,13969,14007,13962,-1,13971,13973,14003,14005,-1,13973,13975,14001,14003,-1,13983,13985,13992,13991,-1,13991,13995,13981,13983,-1,13995,13997,13979,13981,-1,13975,13977,13999,14001,-1,13977,13979,13997,13999,-1,13969,13971,14005,14007,-1,13992,13987,13986,13993,-1,13985,13988,13987,13992,-1,13984,13989,13988,13985,-1,14008,14009,14010,14011,-1,14009,14012,14013,14010,-1,14012,14014,14015,14013,-1,14014,14016,14017,14015,-1,14016,14018,14019,14017,-1,14018,14020,14021,14019,-1,14020,14022,14023,14021,-1,14022,14024,14025,14023,-1,14024,14026,14027,14025,-1,14011,14028,14029,14008,-1,13982,14030,14031,13984,-1,13980,14032,14030,13982,-1,13978,14033,14032,13980,-1,13976,14034,14033,13978,-1,13974,14035,14034,13976,-1,13972,14036,14035,13974,-1,13970,14037,14036,13972,-1,13968,14038,14037,13970,-1,13967,14039,14038,13968,-1,13964,14040,14039,13967,-1,13963,14041,14040,13964,-1,13966,14042,14041,13963,-1,14006,14043,14042,13966,-1,14004,14044,14043,14006,-1,14002,14045,14044,14004,-1,14000,14046,14045,14002,-1,13998,14047,14046,14000,-1,13996,14048,14047,13998,-1,13994,14049,14048,13996,-1,13990,14050,14049,13994,-1,13993,14051,14050,13990,-1,13989,14052,14053,13986,-1,14030,14025,14027,14031,-1,14032,14023,14025,14030,-1,14033,14021,14023,14032,-1,14034,14019,14021,14033,-1,14035,14017,14019,14034,-1,14036,14015,14017,14035,-1,14037,14013,14015,14036,-1,14038,14010,14013,14037,-1,14039,14011,14010,14038,-1,14040,14028,14011,14039,-1,14041,14029,14028,14040,-1,14042,14008,14029,14041,-1,14043,14009,14008,14042,-1,14044,14012,14009,14043,-1,14045,14014,14012,14044,-1,14046,14016,14014,14045,-1,14047,14018,14016,14046,-1,14048,14020,14018,14047,-1,14049,14022,14020,14048,-1,14050,14024,14022,14049,-1,14051,14026,14024,14050,-1,14052,14054,14055,14053,-1,14051,14053,14055,14026,-1,13993,13986,14053,14051,-1,14031,14052,13989,13984,-1,14027,14054,14052,14031,-1,14026,14055,14054,14027,-1,14056,14057,14058,14059,-1,14060,14061,14062,14063,-1,14064,14065,14066,14067,-1,14068,14069,14070,14071,-1,14072,14073,14074,14075,-1,14076,14077,14073,14072,-1,14078,14079,14077,14076,-1,14080,14081,14079,14078,-1,14082,14083,14081,14080,-1,14084,14085,14083,14082,-1,14086,14087,14085,14084,-1,14088,14089,14087,14086,-1,14090,14091,14089,14088,-1,14092,14093,14091,14090,-1,14094,14095,14093,14092,-1,14096,14097,14095,14094,-1,14098,14099,14097,14096,-1,14100,14101,14099,14098,-1,14102,14103,14101,14100,-1,14104,14105,14103,14102,-1,14106,14107,14105,14104,-1,14108,14109,14107,14106,-1,14110,14111,14109,14108,-1,14112,14113,14111,14110,-1,14114,14115,14113,14112,-1,14075,14074,14115,14114,-1,14073,14116,14117,14074,-1,14077,14118,14116,14073,-1,14079,14119,14118,14077,-1,14081,14120,14119,14079,-1,14083,14121,14120,14081,-1,14085,14056,14121,14083,-1,14087,14057,14056,14085,-1,14089,14122,14057,14087,-1,14091,14123,14122,14089,-1,14093,14124,14123,14091,-1,14095,14125,14124,14093,-1,14097,14126,14125,14095,-1,14099,14127,14126,14097,-1,14101,14128,14127,14099,-1,14103,14129,14128};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_71()
		{
			int[] value = {14101,-1,14105,14058,14129,14103,-1,14107,14059,14058,14105,-1,14109,14130,14059,14107,-1,14111,14131,14130,14109,-1,14113,14132,14131,14111,-1,14115,14133,14132,14113,-1,14074,14117,14133,14115,-1,14124,14125,14126,14127,-1,14122,14123,14128,14129,-1,14127,14128,14123,14124,-1,14057,14122,14129,14058,-1,14130,14131,14120,14121,-1,14121,14056,14059,14130,-1,14132,14133,14118,14119,-1,14119,14120,14131,14132,-1,14133,14117,14116,14118,-1,14134,14135,14069,14068,-1,14135,14134,14065,14064,-1,14136,14137,14061,14060,-1,14137,14136,14071,14070,-1,14138,14139,14140,14141,-1,14139,14138,14063,14062,-1,14141,14140,14142,14143,-1,14075,14143,14142,14072,-1,14114,14141,14143,14075,-1,14112,14138,14141,14114,-1,14110,14063,14138,14112,-1,14108,14060,14063,14110,-1,14106,14136,14060,14108,-1,14104,14071,14136,14106,-1,14102,14068,14071,14104,-1,14100,14134,14068,14102,-1,14098,14065,14134,14100,-1,14096,14066,14065,14098,-1,14094,14067,14066,14096,-1,14092,14064,14067,14094,-1,14090,14135,14064,14092,-1,14088,14069,14135,14090,-1,14086,14070,14069,14088,-1,14084,14137,14070,14086,-1,14082,14061,14137,14084,-1,14080,14062,14061,14082,-1,14078,14139,14062,14080,-1,14076,14140,14139,14078,-1,14072,14142,14140,14076,-1,14144,14145,14146,14147,-1,14148,14149,14150,14151,-1,14152,14153,14154,14155,-1,14156,14157,14158,14159,-1,14160,14161,14162,14163,-1,14163,14162,14164,14165,-1,14165,14164,14166,14167,-1,14167,14166,14168,14169,-1,14169,14168,14170,14171,-1,14171,14170,14172,14173,-1,14173,14172,14174,14175,-1,14175,14174,14176,14177,-1,14177,14176,14178,14179,-1,14179,14178,14180,14181,-1,14181,14180,14182,14183,-1,14183,14182,14184,14185,-1,14185,14184,14186,14187,-1,14187,14186,14188,14189,-1,14189,14188,14190,14191,-1,14191,14190,14192,14193,-1,14193,14192,14194,14195,-1,14195,14194,14196,14197,-1,14197,14196,14198,14199,-1,14199,14198,14200,14201,-1,14201,14200,14202,14203,-1,14203,14202,14161,14160,-1,14161,14204,14205,14162,-1,14162,14205,14206,14164,-1,14164,14206,14207,14166,-1,14166,14207,14208,14168,-1,14168,14208,14209,14170,-1,14170,14209,14147,14172,-1,14172,14147,14146,14174,-1,14174,14146,14210,14176,-1,14176,14210,14211,14178,-1,14178,14211,14212,14180,-1,14180,14212,14213,14182,-1,14182,14213,14214,14184,-1,14184,14214,14215,14186,-1,14186,14215,14216,14188,-1,14188,14216,14217,14190,-1,14190,14217,14145,14192,-1,14192,14145,14144,14194,-1,14194,14144,14218,14196,-1,14196,14218,14219,14198,-1,14198,14219,14220,14200,-1,14200,14220,14221,14202,-1,14202,14221,14204,14161,-1,14215,14214,14213,14212,-1,14217,14216,14211,14210,-1,14212,14211,14216,14215,-1,14145,14217,14210,14146,-1,14209,14208,14219,14218,-1,14218,14144,14147,14209,-1,14207,14206,14221,14220,-1,14220,14219,14208,14207,-1,14206,14205,14204,14221,-1,14159,14158,14222,14223,-1,14155,14154,14223,14222,-1,14151,14150,14224,14225,-1,14157,14156,14225,14224,-1,14226,14227,14228,14229,-1,14149,14148,14229,14228,-1,14230,14231,14227,14226,-1,14163,14231,14230,14160,-1,14160,14230,14226,14203,-1,14203,14226,14229,14201,-1,14201,14229,14148,14199,-1,14199,14148,14151,14197,-1,14197,14151,14225,14195,-1,14195,14225,14156,14193,-1,14193,14156,14159,14191,-1,14191,14159,14223,14189,-1,14189,14223,14154,14187,-1,14187,14154,14153,14185,-1,14185,14153,14152,14183,-1,14183,14152,14155,14181,-1,14181,14155,14222,14179,-1,14179,14222,14158,14177,-1,14177,14158,14157,14175,-1,14175,14157,14224,14173,-1,14173,14224,14150,14171,-1,14171,14150,14149,14169,-1,14169,14149,14228,14167,-1,14167,14228,14227,14165,-1,14165,14227,14231,14163,-1,14232,14233,14234,14235,-1,14236,14237,14233,14232,-1,14238,14239,14237,14236,-1,14240,14241,14239,14238,-1,14242,14243,14241,14240,-1,14244,14245,14246,14247,-1,14233,14248,14249,14234,-1,14237,14250,14248,14233,-1,14239,14251,14250,14237,-1,14241,14252,14251,14239,-1,14243,14253,14252,14241,-1,14245,14254,14255,14246,-1,14248,14256,14257,14249,-1,14250,14258,14256,14248,-1,14251,14259,14258,14250,-1,14252,14260,14259,14251,-1,14253,14261,14260,14252,-1,14254,14262,14263,14255,-1,14256,14264,14265,14257,-1,14258,14266,14264,14256,-1,14259,14267,14266,14258,-1,14260,14268,14267,14259,-1,14261,14269,14268,14260,-1,14262,14270,14271,14263,-1,14264,14272,14273,14265,-1,14266,14274,14272,14264,-1,14267,14275,14274,14266,-1,14268,14276,14275,14267,-1,14269,14277,14276,14268,-1,14270,14278,14279,14271,-1,14272,14280,14281,14273,-1,14274,14282,14280,14272,-1,14275,14283,14282,14274,-1,14276,14284,14283,14275,-1,14277,14285,14284,14276,-1,14278,14286,14287,14279,-1,14280,14288,14289,14281,-1,14282,14290,14288,14280,-1,14283,14291,14290,14282,-1,14284,14292,14291,14283,-1,14285,14293,14292,14284,-1,14286,14294,14295,14287,-1,14288,14296,14297,14289,-1,14290,14298,14296,14288,-1,14291,14299,14298,14290,-1,14292,14300,14299,14291,-1,14293,14301,14300,14292,-1,14294,14302,14303,14295,-1,14296,14304,14305,14297,-1,14298,14306,14304,14296,-1,14299,14307,14306,14298,-1,14300,14308,14307,14299,-1,14301,14309,14308,14300,-1,14302,14310,14311,14303,-1,14312,14313,14314,14315,-1,14304,14306,14307,14308,-1,14305,14316,14317,14297,-1,14297,14317,14318,14289,-1,14289,14318,14319,14281,-1,14281,14319,14320,14273,-1,14273,14320,14321,14265,-1,14265,14321,14322,14257,-1,14257,14322,14323,14249,-1,14249,14323,14324,14234,-1,14234,14324,14325,14235,-1,14312,14326,14327,14313,-1,14328,14329,14330,14331,-1,14331,14330,14332,14333,-1,14333,14332,14334};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_72()
		{
			int[] value = {14335,-1,14335,14334,14336,14337,-1,14337,14336,14338,14339,-1,14339,14338,14340,14341,-1,14341,14340,14342,14343,-1,14343,14342,14344,14345,-1,14345,14344,14346,14309,-1,14309,14346,14316,14305,-1,14316,14347,14348,14317,-1,14317,14348,14349,14318,-1,14318,14349,14350,14319,-1,14319,14350,14351,14320,-1,14320,14351,14352,14321,-1,14321,14352,14353,14322,-1,14322,14353,14354,14323,-1,14323,14354,14355,14324,-1,14324,14355,14356,14325,-1,14326,14357,14358,14327,-1,14329,14359,14360,14330,-1,14330,14360,14361,14332,-1,14332,14361,14362,14334,-1,14334,14362,14363,14336,-1,14336,14363,14364,14338,-1,14338,14364,14365,14340,-1,14340,14365,14366,14342,-1,14342,14366,14367,14344,-1,14344,14367,14368,14346,-1,14346,14368,14347,14316,-1,14355,14369,14370,14356,-1,14357,14371,14372,14358,-1,14359,14373,14374,14360,-1,14360,14374,14375,14361,-1,14361,14375,14376,14362,-1,14362,14376,14377,14363,-1,14363,14377,14378,14364,-1,14364,14378,14379,14365,-1,14365,14379,14380,14366,-1,14366,14380,14381,14367,-1,14367,14381,14382,14368,-1,14368,14382,14383,14347,-1,14347,14383,14384,14348,-1,14348,14384,14385,14349,-1,14349,14385,14386,14350,-1,14350,14386,14387,14351,-1,14351,14387,14388,14352,-1,14352,14388,14389,14353,-1,14353,14389,14390,14354,-1,14354,14390,14369,14355,-1,14369,14245,14244,14370,-1,14371,14391,14392,14372,-1,14373,14247,14246,14374,-1,14374,14246,14255,14375,-1,14375,14255,14263,14376,-1,14376,14263,14271,14377,-1,14377,14271,14279,14378,-1,14378,14279,14287,14379,-1,14379,14287,14295,14380,-1,14380,14295,14303,14381,-1,14381,14303,14311,14382,-1,14382,14311,14310,14383,-1,14383,14310,14302,14384,-1,14384,14302,14294,14385,-1,14385,14294,14286,14386,-1,14386,14286,14278,14387,-1,14387,14278,14270,14388,-1,14388,14270,14262,14389,-1,14389,14262,14254,14390,-1,14390,14254,14245,14369,-1,14308,14309,14305,14304,-1,14314,14393,14394,14315,-1,14238,14393,14314,14240,-1,14240,14314,14313,14242,-1,14328,14313,14327,14329,-1,14329,14327,14358,14359,-1,14359,14358,14372,14373,-1,14373,14372,14392,14247,-1,14247,14392,14391,14244,-1,14244,14391,14371,14370,-1,14370,14371,14357,14356,-1,14356,14357,14326,14325,-1,14325,14326,14312,14235,-1,14235,14312,14315,14232,-1,14232,14315,14394,14236,-1,14236,14394,14393,14238,-1,14261,14253,14395,14396,-1,14396,14395,14333,14335,-1,14253,14243,14397,14395,-1,14395,14397,14331,14333,-1,14243,14242,14398,14397,-1,14397,14398,14328,14331,-1,14269,14261,14396,14399,-1,14399,14396,14335,14337,-1,14277,14269,14399,14400,-1,14400,14399,14337,14339,-1,14285,14277,14400,14401,-1,14401,14400,14339,14341,-1,14293,14285,14401,14402,-1,14402,14401,14341,14343,-1,14301,14293,14402,14403,-1,14403,14402,14343,14345,-1,14242,14313,14398,-1,14313,14328,14398,-1,14309,14301,14403,-1,14403,14345,14309,-1,14404,14405,14406,14407,-1,14408,14407,14406,-1,14405,14404,14409,-1,14409,14404,14410,14411,-1,14411,14410,14412,14413,-1,14413,14412,14414,14415,-1,14415,14414,14416,14417,-1,14417,14416,14418,14419,-1,14419,14418,14420,14421,-1,14421,14420,14422,14423,-1,14423,14422,14424,14425,-1,14425,14424,14426,14427,-1,14428,14429,14430,14431,-1,14432,14433,14434,14435,-1,14435,14434,14436,14437,-1,14437,14436,14438,14439,-1,14439,14438,14440,14441,-1,14441,14440,14442,14443,-1,14443,14442,14444,14445,-1,14445,14444,14446,14447,-1,14447,14446,14448,14449,-1,14449,14448,14407,14408,-1,14407,14448,14410,14404,-1,14446,14444,14414,14412,-1,14444,14442,14416,14414,-1,14434,14433,14426,14424,-1,14424,14422,14436,14434,-1,14422,14420,14438,14436,-1,14442,14440,14418,14416,-1,14440,14438,14420,14418,-1,14448,14446,14412,14410,-1,14432,14431,14430,14433,-1,14433,14430,14429,14426,-1,14426,14429,14428,14427,-1,14450,14451,14452,14453,-1,14451,14454,14455,14452,-1,14454,14456,14457,14455,-1,14456,14458,14459,14457,-1,14458,14460,14461,14459,-1,14460,14462,14463,14461,-1,14462,14464,14465,14463,-1,14464,14466,14467,14465,-1,14466,14468,14469,14467,-1,14453,14470,14471,14450,-1,14427,14472,14473,14425,-1,14425,14473,14474,14423,-1,14423,14474,14475,14421,-1,14421,14475,14476,14419,-1,14419,14476,14477,14417,-1,14417,14477,14478,14415,-1,14415,14478,14479,14413,-1,14413,14479,14480,14411,-1,14411,14480,14481,14409,-1,14409,14481,14482,14405,-1,14405,14482,14483,14406,-1,14406,14483,14484,14408,-1,14408,14484,14485,14449,-1,14449,14485,14486,14447,-1,14447,14486,14487,14445,-1,14445,14487,14488,14443,-1,14443,14488,14489,14441,-1,14441,14489,14490,14439,-1,14439,14490,14491,14437,-1,14437,14491,14492,14435,-1,14435,14492,14493,14432,-1,14431,14494,14495,14428,-1,14472,14468,14466,14473,-1,14473,14466,14464,14474,-1,14474,14464,14462,14475,-1,14475,14462,14460,14476,-1,14476,14460,14458,14477,-1,14477,14458,14456,14478,-1,14478,14456,14454,14479,-1,14479,14454,14451,14480,-1,14480,14451,14450,14481,-1,14481,14450,14471,14482,-1,14482,14471,14470,14483,-1,14483,14470,14453,14484,-1,14484,14453,14452,14485,-1,14485,14452,14455,14486,-1,14486,14455,14457,14487,-1,14487,14457,14459,14488,-1,14488,14459,14461,14489,-1,14489,14461,14463,14490,-1,14490,14463,14465,14491,-1,14491,14465,14467,14492,-1,14492,14467,14469,14493,-1,14494,14496,14497,14495,-1,14469,14496,14494,14493,-1,14493,14494,14431,14432,-1,14427,14428,14495,14472,-1,14472,14495,14497,14468,-1,14468,14497,14496,14469,-1,14498,14499,14500,14501,-1,14522,14523,14524,14525,-1,14525,14524,14526,14527,-1,14527,14526,14528,14529,-1,14529,14528,14530,14531};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_73()
		{
			int[] value = {-1,14531,14530,14532,14533,-1,14533,14532,14534,14535,-1,14535,14534,14536,14537,-1,14537,14536,14538,14539,-1,14539,14538,14540,14541,-1,14541,14540,14542,14543,-1,14543,14542,14544,14545,-1,14499,14502,14503,14500,-1,14523,14546,14547,14524,-1,14524,14547,14548,14526,-1,14526,14548,14549,14528,-1,14528,14549,14550,14530,-1,14530,14550,14551,14532,-1,14532,14551,14552,14534,-1,14534,14552,14553,14536,-1,14536,14553,14554,14538,-1,14538,14554,14555,14540,-1,14540,14555,14556,14542,-1,14542,14556,14557,14544,-1,14502,14504,14505,14503,-1,14546,14558,14559,14547,-1,14547,14559,14560,14548,-1,14548,14560,14561,14549,-1,14549,14561,14562,14550,-1,14550,14562,14563,14551,-1,14551,14563,14564,14552,-1,14552,14564,14565,14553,-1,14553,14565,14566,14554,-1,14554,14566,14567,14555,-1,14555,14567,14568,14556,-1,14556,14568,14569,14557,-1,14504,14506,14507,14505,-1,14558,14570,14571,14559,-1,14559,14571,14572,14560,-1,14560,14572,14573,14561,-1,14561,14573,14574,14562,-1,14562,14574,14575,14563,-1,14563,14575,14576,14564,-1,14564,14576,14577,14565,-1,14565,14577,14578,14566,-1,14566,14578,14579,14567,-1,14567,14579,14580,14568,-1,14568,14580,14581,14569,-1,14506,14508,14509,14507,-1,14570,14582,14583,14571,-1,14571,14583,14584,14572,-1,14572,14584,14585,14573,-1,14573,14585,14586,14574,-1,14574,14586,14587,14575,-1,14575,14587,14588,14576,-1,14576,14588,14589,14577,-1,14577,14589,14590,14578,-1,14578,14590,14591,14579,-1,14579,14591,14592,14580,-1,14580,14592,14593,14581,-1,14508,14510,14511,14509,-1,14582,14594,14595,14583,-1,14583,14595,14596,14584,-1,14584,14596,14597,14585,-1,14585,14597,14598,14586,-1,14586,14598,14599,14587,-1,14587,14599,14600,14588,-1,14588,14600,14601,14589,-1,14589,14601,14602,14590,-1,14590,14602,14603,14591,-1,14591,14603,14604,14592,-1,14592,14604,14605,14593,-1,14510,14512,14513,14511,-1,14594,14606,14607,14595,-1,14595,14607,14608,14596,-1,14596,14608,14609,14597,-1,14597,14609,14610,14598,-1,14598,14610,14611,14599,-1,14599,14611,14612,14600,-1,14600,14612,14613,14601,-1,14601,14613,14614,14602,-1,14602,14614,14615,14603,-1,14603,14615,14616,14604,-1,14604,14616,14617,14605,-1,14512,14514,14515,14513,-1,14606,14618,14619,14607,-1,14607,14619,14620,14608,-1,14608,14620,14621,14609,-1,14609,14621,14622,14610,-1,14610,14622,14623,14611,-1,14611,14623,14624,14612,-1,14612,14624,14625,14613,-1,14613,14625,14626,14614,-1,14614,14626,14627,14615,-1,14615,14627,14628,14616,-1,14616,14628,14629,14617,-1,14514,14516,14517,14515,-1,14618,14630,14631,14619,-1,14619,14631,14632,14620,-1,14620,14632,14633,14621,-1,14621,14633,14634,14622,-1,14622,14634,14635,14623,-1,14623,14635,14636,14624,-1,14624,14636,14637,14625,-1,14625,14637,14638,14626,-1,14626,14638,14639,14627,-1,14627,14639,14640,14628,-1,14628,14640,14641,14629,-1,14516,14518,14519,14517,-1,14630,14642,14643,14631,-1,14631,14643,14644,14632,-1,14632,14644,14645,14633,-1,14633,14645,14646,14634,-1,14634,14646,14647,14635,-1,14635,14647,14648,14636,-1,14636,14648,14649,14637,-1,14637,14649,14650,14638,-1,14638,14650,14651,14639,-1,14639,14651,14652,14640,-1,14640,14652,14653,14641,-1,14518,14520,14521,14519,-1,14642,14654,14655,14643,-1,14643,14655,14656,14644,-1,14644,14656,14657,14645,-1,14645,14657,14658,14646,-1,14646,14658,14659,14647,-1,14647,14659,14660,14648,-1,14648,14660,14661,14649,-1,14649,14661,14662,14650,-1,14650,14662,14663,14651,-1,14651,14663,14664,14652,-1,14652,14664,14665,14653,-1,14520,14498,14501,14521,-1,14654,14522,14525,14655,-1,14655,14525,14527,14656,-1,14656,14527,14529,14657,-1,14657,14529,14531,14658,-1,14658,14531,14533,14659,-1,14659,14533,14535,14660,-1,14660,14535,14537,14661,-1,14661,14537,14539,14662,-1,14662,14539,14541,14663,-1,14663,14541,14543,14664,-1,14664,14543,14545,14665,-1,14520,14518,14516,14514,14512,14510,14508,14506,14504,14502,14499,14498,-1,14544,14557,14569,14581,14593,14605,14617,14629,14641,14653,14665,14545,-1,14666,14667,14668,14669,-1,14690,14691,14692,14693,-1,14694,14695,14691,14690,-1,14696,14697,14695,14694,-1,14698,14699,14697,14696,-1,14700,14701,14699,14698,-1,14702,14703,14701,14700,-1,14704,14705,14703,14702,-1,14706,14707,14705,14704,-1,14708,14709,14707,14706,-1,14710,14711,14709,14708,-1,14712,14713,14711,14710,-1,14667,14670,14671,14668,-1,14691,14714,14715,14692,-1,14695,14716,14714,14691,-1,14697,14717,14716,14695,-1,14699,14718,14717,14697,-1,14701,14719,14718,14699,-1,14703,14720,14719,14701,-1,14705,14721,14720,14703,-1,14707,14722,14721,14705,-1,14709,14723,14722,14707,-1,14711,14724,14723,14709,-1,14713,14725,14724,14711,-1,14670,14672,14673,14671,-1,14714,14726,14727,14715,-1,14716,14728,14726,14714,-1,14717,14729,14728,14716,-1,14718,14730,14729,14717,-1,14719,14731,14730,14718,-1,14720,14732,14731,14719,-1,14721,14733,14732,14720,-1,14722,14734,14733,14721,-1,14723,14735,14734,14722,-1,14724,14736,14735,14723,-1,14725,14737,14736,14724,-1,14672,14674,14675,14673,-1,14726,14738,14739,14727,-1,14728,14740,14738,14726,-1,14729,14741,14740,14728,-1,14730,14742,14741,14729,-1,14731,14743,14742,14730,-1,14732,14744,14743,14731,-1,14733,14745,14744,14732,-1,14734,14746,14745,14733,-1,14735,14747,14746,14734,-1,14736,14748,14747,14735,-1,14737,14749,14748,14736,-1,14674,14676,14677,14675,-1,14738,14750,14751,14739,-1,14740,14752,14750,14738,-1,14741,14753,14752,14740,-1,14742,14754,14753,14741,-1,14743,14755,14754,14742,-1,14744,14756,14755,14743,-1,14745,14757,14756};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_74()
		{
			int[] value = {14744,-1,14746,14758,14757,14745,-1,14747,14759,14758,14746,-1,14748,14760,14759,14747,-1,14749,14761,14760,14748,-1,14676,14678,14679,14677,-1,14750,14762,14763,14751,-1,14752,14764,14762,14750,-1,14753,14765,14764,14752,-1,14754,14766,14765,14753,-1,14755,14767,14766,14754,-1,14756,14768,14767,14755,-1,14757,14769,14768,14756,-1,14758,14770,14769,14757,-1,14759,14771,14770,14758,-1,14760,14772,14771,14759,-1,14761,14773,14772,14760,-1,14678,14680,14681,14679,-1,14762,14774,14775,14763,-1,14764,14776,14774,14762,-1,14765,14777,14776,14764,-1,14766,14778,14777,14765,-1,14767,14779,14778,14766,-1,14768,14780,14779,14767,-1,14769,14781,14780,14768,-1,14770,14782,14781,14769,-1,14771,14783,14782,14770,-1,14772,14784,14783,14771,-1,14773,14785,14784,14772,-1,14680,14682,14683,14681,-1,14774,14786,14787,14775,-1,14776,14788,14786,14774,-1,14777,14789,14788,14776,-1,14778,14790,14789,14777,-1,14779,14791,14790,14778,-1,14780,14792,14791,14779,-1,14781,14793,14792,14780,-1,14782,14794,14793,14781,-1,14783,14795,14794,14782,-1,14784,14796,14795,14783,-1,14785,14797,14796,14784,-1,14682,14684,14685,14683,-1,14786,14798,14799,14787,-1,14788,14800,14798,14786,-1,14789,14801,14800,14788,-1,14790,14802,14801,14789,-1,14791,14803,14802,14790,-1,14792,14804,14803,14791,-1,14793,14805,14804,14792,-1,14794,14806,14805,14793,-1,14795,14807,14806,14794,-1,14796,14808,14807,14795,-1,14797,14809,14808,14796,-1,14684,14686,14687,14685,-1,14798,14810,14811,14799,-1,14800,14812,14810,14798,-1,14801,14813,14812,14800,-1,14802,14814,14813,14801,-1,14803,14815,14814,14802,-1,14804,14816,14815,14803,-1,14805,14817,14816,14804,-1,14806,14818,14817,14805,-1,14807,14819,14818,14806,-1,14808,14820,14819,14807,-1,14809,14821,14820,14808,-1,14686,14688,14689,14687,-1,14810,14822,14823,14811,-1,14812,14824,14822,14810,-1,14813,14825,14824,14812,-1,14814,14826,14825,14813,-1,14815,14827,14826,14814,-1,14816,14828,14827,14815,-1,14817,14829,14828,14816,-1,14818,14830,14829,14817,-1,14819,14831,14830,14818,-1,14820,14832,14831,14819,-1,14821,14833,14832,14820,-1,14688,14666,14669,14689,-1,14822,14690,14693,14823,-1,14824,14694,14690,14822,-1,14825,14696,14694,14824,-1,14826,14698,14696,14825,-1,14827,14700,14698,14826,-1,14828,14702,14700,14827,-1,14829,14704,14702,14828,-1,14830,14706,14704,14829,-1,14831,14708,14706,14830,-1,14832,14710,14708,14831,-1,14833,14712,14710,14832,-1,14669,14668,14671,14673,14675,14677,14679,14681,14683,14685,14687,14689,-1,14712,14833,14821,14809,14797,14785,14773,14761,14749,14737,14725,14713,-1,94,14834,14835,95,-1,14834,94,14836,14837,-1,14837,14836,14838,14839,-1,14841,14840,14842,-1,14845,14846,14847,-1,14848,14932,14933,14849,-1,14845,14847,14932,14848,-1,14849,14933,14934,14850,-1,14850,14934,14935,14851,-1,14851,14935,14936,14852,-1,14852,14936,14937,14853,-1,14854,14838,14853,14937,-1,14838,14854,14844,14839,-1,14843,14855,14839,14844,-1,14856,14857,14855,14843,-1,14858,14859,14857,14856,-1,14860,14861,14862,14863,-1,14938,14864,14861,14860,-1,14939,14865,14864,14938,-1,14866,14867,14865,14939,-1,14868,14869,14867,14866,-1,14870,14871,14869,14868,-1,14846,14845,14871,14870,-1,14858,14863,14862,14859,-1,14872,14873,14859,14862,-1,14874,14875,14876,14877,-1,14875,14874,14878,14879,-1,14861,14864,14879,14878,-1,14877,14876,14880,-1,14883,14882,115,116,-1,14884,14883,116,117,-1,132,14887,14888,14886,-1,14882,14889,14890,14881,-1,14891,14848,14849,14892,-1,14893,14894,14895,-1,14851,14896,138,14850,-1,14897,14898,14899,14900,-1,14875,14897,14900,14876,-1,14889,14882,14883,14902,-1,14848,14891,14903,14845,-1,14904,14905,14906,-1,14899,14906,14905,14900,-1,14867,14907,14908,14865,-1,14907,14867,14869,-1,117,116,141,-1,14902,14883,14884,14909,-1,14845,14903,14910,14871,-1,117,140,14904,14906,-1,14884,117,14906,14899,-1,14909,14884,14899,14898,-1,14871,14910,14907,14869,-1,122,14885,14880,-1,14911,14880,14885,14912,-1,14842,14911,14912,14841,-1,14886,14842,14840,-1,14880,14911,14877,-1,122,14905,14904,120,-1,14900,14905,14876,-1,14865,14908,14879,14864,-1,14874,14877,14911,14913,-1,14913,14911,14842,14914,-1,14914,14842,14886,14888,-1,14873,14915,14857,14859,-1,14887,132,142,14916,-1,14834,14917,14901,14835,-1,14836,14894,14853,14838,-1,14894,14893,14852,14853,-1,14918,14893,14895,-1,14896,14851,14852,14893,-1,14850,138,14892,14849,-1,14921,14855,14922,-1,14923,14924,14901,14917,-1,14916,142,14924,14923,-1,14855,14857,14925,14922,-1,14895,14894,14919,-1,14919,14894,14836,94,-1,14834,14837,14921,14917,-1,14917,14921,14922,14923,-1,14923,14922,14925,14916,-1,14916,14925,14915,14887,-1,14887,14915,14888,-1,14888,14915,14873,14914,-1,14914,14873,14872,14913,-1,14913,14872,14878,14874,-1,14875,14879,14908,14897,-1,14897,14908,14907,14898,-1,14898,14907,14910,14909,-1,14909,14910,14903,14902,-1,14902,14903,14891,14889,-1,14889,14891,14892,14890,-1,14890,14892,138,14920,-1,14905,122,14880,14876,-1,14921,14837,14839,14855,-1,14857,14915,14925,-1,14862,14861,14878,14872,-1,14926,14927,15015,15014,-1,14928,14929,14927,14926,-1,14929,14928,14930,14931,-1,14931,14930,14843,14844,-1,14940,14941,14863,14858,-1,14942,14943,14941,14940,-1,14943,14942,14944,14945,-1,14946,14947,14945,14944,-1,14947,14946,14948,14949,-1,14950,14951,14938,14860,-1,14952,14953,14951,14950,-1,14954,14955,14953,14952,-1,14955,14954,14956,-1,15015,14927,14958,15069,-1,14959,14960,14961,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_75()
		{
			int[] value = {14962,14961,14960,14963,-1,14932,14962,14963,14933,-1,14934,14963,14964,14935,-1,14962,14932,14847,14965,-1,14965,14961,14962,-1,14966,14967,14847,14846,-1,14968,14969,14970,14971,-1,14972,14968,14971,14973,-1,14973,14967,14966,14972,-1,14847,14967,14965,-1,14961,14965,14967,14973,-1,14974,14972,14966,-1,14972,14974,14975,14968,-1,14969,14968,14975,14976,-1,14866,14977,14978,14868,-1,14977,14951,14953,-1,14979,14980,14953,14955,-1,14981,14979,14955,14956,-1,14952,14950,14941,14943,-1,14956,14954,14945,14947,-1,14942,14940,14982,14983,-1,14944,14942,14983,14984,-1,14946,14944,14984,15079,-1,14966,14846,14870,14985,-1,14974,14966,14985,14986,-1,14975,14974,14986,14987,-1,14976,14975,14987,14988,-1,14985,14870,14868,14978,-1,14986,14985,14978,14980,-1,14987,14986,14980,14979,-1,14988,14987,14979,14981,-1,14951,14939,14938,-1,14950,14860,14863,14941,-1,14940,14858,14856,14982,-1,14856,14843,14930,14982,-1,14983,14982,14930,14928,-1,14984,14983,14928,14926,-1,15079,14984,14926,15014,-1,14943,14945,14954,14952,-1,14989,15087,14990,14991,-1,14992,14991,14990,14993,-1,14964,14992,14993,14994,-1,14990,15087,15069,14958,-1,14958,14927,14929,-1,14994,14993,14929,14931,-1,14936,14994,14937,-1,14931,14844,14854,-1,14959,14995,14989,14991,-1,14960,14959,14991,14992,-1,14960,14992,14964,14963,-1,14934,14933,14963,-1,14935,14964,14994,14936,-1,14995,14959,14971,14970,-1,14973,14971,14959,14961,-1,14970,15065,15067,14995,-1,14995,15067,14996,14989,-1,15079,15092,14948,14946,-1,14947,14949,15093,14956,-1,14956,15093,15094,14981,-1,14981,15094,14957,14988,-1,14988,14957,15060,14976,-1,14976,15060,15063,14969,-1,14969,15063,15065,14970,-1,14953,14980,14978,14977,-1,14951,14977,14866,14939,-1,14854,14937,14994,14931,-1,14929,14993,14990,14958,-1,14997,14998,14999,-1,15000,15001,15002,15003,-1,15097,15004,15005,-1,15006,15007,15008,15009,-1,15010,15011,15009,15008,-1,15007,15006,15012,15013,-1,15014,15015,15013,15012,-1,15011,15010,15016,-1,15017,15018,14949,14948,-1,15019,15020,15018,15017,-1,15021,15022,15020,15019,-1,15022,15021,15023,-1,15024,15025,15026,15027,-1,15028,15029,15004,-1,15030,15031,15032,15033,-1,15034,15035,15036,15037,-1,14998,15038,15039,15040,-1,15026,15025,15097,15098,-1,15097,15043,15004,-1,15005,15004,15029,-1,15032,15031,15044,-1,15036,15035,15045,-1,15001,15046,15002,-1,15035,15034,15001,15000,-1,15047,15034,15037,-1,15031,15030,15037,15036,-1,15030,15033,15048,-1,15029,15028,15033,15032,-1,15049,15043,15025,15024,-1,15002,15050,15051,15003,-1,14999,14998,15040,-1,15052,15053,15040,15039,-1,15027,15026,15042,15054,-1,15055,15024,15027,-1,15054,15016,15010,-1,15016,15056,15011,-1,15022,15023,15057,-1,14997,15038,14998,-1,14997,15023,15021,-1,15016,15054,15042,15041,-1,15043,15049,15028,-1,15028,15004,15043,-1,15050,15002,15046,-1,15050,15046,15058,-1,15039,15038,15059,-1,15060,14957,15061,15062,-1,15063,15060,15062,15064,-1,15065,15063,15064,15066,-1,15067,15065,15066,15068,-1,15070,15064,15062,-1,15028,15071,15048,15033,-1,15064,15070,15072,15066,-1,15021,15038,14997,-1,15043,15097,15025,-1,15098,15042,15026,-1,15073,15074,15075,15076,-1,15076,15075,15018,15020,-1,15077,15076,15020,15022,-1,15078,15077,15022,15057,-1,15017,15080,15059,15019,-1,15021,15019,15059,15038,-1,15058,15070,15062,15061,-1,15047,15070,15058,15046,-1,15034,15047,15046,15001,-1,15058,15061,15074,15073,-1,15081,15073,15076,15077,-1,15081,15077,15078,-1,15059,15080,15006,15009,-1,15039,15059,15009,15011,-1,15053,14999,15040,-1,15082,15049,15024,15055,-1,15083,15082,15055,15084,-1,15084,15085,15086,15083,-1,15084,15055,15010,15008,-1,15008,15007,15088,-1,15089,15072,15048,15071,-1,15068,15089,15083,15086,-1,15070,15047,15048,15072,-1,15072,15089,15068,15066,-1,15030,15048,15047,15037,-1,15000,15045,15035,-1,15052,15039,15011,15056,-1,15031,15036,15045,15044,-1,15029,15032,15044,15005,-1,15010,15055,15027,15054,-1,14989,14996,15090,15087,-1,15087,15090,15091,15069,-1,15069,15091,15013,15015,-1,15014,15012,15092,15079,-1,15074,15094,15093,15075,-1,15075,15093,14949,15018,-1,15017,14948,15092,15080,-1,15080,15092,15012,15006,-1,15007,15013,15091,15088,-1,15090,15085,15088,15091,-1,14996,15086,15085,15090,-1,15094,15074,15061,14957,-1,15086,14996,15067,15068,-1,15088,15085,15084,15008,-1,15028,15049,15082,15071,-1,15071,15082,15083,15089,-1,15078,15051,15050,15081,-1,15081,15050,15058,15073,-1,15102,15103,15016,15041,-1,15104,15056,15016,15103,-1,15105,15052,15056,15104,-1,15106,15053,15052,15105,-1,15107,14999,15053,15106,-1,15108,14997,14999,15107,-1,15095,15023,14997,15108,-1,15109,15057,15023,15095,-1,15096,15078,15057,15109,-1,15110,15051,15078,15096,-1,15111,15003,15051,15110,-1,15112,15000,15003,15111,-1,15113,15045,15000,15112,-1,15114,15044,15045,15113,-1,15100,15005,15044,15114,-1,15275,15276,15277,15278,-1,15276,15279,15280,15277,-1,15281,15282,15283,15284,-1,15282,15285,15286,15283,-1,15278,15277,15287,15288,-1,15277,15280,15289,15287,-1,15284,15283,15290,15291,-1,15283,15286,15292,15290,-1,15288,15287,15293,15294,-1,15287,15289,15295,15293,-1,15291,15290,15296,15297,-1,15290,15292,15298,15296,-1,15294,15293,15299,15300,-1,15293,15295,15301,15299,-1,15297,15296,15302,15303,-1,15296,15298,15304,15302,-1,15300,15299,15305,15306,-1,15299,15301,15307,15305,-1,15303,15302,15308,15309,-1,15302,15304,15310,15308,-1,15306,15305,15311,15312,-1,15305,15307,15313,15311,-1,15309,15308,15314,15315,-1,15308};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_76()
		{
			int[] value = {15310,15316,15314,-1,15312,15311,15317,15318,-1,15311,15313,15319,15317,-1,15315,15314,15320,15321,-1,15314,15316,15322,15320,-1,15318,15317,15323,15324,-1,15317,15319,15325,15323,-1,15321,15320,15326,15327,-1,15320,15322,15328,15326,-1,15324,15323,15329,15330,-1,15323,15325,15331,15329,-1,15327,15326,15332,15333,-1,15326,15328,15334,15332,-1,15330,15329,15335,15336,-1,15329,15331,15337,15335,-1,15333,15332,15338,-1,15332,15334,15336,15338,-1,15275,15285,15282,15281,-1,15339,15340,15341,15342,-1,15336,15341,15340,15338,-1,15339,15342,15335,15337,-1,15337,15338,15340,15339,-1,15342,15341,15336,15335,-1,15338,15337,15331,15333,-1,15333,15331,15325,15327,-1,15327,15325,15319,15321,-1,15321,15319,15313,15315,-1,15315,15313,15307,15309,-1,15309,15307,15301,15303,-1,15303,15301,15295,15297,-1,15297,15295,15289,15291,-1,15291,15289,15280,15284,-1,15284,15280,15279,15281,-1,15281,15279,15276,15275,-1,15336,15334,15330,-1,15330,15334,15328,15324,-1,15324,15328,15322,15318,-1,15318,15322,15316,15312,-1,15312,15316,15310,15306,-1,15306,15310,15304,15300,-1,15300,15304,15298,15294,-1,15294,15298,15292,15288,-1,15288,15292,15286,15278,-1,15278,15286,15285,15275,-1,15343,15344,15345,15346,-1,15344,15347,15348,15345,-1,15349,15350,15351,15352,-1,15350,15353,15354,15351,-1,15346,15345,15355,15356,-1,15345,15348,15357,15355,-1,15352,15351,15358,15359,-1,15351,15354,15360,15358,-1,15356,15355,15361,15362,-1,15355,15357,15363,15361,-1,15359,15358,15364,15365,-1,15358,15360,15366,15364,-1,15362,15361,15367,15368,-1,15361,15363,15369,15367,-1,15365,15364,15370,15371,-1,15364,15366,15372,15370,-1,15368,15367,15373,15374,-1,15367,15369,15375,15373,-1,15371,15370,15376,15377,-1,15370,15372,15378,15376,-1,15374,15373,15379,15380,-1,15373,15375,15381,15379,-1,15377,15376,15382,15383,-1,15376,15378,15384,15382,-1,15380,15379,15385,15386,-1,15379,15381,15387,15385,-1,15383,15382,15388,15389,-1,15382,15384,15390,15388,-1,15386,15385,15391,15392,-1,15385,15387,15393,15391,-1,15389,15388,15394,15395,-1,15388,15390,15396,15394,-1,15392,15391,15397,15398,-1,15391,15393,15399,15397,-1,15395,15394,15400,15401,-1,15394,15396,15402,15400,-1,15398,15397,15403,15404,-1,15397,15399,15405,15403,-1,15401,15400,15406,-1,15400,15402,15404,15406,-1,15343,15353,15350,15349,-1,15407,15408,15409,15410,-1,15404,15409,15408,15406,-1,15407,15410,15403,15405,-1,15405,15406,15408,15407,-1,15410,15409,15404,15403,-1,15406,15405,15399,15401,-1,15401,15399,15393,15395,-1,15395,15393,15387,15389,-1,15389,15387,15381,15383,-1,15383,15381,15375,15377,-1,15377,15375,15369,15371,-1,15371,15369,15363,15365,-1,15365,15363,15357,15359,-1,15359,15357,15348,15352,-1,15352,15348,15347,15349,-1,15349,15347,15344,15343,-1,15404,15402,15398,-1,15398,15402,15396,15392,-1,15392,15396,15390,15386,-1,15386,15390,15384,15380,-1,15380,15384,15378,15374,-1,15374,15378,15372,15368,-1,15368,15372,15366,15362,-1,15362,15366,15360,15356,-1,15356,15360,15354,15346,-1,15346,15354,15353,15343,-1,15411,15412,15413,15414,-1,15412,15415,15416,15413,-1,15417,15418,15419,15420,-1,15418,15421,15422,15419,-1,15414,15413,15423,15424,-1,15413,15416,15425,15423,-1,15420,15419,15426,15427,-1,15419,15422,15428,15426,-1,15424,15423,15429,15430,-1,15423,15425,15431,15429,-1,15427,15426,15432,15433,-1,15426,15428,15434,15432,-1,15430,15429,15435,15436,-1,15429,15431,15437,15435,-1,15433,15432,15438,15439,-1,15432,15434,15440,15438,-1,15436,15435,15441,15442,-1,15435,15437,15443,15441,-1,15439,15438,15444,15445,-1,15438,15440,15446,15444,-1,15442,15441,15447,15448,-1,15441,15443,15449,15447,-1,15445,15444,15450,15451,-1,15444,15446,15452,15450,-1,15448,15447,15453,15454,-1,15447,15449,15455,15453,-1,15451,15450,15456,15457,-1,15450,15452,15458,15456,-1,15454,15453,15459,15460,-1,15453,15455,15461,15459,-1,15457,15456,15462,15463,-1,15456,15458,15464,15462,-1,15460,15459,15465,15466,-1,15459,15461,15467,15465,-1,15463,15462,15468,15469,-1,15462,15464,15470,15468,-1,15466,15465,15471,15472,-1,15465,15467,15473,15471,-1,15469,15468,15474,-1,15468,15470,15472,15474,-1,15411,15421,15418,15417,-1,15475,15476,15477,15478,-1,15472,15477,15476,15474,-1,15475,15478,15471,15473,-1,15473,15474,15476,15475,-1,15478,15477,15472,15471,-1,15474,15473,15467,15469,-1,15469,15467,15461,15463,-1,15463,15461,15455,15457,-1,15457,15455,15449,15451,-1,15451,15449,15443,15445,-1,15445,15443,15437,15439,-1,15439,15437,15431,15433,-1,15433,15431,15425,15427,-1,15427,15425,15416,15420,-1,15420,15416,15415,15417,-1,15417,15415,15412,15411,-1,15472,15470,15466,-1,15466,15470,15464,15460,-1,15460,15464,15458,15454,-1,15454,15458,15452,15448,-1,15448,15452,15446,15442,-1,15442,15446,15440,15436,-1,15436,15440,15434,15430,-1,15430,15434,15428,15424,-1,15424,15428,15422,15414,-1,15414,15422,15421,15411,-1,15479,15480,15481,15482,-1,15480,15483,15484,15481,-1,15485,15486,15487,15488,-1,15486,15489,15490,15487,-1,15482,15481,15491,15492,-1,15481,15484,15493,15491,-1,15488,15487,15494,15495,-1,15487,15490,15496,15494,-1,15492,15491,15497,15498,-1,15491,15493,15499,15497,-1,15495,15494,15500,15501,-1,15494,15496,15502,15500,-1,15498,15497,15503,15504,-1,15497,15499,15505,15503,-1,15501,15500,15506,15507,-1,15500,15502,15508,15506,-1,15504,15503,15509,15510,-1,15503,15505,15511,15509,-1,15507,15506,15512,15513,-1,15506,15508,15514,15512,-1,15510,15509,15515,15516,-1,15509,15511,15517,15515,-1,15513,15512,15518,15519,-1,15512,15514};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_77()
		{
			int[] value = {15520,15518,-1,15516,15515,15521,15522,-1,15515,15517,15523,15521,-1,15519,15518,15524,15525,-1,15518,15520,15526,15524,-1,15522,15521,15527,15528,-1,15521,15523,15529,15527,-1,15525,15524,15530,15531,-1,15524,15526,15532,15530,-1,15528,15527,15533,15534,-1,15527,15529,15535,15533,-1,15531,15530,15536,15537,-1,15530,15532,15538,15536,-1,15534,15533,15539,15540,-1,15533,15535,15541,15539,-1,15537,15536,15542,-1,15536,15538,15540,15542,-1,15479,15489,15486,15485,-1,15543,15544,15545,15546,-1,15540,15545,15544,15542,-1,15543,15546,15539,15541,-1,15541,15542,15544,15543,-1,15546,15545,15540,15539,-1,15542,15541,15535,15537,-1,15537,15535,15529,15531,-1,15531,15529,15523,15525,-1,15525,15523,15517,15519,-1,15519,15517,15511,15513,-1,15513,15511,15505,15507,-1,15507,15505,15499,15501,-1,15501,15499,15493,15495,-1,15495,15493,15484,15488,-1,15488,15484,15483,15485,-1,15485,15483,15480,15479,-1,15540,15538,15534,-1,15534,15538,15532,15528,-1,15528,15532,15526,15522,-1,15522,15526,15520,15516,-1,15516,15520,15514,15510,-1,15510,15514,15508,15504,-1,15504,15508,15502,15498,-1,15498,15502,15496,15492,-1,15492,15496,15490,15482,-1,15482,15490,15489,15479,-1,15041,15042,15098,15099,-1,15097,15005,15100,15101,-1,15041,15099,15115,15102,-1,15099,15098,15116,15115,-1,15101,15116,15098,15097,-1,15117,15095,15108,15118,-1,15119,15120,15121,15122,-1,15123,15119,15122,15124,-1,15125,15123,15124,15126,-1,15127,15125,15126,15128,-1,15129,15127,15128,15130,-1,15131,15132,15133,-1,15134,15135,15132,15136,-1,15137,15138,15139,15140,-1,15141,15142,15143,15144,-1,15145,15146,15147,15148,-1,15149,15150,15151,15152,-1,15153,15154,15155,15156,-1,15157,15158,15159,15160,-1,15131,15133,15161,15162,-1,15163,15134,15136,15164,-1,15140,15139,15165,15166,-1,15144,15143,15167,15168,-1,15148,15147,15169,15170,-1,15152,15151,15171,15172,-1,15156,15155,15173,15174,-1,15160,15159,15175,15176,-1,15165,15177,15178,15166,-1,15168,15167,15178,15179,-1,15170,15169,15180,15117,-1,15172,15171,15117,15118,-1,15174,15173,15181,15182,-1,15120,15183,15184,15185,-1,15164,15186,15177,15163,-1,15113,15112,15162,15161,-1,15182,15181,15107,-1,15095,15117,15180,-1,15110,15096,15178,15177,-1,15101,15100,15187,-1,15188,15114,15113,15161,-1,15547,15548,15549,15550,15551,15552,15553,15554,-1,15161,15133,15189,15188,-1,15190,15191,15192,-1,15123,15125,15193,15194,-1,15120,15119,15183,-1,15195,15187,15190,15192,-1,15190,15187,15188,-1,15187,15100,15114,15188,-1,15183,15119,15123,15194,-1,15132,15131,15136,-1,15131,15162,15164,15136,-1,15164,15162,15186,-1,15162,15112,15111,15186,-1,15196,15197,15194,15193,-1,15197,15184,15183,15194,-1,15175,15182,15198,15176,-1,15106,15105,15185,15198,-1,15195,15122,15121,15199,-1,15188,15189,15190,-1,15135,15134,15139,15138,-1,15134,15163,15165,15139,-1,15144,15168,15169,15147,-1,15141,15144,15147,15146,-1,15168,15179,15180,15169,-1,15149,15152,15155,15154,-1,15152,15172,15173,15155,-1,15157,15160,15197,15196,-1,15160,15176,15184,15197,-1,15172,15118,15181,15173,-1,15108,15107,15181,15118,-1,15180,15179,15109,15095,-1,15165,15163,15177,-1,15198,15185,15184,15176,-1,15104,15103,15121,15120,-1,15192,15191,15126,15124,-1,15200,15159,15158,15201,-1,15156,15200,15201,15153,-1,15202,15175,15159,15200,-1,15174,15202,15200,15156,-1,15203,15151,15150,15204,-1,15148,15203,15204,15145,-1,15205,15171,15151,15203,-1,15170,15205,15203,15148,-1,15206,15143,15142,15207,-1,15140,15206,15207,15137,-1,15208,15167,15143,15206,-1,15166,15208,15206,15140,-1,15208,15178,15167,-1,15205,15117,15171,-1,15202,15182,15175,-1,15195,15192,15124,15122,-1,15202,15174,15182,-1,15205,15170,15117,-1,15208,15166,15178,-1,15209,15210,15133,15132,-1,15211,15209,15132,15135,-1,15212,15211,15135,15138,-1,15213,15212,15138,15137,-1,15214,15213,15137,15207,-1,15215,15214,15207,15142,-1,15216,15215,15142,15141,-1,15217,15216,15141,15146,-1,15218,15217,15146,15145,-1,15219,15218,15145,15204,-1,15220,15219,15204,15150,-1,15221,15220,15150,15149,-1,15222,15221,15149,15154,-1,15223,15222,15154,15153,-1,15224,15223,15153,15201,-1,15225,15224,15201,15158,-1,15226,15225,15158,15157,-1,15227,15226,15157,15196,-1,15228,15227,15196,15193,-1,15127,15228,15193,15125,-1,15229,15128,15126,15191,-1,15230,15229,15191,15190,-1,15231,15230,15190,15189,-1,15210,15231,15189,15133,-1,15232,15233,15210,15209,-1,15234,15232,15209,15211,-1,15235,15234,15211,15212,-1,15236,15235,15212,15213,-1,15237,15236,15213,15214,-1,15238,15237,15214,15215,-1,15239,15238,15215,15216,-1,15240,15239,15216,15217,-1,15241,15240,15217,15218,-1,15242,15241,15218,15219,-1,15243,15242,15219,15220,-1,15244,15243,15220,15221,-1,15245,15244,15221,15222,-1,15246,15245,15222,15223,-1,15247,15246,15223,15224,-1,15248,15247,15224,15225,-1,15249,15248,15225,15226,-1,15250,15249,15226,15227,-1,15251,15250,15227,15228,-1,15129,15251,15228,15127,-1,15252,15130,15128,15229,-1,15253,15252,15229,15230,-1,15254,15253,15230,15231,-1,15233,15254,15231,15210,-1,15555,15556,15557,15558,15559,15560,15561,15562,-1,15563,15564,15565,15566,15567,15568,15569,15570,-1,15571,15572,15573,15574,15575,15576,15577,15578,-1,15579,15580,15581,15582,15583,15584,15585,15586,15587,15588,15589,-1,15255,15237,15256,-1,15256,15257,15258,-1,15259,15247,15260,-1,15129,15130,15261,15262,-1,15254,15233,15263,-1,15257,15242,15258,-1,15130,15252,15261,-1,15264,15265,15253,15254,-1,15266,15264,15254,15263,-1,15267,15266,15263,15255,-1,15268,15267,15255,15256};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_78()
		{
			int[] value = {-1,15269,15268,15256,15258,-1,15270,15269,15258,15259,-1,15271,15270,15259,15260,-1,15272,15271,15260,15262,-1,15273,15272,15262,15261,-1,15274,15273,15261,15252,-1,15265,15274,15252,15253,-1,15553,15552,15590,15591,-1,15554,15553,15591,15592,-1,15547,15554,15592,15593,-1,15548,15547,15593,15594,-1,15549,15548,15594,15595,-1,15550,15549,15595,15596,-1,15551,15550,15596,15597,-1,15552,15551,15597,15590,-1,15561,15560,15598,15599,-1,15562,15561,15599,15600,-1,15555,15562,15600,15601,-1,15556,15555,15601,15591,-1,15557,15556,15591,15602,-1,15558,15557,15602,15603,-1,15559,15558,15603,15604,-1,15560,15559,15604,15598,-1,15569,15568,15605,15594,-1,15570,15569,15594,15606,-1,15563,15570,15606,15607,-1,15564,15563,15607,15608,-1,15565,15564,15608,15609,-1,15566,15565,15609,15610,-1,15567,15566,15610,15611,-1,15568,15567,15611,15605,-1,15577,15576,15612,15608,-1,15578,15577,15608,15613,-1,15571,15578,15613,15614,-1,15572,15571,15614,15615,-1,15573,15572,15615,15616,-1,15574,15573,15616,15617,-1,15575,15574,15617,15618,-1,15576,15575,15618,15612,-1,15103,15102,15121,-1,15179,15178,15096,15109,-1,15177,15186,15111,15110,-1,15198,15182,15107,15106,-1,15120,15185,15105,15104,-1,15102,15115,15199,15121,-1,15115,15116,15199,-1,15199,15116,15195,-1,15187,15195,15116,15101,-1,15619,5,15620,15621,-1,15622,15623,15621,15620,-1,15624,15625,15623,15622,-1,15628,15627,15626,-1,15718,15719,15629,-1,15630,15631,15720,15632,-1,15632,15720,15718,15629,-1,15633,15721,15631,15630,-1,15634,15635,15721,15633,-1,15636,15637,15635,15634,-1,15638,15639,15637,15636,-1,15639,15638,15625,15722,-1,15624,15716,15722,15625,-1,15716,15624,15640,15717,-1,15717,15640,15641,15723,-1,15723,15641,15642,15724,-1,15725,15643,15644,15726,-1,15726,15644,15645,15646,-1,15646,15645,15647,15648,-1,15648,15647,15649,15727,-1,15727,15649,15650,15728,-1,15728,15650,15651,15729,-1,15729,15651,15629,15719,-1,15642,15643,15725,15724,-1,15643,15642,15652,15653,-1,15654,15655,15656,15657,-1,15658,15659,15657,15656,-1,15659,15658,15645,15644,-1,15660,15655,15654,-1,15662,15661,31,15663,-1,15664,15662,15663,15665,-1,15669,15670,15671,15668,-1,30,52,15672,31,-1,15673,15630,15632,15674,-1,15675,15676,15677,-1,15633,15678,15679,15634,-1,15680,15681,15682,15683,-1,15655,15680,15683,15656,-1,15686,15663,31,15672,-1,15629,15687,15674,15632,-1,15688,15689,15690,-1,15680,15689,15688,15681,-1,15647,15691,15692,15649,-1,15650,15649,15692,-1,15685,15662,15664,-1,15693,15665,15663,15686,-1,15651,15694,15687,15629,-1,15688,15690,15684,15664,-1,15681,15688,15664,15665,-1,15682,15681,15665,15693,-1,15650,15692,15694,15651,-1,15660,34,15666,-1,15695,34,15660,15696,-1,15626,15695,15696,15628,-1,15627,15628,15669,-1,15654,15696,15660,-1,15667,15690,15689,15666,-1,15655,15689,15680,-1,15645,15658,15691,15647,-1,15697,15696,15654,15657,-1,15698,15628,15696,15697,-1,15670,15669,15628,15698,-1,15642,15641,15699,15652,-1,15700,15701,15668,15671,-1,5,55,15702,15620,-1,15625,15638,15676,15623,-1,15638,15636,15677,15676,-1,15675,15677,82,-1,15677,15636,15634,15679,-1,15630,15673,15678,15633,-1,15704,15640,15705,-1,15702,55,86,15706,-1,15706,86,15701,15700,-1,15704,15707,15641,15640,-1,15703,15676,15675,-1,15621,15623,15676,15703,-1,15702,15705,15622,15620,-1,15706,15704,15705,15702,-1,15700,15707,15704,15706,-1,15671,15699,15707,15700,-1,15670,15699,15671,-1,15698,15652,15699,15670,-1,15697,15653,15652,15698,-1,15657,15659,15653,15697,-1,15683,15691,15658,15656,-1,15682,15692,15691,15683,-1,15693,15694,15692,15682,-1,15686,15687,15694,15693,-1,15672,15674,15687,15686,-1,52,15673,15674,15672,-1,85,15678,15673,52,-1,15655,15660,15666,15689,-1,15640,15624,15622,15705,-1,15707,15699,15641,-1,15653,15659,15644,15643,-1,15709,15708,15710,15711,-1,15711,15710,15712,15713,-1,15714,15715,15713,15712,-1,15716,15717,15715,15714,-1,15724,15725,15730,15731,-1,15731,15730,15732,15733,-1,15734,15735,15733,15732,-1,15735,15734,15736,15737,-1,15805,15806,15737,15736,-1,15726,15646,15738,15739,-1,15739,15738,15740,15741,-1,15741,15740,15742,15743,-1,15744,15743,15742,-1,15746,15747,15710,15708,-1,15748,15749,15750,-1,15751,15749,15748,15752,-1,15631,15751,15752,15720,-1,15635,15753,15751,15721,-1,15754,15718,15720,15752,-1,15752,15748,15754,-1,15719,15718,15755,15756,-1,15757,15758,15759,15760,-1,15761,15757,15760,15762,-1,15762,15756,15755,15761,-1,15754,15755,15718,-1,15761,15755,15754,15748,-1,15756,15762,15763,-1,15760,15764,15763,15762,-1,15765,15764,15760,15759,-1,15728,15766,15767,15727,-1,15740,15738,15767,-1,15742,15740,15768,15769,-1,15744,15742,15769,15770,-1,15732,15730,15739,15741,-1,15736,15734,15743,15744,-1,15771,15772,15731,15733,-1,15773,15771,15733,15735,-1,15774,15773,15735,15737,-1,15775,15729,15719,15756,-1,15776,15775,15756,15763,-1,15777,15776,15763,15764,-1,15778,15777,15764,15765,-1,15766,15728,15729,15775,-1,15768,15766,15775,15776,-1,15769,15768,15776,15777,-1,15770,15769,15777,15778,-1,15646,15648,15738,-1,15730,15725,15726,15739,-1,15772,15723,15724,15731,-1,15772,15715,15717,15723,-1,15713,15715,15772,15771,-1,15711,15713,15771,15773,-1,15709,15711,15773,15774,-1,15741,15743,15734,15732,-1,15779,15780,15781,15874,-1,15782,15780,15779,15783,-1,15784,15782,15783,15753,-1,15747,15746,15781,15780,-1,15712,15710,15747,-1,15714,15712,15782,15784,-1,15639,15784,15637,-1,15722,15716,15714,-1,15779,15874,15785};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_79()
		{
			int[] value = {15750,-1,15783,15779,15750,15749,-1,15751,15753,15783,15749,-1,15751,15631,15721,-1,15637,15784,15753,15635,-1,15758,15757,15750,15785,-1,15748,15750,15757,15761,-1,15785,15745,15856,15758,-1,15874,15877,15745,15785,-1,15737,15806,15786,15774,-1,15744,15880,15805,15736,-1,15770,15787,15880,15744,-1,15778,15851,15787,15770,-1,15765,15852,15851,15778,-1,15759,15854,15852,15765,-1,15758,15856,15854,15759,-1,15767,15766,15768,15740,-1,15648,15727,15767,15738,-1,15714,15784,15639,15722,-1,15747,15780,15782,15712,-1,15788,15789,15790,-1,15791,15792,15793,15794,-1,15885,15795,15886,-1,15796,15797,15798,15799,-1,15797,15796,15800,15801,-1,15802,15803,15799,15798,-1,15803,15802,15708,15709,-1,15804,15801,15800,-1,15806,15805,15807,15808,-1,15808,15807,15809,15810,-1,15810,15809,15811,15812,-1,15813,15812,15811,-1,15814,15815,15816,15817,-1,15795,15818,15819,-1,15820,15821,15822,15823,-1,15824,15825,15826,15827,-1,15828,15829,15830,15789,-1,15831,15886,15816,15815,-1,15795,15832,15886,-1,15818,15795,15885,-1,15833,15822,15821,-1,15834,15826,15825,-1,15792,15835,15793,-1,15794,15793,15827,15826,-1,15824,15827,15836,-1,15825,15824,15823,15822,-1,15837,15820,15823,-1,15821,15820,15819,15818,-1,15817,15816,15832,15838,-1,15791,15839,15840,15792,-1,15828,15789,15788,-1,15829,15828,15841,15842,-1,15843,15888,15815,15814,-1,15814,15817,15844,-1,15801,15804,15843,-1,15800,15845,15804,-1,15846,15813,15811,-1,15789,15830,15790,-1,15812,15813,15790,-1,15889,15888,15843,15804,-1,15819,15838,15832,-1,15832,15795,15819,-1,15835,15792,15840,-1,15847,15835,15840,-1,15848,15830,15829,-1,15849,15850,15851,15852,-1,15853,15849,15852,15854,-1,15855,15853,15854,15856,-1,15857,15855,15856,15745,-1,15849,15853,15858,-1,15820,15837,15859,15819,-1,15855,15860,15858,15853,-1,15790,15830,15812,-1,15816,15886,15832,-1,15815,15888,15831,-1,15861,15862,15863,15864,-1,15809,15807,15862,15861,-1,15811,15809,15861,15865,-1,15846,15811,15865,15866,-1,15810,15848,15867,15808,-1,15830,15848,15810,15812,-1,15850,15849,15858,15847,-1,15835,15847,15858,15836,-1,15793,15835,15836,15827,-1,15864,15863,15850,15847,-1,15865,15861,15864,15868,-1,15866,15865,15868,-1,15796,15799,15867,15848,-1,15800,15796,15848,15829,-1,15828,15788,15841,-1,15844,15817,15838,15869,-1,15870,15844,15869,15871,-1,15871,15872,15873,15870,-1,15797,15801,15844,15870,-1,15875,15798,15797,-1,15859,15837,15860,15876,-1,15872,15871,15876,15857,-1,15860,15837,15836,15858,-1,15855,15857,15876,15860,-1,15824,15836,15837,15823,-1,15826,15834,15794,-1,15845,15800,15829,15842,-1,15833,15834,15825,15822,-1,15885,15833,15821,15818,-1,15843,15814,15844,15801,-1,15781,15878,15877,15874,-1,15746,15879,15878,15781,-1,15708,15802,15879,15746,-1,15774,15786,15803,15709,-1,15862,15880,15787,15863,-1,15807,15805,15880,15862,-1,15867,15786,15806,15808,-1,15799,15803,15786,15867,-1,15875,15879,15802,15798,-1,15879,15875,15873,15878,-1,15878,15873,15872,15877,-1,15851,15850,15863,15787,-1,15857,15745,15877,15872,-1,15797,15870,15873,15875,-1,15859,15869,15838,15819,-1,15876,15871,15869,15859,-1,15868,15840,15839,15866,-1,15864,15847,15840,15868,-1,15889,15804,15881,15892,-1,15881,15804,15845,15893,-1,15893,15845,15842,15882,-1,15882,15842,15841,15894,-1,15894,15841,15788,15883,-1,15883,15788,15790,15895,-1,15895,15790,15813,15896,-1,15896,15813,15846,15897,-1,15897,15846,15866,15898,-1,15898,15866,15839,15899,-1,15899,15839,15791,15884,-1,15884,15791,15794,15900,-1,15900,15794,15834,15901,-1,15901,15834,15833,15902,-1,15902,15833,15885,15891,-1,16063,16064,16065,16066,-1,16064,16067,16068,16065,-1,16069,16070,16071,16072,-1,16070,16073,16074,16071,-1,16075,16076,16064,16063,-1,16076,16077,16067,16064,-1,16078,16079,16070,16069,-1,16079,16080,16073,16070,-1,16081,16082,16076,16075,-1,16082,16083,16077,16076,-1,16084,16085,16079,16078,-1,16085,16086,16080,16079,-1,16087,16088,16082,16081,-1,16088,16089,16083,16082,-1,16090,16091,16085,16084,-1,16091,16092,16086,16085,-1,16093,16094,16088,16087,-1,16094,16095,16089,16088,-1,16096,16097,16091,16090,-1,16097,16098,16092,16091,-1,16099,16100,16094,16093,-1,16100,16101,16095,16094,-1,16102,16103,16097,16096,-1,16103,16104,16098,16097,-1,16105,16106,16100,16099,-1,16106,16107,16101,16100,-1,16108,16109,16103,16102,-1,16109,16110,16104,16103,-1,16111,16112,16106,16105,-1,16112,16113,16107,16106,-1,16114,16115,16109,16108,-1,16115,16116,16110,16109,-1,16117,16118,16112,16111,-1,16118,16119,16113,16112,-1,16120,16121,16115,16114,-1,16121,16122,16116,16115,-1,16123,16124,16118,16117,-1,16124,16125,16119,16118,-1,16126,16121,16120,-1,16126,16123,16122,16121,-1,16072,16071,16074,16066,-1,16127,16128,16129,16130,-1,16126,16129,16128,16123,-1,16125,16124,16127,16130,-1,16130,16129,16126,16125,-1,16124,16123,16128,16127,-1,16120,16119,16125,16126,-1,16114,16113,16119,16120,-1,16108,16107,16113,16114,-1,16102,16101,16107,16108,-1,16096,16095,16101,16102,-1,16090,16089,16095,16096,-1,16084,16083,16089,16090,-1,16078,16077,16083,16084,-1,16069,16067,16077,16078,-1,16072,16068,16067,16069,-1,16066,16065,16068,16072,-1,16117,16122,16123,-1,16111,16116,16122,16117,-1,16105,16110,16116,16111,-1,16099,16104,16110,16105,-1,16093,16098,16104,16099,-1,16087,16092,16098,16093,-1,16081,16086,16092,16087,-1,16075,16080,16086,16081,-1,16063,16073,16080,16075,-1,16066,16074,16073,16063,-1,16131,16132,16133,16134,-1,16132,16135,16136,16133,-1,16137,16138,16139};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_80()
		{
			int[] value = {16140,-1,16138,16141,16142,16139,-1,16143,16144,16132,16131,-1,16144,16145,16135,16132,-1,16146,16147,16138,16137,-1,16147,16148,16141,16138,-1,16149,16150,16144,16143,-1,16150,16151,16145,16144,-1,16152,16153,16147,16146,-1,16153,16154,16148,16147,-1,16155,16156,16150,16149,-1,16156,16157,16151,16150,-1,16158,16159,16153,16152,-1,16159,16160,16154,16153,-1,16161,16162,16156,16155,-1,16162,16163,16157,16156,-1,16164,16165,16159,16158,-1,16165,16166,16160,16159,-1,16167,16168,16162,16161,-1,16168,16169,16163,16162,-1,16170,16171,16165,16164,-1,16171,16172,16166,16165,-1,16173,16174,16168,16167,-1,16174,16175,16169,16168,-1,16176,16177,16171,16170,-1,16177,16178,16172,16171,-1,16179,16180,16174,16173,-1,16180,16181,16175,16174,-1,16182,16183,16177,16176,-1,16183,16184,16178,16177,-1,16185,16186,16180,16179,-1,16186,16187,16181,16180,-1,16188,16189,16183,16182,-1,16189,16190,16184,16183,-1,16191,16192,16186,16185,-1,16192,16193,16187,16186,-1,16194,16189,16188,-1,16194,16191,16190,16189,-1,16140,16139,16142,16134,-1,16195,16196,16197,16198,-1,16194,16197,16196,16191,-1,16193,16192,16195,16198,-1,16198,16197,16194,16193,-1,16192,16191,16196,16195,-1,16188,16187,16193,16194,-1,16182,16181,16187,16188,-1,16176,16175,16181,16182,-1,16170,16169,16175,16176,-1,16164,16163,16169,16170,-1,16158,16157,16163,16164,-1,16152,16151,16157,16158,-1,16146,16145,16151,16152,-1,16137,16135,16145,16146,-1,16140,16136,16135,16137,-1,16134,16133,16136,16140,-1,16185,16190,16191,-1,16179,16184,16190,16185,-1,16173,16178,16184,16179,-1,16167,16172,16178,16173,-1,16161,16166,16172,16167,-1,16155,16160,16166,16161,-1,16149,16154,16160,16155,-1,16143,16148,16154,16149,-1,16131,16141,16148,16143,-1,16134,16142,16141,16131,-1,16199,16200,16201,16202,-1,16200,16203,16204,16201,-1,16205,16206,16207,16208,-1,16206,16209,16210,16207,-1,16211,16212,16200,16199,-1,16212,16213,16203,16200,-1,16214,16215,16206,16205,-1,16215,16216,16209,16206,-1,16217,16218,16212,16211,-1,16218,16219,16213,16212,-1,16220,16221,16215,16214,-1,16221,16222,16216,16215,-1,16223,16224,16218,16217,-1,16224,16225,16219,16218,-1,16226,16227,16221,16220,-1,16227,16228,16222,16221,-1,16229,16230,16224,16223,-1,16230,16231,16225,16224,-1,16232,16233,16227,16226,-1,16233,16234,16228,16227,-1,16235,16236,16230,16229,-1,16236,16237,16231,16230,-1,16238,16239,16233,16232,-1,16239,16240,16234,16233,-1,16241,16242,16236,16235,-1,16242,16243,16237,16236,-1,16244,16245,16239,16238,-1,16245,16246,16240,16239,-1,16247,16248,16242,16241,-1,16248,16249,16243,16242,-1,16250,16251,16245,16244,-1,16251,16252,16246,16245,-1,16253,16254,16248,16247,-1,16254,16255,16249,16248,-1,16256,16257,16251,16250,-1,16257,16258,16252,16251,-1,16259,16260,16254,16253,-1,16260,16261,16255,16254,-1,16262,16257,16256,-1,16262,16259,16258,16257,-1,16208,16207,16210,16202,-1,16263,16264,16265,16266,-1,16262,16265,16264,16259,-1,16261,16260,16263,16266,-1,16266,16265,16262,16261,-1,16260,16259,16264,16263,-1,16256,16255,16261,16262,-1,16250,16249,16255,16256,-1,16244,16243,16249,16250,-1,16238,16237,16243,16244,-1,16232,16231,16237,16238,-1,16226,16225,16231,16232,-1,16220,16219,16225,16226,-1,16214,16213,16219,16220,-1,16205,16203,16213,16214,-1,16208,16204,16203,16205,-1,16202,16201,16204,16208,-1,16253,16258,16259,-1,16247,16252,16258,16253,-1,16241,16246,16252,16247,-1,16235,16240,16246,16241,-1,16229,16234,16240,16235,-1,16223,16228,16234,16229,-1,16217,16222,16228,16223,-1,16211,16216,16222,16217,-1,16199,16209,16216,16211,-1,16202,16210,16209,16199,-1,16267,16268,16269,16270,-1,16268,16271,16272,16269,-1,16273,16274,16275,16276,-1,16274,16277,16278,16275,-1,16279,16280,16268,16267,-1,16280,16281,16271,16268,-1,16282,16283,16274,16273,-1,16283,16284,16277,16274,-1,16285,16286,16280,16279,-1,16286,16287,16281,16280,-1,16288,16289,16283,16282,-1,16289,16290,16284,16283,-1,16291,16292,16286,16285,-1,16292,16293,16287,16286,-1,16294,16295,16289,16288,-1,16295,16296,16290,16289,-1,16297,16298,16292,16291,-1,16298,16299,16293,16292,-1,16300,16301,16295,16294,-1,16301,16302,16296,16295,-1,16303,16304,16298,16297,-1,16304,16305,16299,16298,-1,16306,16307,16301,16300,-1,16307,16308,16302,16301,-1,16309,16310,16304,16303,-1,16310,16311,16305,16304,-1,16312,16313,16307,16306,-1,16313,16314,16308,16307,-1,16315,16316,16310,16309,-1,16316,16317,16311,16310,-1,16318,16319,16313,16312,-1,16319,16320,16314,16313,-1,16321,16322,16316,16315,-1,16322,16323,16317,16316,-1,16324,16325,16319,16318,-1,16325,16326,16320,16319,-1,16327,16328,16322,16321,-1,16328,16329,16323,16322,-1,16330,16325,16324,-1,16330,16327,16326,16325,-1,16276,16275,16278,16270,-1,16331,16332,16333,16334,-1,16330,16333,16332,16327,-1,16329,16328,16331,16334,-1,16334,16333,16330,16329,-1,16328,16327,16332,16331,-1,16324,16323,16329,16330,-1,16318,16317,16323,16324,-1,16312,16311,16317,16318,-1,16306,16305,16311,16312,-1,16300,16299,16305,16306,-1,16294,16293,16299,16300,-1,16288,16287,16293,16294,-1,16282,16281,16287,16288,-1,16273,16271,16281,16282,-1,16276,16272,16271,16273,-1,16270,16269,16272,16276,-1,16321,16326,16327,-1,16315,16320,16326,16321,-1,16309,16314,16320,16315,-1,16303,16308,16314,16309,-1,16297,16302,16308,16303,-1,16291,16296,16302,16297,-1,16285,16290,16296,16291,-1,16279,16284,16290,16285,-1,16267,16277,16284,16279,-1,16270,16278,16277,16267,-1,15887,15831,15888,15889,-1,15890,15891,15885,15886,-1,15892,15903,15887,15889};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_81()
		{
			int[] value = {-1,15903,15904,15831,15887,-1,15886,15831,15904,15890,-1,15905,15895,15896,15906,-1,15907,15908,15909,15910,-1,15911,15907,15910,15912,-1,15913,15911,15912,15914,-1,15915,15913,15914,15916,-1,15917,15915,15916,15918,-1,15919,15920,15921,-1,15922,15920,15923,15924,-1,15925,15926,15927,15928,-1,15929,15930,15931,15932,-1,15933,15934,15935,15936,-1,15937,15938,15939,15940,-1,15941,15942,15943,15944,-1,15945,15946,15947,15948,-1,15949,15950,15919,15921,-1,15951,15922,15924,15952,-1,15953,15954,15926,15925,-1,15955,15956,15930,15929,-1,15957,15958,15934,15933,-1,15959,15960,15938,15937,-1,15961,15962,15942,15941,-1,15963,15964,15946,15945,-1,15953,15965,15966,15954,-1,15967,15965,15956,15955,-1,15906,15968,15958,15957,-1,15905,15906,15960,15959,-1,15969,15970,15962,15961,-1,15971,15972,15973,15909,-1,15952,15966,15974,15951,-1,15950,15949,15900,15901,-1,15883,15970,15969,-1,15968,15906,15896,-1,15966,15965,15898,15899,-1,15975,15891,15890,-1,15950,15901,15902,15976,-1,16335,16336,16337,16338,16339,16340,16341,16342,-1,15976,15977,15919,15950,-1,15978,15979,15980,-1,15981,15982,15914,15912,-1,15973,15910,15909,-1,15978,15980,15975,15983,-1,15976,15975,15980,-1,15976,15902,15891,15975,-1,15981,15912,15910,15973,-1,15922,15921,15920,-1,15922,15951,15949,15921,-1,15974,15949,15951,-1,15974,15884,15900,15949,-1,15982,15981,15984,15985,-1,15981,15973,15972,15984,-1,15963,15986,15969,15964,-1,15986,15971,15882,15894,-1,15987,15908,15907,15983,-1,15980,15977,15976,-1,15927,15926,15924,15923,-1,15926,15954,15952,15924,-1,15934,15958,15955,15929,-1,15935,15934,15929,15932,-1,15958,15968,15967,15955,-1,15943,15942,15937,15940,-1,15942,15962,15959,15937,-1,15985,15984,15945,15948,-1,15984,15972,15963,15945,-1,15962,15970,15905,15959,-1,15905,15970,15883,15895,-1,15896,15897,15967,15968,-1,15966,15952,15954,-1,15963,15972,15971,15986,-1,15909,15908,15881,15893,-1,15911,15913,15979,15978,-1,15988,15947,15946,15989,-1,15944,15988,15989,15941,-1,15989,15946,15964,15990,-1,15941,15989,15990,15961,-1,15991,15939,15938,15992,-1,15936,15991,15992,15933,-1,15992,15938,15960,15993,-1,15933,15992,15993,15957,-1,15994,15931,15930,15995,-1,15928,15994,15995,15925,-1,15995,15930,15956,15996,-1,15925,15995,15996,15953,-1,15956,15965,15996,-1,15960,15906,15993,-1,15964,15969,15990,-1,15907,15911,15978,15983,-1,15969,15961,15990,-1,15906,15957,15993,-1,15965,15953,15996,-1,15920,15919,15997,15998,-1,15923,15920,15998,15999,-1,15927,15923,15999,16000,-1,15928,15927,16000,16001,-1,15994,15928,16001,16002,-1,15931,15994,16002,16003,-1,15932,15931,16003,16004,-1,15935,15932,16004,16005,-1,15936,15935,16005,16006,-1,15991,15936,16006,16007,-1,15939,15991,16007,16008,-1,15940,15939,16008,16009,-1,15943,15940,16009,16010,-1,15944,15943,16010,16011,-1,15988,15944,16011,16012,-1,15947,15988,16012,16013,-1,15948,15947,16013,16014,-1,15985,15948,16014,16015,-1,15982,15985,16015,16016,-1,15914,15982,16016,15916,-1,15979,15913,15915,16017,-1,15980,15979,16017,16018,-1,15977,15980,16018,16019,-1,15919,15977,16019,15997,-1,15998,15997,16020,16021,-1,15999,15998,16021,16022,-1,16000,15999,16022,16023,-1,16001,16000,16023,16024,-1,16002,16001,16024,16025,-1,16003,16002,16025,16026,-1,16004,16003,16026,16027,-1,16005,16004,16027,16028,-1,16006,16005,16028,16029,-1,16007,16006,16029,16030,-1,16008,16007,16030,16031,-1,16009,16008,16031,16032,-1,16010,16009,16032,16033,-1,16011,16010,16033,16034,-1,16012,16011,16034,16035,-1,16013,16012,16035,16036,-1,16014,16013,16036,16037,-1,16015,16014,16037,16038,-1,16016,16015,16038,16039,-1,15916,16016,16039,15918,-1,16017,15915,15917,16040,-1,16018,16017,16040,16041,-1,16019,16018,16041,16042,-1,15997,16019,16042,16020,-1,16343,16344,16345,16346,16347,16348,16349,16350,-1,16351,16352,16353,16354,16355,16356,16357,16358,-1,16359,16360,16361,16362,16363,16364,16365,16366,-1,16367,16368,16369,16370,16371,16372,16373,16374,16375,16376,16377,-1,16043,16025,16044,-1,16045,16046,16043,-1,16047,16035,16048,-1,16049,16050,15917,15918,-1,16051,16020,16042,-1,16045,16030,16046,-1,16050,16040,15917,-1,16042,16041,16052,16053,-1,16051,16042,16053,16054,-1,16044,16051,16054,16055,-1,16043,16044,16055,16056,-1,16045,16043,16056,16057,-1,16048,16045,16057,16058,-1,16047,16048,16058,16059,-1,16049,16047,16059,16060,-1,16050,16049,16060,16061,-1,16040,16050,16061,16062,-1,16041,16040,16062,16052,-1,16378,16379,16337,16336,-1,16380,16378,16336,16335,-1,16381,16380,16335,16342,-1,16382,16381,16342,16341,-1,16383,16382,16341,16340,-1,16384,16383,16340,16339,-1,16385,16384,16339,16338,-1,16379,16385,16338,16337,-1,16386,16387,16345,16344,-1,16388,16386,16344,16343,-1,16389,16388,16343,16350,-1,16378,16389,16350,16349,-1,16390,16378,16349,16348,-1,16391,16390,16348,16347,-1,16392,16391,16347,16346,-1,16387,16392,16346,16345,-1,16382,16393,16353,16352,-1,16394,16382,16352,16351,-1,16395,16394,16351,16358,-1,16396,16395,16358,16357,-1,16397,16396,16357,16356,-1,16398,16397,16356,16355,-1,16399,16398,16355,16354,-1,16393,16399,16354,16353,-1,16396,16400,16361,16360,-1,16401,16396,16360,16359,-1,16402,16401,16359,16366,-1,16403,16402,16366,16365,-1,16404,16403,16365,16364,-1,16405,16404,16364,16363,-1,16406,16405,16363,16362,-1,16400,16406,16362,16361,-1,15908,15892,15881,-1,15897,15898,15965,15967,-1,15899,15884,15974,15966,-1,15894,15883,15969,15986,-1,15893,15882,15971,15909,-1,15908,15987,15903,15892,-1,15987,15904,15903,-1,15983};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_82()
		{
			int[] value = {15904,15987,-1,15890,15904,15983,15975,-1,16407,16408,16409,16410,-1,16408,16411,16412,16409,-1,16411,16413,16414,16412,-1,16415,16407,16410,16416,-1,16417,16415,16416,16418,-1,16419,16417,16418,16420,-1,16413,16421,16422,16414,-1,16421,16423,16424,16422,-1,16425,16419,16420,16426,-1,16423,16425,16426,16424,-1,16427,16443,16444,16428,-1,16428,16444,16445,16429,-1,16429,16445,16446,16430,-1,16430,16446,16447,16431,-1,16431,16447,16448,16432,-1,16432,16448,16449,16433,-1,16409,16433,16434,16410,-1,16434,16450,16451,16435,-1,16435,16451,16452,16436,-1,16436,16452,16443,16427,-1,16435,16416,16410,16434,-1,16436,16418,16416,16435,-1,16427,16420,16418,16436,-1,16428,16426,16420,16427,-1,16429,16424,16426,16428,-1,16430,16422,16424,16429,-1,16431,16414,16422,16430,-1,16432,16412,16414,16431,-1,16433,16409,16412,16432,-1,16433,16449,16450,16434,-1,16425,16423,16437,163,-1,16419,16425,163,164,-1,170,16407,16415,16439,-1,16439,16415,16417,16438,-1,16438,16417,16419,164,-1,16440,16437,16423,16421,-1,16441,16440,16421,16413,-1,16442,16408,16407,170,-1,173,16411,16408,16442,-1,16441,16413,16411,173,-1,16453,16454,16455,16456,-1,16456,16455,16457,16458,-1,16458,16457,16459,16460,-1,16460,16459,16461,16462,-1,16462,16461,16463,16464,-1,16464,16463,16465,16466,-1,16466,16465,16467,16468,-1,16468,16467,16469,16470,-1,16470,16469,16471,16472,-1,16472,16471,16454,16453,-1,16457,16473,16474,16459,-1,16475,16461,16459,16474,-1,16476,16463,16461,16475,-1,16477,16465,16463,16476,-1,16478,16467,16465,16477,-1,16479,16469,16467,16478,-1,16480,16471,16469,16479,-1,16481,16454,16471,16480,-1,16482,16455,16454,16481,-1,16473,16457,16455,16482,-1,16470,16451,16450,16468,-1,16472,16452,16451,16470,-1,16453,16443,16452,16472,-1,16456,16444,16443,16453,-1,16458,16445,16444,16456,-1,16460,16446,16445,16458,-1,16462,16447,16446,16460,-1,16464,16448,16447,16462,-1,16466,16449,16448,16464,-1,16468,16450,16449,16466,-1,16474,16483,16484,16475,-1,16475,16484,16485,16476,-1,16476,16485,16486,16477,-1,16477,16486,16487,16478,-1,16488,16489,16490,16483,-1,16483,16490,16491,16484,-1,16484,16491,16492,16485,-1,16485,16492,16493,16486,-1,16486,16493,16494,16487,-1,16473,16488,16483,16474,-1,16493,16520,16522,16494,-1,16492,16518,16520,16493,-1,16491,16516,16518,16492,-1,16490,16514,16516,16491,-1,16489,16511,16514,16490,-1,16481,16495,16496,16482,-1,16482,16496,16488,16473,-1,16478,16487,16497,16479,-1,16479,16497,16498,16480,-1,16480,16498,16495,16481,-1,16495,16499,16500,16496,-1,16496,16500,16489,16488,-1,16487,16494,16501,16497,-1,16501,16535,16537,16502,-1,16498,16502,16499,16495,-1,16494,16522,16535,16501,-1,16500,16533,16511,16489,-1,16499,16530,16533,16500,-1,16502,16537,16530,16499,-1,16502,16498,16497,16501,-1,16538,16503,16504,16505,-1,16506,16507,16620,16541,-1,16505,16506,16541,16538,-1,16508,16504,16503,16509,-1,16507,16510,16622,16620,-1,16511,16512,16513,16514,-1,16514,16513,16515,16516,-1,16516,16515,16517,16518,-1,16518,16517,16519,16520,-1,16520,16519,16521,16522,-1,16517,16505,16504,16519,-1,16515,16506,16505,16517,-1,16513,16507,16506,16515,-1,16512,16510,16507,16513,-1,16519,16504,16508,16521,-1,16523,16524,16525,16625,-1,16510,16523,16625,16622,-1,16526,16527,16528,16529,-1,16524,16526,16529,16525,-1,16509,16528,16527,16508,-1,16530,16531,16532,16533,-1,16533,16532,16512,16511,-1,16522,16521,16534,16535,-1,16535,16534,16536,16537,-1,16537,16536,16531,16530,-1,16532,16523,16510,16512,-1,16531,16524,16523,16532,-1,16536,16526,16524,16531,-1,16534,16527,16526,16536,-1,16521,16508,16527,16534,-1,16503,16538,16539,16540,-1,16538,16541,16542,16539,-1,16509,16503,16540,16543,-1,16544,16545,16529,16528,-1,16545,16546,16525,16529,-1,16543,16544,16528,16509,-1,16547,16548,16549,-1,16550,16549,16548,-1,16551,16550,16548,16552,-1,16553,16554,16555,-1,16555,16556,16557,16553,-1,16558,16559,16547,-1,16560,16561,16562,-1,16563,16561,16560,-1,16564,16565,16539,-1,16564,16551,16552,16565,-1,16548,16559,16566,16567,-1,16552,16548,16567,16568,-1,16565,16552,16568,16569,-1,16569,16539,16565,-1,16570,16571,16572,16573,-1,16574,16573,16572,-1,16571,16569,16568,-1,16568,16567,16572,16571,-1,16567,16575,16574,16572,-1,16575,16555,16573,16574,-1,16555,16554,16570,16573,-1,16570,16554,16576,-1,16577,16566,16559,-1,16558,16578,16577,16559,-1,16578,16579,16566,16577,-1,16566,16579,16567,-1,16580,16579,16578,-1,16581,16561,16580,-1,16580,16578,16582,16581,-1,16581,16562,16561,-1,16575,16579,16580,16561,-1,16583,16575,16561,16563,-1,16579,16575,16567,-1,16559,16548,16547,-1,16556,16555,16575,16583,-1,16550,16551,16549,-1,16584,16554,16553,16557,-1,16576,16569,16571,16570,-1,16564,16585,16549,16551,-1,16586,16576,16554,16584,-1,16540,16539,16569,16576,-1,16539,16542,16585,16564,-1,16543,16540,16576,16586,-1,16587,16562,16581,16582,-1,16588,16589,16590,-1,16589,16588,16591,-1,16592,16589,16591,16593,-1,16594,16595,16596,-1,16596,16557,16556,16594,-1,16590,16597,16598,-1,16562,16599,16560,-1,16560,16599,16563,-1,16545,16600,16601,-1,16600,16592,16593,16601,-1,16602,16603,16597,16589,-1,16604,16602,16589,16592,-1,16605,16604,16592,16600,-1,16600,16545,16605,-1,16606,16607,16608,16609,-1,16607,16606,16610,-1,16604,16605,16608,-1,16608,16607,16602,16604,-1,16607,16610,16611,16602,-1,16610,16606,16594,16611,-1,16606,16609,16595,16594,-1,16612,16595,16609,-1,16597,16603,16613,-1,16597,16613,16614,16598,-1,16613,16603,16615};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_texCoordIndex_83()
		{
			int[] value = {16614,-1,16602,16615,16603,-1,16614,16615,16616,-1,16616,16599,16617,-1,16617,16618,16614,16616,-1,16599,16562,16617,-1,16599,16616,16615,16611,-1,16563,16599,16611,16583,-1,16602,16611,16615,-1,16590,16589,16597,-1,16583,16611,16594,16556,-1,16588,16593,16591,-1,16557,16596,16595,16584,-1,16609,16608,16605,16612,-1,16593,16588,16619,16601,-1,16584,16595,16612,16586,-1,16612,16605,16545,16544,-1,16601,16619,16546,16545,-1,16586,16612,16544,16543,-1,16618,16617,16562,16587,-1,16541,16620,16621,16542,-1,16620,16622,16623,16621,-1,16546,16624,16625,16525,-1,16624,16623,16622,16625,-1,16626,16627,16628,-1,16626,16628,16585,-1,16549,16585,16628,-1,16629,16630,16631,16632,-1,16631,16630,16633,-1,16634,16635,16636,-1,16636,16628,16637,-1,16637,16633,16634,16636,-1,16633,16547,16635,16634,-1,16635,16547,16549,-1,16558,16547,16633,-1,16582,16578,16630,-1,16630,16629,16587,16582,-1,16558,16633,16630,16578,-1,16633,16638,16632,16631,-1,16637,16639,16638,16633,-1,16549,16628,16636,16635,-1,16628,16640,16639,16637,-1,16626,16585,16627,-1,16627,16641,16640,16628,-1,16542,16621,16627,16585,-1,16621,16623,16641,16627,-1,16642,16643,16644,-1,16619,16642,16644,-1,16642,16619,16588,-1,16632,16645,16646,16629,-1,16647,16646,16645,-1,16648,16649,16650,-1,16651,16642,16648,-1,16648,16650,16647,16651,-1,16650,16649,16590,16647,-1,16588,16590,16649,-1,16647,16590,16598,-1,16646,16614,16618,-1,16618,16587,16629,16646,-1,16614,16646,16647,16598,-1,16645,16632,16638,16647,-1,16647,16638,16639,16651,-1,16649,16648,16642,16588,-1,16651,16639,16640,16642,-1,16643,16619,16644,-1,16642,16640,16641,16643,-1,16619,16643,16624,16546,-1,16643,16641,16623,16624,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_20_point_1()
		{
			double[] value = {0.6804,0.3379,0.7197,0.3656,0.7201,0.3534,0.748,0.3722,0.7505,0.3606,0.7672,0.3686,0.676,0.4491,0.6779,0.4409,0.723,0.4625,0.7246,0.4542,0.7605,0.468,0.759,0.4594,0.7494,0.5688,0.746,0.5574,0.6867,0.586,0.6876,0.5906,0.7568,0.5872,0.7564,0.5837,0.7957,0.5778,0.7954,0.5758,0.839,0.5673,0.8379,0.5638,0.8816,0.5541,0.8809,0.5502,0.9232,0.5297,0.7912,0.5648,0.7824,0.5456,0.9529,0.4602,0.94,0.4517,0.9304,0.4097,0.949,0.4266,0.9484,0.4387,0.718,0.3951,0.9496,0.4936,0.8054,0.5109,0.8186,0.5328,0.9287,0.5323,0.9321,0.5313,0.9449,0.5148,0.9427,0.5152,0.9344,0.5141,0.6804,0.4225,0.6802,0.4133,0.718,0.4204,0.7185,0.4371,0.7491,0.4181,0.7551,0.439,0.9524,0.5048,0.9554,0.4968,0.9526,0.4943,0.9514,0.501,0.8341,0.551,0.9435,0.4085,0.7459,0.392,0.6804,0.3935,0.7638,0.384,0.9185,0.5439,0.925,0.5418,0.9538,0.4941,0.8748,0.5317,0.773,0.5237,0.7413,0.5371,0.678,0.5333,0.879,0.5432,0.8365,0.5589,0.7939,0.5722,0.7526,0.5771,0.8813,0.5591,0.8401,0.5701,0.7943,0.5785,0.7552,0.587,0.6806,0.5911,0.7652,0.4964,0.7422,0.3972,0.7297,0.5025,0.7176,0.4025,0.7559,0.3472,0.7877,0.3554,0.8002,0.3523,0.7592,0.3468,0.72,0.3402,0.7251,0.3428,0.8448,0.3504,0.8401,0.3567,0.8888,0.3661,0.928,0.3915,0.7586,0.3867,0.742,0.395,0.7177,0.3995,0.8872,0.3767,0.7201,0.3534,0.7197,0.3656,0.7505,0.3606,0.748,0.3722,0.7784,0.3576,0.7693,0.3641,0.7246,0.4542,0.723,0.4625,0.759,0.4594,0.7605,0.468};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_2()
		{
			double[] value = {0.6817,0.5686,0.746,0.5574,0.7494,0.5688,0.7564,0.5837,0.7568,0.5872,0.7954,0.5758,0.7957,0.5778,0.8379,0.5638,0.839,0.5673,0.8809,0.5502,0.8816,0.5541,0.9232,0.5297,0.7824,0.5456,0.7912,0.5648,0.9529,0.4602,0.9525,0.4679,0.9366,0.4732,0.9167,0.4805,0.718,0.3951,0.6808,0.3812,0.8635,0.5117,0.8186,0.5328,0.8444,0.4949,0.9427,0.5152,0.9449,0.5148,0.9321,0.5313,0.9287,0.5323,0.9344,0.5141,0.7185,0.4371,0.718,0.4204,0.7551,0.439,0.7491,0.4181,0.7656,0.4063,0.9514,0.501,0.9526,0.4943,0.9554,0.4968,0.9524,0.5048,0.8341,0.551,0.9249,0.3693,0.7459,0.392,0.9082,0.5061,0.9386,0.491,0.7591,0.3887,0.8748,0.5317,0.773,0.5237,0.7413,0.5371,0.879,0.5432,0.8365,0.5589,0.7939,0.5722,0.7526,0.5771,0.6847,0.5784,0.7652,0.4964,0.7422,0.3972,0.7297,0.5025,0.7176,0.4025,0.6766,0.4946,0.7877,0.3554,0.7559,0.3472,0.72,0.3402,0.679,0.3313,0.8888,0.3661,0.742,0.395,0.7177,0.3995,0.4545,0.0585,0.4589,0.049,0.4569,0.0417,0.452,0.0482,0.4437,0.0589,0.4391,0.0657,0.4588,0.0365,0.4642,0.0351,0.4578,0.0348,0.452,0.0482,0.4634,0.0419,0.4569,0.0417,0.4437,0.0589,0.4588,0.0365,0.5852,0.3147,0.6342,0.3367,0.6333,0.3244,0.6801,0.3508,0.5735,0.4227,0.5745,0.4137,0.6314,0.4317,0.6319,0.4232,0.6244,0.5649,0.6256,0.5536,0.6817,0.5686,0.6811,0.5575,0.6215,0.585,0.6198,0.5907,0.5584,0.5829,0.6808,0.3812,0.6331,0.3638,0.633,0.4039,0.5642,0.5184,0.5466,0.5927,0.6275,0.5277,0.6847,0.5784,0.623,0.5761};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_3()
		{
			double[] value = {0.6154,0.5954,0.6766,0.4946,0.6278,0.4787,0.6274,0.5182,0.576,0.398,0.679,0.3313,0.6786,0.3312,0.63,0.3167,0.6304,0.3191,0.6333,0.3244,0.6342,0.3367,0.6804,0.3379,0.6801,0.3508,0.6319,0.4232,0.6314,0.4317,0.6779,0.4409,0.676,0.4491,0.6256,0.5536,0.6245,0.5649,0.6811,0.5575,0.6876,0.5906,0.6867,0.586,0.6198,0.5907,0.6216,0.585,0.6331,0.3638,0.633,0.4039,0.6802,0.4133,0.6804,0.4225,0.6804,0.3935,0.5812,0.351,0.5595,0.5741,0.678,0.5333,0.6275,0.5277,0.623,0.5761,0.6274,0.5182,0.6278,0.4787,0.5684,0.4801,0.5693,0.4521,0.63,0.3167,0.2294,0.4472,0.245,0.4163,0.2399,0.4239,0.2426,0.423,0.2986,0.6494,0.2515,0.4188,0.242,0.4123,0.2296,0.4408,0.2333,0.4398,0.2373,0.4396,0.2569,0.4452,0.4303,0.4471,0.4378,0.5103,0.5163,0.3269,0.5177,0.3162,0.5849,0.3261,0.5085,0.4152,0.5097,0.4239,0.4697,0.4217,0.5022,0.5583,0.504,0.5467,0.4567,0.5459,0.4561,0.5582,0.5606,0.5632,0.5616,0.5522,0.5557,0.5882,0.4483,0.5589,0.4488,0.5471,0.4389,0.5506,0.4353,0.5632,0.4977,0.5846,0.4943,0.5892,0.446,0.5922,0.4383,0.5949,0.4312,0.5948,0.4395,0.5926,0.4525,0.5842,0.4451,0.5864,0.455,0.5709,0.4474,0.5726,0.4574,0.5108,0.449,0.5103,0.4398,0.4457,0.3951,0.6243,0.4049,0.619,0.4094,0.6188,0.399,0.6233,0.3867,0.6205,0.3973,0.6156,0.4105,0.606,0.3996,0.609,0.4089,0.5872,0.3979,0.5898,0.4048,0.5501,0.3936,0.5521,0.4004,0.5149,0.3845,0.519,0.4759,0.3574,0.2471,0.4128,0.5812,0.351,0.5118,0.3483};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_4()
		{
			double[] value = {0.5089,0.5163,0.5002,0.5713,0.5595,0.5741,0.4271,0.5896,0.4257,0.5686,0.4243,0.5486,0.4241,0.6062,0.49,0.5919,0.4148,0.6041,0.4195,0.6055,0.4222,0.5098,0.4712,0.3976,0.2924,0.5463,0.2863,0.5484,0.2908,0.5623,0.3108,0.5873,0.3031,0.591,0.3137,0.628,0.3244,0.6237,0.3352,0.6108,0.3177,0.581,0.3016,0.5436,0.277,0.4973,0.2847,0.5218,0.2945,0.5187,0.2875,0.4937,0.28,0.4168,0.2813,0.5223,0.2702,0.4983,0.2783,0.5233,0.2639,0.3691,0.254,0.3697,0.2744,0.3393,0.2854,0.335,0.3034,0.3227,0.3666,0.6305,0.3615,0.6279,0.3703,0.6288,0.371,0.6148,0.3628,0.5607,0.3712,0.5953,0.3517,0.5292,0.3367,0.6339,0.3361,0.6353,0.3193,0.6394,0.3403,0.6255,0.3433,0.6117,0.3261,0.5731,0.3467,0.5956,0.3125,0.5396,0.3082,0.5223,0.5692,0.4521,0.5684,0.4801,0.5118,0.435,0.5149,0.4608,0.507,0.3943,0.3357,0.3205,0.3873,0.3095,0.5791,0.309,0.5788,0.3115,0.5172,0.3091,0.5153,0.3118,0.4702,0.3177,0.4675,0.3166,0.4186,0.3111,0.2727,0.3687,0.3176,0.6444,0.2294,0.4472,0.2308,0.4618,0.2426,0.423,0.2399,0.4239,0.245,0.4163,0.2515,0.4188,0.2333,0.4398,0.2373,0.4396,0.2569,0.4452,0.4378,0.5103,0.4732,0.323,0.4748,0.3323,0.426,0.3266,0.5177,0.3162,0.5163,0.3269,0.5849,0.3261,0.5852,0.3147,0.5745,0.4137,0.5735,0.4227,0.5097,0.4239,0.5085,0.4152,0.4561,0.5582,0.4567,0.5459,0.504,0.5467,0.5022,0.5583,0.5616,0.5522,0.5606,0.5632,0.5557,0.5882,0.5584,0.5829,0.4353,0.5632,0.4389,0.5506,0.4488,0.5471,0.4483,0.5589};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_5()
		{
			double[] value = {0.4943,0.5892,0.4977,0.5846,0.4383,0.5949,0.446,0.5922,0.4451,0.5864,0.4525,0.5842,0.4474,0.5726,0.455,0.5709,0.449,0.5103,0.4574,0.5108,0.4424,0.4455,0.469,0.4459,0.399,0.6233,0.4094,0.6188,0.4049,0.619,0.3951,0.6243,0.3996,0.609,0.4105,0.606,0.3979,0.5898,0.4089,0.5872,0.3936,0.5521,0.4048,0.5501,0.3845,0.519,0.4004,0.5149,0.3653,0.4677,0.2682,0.417,0.5118,0.3483,0.5089,0.5163,0.5642,0.5184,0.5002,0.5713,0.4271,0.5896,0.4243,0.5486,0.4257,0.5686,0.4241,0.6062,0.4195,0.6055,0.4222,0.5098,0.4118,0.4496,0.2908,0.5623,0.2863,0.5484,0.2924,0.5463,0.3031,0.591,0.3108,0.5873,0.3244,0.6237,0.3137,0.628,0.3177,0.581,0.3352,0.6108,0.3016,0.5436,0.2945,0.5187,0.2847,0.5218,0.277,0.4973,0.2783,0.5233,0.2702,0.4983,0.2813,0.5223,0.3135,0.3238,0.3666,0.6305,0.3703,0.6288,0.371,0.6148,0.3712,0.5953,0.3628,0.5607,0.3517,0.5292,0.3354,0.4782,0.3367,0.6339,0.3193,0.6394,0.3433,0.6117,0.3403,0.6255,0.3467,0.5956,0.3261,0.5731,0.3125,0.5396,0.3082,0.5223,0.3,0.4892,0.576,0.398,0.515,0.4608,0.5118,0.435,0.507,0.3943,0.3407,0.3229,0.3932,0.3154,0.5791,0.309,0.5172,0.3091,0.4702,0.3177,0.4237,0.313,0.6704,0.768,0.6773,0.7677,0.6761,0.7807,0.677,0.7754,0.6729,0.7562,0.6748,0.7783,0.8334,0.8777,0.8615,0.867,0.8613,0.8668,0.742,0.7753,0.7403,0.7752,0.7332,0.7708,0.7346,0.7705,0.8519,0.8111,0.8513,0.8117,0.8471,0.8101,0.8464,0.8089,0.8705,0.8201,0.8701,0.821,0.8568,0.8142};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_6()
		{
			double[] value = {0.8578,0.8136,0.8809,0.8247,0.8797,0.8252,0.8782,0.8244,0.8794,0.8238,0.9113,0.8308,0.9102,0.832,0.9075,0.8312,0.9081,0.83,0.9308,0.8338,0.9295,0.8349,0.9275,0.8352,0.9283,0.834,0.8879,0.8458,0.9128,0.8328,0.867,0.8362,0.8891,0.8269,0.8388,0.8218,0.7889,0.8157,0.7672,0.7999,0.7794,0.8078,0.6746,0.7436,0.6653,0.7217,0.6709,0.7194,0.8659,0.8448,0.9272,0.8344,0.9253,0.8347,0.885,0.8497,0.8796,0.8455,0.8504,0.8602,0.8556,0.8637,0.7802,0.8081,0.7792,0.8068,0.7664,0.7981,0.7679,0.8003,0.6652,0.7206,0.6658,0.72,0.6707,0.7185,0.6706,0.7185,0.9195,0.8346,0.9207,0.8334,0.9139,0.8317,0.8904,0.8263,0.8321,0.8033,0.8342,0.8023,0.8092,0.8036,0.811,0.8023,0.7937,0.8068,0.7943,0.8061,0.7878,0.8099,0.7883,0.8093,0.7175,0.7776,0.6944,0.7463,0.693,0.7444,0.6645,0.7324,0.6656,0.7318,0.9289,0.8334,0.9277,0.8335,0.8075,0.8965,0.8088,0.8956,0.7535,0.8086,0.761,0.8144,0.7613,0.8147,0.751,0.8065,0.7939,0.8111,0.8022,0.8092,0.7868,0.8806,0.7843,0.8777,0.8071,0.8973,0.8031,0.8958,0.8016,0.8948,0.8014,0.8929,0.7969,0.8915,0.7963,0.8893,0.8174,0.8747,0.8225,0.8757,0.8256,0.8773,0.8931,0.8361,0.8863,0.8341,0.9128,0.8401,0.9144,0.8405,0.8988,0.8545,0.8994,0.8551,0.8053,0.8637,0.8064,0.8646,0.8323,0.8446,0.83,0.8431,0.856,0.818,0.8594,0.8196,0.8511,0.8277,0.8538,0.8293,0.8219,0.8035,0.7421,0.8252,0.7399,0.8222,0.7542,0.8212,0.7765,0.8087,0.7719,0.8057,0.7723,0.8157,0.7756,0.8184,0.7439,0.7776};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_7()
		{
			double[] value = {0.6763,0.7702,0.675,0.761,0.7341,0.7708,0.666,0.7329,0.6672,0.7215,0.6709,0.7228,0.6673,0.7402,0.6926,0.7451,0.7362,0.7952,0.731,0.7958,0.7392,0.8012,0.721,0.7999,0.7096,0.7966,0.9309,0.8422,0.9297,0.8423,0.9159,0.8567,0.9143,0.8567,0.8605,0.8689,0.8599,0.869,0.8104,0.8983,0.8105,0.8978,0.8325,0.8795,0.8323,0.88,0.6909,0.7821,0.7254,0.8031,0.7142,0.7857,0.7423,0.8047,0.688,0.7724,0.6773,0.751,0.7083,0.7735,0.7362,0.7845,0.7473,0.7831,0.7336,0.7725,0.7497,0.7961,0.6945,0.751,0.7476,0.8316,0.759,0.8258,0.782,0.8224,0.7828,0.8113,0.7532,0.8184,0.7385,0.8186,0.7603,0.8478,0.7602,0.8494,0.7813,0.8761,0.8036,0.8617,0.7944,0.8564,0.7743,0.8697,0.8206,0.8374,0.8281,0.842,0.8489,0.8266,0.8381,0.8204,0.8524,0.8167,0.8352,0.8105,0.8166,0.8135,0.8039,0.8297,0.776,0.843,0.7666,0.8598,0.7657,0.8593,0.7713,0.8419,0.7987,0.8285,0.8068,0.8146,0.7918,0.8857,0.8173,0.8712,0.8117,0.8669,0.8435,0.8523,0.8672,0.838,0.8847,0.8327,0.8731,0.8267,0.9289,0.8418,0.9318,0.842,0.9163,0.8578,0.913,0.8572,0.8638,0.8698,0.8629,0.8694,0.8104,0.8974,0.8323,0.8798,0.8323,0.8792,0.8081,0.8956,0.8082,0.8957,0.8321,0.8786,0.8617,0.8681,0.9043,0.8563,0.8951,0.8524,0.8606,0.8662,0.9206,0.841,0.907,0.8389,0.8307,0.8784,0.6736,0.7292,0.678,0.7191,0.6438,0.6675,0.6419,0.6732,0.6636,0.6512,0.6635,0.6489,0.6846,0.7056,0.6846,0.6968,0.6805,0.712,0.6595,0.7464,0.669,0.7352,0.6761,0.7236,0.6723,0.7354};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_8()
		{
			double[] value = {0.6827,0.7086,0.6796,0.7185,0.6782,0.7217,0.6431,0.6839,0.6458,0.6733,0.6662,0.6531,0.6816,0.7098,0.6772,0.7203,0.6591,0.7318,0.6556,0.7296,0.6561,0.7312,0.6858,0.6359,0.6835,0.6553,0.6962,0.6463,0.6967,0.6287,0.6821,0.6678,0.6889,0.6642,0.6681,0.6666,0.6714,0.6729,0.6696,0.6515,0.6445,0.6758,0.643,0.6958,0.6631,0.7356,0.6561,0.7517,0.6622,0.7402,0.6797,0.6342,0.6728,0.6415,0.6926,0.6243,0.6893,0.6276,0.6719,0.7322,0.6842,0.684,0.6889,0.686,0.6775,0.6857,0.6447,0.7007,0.6738,0.6795,0.6841,0.6766,0.6884,0.6787,0.663,0.7422,0.6729,0.7276,0.6542,0.7334,0.6573,0.7129,0.6604,0.7081,0.6663,0.7091,0.6722,0.7166,0.6712,0.725,0.664,0.6868,0.6702,0.6816,0.6748,0.6843,0.6785,0.696,0.6808,0.7061,0.6819,0.712,0.6804,0.719,0.6537,0.7555,0.6883,0.7,0.6386,0.6897,0.6859,0.6453,0.6915,0.6395,0.6932,0.6465,0.6878,0.6685,0.686,0.683,0.6881,0.6908,0.6614,0.7402,0.6708,0.7257,0.6801,0.7084,0.6856,0.6862,0.6869,0.6721,0.6823,0.6736,0.6727,0.6773,0.6453,0.699,0.6828,0.6361,0.6938,0.6266,0.6908,0.6417,0.6706,0.6824,0.6611,0.7077,0.6865,0.7419,0.6861,0.7415,0.6881,0.7394,0.6884,0.7398,0.6672,0.7499,0.6776,0.7469,0.6777,0.7486,0.6867,0.7426,0.6867,0.7439,0.6886,0.7406,0.6887,0.7422,0.688,0.7398,0.688,0.7415,0.6859,0.7418,0.6859,0.7433,0.6766,0.7461,0.6767,0.7478,0.6673,0.7519,0.6775,0.7489,0.6865,0.7442,0.6885,0.7425,0.6882,0.7422,0.6862,0.7438,0.677,0.7485,0.6677,0.7526,0.6768,0.7458};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_9()
		{
			double[] value = {0.6773,0.7462,0.6645,0.7413,0.6539,0.7184,0.6727,0.7365,0.6762,0.7411,0.677,0.7418,0.6759,0.7411,0.674,0.7394,0.6721,0.7363,0.6639,0.7125,0.6642,0.7129,0.6797,0.729,0.6831,0.7339,0.6842,0.7344,0.6833,0.7337,0.6813,0.7322,0.6793,0.729,0.6724,0.7049,0.6728,0.7053,0.6805,0.7264,0.6837,0.731,0.685,0.7317,0.6842,0.731,0.6829,0.7302,0.6798,0.7257,0.6737,0.7026,0.6741,0.703,0.6758,0.721,0.6766,0.7184,0.6692,0.7288,0.6611,0.7341,0.6485,0.7398,0.663,0.7396,0.6711,0.7348,0.6685,0.729,0.6784,0.7272,0.6756,0.7212,0.6761,0.7177,0.6737,0.7131,0.6753,0.7106,0.6658,0.721,0.6571,0.7266,0.6457,0.7325,0.6651,0.7203,0.6732,0.7124,0.6748,0.7099,0.6639,0.7134,0.6726,0.7058,0.6739,0.7035,0.6744,0.7042,0.6731,0.7064,0.6644,0.7141,0.6717,0.7358,0.6789,0.7283,0.6538,0.7162,0.6635,0.7115,0.6641,0.7131,0.6719,0.7048,0.6724,0.7061,0.6733,0.7025,0.6738,0.704,0.6732,0.7019,0.6737,0.7033,0.6739,0.7036,0.6734,0.7022,0.6716,0.7043,0.6721,0.7057,0.6734,0.7035,0.673,0.7021,0.6632,0.7111,0.6638,0.7126,0.6527,0.7124,0.6622,0.7081,0.6625,0.7085,0.6708,0.7018,0.6712,0.7022,0.6721,0.6995,0.6725,0.7,0.6715,0.7033,0.6728,0.7011,0.6629,0.7098,0.6626,0.7094,0.6712,0.7029,0.6725,0.7007,0.673,0.7007,0.6728,0.7005,0.6726,0.6996,0.6724,0.6993,0.6793,0.7757,0.6898,0.7713,0.6903,0.7731,0.6996,0.7718,0.7001,0.7736,0.7019,0.7735,0.7023,0.7753,0.7026,0.7756,0.7021,0.7738,0.702,0.774,0.7025,0.7758,0.7022,0.7756};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_10()
		{
			double[] value = {0.7017,0.7738,0.6994,0.7722,0.6999,0.7739,0.6896,0.7717,0.6901,0.7735,0.6799,0.7778,0.6826,0.782,0.6921,0.7777,0.692,0.7781,0.7017,0.7784,0.7016,0.7787,0.7039,0.7804,0.7037,0.7807,0.7032,0.778,0.701,0.7762,0.6912,0.7756,0.6911,0.776,0.7008,0.7765,0.703,0.7783,0.7034,0.7785,0.7035,0.7784,0.7041,0.7809,0.7042,0.7807,0.6738,0.7699,0.6857,0.7651,0.6859,0.7663,0.695,0.7638,0.6951,0.765,0.6967,0.7648,0.6968,0.7661,0.6969,0.7662,0.6969,0.7649,0.6967,0.7648,0.6968,0.7661,0.6965,0.7659,0.6964,0.7646,0.6948,0.7637,0.6948,0.7649,0.6853,0.7651,0.6855,0.7663,0.674,0.7713,0.677,0.7757,0.6869,0.7707,0.6866,0.7707,0.6961,0.77,0.6957,0.7699,0.6982,0.7713,0.6978,0.7711,0.6974,0.7688,0.6955,0.7676,0.6865,0.7686,0.6861,0.7686,0.6952,0.7675,0.697,0.7686,0.6974,0.7689,0.6976,0.769,0.6982,0.7713,0.6984,0.7715,0.6923,0.7623,0.6921,0.7626,0.6895,0.7626,0.6897,0.7624,0.6704,0.7685,0.6701,0.767,0.6705,0.7681,0.6794,0.7639,0.6798,0.7647,0.6893,0.7612,0.6896,0.762,0.6917,0.761,0.6922,0.7619,0.6913,0.7613,0.6918,0.7624,0.6889,0.7615,0.6892,0.7624,0.6788,0.7642,0.6793,0.7651,0.6699,0.7667,0.6791,0.7637,0.6891,0.761,0.6915,0.7608,0.6913,0.761,0.6889,0.7612,0.6788,0.7639,0.6798,0.7651,0.6795,0.7653,0.7274,0.8422,0.7281,0.8417,0.7266,0.8414,0.7267,0.8422,0.7259,0.8438,0.7273,0.8441,0.7342,0.8473,0.7355,0.849,0.7424,0.849,0.7442,0.8503,0.7543,0.8483,0.7568,0.8493,0.7674,0.8446,0.7697,0.8462};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_11()
		{
			double[] value = {0.7832,0.8392,0.7848,0.8408,0.798,0.8306,0.799,0.8327,0.8083,0.8253,0.8089,0.8274,0.818,0.8259,0.8189,0.828,0.8206,0.8279,0.8215,0.83,0.8219,0.8304,0.821,0.8282,0.8212,0.8284,0.8221,0.8306,0.8217,0.8304,0.8209,0.8282,0.8183,0.8263,0.8192,0.8284,0.8084,0.8257,0.809,0.8279,0.7981,0.8309,0.7992,0.833,0.7836,0.8394,0.7852,0.841,0.7684,0.8447,0.7706,0.8463,0.7551,0.8484,0.7575,0.8494,0.7422,0.849,0.7439,0.8504,0.7332,0.8472,0.7332,0.8488,0.7308,0.8475,0.739,0.8518,0.7376,0.8519,0.7294,0.8474,0.7474,0.8529,0.7468,0.8532,0.7597,0.8525,0.7601,0.8527,0.7723,0.85,0.7729,0.8502,0.7866,0.8454,0.7869,0.8456,0.8007,0.8379,0.801,0.8383,0.8102,0.8328,0.8104,0.8333,0.8202,0.8336,0.8205,0.834,0.8227,0.8359,0.823,0.8363,0.7302,0.8451,0.732,0.8452,0.8222,0.8332,0.8197,0.831,0.8096,0.8303,0.8001,0.8357,0.7859,0.8433,0.7712,0.8485,0.7584,0.8512,0.7459,0.8518,0.7374,0.8506,0.7291,0.8461,0.7301,0.8437,0.7285,0.8435,0.7272,0.8459,0.7358,0.8508,0.7454,0.852,0.759,0.8513,0.7719,0.8487,0.7862,0.8435,0.8003,0.8361,0.8098,0.8308,0.82,0.8314,0.8225,0.8335,0.8228,0.8338,0.8227,0.8336,0.8233,0.8365,0.8231,0.8364,0.7261,0.8409,0.7268,0.8404,0.7258,0.8406,0.7256,0.8411,0.7255,0.8431,0.7266,0.8429,0.7327,0.8445,0.7348,0.8461,0.7408,0.8447,0.7434,0.8458,0.7531,0.8428,0.7562,0.8433,0.7655,0.8379,0.7687,0.8393,0.7798,0.8325,0.7819,0.834,0.7947,0.8241,0.7957,0.8257,0.8055,0.818,0.806,0.8194};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_12()
		{
			double[] value = {0.8146,0.8164,0.815,0.8179,0.8166,0.8176,0.8171,0.8191,0.8173,0.8193,0.8169,0.8178,0.8167,0.8176,0.8172,0.8192,0.8169,0.8189,0.8164,0.8174,0.8145,0.8163,0.8148,0.8177,0.8054,0.818,0.8059,0.8194,0.7945,0.8241,0.7955,0.8257,0.78,0.8322,0.782,0.8338,0.7659,0.8375,0.7691,0.8389,0.7531,0.8424,0.7563,0.8429,0.74,0.8445,0.7425,0.8455,0.7314,0.8442,0.7322,0.8459,0.7312,0.8463,0.7415,0.8492,0.7398,0.8493,0.7303,0.8466,0.7503,0.8487,0.7491,0.8487,0.7632,0.847,0.7629,0.8468,0.7744,0.8442,0.7746,0.844,0.7862,0.839,0.7862,0.8389,0.7983,0.8306,0.7982,0.8306,0.8075,0.8245,0.8073,0.8246,0.817,0.8237,0.8167,0.8236,0.8196,0.8253,0.8193,0.825,0.7292,0.8433,0.7306,0.8431,0.8183,0.8224,0.8159,0.8209,0.8068,0.8221,0.7973,0.8285,0.7845,0.8369,0.7722,0.8423,0.7604,0.8455,0.7472,0.8475,0.7384,0.8479,0.7287,0.8446,0.7284,0.8416,0.7273,0.8419,0.7278,0.8454,0.7364,0.8481,0.7461,0.8474,0.7602,0.8453,0.7725,0.842,0.7845,0.8367,0.7971,0.8285,0.8067,0.8221,0.8157,0.8208,0.818,0.8221,0.8184,0.8224,0.8186,0.8225,0.8197,0.8253,0.8199,0.8254,0.7578,0.8355,0.7746,0.8289,0.7741,0.8289,0.7571,0.8358,0.7399,0.8441,0.7404,0.8442,0.749,0.8424,0.7493,0.8422,0.811,0.8147,0.8111,0.815,0.8084,0.815,0.8084,0.8148,0.7771,0.8315,0.7766,0.8315,0.7908,0.8229,0.7908,0.8232,0.725,0.8417,0.7227,0.8387,0.7248,0.8395,0.7274,0.8423,0.7253,0.8406,0.728,0.8433,0.7309,0.8425,0.7333,0.8443,0.7375,0.8425,0.7399,0.8438};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_13()
		{
			double[] value = {0.7459,0.8411,0.7481,0.8421,0.7574,0.8363,0.7595,0.8374,0.7743,0.8294,0.7759,0.831,0.7898,0.8213,0.7905,0.8225,0.7983,0.8166,0.799,0.8176,0.8075,0.8134,0.8082,0.8143,0.8099,0.8131,0.8107,0.8142,0.8099,0.8136,0.8108,0.8148,0.8076,0.8138,0.8082,0.8148,0.7984,0.817,0.7991,0.8181,0.79,0.8217,0.7907,0.8229,0.7753,0.8294,0.7769,0.831,0.7588,0.8357,0.761,0.8369,0.7466,0.8407,0.7488,0.8418,0.7369,0.8423,0.7391,0.8437,0.7293,0.8419,0.7315,0.844,0.7235,0.8396,0.7259,0.8426,0.7225,0.8379,0.7235,0.8384,0.7241,0.8394,0.7297,0.8417,0.7366,0.842,0.7454,0.8407,0.7896,0.821,0.7981,0.8164,0.8073,0.8132,0.8096,0.8129,0.8097,0.8131,0.8073,0.8134,0.7982,0.8166,0.7897,0.8212,0.7457,0.8405,0.7363,0.8419,0.729,0.8414,0.7233,0.8389,0.7993,0.818,0.7993,0.8183,0.7606,0.8376,0.7613,0.8374,0.7272,0.8436,0.7283,0.8439,0.7336,0.8447,0.7327,0.8446,0.7264,0.8427,0.7276,0.8429,0.6729,0.7977,0.6729,0.8037,0.6773,0.7677,0.6704,0.768,0.6755,0.7965,0.6761,0.7898,0.6749,0.8033,0.6722,0.8031,0.6779,0.7644,0.6747,0.7884,0.6746,0.7812,0.675,0.7963,0.6761,0.7807,0.677,0.7754,0.6653,0.7715,0.6632,0.7972,0.6748,0.7858,0.6748,0.7783,0.6728,0.7983,0.8613,0.8668,0.8615,0.867,0.8334,0.8777,0.6624,0.7437,0.6633,0.7443,0.7346,0.7705,0.7332,0.7708,0.7403,0.7752,0.7421,0.7753,0.8464,0.8089,0.8471,0.8101,0.8513,0.8117,0.8519,0.8111,0.8578,0.8136,0.8568,0.8142,0.8701,0.821,0.8705,0.8201,0.8794,0.8238,0.8782,0.8244};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_14()
		{
			double[] value = {0.8797,0.8252,0.8809,0.8247,0.9081,0.83,0.9075,0.8312,0.9102,0.832,0.9113,0.8308,0.9283,0.834,0.9275,0.8352,0.9295,0.8349,0.9308,0.8338,0.9128,0.8328,0.8879,0.8458,0.8891,0.8269,0.867,0.8362,0.8388,0.8218,0.7794,0.8078,0.7672,0.7999,0.7889,0.8157,0.6709,0.7194,0.6653,0.7217,0.6746,0.7436,0.9272,0.8344,0.8556,0.8637,0.8504,0.8602,0.8796,0.8455,0.885,0.8497,0.7679,0.8003,0.7664,0.7981,0.7792,0.8068,0.7802,0.8081,0.6707,0.7185,0.6652,0.7206,0.9195,0.8346,0.9207,0.8334,0.9139,0.8317,0.8904,0.8263,0.8321,0.8033,0.8342,0.8023,0.8092,0.8036,0.811,0.8023,0.7937,0.8068,0.7943,0.8061,0.7878,0.8099,0.7883,0.8093,0.7175,0.7776,0.6944,0.7463,0.693,0.7444,0.6645,0.7324,0.6656,0.7318,0.9289,0.8334,0.8088,0.8956,0.8075,0.8965,0.751,0.8065,0.7613,0.8147,0.761,0.8144,0.7535,0.8086,0.8022,0.8092,0.7939,0.8111,0.7843,0.8777,0.7868,0.8806,0.8031,0.8958,0.8071,0.8973,0.8014,0.8929,0.8016,0.8948,0.7963,0.8893,0.7969,0.8915,0.8174,0.8747,0.8225,0.8757,0.8256,0.8773,0.8863,0.8341,0.8931,0.8361,0.9144,0.8405,0.9129,0.8401,0.8994,0.8551,0.8988,0.8545,0.83,0.8431,0.8323,0.8446,0.8064,0.8646,0.8053,0.8637,0.8594,0.8196,0.856,0.818,0.8538,0.8293,0.8511,0.8277,0.8219,0.8035,0.7399,0.8222,0.7421,0.8252,0.7542,0.8212,0.7756,0.8184,0.7723,0.8157,0.7719,0.8057,0.7765,0.8087,0.7439,0.7776,0.6694,0.7555,0.675,0.761,0.6763,0.7702,0.6709,0.7654,0.7341,0.7708,0.666,0.7329,0.6673,0.7402,0.6642,0.747};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_15()
		{
			double[] value = {0.6926,0.7451,0.7392,0.8012,0.731,0.7958,0.7363,0.7952,0.7096,0.7966,0.721,0.7999,0.9309,0.8422,0.9159,0.8567,0.8605,0.8689,0.8105,0.8978,0.8325,0.8795,0.6909,0.7821,0.7254,0.8031,0.7142,0.7857,0.7423,0.8047,0.688,0.7724,0.7084,0.7735,0.6773,0.751,0.7362,0.7845,0.7498,0.7961,0.7336,0.7725,0.7473,0.7831,0.6945,0.751,0.7476,0.8316,0.759,0.8258,0.782,0.8224,0.7828,0.8113,0.7532,0.8184,0.7385,0.8186,0.7603,0.8478,0.7602,0.8494,0.7743,0.8697,0.7944,0.8564,0.8036,0.8617,0.7813,0.8761,0.8381,0.8204,0.8489,0.8266,0.8281,0.842,0.8206,0.8374,0.8352,0.8105,0.8524,0.8167,0.8166,0.8135,0.8039,0.8297,0.776,0.843,0.7666,0.8598,0.7713,0.8419,0.7657,0.8593,0.7987,0.8285,0.8068,0.8146,0.7918,0.8857,0.8117,0.8669,0.8173,0.8712,0.8672,0.838,0.8435,0.8523,0.8731,0.8267,0.8847,0.8327,0.9318,0.842,0.9289,0.8418,0.9163,0.8578,0.913,0.8572,0.8629,0.8694,0.8638,0.8698,0.8081,0.8956,0.8324,0.8792,0.8323,0.8798,0.8104,0.8974,0.8082,0.8957,0.8321,0.8786,0.8617,0.8681,0.9043,0.8563,0.8606,0.8662,0.8951,0.8524,0.9206,0.841,0.907,0.8389,0.8307,0.8784,0.6884,0.7398,0.6881,0.7394,0.6861,0.7415,0.6865,0.7419,0.6678,0.7502,0.6684,0.7526,0.6681,0.7509,0.6777,0.7486,0.6776,0.7469,0.6867,0.7439,0.6867,0.7426,0.6887,0.7422,0.6886,0.7406,0.688,0.7415,0.688,0.7398,0.6859,0.7433,0.6859,0.7418,0.6767,0.7478,0.6766,0.7461,0.6682,0.7529,0.6775,0.7489,0.6865,0.7442,0.6885,0.7425,0.6882,0.7422,0.6862,0.7438};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_16()
		{
			double[] value = {0.677,0.7485,0.6773,0.7462,0.6768,0.7458,0.667,0.746,0.6676,0.7469,0.6664,0.7462,0.6649,0.7443,0.6637,0.7412,0.6543,0.7187,0.6762,0.7411,0.6728,0.7365,0.677,0.7418,0.6759,0.7411,0.674,0.7394,0.6721,0.7363,0.6642,0.7129,0.6639,0.7125,0.6831,0.7339,0.6797,0.729,0.6842,0.7344,0.6833,0.7337,0.6813,0.7322,0.6793,0.729,0.6728,0.7053,0.6724,0.7049,0.6837,0.731,0.6805,0.7264,0.685,0.7317,0.6843,0.731,0.6829,0.7302,0.6798,0.7257,0.6741,0.703,0.6737,0.7026,0.6766,0.7184,0.6758,0.721,0.6605,0.7342,0.6685,0.729,0.6711,0.7348,0.6756,0.7212,0.6784,0.7272,0.6761,0.7177,0.6753,0.7106,0.6737,0.7131,0.6561,0.7259,0.6651,0.7203,0.6732,0.7124,0.6748,0.7099,0.6639,0.7134,0.6726,0.7058,0.6739,0.7035,0.6744,0.7042,0.6731,0.7064,0.6717,0.7358,0.6789,0.7283,0.6543,0.718,0.6641,0.7131,0.6635,0.7115,0.6724,0.7061,0.6719,0.7048,0.6738,0.704,0.6733,0.7025,0.6734,0.7022,0.6739,0.7036,0.6737,0.7033,0.6732,0.7019,0.673,0.7021,0.6734,0.7035,0.6721,0.7057,0.6716,0.7043,0.6638,0.7126,0.6632,0.7111,0.6533,0.7157,0.6531,0.7129,0.6625,0.7085,0.6622,0.7081,0.6712,0.7022,0.6708,0.7018,0.6725,0.7,0.6721,0.6995,0.6728,0.7011,0.6715,0.7033,0.6629,0.7098,0.6626,0.7094,0.6712,0.7029,0.6725,0.7007,0.6728,0.7005,0.673,0.7007,0.6724,0.6993,0.6726,0.6996,0.6671,0.7828,0.6903,0.7731,0.6899,0.7713,0.7001,0.7736,0.6996,0.7718,0.7023,0.7753,0.7019,0.7735,0.7025,0.7758,0.702,0.774,0.7022,0.7738,0.7026,0.7756};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_17()
		{
			double[] value = {0.6999,0.7739,0.6994,0.7722,0.7017,0.7738,0.7022,0.7756,0.6901,0.7735,0.6896,0.7717,0.6603,0.7888,0.6699,0.7875,0.67,0.7872,0.6825,0.7824,0.6826,0.782,0.692,0.7781,0.6921,0.7777,0.7016,0.7787,0.7017,0.7784,0.7038,0.7807,0.7039,0.7804,0.701,0.7762,0.7032,0.778,0.6912,0.7756,0.6817,0.7801,0.6688,0.7852,0.6687,0.7855,0.6816,0.7805,0.6911,0.776,0.7008,0.7765,0.7031,0.7783,0.7035,0.7784,0.7034,0.7785,0.7042,0.7807,0.7041,0.7809,0.6746,0.7713,0.6859,0.7663,0.6857,0.7651,0.6951,0.765,0.695,0.7638,0.6968,0.7661,0.6967,0.7648,0.6968,0.7661,0.6967,0.7648,0.6969,0.7649,0.697,0.7662,0.6948,0.7649,0.6948,0.7637,0.6964,0.7646,0.6965,0.7659,0.6855,0.7663,0.6853,0.7651,0.6766,0.7757,0.6957,0.7699,0.6961,0.77,0.6978,0.7711,0.6982,0.7713,0.6955,0.7676,0.6974,0.7688,0.6861,0.7686,0.6952,0.7675,0.697,0.7686,0.6976,0.769,0.6974,0.7689,0.6984,0.7715,0.6982,0.7713,0.6897,0.7624,0.6895,0.7626,0.6921,0.7626,0.6923,0.7623,0.6701,0.7687,0.6798,0.7647,0.6794,0.7639,0.6896,0.762,0.6893,0.7612,0.6922,0.7619,0.6917,0.761,0.6918,0.7624,0.6913,0.7613,0.6892,0.7624,0.6889,0.7615,0.6793,0.7651,0.6788,0.7642,0.6695,0.7674,0.6791,0.7637,0.6891,0.761,0.6915,0.7608,0.6913,0.761,0.6889,0.7612,0.6788,0.7639,0.6696,0.7669,0.6795,0.7653,0.6798,0.7651,0.7267,0.8422,0.7266,0.8414,0.7281,0.8417,0.7274,0.8422,0.7259,0.8438,0.7273,0.8441,0.7355,0.849,0.7342,0.8473,0.7442,0.8503,0.7424,0.849,0.7568,0.8493};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_18()
		{
			double[] value = {0.7544,0.8483,0.7697,0.8462,0.7674,0.8446,0.7848,0.8408,0.7832,0.8392,0.799,0.8327,0.798,0.8306,0.8089,0.8274,0.8083,0.8253,0.8189,0.828,0.818,0.8259,0.8215,0.83,0.8206,0.8279,0.8221,0.8306,0.8212,0.8284,0.821,0.8282,0.8219,0.8304,0.8192,0.8284,0.8183,0.8263,0.8209,0.8282,0.8217,0.8304,0.809,0.8279,0.8084,0.8257,0.7992,0.833,0.7981,0.8309,0.7852,0.841,0.7837,0.8394,0.7706,0.8463,0.7684,0.8447,0.7575,0.8494,0.7551,0.8484,0.7439,0.8504,0.7422,0.849,0.7332,0.8488,0.7332,0.8472,0.7295,0.8474,0.7377,0.8519,0.739,0.8518,0.7308,0.8475,0.7468,0.8532,0.7474,0.8529,0.7601,0.8527,0.7597,0.8525,0.7729,0.8502,0.7723,0.85,0.7869,0.8456,0.7866,0.8454,0.801,0.8383,0.8007,0.8379,0.8104,0.8333,0.8102,0.8328,0.8205,0.834,0.8202,0.8336,0.823,0.8363,0.8227,0.8359,0.732,0.8452,0.7303,0.8451,0.8197,0.831,0.8223,0.8332,0.8096,0.8303,0.8001,0.8357,0.7859,0.8433,0.7712,0.8485,0.7585,0.8512,0.7459,0.8518,0.7374,0.8506,0.7291,0.8461,0.7301,0.8437,0.7285,0.8435,0.7273,0.8459,0.7358,0.8508,0.7454,0.852,0.759,0.8513,0.7719,0.8487,0.7862,0.8435,0.8003,0.8361,0.8098,0.8308,0.82,0.8314,0.8225,0.8335,0.8227,0.8336,0.8228,0.8338,0.8231,0.8364,0.8233,0.8365,0.7256,0.8411,0.7258,0.8406,0.7268,0.8404,0.7261,0.8409,0.7255,0.8431,0.7266,0.8429,0.7348,0.8461,0.7327,0.8445,0.7434,0.8458,0.7408,0.8447,0.7562,0.8433,0.7531,0.8428,0.7687,0.8393,0.7655,0.8379,0.7819,0.834,0.7798,0.8325,0.7957,0.8257};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_19()
		{
			double[] value = {0.7947,0.8241,0.806,0.8194,0.8055,0.818,0.815,0.8179,0.8146,0.8164,0.8171,0.8191,0.8166,0.8176,0.8172,0.8192,0.8167,0.8176,0.8169,0.8178,0.8174,0.8193,0.8148,0.8177,0.8145,0.8163,0.8164,0.8174,0.8169,0.8189,0.8059,0.8194,0.8054,0.818,0.7955,0.8257,0.7945,0.8241,0.782,0.8338,0.78,0.8322,0.7691,0.8389,0.7659,0.8375,0.7563,0.8429,0.7532,0.8424,0.7425,0.8455,0.74,0.8445,0.7322,0.8459,0.7314,0.8442,0.7303,0.8466,0.7398,0.8493,0.7415,0.8492,0.7312,0.8463,0.7491,0.8487,0.7503,0.8487,0.7629,0.8468,0.7632,0.847,0.7746,0.844,0.7744,0.8442,0.7862,0.8389,0.7862,0.839,0.7982,0.8306,0.7983,0.8306,0.8074,0.8246,0.8075,0.8245,0.8168,0.8236,0.817,0.8237,0.8193,0.825,0.8196,0.8253,0.7306,0.8431,0.7292,0.8433,0.816,0.8209,0.8183,0.8224,0.8068,0.8221,0.7973,0.8285,0.7845,0.8369,0.7722,0.8423,0.7604,0.8455,0.7472,0.8475,0.7384,0.8479,0.7288,0.8446,0.7284,0.8416,0.7273,0.8419,0.7278,0.8454,0.7364,0.8481,0.7461,0.8474,0.7602,0.8453,0.7725,0.842,0.7845,0.8367,0.7971,0.8285,0.8067,0.8221,0.8157,0.8208,0.818,0.8221,0.8186,0.8225,0.8184,0.8224,0.8199,0.8254,0.8197,0.8253,0.7571,0.8358,0.7741,0.8289,0.7746,0.8289,0.7578,0.8355,0.7493,0.8422,0.749,0.8424,0.7404,0.8442,0.7399,0.8441,0.8084,0.8148,0.8084,0.815,0.8111,0.815,0.811,0.8147,0.7909,0.8232,0.7908,0.8229,0.7767,0.8315,0.7771,0.8315,0.7274,0.8423,0.7248,0.8395,0.7227,0.8387,0.725,0.8417,0.728,0.8433,0.7253,0.8406,0.7334,0.8443};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_20()
		{
			double[] value = {0.7309,0.8425,0.7399,0.8438,0.7375,0.8425,0.7482,0.8421,0.7459,0.8411,0.7595,0.8374,0.7574,0.8363,0.7759,0.831,0.7743,0.8294,0.7905,0.8225,0.7898,0.8213,0.7991,0.8176,0.7983,0.8166,0.8082,0.8143,0.8075,0.8134,0.8107,0.8142,0.8099,0.8131,0.8108,0.8148,0.81,0.8136,0.8082,0.8148,0.8076,0.8138,0.7991,0.8181,0.7984,0.817,0.7907,0.8229,0.79,0.8217,0.7769,0.831,0.7753,0.8294,0.761,0.8369,0.7588,0.8357,0.7488,0.8418,0.7466,0.8407,0.7391,0.8437,0.7369,0.8423,0.7315,0.844,0.7293,0.8419,0.7259,0.8426,0.7235,0.8396,0.7235,0.8384,0.7225,0.8379,0.7242,0.8394,0.7297,0.8417,0.7367,0.842,0.7454,0.8407,0.7896,0.821,0.7981,0.8164,0.8073,0.8132,0.8097,0.8129,0.8097,0.8131,0.8074,0.8134,0.7982,0.8166,0.7897,0.8212,0.7457,0.8405,0.7363,0.8419,0.729,0.8414,0.7233,0.8389,0.7993,0.8183,0.7993,0.818,0.7613,0.8374,0.7606,0.8376,0.7327,0.8446,0.7336,0.8447,0.7283,0.8439,0.7272,0.8436,0.7276,0.8429,0.7264,0.8427,0.678,0.7191,0.6736,0.7292,0.6623,0.6536,0.6419,0.6732,0.6477,0.7111,0.6847,0.6968,0.6846,0.7056,0.6805,0.712,0.6576,0.7523,0.6651,0.7438,0.669,0.7352,0.6595,0.7464,0.6627,0.7511,0.6667,0.7449,0.6576,0.7554,0.6719,0.7334,0.6761,0.7236,0.6685,0.7423,0.6723,0.7354,0.6642,0.7506,0.6796,0.7185,0.6827,0.7086,0.6745,0.7299,0.6782,0.7217,0.6698,0.7394,0.6531,0.764,0.651,0.7626,0.6458,0.6733,0.6647,0.656,0.6816,0.7098,0.6772,0.7203,0.6705,0.7346,0.6644,0.7442,0.6558,0.7539,0.6556,0.7296};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_21()
		{
			double[] value = {0.6591,0.7318,0.6561,0.7312,0.694,0.6342,0.6936,0.6516,0.6821,0.6581,0.6825,0.6424,0.6885,0.6651,0.6821,0.6678,0.6714,0.6729,0.6681,0.6666,0.6678,0.6551,0.6445,0.6758,0.6392,0.6924,0.6561,0.7517,0.6631,0.7356,0.6622,0.7402,0.6547,0.7538,0.6776,0.6383,0.691,0.6276,0.6719,0.7322,0.6622,0.7454,0.6889,0.686,0.6842,0.684,0.6775,0.6857,0.6461,0.7052,0.6358,0.7063,0.6447,0.7007,0.6738,0.6795,0.6841,0.6766,0.6884,0.6787,0.6729,0.7276,0.663,0.7422,0.6604,0.7081,0.6722,0.7166,0.6663,0.7091,0.6712,0.725,0.6702,0.6816,0.6785,0.696,0.6748,0.6843,0.6808,0.7061,0.6804,0.719,0.6819,0.712,0.6883,0.7,0.6382,0.7048,0.6902,0.6422,0.6871,0.6699,0.691,0.6508,0.686,0.683,0.6881,0.6908,0.6527,0.7538,0.6614,0.7402,0.6708,0.7257,0.6801,0.7084,0.6856,0.6862,0.6869,0.6721,0.6823,0.6736,0.6727,0.6773,0.68,0.6416,0.6914,0.6313,0.6888,0.6456,0.6706,0.6824,0.6611,0.7077,0.4318,0.3543,0.4268,0.3446,0.4295,0.3424,0.434,0.3512,0.4374,0.3958,0.4325,0.3958,0.4359,0.3695,0.4401,0.3682,0.4307,0.4368,0.424,0.4397,0.4303,0.4471,0.4234,0.4481,0.4339,0.3583,0.4376,0.3569,0.4216,0.3339,0.4267,0.3531,0.4361,0.3583,0.4331,0.3574,0.4243,0.3523,0.4002,0.3439,0.3979,0.3426,0.3478,0.3241,0.442,0.3674,0.4387,0.3679,0.4443,0.3949,0.4398,0.3946,0.3464,0.327,0.323,0.3226,0.4258,0.3441,0.4395,0.4231,0.427,0.3322,0.4698,0.4217,0.4398,0.4457,0.3922,0.4558,0.4759,0.3574,0.3971,0.3683,0.4039,0.3793,0.4713,0.3976};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_22()
		{
			double[] value = {0.4074,0.4028,0.3566,0.418,0.3892,0.409,0.3888,0.3799,0.3614,0.3701,0.2875,0.4937,0.28,0.4168,0.2737,0.4137,0.2974,0.3653,0.2847,0.3646,0.2742,0.3727,0.2872,0.3528,0.2792,0.3556,0.2738,0.3693,0.2771,0.361,0.2841,0.3455,0.2639,0.3691,0.2854,0.335,0.2941,0.3306,0.3247,0.3182,0.3264,0.3138,0.2961,0.3226,0.292,0.3386,0.3214,0.4208,0.3267,0.3695,0.2886,0.4195,0.3985,0.3541,0.3647,0.357,0.3299,0.3571,0.3015,0.3539,0.3959,0.3222,0.3971,0.3344,0.4224,0.3349,0.3496,0.3196,0.3523,0.3128,0.3973,0.3345,0.4369,0.3555,0.4404,0.3664,0.4395,0.3947,0.438,0.4232,0.2727,0.3687,0.3452,0.3281,0.3204,0.3243,0.2922,0.3398,0.3956,0.329,0.2911,0.3301,0.2841,0.3386,0.4246,0.3327,0.4139,0.3143,0.4164,0.3126,0.4055,0.2804,0.4079,0.2788,0.4011,0.2619,0.4034,0.2603,0.3922,0.2212,0.3952,0.2202,0.3761,0.1756,0.3792,0.1744,0.3667,0.1451,0.3691,0.1445,0.3637,0.1211,0.3658,0.1215,0.362,0.1096,0.3639,0.11,0.3619,0.0952,0.3096,0.2672,0.3082,0.2674,0.3056,0.284,0.3711,0.2716,0.3716,0.2903,0.344,0.2945,0.3442,0.2765,0.386,0.2676,0.3905,0.2859,0.4006,0.2587,0.4048,0.277,0.3877,0.2597,0.3904,0.2768,0.3582,0.2598,0.3575,0.2763,0.3342,0.2621,0.3336,0.2789,0.3223,0.2972,0.3259,0.2802,0.3092,0.2983,0.3094,0.2816,0.2919,0.2948,0.292,0.2773,0.2917,0.2866,0.2923,0.2691,0.3448,0.1148,0.348,0.1258,0.333,0.1326,0.33,0.1209,0.3568,0.1091,0.3585,0.1205,0.3636,0.1104,0.3661,0.122,0.3505,0.1162,0.3533,0.1274};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_23()
		{
			double[] value = {0.3395,0.1195,0.3421,0.1307,0.3285,0.1227,0.3309,0.134,0.3171,0.1233,0.3187,0.1347,0.3068,0.124,0.3072,0.1354,0.2947,0.1246,0.2945,0.1351,0.2952,0.1264,0.2965,0.1365,0.304,0.1253,0.3056,0.1356,0.3152,0.1235,0.3159,0.1344,0.3376,0.3256,0.3714,0.3237,0.3286,0.1558,0.3174,0.1573,0.3106,0.3241,0.3336,0.2325,0.3439,0.2309,0.3309,0.1859,0.339,0.1857,0.3348,0.1549,0.2923,0.3231,0.2896,0.3154,0.2943,0.2353,0.2899,0.2308,0.2953,0.188,0.2911,0.1909,0.2974,0.1563,0.2933,0.1541,0.2931,0.1177,0.2945,0.1151,0.3998,0.34,0.3993,0.3188,0.3778,0.2256,0.3673,0.1783,0.3618,0.1477,0.3539,0.094,0.368,0.3439,0.3654,0.2264,0.3572,0.1847,0.3529,0.1519,0.3447,0.0997,0.3331,0.3447,0.3055,0.3425,0.314,0.2353,0.3147,0.1864,0.3316,0.1061,0.3146,0.1132,0.3044,0.1872,0.3068,0.1569,0.419,0.3258,0.3939,0.3041,0.4136,0.3096,0.3793,0.221,0.395,0.2199,0.3651,0.1795,0.3796,0.1737,0.3575,0.1527,0.3693,0.1455,0.3457,0.1017,0.3604,0.0959,0.3554,0.3007,0.3569,0.2236,0.3352,0.1052,0.3461,0.1551,0.3507,0.1854,0.3366,0.2257,0.3291,0.304,0.3208,0.1565,0.3347,0.1574,0.3211,0.1912,0.3362,0.189,0.3186,0.2273,0.2995,0.3092,0.306,0.1127,0.3075,0.1558,0.3066,0.1915,0.3072,0.2287,0.3013,0.1162,0.3433,0.0965,0.3345,0.0871,0.3334,0.1,0.3577,0.0909,0.3451,0.0813,0.3592,0.0903,0.3459,0.0793,0.3518,0.0888,0.3428,0.0825,0.3247,0.1088,0.3148,0.111,0.2898,0.341,0.3423,0.0945,0.3104,0.1005,0.3083,0.0943,0.3248,0.0782};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_24()
		{
			double[] value = {0.3269,0.0888,0.2902,0.1077,0.2891,0.1042,0.2953,0.102,0.2971,0.106,0.2937,0.1036,0.2941,0.0987,0.3317,0.0842,0.3253,0.0751,0.3298,0.0806,0.3389,0.0735,0.333,0.0668,0.3387,0.0726,0.3348,0.0636,0.3355,0.0632,0.3406,0.0707,0.3108,0.0986,0.3086,0.0927,0.3024,0.0961,0.3036,0.1011,0.3292,0.0965,0.3232,0.103,0.3191,0.0954,0.3152,0.0888,0.3291,0.1004,0.3128,0.1077,0.2993,0.1109,0.2915,0.1121,0.3259,0.0871,0.3204,0.0821,0.2937,0.1094,0.3051,0.1071,0.3133,0.1055,0.286,0.0462,0.2722,0.0396,0.3001,0.0396,0.2638,0.0599,0.2603,0.0396,0.2739,0.0534,0.2508,0.0396,0.2534,0.0396,0.2575,0.0621,0.2525,0.0607,0.232,0.0396,0.2489,0.0396,0.2506,0.0614,0.2298,0.0633,0.2295,0.0396,0.2275,0.0396,0.2244,0.0649,0.2238,0.0641,0.2192,0.0396,0.2289,0.0396,0.2229,0.0641,0.2156,0.0653,0.2274,0.0396,0.2192,0.0396,0.2155,0.0648,0.2231,0.0623,0.2241,0.0396,0.2279,0.0396,0.2236,0.0619,0.2188,0.0594,0.3124,0.0433,0.3013,0.0584,0.2773,0.077,0.2885,0.069,0.2712,0.0801,0.2689,0.0801,0.2673,0.0808,0.2567,0.0869,0.2539,0.0889,0.2533,0.0854,0.2526,0.0854,0.2471,0.0897,0.2476,0.0886,0.2503,0.0811,0.2506,0.0806,0.2501,0.0844,0.2909,0.0864,0.2972,0.0724,0.2804,0.0936,0.2759,0.0957,0.2743,0.0961,0.2731,0.0958,0.2733,0.0945,0.2739,0.0933,0.2763,0.0899,0.2818,0.0852,0.2588,0.0746,0.2527,0.0824,0.279,0.0892,0.313,0.0566,0.3133,0.0483,0.3148,0.0428,0.3127,0.0578,0.2897,0.0785,0.2875,0.0791,0.3058,0.0396,0.3068,0.0396};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_25()
		{
			double[] value = {0.3015,0.0396,0.3079,0.0465,0.2579,0.049,0.2545,0.0396,0.2373,0.0396,0.2385,0.0537,0.267,0.0655,0.2645,0.0652,0.3071,0.047,0.3015,0.0396,0.2857,0.0396,0.2892,0.043,0.2957,0.0518,0.3031,0.0661,0.2556,0.0445,0.2581,0.0472,0.2277,0.0396,0.2219,0.0575,0.2756,0.06,0.2669,0.044,0.2578,0.0447,0.2659,0.0637,0.2933,0.0742,0.2557,0.0396,0.2552,0.0396,0.2582,0.0396,0.2674,0.0396,0.2582,0.0396,0.2614,0.0479,0.2264,0.0611,0.2308,0.0396,0.2524,0.0786,0.2263,0.0632,0.2322,0.0396,0.2549,0.0833,0.2538,0.0603,0.2521,0.0396,0.2698,0.0791,0.2711,0.0377,0.2977,0.0377,0.2607,0.0377,0.2557,0.0377,0.2539,0.0377,0.2581,0.0377,0.2483,0.0377,0.2333,0.0377,0.2306,0.0377,0.2322,0.0377,0.2393,0.0377,0.2306,0.0377,0.2221,0.0377,0.2221,0.0377,0.2291,0.0377,0.2382,0.0377,0.2304,0.0377,0.2272,0.0377,0.2297,0.0377,0.2379,0.0377,0.2544,0.0377,0.2629,0.0377,0.2572,0.0377,0.2569,0.0377,0.2598,0.0377,0.2671,0.0377,0.2842,0.0377,0.2986,0.0377,0.2987,0.0377,0.3039,0.0377,0.3029,0.0377,0.27,0.0352,0.2953,0.0352,0.261,0.0352,0.2581,0.0352,0.257,0.0352,0.2641,0.0352,0.2477,0.0352,0.2346,0.0352,0.2333,0.0352,0.2349,0.0352,0.2463,0.0352,0.2322,0.0352,0.2249,0.0352,0.2249,0.0352,0.2308,0.0352,0.2457,0.0352,0.2329,0.0352,0.2302,0.0352,0.2316,0.0352,0.2385,0.0352,0.2543,0.0352,0.2682,0.0352,0.2617,0.0352,0.2621,0.0352,0.2669,0.0352,0.2827,0.0352,0.2957,0.0352,0.2958,0.0352,0.301,0.0352,0.3,0.0352,0.2748,0.0352};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_26()
		{
			double[] value = {0.2647,0.0352,0.2579,0.0352,0.2594,0.0352,0.2573,0.0352,0.2605,0.0352,0.2765,0.0352,0.2623,0.0352,0.2886,0.0352,0.287,0.0352,0.2971,0.034,0.2979,0.034,0.2858,0.034,0.2751,0.034,0.2664,0.034,0.2617,0.034,0.2599,0.034,0.2627,0.034,0.2643,0.034,0.2766,0.034,0.2872,0.034,0.2934,0.034,0.5414,0.2202,0.5412,0.2209,0.5404,0.2211,0.5406,0.2201,0.5415,0.2211,0.5412,0.2216,0.5422,0.2208,0.5421,0.2202,0.5419,0.2201,0.542,0.2211,0.5418,0.22,0.5415,0.2198,0.5399,0.2212,0.5401,0.2199,0.5409,0.2218,0.5419,0.2198,0.542,0.2211,0.5413,0.2194,0.5393,0.2209,0.5397,0.2193,0.5407,0.2218,0.5419,0.2193,0.5421,0.2209,0.5413,0.2189,0.5388,0.2202,0.5395,0.2185,0.5408,0.2215,0.5421,0.2185,0.5422,0.2203,0.5414,0.218,0.5388,0.219,0.5397,0.2175,0.5412,0.2206,0.5425,0.2177,0.5426,0.2195,0.5416,0.2171,0.5392,0.2175,0.5401,0.2161,0.5419,0.2193,0.5431,0.2165,0.5432,0.2182,0.5422,0.2158,0.5402,0.2147,0.5411,0.2137,0.5433,0.2169,0.5445,0.2143,0.5446,0.216,0.5433,0.2135,0.542,0.211,0.5426,0.2107,0.5457,0.2134,0.546,0.2123,0.5465,0.2133,0.5445,0.2112,0.5436,0.2074,0.544,0.2078,0.5482,0.2104,0.5475,0.2102,0.5485,0.2108,0.5458,0.209,0.544,0.204,0.5441,0.2059,0.551,0.2088,0.5511,0.2106,0.5559,0.2019,0.556,0.2038,0.549,0.1991,0.5489,0.1972,0.5538,0.244,0.554,0.2448,0.5534,0.2456,0.5531,0.2447,0.5545,0.2449,0.5546,0.2458,0.5551,0.2442,0.5547,0.2439,0.5547,0.2442,0.5553,0.245,0.5543,0.2438};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_27()
		{
			double[] value = {0.5541,0.2441,0.553,0.2462,0.5527,0.245,0.5545,0.2465,0.5548,0.2443,0.5555,0.2454,0.5539,0.2441,0.5526,0.2467,0.5523,0.2451,0.5546,0.247,0.5548,0.2442,0.5558,0.2456,0.5539,0.244,0.552,0.2468,0.552,0.245,0.555,0.2473,0.555,0.2438,0.5561,0.2456,0.5539,0.2436,0.5518,0.2463,0.552,0.2444,0.5554,0.2468,0.5553,0.2433,0.5564,0.2451,0.554,0.2431,0.5519,0.2453,0.5521,0.2434,0.5559,0.2459,0.5556,0.2422,0.5568,0.2441,0.5542,0.242,0.5522,0.243,0.5524,0.2412,0.5569,0.2437,0.5564,0.2401,0.5577,0.242,0.5547,0.2398,0.5528,0.2393,0.5529,0.2382,0.5584,0.2401,0.5574,0.2378,0.5589,0.2391,0.5551,0.2374,0.5531,0.2356,0.5534,0.2352,0.5601,0.2367,0.5582,0.2353,0.5601,0.2362,0.5557,0.2349,0.5521,0.2325,0.5521,0.2327,0.5628,0.2341,0.5627,0.2343,0.5652,0.2258,0.5652,0.2261,0.5545,0.2245,0.5545,0.2242,0.5761,0.2471,0.5764,0.2478,0.5761,0.2486,0.5756,0.2478,0.577,0.2477,0.5773,0.2484,0.5773,0.2469,0.5769,0.2466,0.5771,0.2468,0.5779,0.2475,0.5765,0.2467,0.5764,0.2469,0.576,0.2492,0.5754,0.2481,0.5776,0.249,0.5772,0.2468,0.5782,0.2477,0.5763,0.2469,0.5758,0.2496,0.5751,0.2482,0.5779,0.2493,0.5773,0.2466,0.5786,0.2477,0.5764,0.2467,0.5755,0.2497,0.5749,0.248,0.5784,0.2493,0.5774,0.246,0.5789,0.2474,0.5763,0.2462,0.5752,0.2491,0.5747,0.2473,0.5788,0.2486,0.5776,0.2453,0.5792,0.2466,0.5763,0.2455,0.575,0.2479,0.5746,0.2462,0.5791,0.2473,0.5777,0.2441,0.5794,0.2455,0.5762,0.2443,0.5748,0.2455};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_28()
		{
			double[] value = {0.5744,0.2438,0.5795,0.2448,0.5779,0.2417,0.5797,0.243,0.5761,0.242,0.5744,0.2416,0.5741,0.2407,0.5799,0.2408,0.5781,0.2392,0.58,0.2398,0.5758,0.2395,0.5737,0.2379,0.5737,0.2376,0.5806,0.2369,0.5782,0.2365,0.5804,0.2366,0.5757,0.2369,0.5718,0.2352,0.5716,0.2358,0.5824,0.2336,0.5822,0.2343,0.5823,0.225,0.5821,0.2256,0.5715,0.2272,0.5717,0.2265,0.5962,0.2388,0.5966,0.2396,0.5964,0.241,0.5958,0.2404,0.5971,0.2395,0.5976,0.2407,0.5974,0.2385,0.5969,0.2386,0.5971,0.2394,0.598,0.2398,0.5965,0.2387,0.5965,0.2396,0.5963,0.2422,0.5956,0.2413,0.5978,0.2418,0.5973,0.2399,0.5983,0.2406,0.5964,0.2402,0.5962,0.2436,0.5953,0.2423,0.5982,0.243,0.5973,0.2406,0.5987,0.2414,0.5964,0.2408,0.5958,0.2449,0.595,0.2432,0.5987,0.2441,0.5974,0.241,0.599,0.2421,0.5963,0.2413,0.5955,0.2453,0.5948,0.2434,0.599,0.2444,0.5974,0.2409,0.5992,0.2422,0.5962,0.2413,0.5952,0.2453,0.5946,0.2432,0.5991,0.2443,0.5974,0.2404,0.5992,0.2419,0.596,0.2408,0.5946,0.2443,0.5941,0.242,0.5992,0.2431,0.5973,0.2389,0.5992,0.2406,0.5956,0.2394,0.5938,0.2418,0.5934,0.2399,0.5992,0.2404,0.5973,0.2369,0.5992,0.2383,0.595,0.2375,0.5927,0.2391,0.5927,0.2374,0.5995,0.2373,0.5971,0.2347,0.5993,0.2357,0.5947,0.2353,0.5905,0.2371,0.5905,0.2348,0.601,0.2343,0.6009,0.232,0.5999,0.2263,0.5999,0.2241,0.5894,0.2269,0.5895,0.2291,0.6052,0.2184,0.6057,0.2192,0.6057,0.2205,0.6052,0.22,0.6061,0.219,0.6068,0.2202,0.6063,0.218};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_29()
		{
			double[] value = {0.606,0.2181,0.6064,0.2189,0.6071,0.2192,0.6056,0.2183,0.6058,0.2191,0.6059,0.2217,0.6052,0.2209,0.6072,0.2212,0.6067,0.2194,0.6077,0.22,0.606,0.2197,0.6061,0.2231,0.6052,0.2219,0.6079,0.2224,0.607,0.22,0.6084,0.2207,0.6062,0.2203,0.6061,0.2244,0.6054,0.2227,0.6087,0.2234,0.6074,0.2204,0.609,0.2214,0.6065,0.2207,0.6062,0.2248,0.6054,0.2229,0.6094,0.2237,0.6077,0.2203,0.6094,0.2215,0.6066,0.2207,0.6062,0.2248,0.6055,0.2227,0.6099,0.2235,0.6079,0.2198,0.6097,0.2212,0.6066,0.2203,0.6061,0.2238,0.6053,0.2216,0.6103,0.2223,0.608,0.2183,0.6101,0.2198,0.6064,0.2188,0.6057,0.2213,0.605,0.2194,0.6107,0.2195,0.6081,0.2162,0.6102,0.2175,0.606,0.217,0.6049,0.2187,0.6044,0.217,0.611,0.2164,0.6079,0.214,0.6104,0.2149,0.6057,0.2148,0.6029,0.2168,0.6019,0.2146,0.6124,0.2133,0.6114,0.2112,0.6114,0.2054,0.6103,0.2032,0.6008,0.2067,0.6019,0.2089,0.7713,0.2319,0.775,0.2397,0.7733,0.2481,0.7674,0.2525,0.765,0.2525,0.7604,0.249,0.7582,0.2401,0.7612,0.2332,0.7538,0.2308,0.7557,0.2397,0.7511,0.2473,0.7451,0.2489,0.7436,0.2481,0.7424,0.244,0.7411,0.2345,0.7463,0.2297,0.7794,0.228,0.7833,0.2284,0.7877,0.2382,0.7877,0.2461,0.7869,0.2468,0.7821,0.2458,0.7771,0.239,0.7758,0.2321,0.7811,0.2126,0.786,0.2077,0.7946,0.2228,0.796,0.2282,0.795,0.2299,0.7931,0.2306,0.7841,0.2264,0.7803,0.22,0.7515,0.2068,0.7637,0.2037,0.7744,0.2043,0.7777,0.2121,0.777,0.2194,0.7769,0.2254,0.7708,0.2286};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_30()
		{
			double[] value = {0.7608,0.2299,0.7558,0.2279,0.7483,0.2268,0.7481,0.2183,0.7504,0.2111,0.7452,0.2185,0.7412,0.2235,0.7368,0.2274,0.7349,0.2271,0.7348,0.2243,0.738,0.2148,0.745,0.207,0.7475,0.2113,0.7377,0.2141,0.7457,0.2052,0.7485,0.2101,0.7459,0.2184,0.7413,0.2241,0.7362,0.2286,0.734,0.2283,0.734,0.2251,0.7595,0.2498,0.757,0.2396,0.7605,0.2316,0.772,0.2302,0.7763,0.2392,0.7743,0.2488,0.7676,0.2538,0.7648,0.2538,0.7417,0.2445,0.7401,0.2337,0.7462,0.2282,0.7547,0.2294,0.7517,0.2484,0.7448,0.2502,0.7431,0.2493,0.782,0.247,0.7749,0.2312,0.779,0.2265,0.7834,0.227,0.7885,0.2382,0.7885,0.2472,0.7875,0.2481,0.7937,0.2318,0.7791,0.2196,0.7799,0.2112,0.7856,0.2055,0.7955,0.2229,0.797,0.2291,0.796,0.2311,0.434,0.3512,0.4295,0.3424,0.4268,0.3446,0.4318,0.3543,0.4401,0.3682,0.4359,0.3695,0.4324,0.3958,0.4374,0.3958,0.424,0.4397,0.4307,0.4368,0.4234,0.4481,0.4376,0.3569,0.4339,0.3583,0.4243,0.3523,0.4331,0.3574,0.4361,0.3583,0.4267,0.3531,0.3478,0.3241,0.3979,0.3426,0.4002,0.3439,0.4387,0.3679,0.4419,0.3674,0.4398,0.3946,0.4443,0.3949,0.323,0.3226,0.3464,0.327,0.4258,0.3441,0.4395,0.4231,0.426,0.3266,0.427,0.3322,0.4748,0.3323,0.4732,0.323,0.4424,0.4455,0.469,0.4459,0.3922,0.4558,0.3653,0.4677,0.2682,0.417,0.4039,0.3793,0.3971,0.3683,0.4118,0.4496,0.4074,0.4028,0.3892,0.409,0.3566,0.418,0.3614,0.3701,0.3887,0.3799,0.2737,0.4137,0.2847,0.3646,0.2973,0.3653,0.2742,0.3727,0.2792,0.3556};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_31()
		{
			double[] value = {0.2872,0.3528,0.2841,0.3455,0.2771,0.361,0.2738,0.3693,0.3135,0.3238,0.2961,0.3226,0.3264,0.3138,0.3247,0.3182,0.2941,0.3306,0.292,0.3386,0.3354,0.4782,0.3214,0.4208,0.3267,0.3695,0.3,0.4892,0.2886,0.4195,0.3998,0.34,0.3984,0.3541,0.368,0.3439,0.3647,0.357,0.3331,0.3447,0.3299,0.3571,0.3055,0.3425,0.3015,0.3539,0.419,0.3258,0.4224,0.3349,0.3971,0.3344,0.3959,0.3222,0.3523,0.3128,0.3496,0.3196,0.3407,0.3229,0.3932,0.3154,0.4237,0.313,0.3973,0.3345,0.4369,0.3555,0.4404,0.3664,0.4395,0.3947,0.438,0.4232,0.3204,0.3243,0.3452,0.3281,0.2922,0.3398,0.3956,0.329,0.2911,0.3301,0.2841,0.3386,0.2898,0.341,0.4246,0.3327,0.4216,0.3339,0.4164,0.3126,0.4139,0.3143,0.4079,0.2788,0.4055,0.2804,0.4034,0.2603,0.4011,0.2619,0.3952,0.2202,0.3922,0.2212,0.3791,0.1744,0.3761,0.1756,0.3691,0.1445,0.3667,0.1451,0.3658,0.1215,0.3637,0.1211,0.3639,0.11,0.362,0.1096,0.3619,0.0952,0.3056,0.284,0.3082,0.2674,0.3096,0.2672,0.3442,0.2765,0.344,0.2945,0.3716,0.2903,0.3711,0.2716,0.3905,0.2859,0.386,0.2676,0.4048,0.277,0.4006,0.2587,0.3904,0.2768,0.3877,0.2597,0.3575,0.2763,0.3582,0.2598,0.3336,0.2789,0.3342,0.2621,0.3259,0.2802,0.3223,0.2972,0.3094,0.2816,0.3092,0.2983,0.292,0.2773,0.2919,0.2948,0.2923,0.2691,0.2917,0.2866,0.33,0.1209,0.333,0.1326,0.348,0.1258,0.3448,0.1148,0.3585,0.1205,0.3567,0.1091,0.3661,0.122,0.3636,0.1104,0.3533,0.1274,0.3505,0.1162,0.3421,0.1307,0.3395,0.1195};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_32()
		{
			double[] value = {0.3309,0.134,0.3285,0.1227,0.3187,0.1347,0.3171,0.1233,0.3072,0.1354,0.3068,0.124,0.2945,0.1351,0.2947,0.1246,0.2965,0.1365,0.2952,0.1264,0.3056,0.1356,0.304,0.1253,0.3159,0.1344,0.3152,0.1235,0.3714,0.3237,0.3376,0.3256,0.3174,0.1573,0.3286,0.1558,0.3106,0.3241,0.3439,0.2309,0.3336,0.2325,0.339,0.1857,0.3309,0.1859,0.3348,0.1549,0.2896,0.3154,0.2923,0.3231,0.2899,0.2308,0.2943,0.2353,0.2911,0.1909,0.2953,0.188,0.2933,0.1541,0.2974,0.1563,0.2945,0.1151,0.2931,0.1177,0.3993,0.3188,0.3778,0.2256,0.3673,0.1783,0.3618,0.1477,0.3539,0.094,0.3654,0.2264,0.3572,0.1847,0.3529,0.1519,0.3447,0.0997,0.3139,0.2353,0.3147,0.1864,0.3146,0.1132,0.3316,0.1061,0.3044,0.1872,0.3068,0.1569,0.4136,0.3096,0.3939,0.3041,0.395,0.2199,0.3793,0.221,0.3796,0.1737,0.3651,0.1795,0.3693,0.1455,0.3575,0.1527,0.3604,0.0959,0.3457,0.1017,0.3554,0.3007,0.3569,0.2236,0.3352,0.1052,0.3461,0.1551,0.3507,0.1854,0.3366,0.2257,0.3291,0.304,0.3347,0.1574,0.3208,0.1565,0.3362,0.189,0.3211,0.1912,0.3186,0.2273,0.2995,0.3092,0.306,0.1127,0.3075,0.1558,0.3066,0.1915,0.3072,0.2287,0.3013,0.1162,0.3334,0.1,0.3292,0.0965,0.3433,0.0965,0.3577,0.0909,0.3592,0.0903,0.3518,0.0888,0.3232,0.103,0.3147,0.111,0.3247,0.1088,0.3268,0.0888,0.3248,0.0782,0.3083,0.0943,0.3104,0.1005,0.2971,0.106,0.2952,0.102,0.2891,0.1042,0.2902,0.1077,0.294,0.0987,0.2937,0.1036,0.3317,0.0842,0.3329,0.0668,0.3389,0.0735,0.3298,0.0806};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_33()
		{
			double[] value = {0.3253,0.0751,0.3406,0.0707,0.3355,0.0632,0.3348,0.0636,0.3387,0.0726,0.3036,0.1011,0.3024,0.0961,0.3086,0.0927,0.3108,0.0986,0.3345,0.0871,0.3451,0.0813,0.3459,0.0793,0.3428,0.0825,0.3152,0.0888,0.3191,0.0954,0.3291,0.1004,0.3423,0.0945,0.3128,0.1077,0.2993,0.1109,0.2915,0.1121,0.3204,0.0821,0.3259,0.0871,0.2937,0.1094,0.3051,0.1071,0.3132,0.1055,0.3001,0.0396,0.2722,0.0396,0.286,0.0462,0.2739,0.0534,0.2603,0.0396,0.2638,0.0599,0.2525,0.0607,0.2575,0.0621,0.2533,0.0396,0.2508,0.0396,0.2298,0.0633,0.2506,0.0614,0.2489,0.0396,0.232,0.0396,0.2238,0.0641,0.2243,0.0649,0.2275,0.0396,0.2295,0.0396,0.2156,0.0653,0.2229,0.0641,0.2289,0.0396,0.2192,0.0396,0.2231,0.0623,0.2154,0.0648,0.2192,0.0396,0.2274,0.0396,0.2188,0.0594,0.2236,0.0619,0.2279,0.0396,0.2241,0.0396,0.3013,0.0584,0.3124,0.0433,0.2885,0.069,0.2773,0.077,0.2689,0.0801,0.2712,0.0801,0.2567,0.0869,0.2672,0.0808,0.2533,0.0854,0.2539,0.0889,0.2471,0.0897,0.2525,0.0854,0.2503,0.0811,0.2476,0.0886,0.2501,0.0844,0.2506,0.0806,0.2972,0.0724,0.2909,0.0864,0.2804,0.0936,0.2759,0.0957,0.2731,0.0958,0.2743,0.0961,0.2732,0.0945,0.2763,0.0899,0.2739,0.0933,0.279,0.0892,0.2527,0.0824,0.2588,0.0746,0.2818,0.0852,0.3133,0.0483,0.313,0.0566,0.3148,0.0428,0.3127,0.0578,0.2875,0.0791,0.2897,0.0785,0.3057,0.0396,0.3079,0.0465,0.3015,0.0396,0.3068,0.0396,0.2385,0.0537,0.2372,0.0396,0.2545,0.0396,0.2579,0.049,0.267,0.0655,0.2645,0.0652};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_34()
		{
			double[] value = {0.2892,0.043,0.2857,0.0396,0.3015,0.0396,0.3071,0.047,0.3031,0.0661,0.2957,0.0518,0.2581,0.0472,0.2556,0.0445,0.2219,0.0575,0.2277,0.0396,0.2659,0.0637,0.2578,0.0447,0.2669,0.044,0.2756,0.06,0.2933,0.0742,0.2552,0.0396,0.2557,0.0396,0.2674,0.0396,0.2582,0.0396,0.2614,0.0479,0.2582,0.0396,0.2308,0.0396,0.2264,0.0611,0.2523,0.0786,0.2322,0.0396,0.2263,0.0632,0.2549,0.0833,0.2521,0.0396,0.2538,0.0603,0.2698,0.0791,0.2977,0.0377,0.2711,0.0377,0.2607,0.0377,0.2557,0.0377,0.2539,0.0377,0.2581,0.0377,0.2483,0.0377,0.2333,0.0377,0.2306,0.0377,0.2322,0.0377,0.2393,0.0377,0.2306,0.0377,0.2221,0.0377,0.2221,0.0377,0.2291,0.0377,0.2382,0.0377,0.2304,0.0377,0.2272,0.0377,0.2297,0.0377,0.2379,0.0377,0.2544,0.0377,0.2629,0.0377,0.2572,0.0377,0.2569,0.0377,0.2598,0.0377,0.2671,0.0377,0.2842,0.0377,0.2986,0.0377,0.2987,0.0377,0.3039,0.0377,0.3029,0.0377,0.2953,0.0352,0.27,0.0352,0.261,0.0352,0.2581,0.0352,0.257,0.0352,0.2641,0.0352,0.2477,0.0352,0.2345,0.0352,0.2333,0.0352,0.2349,0.0352,0.2463,0.0352,0.2322,0.0352,0.2249,0.0352,0.2249,0.0352,0.2308,0.0352,0.2457,0.0352,0.2329,0.0352,0.2302,0.0352,0.2316,0.0352,0.2385,0.0352,0.2543,0.0352,0.2682,0.0352,0.2617,0.0352,0.2621,0.0352,0.2669,0.0352,0.2827,0.0352,0.2957,0.0352,0.2958,0.0352,0.301,0.0352,0.3,0.0352,0.2647,0.0352,0.2748,0.0352,0.2594,0.0352,0.2579,0.0352,0.2605,0.0352,0.2573,0.0352,0.2623,0.0352,0.2765,0.0352,0.2886,0.0352};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_35()
		{
			double[] value = {0.287,0.0352,0.2979,0.034,0.2971,0.034,0.2858,0.034,0.2751,0.034,0.2663,0.034,0.2617,0.034,0.2599,0.034,0.2627,0.034,0.2643,0.034,0.2766,0.034,0.2872,0.034,0.2934,0.034,0.514,0.2201,0.5142,0.2211,0.5134,0.2209,0.5132,0.2202,0.5134,0.2216,0.5131,0.2211,0.5125,0.2211,0.5127,0.2201,0.5125,0.2202,0.5124,0.2208,0.5131,0.2198,0.5128,0.22,0.5144,0.2199,0.5147,0.2212,0.5137,0.2218,0.5126,0.2211,0.5126,0.2198,0.5132,0.2194,0.5148,0.2193,0.5153,0.2209,0.5139,0.2218,0.5125,0.2209,0.5127,0.2193,0.5132,0.2189,0.515,0.2185,0.5157,0.2202,0.5138,0.2215,0.5124,0.2203,0.5124,0.2185,0.5132,0.218,0.5149,0.2175,0.5157,0.219,0.5134,0.2206,0.512,0.2195,0.5121,0.2177,0.5129,0.2171,0.5145,0.2161,0.5154,0.2175,0.5127,0.2193,0.5113,0.2182,0.5115,0.2165,0.5124,0.2158,0.5135,0.2137,0.5144,0.2147,0.5113,0.2169,0.51,0.216,0.5101,0.2143,0.5113,0.2135,0.512,0.2107,0.5126,0.211,0.5089,0.2134,0.5081,0.2133,0.5086,0.2123,0.5101,0.2112,0.5106,0.2078,0.511,0.2074,0.5064,0.2104,0.5061,0.2108,0.5071,0.2102,0.5087,0.209,0.5105,0.2059,0.5106,0.204,0.5035,0.2088,0.5035,0.2106,0.5057,0.1972,0.5056,0.1991,0.4986,0.2038,0.4987,0.2019,0.5015,0.2447,0.5012,0.2456,0.5006,0.2448,0.5007,0.244,0.5,0.2458,0.5001,0.2449,0.4992,0.245,0.4998,0.2442,0.4998,0.2439,0.4995,0.2442,0.5005,0.2441,0.5003,0.2438,0.5019,0.245,0.5016,0.2462,0.5,0.2465,0.4991,0.2454,0.4997,0.2443,0.5006,0.2441,0.5023,0.2451};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_36()
		{
			double[] value = {0.502,0.2467,0.4999,0.247,0.4988,0.2456,0.4997,0.2442,0.5006,0.244,0.5025,0.245,0.5025,0.2468,0.4996,0.2473,0.4985,0.2456,0.4995,0.2438,0.5006,0.2436,0.5026,0.2444,0.5027,0.2463,0.4991,0.2468,0.4982,0.2451,0.4993,0.2433,0.5006,0.2431,0.5025,0.2434,0.5027,0.2453,0.4986,0.2459,0.4977,0.2441,0.4989,0.2422,0.5004,0.242,0.5022,0.2412,0.5024,0.243,0.4977,0.2437,0.4969,0.242,0.4981,0.2401,0.4999,0.2398,0.5016,0.2382,0.5018,0.2393,0.4962,0.2401,0.4957,0.2391,0.4972,0.2378,0.4995,0.2374,0.5012,0.2352,0.5015,0.2356,0.4945,0.2367,0.4944,0.2362,0.4964,0.2353,0.4989,0.2349,0.5025,0.2327,0.5025,0.2325,0.4918,0.2341,0.4918,0.2343,0.5001,0.2242,0.5001,0.2245,0.4894,0.2261,0.4894,0.2258,0.479,0.2478,0.4784,0.2486,0.4781,0.2478,0.4785,0.2471,0.4772,0.2484,0.4776,0.2477,0.4767,0.2475,0.4775,0.2468,0.4777,0.2466,0.4773,0.2469,0.4782,0.2469,0.4781,0.2467,0.4792,0.2481,0.4785,0.2492,0.477,0.249,0.4764,0.2477,0.4774,0.2468,0.4782,0.2469,0.4795,0.2482,0.4788,0.2496,0.4767,0.2493,0.476,0.2477,0.4773,0.2466,0.4782,0.2467,0.4797,0.248,0.4791,0.2497,0.4762,0.2493,0.4756,0.2474,0.4771,0.246,0.4782,0.2462,0.4798,0.2473,0.4794,0.2491,0.4758,0.2486,0.4754,0.2466,0.477,0.2453,0.4783,0.2455,0.48,0.2462,0.4795,0.2479,0.4755,0.2473,0.4752,0.2455,0.4769,0.2441,0.4783,0.2443,0.4802,0.2438,0.4798,0.2455,0.4751,0.2448,0.4749,0.243,0.4767,0.2417,0.4785,0.242,0.4805,0.2407,0.4802,0.2416,0.4747,0.2408};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_37()
		{
			double[] value = {0.4746,0.2398,0.4765,0.2392,0.4788,0.2395,0.4809,0.2376,0.4809,0.2379,0.474,0.2369,0.4742,0.2366,0.4764,0.2365,0.4789,0.2369,0.483,0.2358,0.4828,0.2352,0.4722,0.2336,0.4724,0.2343,0.4829,0.2265,0.4831,0.2272,0.4725,0.2256,0.4723,0.225,0.4588,0.2404,0.4582,0.241,0.458,0.2396,0.4584,0.2388,0.457,0.2407,0.4575,0.2395,0.4566,0.2398,0.4575,0.2394,0.4576,0.2386,0.4572,0.2385,0.4581,0.2396,0.458,0.2387,0.459,0.2413,0.4582,0.2422,0.4567,0.2418,0.4562,0.2406,0.4573,0.2399,0.4582,0.2402,0.4593,0.2423,0.4584,0.2436,0.4564,0.243,0.4558,0.2414,0.4573,0.2406,0.4582,0.2408,0.4595,0.2432,0.4587,0.2449,0.4559,0.2441,0.4556,0.2421,0.4572,0.241,0.4583,0.2413,0.4598,0.2434,0.4591,0.2453,0.4556,0.2444,0.4554,0.2422,0.4572,0.2409,0.4584,0.2413,0.46,0.2432,0.4594,0.2453,0.4554,0.2443,0.4553,0.2419,0.4572,0.2404,0.4586,0.2408,0.4605,0.242,0.46,0.2443,0.4553,0.2431,0.4553,0.2406,0.4573,0.2389,0.459,0.2394,0.4612,0.2399,0.4608,0.2418,0.4554,0.2404,0.4553,0.2383,0.4573,0.2369,0.4595,0.2375,0.4619,0.2374,0.4619,0.2391,0.4551,0.2373,0.4553,0.2357,0.4575,0.2347,0.4599,0.2353,0.4641,0.2348,0.464,0.2371,0.4536,0.2343,0.4537,0.232,0.465,0.2291,0.4651,0.2269,0.4547,0.2241,0.4546,0.2263,0.4494,0.22,0.4489,0.2205,0.4489,0.2192,0.4494,0.2184,0.4478,0.2202,0.4484,0.219,0.4474,0.2192,0.4482,0.2189,0.4486,0.2181,0.4483,0.218,0.4488,0.2191,0.4489,0.2183,0.4494,0.2209,0.4487,0.2217,0.4473,0.2212};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_38()
		{
			double[] value = {0.4469,0.22,0.4478,0.2194,0.4486,0.2197,0.4494,0.2219,0.4485,0.2231,0.4467,0.2224,0.4462,0.2207,0.4475,0.22,0.4483,0.2203,0.4492,0.2227,0.4484,0.2244,0.4458,0.2234,0.4456,0.2214,0.4471,0.2204,0.4481,0.2207,0.4491,0.2229,0.4484,0.2248,0.4452,0.2237,0.4452,0.2215,0.4469,0.2203,0.448,0.2207,0.4491,0.2227,0.4483,0.2248,0.4447,0.2235,0.4448,0.2212,0.4467,0.2198,0.448,0.2203,0.4492,0.2216,0.4484,0.2238,0.4442,0.2223,0.4445,0.2198,0.4466,0.2183,0.4481,0.2188,0.4496,0.2194,0.4489,0.2213,0.4439,0.2195,0.4443,0.2175,0.4465,0.2162,0.4485,0.217,0.4502,0.217,0.4497,0.2187,0.4435,0.2164,0.4442,0.2149,0.4466,0.214,0.4489,0.2148,0.4527,0.2146,0.4516,0.2168,0.4421,0.2133,0.4432,0.2112,0.4527,0.2089,0.4537,0.2067,0.4443,0.2032,0.4432,0.2054,0.678,0.228,0.681,0.2349,0.6788,0.2438,0.6742,0.2473,0.6718,0.2473,0.6659,0.243,0.6642,0.2345,0.668,0.2267,0.6929,0.2246,0.6981,0.2294,0.6968,0.2388,0.6956,0.2429,0.6941,0.2437,0.6881,0.2422,0.6835,0.2345,0.6854,0.2256,0.6634,0.2269,0.6621,0.2338,0.6572,0.2407,0.6524,0.2416,0.6515,0.2409,0.6515,0.233,0.6559,0.2232,0.6598,0.2228,0.6589,0.2148,0.6551,0.2212,0.6461,0.2254,0.6442,0.2247,0.6433,0.223,0.6446,0.2176,0.6532,0.2025,0.6582,0.2075,0.6888,0.2059,0.6911,0.2132,0.6909,0.2216,0.6834,0.2227,0.6784,0.2247,0.6684,0.2234,0.6623,0.2202,0.6622,0.2142,0.6615,0.2069,0.6649,0.1991,0.6755,0.1985,0.6877,0.2016,0.6917,0.2061,0.6942,0.2019,0.7012,0.2096};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_39()
		{
			double[] value = {0.7044,0.2191,0.7044,0.222,0.7024,0.2222,0.6981,0.2183,0.694,0.2133,0.6935,0.2,0.7016,0.209,0.6907,0.2049,0.6933,0.2132,0.6979,0.2189,0.703,0.2234,0.7052,0.2231,0.7052,0.2199,0.6823,0.2344,0.6797,0.2446,0.6787,0.2265,0.6673,0.225,0.6629,0.234,0.6649,0.2436,0.6716,0.2487,0.6744,0.2487,0.6991,0.2285,0.6975,0.2394,0.6931,0.223,0.6845,0.2242,0.6875,0.2432,0.6944,0.245,0.6962,0.2441,0.6573,0.2418,0.6644,0.226,0.6602,0.2213,0.6558,0.2218,0.6507,0.233,0.6507,0.2421,0.6517,0.2429,0.6455,0.2266,0.6601,0.2144,0.6593,0.206,0.6537,0.2003,0.6438,0.2177,0.6422,0.2239,0.6433,0.2259,0.2009,0.5334,0.1965,0.5267,0.1929,0.5279,0.2104,0.4808,0.207,0.4884,0.2104,0.4915,0.2144,0.4861,0.2218,0.4657,0.2189,0.4599,0.2154,0.4671,0.2197,0.474,0.2088,0.4931,0.2052,0.49,0.2026,0.4941,0.2071,0.4984,0.2027,0.5062,0.1992,0.5005,0.1964,0.5045,0.199,0.5089,0.2199,0.4943,0.2155,0.4986,0.2258,0.5035,0.2209,0.459,0.2236,0.4647,0.2254,0.4627,0.2237,0.456,0.2273,0.4507,0.2308,0.4618,0.2284,0.4772,0.2259,0.4844,0.2363,0.4984,0.247,0.5309,0.2404,0.5116,0.2334,0.5242,0.2038,0.5188,0.2017,0.5227,0.2078,0.5309,0.2201,0.5485,0.2302,0.5428,0.2234,0.534,0.2145,0.5401,0.2401,0.5578,0.2353,0.5506,0.2245,0.556,0.2287,0.5629,0.2129,0.5589,0.2528,0.6133,0.2547,0.6222,0.2747,0.6187,0.2691,0.6042,0.2439,0.5964,0.2476,0.6023,0.2626,0.5922,0.226,0.6159,0.2209,0.6112,0.2329,0.645,0.2792,0.6356,0.2614,0.6439};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_40()
		{
			double[] value = {0.2636,0.6545,0.2818,0.6473,0.2343,0.5759,0.2446,0.5644,0.2325,0.5694,0.2826,0.6579,0.2826,0.6538,0.2643,0.6611,0.2643,0.6652,0.1933,0.5225,0.1924,0.5113,0.1961,0.5156,0.197,0.5102,0.1942,0.506,0.2168,0.5803,0.2036,0.4845,0.2146,0.4548,0.1992,0.488,0.2134,0.505,0.2198,0.4538,0.2259,0.4422,0.2315,0.4735,0.2221,0.5136,0.208,0.515,0.2149,0.5243,0.2421,0.5895,0.2351,0.6556,0.2578,0.6292,0.2856,0.6019,0.2719,0.576,0.2562,0.5816,0.25,0.5724,0.2372,0.5814,0.2519,0.5434,0.2615,0.5589,0.238,0.6747,0.2952,0.6372,0.1904,0.5038,0.1957,0.4994,0.2419,0.675,0.259,0.669,0.2762,0.6629,0.2969,0.6537,0.2065,0.5425,0.2106,0.551,0.2144,0.4861,0.2104,0.4915,0.207,0.4884,0.2104,0.4808,0.2197,0.474,0.2154,0.4671,0.2189,0.4599,0.2218,0.4657,0.2071,0.4984,0.2026,0.4941,0.2052,0.49,0.2088,0.4931,0.199,0.5089,0.1964,0.5045,0.1992,0.5005,0.2027,0.5062,0.2258,0.5035,0.2155,0.4986,0.2199,0.4943,0.2237,0.456,0.2254,0.4627,0.2236,0.4647,0.2209,0.459,0.2273,0.4507,0.2363,0.4984,0.2259,0.4844,0.2284,0.4772,0.2334,0.5242,0.2404,0.5116,0.247,0.5309,0.2078,0.5309,0.2017,0.5227,0.2038,0.5188,0.2145,0.5401,0.2234,0.534,0.2302,0.5428,0.2201,0.5485,0.2287,0.5629,0.2245,0.556,0.2353,0.5506,0.2401,0.5578,0.2289,0.6257,0.23,0.6329,0.2691,0.6042,0.2747,0.6187,0.2547,0.6222,0.2528,0.6133,0.2626,0.5922,0.2476,0.6023,0.2439,0.5964,0.2818,0.6473,0.2636,0.6545,0.2615,0.6439,0.2792,0.6356,0.2174,0.5896};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_41()
		{
			double[] value = {0.2209,0.5933,0.2325,0.5694,0.2446,0.5644,0.2343,0.5759,0.2643,0.6652,0.2643,0.6611,0.2826,0.6538,0.2826,0.6579,0.1933,0.5225,0.191,0.5251,0.1942,0.506,0.197,0.5102,0.1961,0.5156,0.1924,0.5113,0.2134,0.505,0.2315,0.4735,0.2221,0.5136,0.2149,0.5243,0.208,0.515,0.2421,0.5895,0.2578,0.6292,0.2856,0.6019,0.2562,0.5816,0.2719,0.576,0.2372,0.5814,0.25,0.5724,0.2519,0.5434,0.2615,0.5589,0.2986,0.6494,0.2952,0.6372,0.6173,0.7742,0.6338,0.7657,0.6327,0.7623,0.6338,0.7499,0.6306,0.7417,0.6132,0.7568,0.6182,0.7653,0.6611,0.8124,0.6612,0.8058,0.6717,0.7924,0.6729,0.7977,0.6258,0.7977,0.631,0.81,0.6326,0.7989,0.6221,0.7802,0.6249,0.785,0.6329,0.788,0.6339,0.78,0.6695,0.813,0.6707,0.8176,0.6597,0.8281,0.6594,0.8236,0.6607,0.8183,0.6729,0.8037,0.6286,0.734,0.6263,0.7299,0.607,0.7407,0.6083,0.7465,0.6118,0.7506,0.6286,0.7371,0.6278,0.8205,0.6273,0.8254,0.6269,0.8268,0.6263,0.83,0.625,0.8345,0.6223,0.8455,0.6199,0.8593,0.5949,0.843,0.5945,0.8133,0.6302,0.796,0.6294,0.8044,0.6289,0.8098,0.6287,0.8119,0.6285,0.8151,0.6223,0.7729,0.6248,0.7624,0.6259,0.769,0.624,0.7776,0.6264,0.7797,0.6288,0.7685,0.6299,0.7746,0.628,0.7836,0.6336,0.7805,0.6322,0.7888,0.6255,0.752,0.6267,0.7589,0.629,0.7584,0.6302,0.7649,0.6736,0.8111,0.6726,0.8172,0.678,0.7517,0.6725,0.777,0.6761,0.7898,0.6755,0.7965,0.6749,0.8033,0.6722,0.8031,0.6718,0.8117,0.6779,0.7644,0.6746,0.7812,0.6747,0.7884};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_42()
		{
			double[] value = {0.675,0.7963,0.6348,0.7715,0.6209,0.7906,0.6213,0.7922,0.6178,0.7915,0.6172,0.7883,0.6327,0.7747,0.6262,0.7387,0.6274,0.7452,0.6295,0.7452,0.6306,0.7517,0.6348,0.7599,0.619,0.7734,0.6189,0.784,0.6737,0.7838,0.6191,0.7752,0.6352,0.7687,0.6203,0.7772,0.6348,0.7736,0.6699,0.7467,0.6735,0.7649,0.6652,0.7715,0.6643,0.778,0.6641,0.7856,0.6631,0.7972,0.6614,0.808,0.6425,0.8149,0.6415,0.8205,0.6407,0.8253,0.6407,0.83,0.64,0.8344,0.6446,0.8101,0.6464,0.7982,0.6464,0.7863,0.6475,0.778,0.6485,0.7714,0.6485,0.7662,0.6474,0.7626,0.6472,0.7577,0.6502,0.7669,0.6459,0.7851,0.646,0.883,0.619,0.7941,0.6179,0.7928,0.6223,0.7866,0.6252,0.7877,0.6234,0.785,0.6425,0.8113,0.6616,0.801,0.6715,0.7881,0.6748,0.7858,0.6671,0.7694,0.6485,0.7696,0.6344,0.7718,0.6192,0.7768,0.6102,0.7498,0.6275,0.7366,0.6268,0.7454,0.6262,0.7589,0.6257,0.7689,0.6234,0.7789,0.6323,0.794,0.6247,0.792,0.6464,0.7929,0.6632,0.7908,0.6728,0.7983,0.6728,0.8065,0.6695,0.8083,0.66,0.8197,0.6407,0.8268,0.6311,0.7689,0.628,0.7805,0.6278,0.7676,0.6291,0.7684,0.6242,0.7284,0.6258,0.7259,0.6363,0.733,0.633,0.7305,0.6305,0.8308,0.6256,0.7265,0.634,0.7325,0.6175,0.7255,0.6343,0.7706,0.63,0.7803,0.6277,0.7813,0.6318,0.7728,0.6271,0.7907,0.6622,0.7835,0.663,0.7916,0.6683,0.8343,0.6655,0.8493,0.6555,0.854,0.657,0.8408,0.6433,0.8631,0.6597,0.8634,0.6527,0.8729,0.6208,0.7281,0.6202,0.7303,0.6302,0.7297,0.6299,0.7309};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_43()
		{
			double[] value = {0.6473,0.8796,0.6023,0.7814,0.6054,0.7994,0.6217,0.7824,0.6272,0.7741,0.6296,0.7642,0.6261,0.7281,0.6308,0.732,0.621,0.7274,0.6191,0.7264,0.6271,0.7279,0.6331,0.7339,0.6297,0.7732,0.632,0.7635,0.5923,0.7889,0.5961,0.7783,0.6015,0.7746,0.6282,0.7692,0.6299,0.7603,0.6309,0.7591,0.633,0.7597,0.6362,0.762,0.634,0.7643,0.6299,0.7516,0.6308,0.7504,0.633,0.7509,0.6363,0.7534,0.6344,0.755,0.6324,0.7538,0.6303,0.754,0.6721,0.833,0.6705,0.849,0.6597,0.8636,0.6536,0.8734,0.645,0.8832,0.6712,0.8282,0.6696,0.8443,0.6453,0.8586,0.6392,0.868,0.6316,0.877,0.6239,0.7826,0.6257,0.7821,0.6308,0.741,0.6299,0.74,0.6308,0.739,0.633,0.7395,0.6363,0.7419,0.6345,0.7429,0.6327,0.7413,0.6615,0.7995,0.6637,0.823,0.6613,0.8399,0.6446,0.7935,0.6435,0.803,0.6425,0.8091,0.6391,0.8458,0.637,0.859,0.6411,0.8583,0.6426,0.8574,0.6474,0.8504,0.6424,0.846,0.6441,0.8305,0.6232,0.8633,0.6227,0.8691,0.6244,0.8639,0.6043,0.7901,0.629,0.7725,0.6249,0.781,0.6312,0.7637,0.6317,0.7543,0.632,0.7419,0.6321,0.7337,0.6255,0.7285,0.6183,0.7272,0.6047,0.7349,0.6042,0.8009,0.6222,0.7298,0.6302,0.7311,0.6297,0.7389,0.6297,0.7504,0.6297,0.7589,0.6231,0.7801,0.6279,0.7883,0.6306,0.795,0.6304,0.782,0.6602,0.8348,0.7201,0.9324,0.7499,0.9111,0.7191,0.9335,0.7562,0.9197,0.757,0.9171,0.7776,0.9038,0.6287,0.7845,0.629,0.7849,0.6286,0.7842,0.6282,0.7839,0.6633,0.7443,0.6624,0.7437,0.6551,0.7469,0.6556,0.7467};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_44()
		{
			double[] value = {0.6348,0.7939,0.6307,0.7816,0.6277,0.7876,0.6306,0.7807,0.6608,0.7667,0.6425,0.7585,0.6423,0.7574,0.637,0.7709,0.6365,0.7703,0.6292,0.7935,0.6267,0.7815,0.6264,0.7814,0.6227,0.7877,0.6222,0.7881,0.6194,0.7988,0.6195,0.7971,0.7865,0.9114,0.7863,0.9115,0.7637,0.9249,0.7636,0.925,0.7334,0.9402,0.7335,0.9404,0.6371,0.7703,0.644,0.7573,0.7649,0.8868,0.7693,0.8934,0.6953,0.8339,0.6938,0.8305,0.6733,0.8532,0.6759,0.8555,0.7581,0.9175,0.7807,0.9048,0.7857,0.9103,0.7848,0.9088,0.7618,0.9234,0.763,0.9243,0.7864,0.9113,0.7883,0.9137,0.7102,0.9496,0.7086,0.9513,0.7235,0.9414,0.7243,0.9422,0.7239,0.9395,0.7247,0.9398,0.7066,0.9057,0.7085,0.909,0.7333,0.8906,0.7568,0.8789,0.74,0.8989,0.7117,0.9276,0.6844,0.8731,0.637,0.803,0.635,0.8007,0.6263,0.8017,0.6256,0.8016,0.6269,0.7872,0.6214,0.7929,0.6252,0.7863,0.6481,0.8174,0.639,0.8052,0.717,0.8267,0.719,0.8297,0.6709,0.7654,0.6694,0.7555,0.6642,0.747,0.6572,0.7489,0.6832,0.7949,0.6914,0.8,0.6619,0.7756,0.6657,0.7797,0.6511,0.787,0.6544,0.791,0.6646,0.7987,0.6579,0.7938,0.7888,0.9173,0.7886,0.9176,0.765,0.9325,0.7651,0.932,0.7357,0.9483,0.7359,0.9489,0.7088,0.9559,0.7104,0.9559,0.6441,0.7779,0.6655,0.759,0.6537,0.7659,0.6717,0.7853,0.697,0.8048,0.679,0.8606,0.7007,0.8385,0.7218,0.8337,0.7145,0.8223,0.6905,0.826,0.675,0.809,0.6708,0.849,0.6237,0.7974,0.6984,0.8943,0.6944,0.8885,0.684,0.869,0.717,0.8473,0.7266,0.8713};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_45()
		{
			double[] value = {0.718,0.8515,0.7498,0.8495,0.7484,0.8519,0.7106,0.9136,0.709,0.9084,0.7516,0.8675,0.7503,0.8672,0.7278,0.8735,0.7158,0.9239,0.7207,0.9341,0.7072,0.9503,0.7288,0.9426,0.7339,0.9402,0.7735,0.8983,0.7541,0.914,0.7335,0.9406,0.7882,0.9161,0.7646,0.9297,0.7357,0.9458,0.7075,0.9552,0.7327,0.9395,0.763,0.9242,0.7858,0.9107,0.764,0.9254,0.7655,0.9275,0.7856,0.912,0.7625,0.925,0.6478,0.7303,0.6465,0.7399,0.6477,0.7111,0.6477,0.7184,0.6504,0.7238,0.6651,0.7438,0.6576,0.7523,0.6576,0.7554,0.6667,0.7449,0.6627,0.7511,0.6559,0.7605,0.6719,0.7334,0.6685,0.7423,0.6642,0.7506,0.6414,0.7638,0.6402,0.7736,0.6598,0.7593,0.6745,0.7299,0.6698,0.7394,0.6435,0.7505,0.6349,0.7045,0.6393,0.6842,0.6393,0.6804,0.6339,0.7032,0.651,0.7626,0.6531,0.764,0.6527,0.7605,0.6382,0.7045,0.65,0.7224,0.6705,0.7346,0.6644,0.7442,0.6558,0.7539,0.6519,0.751,0.6138,0.7931,0.6129,0.7993,0.6144,0.7956,0.6195,0.7608,0.6168,0.7605,0.6163,0.7766,0.6191,0.7756,0.6158,0.7876,0.6175,0.7884,0.6177,0.7931,0.6392,0.6924,0.6246,0.7412,0.6257,0.7522,0.6361,0.702,0.6179,0.751,0.6154,0.7979,0.615,0.8031,0.6129,0.7916,0.6202,0.7507,0.6226,0.7438,0.6232,0.7529,0.6216,0.7576,0.6248,0.7382,0.6234,0.7488,0.6236,0.7457,0.6254,0.7368,0.6261,0.7363,0.623,0.7458,0.6547,0.7538,0.6137,0.7773,0.6149,0.7671,0.617,0.774,0.6167,0.7827,0.6249,0.7283,0.6274,0.7211,0.621,0.7356,0.6521,0.7574,0.6533,0.7678,0.6265,0.7334,0.6205,0.7389};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_46()
		{
			double[] value = {0.6156,0.7902,0.613,0.782,0.6622,0.7454,0.6461,0.7052,0.6315,0.7137,0.6188,0.7667,0.6168,0.7594,0.6185,0.7534,0.6202,0.7622,0.6358,0.7063,0.6183,0.798,0.6188,0.7905,0.6193,0.783,0.6198,0.7745,0.6217,0.7674,0.6231,0.7628,0.6246,0.7583,0.6261,0.7534,0.6263,0.7501,0.6263,0.7483,0.6258,0.748,0.6145,0.7856,0.6163,0.7746,0.6147,0.7718,0.6177,0.7582,0.6198,0.7506,0.6222,0.7439,0.6228,0.7426,0.627,0.7325,0.6297,0.725,0.6297,0.7234,0.63,0.7222,0.6174,0.7763,0.6189,0.7633,0.6186,0.7625,0.6217,0.7475,0.6245,0.7402,0.6282,0.7325,0.629,0.7314,0.6342,0.7199,0.6363,0.708,0.6258,0.7766,0.6259,0.7837,0.6529,0.7568,0.6256,0.7634,0.6175,0.7627,0.6187,0.749,0.6206,0.7483,0.6241,0.7338,0.6282,0.7266,0.6314,0.719,0.6338,0.7167,0.6382,0.7048,0.6527,0.7538,0.6386,0.7038,0.6355,0.7171,0.6223,0.7589,0.6246,0.7592,0.621,0.7522,0.6241,0.7438,0.6311,0.7318,0.6315,0.7239,0.6271,0.7373,0.6257,0.7456,0.6277,0.7462,0.6213,0.7485,0.6204,0.7632,0.617,0.7738,0.615,0.7798,0.6173,0.7859,0.6196,0.7859,0.6227,0.7373,0.6272,0.7319,0.6471,0.7509,0.6447,0.7606,0.6547,0.7573,0.6543,0.757,0.6443,0.7604,0.6382,0.7605,0.6387,0.7606,0.6382,0.7637,0.6376,0.7641,0.6678,0.7502,0.6536,0.7545,0.6532,0.7543,0.645,0.7692,0.6459,0.7711,0.645,0.7724,0.6441,0.7704,0.643,0.7688,0.6438,0.7708,0.64,0.7667,0.6409,0.7684,0.6389,0.764,0.6399,0.7656,0.6393,0.761,0.6403,0.7626,0.6437,0.7586,0.6446,0.7601,0.654,0.7552};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_47()
		{
			double[] value = {0.6547,0.7569,0.6681,0.7509,0.6684,0.7526,0.667,0.7502,0.6531,0.7547,0.6539,0.7564,0.6429,0.7582,0.6438,0.7598,0.6382,0.761,0.6392,0.7626,0.6376,0.7647,0.6386,0.7663,0.6388,0.7678,0.6398,0.7696,0.6419,0.7701,0.6428,0.7721,0.646,0.7721,0.6455,0.7727,0.6438,0.7718,0.6409,0.7693,0.6399,0.7663,0.6403,0.763,0.6682,0.7529,0.6397,0.763,0.6392,0.7666,0.6404,0.7698,0.6433,0.7724,0.6429,0.7578,0.6432,0.758,0.6388,0.767,0.6394,0.7664,0.6425,0.7686,0.6419,0.7692,0.6446,0.7689,0.6441,0.7695,0.6414,0.7639,0.6356,0.7605,0.639,0.7632,0.6434,0.7673,0.6392,0.7643,0.6443,0.7683,0.6379,0.7655,0.6433,0.7695,0.6367,0.7646,0.6419,0.7684,0.6347,0.762,0.6406,0.7657,0.6339,0.7475,0.6304,0.7426,0.6311,0.7419,0.6345,0.7468,0.6338,0.7577,0.637,0.7608,0.6371,0.7618,0.6358,0.7624,0.6343,0.7614,0.6328,0.7587,0.6296,0.7382,0.6305,0.7379,0.635,0.7537,0.6373,0.7576,0.6377,0.7585,0.6368,0.7583,0.6353,0.7569,0.6343,0.7541,0.6314,0.7327,0.632,0.7329,0.6399,0.7506,0.6417,0.7548,0.6422,0.7557,0.6415,0.7553,0.6403,0.7536,0.6395,0.7507,0.6359,0.7289,0.6364,0.7292,0.6503,0.7467,0.6522,0.7511,0.6528,0.752,0.652,0.7515,0.6506,0.7497,0.6497,0.7467,0.6426,0.7244,0.6431,0.7248,0.667,0.746,0.6675,0.7469,0.6664,0.7462,0.6649,0.7443,0.6637,0.7412,0.6543,0.7187,0.6451,0.7669,0.644,0.7684,0.6428,0.7649,0.6437,0.7637,0.6387,0.7441,0.6336,0.7474,0.6319,0.7517,0.6328,0.7548,0.6383,0.7581,0.641,0.7592,0.6418,0.758};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_48()
		{
			double[] value = {0.634,0.7608,0.6319,0.7564,0.6376,0.7598,0.6399,0.7642,0.6322,0.7575,0.6309,0.7528,0.6338,0.7527,0.6328,0.7479,0.6391,0.7492,0.6382,0.7442,0.6492,0.7452,0.648,0.7399,0.6605,0.7342,0.6378,0.737,0.633,0.7406,0.6311,0.7453,0.6317,0.7488,0.6359,0.7527,0.6388,0.7537,0.6396,0.7526,0.6306,0.7498,0.6348,0.7539,0.6299,0.7457,0.632,0.7402,0.6371,0.7363,0.6449,0.7318,0.6561,0.7259,0.6349,0.7475,0.6315,0.7428,0.6375,0.7482,0.6385,0.747,0.6303,0.7438,0.6338,0.7487,0.6295,0.7393,0.6313,0.7337,0.636,0.7298,0.6427,0.7253,0.654,0.7192,0.6547,0.7199,0.6435,0.726,0.6368,0.7304,0.6324,0.734,0.6308,0.7389,0.6376,0.7471,0.6382,0.7463,0.646,0.7681,0.6451,0.7694,0.6343,0.7535,0.6328,0.7581,0.6347,0.7613,0.6406,0.7649,0.6394,0.7501,0.6496,0.7461,0.6635,0.7406,0.6359,0.7476,0.6376,0.7477,0.6382,0.747,0.6364,0.7473,0.6341,0.7477,0.6347,0.7468,0.6318,0.7418,0.633,0.7431,0.6311,0.7374,0.632,0.7389,0.6324,0.7318,0.633,0.7335,0.636,0.7271,0.6366,0.729,0.6427,0.7223,0.6432,0.7241,0.6543,0.718,0.6533,0.7157,0.6539,0.7175,0.6421,0.7218,0.6427,0.7237,0.6354,0.7266,0.6361,0.7285,0.6316,0.7316,0.6323,0.7333,0.6302,0.7377,0.6311,0.7391,0.631,0.7431,0.6323,0.7436,0.6343,0.7446,0.6312,0.7394,0.6319,0.7388,0.6349,0.7438,0.6303,0.7346,0.6311,0.7343,0.6312,0.7282,0.6319,0.7283,0.6349,0.7232,0.6354,0.7236,0.6418,0.7183,0.6423,0.7187,0.6531,0.7129,0.6382,0.744,0.6376,0.7448,0.6534,0.7142,0.6424,0.7203};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_49()
		{
			double[] value = {0.6356,0.725,0.6321,0.7298,0.6311,0.7357,0.6319,0.7401,0.6348,0.7452,0.6381,0.7453,0.6375,0.7461,0.6338,0.7462,0.6307,0.7409,0.6303,0.736,0.6314,0.7296,0.6351,0.7246,0.6419,0.7199,0.653,0.7138,0.6432,0.7706,0.6449,0.7702,0.644,0.77,0.6426,0.7706,0.641,0.7719,0.6421,0.7721,0.643,0.7753,0.6428,0.7771,0.645,0.7785,0.6453,0.7803,0.65,0.7815,0.6508,0.7832,0.6566,0.7822,0.6578,0.7842,0.6659,0.7811,0.6671,0.7828,0.6802,0.7775,0.679,0.776,0.6658,0.7814,0.667,0.783,0.6565,0.7826,0.6576,0.7845,0.6495,0.7819,0.6503,0.7836,0.644,0.7786,0.6443,0.7803,0.6419,0.7751,0.6412,0.7766,0.6444,0.7752,0.6453,0.7803,0.6442,0.7802,0.6433,0.775,0.6479,0.7838,0.6469,0.7839,0.6534,0.7874,0.6529,0.7877,0.6604,0.7885,0.6603,0.7888,0.67,0.7872,0.6699,0.7875,0.6825,0.7824,0.6461,0.773,0.6471,0.7732,0.6817,0.7801,0.6688,0.7852,0.6594,0.7868,0.6524,0.7857,0.6468,0.7822,0.6442,0.7788,0.6433,0.7738,0.646,0.7718,0.645,0.7717,0.6418,0.7736,0.6426,0.7788,0.6458,0.7823,0.6519,0.7859,0.6592,0.7871,0.6687,0.7855,0.6816,0.7805,0.6428,0.7696,0.6445,0.7692,0.6437,0.7694,0.6422,0.7698,0.6407,0.7713,0.6416,0.7712,0.6416,0.7729,0.6412,0.7745,0.6427,0.7746,0.6428,0.7762,0.6467,0.7763,0.6473,0.7778,0.6525,0.7758,0.6536,0.7778,0.6607,0.7746,0.6617,0.7763,0.6745,0.7713,0.6733,0.7699,0.6603,0.7744,0.6613,0.7761,0.6521,0.7756,0.6531,0.7776,0.646,0.7761,0.6466,0.7776,0.6416,0.7743,0.6416,0.7759,0.6406,0.7726};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_50()
		{
			double[] value = {0.6398,0.7741,0.6435,0.774,0.6439,0.7786,0.6427,0.7783,0.6427,0.7743,0.6456,0.7808,0.6445,0.7805,0.6503,0.7832,0.6495,0.783,0.6567,0.7835,0.6563,0.7833,0.6653,0.7814,0.6649,0.7813,0.6766,0.7757,0.6451,0.7715,0.646,0.7714,0.6761,0.7738,0.6638,0.7792,0.6555,0.7813,0.6491,0.781,0.6444,0.7787,0.6427,0.7767,0.6425,0.7726,0.6451,0.7701,0.6443,0.7703,0.6414,0.7732,0.6411,0.7765,0.6432,0.7784,0.6484,0.7808,0.6551,0.7811,0.6634,0.7791,0.6756,0.7738,0.6491,0.7717,0.6579,0.7705,0.6582,0.7704,0.6494,0.7717,0.6416,0.774,0.6424,0.774,0.6447,0.7748,0.6442,0.7749,0.6585,0.7732,0.6588,0.7731,0.6701,0.7687,0.644,0.7702,0.6433,0.7681,0.6449,0.7686,0.6456,0.7707,0.6432,0.7694,0.644,0.7714,0.642,0.7711,0.6425,0.7728,0.6426,0.772,0.6428,0.7736,0.6446,0.7728,0.6449,0.7743,0.6497,0.7721,0.6501,0.7737,0.6584,0.7708,0.6588,0.7725,0.6695,0.7674,0.6699,0.7685,0.6579,0.7711,0.6583,0.7727,0.6491,0.7722,0.6496,0.7738,0.6435,0.7729,0.6438,0.7744,0.6408,0.7719,0.6411,0.7735,0.6402,0.7706,0.6406,0.7724,0.6414,0.7688,0.6422,0.7709,0.6435,0.7676,0.6443,0.7678,0.6425,0.7686,0.6414,0.7704,0.642,0.7715,0.6442,0.7724,0.6696,0.7669,0.6437,0.7724,0.6412,0.7715,0.6405,0.7702,0.6417,0.7682,0.6501,0.7742,0.6499,0.7742,0.6429,0.7717,0.6438,0.7719,0.6421,0.7732,0.6412,0.773,0.6447,0.771,0.6455,0.7712,0.6327,0.7623,0.6338,0.7657,0.6173,0.7742,0.6182,0.7653,0.6132,0.7568,0.6307,0.7417,0.6338,0.7499,0.6717,0.7924};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_51()
		{
			double[] value = {0.6612,0.8058,0.6611,0.8124,0.6327,0.7989,0.631,0.81,0.6258,0.7977,0.6339,0.78,0.6329,0.788,0.6249,0.785,0.6221,0.7802,0.6594,0.8236,0.6597,0.8281,0.6707,0.8176,0.6695,0.813,0.6607,0.8183,0.607,0.7407,0.6263,0.7299,0.6286,0.734,0.6286,0.7371,0.6118,0.7506,0.6285,0.8151,0.6287,0.8119,0.629,0.8098,0.6294,0.8044,0.6302,0.796,0.6199,0.8593,0.6223,0.8455,0.625,0.8345,0.6263,0.83,0.6269,0.8268,0.6273,0.8254,0.6278,0.8205,0.624,0.7776,0.6259,0.769,0.6248,0.7624,0.6223,0.7729,0.628,0.7836,0.6299,0.7746,0.6288,0.7685,0.6264,0.7797,0.6322,0.7888,0.6336,0.7805,0.6267,0.7589,0.6255,0.752,0.6302,0.7649,0.629,0.7584,0.6726,0.8172,0.6736,0.8111,0.6725,0.777,0.678,0.7517,0.6718,0.8117,0.6348,0.7715,0.6213,0.7922,0.6209,0.7906,0.6327,0.7747,0.6173,0.7883,0.6178,0.7915,0.6274,0.7452,0.6262,0.7387,0.6306,0.7517,0.6295,0.7452,0.6348,0.7599,0.6189,0.784,0.619,0.7734,0.6737,0.7838,0.6352,0.7687,0.6191,0.7752,0.6348,0.7736,0.6203,0.7772,0.6729,0.7562,0.6699,0.7467,0.6735,0.7649,0.6643,0.778,0.6641,0.7856,0.6614,0.808,0.6415,0.8205,0.6425,0.8149,0.6407,0.8253,0.64,0.8344,0.6407,0.83,0.6464,0.7982,0.6446,0.8101,0.6475,0.778,0.6464,0.7863,0.6485,0.7714,0.6474,0.7626,0.6485,0.7662,0.6472,0.7577,0.6502,0.7669,0.6459,0.7851,0.6417,0.8811,0.6486,0.8798,0.619,0.7941,0.618,0.7928,0.6234,0.785,0.6252,0.7877,0.6223,0.7866,0.6425,0.8113,0.6616,0.801,0.6715,0.7881,0.6671,0.7694};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_52()
		{
			double[] value = {0.6485,0.7696,0.6344,0.7718,0.6192,0.7768,0.6275,0.7366,0.6102,0.7498,0.6268,0.7454,0.6262,0.7589,0.6257,0.7689,0.6234,0.7789,0.6247,0.792,0.6323,0.794,0.6464,0.7929,0.6632,0.7908,0.6728,0.8065,0.6695,0.8083,0.66,0.8197,0.6407,0.8268,0.6278,0.7676,0.6311,0.7689,0.6291,0.7684,0.633,0.7305,0.6363,0.733,0.6258,0.7259,0.6242,0.7284,0.6305,0.8308,0.6122,0.8334,0.634,0.7325,0.6256,0.7265,0.6175,0.7255,0.6094,0.8193,0.6088,0.8123,0.5999,0.7666,0.63,0.7803,0.6343,0.7706,0.6318,0.7728,0.6277,0.7813,0.6271,0.7907,0.663,0.7916,0.6622,0.7835,0.657,0.8408,0.6555,0.854,0.6655,0.8493,0.6683,0.8343,0.6228,0.86,0.6527,0.8729,0.6597,0.8634,0.6433,0.8631,0.6208,0.7281,0.6302,0.7297,0.6023,0.7814,0.6054,0.7994,0.6217,0.7824,0.5993,0.7607,0.6296,0.7642,0.6272,0.7741,0.6308,0.732,0.6261,0.7281,0.621,0.7274,0.6054,0.7369,0.6044,0.7347,0.6191,0.7264,0.6271,0.7279,0.6331,0.7339,0.632,0.7635,0.6297,0.7732,0.5925,0.8005,0.5945,0.782,0.5988,0.7745,0.6309,0.7591,0.6362,0.762,0.633,0.7597,0.634,0.7643,0.6023,0.7919,0.6031,0.7961,0.6308,0.7504,0.6363,0.7534,0.633,0.7509,0.6344,0.755,0.6303,0.754,0.6324,0.7538,0.6032,0.7943,0.6721,0.833,0.6705,0.849,0.6242,0.8604,0.6536,0.8734,0.6597,0.8636,0.6712,0.8282,0.6696,0.8443,0.6392,0.868,0.6453,0.8586,0.6257,0.7821,0.6239,0.7826,0.6308,0.741,0.6308,0.739,0.6363,0.7419,0.633,0.7395,0.6345,0.7429,0.6327,0.7413,0.6615,0.7995,0.6053,0.7921};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_53()
		{
			double[] value = {0.6637,0.823,0.6614,0.8399,0.6446,0.7935,0.6435,0.803,0.6425,0.8091,0.6391,0.8458,0.637,0.859,0.6411,0.8583,0.6427,0.8574,0.6474,0.8504,0.6424,0.846,0.6441,0.8305,0.6247,0.8633,0.6227,0.8691,0.629,0.8604,0.6249,0.781,0.629,0.7725,0.6312,0.7637,0.6317,0.7543,0.632,0.7419,0.6321,0.7337,0.6255,0.7285,0.6183,0.7272,0.6042,0.8009,0.6222,0.7298,0.6302,0.7311,0.6297,0.7389,0.6297,0.7504,0.6297,0.7589,0.6075,0.8093,0.6304,0.782,0.6306,0.795,0.6279,0.7883,0.6602,0.8348,0.7191,0.9335,0.7499,0.9111,0.7201,0.9324,0.7776,0.9038,0.757,0.9171,0.7562,0.9197,0.6282,0.7839,0.6286,0.7842,0.629,0.7849,0.6287,0.7845,0.6556,0.7467,0.6551,0.7469,0.6307,0.7816,0.6348,0.7939,0.6306,0.7807,0.6277,0.7876,0.6707,0.7185,0.6658,0.72,0.6608,0.7667,0.6425,0.7585,0.6423,0.7574,0.637,0.7709,0.6365,0.7703,0.6267,0.7815,0.6292,0.7935,0.6264,0.7814,0.6227,0.7877,0.6222,0.7881,0.6194,0.7988,0.6195,0.7971,0.7863,0.9115,0.7865,0.9114,0.7636,0.925,0.7637,0.9249,0.7335,0.9404,0.7334,0.9402,0.644,0.7573,0.6371,0.7703,0.7693,0.8934,0.7649,0.8868,0.676,0.8555,0.6733,0.8532,0.6938,0.8305,0.6953,0.8339,0.7807,0.9048,0.7581,0.9175,0.763,0.9243,0.7618,0.9234,0.7848,0.9088,0.7857,0.9103,0.7883,0.9137,0.7864,0.9113,0.7102,0.9496,0.7086,0.9513,0.7243,0.9422,0.7235,0.9414,0.7247,0.9398,0.7239,0.9395,0.7333,0.8906,0.7085,0.909,0.7066,0.9057,0.74,0.8989,0.7568,0.8789,0.7117,0.9276,0.6844,0.8731,0.635,0.8007};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_54()
		{
			double[] value = {0.637,0.803,0.6256,0.8016,0.6263,0.8017,0.6269,0.7872,0.6214,0.7929,0.6252,0.7863,0.639,0.8052,0.6481,0.8174,0.719,0.8297,0.717,0.8267,0.6709,0.7228,0.6672,0.7215,0.6572,0.7489,0.6914,0.8,0.6832,0.7949,0.6657,0.7797,0.6619,0.7756,0.6545,0.791,0.6511,0.787,0.6646,0.7987,0.6579,0.7938,0.7888,0.9173,0.7651,0.932,0.7357,0.9483,0.7088,0.9559,0.6441,0.7779,0.6537,0.7659,0.6655,0.759,0.6717,0.7853,0.697,0.8048,0.679,0.8606,0.7007,0.8385,0.7218,0.8337,0.7145,0.8223,0.6905,0.826,0.675,0.809,0.6708,0.849,0.6237,0.7974,0.6984,0.8943,0.6944,0.8885,0.684,0.869,0.717,0.8473,0.718,0.8515,0.7266,0.8713,0.7498,0.8495,0.7484,0.8519,0.709,0.9084,0.7106,0.9136,0.7516,0.8675,0.7503,0.8672,0.7278,0.8735,0.7158,0.9239,0.7207,0.9341,0.7072,0.9503,0.7339,0.9402,0.7288,0.9426,0.7541,0.914,0.7736,0.8983,0.7335,0.9406,0.7882,0.9161,0.7646,0.9297,0.7075,0.9552,0.7357,0.9458,0.7327,0.9395,0.763,0.9242,0.7858,0.9107,0.764,0.9254,0.7655,0.9275,0.7856,0.912,0.7625,0.925,0.6443,0.7604,0.6543,0.757,0.6547,0.7573,0.6447,0.7606,0.6376,0.7641,0.6382,0.7637,0.6387,0.7606,0.6382,0.7605,0.6532,0.7543,0.6536,0.7545,0.6672,0.7499,0.6441,0.7704,0.645,0.7724,0.6459,0.7711,0.645,0.7692,0.6438,0.7708,0.643,0.7688,0.6409,0.7684,0.64,0.7667,0.6399,0.7656,0.6389,0.764,0.6403,0.7626,0.6393,0.761,0.6446,0.7601,0.6437,0.7586,0.6547,0.7569,0.654,0.7552,0.6673,0.7519,0.667,0.7502,0.6539,0.7564};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_55()
		{
			double[] value = {0.6532,0.7547,0.6438,0.7598,0.6429,0.7582,0.6392,0.7626,0.6382,0.761,0.6386,0.7663,0.6376,0.7647,0.6398,0.7696,0.6388,0.7678,0.6428,0.7721,0.6419,0.7701,0.6455,0.7727,0.646,0.7721,0.6438,0.7718,0.6409,0.7693,0.6399,0.7663,0.6403,0.763,0.6677,0.7526,0.6397,0.763,0.6392,0.7666,0.6404,0.7698,0.6433,0.7724,0.6432,0.758,0.6429,0.7578,0.6419,0.7692,0.6425,0.7686,0.6394,0.7664,0.6388,0.767,0.6441,0.7695,0.6446,0.7689,0.6434,0.7673,0.6391,0.7632,0.6356,0.7605,0.6414,0.7639,0.6443,0.7683,0.6392,0.7643,0.6433,0.7695,0.6379,0.7655,0.6419,0.7684,0.6367,0.7646,0.6406,0.7657,0.6347,0.762,0.6345,0.7468,0.6311,0.7419,0.6304,0.7426,0.6339,0.7475,0.637,0.7608,0.6338,0.7577,0.6371,0.7618,0.6358,0.7624,0.6343,0.7614,0.6328,0.7587,0.6305,0.7379,0.6296,0.7382,0.6373,0.7576,0.635,0.7537,0.6377,0.7585,0.6368,0.7583,0.6353,0.7569,0.6343,0.7541,0.632,0.7329,0.6314,0.7327,0.6417,0.7548,0.6399,0.7506,0.6422,0.7557,0.6415,0.7553,0.6403,0.7536,0.6395,0.7507,0.6364,0.7292,0.6359,0.7289,0.6523,0.7511,0.6503,0.7467,0.6528,0.752,0.652,0.7515,0.6507,0.7497,0.6497,0.7467,0.6431,0.7248,0.6426,0.7244,0.6645,0.7413,0.6539,0.7184,0.6437,0.7637,0.6428,0.7649,0.644,0.7684,0.6451,0.7669,0.6692,0.7288,0.6611,0.7341,0.6485,0.7398,0.6387,0.7441,0.6336,0.7474,0.6319,0.7517,0.6328,0.7548,0.6383,0.7581,0.6418,0.758,0.641,0.7592,0.6399,0.7642,0.6376,0.7598,0.6319,0.7564,0.634,0.7608,0.6309,0.7528,0.6322,0.7575};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_56()
		{
			double[] value = {0.6328,0.7479,0.6338,0.7527,0.6382,0.7442,0.6391,0.7492,0.648,0.7399,0.6492,0.7452,0.663,0.7396,0.6658,0.721,0.6571,0.7266,0.6457,0.7325,0.6379,0.737,0.633,0.7406,0.6311,0.7453,0.6317,0.7488,0.6359,0.7527,0.6396,0.7526,0.6388,0.7537,0.6348,0.7539,0.6306,0.7498,0.6299,0.7457,0.632,0.7402,0.6371,0.7363,0.6449,0.7318,0.6315,0.7428,0.6349,0.7475,0.6385,0.747,0.6375,0.7482,0.6338,0.7487,0.6303,0.7438,0.6295,0.7393,0.6314,0.7337,0.636,0.7298,0.6427,0.7253,0.654,0.7192,0.6644,0.7141,0.6547,0.7199,0.6435,0.726,0.6368,0.7304,0.6324,0.734,0.6308,0.7389,0.6382,0.7463,0.6376,0.7471,0.6451,0.7694,0.646,0.7681,0.6328,0.7581,0.6343,0.7535,0.6347,0.7613,0.6406,0.7649,0.6394,0.7501,0.6496,0.7461,0.6635,0.7406,0.6364,0.7473,0.6382,0.747,0.6376,0.7477,0.636,0.7476,0.6341,0.7477,0.6347,0.7468,0.633,0.7431,0.6318,0.7418,0.632,0.7389,0.6311,0.7374,0.633,0.7335,0.6324,0.7318,0.6366,0.729,0.636,0.7271,0.6432,0.7241,0.6427,0.7223,0.6538,0.7162,0.6539,0.7175,0.6427,0.7237,0.6421,0.7218,0.6361,0.7285,0.6354,0.7266,0.6323,0.7333,0.6316,0.7316,0.6311,0.7391,0.6302,0.7377,0.6323,0.7436,0.631,0.7431,0.6349,0.7438,0.6319,0.7388,0.6312,0.7394,0.6343,0.7446,0.6311,0.7343,0.6303,0.7346,0.6319,0.7283,0.6312,0.7282,0.6354,0.7236,0.6349,0.7232,0.6423,0.7187,0.6418,0.7183,0.6527,0.7124,0.6376,0.7448,0.6382,0.744,0.6534,0.7142,0.6424,0.7203,0.6356,0.725,0.6321,0.7298,0.6311,0.7357,0.6319,0.7401};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_57()
		{
			double[] value = {0.6348,0.7452,0.6381,0.7453,0.6375,0.7461,0.6338,0.7462,0.6307,0.7409,0.6303,0.736,0.6314,0.7296,0.6351,0.7246,0.6419,0.7199,0.653,0.7138,0.6426,0.7706,0.644,0.77,0.6449,0.7702,0.6432,0.7706,0.641,0.7719,0.6421,0.7721,0.6428,0.7771,0.643,0.7753,0.6453,0.7803,0.645,0.7785,0.6508,0.7832,0.65,0.7815,0.6578,0.7842,0.6566,0.7822,0.6659,0.7811,0.6802,0.7775,0.6793,0.7757,0.6799,0.7778,0.679,0.776,0.667,0.783,0.6658,0.7814,0.6576,0.7845,0.6565,0.7826,0.6503,0.7836,0.6495,0.7819,0.6443,0.7803,0.644,0.7786,0.6412,0.7766,0.6419,0.7751,0.6433,0.775,0.6442,0.7802,0.6453,0.7803,0.6444,0.7752,0.6469,0.7839,0.6479,0.7838,0.6529,0.7877,0.6534,0.7874,0.6604,0.7885,0.6471,0.7732,0.6461,0.773,0.6594,0.7868,0.6524,0.7857,0.6468,0.7822,0.6442,0.7788,0.6433,0.7738,0.646,0.7718,0.645,0.7717,0.6418,0.7736,0.6426,0.7788,0.6458,0.7823,0.6519,0.7859,0.6592,0.7871,0.6422,0.7698,0.6437,0.7694,0.6445,0.7692,0.6428,0.7696,0.6407,0.7713,0.6416,0.7712,0.6412,0.7745,0.6416,0.7729,0.6428,0.7762,0.6427,0.7746,0.6473,0.7778,0.6467,0.7763,0.6536,0.7778,0.6525,0.7758,0.6617,0.7763,0.6607,0.7746,0.6739,0.7699,0.674,0.7713,0.6733,0.7699,0.6613,0.7761,0.6603,0.7744,0.6531,0.7776,0.6521,0.7756,0.6466,0.7776,0.646,0.7761,0.6416,0.7759,0.6416,0.7743,0.6398,0.7741,0.6406,0.7726,0.6427,0.7743,0.6427,0.7783,0.6439,0.7786,0.6435,0.774,0.6445,0.7805,0.6457,0.7808,0.6496,0.783,0.6503,0.7832,0.6563,0.7833};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_58()
		{
			double[] value = {0.6567,0.7835,0.6649,0.7813,0.6653,0.7814,0.677,0.7757,0.6866,0.7707,0.6869,0.7707,0.646,0.7714,0.6451,0.7715,0.6865,0.7686,0.6761,0.7738,0.6638,0.7792,0.6555,0.7813,0.6491,0.781,0.6444,0.7787,0.6427,0.7767,0.6425,0.7726,0.6451,0.7701,0.6443,0.7703,0.6414,0.7732,0.6411,0.7765,0.6432,0.7784,0.6484,0.7808,0.6551,0.7811,0.6634,0.7791,0.6756,0.7738,0.6494,0.7717,0.6582,0.7704,0.6579,0.7705,0.6491,0.7717,0.6442,0.7749,0.6447,0.7748,0.6424,0.774,0.6416,0.774,0.6704,0.7685,0.6588,0.7731,0.6586,0.7732,0.6456,0.7707,0.6449,0.7686,0.6433,0.7681,0.644,0.7702,0.644,0.7714,0.6432,0.7694,0.6425,0.7728,0.642,0.7711,0.6428,0.7736,0.6426,0.772,0.6449,0.7743,0.6446,0.7728,0.6501,0.7737,0.6497,0.7721,0.6588,0.7725,0.6584,0.7708,0.6705,0.7681,0.6701,0.767,0.6699,0.7685,0.6583,0.7727,0.6579,0.7711,0.6496,0.7738,0.6491,0.7722,0.6438,0.7744,0.6435,0.7729,0.6411,0.7735,0.6408,0.7719,0.6406,0.7724,0.6402,0.7706,0.6422,0.7709,0.6414,0.7688,0.6443,0.7678,0.6435,0.7676,0.6425,0.7686,0.6414,0.7704,0.642,0.7715,0.6443,0.7724,0.6699,0.7667,0.6437,0.7724,0.6412,0.7715,0.6405,0.7702,0.6417,0.7682,0.6499,0.7742,0.6501,0.7742,0.6412,0.773,0.6421,0.7732,0.6438,0.7719,0.6429,0.7717,0.6455,0.7712,0.6447,0.771,0.6465,0.7399,0.6478,0.7303,0.6477,0.7184,0.6504,0.7238,0.6559,0.7605,0.6598,0.7593,0.6402,0.7736,0.6414,0.7638,0.6435,0.7505,0.6393,0.6842,0.6349,0.7045,0.6527,0.7605,0.6431,0.6839,0.6382,0.7045};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_59()
		{
			double[] value = {0.65,0.7224,0.6144,0.7956,0.6129,0.7993,0.6138,0.7931,0.6191,0.7756,0.6163,0.7766,0.6168,0.7605,0.6195,0.7608,0.6175,0.7884,0.6158,0.7876,0.6177,0.7931,0.643,0.6958,0.6257,0.7522,0.6247,0.7412,0.6361,0.702,0.6179,0.751,0.6129,0.7916,0.615,0.8031,0.6154,0.7979,0.6216,0.7576,0.6232,0.7529,0.6226,0.7438,0.6202,0.7507,0.6234,0.7488,0.6248,0.7382,0.6254,0.7368,0.6236,0.7457,0.6167,0.7827,0.617,0.774,0.6149,0.7671,0.6137,0.7773,0.621,0.7356,0.6274,0.7211,0.6249,0.7283,0.6521,0.7574,0.6533,0.7678,0.6265,0.7334,0.6205,0.7389,0.6131,0.782,0.6156,0.7902,0.6315,0.7137,0.6168,0.7594,0.6188,0.7667,0.6202,0.7622,0.6185,0.7534,0.6188,0.7905,0.6183,0.798,0.6198,0.7745,0.6193,0.783,0.6217,0.7674,0.6231,0.7628,0.6261,0.7534,0.6246,0.7583,0.6263,0.7501,0.6263,0.7483,0.6145,0.7856,0.6163,0.7746,0.6177,0.7582,0.6147,0.7718,0.6198,0.7506,0.6222,0.7439,0.627,0.7325,0.6228,0.7426,0.6297,0.725,0.6297,0.7234,0.6174,0.7763,0.6189,0.7633,0.6217,0.7475,0.6186,0.7625,0.6245,0.7402,0.6282,0.7325,0.6342,0.7199,0.629,0.7314,0.6363,0.708,0.6259,0.7837,0.6258,0.7766,0.6537,0.7555,0.6529,0.7568,0.6256,0.7634,0.6175,0.7627,0.6187,0.749,0.6241,0.7338,0.6206,0.7483,0.6282,0.7266,0.6314,0.719,0.6338,0.7167,0.6386,0.6897,0.6453,0.699,0.6386,0.7038,0.6355,0.7171,0.6246,0.7592,0.6223,0.7589,0.621,0.7522,0.6241,0.7438,0.6311,0.7318,0.6315,0.7239,0.6271,0.7373,0.6257,0.7456,0.6277,0.7462,0.6204,0.7632};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_60()
		{
			double[] value = {0.6213,0.7485,0.617,0.7738,0.615,0.7798,0.6173,0.7859,0.6197,0.7859,0.6227,0.7373,0.6272,0.7319,0.0909,0.8993,0.0882,0.8683,0.1098,0.8626,0.1098,0.8941,0.0765,0.9532,0.0878,0.9331,0.1098,0.9289,0.1098,0.9551,0.0692,0.8999,0.07,0.8685,0.0625,0.9523,0.0675,0.9321,0.0656,0.8662,0.0653,0.8986,0.0669,0.8912,0.0683,0.8644,0.0627,0.93,0.0537,0.9498,0.0501,0.9353,0.0634,0.9217,0.1098,0.8514,0.0945,0.8507,0.0952,0.8459,0.1098,0.8466,0.0766,0.8513,0.0767,0.8474,0.0662,0.8459,0.0667,0.8413,0.069,0.8456,0.0686,0.8514,0.0661,0.8542,0.0935,0.8545,0.0723,0.855,0.1098,0.8518,0.0779,0.8422,0.0939,0.8414,0.1098,0.8421,0.0712,0.8407,0.0694,0.852,0.1098,0.839,0.0947,0.8384,0.0966,0.837,0.1098,0.8368,0.0786,0.8381,0.0793,0.8362,0.0734,0.8379,0.0776,0.8361,0.0718,0.8377,0.0624,0.9143,0.0685,0.8847,0.0684,0.8645,0.0699,0.8516,0.0681,0.8462,0.0695,0.8389,0.0592,0.9183,0.0807,0.836,0.0732,0.8378,0.0644,0.9125,0.0971,0.8369,0.1098,0.8366,0.0716,0.8432,0.0726,0.8489,0.071,0.862,0.071,0.8827,0.0966,0.8747,0.0748,0.867,0.0777,0.8681,0.098,0.8752,0.1098,0.8788,0.1098,0.8804,0.0845,0.8088,0.1098,0.8091,0.1098,0.8126,0.0864,0.8115,0.0606,0.8128,0.0622,0.8158,0.0523,0.8251,0.0538,0.8281,0.0504,0.8403,0.052,0.8432,0.0476,0.8557,0.0493,0.8585,0.0474,0.8736,0.0493,0.8762,0.0412,0.8923,0.0433,0.8948,0.0292,0.9104,0.0323,0.9121,0.0298,0.9229,0.0296,0.9187,0.0328,0.9201,0.0331,0.924,0.025,0.9154};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_61()
		{
			double[] value = {0.028,0.9166,0.0253,0.9011,0.0281,0.9023,0.0338,0.8646,0.0296,0.8757,0.0324,0.8769,0.0366,0.8658,0.0441,0.861,0.047,0.8622,0.0545,0.8575,0.0574,0.8586,0.0759,0.9643,0.0764,0.9564,0.1098,0.9599,0.1098,0.9747,0.1098,0.9784,0.0762,0.9695,0.0752,0.9691,0.1098,0.9774,0.0447,0.895,0.0419,0.9044,0.1098,0.8181,0.0869,0.8171,0.0657,0.821,0.0555,0.8327,0.0539,0.8474,0.0516,0.8606,0.0513,0.8763,0.0385,0.929,0.0404,0.936,0.0413,0.9395,0.0583,0.9562,0.0615,0.9546,0.0533,0.9525,0.0459,0.9407,0.0584,0.9529,0.043,0.9399,0.0308,0.9214,0.0294,0.9208,0.0295,0.9068,0.0334,0.8813,0.0371,0.87,0.0476,0.8664,0.0581,0.8628,0.0782,0.8722,0.0981,0.8793,0.1098,0.8839,0.1098,0.8345,0.0968,0.8344,0.0808,0.8331,0.0774,0.8328,0.0706,0.8354,0.0627,0.9477,0.0463,0.9274,0.0487,0.9081,0.0505,0.897,0.0297,0.8927,0.0662,0.9336,0.0693,0.9125,0.077,0.95,0.0818,0.9246,0.1098,0.9601,0.1098,0.9304,0.0558,0.8766,0.078,0.8716,0.0796,0.8655,0.0928,0.8781,0.0942,0.8707,0.1098,0.8823,0.1098,0.8736,0.1098,0.9014,0.0909,0.8956,0.0754,0.8861,0.0682,0.8428,0.0695,0.837,0.0693,0.8487,0.0677,0.8618,0.0676,0.8824,0.0598,0.9116,0.0395,0.9325,0.0282,0.888,0.0254,0.8868,0.0325,0.9161,0.0294,0.9145,0.1313,0.8683,0.1287,0.8993,0.1318,0.9331,0.143,0.9532,0.1496,0.8685,0.1504,0.8999,0.152,0.9321,0.1571,0.9523,0.1512,0.8644,0.1526,0.8912,0.1543,0.8986,0.1539,0.8662,0.1561,0.9217,0.1694,0.9353,0.1659,0.9498,0.1569,0.93};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_62()
		{
			double[] value = {0.1243,0.8459,0.125,0.8507,0.1428,0.8474,0.1429,0.8513,0.1509,0.8514,0.1505,0.8456,0.1529,0.8413,0.1533,0.8459,0.1534,0.8542,0.1472,0.855,0.1261,0.8545,0.1256,0.8414,0.1416,0.8422,0.1483,0.8407,0.1502,0.852,0.123,0.837,0.1248,0.8384,0.1402,0.8362,0.1409,0.8381,0.1419,0.8361,0.1461,0.8379,0.1477,0.8377,0.151,0.8847,0.1572,0.9143,0.1511,0.8645,0.1497,0.8516,0.1514,0.8462,0.15,0.8389,0.1604,0.9183,0.1389,0.836,0.1463,0.8378,0.1552,0.9125,0.1224,0.8369,0.1479,0.8432,0.1469,0.8489,0.1485,0.862,0.1485,0.8827,0.1215,0.8752,0.1418,0.8681,0.1447,0.867,0.1229,0.8747,0.1331,0.8115,0.135,0.8088,0.1574,0.8158,0.1589,0.8128,0.1658,0.8281,0.1672,0.8251,0.1675,0.8432,0.1691,0.8403,0.1703,0.8585,0.1719,0.8557,0.1702,0.8762,0.1721,0.8736,0.1762,0.8948,0.1783,0.8923,0.1872,0.9121,0.1904,0.9104,0.1865,0.924,0.1867,0.9201,0.1899,0.9187,0.1897,0.9229,0.1915,0.9166,0.1945,0.9154,0.1914,0.9023,0.1943,0.9011,0.183,0.8658,0.1871,0.8769,0.1899,0.8757,0.1858,0.8646,0.1726,0.8622,0.1754,0.861,0.1621,0.8586,0.165,0.8575,0.1431,0.9564,0.1436,0.9643,0.1443,0.9691,0.1433,0.9695,0.1777,0.9044,0.1748,0.895,0.1326,0.8171,0.1538,0.821,0.164,0.8327,0.1657,0.8474,0.1679,0.8606,0.1683,0.8763,0.181,0.929,0.1782,0.9395,0.1791,0.936,0.1581,0.9546,0.1612,0.9562,0.1737,0.9407,0.1662,0.9525,0.1611,0.9529,0.1765,0.9399,0.1901,0.9208,0.1887,0.9214,0.19,0.9068,0.1824,0.87,0.1861,0.8813,0.1719,0.8664};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_63()
		{
			double[] value = {0.1413,0.8722,0.1614,0.8628,0.1214,0.8793,0.1227,0.8344,0.1388,0.8331,0.1489,0.8354,0.1422,0.8328,0.1568,0.9477,0.1733,0.9274,0.1898,0.8927,0.169,0.897,0.1709,0.9081,0.1502,0.9125,0.1533,0.9336,0.1377,0.9246,0.1426,0.95,0.1637,0.8766,0.14,0.8655,0.1415,0.8716,0.1253,0.8707,0.1268,0.8781,0.1287,0.8956,0.1442,0.8861,0.15,0.837,0.1513,0.8428,0.1502,0.8487,0.1518,0.8618,0.152,0.8824,0.1597,0.9116,0.1801,0.9325,0.1941,0.8868,0.1913,0.888,0.187,0.9161,0.1901,0.9145,0.3284,0.932,0.3289,0.9381,0.3234,0.9433,0.2871,0.9529,0.2883,0.946,0.2829,0.9476,0.2766,0.959,0.2732,0.9486,0.3211,0.9375,0.2993,0.955,0.3391,0.9252,0.3502,0.9235,0.3502,0.9337,0.3356,0.9335,0.3502,0.9168,0.3392,0.9194,0.3502,0.9027,0.3502,0.9423,0.3247,0.9462,0.2718,0.9572,0.2766,0.9534,0.269,0.9512,0.3284,0.9305,0.3279,0.9229,0.2855,0.939,0.2765,0.9519,0.2711,0.9465,0.2758,0.9623,0.2743,0.9618,0.3502,0.9501,0.3242,0.9543,0.2987,0.9614,0.3255,0.8997,0.4121,0.946,0.4133,0.9529,0.377,0.9433,0.3716,0.9381,0.3721,0.932,0.4272,0.9486,0.4238,0.959,0.4175,0.9476,0.4011,0.955,0.3793,0.9375,0.3648,0.9335,0.3613,0.9252,0.3612,0.9194,0.3757,0.9462,0.4314,0.9512,0.4238,0.9534,0.4286,0.9572,0.3721,0.9305,0.3725,0.9229,0.4149,0.939,0.4293,0.9465,0.424,0.9519,0.4261,0.9618,0.4246,0.9623,0.3762,0.9543,0.4019,0.9614,0.375,0.8997,0.3333,0.8053,0.3336,0.806,0.3333,0.8045,0.3386,0.7971,0.3403,0.7975,0.3343,0.7928};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_64()
		{
			double[] value = {0.3347,0.7976,0.3293,0.805,0.3263,0.8044,0.3282,0.808,0.3313,0.8085,0.3395,0.8056,0.3393,0.8014,0.3289,0.7983,0.3245,0.8036,0.3259,0.8064,0.3336,0.7976,0.324,0.8028,0.3226,0.8,0.3249,0.7898,0.3292,0.7887,0.3244,0.786,0.3222,0.7962,0.3268,0.7831,0.3367,0.7609,0.3333,0.7572,0.3333,0.727,0.3448,0.7403,0.3086,0.7659,0.3084,0.7715,0.3029,0.7786,0.3005,0.7772,0.3116,0.7718,0.3164,0.7717,0.3062,0.7789,0.3018,0.7812,0.3043,0.7826,0.3115,0.7805,0.3119,0.7755,0.3039,0.7694,0.2994,0.7752,0.3002,0.7787,0.3079,0.7696,0.2989,0.7747,0.2982,0.7712,0.3012,0.7601,0.3049,0.7598,0.3014,0.7554,0.2982,0.7665,0.3039,0.7522,0.2995,0.7705,0.304,0.7648,0.3052,0.7572,0.3239,0.7999,0.3283,0.7945,0.3289,0.7877,0.3393,0.7673,0.339,0.7749,0.3471,0.7764,0.3463,0.7804,0.3148,0.7808,0.3076,0.7828,0.3181,0.7765,0.3226,0.7997,0.3086,0.7886,0.3137,0.781,0.3313,0.7918,0.3487,0.7986,0.3425,0.7973,0.3502,0.7927,0.3291,0.7959,0.3354,0.7972,0.3282,0.8072,0.2937,0.8481,0.306,0.8086,0.3188,0.8256,0.305,0.8492,0.3558,0.7804,0.3576,0.7808,0.3357,0.8093,0.3353,0.808,0.3436,0.805,0.3525,0.7732,0.334,0.7629,0.3413,0.7642,0.3263,0.7472,0.3282,0.7564,0.3123,0.7306,0.3181,0.7339,0.315,0.7284,0.3157,0.7438,0.3169,0.7353,0.3221,0.7474,0.3632,0.7911,0.3596,0.7847,0.3357,0.7635,0.3328,0.7686,0.3309,0.7602,0.3228,0.7103,0.3572,0.7502,0.3315,0.7679,0.3186,0.7501,0.3632,0.7876,0.2917,0.7662,0.2975,0.7601,0.316,0.7849};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_65()
		{
			double[] value = {0.3478,0.8047,0.3404,0.814,0.3151,0.7915,0.3011,0.767,0.301,0.7623,0.2775,0.7965,0.2922,0.7801,0.2895,0.8263,0.3306,0.831,0.317,0.8536,0.3631,0.7532,0.423,0.802,0.4248,0.8016,0.4302,0.8091,0.4298,0.8106,0.4301,0.8098,0.4371,0.809,0.4341,0.8095,0.4287,0.8021,0.429,0.7974,0.4241,0.8059,0.4238,0.8101,0.432,0.8131,0.4352,0.8126,0.4298,0.8022,0.4375,0.811,0.4389,0.8082,0.4345,0.8029,0.4342,0.7933,0.4385,0.7944,0.4407,0.8046,0.4394,0.8074,0.4365,0.7877,0.4412,0.8008,0.439,0.7906,0.4186,0.7448,0.43,0.7315,0.4301,0.7617,0.4266,0.7655,0.4629,0.7818,0.4605,0.7832,0.455,0.7761,0.4547,0.7704,0.4571,0.7835,0.447,0.7763,0.4517,0.7764,0.4515,0.7801,0.4519,0.7851,0.4591,0.7871,0.4616,0.7858,0.4555,0.7742,0.4632,0.7833,0.464,0.7798,0.4595,0.774,0.4585,0.7644,0.4621,0.7646,0.4653,0.7757,0.4645,0.7793,0.4595,0.7568,0.4651,0.7711,0.4621,0.76,0.4581,0.7618,0.4594,0.7694,0.4639,0.7751,0.4345,0.7923,0.4351,0.7991,0.4394,0.8045,0.417,0.7849,0.4163,0.781,0.4244,0.7795,0.4241,0.7719,0.4453,0.781,0.4558,0.7874,0.4486,0.7854,0.4321,0.7964,0.4496,0.7856,0.4548,0.7932,0.4407,0.8042,0.4132,0.7972,0.4208,0.8019,0.4146,0.8031,0.4351,0.8117,0.428,0.8018,0.4343,0.8005,0.4583,0.8538,0.4446,0.8301,0.4574,0.8132,0.4697,0.8526,0.4058,0.7854,0.4076,0.7849,0.4281,0.8125,0.4277,0.8139,0.4198,0.8095,0.4109,0.7777,0.422,0.7687,0.4293,0.7675,0.4352,0.761,0.437,0.7518,0.4452,0.7385,0.4511,0.7352};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_66()
		{
			double[] value = {0.4484,0.7329,0.4466,0.7399,0.4476,0.7484,0.4413,0.752,0.4038,0.7892,0.4002,0.7956,0.4277,0.7681,0.4305,0.7732,0.4325,0.7648,0.4406,0.7148,0.4062,0.7548,0.4448,0.7547,0.4319,0.7724,0.4002,0.7921,0.4658,0.7647,0.4717,0.7707,0.4474,0.7895,0.423,0.8186,0.4157,0.8093,0.4482,0.7961,0.4624,0.7669,0.4622,0.7716,0.4739,0.8308,0.4712,0.7846,0.4858,0.8011,0.4464,0.8581,0.4327,0.8356,0.4003,0.7578,0.1258,0.3201,0.1258,0.3193,0.1259,0.32,0.0666,0.3446,0.0669,0.3446,0.0666,0.344,0.1127,0.3224,0.1126,0.3224,0.1126,0.3217,0.0997,0.3263,0.0997,0.3256,0.0999,0.3262,0.0872,0.3309,0.0874,0.3316,0.0873,0.3316,0.0754,0.3384,0.0753,0.3378,0.0756,0.3384,0.1275,0.3189,0.1274,0.3184,0.1275,0.3192,0.0706,0.3618,0.0707,0.362,0.0703,0.3614,0.1146,0.3252,0.1146,0.3249,0.1144,0.3244,0.1021,0.3325,0.1019,0.3321,0.1021,0.3328,0.0899,0.3413,0.0902,0.342,0.0901,0.3418,0.0788,0.3526,0.0785,0.3521,0.0789,0.3528,0.1253,0.3208,0.1253,0.3201,0.1252,0.3209,0.0608,0.3297,0.0609,0.3299,0.0607,0.3291,0.1116,0.3196,0.1116,0.3195,0.1116,0.3188,0.0979,0.3199,0.0979,0.3192,0.0979,0.32,0.0843,0.3213,0.0844,0.3221,0.0843,0.322,0.0709,0.3257,0.0708,0.3251,0.071,0.3258,0.1248,0.3157,0.1248,0.3154,0.1248,0.3149,0.0612,0.3111,0.0612,0.3103,0.061,0.3107,0.1111,0.3158,0.1111,0.3166,0.1111,0.3163,0.0976,0.3165,0.0975,0.3161,0.0976,0.3157,0.084,0.315,0.0842,0.3146,0.0841,0.3154,0.071,0.3133,0.0709,0.313,0.0711,0.3125};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_67()
		{
			double[] value = {0.1248,0.3149,0.1248,0.3149,0.1248,0.3142,0.0621,0.2962,0.0622,0.2956,0.062,0.2962,0.1112,0.313,0.1112,0.3137,0.1111,0.3137,0.0977,0.3111,0.0976,0.311,0.0977,0.3103,0.0844,0.3069,0.0846,0.3062,0.0845,0.3069,0.0717,0.3014,0.0715,0.3014,0.0718,0.3007,0.1248,0.3196,0.1248,0.3197,0.1248,0.3203,0.1112,0.3215,0.1112,0.3208,0.1111,0.3209,0.0977,0.3235,0.0976,0.3235,0.0977,0.3242,0.0844,0.3276,0.0846,0.3282,0.0845,0.3275,0.0717,0.333,0.0715,0.3331,0.0718,0.3337,0.1271,0.3149,0.1272,0.3156,0.1272,0.315,0.1137,0.3165,0.1136,0.3163,0.1137,0.3171,0.1002,0.3163,0.1002,0.3171,0.1003,0.3165,0.087,0.3158,0.0872,0.3152,0.087,0.315,0.0742,0.3123,0.0742,0.3131,0.0744,0.3125,0.0712,0.2736,0.0714,0.2736,0.0711,0.2742,0.1291,0.3096,0.116,0.3049,0.1159,0.305,0.129,0.3097,0.1158,0.3056,0.1289,0.3103,0.1032,0.2987,0.1031,0.2994,0.1034,0.2987,0.091,0.2915,0.0913,0.2909,0.0911,0.2909,0.0796,0.2817,0.0795,0.2823,0.0798,0.2817,0.1234,0.3079,0.1234,0.3086,0.1235,0.3086,0.1105,0.3098,0.1103,0.3091,0.1103,0.3098,0.0977,0.3103,0.0976,0.311,0.0978,0.3111,0.0854,0.3122,0.0857,0.3123,0.0856,0.3115,0.1252,0.3094,0.1252,0.3098,0.1252,0.309,0.0615,0.2936,0.0616,0.2933,0.0614,0.294,0.1116,0.309,0.1116,0.3094,0.1115,0.3098,0.098,0.3076,0.0979,0.3081,0.098,0.3073,0.0844,0.3045,0.0846,0.3037,0.0845,0.3041,0.0714,0.2988,0.0713,0.2992,0.0714,0.2985,0.1248,0.3162,0.1248,0.3162,0.1248,0.3155,0.0621,0.2975};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_68()
		{
			double[] value = {0.0622,0.2968,0.062,0.2974,0.1112,0.3143,0.1112,0.315,0.1111,0.315,0.0977,0.3123,0.0976,0.3123,0.0977,0.3116,0.0844,0.3082,0.0846,0.3075,0.0845,0.3082,0.0717,0.3027,0.0715,0.3026,0.0718,0.302,0.1272,0.3069,0.1145,0.3033,0.1143,0.3031,0.127,0.3067,0.1142,0.3039,0.127,0.3075,0.1021,0.2982,0.1021,0.299,0.1023,0.2984,0.1252,0.3112,0.1252,0.312,0.1254,0.3116,0.113,0.3132,0.1128,0.3128,0.1128,0.3136,0.1008,0.3134,0.1008,0.3143,0.1011,0.3139,0.1264,0.3084,0.1265,0.3093,0.1266,0.3089,0.1134,0.3105,0.1132,0.3101,0.1132,0.3109,0.1002,0.3107,0.1002,0.3115,0.1004,0.3111,0.1325,0.3031,0.1323,0.3038,0.1325,0.3032,0.1195,0.2982,0.1194,0.2981,0.1192,0.2988,0.1071,0.2918,0.1068,0.2925,0.1072,0.2919,0.1522,0.32,0.1523,0.3193,0.1523,0.3201,0.2116,0.344,0.2112,0.3446,0.2114,0.3446,0.1655,0.3224,0.1654,0.3224,0.1655,0.3217,0.1784,0.3256,0.1784,0.3263,0.1782,0.3262,0.1906,0.3316,0.1909,0.3309,0.1908,0.3316,0.2028,0.3378,0.2027,0.3384,0.2025,0.3384,0.1506,0.3192,0.1507,0.3184,0.1506,0.3189,0.2078,0.3614,0.2074,0.362,0.2075,0.3618,0.1635,0.3249,0.1635,0.3252,0.1637,0.3244,0.1762,0.3321,0.176,0.3325,0.176,0.3328,0.1879,0.342,0.1882,0.3413,0.188,0.3418,0.1996,0.3521,0.1993,0.3526,0.1992,0.3528,0.1529,0.3209,0.1528,0.3201,0.1528,0.3208,0.2174,0.3291,0.2172,0.3299,0.2173,0.3297,0.1665,0.3195,0.1665,0.3196,0.1665,0.3188,0.1802,0.3192,0.1802,0.3199,0.1802,0.32,0.1937,0.3221,0.1938,0.3213};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_69()
		{
			double[] value = {0.1938,0.322,0.2073,0.3251,0.2072,0.3257,0.2071,0.3258,0.1533,0.3149,0.1533,0.3154,0.1533,0.3157,0.2171,0.3107,0.2168,0.3103,0.2169,0.3111,0.167,0.3166,0.167,0.3158,0.167,0.3163,0.1806,0.3161,0.1806,0.3165,0.1806,0.3157,0.1939,0.3146,0.1941,0.315,0.194,0.3154,0.2072,0.313,0.2071,0.3133,0.207,0.3125,0.1533,0.3142,0.1533,0.3149,0.1533,0.3149,0.2161,0.2962,0.2158,0.2956,0.216,0.2962,0.1669,0.3137,0.1669,0.313,0.167,0.3137,0.1805,0.311,0.1804,0.3111,0.1804,0.3103,0.1935,0.3062,0.1937,0.3069,0.1936,0.3069,0.2066,0.3014,0.2064,0.3014,0.2063,0.3007,0.1533,0.3203,0.1533,0.3197,0.1533,0.3196,0.1669,0.3208,0.1669,0.3215,0.167,0.3209,0.1805,0.3235,0.1804,0.3235,0.1804,0.3242,0.1935,0.3282,0.1937,0.3276,0.1936,0.3275,0.2066,0.3331,0.2064,0.333,0.2063,0.3337,0.1509,0.315,0.1509,0.3156,0.151,0.3149,0.1645,0.3163,0.1644,0.3165,0.1645,0.3171,0.1779,0.3171,0.1779,0.3163,0.1778,0.3165,0.1909,0.3152,0.1911,0.3158,0.1911,0.315,0.204,0.3131,0.2039,0.3123,0.2037,0.3125,0.207,0.2742,0.2067,0.2736,0.2069,0.2736,0.1491,0.3097,0.1622,0.305,0.1621,0.3049,0.1491,0.3096,0.1492,0.3103,0.1623,0.3056,0.175,0.2994,0.1749,0.2987,0.1747,0.2987,0.1868,0.2909,0.1871,0.2915,0.187,0.2909,0.1987,0.2823,0.1985,0.2817,0.1983,0.2817,0.1546,0.3086,0.1547,0.3086,0.1547,0.3079,0.1677,0.3091,0.1676,0.3098,0.1678,0.3098,0.1805,0.311,0.1804,0.3103,0.1803,0.3111,0.1924,0.3123,0.1927,0.3122,0.1925,0.3115};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_70()
		{
			double[] value = {0.1529,0.309,0.1528,0.3098,0.1528,0.3094,0.2168,0.294,0.2165,0.2933,0.2166,0.2936,0.1665,0.3094,0.1665,0.309,0.1666,0.3098,0.1802,0.3081,0.1801,0.3076,0.1801,0.3073,0.1935,0.3037,0.1937,0.3045,0.1936,0.3041,0.2069,0.2992,0.2067,0.2988,0.2067,0.2985,0.1533,0.3155,0.1533,0.3162,0.1533,0.3162,0.2161,0.2974,0.2158,0.2968,0.216,0.2975,0.1669,0.315,0.1669,0.3143,0.167,0.315,0.1805,0.3123,0.1804,0.3123,0.1804,0.3116,0.1935,0.3075,0.1937,0.3082,0.1936,0.3082,0.2066,0.3026,0.2064,0.3027,0.2063,0.302,0.1511,0.3067,0.1638,0.3031,0.1636,0.3033,0.1509,0.3069,0.1511,0.3075,0.1639,0.3039,0.1761,0.299,0.176,0.2982,0.1757,0.2984,0.1527,0.3116,0.1528,0.312,0.1529,0.3112,0.1653,0.3128,0.1651,0.3132,0.1653,0.3136,0.1773,0.3143,0.1773,0.3134,0.177,0.3139,0.1515,0.3089,0.1516,0.3093,0.1517,0.3084,0.1649,0.3101,0.1647,0.3105,0.1649,0.3109,0.1779,0.3115,0.1779,0.3107,0.1777,0.3111,0.1456,0.3032,0.1458,0.3038,0.1457,0.3031,0.1587,0.2981,0.1586,0.2982,0.1589,0.2988,0.1712,0.2925,0.171,0.2918,0.1709,0.2919,0.1322,0.3159,0.132,0.3159,0.1316,0.3156,0.1014,0.3522,0.1009,0.3519,0.1012,0.3523,0.1266,0.3245,0.1271,0.3247,0.1269,0.3247,0.1212,0.333,0.1211,0.333,0.1207,0.3327,0.1145,0.3406,0.1141,0.3403,0.1146,0.3406,0.1074,0.3475,0.1072,0.3475,0.1069,0.3472,0.1313,0.314,0.1318,0.3142,0.1313,0.314,0.1275,0.3235,0.1275,0.3236,0.128,0.3238,0.1226,0.3326,0.1231,0.3329,0.1227,0.3326,0.1173,0.3413};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_71()
		{
			double[] value = {0.1168,0.341,0.1168,0.3411,0.1099,0.3488,0.1104,0.3491,0.11,0.3488,0.0838,0.3384,0.0838,0.3383,0.0841,0.3387,0.1292,0.3112,0.1214,0.3185,0.1215,0.3186,0.1293,0.3113,0.1218,0.3189,0.1297,0.3116,0.1127,0.3251,0.113,0.3254,0.1126,0.325,0.1033,0.331,0.1029,0.3306,0.103,0.3307,0.0925,0.3354,0.0928,0.3357,0.0924,0.3353,0.128,0.3138,0.1282,0.3139,0.1276,0.3136,0.0973,0.3517,0.097,0.3515,0.0974,0.3519,0.1233,0.3229,0.1237,0.323,0.1239,0.3232,0.1182,0.3316,0.1184,0.3318,0.1178,0.3315,0.1118,0.3398,0.1113,0.3394,0.1116,0.3396,0.1039,0.3467,0.1041,0.347,0.1036,0.3466,0.1317,0.3158,0.1315,0.3157,0.1311,0.3155,0.1009,0.3543,0.1004,0.354,0.1007,0.3543,0.1261,0.3245,0.1266,0.3247,0.1265,0.3247,0.1208,0.3333,0.1206,0.3332,0.1202,0.333,0.114,0.3413,0.1136,0.3411,0.1142,0.3414,0.1069,0.349,0.1067,0.3489,0.1064,0.3486,0.1491,0.3156,0.1487,0.3159,0.1485,0.3159,0.1795,0.3523,0.1798,0.3519,0.1793,0.3522,0.1536,0.3247,0.1542,0.3245,0.1538,0.3247,0.1596,0.333,0.1595,0.333,0.16,0.3327,0.1666,0.3403,0.1663,0.3406,0.1661,0.3406,0.1735,0.3475,0.1733,0.3475,0.1738,0.3472,0.1494,0.314,0.1489,0.3142,0.1494,0.314,0.1532,0.3236,0.1532,0.3235,0.1527,0.3238,0.1576,0.3329,0.1581,0.3326,0.1581,0.3326,0.1639,0.341,0.1635,0.3413,0.1639,0.3411,0.1703,0.3491,0.1708,0.3488,0.1707,0.3488,0.1966,0.3387,0.1969,0.3383,0.1969,0.3384,0.1514,0.3113,0.1592,0.3186,0.1593,0.3185,0.1515,0.3112,0.1511,0.3116};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_72()
		{
			double[] value = {0.1589,0.3189,0.1677,0.3254,0.168,0.3251,0.1681,0.325,0.1778,0.3306,0.1774,0.331,0.1777,0.3307,0.188,0.3357,0.1882,0.3354,0.1883,0.3353,0.1531,0.3136,0.1525,0.3139,0.1528,0.3138,0.1833,0.3519,0.1837,0.3515,0.1835,0.3517,0.1571,0.323,0.1574,0.3229,0.1569,0.3232,0.1624,0.3318,0.1625,0.3316,0.1629,0.3315,0.1695,0.3394,0.169,0.3398,0.1691,0.3396,0.1767,0.347,0.1768,0.3467,0.1771,0.3466,0.1496,0.3155,0.1492,0.3157,0.149,0.3158,0.18,0.3543,0.1803,0.354,0.1798,0.3543,0.1541,0.3247,0.1547,0.3245,0.1543,0.3247,0.1602,0.3332,0.16,0.3333,0.1605,0.333,0.1671,0.3411,0.1667,0.3413,0.1666,0.3414,0.174,0.3489,0.1738,0.349,0.1743,0.3486,0.8273,0.7023,0.8256,0.7051,0.8201,0.7036,0.8219,0.7009,0.8162,0.7302,0.8143,0.7335,0.8197,0.735,0.8216,0.7316,0.8173,0.7243,0.8167,0.7272,0.8145,0.7266,0.8151,0.7237,0.8256,0.7204,0.827,0.7131,0.8185,0.7108,0.817,0.7181,0.8278,0.7212,0.8261,0.724,0.8274,0.7171,0.8291,0.7143,0.8157,0.7107,0.814,0.7135,0.8126,0.7204,0.8144,0.7176,0.8284,0.7037,0.8206,0.7016,0.8196,0.7051,0.8281,0.7074,0.8189,0.7019,0.8171,0.7047,0.8164,0.7082,0.8182,0.7054,0.8194,0.7098,0.8219,0.7105,0.8216,0.712,0.8191,0.7113,0.8279,0.7075,0.8296,0.7048,0.8289,0.7083,0.8272,0.711,0.8155,0.7276,0.8234,0.7297,0.8245,0.7256,0.816,0.7233,0.8246,0.7302,0.8229,0.7332,0.8237,0.729,0.8254,0.7262,0.8171,0.7333,0.8147,0.7327,0.815,0.7311,0.8174,0.7317,0.8121,0.7304,0.8139,0.7273};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_73()
		{
			double[] value = {0.8147,0.7234,0.8129,0.7261,0.8177,0.7087,0.8173,0.7106,0.8161,0.71,0.8167,0.7071,0.8187,0.7121,0.8219,0.7129,0.8228,0.7133,0.8182,0.7121,0.8236,0.7123,0.824,0.7103,0.826,0.7095,0.8254,0.7125,0.8226,0.709,0.8195,0.7082,0.8193,0.7062,0.824,0.7074,0.8192,0.7203,0.8161,0.7195,0.8173,0.7148,0.8219,0.716,0.8142,0.721,0.8134,0.7249,0.8132,0.7231,0.8144,0.7172,0.8146,0.7273,0.8177,0.7281,0.8195,0.728,0.8149,0.7268,0.8196,0.7266,0.8203,0.7226,0.8236,0.7197,0.8225,0.7256,0.8192,0.7339,0.8197,0.7316,0.8219,0.7307,0.8211,0.7342,0.8183,0.7303,0.8151,0.7294,0.8151,0.7274,0.8197,0.7286,0.8134,0.7299,0.8129,0.7322,0.8119,0.7317,0.8125,0.7282,0.8142,0.7338,0.8174,0.7346,0.8184,0.7355,0.8138,0.7342,0.8327,0.6705,0.8299,0.6734,0.8247,0.6719,0.8275,0.6691,0.8239,0.6984,0.8211,0.7018,0.8263,0.7032,0.8291,0.6998,0.8204,0.6925,0.82,0.6955,0.8178,0.6949,0.8182,0.6919,0.8323,0.6886,0.8333,0.6813,0.825,0.6791,0.8241,0.6863,0.8344,0.6895,0.8316,0.6923,0.8325,0.6853,0.8352,0.6826,0.8223,0.679,0.8195,0.6817,0.8187,0.6887,0.8214,0.6859,0.8341,0.672,0.8265,0.6698,0.8257,0.6734,0.834,0.6757,0.8246,0.6701,0.8219,0.673,0.8215,0.6764,0.8242,0.6736,0.8233,0.6781,0.8256,0.6787,0.8255,0.6802,0.8231,0.6796,0.8323,0.6758,0.835,0.673,0.8346,0.6765,0.8319,0.6793,0.8233,0.6958,0.8309,0.6979,0.8317,0.6939,0.8235,0.6916,0.832,0.6985,0.8292,0.7015,0.8297,0.6973,0.8324,0.6945,0.8223,0.7016,0.82,0.7009};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_74()
		{
			double[] value = {0.8202,0.6994,0.8225,0.7,0.8188,0.6986,0.8216,0.6956,0.8221,0.6916,0.8193,0.6944,0.8217,0.6769,0.8215,0.6789,0.8206,0.6783,0.8209,0.6754,0.8229,0.6803,0.826,0.6812,0.8271,0.6816,0.8227,0.6804,0.8276,0.6806,0.8278,0.6786,0.8299,0.6778,0.8296,0.6807,0.8264,0.6772,0.8234,0.6764,0.8234,0.6745,0.8278,0.6757,0.8227,0.6885,0.8197,0.6877,0.8216,0.6831,0.826,0.6843,0.818,0.6893,0.8175,0.6932,0.8183,0.6914,0.819,0.6855,0.8188,0.6956,0.8217,0.6964,0.8245,0.6963,0.82,0.695,0.8234,0.6948,0.8239,0.6909,0.8279,0.6879,0.8271,0.6939,0.8246,0.7022,0.8249,0.6999,0.8273,0.6989,0.8269,0.7024,0.8234,0.6985,0.8204,0.6977,0.8206,0.6957,0.8251,0.6969,0.8188,0.6982,0.8186,0.7005,0.8179,0.6999,0.8183,0.6964,0.8199,0.7021,0.8229,0.7029,0.8243,0.7037,0.8199,0.7025,0.8358,0.6416,0.8331,0.6444,0.8278,0.643,0.8306,0.6402,0.827,0.6694,0.8242,0.6728,0.8295,0.6742,0.8322,0.6709,0.8235,0.6635,0.8232,0.6665,0.8209,0.6659,0.8213,0.6629,0.8355,0.6597,0.8364,0.6523,0.8281,0.6501,0.8273,0.6574,0.8375,0.6605,0.8348,0.6633,0.8356,0.6563,0.8383,0.6536,0.8253,0.65,0.8227,0.6528,0.8218,0.6597,0.8245,0.6569,0.8372,0.643,0.8296,0.6409,0.8288,0.6444,0.8371,0.6467,0.8278,0.6412,0.825,0.644,0.8246,0.6475,0.8273,0.6447,0.8264,0.6491,0.8287,0.6497,0.8285,0.6513,0.8263,0.6506,0.8354,0.6469,0.8382,0.6441,0.8378,0.6475,0.835,0.6504,0.8265,0.6669,0.834,0.669,0.8349,0.6649,0.8266,0.6626,0.8351,0.6695,0.8323,0.6725};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_75()
		{
			double[] value = {0.8329,0.6683,0.8356,0.6655,0.8255,0.6727,0.8231,0.672,0.8233,0.6704,0.8256,0.671,0.822,0.6697,0.8247,0.6666,0.8251,0.6626,0.8225,0.6655,0.8248,0.648,0.8246,0.65,0.8237,0.6493,0.8241,0.6464,0.826,0.6514,0.8291,0.6522,0.8303,0.6526,0.8258,0.6514,0.8307,0.6516,0.8309,0.6496,0.833,0.6488,0.8327,0.6518,0.8296,0.6483,0.8265,0.6474,0.8265,0.6455,0.831,0.6468,0.8258,0.6596,0.8228,0.6588,0.8247,0.6541,0.8291,0.6553,0.8211,0.6603,0.8206,0.6643,0.8213,0.6624,0.8221,0.6565,0.8219,0.6666,0.8248,0.6674,0.8276,0.6673,0.8231,0.6661,0.8265,0.6659,0.827,0.662,0.831,0.659,0.8303,0.6649,0.8277,0.6732,0.828,0.6709,0.8304,0.67,0.83,0.6734,0.8265,0.6695,0.8235,0.6687,0.8237,0.6667,0.8282,0.668,0.822,0.6692,0.8216,0.6715,0.821,0.671,0.8214,0.6675,0.823,0.6731,0.826,0.6739,0.8275,0.6747,0.823,0.6735,0.8397,0.6298,0.8379,0.6337,0.8407,0.6248,0.8425,0.6208,0.8288,0.6163,0.827,0.6203,0.8242,0.6293,0.8261,0.6254,0.8252,0.6475,0.8235,0.647,0.8238,0.6456,0.8256,0.6461,0.8281,0.631,0.8263,0.6349,0.8331,0.6371,0.8349,0.6332,0.8405,0.6151,0.8386,0.6192,0.8317,0.617,0.8337,0.6129,0.8348,0.6382,0.8366,0.6324,0.8387,0.6289,0.8363,0.6366,0.8343,0.6286,0.8283,0.6266,0.8298,0.6217,0.8365,0.6239,0.8241,0.6287,0.8225,0.6341,0.823,0.6322,0.8253,0.6245,0.8246,0.6386,0.8306,0.6405,0.8316,0.6395,0.8252,0.6373,0.8313,0.6421,0.8321,0.6391,0.8344,0.636,0.8333,0.6399,0.8302,0.6363,0.8262,0.635};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_76()
		{
			double[] value = {0.8271,0.631,0.8322,0.6327,0.8232,0.6362,0.8224,0.6394,0.8223,0.6366,0.8235,0.6325,0.8243,0.6422,0.8283,0.6435,0.8295,0.6418,0.8244,0.6401,0.8276,0.6463,0.8281,0.6445,0.8302,0.6421,0.8296,0.6444,0.8269,0.643,0.8246,0.6422,0.8253,0.6388,0.8286,0.6398,0.8229,0.6429,0.8225,0.6447,0.8223,0.6421,0.8229,0.6396,0.8236,0.6463,0.8259,0.647,0.8272,0.6454,0.8239,0.6444,0.8274,0.6247,0.8291,0.6295,0.835,0.6314,0.8392,0.6285,0.8416,0.6207,0.8398,0.6158,0.8339,0.614,0.8298,0.6169,0.8426,0.6246,0.8426,0.6195,0.8426,0.6167,0.8426,0.6217,0.8668,0.6246,0.8633,0.6248,0.8633,0.6226,0.8668,0.6224,0.8672,0.6213,0.8672,0.616,0.8629,0.6163,0.8629,0.6216,0.8629,0.6159,0.8629,0.6107,0.8672,0.6103,0.8672,0.6156,0.8539,0.6174,0.8539,0.6122,0.8584,0.6113,0.8584,0.6165,0.8544,0.6261,0.8544,0.6238,0.8579,0.6232,0.8579,0.6255,0.8539,0.6179,0.8539,0.623,0.8584,0.6222,0.8584,0.6169,0.8449,0.6197,0.8449,0.6147,0.8494,0.6134,0.8494,0.6185,0.8453,0.6296,0.8453,0.6273,0.8489,0.6265,0.8489,0.6287,0.8449,0.6203,0.8449,0.6253,0.8494,0.6241,0.8494,0.619,0.849,0.6244,0.8452,0.6253,0.845,0.6235,0.8493,0.6224,0.8509,0.6275,0.8509,0.6251,0.8514,0.6232,0.8514,0.6259,0.8452,0.6301,0.849,0.6291,0.8493,0.6277,0.845,0.6288,0.8433,0.627,0.8433,0.6294,0.8428,0.628,0.8428,0.6254,0.858,0.6215,0.8542,0.6222,0.854,0.621,0.8583,0.6202,0.8599,0.6248,0.8599,0.6224,0.8604,0.6212,0.8604,0.6239,0.8542,0.6269,0.858,0.6262};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_77()
		{
			double[] value = {0.8583,0.6256,0.854,0.6263,0.8524,0.6237,0.8524,0.6261,0.8519,0.6254,0.8519,0.6227,0.8613,0.6222,0.8613,0.6246,0.8609,0.6238,0.8609,0.6212,0.8669,0.6207,0.8632,0.6209,0.863,0.6196,0.8671,0.6193,0.8687,0.6241,0.8687,0.6217,0.8694,0.6206,0.8694,0.6233,0.8632,0.6256,0.8669,0.6254,0.8671,0.6247,0.863,0.625,0.8449,0.6139,0.8449,0.6167,0.8517,0.6225,0.8517,0.6191,0.8539,0.6115,0.8517,0.614,0.8517,0.6126,0.8539,0.6143,0.8517,0.6143,0.8517,0.6174,0.8694,0.6116,0.8672,0.6096,0.8694,0.6169,0.8694,0.6197,0.8694,0.6145,0.8672,0.6124,0.8584,0.6135,0.8606,0.6156,0.8606,0.6125,0.8606,0.6208,0.8606,0.6174,0.8606,0.6108,0.8606,0.6121,0.8584,0.6106,0.8494,0.6126,0.8494,0.6155,0.8517,0.6247,0.8517,0.622,0.8629,0.6128,0.8629,0.61,0.8606,0.6202,0.8606,0.6229,0.8188,0.72,0.8171,0.7271,0.8112,0.7259,0.8129,0.7187,0.8122,0.7321,0.8105,0.739,0.8164,0.7403,0.8181,0.7334,0.8208,0.7097,0.8209,0.7085,0.8184,0.7079,0.8183,0.7092,0.8183,0.7333,0.8181,0.7366,0.8088,0.7347,0.809,0.7314,0.8228,0.7289,0.821,0.7361,0.8212,0.733,0.8229,0.7258,0.8083,0.7226,0.8065,0.7298,0.8064,0.7329,0.8081,0.7258,0.8096,0.7273,0.8182,0.7291,0.8184,0.7308,0.8091,0.7288,0.8099,0.7188,0.8082,0.726,0.8081,0.7276,0.8098,0.7204,0.8187,0.7145,0.816,0.714,0.816,0.7147,0.8186,0.7152,0.82,0.7285,0.8217,0.7214,0.8216,0.723,0.8199,0.7301,0.8175,0.7408,0.809,0.7389,0.8087,0.737,0.818,0.739,0.8211,0.7329,0.8194,0.74};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_78()
		{
			double[] value = {0.8195,0.7382,0.8212,0.731,0.8159,0.7223,0.8185,0.7229,0.8186,0.7222,0.8159,0.7216,0.8076,0.7375,0.8093,0.7304,0.8094,0.7285,0.8077,0.7357,0.8137,0.715,0.8137,0.7141,0.8118,0.7149,0.8117,0.7163,0.8188,0.7166,0.8154,0.7158,0.8142,0.7175,0.8193,0.7185,0.8206,0.7156,0.8206,0.7165,0.8219,0.7184,0.8219,0.7171,0.8155,0.714,0.8189,0.7148,0.8194,0.7159,0.8144,0.7148,0.817,0.7108,0.8204,0.7115,0.8198,0.717,0.8148,0.7159,0.8152,0.7131,0.8153,0.7113,0.8122,0.7167,0.812,0.7194,0.8202,0.7151,0.8168,0.7144,0.8145,0.721,0.8196,0.7221,0.822,0.7128,0.8219,0.7145,0.8221,0.7215,0.8222,0.7189,0.8204,0.7239,0.8203,0.7249,0.8213,0.728,0.8214,0.7264,0.8153,0.722,0.8188,0.7228,0.819,0.7248,0.814,0.7238,0.8134,0.7234,0.8135,0.7224,0.8113,0.7242,0.8113,0.7258,0.8186,0.7248,0.8152,0.7241,0.8137,0.7271,0.8188,0.7281,0.8198,0.7057,0.818,0.7128,0.8122,0.7115,0.8139,0.7044,0.8132,0.7178,0.8115,0.7247,0.8173,0.726,0.8191,0.7191,0.8217,0.6954,0.8219,0.6941,0.8194,0.6936,0.8193,0.6949,0.8192,0.7191,0.8191,0.7223,0.8098,0.7203,0.8099,0.717,0.8237,0.7146,0.822,0.7218,0.8222,0.7186,0.8239,0.7115,0.8092,0.7084,0.8075,0.7155,0.8074,0.7186,0.8091,0.7115,0.8105,0.7129,0.8191,0.7148,0.8194,0.7165,0.8101,0.7145,0.8109,0.7045,0.8092,0.7117,0.8091,0.7133,0.8108,0.7061,0.8196,0.7002,0.817,0.6997,0.8169,0.7003,0.8196,0.7009,0.8209,0.7142,0.8227,0.7071,0.8226,0.7086,0.8208,0.7158,0.8185,0.7264,0.8099,0.7246};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_79()
		{
			double[] value = {0.8096,0.7226,0.819,0.7247,0.8221,0.7186,0.8203,0.7256,0.8204,0.7239,0.8222,0.7167,0.8168,0.708,0.8195,0.7086,0.8195,0.7079,0.8169,0.7073,0.8086,0.7232,0.8103,0.7161,0.8104,0.7142,0.8087,0.7213,0.8147,0.7007,0.8147,0.6998,0.8127,0.7006,0.8127,0.702,0.8198,0.7022,0.8163,0.7015,0.8152,0.7032,0.8202,0.7042,0.8216,0.7013,0.8216,0.7022,0.8228,0.7041,0.8229,0.7028,0.8164,0.6997,0.8199,0.7005,0.8204,0.7016,0.8153,0.7005,0.818,0.6965,0.8213,0.6973,0.8207,0.7027,0.8157,0.7016,0.8162,0.6988,0.8163,0.697,0.8131,0.7024,0.813,0.7051,0.8211,0.7007,0.8178,0.7,0.8155,0.7067,0.8205,0.7078,0.823,0.6985,0.8229,0.7002,0.823,0.7072,0.8232,0.7046,0.8213,0.7095,0.8213,0.7106,0.8223,0.7137,0.8224,0.7121,0.8163,0.7077,0.8197,0.7085,0.82,0.7105,0.8149,0.7094,0.8144,0.7091,0.8145,0.708,0.8123,0.7099,0.8122,0.7115,0.8196,0.7105,0.8161,0.7098,0.8147,0.7127,0.8198,0.7138,0.8305,0.668,0.8296,0.6762,0.83,0.6681,0.8309,0.6599,0.8158,0.6588,0.8149,0.6669,0.8145,0.675,0.8154,0.6668,0.8243,0.648,0.8263,0.6482,0.8265,0.6456,0.8245,0.6454,0.8189,0.6711,0.818,0.6794,0.8256,0.6799,0.8265,0.6717,0.8273,0.6557,0.8265,0.6637,0.8189,0.6631,0.8198,0.6551,0.8313,0.6507,0.8306,0.6585,0.8309,0.6622,0.8314,0.6543,0.8214,0.6463,0.828,0.6468,0.828,0.6501,0.8206,0.6495,0.8169,0.6575,0.8175,0.6501,0.8166,0.6531,0.8161,0.661,0.8267,0.6627,0.8201,0.6622,0.8197,0.6654,0.8268,0.6659,0.8299,0.6476,0.8295,0.653};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_80()
		{
			double[] value = {0.8302,0.6552,0.8307,0.6489,0.8231,0.6436,0.8275,0.6439,0.8279,0.6448,0.8223,0.6444,0.8196,0.6524,0.8201,0.6468,0.8187,0.6481,0.8181,0.6546,0.8266,0.6565,0.8221,0.6562,0.8209,0.6591,0.8266,0.6595,0.8282,0.646,0.828,0.6493,0.829,0.651,0.8293,0.6468,0.8243,0.6436,0.8268,0.6438,0.8273,0.6436,0.8236,0.6433,0.8223,0.6489,0.8226,0.6455,0.8212,0.646,0.8208,0.6506,0.8263,0.6513,0.8237,0.6511,0.8229,0.6538,0.8265,0.654,0.8258,0.6656,0.8288,0.6694,0.8284,0.6764,0.825,0.6796,0.8185,0.6791,0.8155,0.6754,0.8158,0.6684,0.8193,0.6651,0.8449,0.6799,0.8449,0.6774,0.8494,0.6769,0.8494,0.6794,0.8584,0.6761,0.8584,0.6786,0.8539,0.679,0.8539,0.6765,0.8517,0.6786,0.8517,0.6772,0.8672,0.6757,0.8672,0.6782,0.8629,0.6783,0.8629,0.6758,0.8606,0.6764,0.8606,0.6779,0.8514,0.6649,0.8517,0.6658,0.8517,0.668,0.8609,0.6645,0.8606,0.6672,0.8606,0.6653,0.8609,0.6669,0.8606,0.6676,0.8606,0.6703,0.8514,0.6673,0.8517,0.6682,0.8517,0.671,0.8519,0.6675,0.8604,0.6669,0.8494,0.6721,0.8494,0.6777,0.8517,0.6766,0.8629,0.6766,0.8606,0.6758,0.8629,0.671,0.8494,0.6671,0.8629,0.6661,0.8494,0.6727,0.8517,0.6735,0.8519,0.6652,0.8604,0.6646,0.8629,0.6716,0.8606,0.6728,0.863,0.668,0.8583,0.6683,0.8584,0.6713,0.854,0.6686,0.8539,0.6717,0.8493,0.6687,0.8493,0.6639,0.854,0.6638,0.8539,0.6667,0.8583,0.6635,0.8584,0.6663,0.863,0.6632,0.8584,0.6719,0.8584,0.6769,0.8694,0.6752,0.8694,0.6697,0.8672,0.6709,0.8672,0.6765};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_81()
		{
			double[] value = {0.8694,0.6671,0.8694,0.6727,0.8672,0.6714,0.8672,0.6659,0.8671,0.6631,0.8671,0.6679,0.8539,0.6772,0.8539,0.6723,0.8449,0.6782,0.8449,0.6732,0.8426,0.6772,0.8426,0.6747,0.845,0.6644,0.8449,0.6676,0.8426,0.6691,0.8449,0.6726,0.845,0.6691,0.8426,0.6716,0.8428,0.6682,0.8428,0.6658,0.8452,0.6633,0.8433,0.6645,0.8509,0.6637,0.849,0.6629,0.8453,0.6637,0.8489,0.6633,0.849,0.6671,0.8509,0.6659,0.8489,0.6653,0.8433,0.6666,0.8452,0.6674,0.8453,0.6657,0.8542,0.6633,0.8524,0.6645,0.8599,0.6639,0.858,0.663,0.8544,0.664,0.8579,0.6638,0.858,0.6672,0.8599,0.6661,0.8579,0.6658,0.8524,0.6666,0.8542,0.6675,0.8544,0.666,0.8613,0.666,0.8632,0.667,0.8632,0.6628,0.8613,0.6639,0.8633,0.6655,0.8633,0.6635,0.8687,0.6637,0.8694,0.6643,0.8669,0.6627,0.8668,0.6634,0.8669,0.6669,0.8694,0.6667,0.8687,0.6658,0.8668,0.6654,0.9169,0.7009,0.9186,0.7036,0.9133,0.7051,0.9115,0.7023,0.9172,0.7316,0.9191,0.735,0.9245,0.7335,0.9226,0.7302,0.9237,0.7237,0.9243,0.7266,0.922,0.7272,0.9214,0.7243,0.9217,0.7181,0.9203,0.7108,0.9118,0.7131,0.9132,0.7204,0.9096,0.7143,0.9114,0.7171,0.9127,0.724,0.911,0.7212,0.9244,0.7176,0.9261,0.7204,0.9248,0.7135,0.923,0.7107,0.9107,0.7074,0.9192,0.7051,0.9182,0.7016,0.9103,0.7037,0.9206,0.7054,0.9223,0.7082,0.9217,0.7047,0.9199,0.7019,0.9196,0.7113,0.9172,0.712,0.917,0.7105,0.9193,0.7098,0.9116,0.711,0.9098,0.7083,0.9091,0.7048,0.9109,0.7075,0.9227,0.7233,0.9142,0.7256};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_82()
		{
			double[] value = {0.9154,0.7297,0.9232,0.7276,0.9134,0.7262,0.9151,0.729,0.9159,0.7332,0.9141,0.7302,0.9214,0.7317,0.9237,0.7311,0.9241,0.7327,0.9217,0.7333,0.9258,0.7261,0.9241,0.7234,0.9249,0.7273,0.9267,0.7304,0.9221,0.7071,0.9226,0.71,0.9214,0.7106,0.921,0.7087,0.9206,0.7121,0.9159,0.7133,0.9169,0.7129,0.92,0.7121,0.9134,0.7125,0.9127,0.7095,0.9147,0.7103,0.9151,0.7123,0.9148,0.7074,0.9194,0.7062,0.9193,0.7082,0.9161,0.709,0.9169,0.716,0.9215,0.7148,0.9226,0.7195,0.9195,0.7203,0.9244,0.7172,0.9256,0.7231,0.9253,0.7249,0.9246,0.721,0.9239,0.7268,0.9193,0.728,0.9211,0.7281,0.9241,0.7273,0.9163,0.7256,0.9152,0.7197,0.9184,0.7226,0.9192,0.7266,0.9176,0.7342,0.9169,0.7307,0.9191,0.7316,0.9195,0.7339,0.919,0.7286,0.9236,0.7274,0.9236,0.7294,0.9205,0.7303,0.9262,0.7282,0.9269,0.7317,0.9258,0.7322,0.9254,0.7299,0.925,0.7342,0.9203,0.7355,0.9214,0.7346,0.9245,0.7338,0.9113,0.6691,0.914,0.6719,0.9088,0.6734,0.9061,0.6705,0.9097,0.6998,0.9124,0.7032,0.9177,0.7018,0.9148,0.6984,0.9206,0.6919,0.9209,0.6949,0.9187,0.6955,0.9184,0.6925,0.9146,0.6863,0.9137,0.6791,0.9055,0.6813,0.9064,0.6886,0.9036,0.6826,0.9063,0.6853,0.9071,0.6923,0.9044,0.6895,0.9174,0.6859,0.9201,0.6887,0.9192,0.6817,0.9165,0.679,0.9048,0.6757,0.913,0.6734,0.9123,0.6698,0.9047,0.672,0.9145,0.6736,0.9173,0.6764,0.9169,0.673,0.9141,0.6701,0.9156,0.6796,0.9133,0.6802,0.9132,0.6787,0.9154,0.6781,0.9069,0.6793,0.9041,0.6765};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_83()
		{
			double[] value = {0.9037,0.673,0.9064,0.6758,0.9152,0.6916,0.907,0.6939,0.9078,0.6979,0.9154,0.6958,0.9063,0.6945,0.909,0.6973,0.9096,0.7015,0.9068,0.6985,0.9162,0.7,0.9186,0.6994,0.9188,0.7009,0.9164,0.7016,0.9194,0.6944,0.9167,0.6916,0.9172,0.6956,0.9199,0.6986,0.9178,0.6754,0.9182,0.6783,0.9173,0.6789,0.917,0.6769,0.9161,0.6804,0.9116,0.6816,0.9128,0.6812,0.9158,0.6803,0.9092,0.6807,0.9088,0.6778,0.9109,0.6786,0.9112,0.6806,0.9109,0.6757,0.9154,0.6745,0.9154,0.6764,0.9123,0.6772,0.9127,0.6843,0.9172,0.6831,0.9191,0.6877,0.9161,0.6885,0.9198,0.6855,0.9205,0.6914,0.9213,0.6932,0.9208,0.6893,0.9187,0.695,0.9143,0.6963,0.9171,0.6964,0.92,0.6956,0.9116,0.6939,0.9109,0.6879,0.9149,0.6909,0.9153,0.6948,0.9119,0.7024,0.9115,0.6989,0.9139,0.6999,0.9142,0.7022,0.9137,0.6969,0.9181,0.6957,0.9184,0.6977,0.9153,0.6985,0.9204,0.6964,0.9209,0.6999,0.9202,0.7005,0.9199,0.6982,0.9189,0.7025,0.9144,0.7037,0.9159,0.7029,0.9189,0.7021,0.9082,0.6402,0.9109,0.643,0.9057,0.6444,0.903,0.6416,0.9065,0.6709,0.9093,0.6742,0.9145,0.6728,0.9117,0.6694,0.9175,0.6629,0.9178,0.6659,0.9156,0.6665,0.9152,0.6635,0.9115,0.6574,0.9106,0.6501,0.9024,0.6523,0.9033,0.6597,0.9004,0.6536,0.9032,0.6563,0.904,0.6633,0.9013,0.6605,0.9142,0.6569,0.917,0.6597,0.9161,0.6528,0.9134,0.65,0.9017,0.6467,0.9099,0.6444,0.9091,0.6409,0.9016,0.643,0.9114,0.6447,0.9142,0.6475,0.9137,0.644,0.911,0.6412,0.9125,0.6506,0.9102,0.6513};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_84()
		{
			double[] value = {0.91,0.6497,0.9123,0.6491,0.9037,0.6504,0.901,0.6475,0.9006,0.6441,0.9033,0.6469,0.9121,0.6626,0.9039,0.6649,0.9047,0.669,0.9123,0.6669,0.9032,0.6655,0.9059,0.6683,0.9064,0.6725,0.9037,0.6695,0.9132,0.671,0.9154,0.6704,0.9156,0.672,0.9133,0.6727,0.9163,0.6655,0.9136,0.6626,0.9141,0.6666,0.9169,0.6697,0.9147,0.6464,0.9151,0.6493,0.9141,0.65,0.9139,0.648,0.913,0.6514,0.9085,0.6526,0.9097,0.6522,0.9127,0.6514,0.9061,0.6518,0.9057,0.6488,0.9078,0.6496,0.908,0.6516,0.9078,0.6468,0.9123,0.6455,0.9122,0.6474,0.9092,0.6483,0.9097,0.6553,0.9141,0.6541,0.9159,0.6588,0.913,0.6596,0.9167,0.6565,0.9174,0.6624,0.9181,0.6643,0.9177,0.6603,0.9156,0.6661,0.9112,0.6673,0.9139,0.6674,0.9169,0.6666,0.9085,0.6649,0.9078,0.659,0.9117,0.662,0.9122,0.6659,0.9088,0.6734,0.9083,0.67,0.9108,0.6709,0.911,0.6732,0.9105,0.668,0.915,0.6667,0.9153,0.6687,0.9122,0.6695,0.9173,0.6675,0.9177,0.671,0.9171,0.6715,0.9169,0.6692,0.9158,0.6735,0.9113,0.6747,0.9127,0.6739,0.9158,0.6731,0.8962,0.6208,0.8981,0.6248,0.9008,0.6337,0.899,0.6298,0.9127,0.6254,0.9145,0.6293,0.9118,0.6203,0.9099,0.6163,0.9132,0.6461,0.9149,0.6456,0.9153,0.647,0.9135,0.6475,0.9038,0.6332,0.9056,0.6371,0.9125,0.6349,0.9106,0.631,0.9051,0.6129,0.907,0.617,0.9002,0.6192,0.8983,0.6151,0.9025,0.6366,0.9001,0.6289,0.9021,0.6324,0.9039,0.6382,0.9022,0.6239,0.9089,0.6217,0.9105,0.6266,0.9045,0.6286,0.9135,0.6245,0.9158,0.6322};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_85()
		{
			double[] value = {0.9163,0.6341,0.9146,0.6287,0.9136,0.6373,0.9071,0.6395,0.9081,0.6405,0.9141,0.6386,0.9055,0.6399,0.9044,0.636,0.9067,0.6391,0.9075,0.6421,0.9066,0.6327,0.9117,0.631,0.9125,0.635,0.9085,0.6363,0.9153,0.6325,0.9164,0.6366,0.9164,0.6394,0.9155,0.6362,0.9144,0.6401,0.9092,0.6418,0.9104,0.6435,0.9145,0.6422,0.9091,0.6444,0.9086,0.6421,0.9107,0.6445,0.9111,0.6463,0.9102,0.6398,0.9135,0.6388,0.9142,0.6422,0.9118,0.643,0.9159,0.6396,0.9165,0.6421,0.9163,0.6447,0.9158,0.6429,0.9149,0.6444,0.9116,0.6454,0.9128,0.647,0.9151,0.6463,0.9089,0.6169,0.9048,0.614,0.899,0.6158,0.8972,0.6207,0.8996,0.6285,0.9037,0.6314,0.9096,0.6295,0.9113,0.6247,0.8962,0.6217,0.8962,0.6167,0.8962,0.6195,0.8962,0.6246,0.872,0.6224,0.8754,0.6226,0.8754,0.6248,0.872,0.6246,0.8759,0.6216,0.8759,0.6163,0.8715,0.616,0.8715,0.6213,0.8715,0.6156,0.8715,0.6103,0.8759,0.6107,0.8759,0.6159,0.8803,0.6165,0.8803,0.6113,0.8849,0.6122,0.8849,0.6174,0.8808,0.6255,0.8808,0.6232,0.8844,0.6238,0.8844,0.6261,0.8803,0.6169,0.8803,0.6222,0.8849,0.623,0.8849,0.6179,0.8894,0.6185,0.8894,0.6134,0.8939,0.6147,0.8939,0.6197,0.8898,0.6287,0.8898,0.6265,0.8934,0.6273,0.8934,0.6296,0.8894,0.619,0.8894,0.6241,0.8939,0.6253,0.8939,0.6203,0.8895,0.6224,0.8938,0.6235,0.8935,0.6253,0.8897,0.6244,0.8873,0.6259,0.8873,0.6232,0.8878,0.6251,0.8878,0.6275,0.8938,0.6288,0.8895,0.6277,0.8897,0.6291,0.8935,0.6301,0.896,0.6254,0.896,0.628};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_86()
		{
			double[] value = {0.8955,0.6294,0.8955,0.627,0.8805,0.6202,0.8847,0.621,0.8845,0.6222,0.8807,0.6215,0.8783,0.6239,0.8783,0.6212,0.8788,0.6224,0.8788,0.6248,0.8847,0.6263,0.8805,0.6256,0.8807,0.6262,0.8845,0.6269,0.8869,0.6227,0.8869,0.6254,0.8864,0.6261,0.8864,0.6237,0.8779,0.6212,0.8779,0.6238,0.8774,0.6246,0.8774,0.6222,0.8716,0.6193,0.8758,0.6196,0.8756,0.6209,0.8718,0.6207,0.87,0.6217,0.87,0.6241,0.8758,0.625,0.8716,0.6247,0.8718,0.6254,0.8756,0.6256,0.8939,0.6139,0.8939,0.6167,0.8871,0.6225,0.8871,0.6191,0.8871,0.6126,0.8871,0.614,0.8849,0.6115,0.8871,0.6174,0.8871,0.6143,0.8849,0.6143,0.8715,0.6096,0.8715,0.6124,0.8781,0.6125,0.8781,0.6156,0.8803,0.6135,0.8781,0.6208,0.8781,0.6174,0.8803,0.6106,0.8781,0.6121,0.8781,0.6108,0.8894,0.6126,0.8894,0.6155,0.8871,0.622,0.8871,0.6247,0.8759,0.6128,0.8759,0.61,0.8781,0.6229,0.8781,0.6202,0.9258,0.7187,0.9275,0.7259,0.9217,0.7271,0.9199,0.72,0.9207,0.7334,0.9224,0.7403,0.9283,0.739,0.9265,0.7321,0.9204,0.7092,0.9203,0.7079,0.9179,0.7085,0.9179,0.7097,0.9298,0.7314,0.9299,0.7347,0.9207,0.7366,0.9204,0.7333,0.9158,0.7258,0.9176,0.733,0.9177,0.7361,0.916,0.7289,0.9306,0.7258,0.9324,0.7329,0.9322,0.7298,0.9305,0.7226,0.9296,0.7288,0.9203,0.7308,0.9206,0.7291,0.9292,0.7273,0.9289,0.7204,0.9306,0.7276,0.9305,0.726,0.9288,0.7188,0.9201,0.7152,0.9227,0.7147,0.9227,0.714,0.9201,0.7145,0.9189,0.7301,0.9172,0.723,0.9171,0.7214,0.9188,0.7285};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_87()
		{
			double[] value = {0.9208,0.739,0.9301,0.737,0.9298,0.7389,0.9212,0.7408,0.9176,0.731,0.9193,0.7382,0.9194,0.74,0.9177,0.7329,0.9228,0.7216,0.9202,0.7222,0.9202,0.7229,0.9228,0.7223,0.931,0.7357,0.9293,0.7285,0.9294,0.7304,0.9311,0.7375,0.927,0.7163,0.927,0.7149,0.925,0.7141,0.9251,0.715,0.9195,0.7185,0.9246,0.7175,0.9233,0.7158,0.9199,0.7166,0.9169,0.7171,0.9169,0.7184,0.9182,0.7165,0.9181,0.7156,0.9244,0.7148,0.9193,0.7159,0.9198,0.7148,0.9233,0.714,0.924,0.7159,0.919,0.717,0.9184,0.7115,0.9217,0.7108,0.9267,0.7194,0.9266,0.7167,0.9234,0.7113,0.9235,0.7131,0.9192,0.7221,0.9243,0.721,0.9219,0.7144,0.9186,0.7151,0.9165,0.7189,0.9167,0.7215,0.9169,0.7145,0.9168,0.7128,0.9173,0.7264,0.9174,0.728,0.9184,0.7249,0.9184,0.7239,0.9248,0.7238,0.9197,0.7248,0.92,0.7228,0.9234,0.722,0.9275,0.7258,0.9274,0.7242,0.9253,0.7224,0.9253,0.7234,0.9199,0.7281,0.925,0.7271,0.9235,0.7241,0.9201,0.7248,0.9249,0.7044,0.9266,0.7115,0.9207,0.7128,0.919,0.7057,0.9197,0.7191,0.9214,0.726,0.9273,0.7247,0.9256,0.7178,0.9195,0.6949,0.9194,0.6936,0.9169,0.6941,0.917,0.6954,0.9288,0.717,0.929,0.7203,0.9197,0.7223,0.9195,0.7191,0.9149,0.7115,0.9166,0.7186,0.9168,0.7218,0.9151,0.7146,0.9297,0.7115,0.9314,0.7186,0.9313,0.7155,0.9295,0.7084,0.9287,0.7145,0.9194,0.7165,0.9196,0.7148,0.9283,0.7129,0.928,0.7061,0.9297,0.7133,0.9296,0.7117,0.9279,0.7045,0.9192,0.7009,0.9218,0.7003,0.9218,0.6997,0.9191,0.7002};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_88()
		{
			double[] value = {0.9179,0.7158,0.9162,0.7086,0.9161,0.7071,0.9178,0.7142,0.9198,0.7247,0.9291,0.7226,0.9289,0.7246,0.9203,0.7264,0.9166,0.7167,0.9183,0.7239,0.9184,0.7256,0.9167,0.7186,0.9219,0.7073,0.9192,0.7079,0.9193,0.7086,0.9219,0.708,0.9301,0.7213,0.9284,0.7142,0.9285,0.7161,0.9302,0.7232,0.9261,0.702,0.926,0.7006,0.9241,0.6998,0.9241,0.7007,0.9185,0.7042,0.9236,0.7032,0.9224,0.7015,0.919,0.7022,0.9159,0.7028,0.9159,0.7041,0.9172,0.7022,0.9172,0.7013,0.9234,0.7005,0.9184,0.7016,0.9189,0.7005,0.9223,0.6997,0.923,0.7016,0.918,0.7027,0.9174,0.6973,0.9208,0.6965,0.9258,0.7051,0.9257,0.7024,0.9225,0.697,0.9226,0.6988,0.9182,0.7078,0.9233,0.7067,0.921,0.7,0.9176,0.7007,0.9156,0.7046,0.9157,0.7072,0.9159,0.7002,0.9158,0.6985,0.9163,0.7121,0.9164,0.7137,0.9175,0.7106,0.9174,0.7095,0.9238,0.7094,0.9188,0.7105,0.919,0.7085,0.9225,0.7077,0.9266,0.7115,0.9265,0.7099,0.9243,0.708,0.9244,0.7091,0.919,0.7138,0.9241,0.7127,0.9226,0.7098,0.9192,0.7105,0.9078,0.6599,0.9087,0.6681,0.9092,0.6762,0.9083,0.668,0.9234,0.6668,0.9243,0.675,0.9239,0.6669,0.923,0.6588,0.9142,0.6454,0.9123,0.6456,0.9124,0.6482,0.9144,0.648,0.9122,0.6717,0.9132,0.6799,0.9208,0.6794,0.9198,0.6711,0.919,0.6551,0.9199,0.6631,0.9123,0.6637,0.9114,0.6557,0.9073,0.6543,0.9078,0.6622,0.9081,0.6585,0.9075,0.6507,0.9182,0.6495,0.9108,0.6501,0.9107,0.6468,0.9174,0.6463,0.9226,0.661,0.9221,0.6531,0.9212,0.6501,0.9218,0.6575};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_89()
		{
			double[] value = {0.9119,0.6659,0.9191,0.6654,0.9187,0.6622,0.912,0.6627,0.908,0.6489,0.9086,0.6552,0.9093,0.653,0.9088,0.6476,0.9165,0.6444,0.9108,0.6448,0.9112,0.6439,0.9157,0.6436,0.9207,0.6546,0.9201,0.6481,0.9187,0.6468,0.9191,0.6524,0.9121,0.6595,0.9178,0.6591,0.9167,0.6562,0.9122,0.6565,0.9095,0.6468,0.9098,0.651,0.9108,0.6493,0.9105,0.646,0.9151,0.6433,0.9115,0.6436,0.9119,0.6438,0.9145,0.6436,0.9179,0.6506,0.9176,0.646,0.9162,0.6455,0.9164,0.6489,0.9122,0.654,0.9159,0.6538,0.915,0.6511,0.9124,0.6513,0.9195,0.6651,0.9229,0.6684,0.9233,0.6754,0.9202,0.6791,0.9138,0.6796,0.9103,0.6764,0.9099,0.6694,0.913,0.6656,0.8894,0.6794,0.8894,0.6769,0.8939,0.6774,0.8939,0.6799,0.8849,0.6765,0.8849,0.679,0.8803,0.6786,0.8803,0.6761,0.8871,0.6772,0.8871,0.6786,0.8759,0.6758,0.8759,0.6783,0.8715,0.6782,0.8715,0.6757,0.8781,0.6779,0.8781,0.6764,0.8871,0.668,0.8871,0.6658,0.8873,0.6649,0.8781,0.6653,0.8781,0.6672,0.8779,0.6645,0.8781,0.6703,0.8781,0.6676,0.8779,0.6669,0.8871,0.6682,0.8873,0.6673,0.8871,0.671,0.8869,0.6675,0.8783,0.6669,0.8894,0.6721,0.8871,0.6766,0.8894,0.6777,0.8781,0.6758,0.8759,0.6766,0.8759,0.671,0.8894,0.6671,0.8759,0.6661,0.8871,0.6735,0.8894,0.6727,0.8869,0.6652,0.8783,0.6646,0.8781,0.6728,0.8759,0.6716,0.8758,0.668,0.8803,0.6713,0.8805,0.6683,0.8849,0.6717,0.8847,0.6686,0.8895,0.6687,0.8895,0.6639,0.8849,0.6667,0.8847,0.6638,0.8803,0.6663,0.8805,0.6635,0.8758,0.6632};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_90()
		{
			double[] value = {0.8803,0.6719,0.8803,0.6769,0.8715,0.6765,0.8715,0.6709,0.8715,0.6659,0.8715,0.6714,0.8716,0.6631,0.8716,0.6679,0.8849,0.6772,0.8849,0.6723,0.8939,0.6782,0.8939,0.6732,0.8962,0.6747,0.8962,0.6772,0.8939,0.6676,0.8938,0.6644,0.8962,0.6691,0.8938,0.6691,0.8939,0.6726,0.896,0.6658,0.896,0.6682,0.8962,0.6716,0.8955,0.6645,0.8935,0.6633,0.8897,0.6629,0.8878,0.6637,0.8898,0.6633,0.8934,0.6637,0.8878,0.6659,0.8897,0.6671,0.8898,0.6653,0.8935,0.6674,0.8955,0.6666,0.8934,0.6657,0.8864,0.6645,0.8845,0.6633,0.8807,0.663,0.8788,0.6639,0.8808,0.6638,0.8844,0.664,0.8788,0.6661,0.8807,0.6672,0.8808,0.6658,0.8845,0.6675,0.8864,0.6666,0.8844,0.666,0.8756,0.667,0.8774,0.666,0.8774,0.6639,0.8756,0.6628,0.8754,0.6635,0.8754,0.6655,0.8718,0.6627,0.87,0.6637,0.872,0.6634,0.87,0.6658,0.8718,0.6669,0.872,0.6654,0.1047,0.6669,0.1152,0.6757,0.1054,0.6683,0.1497,0.5269,0.1535,0.5313,0.1567,0.5283,0.1548,0.5247,0.1408,0.5116,0.1428,0.5139,0.1469,0.5123,0.1454,0.5104,0.145,0.5184,0.1473,0.5228,0.1537,0.5191,0.1506,0.5167,0.137,0.6855,0.1421,0.6862,0.1433,0.6844,0.1379,0.6837,0.1487,0.685,0.1472,0.6867,0.1549,0.6872,0.1543,0.6858,0.1394,0.6806,0.1454,0.6815,0.1458,0.6802,0.1397,0.6794,0.152,0.6808,0.1627,0.6776,0.1601,0.6773,0.1387,0.68,0.1444,0.6807,0.1431,0.6811,0.1378,0.6806,0.1483,0.6812,0.1501,0.6809,0.1576,0.6778,0.1551,0.6784,0.1369,0.6812,0.1417,0.6817,0.1387,0.6853,0.1348,0.6841};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_91()
		{
			double[] value = {0.1428,0.6859,0.1465,0.6816,0.1526,0.6792,0.148,0.6844,0.1314,0.6891,0.134,0.6919,0.1316,0.6949,0.1297,0.6913,0.1341,0.6977,0.1371,0.694,0.1415,0.6941,0.138,0.6985,0.1297,0.6907,0.1314,0.6942,0.1327,0.6914,0.1316,0.6891,0.1351,0.694,0.1338,0.6969,0.1375,0.6977,0.1391,0.6929,0.1421,0.6723,0.1428,0.6725,0.1426,0.6725,0.1426,0.6716,0.1417,0.6714,0.1417,0.6684,0.1425,0.6697,0.1416,0.6707,0.1415,0.6714,0.1421,0.6717,0.1436,0.672,0.1437,0.6714,0.1434,0.6721,0.1408,0.6671,0.141,0.6704,0.1412,0.6696,0.1406,0.6672,0.1431,0.6704,0.1424,0.6703,0.1428,0.6712,0.1436,0.6703,0.1435,0.6711,0.1435,0.6691,0.1441,0.669,0.1439,0.6699,0.1369,0.6618,0.1375,0.6641,0.1453,0.6635,0.1402,0.6614,0.1409,0.6613,0.138,0.6528,0.1328,0.6564,0.1585,0.6458,0.1609,0.6339,0.1559,0.6394,0.1612,0.6472,0.1597,0.651,0.1601,0.6518,0.1646,0.6429,0.1685,0.6117,0.1683,0.6219,0.1761,0.6088,0.1571,0.6273,0.1584,0.6157,0.1496,0.6224,0.1493,0.6302,0.1704,0.5403,0.1727,0.5384,0.1718,0.5361,0.1622,0.5326,0.1622,0.5262,0.1673,0.5252,0.1658,0.5221,0.161,0.5232,0.1714,0.52,0.1739,0.5226,0.1802,0.522,0.1755,0.5204,0.1604,0.5209,0.1658,0.5204,0.1616,0.5196,0.1761,0.6611,0.1733,0.6696,0.1857,0.6593,0.1805,0.658,0.1667,0.6713,0.1727,0.6634,0.1693,0.6657,0.1633,0.6728,0.173,0.6572,0.1755,0.6541,0.1774,0.6453,0.1763,0.6459,0.1794,0.6418,0.1779,0.6511,0.1819,0.6476,0.1845,0.6374,0.1808,0.6358,0.133,0.679,0.1326,0.6797};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_92()
		{
			double[] value = {0.1279,0.6768,0.1287,0.6767,0.1281,0.6782,0.1321,0.6804,0.131,0.6824,0.1283,0.6802,0.1721,0.687,0.184,0.6859,0.1846,0.6824,0.1686,0.6846,0.1579,0.5166,0.1623,0.5188,0.1612,0.5169,0.1536,0.5132,0.1488,0.511,0.1516,0.5127,0.1481,0.5115,0.1529,0.5137,0.1535,0.5145,0.1484,0.5107,0.146,0.5099,0.1773,0.5275,0.1818,0.5319,0.1892,0.5329,0.188,0.5291,0.1845,0.5262,0.1958,0.5448,0.1929,0.5404,0.1853,0.5398,0.1862,0.5422,0.1883,0.5454,0.2003,0.5418,0.2034,0.5457,0.2036,0.5427,0.1991,0.5358,0.1948,0.5317,0.1962,0.5351,0.1935,0.5302,0.198,0.535,0.1901,0.5275,0.2029,0.547,0.2019,0.5511,0.2106,0.551,0.2065,0.5425,0.2029,0.5433,0.2154,0.5663,0.2027,0.5593,0.2048,0.5637,0.2089,0.5678,0.1952,0.5615,0.1937,0.5572,0.1871,0.5566,0.1869,0.56,0.23,0.6329,0.2289,0.6257,0.2115,0.6336,0.2134,0.641,0.2096,0.6163,0.2105,0.6242,0.2226,0.5988,0.213,0.6035,0.2101,0.6064,0.2089,0.6099,0.2202,0.605,0.179,0.6318,0.1801,0.6308,0.1814,0.6248,0.1811,0.6213,0.1796,0.625,0.2011,0.6272,0.2009,0.619,0.1945,0.62,0.193,0.6271,0.2014,0.6087,0.1944,0.6062,0.1941,0.611,0.1866,0.6706,0.1722,0.6751,0.171,0.6789,0.1861,0.6765,0.2026,0.6527,0.2046,0.6585,0.2144,0.6537,0.21,0.6487,0.2202,0.6606,0.2087,0.665,0.2109,0.6715,0.2238,0.6679,0.2309,0.6381,0.2162,0.6467,0.2188,0.652,0.175,0.5657,0.1822,0.5644,0.181,0.5576,0.183,0.5431,0.1875,0.5444,0.1854,0.5412,0.2088,0.6038,0.2103,0.6065,0.2131,0.6037};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_93()
		{
			double[] value = {0.2128,0.5993,0.2209,0.5933,0.2174,0.5896,0.2097,0.592,0.21,0.5951,0.2129,0.5994,0.2101,0.5952,0.2087,0.5974,0.2016,0.5891,0.2014,0.5859,0.1944,0.5845,0.1943,0.5894,0.1884,0.6134,0.1868,0.6095,0.1826,0.6177,0.183,0.6212,0.1937,0.6069,0.1953,0.6109,0.1956,0.6061,0.1893,0.5852,0.1864,0.578,0.1795,0.5799,0.1818,0.5941,0.1666,0.5914,0.1744,0.595,0.1664,0.582,0.1918,0.5769,0.1944,0.5821,0.1944,0.5769,0.1913,0.5678,0.1875,0.5621,0.1884,0.567,0.1219,0.4738,0.1227,0.4738,0.1288,0.4743,0.1297,0.4749,0.1293,0.4749,0.1236,0.4745,0.1254,0.4772,0.1303,0.4766,0.1365,0.4782,0.1356,0.478,0.1366,0.4797,0.1221,0.4994,0.1261,0.4995,0.1232,0.4949,0.1304,0.5092,0.1293,0.5044,0.1271,0.5067,0.1329,0.5034,0.1355,0.5072,0.1393,0.5067,0.1368,0.5027,0.1305,0.4927,0.1316,0.4981,0.1354,0.4971,0.1346,0.4913,0.1328,0.481,0.128,0.482,0.1297,0.4871,0.1344,0.4853,0.1383,0.4906,0.1392,0.4967,0.1411,0.496,0.1402,0.4898,0.1429,0.5018,0.1408,0.5022,0.1431,0.5066,0.1453,0.5067,0.1659,0.6681,0.1621,0.6733,0.1576,0.6798,0.1794,0.6217,0.1782,0.6213,0.1737,0.6305,0.1742,0.6325,0.178,0.6254,0.1722,0.6309,0.1761,0.6215,0.1718,0.6272,0.1707,0.6321,0.1631,0.6474,0.1587,0.655,0.1592,0.6568,0.1649,0.6459,0.1389,0.6701,0.1377,0.6735,0.1451,0.6718,0.144,0.6689,0.1614,0.6557,0.1628,0.6571,0.1682,0.6464,0.167,0.6449,0.1229,0.66,0.1175,0.6627,0.1194,0.6648,0.1247,0.6626,0.1243,0.6713,0.1239,0.672,0.122,0.6691};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_94()
		{
			double[] value = {0.1206,0.6671,0.1224,0.6693,0.1289,0.6759,0.127,0.674,0.1269,0.6761,0.1333,0.6795,0.1737,0.6523,0.1715,0.6591,0.1706,0.6603,0.1744,0.6497,0.1683,0.6662,0.1675,0.6664,0.1617,0.6765,0.164,0.6731,0.1531,0.6883,0.158,0.6814,0.1554,0.6852,0.1506,0.6914,0.1499,0.6907,0.1545,0.6846,0.1549,0.6814,0.1506,0.6879,0.1609,0.6724,0.1606,0.6758,0.1662,0.6657,0.1653,0.6652,0.1631,0.6612,0.1689,0.6525,0.1685,0.6502,0.1304,0.6713,0.1284,0.6696,0.1238,0.6715,0.1255,0.676,0.1233,0.6724,0.1248,0.6746,0.1254,0.6772,0.125,0.6767,0.1274,0.6665,0.1261,0.6642,0.1207,0.6659,0.1222,0.6682,0.1166,0.6646,0.1146,0.6662,0.1202,0.6706,0.121,0.669,0.1193,0.6665,0.1726,0.6549,0.1736,0.6547,0.1757,0.648,0.1758,0.6449,0.1743,0.6445,0.1722,0.6474,0.1701,0.6538,0.1711,0.6543,0.1735,0.637,0.1735,0.6396,0.1756,0.6366,0.1768,0.6302,0.1774,0.6363,0.1782,0.6298,0.177,0.6364,0.1768,0.6393,0.1498,0.6919,0.1474,0.695,0.1432,0.6974,0.1472,0.6921,0.1426,0.6967,0.1467,0.6943,0.1475,0.6916,0.1445,0.6918,0.137,0.6831,0.1381,0.6854,0.1445,0.6771,0.1377,0.6788,0.127,0.6822,0.1275,0.6825,0.1294,0.6857,0.1286,0.687,0.1308,0.6805,0.1273,0.6816,0.1287,0.6865,0.1307,0.6849,0.1946,0.6485,0.2007,0.6369,0.1917,0.6382,0.1894,0.6472,0.2244,0.6744,0.2111,0.6779,0.2112,0.6816,0.2246,0.6782,0.1816,0.527,0.1739,0.5253,0.1773,0.5247,0.1819,0.5224,0.1862,0.5234,0.1892,0.5239,0.1864,0.5238,0.191,0.5251,0.1909,0.5203,0.1889,0.5245};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_95()
		{
			double[] value = {0.1112,0.6675,0.1092,0.6681,0.1151,0.6734,0.1175,0.6725,0.2053,0.5632,0.2047,0.567,0.2092,0.5674,0.2106,0.5745,0.2065,0.5754,0.2087,0.5792,0.2089,0.5795,0.2091,0.5827,0.2179,0.5731,0.2106,0.5748,0.1325,0.6827,0.1229,0.6795,0.1239,0.6809,0.1318,0.6846,0.1444,0.5336,0.1349,0.5131,0.1393,0.5095,0.1399,0.5257,0.1366,0.5171,0.1515,0.6822,0.1429,0.6693,0.1421,0.6691,0.1421,0.6633,0.1431,0.6647,0.1406,0.6615,0.1416,0.6666,0.1437,0.6646,0.1544,0.5436,0.1644,0.5432,0.1589,0.5358,0.1684,0.5311,0.1531,0.5211,0.1702,0.6698,0.1574,0.6831,0.1652,0.6877,0.1644,0.6863,0.1475,0.6488,0.1522,0.6446,0.1436,0.637,0.1371,0.6405,0.1419,0.6519,0.1645,0.5204,0.1606,0.5183,0.1665,0.5213,0.1605,0.5176,0.1942,0.549,0.1882,0.5484,0.2002,0.6123,0.1939,0.6133,0.1616,0.6814,0.1859,0.6647,0.1699,0.5535,0.1767,0.5499,0.1812,0.5511,0.1811,0.5542,0.2,0.6038,0.2002,0.5933,0.1882,0.6157,0.1896,0.5943,0.1877,0.5951,0.1818,0.6083,0.194,0.602,0.1892,0.5901,0.1943,0.5782,0.1908,0.5669,0.1097,0.4754,0.1382,0.4842,0.14,0.4832,0.1403,0.4917,0.1429,0.5091,0.1599,0.6744,0.1711,0.6238,0.1641,0.6355,0.1655,0.6383,0.1597,0.6451,0.1806,0.6173,0.1766,0.6177,0.1435,0.667,0.1384,0.6682,0.132,0.6453,0.1154,0.6572,0.1335,0.6782,0.1676,0.6656,0.1371,0.6667,0.1442,0.6651,0.1353,0.66,0.1668,0.6589,0.1625,0.6663,0.1545,0.6808,0.1425,0.6841,0.1523,0.6824,0.1489,0.6828,0.1566,0.6756,0.1297,0.6749,0.1864,0.624,0.2037,0.6441};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_96()
		{
			double[] value = {0.2367,0.6642,0.2376,0.6708,0.1703,0.5214,0.1878,0.5257,0.1086,0.6608,0.1051,0.6622,0.1983,0.5777,0.1953,0.5666,0.2012,0.5827,0.139,0.6869,0.1132,0.6745,0.105,0.6686,0.1067,0.6688,0.1134,0.674,0.1257,0.679,0.1145,0.4771,0.1198,0.4885,0.1613,0.6499,0.1458,0.6626,0.0996,0.6618,0.0964,0.6603,0.0805,0.5876,0.0689,0.5803,0.0734,0.5914,0.1888,0.6866,0.2068,0.6838,0.1313,0.6854,0.1234,0.6814,0.1447,0.5511,0.1525,0.56,0.1596,0.5558,0.1359,0.5396,0.1316,0.5323,0.1298,0.5245,0.1162,0.5019,0.1146,0.4919,0.1094,0.4954,0.099,0.49,0.1055,0.4836,0.096,0.4883,0.1016,0.4819,0.099,0.4822,0.0948,0.4885,0.1535,0.5147,0.1503,0.5113,0.1472,0.5078,0.1399,0.482,0.1288,0.4756,0.1352,0.4772,0.0969,0.6585,0.0967,0.6596,0.0676,0.6199,0.0755,0.633,0.0759,0.6343,0.0686,0.6208,0.0618,0.6064,0.0627,0.6078,0.05,0.5901,0.0557,0.5984,0.0563,0.5991,0.0501,0.5901,0.0356,0.5707,0.0427,0.5804,0.0431,0.5802,0.0363,0.5704,0.0237,0.5506,0.0277,0.5601,0.0298,0.561,0.025,0.5527,0.0217,0.5458,0.0231,0.5474,0.0928,0.6474,0.0879,0.6396,0.0816,0.6372,0.0861,0.6451,0.0736,0.6263,0.0711,0.6184,0.0696,0.6218,0.075,0.6331,0.0846,0.6311,0.08,0.6287,0.0806,0.6331,0.086,0.6355,0.0575,0.5994,0.0611,0.598,0.051,0.5896,0.0475,0.5774,0.0552,0.5875,0.0577,0.5822,0.0515,0.5747,0.0357,0.56,0.0393,0.5579,0.0359,0.5524,0.0323,0.5538,0.0311,0.5498,0.0331,0.549,0.0598,0.5698,0.0652,0.576,0.0835,0.5656,0.0727,0.5573};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_97()
		{
			double[] value = {0.0416,0.5497,0.0459,0.5539,0.0468,0.5522,0.0419,0.5485,0.066,0.5329,0.0589,0.5251,0.0499,0.5341,0.0558,0.5415,0.092,0.5566,0.0827,0.5488,0.0978,0.5653,0.0882,0.5729,0.1117,0.6222,0.1081,0.6182,0.1002,0.6333,0.1057,0.6425,0.1026,0.5983,0.0971,0.604,0.1032,0.6044,0.0911,0.5906,0.0958,0.5861,0.0948,0.6261,0.0973,0.6298,0.1351,0.5578,0.1303,0.5612,0.134,0.5758,0.1364,0.5741,0.1283,0.5459,0.1245,0.549,0.108,0.558,0.1202,0.5377,0.111,0.5345,0.1008,0.5474,0.0928,0.5399,0.1009,0.5283,0.0689,0.5168,0.0767,0.5245,0.0845,0.5173,0.0781,0.5125,0.0713,0.5109,0.0635,0.5145,0.0842,0.5802,0.085,0.5882,0.0895,0.5829,0.0434,0.5458,0.0412,0.541,0.0393,0.5449,0.0809,0.6098,0.0807,0.6094,0.0796,0.6114,0.0802,0.611,0.1604,0.5689,0.0671,0.6078,0.0636,0.6091,0.0983,0.6127,0.1031,0.6155,0.0848,0.5971,0.0806,0.599,0.0791,0.6037,0.0791,0.624,0.0819,0.6253,0.0909,0.6221,0.0953,0.612,0.0943,0.6052,0.0894,0.598,0.0713,0.6059,0.0787,0.6083,0.0737,0.6146,0.0765,0.613,0.127,0.6066,0.1243,0.6329,0.1346,0.6233,0.1178,0.6057,0.1094,0.6049,0.1157,0.5897,0.1083,0.5928,0.109,0.5759,0.1008,0.582,0.1377,0.5904,0.102,0.57,0.0944,0.5777,0.0788,0.6145,0.0792,0.6137,0.0846,0.6025,0.0809,0.6063,0.0829,0.6074,0.0853,0.6043,0.0884,0.6036,0.0886,0.6056,0.0914,0.6075,0.0915,0.6092,0.0918,0.6114,0.0924,0.6113,0.0872,0.6154,0.088,0.6168,0.0811,0.6182,0.0813,0.6165,0.0797,0.616,0.0794,0.6174,0.0808,0.6057};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_98()
		{
			double[] value = {0.0815,0.6078,0.08,0.6077,0.0818,0.6086,0.0887,0.6159,0.081,0.6112,0.0817,0.6101,0.0827,0.609,0.0836,0.608,0.0858,0.6049,0.0892,0.6062,0.0923,0.6098,0.0926,0.6116,0.0831,0.6166,0.0813,0.6162,0.0806,0.6138,0.0767,0.6222,0.0765,0.6181,0.075,0.6202,0.0763,0.6259,0.0658,0.5954,0.06,0.5849,0.0265,0.5495,0.0294,0.5545,0.0297,0.5502,0.0405,0.5498,0.0383,0.5462,0.0416,0.5568,0.0369,0.5285,0.0377,0.5312,0.0457,0.5192,0.0467,0.5192,0.0342,0.5346,0.0365,0.5389,0.0364,0.5409,0.0386,0.5355,0.0415,0.5493,0.0396,0.5466,0.0476,0.5208,0.0383,0.5292,0.0589,0.5128,0.0646,0.5094,0.0541,0.5135,0.0518,0.5141,0.0466,0.5243,0.0506,0.5168,0.0509,0.5186,0.124,0.5359,0.1237,0.5854,0.1182,0.5708,0.1106,0.5633,0.1435,0.5025,0.1222,0.5086,0.1264,0.5164,0.055,0.521,0.0479,0.5289,0.052,0.5177,0.048,0.5158,0.1207,0.4748,0.1059,0.4759,0.1446,0.6136,0.0439,0.5644,0.0403,0.5672,0.0515,0.5591,0.0622,0.5488,0.0733,0.5406,0.0909,0.5221,0.0848,0.5323,0.076,0.6302,0.0443,0.5796,0.0378,0.5696,0.0329,0.5614,0.0222,0.543,0.0215,0.5419,0.0247,0.5449,0.0295,0.5451,0.0301,0.545,0.0359,0.5422,0.0375,0.5438,0.0801,0.6422,0.0762,0.6343,0.085,0.6477,0.0849,0.6494,0.0852,0.646,0.0914,0.6522,0.0987,0.6544,0.112,0.6511,0.1608,0.5972,0.1567,0.6884,0.1637,0.6889,0.1538,0.5752,0.1496,0.688,0.1159,0.6257,0.1054,0.6079,0.1035,0.6049,0.0994,0.6035,0.094,0.6073,0.0935,0.6085,0.093,0.6104,0.0925,0.6121,0.0922,0.6155};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_99()
		{
			double[] value = {0.0935,0.6185,0.0962,0.6201,0.1012,0.618,0.1048,0.6108,0.1321,0.5427,0.1278,0.5341,0.1399,0.5545,0.1468,0.5648,0.2247,0.6811,0.1708,0.6893,0.1054,0.6683,0.1548,0.5247,0.1567,0.5283,0.1535,0.5313,0.1497,0.5269,0.1454,0.5104,0.1469,0.5123,0.1428,0.5139,0.1408,0.5116,0.1506,0.5167,0.1537,0.5191,0.1473,0.5228,0.145,0.5184,0.1379,0.6837,0.1433,0.6844,0.1421,0.6862,0.137,0.6855,0.1543,0.6858,0.1549,0.6872,0.1472,0.6867,0.1487,0.685,0.1397,0.6794,0.1458,0.6802,0.1454,0.6815,0.1394,0.6806,0.1601,0.6773,0.1627,0.6776,0.152,0.6808,0.1378,0.6806,0.1431,0.6811,0.1444,0.6807,0.1387,0.68,0.1551,0.6784,0.1576,0.6778,0.1501,0.6809,0.1483,0.6812,0.1348,0.6841,0.1387,0.6853,0.1417,0.6817,0.1369,0.6812,0.1481,0.6844,0.1526,0.6792,0.1465,0.6816,0.1428,0.6859,0.1297,0.6913,0.1316,0.6949,0.134,0.6919,0.1314,0.6891,0.138,0.6985,0.1415,0.6941,0.1371,0.694,0.1341,0.6977,0.1316,0.6891,0.1327,0.6914,0.1314,0.6942,0.1297,0.6907,0.1391,0.6929,0.1376,0.6977,0.1338,0.6969,0.1351,0.694,0.1427,0.6725,0.1428,0.6725,0.1421,0.6723,0.1425,0.6697,0.1418,0.6684,0.1417,0.6714,0.1426,0.6716,0.1421,0.6717,0.1415,0.6714,0.1416,0.6707,0.1434,0.6721,0.1437,0.6714,0.1436,0.672,0.1406,0.6672,0.1412,0.6696,0.141,0.6704,0.1408,0.6671,0.1428,0.6712,0.1424,0.6703,0.1431,0.6704,0.144,0.6699,0.1441,0.669,0.1435,0.6691,0.1435,0.6711,0.1436,0.6703,0.1453,0.6635,0.1375,0.6641,0.1369,0.6618,0.1328,0.6564,0.138,0.6528};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_100()
		{
			double[] value = {0.1409,0.6613,0.1402,0.6614,0.1559,0.6394,0.1609,0.6339,0.1585,0.6458,0.1646,0.6429,0.1601,0.6518,0.1598,0.651,0.1612,0.6472,0.1761,0.6088,0.1683,0.6219,0.1685,0.6117,0.1493,0.6302,0.1496,0.6224,0.1584,0.6157,0.1571,0.6273,0.1622,0.5326,0.1718,0.5361,0.1727,0.5384,0.1704,0.5403,0.161,0.5232,0.1658,0.5221,0.1673,0.5252,0.1622,0.5262,0.1755,0.5204,0.1802,0.522,0.1739,0.5226,0.1714,0.52,0.1616,0.5196,0.1658,0.5204,0.1604,0.5209,0.1805,0.658,0.1857,0.6593,0.1733,0.6696,0.1761,0.6611,0.1633,0.6728,0.1693,0.6657,0.1727,0.6634,0.1667,0.6713,0.1763,0.6459,0.1774,0.6453,0.1755,0.6541,0.173,0.6572,0.1808,0.6358,0.1845,0.6374,0.1819,0.6476,0.1779,0.6511,0.1794,0.6418,0.1287,0.6767,0.1279,0.6768,0.1326,0.6797,0.133,0.679,0.1283,0.6802,0.1311,0.6824,0.1321,0.6804,0.1281,0.6782,0.1686,0.6846,0.1846,0.6824,0.184,0.6859,0.1721,0.687,0.1612,0.5169,0.1623,0.5188,0.1579,0.5166,0.1516,0.5127,0.1488,0.511,0.1536,0.5132,0.146,0.5099,0.1484,0.5107,0.1535,0.5145,0.1529,0.5137,0.1481,0.5115,0.1845,0.5262,0.188,0.5291,0.1892,0.5329,0.1818,0.5319,0.1773,0.5275,0.1883,0.5454,0.1862,0.5422,0.1853,0.5398,0.1929,0.5404,0.1958,0.5448,0.2036,0.5427,0.2034,0.5457,0.2003,0.5418,0.1962,0.5351,0.1948,0.5317,0.1991,0.5358,0.1901,0.5275,0.193,0.5279,0.1965,0.5267,0.2009,0.5334,0.198,0.535,0.1935,0.5302,0.2029,0.5433,0.2019,0.5511,0.2029,0.547,0.2089,0.5678,0.2048,0.5637,0.2027,0.5593,0.213,0.5589};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_101()
		{
			double[] value = {0.2154,0.5663,0.1869,0.56,0.1871,0.5566,0.1937,0.5572,0.1953,0.5615,0.2134,0.641,0.2115,0.6336,0.2105,0.6242,0.2096,0.6163,0.2209,0.6112,0.226,0.6159,0.2202,0.605,0.209,0.6099,0.2101,0.6064,0.213,0.6035,0.2226,0.5988,0.1796,0.625,0.1811,0.6213,0.1814,0.6248,0.1801,0.6308,0.179,0.6318,0.193,0.6271,0.1945,0.62,0.2009,0.619,0.2011,0.6272,0.1941,0.611,0.1944,0.6062,0.2014,0.6087,0.1861,0.6765,0.171,0.6789,0.1722,0.6751,0.1866,0.6706,0.21,0.6487,0.2144,0.6537,0.2046,0.6585,0.2026,0.6527,0.2238,0.6679,0.2109,0.6715,0.2087,0.665,0.2202,0.6606,0.2188,0.652,0.2162,0.6467,0.2309,0.6381,0.2329,0.645,0.181,0.5576,0.1822,0.5644,0.175,0.5657,0.1854,0.5412,0.1875,0.5444,0.1831,0.5431,0.2131,0.6037,0.2103,0.6065,0.2088,0.6038,0.21,0.5951,0.2097,0.592,0.2128,0.5993,0.2087,0.5974,0.2101,0.5952,0.213,0.5994,0.1943,0.5894,0.1944,0.5845,0.2014,0.5859,0.2017,0.5891,0.183,0.6212,0.1826,0.6177,0.1868,0.6095,0.1884,0.6134,0.1956,0.6061,0.1953,0.6109,0.1937,0.6069,0.1818,0.5941,0.1795,0.5799,0.1864,0.578,0.1893,0.5852,0.1664,0.582,0.1744,0.595,0.1666,0.5914,0.1945,0.5769,0.1944,0.5821,0.1918,0.5769,0.1884,0.567,0.1876,0.5621,0.1913,0.5678,0.1297,0.4749,0.1288,0.4743,0.1227,0.4738,0.1219,0.4738,0.1303,0.4766,0.1254,0.4772,0.1236,0.4745,0.1293,0.4749,0.1366,0.4797,0.1356,0.478,0.1365,0.4782,0.1232,0.4949,0.1261,0.4995,0.1221,0.4994,0.1271,0.5067,0.1293,0.5044,0.1304,0.5092};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_102()
		{
			double[] value = {0.1368,0.5027,0.1393,0.5067,0.1355,0.5072,0.1329,0.5034,0.1346,0.4913,0.1354,0.4971,0.1316,0.4981,0.1305,0.4927,0.1344,0.4853,0.1297,0.4871,0.128,0.482,0.1328,0.481,0.1402,0.4898,0.1411,0.496,0.1392,0.4967,0.1383,0.4906,0.1453,0.5067,0.1431,0.5066,0.1408,0.5022,0.1429,0.5018,0.1576,0.6798,0.1621,0.6733,0.1659,0.6681,0.178,0.6254,0.1742,0.6325,0.1737,0.6305,0.1782,0.6213,0.1794,0.6217,0.1707,0.6321,0.1718,0.6272,0.1761,0.6215,0.1722,0.6309,0.1649,0.6459,0.1592,0.6568,0.1587,0.655,0.1631,0.6474,0.144,0.6689,0.1451,0.6718,0.1377,0.6735,0.1389,0.6701,0.167,0.6449,0.1682,0.6464,0.1628,0.6571,0.1614,0.6557,0.1247,0.6626,0.1194,0.6648,0.1175,0.6627,0.1229,0.66,0.1224,0.6693,0.1206,0.6671,0.122,0.6691,0.1239,0.672,0.1243,0.6713,0.1333,0.6795,0.1269,0.6761,0.127,0.674,0.1289,0.6759,0.1744,0.6497,0.1706,0.6603,0.1715,0.6591,0.1737,0.6523,0.164,0.6731,0.1617,0.6765,0.1675,0.6664,0.1683,0.6662,0.1506,0.6914,0.1554,0.6852,0.158,0.6814,0.1531,0.6883,0.1506,0.6879,0.1549,0.6814,0.1545,0.6846,0.1499,0.6907,0.1653,0.6652,0.1662,0.6657,0.1606,0.6758,0.1609,0.6724,0.1685,0.6502,0.1689,0.6525,0.1631,0.6612,0.1255,0.676,0.1238,0.6715,0.1284,0.6696,0.1304,0.6713,0.125,0.6767,0.1254,0.6772,0.1248,0.6746,0.1234,0.6724,0.1222,0.6682,0.1207,0.6659,0.1261,0.6642,0.1274,0.6665,0.1193,0.6665,0.121,0.669,0.1202,0.6706,0.1146,0.6662,0.1166,0.6646,0.1758,0.6449,0.1757,0.648,0.1736,0.6547};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_103()
		{
			double[] value = {0.1726,0.6549,0.1712,0.6543,0.1701,0.6538,0.1722,0.6474,0.1743,0.6445,0.1768,0.6302,0.1756,0.6366,0.1736,0.6396,0.1735,0.637,0.1768,0.6393,0.177,0.6364,0.1782,0.6298,0.1774,0.6363,0.1472,0.6921,0.1432,0.6974,0.1474,0.695,0.1498,0.6919,0.1445,0.6918,0.1475,0.6916,0.1467,0.6943,0.1426,0.6967,0.1377,0.6788,0.1446,0.6771,0.1381,0.6854,0.137,0.6831,0.1286,0.687,0.1294,0.6857,0.1275,0.6825,0.127,0.6822,0.1307,0.6849,0.1287,0.6865,0.1273,0.6816,0.1308,0.6805,0.1894,0.6472,0.1917,0.6382,0.2007,0.6369,0.1946,0.6485,0.2246,0.6782,0.2112,0.6816,0.2111,0.6779,0.2244,0.6744,0.1773,0.5247,0.1864,0.5238,0.1892,0.5239,0.1862,0.5234,0.1819,0.5224,0.1889,0.5245,0.1909,0.5203,0.1175,0.6725,0.1151,0.6734,0.1092,0.6681,0.1112,0.6675,0.2092,0.5674,0.2047,0.567,0.2053,0.5632,0.2087,0.5792,0.2065,0.5754,0.2106,0.5745,0.2106,0.5748,0.2179,0.5731,0.2168,0.5803,0.2091,0.5827,0.2089,0.5795,0.1318,0.6846,0.1239,0.6809,0.1229,0.6795,0.1325,0.6827,0.1444,0.5336,0.1393,0.5095,0.1349,0.5131,0.1399,0.5257,0.1366,0.5171,0.1515,0.6822,0.1421,0.6691,0.1429,0.6693,0.1431,0.6647,0.1421,0.6633,0.1406,0.6615,0.1416,0.6666,0.1437,0.6646,0.1589,0.5358,0.1644,0.5432,0.1544,0.5436,0.1684,0.5311,0.1531,0.5211,0.1702,0.6698,0.1574,0.6831,0.1644,0.6863,0.1652,0.6877,0.1436,0.637,0.1522,0.6446,0.1475,0.6488,0.1419,0.6519,0.1371,0.6405,0.1665,0.5213,0.1606,0.5183,0.1605,0.5176,0.1942,0.549,0.1882,0.5484,0.1939,0.6133};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_104()
		{
			double[] value = {0.2002,0.6123,0.1616,0.6814,0.1859,0.6647,0.2351,0.6556,0.1767,0.5499,0.1699,0.5535,0.1811,0.5542,0.1812,0.5511,0.2,0.6038,0.2002,0.5933,0.1882,0.6157,0.1877,0.5951,0.1896,0.5943,0.1818,0.6083,0.1892,0.5901,0.194,0.602,0.1943,0.5782,0.1908,0.5669,0.1097,0.4754,0.1382,0.4842,0.14,0.4832,0.1429,0.5091,0.1599,0.6744,0.1641,0.6355,0.1711,0.6238,0.1597,0.6451,0.1655,0.6383,0.1806,0.6173,0.1766,0.6177,0.1384,0.6682,0.1435,0.667,0.132,0.6453,0.1154,0.6572,0.1335,0.6782,0.1676,0.6656,0.1371,0.6667,0.1442,0.6651,0.1353,0.66,0.1625,0.6663,0.1669,0.6589,0.1545,0.6808,0.1425,0.6841,0.1489,0.6828,0.1523,0.6824,0.1566,0.6756,0.1297,0.6749,0.1864,0.624,0.2037,0.6441,0.2367,0.6642,0.238,0.6747,0.2376,0.6708,0.1703,0.5214,0.1086,0.6608,0.1051,0.6622,0.1953,0.5666,0.1983,0.5777,0.2012,0.5827,0.105,0.6686,0.1132,0.6745,0.1134,0.674,0.1067,0.6688,0.1257,0.679,0.1146,0.4771,0.1198,0.4885,0.1613,0.6499,0.1458,0.6626,0.0964,0.6603,0.0996,0.6618,0.0734,0.5914,0.0689,0.5803,0.0805,0.5876,0.1596,0.5558,0.1525,0.56,0.1447,0.5511,0.1359,0.5396,0.1298,0.5245,0.1316,0.5323,0.1094,0.4954,0.1146,0.4919,0.1162,0.5019,0.1055,0.4836,0.099,0.49,0.1016,0.4819,0.096,0.4883,0.0967,0.6596,0.0686,0.6208,0.0759,0.6343,0.0627,0.6078,0.0501,0.5901,0.0563,0.5991,0.0363,0.5704,0.0431,0.5802,0.025,0.5527,0.0298,0.561,0.0231,0.5474,0.0861,0.6451,0.0816,0.6372,0.0879,0.6396,0.0928,0.6474,0.075,0.6331};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_105()
		{
			double[] value = {0.0696,0.6218,0.0711,0.6184,0.0736,0.6263,0.086,0.6355,0.0806,0.6331,0.08,0.6287,0.0846,0.6311,0.051,0.5896,0.0611,0.598,0.0575,0.5994,0.0515,0.5747,0.0577,0.5822,0.0552,0.5875,0.0475,0.5774,0.0323,0.5538,0.0359,0.5524,0.0393,0.5579,0.0357,0.56,0.0331,0.549,0.0311,0.5498,0.0727,0.5573,0.0835,0.5656,0.0652,0.576,0.0598,0.5698,0.0419,0.5485,0.0468,0.5522,0.0459,0.5539,0.0416,0.5497,0.0558,0.5415,0.0499,0.5341,0.0589,0.5251,0.066,0.5329,0.0827,0.5488,0.092,0.5566,0.0882,0.5729,0.0978,0.5653,0.1057,0.6425,0.1002,0.6333,0.1081,0.6182,0.1117,0.6222,0.1032,0.6044,0.0971,0.604,0.1026,0.5983,0.0958,0.5861,0.0911,0.5906,0.0973,0.6298,0.0948,0.6261,0.1364,0.5741,0.134,0.5758,0.1303,0.5612,0.1351,0.5578,0.1245,0.549,0.1283,0.5459,0.1008,0.5474,0.111,0.5345,0.1202,0.5377,0.108,0.558,0.1009,0.5283,0.0928,0.5399,0.0781,0.5125,0.0845,0.5173,0.0767,0.5245,0.0689,0.5168,0.0635,0.5145,0.0713,0.5109,0.0842,0.5802,0.0895,0.5829,0.085,0.5882,0.0393,0.5449,0.0412,0.541,0.0434,0.5458,0.0802,0.611,0.0796,0.6114,0.0807,0.6094,0.0809,0.6098,0.1604,0.5689,0.0636,0.6091,0.0671,0.6078,0.1031,0.6155,0.0983,0.6127,0.0806,0.599,0.0848,0.5971,0.0791,0.6037,0.0819,0.6253,0.0791,0.624,0.0909,0.6221,0.0953,0.612,0.0943,0.6052,0.0894,0.598,0.0787,0.6083,0.0713,0.6059,0.0765,0.613,0.0737,0.6146,0.1346,0.6233,0.1243,0.6329,0.127,0.6066,0.1094,0.6049,0.1178,0.6057,0.1083,0.5928,0.1157,0.5897};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_106()
		{
			double[] value = {0.1008,0.582,0.109,0.5759,0.1377,0.5904,0.0944,0.5777,0.102,0.57,0.0792,0.6137,0.0788,0.6145,0.0853,0.6043,0.0829,0.6074,0.0809,0.6063,0.0846,0.6025,0.0886,0.6056,0.0884,0.6036,0.0915,0.6092,0.0914,0.6075,0.0919,0.6114,0.088,0.6168,0.0872,0.6154,0.0924,0.6113,0.0813,0.6165,0.0811,0.6182,0.0794,0.6174,0.0797,0.616,0.0815,0.6078,0.0808,0.6057,0.08,0.6077,0.0818,0.6086,0.0887,0.6159,0.0817,0.6101,0.081,0.6112,0.0827,0.609,0.0836,0.608,0.0858,0.6049,0.0892,0.6062,0.0923,0.6098,0.0926,0.6116,0.0831,0.6166,0.0813,0.6162,0.0806,0.6138,0.0763,0.6259,0.075,0.6202,0.0765,0.6181,0.0767,0.6222,0.06,0.5849,0.0658,0.5954,0.0297,0.5502,0.0294,0.5545,0.0265,0.5495,0.0383,0.5462,0.0405,0.5498,0.0416,0.5568,0.0467,0.5192,0.0457,0.5192,0.0378,0.5312,0.0369,0.5285,0.0365,0.5389,0.0342,0.5346,0.0386,0.5355,0.0364,0.5409,0.0415,0.5493,0.0396,0.5466,0.0518,0.5141,0.0541,0.5135,0.0646,0.5094,0.0589,0.5128,0.0466,0.5243,0.0506,0.5168,0.124,0.5359,0.1182,0.5708,0.1237,0.5854,0.1106,0.5633,0.1222,0.5086,0.1264,0.5164,0.0479,0.5289,0.055,0.521,0.048,0.5158,0.052,0.5177,0.1446,0.6136,0.0403,0.5672,0.0439,0.5644,0.0515,0.5591,0.0622,0.5488,0.0733,0.5406,0.0848,0.5323,0.0909,0.5221,0.076,0.6302,0.0443,0.5796,0.0378,0.5696,0.0329,0.5614,0.0222,0.543,0.0247,0.5449,0.0295,0.5451,0.0301,0.545,0.0359,0.5422,0.0375,0.5438,0.0762,0.6343,0.0801,0.6422,0.0849,0.6494,0.085,0.6477,0.0914,0.6522};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_107()
		{
			double[] value = {0.0987,0.6544,0.112,0.6511,0.1608,0.5972,0.1538,0.5752,0.1159,0.6257,0.1048,0.6108,0.1012,0.618,0.0962,0.6201,0.0935,0.6185,0.0922,0.6155,0.0925,0.6121,0.093,0.6104,0.0935,0.6085,0.094,0.6073,0.0994,0.6035,0.1035,0.6049,0.1054,0.6079,0.1278,0.5341,0.1321,0.5427,0.1399,0.5545,0.1468,0.5648,0.6073,0.7263,0.6049,0.7277,0.6136,0.7257,0.616,0.7272,0.6112,0.8602,0.5971,0.855,0.5954,0.8491,0.5943,0.8387,0.5947,0.836,0.594,0.8343,0.5941,0.8298,0.5943,0.8274,0.5951,0.8256,0.5945,0.8251,0.5945,0.8228,0.5936,0.8067,0.6052,0.7473,0.6055,0.7356,0.6073,0.7354,0.6073,0.7471,0.5934,0.8669,0.5937,0.8684,0.5947,0.8677,0.5941,0.8642,0.6486,0.8798,0.6417,0.8811,0.6403,0.8826,0.5944,0.8629,0.5935,0.8657,0.5966,0.8724,0.5958,0.87,0.594,0.8659,0.6035,0.882,0.6049,0.8797,0.613,0.8862,0.6132,0.8832,0.6279,0.889,0.6262,0.8837,0.5956,0.862,0.5951,0.8636,0.5991,0.8654,0.5937,0.8126,0.5992,0.8095,0.5987,0.8029,0.5933,0.8068,0.5942,0.8184,0.5998,0.8157,0.5966,0.8282,0.6028,0.8272,0.6019,0.8207,0.5961,0.8228,0.5975,0.8354,0.6036,0.8359,0.5971,0.8417,0.6038,0.8431,0.5983,0.854,0.6039,0.8541,0.5971,0.8572,0.6014,0.8601,0.5919,0.8006,0.5967,0.7953,0.5961,0.788,0.5917,0.7952,0.5929,0.8013,0.5955,0.8643,0.5939,0.8686,0.5942,0.8675,0.5968,0.8649,0.597,0.8585,0.5979,0.8663,0.5961,0.8599,0.5989,0.7997,0.5939,0.8038,0.6061,0.7479,0.6068,0.7361,0.6064,0.7282,0.6149,0.7275,0.5965,0.8208,0.6018,0.8182};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_108()
		{
			double[] value = {0.5909,0.8078,0.5901,0.8137,0.5917,0.8102,0.5904,0.8089,0.5963,0.7811,0.593,0.7807,0.5928,0.7933,0.5962,0.7929,0.5925,0.8028,0.5948,0.8039,0.595,0.8081,0.5675,0.954,0.5678,0.9542,0.55,0.9375,0.5491,0.937,0.5721,0.9472,0.5553,0.9365,0.5547,0.9374,0.5702,0.9501,0.5485,0.9212,0.5478,0.9229,0.6122,0.8334,0.6155,0.8477,0.6288,0.8465,0.5439,0.9238,0.5513,0.9376,0.5529,0.9382,0.5455,0.9244,0.6153,0.8577,0.6105,0.8656,0.6155,0.7239,0.6088,0.8123,0.6094,0.8193,0.5417,0.9236,0.5408,0.9215,0.5498,0.9367,0.5492,0.9368,0.6163,0.7257,0.6027,0.7326,0.6053,0.7266,0.6037,0.733,0.5583,0.9367,0.5603,0.9349,0.5525,0.92,0.5504,0.922,0.576,0.9438,0.5415,0.9237,0.5416,0.9238,0.5999,0.7666,0.603,0.7749,0.6005,0.7368,0.5929,0.7737,0.5454,0.9055,0.5408,0.9112,0.5413,0.9128,0.5456,0.9067,0.5466,0.907,0.5415,0.913,0.5412,0.9133,0.5453,0.9075,0.5418,0.9134,0.5454,0.9078,0.5477,0.9079,0.5438,0.9135,0.5455,0.9137,0.5493,0.9082,0.5487,0.9126,0.55,0.9116,0.5539,0.9074,0.5529,0.9077,0.5562,0.9068,0.5517,0.9114,0.5542,0.9098,0.5583,0.9059,0.5945,0.8608,0.595,0.8561,0.5948,0.8545,0.5945,0.8594,0.5931,0.85,0.5932,0.8489,0.5921,0.8389,0.5927,0.843,0.5923,0.8429,0.5912,0.838,0.5917,0.8129,0.5921,0.8178,0.589,0.8066,0.59,0.7751,0.5925,0.7698,0.5932,0.7774,0.5915,0.7812,0.5954,0.7658,0.5943,0.7742,0.5962,0.7719,0.5974,0.7651,0.6012,0.7653,0.5987,0.7723,0.6228,0.86,0.6101,0.8602,0.6385,0.8702};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_109()
		{
			double[] value = {0.5946,0.9127,0.6042,0.9144,0.6034,0.9218,0.5952,0.9154,0.6115,0.9304,0.6047,0.9235,0.6054,0.9329,0.6057,0.9289,0.6158,0.9339,0.6156,0.9379,0.6046,0.9376,0.6054,0.9373,0.6165,0.9427,0.6164,0.9425,0.5602,0.9144,0.5562,0.9176,0.5615,0.9294,0.5674,0.9282,0.565,0.9017,0.5614,0.9042,0.5575,0.907,0.5621,0.9043,0.6084,0.9123,0.5988,0.9119,0.632,0.8759,0.6057,0.8721,0.5903,0.8219,0.59,0.8188,0.5918,0.8226,0.5919,0.8251,0.6024,0.7873,0.6056,0.8067,0.5915,0.8299,0.5916,0.8345,0.5905,0.8327,0.5904,0.8276,0.587,0.7949,0.5869,0.7869,0.5889,0.7932,0.5901,0.8001,0.5962,0.7566,0.5963,0.75,0.593,0.7626,0.5993,0.7607,0.5946,0.7648,0.5905,0.8062,0.5879,0.7982,0.5682,0.9537,0.5683,0.9537,0.567,0.953,0.5676,0.9538,0.6154,0.9438,0.6151,0.9435,0.604,0.9377,0.6044,0.938,0.6043,0.938,0.6045,0.938,0.6159,0.9434,0.6157,0.9435,0.617,0.9409,0.6051,0.9354,0.5546,0.9384,0.5692,0.9527,0.5474,0.9247,0.5522,0.9082,0.5478,0.9137,0.5501,0.9375,0.5421,0.9237,0.568,0.9542,0.6048,0.9379,0.6161,0.9433,0.6053,0.7369,0.598,0.7436,0.5894,0.7881,0.5874,0.7816,0.5885,0.7772,0.5903,0.7848,0.6044,0.7347,0.6002,0.7381,0.5486,0.9086,0.5478,0.9084,0.5481,0.9086,0.5499,0.9088,0.5516,0.9091,0.5541,0.9092,0.5554,0.9086,0.5567,0.9083,0.5587,0.9077,0.5607,0.9069,0.5636,0.9054,0.5669,0.9035,0.5925,0.8005,0.5916,0.7939,0.5932,0.7855,0.5945,0.782,0.5973,0.7758,0.5988,0.7745,0.5904,0.801,0.5909,0.7918,0.5878,0.7901};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_110()
		{
			double[] value = {0.5894,0.78,0.5901,0.7748,0.5921,0.7696,0.5924,0.7687,0.5963,0.7613,0.5997,0.7566,0.6012,0.7562,0.6042,0.756,0.6031,0.7961,0.6023,0.7919,0.5892,0.8106,0.5928,0.7931,0.5932,0.7831,0.5911,0.783,0.593,0.7721,0.5942,0.7667,0.5964,0.761,0.5972,0.7606,0.6008,0.7527,0.6038,0.7479,0.6032,0.8003,0.6032,0.7943,0.6242,0.8604,0.6113,0.8609,0.604,0.8817,0.5966,0.8719,0.5938,0.8657,0.595,0.861,0.5962,0.8564,0.5946,0.8502,0.5938,0.8431,0.5925,0.8378,0.5914,0.833,0.591,0.8276,0.59,0.8178,0.6287,0.8554,0.6038,0.874,0.5955,0.8482,0.5951,0.8415,0.5948,0.8338,0.594,0.8274,0.5921,0.8241,0.5916,0.8178,0.5892,0.7986,0.5897,0.8064,0.6279,0.8891,0.5949,0.9277,0.5916,0.9326,0.5926,0.9421,0.5993,0.9461,0.6004,0.9492,0.5995,0.9525,0.5983,0.9561,0.5987,0.9575,0.598,0.958,0.5981,0.9581,0.5978,0.9583,0.5975,0.9583,0.5975,0.9581,0.597,0.9577,0.5481,0.9068,0.5486,0.908,0.5916,0.8054,0.6031,0.7836,0.5926,0.7825,0.5928,0.7724,0.5928,0.7724,0.5945,0.7614,0.5962,0.7555,0.598,0.7492,0.5998,0.7486,0.6022,0.7415,0.6044,0.7365,0.6053,0.7921,0.5912,0.8119,0.5904,0.8249,0.5907,0.8232,0.5916,0.8274,0.6247,0.8633,0.6209,0.8701,0.6097,0.8665,0.6167,0.8748,0.6079,0.8716,0.572,0.9145,0.5835,0.9176,0.58,0.9178,0.5692,0.9152,0.5807,0.92,0.5694,0.9167,0.5902,0.9309,0.5748,0.924,0.578,0.9306,0.5902,0.9362,0.5896,0.9384,0.5771,0.9332,0.5891,0.9405,0.5766,0.936,0.5762,0.9376,0.5889,0.9424,0.5884,0.9426};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_111()
		{
			double[] value = {0.575,0.9371,0.5747,0.9371,0.5884,0.9427,0.5882,0.9427,0.5746,0.9371,0.588,0.9426,0.5745,0.937,0.5743,0.9368,0.588,0.9425,0.5877,0.942,0.574,0.9363,0.5807,0.9592,0.5812,0.9599,0.5812,0.9601,0.5815,0.9602,0.5817,0.9603,0.5817,0.9602,0.5823,0.9601,0.5826,0.9583,0.5833,0.956,0.5846,0.9536,0.5864,0.9503,0.5808,0.9381,0.5794,0.9322,0.5845,0.933,0.6132,0.8861,0.6135,0.8773,0.6161,0.8757,0.629,0.8604,0.6288,0.8812,0.589,0.9431,0.5762,0.9386,0.6049,0.9387,0.6154,0.9422,0.5982,0.9561,0.5825,0.9585,0.569,0.9526,0.5546,0.9377,0.5479,0.9245,0.5482,0.9145,0.5514,0.9097,0.553,0.9105,0.588,0.9443,0.5741,0.9385,0.604,0.9398,0.6142,0.944,0.597,0.957,0.5812,0.9588,0.568,0.9528,0.55,0.9361,0.5431,0.9234,0.5431,0.9136,0.5465,0.9087,0.5483,0.9099,0.5432,0.9138,0.5464,0.9089,0.5482,0.9098,0.5435,0.9236,0.5511,0.937,0.5686,0.9532,0.5818,0.959,0.5976,0.9569,0.6148,0.9435,0.6044,0.9396,0.5884,0.9444,0.5745,0.9387,0.5503,0.9216,0.5517,0.912,0.5554,0.9082,0.5574,0.909,0.5571,0.936,0.5744,0.9453,0.5856,0.9518,0.6001,0.9474,0.6146,0.9329,0.6053,0.928,0.5911,0.9362,0.5787,0.9301,0.5636,0.914,0.5651,0.9044,0.5673,0.9019,0.5688,0.9031,0.5694,0.9261,0.5834,0.9297,0.5946,0.9247,0.6097,0.9109,0.5987,0.9106,0.5839,0.9176,0.5732,0.9151,0.6436,0.8824,0.5971,0.8719,0.6048,0.8807,0.6134,0.885,0.6277,0.8878,0.6315,0.8799,0.6165,0.8782,0.607,0.8741,0.592,0.8092,0.593,0.8257,0.592,0.8232};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_112()
		{
			double[] value = {0.5921,0.8204,0.6017,0.7377,0.6004,0.7487,0.5921,0.7823,0.5944,0.7826,0.5907,0.7764,0.5936,0.7697,0.5983,0.7611,0.6019,0.757,0.5981,0.7657,0.5971,0.7721,0.5991,0.7731,0.5943,0.7724,0.5937,0.7834,0.5908,0.7915,0.589,0.7966,0.5915,0.8024,0.5937,0.8026,0.5952,0.764,0.5986,0.7596,0.5946,0.8256,0.5933,0.835,0.5922,0.8349,0.5929,0.8363,0.6075,0.8093,0.5692,0.9147,0.5701,0.9318,0.5934,0.9223,0.5798,0.921,0.5939,0.9244,0.5685,0.9207,0.5634,0.9139,0.5621,0.915,0.6404,0.8712,0.6453,0.877,0.6506,0.9558,0.6789,0.938,0.6779,0.9386,0.5726,0.8994,0.5735,0.8971,0.571,0.8991,0.595,0.9158,0.6113,0.9122,0.5968,0.9147,0.5657,0.8999,0.5661,0.8988,0.5646,0.9001,0.5607,0.9041,0.5622,0.9023,0.5612,0.9022,0.5588,0.905,0.5546,0.9038,0.5545,0.9049,0.611,0.9642,0.6128,0.9644,0.628,0.9625,0.6266,0.9623,0.654,0.9699,0.6497,0.9697,0.65,0.966,0.656,0.9665,0.623,0.8778,0.6216,0.8789,0.6217,0.8831,0.6232,0.8824,0.6195,0.8783,0.6179,0.8791,0.6192,0.8818,0.6799,0.9577,0.6752,0.9597,0.6769,0.9586,0.6578,0.961,0.6576,0.9613,0.6521,0.9615,0.6517,0.9611,0.6241,0.835,0.6181,0.813,0.6179,0.8122,0.6155,0.8431,0.6149,0.8435,0.619,0.8585,0.6188,0.8594,0.6271,0.8866,0.6192,0.8667,0.618,0.8656,0.6192,0.8706,0.6181,0.8696,0.6191,0.8798,0.6173,0.887,0.6132,0.8914,0.616,0.887,0.6114,0.8915,0.609,0.9059,0.6025,0.9041,0.6018,0.9039,0.5987,0.9048,0.5976,0.9052,0.5838,0.8985,0.5816,0.8981,0.5745,0.8973};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_113()
		{
			double[] value = {0.5845,0.9028,0.5677,0.8991,0.5631,0.9022,0.5569,0.9041,0.5517,0.9045,0.5907,0.895,0.5512,0.9046,0.5498,0.9041,0.549,0.9039,0.5701,0.9042,0.5728,0.9026,0.5699,0.9011,0.5749,0.91,0.5725,0.9104,0.5754,0.9142,0.578,0.9129,0.5801,0.9169,0.5825,0.9154,0.5931,0.9174,0.6016,0.9135,0.598,0.9116,0.6036,0.9126,0.6005,0.911,0.5936,0.9117,0.594,0.9255,0.6249,0.9226,0.6247,0.9206,0.5777,0.9299,0.5778,0.9229,0.5713,0.9176,0.6222,0.95,0.6075,0.9511,0.6215,0.9524,0.6762,0.9352,0.6472,0.9502,0.5524,0.9086,0.5567,0.909,0.5836,0.9102,0.5849,0.9137,0.5664,0.912,0.5732,0.9164,0.5693,0.9118,0.5588,0.9172,0.5583,0.9127,0.5551,0.9138,0.6154,0.899,0.6068,0.907,0.6091,0.9084,0.6171,0.8999,0.6844,0.9624,0.6741,0.9637,0.6811,0.9596,0.687,0.9592,0.6734,0.9688,0.6718,0.9683,0.6542,0.9722,0.6575,0.9723,0.6001,0.964,0.602,0.9643,0.6044,0.9671,0.6147,0.9682,0.6061,0.966,0.5951,0.9646,0.5885,0.9597,0.5904,0.9604,0.5926,0.962,0.5767,0.9451,0.6208,0.9709,0.6112,0.9687,0.6181,0.9666,0.6257,0.9694,0.6207,0.9637,0.6278,0.9669,0.6608,0.9694,0.6624,0.9689,0.6765,0.9651,0.6751,0.9654,0.6664,0.9651,0.6647,0.9684,0.561,0.9303,0.5602,0.934,0.5749,0.9428,0.5739,0.9395,0.5522,0.9146,0.5514,0.9171,0.5539,0.9221,0.555,0.9191,0.5507,0.9121,0.5495,0.9141,0.5497,0.9094,0.5495,0.9069,0.5525,0.9051,0.5496,0.9076,0.5985,0.956,0.5868,0.9504,0.5838,0.9561,0.595,0.961,0.5494,0.9087,0.5551,0.9203,0.5523,0.919};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_114()
		{
			double[] value = {0.5495,0.9088,0.6228,0.9654,0.6192,0.9676,0.5986,0.966,0.5946,0.9464,0.5922,0.9438,0.5759,0.9347,0.5924,0.9397,0.5924,0.9372,0.6045,0.9052,0.6141,0.8956,0.6,0.9084,0.5971,0.9086,0.5944,0.9075,0.5822,0.9018,0.5756,0.9005,0.5813,0.9114,0.6267,0.9361,0.6254,0.9344,0.6899,0.953,0.6921,0.9534,0.6817,0.9637,0.701,0.9574,0.696,0.9581,0.6969,0.9587,0.6985,0.9548,0.6974,0.9551,0.6872,0.9469,0.6873,0.9466,0.6561,0.9569,0.6542,0.9571,0.6568,0.9094,0.6576,0.9126,0.6297,0.8455,0.631,0.8493,0.6238,0.8275,0.6246,0.83,0.619,0.8125,0.6158,0.8413,0.6186,0.8542,0.6194,0.8558,0.6317,0.8519,0.6378,0.8641,0.624,0.871,0.6268,0.8846,0.6236,0.8685,0.6237,0.8781,0.6234,0.8741,0.621,0.8708,0.6202,0.8736,0.6178,0.8906,0.6197,0.8933,0.6212,0.8941,0.619,0.895,0.6204,0.896,0.627,0.8915,0.6269,0.9025,0.653,0.8947,0.6519,0.8926,0.5635,0.9014,0.6139,0.9618,0.6137,0.9603,0.6269,0.9603,0.6265,0.9605,0.5755,0.9422,0.5943,0.9546,0.5974,0.9572,0.5651,0.9323,0.5652,0.9313,0.561,0.9265,0.5612,0.9264,0.5552,0.9204,0.6854,0.9548,0.6857,0.955,0.6671,0.9608,0.6672,0.9605,0.5598,0.9088,0.5595,0.9075,0.558,0.9122,0.5584,0.9113,0.5625,0.9047,0.5658,0.9041,0.5605,0.9046,0.6234,0.9247,0.6532,0.8981,0.65,0.8894,0.6233,0.917,0.6148,0.9084,0.6207,0.8977,0.6273,0.8875,0.6237,0.8908,0.6233,0.8931,0.6218,0.8673,0.6217,0.8618,0.6266,0.8364,0.6206,0.8184,0.6719,0.9249,0.6681,0.9214,0.6605,0.9209,0.6277,0.9402};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_115()
		{
			double[] value = {0.6346,0.9428,0.6444,0.9455,0.6552,0.9081,0.6232,0.9331,0.6874,0.949,0.653,0.9617,0.6498,0.9605,0.6812,0.9427,0.6936,0.9505,0.6662,0.9622,0.6929,0.9492,0.6641,0.961,0.6639,0.9608,0.6914,0.9513,0.6801,0.9665,0.7048,0.9536,0.6886,0.9551,0.5906,0.9355,0.5916,0.9268,0.5649,0.9261,0.5543,0.9122,0.5598,0.91,0.5591,0.9075,0.5635,0.9075,0.5666,0.9071,0.5785,0.9092,0.6159,0.9599,0.6184,0.9477,0.6033,0.9474,0.5832,0.9466,0.5577,0.9322,0.5627,0.935,0.5724,0.9446,0.567,0.9417,0.5541,0.9271,0.5571,0.9291,0.6058,0.9494,0.5829,0.959,0.5691,0.9426,0.5868,0.9621,0.6303,0.9667,0.6151,0.9643,0.5732,0.9541,0.5616,0.9397,0.5579,0.9318,0.5557,0.9268,0.5508,0.9171,0.5539,0.9249,0.5574,0.9297,0.5621,0.9363,0.5724,0.9482,0.5524,0.9237,0.5495,0.9157,0.6272,0.963,0.6318,0.967,0.6432,0.969,0.6391,0.9691,0.641,0.9682,0.636,0.97,0.604,0.9638,0.5392,0.9176,0.539,0.9254,0.5382,0.9256,0.5383,0.9177,0.5382,0.9119,0.539,0.912,0.5412,0.9092,0.5404,0.9087,0.5459,0.9453,0.5453,0.9454,0.5471,0.9471,0.5477,0.9469,0.5383,0.9346,0.5389,0.9345,0.5384,0.9253,0.5376,0.9255,0.553,0.9078,0.5529,0.908,0.5524,0.9069,0.5526,0.9066,0.5504,0.9072,0.5502,0.9074,0.545,0.9078,0.5452,0.908,0.5417,0.9094,0.5421,0.9097,0.5396,0.9121,0.5401,0.9123,0.5391,0.9174,0.5395,0.9175,0.5389,0.9252,0.5393,0.9253,0.5393,0.9344,0.5396,0.9345,0.5418,0.9397,0.5419,0.9398,0.5462,0.9452,0.546,0.9453,0.5479,0.9468,0.5476,0.9467};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_116()
		{
			double[] value = {0.5466,0.9471,0.5463,0.947,0.5449,0.9454,0.5447,0.9455,0.5405,0.94,0.5405,0.94,0.538,0.9347,0.5382,0.9347,0.5373,0.9256,0.5377,0.9257,0.5374,0.9177,0.5378,0.9178,0.5379,0.9119,0.5383,0.9121,0.5401,0.9086,0.5405,0.9089,0.5439,0.9068,0.544,0.907,0.5495,0.9061,0.5493,0.9064,0.5527,0.9078,0.5525,0.9073,0.5499,0.9072,0.545,0.9078,0.5418,0.9095,0.5398,0.9123,0.5393,0.9346,0.5416,0.9399,0.5456,0.9454,0.5472,0.9468,0.5466,0.9469,0.545,0.9455,0.5409,0.94,0.5386,0.9347,0.5389,0.9122,0.541,0.9092,0.5444,0.9074,0.5494,0.9067,0.5408,0.9399,0.5415,0.9397,0.5377,0.9176,0.5385,0.9174,0.5441,0.9069,0.5447,0.9075,0.5502,0.9069,0.5497,0.9064,0.5529,0.9075,0.5527,0.9069,0.55,0.9076,0.5429,0.9064,0.5454,0.9079,0.5511,0.9079,0.5445,0.9081,0.5509,0.9086,0.5436,0.9069,0.5502,0.9074,0.5436,0.9059,0.5501,0.9065,0.5421,0.9054,0.5495,0.9064,0.5481,0.9062,0.5433,0.9069,0.5438,0.9076,0.5486,0.9069,0.5391,0.9076,0.5418,0.9086,0.5407,0.9089,0.5393,0.9081,0.5389,0.9069,0.5378,0.9069,0.5408,0.9089,0.5416,0.9094,0.5373,0.9113,0.5394,0.9113,0.5387,0.9119,0.5371,0.9118,0.5364,0.9111,0.5358,0.9113,0.5404,0.9129,0.5412,0.913,0.5372,0.9172,0.539,0.9167,0.5383,0.9173,0.5366,0.9177,0.5361,0.9174,0.5357,0.9175,0.5413,0.9181,0.5421,0.918,0.5377,0.9248,0.5391,0.9246,0.5383,0.9252,0.5368,0.9256,0.5364,0.9253,0.5363,0.9252,0.5429,0.9244,0.5437,0.9243,0.5389,0.9335,0.5397,0.9337,0.5391,0.9343,0.5378,0.9346};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_117()
		{
			double[] value = {0.5375,0.9341,0.5376,0.9339,0.546,0.9327,0.5468,0.9325,0.5417,0.9383,0.5424,0.9388,0.5419,0.9396,0.5406,0.9398,0.5402,0.9391,0.5404,0.9387,0.5508,0.9398,0.5515,0.9396,0.5471,0.9448,0.5471,0.9446,0.5466,0.9454,0.5454,0.9457,0.5451,0.9449,0.5457,0.945,0.5562,0.9476,0.5569,0.9475,0.5491,0.9467,0.5487,0.9465,0.5486,0.9473,0.5474,0.9476,0.5474,0.9468,0.5479,0.947,0.5574,0.9492,0.5581,0.9491,0.5525,0.909,0.5522,0.9075,0.5523,0.9074,0.5525,0.9087,0.55,0.9462,0.5521,0.9481,0.5437,0.9389,0.5401,0.9333,0.5383,0.925,0.5374,0.9177,0.5371,0.912,0.5383,0.9082,0.5413,0.9063,0.5482,0.9074,0.552,0.9078,0.5521,0.909,0.5418,0.9052,0.5406,0.9052,0.5478,0.9062,0.5491,0.9064,0.5376,0.9068,0.537,0.9074,0.5357,0.9113,0.5357,0.9118,0.5357,0.9175,0.5359,0.9179,0.5363,0.9252,0.5369,0.9253,0.5377,0.9337,0.5387,0.9336,0.5406,0.9385,0.5422,0.9391,0.5463,0.9453,0.5485,0.9463,0.5509,0.9483,0.554,0.9472,0.5557,0.9489,0.5475,0.9393,0.5432,0.9331,0.5408,0.9248,0.5395,0.918,0.5389,0.9126,0.5396,0.9088,0.542,0.9068,0.5477,0.9068,0.5514,0.9076,0.5516,0.9088,0.5411,0.9057,0.5471,0.9056,0.5382,0.908,0.5375,0.9124,0.5382,0.9182,0.5396,0.925,0.5419,0.9333,0.5463,0.9395,0.5528,0.9475,0.5545,0.9492,0.5488,0.907,0.544,0.9076,0.5514,0.9081,0.5517,0.9094,0.543,0.9064,0.5481,0.9058,0.5405,0.9086,0.54,0.9127,0.541,0.918,0.5426,0.9244,0.5456,0.9327,0.5503,0.9397,0.5559,0.9476,0.5571,0.9492,0.5583,0.949};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_118()
		{
			double[] value = {0.5571,0.9473,0.5515,0.9394,0.5469,0.9325,0.5438,0.9242,0.5423,0.9179,0.5414,0.913,0.5418,0.9094,0.5516,0.9085,0.5517,0.9093,0.5525,0.9094,0.5522,0.9082,0.5362,0.9112,0.538,0.907,0.5421,0.9056,0.5494,0.9067,0.5361,0.9174,0.5366,0.9251,0.5379,0.9337,0.5408,0.9384,0.5462,0.9449,0.5493,0.9077,0.5509,0.9085,0.551,0.9094,0.5495,0.9083,0.5489,0.9059,0.5491,0.9068,0.5463,0.9069,0.5465,0.9077,0.5447,0.9086,0.5448,0.909,0.5445,0.912,0.5444,0.9121,0.5452,0.9169,0.5445,0.9172,0.5463,0.9233,0.5456,0.9236,0.55,0.9314,0.5489,0.9318,0.5546,0.9382,0.554,0.9385,0.5612,0.945,0.5609,0.9452,0.5627,0.9465,0.5624,0.9466,0.5622,0.9468,0.562,0.9469,0.5625,0.9468,0.5627,0.9467,0.5604,0.9452,0.5601,0.9453,0.5616,0.9467,0.5618,0.9466,0.5538,0.9384,0.5532,0.9387,0.549,0.9316,0.5481,0.9319,0.5454,0.9235,0.5447,0.9238,0.5442,0.917,0.5436,0.9173,0.5434,0.9119,0.5433,0.912,0.5437,0.9081,0.5437,0.9086,0.5458,0.9059,0.5459,0.9071,0.551,0.906,0.5483,0.906,0.5489,0.9067,0.5513,0.9068,0.547,0.9074,0.5479,0.9079,0.547,0.9107,0.548,0.9108,0.5482,0.9155,0.549,0.9155,0.5501,0.9217,0.551,0.9216,0.5541,0.9297,0.5549,0.9296,0.5582,0.9366,0.5589,0.9365,0.5638,0.9439,0.5646,0.9437,0.5651,0.9454,0.5659,0.9453,0.5529,0.9094,0.5528,0.9085,0.563,0.9443,0.5644,0.9458,0.5571,0.9372,0.553,0.9302,0.549,0.9223,0.5476,0.916,0.5466,0.9113,0.5465,0.9082,0.5477,0.9068,0.5503,0.9068,0.552,0.9094,0.5519,0.9085};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_119()
		{
			double[] value = {0.55,0.9056,0.5469,0.9058,0.5455,0.9078,0.5455,0.9112,0.5466,0.9161,0.5481,0.9225,0.5521,0.9304,0.5563,0.9374,0.5622,0.9444,0.5636,0.946,0.5644,0.9461,0.5639,0.9462,0.5659,0.9455,0.5654,0.9456,0.5491,0.9074,0.5507,0.9085,0.5505,0.9077,0.5489,0.9069,0.5486,0.905,0.5489,0.9059,0.5467,0.9067,0.5466,0.9058,0.5454,0.908,0.5455,0.9076,0.5456,0.9113,0.5459,0.9113,0.5461,0.9166,0.547,0.9165,0.5472,0.9235,0.5481,0.9233,0.5501,0.9322,0.5513,0.9318,0.555,0.9388,0.5559,0.9385,0.5621,0.9451,0.5626,0.9449,0.5637,0.9464,0.564,0.9462,0.564,0.9465,0.5637,0.9466,0.5632,0.9467,0.5635,0.9466,0.5631,0.9464,0.5629,0.9465,0.5613,0.9452,0.5617,0.945,0.5542,0.939,0.5551,0.9387,0.5492,0.9324,0.5503,0.9321,0.5464,0.9237,0.5472,0.9236,0.5452,0.9168,0.5459,0.9167,0.5445,0.9112,0.5447,0.9113,0.5443,0.9076,0.5444,0.9072,0.546,0.9061,0.546,0.9048,0.5515,0.9057,0.5497,0.9056,0.549,0.9049,0.5511,0.905,0.549,0.907,0.5481,0.9066,0.5497,0.9103,0.5487,0.9102,0.5511,0.9153,0.5502,0.9154,0.553,0.9218,0.5521,0.922,0.5564,0.93,0.5556,0.9302,0.5606,0.9366,0.5599,0.9368,0.5662,0.9434,0.5654,0.9436,0.5673,0.945,0.5665,0.9451,0.5529,0.9075,0.5531,0.9083,0.5658,0.9455,0.5645,0.9441,0.5586,0.9374,0.5545,0.9307,0.5509,0.9224,0.5495,0.9157,0.5482,0.9107,0.5475,0.9073,0.5483,0.9057,0.5503,0.9058,0.5519,0.9084,0.5517,0.9075,0.5498,0.9046,0.5474,0.9047,0.5465,0.9068,0.5471,0.9106,0.5486,0.9159,0.55,0.9226};
			return value;
		}
		private double[] getTextureCoordinate_6_20_point_120()
		{
			double[] value = {0.5536,0.9309,0.5578,0.9376,0.5638,0.9442,0.565,0.9457,0.5653,0.9459,0.5658,0.9458,0.5668,0.9453,0.5672,0.9452,0.549,0.9074,0.5505,0.9086,0.5505,0.9077,0.5489,0.9069,0.5482,0.9051,0.5482,0.9061,0.5445,0.9074,0.5436,0.9068,0.5415,0.9092,0.5407,0.9091,0.5396,0.9133,0.5389,0.9136,0.5389,0.919,0.5386,0.9192,0.5388,0.9264,0.5384,0.9266,0.5393,0.9359,0.5393,0.9359,0.5428,0.943,0.5428,0.9429,0.548,0.9499,0.5477,0.9499,0.5488,0.9515,0.5483,0.9516,0.5482,0.9518,0.5487,0.9518,0.5481,0.9519,0.5477,0.952,0.5474,0.9518,0.5479,0.9517,0.5471,0.9501,0.5468,0.9501,0.5418,0.9433,0.5418,0.9432,0.5384,0.9361,0.5383,0.9362,0.5378,0.9266,0.5374,0.9268,0.5379,0.9192,0.5375,0.9194,0.5385,0.9132,0.5377,0.9136,0.5405,0.9088,0.5397,0.9087,0.544,0.9067,0.5434,0.9057,0.5489,0.9066,0.5446,0.9074,0.5441,0.9066,0.5487,0.9058,0.5419,0.9095,0.5411,0.9089,0.5401,0.9136,0.5391,0.9135,0.54,0.919,0.5391,0.9192,0.5404,0.9261,0.5395,0.9263,0.5419,0.935,0.541,0.9352,0.5453,0.9418,0.5445,0.942,0.5494,0.9492,0.5486,0.9493,0.5497,0.951,0.5489,0.9512,0.551,0.9081,0.551,0.90