####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python FishCoded.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='FishCoded.x3d',name='title'),
    meta(content='Fish example with IndexedFaceSet encoding.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='X3D-Edit VRML importer',name='translator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='26-Sep-2002',name='created'),
    meta(content='28 April 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='http://www.cs.unc.edu/~isenburg/ac/models',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/research/asciicoder',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/research/asciicoder/coder',name='reference'),
    meta(content="Martin Isenburg, Jack Snoeyink Binary Compression Rates for ASCII Formats, accepted for Web3D'03, March 2003",name='reference'),
    meta(content='isenburg/is-bcraf-03.pdf',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/research/papers/is-bcraf-03.pdf',name='reference'),
    meta(content="Martin Isenburg, Jack Snoeyink, Coding with ASCII: compact, yet text-based 3D content, Proceedings of the 1st International Symposium on 3D Data Processing, Visualization and Transmission'02 (Invited Paper), pages 609 - 616, June 2002.",name='reference'),
    meta(content='isenburg/is-cwa-02.pdf',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/papers/is-cwa-02.pdf',name='reference'),
    meta(content="Martin Isenburg, Jack Snoeyink Coding Polygon Meshes as Compressable ASCII, Proceedings of Web3D Symposium'02 (Best Paper), pages 1 - 10, February 2002",name='reference'),
    meta(content='isenburg/is-cpmca-02.pdf',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/papers/is-cpmca-02.pdf',name='reference'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/FishCoded.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='FishCoded.x3d'),
    ExternProtoDeclare(appinfo='An ASCII-coded IndexedFaceSet',name='CodedIndexedFaceSet',url=["CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","CodedCompressedPrototypes.wrl#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CodedIndexedFaceSet"],
      field=[
      field(accessType='initializeOnly',appinfo='ASCII-coded coordIndex and texCoordIndex values',name='code',type='MFInt32'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for Coordinate values',name='pos',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for TextureCoordinate values',name='tex',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='Coordinate node',name='coord',type='SFNode'),
      field(accessType='initializeOnly',appinfo='TextureCoordinate node',name='texCoord',type='SFNode')]),
    #  ==================== 
    Viewpoint(description='1M view',position=(0,0,1)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(rotation=(0,1,0,1.57),scale=(0.025,0.025,0.025),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1,1,1)),
          #  modulateTextureWithDiffuse=true by retaining Material and diffuseColor 
          texture=ImageTexture(url=["fish.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/fish.jpg"])),
        geometry=ProtoInstance(name='CodedIndexedFaceSet',
          fieldValue=[
          fieldValue(name='code',value=[24045,3,0,3,1,1,2,0,0,0,0,0,0,3,2,10,0,0,0,10,0,0,6,0,6,0,0,6,0,6,0,0,6,0,6,0,3,2,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,0,3,3,1,2,0,6,0,5,3,2,0,6,0,6,0,0,0,6,0,6,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,3,1,1,1,2,0,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,3,1,1,1,2,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,5,5,0,0,6,0,5,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,5,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,3,1,2,0,6,0,6,0,0,6,0,0,6,0,3,2,0,6,0,6,0,6,0,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,5,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,5,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,3,0,0,0,0,3,2,0,6,0,6,0,6,0,6,5,2,0,5,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,0,0,6,0,5,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,0,6,6,0,0,0,6,0,5,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,1,2,0,5,0,6,0,6,6,0,6,0,0,6,3,2,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,6,0,0,0,6,0,0,6,0,0,0,7,0,6,0,0,0,6,0,6,0,0,0,0,6,5,0,6,6,0,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,8,0,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,8,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,2,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,7,0,0,0,0,6,0,0,8,0,0,0,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,5,0,0,5,0,6,0,6,0,0,0,0,6,5,0,5,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,8,0,0,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,6,1,2,0,6,0,6,0,5,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,8,0,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,3,0,0,0,6,0,0,3,2,0,6,0,6,0,6,0,6,0,3,2,0,5,6,0,0,6,6,0,0,0,0,6,0,6,0,0,3,2,0,6,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,0,6,0,6,0,6,5,0,0,6,0,5,0,5,0,0,6,0,5,0,3,0,3,2,0,6,0,6,0,0,6,0,0,3,2,0,0,0,0,0,0,0,0,11,0,11,0,0,6,0,1,1,1,1,1,1,1,1,1,1,2,0,6,6,0,1,1,1,1,1,1,2,0,5,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,6,0,6,6,0,6,6,0,0,0,5,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,5,0,5,0,5,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,0,3,2,0,0,6,0,6,0,0,0,6,6,0,6,1,1,1,2,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,3,2,0,6,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,5,0,6,5,0,5,0,0,6,0,5,0,0,0,0,0,6,0,6,6,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,3,2,0,0,6,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,0,0,0,6,0,6,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,1,1,0,5,1,1,2,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,3,2,0,0,6,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,5,0,0,6,0,0,5,5,0,6,0,0,0,5,0,6,0,5,0,5,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,5,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,6,0,0,0,5,6,0,0,0,0,0,5,6,6,0,0,0,5,5,0,5,0,0,5,5,0,0,6,0,0,5,6,0,0,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,7,0,0,0,0,6,0,5,0,6,0,0,5,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,5,5,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,5,5,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,7,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,5,0,5,0,0,6,0,0,5,6,0,0,5,0,0,5,0,6,0,5,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,3,2,0,0,6,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,5,0,6,0,0,0,5,0,6,0,5,0,0,5,5,0,5,0,0,5,6,0,0,0,0,5,0,6,6,0,0,0,5,6,0,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,5,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,5,0,0,5,0,6,0,6,0,0,0,5,0,6,0,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,5,6,0,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,5,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,1,1,0,5,0,0,5,0,6,0,5,6,0,0,0,6,5,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,0,5,6,0,0,5,5,0,3,2,0,6,0,5,0,6,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,5,0,5,0,5,0,0,0,5,6,5,0,5,0,0,5,0,0,6,0,6,0,5,0,0,0,6,6,0,0,0,5,0,5,5,0,0,5,5,0,0,0,6,5,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,3,2,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,0,0,6,5,0,0,5,0,5,0,5,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,5,5,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,3,2,5,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,5,0,5,0,0,6,0,5,0,5,0,0,5,5,0,6,0,0,0,6,0,5,0,5,0,6,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,0,0,5,0,6,0,5,0,5,0,5,0,0,5,0,6,0,5,0,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,5,0,0,6,0,5,0,6,0,0,0,5,5,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,5,6,3,3,2,5,0,5,0,0,6,0,6,0,0,0,0,0,0,6,0,6,6,5,0,0,5,0,6,0,5,0,3,1,1,2,0,6,5,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,5,5,0,6,0,0,0,6,0,6,0,0,0,0,6,6,0,6,2,5,5,0,0,5,0,0,6,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,0,5,6,0,6,0,0,5,0,5,0,0,6,5,0,0,6,0,5,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,5,0,6,0,5,5,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,5,5,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,5,0,5,0,5,5,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,5,0,0,6,0,0,0,5,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,5,5,0,6,0,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,0,3,0,5,0,0,3,1,2,5,0,0,6,6,0,5,0,6,0,0,5,0,5,0,5,0,0,5,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,5,0,5,0,6,0,6,0,0,5,6,0,0,0,5,5,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,0,0,6,5,0,0,6,5,0,0,5,5,0,0,5,0,5,6,0,0,0,0,6,5,0,0,6,0,0,0,6,0,5,5,0,5,0,0,0,5,0,6,5,0,0,0,6,0,5,3,2,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,5,0,5,0,5,5,0,0,0,6,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,3,2,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,3,2,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,5,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,5,0,5,0,6,0,6,0,0,5,0,0,5,5,0,5,0,0,6,0,5,0,5,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,5,0,5,0,5,0,0,6,0,0,5,5,0,5,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,5,0,0,5,6,0,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,5,0,5,0,0,5,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,6,0,6,5,3,0,5,0,3,1,1,1,1,2,0,5,0,6,0,5,5,0,0,0,0,6,0,6,0,6,0,6,0,0,0,6,5,0,0,0,6,0,6,0,5,0,6,0,5,0,6,5,0,0,6,0,5,5,2,0,0,5,6,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,5,0,0,0,6,0,5,5,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,5,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,5,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,5,0,6,0,0,5,0,5,5,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,5,0,5,0,5,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,5,0,0,5,5,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,0,5,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,5,5,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,5,0,5,0,0,5,5,0,5,0,5,0,5,0,6,0,0,0,0,2]),
          fieldValue(name='pos',value=4.884e-3),
          fieldValue(name='tex',value=3.8234e-3),
          fieldValue(name='coord',
            children=[
            Coordinate(point=[(-2,-4,-1),(-3,-3,0),(-4,-47,9),(0,-19,10),(0,55,-19),(0,11,0),(-4,1,0),(-3,3,1),(-3,4,1),(-2,6,0),(-1,4,1),(0,2,1),(14,0,0),(0,2,2),(13,-2,-3),(-2,-3,-1),(0,-5,0),(8,-1,2),(-3,-9,-2),(-5,-8,-1),(-4,-4,0),(1,-34,8),(-1,-22,12),(1,-23,25),(-9,-1,0),(0,-21,37),(-8,23,-38),(0,23,-25),(-1,22,-12),(1,34,-7),(-5,5,1),(-4,7,1),(-4,9,2),(-1,8,1),(-1,6,1),(1,2,2),(23,-1,0),(23,0,0),(0,-3,-3),(-1,-6,0),(12,-6,13),(-5,-19,-3),(-5,-17,-4),(-7,-13,-1),(-2,-24,10),(4,-22,26),(3,-17,35),(-13,-9,1),(-3,-37,30),(-7,0,0),(-8,1,-1),(-3,37,-30),(-11,9,-1),(3,17,-35),(3,22,-26),(-2,25,-9),(-8,12,2),(-5,18,4),(-4,19,3),(-1,17,4),(3,3,0),(34,-2,0),(35,0,0),(2,-3,0),(9,1,18),(-3,-27,-6),(-6,-27,-6),(-6,-21,-5),(8,-18,26),(7,-15,36),(1,-25,32),(-27,-34,-6),(4,-7,0),(-13,-11,0),(-12,0,0),(-12,1,0),(-12,11,1),(3,7,0),(-27,34,5),(2,26,-33),(8,15,-36),(7,18,-25),(-8,22,6),(-5,26,6),(-1,29,6),(3,3,0),(43,-2,-5),(43,1,6),(-45,682,2142),(0,-3,4),(2,0,0),(0,0,-1),(0,4,-3),(-1,2,0),(0,0,-7),(-1,-2,0),(0,-10,12),(2,0,0),(0,0,-1),(0,10,-12),(0,-19,-33),(-1,1,0),(0,-2,1),(0,-17,36),(1,0,0),(1,1,0),(6,164,1019),(-1,13,174),(-1,-20,129),(0,-56,148),(0,-79,130),(0,-76,71),(-3,-675,-222),(0,-65,-65),(5,162,11),(2,155,40),(-6,-268,-56),(-1,162,161),(-2,14,34),(-1,0,0),(-1,0,0),(2,-160,-125),(0,-66,-66),(0,-57,-54),(2,0,0),(2,26,-44),(3,-51,-90),(6,-25,-97),(-9,-205,736),(-4,0,-1),(0,-44,-19),(5,0,0),(0,-1,-26),(1,-1,-47),(0,42,16),(-2,4,51),(-2,68,30),(0,1,25),(-3,0,0),(-4,0,0),(-1,-69,-29),(0,-44,-20),(0,-1,-26),(0,-56,-20),(0,0,24),(6,0,0),(5,0,0),(0,0,-25),(0,-64,-12),(2,1,-43),(0,62,10),(3,10,-89),(0,42,8),(0,31,6),(-3,48,8),(-2,33,127),(2,46,15),(-1,24,8),(-2,6,55),(0,-23,-6),(0,2,24),(-5,0,0),(-5,0,0),(0,-3,-25),(1,-47,-16),(-2,-68,-30),(-1,-4,-51),(0,-42,-16),(0,-56,-18),(0,-62,-10),(2,-1,44),(1,-1,25),(5,0,0),(5,0,0),(0,-87,0),(0,2,-25),(2,2,-45),(3,49,-97),(0,63,9),(1,12,-50),(0,39,7),(0,34,4),(-1,-6,-53),(0,24,0),(1,8,57),(-4,40,0),(3,29,-1),(0,22,71),(0,20,2),(-2,34,5),(-1,58,155),(-3,7,54),(0,1,21),(0,-43,-10),(-5,0,0),(-6,0,0),(0,-3,-25),(-1,-7,-56),(0,-24,-8),(1,-46,-15),(-3,-33,-127),(-2,-48,-8),(0,-31,-6),(0,-42,-8),(1,-46,-9),(0,-63,-9),(3,-49,98),(3,-2,45),(0,-2,25),(5,0,0),(0,-74,3),(0,-397,-48),(0,-65,-31),(0,200,62),(0,99,22),(0,102,-2),(5,0,0),(0,62,-3),(0,3,-24),(2,3,-49),(3,69,-106),(0,32,-55),(1,42,10),(1,22,-50),(0,40,10),(0,31,6),(3,0,-40),(-1,21,1),(-1,29,0),(-1,19,-1),(-3,8,42),(0,22,-5),(0,18,-4),(-1,28,65),(0,27,-3),(0,35,-5),(0,37,90),(-2,69,165),(-2,7,53),(0,2,20),(0,31,2),(-5,158,-24),(0,63,-56),(0,-111,78),(0,-67,7),(0,-44,-5),(0,-31,-4),(0,-51,-8),(-6,0,0),(0,-2,-22),(-2,-7,-54),(-2,-58,-155),(-1,-34,-5),(0,-20,-2),(2,-22,-70),(1,-29,1),(-4,-40,-1),(1,-25,-3),(0,-35,-5),(0,-39,-7),(1,-53,-11),(0,-42,-10),(1,-32,56),(2,-69,106),(3,-3,49),(0,-3,24),(0,-62,3),(0,-102,1),(0,-99,-23),(0,-134,-29),(0,-65,-33),(0,0,-29),(5,0,0),(4,0,0),(0,0,30),(0,66,33),(0,134,29),(0,99,22),(0,6,-25),(1,99,-3),(2,4,-50),(2,85,-114),(1,39,-59),(1,35,-53),(0,33,12),(4,15,-37),(0,26,9),(1,41,11),(7,22,-17),(-3,67,1),(-8,19,16),(-1,21,-7),(0,13,-6),(-3,17,43),(-1,24,-12),(0,25,-11),(0,49,84),(0,38,97),(-1,73,169),(-2,5,52),(-1,44,5),(0,3,17),(0,67,-8),(-1,47,-21),(0,64,-57),(-1,9,-68),(-2,0,0),(-3,0,0),(0,-10,69),(-1,-64,57),(-1,-47,21),(0,-67,7),(0,-44,-5),(-1,-31,-3),(0,-2,-20),(-2,-7,-53),(-1,-69,-165),(0,-37,-89),(-1,-35,6),(0,-27,2),(0,-28,-65),(0,-18,5),(0,-22,5),(-1,-26,0),(-1,-24,0),(0,-27,-3),(0,-31,-7),(0,-40,-10),(1,-34,-12),(1,-33,-12),(1,-35,54),(0,-39,59),(2,-85,114),(3,-4,50),(0,-99,2),(0,-98,-16),(0,-133,-25),(0,-62,-31),(0,1,-30),(5,0,0),(4,0,1),(0,-1,30),(0,63,31),(0,133,24),(2,15,-42),(1,92,5),(2,113,-126),(0,50,-62),(1,51,-56),(3,24,-38),(1,39,18),(9,34,-8),(14,12,-24),(0,68,19),(-3,63,2),(-2,46,-8),(-14,7,21),(-8,19,6),(-2,26,-17),(-1,15,-10),(-1,30,48),(0,53,93),(0,42,103),(-1,85,171),(0,60,-9),(-2,14,52),(-1,45,-21),(-1,62,-55),(0,8,-67),(-2,0,0),(-3,0,0),(0,-9,68),(-1,-62,55),(-1,-45,21),(0,-66,6),(0,-44,-5),(-3,-5,-52),(0,-73,-169),(0,-38,-97),(0,-49,-83),(-1,-25,12),(-1,-24,11),(-3,-17,-43),(0,-13,7),(0,-21,7),(-1,-16,5),(-1,-19,1),(-1,-29,0),(0,-21,-2),(0,-23,-5),(1,-41,-12),(0,-26,-9),(1,-24,-12),(1,-39,-18),(3,-24,39),(1,-51,56),(1,-50,62),(2,-113,125),(0,-92,-6),(0,-121,-19),(0,-49,-36),(1,9,-34),(6,0,0),(5,0,0),(1,-9,35),(0,50,35),(2,210,-152),(0,65,36),(0,62,-63),(1,58,-60),(4,33,-37),(8,31,-7),(12,21,-17),(3,-7,-40),(-1,-7,-20),(5,31,45),(3,41,20),(2,68,15),(-3,59,4),(-3,46,-4),(-2,22,-12),(-2,10,-15),(-6,2,30),(-15,18,10),(-8,28,-3),(0,38,45),(0,64,96),(0,50,107),(-2,23,-13),(-1,123,160),(-1,54,-53),(-1,8,-73),(-2,0,0),(-3,0,0),(-1,-9,74),(-1,-54,53),(-2,-39,22),(0,-60,9),(0,-85,-172),(0,-42,-103),(0,-53,-93),(-1,-30,-47),(-2,-15,11),(-2,-26,16),(-8,-19,-6),(-2,-50,14),(-2,-67,-1),(1,-79,-23),(2,-65,-35),(9,-31,7),(3,-33,37),(1,-58,60),(0,-62,62),(0,-65,-37),(1,-32,-50),(0,0,-33),(8,0,0),(7,0,0),(0,0,33),(0,86,-55),(1,24,43),(0,79,-61),(3,36,-37),(9,21,-13),(9,24,-9),(-2,-12,-29),(1,2,-32),(9,29,7),(9,47,37),(10,96,10),(-2,58,9),(-10,52,11),(-9,27,-13),(-8,16,0),(0,-4,35),(-14,20,5),(-8,25,2),(-1,40,46),(0,67,102),(-1,23,-33),(0,65,103),(-1,7,-77),(-3,0,0),(-3,0,0),(-1,-8,78),(-2,-32,39),(-1,-23,13),(0,-50,-108),(0,-64,-96),(-1,-38,-44),(-8,-28,3),(-15,-18,-10),(-3,-32,19),(-2,-46,8),(-1,-63,-3),(1,-68,-19),(3,-55,-28),(4,-33,-34),(10,-25,9),(8,-21,13),(3,-36,37),(0,-79,60),(1,-23,-44),(1,2,-26),(7,0,0),(6,0,0),(-1,100,-74),(2,-2,30),(0,26,-35),(8,11,0),(-6,0,-26),(-2,14,-67),(-4,-10,5),(2,-183,65),(1,-206,77),(0,-75,18),(0,-80,14),(0,7,-22),(0,-71,4),(0,139,-25),(0,62,-16),(-1,221,-69),(-1,183,-55),(15,25,3),(21,30,1),(6,13,1),(22,66,8),(8,95,16),(-3,37,10),(-9,41,9),(-27,43,12),(-6,10,2),(-21,34,6),(-1,37,-112),(2,-45,172),(-8,24,1),(-2,41,42),(0,-16,-78),(0,97,124),(-2,0,0),(-3,0,0),(-1,-1,66),(-1,-23,33),(0,-67,-103),(-2,-40,-46),(-8,-25,-2),(-14,-20,-5),(-8,-15,-6),(-1,-10,16),(-2,-22,12),(-4,-46,3),(-1,-59,-5),(2,-68,-15),(4,-41,-20),(3,-23,-24),(1,-8,-21),(8,-31,-2),(11,-34,0),(10,-12,0),(0,-25,34),(1,3,-31),(6,0,0),(0,26,-31),(5,0,-1),(-3,16,-60),(-3,0,0),(0,-4,0),(0,-183,65),(0,-206,77),(0,-75,18),(-6,0,0),(0,-81,15),(7,0,0),(0,-93,15),(6,0,0),(1,-262,22),(0,73,-29),(0,338,-146),(2,283,-78),(0,173,-40),(4,32,-9),(13,24,-5),(18,27,-3),(8,12,-2),(22,69,-3),(15,111,4),(-7,48,10),(-13,56,15),(-33,49,11),(-12,20,5),(-4,71,-105),(3,53,-36),(-9,34,97),(-6,68,98),(5,96,-28),(3,117,-15),(-2,255,288),(-8,163,201),(0,64,-28),(0,-200,47),(-1,-121,-26),(-1,24,39),(-5,0,0),(-5,0,0),(0,-25,-40),(2,-205,-130),(0,-145,-90),(0,-66,-66),(0,-58,-54),(-1,-66,-56),(8,0,0),(0,-40,-84),(-3,0,0),(0,-3,0),(2,0,0),(-1,-27,96),(-2,0,0),(0,28,34),(-3,0,0),(0,16,78),(-2,-42,-43),(-8,-24,-1),(-14,-24,-1),(-10,-17,0),(-9,-27,13),(-9,-52,-12),(-1,-58,-9),(11,-96,-10),(8,-47,-37),(10,-29,-6),(18,-37,6),(4,-7,-2),(1,16,-60),(0,-4,0),(-2,-183,65),(0,-206,76),(0,-19,-25),(0,-62,16),(0,-67,20),(0,-72,5),(0,-29,33),(0,-263,22),(7,0,0),(0,-160,-33),(7,0,0),(0,61,-21),(1,398,-210),(6,301,-91),(3,146,-35),(3,-110,-71),(9,111,-16),(-6,84,66),(17,50,-8),(19,51,2),(37,78,-46),(24,155,-10),(-10,109,27),(-18,44,17),(-34,34,32),(-23,26,11),(10,58,-56),(8,60,-44),(-23,13,27),(-9,39,95),(11,76,-39),(1,57,-36),(-12,138,152),(-6,279,286),(-8,216,125),(0,75,-135),(0,49,-155),(2,11,-136),(0,-26,-177),(-2,-35,-190),(-2,37,42),(-3,-59,-202),(-2,0,0),(0,60,203),(0,32,198),(0,13,174),(0,-20,129),(0,-56,148),(0,-79,130),(0,-76,72),(0,-62,31),(5,0,0),(0,-127,22),(-6,0,0),(-7,0,0),(-1,-14,-29),(-2,-220,-261),(3,-156,-41),(3,-113,-16),(0,-80,-93),(-3,-51,-90),(-7,-25,-97),(11,-57,91),(0,-3,0),(1,-28,96),(-9,-13,9),(-22,-34,-7),(-6,-10,-2),(-26,-43,-12),(-10,-41,-9),(-2,-37,-10),(9,-95,-16),(22,-66,-8),(7,-13,-1),(21,-30,0),(10,-11,0),(4,-14,-3),(-3,-183,55),(-2,-20,-86),(2,-283,78),(0,-338,145),(0,-173,-24),(0,-61,20),(0,-103,-89),(8,0,0),(7,0,0),(0,35,-19),(1,406,-202),(6,309,-90),(0,-113,-68),(0,-103,-66),(6,142,-13),(2,120,60),(11,109,-11),(18,63,-13),(-3,98,55),(22,60,-15),(38,113,-35),(21,159,-4),(2,45,1),(-12,122,32),(-19,54,21),(-31,52,30),(8,54,-49),(6,59,-50),(-21,44,25),(-20,17,29),(1,59,-39),(0,77,-48),(-10,38,100),(-10,136,146),(-8,292,256),(0,61,-139),(-1,27,-156),(0,14,-135),(-2,-3,-143),(0,-28,-212),(-6,-12,-210),(-1,58,109),(-1,22,-8),(-5,0,0),(-5,0,0),(1,44,154),(-3,60,203),(-1,32,198),(1,13,174),(1,-20,129),(0,-56,148),(0,-79,130),(0,-76,72),(-1,-62,30),(-1,-6,-25),(-7,-163,-202),(-2,-255,-287),(5,-117,16),(3,-96,27),(-7,-68,-99),(-8,-34,-96),(4,-53,37),(11,-57,108),(-17,-14,-4),(-12,-20,-6),(-33,-49,-11),(-13,-56,-15),(-6,-48,-10),(16,-111,-3),(23,-69,4),(8,-12,2),(17,-27,3),(13,-24,5),(3,-32,8),(-6,-121,-96),(2,-147,35),(6,-301,90),(0,-122,-78),(0,-406,201),(0,-40,-100),(0,-30,27),(9,0,0),(8,0,0),(0,31,-28),(1,359,-183),(1,-49,-94),(-1,-48,-82),(2,185,-32),(6,128,-11),(14,81,-5),(4,115,58),(17,74,-17),(23,105,-23),(1,99,65),(39,146,-41),(24,177,-6),(2,90,3),(-12,135,35),(-20,61,28),(10,38,-62),(-26,141,14),(-22,54,20),(0,75,-52),(-2,92,-78),(-28,26,30),(-10,46,99),(-9,117,131),(-1,93,-145),(-2,40,-146),(-2,24,-159),(-5,24,-153),(-6,35,-128),(-7,167,133),(0,0,-2),(0,5,-9),(0,1,0),(0,-2,0),(0,-5,9),(0,-11,-6),(0,0,1),(0,0,-2),(0,15,-44),(0,2,0),(0,-3,-1),(0,-15,-113),(0,-26,118),(0,-1,0),(0,2,0),(0,26,-119),(0,1,0),(0,-24,-127),(0,-2,1),(0,-59,101),(1,0,0),(0,1,-1),(0,58,-101),(0,-96,-149),(0,-52,73),(0,98,-20),(0,33,52),(-1,0,0),(0,-1,0),(0,-79,73),(1,-1,0),(0,1,-1),(0,-31,-63),(4,12,71),(0,35,91),(0,43,100),(-5,0,0),(-6,0,0),(-1,14,137),(-2,88,305),(-1,36,191),(2,25,177),(1,-12,136),(0,-49,155),(0,-75,135),(-1,-76,76),(-9,-140,-203),(-6,-279,-286),(-11,-138,-151),(2,-57,37),(10,-76,38),(-10,-39,-96),(-22,-13,-26),(9,-60,45),(9,-58,55),(-24,-26,-12),(-34,-34,-32),(-17,-44,-17),(-10,-109,-26),(25,-155,11),(37,-78,45),(20,-51,-2),(15,-50,8),(-6,-84,-66),(10,-111,17),(6,-149,27),(0,-113,-67),(4,-283,75),(0,-49,-93),(1,-317,166),(0,-44,48),(10,0,0),(9,0,0),(0,45,-49),(-2,9,-125),(-1,7,-135),(1,230,-75),(2,140,-22),(5,102,-9),(15,67,-11),(20,72,-20),(3,121,87),(24,134,-17),(45,271,8),(26,194,-11),(6,134,5),(-9,150,37),(-17,119,-25),(-30,162,17),(-1,91,-79),(0,88,-126),(-29,69,-7),(-29,29,16),(-10,47,102),(-3,57,-171),(-5,51,-139),(-5,42,-109),(-5,39,-110),(4,-37,-55),(-8,42,-173),(0,3,-5),(-6,107,40),(0,26,-42),(-1,1,0),(0,-2,1),(0,-26,42),(0,-1,0),(0,-32,-21),(0,44,50),(0,-2,1),(0,-78,61),(0,-2,0),(0,-17,-40),(0,32,111),(0,34,91),(-5,0,0),(-3,0,127),(-5,13,211),(-1,28,212),(-2,2,143),(0,-15,135),(-1,-27,156),(0,-61,138),(-7,-292,-257),(-10,-136,-146),(-10,-38,-99),(0,-77,49),(1,-59,38),(-21,-17,-30),(-20,-44,-24),(7,-59,51),(7,-54,48),(-31,-52,-31),(-20,-54,-21),(-11,-122,-32),(3,-45,0),(21,-159,5),(38,-113,35),(21,-60,14),(-3,-98,-55),(19,-63,14),(11,-109,10),(2,-120,-60),(6,-142,13),(3,-92,-65),(2,-185,32),(1,-259,123),(0,-71,72),(9,0,0),(7,0,0),(-1,-12,-162),(0,-7,-140),(0,91,-23),(0,199,-49),(3,138,-19),(3,65,-9),(14,63,-13),(21,67,-22),(2,-54,-92),(32,184,64),(0,88,94),(49,269,-49),(33,256,-6),(6,192,2),(-10,192,20),(-24,185,44),(3,87,-115),(-47,203,-76),(-34,82,-53),(-25,30,0),(-6,55,-129),(-6,40,-99),(-1,30,-96),(-7,48,-166),(-6,12,-124),(99,-273,-1195),(7,-1,-1),(20,-40,60),(0,15,14),(-20,42,-71),(6,3,0),(14,-6,-7),(-22,28,-113),(0,-15,-8),(-11,20,13),(-5,-2,1),(-2,-10,-4),(-6,1,2),(-6,5,4),(8,111,181),(-43,60,33),(55,-204,-98),(25,-47,65),(1,-1,-9),(29,-58,40),(5,0,-2),(4,10,25),(17,-73,23),(6,2,1),(22,-102,-20),(-40,177,-3),(-30,61,-52),(14,-7,-12),(2,-20,-30),(-19,39,-52),(9,-30,-15),(-31,52,-99),(8,-35,-17),(3,-3,-3),(-2,20,-96),(-6,6,1),(-10,40,21),(-2,5,2),(-13,0,0),(-11,0,2),(-72,-217,-580),(-3,4,0),(-2,3,1),(4,7,4),(-4,2,0),(10,-7,-1),(5,-7,-1),(2,-7,-1),(-10,0,-4),(0,-6,0),(0,-4,0),(-12,0,0),(0,-6,2),(-11,8,-2),(0,3,1),(1,6,0),(2,4,1),(2,4,0),(3,3,1),(3,1,0),(1,0,0),(1,0,0),(9,33,23),(3,13,19),(4,14,34),(3,9,43),(2,0,52),(4,20,65),(3,67,65),(4,40,64),(5,54,121),(3,44,128),(0,43,134),(-31,56,173),(-1,30,258),(0,-5,266),(0,-10,218),(-1,6,190),(-6,25,141),(-2,4,9),(0,60,44),(-1,0,0),(-1,-1,1),(0,0,86),(0,-52,74),(-3,31,111),(-4,-14,126),(-6,-35,129),(-5,-24,153),(-2,-24,159),(-2,-40,146),(-1,-93,144),(-9,-117,-132),(-10,-46,-99),(-28,-26,-29),(-2,-92,79),(0,-75,51),(-21,-54,-21),(-26,-141,-13),(10,-38,62),(-21,-61,-29),(-11,-135,-35),(3,-90,-2),(24,-177,7),(39,-146,40),(1,-99,-65),(23,-105,24),(17,-74,16),(4,-115,-58),(15,-81,5),(2,-93,-74),(5,-102,9),(2,-140,22),(1,-230,75),(0,-90,45),(7,-1,-1),(0,-7,-139),(0,-4,-54),(6,1,-3),(0,78,-39),(0,165,-64),(5,180,-21),(13,79,-27),(0,-41,-118),(28,65,-22),(42,124,-28),(-9,60,135),(56,303,9),(36,293,-36),(5,249,0),(-11,230,22),(-31,307,-49),(-57,204,-98),(-36,75,-42),(-9,49,-111),(-3,30,-82),(-3,61,-165),(10,10,-123),(7,-26,-147),(0,-11,-196),(-3,2,-221),(0,6,-271),(47,-59,-35),(43,-214,-160),(15,-61,-54),(20,-72,21),(2,-3,-7),(4,0,-3),(22,-97,-17),(5,3,22),(8,-99,0),(6,0,2),(5,-49,18),(12,-1,-9),(-4,49,-18),(-8,102,0),(-21,101,16),(-20,72,-22),(-1,-16,-37),(0,-23,-36),(-26,59,-32),(-3,-39,-63),(-8,34,-23),(2,-3,-4),(3,-1,0),(-19,45,-68),(-2,21,-96),(-16,0,-103),(-8,2,-2),(-6,6,0),(-23,42,16),(-11,-28,-112),(-7,-36,-61),(-7,-62,-64),(-8,-17,-63),(-5,0,-50),(-6,-8,-43),(-6,-13,-33),(-6,-14,-21),(8,-8,-1),(7,-9,-1),(4,-12,-1),(0,-14,-2),(-15,-6,-17),(0,-7,0),(0,-3,1),(-24,0,0),(-22,0,0),(0,4,-1),(0,7,1),(2,9,1),(3,8,1),(4,7,1),(5,4,0),(6,3,1),(3,0,0),(0,25,18),(0,13,20),(0,14,33),(0,9,43),(0,1,53),(-1,21,65),(0,69,66),(0,42,66),(0,57,125),(0,48,131),(-88,-108,63),(-6,0,-1),(-1,10,2),(-6,2,0),(-9,-5,-4),(-2,-16,-8),(-20,-12,122),(15,6,6),(4,-4,0),(-20,-42,71),(1,-14,-15),(20,41,-59),(7,1,1),(25,39,-110),(38,131,55),(42,19,14),(0,39,162),(0,28,257),(0,-5,265),(0,-9,217),(0,5,190),(0,25,141),(0,5,8),(-1,-2,1),(-7,-11,113),(0,-3,6),(-7,-41,173),(4,37,55),(-5,-40,110),(-6,-42,109),(-5,-51,139),(-3,-57,170),(-10,-47,-103),(-28,-29,-15),(-30,-69,8),(0,-88,126),(0,-91,78),(-31,-162,-17),(-16,-119,25),(-9,-150,-38),(7,-134,-4),(26,-194,11),(45,-271,-8),(24,-134,17),(3,-121,-87),(20,-72,20),(3,-81,-89),(14,-63,13),(4,-65,9),(2,-138,19),(0,-199,49),(0,-91,22),(0,-4,-57),(1,-3,-93),(6,-2,1),(5,3,-2),(0,75,-51),(0,159,-77),(3,156,-28),(0,-21,-136),(13,60,-14),(30,62,-13),(43,129,-7),(64,274,31),(31,331,-52),(5,327,1),(-3,219,11),(-5,92,2),(-42,311,1),(-72,209,-91),(0,86,-217),(15,15,-125),(12,-23,-149),(0,-30,-214),(-4,4,-227),(67,-186,-96),(7,-145,-313),(24,-111,-29),(-1,-4,-54),(2,-2,-6),(8,-98,0),(5,0,-1),(4,-52,20),(6,5,21),(5,-54,55),(6,0,2),(0,-40,1),(12,5,-12),(-5,-68,-17),(6,104,13),(-4,-3,-32),(-5,49,-47),(-4,52,-19),(-7,101,-3),(-21,94,9),(-4,-6,-44),(-22,2,-73),(-9,6,-31),(1,0,-5),(-9,61,-2),(0,0,-2),(-1,-13,-26),(-8,31,-19),(-12,42,-54),(-4,23,-94),(-14,0,-100),(-26,-3,-97),(-6,-36,-65),(-10,-42,-61),(-12,-10,-58),(-10,1,-50),(-7,-7,-43),(-9,-11,-34),(8,-10,0),(3,-12,-2),(0,-18,-2),(-2,-17,-4),(-10,-2,-19),(-2,-2,0),(-35,1,0),(-36,-1,0),(-2,3,0),(0,12,3),(1,14,2),(4,12,1),(7,10,1),(8,7,1),(8,6,0),(-3,13,19),(-3,14,34),(-3,9,43),(-3,0,52),(-5,20,65),(-4,67,65),(-4,40,64),(-5,54,121),(-3,43,127),(-41,-84,-34),(-11,-1,-2),(-13,0,0),(-2,-5,-3),(-10,-40,-21),(-6,-6,0),(-1,-19,97),(4,4,3),(7,34,17),(-30,-52,99),(8,30,15),(-18,-39,52),(2,21,30),(14,6,12),(-31,-62,52),(-18,-74,22),(-22,-102,-19),(29,100,17),(17,73,-23),(4,-10,-24),(5,0,2),(29,59,-40),(2,1,9),(25,47,-65),(11,143,65),(43,61,34),(35,15,13),(0,30,258),(0,-5,266),(0,-10,218),(2,6,190),(4,25,141),(-3,0,5),(-7,-13,124),(-6,-48,166),(-2,-30,96),(-6,-40,99),(-6,-55,128),(-25,-30,0),(-34,-82,54),(-46,-203,76),(3,-87,114),(-25,-185,-45),(-9,-192,-20),(7,-192,-1),(33,-256,7),(49,-269,48),(1,-88,-94),(32,-129,28),(-1,-55,-92),(25,-70,20),(13,-80,27),(5,-180,21),(0,-165,63),(1,-5,-106),(1,0,-136),(3,-76,54),(2,-2,1),(1,3,-2),(3,76,-54),(0,158,-79),(2,3,-121),(3,125,-69),(4,-8,-158),(0,-1,-99),(10,31,-23),(0,5,107),(-1,18,162),(27,45,-14),(42,112,-15),(62,242,-25),(33,315,-25),(7,117,-11),(10,319,-10),(-1,208,5),(-7,135,14),(-44,326,-17),(8,18,-169),(4,17,-194),(3,-18,-246),(41,-264,-23),(-5,17,-299),(5,-89,-25),(-7,-11,-279),(-1,-5,-45),(5,-52,20),(2,-3,-5),(7,-53,52),(4,0,-2),(0,-34,1),(4,-2,23),(-6,-65,-20),(5,0,2),(0,-101,-1),(12,0,-8),(-1,3,-30),(1,104,-1),(4,70,15),(-9,23,-48),(-4,55,-39),(-3,42,-11),(-6,111,-9),(-25,1,-89),(-11,4,-36),(2,1,-4),(1,7,0),(-13,86,19),(-4,7,-27),(-9,27,-117),(-7,23,-90),(-12,23,-85),(-18,6,-83),(-13,-19,-63),(-13,-31,-58),(-15,-5,-56),(-11,4,-48),(-9,-4,-43),(3,-15,-2),(0,-21,-3),(-2,-22,-3),(-1,-5,0),(9,-10,40),(-21,14,-74),(-45,1,-4),(-46,-1,5),(-2,4,0),(-1,18,4),(0,17,2),(4,12,2),(8,10,0),(11,10,1),(-6,13,33),(-5,8,43),(-6,0,50),(-9,17,63),(-8,62,64),(-7,36,61),(-11,27,111),(-22,-43,-16),(-7,-6,0),(-7,-2,3),(-17,0,103),(-2,-21,96),(-18,-44,68),(4,2,0),(1,2,4),(-9,-34,23),(-3,39,63),(-26,-59,32),(0,24,36),(-1,15,37),(-20,-73,21),(-21,-101,-16),(-7,-102,1),(-3,-48,18),(13,2,8),(4,49,-19),(6,0,-1),(8,98,0),(5,-3,-22),(22,98,18),(4,0,3),(2,3,6),(20,72,-21),(15,61,55),(43,214,160),(46,58,35),(0,-7,271),(-3,-1,221),(0,12,196),(9,25,147),(8,-11,123),(-4,-61,165),(-3,-30,82),(-9,-49,111),(-36,-75,42),(-57,-204,98),(-31,-307,48),(-9,-230,-22),(5,-249,1),(36,-293,35),(55,-303,-10),(-9,-60,-134),(43,-124,29),(28,-65,22),(15,-73,19),(4,-156,27),(0,0,-139),(-2,2,-120),(0,-148,58),(4,-78,54),(4,-2,2),(3,3,-3),(4,78,-54),(2,0,-141),(0,143,-49),(1,0,-133),(1,13,-142),(6,116,-31),(9,30,-11),(22,34,-11),(-1,-5,80),(2,5,120),(39,96,-17),(58,211,-15),(37,331,-15),(9,184,-17),(17,299,-41),(1,217,-12),(-6,165,25),(5,30,-240),(2,-35,-238),(1,-81,-312),(-6,-2,-262),(5,-57,39),(-1,1,-17),(0,-38,0),(1,2,-8),(-5,-64,-34),(3,0,-1),(0,-102,13),(4,-2,22),(-10,-113,-48),(6,0,2),(12,6,-7),(-2,9,-27),(-6,17,-16),(9,89,32),(0,107,-14),(-26,120,-133),(-18,12,-40),(1,4,-5),(2,6,-2),(-3,8,-24),(-1,161,1),(-10,22,-123),(-7,32,-89),(-13,43,-81),(-19,21,-78),(-14,-8,-60),(-15,-18,-55),(-16,1,-54),(-12,6,-47),(0,-27,-4),(-1,-28,-2),(9,-18,45),(0,-7,0),(3,-1,2),(-18,-8,-50),(-10,-3,-41),(2,-5,-1),(-3,-37,-8),(-6,-34,-8),(9,-13,39),(10,-12,35),(2,0,2),(-14,-44,-12),(4,-2,2),(-29,-39,-9),(-15,-14,0),(-15,-1,0),(-16,2,0),(-15,14,1),(-28,39,8),(4,2,-2),(-14,44,12),(4,0,-3),(9,14,-35),(8,13,-38),(-5,35,9),(-1,37,8),(2,4,0),(54,-3,-1),(0,5,40),(0,13,53),(0,6,0),(0,17,-54),(-1,5,-39),(-55,-2,2),(-3,5,0),(-1,22,4),(0,21,3),(4,15,2),(8,12,0),(-7,6,43),(-10,-2,50),(-14,12,58),(-11,42,61),(-6,36,65),(-26,2,97),(-14,-1,98),(-4,-23,96),(-12,-42,54),(-8,-30,19),(0,13,26),(0,0,2),(-8,-62,2),(1,0,5),(-11,-6,31),(-22,-1,73),(-4,6,43),(-21,-95,-9),(-7,-101,4),(-3,-52,19),(-6,-48,47),(-3,3,32),(1,-36,3),(6,-68,-17),(7,63,29),(0,40,-2),(6,0,-2),(5,54,-55),(6,-5,-21),(5,53,-19),(5,0,1),(7,98,0),(1,2,7),(-1,4,54),(25,111,29),(8,145,313),(65,185,96),(-4,-4,227),(0,31,214),(13,22,149),(14,-16,125),(0,-86,217),(-73,-209,90),(-41,-311,-2),(-6,-92,-2),(-2,-219,-11),(7,-327,0),(30,-331,52),(64,-274,-31),(44,-129,8),(29,-62,13),(13,-60,13),(-2,-6,-165),(-3,-8,-157),(3,-123,95),(0,-143,49),(5,-71,54),(6,-2,1),(5,3,-2),(0,8,-123),(5,69,-54),(0,21,-145),(-2,28,-118),(1,117,-61),(3,113,-44),(11,34,-12),(24,37,-21),(35,81,-29),(0,-28,191),(60,200,-16),(41,326,-9),(11,226,-36),(18,303,-75),(4,210,-17),(4,2,-249),(-3,11,-294),(-2,-108,21),(-5,58,-236),(-4,-72,-22),(-3,28,-38),(0,-100,11),(1,0,-6),(-11,-112,-41),(4,1,-5),(-13,-79,-94),(17,11,-1),(0,10,-1),(-6,192,-22),(-10,9,-52),(-16,9,-52),(-10,27,-129),(4,226,2),(-5,52,-96),(-13,69,-84),(-18,48,-71),(-14,11,-56),(-15,-2,-51),(-16,11,-51),(0,-27,-2),(1,-16,5),(-3,-2,-8),(-13,-9,-49),(-3,-50,-6),(11,-7,38),(0,-2,3),(-3,-41,-9),(2,0,4),(-13,-46,-14),(-28,-41,-10),(-15,-15,-1),(-19,-3,0),(-20,4,0),(-15,15,2),(-28,41,10),(-11,47,13),(1,0,-4),(-2,42,9),(1,2,-4),(11,8,-37),(-2,50,7),(2,5,1),(-15,7,48),(-2,0,2),(3,7,-2),(13,12,-47),(-4,5,2),(-1,28,3),(0,27,4),(4,17,2),(-12,-4,48),(-16,6,56),(-14,31,58),(-13,18,63),(-18,-7,83),(-12,-24,84),(-7,-22,91),(-9,-27,117),(-3,-7,26),(-13,-86,-19),(2,-7,1),(2,-1,4),(-12,-4,36),(-25,-1,89),(-7,-111,9),(-2,-42,11),(-5,-55,39),(-8,-23,47),(5,-70,-15),(1,-104,2),(-2,-2,30),(12,0,8),(0,102,0),(5,0,-2),(-6,65,20),(5,2,-24),(0,34,0),(4,0,2),(7,53,-52),(2,3,5),(4,52,-20),(-2,5,46),(-6,11,279),(5,88,25),(-5,-17,299),(42,265,23),(3,17,246),(4,-18,194),(7,-18,169),(-45,-326,16),(-6,-135,-15),(0,-208,-4),(10,-319,11),(7,-117,11),(33,-315,25),(63,-242,25),(41,-112,15),(26,-45,13),(-1,-18,-163),(1,-5,-106),(10,-31,24),(3,-121,61),(0,-137,59),(5,-69,54),(6,-3,1),(0,23,-145),(5,3,-2),(-2,29,-145),(0,21,-136),(4,35,-133),(0,40,98),(0,105,-51),(5,110,-54),(12,38,-7),(23,35,-11),(37,78,-15),(53,161,16),(40,297,-31),(21,271,-49),(18,290,-24),(-1,6,-277),(-10,13,-251),(-13,-131,-45),(-2,-22,-24),(0,41,-9),(-15,-68,-107),(-13,-43,-132),(1,25,-11),(2,122,7),(-14,16,-135),(-4,72,-107),(6,128,16),(-10,122,-89),(-19,94,-72),(-13,40,-51),(-14,14,-48),(-19,4,-51),(-1,-42,-2),(-3,-43,0),(-14,-50,-10),(-28,-47,-5),(-16,-16,-1),(-17,-2,0),(-18,3,0),(-16,16,2),(-28,47,5),(-14,50,10),(-2,44,0),(0,43,2),(-2,29,5),(-2,1,7),(1,17,-5),(-1,25,3),(0,32,4),(-18,0,54),(-16,19,55),(-13,7,60),(-19,-22,78),(-14,-43,81),(-7,-32,89),(-10,-22,122),(-1,-161,-1),(-2,-8,25),(3,-6,2),(0,-4,5),(-19,-12,40),(-25,-120,133),(1,-107,13),(8,-89,-32),(-7,-17,17),(-1,-9,27),(14,-5,6),(5,0,-2),(-11,114,48),(4,2,-23),(0,102,-12),(3,0,2),(-5,63,34),(1,-2,7),(-1,38,0),(0,-1,17),(5,58,-39),(-6,2,263),(2,81,312),(2,34,238),(4,-31,239),(-6,-165,-25),(2,-217,13),(17,-299,41),(9,-184,17),(38,-331,15),(57,-211,15),(39,-96,16),(1,-4,-121),(-1,5,-79),(23,-35,12),(9,-30,11),(6,-116,31),(0,-129,56),(6,-67,53),(2,28,-144),(4,-5,1),(0,22,-136),(0,38,-143),(0,34,-146),(2,3,-3),(0,52,-181),(1,77,-67),(1,-54,179),(2,-39,160),(1,102,-79),(4,102,-68),(12,43,-7),(21,36,-17),(37,82,-26),(56,168,-16),(38,284,-48),(21,269,-40),(-12,49,-345),(-10,16,-124),(-15,-21,-140),(-15,50,-150),(-5,77,-111),(-5,185,-76),(-19,154,-63),(-13,74,-52),(-11,42,-46),(-14,-54,-13),(-16,-62,-6),(-32,-52,-7),(-16,-17,-1),(-14,-4,0),(-15,5,1),(-16,17,1),(-32,52,7),(-16,62,6),(-13,54,13),(-6,70,11),(-1,67,10),(-16,2,51),(-13,-12,56),(-19,-48,71),(-12,-71,83),(-5,-50,96),(4,-226,-2),(-11,-27,130),(-16,-9,52),(-9,-9,52),(-6,-192,22),(0,-10,1),(17,-10,1),(-13,79,94),(4,-1,5),(-11,112,41),(1,0,5),(-1,100,-11),(-2,-28,39),(-5,72,22),(-5,-58,235),(-2,108,-21),(-2,-12,295),(5,-2,249),(4,-210,17),(18,-303,75),(12,-226,36),(40,-326,9),(59,-199,15),(0,28,-191),(36,-82,30),(24,-37,21),(11,-34,12),(4,-113,44),(0,-116,60),(1,28,-143),(3,-74,34),(-3,35,-134),(5,35,-156),(0,51,-181),(3,-2,-4),(0,52,-138),(3,4,-1),(0,64,-31),(0,56,-119),(0,46,-79),(0,30,41),(0,-67,127),(0,-21,61),(3,-49,159),(3,101,-77),(10,48,-22),(20,39,-23),(36,95,-43),(55,187,-53),(33,269,-114),(-8,34,-149),(-17,46,-178),(-17,60,-145),(-2,107,-124),(-5,170,-83),(-5,54,-26),(-11,162,-43),(-9,84,-35),(-19,-81,-15),(-37,-78,-14),(-18,-25,-3),(-16,-6,0),(-16,7,0),(-19,25,4),(-37,78,14),(-19,81,15),(-13,85,9),(-9,98,13),(-13,-40,51),(-19,-94,72),(-9,-122,88),(6,-128,-16),(-4,-72,108),(-14,-16,134),(3,-122,-7),(0,-24,12),(-14,44,132),(-14,67,107),(0,-41,9),(-2,23,24),(-14,130,45),(-10,-14,251),(0,-6,277),(19,-290,24),(21,-271,49),(40,-297,30),(53,-161,-16),(37,-78,16),(23,-35,11),(12,-38,7),(5,-109,53),(0,27,-191),(1,-101,78),(2,40,-161),(1,54,-179),(0,38,-105),(0,-63,30),(0,42,-95),(4,-1,-4),(4,2,4),(0,84,-125),(0,55,-81),(1,35,-9),(1,67,-17),(-1,-52,84),(7,81,-18),(-4,-90,178),(15,42,-17),(18,26,-10),(33,81,-21),(53,179,-17),(-4,41,-171),(-15,112,-196),(-13,86,-138),(-7,129,-110),(0,179,-108),(-4,100,-38),(-6,111,-40),(-40,-96,-12),(-21,-28,0),(-18,-6,0),(-19,7,0),(-20,28,1),(-41,96,12),(-20,121,28),(-17,95,26),(-19,-154,63),(-5,-185,76),(-4,-77,111),(-16,-49,150),(-15,21,140),(-10,-17,124),(-11,-49,345),(22,-269,40),(39,-284,48),(55,-168,16),(37,-82,26),(22,-36,17),(11,-42,6),(2,24,-185),(3,-100,76),(2,50,-160),(0,21,-61),(0,66,-126),(0,-76,38),(0,45,-79),(0,-39,9),(5,0,-1),(0,55,-84),(0,27,-41),(9,0,-1),(0,30,-3),(3,64,-4),(6,67,8),(23,10,37),(30,61,-10),(-19,160,-243),(-6,92,-100),(-4,115,-94),(0,206,-128),(-1,91,-38),(-23,-24,-2),(-19,-5,0),(-20,6,0),(-23,24,3),(-43,93,13),(-25,70,31),(-5,-54,26),(-5,-170,83),(-1,-107,124),(-18,-60,145),(-17,-46,178),(-7,-34,149),(34,-269,114),(55,-187,53),(36,-95,43),(19,-38,22),(-3,56,-159),(14,-41,16),(-4,90,-178),(7,-81,18),(0,52,-84),(1,-68,18),(0,-34,8),(-3,26,-46),(1,114,-106),(8,0,0),(8,0,0),(0,40,-5),(1,44,-8),(4,51,12),(19,9,11),(-9,92,-124),(-2,105,-102),(-2,119,-89),(0,204,-125),(-20,-5,0),(-21,6,0),(-23,26,0),(-45,84,13),(0,-179,108),(-8,-129,110),(-13,-86,138),(-15,-112,196),(-2,-41,171),(53,-179,17),(33,-80,20),(0,87,-199),(24,-10,-38),(6,-67,-7),(3,-63,4),(0,124,-108),(0,43,-42),(9,0,0),(7,0,0),(0,47,-24),(0,97,-39),(-1,110,-107),(-7,117,-87),(-21,6,0),(-23,24,2),(-4,-115,94),(-6,-92,100),(-18,-159,242),(39,25,-124),(20,-9,-12),(4,-50,-12),(1,46,-57),(8,1,0),(0,97,-38),(0,109,-107),(-8,0,0),(-15,3,1),(-1,-105,102),(16,-8,3),(109,965,-279),(4,-5,17),(3,-8,16),(3,-10,14),(2,-13,13),(2,-14,10),(0,-16,8),(0,-18,4),(-1,-18,1),(-1,-17,-1),(-2,-18,-4),(-3,-16,-8),(-3,-14,-9),(-4,-13,-13),(-4,-10,-14),(-4,-8,-15),(-5,-4,-17),(-5,-1,-18),(-6,2,-17),(-5,4,-17),(-5,8,-16),(-4,10,-14),(-3,12,-13),(36,-2,-7),(4,-13,12),(5,-10,14),(5,-8,16),(6,-4,17),(5,-1,18),(5,1,17),(5,5,17),(5,8,15),(4,10,15),(4,12,12),(3,15,10),(3,16,7),(2,18,4),(1,17,0),(0,18,-1),(0,17,-5),(-1,17,-8),(-2,14,-10),(-2,13,-12),(-3,10,-15),(-3,8,-16),(-4,4,-16),(-4,2,-17),(-38,1,9),(-2,-4,1),(4,-1,16),(4,-5,16),(3,-7,16),(3,-10,13),(2,-12,12),(1,-14,10),(0,-16,7),(0,-16,5),(0,-17,1),(-2,-17,-2),(-2,-17,-4),(-2,-16,-7),(-3,-14,-9),(-4,-12,-12),(-4,-10,-13),(-4,-7,-15),(-5,-4,-16),(-5,-1,-17),(-5,2,-17),(-5,4,-16),(-5,8,-15),(-4,9,-14),(-4,13,-12),(-1,13,-10),(1,-3,-4),(36,-1,-8),(6,0,1),(4,-14,10),(4,-12,12),(4,-10,14),(5,-8,16),(6,-4,16),(5,-1,17),(5,2,17),(5,4,17),(5,7,15),(4,10,14),(3,13,12),(4,14,9),(2,16,7),(2,17,4),(1,17,1),(0,17,-2),(0,17,-5),(-1,16,-7),(-1,14,-10),(-2,13,-12),(-3,10,-14),(-3,7,-16),(-4,5,-16),(-4,0,-17),(-5,0,-16),(-6,2,1),(-38,2,9),(-2,-4,0),(-5,-5,-16),(-6,-7,-15),(-5,-10,-14),(-5,-12,-12),(-5,-14,-9),(-4,-15,-7),(-3,-17,-4),(-2,-17,0),(0,-17,1),(0,-17,4),(1,-1,-4),(36,-1,-8),(7,0,1),(4,1,4),(2,-15,7),(3,-14,9),(4,-11,12),(4,-10,13),(5,-7,15),(5,-4,15),(6,0,16),(5,1,16),(4,4,16),(5,7,14),(4,10,13),(3,11,11),(3,14,9),(3,15,7),(1,15,4),(1,17,0),(0,16,-1),(0,16,-5),(0,15,-7),(-2,14,-9),(-2,11,-12),(-2,10,-13),(-4,7,-14),(-3,4,-16),(-4,0,-16),(-5,-1,-16),(-5,-3,-15),(-3,5,-1),(-7,3,1),(-37,1,8),(-5,-7,-16),(-6,-11,-14),(-5,-12,-12),(-5,-15,-10),(-4,-16,-7),(-4,-17,-5),(-2,-18,0),(0,-18,1),(35,-1,-8),(7,0,1),(5,1,5),(4,2,21),(1,-12,3),(1,-11,5),(2,-11,8),(3,-9,8),(4,-7,11),(4,-6,11),(4,-3,12),(4,0,12),(4,1,13),(4,3,12),(4,6,11),(3,7,10),(3,9,9),(3,10,7),(2,12,5),(1,12,3),(1,13,0),(0,13,-1),(0,12,-4),(-1,11,-5),(-1,11,-7),(-2,9,-9),(-2,7,-11),(-3,6,-11),(-3,3,-12),(-3,0,-12),(-4,-1,-13),(-5,-3,-12),(-3,-5,-11),(0,19,-11),(-3,5,-2),(-6,1,0),(-6,-10,-14),(-6,-13,-12),(-5,-14,-10),(-4,-16,-7),(-4,-18,-4),(-2,-17,-1),(7,-1,1),(5,0,5),(4,0,21),(7,0,20),(0,-9,1),(1,-9,3),(0,-8,4),(2,-8,5),(2,-6,6),(3,-5,7),(2,-4,8),(3,-2,9),(3,0,9),(4,1,9),(3,2,8),(3,4,8),(2,5,7),(2,6,7),(2,8,5),(2,8,3),(1,9,2),(0,9,0),(0,9,-1),(0,9,-2),(0,8,-4),(-1,7,-5),(-1,7,-7),(-2,5,-7),(-2,4,-8),(-3,2,-9),(-3,0,-8),(-3,-1,-9),(-3,-2,-9),(-3,-4,-8),(-3,-4,-7),(-3,16,-13),(0,16,-14),(-4,4,-3),(-5,-12,-12),(-5,-15,-9),(-5,-15,-7),(-2,-17,-3),(4,-2,4),(4,-3,21),(7,-3,20),(2,9,2),(2,8,4),(2,8,4),(-4,13,-16),(-1,13,-16),(-5,-14,-9),(-3,-15,-6),(2,-6,20),(3,12,5),(-215,66,89),(-4,-5,17),(-3,-8,16),(-3,-10,14),(-2,-13,13),(-1,-14,10),(0,-16,8),(0,-18,4),(0,-18,1),(2,-17,-1),(2,-18,-4),(2,-16,-8),(4,-14,-9),(3,-13,-13),(4,-10,-14),(5,-8,-15),(4,-4,-17),(6,-1,-18),(5,2,-17),(5,4,-17),(5,8,-16),(5,10,-14),(3,13,-12),(1,2,4),(-4,-13,12),(-4,-9,14),(-5,-8,15),(-5,-4,16),(-5,-1,17),(-5,2,17),(-5,4,16),(-4,7,15),(-4,10,13),(-3,12,12),(-3,14,9),(-3,16,7),(-2,17,4),(-1,17,1),(0,17,-2),(0,16,-5),(1,16,-7),(1,14,-10),(2,12,-12),(3,10,-13),(3,7,-16),(4,5,-16),(3,1,-16),(-3,3,-1),(-38,-2,-8),(-4,-2,18),(-4,-4,16),(-3,-8,16),(-3,-10,15),(-2,-13,12),(-1,-14,10),(0,-17,8),(0,-17,5),(0,-18,0),(2,-17,-1),(2,-18,-4),(2,-16,-7),(4,-15,-10),(3,-12,-12),(4,-10,-15),(5,-8,-15),(5,-5,-17),(5,0,-17),(6,2,-18),(5,4,-17),(5,8,-16),(5,10,-14),(4,13,-12),(3,14,-10),(36,2,9),(2,3,3),(1,15,-7),(0,17,-5),(-1,17,0),(-2,17,1),(-4,17,4),(-4,15,7),(-5,14,9),(-5,12,12),(-5,10,14),(-5,7,15),(-5,5,15),(-3,3,-1),(-38,-3,-9),(-6,-1,0),(-4,0,17),(-5,-1,17),(-4,-5,16),(-3,-7,16),(-3,-10,14),(-2,-13,12),(-1,-14,10),(0,-16,7),(0,-17,5),(1,-17,1),(1,-17,-2),(2,-17,-4),(3,-16,-7),(3,-14,-9),(3,-13,-12),(4,-10,-14),(5,-7,-15),(5,-4,-17),(5,-1,-17),(5,2,-17),(6,4,-16),(5,8,-16),(5,10,-14),(4,12,-12),(3,14,-10),(2,16,-7),(6,0,0),(35,2,8),(0,17,-5),(-1,18,-1),(-2,18,1),(-3,17,5),(-5,16,7),(-5,15,10),(-5,12,12),(-5,11,14),(-6,6,15),(-37,-2,-9),(-6,-3,0),(-4,-4,2),(-5,4,15),(-4,0,16),(-5,-1,16),(-3,-4,16),(-3,-7,14),(-3,-10,13),(-2,-11,12),(-1,-14,9),(0,-15,7),(0,-16,5),(0,-16,0),(2,-17,-1),(2,-15,-4),(2,-15,-7),(3,-14,-9),(4,-11,-11),(3,-10,-13),(5,-7,-14),(5,-4,-16),(5,0,-16),(5,1,-16),(5,4,-15),(5,7,-15),(4,10,-13),(4,11,-12),(3,14,-9),(2,15,-7),(0,15,-4),(5,0,-5),(6,0,-1),(-1,18,-1),(-3,17,2),(-3,18,4),(-5,16,7),(-5,14,10),(-6,13,12),(-6,9,14),(-6,-2,0),(-2,-5,2),(0,-18,11),(-4,6,11),(-4,3,12),(-4,0,13),(-4,-1,12),(-3,-3,12),(-3,-6,11),(-2,-7,11),(-2,-9,9),(-1,-11,7),(0,-11,5),(0,-12,4),(1,-13,0),(1,-13,-1),(2,-12,-3),(2,-12,-5),(2,-10,-7),(3,-9,-9),(3,-7,-10),(4,-6,-11),(4,-3,-12),(4,0,-13),(4,1,-12),(5,3,-12),(4,6,-11),(3,7,-11),(3,9,-8),(2,11,-8),(1,11,-5),(0,12,-3),(0,13,-2),(4,0,-21),(4,0,-4),(-2,18,2),(-4,17,4),(-5,15,7),(-5,15,9),(-5,11,12),(-4,-5,3),(0,-16,14),(-3,-15,13),(-3,5,7),(-3,4,8),(-3,2,9),(-3,0,9),(-3,-1,8),(-2,-2,9),(-3,-4,8),(-1,-5,7),(-2,-7,7),(0,-7,5),(0,-8,4),(0,-9,2),(0,-9,0),(1,-9,-1),(1,-9,-2),(2,-8,-3),(2,-8,-5),(2,-6,-7),(3,-5,-7),(3,-4,-8),(3,-2,-8),(3,0,-9),(3,1,-9),(3,2,-9),(3,4,-8),(2,5,-7),(2,6,-6),(2,8,-5),(0,8,-4),(0,9,-3),(-1,9,0),(0,9,0),(7,4,-20),(3,3,-20),(-4,16,4),(-4,15,7),(-5,13,9),(0,-14,16),(-4,-13,15),(3,-8,-5),(2,-7,-4),(6,7,-18),(-3,12,5),(54,310,712),(-2,16,-5),(-3,-19,39),(-35,-27,19),(1,38,26),(-26,2,-2),(-1,-24,-17),(-2,-23,-17),(-1,-23,-16),(-14,0,-15),(69,56,-24),(-27,17,-14),(-14,4,0),(15,28,8),(15,-6,1),(8,130,116),(22,-17,17),(5,-6,14),(-8,-45,-11),(-37,-19,15),(-2,-37,-27),(-26,-12,-13),(-32,-5,4),(-32,-2,2),(30,-14,-19),(0,-8,-6),(0,-21,-8),(0,-9,-5),(-2,-22,-15),(-2,-23,-23),(-2,23,-22),(-10,3,1),(-10,6,6),(-2,19,14),(1,15,12),(1,19,14),(1,14,10),(3,13,8),(0,12,6),(85,66,-25),(1,56,48),(-11,11,20),(16,-3,3),(25,-19,13),(-69,-17,28),(15,-20,0),(-2,-26,-14),(-1,-21,-19),(-2,-22,-16),(-32,0,7),(-1,-23,-14),(-32,-2,3),(-24,-9,12),(-1,-8,-5),(-4,-18,-14),(26,11,-15),(0,-9,-5),(0,-21,-9),(0,-9,-5),(-1,-23,-15),(-5,-23,-22),(-11,6,-4),(-11,5,4),(-1,22,16),(-1,10,4),(1,8,5),(2,5,6),(-25,-21,16),(25,33,-8),(-1,10,4),(0,7,4),(3,3,5),(-2,10,4),(2,4,4),(-1,7,2),(0,6,4),(3,6,5),(33,18,-17),(-1,10,5),(2,11,9),(0,18,9),(3,22,16),(1,32,20),(3,10,9),(13,1,2),(8,-2,0),(1,-24,12),(-2,-29,-14),(-1,-20,-18),(0,-9,-4),(-32,0,2),(0,-26,-9),(-25,-8,12),(-15,-10,12),(-2,-28,-14),(-1,-9,-4),(-5,-23,-14),(0,-7,-6),(18,18,-14),(0,-23,-7),(1,-8,-7),(-3,-25,-12),(-6,-26,-20),(-11,1,-3),(-10,3,3),(0,24,14),(-2,9,4),(0,7,5),(-17,-25,15),(3,7,6),(2,16,4),(17,23,-12),(-2,10,4),(0,7,4),(2,4,4),(-1,11,3),(2,4,4),(-1,8,3),(0,6,3),(3,7,6),(-2,8,1),(25,15,-13),(0,6,3),(3,3,5),(0,9,4),(-2,8,3),(1,11,6),(3,14,11),(0,24,15),(0,14,6),(3,10,8),(13,0,2),(11,-10,2),(0,-29,-14),(-3,-22,-17),(-25,-6,11),(0,-9,-4),(-17,-7,15),(-43,-10,79),(3,-41,-15),(-2,-40,-16),(-1,-9,-4),(-6,-30,-14),(0,-17,-7),(2,-31,-11),(43,54,-71),(1,-8,-6),(-3,-29,-13),(-7,-30,-19),(-10,1,-2),(-11,4,3),(1,26,13),(-3,9,4),(-41,-70,71),(0,11,5),(3,11,6),(1,20,5),(-2,14,3),(42,57,-69),(0,8,4),(2,5,4),(-1,12,4),(2,5,4),(-2,8,2),(1,7,3),(2,9,6),(-1,8,2),(0,8,2),(19,13,-12),(2,5,4),(0,9,5),(-1,8,2),(1,11,6),(4,16,10),(0,25,14),(0,15,7),(4,11,9),(13,1,1),(8,-6,0),(0,-31,-13),(-15,-3,13),(-4,-27,-15),(-44,-9,77),(-38,-9,108),(0,-10,0),(3,-53,-17),(-2,-54,-17),(-1,-9,-3),(-8,-41,-16),(0,-19,-6),(0,-43,-11),(-24,-44,99),(25,36,-103),(41,58,-107),(-3,-41,-15),(-8,-42,-20),(-9,0,-2),(-10,5,2),(2,32,14),(-44,-80,103),(-2,15,7),(1,10,3),(3,12,6),(2,36,6),(-2,16,2),(1,14,2),(42,58,-100),(2,8,3),(-2,16,4),(3,9,3),(-2,12,2),(1,10,3),(3,13,7),(-2,11,2),(0,12,2),(4,9,3),(39,21,-67),(0,10,6),(-1,9,2),(1,14,6),(5,18,10),(3,26,14),(1,16,8),(3,13,8),(12,2,2),(8,-5,0),(-43,14,81),(0,-45,-15),(-36,4,109),(-25,13,102),(-6,-64,-18),(0,-10,-3),(2,-64,-16),(-3,-64,-18),(-1,-10,-2),(-6,-60,-18),(-1,-10,-2),(-5,-10,22),(1,-59,-15),(0,-8,-3),(5,10,-22),(-2,-63,-18),(24,55,-100),(-9,-56,-20),(-9,1,-2),(-11,6,1),(-25,-67,99),(0,31,21),(-2,16,7),(0,12,6),(4,14,6),(2,44,3),(-2,17,3),(1,15,2),(3,14,2),(27,54,-106),(-1,22,3),(4,14,2),(0,12,2),(0,13,1),(3,16,6),(-2,15,1),(1,12,2),(4,15,4),(1,31,10),(35,9,-98),(-2,11,2),(2,14,4),(4,17,7),(-2,23,15),(0,18,6),(1,13,5),(4,8,5),(1,25,15),(11,3,3),(-35,14,112),(8,-4,0),(-24,24,103),(-9,-7,34),(1,-68,-23),(-5,-63,-22),(0,-10,-3),(2,-67,-16),(-3,-66,-18),(-1,-8,-4),(-6,-63,-16),(-14,-38,55),(0,-8,-7),(0,-65,-6),(0,-8,-7),(-3,-71,-9),(16,50,-72),(-5,-58,-38),(-9,0,-2),(-27,-76,112),(-10,9,-1),(0,32,29),(-2,15,8),(0,12,6),(4,12,5),(1,43,1),(-2,15,3),(0,15,4),(3,14,2),(0,31,-7),(28,74,-114),(5,13,2),(-2,15,0),(1,14,1),(3,19,1),(-2,14,0),(0,15,1),(4,18,3),(1,37,6),(-2,13,1),(27,32,-84),(1,22,7),(5,15,7),(0,26,13),(-2,13,5),(1,16,7),(5,12,5),(0,38,23),(-24,25,102),(11,2,6),(-10,-7,35),(-10,-28,25),(9,-5,0),(-1,-73,-12),(-7,-70,-10),(2,-6,-8),(1,-67,-13),(-3,-67,-12),(1,-9,-7),(-7,-33,17),(-10,-59,-8),(1,-6,-8),(1,-65,-5),(1,-7,-7),(-3,-65,-10),(-9,-65,-16),(-14,-43,65),(-9,0,-2),(-10,9,-1),(-1,24,51),(-3,11,7),(0,11,6),(4,10,4),(1,25,-1),(-2,11,4),(0,11,5),(3,11,4),(0,34,-9),(3,12,5),(-1,-80,57),(18,166,-145),(-2,14,2),(0,12,1),(4,23,-3),(-2,13,2),(0,13,3),(3,20,1),(1,39,0),(-2,13,1),(1,20,1),(30,73,-104),(4,21,7),(0,27,10),(-1,18,6),(1,19,7),(2,13,10),(-5,73,72),(-11,-28,26),(-10,-55,19),(10,0,8),(10,-4,0),(0,-66,-15),(-6,-64,-12),(2,-4,-8),(1,-64,-10),(-1,-66,-11),(-11,-53,38),(0,-6,-8),(-10,-60,0),(0,-6,-6),(2,-61,0),(0,-7,-7),(-4,-61,-4),(-3,-20,29),(-9,-52,-8),(-10,0,-2),(-9,9,-1),(2,-1,32),(1,6,23),(-2,2,8),(1,5,7),(3,7,6),(0,11,8),(-3,8,6),(0,9,4),(4,13,3),(0,16,5),(10,-9,8),(9,-2,0),(-22,41,-8),(2,78,-55),(0,11,2),(8,28,-8),(-2,12,2),(0,13,3),(3,14,3),(2,34,-7),(-3,14,4),(-1,16,5),(3,13,5),(17,100,-87),(0,27,3),(-2,14,5),(1,18,6),(3,16,3),(-7,8,46),(10,-1,8),(10,-2,-1),(0,-64,-9),(-6,-61,-5),(2,-4,-9),(1,-61,-3),(-3,-64,21),(-3,-56,-1),(-3,-2,-7),(-7,-51,1),(0,-6,-7),(2,-49,1),(0,-8,-6),(0,-23,31),(-1,-35,-4),(-8,-46,-6),(-10,0,0),(3,6,24),(1,14,21),(0,11,10),(0,29,13),(10,0,0),(0,29,5),(0,30,3),(-10,1,0),(-9,9,-9),(0,32,-5),(0,16,-2),(1,21,-3),(4,22,-4),(0,33,-6),(-3,23,-3),(2,25,-5),(3,28,-4),(2,41,-6),(-1,20,-4),(2,25,-5),(5,30,-8),(10,-3,8),(10,-1,0),(0,-54,-7),(-5,-51,-4),(0,-3,-8),(0,-74,25),(2,-37,-4),(-4,-36,-2),(-2,-16,-2),(-5,-31,-2),(0,-13,-2),(4,-33,-2),(0,-12,17),(-1,-28,-2),(-6,-47,-3),(1,14,21),(0,11,10),(0,39,6),(0,40,6),(0,40,4),(-9,2,0),(4,59,-9),(1,35,-6),(1,77,-12),(4,41,-6),(9,-1,0),(1,-44,-6),(-1,-37,-3),(-1,-57,8),(3,-28,-1),(-4,-37,-2),(-7,-40,-1),(0,-36,10),(0,-1,9),(1,64,6),(3,63,4),(1,34,-6),(1,77,-12),(4,-42,-2),(-3,-129,9),(742,41,-10),(4,28,0),(0,33,-11),(-5,-36,-4),(-1,-38,-2),(0,-16,0),(0,-11,16),(24,-58,31),(3,13,1),(-13,-37,6),(-10,-1,0),(20,11,-8),(5,82,-61),(-2,13,4),(3,12,4),(2,10,0),(-4,30,-8),(4,12,3),(0,-70,53),(-7,-17,4),(-1,-32,4),(-10,-9,8),(-9,-1,-1),(0,-29,-4),(0,20,-6),(0,-24,-22),(-5,65,9),(4,-68,0),(0,-13,8),(0,-9,7),(10,1,0),(10,9,-7),(3,66,-48),(-9,88,-88),(1,32,-6),(0,14,1),(3,14,3),(0,13,1),(-4,23,-4),(3,13,3),(0,12,2),(11,-85,86),(0,-62,47),(-17,-47,14),(-9,0,0),(3,60,-10),(-4,-63,-4),(-1,134,-17),(-2,38,-8),(4,-35,-5),(-3,51,-17),(-1,-3,-10),(0,-54,-3),(1,-56,-2),(1,-5,-7),(2,-51,4),(-1,-27,23),(0,-14,0),(0,-5,17),(-6,-39,-3),(0,-28,-3),(6,-47,-3),(-1,13,21),(0,11,10),(10,0,0),(14,27,3),(2,67,-50),(-9,85,-86),(-23,82,-118),(-2,14,2),(1,25,-2),(-1,15,1),(2,15,0),(0,13,1),(-3,20,1),(2,14,0),(-2,13,3),(-3,17,2),(24,-75,117),(13,-89,85),(0,-54,40),(-10,-7,8),(0,34,-6),(-10,-1,0),(-4,76,-11),(-1,43,-6),(-3,76,-17),(-2,-52,-8),(-2,78,-18),(4,-61,-5),(-1,-4,-10),(-3,-61,-4),(4,-64,-6),(0,-5,-8),(4,-62,1),(0,-6,-6),(1,-43,27),(-4,-49,1),(-1,-19,25),(0,-11,-1),(1,-35,-4),(6,-47,-6),(9,0,0),(-2,7,24),(-1,13,21),(13,3,-11),(-3,7,7),(0,11,8),(4,7,5),(3,66,-50),(-10,82,-86),(-22,80,-117),(-25,58,-107),(0,13,3),(-3,13,4),(2,22,2),(-3,14,2),(4,14,0),(0,13,2),(-3,16,6),(1,14,2),(0,12,2),(-4,15,4),(0,30,11),(23,-35,87),(24,-73,108),(12,-94,80),(3,-53,41),(3,22,-4),(-1,25,-4),(-6,25,-2),(-11,-4,7),(-1,43,-5),(-3,78,-18),(-2,89,-16),(-10,-1,-1),(-9,62,-15),(-1,-67,-14),(4,-63,-12),(-2,-4,-9),(-3,-65,-10),(3,-64,-13),(0,-5,-8),(6,-61,-9),(-3,-6,-6),(-2,-64,-4),(8,-52,52),(0,-7,-6),(3,-31,28),(1,-51,-4),(7,-52,-8),(10,0,-1),(9,9,-1),(-3,-1,32),(-1,6,23),(2,2,7),(4,39,-36),(0,10,6),(-4,11,4),(-1,25,-2),(-10,78,-84),(-22,79,-117),(-25,58,-107),(-34,64,-105),(2,14,5),(0,12,4),(-2,8,3),(2,15,4),(-3,10,3),(1,11,3),(0,10,3),(-1,14,6),(2,11,2),(-1,10,3),(-3,9,4),(1,14,7),(2,10,2),(35,-9,100),(23,-33,86),(24,-74,107),(9,-91,84),(0,13,5),(-2,14,6),(0,20,8),(1,20,-4),(0,25,-5),(-5,31,-9),(-2,88,-16),(-8,63,-13),(-11,1,7),(-9,56,-20),(-10,-4,-1),(0,-73,-12),(5,-70,-10),(-2,-6,-8),(-3,-67,-13),(2,-67,-12),(1,-8,-9),(7,-63,-11),(-1,-8,-7),(-4,-67,-5),(-1,-7,-5),(5,-26,18),(2,-65,-9),(9,-48,59),(8,-61,-11),(10,0,-2),(9,8,0),(0,24,50),(-9,53,-87),(3,15,8),(0,11,6),(-4,13,4),(-21,77,-119),(-25,67,-111),(-36,79,-103),(-37,66,-70),(-1,16,5),(3,11,5),(0,7,4),(-3,6,4),(2,12,3),(-2,5,4),(2,8,3),(0,7,3),(-2,9,5),(2,9,2),(-1,7,4),(-2,6,4),(0,10,5),(2,8,2),(0,13,6),(36,-17,69),(36,-1,103),(23,-35,84),(23,-73,105),(-3,15,4),(0,28,3),(2,13,5),(0,19,6),(-4,16,3),(-11,127,11),(-9,28,-25),(-11,2,6),(-9,-5,0),(-2,-68,-23),(3,-63,-22),(0,-9,-3),(-3,-68,-16),(1,-65,-18),(0,-9,-5),(8,-61,-17),(0,-9,-5),(-6,-60,-15),(0,-9,-4),(1,-64,-20),(13,-51,72),(12,-84,2),(9,0,-3),(10,8,-1),(-20,77,-111),(0,31,21),(3,15,8),(0,13,5),(-25,68,-110),(-37,81,-104),(-37,69,-71),(-16,27,-14),(-3,6,6),(-1,14,6),(2,10,4),(0,7,4),(-2,4,4),(1,11,4),(-2,4,4),(2,8,3),(0,6,3),(-3,7,5),(2,8,3),(0,6,3),(-3,4,4),(0,10,4),(2,7,3),(-1,12,6),(-3,15,10),(17,-6,14),(37,-19,66),(35,-3,102),(23,-27,85),(0,27,9),(2,18,7),(-1,19,7),(-3,13,10),(-3,80,38),(-11,2,6),(-9,-5,-1),(-1,-69,-18),(4,-63,-18),(0,-10,-3),(-4,-65,-17),(2,-63,-17),(1,-10,-3),(7,-59,-19),(0,-10,-3),(-4,-59,-14),(0,-10,-3),(1,-64,-17),(8,-67,-21),(8,0,-2),(-22,68,-99),(10,6,2),(-1,34,13),(3,16,5),(-37,79,-106),(-38,72,-70),(-15,28,-15),(-24,23,-17),(-1,8,5),(-2,6,6),(0,11,8),(1,10,4),(0,7,4),(-2,3,4),(2,10,5),(-2,4,4),(1,7,2),(0,6,3),(-2,6,7),(1,8,2),(0,6,3),(-2,3,4),(0,9,5),(2,7,3),(-1,12,6),(-3,14,11),(0,23,15),(23,-11,12),(14,-5,15),(42,-21,67),(33,0,100),(2,13,5),(-1,16,7),(-4,13,5),(-1,37,23),(-11,3,3),(-10,-5,0),(0,-58,-17),(4,-52,-20),(0,-10,0),(-4,-53,-17),(3,-53,-18),(1,-9,-3),(4,-43,-15),(0,-19,-6),(-4,-43,-12),(0,-10,-3),(2,-52,-17),(7,-56,-20),(-37,86,-106),(10,0,-2),(10,5,3),(-1,33,12),(-38,74,-70),(-16,28,-14),(-22,22,-18),(-32,24,-22),(0,15,11),(-1,20,15),(-1,13,9),(-2,14,9),(0,11,7),(0,10,9),(2,11,4),(-2,11,10),(1,18,9),(-3,21,15),(0,32,20),(34,-16,16),(22,-10,13),(14,-4,15),(42,-19,66),(-1,12,5),(-4,9,4),(0,25,15),(-12,2,2),(-10,-5,0),(0,-45,-17),(3,-39,-18),(0,-10,-1),(-4,-41,-16),(2,-40,-16),(0,-9,-4),(4,-30,-14),(0,-19,-7),(-3,-31,-11),(-1,-9,-5),(0,-40,-14),(-36,70,-72),(7,-31,-19),(9,1,-2),(11,4,3),(-16,29,-15),(-25,25,-20),(-32,27,-22),(-64,59,-37),(-14,29,8),(-6,73,66),(-1,56,49),(12,10,20),(66,-23,37),(34,-17,15),(21,-9,14),(14,0,14),(-13,2,1),(-9,-5,0),(0,-34,-15),(2,-27,-15),(0,-9,-5),(-2,-30,-11),(1,-28,-15),(1,-9,-4),(5,-23,-14),(-1,-7,-6),(-2,-27,-8),(-2,-6,-7),(-14,21,-13),(2,-25,-13),(6,-26,-20),(11,0,-3),(-26,22,-21),(-31,27,-23),(-69,61,-31),(-14,27,9),(-6,131,116),(10,12,20),(61,-20,37),(8,1,0),(34,-16,15),(20,-9,12),(-9,-5,0),(0,-31,-14),(2,-23,-16),(0,-9,-5),(-2,-27,-10),(2,-24,-14),(1,-9,-6),(3,-19,-13),(-1,-7,-7),(-1,-22,-7),(-24,12,-17),(0,-8,-4),(1,-24,-15),(3,-23,-22),(-29,28,-28),(-20,-9,9),(-67,58,-26),(-11,22,6),(-5,136,121),(7,10,17),(68,-20,30),(17,-7,7),(32,0,3),(0,-29,-15),(1,-22,-17),(0,-8,-5),(0,-26,-10),(1,-23,-15),(1,-8,-6),(2,-17,-16),(0,-7,-5),(-33,3,-5),(0,-21,-9),(0,-8,-5),(1,-23,-15),(2,-22,-22),(-31,13,1),(-66,62,-29),(-9,146,131),(65,-23,31),(2,-24,-12),(33,9,4),(1,-21,-17),(0,-8,-5),(0,-26,-11),(1,-22,-15),(0,-8,-6),(0,-16,-16),(-30,0,-5),(1,-24,-17),(0,-22,-16),(-26,7,7),(-35,29,-20),(-5,103,86),(36,-20,16),(25,-3,-6),(1,-24,-17),(0,-23,-17),(-24,-24,-14),(-2,37,28),(-163,436,19),(-6,-22,24),(37,-12,-35),(3,-15,-25),(-5,-17,-2),(-37,-3,-16),(-14,-2,0),(44,23,9),(-56,61,7),(13,4,12),(-4,-14,19),(-3,-13,16),(-4,-14,15),(-3,-13,14),(22,-6,11),(-3,-22,24),(31,-25,-10),(3,-36,17),(-8,-10,-14),(-24,-20,-13),(15,67,-96),(-16,-4,0),(-70,58,47),(3,12,-13),(2,8,-12),(6,10,-16),(9,3,-6),(10,2,-1),(6,27,14),(-1,-11,25),(-4,-13,16),(-2,-6,5),(-4,-15,9),(-1,-5,4),(-2,-6,14),(-26,5,7),(0,-4,5),(25,-6,-6),(-1,-12,13),(26,-5,-9),(-2,-12,15),(0,-10,20),(-1,-16,17),(-16,-16,2),(60,-35,-25),(-28,-20,-8),(-14,-1,-2),(11,1,-20),(4,30,-44),(-64,73,19),(1,7,-7),(0,8,-6),(-24,24,16),(0,4,-4),(4,7,-5),(1,7,-8),(-19,25,12),(18,-22,-19),(0,5,-5),(3,7,-6),(4,12,-21),(10,3,-3),(11,6,2),(0,-13,27),(-2,-15,17),(-2,-5,5),(-4,-15,9),(-1,-4,5),(-19,16,16),(1,-10,13),(0,-4,5),(0,-14,15),(15,-13,-15),(-3,-16,11),(25,-5,-8),(0,-5,6),(-1,-9,19),(0,-19,18),(-6,-26,-7),(-7,-1,2),(-10,2,0),(-2,6,-11),(0,19,-26),(0,11,-16),(2,11,-10),(0,5,-8),(2,6,-4),(-22,25,18),(-1,2,-6),(0,3,-3),(2,5,-3),(-1,2,-4),(3,6,-3),(-17,23,12),(-2,1,-4),(1,5,-5),(3,7,-4),(-13,26,6),(-1,11,-8),(-2,4,-7),(14,-29,-7),(1,5,-7),(3,7,-6),(0,15,-20),(10,2,-2),(11,0,2),(3,-16,27),(0,-17,17),(-3,-5,7),(-4,-15,9),(-11,21,12),(0,-4,7),(2,-14,14),(0,-5,6),(-1,-16,16),(-5,-19,14),(10,-13,-16),(0,-5,5),(17,-12,-15),(0,-11,19),(-1,-19,21),(-11,-7,2),(-10,1,1),(-2,5,-10),(1,9,-10),(0,14,-19),(-1,7,-12),(1,6,-7),(2,6,-4),(0,4,-4),(-1,1,-5),(0,4,-2),(-15,19,14),(2,5,-3),(-2,4,-6),(1,3,-3),(2,5,-4),(-2,2,-3),(-12,23,10),(2,8,-6),(-2,3,-5),(0,5,-4),(-35,79,46),(2,11,-7),(0,17,-10),(-2,8,-9),(0,7,-8),(36,-93,-43),(4,6,-7),(0,19,-20),(12,2,-4),(9,0,3),(5,-21,28),(0,-21,20),(-2,-3,7),(-36,79,48),(-3,-24,19),(0,-13,11),(4,-20,21),(0,-6,6),(0,-27,26),(-4,-31,27),(0,-8,3),(31,-33,-85),(2,-17,20),(8,-9,-17),(-2,-20,21),(-7,-4,4),(-11,2,0),(-2,6,-11),(1,10,-11),(0,15,-18),(-1,8,-12),(0,7,-8),(3,5,-3),(0,5,-5),(-3,2,-3),(-11,18,12),(0,4,-4),(2,6,-4),(-1,5,-6),(0,4,-4),(3,6,-3),(-35,65,52),(-3,6,-6),(3,12,-7),(-3,6,-5),(-37,95,69),(0,11,-6),(2,13,-5),(0,33,-15),(-2,8,-7),(0,8,-6),(3,11,-9),(38,-117,-71),(0,25,-23),(13,4,-5),(9,0,2),(5,-33,33),(-1,-30,27),(-38,97,76),(-1,-7,5),(-24,79,74),(20,-116,-53),(0,-16,11),(6,-34,27),(0,-8,6),(0,-43,31),(-5,-48,28),(1,-9,3),(3,-47,26),(35,-15,-84),(-2,-39,30),(30,-4,-102),(-8,-4,4),(-10,2,0),(-1,9,-12),(0,11,-12),(-2,15,-20),(-2,11,-12),(0,9,-8),(3,5,-3),(0,6,-6),(-32,46,61),(-3,6,-6),(0,7,-5),(2,9,-6),(-2,9,-9),(0,8,-5),(-37,72,71),(2,13,-5),(-2,12,-6),(2,19,-6),(-26,93,75),(-2,12,-6),(0,13,-5),(2,14,-6),(-1,39,-13),(-2,11,-8),(0,9,-8),(4,11,-11),(2,20,-31),(24,-99,-66),(11,5,-3),(9,0,3),(6,-43,35),(-25,89,74),(0,-52,29),(-5,18,16),(-1,-7,5),(-4,-50,27),(5,-18,-17),(0,-8,4),(6,-50,36),(0,-7,4),(0,-62,31),(-4,-63,19),(0,-9,2),(2,-60,24),(-3,-61,35),(24,-4,-75),(-8,-5,0),(36,-1,-81),(-11,2,-3),(0,21,-23),(-4,6,-6),(0,10,-10),(2,15,-12),(2,16,-23),(-4,13,-11),(0,11,-9),(2,9,-4),(-36,34,84),(0,26,-19),(-3,12,-8),(0,10,-6),(2,12,-5),(-3,14,-11),(-25,82,70),(0,12,-4),(3,15,-6),(-4,13,-4),(-23,112,81),(1,29,-2),(-2,11,-8),(0,11,-7),(3,12,-7),(-1,38,-15),(-2,9,-10),(1,8,-9),(4,11,-12),(1,20,-40),(11,7,-2),(24,-106,-62),(9,0,2),(0,-39,54),(-14,68,43),(0,-59,30),(-1,-5,7),(-4,-57,24),(0,-4,7),(13,-57,-38),(5,-51,35),(0,-6,6),(0,-63,31),(-4,-67,16),(0,-10,3),(1,-58,26),(-5,-59,37),(-9,-4,1),(8,-19,-24),(-10,0,-7),(25,-1,-74),(0,31,-27),(-3,11,-8),(0,15,-9),(2,12,-7),(0,22,-16),(-3,12,-8),(0,19,-11),(-24,56,57),(2,13,-4),(0,37,-14),(-3,15,-6),(0,13,-6),(2,14,-4),(-25,114,80),(-3,23,-4),(0,10,-5),(3,12,-5),(-11,107,56),(1,96,25),(-4,-86,-35),(2,34,-3),(-2,9,-9),(0,8,-9),(3,7,-9),(-1,24,-8),(-2,8,-9),(0,7,-11),(4,7,-11),(2,4,-59),(11,8,-2),(9,0,2),(11,-64,-34),(5,-54,42),(0,-54,30),(-2,-4,9),(-4,-53,22),(0,-3,8),(6,-54,27),(5,-37,-4),(0,-3,10),(0,-58,29),(-4,-67,17),(-1,-3,8),(4,-74,10),(-2,-72,24),(-10,-4,0),(-11,0,-9),(9,-38,-13),(7,49,-76),(-1,11,-10),(0,17,-8),(3,16,-6),(0,25,-11),(-4,20,-7),(-25,121,84),(0,18,-7),(2,13,-5),(-1,35,-10),(-3,16,-9),(0,11,-6),(-10,108,54),(3,9,-7),(-4,30,-1),(1,8,-6),(1,93,25),(14,36,-9),(10,2,0),(-20,-13,-3),(0,14,-12),(-2,10,-8),(0,7,-9),(3,4,-8),(0,7,-13),(-2,4,-10),(0,0,-9),(2,-1,-8),(-2,-2,-26),(-1,-13,-31),(10,9,-1),(10,0,2),(6,-46,32),(3,-30,-17),(0,-54,28),(-2,-3,9),(-4,-54,19),(0,-3,9),(6,-53,19),(0,-2,9),(8,-64,-18),(0,-53,32),(-5,-58,21),(-1,0,9),(4,-65,14),(-4,-67,17),(-10,-3,0),(-9,-3,-9),(0,64,-33),(-3,17,-3),(0,18,-6),(3,13,-5),(-1,27,-4),(-12,131,57),(-3,10,-10),(1,9,-7),(3,10,-9),(-1,32,-3),(-3,11,-7),(-1,73,23),(0,20,-4),(5,17,-5),(1,31,-6),(10,11,3),(10,1,0),(1,25,-16),(0,24,-16),(-9,0,0),(0,21,-25),(0,7,-14),(0,3,-28),(-1,-3,-26),(10,0,1),(5,-41,28),(-1,-31,18),(0,-33,-20),(-1,-4,10),(-4,-44,16),(0,-3,10),(5,-46,14),(0,-1,10),(1,-48,20),(1,-64,0),(-5,-53,23),(0,0,10),(2,-55,15),(-2,-64,12),(-10,-2,0),(-10,-4,-8),(-3,99,11),(-4,32,1),(0,26,-3),(2,19,-3),(-1,40,-8),(-3,23,-2),(0,23,-4),(3,20,-4),(1,33,-7),(11,70,-7),(11,1,0),(1,34,-20),(1,34,-22),(2,33,-24),(0,6,-13),(0,3,-26),(4,-43,26),(0,-24,13),(-2,-18,-13),(-4,-28,17),(0,-11,6),(4,-27,14),(0,-14,7),(-1,-33,16),(-4,-32,15),(0,-70,0),(0,1,8),(2,-46,20),(-3,-46,21),(-10,0,0),(-2,78,-6),(-1,41,-8),(0,68,-10),(1,34,-8),(10,1,0),(2,56,-27),(1,55,-31),(0,-6,-7),(0,-37,5),(5,-35,17),(-1,-34,16),(-5,-24,10),(0,-54,11),(2,-29,15),(-4,-35,17),(-1,41,-9),(0,68,-10),(8,83,-38),(-3,-119,35),(645,83,-57),(-2,-14,7),(0,-32,17),(3,-30,15),(1,35,-1),(-3,24,-11),(1,34,-15),(29,52,12),(-3,13,-6),(-9,24,-3),(-10,2,0),(0,-21,-25),(0,-36,5),(0,43,3),(0,14,2),(0,-33,21),(0,21,-2),(0,-25,16),(10,-1,0),(10,-12,-4),(0,-31,8),(2,-17,4),(-3,-81,-28),(-3,10,-7),(5,29,-1),(0,9,-7),(-2,9,-8),(3,10,-7),(-3,99,27),(0,13,-11),(-9,12,1),(-9,1,0),(1,21,-26),(0,6,-14),(1,3,-26),(-8,-43,26),(0,-24,14),(4,-46,4),(0,-11,5),(-1,-35,-12),(-7,-45,14),(-1,-1,10),(-2,-48,21),(3,-46,21),(1,2,9),(1,51,1),(-3,-27,14),(2,36,-3),(2,119,-36),(5,4,5),(0,-54,27),(1,58,-13),(10,-2,1),(12,-49,3),(-4,-73,-24),(-13,-106,-56),(0,11,-7),(-2,11,-7),(5,23,-4),(0,11,-6),(-2,11,-6),(2,12,-7),(0,29,-1),(14,111,51),(2,8,-8),(-1,80,20),(-11,23,-16),(0,6,-14),(2,3,-27),(1,-3,-26),(-10,0,1),(-8,-40,28),(0,-31,19),(0,-9,5),(0,-28,-16),(2,-44,16),(-4,-48,-11),(0,-3,9),(-8,-53,20),(0,-1,10),(-3,-55,27),(2,-53,25),(0,0,10),(-5,-55,15),(5,80,2),(1,-45,20),(5,78,-6),(3,41,-9),(3,68,-10),(10,-1,0),(1,32,-8),(9,-11,-5),(-4,-62,-20),(-13,-112,-55),(-26,-117,-87),(3,17,-8),(0,13,-5),(-1,13,-6),(4,19,-7),(0,12,-5),(-1,13,-5),(3,13,-5),(-1,25,-3),(4,12,-4),(26,115,79),(0,11,-6),(13,105,49),(-1,79,20),(-3,5,-8),(1,6,-13),(3,4,-10),(0,0,-9),(-2,-1,-8),(3,-3,-26),(1,-13,-31),(-9,10,-1),(-10,0,2),(-9,-45,33),(-3,-45,24),(-3,-39,-13),(0,-4,7),(-10,-64,-29),(1,-53,23),(0,-3,9),(-9,-52,27),(0,-2,10),(-2,-52,34),(2,-58,21),(1,0,9),(-5,-65,14),(1,-66,18),(9,80,13),(11,-3,2),(5,99,9),(5,78,-6),(3,40,-9),(10,-7,-6),(5,23,-3),(0,23,-4),(-3,19,-4),(-5,-62,-23),(-13,-116,-48),(-27,-118,-84),(-24,-57,-61),(1,26,-19),(4,12,-8),(0,11,-6),(-2,11,-6),(4,13,-11),(0,11,-5),(-2,13,-6),(3,11,-5),(-1,20,-8),(5,10,-6),(0,12,-5),(26,94,77),(-2,14,-5),(25,111,78),(14,100,46),(2,24,-8),(3,8,-10),(0,7,-10),(-3,7,-11),(-1,3,-60),(-10,9,-2),(-9,0,2),(-10,-53,39),(-12,-65,-31),(-3,-54,30),(-5,-28,-8),(1,-5,7),(1,-57,24),(0,-4,9),(-9,-54,31),(0,-4,10),(-3,-57,30),(2,-66,17),(1,-4,9),(-7,-74,10),(0,-71,24),(9,-4,2),(11,70,9),(11,-3,-8),(10,79,14),(5,98,11),(5,31,1),(1,26,-3),(-1,20,-4),(0,15,-15),(3,9,-10),(0,9,-8),(-13,-117,-53),(-28,-120,-84),(-25,-56,-59),(-35,-31,-85),(-2,8,-6),(0,8,-10),(4,6,-6),(0,8,-5),(-2,8,-5),(3,9,-10),(0,7,-5),(-1,9,-5),(3,6,-6),(-2,12,-8),(3,6,-5),(0,9,-7),(-2,11,-7),(40,99,72),(3,31,-12),(26,103,78),(25,109,74),(3,10,-10),(0,8,-9),(-3,11,-12),(0,19,-40),(-10,8,-2),(-9,1,2),(-15,-77,33),(-15,-69,-41),(-2,-50,33),(1,-7,5),(1,-50,29),(0,-6,6),(-9,-50,35),(0,-6,7),(-2,-61,30),(2,-68,18),(-1,-10,3),(-4,-58,26),(1,-59,39),(9,-4,1),(11,0,-7),(11,37,12),(13,133,-25),(4,17,-3),(0,17,-6),(-2,13,-5),(2,27,-5),(3,14,-6),(-28,-122,-84),(-25,-55,-53),(-35,-24,-90),(-30,-38,-68),(0,9,-8),(-2,6,-4),(0,5,-7),(2,3,-4),(0,5,-4),(-2,6,-4),(2,4,-6),(0,5,-4),(-2,5,-4),(2,3,-5),(-2,9,-6),(2,2,-4),(0,5,-6),(-3,8,-6),(2,12,-8),(38,87,44),(3,8,-7),(41,113,70),(26,105,76),(0,9,-8),(-2,12,-11),(1,20,-30),(-11,6,-2),(-9,1,2),(-11,-55,41),(-2,-51,30),(0,-8,4),(1,-49,27),(0,-8,5),(-9,-48,35),(-1,-8,5),(-2,-60,30),(2,-64,20),(0,-9,3),(-6,-60,24),(0,-61,37),(9,-5,1),(11,1,-7),(5,66,-53),(4,10,-10),(0,17,-8),(-1,17,-8),(0,24,-11),(-25,-48,-52),(-36,-23,-88),(-30,-37,-67),(-10,-10,-17),(2,9,-11),(0,6,-8),(-1,6,-4),(0,5,-5),(1,1,-4),(0,4,-3),(-2,5,-4),(2,4,-5),(0,3,-4),(-2,5,-4),(2,2,-4),(-2,8,-5),(2,1,-4),(-1,4,-4),(-2,7,-6),(1,10,-8),(3,3,-6),(14,29,5),(0,6,-6),(39,93,43),(40,113,72),(-2,12,-10),(2,25,-23),(-11,6,-3),(-10,0,3),(-9,-43,35),(-2,-42,27),(0,-7,5),(1,-35,22),(-1,-15,10),(-8,-33,26),(-1,-8,6),(-1,-44,33),(2,-48,28),(-1,-9,3),(-5,-46,27),(0,-52,30),(10,-5,0),(11,1,-4),(1,32,-28),(5,10,-7),(0,15,-10),(-3,11,-7),(-32,-18,-81),(-34,-37,-70),(-10,-9,-18),(-14,-14,-16),(1,14,-18),(2,7,-12),(-1,6,-8),(-1,5,-3),(0,5,-6),(1,1,-3),(0,3,-4),(-2,5,-3),(1,3,-6),(0,3,-3),(-2,5,-3),(2,1,-4),(-3,7,-5),(2,1,-3),(-1,4,-5),(-3,7,-5),(0,6,-8),(2,3,-6),(0,5,-5),(19,26,10),(-2,6,-5),(15,30,5),(38,95,41),(2,25,-23),(-11,4,-5),(-9,0,2),(-9,-32,33),(-1,-31,26),(0,-6,6),(2,-24,20),(-1,-13,11),(-6,-20,21),(-1,-6,6),(0,-26,26),(3,-30,26),(-1,-8,5),(-3,-31,30),(0,-38,32),(9,-4,1),(12,1,-2),(1,20,-23),(4,7,-7),(0,9,-9),(-35,-32,-71),(-9,-9,-19),(-15,-14,-17),(-22,-19,-21),(1,19,-26),(1,10,-16),(-2,11,-10),(1,5,-9),(-3,7,-5),(-1,4,-8),(-1,7,-7),(0,8,-7),(-1,7,-9),(-2,12,-13),(0,8,-11),(24,29,15),(-2,13,-19),(23,28,11),(14,33,3),(-12,2,-4),(-9,1,2),(-7,-21,28),(-1,-21,20),(2,-4,8),(3,-20,13),(0,-3,7),(-4,-14,14),(0,-5,6),(1,-16,16),(3,-19,16),(0,-5,6),(-3,-16,20),(1,-24,24),(7,-4,4),(10,1,0),(-10,-6,-20),(-14,-13,-18),(-23,-20,-20),(-53,-39,-40),(-11,1,-21),(-2,29,-46),(-5,38,-51),(9,21,-10),(53,65,18),(-9,3,-6),(26,31,14),(23,27,12),(-11,1,3),(-5,-16,26),(0,-17,18),(3,-4,6),(2,-17,10),(1,-4,7),(-2,-10,13),(0,-4,6),(0,-14,15),(3,-17,13),(0,-5,6),(-2,-12,19),(0,-20,22),(7,-5,3),(-14,-13,-18),(-24,-20,-21),(-7,1,-1),(-51,-36,-37),(-9,3,-20),(-9,67,-99),(10,20,-10),(49,66,11),(24,35,18),(-1,-12,27),(2,-15,17),(1,-6,5),(4,-15,10),(0,-4,5),(0,-8,14),(0,-4,6),(1,-12,14),(2,-16,13),(0,-5,5),(-2,-11,20),(-1,-18,20),(-25,-3,-12),(-12,-10,-9),(-61,-31,-27),(-7,3,-16),(-12,70,-106),(8,16,-7),(59,60,8),(14,14,9),(1,-11,25),(2,-14,16),(1,-6,5),(4,-14,9),(1,-5,5),(0,-7,14),(1,-4,6),(1,-12,14),(2,-16,11),(0,-5,5),(-1,-9,19),(-28,4,-10),(-1,-16,15),(-60,-34,-25),(-8,76,-116),(56,63,10),(-21,-14,24),(25,1,-5),(2,-14,17),(3,-13,15),(2,-14,14),(2,-13,15),(0,-12,16),(-24,-1,4),(-32,-23,-12),(-9,56,-74),(36,10,37),(4,-21,24),(-0.469,-4.409,4.414)])]),
          fieldValue(name='texCoord',
            children=[
            TextureCoordinate(point=[(0,0),(0,0),(0,-4),(0,1),(0,3),(0,1),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,-1),(0,-1),(0,0),(0,-2),(-1,-2),(-2,-2),(-1,0),(2,1),(0,0),(2,2),(0,2),(0,2),(0,0),(0,1),(0,1),(0,0),(0,0),(0,0),(0,0),(0,0),(0,-1),(0,0),(0,0),(0,-2),(0,-1),(0,-1),(-1,-2),(-2,-1),(-2,-1),(0,-1),(-1,-2),(0,0),(0,0),(2,3),(0,1),(2,1),(2,1),(0,2),(-1,1),(0,1),(0,2),(0,1),(0,0),(0,0),(0,0),(0,0),(-134,40),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(-90,-48),(3,-4),(-27,-19),(0,0),(1,-2),(0,0),(2,0),(2,0),(-1,2),(-3,1),(-2,3),(-1,0),(0,0),(0,0),(2,-4),(1,-3),(2,0),(0,-4),(0,0),(0,0),(0,0),(1,0),(1,-3),(2,0),(0,4),(5,1),(-1,2),(0,2),(-1,3),(-8,2),(-1,3),(0,1),(-3,0),(0,-1),(-1,0),(0,0),(0,0),(2,0),(1,-3),(2,-4),(3,-1),(1,-2),(1,-4),(0,-4),(-3,0),(-1,0),(0,0),(0,0),(0,-4),(2,0),(3,0),(5,3),(0,4),(3,1),(0,2),(0,2),(2,0),(0,1),(-3,1),(0,2),(0,2),(-5,2),(0,1),(0,2),(-10,3),(-3,0),(-1,0),(1,-3),(0,0),(0,0),(1,0),(4,0),(0,-2),(1,-3),(8,-2),(1,-3),(0,-2),(1,-2),(0,-3),(0,-4),(-6,-3),(-3,0),(-1,0),(0,0),(0,-5),(4,-28),(-2,4),(-2,9),(0,6),(0,6),(0,0),(0,4),(2,0),(3,0),(6,5),(3,2),(0,2),(2,2),(0,2),(0,2),(2,0),(0,1),(0,2),(0,1),(-2,1),(0,1),(0,1),(-4,2),(0,2),(0,2),(-5,2),(-11,5),(-3,0),(0,0),(0,2),(4,13),(-4,-4),(-1,-3),(0,-4),(1,-3),(0,-2),(0,-3),(0,0),(2,0),(3,-1),(10,-3),(0,-2),(0,-1),(4,-2),(0,-2),(1,-2),(0,-2),(0,-2),(0,-2),(1,-4),(0,-2),(-4,-2),(-6,-5),(-3,0),(-1,0),(0,-4),(0,-6),(1,-6),(2,-9),(2,-3),(1,0),(0,0),(0,0),(-2,0),(-2,4),(-2,9),(0,6),(1,0),(1,6),(3,1),(7,5),(3,2),(3,3),(0,2),(1,1),(0,1),(0,3),(0,1),(0,4),(0,1),(0,2),(0,1),(-2,1),(1,1),(0,2),(-6,3),(-6,2),(-10,5),(-3,0),(-1,3),(0,0),(1,4),(1,3),(4,4),(3,0),(0,0),(0,0),(-4,-1),(-4,-4),(-1,-3),(0,-4),(1,-3),(0,-2),(1,0),(3,0),(11,-5),(5,-2),(0,-2),(0,-2),(3,-2),(0,-1),(0,-1),(0,-2),(0,-1),(0,-2),(1,-2),(0,-2),(1,-2),(0,-2),(-4,-3),(-3,-2),(-7,-5),(-3,-1),(0,-6),(1,-6),(2,-8),(2,-3),(1,0),(0,0),(0,0),(-2,0),(-2,4),(-1,8),(3,1),(0,6),(8,7),(3,3),(4,3),(1,2),(0,2),(1,2),(0,1),(-1,4),(0,4),(0,3),(0,0),(0,2),(0,1),(0,1),(-3,2),(-5,3),(-7,3),(-10,5),(0,4),(-2,1),(1,3),(4,3),(3,0),(0,0),(0,0),(-4,0),(-4,-4),(-1,-3),(0,-4),(1,-3),(3,0),(10,-5),(6,-2),(5,-3),(-1,-2),(0,-1),(2,-1),(0,-1),(0,-2),(0,-1),(0,-1),(0,-2),(0,-1),(0,-1),(1,-3),(0,-1),(1,-2),(0,-2),(-2,-2),(-4,-3),(-3,-3),(-7,-7),(0,-6),(1,-7),(2,-3),(2,0),(0,0),(0,0),(-3,0),(-1,4),(9,13),(-2,4),(4,4),(4,3),(2,2),(1,2),(1,1),(3,0),(-2,0),(-1,2),(-1,2),(-1,4),(0,4),(1,3),(0,1),(-1,0),(0,1),(-1,1),(0,2),(-3,2),(-6,4),(-5,3),(0,2),(-10,7),(4,3),(3,0),(0,0),(0,0),(-4,0),(-4,-4),(0,-2),(0,-4),(10,-5),(7,-3),(5,-3),(2,-2),(0,-1),(-1,-1),(0,-2),(0,-3),(0,-4),(2,-5),(1,-4),(-1,-2),(-2,-2),(-4,-3),(-3,-4),(3,-4),(3,-1),(1,0),(0,0),(0,0),(-1,0),(2,5),(-1,1),(3,5),(3,3),(1,1),(0,1),(2,0),(1,0),(0,2),(-3,3),(0,5),(-1,4),(0,3),(0,2),(0,1),(-2,0),(0,1),(0,2),(-3,2),(-6,4),(1,2),(-5,3),(4,0),(0,0),(0,0),(-5,0),(-2,-2),(0,-2),(6,-3),(6,-4),(3,-2),(0,-2),(0,-1),(-1,-2),(0,-3),(0,-4),(1,-4),(2,-3),(1,-3),(0,-1),(-1,-1),(-3,-3),(-2,-5),(2,0),(2,0),(0,0),(0,0),(4,6),(-1,0),(2,2),(0,0),(2,0),(2,0),(-4,-12),(-4,-12),(-1,-5),(0,-5),(1,-3),(0,4),(1,4),(1,4),(5,14),(2,12),(0,0),(0,1),(0,2),(0,1),(-1,4),(-1,6),(0,2),(-1,3),(-1,2),(0,1),(-8,34),(3,-10),(0,-6),(-11,10),(-1,0),(0,0),(0,0),(8,-10),(4,-4),(4,-3),(0,0),(2,1),(6,-3),(5,-2),(-12,-5),(-4,0),(0,1),(-2,2),(4,0),(-7,5),(0,0),(0,0),(-5,0),(-1,-2),(7,-4),(2,-2),(0,-2),(0,-1),(0,-1),(-1,-1),(0,-1),(0,-3),(1,-4),(1,-4),(1,-2),(1,-2),(1,0),(0,-2),(0,-2),(0,-1),(-1,-1),(2,0),(0,0),(2,2),(0,0),(2,0),(0,0),(0,0),(-4,-12),(-4,-12),(-1,-5),(0,0),(-1,-5),(0,0),(-1,-6),(0,0),(-1,-15),(2,4),(9,21),(5,18),(2,11),(1,2),(0,1),(0,2),(0,1),(0,4),(0,7),(-1,3),(-1,3),(0,3),(0,2),(0,0),(7,4),(1,3),(-6,2),(-5,5),(1,6),(0,7),(-17,16),(28,28),(-11,0),(-8,-2),(-9,-3),(-8,-5),(-5,-5),(0,-4),(0,-8),(0,-7),(-1,0),(0,0),(0,0),(2,-1),(8,-13),(6,-9),(4,-4),(4,-4),(3,-4),(0,0),(4,-2),(0,0),(0,0),(0,0),(-6,-1),(0,0),(-2,2),(0,0),(-4,0),(2,-3),(0,-1),(0,-2),(0,-1),(0,-2),(1,-3),(1,-4),(0,-5),(3,-3),(0,-2),(0,-2),(0,0),(2,0),(0,0),(-4,-12),(-3,-12),(0,-2),(-1,-4),(-1,-4),(0,-4),(-2,-2),(-1,-16),(0,0),(2,-9),(0,0),(2,3),(13,25),(5,19),(2,8),(5,-6),(0,7),(-3,5),(0,3),(0,4),(3,4),(0,10),(-2,7),(-1,3),(-2,2),(0,1),(4,4),(2,4),(-2,1),(-5,2),(2,5),(2,3),(-10,9),(-18,17),(-11,9),(4,5),(9,4),(10,3),(8,0),(11,-1),(11,-2),(-2,2),(12,-3),(0,0),(-13,4),(-12,2),(-11,0),(-8,-2),(-9,-3),(-8,-5),(-5,-5),(-2,-4),(0,0),(0,-8),(0,0),(0,0),(2,0),(16,-14),(3,-10),(1,-7),(5,-5),(6,-3),(5,-2),(-6,-3),(0,0),(-5,-2),(0,-1),(0,-2),(0,-1),(1,-2),(1,-3),(0,-2),(1,-6),(0,-4),(0,-1),(0,-2),(0,-1),(0,0),(-2,-12),(4,-1),(-5,-18),(-8,-21),(1,-11),(-1,-3),(6,-6),(0,0),(0,0),(1,2),(13,26),(5,18),(4,-7),(4,-6),(0,9),(-2,8),(0,7),(0,3),(-2,7),(1,3),(1,7),(0,10),(0,3),(-2,8),(-1,3),(-1,3),(3,4),(2,3),(-1,3),(-1,1),(2,4),(2,5),(-6,2),(-9,8),(-15,19),(8,3),(10,2),(9,0),(8,0),(14,-1),(10,6),(0,0),(0,0),(0,0),(0,0),(0,0),(1,0),(0,0),(0,0),(2,0),(0,0),(1,0),(6,-1),(-7,-1),(0,0),(0,0),(8,1),(0,0),(7,-1),(0,-1),(-6,-2),(0,0),(0,0),(6,2),(-16,-4),(-6,4),(0,1),(0,0),(0,0),(-10,3),(-13,4),(-12,2),(-11,0),(-8,-2),(-9,-3),(-8,-5),(-5,-5),(-1,-4),(2,0),(12,-10),(17,-16),(-1,-7),(0,-6),(6,-5),(5,-2),(-2,-3),(-6,-4),(0,0),(0,-2),(1,-3),(1,-3),(0,-3),(0,-7),(0,-4),(0,-1),(-1,-2),(0,-1),(0,-2),(5,-8),(-2,-9),(-4,-19),(4,-7),(-12,-26),(5,-2),(0,-1),(0,0),(0,0),(1,2),(12,21),(6,-3),(5,-2),(2,12),(0,8),(0,5),(-3,7),(1,4),(1,7),(-4,6),(2,9),(0,11),(0,6),(-2,8),(-1,4),(3,2),(-1,9),(0,4),(3,4),(4,6),(-2,2),(-6,3),(-7,7),(9,6),(9,2),(10,2),(9,1),(9,2),(18,7),(0,0),(0,0),(-3,-2),(0,0),(0,0),(0,0),(-4,1),(0,0),(0,0),(-3,-5),(0,0),(0,0),(4,-2),(1,0),(-7,2),(-5,2),(-7,3),(0,0),(0,0),(-8,1),(-19,5),(-12,3),(-11,0),(-8,-1),(-10,-3),(-9,-4),(-3,-5),(12,-9),(18,-17),(9,-9),(-3,-3),(-1,-5),(6,-2),(1,-1),(-3,-4),(-3,-4),(1,-1),(2,-2),(1,-3),(1,-7),(-1,-10),(-2,-4),(0,-4),(0,-3),(3,-5),(-1,-7),(-1,-9),(3,-7),(-3,-18),(5,-3),(-11,-20),(-2,-1),(0,0),(0,0),(3,2),(8,1),(8,0),(5,15),(1,9),(1,6),(1,4),(0,5),(-4,7),(0,8),(0,17),(0,12),(-1,9),(-1,9),(1,7),(0,11),(5,5),(7,6),(0,4),(-1,2),(-6,3),(11,3),(9,3),(7,3),(6,2),(4,-2),(11,2),(80,-16),(0,0),(-3,-2),(0,1),(4,3),(0,0),(0,0),(7,0),(0,1),(0,0),(0,0),(0,-1),(0,0),(43,-13),(0,0),(0,0),(-44,14),(-88,14),(-1,4),(-1,3),(2,0),(0,0),(0,0),(-2,-1),(0,0),(1,-1),(-3,1),(0,0),(-3,-5),(0,0),(1,0),(-7,2),(-5,2),(0,0),(-8,0),(-13,1),(-14,1),(-8,0),(-9,-1),(-10,-2),(-7,-3),(16,-19),(9,-8),(5,-2),(-3,-5),(-1,-4),(1,-1),(1,-3),(-3,-3),(-2,-4),(2,-3),(1,-3),(1,-8),(0,-3),(0,-10),(-2,-7),(0,-3),(2,-7),(0,-3),(0,-7),(3,-8),(0,-9),(3,-5),(-2,-12),(-8,-16),(-4,-4),(0,0),(0,0),(11,-1),(8,0),(2,6),(3,12),(1,9),(0,4),(1,4),(6,1),(-4,3),(0,8),(-4,6),(2,16),(0,16),(0,12),(-1,12),(-2,12),(7,5),(5,13),(3,5),(0,2),(8,3),(6,3),(6,2),(11,2),(7,0),(70,-7),(3,-9),(-4,-3),(0,0),(-2,-3),(0,0),(-1,0),(-1,-5),(0,-5),(0,7),(1,4),(4,3),(0,0),(2,-1),(3,2),(1,-1),(7,3),(1,-2),(0,0),(5,1),(0,1),(-1,2),(0,0),(0,0),(0,0),(36,-14),(0,-1),(0,0),(0,-1),(0,0),(0,0),(0,0),(0,0),(0,1),(0,0),(0,0),(0,0),(0,1),(0,0),(0,0),(0,0),(0,0),(0,0),(-1,1),(-1,2),(-1,1),(-2,1),(-3,1),(-3,0),(-4,1),(-4,4),(-4,3),(-8,3),(-8,3),(-8,2),(-11,3),(0,1),(-16,1),(-16,0),(-14,0),(-12,0),(-8,1),(-1,1),(-3,3),(0,0),(0,-1),(-5,0),(-5,-2),(-7,1),(-7,-1),(-9,-2),(-9,-1),(-10,-2),(-9,-2),(-8,-6),(8,-7),(6,-3),(1,-2),(-5,-6),(-2,-4),(1,-4),(0,-9),(-3,-2),(2,-4),(1,-8),(0,-6),(0,-11),(-2,-9),(4,-6),(-2,-7),(0,-4),(3,-7),(0,-5),(4,-6),(-1,-6),(-1,-9),(-5,-15),(-1,-5),(0,0),(8,0),(4,0),(0,0),(2,5),(4,10),(2,11),(1,4),(8,-1),(1,4),(1,8),(-8,3),(0,19),(1,18),(0,16),(0,14),(3,19),(6,13),(2,5),(7,3),(5,2),(11,3),(7,0),(9,-1),(13,-1),(13,0),(17,0),(2,-3),(10,-14),(2,-3),(0,-5),(1,0),(0,0),(0,-6),(-1,0),(0,-6),(0,0),(0,-2),(0,0),(0,3),(0,6),(0,7),(1,3),(2,-1),(3,0),(2,2),(4,-1),(1,2),(0,0),(0,0),(5,3),(6,1),(5,0),(0,0),(0,1),(0,1),(7,-1),(4,-3),(4,-3),(4,-1),(3,-1),(3,-1),(2,-1),(1,-1),(0,0),(0,-1),(0,-1),(1,-1),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,1),(0,0),(-1,1),(0,0),(0,1),(0,0),(0,0),(-1,2),(-1,1),(-2,1),(-3,1),(-3,0),(-4,2),(-4,4),(-4,2),(-8,4),(-9,2),(-3,-6),(0,0),(0,0),(0,-1),(0,0),(-8,-1),(0,0),(0,0),(-3,-3),(1,0),(3,3),(0,0),(6,2),(0,0),(-3,8),(-1,2),(-11,2),(-15,1),(-17,0),(-13,0),(-12,0),(-8,1),(-1,0),(0,0),(-7,-1),(0,0),(-11,-2),(-4,2),(-6,-3),(-7,-3),(-9,-3),(-10,-3),(7,-3),(0,-2),(-1,-4),(-7,-6),(-4,-5),(0,-11),(-1,-7),(2,-9),(0,-9),(0,-12),(0,-17),(0,-8),(4,-7),(0,-5),(4,-5),(-1,-4),(0,-4),(-1,-9),(-3,-12),(-1,-5),(4,0),(6,0),(0,0),(0,0),(3,5),(5,10),(1,8),(9,0),(1,4),(0,3),(0,9),(-1,17),(2,20),(0,21),(0,13),(0,6),(0,19),(6,13),(14,6),(7,0),(10,-2),(13,-1),(14,0),(6,-12),(19,-9),(2,-7),(3,0),(0,0),(0,-6),(0,0),(-1,-3),(-1,0),(-3,-4),(0,0),(0,-2),(1,-3),(0,4),(0,2),(2,0),(3,3),(0,4),(0,6),(0,5),(3,0),(5,1),(2,0),(0,0),(0,3),(0,0),(2,0),(1,2),(3,3),(6,0),(7,0),(6,0),(4,-2),(3,-2),(4,-1),(3,0),(3,-1),(2,-1),(0,-1),(0,-1),(0,-1),(1,-1),(0,0),(0,0),(0,0),(0,0),(0,0),(0,1),(-1,1),(0,1),(0,1),(0,0),(0,1),(-1,1),(-2,1),(-3,1),(-3,0),(-4,1),(-4,4),(-4,3),(-8,3),(-7,2),(2,-5),(0,0),(1,-1),(0,0),(0,-2),(0,-1),(-6,0),(0,0),(-1,2),(-7,-3),(-1,1),(-3,-2),(-2,1),(0,0),(-4,-4),(0,-10),(0,6),(0,0),(2,4),(1,0),(0,0),(2,4),(0,0),(3,3),(-4,9),(-3,4),(0,1),(-16,1),(-16,0),(-14,0),(-12,0),(-8,0),(-1,0),(-7,0),(-11,-3),(-6,-2),(-6,-3),(-8,-3),(0,-2),(-3,-5),(-5,-13),(-6,-5),(3,-12),(0,-12),(0,-12),(0,-16),(-2,-16),(4,-6),(0,-8),(4,-3),(-1,-5),(-1,-5),(-2,-11),(-3,-10),(7,0),(7,0),(-2,-4),(0,0),(0,0),(3,5),(5,9),(8,1),(4,7),(10,0),(6,0),(1,2),(-7,0),(-9,1),(1,3),(1,7),(1,15),(2,20),(0,7),(0,20),(0,13),(0,8),(1,21),(10,1),(13,0),(15,-1),(1,-16),(19,0),(2,-5),(17,-1),(2,0),(-1,-3),(0,-1),(-3,-3),(0,0),(0,-2),(-1,0),(1,-4),(0,0),(1,-6),(0,0),(1,1),(0,6),(0,4),(3,2),(2,3),(1,3),(0,7),(6,0),(1,0),(0,0),(0,1),(0,5),(2,1),(7,1),(6,2),(5,1),(5,0),(4,-1),(4,-2),(3,0),(3,0),(3,-1),(0,-1),(0,-2),(0,-1),(3,-1),(0,-2),(0,-2),(0,-1),(-2,-2),(-2,-1),(-1,-2),(0,-2),(0,0),(0,0),(0,0),(0,0),(0,1),(0,0),(0,2),(2,2),(2,1),(1,2),(-1,1),(0,2),(0,2),(0,0),(0,0),(-1,0),(-1,0),(2,0),(0,0),(0,0),(0,1),(-1,1),(0,1),(0,1),(0,1),(0,0),(-2,1),(-3,1),(-3,1),(-4,1),(-4,3),(-4,3),(-6,0),(0,-2),(0,-1),(0,0),(-6,0),(-6,-1),(-5,-3),(0,0),(0,0),(-1,-1),(-4,1),(-2,-2),(-3,1),(-2,0),(0,-4),(0,-7),(0,-6),(0,-2),(0,0),(1,3),(0,0),(0,6),(0,0),(-1,6),(0,0),(0,0),(0,5),(-3,3),(-10,14),(-2,3),(-17,0),(-13,0),(-13,1),(-9,0),(-7,0),(-11,-4),(-5,-2),(-7,-3),(-2,-5),(-6,-13),(-2,-19),(0,-14),(0,-16),(-1,-18),(0,-19),(8,-3),(-2,-8),(-1,-4),(-2,-5),(0,-9),(8,0),(7,0),(-4,-10),(-2,-4),(0,0),(0,1),(3,4),(9,0),(3,9),(8,0),(9,1),(2,7),(1,2),(0,2),(-5,0),(-7,0),(1,6),(1,14),(1,20),(1,12),(2,18),(0,14),(0,10),(15,1),(15,-2),(19,-5),(15,0),(-1,-4),(1,0),(0,-2),(0,0),(2,-4),(0,0),(-1,-6),(0,-1),(3,-6),(0,0),(0,1),(2,0),(0,1),(-1,6),(0,7),(9,7),(2,1),(0,0),(0,1),(2,0),(0,10),(7,2),(6,2),(5,2),(5,1),(4,-1),(3,-1),(3,0),(3,0),(0,-1),(0,-2),(0,-1),(-2,0),(0,0),(0,0),(3,0),(3,0),(0,0),(0,-2),(0,-3),(-3,-1),(-1,-1),(0,0),(0,-3),(0,0),(0,-3),(0,0),(0,0),(0,0),(0,1),(0,3),(0,0),(0,3),(0,0),(2,1),(2,1),(-1,3),(0,2),(0,0),(0,0),(-3,0),(-2,0),(0,0),(3,0),(2,0),(-1,1),(0,0),(0,1),(0,2),(0,1),(0,1),(-3,1),(-3,0),(-4,1),(-3,2),(-4,1),(-6,0),(-7,0),(-6,-1),(-3,-3),(-1,-1),(-2,0),(0,0),(0,-4),(0,0),(-2,0),(-5,0),(-2,0),(0,-6),(0,-6),(-1,-4),(-3,-3),(-1,0),(0,-5),(-1,4),(0,0),(0,2),(0,0),(4,3),(1,0),(0,4),(0,0),(0,6),(0,0),(-4,0),(-2,7),(-19,9),(-6,11),(-14,0),(-13,2),(-10,1),(-7,-1),(-14,-6),(-5,-13),(0,-19),(0,-6),(0,-13),(0,-21),(-2,-20),(1,-17),(0,-9),(-1,-3),(0,-4),(10,0),(9,-1),(-6,-8),(-3,-9),(-3,-3),(0,0),(1,0),(7,1),(4,4),(9,1),(7,2),(4,7),(3,7),(0,2),(2,3),(1,4),(-11,-1),(1,12),(0,21),(2,14),(5,19),(1,13),(16,0),(17,0),(0,-6),(14,2),(2,-3),(2,1),(0,-6),(0,0),(3,-7),(0,0),(6,-4),(0,1),(0,0),(1,12),(3,1),(4,0),(7,2),(0,14),(6,3),(5,5),(5,3),(3,0),(3,0),(3,0),(0,-1),(0,-1),(1,0),(3,0),(0,-3),(-2,-1),(0,-1),(0,-2),(0,0),(1,-3),(0,-3),(0,0),(0,0),(0,0),(0,1),(-1,3),(0,3),(0,0),(0,2),(0,1),(2,1),(-1,3),(0,0),(-2,0),(0,0),(0,0),(2,0),(0,1),(0,2),(-1,1),(0,2),(-3,0),(-3,0),(-4,2),(-4,0),(-5,-1),(-5,-1),(-6,-2),(-7,-1),(-1,-1),(0,-5),(0,-1),(0,0),(-2,0),(-6,0),(0,-7),(-1,-3),(-2,-3),(-2,-2),(0,-4),(0,-6),(-2,0),(0,0),(0,7),(0,0),(-1,4),(1,0),(0,2),(0,0),(3,3),(0,1),(1,3),(-3,0),(-17,1),(-2,4),(-19,0),(-1,17),(-15,0),(-13,-1),(-10,-1),(0,-21),(0,-8),(0,-13),(-1,-20),(0,-7),(-2,-20),(-1,-15),(-1,-7),(0,-3),(10,-1),(6,0),(-2,-2),(-4,-8),(-3,-8),(-3,-4),(0,0),(9,2),(0,0),(9,2),(17,2),(-8,-1),(2,5),(3,6),(4,7),(0,2),(1,3),(0,5),(0,10),(2,18),(3,17),(1,18),(17,0),(16,0),(3,-8),(2,0),(0,1),(7,-4),(8,-1),(0,1),(0,8),(9,1),(5,4),(0,8),(6,8),(4,6),(3,2),(3,1),(3,0),(0,-3),(0,-3),(1,-3),(0,-3),(0,0),(0,0),(0,0),(-1,1),(0,3),(-1,3),(0,3),(0,3),(0,2),(0,0),(0,1),(0,1),(-1,2),(-3,0),(-3,1),(-4,0),(-5,-2),(-5,-2),(-6,-2),(-7,-2),(0,-10),(-2,0),(0,-1),(0,0),(-2,-1),(-8,-7),(0,-7),(1,-6),(-1,-1),(-2,0),(0,0),(0,0),(-2,7),(1,1),(0,6),(0,0),(-3,4),(0,0),(0,2),(0,0),(1,4),(-16,0),(-19,5),(-15,1),(-14,-2),(0,-10),(0,-14),(-3,-18),(-1,-12),(-1,-20),(-1,-14),(0,-6),(8,0),(4,0),(-1,-2),(-1,-2),(-2,-7),(-3,-8),(-3,-3),(9,1),(0,0),(9,2),(9,2),(9,2),(1,0),(11,3),(3,4),(-11,-3),(-9,-2),(5,7),(4,6),(0,3),(1,2),(2,5),(1,11),(3,17),(2,17),(22,3),(8,1),(8,-1),(10,3),(6,5),(5,12),(4,9),(3,5),(3,2),(1,-4),(0,-3),(0,-4),(0,0),(0,0),(0,0),(0,1),(-1,4),(0,3),(-1,4),(-1,5),(-1,3),(-3,-1),(-3,0),(-5,-3),(-5,-5),(-5,-3),(0,-14),(-8,-2),(-4,0),(-3,-1),(-1,-12),(0,0),(0,0),(-6,5),(0,0),(-3,7),(0,0),(0,5),(-2,-1),(-2,3),(-13,-2),(0,6),(-18,-1),(-16,0),(-1,-13),(-5,-19),(-2,-14),(0,-21),(0,-11),(11,1),(-2,-5),(-2,-3),(0,-2),(-3,-7),(-3,-6),(8,1),(-1,-4),(9,2),(10,2),(11,3),(0,0),(9,4),(0,0),(2,4),(12,5),(-5,-2),(2,4),(-9,-4),(-3,-1),(-9,-3),(4,7),(2,3),(1,2),(3,6),(3,12),(7,17),(10,2),(11,3),(9,4),(7,6),(5,11),(2,3),(3,11),(2,4),(1,-5),(0,-5),(0,-1),(0,0),(0,0),(0,2),(-1,5),(-1,5),(-1,5),(-1,5),(-3,-2),(-4,-6),(-5,-8),(0,-8),(-6,-4),(-8,-1),(0,-8),(-1,0),(-8,2),(-7,3),(0,-1),(-2,1),(-3,7),(-16,-1),(-17,0),(-1,-18),(-3,-17),(-1,-18),(0,-10),(-1,-5),(-1,-3),(0,-2),(-3,-6),(12,1),(-4,-6),(10,3),(11,3),(6,2),(-1,-3),(6,2),(0,0),(0,1),(8,5),(5,3),(1,3),(0,3),(-5,-3),(1,5),(-11,-5),(1,2),(0,2),(2,5),(1,11),(11,3),(12,7),(8,5),(7,9),(7,11),(2,6),(2,6),(0,-6),(0,-1),(0,0),(0,0),(0,2),(-1,6),(-2,8),(-1,4),(-4,-9),(-5,-12),(-6,-5),(-10,-2),(-8,1),(-8,-2),(-22,-3),(-2,-17),(-3,-17),(-1,-11),(-2,-5),(0,-2),(0,-2),(10,1),(-3,-6),(10,4),(3,1),(8,3),(-2,-4),(5,2),(0,-1),(0,0),(5,3),(3,2),(0,0),(0,2),(0,4),(-1,4),(-1,1),(0,3),(15,11),(6,5),(6,8),(7,12),(2,5),(0,-1),(0,0),(0,1),(0,1),(-1,6),(-2,3),(-2,-3),(-5,-11),(-7,-6),(-9,-4),(-11,-3),(-10,-2),(-7,-17),(-3,-12),(-3,-6),(0,-1),(9,2),(0,-1),(11,5),(-1,-5),(5,3),(-1,-4),(0,-2),(3,2),(6,7),(0,0),(0,0),(0,3),(0,3),(0,3),(0,0),(7,6),(6,7),(6,7),(6,12),(0,0),(0,1),(0,1),(0,5),(-7,-11),(-7,-9),(-8,-5),(-12,-7),(-11,-3),(-1,-11),(-1,-4),(14,5),(2,-1),(0,-4),(0,-3),(7,8),(2,3),(0,0),(0,0),(2,3),(2,6),(7,6),(4,8),(0,0),(0,1),(-6,-8),(-6,-5),(-14,-10),(8,1),(1,0),(0,-2),(4,3),(0,0),(2,6),(6,6),(0,0),(-1,0),(-6,-6),(0,0),(-187,181),(3,-1),(2,-1),(2,-1),(2,-2),(1,-2),(1,-3),(0,-2),(0,-3),(0,-2),(-1,-3),(-1,-2),(-1,-2),(-2,-2),(-2,-1),(-3,-1),(-2,0),(-3,0),(-2,0),(-3,1),(-2,1),(-2,2),(-1,0),(0,0),(2,-1),(2,-2),(2,-1),(3,0),(2,0),(3,0),(2,1),(3,1),(2,1),(2,2),(1,2),(1,2),(0,3),(0,2),(0,3),(-1,2),(-1,3),(-1,2),(-2,2),(-2,1),(-2,1),(-3,0),(-1,0),(0,0),(0,0),(2,-1),(3,0),(2,-1),(2,-2),(1,-2),(2,-2),(1,-2),(0,-2),(0,-3),(-1,-2),(0,-2),(-1,-3),(-2,-2),(-2,-1),(-2,-2),(-2,0),(-2,0),(-3,0),(-2,0),(-3,0),(-2,2),(-2,1),(-2,2),(-1,1),(0,0),(0,0),(1,0),(1,-2),(2,-2),(2,-2),(2,-1),(3,0),(2,0),(3,1),(2,0),(3,1),(2,2),(1,1),(2,2),(1,3),(0,2),(0,2),(0,3),(-1,2),(-1,3),(-1,2),(-2,1),(-2,2),(-2,1),(-3,0),(-2,0),(-3,0),(0,0),(0,0),(0,-1),(-2,0),(-2,-1),(-2,-2),(-2,-1),(-2,-2),(-1,-2),(0,-3),(0,-2),(0,-3),(0,-2),(0,0),(0,0),(1,0),(1,0),(0,-2),(2,-2),(2,-1),(1,-2),(3,-1),(2,0),(2,0),(3,0),(2,1),(2,1),(2,1),(2,2),(1,2),(1,2),(0,2),(0,2),(0,3),(-1,2),(-1,2),(-1,2),(-1,2),(-2,1),(-2,1),(-3,0),(-2,0),(-2,0),(-3,0),(0,0),(0,0),(0,0),(-3,-1),(-2,-1),(-2,-2),(-1,-2),(-1,-2),(0,-3),(0,-2),(0,-2),(0,0),(0,0),(1,0),(3,0),(0,-2),(1,-1),(1,-2),(2,-1),(1,-1),(2,-1),(2,0),(1,0),(2,0),(2,1),(2,1),(1,1),(2,1),(1,1),(0,2),(0,2),(0,2),(0,1),(0,2),(-1,2),(-1,1),(-1,2),(-2,1),(-2,0),(-1,0),(-2,0),(-2,0),(-2,0),(-1,0),(-2,2),(0,0),(0,0),(-3,-1),(-2,-2),(-1,-2),(-1,-2),(0,-3),(0,-2),(0,0),(1,0),(3,0),(3,0),(0,-2),(0,-1),(1,-1),(1,-1),(0,-1),(2,-1),(1,0),(1,0),(1,0),(2,0),(1,1),(1,0),(1,1),(1,1),(1,1),(0,1),(0,1),(0,2),(0,1),(0,1),(-1,1),(-1,1),(0,1),(-1,1),(-2,0),(-1,0),(-1,0),(-2,0),(-1,0),(-1,-1),(-1,0),(-2,3),(-2,2),(0,0),(-2,-2),(-2,-2),(-1,-2),(0,-3),(1,0),(3,0),(3,0),(0,1),(1,1),(0,2),(-2,1),(-3,1),(-1,-1),(0,-2),(3,0),(0,-1),(43,10),(-3,-1),(-2,-1),(-2,-1),(-2,-2),(-1,-2),(-1,-3),(0,-2),(0,-3),(0,-2),(1,-3),(1,-2),(2,-2),(1,-2),(3,-1),(2,-1),(2,0),(3,0),(2,0),(3,1),(2,1),(2,2),(1,1),(0,0),(-2,-2),(-2,-1),(-2,-1),(-3,0),(-2,0),(-3,0),(-2,0),(-2,1),(-2,2),(-2,1),(-1,2),(-1,3),(0,2),(0,2),(0,3),(0,2),(1,2),(2,2),(1,2),(2,2),(3,1),(2,0),(1,0),(0,0),(0,0),(-2,0),(-3,-1),(-2,-1),(-2,-1),(-2,-2),(-1,-2),(-1,-3),(0,-2),(0,-3),(0,-2),(1,-3),(1,-2),(1,-2),(2,-2),(2,-1),(3,-1),(2,0),(3,0),(2,0),(3,1),(2,1),(2,2),(2,1),(1,2),(0,0),(0,1),(1,2),(0,2),(0,3),(0,2),(-1,3),(-1,2),(-2,2),(-1,1),(-3,2),(-2,1),(-2,0),(0,0),(0,0),(0,0),(-3,0),(-2,0),(-3,-1),(-2,-1),(-2,-2),(-2,-1),(-1,-2),(-1,-3),(0,-2),(0,-3),(0,-2),(1,-2),(1,-3),(2,-2),(1,-1),(3,-2),(2,-1),(2,0),(3,0),(2,1),(3,0),(2,1),(2,2),(2,2),(1,2),(1,2),(1,0),(0,0),(0,2),(0,3),(-1,2),(-1,3),(-1,2),(-1,2),(-2,2),(-2,1),(-3,0),(0,0),(0,0),(0,0),(-3,0),(-2,0),(-2,0),(-2,-1),(-3,-1),(-1,-1),(-2,-2),(-1,-2),(-1,-2),(0,-2),(0,-3),(0,-2),(1,-2),(1,-2),(1,-2),(2,-2),(2,-1),(2,-1),(2,0),(3,0),(2,1),(2,0),(3,1),(2,2),(1,1),(2,2),(1,2),(0,2),(0,0),(0,0),(0,3),(0,2),(-1,3),(-1,2),(-1,2),(-2,2),(-2,0),(-1,0),(0,-1),(-1,-1),(-2,0),(-2,0),(-2,0),(-2,0),(-1,-1),(-2,0),(-1,-1),(-2,-2),(-1,-1),(0,-2),(0,-2),(0,-1),(0,-2),(1,-2),(0,-2),(2,-1),(1,-1),(1,-1),(2,-1),(2,0),(2,0),(2,0),(1,1),(2,1),(2,1),(1,1),(1,2),(1,1),(0,2),(0,2),(3,0),(0,0),(0,2),(-1,3),(-1,2),(-2,2),(-1,1),(-1,-1),(-2,-2),(-2,-2),(-1,1),(-1,0),(-1,0),(-2,0),(-1,0),(-1,0),(-1,-1),(-1,-1),(-1,-1),(-1,-1),(0,-1),(0,-1),(0,-1),(0,-2),(0,-1),(1,-1),(1,-1),(1,-1),(1,-1),(1,0),(1,0),(2,0),(1,0),(1,1),(2,0),(1,1),(1,1),(0,1),(1,1),(0,1),(0,2),(0,1),(3,1),(2,0),(-1,2),(-1,3),(-1,0),(-2,-2),(-2,-1),(1,-2),(1,0),(2,2),(0,-2),(158,-6),(4,3),(-1,-1),(-2,0),(-3,0),(1,0),(1,-1),(1,-2),(1,-1),(1,0),(2,4),(0,2),(0,0),(-1,1),(0,0),(-8,9),(-1,-1),(0,-1),(0,-3),(-1,-2),(2,-2),(1,-1),(0,-1),(0,0),(1,-1),(1,0),(0,-2),(1,0),(1,-2),(1,-1),(1,2),(0,0),(0,1),(-2,1),(0,1),(-1,1),(-1,1),(0,1),(0,1),(1,5),(-4,4),(-1,0),(-1,0),(-1,-2),(-1,-1),(0,-1),(1,-2),(2,-2),(1,-1),(0,0),(0,-2),(-1,0),(0,-1),(1,-1),(1,0),(1,0),(0,-1),(1,-1),(0,-1),(1,-1),(1,-1),(0,0),(0,1),(-1,1),(0,0),(-1,0),(0,0),(0,2),(-1,1),(0,0),(0,1),(-1,0),(0,1),(0,0),(0,1),(0,0),(0,0),(0,2),(0,1),(-1,0),(-1,2),(-1,1),(-1,2),(-1,0),(0,0),(0,0),(0,-2),(1,-2),(1,-1),(0,-1),(0,0),(0,-2),(-1,0),(0,-1),(1,-2),(1,-1),(1,-1),(0,0),(1,1),(1,-2),(0,-1),(1,-1),(1,-1),(0,0),(0,0),(-1,2),(-1,0),(0,0),(-1,-1),(0,0),(0,1),(0,2),(0,1),(-1,0),(0,1),(0,0),(0,1),(0,0),(0,1),(0,0),(0,1),(0,1),(-1,0),(0,1),(0,0),(-1,1),(0,1),(-1,1),(-1,1),(0,1),(0,0),(0,0),(0,-1),(1,-2),(0,-1),(0,-1),(0,0),(-2,-1),(-4,-1),(1,-3),(1,-3),(0,0),(1,-2),(1,-2),(1,-1),(5,3),(0,0),(1,-2),(1,-2),(0,0),(0,1),(-1,1),(-1,0),(-5,-4),(0,1),(0,1),(0,1),(0,1),(4,4),(-1,1),(0,0),(0,1),(0,0),(-1,1),(0,1),(0,0),(0,1),(0,0),(0,1),(0,1),(0,0),(0,1),(-1,1),(-1,1),(-1,2),(0,1),(0,0),(0,0),(0,-1),(0,-2),(0,0),(0,-2),(-5,-1),(-7,-1),(0,0),(1,-4),(1,-4),(1,-1),(0,-3),(0,-1),(-5,-6),(7,3),(0,0),(8,3),(1,-2),(1,-3),(0,0),(0,1),(-1,1),(-8,-5),(0,1),(0,1),(-1,1),(0,2),(0,1),(0,1),(7,5),(-1,0),(0,2),(0,0),(0,1),(-1,1),(0,1),(0,1),(0,0),(0,1),(4,2),(0,0),(-1,1),(0,1),(-1,1),(-1,2),(0,1),(-1,1),(0,0),(0,0),(-5,0),(0,-2),(-8,0),(-6,0),(1,-5),(0,-1),(2,-4),(1,-5),(0,0),(1,-5),(0,0),(-1,-1),(1,-4),(1,0),(1,0),(1,-4),(8,3),(0,-3),(0,0),(0,0),(-7,-4),(-1,2),(-1,1),(0,1),(-1,1),(0,3),(0,1),(0,1),(0,1),(7,4),(0,2),(0,1),(-1,1),(0,1),(0,1),(0,1),(0,1),(-1,1),(0,2),(7,1),(-1,1),(0,1),(0,1),(-2,2),(0,1),(0,1),(-1,0),(-1,2),(0,0),(-8,1),(0,0),(-8,1),(-1,-1),(2,-5),(1,-4),(1,-1),(1,-5),(1,-4),(0,-1),(1,-4),(-3,-3),(0,-1),(1,-5),(0,0),(1,-4),(5,2),(2,-4),(0,0),(-8,-5),(0,1),(-2,2),(-1,1),(0,1),(0,1),(0,3),(0,1),(0,1),(0,1),(0,3),(7,5),(0,1),(0,1),(0,1),(0,2),(0,1),(0,1),(0,1),(0,3),(0,1),(5,2),(0,2),(-1,1),(-1,2),(0,0),(-1,2),(0,1),(-2,2),(-7,1),(-1,0),(-2,0),(-1,-3),(0,0),(1,-5),(1,-5),(0,-1),(1,-4),(1,-5),(0,-1),(0,-2),(0,-5),(1,0),(0,-5),(1,0),(1,-5),(0,-5),(-5,-2),(0,0),(0,1),(-3,1),(-1,1),(0,1),(0,1),(0,2),(-1,0),(0,1),(0,1),(0,1),(-3,-4),(4,6),(5,7),(0,1),(0,1),(0,1),(0,1),(0,1),(0,1),(0,3),(0,1),(0,2),(7,5),(-1,2),(-1,2),(0,1),(-1,1),(0,1),(-6,4),(-1,-2),(-1,-4),(0,0),(0,0),(1,-5),(1,-4),(0,-1),(1,-4),(0,-5),(-2,-4),(1,0),(0,-5),(0,0),(0,-4),(0,-1),(0,-4),(-1,-2),(0,-3),(0,0),(0,1),(-2,0),(-2,0),(0,0),(-1,1),(0,0),(-1,1),(0,1),(-1,0),(0,1),(0,1),(0,0),(0,0),(1,2),(3,6),(0,1),(0,2),(0,1),(0,1),(0,1),(0,2),(0,1),(0,1),(0,1),(5,8),(0,2),(-1,1),(0,1),(0,1),(-3,0),(0,0),(0,-1),(0,-4),(1,-4),(0,-1),(0,-4),(-1,-5),(0,-4),(1,0),(0,-4),(0,0),(0,-4),(0,0),(-1,-2),(0,-2),(0,-3),(0,0),(-2,1),(-2,1),(0,0),(-1,2),(0,0),(0,2),(0,3),(0,0),(1,0),(0,3),(0,1),(0,2),(0,1),(1,3),(0,1),(0,2),(1,2),(0,3),(0,1),(1,2),(0,1),(0,0),(0,0),(0,-4),(0,-4),(0,0),(-1,-5),(1,-3),(0,-2),(0,-2),(0,-2),(0,-1),(0,-2),(-1,-1),(0,-2),(0,-2),(-2,1),(0,0),(-1,3),(0,3),(0,3),(0,0),(1,5),(0,2),(1,5),(0,2),(0,0),(0,-3),(0,-2),(0,-4),(0,-2),(0,-3),(0,-3),(-1,-2),(0,0),(0,5),(0,4),(0,3),(0,4),(0,-11),(0,8),(-1,-12),(0,0),(0,-1),(0,0),(1,0),(3,6),(0,1),(0,1),(0,1),(0,2),(0,0),(-4,-5),(0,-1),(0,-3),(0,0),(0,0),(0,-2),(1,2),(2,7),(0,2),(0,1),(0,-3),(0,-2),(0,-2),(-1,0),(-1,-6),(0,0),(0,-1),(0,0),(0,0),(0,1),(3,5),(6,6),(0,3),(0,1),(0,1),(0,1),(0,1),(0,1),(0,0),(-6,-6),(-4,-4),(0,-3),(0,0),(1,3),(0,-3),(1,0),(0,9),(1,2),(0,-1),(1,2),(1,0),(0,-4),(0,-4),(0,0),(0,-4),(-2,-2),(0,-1),(0,0),(0,-3),(0,-2),(0,-2),(-2,1),(0,0),(0,0),(0,2),(4,5),(6,6),(7,6),(0,1),(0,2),(0,1),(0,1),(0,1),(0,2),(0,1),(0,1),(0,0),(-9,-6),(-6,-6),(-2,-3),(0,0),(0,2),(0,0),(1,5),(0,3),(2,5),(0,-3),(1,5),(1,-4),(1,-1),(0,-4),(0,-5),(0,0),(0,-5),(0,0),(-1,-3),(-1,-4),(0,-1),(0,-1),(0,-2),(0,-3),(0,0),(-2,1),(-1,1),(0,0),(0,0),(0,1),(0,1),(3,4),(6,6),(9,6),(6,4),(0,1),(0,1),(0,2),(0,1),(-1,1),(0,1),(0,1),(0,1),(0,1),(-1,1),(-1,1),(-6,-2),(-7,-6),(-6,-7),(-2,-2),(0,1),(0,2),(0,1),(0,0),(0,3),(2,6),(1,6),(0,0),(1,4),(1,-5),(1,-4),(0,-1),(1,-4),(1,-5),(1,0),(0,-5),(0,0),(0,-5),(-3,-3),(0,-1),(-1,-2),(0,-4),(0,-3),(0,0),(0,1),(-2,0),(-1,0),(0,0),(1,3),(0,1),(0,1),(1,2),(6,5),(8,6),(8,4),(6,5),(0,1),(0,1),(-1,0),(0,2),(0,0),(0,1),(-1,1),(0,1),(0,1),(-1,0),(0,1),(0,1),(-1,0),(-7,-1),(-6,-2),(-8,-6),(-6,-6),(0,1),(0,1),(0,2),(0,1),(1,2),(0,2),(1,7),(1,4),(0,0),(1,3),(0,0),(1,-5),(1,-5),(0,-1),(1,-4),(1,-5),(1,-1),(1,-4),(0,-1),(0,-5),(0,0),(0,-2),(0,-5),(-4,-3),(0,-4),(0,0),(0,1),(-2,1),(5,4),(0,1),(0,1),(0,1),(8,6),(8,5),(7,6),(5,4),(-1,1),(0,1),(-1,1),(0,0),(0,1),(0,0),(-1,1),(0,1),(0,0),(0,1),(-1,0),(0,1),(0,0),(-1,1),(0,0),(-5,-1),(-7,0),(-6,-3),(-8,-4),(0,1),(0,2),(-1,1),(0,1),(0,1),(0,9),(1,2),(0,0),(0,-1),(2,-5),(1,-4),(1,-1),(1,-5),(1,-4),(0,-1),(2,-4),(0,-1),(1,-4),(1,-1),(0,-5),(-4,-3),(0,-6),(0,0),(0,1),(7,6),(-1,2),(0,1),(0,1),(8,5),(7,6),(5,5),(0,2),(0,0),(-1,1),(0,1),(-1,0),(0,1),(0,0),(0,1),(-1,0),(0,1),(0,0),(0,1),(-1,0),(0,1),(0,0),(0,1),(-1,1),(-1,0),(-1,-1),(-4,-1),(-8,0),(-6,-1),(-1,2),(0,1),(-1,1),(0,1),(-3,5),(0,0),(0,0),(2,-5),(1,-5),(0,-1),(2,-4),(1,-5),(0,0),(2,-5),(0,0),(1,-5),(0,0),(1,-5),(2,-4),(0,0),(6,5),(0,1),(0,2),(0,1),(7,6),(5,5),(1,2),(1,2),(-1,0),(0,1),(-1,1),(0,0),(0,1),(-1,0),(0,1),(0,0),(-1,1),(0,0),(0,0),(0,1),(-1,0),(0,1),(0,0),(-1,1),(0,1),(-1,1),(-1,0),(-1,0),(-1,-1),(-5,0),(-7,0),(0,0),(-1,2),(0,1),(-1,1),(0,0),(0,0),(1,-4),(2,-4),(0,0),(1,-4),(1,-4),(1,-1),(1,-3),(0,-1),(1,-3),(0,-1),(2,-4),(1,-3),(7,6),(0,0),(0,1),(0,2),(5,6),(1,2),(1,1),(0,2),(0,1),(-1,1),(-1,1),(-1,1),(0,1),(-1,1),(0,1),(-1,0),(-1,2),(-1,1),(-1,2),(-1,-2),(-1,0),(-1,-1),(-5,0),(0,1),(-1,0),(0,1),(0,0),(0,0),(1,-3),(2,-3),(0,-1),(1,-3),(1,-3),(0,0),(1,-2),(1,-2),(1,-2),(0,-1),(1,-1),(5,4),(2,-2),(0,0),(0,1),(1,2),(1,2),(2,2),(1,4),(-1,2),(-4,5),(-4,4),(-1,0),(-3,-2),(-1,-1),(-1,0),(0,0),(0,0),(0,-1),(1,-2),(1,-2),(0,-1),(1,-2),(1,-2),(1,-1),(1,-1),(0,-1),(1,-1),(0,0),(1,0),(1,-1),(2,-1),(0,0),(1,1),(2,2),(1,5),(-1,1),(-8,10),(-2,0),(-2,-2),(0,0),(-1,-1),(0,0),(0,-1),(1,-2),(1,-2),(1,0),(0,-2),(1,-2),(1,-1),(1,-1),(0,0),(1,-1),(1,0),(0,-1),(1,-1),(2,-1),(1,1),(0,0),(1,4),(0,2),(-9,9),(-2,0),(-1,-1),(0,-1),(0,0),(1,-2),(1,-1),(0,-1),(1,-2),(1,-1),(1,-1),(1,-1),(0,0),(1,0),(0,-2),(1,0),(1,-2),(1,-1),(0,1),(1,5),(-9,9),(-2,-1),(1,-2),(0,0),(1,-1),(1,-1),(1,-1),(1,-2),(0,-1),(1,-1),(1,0),(1,-1),(0,-1),(0,0),(1,2),(-6,7),(-1,-2),(1,0),(1,-1),(0,-1),(0,0),(1,-3),(-68,-26),(-1,-2),(3,-1),(1,-1),(1,-1),(0,0),(0,1),(-1,1),(0,4),(-1,0),(-2,-1),(-1,-1),(-1,-1),(-1,-1),(-1,-1),(-1,-1),(0,-2),(0,-3),(1,0),(1,-1),(6,5),(0,0),(-3,4),(1,1),(1,0),(1,1),(0,0),(0,0),(-1,2),(-2,-1),(-1,-1),(0,-1),(-1,-1),(0,0),(-1,0),(-1,0),(0,-1),(0,0),(0,-1),(0,0),(-1,-1),(-2,-1),(0,-1),(0,-1),(2,-3),(1,0),(0,0),(1,0),(2,2),(0,5),(0,1),(0,0),(-1,2),(1,0),(0,1),(0,1),(1,-1),(0,1),(1,0),(0,0),(1,1),(0,0),(0,0),(-2,-1),(-2,-1),(0,0),(-1,-1),(0,0),(-1,0),(-1,0),(0,-1),(0,-1),(0,-1),(-1,-1),(0,0),(0,0),(-1,-1),(-1,-1),(1,-2),(0,0),(0,1),(0,0),(2,1),(1,1),(1,1),(0,0),(0,1),(0,2),(0,0),(0,0),(0,0),(0,0),(0,1),(0,2),(0,0),(1,0),(0,1),(0,1),(0,1),(1,0),(0,-2),(1,1),(0,0),(1,1),(0,0),(0,0),(-2,-2),(-1,-1),(-1,0),(-1,0),(0,0),(-1,0),(-1,-1),(0,0),(-2,-2),(0,-1),(1,-1),(0,0),(0,-1),(-1,-1),(-1,-1),(0,0),(0,0),(1,0),(1,1),(1,1),(1,1),(0,0),(0,1),(0,0),(0,0),(0,0),(0,2),(1,0),(0,0),(0,0),(0,1),(0,0),(0,2),(0,0),(0,0),(0,1),(-2,5),(0,1),(1,2),(0,0),(1,0),(3,-6),(1,0),(1,1),(0,0),(-1,0),(-2,-1),(-1,-1),(-1,0),(-3,4),(-2,-1),(0,-1),(-2,-2),(0,0),(-2,-2),(-1,-2),(0,-1),(5,-2),(-1,-2),(1,0),(-1,-1),(0,0),(0,0),(1,0),(0,1),(2,1),(1,1),(0,0),(0,1),(0,0),(0,0),(0,2),(0,0),(1,0),(0,1),(0,0),(0,0),(-3,5),(0,0),(0,1),(0,1),(-4,7),(0,0),(1,1),(1,3),(0,0),(0,1),(1,0),(6,-8),(1,1),(0,0),(-1,0),(-2,-2),(-2,-1),(-5,7),(-5,4),(4,-6),(-1,-2),(-1,-1),(-2,-3),(0,0),(-2,-4),(-2,-3),(-1,-1),(-1,-3),(6,-1),(-2,-3),(7,0),(0,0),(0,0),(1,1),(1,1),(2,1),(0,1),(1,0),(0,1),(0,0),(-4,4),(1,0),(0,1),(0,0),(0,1),(0,0),(-4,6),(1,0),(0,1),(0,2),(-5,6),(0,1),(1,1),(0,1),(1,3),(0,1),(1,0),(1,1),(2,1),(4,-7),(0,0),(0,0),(-3,-2),(-5,5),(-2,-3),(-1,1),(-1,-1),(-1,-3),(1,-2),(0,0),(-3,-4),(0,0),(-2,-5),(-2,-4),(0,-1),(-2,-4),(-1,-4),(5,0),(0,0),(6,0),(0,0),(2,1),(1,1),(0,0),(1,1),(2,2),(0,1),(0,0),(0,1),(-5,2),(2,2),(0,1),(1,1),(0,1),(0,1),(-4,6),(0,1),(0,1),(0,0),(-5,8),(0,3),(0,0),(1,1),(0,1),(1,3),(1,0),(1,1),(0,1),(3,1),(0,0),(4,-8),(0,0),(-4,-2),(-3,4),(-2,-4),(-1,0),(-1,-4),(0,-1),(2,-4),(-2,-3),(-1,-1),(-2,-4),(-1,-5),(0,-1),(-2,-4),(-2,-5),(0,0),(2,0),(0,0),(6,0),(2,2),(0,1),(1,1),(0,1),(1,1),(1,1),(0,2),(-3,4),(0,1),(1,2),(0,1),(0,1),(0,1),(-5,8),(0,2),(0,1),(0,1),(-5,13),(2,-6),(0,1),(1,2),(0,1),(1,1),(1,0),(0,2),(1,0),(1,1),(0,1),(5,0),(0,0),(0,0),(1,-5),(-3,-4),(-2,-4),(0,0),(-2,-4),(-1,0),(-1,-4),(0,-3),(-1,0),(-2,-4),(-1,-5),(-1,0),(0,-6),(-1,-5),(0,0),(1,0),(1,-2),(5,4),(1,0),(0,2),(1,1),(0,2),(0,1),(-5,9),(0,1),(1,1),(0,3),(1,1),(0,1),(-4,7),(0,1),(0,2),(0,1),(-1,6),(1,2),(0,0),(0,0),(1,1),(1,1),(0,0),(1,1),(1,0),(1,0),(0,0),(1,0),(2,-1),(1,0),(0,0),(0,0),(-1,-3),(0,-2),(-2,-4),(-1,-1),(-1,-3),(-1,-1),(-1,-4),(0,0),(1,-4),(-3,-4),(-1,-4),(-1,0),(-1,-5),(0,-4),(0,0),(1,0),(2,4),(0,2),(0,1),(0,1),(0,2),(-3,9),(1,1),(0,1),(1,0),(0,3),(0,0),(-1,6),(0,1),(0,1),(1,2),(0,1),(0,0),(1,2),(1,2),(0,0),(2,1),(1,0),(2,0),(1,0),(0,0),(-2,-3),(-1,-2),(1,-2),(-1,-1),(-1,-3),(-1,0),(-1,-4),(0,0),(-2,-3),(0,-5),(-1,-4),(-1,0),(-1,-4),(0,-4),(0,0),(0,0),(0,7),(0,3),(0,2),(0,1),(1,3),(0,2),(0,1),(0,2),(1,2),(0,5),(0,0),(2,3),(1,2),(2,2),(1,0),(1,0),(-2,-3),(0,-2),(0,-1),(-1,-2),(-1,-1),(-1,-2),(0,-1),(-1,-2),(-1,-2),(0,-5),(-1,0),(-1,-4),(-1,-2),(0,0),(0,5),(1,3),(1,6),(0,2),(0,0),(2,4),(2,3),(0,0),(0,-3),(-2,-3),(-1,-2),(0,-2),(-1,-4),(-1,-2),(0,-1),(0,3),(1,4),(0,-2),(2,9),(0,2),(1,1),(0,1),(0,0),(0,-8),(0,-1),(-1,-2),(0,-1),(0,2),(0,2),(1,2),(1,6),(-1,0),(0,0),(-1,-1),(0,0),(-1,-2),(0,0),(0,-1),(0,-2),(0,-1),(2,-5),(1,1),(0,2),(0,1),(0,0),(0,1),(-1,7),(1,1),(0,1),(0,0),(2,1),(1,0),(1,0),(-2,-3),(-1,-2),(0,-2),(0,-1),(0,-1),(0,-2),(-1,-4),(0,0),(-2,-3),(-1,-2),(-1,0),(0,2),(0,-1),(0,3),(2,8),(-1,0),(-1,-3),(1,3),(0,0),(0,-3),(2,-6),(4,-6),(1,1),(0,0),(0,2),(1,1),(0,1),(0,0),(0,3),(-4,7),(0,1),(0,6),(1,1),(1,0),(2,0),(1,0),(0,0),(-2,-3),(-1,-2),(0,-1),(0,-2),(0,-3),(0,-3),(-1,-1),(-1,-4),(-1,0),(-2,-4),(-1,-4),(-1,0),(-1,-3),(0,5),(-1,-2),(1,6),(0,3),(1,5),(0,0),(0,1),(1,-1),(1,-4),(4,-8),(7,-8),(0,1),(1,1),(0,1),(1,2),(0,1),(0,1),(0,0),(0,2),(0,1),(-5,8),(0,1),(-4,8),(-1,5),(1,1),(1,0),(1,0),(0,0),(1,0),(2,-1),(1,0),(0,0),(0,0),(-2,-3),(-1,-3),(0,-3),(0,-1),(2,-4),(-2,-4),(-1,0),(-1,-4),(-1,0),(-3,-4),(-1,-4),(-1,0),(-1,-5),(-1,-4),(-1,6),(0,0),(0,7),(0,5),(1,3),(1,0),(0,2),(0,1),(0,1),(2,-5),(4,-8),(6,-8),(4,-4),(2,2),(0,1),(1,1),(0,1),(1,1),(0,1),(1,0),(0,1),(0,2),(0,1),(0,0),(-5,7),(0,1),(-6,8),(-2,7),(0,2),(1,0),(1,1),(0,1),(4,0),(0,0),(0,0),(-2,-4),(1,-5),(-1,-4),(0,-2),(-1,0),(-1,-4),(-1,-1),(-2,-4),(-1,0),(-2,-4),(-1,-5),(-1,0),(0,-6),(-2,-4),(0,0),(0,5),(0,0),(-1,5),(0,7),(0,3),(0,2),(0,1),(1,1),(1,1),(0,0),(4,-9),(7,-8),(4,-4),(6,-2),(0,1),(1,1),(1,0),(0,1),(0,0),(1,1),(0,0),(1,1),(0,0),(1,1),(0,1),(0,0),(0,1),(-4,7),(0,3),(-6,7),(-5,8),(1,0),(1,1),(0,1),(2,1),(0,0),(0,0),(-1,-6),(2,-5),(-2,-3),(-1,-1),(-2,-3),(0,-1),(-2,-3),(-1,-1),(-2,-4),(-1,-5),(0,-1),(-2,-4),(-2,-4),(0,0),(0,0),(0,3),(1,9),(0,2),(1,1),(0,1),(0,2),(1,0),(6,-9),(4,-4),(6,-1),(5,-2),(1,0),(0,1),(1,0),(0,1),(0,0),(1,0),(0,1),(0,0),(1,0),(0,1),(0,0),(1,0),(0,1),(0,0),(0,1),(-3,7),(0,0),(-5,8),(-5,8),(1,0),(1,1),(1,1),(0,0),(0,0),(-3,-4),(-2,-4),(0,0),(-2,-4),(0,0),(-3,-4),(0,0),(-2,-5),(-2,-4),(0,-1),(-2,-4),(-1,-4),(0,0),(0,0),(4,5),(1,0),(0,2),(1,1),(1,1),(3,-4),(7,-1),(5,-3),(1,0),(1,1),(0,0),(0,1),(1,0),(0,0),(0,1),(1,0),(0,0),(0,0),(0,1),(1,0),(0,1),(0,0),(1,0),(0,1),(0,0),(0,0),(0,3),(0,0),(-3,7),(-5,8),(1,1),(1,1),(0,0),(0,0),(-3,-3),(-1,-3),(-1,-1),(-1,-2),(-1,-1),(-2,-3),(0,0),(-2,-4),(-2,-3),(-1,-1),(-2,-3),(-1,-3),(0,0),(1,0),(2,2),(0,1),(1,1),(0,0),(6,-2),(5,-2),(1,-1),(2,0),(1,1),(1,1),(0,0),(1,1),(0,0),(0,0),(0,0),(1,1),(0,0),(0,0),(1,0),(0,0),(0,1),(0,0),(1,0),(0,1),(1,0),(0,1),(0,0),(-1,2),(0,0),(0,2),(-2,7),(1,1),(0,0),(-1,0),(-2,-2),(-2,-2),(0,-1),(-2,-1),(0,-1),(-2,-2),(0,0),(-2,-2),(-2,-2),(0,-1),(-2,-2),(-2,-2),(0,0),(0,0),(2,1),(1,0),(0,0),(5,-2),(2,-1),(1,-1),(1,0),(2,1),(1,1),(1,1),(1,0),(0,1),(1,0),(0,1),(1,0),(0,1),(1,1),(0,0),(0,2),(0,1),(0,2),(0,2),(0,0),(-1,0),(-2,-1),(-1,-2),(-1,0),(0,-2),(-1,0),(-1,-1),(0,0),(-2,-2),(-1,-1),(0,0),(-2,-2),(-1,-1),(0,-1),(0,0),(2,0),(1,-1),(2,-1),(3,-2),(1,0),(3,2),(4,3),(0,1),(-1,5),(0,0),(-1,3),(-1,1),(0,0),(-2,-2),(-1,-1),(-1,0),(-1,-1),(0,-1),(-1,0),(0,-1),(-1,-1),(-1,-1),(-1,0),(-1,-1),(-1,-2),(0,0),(1,-1),(2,-1),(0,0),(3,-2),(1,0),(7,5),(0,2),(-1,4),(-1,2),(-2,-1),(-2,-1),(0,0),(-1,-1),(0,-1),(-1,0),(0,-1),(-1,-1),(-1,-1),(-1,0),(-1,-1),(0,-1),(0,0),(1,-1),(2,-2),(1,1),(7,5),(0,1),(0,4),(-1,1),(-2,-1),(-1,-1),(0,-1),(-1,-1),(0,0),(-1,-1),(-1,0),(-1,-1),(-1,-1),(0,0),(-1,-1),(0,0),(0,-1),(2,-2),(7,6),(0,4),(-2,-1),(0,0),(-1,-1),(-1,-1),(-1,-1),(-1,-1),(0,-1),(0,0),(0,-1),(5,3),(-4,0),(2,2),(0.3825,0.252)])])]))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for FishCoded.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python FishCoded.py load and self-test diagnostics complete.")
