package Basic.ExperimentalBinaryCompression;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Fish example with IndexedFaceSet encoding. </p>
 <p> Related links: Catalog page <a href="../../../ExperimentalBinaryCompression/FishCodedIndex.html" target="_blank">FishCoded</a>,  source <a href="../../../ExperimentalBinaryCompression/FishCoded.java">FishCoded.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/FishCoded.x3d">FishCoded.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Fish example with IndexedFaceSet encoding. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Martin Isenburg </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> X3D-Edit VRML importer </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 26-Sep-2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 28 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/ac/models" target="_blank">http://www.cs.unc.edu/~isenburg/ac/models</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/research/asciicoder" target="_blank">http://www.cs.unc.edu/~isenburg/research/asciicoder</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/research/asciicoder/coder" target="_blank">http://www.cs.unc.edu/~isenburg/research/asciicoder/coder</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Martin Isenburg, Jack Snoeyink Binary Compression Rates for ASCII Formats, accepted for Web3D'03, March 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/isenburg/is-bcraf-03.pdf">isenburg/is-bcraf-03.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/research/papers/is-bcraf-03.pdf" target="_blank">http://www.cs.unc.edu/~isenburg/research/papers/is-bcraf-03.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Martin Isenburg, Jack Snoeyink, Coding with ASCII: compact, yet text-based 3D content, Proceedings of the 1st International Symposium on 3D Data Processing, Visualization and Transmission'02 (Invited Paper), pages 609 - 616, June 2002. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/isenburg/is-cwa-02.pdf">isenburg/is-cwa-02.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/papers/is-cwa-02.pdf" target="_blank">http://www.cs.unc.edu/~isenburg/papers/is-cwa-02.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Martin Isenburg, Jack Snoeyink Coding Polygon Meshes as Compressable ASCII, Proceedings of Web3D Symposium'02 (Best Paper), pages 1 - 10, February 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/isenburg/is-cpmca-02.pdf">isenburg/is-cpmca-02.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.cs.unc.edu/~isenburg/papers/is-cpmca-02.pdf" target="_blank">http://www.cs.unc.edu/~isenburg/papers/is-cpmca-02.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D VRML binary compression </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/FishCoded.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/FishCoded.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Martin Isenburg
 */

public class FishCoded
{
	/** Default constructor to create this object. */
	public FishCoded ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("FishCoded.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Fish example with IndexedFaceSet encoding."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Martin Isenburg"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("X3D-Edit VRML importer"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("26-Sep-2002"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("28 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/ac/models"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/research/asciicoder"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/research/asciicoder/coder"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Martin Isenburg, Jack Snoeyink Binary Compression Rates for ASCII Formats, accepted for Web3D'03, March 2003"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("isenburg/is-bcraf-03.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/research/papers/is-bcraf-03.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Martin Isenburg, Jack Snoeyink, Coding with ASCII: compact, yet text-based 3D content, Proceedings of the 1st International Symposium on 3D Data Processing, Visualization and Transmission'02 (Invited Paper), pages 609 - 616, June 2002."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("isenburg/is-cwa-02.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/papers/is-cwa-02.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Martin Isenburg, Jack Snoeyink Coding Polygon Meshes as Compressable ASCII, Proceedings of Web3D Symposium'02 (Best Paper), pages 1 - 10, February 2002"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("isenburg/is-cpmca-02.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.cs.unc.edu/~isenburg/papers/is-cpmca-02.pdf"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D VRML binary compression"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/FishCoded.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("FishCoded.x3d"))
    .addChild(new ExternProtoDeclare("CodedIndexedFaceSet").setName("CodedIndexedFaceSet").setAppinfo("An ASCII-coded IndexedFaceSet").setUrl(new String[] {"CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","CodedCompressedPrototypes.wrl#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CodedIndexedFaceSet"})
      .addField(new field().setName("code").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("ASCII-coded coordIndex and texCoordIndex values"))
      .addField(new field().setName("pos").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("dequantization multiplier for Coordinate values"))
      .addField(new field().setName("tex").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("dequantization multiplier for TextureCoordinate values"))
      .addField(new field().setName("coord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Coordinate node"))
      .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("TextureCoordinate node")))
    .addComments(" ==================== ")
    .addChild(new Viewpoint().setDescription("1M view").setPosition(0.0,0.0,1.0))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setScale(0.025,0.025,0.025)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0))
          .addComments(" modulateTextureWithDiffuse=true by retaining Material and diffuseColor ")
          .setTexture(new ImageTexture().setUrl(new String[] {"fish.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/fish.jpg"})))
        .setGeometry(new ProtoInstance("CodedIndexedFaceSet").setContainerField("geometry")
          .addFieldValue(new fieldValue().setName("code").setValue(getfieldValue_code_6_39_value()))
          .addFieldValue(new fieldValue().setName("pos").setValue(4.884e-3))
          .addFieldValue(new fieldValue().setName("tex").setValue(3.8234e-3))
          .addFieldValue(new fieldValue().setName("coord")
            .addChild(new Coordinate().setPoint(getCoordinate_7_42_point())))
          .addFieldValue(new fieldValue().setName("texCoord")
            .addChild(new TextureCoordinate().setPoint(getTextureCoordinate_7_44_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getfieldValue_code_6_39_value_1()
		{
			int[] value = {24045,3,0,3,1,1,2,0,0,0,0,0,0,3,2,10,0,0,0,10,0,0,6,0,6,0,0,6,0,6,0,0,6,0,6,0,3,2,6,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,0,0,0,0,3,3,1,2,0,6,0,5,3,2,0,6,0,6,0,0,0,6,0,6,0,0,0,3,0,0,6,0,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,0,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,3,1,1,1,2,0,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,3,1,1,1,2,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,5,5,0,0,6,0,5,0,0,5,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,5,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_2()
		{
			int[] value = {6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,3,1,2,0,6,0,6,0,0,6,0,0,6,0,3,2,0,6,0,6,0,6,0,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,5,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,5,0,5,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,5,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,5,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,3,0,0,0,0,3,2,0,6,0,6,0,6,0,6,5,2,0,5,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,6,0,0,0,6,0,5,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,0,6,6,0,0,0,6,0,5,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,1,2,0,5,0,6,0,6,6,0,6,0,0,6,3,2,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,6,0,0,0,6,0,0,6,0,0,0,7,0,6,0,0,0,6,0,6,0,0,0,0,6,5,0,6,6,0,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,5,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,8,0,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,8,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,2,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,7,0,0,0,0,6,0,0,8,0,0,0,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,5,0,0,5,0,6,0,6,0,0,0,0,6,5,0,5,0,5,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_3()
		{
			int[] value = {0,5,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,0,0,6,6,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,8,0,0,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,3,1,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,6,1,2,0,6,0,6,0,5,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,1,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,8,0,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,3,0,0,0,6,0,0,3,2,0,6,0,6,0,6,0,6,0,3,2,0,5,6,0,0,6,6,0,0,0,0,6,0,6,0,0,3,2,0,6,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,0,6,0,6,0,6,5,0,0,6,0,5,0,5,0,0,6,0,5,0,3,0,3,2,0,6,0,6,0,0,6,0,0,3,2,0,0,0,0,0,0,0,0,11,0,11,0,0,6,0,1,1,1,1,1,1,1,1,1,1,2,0,6,6,0,1,1,1,1};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_4()
		{
			int[] value = {1,1,2,0,5,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,6,0,6,6,0,6,6,0,0,0,5,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,5,0,5,0,5,0,6,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,0,0,3,2,0,0,6,0,6,0,0,0,6,6,0,6,1,1,1,2,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,3,2,0,6,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,5,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,5,0,6,5,0,5,0,0,6,0,5,0,0,0,0,0,6,0,6,6,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,3,2,0,0,6,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,5,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_5()
		{
			int[] value = {0,0,6,0,6,0,0,0,0,6,0,0,0,0,6,0,6,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,0,0,6,6,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,5,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,1,1,0,5,1,1,2,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,6,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,6,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,3,2,0,0,6,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,5,0,0,6,0,0,5,5,0,6,0,0,0,5,0,6,0,5,0,5,0,5,0,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_6()
		{
			int[] value = {0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,5,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,6,0,0,0,5,6,0,0,0,0,0,5,6,6,0,0,0,5,5,0,5,0,0,5,5,0,0,6,0,0,5,6,0,0,5,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,7,0,0,0,0,6,0,5,0,6,0,0,5,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,5,5,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,5,5,0,6,0,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,7,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,5,0,5,0,0,6,0,0,5,6,0,0,5,0,0,5,0,6,0,5,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,3,2,0,0,6,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_7()
		{
			int[] value = {0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,5,0,6,0,0,0,5,0,6,0,5,0,0,5,5,0,5,0,0,5,6,0,0,0,0,5,0,6,6,0,0,0,5,6,0,0,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,6,0,0,0,5,0,6,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,5,0,0,5,0,6,0,6,0,0,0,5,0,6,0,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,5,6,0,0,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,5,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,5,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,5,0,0,5,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_8()
		{
			int[] value = {0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_9()
		{
			int[] value = {0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,0,3,1,1,0,5,0,0,5,0,6,0,5,6,0,0,0,6,5,0,0,0,0,6,6,0,0,6,0,6,0,0,6,0,0,0,5,6,0,0,5,5,0,3,2,0,6,0,5,0,6,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,5,0,6,0,0,6,0,0,5,0,5,0,5,0,0,0,5,6,5,0,5,0,0,5,0,0,6,0,6,0,5,0,0,0,6,6,0,0,0,5,0,5,5,0,0,5,5,0,0,0,6,5,0,0,6,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,3,2,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,0,0,6,5,0,0,5,0,5,0,5,0,6,0,0,6,0,0,5,0,6,0,0,5,6,0,0,0,5,5,0,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,0,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_10()
		{
			int[] value = {6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,3,2,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,5,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,3,2,5,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5,0,0,5,5,0,5,0,0,6,0,5,0,5,0,0,5,5,0,6,0,0,0,6,0,5,0,5,0,6,0,0,5,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,5,0,0,5,0,6,0,5,0,5,0,5,0,0,5,0,6,0,5,0,5,0,5,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,5,0,0,6,0,5,0,6,0,0,0,5,5,0,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,0,0,3,0,0,6,0,0,0,5,6,3,3,2,5,0,5,0,0,6,0,6,0,0,0,0,0,0,6,0,6,6,5,0,0,5,0,6,0,5,0,3,1,1,2,0,6,5,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,5,5,0,6,0,0,0,6,0,6,0,0,0,0,6,6,0,6,2,5,5,0,0,5,0,0,6,5,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,0,0,5,6,0,6,0,0,5,0,5,0,0,6,5,0,0,6,0,5,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,5,0,0,5,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,0,0,6,0,6,0,6,0,0,0,0,5,0,6,0,5,5,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_11()
		{
			int[] value = {0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,5,5,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,5,0,5,0,5,5,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,5,5,0,5,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,5,0,0,6,0,0,0,5,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,5};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_12()
		{
			int[] value = {0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,6,0,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,5,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,5,6,0,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,5,5,0,6,0,0,5,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,0,3,0,5,0,0,3,1,2,5,0,0,6,6,0,5,0,6,0,0,5,0,5,0,5,0,0,5,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,5,0,5,0,6,0,6,0,0,5,6,0,0,0,5,5,0,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,0,0,6,5,0,0,6,5,0,0,5,5,0,0,5,0,5,6,0,0,0,0,6,5,0,0,6,0,0,0,6,0,5,5,0,5,0,0,0,5,0,6,5,0,0,0,6,0,5,3,2,6,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,5,0,6,0,0,6,0,5,0,0,5,6,0,0,0,5,0,6,0,0,5,0,6,0,0,6,0,0,5,0,5,0,5,5,0,0,0,6,0,5,0,6,0,0,5,0,6,0,5,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,0,5,0,6,0,0,5,0,6,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,3,2,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_13()
		{
			int[] value = {0,6,0,0,0,6,6,0,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,3,2,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,6,3,2,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,0,5,5,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,5,0,0,5,0,6,0,5,0,5,0,6,0,6,0,0,5,0,0,5,5,0,5,0,0,6,0,5,0,5,0,0,5,5,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,5,0,5,0,5,0,0,6,0,0,5,5,0,5,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,5,0,0,5,6,0,0,5,0,0,6,0,5,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,6,0,0,0,6,0,6,0,0,6,0,0,5,0,5,0,0,5,6,0,0,6,0,0,6,0,0,0,0,3,0,0,0,0,6,0,6,5,3,0,5,0,3,1,1,1,1,2,0,5,0,6,0,5,5,0,0,0,0,6,0,6,0,6,0,6,0,0,0,6,5,0,0,0,6,0,6,0,5,0,6,0,5,0,6,5,0,0,6,0,5,5,2,0,0,5,6,0,0,6,0,6,0,0,6,0,0,6,0,0,0,6,5,0,0,0,6,0,5,5,0,5,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,6,0,6,0,0,5,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,5,0,0,5,6,0,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,5,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,5,5,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,5,0,6,0,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_14()
		{
			int[] value = {5,0,5,5,0,0,5,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,6,0,0,0,5,0,5,0,5,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,0,5,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,5,0,0,5,0,5,0,5,6,0,0,0,5,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,5,5,0,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,0,6,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,5,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,5,0,5,0,6,0,0,0,6,0,0,6,0,0,6,0,0,5,0,6,0,0,6,0,5,0,5,0,5,0,5,0,5,0,0,6,0,5,0,5,0,5,0,0,0,6,6,0,0,0,0,6,0,6,0,6,0,0,0,6,0};
			return value;
		}
		private int[] getfieldValue_code_6_39_value_15()
		{
			int[] value = {0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,6,0,0,6,0,0,0,5,6,0,0,6,0,5,0,0,5,5,0,0,6,0,6,0,0,0,5,0,6,0,6,0,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,6,0,0,0,5,0,5,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,5,5,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,0,6,0,6,0,0,0,0,6,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,0,5,6,0,0,6,0,5,0,0,6,0,5,0,0,6,0,5,0,0,6,0,0,6,0,5,0,6,0,0,0,5,5,0,0,6,0,0,6,0,6,0,0,0,5,6,0,0,5,0,5,0,0,5,5,0,5,0,5,0,5,0,6,0,0,0,0,2};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_7_42_point_1()
		{
			double[] value = {-2.0,-4.0,-1.0,-3.0,-3.0,0.0,-4.0,-47.0,9.0,0.0,-19.0,10.0,0.0,55.0,-19.0,0.0,11.0,0.0,-4.0,1.0,0.0,-3.0,3.0,1.0,-3.0,4.0,1.0,-2.0,6.0,0.0,-1.0,4.0,1.0,0.0,2.0,1.0,14.0,0.0,0.0,0.0,2.0,2.0,13.0,-2.0,-3.0,-2.0,-3.0,-1.0,0.0,-5.0,0.0,8.0,-1.0,2.0,-3.0,-9.0,-2.0,-5.0,-8.0,-1.0,-4.0,-4.0,0.0,1.0,-34.0,8.0,-1.0,-22.0,12.0,1.0,-23.0,25.0,-9.0,-1.0,0.0,0.0,-21.0,37.0,-8.0,23.0,-38.0,0.0,23.0,-25.0,-1.0,22.0,-12.0,1.0,34.0,-7.0,-5.0,5.0,1.0,-4.0,7.0,1.0,-4.0,9.0,2.0,-1.0,8.0,1.0,-1.0,6.0,1.0,1.0,2.0,2.0,23.0,-1.0,0.0,23.0,0.0,0.0,0.0,-3.0,-3.0,-1.0,-6.0,0.0,12.0,-6.0,13.0,-5.0,-19.0,-3.0,-5.0,-17.0,-4.0,-7.0,-13.0,-1.0,-2.0,-24.0,10.0,4.0,-22.0,26.0,3.0,-17.0,35.0,-13.0,-9.0,1.0,-3.0,-37.0,30.0,-7.0,0.0,0.0,-8.0,1.0,-1.0,-3.0,37.0,-30.0,-11.0,9.0,-1.0,3.0,17.0,-35.0,3.0,22.0,-26.0,-2.0,25.0,-9.0,-8.0,12.0,2.0,-5.0,18.0,4.0,-4.0,19.0,3.0,-1.0,17.0,4.0,3.0,3.0,0.0,34.0,-2.0,0.0,35.0,0.0,0.0,2.0,-3.0,0.0,9.0,1.0,18.0,-3.0,-27.0,-6.0,-6.0,-27.0,-6.0,-6.0,-21.0,-5.0,8.0,-18.0,26.0,7.0,-15.0,36.0,1.0,-25.0,32.0,-27.0,-34.0,-6.0,4.0,-7.0,0.0,-13.0,-11.0,0.0,-12.0,0.0,0.0,-12.0,1.0,0.0,-12.0,11.0,1.0,3.0,7.0,0.0,-27.0,34.0,5.0,2.0,26.0,-33.0,8.0,15.0,-36.0,7.0,18.0,-25.0,-8.0,22.0,6.0,-5.0,26.0,6.0,-1.0,29.0,6.0,3.0,3.0,0.0,43.0,-2.0,-5.0,43.0,1.0,6.0,-45.0,682.0,2142.0,0.0,-3.0,4.0,2.0,0.0,0.0,0.0,0.0,-1.0,0.0,4.0,-3.0,-1.0,2.0,0.0,0.0,0.0,-7.0,-1.0,-2.0,0.0,0.0,-10.0,12.0,2.0,0.0,0.0,0.0,0.0,-1.0,0.0,10.0,-12.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_2()
		{
			double[] value = {0.0,-19.0,-33.0,-1.0,1.0,0.0,0.0,-2.0,1.0,0.0,-17.0,36.0,1.0,0.0,0.0,1.0,1.0,0.0,6.0,164.0,1019.0,-1.0,13.0,174.0,-1.0,-20.0,129.0,0.0,-56.0,148.0,0.0,-79.0,130.0,0.0,-76.0,71.0,-3.0,-675.0,-222.0,0.0,-65.0,-65.0,5.0,162.0,11.0,2.0,155.0,40.0,-6.0,-268.0,-56.0,-1.0,162.0,161.0,-2.0,14.0,34.0,-1.0,0.0,0.0,-1.0,0.0,0.0,2.0,-160.0,-125.0,0.0,-66.0,-66.0,0.0,-57.0,-54.0,2.0,0.0,0.0,2.0,26.0,-44.0,3.0,-51.0,-90.0,6.0,-25.0,-97.0,-9.0,-205.0,736.0,-4.0,0.0,-1.0,0.0,-44.0,-19.0,5.0,0.0,0.0,0.0,-1.0,-26.0,1.0,-1.0,-47.0,0.0,42.0,16.0,-2.0,4.0,51.0,-2.0,68.0,30.0,0.0,1.0,25.0,-3.0,0.0,0.0,-4.0,0.0,0.0,-1.0,-69.0,-29.0,0.0,-44.0,-20.0,0.0,-1.0,-26.0,0.0,-56.0,-20.0,0.0,0.0,24.0,6.0,0.0,0.0,5.0,0.0,0.0,0.0,0.0,-25.0,0.0,-64.0,-12.0,2.0,1.0,-43.0,0.0,62.0,10.0,3.0,10.0,-89.0,0.0,42.0,8.0,0.0,31.0,6.0,-3.0,48.0,8.0,-2.0,33.0,127.0,2.0,46.0,15.0,-1.0,24.0,8.0,-2.0,6.0,55.0,0.0,-23.0,-6.0,0.0,2.0,24.0,-5.0,0.0,0.0,-5.0,0.0,0.0,0.0,-3.0,-25.0,1.0,-47.0,-16.0,-2.0,-68.0,-30.0,-1.0,-4.0,-51.0,0.0,-42.0,-16.0,0.0,-56.0,-18.0,0.0,-62.0,-10.0,2.0,-1.0,44.0,1.0,-1.0,25.0,5.0,0.0,0.0,5.0,0.0,0.0,0.0,-87.0,0.0,0.0,2.0,-25.0,2.0,2.0,-45.0,3.0,49.0,-97.0,0.0,63.0,9.0,1.0,12.0,-50.0,0.0,39.0,7.0,0.0,34.0,4.0,-1.0,-6.0,-53.0,0.0,24.0,0.0,1.0,8.0,57.0,-4.0,40.0,0.0,3.0,29.0,-1.0,0.0,22.0,71.0,0.0,20.0,2.0,-2.0,34.0,5.0,-1.0,58.0,155.0,-3.0,7.0,54.0,0.0,1.0,21.0,0.0,-43.0,-10.0,-5.0,0.0,0.0,-6.0,0.0,0.0,0.0,-3.0,-25.0,-1.0,-7.0,-56.0,0.0,-24.0,-8.0,1.0,-46.0,-15.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_3()
		{
			double[] value = {-3.0,-33.0,-127.0,-2.0,-48.0,-8.0,0.0,-31.0,-6.0,0.0,-42.0,-8.0,1.0,-46.0,-9.0,0.0,-63.0,-9.0,3.0,-49.0,98.0,3.0,-2.0,45.0,0.0,-2.0,25.0,5.0,0.0,0.0,0.0,-74.0,3.0,0.0,-397.0,-48.0,0.0,-65.0,-31.0,0.0,200.0,62.0,0.0,99.0,22.0,0.0,102.0,-2.0,5.0,0.0,0.0,0.0,62.0,-3.0,0.0,3.0,-24.0,2.0,3.0,-49.0,3.0,69.0,-106.0,0.0,32.0,-55.0,1.0,42.0,10.0,1.0,22.0,-50.0,0.0,40.0,10.0,0.0,31.0,6.0,3.0,0.0,-40.0,-1.0,21.0,1.0,-1.0,29.0,0.0,-1.0,19.0,-1.0,-3.0,8.0,42.0,0.0,22.0,-5.0,0.0,18.0,-4.0,-1.0,28.0,65.0,0.0,27.0,-3.0,0.0,35.0,-5.0,0.0,37.0,90.0,-2.0,69.0,165.0,-2.0,7.0,53.0,0.0,2.0,20.0,0.0,31.0,2.0,-5.0,158.0,-24.0,0.0,63.0,-56.0,0.0,-111.0,78.0,0.0,-67.0,7.0,0.0,-44.0,-5.0,0.0,-31.0,-4.0,0.0,-51.0,-8.0,-6.0,0.0,0.0,0.0,-2.0,-22.0,-2.0,-7.0,-54.0,-2.0,-58.0,-155.0,-1.0,-34.0,-5.0,0.0,-20.0,-2.0,2.0,-22.0,-70.0,1.0,-29.0,1.0,-4.0,-40.0,-1.0,1.0,-25.0,-3.0,0.0,-35.0,-5.0,0.0,-39.0,-7.0,1.0,-53.0,-11.0,0.0,-42.0,-10.0,1.0,-32.0,56.0,2.0,-69.0,106.0,3.0,-3.0,49.0,0.0,-3.0,24.0,0.0,-62.0,3.0,0.0,-102.0,1.0,0.0,-99.0,-23.0,0.0,-134.0,-29.0,0.0,-65.0,-33.0,0.0,0.0,-29.0,5.0,0.0,0.0,4.0,0.0,0.0,0.0,0.0,30.0,0.0,66.0,33.0,0.0,134.0,29.0,0.0,99.0,22.0,0.0,6.0,-25.0,1.0,99.0,-3.0,2.0,4.0,-50.0,2.0,85.0,-114.0,1.0,39.0,-59.0,1.0,35.0,-53.0,0.0,33.0,12.0,4.0,15.0,-37.0,0.0,26.0,9.0,1.0,41.0,11.0,7.0,22.0,-17.0,-3.0,67.0,1.0,-8.0,19.0,16.0,-1.0,21.0,-7.0,0.0,13.0,-6.0,-3.0,17.0,43.0,-1.0,24.0,-12.0,0.0,25.0,-11.0,0.0,49.0,84.0,0.0,38.0,97.0,-1.0,73.0,169.0,-2.0,5.0,52.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_4()
		{
			double[] value = {-1.0,44.0,5.0,0.0,3.0,17.0,0.0,67.0,-8.0,-1.0,47.0,-21.0,0.0,64.0,-57.0,-1.0,9.0,-68.0,-2.0,0.0,0.0,-3.0,0.0,0.0,0.0,-10.0,69.0,-1.0,-64.0,57.0,-1.0,-47.0,21.0,0.0,-67.0,7.0,0.0,-44.0,-5.0,-1.0,-31.0,-3.0,0.0,-2.0,-20.0,-2.0,-7.0,-53.0,-1.0,-69.0,-165.0,0.0,-37.0,-89.0,-1.0,-35.0,6.0,0.0,-27.0,2.0,0.0,-28.0,-65.0,0.0,-18.0,5.0,0.0,-22.0,5.0,-1.0,-26.0,0.0,-1.0,-24.0,0.0,0.0,-27.0,-3.0,0.0,-31.0,-7.0,0.0,-40.0,-10.0,1.0,-34.0,-12.0,1.0,-33.0,-12.0,1.0,-35.0,54.0,0.0,-39.0,59.0,2.0,-85.0,114.0,3.0,-4.0,50.0,0.0,-99.0,2.0,0.0,-98.0,-16.0,0.0,-133.0,-25.0,0.0,-62.0,-31.0,0.0,1.0,-30.0,5.0,0.0,0.0,4.0,0.0,1.0,0.0,-1.0,30.0,0.0,63.0,31.0,0.0,133.0,24.0,2.0,15.0,-42.0,1.0,92.0,5.0,2.0,113.0,-126.0,0.0,50.0,-62.0,1.0,51.0,-56.0,3.0,24.0,-38.0,1.0,39.0,18.0,9.0,34.0,-8.0,14.0,12.0,-24.0,0.0,68.0,19.0,-3.0,63.0,2.0,-2.0,46.0,-8.0,-14.0,7.0,21.0,-8.0,19.0,6.0,-2.0,26.0,-17.0,-1.0,15.0,-10.0,-1.0,30.0,48.0,0.0,53.0,93.0,0.0,42.0,103.0,-1.0,85.0,171.0,0.0,60.0,-9.0,-2.0,14.0,52.0,-1.0,45.0,-21.0,-1.0,62.0,-55.0,0.0,8.0,-67.0,-2.0,0.0,0.0,-3.0,0.0,0.0,0.0,-9.0,68.0,-1.0,-62.0,55.0,-1.0,-45.0,21.0,0.0,-66.0,6.0,0.0,-44.0,-5.0,-3.0,-5.0,-52.0,0.0,-73.0,-169.0,0.0,-38.0,-97.0,0.0,-49.0,-83.0,-1.0,-25.0,12.0,-1.0,-24.0,11.0,-3.0,-17.0,-43.0,0.0,-13.0,7.0,0.0,-21.0,7.0,-1.0,-16.0,5.0,-1.0,-19.0,1.0,-1.0,-29.0,0.0,0.0,-21.0,-2.0,0.0,-23.0,-5.0,1.0,-41.0,-12.0,0.0,-26.0,-9.0,1.0,-24.0,-12.0,1.0,-39.0,-18.0,3.0,-24.0,39.0,1.0,-51.0,56.0,1.0,-50.0,62.0,2.0,-113.0,125.0,0.0,-92.0,-6.0,0.0,-121.0,-19.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_5()
		{
			double[] value = {0.0,-49.0,-36.0,1.0,9.0,-34.0,6.0,0.0,0.0,5.0,0.0,0.0,1.0,-9.0,35.0,0.0,50.0,35.0,2.0,210.0,-152.0,0.0,65.0,36.0,0.0,62.0,-63.0,1.0,58.0,-60.0,4.0,33.0,-37.0,8.0,31.0,-7.0,12.0,21.0,-17.0,3.0,-7.0,-40.0,-1.0,-7.0,-20.0,5.0,31.0,45.0,3.0,41.0,20.0,2.0,68.0,15.0,-3.0,59.0,4.0,-3.0,46.0,-4.0,-2.0,22.0,-12.0,-2.0,10.0,-15.0,-6.0,2.0,30.0,-15.0,18.0,10.0,-8.0,28.0,-3.0,0.0,38.0,45.0,0.0,64.0,96.0,0.0,50.0,107.0,-2.0,23.0,-13.0,-1.0,123.0,160.0,-1.0,54.0,-53.0,-1.0,8.0,-73.0,-2.0,0.0,0.0,-3.0,0.0,0.0,-1.0,-9.0,74.0,-1.0,-54.0,53.0,-2.0,-39.0,22.0,0.0,-60.0,9.0,0.0,-85.0,-172.0,0.0,-42.0,-103.0,0.0,-53.0,-93.0,-1.0,-30.0,-47.0,-2.0,-15.0,11.0,-2.0,-26.0,16.0,-8.0,-19.0,-6.0,-2.0,-50.0,14.0,-2.0,-67.0,-1.0,1.0,-79.0,-23.0,2.0,-65.0,-35.0,9.0,-31.0,7.0,3.0,-33.0,37.0,1.0,-58.0,60.0,0.0,-62.0,62.0,0.0,-65.0,-37.0,1.0,-32.0,-50.0,0.0,0.0,-33.0,8.0,0.0,0.0,7.0,0.0,0.0,0.0,0.0,33.0,0.0,86.0,-55.0,1.0,24.0,43.0,0.0,79.0,-61.0,3.0,36.0,-37.0,9.0,21.0,-13.0,9.0,24.0,-9.0,-2.0,-12.0,-29.0,1.0,2.0,-32.0,9.0,29.0,7.0,9.0,47.0,37.0,10.0,96.0,10.0,-2.0,58.0,9.0,-10.0,52.0,11.0,-9.0,27.0,-13.0,-8.0,16.0,0.0,0.0,-4.0,35.0,-14.0,20.0,5.0,-8.0,25.0,2.0,-1.0,40.0,46.0,0.0,67.0,102.0,-1.0,23.0,-33.0,0.0,65.0,103.0,-1.0,7.0,-77.0,-3.0,0.0,0.0,-3.0,0.0,0.0,-1.0,-8.0,78.0,-2.0,-32.0,39.0,-1.0,-23.0,13.0,0.0,-50.0,-108.0,0.0,-64.0,-96.0,-1.0,-38.0,-44.0,-8.0,-28.0,3.0,-15.0,-18.0,-10.0,-3.0,-32.0,19.0,-2.0,-46.0,8.0,-1.0,-63.0,-3.0,1.0,-68.0,-19.0,3.0,-55.0,-28.0,4.0,-33.0,-34.0,10.0,-25.0,9.0,8.0,-21.0,13.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_6()
		{
			double[] value = {3.0,-36.0,37.0,0.0,-79.0,60.0,1.0,-23.0,-44.0,1.0,2.0,-26.0,7.0,0.0,0.0,6.0,0.0,0.0,-1.0,100.0,-74.0,2.0,-2.0,30.0,0.0,26.0,-35.0,8.0,11.0,0.0,-6.0,0.0,-26.0,-2.0,14.0,-67.0,-4.0,-10.0,5.0,2.0,-183.0,65.0,1.0,-206.0,77.0,0.0,-75.0,18.0,0.0,-80.0,14.0,0.0,7.0,-22.0,0.0,-71.0,4.0,0.0,139.0,-25.0,0.0,62.0,-16.0,-1.0,221.0,-69.0,-1.0,183.0,-55.0,15.0,25.0,3.0,21.0,30.0,1.0,6.0,13.0,1.0,22.0,66.0,8.0,8.0,95.0,16.0,-3.0,37.0,10.0,-9.0,41.0,9.0,-27.0,43.0,12.0,-6.0,10.0,2.0,-21.0,34.0,6.0,-1.0,37.0,-112.0,2.0,-45.0,172.0,-8.0,24.0,1.0,-2.0,41.0,42.0,0.0,-16.0,-78.0,0.0,97.0,124.0,-2.0,0.0,0.0,-3.0,0.0,0.0,-1.0,-1.0,66.0,-1.0,-23.0,33.0,0.0,-67.0,-103.0,-2.0,-40.0,-46.0,-8.0,-25.0,-2.0,-14.0,-20.0,-5.0,-8.0,-15.0,-6.0,-1.0,-10.0,16.0,-2.0,-22.0,12.0,-4.0,-46.0,3.0,-1.0,-59.0,-5.0,2.0,-68.0,-15.0,4.0,-41.0,-20.0,3.0,-23.0,-24.0,1.0,-8.0,-21.0,8.0,-31.0,-2.0,11.0,-34.0,0.0,10.0,-12.0,0.0,0.0,-25.0,34.0,1.0,3.0,-31.0,6.0,0.0,0.0,0.0,26.0,-31.0,5.0,0.0,-1.0,-3.0,16.0,-60.0,-3.0,0.0,0.0,0.0,-4.0,0.0,0.0,-183.0,65.0,0.0,-206.0,77.0,0.0,-75.0,18.0,-6.0,0.0,0.0,0.0,-81.0,15.0,7.0,0.0,0.0,0.0,-93.0,15.0,6.0,0.0,0.0,1.0,-262.0,22.0,0.0,73.0,-29.0,0.0,338.0,-146.0,2.0,283.0,-78.0,0.0,173.0,-40.0,4.0,32.0,-9.0,13.0,24.0,-5.0,18.0,27.0,-3.0,8.0,12.0,-2.0,22.0,69.0,-3.0,15.0,111.0,4.0,-7.0,48.0,10.0,-13.0,56.0,15.0,-33.0,49.0,11.0,-12.0,20.0,5.0,-4.0,71.0,-105.0,3.0,53.0,-36.0,-9.0,34.0,97.0,-6.0,68.0,98.0,5.0,96.0,-28.0,3.0,117.0,-15.0,-2.0,255.0,288.0,-8.0,163.0,201.0,0.0,64.0,-28.0,0.0,-200.0,47.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_7()
		{
			double[] value = {-1.0,-121.0,-26.0,-1.0,24.0,39.0,-5.0,0.0,0.0,-5.0,0.0,0.0,0.0,-25.0,-40.0,2.0,-205.0,-130.0,0.0,-145.0,-90.0,0.0,-66.0,-66.0,0.0,-58.0,-54.0,-1.0,-66.0,-56.0,8.0,0.0,0.0,0.0,-40.0,-84.0,-3.0,0.0,0.0,0.0,-3.0,0.0,2.0,0.0,0.0,-1.0,-27.0,96.0,-2.0,0.0,0.0,0.0,28.0,34.0,-3.0,0.0,0.0,0.0,16.0,78.0,-2.0,-42.0,-43.0,-8.0,-24.0,-1.0,-14.0,-24.0,-1.0,-10.0,-17.0,0.0,-9.0,-27.0,13.0,-9.0,-52.0,-12.0,-1.0,-58.0,-9.0,11.0,-96.0,-10.0,8.0,-47.0,-37.0,10.0,-29.0,-6.0,18.0,-37.0,6.0,4.0,-7.0,-2.0,1.0,16.0,-60.0,0.0,-4.0,0.0,-2.0,-183.0,65.0,0.0,-206.0,76.0,0.0,-19.0,-25.0,0.0,-62.0,16.0,0.0,-67.0,20.0,0.0,-72.0,5.0,0.0,-29.0,33.0,0.0,-263.0,22.0,7.0,0.0,0.0,0.0,-160.0,-33.0,7.0,0.0,0.0,0.0,61.0,-21.0,1.0,398.0,-210.0,6.0,301.0,-91.0,3.0,146.0,-35.0,3.0,-110.0,-71.0,9.0,111.0,-16.0,-6.0,84.0,66.0,17.0,50.0,-8.0,19.0,51.0,2.0,37.0,78.0,-46.0,24.0,155.0,-10.0,-10.0,109.0,27.0,-18.0,44.0,17.0,-34.0,34.0,32.0,-23.0,26.0,11.0,10.0,58.0,-56.0,8.0,60.0,-44.0,-23.0,13.0,27.0,-9.0,39.0,95.0,11.0,76.0,-39.0,1.0,57.0,-36.0,-12.0,138.0,152.0,-6.0,279.0,286.0,-8.0,216.0,125.0,0.0,75.0,-135.0,0.0,49.0,-155.0,2.0,11.0,-136.0,0.0,-26.0,-177.0,-2.0,-35.0,-190.0,-2.0,37.0,42.0,-3.0,-59.0,-202.0,-2.0,0.0,0.0,0.0,60.0,203.0,0.0,32.0,198.0,0.0,13.0,174.0,0.0,-20.0,129.0,0.0,-56.0,148.0,0.0,-79.0,130.0,0.0,-76.0,72.0,0.0,-62.0,31.0,5.0,0.0,0.0,0.0,-127.0,22.0,-6.0,0.0,0.0,-7.0,0.0,0.0,-1.0,-14.0,-29.0,-2.0,-220.0,-261.0,3.0,-156.0,-41.0,3.0,-113.0,-16.0,0.0,-80.0,-93.0,-3.0,-51.0,-90.0,-7.0,-25.0,-97.0,11.0,-57.0,91.0,0.0,-3.0,0.0,1.0,-28.0,96.0,-9.0,-13.0,9.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_8()
		{
			double[] value = {-22.0,-34.0,-7.0,-6.0,-10.0,-2.0,-26.0,-43.0,-12.0,-10.0,-41.0,-9.0,-2.0,-37.0,-10.0,9.0,-95.0,-16.0,22.0,-66.0,-8.0,7.0,-13.0,-1.0,21.0,-30.0,0.0,10.0,-11.0,0.0,4.0,-14.0,-3.0,-3.0,-183.0,55.0,-2.0,-20.0,-86.0,2.0,-283.0,78.0,0.0,-338.0,145.0,0.0,-173.0,-24.0,0.0,-61.0,20.0,0.0,-103.0,-89.0,8.0,0.0,0.0,7.0,0.0,0.0,0.0,35.0,-19.0,1.0,406.0,-202.0,6.0,309.0,-90.0,0.0,-113.0,-68.0,0.0,-103.0,-66.0,6.0,142.0,-13.0,2.0,120.0,60.0,11.0,109.0,-11.0,18.0,63.0,-13.0,-3.0,98.0,55.0,22.0,60.0,-15.0,38.0,113.0,-35.0,21.0,159.0,-4.0,2.0,45.0,1.0,-12.0,122.0,32.0,-19.0,54.0,21.0,-31.0,52.0,30.0,8.0,54.0,-49.0,6.0,59.0,-50.0,-21.0,44.0,25.0,-20.0,17.0,29.0,1.0,59.0,-39.0,0.0,77.0,-48.0,-10.0,38.0,100.0,-10.0,136.0,146.0,-8.0,292.0,256.0,0.0,61.0,-139.0,-1.0,27.0,-156.0,0.0,14.0,-135.0,-2.0,-3.0,-143.0,0.0,-28.0,-212.0,-6.0,-12.0,-210.0,-1.0,58.0,109.0,-1.0,22.0,-8.0,-5.0,0.0,0.0,-5.0,0.0,0.0,1.0,44.0,154.0,-3.0,60.0,203.0,-1.0,32.0,198.0,1.0,13.0,174.0,1.0,-20.0,129.0,0.0,-56.0,148.0,0.0,-79.0,130.0,0.0,-76.0,72.0,-1.0,-62.0,30.0,-1.0,-6.0,-25.0,-7.0,-163.0,-202.0,-2.0,-255.0,-287.0,5.0,-117.0,16.0,3.0,-96.0,27.0,-7.0,-68.0,-99.0,-8.0,-34.0,-96.0,4.0,-53.0,37.0,11.0,-57.0,108.0,-17.0,-14.0,-4.0,-12.0,-20.0,-6.0,-33.0,-49.0,-11.0,-13.0,-56.0,-15.0,-6.0,-48.0,-10.0,16.0,-111.0,-3.0,23.0,-69.0,4.0,8.0,-12.0,2.0,17.0,-27.0,3.0,13.0,-24.0,5.0,3.0,-32.0,8.0,-6.0,-121.0,-96.0,2.0,-147.0,35.0,6.0,-301.0,90.0,0.0,-122.0,-78.0,0.0,-406.0,201.0,0.0,-40.0,-100.0,0.0,-30.0,27.0,9.0,0.0,0.0,8.0,0.0,0.0,0.0,31.0,-28.0,1.0,359.0,-183.0,1.0,-49.0,-94.0,-1.0,-48.0,-82.0,2.0,185.0,-32.0,6.0,128.0,-11.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_9()
		{
			double[] value = {14.0,81.0,-5.0,4.0,115.0,58.0,17.0,74.0,-17.0,23.0,105.0,-23.0,1.0,99.0,65.0,39.0,146.0,-41.0,24.0,177.0,-6.0,2.0,90.0,3.0,-12.0,135.0,35.0,-20.0,61.0,28.0,10.0,38.0,-62.0,-26.0,141.0,14.0,-22.0,54.0,20.0,0.0,75.0,-52.0,-2.0,92.0,-78.0,-28.0,26.0,30.0,-10.0,46.0,99.0,-9.0,117.0,131.0,-1.0,93.0,-145.0,-2.0,40.0,-146.0,-2.0,24.0,-159.0,-5.0,24.0,-153.0,-6.0,35.0,-128.0,-7.0,167.0,133.0,0.0,0.0,-2.0,0.0,5.0,-9.0,0.0,1.0,0.0,0.0,-2.0,0.0,0.0,-5.0,9.0,0.0,-11.0,-6.0,0.0,0.0,1.0,0.0,0.0,-2.0,0.0,15.0,-44.0,0.0,2.0,0.0,0.0,-3.0,-1.0,0.0,-15.0,-113.0,0.0,-26.0,118.0,0.0,-1.0,0.0,0.0,2.0,0.0,0.0,26.0,-119.0,0.0,1.0,0.0,0.0,-24.0,-127.0,0.0,-2.0,1.0,0.0,-59.0,101.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,58.0,-101.0,0.0,-96.0,-149.0,0.0,-52.0,73.0,0.0,98.0,-20.0,0.0,33.0,52.0,-1.0,0.0,0.0,0.0,-1.0,0.0,0.0,-79.0,73.0,1.0,-1.0,0.0,0.0,1.0,-1.0,0.0,-31.0,-63.0,4.0,12.0,71.0,0.0,35.0,91.0,0.0,43.0,100.0,-5.0,0.0,0.0,-6.0,0.0,0.0,-1.0,14.0,137.0,-2.0,88.0,305.0,-1.0,36.0,191.0,2.0,25.0,177.0,1.0,-12.0,136.0,0.0,-49.0,155.0,0.0,-75.0,135.0,-1.0,-76.0,76.0,-9.0,-140.0,-203.0,-6.0,-279.0,-286.0,-11.0,-138.0,-151.0,2.0,-57.0,37.0,10.0,-76.0,38.0,-10.0,-39.0,-96.0,-22.0,-13.0,-26.0,9.0,-60.0,45.0,9.0,-58.0,55.0,-24.0,-26.0,-12.0,-34.0,-34.0,-32.0,-17.0,-44.0,-17.0,-10.0,-109.0,-26.0,25.0,-155.0,11.0,37.0,-78.0,45.0,20.0,-51.0,-2.0,15.0,-50.0,8.0,-6.0,-84.0,-66.0,10.0,-111.0,17.0,6.0,-149.0,27.0,0.0,-113.0,-67.0,4.0,-283.0,75.0,0.0,-49.0,-93.0,1.0,-317.0,166.0,0.0,-44.0,48.0,10.0,0.0,0.0,9.0,0.0,0.0,0.0,45.0,-49.0,-2.0,9.0,-125.0,-1.0,7.0,-135.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_10()
		{
			double[] value = {1.0,230.0,-75.0,2.0,140.0,-22.0,5.0,102.0,-9.0,15.0,67.0,-11.0,20.0,72.0,-20.0,3.0,121.0,87.0,24.0,134.0,-17.0,45.0,271.0,8.0,26.0,194.0,-11.0,6.0,134.0,5.0,-9.0,150.0,37.0,-17.0,119.0,-25.0,-30.0,162.0,17.0,-1.0,91.0,-79.0,0.0,88.0,-126.0,-29.0,69.0,-7.0,-29.0,29.0,16.0,-10.0,47.0,102.0,-3.0,57.0,-171.0,-5.0,51.0,-139.0,-5.0,42.0,-109.0,-5.0,39.0,-110.0,4.0,-37.0,-55.0,-8.0,42.0,-173.0,0.0,3.0,-5.0,-6.0,107.0,40.0,0.0,26.0,-42.0,-1.0,1.0,0.0,0.0,-2.0,1.0,0.0,-26.0,42.0,0.0,-1.0,0.0,0.0,-32.0,-21.0,0.0,44.0,50.0,0.0,-2.0,1.0,0.0,-78.0,61.0,0.0,-2.0,0.0,0.0,-17.0,-40.0,0.0,32.0,111.0,0.0,34.0,91.0,-5.0,0.0,0.0,-3.0,0.0,127.0,-5.0,13.0,211.0,-1.0,28.0,212.0,-2.0,2.0,143.0,0.0,-15.0,135.0,-1.0,-27.0,156.0,0.0,-61.0,138.0,-7.0,-292.0,-257.0,-10.0,-136.0,-146.0,-10.0,-38.0,-99.0,0.0,-77.0,49.0,1.0,-59.0,38.0,-21.0,-17.0,-30.0,-20.0,-44.0,-24.0,7.0,-59.0,51.0,7.0,-54.0,48.0,-31.0,-52.0,-31.0,-20.0,-54.0,-21.0,-11.0,-122.0,-32.0,3.0,-45.0,0.0,21.0,-159.0,5.0,38.0,-113.0,35.0,21.0,-60.0,14.0,-3.0,-98.0,-55.0,19.0,-63.0,14.0,11.0,-109.0,10.0,2.0,-120.0,-60.0,6.0,-142.0,13.0,3.0,-92.0,-65.0,2.0,-185.0,32.0,1.0,-259.0,123.0,0.0,-71.0,72.0,9.0,0.0,0.0,7.0,0.0,0.0,-1.0,-12.0,-162.0,0.0,-7.0,-140.0,0.0,91.0,-23.0,0.0,199.0,-49.0,3.0,138.0,-19.0,3.0,65.0,-9.0,14.0,63.0,-13.0,21.0,67.0,-22.0,2.0,-54.0,-92.0,32.0,184.0,64.0,0.0,88.0,94.0,49.0,269.0,-49.0,33.0,256.0,-6.0,6.0,192.0,2.0,-10.0,192.0,20.0,-24.0,185.0,44.0,3.0,87.0,-115.0,-47.0,203.0,-76.0,-34.0,82.0,-53.0,-25.0,30.0,0.0,-6.0,55.0,-129.0,-6.0,40.0,-99.0,-1.0,30.0,-96.0,-7.0,48.0,-166.0,-6.0,12.0,-124.0,99.0,-273.0,-1195.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_11()
		{
			double[] value = {7.0,-1.0,-1.0,20.0,-40.0,60.0,0.0,15.0,14.0,-20.0,42.0,-71.0,6.0,3.0,0.0,14.0,-6.0,-7.0,-22.0,28.0,-113.0,0.0,-15.0,-8.0,-11.0,20.0,13.0,-5.0,-2.0,1.0,-2.0,-10.0,-4.0,-6.0,1.0,2.0,-6.0,5.0,4.0,8.0,111.0,181.0,-43.0,60.0,33.0,55.0,-204.0,-98.0,25.0,-47.0,65.0,1.0,-1.0,-9.0,29.0,-58.0,40.0,5.0,0.0,-2.0,4.0,10.0,25.0,17.0,-73.0,23.0,6.0,2.0,1.0,22.0,-102.0,-20.0,-40.0,177.0,-3.0,-30.0,61.0,-52.0,14.0,-7.0,-12.0,2.0,-20.0,-30.0,-19.0,39.0,-52.0,9.0,-30.0,-15.0,-31.0,52.0,-99.0,8.0,-35.0,-17.0,3.0,-3.0,-3.0,-2.0,20.0,-96.0,-6.0,6.0,1.0,-10.0,40.0,21.0,-2.0,5.0,2.0,-13.0,0.0,0.0,-11.0,0.0,2.0,-72.0,-217.0,-580.0,-3.0,4.0,0.0,-2.0,3.0,1.0,4.0,7.0,4.0,-4.0,2.0,0.0,10.0,-7.0,-1.0,5.0,-7.0,-1.0,2.0,-7.0,-1.0,-10.0,0.0,-4.0,0.0,-6.0,0.0,0.0,-4.0,0.0,-12.0,0.0,0.0,0.0,-6.0,2.0,-11.0,8.0,-2.0,0.0,3.0,1.0,1.0,6.0,0.0,2.0,4.0,1.0,2.0,4.0,0.0,3.0,3.0,1.0,3.0,1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,9.0,33.0,23.0,3.0,13.0,19.0,4.0,14.0,34.0,3.0,9.0,43.0,2.0,0.0,52.0,4.0,20.0,65.0,3.0,67.0,65.0,4.0,40.0,64.0,5.0,54.0,121.0,3.0,44.0,128.0,0.0,43.0,134.0,-31.0,56.0,173.0,-1.0,30.0,258.0,0.0,-5.0,266.0,0.0,-10.0,218.0,-1.0,6.0,190.0,-6.0,25.0,141.0,-2.0,4.0,9.0,0.0,60.0,44.0,-1.0,0.0,0.0,-1.0,-1.0,1.0,0.0,0.0,86.0,0.0,-52.0,74.0,-3.0,31.0,111.0,-4.0,-14.0,126.0,-6.0,-35.0,129.0,-5.0,-24.0,153.0,-2.0,-24.0,159.0,-2.0,-40.0,146.0,-1.0,-93.0,144.0,-9.0,-117.0,-132.0,-10.0,-46.0,-99.0,-28.0,-26.0,-29.0,-2.0,-92.0,79.0,0.0,-75.0,51.0,-21.0,-54.0,-21.0,-26.0,-141.0,-13.0,10.0,-38.0,62.0,-21.0,-61.0,-29.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_12()
		{
			double[] value = {-11.0,-135.0,-35.0,3.0,-90.0,-2.0,24.0,-177.0,7.0,39.0,-146.0,40.0,1.0,-99.0,-65.0,23.0,-105.0,24.0,17.0,-74.0,16.0,4.0,-115.0,-58.0,15.0,-81.0,5.0,2.0,-93.0,-74.0,5.0,-102.0,9.0,2.0,-140.0,22.0,1.0,-230.0,75.0,0.0,-90.0,45.0,7.0,-1.0,-1.0,0.0,-7.0,-139.0,0.0,-4.0,-54.0,6.0,1.0,-3.0,0.0,78.0,-39.0,0.0,165.0,-64.0,5.0,180.0,-21.0,13.0,79.0,-27.0,0.0,-41.0,-118.0,28.0,65.0,-22.0,42.0,124.0,-28.0,-9.0,60.0,135.0,56.0,303.0,9.0,36.0,293.0,-36.0,5.0,249.0,0.0,-11.0,230.0,22.0,-31.0,307.0,-49.0,-57.0,204.0,-98.0,-36.0,75.0,-42.0,-9.0,49.0,-111.0,-3.0,30.0,-82.0,-3.0,61.0,-165.0,10.0,10.0,-123.0,7.0,-26.0,-147.0,0.0,-11.0,-196.0,-3.0,2.0,-221.0,0.0,6.0,-271.0,47.0,-59.0,-35.0,43.0,-214.0,-160.0,15.0,-61.0,-54.0,20.0,-72.0,21.0,2.0,-3.0,-7.0,4.0,0.0,-3.0,22.0,-97.0,-17.0,5.0,3.0,22.0,8.0,-99.0,0.0,6.0,0.0,2.0,5.0,-49.0,18.0,12.0,-1.0,-9.0,-4.0,49.0,-18.0,-8.0,102.0,0.0,-21.0,101.0,16.0,-20.0,72.0,-22.0,-1.0,-16.0,-37.0,0.0,-23.0,-36.0,-26.0,59.0,-32.0,-3.0,-39.0,-63.0,-8.0,34.0,-23.0,2.0,-3.0,-4.0,3.0,-1.0,0.0,-19.0,45.0,-68.0,-2.0,21.0,-96.0,-16.0,0.0,-103.0,-8.0,2.0,-2.0,-6.0,6.0,0.0,-23.0,42.0,16.0,-11.0,-28.0,-112.0,-7.0,-36.0,-61.0,-7.0,-62.0,-64.0,-8.0,-17.0,-63.0,-5.0,0.0,-50.0,-6.0,-8.0,-43.0,-6.0,-13.0,-33.0,-6.0,-14.0,-21.0,8.0,-8.0,-1.0,7.0,-9.0,-1.0,4.0,-12.0,-1.0,0.0,-14.0,-2.0,-15.0,-6.0,-17.0,0.0,-7.0,0.0,0.0,-3.0,1.0,-24.0,0.0,0.0,-22.0,0.0,0.0,0.0,4.0,-1.0,0.0,7.0,1.0,2.0,9.0,1.0,3.0,8.0,1.0,4.0,7.0,1.0,5.0,4.0,0.0,6.0,3.0,1.0,3.0,0.0,0.0,0.0,25.0,18.0,0.0,13.0,20.0,0.0,14.0,33.0,0.0,9.0,43.0,0.0,1.0,53.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_13()
		{
			double[] value = {-1.0,21.0,65.0,0.0,69.0,66.0,0.0,42.0,66.0,0.0,57.0,125.0,0.0,48.0,131.0,-88.0,-108.0,63.0,-6.0,0.0,-1.0,-1.0,10.0,2.0,-6.0,2.0,0.0,-9.0,-5.0,-4.0,-2.0,-16.0,-8.0,-20.0,-12.0,122.0,15.0,6.0,6.0,4.0,-4.0,0.0,-20.0,-42.0,71.0,1.0,-14.0,-15.0,20.0,41.0,-59.0,7.0,1.0,1.0,25.0,39.0,-110.0,38.0,131.0,55.0,42.0,19.0,14.0,0.0,39.0,162.0,0.0,28.0,257.0,0.0,-5.0,265.0,0.0,-9.0,217.0,0.0,5.0,190.0,0.0,25.0,141.0,0.0,5.0,8.0,-1.0,-2.0,1.0,-7.0,-11.0,113.0,0.0,-3.0,6.0,-7.0,-41.0,173.0,4.0,37.0,55.0,-5.0,-40.0,110.0,-6.0,-42.0,109.0,-5.0,-51.0,139.0,-3.0,-57.0,170.0,-10.0,-47.0,-103.0,-28.0,-29.0,-15.0,-30.0,-69.0,8.0,0.0,-88.0,126.0,0.0,-91.0,78.0,-31.0,-162.0,-17.0,-16.0,-119.0,25.0,-9.0,-150.0,-38.0,7.0,-134.0,-4.0,26.0,-194.0,11.0,45.0,-271.0,-8.0,24.0,-134.0,17.0,3.0,-121.0,-87.0,20.0,-72.0,20.0,3.0,-81.0,-89.0,14.0,-63.0,13.0,4.0,-65.0,9.0,2.0,-138.0,19.0,0.0,-199.0,49.0,0.0,-91.0,22.0,0.0,-4.0,-57.0,1.0,-3.0,-93.0,6.0,-2.0,1.0,5.0,3.0,-2.0,0.0,75.0,-51.0,0.0,159.0,-77.0,3.0,156.0,-28.0,0.0,-21.0,-136.0,13.0,60.0,-14.0,30.0,62.0,-13.0,43.0,129.0,-7.0,64.0,274.0,31.0,31.0,331.0,-52.0,5.0,327.0,1.0,-3.0,219.0,11.0,-5.0,92.0,2.0,-42.0,311.0,1.0,-72.0,209.0,-91.0,0.0,86.0,-217.0,15.0,15.0,-125.0,12.0,-23.0,-149.0,0.0,-30.0,-214.0,-4.0,4.0,-227.0,67.0,-186.0,-96.0,7.0,-145.0,-313.0,24.0,-111.0,-29.0,-1.0,-4.0,-54.0,2.0,-2.0,-6.0,8.0,-98.0,0.0,5.0,0.0,-1.0,4.0,-52.0,20.0,6.0,5.0,21.0,5.0,-54.0,55.0,6.0,0.0,2.0,0.0,-40.0,1.0,12.0,5.0,-12.0,-5.0,-68.0,-17.0,6.0,104.0,13.0,-4.0,-3.0,-32.0,-5.0,49.0,-47.0,-4.0,52.0,-19.0,-7.0,101.0,-3.0,-21.0,94.0,9.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_14()
		{
			double[] value = {-4.0,-6.0,-44.0,-22.0,2.0,-73.0,-9.0,6.0,-31.0,1.0,0.0,-5.0,-9.0,61.0,-2.0,0.0,0.0,-2.0,-1.0,-13.0,-26.0,-8.0,31.0,-19.0,-12.0,42.0,-54.0,-4.0,23.0,-94.0,-14.0,0.0,-100.0,-26.0,-3.0,-97.0,-6.0,-36.0,-65.0,-10.0,-42.0,-61.0,-12.0,-10.0,-58.0,-10.0,1.0,-50.0,-7.0,-7.0,-43.0,-9.0,-11.0,-34.0,8.0,-10.0,0.0,3.0,-12.0,-2.0,0.0,-18.0,-2.0,-2.0,-17.0,-4.0,-10.0,-2.0,-19.0,-2.0,-2.0,0.0,-35.0,1.0,0.0,-36.0,-1.0,0.0,-2.0,3.0,0.0,0.0,12.0,3.0,1.0,14.0,2.0,4.0,12.0,1.0,7.0,10.0,1.0,8.0,7.0,1.0,8.0,6.0,0.0,-3.0,13.0,19.0,-3.0,14.0,34.0,-3.0,9.0,43.0,-3.0,0.0,52.0,-5.0,20.0,65.0,-4.0,67.0,65.0,-4.0,40.0,64.0,-5.0,54.0,121.0,-3.0,43.0,127.0,-41.0,-84.0,-34.0,-11.0,-1.0,-2.0,-13.0,0.0,0.0,-2.0,-5.0,-3.0,-10.0,-40.0,-21.0,-6.0,-6.0,0.0,-1.0,-19.0,97.0,4.0,4.0,3.0,7.0,34.0,17.0,-30.0,-52.0,99.0,8.0,30.0,15.0,-18.0,-39.0,52.0,2.0,21.0,30.0,14.0,6.0,12.0,-31.0,-62.0,52.0,-18.0,-74.0,22.0,-22.0,-102.0,-19.0,29.0,100.0,17.0,17.0,73.0,-23.0,4.0,-10.0,-24.0,5.0,0.0,2.0,29.0,59.0,-40.0,2.0,1.0,9.0,25.0,47.0,-65.0,11.0,143.0,65.0,43.0,61.0,34.0,35.0,15.0,13.0,0.0,30.0,258.0,0.0,-5.0,266.0,0.0,-10.0,218.0,2.0,6.0,190.0,4.0,25.0,141.0,-3.0,0.0,5.0,-7.0,-13.0,124.0,-6.0,-48.0,166.0,-2.0,-30.0,96.0,-6.0,-40.0,99.0,-6.0,-55.0,128.0,-25.0,-30.0,0.0,-34.0,-82.0,54.0,-46.0,-203.0,76.0,3.0,-87.0,114.0,-25.0,-185.0,-45.0,-9.0,-192.0,-20.0,7.0,-192.0,-1.0,33.0,-256.0,7.0,49.0,-269.0,48.0,1.0,-88.0,-94.0,32.0,-129.0,28.0,-1.0,-55.0,-92.0,25.0,-70.0,20.0,13.0,-80.0,27.0,5.0,-180.0,21.0,0.0,-165.0,63.0,1.0,-5.0,-106.0,1.0,0.0,-136.0,3.0,-76.0,54.0,2.0,-2.0,1.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_15()
		{
			double[] value = {1.0,3.0,-2.0,3.0,76.0,-54.0,0.0,158.0,-79.0,2.0,3.0,-121.0,3.0,125.0,-69.0,4.0,-8.0,-158.0,0.0,-1.0,-99.0,10.0,31.0,-23.0,0.0,5.0,107.0,-1.0,18.0,162.0,27.0,45.0,-14.0,42.0,112.0,-15.0,62.0,242.0,-25.0,33.0,315.0,-25.0,7.0,117.0,-11.0,10.0,319.0,-10.0,-1.0,208.0,5.0,-7.0,135.0,14.0,-44.0,326.0,-17.0,8.0,18.0,-169.0,4.0,17.0,-194.0,3.0,-18.0,-246.0,41.0,-264.0,-23.0,-5.0,17.0,-299.0,5.0,-89.0,-25.0,-7.0,-11.0,-279.0,-1.0,-5.0,-45.0,5.0,-52.0,20.0,2.0,-3.0,-5.0,7.0,-53.0,52.0,4.0,0.0,-2.0,0.0,-34.0,1.0,4.0,-2.0,23.0,-6.0,-65.0,-20.0,5.0,0.0,2.0,0.0,-101.0,-1.0,12.0,0.0,-8.0,-1.0,3.0,-30.0,1.0,104.0,-1.0,4.0,70.0,15.0,-9.0,23.0,-48.0,-4.0,55.0,-39.0,-3.0,42.0,-11.0,-6.0,111.0,-9.0,-25.0,1.0,-89.0,-11.0,4.0,-36.0,2.0,1.0,-4.0,1.0,7.0,0.0,-13.0,86.0,19.0,-4.0,7.0,-27.0,-9.0,27.0,-117.0,-7.0,23.0,-90.0,-12.0,23.0,-85.0,-18.0,6.0,-83.0,-13.0,-19.0,-63.0,-13.0,-31.0,-58.0,-15.0,-5.0,-56.0,-11.0,4.0,-48.0,-9.0,-4.0,-43.0,3.0,-15.0,-2.0,0.0,-21.0,-3.0,-2.0,-22.0,-3.0,-1.0,-5.0,0.0,9.0,-10.0,40.0,-21.0,14.0,-74.0,-45.0,1.0,-4.0,-46.0,-1.0,5.0,-2.0,4.0,0.0,-1.0,18.0,4.0,0.0,17.0,2.0,4.0,12.0,2.0,8.0,10.0,0.0,11.0,10.0,1.0,-6.0,13.0,33.0,-5.0,8.0,43.0,-6.0,0.0,50.0,-9.0,17.0,63.0,-8.0,62.0,64.0,-7.0,36.0,61.0,-11.0,27.0,111.0,-22.0,-43.0,-16.0,-7.0,-6.0,0.0,-7.0,-2.0,3.0,-17.0,0.0,103.0,-2.0,-21.0,96.0,-18.0,-44.0,68.0,4.0,2.0,0.0,1.0,2.0,4.0,-9.0,-34.0,23.0,-3.0,39.0,63.0,-26.0,-59.0,32.0,0.0,24.0,36.0,-1.0,15.0,37.0,-20.0,-73.0,21.0,-21.0,-101.0,-16.0,-7.0,-102.0,1.0,-3.0,-48.0,18.0,13.0,2.0,8.0,4.0,49.0,-19.0,6.0,0.0,-1.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_16()
		{
			double[] value = {8.0,98.0,0.0,5.0,-3.0,-22.0,22.0,98.0,18.0,4.0,0.0,3.0,2.0,3.0,6.0,20.0,72.0,-21.0,15.0,61.0,55.0,43.0,214.0,160.0,46.0,58.0,35.0,0.0,-7.0,271.0,-3.0,-1.0,221.0,0.0,12.0,196.0,9.0,25.0,147.0,8.0,-11.0,123.0,-4.0,-61.0,165.0,-3.0,-30.0,82.0,-9.0,-49.0,111.0,-36.0,-75.0,42.0,-57.0,-204.0,98.0,-31.0,-307.0,48.0,-9.0,-230.0,-22.0,5.0,-249.0,1.0,36.0,-293.0,35.0,55.0,-303.0,-10.0,-9.0,-60.0,-134.0,43.0,-124.0,29.0,28.0,-65.0,22.0,15.0,-73.0,19.0,4.0,-156.0,27.0,0.0,0.0,-139.0,-2.0,2.0,-120.0,0.0,-148.0,58.0,4.0,-78.0,54.0,4.0,-2.0,2.0,3.0,3.0,-3.0,4.0,78.0,-54.0,2.0,0.0,-141.0,0.0,143.0,-49.0,1.0,0.0,-133.0,1.0,13.0,-142.0,6.0,116.0,-31.0,9.0,30.0,-11.0,22.0,34.0,-11.0,-1.0,-5.0,80.0,2.0,5.0,120.0,39.0,96.0,-17.0,58.0,211.0,-15.0,37.0,331.0,-15.0,9.0,184.0,-17.0,17.0,299.0,-41.0,1.0,217.0,-12.0,-6.0,165.0,25.0,5.0,30.0,-240.0,2.0,-35.0,-238.0,1.0,-81.0,-312.0,-6.0,-2.0,-262.0,5.0,-57.0,39.0,-1.0,1.0,-17.0,0.0,-38.0,0.0,1.0,2.0,-8.0,-5.0,-64.0,-34.0,3.0,0.0,-1.0,0.0,-102.0,13.0,4.0,-2.0,22.0,-10.0,-113.0,-48.0,6.0,0.0,2.0,12.0,6.0,-7.0,-2.0,9.0,-27.0,-6.0,17.0,-16.0,9.0,89.0,32.0,0.0,107.0,-14.0,-26.0,120.0,-133.0,-18.0,12.0,-40.0,1.0,4.0,-5.0,2.0,6.0,-2.0,-3.0,8.0,-24.0,-1.0,161.0,1.0,-10.0,22.0,-123.0,-7.0,32.0,-89.0,-13.0,43.0,-81.0,-19.0,21.0,-78.0,-14.0,-8.0,-60.0,-15.0,-18.0,-55.0,-16.0,1.0,-54.0,-12.0,6.0,-47.0,0.0,-27.0,-4.0,-1.0,-28.0,-2.0,9.0,-18.0,45.0,0.0,-7.0,0.0,3.0,-1.0,2.0,-18.0,-8.0,-50.0,-10.0,-3.0,-41.0,2.0,-5.0,-1.0,-3.0,-37.0,-8.0,-6.0,-34.0,-8.0,9.0,-13.0,39.0,10.0,-12.0,35.0,2.0,0.0,2.0,-14.0,-44.0,-12.0,4.0,-2.0,2.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_17()
		{
			double[] value = {-29.0,-39.0,-9.0,-15.0,-14.0,0.0,-15.0,-1.0,0.0,-16.0,2.0,0.0,-15.0,14.0,1.0,-28.0,39.0,8.0,4.0,2.0,-2.0,-14.0,44.0,12.0,4.0,0.0,-3.0,9.0,14.0,-35.0,8.0,13.0,-38.0,-5.0,35.0,9.0,-1.0,37.0,8.0,2.0,4.0,0.0,54.0,-3.0,-1.0,0.0,5.0,40.0,0.0,13.0,53.0,0.0,6.0,0.0,0.0,17.0,-54.0,-1.0,5.0,-39.0,-55.0,-2.0,2.0,-3.0,5.0,0.0,-1.0,22.0,4.0,0.0,21.0,3.0,4.0,15.0,2.0,8.0,12.0,0.0,-7.0,6.0,43.0,-10.0,-2.0,50.0,-14.0,12.0,58.0,-11.0,42.0,61.0,-6.0,36.0,65.0,-26.0,2.0,97.0,-14.0,-1.0,98.0,-4.0,-23.0,96.0,-12.0,-42.0,54.0,-8.0,-30.0,19.0,0.0,13.0,26.0,0.0,0.0,2.0,-8.0,-62.0,2.0,1.0,0.0,5.0,-11.0,-6.0,31.0,-22.0,-1.0,73.0,-4.0,6.0,43.0,-21.0,-95.0,-9.0,-7.0,-101.0,4.0,-3.0,-52.0,19.0,-6.0,-48.0,47.0,-3.0,3.0,32.0,1.0,-36.0,3.0,6.0,-68.0,-17.0,7.0,63.0,29.0,0.0,40.0,-2.0,6.0,0.0,-2.0,5.0,54.0,-55.0,6.0,-5.0,-21.0,5.0,53.0,-19.0,5.0,0.0,1.0,7.0,98.0,0.0,1.0,2.0,7.0,-1.0,4.0,54.0,25.0,111.0,29.0,8.0,145.0,313.0,65.0,185.0,96.0,-4.0,-4.0,227.0,0.0,31.0,214.0,13.0,22.0,149.0,14.0,-16.0,125.0,0.0,-86.0,217.0,-73.0,-209.0,90.0,-41.0,-311.0,-2.0,-6.0,-92.0,-2.0,-2.0,-219.0,-11.0,7.0,-327.0,0.0,30.0,-331.0,52.0,64.0,-274.0,-31.0,44.0,-129.0,8.0,29.0,-62.0,13.0,13.0,-60.0,13.0,-2.0,-6.0,-165.0,-3.0,-8.0,-157.0,3.0,-123.0,95.0,0.0,-143.0,49.0,5.0,-71.0,54.0,6.0,-2.0,1.0,5.0,3.0,-2.0,0.0,8.0,-123.0,5.0,69.0,-54.0,0.0,21.0,-145.0,-2.0,28.0,-118.0,1.0,117.0,-61.0,3.0,113.0,-44.0,11.0,34.0,-12.0,24.0,37.0,-21.0,35.0,81.0,-29.0,0.0,-28.0,191.0,60.0,200.0,-16.0,41.0,326.0,-9.0,11.0,226.0,-36.0,18.0,303.0,-75.0,4.0,210.0,-17.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_18()
		{
			double[] value = {4.0,2.0,-249.0,-3.0,11.0,-294.0,-2.0,-108.0,21.0,-5.0,58.0,-236.0,-4.0,-72.0,-22.0,-3.0,28.0,-38.0,0.0,-100.0,11.0,1.0,0.0,-6.0,-11.0,-112.0,-41.0,4.0,1.0,-5.0,-13.0,-79.0,-94.0,17.0,11.0,-1.0,0.0,10.0,-1.0,-6.0,192.0,-22.0,-10.0,9.0,-52.0,-16.0,9.0,-52.0,-10.0,27.0,-129.0,4.0,226.0,2.0,-5.0,52.0,-96.0,-13.0,69.0,-84.0,-18.0,48.0,-71.0,-14.0,11.0,-56.0,-15.0,-2.0,-51.0,-16.0,11.0,-51.0,0.0,-27.0,-2.0,1.0,-16.0,5.0,-3.0,-2.0,-8.0,-13.0,-9.0,-49.0,-3.0,-50.0,-6.0,11.0,-7.0,38.0,0.0,-2.0,3.0,-3.0,-41.0,-9.0,2.0,0.0,4.0,-13.0,-46.0,-14.0,-28.0,-41.0,-10.0,-15.0,-15.0,-1.0,-19.0,-3.0,0.0,-20.0,4.0,0.0,-15.0,15.0,2.0,-28.0,41.0,10.0,-11.0,47.0,13.0,1.0,0.0,-4.0,-2.0,42.0,9.0,1.0,2.0,-4.0,11.0,8.0,-37.0,-2.0,50.0,7.0,2.0,5.0,1.0,-15.0,7.0,48.0,-2.0,0.0,2.0,3.0,7.0,-2.0,13.0,12.0,-47.0,-4.0,5.0,2.0,-1.0,28.0,3.0,0.0,27.0,4.0,4.0,17.0,2.0,-12.0,-4.0,48.0,-16.0,6.0,56.0,-14.0,31.0,58.0,-13.0,18.0,63.0,-18.0,-7.0,83.0,-12.0,-24.0,84.0,-7.0,-22.0,91.0,-9.0,-27.0,117.0,-3.0,-7.0,26.0,-13.0,-86.0,-19.0,2.0,-7.0,1.0,2.0,-1.0,4.0,-12.0,-4.0,36.0,-25.0,-1.0,89.0,-7.0,-111.0,9.0,-2.0,-42.0,11.0,-5.0,-55.0,39.0,-8.0,-23.0,47.0,5.0,-70.0,-15.0,1.0,-104.0,2.0,-2.0,-2.0,30.0,12.0,0.0,8.0,0.0,102.0,0.0,5.0,0.0,-2.0,-6.0,65.0,20.0,5.0,2.0,-24.0,0.0,34.0,0.0,4.0,0.0,2.0,7.0,53.0,-52.0,2.0,3.0,5.0,4.0,52.0,-20.0,-2.0,5.0,46.0,-6.0,11.0,279.0,5.0,88.0,25.0,-5.0,-17.0,299.0,42.0,265.0,23.0,3.0,17.0,246.0,4.0,-18.0,194.0,7.0,-18.0,169.0,-45.0,-326.0,16.0,-6.0,-135.0,-15.0,0.0,-208.0,-4.0,10.0,-319.0,11.0,7.0,-117.0,11.0,33.0,-315.0,25.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_19()
		{
			double[] value = {63.0,-242.0,25.0,41.0,-112.0,15.0,26.0,-45.0,13.0,-1.0,-18.0,-163.0,1.0,-5.0,-106.0,10.0,-31.0,24.0,3.0,-121.0,61.0,0.0,-137.0,59.0,5.0,-69.0,54.0,6.0,-3.0,1.0,0.0,23.0,-145.0,5.0,3.0,-2.0,-2.0,29.0,-145.0,0.0,21.0,-136.0,4.0,35.0,-133.0,0.0,40.0,98.0,0.0,105.0,-51.0,5.0,110.0,-54.0,12.0,38.0,-7.0,23.0,35.0,-11.0,37.0,78.0,-15.0,53.0,161.0,16.0,40.0,297.0,-31.0,21.0,271.0,-49.0,18.0,290.0,-24.0,-1.0,6.0,-277.0,-10.0,13.0,-251.0,-13.0,-131.0,-45.0,-2.0,-22.0,-24.0,0.0,41.0,-9.0,-15.0,-68.0,-107.0,-13.0,-43.0,-132.0,1.0,25.0,-11.0,2.0,122.0,7.0,-14.0,16.0,-135.0,-4.0,72.0,-107.0,6.0,128.0,16.0,-10.0,122.0,-89.0,-19.0,94.0,-72.0,-13.0,40.0,-51.0,-14.0,14.0,-48.0,-19.0,4.0,-51.0,-1.0,-42.0,-2.0,-3.0,-43.0,0.0,-14.0,-50.0,-10.0,-28.0,-47.0,-5.0,-16.0,-16.0,-1.0,-17.0,-2.0,0.0,-18.0,3.0,0.0,-16.0,16.0,2.0,-28.0,47.0,5.0,-14.0,50.0,10.0,-2.0,44.0,0.0,0.0,43.0,2.0,-2.0,29.0,5.0,-2.0,1.0,7.0,1.0,17.0,-5.0,-1.0,25.0,3.0,0.0,32.0,4.0,-18.0,0.0,54.0,-16.0,19.0,55.0,-13.0,7.0,60.0,-19.0,-22.0,78.0,-14.0,-43.0,81.0,-7.0,-32.0,89.0,-10.0,-22.0,122.0,-1.0,-161.0,-1.0,-2.0,-8.0,25.0,3.0,-6.0,2.0,0.0,-4.0,5.0,-19.0,-12.0,40.0,-25.0,-120.0,133.0,1.0,-107.0,13.0,8.0,-89.0,-32.0,-7.0,-17.0,17.0,-1.0,-9.0,27.0,14.0,-5.0,6.0,5.0,0.0,-2.0,-11.0,114.0,48.0,4.0,2.0,-23.0,0.0,102.0,-12.0,3.0,0.0,2.0,-5.0,63.0,34.0,1.0,-2.0,7.0,-1.0,38.0,0.0,0.0,-1.0,17.0,5.0,58.0,-39.0,-6.0,2.0,263.0,2.0,81.0,312.0,2.0,34.0,238.0,4.0,-31.0,239.0,-6.0,-165.0,-25.0,2.0,-217.0,13.0,17.0,-299.0,41.0,9.0,-184.0,17.0,38.0,-331.0,15.0,57.0,-211.0,15.0,39.0,-96.0,16.0,1.0,-4.0,-121.0,-1.0,5.0,-79.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_20()
		{
			double[] value = {23.0,-35.0,12.0,9.0,-30.0,11.0,6.0,-116.0,31.0,0.0,-129.0,56.0,6.0,-67.0,53.0,2.0,28.0,-144.0,4.0,-5.0,1.0,0.0,22.0,-136.0,0.0,38.0,-143.0,0.0,34.0,-146.0,2.0,3.0,-3.0,0.0,52.0,-181.0,1.0,77.0,-67.0,1.0,-54.0,179.0,2.0,-39.0,160.0,1.0,102.0,-79.0,4.0,102.0,-68.0,12.0,43.0,-7.0,21.0,36.0,-17.0,37.0,82.0,-26.0,56.0,168.0,-16.0,38.0,284.0,-48.0,21.0,269.0,-40.0,-12.0,49.0,-345.0,-10.0,16.0,-124.0,-15.0,-21.0,-140.0,-15.0,50.0,-150.0,-5.0,77.0,-111.0,-5.0,185.0,-76.0,-19.0,154.0,-63.0,-13.0,74.0,-52.0,-11.0,42.0,-46.0,-14.0,-54.0,-13.0,-16.0,-62.0,-6.0,-32.0,-52.0,-7.0,-16.0,-17.0,-1.0,-14.0,-4.0,0.0,-15.0,5.0,1.0,-16.0,17.0,1.0,-32.0,52.0,7.0,-16.0,62.0,6.0,-13.0,54.0,13.0,-6.0,70.0,11.0,-1.0,67.0,10.0,-16.0,2.0,51.0,-13.0,-12.0,56.0,-19.0,-48.0,71.0,-12.0,-71.0,83.0,-5.0,-50.0,96.0,4.0,-226.0,-2.0,-11.0,-27.0,130.0,-16.0,-9.0,52.0,-9.0,-9.0,52.0,-6.0,-192.0,22.0,0.0,-10.0,1.0,17.0,-10.0,1.0,-13.0,79.0,94.0,4.0,-1.0,5.0,-11.0,112.0,41.0,1.0,0.0,5.0,-1.0,100.0,-11.0,-2.0,-28.0,39.0,-5.0,72.0,22.0,-5.0,-58.0,235.0,-2.0,108.0,-21.0,-2.0,-12.0,295.0,5.0,-2.0,249.0,4.0,-210.0,17.0,18.0,-303.0,75.0,12.0,-226.0,36.0,40.0,-326.0,9.0,59.0,-199.0,15.0,0.0,28.0,-191.0,36.0,-82.0,30.0,24.0,-37.0,21.0,11.0,-34.0,12.0,4.0,-113.0,44.0,0.0,-116.0,60.0,1.0,28.0,-143.0,3.0,-74.0,34.0,-3.0,35.0,-134.0,5.0,35.0,-156.0,0.0,51.0,-181.0,3.0,-2.0,-4.0,0.0,52.0,-138.0,3.0,4.0,-1.0,0.0,64.0,-31.0,0.0,56.0,-119.0,0.0,46.0,-79.0,0.0,30.0,41.0,0.0,-67.0,127.0,0.0,-21.0,61.0,3.0,-49.0,159.0,3.0,101.0,-77.0,10.0,48.0,-22.0,20.0,39.0,-23.0,36.0,95.0,-43.0,55.0,187.0,-53.0,33.0,269.0,-114.0,-8.0,34.0,-149.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_21()
		{
			double[] value = {-17.0,46.0,-178.0,-17.0,60.0,-145.0,-2.0,107.0,-124.0,-5.0,170.0,-83.0,-5.0,54.0,-26.0,-11.0,162.0,-43.0,-9.0,84.0,-35.0,-19.0,-81.0,-15.0,-37.0,-78.0,-14.0,-18.0,-25.0,-3.0,-16.0,-6.0,0.0,-16.0,7.0,0.0,-19.0,25.0,4.0,-37.0,78.0,14.0,-19.0,81.0,15.0,-13.0,85.0,9.0,-9.0,98.0,13.0,-13.0,-40.0,51.0,-19.0,-94.0,72.0,-9.0,-122.0,88.0,6.0,-128.0,-16.0,-4.0,-72.0,108.0,-14.0,-16.0,134.0,3.0,-122.0,-7.0,0.0,-24.0,12.0,-14.0,44.0,132.0,-14.0,67.0,107.0,0.0,-41.0,9.0,-2.0,23.0,24.0,-14.0,130.0,45.0,-10.0,-14.0,251.0,0.0,-6.0,277.0,19.0,-290.0,24.0,21.0,-271.0,49.0,40.0,-297.0,30.0,53.0,-161.0,-16.0,37.0,-78.0,16.0,23.0,-35.0,11.0,12.0,-38.0,7.0,5.0,-109.0,53.0,0.0,27.0,-191.0,1.0,-101.0,78.0,2.0,40.0,-161.0,1.0,54.0,-179.0,0.0,38.0,-105.0,0.0,-63.0,30.0,0.0,42.0,-95.0,4.0,-1.0,-4.0,4.0,2.0,4.0,0.0,84.0,-125.0,0.0,55.0,-81.0,1.0,35.0,-9.0,1.0,67.0,-17.0,-1.0,-52.0,84.0,7.0,81.0,-18.0,-4.0,-90.0,178.0,15.0,42.0,-17.0,18.0,26.0,-10.0,33.0,81.0,-21.0,53.0,179.0,-17.0,-4.0,41.0,-171.0,-15.0,112.0,-196.0,-13.0,86.0,-138.0,-7.0,129.0,-110.0,0.0,179.0,-108.0,-4.0,100.0,-38.0,-6.0,111.0,-40.0,-40.0,-96.0,-12.0,-21.0,-28.0,0.0,-18.0,-6.0,0.0,-19.0,7.0,0.0,-20.0,28.0,1.0,-41.0,96.0,12.0,-20.0,121.0,28.0,-17.0,95.0,26.0,-19.0,-154.0,63.0,-5.0,-185.0,76.0,-4.0,-77.0,111.0,-16.0,-49.0,150.0,-15.0,21.0,140.0,-10.0,-17.0,124.0,-11.0,-49.0,345.0,22.0,-269.0,40.0,39.0,-284.0,48.0,55.0,-168.0,16.0,37.0,-82.0,26.0,22.0,-36.0,17.0,11.0,-42.0,6.0,2.0,24.0,-185.0,3.0,-100.0,76.0,2.0,50.0,-160.0,0.0,21.0,-61.0,0.0,66.0,-126.0,0.0,-76.0,38.0,0.0,45.0,-79.0,0.0,-39.0,9.0,5.0,0.0,-1.0,0.0,55.0,-84.0,0.0,27.0,-41.0,9.0,0.0,-1.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_22()
		{
			double[] value = {0.0,30.0,-3.0,3.0,64.0,-4.0,6.0,67.0,8.0,23.0,10.0,37.0,30.0,61.0,-10.0,-19.0,160.0,-243.0,-6.0,92.0,-100.0,-4.0,115.0,-94.0,0.0,206.0,-128.0,-1.0,91.0,-38.0,-23.0,-24.0,-2.0,-19.0,-5.0,0.0,-20.0,6.0,0.0,-23.0,24.0,3.0,-43.0,93.0,13.0,-25.0,70.0,31.0,-5.0,-54.0,26.0,-5.0,-170.0,83.0,-1.0,-107.0,124.0,-18.0,-60.0,145.0,-17.0,-46.0,178.0,-7.0,-34.0,149.0,34.0,-269.0,114.0,55.0,-187.0,53.0,36.0,-95.0,43.0,19.0,-38.0,22.0,-3.0,56.0,-159.0,14.0,-41.0,16.0,-4.0,90.0,-178.0,7.0,-81.0,18.0,0.0,52.0,-84.0,1.0,-68.0,18.0,0.0,-34.0,8.0,-3.0,26.0,-46.0,1.0,114.0,-106.0,8.0,0.0,0.0,8.0,0.0,0.0,0.0,40.0,-5.0,1.0,44.0,-8.0,4.0,51.0,12.0,19.0,9.0,11.0,-9.0,92.0,-124.0,-2.0,105.0,-102.0,-2.0,119.0,-89.0,0.0,204.0,-125.0,-20.0,-5.0,0.0,-21.0,6.0,0.0,-23.0,26.0,0.0,-45.0,84.0,13.0,0.0,-179.0,108.0,-8.0,-129.0,110.0,-13.0,-86.0,138.0,-15.0,-112.0,196.0,-2.0,-41.0,171.0,53.0,-179.0,17.0,33.0,-80.0,20.0,0.0,87.0,-199.0,24.0,-10.0,-38.0,6.0,-67.0,-7.0,3.0,-63.0,4.0,0.0,124.0,-108.0,0.0,43.0,-42.0,9.0,0.0,0.0,7.0,0.0,0.0,0.0,47.0,-24.0,0.0,97.0,-39.0,-1.0,110.0,-107.0,-7.0,117.0,-87.0,-21.0,6.0,0.0,-23.0,24.0,2.0,-4.0,-115.0,94.0,-6.0,-92.0,100.0,-18.0,-159.0,242.0,39.0,25.0,-124.0,20.0,-9.0,-12.0,4.0,-50.0,-12.0,1.0,46.0,-57.0,8.0,1.0,0.0,0.0,97.0,-38.0,0.0,109.0,-107.0,-8.0,0.0,0.0,-15.0,3.0,1.0,-1.0,-105.0,102.0,16.0,-8.0,3.0,109.0,965.0,-279.0,4.0,-5.0,17.0,3.0,-8.0,16.0,3.0,-10.0,14.0,2.0,-13.0,13.0,2.0,-14.0,10.0,0.0,-16.0,8.0,0.0,-18.0,4.0,-1.0,-18.0,1.0,-1.0,-17.0,-1.0,-2.0,-18.0,-4.0,-3.0,-16.0,-8.0,-3.0,-14.0,-9.0,-4.0,-13.0,-13.0,-4.0,-10.0,-14.0,-4.0,-8.0,-15.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_23()
		{
			double[] value = {-5.0,-4.0,-17.0,-5.0,-1.0,-18.0,-6.0,2.0,-17.0,-5.0,4.0,-17.0,-5.0,8.0,-16.0,-4.0,10.0,-14.0,-3.0,12.0,-13.0,36.0,-2.0,-7.0,4.0,-13.0,12.0,5.0,-10.0,14.0,5.0,-8.0,16.0,6.0,-4.0,17.0,5.0,-1.0,18.0,5.0,1.0,17.0,5.0,5.0,17.0,5.0,8.0,15.0,4.0,10.0,15.0,4.0,12.0,12.0,3.0,15.0,10.0,3.0,16.0,7.0,2.0,18.0,4.0,1.0,17.0,0.0,0.0,18.0,-1.0,0.0,17.0,-5.0,-1.0,17.0,-8.0,-2.0,14.0,-10.0,-2.0,13.0,-12.0,-3.0,10.0,-15.0,-3.0,8.0,-16.0,-4.0,4.0,-16.0,-4.0,2.0,-17.0,-38.0,1.0,9.0,-2.0,-4.0,1.0,4.0,-1.0,16.0,4.0,-5.0,16.0,3.0,-7.0,16.0,3.0,-10.0,13.0,2.0,-12.0,12.0,1.0,-14.0,10.0,0.0,-16.0,7.0,0.0,-16.0,5.0,0.0,-17.0,1.0,-2.0,-17.0,-2.0,-2.0,-17.0,-4.0,-2.0,-16.0,-7.0,-3.0,-14.0,-9.0,-4.0,-12.0,-12.0,-4.0,-10.0,-13.0,-4.0,-7.0,-15.0,-5.0,-4.0,-16.0,-5.0,-1.0,-17.0,-5.0,2.0,-17.0,-5.0,4.0,-16.0,-5.0,8.0,-15.0,-4.0,9.0,-14.0,-4.0,13.0,-12.0,-1.0,13.0,-10.0,1.0,-3.0,-4.0,36.0,-1.0,-8.0,6.0,0.0,1.0,4.0,-14.0,10.0,4.0,-12.0,12.0,4.0,-10.0,14.0,5.0,-8.0,16.0,6.0,-4.0,16.0,5.0,-1.0,17.0,5.0,2.0,17.0,5.0,4.0,17.0,5.0,7.0,15.0,4.0,10.0,14.0,3.0,13.0,12.0,4.0,14.0,9.0,2.0,16.0,7.0,2.0,17.0,4.0,1.0,17.0,1.0,0.0,17.0,-2.0,0.0,17.0,-5.0,-1.0,16.0,-7.0,-1.0,14.0,-10.0,-2.0,13.0,-12.0,-3.0,10.0,-14.0,-3.0,7.0,-16.0,-4.0,5.0,-16.0,-4.0,0.0,-17.0,-5.0,0.0,-16.0,-6.0,2.0,1.0,-38.0,2.0,9.0,-2.0,-4.0,0.0,-5.0,-5.0,-16.0,-6.0,-7.0,-15.0,-5.0,-10.0,-14.0,-5.0,-12.0,-12.0,-5.0,-14.0,-9.0,-4.0,-15.0,-7.0,-3.0,-17.0,-4.0,-2.0,-17.0,0.0,0.0,-17.0,1.0,0.0,-17.0,4.0,1.0,-1.0,-4.0,36.0,-1.0,-8.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_24()
		{
			double[] value = {7.0,0.0,1.0,4.0,1.0,4.0,2.0,-15.0,7.0,3.0,-14.0,9.0,4.0,-11.0,12.0,4.0,-10.0,13.0,5.0,-7.0,15.0,5.0,-4.0,15.0,6.0,0.0,16.0,5.0,1.0,16.0,4.0,4.0,16.0,5.0,7.0,14.0,4.0,10.0,13.0,3.0,11.0,11.0,3.0,14.0,9.0,3.0,15.0,7.0,1.0,15.0,4.0,1.0,17.0,0.0,0.0,16.0,-1.0,0.0,16.0,-5.0,0.0,15.0,-7.0,-2.0,14.0,-9.0,-2.0,11.0,-12.0,-2.0,10.0,-13.0,-4.0,7.0,-14.0,-3.0,4.0,-16.0,-4.0,0.0,-16.0,-5.0,-1.0,-16.0,-5.0,-3.0,-15.0,-3.0,5.0,-1.0,-7.0,3.0,1.0,-37.0,1.0,8.0,-5.0,-7.0,-16.0,-6.0,-11.0,-14.0,-5.0,-12.0,-12.0,-5.0,-15.0,-10.0,-4.0,-16.0,-7.0,-4.0,-17.0,-5.0,-2.0,-18.0,0.0,0.0,-18.0,1.0,35.0,-1.0,-8.0,7.0,0.0,1.0,5.0,1.0,5.0,4.0,2.0,21.0,1.0,-12.0,3.0,1.0,-11.0,5.0,2.0,-11.0,8.0,3.0,-9.0,8.0,4.0,-7.0,11.0,4.0,-6.0,11.0,4.0,-3.0,12.0,4.0,0.0,12.0,4.0,1.0,13.0,4.0,3.0,12.0,4.0,6.0,11.0,3.0,7.0,10.0,3.0,9.0,9.0,3.0,10.0,7.0,2.0,12.0,5.0,1.0,12.0,3.0,1.0,13.0,0.0,0.0,13.0,-1.0,0.0,12.0,-4.0,-1.0,11.0,-5.0,-1.0,11.0,-7.0,-2.0,9.0,-9.0,-2.0,7.0,-11.0,-3.0,6.0,-11.0,-3.0,3.0,-12.0,-3.0,0.0,-12.0,-4.0,-1.0,-13.0,-5.0,-3.0,-12.0,-3.0,-5.0,-11.0,0.0,19.0,-11.0,-3.0,5.0,-2.0,-6.0,1.0,0.0,-6.0,-10.0,-14.0,-6.0,-13.0,-12.0,-5.0,-14.0,-10.0,-4.0,-16.0,-7.0,-4.0,-18.0,-4.0,-2.0,-17.0,-1.0,7.0,-1.0,1.0,5.0,0.0,5.0,4.0,0.0,21.0,7.0,0.0,20.0,0.0,-9.0,1.0,1.0,-9.0,3.0,0.0,-8.0,4.0,2.0,-8.0,5.0,2.0,-6.0,6.0,3.0,-5.0,7.0,2.0,-4.0,8.0,3.0,-2.0,9.0,3.0,0.0,9.0,4.0,1.0,9.0,3.0,2.0,8.0,3.0,4.0,8.0,2.0,5.0,7.0,2.0,6.0,7.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_25()
		{
			double[] value = {2.0,8.0,5.0,2.0,8.0,3.0,1.0,9.0,2.0,0.0,9.0,0.0,0.0,9.0,-1.0,0.0,9.0,-2.0,0.0,8.0,-4.0,-1.0,7.0,-5.0,-1.0,7.0,-7.0,-2.0,5.0,-7.0,-2.0,4.0,-8.0,-3.0,2.0,-9.0,-3.0,0.0,-8.0,-3.0,-1.0,-9.0,-3.0,-2.0,-9.0,-3.0,-4.0,-8.0,-3.0,-4.0,-7.0,-3.0,16.0,-13.0,0.0,16.0,-14.0,-4.0,4.0,-3.0,-5.0,-12.0,-12.0,-5.0,-15.0,-9.0,-5.0,-15.0,-7.0,-2.0,-17.0,-3.0,4.0,-2.0,4.0,4.0,-3.0,21.0,7.0,-3.0,20.0,2.0,9.0,2.0,2.0,8.0,4.0,2.0,8.0,4.0,-4.0,13.0,-16.0,-1.0,13.0,-16.0,-5.0,-14.0,-9.0,-3.0,-15.0,-6.0,2.0,-6.0,20.0,3.0,12.0,5.0,-215.0,66.0,89.0,-4.0,-5.0,17.0,-3.0,-8.0,16.0,-3.0,-10.0,14.0,-2.0,-13.0,13.0,-1.0,-14.0,10.0,0.0,-16.0,8.0,0.0,-18.0,4.0,0.0,-18.0,1.0,2.0,-17.0,-1.0,2.0,-18.0,-4.0,2.0,-16.0,-8.0,4.0,-14.0,-9.0,3.0,-13.0,-13.0,4.0,-10.0,-14.0,5.0,-8.0,-15.0,4.0,-4.0,-17.0,6.0,-1.0,-18.0,5.0,2.0,-17.0,5.0,4.0,-17.0,5.0,8.0,-16.0,5.0,10.0,-14.0,3.0,13.0,-12.0,1.0,2.0,4.0,-4.0,-13.0,12.0,-4.0,-9.0,14.0,-5.0,-8.0,15.0,-5.0,-4.0,16.0,-5.0,-1.0,17.0,-5.0,2.0,17.0,-5.0,4.0,16.0,-4.0,7.0,15.0,-4.0,10.0,13.0,-3.0,12.0,12.0,-3.0,14.0,9.0,-3.0,16.0,7.0,-2.0,17.0,4.0,-1.0,17.0,1.0,0.0,17.0,-2.0,0.0,16.0,-5.0,1.0,16.0,-7.0,1.0,14.0,-10.0,2.0,12.0,-12.0,3.0,10.0,-13.0,3.0,7.0,-16.0,4.0,5.0,-16.0,3.0,1.0,-16.0,-3.0,3.0,-1.0,-38.0,-2.0,-8.0,-4.0,-2.0,18.0,-4.0,-4.0,16.0,-3.0,-8.0,16.0,-3.0,-10.0,15.0,-2.0,-13.0,12.0,-1.0,-14.0,10.0,0.0,-17.0,8.0,0.0,-17.0,5.0,0.0,-18.0,0.0,2.0,-17.0,-1.0,2.0,-18.0,-4.0,2.0,-16.0,-7.0,4.0,-15.0,-10.0,3.0,-12.0,-12.0,4.0,-10.0,-15.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_26()
		{
			double[] value = {5.0,-8.0,-15.0,5.0,-5.0,-17.0,5.0,0.0,-17.0,6.0,2.0,-18.0,5.0,4.0,-17.0,5.0,8.0,-16.0,5.0,10.0,-14.0,4.0,13.0,-12.0,3.0,14.0,-10.0,36.0,2.0,9.0,2.0,3.0,3.0,1.0,15.0,-7.0,0.0,17.0,-5.0,-1.0,17.0,0.0,-2.0,17.0,1.0,-4.0,17.0,4.0,-4.0,15.0,7.0,-5.0,14.0,9.0,-5.0,12.0,12.0,-5.0,10.0,14.0,-5.0,7.0,15.0,-5.0,5.0,15.0,-3.0,3.0,-1.0,-38.0,-3.0,-9.0,-6.0,-1.0,0.0,-4.0,0.0,17.0,-5.0,-1.0,17.0,-4.0,-5.0,16.0,-3.0,-7.0,16.0,-3.0,-10.0,14.0,-2.0,-13.0,12.0,-1.0,-14.0,10.0,0.0,-16.0,7.0,0.0,-17.0,5.0,1.0,-17.0,1.0,1.0,-17.0,-2.0,2.0,-17.0,-4.0,3.0,-16.0,-7.0,3.0,-14.0,-9.0,3.0,-13.0,-12.0,4.0,-10.0,-14.0,5.0,-7.0,-15.0,5.0,-4.0,-17.0,5.0,-1.0,-17.0,5.0,2.0,-17.0,6.0,4.0,-16.0,5.0,8.0,-16.0,5.0,10.0,-14.0,4.0,12.0,-12.0,3.0,14.0,-10.0,2.0,16.0,-7.0,6.0,0.0,0.0,35.0,2.0,8.0,0.0,17.0,-5.0,-1.0,18.0,-1.0,-2.0,18.0,1.0,-3.0,17.0,5.0,-5.0,16.0,7.0,-5.0,15.0,10.0,-5.0,12.0,12.0,-5.0,11.0,14.0,-6.0,6.0,15.0,-37.0,-2.0,-9.0,-6.0,-3.0,0.0,-4.0,-4.0,2.0,-5.0,4.0,15.0,-4.0,0.0,16.0,-5.0,-1.0,16.0,-3.0,-4.0,16.0,-3.0,-7.0,14.0,-3.0,-10.0,13.0,-2.0,-11.0,12.0,-1.0,-14.0,9.0,0.0,-15.0,7.0,0.0,-16.0,5.0,0.0,-16.0,0.0,2.0,-17.0,-1.0,2.0,-15.0,-4.0,2.0,-15.0,-7.0,3.0,-14.0,-9.0,4.0,-11.0,-11.0,3.0,-10.0,-13.0,5.0,-7.0,-14.0,5.0,-4.0,-16.0,5.0,0.0,-16.0,5.0,1.0,-16.0,5.0,4.0,-15.0,5.0,7.0,-15.0,4.0,10.0,-13.0,4.0,11.0,-12.0,3.0,14.0,-9.0,2.0,15.0,-7.0,0.0,15.0,-4.0,5.0,0.0,-5.0,6.0,0.0,-1.0,-1.0,18.0,-1.0,-3.0,17.0,2.0,-3.0,18.0,4.0,-5.0,16.0,7.0,-5.0,14.0,10.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_27()
		{
			double[] value = {-6.0,13.0,12.0,-6.0,9.0,14.0,-6.0,-2.0,0.0,-2.0,-5.0,2.0,0.0,-18.0,11.0,-4.0,6.0,11.0,-4.0,3.0,12.0,-4.0,0.0,13.0,-4.0,-1.0,12.0,-3.0,-3.0,12.0,-3.0,-6.0,11.0,-2.0,-7.0,11.0,-2.0,-9.0,9.0,-1.0,-11.0,7.0,0.0,-11.0,5.0,0.0,-12.0,4.0,1.0,-13.0,0.0,1.0,-13.0,-1.0,2.0,-12.0,-3.0,2.0,-12.0,-5.0,2.0,-10.0,-7.0,3.0,-9.0,-9.0,3.0,-7.0,-10.0,4.0,-6.0,-11.0,4.0,-3.0,-12.0,4.0,0.0,-13.0,4.0,1.0,-12.0,5.0,3.0,-12.0,4.0,6.0,-11.0,3.0,7.0,-11.0,3.0,9.0,-8.0,2.0,11.0,-8.0,1.0,11.0,-5.0,0.0,12.0,-3.0,0.0,13.0,-2.0,4.0,0.0,-21.0,4.0,0.0,-4.0,-2.0,18.0,2.0,-4.0,17.0,4.0,-5.0,15.0,7.0,-5.0,15.0,9.0,-5.0,11.0,12.0,-4.0,-5.0,3.0,0.0,-16.0,14.0,-3.0,-15.0,13.0,-3.0,5.0,7.0,-3.0,4.0,8.0,-3.0,2.0,9.0,-3.0,0.0,9.0,-3.0,-1.0,8.0,-2.0,-2.0,9.0,-3.0,-4.0,8.0,-1.0,-5.0,7.0,-2.0,-7.0,7.0,0.0,-7.0,5.0,0.0,-8.0,4.0,0.0,-9.0,2.0,0.0,-9.0,0.0,1.0,-9.0,-1.0,1.0,-9.0,-2.0,2.0,-8.0,-3.0,2.0,-8.0,-5.0,2.0,-6.0,-7.0,3.0,-5.0,-7.0,3.0,-4.0,-8.0,3.0,-2.0,-8.0,3.0,0.0,-9.0,3.0,1.0,-9.0,3.0,2.0,-9.0,3.0,4.0,-8.0,2.0,5.0,-7.0,2.0,6.0,-6.0,2.0,8.0,-5.0,0.0,8.0,-4.0,0.0,9.0,-3.0,-1.0,9.0,0.0,0.0,9.0,0.0,7.0,4.0,-20.0,3.0,3.0,-20.0,-4.0,16.0,4.0,-4.0,15.0,7.0,-5.0,13.0,9.0,0.0,-14.0,16.0,-4.0,-13.0,15.0,3.0,-8.0,-5.0,2.0,-7.0,-4.0,6.0,7.0,-18.0,-3.0,12.0,5.0,54.0,310.0,712.0,-2.0,16.0,-5.0,-3.0,-19.0,39.0,-35.0,-27.0,19.0,1.0,38.0,26.0,-26.0,2.0,-2.0,-1.0,-24.0,-17.0,-2.0,-23.0,-17.0,-1.0,-23.0,-16.0,-14.0,0.0,-15.0,69.0,56.0,-24.0,-27.0,17.0,-14.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_28()
		{
			double[] value = {-14.0,4.0,0.0,15.0,28.0,8.0,15.0,-6.0,1.0,8.0,130.0,116.0,22.0,-17.0,17.0,5.0,-6.0,14.0,-8.0,-45.0,-11.0,-37.0,-19.0,15.0,-2.0,-37.0,-27.0,-26.0,-12.0,-13.0,-32.0,-5.0,4.0,-32.0,-2.0,2.0,30.0,-14.0,-19.0,0.0,-8.0,-6.0,0.0,-21.0,-8.0,0.0,-9.0,-5.0,-2.0,-22.0,-15.0,-2.0,-23.0,-23.0,-2.0,23.0,-22.0,-10.0,3.0,1.0,-10.0,6.0,6.0,-2.0,19.0,14.0,1.0,15.0,12.0,1.0,19.0,14.0,1.0,14.0,10.0,3.0,13.0,8.0,0.0,12.0,6.0,85.0,66.0,-25.0,1.0,56.0,48.0,-11.0,11.0,20.0,16.0,-3.0,3.0,25.0,-19.0,13.0,-69.0,-17.0,28.0,15.0,-20.0,0.0,-2.0,-26.0,-14.0,-1.0,-21.0,-19.0,-2.0,-22.0,-16.0,-32.0,0.0,7.0,-1.0,-23.0,-14.0,-32.0,-2.0,3.0,-24.0,-9.0,12.0,-1.0,-8.0,-5.0,-4.0,-18.0,-14.0,26.0,11.0,-15.0,0.0,-9.0,-5.0,0.0,-21.0,-9.0,0.0,-9.0,-5.0,-1.0,-23.0,-15.0,-5.0,-23.0,-22.0,-11.0,6.0,-4.0,-11.0,5.0,4.0,-1.0,22.0,16.0,-1.0,10.0,4.0,1.0,8.0,5.0,2.0,5.0,6.0,-25.0,-21.0,16.0,25.0,33.0,-8.0,-1.0,10.0,4.0,0.0,7.0,4.0,3.0,3.0,5.0,-2.0,10.0,4.0,2.0,4.0,4.0,-1.0,7.0,2.0,0.0,6.0,4.0,3.0,6.0,5.0,33.0,18.0,-17.0,-1.0,10.0,5.0,2.0,11.0,9.0,0.0,18.0,9.0,3.0,22.0,16.0,1.0,32.0,20.0,3.0,10.0,9.0,13.0,1.0,2.0,8.0,-2.0,0.0,1.0,-24.0,12.0,-2.0,-29.0,-14.0,-1.0,-20.0,-18.0,0.0,-9.0,-4.0,-32.0,0.0,2.0,0.0,-26.0,-9.0,-25.0,-8.0,12.0,-15.0,-10.0,12.0,-2.0,-28.0,-14.0,-1.0,-9.0,-4.0,-5.0,-23.0,-14.0,0.0,-7.0,-6.0,18.0,18.0,-14.0,0.0,-23.0,-7.0,1.0,-8.0,-7.0,-3.0,-25.0,-12.0,-6.0,-26.0,-20.0,-11.0,1.0,-3.0,-10.0,3.0,3.0,0.0,24.0,14.0,-2.0,9.0,4.0,0.0,7.0,5.0,-17.0,-25.0,15.0,3.0,7.0,6.0,2.0,16.0,4.0,17.0,23.0,-12.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_29()
		{
			double[] value = {-2.0,10.0,4.0,0.0,7.0,4.0,2.0,4.0,4.0,-1.0,11.0,3.0,2.0,4.0,4.0,-1.0,8.0,3.0,0.0,6.0,3.0,3.0,7.0,6.0,-2.0,8.0,1.0,25.0,15.0,-13.0,0.0,6.0,3.0,3.0,3.0,5.0,0.0,9.0,4.0,-2.0,8.0,3.0,1.0,11.0,6.0,3.0,14.0,11.0,0.0,24.0,15.0,0.0,14.0,6.0,3.0,10.0,8.0,13.0,0.0,2.0,11.0,-10.0,2.0,0.0,-29.0,-14.0,-3.0,-22.0,-17.0,-25.0,-6.0,11.0,0.0,-9.0,-4.0,-17.0,-7.0,15.0,-43.0,-10.0,79.0,3.0,-41.0,-15.0,-2.0,-40.0,-16.0,-1.0,-9.0,-4.0,-6.0,-30.0,-14.0,0.0,-17.0,-7.0,2.0,-31.0,-11.0,43.0,54.0,-71.0,1.0,-8.0,-6.0,-3.0,-29.0,-13.0,-7.0,-30.0,-19.0,-10.0,1.0,-2.0,-11.0,4.0,3.0,1.0,26.0,13.0,-3.0,9.0,4.0,-41.0,-70.0,71.0,0.0,11.0,5.0,3.0,11.0,6.0,1.0,20.0,5.0,-2.0,14.0,3.0,42.0,57.0,-69.0,0.0,8.0,4.0,2.0,5.0,4.0,-1.0,12.0,4.0,2.0,5.0,4.0,-2.0,8.0,2.0,1.0,7.0,3.0,2.0,9.0,6.0,-1.0,8.0,2.0,0.0,8.0,2.0,19.0,13.0,-12.0,2.0,5.0,4.0,0.0,9.0,5.0,-1.0,8.0,2.0,1.0,11.0,6.0,4.0,16.0,10.0,0.0,25.0,14.0,0.0,15.0,7.0,4.0,11.0,9.0,13.0,1.0,1.0,8.0,-6.0,0.0,0.0,-31.0,-13.0,-15.0,-3.0,13.0,-4.0,-27.0,-15.0,-44.0,-9.0,77.0,-38.0,-9.0,108.0,0.0,-10.0,0.0,3.0,-53.0,-17.0,-2.0,-54.0,-17.0,-1.0,-9.0,-3.0,-8.0,-41.0,-16.0,0.0,-19.0,-6.0,0.0,-43.0,-11.0,-24.0,-44.0,99.0,25.0,36.0,-103.0,41.0,58.0,-107.0,-3.0,-41.0,-15.0,-8.0,-42.0,-20.0,-9.0,0.0,-2.0,-10.0,5.0,2.0,2.0,32.0,14.0,-44.0,-80.0,103.0,-2.0,15.0,7.0,1.0,10.0,3.0,3.0,12.0,6.0,2.0,36.0,6.0,-2.0,16.0,2.0,1.0,14.0,2.0,42.0,58.0,-100.0,2.0,8.0,3.0,-2.0,16.0,4.0,3.0,9.0,3.0,-2.0,12.0,2.0,1.0,10.0,3.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_30()
		{
			double[] value = {3.0,13.0,7.0,-2.0,11.0,2.0,0.0,12.0,2.0,4.0,9.0,3.0,39.0,21.0,-67.0,0.0,10.0,6.0,-1.0,9.0,2.0,1.0,14.0,6.0,5.0,18.0,10.0,3.0,26.0,14.0,1.0,16.0,8.0,3.0,13.0,8.0,12.0,2.0,2.0,8.0,-5.0,0.0,-43.0,14.0,81.0,0.0,-45.0,-15.0,-36.0,4.0,109.0,-25.0,13.0,102.0,-6.0,-64.0,-18.0,0.0,-10.0,-3.0,2.0,-64.0,-16.0,-3.0,-64.0,-18.0,-1.0,-10.0,-2.0,-6.0,-60.0,-18.0,-1.0,-10.0,-2.0,-5.0,-10.0,22.0,1.0,-59.0,-15.0,0.0,-8.0,-3.0,5.0,10.0,-22.0,-2.0,-63.0,-18.0,24.0,55.0,-100.0,-9.0,-56.0,-20.0,-9.0,1.0,-2.0,-11.0,6.0,1.0,-25.0,-67.0,99.0,0.0,31.0,21.0,-2.0,16.0,7.0,0.0,12.0,6.0,4.0,14.0,6.0,2.0,44.0,3.0,-2.0,17.0,3.0,1.0,15.0,2.0,3.0,14.0,2.0,27.0,54.0,-106.0,-1.0,22.0,3.0,4.0,14.0,2.0,0.0,12.0,2.0,0.0,13.0,1.0,3.0,16.0,6.0,-2.0,15.0,1.0,1.0,12.0,2.0,4.0,15.0,4.0,1.0,31.0,10.0,35.0,9.0,-98.0,-2.0,11.0,2.0,2.0,14.0,4.0,4.0,17.0,7.0,-2.0,23.0,15.0,0.0,18.0,6.0,1.0,13.0,5.0,4.0,8.0,5.0,1.0,25.0,15.0,11.0,3.0,3.0,-35.0,14.0,112.0,8.0,-4.0,0.0,-24.0,24.0,103.0,-9.0,-7.0,34.0,1.0,-68.0,-23.0,-5.0,-63.0,-22.0,0.0,-10.0,-3.0,2.0,-67.0,-16.0,-3.0,-66.0,-18.0,-1.0,-8.0,-4.0,-6.0,-63.0,-16.0,-14.0,-38.0,55.0,0.0,-8.0,-7.0,0.0,-65.0,-6.0,0.0,-8.0,-7.0,-3.0,-71.0,-9.0,16.0,50.0,-72.0,-5.0,-58.0,-38.0,-9.0,0.0,-2.0,-27.0,-76.0,112.0,-10.0,9.0,-1.0,0.0,32.0,29.0,-2.0,15.0,8.0,0.0,12.0,6.0,4.0,12.0,5.0,1.0,43.0,1.0,-2.0,15.0,3.0,0.0,15.0,4.0,3.0,14.0,2.0,0.0,31.0,-7.0,28.0,74.0,-114.0,5.0,13.0,2.0,-2.0,15.0,0.0,1.0,14.0,1.0,3.0,19.0,1.0,-2.0,14.0,0.0,0.0,15.0,1.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_31()
		{
			double[] value = {4.0,18.0,3.0,1.0,37.0,6.0,-2.0,13.0,1.0,27.0,32.0,-84.0,1.0,22.0,7.0,5.0,15.0,7.0,0.0,26.0,13.0,-2.0,13.0,5.0,1.0,16.0,7.0,5.0,12.0,5.0,0.0,38.0,23.0,-24.0,25.0,102.0,11.0,2.0,6.0,-10.0,-7.0,35.0,-10.0,-28.0,25.0,9.0,-5.0,0.0,-1.0,-73.0,-12.0,-7.0,-70.0,-10.0,2.0,-6.0,-8.0,1.0,-67.0,-13.0,-3.0,-67.0,-12.0,1.0,-9.0,-7.0,-7.0,-33.0,17.0,-10.0,-59.0,-8.0,1.0,-6.0,-8.0,1.0,-65.0,-5.0,1.0,-7.0,-7.0,-3.0,-65.0,-10.0,-9.0,-65.0,-16.0,-14.0,-43.0,65.0,-9.0,0.0,-2.0,-10.0,9.0,-1.0,-1.0,24.0,51.0,-3.0,11.0,7.0,0.0,11.0,6.0,4.0,10.0,4.0,1.0,25.0,-1.0,-2.0,11.0,4.0,0.0,11.0,5.0,3.0,11.0,4.0,0.0,34.0,-9.0,3.0,12.0,5.0,-1.0,-80.0,57.0,18.0,166.0,-145.0,-2.0,14.0,2.0,0.0,12.0,1.0,4.0,23.0,-3.0,-2.0,13.0,2.0,0.0,13.0,3.0,3.0,20.0,1.0,1.0,39.0,0.0,-2.0,13.0,1.0,1.0,20.0,1.0,30.0,73.0,-104.0,4.0,21.0,7.0,0.0,27.0,10.0,-1.0,18.0,6.0,1.0,19.0,7.0,2.0,13.0,10.0,-5.0,73.0,72.0,-11.0,-28.0,26.0,-10.0,-55.0,19.0,10.0,0.0,8.0,10.0,-4.0,0.0,0.0,-66.0,-15.0,-6.0,-64.0,-12.0,2.0,-4.0,-8.0,1.0,-64.0,-10.0,-1.0,-66.0,-11.0,-11.0,-53.0,38.0,0.0,-6.0,-8.0,-10.0,-60.0,0.0,0.0,-6.0,-6.0,2.0,-61.0,0.0,0.0,-7.0,-7.0,-4.0,-61.0,-4.0,-3.0,-20.0,29.0,-9.0,-52.0,-8.0,-10.0,0.0,-2.0,-9.0,9.0,-1.0,2.0,-1.0,32.0,1.0,6.0,23.0,-2.0,2.0,8.0,1.0,5.0,7.0,3.0,7.0,6.0,0.0,11.0,8.0,-3.0,8.0,6.0,0.0,9.0,4.0,4.0,13.0,3.0,0.0,16.0,5.0,10.0,-9.0,8.0,9.0,-2.0,0.0,-22.0,41.0,-8.0,2.0,78.0,-55.0,0.0,11.0,2.0,8.0,28.0,-8.0,-2.0,12.0,2.0,0.0,13.0,3.0,3.0,14.0,3.0,2.0,34.0,-7.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_32()
		{
			double[] value = {-3.0,14.0,4.0,-1.0,16.0,5.0,3.0,13.0,5.0,17.0,100.0,-87.0,0.0,27.0,3.0,-2.0,14.0,5.0,1.0,18.0,6.0,3.0,16.0,3.0,-7.0,8.0,46.0,10.0,-1.0,8.0,10.0,-2.0,-1.0,0.0,-64.0,-9.0,-6.0,-61.0,-5.0,2.0,-4.0,-9.0,1.0,-61.0,-3.0,-3.0,-64.0,21.0,-3.0,-56.0,-1.0,-3.0,-2.0,-7.0,-7.0,-51.0,1.0,0.0,-6.0,-7.0,2.0,-49.0,1.0,0.0,-8.0,-6.0,0.0,-23.0,31.0,-1.0,-35.0,-4.0,-8.0,-46.0,-6.0,-10.0,0.0,0.0,3.0,6.0,24.0,1.0,14.0,21.0,0.0,11.0,10.0,0.0,29.0,13.0,10.0,0.0,0.0,0.0,29.0,5.0,0.0,30.0,3.0,-10.0,1.0,0.0,-9.0,9.0,-9.0,0.0,32.0,-5.0,0.0,16.0,-2.0,1.0,21.0,-3.0,4.0,22.0,-4.0,0.0,33.0,-6.0,-3.0,23.0,-3.0,2.0,25.0,-5.0,3.0,28.0,-4.0,2.0,41.0,-6.0,-1.0,20.0,-4.0,2.0,25.0,-5.0,5.0,30.0,-8.0,10.0,-3.0,8.0,10.0,-1.0,0.0,0.0,-54.0,-7.0,-5.0,-51.0,-4.0,0.0,-3.0,-8.0,0.0,-74.0,25.0,2.0,-37.0,-4.0,-4.0,-36.0,-2.0,-2.0,-16.0,-2.0,-5.0,-31.0,-2.0,0.0,-13.0,-2.0,4.0,-33.0,-2.0,0.0,-12.0,17.0,-1.0,-28.0,-2.0,-6.0,-47.0,-3.0,1.0,14.0,21.0,0.0,11.0,10.0,0.0,39.0,6.0,0.0,40.0,6.0,0.0,40.0,4.0,-9.0,2.0,0.0,4.0,59.0,-9.0,1.0,35.0,-6.0,1.0,77.0,-12.0,4.0,41.0,-6.0,9.0,-1.0,0.0,1.0,-44.0,-6.0,-1.0,-37.0,-3.0,-1.0,-57.0,8.0,3.0,-28.0,-1.0,-4.0,-37.0,-2.0,-7.0,-40.0,-1.0,0.0,-36.0,10.0,0.0,-1.0,9.0,1.0,64.0,6.0,3.0,63.0,4.0,1.0,34.0,-6.0,1.0,77.0,-12.0,4.0,-42.0,-2.0,-3.0,-129.0,9.0,742.0,41.0,-10.0,4.0,28.0,0.0,0.0,33.0,-11.0,-5.0,-36.0,-4.0,-1.0,-38.0,-2.0,0.0,-16.0,0.0,0.0,-11.0,16.0,24.0,-58.0,31.0,3.0,13.0,1.0,-13.0,-37.0,6.0,-10.0,-1.0,0.0,20.0,11.0,-8.0,5.0,82.0,-61.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_33()
		{
			double[] value = {-2.0,13.0,4.0,3.0,12.0,4.0,2.0,10.0,0.0,-4.0,30.0,-8.0,4.0,12.0,3.0,0.0,-70.0,53.0,-7.0,-17.0,4.0,-1.0,-32.0,4.0,-10.0,-9.0,8.0,-9.0,-1.0,-1.0,0.0,-29.0,-4.0,0.0,20.0,-6.0,0.0,-24.0,-22.0,-5.0,65.0,9.0,4.0,-68.0,0.0,0.0,-13.0,8.0,0.0,-9.0,7.0,10.0,1.0,0.0,10.0,9.0,-7.0,3.0,66.0,-48.0,-9.0,88.0,-88.0,1.0,32.0,-6.0,0.0,14.0,1.0,3.0,14.0,3.0,0.0,13.0,1.0,-4.0,23.0,-4.0,3.0,13.0,3.0,0.0,12.0,2.0,11.0,-85.0,86.0,0.0,-62.0,47.0,-17.0,-47.0,14.0,-9.0,0.0,0.0,3.0,60.0,-10.0,-4.0,-63.0,-4.0,-1.0,134.0,-17.0,-2.0,38.0,-8.0,4.0,-35.0,-5.0,-3.0,51.0,-17.0,-1.0,-3.0,-10.0,0.0,-54.0,-3.0,1.0,-56.0,-2.0,1.0,-5.0,-7.0,2.0,-51.0,4.0,-1.0,-27.0,23.0,0.0,-14.0,0.0,0.0,-5.0,17.0,-6.0,-39.0,-3.0,0.0,-28.0,-3.0,6.0,-47.0,-3.0,-1.0,13.0,21.0,0.0,11.0,10.0,10.0,0.0,0.0,14.0,27.0,3.0,2.0,67.0,-50.0,-9.0,85.0,-86.0,-23.0,82.0,-118.0,-2.0,14.0,2.0,1.0,25.0,-2.0,-1.0,15.0,1.0,2.0,15.0,0.0,0.0,13.0,1.0,-3.0,20.0,1.0,2.0,14.0,0.0,-2.0,13.0,3.0,-3.0,17.0,2.0,24.0,-75.0,117.0,13.0,-89.0,85.0,0.0,-54.0,40.0,-10.0,-7.0,8.0,0.0,34.0,-6.0,-10.0,-1.0,0.0,-4.0,76.0,-11.0,-1.0,43.0,-6.0,-3.0,76.0,-17.0,-2.0,-52.0,-8.0,-2.0,78.0,-18.0,4.0,-61.0,-5.0,-1.0,-4.0,-10.0,-3.0,-61.0,-4.0,4.0,-64.0,-6.0,0.0,-5.0,-8.0,4.0,-62.0,1.0,0.0,-6.0,-6.0,1.0,-43.0,27.0,-4.0,-49.0,1.0,-1.0,-19.0,25.0,0.0,-11.0,-1.0,1.0,-35.0,-4.0,6.0,-47.0,-6.0,9.0,0.0,0.0,-2.0,7.0,24.0,-1.0,13.0,21.0,13.0,3.0,-11.0,-3.0,7.0,7.0,0.0,11.0,8.0,4.0,7.0,5.0,3.0,66.0,-50.0,-10.0,82.0,-86.0,-22.0,80.0,-117.0,-25.0,58.0,-107.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_34()
		{
			double[] value = {0.0,13.0,3.0,-3.0,13.0,4.0,2.0,22.0,2.0,-3.0,14.0,2.0,4.0,14.0,0.0,0.0,13.0,2.0,-3.0,16.0,6.0,1.0,14.0,2.0,0.0,12.0,2.0,-4.0,15.0,4.0,0.0,30.0,11.0,23.0,-35.0,87.0,24.0,-73.0,108.0,12.0,-94.0,80.0,3.0,-53.0,41.0,3.0,22.0,-4.0,-1.0,25.0,-4.0,-6.0,25.0,-2.0,-11.0,-4.0,7.0,-1.0,43.0,-5.0,-3.0,78.0,-18.0,-2.0,89.0,-16.0,-10.0,-1.0,-1.0,-9.0,62.0,-15.0,-1.0,-67.0,-14.0,4.0,-63.0,-12.0,-2.0,-4.0,-9.0,-3.0,-65.0,-10.0,3.0,-64.0,-13.0,0.0,-5.0,-8.0,6.0,-61.0,-9.0,-3.0,-6.0,-6.0,-2.0,-64.0,-4.0,8.0,-52.0,52.0,0.0,-7.0,-6.0,3.0,-31.0,28.0,1.0,-51.0,-4.0,7.0,-52.0,-8.0,10.0,0.0,-1.0,9.0,9.0,-1.0,-3.0,-1.0,32.0,-1.0,6.0,23.0,2.0,2.0,7.0,4.0,39.0,-36.0,0.0,10.0,6.0,-4.0,11.0,4.0,-1.0,25.0,-2.0,-10.0,78.0,-84.0,-22.0,79.0,-117.0,-25.0,58.0,-107.0,-34.0,64.0,-105.0,2.0,14.0,5.0,0.0,12.0,4.0,-2.0,8.0,3.0,2.0,15.0,4.0,-3.0,10.0,3.0,1.0,11.0,3.0,0.0,10.0,3.0,-1.0,14.0,6.0,2.0,11.0,2.0,-1.0,10.0,3.0,-3.0,9.0,4.0,1.0,14.0,7.0,2.0,10.0,2.0,35.0,-9.0,100.0,23.0,-33.0,86.0,24.0,-74.0,107.0,9.0,-91.0,84.0,0.0,13.0,5.0,-2.0,14.0,6.0,0.0,20.0,8.0,1.0,20.0,-4.0,0.0,25.0,-5.0,-5.0,31.0,-9.0,-2.0,88.0,-16.0,-8.0,63.0,-13.0,-11.0,1.0,7.0,-9.0,56.0,-20.0,-10.0,-4.0,-1.0,0.0,-73.0,-12.0,5.0,-70.0,-10.0,-2.0,-6.0,-8.0,-3.0,-67.0,-13.0,2.0,-67.0,-12.0,1.0,-8.0,-9.0,7.0,-63.0,-11.0,-1.0,-8.0,-7.0,-4.0,-67.0,-5.0,-1.0,-7.0,-5.0,5.0,-26.0,18.0,2.0,-65.0,-9.0,9.0,-48.0,59.0,8.0,-61.0,-11.0,10.0,0.0,-2.0,9.0,8.0,0.0,0.0,24.0,50.0,-9.0,53.0,-87.0,3.0,15.0,8.0,0.0,11.0,6.0,-4.0,13.0,4.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_35()
		{
			double[] value = {-21.0,77.0,-119.0,-25.0,67.0,-111.0,-36.0,79.0,-103.0,-37.0,66.0,-70.0,-1.0,16.0,5.0,3.0,11.0,5.0,0.0,7.0,4.0,-3.0,6.0,4.0,2.0,12.0,3.0,-2.0,5.0,4.0,2.0,8.0,3.0,0.0,7.0,3.0,-2.0,9.0,5.0,2.0,9.0,2.0,-1.0,7.0,4.0,-2.0,6.0,4.0,0.0,10.0,5.0,2.0,8.0,2.0,0.0,13.0,6.0,36.0,-17.0,69.0,36.0,-1.0,103.0,23.0,-35.0,84.0,23.0,-73.0,105.0,-3.0,15.0,4.0,0.0,28.0,3.0,2.0,13.0,5.0,0.0,19.0,6.0,-4.0,16.0,3.0,-11.0,127.0,11.0,-9.0,28.0,-25.0,-11.0,2.0,6.0,-9.0,-5.0,0.0,-2.0,-68.0,-23.0,3.0,-63.0,-22.0,0.0,-9.0,-3.0,-3.0,-68.0,-16.0,1.0,-65.0,-18.0,0.0,-9.0,-5.0,8.0,-61.0,-17.0,0.0,-9.0,-5.0,-6.0,-60.0,-15.0,0.0,-9.0,-4.0,1.0,-64.0,-20.0,13.0,-51.0,72.0,12.0,-84.0,2.0,9.0,0.0,-3.0,10.0,8.0,-1.0,-20.0,77.0,-111.0,0.0,31.0,21.0,3.0,15.0,8.0,0.0,13.0,5.0,-25.0,68.0,-110.0,-37.0,81.0,-104.0,-37.0,69.0,-71.0,-16.0,27.0,-14.0,-3.0,6.0,6.0,-1.0,14.0,6.0,2.0,10.0,4.0,0.0,7.0,4.0,-2.0,4.0,4.0,1.0,11.0,4.0,-2.0,4.0,4.0,2.0,8.0,3.0,0.0,6.0,3.0,-3.0,7.0,5.0,2.0,8.0,3.0,0.0,6.0,3.0,-3.0,4.0,4.0,0.0,10.0,4.0,2.0,7.0,3.0,-1.0,12.0,6.0,-3.0,15.0,10.0,17.0,-6.0,14.0,37.0,-19.0,66.0,35.0,-3.0,102.0,23.0,-27.0,85.0,0.0,27.0,9.0,2.0,18.0,7.0,-1.0,19.0,7.0,-3.0,13.0,10.0,-3.0,80.0,38.0,-11.0,2.0,6.0,-9.0,-5.0,-1.0,-1.0,-69.0,-18.0,4.0,-63.0,-18.0,0.0,-10.0,-3.0,-4.0,-65.0,-17.0,2.0,-63.0,-17.0,1.0,-10.0,-3.0,7.0,-59.0,-19.0,0.0,-10.0,-3.0,-4.0,-59.0,-14.0,0.0,-10.0,-3.0,1.0,-64.0,-17.0,8.0,-67.0,-21.0,8.0,0.0,-2.0,-22.0,68.0,-99.0,10.0,6.0,2.0,-1.0,34.0,13.0,3.0,16.0,5.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_36()
		{
			double[] value = {-37.0,79.0,-106.0,-38.0,72.0,-70.0,-15.0,28.0,-15.0,-24.0,23.0,-17.0,-1.0,8.0,5.0,-2.0,6.0,6.0,0.0,11.0,8.0,1.0,10.0,4.0,0.0,7.0,4.0,-2.0,3.0,4.0,2.0,10.0,5.0,-2.0,4.0,4.0,1.0,7.0,2.0,0.0,6.0,3.0,-2.0,6.0,7.0,1.0,8.0,2.0,0.0,6.0,3.0,-2.0,3.0,4.0,0.0,9.0,5.0,2.0,7.0,3.0,-1.0,12.0,6.0,-3.0,14.0,11.0,0.0,23.0,15.0,23.0,-11.0,12.0,14.0,-5.0,15.0,42.0,-21.0,67.0,33.0,0.0,100.0,2.0,13.0,5.0,-1.0,16.0,7.0,-4.0,13.0,5.0,-1.0,37.0,23.0,-11.0,3.0,3.0,-10.0,-5.0,0.0,0.0,-58.0,-17.0,4.0,-52.0,-20.0,0.0,-10.0,0.0,-4.0,-53.0,-17.0,3.0,-53.0,-18.0,1.0,-9.0,-3.0,4.0,-43.0,-15.0,0.0,-19.0,-6.0,-4.0,-43.0,-12.0,0.0,-10.0,-3.0,2.0,-52.0,-17.0,7.0,-56.0,-20.0,-37.0,86.0,-106.0,10.0,0.0,-2.0,10.0,5.0,3.0,-1.0,33.0,12.0,-38.0,74.0,-70.0,-16.0,28.0,-14.0,-22.0,22.0,-18.0,-32.0,24.0,-22.0,0.0,15.0,11.0,-1.0,20.0,15.0,-1.0,13.0,9.0,-2.0,14.0,9.0,0.0,11.0,7.0,0.0,10.0,9.0,2.0,11.0,4.0,-2.0,11.0,10.0,1.0,18.0,9.0,-3.0,21.0,15.0,0.0,32.0,20.0,34.0,-16.0,16.0,22.0,-10.0,13.0,14.0,-4.0,15.0,42.0,-19.0,66.0,-1.0,12.0,5.0,-4.0,9.0,4.0,0.0,25.0,15.0,-12.0,2.0,2.0,-10.0,-5.0,0.0,0.0,-45.0,-17.0,3.0,-39.0,-18.0,0.0,-10.0,-1.0,-4.0,-41.0,-16.0,2.0,-40.0,-16.0,0.0,-9.0,-4.0,4.0,-30.0,-14.0,0.0,-19.0,-7.0,-3.0,-31.0,-11.0,-1.0,-9.0,-5.0,0.0,-40.0,-14.0,-36.0,70.0,-72.0,7.0,-31.0,-19.0,9.0,1.0,-2.0,11.0,4.0,3.0,-16.0,29.0,-15.0,-25.0,25.0,-20.0,-32.0,27.0,-22.0,-64.0,59.0,-37.0,-14.0,29.0,8.0,-6.0,73.0,66.0,-1.0,56.0,49.0,12.0,10.0,20.0,66.0,-23.0,37.0,34.0,-17.0,15.0,21.0,-9.0,14.0,14.0,0.0,14.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_37()
		{
			double[] value = {-13.0,2.0,1.0,-9.0,-5.0,0.0,0.0,-34.0,-15.0,2.0,-27.0,-15.0,0.0,-9.0,-5.0,-2.0,-30.0,-11.0,1.0,-28.0,-15.0,1.0,-9.0,-4.0,5.0,-23.0,-14.0,-1.0,-7.0,-6.0,-2.0,-27.0,-8.0,-2.0,-6.0,-7.0,-14.0,21.0,-13.0,2.0,-25.0,-13.0,6.0,-26.0,-20.0,11.0,0.0,-3.0,-26.0,22.0,-21.0,-31.0,27.0,-23.0,-69.0,61.0,-31.0,-14.0,27.0,9.0,-6.0,131.0,116.0,10.0,12.0,20.0,61.0,-20.0,37.0,8.0,1.0,0.0,34.0,-16.0,15.0,20.0,-9.0,12.0,-9.0,-5.0,0.0,0.0,-31.0,-14.0,2.0,-23.0,-16.0,0.0,-9.0,-5.0,-2.0,-27.0,-10.0,2.0,-24.0,-14.0,1.0,-9.0,-6.0,3.0,-19.0,-13.0,-1.0,-7.0,-7.0,-1.0,-22.0,-7.0,-24.0,12.0,-17.0,0.0,-8.0,-4.0,1.0,-24.0,-15.0,3.0,-23.0,-22.0,-29.0,28.0,-28.0,-20.0,-9.0,9.0,-67.0,58.0,-26.0,-11.0,22.0,6.0,-5.0,136.0,121.0,7.0,10.0,17.0,68.0,-20.0,30.0,17.0,-7.0,7.0,32.0,0.0,3.0,0.0,-29.0,-15.0,1.0,-22.0,-17.0,0.0,-8.0,-5.0,0.0,-26.0,-10.0,1.0,-23.0,-15.0,1.0,-8.0,-6.0,2.0,-17.0,-16.0,0.0,-7.0,-5.0,-33.0,3.0,-5.0,0.0,-21.0,-9.0,0.0,-8.0,-5.0,1.0,-23.0,-15.0,2.0,-22.0,-22.0,-31.0,13.0,1.0,-66.0,62.0,-29.0,-9.0,146.0,131.0,65.0,-23.0,31.0,2.0,-24.0,-12.0,33.0,9.0,4.0,1.0,-21.0,-17.0,0.0,-8.0,-5.0,0.0,-26.0,-11.0,1.0,-22.0,-15.0,0.0,-8.0,-6.0,0.0,-16.0,-16.0,-30.0,0.0,-5.0,1.0,-24.0,-17.0,0.0,-22.0,-16.0,-26.0,7.0,7.0,-35.0,29.0,-20.0,-5.0,103.0,86.0,36.0,-20.0,16.0,25.0,-3.0,-6.0,1.0,-24.0,-17.0,0.0,-23.0,-17.0,-24.0,-24.0,-14.0,-2.0,37.0,28.0,-163.0,436.0,19.0,-6.0,-22.0,24.0,37.0,-12.0,-35.0,3.0,-15.0,-25.0,-5.0,-17.0,-2.0,-37.0,-3.0,-16.0,-14.0,-2.0,0.0,44.0,23.0,9.0,-56.0,61.0,7.0,13.0,4.0,12.0,-4.0,-14.0,19.0,-3.0,-13.0,16.0,-4.0,-14.0,15.0,-3.0,-13.0,14.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_38()
		{
			double[] value = {22.0,-6.0,11.0,-3.0,-22.0,24.0,31.0,-25.0,-10.0,3.0,-36.0,17.0,-8.0,-10.0,-14.0,-24.0,-20.0,-13.0,15.0,67.0,-96.0,-16.0,-4.0,0.0,-70.0,58.0,47.0,3.0,12.0,-13.0,2.0,8.0,-12.0,6.0,10.0,-16.0,9.0,3.0,-6.0,10.0,2.0,-1.0,6.0,27.0,14.0,-1.0,-11.0,25.0,-4.0,-13.0,16.0,-2.0,-6.0,5.0,-4.0,-15.0,9.0,-1.0,-5.0,4.0,-2.0,-6.0,14.0,-26.0,5.0,7.0,0.0,-4.0,5.0,25.0,-6.0,-6.0,-1.0,-12.0,13.0,26.0,-5.0,-9.0,-2.0,-12.0,15.0,0.0,-10.0,20.0,-1.0,-16.0,17.0,-16.0,-16.0,2.0,60.0,-35.0,-25.0,-28.0,-20.0,-8.0,-14.0,-1.0,-2.0,11.0,1.0,-20.0,4.0,30.0,-44.0,-64.0,73.0,19.0,1.0,7.0,-7.0,0.0,8.0,-6.0,-24.0,24.0,16.0,0.0,4.0,-4.0,4.0,7.0,-5.0,1.0,7.0,-8.0,-19.0,25.0,12.0,18.0,-22.0,-19.0,0.0,5.0,-5.0,3.0,7.0,-6.0,4.0,12.0,-21.0,10.0,3.0,-3.0,11.0,6.0,2.0,0.0,-13.0,27.0,-2.0,-15.0,17.0,-2.0,-5.0,5.0,-4.0,-15.0,9.0,-1.0,-4.0,5.0,-19.0,16.0,16.0,1.0,-10.0,13.0,0.0,-4.0,5.0,0.0,-14.0,15.0,15.0,-13.0,-15.0,-3.0,-16.0,11.0,25.0,-5.0,-8.0,0.0,-5.0,6.0,-1.0,-9.0,19.0,0.0,-19.0,18.0,-6.0,-26.0,-7.0,-7.0,-1.0,2.0,-10.0,2.0,0.0,-2.0,6.0,-11.0,0.0,19.0,-26.0,0.0,11.0,-16.0,2.0,11.0,-10.0,0.0,5.0,-8.0,2.0,6.0,-4.0,-22.0,25.0,18.0,-1.0,2.0,-6.0,0.0,3.0,-3.0,2.0,5.0,-3.0,-1.0,2.0,-4.0,3.0,6.0,-3.0,-17.0,23.0,12.0,-2.0,1.0,-4.0,1.0,5.0,-5.0,3.0,7.0,-4.0,-13.0,26.0,6.0,-1.0,11.0,-8.0,-2.0,4.0,-7.0,14.0,-29.0,-7.0,1.0,5.0,-7.0,3.0,7.0,-6.0,0.0,15.0,-20.0,10.0,2.0,-2.0,11.0,0.0,2.0,3.0,-16.0,27.0,0.0,-17.0,17.0,-3.0,-5.0,7.0,-4.0,-15.0,9.0,-11.0,21.0,12.0,0.0,-4.0,7.0,2.0,-14.0,14.0,0.0,-5.0,6.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_39()
		{
			double[] value = {-1.0,-16.0,16.0,-5.0,-19.0,14.0,10.0,-13.0,-16.0,0.0,-5.0,5.0,17.0,-12.0,-15.0,0.0,-11.0,19.0,-1.0,-19.0,21.0,-11.0,-7.0,2.0,-10.0,1.0,1.0,-2.0,5.0,-10.0,1.0,9.0,-10.0,0.0,14.0,-19.0,-1.0,7.0,-12.0,1.0,6.0,-7.0,2.0,6.0,-4.0,0.0,4.0,-4.0,-1.0,1.0,-5.0,0.0,4.0,-2.0,-15.0,19.0,14.0,2.0,5.0,-3.0,-2.0,4.0,-6.0,1.0,3.0,-3.0,2.0,5.0,-4.0,-2.0,2.0,-3.0,-12.0,23.0,10.0,2.0,8.0,-6.0,-2.0,3.0,-5.0,0.0,5.0,-4.0,-35.0,79.0,46.0,2.0,11.0,-7.0,0.0,17.0,-10.0,-2.0,8.0,-9.0,0.0,7.0,-8.0,36.0,-93.0,-43.0,4.0,6.0,-7.0,0.0,19.0,-20.0,12.0,2.0,-4.0,9.0,0.0,3.0,5.0,-21.0,28.0,0.0,-21.0,20.0,-2.0,-3.0,7.0,-36.0,79.0,48.0,-3.0,-24.0,19.0,0.0,-13.0,11.0,4.0,-20.0,21.0,0.0,-6.0,6.0,0.0,-27.0,26.0,-4.0,-31.0,27.0,0.0,-8.0,3.0,31.0,-33.0,-85.0,2.0,-17.0,20.0,8.0,-9.0,-17.0,-2.0,-20.0,21.0,-7.0,-4.0,4.0,-11.0,2.0,0.0,-2.0,6.0,-11.0,1.0,10.0,-11.0,0.0,15.0,-18.0,-1.0,8.0,-12.0,0.0,7.0,-8.0,3.0,5.0,-3.0,0.0,5.0,-5.0,-3.0,2.0,-3.0,-11.0,18.0,12.0,0.0,4.0,-4.0,2.0,6.0,-4.0,-1.0,5.0,-6.0,0.0,4.0,-4.0,3.0,6.0,-3.0,-35.0,65.0,52.0,-3.0,6.0,-6.0,3.0,12.0,-7.0,-3.0,6.0,-5.0,-37.0,95.0,69.0,0.0,11.0,-6.0,2.0,13.0,-5.0,0.0,33.0,-15.0,-2.0,8.0,-7.0,0.0,8.0,-6.0,3.0,11.0,-9.0,38.0,-117.0,-71.0,0.0,25.0,-23.0,13.0,4.0,-5.0,9.0,0.0,2.0,5.0,-33.0,33.0,-1.0,-30.0,27.0,-38.0,97.0,76.0,-1.0,-7.0,5.0,-24.0,79.0,74.0,20.0,-116.0,-53.0,0.0,-16.0,11.0,6.0,-34.0,27.0,0.0,-8.0,6.0,0.0,-43.0,31.0,-5.0,-48.0,28.0,1.0,-9.0,3.0,3.0,-47.0,26.0,35.0,-15.0,-84.0,-2.0,-39.0,30.0,30.0,-4.0,-102.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_40()
		{
			double[] value = {-8.0,-4.0,4.0,-10.0,2.0,0.0,-1.0,9.0,-12.0,0.0,11.0,-12.0,-2.0,15.0,-20.0,-2.0,11.0,-12.0,0.0,9.0,-8.0,3.0,5.0,-3.0,0.0,6.0,-6.0,-32.0,46.0,61.0,-3.0,6.0,-6.0,0.0,7.0,-5.0,2.0,9.0,-6.0,-2.0,9.0,-9.0,0.0,8.0,-5.0,-37.0,72.0,71.0,2.0,13.0,-5.0,-2.0,12.0,-6.0,2.0,19.0,-6.0,-26.0,93.0,75.0,-2.0,12.0,-6.0,0.0,13.0,-5.0,2.0,14.0,-6.0,-1.0,39.0,-13.0,-2.0,11.0,-8.0,0.0,9.0,-8.0,4.0,11.0,-11.0,2.0,20.0,-31.0,24.0,-99.0,-66.0,11.0,5.0,-3.0,9.0,0.0,3.0,6.0,-43.0,35.0,-25.0,89.0,74.0,0.0,-52.0,29.0,-5.0,18.0,16.0,-1.0,-7.0,5.0,-4.0,-50.0,27.0,5.0,-18.0,-17.0,0.0,-8.0,4.0,6.0,-50.0,36.0,0.0,-7.0,4.0,0.0,-62.0,31.0,-4.0,-63.0,19.0,0.0,-9.0,2.0,2.0,-60.0,24.0,-3.0,-61.0,35.0,24.0,-4.0,-75.0,-8.0,-5.0,0.0,36.0,-1.0,-81.0,-11.0,2.0,-3.0,0.0,21.0,-23.0,-4.0,6.0,-6.0,0.0,10.0,-10.0,2.0,15.0,-12.0,2.0,16.0,-23.0,-4.0,13.0,-11.0,0.0,11.0,-9.0,2.0,9.0,-4.0,-36.0,34.0,84.0,0.0,26.0,-19.0,-3.0,12.0,-8.0,0.0,10.0,-6.0,2.0,12.0,-5.0,-3.0,14.0,-11.0,-25.0,82.0,70.0,0.0,12.0,-4.0,3.0,15.0,-6.0,-4.0,13.0,-4.0,-23.0,112.0,81.0,1.0,29.0,-2.0,-2.0,11.0,-8.0,0.0,11.0,-7.0,3.0,12.0,-7.0,-1.0,38.0,-15.0,-2.0,9.0,-10.0,1.0,8.0,-9.0,4.0,11.0,-12.0,1.0,20.0,-40.0,11.0,7.0,-2.0,24.0,-106.0,-62.0,9.0,0.0,2.0,0.0,-39.0,54.0,-14.0,68.0,43.0,0.0,-59.0,30.0,-1.0,-5.0,7.0,-4.0,-57.0,24.0,0.0,-4.0,7.0,13.0,-57.0,-38.0,5.0,-51.0,35.0,0.0,-6.0,6.0,0.0,-63.0,31.0,-4.0,-67.0,16.0,0.0,-10.0,3.0,1.0,-58.0,26.0,-5.0,-59.0,37.0,-9.0,-4.0,1.0,8.0,-19.0,-24.0,-10.0,0.0,-7.0,25.0,-1.0,-74.0,0.0,31.0,-27.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_41()
		{
			double[] value = {-3.0,11.0,-8.0,0.0,15.0,-9.0,2.0,12.0,-7.0,0.0,22.0,-16.0,-3.0,12.0,-8.0,0.0,19.0,-11.0,-24.0,56.0,57.0,2.0,13.0,-4.0,0.0,37.0,-14.0,-3.0,15.0,-6.0,0.0,13.0,-6.0,2.0,14.0,-4.0,-25.0,114.0,80.0,-3.0,23.0,-4.0,0.0,10.0,-5.0,3.0,12.0,-5.0,-11.0,107.0,56.0,1.0,96.0,25.0,-4.0,-86.0,-35.0,2.0,34.0,-3.0,-2.0,9.0,-9.0,0.0,8.0,-9.0,3.0,7.0,-9.0,-1.0,24.0,-8.0,-2.0,8.0,-9.0,0.0,7.0,-11.0,4.0,7.0,-11.0,2.0,4.0,-59.0,11.0,8.0,-2.0,9.0,0.0,2.0,11.0,-64.0,-34.0,5.0,-54.0,42.0,0.0,-54.0,30.0,-2.0,-4.0,9.0,-4.0,-53.0,22.0,0.0,-3.0,8.0,6.0,-54.0,27.0,5.0,-37.0,-4.0,0.0,-3.0,10.0,0.0,-58.0,29.0,-4.0,-67.0,17.0,-1.0,-3.0,8.0,4.0,-74.0,10.0,-2.0,-72.0,24.0,-10.0,-4.0,0.0,-11.0,0.0,-9.0,9.0,-38.0,-13.0,7.0,49.0,-76.0,-1.0,11.0,-10.0,0.0,17.0,-8.0,3.0,16.0,-6.0,0.0,25.0,-11.0,-4.0,20.0,-7.0,-25.0,121.0,84.0,0.0,18.0,-7.0,2.0,13.0,-5.0,-1.0,35.0,-10.0,-3.0,16.0,-9.0,0.0,11.0,-6.0,-10.0,108.0,54.0,3.0,9.0,-7.0,-4.0,30.0,-1.0,1.0,8.0,-6.0,1.0,93.0,25.0,14.0,36.0,-9.0,10.0,2.0,0.0,-20.0,-13.0,-3.0,0.0,14.0,-12.0,-2.0,10.0,-8.0,0.0,7.0,-9.0,3.0,4.0,-8.0,0.0,7.0,-13.0,-2.0,4.0,-10.0,0.0,0.0,-9.0,2.0,-1.0,-8.0,-2.0,-2.0,-26.0,-1.0,-13.0,-31.0,10.0,9.0,-1.0,10.0,0.0,2.0,6.0,-46.0,32.0,3.0,-30.0,-17.0,0.0,-54.0,28.0,-2.0,-3.0,9.0,-4.0,-54.0,19.0,0.0,-3.0,9.0,6.0,-53.0,19.0,0.0,-2.0,9.0,8.0,-64.0,-18.0,0.0,-53.0,32.0,-5.0,-58.0,21.0,-1.0,0.0,9.0,4.0,-65.0,14.0,-4.0,-67.0,17.0,-10.0,-3.0,0.0,-9.0,-3.0,-9.0,0.0,64.0,-33.0,-3.0,17.0,-3.0,0.0,18.0,-6.0,3.0,13.0,-5.0,-1.0,27.0,-4.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_42()
		{
			double[] value = {-12.0,131.0,57.0,-3.0,10.0,-10.0,1.0,9.0,-7.0,3.0,10.0,-9.0,-1.0,32.0,-3.0,-3.0,11.0,-7.0,-1.0,73.0,23.0,0.0,20.0,-4.0,5.0,17.0,-5.0,1.0,31.0,-6.0,10.0,11.0,3.0,10.0,1.0,0.0,1.0,25.0,-16.0,0.0,24.0,-16.0,-9.0,0.0,0.0,0.0,21.0,-25.0,0.0,7.0,-14.0,0.0,3.0,-28.0,-1.0,-3.0,-26.0,10.0,0.0,1.0,5.0,-41.0,28.0,-1.0,-31.0,18.0,0.0,-33.0,-20.0,-1.0,-4.0,10.0,-4.0,-44.0,16.0,0.0,-3.0,10.0,5.0,-46.0,14.0,0.0,-1.0,10.0,1.0,-48.0,20.0,1.0,-64.0,0.0,-5.0,-53.0,23.0,0.0,0.0,10.0,2.0,-55.0,15.0,-2.0,-64.0,12.0,-10.0,-2.0,0.0,-10.0,-4.0,-8.0,-3.0,99.0,11.0,-4.0,32.0,1.0,0.0,26.0,-3.0,2.0,19.0,-3.0,-1.0,40.0,-8.0,-3.0,23.0,-2.0,0.0,23.0,-4.0,3.0,20.0,-4.0,1.0,33.0,-7.0,11.0,70.0,-7.0,11.0,1.0,0.0,1.0,34.0,-20.0,1.0,34.0,-22.0,2.0,33.0,-24.0,0.0,6.0,-13.0,0.0,3.0,-26.0,4.0,-43.0,26.0,0.0,-24.0,13.0,-2.0,-18.0,-13.0,-4.0,-28.0,17.0,0.0,-11.0,6.0,4.0,-27.0,14.0,0.0,-14.0,7.0,-1.0,-33.0,16.0,-4.0,-32.0,15.0,0.0,-70.0,0.0,0.0,1.0,8.0,2.0,-46.0,20.0,-3.0,-46.0,21.0,-10.0,0.0,0.0,-2.0,78.0,-6.0,-1.0,41.0,-8.0,0.0,68.0,-10.0,1.0,34.0,-8.0,10.0,1.0,0.0,2.0,56.0,-27.0,1.0,55.0,-31.0,0.0,-6.0,-7.0,0.0,-37.0,5.0,5.0,-35.0,17.0,-1.0,-34.0,16.0,-5.0,-24.0,10.0,0.0,-54.0,11.0,2.0,-29.0,15.0,-4.0,-35.0,17.0,-1.0,41.0,-9.0,0.0,68.0,-10.0,8.0,83.0,-38.0,-3.0,-119.0,35.0,645.0,83.0,-57.0,-2.0,-14.0,7.0,0.0,-32.0,17.0,3.0,-30.0,15.0,1.0,35.0,-1.0,-3.0,24.0,-11.0,1.0,34.0,-15.0,29.0,52.0,12.0,-3.0,13.0,-6.0,-9.0,24.0,-3.0,-10.0,2.0,0.0,0.0,-21.0,-25.0,0.0,-36.0,5.0,0.0,43.0,3.0,0.0,14.0,2.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_43()
		{
			double[] value = {0.0,-33.0,21.0,0.0,21.0,-2.0,0.0,-25.0,16.0,10.0,-1.0,0.0,10.0,-12.0,-4.0,0.0,-31.0,8.0,2.0,-17.0,4.0,-3.0,-81.0,-28.0,-3.0,10.0,-7.0,5.0,29.0,-1.0,0.0,9.0,-7.0,-2.0,9.0,-8.0,3.0,10.0,-7.0,-3.0,99.0,27.0,0.0,13.0,-11.0,-9.0,12.0,1.0,-9.0,1.0,0.0,1.0,21.0,-26.0,0.0,6.0,-14.0,1.0,3.0,-26.0,-8.0,-43.0,26.0,0.0,-24.0,14.0,4.0,-46.0,4.0,0.0,-11.0,5.0,-1.0,-35.0,-12.0,-7.0,-45.0,14.0,-1.0,-1.0,10.0,-2.0,-48.0,21.0,3.0,-46.0,21.0,1.0,2.0,9.0,1.0,51.0,1.0,-3.0,-27.0,14.0,2.0,36.0,-3.0,2.0,119.0,-36.0,5.0,4.0,5.0,0.0,-54.0,27.0,1.0,58.0,-13.0,10.0,-2.0,1.0,12.0,-49.0,3.0,-4.0,-73.0,-24.0,-13.0,-106.0,-56.0,0.0,11.0,-7.0,-2.0,11.0,-7.0,5.0,23.0,-4.0,0.0,11.0,-6.0,-2.0,11.0,-6.0,2.0,12.0,-7.0,0.0,29.0,-1.0,14.0,111.0,51.0,2.0,8.0,-8.0,-1.0,80.0,20.0,-11.0,23.0,-16.0,0.0,6.0,-14.0,2.0,3.0,-27.0,1.0,-3.0,-26.0,-10.0,0.0,1.0,-8.0,-40.0,28.0,0.0,-31.0,19.0,0.0,-9.0,5.0,0.0,-28.0,-16.0,2.0,-44.0,16.0,-4.0,-48.0,-11.0,0.0,-3.0,9.0,-8.0,-53.0,20.0,0.0,-1.0,10.0,-3.0,-55.0,27.0,2.0,-53.0,25.0,0.0,0.0,10.0,-5.0,-55.0,15.0,5.0,80.0,2.0,1.0,-45.0,20.0,5.0,78.0,-6.0,3.0,41.0,-9.0,3.0,68.0,-10.0,10.0,-1.0,0.0,1.0,32.0,-8.0,9.0,-11.0,-5.0,-4.0,-62.0,-20.0,-13.0,-112.0,-55.0,-26.0,-117.0,-87.0,3.0,17.0,-8.0,0.0,13.0,-5.0,-1.0,13.0,-6.0,4.0,19.0,-7.0,0.0,12.0,-5.0,-1.0,13.0,-5.0,3.0,13.0,-5.0,-1.0,25.0,-3.0,4.0,12.0,-4.0,26.0,115.0,79.0,0.0,11.0,-6.0,13.0,105.0,49.0,-1.0,79.0,20.0,-3.0,5.0,-8.0,1.0,6.0,-13.0,3.0,4.0,-10.0,0.0,0.0,-9.0,-2.0,-1.0,-8.0,3.0,-3.0,-26.0,1.0,-13.0,-31.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_44()
		{
			double[] value = {-9.0,10.0,-1.0,-10.0,0.0,2.0,-9.0,-45.0,33.0,-3.0,-45.0,24.0,-3.0,-39.0,-13.0,0.0,-4.0,7.0,-10.0,-64.0,-29.0,1.0,-53.0,23.0,0.0,-3.0,9.0,-9.0,-52.0,27.0,0.0,-2.0,10.0,-2.0,-52.0,34.0,2.0,-58.0,21.0,1.0,0.0,9.0,-5.0,-65.0,14.0,1.0,-66.0,18.0,9.0,80.0,13.0,11.0,-3.0,2.0,5.0,99.0,9.0,5.0,78.0,-6.0,3.0,40.0,-9.0,10.0,-7.0,-6.0,5.0,23.0,-3.0,0.0,23.0,-4.0,-3.0,19.0,-4.0,-5.0,-62.0,-23.0,-13.0,-116.0,-48.0,-27.0,-118.0,-84.0,-24.0,-57.0,-61.0,1.0,26.0,-19.0,4.0,12.0,-8.0,0.0,11.0,-6.0,-2.0,11.0,-6.0,4.0,13.0,-11.0,0.0,11.0,-5.0,-2.0,13.0,-6.0,3.0,11.0,-5.0,-1.0,20.0,-8.0,5.0,10.0,-6.0,0.0,12.0,-5.0,26.0,94.0,77.0,-2.0,14.0,-5.0,25.0,111.0,78.0,14.0,100.0,46.0,2.0,24.0,-8.0,3.0,8.0,-10.0,0.0,7.0,-10.0,-3.0,7.0,-11.0,-1.0,3.0,-60.0,-10.0,9.0,-2.0,-9.0,0.0,2.0,-10.0,-53.0,39.0,-12.0,-65.0,-31.0,-3.0,-54.0,30.0,-5.0,-28.0,-8.0,1.0,-5.0,7.0,1.0,-57.0,24.0,0.0,-4.0,9.0,-9.0,-54.0,31.0,0.0,-4.0,10.0,-3.0,-57.0,30.0,2.0,-66.0,17.0,1.0,-4.0,9.0,-7.0,-74.0,10.0,0.0,-71.0,24.0,9.0,-4.0,2.0,11.0,70.0,9.0,11.0,-3.0,-8.0,10.0,79.0,14.0,5.0,98.0,11.0,5.0,31.0,1.0,1.0,26.0,-3.0,-1.0,20.0,-4.0,0.0,15.0,-15.0,3.0,9.0,-10.0,0.0,9.0,-8.0,-13.0,-117.0,-53.0,-28.0,-120.0,-84.0,-25.0,-56.0,-59.0,-35.0,-31.0,-85.0,-2.0,8.0,-6.0,0.0,8.0,-10.0,4.0,6.0,-6.0,0.0,8.0,-5.0,-2.0,8.0,-5.0,3.0,9.0,-10.0,0.0,7.0,-5.0,-1.0,9.0,-5.0,3.0,6.0,-6.0,-2.0,12.0,-8.0,3.0,6.0,-5.0,0.0,9.0,-7.0,-2.0,11.0,-7.0,40.0,99.0,72.0,3.0,31.0,-12.0,26.0,103.0,78.0,25.0,109.0,74.0,3.0,10.0,-10.0,0.0,8.0,-9.0,-3.0,11.0,-12.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_45()
		{
			double[] value = {0.0,19.0,-40.0,-10.0,8.0,-2.0,-9.0,1.0,2.0,-15.0,-77.0,33.0,-15.0,-69.0,-41.0,-2.0,-50.0,33.0,1.0,-7.0,5.0,1.0,-50.0,29.0,0.0,-6.0,6.0,-9.0,-50.0,35.0,0.0,-6.0,7.0,-2.0,-61.0,30.0,2.0,-68.0,18.0,-1.0,-10.0,3.0,-4.0,-58.0,26.0,1.0,-59.0,39.0,9.0,-4.0,1.0,11.0,0.0,-7.0,11.0,37.0,12.0,13.0,133.0,-25.0,4.0,17.0,-3.0,0.0,17.0,-6.0,-2.0,13.0,-5.0,2.0,27.0,-5.0,3.0,14.0,-6.0,-28.0,-122.0,-84.0,-25.0,-55.0,-53.0,-35.0,-24.0,-90.0,-30.0,-38.0,-68.0,0.0,9.0,-8.0,-2.0,6.0,-4.0,0.0,5.0,-7.0,2.0,3.0,-4.0,0.0,5.0,-4.0,-2.0,6.0,-4.0,2.0,4.0,-6.0,0.0,5.0,-4.0,-2.0,5.0,-4.0,2.0,3.0,-5.0,-2.0,9.0,-6.0,2.0,2.0,-4.0,0.0,5.0,-6.0,-3.0,8.0,-6.0,2.0,12.0,-8.0,38.0,87.0,44.0,3.0,8.0,-7.0,41.0,113.0,70.0,26.0,105.0,76.0,0.0,9.0,-8.0,-2.0,12.0,-11.0,1.0,20.0,-30.0,-11.0,6.0,-2.0,-9.0,1.0,2.0,-11.0,-55.0,41.0,-2.0,-51.0,30.0,0.0,-8.0,4.0,1.0,-49.0,27.0,0.0,-8.0,5.0,-9.0,-48.0,35.0,-1.0,-8.0,5.0,-2.0,-60.0,30.0,2.0,-64.0,20.0,0.0,-9.0,3.0,-6.0,-60.0,24.0,0.0,-61.0,37.0,9.0,-5.0,1.0,11.0,1.0,-7.0,5.0,66.0,-53.0,4.0,10.0,-10.0,0.0,17.0,-8.0,-1.0,17.0,-8.0,0.0,24.0,-11.0,-25.0,-48.0,-52.0,-36.0,-23.0,-88.0,-30.0,-37.0,-67.0,-10.0,-10.0,-17.0,2.0,9.0,-11.0,0.0,6.0,-8.0,-1.0,6.0,-4.0,0.0,5.0,-5.0,1.0,1.0,-4.0,0.0,4.0,-3.0,-2.0,5.0,-4.0,2.0,4.0,-5.0,0.0,3.0,-4.0,-2.0,5.0,-4.0,2.0,2.0,-4.0,-2.0,8.0,-5.0,2.0,1.0,-4.0,-1.0,4.0,-4.0,-2.0,7.0,-6.0,1.0,10.0,-8.0,3.0,3.0,-6.0,14.0,29.0,5.0,0.0,6.0,-6.0,39.0,93.0,43.0,40.0,113.0,72.0,-2.0,12.0,-10.0,2.0,25.0,-23.0,-11.0,6.0,-3.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_46()
		{
			double[] value = {-10.0,0.0,3.0,-9.0,-43.0,35.0,-2.0,-42.0,27.0,0.0,-7.0,5.0,1.0,-35.0,22.0,-1.0,-15.0,10.0,-8.0,-33.0,26.0,-1.0,-8.0,6.0,-1.0,-44.0,33.0,2.0,-48.0,28.0,-1.0,-9.0,3.0,-5.0,-46.0,27.0,0.0,-52.0,30.0,10.0,-5.0,0.0,11.0,1.0,-4.0,1.0,32.0,-28.0,5.0,10.0,-7.0,0.0,15.0,-10.0,-3.0,11.0,-7.0,-32.0,-18.0,-81.0,-34.0,-37.0,-70.0,-10.0,-9.0,-18.0,-14.0,-14.0,-16.0,1.0,14.0,-18.0,2.0,7.0,-12.0,-1.0,6.0,-8.0,-1.0,5.0,-3.0,0.0,5.0,-6.0,1.0,1.0,-3.0,0.0,3.0,-4.0,-2.0,5.0,-3.0,1.0,3.0,-6.0,0.0,3.0,-3.0,-2.0,5.0,-3.0,2.0,1.0,-4.0,-3.0,7.0,-5.0,2.0,1.0,-3.0,-1.0,4.0,-5.0,-3.0,7.0,-5.0,0.0,6.0,-8.0,2.0,3.0,-6.0,0.0,5.0,-5.0,19.0,26.0,10.0,-2.0,6.0,-5.0,15.0,30.0,5.0,38.0,95.0,41.0,2.0,25.0,-23.0,-11.0,4.0,-5.0,-9.0,0.0,2.0,-9.0,-32.0,33.0,-1.0,-31.0,26.0,0.0,-6.0,6.0,2.0,-24.0,20.0,-1.0,-13.0,11.0,-6.0,-20.0,21.0,-1.0,-6.0,6.0,0.0,-26.0,26.0,3.0,-30.0,26.0,-1.0,-8.0,5.0,-3.0,-31.0,30.0,0.0,-38.0,32.0,9.0,-4.0,1.0,12.0,1.0,-2.0,1.0,20.0,-23.0,4.0,7.0,-7.0,0.0,9.0,-9.0,-35.0,-32.0,-71.0,-9.0,-9.0,-19.0,-15.0,-14.0,-17.0,-22.0,-19.0,-21.0,1.0,19.0,-26.0,1.0,10.0,-16.0,-2.0,11.0,-10.0,1.0,5.0,-9.0,-3.0,7.0,-5.0,-1.0,4.0,-8.0,-1.0,7.0,-7.0,0.0,8.0,-7.0,-1.0,7.0,-9.0,-2.0,12.0,-13.0,0.0,8.0,-11.0,24.0,29.0,15.0,-2.0,13.0,-19.0,23.0,28.0,11.0,14.0,33.0,3.0,-12.0,2.0,-4.0,-9.0,1.0,2.0,-7.0,-21.0,28.0,-1.0,-21.0,20.0,2.0,-4.0,8.0,3.0,-20.0,13.0,0.0,-3.0,7.0,-4.0,-14.0,14.0,0.0,-5.0,6.0,1.0,-16.0,16.0,3.0,-19.0,16.0,0.0,-5.0,6.0,-3.0,-16.0,20.0,1.0,-24.0,24.0,7.0,-4.0,4.0};
			return value;
		}
		private double[] getCoordinate_7_42_point_47()
		{
			double[] value = {10.0,1.0,0.0,-10.0,-6.0,-20.0,-14.0,-13.0,-18.0,-23.0,-20.0,-20.0,-53.0,-39.0,-40.0,-11.0,1.0,-21.0,-2.0,29.0,-46.0,-5.0,38.0,-51.0,9.0,21.0,-10.0,53.0,65.0,18.0,-9.0,3.0,-6.0,26.0,31.0,14.0,23.0,27.0,12.0,-11.0,1.0,3.0,-5.0,-16.0,26.0,0.0,-17.0,18.0,3.0,-4.0,6.0,2.0,-17.0,10.0,1.0,-4.0,7.0,-2.0,-10.0,13.0,0.0,-4.0,6.0,0.0,-14.0,15.0,3.0,-17.0,13.0,0.0,-5.0,6.0,-2.0,-12.0,19.0,0.0,-20.0,22.0,7.0,-5.0,3.0,-14.0,-13.0,-18.0,-24.0,-20.0,-21.0,-7.0,1.0,-1.0,-51.0,-36.0,-37.0,-9.0,3.0,-20.0,-9.0,67.0,-99.0,10.0,20.0,-10.0,49.0,66.0,11.0,24.0,35.0,18.0,-1.0,-12.0,27.0,2.0,-15.0,17.0,1.0,-6.0,5.0,4.0,-15.0,10.0,0.0,-4.0,5.0,0.0,-8.0,14.0,0.0,-4.0,6.0,1.0,-12.0,14.0,2.0,-16.0,13.0,0.0,-5.0,5.0,-2.0,-11.0,20.0,-1.0,-18.0,20.0,-25.0,-3.0,-12.0,-12.0,-10.0,-9.0,-61.0,-31.0,-27.0,-7.0,3.0,-16.0,-12.0,70.0,-106.0,8.0,16.0,-7.0,59.0,60.0,8.0,14.0,14.0,9.0,1.0,-11.0,25.0,2.0,-14.0,16.0,1.0,-6.0,5.0,4.0,-14.0,9.0,1.0,-5.0,5.0,0.0,-7.0,14.0,1.0,-4.0,6.0,1.0,-12.0,14.0,2.0,-16.0,11.0,0.0,-5.0,5.0,-1.0,-9.0,19.0,-28.0,4.0,-10.0,-1.0,-16.0,15.0,-60.0,-34.0,-25.0,-8.0,76.0,-116.0,56.0,63.0,10.0,-21.0,-14.0,24.0,25.0,1.0,-5.0,2.0,-14.0,17.0,3.0,-13.0,15.0,2.0,-14.0,14.0,2.0,-13.0,15.0,0.0,-12.0,16.0,-24.0,-1.0,4.0,-32.0,-23.0,-12.0,-9.0,56.0,-74.0,36.0,10.0,37.0,4.0,-21.0,24.0,-0.469,-4.409,4.414};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_7_44_point_1()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,-4.0,0.0,1.0,0.0,3.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,-1.0,0.0,0.0,0.0,-2.0,-1.0,-2.0,-2.0,-2.0,-1.0,0.0,2.0,1.0,0.0,0.0,2.0,2.0,0.0,2.0,0.0,2.0,0.0,0.0,0.0,1.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,0.0,-1.0,-1.0,-2.0,0.0,0.0,0.0,0.0,2.0,3.0,0.0,1.0,2.0,1.0,2.0,1.0,0.0,2.0,-1.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-134.0,40.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-90.0,-48.0,3.0,-4.0,-27.0,-19.0,0.0,0.0,1.0,-2.0,0.0,0.0,2.0,0.0,2.0,0.0,-1.0,2.0,-3.0,1.0,-2.0,3.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,-4.0,1.0,-3.0,2.0,0.0,0.0,-4.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,-3.0,2.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_2()
		{
			double[] value = {0.0,4.0,5.0,1.0,-1.0,2.0,0.0,2.0,-1.0,3.0,-8.0,2.0,-1.0,3.0,0.0,1.0,-3.0,0.0,0.0,-1.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,1.0,-3.0,2.0,-4.0,3.0,-1.0,1.0,-2.0,1.0,-4.0,0.0,-4.0,-3.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,0.0,-4.0,2.0,0.0,3.0,0.0,5.0,3.0,0.0,4.0,3.0,1.0,0.0,2.0,0.0,2.0,2.0,0.0,0.0,1.0,-3.0,1.0,0.0,2.0,0.0,2.0,-5.0,2.0,0.0,1.0,0.0,2.0,-10.0,3.0,-3.0,0.0,-1.0,0.0,1.0,-3.0,0.0,0.0,0.0,0.0,1.0,0.0,4.0,0.0,0.0,-2.0,1.0,-3.0,8.0,-2.0,1.0,-3.0,0.0,-2.0,1.0,-2.0,0.0,-3.0,0.0,-4.0,-6.0,-3.0,-3.0,0.0,-1.0,0.0,0.0,0.0,0.0,-5.0,4.0,-28.0,-2.0,4.0,-2.0,9.0,0.0,6.0,0.0,6.0,0.0,0.0,0.0,4.0,2.0,0.0,3.0,0.0,6.0,5.0,3.0,2.0,0.0,2.0,2.0,2.0,0.0,2.0,0.0,2.0,2.0,0.0,0.0,1.0,0.0,2.0,0.0,1.0,-2.0,1.0,0.0,1.0,0.0,1.0,-4.0,2.0,0.0,2.0,0.0,2.0,-5.0,2.0,-11.0,5.0,-3.0,0.0,0.0,0.0,0.0,2.0,4.0,13.0,-4.0,-4.0,-1.0,-3.0,0.0,-4.0,1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,0.0,2.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_3()
		{
			double[] value = {3.0,-1.0,10.0,-3.0,0.0,-2.0,0.0,-1.0,4.0,-2.0,0.0,-2.0,1.0,-2.0,0.0,-2.0,0.0,-2.0,0.0,-2.0,1.0,-4.0,0.0,-2.0,-4.0,-2.0,-6.0,-5.0,-3.0,0.0,-1.0,0.0,0.0,-4.0,0.0,-6.0,1.0,-6.0,2.0,-9.0,2.0,-3.0,1.0,0.0,0.0,0.0,0.0,0.0,-2.0,0.0,-2.0,4.0,-2.0,9.0,0.0,6.0,1.0,0.0,1.0,6.0,3.0,1.0,7.0,5.0,3.0,2.0,3.0,3.0,0.0,2.0,1.0,1.0,0.0,1.0,0.0,3.0,0.0,1.0,0.0,4.0,0.0,1.0,0.0,2.0,0.0,1.0,-2.0,1.0,1.0,1.0,0.0,2.0,-6.0,3.0,-6.0,2.0,-10.0,5.0,-3.0,0.0,-1.0,3.0,0.0,0.0,1.0,4.0,1.0,3.0,4.0,4.0,3.0,0.0,0.0,0.0,0.0,0.0,-4.0,-1.0,-4.0,-4.0,-1.0,-3.0,0.0,-4.0,1.0,-3.0,0.0,-2.0,1.0,0.0,3.0,0.0,11.0,-5.0,5.0,-2.0,0.0,-2.0,0.0,-2.0,3.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-2.0,1.0,-2.0,0.0,-2.0,1.0,-2.0,0.0,-2.0,-4.0,-3.0,-3.0,-2.0,-7.0,-5.0,-3.0,-1.0,0.0,-6.0,1.0,-6.0,2.0,-8.0,2.0,-3.0,1.0,0.0,0.0,0.0,0.0,0.0,-2.0,0.0,-2.0,4.0,-1.0,8.0,3.0,1.0,0.0,6.0,8.0,7.0,3.0,3.0,4.0,3.0,1.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_4()
		{
			double[] value = {0.0,2.0,1.0,2.0,0.0,1.0,-1.0,4.0,0.0,4.0,0.0,3.0,0.0,0.0,0.0,2.0,0.0,1.0,0.0,1.0,-3.0,2.0,-5.0,3.0,-7.0,3.0,-10.0,5.0,0.0,4.0,-2.0,1.0,1.0,3.0,4.0,3.0,3.0,0.0,0.0,0.0,0.0,0.0,-4.0,0.0,-4.0,-4.0,-1.0,-3.0,0.0,-4.0,1.0,-3.0,3.0,0.0,10.0,-5.0,6.0,-2.0,5.0,-3.0,-1.0,-2.0,0.0,-1.0,2.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,1.0,-3.0,0.0,-1.0,1.0,-2.0,0.0,-2.0,-2.0,-2.0,-4.0,-3.0,-3.0,-3.0,-7.0,-7.0,0.0,-6.0,1.0,-7.0,2.0,-3.0,2.0,0.0,0.0,0.0,0.0,0.0,-3.0,0.0,-1.0,4.0,9.0,13.0,-2.0,4.0,4.0,4.0,4.0,3.0,2.0,2.0,1.0,2.0,1.0,1.0,3.0,0.0,-2.0,0.0,-1.0,2.0,-1.0,2.0,-1.0,4.0,0.0,4.0,1.0,3.0,0.0,1.0,-1.0,0.0,0.0,1.0,-1.0,1.0,0.0,2.0,-3.0,2.0,-6.0,4.0,-5.0,3.0,0.0,2.0,-10.0,7.0,4.0,3.0,3.0,0.0,0.0,0.0,0.0,0.0,-4.0,0.0,-4.0,-4.0,0.0,-2.0,0.0,-4.0,10.0,-5.0,7.0,-3.0,5.0,-3.0,2.0,-2.0,0.0,-1.0,-1.0,-1.0,0.0,-2.0,0.0,-3.0,0.0,-4.0,2.0,-5.0,1.0,-4.0,-1.0,-2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_5()
		{
			double[] value = {-2.0,-2.0,-4.0,-3.0,-3.0,-4.0,3.0,-4.0,3.0,-1.0,1.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,2.0,5.0,-1.0,1.0,3.0,5.0,3.0,3.0,1.0,1.0,0.0,1.0,2.0,0.0,1.0,0.0,0.0,2.0,-3.0,3.0,0.0,5.0,-1.0,4.0,0.0,3.0,0.0,2.0,0.0,1.0,-2.0,0.0,0.0,1.0,0.0,2.0,-3.0,2.0,-6.0,4.0,1.0,2.0,-5.0,3.0,4.0,0.0,0.0,0.0,0.0,0.0,-5.0,0.0,-2.0,-2.0,0.0,-2.0,6.0,-3.0,6.0,-4.0,3.0,-2.0,0.0,-2.0,0.0,-1.0,-1.0,-2.0,0.0,-3.0,0.0,-4.0,1.0,-4.0,2.0,-3.0,1.0,-3.0,0.0,-1.0,-1.0,-1.0,-3.0,-3.0,-2.0,-5.0,2.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,4.0,6.0,-1.0,0.0,2.0,2.0,0.0,0.0,2.0,0.0,2.0,0.0,-4.0,-12.0,-4.0,-12.0,-1.0,-5.0,0.0,-5.0,1.0,-3.0,0.0,4.0,1.0,4.0,1.0,4.0,5.0,14.0,2.0,12.0,0.0,0.0,0.0,1.0,0.0,2.0,0.0,1.0,-1.0,4.0,-1.0,6.0,0.0,2.0,-1.0,3.0,-1.0,2.0,0.0,1.0,-8.0,34.0,3.0,-10.0,0.0,-6.0,-11.0,10.0,-1.0,0.0,0.0,0.0,0.0,0.0,8.0,-10.0,4.0,-4.0,4.0,-3.0,0.0,0.0,2.0,1.0,6.0,-3.0,5.0,-2.0,-12.0,-5.0,-4.0,0.0,0.0,1.0,-2.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_6()
		{
			double[] value = {4.0,0.0,-7.0,5.0,0.0,0.0,0.0,0.0,-5.0,0.0,-1.0,-2.0,7.0,-4.0,2.0,-2.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,-1.0,-1.0,0.0,-1.0,0.0,-3.0,1.0,-4.0,1.0,-4.0,1.0,-2.0,1.0,-2.0,1.0,0.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,-1.0,-1.0,2.0,0.0,0.0,0.0,2.0,2.0,0.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,-4.0,-12.0,-4.0,-12.0,-1.0,-5.0,0.0,0.0,-1.0,-5.0,0.0,0.0,-1.0,-6.0,0.0,0.0,-1.0,-15.0,2.0,4.0,9.0,21.0,5.0,18.0,2.0,11.0,1.0,2.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,4.0,0.0,7.0,-1.0,3.0,-1.0,3.0,0.0,3.0,0.0,2.0,0.0,0.0,7.0,4.0,1.0,3.0,-6.0,2.0,-5.0,5.0,1.0,6.0,0.0,7.0,-17.0,16.0,28.0,28.0,-11.0,0.0,-8.0,-2.0,-9.0,-3.0,-8.0,-5.0,-5.0,-5.0,0.0,-4.0,0.0,-8.0,0.0,-7.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,-1.0,8.0,-13.0,6.0,-9.0,4.0,-4.0,4.0,-4.0,3.0,-4.0,0.0,0.0,4.0,-2.0,0.0,0.0,0.0,0.0,0.0,0.0,-6.0,-1.0,0.0,0.0,-2.0,2.0,0.0,0.0,-4.0,0.0,2.0,-3.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-2.0,1.0,-3.0,1.0,-4.0,0.0,-5.0,3.0,-3.0,0.0,-2.0,0.0,-2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_7()
		{
			double[] value = {0.0,0.0,2.0,0.0,0.0,0.0,-4.0,-12.0,-3.0,-12.0,0.0,-2.0,-1.0,-4.0,-1.0,-4.0,0.0,-4.0,-2.0,-2.0,-1.0,-16.0,0.0,0.0,2.0,-9.0,0.0,0.0,2.0,3.0,13.0,25.0,5.0,19.0,2.0,8.0,5.0,-6.0,0.0,7.0,-3.0,5.0,0.0,3.0,0.0,4.0,3.0,4.0,0.0,10.0,-2.0,7.0,-1.0,3.0,-2.0,2.0,0.0,1.0,4.0,4.0,2.0,4.0,-2.0,1.0,-5.0,2.0,2.0,5.0,2.0,3.0,-10.0,9.0,-18.0,17.0,-11.0,9.0,4.0,5.0,9.0,4.0,10.0,3.0,8.0,0.0,11.0,-1.0,11.0,-2.0,-2.0,2.0,12.0,-3.0,0.0,0.0,-13.0,4.0,-12.0,2.0,-11.0,0.0,-8.0,-2.0,-9.0,-3.0,-8.0,-5.0,-5.0,-5.0,-2.0,-4.0,0.0,0.0,0.0,-8.0,0.0,0.0,0.0,0.0,2.0,0.0,16.0,-14.0,3.0,-10.0,1.0,-7.0,5.0,-5.0,6.0,-3.0,5.0,-2.0,-6.0,-3.0,0.0,0.0,-5.0,-2.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,1.0,-2.0,1.0,-3.0,0.0,-2.0,1.0,-6.0,0.0,-4.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,0.0,-2.0,-12.0,4.0,-1.0,-5.0,-18.0,-8.0,-21.0,1.0,-11.0,-1.0,-3.0,6.0,-6.0,0.0,0.0,0.0,0.0,1.0,2.0,13.0,26.0,5.0,18.0,4.0,-7.0,4.0,-6.0,0.0,9.0,-2.0,8.0,0.0,7.0,0.0,3.0,-2.0,7.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_8()
		{
			double[] value = {1.0,3.0,1.0,7.0,0.0,10.0,0.0,3.0,-2.0,8.0,-1.0,3.0,-1.0,3.0,3.0,4.0,2.0,3.0,-1.0,3.0,-1.0,1.0,2.0,4.0,2.0,5.0,-6.0,2.0,-9.0,8.0,-15.0,19.0,8.0,3.0,10.0,2.0,9.0,0.0,8.0,0.0,14.0,-1.0,10.0,6.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,0.0,0.0,1.0,0.0,6.0,-1.0,-7.0,-1.0,0.0,0.0,0.0,0.0,8.0,1.0,0.0,0.0,7.0,-1.0,0.0,-1.0,-6.0,-2.0,0.0,0.0,0.0,0.0,6.0,2.0,-16.0,-4.0,-6.0,4.0,0.0,1.0,0.0,0.0,0.0,0.0,-10.0,3.0,-13.0,4.0,-12.0,2.0,-11.0,0.0,-8.0,-2.0,-9.0,-3.0,-8.0,-5.0,-5.0,-5.0,-1.0,-4.0,2.0,0.0,12.0,-10.0,17.0,-16.0,-1.0,-7.0,0.0,-6.0,6.0,-5.0,5.0,-2.0,-2.0,-3.0,-6.0,-4.0,0.0,0.0,0.0,-2.0,1.0,-3.0,1.0,-3.0,0.0,-3.0,0.0,-7.0,0.0,-4.0,0.0,-1.0,-1.0,-2.0,0.0,-1.0,0.0,-2.0,5.0,-8.0,-2.0,-9.0,-4.0,-19.0,4.0,-7.0,-12.0,-26.0,5.0,-2.0,0.0,-1.0,0.0,0.0,0.0,0.0,1.0,2.0,12.0,21.0,6.0,-3.0,5.0,-2.0,2.0,12.0,0.0,8.0,0.0,5.0,-3.0,7.0,1.0,4.0,1.0,7.0,-4.0,6.0,2.0,9.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_9()
		{
			double[] value = {0.0,11.0,0.0,6.0,-2.0,8.0,-1.0,4.0,3.0,2.0,-1.0,9.0,0.0,4.0,3.0,4.0,4.0,6.0,-2.0,2.0,-6.0,3.0,-7.0,7.0,9.0,6.0,9.0,2.0,10.0,2.0,9.0,1.0,9.0,2.0,18.0,7.0,0.0,0.0,0.0,0.0,-3.0,-2.0,0.0,0.0,0.0,0.0,0.0,0.0,-4.0,1.0,0.0,0.0,0.0,0.0,-3.0,-5.0,0.0,0.0,0.0,0.0,4.0,-2.0,1.0,0.0,-7.0,2.0,-5.0,2.0,-7.0,3.0,0.0,0.0,0.0,0.0,-8.0,1.0,-19.0,5.0,-12.0,3.0,-11.0,0.0,-8.0,-1.0,-10.0,-3.0,-9.0,-4.0,-3.0,-5.0,12.0,-9.0,18.0,-17.0,9.0,-9.0,-3.0,-3.0,-1.0,-5.0,6.0,-2.0,1.0,-1.0,-3.0,-4.0,-3.0,-4.0,1.0,-1.0,2.0,-2.0,1.0,-3.0,1.0,-7.0,-1.0,-10.0,-2.0,-4.0,0.0,-4.0,0.0,-3.0,3.0,-5.0,-1.0,-7.0,-1.0,-9.0,3.0,-7.0,-3.0,-18.0,5.0,-3.0,-11.0,-20.0,-2.0,-1.0,0.0,0.0,0.0,0.0,3.0,2.0,8.0,1.0,8.0,0.0,5.0,15.0,1.0,9.0,1.0,6.0,1.0,4.0,0.0,5.0,-4.0,7.0,0.0,8.0,0.0,17.0,0.0,12.0,-1.0,9.0,-1.0,9.0,1.0,7.0,0.0,11.0,5.0,5.0,7.0,6.0,0.0,4.0,-1.0,2.0,-6.0,3.0,11.0,3.0,9.0,3.0,7.0,3.0,6.0,2.0,4.0,-2.0,11.0,2.0,80.0,-16.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_10()
		{
			double[] value = {0.0,0.0,-3.0,-2.0,0.0,1.0,4.0,3.0,0.0,0.0,0.0,0.0,7.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,0.0,43.0,-13.0,0.0,0.0,0.0,0.0,-44.0,14.0,-88.0,14.0,-1.0,4.0,-1.0,3.0,2.0,0.0,0.0,0.0,0.0,0.0,-2.0,-1.0,0.0,0.0,1.0,-1.0,-3.0,1.0,0.0,0.0,-3.0,-5.0,0.0,0.0,1.0,0.0,-7.0,2.0,-5.0,2.0,0.0,0.0,-8.0,0.0,-13.0,1.0,-14.0,1.0,-8.0,0.0,-9.0,-1.0,-10.0,-2.0,-7.0,-3.0,16.0,-19.0,9.0,-8.0,5.0,-2.0,-3.0,-5.0,-1.0,-4.0,1.0,-1.0,1.0,-3.0,-3.0,-3.0,-2.0,-4.0,2.0,-3.0,1.0,-3.0,1.0,-8.0,0.0,-3.0,0.0,-10.0,-2.0,-7.0,0.0,-3.0,2.0,-7.0,0.0,-3.0,0.0,-7.0,3.0,-8.0,0.0,-9.0,3.0,-5.0,-2.0,-12.0,-8.0,-16.0,-4.0,-4.0,0.0,0.0,0.0,0.0,11.0,-1.0,8.0,0.0,2.0,6.0,3.0,12.0,1.0,9.0,0.0,4.0,1.0,4.0,6.0,1.0,-4.0,3.0,0.0,8.0,-4.0,6.0,2.0,16.0,0.0,16.0,0.0,12.0,-1.0,12.0,-2.0,12.0,7.0,5.0,5.0,13.0,3.0,5.0,0.0,2.0,8.0,3.0,6.0,3.0,6.0,2.0,11.0,2.0,7.0,0.0,70.0,-7.0,3.0,-9.0,-4.0,-3.0,0.0,0.0,-2.0,-3.0,0.0,0.0,-1.0,0.0,-1.0,-5.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_11()
		{
			double[] value = {0.0,-5.0,0.0,7.0,1.0,4.0,4.0,3.0,0.0,0.0,2.0,-1.0,3.0,2.0,1.0,-1.0,7.0,3.0,1.0,-2.0,0.0,0.0,5.0,1.0,0.0,1.0,-1.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,36.0,-14.0,0.0,-1.0,0.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0,1.0,-1.0,2.0,-1.0,1.0,-2.0,1.0,-3.0,1.0,-3.0,0.0,-4.0,1.0,-4.0,4.0,-4.0,3.0,-8.0,3.0,-8.0,3.0,-8.0,2.0,-11.0,3.0,0.0,1.0,-16.0,1.0,-16.0,0.0,-14.0,0.0,-12.0,0.0,-8.0,1.0,-1.0,1.0,-3.0,3.0,0.0,0.0,0.0,-1.0,-5.0,0.0,-5.0,-2.0,-7.0,1.0,-7.0,-1.0,-9.0,-2.0,-9.0,-1.0,-10.0,-2.0,-9.0,-2.0,-8.0,-6.0,8.0,-7.0,6.0,-3.0,1.0,-2.0,-5.0,-6.0,-2.0,-4.0,1.0,-4.0,0.0,-9.0,-3.0,-2.0,2.0,-4.0,1.0,-8.0,0.0,-6.0,0.0,-11.0,-2.0,-9.0,4.0,-6.0,-2.0,-7.0,0.0,-4.0,3.0,-7.0,0.0,-5.0,4.0,-6.0,-1.0,-6.0,-1.0,-9.0,-5.0,-15.0,-1.0,-5.0,0.0,0.0,8.0,0.0,4.0,0.0,0.0,0.0,2.0,5.0,4.0,10.0,2.0,11.0,1.0,4.0,8.0,-1.0,1.0,4.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_12()
		{
			double[] value = {1.0,8.0,-8.0,3.0,0.0,19.0,1.0,18.0,0.0,16.0,0.0,14.0,3.0,19.0,6.0,13.0,2.0,5.0,7.0,3.0,5.0,2.0,11.0,3.0,7.0,0.0,9.0,-1.0,13.0,-1.0,13.0,0.0,17.0,0.0,2.0,-3.0,10.0,-14.0,2.0,-3.0,0.0,-5.0,1.0,0.0,0.0,0.0,0.0,-6.0,-1.0,0.0,0.0,-6.0,0.0,0.0,0.0,-2.0,0.0,0.0,0.0,3.0,0.0,6.0,0.0,7.0,1.0,3.0,2.0,-1.0,3.0,0.0,2.0,2.0,4.0,-1.0,1.0,2.0,0.0,0.0,0.0,0.0,5.0,3.0,6.0,1.0,5.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,7.0,-1.0,4.0,-3.0,4.0,-3.0,4.0,-1.0,3.0,-1.0,3.0,-1.0,2.0,-1.0,1.0,-1.0,0.0,0.0,0.0,-1.0,0.0,-1.0,1.0,-1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,-1.0,2.0,-1.0,1.0,-2.0,1.0,-3.0,1.0,-3.0,0.0,-4.0,2.0,-4.0,4.0,-4.0,2.0,-8.0,4.0,-9.0,2.0,-3.0,-6.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,0.0,-8.0,-1.0,0.0,0.0,0.0,0.0,-3.0,-3.0,1.0,0.0,3.0,3.0,0.0,0.0,6.0,2.0,0.0,0.0,-3.0,8.0,-1.0,2.0,-11.0,2.0,-15.0,1.0,-17.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_13()
		{
			double[] value = {-13.0,0.0,-12.0,0.0,-8.0,1.0,-1.0,0.0,0.0,0.0,-7.0,-1.0,0.0,0.0,-11.0,-2.0,-4.0,2.0,-6.0,-3.0,-7.0,-3.0,-9.0,-3.0,-10.0,-3.0,7.0,-3.0,0.0,-2.0,-1.0,-4.0,-7.0,-6.0,-4.0,-5.0,0.0,-11.0,-1.0,-7.0,2.0,-9.0,0.0,-9.0,0.0,-12.0,0.0,-17.0,0.0,-8.0,4.0,-7.0,0.0,-5.0,4.0,-5.0,-1.0,-4.0,0.0,-4.0,-1.0,-9.0,-3.0,-12.0,-1.0,-5.0,4.0,0.0,6.0,0.0,0.0,0.0,0.0,0.0,3.0,5.0,5.0,10.0,1.0,8.0,9.0,0.0,1.0,4.0,0.0,3.0,0.0,9.0,-1.0,17.0,2.0,20.0,0.0,21.0,0.0,13.0,0.0,6.0,0.0,19.0,6.0,13.0,14.0,6.0,7.0,0.0,10.0,-2.0,13.0,-1.0,14.0,0.0,6.0,-12.0,19.0,-9.0,2.0,-7.0,3.0,0.0,0.0,0.0,0.0,-6.0,0.0,0.0,-1.0,-3.0,-1.0,0.0,-3.0,-4.0,0.0,0.0,0.0,-2.0,1.0,-3.0,0.0,4.0,0.0,2.0,2.0,0.0,3.0,3.0,0.0,4.0,0.0,6.0,0.0,5.0,3.0,0.0,5.0,1.0,2.0,0.0,0.0,0.0,0.0,3.0,0.0,0.0,2.0,0.0,1.0,2.0,3.0,3.0,6.0,0.0,7.0,0.0,6.0,0.0,4.0,-2.0,3.0,-2.0,4.0,-1.0,3.0,0.0,3.0,-1.0,2.0,-1.0,0.0,-1.0,0.0,-1.0,0.0,-1.0,1.0,-1.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_14()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,1.0,-2.0,1.0,-3.0,1.0,-3.0,0.0,-4.0,1.0,-4.0,4.0,-4.0,3.0,-8.0,3.0,-7.0,2.0,2.0,-5.0,0.0,0.0,1.0,-1.0,0.0,0.0,0.0,-2.0,0.0,-1.0,-6.0,0.0,0.0,0.0,-1.0,2.0,-7.0,-3.0,-1.0,1.0,-3.0,-2.0,-2.0,1.0,0.0,0.0,-4.0,-4.0,0.0,-10.0,0.0,6.0,0.0,0.0,2.0,4.0,1.0,0.0,0.0,0.0,2.0,4.0,0.0,0.0,3.0,3.0,-4.0,9.0,-3.0,4.0,0.0,1.0,-16.0,1.0,-16.0,0.0,-14.0,0.0,-12.0,0.0,-8.0,0.0,-1.0,0.0,-7.0,0.0,-11.0,-3.0,-6.0,-2.0,-6.0,-3.0,-8.0,-3.0,0.0,-2.0,-3.0,-5.0,-5.0,-13.0,-6.0,-5.0,3.0,-12.0,0.0,-12.0,0.0,-12.0,0.0,-16.0,-2.0,-16.0,4.0,-6.0,0.0,-8.0,4.0,-3.0,-1.0,-5.0,-1.0,-5.0,-2.0,-11.0,-3.0,-10.0,7.0,0.0,7.0,0.0,-2.0,-4.0,0.0,0.0,0.0,0.0,3.0,5.0,5.0,9.0,8.0,1.0,4.0,7.0,10.0,0.0,6.0,0.0,1.0,2.0,-7.0,0.0,-9.0,1.0,1.0,3.0,1.0,7.0,1.0,15.0,2.0,20.0,0.0,7.0,0.0,20.0,0.0,13.0,0.0,8.0,1.0,21.0,10.0,1.0,13.0,0.0,15.0,-1.0,1.0,-16.0,19.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_15()
		{
			double[] value = {2.0,-5.0,17.0,-1.0,2.0,0.0,-1.0,-3.0,0.0,-1.0,-3.0,-3.0,0.0,0.0,0.0,-2.0,-1.0,0.0,1.0,-4.0,0.0,0.0,1.0,-6.0,0.0,0.0,1.0,1.0,0.0,6.0,0.0,4.0,3.0,2.0,2.0,3.0,1.0,3.0,0.0,7.0,6.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,5.0,2.0,1.0,7.0,1.0,6.0,2.0,5.0,1.0,5.0,0.0,4.0,-1.0,4.0,-2.0,3.0,0.0,3.0,0.0,3.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,3.0,-1.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,-2.0,-2.0,-2.0,-1.0,-1.0,-2.0,0.0,-2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,2.0,2.0,2.0,2.0,1.0,1.0,2.0,-1.0,1.0,0.0,2.0,0.0,2.0,0.0,0.0,0.0,0.0,-1.0,0.0,-1.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,0.0,-2.0,1.0,-3.0,1.0,-3.0,1.0,-4.0,1.0,-4.0,3.0,-4.0,3.0,-6.0,0.0,0.0,-2.0,0.0,-1.0,0.0,0.0,-6.0,0.0,-6.0,-1.0,-5.0,-3.0,0.0,0.0,0.0,0.0,-1.0,-1.0,-4.0,1.0,-2.0,-2.0,-3.0,1.0,-2.0,0.0,0.0,-4.0,0.0,-7.0,0.0,-6.0,0.0,-2.0,0.0,0.0,1.0,3.0,0.0,0.0,0.0,6.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_16()
		{
			double[] value = {0.0,0.0,-1.0,6.0,0.0,0.0,0.0,0.0,0.0,5.0,-3.0,3.0,-10.0,14.0,-2.0,3.0,-17.0,0.0,-13.0,0.0,-13.0,1.0,-9.0,0.0,-7.0,0.0,-11.0,-4.0,-5.0,-2.0,-7.0,-3.0,-2.0,-5.0,-6.0,-13.0,-2.0,-19.0,0.0,-14.0,0.0,-16.0,-1.0,-18.0,0.0,-19.0,8.0,-3.0,-2.0,-8.0,-1.0,-4.0,-2.0,-5.0,0.0,-9.0,8.0,0.0,7.0,0.0,-4.0,-10.0,-2.0,-4.0,0.0,0.0,0.0,1.0,3.0,4.0,9.0,0.0,3.0,9.0,8.0,0.0,9.0,1.0,2.0,7.0,1.0,2.0,0.0,2.0,-5.0,0.0,-7.0,0.0,1.0,6.0,1.0,14.0,1.0,20.0,1.0,12.0,2.0,18.0,0.0,14.0,0.0,10.0,15.0,1.0,15.0,-2.0,19.0,-5.0,15.0,0.0,-1.0,-4.0,1.0,0.0,0.0,-2.0,0.0,0.0,2.0,-4.0,0.0,0.0,-1.0,-6.0,0.0,-1.0,3.0,-6.0,0.0,0.0,0.0,1.0,2.0,0.0,0.0,1.0,-1.0,6.0,0.0,7.0,9.0,7.0,2.0,1.0,0.0,0.0,0.0,1.0,2.0,0.0,0.0,10.0,7.0,2.0,6.0,2.0,5.0,2.0,5.0,1.0,4.0,-1.0,3.0,-1.0,3.0,0.0,3.0,0.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,-2.0,0.0,0.0,0.0,0.0,0.0,3.0,0.0,3.0,0.0,0.0,0.0,0.0,-2.0,0.0,-3.0,-3.0,-1.0,-1.0,-1.0,0.0,0.0,0.0,-3.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_17()
		{
			double[] value = {0.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,3.0,0.0,0.0,0.0,3.0,0.0,0.0,2.0,1.0,2.0,1.0,-1.0,3.0,0.0,2.0,0.0,0.0,0.0,0.0,-3.0,0.0,-2.0,0.0,0.0,0.0,3.0,0.0,2.0,0.0,-1.0,1.0,0.0,0.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,-3.0,1.0,-3.0,0.0,-4.0,1.0,-3.0,2.0,-4.0,1.0,-6.0,0.0,-7.0,0.0,-6.0,-1.0,-3.0,-3.0,-1.0,-1.0,-2.0,0.0,0.0,0.0,0.0,-4.0,0.0,0.0,-2.0,0.0,-5.0,0.0,-2.0,0.0,0.0,-6.0,0.0,-6.0,-1.0,-4.0,-3.0,-3.0,-1.0,0.0,0.0,-5.0,-1.0,4.0,0.0,0.0,0.0,2.0,0.0,0.0,4.0,3.0,1.0,0.0,0.0,4.0,0.0,0.0,0.0,6.0,0.0,0.0,-4.0,0.0,-2.0,7.0,-19.0,9.0,-6.0,11.0,-14.0,0.0,-13.0,2.0,-10.0,1.0,-7.0,-1.0,-14.0,-6.0,-5.0,-13.0,0.0,-19.0,0.0,-6.0,0.0,-13.0,0.0,-21.0,-2.0,-20.0,1.0,-17.0,0.0,-9.0,-1.0,-3.0,0.0,-4.0,10.0,0.0,9.0,-1.0,-6.0,-8.0,-3.0,-9.0,-3.0,-3.0,0.0,0.0,1.0,0.0,7.0,1.0,4.0,4.0,9.0,1.0,7.0,2.0,4.0,7.0,3.0,7.0,0.0,2.0,2.0,3.0,1.0,4.0,-11.0,-1.0,1.0,12.0,0.0,21.0,2.0,14.0,5.0,19.0,1.0,13.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_18()
		{
			double[] value = {16.0,0.0,17.0,0.0,0.0,-6.0,14.0,2.0,2.0,-3.0,2.0,1.0,0.0,-6.0,0.0,0.0,3.0,-7.0,0.0,0.0,6.0,-4.0,0.0,1.0,0.0,0.0,1.0,12.0,3.0,1.0,4.0,0.0,7.0,2.0,0.0,14.0,6.0,3.0,5.0,5.0,5.0,3.0,3.0,0.0,3.0,0.0,3.0,0.0,0.0,-1.0,0.0,-1.0,1.0,0.0,3.0,0.0,0.0,-3.0,-2.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,0.0,1.0,-3.0,0.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,-1.0,3.0,0.0,3.0,0.0,0.0,0.0,2.0,0.0,1.0,2.0,1.0,-1.0,3.0,0.0,0.0,-2.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,0.0,1.0,0.0,2.0,-1.0,1.0,0.0,2.0,-3.0,0.0,-3.0,0.0,-4.0,2.0,-4.0,0.0,-5.0,-1.0,-5.0,-1.0,-6.0,-2.0,-7.0,-1.0,-1.0,-1.0,0.0,-5.0,0.0,-1.0,0.0,0.0,-2.0,0.0,-6.0,0.0,0.0,-7.0,-1.0,-3.0,-2.0,-3.0,-2.0,-2.0,0.0,-4.0,0.0,-6.0,-2.0,0.0,0.0,0.0,0.0,7.0,0.0,0.0,-1.0,4.0,1.0,0.0,0.0,2.0,0.0,0.0,3.0,3.0,0.0,1.0,1.0,3.0,-3.0,0.0,-17.0,1.0,-2.0,4.0,-19.0,0.0,-1.0,17.0,-15.0,0.0,-13.0,-1.0,-10.0,-1.0,0.0,-21.0,0.0,-8.0,0.0,-13.0,-1.0,-20.0,0.0,-7.0,-2.0,-20.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_19()
		{
			double[] value = {-1.0,-15.0,-1.0,-7.0,0.0,-3.0,10.0,-1.0,6.0,0.0,-2.0,-2.0,-4.0,-8.0,-3.0,-8.0,-3.0,-4.0,0.0,0.0,9.0,2.0,0.0,0.0,9.0,2.0,17.0,2.0,-8.0,-1.0,2.0,5.0,3.0,6.0,4.0,7.0,0.0,2.0,1.0,3.0,0.0,5.0,0.0,10.0,2.0,18.0,3.0,17.0,1.0,18.0,17.0,0.0,16.0,0.0,3.0,-8.0,2.0,0.0,0.0,1.0,7.0,-4.0,8.0,-1.0,0.0,1.0,0.0,8.0,9.0,1.0,5.0,4.0,0.0,8.0,6.0,8.0,4.0,6.0,3.0,2.0,3.0,1.0,3.0,0.0,0.0,-3.0,0.0,-3.0,1.0,-3.0,0.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0,1.0,0.0,3.0,-1.0,3.0,0.0,3.0,0.0,3.0,0.0,2.0,0.0,0.0,0.0,1.0,0.0,1.0,-1.0,2.0,-3.0,0.0,-3.0,1.0,-4.0,0.0,-5.0,-2.0,-5.0,-2.0,-6.0,-2.0,-7.0,-2.0,0.0,-10.0,-2.0,0.0,0.0,-1.0,0.0,0.0,-2.0,-1.0,-8.0,-7.0,0.0,-7.0,1.0,-6.0,-1.0,-1.0,-2.0,0.0,0.0,0.0,0.0,0.0,-2.0,7.0,1.0,1.0,0.0,6.0,0.0,0.0,-3.0,4.0,0.0,0.0,0.0,2.0,0.0,0.0,1.0,4.0,-16.0,0.0,-19.0,5.0,-15.0,1.0,-14.0,-2.0,0.0,-10.0,0.0,-14.0,-3.0,-18.0,-1.0,-12.0,-1.0,-20.0,-1.0,-14.0,0.0,-6.0,8.0,0.0,4.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_20()
		{
			double[] value = {-1.0,-2.0,-1.0,-2.0,-2.0,-7.0,-3.0,-8.0,-3.0,-3.0,9.0,1.0,0.0,0.0,9.0,2.0,9.0,2.0,9.0,2.0,1.0,0.0,11.0,3.0,3.0,4.0,-11.0,-3.0,-9.0,-2.0,5.0,7.0,4.0,6.0,0.0,3.0,1.0,2.0,2.0,5.0,1.0,11.0,3.0,17.0,2.0,17.0,22.0,3.0,8.0,1.0,8.0,-1.0,10.0,3.0,6.0,5.0,5.0,12.0,4.0,9.0,3.0,5.0,3.0,2.0,1.0,-4.0,0.0,-3.0,0.0,-4.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,-1.0,4.0,0.0,3.0,-1.0,4.0,-1.0,5.0,-1.0,3.0,-3.0,-1.0,-3.0,0.0,-5.0,-3.0,-5.0,-5.0,-5.0,-3.0,0.0,-14.0,-8.0,-2.0,-4.0,0.0,-3.0,-1.0,-1.0,-12.0,0.0,0.0,0.0,0.0,-6.0,5.0,0.0,0.0,-3.0,7.0,0.0,0.0,0.0,5.0,-2.0,-1.0,-2.0,3.0,-13.0,-2.0,0.0,6.0,-18.0,-1.0,-16.0,0.0,-1.0,-13.0,-5.0,-19.0,-2.0,-14.0,0.0,-21.0,0.0,-11.0,11.0,1.0,-2.0,-5.0,-2.0,-3.0,0.0,-2.0,-3.0,-7.0,-3.0,-6.0,8.0,1.0,-1.0,-4.0,9.0,2.0,10.0,2.0,11.0,3.0,0.0,0.0,9.0,4.0,0.0,0.0,2.0,4.0,12.0,5.0,-5.0,-2.0,2.0,4.0,-9.0,-4.0,-3.0,-1.0,-9.0,-3.0,4.0,7.0,2.0,3.0,1.0,2.0,3.0,6.0,3.0,12.0,7.0,17.0,10.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_21()
		{
			double[] value = {11.0,3.0,9.0,4.0,7.0,6.0,5.0,11.0,2.0,3.0,3.0,11.0,2.0,4.0,1.0,-5.0,0.0,-5.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,-1.0,5.0,-1.0,5.0,-1.0,5.0,-1.0,5.0,-3.0,-2.0,-4.0,-6.0,-5.0,-8.0,0.0,-8.0,-6.0,-4.0,-8.0,-1.0,0.0,-8.0,-1.0,0.0,-8.0,2.0,-7.0,3.0,0.0,-1.0,-2.0,1.0,-3.0,7.0,-16.0,-1.0,-17.0,0.0,-1.0,-18.0,-3.0,-17.0,-1.0,-18.0,0.0,-10.0,-1.0,-5.0,-1.0,-3.0,0.0,-2.0,-3.0,-6.0,12.0,1.0,-4.0,-6.0,10.0,3.0,11.0,3.0,6.0,2.0,-1.0,-3.0,6.0,2.0,0.0,0.0,0.0,1.0,8.0,5.0,5.0,3.0,1.0,3.0,0.0,3.0,-5.0,-3.0,1.0,5.0,-11.0,-5.0,1.0,2.0,0.0,2.0,2.0,5.0,1.0,11.0,11.0,3.0,12.0,7.0,8.0,5.0,7.0,9.0,7.0,11.0,2.0,6.0,2.0,6.0,0.0,-6.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,-1.0,6.0,-2.0,8.0,-1.0,4.0,-4.0,-9.0,-5.0,-12.0,-6.0,-5.0,-10.0,-2.0,-8.0,1.0,-8.0,-2.0,-22.0,-3.0,-2.0,-17.0,-3.0,-17.0,-1.0,-11.0,-2.0,-5.0,0.0,-2.0,0.0,-2.0,10.0,1.0,-3.0,-6.0,10.0,4.0,3.0,1.0,8.0,3.0,-2.0,-4.0,5.0,2.0,0.0,-1.0,0.0,0.0,5.0,3.0,3.0,2.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_22()
		{
			double[] value = {0.0,2.0,0.0,4.0,-1.0,4.0,-1.0,1.0,0.0,3.0,15.0,11.0,6.0,5.0,6.0,8.0,7.0,12.0,2.0,5.0,0.0,-1.0,0.0,0.0,0.0,1.0,0.0,1.0,-1.0,6.0,-2.0,3.0,-2.0,-3.0,-5.0,-11.0,-7.0,-6.0,-9.0,-4.0,-11.0,-3.0,-10.0,-2.0,-7.0,-17.0,-3.0,-12.0,-3.0,-6.0,0.0,-1.0,9.0,2.0,0.0,-1.0,11.0,5.0,-1.0,-5.0,5.0,3.0,-1.0,-4.0,0.0,-2.0,3.0,2.0,6.0,7.0,0.0,0.0,0.0,0.0,0.0,3.0,0.0,3.0,0.0,3.0,0.0,0.0,7.0,6.0,6.0,7.0,6.0,7.0,6.0,12.0,0.0,0.0,0.0,1.0,0.0,1.0,0.0,5.0,-7.0,-11.0,-7.0,-9.0,-8.0,-5.0,-12.0,-7.0,-11.0,-3.0,-1.0,-11.0,-1.0,-4.0,14.0,5.0,2.0,-1.0,0.0,-4.0,0.0,-3.0,7.0,8.0,2.0,3.0,0.0,0.0,0.0,0.0,2.0,3.0,2.0,6.0,7.0,6.0,4.0,8.0,0.0,0.0,0.0,1.0,-6.0,-8.0,-6.0,-5.0,-14.0,-10.0,8.0,1.0,1.0,0.0,0.0,-2.0,4.0,3.0,0.0,0.0,2.0,6.0,6.0,6.0,0.0,0.0,-1.0,0.0,-6.0,-6.0,0.0,0.0,-187.0,181.0,3.0,-1.0,2.0,-1.0,2.0,-1.0,2.0,-2.0,1.0,-2.0,1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,-1.0,-3.0,-1.0,-2.0,-1.0,-2.0,-2.0,-2.0,-2.0,-1.0,-3.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_23()
		{
			double[] value = {-2.0,0.0,-3.0,0.0,-2.0,0.0,-3.0,1.0,-2.0,1.0,-2.0,2.0,-1.0,0.0,0.0,0.0,2.0,-1.0,2.0,-2.0,2.0,-1.0,3.0,0.0,2.0,0.0,3.0,0.0,2.0,1.0,3.0,1.0,2.0,1.0,2.0,2.0,1.0,2.0,1.0,2.0,0.0,3.0,0.0,2.0,0.0,3.0,-1.0,2.0,-1.0,3.0,-1.0,2.0,-2.0,2.0,-2.0,1.0,-2.0,1.0,-3.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,2.0,-1.0,3.0,0.0,2.0,-1.0,2.0,-2.0,1.0,-2.0,2.0,-2.0,1.0,-2.0,0.0,-2.0,0.0,-3.0,-1.0,-2.0,0.0,-2.0,-1.0,-3.0,-2.0,-2.0,-2.0,-1.0,-2.0,-2.0,-2.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,2.0,-2.0,1.0,-2.0,2.0,-1.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,-2.0,2.0,-2.0,2.0,-2.0,2.0,-1.0,3.0,0.0,2.0,0.0,3.0,1.0,2.0,0.0,3.0,1.0,2.0,2.0,1.0,1.0,2.0,2.0,1.0,3.0,0.0,2.0,0.0,2.0,0.0,3.0,-1.0,2.0,-1.0,3.0,-1.0,2.0,-2.0,1.0,-2.0,2.0,-2.0,1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0,-2.0,0.0,-2.0,-1.0,-2.0,-2.0,-2.0,-1.0,-2.0,-2.0,-1.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_24()
		{
			double[] value = {1.0,0.0,1.0,0.0,0.0,-2.0,2.0,-2.0,2.0,-1.0,1.0,-2.0,3.0,-1.0,2.0,0.0,2.0,0.0,3.0,0.0,2.0,1.0,2.0,1.0,2.0,1.0,2.0,2.0,1.0,2.0,1.0,2.0,0.0,2.0,0.0,2.0,0.0,3.0,-1.0,2.0,-1.0,2.0,-1.0,2.0,-1.0,2.0,-2.0,1.0,-2.0,1.0,-3.0,0.0,-2.0,0.0,-2.0,0.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-3.0,-1.0,-2.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,-2.0,0.0,0.0,0.0,0.0,1.0,0.0,3.0,0.0,0.0,-2.0,1.0,-1.0,1.0,-2.0,2.0,-1.0,1.0,-1.0,2.0,-1.0,2.0,0.0,1.0,0.0,2.0,0.0,2.0,1.0,2.0,1.0,1.0,1.0,2.0,1.0,1.0,1.0,0.0,2.0,0.0,2.0,0.0,2.0,0.0,1.0,0.0,2.0,-1.0,2.0,-1.0,1.0,-1.0,2.0,-2.0,1.0,-2.0,0.0,-1.0,0.0,-2.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,0.0,-2.0,2.0,0.0,0.0,0.0,0.0,-3.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,0.0,1.0,0.0,3.0,0.0,3.0,0.0,0.0,-2.0,0.0,-1.0,1.0,-1.0,1.0,-1.0,0.0,-1.0,2.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,1.0,1.0,0.0,1.0,1.0,1.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_25()
		{
			double[] value = {1.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,-1.0,1.0,-1.0,1.0,0.0,1.0,-1.0,1.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,-1.0,-1.0,0.0,-2.0,3.0,-2.0,2.0,0.0,0.0,-2.0,-2.0,-2.0,-2.0,-1.0,-2.0,0.0,-3.0,1.0,0.0,3.0,0.0,3.0,0.0,0.0,1.0,1.0,1.0,0.0,2.0,-2.0,1.0,-3.0,1.0,-1.0,-1.0,0.0,-2.0,3.0,0.0,0.0,-1.0,43.0,10.0,-3.0,-1.0,-2.0,-1.0,-2.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,1.0,-3.0,1.0,-2.0,2.0,-2.0,1.0,-2.0,3.0,-1.0,2.0,-1.0,2.0,0.0,3.0,0.0,2.0,0.0,3.0,1.0,2.0,1.0,2.0,2.0,1.0,1.0,0.0,0.0,-2.0,-2.0,-2.0,-1.0,-2.0,-1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,0.0,-2.0,1.0,-2.0,2.0,-2.0,1.0,-1.0,2.0,-1.0,3.0,0.0,2.0,0.0,2.0,0.0,3.0,0.0,2.0,1.0,2.0,2.0,2.0,1.0,2.0,2.0,2.0,3.0,1.0,2.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,-2.0,0.0,-3.0,-1.0,-2.0,-1.0,-2.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,1.0,-3.0,1.0,-2.0,1.0,-2.0,2.0,-2.0,2.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_26()
		{
			double[] value = {3.0,-1.0,2.0,0.0,3.0,0.0,2.0,0.0,3.0,1.0,2.0,1.0,2.0,2.0,2.0,1.0,1.0,2.0,0.0,0.0,0.0,1.0,1.0,2.0,0.0,2.0,0.0,3.0,0.0,2.0,-1.0,3.0,-1.0,2.0,-2.0,2.0,-1.0,1.0,-3.0,2.0,-2.0,1.0,-2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-3.0,0.0,-2.0,0.0,-3.0,-1.0,-2.0,-1.0,-2.0,-2.0,-2.0,-1.0,-1.0,-2.0,-1.0,-3.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,1.0,-2.0,1.0,-3.0,2.0,-2.0,1.0,-1.0,3.0,-2.0,2.0,-1.0,2.0,0.0,3.0,0.0,2.0,1.0,3.0,0.0,2.0,1.0,2.0,2.0,2.0,2.0,1.0,2.0,1.0,2.0,1.0,0.0,0.0,0.0,0.0,2.0,0.0,3.0,-1.0,2.0,-1.0,3.0,-1.0,2.0,-1.0,2.0,-2.0,2.0,-2.0,1.0,-3.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-3.0,0.0,-2.0,0.0,-2.0,0.0,-2.0,-1.0,-3.0,-1.0,-1.0,-1.0,-2.0,-2.0,-1.0,-2.0,-1.0,-2.0,0.0,-2.0,0.0,-3.0,0.0,-2.0,1.0,-2.0,1.0,-2.0,1.0,-2.0,2.0,-2.0,2.0,-1.0,2.0,-1.0,2.0,0.0,3.0,0.0,2.0,1.0,2.0,0.0,3.0,1.0,2.0,2.0,1.0,1.0,2.0,2.0,1.0,2.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,3.0,0.0,2.0,-1.0,3.0,-1.0,2.0,-1.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_27()
		{
			double[] value = {-2.0,2.0,-2.0,0.0,-1.0,0.0,0.0,-1.0,-1.0,-1.0,-2.0,0.0,-2.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,-1.0,-2.0,0.0,-1.0,-1.0,-2.0,-2.0,-1.0,-1.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,0.0,-2.0,1.0,-2.0,0.0,-2.0,2.0,-1.0,1.0,-1.0,1.0,-1.0,2.0,-1.0,2.0,0.0,2.0,0.0,2.0,0.0,1.0,1.0,2.0,1.0,2.0,1.0,1.0,1.0,1.0,2.0,1.0,1.0,0.0,2.0,0.0,2.0,3.0,0.0,0.0,0.0,0.0,2.0,-1.0,3.0,-1.0,2.0,-2.0,2.0,-1.0,1.0,-1.0,-1.0,-2.0,-2.0,-2.0,-2.0,-1.0,1.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,0.0,-1.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,1.0,2.0,0.0,1.0,1.0,1.0,1.0,0.0,1.0,1.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,3.0,1.0,2.0,0.0,-1.0,2.0,-1.0,3.0,-1.0,0.0,-2.0,-2.0,-2.0,-1.0,1.0,-2.0,1.0,0.0,2.0,2.0,0.0,-2.0,158.0,-6.0,4.0,3.0,-1.0,-1.0,-2.0,0.0,-3.0,0.0,1.0,0.0,1.0,-1.0,1.0,-2.0,1.0,-1.0,1.0,0.0,2.0,4.0,0.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_28()
		{
			double[] value = {0.0,0.0,-1.0,1.0,0.0,0.0,-8.0,9.0,-1.0,-1.0,0.0,-1.0,0.0,-3.0,-1.0,-2.0,2.0,-2.0,1.0,-1.0,0.0,-1.0,0.0,0.0,1.0,-1.0,1.0,0.0,0.0,-2.0,1.0,0.0,1.0,-2.0,1.0,-1.0,1.0,2.0,0.0,0.0,0.0,1.0,-2.0,1.0,0.0,1.0,-1.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,1.0,5.0,-4.0,4.0,-1.0,0.0,-1.0,0.0,-1.0,-2.0,-1.0,-1.0,0.0,-1.0,1.0,-2.0,2.0,-2.0,1.0,-1.0,0.0,0.0,0.0,-2.0,-1.0,0.0,0.0,-1.0,1.0,-1.0,1.0,0.0,1.0,0.0,0.0,-1.0,1.0,-1.0,0.0,-1.0,1.0,-1.0,1.0,-1.0,0.0,0.0,0.0,1.0,-1.0,1.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,2.0,-1.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,1.0,-1.0,0.0,-1.0,2.0,-1.0,1.0,-1.0,2.0,-1.0,0.0,0.0,0.0,0.0,0.0,0.0,-2.0,1.0,-2.0,1.0,-1.0,0.0,-1.0,0.0,0.0,0.0,-2.0,-1.0,0.0,0.0,-1.0,1.0,-2.0,1.0,-1.0,1.0,-1.0,0.0,0.0,1.0,1.0,1.0,-2.0,0.0,-1.0,1.0,-1.0,1.0,-1.0,0.0,0.0,0.0,0.0,-1.0,2.0,-1.0,0.0,0.0,0.0,-1.0,-1.0,0.0,0.0,0.0,1.0,0.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_29()
		{
			double[] value = {0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,1.0,-1.0,1.0,-1.0,1.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,-1.0,1.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,0.0,-2.0,-1.0,-4.0,-1.0,1.0,-3.0,1.0,-3.0,0.0,0.0,1.0,-2.0,1.0,-2.0,1.0,-1.0,5.0,3.0,0.0,0.0,1.0,-2.0,1.0,-2.0,0.0,0.0,0.0,1.0,-1.0,1.0,-1.0,0.0,-5.0,-4.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,4.0,4.0,-1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,2.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,-1.0,0.0,-2.0,0.0,0.0,0.0,-2.0,-5.0,-1.0,-7.0,-1.0,0.0,0.0,1.0,-4.0,1.0,-4.0,1.0,-1.0,0.0,-3.0,0.0,-1.0,-5.0,-6.0,7.0,3.0,0.0,0.0,8.0,3.0,1.0,-2.0,1.0,-3.0,0.0,0.0,0.0,1.0,-1.0,1.0,-8.0,-5.0,0.0,1.0,0.0,1.0,-1.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,7.0,5.0,-1.0,0.0,0.0,2.0,0.0,0.0,0.0,1.0,-1.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_30()
		{
			double[] value = {0.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,4.0,2.0,0.0,0.0,-1.0,1.0,0.0,1.0,-1.0,1.0,-1.0,2.0,0.0,1.0,-1.0,1.0,0.0,0.0,0.0,0.0,-5.0,0.0,0.0,-2.0,-8.0,0.0,-6.0,0.0,1.0,-5.0,0.0,-1.0,2.0,-4.0,1.0,-5.0,0.0,0.0,1.0,-5.0,0.0,0.0,-1.0,-1.0,1.0,-4.0,1.0,0.0,1.0,0.0,1.0,-4.0,8.0,3.0,0.0,-3.0,0.0,0.0,0.0,0.0,-7.0,-4.0,-1.0,2.0,-1.0,1.0,0.0,1.0,-1.0,1.0,0.0,3.0,0.0,1.0,0.0,1.0,0.0,1.0,7.0,4.0,0.0,2.0,0.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,-1.0,1.0,0.0,2.0,7.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,-2.0,2.0,0.0,1.0,0.0,1.0,-1.0,0.0,-1.0,2.0,0.0,0.0,-8.0,1.0,0.0,0.0,-8.0,1.0,-1.0,-1.0,2.0,-5.0,1.0,-4.0,1.0,-1.0,1.0,-5.0,1.0,-4.0,0.0,-1.0,1.0,-4.0,-3.0,-3.0,0.0,-1.0,1.0,-5.0,0.0,0.0,1.0,-4.0,5.0,2.0,2.0,-4.0,0.0,0.0,-8.0,-5.0,0.0,1.0,-2.0,2.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,3.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,3.0,7.0,5.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_31()
		{
			double[] value = {0.0,1.0,0.0,3.0,0.0,1.0,5.0,2.0,0.0,2.0,-1.0,1.0,-1.0,2.0,0.0,0.0,-1.0,2.0,0.0,1.0,-2.0,2.0,-7.0,1.0,-1.0,0.0,-2.0,0.0,-1.0,-3.0,0.0,0.0,1.0,-5.0,1.0,-5.0,0.0,-1.0,1.0,-4.0,1.0,-5.0,0.0,-1.0,0.0,-2.0,0.0,-5.0,1.0,0.0,0.0,-5.0,1.0,0.0,1.0,-5.0,0.0,-5.0,-5.0,-2.0,0.0,0.0,0.0,1.0,-3.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,-1.0,0.0,0.0,1.0,0.0,1.0,0.0,1.0,-3.0,-4.0,4.0,6.0,5.0,7.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,3.0,0.0,1.0,0.0,2.0,7.0,5.0,-1.0,2.0,-1.0,2.0,0.0,1.0,-1.0,1.0,0.0,1.0,-6.0,4.0,-1.0,-2.0,-1.0,-4.0,0.0,0.0,0.0,0.0,1.0,-5.0,1.0,-4.0,0.0,-1.0,1.0,-4.0,0.0,-5.0,-2.0,-4.0,1.0,0.0,0.0,-5.0,0.0,0.0,0.0,-4.0,0.0,-1.0,0.0,-4.0,-1.0,-2.0,0.0,-3.0,0.0,0.0,0.0,1.0,-2.0,0.0,-2.0,0.0,0.0,0.0,-1.0,1.0,0.0,0.0,-1.0,1.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,2.0,3.0,6.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_32()
		{
			double[] value = {0.0,1.0,0.0,1.0,0.0,1.0,5.0,8.0,0.0,2.0,-1.0,1.0,0.0,1.0,0.0,1.0,-3.0,0.0,0.0,0.0,0.0,-1.0,0.0,-4.0,1.0,-4.0,0.0,-1.0,0.0,-4.0,-1.0,-5.0,0.0,-4.0,1.0,0.0,0.0,-4.0,0.0,0.0,0.0,-4.0,0.0,0.0,-1.0,-2.0,0.0,-2.0,0.0,-3.0,0.0,0.0,-2.0,1.0,-2.0,1.0,0.0,0.0,-1.0,2.0,0.0,0.0,0.0,2.0,0.0,3.0,0.0,0.0,1.0,0.0,0.0,3.0,0.0,1.0,0.0,2.0,0.0,1.0,1.0,3.0,0.0,1.0,0.0,2.0,1.0,2.0,0.0,3.0,0.0,1.0,1.0,2.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,-4.0,0.0,-4.0,0.0,0.0,-1.0,-5.0,1.0,-3.0,0.0,-2.0,0.0,-2.0,0.0,-2.0,0.0,-1.0,0.0,-2.0,-1.0,-1.0,0.0,-2.0,0.0,-2.0,-2.0,1.0,0.0,0.0,-1.0,3.0,0.0,3.0,0.0,3.0,0.0,0.0,1.0,5.0,0.0,2.0,1.0,5.0,0.0,2.0,0.0,0.0,0.0,-3.0,0.0,-2.0,0.0,-4.0,0.0,-2.0,0.0,-3.0,0.0,-3.0,-1.0,-2.0,0.0,0.0,0.0,5.0,0.0,4.0,0.0,3.0,0.0,4.0,0.0,-11.0,0.0,8.0,-1.0,-12.0,0.0,0.0,0.0,-1.0,0.0,0.0,1.0,0.0,3.0,6.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,0.0,-4.0,-5.0,0.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_33()
		{
			double[] value = {0.0,-3.0,0.0,0.0,0.0,0.0,0.0,-2.0,1.0,2.0,2.0,7.0,0.0,2.0,0.0,1.0,0.0,-3.0,0.0,-2.0,0.0,-2.0,-1.0,0.0,-1.0,-6.0,0.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,1.0,3.0,5.0,6.0,6.0,0.0,3.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,0.0,-6.0,-6.0,-4.0,-4.0,0.0,-3.0,0.0,0.0,1.0,3.0,0.0,-3.0,1.0,0.0,0.0,9.0,1.0,2.0,0.0,-1.0,1.0,2.0,1.0,0.0,0.0,-4.0,0.0,-4.0,0.0,0.0,0.0,-4.0,-2.0,-2.0,0.0,-1.0,0.0,0.0,0.0,-3.0,0.0,-2.0,0.0,-2.0,-2.0,1.0,0.0,0.0,0.0,0.0,0.0,2.0,4.0,5.0,6.0,6.0,7.0,6.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,1.0,0.0,0.0,-9.0,-6.0,-6.0,-6.0,-2.0,-3.0,0.0,0.0,0.0,2.0,0.0,0.0,1.0,5.0,0.0,3.0,2.0,5.0,0.0,-3.0,1.0,5.0,1.0,-4.0,1.0,-1.0,0.0,-4.0,0.0,-5.0,0.0,0.0,0.0,-5.0,0.0,0.0,-1.0,-3.0,-1.0,-4.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,0.0,-3.0,0.0,0.0,-2.0,1.0,-1.0,1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,3.0,4.0,6.0,6.0,9.0,6.0,6.0,4.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_34()
		{
			double[] value = {0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,-1.0,1.0,-1.0,1.0,-6.0,-2.0,-7.0,-6.0,-6.0,-7.0,-2.0,-2.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,0.0,3.0,2.0,6.0,1.0,6.0,0.0,0.0,1.0,4.0,1.0,-5.0,1.0,-4.0,0.0,-1.0,1.0,-4.0,1.0,-5.0,1.0,0.0,0.0,-5.0,0.0,0.0,0.0,-5.0,-3.0,-3.0,0.0,-1.0,-1.0,-2.0,0.0,-4.0,0.0,-3.0,0.0,0.0,0.0,1.0,-2.0,0.0,-1.0,0.0,0.0,0.0,1.0,3.0,0.0,1.0,0.0,1.0,1.0,2.0,6.0,5.0,8.0,6.0,8.0,4.0,6.0,5.0,0.0,1.0,0.0,1.0,-1.0,0.0,0.0,2.0,0.0,0.0,0.0,1.0,-1.0,1.0,0.0,1.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,1.0,-1.0,0.0,-7.0,-1.0,-6.0,-2.0,-8.0,-6.0,-6.0,-6.0,0.0,1.0,0.0,1.0,0.0,2.0,0.0,1.0,1.0,2.0,0.0,2.0,1.0,7.0,1.0,4.0,0.0,0.0,1.0,3.0,0.0,0.0,1.0,-5.0,1.0,-5.0,0.0,-1.0,1.0,-4.0,1.0,-5.0,1.0,-1.0,1.0,-4.0,0.0,-1.0,0.0,-5.0,0.0,0.0,0.0,-2.0,0.0,-5.0,-4.0,-3.0,0.0,-4.0,0.0,0.0,0.0,1.0,-2.0,1.0,5.0,4.0,0.0,1.0,0.0,1.0,0.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_35()
		{
			double[] value = {8.0,6.0,8.0,5.0,7.0,6.0,5.0,4.0,-1.0,1.0,0.0,1.0,-1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,0.0,-5.0,-1.0,-7.0,0.0,-6.0,-3.0,-8.0,-4.0,0.0,1.0,0.0,2.0,-1.0,1.0,0.0,1.0,0.0,1.0,0.0,9.0,1.0,2.0,0.0,0.0,0.0,-1.0,2.0,-5.0,1.0,-4.0,1.0,-1.0,1.0,-5.0,1.0,-4.0,0.0,-1.0,2.0,-4.0,0.0,-1.0,1.0,-4.0,1.0,-1.0,0.0,-5.0,-4.0,-3.0,0.0,-6.0,0.0,0.0,0.0,1.0,7.0,6.0,-1.0,2.0,0.0,1.0,0.0,1.0,8.0,5.0,7.0,6.0,5.0,5.0,0.0,2.0,0.0,0.0,-1.0,1.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,1.0,-1.0,0.0,-1.0,-1.0,-4.0,-1.0,-8.0,0.0,-6.0,-1.0,-1.0,2.0,0.0,1.0,-1.0,1.0,0.0,1.0,-3.0,5.0,0.0,0.0,0.0,0.0,2.0,-5.0,1.0,-5.0,0.0,-1.0,2.0,-4.0,1.0,-5.0,0.0,0.0,2.0,-5.0,0.0,0.0,1.0,-5.0,0.0,0.0,1.0,-5.0,2.0,-4.0,0.0,0.0,6.0,5.0,0.0,1.0,0.0,2.0,0.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_36()
		{
			double[] value = {7.0,6.0,5.0,5.0,1.0,2.0,1.0,2.0,-1.0,0.0,0.0,1.0,-1.0,1.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,0.0,0.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,-1.0,1.0,0.0,1.0,-1.0,1.0,-1.0,0.0,-1.0,0.0,-1.0,-1.0,-5.0,0.0,-7.0,0.0,0.0,0.0,-1.0,2.0,0.0,1.0,-1.0,1.0,0.0,0.0,0.0,0.0,1.0,-4.0,2.0,-4.0,0.0,0.0,1.0,-4.0,1.0,-4.0,1.0,-1.0,1.0,-3.0,0.0,-1.0,1.0,-3.0,0.0,-1.0,2.0,-4.0,1.0,-3.0,7.0,6.0,0.0,0.0,0.0,1.0,0.0,2.0,5.0,6.0,1.0,2.0,1.0,1.0,0.0,2.0,0.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,1.0,0.0,1.0,-1.0,1.0,0.0,1.0,-1.0,0.0,-1.0,2.0,-1.0,1.0,-1.0,2.0,-1.0,-2.0,-1.0,0.0,-1.0,-1.0,-5.0,0.0,0.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,-3.0,2.0,-3.0,0.0,-1.0,1.0,-3.0,1.0,-3.0,0.0,0.0,1.0,-2.0,1.0,-2.0,1.0,-2.0,0.0,-1.0,1.0,-1.0,5.0,4.0,2.0,-2.0,0.0,0.0,0.0,1.0,1.0,2.0,1.0,2.0,2.0,2.0,1.0,4.0,-1.0,2.0,-4.0,5.0,-4.0,4.0,-1.0,0.0,-3.0,-2.0,-1.0,-1.0,-1.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_37()
		{
			double[] value = {0.0,0.0,0.0,-1.0,1.0,-2.0,1.0,-2.0,0.0,-1.0,1.0,-2.0,1.0,-2.0,1.0,-1.0,1.0,-1.0,0.0,-1.0,1.0,-1.0,0.0,0.0,1.0,0.0,1.0,-1.0,2.0,-1.0,0.0,0.0,1.0,1.0,2.0,2.0,1.0,5.0,-1.0,1.0,-8.0,10.0,-2.0,0.0,-2.0,-2.0,0.0,0.0,-1.0,-1.0,0.0,0.0,0.0,-1.0,1.0,-2.0,1.0,-2.0,1.0,0.0,0.0,-2.0,1.0,-2.0,1.0,-1.0,1.0,-1.0,0.0,0.0,1.0,-1.0,1.0,0.0,0.0,-1.0,1.0,-1.0,2.0,-1.0,1.0,1.0,0.0,0.0,1.0,4.0,0.0,2.0,-9.0,9.0,-2.0,0.0,-1.0,-1.0,0.0,-1.0,0.0,0.0,1.0,-2.0,1.0,-1.0,0.0,-1.0,1.0,-2.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,0.0,0.0,1.0,0.0,0.0,-2.0,1.0,0.0,1.0,-2.0,1.0,-1.0,0.0,1.0,1.0,5.0,-9.0,9.0,-2.0,-1.0,1.0,-2.0,0.0,0.0,1.0,-1.0,1.0,-1.0,1.0,-1.0,1.0,-2.0,0.0,-1.0,1.0,-1.0,1.0,0.0,1.0,-1.0,0.0,-1.0,0.0,0.0,1.0,2.0,-6.0,7.0,-1.0,-2.0,1.0,0.0,1.0,-1.0,0.0,-1.0,0.0,0.0,1.0,-3.0,-68.0,-26.0,-1.0,-2.0,3.0,-1.0,1.0,-1.0,1.0,-1.0,0.0,0.0,0.0,1.0,-1.0,1.0,0.0,4.0,-1.0,0.0,-2.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_38()
		{
			double[] value = {-1.0,-1.0,-1.0,-1.0,0.0,-2.0,0.0,-3.0,1.0,0.0,1.0,-1.0,6.0,5.0,0.0,0.0,-3.0,4.0,1.0,1.0,1.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,-1.0,2.0,-2.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,-1.0,0.0,0.0,-1.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,0.0,-1.0,0.0,0.0,-1.0,-1.0,-2.0,-1.0,0.0,-1.0,0.0,-1.0,2.0,-3.0,1.0,0.0,0.0,0.0,1.0,0.0,2.0,2.0,0.0,5.0,0.0,1.0,0.0,0.0,-1.0,2.0,1.0,0.0,0.0,1.0,0.0,1.0,1.0,-1.0,0.0,1.0,1.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,-2.0,-1.0,-2.0,-1.0,0.0,0.0,-1.0,-1.0,0.0,0.0,-1.0,0.0,-1.0,0.0,0.0,-1.0,0.0,-1.0,0.0,-1.0,-1.0,-1.0,0.0,0.0,0.0,0.0,-1.0,-1.0,-1.0,-1.0,1.0,-2.0,0.0,0.0,0.0,1.0,0.0,0.0,2.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,1.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,2.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,1.0,0.0,1.0,1.0,0.0,0.0,-2.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,-2.0,-2.0,-1.0,-1.0,-1.0,0.0,-1.0,0.0,0.0,0.0,-1.0,0.0,-1.0,-1.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_39()
		{
			double[] value = {-2.0,-2.0,0.0,-1.0,1.0,-1.0,0.0,0.0,0.0,-1.0,-1.0,-1.0,-1.0,-1.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,1.0,-2.0,5.0,0.0,1.0,1.0,2.0,0.0,0.0,1.0,0.0,3.0,-6.0,1.0,0.0,1.0,1.0,0.0,0.0,-1.0,0.0,-2.0,-1.0,-1.0,-1.0,-1.0,0.0,-3.0,4.0,-2.0,-1.0,0.0,-1.0,-2.0,-2.0,0.0,0.0,-2.0,-2.0,-1.0,-2.0,0.0,-1.0,5.0,-2.0,-1.0,-2.0,1.0,0.0,-1.0,-1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,1.0,2.0,1.0,1.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,-3.0,5.0,0.0,0.0,0.0,1.0,0.0,1.0,-4.0,7.0,0.0,0.0,1.0,1.0,1.0,3.0,0.0,0.0,0.0,1.0,1.0,0.0,6.0,-8.0,1.0,1.0,0.0,0.0,-1.0,0.0,-2.0,-2.0,-2.0,-1.0,-5.0,7.0,-5.0,4.0,4.0,-6.0,-1.0,-2.0,-1.0,-1.0,-2.0,-3.0,0.0,0.0,-2.0,-4.0,-2.0,-3.0,-1.0,-1.0,-1.0,-3.0,6.0,-1.0,-2.0,-3.0,7.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_40()
		{
			double[] value = {0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,2.0,1.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,0.0,-4.0,4.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,-4.0,6.0,1.0,0.0,0.0,1.0,0.0,2.0,-5.0,6.0,0.0,1.0,1.0,1.0,0.0,1.0,1.0,3.0,0.0,1.0,1.0,0.0,1.0,1.0,2.0,1.0,4.0,-7.0,0.0,0.0,0.0,0.0,-3.0,-2.0,-5.0,5.0,-2.0,-3.0,-1.0,1.0,-1.0,-1.0,-1.0,-3.0,1.0,-2.0,0.0,0.0,-3.0,-4.0,0.0,0.0,-2.0,-5.0,-2.0,-4.0,0.0,-1.0,-2.0,-4.0,-1.0,-4.0,5.0,0.0,0.0,0.0,6.0,0.0,0.0,0.0,2.0,1.0,1.0,1.0,0.0,0.0,1.0,1.0,2.0,2.0,0.0,1.0,0.0,0.0,0.0,1.0,-5.0,2.0,2.0,2.0,0.0,1.0,1.0,1.0,0.0,1.0,0.0,1.0,-4.0,6.0,0.0,1.0,0.0,1.0,0.0,0.0,-5.0,8.0,0.0,3.0,0.0,0.0,1.0,1.0,0.0,1.0,1.0,3.0,1.0,0.0,1.0,1.0,0.0,1.0,3.0,1.0,0.0,0.0,4.0,-8.0,0.0,0.0,-4.0,-2.0,-3.0,4.0,-2.0,-4.0,-1.0,0.0,-1.0,-4.0,0.0,-1.0,2.0,-4.0,-2.0,-3.0,-1.0,-1.0,-2.0,-4.0,-1.0,-5.0,0.0,-1.0,-2.0,-4.0,-2.0,-5.0,0.0,0.0,2.0,0.0,0.0,0.0,6.0,0.0,2.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_41()
		{
			double[] value = {0.0,1.0,1.0,1.0,0.0,1.0,1.0,1.0,1.0,1.0,0.0,2.0,-3.0,4.0,0.0,1.0,1.0,2.0,0.0,1.0,0.0,1.0,0.0,1.0,-5.0,8.0,0.0,2.0,0.0,1.0,0.0,1.0,-5.0,13.0,2.0,-6.0,0.0,1.0,1.0,2.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,2.0,1.0,0.0,1.0,1.0,0.0,1.0,5.0,0.0,0.0,0.0,0.0,0.0,1.0,-5.0,-3.0,-4.0,-2.0,-4.0,0.0,0.0,-2.0,-4.0,-1.0,0.0,-1.0,-4.0,0.0,-3.0,-1.0,0.0,-2.0,-4.0,-1.0,-5.0,-1.0,0.0,0.0,-6.0,-1.0,-5.0,0.0,0.0,1.0,0.0,1.0,-2.0,5.0,4.0,1.0,0.0,0.0,2.0,1.0,1.0,0.0,2.0,0.0,1.0,-5.0,9.0,0.0,1.0,1.0,1.0,0.0,3.0,1.0,1.0,0.0,1.0,-4.0,7.0,0.0,1.0,0.0,2.0,0.0,1.0,-1.0,6.0,1.0,2.0,0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,1.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,2.0,-1.0,1.0,0.0,0.0,0.0,0.0,0.0,-1.0,-3.0,0.0,-2.0,-2.0,-4.0,-1.0,-1.0,-1.0,-3.0,-1.0,-1.0,-1.0,-4.0,0.0,0.0,1.0,-4.0,-3.0,-4.0,-1.0,-4.0,-1.0,0.0,-1.0,-5.0,0.0,-4.0,0.0,0.0,1.0,0.0,2.0,4.0,0.0,2.0,0.0,1.0,0.0,1.0,0.0,2.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_42()
		{
			double[] value = {-3.0,9.0,1.0,1.0,0.0,1.0,1.0,0.0,0.0,3.0,0.0,0.0,-1.0,6.0,0.0,1.0,0.0,1.0,1.0,2.0,0.0,1.0,0.0,0.0,1.0,2.0,1.0,2.0,0.0,0.0,2.0,1.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,0.0,-2.0,-3.0,-1.0,-2.0,1.0,-2.0,-1.0,-1.0,-1.0,-3.0,-1.0,0.0,-1.0,-4.0,0.0,0.0,-2.0,-3.0,0.0,-5.0,-1.0,-4.0,-1.0,0.0,-1.0,-4.0,0.0,-4.0,0.0,0.0,0.0,0.0,0.0,7.0,0.0,3.0,0.0,2.0,0.0,1.0,1.0,3.0,0.0,2.0,0.0,1.0,0.0,2.0,1.0,2.0,0.0,5.0,0.0,0.0,2.0,3.0,1.0,2.0,2.0,2.0,1.0,0.0,1.0,0.0,-2.0,-3.0,0.0,-2.0,0.0,-1.0,-1.0,-2.0,-1.0,-1.0,-1.0,-2.0,0.0,-1.0,-1.0,-2.0,-1.0,-2.0,0.0,-5.0,-1.0,0.0,-1.0,-4.0,-1.0,-2.0,0.0,0.0,0.0,5.0,1.0,3.0,1.0,6.0,0.0,2.0,0.0,0.0,2.0,4.0,2.0,3.0,0.0,0.0,0.0,-3.0,-2.0,-3.0,-1.0,-2.0,0.0,-2.0,-1.0,-4.0,-1.0,-2.0,0.0,-1.0,0.0,3.0,1.0,4.0,0.0,-2.0,2.0,9.0,0.0,2.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,-8.0,0.0,-1.0,-1.0,-2.0,0.0,-1.0,0.0,2.0,0.0,2.0,1.0,2.0,1.0,6.0,-1.0,0.0,0.0,0.0,-1.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_43()
		{
			double[] value = {0.0,0.0,-1.0,-2.0,0.0,0.0,0.0,-1.0,0.0,-2.0,0.0,-1.0,2.0,-5.0,1.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,0.0,1.0,-1.0,7.0,1.0,1.0,0.0,1.0,0.0,0.0,2.0,1.0,1.0,0.0,1.0,0.0,-2.0,-3.0,-1.0,-2.0,0.0,-2.0,0.0,-1.0,0.0,-1.0,0.0,-2.0,-1.0,-4.0,0.0,0.0,-2.0,-3.0,-1.0,-2.0,-1.0,0.0,0.0,2.0,0.0,-1.0,0.0,3.0,2.0,8.0,-1.0,0.0,-1.0,-3.0,1.0,3.0,0.0,0.0,0.0,-3.0,2.0,-6.0,4.0,-6.0,1.0,1.0,0.0,0.0,0.0,2.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,3.0,-4.0,7.0,0.0,1.0,0.0,6.0,1.0,1.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,0.0,-2.0,-3.0,-1.0,-2.0,0.0,-1.0,0.0,-2.0,0.0,-3.0,0.0,-3.0,-1.0,-1.0,-1.0,-4.0,-1.0,0.0,-2.0,-4.0,-1.0,-4.0,-1.0,0.0,-1.0,-3.0,0.0,5.0,-1.0,-2.0,1.0,6.0,0.0,3.0,1.0,5.0,0.0,0.0,0.0,1.0,1.0,-1.0,1.0,-4.0,4.0,-8.0,7.0,-8.0,0.0,1.0,1.0,1.0,0.0,1.0,1.0,2.0,0.0,1.0,0.0,1.0,0.0,0.0,0.0,2.0,0.0,1.0,-5.0,8.0,0.0,1.0,-4.0,8.0,-1.0,5.0,1.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,2.0,-1.0,1.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_44()
		{
			double[] value = {0.0,0.0,0.0,0.0,-2.0,-3.0,-1.0,-3.0,0.0,-3.0,0.0,-1.0,2.0,-4.0,-2.0,-4.0,-1.0,0.0,-1.0,-4.0,-1.0,0.0,-3.0,-4.0,-1.0,-4.0,-1.0,0.0,-1.0,-5.0,-1.0,-4.0,-1.0,6.0,0.0,0.0,0.0,7.0,0.0,5.0,1.0,3.0,1.0,0.0,0.0,2.0,0.0,1.0,0.0,1.0,2.0,-5.0,4.0,-8.0,6.0,-8.0,4.0,-4.0,2.0,2.0,0.0,1.0,1.0,1.0,0.0,1.0,1.0,1.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,2.0,0.0,1.0,0.0,0.0,-5.0,7.0,0.0,1.0,-6.0,8.0,-2.0,7.0,0.0,2.0,1.0,0.0,1.0,1.0,0.0,1.0,4.0,0.0,0.0,0.0,0.0,0.0,-2.0,-4.0,1.0,-5.0,-1.0,-4.0,0.0,-2.0,-1.0,0.0,-1.0,-4.0,-1.0,-1.0,-2.0,-4.0,-1.0,0.0,-2.0,-4.0,-1.0,-5.0,-1.0,0.0,0.0,-6.0,-2.0,-4.0,0.0,0.0,0.0,5.0,0.0,0.0,-1.0,5.0,0.0,7.0,0.0,3.0,0.0,2.0,0.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,4.0,-9.0,7.0,-8.0,4.0,-4.0,6.0,-2.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,-4.0,7.0,0.0,3.0,-6.0,7.0,-5.0,8.0,1.0,0.0,1.0,1.0,0.0,1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_45()
		{
			double[] value = {2.0,1.0,0.0,0.0,0.0,0.0,-1.0,-6.0,2.0,-5.0,-2.0,-3.0,-1.0,-1.0,-2.0,-3.0,0.0,-1.0,-2.0,-3.0,-1.0,-1.0,-2.0,-4.0,-1.0,-5.0,0.0,-1.0,-2.0,-4.0,-2.0,-4.0,0.0,0.0,0.0,0.0,0.0,3.0,1.0,9.0,0.0,2.0,1.0,1.0,0.0,1.0,0.0,2.0,1.0,0.0,6.0,-9.0,4.0,-4.0,6.0,-1.0,5.0,-2.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,-3.0,7.0,0.0,0.0,-5.0,8.0,-5.0,8.0,1.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,-3.0,-4.0,-2.0,-4.0,0.0,0.0,-2.0,-4.0,0.0,0.0,-3.0,-4.0,0.0,0.0,-2.0,-5.0,-2.0,-4.0,0.0,-1.0,-2.0,-4.0,-1.0,-4.0,0.0,0.0,0.0,0.0,4.0,5.0,1.0,0.0,0.0,2.0,1.0,1.0,1.0,1.0,3.0,-4.0,7.0,-1.0,5.0,-3.0,1.0,0.0,1.0,1.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,3.0,0.0,0.0,-3.0,7.0,-5.0,8.0,1.0,1.0,1.0,1.0,0.0,0.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_46()
		{
			double[] value = {0.0,0.0,-3.0,-3.0,-1.0,-3.0,-1.0,-1.0,-1.0,-2.0,-1.0,-1.0,-2.0,-3.0,0.0,0.0,-2.0,-4.0,-2.0,-3.0,-1.0,-1.0,-2.0,-3.0,-1.0,-3.0,0.0,0.0,1.0,0.0,2.0,2.0,0.0,1.0,1.0,1.0,0.0,0.0,6.0,-2.0,5.0,-2.0,1.0,-1.0,2.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,2.0,0.0,0.0,0.0,2.0,-2.0,7.0,1.0,1.0,0.0,0.0,-1.0,0.0,-2.0,-2.0,-2.0,-2.0,0.0,-1.0,-2.0,-1.0,0.0,-1.0,-2.0,-2.0,0.0,0.0,-2.0,-2.0,-2.0,-2.0,0.0,-1.0,-2.0,-2.0,-2.0,-2.0,0.0,0.0,0.0,0.0,2.0,1.0,1.0,0.0,0.0,0.0,5.0,-2.0,2.0,-1.0,1.0,-1.0,1.0,0.0,2.0,1.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,0.0,0.0,1.0,1.0,1.0,0.0,0.0,0.0,2.0,0.0,1.0,0.0,2.0,0.0,2.0,0.0,0.0,-1.0,0.0,-2.0,-1.0,-1.0,-2.0,-1.0,0.0,0.0,-2.0,-1.0,0.0,-1.0,-1.0,0.0,0.0,-2.0,-2.0,-1.0,-1.0,0.0,0.0,-2.0,-2.0,-1.0,-1.0,0.0,-1.0};
			return value;
		}
		private double[] getTextureCoordinate_7_44_point_47()
		{
			double[] value = {0.0,0.0,2.0,0.0,1.0,-1.0,2.0,-1.0,3.0,-2.0,1.0,0.0,3.0,2.0,4.0,3.0,0.0,1.0,-1.0,5.0,0.0,0.0,-1.0,3.0,-1.0,1.0,0.0,0.0,-2.0,-2.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,0.0,-1.0,-1.0,0.0,0.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,-1.0,-2.0,0.0,0.0,1.0,-1.0,2.0,-1.0,0.0,0.0,3.0,-2.0,1.0,0.0,7.0,5.0,0.0,2.0,-1.0,4.0,-1.0,2.0,-2.0,-1.0,-2.0,-1.0,0.0,0.0,-1.0,-1.0,0.0,-1.0,-1.0,0.0,0.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,0.0,-1.0,0.0,0.0,1.0,-1.0,2.0,-2.0,1.0,1.0,7.0,5.0,0.0,1.0,0.0,4.0,-1.0,1.0,-2.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,-1.0,0.0,0.0,-1.0,-1.0,-1.0,0.0,-1.0,-1.0,-1.0,-1.0,0.0,0.0,-1.0,-1.0,0.0,0.0,0.0,-1.0,2.0,-2.0,7.0,6.0,0.0,4.0,-2.0,-1.0,0.0,0.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,0.0,-1.0,0.0,0.0,0.0,-1.0,5.0,3.0,-4.0,0.0,2.0,2.0,0.3825,0.252};
			return value;
		}

		/** Large attribute array: fieldValue value field, scene-graph level=6, element #39, 14266 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getfieldValue_code_6_39_value()
		{
			MFInt32 fieldValue_code_6_39_value = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getfieldValue_code_6_39_value_1()))
				.append(new MFInt32(getfieldValue_code_6_39_value_2()))
				.append(new MFInt32(getfieldValue_code_6_39_value_3()))
				.append(new MFInt32(getfieldValue_code_6_39_value_4()))
				.append(new MFInt32(getfieldValue_code_6_39_value_5()))
				.append(new MFInt32(getfieldValue_code_6_39_value_6()))
				.append(new MFInt32(getfieldValue_code_6_39_value_7()))
				.append(new MFInt32(getfieldValue_code_6_39_value_8()))
				.append(new MFInt32(getfieldValue_code_6_39_value_9()))
				.append(new MFInt32(getfieldValue_code_6_39_value_10()))
				.append(new MFInt32(getfieldValue_code_6_39_value_11()))
				.append(new MFInt32(getfieldValue_code_6_39_value_12()))
				.append(new MFInt32(getfieldValue_code_6_39_value_13()))
				.append(new MFInt32(getfieldValue_code_6_39_value_14()))
				.append(new MFInt32(getfieldValue_code_6_39_value_15()));
			return fieldValue_code_6_39_value;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=7, element #42, 14055 total numbers made up of 4685 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_7_42_point()
		{
			MFVec3f Coordinate_7_42_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_7_42_point_1()))
				.append(new MFVec3f(getCoordinate_7_42_point_2()))
				.append(new MFVec3f(getCoordinate_7_42_point_3()))
				.append(new MFVec3f(getCoordinate_7_42_point_4()))
				.append(new MFVec3f(getCoordinate_7_42_point_5()))
				.append(new MFVec3f(getCoordinate_7_42_point_6()))
				.append(new MFVec3f(getCoordinate_7_42_point_7()))
				.append(new MFVec3f(getCoordinate_7_42_point_8()))
				.append(new MFVec3f(getCoordinate_7_42_point_9()))
				.append(new MFVec3f(getCoordinate_7_42_point_10()))
				.append(new MFVec3f(getCoordinate_7_42_point_11()))
				.append(new MFVec3f(getCoordinate_7_42_point_12()))
				.append(new MFVec3f(getCoordinate_7_42_point_13()))
				.append(new MFVec3f(getCoordinate_7_42_point_14()))
				.append(new MFVec3f(getCoordinate_7_42_point_15()))
				.append(new MFVec3f(getCoordinate_7_42_point_16()))
				.append(new MFVec3f(getCoordinate_7_42_point_17()))
				.append(new MFVec3f(getCoordinate_7_42_point_18()))
				.append(new MFVec3f(getCoordinate_7_42_point_19()))
				.append(new MFVec3f(getCoordinate_7_42_point_20()))
				.append(new MFVec3f(getCoordinate_7_42_point_21()))
				.append(new MFVec3f(getCoordinate_7_42_point_22()))
				.append(new MFVec3f(getCoordinate_7_42_point_23()))
				.append(new MFVec3f(getCoordinate_7_42_point_24()))
				.append(new MFVec3f(getCoordinate_7_42_point_25()))
				.append(new MFVec3f(getCoordinate_7_42_point_26()))
				.append(new MFVec3f(getCoordinate_7_42_point_27()))
				.append(new MFVec3f(getCoordinate_7_42_point_28()))
				.append(new MFVec3f(getCoordinate_7_42_point_29()))
				.append(new MFVec3f(getCoordinate_7_42_point_30()))
				.append(new MFVec3f(getCoordinate_7_42_point_31()))
				.append(new MFVec3f(getCoordinate_7_42_point_32()))
				.append(new MFVec3f(getCoordinate_7_42_point_33()))
				.append(new MFVec3f(getCoordinate_7_42_point_34()))
				.append(new MFVec3f(getCoordinate_7_42_point_35()))
				.append(new MFVec3f(getCoordinate_7_42_point_36()))
				.append(new MFVec3f(getCoordinate_7_42_point_37()))
				.append(new MFVec3f(getCoordinate_7_42_point_38()))
				.append(new MFVec3f(getCoordinate_7_42_point_39()))
				.append(new MFVec3f(getCoordinate_7_42_point_40()))
				.append(new MFVec3f(getCoordinate_7_42_point_41()))
				.append(new MFVec3f(getCoordinate_7_42_point_42()))
				.append(new MFVec3f(getCoordinate_7_42_point_43()))
				.append(new MFVec3f(getCoordinate_7_42_point_44()))
				.append(new MFVec3f(getCoordinate_7_42_point_45()))
				.append(new MFVec3f(getCoordinate_7_42_point_46()))
				.append(new MFVec3f(getCoordinate_7_42_point_47()));
			return Coordinate_7_42_point;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=7, element #44, 9370 total numbers made up of 4685 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_7_44_point()
		{
			MFVec2f TextureCoordinate_7_44_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_7_44_point_1()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_2()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_3()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_4()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_5()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_6()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_7()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_8()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_9()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_10()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_11()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_12()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_13()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_14()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_15()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_16()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_17()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_18()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_19()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_20()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_21()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_22()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_23()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_24()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_25()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_26()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_27()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_28()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_29()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_30()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_31()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_32()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_33()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_34()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_35()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_36()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_37()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_38()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_39()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_40()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_41()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_42()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_43()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_44()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_45()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_46()))
				.append(new MFVec2f(getTextureCoordinate_7_44_point_47()));
			return TextureCoordinate_7_44_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return FishCoded model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new FishCoded().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ExperimentalBinaryCompression.FishCoded\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ExperimentalBinaryCompression.FishCoded self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ExperimentalBinaryCompression/FishCoded_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ExperimentalBinaryCompression/FishCoded_JavaExport.x3d"; 
                String filenameX3DV = "ExperimentalBinaryCompression/FishCoded_JavaExport.x3dv"; 
                String filenameJSON = "ExperimentalBinaryCompression/FishCoded_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
