####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Fish.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.0',
  head=head(
    children=[
    meta(content='Fish.x3d',name='title'),
    meta(content='Simple fish example used for encoding and compression comparisons.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='X3D-Edit VRML importer',name='translator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='26 September 2002',name='created'),
    meta(content='28 April 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='http://www.cs.unc.edu/~isenburg/ac/models',name='reference'),
    meta(content='http://www.cs.unc.edu/~isenburg/research/papers/is-bcraf-03.pdf',name='reference'),
    meta(content='isenburg/is-bcraf-03.pdf',name='reference'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Fish.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='Fish.x3d'),
    Viewpoint(description='1M view',position=(0,0,1)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(rotation=(0,1,0,1.57),scale=(0.025,0.025,0.025),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1,1,1)),
          #  modulateTextureWithDiffuse=true by retaining Material and diffuseColor 
          texture=ImageTexture(url=["fish.jpg","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/fish.jpg"])),
        geometry=IndexedFaceSet(coordIndex=[7,6,209,204,-1,4,217,210,5,-1,2,223,219,3,-1,203,403,237,8,-1,131,11,10,130,-1,130,10,9,129,-1,129,9,254,341,-1,11,131,12,-1,161,154,153,160,-1,162,168,154,161,-1,168,162,171,170,-1,172,169,170,171,-1,163,151,169,172,-1,164,152,151,163,-1,160,153,149,159,-1,174,173,159,149,-1,165,150,152,164,-1,167,158,150,165,-1,166,157,158,167,-1,126,156,157,-1,126,128,1970,-1,157,166,128,126,-1,156,126,127,141,-1,141,127,12,131,-1,126,1970,1872,127,-1,127,1872,1480,12,-1,1972,128,166,2060,-1,2010,1970,128,1972,-1,143,200,199,148,-1,200,143,374,384,-1,2031,2032,132,226,-1,228,2033,2031,226,-1,140,130,129,136,-1,129,341,347,136,-1,130,140,141,131,-1,175,132,2032,2180,-1,132,134,145,226,-1,175,133,134,132,-1,195,196,133,175,-1,136,137,155,140,-1,155,137,177,176,-1,137,348,343,177,-1,155,176,158,-1,177,343,344,179,-1,178,152,150,176,-1,180,182,169,151,-1,181,179,344,383,-1,187,185,382,379,-1,2053,159,173,2080,-1,190,379,345,192,-1,196,192,138,133,-1,192,345,346,138,-1,133,138,139,135,-1,133,135,134,-1,134,135,146,145,-1,135,139,142,146,-1,146,142,144,147,-1,347,348,137,136,-1,138,346,354,139,-1,142,139,354,378,-1,140,155,156,141,-1,226,145,198,227,-1,143,144,377,374,-1,144,142,378,377,-1,144,143,148,147,-1,198,145,146,147,-1,148,197,198,147,-1,230,2184,2033,228,-1,202,201,227,197,-1,148,199,202,197,-1,149,191,193,174,-1,189,191,149,153,-1,158,176,150,-1,180,151,152,178,-1,188,154,168,186,-1,194,174,193,-1,189,153,154,188,-1,379,190,187,-1,156,155,158,157,-1,2179,195,2181,2079,-1,2179,173,174,-1,2054,160,159,2053,-1,2055,161,160,2054,-1,2056,162,161,2055,-1,171,162,2056,2067,-1,2057,163,172,2066,-1,2058,164,163,2057,-1,2059,165,164,2058,-1,2061,167,165,2059,-1,2060,166,167,2061,-1,184,186,168,170,-1,383,382,185,183,-1,183,181,383,-1,170,169,182,184,-1,2067,2066,172,171,-1,2080,173,2179,-1,174,194,195,2179,-1,195,175,2180,2181,-1,176,177,178,-1,178,177,179,180,-1,180,179,181,182,-1,182,181,183,184,-1,184,183,185,186,-1,186,185,187,188,-1,188,187,190,189,-1,189,190,191,-1,191,190,192,193,-1,193,192,196,194,-1,194,196,195,-1,227,198,197,-1,205,212,202,199,-1,384,401,208,200,-1,206,211,212,205,-1,205,199,200,208,-1,208,401,402,207,-1,204,209,211,206,-1,207,402,403,203,-1,204,206,207,203,-1,227,201,229,-1,202,213,215,201,-1,201,216,225,229,-1,213,214,218,215,-1,216,220,224,225,-1,216,201,215,-1,213,202,212,-1,236,1,0,235,-1,203,8,7,204,-1,206,205,208,207,-1,209,6,5,210,-1,211,209,210,214,-1,214,210,217,218,-1,212,211,214,213,-1,217,4,3,219,-1,215,218,220,216,-1,218,217,219,220,-1,220,219,223,224,-1,2184,221,13,1524,-1,232,221,2184,230,-1,221,222,14,13,-1,232,234,222,221,-1,222,235,0,14,-1,234,235,222,-1,231,229,225,-1,223,2,1,236,-1,224,223,236,233,-1,225,224,233,231,-1,226,227,228,-1,228,227,229,230,-1,230,229,231,232,-1,232,231,233,234,-1,234,233,236,235,-1,47,42,6,7,-1,5,41,34,4,-1,3,32,28,2,-1,8,237,258,48,-1,121,10,11,120,-1,122,9,10,121,-1,320,254,9,122,-1,12,120,11,-1,91,98,97,90,-1,90,97,83,89,-1,81,80,89,83,-1,80,81,82,79,-1,79,82,100,88,-1,88,100,99,87,-1,92,102,98,91,-1,102,92,78,77,-1,87,99,101,86,-1,86,101,93,84,-1,84,93,94,85,-1,94,95,125,-1,1737,123,125,-1,125,123,85,94,-1,110,124,125,95,-1,120,12,124,110,-1,124,1835,1737,125,-1,12,1480,1835,124,-1,1647,85,123,1735,-1,1735,123,1737,1697,-1,103,52,51,108,-1,277,287,108,51,-1,25,119,1675,1676,-1,25,1676,1674,23,-1,115,122,121,111,-1,115,314,320,122,-1,120,110,111,121,-1,1529,1675,119,76,-1,25,106,117,119,-1,119,117,118,76,-1,76,118,55,56,-1,111,96,114,115,-1,75,74,114,96,-1,74,318,313,114,-1,93,75,96,-1,72,317,318,74,-1,75,101,99,73,-1,100,82,69,71,-1,278,317,72,70,-1,282,279,66,64,-1,1627,78,92,1654,-1,59,316,282,61,-1,118,113,59,55,-1,113,315,316,59,-1,116,112,113,118,-1,117,116,118,-1,106,105,116,117,-1,105,109,112,116,-1,104,107,109,105,-1,115,114,313,314,-1,112,307,315,113,-1,283,307,112,109,-1,110,95,96,111,-1,24,53,106,25,-1,287,284,107,108,-1,284,283,109,107,-1,104,103,108,107,-1,104,105,106,53,-1,104,53,54,103,-1,23,1674,1525,21,-1,54,24,50,49,-1,54,49,52,103,-1,77,58,60,102,-1,98,102,60,62,-1,101,75,93,-1,73,99,100,71,-1,65,83,97,63,-1,58,77,57,-1,63,97,98,62,-1,64,61,282,-1,94,93,96,95,-1,1628,1528,56,1530,-1,77,78,1530,-1,1654,92,91,1653,-1,1653,91,90,1652,-1,1652,90,89,1651,-1,1640,1651,89,80,-1,1641,79,88,1650,-1,1650,88,87,1649,-1,1649,87,86,1648,-1,1648,86,84,1646,-1,1646,84,85,1647,-1,81,83,65,67,-1,68,66,279,278,-1,278,70,68,-1,67,69,82,81,-1,80,79,1641,1640,-1,1530,78,1627,-1,1530,56,57,77,-1,1528,1529,76,56,-1,73,74,75,-1,71,72,74,73,-1,69,70,72,71,-1,67,68,70,69,-1,65,66,68,67,-1,63,64,66,65,-1,62,61,64,63,-1,60,61,62,-1,58,59,61,60,-1,57,55,59,58,-1,56,55,57,-1,54,53,24,-1,52,49,39,46,-1,51,43,260,277,-1,46,39,40,45,-1,43,51,52,46,-1,44,259,260,43,-1,45,40,42,47,-1,48,258,259,44,-1,48,44,45,47,-1,22,50,24,-1,50,36,38,49,-1,22,26,35,50,-1,36,33,37,38,-1,26,27,31,35,-1,36,50,35,-1,39,49,38,-1,16,0,1,15,-1,47,7,8,48,-1,44,43,46,45,-1,41,5,6,42,-1,37,41,42,40,-1,33,34,41,37,-1,38,37,40,39,-1,32,3,4,34,-1,35,31,33,36,-1,31,32,34,33,-1,27,28,32,31,-1,1524,13,30,1525,-1,21,1525,30,19,-1,13,14,29,30,-1,30,29,17,19,-1,14,0,16,29,-1,29,16,17,-1,26,22,20,-1,15,1,2,28,-1,18,15,28,27,-1,20,18,27,26,-1,23,24,25,-1,21,22,24,23,-1,19,20,22,21,-1,17,18,20,19,-1,16,15,18,17,-1,238,394,396,239,-1,240,398,400,241,-1,241,400,687,407,-1,240,239,396,398,-1,238,237,403,394,-1,406,253,252,405,-1,331,332,700,698,-1,251,250,332,331,-1,341,254,253,406,-1,331,342,405,-1,251,331,405,-1,698,597,342,331,-1,250,249,334,332,-1,700,332,334,333,-1,245,338,340,246,-1,436,700,333,242,-1,242,333,335,243,-1,334,336,335,333,-1,249,248,336,334,-1,243,335,337,244,-1,336,339,337,335,-1,248,247,339,336,-1,244,337,338,245,-1,339,340,338,337,-1,247,246,340,339,-1,251,405,252,-1,385,375,371,386,-1,642,672,388,368,-1,387,386,371,372,-1,374,375,385,384,-1,372,368,388,387,-1,341,406,404,347,-1,405,342,365,404,-1,342,597,613,365,-1,348,356,349,343,-1,343,349,381,344,-1,383,344,381,-1,382,380,350,379,-1,379,350,351,345,-1,345,351,352,346,-1,346,352,353,354,-1,404,356,348,347,-1,356,366,357,349,-1,349,357,358,381,-1,381,358,359,380,-1,380,359,360,350,-1,350,360,361,351,-1,351,361,362,352,-1,352,362,363,353,-1,354,353,364,355,-1,353,363,367,364,-1,355,378,354,-1,376,355,364,370,-1,376,377,378,355,-1,365,366,356,404,-1,366,614,598,357,-1,357,598,599,358,-1,358,599,600,359,-1,359,600,601,360,-1,360,601,602,361,-1,361,602,603,362,-1,362,603,604,363,-1,363,604,610,367,-1,364,367,369,373,-1,373,370,364,-1,613,614,366,365,-1,369,367,610,620,-1,369,620,642,368,-1,372,373,369,368,-1,375,376,370,371,-1,371,370,373,372,-1,374,377,376,375,-1,381,380,382,383,-1,385,389,401,384,-1,386,390,389,385,-1,387,391,390,386,-1,388,392,391,387,-1,672,682,392,388,-1,389,393,402,401,-1,390,395,393,389,-1,391,397,395,390,-1,392,399,397,391,-1,682,686,399,392,-1,393,394,403,402,-1,395,396,394,393,-1,397,398,396,395,-1,399,400,398,397,-1,686,687,400,399,-1,404,406,405,-1,239,265,267,238,-1,241,261,263,240,-1,407,464,261,241,-1,263,265,239,240,-1,267,258,237,238,-1,256,252,253,255,-1,453,451,329,330,-1,330,329,250,251,-1,255,253,254,320,-1,256,319,330,-1,256,330,251,-1,330,319,554,453,-1,329,327,249,250,-1,328,327,329,451,-1,246,321,323,245,-1,242,328,451,436,-1,243,326,328,242,-1,328,326,325,327,-1,327,325,248,249,-1,244,324,326,243,-1,326,324,322,325,-1,325,322,247,248,-1,245,323,324,244,-1,324,323,321,322,-1,322,321,246,247,-1,252,256,251,-1,275,290,286,276,-1,293,273,479,509,-1,289,290,275,274,-1,277,276,286,287,-1,274,273,293,289,-1,314,257,255,320,-1,257,296,319,256,-1,296,538,554,319,-1,318,312,305,313,-1,317,280,312,318,-1,280,317,278,-1,282,311,281,279,-1,316,310,311,282,-1,315,309,310,316,-1,307,308,309,315,-1,314,313,305,257,-1,312,304,295,305,-1,280,303,304,312,-1,281,302,303,280,-1,311,301,302,281,-1,310,300,301,311,-1,309,299,300,310,-1,308,298,299,309,-1,306,297,308,307,-1,297,294,298,308,-1,307,283,306,-1,291,297,306,285,-1,306,283,284,285,-1,257,305,295,296,-1,304,553,537,295,-1,303,552,553,304,-1,302,551,552,303,-1,301,550,551,302,-1,300,549,550,301,-1,299,548,549,300,-1,298,547,548,299,-1,294,541,547,298,-1,288,292,294,297,-1,297,291,288,-1,296,295,537,538,-1,531,541,294,292,-1,293,509,531,292,-1,293,292,288,289,-1,290,291,285,286,-1,289,288,291,290,-1,286,285,284,287,-1,278,279,281,280,-1,277,260,272,276,-1,276,272,271,275,-1,275,271,270,274,-1,274,270,269,273,-1,273,269,469,479,-1,260,259,268,272,-1,272,268,266,271,-1,271,266,264,270,-1,270,264,262,269,-1,269,262,465,469,-1,259,258,267,268,-1,268,267,265,266,-1,266,265,263,264,-1,264,263,261,262,-1,262,261,464,465,-1,256,255,257,-1,407,687,689,408,-1,409,408,689,691,-1,409,691,693,410,-1,435,702,700,436,-1,698,699,597,-1,597,699,576,616,-1,616,576,629,-1,419,657,658,420,-1,417,593,656,418,-1,416,592,593,417,-1,415,591,592,416,-1,414,590,591,415,-1,413,589,590,414,-1,737,902,589,413,-1,595,577,889,908,-1,594,578,577,595,-1,596,579,578,594,-1,631,580,579,596,-1,629,581,580,631,-1,576,582,581,629,-1,699,701,582,576,-1,430,429,713,711,-1,577,583,896,889,-1,578,584,583,577,-1,579,585,584,578,-1,580,586,585,579,-1,581,587,586,580,-1,582,588,587,581,-1,701,714,588,582,-1,714,701,423,-1,421,420,658,659,-1,583,671,966,896,-1,584,669,671,583,-1,585,667,669,584,-1,586,665,667,585,-1,587,663,665,586,-1,588,661,663,587,-1,714,659,661,588,-1,670,589,902,965,-1,668,590,589,670,-1,666,591,590,668,-1,664,592,591,666,-1,662,593,592,664,-1,660,656,593,662,-1,657,656,660,-1,596,594,605,632,-1,635,605,594,595,-1,595,908,925,635,-1,632,633,631,596,-1,613,597,616,617,-1,615,598,614,618,-1,598,615,612,599,-1,612,611,600,599,-1,611,607,601,600,-1,607,608,602,601,-1,602,608,603,-1,608,623,604,603,-1,623,624,610,604,-1,605,635,634,606,-1,605,606,636,632,-1,606,634,644,645,-1,634,927,928,644,-1,636,606,645,-1,644,928,954,646,-1,638,645,647,-1,646,954,951,648,-1,648,951,931,650,-1,647,649,607,611,-1,650,931,933,654,-1,649,651,608,607,-1,651,655,623,608,-1,654,933,918,653,-1,619,621,652,653,-1,655,652,609,-1,652,621,622,609,-1,919,619,653,918,-1,609,627,623,655,-1,627,609,622,626,-1,610,624,625,620,-1,647,611,612,-1,615,638,647,612,-1,617,618,614,613,-1,638,615,618,637,-1,617,630,618,-1,616,629,630,617,-1,630,633,637,618,-1,621,619,641,640,-1,639,628,626,622,-1,929,641,619,919,-1,643,642,620,625,-1,628,643,625,626,-1,640,639,622,621,-1,624,623,627,-1,625,624,627,626,-1,673,643,628,674,-1,674,628,639,681,-1,630,629,631,633,-1,633,632,636,637,-1,927,634,635,925,-1,637,636,645,638,-1,639,640,675,681,-1,675,640,641,676,-1,676,641,929,981,-1,672,642,643,673,-1,646,647,645,644,-1,648,649,647,646,-1,650,651,649,648,-1,654,655,651,650,-1,653,652,655,654,-1,659,714,422,421,-1,419,418,656,657,-1,660,658,657,-1,659,658,660,661,-1,661,660,662,663,-1,663,662,664,665,-1,665,664,666,667,-1,667,666,668,669,-1,669,668,670,671,-1,671,670,965,966,-1,695,411,410,693,-1,697,412,411,695,-1,998,715,412,697,-1,673,683,682,672,-1,674,685,683,673,-1,681,684,685,674,-1,679,694,692,684,-1,677,696,694,679,-1,996,997,696,677,-1,681,675,680,-1,680,675,676,678,-1,678,676,981,993,-1,993,996,677,678,-1,678,677,679,680,-1,680,679,684,681,-1,683,688,686,682,-1,685,690,688,683,-1,684,692,690,685,-1,688,689,687,686,-1,690,691,689,688,-1,692,693,691,690,-1,694,695,693,692,-1,696,697,695,694,-1,997,998,697,696,-1,699,698,700,701,-1,423,701,703,424,-1,700,702,703,701,-1,702,704,705,703,-1,435,434,704,702,-1,424,703,705,425,-1,704,706,707,705,-1,434,433,706,704,-1,425,705,707,426,-1,706,708,709,707,-1,433,432,708,706,-1,426,707,709,427,-1,708,710,712,709,-1,432,431,710,708,-1,427,709,712,428,-1,710,711,713,712,-1,431,430,711,710,-1,428,712,713,429,-1,423,422,714,-1,408,462,464,407,-1,460,462,408,409,-1,410,458,460,409,-1,436,451,449,435,-1,554,452,453,-1,535,575,452,554,-1,522,575,535,-1,420,493,494,419,-1,418,495,558,417,-1,417,558,559,416,-1,416,559,560,415,-1,415,560,561,414,-1,414,561,562,413,-1,413,562,859,737,-1,853,872,574,556,-1,556,574,573,557,-1,557,573,572,555,-1,555,572,571,520,-1,520,571,570,522,-1,522,570,569,575,-1,575,569,450,452,-1,440,438,429,430,-1,872,865,568,574,-1,574,568,567,573,-1,573,567,566,572,-1,572,566,565,571,-1,571,565,564,570,-1,570,564,563,569,-1,569,563,437,450,-1,423,450,437,-1,492,493,420,421,-1,865,795,480,568,-1,568,480,482,567,-1,567,482,484,566,-1,566,484,486,565,-1,565,486,488,564,-1,564,488,490,563,-1,563,490,492,437,-1,796,859,562,481,-1,481,562,561,483,-1,483,561,560,485,-1,485,560,559,487,-1,487,559,558,489,-1,489,558,495,491,-1,491,495,494,-1,519,546,557,555,-1,556,557,546,516,-1,516,836,853,556,-1,555,520,518,519,-1,534,535,554,538,-1,533,537,553,536,-1,552,539,536,553,-1,552,551,540,539,-1,551,550,544,540,-1,550,549,543,544,-1,548,543,549,-1,548,547,528,543,-1,547,541,527,528,-1,545,517,516,546,-1,519,515,545,546,-1,506,507,517,545,-1,507,833,834,517,-1,506,545,515,-1,505,807,833,507,-1,504,506,513,-1,503,810,807,505,-1,501,830,810,503,-1,540,544,502,504,-1,497,828,830,501,-1,544,543,500,502,-1,543,528,496,500,-1,498,843,828,497,-1,498,499,530,532,-1,542,499,496,-1,542,529,530,499,-1,843,498,532,842,-1,496,528,524,542,-1,525,529,542,524,-1,531,526,527,541,-1,539,540,504,-1,539,504,513,536,-1,538,537,533,534,-1,514,533,536,513,-1,533,521,534,-1,534,521,522,535,-1,533,514,518,521,-1,511,510,532,530,-1,529,525,523,512,-1,842,532,510,832,-1,526,531,509,508,-1,525,526,508,523,-1,530,529,512,511,-1,524,528,527,-1,525,524,527,526,-1,477,523,508,478,-1,470,512,523,477,-1,518,520,522,521,-1,514,515,519,518,-1,836,516,517,834,-1,513,506,515,514,-1,470,476,511,512,-1,475,510,511,476,-1,780,832,510,475,-1,478,508,509,479,-1,507,506,504,505,-1,505,504,502,503,-1,503,502,500,501,-1,501,500,496,497,-1,497,496,499,498,-1,421,422,437,492,-1,494,495,418,419,-1,494,493,491,-1,490,491,493,492,-1,488,489,491,490,-1,486,487,489,488,-1,484,485,487,486,-1,482,483,485,484,-1,480,481,483,482,-1,795,796,481,480,-1,458,410,411,456,-1,456,411,412,454,-1,454,412,715,763,-1,479,469,468,478,-1,478,468,466,477,-1,477,466,467,470,-1,467,459,457,472,-1,472,457,455,474,-1,474,455,764,765,-1,471,476,470,-1,473,475,476,471,-1,768,780,475,473,-1,473,474,765,768,-1,471,472,474,473,-1,470,467,472,471,-1,469,465,463,468,-1,468,463,461,466,-1,466,461,459,467,-1,465,464,462,463,-1,463,462,460,461,-1,461,460,458,459,-1,459,458,456,457,-1,457,456,454,455,-1,455,454,763,764,-1,450,451,453,452,-1,424,448,450,423,-1,450,448,449,451,-1,448,446,447,449,-1,449,447,434,435,-1,425,446,448,424,-1,446,444,445,447,-1,447,445,433,434,-1,426,444,446,425,-1,444,442,443,445,-1,445,443,432,433,-1,427,442,444,426,-1,442,439,441,443,-1,443,441,431,432,-1,428,439,442,427,-1,439,438,440,441,-1,441,440,430,431,-1,429,438,439,428,-1,437,422,423,-1,1003,1478,1479,-1,1024,726,1003,1479,-1,1478,1003,1022,-1,1023,1021,985,939,-1,939,985,984,947,-1,881,979,980,-1,903,882,881,980,-1,728,727,979,881,-1,882,903,904,-1,736,901,902,737,-1,735,900,901,736,-1,733,898,899,734,-1,732,897,898,733,-1,897,732,731,977,-1,882,884,883,881,-1,904,885,884,882,-1,905,886,885,904,-1,907,887,886,905,-1,906,888,887,907,-1,908,889,888,906,-1,884,891,890,883,-1,885,892,891,884,-1,886,893,892,885,-1,887,894,893,886,-1,888,895,894,887,-1,889,896,895,888,-1,890,978,730,729,-1,891,976,978,890,-1,892,974,976,891,-1,893,972,974,892,-1,894,970,972,893,-1,895,968,970,894,-1,896,966,968,895,-1,975,897,977,-1,973,898,897,975,-1,971,899,898,973,-1,969,900,899,971,-1,967,901,900,969,-1,965,902,901,967,-1,903,980,911,920,-1,904,903,920,921,-1,963,964,907,905,-1,906,924,925,908,-1,905,904,921,963,-1,924,906,907,964,-1,1434,1478,1023,917,-1,959,955,952,953,-1,930,952,955,946,-1,946,944,932,930,-1,913,914,945,956,-1,932,944,942,934,-1,933,935,918,-1,934,942,940,937,-1,916,917,941,943,-1,928,950,954,-1,962,922,958,949,-1,959,953,949,958,-1,922,923,957,958,-1,926,961,950,-1,924,964,961,926,-1,922,962,963,921,-1,980,1474,1437,911,-1,1436,1429,909,910,-1,1429,1430,912,909,-1,910,909,957,923,-1,910,911,1437,1436,-1,909,912,960,957,-1,910,923,920,911,-1,1430,1431,913,912,-1,912,913,956,960,-1,1431,1432,914,913,-1,1432,1433,915,914,-1,914,915,943,945,-1,916,915,1433,1435,-1,915,916,943,-1,1435,1434,917,916,-1,939,941,917,1023,-1,937,940,947,948,-1,919,938,936,929,-1,918,935,938,919,-1,921,920,923,922,-1,925,924,926,927,-1,927,926,950,928,-1,936,948,983,982,-1,929,936,982,981,-1,930,931,951,952,-1,932,933,931,930,-1,934,935,933,932,-1,937,938,935,934,-1,948,936,938,937,-1,940,941,939,947,-1,942,943,941,940,-1,944,945,943,942,-1,946,956,945,944,-1,955,956,946,-1,984,983,948,947,-1,949,950,961,962,-1,953,954,950,949,-1,952,951,954,953,-1,959,960,956,955,-1,958,957,960,959,-1,962,961,964,963,-1,966,965,967,968,-1,968,967,969,970,-1,970,969,971,972,-1,972,971,973,974,-1,974,973,975,976,-1,976,975,977,978,-1,978,977,731,730,-1,980,979,1475,1474,-1,1002,717,716,1000,-1,1018,718,717,1002,-1,1013,720,719,1015,-1,990,1001,999,995,-1,988,1017,1001,990,-1,986,1016,1017,988,-1,994,1014,1016,986,-1,1008,1010,994,-1,723,722,1009,1007,-1,993,981,982,992,-1,992,982,983,991,-1,991,983,984,989,-1,989,984,985,987,-1,987,985,1021,1019,-1,1004,1003,726,725,-1,725,724,1005,1004,-1,1006,994,1019,1020,-1,1019,994,986,987,-1,987,986,988,989,-1,989,988,990,991,-1,991,990,995,992,-1,992,995,996,993,-1,722,721,1011,1009,-1,1007,1005,724,723,-1,1012,994,1010,-1,994,1006,1008,-1,1014,994,1012,-1,996,995,999,997,-1,999,1000,998,997,-1,1001,1002,1000,999,-1,1017,1018,1002,1001,-1,1015,719,718,1018,-1,1022,1003,1004,1020,-1,1020,1004,1005,1006,-1,1006,1005,1007,1008,-1,1008,1007,1009,1010,-1,1010,1009,1011,1012,-1,1012,1011,1013,1014,-1,1014,1013,1015,1016,-1,1016,1015,1018,1017,-1,1020,1019,1021,1022,-1,1022,1021,1023,1478,-1,1060,1061,758,-1,1060,758,726,1024,-1,739,758,1061,-1,822,776,740,738,-1,814,777,776,822,-1,781,782,880,-1,781,880,879,858,-1,880,782,727,728,-1,857,858,879,-1,737,859,860,736,-1,736,860,861,735,-1,734,899,900,735,861,862,-1,734,862,863,733,-1,733,863,864,732,-1,784,731,732,864,-1,1064,1059,1475,979,727,782,-1,728,881,883,878,880,-1,880,878,877,879,-1,879,877,876,857,-1,857,876,875,856,-1,856,875,874,854,-1,854,874,873,855,-1,855,873,872,853,-1,883,890,729,871,878,-1,878,871,870,877,-1,877,870,869,876,-1,876,869,868,875,-1,875,868,867,874,-1,874,867,866,873,-1,873,866,865,872,-1,729,730,783,871,-1,871,783,785,870,-1,870,785,787,869,-1,869,787,789,868,-1,868,789,791,867,-1,867,791,793,866,-1,866,793,795,865,-1,784,864,786,-1,786,864,863,788,-1,788,863,862,790,-1,790,862,861,792,-1,792,861,860,794,-1,794,860,859,796,-1,841,850,781,858,-1,840,841,858,857,-1,856,854,797,798,-1,853,836,837,855,-1,798,840,857,856,-1,797,854,855,837,-1,844,738,1061,1105,-1,808,809,806,802,-1,815,806,809,831,-1,831,829,817,815,-1,805,816,847,848,-1,827,819,817,829,-1,843,826,828,-1,824,821,819,827,-1,818,820,844,845,-1,807,811,833,-1,812,803,839,799,-1,803,812,808,802,-1,803,804,838,839,-1,811,800,835,-1,835,800,797,837,-1,840,798,799,839,-1,850,1102,1065,781,-1,851,852,1110,1103,-1,852,849,1109,1110,-1,838,804,852,851,-1,1103,1102,850,851,-1,804,801,849,852,-1,850,841,838,851,-1,849,848,1108,1109,-1,801,805,848,849,-1,848,847,1107,1108,-1,847,846,1106,1107,-1,816,818,846,847,-1,1104,1106,846,845,-1,818,845,846,-1,845,844,1105,1104,-1,738,844,820,822,-1,813,814,821,824,-1,832,825,823,842,-1,842,823,826,843,-1,839,838,841,840,-1,834,835,837,836,-1,833,811,835,834,-1,779,778,813,825,-1,780,779,825,832,-1,809,810,830,831,-1,831,830,828,829,-1,829,828,826,827,-1,827,826,823,824,-1,824,823,825,813,-1,814,822,820,821,-1,821,820,818,819,-1,819,818,816,817,-1,817,816,805,815,-1,815,805,806,-1,814,813,778,777,-1,799,800,811,812,-1,812,811,807,808,-1,808,807,810,809,-1,806,805,801,802,-1,802,801,804,803,-1,798,797,800,799,-1,793,794,796,795,-1,791,792,794,793,-1,789,790,792,791,-1,787,788,790,789,-1,785,786,788,787,-1,783,784,786,785,-1,730,731,784,783,-1,1065,1064,782,781,-1,761,763,715,998,1000,716,-1,761,716,717,759,-1,759,717,718,743,-1,746,719,720,748,-1,748,720,1013,1011,721,750,-1,766,762,760,771,-1,771,760,744,773,-1,773,744,745,775,-1,775,745,747,767,-1,767,751,753,-1,754,752,722,723,-1,769,779,780,768,-1,770,778,779,769,-1,772,777,778,770,-1,774,776,777,772,-1,742,740,776,774,-1,725,726,758,757,-1,757,756,724,725,-1,741,742,767,755,-1,774,775,767,742,-1,772,773,775,774,-1,770,771,773,772,-1,769,766,771,770,-1,768,765,766,769,-1,752,750,721,722,-1,723,724,756,754,-1,751,767,749,-1,753,755,767,-1,749,767,747,-1,764,762,766,765,-1,764,763,761,762,-1,762,761,759,760,-1,760,759,743,744,-1,743,718,719,746,-1,741,757,758,739,-1,755,756,757,741,-1,753,754,756,755,-1,751,752,754,753,-1,749,750,752,751,-1,747,748,750,749,-1,745,746,748,747,-1,744,743,746,745,-1,739,740,742,741,-1,1061,738,740,739,-1,1058,1291,1475,1059,-1,1031,1361,1363,1032,-1,1032,1363,1365,1033,-1,1033,1365,1367,1034,-1,1034,1367,1369,1035,-1,1035,1369,1371,1036,-1,1036,1371,1373,1037,-1,1037,1373,1375,1038,-1,1038,1375,1377,1039,-1,1039,1377,1379,1040,-1,1040,1379,1381,1041,-1,1041,1381,1383,1042,-1,1042,1383,1385,1043,-1,1043,1385,1387,1044,-1,1044,1387,1389,1045,-1,1045,1389,1391,1046,-1,1046,1391,1393,1047,-1,1047,1393,1395,1048,-1,1395,1397,1049,1048,-1,1049,1397,1399,1050,-1,1050,1399,1401,1051,-1,1051,1401,1405,1052,-1,1052,1405,1402,1053,-1,1476,1270,1026,1025,-1,1427,1271,1270,1476,-1,1408,1272,1271,1427,-1,1410,1273,1272,1408,-1,1411,1274,1273,1410,-1,1413,1275,1274,1411,-1,1414,1276,1275,1413,-1,1415,1277,1276,1414,-1,1417,1278,1277,1415,-1,1418,1279,1278,1417,-1,1416,1280,1279,1418,-1,1420,1281,1280,1416,-1,1421,1282,1281,1420,-1,1419,1283,1282,1421,-1,1424,1284,1283,1419,-1,1423,1285,1284,1424,-1,1422,1286,1285,1423,-1,1412,1287,1286,1422,-1,1425,1288,1287,1412,-1,1426,1289,1288,1425,-1,1409,1290,1289,1426,-1,1428,1292,1290,1409,-1,1475,1291,1292,1428,-1,1058,1057,1406,1291,-1,1270,1314,1027,1026,-1,1271,1293,1314,1270,-1,1272,1294,1293,1271,-1,1273,1295,1294,1272,-1,1274,1296,1295,1273,-1,1275,1297,1296,1274,-1,1276,1298,1297,1275,-1,1277,1299,1298,1276,-1,1278,1300,1299,1277,-1,1279,1301,1300,1278,-1,1280,1302,1301,1279,-1,1281,1303,1302,1280,-1,1282,1304,1303,1281,-1,1283,1305,1304,1282,-1,1284,1306,1305,1283,-1,1285,1307,1306,1284,-1,1286,1308,1307,1285,-1,1287,1309,1308,1286,-1,1288,1310,1309,1287,-1,1289,1311,1310,1288,-1,1290,1312,1311,1289,-1,1292,1313,1312,1290,-1,1291,1406,1313,1292,-1,1293,1315,1336,1314,-1,1294,1316,1315,1293,-1,1295,1317,1316,1294,-1,1296,1318,1317,1295,-1,1297,1319,1318,1296,-1,1298,1320,1319,1297,-1,1299,1321,1320,1298,-1,1300,1322,1321,1299,-1,1301,1323,1322,1300,-1,1302,1324,1323,1301,-1,1303,1325,1324,1302,-1,1304,1326,1325,1303,-1,1305,1327,1326,1304,-1,1306,1328,1327,1305,-1,1307,1329,1328,1306,-1,1308,1330,1329,1307,-1,1309,1331,1330,1308,-1,1310,1332,1331,1309,-1,1311,1333,1332,1310,-1,1312,1334,1333,1311,-1,1313,1335,1334,1312,-1,1406,1407,1335,1313,-1,1314,1336,1028,1027,-1,1315,1337,1359,1336,-1,1316,1338,1337,1315,-1,1317,1339,1338,1316,-1,1318,1340,1339,1317,-1,1319,1341,1340,1318,-1,1320,1342,1341,1319,-1,1321,1343,1342,1320,-1,1322,1344,1343,1321,-1,1323,1345,1344,1322,-1,1324,1346,1345,1323,-1,1325,1347,1346,1324,-1,1326,1348,1347,1325,-1,1327,1349,1348,1326,-1,1328,1350,1349,1327,-1,1329,1351,1350,1328,-1,1330,1352,1351,1329,-1,1331,1353,1352,1330,-1,1332,1354,1353,1331,-1,1333,1355,1354,1332,-1,1334,1356,1355,1333,-1,1335,1357,1356,1334,-1,1407,1358,1357,1335,-1,1056,1055,1358,1407,-1,1336,1359,1029,1028,-1,1337,1362,1360,1359,-1,1338,1364,1362,1337,-1,1339,1366,1364,1338,-1,1340,1368,1366,1339,-1,1341,1370,1368,1340,-1,1342,1372,1370,1341,-1,1343,1374,1372,1342,-1,1344,1376,1374,1343,-1,1345,1378,1376,1344,-1,1346,1380,1378,1345,-1,1347,1382,1380,1346,-1,1348,1384,1382,1347,-1,1349,1386,1384,1348,-1,1350,1388,1386,1349,-1,1351,1390,1388,1350,-1,1352,1392,1390,1351,-1,1353,1394,1392,1352,-1,1354,1396,1394,1353,-1,1355,1398,1396,1354,-1,1356,1400,1398,1355,-1,1357,1404,1400,1356,-1,1358,1403,1404,1357,-1,1055,1054,1403,1358,-1,1359,1360,1030,1029,-1,1054,1053,1402,1403,-1,1360,1361,1031,1030,-1,1362,1363,1361,1360,-1,1364,1365,1363,1362,-1,1366,1367,1365,1364,-1,1368,1369,1367,1366,-1,1370,1371,1369,1368,-1,1372,1373,1371,1370,-1,1374,1375,1373,1372,-1,1376,1377,1375,1374,-1,1378,1379,1377,1376,-1,1380,1381,1379,1378,-1,1382,1383,1381,1380,-1,1384,1385,1383,1382,-1,1386,1387,1385,1384,-1,1388,1389,1387,1386,-1,1390,1391,1389,1388,-1,1392,1393,1391,1390,-1,1394,1395,1393,1392,-1,1396,1397,1395,1394,-1,1398,1399,1397,1396,-1,1400,1401,1399,1398,-1,1404,1405,1401,1400,-1,1403,1402,1405,1404,-1,1057,1056,1407,1406,-1,1443,1410,1408,1451,-1,1442,1413,1411,1443,-1,1441,1417,1415,1442,-1,1440,1420,1416,1441,-1,1439,1424,1419,1440,-1,1444,1412,1422,1439,-1,1445,1438,1428,1409,-1,1450,1451,1408,1427,-1,1409,1426,1444,1445,-1,1443,1411,1410,-1,1412,1444,1425,-1,1442,1414,1413,-1,1414,1442,1415,-1,1418,1441,1416,-1,1441,1418,1417,-1,1421,1440,1419,-1,1440,1421,1420,-1,1423,1439,1422,-1,1423,1424,1439,-1,1425,1444,1426,-1,1450,1427,1476,1477,-1,1438,1474,1475,1428,-1,1477,1478,1434,-1,1464,1463,1429,1436,-1,1463,1460,1430,1429,-1,1460,1463,1462,1459,-1,1460,1461,1431,1430,-1,1461,1457,1432,1431,-1,1456,1457,1461,1458,-1,1457,1453,1433,1432,-1,1453,1457,1467,-1,1435,1433,1453,1454,-1,1454,1477,1434,1435,-1,1450,1477,1454,1468,-1,1463,1464,1472,-1,1436,1437,1465,1464,-1,1438,1465,1437,1474,-1,1465,1438,1445,1471,-1,1470,1444,1439,1446,-1,1446,1439,1440,1447,-1,1447,1440,1441,1448,-1,1449,1448,1441,1442,-1,1442,1443,1452,1449,-1,1452,1443,1451,1469,-1,1445,1444,1470,1471,-1,1473,1470,1446,1462,-1,1462,1446,1447,1459,-1,1459,1447,1448,1458,-1,1458,1448,1449,1456,-1,1456,1449,1452,1455,-1,1468,1469,1451,1450,-1,1455,1452,1469,1466,-1,1467,1468,1454,1453,-1,1457,1466,1467,-1,1466,1457,1455,-1,1455,1457,1456,-1,1459,1458,1461,1460,-1,1462,1463,1473,-1,1472,1473,1463,-1,1472,1464,1465,1471,-1,1467,1466,1469,1468,-1,1471,1470,1473,1472,-1,1477,1476,1479,1478,-1,1059,1064,1248,1058,-1,1032,1176,1178,1031,-1,1033,1174,1176,1032,-1,1034,1172,1174,1033,-1,1035,1170,1172,1034,-1,1036,1168,1170,1035,-1,1037,1166,1168,1036,-1,1038,1164,1166,1037,-1,1039,1162,1164,1038,-1,1040,1160,1162,1039,-1,1041,1158,1160,1040,-1,1042,1156,1158,1041,-1,1043,1154,1156,1042,-1,1044,1152,1154,1043,-1,1045,1150,1152,1044,-1,1046,1148,1150,1045,-1,1047,1146,1148,1046,-1,1048,1144,1146,1047,-1,1048,1049,1142,1144,-1,1050,1140,1142,1049,-1,1051,1138,1140,1050,-1,1052,1134,1138,1051,-1,1053,1137,1134,1052,-1,1025,1026,1269,1063,-1,1063,1269,1268,1112,-1,1112,1268,1267,1131,-1,1131,1267,1266,1129,-1,1129,1266,1265,1128,-1,1128,1265,1264,1126,-1,1126,1264,1263,1125,-1,1125,1263,1262,1124,-1,1124,1262,1261,1122,-1,1122,1261,1260,1121,-1,1121,1260,1259,1123,-1,1123,1259,1258,1119,-1,1119,1258,1257,1118,-1,1118,1257,1256,1120,-1,1120,1256,1255,1115,-1,1115,1255,1254,1116,-1,1116,1254,1253,1117,-1,1117,1253,1252,1127,-1,1127,1252,1251,1114,-1,1114,1251,1250,1113,-1,1113,1250,1249,1130,-1,1130,1249,1247,1111,-1,1111,1247,1248,1064,-1,1248,1133,1057,1058,-1,1026,1027,1225,1269,-1,1269,1225,1246,1268,-1,1268,1246,1245,1267,-1,1267,1245,1244,1266,-1,1266,1244,1243,1265,-1,1265,1243,1242,1264,-1,1264,1242,1241,1263,-1,1263,1241,1240,1262,-1,1262,1240,1239,1261,-1,1261,1239,1238,1260,-1,1260,1238,1237,1259,-1,1259,1237,1236,1258,-1,1258,1236,1235,1257,-1,1257,1235,1234,1256,-1,1256,1234,1233,1255,-1,1255,1233,1232,1254,-1,1254,1232,1231,1253,-1,1253,1231,1230,1252,-1,1252,1230,1229,1251,-1,1251,1229,1228,1250,-1,1250,1228,1227,1249,-1,1249,1227,1226,1247,-1,1247,1226,1133,1248,-1,1225,1203,1224,1246,-1,1246,1224,1223,1245,-1,1245,1223,1222,1244,-1,1244,1222,1221,1243,-1,1243,1221,1220,1242,-1,1242,1220,1219,1241,-1,1241,1219,1218,1240,-1,1240,1218,1217,1239,-1,1239,1217,1216,1238,-1,1238,1216,1215,1237,-1,1237,1215,1214,1236,-1,1236,1214,1213,1235,-1,1235,1213,1212,1234,-1,1234,1212,1211,1233,-1,1233,1211,1210,1232,-1,1232,1210,1209,1231,-1,1231,1209,1208,1230,-1,1230,1208,1207,1229,-1,1229,1207,1206,1228,-1,1228,1206,1205,1227,-1,1227,1205,1204,1226,-1,1226,1204,1132,1133,-1,1027,1028,1203,1225,-1,1203,1180,1202,1224,-1,1224,1202,1201,1223,-1,1223,1201,1200,1222,-1,1222,1200,1199,1221,-1,1221,1199,1198,1220,-1,1220,1198,1197,1219,-1,1219,1197,1196,1218,-1,1218,1196,1195,1217,-1,1217,1195,1194,1216,-1,1216,1194,1193,1215,-1,1215,1193,1192,1214,-1,1214,1192,1191,1213,-1,1213,1191,1190,1212,-1,1212,1190,1189,1211,-1,1211,1189,1188,1210,-1,1210,1188,1187,1209,-1,1209,1187,1186,1208,-1,1208,1186,1185,1207,-1,1207,1185,1184,1206,-1,1206,1184,1183,1205,-1,1205,1183,1182,1204,-1,1204,1182,1181,1132,-1,1132,1181,1055,1056,-1,1028,1029,1180,1203,-1,1180,1179,1177,1202,-1,1202,1177,1175,1201,-1,1201,1175,1173,1200,-1,1200,1173,1171,1199,-1,1199,1171,1169,1198,-1,1198,1169,1167,1197,-1,1197,1167,1165,1196,-1,1196,1165,1163,1195,-1,1195,1163,1161,1194,-1,1194,1161,1159,1193,-1,1193,1159,1157,1192,-1,1192,1157,1155,1191,-1,1191,1155,1153,1190,-1,1190,1153,1151,1189,-1,1189,1151,1149,1188,-1,1188,1149,1147,1187,-1,1187,1147,1145,1186,-1,1186,1145,1143,1185,-1,1185,1143,1141,1184,-1,1184,1141,1139,1183,-1,1183,1139,1135,1182,-1,1182,1135,1136,1181,-1,1181,1136,1054,1055,-1,1029,1030,1179,1180,-1,1136,1137,1053,1054,-1,1030,1031,1178,1179,-1,1179,1178,1176,1177,-1,1177,1176,1174,1175,-1,1175,1174,1172,1173,-1,1173,1172,1170,1171,-1,1171,1170,1168,1169,-1,1169,1168,1166,1167,-1,1167,1166,1164,1165,-1,1165,1164,1162,1163,-1,1163,1162,1160,1161,-1,1161,1160,1158,1159,-1,1159,1158,1156,1157,-1,1157,1156,1154,1155,-1,1155,1154,1152,1153,-1,1153,1152,1150,1151,-1,1151,1150,1148,1149,-1,1149,1148,1146,1147,-1,1147,1146,1144,1145,-1,1145,1144,1142,1143,-1,1143,1142,1140,1141,-1,1141,1140,1138,1139,-1,1139,1138,1134,1135,-1,1135,1134,1137,1136,-1,1133,1132,1056,1057,-1,1088,1131,1129,1096,-1,1096,1128,1126,1097,-1,1097,1124,1122,1098,-1,1098,1123,1119,1099,-1,1099,1120,1115,1100,-1,1100,1117,1127,1095,-1,1130,1111,1101,1094,-1,1112,1131,1088,1089,-1,1094,1095,1113,1130,-1,1129,1128,1096,-1,1114,1095,1127,-1,1126,1125,1097,-1,1124,1097,1125,-1,1123,1098,1121,-1,1122,1121,1098,-1,1120,1099,1118,-1,1119,1118,1099,-1,1117,1100,1116,-1,1100,1115,1116,-1,1113,1095,1114,-1,1062,1063,1112,1089,-1,1111,1064,1065,1101,-1,1105,1061,1062,-1,1103,1110,1076,1075,-1,1110,1109,1079,1076,-1,1080,1077,1076,1079,-1,1109,1108,1078,1079,-1,1108,1107,1082,1078,-1,1081,1078,1082,1083,-1,1107,1106,1086,1082,-1,1072,1082,1086,-1,1085,1086,1106,1104,-1,1104,1105,1062,1085,-1,1071,1085,1062,1089,-1,1067,1075,1076,-1,1075,1074,1102,1103,-1,1065,1102,1074,1101,-1,1068,1094,1101,1074,-1,1093,1100,1095,1069,-1,1092,1099,1100,1093,-1,1091,1098,1099,1092,-1,1097,1098,1091,1090,-1,1090,1087,1096,1097,-1,1070,1088,1096,1087,-1,1068,1069,1095,1094,-1,1077,1093,1069,1066,-1,1080,1092,1093,1077,-1,1081,1091,1092,1080,-1,1083,1090,1091,1081,-1,1084,1087,1090,1083,-1,1089,1088,1070,1071,-1,1073,1070,1087,1084,-1,1086,1085,1071,1072,-1,1072,1073,1082,-1,1084,1082,1073,-1,1083,1082,1084,-1,1079,1078,1081,1080,-1,1066,1076,1077,-1,1076,1066,1067,-1,1068,1074,1075,1067,-1,1071,1070,1073,1072,-1,1067,1066,1069,1068,-1,1024,1479,1476,1025,1063,1060,-1,1061,1060,1063,1062,-1,2077,2078,1857,-1,1855,1867,1912,-1,1856,2182,1867,1855,-1,1857,2078,2182,1856,-1,1854,2043,2077,1857,-1,2075,2043,1854,-1,2074,2030,2019,2073,-1,2020,2095,2073,2019,-1,2095,2020,2021,2094,-1,2094,2021,2022,2050,-1,2024,1966,2050,2022,-1,2026,1969,1966,2024,-1,2029,1965,1969,2026,-1,1965,2029,2027,-1,2030,2074,2085,-1,2184,1524,1523,1858,-1,1858,1523,1522,-1,2113,2114,1500,1499,-1,1499,1498,2112,2113,-1,1501,1500,2114,2115,-1,2108,2104,1503,1502,-1,2115,2108,1502,1501,-1,1497,1496,2103,2107,-1,2104,2152,1504,1503,-1,1496,1495,2100,2103,-1,2107,2112,1498,1497,-1,2113,2096,2114,-1,2133,2134,2132,-1,2132,2134,2129,2128,-1,2128,2129,2125,2124,-1,2124,2125,2121,2120,-1,2120,2121,2118,2117,-1,2184,1858,1859,2033,-1,2033,1859,1860,2031,-1,2031,1860,1861,2032,-1,2032,1861,2183,2180,-1,2181,2182,2079,-1,1857,1856,1862,2085,-1,2085,1862,2034,2087,-1,2084,2035,2015,2091,-1,2050,1966,1967,2051,-1,1858,1522,1863,1859,-1,1859,1863,1864,1860,-1,1860,1864,1865,1861,-1,1861,1865,1866,2183,-1,2183,1866,1867,2182,-1,1855,1868,1862,1856,-1,1862,1868,1869,2034,-1,2034,1869,1870,2035,-1,2035,1870,1871,2015,-1,2015,1871,2017,2016,-1,1968,1973,1975,1967,-1,1522,1521,1873,1863,-1,1863,1873,1874,1864,-1,1864,1874,1875,1865,-1,1865,1875,1876,1866,-1,1866,1876,1912,1867,-1,1912,1877,1868,1855,-1,1868,1877,1878,1869,-1,1869,1878,1879,1870,-1,1870,1879,1880,1871,-1,1871,1880,2018,2017,-1,1971,1973,1968,-1,1970,1971,1881,1872,-1,1872,1881,1481,1480,-1,1521,1520,1920,1873,-1,1873,1920,1918,1874,-1,1874,1918,1916,1875,-1,1875,1916,1914,1876,-1,1876,1914,1912,-1,1912,1913,1882,1877,-1,1877,1882,1883,1878,-1,1878,1883,1884,1879,-1,1879,1884,1885,1880,-1,1880,1885,2027,2018,-1,1965,2027,1886,1971,-1,1971,1886,1887,1881,-1,1881,1887,1482,1481,-1,1519,1518,1888,1921,-1,1921,1888,1889,1919,-1,1919,1889,1890,1917,-1,1917,1890,1891,1915,-1,1915,1891,1892,1913,-1,1913,1892,1893,1882,-1,1882,1893,1894,1883,-1,1883,1894,1895,1884,-1,1884,1895,1896,1885,-1,1885,1896,1897,2027,-1,2027,1897,1898,1886,-1,1886,1898,1899,1887,-1,1887,1899,1483,1482,-1,1518,1517,2142,1888,-1,1888,2142,2144,1889,-1,1889,2144,2146,1890,-1,1890,2146,2150,1891,-1,1891,2150,2147,1892,-1,1892,2147,2139,1893,-1,1893,2139,1900,1894,-1,1894,1900,1901,1895,-1,1895,1901,1902,1896,-1,1896,1902,1903,1897,-1,1897,1903,1904,1898,-1,1898,1904,1905,1899,-1,1899,1905,1484,1483,-1,1516,1515,2122,2141,-1,2141,2122,2126,2143,-1,2143,2126,2130,2145,-1,2145,2130,2135,2149,-1,2149,2135,2148,-1,2140,2116,2097,2139,-1,2139,2097,2110,1906,1900,-1,1900,1906,1907,1901,-1,1901,1907,1908,1902,-1,1902,1908,1909,1903,-1,1903,1909,1910,1904,-1,1904,1910,1911,1905,-1,1905,1911,1485,1484,-1,1514,1513,1922,2119,-1,2119,1922,1923,2123,-1,2123,1923,1924,2127,-1,2127,1924,1925,2131,-1,2131,1925,2138,2136,-1,2140,2137,2116,-1,2110,2111,1926,1906,-1,1906,1926,1927,1907,-1,1907,1927,1928,1908,-1,1908,1928,1929,1909,-1,1909,1929,1930,1910,-1,1910,1930,1931,1911,-1,1911,1931,1486,1485,-1,1914,1915,1913,1912,-1,1916,1917,1915,1914,-1,1918,1919,1917,1916,-1,1920,1921,1919,1918,-1,1520,1519,1921,1920,-1,1513,1512,1932,1922,-1,1922,1932,1933,1923,-1,1923,1933,1934,1924,-1,1924,1934,1935,1925,-1,1925,1935,1936,2138,-1,2138,1936,2109,2137,-1,2111,2106,1937,1926,-1,1926,1937,1938,1927,-1,1927,1938,1939,1928,-1,1928,1939,1940,1929,-1,1929,1940,1941,1930,-1,1930,1941,1942,1931,-1,1931,1942,1487,1486,-1,1512,1511,1943,1932,-1,1932,1943,1944,1933,-1,1933,1944,1945,1934,-1,1934,1945,1946,1935,-1,1935,1946,1947,1936,-1,1936,1947,2105,2109,-1,2106,2102,1948,1937,-1,1937,1948,1949,1938,-1,1938,1949,1950,1939,-1,1939,1950,1951,1940,-1,1940,1951,1952,1941,-1,1941,1952,1963,1942,-1,1942,1963,1488,1487,-1,1511,1510,1953,1943,-1,1943,1953,1954,1944,-1,1944,1954,1955,1945,-1,1945,1955,1956,1946,-1,1946,1956,1957,1947,-1,1947,1957,2101,2105,-1,2102,2099,1958,1948,-1,1948,1958,1959,1949,-1,1949,1959,1960,1950,-1,1950,1960,1961,1951,-1,1951,1961,1962,1952,-1,1952,1962,1964,1963,-1,1953,1510,1509,2156,-1,1953,2156,2158,1954,-1,1954,2158,2160,1955,-1,1955,2160,2162,1956,-1,1956,2162,2163,1957,-1,1957,2163,2154,2101,-1,2099,2166,2168,1958,-1,1958,2168,2170,1959,-1,1959,2170,2172,1960,-1,1960,2172,2174,1961,-1,1961,2174,2176,1962,-1,1962,2176,2177,1964,-1,1489,1964,2177,1490,-1,1491,2178,2175,2173,2171,2169,2167,2165,1492,-1,1488,1963,1964,1489,-1,1495,1494,2098,2100,-1,2049,2051,1967,1975,-1,1968,1969,1965,1971,-1,1967,1966,1969,1968,-1,1971,1970,2010,-1,2095,2092,2072,2073,-1,2014,2052,2076,1987,-1,2014,1987,1986,2009,-1,1985,1988,2009,1986,-1,1984,1990,1988,1985,-1,1983,1992,1990,1984,-1,1982,1994,1992,1983,-1,1981,1996,1994,1982,-1,1980,1998,1996,1981,-1,1979,2000,1998,1980,-1,1978,2002,2000,1979,-1,1977,2004,2002,1978,-1,1976,2006,2004,1977,-1,1974,2011,2006,1976,-1,1974,1973,2010,2011,-1,1971,2010,1973,-1,2079,2076,2052,-1,2078,2079,2182,-1,2052,2013,2080,-1,2080,2013,2008,2053,-1,2053,2008,1989,2054,-1,2054,1989,1991,2055,-1,2055,1991,1993,2056,-1,2056,1993,1995,2067,-1,2067,1995,1997,2066,-1,2066,1997,1999,2057,-1,2057,1999,2001,2058,-1,2058,2001,2003,2059,-1,2059,2003,2005,2061,-1,2061,2005,2007,2060,-1,2060,2007,2012,1972,-1,1972,2012,2010,-1,1973,1974,1975,-1,1975,1974,1976,2049,-1,2049,1976,1977,2048,-1,2048,1977,1978,2039,-1,2039,1978,1979,2038,-1,2038,1979,1980,2037,-1,2037,1980,1981,2069,-1,2069,1981,1982,2068,-1,2068,1982,1983,2042,-1,2042,1983,1984,2046,-1,2046,1984,1985,2045,-1,2045,1985,1986,2062,-1,2062,1986,1987,2064,-1,2064,1987,2076,-1,2008,2009,1988,1989,-1,1989,1988,1990,1991,-1,1991,1990,1992,1993,-1,1993,1992,1994,1995,-1,1995,1994,1996,1997,-1,1997,1996,1998,1999,-1,1999,1998,2000,2001,-1,2001,2000,2002,2003,-1,2003,2002,2004,2005,-1,2005,2004,2006,2007,-1,2007,2006,2011,2012,-1,2013,2014,2009,2008,-1,2010,2012,2011,-1,2052,2014,2013,-1,2081,2015,2016,-1,2083,2084,2091,2088,-1,2081,2090,2015,-1,2090,2091,2015,-1,2016,2023,2082,2081,-1,2017,2025,2023,2016,-1,2018,2028,2025,2017,-1,2027,2028,2018,-1,2030,2086,2083,2019,-1,2019,2083,2088,2020,-1,2020,2088,2089,2021,-1,2021,2089,2082,2022,-1,2022,2082,2023,2024,-1,2025,2026,2024,2023,-1,2028,2029,2026,2025,-1,2027,2029,2028,-1,2085,2086,2030,-1,2043,2063,2065,-1,2045,2062,2063,2044,-1,2075,2044,2063,2043,-1,2036,2071,2075,2072,-1,2039,2038,2040,2041,-1,2087,2034,2035,2084,-1,1854,2085,2074,2075,-1,1857,2085,1854,-1,2080,2179,2052,-1,2069,2071,2036,2037,-1,2040,2036,2072,2092,-1,2037,2036,2040,2038,-1,2093,2048,2039,2041,-1,2040,2092,2041,-1,2041,2092,2093,-1,2046,2047,2042,-1,2075,2047,2044,-1,2070,2047,2075,-1,2068,2042,2047,2070,-1,2065,2077,2043,-1,2045,2044,2047,2046,-1,2093,2051,2049,2048,-1,2094,2050,2051,2093,-1,2052,2179,2079,-1,2064,2065,2063,2062,-1,2076,2077,2065,2064,-1,2070,2071,2069,2068,-1,2075,2071,2070,-1,2073,2072,2075,2074,-1,2077,2076,2079,2078,-1,2090,2081,2082,2089,-1,2086,2087,2084,2083,-1,2085,2087,2086,-1,2089,2088,2091,2090,-1,2093,2092,2095,2094,-1,2153,2164,2161,2159,2157,2155,1508,1507,-1,2096,2113,2110,2097,-1,2114,2096,2097,2116,-1,1493,2166,2098,1494,-1,1505,2151,2154,1506,-1,2166,2099,2100,2098,-1,2151,2152,2101,2154,-1,2099,2102,2103,2100,-1,2152,2104,2105,2101,-1,2102,2106,2107,2103,-1,2104,2108,2109,2105,-1,2106,2111,2112,2107,-1,2108,2115,2137,2109,-1,2111,2110,2113,2112,-1,2115,2114,2116,2137,-1,2133,2136,2140,-1,2133,2140,2148,-1,1514,2119,2120,2117,-1,2118,2121,2122,1515,-1,2119,2123,2124,2120,-1,2121,2125,2126,2122,-1,2123,2127,2128,2124,-1,2125,2129,2130,2126,-1,2127,2131,2132,2128,-1,2129,2134,2135,2130,-1,2131,2136,2133,2132,-1,2134,2133,2148,2135,-1,2140,2136,2138,2137,-1,2139,2147,2148,2140,-1,2141,2142,1517,1516,-1,2143,2144,2142,2141,-1,2145,2146,2144,2143,-1,2149,2150,2146,2145,-1,2148,2147,2150,2149,-1,2152,2151,1505,1504,-1,2163,2164,2153,2154,-1,2154,2153,1507,1506,-1,1509,1508,2155,2156,-1,2156,2155,2157,2158,-1,2158,2157,2159,2160,-1,2160,2159,2161,2162,-1,2162,2161,2164,2163,-1,2177,2178,1491,1490,-1,1493,1492,2165,2166,-1,2166,2165,2167,2168,-1,2168,2167,2169,2170,-1,2170,2169,2171,2172,-1,2172,2171,2173,2174,-1,2174,2173,2175,2176,-1,2176,2175,2178,2177,-1,2181,2180,2183,2182,-1,1634,1688,1677,1633,-1,1688,1634,1612,1687,-1,1613,1686,1687,1612,-1,1657,1685,1686,1613,-1,1685,1657,1741,1683,-1,1683,1741,1738,1681,-1,1681,1738,1742,1678,-1,1680,1678,1742,-1,1622,1633,1677,-1,1849,1523,1524,1525,-1,1522,1523,1849,-1,1499,1500,1593,1594,-1,1594,1595,1498,1499,-1,1592,1593,1500,1501,-1,1502,1503,1603,1599,-1,1501,1502,1599,1592,-1,1600,1604,1496,1497,-1,1503,1504,1557,1603,-1,1604,1607,1495,1496,-1,1497,1498,1595,1600,-1,1593,1611,1594,-1,1577,1575,1576,-1,1581,1580,1575,1577,-1,1585,1584,1580,1581,-1,1589,1588,1584,1585,-1,2117,2118,1588,1589,-1,1674,1848,1849,1525,-1,1676,1847,1848,1674,-1,1675,1846,1847,1676,-1,1529,1526,1846,1675,-1,1628,1527,1528,-1,1622,1845,1851,1850,-1,1620,1673,1845,1622,-1,1616,1692,1672,1623,-1,1656,1740,1741,1657,-1,1848,1844,1522,1849,-1,1847,1843,1844,1848,-1,1846,1842,1843,1847,-1,1526,1841,1842,1846,-1,1527,1840,1841,1526,-1,1851,1845,1839,1852,-1,1673,1838,1839,1845,-1,1672,1837,1838,1673,-1,1692,1836,1837,1672,-1,1691,1690,1836,1692,-1,1740,1732,1734,1739,-1,1844,1834,1521,1522,-1,1843,1833,1834,1844,-1,1842,1832,1833,1843,-1,1841,1831,1832,1842,-1,1840,1795,1831,1841,-1,1852,1839,1830,1795,-1,1838,1829,1830,1839,-1,1837,1828,1829,1838,-1,1836,1827,1828,1837,-1,1690,1689,1827,1836,-1,1739,1734,1736,-1,1835,1826,1736,1737,-1,1480,1481,1826,1835,-1,1834,1787,1520,1521,-1,1833,1789,1787,1834,-1,1832,1791,1789,1833,-1,1831,1793,1791,1832,-1,1795,1793,1831,-1,1830,1825,1794,1795,-1,1829,1824,1825,1830,-1,1828,1823,1824,1829,-1,1827,1822,1823,1828,-1,1689,1680,1822,1827,-1,1736,1821,1680,1742,-1,1826,1820,1821,1736,-1,1481,1482,1820,1826,-1,1786,1819,1518,1519,-1,1788,1818,1819,1786,-1,1790,1817,1818,1788,-1,1792,1816,1817,1790,-1,1794,1815,1816,1792,-1,1825,1814,1815,1794,-1,1824,1813,1814,1825,-1,1823,1812,1813,1824,-1,1822,1811,1812,1823,-1,1680,1810,1811,1822,-1,1821,1809,1810,1680,-1,1820,1808,1809,1821,-1,1482,1483,1808,1820,-1,1819,1567,1517,1518,-1,1818,1565,1567,1819,-1,1817,1563,1565,1818,-1,1816,1559,1563,1817,-1,1815,1562,1559,1816,-1,1814,1570,1562,1815,-1,1813,1807,1570,1814,-1,1812,1806,1807,1813,-1,1811,1805,1806,1812,-1,1810,1804,1805,1811,-1,1809,1803,1804,1810,-1,1808,1802,1803,1809,-1,1483,1484,1802,1808,-1,1568,1587,1515,1516,-1,1566,1583,1587,1568,-1,1564,1579,1583,1566,-1,1560,1574,1579,1564,-1,1561,1574,1560,-1,1570,1610,1591,1569,-1,1807,1801,1597,1610,1570,-1,1806,1800,1801,1807,-1,1805,1799,1800,1806,-1,1804,1798,1799,1805,-1,1803,1797,1798,1804,-1,1802,1796,1797,1803,-1,1484,1485,1796,1802,-1,1590,1785,1513,1514,-1,1586,1784,1785,1590,-1,1582,1783,1784,1586,-1,1578,1782,1783,1582,-1,1573,1571,1782,1578,-1,1591,1572,1569,-1,1801,1781,1596,1597,-1,1800,1780,1781,1801,-1,1799,1779,1780,1800,-1,1798,1778,1779,1799,-1,1797,1777,1778,1798,-1,1796,1776,1777,1797,-1,1485,1486,1776,1796,-1,1795,1794,1792,1793,-1,1793,1792,1790,1791,-1,1791,1790,1788,1789,-1,1789,1788,1786,1787,-1,1787,1786,1519,1520,-1,1785,1775,1512,1513,-1,1784,1774,1775,1785,-1,1783,1773,1774,1784,-1,1782,1772,1773,1783,-1,1571,1771,1772,1782,-1,1572,1598,1771,1571,-1,1781,1770,1601,1596,-1,1780,1769,1770,1781,-1,1779,1768,1769,1780,-1,1778,1767,1768,1779,-1,1777,1766,1767,1778,-1,1776,1765,1766,1777,-1,1486,1487,1765,1776,-1,1775,1764,1511,1512,-1,1774,1763,1764,1775,-1,1773,1762,1763,1774,-1,1772,1761,1762,1773,-1,1771,1760,1761,1772,-1,1598,1602,1760,1771,-1,1770,1759,1605,1601,-1,1769,1758,1759,1770,-1,1768,1757,1758,1769,-1,1767,1756,1757,1768,-1,1766,1755,1756,1767,-1,1765,1744,1755,1766,-1,1487,1488,1744,1765,-1,1764,1754,1510,1511,-1,1763,1753,1754,1764,-1,1762,1752,1753,1763,-1,1761,1751,1752,1762,-1,1760,1750,1751,1761,-1,1602,1606,1750,1760,-1,1759,1749,1608,1605,-1,1758,1748,1749,1759,-1,1757,1747,1748,1758,-1,1756,1746,1747,1757,-1,1755,1745,1746,1756,-1,1744,1743,1745,1755,-1,1553,1509,1510,1754,-1,1753,1551,1553,1754,-1,1752,1549,1551,1753,-1,1751,1547,1549,1752,-1,1750,1546,1547,1751,-1,1606,1555,1546,1750,-1,1749,1541,1543,1608,-1,1748,1539,1541,1749,-1,1747,1537,1539,1748,-1,1746,1535,1537,1747,-1,1745,1533,1535,1746,-1,1743,1532,1533,1745,-1,1490,1532,1743,1489,-1,1492,1544,1542,1540,1538,1536,1534,1531,1491,-1,1489,1743,1744,1488,-1,1607,1609,1494,1495,-1,1732,1740,1656,1658,-1,1736,1742,1738,1739,-1,1739,1738,1741,1740,-1,1697,1737,1736,-1,1634,1635,1615,1612,-1,1720,1631,1655,1693,-1,1698,1721,1720,1693,-1,1721,1698,1719,1722,-1,1722,1719,1717,1723,-1,1723,1717,1715,1724,-1,1724,1715,1713,1725,-1,1725,1713,1711,1726,-1,1726,1711,1709,1727,-1,1727,1709,1707,1728,-1,1728,1707,1705,1729,-1,1729,1705,1703,1730,-1,1730,1703,1701,1731,-1,1731,1701,1696,1733,-1,1696,1697,1734,1733,-1,1734,1697,1736,-1,1655,1631,1628,-1,1527,1628,1629,-1,1627,1694,1655,-1,1654,1699,1694,1627,-1,1653,1718,1699,1654,-1,1652,1716,1718,1653,-1,1651,1714,1716,1652,-1,1640,1712,1714,1651,-1,1641,1710,1712,1640,-1,1650,1708,1710,1641,-1,1649,1706,1708,1650,-1,1648,1704,1706,1649,-1,1646,1702,1704,1648,-1,1647,1700,1702,1646,-1,1735,1695,1700,1647,-1,1697,1695,1735,-1,1732,1733,1734,-1,1658,1731,1733,1732,-1,1659,1730,1731,1658,-1,1668,1729,1730,1659,-1,1669,1728,1729,1668,-1,1670,1727,1728,1669,-1,1638,1726,1727,1670,-1,1639,1725,1726,1638,-1,1665,1724,1725,1639,-1,1661,1723,1724,1665,-1,1662,1722,1723,1661,-1,1645,1721,1722,1662,-1,1643,1720,1721,1645,-1,1631,1720,1643,-1,1718,1719,1698,1699,-1,1716,1717,1719,1718,-1,1714,1715,1717,1716,-1,1712,1713,1715,1714,-1,1710,1711,1713,1712,-1,1708,1709,1711,1710,-1,1706,1707,1709,1708,-1,1704,1705,1707,1706,-1,1702,1703,1705,1704,-1,1700,1701,1703,1702,-1,1695,1696,1701,1700,-1,1699,1698,1693,1694,-1,1696,1695,1697,-1,1694,1693,1655,-1,1691,1692,1626,-1,1619,1616,1623,1624,-1,1692,1617,1626,-1,1692,1616,1617,-1,1626,1625,1684,1691,-1,1691,1684,1682,1690,-1,1690,1682,1679,1689,-1,1689,1679,1680,-1,1688,1624,1621,1677,-1,1687,1619,1624,1688,-1,1686,1618,1619,1687,-1,1685,1625,1618,1686,-1,1683,1684,1625,1685,-1,1684,1683,1681,1682,-1,1682,1681,1678,1679,-1,1679,1678,1680,-1,1677,1621,1622,-1,1642,1644,1664,-1,1663,1644,1645,1662,-1,1664,1644,1663,1632,-1,1635,1632,1636,1671,-1,1666,1667,1669,1668,-1,1623,1672,1673,1620,-1,1632,1633,1622,1853,-1,1853,1622,1850,-1,1655,1530,1627,-1,1670,1671,1636,1638,-1,1615,1635,1671,1667,-1,1669,1667,1671,1670,-1,1666,1668,1659,1614,-1,1666,1615,1667,-1,1614,1615,1666,-1,1665,1660,1661,-1,1663,1660,1632,-1,1632,1660,1637,-1,1637,1660,1665,1639,-1,1664,1630,1642,-1,1661,1660,1663,1662,-1,1659,1658,1656,1614,-1,1614,1656,1657,1613,-1,1628,1530,1655,-1,1645,1644,1642,1643,-1,1643,1642,1630,1631,-1,1639,1638,1636,1637,-1,1637,1636,1632,-1,1633,1632,1635,1634,-1,1629,1628,1631,1630,-1,1618,1625,1626,1617,-1,1624,1623,1620,1621,-1,1621,1620,1622,-1,1617,1616,1619,1618,-1,1613,1612,1615,1614,-1,1507,1508,1554,1552,1550,1548,1545,1556,-1,1610,1597,1594,1611,-1,1591,1610,1611,1593,-1,1494,1609,1543,1493,-1,1506,1555,1558,1505,-1,1609,1607,1608,1543,-1,1555,1606,1557,1558,-1,1607,1604,1605,1608,-1,1606,1602,1603,1557,-1,1604,1600,1601,1605,-1,1602,1598,1599,1603,-1,1600,1595,1596,1601,-1,1598,1572,1592,1599,-1,1595,1594,1597,1596,-1,1572,1591,1593,1592,-1,1569,1573,1576,-1,1561,1569,1576,-1,2117,1589,1590,1514,-1,1515,1587,1588,2118,-1,1589,1585,1586,1590,-1,1587,1583,1584,1588,-1,1585,1581,1582,1586,-1,1583,1579,1580,1584,-1,1581,1577,1578,1582,-1,1579,1574,1575,1580,-1,1577,1576,1573,1578,-1,1574,1561,1576,1575,-1,1572,1571,1573,1569,-1,1569,1561,1562,1570,-1,1516,1517,1567,1568,-1,1568,1567,1565,1566,-1,1566,1565,1563,1564,-1,1564,1563,1559,1560,-1,1560,1559,1562,1561,-1,1504,1505,1558,1557,-1,1555,1556,1545,1546,-1,1506,1507,1556,1555,-1,1553,1554,1508,1509,-1,1551,1552,1554,1553,-1,1549,1550,1552,1551,-1,1547,1548,1550,1549,-1,1546,1545,1548,1547,-1,1490,1491,1531,1532,-1,1543,1544,1492,1493,-1,1541,1542,1544,1543,-1,1539,1540,1542,1541,-1,1537,1538,1540,1539,-1,1535,1536,1538,1537,-1,1533,1534,1536,1535,-1,1532,1531,1534,1533,-1,1527,1526,1529,1528,-1,1853,1664,1632,-1,1850,1630,1664,1853,-1,1851,1527,1629,1850,-1,1852,1840,1527,1851,-1,1795,1840,1852,-1,1850,1629,1630,-1,2188,2187,2186,2185,-1,2187,2190,2189,2186,-1,2190,2192,2191,2189,-1,2192,2194,2193,2191,-1,2194,2196,2195,2193,-1,2196,2198,2197,2195,-1,2198,2200,2199,2197,-1,2200,2202,2201,2199,-1,2202,2204,2203,2201,-1,2204,2206,2205,2203,-1,2206,2208,2207,2205,-1,2208,2210,2209,2207,-1,2210,2212,2211,2209,-1,2212,2214,2213,2211,-1,2214,2216,2215,2213,-1,2216,2218,2217,2215,-1,2218,2220,2219,2217,-1,2220,2222,2221,2219,-1,2222,2224,2223,2221,-1,2224,2226,2225,2223,-1,2226,2228,2227,2225,-1,2228,2230,2229,2227,-1,2230,2232,2231,2229,-1,2232,2234,2233,2231,-1,2234,2236,2235,2233,-1,2236,2238,2237,2235,-1,2238,2240,2239,2237,-1,2240,2242,2241,2239,-1,2242,2244,2243,2241,-1,2244,2246,2245,2243,-1,2246,2248,2247,2245,-1,2248,2250,2249,2247,-1,2250,2252,2251,2249,-1,2252,2254,2253,2251,-1,2254,2256,2255,2253,-1,2256,2188,2185,2255,-1,2292,2291,2290,2289,2288,2287,2286,2285,2284,2283,2282,2281,2280,2279,2278,2277,2276,2275,2274,2273,2272,2271,2270,2269,2268,2267,2266,2265,2264,2263,2262,2261,2260,2259,2258,2257,-1,2328,2327,2326,2325,2324,2323,2322,2321,2320,2319,2318,2317,2316,2315,2314,2313,2312,2311,2310,2309,2308,2307,2306,2305,2304,2303,2302,2301,2300,2299,2298,2297,2296,2295,2294,2293,-1,2185,2293,2294,2255,-1,2186,2328,2293,2185,-1,2189,2327,2328,2186,-1,2191,2326,2327,2189,-1,2193,2325,2326,2191,-1,2195,2324,2325,2193,-1,2197,2323,2324,2195,-1,2199,2322,2323,2197,-1,2201,2321,2322,2199,-1,2203,2320,2321,2201,-1,2205,2319,2320,2203,-1,2207,2318,2319,2205,-1,2209,2317,2318,2207,-1,2211,2316,2317,2209,-1,2213,2315,2316,2211,-1,2215,2314,2315,2213,-1,2217,2313,2314,2215,-1,2219,2312,2313,2217,-1,2221,2311,2312,2219,-1,2223,2310,2311,2221,-1,2225,2309,2310,2223,-1,2227,2308,2309,2225,-1,2229,2307,2308,2227,-1,2231,2306,2307,2229,-1,2233,2305,2306,2231,-1,2235,2304,2305,2233,-1,2237,2303,2304,2235,-1,2239,2302,2303,2237,-1,2241,2301,2302,2239,-1,2243,2300,2301,2241,-1,2245,2299,2300,2243,-1,2247,2298,2299,2245,-1,2249,2297,2298,2247,-1,2251,2296,2297,2249,-1,2253,2295,2296,2251,-1,2255,2294,2295,2253,-1,2188,2330,2329,2187,-1,2256,2331,2330,2188,-1,2254,2332,2331,2256,-1,2252,2333,2332,2254,-1,2250,2334,2333,2252,-1,2248,2335,2334,2250,-1,2246,2336,2335,2248,-1,2244,2337,2336,2246,-1,2242,2338,2337,2244,-1,2240,2339,2338,2242,-1,2238,2340,2339,2240,-1,2236,2341,2340,2238,-1,2234,2342,2341,2236,-1,2232,2343,2342,2234,-1,2230,2344,2343,2232,-1,2228,2345,2344,2230,-1,2226,2346,2345,2228,-1,2224,2347,2346,2226,-1,2222,2348,2347,2224,-1,2220,2349,2348,2222,-1,2218,2350,2349,2220,-1,2216,2351,2350,2218,-1,2214,2352,2351,2216,-1,2212,2353,2352,2214,-1,2210,2354,2353,2212,-1,2208,2355,2354,2210,-1,2206,2356,2355,2208,-1,2204,2357,2356,2206,-1,2202,2358,2357,2204,-1,2200,2359,2358,2202,-1,2198,2360,2359,2200,-1,2196,2361,2360,2198,-1,2194,2362,2361,2196,-1,2192,2363,2362,2194,-1,2190,2364,2363,2192,-1,2187,2329,2364,2190,-1,2330,2366,2365,2329,-1,2331,2367,2366,2330,-1,2332,2368,2367,2331,-1,2333,2369,2368,2332,-1,2334,2370,2369,2333,-1,2335,2371,2370,2334,-1,2336,2372,2371,2335,-1,2337,2373,2372,2336,-1,2338,2374,2373,2337,-1,2339,2375,2374,2338,-1,2340,2376,2375,2339,-1,2341,2377,2376,2340,-1,2342,2378,2377,2341,-1,2343,2379,2378,2342,-1,2344,2380,2379,2343,-1,2345,2381,2380,2344,-1,2346,2382,2381,2345,-1,2347,2383,2382,2346,-1,2348,2384,2383,2347,-1,2349,2385,2384,2348,-1,2350,2386,2385,2349,-1,2351,2387,2386,2350,-1,2352,2388,2387,2351,-1,2353,2389,2388,2352,-1,2354,2390,2389,2353,-1,2355,2391,2390,2354,-1,2356,2392,2391,2355,-1,2357,2393,2392,2356,-1,2358,2394,2393,2357,-1,2359,2395,2394,2358,-1,2360,2396,2395,2359,-1,2361,2397,2396,2360,-1,2362,2398,2397,2361,-1,2363,2399,2398,2362,-1,2364,2400,2399,2363,-1,2329,2365,2400,2364,-1,2366,2402,2401,2365,-1,2367,2403,2402,2366,-1,2368,2404,2403,2367,-1,2369,2405,2404,2368,-1,2370,2406,2405,2369,-1,2371,2407,2406,2370,-1,2372,2408,2407,2371,-1,2373,2409,2408,2372,-1,2374,2410,2409,2373,-1,2375,2411,2410,2374,-1,2376,2412,2411,2375,-1,2377,2413,2412,2376,-1,2378,2414,2413,2377,-1,2379,2415,2414,2378,-1,2380,2416,2415,2379,-1,2381,2417,2416,2380,-1,2382,2418,2417,2381,-1,2383,2419,2418,2382,-1,2384,2420,2419,2383,-1,2385,2421,2420,2384,-1,2386,2422,2421,2385,-1,2387,2423,2422,2386,-1,2388,2424,2423,2387,-1,2389,2425,2424,2388,-1,2390,2426,2425,2389,-1,2391,2427,2426,2390,-1,2392,2428,2427,2391,-1,2393,2429,2428,2392,-1,2394,2430,2429,2393,-1,2395,2431,2430,2394,-1,2396,2432,2431,2395,-1,2397,2433,2432,2396,-1,2398,2434,2433,2397,-1,2399,2435,2434,2398,-1,2400,2436,2435,2399,-1,2365,2401,2436,2400,-1,2402,2257,2258,2401,-1,2403,2292,2257,2402,-1,2404,2291,2292,2403,-1,2405,2290,2291,2404,-1,2406,2289,2290,2405,-1,2407,2288,2289,2406,-1,2408,2287,2288,2407,-1,2409,2286,2287,2408,-1,2410,2285,2286,2409,-1,2411,2284,2285,2410,-1,2412,2283,2284,2411,-1,2413,2282,2283,2412,-1,2414,2281,2282,2413,-1,2415,2280,2281,2414,-1,2416,2279,2280,2415,-1,2417,2278,2279,2416,-1,2418,2277,2278,2417,-1,2419,2276,2277,2418,-1,2420,2275,2276,2419,-1,2421,2274,2275,2420,-1,2422,2273,2274,2421,-1,2423,2272,2273,2422,-1,2424,2271,2272,2423,-1,2425,2270,2271,2424,-1,2426,2269,2270,2425,-1,2427,2268,2269,2426,-1,2428,2267,2268,2427,-1,2429,2266,2267,2428,-1,2430,2265,2266,2429,-1,2431,2264,2265,2430,-1,2432,2263,2264,2431,-1,2433,2262,2263,2432,-1,2434,2261,2262,2433,-1,2435,2260,2261,2434,-1,2436,2259,2260,2435,-1,2401,2258,2259,2436,-1,2440,2439,2438,2437,-1,2439,2442,2441,2438,-1,2442,2444,2443,2441,-1,2444,2446,2445,2443,-1,2446,2448,2447,2445,-1,2448,2450,2449,2447,-1,2450,2452,2451,2449,-1,2452,2454,2453,2451,-1,2454,2456,2455,2453,-1,2456,2458,2457,2455,-1,2458,2460,2459,2457,-1,2460,2462,2461,2459,-1,2462,2464,2463,2461,-1,2464,2466,2465,2463,-1,2466,2468,2467,2465,-1,2468,2470,2469,2467,-1,2470,2472,2471,2469,-1,2472,2474,2473,2471,-1,2474,2476,2475,2473,-1,2476,2478,2477,2475,-1,2478,2480,2479,2477,-1,2480,2482,2481,2479,-1,2482,2484,2483,2481,-1,2484,2486,2485,2483,-1,2486,2488,2487,2485,-1,2488,2490,2489,2487,-1,2490,2492,2491,2489,-1,2492,2494,2493,2491,-1,2494,2496,2495,2493,-1,2496,2498,2497,2495,-1,2498,2500,2499,2497,-1,2500,2502,2501,2499,-1,2502,2504,2503,2501,-1,2504,2506,2505,2503,-1,2506,2508,2507,2505,-1,2508,2440,2437,2507,-1,2544,2543,2542,2541,2540,2539,2538,2537,2536,2535,2534,2533,2532,2531,2530,2529,2528,2527,2526,2525,2524,2523,2522,2521,2520,2519,2518,2517,2516,2515,2514,2513,2512,2511,2510,2509,-1,2580,2579,2578,2577,2576,2575,2574,2573,2572,2571,2570,2569,2568,2567,2566,2565,2564,2563,2562,2561,2560,2559,2558,2557,2556,2555,2554,2553,2552,2551,2550,2549,2548,2547,2546,2545,-1,2508,2579,2580,2440,-1,2440,2580,2545,2439,-1,2439,2545,2546,2442,-1,2442,2546,2547,2444,-1,2444,2547,2548,2446,-1,2446,2548,2549,2448,-1,2448,2549,2550,2450,-1,2450,2550,2551,2452,-1,2452,2551,2552,2454,-1,2454,2552,2553,2456,-1,2456,2553,2554,2458,-1,2458,2554,2555,2460,-1,2460,2555,2556,2462,-1,2462,2556,2557,2464,-1,2464,2557,2558,2466,-1,2466,2558,2559,2468,-1,2468,2559,2560,2470,-1,2470,2560,2561,2472,-1,2472,2561,2562,2474,-1,2474,2562,2563,2476,-1,2476,2563,2564,2478,-1,2478,2564,2565,2480,-1,2480,2565,2566,2482,-1,2482,2566,2567,2484,-1,2484,2567,2568,2486,-1,2486,2568,2569,2488,-1,2488,2569,2570,2490,-1,2490,2570,2571,2492,-1,2492,2571,2572,2494,-1,2494,2572,2573,2496,-1,2496,2573,2574,2498,-1,2498,2574,2575,2500,-1,2500,2575,2576,2502,-1,2502,2576,2577,2504,-1,2504,2577,2578,2506,-1,2506,2578,2579,2508,-1,2438,2582,2581,2437,-1,2437,2581,2583,2507,-1,2507,2583,2584,2505,-1,2505,2584,2585,2503,-1,2503,2585,2586,2501,-1,2501,2586,2587,2499,-1,2499,2587,2588,2497,-1,2497,2588,2589,2495,-1,2495,2589,2590,2493,-1,2493,2590,2591,2491,-1,2491,2591,2592,2489,-1,2489,2592,2593,2487,-1,2487,2593,2594,2485,-1,2485,2594,2595,2483,-1,2483,2595,2596,2481,-1,2481,2596,2597,2479,-1,2479,2597,2598,2477,-1,2477,2598,2599,2475,-1,2475,2599,2600,2473,-1,2473,2600,2601,2471,-1,2471,2601,2602,2469,-1,2469,2602,2603,2467,-1,2467,2603,2604,2465,-1,2465,2604,2605,2463,-1,2463,2605,2606,2461,-1,2461,2606,2607,2459,-1,2459,2607,2608,2457,-1,2457,2608,2609,2455,-1,2455,2609,2610,2453,-1,2453,2610,2611,2451,-1,2451,2611,2612,2449,-1,2449,2612,2613,2447,-1,2447,2613,2614,2445,-1,2445,2614,2615,2443,-1,2443,2615,2616,2441,-1,2441,2616,2582,2438,-1,2582,2618,2617,2581,-1,2581,2617,2619,2583,-1,2583,2619,2620,2584,-1,2584,2620,2621,2585,-1,2585,2621,2622,2586,-1,2586,2622,2623,2587,-1,2587,2623,2624,2588,-1,2588,2624,2625,2589,-1,2589,2625,2626,2590,-1,2590,2626,2627,2591,-1,2591,2627,2628,2592,-1,2592,2628,2629,2593,-1,2593,2629,2630,2594,-1,2594,2630,2631,2595,-1,2595,2631,2632,2596,-1,2596,2632,2633,2597,-1,2597,2633,2634,2598,-1,2598,2634,2635,2599,-1,2599,2635,2636,2600,-1,2600,2636,2637,2601,-1,2601,2637,2638,2602,-1,2602,2638,2639,2603,-1,2603,2639,2640,2604,-1,2604,2640,2641,2605,-1,2605,2641,2642,2606,-1,2606,2642,2643,2607,-1,2607,2643,2644,2608,-1,2608,2644,2645,2609,-1,2609,2645,2646,2610,-1,2610,2646,2647,2611,-1,2611,2647,2648,2612,-1,2612,2648,2649,2613,-1,2613,2649,2650,2614,-1,2614,2650,2651,2615,-1,2615,2651,2652,2616,-1,2616,2652,2618,2582,-1,2618,2654,2653,2617,-1,2617,2653,2655,2619,-1,2619,2655,2656,2620,-1,2620,2656,2657,2621,-1,2621,2657,2658,2622,-1,2622,2658,2659,2623,-1,2623,2659,2660,2624,-1,2624,2660,2661,2625,-1,2625,2661,2662,2626,-1,2626,2662,2663,2627,-1,2627,2663,2664,2628,-1,2628,2664,2665,2629,-1,2629,2665,2666,2630,-1,2630,2666,2667,2631,-1,2631,2667,2668,2632,-1,2632,2668,2669,2633,-1,2633,2669,2670,2634,-1,2634,2670,2671,2635,-1,2635,2671,2672,2636,-1,2636,2672,2673,2637,-1,2637,2673,2674,2638,-1,2638,2674,2675,2639,-1,2639,2675,2676,2640,-1,2640,2676,2677,2641,-1,2641,2677,2678,2642,-1,2642,2678,2679,2643,-1,2643,2679,2680,2644,-1,2644,2680,2681,2645,-1,2645,2681,2682,2646,-1,2646,2682,2683,2647,-1,2647,2683,2684,2648,-1,2648,2684,2685,2649,-1,2649,2685,2686,2650,-1,2650,2686,2687,2651,-1,2651,2687,2688,2652,-1,2652,2688,2654,2618,-1,2654,2543,2544,2653,-1,2653,2544,2509,2655,-1,2655,2509,2510,2656,-1,2656,2510,2511,2657,-1,2657,2511,2512,2658,-1,2658,2512,2513,2659,-1,2659,2513,2514,2660,-1,2660,2514,2515,2661,-1,2661,2515,2516,2662,-1,2662,2516,2517,2663,-1,2663,2517,2518,2664,-1,2664,2518,2519,2665,-1,2665,2519,2520,2666,-1,2666,2520,2521,2667,-1,2667,2521,2522,2668,-1,2668,2522,2523,2669,-1,2669,2523,2524,2670,-1,2670,2524,2525,2671,-1,2671,2525,2526,2672,-1,2672,2526,2527,2673,-1,2673,2527,2528,2674,-1,2674,2528,2529,2675,-1,2675,2529,2530,2676,-1,2676,2530,2531,2677,-1,2677,2531,2532,2678,-1,2678,2532,2533,2679,-1,2679,2533,2534,2680,-1,2680,2534,2535,2681,-1,2681,2535,2536,2682,-1,2682,2536,2537,2683,-1,2683,2537,2538,2684,-1,2684,2538,2539,2685,-1,2685,2539,2540,2686,-1,2686,2540,2541,2687,-1,2687,2541,2542,2688,-1,2688,2542,2543,2654,-1,2692,2691,2690,2689,-1,2696,2695,2694,2693,-1,2698,2697,2695,2696,-1,2700,2699,2697,2698,-1,2702,2701,2699,2700,-1,2704,2703,2701,2702,-1,2706,2705,2703,2704,-1,2708,2707,2705,2706,-1,2712,2711,2710,2709,-1,2709,2710,2714,2713,-1,2713,2714,2716,2715,-1,2715,2716,2718,2717,-1,2717,2718,2707,2708,-1,2722,2721,2720,2719,-1,2724,2723,2721,2722,-1,2726,2725,2723,2724,-1,2730,2729,2728,2727,-1,2732,2731,2729,2730,-1,2734,2733,2731,2732,-1,2736,2735,2733,2734,-1,2738,2737,2735,2736,-1,2740,2739,2737,2738,-1,2744,2743,2742,2741,-1,2746,2745,2743,2744,-1,2748,2747,2745,2746,-1,2750,2749,2747,2748,-1,2752,2751,2749,2750,-1,2741,2742,2754,2753,-1,2753,2754,2756,2755,-1,2755,2756,2758,2757,-1,2757,2758,2760,2759,-1,2759,2760,2762,2761,-1,2761,2762,2764,2763,-1,2763,2764,2766,2765,-1,2770,2769,2768,2767,-1,2772,2771,2769,2770,-1,2774,2773,2771,2772,-1,2776,2775,2773,2774,-1,2778,2777,2775,2776,-1,2767,2768,2780,2779,-1,2779,2780,2782,2781,-1,2781,2782,2784,2783,-1,2783,2784,2786,2785,-1,2785,2786,2788,2787,-1,2787,2788,2790,2789,-1,2789,2790,2792,2791,-1,2719,2720,2793,-1,2777,2778,2794,-1,2751,2752,2795,-1,2711,2712,2796,-1,2693,2694,2797,-1,2765,2766,2798,-1,2739,2740,2799,-1,2791,2792,2800,-1,2689,2690,2725,2726,-1,2691,2692,2727,2728,-1,2803,2802,2801,-1,2801,2802,2804,-1,2804,2802,2805,-1,2807,2805,2806,-1,2809,2808,2805,2807,-1,2811,2810,2808,2809,-1,2812,2810,2811,-1,2815,2814,2813,-1,2818,2817,2816,-1,2820,2819,2817,2818,-1,2821,2819,2820,-1,2822,2803,2819,2821,-1,2823,2802,2803,2822,-1,2824,2802,2823,-1,2825,2802,2824,-1,2826,2802,2825,-1,2827,2802,2826,-1,2828,2802,2827,-1,2829,2805,2802,2828,-1,2830,2805,2829,-1,2806,2805,2830,-1,2832,2816,2817,2831,-1,2804,2834,2833,2801,-1,2836,2810,2812,2835,-1,2838,2833,2834,2837,-1,2841,2840,2839,2837,-1,2794,2793,2842,-1,2838,2813,2814,2843,-1,2837,2839,2813,2838,-1,2831,2838,2843,2832,-1,2835,2841,2837,2836,-1,2803,2801,2817,2819,-1,2801,2833,2831,2817,-1,2833,2838,2831,-1,2804,2805,2808,2810,-1,2836,2837,2834,-1,2804,2810,2836,2834,-1,2847,2846,2845,2844,-1,2821,2820,2846,2847,-1,2851,2850,2849,2848,-1,2855,2854,2853,2852,-1,2852,2853,2850,2851,-1,2858,2857,2856,-1,2848,2849,2860,2859,-1,2859,2860,2862,2861,-1,2861,2862,2857,2858,-1,2865,2864,2863,-1,2863,2868,2867,2866,-1,2866,2867,2870,2869,-1,2869,2870,2872,2871,-1,2871,2872,2874,2873,-1,2873,2874,2876,2875,-1,2875,2876,2878,2877,-1,2877,2878,2880,2879,-1,2884,2883,2882,2881,-1,2881,2882,2886,2885,-1,2885,2886,2888,2887,-1,2887,2888,2890,2889,-1,2889,2890,2892,2891,-1,2891,2892,2894,2893,-1,2893,2894,2896,2895,-1,2895,2896,2898,2897,-1,2897,2898,2827,2826,-1,2879,2880,2809,2807,-1,2901,2900,2899,-1,2899,2900,2903,2902,-1,2902,2903,2905,2904,-1,2904,2905,2906,-1,2824,2908,2907,-1,2907,2908,2910,2909,-1,2909,2910,2912,2911,-1,2911,2912,2914,2913,-1,2913,2914,2916,2915,-1,2915,2916,2918,2917,-1,2917,2918,2920,2919,-1,2919,2920,2922,2921,-1,2921,2922,2924,2923,-1,2928,2927,2926,2925,-1,2925,2926,2930,2929,-1,2929,2930,2932,2931,-1,2931,2932,2934,2933,-1,2933,2934,2936,2935,-1,2935,2936,2938,2937,-1,2937,2938,2940,2939,-1,2939,2940,2942,2941,-1,2941,2942,2829,2828,-1,2806,2830,2944,2943,-1,2943,2944,2946,2945,-1,2945,2946,2948,2947,-1,2947,2948,2950,2949,-1,2949,2950,2952,2951,-1,2951,2952,2954,2953,-1,2953,2954,2956,2955,-1,2955,2956,2958,2957,-1,2957,2958,2960,2959,-1,2963,2962,2961,-1,2963,2961,2964,-1,2863,2864,2868,-1,2863,2965,2865,-1,2966,2962,2963,-1,2906,2966,2963,2904,-1,2968,2967,2902,2904,-1,2969,2968,2904,2963,-1,2971,2970,2964,-1,2964,2970,2972,-1,2972,2970,2973,-1,2973,2970,2857,-1,2975,2974,2965,2863,-1,2977,2976,2926,2927,-1,2960,2958,2979,2978,-1,2976,2980,2930,2926,-1,2958,2956,2981,2979,-1,2980,2982,2932,2930,-1,2956,2954,2983,2981,-1,2982,2984,2934,2932,-1,2954,2952,2985,2983,-1,2984,2986,2936,2934,-1,2952,2950,2987,2985,-1,2986,2988,2938,2936,-1,2950,2948,2989,2987,-1,2988,2990,2940,2938,-1,2948,2946,2991,2989,-1,2990,2992,2942,2940,-1,2946,2944,2993,2991,-1,2992,2829,2942,-1,2944,2830,2993,-1,2995,2994,2884,2881,-1,2921,2923,2997,2996,-1,2998,2995,2881,2885,-1,2919,2921,2996,2999,-1,3000,2998,2885,2887,-1,2917,2919,2999,3001,-1,3002,3000,2887,2889,-1,2915,2917,3001,3003,-1,3004,3002,2889,2891,-1,2913,2915,3003,3005,-1,3006,3004,2891,2893,-1,2911,2913,3005,3007,-1,3008,3006,2893,2895,-1,2909,2911,3007,3009,-1,3010,3008,2895,2897,-1,2907,2909,3009,3011,-1,2825,3010,2897,2826,-1,2824,2907,3011,2825,-1,3013,3012,2860,2849,-1,3014,3013,2849,2850,-1,2899,2902,2967,3015,-1,2845,2901,3016,2844,-1,2901,3015,3014,3016,-1,2899,3015,2901,-1,3017,2973,2857,2862,-1,2963,2964,2972,2969,-1,3012,3017,2862,2860,-1,3019,2823,2822,3018,-1,2908,2824,2823,3020,-1,3021,3019,3018,2855,-1,2910,2908,3020,3022,-1,3023,3021,2855,2852,-1,2912,2910,3022,3024,-1,3025,3023,2852,2851,-1,2914,2912,3024,3026,-1,3027,3025,2851,2848,-1,2916,2914,3026,3028,-1,3029,3027,2848,2859,-1,2918,2916,3028,3030,-1,3031,3029,2859,2861,-1,2920,2918,3030,3032,-1,3033,3031,2861,2858,-1,2922,2920,3032,3034,-1,3035,3033,2858,2856,-1,2924,2922,3034,3036,-1,3037,2827,2898,-1,2941,2828,3038,-1,3039,3037,2898,2896,-1,2939,2941,3038,3040,-1,3041,3039,2896,2894,-1,2937,2939,3040,3042,-1,3043,3041,2894,2892,-1,2935,2937,3042,3044,-1,3045,3043,2892,2890,-1,2933,2935,3044,3046,-1,3047,3045,2890,2888,-1,2931,2933,3046,3048,-1,3049,3047,2888,2886,-1,2929,2931,3048,3050,-1,3051,3049,2886,2882,-1,2925,2929,3050,3052,-1,3053,3051,2882,2883,-1,2928,2925,3052,3054,-1,3055,2879,2807,-1,2943,3056,2806,-1,3055,3057,2877,2879,-1,2943,2945,3058,3056,-1,3057,3059,2875,2877,-1,2945,2947,3060,3058,-1,3059,3061,2873,2875,-1,2947,2949,3062,3060,-1,3061,3063,2871,2873,-1,2949,2951,3064,3062,-1,3063,3065,2869,2871,-1,2951,2953,3066,3064,-1,3065,3067,2866,2869,-1,2953,2955,3068,3066,-1,3067,2975,2863,2866,-1,2955,2957,3069,3068,-1,2957,2959,3070,3069,-1,2854,2855,3018,3071,-1,3071,3018,2822,2821,-1,3014,2850,2853,3016,-1,3016,2853,2854,2844,-1,2844,2854,3071,2847,-1,2847,3071,2821,-1,2790,3073,3072,2792,-1,2927,3074,2977,-1,3074,3075,2977,-1,2977,3075,2978,-1,3075,2960,2978,-1,3077,3076,2923,-1,2923,3076,2997,-1,2997,3076,2994,-1,3076,2884,2994,-1,3079,3078,2856,-1,2856,3078,3035,-1,3035,3078,3036,-1,3078,2924,3036,-1,3081,3080,2883,-1,2928,3054,3080,-1,2883,3080,3053,-1,3080,3054,3053,-1,3019,3020,2823,-1,3021,3022,3020,3019,-1,3023,3024,3022,3021,-1,3025,3026,3024,3023,-1,3027,3028,3026,3025,-1,3029,3030,3028,3027,-1,3031,3032,3030,3029,-1,3035,3036,3034,3033,-1,3033,3034,3032,3031,-1,2992,2993,2830,2829,-1,2990,2991,2993,2992,-1,2988,2989,2991,2990,-1,2986,2987,2989,2988,-1,2984,2985,2987,2986,-1,2982,2983,2985,2984,-1,2980,2981,2983,2982,-1,2977,2978,2979,2976,-1,2976,2979,2981,2980,-1,2975,3069,3070,2974,-1,2807,2806,3056,3055,-1,3055,3056,3058,3057,-1,3057,3058,3060,3059,-1,3059,3060,3062,3061,-1,3061,3062,3064,3063,-1,3063,3064,3066,3065,-1,3065,3066,3068,3067,-1,3067,3068,3069,2975,-1,3051,3052,3050,3049,-1,3053,3054,3052,3051,-1,3049,3050,3048,3047,-1,3047,3048,3046,3045,-1,3045,3046,3044,3043,-1,3043,3044,3042,3041,-1,3041,3042,3040,3039,-1,3039,3040,3038,3037,-1,3037,3038,2828,2827,-1,2998,2999,2996,2995,-1,3000,3001,2999,2998,-1,3002,3003,3001,3000,-1,3004,3005,3003,3002,-1,3006,3007,3005,3004,-1,3008,3009,3007,3006,-1,3010,3011,3009,3008,-1,2825,3011,3010,-1,2995,2996,2997,2994,-1,3017,2969,2972,2973,-1,3012,2968,2969,3017,-1,3013,2967,2968,3012,-1,3014,3015,2967,3013,-1,2845,3083,3082,2901,-1,2846,3084,3083,2845,-1,2820,2818,3084,2846,-1,2880,3085,2811,2809,-1,2878,3086,3085,2880,-1,2876,3087,3086,2878,-1,2874,3088,3087,2876,-1,2872,3089,3088,2874,-1,2870,3090,3089,2872,-1,2867,3091,3090,2870,-1,2868,3092,3091,2867,-1,2864,3093,3092,2868,-1,2865,3094,3093,2864,-1,2965,3095,3094,2865,-1,2965,2974,3095,-1,3095,2974,3096,-1,2974,3070,3096,-1,3096,3070,2959,-1,2960,3075,3096,2959,-1,2928,3080,3074,2927,-1,2884,3076,3081,2883,-1,2924,3078,3077,2923,-1,2857,2970,3079,2856,-1,2961,3097,2971,2964,-1,2962,3098,3097,2961,-1,2966,3099,3098,2962,-1,2906,3100,3099,2966,-1,2905,3101,3100,2906,-1,2903,3102,3101,2905,-1,2900,3103,3102,2903,-1,2901,3082,3103,2900,-1,3083,3105,3104,3082,-1,3084,3106,3105,3083,-1,2818,2816,3106,3084,-1,3085,3107,2812,2811,-1,3086,3108,3107,3085,-1,3087,3109,3108,3086,-1,3088,3110,3109,3087,-1,3089,3111,3110,3088,-1,3090,3112,3111,3089,-1,3091,3113,3112,3090,-1,3092,3114,3113,3091,-1,3093,3115,3114,3092,-1,3094,3116,3115,3093,-1,3095,3117,3116,3094,-1,3096,3118,3117,3095,-1,3075,3119,3118,3096,-1,3074,3120,3119,3075,-1,3080,3121,3120,3074,-1,3081,3122,3121,3080,-1,3076,3123,3122,3081,-1,3077,3124,3123,3076,-1,3078,3125,3124,3077,-1,3079,3126,3125,3078,-1,2970,3127,3126,3079,-1,2971,3128,3127,2970,-1,3097,3129,3128,2971,-1,3098,3130,3129,3097,-1,3099,3131,3130,3098,-1,3100,3132,3131,3099,-1,3101,3133,3132,3100,-1,3102,3134,3133,3101,-1,3103,3135,3134,3102,-1,3082,3104,3135,3103,-1,2812,3107,3136,-1,3138,2771,2773,3137,-1,3139,2769,2771,3138,-1,3140,2768,2769,3139,-1,3141,2780,2768,3140,-1,3143,2788,2786,3142,-1,3144,2800,2792,3072,-1,3144,3117,3118,3145,-1,3145,3118,3146,-1,3149,3148,3147,3146,-1,3148,3149,3120,3150,-1,3120,3121,3150,-1,2775,3151,3137,2773,-1,2788,3143,3073,2790,-1,2784,3152,3142,2786,-1,3152,2784,2782,3153,-1,2777,3154,3151,2775,-1,3155,3106,2816,-1,2816,2832,3155,-1,2794,3156,3154,2777,-1,3136,2835,2812,-1,2832,2843,3155,-1,3136,2841,2835,-1,3153,2782,2780,3141,-1,2840,2841,3156,-1,3156,2841,3136,3154,-1,3154,3136,3107,3151,-1,3151,3107,3108,3137,-1,3137,3108,3109,3138,-1,3138,3109,3110,3139,-1,3139,3110,3111,3140,-1,3140,3111,3112,3141,-1,3141,3112,3153,-1,3153,3112,3113,3152,-1,3152,3113,3142,-1,3142,3113,3114,3143,-1,3143,3114,3115,3073,-1,3073,3115,3116,3072,-1,3072,3116,3117,3144,-1,2799,2798,2766,2739,-1,2739,2766,2764,2737,-1,2737,2764,2762,2735,-1,2735,2762,2760,2733,-1,2733,2760,2758,2731,-1,2731,2758,2756,2729,-1,2729,2756,2754,2728,-1,2728,2754,2742,2691,-1,2691,2742,2743,2690,-1,2690,2743,2745,2725,-1,2725,2745,2747,2723,-1,2723,2747,2749,2721,-1,2721,2749,2751,2720,-1,2720,2751,2795,2793,-1,2793,2794,2778,2719,-1,2719,2778,2776,2722,-1,2722,2776,2774,2724,-1,2724,2774,2772,2726,-1,2726,2772,2770,2689,-1,2689,2770,2767,2692,-1,2692,2767,2779,2727,-1,2727,2779,2781,2730,-1,2730,2781,2783,2732,-1,2732,2783,2785,2734,-1,2734,2785,2787,2736,-1,2736,2787,2789,2738,-1,2738,2789,2791,2740,-1,2740,2791,2800,2799,-1,3158,2797,2694,3157,-1,3157,2694,2695,3159,-1,3159,2695,2697,3160,-1,3160,2697,2699,3161,-1,3161,2699,2701,3162,-1,3162,2701,2703,3163,-1,3163,2703,2705,3164,-1,3164,2705,2707,3165,-1,3165,2707,2718,3166,-1,3166,2718,2716,3167,-1,3167,2716,2714,3168,-1,3168,2714,2710,3169,-1,3169,2710,2711,3170,-1,3170,2711,2796,3171,-1,3171,2795,2752,3170,-1,3170,2752,2750,3169,-1,3169,2750,2748,3168,-1,3168,2748,2746,3167,-1,3167,2746,2744,3166,-1,3166,2744,2741,3165,-1,3165,2741,2753,3164,-1,3164,2753,2755,3163,-1,3163,2755,2757,3162,-1,3162,2757,2759,3161,-1,3161,2759,2761,3160,-1,3160,2761,2763,3159,-1,3159,2763,2765,3157,-1,3157,2765,2798,3158,-1,3173,3126,3127,3172,-1,3172,3127,3128,3174,-1,3174,3128,3129,3175,-1,3175,3129,3130,3176,-1,3176,3130,3131,3177,-1,3177,3131,3132,3178,-1,3178,3132,3133,3179,-1,3179,3133,3134,3180,-1,3180,3134,3135,3181,-1,3181,3135,3104,3182,-1,3182,3104,3105,3183,-1,3183,3105,3106,3184,-1,3184,3106,3155,3185,-1,3185,3155,2843,3186,-1,3186,2796,2712,3185,-1,3185,2712,2709,3184,-1,3184,2709,2713,3183,-1,3183,2713,2715,3182,-1,3182,2715,2717,3181,-1,3181,2717,2708,3180,-1,3180,2708,2706,3179,-1,3179,2706,2704,3178,-1,3178,2704,2702,3177,-1,3177,2702,2700,3176,-1,3176,2700,2698,3175,-1,3175,2698,2696,3174,-1,3174,2696,2693,3172,-1,3172,2693,2797,3173,-1,3121,3122,3150,-1,3150,3122,3123,3148,-1,3146,3118,3119,3149,-1,3149,3119,3120,-1,3148,3123,3124,3147,-1,3147,3124,3125,3187,-1,3187,3125,3126,3173,-1,3146,3147,3187,3145,-1,3145,2799,2800,-1,2800,3144,3145,-1,3187,3173,2797,-1,3158,2798,3187,-1,3187,2797,3158,-1,2798,2799,3145,3187,-1,2839,2840,2842,-1,2842,2840,3156,2794,-1,2795,2815,2842,-1,2842,2793,2795,-1,2796,2814,2815,-1,2815,2795,3171,-1,2813,2839,2842,2815,-1,2815,3171,2796,-1,3186,2843,2814,-1,2814,2796,3186,-1,3583,3584,3581,3582,-1,3587,3588,3585,3586,-1,3586,3585,3589,3590,-1,3590,3589,3591,3592,-1,3592,3591,3593,3594,-1,3594,3593,3595,3596,-1,3596,3595,3597,3598,-1,3598,3597,3599,3600,-1,3603,3604,3601,3602,-1,3605,3606,3604,3603,-1,3607,3608,3606,3605,-1,3609,3610,3608,3607,-1,3600,3599,3610,3609,-1,3613,3614,3611,3612,-1,3612,3611,3615,3616,-1,3616,3615,3617,3618,-1,3620,3619,3621,3622,-1,3622,3621,3623,3624,-1,3624,3623,3625,3626,-1,3626,3625,3627,3628,-1,3628,3627,3629,3630,-1,3630,3629,3631,3632,-1,3635,3636,3633,3634,-1,3634,3633,3637,3638,-1,3638,3637,3639,3640,-1,3640,3639,3641,3642,-1,3642,3641,3643,3644,-1,3645,3646,3636,3635,-1,3647,3648,3646,3645,-1,3649,3650,3648,3647,-1,3651,3652,3650,3649,-1,3653,3654,3652,3651,-1,3655,3656,3654,3653,-1,3657,3658,3656,3655,-1,3661,3662,3659,3660,-1,3660,3659,3663,3664,-1,3664,3663,3665,3666,-1,3666,3665,3667,3668,-1,3668,3667,3669,3670,-1,3671,3672,3662,3661,-1,3673,3674,3672,3671,-1,3675,3676,3674,3673,-1,3677,3678,3676,3675,-1,3679,3680,3678,3677,-1,3681,3682,3680,3679,-1,3683,3684,3682,3681,-1,3255,3614,3613,-1,3256,3670,3669,-1,3254,3644,3643,-1,3225,3602,3601,-1,3192,3588,3587,-1,3190,3658,3657,-1,3191,3632,3631,-1,3196,3684,3683,-1,3618,3617,3584,3583,-1,3619,3620,3582,3581,-1,3574,3580,3576,-1,3565,3580,3574,-1,3569,3580,3565,-1,3425,3569,3424,-1,3424,3569,3568,3355,-1,3355,3568,3566,3319,-1,3319,3566,3287,-1,3577,3579,3686,-1,3288,3573,3321,-1,3321,3573,3575,3357,-1,3357,3575,3466,-1,3466,3575,3576,3473,-1,3473,3576,3580,3464,-1,3464,3580,3522,-1,3522,3580,3375,-1,3375,3580,3531,-1,3531,3580,3389,-1,3389,3580,3388,-1,3388,3580,3569,3445,-1,3445,3569,3444,-1,3444,3569,3425,-1,3571,3573,3288,3286,-1,3574,3572,3564,3565,-1,3285,3287,3566,3563,-1,3567,3564,3572,3570,-1,3567,3578,3284,3283,-1,3685,3255,3256,-1,3226,3579,3577,3570,-1,3570,3577,3578,3567,-1,3286,3226,3570,3571,-1,3563,3567,3283,3285,-1,3575,3573,3574,3576,-1,3573,3571,3572,3574,-1,3571,3570,3572,-1,3566,3568,3569,3565,-1,3564,3567,3563,-1,3564,3563,3566,3565,-1,3468,3358,3356,3467,-1,3467,3356,3357,3466,-1,3515,3528,3472,3517,-1,3519,3471,3469,3475,-1,3517,3472,3471,3519,-1,3332,3333,3509,-1,3513,3524,3528,3515,-1,3511,3523,3524,3513,-1,3509,3333,3523,3511,-1,3478,3346,3345,-1,3479,3348,3347,3478,-1,3481,3349,3348,3479,-1,3483,3350,3349,3481,-1,3485,3351,3350,3483,-1,3487,3352,3351,3485,-1,3489,3353,3352,3487,-1,3491,3354,3353,3489,-1,3545,3493,3336,3337,-1,3543,3495,3493,3545,-1,3541,3497,3495,3543,-1,3539,3499,3497,3541,-1,3537,3501,3499,3539,-1,3535,3503,3501,3537,-1,3533,3505,3503,3535,-1,3530,3507,3505,3533,-1,3531,3389,3507,3530,-1,3424,3355,3354,3491,-1,3526,3323,3324,-1,3527,3325,3323,3526,-1,3562,3326,3325,3527,-1,3327,3326,3562,-1,3529,3521,3522,-1,3532,3520,3521,3529,-1,3534,3518,3520,3532,-1,3536,3516,3518,3534,-1,3538,3514,3516,3536,-1,3540,3512,3514,3538,-1,3542,3510,3512,3540,-1,3544,3508,3510,3542,-1,3334,3335,3508,3544,-1,3492,3561,3338,3339,-1,3494,3559,3561,3492,-1,3496,3557,3559,3494,-1,3498,3555,3557,3496,-1,3500,3553,3555,3498,-1,3502,3551,3553,3500,-1,3504,3549,3551,3502,-1,3506,3547,3549,3504,-1,3388,3445,3547,3506,-1,3490,3546,3444,3425,-1,3488,3548,3546,3490,-1,3486,3550,3548,3488,-1,3484,3552,3550,3486,-1,3482,3554,3552,3484,-1,3480,3556,3554,3482,-1,3477,3558,3556,3480,-1,3476,3560,3558,3477,-1,3340,3341,3560,3476,-1,3330,3329,3525,-1,3331,3330,3525,-1,3347,3346,3478,-1,3345,3344,3478,-1,3525,3329,3328,-1,3562,3525,3328,3327,-1,3562,3527,3359,3363,-1,3525,3562,3363,3365,-1,3331,3298,3297,-1,3367,3298,3331,-1,3368,3298,3367,-1,3333,3298,3368,-1,3478,3344,3343,3409,-1,3338,3561,3428,3430,-1,3431,3429,3560,3341,-1,3561,3559,3427,3428,-1,3429,3426,3558,3560,-1,3559,3557,3433,3427,-1,3426,3432,3556,3558,-1,3557,3555,3435,3433,-1,3432,3434,3554,3556,-1,3555,3553,3437,3435,-1,3434,3436,3552,3554,-1,3553,3551,3439,3437,-1,3436,3438,3550,3552,-1,3551,3549,3441,3439,-1,3438,3440,3548,3550,-1,3549,3547,3443,3441,-1,3440,3442,3546,3548,-1,3547,3445,3443,-1,3442,3444,3546,-1,3545,3337,3370,3371,-1,3372,3369,3334,3544,-1,3543,3545,3371,3387,-1,3386,3372,3544,3542,-1,3541,3543,3387,3385,-1,3384,3386,3542,3540,-1,3539,3541,3385,3383,-1,3382,3384,3540,3538,-1,3537,3539,3383,3381,-1,3380,3382,3538,3536,-1,3535,3537,3381,3379,-1,3378,3380,3536,3534,-1,3533,3535,3379,3377,-1,3376,3378,3534,3532,-1,3530,3533,3377,3374,-1,3373,3376,3532,3529,-1,3531,3530,3374,3375,-1,3375,3373,3529,3522,-1,3528,3524,3364,3360,-1,3472,3528,3360,3361,-1,3362,3359,3527,3526,-1,3468,3470,3324,3358,-1,3470,3361,3362,3324,-1,3324,3362,3526,-1,3523,3333,3368,3366,-1,3365,3367,3331,3525,-1,3524,3523,3366,3364,-1,3474,3473,3464,3463,-1,3462,3464,3522,3521,-1,3475,3474,3463,3461,-1,3460,3462,3521,3520,-1,3519,3475,3461,3459,-1,3458,3460,3520,3518,-1,3517,3519,3459,3457,-1,3456,3458,3518,3516,-1,3515,3517,3457,3455,-1,3454,3456,3516,3514,-1,3513,3515,3455,3453,-1,3452,3454,3514,3512,-1,3511,3513,3453,3447,-1,3446,3452,3512,3510,-1,3509,3511,3447,3448,-1,3449,3446,3510,3508,-1,3332,3509,3448,3450,-1,3451,3449,3508,3335,-1,3507,3389,3390,-1,3391,3388,3506,-1,3505,3507,3390,3392,-1,3393,3391,3506,3504,-1,3503,3505,3392,3394,-1,3395,3393,3504,3502,-1,3501,3503,3394,3396,-1,3397,3395,3502,3500,-1,3499,3501,3396,3398,-1,3399,3397,3500,3498,-1,3497,3499,3398,3400,-1,3401,3399,3498,3496,-1,3495,3497,3400,3402,-1,3403,3401,3496,3494,-1,3493,3495,3402,3405,-1,3404,3403,3494,3492,-1,3336,3493,3405,3406,-1,3407,3404,3492,3339,-1,3424,3491,3422,-1,3425,3423,3490,-1,3491,3489,3420,3422,-1,3423,3421,3488,3490,-1,3489,3487,3418,3420,-1,3421,3419,3486,3488,-1,3487,3485,3416,3418,-1,3419,3417,3484,3486,-1,3485,3483,3414,3416,-1,3417,3415,3482,3484,-1,3483,3481,3412,3414,-1,3415,3413,3480,3482,-1,3481,3479,3410,3412,-1,3413,3411,3477,3480,-1,3479,3478,3409,3410,-1,3411,3408,3476,3477,-1,3408,3342,3340,3476,-1,3465,3474,3475,3469,-1,3466,3473,3474,3465,-1,3470,3471,3472,3361,-1,3468,3469,3471,3470,-1,3467,3465,3469,3468,-1,3466,3465,3467,-1,3684,3258,3260,3682,-1,3430,3305,3338,-1,3430,3306,3305,-1,3431,3306,3430,-1,3431,3341,3306,-1,3334,3302,3301,-1,3369,3302,3334,-1,3370,3302,3369,-1,3370,3337,3302,-1,3332,3300,3299,-1,3450,3300,3332,-1,3451,3300,3450,-1,3451,3335,3300,-1,3336,3304,3303,-1,3304,3407,3339,-1,3406,3304,3336,-1,3406,3407,3304,-1,3464,3462,3463,-1,3463,3462,3460,3461,-1,3461,3460,3458,3459,-1,3459,3458,3456,3457,-1,3457,3456,3454,3455,-1,3455,3454,3452,3453,-1,3453,3452,3446,3447,-1,3448,3449,3451,3450,-1,3447,3446,3449,3448,-1,3445,3444,3442,3443,-1,3443,3442,3440,3441,-1,3441,3440,3438,3439,-1,3439,3438,3436,3437,-1,3437,3436,3434,3435,-1,3435,3434,3432,3433,-1,3433,3432,3426,3427,-1,3428,3429,3431,3430,-1,3427,3426,3429,3428,-1,3343,3342,3408,3409,-1,3422,3423,3425,3424,-1,3420,3421,3423,3422,-1,3418,3419,3421,3420,-1,3416,3417,3419,3418,-1,3414,3415,3417,3416,-1,3412,3413,3415,3414,-1,3410,3411,3413,3412,-1,3409,3408,3411,3410,-1,3402,3403,3404,3405,-1,3405,3404,3407,3406,-1,3400,3401,3403,3402,-1,3398,3399,3401,3400,-1,3396,3397,3399,3398,-1,3394,3395,3397,3396,-1,3392,3393,3395,3394,-1,3390,3391,3393,3392,-1,3389,3388,3391,3390,-1,3371,3372,3386,3387,-1,3387,3386,3384,3385,-1,3385,3384,3382,3383,-1,3383,3382,3380,3381,-1,3381,3380,3378,3379,-1,3379,3378,3376,3377,-1,3377,3376,3373,3374,-1,3374,3373,3375,-1,3370,3369,3372,3371,-1,3368,3367,3365,3366,-1,3366,3365,3363,3364,-1,3364,3363,3359,3360,-1,3360,3359,3362,3361,-1,3324,3290,3322,3358,-1,3358,3322,3320,3356,-1,3356,3320,3321,3357,-1,3355,3319,3318,3354,-1,3354,3318,3317,3353,-1,3353,3317,3316,3352,-1,3352,3316,3315,3351,-1,3351,3315,3314,3350,-1,3350,3314,3313,3349,-1,3349,3313,3312,3348,-1,3348,3312,3311,3347,-1,3347,3311,3310,3346,-1,3346,3310,3309,3345,-1,3345,3309,3308,3344,-1,3308,3343,3344,-1,3307,3343,3308,-1,3307,3342,3343,-1,3340,3342,3307,-1,3340,3307,3306,3341,-1,3338,3305,3304,3339,-1,3336,3303,3302,3337,-1,3334,3301,3300,3335,-1,3332,3299,3298,3333,-1,3331,3297,3296,3330,-1,3330,3296,3295,3329,-1,3329,3295,3294,3328,-1,3328,3294,3293,3327,-1,3327,3293,3292,3326,-1,3326,3292,3291,3325,-1,3325,3291,3289,3323,-1,3323,3289,3290,3324,-1,3290,3230,3229,3322,-1,3322,3229,3228,3320,-1,3320,3228,3288,3321,-1,3319,3287,3279,3318,-1,3318,3279,3277,3317,-1,3317,3277,3275,3316,-1,3316,3275,3273,3315,-1,3315,3273,3271,3314,-1,3314,3271,3268,3313,-1,3313,3268,3265,3312,-1,3312,3265,3263,3311,-1,3311,3263,3261,3310,-1,3310,3261,3259,3309,-1,3309,3259,3257,3308,-1,3308,3257,3207,3307,-1,3307,3207,3204,3306,-1,3306,3204,3205,3305,-1,3305,3205,3210,3304,-1,3304,3210,3209,3303,-1,3303,3209,3203,3302,-1,3302,3203,3201,3301,-1,3301,3201,3200,3300,-1,3300,3200,3199,3299,-1,3299,3199,3239,3298,-1,3298,3239,3238,3297,-1,3297,3238,3237,3296,-1,3296,3237,3236,3295,-1,3295,3236,3235,3294,-1,3294,3235,3234,3293,-1,3293,3234,3233,3292,-1,3292,3233,3232,3291,-1,3291,3232,3231,3289,-1,3289,3231,3230,3290,-1,3281,3279,3287,-1,3276,3665,3663,3274,-1,3274,3663,3659,3272,-1,3272,3659,3662,3270,-1,3270,3662,3672,3269,-1,3264,3678,3680,3262,-1,3258,3684,3196,3195,-1,3188,3207,3257,3195,-1,3197,3207,3188,-1,3197,3198,3202,3206,-1,3208,3205,3206,3202,-1,3208,3210,3205,-1,3665,3276,3278,3667,-1,3682,3260,3262,3680,-1,3678,3264,3266,3676,-1,3267,3674,3676,3266,-1,3667,3278,3280,3669,-1,3288,3228,3227,-1,3227,3286,3288,-1,3669,3280,3282,3256,-1,3287,3285,3281,-1,3227,3226,3286,-1,3285,3283,3281,-1,3269,3672,3674,3267,-1,3282,3283,3284,-1,3280,3281,3283,3282,-1,3278,3279,3281,3280,-1,3276,3277,3279,3278,-1,3274,3275,3277,3276,-1,3272,3273,3275,3274,-1,3270,3271,3273,3272,-1,3269,3268,3271,3270,-1,3267,3268,3269,-1,3266,3265,3268,3267,-1,3264,3265,3266,-1,3262,3263,3265,3264,-1,3260,3261,3263,3262,-1,3258,3259,3261,3260,-1,3195,3257,3259,3258,-1,3631,3658,3190,3191,-1,3629,3656,3658,3631,-1,3627,3654,3656,3629,-1,3625,3652,3654,3627,-1,3623,3650,3652,3625,-1,3621,3648,3650,3623,-1,3619,3646,3648,3621,-1,3581,3636,3646,3619,-1,3584,3633,3636,3581,-1,3617,3637,3633,3584,-1,3615,3639,3637,3617,-1,3611,3641,3639,3615,-1,3614,3643,3641,3611,-1,3255,3254,3643,3614,-1,3613,3670,3256,3255,-1,3612,3668,3670,3613,-1,3616,3666,3668,3612,-1,3618,3664,3666,3616,-1,3583,3660,3664,3618,-1,3582,3661,3660,3583,-1,3620,3671,3661,3582,-1,3622,3673,3671,3620,-1,3624,3675,3673,3622,-1,3626,3677,3675,3624,-1,3628,3679,3677,3626,-1,3630,3681,3679,3628,-1,3632,3683,3681,3630,-1,3191,3196,3683,3632,-1,3240,3588,3192,3193,-1,3241,3585,3588,3240,-1,3242,3589,3585,3241,-1,3243,3591,3589,3242,-1,3244,3593,3591,3243,-1,3245,3595,3593,3244,-1,3246,3597,3595,3245,-1,3247,3599,3597,3246,-1,3248,3610,3599,3247,-1,3249,3608,3610,3248,-1,3250,3606,3608,3249,-1,3251,3604,3606,3250,-1,3252,3601,3604,3251,-1,3253,3225,3601,3252,-1,3252,3644,3254,3253,-1,3251,3642,3644,3252,-1,3250,3640,3642,3251,-1,3249,3638,3640,3250,-1,3248,3634,3638,3249,-1,3247,3635,3634,3248,-1,3246,3645,3635,3247,-1,3245,3647,3645,3246,-1,3244,3649,3647,3245,-1,3243,3651,3649,3244,-1,3242,3653,3651,3243,-1,3241,3655,3653,3242,-1,3240,3657,3655,3241,-1,3193,3190,3657,3240,-1,3211,3239,3199,3194,-1,3212,3238,3239,3211,-1,3213,3237,3238,3212,-1,3214,3236,3237,3213,-1,3215,3235,3236,3214,-1,3216,3234,3235,3215,-1,3217,3233,3234,3216,-1,3218,3232,3233,3217,-1,3219,3231,3232,3218,-1,3220,3230,3231,3219,-1,3221,3229,3230,3220,-1,3222,3228,3229,3221,-1,3223,3227,3228,3222,-1,3224,3226,3227,3223,-1,3223,3602,3225,3224,-1,3222,3603,3602,3223,-1,3221,3605,3603,3222,-1,3220,3607,3605,3221,-1,3219,3609,3607,3220,-1,3218,3600,3609,3219,-1,3217,3598,3600,3218,-1,3216,3596,3598,3217,-1,3215,3594,3596,3216,-1,3214,3592,3594,3215,-1,3213,3590,3592,3214,-1,3212,3586,3590,3213,-1,3211,3587,3586,3212,-1,3194,3192,3587,3211,-1,3208,3209,3210,-1,3202,3203,3209,3208,-1,3206,3204,3207,3197,-1,3205,3204,3206,-1,3198,3201,3203,3202,-1,3189,3200,3201,3198,-1,3194,3199,3200,3189,-1,3188,3189,3198,3197,-1,3196,3191,3188,-1,3188,3195,3196,-1,3192,3194,3189,-1,3189,3190,3193,-1,3193,3192,3189,-1,3189,3188,3191,3190,-1,3685,3284,3578,-1,3256,3282,3284,3685,-1,3685,3686,3254,-1,3254,3255,3685,-1,3686,3579,3225,-1,3253,3254,3686,-1,3686,3685,3578,3577,-1,3225,3253,3686,-1,3579,3226,3224,-1,3224,3225,3579,-1,3690,3689,3688,3687,-1,3694,3693,3692,3691,-1,3691,3692,3696,3695,-1,3695,3696,3698,3697,-1,3697,3698,3700,3699,-1,3699,3700,3702,3701,-1,3701,3702,3704,3703,-1,3703,3704,3706,3705,-1,3710,3709,3708,3707,-1,3712,3711,3709,3710,-1,3714,3713,3711,3712,-1,3716,3715,3713,3714,-1,3705,3706,3715,3716,-1,3720,3719,3718,3717,-1,3717,3718,3722,3721,-1,3721,3722,3724,3723,-1,3728,3727,3726,3725,-1,3725,3726,3730,3729,-1,3729,3730,3732,3731,-1,3731,3732,3734,3733,-1,3733,3734,3736,3735,-1,3735,3736,3738,3737,-1,3742,3741,3740,3739,-1,3739,3740,3744,3743,-1,3743,3744,3746,3745,-1,3745,3746,3748,3747,-1,3747,3748,3750,3749,-1,3752,3751,3741,3742,-1,3754,3753,3751,3752,-1,3756,3755,3753,3754,-1,3758,3757,3755,3756,-1,3760,3759,3757,3758,-1,3762,3761,3759,3760,-1,3764,3763,3761,3762,-1,3768,3767,3766,3765,-1,3765,3766,3770,3769,-1,3769,3770,3772,3771,-1,3771,3772,3774,3773,-1,3773,3774,3776,3775,-1,3778,3777,3767,3768,-1,3780,3779,3777,3778,-1,3782,3781,3779,3780,-1,3784,3783,3781,3782,-1,3786,3785,3783,3784,-1,3788,3787,3785,3786,-1,3790,3789,3787,3788,-1,3791,3719,3720,-1,3792,3775,3776,-1,3793,3749,3750,-1,3794,3707,3708,-1,3795,3693,3694,-1,3796,3763,3764,-1,3797,3737,3738,-1,3798,3789,3790,-1,3723,3724,3689,3690,-1,3727,3728,3687,3688,-1,3801,3800,3799,-1,3802,3800,3801,-1,3803,3800,3802,-1,3805,3803,3804,-1,3804,3803,3807,3806,-1,3806,3807,3809,3808,-1,3808,3809,3810,-1,3813,3812,3811,-1,3816,3815,3814,-1,3814,3815,3818,3817,-1,3817,3818,3819,-1,3819,3818,3799,3820,-1,3820,3799,3800,3821,-1,3821,3800,3822,-1,3822,3800,3823,-1,3823,3800,3824,-1,3824,3800,3825,-1,3825,3800,3826,-1,3826,3800,3803,3827,-1,3827,3803,3828,-1,3828,3803,3805,-1,3830,3815,3816,3829,-1,3801,3832,3831,3802,-1,3834,3810,3809,3833,-1,3836,3831,3832,3835,-1,3836,3839,3838,3837,-1,3840,3791,3792,-1,3841,3812,3813,3835,-1,3835,3813,3839,3836,-1,3829,3841,3835,3830,-1,3833,3836,3837,3834,-1,3818,3815,3801,3799,-1,3815,3830,3832,3801,-1,3830,3835,3832,-1,3809,3807,3803,3802,-1,3831,3836,3833,-1,3831,3833,3809,3802,-1,3845,3844,3843,3842,-1,3842,3843,3817,3819,-1,3849,3848,3847,3846,-1,3853,3852,3851,3850,-1,3846,3847,3852,3853,-1,3856,3855,3854,-1,3858,3857,3848,3849,-1,3860,3859,3857,3858,-1,3854,3855,3859,3860,-1,3863,3862,3861,-1,3866,3865,3864,3863,-1,3868,3867,3865,3866,-1,3870,3869,3867,3868,-1,3872,3871,3869,3870,-1,3874,3873,3871,3872,-1,3876,3875,3873,3874,-1,3878,3877,3875,3876,-1,3882,3881,3880,3879,-1,3884,3883,3881,3882,-1,3886,3885,3883,3884,-1,3888,3887,3885,3886,-1,3890,3889,3887,3888,-1,3892,3891,3889,3890,-1,3894,3893,3891,3892,-1,3896,3895,3893,3894,-1,3824,3825,3895,3896,-1,3804,3806,3877,3878,-1,3899,3898,3897,-1,3901,3900,3898,3899,-1,3903,3902,3900,3901,-1,3904,3902,3903,-1,3906,3905,3822,-1,3908,3907,3905,3906,-1,3910,3909,3907,3908,-1,3912,3911,3909,3910,-1,3914,3913,3911,3912,-1,3916,3915,3913,3914,-1,3918,3917,3915,3916,-1,3920,3919,3917,3918,-1,3922,3921,3919,3920,-1,3926,3925,3924,3923,-1,3928,3927,3925,3926,-1,3930,3929,3927,3928,-1,3932,3931,3929,3930,-1,3934,3933,3931,3932,-1,3936,3935,3933,3934,-1,3938,3937,3935,3936,-1,3940,3939,3937,3938,-1,3826,3827,3939,3940,-1,3942,3941,3828,3805,-1,3944,3943,3941,3942,-1,3946,3945,3943,3944,-1,3948,3947,3945,3946,-1,3950,3949,3947,3948,-1,3952,3951,3949,3950,-1,3954,3953,3951,3952,-1,3956,3955,3953,3954,-1,3958,3957,3955,3956,-1,3961,3960,3959,-1,3962,3961,3959,-1,3864,3862,3863,-1,3861,3963,3863,-1,3959,3960,3964,-1,3903,3959,3964,3904,-1,3903,3901,3966,3965,-1,3959,3903,3965,3967,-1,3962,3969,3968,-1,3970,3969,3962,-1,3971,3969,3970,-1,3855,3969,3971,-1,3863,3963,3973,3972,-1,3924,3925,3975,3974,-1,3977,3976,3955,3957,-1,3925,3927,3978,3975,-1,3976,3979,3953,3955,-1,3927,3929,3980,3978,-1,3979,3981,3951,3953,-1,3929,3931,3982,3980,-1,3981,3983,3949,3951,-1,3931,3933,3984,3982,-1,3983,3985,3947,3949,-1,3933,3935,3986,3984,-1,3985,3987,3945,3947,-1,3935,3937,3988,3986,-1,3987,3989,3943,3945,-1,3937,3939,3990,3988,-1,3989,3991,3941,3943,-1,3939,3827,3990,-1,3991,3828,3941,-1,3882,3879,3993,3992,-1,3995,3994,3922,3920,-1,3884,3882,3992,3996,-1,3997,3995,3920,3918,-1,3886,3884,3996,3998,-1,3999,3997,3918,3916,-1,3888,3886,3998,4000,-1,4001,3999,3916,3914,-1,3890,3888,4000,4002,-1,4003,4001,3914,3912,-1,3892,3890,4002,4004,-1,4005,4003,3912,3910,-1,3894,3892,4004,4006,-1,4007,4005,3910,3908,-1,3896,3894,4006,4008,-1,4009,4007,3908,3906,-1,3824,3896,4008,3823,-1,3823,4009,3906,3822,-1,3848,3857,4011,4010,-1,3847,3848,4010,4012,-1,4013,3966,3901,3899,-1,3845,4014,3897,3844,-1,4014,4012,4013,3897,-1,3897,4013,3899,-1,3859,3855,3971,4015,-1,3967,3970,3962,3959,-1,3857,3859,4015,4011,-1,4017,3820,3821,4016,-1,4018,3821,3822,3905,-1,3850,4017,4016,4019,-1,4020,4018,3905,3907,-1,3853,3850,4019,4021,-1,4022,4020,3907,3909,-1,3846,3853,4021,4023,-1,4024,4022,3909,3911,-1,3849,3846,4023,4025,-1,4026,4024,3911,3913,-1,3858,3849,4025,4027,-1,4028,4026,3913,3915,-1,3860,3858,4027,4029,-1,4030,4028,3915,3917,-1,3854,3860,4029,4031,-1,4032,4030,3917,3919,-1,3856,3854,4031,4033,-1,4034,4032,3919,3921,-1,3895,3825,4035,-1,4036,3826,3940,-1,3893,3895,4035,4037,-1,4038,4036,3940,3938,-1,3891,3893,4037,4039,-1,4040,4038,3938,3936,-1,3889,3891,4039,4041,-1,4042,4040,3936,3934,-1,3887,3889,4041,4043,-1,4044,4042,3934,3932,-1,3885,3887,4043,4045,-1,4046,4044,3932,3930,-1,3883,3885,4045,4047,-1,4048,4046,3930,3928,-1,3881,3883,4047,4049,-1,4050,4048,3928,3926,-1,3880,3881,4049,4051,-1,4052,4050,3926,3923,-1,3804,3878,4053,-1,3805,4054,3942,-1,3878,3876,4055,4053,-1,4054,4056,3944,3942,-1,3876,3874,4057,4055,-1,4056,4058,3946,3944,-1,3874,3872,4059,4057,-1,4058,4060,3948,3946,-1,3872,3870,4061,4059,-1,4060,4062,3950,3948,-1,3870,3868,4063,4061,-1,4062,4064,3952,3950,-1,3868,3866,4065,4063,-1,4064,4066,3954,3952,-1,3866,3863,3972,4065,-1,4066,4067,3956,3954,-1,4067,4068,3958,3956,-1,4069,4017,3850,3851,-1,3819,3820,4017,4069,-1,4014,3852,3847,4012,-1,3845,3851,3852,4014,-1,3842,4069,3851,3845,-1,3819,4069,3842,-1,3789,4071,4070,3787,-1,3974,4072,3924,-1,3974,4073,4072,-1,3977,4073,3974,-1,3977,3957,4073,-1,3922,4075,4074,-1,3994,4075,3922,-1,3993,4075,3994,-1,3993,3879,4075,-1,3856,4077,4076,-1,4033,4077,3856,-1,4034,4077,4033,-1,4034,3921,4077,-1,3880,4079,4078,-1,4079,4052,3923,-1,4051,4079,3880,-1,4051,4052,4079,-1,3821,4018,4016,-1,4016,4018,4020,4019,-1,4019,4020,4022,4021,-1,4021,4022,4024,4023,-1,4023,4024,4026,4025,-1,4025,4026,4028,4027,-1,4027,4028,4030,4029,-1,4031,4032,4034,4033,-1,4029,4030,4032,4031,-1,3827,3828,3991,3990,-1,3990,3991,3989,3988,-1,3988,3989,3987,3986,-1,3986,3987,3985,3984,-1,3984,3985,3983,3982,-1,3982,3983,3981,3980,-1,3980,3981,3979,3978,-1,3975,3976,3977,3974,-1,3978,3979,3976,3975,-1,3973,4068,4067,3972,-1,4053,4054,3805,3804,-1,4055,4056,4054,4053,-1,4057,4058,4056,4055,-1,4059,4060,4058,4057,-1,4061,4062,4060,4059,-1,4063,4064,4062,4061,-1,4065,4066,4064,4063,-1,3972,4067,4066,4065,-1,4047,4048,4050,4049,-1,4049,4050,4052,4051,-1,4045,4046,4048,4047,-1,4043,4044,4046,4045,-1,4041,4042,4044,4043,-1,4039,4040,4042,4041,-1,4037,4038,4040,4039,-1,4035,4036,4038,4037,-1,3825,3826,4036,4035,-1,3992,3995,3997,3996,-1,3996,3997,3999,3998,-1,3998,3999,4001,4000,-1,4000,4001,4003,4002,-1,4002,4003,4005,4004,-1,4004,4005,4007,4006,-1,4006,4007,4009,4008,-1,4008,4009,3823,-1,3993,3994,3995,3992,-1,3971,3970,3967,4015,-1,4015,3967,3965,4011,-1,4011,3965,3966,4010,-1,4010,3966,4013,4012,-1,3897,4081,4080,3844,-1,3844,4080,4082,3843,-1,3843,4082,3814,3817,-1,3806,3808,4083,3877,-1,3877,4083,4084,3875,-1,3875,4084,4085,3873,-1,3873,4085,4086,3871,-1,3871,4086,4087,3869,-1,3869,4087,4088,3867,-1,3867,4088,4089,3865,-1,3865,4089,4090,3864,-1,3864,4090,4091,3862,-1,3862,4091,4092,3861,-1,3861,4092,4093,3963,-1,4093,3973,3963,-1,4094,3973,4093,-1,4094,4068,3973,-1,3958,4068,4094,-1,3958,4094,4073,3957,-1,3924,4072,4079,3923,-1,3880,4078,4075,3879,-1,3922,4074,4077,3921,-1,3856,4076,3969,3855,-1,3962,3968,4095,3961,-1,3961,4095,4096,3960,-1,3960,4096,4097,3964,-1,3964,4097,4098,3904,-1,3904,4098,4099,3902,-1,3902,4099,4100,3900,-1,3900,4100,4101,3898,-1,3898,4101,4081,3897,-1,4081,4103,4102,4080,-1,4080,4102,4104,4082,-1,4082,4104,3816,3814,-1,3808,3810,4105,4083,-1,4083,4105,4106,4084,-1,4084,4106,4107,4085,-1,4085,4107,4108,4086,-1,4086,4108,4109,4087,-1,4087,4109,4110,4088,-1,4088,4110,4111,4089,-1,4089,4111,4112,4090,-1,4090,4112,4113,4091,-1,4091,4113,4114,4092,-1,4092,4114,4115,4093,-1,4093,4115,4116,4094,-1,4094,4116,4117,4073,-1,4073,4117,4118,4072,-1,4072,4118,4119,4079,-1,4079,4119,4120,4078,-1,4078,4120,4121,4075,-1,4075,4121,4122,4074,-1,4074,4122,4123,4077,-1,4077,4123,4124,4076,-1,4076,4124,4125,3969,-1,3969,4125,4126,3968,-1,3968,4126,4127,4095,-1,4095,4127,4128,4096,-1,4096,4128,4129,4097,-1,4097,4129,4130,4098,-1,4098,4130,4131,4099,-1,4099,4131,4132,4100,-1,4100,4132,4133,4101,-1,4101,4133,4103,4081,-1,4134,4105,3810,-1,4136,3772,3770,4135,-1,4135,3770,3766,4137,-1,4137,3766,3767,4138,-1,4138,3767,3777,4139,-1,4141,3783,3785,4140,-1,4071,3789,3798,4142,-1,4143,4116,4115,4142,-1,4144,4116,4143,-1,4144,4147,4146,4145,-1,4148,4118,4145,4146,-1,4148,4119,4118,-1,3772,4136,4149,3774,-1,3787,4070,4140,3785,-1,3783,4141,4150,3781,-1,4151,3779,3781,4150,-1,3774,4149,4152,3776,-1,3816,4104,4153,-1,4153,3829,3816,-1,3776,4152,4154,3792,-1,3810,3834,4134,-1,4153,3841,3829,-1,3834,3837,4134,-1,4139,3777,3779,4151,-1,4154,3837,3838,-1,4152,4134,3837,4154,-1,4149,4105,4134,4152,-1,4136,4106,4105,4149,-1,4135,4107,4106,4136,-1,4137,4108,4107,4135,-1,4138,4109,4108,4137,-1,4139,4110,4109,4138,-1,4151,4110,4139,-1,4150,4111,4110,4151,-1,4141,4111,4150,-1,4140,4112,4111,4141,-1,4070,4113,4112,4140,-1,4071,4114,4113,4070,-1,4142,4115,4114,4071,-1,3738,3763,3796,3797,-1,3736,3761,3763,3738,-1,3734,3759,3761,3736,-1,3732,3757,3759,3734,-1,3730,3755,3757,3732,-1,3726,3753,3755,3730,-1,3727,3751,3753,3726,-1,3688,3741,3751,3727,-1,3689,3740,3741,3688,-1,3724,3744,3740,3689,-1,3722,3746,3744,3724,-1,3718,3748,3746,3722,-1,3719,3750,3748,3718,-1,3791,3793,3750,3719,-1,3720,3775,3792,3791,-1,3717,3773,3775,3720,-1,3721,3771,3773,3717,-1,3723,3769,3771,3721,-1,3690,3765,3769,3723,-1,3687,3768,3765,3690,-1,3728,3778,3768,3687,-1,3725,3780,3778,3728,-1,3729,3782,3780,3725,-1,3731,3784,3782,3729,-1,3733,3786,3784,3731,-1,3735,3788,3786,3733,-1,3737,3790,3788,3735,-1,3797,3798,3790,3737,-1,4156,3693,3795,4155,-1,4157,3692,3693,4156,-1,4158,3696,3692,4157,-1,4159,3698,3696,4158,-1,4160,3700,3698,4159,-1,4161,3702,3700,4160,-1,4162,3704,3702,4161,-1,4163,3706,3704,4162,-1,4164,3715,3706,4163,-1,4165,3713,3715,4164,-1,4166,3711,3713,4165,-1,4167,3709,3711,4166,-1,4168,3708,3709,4167,-1,4169,3794,3708,4168,-1,4168,3749,3793,4169,-1,4167,3747,3749,4168,-1,4166,3745,3747,4167,-1,4165,3743,3745,4166,-1,4164,3739,3743,4165,-1,4163,3742,3739,4164,-1,4162,3752,3742,4163,-1,4161,3754,3752,4162,-1,4160,3756,3754,4161,-1,4159,3758,3756,4160,-1,4158,3760,3758,4159,-1,4157,3762,3760,4158,-1,4156,3764,3762,4157,-1,4155,3796,3764,4156,-1,4171,4125,4124,4170,-1,4172,4126,4125,4171,-1,4173,4127,4126,4172,-1,4174,4128,4127,4173,-1,4175,4129,4128,4174,-1,4176,4130,4129,4175,-1,4177,4131,4130,4176,-1,4178,4132,4131,4177,-1,4179,4133,4132,4178,-1,4180,4103,4133,4179,-1,4181,4102,4103,4180,-1,4182,4104,4102,4181,-1,4183,4153,4104,4182,-1,4184,3841,4153,4183,-1,4183,3707,3794,4184,-1,4182,3710,3707,4183,-1,4181,3712,3710,4182,-1,4180,3714,3712,4181,-1,4179,3716,3714,4180,-1,4178,3705,3716,4179,-1,4177,3703,3705,4178,-1,4176,3701,3703,4177,-1,4175,3699,3701,4176,-1,4174,3697,3699,4175,-1,4173,3695,3697,4174,-1,4172,3691,3695,4173,-1,4171,3694,3691,4172,-1,4170,3795,3694,4171,-1,4148,4120,4119,-1,4146,4121,4120,4148,-1,4145,4117,4116,4144,-1,4118,4117,4145,-1,4147,4122,4121,4146,-1,4185,4123,4122,4147,-1,4170,4124,4123,4185,-1,4143,4185,4147,4144,-1,3798,3797,4143,-1,4143,4142,3798,-1,3795,4170,4185,-1,4185,3796,4155,-1,4155,3795,4185,-1,4185,4143,3797,3796,-1,3840,3838,3839,-1,3792,4154,3838,3840,-1,3840,3811,3793,-1,3793,3791,3840,-1,3811,3812,3794,-1,4169,3793,3811,-1,3811,3840,3839,3813,-1,3794,4169,3811,-1,3812,3841,4184,-1,4184,3794,3812,-1,4580,4579,4582,4581,-1,4584,4583,4586,4585,-1,4588,4587,4583,4584,-1,4590,4589,4587,4588,-1,4592,4591,4589,4590,-1,4594,4593,4591,4592,-1,4596,4595,4593,4594,-1,4598,4597,4595,4596,-1,4600,4599,4602,4601,-1,4601,4602,4604,4603,-1,4603,4604,4606,4605,-1,4605,4606,4608,4607,-1,4607,4608,4597,4598,-1,4610,4609,4612,4611,-1,4614,4613,4609,4610,-1,4616,4615,4613,4614,-1,4620,4619,4617,4618,-1,4622,4621,4619,4620,-1,4624,4623,4621,4622,-1,4626,4625,4623,4624,-1,4628,4627,4625,4626,-1,4630,4629,4627,4628,-1,4632,4631,4634,4633,-1,4636,4635,4631,4632,-1,4638,4637,4635,4636,-1,4640,4639,4637,4638,-1,4642,4641,4639,4640,-1,4633,4634,4644,4643,-1,4643,4644,4646,4645,-1,4645,4646,4648,4647,-1,4647,4648,4650,4649,-1,4649,4650,4652,4651,-1,4651,4652,4654,4653,-1,4653,4654,4656,4655,-1,4658,4657,4660,4659,-1,4662,4661,4657,4658,-1,4664,4663,4661,4662,-1,4666,4665,4663,4664,-1,4668,4667,4665,4666,-1,4659,4660,4670,4669,-1,4669,4670,4672,4671,-1,4671,4672,4674,4673,-1,4673,4674,4676,4675,-1,4675,4676,4678,4677,-1,4677,4678,4680,4679,-1,4679,4680,4682,4681,-1,4611,4612,4253,-1,4667,4668,4254,-1,4641,4642,4252,-1,4599,4600,4223,-1,4585,4586,4190,-1,4655,4656,4188,-1,4629,4630,4189,-1,4681,4682,4194,-1,4581,4582,4615,4616,-1,4579,4580,4618,4617,-1,4574,4578,4572,-1,4572,4578,4563,-1,4563,4578,4567,-1,4422,4567,4423,-1,4353,4566,4567,4422,-1,4317,4564,4566,4353,-1,4285,4564,4317,-1,4684,4577,4575,-1,4319,4571,4286,-1,4355,4573,4571,4319,-1,4464,4573,4355,-1,4471,4574,4573,4464,-1,4462,4578,4574,4471,-1,4520,4578,4462,-1,4373,4578,4520,-1,4529,4578,4373,-1,4387,4578,4529,-1,4386,4578,4387,-1,4443,4567,4578,4386,-1,4442,4567,4443,-1,4423,4567,4442,-1,4284,4286,4571,4569,-1,4563,4562,4570,4572,-1,4561,4564,4285,4283,-1,4568,4570,4562,4565,-1,4281,4282,4576,4565,-1,4254,4253,4683,-1,4568,4575,4577,4224,-1,4565,4576,4575,4568,-1,4569,4568,4224,4284,-1,4283,4281,4565,4561,-1,4574,4572,4571,4573,-1,4572,4570,4569,4571,-1,4570,4568,4569,-1,4563,4567,4566,4564,-1,4561,4565,4562,-1,4563,4564,4561,4562,-1,4465,4354,4356,4466,-1,4464,4355,4354,4465,-1,4515,4470,4526,4513,-1,4473,4467,4469,4517,-1,4517,4469,4470,4515,-1,4507,4331,4330,-1,4513,4526,4522,4511,-1,4511,4522,4521,4509,-1,4509,4521,4331,4507,-1,4343,4344,4476,-1,4476,4345,4346,4477,-1,4477,4346,4347,4479,-1,4479,4347,4348,4481,-1,4481,4348,4349,4483,-1,4483,4349,4350,4485,-1,4485,4350,4351,4487,-1,4487,4351,4352,4489,-1,4335,4334,4491,4543,-1,4543,4491,4493,4541,-1,4541,4493,4495,4539,-1,4539,4495,4497,4537,-1,4537,4497,4499,4535,-1,4535,4499,4501,4533,-1,4533,4501,4503,4531,-1,4531,4503,4505,4528,-1,4528,4505,4387,4529,-1,4489,4352,4353,4422,-1,4322,4321,4524,-1,4524,4321,4323,4525,-1,4525,4323,4324,4560,-1,4560,4324,4325,-1,4520,4519,4527,-1,4527,4519,4518,4530,-1,4530,4518,4516,4532,-1,4532,4516,4514,4534,-1,4534,4514,4512,4536,-1,4536,4512,4510,4538,-1,4538,4510,4508,4540,-1,4540,4508,4506,4542,-1,4542,4506,4333,4332,-1,4337,4336,4559,4490,-1,4490,4559,4557,4492,-1,4492,4557,4555,4494,-1,4494,4555,4553,4496,-1,4496,4553,4551,4498,-1,4498,4551,4549,4500,-1,4500,4549,4547,4502,-1,4502,4547,4545,4504,-1,4504,4545,4443,4386,-1,4423,4442,4544,4488,-1,4488,4544,4546,4486,-1,4486,4546,4548,4484,-1,4484,4548,4550,4482,-1,4482,4550,4552,4480,-1,4480,4552,4554,4478,-1,4478,4554,4556,4475,-1,4475,4556,4558,4474,-1,4474,4558,4339,4338,-1,4523,4327,4328,-1,4523,4328,4329,-1,4476,4344,4345,-1,4476,4342,4343,-1,4326,4327,4523,-1,4325,4326,4523,4560,-1,4361,4357,4525,4560,-1,4363,4361,4560,4523,-1,4295,4296,4329,-1,4329,4296,4365,-1,4365,4296,4366,-1,4366,4296,4331,-1,4407,4341,4342,4476,-1,4428,4426,4559,4336,-1,4339,4558,4427,4429,-1,4426,4425,4557,4559,-1,4558,4556,4424,4427,-1,4425,4431,4555,4557,-1,4556,4554,4430,4424,-1,4431,4433,4553,4555,-1,4554,4552,4432,4430,-1,4433,4435,4551,4553,-1,4552,4550,4434,4432,-1,4435,4437,4549,4551,-1,4550,4548,4436,4434,-1,4437,4439,4547,4549,-1,4548,4546,4438,4436,-1,4439,4441,4545,4547,-1,4546,4544,4440,4438,-1,4441,4443,4545,-1,4544,4442,4440,-1,4369,4368,4335,4543,-1,4542,4332,4367,4370,-1,4385,4369,4543,4541,-1,4540,4542,4370,4384,-1,4383,4385,4541,4539,-1,4538,4540,4384,4382,-1,4381,4383,4539,4537,-1,4536,4538,4382,4380,-1,4379,4381,4537,4535,-1,4534,4536,4380,4378,-1,4377,4379,4535,4533,-1,4532,4534,4378,4376,-1,4375,4377,4533,4531,-1,4530,4532,4376,4374,-1,4372,4375,4531,4528,-1,4527,4530,4374,4371,-1,4373,4372,4528,4529,-1,4520,4527,4371,4373,-1,4358,4362,4522,4526,-1,4359,4358,4526,4470,-1,4524,4525,4357,4360,-1,4356,4322,4468,4466,-1,4322,4360,4359,4468,-1,4524,4360,4322,-1,4364,4366,4331,4521,-1,4523,4329,4365,4363,-1,4362,4364,4521,4522,-1,4461,4462,4471,4472,-1,4519,4520,4462,4460,-1,4459,4461,4472,4473,-1,4518,4519,4460,4458,-1,4457,4459,4473,4517,-1,4516,4518,4458,4456,-1,4455,4457,4517,4515,-1,4514,4516,4456,4454,-1,4453,4455,4515,4513,-1,4512,4514,4454,4452,-1,4451,4453,4513,4511,-1,4510,4512,4452,4450,-1,4445,4451,4511,4509,-1,4508,4510,4450,4444,-1,4446,4445,4509,4507,-1,4506,4508,4444,4447,-1,4448,4446,4507,4330,-1,4333,4506,4447,4449,-1,4388,4387,4505,-1,4504,4386,4389,-1,4390,4388,4505,4503,-1,4502,4504,4389,4391,-1,4392,4390,4503,4501,-1,4500,4502,4391,4393,-1,4394,4392,4501,4499,-1,4498,4500,4393,4395,-1,4396,4394,4499,4497,-1,4496,4498,4395,4397,-1,4398,4396,4497,4495,-1,4494,4496,4397,4399,-1,4400,4398,4495,4493,-1,4492,4494,4399,4401,-1,4403,4400,4493,4491,-1,4490,4492,4401,4402,-1,4404,4403,4491,4334,-1,4337,4490,4402,4405,-1,4420,4489,4422,-1,4488,4421,4423,-1,4420,4418,4487,4489,-1,4488,4486,4419,4421,-1,4418,4416,4485,4487,-1,4486,4484,4417,4419,-1,4416,4414,4483,4485,-1,4484,4482,4415,4417,-1,4414,4412,4481,4483,-1,4482,4480,4413,4415,-1,4412,4410,4479,4481,-1,4480,4478,4411,4413,-1,4410,4408,4477,4479,-1,4478,4475,4409,4411,-1,4408,4407,4476,4477,-1,4475,4474,4406,4409,-1,4474,4338,4340,4406,-1,4467,4473,4472,4463,-1,4463,4472,4471,4464,-1,4359,4470,4469,4468,-1,4468,4469,4467,4466,-1,4466,4467,4463,4465,-1,4465,4463,4464,-1,4680,4258,4256,4682,-1,4336,4303,4428,-1,4303,4304,4428,-1,4428,4304,4429,-1,4304,4339,4429,-1,4299,4300,4332,-1,4332,4300,4367,-1,4367,4300,4368,-1,4300,4335,4368,-1,4297,4298,4330,-1,4330,4298,4448,-1,4448,4298,4449,-1,4298,4333,4449,-1,4301,4302,4334,-1,4337,4405,4302,-1,4334,4302,4404,-1,4302,4405,4404,-1,4461,4460,4462,-1,4459,4458,4460,4461,-1,4457,4456,4458,4459,-1,4455,4454,4456,4457,-1,4453,4452,4454,4455,-1,4451,4450,4452,4453,-1,4445,4444,4450,4451,-1,4448,4449,4447,4446,-1,4446,4447,4444,4445,-1,4441,4440,4442,4443,-1,4439,4438,4440,4441,-1,4437,4436,4438,4439,-1,4435,4434,4436,4437,-1,4433,4432,4434,4435,-1,4431,4430,4432,4433,-1,4425,4424,4430,4431,-1,4428,4429,4427,4426,-1,4426,4427,4424,4425,-1,4407,4406,4340,4341,-1,4422,4423,4421,4420,-1,4420,4421,4419,4418,-1,4418,4419,4417,4416,-1,4416,4417,4415,4414,-1,4414,4415,4413,4412,-1,4412,4413,4411,4410,-1,4410,4411,4409,4408,-1,4408,4409,4406,4407,-1,4403,4402,4401,4400,-1,4404,4405,4402,4403,-1,4400,4401,4399,4398,-1,4398,4399,4397,4396,-1,4396,4397,4395,4394,-1,4394,4395,4393,4392,-1,4392,4393,4391,4390,-1,4390,4391,4389,4388,-1,4388,4389,4386,4387,-1,4385,4384,4370,4369,-1,4383,4382,4384,4385,-1,4381,4380,4382,4383,-1,4379,4378,4380,4381,-1,4377,4376,4378,4379,-1,4375,4374,4376,4377,-1,4372,4371,4374,4375,-1,4373,4371,4372,-1,4369,4370,4367,4368,-1,4364,4363,4365,4366,-1,4362,4361,4363,4364,-1,4358,4357,4361,4362,-1,4359,4360,4357,4358,-1,4356,4320,4288,4322,-1,4354,4318,4320,4356,-1,4355,4319,4318,4354,-1,4352,4316,4317,4353,-1,4351,4315,4316,4352,-1,4350,4314,4315,4351,-1,4349,4313,4314,4350,-1,4348,4312,4313,4349,-1,4347,4311,4312,4348,-1,4346,4310,4311,4347,-1,4345,4309,4310,4346,-1,4344,4308,4309,4345,-1,4343,4307,4308,4344,-1,4342,4306,4307,4343,-1,4342,4341,4306,-1,4306,4341,4305,-1,4341,4340,4305,-1,4305,4340,4338,-1,4339,4304,4305,4338,-1,4337,4302,4303,4336,-1,4335,4300,4301,4334,-1,4333,4298,4299,4332,-1,4331,4296,4297,4330,-1,4328,4294,4295,4329,-1,4327,4293,4294,4328,-1,4326,4292,4293,4327,-1,4325,4291,4292,4326,-1,4324,4290,4291,4325,-1,4323,4289,4290,4324,-1,4321,4287,4289,4323,-1,4322,4288,4287,4321,-1,4320,4227,4228,4288,-1,4318,4226,4227,4320,-1,4319,4286,4226,4318,-1,4316,4277,4285,4317,-1,4315,4275,4277,4316,-1,4314,4273,4275,4315,-1,4313,4271,4273,4314,-1,4312,4269,4271,4313,-1,4311,4266,4269,4312,-1,4310,4263,4266,4311,-1,4309,4261,4263,4310,-1,4308,4259,4261,4309,-1,4307,4257,4259,4308,-1,4306,4255,4257,4307,-1,4305,4205,4255,4306,-1,4304,4202,4205,4305,-1,4303,4203,4202,4304,-1,4302,4208,4203,4303,-1,4301,4207,4208,4302,-1,4300,4201,4207,4301,-1,4299,4199,4201,4300,-1,4298,4198,4199,4299,-1,4297,4197,4198,4298,-1,4296,4237,4197,4297,-1,4295,4236,4237,4296,-1,4294,4235,4236,4295,-1,4293,4234,4235,4294,-1,4292,4233,4234,4293,-1,4291,4232,4233,4292,-1,4290,4231,4232,4291,-1,4289,4230,4231,4290,-1,4287,4229,4230,4289,-1,4288,4228,4229,4287,-1,4285,4277,4279,-1,4272,4661,4663,4274,-1,4270,4657,4661,4272,-1,4268,4660,4657,4270,-1,4267,4670,4660,4268,-1,4260,4678,4676,4262,-1,4193,4194,4682,4256,-1,4193,4255,4205,4186,-1,4186,4205,4195,-1,4204,4200,4196,4195,-1,4200,4204,4203,4206,-1,4203,4208,4206,-1,4665,4276,4274,4663,-1,4678,4260,4258,4680,-1,4674,4264,4262,4676,-1,4264,4674,4672,4265,-1,4667,4278,4276,4665,-1,4225,4226,4286,-1,4286,4284,4225,-1,4254,4280,4278,4667,-1,4279,4283,4285,-1,4284,4224,4225,-1,4279,4281,4283,-1,4265,4672,4670,4267,-1,4282,4281,4280,-1,4280,4281,4279,4278,-1,4278,4279,4277,4276,-1,4276,4277,4275,4274,-1,4274,4275,4273,4272,-1,4272,4273,4271,4270,-1,4270,4271,4269,4268,-1,4268,4269,4266,4267,-1,4267,4266,4265,-1,4265,4266,4263,4264,-1,4264,4263,4262,-1,4262,4263,4261,4260,-1,4260,4261,4259,4258,-1,4258,4259,4257,4256,-1,4256,4257,4255,4193,-1,4189,4188,4656,4629,-1,4629,4656,4654,4627,-1,4627,4654,4652,4625,-1,4625,4652,4650,4623,-1,4623,4650,4648,4621,-1,4621,4648,4646,4619,-1,4619,4646,4644,4617,-1,4617,4644,4634,4579,-1,4579,4634,4631,4582,-1,4582,4631,4635,4615,-1,4615,4635,4637,4613,-1,4613,4637,4639,4609,-1,4609,4639,4641,4612,-1,4612,4641,4252,4253,-1,4253,4254,4668,4611,-1,4611,4668,4666,4610,-1,4610,4666,4664,4614,-1,4614,4664,4662,4616,-1,4616,4662,4658,4581,-1,4581,4658,4659,4580,-1,4580,4659,4669,4618,-1,4618,4669,4671,4620,-1,4620,4671,4673,4622,-1,4622,4673,4675,4624,-1,4624,4675,4677,4626,-1,4626,4677,4679,4628,-1,4628,4679,4681,4630,-1,4630,4681,4194,4189,-1,4191,4190,4586,4238,-1,4238,4586,4583,4239,-1,4239,4583,4587,4240,-1,4240,4587,4589,4241,-1,4241,4589,4591,4242,-1,4242,4591,4593,4243,-1,4243,4593,4595,4244,-1,4244,4595,4597,4245,-1,4245,4597,4608,4246,-1,4246,4608,4606,4247,-1,4247,4606,4604,4248,-1,4248,4604,4602,4249,-1,4249,4602,4599,4250,-1,4250,4599,4223,4251,-1,4251,4252,4642,4250,-1,4250,4642,4640,4249,-1,4249,4640,4638,4248,-1,4248,4638,4636,4247,-1,4247,4636,4632,4246,-1,4246,4632,4633,4245,-1,4245,4633,4643,4244,-1,4244,4643,4645,4243,-1,4243,4645,4647,4242,-1,4242,4647,4649,4241,-1,4241,4649,4651,4240,-1,4240,4651,4653,4239,-1,4239,4653,4655,4238,-1,4238,4655,4188,4191,-1,4192,4197,4237,4209,-1,4209,4237,4236,4210,-1,4210,4236,4235,4211,-1,4211,4235,4234,4212,-1,4212,4234,4233,4213,-1,4213,4233,4232,4214,-1,4214,4232,4231,4215,-1,4215,4231,4230,4216,-1,4216,4230,4229,4217,-1,4217,4229,4228,4218,-1,4218,4228,4227,4219,-1,4219,4227,4226,4220,-1,4220,4226,4225,4221,-1,4221,4225,4224,4222,-1,4222,4223,4600,4221,-1,4221,4600,4601,4220,-1,4220,4601,4603,4219,-1,4219,4603,4605,4218,-1,4218,4605,4607,4217,-1,4217,4607,4598,4216,-1,4216,4598,4596,4215,-1,4215,4596,4594,4214,-1,4214,4594,4592,4213,-1,4213,4592,4590,4212,-1,4212,4590,4588,4211,-1,4211,4588,4584,4210,-1,4210,4584,4585,4209,-1,4209,4585,4190,4192,-1,4208,4207,4206,-1,4206,4207,4201,4200,-1,4195,4205,4202,4204,-1,4204,4202,4203,-1,4200,4201,4199,4196,-1,4196,4199,4198,4187,-1,4187,4198,4197,4192,-1,4195,4196,4187,4186,-1,4186,4189,4194,-1,4194,4193,4186,-1,4187,4192,4190,-1,4191,4188,4187,-1,4187,4190,4191,-1,4188,4189,4186,4187,-1,4576,4282,4683,-1,4683,4282,4280,4254,-1,4252,4684,4683,-1,4683,4253,4252,-1,4223,4577,4684,-1,4684,4252,4251,-1,4575,4576,4683,4684,-1,4684,4251,4223,-1,4222,4224,4577,-1,4577,4223,4222,-1],creaseAngle=.9,texCoordIndex=[0,1,2,3,-1,4,5,6,7,-1,8,9,10,11,-1,12,276,275,13,-1,14,15,16,17,-1,17,16,18,19,-1,19,18,20,286,-1,15,14,21,-1,22,23,24,25,-1,26,27,23,22,-1,27,26,28,29,-1,30,31,29,28,-1,32,33,31,30,-1,34,35,33,32,-1,25,24,36,37,-1,38,39,37,36,-1,40,41,35,34,-1,42,43,41,40,-1,44,45,43,42,-1,46,47,45,-1,46,48,1521,-1,45,44,48,46,-1,47,46,52,53,-1,53,52,21,14,-1,46,1521,1588,52,-1,52,1588,1589,21,-1,1764,48,44,1765,-1,1766,1521,48,1764,-1,61,62,63,64,-1,62,61,65,66,-1,1560,51,67,68,-1,69,1558,1560,68,-1,70,17,19,71,-1,19,286,314,71,-1,17,70,53,14,-1,72,67,51,1563,-1,67,73,74,68,-1,72,75,73,67,-1,76,77,75,72,-1,71,78,79,70,-1,79,78,80,81,-1,78,317,318,80,-1,79,81,43,-1,80,318,82,83,-1,84,35,41,81,-1,85,86,31,33,-1,87,83,82,88,-1,89,90,319,320,-1,1800,37,39,1798,-1,91,320,321,92,-1,77,92,93,75,-1,92,321,94,93,-1,75,93,95,96,-1,75,96,73,-1,73,96,97,74,-1,96,95,98,97,-1,97,98,99,100,-1,314,317,78,71,-1,93,94,101,95,-1,98,95,101,102,-1,70,79,47,53,-1,68,74,103,104,-1,61,99,343,65,-1,99,98,102,343,-1,99,61,64,100,-1,103,74,97,100,-1,64,105,103,100,-1,106,49,1558,69,-1,107,108,104,105,-1,64,63,107,105,-1,36,110,111,38,-1,112,110,36,24,-1,43,81,41,-1,85,33,35,84,-1,113,23,27,114,-1,115,38,111,-1,112,24,23,113,-1,320,91,89,-1,47,79,43,45,-1,109,76,1564,1565,-1,109,39,38,-1,54,25,37,1800,-1,55,22,25,54,-1,56,26,22,55,-1,28,26,56,57,-1,1808,32,30,1806,-1,58,34,32,1808,-1,59,40,34,58,-1,60,42,40,59,-1,1765,44,42,60,-1,116,114,27,29,-1,88,319,90,117,-1,117,87,88,-1,29,31,86,116,-1,57,1806,30,28,-1,1798,39,109,-1,38,115,76,109,-1,76,72,1563,1564,-1,81,80,84,-1,84,80,83,85,-1,85,83,87,86,-1,86,87,117,116,-1,116,117,90,114,-1,114,90,89,113,-1,113,89,91,112,-1,112,91,110,-1,110,91,92,111,-1,111,92,77,115,-1,115,77,76,-1,104,103,105,-1,118,119,107,63,-1,66,120,121,62,-1,123,124,119,118,-1,118,63,62,121,-1,121,120,122,125,-1,3,2,124,123,-1,125,122,276,12,-1,3,123,125,12,-1,104,108,126,-1,107,127,128,108,-1,108,129,130,126,-1,127,131,132,128,-1,129,133,134,130,-1,129,108,128,-1,127,107,119,-1,135,136,137,138,-1,12,13,0,3,-1,123,118,121,125,-1,2,1,7,6,-1,124,2,6,131,-1,131,6,5,132,-1,119,124,131,127,-1,5,4,11,10,-1,128,132,133,129,-1,132,5,10,133,-1,133,10,9,134,-1,49,139,140,50,-1,141,139,49,106,-1,139,142,143,140,-1,141,144,142,139,-1,142,138,137,143,-1,144,138,142,-1,145,126,130,-1,9,8,136,135,-1,134,9,135,146,-1,130,134,146,145,-1,68,104,69,-1,69,104,126,106,-1,106,126,145,141,-1,141,145,146,144,-1,144,146,135,138,-1,147,148,1,0,-1,7,149,150,4,-1,11,151,152,8,-1,13,275,361,153,-1,154,16,15,155,-1,156,18,16,154,-1,366,20,18,156,-1,21,155,15,-1,157,158,159,160,-1,160,159,161,162,-1,163,164,162,161,-1,164,163,165,166,-1,166,165,167,168,-1,168,167,169,170,-1,171,172,158,157,-1,172,171,173,174,-1,170,169,175,176,-1,176,175,177,178,-1,178,177,179,180,-1,179,181,182,-1,1875,183,182,-1,182,183,180,179,-1,185,186,182,181,-1,155,21,186,185,-1,186,1934,1875,182,-1,21,1589,1934,186,-1,2084,180,183,2085,-1,2085,183,1875,2086,-1,187,188,189,190,-1,191,376,190,189,-1,192,193,1902,1900,-1,192,1900,1898,194,-1,195,156,154,196,-1,195,197,366,156,-1,155,185,196,154,-1,184,1902,193,198,-1,192,199,200,193,-1,193,200,201,198,-1,198,201,202,203,-1,196,204,205,195,-1,206,207,205,204,-1,207,390,391,205,-1,177,206,204,-1,208,209,390,207,-1,206,175,169,210,-1,167,165,211,212,-1,213,209,208,214,-1,392,393,215,216,-1,2118,173,171,2120,-1,217,394,392,218,-1,201,219,217,202,-1,219,220,394,217,-1,221,222,219,201,-1,200,221,201,-1,199,223,221,200,-1,223,224,222,221,-1,225,226,224,223,-1,195,205,391,197,-1,222,227,220,219,-1,228,227,222,224,-1,185,181,204,196,-1,229,230,199,192,-1,376,416,226,190,-1,416,228,224,226,-1,225,187,190,226,-1,225,223,199,230,-1,225,230,231,187,-1,194,1898,1877,232,-1,231,229,233,234,-1,231,234,188,187,-1,174,235,236,172,-1,158,172,236,237,-1,175,206,177,-1,210,169,167,212,-1,238,161,159,239,-1,235,174,240,-1,239,159,158,237,-1,216,218,392,-1,179,177,204,181,-1,1905,1907,203,2173,-1,174,173,2173,-1,2120,171,157,2122,-1,2122,157,160,2124,-1,2124,160,162,2126,-1,2128,2126,162,164,-1,2130,166,168,2132,-1,2132,168,170,2134,-1,2134,170,176,2136,-1,2136,176,178,2138,-1,2138,178,180,2084,-1,163,161,238,241,-1,242,215,393,213,-1,213,214,242,-1,241,211,165,163,-1,164,166,2130,2128,-1,2173,173,2118,-1,2173,203,240,174,-1,1907,184,198,203,-1,210,207,206,-1,212,208,207,210,-1,211,214,208,212,-1,241,242,214,211,-1,238,215,242,241,-1,239,216,215,238,-1,237,218,216,239,-1,236,218,237,-1,235,217,218,236,-1,240,202,217,235,-1,203,202,240,-1,231,230,229,-1,188,234,243,244,-1,189,245,246,191,-1,244,243,247,248,-1,245,189,188,244,-1,249,432,246,245,-1,248,247,148,147,-1,153,361,432,249,-1,153,249,248,147,-1,250,233,229,-1,233,251,252,234,-1,250,253,254,233,-1,251,255,256,252,-1,253,257,258,254,-1,251,233,254,-1,243,234,252,-1,259,137,136,260,-1,147,0,13,153,-1,249,245,244,248,-1,149,7,1,148,-1,256,149,148,247,-1,255,150,149,256,-1,252,256,247,243,-1,151,11,4,150,-1,254,258,255,251,-1,258,151,150,255,-1,257,152,151,258,-1,50,140,261,1877,-1,232,1877,261,262,-1,140,143,263,261,-1,261,263,264,262,-1,143,137,259,263,-1,263,259,264,-1,253,250,265,-1,260,136,8,152,-1,266,260,152,257,-1,265,266,257,253,-1,194,229,192,-1,232,250,229,194,-1,262,265,250,232,-1,264,266,265,262,-1,259,260,266,264,-1,267,268,269,270,-1,271,272,273,274,-1,274,273,438,439,-1,271,270,269,272,-1,267,275,276,268,-1,277,278,279,280,-1,282,283,448,449,-1,284,285,283,282,-1,286,20,278,277,-1,282,287,280,-1,284,282,280,-1,449,451,287,282,-1,285,288,289,283,-1,448,283,289,290,-1,291,292,293,294,-1,281,448,290,295,-1,295,290,296,297,-1,289,298,296,290,-1,288,299,298,289,-1,297,296,300,301,-1,298,302,300,296,-1,299,303,302,298,-1,301,300,292,291,-1,302,293,292,300,-1,303,294,293,302,-1,284,280,279,-1,304,305,306,307,-1,308,309,310,311,-1,312,307,306,313,-1,65,305,304,66,-1,313,311,310,312,-1,286,277,315,314,-1,280,287,316,315,-1,287,451,517,316,-1,317,322,323,318,-1,318,323,324,82,-1,88,82,324,-1,319,325,326,320,-1,320,326,327,321,-1,321,327,328,94,-1,94,328,329,101,-1,315,322,317,314,-1,322,330,331,323,-1,323,331,332,324,-1,324,332,333,325,-1,325,333,334,326,-1,326,334,335,327,-1,327,335,336,328,-1,328,336,337,329,-1,101,329,338,339,-1,329,337,340,338,-1,339,102,101,-1,341,339,338,342,-1,341,343,102,339,-1,316,330,322,315,-1,330,519,520,331,-1,331,520,521,332,-1,332,521,522,333,-1,333,522,523,334,-1,334,523,524,335,-1,335,524,525,336,-1,336,525,526,337,-1,337,526,527,340,-1,338,340,344,345,-1,345,342,338,-1,517,519,330,316,-1,344,340,527,346,-1,344,346,308,311,-1,313,345,344,311,-1,305,341,342,306,-1,306,342,345,313,-1,65,343,341,305,-1,324,325,319,88,-1,304,347,120,66,-1,307,348,347,304,-1,312,349,348,307,-1,310,350,349,312,-1,309,351,350,310,-1,347,352,122,120,-1,348,353,352,347,-1,349,354,353,348,-1,350,355,354,349,-1,351,592,355,350,-1,352,268,276,122,-1,353,269,268,352,-1,354,272,269,353,-1,355,273,272,354,-1,592,438,273,355,-1,315,277,280,-1,270,356,357,267,-1,274,358,359,271,-1,439,360,358,274,-1,359,356,270,271,-1,357,361,275,267,-1,362,279,278,363,-1,618,616,364,365,-1,365,364,285,284,-1,363,278,20,366,-1,362,367,365,-1,362,365,284,-1,365,367,619,618,-1,364,368,288,285,-1,369,368,364,616,-1,294,370,371,291,-1,295,369,616,281,-1,297,372,369,295,-1,369,372,373,368,-1,368,373,299,288,-1,301,374,372,297,-1,372,374,375,373,-1,373,375,303,299,-1,291,371,374,301,-1,374,371,370,375,-1,375,370,294,303,-1,279,362,284,-1,377,378,379,380,-1,381,382,383,384,-1,385,378,377,386,-1,191,380,379,376,-1,386,382,381,385,-1,197,387,363,366,-1,387,388,367,362,-1,388,389,619,367,-1,390,395,396,391,-1,209,397,395,390,-1,397,209,213,-1,392,398,399,393,-1,394,400,398,392,-1,220,401,400,394,-1,227,402,401,220,-1,197,391,396,387,-1,395,403,404,396,-1,397,405,403,395,-1,399,406,405,397,-1,398,407,406,399,-1,400,408,407,398,-1,401,409,408,400,-1,402,410,409,401,-1,411,412,402,227,-1,412,413,410,402,-1,227,228,411,-1,414,412,411,415,-1,411,228,416,415,-1,387,396,404,388,-1,403,673,674,404,-1,405,417,673,403,-1,406,418,417,405,-1,407,419,418,406,-1,408,420,419,407,-1,409,421,420,408,-1,410,422,421,409,-1,413,423,422,410,-1,424,425,413,412,-1,412,414,424,-1,388,404,674,389,-1,426,423,413,425,-1,381,384,426,425,-1,381,425,424,385,-1,378,414,415,379,-1,385,424,414,378,-1,379,415,416,376,-1,213,393,399,397,-1,191,246,427,380,-1,380,427,428,377,-1,377,428,429,386,-1,386,429,430,382,-1,382,430,431,383,-1,246,432,433,427,-1,427,433,434,428,-1,428,434,435,429,-1,429,435,436,430,-1,430,436,437,431,-1,432,361,357,433,-1,433,357,356,434,-1,434,356,359,435,-1,435,359,358,436,-1,436,358,360,437,-1,362,363,387,-1,439,438,440,441,-1,442,441,440,443,-1,442,443,444,445,-1,446,447,448,281,-1,449,450,451,-1,451,450,452,453,-1,453,452,454,-1,455,456,457,458,-1,459,460,461,462,-1,463,464,460,459,-1,465,466,464,463,-1,467,468,466,465,-1,469,470,468,467,-1,471,472,470,469,-1,475,476,474,473,-1,477,478,476,475,-1,479,480,478,477,-1,481,482,480,479,-1,454,483,482,481,-1,452,484,483,454,-1,450,485,484,452,-1,486,487,488,489,-1,476,490,798,474,-1,478,491,490,476,-1,480,492,491,478,-1,482,493,492,480,-1,483,494,493,482,-1,484,495,494,483,-1,485,496,495,484,-1,496,485,497,-1,498,458,457,499,-1,490,500,807,798,-1,491,501,500,490,-1,492,502,501,491,-1,493,503,502,492,-1,494,504,503,493,-1,495,505,504,494,-1,496,499,505,495,-1,506,470,472,813,-1,507,468,470,506,-1,508,466,468,507,-1,509,464,466,508,-1,510,460,464,509,-1,511,461,460,510,-1,456,461,511,-1,479,477,512,513,-1,514,512,477,475,-1,475,473,515,514,-1,513,516,481,479,-1,517,451,453,518,-1,528,520,519,529,-1,520,528,530,521,-1,530,531,522,521,-1,531,532,523,522,-1,532,533,524,523,-1,524,533,525,-1,533,534,526,525,-1,534,535,527,526,-1,512,514,536,537,-1,512,537,538,513,-1,537,536,539,540,-1,536,541,542,539,-1,538,537,540,-1,539,542,822,543,-1,544,540,545,-1,543,822,823,546,-1,546,823,828,547,-1,545,548,532,531,-1,547,828,831,549,-1,548,550,533,532,-1,550,551,534,533,-1,549,831,834,552,-1,553,554,555,552,-1,551,555,556,-1,555,554,557,556,-1,835,553,552,834,-1,556,558,534,551,-1,558,556,557,559,-1,527,535,560,346,-1,545,531,530,-1,528,544,545,530,-1,518,529,519,517,-1,544,528,529,561,-1,518,562,529,-1,453,454,562,518,-1,562,516,561,529,-1,554,553,563,564,-1,565,566,559,557,-1,567,563,553,835,-1,568,308,346,560,-1,566,568,560,559,-1,564,565,557,554,-1,535,534,558,-1,560,535,558,559,-1,569,568,566,570,-1,570,566,565,571,-1,562,454,481,516,-1,516,513,538,561,-1,541,536,514,515,-1,561,538,540,544,-1,565,564,572,571,-1,572,564,563,573,-1,573,563,567,574,-1,309,308,568,569,-1,543,545,540,539,-1,546,548,545,543,-1,547,550,548,546,-1,549,551,550,547,-1,552,555,551,549,-1,499,496,575,498,-1,455,462,461,456,-1,511,457,456,-1,499,457,511,505,-1,505,511,510,504,-1,504,510,509,503,-1,503,509,508,502,-1,502,508,507,501,-1,501,507,506,500,-1,500,506,813,807,-1,576,577,445,444,-1,578,579,577,576,-1,867,868,579,578,-1,569,580,351,309,-1,570,581,580,569,-1,571,582,581,570,-1,583,584,585,582,-1,586,587,584,583,-1,588,879,587,586,-1,571,572,589,-1,589,572,573,590,-1,590,573,574,591,-1,591,588,586,590,-1,590,586,583,589,-1,589,583,582,571,-1,580,593,592,351,-1,581,594,593,580,-1,582,585,594,581,-1,593,440,438,592,-1,594,443,440,593,-1,585,444,443,594,-1,584,576,444,585,-1,587,578,576,584,-1,879,867,578,587,-1,450,449,448,485,-1,497,485,595,596,-1,448,447,595,485,-1,447,597,598,595,-1,446,599,597,447,-1,596,595,598,600,-1,597,601,602,598,-1,599,603,601,597,-1,600,598,602,604,-1,601,605,606,602,-1,603,607,605,601,-1,604,602,606,608,-1,605,609,610,606,-1,607,611,609,605,-1,608,606,610,612,-1,609,489,488,610,-1,611,486,489,609,-1,612,610,488,487,-1,497,575,496,-1,441,613,360,439,-1,614,613,441,442,-1,445,615,614,442,-1,281,616,617,446,-1,619,620,618,-1,621,622,620,619,-1,623,622,621,-1,458,624,625,455,-1,462,626,627,459,-1,459,627,628,463,-1,463,628,629,465,-1,465,629,630,467,-1,467,630,631,469,-1,469,631,925,471,-1,632,941,633,634,-1,634,633,635,636,-1,636,635,637,638,-1,638,637,639,640,-1,640,639,641,623,-1,623,641,642,622,-1,622,642,643,620,-1,644,645,487,486,-1,941,948,646,633,-1,633,646,647,635,-1,635,647,648,637,-1,637,648,649,639,-1,639,649,650,641,-1,641,650,651,642,-1,642,651,652,643,-1,497,643,652,-1,653,624,458,498,-1,948,955,654,646,-1,646,654,655,647,-1,647,655,656,648,-1,648,656,657,649,-1,649,657,658,650,-1,650,658,659,651,-1,651,659,653,652,-1,660,925,631,661,-1,661,631,630,662,-1,662,630,629,663,-1,663,629,628,664,-1,664,628,627,665,-1,665,627,626,666,-1,666,626,625,-1,667,668,636,638,-1,634,636,668,669,-1,669,670,632,634,-1,638,640,671,667,-1,672,621,619,389,-1,675,674,673,676,-1,417,677,676,673,-1,417,418,678,677,-1,418,419,679,678,-1,419,420,680,679,-1,421,680,420,-1,421,422,681,680,-1,422,423,682,681,-1,683,684,669,668,-1,667,685,683,668,-1,686,687,684,683,-1,687,688,689,684,-1,686,683,685,-1,690,691,688,687,-1,692,686,693,-1,694,969,691,690,-1,695,974,969,694,-1,678,679,696,692,-1,697,977,974,695,-1,679,680,698,696,-1,680,681,699,698,-1,700,980,977,697,-1,700,701,702,703,-1,704,701,699,-1,704,705,702,701,-1,980,700,703,706,-1,699,681,707,704,-1,708,705,704,707,-1,426,709,682,423,-1,677,678,692,-1,677,692,693,676,-1,389,674,675,672,-1,710,675,676,693,-1,675,711,672,-1,672,711,623,621,-1,675,710,671,711,-1,712,713,703,702,-1,705,708,714,715,-1,706,703,713,716,-1,709,426,384,717,-1,708,709,717,714,-1,702,705,715,712,-1,707,681,682,-1,708,707,682,709,-1,718,714,717,719,-1,720,715,714,718,-1,671,640,623,711,-1,710,685,667,671,-1,670,669,684,689,-1,693,686,685,710,-1,720,721,712,715,-1,722,713,712,721,-1,723,716,713,722,-1,719,717,384,383,-1,687,686,692,690,-1,690,692,696,694,-1,694,696,698,695,-1,695,698,699,697,-1,697,699,701,700,-1,498,575,652,653,-1,625,626,462,455,-1,625,624,666,-1,659,666,624,653,-1,658,665,666,659,-1,657,664,665,658,-1,656,663,664,657,-1,655,662,663,656,-1,654,661,662,655,-1,955,660,661,654,-1,615,445,577,724,-1,724,577,579,725,-1,725,579,868,726,-1,383,431,727,719,-1,719,727,728,718,-1,718,728,729,720,-1,729,730,731,732,-1,732,731,733,734,-1,734,733,735,736,-1,737,721,720,-1,738,722,721,737,-1,739,723,722,738,-1,738,734,736,739,-1,737,732,734,738,-1,720,729,732,737,-1,431,437,740,727,-1,727,740,741,728,-1,728,741,730,729,-1,437,360,613,740,-1,740,613,614,741,-1,741,614,615,730,-1,730,615,724,731,-1,731,724,725,733,-1,733,725,726,735,-1,643,616,618,620,-1,596,742,643,497,-1,643,742,617,616,-1,742,743,744,617,-1,617,744,599,446,-1,600,743,742,596,-1,743,745,746,744,-1,744,746,603,599,-1,604,745,743,600,-1,745,747,748,746,-1,746,748,607,603,-1,608,747,745,604,-1,747,749,750,748,-1,748,750,611,607,-1,612,749,747,608,-1,749,645,644,750,-1,750,644,486,611,-1,487,645,749,612,-1,652,575,497,-1,753,754,1049,-1,1050,755,753,1049,-1,754,753,756,-1,757,758,759,760,-1,760,759,761,762,-1,763,764,765,-1,766,767,763,765,-1,768,769,764,763,-1,767,766,770,-1,771,772,472,471,-1,773,774,772,771,-1,775,776,777,778,-1,779,780,776,775,-1,780,779,781,782,-1,767,783,784,763,-1,770,785,783,767,-1,786,787,785,770,-1,788,789,787,786,-1,790,791,789,788,-1,473,474,791,790,-1,783,792,793,784,-1,785,794,792,783,-1,787,795,794,785,-1,789,796,795,787,-1,791,797,796,789,-1,474,798,797,791,-1,793,799,800,801,-1,792,802,799,793,-1,794,803,802,792,-1,795,804,803,794,-1,796,805,804,795,-1,797,806,805,796,-1,798,807,806,797,-1,808,780,782,-1,809,776,780,808,-1,810,777,776,809,-1,811,774,777,810,-1,812,772,774,811,-1,813,472,772,812,-1,766,765,814,815,-1,770,766,815,816,-1,817,818,788,786,-1,790,819,515,473,-1,786,770,816,817,-1,819,790,788,818,-1,820,754,757,821,-1,824,825,826,827,-1,829,826,825,830,-1,830,832,833,829,-1,836,837,838,839,-1,833,832,840,841,-1,831,842,834,-1,841,840,843,844,-1,845,821,846,847,-1,542,848,822,-1,849,850,851,852,-1,824,827,852,851,-1,850,853,854,851,-1,855,856,848,-1,819,818,856,855,-1,850,849,817,816,-1,765,1254,1255,814,-1,1256,1257,857,858,-1,1257,1260,859,857,-1,858,857,854,853,-1,858,814,1255,1256,-1,857,859,860,854,-1,858,853,815,814,-1,1260,1265,836,859,-1,859,836,839,860,-1,1265,1267,837,836,-1,1267,1271,861,837,-1,837,861,847,838,-1,845,861,1271,1273,-1,861,845,847,-1,1273,820,821,845,-1,760,846,821,757,-1,844,843,762,862,-1,835,863,864,567,-1,834,842,863,835,-1,816,815,853,850,-1,515,819,855,541,-1,541,855,848,542,-1,864,862,865,866,-1,567,864,866,574,-1,829,828,823,826,-1,833,831,828,829,-1,841,842,831,833,-1,844,863,842,841,-1,862,864,863,844,-1,843,846,760,762,-1,840,847,846,843,-1,832,838,847,840,-1,830,839,838,832,-1,825,839,830,-1,761,865,862,762,-1,852,848,856,849,-1,827,822,848,852,-1,826,823,822,827,-1,824,860,839,825,-1,851,854,860,824,-1,849,856,818,817,-1,807,813,812,806,-1,806,812,811,805,-1,805,811,810,804,-1,804,810,809,803,-1,803,809,808,802,-1,802,808,782,799,-1,799,782,781,800,-1,765,764,751,1254,-1,869,870,871,872,-1,873,874,870,869,-1,875,876,877,878,-1,880,881,882,883,-1,884,885,881,880,-1,886,887,885,884,-1,888,889,887,886,-1,890,891,888,-1,892,893,894,895,-1,591,574,866,896,-1,896,866,865,897,-1,897,865,761,898,-1,898,761,759,899,-1,899,759,758,900,-1,901,753,755,902,-1,902,903,904,901,-1,905,888,900,906,-1,900,888,886,899,-1,899,886,884,898,-1,898,884,880,897,-1,897,880,883,896,-1,896,883,588,591,-1,893,907,908,894,-1,895,904,903,892,-1,909,888,891,-1,888,905,890,-1,889,888,909,-1,588,883,882,879,-1,882,872,867,879,-1,881,869,872,882,-1,885,873,869,881,-1,878,877,874,873,-1,756,753,901,906,-1,906,901,904,905,-1,905,904,895,890,-1,890,895,894,891,-1,891,894,908,909,-1,909,908,875,889,-1,889,875,878,887,-1,887,878,873,885,-1,906,900,758,756,-1,756,758,757,754,-1,1291,910,911,-1,1291,911,755,1050,-1,912,911,910,-1,913,914,915,916,-1,917,918,914,913,-1,919,920,921,-1,919,921,922,923,-1,921,920,769,768,-1,924,923,922,-1,471,925,926,771,-1,771,926,927,773,-1,778,777,774,773,927,928,-1,778,928,929,775,-1,775,929,930,779,-1,931,781,779,930,-1,1289,752,751,764,769,920,-1,768,763,784,932,921,-1,921,932,933,922,-1,922,933,934,924,-1,924,934,935,936,-1,936,935,937,938,-1,938,937,939,940,-1,940,939,941,632,-1,784,793,801,942,932,-1,932,942,943,933,-1,933,943,944,934,-1,934,944,945,935,-1,935,945,946,937,-1,937,946,947,939,-1,939,947,948,941,-1,801,800,949,942,-1,942,949,950,943,-1,943,950,951,944,-1,944,951,952,945,-1,945,952,953,946,-1,946,953,954,947,-1,947,954,955,948,-1,931,930,956,-1,956,930,929,957,-1,957,929,928,958,-1,958,928,927,959,-1,959,927,926,960,-1,960,926,925,660,-1,961,962,919,923,-1,963,961,923,924,-1,936,938,964,965,-1,632,670,966,940,-1,965,963,924,936,-1,964,938,940,966,-1,968,916,910,967,-1,970,971,972,973,-1,975,972,971,976,-1,976,978,979,975,-1,981,982,983,984,-1,985,986,979,978,-1,980,987,977,-1,988,989,986,985,-1,990,991,968,992,-1,691,993,688,-1,994,995,996,997,-1,995,994,970,973,-1,995,998,999,996,-1,993,1000,1001,-1,1001,1000,964,966,-1,963,965,997,996,-1,962,1463,1462,919,-1,1002,1003,1464,1465,-1,1003,1004,1005,1464,-1,999,998,1003,1002,-1,1465,1463,962,1002,-1,998,1006,1004,1003,-1,962,961,999,1002,-1,1004,984,1007,1005,-1,1006,981,984,1004,-1,984,983,1008,1007,-1,983,1010,1009,1008,-1,982,990,1010,983,-1,1011,1009,1010,992,-1,990,992,1010,-1,992,968,967,1011,-1,916,968,991,913,-1,1012,917,989,988,-1,716,1013,1014,706,-1,706,1014,987,980,-1,996,999,961,963,-1,689,1001,966,670,-1,688,993,1001,689,-1,1015,1016,1012,1013,-1,723,1015,1013,716,-1,971,969,974,976,-1,976,974,977,978,-1,978,977,987,985,-1,985,987,1014,988,-1,988,1014,1013,1012,-1,917,913,991,989,-1,989,991,990,986,-1,986,990,982,979,-1,979,982,981,975,-1,975,981,972,-1,917,1012,1016,918,-1,997,1000,993,994,-1,994,993,691,970,-1,970,691,969,971,-1,972,981,1006,973,-1,973,1006,998,995,-1,965,964,1000,997,-1,954,960,660,955,-1,953,959,960,954,-1,952,958,959,953,-1,951,957,958,952,-1,950,956,957,951,-1,949,931,956,950,-1,800,781,931,949,-1,1462,1289,920,919,-1,1017,726,868,867,872,871,-1,1017,871,870,1018,-1,1018,870,874,1019,-1,1020,877,876,1021,-1,1021,876,875,908,907,1022,-1,1023,1024,1025,1026,-1,1026,1025,1027,1028,-1,1028,1027,1029,1030,-1,1030,1029,1031,1032,-1,1032,1033,1034,-1,1035,1036,893,892,-1,1037,1015,723,739,-1,1038,1016,1015,1037,-1,1039,918,1016,1038,-1,1040,914,918,1039,-1,1041,915,914,1040,-1,902,755,911,1042,-1,1042,1043,903,902,-1,1044,1041,1032,1045,-1,1040,1030,1032,1041,-1,1039,1028,1030,1040,-1,1038,1026,1028,1039,-1,1037,1023,1026,1038,-1,739,736,1023,1037,-1,1036,1022,907,893,-1,892,903,1043,1035,-1,1033,1032,1046,-1,1034,1045,1032,-1,1046,1032,1031,-1,735,1024,1023,736,-1,735,726,1017,1024,-1,1024,1017,1018,1025,-1,1025,1018,1019,1027,-1,1019,874,877,1020,-1,1044,1042,911,912,-1,1045,1043,1042,1044,-1,1034,1035,1043,1045,-1,1033,1036,1035,1034,-1,1046,1022,1036,1033,-1,1031,1021,1022,1046,-1,1029,1020,1021,1031,-1,1027,1019,1020,1029,-1,912,915,1041,1044,-1,910,916,915,912,-1,1047,1048,751,752,-1,1051,1052,1053,1054,-1,1054,1053,1055,1056,-1,1056,1055,1057,1058,-1,1058,1057,1059,1060,-1,1060,1059,1061,1062,-1,1062,1061,1063,1064,-1,1064,1063,1065,1066,-1,1066,1065,1067,1068,-1,1068,1067,1069,1070,-1,1070,1069,1071,1072,-1,1072,1071,1073,1074,-1,1074,1073,1075,1076,-1,1076,1075,1077,1078,-1,1078,1077,1079,1080,-1,1080,1079,1081,1082,-1,1082,1081,1083,1084,-1,1084,1083,1085,1086,-1,1085,1087,1088,1086,-1,1088,1087,1089,1090,-1,1090,1089,1091,1092,-1,1092,1091,1093,1094,-1,1094,1093,1095,1096,-1,1097,1098,1099,1100,-1,1101,1102,1098,1097,-1,1103,1104,1102,1101,-1,1105,1106,1104,1103,-1,1107,1108,1106,1105,-1,1109,1110,1108,1107,-1,1111,1112,1110,1109,-1,1113,1114,1112,1111,-1,1115,1116,1114,1113,-1,1117,1118,1116,1115,-1,1119,1120,1118,1117,-1,1121,1122,1120,1119,-1,1123,1124,1122,1121,-1,1125,1126,1124,1123,-1,1127,1128,1126,1125,-1,1129,1130,1128,1127,-1,1131,1132,1130,1129,-1,1133,1134,1132,1131,-1,1135,1136,1134,1133,-1,1137,1138,1136,1135,-1,1139,1140,1138,1137,-1,1141,1142,1140,1139,-1,751,1048,1142,1141,-1,1047,1143,1144,1048,-1,1098,1145,1146,1099,-1,1102,1147,1145,1098,-1,1104,1148,1147,1102,-1,1106,1149,1148,1104,-1,1108,1150,1149,1106,-1,1110,1151,1150,1108,-1,1112,1152,1151,1110,-1,1114,1153,1152,1112,-1,1116,1154,1153,1114,-1,1118,1155,1154,1116,-1,1120,1156,1155,1118,-1,1122,1157,1156,1120,-1,1124,1158,1157,1122,-1,1126,1159,1158,1124,-1,1128,1160,1159,1126,-1,1130,1161,1160,1128,-1,1132,1162,1161,1130,-1,1134,1163,1162,1132,-1,1136,1164,1163,1134,-1,1138,1165,1164,1136,-1,1140,1166,1165,1138,-1,1142,1167,1166,1140,-1,1048,1144,1167,1142,-1,1147,1168,1169,1145,-1,1148,1170,1168,1147,-1,1149,1171,1170,1148,-1,1150,1172,1171,1149,-1,1151,1173,1172,1150,-1,1152,1174,1173,1151,-1,1153,1175,1174,1152,-1,1154,1176,1175,1153,-1,1155,1177,1176,1154,-1,1156,1178,1177,1155,-1,1157,1179,1178,1156,-1,1158,1180,1179,1157,-1,1159,1181,1180,1158,-1,1160,1182,1181,1159,-1,1161,1183,1182,1160,-1,1162,1184,1183,1161,-1,1163,1185,1184,1162,-1,1164,1186,1185,1163,-1,1165,1187,1186,1164,-1,1166,1188,1187,1165,-1,1167,1189,1188,1166,-1,1144,1190,1189,1167,-1,1145,1169,1191,1146,-1,1168,1192,1193,1169,-1,1170,1194,1192,1168,-1,1171,1195,1194,1170,-1,1172,1196,1195,1171,-1,1173,1197,1196,1172,-1,1174,1198,1197,1173,-1,1175,1199,1198,1174,-1,1176,1200,1199,1175,-1,1177,1201,1200,1176,-1,1178,1202,1201,1177,-1,1179,1203,1202,1178,-1,1180,1204,1203,1179,-1,1181,1205,1204,1180,-1,1182,1206,1205,1181,-1,1183,1207,1206,1182,-1,1184,1208,1207,1183,-1,1185,1209,1208,1184,-1,1186,1210,1209,1185,-1,1187,1211,1210,1186,-1,1188,1212,1211,1187,-1,1189,1213,1212,1188,-1,1190,1214,1213,1189,-1,1215,1216,1214,1190,-1,1169,1193,1217,1191,-1,1192,1218,1219,1193,-1,1194,1220,1218,1192,-1,1195,1221,1220,1194,-1,1196,1222,1221,1195,-1,1197,1223,1222,1196,-1,1198,1224,1223,1197,-1,1199,1225,1224,1198,-1,1200,1226,1225,1199,-1,1201,1227,1226,1200,-1,1202,1228,1227,1201,-1,1203,1229,1228,1202,-1,1204,1230,1229,1203,-1,1205,1231,1230,1204,-1,1206,1232,1231,1205,-1,1207,1233,1232,1206,-1,1208,1234,1233,1207,-1,1209,1235,1234,1208,-1,1210,1236,1235,1209,-1,1211,1237,1236,1210,-1,1212,1238,1237,1211,-1,1213,1239,1238,1212,-1,1214,1240,1239,1213,-1,1216,1241,1240,1214,-1,1193,1219,1242,1217,-1,1241,1096,1095,1240,-1,1219,1052,1051,1242,-1,1218,1053,1052,1219,-1,1220,1055,1053,1218,-1,1221,1057,1055,1220,-1,1222,1059,1057,1221,-1,1223,1061,1059,1222,-1,1224,1063,1061,1223,-1,1225,1065,1063,1224,-1,1226,1067,1065,1225,-1,1227,1069,1067,1226,-1,1228,1071,1069,1227,-1,1229,1073,1071,1228,-1,1230,1075,1073,1229,-1,1231,1077,1075,1230,-1,1232,1079,1077,1231,-1,1233,1081,1079,1232,-1,1234,1083,1081,1233,-1,1235,1085,1083,1234,-1,1236,1087,1085,1235,-1,1237,1089,1087,1236,-1,1238,1091,1089,1237,-1,1239,1093,1091,1238,-1,1240,1095,1093,1239,-1,1143,1215,1190,1144,-1,1243,1105,1103,1244,-1,1245,1109,1107,1243,-1,1246,1115,1113,1245,-1,1247,1121,1119,1246,-1,1248,1127,1125,1247,-1,1249,1133,1131,1248,-1,1250,1251,1141,1139,-1,1252,1244,1103,1101,-1,1139,1137,1249,1250,-1,1243,1107,1105,-1,1133,1249,1135,-1,1245,1111,1109,-1,1111,1245,1113,-1,1117,1246,1119,-1,1246,1117,1115,-1,1123,1247,1125,-1,1247,1123,1121,-1,1129,1248,1131,-1,1129,1127,1248,-1,1135,1249,1137,-1,1252,1101,1097,1253,-1,1251,1254,751,1141,-1,1253,754,820,-1,1258,1259,1257,1256,-1,1259,1261,1260,1257,-1,1261,1259,1262,1263,-1,1261,1264,1265,1260,-1,1264,1266,1267,1265,-1,1268,1266,1264,1269,-1,1266,1270,1271,1267,-1,1270,1266,1272,-1,1273,1271,1270,1274,-1,1274,1253,820,1273,-1,1252,1253,1274,1275,-1,1259,1258,1276,-1,1256,1255,1277,1258,-1,1251,1277,1255,1254,-1,1277,1251,1250,1278,-1,1279,1249,1248,1280,-1,1280,1248,1247,1281,-1,1281,1247,1246,1282,-1,1283,1282,1246,1245,-1,1245,1243,1284,1283,-1,1284,1243,1244,1285,-1,1250,1249,1279,1278,-1,1286,1279,1280,1262,-1,1262,1280,1281,1263,-1,1263,1281,1282,1269,-1,1269,1282,1283,1268,-1,1268,1283,1284,1287,-1,1275,1285,1244,1252,-1,1287,1284,1285,1288,-1,1272,1275,1274,1270,-1,1266,1288,1272,-1,1288,1266,1287,-1,1287,1266,1268,-1,1263,1269,1264,1261,-1,1262,1259,1286,-1,1276,1286,1259,-1,1276,1258,1277,1278,-1,1272,1288,1285,1275,-1,1278,1279,1286,1276,-1,1253,1097,1049,754,-1,752,1289,1290,1047,-1,1054,1292,1293,1051,-1,1056,1294,1292,1054,-1,1058,1295,1294,1056,-1,1060,1296,1295,1058,-1,1062,1297,1296,1060,-1,1064,1298,1297,1062,-1,1066,1299,1298,1064,-1,1068,1300,1299,1066,-1,1070,1301,1300,1068,-1,1072,1302,1301,1070,-1,1074,1303,1302,1072,-1,1076,1304,1303,1074,-1,1078,1305,1304,1076,-1,1080,1306,1305,1078,-1,1082,1307,1306,1080,-1,1084,1308,1307,1082,-1,1086,1309,1308,1084,-1,1086,1088,1310,1309,-1,1090,1311,1310,1088,-1,1092,1312,1311,1090,-1,1094,1313,1312,1092,-1,1096,1314,1313,1094,-1,1100,1099,1315,1316,-1,1316,1315,1317,1318,-1,1318,1317,1319,1320,-1,1320,1319,1321,1322,-1,1322,1321,1323,1324,-1,1324,1323,1325,1326,-1,1326,1325,1327,1328,-1,1328,1327,1329,1330,-1,1330,1329,1331,1332,-1,1332,1331,1333,1334,-1,1334,1333,1335,1336,-1,1336,1335,1337,1338,-1,1338,1337,1339,1340,-1,1340,1339,1341,1342,-1,1342,1341,1343,1344,-1,1344,1343,1345,1346,-1,1346,1345,1347,1348,-1,1348,1347,1349,1350,-1,1350,1349,1351,1352,-1,1352,1351,1353,1354,-1,1354,1353,1355,1356,-1,1356,1355,1357,1358,-1,1358,1357,1290,1289,-1,1290,1359,1143,1047,-1,1099,1146,1360,1315,-1,1315,1360,1361,1317,-1,1317,1361,1362,1319,-1,1319,1362,1363,1321,-1,1321,1363,1364,1323,-1,1323,1364,1365,1325,-1,1325,1365,1366,1327,-1,1327,1366,1367,1329,-1,1329,1367,1368,1331,-1,1331,1368,1369,1333,-1,1333,1369,1370,1335,-1,1335,1370,1371,1337,-1,1337,1371,1372,1339,-1,1339,1372,1373,1341,-1,1341,1373,1374,1343,-1,1343,1374,1375,1345,-1,1345,1375,1376,1347,-1,1347,1376,1377,1349,-1,1349,1377,1378,1351,-1,1351,1378,1379,1353,-1,1353,1379,1380,1355,-1,1355,1380,1381,1357,-1,1357,1381,1359,1290,-1,1360,1382,1383,1361,-1,1361,1383,1384,1362,-1,1362,1384,1385,1363,-1,1363,1385,1386,1364,-1,1364,1386,1387,1365,-1,1365,1387,1388,1366,-1,1366,1388,1389,1367,-1,1367,1389,1390,1368,-1,1368,1390,1391,1369,-1,1369,1391,1392,1370,-1,1370,1392,1393,1371,-1,1371,1393,1394,1372,-1,1372,1394,1395,1373,-1,1373,1395,1396,1374,-1,1374,1396,1397,1375,-1,1375,1397,1398,1376,-1,1376,1398,1399,1377,-1,1377,1399,1400,1378,-1,1378,1400,1401,1379,-1,1379,1401,1402,1380,-1,1380,1402,1403,1381,-1,1381,1403,1404,1359,-1,1146,1191,1382,1360,-1,1382,1405,1406,1383,-1,1383,1406,1407,1384,-1,1384,1407,1408,1385,-1,1385,1408,1409,1386,-1,1386,1409,1410,1387,-1,1387,1410,1411,1388,-1,1388,1411,1412,1389,-1,1389,1412,1413,1390,-1,1390,1413,1414,1391,-1,1391,1414,1415,1392,-1,1392,1415,1416,1393,-1,1393,1416,1417,1394,-1,1394,1417,1418,1395,-1,1395,1418,1419,1396,-1,1396,1419,1420,1397,-1,1397,1420,1421,1398,-1,1398,1421,1422,1399,-1,1399,1422,1423,1400,-1,1400,1423,1424,1401,-1,1401,1424,1425,1402,-1,1402,1425,1426,1403,-1,1403,1426,1427,1404,-1,1404,1427,1216,1215,-1,1191,1217,1405,1382,-1,1405,1428,1429,1406,-1,1406,1429,1430,1407,-1,1407,1430,1431,1408,-1,1408,1431,1432,1409,-1,1409,1432,1433,1410,-1,1410,1433,1434,1411,-1,1411,1434,1435,1412,-1,1412,1435,1436,1413,-1,1413,1436,1437,1414,-1,1414,1437,1438,1415,-1,1415,1438,1439,1416,-1,1416,1439,1440,1417,-1,1417,1440,1441,1418,-1,1418,1441,1442,1419,-1,1419,1442,1443,1420,-1,1420,1443,1444,1421,-1,1421,1444,1445,1422,-1,1422,1445,1446,1423,-1,1423,1446,1447,1424,-1,1424,1447,1448,1425,-1,1425,1448,1449,1426,-1,1426,1449,1450,1427,-1,1427,1450,1241,1216,-1,1217,1242,1428,1405,-1,1450,1314,1096,1241,-1,1242,1051,1293,1428,-1,1428,1293,1292,1429,-1,1429,1292,1294,1430,-1,1430,1294,1295,1431,-1,1431,1295,1296,1432,-1,1432,1296,1297,1433,-1,1433,1297,1298,1434,-1,1434,1298,1299,1435,-1,1435,1299,1300,1436,-1,1436,1300,1301,1437,-1,1437,1301,1302,1438,-1,1438,1302,1303,1439,-1,1439,1303,1304,1440,-1,1440,1304,1305,1441,-1,1441,1305,1306,1442,-1,1442,1306,1307,1443,-1,1443,1307,1308,1444,-1,1444,1308,1309,1445,-1,1445,1309,1310,1446,-1,1446,1310,1311,1447,-1,1447,1311,1312,1448,-1,1448,1312,1313,1449,-1,1449,1313,1314,1450,-1,1359,1404,1215,1143,-1,1451,1320,1322,1452,-1,1452,1324,1326,1453,-1,1453,1330,1332,1454,-1,1454,1336,1338,1455,-1,1455,1342,1344,1456,-1,1456,1348,1350,1457,-1,1356,1358,1458,1459,-1,1318,1320,1451,1460,-1,1459,1457,1354,1356,-1,1322,1324,1452,-1,1352,1457,1350,-1,1326,1328,1453,-1,1330,1453,1328,-1,1336,1454,1334,-1,1332,1334,1454,-1,1342,1455,1340,-1,1338,1340,1455,-1,1348,1456,1346,-1,1456,1344,1346,-1,1354,1457,1352,-1,1461,1316,1318,1460,-1,1358,1289,1462,1458,-1,967,910,1461,-1,1465,1464,1466,1467,-1,1464,1005,1468,1466,-1,1469,1470,1466,1468,-1,1005,1007,1471,1468,-1,1007,1008,1472,1471,-1,1473,1471,1472,1474,-1,1008,1009,1475,1472,-1,1476,1472,1475,-1,1477,1475,1009,1011,-1,1011,967,1461,1477,-1,1478,1477,1461,1460,-1,1479,1467,1466,-1,1467,1480,1463,1465,-1,1462,1463,1480,1458,-1,1481,1459,1458,1480,-1,1482,1456,1457,1483,-1,1484,1455,1456,1482,-1,1485,1454,1455,1484,-1,1453,1454,1485,1486,-1,1486,1487,1452,1453,-1,1488,1451,1452,1487,-1,1481,1483,1457,1459,-1,1470,1482,1483,1489,-1,1469,1484,1482,1470,-1,1473,1485,1484,1469,-1,1474,1486,1485,1473,-1,1490,1487,1486,1474,-1,1460,1451,1488,1478,-1,1491,1488,1487,1490,-1,1475,1477,1478,1476,-1,1476,1491,1472,-1,1490,1472,1491,-1,1474,1472,1490,-1,1468,1471,1473,1469,-1,1489,1466,1470,-1,1466,1489,1479,-1,1481,1480,1467,1479,-1,1478,1488,1491,1476,-1,1479,1489,1483,1481,-1,1050,1049,1097,1100,1316,1291,-1,910,1291,1316,1461,-1,1492,1493,1494,-1,1495,1496,1497,-1,1498,1499,1496,1495,-1,1494,1493,1499,1498,-1,1500,1501,1492,1494,-1,1502,1501,1500,-1,1503,1504,1505,1506,-1,1507,1508,1506,1505,-1,1508,1507,1509,1510,-1,1510,1509,1511,1512,-1,1513,1514,1512,1511,-1,1515,1516,1514,1513,-1,1517,1518,1516,1515,-1,1518,1517,1519,-1,1504,1503,1520,-1,49,50,1522,1523,-1,1523,1522,1524,-1,1525,1526,1527,1528,-1,1528,1529,1530,1525,-1,1531,1527,1526,1532,-1,1533,1534,1535,1536,-1,1532,1533,1536,1531,-1,1537,1538,1539,1540,-1,1534,1541,1542,1535,-1,1538,1543,1544,1539,-1,1540,1530,1529,1537,-1,1525,1545,1526,-1,1546,1547,1548,-1,1548,1547,1549,1550,-1,1550,1549,1551,1552,-1,1552,1551,1553,1554,-1,1554,1553,1555,1556,-1,49,1523,1557,1558,-1,1558,1557,1559,1560,-1,1560,1559,1561,51,-1,51,1561,1562,1563,-1,1564,1499,1565,-1,1494,1498,1566,1520,-1,1520,1566,1567,1568,-1,1569,1570,1571,1572,-1,1512,1514,1573,1574,-1,1523,1524,1575,1557,-1,1557,1575,1576,1559,-1,1559,1576,1577,1561,-1,1561,1577,1578,1562,-1,1562,1578,1496,1499,-1,1495,1579,1566,1498,-1,1566,1579,1580,1567,-1,1567,1580,1581,1570,-1,1570,1581,1582,1571,-1,1571,1582,1583,1584,-1,1585,1586,1587,1573,-1,1524,1590,1591,1575,-1,1575,1591,1592,1576,-1,1576,1592,1593,1577,-1,1577,1593,1594,1578,-1,1578,1594,1497,1496,-1,1497,1595,1579,1495,-1,1579,1595,1596,1580,-1,1580,1596,1597,1581,-1,1581,1597,1598,1582,-1,1582,1598,1599,1583,-1,1600,1586,1585,-1,1521,1600,1601,1588,-1,1588,1601,1602,1589,-1,1590,1603,1604,1591,-1,1591,1604,1605,1592,-1,1592,1605,1606,1593,-1,1593,1606,1607,1594,-1,1594,1607,1497,-1,1497,1608,1609,1595,-1,1595,1609,1610,1596,-1,1596,1610,1611,1597,-1,1597,1611,1612,1598,-1,1598,1612,1519,1599,-1,1518,1519,1613,1600,-1,1600,1613,1614,1601,-1,1601,1614,1615,1602,-1,1616,1617,1618,1619,-1,1619,1618,1620,1621,-1,1621,1620,1622,1623,-1,1623,1622,1624,1625,-1,1625,1624,1626,1608,-1,1608,1626,1627,1609,-1,1609,1627,1628,1610,-1,1610,1628,1629,1611,-1,1611,1629,1630,1612,-1,1612,1630,1631,1519,-1,1519,1631,1632,1613,-1,1613,1632,1633,1614,-1,1614,1633,1634,1615,-1,1617,1635,1636,1618,-1,1618,1636,1637,1620,-1,1620,1637,1638,1622,-1,1622,1638,1639,1624,-1,1624,1639,1640,1626,-1,1626,1640,1641,1627,-1,1627,1641,1642,1628,-1,1628,1642,1643,1629,-1,1629,1643,1644,1630,-1,1630,1644,1645,1631,-1,1631,1645,1646,1632,-1,1632,1646,1647,1633,-1,1633,1647,1648,1634,-1,1649,1650,1651,1652,-1,1652,1651,1653,1654,-1,1654,1653,1655,1656,-1,1656,1655,1657,1658,-1,1658,1657,1659,-1,1660,1661,1662,1641,-1,1641,1662,1663,1664,1642,-1,1642,1664,1665,1643,-1,1643,1665,1666,1644,-1,1644,1666,1667,1645,-1,1645,1667,1668,1646,-1,1646,1668,1669,1647,-1,1647,1669,1670,1648,-1,1671,1672,1673,1674,-1,1674,1673,1675,1676,-1,1676,1675,1677,1678,-1,1678,1677,1679,1680,-1,1680,1679,1681,1682,-1,1660,1683,1661,-1,1663,1684,1685,1664,-1,1664,1685,1686,1665,-1,1665,1686,1687,1666,-1,1666,1687,1688,1667,-1,1667,1688,1689,1668,-1,1668,1689,1690,1669,-1,1669,1690,1691,1670,-1,1607,1625,1608,1497,-1,1606,1623,1625,1607,-1,1605,1621,1623,1606,-1,1604,1619,1621,1605,-1,1603,1616,1619,1604,-1,1672,1692,1693,1673,-1,1673,1693,1694,1675,-1,1675,1694,1695,1677,-1,1677,1695,1696,1679,-1,1679,1696,1697,1681,-1,1681,1697,1698,1683,-1,1684,1699,1700,1685,-1,1685,1700,1701,1686,-1,1686,1701,1702,1687,-1,1687,1702,1703,1688,-1,1688,1703,1704,1689,-1,1689,1704,1705,1690,-1,1690,1705,1706,1691,-1,1692,1707,1708,1693,-1,1693,1708,1709,1694,-1,1694,1709,1710,1695,-1,1695,1710,1711,1696,-1,1696,1711,1712,1697,-1,1697,1712,1713,1698,-1,1699,1714,1715,1700,-1,1700,1715,1716,1701,-1,1701,1716,1717,1702,-1,1702,1717,1718,1703,-1,1703,1718,1719,1704,-1,1704,1719,1720,1705,-1,1705,1720,1721,1706,-1,1707,1722,1723,1708,-1,1708,1723,1724,1709,-1,1709,1724,1725,1710,-1,1710,1725,1726,1711,-1,1711,1726,1727,1712,-1,1712,1727,1728,1713,-1,1714,1729,1730,1715,-1,1715,1730,1731,1716,-1,1716,1731,1732,1717,-1,1717,1732,1733,1718,-1,1718,1733,1734,1719,-1,1719,1734,1735,1720,-1,1723,1722,1736,1737,-1,1723,1737,1738,1724,-1,1724,1738,1739,1725,-1,1725,1739,1740,1726,-1,1726,1740,1741,1727,-1,1727,1741,1742,1728,-1,1729,1743,1744,1730,-1,1730,1744,1745,1731,-1,1731,1745,1746,1732,-1,1732,1746,1747,1733,-1,1733,1747,1748,1734,-1,1734,1748,1749,1735,-1,1750,1735,1749,1751,-1,1752,1753,1754,1755,1756,1757,1758,1759,1760,-1,1721,1720,1735,1750,-1,1543,1761,1762,1544,-1,1763,1574,1573,1587,-1,1585,1516,1518,1600,-1,1573,1514,1516,1585,-1,1600,1521,1766,-1,1508,1767,1768,1506,-1,1769,1770,1771,1772,-1,1769,1772,1773,1774,-1,1775,1776,1774,1773,-1,1777,1778,1776,1775,-1,1779,1780,1778,1777,-1,1781,1782,1780,1779,-1,1783,1784,1782,1781,-1,1785,1786,1784,1783,-1,1787,1788,1786,1785,-1,1789,1790,1788,1787,-1,1791,1792,1790,1789,-1,1793,1794,1792,1791,-1,1795,1796,1794,1793,-1,1795,1586,1766,1796,-1,1600,1766,1586,-1,1565,1771,1770,-1,1493,1565,1499,-1,1770,1797,1798,-1,1798,1797,1799,1800,-1,1800,1799,1801,54,-1,54,1801,1802,55,-1,55,1802,1803,56,-1,56,1803,1804,57,-1,57,1804,1805,1806,-1,1806,1805,1807,1808,-1,1808,1807,1809,58,-1,58,1809,1810,59,-1,59,1810,1811,60,-1,60,1811,1812,1765,-1,1765,1812,1813,1764,-1,1764,1813,1766,-1,1586,1795,1587,-1,1587,1795,1793,1763,-1,1763,1793,1791,1814,-1,1814,1791,1789,1815,-1,1815,1789,1787,1816,-1,1816,1787,1785,1817,-1,1817,1785,1783,1818,-1,1818,1783,1781,1819,-1,1819,1781,1779,1820,-1,1820,1779,1777,1821,-1,1821,1777,1775,1822,-1,1822,1775,1773,1823,-1,1823,1773,1772,1824,-1,1824,1772,1771,-1,1799,1774,1776,1801,-1,1801,1776,1778,1802,-1,1802,1778,1780,1803,-1,1803,1780,1782,1804,-1,1804,1782,1784,1805,-1,1805,1784,1786,1807,-1,1807,1786,1788,1809,-1,1809,1788,1790,1810,-1,1810,1790,1792,1811,-1,1811,1792,1794,1812,-1,1812,1794,1796,1813,-1,1797,1769,1774,1799,-1,1766,1813,1796,-1,1770,1769,1797,-1,1825,1571,1584,-1,1826,1569,1572,1827,-1,1825,1828,1571,-1,1828,1572,1571,-1,1584,1829,1830,1825,-1,1583,1831,1829,1584,-1,1599,1832,1831,1583,-1,1519,1832,1599,-1,1504,1833,1826,1505,-1,1505,1826,1827,1507,-1,1507,1827,1834,1509,-1,1509,1834,1830,1511,-1,1511,1830,1829,1513,-1,1831,1515,1513,1829,-1,1832,1517,1515,1831,-1,1519,1517,1832,-1,1520,1833,1504,-1,1501,1835,1836,-1,1822,1823,1835,1837,-1,1502,1837,1835,1501,-1,1838,1839,1502,1768,-1,1815,1816,1840,1841,-1,1568,1567,1570,1569,-1,1500,1520,1503,1502,-1,1494,1520,1500,-1,1798,109,1770,-1,1818,1839,1838,1817,-1,1840,1838,1768,1767,-1,1817,1838,1840,1816,-1,1842,1814,1815,1841,-1,1840,1767,1841,-1,1841,1767,1842,-1,1821,1843,1820,-1,1502,1843,1837,-1,1844,1843,1502,-1,1819,1820,1843,1844,-1,1836,1492,1501,-1,1822,1837,1843,1821,-1,1842,1574,1763,1814,-1,1510,1512,1574,1842,-1,1770,109,1565,-1,1824,1836,1835,1823,-1,1771,1492,1836,1824,-1,1844,1839,1818,1819,-1,1502,1839,1844,-1,1506,1768,1502,1503,-1,1492,1771,1565,1493,-1,1828,1825,1830,1834,-1,1833,1568,1569,1826,-1,1520,1568,1833,-1,1834,1827,1572,1828,-1,1842,1767,1508,1510,-1,1845,1846,1847,1848,1849,1850,1851,1852,-1,1545,1525,1663,1662,-1,1526,1545,1662,1661,-1,1853,1743,1762,1761,-1,1854,1855,1742,1856,-1,1743,1729,1544,1762,-1,1855,1541,1728,1742,-1,1729,1714,1539,1544,-1,1541,1534,1713,1728,-1,1714,1699,1540,1539,-1,1534,1533,1698,1713,-1,1699,1684,1530,1540,-1,1533,1532,1683,1698,-1,1684,1663,1525,1530,-1,1532,1526,1661,1683,-1,1546,1682,1660,-1,1546,1660,1659,-1,1671,1674,1554,1556,-1,1555,1553,1651,1650,-1,1674,1676,1552,1554,-1,1553,1551,1653,1651,-1,1676,1678,1550,1552,-1,1551,1549,1655,1653,-1,1678,1680,1548,1550,-1,1549,1547,1657,1655,-1,1680,1682,1546,1548,-1,1547,1546,1659,1657,-1,1660,1682,1681,1683,-1,1641,1640,1659,1660,-1,1652,1636,1635,1649,-1,1654,1637,1636,1652,-1,1656,1638,1637,1654,-1,1658,1639,1638,1656,-1,1659,1640,1639,1658,-1,1541,1855,1854,1542,-1,1741,1846,1845,1742,-1,1742,1845,1852,1856,-1,1736,1851,1850,1737,-1,1737,1850,1849,1738,-1,1738,1849,1848,1739,-1,1739,1848,1847,1740,-1,1740,1847,1846,1741,-1,1749,1753,1752,1751,-1,1853,1760,1759,1743,-1,1743,1759,1758,1744,-1,1744,1758,1757,1745,-1,1745,1757,1756,1746,-1,1746,1756,1755,1747,-1,1747,1755,1754,1748,-1,1748,1754,1753,1749,-1,1564,1563,1562,1499,-1,1857,1858,1859,1860,-1,1858,1857,1861,1862,-1,1863,1864,1862,1861,-1,1865,1866,1864,1863,-1,1866,1865,1867,1868,-1,1868,1867,1869,1870,-1,1870,1869,1871,1872,-1,1873,1872,1871,-1,1874,1860,1859,-1,1876,1522,50,1877,-1,1524,1522,1876,-1,1528,1527,1878,1879,-1,1879,1880,1529,1528,-1,1881,1878,1527,1531,-1,1536,1535,1882,1883,-1,1531,1536,1883,1881,-1,1884,1885,1538,1537,-1,1535,1542,1886,1882,-1,1885,1887,1543,1538,-1,1537,1529,1880,1884,-1,1878,1888,1879,-1,1889,1890,1891,-1,1892,1893,1890,1889,-1,1894,1895,1893,1892,-1,1896,1897,1895,1894,-1,1556,1555,1897,1896,-1,1898,1899,1876,1877,-1,1900,1901,1899,1898,-1,1902,1903,1901,1900,-1,184,1904,1903,1902,-1,1905,1906,1907,-1,1874,1908,1909,1910,-1,1911,1912,1908,1874,-1,1913,1914,1915,1916,-1,1917,1918,1867,1865,-1,1899,1919,1524,1876,-1,1901,1920,1919,1899,-1,1903,1921,1920,1901,-1,1904,1922,1921,1903,-1,1906,1923,1922,1904,-1,1909,1908,1924,1925,-1,1912,1926,1924,1908,-1,1915,1927,1926,1912,-1,1914,1928,1927,1915,-1,1929,1930,1928,1914,-1,1918,1931,1932,1933,-1,1919,1935,1590,1524,-1,1920,1936,1935,1919,-1,1921,1937,1936,1920,-1,1922,1938,1937,1921,-1,1923,1939,1938,1922,-1,1925,1924,1940,1939,-1,1926,1941,1940,1924,-1,1927,1942,1941,1926,-1,1928,1943,1942,1927,-1,1930,1944,1943,1928,-1,1933,1932,1945,-1,1934,1946,1945,1875,-1,1589,1602,1946,1934,-1,1935,1947,1603,1590,-1,1936,1948,1947,1935,-1,1937,1949,1948,1936,-1,1938,1950,1949,1937,-1,1939,1950,1938,-1,1940,1951,1952,1939,-1,1941,1953,1951,1940,-1,1942,1954,1953,1941,-1,1943,1955,1954,1942,-1,1944,1873,1955,1943,-1,1945,1956,1873,1871,-1,1946,1957,1956,1945,-1,1602,1615,1957,1946,-1,1958,1959,1617,1616,-1,1960,1961,1959,1958,-1,1962,1963,1961,1960,-1,1964,1965,1963,1962,-1,1952,1966,1965,1964,-1,1951,1967,1966,1952,-1,1953,1968,1967,1951,-1,1954,1969,1968,1953,-1,1955,1970,1969,1954,-1,1873,1971,1970,1955,-1,1956,1972,1971,1873,-1,1957,1973,1972,1956,-1,1615,1634,1973,1957,-1,1959,1974,1635,1617,-1,1961,1975,1974,1959,-1,1963,1976,1975,1961,-1,1965,1977,1976,1963,-1,1966,1978,1977,1965,-1,1967,1979,1978,1966,-1,1968,1980,1979,1967,-1,1969,1981,1980,1968,-1,1970,1982,1981,1969,-1,1971,1983,1982,1970,-1,1972,1984,1983,1971,-1,1973,1985,1984,1972,-1,1634,1648,1985,1973,-1,1986,1987,1650,1649,-1,1988,1989,1987,1986,-1,1990,1991,1989,1988,-1,1992,1993,1991,1990,-1,1994,1993,1992,-1,1979,1995,1996,1997,-1,1980,1998,1999,1995,1979,-1,1981,2000,1998,1980,-1,1982,2001,2000,1981,-1,1983,2002,2001,1982,-1,1984,2003,2002,1983,-1,1985,2004,2003,1984,-1,1648,1670,2004,1985,-1,2005,2006,1672,1671,-1,2007,2008,2006,2005,-1,2009,2010,2008,2007,-1,2011,2012,2010,2009,-1,2013,2014,2012,2011,-1,1996,2015,1997,-1,1998,2016,2017,1999,-1,2000,2018,2016,1998,-1,2001,2019,2018,2000,-1,2002,2020,2019,2001,-1,2003,2021,2020,2002,-1,2004,2022,2021,2003,-1,1670,1691,2022,2004,-1,1939,1952,1964,1950,-1,1950,1964,1962,1949,-1,1949,1962,1960,1948,-1,1948,1960,1958,1947,-1,1947,1958,1616,1603,-1,2006,2023,1692,1672,-1,2008,2024,2023,2006,-1,2010,2025,2024,2008,-1,2012,2026,2025,2010,-1,2014,2027,2026,2012,-1,2015,2028,2027,2014,-1,2016,2029,2030,2017,-1,2018,2031,2029,2016,-1,2019,2032,2031,2018,-1,2020,2033,2032,2019,-1,2021,2034,2033,2020,-1,2022,2035,2034,2021,-1,1691,1706,2035,2022,-1,2023,2036,1707,1692,-1,2024,2037,2036,2023,-1,2025,2038,2037,2024,-1,2026,2039,2038,2025,-1,2027,2040,2039,2026,-1,2028,2041,2040,2027,-1,2029,2042,2043,2030,-1,2031,2044,2042,2029,-1,2032,2045,2044,2031,-1,2033,2046,2045,2032,-1,2034,2047,2046,2033,-1,2035,2048,2047,2034,-1,1706,1721,2048,2035,-1,2036,2049,1722,1707,-1,2037,2050,2049,2036,-1,2038,2051,2050,2037,-1,2039,2052,2051,2038,-1,2040,2053,2052,2039,-1,2041,2054,2053,2040,-1,2042,2055,2056,2043,-1,2044,2057,2055,2042,-1,2045,2058,2057,2044,-1,2046,2059,2058,2045,-1,2047,2060,2059,2046,-1,2048,2061,2060,2047,-1,2062,1736,1722,2049,-1,2050,2063,2062,2049,-1,2051,2064,2063,2050,-1,2052,2065,2064,2051,-1,2053,2066,2065,2052,-1,2054,2067,2066,2053,-1,2055,2068,2069,2056,-1,2057,2070,2068,2055,-1,2058,2071,2070,2057,-1,2059,2072,2071,2058,-1,2060,2073,2072,2059,-1,2061,2074,2073,2060,-1,1751,2074,2061,1750,-1,1760,2075,2076,2077,2078,2079,2080,2081,1752,-1,1750,2061,2048,1721,-1,1887,2082,1761,1543,-1,1931,1918,1917,2083,-1,1945,1871,1869,1933,-1,1933,1869,1867,1918,-1,2086,1875,1945,-1,1857,2087,2088,1861,-1,2089,2090,2091,2092,-1,2093,2094,2089,2092,-1,2094,2093,2095,2096,-1,2096,2095,2097,2098,-1,2098,2097,2099,2100,-1,2100,2099,2101,2102,-1,2102,2101,2103,2104,-1,2104,2103,2105,2106,-1,2106,2105,2107,2108,-1,2108,2107,2109,2110,-1,2110,2109,2111,2112,-1,2112,2111,2113,2114,-1,2114,2113,2115,2116,-1,2115,2086,1932,2116,-1,1932,2086,1945,-1,2091,2090,1905,-1,1906,1905,2117,-1,2118,2119,2091,-1,2120,2121,2119,2118,-1,2122,2123,2121,2120,-1,2124,2125,2123,2122,-1,2126,2127,2125,2124,-1,2128,2129,2127,2126,-1,2130,2131,2129,2128,-1,2132,2133,2131,2130,-1,2134,2135,2133,2132,-1,2136,2137,2135,2134,-1,2138,2139,2137,2136,-1,2084,2140,2139,2138,-1,2085,2141,2140,2084,-1,2086,2141,2085,-1,1931,2116,1932,-1,2083,2114,2116,1931,-1,2142,2112,2114,2083,-1,2143,2110,2112,2142,-1,2144,2108,2110,2143,-1,2145,2106,2108,2144,-1,2146,2104,2106,2145,-1,2147,2102,2104,2146,-1,2148,2100,2102,2147,-1,2149,2098,2100,2148,-1,2150,2096,2098,2149,-1,2151,2094,2096,2150,-1,2152,2089,2094,2151,-1,2090,2089,2152,-1,2123,2095,2093,2121,-1,2125,2097,2095,2123,-1,2127,2099,2097,2125,-1,2129,2101,2099,2127,-1,2131,2103,2101,2129,-1,2133,2105,2103,2131,-1,2135,2107,2105,2133,-1,2137,2109,2107,2135,-1,2139,2111,2109,2137,-1,2140,2113,2111,2139,-1,2141,2115,2113,2140,-1,2121,2093,2092,2119,-1,2115,2141,2086,-1,2119,2092,2091,-1,1929,1914,2153,-1,2154,1913,1916,2155,-1,1914,2156,2153,-1,1914,1913,2156,-1,2153,2157,2158,1929,-1,1929,2158,2159,1930,-1,1930,2159,2160,1944,-1,1944,2160,1873,-1,1858,2155,2161,1859,-1,1862,2154,2155,1858,-1,1864,2162,2154,1862,-1,1866,2157,2162,1864,-1,1868,2158,2157,1866,-1,2158,1868,1870,2159,-1,2159,1870,1872,2160,-1,2160,1872,1873,-1,1859,2161,1874,-1,2163,2164,2165,-1,2166,2164,2151,2150,-1,2165,2164,2166,2167,-1,2087,2167,2168,2169,-1,2170,2171,2144,2143,-1,1916,1915,1912,1911,-1,2167,1860,1874,2172,-1,2172,1874,1910,-1,2091,2173,2118,-1,2145,2169,2168,2146,-1,2088,2087,2169,2171,-1,2144,2171,2169,2145,-1,2170,2143,2142,2174,-1,2170,2088,2171,-1,2174,2088,2170,-1,2148,2175,2149,-1,2166,2175,2167,-1,2167,2175,2176,-1,2176,2175,2148,2147,-1,2165,2177,2163,-1,2149,2175,2166,2150,-1,2142,2083,1917,2174,-1,2174,1917,1865,1863,-1,1905,2173,2091,-1,2151,2164,2163,2152,-1,2152,2163,2177,2090,-1,2147,2146,2168,2176,-1,2176,2168,2167,-1,1860,2167,2087,1857,-1,2117,1905,2090,2177,-1,2162,2157,2153,2156,-1,2155,1916,1911,2161,-1,2161,1911,1874,-1,2156,1913,2154,2162,-1,1863,1861,2088,2174,-1,1852,1851,2178,2179,2180,2181,2182,2183,-1,1995,1999,1879,1888,-1,1996,1995,1888,1878,-1,1761,2082,2069,1853,-1,1856,2067,2184,1854,-1,2082,1887,2056,2069,-1,2067,2054,1886,2184,-1,1887,1885,2043,2056,-1,2054,2041,1882,1886,-1,1885,1884,2030,2043,-1,2041,2028,1883,1882,-1,1884,1880,2017,2030,-1,2028,2015,1881,1883,-1,1880,1879,1999,2017,-1,2015,1996,1878,1881,-1,1997,2013,1891,-1,1994,1997,1891,-1,1556,1896,2005,1671,-1,1650,1987,1897,1555,-1,1896,1894,2007,2005,-1,1987,1989,1895,1897,-1,1894,1892,2009,2007,-1,1989,1991,1893,1895,-1,1892,1889,2011,2009,-1,1991,1993,1890,1893,-1,1889,1891,2013,2011,-1,1993,1994,1891,1890,-1,2015,2014,2013,1997,-1,1997,1994,1978,1979,-1,1649,1635,1974,1986,-1,1986,1974,1975,1988,-1,1988,1975,1976,1990,-1,1990,1976,1977,1992,-1,1992,1977,1978,1994,-1,1542,1854,2184,1886,-1,2067,2183,2182,2066,-1,1856,1852,2183,2067,-1,2062,2178,1851,1736,-1,2063,2179,2178,2062,-1,2064,2180,2179,2063,-1,2065,2181,2180,2064,-1,2066,2182,2181,2065,-1,1751,1752,2081,2074,-1,2069,2075,1760,1853,-1,2068,2076,2075,2069,-1,2070,2077,2076,2068,-1,2071,2078,2077,2070,-1,2072,2079,2078,2071,-1,2073,2080,2079,2072,-1,2074,2081,2080,2073,-1,1906,1904,184,1907,-1,2172,2165,2167,-1,1910,2177,2165,2172,-1,1909,1906,2117,1910,-1,1925,1923,1906,1909,-1,1939,1923,1925,-1,1910,2117,2177,-1,2185,2186,2187,2188,-1,2186,2189,2190,2187,-1,2189,2191,2192,2190,-1,2191,2193,2194,2192,-1,2193,2195,2196,2194,-1,2195,2197,2198,2196,-1,2197,2199,2200,2198,-1,2199,2201,2202,2200,-1,2201,2203,2204,2202,-1,2203,2205,2206,2204,-1,2205,2207,2208,2206,-1,2207,2209,2210,2208,-1,2209,2211,2212,2210,-1,2211,2213,2214,2212,-1,2213,2215,2216,2214,-1,2215,2217,2218,2216,-1,2217,2219,2220,2218,-1,2219,2221,2222,2220,-1,2221,2223,2224,2222,-1,2223,2225,2226,2224,-1,2225,2227,2228,2226,-1,2227,2229,2230,2228,-1,2229,2231,2232,2230,-1,2231,2233,2234,2232,-1,2233,2235,2236,2234,-1,2235,2237,2238,2236,-1,2237,2239,2240,2238,-1,2239,2241,2242,2240,-1,2241,2243,2244,2242,-1,2243,2245,2246,2244,-1,2245,2247,2248,2246,-1,2247,2249,2250,2248,-1,2249,2251,2252,2250,-1,2251,2253,2254,2252,-1,2253,2255,2256,2254,-1,2255,2185,2188,2256,-1,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2402,2401,-1,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,-1,2188,2292,2291,2256,-1,2187,2257,2292,2188,-1,2190,2258,2257,2187,-1,2192,2259,2258,2190,-1,2194,2260,2259,2192,-1,2196,2261,2260,2194,-1,2198,2262,2261,2196,-1,2200,2263,2262,2198,-1,2202,2264,2263,2200,-1,2204,2265,2264,2202,-1,2206,2266,2265,2204,-1,2208,2267,2266,2206,-1,2210,2268,2267,2208,-1,2212,2269,2268,2210,-1,2214,2270,2269,2212,-1,2216,2271,2270,2214,-1,2218,2272,2271,2216,-1,2220,2273,2272,2218,-1,2222,2274,2273,2220,-1,2224,2275,2274,2222,-1,2226,2276,2275,2224,-1,2228,2277,2276,2226,-1,2230,2278,2277,2228,-1,2232,2279,2278,2230,-1,2234,2280,2279,2232,-1,2236,2281,2280,2234,-1,2238,2282,2281,2236,-1,2240,2283,2282,2238,-1,2242,2284,2283,2240,-1,2244,2285,2284,2242,-1,2246,2286,2285,2244,-1,2248,2287,2286,2246,-1,2250,2288,2287,2248,-1,2252,2289,2288,2250,-1,2254,2290,2289,2252,-1,2256,2291,2290,2254,-1,2185,2293,2294,2186,-1,2255,2295,2293,2185,-1,2253,2296,2295,2255,-1,2251,2297,2296,2253,-1,2249,2298,2297,2251,-1,2247,2299,2298,2249,-1,2245,2300,2299,2247,-1,2243,2301,2300,2245,-1,2241,2302,2301,2243,-1,2239,2303,2302,2241,-1,2237,2304,2303,2239,-1,2235,2305,2304,2237,-1,2233,2306,2305,2235,-1,2231,2307,2306,2233,-1,2229,2308,2307,2231,-1,2227,2309,2308,2229,-1,2225,2310,2309,2227,-1,2223,2311,2310,2225,-1,2221,2312,2311,2223,-1,2219,2313,2312,2221,-1,2217,2314,2313,2219,-1,2215,2315,2314,2217,-1,2213,2316,2315,2215,-1,2211,2317,2316,2213,-1,2209,2318,2317,2211,-1,2207,2319,2318,2209,-1,2205,2320,2319,2207,-1,2203,2321,2320,2205,-1,2201,2322,2321,2203,-1,2199,2323,2322,2201,-1,2197,2324,2323,2199,-1,2195,2325,2324,2197,-1,2193,2326,2325,2195,-1,2191,2327,2326,2193,-1,2189,2328,2327,2191,-1,2186,2294,2328,2189,-1,2293,2329,2330,2294,-1,2295,2331,2329,2293,-1,2296,2332,2331,2295,-1,2297,2333,2332,2296,-1,2298,2334,2333,2297,-1,2299,2335,2334,2298,-1,2300,2336,2335,2299,-1,2301,2337,2336,2300,-1,2302,2338,2337,2301,-1,2303,2339,2338,2302,-1,2304,2340,2339,2303,-1,2305,2341,2340,2304,-1,2306,2342,2341,2305,-1,2307,2343,2342,2306,-1,2308,2344,2343,2307,-1,2309,2345,2344,2308,-1,2310,2346,2345,2309,-1,2311,2347,2346,2310,-1,2312,2348,2347,2311,-1,2313,2349,2348,2312,-1,2314,2350,2349,2313,-1,2315,2351,2350,2314,-1,2316,2352,2351,2315,-1,2317,2353,2352,2316,-1,2318,2354,2353,2317,-1,2319,2355,2354,2318,-1,2320,2356,2355,2319,-1,2321,2357,2356,2320,-1,2322,2358,2357,2321,-1,2323,2359,2358,2322,-1,2324,2360,2359,2323,-1,2325,2361,2360,2324,-1,2326,2362,2361,2325,-1,2327,2363,2362,2326,-1,2328,2364,2363,2327,-1,2294,2330,2364,2328,-1,2329,2365,2366,2330,-1,2331,2367,2365,2329,-1,2332,2368,2367,2331,-1,2333,2369,2368,2332,-1,2334,2370,2369,2333,-1,2335,2371,2370,2334,-1,2336,2372,2371,2335,-1,2337,2373,2372,2336,-1,2338,2374,2373,2337,-1,2339,2375,2374,2338,-1,2340,2376,2375,2339,-1,2341,2377,2376,2340,-1,2342,2378,2377,2341,-1,2343,2379,2378,2342,-1,2344,2380,2379,2343,-1,2345,2381,2380,2344,-1,2346,2382,2381,2345,-1,2347,2383,2382,2346,-1,2348,2384,2383,2347,-1,2349,2385,2384,2348,-1,2350,2386,2385,2349,-1,2351,2387,2386,2350,-1,2352,2388,2387,2351,-1,2353,2389,2388,2352,-1,2354,2390,2389,2353,-1,2355,2391,2390,2354,-1,2356,2392,2391,2355,-1,2357,2393,2392,2356,-1,2358,2394,2393,2357,-1,2359,2395,2394,2358,-1,2360,2396,2395,2359,-1,2361,2397,2396,2360,-1,2362,2398,2397,2361,-1,2363,2399,2398,2362,-1,2364,2400,2399,2363,-1,2330,2366,2400,2364,-1,2365,2401,2402,2366,-1,2367,2403,2401,2365,-1,2368,2404,2403,2367,-1,2369,2405,2404,2368,-1,2370,2406,2405,2369,-1,2371,2407,2406,2370,-1,2372,2408,2407,2371,-1,2373,2409,2408,2372,-1,2374,2410,2409,2373,-1,2375,2411,2410,2374,-1,2376,2412,2411,2375,-1,2377,2413,2412,2376,-1,2378,2414,2413,2377,-1,2379,2415,2414,2378,-1,2380,2416,2415,2379,-1,2381,2417,2416,2380,-1,2382,2418,2417,2381,-1,2383,2419,2418,2382,-1,2384,2420,2419,2383,-1,2385,2421,2420,2384,-1,2386,2422,2421,2385,-1,2387,2423,2422,2386,-1,2388,2424,2423,2387,-1,2389,2425,2424,2388,-1,2390,2426,2425,2389,-1,2391,2427,2426,2390,-1,2392,2428,2427,2391,-1,2393,2429,2428,2392,-1,2394,2430,2429,2393,-1,2395,2431,2430,2394,-1,2396,2432,2431,2395,-1,2397,2433,2432,2396,-1,2398,2434,2433,2397,-1,2399,2435,2434,2398,-1,2400,2436,2435,2399,-1,2366,2402,2436,2400,-1,2437,2438,2439,2440,-1,2438,2441,2442,2439,-1,2441,2443,2444,2442,-1,2443,2445,2446,2444,-1,2445,2447,2448,2446,-1,2447,2449,2450,2448,-1,2449,2451,2452,2450,-1,2451,2453,2454,2452,-1,2453,2455,2456,2454,-1,2455,2457,2458,2456,-1,2457,2459,2460,2458,-1,2459,2461,2462,2460,-1,2461,2463,2464,2462,-1,2463,2465,2466,2464,-1,2465,2467,2468,2466,-1,2467,2469,2470,2468,-1,2469,2471,2472,2470,-1,2471,2473,2474,2472,-1,2473,2475,2476,2474,-1,2475,2477,2478,2476,-1,2477,2479,2480,2478,-1,2479,2481,2482,2480,-1,2481,2483,2484,2482,-1,2483,2485,2486,2484,-1,2485,2487,2488,2486,-1,2487,2489,2490,2488,-1,2489,2491,2492,2490,-1,2491,2493,2494,2492,-1,2493,2495,2496,2494,-1,2495,2497,2498,2496,-1,2497,2499,2500,2498,-1,2499,2501,2502,2500,-1,2501,2503,2504,2502,-1,2503,2505,2506,2504,-1,2505,2507,2508,2506,-1,2507,2437,2440,2508,-1,2654,2653,2688,2687,2686,2685,2684,2683,2682,2681,2680,2679,2678,2677,2676,2675,2674,2673,2672,2671,2670,2669,2668,2667,2666,2665,2664,2663,2662,2661,2660,2659,2658,2657,2656,2655,-1,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,2544,-1,2507,2510,2509,2437,-1,2437,2509,2544,2438,-1,2438,2544,2543,2441,-1,2441,2543,2542,2443,-1,2443,2542,2541,2445,-1,2445,2541,2540,2447,-1,2447,2540,2539,2449,-1,2449,2539,2538,2451,-1,2451,2538,2537,2453,-1,2453,2537,2536,2455,-1,2455,2536,2535,2457,-1,2457,2535,2534,2459,-1,2459,2534,2533,2461,-1,2461,2533,2532,2463,-1,2463,2532,2531,2465,-1,2465,2531,2530,2467,-1,2467,2530,2529,2469,-1,2469,2529,2528,2471,-1,2471,2528,2527,2473,-1,2473,2527,2526,2475,-1,2475,2526,2525,2477,-1,2477,2525,2524,2479,-1,2479,2524,2523,2481,-1,2481,2523,2522,2483,-1,2483,2522,2521,2485,-1,2485,2521,2520,2487,-1,2487,2520,2519,2489,-1,2489,2519,2518,2491,-1,2491,2518,2517,2493,-1,2493,2517,2516,2495,-1,2495,2516,2515,2497,-1,2497,2515,2514,2499,-1,2499,2514,2513,2501,-1,2501,2513,2512,2503,-1,2503,2512,2511,2505,-1,2505,2511,2510,2507,-1,2439,2545,2546,2440,-1,2440,2546,2547,2508,-1,2508,2547,2548,2506,-1,2506,2548,2549,2504,-1,2504,2549,2550,2502,-1,2502,2550,2551,2500,-1,2500,2551,2552,2498,-1,2498,2552,2553,2496,-1,2496,2553,2554,2494,-1,2494,2554,2555,2492,-1,2492,2555,2556,2490,-1,2490,2556,2557,2488,-1,2488,2557,2558,2486,-1,2486,2558,2559,2484,-1,2484,2559,2560,2482,-1,2482,2560,2561,2480,-1,2480,2561,2562,2478,-1,2478,2562,2563,2476,-1,2476,2563,2564,2474,-1,2474,2564,2565,2472,-1,2472,2565,2566,2470,-1,2470,2566,2567,2468,-1,2468,2567,2568,2466,-1,2466,2568,2569,2464,-1,2464,2569,2570,2462,-1,2462,2570,2571,2460,-1,2460,2571,2572,2458,-1,2458,2572,2573,2456,-1,2456,2573,2574,2454,-1,2454,2574,2575,2452,-1,2452,2575,2576,2450,-1,2450,2576,2577,2448,-1,2448,2577,2578,2446,-1,2446,2578,2579,2444,-1,2444,2579,2580,2442,-1,2442,2580,2545,2439,-1,2545,2581,2582,2546,-1,2546,2582,2583,2547,-1,2547,2583,2584,2548,-1,2548,2584,2585,2549,-1,2549,2585,2586,2550,-1,2550,2586,2587,2551,-1,2551,2587,2588,2552,-1,2552,2588,2589,2553,-1,2553,2589,2590,2554,-1,2554,2590,2591,2555,-1,2555,2591,2592,2556,-1,2556,2592,2593,2557,-1,2557,2593,2594,2558,-1,2558,2594,2595,2559,-1,2559,2595,2596,2560,-1,2560,2596,2597,2561,-1,2561,2597,2598,2562,-1,2562,2598,2599,2563,-1,2563,2599,2600,2564,-1,2564,2600,2601,2565,-1,2565,2601,2602,2566,-1,2566,2602,2603,2567,-1,2567,2603,2604,2568,-1,2568,2604,2605,2569,-1,2569,2605,2606,2570,-1,2570,2606,2607,2571,-1,2571,2607,2608,2572,-1,2572,2608,2609,2573,-1,2573,2609,2610,2574,-1,2574,2610,2611,2575,-1,2575,2611,2612,2576,-1,2576,2612,2613,2577,-1,2577,2613,2614,2578,-1,2578,2614,2615,2579,-1,2579,2615,2616,2580,-1,2580,2616,2581,2545,-1,2581,2617,2618,2582,-1,2582,2618,2619,2583,-1,2583,2619,2620,2584,-1,2584,2620,2621,2585,-1,2585,2621,2622,2586,-1,2586,2622,2623,2587,-1,2587,2623,2624,2588,-1,2588,2624,2625,2589,-1,2589,2625,2626,2590,-1,2590,2626,2627,2591,-1,2591,2627,2628,2592,-1,2592,2628,2629,2593,-1,2593,2629,2630,2594,-1,2594,2630,2631,2595,-1,2595,2631,2632,2596,-1,2596,2632,2633,2597,-1,2597,2633,2634,2598,-1,2598,2634,2635,2599,-1,2599,2635,2636,2600,-1,2600,2636,2637,2601,-1,2601,2637,2638,2602,-1,2602,2638,2639,2603,-1,2603,2639,2640,2604,-1,2604,2640,2641,2605,-1,2605,2641,2642,2606,-1,2606,2642,2643,2607,-1,2607,2643,2644,2608,-1,2608,2644,2645,2609,-1,2609,2645,2646,2610,-1,2610,2646,2647,2611,-1,2611,2647,2648,2612,-1,2612,2648,2649,2613,-1,2613,2649,2650,2614,-1,2614,2650,2651,2615,-1,2615,2651,2652,2616,-1,2616,2652,2617,2581,-1,2617,2653,2654,2618,-1,2618,2654,2655,2619,-1,2619,2655,2656,2620,-1,2620,2656,2657,2621,-1,2621,2657,2658,2622,-1,2622,2658,2659,2623,-1,2623,2659,2660,2624,-1,2624,2660,2661,2625,-1,2625,2661,2662,2626,-1,2626,2662,2663,2627,-1,2627,2663,2664,2628,-1,2628,2664,2665,2629,-1,2629,2665,2666,2630,-1,2630,2666,2667,2631,-1,2631,2667,2668,2632,-1,2632,2668,2669,2633,-1,2633,2669,2670,2634,-1,2634,2670,2671,2635,-1,2635,2671,2672,2636,-1,2636,2672,2673,2637,-1,2637,2673,2674,2638,-1,2638,2674,2675,2639,-1,2639,2675,2676,2640,-1,2640,2676,2677,2641,-1,2641,2677,2678,2642,-1,2642,2678,2679,2643,-1,2643,2679,2680,2644,-1,2644,2680,2681,2645,-1,2645,2681,2682,2646,-1,2646,2682,2683,2647,-1,2647,2683,2684,2648,-1,2648,2684,2685,2649,-1,2649,2685,2686,2650,-1,2650,2686,2687,2651,-1,2651,2687,2688,2652,-1,2652,2688,2653,2617,-1,2689,2690,2691,2692,-1,2693,2694,2695,2696,-1,2697,2698,2694,2693,-1,2699,2700,2698,2697,-1,2701,2702,2700,2699,-1,2703,2704,2702,2701,-1,2705,2706,2704,2703,-1,2707,2708,2706,2705,-1,2709,2710,2711,2712,-1,2712,2711,2713,2714,-1,2714,2713,2715,2716,-1,2716,2715,2717,2718,-1,2718,2717,2708,2707,-1,2719,2720,2721,2722,-1,2723,2724,2720,2719,-1,2725,2726,2724,2723,-1,2727,2728,2729,2730,-1,2731,2732,2728,2727,-1,2733,2734,2732,2731,-1,2735,2736,2734,2733,-1,2737,2738,2736,2735,-1,2739,2740,2738,2737,-1,2741,2742,2743,2744,-1,2745,2746,2742,2741,-1,2747,2748,2746,2745,-1,2749,2750,2748,2747,-1,2751,2752,2750,2749,-1,2744,2743,2753,2754,-1,2754,2753,2755,2756,-1,2756,2755,2757,2758,-1,2758,2757,2759,2760,-1,2760,2759,2761,2762,-1,2762,2761,2763,2764,-1,2764,2763,2765,2766,-1,2767,2768,2769,2770,-1,2771,2772,2768,2767,-1,2773,2774,2772,2771,-1,2775,2776,2774,2773,-1,2777,2778,2776,2775,-1,2770,2769,2779,2780,-1,2780,2779,2781,2782,-1,2782,2781,2783,2784,-1,2784,2783,2785,2786,-1,2786,2785,2787,2788,-1,2788,2787,2789,2790,-1,2790,2789,2791,2792,-1,2722,2721,2793,-1,2778,2777,2794,-1,2752,2751,2795,-1,2710,2709,2796,-1,2696,2695,2797,-1,2766,2765,2798,-1,2740,2739,2799,-1,2792,2791,2800,-1,2692,2691,2726,2725,-1,2690,2689,2730,2729,-1,2801,2802,2803,-1,2803,2802,2804,-1,2804,2802,2805,-1,2806,2805,2807,-1,2808,2809,2805,2806,-1,2810,2811,2809,2808,-1,2812,2811,2810,-1,2813,2814,2815,-1,2816,2817,2818,-1,2819,2820,2817,2816,-1,2821,2820,2819,-1,2822,2801,2820,2821,-1,2823,2802,2801,2822,-1,2824,2802,2823,-1,2825,2802,2824,-1,2826,2802,2825,-1,2827,2802,2826,-1,2828,2802,2827,-1,2829,2805,2802,2828,-1,2830,2805,2829,-1,2807,2805,2830,-1,2831,2818,2817,2832,-1,2804,2833,2834,2803,-1,2835,2811,2812,2836,-1,2837,2834,2833,2838,-1,2839,2840,2841,2838,-1,2794,2793,2842,-1,2837,2815,2814,2843,-1,2838,2841,2815,2837,-1,2832,2837,2843,2831,-1,2836,2839,2838,2835,-1,2801,2803,2817,2820,-1,2803,2834,2832,2817,-1,2834,2837,2832,-1,2804,2805,2809,2811,-1,2835,2838,2833,-1,2804,2811,2835,2833,-1,2844,2845,2846,2847,-1,2821,2819,2845,2844,-1,2848,2849,2850,2851,-1,2852,2853,2854,2855,-1,2855,2854,2849,2848,-1,2856,2857,2858,-1,2851,2850,2859,2860,-1,2860,2859,2861,2862,-1,2862,2861,2857,2856,-1,2863,2864,2865,-1,2865,2866,2867,2868,-1,2868,2867,2869,2870,-1,2870,2869,2871,2872,-1,2872,2871,2873,2874,-1,2874,2873,2875,2876,-1,2876,2875,2877,2878,-1,2878,2877,2879,2880,-1,2881,2882,2883,2884,-1,2884,2883,2885,2886,-1,2886,2885,2887,2888,-1,2888,2887,2889,2890,-1,2890,2889,2891,2892,-1,2892,2891,2893,2894,-1,2894,2893,2895,2896,-1,2896,2895,2897,2898,-1,2898,2897,2827,2826,-1,2880,2879,2808,2806,-1,2899,2900,2901,-1,2901,2900,2902,2903,-1,2903,2902,2904,2905,-1,2905,2904,2906,-1,2824,2907,2908,-1,2908,2907,2909,2910,-1,2910,2909,2911,2912,-1,2912,2911,2913,2914,-1,2914,2913,2915,2916,-1,2916,2915,2917,2918,-1,2918,2917,2919,2920,-1,2920,2919,2921,2922,-1,2922,2921,2923,2924,-1,2925,2926,2927,2928,-1,2928,2927,2929,2930,-1,2930,2929,2931,2932,-1,2932,2931,2933,2934,-1,2934,2933,2935,2936,-1,2936,2935,2937,2938,-1,2938,2937,2939,2940,-1,2940,2939,2941,2942,-1,2942,2941,2829,2828,-1,2807,2830,2943,2944,-1,2944,2943,2945,2946,-1,2946,2945,2947,2948,-1,2948,2947,2949,2950,-1,2950,2949,2951,2952,-1,2952,2951,2953,2954,-1,2954,2953,2955,2956,-1,2956,2955,2957,2958,-1,2958,2957,2959,2960,-1,2961,2962,2963,-1,2961,2963,2964,-1,2865,2864,2866,-1,2865,2965,2863,-1,2966,2962,2961,-1,2906,2966,2961,2905,-1,2967,2968,2903,2905,-1,2969,2967,2905,2961,-1,2970,2971,2964,-1,2964,2971,2972,-1,2972,2971,2973,-1,2973,2971,2857,-1,2974,2975,2965,2865,-1,2976,2977,2927,2926,-1,2959,2957,2978,2979,-1,2977,2980,2929,2927,-1,2957,2955,2981,2978,-1,2980,2982,2931,2929,-1,2955,2953,2983,2981,-1,2982,2984,2933,2931,-1,2953,2951,2985,2983,-1,2984,2986,2935,2933,-1,2951,2949,2987,2985,-1,2986,2988,2937,2935,-1,2949,2947,2989,2987,-1,2988,2990,2939,2937,-1,2947,2945,2991,2989,-1,2990,2992,2941,2939,-1,2945,2943,2993,2991,-1,2992,2829,2941,-1,2943,2830,2993,-1,2994,2995,2881,2884,-1,2922,2924,2996,2997,-1,2998,2994,2884,2886,-1,2920,2922,2997,2999,-1,3000,2998,2886,2888,-1,2918,2920,2999,3001,-1,3002,3000,2888,2890,-1,2916,2918,3001,3003,-1,3004,3002,2890,2892,-1,2914,2916,3003,3005,-1,3006,3004,2892,2894,-1,2912,2914,3005,3007,-1,3008,3006,2894,2896,-1,2910,2912,3007,3009,-1,3010,3008,2896,2898,-1,2908,2910,3009,3011,-1,2825,3010,2898,2826,-1,2824,2908,3011,2825,-1,3012,3013,2859,2850,-1,3014,3012,2850,2849,-1,2901,2903,2968,3015,-1,2846,2899,3016,2847,-1,2899,3015,3014,3016,-1,2901,3015,2899,-1,3017,2973,2857,2861,-1,2961,2964,2972,2969,-1,3013,3017,2861,2859,-1,3018,2823,2822,3019,-1,2907,2824,2823,3020,-1,3021,3018,3019,2852,-1,2909,2907,3020,3022,-1,3023,3021,2852,2855,-1,2911,2909,3022,3024,-1,3025,3023,2855,2848,-1,2913,2911,3024,3026,-1,3027,3025,2848,2851,-1,2915,2913,3026,3028,-1,3029,3027,2851,2860,-1,2917,2915,3028,3030,-1,3031,3029,2860,2862,-1,2919,2917,3030,3032,-1,3033,3031,2862,2856,-1,2921,2919,3032,3034,-1,3035,3033,2856,2858,-1,2923,2921,3034,3036,-1,3037,2827,2897,-1,2942,2828,3038,-1,3039,3037,2897,2895,-1,2940,2942,3038,3040,-1,3041,3039,2895,2893,-1,2938,2940,3040,3042,-1,3043,3041,2893,2891,-1,2936,2938,3042,3044,-1,3045,3043,2891,2889,-1,2934,2936,3044,3046,-1,3047,3045,2889,2887,-1,2932,2934,3046,3048,-1,3049,3047,2887,2885,-1,2930,2932,3048,3050,-1,3051,3049,2885,2883,-1,2928,2930,3050,3052,-1,3053,3051,2883,2882,-1,2925,2928,3052,3054,-1,3055,2880,2806,-1,2944,3056,2807,-1,3055,3057,2878,2880,-1,2944,2946,3058,3056,-1,3057,3059,2876,2878,-1,2946,2948,3060,3058,-1,3059,3061,2874,2876,-1,2948,2950,3062,3060,-1,3061,3063,2872,2874,-1,2950,2952,3064,3062,-1,3063,3065,2870,2872,-1,2952,2954,3066,3064,-1,3065,3067,2868,2870,-1,2954,2956,3068,3066,-1,3067,2974,2865,2868,-1,2956,2958,3069,3068,-1,2958,2960,3070,3069,-1,2853,2852,3019,3071,-1,3071,3019,2822,2821,-1,3014,2849,2854,3016,-1,3016,2854,2853,2847,-1,2847,2853,3071,2844,-1,2844,3071,2821,-1,2789,3072,3073,2791,-1,2926,3074,2976,-1,3074,3075,2976,-1,2976,3075,2979,-1,3075,2959,2979,-1,3076,3077,2924,-1,2924,3077,2996,-1,2996,3077,2995,-1,3077,2881,2995,-1,3078,3079,2858,-1,2858,3079,3035,-1,3035,3079,3036,-1,3079,2923,3036,-1,3080,3081,2882,-1,2925,3054,3081,-1,2882,3081,3053,-1,3081,3054,3053,-1,3018,3020,2823,-1,3021,3022,3020,3018,-1,3023,3024,3022,3021,-1,3025,3026,3024,3023,-1,3027,3028,3026,3025,-1,3029,3030,3028,3027,-1,3031,3032,3030,3029,-1,3035,3036,3034,3033,-1,3033,3034,3032,3031,-1,2992,2993,2830,2829,-1,2990,2991,2993,2992,-1,2988,2989,2991,2990,-1,2986,2987,2989,2988,-1,2984,2985,2987,2986,-1,2982,2983,2985,2984,-1,2980,2981,2983,2982,-1,2976,2979,2978,2977,-1,2977,2978,2981,2980,-1,2974,3069,3070,2975,-1,2806,2807,3056,3055,-1,3055,3056,3058,3057,-1,3057,3058,3060,3059,-1,3059,3060,3062,3061,-1,3061,3062,3064,3063,-1,3063,3064,3066,3065,-1,3065,3066,3068,3067,-1,3067,3068,3069,2974,-1,3051,3052,3050,3049,-1,3053,3054,3052,3051,-1,3049,3050,3048,3047,-1,3047,3048,3046,3045,-1,3045,3046,3044,3043,-1,3043,3044,3042,3041,-1,3041,3042,3040,3039,-1,3039,3040,3038,3037,-1,3037,3038,2828,2827,-1,2998,2999,2997,2994,-1,3000,3001,2999,2998,-1,3002,3003,3001,3000,-1,3004,3005,3003,3002,-1,3006,3007,3005,3004,-1,3008,3009,3007,3006,-1,3010,3011,3009,3008,-1,2825,3011,3010,-1,2994,2997,2996,2995,-1,3017,2969,2972,2973,-1,3013,2967,2969,3017,-1,3012,2968,2967,3013,-1,3014,3015,2968,3012,-1,2846,3082,3083,2899,-1,2845,3084,3082,2846,-1,2819,2816,3084,2845,-1,2879,3085,2810,2808,-1,2877,3086,3085,2879,-1,2875,3087,3086,2877,-1,2873,3088,3087,2875,-1,2871,3089,3088,2873,-1,2869,3090,3089,2871,-1,2867,3091,3090,2869,-1,2866,3092,3091,2867,-1,2864,3093,3092,2866,-1,2863,3094,3093,2864,-1,2965,3095,3094,2863,-1,2965,2975,3095,-1,3095,2975,3096,-1,2975,3070,3096,-1,3096,3070,2960,-1,2959,3075,3096,2960,-1,2925,3081,3074,2926,-1,2881,3077,3080,2882,-1,2923,3079,3076,2924,-1,2857,2971,3078,2858,-1,2963,3097,2970,2964,-1,2962,3098,3097,2963,-1,2966,3099,3098,2962,-1,2906,3100,3099,2966,-1,2904,3101,3100,2906,-1,2902,3102,3101,2904,-1,2900,3103,3102,2902,-1,2899,3083,3103,2900,-1,3082,3104,3105,3083,-1,3084,3106,3104,3082,-1,2816,2818,3106,3084,-1,3085,3107,2812,2810,-1,3086,3108,3107,3085,-1,3087,3109,3108,3086,-1,3088,3110,3109,3087,-1,3089,3111,3110,3088,-1,3090,3112,3111,3089,-1,3091,3113,3112,3090,-1,3092,3114,3113,3091,-1,3093,3115,3114,3092,-1,3094,3116,3115,3093,-1,3095,3117,3116,3094,-1,3096,3118,3117,3095,-1,3075,3119,3118,3096,-1,3074,3120,3119,3075,-1,3081,3121,3120,3074,-1,3080,3122,3121,3081,-1,3077,3123,3122,3080,-1,3076,3124,3123,3077,-1,3079,3125,3124,3076,-1,3078,3126,3125,3079,-1,2971,3127,3126,3078,-1,2970,3128,3127,2971,-1,3097,3129,3128,2970,-1,3098,3130,3129,3097,-1,3099,3131,3130,3098,-1,3100,3132,3131,3099,-1,3101,3133,3132,3100,-1,3102,3134,3133,3101,-1,3103,3135,3134,3102,-1,3083,3105,3135,3103,-1,2812,3107,3136,-1,3137,2772,2774,3138,-1,3139,2768,2772,3137,-1,3140,2769,2768,3139,-1,3141,2779,2769,3140,-1,3142,2787,2785,3143,-1,3144,2800,2791,3073,-1,3144,3117,3118,3145,-1,3145,3118,3146,-1,3147,3148,3149,3146,-1,3148,3147,3120,3150,-1,3120,3121,3150,-1,2776,3151,3138,2774,-1,2787,3142,3072,2789,-1,2783,3152,3143,2785,-1,3152,2783,2781,3153,-1,2778,3154,3151,2776,-1,3155,3106,2818,-1,2818,2831,3155,-1,2794,3156,3154,2778,-1,3136,2836,2812,-1,2831,2843,3155,-1,3136,2839,2836,-1,3153,2781,2779,3141,-1,2840,2839,3156,-1,3156,2839,3136,3154,-1,3154,3136,3107,3151,-1,3151,3107,3108,3138,-1,3138,3108,3109,3137,-1,3137,3109,3110,3139,-1,3139,3110,3111,3140,-1,3140,3111,3112,3141,-1,3141,3112,3153,-1,3153,3112,3113,3152,-1,3152,3113,3143,-1,3143,3113,3114,3142,-1,3142,3114,3115,3072,-1,3072,3115,3116,3073,-1,3073,3116,3117,3144,-1,2799,2798,2765,2740,-1,2740,2765,2763,2738,-1,2738,2763,2761,2736,-1,2736,2761,2759,2734,-1,2734,2759,2757,2732,-1,2732,2757,2755,2728,-1,2728,2755,2753,2729,-1,2729,2753,2743,2690,-1,2690,2743,2742,2691,-1,2691,2742,2746,2726,-1,2726,2746,2748,2724,-1,2724,2748,2750,2720,-1,2720,2750,2752,2721,-1,2721,2752,2795,2793,-1,2793,2794,2777,2722,-1,2722,2777,2775,2719,-1,2719,2775,2773,2723,-1,2723,2773,2771,2725,-1,2725,2771,2767,2692,-1,2692,2767,2770,2689,-1,2689,2770,2780,2730,-1,2730,2780,2782,2727,-1,2727,2782,2784,2731,-1,2731,2784,2786,2733,-1,2733,2786,2788,2735,-1,2735,2788,2790,2737,-1,2737,2790,2792,2739,-1,2739,2792,2800,2799,-1,3157,2797,2695,3158,-1,3158,2695,2694,3159,-1,3159,2694,2698,3160,-1,3160,2698,2700,3161,-1,3161,2700,2702,3162,-1,3162,2702,2704,3163,-1,3163,2704,2706,3164,-1,3164,2706,2708,3165,-1,3165,2708,2717,3166,-1,3166,2717,2715,3167,-1,3167,2715,2713,3168,-1,3168,2713,2711,3169,-1,3169,2711,2710,3170,-1,3170,2710,2796,3171,-1,3171,2795,2751,3170,-1,3170,2751,2749,3169,-1,3169,2749,2747,3168,-1,3168,2747,2745,3167,-1,3167,2745,2741,3166,-1,3166,2741,2744,3165,-1,3165,2744,2754,3164,-1,3164,2754,2756,3163,-1,3163,2756,2758,3162,-1,3162,2758,2760,3161,-1,3161,2760,2762,3160,-1,3160,2762,2764,3159,-1,3159,2764,2766,3158,-1,3158,2766,2798,3157,-1,3172,3126,3127,3173,-1,3173,3127,3128,3174,-1,3174,3128,3129,3175,-1,3175,3129,3130,3176,-1,3176,3130,3131,3177,-1,3177,3131,3132,3178,-1,3178,3132,3133,3179,-1,3179,3133,3134,3180,-1,3180,3134,3135,3181,-1,3181,3135,3105,3182,-1,3182,3105,3104,3183,-1,3183,3104,3106,3184,-1,3184,3106,3155,3185,-1,3185,3155,2843,3186,-1,3186,2796,2709,3185,-1,3185,2709,2712,3184,-1,3184,2712,2714,3183,-1,3183,2714,2716,3182,-1,3182,2716,2718,3181,-1,3181,2718,2707,3180,-1,3180,2707,2705,3179,-1,3179,2705,2703,3178,-1,3178,2703,2701,3177,-1,3177,2701,2699,3176,-1,3176,2699,2697,3175,-1,3175,2697,2693,3174,-1,3174,2693,2696,3173,-1,3173,2696,2797,3172,-1,3121,3122,3150,-1,3150,3122,3123,3148,-1,3146,3118,3119,3147,-1,3147,3119,3120,-1,3148,3123,3124,3149,-1,3149,3124,3125,3187,-1,3187,3125,3126,3172,-1,3146,3149,3187,3145,-1,3145,2799,2800,-1,2800,3144,3145,-1,3187,3172,2797,-1,3157,2798,3187,-1,3187,2797,3157,-1,2798,2799,3145,3187,-1,2841,2840,2842,-1,2842,2840,3156,2794,-1,2795,2813,2842,-1,2842,2793,2795,-1,2796,2814,2813,-1,2813,2795,3171,-1,2815,2841,2842,2813,-1,2813,3171,2796,-1,3186,2843,2814,-1,2814,2796,3186,-1,3188,3189,3190,3191,-1,3192,3193,3194,3195,-1,3195,3194,3196,3197,-1,3197,3196,3198,3199,-1,3199,3198,3200,3201,-1,3201,3200,3202,3203,-1,3203,3202,3204,3205,-1,3205,3204,3206,3207,-1,3208,3209,3210,3211,-1,3212,3213,3209,3208,-1,3214,3215,3213,3212,-1,3216,3217,3215,3214,-1,3207,3206,3217,3216,-1,3218,3219,3220,3221,-1,3221,3220,3222,3223,-1,3223,3222,3224,3225,-1,3226,3227,3228,3229,-1,3229,3228,3230,3231,-1,3231,3230,3232,3233,-1,3233,3232,3234,3235,-1,3235,3234,3236,3237,-1,3237,3236,3238,3239,-1,3240,3241,3242,3243,-1,3243,3242,3244,3245,-1,3245,3244,3246,3247,-1,3247,3246,3248,3249,-1,3249,3248,3250,3251,-1,3252,3253,3241,3240,-1,3254,3255,3253,3252,-1,3256,3257,3255,3254,-1,3258,3259,3257,3256,-1,3260,3261,3259,3258,-1,3262,3263,3261,3260,-1,3264,3265,3263,3262,-1,3266,3267,3268,3269,-1,3269,3268,3270,3271,-1,3271,3270,3272,3273,-1,3273,3272,3274,3275,-1,3275,3274,3276,3277,-1,3278,3279,3267,3266,-1,3280,3281,3279,3278,-1,3282,3283,3281,3280,-1,3284,3285,3283,3282,-1,3286,3287,3285,3284,-1,3288,3289,3287,3286,-1,3290,3291,3289,3288,-1,3292,3219,3218,-1,3293,3277,3276,-1,3294,3251,3250,-1,3295,3211,3210,-1,3296,3193,3192,-1,3297,3265,3264,-1,3298,3239,3238,-1,3299,3291,3290,-1,3225,3224,3189,3188,-1,3227,3226,3191,3190,-1,3300,3301,3302,-1,3303,3301,3300,-1,3304,3301,3303,-1,3305,3304,3306,-1,3306,3304,3307,3308,-1,3308,3307,3309,3310,-1,3310,3309,3311,-1,3312,3313,3314,-1,3315,3316,3317,-1,3317,3316,3318,3319,-1,3319,3318,3320,-1,3320,3318,3302,3321,-1,3321,3302,3301,3322,-1,3322,3301,3323,-1,3323,3301,3324,-1,3324,3301,3325,-1,3325,3301,3326,-1,3326,3301,3327,-1,3327,3301,3304,3328,-1,3328,3304,3329,-1,3329,3304,3305,-1,3330,3316,3315,3331,-1,3300,3332,3333,3303,-1,3334,3311,3309,3335,-1,3336,3333,3332,3337,-1,3336,3338,3339,3340,-1,3341,3292,3293,-1,3342,3313,3312,3337,-1,3337,3312,3338,3336,-1,3331,3342,3337,3330,-1,3335,3336,3340,3334,-1,3318,3316,3300,3302,-1,3316,3330,3332,3300,-1,3330,3337,3332,-1,3309,3307,3304,3303,-1,3333,3336,3335,-1,3333,3335,3309,3303,-1,3343,3344,3345,3346,-1,3346,3345,3319,3320,-1,3347,3348,3349,3350,-1,3351,3352,3353,3354,-1,3350,3349,3352,3351,-1,3355,3356,3357,-1,3358,3359,3348,3347,-1,3360,3361,3359,3358,-1,3357,3356,3361,3360,-1,3362,3363,3364,-1,3365,3366,3367,3362,-1,3368,3369,3366,3365,-1,3370,3371,3369,3368,-1,3372,3373,3371,3370,-1,3374,3375,3373,3372,-1,3376,3377,3375,3374,-1,3378,3379,3377,3376,-1,3380,3381,3382,3383,-1,3384,3385,3381,3380,-1,3386,3387,3385,3384,-1,3388,3389,3387,3386,-1,3390,3391,3389,3388,-1,3392,3393,3391,3390,-1,3394,3395,3393,3392,-1,3396,3397,3395,3394,-1,3325,3326,3397,3396,-1,3306,3308,3379,3378,-1,3398,3399,3400,-1,3401,3402,3399,3398,-1,3403,3404,3402,3401,-1,3405,3404,3403,-1,3406,3407,3323,-1,3408,3409,3407,3406,-1,3410,3411,3409,3408,-1,3412,3413,3411,3410,-1,3414,3415,3413,3412,-1,3416,3417,3415,3414,-1,3418,3419,3417,3416,-1,3420,3421,3419,3418,-1,3422,3423,3421,3420,-1,3424,3425,3426,3427,-1,3428,3429,3425,3424,-1,3430,3431,3429,3428,-1,3432,3433,3431,3430,-1,3434,3435,3433,3432,-1,3436,3437,3435,3434,-1,3438,3439,3437,3436,-1,3440,3441,3439,3438,-1,3327,3328,3441,3440,-1,3442,3443,3329,3305,-1,3444,3445,3443,3442,-1,3446,3447,3445,3444,-1,3448,3449,3447,3446,-1,3450,3451,3449,3448,-1,3452,3453,3451,3450,-1,3454,3455,3453,3452,-1,3456,3457,3455,3454,-1,3458,3459,3457,3456,-1,3460,3461,3462,-1,3463,3460,3462,-1,3367,3363,3362,-1,3364,3464,3362,-1,3462,3461,3465,-1,3403,3462,3465,3405,-1,3403,3401,3466,3467,-1,3462,3403,3467,3468,-1,3463,3469,3470,-1,3471,3469,3463,-1,3472,3469,3471,-1,3356,3469,3472,-1,3362,3464,3473,3474,-1,3426,3425,3475,3476,-1,3477,3478,3457,3459,-1,3425,3429,3479,3475,-1,3478,3480,3455,3457,-1,3429,3431,3481,3479,-1,3480,3482,3453,3455,-1,3431,3433,3483,3481,-1,3482,3484,3451,3453,-1,3433,3435,3485,3483,-1,3484,3486,3449,3451,-1,3435,3437,3487,3485,-1,3486,3488,3447,3449,-1,3437,3439,3489,3487,-1,3488,3490,3445,3447,-1,3439,3441,3491,3489,-1,3490,3492,3443,3445,-1,3441,3328,3491,-1,3492,3329,3443,-1,3380,3383,3493,3494,-1,3495,3496,3422,3420,-1,3384,3380,3494,3497,-1,3498,3495,3420,3418,-1,3386,3384,3497,3499,-1,3500,3498,3418,3416,-1,3388,3386,3499,3501,-1,3502,3500,3416,3414,-1,3390,3388,3501,3503,-1,3504,3502,3414,3412,-1,3392,3390,3503,3505,-1,3506,3504,3412,3410,-1,3394,3392,3505,3507,-1,3508,3506,3410,3408,-1,3396,3394,3507,3509,-1,3510,3508,3408,3406,-1,3325,3396,3509,3324,-1,3324,3510,3406,3323,-1,3348,3359,3511,3512,-1,3349,3348,3512,3513,-1,3514,3466,3401,3398,-1,3343,3515,3400,3344,-1,3515,3513,3514,3400,-1,3400,3514,3398,-1,3361,3356,3472,3516,-1,3468,3471,3463,3462,-1,3359,3361,3516,3511,-1,3517,3321,3322,3518,-1,3519,3322,3323,3407,-1,3354,3517,3518,3520,-1,3521,3519,3407,3409,-1,3351,3354,3520,3522,-1,3523,3521,3409,3411,-1,3350,3351,3522,3524,-1,3525,3523,3411,3413,-1,3347,3350,3524,3526,-1,3527,3525,3413,3415,-1,3358,3347,3526,3528,-1,3529,3527,3415,3417,-1,3360,3358,3528,3530,-1,3531,3529,3417,3419,-1,3357,3360,3530,3532,-1,3533,3531,3419,3421,-1,3355,3357,3532,3534,-1,3535,3533,3421,3423,-1,3397,3326,3536,-1,3537,3327,3440,-1,3395,3397,3536,3538,-1,3539,3537,3440,3438,-1,3393,3395,3538,3540,-1,3541,3539,3438,3436,-1,3391,3393,3540,3542,-1,3543,3541,3436,3434,-1,3389,3391,3542,3544,-1,3545,3543,3434,3432,-1,3387,3389,3544,3546,-1,3547,3545,3432,3430,-1,3385,3387,3546,3548,-1,3549,3547,3430,3428,-1,3381,3385,3548,3550,-1,3551,3549,3428,3424,-1,3382,3381,3550,3552,-1,3553,3551,3424,3427,-1,3306,3378,3554,-1,3305,3555,3442,-1,3378,3376,3556,3554,-1,3555,3557,3444,3442,-1,3376,3374,3558,3556,-1,3557,3559,3446,3444,-1,3374,3372,3560,3558,-1,3559,3561,3448,3446,-1,3372,3370,3562,3560,-1,3561,3563,3450,3448,-1,3370,3368,3564,3562,-1,3563,3565,3452,3450,-1,3368,3365,3566,3564,-1,3565,3567,3454,3452,-1,3365,3362,3474,3566,-1,3567,3568,3456,3454,-1,3568,3569,3458,3456,-1,3570,3517,3354,3353,-1,3320,3321,3517,3570,-1,3515,3352,3349,3513,-1,3343,3353,3352,3515,-1,3346,3570,3353,3343,-1,3320,3570,3346,-1,3291,3571,3572,3289,-1,3476,3573,3426,-1,3476,3574,3573,-1,3477,3574,3476,-1,3477,3459,3574,-1,3422,3575,3576,-1,3496,3575,3422,-1,3493,3575,3496,-1,3493,3383,3575,-1,3355,3577,3578,-1,3534,3577,3355,-1,3535,3577,3534,-1,3535,3423,3577,-1,3382,3579,3580,-1,3579,3553,3427,-1,3552,3579,3382,-1,3552,3553,3579,-1,3322,3519,3518,-1,3518,3519,3521,3520,-1,3520,3521,3523,3522,-1,3522,3523,3525,3524,-1,3524,3525,3527,3526,-1,3526,3527,3529,3528,-1,3528,3529,3531,3530,-1,3532,3533,3535,3534,-1,3530,3531,3533,3532,-1,3328,3329,3492,3491,-1,3491,3492,3490,3489,-1,3489,3490,3488,3487,-1,3487,3488,3486,3485,-1,3485,3486,3484,3483,-1,3483,3484,3482,3481,-1,3481,3482,3480,3479,-1,3475,3478,3477,3476,-1,3479,3480,3478,3475,-1,3473,3569,3568,3474,-1,3554,3555,3305,3306,-1,3556,3557,3555,3554,-1,3558,3559,3557,3556,-1,3560,3561,3559,3558,-1,3562,3563,3561,3560,-1,3564,3565,3563,3562,-1,3566,3567,3565,3564,-1,3474,3568,3567,3566,-1,3548,3549,3551,3550,-1,3550,3551,3553,3552,-1,3546,3547,3549,3548,-1,3544,3545,3547,3546,-1,3542,3543,3545,3544,-1,3540,3541,3543,3542,-1,3538,3539,3541,3540,-1,3536,3537,3539,3538,-1,3326,3327,3537,3536,-1,3494,3495,3498,3497,-1,3497,3498,3500,3499,-1,3499,3500,3502,3501,-1,3501,3502,3504,3503,-1,3503,3504,3506,3505,-1,3505,3506,3508,3507,-1,3507,3508,3510,3509,-1,3509,3510,3324,-1,3493,3496,3495,3494,-1,3472,3471,3468,3516,-1,3516,3468,3467,3511,-1,3511,3467,3466,3512,-1,3512,3466,3514,3513,-1,3400,3581,3582,3344,-1,3344,3582,3583,3345,-1,3345,3583,3317,3319,-1,3308,3310,3584,3379,-1,3379,3584,3585,3377,-1,3377,3585,3586,3375,-1,3375,3586,3587,3373,-1,3373,3587,3588,3371,-1,3371,3588,3589,3369,-1,3369,3589,3590,3366,-1,3366,3590,3591,3367,-1,3367,3591,3592,3363,-1,3363,3592,3593,3364,-1,3364,3593,3594,3464,-1,3594,3473,3464,-1,3595,3473,3594,-1,3595,3569,3473,-1,3458,3569,3595,-1,3458,3595,3574,3459,-1,3426,3573,3579,3427,-1,3382,3580,3575,3383,-1,3422,3576,3577,3423,-1,3355,3578,3469,3356,-1,3463,3470,3596,3460,-1,3460,3596,3597,3461,-1,3461,3597,3598,3465,-1,3465,3598,3599,3405,-1,3405,3599,3600,3404,-1,3404,3600,3601,3402,-1,3402,3601,3602,3399,-1,3399,3602,3581,3400,-1,3581,3603,3604,3582,-1,3582,3604,3605,3583,-1,3583,3605,3315,3317,-1,3310,3311,3606,3584,-1,3584,3606,3607,3585,-1,3585,3607,3608,3586,-1,3586,3608,3609,3587,-1,3587,3609,3610,3588,-1,3588,3610,3611,3589,-1,3589,3611,3612,3590,-1,3590,3612,3613,3591,-1,3591,3613,3614,3592,-1,3592,3614,3615,3593,-1,3593,3615,3616,3594,-1,3594,3616,3617,3595,-1,3595,3617,3618,3574,-1,3574,3618,3619,3573,-1,3573,3619,3620,3579,-1,3579,3620,3621,3580,-1,3580,3621,3622,3575,-1,3575,3622,3623,3576,-1,3576,3623,3624,3577,-1,3577,3624,3625,3578,-1,3578,3625,3626,3469,-1,3469,3626,3627,3470,-1,3470,3627,3628,3596,-1,3596,3628,3629,3597,-1,3597,3629,3630,3598,-1,3598,3630,3631,3599,-1,3599,3631,3632,3600,-1,3600,3632,3633,3601,-1,3601,3633,3634,3602,-1,3602,3634,3603,3581,-1,3635,3606,3311,-1,3636,3272,3270,3637,-1,3637,3270,3268,3638,-1,3638,3268,3267,3639,-1,3639,3267,3279,3640,-1,3641,3285,3287,3642,-1,3571,3291,3299,3643,-1,3644,3617,3616,3643,-1,3645,3617,3644,-1,3645,3646,3647,3648,-1,3649,3619,3648,3647,-1,3649,3620,3619,-1,3272,3636,3650,3274,-1,3289,3572,3642,3287,-1,3285,3641,3651,3283,-1,3652,3281,3283,3651,-1,3274,3650,3653,3276,-1,3315,3605,3654,-1,3654,3331,3315,-1,3276,3653,3655,3293,-1,3311,3334,3635,-1,3654,3342,3331,-1,3334,3340,3635,-1,3640,3279,3281,3652,-1,3655,3340,3339,-1,3653,3635,3340,3655,-1,3650,3606,3635,3653,-1,3636,3607,3606,3650,-1,3637,3608,3607,3636,-1,3638,3609,3608,3637,-1,3639,3610,3609,3638,-1,3640,3611,3610,3639,-1,3652,3611,3640,-1,3651,3612,3611,3652,-1,3641,3612,3651,-1,3642,3613,3612,3641,-1,3572,3614,3613,3642,-1,3571,3615,3614,3572,-1,3643,3616,3615,3571,-1,3238,3265,3297,3298,-1,3236,3263,3265,3238,-1,3234,3261,3263,3236,-1,3232,3259,3261,3234,-1,3230,3257,3259,3232,-1,3228,3255,3257,3230,-1,3227,3253,3255,3228,-1,3190,3241,3253,3227,-1,3189,3242,3241,3190,-1,3224,3244,3242,3189,-1,3222,3246,3244,3224,-1,3220,3248,3246,3222,-1,3219,3250,3248,3220,-1,3292,3294,3250,3219,-1,3218,3277,3293,3292,-1,3221,3275,3277,3218,-1,3223,3273,3275,3221,-1,3225,3271,3273,3223,-1,3188,3269,3271,3225,-1,3191,3266,3269,3188,-1,3226,3278,3266,3191,-1,3229,3280,3278,3226,-1,3231,3282,3280,3229,-1,3233,3284,3282,3231,-1,3235,3286,3284,3233,-1,3237,3288,3286,3235,-1,3239,3290,3288,3237,-1,3298,3299,3290,3239,-1,3656,3193,3296,3657,-1,3658,3194,3193,3656,-1,3659,3196,3194,3658,-1,3660,3198,3196,3659,-1,3661,3200,3198,3660,-1,3662,3202,3200,3661,-1,3663,3204,3202,3662,-1,3664,3206,3204,3663,-1,3665,3217,3206,3664,-1,3666,3215,3217,3665,-1,3667,3213,3215,3666,-1,3668,3209,3213,3667,-1,3669,3210,3209,3668,-1,3670,3295,3210,3669,-1,3669,3251,3294,3670,-1,3668,3249,3251,3669,-1,3667,3247,3249,3668,-1,3666,3245,3247,3667,-1,3665,3243,3245,3666,-1,3664,3240,3243,3665,-1,3663,3252,3240,3664,-1,3662,3254,3252,3663,-1,3661,3256,3254,3662,-1,3660,3258,3256,3661,-1,3659,3260,3258,3660,-1,3658,3262,3260,3659,-1,3656,3264,3262,3658,-1,3657,3297,3264,3656,-1,3671,3626,3625,3672,-1,3673,3627,3626,3671,-1,3674,3628,3627,3673,-1,3675,3629,3628,3674,-1,3676,3630,3629,3675,-1,3677,3631,3630,3676,-1,3678,3632,3631,3677,-1,3679,3633,3632,3678,-1,3680,3634,3633,3679,-1,3681,3603,3634,3680,-1,3682,3604,3603,3681,-1,3683,3605,3604,3682,-1,3684,3654,3605,3683,-1,3685,3342,3654,3684,-1,3684,3211,3295,3685,-1,3683,3208,3211,3684,-1,3682,3212,3208,3683,-1,3681,3214,3212,3682,-1,3680,3216,3214,3681,-1,3679,3207,3216,3680,-1,3678,3205,3207,3679,-1,3677,3203,3205,3678,-1,3676,3201,3203,3677,-1,3675,3199,3201,3676,-1,3674,3197,3199,3675,-1,3673,3195,3197,3674,-1,3671,3192,3195,3673,-1,3672,3296,3192,3671,-1,3649,3621,3620,-1,3647,3622,3621,3649,-1,3648,3618,3617,3645,-1,3619,3618,3648,-1,3646,3623,3622,3647,-1,3686,3624,3623,3646,-1,3672,3625,3624,3686,-1,3644,3686,3646,3645,-1,3299,3298,3644,-1,3644,3643,3299,-1,3296,3672,3686,-1,3686,3297,3657,-1,3657,3296,3686,-1,3686,3644,3298,3297,-1,3341,3339,3338,-1,3293,3655,3339,3341,-1,3341,3314,3294,-1,3294,3292,3341,-1,3314,3313,3295,-1,3670,3294,3314,-1,3314,3341,3338,3312,-1,3295,3670,3314,-1,3313,3342,3685,-1,3685,3295,3313,-1,3687,3688,3689,3690,-1,3691,3692,3693,3694,-1,3694,3693,3695,3696,-1,3696,3695,3697,3698,-1,3698,3697,3699,3700,-1,3700,3699,3701,3702,-1,3702,3701,3703,3704,-1,3704,3703,3705,3706,-1,3707,3708,3709,3710,-1,3711,3712,3708,3707,-1,3713,3714,3712,3711,-1,3715,3716,3714,3713,-1,3706,3705,3716,3715,-1,3717,3718,3719,3720,-1,3720,3719,3721,3722,-1,3722,3721,3723,3724,-1,3725,3726,3727,3728,-1,3728,3727,3729,3730,-1,3730,3729,3731,3732,-1,3732,3731,3733,3734,-1,3734,3733,3735,3736,-1,3736,3735,3737,3738,-1,3739,3740,3741,3742,-1,3742,3741,3743,3744,-1,3744,3743,3745,3746,-1,3746,3745,3747,3748,-1,3748,3747,3749,3750,-1,3751,3752,3740,3739,-1,3753,3754,3752,3751,-1,3755,3756,3754,3753,-1,3757,3758,3756,3755,-1,3759,3760,3758,3757,-1,3761,3762,3760,3759,-1,3763,3764,3762,3761,-1,3765,3766,3767,3768,-1,3768,3767,3769,3770,-1,3770,3769,3771,3772,-1,3772,3771,3773,3774,-1,3774,3773,3775,3776,-1,3777,3778,3766,3765,-1,3779,3780,3778,3777,-1,3781,3782,3780,3779,-1,3783,3784,3782,3781,-1,3785,3786,3784,3783,-1,3787,3788,3786,3785,-1,3789,3790,3788,3787,-1,3791,3718,3717,-1,3792,3776,3775,-1,3793,3750,3749,-1,3794,3710,3709,-1,3795,3692,3691,-1,3796,3764,3763,-1,3797,3738,3737,-1,3798,3790,3789,-1,3724,3723,3688,3687,-1,3726,3725,3690,3689,-1,3799,3800,3801,-1,3802,3800,3799,-1,3803,3800,3802,-1,3804,3803,3805,-1,3805,3803,3806,3807,-1,3807,3806,3808,3809,-1,3809,3808,3810,-1,3811,3812,3813,-1,3814,3815,3816,-1,3816,3815,3817,3818,-1,3818,3817,3819,-1,3819,3817,3801,3820,-1,3820,3801,3800,3821,-1,3821,3800,3822,-1,3822,3800,3823,-1,3823,3800,3824,-1,3824,3800,3825,-1,3825,3800,3826,-1,3826,3800,3803,3827,-1,3827,3803,3828,-1,3828,3803,3804,-1,3829,3815,3814,3830,-1,3799,3831,3832,3802,-1,3833,3810,3808,3834,-1,3835,3832,3831,3836,-1,3835,3837,3838,3839,-1,3840,3791,3792,-1,3841,3812,3811,3836,-1,3836,3811,3837,3835,-1,3830,3841,3836,3829,-1,3834,3835,3839,3833,-1,3817,3815,3799,3801,-1,3815,3829,3831,3799,-1,3829,3836,3831,-1,3808,3806,3803,3802,-1,3832,3835,3834,-1,3832,3834,3808,3802,-1,3842,3843,3844,3845,-1,3845,3844,3818,3819,-1,3846,3847,3848,3849,-1,3850,3851,3852,3853,-1,3849,3848,3851,3850,-1,3854,3855,3856,-1,3857,3858,3847,3846,-1,3859,3860,3858,3857,-1,3856,3855,3860,3859,-1,3861,3862,3863,-1,3864,3865,3866,3861,-1,3867,3868,3865,3864,-1,3869,3870,3868,3867,-1,3871,3872,3870,3869,-1,3873,3874,3872,3871,-1,3875,3876,3874,3873,-1,3877,3878,3876,3875,-1,3879,3880,3881,3882,-1,3883,3884,3880,3879,-1,3885,3886,3884,3883,-1,3887,3888,3886,3885,-1,3889,3890,3888,3887,-1,3891,3892,3890,3889,-1,3893,3894,3892,3891,-1,3895,3896,3894,3893,-1,3824,3825,3896,3895,-1,3805,3807,3878,3877,-1,3897,3898,3899,-1,3900,3901,3898,3897,-1,3902,3903,3901,3900,-1,3904,3903,3902,-1,3905,3906,3822,-1,3907,3908,3906,3905,-1,3909,3910,3908,3907,-1,3911,3912,3910,3909,-1,3913,3914,3912,3911,-1,3915,3916,3914,3913,-1,3917,3918,3916,3915,-1,3919,3920,3918,3917,-1,3921,3922,3920,3919,-1,3923,3924,3925,3926,-1,3927,3928,3924,3923,-1,3929,3930,3928,3927,-1,3931,3932,3930,3929,-1,3933,3934,3932,3931,-1,3935,3936,3934,3933,-1,3937,3938,3936,3935,-1,3939,3940,3938,3937,-1,3826,3827,3940,3939,-1,3941,3942,3828,3804,-1,3943,3944,3942,3941,-1,3945,3946,3944,3943,-1,3947,3948,3946,3945,-1,3949,3950,3948,3947,-1,3951,3952,3950,3949,-1,3953,3954,3952,3951,-1,3955,3956,3954,3953,-1,3957,3958,3956,3955,-1,3959,3960,3961,-1,3962,3959,3961,-1,3866,3862,3861,-1,3863,3963,3861,-1,3961,3960,3964,-1,3902,3961,3964,3904,-1,3902,3900,3965,3966,-1,3961,3902,3966,3967,-1,3962,3968,3969,-1,3970,3968,3962,-1,3971,3968,3970,-1,3855,3968,3971,-1,3861,3963,3972,3973,-1,3925,3924,3974,3975,-1,3976,3977,3956,3958,-1,3924,3928,3978,3974,-1,3977,3979,3954,3956,-1,3928,3930,3980,3978,-1,3979,3981,3952,3954,-1,3930,3932,3982,3980,-1,3981,3983,3950,3952,-1,3932,3934,3984,3982,-1,3983,3985,3948,3950,-1,3934,3936,3986,3984,-1,3985,3987,3946,3948,-1,3936,3938,3988,3986,-1,3987,3989,3944,3946,-1,3938,3940,3990,3988,-1,3989,3991,3942,3944,-1,3940,3827,3990,-1,3991,3828,3942,-1,3879,3882,3992,3993,-1,3994,3995,3921,3919,-1,3883,3879,3993,3996,-1,3997,3994,3919,3917,-1,3885,3883,3996,3998,-1,3999,3997,3917,3915,-1,3887,3885,3998,4000,-1,4001,3999,3915,3913,-1,3889,3887,4000,4002,-1,4003,4001,3913,3911,-1,3891,3889,4002,4004,-1,4005,4003,3911,3909,-1,3893,3891,4004,4006,-1,4007,4005,3909,3907,-1,3895,3893,4006,4008,-1,4009,4007,3907,3905,-1,3824,3895,4008,3823,-1,3823,4009,3905,3822,-1,3847,3858,4010,4011,-1,3848,3847,4011,4012,-1,4013,3965,3900,3897,-1,3842,4014,3899,3843,-1,4014,4012,4013,3899,-1,3899,4013,3897,-1,3860,3855,3971,4015,-1,3967,3970,3962,3961,-1,3858,3860,4015,4010,-1,4016,3820,3821,4017,-1,4018,3821,3822,3906,-1,3853,4016,4017,4019,-1,4020,4018,3906,3908,-1,3850,3853,4019,4021,-1,4022,4020,3908,3910,-1,3849,3850,4021,4023,-1,4024,4022,3910,3912,-1,3846,3849,4023,4025,-1,4026,4024,3912,3914,-1,3857,3846,4025,4027,-1,4028,4026,3914,3916,-1,3859,3857,4027,4029,-1,4030,4028,3916,3918,-1,3856,3859,4029,4031,-1,4032,4030,3918,3920,-1,3854,3856,4031,4033,-1,4034,4032,3920,3922,-1,3896,3825,4035,-1,4036,3826,3939,-1,3894,3896,4035,4037,-1,4038,4036,3939,3937,-1,3892,3894,4037,4039,-1,4040,4038,3937,3935,-1,3890,3892,4039,4041,-1,4042,4040,3935,3933,-1,3888,3890,4041,4043,-1,4044,4042,3933,3931,-1,3886,3888,4043,4045,-1,4046,4044,3931,3929,-1,3884,3886,4045,4047,-1,4048,4046,3929,3927,-1,3880,3884,4047,4049,-1,4050,4048,3927,3923,-1,3881,3880,4049,4051,-1,4052,4050,3923,3926,-1,3805,3877,4053,-1,3804,4054,3941,-1,3877,3875,4055,4053,-1,4054,4056,3943,3941,-1,3875,3873,4057,4055,-1,4056,4058,3945,3943,-1,3873,3871,4059,4057,-1,4058,4060,3947,3945,-1,3871,3869,4061,4059,-1,4060,4062,3949,3947,-1,3869,3867,4063,4061,-1,4062,4064,3951,3949,-1,3867,3864,4065,4063,-1,4064,4066,3953,3951,-1,3864,3861,3973,4065,-1,4066,4067,3955,3953,-1,4067,4068,3957,3955,-1,4069,4016,3853,3852,-1,3819,3820,4016,4069,-1,4014,3851,3848,4012,-1,3842,3852,3851,4014,-1,3845,4069,3852,3842,-1,3819,4069,3845,-1,3790,4070,4071,3788,-1,3975,4072,3925,-1,3975,4073,4072,-1,3976,4073,3975,-1,3976,3958,4073,-1,3921,4074,4075,-1,3995,4074,3921,-1,3992,4074,3995,-1,3992,3882,4074,-1,3854,4076,4077,-1,4033,4076,3854,-1,4034,4076,4033,-1,4034,3922,4076,-1,3881,4078,4079,-1,4078,4052,3926,-1,4051,4078,3881,-1,4051,4052,4078,-1,3821,4018,4017,-1,4017,4018,4020,4019,-1,4019,4020,4022,4021,-1,4021,4022,4024,4023,-1,4023,4024,4026,4025,-1,4025,4026,4028,4027,-1,4027,4028,4030,4029,-1,4031,4032,4034,4033,-1,4029,4030,4032,4031,-1,3827,3828,3991,3990,-1,3990,3991,3989,3988,-1,3988,3989,3987,3986,-1,3986,3987,3985,3984,-1,3984,3985,3983,3982,-1,3982,3983,3981,3980,-1,3980,3981,3979,3978,-1,3974,3977,3976,3975,-1,3978,3979,3977,3974,-1,3972,4068,4067,3973,-1,4053,4054,3804,3805,-1,4055,4056,4054,4053,-1,4057,4058,4056,4055,-1,4059,4060,4058,4057,-1,4061,4062,4060,4059,-1,4063,4064,4062,4061,-1,4065,4066,4064,4063,-1,3973,4067,4066,4065,-1,4047,4048,4050,4049,-1,4049,4050,4052,4051,-1,4045,4046,4048,4047,-1,4043,4044,4046,4045,-1,4041,4042,4044,4043,-1,4039,4040,4042,4041,-1,4037,4038,4040,4039,-1,4035,4036,4038,4037,-1,3825,3826,4036,4035,-1,3993,3994,3997,3996,-1,3996,3997,3999,3998,-1,3998,3999,4001,4000,-1,4000,4001,4003,4002,-1,4002,4003,4005,4004,-1,4004,4005,4007,4006,-1,4006,4007,4009,4008,-1,4008,4009,3823,-1,3992,3995,3994,3993,-1,3971,3970,3967,4015,-1,4015,3967,3966,4010,-1,4010,3966,3965,4011,-1,4011,3965,4013,4012,-1,3899,4080,4081,3843,-1,3843,4081,4082,3844,-1,3844,4082,3816,3818,-1,3807,3809,4083,3878,-1,3878,4083,4084,3876,-1,3876,4084,4085,3874,-1,3874,4085,4086,3872,-1,3872,4086,4087,3870,-1,3870,4087,4088,3868,-1,3868,4088,4089,3865,-1,3865,4089,4090,3866,-1,3866,4090,4091,3862,-1,3862,4091,4092,3863,-1,3863,4092,4093,3963,-1,4093,3972,3963,-1,4094,3972,4093,-1,4094,4068,3972,-1,3957,4068,4094,-1,3957,4094,4073,3958,-1,3925,4072,4078,3926,-1,3881,4079,4074,3882,-1,3921,4075,4076,3922,-1,3854,4077,3968,3855,-1,3962,3969,4095,3959,-1,3959,4095,4096,3960,-1,3960,4096,4097,3964,-1,3964,4097,4098,3904,-1,3904,4098,4099,3903,-1,3903,4099,4100,3901,-1,3901,4100,4101,3898,-1,3898,4101,4080,3899,-1,4080,4102,4103,4081,-1,4081,4103,4104,4082,-1,4082,4104,3814,3816,-1,3809,3810,4105,4083,-1,4083,4105,4106,4084,-1,4084,4106,4107,4085,-1,4085,4107,4108,4086,-1,4086,4108,4109,4087,-1,4087,4109,4110,4088,-1,4088,4110,4111,4089,-1,4089,4111,4112,4090,-1,4090,4112,4113,4091,-1,4091,4113,4114,4092,-1,4092,4114,4115,4093,-1,4093,4115,4116,4094,-1,4094,4116,4117,4073,-1,4073,4117,4118,4072,-1,4072,4118,4119,4078,-1,4078,4119,4120,4079,-1,4079,4120,4121,4074,-1,4074,4121,4122,4075,-1,4075,4122,4123,4076,-1,4076,4123,4124,4077,-1,4077,4124,4125,3968,-1,3968,4125,4126,3969,-1,3969,4126,4127,4095,-1,4095,4127,4128,4096,-1,4096,4128,4129,4097,-1,4097,4129,4130,4098,-1,4098,4130,4131,4099,-1,4099,4131,4132,4100,-1,4100,4132,4133,4101,-1,4101,4133,4102,4080,-1,4134,4105,3810,-1,4135,3771,3769,4136,-1,4136,3769,3767,4137,-1,4137,3767,3766,4138,-1,4138,3766,3778,4139,-1,4140,3784,3786,4141,-1,4070,3790,3798,4142,-1,4143,4116,4115,4142,-1,4144,4116,4143,-1,4144,4145,4146,4147,-1,4148,4118,4147,4146,-1,4148,4119,4118,-1,3771,4135,4149,3773,-1,3788,4071,4141,3786,-1,3784,4140,4150,3782,-1,4151,3780,3782,4150,-1,3773,4149,4152,3775,-1,3814,4104,4153,-1,4153,3830,3814,-1,3775,4152,4154,3792,-1,3810,3833,4134,-1,4153,3841,3830,-1,3833,3839,4134,-1,4139,3778,3780,4151,-1,4154,3839,3838,-1,4152,4134,3839,4154,-1,4149,4105,4134,4152,-1,4135,4106,4105,4149,-1,4136,4107,4106,4135,-1,4137,4108,4107,4136,-1,4138,4109,4108,4137,-1,4139,4110,4109,4138,-1,4151,4110,4139,-1,4150,4111,4110,4151,-1,4140,4111,4150,-1,4141,4112,4111,4140,-1,4071,4113,4112,4141,-1,4070,4114,4113,4071,-1,4142,4115,4114,4070,-1,3737,3764,3796,3797,-1,3735,3762,3764,3737,-1,3733,3760,3762,3735,-1,3731,3758,3760,3733,-1,3729,3756,3758,3731,-1,3727,3754,3756,3729,-1,3726,3752,3754,3727,-1,3689,3740,3752,3726,-1,3688,3741,3740,3689,-1,3723,3743,3741,3688,-1,3721,3745,3743,3723,-1,3719,3747,3745,3721,-1,3718,3749,3747,3719,-1,3791,3793,3749,3718,-1,3717,3776,3792,3791,-1,3720,3774,3776,3717,-1,3722,3772,3774,3720,-1,3724,3770,3772,3722,-1,3687,3768,3770,3724,-1,3690,3765,3768,3687,-1,3725,3777,3765,3690,-1,3728,3779,3777,3725,-1,3730,3781,3779,3728,-1,3732,3783,3781,3730,-1,3734,3785,3783,3732,-1,3736,3787,3785,3734,-1,3738,3789,3787,3736,-1,3797,3798,3789,3738,-1,4155,3692,3795,4156,-1,4157,3693,3692,4155,-1,4158,3695,3693,4157,-1,4159,3697,3695,4158,-1,4160,3699,3697,4159,-1,4161,3701,3699,4160,-1,4162,3703,3701,4161,-1,4163,3705,3703,4162,-1,4164,3716,3705,4163,-1,4165,3714,3716,4164,-1,4166,3712,3714,4165,-1,4167,3708,3712,4166,-1,4168,3709,3708,4167,-1,4169,3794,3709,4168,-1,4168,3750,3793,4169,-1,4167,3748,3750,4168,-1,4166,3746,3748,4167,-1,4165,3744,3746,4166,-1,4164,3742,3744,4165,-1,4163,3739,3742,4164,-1,4162,3751,3739,4163,-1,4161,3753,3751,4162,-1,4160,3755,3753,4161,-1,4159,3757,3755,4160,-1,4158,3759,3757,4159,-1,4157,3761,3759,4158,-1,4155,3763,3761,4157,-1,4156,3796,3763,4155,-1,4170,4125,4124,4171,-1,4172,4126,4125,4170,-1,4173,4127,4126,4172,-1,4174,4128,4127,4173,-1,4175,4129,4128,4174,-1,4176,4130,4129,4175,-1,4177,4131,4130,4176,-1,4178,4132,4131,4177,-1,4179,4133,4132,4178,-1,4180,4102,4133,4179,-1,4181,4103,4102,4180,-1,4182,4104,4103,4181,-1,4183,4153,4104,4182,-1,4184,3841,4153,4183,-1,4183,3710,3794,4184,-1,4182,3707,3710,4183,-1,4181,3711,3707,4182,-1,4180,3713,3711,4181,-1,4179,3715,3713,4180,-1,4178,3706,3715,4179,-1,4177,3704,3706,4178,-1,4176,3702,3704,4177,-1,4175,3700,3702,4176,-1,4174,3698,3700,4175,-1,4173,3696,3698,4174,-1,4172,3694,3696,4173,-1,4170,3691,3694,4172,-1,4171,3795,3691,4170,-1,4148,4120,4119,-1,4146,4121,4120,4148,-1,4147,4117,4116,4144,-1,4118,4117,4147,-1,4145,4122,4121,4146,-1,4185,4123,4122,4145,-1,4171,4124,4123,4185,-1,4143,4185,4145,4144,-1,3798,3797,4143,-1,4143,4142,3798,-1,3795,4171,4185,-1,4185,3796,4156,-1,4156,3795,4185,-1,4185,4143,3797,3796,-1,3840,3838,3837,-1,3792,4154,3838,3840,-1,3840,3813,3793,-1,3793,3791,3840,-1,3813,3812,3794,-1,4169,3793,3813,-1,3813,3840,3837,3811,-1,3794,4169,3813,-1,3812,3841,4184,-1,4184,3794,3812,-1,4186,4187,4188,4189,-1,4190,4191,4192,4193,-1,4194,4195,4191,4190,-1,4196,4197,4195,4194,-1,4198,4199,4197,4196,-1,4200,4201,4199,4198,-1,4202,4203,4201,4200,-1,4204,4205,4203,4202,-1,4206,4207,4208,4209,-1,4209,4208,4210,4211,-1,4211,4210,4212,4213,-1,4213,4212,4214,4215,-1,4215,4214,4205,4204,-1,4216,4217,4218,4219,-1,4220,4221,4217,4216,-1,4222,4223,4221,4220,-1,4224,4225,4226,4227,-1,4228,4229,4225,4224,-1,4230,4231,4229,4228,-1,4232,4233,4231,4230,-1,4234,4235,4233,4232,-1,4236,4237,4235,4234,-1,4238,4239,4240,4241,-1,4242,4243,4239,4238,-1,4244,4245,4243,4242,-1,4246,4247,4245,4244,-1,4248,4249,4247,4246,-1,4241,4240,4250,4251,-1,4251,4250,4252,4253,-1,4253,4252,4254,4255,-1,4255,4254,4256,4257,-1,4257,4256,4258,4259,-1,4259,4258,4260,4261,-1,4261,4260,4262,4263,-1,4264,4265,4266,4267,-1,4268,4269,4265,4264,-1,4270,4271,4269,4268,-1,4272,4273,4271,4270,-1,4274,4275,4273,4272,-1,4267,4266,4276,4277,-1,4277,4276,4278,4279,-1,4279,4278,4280,4281,-1,4281,4280,4282,4283,-1,4283,4282,4284,4285,-1,4285,4284,4286,4287,-1,4287,4286,4288,4289,-1,4219,4218,4290,-1,4275,4274,4291,-1,4249,4248,4292,-1,4207,4206,4293,-1,4193,4192,4294,-1,4263,4262,4295,-1,4237,4236,4296,-1,4289,4288,4297,-1,4189,4188,4223,4222,-1,4187,4186,4227,4226,-1,4298,4299,4300,-1,4300,4299,4301,-1,4301,4299,4302,-1,4303,4302,4304,-1,4305,4306,4302,4303,-1,4307,4308,4306,4305,-1,4309,4308,4307,-1,4310,4311,4312,-1,4313,4314,4315,-1,4316,4317,4314,4313,-1,4318,4317,4316,-1,4319,4298,4317,4318,-1,4320,4299,4298,4319,-1,4321,4299,4320,-1,4322,4299,4321,-1,4323,4299,4322,-1,4324,4299,4323,-1,4325,4299,4324,-1,4326,4302,4299,4325,-1,4327,4302,4326,-1,4304,4302,4327,-1,4328,4315,4314,4329,-1,4301,4330,4331,4300,-1,4332,4308,4309,4333,-1,4334,4331,4330,4335,-1,4336,4337,4338,4335,-1,4291,4290,4339,-1,4334,4312,4311,4340,-1,4335,4338,4312,4334,-1,4329,4334,4340,4328,-1,4333,4336,4335,4332,-1,4298,4300,4314,4317,-1,4300,4331,4329,4314,-1,4331,4334,4329,-1,4301,4302,4306,4308,-1,4332,4335,4330,-1,4301,4308,4332,4330,-1,4341,4342,4343,4344,-1,4318,4316,4342,4341,-1,4345,4346,4347,4348,-1,4349,4350,4351,4352,-1,4352,4351,4346,4345,-1,4353,4354,4355,-1,4348,4347,4356,4357,-1,4357,4356,4358,4359,-1,4359,4358,4354,4353,-1,4360,4361,4362,-1,4362,4363,4364,4365,-1,4365,4364,4366,4367,-1,4367,4366,4368,4369,-1,4369,4368,4370,4371,-1,4371,4370,4372,4373,-1,4373,4372,4374,4375,-1,4375,4374,4376,4377,-1,4378,4379,4380,4381,-1,4381,4380,4382,4383,-1,4383,4382,4384,4385,-1,4385,4384,4386,4387,-1,4387,4386,4388,4389,-1,4389,4388,4390,4391,-1,4391,4390,4392,4393,-1,4393,4392,4394,4395,-1,4395,4394,4324,4323,-1,4377,4376,4305,4303,-1,4396,4397,4398,-1,4398,4397,4399,4400,-1,4400,4399,4401,4402,-1,4402,4401,4403,-1,4321,4404,4405,-1,4405,4404,4406,4407,-1,4407,4406,4408,4409,-1,4409,4408,4410,4411,-1,4411,4410,4412,4413,-1,4413,4412,4414,4415,-1,4415,4414,4416,4417,-1,4417,4416,4418,4419,-1,4419,4418,4420,4421,-1,4422,4423,4424,4425,-1,4425,4424,4426,4427,-1,4427,4426,4428,4429,-1,4429,4428,4430,4431,-1,4431,4430,4432,4433,-1,4433,4432,4434,4435,-1,4435,4434,4436,4437,-1,4437,4436,4438,4439,-1,4439,4438,4326,4325,-1,4304,4327,4440,4441,-1,4441,4440,4442,4443,-1,4443,4442,4444,4445,-1,4445,4444,4446,4447,-1,4447,4446,4448,4449,-1,4449,4448,4450,4451,-1,4451,4450,4452,4453,-1,4453,4452,4454,4455,-1,4455,4454,4456,4457,-1,4458,4459,4460,-1,4458,4460,4461,-1,4362,4361,4363,-1,4362,4462,4360,-1,4463,4459,4458,-1,4403,4463,4458,4402,-1,4464,4465,4400,4402,-1,4466,4464,4402,4458,-1,4467,4468,4461,-1,4461,4468,4469,-1,4469,4468,4470,-1,4470,4468,4354,-1,4471,4472,4462,4362,-1,4473,4474,4424,4423,-1,4456,4454,4475,4476,-1,4474,4477,4426,4424,-1,4454,4452,4478,4475,-1,4477,4479,4428,4426,-1,4452,4450,4480,4478,-1,4479,4481,4430,4428,-1,4450,4448,4482,4480,-1,4481,4483,4432,4430,-1,4448,4446,4484,4482,-1,4483,4485,4434,4432,-1,4446,4444,4486,4484,-1,4485,4487,4436,4434,-1,4444,4442,4488,4486,-1,4487,4489,4438,4436,-1,4442,4440,4490,4488,-1,4489,4326,4438,-1,4440,4327,4490,-1,4491,4492,4378,4381,-1,4419,4421,4493,4494,-1,4495,4491,4381,4383,-1,4417,4419,4494,4496,-1,4497,4495,4383,4385,-1,4415,4417,4496,4498,-1,4499,4497,4385,4387,-1,4413,4415,4498,4500,-1,4501,4499,4387,4389,-1,4411,4413,4500,4502,-1,4503,4501,4389,4391,-1,4409,4411,4502,4504,-1,4505,4503,4391,4393,-1,4407,4409,4504,4506,-1,4507,4505,4393,4395,-1,4405,4407,4506,4508,-1,4322,4507,4395,4323,-1,4321,4405,4508,4322,-1,4509,4510,4356,4347,-1,4511,4509,4347,4346,-1,4398,4400,4465,4512,-1,4343,4396,4513,4344,-1,4396,4512,4511,4513,-1,4398,4512,4396,-1,4514,4470,4354,4358,-1,4458,4461,4469,4466,-1,4510,4514,4358,4356,-1,4515,4320,4319,4516,-1,4404,4321,4320,4517,-1,4518,4515,4516,4349,-1,4406,4404,4517,4519,-1,4520,4518,4349,4352,-1,4408,4406,4519,4521,-1,4522,4520,4352,4345,-1,4410,4408,4521,4523,-1,4524,4522,4345,4348,-1,4412,4410,4523,4525,-1,4526,4524,4348,4357,-1,4414,4412,4525,4527,-1,4528,4526,4357,4359,-1,4416,4414,4527,4529,-1,4530,4528,4359,4353,-1,4418,4416,4529,4531,-1,4532,4530,4353,4355,-1,4420,4418,4531,4533,-1,4534,4324,4394,-1,4439,4325,4535,-1,4536,4534,4394,4392,-1,4437,4439,4535,4537,-1,4538,4536,4392,4390,-1,4435,4437,4537,4539,-1,4540,4538,4390,4388,-1,4433,4435,4539,4541,-1,4542,4540,4388,4386,-1,4431,4433,4541,4543,-1,4544,4542,4386,4384,-1,4429,4431,4543,4545,-1,4546,4544,4384,4382,-1,4427,4429,4545,4547,-1,4548,4546,4382,4380,-1,4425,4427,4547,4549,-1,4550,4548,4380,4379,-1,4422,4425,4549,4551,-1,4552,4377,4303,-1,4441,4553,4304,-1,4552,4554,4375,4377,-1,4441,4443,4555,4553,-1,4554,4556,4373,4375,-1,4443,4445,4557,4555,-1,4556,4558,4371,4373,-1,4445,4447,4559,4557,-1,4558,4560,4369,4371,-1,4447,4449,4561,4559,-1,4560,4562,4367,4369,-1,4449,4451,4563,4561,-1,4562,4564,4365,4367,-1,4451,4453,4565,4563,-1,4564,4471,4362,4365,-1,4453,4455,4566,4565,-1,4455,4457,4567,4566,-1,4350,4349,4516,4568,-1,4568,4516,4319,4318,-1,4511,4346,4351,4513,-1,4513,4351,4350,4344,-1,4344,4350,4568,4341,-1,4341,4568,4318,-1,4286,4569,4570,4288,-1,4423,4571,4473,-1,4571,4572,4473,-1,4473,4572,4476,-1,4572,4456,4476,-1,4573,4574,4421,-1,4421,4574,4493,-1,4493,4574,4492,-1,4574,4378,4492,-1,4575,4576,4355,-1,4355,4576,4532,-1,4532,4576,4533,-1,4576,4420,4533,-1,4577,4578,4379,-1,4422,4551,4578,-1,4379,4578,4550,-1,4578,4551,4550,-1,4515,4517,4320,-1,4518,4519,4517,4515,-1,4520,4521,4519,4518,-1,4522,4523,4521,4520,-1,4524,4525,4523,4522,-1,4526,4527,4525,4524,-1,4528,4529,4527,4526,-1,4532,4533,4531,4530,-1,4530,4531,4529,4528,-1,4489,4490,4327,4326,-1,4487,4488,4490,4489,-1,4485,4486,4488,4487,-1,4483,4484,4486,4485,-1,4481,4482,4484,4483,-1,4479,4480,4482,4481,-1,4477,4478,4480,4479,-1,4473,4476,4475,4474,-1,4474,4475,4478,4477,-1,4471,4566,4567,4472,-1,4303,4304,4553,4552,-1,4552,4553,4555,4554,-1,4554,4555,4557,4556,-1,4556,4557,4559,4558,-1,4558,4559,4561,4560,-1,4560,4561,4563,4562,-1,4562,4563,4565,4564,-1,4564,4565,4566,4471,-1,4548,4549,4547,4546,-1,4550,4551,4549,4548,-1,4546,4547,4545,4544,-1,4544,4545,4543,4542,-1,4542,4543,4541,4540,-1,4540,4541,4539,4538,-1,4538,4539,4537,4536,-1,4536,4537,4535,4534,-1,4534,4535,4325,4324,-1,4495,4496,4494,4491,-1,4497,4498,4496,4495,-1,4499,4500,4498,4497,-1,4501,4502,4500,4499,-1,4503,4504,4502,4501,-1,4505,4506,4504,4503,-1,4507,4508,4506,4505,-1,4322,4508,4507,-1,4491,4494,4493,4492,-1,4514,4466,4469,4470,-1,4510,4464,4466,4514,-1,4509,4465,4464,4510,-1,4511,4512,4465,4509,-1,4343,4579,4580,4396,-1,4342,4581,4579,4343,-1,4316,4313,4581,4342,-1,4376,4582,4307,4305,-1,4374,4583,4582,4376,-1,4372,4584,4583,4374,-1,4370,4585,4584,4372,-1,4368,4586,4585,4370,-1,4366,4587,4586,4368,-1,4364,4588,4587,4366,-1,4363,4589,4588,4364,-1,4361,4590,4589,4363,-1,4360,4591,4590,4361,-1,4462,4592,4591,4360,-1,4462,4472,4592,-1,4592,4472,4593,-1,4472,4567,4593,-1,4593,4567,4457,-1,4456,4572,4593,4457,-1,4422,4578,4571,4423,-1,4378,4574,4577,4379,-1,4420,4576,4573,4421,-1,4354,4468,4575,4355,-1,4460,4594,4467,4461,-1,4459,4595,4594,4460,-1,4463,4596,4595,4459,-1,4403,4597,4596,4463,-1,4401,4598,4597,4403,-1,4399,4599,4598,4401,-1,4397,4600,4599,4399,-1,4396,4580,4600,4397,-1,4579,4601,4602,4580,-1,4581,4603,4601,4579,-1,4313,4315,4603,4581,-1,4582,4604,4309,4307,-1,4583,4605,4604,4582,-1,4584,4606,4605,4583,-1,4585,4607,4606,4584,-1,4586,4608,4607,4585,-1,4587,4609,4608,4586,-1,4588,4610,4609,4587,-1,4589,4611,4610,4588,-1,4590,4612,4611,4589,-1,4591,4613,4612,4590,-1,4592,4614,4613,4591,-1,4593,4615,4614,4592,-1,4572,4616,4615,4593,-1,4571,4617,4616,4572,-1,4578,4618,4617,4571,-1,4577,4619,4618,4578,-1,4574,4620,4619,4577,-1,4573,4621,4620,4574,-1,4576,4622,4621,4573,-1,4575,4623,4622,4576,-1,4468,4624,4623,4575,-1,4467,4625,4624,4468,-1,4594,4626,4625,4467,-1,4595,4627,4626,4594,-1,4596,4628,4627,4595,-1,4597,4629,4628,4596,-1,4598,4630,4629,4597,-1,4599,4631,4630,4598,-1,4600,4632,4631,4599,-1,4580,4602,4632,4600,-1,4309,4604,4633,-1,4634,4269,4271,4635,-1,4636,4265,4269,4634,-1,4637,4266,4265,4636,-1,4638,4276,4266,4637,-1,4639,4284,4282,4640,-1,4641,4297,4288,4570,-1,4641,4614,4615,4642,-1,4642,4615,4643,-1,4644,4645,4646,4643,-1,4645,4644,4617,4647,-1,4617,4618,4647,-1,4273,4648,4635,4271,-1,4284,4639,4569,4286,-1,4280,4649,4640,4282,-1,4649,4280,4278,4650,-1,4275,4651,4648,4273,-1,4652,4603,4315,-1,4315,4328,4652,-1,4291,4653,4651,4275,-1,4633,4333,4309,-1,4328,4340,4652,-1,4633,4336,4333,-1,4650,4278,4276,4638,-1,4337,4336,4653,-1,4653,4336,4633,4651,-1,4651,4633,4604,4648,-1,4648,4604,4605,4635,-1,4635,4605,4606,4634,-1,4634,4606,4607,4636,-1,4636,4607,4608,4637,-1,4637,4608,4609,4638,-1,4638,4609,4650,-1,4650,4609,4610,4649,-1,4649,4610,4640,-1,4640,4610,4611,4639,-1,4639,4611,4612,4569,-1,4569,4612,4613,4570,-1,4570,4613,4614,4641,-1,4296,4295,4262,4237,-1,4237,4262,4260,4235,-1,4235,4260,4258,4233,-1,4233,4258,4256,4231,-1,4231,4256,4254,4229,-1,4229,4254,4252,4225,-1,4225,4252,4250,4226,-1,4226,4250,4240,4187,-1,4187,4240,4239,4188,-1,4188,4239,4243,4223,-1,4223,4243,4245,4221,-1,4221,4245,4247,4217,-1,4217,4247,4249,4218,-1,4218,4249,4292,4290,-1,4290,4291,4274,4219,-1,4219,4274,4272,4216,-1,4216,4272,4270,4220,-1,4220,4270,4268,4222,-1,4222,4268,4264,4189,-1,4189,4264,4267,4186,-1,4186,4267,4277,4227,-1,4227,4277,4279,4224,-1,4224,4279,4281,4228,-1,4228,4281,4283,4230,-1,4230,4283,4285,4232,-1,4232,4285,4287,4234,-1,4234,4287,4289,4236,-1,4236,4289,4297,4296,-1,4654,4294,4192,4655,-1,4655,4192,4191,4656,-1,4656,4191,4195,4657,-1,4657,4195,4197,4658,-1,4658,4197,4199,4659,-1,4659,4199,4201,4660,-1,4660,4201,4203,4661,-1,4661,4203,4205,4662,-1,4662,4205,4214,4663,-1,4663,4214,4212,4664,-1,4664,4212,4210,4665,-1,4665,4210,4208,4666,-1,4666,4208,4207,4667,-1,4667,4207,4293,4668,-1,4668,4292,4248,4667,-1,4667,4248,4246,4666,-1,4666,4246,4244,4665,-1,4665,4244,4242,4664,-1,4664,4242,4238,4663,-1,4663,4238,4241,4662,-1,4662,4241,4251,4661,-1,4661,4251,4253,4660,-1,4660,4253,4255,4659,-1,4659,4255,4257,4658,-1,4658,4257,4259,4657,-1,4657,4259,4261,4656,-1,4656,4261,4263,4655,-1,4655,4263,4295,4654,-1,4669,4623,4624,4670,-1,4670,4624,4625,4671,-1,4671,4625,4626,4672,-1,4672,4626,4627,4673,-1,4673,4627,4628,4674,-1,4674,4628,4629,4675,-1,4675,4629,4630,4676,-1,4676,4630,4631,4677,-1,4677,4631,4632,4678,-1,4678,4632,4602,4679,-1,4679,4602,4601,4680,-1,4680,4601,4603,4681,-1,4681,4603,4652,4682,-1,4682,4652,4340,4683,-1,4683,4293,4206,4682,-1,4682,4206,4209,4681,-1,4681,4209,4211,4680,-1,4680,4211,4213,4679,-1,4679,4213,4215,4678,-1,4678,4215,4204,4677,-1,4677,4204,4202,4676,-1,4676,4202,4200,4675,-1,4675,4200,4198,4674,-1,4674,4198,4196,4673,-1,4673,4196,4194,4672,-1,4672,4194,4190,4671,-1,4671,4190,4193,4670,-1,4670,4193,4294,4669,-1,4618,4619,4647,-1,4647,4619,4620,4645,-1,4643,4615,4616,4644,-1,4644,4616,4617,-1,4645,4620,4621,4646,-1,4646,4621,4622,4684,-1,4684,4622,4623,4669,-1,4643,4646,4684,4642,-1,4642,4296,4297,-1,4297,4641,4642,-1,4684,4669,4294,-1,4654,4295,4684,-1,4684,4294,4654,-1,4295,4296,4642,4684,-1,4338,4337,4339,-1,4339,4337,4653,4291,-1,4292,4310,4339,-1,4339,4290,4292,-1,4293,4311,4310,-1,4310,4292,4668,-1,4312,4338,4339,4310,-1,4310,4668,4293,-1,4683,4340,4311,-1,4311,4293,4683,-1],
          coord=Coordinate(point=[(-0.0715,4.7609,6.393),(-0.0715,5.32,5.8672),(-0.0715,5.4506,5.668),(-0.0715,5.7185,5.2608),(-0.0715,6.1332,4.6662),(-0.0715,6.3536,4.1748),(-0.0715,6.6117,3.5004),(-0.0715,6.8656,2.5844),(-0.0715,7.0316,1.8702),(-0.0715,-4.5845,2.8994),(-0.0715,-4.6105,4.1963),(-0.0715,-4.4662,5.4505),(-0.0715,-4.2759,6.2407),(-0.0715,4.1225,6.7411),(-0.0715,4.3542,6.6196),(-0.115,5.3189,5.8728),(-0.1111,4.7655,6.3942),(-0.1122,4.5683,6.4144),(-0.1158,5.1714,5.8907),(-0.1187,4.3517,6.4611),(-0.1304,4.8613,5.9113),(-0.1378,4.1048,6.3998),(-0.1592,4.5355,5.8733),(-0.2349,4.0598,6.3424),(-0.2743,4.4871,5.6882),(-0.4248,4.1883,5.7387),(-0.1054,4.944,5.7831),(-0.0996,5.2751,5.6945),(-0.0935,5.4456,5.6486),(-0.1119,4.3593,6.6196),(-0.1137,4.1279,6.741),(-0.0917,5.5255,5.3031),(-0.0931,5.7149,5.2563),(-0.0894,5.7518,4.9114),(-0.0908,6.1267,4.6456),(-0.0982,5.2023,5.3679),(-0.0883,5.3713,5.1037),(-0.087,6.0244,4.3326),(-0.0877,5.7021,4.4812),(-0.089,5.8017,4.1836),(-0.0859,6.2149,3.8139),(-0.0862,6.3363,4.1791),(-0.0838,6.5955,3.4813),(-0.1075,6.1752,2.5396),(-0.1047,6.6722,2.152),(-0.093,6.4795,2.9394),(-0.1027,6.0465,3.4007),(-0.0841,6.8477,2.5958),(-0.1075,7.018,1.8348),(-0.1125,5.2463,4.5852),(-0.139,4.8008,5.4613),(-0.1294,5.675,2.8705),(-0.1176,5.5521,3.7787),(-0.2719,4.9133,4.7146),(-0.1867,5.0436,4.6656),(-0.9788,1.1311,5.3058),(-0.9274,1.0472,5.9131),(-1.0012,0.715,5.3726),(-1.0145,0.6015,5.2531),(-1.0351,1.3671,3.6219),(-1.0812,-0.0368,5.0343),(-1.1289,0.0316,3.8069),(-1.0826,-0.4107,5.0896),(-1.1056,-0.7652,4.9794),(-1.13,-0.4779,3.8284),(-1.111,-1.0401,5.0257),(-1.138,-1.0099,3.9376),(-1.0801,-1.3221,5.2192),(-1.1159,-1.33,3.9336),(-1.056,-1.5953,5.2608),(-1.0912,-1.6475,3.8984),(-1.0215,-2.0695,5.2191),(-1.061,-2.0841,3.7723),(-0.8975,-2.611,5.0803),(-0.8628,-3.3219,3.5518),(-0.7376,-3.186,5.2316),(-0.8353,2.2739,5.7518),(-1.0078,0.5098,5.4156),(-1.0184,0.491,5.4499),(-1.0578,-1.5613,5.5142),(-1.0812,-1.3012,5.4101),(-1.0691,-1.3167,5.3827),(-1.0462,-1.5707,5.484),(-1.1052,-1.0512,5.1122),(-0.691,-3.1529,5.737),(-0.5872,-3.3544,6.0348),(-0.8297,-2.8681,5.5359),(-0.9199,-2.5217,5.4264),(-1.0232,-2.0417,5.5185),(-1.1127,-1.0446,5.15),(-1.1082,-0.8728,5.1474),(-1.08,-0.558,5.312),(-1.0745,-0.0614,5.2487),(-0.6816,-3.1581,5.6874),(-0.5601,-3.3878,6.0126),(-0.5057,-4.087,5.6931),(-0.5273,-4.2309,4.4499),(-1.0986,-0.8605,5.1099),(-1.0714,-0.5492,5.2797),(-0.9098,-2.5367,5.3895),(-1.0124,-2.0486,5.4855),(-0.8128,-2.8891,5.4975),(-1.0656,-0.0587,5.2205),(-0.1665,5.3182,3.8847),(-0.2632,5.13,3.9965),(-0.4386,4.6634,4.2067),(-0.435,4.5186,4.819),(-0.29,5.2923,2.9871),(-0.1841,5.4679,2.9065),(-0.4691,4.8904,3.1127),(-0.2921,-4.3844,5.5252),(-0.2999,-4.522,4.2751),(-0.7403,4.0695,3.1945),(-0.9289,2.6819,3.4254),(-0.5364,-4.2275,3.0814),(-0.2997,-4.4891,2.9556),(-0.7105,3.7513,4.4671),(-0.6965,3.6453,4.9002),(-0.8749,2.4368,5.0267),(-0.6813,3.4461,5.7377),(-0.1255,-4.4592,5.4649),(-0.123,-4.6076,4.2048),(-0.1222,-4.583,2.9031),(-0.499,-3.5208,6.5963),(-0.2801,-4.1843,6.309),(-0.4654,-3.5464,6.5776),(0.3224,-3.5464,6.5776),(0.1371,-4.1843,6.309),(0.356,-3.5208,6.5963),(-0.0208,-4.583,2.9031),(-0.02,-4.6076,4.2048),(-0.0175,-4.4592,5.4649),(0.5383,3.4461,5.7377),(0.7319,2.4368,5.0267),(0.5535,3.6453,4.9002),(0.5675,3.7513,4.4671),(0.1567,-4.4891,2.9556),(0.3934,-4.2275,3.0814),(0.7859,2.6819,3.4254),(0.5973,4.0695,3.1945),(0.1569,-4.522,4.2751),(0.1491,-4.3844,5.5252),(0.3261,4.8904,3.1127),(0.0411,5.4679,2.9065),(0.147,5.2923,2.9871),(0.292,4.5186,4.819),(0.2956,4.6634,4.2067),(0.1202,5.13,3.9965),(0.0235,5.3182,3.8847),(0.9226,-0.0587,5.2205),(0.6698,-2.8891,5.4975),(0.8694,-2.0486,5.4855),(0.7668,-2.5367,5.3895),(0.9284,-0.5492,5.2797),(0.9555,-0.8605,5.1099),(0.3843,-4.2309,4.4499),(0.3627,-4.087,5.6931),(0.4171,-3.3878,6.0126),(0.5385,-3.1581,5.6874),(0.9314,-0.0614,5.2487),(0.937,-0.558,5.312),(0.9652,-0.8728,5.1474),(0.9697,-1.0446,5.15),(0.8802,-2.0417,5.5185),(0.7769,-2.5217,5.4264),(0.6867,-2.8681,5.5359),(0.4442,-3.3544,6.0348),(0.548,-3.1529,5.737),(0.9622,-1.0512,5.1122),(0.9032,-1.5707,5.484),(0.926,-1.3167,5.3827),(0.9382,-1.3012,5.4101),(0.9148,-1.5613,5.5142),(0.8753,0.491,5.4499),(0.8648,0.5098,5.4156),(0.6923,2.2739,5.7518),(0.5946,-3.186,5.2316),(0.7198,-3.3219,3.5518),(0.7544,-2.611,5.0803),(0.918,-2.0841,3.7723),(0.8785,-2.0695,5.2191),(0.9482,-1.6475,3.8984),(0.913,-1.5953,5.2608),(0.9728,-1.33,3.9336),(0.9371,-1.3221,5.2192),(0.995,-1.0099,3.9376),(0.968,-1.0401,5.0257),(0.987,-0.4779,3.8284),(0.9626,-0.7652,4.9794),(0.9396,-0.4107,5.0896),(0.9859,0.0316,3.8069),(0.9382,-0.0368,5.0343),(0.8921,1.3671,3.6219),(0.8715,0.6015,5.2531),(0.8582,0.715,5.3726),(0.7844,1.0472,5.9131),(0.8357,1.1311,5.3058),(0.0437,5.0436,4.6656),(0.1289,4.9133,4.7146),(-0.0254,5.5521,3.7787),(-0.0136,5.675,2.8705),(-0.0041,4.8008,5.4613),(-0.0305,5.2463,4.5852),(-0.0355,7.018,1.8348),(-0.0589,6.8477,2.5958),(-0.0403,6.0465,3.4007),(-0.05,6.4795,2.9394),(-0.0383,6.6722,2.152),(-0.0355,6.1752,2.5396),(-0.0592,6.5955,3.4813),(-0.0568,6.3363,4.1791),(-0.0571,6.2149,3.8139),(-0.0541,5.8017,4.1836),(-0.0553,5.7021,4.4812),(-0.056,6.0244,4.3326),(-0.0548,5.3713,5.1037),(-0.0448,5.2023,5.3679),(-0.0523,6.1267,4.6456),(-0.0536,5.7518,4.9114),(-0.0499,5.7149,5.2563),(-0.0513,5.5255,5.3031),(-0.0293,4.1279,6.741),(-0.0311,4.3593,6.6196),(-0.0495,5.4456,5.6486),(-0.0434,5.2751,5.6945),(-0.0376,4.944,5.7831),(0.2818,4.1883,5.7387),(0.1312,4.4871,5.6882),(0.0919,4.0598,6.3424),(0.0162,4.5355,5.8733),(-0.0052,4.1048,6.3998),(-0.0127,4.8613,5.9113),(-0.0243,4.3517,6.4611),(-0.0272,5.1714,5.8907),(-0.0308,4.5683,6.4144),(-0.0319,4.7655,6.3942),(-0.028,5.3189,5.8728),(-0.0715,7.2164,1.1696),(-0.0715,7.3227,0.5074),(-0.0715,7.45,-0.2038),(-0.0715,7.5608,-0.9116),(-0.0715,7.5944,-1.5121),(-0.0715,-5.1673,-0.5789),(-0.0715,-5.3077,-0.6607),(-0.0715,-5.4384,-0.7051),(-0.0715,-5.4746,-0.7018),(-0.0715,-5.4988,-0.6791),(-0.0715,-5.5014,-0.6422),(-0.0715,-5.4049,-0.4772),(-0.0715,-5.3069,-0.3622),(-0.0715,-5.0009,-0.0359),(-0.0715,-4.7102,0.1841),(-0.0715,-4.6846,0.2225),(-0.0715,-4.5587,0.9127),(-0.0715,-4.5345,1.8395),(-0.1158,-4.5582,0.9145),(-0.0876,-4.6845,0.2229),(-0.3176,-4.536,0.918),(-0.0895,7.1913,1.1817),(-0.1072,6.824,1.3523),(-0.1078,6.3135,1.6032),(-0.0978,7.5791,-1.4985),(-0.1216,7.2349,-1.2365),(-0.1,7.544,-0.9002),(-0.1257,7.2054,-0.6382),(-0.101,7.4328,-0.1919),(-0.129,7.1014,0.0702),(-0.0915,7.2923,0.5142),(-0.1113,6.9667,0.6461),(-0.119,6.5362,-0.9984),(-0.1246,6.5344,-0.3466),(-0.1283,6.4741,0.347),(-0.1158,6.3929,0.9479),(-0.1376,5.9371,-0.5324),(-0.1391,5.9452,-0.0499),(-0.1553,5.9043,0.4963),(-0.1338,5.8406,1.1619),(-0.1341,5.7725,1.866),(-1.106,-1.7257,2.4133),(-1.1523,-0.953,2.4941),(-1.0959,-1.9008,1.2515),(-1.13,-0.9412,1.2779),(-1.133,0.0616,2.4545),(-0.4837,5.0346,2.0291),(-0.3042,5.4161,1.9546),(-0.3024,5.4967,1.3231),(-0.1856,5.6743,1.2204),(-0.1905,5.5887,1.8975),(-0.3051,5.6189,0.2185),(-0.1873,5.7943,0.0681),(-0.2021,5.7589,0.5493),(-0.3141,5.5876,0.6075),(-0.3143,5.5944,-0.3723),(-0.1909,5.7705,-0.4556),(-0.5039,5.1256,-0.2909),(-0.5004,-4.4672,0.1981),(-0.2763,-4.6633,0.2014),(-0.4731,5.2386,0.5324),(-0.785,4.0923,-0.2176),(-0.9666,2.4785,-0.1428),(-1.012,1.5776,-0.0575),(-1.0949,0.1172,0.1424),(-1.1033,-0.9419,0.2057),(-1.0697,-1.7456,0.0753),(-0.8512,-3.2888,0.0545),(-0.562,-4.3532,0.9263),(-0.4795,5.0962,1.4711),(-0.744,4.2513,1.9478),(-0.7656,4.2615,0.6104),(-0.9655,2.6702,0.6526),(-1.0214,1.565,0.8312),(-1.1099,0.0819,1.1936),(-0.8706,-3.3771,1.0007),(-0.5641,-4.2059,1.9704),(-0.319,-4.4758,1.8754),(-0.9396,2.7984,2.0989),(-1.0393,1.4742,2.3363),(-1.0908,-1.9978,2.313),(-0.8851,-3.2921,2.2036),(-0.1049,-4.685,0.1994),(-0.1216,-4.5333,1.8425),(-0.0769,-5.4894,-0.6762),(-0.0768,-5.4916,-0.6433),(-0.077,-5.4693,-0.6954),(-0.077,-5.4391,-0.6981),(-0.0769,-5.3969,-0.4812),(-0.0765,-5.3114,-0.654),(-0.0768,-5.2997,-0.3673),(-0.0766,-5.1718,-0.5724),(-0.0768,-4.994,-0.0409),(-0.0768,-4.7037,0.178),(-0.0662,-4.7037,0.178),(-0.0662,-4.994,-0.0409),(-0.0664,-5.1718,-0.5724),(-0.0662,-5.2997,-0.3673),(-0.0665,-5.3114,-0.654),(-0.0661,-5.3969,-0.4812),(-0.066,-5.4391,-0.6981),(-0.066,-5.4693,-0.6954),(-0.0662,-5.4916,-0.6433),(-0.0661,-5.4894,-0.6762),(-0.0214,-4.5333,1.8425),(-0.0381,-4.685,0.1994),(0.7421,-3.2921,2.2036),(0.9478,-1.9978,2.313),(0.8963,1.4742,2.3363),(0.7965,2.7984,2.0989),(0.176,-4.4758,1.8754),(0.4211,-4.2059,1.9704),(0.7276,-3.3771,1.0007),(0.9669,0.0819,1.1936),(0.8784,1.565,0.8312),(0.8224,2.6702,0.6526),(0.6226,4.2615,0.6104),(0.601,4.2513,1.9478),(0.3365,5.0962,1.4711),(0.419,-4.3532,0.9263),(0.7082,-3.2888,0.0545),(0.9267,-1.7456,0.0753),(0.9602,-0.9419,0.2057),(0.9519,0.1172,0.1424),(0.869,1.5776,-0.0575),(0.8236,2.4785,-0.1428),(0.642,4.0923,-0.2176),(0.3301,5.2386,0.5324),(0.1333,-4.6633,0.2014),(0.3574,-4.4672,0.1981),(0.3609,5.1256,-0.2909),(0.0479,5.7705,-0.4556),(0.1713,5.5944,-0.3723),(0.1711,5.5876,0.6075),(0.0591,5.7589,0.5493),(0.0443,5.7943,0.0681),(0.1621,5.6189,0.2185),(0.0475,5.5887,1.8975),(0.0426,5.6743,1.2204),(0.1594,5.4967,1.3231),(0.1612,5.4161,1.9546),(0.3406,5.0346,2.0291),(0.99,0.0616,2.4545),(0.987,-0.9412,1.2779),(0.9529,-1.9008,1.2515),(1.0093,-0.953,2.4941),(0.963,-1.7257,2.4133),(-0.0089,5.7725,1.866),(-0.0092,5.8406,1.1619),(0.0123,5.9043,0.4963),(-0.0039,5.9452,-0.0499),(-0.0054,5.9371,-0.5324),(-0.0272,6.3929,0.9479),(-0.0147,6.4741,0.347),(-0.0185,6.5344,-0.3466),(-0.024,6.5362,-0.9984),(-0.0318,6.9667,0.6461),(-0.0516,7.2923,0.5142),(-0.014,7.1014,0.0702),(-0.042,7.4328,-0.1919),(-0.0174,7.2054,-0.6382),(-0.043,7.544,-0.9002),(-0.0214,7.2349,-1.2365),(-0.0452,7.5791,-1.4985),(-0.0352,6.3135,1.6032),(-0.0358,6.824,1.3523),(-0.0535,7.1913,1.1817),(0.1746,-4.536,0.918),(-0.0554,-4.6845,0.2229),(-0.0272,-4.5582,0.9145),(-0.0715,7.6286,-2.2037),(-0.0715,7.6847,-2.8938),(-0.0715,7.6861,-3.5483),(-0.0715,7.6598,-4.0121),(-0.0715,7.6339,-4.2758),(-0.0715,7.5985,-4.9559),(-0.0715,-5.8089,-7.834),(-0.0715,-6.0845,-7.1126),(-0.0715,-6.1809,-6.4826),(-0.0715,-6.1119,-5.6324),(-0.0715,-5.9586,-4.664),(-0.0715,-5.6653,-3.6743),(-0.0715,-5.4505,-2.9198),(-0.0715,-5.274,-2.2973),(-0.0715,-5.0638,-1.8061),(-0.0715,-4.8914,-1.3645),(-0.0715,-4.7371,-0.8239),(-0.0715,-4.8256,-1.0203),(-0.0715,-4.98,-1.3341),(-0.0715,-5.1703,-1.6919),(-0.0715,-5.4459,-2.3955),(-0.0715,-5.5813,-2.598),(-0.0715,-5.6457,-2.6329),(-0.0715,-5.6762,-2.5818),(-0.0715,-5.6669,-2.3743),(-0.0715,-5.5909,-1.8137),(-0.0715,-5.4754,-1.188),(-0.0715,-5.3822,-0.9709),(-0.0715,-5.2235,-0.7156),(-0.0715,-5.0033,-0.4686),(-0.0913,-4.8914,-1.3646),(-0.0747,-5.639,-2.6231),(-0.0744,-5.583,-2.5901),(-0.0748,-5.6651,-2.5754),(-0.0751,-5.656,-2.3705),(-0.0746,-5.4519,-2.3919),(-0.0757,-5.5804,-1.8139),(-0.0746,-5.1775,-1.687),(-0.0765,-5.465,-1.1905),(-0.0744,-4.9879,-1.3301),(-0.0766,-5.3739,-0.9741),(-0.0744,-4.8343,-1.0173),(-0.0766,-5.2153,-0.7187),(-0.0744,-4.7371,-0.8239),(-0.0766,-4.9954,-0.4618),(-0.1072,-4.6339,-0.402),(-0.1072,-4.6474,-0.3714),(-0.1039,7.5983,-4.9561),(-0.1042,7.1553,-4.7327),(-0.1014,7.6335,-4.2758),(-0.1014,7.1888,-4.1631),(-0.1016,7.6566,-3.9966),(-0.1014,7.2729,-3.8038),(-0.1002,7.6687,-3.5378),(-0.1002,7.305,-3.2878),(-0.0786,7.6676,-2.8818),(-0.0934,7.2965,-2.6214),(-0.0897,7.6131,-2.1892),(-0.1064,7.2364,-1.9271),(-0.1002,6.5246,-2.9131),(-0.1021,6.468,-3.4926),(-0.0934,6.5261,-2.2321),(-0.1049,6.5121,-1.6409),(-0.1275,5.5873,-3.3884),(-0.1158,5.5451,-3.8283),(-0.1018,6.2166,-3.9213),(-0.1178,5.3483,-4.2604),(-0.1071,6.0323,-4.3693),(-0.1426,4.8489,-4.2172),(-0.1336,5.2251,-3.7885),(-0.1194,5.7586,-2.7737),(-0.1107,5.8655,-2.1124),(-0.1173,5.8952,-1.3064),(-0.1529,-5.0664,-6.6139),(-0.1064,-5.777,-7.6761),(-0.1478,-5.2026,-5.8499),(-0.1068,-6.0145,-6.9156),(-0.1481,-5.2733,-5.1907),(-0.1155,-6.0755,-6.2519),(-0.1376,-5.2609,-4.493),(-0.1239,-5.9485,-5.3879),(-0.1354,-5.1202,-3.4588),(-0.1147,-5.7722,-4.4563),(-0.1099,-5.0595,-2.4292),(-0.1047,-5.3418,-2.9671),(-0.0938,-5.0637,-1.8064),(-0.0977,-5.274,-2.2976),(-0.1,-5.4505,-2.9203),(-0.0894,-5.6653,-3.6746),(-0.7635,2.7049,-3.1406),(-0.7098,2.2145,-3.7006),(-0.4687,3.5274,-3.9372),(-0.4676,3.9569,-3.476),(-0.9401,1.2742,-2.9676),(-0.8692,0.9644,-3.6623),(-0.9655,0.058,-2.9617),(-0.9027,0.0273,-3.6761),(-0.9123,-1.0637,-3.0711),(-0.8543,-0.9123,-3.7713),(-0.7534,-2.2389,-3.4278),(-0.734,-1.8153,-3.9911),(-0.1755,5.5755,-2.0429),(-0.1797,5.6798,-1.2498),(-0.2139,4.5245,-4.1631),(-0.1993,4.9213,-3.7242),(-0.192,5.1976,-3.2578),(-0.7638,-2.5623,-2.832),(-0.486,-3.5613,-2.3536),(-0.5241,-3.2342,-3.0589),(-0.4152,-2.8447,-4.2809),(-0.5481,-2.5497,-4.1701),(-0.3069,-3.9249,-2.1493),(-0.359,-3.6331,-2.7941),(-0.2046,-4.0467,-2.1712),(-0.2643,-4.1631,-1.6083),(-0.1773,-4.2446,-1.6877),(-0.1895,5.403,-2.6848),(-0.5361,4.4776,-2.4313),(-0.3285,5.0856,-2.5767),(-0.3204,5.2718,-1.9792),(-0.5313,4.6425,-1.9416),(-0.8459,3.3037,-2.0942),(-0.3144,4.8561,-3.1607),(-0.3032,4.5859,-3.6162),(-0.315,5.4617,-1.1829),(-0.3146,4.1721,-4.0618),(-0.4284,-3.9695,-1.4705),(-0.2482,-4.3103,-1.2071),(-0.1687,-4.3905,-1.2154),(-0.7827,-2.9467,-1.9169),(-0.4269,-4.3896,-0.4117),(-0.2301,-4.6076,-0.4007),(-0.9847,-1.4305,-1.9051),(-1.0106,-0.9828,-1.8956),(-0.5156,4.9145,-1.1117),(-0.4904,4.1873,-3.0925),(-0.9944,1.6852,-1.8353),(-1.0256,0.0912,-1.8411),(-0.5487,-2.9768,-3.555),(-0.4033,-3.3146,-3.5162),(-0.8206,3.7326,-0.9886),(-0.984,2.1939,-0.8667),(-1.0161,1.6229,-0.814),(-1.0675,0.0635,-0.7572),(-1.0652,-0.9529,-0.7824),(-1.0321,-1.6113,-0.8581),(-0.8124,-3.2008,-0.7733),(-0.1387,-4.624,-0.4086),(-0.2359,-3.7803,-2.7984),(-0.2786,-2.9708,-4.4265),(-0.2662,-3.4551,-3.5961),(-0.1039,-5.9586,-4.6643),(-0.1149,-6.1118,-5.6327),(-0.1074,-6.1809,-6.4828),(-0.0967,-6.0846,-7.1126),(-0.0984,-5.809,-7.834),(-0.1097,-4.8256,-1.9778),(-0.1391,-4.6514,-2.6096),(-0.1621,-4.5356,-3.3583),(-0.1714,-4.4165,-4.1348),(-0.1797,-4.2239,-4.8472),(-0.1863,-3.7716,-5.5548),(-0.1233,-4.6128,-1.5157),(-0.1499,-4.4208,-2.0537),(-0.1768,-4.2132,-2.585),(-0.2024,-3.9627,-3.2647),(-0.2161,-3.6854,-4.1002),(-0.2302,-3.196,-4.9083),(-0.1475,-4.4288,-1.2456),(0.0045,-4.4288,-1.2456),(0.0872,-3.196,-4.9083),(0.0731,-3.6854,-4.1002),(0.0594,-3.9627,-3.2647),(0.0337,-4.2132,-2.585),(0.0069,-4.4208,-2.0537),(-0.0197,-4.6128,-1.5157),(0.0433,-3.7716,-5.5548),(0.0367,-4.2239,-4.8472),(0.0283,-4.4165,-4.1348),(0.0191,-4.5356,-3.3583),(-0.0039,-4.6514,-2.6096),(-0.0333,-4.8256,-1.9778),(-0.0446,-5.809,-7.834),(-0.0463,-6.0846,-7.1126),(-0.0356,-6.1809,-6.4828),(-0.0282,-6.1118,-5.6327),(-0.0391,-5.9586,-4.6643),(0.1232,-3.4551,-3.5961),(0.1355,-2.9708,-4.4265),(0.0929,-3.7803,-2.7984),(-0.0043,-4.624,-0.4086),(0.6694,-3.2008,-0.7733),(0.8891,-1.6113,-0.8581),(0.9222,-0.9529,-0.7824),(0.9245,0.0635,-0.7572),(0.8731,1.6229,-0.814),(0.841,2.1939,-0.8667),(0.6776,3.7326,-0.9886),(0.2603,-3.3146,-3.5162),(0.4057,-2.9768,-3.555),(0.8825,0.0912,-1.8411),(0.8514,1.6852,-1.8353),(0.3474,4.1873,-3.0925),(0.3726,4.9145,-1.1117),(0.8676,-0.9828,-1.8956),(0.8417,-1.4305,-1.9051),(0.0871,-4.6076,-0.4007),(0.2839,-4.3896,-0.4117),(0.6396,-2.9467,-1.9169),(0.0257,-4.3905,-1.2154),(0.1052,-4.3103,-1.2071),(0.2854,-3.9695,-1.4705),(0.1715,4.1721,-4.0618),(0.172,5.4617,-1.1829),(0.1602,4.5859,-3.6162),(0.1714,4.8561,-3.1607),(0.7029,3.3037,-2.0942),(0.3883,4.6425,-1.9416),(0.1774,5.2718,-1.9792),(0.1855,5.0856,-2.5767),(0.3931,4.4776,-2.4313),(0.0465,5.403,-2.6848),(0.0343,-4.2446,-1.6877),(0.1213,-4.1631,-1.6083),(0.0616,-4.0467,-2.1712),(0.216,-3.6331,-2.7941),(0.1639,-3.9249,-2.1493),(0.405,-2.5497,-4.1701),(0.2722,-2.8447,-4.2809),(0.3811,-3.2342,-3.0589),(0.343,-3.5613,-2.3536),(0.6208,-2.5623,-2.832),(0.049,5.1976,-3.2578),(0.0563,4.9213,-3.7242),(0.0709,4.5245,-4.1631),(0.0367,5.6798,-1.2498),(0.0325,5.5755,-2.0429),(0.591,-1.8153,-3.9911),(0.6104,-2.2389,-3.4278),(0.7112,-0.9123,-3.7713),(0.7693,-1.0637,-3.0711),(0.7597,0.0273,-3.6761),(0.8224,0.058,-2.9617),(0.7262,0.9644,-3.6623),(0.7971,1.2742,-2.9676),(0.3246,3.9569,-3.476),(0.3257,3.5274,-3.9372),(0.5668,2.2145,-3.7006),(0.6205,2.7049,-3.1406),(-0.0536,-5.6653,-3.6746),(-0.043,-5.4505,-2.9203),(-0.0453,-5.274,-2.2976),(-0.0492,-5.0637,-1.8064),(-0.0383,-5.3418,-2.9671),(-0.0331,-5.0595,-2.4292),(-0.0283,-5.7722,-4.4563),(-0.0077,-5.1202,-3.4588),(-0.0192,-5.9485,-5.3879),(-0.0054,-5.2609,-4.493),(-0.0275,-6.0755,-6.2519),(0.0051,-5.2733,-5.1907),(-0.0362,-6.0145,-6.9156),(0.0048,-5.2026,-5.8499),(-0.0366,-5.777,-7.6761),(0.0099,-5.0664,-6.6139),(-0.0257,5.8952,-1.3064),(-0.0323,5.8655,-2.1124),(-0.0236,5.7586,-2.7737),(-0.0095,5.2251,-3.7885),(-5.0E-4,4.8489,-4.2172),(-0.0359,6.0323,-4.3693),(-0.0253,5.3483,-4.2604),(-0.0412,6.2166,-3.9213),(-0.0272,5.5451,-3.8283),(-0.0156,5.5873,-3.3884),(-0.0381,6.5121,-1.6409),(-0.0496,6.5261,-2.2321),(-0.0409,6.468,-3.4926),(-0.0428,6.5246,-2.9131),(-0.0366,7.2364,-1.9271),(-0.0534,7.6131,-2.1892),(-0.0496,7.2965,-2.6214),(-0.0644,7.6676,-2.8818),(-0.0428,7.305,-3.2878),(-0.0428,7.6687,-3.5378),(-0.0416,7.2729,-3.8038),(-0.0415,7.6566,-3.9966),(-0.0416,7.1888,-4.1631),(-0.0416,7.6335,-4.2758),(-0.0388,7.1553,-4.7327),(-0.0391,7.5983,-4.9561),(-0.0358,-4.6474,-0.3714),(-0.0358,-4.6339,-0.402),(-0.0664,-4.9954,-0.4618),(-0.0686,-4.7371,-0.8239),(-0.0664,-5.2153,-0.7187),(-0.0686,-4.8343,-1.0173),(-0.0664,-5.3739,-0.9741),(-0.0686,-4.9879,-1.3301),(-0.0665,-5.465,-1.1905),(-0.0685,-5.1775,-1.687),(-0.0674,-5.5804,-1.8139),(-0.0685,-5.4519,-2.3919),(-0.0679,-5.656,-2.3705),(-0.0682,-5.6651,-2.5754),(-0.0686,-5.583,-2.5901),(-0.0683,-5.639,-2.6231),(-0.0517,-4.8914,-1.3646),(-0.0715,7.5377,-5.7513),(-0.0715,7.4555,-6.2422),(-0.0715,7.3576,-6.6821),(-0.0715,7.1806,-7.1328),(-0.0715,6.6702,-7.5648),(-0.0715,5.8851,-7.7266),(-0.0715,4.6015,-7.614),(-0.0715,4.1499,-7.5444),(-0.0715,3.7538,-7.4676),(-0.0715,3.3838,-7.3795),(-0.0715,2.3802,-7.0049),(-0.0715,1.4855,-6.6869),(-0.0715,-0.62,-6.4637),(-0.0715,-0.6356,-6.4649),(-0.0715,-1.1516,-7.1507),(-0.0715,-1.4363,-7.4166),(-0.0715,-1.7563,-7.7379),(-0.0715,-2.5385,-8.3478),(-0.0715,-3.5868,-9.0052),(-0.0715,-4.1318,-9.0831),(-0.0715,-4.7519,-8.9741),(-0.0715,-5.0529,-8.8234),(-0.0715,-5.4233,-8.4677),(-0.1391,1.494,-6.2515),(-0.0916,1.5046,-6.643),(-0.1164,1.6538,-6.2973),(-0.1018,2.3987,-6.9179),(-0.1176,2.4965,-6.4921),(-0.1083,7.1809,-7.1328),(-0.1083,7.0099,-7.0407),(-0.1085,6.3739,-7.4661),(-0.1088,6.6707,-7.5649),(-0.1054,5.5298,-7.5879),(-0.1054,5.8856,-7.7267),(-0.1041,4.4585,-7.4543),(-0.1036,4.6018,-7.6138),(-0.1039,4.1104,-7.4318),(-0.1036,4.1502,-7.5442),(-0.1045,3.7818,-7.3301),(-0.1038,3.7541,-7.4673),(-0.1061,3.481,-7.2524),(-0.1038,3.3838,-7.3791),(-0.0981,2.3802,-7.0046),(-0.0898,1.4855,-6.6869),(-0.1131,7.3579,-6.6819),(-0.1131,7.2053,-6.5438),(-0.1201,7.4555,-6.2422),(-0.1201,7.2328,-6.0021),(-0.1146,7.5377,-5.7513),(-0.1146,7.192,-5.3913),(-0.1164,5.9241,-4.7943),(-0.125,5.6866,-5.1926),(-0.1088,3.8806,-6.875),(-0.1272,5.022,-4.6382),(-0.1409,4.5716,-4.9594),(-0.1442,4.0652,-5.2796),(-0.1193,5.4459,-5.6506),(-0.1406,3.5113,-5.6113),(-0.1125,5.0289,-6.0501),(-0.1405,2.9625,-5.9922),(-0.111,4.4322,-6.4403),(-0.155,2.2447,-5.8237),(-0.1712,2.784,-5.4783),(-0.1808,3.2938,-5.1871),(-0.1734,3.877,-4.8897),(-0.1546,4.3948,-4.581),(-0.116,-0.6033,-6.4293),(-0.0897,-0.62,-6.4638),(-0.0845,-1.4365,-7.4167),(-0.0838,-1.7564,-7.7382),(-0.0908,-1.6721,-7.3896),(-0.0883,-2.4631,-8.1782),(-0.1093,-2.2255,-7.4677),(-0.1005,-3.4674,-8.814),(-0.1222,-2.9863,-7.6706),(-0.1082,-4.0641,-8.9418),(-0.1453,-3.9246,-7.8632),(-0.1093,-4.7217,-8.8508),(-0.1525,-4.3572,-7.7178),(-0.1072,-5.0393,-8.7087),(-0.1513,-4.7701,-7.2907),(-0.1053,-5.4125,-8.3354),(-0.3826,-1.7481,-5.1177),(-0.337,-1.4163,-5.3512),(-0.4504,-1.2451,-5.249),(-0.4849,-1.5344,-4.9972),(-0.6138,-0.3313,-5.5459),(-0.6597,-0.464,-5.2307),(-0.5651,-0.726,-5.3336),(-0.5294,-0.545,-5.6261),(-0.6633,0.2014,-5.4109),(-0.7171,0.1336,-5.0771),(-0.7792,-0.7289,-4.5953),(-0.7094,-0.5968,-4.9142),(-0.7677,0.0663,-4.7447),(-0.8275,-5.0E-4,-4.4126),(-0.6611,-1.0788,-4.7494),(-0.6046,-0.8936,-5.0581),(-0.2365,2.7603,-5.1343),(-0.2209,2.2443,-5.3954),(-0.7057,0.3539,-5.0695),(-0.5446,0.9605,-5.4656),(-0.6029,1.1281,-5.0962),(-0.3634,1.338,-5.6914),(-0.4145,1.6816,-5.2668),(-0.2673,1.588,-5.6766),(-0.3079,1.9744,-5.338),(-0.1873,1.8339,-5.719),(-0.3283,3.0788,-4.7579),(-0.3272,2.4552,-5.068),(-0.2445,3.4386,-4.8424),(-0.4411,2.565,-4.6402),(-0.4442,2.0824,-4.9645),(-0.6656,1.6053,-4.4472),(-0.6354,1.3672,-4.7623),(-0.7919,0.6543,-4.386),(-0.7532,0.5047,-4.7271),(-0.227,4.0009,-4.5532),(-0.6996,-1.3112,-4.4711),(-0.5507,-2.1021,-4.5579),(-0.531,-1.7646,-4.8145),(-0.4255,-2.3957,-4.6648),(-0.424,-2.0281,-4.9177),(-0.3605,-0.7126,-5.7824),(-0.4126,-0.98,-5.484),(-0.292,-1.1203,-5.5712),(-0.2431,-0.8385,-5.8418),(-0.3265,3.5795,-4.4885),(-0.4454,2.9246,-4.4038),(-0.2002,1.3791,-6.2274),(-0.2862,1.247,-6.2149),(-0.3251,1.1871,-6.2015),(-0.4352,0.8501,-6.1867),(-0.5127,0.3078,-6.2048),(-0.4791,0.076,-6.2547),(-0.1956,-0.5342,-6.4069),(-0.2535,-0.4367,-6.381),(-0.4161,-0.2009,-6.3246),(-0.2884,-2.4951,-4.8339),(-0.2797,-1.8295,-5.2642),(-0.2894,-2.1194,-5.0774),(-0.2262,-1.4791,-5.483),(-0.1923,-1.144,-5.716),(-0.1732,-0.885,-5.8938),(-0.0981,-5.4236,-8.4676),(-0.1005,-5.0532,-8.8231),(-0.1016,-4.7522,-8.9739),(-0.1021,-4.1321,-9.0831),(-0.0969,-3.5872,-9.0055),(-0.08,-2.5386,-8.348),(-0.1892,-3.346,-6.0366),(-0.1811,-2.992,-6.3192),(-0.1575,-2.6818,-6.4574),(-0.1345,-2.1062,-6.5357),(-0.1126,-1.6391,-6.6733),(-0.0915,-1.283,-6.9344),(-0.0834,-1.1516,-7.1507),(-0.2377,-2.6796,-5.3254),(-0.2385,-2.3166,-5.5775),(-0.232,-2.0409,-5.759),(-0.1769,-1.6693,-5.95),(-0.1467,-1.3096,-6.1907),(-0.106,-1.0339,-6.4972),(-0.0933,-0.8271,-6.88),(-0.1416,-0.9112,-6.0202),(-0.0906,-0.6356,-6.465),(-0.0524,-0.6356,-6.465),(-0.0014,-0.9112,-6.0202),(-0.0498,-0.8271,-6.88),(-0.037,-1.0339,-6.4972),(0.0037,-1.3096,-6.1907),(0.0339,-1.6693,-5.95),(0.089,-2.0409,-5.759),(0.0955,-2.3166,-5.5775),(0.0947,-2.6796,-5.3254),(-0.0596,-1.1516,-7.1507),(-0.0516,-1.283,-6.9344),(-0.0304,-1.6391,-6.6733),(-0.0085,-2.1062,-6.5357),(0.0145,-2.6818,-6.4574),(0.038,-2.992,-6.3192),(0.0462,-3.346,-6.0366),(-0.0631,-2.5386,-8.348),(-0.0462,-3.5872,-9.0055),(-0.0409,-4.1321,-9.0831),(-0.0415,-4.7522,-8.9739),(-0.0426,-5.0532,-8.8231),(-0.0449,-5.4236,-8.4676),(0.0301,-0.885,-5.8938),(0.0493,-1.144,-5.716),(0.0832,-1.4791,-5.483),(0.1463,-2.1194,-5.0774),(0.1366,-1.8295,-5.2642),(0.1454,-2.4951,-4.8339),(0.2731,-0.2009,-6.3246),(0.1105,-0.4367,-6.381),(0.0526,-0.5342,-6.4069),(0.3361,0.076,-6.2547),(0.3697,0.3078,-6.2048),(0.2922,0.8501,-6.1867),(0.1821,1.1871,-6.2015),(0.1431,1.247,-6.2149),(0.0571,1.3791,-6.2274),(0.3024,2.9246,-4.4038),(0.1835,3.5795,-4.4885),(0.1001,-0.8385,-5.8418),(0.149,-1.1203,-5.5712),(0.2696,-0.98,-5.484),(0.2175,-0.7126,-5.7824),(0.2809,-2.0281,-4.9177),(0.2825,-2.3957,-4.6648),(0.388,-1.7646,-4.8145),(0.4077,-2.1021,-4.5579),(0.5565,-1.3112,-4.4711),(0.084,4.0009,-4.5532),(0.6101,0.5047,-4.7271),(0.6489,0.6543,-4.386),(0.4924,1.3672,-4.7623),(0.5226,1.6053,-4.4472),(0.3012,2.0824,-4.9645),(0.2981,2.565,-4.6402),(0.1015,3.4386,-4.8424),(0.1841,2.4552,-5.068),(0.1853,3.0788,-4.7579),(0.0443,1.8339,-5.719),(0.1649,1.9744,-5.338),(0.1243,1.588,-5.6766),(0.2715,1.6816,-5.2668),(0.2204,1.338,-5.6914),(0.4599,1.1281,-5.0962),(0.4016,0.9605,-5.4656),(0.5626,0.3539,-5.0695),(0.0779,2.2443,-5.3954),(0.0934,2.7603,-5.1343),(0.4615,-0.8936,-5.0581),(0.518,-1.0788,-4.7494),(0.6845,-5.0E-4,-4.4126),(0.6247,0.0663,-4.7447),(0.5664,-0.5968,-4.9142),(0.6362,-0.7289,-4.5953),(0.5741,0.1336,-5.0771),(0.5203,0.2014,-5.4109),(0.3863,-0.545,-5.6261),(0.4221,-0.726,-5.3336),(0.5167,-0.464,-5.2307),(0.4708,-0.3313,-5.5459),(0.3419,-1.5344,-4.9972),(0.3074,-1.2451,-5.249),(0.194,-1.4163,-5.3512),(0.2395,-1.7481,-5.1177),(-0.0377,-5.4125,-8.3354),(0.0083,-4.7701,-7.2907),(-0.0358,-5.0393,-8.7087),(0.0095,-4.3572,-7.7178),(-0.0337,-4.7217,-8.8508),(0.0023,-3.9246,-7.8632),(-0.0348,-4.0641,-8.9418),(-0.0208,-2.9863,-7.6706),(-0.0426,-3.4674,-8.814),(-0.0337,-2.2255,-7.4677),(-0.0548,-2.4631,-8.1782),(-0.0523,-1.6721,-7.3896),(-0.0592,-1.7564,-7.7382),(-0.0585,-1.4365,-7.4167),(-0.0534,-0.62,-6.4638),(-0.0271,-0.6033,-6.4293),(0.0116,4.3948,-4.581),(0.0304,3.877,-4.8897),(0.0378,3.2938,-5.1871),(0.0282,2.784,-5.4783),(0.012,2.2447,-5.8237),(-0.032,4.4322,-6.4403),(-0.0025,2.9625,-5.9922),(-0.0305,5.0289,-6.0501),(-0.0024,3.5113,-5.6113),(-0.0237,5.4459,-5.6506),(0.0012,4.0652,-5.2796),(-0.0021,4.5716,-4.9594),(-0.0158,5.022,-4.6382),(-0.0343,3.8806,-6.875),(-0.0181,5.6866,-5.1926),(-0.0266,5.9241,-4.7943),(-0.0284,7.192,-5.3913),(-0.0284,7.5377,-5.7513),(-0.0229,7.2328,-6.0021),(-0.0229,7.4555,-6.2422),(-0.03,7.2053,-6.5438),(-0.03,7.3579,-6.6819),(-0.0532,1.4855,-6.6869),(-0.0449,2.3802,-7.0046),(-0.0392,3.3838,-7.3791),(-0.0369,3.481,-7.2524),(-0.0392,3.7541,-7.4673),(-0.0385,3.7818,-7.3301),(-0.0394,4.1502,-7.5442),(-0.0391,4.1104,-7.4318),(-0.0394,4.6018,-7.6138),(-0.039,4.4585,-7.4543),(-0.0376,5.8856,-7.7267),(-0.0376,5.5298,-7.5879),(-0.0343,6.6707,-7.5649),(-0.0345,6.3739,-7.4661),(-0.0347,7.0099,-7.0407),(-0.0347,7.1809,-7.1328),(-0.0254,2.4965,-6.4921),(-0.0412,2.3987,-6.9179),(-0.0266,1.6538,-6.2973),(-0.0514,1.5046,-6.643),(-0.0039,1.494,-6.2515),(-0.0715,1.4676,-6.6913),(-0.0715,1.5514,-6.9877),(-0.0715,1.6786,-7.1409),(-0.0715,2.1705,-7.5076),(-0.0715,2.5933,-7.7415),(-0.0715,3.6599,-8.551),(-0.0715,3.8934,-8.7796),(-0.0715,3.9573,-8.8418),(-0.0715,3.9571,-8.9869),(-0.0715,3.6338,-9.1457),(-0.0715,2.9806,-9.2893),(-0.0715,2.4947,-9.4027),(-0.0715,2.001,-9.3913),(-0.0715,1.6937,-9.38),(-0.0715,1.3328,-9.3591),(-0.0715,0.9027,-9.353),(-0.0715,0.5844,-9.411),(-0.0715,0.3061,-9.5178),(-0.0715,0.0909,-9.6153),(-0.0715,-0.2489,-9.7588),(-0.0715,-0.4826,-9.8328),(-0.0715,-0.5975,-9.8655),(-0.0715,-0.8107,-9.9172),(-0.0715,-1.0592,-9.9569),(-0.0715,-1.2094,-9.9758),(-0.0715,-1.4231,-9.9997),(-0.0715,-1.7528,-9.9593),(-0.0715,-1.9794,-9.8565),(-0.0715,-2.2944,-9.5786),(-0.0715,-2.3442,-9.2396),(-0.0715,-2.3011,-9.1713),(-0.0715,-2.1619,-8.8896),(-0.0715,-1.4472,-8.1505),(-0.0715,-1.0979,-7.7027),(-0.0715,-0.6179,-7.0963),(-0.0715,-0.4806,-6.9333),(-0.0905,1.4676,-6.6913),(-0.1121,1.4391,-6.6639),(-0.1207,1.5089,-6.9934),(-0.1007,1.5513,-6.9876),(-0.0809,-0.4806,-6.933),(-0.1248,-0.4205,-6.9809),(-0.2576,-0.117,-7.4733),(-0.2497,-0.1632,-7.3967),(-0.2092,-0.2397,-7.4312),(-0.2201,-0.173,-7.5407),(-0.2178,1.2768,-7.2657),(-0.2056,1.3382,-7.1222),(-0.2459,1.1893,-7.1356),(-0.2522,1.1493,-7.2371),(-0.2034,-0.261,-7.2569),(-0.2488,-0.1782,-7.2593),(-0.2924,-0.0484,-7.3248),(-0.2671,-0.0070,-7.5334),(-0.3504,0.4913,-7.2263),(-0.3402,0.2056,-7.2666),(-0.2851,0.2143,-7.5521),(-0.2961,0.5032,-7.5296),(-0.2963,0.9577,-7.1777),(-0.2831,0.8371,-7.4533),(-0.2665,1.0367,-7.3558),(-0.2086,1.3314,-6.9595),(-0.2543,1.1898,-6.9967),(-0.2349,1.115,-7.4353),(-0.1696,1.3987,-7.3055),(-0.1514,1.5038,-7.1227),(-0.2527,0.8475,-7.5728),(-0.2574,0.5116,-7.663),(-0.2464,0.2088,-7.6785),(-0.234,-0.0192,-7.634),(-0.1439,-0.3369,-7.4533),(-0.1457,-0.2639,-7.5948),(-0.1763,1.222,-7.5154),(-0.1849,0.9065,-7.6929),(-0.1902,0.5172,-7.8047),(-0.1768,0.1913,-7.8123),(-0.1651,-0.0519,-7.7386),(-0.1331,-0.3806,-7.2662),(-0.2306,-0.2523,-6.9451),(-0.2607,-0.2028,-6.9341),(-0.2669,1.236,-6.6646),(-0.1646,1.3848,-6.6593),(-0.2992,1.172,-6.6696),(-0.4046,0.8516,-6.7071),(-0.4497,0.3859,-6.7863),(-0.4352,0.2059,-6.8352),(-0.3892,0.0056,-6.8801),(-0.0933,-0.4971,-7.2712),(-0.1057,1.5626,-7.1225),(-0.11,-0.3991,-7.577),(-0.111,-0.3453,-7.6368),(-0.1341,-0.0045,-7.8591),(-0.1327,-0.0689,-7.8264),(-0.1265,-0.1477,-7.7734),(-0.136,0.1789,-7.9175),(-0.1408,0.2678,-7.9282),(-0.1354,0.1006,-7.8947),(-0.1507,0.5116,-7.9177),(-0.1518,0.6244,-7.893),(-0.146,0.4139,-7.9268),(-0.1491,0.8274,-7.8344),(-0.147,0.9523,-7.789),(-0.1413,1.0718,-7.7347),(-0.119,-0.2714,-7.69),(-0.1387,1.2591,-7.6378),(-0.1345,1.3724,-7.5516),(-0.1041,-0.4564,-7.4656),(-0.1261,1.5023,-7.372),(-0.0865,-1.4473,-8.1503),(-0.0819,-1.0979,-7.7023),(-0.0856,-2.2946,-9.5787),(-0.0855,-2.2563,-9.5045),(-0.0834,-2.3011,-9.1714),(-0.0836,-2.3443,-9.2397),(-0.0894,-1.9795,-9.8567),(-0.0894,-1.9519,-9.7743),(-0.0938,-1.7529,-9.9594),(-0.0937,-1.7323,-9.8752),(-0.0928,-1.4231,-10.0),(-0.0928,-1.4091,-9.9129),(-0.0962,-1.2094,-9.9759),(-0.0963,-1.1977,-9.8845),(-0.0973,-1.0592,-9.9572),(-0.0973,-1.0469,-9.8608),(-0.0974,-0.8107,-9.9173),(-0.0974,-0.7975,-9.8094),(-0.097,-0.5977,-9.8658),(-0.097,-0.5824,-9.747),(-0.0973,-0.4827,-9.8331),(-0.0973,-0.4693,-9.7112),(-0.0903,-0.2489,-9.759),(-0.0903,-0.2392,-9.6316),(-0.0969,0.0908,-9.6158),(-0.0969,0.0956,-9.4865),(-0.0964,0.3061,-9.5185),(-0.0964,0.3082,-9.3919),(-0.097,0.5842,-9.4118),(-0.097,0.5832,-9.2895),(-0.0964,0.9027,-9.3538),(-0.0966,0.8979,-9.2336),(-0.096,1.3326,-9.36),(-0.096,1.3226,-9.2389),(-0.0962,1.6937,-9.3807),(-0.0962,1.6793,-9.2592),(-0.0957,2.001,-9.392),(-0.0957,1.9832,-9.2679),(-0.0951,2.4945,-9.4034),(-0.0951,2.4671,-9.2823),(-0.0948,2.9804,-9.2902),(-0.0948,2.947,-9.2013),(-0.0944,3.6333,-9.1472),(-0.0944,3.595,-9.08),(-0.0934,3.9569,-8.9883),(-0.0934,3.9056,-8.9277),(-0.0921,3.9573,-8.8432),(-0.0921,3.8934,-8.781),(-0.1,3.6601,-8.5529),(-0.083,-2.162,-8.8897),(-0.087,-2.1167,-9.2516),(-0.0941,-1.8529,-9.5127),(-0.1024,-1.6642,-9.6172),(-0.1024,-1.3729,-9.6643),(-0.1068,-1.1718,-9.6344),(-0.1083,-1.0124,-9.6045),(-0.1106,-0.7641,-9.5423),(-0.1097,-0.5506,-9.4708),(-0.1103,-0.4352,-9.4323),(-0.0973,-0.2103,-9.36),(-0.1092,0.1128,-9.2373),(-0.1085,0.3194,-9.1573),(-0.1099,0.5902,-9.0714),(-0.1089,0.8973,-9.0194),(-0.1075,1.3154,-9.0173),(-0.1077,1.665,-9.0231),(-0.1065,1.9639,-9.0198),(-0.1054,2.4261,-9.0238),(-0.1049,2.8708,-8.9921),(-0.1039,3.4647,-8.8983),(-0.1023,3.7084,-8.7241),(-0.1083,2.5931,-7.7415),(-0.0915,-1.4093,-8.5313),(-0.0993,-1.2526,-8.7228),(-0.1083,-1.1415,-8.7915),(-0.1097,-0.9573,-8.8266),(-0.1144,-0.8141,-8.8048),(-0.1155,-0.6759,-8.7949),(-0.118,-0.4804,-8.7859),(-0.1269,-0.3165,-8.7654),(-0.1273,-0.2203,-8.7523),(-0.1137,-0.0474,-8.7375),(-0.1251,0.1866,-8.701),(-0.1243,0.3388,-8.6705),(-0.1258,0.5418,-8.6305),(-0.1244,0.7679,-8.5849),(-0.1222,1.0752,-8.5391),(-0.1208,1.3275,-8.5044),(-0.1182,1.5492,-8.4653),(-0.1157,1.8736,-8.4058),(-0.1147,2.1198,-8.3329),(-0.1133,2.4404,-8.1525),(-0.111,2.6005,-7.9081),(-0.1054,2.1705,-7.5073),(-0.0874,-1.0944,-8.0278),(-0.0962,-0.9782,-8.1937),(-0.1063,-0.895,-8.2657),(-0.107,-0.7526,-8.3258),(-0.1107,-0.631,-8.3347),(-0.114,-0.4953,-8.3572),(-0.1171,-0.325,-8.3884),(-0.1183,-0.193,-8.3999),(-0.12,-0.112,-8.4053),(-0.1083,0.0328,-8.4186),(-0.1319,0.2236,-8.4096),(-0.1306,0.3499,-8.3943),(-0.1262,0.5212,-8.3714),(-0.1262,0.7089,-8.3366),(-0.125,0.9664,-8.2826),(-0.1237,1.1752,-8.2294),(-0.12,1.3588,-8.178),(-0.1168,1.6291,-8.1019),(-0.1142,1.8182,-8.0268),(-0.1119,2.0637,-7.8498),(-0.1086,2.1778,-7.6354),(-0.0852,-0.7017,-7.482),(-0.0826,-0.6179,-7.096),(-0.0953,-0.6539,-7.6876),(-0.1023,-0.5841,-7.7957),(-0.1046,-0.4927,-7.8693),(-0.1099,-0.388,-7.9221),(-0.1143,-0.2661,-7.9833),(-0.1191,-0.1501,-8.0411),(-0.1208,-0.058,-8.0779),(-0.1207,0.0282,-8.1039),(-0.118,0.1368,-8.1271),(-0.1241,0.2629,-8.1354),(-0.1276,0.3841,-8.1312),(-0.1315,0.5161,-8.1161),(-0.1326,0.6676,-8.085),(-0.1322,0.8591,-8.0329),(-0.1294,1.027,-7.9768),(-0.125,1.1878,-7.9134),(-0.1216,1.3797,-7.8297),(-0.1179,1.5332,-7.732),(-0.1124,1.6772,-7.5541),(-0.1053,1.6896,-7.2946),(-0.1002,1.6786,-7.1407),(-0.0428,1.6786,-7.1407),(-0.0377,1.6896,-7.2946),(-0.0307,1.6772,-7.5541),(-0.0251,1.5332,-7.732),(-0.0214,1.3797,-7.8297),(-0.0181,1.1878,-7.9134),(-0.0136,1.027,-7.9768),(-0.0109,0.8591,-8.0329),(-0.0104,0.6676,-8.085),(-0.0115,0.5161,-8.1161),(-0.0154,0.3841,-8.1312),(-0.0189,0.2629,-8.1354),(-0.025,0.1368,-8.1271),(-0.0223,0.0282,-8.1039),(-0.0222,-0.058,-8.0779),(-0.0239,-0.1501,-8.0411),(-0.0287,-0.2661,-7.9833),(-0.0331,-0.388,-7.9221),(-0.0384,-0.4927,-7.8693),(-0.0408,-0.5841,-7.7957),(-0.0477,-0.6539,-7.6876),(-0.0604,-0.6179,-7.096),(-0.0578,-0.7017,-7.482),(-0.0344,2.1778,-7.6354),(-0.0311,2.0637,-7.8498),(-0.0289,1.8182,-8.0268),(-0.0262,1.6291,-8.1019),(-0.023,1.3588,-8.178),(-0.0193,1.1752,-8.2294),(-0.0181,0.9664,-8.2826),(-0.0168,0.7089,-8.3366),(-0.0168,0.5212,-8.3714),(-0.0124,0.3499,-8.3943),(-0.0111,0.2236,-8.4096),(-0.0347,0.0328,-8.4186),(-0.023,-0.112,-8.4053),(-0.0247,-0.193,-8.3999),(-0.0259,-0.325,-8.3884),(-0.029,-0.4953,-8.3572),(-0.0323,-0.631,-8.3347),(-0.0361,-0.7526,-8.3258),(-0.0367,-0.895,-8.2657),(-0.0469,-0.9782,-8.1937),(-0.0556,-1.0944,-8.0278),(-0.0376,2.1705,-7.5073),(-0.032,2.6005,-7.9081),(-0.0297,2.4404,-8.1525),(-0.0283,2.1198,-8.3329),(-0.0273,1.8736,-8.4058),(-0.0248,1.5492,-8.4653),(-0.0222,1.3275,-8.5044),(-0.0208,1.0752,-8.5391),(-0.0186,0.7679,-8.5849),(-0.0172,0.5418,-8.6305),(-0.0187,0.3388,-8.6705),(-0.0179,0.1866,-8.701),(-0.0293,-0.0474,-8.7375),(-0.0157,-0.2203,-8.7523),(-0.0161,-0.3165,-8.7654),(-0.025,-0.4804,-8.7859),(-0.0275,-0.6759,-8.7949),(-0.0286,-0.8141,-8.8048),(-0.0333,-0.9573,-8.8266),(-0.0347,-1.1415,-8.7915),(-0.0437,-1.2526,-8.7228),(-0.0516,-1.4093,-8.5313),(-0.0347,2.5931,-7.7415),(-0.0408,3.7084,-8.7241),(-0.0391,3.4647,-8.8983),(-0.0381,2.8708,-8.9921),(-0.0376,2.4261,-9.0238),(-0.0365,1.9639,-9.0198),(-0.0354,1.665,-9.0231),(-0.0355,1.3154,-9.0173),(-0.0341,0.8973,-9.0194),(-0.0331,0.5902,-9.0714),(-0.0345,0.3194,-9.1573),(-0.0338,0.1128,-9.2373),(-0.0458,-0.2103,-9.36),(-0.0327,-0.4352,-9.4323),(-0.0333,-0.5506,-9.4708),(-0.0325,-0.7641,-9.5423),(-0.0347,-1.0124,-9.6045),(-0.0362,-1.1718,-9.6344),(-0.0406,-1.3729,-9.6643),(-0.0406,-1.6642,-9.6172),(-0.0489,-1.8529,-9.5127),(-0.056,-2.1167,-9.2516),(-0.06,-2.162,-8.8897),(-0.043,3.6601,-8.5529),(-0.0509,3.8934,-8.781),(-0.0509,3.9573,-8.8432),(-0.0496,3.9056,-8.9277),(-0.0496,3.9569,-8.9883),(-0.0487,3.595,-9.08),(-0.0487,3.6333,-9.1472),(-0.0482,2.947,-9.2013),(-0.0482,2.9804,-9.2902),(-0.048,2.4671,-9.2823),(-0.048,2.4945,-9.4034),(-0.0473,1.9832,-9.2679),(-0.0473,2.001,-9.392),(-0.0469,1.6793,-9.2592),(-0.0469,1.6937,-9.3807),(-0.047,1.3226,-9.2389),(-0.047,1.3326,-9.36),(-0.0464,0.8979,-9.2336),(-0.0466,0.9027,-9.3538),(-0.046,0.5832,-9.2895),(-0.046,0.5842,-9.4118),(-0.0466,0.3082,-9.3919),(-0.0466,0.3061,-9.5185),(-0.0462,0.0956,-9.4865),(-0.0462,0.0908,-9.6158),(-0.0527,-0.2392,-9.6316),(-0.0527,-0.2489,-9.759),(-0.0458,-0.4693,-9.7112),(-0.0458,-0.4827,-9.8331),(-0.046,-0.5824,-9.747),(-0.046,-0.5977,-9.8658),(-0.0456,-0.7975,-9.8094),(-0.0456,-0.8107,-9.9173),(-0.0458,-1.0469,-9.8608),(-0.0458,-1.0592,-9.9572),(-0.0467,-1.1977,-9.8845),(-0.0469,-1.2094,-9.9759),(-0.0502,-1.4091,-9.9129),(-0.0502,-1.4231,-10.0),(-0.0494,-1.7323,-9.8752),(-0.0492,-1.7529,-9.9594),(-0.0536,-1.9519,-9.7743),(-0.0536,-1.9795,-9.8567),(-0.0595,-2.3443,-9.2397),(-0.0596,-2.3011,-9.1714),(-0.0575,-2.2563,-9.5045),(-0.0574,-2.2946,-9.5787),(-0.0611,-1.0979,-7.7023),(-0.0566,-1.4473,-8.1503),(-0.0169,1.5023,-7.372),(-0.039,-0.4564,-7.4656),(-0.0085,1.3724,-7.5516),(-0.0043,1.2591,-7.6378),(-0.024,-0.2714,-7.69),(-0.0017,1.0718,-7.7347),(0.0040,0.9523,-7.789),(0.0060,0.8274,-7.8344),(0.0030,0.4139,-7.9268),(0.0088,0.6244,-7.893),(0.0077,0.5116,-7.9177),(-0.0077,0.1006,-7.8947),(-0.0023,0.2678,-7.9282),(-0.0070,0.1789,-7.9175),(-0.0165,-0.1477,-7.7734),(-0.0103,-0.0689,-7.8264),(-0.0089,-0.0045,-7.8591),(-0.032,-0.3453,-7.6368),(-0.033,-0.3991,-7.577),(-0.0373,1.5626,-7.1225),(-0.0498,-0.4971,-7.2712),(0.2462,0.0056,-6.8801),(0.2922,0.2059,-6.8352),(0.3067,0.3859,-6.7863),(0.2616,0.8516,-6.7071),(0.1562,1.172,-6.6696),(0.0216,1.3848,-6.6593),(0.1239,1.236,-6.6646),(0.1177,-0.2028,-6.9341),(0.0876,-0.2523,-6.9451),(-0.0099,-0.3806,-7.2662),(0.0221,-0.0519,-7.7386),(0.0337,0.1913,-7.8123),(0.0472,0.5172,-7.8047),(0.0419,0.9065,-7.6929),(0.0333,1.222,-7.5154),(0.0027,-0.2639,-7.5948),(9.0E-4,-0.3369,-7.4533),(0.0909,-0.0192,-7.634),(0.1034,0.2088,-7.6785),(0.1143,0.5116,-7.663),(0.1096,0.8475,-7.5728),(0.0084,1.5038,-7.1227),(0.0265,1.3987,-7.3055),(0.0919,1.115,-7.4353),(0.1113,1.1898,-6.9967),(0.0656,1.3314,-6.9595),(0.1235,1.0367,-7.3558),(0.1401,0.8371,-7.4533),(0.1533,0.9577,-7.1777),(0.1531,0.5032,-7.5296),(0.142,0.2143,-7.5521),(0.1972,0.2056,-7.2666),(0.2074,0.4913,-7.2263),(0.124,-0.0070,-7.5334),(0.1494,-0.0484,-7.3248),(0.1058,-0.1782,-7.2593),(0.0603,-0.261,-7.2569),(0.1092,1.1493,-7.2371),(0.1028,1.1893,-7.1356),(0.0625,1.3382,-7.1222),(0.0747,1.2768,-7.2657),(0.0771,-0.173,-7.5407),(0.0661,-0.2397,-7.4312),(0.1067,-0.1632,-7.3967),(0.1146,-0.117,-7.4733),(-0.0182,-0.4205,-6.9809),(-0.0621,-0.4806,-6.933),(-0.0423,1.5513,-6.9876),(-0.0223,1.5089,-6.9934),(-0.0309,1.4391,-6.6639),(-0.0525,1.4676,-6.6913),(-0.0715,-4.0463,6.9109),(-0.0715,-3.809,7.5494),(-0.0715,-3.528,8.1598),(-0.0715,-3.3244,8.4823),(-0.0724,-2.986,8.804),(-0.0765,-2.8854,9.1224),(-0.0777,-2.8823,9.38),(-0.0768,-2.8376,9.5901),(-0.0756,-2.7681,9.7545),(-0.0749,-2.7053,9.848),(-0.0744,-2.5836,9.9398),(-0.0744,-2.539,9.9632),(-0.0747,-2.4315,9.9757),(-0.0751,-2.3946,9.9619),(-0.0753,-2.3754,9.952),(-0.0761,-2.3962,9.8827),(-0.077,-2.4025,9.8149),(-0.0792,-2.3899,9.6411),(-0.0808,-2.3604,9.4432),(-0.0788,-2.2777,9.1786),(-0.0779,-2.2508,9.1808),(-0.0777,-2.1888,9.4438),(-0.0761,-2.1616,9.6408),(-0.0746,-2.1478,9.8141),(-0.0739,-2.1321,9.8823),(-0.0731,-2.1064,9.9523),(-0.0728,-2.0893,9.967),(-0.0726,-2.0742,9.9832),(-0.0719,-1.9748,10.0),(-0.0717,-1.922,9.9963),(-0.0714,-1.7532,9.9592),(-0.0713,-1.655,9.9022),(-0.0713,-1.5406,9.7775),(-0.0714,-1.437,9.5909),(-0.0715,-1.2642,9.4468),(-0.0715,-1.1526,9.4204),(-0.0715,-1.076,9.3186),(-0.0715,-0.7677,9.1646),(-0.0715,-0.1343,9.0097),(-0.0715,0.5791,8.8738),(-0.0715,1.0846,8.6987),(-0.0715,1.5464,8.4912),(-0.0715,2.5458,7.8804),(-0.0715,3.1172,7.454),(-0.0715,3.6489,6.9266),(-0.1119,3.6536,6.9283),(-0.6669,1.7525,7.3278),(-0.7792,0.9113,7.3278),(-0.8541,1.154,6.5953),(-0.7518,2.0471,6.6224),(-0.9353,0.8415,5.9373),(-0.0788,-2.5385,9.9634),(-0.0912,-2.5825,9.9398),(-0.1188,-2.57,9.9414),(-0.0944,-2.5315,9.9643),(-0.1437,-2.5472,9.9441),(-0.1085,-2.5186,9.9658),(-0.1644,-2.5152,9.9479),(-0.1202,-2.5005,9.9681),(-0.1797,-2.475,9.9529),(-0.129,-2.4781,9.9708),(-0.1888,-2.4286,9.9587),(-0.1342,-2.452,9.9741),(-0.1889,-2.3948,9.9637),(-0.1343,-2.4333,9.9768),(-0.1341,-2.0623,9.9858),(-0.1799,-2.0701,9.9717),(-0.1719,-2.0331,9.9773),(-0.1293,-2.0406,9.9891),(-0.1555,-1.9893,9.9843),(-0.1195,-2.0148,9.9933),(-0.1339,-1.9544,9.9904),(-0.1067,-1.9942,9.9967),(-0.1084,-1.9309,9.9946),(-0.0917,-1.9801,9.9991),(-0.1887,-2.0981,9.9667),(-0.1394,-2.0784,9.9828),(-0.2421,-2.1381,9.8827),(-0.1874,-2.1152,9.9528),(-0.4536,-1.4311,9.091),(-0.4406,-1.6451,9.2329),(-0.4565,-1.8522,9.2344),(-0.5206,-1.6959,9.0306),(-0.3749,-1.1277,9.1211),(-0.3708,-1.4008,9.2833),(-0.2214,-0.8706,9.1559),(-0.2335,-1.1721,9.3083),(-0.1413,-0.7896,9.1636),(-0.1571,-1.0947,9.3189),(-0.4586,-2.058,9.2255),(-0.5522,-2.0348,8.9748),(-0.3847,-1.9155,9.4729),(-0.4034,-2.1558,9.4378),(-0.4384,-1.8783,9.2864),(-0.4377,-1.671,9.2918),(-0.427,-1.6714,9.3193),(-0.4443,-1.8701,9.2674),(-0.4107,-1.6723,9.3407),(-0.3942,-1.6694,9.3566),(-0.3773,-1.446,9.3625),(-0.3626,-1.4502,9.3895),(-0.3361,-1.4585,9.4069),(-0.3098,-1.4778,9.4131),(-0.2396,-1.2463,9.4087),(-0.2205,-1.2585,9.4328),(-0.1931,-1.2772,9.4461),(-0.1711,-1.3139,9.4464),(-0.165,-1.1689,9.4206),(-0.1491,-1.1915,9.4416),(-0.1297,-1.2254,9.4509),(-0.1067,-1.2704,9.4485),(-0.4709,-2.2015,9.2024),(-0.3922,-2.1807,9.4323),(-0.4593,-2.2257,9.1986),(-0.4611,-2.2577,9.1948),(-0.401,-2.323,9.4277),(-0.4165,-2.35,9.4219),(-0.476,-2.2903,9.1916),(-0.3497,-2.1438,9.6356),(-0.3379,-2.1687,9.632),(-0.3499,-2.3749,9.6311),(-0.3638,-2.4027,9.6299),(-0.3015,-2.13,9.7908),(-0.2892,-2.1511,9.7879),(-0.2983,-2.3897,9.7896),(-0.3102,-2.4115,9.7916),(-0.2545,-2.1202,9.8858),(-0.2479,-2.3883,9.8846),(-0.2591,-2.4005,9.887),(-0.1904,-2.3766,9.9533),(-0.4861,-2.2104,9.1612),(-0.4778,-2.2226,9.1867),(-0.8774,-2.5105,6.2844),(-0.8206,-2.8193,6.2996),(-0.8364,-3.015,5.9938),(-0.9292,-2.4801,6.1314),(-0.8807,-2.5646,6.4454),(-0.8415,-2.7451,6.4578),(-0.844,-2.814,6.3293),(-0.8968,-2.5272,6.3138),(-0.9473,-1.3409,6.5295),(-0.9634,-1.3044,6.4082),(-0.9044,-0.26,6.5604),(-0.9425,-2.1284,6.5205),(-0.9623,-2.1104,6.4097),(-0.8047,-2.9705,6.4288),(-0.802,-2.8945,6.5474),(-1.0411,0.4791,5.474),(-0.8667,1.0562,6.5804),(-0.8671,0.9317,6.6391),(-1.0619,0.7669,5.9444),(-1.0617,0.819,5.9367),(-1.0371,-1.195,6.1771),(-0.9439,-1.2516,6.372),(-0.9404,-2.0673,6.3875),(-0.9994,-2.0501,6.2129),(-1.153,-1.5038,5.7313),(-1.1656,-1.2973,5.6767),(-1.1916,-1.5488,5.593),(-1.2096,-1.2954,5.4992),(-1.1053,-1.3037,5.4244),(-1.0826,-1.5596,5.5247),(-1.1128,0.3498,5.6193),(-1.1473,0.4322,5.5367),(-1.1599,-0.0844,5.4577),(-1.1998,-0.0689,5.3228),(-0.7199,-3.1474,5.7537),(-0.6224,-3.3476,6.0458),(-0.8566,-2.8675,5.551),(-0.9376,-2.5218,5.4373),(-1.0472,-2.0433,5.5293),(-1.1323,-1.0459,5.1639),(-1.1318,-0.8791,5.1613),(-1.101,-0.5597,5.321),(-1.0961,-0.0621,5.2573),(-0.9731,0.8694,5.9347),(-0.7845,-3.1435,6.2074),(-0.7771,-2.9944,6.4104),(-0.7397,-3.2972,6.1333),(-0.8335,-3.0984,5.8773),(-1.1869,-1.0273,5.4901),(-1.2321,-0.9162,5.2533),(-1.2078,-0.573,5.3344),(-1.1631,-0.6114,5.5297),(-1.029,-0.1715,6.0489),(-1.2362,-1.0513,5.2666),(-0.9642,-2.7257,5.8371),(-1.0362,-2.4721,5.7784),(-0.9639,-2.8398,5.6592),(-1.0549,-2.5034,5.5607),(-1.16,-2.04,5.6117),(-1.1211,-2.047,5.7789),(-0.8952,-2.2372,7.1218),(-0.876,-1.4911,7.1787),(-0.1921,3.6083,6.9465),(-0.6066,2.8952,6.6969),(-0.3315,3.4069,6.9263),(-0.9486,-1.2754,6.3948),(-0.586,-3.2997,7.7517),(-0.623,-3.2889,7.7351),(-0.5276,-3.201,8.2322),(-0.6789,-3.3103,7.2626),(-0.7032,-3.2914,7.2322),(-0.6881,-3.2105,6.7871),(-0.7141,-3.1891,6.7645),(-0.7865,-2.9761,6.43),(-0.8399,-2.8117,6.319),(-0.8868,-2.5081,6.3101),(-0.9529,-2.0748,6.4085),(-0.6541,-3.2184,7.7614),(-0.7237,-3.2176,7.2731),(-0.7436,-3.0979,6.8109),(-0.835,-2.6945,7.0184),(-1.0918,0.5031,5.3734),(-1.0634,0.506,5.3853),(-0.5352,-3.5705,6.5831),(-0.5616,-3.5791,6.5913),(-0.5276,-3.5579,7.1447),(-1.1466,-0.0505,5.1368),(-1.119,-0.0517,5.1476),(-0.6201,-3.4274,6.0299),(-0.6479,-3.4445,6.0244),(-0.7242,-3.2207,5.6802),(-0.7504,-3.2351,5.6726),(-0.8749,-2.919,5.432),(-0.9016,-2.9347,5.4219),(-0.959,-2.5595,5.3173),(-0.9861,-2.5721,5.3057),(-1.0721,-2.0665,5.4163),(-1.1004,-2.0719,5.4055),(-1.1099,-1.5813,5.4186),(-1.1393,-1.5825,5.4088),(-1.1336,-1.3308,5.3223),(-1.161,-1.3395,5.3167),(-1.1588,-1.0648,5.052),(-1.1857,-1.0695,5.0449),(-1.1584,-0.8702,5.0462),(-1.1858,-0.8705,5.0358),(-1.1253,-0.5515,5.1447),(-1.1535,-0.5522,5.1343),(-1.1578,0.4747,5.4031),(-1.2136,-0.0537,5.1783),(-1.2211,-0.5619,5.1791),(-1.2508,-0.8968,5.091),(-1.2548,-1.0724,5.1105),(-1.2237,-1.3317,5.3613),(-1.2049,-1.5728,5.45),(-1.1686,-2.0712,5.4523),(-1.0667,-2.5624,5.3735),(-0.9686,-2.9178,5.479),(-0.8224,-3.2049,5.7332),(-0.7206,-3.413,6.0609),(-0.617,-3.4752,6.6563),(-0.6083,-3.5533,6.6122),(-0.591,-3.5579,7.1415),(-0.5289,-3.5141,6.606),(-0.4442,-3.5399,7.6644),(-0.4749,-3.5658,7.1308),(-0.6503,-3.3378,7.2581),(-0.6025,-3.5339,7.1545),(-0.6289,-3.405,6.6909),(-0.669,-3.2319,6.775),(-0.5548,-3.3302,7.7503),(-0.12,-2.6992,9.8485),(-0.1389,-2.7617,9.755),(-0.1645,-2.6707,9.8499),(-0.2063,-2.6336,9.8537),(-0.2374,-2.5869,9.8591),(-0.2567,-2.5301,9.8661),(-0.2634,-2.459,9.8754),(-0.243,-2.0382,9.9018),(-0.2222,-1.9468,9.919),(-0.1965,-1.8623,9.9372),(-0.1596,-1.8018,9.9494),(-0.1181,-1.7647,9.9567),(-0.2002,-2.7384,9.7461),(-0.2608,-2.6891,9.7499),(-0.2989,-2.6389,9.754),(-0.3172,-2.5826,9.7606),(-0.3156,-2.4968,9.7723),(-0.288,-1.9939,9.8196),(-0.2607,-1.8666,9.8479),(-0.2229,-1.7632,9.8798),(-0.1466,-1.6836,9.8966),(-0.1066,-1.6607,9.901),(-0.1556,-2.8303,9.5904),(-0.2315,-2.8028,9.5848),(-0.3063,-2.7436,9.5871),(-0.3502,-2.6841,9.5879),(-0.3709,-2.6141,9.5945),(-0.3701,-2.509,9.6088),(-0.335,-1.9644,9.6742),(-0.3048,-1.7982,9.7162),(-0.2615,-1.6743,9.7508),(-0.166,-1.5754,9.7714),(-0.1156,-1.5477,9.7763),(-0.1706,-2.8736,9.381),(-0.2589,-2.8416,9.376),(-0.3435,-2.7773,9.375),(-0.3985,-2.7039,9.3785),(-0.424,-2.6173,9.3882),(-0.424,-2.4864,9.4063),(-0.3482,-1.733,9.5295),(-0.2971,-1.6013,9.5762),(-0.1839,-1.4909,9.5989),(-0.124,-1.4491,9.5937),(-0.1606,0.5427,8.8756),(-0.1675,1.0544,8.6985),(-0.2625,0.4042,8.8721),(-0.2779,0.9394,8.6839),(-0.4582,-0.0643,8.8131),(-0.4909,0.4856,8.6188),(-0.5586,-0.6543,8.677),(-0.613,0.1386,8.4661),(-0.6404,-1.1241,8.5518),(-0.7338,-0.3685,8.2432),(-0.1822,-2.8761,9.1251),(-0.2836,-2.8399,9.1311),(-0.3887,-2.7657,9.1312),(-0.4548,-2.6818,9.141),(-0.4843,-2.5837,9.1544),(-0.4804,-2.4227,9.1772),(-0.1993,-2.9734,8.8101),(-0.3211,-2.9255,8.8223),(-0.4492,-2.8226,8.8476),(-0.5289,-2.7117,8.8665),(-0.5639,-2.579,8.8903),(-0.5591,-2.361,8.9261),(-0.2172,-3.3017,8.4935),(-0.3589,-3.2259,8.5138),(-0.5001,-3.0257,8.5528),(-0.5931,-2.8585,8.5859),(-0.6367,-2.6713,8.6217),(-0.6318,-2.3756,8.6755),(-0.6217,-1.9664,8.7424),(-0.5778,-1.4815,8.8051),(-0.5148,-1.07,8.8505),(-0.4202,-0.6748,8.9216),(-0.2407,-0.2939,8.99),(-0.1502,-0.1683,9.0078),(-0.2355,-3.4967,8.1784),(-0.3928,-3.4015,8.2124),(-0.6555,-2.9518,8.2774),(-0.7016,-2.71,8.3311),(-0.6967,-2.3185,8.4059),(-0.6845,-1.7712,8.4935),(-0.2611,-3.7603,7.5864),(-0.7414,-2.9182,7.8715),(-0.7946,-2.6009,7.9519),(-0.7882,-2.0845,8.0563),(-0.7761,-1.313,8.1419),(-0.635,0.4027,8.3389),(-0.5094,0.9717,8.4341),(-0.2858,1.39,8.4961),(-0.1705,1.5139,8.4962),(-0.2756,-3.9739,6.9649),(-0.8026,-2.8077,7.4557),(-0.8605,-2.3918,7.5531),(-0.8482,-1.7462,7.6494),(-0.8246,-0.7177,7.705),(-0.7586,0.5334,7.8709),(-0.6582,1.2299,7.9339),(-0.5066,1.8481,7.9083),(-0.2837,2.3921,7.8735),(-0.1703,2.5146,7.8812),(-0.8493,-0.3873,7.1938),(-0.541,2.4796,7.3689),(-0.3038,2.9564,7.4119),(-0.1795,3.0953,7.4469),(-0.1077,3.1179,7.4537),(-0.8857,0.3359,6.5998),(-0.8142,0.262,7.2608),(-0.7915,-0.0922,7.7881),(-0.9828,-0.2128,6.3065),(0.8398,-0.2128,6.3065),(0.6485,-0.0922,7.7881),(0.6712,0.262,7.2608),(0.7427,0.3359,6.5998),(-0.0354,3.1179,7.4537),(0.0365,3.0953,7.4469),(0.1607,2.9564,7.4119),(0.398,2.4796,7.3689),(0.7062,-0.3873,7.1938),(0.0272,2.5146,7.8812),(0.1407,2.3921,7.8735),(0.3636,1.8481,7.9083),(0.5151,1.2299,7.9339),(0.6155,0.5334,7.8709),(0.6816,-0.7177,7.705),(0.7051,-1.7378,7.6517),(0.7175,-2.3918,7.5531),(0.6596,-2.8001,7.4612),(0.1326,-3.9739,6.9649),(0.0275,1.5139,8.4962),(0.1427,1.39,8.4961),(0.3664,0.9717,8.4341),(0.492,0.4027,8.3389),(0.6331,-1.313,8.1419),(0.6452,-2.0845,8.0563),(0.6515,-2.6009,7.9519),(0.5984,-2.9182,7.8715),(0.1181,-3.7603,7.5864),(0.5414,-1.7712,8.4935),(0.5536,-2.3185,8.4059),(0.5586,-2.71,8.3311),(0.5125,-2.9518,8.2774),(0.2498,-3.4015,8.2124),(0.0925,-3.4967,8.1784),(0.0072,-0.1683,9.0078),(0.0977,-0.2939,8.99),(0.2772,-0.6748,8.9216),(0.3718,-1.07,8.8505),(0.4348,-1.4815,8.8051),(0.4781,-1.9664,8.7424),(0.4869,-2.3756,8.6755),(0.4925,-2.6713,8.6217),(0.4497,-2.8585,8.5859),(0.3571,-3.0257,8.5528),(0.2159,-3.2259,8.5138),(0.0742,-3.3017,8.4935),(0.4094,-2.3606,8.9261),(0.4146,-2.5789,8.8903),(0.3806,-2.7117,8.8665),(0.302,-2.8226,8.8476),(0.1754,-2.9255,8.8223),(0.0543,-2.9734,8.8101),(0.3247,-2.4207,9.1771),(0.3294,-2.5821,9.1544),(0.3005,-2.6803,9.141),(0.2349,-2.7645,9.1311),(0.1303,-2.8391,9.1311),(0.0291,-2.8758,9.1251),(0.5907,-0.3685,8.2432),(0.4974,-1.1241,8.5518),(0.47,0.1386,8.4661),(0.4156,-0.6543,8.677),(0.3478,0.4856,8.6188),(0.3152,-0.0643,8.8131),(0.1348,0.9394,8.6839),(0.1195,0.4042,8.8721),(0.0245,1.0544,8.6985),(0.0175,0.5427,8.8756),(-0.0187,-1.4495,9.5937),(0.0412,-1.4922,9.5989),(0.154,-1.6054,9.5763),(0.2029,-1.7409,9.5296),(0.2654,-2.4854,9.4063),(0.2668,-2.6164,9.3882),(0.242,-2.703,9.3785),(0.1876,-2.7764,9.375),(0.1035,-2.8409,9.376),(0.0154,-2.873,9.381),(-0.027,-1.5481,9.7763),(0.0234,-1.5766,9.7714),(0.1185,-1.6783,9.7509),(0.1602,-1.8057,9.7163),(0.187,-1.9766,9.6743),(0.2136,-2.5091,9.6088),(0.2152,-2.6141,9.5945),(0.1952,-2.684,9.5879),(0.1518,-2.7431,9.5871),(0.0776,-2.8024,9.5848),(0.0019,-2.8298,9.5904),(-0.0361,-1.6613,9.901),(0.0039,-1.6848,9.8966),(0.0798,-1.7668,9.8798),(0.1164,-1.873,9.848),(0.1414,-2.0035,9.8197),(0.162,-2.4973,9.7723),(0.1642,-2.583,9.7606),(0.1463,-2.6389,9.754),(0.1087,-2.6891,9.7499),(0.0486,-2.7383,9.7461),(-0.0248,-1.7657,9.9567),(0.0166,-1.804,9.9494),(0.053,-1.8661,9.9372),(0.0777,-1.9524,9.919),(0.0969,-2.0457,9.9019),(0.1118,-2.4595,9.8754),(0.1056,-2.5306,9.8661),(0.0866,-2.5872,9.8591),(0.0559,-2.6337,9.8537),(0.0144,-2.6709,9.8499),(-0.0123,-2.7617,9.755),(-0.0298,-2.6992,9.8485),(0.4118,-3.3302,7.7503),(0.5259,-3.2319,6.775),(0.4859,-3.405,6.6909),(0.4595,-3.5339,7.1545),(0.5072,-3.3378,7.2581),(0.3319,-3.5658,7.1308),(0.3012,-3.5399,7.6644),(0.3859,-3.5141,6.606),(0.448,-3.5579,7.1415),(0.4653,-3.5533,6.6122),(0.474,-3.4752,6.6563),(0.5776,-3.413,6.0609),(0.6794,-3.2049,5.7332),(0.8256,-2.9178,5.479),(0.9237,-2.5624,5.3735),(1.0256,-2.0712,5.4523),(1.0619,-1.5728,5.45),(1.0807,-1.3317,5.3613),(1.1117,-1.0724,5.1105),(1.1077,-0.8968,5.091),(1.0781,-0.5619,5.1791),(1.0706,-0.0537,5.1783),(1.0148,0.4747,5.4031),(1.0105,-0.5522,5.1343),(0.9823,-0.5515,5.1447),(1.0428,-0.8705,5.0358),(1.0154,-0.8702,5.0462),(1.0426,-1.0695,5.0449),(1.0158,-1.0648,5.052),(1.018,-1.3395,5.3167),(0.9906,-1.3308,5.3223),(0.9962,-1.5825,5.4088),(0.9669,-1.5813,5.4186),(0.9573,-2.0719,5.4055),(0.9291,-2.0665,5.4163),(0.8431,-2.5721,5.3057),(0.8159,-2.5595,5.3173),(0.7586,-2.9347,5.4219),(0.7319,-2.919,5.432),(0.6074,-3.2351,5.6726),(0.5812,-3.2207,5.6802),(0.5049,-3.4445,6.0244),(0.477,-3.4274,6.0299),(0.976,-0.0517,5.1476),(1.0036,-0.0505,5.1368),(0.3845,-3.5579,7.1447),(0.4186,-3.5791,6.5913),(0.3922,-3.5656,6.591),(0.9204,0.506,5.3853),(0.9487,0.5031,5.3734),(0.692,-2.6945,7.0184),(0.6006,-3.0979,6.8109),(0.5806,-3.2105,7.2799),(0.5111,-3.2184,7.7614),(0.8098,-2.0748,6.4085),(0.7438,-2.5081,6.3101),(0.6968,-2.8117,6.319),(0.6435,-2.9761,6.43),(0.5711,-3.1891,6.7645),(0.545,-3.2105,6.7871),(0.5601,-3.2914,7.2322),(0.5359,-3.3103,7.2626),(0.3845,-3.201,8.2322),(0.48,-3.2889,7.7351),(0.443,-3.2997,7.7517),(0.8055,-1.2754,6.3948),(0.1884,3.4069,6.9263),(0.4636,2.8952,6.6969),(0.0491,3.6083,6.9465),(0.733,-1.4911,7.1787),(0.7522,-2.2372,7.1218),(0.9781,-2.047,5.7789),(1.017,-2.04,5.6117),(0.9119,-2.5034,5.5607),(0.8209,-2.8398,5.6592),(0.8932,-2.4721,5.7784),(0.8212,-2.7257,5.8371),(1.0932,-1.0513,5.2666),(0.886,-0.1715,6.0489),(1.0201,-0.6114,5.5297),(1.0648,-0.573,5.3344),(1.089,-0.9162,5.2533),(1.0439,-1.0273,5.4901),(0.6905,-3.0984,5.8773),(0.5967,-3.2972,6.1333),(0.6341,-2.9944,6.4104),(0.6414,-3.1435,6.2074),(0.8301,0.8694,5.9347),(0.953,-0.0621,5.2573),(0.958,-0.5597,5.321),(0.9888,-0.8791,5.1613),(0.9893,-1.0459,5.1639),(0.9042,-2.0433,5.5293),(0.7946,-2.5218,5.4373),(0.7136,-2.8675,5.551),(0.4794,-3.3476,6.0458),(0.5769,-3.1474,5.7537),(1.0568,-0.0689,5.3228),(1.0169,-0.0844,5.4577),(1.0043,0.4322,5.5367),(0.9698,0.3498,5.6193),(0.9396,-1.5596,5.5247),(0.9623,-1.3037,5.4244),(1.0666,-1.2954,5.4992),(1.0486,-1.5488,5.593),(1.0226,-1.2973,5.6767),(1.01,-1.5038,5.7313),(0.8564,-2.0501,6.2129),(0.7974,-2.0673,6.3875),(0.8008,-1.2516,6.372),(0.894,-1.195,6.1771),(0.9187,0.819,5.9367),(0.9188,0.7669,5.9444),(0.7241,0.9317,6.6391),(0.7237,1.0562,6.5804),(0.8981,0.4791,5.474),(0.659,-2.8945,6.5474),(0.6617,-2.9705,6.4288),(0.8193,-2.1104,6.4097),(0.7995,-2.1284,6.5205),(0.7614,-0.26,6.5604),(0.8204,-1.3044,6.4082),(0.8043,-1.3409,6.5295),(0.7538,-2.5272,6.3138),(0.701,-2.814,6.3293),(0.6985,-2.7451,6.4578),(0.7377,-2.5646,6.4454),(0.7862,-2.4801,6.1314),(0.6934,-3.015,5.9938),(0.6776,-2.8193,6.2996),(0.7344,-2.5105,6.2844),(0.3232,-2.2304,9.1867),(0.3323,-2.2174,9.1613),(0.04,-2.377,9.9533),(0.1072,-2.4012,9.887),(0.096,-2.389,9.8846),(0.1065,-2.1292,9.8859),(0.1562,-2.4123,9.7916),(0.144,-2.3904,9.7896),(0.1387,-2.1633,9.788),(0.1515,-2.1425,9.7909),(0.206,-2.4033,9.6299),(0.1916,-2.3753,9.6311),(0.1843,-2.1842,9.6321),(0.1967,-2.1595,9.6358),(0.3205,-2.2972,9.1916),(0.2563,-2.3486,9.4219),(0.2405,-2.3216,9.4277),(0.3056,-2.2656,9.1948),(0.3052,-2.2347,9.1987),(0.2367,-2.196,9.4324),(0.3173,-2.2106,9.2025),(-0.0715,-1.2186,9.4479),(-0.0715,-1.1814,9.4391),(-0.0363,-1.2704,9.4485),(-0.0133,-1.2254,9.4509),(0.0060,-1.1915,9.4416),(0.022,-1.1689,9.4206),(0.0281,-1.3139,9.4464),(0.0501,-1.2772,9.4461),(0.0775,-1.2585,9.4328),(0.0966,-1.2463,9.4087),(0.167,-1.4783,9.4131),(0.1934,-1.4588,9.4069),(0.2197,-1.4503,9.3895),(0.2344,-1.446,9.3625),(0.2504,-1.6739,9.3567),(0.2669,-1.6766,9.3408),(0.2969,-1.8779,9.2674),(0.2833,-1.6754,9.3193),(0.2941,-1.6743,9.2919),(0.2907,-1.8867,9.2865),(0.2484,-2.1712,9.438),(0.2352,-1.9281,9.473),(0.4049,-2.0364,8.9749),(0.3074,-2.0676,9.2256),(0.0141,-1.0947,9.3189),(-0.0017,-0.7896,9.1636),(0.0905,-1.1721,9.3083),(0.0783,-0.8706,9.1559),(0.2278,-1.4006,9.2833),(0.2319,-1.1277,9.1211),(0.3772,-1.6959,9.0306),(0.3097,-1.8587,9.2344),(0.2974,-1.6469,9.2329),(0.3106,-1.4311,9.091),(0.0408,-2.1205,9.9529),(0.0937,-2.1467,9.8828),(-0.0060,-2.0812,9.9828),(0.0427,-2.1032,9.9667),(-0.0521,-1.9808,9.9991),(-0.0351,-1.932,9.9946),(-0.0373,-1.9954,9.9967),(-0.0099,-1.9565,9.9904),(-0.0248,-2.0165,9.9933),(0.0113,-1.9922,9.9844),(-0.0154,-2.0428,9.9891),(0.0271,-2.037,9.9773),(0.0345,-2.0747,9.9717),(-0.011,-2.0648,9.9859),(-0.015,-2.4336,9.9768),(0.039,-2.3953,9.9637),(-0.0151,-2.4523,9.9741),(0.039,-2.4289,9.9587),(-0.0201,-2.4782,9.9708),(0.0301,-2.4753,9.9529),(-0.0288,-2.5008,9.9681),(0.015,-2.5155,9.9479),(-0.0404,-2.5186,9.9658),(-0.0055,-2.5475,9.9441),(-0.0544,-2.5315,9.9643),(-0.0302,-2.5702,9.9414),(-0.0577,-2.5825,9.9398),(-0.0699,-2.5385,9.9634),(0.7923,0.8415,5.9373),(0.6088,2.0471,6.6224),(0.7111,1.154,6.5953),(0.6362,0.9113,7.3278),(0.5239,1.7525,7.3278),(-0.0311,3.6536,6.9283),(-0.3409,-0.569,8.8625),(-0.3521,-0.656,8.8561),(-0.5277,-0.6454,8.8988),(-0.5154,-0.5586,8.9052),(-0.369,-0.7402,8.8351),(-0.5456,-0.7299,8.8778),(-0.3902,-0.8194,8.8001),(-0.568,-0.809,8.8428),(-0.4144,-0.8908,8.7521),(-0.5935,-0.8803,8.7948),(-0.4406,-0.9525,8.6927),(-0.6209,-0.9421,8.7353),(-0.4673,-1.0025,8.6235),(-0.6487,-0.9921,8.6662),(-0.4938,-1.0393,8.5469),(-0.6763,-1.0288,8.5896),(-0.519,-1.0617,8.465),(-0.7025,-1.0512,8.5076),(-0.5422,-1.0692,8.3803),(-0.7267,-1.0588,8.423),(-0.563,-1.0615,8.2953),(-0.7483,-1.0511,8.338),(-0.5813,-1.0389,8.2128),(-0.767,-1.0284,8.2555),(-0.5975,-1.0018,8.1353),(-0.7832,-0.9914,8.1779),(-0.6112,-0.9516,8.0649),(-0.7968,-0.9412,8.1076),(-0.6219,-0.8899,8.004),(-0.8076,-0.8793,8.0467),(-0.6293,-0.8183,7.9543),(-0.8149,-0.8077,7.997),(-0.6332,-0.7389,7.9174),(-0.8189,-0.7287,7.9601),(-0.6336,-0.6547,7.8943),(-0.8192,-0.6442,7.937),(-0.6303,-0.5676,7.8859),(-0.816,-0.5574,7.9286),(-0.6235,-0.4806,7.8923),(-0.8091,-0.4702,7.935),(-0.6134,-0.3964,7.9133),(-0.799,-0.386,7.956),(-0.6003,-0.3172,7.9483),(-0.7858,-0.3068,7.991),(-0.5845,-0.2459,7.9963),(-0.7701,-0.2354,8.039),(-0.5665,-0.1841,8.0557),(-0.7522,-0.1737,8.0984),(-0.5469,-0.1341,8.1249),(-0.7322,-0.1239,8.1676),(-0.5255,-0.0973,8.2015),(-0.7098,-0.087,8.2442),(-0.5019,-0.075,8.2834),(-0.6854,-0.0645,8.3261),(-0.477,-0.0674,8.3681),(-0.6595,-0.057,8.4108),(-0.4514,-0.0751,8.4531),(-0.6328,-0.0647,8.4957),(-0.4259,-0.0978,8.5356),(-0.6061,-0.0873,8.5783),(-0.4015,-0.1348,8.6131),(-0.5805,-0.1244,8.6558),(-0.3794,-0.185,8.6835),(-0.5571,-0.1746,8.7262),(-0.3605,-0.2469,8.7444),(-0.5371,-0.2363,8.787),(-0.3464,-0.3185,8.7941),(-0.5219,-0.3079,8.8368),(-0.338,-0.3977,8.831),(-0.5125,-0.3873,8.8737),(-0.336,-0.482,8.8541),(-0.5101,-0.4715,8.8967),(-0.6298,-0.5557,8.6758),(-0.6356,-0.5999,8.6726),(-0.6443,-0.6428,8.6619),(-0.6555,-0.683,8.644),(-0.6688,-0.7194,8.6197),(-0.6834,-0.7508,8.5894),(-0.6987,-0.7762,8.5543),(-0.7144,-0.795,8.5153),(-0.7298,-0.8062,8.4735),(-0.7444,-0.8101,8.4305),(-0.758,-0.8062,8.3873),(-0.7701,-0.7947,8.3453),(-0.7806,-0.7759,8.3058),(-0.7892,-0.7503,8.27),(-0.7958,-0.7188,8.2391),(-0.8004,-0.6826,8.2138),(-0.8029,-0.6422,8.195),(-0.8032,-0.5993,8.1833),(-0.8014,-0.555,8.179),(-0.7975,-0.5108,8.1822),(-0.7915,-0.4679,8.1929),(-0.7836,-0.4277,8.2107),(-0.7739,-0.3913,8.2351),(-0.7626,-0.3599,8.2653),(-0.7498,-0.3345,8.3005),(-0.7358,-0.3157,8.3395),(-0.721,-0.3042,8.3812),(-0.7058,-0.3006,8.4243),(-0.6906,-0.3045,8.4675),(-0.6759,-0.316,8.5095),(-0.662,-0.3348,8.549),(-0.65,-0.3603,8.5847),(-0.6399,-0.3919,8.6157),(-0.6325,-0.4281,8.641),(-0.6282,-0.4684,8.6598),(-0.6273,-0.5114,8.6715),(-0.3348,-0.5695,8.8399),(-0.3301,-0.4862,8.8318),(-0.332,-0.4053,8.8096),(-0.34,-0.3293,8.7743),(-0.3535,-0.2607,8.7265),(-0.3715,-0.2013,8.6681),(-0.3927,-0.1532,8.6006),(-0.4162,-0.1176,8.5262),(-0.4409,-0.0959,8.4471),(-0.4657,-0.0884,8.3657),(-0.4897,-0.0958,8.2845),(-0.5126,-0.1172,8.2059),(-0.5337,-0.1525,8.1322),(-0.5525,-0.2005,8.0659),(-0.5697,-0.2596,8.009),(-0.5848,-0.3282,7.9629),(-0.5974,-0.4042,7.9293),(-0.607,-0.4849,7.9091),(-0.6137,-0.5683,7.9031),(-0.6167,-0.6518,7.9112),(-0.6165,-0.7327,7.9333),(-0.6127,-0.8087,7.9687),(-0.6055,-0.8774,8.0163),(-0.5953,-0.9367,8.0748),(-0.5821,-0.9849,8.1422),(-0.5666,-1.0203,8.2167),(-0.549,-1.0421,8.2958),(-0.5287,-1.0495,8.3773),(-0.5061,-1.0423,8.4585),(-0.4817,-1.0207,8.5371),(-0.4561,-0.9854,8.6106),(-0.4302,-0.9375,8.677),(-0.4051,-0.8782,8.734),(-0.3819,-0.8098,8.7799),(-0.3615,-0.7339,8.8136),(-0.3454,-0.6529,8.8337),(-0.5601,-0.6417,8.8942),(-0.5481,-0.5568,8.9004),(-0.5429,-0.472,8.8922),(-0.5451,-0.3896,8.8697),(-0.5544,-0.3122,8.8337),(-0.5694,-0.2424,8.7851),(-0.5889,-0.182,8.7257),(-0.6119,-0.1332,8.6571),(-0.6371,-0.097,8.5813),(-0.6633,-0.0747,8.5007),(-0.6896,-0.0674,8.418),(-0.7152,-0.0746,8.3352),(-0.7393,-0.0966,8.2552),(-0.7613,-0.1325,8.1804),(-0.7811,-0.1812,8.113),(-0.7986,-0.2415,8.0549),(-0.814,-0.3111,8.0081),(-0.8268,-0.3884,7.974),(-0.8368,-0.4707,7.9535),(-0.8435,-0.5556,7.9473),(-0.8466,-0.6404,7.9554),(-0.8462,-0.7227,7.9779),(-0.8425,-0.8001,8.0141),(-0.8351,-0.8699,8.0625),(-0.8248,-0.9303,8.1219),(-0.8113,-0.9792,8.1907),(-0.7955,-1.0153,8.2663),(-0.7771,-1.0376,8.3469),(-0.7556,-1.045,8.4298),(-0.7318,-1.0378,8.5124),(-0.7061,-1.0159,8.5924),(-0.6789,-0.98,8.6672),(-0.6515,-0.9311,8.7346),(-0.6246,-0.8709,8.7927),(-0.5996,-0.8012,8.8395),(-0.5777,-0.7241,8.8737),(-0.583,-0.6359,8.8711),(-0.5716,-0.556,8.877),(-0.5667,-0.4758,8.8692),(-0.5688,-0.3981,8.848),(-0.5776,-0.3254,8.8141),(-0.5917,-0.2595,8.7684),(-0.6102,-0.2025,8.7123),(-0.6321,-0.1564,8.6476),(-0.6561,-0.1222,8.5761),(-0.6811,-0.1013,8.5003),(-0.7063,-0.0944,8.4221),(-0.731,-0.1013,8.3442),(-0.7543,-0.1219,8.2688),(-0.7757,-0.1559,8.1982),(-0.7948,-0.2019,8.1346),(-0.8116,-0.2585,8.0799),(-0.826,-0.3243,8.0358),(-0.8382,-0.3971,8.0036),(-0.8475,-0.4747,7.9842),(-0.8538,-0.5546,7.9785),(-0.8567,-0.6348,7.9861),(-0.8565,-0.7123,8.0073),(-0.8529,-0.7852,8.0414),(-0.8461,-0.8511,8.087),(-0.8361,-0.9079,8.1432),(-0.8236,-0.9541,8.2079),(-0.8084,-0.9881,8.2793),(-0.7904,-1.009,8.3552),(-0.7698,-1.0162,8.4332),(-0.7466,-1.0092,8.5111),(-0.7219,-0.9886,8.5866),(-0.696,-0.9547,8.6572),(-0.6696,-0.9087,8.7207),(-0.6442,-0.8519,8.7755),(-0.6203,-0.7861,8.8196),(-0.5996,-0.7134,8.8519),(-0.6003,-0.6182,8.769),(-0.5918,-0.5561,8.7736),(-0.5881,-0.4942,8.7676),(-0.5896,-0.4341,8.7511),(-0.5961,-0.3779,8.7248),(-0.6069,-0.3268,8.6895),(-0.6213,-0.2827,8.6461),(-0.6385,-0.247,8.5961),(-0.6576,-0.2207,8.5409),(-0.6778,-0.2046,8.4821),(-0.6985,-0.1991,8.4217),(-0.7188,-0.2043,8.3614),(-0.7383,-0.2204,8.3029),(-0.7565,-0.2466,8.2483),(-0.7728,-0.2822,8.1992),(-0.7874,-0.3261,8.1568),(-0.7996,-0.377,8.1227),(-0.8095,-0.4333,8.0977),(-0.8169,-0.4932,8.0827),(-0.8218,-0.5553,8.0783),(-0.8242,-0.6172,8.0843),(-0.8239,-0.6771,8.1006),(-0.821,-0.7335,8.1269),(-0.8156,-0.7846,8.1624),(-0.8074,-0.8285,8.2058),(-0.7966,-0.8644,8.2558),(-0.7833,-0.8907,8.311),(-0.7678,-0.9068,8.3698),(-0.7502,-0.9123,8.4302),(-0.731,-0.9069,8.4905),(-0.7105,-0.891,8.5488),(-0.6893,-0.8648,8.6034),(-0.6681,-0.8292,8.6527),(-0.6479,-0.7853,8.6951),(-0.6292,-0.7343,8.7292),(-0.613,-0.6781,8.7541),(0.3724,-0.5586,8.9052),(0.3847,-0.6454,8.8988),(0.2091,-0.656,8.8561),(0.1979,-0.569,8.8625),(0.4025,-0.7299,8.8778),(0.226,-0.7402,8.8351),(0.425,-0.809,8.8428),(0.2472,-0.8194,8.8001),(0.4505,-0.8803,8.7948),(0.2714,-0.8908,8.7521),(0.4779,-0.9421,8.7353),(0.2976,-0.9525,8.6927),(0.5057,-0.9921,8.6662),(0.3243,-1.0025,8.6235),(0.5333,-1.0288,8.5896),(0.3507,-1.0393,8.5469),(0.5595,-1.0512,8.5076),(0.376,-1.0617,8.465),(0.5837,-1.0588,8.423),(0.3992,-1.0692,8.3803),(0.6053,-1.0511,8.338),(0.42,-1.0615,8.2953),(0.624,-1.0284,8.2555),(0.4383,-1.0389,8.2128),(0.6402,-0.9914,8.1779),(0.4545,-1.0018,8.1353),(0.6538,-0.9412,8.1076),(0.4682,-0.9516,8.0649),(0.6646,-0.8793,8.0467),(0.4788,-0.8899,8.004),(0.6719,-0.8077,7.997),(0.4863,-0.8183,7.9543),(0.6759,-0.7287,7.9601),(0.4902,-0.7389,7.9174),(0.6762,-0.6442,7.937),(0.4906,-0.6547,7.8943),(0.673,-0.5574,7.9286),(0.4873,-0.5676,7.8859),(0.6661,-0.4702,7.935),(0.4805,-0.4806,7.8923),(0.656,-0.386,7.956),(0.4704,-0.3964,7.9133),(0.6428,-0.3068,7.991),(0.4572,-0.3172,7.9483),(0.627,-0.2354,8.039),(0.4415,-0.2459,7.9963),(0.6092,-0.1737,8.0984),(0.4235,-0.1841,8.0557),(0.5892,-0.1239,8.1676),(0.4039,-0.1341,8.1249),(0.5668,-0.087,8.2442),(0.3825,-0.0973,8.2015),(0.5424,-0.0645,8.3261),(0.3589,-0.075,8.2834),(0.5165,-0.057,8.4108),(0.334,-0.0674,8.3681),(0.4898,-0.0647,8.4957),(0.3084,-0.0751,8.4531),(0.4631,-0.0873,8.5783),(0.2829,-0.0978,8.5356),(0.4374,-0.1244,8.6558),(0.2585,-0.1348,8.6131),(0.414,-0.1746,8.7262),(0.2364,-0.185,8.6835),(0.3941,-0.2363,8.787),(0.2175,-0.2469,8.7444),(0.3789,-0.3079,8.8368),(0.2034,-0.3185,8.7941),(0.3694,-0.3873,8.8737),(0.1949,-0.3977,8.831),(0.3671,-0.4715,8.8967),(0.193,-0.482,8.8541),(0.4843,-0.5114,8.6715),(0.4852,-0.4684,8.6598),(0.4895,-0.4281,8.641),(0.4969,-0.3919,8.6157),(0.507,-0.3603,8.5847),(0.519,-0.3348,8.549),(0.5329,-0.316,8.5095),(0.5475,-0.3045,8.4675),(0.5628,-0.3006,8.4243),(0.578,-0.3042,8.3812),(0.5928,-0.3157,8.3395),(0.6068,-0.3345,8.3005),(0.6196,-0.3599,8.2653),(0.6309,-0.3913,8.2351),(0.6406,-0.4277,8.2107),(0.6485,-0.4679,8.1929),(0.6545,-0.5108,8.1822),(0.6583,-0.555,8.179),(0.6601,-0.5993,8.1833),(0.6599,-0.6422,8.195),(0.6574,-0.6826,8.2138),(0.6528,-0.7188,8.2391),(0.6461,-0.7503,8.27),(0.6376,-0.7759,8.3058),(0.627,-0.7947,8.3453),(0.615,-0.8062,8.3873),(0.6014,-0.8101,8.4305),(0.5867,-0.8062,8.4735),(0.5714,-0.795,8.5153),(0.5557,-0.7762,8.5543),(0.5403,-0.7508,8.5894),(0.5258,-0.7194,8.6197),(0.5125,-0.683,8.644),(0.5013,-0.6428,8.6619),(0.4926,-0.5999,8.6726),(0.4867,-0.5557,8.6758),(0.2024,-0.6529,8.8337),(0.2185,-0.7339,8.8136),(0.2388,-0.8098,8.7799),(0.2621,-0.8782,8.734),(0.2872,-0.9375,8.677),(0.3131,-0.9854,8.6106),(0.3387,-1.0207,8.5371),(0.3631,-1.0423,8.4585),(0.3856,-1.0495,8.3773),(0.406,-1.0421,8.2958),(0.4236,-1.0203,8.2167),(0.4391,-0.9849,8.1422),(0.4523,-0.9367,8.0748),(0.4625,-0.8774,8.0163),(0.4697,-0.8087,7.9687),(0.4734,-0.7327,7.9333),(0.4737,-0.6518,7.9112),(0.4707,-0.5683,7.9031),(0.464,-0.4849,7.9091),(0.4543,-0.4042,7.9293),(0.4417,-0.3282,7.9629),(0.4266,-0.2596,8.009),(0.4095,-0.2005,8.0659),(0.3906,-0.1525,8.1322),(0.3696,-0.1172,8.2059),(0.3467,-0.0958,8.2845),(0.3226,-0.0884,8.3657),(0.2978,-0.0959,8.4471),(0.2732,-0.1176,8.5262),(0.2496,-0.1532,8.6006),(0.2285,-0.2013,8.6681),(0.2105,-0.2607,8.7265),(0.197,-0.3293,8.7743),(0.189,-0.4053,8.8096),(0.1871,-0.4862,8.8318),(0.1918,-0.5695,8.8399),(0.405,-0.5568,8.9004),(0.4171,-0.6417,8.8942),(0.3999,-0.472,8.8922),(0.4021,-0.3896,8.8697),(0.4114,-0.3122,8.8337),(0.4264,-0.2424,8.7851),(0.4459,-0.182,8.7257),(0.4689,-0.1332,8.6571),(0.4941,-0.097,8.5813),(0.5203,-0.0747,8.5007),(0.5466,-0.0674,8.418),(0.5722,-0.0746,8.3352),(0.5963,-0.0966,8.2552),(0.6183,-0.1325,8.1804),(0.6381,-0.1812,8.113),(0.6556,-0.2415,8.0549),(0.6709,-0.3111,8.0081),(0.6838,-0.3884,7.974),(0.6938,-0.4707,7.9535),(0.7004,-0.5556,7.9473),(0.7036,-0.6404,7.9554),(0.7032,-0.7227,7.9779),(0.6995,-0.8001,8.0141),(0.6921,-0.8699,8.0625),(0.6817,-0.9303,8.1219),(0.6683,-0.9792,8.1907),(0.6525,-1.0153,8.2663),(0.6341,-1.0376,8.3469),(0.6126,-1.045,8.4298),(0.5888,-1.0378,8.5124),(0.5631,-1.0159,8.5924),(0.5359,-0.98,8.6672),(0.5085,-0.9311,8.7346),(0.4816,-0.8709,8.7927),(0.4566,-0.8012,8.8395),(0.4347,-0.7241,8.8737),(0.4286,-0.556,8.877),(0.4399,-0.6359,8.8711),(0.4237,-0.4758,8.8692),(0.4258,-0.3981,8.848),(0.4345,-0.3254,8.8141),(0.4487,-0.2595,8.7684),(0.4672,-0.2025,8.7123),(0.4891,-0.1564,8.6476),(0.5131,-0.1222,8.5761),(0.5381,-0.1013,8.5003),(0.5633,-0.0944,8.4221),(0.588,-0.1013,8.3442),(0.6112,-0.1219,8.2688),(0.6327,-0.1559,8.1982),(0.6518,-0.2019,8.1346),(0.6686,-0.2585,8.0799),(0.683,-0.3243,8.0358),(0.6952,-0.3971,8.0036),(0.7044,-0.4747,7.9842),(0.7108,-0.5546,7.9785),(0.7137,-0.6348,7.9861),(0.7135,-0.7123,8.0073),(0.7099,-0.7852,8.0414),(0.7031,-0.8511,8.087),(0.6931,-0.9079,8.1432),(0.6806,-0.9541,8.2079),(0.6654,-0.9881,8.2793),(0.6474,-1.009,8.3552),(0.6268,-1.0162,8.4332),(0.6036,-1.0092,8.5111),(0.5788,-0.9886,8.5866),(0.5529,-0.9547,8.6572),(0.5266,-0.9087,8.7207),(0.5011,-0.8519,8.7755),(0.4773,-0.7861,8.8196),(0.4566,-0.7134,8.8519),(0.4488,-0.5561,8.7736),(0.4572,-0.6182,8.769),(0.4451,-0.4942,8.7676),(0.4466,-0.4341,8.7511),(0.4531,-0.3779,8.7248),(0.4639,-0.3268,8.6895),(0.4783,-0.2827,8.6461),(0.4955,-0.247,8.5961),(0.5146,-0.2207,8.5409),(0.5348,-0.2046,8.4821),(0.5554,-0.1991,8.4217),(0.5758,-0.2043,8.3614),(0.5953,-0.2204,8.3029),(0.6135,-0.2466,8.2483),(0.6298,-0.2822,8.1992),(0.6443,-0.3261,8.1568),(0.6565,-0.377,8.1227),(0.6665,-0.4333,8.0977),(0.6738,-0.4932,8.0827),(0.6788,-0.5553,8.0783),(0.6812,-0.6172,8.0843),(0.6809,-0.6771,8.1006),(0.678,-0.7335,8.1269),(0.6726,-0.7846,8.1624),(0.6644,-0.8285,8.2058),(0.6536,-0.8644,8.2558),(0.6403,-0.8907,8.311),(0.6248,-0.9068,8.3698),(0.6072,-0.9123,8.4302),(0.588,-0.9069,8.4905),(0.5675,-0.891,8.5488),(0.5463,-0.8648,8.6034),(0.5251,-0.8292,8.6527),(0.5049,-0.7853,8.6951),(0.4862,-0.7343,8.7292),(0.47,-0.6781,8.7541),(1.2862,-1.8719,4.3609),(1.2781,-1.9578,4.3257),(1.4742,-1.7309,3.8065),(1.4789,-1.6384,3.8366),(1.7935,-1.2486,2.2805),(1.7942,-1.138,2.2909),(1.7865,-1.4965,2.4154),(1.7901,-1.5114,2.3703),(1.7595,-1.8323,2.5139),(1.7665,-1.85,2.4695),(1.7035,-2.1101,2.6434),(1.7141,-2.1298,2.6005),(1.662,-2.309,2.7152),(1.6702,-2.339,2.6758),(1.596,-2.4862,2.9294),(1.5949,-2.5329,2.9157),(1.5607,-2.5112,3.0556),(1.5594,-2.5581,3.0427),(1.4389,-2.5013,3.551),(1.4337,-2.5497,3.5483),(0.8329,-2.7008,4.5829),(0.8345,-2.6592,4.607),(0.6739,-2.662,4.6232),(0.6723,-2.7031,4.5984),(0.9582,-2.6703,4.5262),(0.9593,-2.6276,4.5486),(1.0369,-2.6359,4.4576),(1.0383,-2.5922,4.4784),(1.2498,-2.5927,4.0801),(1.2561,-2.5451,4.0872),(0.6935,-2.2723,4.8813),(0.692,-2.3119,4.8544),(0.8558,-2.298,4.8352),(0.8579,-2.2576,4.8609),(0.988,-2.2425,4.7603),(0.9823,-2.2048,4.7905),(1.0712,-2.1536,4.6918),(1.0672,-2.1154,4.7217),(1.6009,-1.4952,3.334),(1.5987,-1.5419,3.321),(1.632,-1.4886,3.1973),(1.6313,-1.4459,3.2208),(1.7027,-1.3005,2.9261),(1.6985,-1.2655,2.9606),(1.7496,-1.1621,2.8277),(1.7445,-1.1307,2.8647),(1.8087,-0.8931,2.5952),(1.8061,-0.8616,2.6324),(1.8288,-0.6864,2.46),(1.8296,-0.6557,2.4973),(1.8319,-0.5513,2.3397),(1.8344,-0.4862,2.3457),(1.4312,-1.978,3.7161),(1.4359,-1.9321,3.7319),(1.2516,-2.1047,4.2576),(1.2466,-2.1489,4.2386),(1.0415,-2.2659,4.6264),(1.0351,-2.3081,4.6028),(0.9636,-2.3354,4.6933),(0.957,-2.3743,4.6667),(0.8432,-2.3804,4.759),(0.8386,-2.418,4.7297),(0.6846,-2.3905,4.7769),(0.682,-2.4282,4.7465),(1.5627,-1.8833,3.2209),(1.5671,-1.8367,3.2342),(1.5983,-1.8371,3.0933),(1.5999,-1.7939,3.1166),(1.6699,-1.6536,2.8368),(1.6586,-1.61,2.8745),(1.7007,-1.4751,2.748),(1.6969,-1.4485,2.7888),(1.7559,-1.2142,2.5576),(1.7555,-1.1879,2.5989),(1.7765,-0.9479,2.4331),(1.793,-0.9356,2.4724),(1.7967,-0.7821,2.3199),(1.8051,-0.7032,2.3266),(1.4743,-1.4307,3.8975),(1.4744,-1.384,3.9117),(1.2715,-1.6732,4.4344),(1.274,-1.7167,4.4136),(1.0539,-1.9497,4.7917),(1.0636,-1.9864,4.7602),(0.9713,-2.054,4.856),(0.9821,-2.0924,4.8265),(0.8551,-2.1101,4.9257),(0.8546,-2.1533,4.9034),(0.6954,-2.1278,4.9463),(0.6942,-2.1708,4.9235),(1.5968,-1.2119,3.4071),(1.597,-1.1648,3.4197),(1.6272,-1.1574,3.2932),(1.6254,-1.1127,3.3125),(1.7051,-0.9447,2.9884),(1.6993,-0.9068,3.0199),(1.7377,-0.8155,2.8894),(1.7308,-0.781,2.9234),(1.7992,-0.5676,2.6281),(1.794,-0.5324,2.6613),(1.8186,-0.4176,2.49),(1.8159,-0.3805,2.5218),(1.8182,-0.3246,2.3627),(1.8165,-0.2686,2.3686),(0.5361,-2.3033,4.8747),(0.5437,-2.1892,4.9561),(0.5286,-2.4175,4.7932),(0.5135,-2.6456,4.63),(1.8002,-0.9717,2.234),(1.8007,-0.6512,2.2482),(1.8368,-0.4597,2.259),(1.8111,-0.2687,2.2731),(0.3088,-3.0816,4.7714),(0.391,-2.8319,5.021),(0.3798,-3.1054,4.7839),(0.3487,-2.4419,5.3379),(0.4222,-2.4729,5.3417),(0.8296,-2.2246,5.0835),(0.8336,-2.1519,5.1401),(0.4933,-2.3343,5.3834),(0.8214,-2.06,5.2095),(0.4208,-2.3122,5.3809),(0.7736,-2.0301,5.2389),(0.7233,-2.0152,5.2421),(0.2123,-2.7465,4.671),(0.391,-2.657,4.5952),(0.4014,-2.4727,4.7288),(0.6666,-3.059,4.5046),(0.3595,-3.1488,4.6746),(0.7069,-3.0722,4.5092),(0.4383,-3.1633,4.689),(0.7706,-3.0628,4.5171),(0.7877,-3.0135,4.5619),(0.7898,-2.8543,4.6589),(0.808,-2.7505,4.7356),(0.7996,-2.6616,4.7793),(0.8156,-2.6084,4.825),(0.8051,-2.5562,4.8467),(0.8061,-2.5076,4.8917),(0.8034,-2.4504,4.9247),(0.8208,-2.3847,4.9679),(0.8244,-2.3198,5.0138),(0.2364,-3.0553,4.6085),(0.5748,-2.9741,4.4742),(0.1985,-2.9989,4.6873),(0.2303,-2.334,5.2783),(0.6306,-1.959,5.1903),(0.287,-2.2284,5.31),(0.2219,-2.2503,5.2504),(0.1699,-2.9701,4.6125),(0.242,-2.2399,5.0895),(0.4219,-2.1046,4.9959),(0.5588,-1.9611,5.1192),(0.4116,-2.2886,4.8623),(0.4983,-2.8737,4.4671),(1.0706,-2.8991,4.4336),(1.0499,-2.9514,4.3918),(0.9429,-2.9908,4.4525),(0.959,-2.9446,4.493),(1.534,-2.5837,3.6537),(1.5308,-2.7071,3.5885),(1.3611,-2.7111,4.0809),(1.3521,-2.5988,4.1557),(1.1553,-2.6793,4.47),(1.1404,-2.8052,4.3978),(1.0641,-2.826,4.4672),(1.0705,-2.7042,4.5352),(1.9062,-1.4721,2.2452),(1.8904,-1.6725,2.2742),(1.8925,-1.5747,2.3188),(1.6646,-2.4498,3.2451),(1.659,-2.581,3.1977),(1.8129,-2.0634,2.7481),(1.8052,-2.196,2.7315),(1.9557,-0.0929,2.5035),(1.9672,0.0758,2.5984),(1.9577,0.0844,2.4406),(1.886,-0.3473,2.9324),(1.885,-0.1876,3.0741),(1.95,0.0246,2.7535),(1.7537,-0.7087,3.5152),(1.756,-0.5579,3.6187),(1.6204,-1.0518,4.0365),(1.633,-0.886,4.1003),(1.4078,-1.4499,4.5432),(1.4193,-1.2891,4.6084),(1.2014,-1.8069,4.8829),(1.2108,-1.6808,4.9456),(1.1164,-1.938,4.95),(1.1227,-1.822,5.0178),(0.9956,-2.0411,5.0331),(0.9916,-1.9348,5.1127),(1.8988,-1.0083,2.3977),(1.9414,-0.8739,2.3518),(1.935,-0.4984,2.0889),(1.9343,-0.6535,2.1121),(1.829,-1.4165,2.8119),(1.8549,-1.3051,2.7914),(1.693,-1.7738,3.3651),(1.716,-1.6773,3.3677),(1.5618,-1.992,3.822),(1.5802,-1.9115,3.8503),(1.3793,-2.1724,4.2931),(1.3985,-2.1101,4.3253),(1.1804,-2.3225,4.628),(1.1982,-2.2809,4.6567),(1.0894,-2.3965,4.6941),(1.1082,-2.3622,4.722),(0.9709,-2.4713,4.762),(0.9854,-2.4398,4.7914),(1.3412,-2.8987,4.0056),(1.3385,-3.0208,3.9319),(1.1245,-2.9506,4.3229),(1.516,-2.912,3.5045),(1.5108,-3.0941,3.3936),(1.651,-2.8286,3.0859),(1.6293,-3.2169,2.8972),(1.6747,-3.1856,2.7325),(0.9663,-2.5545,4.7141),(0.9639,-2.5961,4.6901),(1.0857,-2.4876,4.6487),(1.0826,-2.5326,4.6259),(1.1746,-2.4314,4.5836),(1.1761,-2.4807,4.5571),(1.3704,-2.3263,4.2539),(1.3727,-2.3925,4.219),(1.5536,-2.1974,3.7869),(1.5486,-2.3455,3.7333),(1.6885,-2.001,3.3437),(1.6786,-2.1821,3.3138),(1.8328,-1.6419,2.7772),(1.8219,-1.8315,2.7848),(1.8973,-1.2017,2.3532),(1.8842,-1.3674,2.3921),(1.9159,-0.9401,2.1582),(1.9119,-1.1044,2.1863),(1.9443,-0.6982,2.405),(1.9389,-0.532,2.3585),(1.938,-0.2113,2.1235),(1.9365,-0.2988,2.0974),(1.8701,-1.1127,2.8237),(1.8656,-0.9593,2.7873),(1.7329,-1.4758,3.3824),(1.7264,-1.3503,3.368),(1.6022,-1.7248,3.8769),(1.5919,-1.6167,3.8892),(1.4043,-1.956,4.3651),(1.3907,-1.8794,4.3829),(1.2032,-2.18,4.7027),(1.1904,-2.1217,4.7196),(1.1119,-2.2748,4.7692),(1.1032,-2.2205,4.7861),(0.9909,-2.3588,4.8397),(0.9786,-2.3099,4.8597),(0.9859,-2.1552,4.9594),(0.986,-2.2101,4.92),(1.1155,-2.0508,4.8765),(1.106,-2.1173,4.8458),(1.202,-1.9277,4.8058),(1.194,-2.005,4.7793),(1.4057,-1.6132,4.4612),(1.397,-1.7142,4.44),(1.6143,-1.2342,3.9621),(1.6006,-1.4121,3.9323),(1.7493,-0.9105,3.4224),(1.7337,-1.1265,3.4073),(1.8826,-0.5376,2.8398),(1.87,-0.7469,2.8358),(1.9526,-0.2491,2.4155),(1.9435,-0.3719,2.4282),(1.9414,-0.0134,2.2272),(1.9406,-0.0671,2.1847),(1.8345,-2.4754,2.4422),(1.7832,-2.7818,2.5119),(1.7949,-2.4326,2.6641),(1.8636,-2.0458,2.3621),(1.9472,0.0541,2.3274),(1.7265,-3.0513,2.6072),(1.5382,-2.8513,3.5319),(1.6672,-2.7624,3.1328),(1.8178,-2.3545,2.679),(1.8433,-1.6518,2.2309),(1.8162,-2.0325,2.3172),(1.891,-1.8949,2.32),(1.8997,-1.7704,2.2932),(1.961,0.0433,2.291),(1.9725,-0.1452,2.4716),(1.9577,-0.4773,2.3815),(1.9567,-0.1523,2.1378),(1.9575,-0.1041,2.1584),(1.9593,-0.4239,2.4048),(1.884,-0.8903,2.8047),(1.8854,-0.8197,2.821),(1.7454,-1.2826,3.3811),(1.748,-1.2083,3.394),(1.6115,-1.5555,3.9049),(1.6143,-1.4875,3.9192),(1.4088,-1.8392,4.4015),(1.4108,-1.7838,4.4205),(1.2071,-2.0968,4.7394),(1.208,-2.0579,4.7595),(1.1182,-2.2014,4.8068),(1.1191,-2.1665,4.8265),(0.9939,-2.2929,4.8809),(0.9961,-2.2597,4.9009),(1.9369,-0.7316,2.1244),(1.9156,-1.0685,2.3847),(1.915,-1.1332,2.3702),(1.9357,-0.8318,2.1388),(1.8448,-1.4805,2.8014),(1.8437,-1.5438,2.7895),(1.7068,-1.842,3.3627),(1.7099,-1.9157,3.3568),(1.579,-2.0638,3.8167),(1.5749,-2.1235,3.8067),(1.3919,-2.2275,4.2835),(1.3906,-2.2821,4.2709),(1.1934,-2.3649,4.6171),(1.1924,-2.4031,4.6028),(1.1026,-2.4371,4.6842),(1.101,-2.4669,4.669),(0.9823,-2.5088,4.7513),(0.9808,-2.5369,4.7353),(1.6719,-2.672,3.168),(1.5433,-2.7719,3.5661),(1.3684,-2.7981,4.0522),(1.3619,-2.8595,4.0273),(1.1397,-2.8841,4.3615),(1.8203,-2.2634,2.7113),(0.9569,-2.7603,4.5946),(0.9731,-2.6893,4.6476),(0.9757,-2.6344,4.6795),(1.0904,-2.6286,4.5856),(1.0944,-2.571,4.6157),(1.1809,-2.5898,4.5176),(1.1883,-2.5223,4.5468),(1.3776,-2.5148,4.1882),(1.3845,-2.4454,4.209),(1.5561,-2.508,3.6839),(1.562,-2.4019,3.7211),(1.687,-2.346,3.2788),(1.6922,-2.245,3.3041),(1.8327,-1.9898,2.7665),(1.8368,-1.8927,2.78),(1.9108,-1.5106,2.3469),(1.901,-1.433,2.3717),(1.921,-1.335,2.224),(1.9266,-1.2148,2.2033),(0.9875,-2.4133,4.8079),(0.9762,-2.376,4.8186),(1.1097,-2.3327,4.7375),(1.0966,-2.2947,4.7486),(1.1998,-2.2471,4.6722),(1.1861,-2.2062,4.6832),(1.4014,-2.0596,4.3387),(1.3852,-1.9999,4.3484),(1.5833,-1.8506,3.8595),(1.5814,-1.7924,3.8653),(1.719,-1.6126,3.3728),(1.7048,-1.5384,3.3754),(1.856,-1.2448,2.8014),(1.8406,-1.1738,2.811),(1.9417,-0.8201,2.367),(1.9254,-0.76,2.384),(1.9513,-0.4374,2.0953),(1.9345,-0.3647,2.0973),(1.0058,-2.0881,5.0129),(1.0023,-2.1263,4.9888),(1.1309,-1.9828,4.9301),(1.1305,-2.0205,4.9055),(1.2172,-1.8522,4.8609),(1.2174,-1.8924,4.8354),(1.4235,-1.5067,4.5188),(1.4229,-1.561,4.4913),(1.6348,-1.1281,4.0057),(1.6326,-1.1774,3.9877),(1.7689,-0.7839,3.4799),(1.7677,-0.8446,3.4522),(1.9016,-0.4197,2.8953),(1.9008,-0.4755,2.8678),(1.9713,-0.1973,2.4422),(1.9588,0.0213,2.2574),(0.95,-2.8778,4.5234),(1.823,-0.0974,2.3882),(1.8283,-0.1334,2.5376),(1.8925,-0.1634,2.0876),(1.8947,-0.0195,2.1541),(1.8883,-0.6089,2.0681),(1.8695,-0.8997,2.1138),(1.8656,-1.0677,2.1421),(1.8592,-1.446,2.2025),(1.8923,-0.2527,2.0593),(1.8899,-0.4524,2.0463),(1.0625,-2.9617,4.3132),(0.9867,-2.9614,4.3822),(0.8787,-2.9984,4.4423),(0.9375,-1.9062,5.131),(1.0711,-1.8045,5.032),(1.1504,-1.6588,4.9625),(1.3681,-1.2643,4.6185),(1.579,-0.8526,4.1057),(1.7039,-0.5213,3.6182),(1.8348,-0.1469,3.0683),(1.9016,0.0685,2.7452),(1.9203,0.1215,2.5854),(1.912,0.1312,2.4232),(1.9011,0.1014,2.3054),(1.8953,0.0344,2.2),(1.7866,-2.4716,2.3981),(1.7339,-2.7834,2.4694),(1.6752,-3.0589,2.5673),(1.6215,-3.1984,2.6964),(1.5742,-3.2326,2.8656),(1.4538,-3.1108,3.3711),(1.2791,-3.0352,3.9169),(1.0185,-2.9345,4.3106),(0.9427,-2.9333,4.3811),(0.8189,-2.9499,4.4289),(0.8815,-1.879,5.1071),(1.0157,-1.8009,5.0163),(1.1053,-1.6563,4.9474),(1.3227,-1.262,4.6043),(1.5334,-0.8505,4.092),(1.6581,-0.5198,3.6045),(1.7888,-0.1448,3.0538),(1.8545,0.07,2.7329),(1.8719,0.1224,2.5767),(1.8628,0.1319,2.4184),(1.852,0.1024,2.3038),(1.8458,0.0362,2.2001),(1.8453,-0.0166,2.1551),(1.8428,-0.1599,2.0883),(1.8413,-0.2402,2.0547),(1.84,-0.4457,2.0466),(1.8391,-0.601,2.0682),(1.8206,-0.8926,2.1141),(1.8166,-1.0603,2.1423),(1.8104,-1.4394,2.2034),(1.7948,-1.6448,2.232),(1.7675,-2.024,2.318),(1.7381,-2.4585,2.3999),(1.6862,-2.765,2.4714),(1.6285,-3.037,2.5691),(1.5763,-3.1736,2.6971),(1.5295,-3.2067,2.8645),(1.4095,-3.086,3.3685),(1.2349,-3.006,3.9107),(0.7129,-1.9057,5.1305),(0.9842,-1.9309,4.9191),(1.0678,-1.8079,4.8545),(1.283,-1.4751,4.5077),(1.4884,-1.1268,3.9943),(1.6118,-0.8523,3.5057),(1.7459,-0.4642,2.974),(1.8096,-0.2338,2.6828),(1.8148,-0.133,2.2832),(1.8423,-0.2804,2.2089),(1.8422,-0.2711,2.1651),(1.8384,-0.586,2.1373),(1.8414,-0.404,2.0949),(1.8434,-0.2085,2.1234),(1.8413,-0.3024,2.0669),(0.8611,-1.9971,4.9986),(1.7193,-0.5567,3.0677),(1.6349,-0.8041,3.4164),(0.7009,-2.0186,5.0189),(0.6607,-2.9431,4.4412),(0.5513,-2.0752,5.0377),(1.7765,-0.9581,2.3066),(1.7818,-0.8332,2.2412),(1.7638,-1.2204,2.4267),(1.7506,-1.5305,2.5344),(1.6943,-1.795,2.6914),(1.6509,-1.9839,2.7777),(1.5844,-2.1562,3.0052),(1.5478,-2.1956,3.1349),(1.4231,-2.2415,3.6329),(1.2374,-2.3448,4.1605),(1.0258,-2.4462,4.5339),(0.9501,-2.4961,4.5993),(0.8326,-2.5322,4.658),(0.6763,-2.5378,4.6742),(0.5211,-2.5315,4.7116),(1.7856,-1.4308,2.2596),(1.7862,-1.233,2.2174),(1.7629,-1.7632,2.3546),(1.7353,-2.1487,2.4434),(1.6822,-2.4408,2.5424),(1.6316,-2.679,2.628),(1.5697,-2.8401,2.8061),(1.5288,-2.8686,2.9528),(1.4074,-2.8032,3.4543),(1.2295,-2.784,3.9907),(1.0161,-2.769,4.3803),(0.9422,-2.7841,4.4481),(0.8223,-2.8067,4.4991),(0.6668,-2.8045,4.5137),(0.5072,-2.7498,4.5342),(1.806,-0.6008,2.1668),(-1.8342,-0.2381,2.1872),(-1.8068,-0.5594,2.1448),(-1.8055,-0.6103,2.2261),(-1.8359,-0.4178,2.2367),(-1.8406,-0.9383,2.215),(-1.8189,-0.8005,2.223),(-1.8329,-1.1999,2.1978),(-1.8043,-0.0919,2.263),(-1.8046,-0.2276,2.2524),(-1.8325,-0.2287,2.1435),(-1.8378,-0.5435,2.1145),(-1.8389,-1.3976,2.1776),(-1.857,-1.0264,2.1226),(-1.8562,-0.8586,2.0948),(-1.8338,-0.3614,2.0727),(-1.8369,-0.5582,2.0453),(-1.8273,0.0258,2.1345),(-1.8273,-0.1172,2.0672),(-1.8305,-0.166,2.102),(-1.8275,0.0785,2.1796),(-1.8297,-0.2596,2.0452),(-1.8323,-0.4028,2.0244),(-1.8273,-0.1976,2.0333),(-1.8155,-1.3898,2.2346),(-1.8062,-1.7232,2.3288),(-1.7935,-2.1097,2.4166),(-1.7527,-2.4037,2.516),(-1.7123,-2.6436,2.602),(-1.6609,-2.8071,2.7812),(-1.6253,-2.8376,2.9289),(-1.5171,-2.7778,3.4342),(-1.3513,-2.7624,3.9728),(-1.1504,-2.7552,4.3682),(-1.0802,-2.7739,4.4389),(-0.9639,-2.8019,4.4948),(-0.8093,-2.8062,4.5153),(-0.6481,-2.7587,4.543),(-0.654,-2.6545,4.639),(-0.6415,-2.8826,4.4758),(-0.8054,-2.9455,4.4434),(-0.9637,-2.9446,4.4238),(-1.0844,-2.9226,4.3709),(-1.1571,-2.9201,4.2974),(-1.3599,-2.9852,3.8912),(-1.5256,-3.06,3.3471),(-1.6341,-3.1751,2.8391),(-1.6748,-3.1401,2.6705),(-1.7187,-3.0014,2.5417),(-1.7648,-2.7274,2.4435),(-1.8048,-2.4192,2.3718),(-1.8179,-1.9837,2.2909),(-1.8306,-1.6034,2.2057),(-1.8184,-0.9256,2.2881),(-1.8153,-1.1886,2.4076),(-1.792,-1.4916,2.5099),(-1.7488,-1.7583,2.6673),(-1.7141,-1.9489,2.7541),(-1.6599,-2.1238,2.9827),(-1.6285,-2.1648,3.1133),(-1.5205,-2.2165,3.6146),(-1.3487,-2.3239,4.1445),(-1.1524,-2.4329,4.5233),(-1.0818,-2.4865,4.5915),(-0.9685,-2.5279,4.6549),(-0.8141,-2.54,4.6771),(-0.6602,-2.5404,4.7206),(-0.6664,-2.4266,4.8023),(-0.6725,-2.3123,4.884),(-0.6788,-2.1982,4.9655),(-1.8346,0.1445,2.2834),(-1.8146,-0.0564,2.3678),(-1.848,0.174,2.3978),(-1.8255,-0.0927,2.5168),(-1.8622,0.164,2.5557),(-1.8144,-0.1942,2.6621),(-1.8512,0.1107,2.7121),(-1.7668,-0.4274,2.954),(-1.802,-0.1071,3.0339),(-1.746,-0.5211,3.0481),(-1.6801,-0.7723,3.3981),(-1.6999,-0.488,3.5866),(-1.6612,-0.8216,3.4878),(-1.5472,-1.0966,3.9759),(-1.5852,-0.8192,4.0734),(-1.3651,-1.4513,4.4925),(-1.3994,-1.2372,4.5887),(-1.1797,-1.7949,4.8459),(-1.2144,-1.6421,4.9381),(-1.1044,-1.9218,4.9132),(-1.1343,-1.7909,5.0098),(-0.9885,-1.9935,4.9959),(-1.0084,-1.8747,5.1038),(-0.8315,-2.0216,5.023),(-0.8434,-1.9087,5.1345),(-0.685,-2.0842,5.0472),(-0.6913,-1.9701,5.1289),(-0.5554,-2.1184,5.0103),(-0.7656,-1.9654,5.1972),(-0.7221,-2.98,4.4795),(-0.8623,-2.0181,5.2452),(-0.8182,-3.0612,4.506),(-1.4051,-3.0074,3.8924),(-1.2024,-2.9453,4.2979),(-1.57079,-3.0834,3.3482),(-1.6795,-3.1996,2.8388),(-1.7207,-3.1633,2.6684),(-1.766,-3.0216,2.5384),(-1.813,-2.7442,2.44),(-1.8536,-2.4306,2.3685),(-1.8669,-1.9906,2.2886),(-1.8793,-1.6089,2.2032),(-1.8878,-1.4026,2.1752),(-1.9063,-1.0325,2.1211),(-1.9052,-0.8644,2.0934),(-1.8863,-0.5644,2.0437),(-1.8823,-0.4079,2.0225),(-1.8788,-0.2084,2.0363),(-1.877,-0.1192,2.065),(-1.8767,0.0246,2.132),(-1.8769,0.0783,2.1781),(-1.8838,0.1451,2.2835),(-1.8973,0.1747,2.4011),(-1.9108,0.1649,2.5629),(-1.8986,0.1106,2.723),(-1.8485,-0.1078,3.047),(-1.7461,-0.4881,3.599),(-1.6313,-0.8197,4.0855),(-1.4491,-1.238,4.606),(-1.2602,-1.6427,4.9513),(-1.1904,-1.7921,5.0231),(-1.0665,-1.8996,5.1252),(-0.9129,-2.0309,5.24),(-1.0259,-2.9909,4.4346),(-0.8592,-3.0729,4.5091),(-1.1296,-2.9487,4.3701),(-1.4643,-2.9903,3.905),(-1.2642,-2.9315,4.305),(-1.6278,-3.0649,3.3691),(-1.7351,-3.1823,2.8688),(-1.7745,-3.1491,2.7029),(-1.8182,-3.0126,2.5767),(-1.8635,-2.7411,2.4809),(-1.9029,-2.4331,2.411),(-1.916,-2.0025,2.332),(-1.9368,-1.4272,2.2164),(-1.9283,-1.6283,2.245),(-1.9537,-0.9037,2.1365),(-1.9545,-1.0681,2.1641),(-1.9302,-0.4527,2.0635),(-1.935,-0.6078,2.0861),(-1.925,-0.1657,2.0993),(-1.9255,-0.2531,2.0728),(-1.9254,0.0318,2.2037),(-1.9249,-0.0218,2.161),(-1.9425,0.0668,2.2335),(-1.9451,0.0888,2.2671),(-1.932,0.0991,2.304),(-1.945,0.1293,2.4169),(-1.9595,0.1206,2.5743),(-1.9486,0.0682,2.7296),(-1.9001,-0.147,3.0511),(-1.7994,-0.523,3.5977),(-1.6863,-0.851,4.0779),(-1.5066,-1.2639,4.5912),(-1.3207,-1.662,4.9318),(-1.2421,-1.8072,5.0066),(-1.1208,-1.9258,5.1046),(-0.9606,-2.0583,5.208),(-1.0901,-2.9802,4.442),(-0.9227,-3.061,4.5146),(-1.1927,-2.9361,4.3771),(-1.6517,-2.8219,3.5075),(-1.6553,-2.7424,3.5419),(-1.4894,-2.7671,4.0253),(-1.4846,-2.8284,4.0004),(-1.7657,-2.7275,3.1052),(-1.7686,-2.6372,3.1405),(-1.8896,-2.3137,2.6488),(-1.8901,-2.2224,2.6814),(-1.9373,-1.8506,2.2898),(-1.9413,-1.7258,2.2632),(-1.9702,-0.7949,2.117),(-1.9686,-0.6946,2.1028),(-1.962,-1.0328,2.3625),(-1.9628,-1.0973,2.3478),(-1.12,-2.5264,4.7258),(-1.1209,-2.4984,4.7419),(-0.9617,-2.606,4.8224),(-1.2341,-2.4509,4.655),(-1.235,-2.421,4.6702),(-1.3197,-2.3829,4.5854),(-1.3221,-2.3475,4.6023),(-1.4981,-2.2516,4.2462),(-1.503,-2.2014,4.2625),(-1.6736,-2.0943,3.7843),(-1.6761,-2.0345,3.7944),(-1.7883,-1.8806,3.3315),(-1.7966,-1.8139,3.3426),(-1.912,-1.5109,2.7673),(-1.9118,-1.4476,2.7794),(-0.9471,-2.4489,4.9232),(-0.9508,-2.5058,4.8899),(-1.1243,-2.4029,4.7989),(-1.1118,-2.3663,4.8103),(-1.2397,-2.3167,4.7239),(-1.2254,-2.2795,4.7358),(-1.3231,-2.227,4.6553),(-1.3081,-2.1868,4.6672),(-1.5019,-2.0292,4.3149),(-1.4901,-1.9744,4.3288),(-1.6854,-1.827,3.8422),(-1.6606,-1.7576,3.84),(-1.8032,-1.5844,3.3532),(-1.7872,-1.5106,3.3564),(-1.9171,-1.2116,2.7799),(-1.9001,-1.1411,2.7901),(-1.9378,-0.7155,2.3577),(-1.9554,-0.7749,2.3398),(-1.9447,-0.3912,2.0697),(-1.9257,-0.319,2.0725),(-1.9676,-0.1517,2.4168),(-1.9679,-0.0998,2.4465),(-1.9186,-0.3779,2.8709),(-1.9187,-0.4335,2.8432),(-1.8152,-0.7481,3.4577),(-1.8151,-0.8087,3.4298),(-1.6938,-1.0923,3.982),(-1.6929,-1.1416,3.9638),(-1.5158,-1.4808,4.5003),(-1.5162,-1.5351,4.4726),(-1.331,-1.8326,4.8458),(-1.332,-1.8726,4.82),(-1.2536,-1.9672,4.9176),(-1.2538,-2.0047,4.8928),(-1.137,-2.0782,5.005),(-1.134,-2.1166,4.9808),(-0.9737,-2.1496,5.1379),(-0.9704,-2.2221,5.0812),(-1.9128,-0.7778,2.7954),(-1.9131,-0.8483,2.7788),(-1.961,-0.4319,2.3554),(-1.9616,-0.3786,2.3788),(-1.9424,-0.1062,2.1133),(-1.9422,-0.0581,2.134),(-1.8052,-1.1725,3.3706),(-1.8045,-1.2469,3.3574),(-1.6838,-1.452,3.8944),(-1.6831,-1.5199,3.8798),(-1.5101,-1.7578,4.4011),(-1.5094,-1.8132,4.3819),(-1.3267,-2.038,4.7434),(-1.3266,-2.0769,4.7232),(-1.2456,-2.1507,4.8135),(-1.2453,-2.1854,4.7936),(-1.1301,-2.2497,4.8924),(-1.1284,-2.2828,4.8723),(-0.9663,-2.3176,5.0117),(-0.9635,-2.3825,4.9657),(-1.897,-1.8517,2.7512),(-1.8956,-1.9489,2.7374),(-1.9458,-1.466,2.3177),(-1.9455,-1.4015,2.3422),(-1.9703,-1.2984,2.2008),(-1.9725,-1.1782,2.1803),(-1.7795,-2.2102,3.2778),(-1.7767,-2.3112,3.2523),(-1.667,-2.3727,3.6979),(-1.6633,-2.4786,3.6604),(-1.4966,-2.4148,4.1835),(-1.4919,-2.4842,4.1626),(-1.3184,-2.5018,4.5288),(-1.3128,-2.5695,4.4995),(-1.2298,-2.5549,4.6013),(-1.2271,-2.6125,4.5711),(-1.1168,-2.6238,4.6696),(-1.1153,-2.6787,4.6375),(-0.9562,-2.748,4.7328),(-1.0953,-2.8674,4.5132),(-0.9395,-3.0111,4.5589),(-1.1059,-2.9337,4.482),(-1.2128,-2.8829,4.4183),(-1.2045,-2.8103,4.4525),(-1.2781,-2.8646,4.3434),(-1.2768,-2.7858,4.3801),(-1.4795,-2.6807,4.0549),(-0.9391,-2.8523,4.6564),(-1.1001,-2.7501,4.5849),(-1.2084,-2.6887,4.5211),(-1.9497,-0.2039,2.3905),(-1.9016,-0.4961,2.8155),(-1.9505,-0.0481,2.4791),(-1.9019,-0.306,2.9088),(-1.7979,-0.875,3.4002),(-1.7986,-0.6735,3.4937),(-1.6758,-1.199,3.9386),(-1.6777,-1.0167,4.0137),(-1.5,-1.5876,4.4429),(-1.4989,-1.4247,4.5256),(-1.3169,-1.9085,4.7908),(-1.3143,-1.7881,4.8686),(-1.2389,-2.0355,4.8644),(-1.238,-1.9231,4.9384),(-1.1177,-2.146,4.9519),(-1.1261,-2.0317,5.0245),(-1.9553,-0.653,2.3783),(-1.9685,-0.8246,2.3323),(-1.9069,-1.0712,2.7973),(-1.9172,-1.2718,2.7697),(-1.7981,-1.4404,3.3582),(-1.8018,-1.6491,3.3479),(-1.6792,-1.6894,3.8512),(-1.6836,-1.8881,3.8329),(-1.5081,-1.9299,4.345),(-1.5007,-2.0798,4.3013),(-1.3248,-2.16,4.6861),(-1.3223,-2.2606,4.6398),(-1.2407,-2.259,4.7558),(-1.2389,-2.3462,4.7083),(-1.1266,-2.3486,4.8308),(-1.1235,-2.431,4.7836),(-1.9384,-1.3323,2.3696),(-1.9287,-1.5305,2.2899),(-1.8803,-1.791,2.7567),(-1.8775,-2.023,2.7193),(-1.7642,-2.1478,3.2882),(-1.7566,-2.4156,3.2188),(-1.6522,-2.3167,3.7108),(-1.6427,-2.5551,3.6306),(-1.4829,-2.3624,4.1944),(-1.4687,-2.5692,4.1307),(-1.3049,-2.4608,4.5399),(-1.2892,-2.6598,4.4525),(-1.2168,-2.5171,4.6122),(-1.1038,-2.5861,4.681),(-0.946,-2.6596,4.7771),(-1.8735,-2.1557,2.7023),(-1.7538,-2.5468,3.1711),(-1.8687,-2.3923,2.6343),(-1.4648,-2.8686,3.9793),(-1.6305,-2.8832,3.4806),(-1.6414,-2.6782,3.565),(-1.1054,-2.5447,4.7052),(-1.1083,-2.4615,4.7533),(-0.95,-2.5542,4.8448),(-1.2189,-2.4723,4.6352),(-1.2222,-2.3833,4.6829),(-1.3023,-2.4117,4.5668),(-1.3067,-2.3054,4.612),(-1.4791,-2.2966,4.2298),(-1.4886,-2.1468,4.2729),(-1.6541,-2.1685,3.7648),(-1.6666,-1.9688,3.8047),(-1.7692,-1.9666,3.3187),(-1.7811,-1.7462,3.3456),(-1.8849,-1.6012,2.7496),(-1.8946,-1.384,2.7904),(-1.9464,-1.1663,2.331),(-1.9441,-0.973,2.3761),(-1.1186,-2.2005,4.9122),(-1.1131,-2.3004,4.8516),(-1.2312,-2.1022,4.8336),(-1.2303,-2.2051,4.7734),(-1.3112,-1.9859,4.7642),(-1.3102,-2.1023,4.704),(-1.4943,-1.6887,4.4214),(-1.4922,-1.8539,4.3637),(-1.6677,-1.3771,3.9084),(-1.6653,-1.5818,3.8645),(-1.7887,-1.0914,3.3847),(-1.7873,-1.3152,3.3446),(-1.8955,-0.7057,2.8109),(-1.8964,-0.9178,2.7617),(-1.9448,-0.3272,2.403),(-1.9432,-0.487,2.3327),(-1.7502,-2.7941,3.0585),(-0.4375,-2.2483,5.3288),(-0.3838,-2.3559,5.2988),(-0.5086,-2.4592,5.3534),(-0.5771,-2.327,5.3942),(-0.3711,-2.2724,5.2716),(-0.6505,-2.3462,5.3938),(-0.5833,-2.4875,5.3542),(-0.3229,-2.9921,4.6332),(-0.3925,-3.0747,4.6262),(-0.3554,-3.02,4.7067),(-0.5216,-3.1635,4.6872),(-0.472,-3.0985,4.7862),(-0.6014,-3.1748,4.6986),(-0.5443,-3.1196,4.7958),(-0.3587,-2.7671,4.6909),(-0.3846,-2.2609,5.1101),(-0.5308,-2.6706,4.6088),(-0.5539,-2.8466,5.0335),(-1.5606,-1.705,3.7888),(-1.5633,-1.6125,3.8192),(-1.3828,-1.8467,4.3464),(-1.3807,-1.9363,4.3102),(-1.8232,-1.4562,2.39),(-1.8259,-1.4708,2.3447),(-1.8422,-1.2155,2.2606),(-1.8402,-1.1049,2.2714),(-1.8098,-1.7928,2.4878),(-1.816,-1.8103,2.4432),(-1.7666,-2.0729,2.6178),(-1.7765,-2.092,2.5745),(-1.7336,-2.2731,2.6899),(-1.7415,-2.3027,2.6501),(-1.6796,-2.4531,2.9052),(-1.6796,-2.4997,2.8914),(-1.649,-2.4796,3.0322),(-1.6489,-2.5265,3.0193),(-1.5419,-2.4753,3.5311),(-1.5383,-2.5238,3.5284),(-0.8148,-2.6639,4.6254),(-0.8139,-2.7049,4.6004),(-0.9731,-2.6961,4.5787),(-0.9739,-2.6546,4.603),(-1.0944,-2.6598,4.517),(-1.0946,-2.6171,4.5396),(-1.1686,-2.6217,4.4454),(-1.1689,-2.5779,4.4664),(-1.3675,-2.5709,4.0624),(-1.3723,-2.5231,4.0695),(-0.9889,-2.2939,4.8324),(-0.9903,-2.2536,4.8582),(-0.8288,-2.275,4.8847),(-0.8276,-2.3148,4.8583),(-1.1152,-2.2321,4.7524),(-1.1092,-2.195,4.783),(-1.1915,-2.1393,4.681),(-1.1871,-2.1015,4.7113),(-1.6799,-1.5165,3.3046),(-1.6812,-1.4699,3.3176),(-1.7089,-1.4621,3.1802),(-1.7076,-1.4196,3.2039),(-1.7682,-1.2714,2.908),(-1.764,-1.2366,2.9428),(-1.7982,-1.1213,2.8112),(-1.7832,-1.0933,2.8419),(-1.8317,-0.8529,2.5716),(-1.8292,-0.8217,2.6091),(-1.8411,-0.6452,2.4368),(-1.8421,-0.6147,2.4742),(-1.8363,-0.5096,2.3171),(-1.837,-0.4446,2.3233),(-1.3603,-2.0834,4.2449),(-1.3563,-2.1276,4.2257),(-1.5331,-1.9579,3.7021),(-1.5371,-1.9119,3.7179),(-1.1639,-2.2526,4.6162),(-1.1585,-2.295,4.5926),(-1.0922,-2.3257,4.6859),(-1.0881,-2.366,4.6604),(-0.9767,-2.3763,4.7563),(-0.9739,-2.4145,4.7273),(-0.8204,-2.3932,4.7805),(-0.8187,-2.4303,4.7498),(-1.6362,-1.8525,3.2002),(-1.6395,-1.8058,3.2135),(-1.6664,-1.8047,3.0717),(-1.6673,-1.7617,3.0951),(-1.7244,-1.6183,2.8141),(-1.7308,-1.5819,2.8565),(-1.7663,-1.4456,2.7295),(-1.7629,-1.4193,2.7704),(-1.8103,-1.1829,2.5387),(-1.8103,-1.1567,2.5801),(-1.8211,-0.9158,2.4146),(-1.8254,-0.8914,2.4564),(-1.8079,-0.7415,2.2973),(-1.8139,-0.6622,2.3041),(-1.3627,-1.6492,4.4222),(-1.3661,-1.6924,4.4009),(-1.5411,-1.4003,3.8781),(-1.5399,-1.3539,3.8925),(-1.1694,-1.9369,4.7829),(-1.1794,-1.9729,4.7507),(-1.0944,-2.0452,4.8499),(-1.1056,-2.0827,4.8197),(-0.9837,-2.1066,4.9241),(-0.9843,-2.1497,4.9015),(-0.8275,-2.1309,4.9502),(-0.8271,-2.1737,4.9273),(-1.6546,-1.181,3.3882),(-1.6537,-1.134,3.4009),(-1.6798,-1.1252,3.2736),(-1.6772,-1.0806,3.2932),(-1.7417,-0.9091,2.9676),(-1.7357,-0.8715,2.9994),(-1.7672,-0.7787,2.8682),(-1.7602,-0.7445,2.9025),(-1.813,-0.528,2.6063),(-1.8076,-0.4931,2.6397),(-1.8234,-0.3769,2.4683),(-1.8205,-0.3401,2.5003),(-1.8162,-0.2834,2.3414),(-1.8129,-0.2277,2.3477),(-0.5472,-2.3025,4.8764),(-0.539,-2.4864,4.7426),(1.1988,-5.5283,3.7295),(1.1989,-5.4499,3.6756),(1.01,-5.0473,4.051),(1.0098,-5.1108,4.1073),(1.5038,-6.2263,2.417),(1.4981,-6.2141,2.4571),(1.5036,-6.565,2.4484),(1.5069,-6.476,2.4041),(1.4958,-5.8758,2.4015),(1.4879,-5.8745,2.4498),(1.4554,-5.5527,2.4887),(1.4441,-5.5534,2.5328),(1.4166,-5.2789,2.553),(1.4073,-5.2929,2.5912),(1.3499,-4.9526,2.7669),(1.3491,-4.9978,2.7805),(1.316,-4.8809,2.8636),(1.3155,-4.9262,2.8779),(1.1926,-4.7537,3.2139),(1.1956,-4.8001,3.2284),(0.6028,-4.2935,4.2641),(0.5992,-4.3165,4.2908),(0.7255,-4.3402,4.2472),(0.7284,-4.3171,4.2198),(0.8101,-4.4007,4.1683),(0.8129,-4.3757,4.1408),(0.858,-4.4636,4.0876),(0.8605,-4.4367,4.0605),(1.0129,-4.6391,3.6632),(1.0092,-4.5996,3.6423),(0.6899,-4.5589,4.4964),(0.6949,-4.5353,4.4718),(0.5588,-4.5085,4.5045),(0.5525,-4.5323,4.5279),(0.7807,-4.637,4.4272),(0.7898,-4.6186,4.3955),(0.835,-4.7436,4.3709),(0.8419,-4.7241,4.3376),(1.3503,-5.9423,3.247),(1.3529,-5.9121,3.2146),(1.3215,-5.8142,3.3133),(1.3216,-5.8522,3.3367),(1.4106,-6.2108,3.0625),(1.4164,-6.1922,3.0217),(1.4399,-6.3753,3.0183),(1.4464,-6.3617,2.976),(1.4897,-6.6894,2.8841),(1.4938,-6.6761,2.8395),(1.5038,-6.9229,2.8254),(1.5043,-6.91,2.7788),(1.5009,-7.1342,2.7404),(1.5015,-7.0783,2.7097),(0.9874,-4.9203,3.9211),(0.9903,-4.9498,3.9504),(1.1742,-5.2825,3.5434),(1.1711,-5.2459,3.5145),(0.8259,-4.6344,4.2398),(0.8271,-4.6583,4.2659),(0.7795,-4.5503,4.3054),(0.7795,-4.5715,4.3323),(0.6968,-4.4809,4.3769),(0.6949,-4.4999,4.4044),(0.5689,-4.4545,4.4103),(0.5652,-4.4733,4.4374),(1.2946,-5.5732,3.1398),(1.2933,-5.538,3.1183),(1.3252,-5.662,3.0417),(1.3267,-5.6361,3.0121),(1.3848,-5.9186,2.8665),(1.3888,-5.9022,2.8177),(1.4171,-6.1012,2.8397),(1.4219,-6.0925,2.7909),(1.4656,-6.4142,2.7477),(1.4673,-6.4072,2.6984),(1.4801,-6.6851,2.708),(1.4775,-6.68,2.6587),(1.4818,-6.9466,2.6414),(1.4771,-6.879,2.6076),(0.9898,-5.2299,4.1976),(0.9851,-5.2613,4.2286),(1.1734,-5.7419,3.8567),(1.1756,-5.7045,3.8348),(0.817,-4.8396,4.4311),(0.8053,-4.8595,4.469),(0.7631,-4.7186,4.4739),(0.7489,-4.74,4.507),(0.6676,-4.6316,4.5425),(0.6603,-4.6603,4.5669),(0.5299,-4.6042,4.5711),(0.5218,-4.6323,4.5942),(1.295,-6.13,3.4851),(1.2969,-6.0915,3.4649),(1.3207,-6.2203,3.4077),(1.3245,-6.187,3.3815),(1.385,-6.5116,3.2134),(1.3926,-6.4898,3.1763),(1.411,-6.6533,3.1663),(1.4194,-6.6353,3.127),(1.4625,-6.9701,3.0204),(1.4694,-6.9512,2.9778),(1.4771,-7.161,2.9513),(1.4816,-7.1396,2.9068),(1.4725,-7.3213,2.8499),(1.4769,-7.2733,2.8211),(0.4162,-4.5022,4.532),(0.3977,-4.5687,4.6041),(0.4335,-4.436,4.463),(0.4586,-4.311,4.3159),(1.5031,-6.7377,2.4555),(1.4753,-7.024,2.583),(1.5022,-7.1928,2.6647),(1.4675,-7.3586,2.7552),(0.4048,-3.8326,4.3884),(0.383,-3.9769,4.6102),(0.3336,-3.8536,4.3824),(0.2555,-4.1848,4.8599),(0.3332,-4.1606,4.8606),(0.6548,-4.5406,4.7456),(0.6658,-4.5,4.6887),(0.626,-4.5921,4.8234),(0.3729,-4.2679,4.9114),(0.5795,-4.6039,4.8557),(0.2987,-4.2843,4.912),(0.5305,-4.6134,4.863),(0.3222,-4.4067,4.4102),(0.3426,-4.3036,4.2875),(0.1885,-4.1811,4.3399),(0.6679,-4.0193,4.1073),(0.3849,-3.839,4.2843),(0.6342,-4.0289,4.1148),(0.718,-4.0303,4.1027),(0.4611,-3.8275,4.2913),(0.7336,-4.0562,4.1563),(0.7287,-4.1498,4.28),(0.7345,-4.2028,4.3596),(0.7165,-4.256,4.4091),(0.7226,-4.2807,4.4499),(0.7058,-4.3138,4.4739),(0.6994,-4.3347,4.5139),(0.6871,-4.3685,4.5448),(0.6895,-4.4072,4.5819),(0.6802,-4.4449,4.6232),(0.545,-4.1063,4.1189),(0.2506,-3.9375,4.2416),(0.1172,-4.2955,4.8271),(0.2111,-3.9526,4.3197),(0.1514,-4.3779,4.8701),(0.4301,-4.679,4.8357),(0.1712,-4.0045,4.2538),(0.0915,-4.379,4.8188),(0.3614,-4.7018,4.7751),(0.26,-4.6193,4.6484),(0.1142,-4.4545,4.6994),(0.2927,-4.5129,4.5249),(0.4616,-4.1845,4.137),(0.8463,-4.16,4.0549),(0.8324,-4.1357,4.0057),(0.9014,-4.1995,3.9205),(0.9181,-4.2293,3.9726),(1.1113,-4.5813,3.7092),(1.1257,-4.5027,3.5972),(1.2997,-4.5936,3.2113),(1.2973,-4.7,3.291),(0.9075,-4.3502,4.1182),(0.9092,-4.2775,4.0266),(0.9587,-4.3257,3.94),(0.9645,-4.4014,4.039),(1.6087,-6.1925,2.3479),(1.6112,-6.1199,2.2731),(1.6176,-6.3158,2.3131),(1.4169,-4.8095,2.9778),(1.4172,-4.9316,3.0305),(1.5455,-5.4204,2.6064),(1.548,-5.5539,2.6306),(1.5957,-7.6205,3.0806),(1.6053,-7.5552,3.2317),(1.6024,-7.4339,3.06),(1.5905,-7.4512,3.3506),(1.5365,-7.1392,3.5239),(1.5454,-7.0421,3.3311),(1.4209,-6.6228,3.8311),(1.4308,-6.5191,3.6798),(1.305,-6.1328,4.1569),(1.3015,-6.0054,4.0452),(1.1182,-5.5503,4.5031),(1.1147,-5.4279,4.3898),(0.9384,-5.0494,4.6945),(0.9374,-4.9584,4.5935),(0.8683,-4.8881,4.7146),(0.8674,-4.8123,4.6193),(0.7576,-4.7468,4.769),(0.775,-4.6852,4.6676),(1.6084,-7.0819,2.456),(1.602,-7.2305,2.4912),(1.6254,-6.7909,2.6108),(1.6022,-6.6452,2.6054),(1.5685,-6.2451,2.8984),(1.5474,-6.1342,2.8822),(1.4439,-5.67,3.3139),(1.4243,-5.5739,3.2749),(1.3174,-5.2671,3.6594),(1.3019,-5.1994,3.6031),(1.134,-4.9285,4.0095),(1.1208,-4.8849,3.9625),(0.9671,-4.6425,4.2773),(0.9563,-4.619,4.2456),(0.9069,-4.5445,4.3351),(0.8952,-4.5266,4.3082),(0.8258,-4.4437,4.4071),(0.8168,-4.4316,4.3805),(0.9519,-4.2273,3.8252),(1.1189,-4.2473,3.3495),(1.1158,-4.3482,3.4602),(1.2978,-4.2563,2.9632),(1.2944,-4.4106,3.0951),(1.4199,-4.2679,2.604),(1.4236,-4.5942,2.8621),(1.4633,-4.3575,2.4904),(0.8259,-4.3629,4.3045),(0.8231,-4.3836,4.3281),(0.9024,-4.4474,4.2261),(0.9006,-4.4733,4.2526),(0.9649,-4.5227,4.1517),(0.9599,-4.5507,4.1848),(1.1224,-4.7393,3.835),(1.1159,-4.7766,3.8821),(1.2988,-4.9059,3.4178),(1.2976,-5.0328,3.5121),(1.4205,-5.1898,3.1244),(1.4228,-5.369,3.1912),(1.5494,-5.773,2.7161),(1.5505,-5.9428,2.764),(1.6014,-6.3335,2.4744),(1.6085,-6.4903,2.4905),(1.6196,-6.6379,2.3612),(1.6173,-6.799,2.3964),(1.5938,-7.4065,2.5779),(1.5911,-7.4746,2.6384),(1.6071,-7.0919,2.738),(1.6201,-6.925,2.7242),(1.5531,-6.5513,2.9989),(1.5642,-6.4092,2.9895),(1.4319,-5.9849,3.404),(1.4439,-5.8641,3.3888),(1.3055,-5.5337,3.7761),(1.3203,-5.4395,3.7402),(1.1185,-5.0975,4.1229),(1.1356,-5.0387,4.0866),(0.9451,-4.7461,4.3644),(0.9625,-4.7053,4.3367),(0.8857,-4.6326,4.4123),(0.9002,-4.5952,4.3888),(0.8008,-4.522,4.4796),(0.8187,-4.4903,4.456),(0.7916,-4.5819,4.5417),(0.7831,-4.6137,4.5833),(0.8763,-4.6953,4.4823),(0.8768,-4.7415,4.5231),(0.9393,-4.8227,4.4458),(0.9438,-4.8795,4.4865),(1.1167,-5.2253,4.2188),(1.1206,-5.31,4.2671),(1.3028,-5.7099,3.8626),(1.3049,-5.8669,3.9337),(1.4294,-6.1757,3.4852),(1.4353,-6.3694,3.5471),(1.5479,-6.7179,3.1049),(1.5509,-6.9028,3.1788),(1.6038,-7.2092,2.8692),(1.6071,-7.3254,2.9073),(1.5868,-7.5799,2.7582),(1.5849,-7.6118,2.8231),(1.5444,-5.1876,2.5395),(1.5463,-4.8739,2.3755),(1.585,-5.2609,2.3082),(1.6013,-5.7414,2.2537),(1.587,-7.6347,2.9526),(1.5082,-4.545,2.4272),(1.4367,-4.6486,2.9078),(1.3138,-4.4639,3.133),(1.5641,-5.2709,2.5527),(1.5537,-5.7693,2.211),(1.5635,-6.1536,2.2385),(1.622,-5.8979,2.2448),(1.625,-6.0233,2.2583),(1.6217,-7.3989,3.0071),(1.6015,-7.6394,2.9124),(1.607,-7.5227,2.6774),(1.6231,-7.1327,2.7827),(1.6222,-7.1719,2.8265),(1.6053,-7.5577,2.7176),(1.5683,-6.6049,3.0351),(1.5666,-6.6602,3.0706),(1.4478,-6.0429,3.4305),(1.4472,-6.1065,3.4573),(1.3205,-5.5895,3.8098),(1.3201,-5.6464,3.8364),(1.1346,-5.1267,4.1504),(1.134,-5.1695,4.1825),(0.9587,-4.7598,4.3872),(0.9567,-4.785,4.4144),(0.8971,-4.6403,4.4327),(0.8939,-4.6615,4.4558),(0.8116,-4.5277,4.498),(0.8084,-4.5475,4.5187),(1.6213,-6.5995,2.5738),(1.6298,-6.9967,2.4335),(1.6326,-6.9021,2.4137),(1.6235,-6.5421,2.5292),(1.5656,-6.0723,2.8426),(1.5669,-6.0187,2.8086),(1.4404,-5.5096,3.2506),(1.4394,-5.4466,3.223),(1.3166,-5.1425,3.5774),(1.3148,-5.0907,3.5488),(1.1359,-4.8396,3.9338),(1.134,-4.8068,3.9104),(0.9719,-4.5902,4.2272),(0.9733,-4.5682,4.208),(0.9104,-4.501,4.2917),(0.9122,-4.484,4.2742),(0.8315,-4.4067,4.3654),(0.8338,-4.391,4.3484),(1.3152,-4.5345,3.1788),(1.4376,-4.7314,2.9484),(1.1375,-4.4305,3.5381),(1.1342,-4.3794,3.493),(0.9623,-4.2719,3.8815),(1.563,-5.3571,2.5846),(0.8435,-4.3072,4.2512),(0.8353,-4.2717,4.1938),(0.8402,-4.3376,4.2876),(0.9186,-4.3908,4.1752),(0.9168,-4.4243,4.2116),(0.9795,-4.455,4.0974),(0.98,-4.4971,4.1361),(1.1322,-4.6435,3.7647),(1.1369,-4.699,3.8092),(1.313,-4.7607,3.3305),(1.3145,-4.8544,3.3905),(1.4355,-5.0299,3.0705),(1.4367,-5.1275,3.1057),(1.5648,-5.6219,2.6572),(1.5649,-5.7106,2.6883),(1.6239,-6.2413,2.3969),(1.6207,-6.2827,2.4329),(1.6372,-6.4277,2.325),(1.6383,-6.5386,2.3438),(0.8235,-4.4593,4.4237),(0.8083,-4.4847,4.4381),(0.9047,-4.5615,4.3528),(0.8888,-4.5871,4.3693),(0.9654,-4.6633,4.2969),(0.9492,-4.6911,4.3153),(1.1343,-4.9655,4.0356),(1.1187,-5.0076,4.0595),(1.3182,-5.3186,3.6864),(1.3026,-5.3812,3.712),(1.4444,-5.7276,3.3362),(1.427,-5.8007,3.3645),(1.5672,-6.2949,2.926),(1.5489,-6.3523,2.9549),(1.6234,-6.8322,2.644),(1.6043,-6.8778,2.681),(1.6153,-7.2833,2.521),(1.5952,-7.3472,2.551),(0.7908,-4.6517,4.6407),(0.7933,-4.6278,4.6126),(0.8847,-4.781,4.5889),(0.8878,-4.7575,4.5564),(0.955,-4.9267,4.5594),(0.9572,-4.9003,4.5239),(1.1331,-5.3859,4.3505),(1.1351,-5.3469,4.3096),(1.3199,-5.9482,3.9979),(1.3203,-5.9099,3.9698),(1.4493,-6.4644,3.6289),(1.4509,-6.4192,3.5893),(1.5642,-6.9899,3.2718),(1.5661,-6.9494,3.227),(1.6232,-7.3626,2.9561),(1.6004,-7.632,2.869),(0.8362,-4.2039,4.1033),(1.4775,-7.3802,3.0702),(1.4707,-7.4694,2.9416),(1.5434,-7.531,2.6243),(1.5388,-7.6345,2.7499),(1.5696,-6.8506,2.3667),(1.5605,-7.1384,2.4303),(1.5697,-6.3543,2.2809),(1.5723,-6.6853,2.3303),(1.5547,-7.2877,2.4687),(1.5478,-7.4622,2.5609),(0.8514,-4.1916,3.9256),(0.901,-4.2194,3.8285),(0.7827,-4.1287,4.0112),(0.7073,-4.7618,4.7918),(0.8183,-4.8958,4.7334),(0.8791,-5.0599,4.718),(1.0555,-5.571,4.5313),(1.2494,-6.1584,4.1727),(1.3671,-6.6541,3.8429),(1.4845,-7.1772,3.5358),(1.5401,-7.4935,3.3627),(1.5563,-7.6012,3.2397),(1.5479,-7.6692,3.084),(1.5389,-7.6858,2.9522),(1.5366,-7.6653,2.8184),(1.5371,-5.2844,2.2629),(1.4971,-4.8921,2.3322),(1.4503,-4.546,2.3806),(1.411,-4.359,2.4513),(1.3656,-4.2639,2.569),(1.2418,-4.2473,2.937),(1.0611,-4.2386,3.3348),(0.8139,-4.2139,3.9438),(0.8621,-4.2424,3.8454),(0.729,-4.1719,4.0241),(0.6508,-4.7931,4.7786),(0.7646,-4.9028,4.7198),(0.8349,-5.0658,4.7045),(1.0101,-5.576,4.5197),(1.2039,-6.1634,4.1603),(1.3214,-6.6588,3.8306),(1.4386,-7.1826,3.5225),(1.4931,-7.4978,3.3502),(1.5082,-7.6036,3.2302),(1.4989,-7.6703,3.0787),(1.4899,-7.6861,2.9504),(1.4873,-7.6656,2.8185),(1.4894,-7.6356,2.7514),(1.4939,-7.5325,2.6257),(1.4963,-7.4738,2.5613),(1.5049,-7.292,2.4711),(1.5113,-7.1435,2.4325),(1.5207,-6.8552,2.3685),(1.5232,-6.6901,2.3324),(1.5208,-6.3579,2.2833),(1.5147,-6.1577,2.2413),(1.5047,-5.7745,2.2136),(1.4883,-5.2943,2.2667),(1.449,-4.9077,2.3367),(1.403,-4.5654,2.3875),(1.3648,-4.382,2.4586),(1.3201,-4.2894,2.575),(1.1965,-4.2739,2.9394),(1.0168,-4.2635,3.3438),(0.4961,-4.753,4.7965),(0.8082,-4.9624,4.5666),(0.745,-4.8241,4.5905),(0.983,-5.4171,4.3596),(1.1741,-5.9463,3.9868),(1.2961,-6.3847,3.6276),(1.4637,-7.2337,3.159),(1.4114,-6.9172,3.3146),(1.4646,-7.4774,2.8221),(1.4992,-7.3747,2.6881),(1.4987,-7.4006,2.6502),(1.4969,-7.4741,2.6373),(1.5041,-7.3096,2.531),(1.5099,-7.1286,2.5012),(1.4994,-7.4127,2.5464),(0.6475,-4.731,4.6483),(1.3894,-6.8016,3.3588),(1.3167,-6.4644,3.5677),(0.5049,-4.6985,4.6713),(0.6055,-4.1566,4.0752),(0.3791,-4.635,4.6836),(1.479,-6.855,2.5067),(1.4787,-6.7202,2.5297),(1.4759,-6.4433,2.5558),(1.4637,-6.1355,2.5626),(1.4209,-5.837,2.6347),(1.3859,-5.6212,2.6773),(1.3247,-5.3285,2.8633),(1.2904,-5.2342,2.9704),(1.1693,-5.0329,3.3626),(0.9864,-4.7881,3.795),(0.8319,-4.5538,4.1604),(0.7867,-4.4813,4.2307),(0.7063,-4.4183,4.3043),(0.5809,-4.3937,4.3419),(0.4479,-4.3719,4.3912),(1.499,-6.5134,2.3492),(1.4943,-6.3346,2.3299),(1.4883,-6.0,2.3172),(1.4775,-5.6038,2.3273),(1.432,-5.2339,2.4197),(1.3914,-4.9165,2.5034),(1.3368,-4.6669,2.6432),(1.2978,-4.5875,2.7465),(1.1766,-4.5262,3.0818),(1.0013,-4.4547,3.4963),(0.8512,-4.3575,3.9611),(0.8057,-4.3135,4.047),(0.7248,-4.2649,4.1241),(0.6033,-4.2459,4.1708),(0.461,-4.2636,4.2188),(1.4783,-7.1022,2.5234),(-1.6913,-7.3515,2.6797),(-1.6545,-7.0819,2.5131),(-1.6508,-7.0032,2.572),(-1.6868,-7.1701,2.6544),(-1.6635,-6.7177,2.4408),(-1.6455,-6.8351,2.494),(-1.6468,-6.4977,2.3353),(-1.6652,-7.4541,2.8159),(-1.6614,-7.336,2.7477),(-1.6904,-7.378,2.642),(-1.6862,-7.1074,2.49),(-1.6611,-6.3393,2.2643),(-1.6758,-6.6738,2.3192),(-1.6822,-6.8352,2.3543),(-1.6882,-7.2881,2.5218),(-1.6858,-7.1232,2.4215),(-1.6933,-7.6119,2.7458),(-1.6896,-7.5102,2.619),(-1.6908,-7.4517,2.63),(-1.6947,-7.6414,2.8133),(-1.6878,-7.3913,2.5385),(-1.6861,-7.2712,2.4618),(-1.6875,-7.4522,2.554),(-1.6374,-6.3248,2.3205),(-1.6168,-5.9824,2.2958),(-1.5917,-5.5868,2.3024),(-1.5428,-5.2203,2.3971),(-1.495,-4.9036,2.4794),(-1.4369,-4.6544,2.6186),(-1.3986,-4.5754,2.7224),(-1.2856,-4.5146,3.0607),(-1.122,-4.4403,3.4793),(-0.9787,-4.3444,3.9448),(-0.9347,-4.3013,4.0319),(-0.8548,-4.255,4.1115),(-0.7344,-4.2404,4.1624),(-0.5948,-4.2631,4.2158),(-0.5978,-4.3093,4.3134),(-0.591,-4.1862,4.1337),(-0.7296,-4.152,4.066),(-0.8517,-4.1631,4.0105),(-0.9352,-4.2025,3.9275),(-0.9808,-4.2302,3.8277),(-1.1248,-4.2525,3.3245),(-1.2841,-4.2613,2.911),(-1.3952,-4.2764,2.5425),(-1.4429,-4.3631,2.4267),(-1.4924,-4.5532,2.3603),(-1.5473,-4.8946,2.3109),(-1.5946,-5.286,2.2449),(-1.6212,-5.7578,2.1894),(-1.6462,-6.1399,2.2206),(-1.6412,-6.7002,2.5156),(-1.6277,-6.4266,2.5419),(-1.6063,-6.1191,2.5465),(-1.5547,-5.8186,2.6139),(-1.5134,-5.6036,2.6556),(-1.4513,-5.3178,2.8469),(-1.4173,-5.2232,2.9539),(-1.3021,-5.0188,3.3458),(-1.1259,-4.7735,3.7808),(-0.9747,-4.5409,4.1484),(-0.9294,-4.4697,4.2199),(-0.8492,-4.4086,4.2954),(-0.7244,-4.3888,4.3377),(-0.5922,-4.3701,4.3899),(-0.5831,-4.4335,4.4625),(-0.571,-4.4996,4.5328),(-0.5578,-4.5661,4.6062),(-1.7028,-7.6602,2.9452),(-1.6753,-7.4445,2.935),(-1.7158,-7.6428,3.0729),(-1.6834,-7.3536,3.0623),(-1.728,-7.5739,3.2233),(-1.6674,-7.2067,3.1502),(-1.7133,-7.4674,3.3427),(-1.6092,-6.8906,3.3044),(-1.6534,-7.1525,3.5137),(-1.5845,-6.7754,3.3482),(-1.5069,-6.4387,3.5562),(-1.5384,-6.6249,3.8187),(-1.4856,-6.3593,3.616),(-1.3674,-5.9172,3.9729),(-1.4137,-6.1306,4.1475),(-1.1695,-5.3919,4.3473),(-1.21,-5.5473,4.508),(-0.9774,-4.9465,4.5589),(-1.0118,-5.0476,4.6969),(-0.9103,-4.8102,4.5836),(-0.9365,-4.8868,4.7129),(-0.8116,-4.7199,4.6437),(-0.8209,-4.7806,4.7743),(-0.6725,-4.6907,4.6706),(-0.6705,-4.7442,4.7966),(-0.5448,-4.6321,4.687),(-0.5331,-4.6985,4.7797),(-0.4239,-4.6215,4.656),(-0.603,-4.6722,4.8375),(-0.6687,-4.1037,4.1113),(-0.6973,-4.6043,4.8609),(-0.7545,-4.0229,4.1032),(-1.1679,-4.2262,3.314),(-1.0181,-4.206,3.8091),(-1.3325,-4.2329,2.9088),(-1.4395,-4.2492,2.5347),(-1.484,-4.3439,2.4164),(-1.5388,-4.5326,2.3518),(-1.5947,-4.8775,2.3049),(-1.6447,-5.2691,2.2377),(-1.6697,-5.7507,2.1851),(-1.6946,-6.1341,2.216),(-1.7097,-6.334,2.2601),(-1.7247,-6.6675,2.3157),(-1.7308,-6.829,2.3508),(-1.7346,-7.1161,2.4174),(-1.7357,-7.2651,2.4576),(-1.7385,-7.4388,2.5517),(-1.7389,-7.5069,2.6158),(-1.7426,-7.609,2.7425),(-1.744,-7.6392,2.8114),(-1.7518,-7.6581,2.9453),(-1.7648,-7.6397,3.0764),(-1.7763,-7.5696,3.2311),(-1.7605,-7.4614,3.3535),(-1.6996,-7.1453,3.5253),(-1.5843,-6.6182,3.8291),(-1.4594,-6.1237,4.1578),(-1.2556,-5.5401,4.5175),(-1.0562,-5.0403,4.7089),(-0.9904,-4.8781,4.7248),(-0.8768,-4.7472,4.7855),(-0.7457,-4.5931,4.852),(-0.903,-4.1179,3.9951),(-0.7876,-4.012,4.0943),(-0.9711,-4.1791,3.9076),(-1.2265,-4.2329,3.327),(-1.0691,-4.212,3.804),(-1.3855,-4.2397,2.931),(-1.495,-4.2509,2.5677),(-1.5376,-4.3402,2.4536),(-1.5906,-4.5215,2.3915),(-1.6446,-4.8575,2.3465),(-1.6932,-5.2437,2.2813),(-1.7178,-5.7207,2.2258),(-1.7573,-6.2935,2.2902),(-1.7422,-6.0983,2.2485),(-1.7777,-6.7753,2.3782),(-1.7714,-6.6185,2.3448),(-1.7817,-7.206,2.4778),(-1.7813,-7.0577,2.4409),(-1.7849,-7.4487,2.6277),(-1.783,-7.3813,2.5664),(-1.7904,-7.5839,2.8138),(-1.7888,-7.5528,2.7486),(-1.8082,-7.603,2.8593),(-1.8111,-7.61,2.9027),(-1.798,-7.6054,2.9433),(-1.8107,-7.5893,3.0708),(-1.8233,-7.5221,3.2208),(-1.8089,-7.4173,3.3391),(-1.7497,-7.1057,3.5112),(-1.6362,-6.5848,3.8147),(-1.5132,-6.0958,4.1394),(-1.3085,-5.5221,4.489),(-1.1143,-5.0279,4.6835),(-1.0395,-4.8688,4.7044),(-0.9283,-4.7299,4.7582),(-0.7947,-4.578,4.8172),(-0.9528,-4.1229,3.9879),(-0.8379,-4.0211,4.088),(-1.0211,-4.185,3.9008),(-1.4151,-4.4446,3.1021),(-1.4208,-4.5147,3.1485),(-1.257,-4.4135,3.5164),(-1.2506,-4.3631,3.471),(-1.5389,-4.624,2.8749),(-1.544,-4.7064,2.9159),(-1.6798,-5.252,2.5264),(-1.6824,-5.3379,2.559),(-1.7439,-5.8765,2.2176),(-1.752,-6.0014,2.2323),(-1.7974,-6.8776,2.396),(-1.7988,-6.9721,2.4168),(-1.7806,-6.5739,2.5534),(-1.7774,-6.521,2.5117),(-0.9769,-4.3741,4.3328),(-0.9758,-4.3896,4.35),(-0.8651,-4.2671,4.4373),(-1.0561,-4.4648,4.2566),(-1.0557,-4.4817,4.2744),(-1.118,-4.5472,4.189),(-1.1182,-4.5691,4.2086),(-1.2772,-4.7859,3.891),(-1.2805,-4.8217,3.9176),(-1.4556,-5.0743,3.5322),(-1.4594,-5.1259,3.5611),(-1.5811,-5.4294,3.2059),(-1.5843,-5.4922,3.2339),(-1.7131,-5.997,2.7883),(-1.7145,-6.0503,2.8228),(-0.8366,-4.3553,4.5342),(-0.8464,-4.3212,4.5026),(-0.972,-4.442,4.409),(-0.9584,-4.4678,4.4243),(-1.0546,-4.5417,4.3362),(-1.0404,-4.5676,4.3536),(-1.1173,-4.6416,4.2792),(-1.1028,-4.67,4.2984),(-1.2865,-4.9422,4.0155),(-1.2733,-4.9846,4.0404),(-1.4693,-5.2968,3.6674),(-1.4564,-5.3595,3.6939),(-1.5993,-5.7065,3.3205),(-1.5855,-5.7739,3.3426),(-1.728,-6.2674,2.9042),(-1.7129,-6.3252,2.9344),(-1.7778,-6.8513,2.6638),(-1.7938,-6.8055,2.6257),(-1.7979,-7.2579,2.5076),(-1.7812,-7.3222,2.5389),(-1.8242,-7.3321,2.9429),(-1.8259,-7.3677,2.9942),(-1.7629,-6.9582,3.2568),(-1.7617,-6.9181,3.2115),(-1.6415,-6.4332,3.6126),(-1.6401,-6.3885,3.5725),(-1.5135,-5.9129,3.9778),(-1.5111,-5.875,3.9493),(-1.3119,-5.3591,4.3344),(-1.311,-5.3203,4.2931),(-1.1227,-4.9061,4.5469),(-1.1229,-4.8799,4.5112),(-1.052,-4.7591,4.575),(-1.053,-4.7359,4.5423),(-0.9549,-4.633,4.6291),(-0.9555,-4.6093,4.6006),(-0.8186,-4.5262,4.7378),(-0.8258,-4.4859,4.6801),(-1.746,-6.631,3.0524),(-1.7444,-6.576,3.0163),(-1.8095,-7.1043,2.7673),(-1.8116,-7.143,2.8115),(-1.8039,-7.4957,2.6666),(-1.8051,-7.5303,2.7071),(-1.6202,-6.0777,3.4376),(-1.6176,-6.0144,3.4102),(-1.4899,-5.6183,3.8165),(-1.4873,-5.5617,3.7893),(-1.2989,-5.1446,4.1644),(-1.2968,-5.1022,4.1318),(-1.1176,-4.7623,4.3981),(-1.1176,-4.7374,4.3706),(-1.0515,-4.6409,4.4405),(-1.053,-4.6198,4.4171),(-0.964,-4.5297,4.5055),(-0.9656,-4.51,4.4844),(-0.8357,-4.4309,4.6136),(-0.8419,-4.3934,4.5716),(-1.6985,-5.6939,2.6688),(-1.6944,-5.6059,2.6367),(-1.7639,-6.2177,2.373),(-1.7638,-6.2627,2.4134),(-1.7815,-6.4081,2.3063),(-1.7866,-6.5188,2.3259),(-1.5646,-5.1076,3.0818),(-1.5593,-5.0102,3.0458),(-1.4426,-4.8356,3.3678),(-1.4365,-4.7425,3.3071),(-1.272,-4.6762,3.7858),(-1.2658,-4.6245,3.7448),(-1.1193,-4.4768,4.1163),(-1.1157,-4.4352,4.0773),(-1.0561,-4.4056,4.1933),(-1.0551,-4.3725,4.1566),(-0.9789,-4.3212,4.2713),(-0.9797,-4.2913,4.2345),(-0.8706,-4.1899,4.3458),(-0.9628,-4.1899,4.0859),(-0.8564,-4.0456,4.1412),(-0.9694,-4.1462,4.0368),(-1.0408,-4.2135,3.9526),(-1.0359,-4.2614,4.0074),(-1.0834,-4.2554,3.8603),(-1.084,-4.3086,3.9195),(-1.2494,-4.4855,3.5764),(-0.8598,-4.138,4.2659),(-0.9679,-4.2567,4.1771),(-1.0404,-4.333,4.0996),(-1.805,-7.296,2.8943),(-1.7431,-6.8726,3.1635),(-1.8098,-7.4029,3.0482),(-1.7481,-7.0104,3.3173),(-1.6212,-6.3397,3.5305),(-1.6269,-6.488,3.6647),(-1.4924,-5.8331,3.9134),(-1.4996,-5.9702,4.0265),(-1.2936,-5.2846,4.2508),(-1.2965,-5.4012,4.3747),(-1.1076,-4.86,4.474),(-1.1072,-4.9381,4.5819),(-1.0401,-4.7206,4.5092),(-1.0352,-4.7924,4.6051),(-0.9437,-4.596,4.5716),(-0.9415,-4.6668,4.6568),(-1.7968,-6.8974,2.7069),(-1.7931,-6.7645,2.5921),(-1.7314,-6.3811,2.969),(-1.7265,-6.2181,2.8761),(-1.6055,-5.8363,3.3669),(-1.5961,-5.6492,3.2975),(-1.4767,-5.417,3.7221),(-1.4661,-5.2455,3.64),(-1.2923,-5.0149,4.0671),(-1.2839,-4.9057,3.9891),(-1.1174,-4.6832,4.3195),(-1.1173,-4.6211,4.2592),(-1.0528,-4.5751,4.3727),(-1.0555,-4.5248,4.3183),(-0.9696,-4.4727,4.4419),(-0.9731,-4.4265,4.3923),(-1.7473,-6.3138,2.4558),(-1.7451,-6.1701,2.3241),(-1.6836,-5.7489,2.69),(-1.6747,-5.5347,2.6072),(-1.5508,-5.1702,3.1014),(-1.5369,-4.913,3.0055),(-1.4293,-4.8872,3.396),(-1.4143,-4.6772,3.2629),(-1.2601,-4.7159,3.812),(-1.2411,-4.5636,3.6894),(-1.1064,-4.5058,4.1358),(-1.0964,-4.3829,4.0189),(-1.0437,-4.4319,4.2114),(-0.9663,-4.3469,4.2889),(-0.8565,-4.2433,4.3964),(-1.6674,-5.4016,2.5818),(-1.5313,-4.7914,2.9519),(-1.6572,-5.1696,2.5131),(-1.2301,-4.3327,3.4386),(-1.3924,-4.3926,3.0645),(-1.4087,-4.574,3.1822),(-0.9654,-4.3697,4.3153),(-0.9627,-4.415,4.3659),(-0.8505,-4.3006,4.4621),(-1.0436,-4.4576,4.2382),(-1.0421,-4.5076,4.2917),(-1.1033,-4.5335,4.1693),(-1.1045,-4.5982,4.2278),(-1.2574,-4.7564,3.8631),(-1.2675,-4.8631,3.9422),(-1.4348,-5.0133,3.4914),(-1.4467,-5.1829,3.5875),(-1.5606,-5.3485,3.1697),(-1.5704,-5.5566,3.2591),(-1.6931,-5.922,2.7436),(-1.6988,-6.105,2.8548),(-1.7596,-6.47,2.4731),(-1.7644,-6.6199,2.5861),(-0.9494,-4.5643,4.5294),(-0.9539,-4.5049,4.4664),(-1.0363,-4.6749,4.4681),(-1.0406,-4.6128,4.3971),(-1.1014,-4.8014,4.4293),(-1.1027,-4.7245,4.3481),(-1.2849,-5.2005,4.2018),(-1.2787,-5.0738,4.1047),(-1.4787,-5.682,3.8476),(-1.4658,-5.5113,3.7592),(-1.606,-6.1472,3.4668),(-1.5985,-5.9574,3.3837),(-1.7307,-6.689,3.088),(-1.726,-6.5234,2.9802),(-1.7962,-7.1804,2.8552),(-1.7904,-7.0644,2.7229),(-1.5199,-4.574,2.8287),(-0.314,-4.382,4.8792),(-0.275,-4.3016,4.8367),(-0.4099,-4.1851,4.8633),(-0.4589,-4.2822,4.9147),(-0.2524,-4.3862,4.8302),(-0.5323,-4.2631,4.9112),(-0.4866,-4.158,4.8608),(-0.2964,-4.0152,4.2589),(-0.3725,-3.9452,4.2432),(-0.3365,-3.9609,4.3229),(-0.5043,-3.8409,4.2799),(-0.4572,-3.8565,4.38),(-0.5802,-3.8264,4.2839),(-0.5278,-3.8328,4.3831),(-0.3238,-4.1899,4.3461),(-0.2736,-4.4619,4.7108),(-0.4807,-4.3068,4.2892),(-0.5198,-3.9751,4.607),(-1.3555,-5.4328,3.6642),(-1.3606,-5.5057,3.7129),(-1.1701,-5.0912,4.0931),(-1.1659,-5.0284,4.0362),(-1.6399,-6.1978,2.4408),(-1.644,-6.2069,2.3972),(-1.6551,-6.4598,2.3896),(-1.6559,-6.5483,2.4348),(-1.6164,-5.8557,2.4271),(-1.6226,-5.8572,2.3786),(-1.5638,-5.5354,2.5084),(-1.5735,-5.5348,2.4639),(-1.5239,-5.2832,2.5718),(-1.5327,-5.2645,2.5312),(-1.4634,-4.9835,2.7583),(-1.4625,-4.9385,2.7443),(-1.4306,-4.912,2.8561),(-1.4292,-4.8669,2.8414),(-1.3173,-4.7864,3.2089),(-1.3125,-4.7403,3.1941),(-0.7375,-4.3096,4.2832),(-0.7392,-4.2869,4.2561),(-0.8639,-4.3059,4.2074),(-0.863,-4.3288,4.2352),(-0.9478,-4.3619,4.126),(-0.947,-4.3869,4.1538),(-0.9948,-4.4221,4.0445),(-0.9944,-4.4486,4.072),(-1.1409,-4.5881,3.6291),(-1.1461,-4.6273,3.6501),(-0.8469,-4.5244,4.4642),(-0.8435,-4.5478,4.4892),(-0.7072,-4.5251,4.5256),(-0.711,-4.5018,4.5008),(-0.9422,-4.6051,4.3857),(-0.9347,-4.6236,4.4178),(-0.996,-4.7094,4.327),(-0.9908,-4.7288,4.3608),(-1.4788,-5.7917,3.2954),(-1.4811,-5.8295,3.3191),(-1.5102,-5.8895,3.1965),(-1.5099,-5.9194,3.2294),(-1.577,-6.1692,3.0043),(-1.5734,-6.1877,3.0455),(-1.6116,-6.3382,2.9592),(-1.6071,-6.3514,3.0018),(-1.6656,-6.652,2.8243),(-1.6636,-6.665,2.8691),(-1.6825,-6.8861,2.7656),(-1.6842,-6.8984,2.8122),(-1.6834,-7.055,2.6982),(-1.686,-7.1107,2.7295),(-1.139,-4.9329,3.9354),(-1.134,-4.9039,3.906),(-1.3157,-5.235,3.5048),(-1.3206,-5.2711,3.5339),(-0.9768,-4.6447,4.2553),(-0.974,-4.6212,4.229),(-0.9286,-4.5571,4.3199),(-0.9269,-4.5362,4.2929),(-0.844,-4.4881,4.3945),(-0.8442,-4.4693,4.3668),(-0.7142,-4.4671,4.4332),(-0.7164,-4.4484,4.4059),(-1.4336,-5.519,3.0988),(-1.4373,-5.557,3.1238),(-1.4667,-5.6168,2.9925),(-1.4677,-5.6457,3.0256),(-1.5319,-5.886,2.8018),(-1.5298,-5.902,2.8509),(-1.57,-6.0753,2.7756),(-1.5669,-6.0838,2.8246),(-1.6242,-6.386,2.6816),(-1.6246,-6.3923,2.7309),(-1.6431,-6.6585,2.6442),(-1.6476,-6.6631,2.6934),(-1.6482,-6.858,2.5951),(-1.6565,-6.925,2.6293),(-1.1575,-5.2407,4.2194),(-1.1597,-5.2095,4.1878),(-1.3523,-5.6777,3.8181),(-1.3525,-5.7149,3.8406),(-0.968,-4.8447,4.4607),(-0.9779,-4.8248,4.4223),(-0.9088,-4.7269,4.4994),(-0.9213,-4.7053,4.4657),(-0.8195,-4.6496,4.5613),(-0.825,-4.6208,4.5365),(-0.6839,-4.6247,4.5923),(-0.69,-4.5966,4.5687),(-1.4698,-6.068,3.4505),(-1.47,-6.1064,3.4712),(-1.4979,-6.1634,3.3671),(-1.4963,-6.1965,3.3938),(-1.5697,-6.4659,3.1626),(-1.5643,-6.4875,3.2001),(-1.6,-6.6107,3.1138),(-1.5938,-6.6286,3.1535),(-1.6563,-6.9262,2.966),(-1.6516,-6.9449,3.009),(-1.6729,-7.1149,2.8966),(-1.6707,-7.136,2.9414),(-1.67,-7.2496,2.8124),(-1.6685,-7.2975,2.8418),(-0.4479,-4.5153,4.5304),(-0.4689,-4.4092,4.4136)]),
          texCoord=TextureCoordinate(point=[(0.3735,0.9441),(0.3289,0.9315),(0.3298,0.9307),(0.3729,0.9433),(0.2722,0.9078),(0.2732,0.9075),(0.2959,0.9178),(0.2961,0.9187),(0.2206,0.8739),(0.2216,0.8736),(0.2405,0.8871),(0.2403,0.8872),(0.41,0.9518),(0.4083,0.9524),(0.2384,0.3907),(0.2392,0.3904),(0.2983,0.384),(0.2979,0.3841),(0.3615,0.3856),(0.3613,0.3857),(0.4122,0.3874),(0.2005,0.3989),(0.2507,0.5659),(0.2525,0.5665),(0.244,0.5815),(0.2424,0.5811),(0.2507,0.5575),(0.2526,0.5572),(0.2383,0.5447),(0.2397,0.544),(0.2335,0.5319),(0.235,0.5315),(0.2337,0.5085),(0.2353,0.5082),(0.2386,0.4852),(0.2404,0.4845),(0.2466,0.6055),(0.245,0.6053),(0.2364,0.6331),(0.2347,0.6321),(0.2336,0.4682),(0.2354,0.4672),(0.224,0.4542),(0.2264,0.454),(0.2097,0.4441),(0.2108,0.4425),(0.1834,0.4342),(0.227,0.4086),(0.1824,0.4354),(0.1598,0.785),(0.1599,0.7848),(0.1718,0.7482),(0.197,0.4034),(0.2354,0.3943),(0.242,0.581),(0.25,0.5655),(0.2501,0.5574),(0.2376,0.5445),(0.2381,0.4852),(0.2328,0.4682),(0.2232,0.4544),(0.3582,0.8759),(0.3599,0.886),(0.3156,0.8797),(0.3105,0.8683),(0.4093,0.8812),(0.4109,0.8901),(0.218,0.7759),(0.2173,0.8121),(0.188,0.8053),(0.2944,0.3883),(0.3588,0.3903),(0.2184,0.7188),(0.2615,0.7864),(0.2652,0.829),(0.2552,0.7274),(0.2117,0.6588),(0.2412,0.6634),(0.3525,0.403),(0.2858,0.4024),(0.3293,0.447),(0.2484,0.453),(0.3891,0.5112),(0.3179,0.507),(0.2553,0.4812),(0.2481,0.5075),(0.2457,0.5306),(0.3117,0.5282),(0.3842,0.5244),(0.3152,0.5853),(0.3098,0.5593),(0.3162,0.6101),(0.3252,0.6753),(0.3337,0.7398),(0.3995,0.7451),(0.3446,0.8076),(0.2826,0.7917),(0.295,0.8363),(0.3483,0.8477),(0.3543,0.8673),(0.3051,0.8591),(0.4069,0.8159),(0.4029,0.8541),(0.2702,0.8483),(0.2195,0.8267),(0.2725,0.8547),(0.1852,0.8075),(0.2764,0.8646),(0.2312,0.8423),(0.2107,0.6488),(0.2559,0.6068),(0.2442,0.6377),(0.2532,0.5885),(0.259,0.5713),(0.2568,0.5578),(0.2383,0.6431),(0.2476,0.5439),(0.31,0.5437),(0.3339,0.9039),(0.2958,0.8918),(0.4237,0.9165),(0.3759,0.9105),(0.4359,0.9414),(0.3563,0.9252),(0.3137,0.912),(0.3946,0.9348),(0.2105,0.8289),(0.2813,0.8868),(0.2501,0.8705),(0.2354,0.862),(0.2145,0.8489),(0.2885,0.9026),(0.2603,0.8891),(0.2383,0.8778),(0.2185,0.8652),(0.2098,0.8671),(0.21,0.8672),(0.1849,0.8395),(0.1848,0.8397),(0.1685,0.8083),(0.1685,0.808),(0.182,0.8195),(0.1742,0.8197),(0.1742,0.8194),(0.184,0.8301),(0.2083,0.8448),(0.209,0.8599),(0.3729,0.9433),(0.3298,0.9307),(0.2959,0.9178),(0.2732,0.9075),(0.2405,0.8871),(0.2216,0.8736),(0.41,0.9518),(0.2979,0.3841),(0.2384,0.3907),(0.3613,0.3857),(0.2424,0.5811),(0.244,0.5815),(0.2525,0.5665),(0.2507,0.5659),(0.2526,0.5572),(0.2507,0.5575),(0.2397,0.544),(0.2383,0.5447),(0.235,0.5315),(0.2335,0.5319),(0.2353,0.5082),(0.2337,0.5085),(0.2404,0.4845),(0.2386,0.4852),(0.245,0.6053),(0.2466,0.6055),(0.2347,0.6321),(0.2364,0.6331),(0.2354,0.4672),(0.2336,0.4682),(0.2264,0.454),(0.224,0.4542),(0.2108,0.4425),(0.2097,0.4441),(0.227,0.4086),(0.1834,0.4342),(0.1824,0.4354),(0.1762,0.7069),(0.2354,0.3943),(0.197,0.4034),(0.3105,0.8683),(0.3156,0.8797),(0.3599,0.886),(0.3582,0.8759),(0.4109,0.8901),(0.2173,0.8121),(0.218,0.7759),(0.188,0.8053),(0.3588,0.3903),(0.2944,0.3883),(0.4104,0.3903),(0.2184,0.7188),(0.2652,0.829),(0.2615,0.7864),(0.2552,0.7274),(0.2412,0.6634),(0.2116,0.6588),(0.2858,0.4024),(0.3525,0.403),(0.2484,0.453),(0.3293,0.447),(0.3179,0.507),(0.3891,0.5112),(0.2553,0.4812),(0.2457,0.5306),(0.2481,0.5075),(0.3842,0.5244),(0.3117,0.5282),(0.3098,0.5593),(0.3152,0.5853),(0.3252,0.6753),(0.3162,0.6101),(0.3337,0.7398),(0.3995,0.7451),(0.2826,0.7917),(0.3446,0.8076),(0.295,0.8363),(0.3483,0.8477),(0.3051,0.8591),(0.3543,0.8673),(0.4069,0.8159),(0.4029,0.8541),(0.2195,0.8267),(0.2702,0.8483),(0.2725,0.8547),(0.1852,0.8075),(0.2312,0.8423),(0.2764,0.8646),(0.2442,0.6377),(0.2559,0.6068),(0.2532,0.5885),(0.2568,0.5578),(0.2589,0.5713),(0.2383,0.6431),(0.2476,0.5439),(0.31,0.5437),(0.2958,0.8918),(0.3339,0.9039),(0.3759,0.9105),(0.4237,0.9165),(0.3137,0.912),(0.3563,0.9252),(0.3946,0.9348),(0.2105,0.8289),(0.2501,0.8705),(0.2813,0.8868),(0.2145,0.8489),(0.2354,0.862),(0.2603,0.8891),(0.2885,0.9026),(0.2185,0.8652),(0.2383,0.8778),(0.1848,0.8397),(0.2098,0.8671),(0.1685,0.8083),(0.182,0.8195),(0.1742,0.8197),(0.184,0.8301),(0.2083,0.8448),(0.209,0.8599),(0.4771,0.9657),(0.4768,0.9642),(0.5112,0.9711),(0.5118,0.9719),(0.5463,0.9773),(0.5458,0.9765),(0.575,0.9782),(0.5756,0.979),(0.4448,0.9605),(0.4442,0.9593),(0.4573,0.3863),(0.4574,0.3863),(0.491,0.3801),(0.491,0.3801),(0.5247,0.3646),(0.4932,0.3792),(0.5039,0.365),(0.4929,0.3789),(0.5036,0.3647),(0.412,0.3875),(0.4921,0.3801),(0.5195,0.3498),(0.5198,0.3501),(0.5298,0.3564),(0.5361,0.3416),(0.5358,0.3419),(0.5348,0.3409),(0.535,0.3404),(0.5301,0.3566),(0.5338,0.3496),(0.5341,0.3497),(0.5253,0.3454),(0.5251,0.345),(0.5359,0.3433),(0.5363,0.3434),(0.5332,0.3408),(0.5332,0.3403),(0.4452,0.8934),(0.4423,0.8853),(0.4751,0.8895),(0.4777,0.8965),(0.5628,0.8856),(0.5656,0.8961),(0.5278,0.8981),(0.5241,0.89),(0.5043,0.8985),(0.4985,0.8912),(0.4104,0.3903),(0.4571,0.3874),(0.492,0.3812),(0.4058,0.4035),(0.3944,0.448),(0.3802,0.5621),(0.3822,0.6116),(0.3879,0.6805),(0.4567,0.3963),(0.4531,0.4439),(0.4408,0.5159),(0.4395,0.5627),(0.4437,0.6126),(0.4613,0.6849),(0.47,0.7388),(0.4721,0.8164),(0.4922,0.3907),(0.4992,0.4482),(0.4982,0.5235),(0.4918,0.5627),(0.4949,0.6143),(0.5047,0.6855),(0.5088,0.7295),(0.5125,0.8082),(0.4759,0.8641),(0.4301,0.8571),(0.5161,0.8586),(0.4373,0.8767),(0.4722,0.8811),(0.4065,0.8727),(0.52,0.8814),(0.4912,0.8826),(0.5596,0.875),(0.4556,0.9204),(0.4849,0.9243),(0.5188,0.9273),(0.5506,0.9274),(0.5819,0.9262),(0.4704,0.9484),(0.4984,0.9549),(0.533,0.96),(0.5622,0.9614),(0.5112,0.9711),(0.4768,0.9642),(0.575,0.9782),(0.5458,0.9765),(0.6086,0.9799),(0.4442,0.9593),(0.491,0.3801),(0.4573,0.3863),(0.5039,0.365),(0.4932,0.3792),(0.412,0.3875),(0.4921,0.3801),(0.5198,0.3501),(0.5298,0.3564),(0.5348,0.3409),(0.5358,0.3419),(0.5338,0.3496),(0.5253,0.3454),(0.5359,0.3433),(0.5332,0.3408),(0.4093,0.8812),(0.4777,0.8965),(0.4751,0.8895),(0.4423,0.8853),(0.4452,0.8934),(0.5241,0.89),(0.5278,0.8981),(0.5656,0.8961),(0.5628,0.8856),(0.4985,0.8912),(0.5043,0.8985),(0.4571,0.3874),(0.492,0.3812),(0.5214,0.3839),(0.3944,0.448),(0.4058,0.4035),(0.3822,0.6116),(0.3802,0.5621),(0.3879,0.6805),(0.4531,0.4439),(0.4567,0.3963),(0.4408,0.5159),(0.4437,0.6126),(0.4395,0.5627),(0.4613,0.6849),(0.47,0.7388),(0.4721,0.8164),(0.4992,0.4482),(0.4922,0.3907),(0.4982,0.5235),(0.4918,0.5627),(0.4949,0.6143),(0.5047,0.6855),(0.5088,0.7295),(0.5125,0.8082),(0.4301,0.8571),(0.4759,0.8641),(0.5161,0.8586),(0.4722,0.8811),(0.4373,0.8767),(0.4065,0.8727),(0.5437,0.53),(0.54,0.5621),(0.5388,0.6117),(0.5416,0.6877),(0.5441,0.7156),(0.5501,0.7906),(0.5561,0.8483),(0.4912,0.8826),(0.52,0.8814),(0.5596,0.875),(0.4556,0.9204),(0.4849,0.9243),(0.5188,0.9273),(0.5506,0.9274),(0.5819,0.9262),(0.4359,0.9414),(0.4704,0.9484),(0.4984,0.9549),(0.533,0.96),(0.5622,0.9614),(0.5959,0.9615),(0.6086,0.9799),(0.6093,0.9806),(0.6424,0.9825),(0.643,0.9834),(0.6749,0.9834),(0.6744,0.9826),(0.6968,0.982),(0.6975,0.9822),(0.5368,0.3538),(0.5369,0.3542),(0.5244,0.365),(0.52,0.3819),(0.5215,0.3826),(0.5218,0.3831),(0.5626,0.3926),(0.5611,0.3945),(0.5842,0.4016),(0.6443,0.3428),(0.6443,0.3428),(0.6139,0.3514),(0.6139,0.3514),(0.7293,0.318),(0.7293,0.318),(0.6811,0.3323),(0.6811,0.3323),(0.7766,0.3105),(0.7766,0.3105),(0.818,0.3071),(0.818,0.3071),(0.8488,0.3119),(0.8488,0.3118),(0.8839,0.3253),(0.8839,0.3253),(0.9148,0.3441),(0.9148,0.3441),(0.7376,0.4869),(0.7616,0.4779),(0.7178,0.4637),(0.7412,0.4527),(0.6773,0.4401),(0.7018,0.4289),(0.6383,0.4242),(0.6611,0.4153),(0.6078,0.4112),(0.6279,0.4031),(0.602,0.393),(0.5758,0.3836),(0.5421,0.3776),(0.6278,0.3318),(0.6303,0.3332),(0.6298,0.3336),(0.6275,0.3323),(0.7728,0.4247),(0.7383,0.4026),(0.7035,0.3932),(0.6657,0.3874),(0.6291,0.3817),(0.5983,0.3732),(0.5684,0.37),(0.5421,0.3776),(0.59,0.3616),(0.59,0.3616),(0.8244,0.3615),(0.7872,0.3549),(0.755,0.3514),(0.721,0.352),(0.6706,0.3589),(0.6203,0.3618),(0.8762,0.3268),(0.8391,0.3153),(0.8068,0.3123),(0.7646,0.3185),(0.7192,0.3271),(0.6466,0.3481),(0.6734,0.4469),(0.6381,0.4314),(0.7107,0.4699),(0.7294,0.4918),(0.6067,0.4172),(0.5214,0.3839),(0.5607,0.3984),(0.5219,0.3945),(0.5396,0.4525),(0.5437,0.53),(0.54,0.5621),(0.5388,0.6117),(0.5416,0.6877),(0.5441,0.7156),(0.5501,0.7906),(0.5561,0.8483),(0.5954,0.4649),(0.5736,0.415),(0.5948,0.5388),(0.5943,0.5607),(0.5917,0.613),(0.5914,0.6908),(0.604,0.7697),(0.5966,0.835),(0.7052,0.4842),(0.6752,0.4634),(0.6511,0.4509),(0.6965,0.5201),(0.669,0.4994),(0.7242,0.5061),(0.7199,0.5446),(0.6858,0.5641),(0.64,0.4836),(0.6516,0.5567),(0.6812,0.6099),(0.6805,0.6556),(0.6463,0.6114),(0.6824,0.7166),(0.6466,0.6707),(0.655,0.7405),(0.6939,0.7806),(0.7,0.8121),(0.6782,0.8322),(0.6714,0.8016),(0.6527,0.8128),(0.656,0.8454),(0.6204,0.827),(0.6275,0.8566),(0.5984,0.8657),(0.6167,0.4349),(0.5803,0.4056),(0.7049,0.8293),(0.6835,0.8486),(0.6608,0.8621),(0.6328,0.8721),(0.7239,0.8037),(0.6015,0.8805),(0.6049,0.8947),(0.6371,0.8894),(0.6671,0.8811),(0.6866,0.8634),(0.7075,0.8451),(0.7253,0.8229),(0.5684,0.37),(0.7104,0.9809),(0.7104,0.9809),(0.7436,0.9792),(0.7436,0.9792),(0.6107,0.9269),(0.6439,0.9268),(0.6722,0.924),(0.6931,0.9118),(0.7049,0.9592),(0.6874,0.9633),(0.715,0.9028),(0.7327,0.9576),(0.7357,0.8975),(0.6886,0.879),(0.7097,0.8694),(0.7281,0.8535),(0.5959,0.9615),(0.6297,0.9644),(0.6622,0.9649),(0.5515,0.3728),(0.5516,0.3732),(0.5494,0.3465),(0.5667,0.3653),(0.5492,0.3461),(0.5669,0.3657),(0.5599,0.3421),(0.5841,0.3561),(0.5598,0.3416),(0.5844,0.3564),(0.5903,0.3364),(0.6185,0.3427),(0.5903,0.3359),(0.6187,0.343),(0.6175,0.3327),(0.6282,0.3363),(0.6177,0.3322),(0.6286,0.3364),(0.6424,0.9825),(0.6744,0.9826),(0.6968,0.982),(0.5244,0.365),(0.5369,0.3542),(0.52,0.3819),(0.5218,0.3831),(0.5215,0.3826),(0.5611,0.3945),(0.5626,0.3926),(0.5842,0.4016),(0.6139,0.3514),(0.6443,0.3428),(0.6811,0.3323),(0.7293,0.318),(0.7766,0.3105),(0.818,0.3071),(0.8488,0.3118),(0.8839,0.3253),(0.7376,0.4869),(0.7412,0.4527),(0.7177,0.4637),(0.7018,0.4289),(0.6773,0.4401),(0.6611,0.4153),(0.6383,0.4242),(0.6279,0.4031),(0.6078,0.4112),(0.602,0.393),(0.5758,0.3836),(0.5421,0.3776),(0.6275,0.3323),(0.6298,0.3336),(0.7728,0.4247),(0.7383,0.4026),(0.7035,0.3932),(0.6657,0.3874),(0.6291,0.3817),(0.5983,0.3732),(0.5684,0.37),(0.59,0.3616),(0.8244,0.3615),(0.7872,0.3549),(0.755,0.3514),(0.721,0.352),(0.6706,0.3589),(0.6203,0.3618),(0.9084,0.3446),(0.8762,0.3268),(0.8391,0.3153),(0.8068,0.3123),(0.7646,0.3185),(0.7192,0.3271),(0.6466,0.3481),(0.6381,0.4314),(0.6734,0.4469),(0.7107,0.4699),(0.7294,0.4918),(0.6067,0.4172),(0.5607,0.3984),(0.5396,0.4525),(0.5219,0.3945),(0.5736,0.415),(0.5954,0.4649),(0.5948,0.5388),(0.5943,0.5607),(0.5917,0.613),(0.5914,0.6908),(0.604,0.7697),(0.5966,0.835),(0.6752,0.4634),(0.7052,0.4842),(0.6511,0.4509),(0.669,0.4994),(0.6965,0.5201),(0.7199,0.5446),(0.7242,0.5061),(0.6858,0.5641),(0.726,0.573),(0.6516,0.5567),(0.64,0.4836),(0.6812,0.6099),(0.6805,0.6556),(0.6463,0.6114),(0.6823,0.7166),(0.6466,0.6707),(0.655,0.7405),(0.6939,0.7806),(0.6714,0.8016),(0.6782,0.8322),(0.7,0.8121),(0.6527,0.8128),(0.656,0.8454),(0.7208,0.7832),(0.6204,0.827),(0.6275,0.8566),(0.5984,0.8657),(0.6167,0.4349),(0.5803,0.4056),(0.6835,0.8486),(0.7049,0.8293),(0.6328,0.8721),(0.6608,0.8621),(0.7239,0.8037),(0.6015,0.8805),(0.6371,0.8894),(0.6049,0.8947),(0.6671,0.8811),(0.6866,0.8634),(0.7075,0.8451),(0.7253,0.8229),(0.7104,0.9809),(0.7436,0.9792),(0.7824,0.9762),(0.6107,0.9269),(0.6439,0.9268),(0.6722,0.924),(0.6874,0.9633),(0.7049,0.9592),(0.6931,0.9118),(0.7327,0.9576),(0.715,0.9028),(0.7648,0.9593),(0.7357,0.8975),(0.6886,0.879),(0.7097,0.8694),(0.7281,0.8535),(0.6297,0.9644),(0.6622,0.9649),(0.5515,0.3728),(0.5667,0.3653),(0.5494,0.3465),(0.5841,0.3561),(0.5599,0.3421),(0.6185,0.3427),(0.5903,0.3364),(0.6282,0.3363),(0.6175,0.3327),(0.84,0.5852),(0.84,0.5852),(0.828,0.681),(0.8269,0.6788),(0.828,0.681),(0.8259,0.682),(0.8068,0.6815),(0.809,0.6892),(0.7859,0.7181),(0.7808,0.698),(0.769,0.7444),(0.765,0.718),(0.8172,0.5776),(0.8171,0.5784),(0.8154,0.5792),(0.7893,0.5654),(0.7955,0.5642),(0.8172,0.5776),(0.8171,0.5784),(0.7806,0.5528),(0.9322,0.3622),(0.9322,0.3621),(0.9395,0.3768),(0.9395,0.3768),(0.9411,0.4337),(0.9411,0.4336),(0.9449,0.4071),(0.9449,0.4071),(0.909,0.4848),(0.909,0.4848),(0.8792,0.5229),(0.8793,0.5229),(0.8187,0.5582),(0.8374,0.5683),(0.8038,0.5447),(0.7693,0.5365),(0.7921,0.5272),(0.7586,0.5194),(0.7827,0.5091),(0.7495,0.5052),(0.7739,0.4956),(0.8401,0.546),(0.8506,0.5524),(0.8273,0.5287),(0.8206,0.5059),(0.8168,0.4778),(0.8101,0.4627),(0.7963,0.4454),(0.8636,0.5385),(0.8636,0.5385),(0.8506,0.5524),(0.8623,0.527),(0.8661,0.5001),(0.876,0.4629),(0.8854,0.4172),(0.8783,0.3961),(0.8574,0.376),(0.9007,0.4885),(0.9317,0.4395),(0.938,0.4104),(0.9335,0.3783),(0.9266,0.3628),(0.9084,0.3446),(0.8143,0.5825),(0.7868,0.5677),(0.7736,0.554),(0.7628,0.5395),(0.7515,0.5233),(0.7417,0.5097),(0.8266,0.6761),(0.8056,0.6759),(0.726,0.573),(0.7171,0.6086),(0.757,0.586),(0.7495,0.6151),(0.7333,0.6118),(0.7415,0.5795),(0.7158,0.6405),(0.7324,0.6332),(0.7491,0.6259),(0.7188,0.6869),(0.7504,0.6636),(0.7341,0.6753),(0.7166,0.7512),(0.7208,0.7832),(0.8045,0.6236),(0.8036,0.6501),(0.7684,0.6554),(0.7658,0.6184),(0.7587,0.6906),(0.744,0.7102),(0.7282,0.7337),(0.7622,0.7049),(0.749,0.7283),(0.805,0.6694),(0.7787,0.686),(0.7794,0.6738),(0.7335,0.556),(0.7579,0.5479),(0.7693,0.5608),(0.762,0.5732),(0.7486,0.565),(0.7839,0.5738),(0.7763,0.582),(0.7367,0.5225),(0.7456,0.5338),(0.8103,0.5988),(0.8131,0.5873),(0.8069,0.6123),(0.7723,0.5924),(0.8043,0.6665),(0.7523,0.7432),(0.7339,0.7587),(0.738,0.7763),(0.7548,0.7692),(0.7403,0.7977),(0.7824,0.9762),(0.7824,0.9762),(0.8277,0.9674),(0.8278,0.9674),(0.8063,0.9722),(0.8063,0.9722),(0.8497,0.9588),(0.8497,0.9588),(0.8787,0.8956),(0.8787,0.8956),(0.8708,0.9339),(0.8708,0.9339),(0.7648,0.9593),(0.7774,0.8742),(0.821,0.96),(0.7946,0.9613),(0.7551,0.8859),(0.7969,0.8539),(0.8452,0.9505),(0.816,0.8248),(0.866,0.9195),(0.8372,0.7978),(0.8719,0.8783),(0.8594,0.793),(0.8643,0.8091),(0.8661,0.7917),(0.8698,0.811),(0.8698,0.811),(0.8661,0.7917),(0.7437,0.8316),(0.7594,0.8069),(0.7755,0.7798),(0.7941,0.7531),(0.8185,0.7303),(0.8435,0.7247),(0.8435,0.7247),(0.8618,0.7736),(0.8617,0.7736),(0.8556,0.7784),(0.8393,0.7256),(0.8732,0.833),(0.8732,0.833),(0.8654,0.826),(0.8269,0.6788),(0.828,0.681),(0.8259,0.682),(0.7808,0.698),(0.7859,0.7181),(0.809,0.6892),(0.8068,0.6815),(0.765,0.718),(0.769,0.7444),(0.8154,0.5792),(0.8171,0.5784),(0.8172,0.5776),(0.7955,0.5642),(0.7893,0.5654),(0.7806,0.5528),(0.9148,0.3441),(0.9322,0.3621),(0.9395,0.3768),(0.9449,0.4071),(0.9411,0.4336),(0.909,0.4848),(0.8793,0.5229),(0.8374,0.5683),(0.8187,0.5582),(0.8038,0.5447),(0.7921,0.5272),(0.7693,0.5365),(0.7827,0.5091),(0.7586,0.5194),(0.7739,0.4956),(0.7495,0.5052),(0.7616,0.4779),(0.8506,0.5524),(0.8401,0.546),(0.8273,0.5287),(0.8206,0.5059),(0.8168,0.4778),(0.8101,0.4627),(0.7963,0.4454),(0.8636,0.5385),(0.8623,0.527),(0.8661,0.5001),(0.876,0.4629),(0.8854,0.4172),(0.8783,0.3961),(0.8574,0.376),(0.9007,0.4885),(0.9317,0.4395),(0.938,0.4104),(0.9335,0.3783),(0.9266,0.3628),(0.7868,0.5677),(0.8143,0.5825),(0.7736,0.554),(0.7515,0.5233),(0.7628,0.5395),(0.7417,0.5097),(0.8266,0.6761),(0.8056,0.6759),(0.7171,0.6086),(0.7415,0.5795),(0.7333,0.6118),(0.7495,0.6151),(0.757,0.586),(0.7158,0.6405),(0.7491,0.6259),(0.7324,0.6332),(0.7188,0.6869),(0.7341,0.6753),(0.7504,0.6636),(0.7166,0.7512),(0.7658,0.6184),(0.7684,0.6554),(0.8036,0.6501),(0.8045,0.6236),(0.744,0.7102),(0.7587,0.6906),(0.7282,0.7337),(0.749,0.7283),(0.7622,0.7049),(0.7794,0.6738),(0.7787,0.686),(0.805,0.6694),(0.7335,0.556),(0.7486,0.565),(0.762,0.5732),(0.7693,0.5608),(0.7579,0.5479),(0.7763,0.582),(0.7839,0.5738),(0.7456,0.5338),(0.7367,0.5225),(0.8131,0.5873),(0.8103,0.5988),(0.8069,0.6123),(0.8352,0.6186),(0.7723,0.5924),(0.8328,0.6274),(0.829,0.6501),(0.8271,0.6658),(0.8043,0.6665),(0.8269,0.6689),(0.7523,0.7432),(0.738,0.7763),(0.7339,0.7587),(0.7403,0.7977),(0.7548,0.7692),(0.8063,0.9722),(0.8277,0.9674),(0.8497,0.9588),(0.8708,0.9339),(0.8787,0.8956),(0.8732,0.833),(0.7551,0.8859),(0.7946,0.9613),(0.821,0.96),(0.7774,0.8742),(0.8452,0.9505),(0.7969,0.8539),(0.866,0.9195),(0.816,0.8248),(0.8719,0.8783),(0.8372,0.7978),(0.8643,0.8091),(0.8594,0.793),(0.8661,0.7917),(0.8698,0.811),(0.7437,0.8316),(0.7594,0.8069),(0.7755,0.7798),(0.7941,0.7531),(0.8185,0.7303),(0.8435,0.7247),(0.8617,0.7736),(0.8393,0.7256),(0.8556,0.7784),(0.8654,0.826),(0.848,0.5785),(0.8479,0.5785),(0.8282,0.6802),(0.8282,0.6802),(0.9331,0.8016),(0.9332,0.8016),(0.9402,0.8016),(0.9402,0.8016),(0.948,0.7858),(0.9479,0.7858),(0.955,0.7539),(0.9549,0.754),(0.9605,0.7303),(0.9604,0.7303),(0.9599,0.7062),(0.9599,0.7062),(0.9594,0.6912),(0.9593,0.6912),(0.9584,0.6736),(0.9583,0.6736),(0.9581,0.6526),(0.958,0.6526),(0.9609,0.6371),(0.9608,0.6371),(0.9661,0.6235),(0.9661,0.6235),(0.9708,0.613),(0.9708,0.613),(0.9778,0.5964),(0.9778,0.5964),(0.9814,0.5851),(0.9814,0.5851),(0.983,0.5794),(0.983,0.5795),(0.9855,0.5691),(0.9855,0.5691),(0.9875,0.5569),(0.9875,0.5569),(0.9884,0.5496),(0.9884,0.5496),(0.9896,0.5392),(0.9896,0.5392),(0.9876,0.5231),(0.9876,0.5231),(0.9826,0.5121),(0.9826,0.5121),(0.969,0.4967),(0.969,0.4967),(0.9525,0.4943),(0.9525,0.4943),(0.8427,0.6842),(0.8501,0.6905),(0.8501,0.6905),(0.8427,0.6843),(0.8492,0.6848),(0.8576,0.691),(0.8614,0.6819),(0.8703,0.6904),(0.8702,0.6755),(0.879,0.6834),(0.8744,0.67),(0.8837,0.6759),(0.8791,0.6609),(0.8878,0.6665),(0.8817,0.655),(0.8909,0.6587),(0.884,0.6489),(0.8936,0.6505),(0.8868,0.639),(0.8962,0.6411),(0.888,0.6335),(0.8977,0.6338),(0.8885,0.6288),(0.8984,0.6273),(0.8885,0.6217),(0.8986,0.6214),(0.888,0.6173),(0.8982,0.6153),(0.8869,0.6135),(0.8971,0.61),(0.8852,0.6084),(0.8958,0.6058),(0.8836,0.6052),(0.894,0.6013),(0.881,0.6014),(0.8912,0.5956),(0.8769,0.5954),(0.8882,0.5897),(0.8743,0.5918),(0.8857,0.5846),(0.8714,0.5891),(0.8821,0.5801),(0.866,0.5863),(0.8768,0.5767),(0.8565,0.5843),(0.8668,0.5744),(0.8775,0.555),(0.8775,0.555),(0.868,0.7144),(0.868,0.7144),(0.8743,0.7148),(0.8847,0.7092),(0.8933,0.6973),(0.897,0.688),(0.9007,0.6749),(0.9032,0.6659),(0.9058,0.6557),(0.9084,0.6432),(0.9101,0.634),(0.9113,0.6257),(0.912,0.6195),(0.9124,0.6102),(0.9118,0.6031),(0.9115,0.5992),(0.911,0.5927),(0.9095,0.5844),(0.9084,0.5778),(0.9079,0.5719),(0.905,0.5649),(0.9015,0.5609),(0.8934,0.5552),(0.8875,0.7354),(0.8794,0.7351),(0.8995,0.7276),(0.9083,0.712),(0.9118,0.7),(0.9147,0.6841),(0.9166,0.6733),(0.9183,0.661),(0.9206,0.646),(0.9228,0.635),(0.9247,0.6251),(0.9262,0.6177),(0.928,0.6063),(0.9287,0.5978),(0.9294,0.5932),(0.9304,0.5852),(0.9308,0.5756),(0.9313,0.5689),(0.9323,0.5619),(0.9306,0.5529),(0.9273,0.5475),(0.9179,0.5399),(0.8994,0.538),(0.8794,0.7351),(0.9273,0.7895),(0.919,0.7871),(0.9358,0.7776),(0.9404,0.7486),(0.942,0.7269),(0.9418,0.7044),(0.9419,0.6898),(0.9416,0.6727),(0.9417,0.6524),(0.9443,0.6374),(0.9485,0.6242),(0.9524,0.6141),(0.9584,0.5983),(0.9619,0.5874),(0.9638,0.5817),(0.9672,0.5713),(0.9703,0.5592),(0.9717,0.5514),(0.9732,0.5416),(0.9709,0.5274),(0.9658,0.5182),(0.9531,0.5054),(0.9354,0.5031),(0.8994,0.538),(0.9354,0.5032),(0.9189,0.7871),(0.9373,0.7991),(0.9301,0.7985),(0.9447,0.7839),(0.9506,0.7523),(0.9546,0.7289),(0.9539,0.7053),(0.9534,0.6905),(0.9525,0.6731),(0.9522,0.6524),(0.9549,0.637),(0.9599,0.6236),(0.9645,0.6133),(0.9716,0.5969),(0.9755,0.5857),(0.9772,0.5802),(0.9803,0.5697),(0.9828,0.5575),(0.9839,0.5502),(0.9853,0.5399),(0.9835,0.5241),(0.9786,0.5134),(0.9654,0.4985),(0.9492,0.4964),(0.9492,0.4964),(0.9301,0.7985),(0.8684,0.6682),(0.8582,0.6768),(0.8771,0.6528),(0.8825,0.6338),(0.8829,0.6179),(0.8793,0.6061),(0.8723,0.5957),(0.8654,0.5922),(0.8562,0.59),(0.8492,0.6819),(0.8429,0.6822),(0.8423,0.5881),(0.8406,0.5963),(0.84,0.5987),(0.8374,0.6089),(0.8559,0.5999),(0.8591,0.6062),(0.8352,0.6186),(0.8563,0.6186),(0.8693,0.6083),(0.8702,0.619),(0.8543,0.6326),(0.8328,0.6274),(0.8519,0.6553),(0.829,0.6501),(0.8654,0.6494),(0.8691,0.6331),(0.8431,0.6666),(0.8271,0.6658),(0.8499,0.6666),(0.8269,0.6689),(0.8413,0.6735),(0.8492,0.6739),(0.8626,0.6006),(0.8558,0.5959),(0.8643,0.5969),(0.8696,0.6002),(0.8742,0.6077),(0.8763,0.6188),(0.8756,0.6335),(0.8712,0.6499),(0.8645,0.663),(0.8562,0.6709),(0.8663,0.6029),(0.8606,0.6592),(0.8548,0.6646),(0.84,0.5852),(0.8479,0.5785),(0.8282,0.6802),(0.9402,0.8016),(0.9332,0.8016),(0.948,0.7858),(0.955,0.7539),(0.9605,0.7303),(0.9599,0.7062),(0.9594,0.6912),(0.9584,0.6736),(0.9581,0.6526),(0.9609,0.6371),(0.9661,0.6235),(0.9708,0.613),(0.9778,0.5964),(0.9814,0.5851),(0.983,0.5794),(0.9855,0.5691),(0.9875,0.5569),(0.9884,0.5496),(0.9896,0.5392),(0.9876,0.5231),(0.9826,0.5121),(0.969,0.4967),(0.9525,0.4943),(0.8501,0.6905),(0.8427,0.6842),(0.8576,0.691),(0.8492,0.6848),(0.8703,0.6904),(0.8614,0.6819),(0.879,0.6834),(0.8702,0.6755),(0.8837,0.6759),(0.8744,0.67),(0.8878,0.6665),(0.8791,0.6609),(0.8909,0.6587),(0.8817,0.655),(0.8936,0.6505),(0.884,0.6489),(0.8962,0.6411),(0.8868,0.639),(0.8977,0.6338),(0.888,0.6335),(0.8984,0.6273),(0.8885,0.6288),(0.8986,0.6214),(0.8885,0.6217),(0.8982,0.6153),(0.888,0.6173),(0.8971,0.61),(0.8869,0.6135),(0.8958,0.6058),(0.8852,0.6084),(0.894,0.6013),(0.8836,0.6052),(0.8912,0.5956),(0.881,0.6014),(0.8882,0.5897),(0.8769,0.5954),(0.8857,0.5846),(0.8743,0.5918),(0.8821,0.5801),(0.8714,0.5891),(0.8768,0.5767),(0.866,0.5863),(0.8668,0.5744),(0.8565,0.5843),(0.8775,0.555),(0.868,0.7144),(0.8743,0.7148),(0.8847,0.7092),(0.8933,0.6973),(0.897,0.688),(0.9007,0.6749),(0.9032,0.6659),(0.9058,0.6557),(0.9084,0.6432),(0.9101,0.634),(0.9113,0.6257),(0.912,0.6195),(0.9124,0.6102),(0.9118,0.6031),(0.9115,0.5992),(0.911,0.5927),(0.9095,0.5844),(0.9084,0.5778),(0.9079,0.5719),(0.905,0.5649),(0.9015,0.5609),(0.8934,0.5552),(0.8794,0.7351),(0.8875,0.7354),(0.8995,0.7276),(0.9083,0.712),(0.9118,0.7),(0.9147,0.6841),(0.9166,0.6733),(0.9183,0.661),(0.9206,0.646),(0.9228,0.635),(0.9247,0.6251),(0.9262,0.6177),(0.928,0.6063),(0.9287,0.5978),(0.9294,0.5932),(0.9304,0.5852),(0.9308,0.5756),(0.9313,0.5689),(0.9323,0.5619),(0.9306,0.5529),(0.9273,0.5475),(0.9179,0.5399),(0.8994,0.538),(0.919,0.7871),(0.9273,0.7895),(0.9358,0.7776),(0.9404,0.7486),(0.942,0.7269),(0.9418,0.7044),(0.9419,0.6898),(0.9416,0.6727),(0.9417,0.6524),(0.9443,0.6374),(0.9485,0.6242),(0.9524,0.6141),(0.9584,0.5983),(0.9619,0.5874),(0.9638,0.5817),(0.9672,0.5713),(0.9703,0.5592),(0.9717,0.5514),(0.9732,0.5416),(0.9709,0.5274),(0.9658,0.5182),(0.9531,0.5054),(0.9354,0.5031),(0.9301,0.7985),(0.9373,0.7991),(0.9447,0.7839),(0.9506,0.7523),(0.9546,0.7289),(0.9539,0.7053),(0.9534,0.6905),(0.9525,0.6731),(0.9522,0.6524),(0.9549,0.637),(0.9599,0.6236),(0.9645,0.6133),(0.9716,0.5969),(0.9755,0.5857),(0.9772,0.5802),(0.9803,0.5697),(0.9828,0.5575),(0.9839,0.5502),(0.9853,0.5399),(0.9835,0.5241),(0.9786,0.5134),(0.9654,0.4985),(0.9492,0.4964),(0.8582,0.6768),(0.8684,0.6682),(0.8771,0.6528),(0.8825,0.6338),(0.8829,0.6179),(0.8793,0.6061),(0.8723,0.5957),(0.8562,0.59),(0.8654,0.5922),(0.8492,0.6819),(0.8429,0.6822),(0.8423,0.5881),(0.8406,0.5963),(0.8374,0.6089),(0.84,0.5987),(0.8591,0.6062),(0.8559,0.5999),(0.8563,0.6186),(0.8702,0.619),(0.8693,0.6083),(0.8543,0.6326),(0.8519,0.6553),(0.8691,0.6331),(0.8654,0.6494),(0.8431,0.6666),(0.8499,0.6666),(0.8413,0.6735),(0.8492,0.6739),(0.8626,0.6006),(0.8558,0.5959),(0.8643,0.5969),(0.8742,0.6077),(0.8696,0.6002),(0.8763,0.6188),(0.8756,0.6335),(0.8712,0.6499),(0.8645,0.663),(0.8562,0.6709),(0.8663,0.6029),(0.8606,0.6592),(0.8548,0.6646),(0.2101,0.645),(0.1766,0.6528),(0.179,0.6238),(0.1216,0.6028),(0.1173,0.6333),(0.0996,0.5892),(0.147,0.62),(0.1434,0.6516),(0.1936,0.597),(0.2061,0.5993),(0.2008,0.5492),(0.1913,0.5463),(0.1902,0.5453),(0.1901,0.5063),(0.1913,0.5065),(0.1955,0.4851),(0.1967,0.485),(0.1956,0.4701),(0.1965,0.4697),(0.1904,0.4619),(0.1913,0.4611),(0.1725,0.4507),(0.1731,0.4496),(0.1487,0.4461),(0.1489,0.4448),(0.1249,0.4464),(0.1249,0.4449),(0.1014,0.451),(0.1814,0.5947),(0.1564,0.4328),(0.1359,0.7591),(0.1359,0.7592),(0.1159,0.7314),(0.054,0.4956),(0.0538,0.4969),(0.0547,0.4954),(0.0548,0.4948),(0.0419,0.4951),(0.0427,0.4955),(0.0418,0.4957),(0.0424,0.4969),(0.0326,0.4958),(0.025,0.496),(0.0238,0.4958),(0.0322,0.4955),(0.0323,0.4949),(0.0238,0.4953),(0.0251,0.4949),(0.0328,0.4944),(0.0204,0.4966),(0.0204,0.4966),(0.0205,0.4959),(0.0204,0.4957),(0.0544,0.4972),(0.0503,0.5142),(0.0477,0.5245),(0.0466,0.5243),(0.0441,0.5358),(0.0433,0.5354),(0.042,0.5452),(0.0413,0.5443),(0.0415,0.5485),(0.0411,0.5468),(0.0416,0.549),(0.0412,0.5472),(0.1362,0.7581),(0.159,0.7828),(0.138,0.7513),(0.1601,0.773),(0.1404,0.7281),(0.1433,0.693),(0.1762,0.7069),(0.1783,0.6634),(0.1788,0.6584),(0.1507,0.5884),(0.1521,0.5346),(0.1837,0.542),(0.1847,0.5036),(0.1553,0.4982),(0.1606,0.476),(0.1887,0.4824),(0.1777,0.441),(0.2014,0.454),(0.1159,0.7299),(0.1164,0.7239),(0.1149,0.6974),(0.1139,0.6672),(0.126,0.5724),(0.1291,0.5222),(0.1343,0.4904),(0.1391,0.4706),(0.1482,0.4506),(0.171,0.4564),(0.1541,0.4353),(0.1547,0.4341),(0.1795,0.4376),(0.1649,0.413),(0.1676,0.4095),(0.0866,0.6824),(0.0864,0.6808),(0.0864,0.6748),(0.0897,0.6544),(0.0946,0.6267),(0.1049,0.5431),(0.1095,0.5056),(0.1148,0.4804),(0.1188,0.465),(0.1243,0.4504),(0.1292,0.4347),(0.1331,0.424),(0.1349,0.4217),(0.0767,0.6598),(0.0767,0.6583),(0.0775,0.6527),(0.0809,0.6306),(0.0885,0.6138),(0.0849,0.5522),(0.088,0.5206),(0.0925,0.494),(0.0963,0.4749),(0.0991,0.4631),(0.1024,0.4413),(0.1041,0.4366),(0.105,0.4351),(0.0684,0.6351),(0.0621,0.6002),(0.0622,0.5986),(0.0683,0.6333),(0.0631,0.5925),(0.0685,0.6266),(0.0666,0.5739),(0.0716,0.6037),(0.0703,0.5547),(0.0785,0.575),(0.0727,0.5346),(0.0759,0.511),(0.0794,0.4911),(0.0821,0.4767),(0.084,0.4676),(0.0857,0.4594),(0.0877,0.4497),(0.0887,0.446),(0.0892,0.4449),(0.0548,0.5693),(0.0549,0.5682),(0.0553,0.5643),(0.0571,0.5517),(0.0587,0.537),(0.0618,0.524),(0.0646,0.5062),(0.0672,0.4906),(0.069,0.4798),(0.0702,0.4733),(0.0712,0.4679),(0.0725,0.4629),(0.0731,0.4606),(0.0734,0.46),(0.0474,0.5542),(0.0425,0.5504),(0.0425,0.5496),(0.0474,0.5533),(0.0431,0.5458),(0.048,0.5495),(0.0455,0.536),(0.0493,0.5383),(0.049,0.5246),(0.0519,0.5262),(0.0519,0.5154),(0.0524,0.5049),(0.0536,0.4981),(0.0556,0.4977),(0.0542,0.4941),(0.0549,0.4885),(0.0561,0.4802),(0.0568,0.4752),(0.0573,0.4711),(0.0574,0.4676),(0.0577,0.4659),(0.0578,0.4655),(0.0413,0.5449),(0.0343,0.5345),(0.0342,0.5338),(0.0412,0.5446),(0.034,0.5315),(0.0413,0.5425),(0.0351,0.5254),(0.043,0.5343),(0.0374,0.5182),(0.0458,0.5244),(0.0403,0.5085),(0.0494,0.5137),(0.0421,0.4981),(0.043,0.494),(0.0438,0.4869),(0.0447,0.4799),(0.0452,0.4754),(0.0454,0.4718),(0.0454,0.4689),(0.0452,0.4675),(0.0453,0.4672),(0.0253,0.5301),(0.0253,0.5297),(0.0256,0.5281),(0.0266,0.5225),(0.0284,0.5154),(0.0305,0.5062),(0.0325,0.497),(0.0329,0.4929),(0.0339,0.4872),(0.0347,0.4815),(0.035,0.4778),(0.0351,0.4749),(0.0352,0.472),(0.035,0.4708),(0.035,0.4705),(0.0192,0.5235),(0.0193,0.5231),(0.0195,0.5218),(0.0204,0.5172),(0.022,0.5112),(0.0234,0.5042),(0.0249,0.4971),(0.025,0.4937),(0.0259,0.4891),(0.0266,0.4844),(0.0269,0.4814),(0.0271,0.4789),(0.0273,0.4764),(0.0269,0.4753),(0.0269,0.475),(0.0165,0.5178),(0.0166,0.5171),(0.017,0.515),(0.0176,0.5115),(0.0185,0.5067),(0.0194,0.5017),(0.0202,0.4975),(0.0203,0.4951),(0.0209,0.492),(0.0214,0.4882),(0.0218,0.4852),(0.022,0.4828),(0.0222,0.4808),(0.0223,0.4793),(0.0148,0.5082),(0.0149,0.5077),(0.0151,0.5064),(0.0154,0.5045),(0.0157,0.5021),(0.016,0.5002),(0.0163,0.4987),(0.0166,0.496),(0.0168,0.4943),(0.0171,0.492),(0.0174,0.4899),(0.0176,0.4882),(0.0177,0.487),(0.0178,0.4864),(0.0224,0.479),(0.0178,0.4863),(0.0167,0.4889),(0.0166,0.4889),(0.0166,0.4893),(0.0165,0.4899),(0.0164,0.4909),(0.0163,0.4921),(0.0161,0.4934),(0.0159,0.4943),(0.016,0.4945),(0.0171,0.4972),(0.0171,0.4969),(0.2052,0.4466),(0.182,0.4358),(0.2091,0.4444),(0.1557,0.4331),(0.2044,0.4864),(0.1998,0.5075),(0.2382,0.6327),(0.2105,0.65),(0.2104,0.6475),(0.2368,0.6313),(0.2483,0.6058),(0.2503,0.606),(0.2488,0.581),(0.251,0.5815),(0.2535,0.5648),(0.2561,0.5661),(0.2527,0.5562),(0.2559,0.5564),(0.2407,0.5433),(0.2429,0.543),(0.2367,0.5314),(0.2387,0.531),(0.2371,0.5071),(0.2394,0.5071),(0.2414,0.4832),(0.2448,0.4828),(0.2367,0.4658),(0.2395,0.465),(0.2246,0.4515),(0.2276,0.4501),(0.2088,0.441),(0.2106,0.4395),(0.1817,0.4338),(0.1827,0.4326),(0.2376,0.6328),(0.2336,0.6315),(0.2498,0.6059),(0.2446,0.6053),(0.2505,0.5815),(0.2556,0.5661),(0.2555,0.5566),(0.2426,0.5434),(0.2382,0.531),(0.233,0.532),(0.2388,0.5074),(0.2331,0.5085),(0.2442,0.4834),(0.239,0.4658),(0.2272,0.4508),(0.2103,0.4404),(0.1827,0.4333),(0.2174,0.4566),(0.2278,0.4694),(0.2322,0.4859),(0.2293,0.5085),(0.2296,0.5325),(0.2339,0.545),(0.2451,0.5571),(0.2456,0.5637),(0.2413,0.5803),(0.2413,0.6049),(0.2303,0.6291),(0.1843,0.466),(0.1901,0.5046),(0.1953,0.4841),(0.1882,0.4736),(0.1736,0.4517),(0.1904,0.4622),(0.1502,0.4471),(0.1257,0.447),(0.1896,0.5439),(0.1951,0.47),(0.2347,0.604),(0.2264,0.625),(0.2318,0.5783),(0.2211,0.5079),(0.2228,0.5346),(0.2216,0.4872),(0.219,0.4748),(0.2117,0.4605),(0.2341,0.558),(0.2253,0.5447),(0.0155,0.4997),(0.0153,0.5006),(0.0152,0.5017),(0.015,0.5031),(0.0148,0.5042),(0.0147,0.505),(0.0146,0.5053),(0.0155,0.4999),(0.0167,0.4963),(0.017,0.4982),(0.017,0.4978),(0.0163,0.4991),(0.1913,0.5065),(0.1901,0.5063),(0.1902,0.5453),(0.1913,0.5463),(0.1967,0.485),(0.1955,0.4851),(0.1965,0.4697),(0.1956,0.4701),(0.1913,0.4611),(0.1904,0.4619),(0.1731,0.4496),(0.1725,0.4507),(0.1489,0.4448),(0.1487,0.4461),(0.1249,0.4449),(0.1249,0.4464),(0.1014,0.451),(0.1814,0.5947),(0.1564,0.4328),(0.1359,0.7592),(0.1598,0.785),(0.0538,0.4969),(0.054,0.4956),(0.0427,0.4955),(0.0424,0.4969),(0.025,0.496),(0.0326,0.4958),(0.0328,0.4944),(0.0251,0.4949),(0.0204,0.4966),(0.0204,0.4957),(0.0544,0.4972),(0.0466,0.5243),(0.0477,0.5245),(0.0503,0.5142),(0.0433,0.5354),(0.0441,0.5358),(0.0413,0.5443),(0.042,0.5452),(0.0411,0.5468),(0.0415,0.5485),(0.159,0.7828),(0.1362,0.7581),(0.1601,0.773),(0.138,0.7513),(0.1718,0.7482),(0.1404,0.7281),(0.1433,0.693),(0.1788,0.6584),(0.1434,0.6516),(0.1783,0.6634),(0.1507,0.5884),(0.147,0.62),(0.179,0.6238),(0.1837,0.542),(0.1521,0.5346),(0.1887,0.4824),(0.1606,0.476),(0.1553,0.4982),(0.1847,0.5036),(0.2014,0.454),(0.1777,0.441),(0.1159,0.7299),(0.1164,0.7239),(0.1149,0.6974),(0.1139,0.6672),(0.1173,0.6333),(0.126,0.5724),(0.1216,0.6028),(0.1291,0.5222),(0.1343,0.4904),(0.1391,0.4706),(0.171,0.4564),(0.1482,0.4506),(0.1795,0.4376),(0.1547,0.4341),(0.1541,0.4353),(0.1649,0.413),(0.0864,0.6808),(0.0864,0.6748),(0.0897,0.6544),(0.0945,0.6267),(0.0996,0.5892),(0.1049,0.5431),(0.1094,0.5056),(0.1148,0.4804),(0.1188,0.465),(0.1243,0.4504),(0.1292,0.4347),(0.1331,0.424),(0.0767,0.6583),(0.0775,0.6527),(0.0809,0.6306),(0.0885,0.6138),(0.088,0.5206),(0.0849,0.5522),(0.0925,0.494),(0.0963,0.4749),(0.0991,0.4631),(0.1024,0.4413),(0.1041,0.4366),(0.0683,0.6333),(0.0622,0.5986),(0.0685,0.6266),(0.0631,0.5925),(0.0716,0.6037),(0.0666,0.5739),(0.0785,0.575),(0.0703,0.5547),(0.0727,0.5346),(0.0759,0.511),(0.0794,0.4911),(0.0821,0.4767),(0.084,0.4676),(0.0857,0.4594),(0.0876,0.4497),(0.0887,0.446),(0.0549,0.5682),(0.0553,0.5643),(0.0571,0.5517),(0.0587,0.537),(0.0618,0.524),(0.0646,0.5062),(0.0672,0.4906),(0.069,0.4798),(0.0702,0.4733),(0.0712,0.4679),(0.0725,0.4629),(0.0731,0.4606),(0.0474,0.5533),(0.0425,0.5496),(0.048,0.5495),(0.0431,0.5458),(0.0493,0.5383),(0.0455,0.536),(0.0519,0.5262),(0.049,0.5246),(0.0519,0.5154),(0.0556,0.4977),(0.0536,0.4981),(0.0524,0.5049),(0.0549,0.4885),(0.0542,0.4941),(0.0561,0.4802),(0.0568,0.4752),(0.0573,0.4711),(0.0574,0.4676),(0.0577,0.4659),(0.0412,0.5446),(0.0342,0.5338),(0.0413,0.5425),(0.034,0.5315),(0.043,0.5343),(0.0351,0.5254),(0.0458,0.5244),(0.0374,0.5182),(0.0494,0.5137),(0.0403,0.5085),(0.0421,0.4981),(0.0438,0.4869),(0.043,0.494),(0.0447,0.4799),(0.0452,0.4754),(0.0454,0.4718),(0.0454,0.4689),(0.0452,0.4675),(0.0253,0.5297),(0.0256,0.5281),(0.0266,0.5225),(0.0284,0.5154),(0.0305,0.5062),(0.0325,0.497),(0.0339,0.4872),(0.0329,0.4929),(0.0347,0.4815),(0.035,0.4778),(0.0351,0.4749),(0.0352,0.472),(0.035,0.4708),(0.0193,0.5231),(0.0195,0.5218),(0.0204,0.5172),(0.022,0.5112),(0.0234,0.5042),(0.0249,0.4971),(0.0259,0.4891),(0.025,0.4937),(0.0266,0.4844),(0.0269,0.4814),(0.0271,0.4789),(0.0273,0.4764),(0.0269,0.4753),(0.0166,0.5171),(0.017,0.515),(0.0176,0.5115),(0.0185,0.5067),(0.0194,0.5017),(0.0202,0.4975),(0.0209,0.492),(0.0203,0.4951),(0.0214,0.4882),(0.0218,0.4852),(0.022,0.4828),(0.0222,0.4808),(0.0223,0.4793),(0.0149,0.5077),(0.0151,0.5064),(0.0154,0.5045),(0.0157,0.5021),(0.016,0.5002),(0.0163,0.4987),(0.0168,0.4943),(0.0166,0.496),(0.0171,0.492),(0.0174,0.4899),(0.0176,0.4882),(0.0177,0.487),(0.0178,0.4864),(0.0159,0.4943),(0.0161,0.4934),(0.0163,0.4921),(0.0164,0.4909),(0.0165,0.4899),(0.0166,0.4893),(0.0166,0.4889),(0.0171,0.4969),(0.2052,0.4466),(0.2091,0.4444),(0.182,0.4358),(0.1557,0.4331),(0.1998,0.5075),(0.2044,0.4864),(0.2368,0.6313),(0.2104,0.6475),(0.2105,0.65),(0.2382,0.6327),(0.2503,0.606),(0.2483,0.6058),(0.251,0.5815),(0.2488,0.581),(0.2561,0.5661),(0.2535,0.5648),(0.2559,0.5564),(0.2527,0.5562),(0.2429,0.543),(0.2407,0.5433),(0.2387,0.531),(0.2367,0.5314),(0.2394,0.5071),(0.2371,0.5071),(0.2448,0.4828),(0.2414,0.4832),(0.2395,0.465),(0.2367,0.4658),(0.2276,0.4501),(0.2246,0.4515),(0.2106,0.4395),(0.2088,0.441),(0.1827,0.4326),(0.1817,0.4338),(0.1766,0.6528),(0.2336,0.6315),(0.2376,0.6328),(0.2446,0.6053),(0.2498,0.6059),(0.242,0.581),(0.2505,0.5815),(0.25,0.5655),(0.2556,0.5661),(0.2501,0.5574),(0.2555,0.5566),(0.2376,0.5445),(0.2426,0.5434),(0.233,0.532),(0.2382,0.531),(0.2331,0.5085),(0.2388,0.5074),(0.2381,0.4852),(0.2442,0.4834),(0.2328,0.4682),(0.239,0.4658),(0.2232,0.4544),(0.2272,0.4508),(0.2103,0.4404),(0.1827,0.4333),(0.2174,0.4566),(0.2278,0.4694),(0.2322,0.4859),(0.2293,0.5085),(0.2296,0.5325),(0.2339,0.545),(0.2451,0.5571),(0.2456,0.5637),(0.2413,0.5803),(0.2413,0.6049),(0.2303,0.6291),(0.1843,0.466),(0.1953,0.4841),(0.1901,0.5046),(0.1882,0.4736),(0.1904,0.4622),(0.1736,0.4517),(0.1502,0.4471),(0.1257,0.447),(0.1896,0.5439),(0.1951,0.47),(0.2264,0.625),(0.2347,0.604),(0.2061,0.5993),(0.2318,0.5783),(0.2008,0.5492),(0.2228,0.5346),(0.2211,0.5079),(0.219,0.4748),(0.2216,0.4872),(0.1936,0.597),(0.2106,0.6488),(0.2117,0.4605),(0.2341,0.558),(0.2253,0.5447),(0.2101,0.645),(0.0147,0.505),(0.0148,0.5042),(0.015,0.5031),(0.0152,0.5017),(0.0153,0.5006),(0.0155,0.4997),(0.017,0.4978),(0.9461,0.1417),(0.9449,0.132),(0.9452,0.1323),(0.9463,0.142),(0.942,0.1226),(0.9423,0.1229),(0.9374,0.1138),(0.9378,0.1141),(0.9314,0.1059),(0.9318,0.1062),(0.9241,0.099),(0.9245,0.0994),(0.9158,0.0936),(0.9163,0.0939),(0.9067,0.0896),(0.9072,0.0899),(0.8972,0.0872),(0.8976,0.0876),(0.8874,0.0865),(0.8879,0.0869),(0.8776,0.0876),(0.8782,0.0879),(0.8683,0.0903),(0.8688,0.0906),(0.8595,0.0945),(0.8601,0.0949),(0.8517,0.1003),(0.8522,0.1007),(0.845,0.1073),(0.8455,0.1077),(0.8395,0.1154),(0.8401,0.1157),(0.8356,0.1242),(0.8362,0.1247),(0.8333,0.1337),(0.8338,0.1341),(0.8326,0.1434),(0.8332,0.1438),(0.8337,0.1531),(0.8342,0.1535),(0.8364,0.1624),(0.8369,0.1628),(0.8407,0.1711),(0.8412,0.1715),(0.8464,0.179),(0.847,0.1794),(0.8534,0.1857),(0.854,0.1861),(0.8615,0.1911),(0.8621,0.1915),(0.8705,0.1951),(0.871,0.1955),(0.88,0.1974),(0.8805,0.1978),(0.8898,0.1981),(0.8903,0.1985),(0.8997,0.1971),(0.9002,0.1975),(0.9093,0.1945),(0.9097,0.1948),(0.9183,0.1903),(0.9186,0.1906),(0.9264,0.1846),(0.9267,0.185),(0.9334,0.1777),(0.9337,0.178),(0.939,0.1697),(0.9393,0.17),(0.9431,0.1608),(0.9433,0.1611),(0.9455,0.1514),(0.9457,0.1517),(0.9429,0.1327),(0.9402,0.1237),(0.9358,0.1153),(0.9301,0.1077),(0.9232,0.1012),(0.9152,0.0959),(0.9065,0.0921),(0.8974,0.0899),(0.888,0.0892),(0.8786,0.0902),(0.8697,0.0928),(0.8613,0.0969),(0.8538,0.1024),(0.8473,0.1091),(0.8421,0.1169),(0.8384,0.1254),(0.8361,0.1345),(0.8355,0.1438),(0.8365,0.153),(0.8391,0.162),(0.8432,0.1704),(0.8487,0.1779),(0.8554,0.1844),(0.8632,0.1896),(0.8718,0.1933),(0.8809,0.1956),(0.8903,0.1963),(0.8997,0.1953),(0.9089,0.1928),(0.9175,0.1887),(0.9253,0.1833),(0.9319,0.1766),(0.9373,0.1689),(0.9412,0.1604),(0.9435,0.1514),(0.9441,0.142),(0.9447,0.1416),(0.9435,0.1322),(0.9441,0.1511),(0.9418,0.1603),(0.9378,0.169),(0.9323,0.1768),(0.9255,0.1835),(0.9175,0.1891),(0.9087,0.1932),(0.8994,0.1958),(0.8898,0.1967),(0.8801,0.196),(0.8708,0.1937),(0.8621,0.1899),(0.8542,0.1846),(0.8473,0.178),(0.8417,0.1704),(0.8376,0.1619),(0.8349,0.1527),(0.8339,0.1433),(0.8345,0.1338),(0.8368,0.1246),(0.8406,0.1159),(0.8459,0.1081),(0.8525,0.1012),(0.8602,0.0956),(0.8687,0.0914),(0.8778,0.0888),(0.8873,0.0878),(0.8969,0.0885),(0.9062,0.0908),(0.9151,0.0947),(0.9232,0.1),(0.9303,0.1067),(0.9362,0.1144),(0.9407,0.123),(0.9415,0.1417),(0.9404,0.1327),(0.941,0.1506),(0.9388,0.1593),(0.935,0.1674),(0.9298,0.1748),(0.9234,0.1812),(0.9159,0.1864),(0.9076,0.1903),(0.8988,0.1927),(0.8897,0.1936),(0.8806,0.1929),(0.8718,0.1908),(0.8635,0.1871),(0.8561,0.1821),(0.8496,0.1759),(0.8443,0.1687),(0.8404,0.1607),(0.8379,0.1521),(0.837,0.1432),(0.8375,0.1343),(0.8397,0.1256),(0.8433,0.1174),(0.8483,0.11),(0.8545,0.1035),(0.8617,0.0982),(0.8698,0.0943),(0.8784,0.0918),(0.8874,0.0909),(0.8964,0.0915),(0.9052,0.0937),(0.9136,0.0974),(0.9213,0.1024),(0.928,0.1087),(0.9335,0.116),(0.9377,0.1241),(0.9298,0.1419),(0.929,0.135),(0.9294,0.1488),(0.9277,0.1555),(0.9248,0.1618),(0.9208,0.1675),(0.9158,0.1725),(0.91,0.1765),(0.9036,0.1795),(0.8967,0.1813),(0.8897,0.182),(0.8826,0.1815),(0.8757,0.1798),(0.8693,0.177),(0.8635,0.1732),(0.8584,0.1683),(0.8543,0.1627),(0.8513,0.1565),(0.8493,0.1499),(0.8486,0.143),(0.8491,0.1361),(0.8507,0.1294),(0.8535,0.123),(0.8574,0.1173),(0.8622,0.1123),(0.8678,0.1082),(0.8741,0.1052),(0.8808,0.1033),(0.8878,0.1026),(0.8948,0.1031),(0.9017,0.1048),(0.9082,0.1076),(0.9142,0.1115),(0.9194,0.1164),(0.9237,0.122),(0.9269,0.1283),(0.9182,0.142),(0.9176,0.1371),(0.9179,0.147),(0.9167,0.1518),(0.9147,0.1563),(0.9118,0.1604),(0.9082,0.1639),(0.9041,0.1668),(0.8995,0.1689),(0.8946,0.1702),(0.8895,0.1707),(0.8845,0.1704),(0.8796,0.1692),(0.8749,0.1671),(0.8707,0.1643),(0.8671,0.1609),(0.8641,0.1569),(0.8619,0.1524),(0.8605,0.1477),(0.86,0.1428),(0.8603,0.1378),(0.8615,0.133),(0.8635,0.1285),(0.8663,0.1244),(0.8698,0.1209),(0.8738,0.1179),(0.8783,0.1158),(0.8831,0.1144),(0.8882,0.1139),(0.8932,0.1143),(0.8981,0.1155),(0.9028,0.1176),(0.9071,0.1203),(0.9108,0.1238),(0.9138,0.1279),(0.9162,0.1323),(0.6901,0.142),(0.6912,0.1323),(0.6915,0.132),(0.6903,0.1417),(0.6941,0.1229),(0.6944,0.1225),(0.6986,0.1141),(0.6989,0.1137),(0.7046,0.1062),(0.705,0.1058),(0.7118,0.0994),(0.7122,0.099),(0.7201,0.0939),(0.7205,0.0935),(0.7292,0.0899),(0.7296,0.0896),(0.7387,0.0876),(0.7392,0.0872),(0.7485,0.0869),(0.749,0.0865),(0.7582,0.0879),(0.7588,0.0875),(0.7676,0.0906),(0.7681,0.0902),(0.7763,0.0949),(0.7768,0.0945),(0.7841,0.1006),(0.7847,0.1003),(0.7909,0.1077),(0.7914,0.1073),(0.7963,0.1157),(0.7968,0.1153),(0.8002,0.1246),(0.8008,0.1242),(0.8025,0.1341),(0.8031,0.1337),(0.8032,0.1438),(0.8037,0.1434),(0.8021,0.1534),(0.8027,0.153),(0.7994,0.1628),(0.8,0.1624),(0.7952,0.1715),(0.7957,0.1711),(0.7894,0.1793),(0.79,0.179),(0.7824,0.1861),(0.783,0.1857),(0.7743,0.1915),(0.7749,0.1911),(0.7654,0.1954),(0.7659,0.1951),(0.7559,0.1978),(0.7564,0.1974),(0.7461,0.1985),(0.7465,0.1981),(0.7362,0.1975),(0.7367,0.1971),(0.7267,0.1948),(0.7271,0.1945),(0.7178,0.1906),(0.7181,0.1903),(0.7097,0.1849),(0.71,0.1846),(0.7027,0.178),(0.703,0.1777),(0.6971,0.17),(0.6974,0.1696),(0.693,0.1611),(0.6933,0.1608),(0.6907,0.1517),(0.6909,0.1514),(0.6923,0.142),(0.6929,0.1513),(0.6952,0.1604),(0.6991,0.1689),(0.7044,0.1766),(0.7111,0.1832),(0.7189,0.1887),(0.7275,0.1927),(0.7366,0.1953),(0.7461,0.1962),(0.7555,0.1956),(0.7646,0.1933),(0.7732,0.1895),(0.781,0.1843),(0.7877,0.1779),(0.7932,0.1703),(0.7973,0.162),(0.7999,0.153),(0.8009,0.1437),(0.8003,0.1344),(0.798,0.1254),(0.7943,0.1169),(0.7891,0.1091),(0.7826,0.1024),(0.7751,0.0969),(0.7667,0.0928),(0.7577,0.0902),(0.7484,0.0892),(0.739,0.0898),(0.7298,0.0921),(0.7212,0.0959),(0.7132,0.1012),(0.7063,0.1077),(0.7005,0.1153),(0.6962,0.1237),(0.6934,0.1327),(0.6929,0.1321),(0.6917,0.1416),(0.6923,0.1511),(0.6946,0.1603),(0.6986,0.1689),(0.7041,0.1768),(0.7109,0.1835),(0.7189,0.1891),(0.7276,0.1932),(0.737,0.1957),(0.7466,0.1967),(0.7562,0.196),(0.7656,0.1937),(0.7743,0.1899),(0.7822,0.1846),(0.7891,0.178),(0.7947,0.1704),(0.7988,0.1618),(0.8015,0.1527),(0.8025,0.1433),(0.8019,0.1338),(0.7996,0.1246),(0.7957,0.1159),(0.7905,0.108),(0.7839,0.1012),(0.7762,0.0956),(0.7677,0.0914),(0.7586,0.0888),(0.7491,0.0878),(0.7395,0.0885),(0.7301,0.0908),(0.7213,0.0946),(0.7131,0.1),(0.706,0.1066),(0.7002,0.1144),(0.6957,0.123),(0.696,0.1327),(0.6949,0.1416),(0.6954,0.1506),(0.6976,0.1593),(0.7014,0.1674),(0.7066,0.1748),(0.713,0.1812),(0.7205,0.1864),(0.7288,0.1902),(0.7376,0.1927),(0.7467,0.1936),(0.7558,0.1929),(0.7646,0.1908),(0.7728,0.1871),(0.7803,0.1821),(0.7868,0.1759),(0.792,0.1687),(0.796,0.1607),(0.7985,0.1521),(0.7994,0.1432),(0.7988,0.1343),(0.7967,0.1256),(0.7931,0.1174),(0.7881,0.11),(0.7819,0.1035),(0.7747,0.0982),(0.7666,0.0943),(0.758,0.0918),(0.749,0.0909),(0.74,0.0915),(0.7311,0.0937),(0.7228,0.0974),(0.7151,0.1024),(0.7084,0.1087),(0.7029,0.116),(0.6987,0.1241),(0.7074,0.1349),(0.7066,0.1419),(0.707,0.1488),(0.7087,0.1555),(0.7116,0.1618),(0.7156,0.1675),(0.7206,0.1724),(0.7264,0.1765),(0.7328,0.1795),(0.7397,0.1813),(0.7467,0.182),(0.7538,0.1815),(0.7607,0.1798),(0.7671,0.177),(0.7729,0.1731),(0.7779,0.1683),(0.7821,0.1627),(0.7851,0.1565),(0.7871,0.1499),(0.7878,0.143),(0.7873,0.1361),(0.7857,0.1293),(0.7829,0.123),(0.779,0.1173),(0.7742,0.1123),(0.7686,0.1082),(0.7623,0.1052),(0.7556,0.1033),(0.7486,0.1025),(0.7416,0.103),(0.7347,0.1047),(0.7282,0.1076),(0.7222,0.1115),(0.717,0.1163),(0.7127,0.122),(0.7095,0.1283),(0.7187,0.1371),(0.7181,0.142),(0.7185,0.147),(0.7197,0.1518),(0.7217,0.1563),(0.7246,0.1603),(0.7281,0.1639),(0.7323,0.1667),(0.7369,0.1689),(0.7418,0.1702),(0.7468,0.1707),(0.7519,0.1704),(0.7568,0.1691),(0.7615,0.1671),(0.7656,0.1643),(0.7693,0.1609),(0.7722,0.1569),(0.7744,0.1524),(0.7758,0.1477),(0.7764,0.1428),(0.7761,0.1378),(0.7749,0.133),(0.7728,0.1285),(0.7701,0.1244),(0.7666,0.1208),(0.7626,0.1179),(0.7581,0.1158),(0.7532,0.1144),(0.7482,0.1139),(0.7432,0.1143),(0.7382,0.1155),(0.7336,0.1175),(0.7293,0.1203),(0.7256,0.1238),(0.7225,0.1278),(0.7202,0.1323),(0.1715,0.184),(0.1733,0.1788),(0.144,0.1654),(0.1418,0.1705),(0.2546,0.1929),(0.252,0.1937),(0.2588,0.2134),(0.2595,0.2071),(0.2493,0.1736),(0.2467,0.1746),(0.2421,0.1576),(0.2396,0.1587),(0.238,0.1456),(0.2357,0.1473),(0.2245,0.1344),(0.2237,0.137),(0.2173,0.1328),(0.2166,0.1354),(0.1887,0.1326),(0.1885,0.1354),(0.1289,0.1222),(0.1275,0.1244),(0.1285,0.1249),(0.1299,0.1226),(0.1319,0.1269),(0.1332,0.1246),(0.1359,0.1292),(0.1371,0.1267),(0.1581,0.1324),(0.1586,0.1297),(0.1136,0.1473),(0.1151,0.145),(0.1139,0.144),(0.1124,0.1462),(0.1177,0.1506),(0.1194,0.1485),(0.1215,0.1559),(0.1233,0.1537),(0.2064,0.1951),(0.2077,0.1927),(0.2007,0.1896),(0.2,0.1922),(0.221,0.2056),(0.223,0.2036),(0.2262,0.2139),(0.2283,0.2122),(0.2391,0.2294),(0.2413,0.2277),(0.2466,0.2412),(0.2487,0.2395),(0.255,0.2509),(0.2554,0.2473),(0.1491,0.1547),(0.148,0.1571),(0.1777,0.167),(0.1786,0.1644),(0.1285,0.1451),(0.1271,0.1474),(0.1249,0.141),(0.1233,0.1433),(0.1213,0.1383),(0.1196,0.1405),(0.1202,0.1375),(0.1184,0.1396),(0.2058,0.1734),(0.2066,0.1708),(0.2125,0.176),(0.2138,0.1736),(0.2261,0.1861),(0.2282,0.1843),(0.2308,0.1953),(0.2332,0.1939),(0.2414,0.2103),(0.2438,0.2088),(0.2483,0.2254),(0.2506,0.224),(0.2563,0.2387),(0.2567,0.2342),(0.1386,0.1792),(0.1374,0.1816),(0.1669,0.1986),(0.1678,0.196),(0.1192,0.1631),(0.1173,0.1651),(0.1155,0.1569),(0.1138,0.159),(0.1111,0.1531),(0.1098,0.1555),(0.1099,0.1519),(0.1085,0.1543),(0.1947,0.2113),(0.1955,0.2086),(0.2008,0.2144),(0.2019,0.2119),(0.2172,0.2264),(0.219,0.2243),(0.2226,0.2336),(0.2245,0.2317),(0.2372,0.248),(0.2391,0.246),(0.245,0.2567),(0.2468,0.2547),(0.2535,0.2632),(0.2539,0.2601),(0.1127,0.1442),(0.1079,0.1506),(0.1174,0.1378),(0.1269,0.1251),(0.2619,0.2228),(0.2607,0.2417),(0.2599,0.2525),(0.2589,0.2633),(0.1186,0.0987),(0.1049,0.1139),(0.1192,0.1),(0.0864,0.1355),(0.0863,0.1339),(0.0977,0.1529),(0.101,0.1489),(0.0937,0.158),(0.0839,0.1418),(0.0919,0.1596),(0.0839,0.1429),(0.0917,0.1603),(0.121,0.1346),(0.1287,0.1243),(0.1244,0.1189),(0.1344,0.1014),(0.1248,0.0964),(0.1346,0.1021),(0.134,0.102),(0.1241,0.0956),(0.1314,0.1048),(0.1257,0.1137),(0.1213,0.1195),(0.1187,0.1244),(0.1161,0.1274),(0.1148,0.1303),(0.1122,0.133),(0.1102,0.1362),(0.1077,0.1399),(0.1051,0.1435),(0.1361,0.1068),(0.1283,0.1015),(0.0896,0.1415),(0.1238,0.1046),(0.0877,0.1476),(0.0945,0.1634),(0.1279,0.1062),(0.0911,0.1463),(0.0984,0.1633),(0.1055,0.1551),(0.1002,0.1471),(0.1132,0.1449),(0.1363,0.1124),(0.1355,0.1091),(0.1378,0.1065),(0.1413,0.109),(0.1389,0.1119),(0.1545,0.1297),(0.1589,0.1235),(0.1866,0.1238),(0.1828,0.1307),(0.1329,0.1228),(0.1369,0.116),(0.1408,0.1174),(0.1366,0.1245),(0.2576,0.1895),(0.2602,0.184),(0.2617,0.1954),(0.2087,0.1315),(0.2059,0.1388),(0.2348,0.1538),(0.2337,0.1613),(0.2492,0.2833),(0.2403,0.2826),(0.2458,0.2732),(0.2316,0.2796),(0.2136,0.2672),(0.2217,0.2583),(0.183,0.2456),(0.189,0.2372),(0.1558,0.2268),(0.1596,0.2175),(0.1273,0.2031),(0.1312,0.1941),(0.1084,0.1804),(0.1121,0.1733),(0.1045,0.1722),(0.1084,0.1657),(0.0992,0.1655),(0.1038,0.1596),(0.2685,0.2418),(0.2696,0.2506),(0.2551,0.2291),(0.2528,0.2207),(0.2307,0.2036),(0.2296,0.1973),(0.1983,0.182),(0.1985,0.1765),(0.1711,0.1682),(0.1727,0.1637),(0.1443,0.1572),(0.1461,0.1535),(0.1256,0.1468),(0.1272,0.1443),(0.1219,0.142),(0.1235,0.1399),(0.1179,0.1372),(0.1196,0.1355),(0.1453,0.1093),(0.1677,0.1061),(0.1634,0.113),(0.198,0.1021),(0.1915,0.1123),(0.2262,0.0957),(0.2152,0.1175),(0.2356,0.0977),(0.1239,0.1286),(0.1224,0.1309),(0.1275,0.1324),(0.1262,0.1349),(0.1314,0.1356),(0.1299,0.1384),(0.1506,0.1414),(0.1486,0.1451),(0.1781,0.1441),(0.1749,0.1525),(0.2017,0.1539),(0.1999,0.1642),(0.2314,0.1744),(0.2317,0.1852),(0.2533,0.2004),(0.2554,0.2098),(0.2648,0.2155),(0.2663,0.2248),(0.269,0.2619),(0.2674,0.2668),(0.2544,0.2485),(0.252,0.239),(0.2305,0.2238),(0.2286,0.2151),(0.1979,0.201),(0.1972,0.1939),(0.1685,0.1856),(0.1694,0.1796),(0.1407,0.17),(0.1418,0.1657),(0.1218,0.1557),(0.1228,0.1525),(0.1181,0.1499),(0.1191,0.1469),(0.1139,0.1445),(0.1151,0.1418),(0.1104,0.1501),(0.1081,0.1532),(0.1146,0.1557),(0.1127,0.1594),(0.1183,0.1622),(0.1167,0.1666),(0.1373,0.1792),(0.136,0.1849),(0.1659,0.1972),(0.164,0.2072),(0.1955,0.2136),(0.1945,0.2258),(0.2276,0.2358),(0.2272,0.2476),(0.2503,0.2575),(0.2509,0.2644),(0.2638,0.2749),(0.2614,0.2779),(0.2388,0.1405),(0.2478,0.1209),(0.2514,0.1383),(0.2556,0.1627),(0.2556,0.2816),(0.2426,0.1055),(0.2125,0.1213),(0.1899,0.1157),(0.2379,0.1449),(0.2581,0.1635),(0.2626,0.1851),(0.2578,0.1714),(0.2593,0.1784),(0.2477,0.2703),(0.2577,0.2811),(0.2666,0.2702),(0.2531,0.2516),(0.2517,0.2546),(0.2654,0.2729),(0.2295,0.2277),(0.2285,0.2317),(0.1971,0.2048),(0.1963,0.209),(0.1676,0.1891),(0.1667,0.193),(0.1397,0.1722),(0.1385,0.1753),(0.1207,0.1571),(0.1195,0.1593),(0.1169,0.151),(0.1157,0.1529),(0.1127,0.1455),(0.1115,0.1474),(0.2535,0.2173),(0.268,0.2366),(0.2673,0.2309),(0.2544,0.2137),(0.2302,0.1937),(0.231,0.1901),(0.1987,0.1727),(0.1991,0.169),(0.1731,0.16),(0.1737,0.1567),(0.1468,0.1504),(0.1476,0.1476),(0.1279,0.142),(0.1288,0.14),(0.1241,0.1378),(0.125,0.1361),(0.1203,0.1334),(0.1212,0.1319),(0.1879,0.1202),(0.2105,0.1264),(0.1606,0.1186),(0.1621,0.1152),(0.143,0.113),(0.236,0.1501),(0.1264,0.1234),(0.1295,0.1194),(0.1245,0.1264),(0.1299,0.1271),(0.1282,0.1303),(0.1338,0.1295),(0.1321,0.1333),(0.1526,0.1345),(0.1513,0.1384),(0.181,0.135),(0.1788,0.141),(0.2039,0.1447),(0.2024,0.1504),(0.2326,0.1655),(0.2318,0.171),(0.256,0.1931),(0.2545,0.1967),(0.2628,0.2024),(0.2639,0.2092),(0.117,0.1388),(0.1163,0.1408),(0.121,0.1436),(0.1203,0.1457),(0.1246,0.1487),(0.124,0.151),(0.1435,0.1601),(0.1428,0.1632),(0.1705,0.1717),(0.1701,0.1757),(0.1979,0.1856),(0.1977,0.1898),(0.2301,0.207),(0.2295,0.211),(0.2542,0.2322),(0.2532,0.2355),(0.2692,0.2541),(0.269,0.2582),(0.105,0.1569),(0.1064,0.1548),(0.1096,0.1632),(0.1111,0.1611),(0.1135,0.1708),(0.115,0.1686),(0.1327,0.1909),(0.1343,0.1879),(0.1614,0.2132),(0.1625,0.2104),(0.1911,0.233),(0.1927,0.2296),(0.2239,0.2543),(0.2255,0.2511),(0.2494,0.2674),(0.2596,0.2799),(0.1336,0.1128),(0.2438,0.2707),(0.2522,0.2729),(0.2694,0.2695),(0.2655,0.2776),(0.2687,0.227),(0.2709,0.2443),(0.2641,0.1968),(0.2672,0.2175),(0.272,0.2532),(0.271,0.2645),(0.1418,0.1083),(0.1458,0.1085),(0.1383,0.106),(0.0981,0.167),(0.1036,0.173),(0.1074,0.1815),(0.1266,0.2046),(0.1554,0.2286),(0.183,0.2476),(0.2138,0.2695),(0.232,0.282),(0.241,0.2852),(0.2501,0.2859),(0.2568,0.2843),(0.2628,0.2806),(0.2539,0.1385),(0.2501,0.1208),(0.2448,0.105),(0.2376,0.097),(0.228,0.0948),(0.1992,0.1011),(0.1685,0.1053),(0.1418,0.1098),(0.1458,0.11),(0.139,0.1087),(0.0993,0.1685),(0.1044,0.1732),(0.1082,0.1816),(0.1273,0.2047),(0.1562,0.2287),(0.1837,0.2477),(0.2146,0.2695),(0.2326,0.2821),(0.2414,0.2852),(0.2504,0.2859),(0.2569,0.2843),(0.2628,0.2806),(0.2654,0.2777),(0.2693,0.2696),(0.2713,0.2651),(0.2719,0.2535),(0.2708,0.2447),(0.2687,0.2274),(0.2672,0.2179),(0.264,0.1971),(0.2625,0.1855),(0.258,0.1639),(0.2537,0.1392),(0.25,0.1218),(0.2446,0.1062),(0.2375,0.0983),(0.228,0.0962),(0.1993,0.1024),(0.1686,0.1065),(0.0979,0.1666),(0.1136,0.1731),(0.11,0.1659),(0.133,0.1927),(0.162,0.2131),(0.1896,0.2289),(0.2357,0.2649),(0.2194,0.2515),(0.2582,0.271),(0.2626,0.2627),(0.265,0.2633),(0.2673,0.2669),(0.2691,0.2558),(0.2669,0.2455),(0.2706,0.2616),(0.1056,0.1619),(0.2142,0.2462),(0.1946,0.2317),(0.1043,0.1604),(0.138,0.1087),(0.1032,0.1569),(0.2614,0.2306),(0.2578,0.2235),(0.2512,0.2086),(0.2453,0.1916),(0.2366,0.1764),(0.2319,0.1656),(0.2191,0.1556),(0.2118,0.1532),(0.1836,0.15),(0.1537,0.1437),(0.1326,0.1373),(0.1288,0.1343),(0.1255,0.132),(0.1244,0.1314),(0.1221,0.1315),(0.2631,0.208),(0.2608,0.1975),(0.2557,0.1786),(0.251,0.1567),(0.2456,0.14),(0.241,0.1264),(0.231,0.1171),(0.2227,0.1153),(0.1942,0.1183),(0.1638,0.119),(0.1417,0.1193),(0.1378,0.1182),(0.1348,0.1167),(0.1338,0.1165),(0.1324,0.1193),(0.2652,0.2446),(0.1418,0.1705),(0.144,0.1654),(0.1733,0.1788),(0.1715,0.184),(0.2595,0.2071),(0.2588,0.2134),(0.252,0.1937),(0.2546,0.1929),(0.2467,0.1746),(0.2493,0.1736),(0.2396,0.1587),(0.2421,0.1576),(0.2357,0.1473),(0.238,0.1456),(0.2237,0.137),(0.2245,0.1344),(0.2166,0.1354),(0.2173,0.1328),(0.1885,0.1354),(0.1887,0.1326),(0.1299,0.1226),(0.1285,0.1249),(0.1275,0.1244),(0.1289,0.1222),(0.1332,0.1246),(0.1319,0.1269),(0.1371,0.1267),(0.1359,0.1292),(0.1586,0.1297),(0.1581,0.1324),(0.1124,0.1462),(0.1139,0.144),(0.1151,0.145),(0.1136,0.1473),(0.1194,0.1485),(0.1177,0.1506),(0.1233,0.1537),(0.1215,0.1559),(0.2,0.1922),(0.2007,0.1896),(0.2077,0.1927),(0.2064,0.1951),(0.223,0.2036),(0.221,0.2056),(0.2283,0.2122),(0.2262,0.2139),(0.2413,0.2277),(0.2391,0.2294),(0.2487,0.2395),(0.2466,0.2412),(0.2554,0.2473),(0.255,0.2509),(0.1786,0.1644),(0.1777,0.167),(0.148,0.1571),(0.1491,0.1547),(0.1271,0.1474),(0.1285,0.1451),(0.1233,0.1433),(0.1249,0.141),(0.1196,0.1405),(0.1213,0.1383),(0.1184,0.1396),(0.1202,0.1375),(0.2066,0.1708),(0.2058,0.1734),(0.2138,0.1736),(0.2125,0.176),(0.2282,0.1843),(0.2261,0.1861),(0.2332,0.1939),(0.2308,0.1953),(0.2438,0.2088),(0.2414,0.2103),(0.2506,0.224),(0.2483,0.2254),(0.2567,0.2342),(0.2563,0.2387),(0.1678,0.196),(0.1669,0.1986),(0.1374,0.1816),(0.1386,0.1792),(0.1173,0.1651),(0.1192,0.1631),(0.1138,0.159),(0.1155,0.1569),(0.1098,0.1555),(0.1111,0.1531),(0.1085,0.1543),(0.1099,0.1519),(0.1955,0.2086),(0.1947,0.2113),(0.2019,0.2119),(0.2008,0.2144),(0.219,0.2243),(0.2172,0.2264),(0.2245,0.2317),(0.2226,0.2336),(0.2391,0.246),(0.2372,0.248),(0.2468,0.2547),(0.245,0.2567),(0.2539,0.2601),(0.2535,0.2632),(0.1127,0.1442),(0.1079,0.1506),(0.1174,0.1378),(0.1269,0.1251),(0.2619,0.2228),(0.2607,0.2417),(0.2599,0.2525),(0.2589,0.2633),(0.1192,0.1),(0.1049,0.1139),(0.1186,0.0987),(0.0864,0.1355),(0.0863,0.1339),(0.101,0.1489),(0.0977,0.1529),(0.0839,0.1418),(0.0937,0.158),(0.0839,0.1429),(0.0919,0.1596),(0.0917,0.1603),(0.1244,0.1189),(0.1287,0.1243),(0.121,0.1346),(0.1346,0.1021),(0.1248,0.0964),(0.1344,0.1014),(0.1241,0.0956),(0.134,0.102),(0.1314,0.1048),(0.1257,0.1137),(0.1213,0.1195),(0.1187,0.1244),(0.1161,0.1274),(0.1148,0.1303),(0.1122,0.133),(0.1102,0.1362),(0.1077,0.1399),(0.1051,0.1435),(0.1283,0.1015),(0.1361,0.1068),(0.1238,0.1046),(0.0896,0.1415),(0.0945,0.1634),(0.0877,0.1476),(0.0911,0.1463),(0.1279,0.1062),(0.1002,0.1471),(0.1055,0.1551),(0.0984,0.1633),(0.1132,0.1449),(0.1363,0.1124),(0.1389,0.1119),(0.1413,0.109),(0.1378,0.1065),(0.1355,0.1091),(0.1828,0.1307),(0.1866,0.1238),(0.1589,0.1235),(0.1545,0.1297),(0.1366,0.1245),(0.1408,0.1174),(0.1369,0.116),(0.1329,0.1228),(0.2617,0.1954),(0.2602,0.184),(0.2576,0.1895),(0.2059,0.1388),(0.2087,0.1315),(0.2337,0.1613),(0.2348,0.1538),(0.2458,0.2732),(0.2403,0.2826),(0.2492,0.2833),(0.2217,0.2583),(0.2136,0.2672),(0.2316,0.2796),(0.189,0.2372),(0.183,0.2456),(0.1596,0.2175),(0.1558,0.2268),(0.1312,0.1941),(0.1273,0.2031),(0.1121,0.1733),(0.1084,0.1804),(0.1084,0.1657),(0.1045,0.1722),(0.1038,0.1596),(0.0992,0.1655),(0.2528,0.2207),(0.2551,0.2291),(0.2696,0.2506),(0.2685,0.2418),(0.2296,0.1973),(0.2307,0.2036),(0.1985,0.1765),(0.1983,0.182),(0.1727,0.1637),(0.1711,0.1682),(0.1461,0.1535),(0.1443,0.1572),(0.1272,0.1443),(0.1256,0.1468),(0.1235,0.1399),(0.1219,0.142),(0.1196,0.1355),(0.1179,0.1372),(0.1634,0.113),(0.1677,0.1061),(0.1453,0.1093),(0.1915,0.1123),(0.198,0.1021),(0.2152,0.1175),(0.2262,0.0957),(0.2356,0.0977),(0.1224,0.1309),(0.1239,0.1286),(0.1262,0.1349),(0.1275,0.1324),(0.1299,0.1384),(0.1314,0.1356),(0.1486,0.1451),(0.1506,0.1414),(0.1749,0.1525),(0.1781,0.1441),(0.1999,0.1642),(0.2017,0.1539),(0.2317,0.1852),(0.2314,0.1744),(0.2554,0.2098),(0.2533,0.2004),(0.2663,0.2248),(0.2648,0.2155),(0.252,0.239),(0.2544,0.2485),(0.2674,0.2668),(0.269,0.2619),(0.2286,0.2151),(0.2305,0.2238),(0.1972,0.1939),(0.1979,0.201),(0.1694,0.1796),(0.1685,0.1856),(0.1418,0.1657),(0.1407,0.17),(0.1228,0.1525),(0.1218,0.1557),(0.1191,0.1469),(0.1181,0.1499),(0.1151,0.1418),(0.1139,0.1445),(0.1081,0.1532),(0.1104,0.1501),(0.1127,0.1594),(0.1146,0.1557),(0.1167,0.1666),(0.1183,0.1622),(0.136,0.1849),(0.1373,0.1792),(0.164,0.2072),(0.1659,0.1972),(0.1945,0.2258),(0.1955,0.2136),(0.2272,0.2476),(0.2276,0.2358),(0.2509,0.2644),(0.2503,0.2575),(0.2614,0.2779),(0.2638,0.2749),(0.2514,0.1383),(0.2478,0.1209),(0.2388,0.1405),(0.2556,0.1627),(0.2556,0.2816),(0.2426,0.1055),(0.1899,0.1157),(0.2125,0.1213),(0.2379,0.1449),(0.2626,0.1851),(0.2581,0.1635),(0.2578,0.1714),(0.2593,0.1784),(0.2577,0.2811),(0.2477,0.2703),(0.2531,0.2516),(0.2666,0.2702),(0.2654,0.2729),(0.2517,0.2546),(0.2295,0.2277),(0.2285,0.2317),(0.1971,0.2048),(0.1963,0.209),(0.1676,0.1891),(0.1667,0.193),(0.1397,0.1722),(0.1385,0.1753),(0.1207,0.1571),(0.1195,0.1593),(0.1169,0.151),(0.1157,0.1529),(0.1127,0.1455),(0.1115,0.1474),(0.268,0.2366),(0.2535,0.2173),(0.2544,0.2137),(0.2673,0.2309),(0.2302,0.1937),(0.231,0.1901),(0.1987,0.1727),(0.1991,0.169),(0.1731,0.16),(0.1737,0.1567),(0.1468,0.1504),(0.1476,0.1476),(0.1279,0.142),(0.1288,0.14),(0.1241,0.1378),(0.125,0.1361),(0.1203,0.1334),(0.1212,0.1319),(0.2105,0.1264),(0.1879,0.1202),(0.1606,0.1186),(0.1621,0.1152),(0.143,0.113),(0.236,0.1501),(0.1295,0.1194),(0.1264,0.1234),(0.1245,0.1264),(0.1299,0.1271),(0.1282,0.1303),(0.1338,0.1295),(0.1321,0.1333),(0.1526,0.1345),(0.1513,0.1384),(0.181,0.135),(0.1788,0.141),(0.2039,0.1447),(0.2024,0.1504),(0.2326,0.1655),(0.2318,0.171),(0.256,0.1931),(0.2545,0.1967),(0.2628,0.2024),(0.2639,0.2092),(0.117,0.1388),(0.1163,0.1408),(0.121,0.1436),(0.1203,0.1457),(0.1246,0.1487),(0.124,0.151),(0.1435,0.1601),(0.1428,0.1632),(0.1705,0.1717),(0.1701,0.1757),(0.1979,0.1856),(0.1977,0.1898),(0.2301,0.207),(0.2295,0.211),(0.2542,0.2322),(0.2532,0.2355),(0.2692,0.2541),(0.269,0.2582),(0.105,0.1569),(0.1064,0.1548),(0.1096,0.1632),(0.1111,0.1611),(0.1135,0.1708),(0.115,0.1686),(0.1327,0.1909),(0.1343,0.1879),(0.1614,0.2132),(0.1625,0.2104),(0.1911,0.233),(0.1927,0.2296),(0.2239,0.2543),(0.2255,0.2511),(0.2494,0.2674),(0.2596,0.2799),(0.1336,0.1128),(0.2522,0.2729),(0.2438,0.2707),(0.2694,0.2695),(0.2655,0.2776),(0.2709,0.2443),(0.2687,0.227),(0.2672,0.2175),(0.2641,0.1968),(0.271,0.2645),(0.272,0.2532),(0.1458,0.1085),(0.1418,0.1083),(0.1383,0.106),(0.0981,0.167),(0.1036,0.173),(0.1074,0.1815),(0.1266,0.2046),(0.1554,0.2286),(0.183,0.2476),(0.2138,0.2695),(0.232,0.282),(0.241,0.2852),(0.2501,0.2859),(0.2568,0.2843),(0.2628,0.2806),(0.2539,0.1385),(0.2501,0.1208),(0.2448,0.105),(0.2376,0.097),(0.228,0.0948),(0.1992,0.1011),(0.1685,0.1053),(0.1458,0.11),(0.1418,0.1098),(0.139,0.1087),(0.0993,0.1685),(0.1044,0.1732),(0.1082,0.1816),(0.1273,0.2047),(0.1562,0.2287),(0.1837,0.2477),(0.2146,0.2695),(0.2326,0.2821),(0.2414,0.2852),(0.2504,0.2859),(0.2569,0.2843),(0.2628,0.2806),(0.2654,0.2777),(0.2693,0.2696),(0.2713,0.2651),(0.2719,0.2535),(0.2708,0.2447),(0.2687,0.2274),(0.2672,0.2179),(0.264,0.1971),(0.2625,0.1855),(0.258,0.1639),(0.2537,0.1392),(0.25,0.1218),(0.2446,0.1062),(0.2375,0.0983),(0.228,0.0962),(0.1993,0.1024),(0.1686,0.1065),(0.0979,0.1666),(0.11,0.1659),(0.1136,0.1731),(0.133,0.1927),(0.162,0.2131),(0.1896,0.2289),(0.2194,0.2515),(0.2357,0.2649),(0.2582,0.271),(0.2626,0.2627),(0.265,0.2633),(0.2669,0.2455),(0.2691,0.2558),(0.2673,0.2669),(0.2706,0.2616),(0.1056,0.1619),(0.2142,0.2462),(0.1946,0.2317),(0.1043,0.1604),(0.138,0.1087),(0.1032,0.1569),(0.2578,0.2235),(0.2614,0.2306),(0.2512,0.2086),(0.2453,0.1916),(0.2366,0.1764),(0.2319,0.1656),(0.2191,0.1556),(0.2118,0.1532),(0.1836,0.15),(0.1537,0.1437),(0.1326,0.1373),(0.1288,0.1343),(0.1255,0.132),(0.1244,0.1314),(0.1221,0.1315),(0.2608,0.1975),(0.2631,0.208),(0.2557,0.1786),(0.251,0.1567),(0.2456,0.14),(0.241,0.1264),(0.231,0.1171),(0.2227,0.1153),(0.1942,0.1183),(0.1638,0.119),(0.1417,0.1193),(0.1378,0.1182),(0.1348,0.1167),(0.1338,0.1165),(0.1324,0.1193),(0.2652,0.2446),(0.4074,0.2193),(0.4105,0.2229),(0.432,0.2003),(0.4293,0.1961),(0.5048,0.1433),(0.5024,0.1382),(0.5017,0.1581),(0.5044,0.1579),(0.5023,0.1777),(0.5051,0.1777),(0.4973,0.1958),(0.4998,0.1959),(0.4934,0.21),(0.4956,0.2108),(0.4825,0.2265),(0.4832,0.2291),(0.4769,0.2305),(0.4777,0.2331),(0.4569,0.2373),(0.4577,0.24),(0.4002,0.2639),(0.3986,0.2625),(0.396,0.2637),(0.3975,0.265),(0.4048,0.2607),(0.4033,0.2593),(0.4095,0.2574),(0.4079,0.2559),(0.4331,0.2482),(0.4319,0.246),(0.3826,0.2512),(0.3839,0.2525),(0.3859,0.2512),(0.3846,0.2498),(0.3904,0.2466),(0.3886,0.2456),(0.3938,0.2408),(0.392,0.2396),(0.4519,0.1782),(0.4532,0.1804),(0.4589,0.1749),(0.4571,0.1732),(0.4701,0.1593),(0.4678,0.1582),(0.4728,0.1498),(0.4704,0.149),(0.4808,0.1321),(0.4783,0.1313),(0.4845,0.1189),(0.4818,0.1182),(0.4885,0.1095),(0.4868,0.1063),(0.4406,0.2116),(0.439,0.2096),(0.4161,0.2284),(0.4178,0.2301),(0.3978,0.2445),(0.3993,0.2459),(0.3941,0.2494),(0.3956,0.2507),(0.3898,0.2533),(0.3914,0.2544),(0.3877,0.2546),(0.3892,0.2557),(0.464,0.1961),(0.4625,0.1937),(0.4701,0.1907),(0.4681,0.1888),(0.481,0.1754),(0.4782,0.1744),(0.4826,0.1647),(0.4799,0.1642),(0.4886,0.1474),(0.4858,0.147),(0.491,0.132),(0.4883,0.1317),(0.4941,0.1208),(0.4922,0.1169),(0.4238,0.1863),(0.4226,0.1842),(0.4006,0.2106),(0.4024,0.2124),(0.3865,0.233),(0.3886,0.2341),(0.3842,0.2396),(0.386,0.2409),(0.3806,0.244),(0.382,0.2457),(0.379,0.2455),(0.3803,0.2471),(0.4448,0.1645),(0.4437,0.1624),(0.4496,0.1592),(0.4482,0.1573),(0.4615,0.1423),(0.4594,0.1411),(0.4645,0.1342),(0.4622,0.1331),(0.4732,0.1164),(0.4708,0.1153),(0.4773,0.1058),(0.4748,0.1046),(0.4823,0.0983),(0.4807,0.0956),(0.3822,0.2527),(0.3782,0.2489),(0.3861,0.2566),(0.3944,0.2638),(0.5026,0.1289),(0.4956,0.1126),(0.4911,0.103),(0.4861,0.0935),(0.39,0.2895),(0.3773,0.2824),(0.3898,0.2907),(0.3632,0.2702),(0.3633,0.2717),(0.3737,0.253),(0.3705,0.2507),(0.3605,0.2656),(0.3661,0.2477),(0.3604,0.2646),(0.3641,0.2469),(0.3637,0.2463),(0.3925,0.2708),(0.3958,0.2641),(0.3889,0.2581),(0.4057,0.2801),(0.3956,0.2904),(0.4062,0.2807),(0.3953,0.2912),(0.4065,0.2802),(0.4035,0.2787),(0.3966,0.2733),(0.3922,0.2702),(0.3894,0.2671),(0.3871,0.2657),(0.3858,0.2638),(0.3835,0.2626),(0.3818,0.2606),(0.3797,0.2584),(0.3774,0.2562),(0.3979,0.2847),(0.4054,0.2756),(0.3935,0.2838),(0.365,0.2638),(0.3652,0.2425),(0.3627,0.2592),(0.3655,0.2591),(0.3972,0.2808),(0.3723,0.2549),(0.3756,0.2458),(0.3686,0.2412),(0.3825,0.252),(0.4043,0.271),(0.4143,0.2693),(0.4172,0.271),(0.4123,0.2744),(0.4095,0.273),(0.4537,0.2434),(0.4581,0.2494),(0.4359,0.2541),(0.4296,0.2496),(0.4108,0.2595),(0.4163,0.2639),(0.4113,0.2665),(0.4062,0.2623),(0.5105,0.153),(0.5126,0.1641),(0.5085,0.1599),(0.4684,0.2302),(0.4713,0.2371),(0.4915,0.1954),(0.4928,0.2029),(0.469,0.0892),(0.4594,0.0823),(0.468,0.0787),(0.4534,0.1111),(0.4425,0.1055),(0.4526,0.088),(0.4331,0.1404),(0.4251,0.1347),(0.4123,0.1693),(0.4061,0.162),(0.3918,0.2013),(0.3855,0.1943),(0.3797,0.2274),(0.374,0.2222),(0.3782,0.2357),(0.3727,0.2312),(0.3752,0.2427),(0.3695,0.2391),(0.4942,0.1341),(0.494,0.1259),(0.5011,0.1011),(0.503,0.1096),(0.4781,0.1628),(0.4773,0.1565),(0.4546,0.1934),(0.4528,0.1883),(0.4357,0.2143),(0.4329,0.2108),(0.4156,0.2323),(0.413,0.2298),(0.3993,0.2471),(0.3975,0.2457),(0.3956,0.2521),(0.3941,0.2511),(0.3913,0.2574),(0.3898,0.2567),(0.4435,0.263),(0.4497,0.2687),(0.4227,0.2695),(0.4645,0.2599),(0.4719,0.2687),(0.478,0.2498),(0.4924,0.2684),(0.4989,0.2635),(0.3941,0.26),(0.3956,0.2613),(0.3985,0.2551),(0.4,0.2566),(0.4025,0.2508),(0.4043,0.2524),(0.42,0.2384),(0.4228,0.2408),(0.4411,0.2241),(0.4463,0.2313),(0.4596,0.2054),(0.4632,0.2156),(0.4842,0.1733),(0.4873,0.1834),(0.5001,0.1425),(0.5009,0.1514),(0.5061,0.1256),(0.5075,0.1343),(0.4877,0.1183),(0.487,0.1088),(0.4929,0.0872),(0.4963,0.0911),(0.4723,0.1472),(0.4718,0.1391),(0.4491,0.1776),(0.4483,0.1708),(0.4284,0.201),(0.4264,0.1956),(0.4087,0.2235),(0.4066,0.2201),(0.3942,0.2421),(0.3927,0.2397),(0.3911,0.2482),(0.3898,0.2461),(0.3871,0.254),(0.3857,0.2521),(0.3799,0.2468),(0.3823,0.2487),(0.3836,0.2398),(0.3859,0.2424),(0.3857,0.232),(0.3881,0.2353),(0.3986,0.208),(0.4013,0.2128),(0.4185,0.1772),(0.422,0.1859),(0.4405,0.1489),(0.4439,0.1599),(0.4619,0.1191),(0.4659,0.1296),(0.4776,0.0955),(0.4797,0.1021),(0.4825,0.0793),(0.4862,0.0812),(0.5096,0.2121),(0.5056,0.234),(0.4965,0.2161),(0.5135,0.1855),(0.4752,0.0779),(0.5027,0.253),(0.4624,0.2569),(0.4755,0.2467),(0.4958,0.2114),(0.5146,0.1622),(0.5158,0.1839),(0.5141,0.1767),(0.5134,0.1696),(0.4775,0.0777),(0.472,0.0913),(0.4845,0.1065),(0.4908,0.0845),(0.4885,0.0825),(0.4821,0.1042),(0.4698,0.1361),(0.4679,0.133),(0.4469,0.1675),(0.4454,0.1639),(0.425,0.1927),(0.4235,0.1895),(0.4051,0.2185),(0.4033,0.216),(0.3914,0.239),(0.3899,0.2375),(0.3886,0.2456),(0.3873,0.2444),(0.3847,0.2518),(0.3836,0.2507),(0.5042,0.1144),(0.496,0.1368),(0.4979,0.1396),(0.5053,0.1198),(0.4798,0.1659),(0.4817,0.169),(0.4559,0.1971),(0.4574,0.2006),(0.4372,0.2176),(0.4387,0.2205),(0.4169,0.2346),(0.4184,0.2367),(0.4003,0.2487),(0.4014,0.25),(0.3965,0.2536),(0.3975,0.2546),(0.3922,0.2588),(0.3931,0.2597),(0.4732,0.242),(0.4599,0.2528),(0.4392,0.2583),(0.4417,0.2612),(0.4196,0.267),(0.494,0.2065),(0.4017,0.2666),(0.3985,0.2645),(0.3965,0.2628),(0.403,0.26),(0.401,0.258),(0.4075,0.2565),(0.4054,0.2541),(0.4265,0.246),(0.4243,0.2431),(0.4512,0.2396),(0.4479,0.2343),(0.4662,0.2246),(0.4643,0.2191),(0.4901,0.1915),(0.4884,0.1865),(0.5057,0.1572),(0.5032,0.1543),(0.5094,0.1462),(0.5084,0.1399),(0.3889,0.2558),(0.3881,0.2543),(0.3931,0.2501),(0.3922,0.2487),(0.3964,0.2445),(0.3954,0.2429),(0.4115,0.2277),(0.4102,0.2253),(0.4314,0.2078),(0.43,0.2043),(0.4516,0.185),(0.4504,0.1812),(0.4758,0.1537),(0.4742,0.1504),(0.4922,0.1236),(0.4901,0.121),(0.4994,0.0981),(0.4978,0.0945),(0.3767,0.2447),(0.3783,0.246),(0.3799,0.2375),(0.3817,0.2389),(0.3816,0.2293),(0.3836,0.2308),(0.394,0.2037),(0.3963,0.2059),(0.415,0.1726),(0.4166,0.1748),(0.436,0.1435),(0.4382,0.1461),(0.4567,0.1142),(0.4592,0.1165),(0.4749,0.0934),(0.48,0.0782),(0.4068,0.2705),(0.4756,0.0872),(0.4683,0.0921),(0.4937,0.084),(0.4866,0.078),(0.5044,0.1063),(0.5078,0.1227),(0.5092,0.1315),(0.5123,0.1508),(0.4972,0.0879),(0.5023,0.0979),(0.4224,0.2699),(0.4169,0.2714),(0.4119,0.2748),(0.368,0.2382),(0.3716,0.2307),(0.3726,0.2215),(0.3841,0.1931),(0.4052,0.1605),(0.4244,0.1328),(0.4418,0.1033),(0.4519,0.0856),(0.4589,0.0796),(0.4678,0.0758),(0.4752,0.075),(0.4828,0.0762),(0.5121,0.2108),(0.508,0.2329),(0.505,0.2524),(0.5011,0.2634),(0.4943,0.2686),(0.4733,0.2692),(0.4504,0.2692),(0.4215,0.2686),(0.4158,0.27),(0.4111,0.2722),(0.3687,0.2363),(0.3723,0.2303),(0.3733,0.2212),(0.3847,0.1928),(0.4058,0.1601),(0.4251,0.1325),(0.4425,0.1029),(0.4525,0.0853),(0.4594,0.0794),(0.468,0.0757),(0.4753,0.0749),(0.4827,0.0762),(0.4865,0.0779),(0.4935,0.0838),(0.4971,0.0872),(0.5021,0.0975),(0.5042,0.106),(0.5076,0.1223),(0.509,0.1312),(0.5121,0.1505),(0.5143,0.1619),(0.5156,0.1836),(0.5119,0.2102),(0.5077,0.232),(0.5045,0.2513),(0.5006,0.262),(0.4939,0.2671),(0.4731,0.2676),(0.4499,0.2677),(0.3676,0.2384),(0.3795,0.2348),(0.381,0.2271),(0.3936,0.2019),(0.4154,0.1725),(0.4358,0.1478),(0.454,0.1181),(0.4631,0.1003),(0.4823,0.0868),(0.4899,0.0927),(0.4921,0.0913),(0.5003,0.1068),(0.4988,0.0965),(0.4928,0.0871),(0.4979,0.0907),(0.376,0.2399),(0.4514,0.1246),(0.4393,0.1434),(0.3747,0.2416),(0.408,0.2729),(0.3737,0.2451),(0.4984,0.1298),(0.4998,0.1222),(0.4962,0.145),(0.4956,0.1624),(0.4917,0.1796),(0.4891,0.1918),(0.478,0.2078),(0.4718,0.213),(0.4494,0.2241),(0.4247,0.2377),(0.4037,0.2505),(0.3996,0.2545),(0.3953,0.2579),(0.393,0.2591),(0.3901,0.2602),(0.5089,0.1513),(0.508,0.1412),(0.5099,0.1707),(0.509,0.1931),(0.5031,0.2135),(0.4982,0.2313),(0.4901,0.2453),(0.4841,0.2497),(0.465,0.2529),(0.4414,0.2568),(0.415,0.2619),(0.41,0.2643),(0.4055,0.2669),(0.4027,0.2678),(0.3998,0.2666),(0.499,0.1082),(0.4293,0.1961),(0.432,0.2003),(0.4105,0.2229),(0.4074,0.2193),(0.5044,0.1579),(0.5017,0.1581),(0.5024,0.1382),(0.5048,0.1433),(0.5051,0.1777),(0.5023,0.1777),(0.4998,0.1959),(0.4973,0.1958),(0.4956,0.2108),(0.4934,0.21),(0.4832,0.2291),(0.4825,0.2265),(0.4777,0.2331),(0.4769,0.2305),(0.4577,0.24),(0.4569,0.2373),(0.3975,0.265),(0.396,0.2637),(0.3986,0.2625),(0.4002,0.2639),(0.4033,0.2593),(0.4048,0.2607),(0.4079,0.2559),(0.4095,0.2574),(0.4319,0.246),(0.4331,0.2482),(0.3846,0.2498),(0.3859,0.2512),(0.3839,0.2525),(0.3826,0.2512),(0.3886,0.2456),(0.3904,0.2466),(0.392,0.2396),(0.3938,0.2408),(0.4571,0.1732),(0.4589,0.1749),(0.4532,0.1804),(0.4519,0.1782),(0.4678,0.1582),(0.4701,0.1593),(0.4704,0.149),(0.4728,0.1498),(0.4783,0.1313),(0.4808,0.1321),(0.4818,0.1182),(0.4845,0.1189),(0.4868,0.1063),(0.4885,0.1095),(0.4178,0.2301),(0.4161,0.2284),(0.439,0.2096),(0.4406,0.2116),(0.3993,0.2459),(0.3978,0.2445),(0.3956,0.2507),(0.3941,0.2494),(0.3914,0.2544),(0.3898,0.2533),(0.3892,0.2557),(0.3877,0.2546),(0.4625,0.1937),(0.464,0.1961),(0.4681,0.1888),(0.4701,0.1907),(0.4782,0.1744),(0.481,0.1754),(0.4799,0.1642),(0.4826,0.1647),(0.4858,0.147),(0.4886,0.1474),(0.4883,0.1317),(0.491,0.132),(0.4922,0.1169),(0.4941,0.1208),(0.4024,0.2124),(0.4006,0.2106),(0.4226,0.1842),(0.4238,0.1863),(0.3886,0.2341),(0.3865,0.233),(0.386,0.2409),(0.3842,0.2396),(0.382,0.2457),(0.3806,0.244),(0.3803,0.2471),(0.379,0.2455),(0.4437,0.1624),(0.4448,0.1645),(0.4482,0.1573),(0.4496,0.1592),(0.4594,0.1411),(0.4615,0.1423),(0.4622,0.1331),(0.4645,0.1342),(0.4708,0.1153),(0.4732,0.1164),(0.4748,0.1046),(0.4773,0.1058),(0.4807,0.0956),(0.4823,0.0983),(0.3822,0.2527),(0.3782,0.2489),(0.3861,0.2566),(0.3944,0.2638),(0.5026,0.1289),(0.4956,0.1126),(0.4911,0.103),(0.4861,0.0935),(0.3898,0.2907),(0.3773,0.2824),(0.39,0.2895),(0.3632,0.2702),(0.3633,0.2717),(0.3705,0.2507),(0.3737,0.253),(0.3661,0.2477),(0.3605,0.2656),(0.3641,0.2469),(0.3604,0.2646),(0.3637,0.2463),(0.3889,0.2581),(0.3958,0.2641),(0.3925,0.2708),(0.4062,0.2807),(0.3956,0.2904),(0.4057,0.2801),(0.4065,0.2802),(0.3953,0.2912),(0.4035,0.2787),(0.3966,0.2733),(0.3922,0.2702),(0.3894,0.2671),(0.3871,0.2657),(0.3858,0.2638),(0.3835,0.2626),(0.3818,0.2606),(0.3797,0.2584),(0.3774,0.2562),(0.4054,0.2756),(0.3979,0.2847),(0.365,0.2638),(0.3935,0.2838),(0.3627,0.2592),(0.3652,0.2425),(0.3972,0.2808),(0.3655,0.2591),(0.3686,0.2412),(0.3756,0.2458),(0.3723,0.2549),(0.3825,0.252),(0.4043,0.271),(0.4095,0.273),(0.4123,0.2744),(0.4172,0.271),(0.4143,0.2693),(0.4296,0.2496),(0.4359,0.2541),(0.4581,0.2494),(0.4537,0.2434),(0.4062,0.2623),(0.4113,0.2665),(0.4163,0.2639),(0.4108,0.2595),(0.5085,0.1599),(0.5126,0.1641),(0.5105,0.153),(0.4713,0.2371),(0.4684,0.2302),(0.4928,0.2029),(0.4915,0.1954),(0.468,0.0787),(0.4594,0.0823),(0.469,0.0892),(0.4526,0.088),(0.4425,0.1055),(0.4534,0.1111),(0.4251,0.1347),(0.4331,0.1404),(0.4061,0.162),(0.4123,0.1693),(0.3855,0.1943),(0.3918,0.2013),(0.374,0.2222),(0.3797,0.2274),(0.3727,0.2312),(0.3782,0.2357),(0.3695,0.2391),(0.3752,0.2427),(0.503,0.1096),(0.5011,0.1011),(0.494,0.1259),(0.4942,0.1341),(0.4773,0.1565),(0.4781,0.1628),(0.4528,0.1883),(0.4546,0.1934),(0.4329,0.2108),(0.4357,0.2143),(0.413,0.2298),(0.4156,0.2323),(0.3975,0.2457),(0.3993,0.2471),(0.3941,0.2511),(0.3956,0.2521),(0.3898,0.2567),(0.3913,0.2574),(0.4227,0.2695),(0.4497,0.2687),(0.4435,0.263),(0.4719,0.2687),(0.4645,0.2599),(0.4924,0.2684),(0.478,0.2498),(0.4989,0.2635),(0.3956,0.2613),(0.3941,0.26),(0.4,0.2566),(0.3985,0.2551),(0.4043,0.2524),(0.4025,0.2508),(0.4228,0.2408),(0.42,0.2384),(0.4463,0.2313),(0.4411,0.2241),(0.4632,0.2156),(0.4596,0.2054),(0.4873,0.1834),(0.4842,0.1733),(0.5009,0.1514),(0.5001,0.1425),(0.5075,0.1343),(0.5061,0.1256),(0.4963,0.0911),(0.4929,0.0872),(0.487,0.1088),(0.4877,0.1183),(0.4718,0.1391),(0.4723,0.1472),(0.4483,0.1708),(0.4491,0.1776),(0.4264,0.1956),(0.4284,0.201),(0.4066,0.2201),(0.4087,0.2235),(0.3927,0.2397),(0.3942,0.2421),(0.3898,0.2461),(0.3911,0.2482),(0.3857,0.2521),(0.3871,0.254),(0.3823,0.2487),(0.3799,0.2468),(0.3859,0.2424),(0.3836,0.2398),(0.3881,0.2353),(0.3857,0.232),(0.4013,0.2128),(0.3986,0.208),(0.422,0.1859),(0.4185,0.1772),(0.4439,0.1599),(0.4405,0.1489),(0.4659,0.1296),(0.4619,0.1191),(0.4797,0.1021),(0.4776,0.0955),(0.4862,0.0812),(0.4825,0.0793),(0.4965,0.2161),(0.5056,0.234),(0.5096,0.2121),(0.5135,0.1855),(0.4752,0.0779),(0.5027,0.253),(0.4755,0.2467),(0.4624,0.2569),(0.4958,0.2114),(0.5158,0.1839),(0.5146,0.1622),(0.5141,0.1767),(0.5134,0.1696),(0.472,0.0913),(0.4775,0.0777),(0.4908,0.0845),(0.4845,0.1065),(0.4821,0.1042),(0.4885,0.0825),(0.4698,0.1361),(0.4679,0.133),(0.4469,0.1675),(0.4454,0.1639),(0.425,0.1927),(0.4235,0.1895),(0.4051,0.2185),(0.4033,0.216),(0.3914,0.239),(0.3899,0.2375),(0.3886,0.2456),(0.3873,0.2444),(0.3847,0.2518),(0.3836,0.2507),(0.496,0.1368),(0.5042,0.1144),(0.5053,0.1198),(0.4979,0.1396),(0.4798,0.1659),(0.4817,0.169),(0.4559,0.1971),(0.4574,0.2006),(0.4372,0.2176),(0.4387,0.2205),(0.4169,0.2346),(0.4184,0.2367),(0.4003,0.2487),(0.4014,0.25),(0.3965,0.2536),(0.3975,0.2546),(0.3922,0.2588),(0.3931,0.2597),(0.4599,0.2528),(0.4732,0.242),(0.4392,0.2583),(0.4417,0.2612),(0.4196,0.267),(0.494,0.2065),(0.3985,0.2645),(0.4017,0.2666),(0.3965,0.2628),(0.403,0.26),(0.401,0.258),(0.4075,0.2565),(0.4054,0.2541),(0.4265,0.246),(0.4243,0.2431),(0.4512,0.2396),(0.4479,0.2343),(0.4662,0.2246),(0.4643,0.2191),(0.4901,0.1915),(0.4884,0.1865),(0.5057,0.1572),(0.5032,0.1543),(0.5094,0.1462),(0.5084,0.1399),(0.3889,0.2558),(0.3881,0.2543),(0.3931,0.2501),(0.3922,0.2487),(0.3964,0.2445),(0.3954,0.2429),(0.4115,0.2277),(0.4102,0.2253),(0.4314,0.2078),(0.43,0.2043),(0.4516,0.185),(0.4504,0.1812),(0.4758,0.1537),(0.4742,0.1504),(0.4922,0.1236),(0.4901,0.121),(0.4994,0.0981),(0.4978,0.0945),(0.3767,0.2447),(0.3783,0.246),(0.3799,0.2375),(0.3817,0.2389),(0.3816,0.2293),(0.3836,0.2308),(0.394,0.2037),(0.3963,0.2059),(0.415,0.1726),(0.4166,0.1748),(0.436,0.1435),(0.4382,0.1461),(0.4567,0.1142),(0.4592,0.1165),(0.4749,0.0934),(0.48,0.0782),(0.4068,0.2705),(0.4683,0.0921),(0.4756,0.0872),(0.4937,0.084),(0.4866,0.078),(0.5078,0.1227),(0.5044,0.1063),(0.5123,0.1508),(0.5092,0.1315),(0.5023,0.0979),(0.4972,0.0879),(0.4169,0.2714),(0.4224,0.2699),(0.4119,0.2748),(0.368,0.2382),(0.3716,0.2307),(0.3726,0.2215),(0.3841,0.1931),(0.4052,0.1605),(0.4244,0.1328),(0.4418,0.1033),(0.4519,0.0856),(0.4589,0.0796),(0.4678,0.0758),(0.4752,0.075),(0.4828,0.0762),(0.5121,0.2108),(0.508,0.2329),(0.505,0.2524),(0.5011,0.2634),(0.4943,0.2686),(0.4733,0.2692),(0.4504,0.2692),(0.4158,0.27),(0.4215,0.2686),(0.4111,0.2722),(0.3687,0.2363),(0.3723,0.2303),(0.3733,0.2212),(0.3847,0.1928),(0.4058,0.1601),(0.4251,0.1325),(0.4425,0.1029),(0.4525,0.0853),(0.4594,0.0794),(0.468,0.0757),(0.4753,0.0749),(0.4827,0.0762),(0.4865,0.0779),(0.4935,0.0838),(0.4971,0.0872),(0.5021,0.0975),(0.5042,0.106),(0.5076,0.1223),(0.509,0.1312),(0.5121,0.1505),(0.5143,0.1619),(0.5156,0.1836),(0.5119,0.2102),(0.5077,0.232),(0.5045,0.2513),(0.5006,0.262),(0.4939,0.2671),(0.4731,0.2676),(0.4499,0.2677),(0.3676,0.2384),(0.381,0.2271),(0.3795,0.2348),(0.3936,0.2019),(0.4154,0.1725),(0.4358,0.1478),(0.4631,0.1003),(0.454,0.1181),(0.4823,0.0868),(0.4899,0.0927),(0.4921,0.0913),(0.4928,0.0871),(0.4988,0.0965),(0.5003,0.1068),(0.4979,0.0907),(0.376,0.2399),(0.4514,0.1246),(0.4393,0.1434),(0.3747,0.2416),(0.408,0.2729),(0.3737,0.2451),(0.4998,0.1222),(0.4984,0.1298),(0.4962,0.145),(0.4956,0.1624),(0.4917,0.1796),(0.4891,0.1918),(0.478,0.2078),(0.4718,0.213),(0.4494,0.2241),(0.4247,0.2377),(0.4037,0.2505),(0.3996,0.2545),(0.3953,0.2579),(0.393,0.2591),(0.3901,0.2602),(0.508,0.1412),(0.5089,0.1513),(0.5099,0.1707),(0.509,0.1931),(0.5031,0.2135),(0.4982,0.2313),(0.4901,0.2453),(0.4841,0.2497),(0.465,0.2529),(0.4414,0.2568),(0.415,0.2619),(0.41,0.2643),(0.4055,0.2669),(0.4027,0.2678),(0.3998,0.2666),(0.499,0.1082)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Fish.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Fish.py load and self-test diagnostics complete.")
