####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python EightCoded.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='EightCoded.x3d',name='title'),
    meta(content='ASCII-coded IndexedFaceSet example.',name='description'),
    meta(content='Martin Isenburg',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='4 May 2003',name='created'),
    meta(content='5 May 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Eight.png',name='Image'),
    meta(content='X3D VRML binary compression',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/EightCoded.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='EightCoded.x3d'),
    ExternProtoDeclare(appinfo='An ASCII-coded IndexedFaceSet',name='CodedIndexedFaceSet',url=["CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.x3d#CodedIndexedFaceSet","CodedCompressedPrototypes.wrl#CodedIndexedFaceSet","https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/CodedCompressedPrototypes.wrl#CodedIndexedFaceSet"],
      field=[
      field(accessType='initializeOnly',appinfo='ASCII-coded coordIndex and texCoordIndex values',name='code',type='MFInt32'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for Coordinate values',name='pos',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='dequantization multiplier for TextureCoordinate values',name='tex',type='SFFloat'),
      field(accessType='initializeOnly',appinfo='Coordinate node',name='coord',type='SFNode'),
      field(accessType='initializeOnly',appinfo='TextureCoordinate node',name='texCoord',type='SFNode')]),
    Viewpoint(description='1M view from above',orientation=(1,0,0,-1.5707999),position=(0,1,0)),
    Viewpoint(description='1M view from side',position=(0,0,1)),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(scale=(0.25,0.25,0.25),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1.0,0.5,0.5))),
        geometry=ProtoInstance(name='CodedIndexedFaceSet',
          fieldValue=[
          fieldValue(name='code',value=[6144,3,0,5,0,0,5,5,0,5,0,0,5,5,0,5,5,0,5,0,0,0,3,1,1,1,2,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,0,0,4,0,8,11,0,5,0,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,0,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,3,2,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,1,1,1,1,2,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,5,0,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,5,0,5,5,0,5,5,0,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,0,5,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,0,0,0,0,0,4,0,20,15,0,5,0,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,0,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,0,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,3,2,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,1,2,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,0,5,5,5,0,5,5,5,0,5,5,5,0,5,5,5,0,5,5,5,5,0,5,5,5,5,5,5,2]),
          fieldValue(name='pos',value=0.0025043988),
          fieldValue(name='coord',
            children=[
            Coordinate(point=[(-24.0,17.0,39.0),(22.0,-17.0,-4.0),(16.0,-26.0,-5.0),(3.0,1.0,-32.0),(11.0,0.0,-29.0),(18.0,-1.0,-25.0),(-35.0,26.0,23.0),(-34.0,17.0,31.0),(-27.0,6.0,42.0),(-25.0,-6.0,0.0),(-21.0,-18.0,-2.0),(-13.0,-26.0,-4.0),(41.0,-102.0,31.0),(24.0,-6.0,-8.0),(-45.0,23.0,17.0),(-14.0,26.0,9.0),(-4.0,30.0,8.0),(6.0,30.0,4.0),(16.0,25.0,1.0),(21.0,18.0,-3.0),(25.0,6.0,-6.0),(24.0,-6.0,-8.0),(21.0,-17.0,-9.0),(14.0,-26.0,-9.0),(4.0,-30.0,-8.0),(-7.0,-30.0,-5.0),(-15.0,-25.0,-1.0),(-22.0,-18.0,4.0),(10.0,0.0,38.0),(22.0,0.0,35.0),(-44.0,-6.0,-22.0),(-21.0,6.0,13.0),(-18.0,17.0,14.0),(-11.0,26.0,12.0),(-1.0,30.0,9.0),(8.0,30.0,3.0),(15.0,26.0,-3.0),(21.0,17.0,-9.0),(22.0,6.0,-12.0),(22.0,-6.0,-13.0),(17.0,-17.0,-14.0),(11.0,-26.0,-12.0),(1.0,-30.0,-9.0),(-8.0,-30.0,-3.0),(-15.0,-26.0,3.0),(18.0,0.0,30.0),(27.0,0.0,24.0),(-14.0,-17.0,18.0),(-49.0,-7.0,-11.0),(-17.0,7.0,18.0),(-14.0,17.0,18.0),(-7.0,26.0,15.0),(1.0,30.0,8.0),(9.0,30.0,2.0),(14.0,26.0,-7.0),(18.0,17.0,-14.0),(19.0,6.0,-17.0),(17.0,-6.0,-19.0),(14.0,-17.0,-18.0),(6.0,-26.0,-14.0),(-1.0,-30.0,-9.0),(-8.0,-30.0,-1.0),(24.0,0.0,21.0),(28.0,0.0,14.0),(-9.0,-26.0,13.0),(-9.0,-17.0,20.0),(-50.0,-7.0,2.0),(-12.0,7.0,23.0),(-8.0,17.0,20.0),(-3.0,26.0,16.0),(3.0,30.0,9.0),(9.0,30.0,-1.0),(12.0,26.0,-11.0),(14.0,17.0,-18.0),(14.0,6.0,-21.0),(11.0,-6.0,-23.0),(9.0,-17.0,-20.0),(3.0,-26.0,-16.0),(-3.0,-30.0,-9.0),(28.0,0.0,12.0),(30.0,0.0,4.0),(-7.0,-30.0,6.0),(-6.0,-26.0,15.0),(-3.0,-17.0,22.0),(-48.0,-7.0,15.0),(-6.0,7.0,24.0),(-2.0,17.0,23.0),(1.0,26.0,16.0),(5.0,30.0,7.0),(8.0,30.0,-4.0),(10.0,26.0,-13.0),(8.0,17.0,-21.0),(8.0,6.0,-24.0),(6.0,-6.0,-25.0),(2.0,-17.0,-22.0),(-1.0,-26.0,-16.0),(32.0,0.0,3.0),(31.0,0.0,-6.0),(-8.0,-30.0,-4.0),(-6.0,-30.0,7.0),(-1.0,-26.0,16.0),(3.0,-17.0,22.0),(-43.0,-7.0,27.0),(1.0,7.0,26.0),(3.0,17.0,22.0),(6.0,26.0,15.0),(7.0,30.0,5.0),(7.0,30.0,-5.0),(5.0,26.0,-15.0),(3.0,17.0,-22.0),(1.0,6.0,-26.0),(-1.0,-6.0,-25.0),(-3.0,-17.0,-22.0),(35.0,0.0,-8.0),(32.0,0.0,-17.0),(-12.0,-26.0,-10.0),(-9.0,-30.0,-2.0),(-3.0,-30.0,9.0),(3.0,-26.0,15.0),(8.0,-17.0,21.0),(-34.0,-7.0,37.0),(7.0,7.0,24.0),(9.0,17.0,21.0),(9.0,26.0,13.0),(8.0,30.0,4.0),(6.0,30.0,-7.0),(1.0,26.0,-16.0),(-3.0,17.0,-23.0),(-5.0,6.0,-24.0),(-8.0,-6.0,-25.0),(37.0,0.0,-19.0),(30.0,0.0,-29.0),(-18.0,-17.0,-13.0),(-14.0,-26.0,-7.0),(-9.0,-30.0,1.0),(-1.0,-30.0,9.0),(7.0,-26.0,14.0),(13.0,-17.0,18.0),(-23.0,-7.0,45.0),(13.0,7.0,21.0),(14.0,17.0,18.0),(12.0,26.0,11.0),(9.0,30.0,1.0),(3.0,30.0,-9.0),(-3.0,26.0,-16.0),(-8.0,17.0,-20.0),(-12.0,6.0,-23.0),(35.0,0.0,-33.0),(25.0,0.0,-40.0),(-22.0,-6.0,-12.0),(-20.0,-18.0,-8.0),(-16.0,-25.0,-3.0),(-8.0,-30.0,3.0),(2.0,-30.0,9.0),(10.0,-26.0,12.0),(16.0,0.0,-32.0),(1.0,-17.0,46.0),(-11.0,-7.0,49.0),(19.0,7.0,17.0),(18.0,17.0,13.0),(15.0,26.0,8.0),(8.0,30.0,-2.0),(1.0,30.0,-8.0),(-7.0,26.0,-15.0),(-13.0,17.0,-18.0),(29.0,0.0,-45.0),(14.0,0.0,-50.0),(-23.0,5.0,-8.0),(-25.0,-6.0,-6.0),(-21.0,-17.0,-3.0),(-15.0,-26.0,0.0),(-7.0,-30.0,5.0),(4.0,-30.0,8.0),(6.0,0.0,-31.0),(-2.0,0.0,-31.0),(18.0,-25.0,36.0),(12.0,-17.0,44.0),(2.0,-7.0,50.0),(23.0,7.0,12.0),(20.0,17.0,9.0),(16.0,26.0,3.0),(8.0,30.0,-3.0),(-2.0,30.0,-9.0),(-11.0,26.0,-12.0),(18.0,-1.0,-55.0),(2.0,0.0,-56.0),(-22.0,17.0,-4.0),(-25.0,6.0,-2.0),(-24.0,-7.0,0.0),(-20.0,-17.0,1.0),(-14.0,-25.0,5.0),(-5.0,-30.0,6.0),(-4.0,-1.0,-30.0),(-12.0,0.0,-27.0),(-18.0,0.0,-23.0),(-27.0,30.0,-25.0),(55.0,-59.0,51.0),(26.0,-25.0,31.0),(24.0,-17.0,38.0),(15.0,-6.0,48.0),(24.0,6.0,6.0),(22.0,17.0,3.0),(16.0,26.0,0.0),(6.0,30.0,-5.0),(-5.0,30.0,-8.0),(4.0,0.0,-60.0),(-12.0,0.0,-60.0),(-17.0,25.0,-1.0),(-22.0,17.0,2.0),(-23.0,6.0,4.0),(-23.0,-7.0,5.0),(-19.0,-17.0,7.0),(-12.0,-26.0,7.0),(-14.0,0.0,-28.0),(-20.0,0.0,-23.0),(-55.0,0.0,-27.0),(-31.0,1.0,-3.0),(-30.0,0.0,5.0),(-28.0,1.0,13.0),(-40.0,25.0,13.0),(-40.0,17.0,22.0),(-37.0,7.0,34.0),(-23.0,-7.0,-6.0),(-19.0,-17.0,-7.0),(-11.0,-26.0,-7.0),(-13.0,-30.0,56.0),(7.0,-29.0,-6.0),(16.0,-26.0,-6.0),(22.0,-16.0,-3.0),(25.0,-6.0,-3.0),(24.0,6.0,-1.0),(21.0,17.0,2.0),(14.0,26.0,5.0),(5.0,30.0,6.0),(4.0,0.0,-30.0),(12.0,0.0,-27.0),(19.0,0.0,-23.0),(24.0,0.0,-17.0),(28.0,0.0,-11.0),(29.0,-1.0,-3.0),(29.0,-1.0,4.0),(27.0,0.0,11.0),(33.0,-30.0,18.0),(34.0,-25.0,23.0),(33.0,-17.0,31.0),(27.0,-6.0,42.0),(25.0,6.0,0.0),(21.0,18.0,-2.0),(14.0,26.0,-4.0),(3.0,29.0,-6.0),(-10.0,1.0,-61.0),(-22.0,0.0,-61.0),(-9.0,29.0,-5.0),(-16.0,25.0,5.0),(-22.0,18.0,10.0),(-23.0,6.0,9.0),(-21.0,-7.0,10.0),(-16.0,-18.0,12.0),(-24.0,1.0,-26.0),(-28.0,0.0,-18.0),(-34.0,0.0,-10.0),(-35.0,0.0,-3.0),(-35.0,0.0,7.0),(-31.0,0.0,15.0),(-44.0,17.0,11.0),(-44.0,6.0,24.0),(-20.0,-6.0,-12.0),(-18.0,-18.0,-11.0),(-10.0,-25.0,-11.0),(-23.0,-30.0,53.0),(8.0,-29.0,-5.0),(17.0,-25.0,-2.0),(22.0,-17.0,2.0),(24.0,-6.0,4.0),(23.0,6.0,5.0),(19.0,18.0,7.0),(12.0,25.0,8.0),(14.0,1.0,-28.0),(21.0,0.0,-23.0),(26.0,0.0,-16.0),(29.0,-1.0,-10.0),(32.0,0.0,-3.0),(30.0,0.0,6.0),(28.0,-1.0,13.0),(38.0,-25.0,14.0),(40.0,-17.0,21.0),(36.0,-7.0,34.0),(24.0,7.0,-5.0),(18.0,17.0,-7.0),(12.0,26.0,-7.0),(-21.0,0.0,-59.0),(-26.0,0.0,-59.0),(-21.0,-3.0,-61.0),(24.0,32.0,47.0),(-9.0,32.0,1.0),(-18.0,28.0,15.0),(-22.0,18.0,16.0),(-24.0,5.0,13.0),(-21.0,-8.0,16.0),(-33.0,2.0,-22.0),(-37.0,1.0,-11.0),(-41.0,-1.0,-3.0),(-41.0,-3.0,7.0),(-37.0,-1.0,19.0),(-49.0,6.0,12.0),(-19.0,-7.0,-19.0),(-19.0,-18.0,-17.0),(-11.0,-25.0,-16.0),(-27.0,-30.0,50.0),(9.0,-29.0,-4.0),(17.0,-26.0,5.0),(21.0,-18.0,9.0),(23.0,-5.0,11.0),(21.0,7.0,11.0),(18.0,18.0,11.0),(22.0,-1.0,-25.0),(28.0,0.0,-18.0),(33.0,-1.0,-11.0),(36.0,0.0,-2.0),(36.0,1.0,6.0),(32.0,0.0,17.0),(42.0,-18.0,10.0),(44.0,-6.0,25.0),(20.0,6.0,-12.0),(17.0,18.0,-11.0),(-27.0,0.0,-54.0),(-22.0,-2.0,-54.0),(-13.0,-5.0,-55.0),(-2.0,-8.0,-55.0),(22.0,27.0,25.0),(15.0,43.0,33.0),(-8.0,31.0,-30.0),(-7.0,12.0,62.0),(-22.0,27.0,23.0),(-27.0,16.0,17.0),(-32.0,4.0,13.0),(-44.0,4.0,-10.0),(-44.0,-1.0,-3.0),(-45.0,-4.0,6.0),(-50.0,-7.0,20.0),(-31.0,-7.0,-25.0),(-21.0,-19.0,-23.0),(-14.0,-25.0,-24.0),(-23.0,-32.0,47.0),(9.0,-31.0,1.0),(18.0,-28.0,16.0),(22.0,-18.0,17.0),(22.0,-4.0,17.0),(21.0,8.0,16.0),(29.0,-2.0,-22.0),(35.0,-2.0,-12.0),(40.0,0.0,-4.0),(44.0,2.0,5.0),(41.0,2.0,19.0),(48.0,-6.0,12.0),(18.0,6.0,-18.0),(-25.0,-3.0,-50.0),(-13.0,-3.0,-51.0),(-4.0,-4.0,-50.0),(2.0,-1.0,-49.0),(5.0,3.0,-48.0),(23.0,4.0,16.0),(21.0,18.0,17.0),(18.0,28.0,16.0),(9.0,31.0,1.0),(-3.0,30.0,-14.0),(-11.0,25.0,-17.0),(-23.0,2.0,55.0),(-13.0,6.0,54.0),(-29.0,22.0,21.0),(-34.0,12.0,14.0),(-38.0,6.0,4.0),(-42.0,1.0,-2.0),(-44.0,-4.0,3.0),(-44.0,-9.0,12.0),(-29.0,-11.0,-28.0),(-23.0,-17.0,-28.0),(-20.0,-19.0,-32.0),(-22.0,-11.0,-46.0),(8.0,-32.0,78.0),(15.0,-43.0,32.0),(22.0,-27.0,25.0),(24.0,-15.0,23.0),(23.0,-2.0,21.0),(34.0,-4.0,-17.0),(40.0,-3.0,-7.0),(48.0,1.0,1.0),(61.0,6.0,14.0),(-6.0,-7.0,-54.0),(-3.0,-1.0,-47.0),(2.0,2.0,-45.0),(7.0,6.0,-44.0),(9.0,13.0,-42.0),(7.0,20.0,-41.0),(17.0,-18.0,11.0),(22.0,-7.0,11.0),(22.0,5.0,10.0),(21.0,18.0,10.0),(17.0,26.0,5.0),(9.0,29.0,-4.0),(-1.0,30.0,-10.0),(-11.0,25.0,-11.0),(-17.0,18.0,-11.0),(-20.0,6.0,-12.0),(-22.0,-6.0,-12.0),(-20.0,-16.0,-7.0),(-17.0,-25.0,-3.0),(-10.0,-30.0,4.0),(0.0,-29.0,8.0),(14.0,-1.0,-28.0),(7.0,0.0,-31.0),(5.0,-25.0,39.0),(19.0,-18.0,6.0),(23.0,-6.0,5.0),(24.0,6.0,4.0),(22.0,17.0,2.0),(17.0,25.0,-1.0),(9.0,29.0,-5.0),(-2.0,30.0,-7.0),(-12.0,26.0,-7.0),(-19.0,17.0,-7.0),(-23.0,7.0,-6.0),(-24.0,-6.0,-4.0),(-22.0,-17.0,-2.0),(-17.0,-25.0,1.0),(-9.0,-30.0,5.0),(5.0,0.0,-29.0),(-3.0,-1.0,-30.0),(-11.0,0.0,-28.0),(17.0,-30.0,33.0),(15.0,-25.0,35.0),(21.0,-17.0,2.0),(25.0,-6.0,0.0),(24.0,6.0,-3.0),(22.0,16.0,-4.0),(17.0,26.0,-5.0),(7.0,29.0,-6.0),(-4.0,30.0,-5.0),(-14.0,26.0,-4.0),(-21.0,18.0,-2.0),(-25.0,6.0,0.0),(-25.0,-6.0,1.0),(-23.0,-17.0,3.0),(-16.0,-26.0,6.0),(-5.0,0.0,-31.0),(-13.0,0.0,-29.0),(-21.0,0.0,-24.0),(-26.0,0.0,-18.0),(27.0,-30.0,27.0),(26.0,-30.0,27.0),(25.0,-25.0,30.0),(21.0,-18.0,-3.0),(24.0,-6.0,-7.0),(24.0,6.0,-8.0),(21.0,17.0,-9.0),(14.0,26.0,-8.0),(5.0,30.0,-8.0),(-7.0,30.0,-4.0),(-15.0,25.0,-1.0),(-22.0,18.0,3.0),(-24.0,6.0,6.0),(-25.0,-6.0,8.0),(-21.0,-17.0,9.0),(-16.0,0.0,-32.0),(-24.0,0.0,-27.0),(-30.0,0.0,-19.0),(-35.0,0.0,-11.0),(-36.0,0.0,-1.0),(37.0,-26.0,18.0),(34.0,-30.0,18.0),(33.0,-30.0,20.0),(33.0,-26.0,23.0),(20.0,-17.0,-9.0),(22.0,-6.0,-12.0),(22.0,6.0,-14.0),(17.0,17.0,-13.0),(11.0,26.0,-12.0),(2.0,30.0,-9.0),(-8.0,30.0,-3.0),(-16.0,26.0,3.0),(-20.0,17.0,8.0),(-23.0,6.0,12.0),(-21.0,-6.0,14.0),(-29.0,0.0,-31.0),(-35.0,0.0,-22.0),(-40.0,0.0,-12.0),(-42.0,0.0,-1.0),(-41.0,0.0,9.0),(-36.0,0.0,20.0),(45.0,-17.0,1.0),(41.0,-26.0,7.0),(37.0,-30.0,10.0),(37.0,-30.0,10.0),(38.0,-26.0,14.0),(18.0,-17.0,-14.0),(19.0,-7.0,-17.0),(17.0,7.0,-19.0),(13.0,17.0,-18.0),(7.0,26.0,-14.0),(-1.0,30.0,-9.0),(-8.0,30.0,-1.0),(-15.0,26.0,7.0),(-18.0,17.0,13.0),(-18.0,6.0,18.0),(-41.0,0.0,-26.0),(-46.0,0.0,-14.0),(-49.0,0.0,-2.0),(-47.0,0.0,10.0),(-43.0,0.0,22.0),(-35.0,0.0,33.0),(-25.0,0.0,40.0),(44.0,-6.0,-22.0),(44.0,-17.0,-11.0),(40.0,-26.0,-4.0),(39.0,-30.0,0.0),(38.0,-30.0,0.0),(41.0,-26.0,4.0),(14.0,-17.0,-18.0),(13.0,-7.0,-22.0),(12.0,7.0,-22.0),(8.0,17.0,-21.0),(3.0,26.0,-16.0),(-3.0,30.0,-8.0),(-9.0,30.0,1.0),(-12.0,26.0,11.0),(-14.0,17.0,17.0),(-52.0,0.0,-17.0),(-55.0,0.0,-3.0),(-54.0,0.0,11.0),(-49.0,0.0,25.0),(-40.0,0.0,37.0),(-29.0,0.0,45.0),(-15.0,0.0,49.0),(0.0,-1.0,52.0),(-10.0,-17.0,52.0),(34.0,23.0,-96.0),(34.0,-5.0,-32.0),(39.0,-17.0,-21.0),(39.0,-26.0,-14.0),(37.0,-30.0,-10.0),(37.0,-30.0,-10.0),(40.0,-26.0,-7.0),(9.0,-17.0,-21.0),(8.0,-7.0,-24.0),(5.0,7.0,-25.0),(3.0,17.0,-22.0),(-1.0,26.0,-16.0),(-6.0,30.0,-7.0),(-8.0,30.0,3.0),(-9.0,26.0,13.0),(-61.0,0.0,-4.0),(-59.0,0.0,11.0),(-55.0,0.0,26.0),(-46.0,0.0,40.0),(-33.0,0.0,49.0),(-18.0,-1.0,54.0),(-1.0,0.0,57.0),(17.0,-25.0,115.0),(16.0,-30.0,60.0),(23.0,-32.0,47.0),(27.0,-30.0,33.0),(29.0,-22.0,28.0),(28.0,-9.0,27.0),(37.0,-7.0,-13.0),(43.0,-3.0,-4.0),(48.0,2.0,2.0),(1.0,-3.0,-43.0),(4.0,4.0,-41.0),(9.0,9.0,-40.0),(14.0,15.0,-38.0),(13.0,21.0,-37.0),(-8.0,27.0,-14.0),(2.0,29.0,-8.0),(10.0,29.0,0.0),(16.0,25.0,6.0),(18.0,17.0,14.0),(17.0,7.0,18.0),(19.0,-7.0,18.0),(-25.0,3.0,48.0),(-15.0,4.0,49.0),(-37.0,16.0,17.0),(-40.0,8.0,9.0),(-41.0,3.0,1.0),(-42.0,-3.0,1.0),(-39.0,-8.0,8.0),(-31.0,-11.0,-32.0),(-28.0,-14.0,-34.0),(-26.0,-10.0,-39.0),(-25.0,-5.0,-48.0),(0.0,17.0,-56.0),(12.0,6.0,-48.0),(24.0,-6.0,-39.0),(31.0,-17.0,-30.0),(33.0,-25.0,-23.0),(33.0,-30.0,-20.0),(33.0,-30.0,-18.0),(37.0,-26.0,-18.0),(3.0,-17.0,-22.0),(1.0,-7.0,-25.0),(-1.0,7.0,-26.0),(-3.0,17.0,-22.0),(-5.0,26.0,-15.0),(-7.0,30.0,-6.0),(-7.0,30.0,6.0),(-64.0,0.0,10.0),(-59.0,0.0,26.0),(-50.0,0.0,41.0),(-37.0,0.0,52.0),(-21.0,0.0,57.0),(-3.0,0.0,60.0),(12.0,0.0,61.0),(13.0,-29.0,56.0),(26.0,-30.0,50.0),(36.0,-28.0,39.0),(36.0,-23.0,33.0),(36.0,-15.0,32.0),(37.0,-9.0,-10.0),(45.0,-3.0,-1.0),(4.0,4.0,-40.0),(13.0,9.0,-35.0),(19.0,16.0,-33.0),(20.0,23.0,-32.0),(-5.0,27.0,-15.0),(3.0,29.0,-7.0),(10.0,29.0,1.0),(14.0,25.0,11.0),(13.0,18.0,20.0),(12.0,9.0,30.0),(-14.0,8.0,45.0),(-44.0,9.0,12.0),(-43.0,4.0,4.0),(-43.0,-1.0,-2.0),(-38.0,-6.0,4.0),(-34.0,-10.0,-37.0),(-30.0,-8.0,-37.0),(-27.0,-5.0,-42.0),(3.0,5.0,-51.0),(12.0,-7.0,-44.0),(21.0,-16.0,-36.0),(25.0,-25.0,-30.0),(27.0,-30.0,-27.0),(27.0,-30.0,-27.0),(31.0,-26.0,-27.0),(-2.0,-17.0,-22.0),(-6.0,-7.0,-24.0),(-8.0,7.0,-25.0),(-8.0,17.0,-21.0),(-10.0,26.0,-13.0),(-8.0,30.0,-3.0),(-61.0,0.0,25.0),(-52.0,0.0,40.0),(-39.0,0.0,52.0),(-24.0,0.0,59.0),(-7.0,0.0,61.0),(11.0,1.0,61.0),(23.0,-30.0,52.0),(38.0,-26.0,45.0),(46.0,-22.0,36.0),(45.0,-17.0,36.0),(43.0,-7.0,-5.0),(12.0,8.0,-36.0),(26.0,15.0,-27.0),(28.0,22.0,-26.0),(-2.0,27.0,-15.0),(6.0,30.0,-7.0),(9.0,28.0,4.0),(10.0,26.0,14.0),(7.0,19.0,22.0),(-1.0,15.0,32.0),(-45.0,4.0,5.0),(-43.0,1.0,-3.0),(-44.0,-4.0,-10.0),(-39.0,-7.0,-37.0),(-28.0,-4.0,-38.0),(2.0,-8.0,-46.0),(11.0,-17.0,-41.0),(15.0,-25.0,-35.0),(18.0,-29.0,-32.0),(19.0,-30.0,-33.0),(24.0,-26.0,-34.0),(-8.0,-17.0,-21.0),(-12.0,-7.0,-22.0),(-14.0,7.0,-22.0),(-14.0,17.0,-17.0),(-12.0,26.0,-11.0),(-52.0,0.0,38.0),(-41.0,0.0,50.0),(-25.0,0.0,57.0),(-9.0,1.0,61.0),(8.0,0.0,59.0),(33.0,-26.0,49.0),(48.0,-19.0,40.0),(64.0,-13.0,33.0),(43.0,11.0,-19.0),(36.0,20.0,-18.0),(3.0,27.0,-16.0),(8.0,29.0,-5.0),(8.0,29.0,5.0),(6.0,26.0,15.0),(0.0,22.0,23.0),(-40.0,1.0,-2.0),(-38.0,-1.0,-11.0),(-33.0,-2.0,-22.0),(-26.0,-3.0,-33.0),(-1.0,-18.0,-43.0),(6.0,-25.0,-38.0),(8.0,-30.0,-36.0),(10.0,-29.0,-36.0),(14.0,-26.0,-39.0),(-14.0,-17.0,-18.0),(-17.0,-7.0,-18.0),(-19.0,7.0,-18.0),(-18.0,17.0,-13.0),(-39.0,0.0,46.0),(-26.0,0.0,53.0),(-10.0,1.0,58.0),(6.0,0.0,57.0),(39.0,-18.0,45.0),(49.0,-7.0,33.0),(47.0,6.0,12.0),(42.0,19.0,-6.0),(7.0,26.0,-14.0),(10.0,28.0,-4.0),(6.0,29.0,7.0),(1.0,27.0,15.0),(-33.0,0.0,-10.0),(-29.0,0.0,-18.0),(-23.0,-1.0,-26.0),(-5.0,-26.0,-40.0),(-1.0,-29.0,-36.0),(-1.0,-30.0,-38.0),(4.0,-25.0,-40.0),(-18.0,-17.0,-14.0),(-22.0,-7.0,-14.0),(-22.0,7.0,-12.0),(-25.0,0.0,49.0),(-11.0,0.0,52.0),(4.0,1.0,52.0),(39.0,-7.0,40.0),(44.0,6.0,24.0),(43.0,18.0,11.0),(12.0,25.0,-12.0),(10.0,29.0,-1.0),(4.0,29.0,7.0),(-26.0,0.0,-17.0),(-20.0,0.0,-23.0),(-11.0,-30.0,-35.0),(-10.0,-29.0,-36.0),(-8.0,-25.0,-40.0),(-21.0,-17.0,-8.0),(-24.0,-6.0,-8.0),(-11.0,0.0,46.0),(2.0,0.0,46.0),(37.0,7.0,34.0),(39.0,17.0,22.0),(15.0,24.0,-7.0),(10.0,29.0,1.0),(-18.0,0.0,-23.0),(-19.0,-29.0,-31.0),(-18.0,-25.0,-37.0),(-23.0,-17.0,-3.0),(1.0,0.0,40.0),(33.0,17.0,31.0),(17.0,25.0,-3.0),(-27.0,-25.0,-30.0),(0.3399,0.1398,0.5931)])])]))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for EightCoded.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python EightCoded.py load and self-test diagnostics complete.")
