package Basic.ExperimentalBinaryCompression;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> IndexedFaceSet example. </p>
 <p> Related links: Catalog page <a href="../../../ExperimentalBinaryCompression/EightIndex.html" target="_blank">Eight</a>,  source <a href="../../../ExperimentalBinaryCompression/Eight.java">Eight.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/Eight.x3d">Eight.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> IndexedFaceSet example. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Martin Isenburg </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 4 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 5 May 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/Eight.png">Eight.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D VRML binary compression </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Eight.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Eight.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ExperimentalBinaryCompression/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Martin Isenburg
 */

public class Eight
{
	/** Default constructor to create this object. */
	public Eight ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Eight.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("IndexedFaceSet example."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Martin Isenburg"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("4 May 2003"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("5 May 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("Eight.png"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D VRML binary compression"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ExperimentalBinaryCompression/Eight.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("Eight.x3d"))
    .addChild(new Viewpoint().setDescription("1M view from above").setOrientation(1.0,0.0,0.0,-1.5707999).setPosition(0.0,1.0,0.0))
    .addChild(new Viewpoint().setDescription("1M view from side").setPosition(0.0,0.0,1.0))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.25,0.25,0.25)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,0.5,0.5)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_21_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_21_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,1,-1,0,5,3,-1,0,3,1,-1,6,7,4,-1,8,9,7,-1,6,10,8,-1,6,8,7,-1,11,12,10,-1,13,14,12,-1,11,5,13,-1,11,13,12,-1,3,6,4,-1,11,10,6,-1,3,5,11,-1,3,11,6,-1,15,7,9,-1,16,4,7,-1,15,17,16,-1,15,16,7,-1,18,1,4,-1,19,2,1,-1,18,20,19,-1,18,19,1,-1,21,22,20,-1,23,24,22,-1,21,17,23,-1,21,23,22,-1,16,18,4,-1,21,20,18,-1,16,17,21,-1,16,21,18,-1,25,26,27,-1,28,29,26,-1,25,30,28,-1,25,28,26,-1,31,32,29,-1,33,34,32,-1,31,35,33,-1,31,33,32,-1,36,37,35,-1,38,39,37,-1,36,30,38,-1,36,38,37,-1,28,31,29,-1,36,35,31,-1,28,30,36,-1,28,36,31,-1,38,40,39,-1,41,42,40,-1,38,30,41,-1,38,41,40,-1,43,44,42,-1,45,46,44,-1,43,47,45,-1,43,45,44,-1,48,49,47,-1,25,27,49,-1,48,30,25,-1,48,25,49,-1,41,43,42,-1,48,47,43,-1,41,30,48,-1,41,48,43,-1,50,51,52,-1,53,54,51,-1,50,55,53,-1,50,53,51,-1,56,57,54,-1,15,9,57,-1,56,17,15,-1,56,15,57,-1,58,23,17,-1,59,24,23,-1,58,55,59,-1,58,59,23,-1,53,56,54,-1,58,17,56,-1,53,55,58,-1,53,58,56,-1,60,61,52,-1,62,63,61,-1,60,64,62,-1,60,62,61,-1,65,66,63,-1,44,46,66,-1,65,42,44,-1,65,44,66,-1,67,40,42,-1,68,39,40,-1,67,64,68,-1,67,68,40,-1,62,65,63,-1,67,42,65,-1,62,64,67,-1,62,67,65,-1,69,70,71,-1,72,73,70,-1,69,74,72,-1,69,72,70,-1,75,76,73,-1,0,2,76,-1,75,5,0,-1,75,0,76,-1,77,13,5,-1,78,14,13,-1,77,74,78,-1,77,78,13,-1,72,75,73,-1,77,5,75,-1,72,74,77,-1,72,77,75,-1,79,80,71,-1,81,82,80,-1,79,83,81,-1,79,81,80,-1,84,85,82,-1,32,34,85,-1,84,29,32,-1,84,32,85,-1,86,26,29,-1,87,27,26,-1,86,83,87,-1,86,87,26,-1,81,84,82,-1,86,29,84,-1,81,83,86,-1,81,86,84,-1,88,89,90,-1,91,92,89,-1,88,93,91,-1,88,91,89,-1,94,95,92,-1,96,71,95,-1,94,97,96,-1,94,96,95,-1,98,99,97,-1,100,101,99,-1,98,93,100,-1,98,100,99,-1,91,94,92,-1,98,97,94,-1,91,93,98,-1,91,98,94,-1,78,102,14,-1,103,104,102,-1,78,74,103,-1,78,103,102,-1,105,106,104,-1,99,101,106,-1,105,97,99,-1,105,99,106,-1,107,96,97,-1,69,71,96,-1,107,74,69,-1,107,69,96,-1,103,105,104,-1,107,97,105,-1,103,74,107,-1,103,107,105,-1,108,109,110,-1,111,112,109,-1,108,113,111,-1,108,111,109,-1,114,115,112,-1,116,34,115,-1,114,117,116,-1,114,116,115,-1,118,119,117,-1,120,90,119,-1,118,113,120,-1,118,120,119,-1,111,114,112,-1,118,117,114,-1,111,113,118,-1,111,118,114,-1,80,95,71,-1,121,92,95,-1,80,82,121,-1,80,121,95,-1,122,89,92,-1,119,90,89,-1,122,117,119,-1,122,119,89,-1,123,116,117,-1,85,34,116,-1,123,82,85,-1,123,85,116,-1,121,122,92,-1,123,117,122,-1,121,82,123,-1,121,123,122,-1,124,125,126,-1,127,128,125,-1,124,129,127,-1,124,127,125,-1,130,131,128,-1,132,133,131,-1,130,134,132,-1,130,132,131,-1,135,136,134,-1,137,110,136,-1,135,129,137,-1,135,137,136,-1,127,130,128,-1,135,134,130,-1,127,129,135,-1,127,135,130,-1,138,115,34,-1,139,112,115,-1,138,140,139,-1,138,139,115,-1,141,109,112,-1,136,110,109,-1,141,134,136,-1,141,136,109,-1,142,132,134,-1,143,133,132,-1,142,140,143,-1,142,143,132,-1,139,141,112,-1,142,134,141,-1,139,140,142,-1,139,142,141,-1,144,106,101,-1,145,104,106,-1,144,146,145,-1,144,145,106,-1,147,102,104,-1,148,14,102,-1,147,149,148,-1,147,148,102,-1,150,151,149,-1,152,126,151,-1,150,146,152,-1,150,152,151,-1,145,147,104,-1,150,149,147,-1,145,146,150,-1,145,150,147,-1,153,131,133,-1,154,128,131,-1,153,155,154,-1,153,154,131,-1,156,125,128,-1,151,126,125,-1,156,149,151,-1,156,151,125,-1,157,148,149,-1,158,14,148,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_2()
		{
			int[] value = {157,155,158,-1,157,158,148,-1,154,156,128,-1,157,149,156,-1,154,155,157,-1,154,157,156,-1,143,159,133,-1,160,161,159,-1,143,140,160,-1,143,160,159,-1,162,163,161,-1,164,165,163,-1,162,166,164,-1,162,164,163,-1,167,168,166,-1,138,34,168,-1,167,140,138,-1,167,138,168,-1,160,162,161,-1,167,166,162,-1,160,140,167,-1,160,167,162,-1,169,37,39,-1,170,35,37,-1,169,171,170,-1,169,170,37,-1,172,33,35,-1,168,34,33,-1,172,166,168,-1,172,168,33,-1,173,164,166,-1,174,165,164,-1,173,171,174,-1,173,174,164,-1,170,172,35,-1,173,166,172,-1,170,171,173,-1,170,173,172,-1,158,12,14,-1,175,10,12,-1,158,155,175,-1,158,175,12,-1,176,8,10,-1,177,9,8,-1,176,178,177,-1,176,177,8,-1,179,180,178,-1,153,133,180,-1,179,155,153,-1,179,153,180,-1,175,176,10,-1,179,178,176,-1,175,155,179,-1,175,179,176,-1,181,163,165,-1,182,161,163,-1,181,183,182,-1,181,182,163,-1,184,159,161,-1,180,133,159,-1,184,178,180,-1,184,180,159,-1,185,177,178,-1,186,9,177,-1,185,183,186,-1,185,186,177,-1,182,184,161,-1,185,178,184,-1,182,183,185,-1,182,185,184,-1,51,187,52,-1,188,189,187,-1,51,54,188,-1,51,188,187,-1,190,191,189,-1,192,193,191,-1,190,194,192,-1,190,192,191,-1,195,196,194,-1,57,9,196,-1,195,54,57,-1,195,57,196,-1,188,190,189,-1,195,194,190,-1,188,54,195,-1,188,195,190,-1,197,198,199,-1,200,201,198,-1,197,202,200,-1,197,200,198,-1,203,204,201,-1,196,9,204,-1,203,194,196,-1,203,196,204,-1,205,192,194,-1,206,193,192,-1,205,202,206,-1,205,206,192,-1,200,203,201,-1,205,194,203,-1,200,202,205,-1,200,205,203,-1,68,207,39,-1,208,209,207,-1,68,64,208,-1,68,208,207,-1,210,211,209,-1,212,213,211,-1,210,214,212,-1,210,212,211,-1,215,216,214,-1,60,52,216,-1,215,64,60,-1,215,60,216,-1,208,210,209,-1,215,214,210,-1,208,64,215,-1,208,215,210,-1,217,191,193,-1,218,189,191,-1,217,219,218,-1,217,218,191,-1,220,187,189,-1,216,52,187,-1,220,214,216,-1,220,216,187,-1,221,212,214,-1,222,213,212,-1,221,219,222,-1,221,222,212,-1,218,220,189,-1,221,214,220,-1,218,219,221,-1,218,221,220,-1,174,223,165,-1,224,225,223,-1,174,171,224,-1,174,224,223,-1,226,227,225,-1,228,229,227,-1,226,230,228,-1,226,228,227,-1,231,232,230,-1,169,39,232,-1,231,171,169,-1,231,169,232,-1,224,226,225,-1,231,230,226,-1,224,171,231,-1,224,231,226,-1,233,211,213,-1,234,209,211,-1,233,235,234,-1,233,234,211,-1,236,207,209,-1,232,39,207,-1,236,230,232,-1,236,232,207,-1,237,228,230,-1,238,229,228,-1,237,235,238,-1,237,238,228,-1,234,236,209,-1,237,230,236,-1,234,235,237,-1,234,237,236,-1,186,204,9,-1,239,201,204,-1,186,183,239,-1,186,239,204,-1,240,198,201,-1,241,199,198,-1,240,242,241,-1,240,241,198,-1,243,244,242,-1,181,165,244,-1,243,183,181,-1,243,181,244,-1,239,240,201,-1,243,242,240,-1,239,183,243,-1,239,243,240,-1,245,227,229,-1,246,225,227,-1,245,247,246,-1,245,246,227,-1,248,223,225,-1,244,165,223,-1,248,242,244,-1,248,244,223,-1,249,241,242,-1,250,199,241,-1,249,247,250,-1,249,250,241,-1,246,248,225,-1,249,242,248,-1,246,247,249,-1,246,249,248,-1,206,251,193,-1,252,253,251,-1,206,202,252,-1,206,252,251,-1,254,255,253,-1,256,257,255,-1,254,258,256,-1,254,256,255,-1,259,260,258,-1,197,199,260,-1,259,202,197,-1,259,197,260,-1,252,254,253,-1,259,258,254,-1,252,202,259,-1,252,259,254,-1,261,262,263,-1,264,265,262,-1,261,266,264,-1,261,264,262,-1,267,268,265,-1,260,199,268,-1,267,258,260,-1,267,260,268,-1,269,256,258,-1,270,257,256,-1,269,266,270,-1,269,270,256,-1,264,267,265,-1,269,258,267,-1,264,266,269,-1,264,269,267,-1,222,271,213,-1,272,273,271,-1,222,219,272,-1,222,272,271,-1,274,275,273,-1,276,277,275,-1,274,278,276,-1,274,276,275,-1,279,280,278,-1,217,193,280,-1,279,219,217,-1,279,217,280,-1,272,274,273,-1,279,278,274,-1,272,219,279,-1,272,279,274,-1,281,255,257,-1,282,253,255,-1,281,283,282,-1,281,282,255,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_3()
		{
			int[] value = {284,251,253,-1,280,193,251,-1,284,278,280,-1,284,280,251,-1,285,276,278,-1,286,277,276,-1,285,283,286,-1,285,286,276,-1,282,284,253,-1,285,278,284,-1,282,283,285,-1,282,285,284,-1,238,287,229,-1,288,289,287,-1,238,235,288,-1,238,288,287,-1,290,291,289,-1,292,293,291,-1,290,294,292,-1,290,292,291,-1,295,296,294,-1,233,213,296,-1,295,235,233,-1,295,233,296,-1,288,290,289,-1,295,294,290,-1,288,235,295,-1,288,295,290,-1,297,275,277,-1,298,273,275,-1,297,299,298,-1,297,298,275,-1,300,271,273,-1,296,213,271,-1,300,294,296,-1,300,296,271,-1,301,292,294,-1,302,293,292,-1,301,299,302,-1,301,302,292,-1,298,300,273,-1,301,294,300,-1,298,299,301,-1,298,301,300,-1,250,268,199,-1,303,265,268,-1,250,247,303,-1,250,303,268,-1,304,262,265,-1,305,263,262,-1,304,306,305,-1,304,305,262,-1,307,308,306,-1,245,229,308,-1,307,247,245,-1,307,245,308,-1,303,304,265,-1,307,306,304,-1,303,247,307,-1,303,307,304,-1,309,291,293,-1,310,289,291,-1,309,311,310,-1,309,310,291,-1,312,287,289,-1,308,229,287,-1,312,306,308,-1,312,308,287,-1,313,305,306,-1,314,263,305,-1,313,311,314,-1,313,314,305,-1,310,312,289,-1,313,306,312,-1,310,311,313,-1,310,313,312,-1,270,315,257,-1,316,317,315,-1,270,266,316,-1,270,316,315,-1,318,319,317,-1,320,321,319,-1,318,322,320,-1,318,320,319,-1,323,324,322,-1,261,263,324,-1,323,266,261,-1,323,261,324,-1,316,318,317,-1,323,322,318,-1,316,266,323,-1,316,323,318,-1,325,326,327,-1,328,329,326,-1,325,330,328,-1,325,328,326,-1,331,332,329,-1,324,263,332,-1,331,322,324,-1,331,324,332,-1,333,320,322,-1,334,321,320,-1,333,330,334,-1,333,334,320,-1,328,331,329,-1,333,322,331,-1,328,330,333,-1,328,333,331,-1,286,335,277,-1,336,337,335,-1,286,283,336,-1,286,336,335,-1,338,339,337,-1,340,341,339,-1,338,342,340,-1,338,340,339,-1,343,344,342,-1,281,257,344,-1,343,283,281,-1,343,281,344,-1,336,338,337,-1,343,342,338,-1,336,283,343,-1,336,343,338,-1,345,319,321,-1,346,317,319,-1,345,347,346,-1,345,346,319,-1,348,315,317,-1,344,257,315,-1,348,342,344,-1,348,344,315,-1,349,340,342,-1,350,341,340,-1,349,347,350,-1,349,350,340,-1,346,348,317,-1,349,342,348,-1,346,347,349,-1,346,349,348,-1,302,351,293,-1,352,353,351,-1,302,299,352,-1,302,352,351,-1,354,355,353,-1,356,357,355,-1,354,358,356,-1,354,356,355,-1,359,360,358,-1,297,277,360,-1,359,299,297,-1,359,297,360,-1,352,354,353,-1,359,358,354,-1,352,299,359,-1,352,359,354,-1,361,339,341,-1,362,337,339,-1,361,363,362,-1,361,362,339,-1,364,335,337,-1,360,277,335,-1,364,358,360,-1,364,360,335,-1,365,356,358,-1,366,357,356,-1,365,363,366,-1,365,366,356,-1,362,364,337,-1,365,358,364,-1,362,363,365,-1,362,365,364,-1,314,332,263,-1,367,329,332,-1,314,311,367,-1,314,367,332,-1,368,326,329,-1,369,327,326,-1,368,370,369,-1,368,369,326,-1,371,372,370,-1,309,293,372,-1,371,311,309,-1,371,309,372,-1,367,368,329,-1,371,370,368,-1,367,311,371,-1,367,371,368,-1,373,355,357,-1,374,353,355,-1,373,375,374,-1,373,374,355,-1,376,351,353,-1,372,293,351,-1,376,370,372,-1,376,372,351,-1,377,369,370,-1,378,327,369,-1,377,375,378,-1,377,378,369,-1,374,376,353,-1,377,370,376,-1,374,375,377,-1,374,377,376,-1,334,379,321,-1,380,381,379,-1,334,330,380,-1,334,380,379,-1,382,383,381,-1,384,90,383,-1,382,385,384,-1,382,384,383,-1,386,387,385,-1,325,327,387,-1,386,330,325,-1,386,325,387,-1,380,382,381,-1,386,385,382,-1,380,330,386,-1,380,386,382,-1,100,388,101,-1,389,390,388,-1,100,93,389,-1,100,389,388,-1,391,392,390,-1,387,327,392,-1,391,385,387,-1,391,387,392,-1,393,384,385,-1,88,90,384,-1,393,93,88,-1,393,88,384,-1,389,391,390,-1,393,385,391,-1,389,93,393,-1,389,393,391,-1,350,394,341,-1,395,396,394,-1,350,347,395,-1,350,395,394,-1,397,398,396,-1,399,110,398,-1,397,400,399,-1,397,399,398,-1,401,402,400,-1,345,321,402,-1,401,347,345,-1,401,345,402,-1,395,397,396,-1,401,400,397,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_4()
		{
			int[] value = {395,347,401,-1,395,401,397,-1,120,383,90,-1,403,381,383,-1,120,113,403,-1,120,403,383,-1,404,379,381,-1,402,321,379,-1,404,400,402,-1,404,402,379,-1,405,399,400,-1,108,110,399,-1,405,113,108,-1,405,108,399,-1,403,404,381,-1,405,400,404,-1,403,113,405,-1,403,405,404,-1,366,406,357,-1,407,408,406,-1,366,363,407,-1,366,407,406,-1,409,410,408,-1,411,126,410,-1,409,412,411,-1,409,411,410,-1,413,414,412,-1,361,341,414,-1,413,363,361,-1,413,361,414,-1,407,409,408,-1,413,412,409,-1,407,363,413,-1,407,413,409,-1,137,398,110,-1,415,396,398,-1,137,129,415,-1,137,415,398,-1,416,394,396,-1,414,341,394,-1,416,412,414,-1,416,414,394,-1,417,411,412,-1,124,126,411,-1,417,129,124,-1,417,124,411,-1,415,416,396,-1,417,412,416,-1,415,129,417,-1,415,417,416,-1,378,392,327,-1,418,390,392,-1,378,375,418,-1,378,418,392,-1,419,388,390,-1,420,101,388,-1,419,421,420,-1,419,420,388,-1,422,423,421,-1,373,357,423,-1,422,375,373,-1,422,373,423,-1,418,419,390,-1,422,421,419,-1,418,375,422,-1,418,422,419,-1,152,410,126,-1,424,408,410,-1,152,146,424,-1,152,424,410,-1,425,406,408,-1,423,357,406,-1,425,421,423,-1,425,423,406,-1,426,420,421,-1,144,101,420,-1,426,146,144,-1,426,144,420,-1,424,425,408,-1,426,421,425,-1,424,146,426,-1,424,426,425,-1,427,428,429,-1,430,431,428,-1,427,432,430,-1,427,430,428,-1,433,434,431,-1,435,436,434,-1,433,437,435,-1,433,435,434,-1,438,439,437,-1,440,441,439,-1,438,432,440,-1,438,440,439,-1,430,433,431,-1,438,437,433,-1,430,432,438,-1,430,438,433,-1,442,443,444,-1,445,446,443,-1,442,447,445,-1,442,445,443,-1,448,449,446,-1,439,441,449,-1,448,437,439,-1,448,439,449,-1,450,435,437,-1,451,436,435,-1,450,447,451,-1,450,451,435,-1,445,448,446,-1,450,437,448,-1,445,447,450,-1,445,450,448,-1,452,453,454,-1,455,456,453,-1,452,457,455,-1,452,455,453,-1,458,459,456,-1,460,461,459,-1,458,462,460,-1,458,460,459,-1,463,464,462,-1,465,429,464,-1,463,457,465,-1,463,465,464,-1,455,458,456,-1,463,462,458,-1,455,457,463,-1,455,463,458,-1,466,434,436,-1,467,431,434,-1,466,468,467,-1,466,467,434,-1,469,428,431,-1,464,429,428,-1,469,462,464,-1,469,464,428,-1,470,460,462,-1,471,461,460,-1,470,468,471,-1,470,471,460,-1,467,469,431,-1,470,462,469,-1,467,468,470,-1,467,470,469,-1,472,473,474,-1,475,476,473,-1,472,477,475,-1,472,475,473,-1,478,479,476,-1,480,481,479,-1,478,482,480,-1,478,480,479,-1,483,484,482,-1,485,454,484,-1,483,477,485,-1,483,485,484,-1,475,478,476,-1,483,482,478,-1,475,477,483,-1,475,483,478,-1,486,459,461,-1,487,456,459,-1,486,488,487,-1,486,487,459,-1,489,453,456,-1,484,454,453,-1,489,482,484,-1,489,484,453,-1,490,480,482,-1,491,481,480,-1,490,488,491,-1,490,491,480,-1,487,489,456,-1,490,482,489,-1,487,488,490,-1,487,490,489,-1,492,449,441,-1,493,446,449,-1,492,494,493,-1,492,493,449,-1,495,443,446,-1,496,444,443,-1,495,497,496,-1,495,496,443,-1,498,499,497,-1,500,474,499,-1,498,494,500,-1,498,500,499,-1,493,495,446,-1,498,497,495,-1,493,494,498,-1,493,498,495,-1,501,479,481,-1,502,476,479,-1,501,503,502,-1,501,502,479,-1,504,473,476,-1,499,474,473,-1,504,497,499,-1,504,499,473,-1,505,496,497,-1,506,444,496,-1,505,503,506,-1,505,506,496,-1,502,504,476,-1,505,497,504,-1,502,503,505,-1,502,505,504,-1,451,507,436,-1,508,509,507,-1,451,447,508,-1,451,508,507,-1,510,511,509,-1,512,513,511,-1,510,514,512,-1,510,512,511,-1,515,516,514,-1,442,444,516,-1,515,447,442,-1,515,442,516,-1,508,510,509,-1,515,514,510,-1,508,447,515,-1,508,515,510,-1,517,518,519,-1,520,521,518,-1,517,522,520,-1,517,520,518,-1,523,524,521,-1,516,444,524,-1,523,514,516,-1,523,516,524,-1,525,512,514,-1,526,513,512,-1,525,522,526,-1,525,526,512,-1,520,523,521,-1,525,514,523,-1,520,522,525,-1,520,525,523,-1,471,527,461,-1,528,529,527,-1,471,468,528,-1,471,528,527,-1,530,531,529,-1,532,533,531,-1,530,534,532,-1,530,532,531,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_5()
		{
			int[] value = {535,536,534,-1,466,436,536,-1,535,468,466,-1,535,466,536,-1,528,530,529,-1,535,534,530,-1,528,468,535,-1,528,535,530,-1,537,511,513,-1,538,509,511,-1,537,539,538,-1,537,538,511,-1,540,507,509,-1,536,436,507,-1,540,534,536,-1,540,536,507,-1,541,532,534,-1,542,533,532,-1,541,539,542,-1,541,542,532,-1,538,540,509,-1,541,534,540,-1,538,539,541,-1,538,541,540,-1,491,543,481,-1,544,545,543,-1,491,488,544,-1,491,544,543,-1,546,547,545,-1,548,549,547,-1,546,550,548,-1,546,548,547,-1,551,552,550,-1,486,461,552,-1,551,488,486,-1,551,486,552,-1,544,546,545,-1,551,550,546,-1,544,488,551,-1,544,551,546,-1,553,531,533,-1,554,529,531,-1,553,555,554,-1,553,554,531,-1,556,527,529,-1,552,461,527,-1,556,550,552,-1,556,552,527,-1,557,548,550,-1,558,549,548,-1,557,555,558,-1,557,558,548,-1,554,556,529,-1,557,550,556,-1,554,555,557,-1,554,557,556,-1,506,524,444,-1,559,521,524,-1,506,503,559,-1,506,559,524,-1,560,518,521,-1,561,519,518,-1,560,562,561,-1,560,561,518,-1,563,564,562,-1,501,481,564,-1,563,503,501,-1,563,501,564,-1,559,560,521,-1,563,562,560,-1,559,503,563,-1,559,563,560,-1,565,547,549,-1,566,545,547,-1,565,567,566,-1,565,566,547,-1,568,543,545,-1,564,481,543,-1,568,562,564,-1,568,564,543,-1,569,561,562,-1,570,519,561,-1,569,567,570,-1,569,570,561,-1,566,568,545,-1,569,562,568,-1,566,567,569,-1,566,569,568,-1,526,571,513,-1,572,573,571,-1,526,522,572,-1,526,572,571,-1,574,575,573,-1,576,577,575,-1,574,578,576,-1,574,576,575,-1,579,580,578,-1,517,519,580,-1,579,522,517,-1,579,517,580,-1,572,574,573,-1,579,578,574,-1,572,522,579,-1,572,579,574,-1,581,582,583,-1,584,585,582,-1,581,586,584,-1,581,584,582,-1,587,588,585,-1,580,519,588,-1,587,578,580,-1,587,580,588,-1,589,576,578,-1,590,577,576,-1,589,586,590,-1,589,590,576,-1,584,587,585,-1,589,578,587,-1,584,586,589,-1,584,589,587,-1,542,591,533,-1,592,593,591,-1,542,539,592,-1,542,592,591,-1,594,595,593,-1,596,597,595,-1,594,598,596,-1,594,596,595,-1,599,600,598,-1,537,513,600,-1,599,539,537,-1,599,537,600,-1,592,594,593,-1,599,598,594,-1,592,539,599,-1,592,599,594,-1,601,575,577,-1,602,573,575,-1,601,603,602,-1,601,602,575,-1,604,571,573,-1,600,513,571,-1,604,598,600,-1,604,600,571,-1,605,596,598,-1,606,597,596,-1,605,603,606,-1,605,606,596,-1,602,604,573,-1,605,598,604,-1,602,603,605,-1,602,605,604,-1,558,607,549,-1,608,609,607,-1,558,555,608,-1,558,608,607,-1,610,611,609,-1,612,613,611,-1,610,614,612,-1,610,612,611,-1,615,616,614,-1,553,533,616,-1,615,555,553,-1,615,553,616,-1,608,610,609,-1,615,614,610,-1,608,555,615,-1,608,615,610,-1,617,595,597,-1,618,593,595,-1,617,619,618,-1,617,618,595,-1,620,591,593,-1,616,533,591,-1,620,614,616,-1,620,616,591,-1,621,612,614,-1,622,613,612,-1,621,619,622,-1,621,622,612,-1,618,620,593,-1,621,614,620,-1,618,619,621,-1,618,621,620,-1,570,588,519,-1,623,585,588,-1,570,567,623,-1,570,623,588,-1,624,582,585,-1,625,583,582,-1,624,626,625,-1,624,625,582,-1,627,628,626,-1,565,549,628,-1,627,567,565,-1,627,565,628,-1,623,624,585,-1,627,626,624,-1,623,567,627,-1,623,627,624,-1,629,611,613,-1,630,609,611,-1,629,631,630,-1,629,630,611,-1,632,607,609,-1,628,549,607,-1,632,626,628,-1,632,628,607,-1,633,625,626,-1,634,583,625,-1,633,631,634,-1,633,634,625,-1,630,632,609,-1,633,626,632,-1,630,631,633,-1,630,633,632,-1,590,635,577,-1,636,637,635,-1,590,586,636,-1,590,636,635,-1,638,639,637,-1,640,52,639,-1,638,641,640,-1,638,640,639,-1,642,643,641,-1,581,583,643,-1,642,586,581,-1,642,581,643,-1,636,638,637,-1,642,641,638,-1,636,586,642,-1,636,642,638,-1,59,644,24,-1,645,646,644,-1,59,55,645,-1,59,645,644,-1,647,648,646,-1,643,583,648,-1,647,641,643,-1,647,643,648,-1,649,640,641,-1,50,52,640,-1,649,55,50,-1,649,50,640,-1,645,647,646,-1,649,641,647,-1,645,55,649,-1,645,649,647,-1,606,650,597,-1,651,652,650,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_6()
		{
			int[] value = {606,603,651,-1,606,651,650,-1,653,654,652,-1,655,46,654,-1,653,656,655,-1,653,655,654,-1,657,658,656,-1,601,577,658,-1,657,603,601,-1,657,601,658,-1,651,653,652,-1,657,656,653,-1,651,603,657,-1,651,657,653,-1,61,639,52,-1,659,637,639,-1,61,63,659,-1,61,659,639,-1,660,635,637,-1,658,577,635,-1,660,656,658,-1,660,658,635,-1,661,655,656,-1,66,46,655,-1,661,63,66,-1,661,66,655,-1,659,660,637,-1,661,656,660,-1,659,63,661,-1,659,661,660,-1,622,662,613,-1,663,664,662,-1,622,619,663,-1,622,663,662,-1,665,666,664,-1,667,668,666,-1,665,669,667,-1,665,667,666,-1,670,671,669,-1,617,597,671,-1,670,619,617,-1,670,617,671,-1,663,665,664,-1,670,669,665,-1,663,619,670,-1,663,670,665,-1,672,654,46,-1,673,652,654,-1,672,674,673,-1,672,673,654,-1,675,650,652,-1,671,597,650,-1,675,669,671,-1,675,671,650,-1,676,667,669,-1,677,668,667,-1,676,674,677,-1,676,677,667,-1,673,675,652,-1,676,669,675,-1,673,674,676,-1,673,676,675,-1,634,648,583,-1,678,646,648,-1,634,631,678,-1,634,678,648,-1,679,644,646,-1,680,24,644,-1,679,681,680,-1,679,680,644,-1,682,683,681,-1,629,613,683,-1,682,631,629,-1,682,629,683,-1,678,679,646,-1,682,681,679,-1,678,631,682,-1,678,682,679,-1,684,666,668,-1,685,664,666,-1,684,686,685,-1,684,685,666,-1,687,662,664,-1,683,613,662,-1,687,681,683,-1,687,683,662,-1,688,680,681,-1,689,24,680,-1,688,686,689,-1,688,689,680,-1,685,687,664,-1,688,681,687,-1,685,686,688,-1,685,688,687,-1,677,690,668,-1,691,692,690,-1,677,674,691,-1,677,691,690,-1,693,694,692,-1,695,696,694,-1,693,697,695,-1,693,695,694,-1,698,699,697,-1,672,46,699,-1,698,674,672,-1,698,672,699,-1,691,693,692,-1,698,697,693,-1,691,674,698,-1,691,698,693,-1,700,49,27,-1,701,47,49,-1,700,702,701,-1,700,701,49,-1,703,45,47,-1,699,46,45,-1,703,697,699,-1,703,699,45,-1,704,695,697,-1,705,696,695,-1,704,702,705,-1,704,705,695,-1,701,703,47,-1,704,697,703,-1,701,702,704,-1,701,704,703,-1,689,22,24,-1,706,20,22,-1,689,686,706,-1,689,706,22,-1,707,19,20,-1,708,2,19,-1,707,709,708,-1,707,708,19,-1,710,711,709,-1,684,668,711,-1,710,686,684,-1,710,684,711,-1,706,707,20,-1,710,709,707,-1,706,686,710,-1,706,710,707,-1,712,694,696,-1,713,692,694,-1,712,714,713,-1,712,713,694,-1,715,690,692,-1,711,668,690,-1,715,709,711,-1,715,711,690,-1,716,708,709,-1,717,2,708,-1,716,714,717,-1,716,717,708,-1,713,715,692,-1,716,709,715,-1,713,714,716,-1,713,716,715,-1,70,718,71,-1,719,720,718,-1,70,73,719,-1,70,719,718,-1,721,722,720,-1,723,429,722,-1,721,724,723,-1,721,723,722,-1,725,726,724,-1,76,2,726,-1,725,73,76,-1,725,76,726,-1,719,721,720,-1,725,724,721,-1,719,73,725,-1,719,725,721,-1,440,727,441,-1,728,729,727,-1,440,432,728,-1,440,728,727,-1,730,731,729,-1,726,2,731,-1,730,724,726,-1,730,726,731,-1,732,723,724,-1,427,429,723,-1,732,432,427,-1,732,427,723,-1,728,730,729,-1,732,724,730,-1,728,432,732,-1,728,732,730,-1,87,733,27,-1,734,735,733,-1,87,83,734,-1,87,734,733,-1,736,737,735,-1,738,454,737,-1,736,739,738,-1,736,738,737,-1,740,741,739,-1,79,71,741,-1,740,83,79,-1,740,79,741,-1,734,736,735,-1,740,739,736,-1,734,83,740,-1,734,740,736,-1,465,722,429,-1,742,720,722,-1,465,457,742,-1,465,742,722,-1,743,718,720,-1,741,71,718,-1,743,739,741,-1,743,741,718,-1,744,738,739,-1,452,454,738,-1,744,457,452,-1,744,452,738,-1,742,743,720,-1,744,739,743,-1,742,457,744,-1,742,744,743,-1,705,745,696,-1,746,747,745,-1,705,702,746,-1,705,746,745,-1,748,749,747,-1,750,474,749,-1,748,751,750,-1,748,750,749,-1,752,753,751,-1,700,27,753,-1,752,702,700,-1,752,700,753,-1,746,748,747,-1,752,751,748,-1,746,702,752,-1,746,752,748,-1,485,737,454,-1,754,735,737,-1,485,477,754,-1,485,754,737,-1,755,733,735,-1,753,27,733,-1,755,751,753,-1,755,753,733,-1,756,750,751,-1,472,474,750,-1,756,477,472,-1,756,472,750,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_21_coordIndex_7()
		{
			int[] value = {754,755,735,-1,756,751,755,-1,754,477,756,-1,754,756,755,-1,717,731,2,-1,757,729,731,-1,717,714,757,-1,717,757,731,-1,758,727,729,-1,759,441,727,-1,758,760,759,-1,758,759,727,-1,761,762,760,-1,712,696,762,-1,761,714,712,-1,761,712,762,-1,757,758,729,-1,761,760,758,-1,757,714,761,-1,757,761,758,-1,500,749,474,-1,763,747,749,-1,500,494,763,-1,500,763,749,-1,764,745,747,-1,762,696,745,-1,764,760,762,-1,764,762,745,-1,765,759,760,-1,492,441,759,-1,765,494,492,-1,765,492,759,-1,763,764,747,-1,765,760,764,-1,763,494,765,-1,763,765,764,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_21_point_1()
		{
			double[] value = {0.2138,0.2339,0.09065,0.1078,0.2532,0.1026,0.2291,0.2171,0.2249,0.1108,0.2588,-0.004183,0.0,0.2663,0.0,0.2056,0.2385,-0.02711,0.01159,0.2581,-0.09905,-0.1078,0.2532,-0.1026,-0.07594,0.2323,-0.1913,-0.2291,0.2171,-0.2249,0.04333,0.234,-0.1877,0.1204,0.2501,-0.1081,0.1446,0.2273,-0.2063,0.2115,0.2333,-0.1395,0.2292,0.2162,-0.2488,-0.2138,0.2339,-0.09065,-0.1108,0.2588,0.004183,-0.2056,0.2385,0.02711,-0.01159,0.2581,0.09905,0.07594,0.2323,0.1913,-0.04333,0.234,0.1877,-0.1204,0.2501,0.1081,-0.1446,0.2273,0.2063,-0.2115,0.2333,0.1395,-0.2292,0.2162,0.2488,0.101,-0.2561,0.102,0.1971,-0.2415,0.09234,0.2005,-0.227,0.2187,0.1042,-0.2596,-0.003115,0.2032,-0.2379,-0.02377,0.0,-0.2668,0.0,0.1143,-0.2481,-0.1061,0.2236,-0.2248,-0.1363,0.1313,-0.2234,-0.2009,0.2583,-0.206,-0.251,0.01852,-0.2335,-0.1868,0.00532,-0.2585,-0.09823,-0.08985,-0.2348,-0.1944,-0.101,-0.2561,-0.102,-0.2005,-0.227,-0.2187,-0.1971,-0.2415,-0.09234,-0.1042,-0.2596,0.003115,-0.2032,-0.2379,0.02377,-0.1143,-0.2481,0.1061,-0.2236,-0.2248,0.1363,-0.1313,-0.2234,0.2009,-0.2583,-0.206,0.251,-0.01852,-0.2335,0.1868,-0.00532,-0.2585,0.09823,0.08985,-0.2348,0.1944,-0.4035,0.107,0.07638,-0.4224,0.079,-0.0798,-0.4404,-1.47E-5,-0.005179,-0.3541,0.155,0.002264,-0.3857,0.1422,-0.1345,-0.3484,0.176,0.1389,-0.2938,0.2005,-0.05229,-0.3263,0.1918,-0.1796,-0.2826,0.2089,0.07249,-0.2885,0.2128,0.195,-0.4049,-0.1069,-0.0857,-0.4224,-0.07913,0.07054,-0.355,-0.1549,-0.005314,-0.3875,-0.1416,0.131,-0.3487,-0.1764,-0.1423,-0.2968,-0.1987,0.06623,-0.3348,-0.1879,0.1889,-0.2804,-0.21,-0.05825,-0.2817,-0.2164,-0.1847,0.4035,0.107,-0.07638,0.4224,0.079,0.0798,0.4404,-1.47E-5,0.005179,0.3541,0.155,-0.002264,0.3857,0.1422,0.1345,0.3484,0.176,-0.1389,0.2938,0.2005,0.05229,0.3263,0.1918,0.1796,0.2826,0.2089,-0.07249,0.2885,0.2128,-0.195,0.4049,-0.1069,0.0857,0.4224,-0.07913,-0.07054,0.355,-0.1549,0.005314,0.3875,-0.1416,-0.131,0.3487,-0.1764,0.1423,0.2968,-0.1987,-0.06623,0.3348,-0.1879,-0.1889,0.2804,-0.21,0.05825,0.2817,-0.2164,0.1847,0.6031,0.07552,-0.6483,0.5934,0.001736,-0.5082,0.6207,0.00108,-0.6632,0.572,0.07537,-0.4957,0.539,0.001856,-0.3514,0.5627,0.1387,-0.6353,0.5173,0.07523,-0.3411,0.479,0.001181,-0.1888,0.4569,0.0798,-0.1913,0.4752,0.1398,-0.3526,0.5299,0.1381,-0.4919,0.4749,0.1807,-0.4967};
			return value;
		}
		private double[] getCoordinate_6_21_point_2()
		{
			double[] value = {0.5073,0.1811,-0.6254,0.4454,0.1958,-0.6193,0.3022,0.2057,-0.3155,0.358,0.195,-0.2746,0.3652,0.1986,-0.4032,0.4218,0.1843,-0.3769,0.4151,0.1956,-0.5067,0.4119,0.1508,-0.2314,0.524,-0.1823,-0.6916,0.455,-0.1974,-0.5744,0.4616,-0.1983,-0.6919,0.5128,-0.1812,-0.5593,0.4157,-0.1968,-0.4613,0.5766,-0.1384,-0.6867,0.4663,-0.1806,-0.4315,0.3487,-0.1977,-0.3554,0.3973,-0.1819,-0.3096,0.5094,-0.1362,-0.4031,0.5601,-0.1371,-0.5425,0.589,-0.07266,-0.5251,0.611,-0.07388,-0.6769,0.4727,-0.07256,-0.225,0.5358,-0.07184,-0.3757,0.4441,-0.1368,-0.2671,0.3021,-0.07636,-0.666,0.274,-0.002833,-0.5747,0.286,-0.001857,-0.6491,0.295,-0.07689,-0.5875,0.2436,-0.003539,-0.5066,0.3419,-0.1401,-0.6796,0.2677,-0.07709,-0.5146,0.1965,-0.003765,-0.4494,0.2221,-0.07672,-0.4516,0.1363,-0.003363,-0.4061,0.3101,-0.1395,-0.5084,0.3377,-0.14,-0.5914,0.3939,-0.1825,-0.5864,0.398,-0.1831,-0.6882,0.2283,-0.1824,-0.3263,0.3052,-0.1813,-0.4007,0.1952,-0.1378,-0.3746,0.3621,-0.1817,-0.4892,0.2612,-0.1387,-0.4347,0.1619,-0.07572,-0.4019,0.3846,0.1799,-0.6177,0.3575,0.1793,-0.5196,0.3325,0.1365,-0.622,0.3114,0.1806,-0.4303,0.2507,0.1842,-0.3561,0.2682,0.1354,-0.459,0.3095,0.1354,-0.5364,0.2795,0.07147,-0.5559,0.2974,0.07264,-0.6331,0.1275,0.07087,-0.3874,0.1922,0.07059,-0.4291,0.1414,0.1381,-0.3504,0.2438,0.07073,-0.4863,0.2114,0.1365,-0.3958,0.1773,0.1892,-0.3019,0.06747,-0.002245,-0.3792,0.09177,-0.07429,-0.3694,-0.005383,-6.772E-4,-0.3704,0.01582,-0.07292,-0.3565,-0.07782,0.001124,-0.3802,-0.06144,-0.07181,-0.3635,-0.1455,0.002776,-0.408,0.03026,-0.1382,-0.3191,0.1168,-0.1374,-0.3349,0.1345,-0.1868,-0.2788,-0.1645,-0.1929,-0.2948,-0.07047,-0.195,-0.2676,-0.1422,-0.1386,-0.3503,0.03104,-0.1926,-0.2616,-0.05869,-0.1391,-0.3249,-0.135,-0.07091,-0.389,0.09066,0.1937,-0.2699,-0.01073,0.1943,-0.2598,-0.1212,0.1907,-0.2727,-0.03136,0.1387,-0.3183,0.05917,0.1391,-0.3245,0.05323,0.07134,-0.363,-0.1706,0.07475,-0.4046,-0.1011,0.07331,-0.3711,-0.2005,0.1378,-0.376,-0.02489,0.07211,-0.3571,-0.1204,0.1381,-0.3344,-0.2236,0.1856,-0.3213,-0.4805,-0.001448,-0.1977,-0.4739,0.0722,-0.2329,-0.5412,-0.002437,-0.3577,-0.538,0.07122,-0.3818,-0.5955,-0.002438,-0.512,-0.5916,0.07183,-0.5293,-0.6223,-0.001671,-0.6651,-0.51,0.1363,-0.4073,-0.4424,0.1376,-0.2711,-0.3901,0.1851,-0.3067,-0.526,0.1816,-0.6939,-0.4576,0.1966,-0.5775,-0.4629,0.1978,-0.6935};
			return value;
		}
		private double[] getCoordinate_6_21_point_3()
		{
			double[] value = {-0.5155,0.1804,-0.5628,-0.4171,0.1968,-0.4636,-0.579,0.1376,-0.6895,-0.4659,0.1812,-0.4336,-0.3427,0.2009,-0.3514,-0.5627,0.1363,-0.5466,-0.6132,0.07311,-0.6795,-0.2976,-0.2088,-0.3115,-0.3585,-0.1958,-0.2783,-0.3675,-0.1987,-0.4074,-0.4251,-0.1837,-0.3832,-0.4184,-0.1948,-0.5113,-0.4774,-0.1801,-0.5008,-0.4471,-0.1952,-0.6215,-0.478,-0.1392,-0.359,-0.4146,-0.1504,-0.2394,-0.459,-0.07959,-0.2002,-0.6041,-0.07586,-0.6496,-0.5737,-0.07565,-0.499,-0.5634,-0.1387,-0.6363,-0.5194,-0.07525,-0.3472,-0.5317,-0.1379,-0.4953,-0.5083,-0.1807,-0.6268,-0.2041,0.003795,-0.452,-0.1992,-0.07028,-0.4316,-0.2493,0.004066,-0.5095,-0.2498,-0.07012,-0.4894,-0.2779,0.003537,-0.5772,-0.2841,-0.07064,-0.5593,-0.2883,0.002454,-0.6509,-0.2725,-0.1355,-0.4611,-0.2145,-0.1372,-0.3957,-0.2468,-0.1873,-0.3508,-0.3871,-0.1791,-0.6206,-0.3613,-0.1785,-0.524,-0.3356,-0.1356,-0.6251,-0.3135,-0.1812,-0.4322,-0.3139,-0.1347,-0.5402,-0.3003,-0.07187,-0.6357,-0.3067,0.1819,-0.4016,-0.3657,0.181,-0.4925,-0.3963,0.1818,-0.5888,-0.3144,0.1388,-0.5114,-0.2669,0.1379,-0.4379,-0.2291,0.07609,-0.4545,-0.3035,0.07672,-0.667,-0.2979,0.07718,-0.5893,-0.3426,0.1401,-0.6803,-0.2726,0.07699,-0.517,-0.3399,0.1398,-0.5931,-0.3988,0.1828,-0.6891,-0.6065,-7.967E-4,-0.819,-0.5912,0.0744,-0.8307,-0.5464,-1.795E-4,-0.9665,-0.5266,0.07519,-0.9742,-0.4471,9.08E-5,-1.096,-0.4253,0.07548,-1.099,-0.3168,1.174E-4,-1.197,-0.4873,0.1397,-0.9666,-0.5525,0.1389,-0.8323,-0.4977,0.1827,-0.8241,-0.2294,0.1834,-1.123,-0.2973,0.199,-1.004,-0.1954,0.199,-1.069,-0.3441,0.1834,-1.048,-0.379,0.1989,-0.9152,-0.264,0.1399,-1.167,-0.4356,0.1833,-0.9453,-0.4355,0.1986,-0.8087,-0.3888,0.1399,-1.081,-0.2948,0.0755,-1.194,-0.4478,-0.1969,-0.735,-0.5078,-0.1821,-0.7552,-0.4169,-0.1983,-0.8455,-0.4708,-0.183,-0.8798,-0.355,-0.1989,-0.9456,-0.3984,-0.1833,-0.9925,-0.2669,-0.1991,-1.028,-0.5152,-0.1397,-0.9143,-0.5597,-0.1394,-0.7776,-0.5951,-0.07568,-0.7999,-0.3248,-0.07529,-1.176,-0.4494,-0.07531,-1.074,-0.3174,-0.1398,-1.136,-0.5422,-0.07546,-0.9448,-0.4319,-0.1398,-1.037,-0.2966,-0.1834,-1.084,-0.2794,0.001311,-0.7251,-0.2962,-0.07341,-0.7129,-0.2516,4.005E-4,-0.7943,-0.2717,-0.07469,-0.7862,-0.2059,-1.038E-4,-0.8538,-0.2277,-0.0754,-0.8511,-0.1456,-2.276E-4,-0.9001,-0.3104,-0.1389,-0.7937,-0.3346,-0.1374,-0.711,-0.3876,-0.1809,-0.719,-0.2329,-0.1835,-0.9736,-0.3083,-0.1833,-0.9021,-0.1983,-0.14,-0.9297};
			return value;
		}
		private double[] getCoordinate_6_21_point_4()
		{
			double[] value = {-0.3612,-0.1825,-0.8151,-0.2639,-0.1398,-0.8685,-0.1675,-0.0756,-0.9034,-0.3742,0.1832,-0.7892,-0.3249,0.1833,-0.8812,-0.2539,0.1833,-0.9577,-0.281,0.1398,-0.8468,-0.3225,0.14,-0.7672,-0.2888,0.07605,-0.7447,-0.1376,0.07517,-0.9209,-0.2035,0.07521,-0.8762,-0.145,0.1396,-0.9608,-0.255,0.0755,-0.8162,-0.2207,0.1396,-0.9129,-0.1657,0.1833,-1.013,-0.1642,6.4E-5,-1.26,-0.1437,0.07545,-1.251,1.83E-5,0.0,-1.281,0.01755,0.0754,-1.267,0.1643,-3.56E-5,-1.26,0.1775,0.07536,-1.242,0.3169,-7.69E-5,-1.197,0.03121,0.1398,-1.229,-0.1206,0.1399,-1.218,-0.09854,0.1834,-1.166,0.2968,0.1834,-1.084,0.1598,0.1991,-1.084,0.267,0.1991,-1.028,0.174,0.1834,-1.146,0.04144,0.199,-1.11,0.3175,0.1398,-1.136,0.03908,0.1834,-1.174,-0.07981,0.199,-1.105,0.1807,0.1398,-1.202,0.3249,0.07533,-1.176,-0.1598,-0.1991,-1.084,-0.174,-0.1834,-1.146,-0.04143,-0.199,-1.11,-0.03907,-0.1834,-1.174,0.07985,-0.199,-1.105,0.09858,-0.1834,-1.166,0.1956,-0.199,-1.069,-0.03119,-0.1398,-1.229,-0.1806,-0.1398,-1.202,-0.1775,-0.07533,-1.242,0.2949,-0.07546,-1.194,0.1438,-0.07542,-1.251,0.2641,-0.1399,-1.167,-0.01752,-0.07538,-1.267,0.1207,-0.1399,-1.218,0.2296,-0.1834,-1.123,-0.07525,-1.537E-4,-0.9296,-0.09579,-0.07554,-0.9385,1.95E-5,0.0,-0.9398,-0.01757,-0.07541,-0.9536,0.07532,1.248E-4,-0.9297,0.06205,-0.07528,-0.9474,0.1457,1.867E-4,-0.9002,-0.03125,-0.1399,-0.9915,-0.1189,-0.14,-0.9717,-0.141,-0.1835,-1.023,0.1659,-0.1833,-1.013,0.06562,-0.1834,-1.043,0.1451,-0.1397,-0.961,-0.03911,-0.1834,-1.047,0.05891,-0.1398,-0.9877,0.1378,-0.0752,-0.921,-0.06557,0.1833,-1.043,0.03912,0.1834,-1.047,0.1411,0.1835,-1.023,0.03127,0.1398,-0.9914,-0.05885,0.1397,-0.9876,-0.06197,0.07525,-0.9473,0.1676,0.07556,-0.9036,0.09586,0.07552,-0.9386,0.1984,0.14,-0.9298,0.0176,0.07539,-0.9535,0.119,0.14,-0.9718,0.233,0.1835,-0.9738,0.4471,-8.25E-5,-1.096,0.4495,0.07532,-1.074,0.5461,5.18E-5,-0.9663,0.5421,0.07538,-0.9449,0.6056,4.361E-4,-0.8182,0.5946,0.07545,-0.7996,0.5153,0.1396,-0.9146,0.432,0.1398,-1.038,0.3986,0.1833,-0.9928,0.4474,0.1972,-0.7346,0.5076,0.1822,-0.7552,0.417,0.1984,-0.8458,0.471,0.183,-0.8802,0.3552,0.1989,-0.946,0.5595,0.1393,-0.7777,0.2976,-0.199,-1.005,0.3443,-0.1834,-1.048,0.3793,-0.1989,-0.9154,0.4356,-0.1834,-0.9453,0.4354,-0.1988,-0.8083,0.4971,-0.1831,-0.8234};
			return value;
		}
		private double[] getCoordinate_6_21_point_5()
		{
			double[] value = {0.4871,-0.1398,-0.9664,0.3889,-0.1399,-1.082,0.4253,-0.07548,-1.099,0.59,-0.07485,-0.8295,0.5262,-0.07534,-0.974,0.5514,-0.1394,-0.8312,0.206,9.61E-5,-0.8539,0.2037,-0.07522,-0.8763,0.2514,-2.704E-4,-0.794,0.255,-0.07541,-0.8161,0.2785,-9.464E-4,-0.7242,0.2884,-0.07581,-0.7443,0.2813,-0.1397,-0.847,0.2209,-0.1396,-0.9131,0.2542,-0.1833,-0.9579,0.3743,-0.1833,-0.7892,0.3253,-0.1833,-0.8814,0.3225,-0.1399,-0.7671,0.3085,0.1833,-0.9024,0.3612,0.1826,-0.8151,0.3868,0.1813,-0.7181,0.3102,0.1391,-0.7936,0.264,0.1398,-0.8687,0.2278,0.07539,-0.8512,0.2949,0.07386,-0.7116,0.2714,0.07484,-0.7859,0.3334,0.1379,-0.7096,0.6132,0.07311,0.6795,0.6065,-7.967E-4,0.819,0.6223,-0.001671,0.6651,0.5912,0.0744,0.8307,0.5464,-1.795E-4,0.9665,0.579,0.1376,0.6895,0.5266,0.07519,0.9742,0.4471,9.08E-5,1.096,0.4253,0.07548,1.099,0.3168,1.174E-4,1.197,0.4873,0.1397,0.9666,0.5525,0.1389,0.8323,0.4977,0.1827,0.8241,0.526,0.1816,0.6939,0.4629,0.1978,0.6935,0.2294,0.1834,1.123,0.2973,0.199,1.004,0.1954,0.199,1.069,0.3441,0.1834,1.048,0.379,0.1989,0.9152,0.264,0.1399,1.167,0.4356,0.1833,0.9453,0.4355,0.1986,0.8087,0.3888,0.1399,1.081,0.2948,0.0755,1.194,0.5083,-0.1807,0.6268,0.4478,-0.1969,0.735,0.4471,-0.1952,0.6215,0.5078,-0.1821,0.7552,0.4169,-0.1983,0.8455,0.5634,-0.1387,0.6363,0.4708,-0.183,0.8798,0.355,-0.1989,0.9456,0.3984,-0.1833,0.9925,0.2669,-0.1991,1.028,0.5152,-0.1397,0.9143,0.5597,-0.1394,0.7776,0.5951,-0.07568,0.7999,0.6041,-0.07586,0.6496,0.3248,-0.07529,1.176,0.4494,-0.07531,1.074,0.3174,-0.1398,1.136,0.5422,-0.07546,0.9448,0.4319,-0.1398,1.037,0.2966,-0.1834,1.084,0.3003,-0.07187,0.6357,0.2794,0.001311,0.7251,0.2883,0.002454,0.6509,0.2962,-0.07341,0.7129,0.2516,4.005E-4,0.7943,0.3356,-0.1356,0.6251,0.2717,-0.07469,0.7862,0.2059,-1.038E-4,0.8538,0.2277,-0.0754,0.8511,0.1456,-2.276E-4,0.9001,0.3104,-0.1389,0.7937,0.3346,-0.1374,0.711,0.3876,-0.1809,0.719,0.3871,-0.1791,0.6206,0.2329,-0.1835,0.9736,0.3083,-0.1833,0.9021,0.1983,-0.14,0.9297,0.3612,-0.1825,0.8151,0.2639,-0.1398,0.8685,0.1675,-0.0756,0.9034,0.3988,0.1828,0.6891,0.3742,0.1832,0.7892,0.3426,0.1401,0.6803,0.3249,0.1833,0.8812,0.2539,0.1833,0.9577,0.281,0.1398,0.8468,0.3225,0.14,0.7672,0.2888,0.07605,0.7447};
			return value;
		}
		private double[] getCoordinate_6_21_point_6()
		{
			double[] value = {0.3035,0.07672,0.667,0.1376,0.07517,0.9209,0.2035,0.07521,0.8762,0.145,0.1396,0.9608,0.255,0.0755,0.8162,0.2207,0.1396,0.9129,0.1657,0.1833,1.013,0.1642,6.4E-5,1.26,0.1437,0.07545,1.251,-1.83E-5,0.0,1.281,-0.01755,0.0754,1.267,-0.1643,-3.56E-5,1.26,-0.1775,0.07536,1.242,-0.3169,-7.69E-5,1.197,-0.03121,0.1398,1.229,0.1206,0.1399,1.218,0.09854,0.1834,1.166,-0.2968,0.1834,1.084,-0.1598,0.1991,1.084,-0.267,0.1991,1.028,-0.174,0.1834,1.146,-0.04144,0.199,1.11,-0.3175,0.1398,1.136,-0.03908,0.1834,1.174,0.07981,0.199,1.105,-0.1807,0.1398,1.202,-0.3249,0.07533,1.176,0.1598,-0.1991,1.084,0.174,-0.1834,1.146,0.04143,-0.199,1.11,0.03907,-0.1834,1.174,-0.07985,-0.199,1.105,-0.09858,-0.1834,1.166,-0.1956,-0.199,1.069,0.03119,-0.1398,1.229,0.1806,-0.1398,1.202,0.1775,-0.07533,1.242,-0.2949,-0.07546,1.194,-0.1438,-0.07542,1.251,-0.2641,-0.1399,1.167,0.01752,-0.07538,1.267,-0.1207,-0.1399,1.218,-0.2296,-0.1834,1.123,0.07525,-1.537E-4,0.9296,0.09579,-0.07554,0.9385,-1.95E-5,0.0,0.9398,0.01757,-0.07541,0.9536,-0.07532,1.248E-4,0.9297,-0.06205,-0.07528,0.9474,-0.1457,1.867E-4,0.9002,0.03125,-0.1399,0.9915,0.1189,-0.14,0.9717,0.141,-0.1835,1.023,-0.1659,-0.1833,1.013,-0.06562,-0.1834,1.043,-0.1451,-0.1397,0.961,0.03911,-0.1834,1.047,-0.05891,-0.1398,0.9877,-0.1378,-0.0752,0.921,0.06557,0.1833,1.043,-0.03912,0.1834,1.047,-0.1411,0.1835,1.023,-0.03127,0.1398,0.9914,0.05885,0.1397,0.9876,0.06197,0.07525,0.9473,-0.1676,0.07556,0.9036,-0.09586,0.07552,0.9386,-0.1984,0.14,0.9298,-0.0176,0.07539,0.9535,-0.119,0.14,0.9718,-0.233,0.1835,0.9738,-0.4471,-8.25E-5,1.096,-0.4495,0.07532,1.074,-0.5461,5.18E-5,0.9663,-0.5421,0.07538,0.9449,-0.6056,4.361E-4,0.8182,-0.5946,0.07545,0.7996,-0.6207,0.00108,0.6632,-0.5153,0.1396,0.9146,-0.432,0.1398,1.038,-0.3986,0.1833,0.9928,-0.5073,0.1811,0.6254,-0.4474,0.1972,0.7346,-0.4454,0.1958,0.6193,-0.5076,0.1822,0.7552,-0.417,0.1984,0.8458,-0.5627,0.1387,0.6353,-0.471,0.183,0.8802,-0.3552,0.1989,0.946,-0.5595,0.1393,0.7777,-0.6031,0.07552,0.6483,-0.2976,-0.199,1.005,-0.3443,-0.1834,1.048,-0.3793,-0.1989,0.9154,-0.4356,-0.1834,0.9453,-0.4354,-0.1988,0.8083,-0.4971,-0.1831,0.8234,-0.4616,-0.1983,0.6919,-0.4871,-0.1398,0.9664,-0.3889,-0.1399,1.082};
			return value;
		}
		private double[] getCoordinate_6_21_point_7()
		{
			double[] value = {-0.4253,-0.07548,1.099,-0.611,-0.07388,0.6769,-0.59,-0.07485,0.8295,-0.5766,-0.1384,0.6867,-0.5262,-0.07534,0.974,-0.5514,-0.1394,0.8312,-0.524,-0.1823,0.6916,-0.206,9.61E-5,0.8539,-0.2037,-0.07522,0.8763,-0.2514,-2.704E-4,0.794,-0.255,-0.07541,0.8161,-0.2785,-9.464E-4,0.7242,-0.2884,-0.07581,0.7443,-0.286,-0.001857,0.6491,-0.2813,-0.1397,0.847,-0.2209,-0.1396,0.9131,-0.2542,-0.1833,0.9579,-0.398,-0.1831,0.6882,-0.3743,-0.1833,0.7892,-0.3419,-0.1401,0.6796,-0.3253,-0.1833,0.8814,-0.3225,-0.1399,0.7671,-0.3021,-0.07636,0.666,-0.3085,0.1833,0.9024,-0.3612,0.1826,0.8151,-0.3868,0.1813,0.7181,-0.3102,0.1391,0.7936,-0.264,0.1398,0.8687,-0.2278,0.07539,0.8512,-0.2974,0.07264,0.6331,-0.2949,0.07386,0.7116,-0.3325,0.1365,0.622,-0.2714,0.07484,0.7859,-0.3334,0.1379,0.7096,-0.3846,0.1799,0.6177,-0.5934,0.001736,0.5082,-0.572,0.07537,0.4957,-0.539,0.001856,0.3514,-0.5173,0.07523,0.3411,-0.479,0.001181,0.1888,-0.4569,0.0798,0.1913,-0.4752,0.1398,0.3526,-0.5299,0.1381,0.4919,-0.4749,0.1807,0.4967,-0.3022,0.2057,0.3155,-0.358,0.195,0.2746,-0.3652,0.1986,0.4032,-0.4218,0.1843,0.3769,-0.4151,0.1956,0.5067,-0.4119,0.1508,0.2314,-0.455,-0.1974,0.5744,-0.5128,-0.1812,0.5593,-0.4157,-0.1968,0.4613,-0.4663,-0.1806,0.4315,-0.3487,-0.1977,0.3554,-0.3973,-0.1819,0.3096,-0.5094,-0.1362,0.4031,-0.5601,-0.1371,0.5425,-0.589,-0.07266,0.5251,-0.4727,-0.07256,0.225,-0.5358,-0.07184,0.3757,-0.4441,-0.1368,0.2671,-0.274,-0.002833,0.5747,-0.295,-0.07689,0.5875,-0.2436,-0.003539,0.5066,-0.2677,-0.07709,0.5146,-0.1965,-0.003765,0.4494,-0.2221,-0.07672,0.4516,-0.1363,-0.003363,0.4061,-0.3101,-0.1395,0.5084,-0.3377,-0.14,0.5914,-0.3939,-0.1825,0.5864,-0.2283,-0.1824,0.3263,-0.3052,-0.1813,0.4007,-0.1952,-0.1378,0.3746,-0.3621,-0.1817,0.4892,-0.2612,-0.1387,0.4347,-0.1619,-0.07572,0.4019,-0.3575,0.1793,0.5196,-0.3114,0.1806,0.4303,-0.2507,0.1842,0.3561,-0.2682,0.1354,0.459,-0.3095,0.1354,0.5364,-0.2795,0.07147,0.5559,-0.1275,0.07087,0.3874,-0.1922,0.07059,0.4291,-0.1414,0.1381,0.3504,-0.2438,0.07073,0.4863,-0.2114,0.1365,0.3958,-0.1773,0.1892,0.3019,-0.06747,-0.002245,0.3792,-0.09177,-0.07429,0.3694,0.005383,-6.772E-4,0.3704,-0.01582,-0.07292,0.3565,0.07782,0.001124,0.3802,0.06144,-0.07181,0.3635,0.1455,0.002776,0.408,-0.03026,-0.1382,0.3191,-0.1168,-0.1374,0.3349,-0.1345,-0.1868,0.2788};
			return value;
		}
		private double[] getCoordinate_6_21_point_8()
		{
			double[] value = {0.1645,-0.1929,0.2948,0.07047,-0.195,0.2676,0.1422,-0.1386,0.3503,-0.03104,-0.1926,0.2616,0.05869,-0.1391,0.3249,0.135,-0.07091,0.389,-0.09066,0.1937,0.2699,0.01073,0.1943,0.2598,0.1212,0.1907,0.2727,0.03136,0.1387,0.3183,-0.05917,0.1391,0.3245,-0.05323,0.07134,0.363,0.1706,0.07475,0.4046,0.1011,0.07331,0.3711,0.2005,0.1378,0.376,0.02489,0.07211,0.3571,0.1204,0.1381,0.3344,0.2236,0.1856,0.3213,0.4805,-0.001448,0.1977,0.4739,0.0722,0.2329,0.5412,-0.002437,0.3577,0.538,0.07122,0.3818,0.5955,-0.002438,0.512,0.5916,0.07183,0.5293,0.51,0.1363,0.4073,0.4424,0.1376,0.2711,0.3901,0.1851,0.3067,0.4576,0.1966,0.5775,0.5155,0.1804,0.5628,0.4171,0.1968,0.4636,0.4659,0.1812,0.4336,0.3427,0.2009,0.3514,0.5627,0.1363,0.5466,0.2976,-0.2088,0.3115,0.3585,-0.1958,0.2783,0.3675,-0.1987,0.4074,0.4251,-0.1837,0.3832,0.4184,-0.1948,0.5113,0.4774,-0.1801,0.5008,0.478,-0.1392,0.359,0.4146,-0.1504,0.2394,0.459,-0.07959,0.2002,0.5737,-0.07565,0.499,0.5194,-0.07525,0.3472,0.5317,-0.1379,0.4953,0.2041,0.003795,0.452,0.1992,-0.07028,0.4316,0.2493,0.004066,0.5095,0.2498,-0.07012,0.4894,0.2779,0.003537,0.5772,0.2841,-0.07064,0.5593,0.2725,-0.1355,0.4611,0.2145,-0.1372,0.3957,0.2468,-0.1873,0.3508,0.3613,-0.1785,0.524,0.3135,-0.1812,0.4322,0.3139,-0.1347,0.5402,0.3067,0.1819,0.4016,0.3657,0.181,0.4925,0.3963,0.1818,0.5888,0.3144,0.1388,0.5114,0.2669,0.1379,0.4379,0.2291,0.07609,0.4545,0.2979,0.07718,0.5893,0.2726,0.07699,0.517,0.3399,0.1398,0.5931};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #21, 6144 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_21_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_21_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_3()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_4()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_5()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_6()))
				.append(new MFInt32(getIndexedFaceSet_5_21_coordIndex_7()));
			return IndexedFaceSet_5_21_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #21, 2298 total numbers made up of 766 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_21_point()
		{
			MFVec3f Coordinate_6_21_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_21_point_1()))
				.append(new MFVec3f(getCoordinate_6_21_point_2()))
				.append(new MFVec3f(getCoordinate_6_21_point_3()))
				.append(new MFVec3f(getCoordinate_6_21_point_4()))
				.append(new MFVec3f(getCoordinate_6_21_point_5()))
				.append(new MFVec3f(getCoordinate_6_21_point_6()))
				.append(new MFVec3f(getCoordinate_6_21_point_7()))
				.append(new MFVec3f(getCoordinate_6_21_point_8()));
			return Coordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Eight model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Eight().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ExperimentalBinaryCompression.Eight\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ExperimentalBinaryCompression.Eight self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ExperimentalBinaryCompression/Eight_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ExperimentalBinaryCompression/Eight_JavaExport.x3d"; 
                String filenameX3DV = "ExperimentalBinaryCompression/Eight_JavaExport.x3dv"; 
                String filenameJSON = "ExperimentalBinaryCompression/Eight_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
