/**
 *<p>
 *	Distributed Interactive Simulation (DIS) is an IEEE standard for conducting real-time platform-level
 *	gaming across multiple host computers and is used worldwide, especially by military organizations
 *	but also by other agencies such as those involved in space exploration and medicine.
 *</p>
 *<p>
 *	A supporting
 *	<a href="https://x3dGraphics.com/slidesets/X3dForAdvancedModeling" target="X3dChapterSlideset">DIS chapter slideset</a>
 *	is available online via
 *	<a href="https://x3dGraphics.com">X3dGraphics.com</a>.
 *	Related work includes
 *	<a href="https://savage.nps.edu/X3D-Edit/#DIS" target="Open-DIS">X3D-Edit DIS Support</a>
 *	as well as the
 *	<a href="http://open-dis.sourceforge.net/Open-DIS.html" target="Open-DIS">Open-DIS software library</a>,
 *	which provides open-source implementations of DIS in C++, C#, Java, Objective-C and JavaScript.
 *</p>
 *
 *<p>
 *	<i>Advisory:</i>
 *	the Distributed Interactive Simulation (DIS) component in not yet widely supported in X3D.
 *	Further work is welcome.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation" target="_blank">X3D Basic: Distributed Interactive Simulation</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.DistributedInteractiveSimulation;

