####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python AutomatedEntityGeometryCreator.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    component(level=2,name='DIS'),
    meta(content='AutomatedEntityGeometryCreator.x3d',name='title'),
    meta(content='Example scene for DISEntityManager and DISEntityTypeMapping, showing design pattern to detect presence of new DIS entities and automatically produce EspduTransform holding an Inline copy of the appropriate model.',name='description'),
    meta(content='Alan Hudson and Justin Couch',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='4 March 2005',name='created'),
    meta(content='8 January 2009',name='translated'),
    meta(content='3 July 2022',name='modified'),
    meta(content='AutomatedEntityGeometryCreatorOriginal.x3dv',name='reference'),
    meta(content='http://www.xj3d.org/extensions/DIS_examples.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/dis.html#DISEntityManager',name='reference'),
    meta(content='IEEE Distributed Interactive Simulation DIS',name='subject'),
    meta(content='under development',name='warning'),
    meta(content='missing script source',name='error'),
    meta(content='http://bugzilla.xj3d.org/show_bug.cgi?id=561',name='reference'),
    meta(content='conversion of .x3dv original version failed',name='warning'),
    meta(content='http://bugzilla.xj3d.org/show_bug.cgi?id=563',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation/AutomatedEntityGeometryCreator.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Xj3D, http://www.xj3d.org',name='generator'),
    meta(content='../license.html',name='license')]),
  #  TODO editor pane: add tooltips to various DIS editor panes 
  #  TODO: change notional url connections to actual models 
  #  TODO: integrate Open-DIS enumerations for field selections wherever appropriate 
  #  TODO: add test file for playback and console output or description of results 
  Scene=Scene(
    children=[
    WorldInfo(title='AutomatedEntityGeometryCreator.x3d'),
    DISEntityManager(DEF='EntityManager',address='224.2.181.145',port=62040,
      #  default containerField for DISEntityManager child DISEntityTypeMapping changed from 'mapping' to 'children' in X3D4 
      children=[
      DISEntityTypeMapping(category=1,country=225,domain=1,kind=1,url=["usatank.x3d","https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation/usatank.x3d"]),
      DISEntityTypeMapping(category=4,country=225,domain=3,kind=1,url=["ddg.x3d","https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation/ddg.x3d"]),
      DISEntityTypeMapping(domain=1,kind=1,url=["land.x3d","https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation/land.x3d"]),
      DISEntityTypeMapping(domain=3,kind=1,url=["surface.x3d","https://www.web3d.org/x3d/content/examples/Basic/DistributedInteractiveSimulation/surface.x3d"])]),
    Group(DEF='EntityHolder'),
    ROUTE(fromField='addedEntities',fromNode='EntityManager',toField='addChildren',toNode='EntityHolder'),
    ROUTE(fromField='removedEntities',fromNode='EntityManager',toField='removeChildren',toNode='EntityHolder')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for AutomatedEntityGeometryCreator.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python AutomatedEntityGeometryCreator.py load and self-test diagnostics complete.")
