/**
 *<p>
 *	<a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">Chemical Markup Language (CML)</a>
 *      provides support for most chemistry including molecules, compounds, reactions, spectra, crystals and computational chemistry.
 *</p>
 *<p>
 *	These examples
 *	show how to visualize 
 *	<a href="https://xml-cml.org" target="_blank">Chemical Markup Language (CML)</a>
 *	molecular definitions, combined with previously designed X3D model prototypes, by converting CML molecule definitions in XML through
 *	<a href="../../../ChemicalMarkupLanguage/CmlToX3d.xslt" target="_blank">CmlToX3d.xslt</a> stylesheet
 *	transformations.
 *	This process is described in the paper 
 *	&quot;<a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf" target="_blank">Stylesheet Transformations for Interactive Visualization: Towards a Web3D Chemistry Curricula</a>,&quot;
 *	originally published in 
 *	<i><a href="https://dl.acm.org/citation.cfm?id=636593&amp;picked=prox&amp;CFID=74553243&amp;CFTOKEN=60897567" target="_blank">Proceedings of Web3D 2003 Symposium</a></i>,
 *	St.&nbsp;Malo France, 9-12 March 2003, ACM Press. 
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage" target="_blank">X3D Basic: Chemical Markup Language</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.ChemicalMarkupLanguage;

