package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of tetrahydrofuran.x3d scene produced from tetrahydrofuran.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/tetrahydrofuranIndex.html" target="_blank">tetrahydrofuran</a>,  source <a href="../../../ChemicalMarkupLanguage/Tetrahydrofuran.java">Tetrahydrofuran.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/tetrahydrofuran.x3d">tetrahydrofuran.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of tetrahydrofuran.x3d scene produced from tetrahydrofuran.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/tetrahydrofuran.xml">tetrahydrofuran.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/tetrahydrofuran.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/tetrahydrofuran.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class Tetrahydrofuran
{
	/** Default constructor to create this object. */
	public Tetrahydrofuran ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("tetrahydrofuran.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of tetrahydrofuran.x3d scene produced from tetrahydrofuran.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("tetrahydrofuran.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/tetrahydrofuran.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect tetrahydrofuran").setPosition(0.0,2.0,20.0))
    .addComments(" <?xml-stylesheet type=\"text/xsl\" href=\"generic.xsl\" ?> ")
    .addComments(" CML document - tetrahydrofuran - karne - 7/8/00 ")
    .addComments(" file converted from: MDL .mol ")
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"tetrahydrofuran: C4 H8 O"}))))
      .addChild(new Transform().setTranslation(0.0,5.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"molecular weight: 72.1066"}))))
      .addChild(new Transform().setTranslation(0.0,4.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"melting point: -108.3"}))))
      .addChild(new Transform().setTranslation(0.0,3.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"boiling point: 65"}))))
      .addChild(new Transform().setTranslation(0.0,2.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"specific gravity: 0.886"}))))
      .addChild(new Transform().setTranslation(0.0,1.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"water solubility: 30"}))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"CAS: 109-99-9"}))))
      .addChild(new Transform().setTranslation(0.0,-1.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"ACX: I1001473"}))))
      .addChild(new Transform().setTranslation(0.0,-2.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"DOT: UN 2056"}))))
      .addChild(new Transform().setTranslation(0.0,-3.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"RTECS: LU5950000"}))))
      .addChild(new Transform().setTranslation(0.0,-4.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"comments: Colorless liquid with an ether-like odor detectable at 2 to 50 ppm. HYGROSCOPIC"})))))
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "tetrahydrofuran_karne_a_1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0300,-1.1700,0.0000)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "tetrahydrofuran_karne_a_2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.2200,-0.2900,0.0000)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "tetrahydrofuran_karne_a_3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.2400,-0.2800,0.0000)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "tetrahydrofuran_karne_a_4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.7700,1.1600,0.0000)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "tetrahydrofuran_karne_a_5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7700,1.1600,0.0000))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "tetrahydrofuran_karne_b_1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.2200,-0.2900,0.0000,0.0300,-1.1700,0.0000})))))
      .addChild(new ProtoInstance("line", "tetrahydrofuran_karne_b_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2400,-0.2800,0.0000,0.0300,-1.1700,0.0000})))))
      .addChild(new ProtoInstance("line", "tetrahydrofuran_karne_b_3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.7700,1.1600,0.0000,-1.2200,-0.2900,0.0000})))))
      .addChild(new ProtoInstance("line", "tetrahydrofuran_karne_b_4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7700,1.1600,0.0000,1.2400,-0.2800,0.0000})))))
      .addChild(new ProtoInstance("line", "tetrahydrofuran_karne_b_5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.7700,1.1600,0.0000,0.7700,1.1600,0.0000})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Tetrahydrofuran model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Tetrahydrofuran().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.Tetrahydrofuran\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.Tetrahydrofuran self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/Tetrahydrofuran_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/Tetrahydrofuran_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/Tetrahydrofuran_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/Tetrahydrofuran_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
