####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SomatoStatin.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='SomatoStatin.x3d',name='title'),
    meta(content='Autogenerated version of SomatoStatin.x3d scene produced from SomatoStatin.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='SomatoStatin.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/SomatoStatin.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect SomatoStatin',position=(0,2,20)),
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["SomatoStatin: "])])])]),
    #  <date day="23" month="11" year="1995"></date> 
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='a1',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-12.2078,-4.5188,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-10.7479,-4.0461,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a3',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-12.2078,-6.0483,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-13.5565,-3.7541,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-10.2751,-2.5862,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-9.8441,-5.2836,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a7',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-10.7479,-6.5349,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a8',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-13.5565,-6.8269,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a9',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-14.8774,-4.5188,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a10',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.7735,-2.2525,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a11',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-14.8774,-6.0483,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a12',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-8.9681,-0.723,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a13',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.3285,-3.7263,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.8986,0.8064,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a15',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-7.6472,-5.1167,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a16',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-9.7607,-4.2964,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.5927,2.3081,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a18',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-10.4281,0.9872,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a19',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-6.7296,-6.3542,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a20',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-10.0666,2.753,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a21',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-8.0366,3.7541,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a22',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-5.6451,-7.4526,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a23',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.9253,-7.3692,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a24',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-10.4281,4.2546,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a25',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.244,5.075,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a26',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-4.3937,-8.3425,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a27',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-6.6322,-8.6344,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a28',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-9.3714,-6.8408,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a29',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-11.9019,4.6857,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a30',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-9.3157,5.3114,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a31',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-6.2568,6.2568,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a32',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-8.5093,5.9649,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a33',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.0172,-9.0238,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a34',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-10.5393,-7.8558,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a35',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-12.2634,6.1734,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a36',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-9.6772,6.7991,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a37',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.3414,7.3275,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a38',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.075,7.244,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a39',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.5294,-9.4548,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a40',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.5594,-10.4559,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a41',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-11.9853,-7.3275,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a42',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-11.1511,7.2301,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a43',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-6.952,8.8291,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a44',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.768,8.0505,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a45',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.0,-9.6355,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a46',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-1.8353,-10.9564,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a47',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-5.0889,-10.6922,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a48',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-3.6151,-12.5554,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a49',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-13.1672,-8.3285,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a50',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.0505,9.9136,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a51',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-5.4643,9.2323,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a52',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.322,8.6205,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a53',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-4.4354,9.427,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a54',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.5294,-9.566,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a55',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.6611,11.4013,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a56',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-5.075,10.72,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a57',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.8203,8.9403,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a58',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.7808,10.0805,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a59',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.7241,-11.0955,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a60',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.045,-9.2462,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a61',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-6.1595,11.8046,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a62',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.7091,8.9959,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a63',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.7102,11.2067,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a64',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.5005,-12.027,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a65',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.4771,-8.6901,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a66',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(3.4899,-10.72,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a67',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.2386,8.8152,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a68',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(0.7647,10.5393,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a69',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.1551,12.6944,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a70',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(0.0278,12.027,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a71',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.6952,-13.5704,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a72',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.9038,-11.4292,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a73',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.7841,-7.8975,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a74',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.7263,8.3842,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a75',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.5584,10.3168,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a76',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.5145,-14.4881,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a77',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.1273,-12.3746,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a78',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.9659,-6.8825,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a79',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.6879,-9.1489,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a80',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1028,7.7029,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a81',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.0183,10.8035,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a82',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.9327,-13.9041,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a83',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(7.967,-5.7146,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a84',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(8.0644,-7.9809,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a85',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.0483,-10.5532,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a86',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(8.6066,-10.2473,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a87',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.3542,6.7991,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a88',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(5.8814,9.0377,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a89',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.3242,12.3051,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a90',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.7457,-4.3937,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a91',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(7.4665,5.7285,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a92',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(7.3414,7.9948,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a93',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.7841,12.8057,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a94',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.3018,-2.9616,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a95',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(10.1361,-5.0611,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a96',name='Sulphur',
          fieldValue=[
          fieldValue(name='position',value=(8.3564,4.4771,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a97',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.8708,7.7307,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a98',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(6.1039,14.3073,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a99',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(9.6077,-1.4321,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a100',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(10.7757,-3.3926,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a101',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(10.2334,-6.5905,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a102',name='Sulphur',
          fieldValue=[
          fieldValue(name='position',value=(9.0377,3.1006,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a103',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.858,8.8986,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a104',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(9.3992,6.2707,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a105',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.6772,0.0834,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a106',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.4826,1.6129,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a107',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(11.3735,8.6344,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a108',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.2067,0.1529,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a109',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(12.3746,9.8024,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a110',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(11.9158,1.5155,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a111',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(12.0409,-1.1262,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a112',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(13.8902,9.5382,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a113',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(11.8463,11.2484,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a114',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(14.8774,10.7061,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a115',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(14.4185,8.0922,0))])])]),
    Group(
      children=[
      ProtoInstance(DEF='b1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2078,-4.5188,0),(-10.7479,-4.0461,0)])]),
      ProtoInstance(DEF='b2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2278,-4.5188,0),(-12.2278,-6.0483,0)])]),
      ProtoInstance(DEF='b2_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.187800000000001,-4.5188,0),(-12.187800000000001,-6.0483,0)])]),
      ProtoInstance(DEF='b3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2078,-4.5188,0),(-13.5565,-3.7541,0)])]),
      ProtoInstance(DEF='b4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.7479,-4.0461,0),(-10.2751,-2.5862,0)])]),
      ProtoInstance(DEF='b5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.7679,-4.0461,0),(-9.864099999999999,-5.2836,0)])]),
      ProtoInstance(DEF='b5_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.7279,-4.0461,0),(-9.8241,-5.2836,0)])]),
      ProtoInstance(DEF='b6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2078,-6.0483,0),(-10.7479,-6.5349,0)])]),
      ProtoInstance(DEF='b7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2078,-6.0483,0),(-13.5565,-6.8269,0)])]),
      ProtoInstance(DEF='b8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-13.5765,-3.7541,0),(-14.8974,-4.5188,0)])]),
      ProtoInstance(DEF='b8_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-13.5365,-3.7541,0),(-14.8574,-4.5188,0)])]),
      ProtoInstance(DEF='b9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.2751,-2.5862,0),(-8.7735,-2.2525,0)])]),
      ProtoInstance(DEF='b10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-13.5765,-6.8269,0),(-14.8974,-6.0483,0)])]),
      ProtoInstance(DEF='b10_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-13.5365,-6.8269,0),(-14.8574,-6.0483,0)])]),
      ProtoInstance(DEF='b11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.7735,-2.2525,0),(-8.9681,-0.723,0)])]),
      ProtoInstance(DEF='b12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.7735,-2.2525,0),(-8.3285,-3.7263,0)])]),
      ProtoInstance(DEF='b13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.9681,-0.723,0),(-8.8986,0.8064,0)])]),
      ProtoInstance(DEF='b14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.3285,-3.7263,0),(-7.6472,-5.1167,0)])]),
      ProtoInstance(DEF='b15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.3485,-3.7263,0),(-9.7807,-4.2964,0)])]),
      ProtoInstance(DEF='b15_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.3085,-3.7263,0),(-9.7407,-4.2964,0)])]),
      ProtoInstance(DEF='b16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.8986,0.8064,0),(-8.5927,2.3081,0)])]),
      ProtoInstance(DEF='b17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.9186,0.8064,0),(-10.4481,0.9872,0)])]),
      ProtoInstance(DEF='b17_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.8786,0.8064,0),(-10.408100000000001,0.9872,0)])]),
      ProtoInstance(DEF='b18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.6472,-5.1167,0),(-6.7296,-6.3542,0)])]),
      ProtoInstance(DEF='b19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.5927,2.3081,0),(-10.0666,2.753,0)])]),
      ProtoInstance(DEF='b20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.5927,2.3081,0),(-8.0366,3.7541,0)])]),
      ProtoInstance(DEF='b21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.7296,-6.3542,0),(-5.6451,-7.4526,0)])]),
      ProtoInstance(DEF='b22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.7296,-6.3542,0),(-7.9253,-7.3692,0)])]),
      ProtoInstance(DEF='b23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.0666,2.753,0),(-10.4281,4.2546,0)])]),
      ProtoInstance(DEF='b24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.0366,3.7541,0),(-7.244,5.075,0)])]),
      ProtoInstance(DEF='b25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.6451,-7.4526,0),(-4.3937,-8.3425,0)])]),
      ProtoInstance(DEF='b26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.6651,-7.4526,0),(-6.6522,-8.6344,0)])]),
      ProtoInstance(DEF='b26_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.625100000000001,-7.4526,0),(-6.6122000000000005,-8.6344,0)])]),
      ProtoInstance(DEF='b27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.9253,-7.3692,0),(-9.3714,-6.8408,0)])]),
      ProtoInstance(DEF='b28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.4481,4.2546,0),(-11.921899999999999,4.6857,0)])]),
      ProtoInstance(DEF='b28_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.408100000000001,4.2546,0),(-11.8819,4.6857,0)])]),
      ProtoInstance(DEF='b29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.4281,4.2546,0),(-9.3157,5.3114,0)])]),
      ProtoInstance(DEF='b30',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.244,5.075,0),(-6.2568,6.2568,0)])]),
      ProtoInstance(DEF='b31',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.263999999999999,5.075,0),(-8.5293,5.9649,0)])]),
      ProtoInstance(DEF='b31_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.224,5.075,0),(-8.4893,5.9649,0)])]),
      ProtoInstance(DEF='b32',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.3937,-8.3425,0),(-3.0172,-9.0238,0)])]),
      ProtoInstance(DEF='b33',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.3714,-6.8408,0),(-10.5393,-7.8558,0)])]),
      ProtoInstance(DEF='b34',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-11.9019,4.6857,0),(-12.2634,6.1734,0)])]),
      ProtoInstance(DEF='b35',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.3357,5.3114,0),(-9.697199999999999,6.7991,0)])]),
      ProtoInstance(DEF='b35_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.2957,5.3114,0),(-9.6572,6.7991,0)])]),
      ProtoInstance(DEF='b36',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.2568,6.2568,0),(-7.3414,7.3275,0)])]),
      ProtoInstance(DEF='b37',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.2568,6.2568,0),(-5.075,7.244,0)])]),
      ProtoInstance(DEF='b38',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.0172,-9.0238,0),(-1.5294,-9.4548,0)])]),
      ProtoInstance(DEF='b39',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.0172,-9.0238,0),(-3.5594,-10.4559,0)])]),
      ProtoInstance(DEF='b40',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-10.5393,-7.8558,0),(-11.9853,-7.3275,0)])]),
      ProtoInstance(DEF='b41',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.2834,6.1734,0),(-11.1711,7.2301,0)])]),
      ProtoInstance(DEF='b41_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.243400000000001,6.1734,0),(-11.1311,7.2301,0)])]),
      ProtoInstance(DEF='b42',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.3414,7.3275,0),(-6.952,8.8291,0)])]),
      ProtoInstance(DEF='b43',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.075,7.244,0),(-3.768,8.0505,0)])]),
      ProtoInstance(DEF='b44',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.5294,-9.4548,0),(0.0,-9.6355,0)])]),
      ProtoInstance(DEF='b45',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.5494,-9.4548,0),(-1.8553,-10.9564,0)])]),
      ProtoInstance(DEF='b45_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.5094,-9.4548,0),(-1.8153,-10.9564,0)])]),
      ProtoInstance(DEF='b46',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.5594,-10.4559,0),(-5.0889,-10.6922,0)])]),
      ProtoInstance(DEF='b47',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.5594,-10.4559,0),(-3.6151,-12.5554,0)])]),
      ProtoInstance(DEF='b48',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-11.9853,-7.3275,0),(-13.1672,-8.3285,0)])]),
      ProtoInstance(DEF='b49',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.9719999999999995,8.8291,0),(-8.0705,9.9136,0)])]),
      ProtoInstance(DEF='b49_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.932,8.8291,0),(-8.0305,9.9136,0)])]),
      ProtoInstance(DEF='b50',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.952,8.8291,0),(-5.4643,9.2323,0)])]),
      ProtoInstance(DEF='b51',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.768,8.0505,0),(-2.322,8.6205,0)])]),
      ProtoInstance(DEF='b52',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.788,8.0505,0),(-4.455399999999999,9.427,0)])]),
      ProtoInstance(DEF='b52_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.7479999999999998,8.0505,0),(-4.4154,9.427,0)])]),
      ProtoInstance(DEF='b53',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.0,-9.6355,0),(1.5294,-9.566,0)])]),
      ProtoInstance(DEF='b54',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.0505,9.9136,0),(-7.6611,11.4013,0)])]),
      ProtoInstance(DEF='b55',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.484299999999999,9.2323,0),(-5.095,10.72,0)])]),
      ProtoInstance(DEF='b55_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.4443,9.2323,0),(-5.055000000000001,10.72,0)])]),
      ProtoInstance(DEF='b56',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.322,8.6205,0),(-0.8203,8.9403,0)])]),
      ProtoInstance(DEF='b57',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.322,8.6205,0),(-2.7808,10.0805,0)])]),
      ProtoInstance(DEF='b58',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5294,-9.566,0),(1.7241,-11.0955,0)])]),
      ProtoInstance(DEF='b59',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5294,-9.566,0),(3.045,-9.2462,0)])]),
      ProtoInstance(DEF='b60',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.6811,11.4013,0),(-6.1795,11.8046,0)])]),
      ProtoInstance(DEF='b60_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.641100000000001,11.4013,0),(-6.139500000000001,11.8046,0)])]),
      ProtoInstance(DEF='b61',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.8203,8.9403,0),(0.7091,8.9959,0)])]),
      ProtoInstance(DEF='b62',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.7808,10.0805,0),(-1.7102,11.2067,0)])]),
      ProtoInstance(DEF='b63',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.7241,-11.0955,0),(0.5005,-12.027,0)])]),
      ProtoInstance(DEF='b64',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.045,-9.2462,0),(4.4771,-8.6901,0)])]),
      ProtoInstance(DEF='b65',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.025,-9.2462,0),(3.4699,-10.72,0)])]),
      ProtoInstance(DEF='b65_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.065,-9.2462,0),(3.5099,-10.72,0)])]),
      ProtoInstance(DEF='b66',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7091,8.9959,0),(2.2386,8.8152,0)])]),
      ProtoInstance(DEF='b67',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.6890999999999999,8.9959,0),(0.7447,10.5393,0)])]),
      ProtoInstance(DEF='b67_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7291,8.9959,0),(0.7847000000000001,10.5393,0)])]),
      ProtoInstance(DEF='b68',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.7102,11.2067,0),(-2.1551,12.6944,0)])]),
      ProtoInstance(DEF='b69',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.7302,11.2067,0),(0.007799999999999998,12.027,0)])]),
      ProtoInstance(DEF='b69_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.6902,11.2067,0),(0.047799999999999995,12.027,0)])]),
      ProtoInstance(DEF='b70',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.4804999999999999,-12.027,0),(0.6752,-13.5704,0)])]),
      ProtoInstance(DEF='b70_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.5205,-12.027,0),(0.7152000000000001,-13.5704,0)])]),
      ProtoInstance(DEF='b71',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.5005,-12.027,0),(-0.9038,-11.4292,0)])]),
      ProtoInstance(DEF='b72',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.4771,-8.6901,0),(5.7841,-7.8975,0)])]),
      ProtoInstance(DEF='b73',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.2386,8.8152,0),(3.7263,8.3842,0)])]),
      ProtoInstance(DEF='b74',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.2386,8.8152,0),(2.5584,10.3168,0)])]),
      ProtoInstance(DEF='b75',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.6952,-13.5704,0),(-0.5145,-14.4881,0)])]),
      ProtoInstance(DEF='b76',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.9238000000000001,-11.4292,0),(-2.1473,-12.3746,0)])]),
      ProtoInstance(DEF='b76_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.8838,-11.4292,0),(-2.1073,-12.3746,0)])]),
      ProtoInstance(DEF='b77',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.7841,-7.8975,0),(6.9659,-6.8825,0)])]),
      ProtoInstance(DEF='b78',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.7841,-7.8975,0),(6.6879,-9.1489,0)])]),
      ProtoInstance(DEF='b79',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.7263,8.3842,0),(5.1028,7.7029,0)])]),
      ProtoInstance(DEF='b80',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5584,10.3168,0),(4.0183,10.8035,0)])]),
      ProtoInstance(DEF='b81',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.5345,-14.4881,0),(-1.9527,-13.9041,0)])]),
      ProtoInstance(DEF='b81_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.49449999999999994,-14.4881,0),(-1.9127,-13.9041,0)])]),
      ProtoInstance(DEF='b82',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.9659,-6.8825,0),(7.967,-5.7146,0)])]),
      ProtoInstance(DEF='b83',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.945900000000001,-6.8825,0),(8.0444,-7.9809,0)])]),
      ProtoInstance(DEF='b83_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.9859,-6.8825,0),(8.084399999999999,-7.9809,0)])]),
      ProtoInstance(DEF='b84',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.6879,-9.1489,0),(6.0483,-10.5532,0)])]),
      ProtoInstance(DEF='b85',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.6879,-9.1489,0),(8.6066,-10.2473,0)])]),
      ProtoInstance(DEF='b86',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1028,7.7029,0),(6.3542,6.7991,0)])]),
      ProtoInstance(DEF='b87',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.082800000000001,7.7029,0),(5.861400000000001,9.0377,0)])]),
      ProtoInstance(DEF='b87_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1228,7.7029,0),(5.9014,9.0377,0)])]),
      ProtoInstance(DEF='b88',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.0183,10.8035,0),(4.3242,12.3051,0)])]),
      ProtoInstance(DEF='b89',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.967,-5.7146,0),(8.7457,-4.3937,0)])]),
      ProtoInstance(DEF='b90',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.3542,6.7991,0),(7.4665,5.7285,0)])]),
      ProtoInstance(DEF='b91',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.3542,6.7991,0),(7.3414,7.9948,0)])]),
      ProtoInstance(DEF='b92',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.3242,12.3051,0),(5.7841,12.8057,0)])]),
      ProtoInstance(DEF='b93',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.7457,-4.3937,0),(9.3018,-2.9616,0)])]),
      ProtoInstance(DEF='b94',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.7457,-4.3937,0),(10.1361,-5.0611,0)])]),
      ProtoInstance(DEF='b95',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.4665,5.7285,0),(8.3564,4.4771,0)])]),
      ProtoInstance(DEF='b96',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.3414,7.9948,0),(8.8708,7.7307,0)])]),
      ProtoInstance(DEF='b97',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.7841,12.8057,0),(6.1039,14.3073,0)])]),
      ProtoInstance(DEF='b98',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.3018,-2.9616,0),(9.6077,-1.4321,0)])]),
      ProtoInstance(DEF='b99',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2818,-2.9616,0),(10.755700000000001,-3.3926,0)])]),
      ProtoInstance(DEF='b99_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.3218,-2.9616,0),(10.7957,-3.3926,0)])]),
      ProtoInstance(DEF='b100',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.1361,-5.0611,0),(10.2334,-6.5905,0)])]),
      ProtoInstance(DEF='b101',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.3564,4.4771,0),(9.0377,3.1006,0)])]),
      ProtoInstance(DEF='b102',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.8708,7.7307,0),(9.858,8.8986,0)])]),
      ProtoInstance(DEF='b103',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.8508,7.7307,0),(9.3792,6.2707,0)])]),
      ProtoInstance(DEF='b103_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.890799999999999,7.7307,0),(9.4192,6.2707,0)])]),
      ProtoInstance(DEF='b104',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.6077,-1.4321,0),(9.6772,0.0834,0)])]),
      ProtoInstance(DEF='b105',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.0377,3.1006,0),(9.4826,1.6129,0)])]),
      ProtoInstance(DEF='b106',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.858,8.8986,0),(11.3735,8.6344,0)])]),
      ProtoInstance(DEF='b107',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.6772,0.0834,0),(11.2067,0.1529,0)])]),
      ProtoInstance(DEF='b108',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.3735,8.6344,0),(12.3746,9.8024,0)])]),
      ProtoInstance(DEF='b109',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.2067,0.1529,0),(11.9158,1.5155,0)])]),
      ProtoInstance(DEF='b110',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.1867,0.1529,0),(12.020900000000001,-1.1262,0)])]),
      ProtoInstance(DEF='b110_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.2267,0.1529,0),(12.0609,-1.1262,0)])]),
      ProtoInstance(DEF='b111',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(12.3746,9.8024,0),(13.8902,9.5382,0)])]),
      ProtoInstance(DEF='b112',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(12.3546,9.8024,0),(11.8263,11.2484,0)])]),
      ProtoInstance(DEF='b112_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(12.394599999999999,9.8024,0),(11.866299999999999,11.2484,0)])]),
      ProtoInstance(DEF='b113',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(13.8902,9.5382,0),(14.8774,10.7061,0)])]),
      ProtoInstance(DEF='b114',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(13.8902,9.5382,0),(14.4185,8.0922,0)])]),
      ProtoInstance(DEF='b115',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.8441,-5.2836,0),(-10.7479,-6.5349,0)])]),
      ProtoInstance(DEF='b116',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-14.8774,-4.5188,0),(-14.8774,-6.0483,0)])]),
      ProtoInstance(DEF='b117',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.6772,6.7991,0),(-11.1511,7.2301,0)])]),
      ProtoInstance(DEF='b118',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.075,10.72,0),(-6.1595,11.8046,0)])]),
      ProtoInstance(DEF='b119',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1273,-12.3746,0),(-1.9327,-13.9041,0)])]),
      ProtoInstance(DEF='b120',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.6772,0.0834,0),(9.4826,1.6129,0)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SomatoStatin.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SomatoStatin.py load and self-test diagnostics complete.")
