package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of SomatoStatin.x3d scene produced from SomatoStatin.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/SomatoStatinIndex.html" target="_blank">SomatoStatin</a>,  source <a href="../../../ChemicalMarkupLanguage/SomatoStatin.java">SomatoStatin.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/SomatoStatin.x3d">SomatoStatin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of SomatoStatin.x3d scene produced from SomatoStatin.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/SomatoStatin.xml">SomatoStatin.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/SomatoStatin.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/SomatoStatin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class SomatoStatin
{
	/** Default constructor to create this object. */
	public SomatoStatin ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SomatoStatin.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of SomatoStatin.x3d scene produced from SomatoStatin.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("SomatoStatin.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/SomatoStatin.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect SomatoStatin").setPosition(0.0,2.0,20.0))
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"SomatoStatin: "})))))
    .addComments(" <date day=\"23\" month=\"11\" year=\"1995\"></date> ")
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-12.2078,-4.5188,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.7479,-4.0461,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-12.2078,-6.0483,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-13.5565,-3.7541,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.2751,-2.5862,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a6").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.8441,-5.2836,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a7").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.7479,-6.5349,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a8").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-13.5565,-6.8269,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a9").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-14.8774,-4.5188,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a10").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.7735,-2.2525,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a11").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-14.8774,-6.0483,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a12").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.9681,-0.723,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a13").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.3285,-3.7263,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a14").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.8986,0.8064,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a15").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.6472,-5.1167,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a16").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.7607,-4.2964,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a17").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.5927,2.3081,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a18").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.4281,0.9872,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a19").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.7296,-6.3542,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a20").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.0666,2.753,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a21").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.0366,3.7541,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a22").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.6451,-7.4526,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a23").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.9253,-7.3692,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a24").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.4281,4.2546,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a25").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.244,5.075,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a26").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.3937,-8.3425,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a27").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.6322,-8.6344,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a28").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.3714,-6.8408,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a29").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-11.9019,4.6857,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a30").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.3157,5.3114,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a31").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.2568,6.2568,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a32").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.5093,5.9649,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a33").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.0172,-9.0238,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a34").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-10.5393,-7.8558,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a35").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-12.2634,6.1734,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a36").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.6772,6.7991,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a37").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.3414,7.3275,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a38").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.075,7.244,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a39").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.5294,-9.4548,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a40").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.5594,-10.4559,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a41").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-11.9853,-7.3275,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a42").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-11.1511,7.2301,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a43").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.952,8.8291,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a44").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.768,8.0505,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a45").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0,-9.6355,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a46").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.8353,-10.9564,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a47").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.0889,-10.6922,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a48").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.6151,-12.5554,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a49").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-13.1672,-8.3285,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a50").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.0505,9.9136,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a51").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.4643,9.2323,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a52").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.322,8.6205,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a53").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.4354,9.427,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a54").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.5294,-9.566,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a55").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.6611,11.4013,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a56").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.075,10.72,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a57").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.8203,8.9403,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a58").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.7808,10.0805,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a59").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.7241,-11.0955,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a60").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.045,-9.2462,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a61").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.1595,11.8046,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a62").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7091,8.9959,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a63").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.7102,11.2067,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a64").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.5005,-12.027,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a65").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.4771,-8.6901,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a66").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.4899,-10.72,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a67").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2386,8.8152,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a68").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7647,10.5393,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a69").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1551,12.6944,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a70").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0278,12.027,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a71").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.6952,-13.5704,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a72").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.9038,-11.4292,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a73").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.7841,-7.8975,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a74").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.7263,8.3842,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a75").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.5584,10.3168,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a76").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.5145,-14.4881,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a77").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1273,-12.3746,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a78").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.9659,-6.8825,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a79").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.6879,-9.1489,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a80").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.1028,7.7029,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a81").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.0183,10.8035,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a82").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.9327,-13.9041,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a83").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.967,-5.7146,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a84").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.0644,-7.9809,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a85").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.0483,-10.5532,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a86").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.6066,-10.2473,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a87").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.3542,6.7991,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a88").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.8814,9.0377,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a89").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.3242,12.3051,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a90").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.7457,-4.3937,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a91").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.4665,5.7285,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a92").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.3414,7.9948,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a93").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.7841,12.8057,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a94").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.3018,-2.9616,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a95").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.1361,-5.0611,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Sulphur", "a96").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.3564,4.4771,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a97").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.8708,7.7307,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a98").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.1039,14.3073,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a99").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.6077,-1.4321,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a100").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.7757,-3.3926,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a101").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.2334,-6.5905,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Sulphur", "a102").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.0377,3.1006,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a103").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.858,8.8986,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a104").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.3992,6.2707,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a105").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.6772,0.0834,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a106").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.4826,1.6129,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a107").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.3735,8.6344,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a108").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.2067,0.1529,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a109").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(12.3746,9.8024,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a110").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.9158,1.5155,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a111").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(12.0409,-1.1262,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a112").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(13.8902,9.5382,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a113").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.8463,11.2484,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a114").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(14.8774,10.7061,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a115").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(14.4185,8.0922,0.0))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "b1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2078,-4.5188,0.0,-10.7479,-4.0461,0.0})))))
      .addChild(new ProtoInstance("line", "b2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2278,-4.5188,0.0,-12.2278,-6.0483,0.0})))))
      .addChild(new ProtoInstance("line", "b2_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.187800000000001,-4.5188,0.0,-12.187800000000001,-6.0483,0.0})))))
      .addChild(new ProtoInstance("line", "b3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2078,-4.5188,0.0,-13.5565,-3.7541,0.0})))))
      .addChild(new ProtoInstance("line", "b4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.7479,-4.0461,0.0,-10.2751,-2.5862,0.0})))))
      .addChild(new ProtoInstance("line", "b5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.7679,-4.0461,0.0,-9.864099999999999,-5.2836,0.0})))))
      .addChild(new ProtoInstance("line", "b5_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.7279,-4.0461,0.0,-9.8241,-5.2836,0.0})))))
      .addChild(new ProtoInstance("line", "b6").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2078,-6.0483,0.0,-10.7479,-6.5349,0.0})))))
      .addChild(new ProtoInstance("line", "b7").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2078,-6.0483,0.0,-13.5565,-6.8269,0.0})))))
      .addChild(new ProtoInstance("line", "b8").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-13.5765,-3.7541,0.0,-14.8974,-4.5188,0.0})))))
      .addChild(new ProtoInstance("line", "b8_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-13.5365,-3.7541,0.0,-14.8574,-4.5188,0.0})))))
      .addChild(new ProtoInstance("line", "b9").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.2751,-2.5862,0.0,-8.7735,-2.2525,0.0})))))
      .addChild(new ProtoInstance("line", "b10").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-13.5765,-6.8269,0.0,-14.8974,-6.0483,0.0})))))
      .addChild(new ProtoInstance("line", "b10_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-13.5365,-6.8269,0.0,-14.8574,-6.0483,0.0})))))
      .addChild(new ProtoInstance("line", "b11").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.7735,-2.2525,0.0,-8.9681,-0.723,0.0})))))
      .addChild(new ProtoInstance("line", "b12").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.7735,-2.2525,0.0,-8.3285,-3.7263,0.0})))))
      .addChild(new ProtoInstance("line", "b13").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.9681,-0.723,0.0,-8.8986,0.8064,0.0})))))
      .addChild(new ProtoInstance("line", "b14").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.3285,-3.7263,0.0,-7.6472,-5.1167,0.0})))))
      .addChild(new ProtoInstance("line", "b15").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.3485,-3.7263,0.0,-9.7807,-4.2964,0.0})))))
      .addChild(new ProtoInstance("line", "b15_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.3085,-3.7263,0.0,-9.7407,-4.2964,0.0})))))
      .addChild(new ProtoInstance("line", "b16").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.8986,0.8064,0.0,-8.5927,2.3081,0.0})))))
      .addChild(new ProtoInstance("line", "b17").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.9186,0.8064,0.0,-10.4481,0.9872,0.0})))))
      .addChild(new ProtoInstance("line", "b17_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.8786,0.8064,0.0,-10.408100000000001,0.9872,0.0})))))
      .addChild(new ProtoInstance("line", "b18").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.6472,-5.1167,0.0,-6.7296,-6.3542,0.0})))))
      .addChild(new ProtoInstance("line", "b19").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.5927,2.3081,0.0,-10.0666,2.753,0.0})))))
      .addChild(new ProtoInstance("line", "b20").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.5927,2.3081,0.0,-8.0366,3.7541,0.0})))))
      .addChild(new ProtoInstance("line", "b21").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.7296,-6.3542,0.0,-5.6451,-7.4526,0.0})))))
      .addChild(new ProtoInstance("line", "b22").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.7296,-6.3542,0.0,-7.9253,-7.3692,0.0})))))
      .addChild(new ProtoInstance("line", "b23").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.0666,2.753,0.0,-10.4281,4.2546,0.0})))))
      .addChild(new ProtoInstance("line", "b24").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.0366,3.7541,0.0,-7.244,5.075,0.0})))))
      .addChild(new ProtoInstance("line", "b25").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.6451,-7.4526,0.0,-4.3937,-8.3425,0.0})))))
      .addChild(new ProtoInstance("line", "b26").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.6651,-7.4526,0.0,-6.6522,-8.6344,0.0})))))
      .addChild(new ProtoInstance("line", "b26_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.625100000000001,-7.4526,0.0,-6.6122000000000005,-8.6344,0.0})))))
      .addChild(new ProtoInstance("line", "b27").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.9253,-7.3692,0.0,-9.3714,-6.8408,0.0})))))
      .addChild(new ProtoInstance("line", "b28").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.4481,4.2546,0.0,-11.921899999999999,4.6857,0.0})))))
      .addChild(new ProtoInstance("line", "b28_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.408100000000001,4.2546,0.0,-11.8819,4.6857,0.0})))))
      .addChild(new ProtoInstance("line", "b29").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.4281,4.2546,0.0,-9.3157,5.3114,0.0})))))
      .addChild(new ProtoInstance("line", "b30").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.244,5.075,0.0,-6.2568,6.2568,0.0})))))
      .addChild(new ProtoInstance("line", "b31").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.263999999999999,5.075,0.0,-8.5293,5.9649,0.0})))))
      .addChild(new ProtoInstance("line", "b31_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.224,5.075,0.0,-8.4893,5.9649,0.0})))))
      .addChild(new ProtoInstance("line", "b32").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.3937,-8.3425,0.0,-3.0172,-9.0238,0.0})))))
      .addChild(new ProtoInstance("line", "b33").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.3714,-6.8408,0.0,-10.5393,-7.8558,0.0})))))
      .addChild(new ProtoInstance("line", "b34").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-11.9019,4.6857,0.0,-12.2634,6.1734,0.0})))))
      .addChild(new ProtoInstance("line", "b35").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.3357,5.3114,0.0,-9.697199999999999,6.7991,0.0})))))
      .addChild(new ProtoInstance("line", "b35_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.2957,5.3114,0.0,-9.6572,6.7991,0.0})))))
      .addChild(new ProtoInstance("line", "b36").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.2568,6.2568,0.0,-7.3414,7.3275,0.0})))))
      .addChild(new ProtoInstance("line", "b37").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.2568,6.2568,0.0,-5.075,7.244,0.0})))))
      .addChild(new ProtoInstance("line", "b38").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.0172,-9.0238,0.0,-1.5294,-9.4548,0.0})))))
      .addChild(new ProtoInstance("line", "b39").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.0172,-9.0238,0.0,-3.5594,-10.4559,0.0})))))
      .addChild(new ProtoInstance("line", "b40").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-10.5393,-7.8558,0.0,-11.9853,-7.3275,0.0})))))
      .addChild(new ProtoInstance("line", "b41").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.2834,6.1734,0.0,-11.1711,7.2301,0.0})))))
      .addChild(new ProtoInstance("line", "b41_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.243400000000001,6.1734,0.0,-11.1311,7.2301,0.0})))))
      .addChild(new ProtoInstance("line", "b42").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.3414,7.3275,0.0,-6.952,8.8291,0.0})))))
      .addChild(new ProtoInstance("line", "b43").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.075,7.244,0.0,-3.768,8.0505,0.0})))))
      .addChild(new ProtoInstance("line", "b44").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.5294,-9.4548,0.0,0.0,-9.6355,0.0})))))
      .addChild(new ProtoInstance("line", "b45").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.5494,-9.4548,0.0,-1.8553,-10.9564,0.0})))))
      .addChild(new ProtoInstance("line", "b45_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.5094,-9.4548,0.0,-1.8153,-10.9564,0.0})))))
      .addChild(new ProtoInstance("line", "b46").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.5594,-10.4559,0.0,-5.0889,-10.6922,0.0})))))
      .addChild(new ProtoInstance("line", "b47").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.5594,-10.4559,0.0,-3.6151,-12.5554,0.0})))))
      .addChild(new ProtoInstance("line", "b48").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-11.9853,-7.3275,0.0,-13.1672,-8.3285,0.0})))))
      .addChild(new ProtoInstance("line", "b49").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.9719999999999995,8.8291,0.0,-8.0705,9.9136,0.0})))))
      .addChild(new ProtoInstance("line", "b49_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.932,8.8291,0.0,-8.0305,9.9136,0.0})))))
      .addChild(new ProtoInstance("line", "b50").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.952,8.8291,0.0,-5.4643,9.2323,0.0})))))
      .addChild(new ProtoInstance("line", "b51").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.768,8.0505,0.0,-2.322,8.6205,0.0})))))
      .addChild(new ProtoInstance("line", "b52").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.788,8.0505,0.0,-4.455399999999999,9.427,0.0})))))
      .addChild(new ProtoInstance("line", "b52_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.7479999999999998,8.0505,0.0,-4.4154,9.427,0.0})))))
      .addChild(new ProtoInstance("line", "b53").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.0,-9.6355,0.0,1.5294,-9.566,0.0})))))
      .addChild(new ProtoInstance("line", "b54").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.0505,9.9136,0.0,-7.6611,11.4013,0.0})))))
      .addChild(new ProtoInstance("line", "b55").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.484299999999999,9.2323,0.0,-5.095,10.72,0.0})))))
      .addChild(new ProtoInstance("line", "b55_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.4443,9.2323,0.0,-5.055000000000001,10.72,0.0})))))
      .addChild(new ProtoInstance("line", "b56").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.322,8.6205,0.0,-0.8203,8.9403,0.0})))))
      .addChild(new ProtoInstance("line", "b57").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.322,8.6205,0.0,-2.7808,10.0805,0.0})))))
      .addChild(new ProtoInstance("line", "b58").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5294,-9.566,0.0,1.7241,-11.0955,0.0})))))
      .addChild(new ProtoInstance("line", "b59").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5294,-9.566,0.0,3.045,-9.2462,0.0})))))
      .addChild(new ProtoInstance("line", "b60").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.6811,11.4013,0.0,-6.1795,11.8046,0.0})))))
      .addChild(new ProtoInstance("line", "b60_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.641100000000001,11.4013,0.0,-6.139500000000001,11.8046,0.0})))))
      .addChild(new ProtoInstance("line", "b61").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.8203,8.9403,0.0,0.7091,8.9959,0.0})))))
      .addChild(new ProtoInstance("line", "b62").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.7808,10.0805,0.0,-1.7102,11.2067,0.0})))))
      .addChild(new ProtoInstance("line", "b63").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.7241,-11.0955,0.0,0.5005,-12.027,0.0})))))
      .addChild(new ProtoInstance("line", "b64").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.045,-9.2462,0.0,4.4771,-8.6901,0.0})))))
      .addChild(new ProtoInstance("line", "b65").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.025,-9.2462,0.0,3.4699,-10.72,0.0})))))
      .addChild(new ProtoInstance("line", "b65_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.065,-9.2462,0.0,3.5099,-10.72,0.0})))))
      .addChild(new ProtoInstance("line", "b66").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7091,8.9959,0.0,2.2386,8.8152,0.0})))))
      .addChild(new ProtoInstance("line", "b67").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.6890999999999999,8.9959,0.0,0.7447,10.5393,0.0})))))
      .addChild(new ProtoInstance("line", "b67_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7291,8.9959,0.0,0.7847000000000001,10.5393,0.0})))))
      .addChild(new ProtoInstance("line", "b68").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.7102,11.2067,0.0,-2.1551,12.6944,0.0})))))
      .addChild(new ProtoInstance("line", "b69").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.7302,11.2067,0.0,0.007799999999999998,12.027,0.0})))))
      .addChild(new ProtoInstance("line", "b69_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.6902,11.2067,0.0,0.047799999999999995,12.027,0.0})))))
      .addChild(new ProtoInstance("line", "b70").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.4804999999999999,-12.027,0.0,0.6752,-13.5704,0.0})))))
      .addChild(new ProtoInstance("line", "b70_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.5205,-12.027,0.0,0.7152000000000001,-13.5704,0.0})))))
      .addChild(new ProtoInstance("line", "b71").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.5005,-12.027,0.0,-0.9038,-11.4292,0.0})))))
      .addChild(new ProtoInstance("line", "b72").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.4771,-8.6901,0.0,5.7841,-7.8975,0.0})))))
      .addChild(new ProtoInstance("line", "b73").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.2386,8.8152,0.0,3.7263,8.3842,0.0})))))
      .addChild(new ProtoInstance("line", "b74").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.2386,8.8152,0.0,2.5584,10.3168,0.0})))))
      .addChild(new ProtoInstance("line", "b75").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.6952,-13.5704,0.0,-0.5145,-14.4881,0.0})))))
      .addChild(new ProtoInstance("line", "b76").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.9238000000000001,-11.4292,0.0,-2.1473,-12.3746,0.0})))))
      .addChild(new ProtoInstance("line", "b76_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.8838,-11.4292,0.0,-2.1073,-12.3746,0.0})))))
      .addChild(new ProtoInstance("line", "b77").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.7841,-7.8975,0.0,6.9659,-6.8825,0.0})))))
      .addChild(new ProtoInstance("line", "b78").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.7841,-7.8975,0.0,6.6879,-9.1489,0.0})))))
      .addChild(new ProtoInstance("line", "b79").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.7263,8.3842,0.0,5.1028,7.7029,0.0})))))
      .addChild(new ProtoInstance("line", "b80").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.5584,10.3168,0.0,4.0183,10.8035,0.0})))))
      .addChild(new ProtoInstance("line", "b81").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.5345,-14.4881,0.0,-1.9527,-13.9041,0.0})))))
      .addChild(new ProtoInstance("line", "b81_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.49449999999999994,-14.4881,0.0,-1.9127,-13.9041,0.0})))))
      .addChild(new ProtoInstance("line", "b82").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.9659,-6.8825,0.0,7.967,-5.7146,0.0})))))
      .addChild(new ProtoInstance("line", "b83").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.945900000000001,-6.8825,0.0,8.0444,-7.9809,0.0})))))
      .addChild(new ProtoInstance("line", "b83_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.9859,-6.8825,0.0,8.084399999999999,-7.9809,0.0})))))
      .addChild(new ProtoInstance("line", "b84").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.6879,-9.1489,0.0,6.0483,-10.5532,0.0})))))
      .addChild(new ProtoInstance("line", "b85").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.6879,-9.1489,0.0,8.6066,-10.2473,0.0})))))
      .addChild(new ProtoInstance("line", "b86").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1028,7.7029,0.0,6.3542,6.7991,0.0})))))
      .addChild(new ProtoInstance("line", "b87").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.082800000000001,7.7029,0.0,5.861400000000001,9.0377,0.0})))))
      .addChild(new ProtoInstance("line", "b87_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1228,7.7029,0.0,5.9014,9.0377,0.0})))))
      .addChild(new ProtoInstance("line", "b88").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.0183,10.8035,0.0,4.3242,12.3051,0.0})))))
      .addChild(new ProtoInstance("line", "b89").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.967,-5.7146,0.0,8.7457,-4.3937,0.0})))))
      .addChild(new ProtoInstance("line", "b90").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.3542,6.7991,0.0,7.4665,5.7285,0.0})))))
      .addChild(new ProtoInstance("line", "b91").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.3542,6.7991,0.0,7.3414,7.9948,0.0})))))
      .addChild(new ProtoInstance("line", "b92").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.3242,12.3051,0.0,5.7841,12.8057,0.0})))))
      .addChild(new ProtoInstance("line", "b93").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.7457,-4.3937,0.0,9.3018,-2.9616,0.0})))))
      .addChild(new ProtoInstance("line", "b94").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.7457,-4.3937,0.0,10.1361,-5.0611,0.0})))))
      .addChild(new ProtoInstance("line", "b95").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.4665,5.7285,0.0,8.3564,4.4771,0.0})))))
      .addChild(new ProtoInstance("line", "b96").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.3414,7.9948,0.0,8.8708,7.7307,0.0})))))
      .addChild(new ProtoInstance("line", "b97").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.7841,12.8057,0.0,6.1039,14.3073,0.0})))))
      .addChild(new ProtoInstance("line", "b98").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.3018,-2.9616,0.0,9.6077,-1.4321,0.0})))))
      .addChild(new ProtoInstance("line", "b99").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2818,-2.9616,0.0,10.755700000000001,-3.3926,0.0})))))
      .addChild(new ProtoInstance("line", "b99_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.3218,-2.9616,0.0,10.7957,-3.3926,0.0})))))
      .addChild(new ProtoInstance("line", "b100").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.1361,-5.0611,0.0,10.2334,-6.5905,0.0})))))
      .addChild(new ProtoInstance("line", "b101").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.3564,4.4771,0.0,9.0377,3.1006,0.0})))))
      .addChild(new ProtoInstance("line", "b102").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.8708,7.7307,0.0,9.858,8.8986,0.0})))))
      .addChild(new ProtoInstance("line", "b103").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.8508,7.7307,0.0,9.3792,6.2707,0.0})))))
      .addChild(new ProtoInstance("line", "b103_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.890799999999999,7.7307,0.0,9.4192,6.2707,0.0})))))
      .addChild(new ProtoInstance("line", "b104").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.6077,-1.4321,0.0,9.6772,0.0834,0.0})))))
      .addChild(new ProtoInstance("line", "b105").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.0377,3.1006,0.0,9.4826,1.6129,0.0})))))
      .addChild(new ProtoInstance("line", "b106").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.858,8.8986,0.0,11.3735,8.6344,0.0})))))
      .addChild(new ProtoInstance("line", "b107").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.6772,0.0834,0.0,11.2067,0.1529,0.0})))))
      .addChild(new ProtoInstance("line", "b108").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.3735,8.6344,0.0,12.3746,9.8024,0.0})))))
      .addChild(new ProtoInstance("line", "b109").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.2067,0.1529,0.0,11.9158,1.5155,0.0})))))
      .addChild(new ProtoInstance("line", "b110").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.1867,0.1529,0.0,12.020900000000001,-1.1262,0.0})))))
      .addChild(new ProtoInstance("line", "b110_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.2267,0.1529,0.0,12.0609,-1.1262,0.0})))))
      .addChild(new ProtoInstance("line", "b111").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {12.3746,9.8024,0.0,13.8902,9.5382,0.0})))))
      .addChild(new ProtoInstance("line", "b112").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {12.3546,9.8024,0.0,11.8263,11.2484,0.0})))))
      .addChild(new ProtoInstance("line", "b112_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {12.394599999999999,9.8024,0.0,11.866299999999999,11.2484,0.0})))))
      .addChild(new ProtoInstance("line", "b113").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {13.8902,9.5382,0.0,14.8774,10.7061,0.0})))))
      .addChild(new ProtoInstance("line", "b114").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {13.8902,9.5382,0.0,14.4185,8.0922,0.0})))))
      .addChild(new ProtoInstance("line", "b115").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.8441,-5.2836,0.0,-10.7479,-6.5349,0.0})))))
      .addChild(new ProtoInstance("line", "b116").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-14.8774,-4.5188,0.0,-14.8774,-6.0483,0.0})))))
      .addChild(new ProtoInstance("line", "b117").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.6772,6.7991,0.0,-11.1511,7.2301,0.0})))))
      .addChild(new ProtoInstance("line", "b118").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.075,10.72,0.0,-6.1595,11.8046,0.0})))))
      .addChild(new ProtoInstance("line", "b119").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1273,-12.3746,0.0,-1.9327,-13.9041,0.0})))))
      .addChild(new ProtoInstance("line", "b120").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.6772,0.0834,0.0,9.4826,1.6129,0.0})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SomatoStatin model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SomatoStatin().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.SomatoStatin\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.SomatoStatin self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/SomatoStatin_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/SomatoStatin_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/SomatoStatin_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/SomatoStatin_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
