####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Riboflavin.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='Riboflavin.x3d',name='title'),
    meta(content='Autogenerated version of Riboflavin.x3d scene produced from Riboflavin.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='Riboflavin.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Riboflavin.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect Riboflavin',position=(0,2,20)),
    #  CML document - riboflavin - karne - 7/8/00 
    #  file converted from: MDL .mol 
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["Riboflavin: "])])])]),
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_1',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-4.7200,-3.7880,-0.2120))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-4.4360,-0.8480,0.2560))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_3',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(4.9120,-2.6120,1.4440))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.5200,4.6120,-0.4160))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.8760,3.1200,-0.5360))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.1720,2.2240,0.5160))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_7',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.2280,0.7120,0.1880))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_8',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.7320,-0.1640,1.3640))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_9',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.6920,-2.1560,1.2040))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_10',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.8160,-3.0440,1.1760))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_11',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.5400,-4.3560,0.8280))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_12',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.2360,-4.7640,0.5320))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_13',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.0240,-4.2560,0.3160))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.2080,-3.8600,0.5840))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_15',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.5000,-2.5280,0.9280))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_16',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.4520,-1.5520,0.9840))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.9680,-1.2560,0.5960))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_18',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.8280,-2.0800,0.6440))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_19',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.9600,-3.4480,0.3400))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_20',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.2320,-3.9680,0.0560))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_21',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.3800,-3.1600,0.0560))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_22',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.2440,-1.7760,0.3000))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_23',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-4.6560,-4.8960,-0.2680))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_24',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.1400,-3.4320,-1.1800))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_25',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.4480,-3.5400,0.5920))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_26',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.0400,-1.0080,-0.6600))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_27',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-4.1360,0.2200,0.2520))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_28',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.1080,-0.9960,1.1320))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_29',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.2040,5.2200,-1.0480))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_30',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.6320,4.9840,0.6280))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_31',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(0.1960,4.8160,-0.8800))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_32',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.4800,-0.1320,2.1880))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_33',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.1680,0.3040,1.8080))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_34',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.8840,-0.1800,0.7920))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_35',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.3360,-5.0440,-0.1680))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_36',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.5760,0.5280,-0.6960))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_37',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(2.5600,0.3560,-0.1480))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_38',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(1.7560,2.4200,1.7960))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_39',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.0960,2.5120,0.5640))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_40',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.5800,2.7680,-1.5560))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_41',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(3.2840,3.0280,-0.3880))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_42',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.4000,4.7760,-0.1440))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_43',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.6520,2.7040,-1.1960))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_44',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.4200,3.2200,2.1800))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_45',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.1240,0.6000,0.5720))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_46',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(2.0000,-5.9160,0.2280))])]),
      Transform(
        children=[
        ProtoInstance(DEF='riboflavin_karne_a_47',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.3120,-5.0400,0.7880))])])]),
    Group(
      children=[
      ProtoInstance(DEF='riboflavin_karne_b_1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2840,3.0280,-0.3880),(3.6520,2.7040,-1.1960)])]),
      ProtoInstance(DEF='riboflavin_karne_b_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.7560,2.4200,1.7960),(1.4200,3.2200,2.1800)])]),
      ProtoInstance(DEF='riboflavin_karne_b_3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5600,0.3560,-0.1480),(3.1240,0.6000,0.5720)])]),
      ProtoInstance(DEF='riboflavin_karne_b_4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.1960,4.8160,-0.8800),(-0.4000,4.7760,-0.1440)])]),
      ProtoInstance(DEF='riboflavin_karne_b_5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.3800,-3.1600,0.0560),(-3.2440,-1.7760,0.3000)])]),
      ProtoInstance(DEF='riboflavin_karne_b_6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.2320,-3.9680,0.0560),(-2.3360,-5.0440,-0.1680)])]),
      ProtoInstance(DEF='riboflavin_karne_b_7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.2520000000000002,-3.9680,0.0560),(-3.4,-3.1600,0.0560)])]),
      ProtoInstance(DEF='riboflavin_karne_b_7_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.212,-3.9680,0.0560),(-3.36,-3.1600,0.0560)])]),
      ProtoInstance(DEF='riboflavin_karne_b_8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.9600,-3.4480,0.3400),(-2.2320,-3.9680,0.0560)])]),
      ProtoInstance(DEF='riboflavin_karne_b_9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.848,-2.0800,0.6440),(-0.98,-3.4480,0.3400)])]),
      ProtoInstance(DEF='riboflavin_karne_b_9_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.8079999999999999,-2.0800,0.6440),(-0.94,-3.4480,0.3400)])]),
      ProtoInstance(DEF='riboflavin_karne_b_10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.9680,-1.2560,0.5960),(-1.8840,-0.1800,0.7920)])]),
      ProtoInstance(DEF='riboflavin_karne_b_11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.988,-1.2560,0.5960),(-3.2640000000000002,-1.7760,0.3000)])]),
      ProtoInstance(DEF='riboflavin_karne_b_11_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.948,-1.2560,0.5960),(-3.224,-1.7760,0.3000)])]),
      ProtoInstance(DEF='riboflavin_karne_b_12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.9680,-1.2560,0.5960),(-0.8280,-2.0800,0.6440)])]),
      ProtoInstance(DEF='riboflavin_karne_b_13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.4520,-1.5520,0.9840),(-0.8280,-2.0800,0.6440)])]),
      ProtoInstance(DEF='riboflavin_karne_b_14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5000,-2.5280,0.9280),(0.4520,-1.5520,0.9840)])]),
      ProtoInstance(DEF='riboflavin_karne_b_15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2080,-3.8600,0.5840),(1.5000,-2.5280,0.9280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.0240,-4.2560,0.3160),(-0.9600,-3.4480,0.3400)])]),
      ProtoInstance(DEF='riboflavin_karne_b_17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.004,-4.2560,0.3160),(1.188,-3.8600,0.5840)])]),
      ProtoInstance(DEF='riboflavin_karne_b_17_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.044,-4.2560,0.3160),(1.228,-3.8600,0.5840)])]),
      ProtoInstance(DEF='riboflavin_karne_b_18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.216,-4.7640,0.5320),(1.98,-5.9160,0.2280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_18_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.2560000000000002,-4.7640,0.5320),(2.02,-5.9160,0.2280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.2360,-4.7640,0.5320),(1.2080,-3.8600,0.5840)])]),
      ProtoInstance(DEF='riboflavin_karne_b_20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.5400,-4.3560,0.8280),(4.3120,-5.0400,0.7880)])]),
      ProtoInstance(DEF='riboflavin_karne_b_21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.5400,-4.3560,0.8280),(2.2360,-4.7640,0.5320)])]),
      ProtoInstance(DEF='riboflavin_karne_b_22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.8160,-3.0440,1.1760),(3.5400,-4.3560,0.8280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.672,-2.1560,1.2040),(1.48,-2.5280,0.9280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_23_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.712,-2.1560,1.2040),(1.52,-2.5280,0.9280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.6920,-2.1560,1.2040),(3.8160,-3.0440,1.1760)])]),
      ProtoInstance(DEF='riboflavin_karne_b_25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7320,-0.1640,1.3640),(-0.1680,0.3040,1.8080)])]),
      ProtoInstance(DEF='riboflavin_karne_b_26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7320,-0.1640,1.3640),(1.4800,-0.1320,2.1880)])]),
      ProtoInstance(DEF='riboflavin_karne_b_27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7320,-0.1640,1.3640),(0.4520,-1.5520,0.9840)])]),
      ProtoInstance(DEF='riboflavin_karne_b_28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2280,0.7120,0.1880),(2.5600,0.3560,-0.1480)])]),
      ProtoInstance(DEF='riboflavin_karne_b_29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2280,0.7120,0.1880),(0.5760,0.5280,-0.6960)])]),
      ProtoInstance(DEF='riboflavin_karne_b_30',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2280,0.7120,0.1880),(0.7320,-0.1640,1.3640)])]),
      ProtoInstance(DEF='riboflavin_karne_b_31',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.1720,2.2240,0.5160),(0.0960,2.5120,0.5640)])]),
      ProtoInstance(DEF='riboflavin_karne_b_32',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.1720,2.2240,0.5160),(1.7560,2.4200,1.7960)])]),
      ProtoInstance(DEF='riboflavin_karne_b_33',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.1720,2.2240,0.5160),(1.2280,0.7120,0.1880)])]),
      ProtoInstance(DEF='riboflavin_karne_b_34',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.8760,3.1200,-0.5360),(3.2840,3.0280,-0.3880)])]),
      ProtoInstance(DEF='riboflavin_karne_b_35',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.8760,3.1200,-0.5360),(1.5800,2.7680,-1.5560)])]),
      ProtoInstance(DEF='riboflavin_karne_b_36',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.8760,3.1200,-0.5360),(1.1720,2.2240,0.5160)])]),
      ProtoInstance(DEF='riboflavin_karne_b_37',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5200,4.6120,-0.4160),(0.1960,4.8160,-0.8800)])]),
      ProtoInstance(DEF='riboflavin_karne_b_38',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5200,4.6120,-0.4160),(1.6320,4.9840,0.6280)])]),
      ProtoInstance(DEF='riboflavin_karne_b_39',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5200,4.6120,-0.4160),(2.2040,5.2200,-1.0480)])]),
      ProtoInstance(DEF='riboflavin_karne_b_40',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.5200,4.6120,-0.4160),(1.8760,3.1200,-0.5360)])]),
      ProtoInstance(DEF='riboflavin_karne_b_41',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.892,-2.6120,1.4440),(3.796,-3.0440,1.1760)])]),
      ProtoInstance(DEF='riboflavin_karne_b_41_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.9319999999999995,-2.6120,1.4440),(3.836,-3.0440,1.1760)])]),
      ProtoInstance(DEF='riboflavin_karne_b_42',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.4360,-0.8480,0.2560),(-5.1080,-0.9960,1.1320)])]),
      ProtoInstance(DEF='riboflavin_karne_b_43',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.4360,-0.8480,0.2560),(-4.1360,0.2200,0.2520)])]),
      ProtoInstance(DEF='riboflavin_karne_b_44',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.4360,-0.8480,0.2560),(-5.0400,-1.0080,-0.6600)])]),
      ProtoInstance(DEF='riboflavin_karne_b_45',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.4360,-0.8480,0.2560),(-3.2440,-1.7760,0.3000)])]),
      ProtoInstance(DEF='riboflavin_karne_b_46',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.7200,-3.7880,-0.2120),(-5.4480,-3.5400,0.5920)])]),
      ProtoInstance(DEF='riboflavin_karne_b_47',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.7200,-3.7880,-0.2120),(-5.1400,-3.4320,-1.1800)])]),
      ProtoInstance(DEF='riboflavin_karne_b_48',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.7200,-3.7880,-0.2120),(-4.6560,-4.8960,-0.2680)])]),
      ProtoInstance(DEF='riboflavin_karne_b_49',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.7200,-3.7880,-0.2120),(-3.3800,-3.1600,0.0560)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Riboflavin.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Riboflavin.py load and self-test diagnostics complete.")
