package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of Riboflavin.x3d scene produced from Riboflavin.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/RiboflavinIndex.html" target="_blank">Riboflavin</a>,  source <a href="../../../ChemicalMarkupLanguage/Riboflavin.java">Riboflavin.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Riboflavin.x3d">Riboflavin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of Riboflavin.x3d scene produced from Riboflavin.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Riboflavin.xml">Riboflavin.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Riboflavin.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Riboflavin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class Riboflavin
{
	/** Default constructor to create this object. */
	public Riboflavin ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Riboflavin.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of Riboflavin.x3d scene produced from Riboflavin.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Riboflavin.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Riboflavin.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect Riboflavin").setPosition(0.0,2.0,20.0))
    .addComments(" CML document - riboflavin - karne - 7/8/00 ")
    .addComments(" file converted from: MDL .mol ")
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"Riboflavin: "})))))
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.7200,-3.7880,-0.2120)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.4360,-0.8480,0.2560)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.9120,-2.6120,1.4440)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.5200,4.6120,-0.4160)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.8760,3.1200,-0.5360)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_6").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.1720,2.2240,0.5160)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_7").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.2280,0.7120,0.1880)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_8").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7320,-0.1640,1.3640)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "riboflavin_karne_a_9").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.6920,-2.1560,1.2040)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_10").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.8160,-3.0440,1.1760)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "riboflavin_karne_a_11").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.5400,-4.3560,0.8280)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_12").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2360,-4.7640,0.5320)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "riboflavin_karne_a_13").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0240,-4.2560,0.3160)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_14").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.2080,-3.8600,0.5840)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_15").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.5000,-2.5280,0.9280)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "riboflavin_karne_a_16").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.4520,-1.5520,0.9840)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_17").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.9680,-1.2560,0.5960)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_18").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.8280,-2.0800,0.6440)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_19").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.9600,-3.4480,0.3400)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_20").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.2320,-3.9680,0.0560)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_21").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.3800,-3.1600,0.0560)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "riboflavin_karne_a_22").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.2440,-1.7760,0.3000)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_23").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.6560,-4.8960,-0.2680)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_24").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.1400,-3.4320,-1.1800)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_25").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.4480,-3.5400,0.5920)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_26").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.0400,-1.0080,-0.6600)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_27").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.1360,0.2200,0.2520)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_28").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.1080,-0.9960,1.1320)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_29").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2040,5.2200,-1.0480)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_30").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.6320,4.9840,0.6280)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_31").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.1960,4.8160,-0.8800)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_32").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.4800,-0.1320,2.1880)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_33").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.1680,0.3040,1.8080)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_34").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.8840,-0.1800,0.7920)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_35").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.3360,-5.0440,-0.1680)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_36").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.5760,0.5280,-0.6960)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_37").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.5600,0.3560,-0.1480)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_38").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.7560,2.4200,1.7960)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_39").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0960,2.5120,0.5640)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_40").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.5800,2.7680,-1.5560)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_41").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.2840,3.0280,-0.3880)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_42").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.4000,4.7760,-0.1440)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_43").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.6520,2.7040,-1.1960)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_44").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.4200,3.2200,2.1800)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_45").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.1240,0.6000,0.5720)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "riboflavin_karne_a_46").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.0000,-5.9160,0.2280)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "riboflavin_karne_a_47").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.3120,-5.0400,0.7880))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2840,3.0280,-0.3880,3.6520,2.7040,-1.1960})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.7560,2.4200,1.7960,1.4200,3.2200,2.1800})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.5600,0.3560,-0.1480,3.1240,0.6000,0.5720})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.1960,4.8160,-0.8800,-0.4000,4.7760,-0.1440})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.3800,-3.1600,0.0560,-3.2440,-1.7760,0.3000})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_6").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.2320,-3.9680,0.0560,-2.3360,-5.0440,-0.1680})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_7").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.2520000000000002,-3.9680,0.0560,-3.4,-3.1600,0.0560})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_7_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.212,-3.9680,0.0560,-3.36,-3.1600,0.0560})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_8").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.9600,-3.4480,0.3400,-2.2320,-3.9680,0.0560})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_9").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.848,-2.0800,0.6440,-0.98,-3.4480,0.3400})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_9_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.8079999999999999,-2.0800,0.6440,-0.94,-3.4480,0.3400})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_10").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.9680,-1.2560,0.5960,-1.8840,-0.1800,0.7920})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_11").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.988,-1.2560,0.5960,-3.2640000000000002,-1.7760,0.3000})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_11_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.948,-1.2560,0.5960,-3.224,-1.7760,0.3000})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_12").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.9680,-1.2560,0.5960,-0.8280,-2.0800,0.6440})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_13").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.4520,-1.5520,0.9840,-0.8280,-2.0800,0.6440})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_14").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5000,-2.5280,0.9280,0.4520,-1.5520,0.9840})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_15").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2080,-3.8600,0.5840,1.5000,-2.5280,0.9280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_16").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.0240,-4.2560,0.3160,-0.9600,-3.4480,0.3400})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_17").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.004,-4.2560,0.3160,1.188,-3.8600,0.5840})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_17_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.044,-4.2560,0.3160,1.228,-3.8600,0.5840})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_18").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.216,-4.7640,0.5320,1.98,-5.9160,0.2280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_18_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.2560000000000002,-4.7640,0.5320,2.02,-5.9160,0.2280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_19").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.2360,-4.7640,0.5320,1.2080,-3.8600,0.5840})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_20").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.5400,-4.3560,0.8280,4.3120,-5.0400,0.7880})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_21").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.5400,-4.3560,0.8280,2.2360,-4.7640,0.5320})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_22").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.8160,-3.0440,1.1760,3.5400,-4.3560,0.8280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_23").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.672,-2.1560,1.2040,1.48,-2.5280,0.9280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_23_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.712,-2.1560,1.2040,1.52,-2.5280,0.9280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_24").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.6920,-2.1560,1.2040,3.8160,-3.0440,1.1760})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_25").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7320,-0.1640,1.3640,-0.1680,0.3040,1.8080})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_26").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7320,-0.1640,1.3640,1.4800,-0.1320,2.1880})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_27").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7320,-0.1640,1.3640,0.4520,-1.5520,0.9840})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_28").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2280,0.7120,0.1880,2.5600,0.3560,-0.1480})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_29").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2280,0.7120,0.1880,0.5760,0.5280,-0.6960})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_30").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2280,0.7120,0.1880,0.7320,-0.1640,1.3640})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_31").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.1720,2.2240,0.5160,0.0960,2.5120,0.5640})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_32").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.1720,2.2240,0.5160,1.7560,2.4200,1.7960})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_33").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.1720,2.2240,0.5160,1.2280,0.7120,0.1880})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_34").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.8760,3.1200,-0.5360,3.2840,3.0280,-0.3880})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_35").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.8760,3.1200,-0.5360,1.5800,2.7680,-1.5560})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_36").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.8760,3.1200,-0.5360,1.1720,2.2240,0.5160})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_37").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5200,4.6120,-0.4160,0.1960,4.8160,-0.8800})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_38").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5200,4.6120,-0.4160,1.6320,4.9840,0.6280})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_39").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5200,4.6120,-0.4160,2.2040,5.2200,-1.0480})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_40").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.5200,4.6120,-0.4160,1.8760,3.1200,-0.5360})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_41").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.892,-2.6120,1.4440,3.796,-3.0440,1.1760})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_41_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.9319999999999995,-2.6120,1.4440,3.836,-3.0440,1.1760})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_42").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.4360,-0.8480,0.2560,-5.1080,-0.9960,1.1320})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_43").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.4360,-0.8480,0.2560,-4.1360,0.2200,0.2520})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_44").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.4360,-0.8480,0.2560,-5.0400,-1.0080,-0.6600})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_45").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.4360,-0.8480,0.2560,-3.2440,-1.7760,0.3000})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_46").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.7200,-3.7880,-0.2120,-5.4480,-3.5400,0.5920})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_47").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.7200,-3.7880,-0.2120,-5.1400,-3.4320,-1.1800})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_48").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.7200,-3.7880,-0.2120,-4.6560,-4.8960,-0.2680})))))
      .addChild(new ProtoInstance("line", "riboflavin_karne_b_49").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.7200,-3.7880,-0.2120,-3.3800,-3.1600,0.0560})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Riboflavin model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Riboflavin().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.Riboflavin\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.Riboflavin self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/Riboflavin_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/Riboflavin_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/Riboflavin_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/Riboflavin_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
