####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Oxytocin.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='Oxytocin.x3d',name='title'),
    meta(content='Autogenerated version of Oxytocin.x3d scene produced from Oxytocin.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='Oxytocin.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Oxytocin.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect Oxytocin',position=(0,2,20)),
    #  Copyright by the U.S. Sec. Commerce on behalf of U.S.A. All rights reserved. 
    #  type="3D" <date day="23" month="11" year="1995"/> 
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["Oxytocin: "])])])]),
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='a1',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.0514,1.8507,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.601,1.9845,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a3',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.2821,0.4905,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.4159,3.2554,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-4.649,0.8473,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.9355,3.5341,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a7',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.2341,0.4905,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a8',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-2.0514,-0.8362,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a9',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.5753,4.3034,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a10',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-6.1764,1.1595,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a11',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-4.1585,-0.6132,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a12',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.4905,2.0402,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a13',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.4905,-1.0257,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.2243,0.0223,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a15',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.2041,3.3892,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a16',name='Sulphur',
          fieldValue=[
          fieldValue(name='position',value=(1.1706,-2.4081,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.7071,0.3568,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a18',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-6.7226,-1.4382,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a19',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.3078,4.4929,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a20',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-0.0446,4.3368,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a21',name='Sulphur',
          fieldValue=[
          fieldValue(name='position',value=(2.2855,-3.5118,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a22',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-9.7662,-0.7804,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a23',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-9.2088,1.8507,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a24',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.7483,-2.5753,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a25',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.6902,5.1841,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a26',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.3936,5.7416,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a27',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.6568,-4.2253,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a28',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-11.2825,-0.4459,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a29',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-7.2243,-4.0693,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a30',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-8.7963,-2.4081,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a31',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.2064,5.4405,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a32',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.0291,7.1797,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a33',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1841,-4.4818,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a34',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-12.3304,-1.6054,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a35',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.7561,5.1841,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a36',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(5.2399,6.9791,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a37',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.126,8.4507,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a38',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(3.5787,7.3135,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a39',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.7226,-4.2253,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a40',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(5.1841,-6.0203,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a41',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(-13.8466,-1.2709,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a42',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-11.8622,-3.0659,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a43',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(8.1385,4.4706,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a44',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(7.2243,6.6781,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a45',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(8.1051,-3.5341,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a46',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(7.202,-5.7193,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a47',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.2422,3.3669,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a48',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.7406,6.9791,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a49',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.2088,-2.4304,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a50',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.9335,1.9845,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a51',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(10.4797,4.3034,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a52',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.2422,8.4507,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a53',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(10.4797,-3.3446,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a54',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.9335,-1.0591,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a55',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(10.1787,0.4682,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a56',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.4274,2.4862,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a57',name='Nitrogen',
          fieldValue=[
          fieldValue(name='position',value=(10.7585,8.774,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a58',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(8.2166,9.6324,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a59',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(10.3237,-4.8943,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a60',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(11.4274,-1.5274,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a61',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(12.5534,1.427,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a62',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.7507,4.0024,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a63',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.8855,-5.5297,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a64',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.5612,-5.8085,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a65',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(14.0473,1.9064,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a66',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.7183,-7.0794,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a67',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.3939,-7.347,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a68',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.9892,-7.9824,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='a69',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(9.7885,-9.5321,0))])])]),
    Group(
      children=[
      ProtoInstance(DEF='b1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.0514,1.8507,0),(-3.601,1.9845,0)])]),
      ProtoInstance(DEF='b2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.0514,1.8507,0),(-1.2821,0.4905,0)])]),
      ProtoInstance(DEF='b3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.0514,1.8507,0),(-1.4159,3.2554,0)])]),
      ProtoInstance(DEF='b4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.601,1.9845,0),(-4.649,0.8473,0)])]),
      ProtoInstance(DEF='b5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.601,1.9845,0),(-3.9355,3.5341,0)])]),
      ProtoInstance(DEF='b6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.2821,0.4905,0),(0.2341,0.4905,0)])]),
      ProtoInstance(DEF='b7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3021,0.4905,0),(-2.0714,-0.8362,0)])]),
      ProtoInstance(DEF='b7_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.2621,0.4905,0),(-2.0314,-0.8362,0)])]),
      ProtoInstance(DEF='b8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4159,3.2554,0),(-2.5753,4.3034,0)])]),
      ProtoInstance(DEF='b9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.649,0.8473,0),(-6.1764,1.1595,0)])]),
      ProtoInstance(DEF='b10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.669,0.8473,0),(-4.1785,-0.6132,0)])]),
      ProtoInstance(DEF='b10_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-4.6290000000000004,0.8473,0),(-4.1385000000000005,-0.6132,0)])]),
      ProtoInstance(DEF='b11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.2341,0.4905,0),(0.4905,2.0402,0)])]),
      ProtoInstance(DEF='b12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.2341,0.4905,0),(0.4905,-1.0257,0)])]),
      ProtoInstance(DEF='b13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.1764,1.1595,0),(-7.2243,0.0223,0)])]),
      ProtoInstance(DEF='b14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.4905,2.0402,0),(1.2041,3.3892,0)])]),
      ProtoInstance(DEF='b15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.4905,-1.0257,0),(1.1706,-2.4081,0)])]),
      ProtoInstance(DEF='b16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.2243,0.0223,0),(-8.7071,0.3568,0)])]),
      ProtoInstance(DEF='b17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.2243,0.0223,0),(-6.7226,-1.4382,0)])]),
      ProtoInstance(DEF='b18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2041,3.3892,0),(2.3078,4.4929,0)])]),
      ProtoInstance(DEF='b19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.1841,3.3892,0),(-0.0646,4.3368,0)])]),
      ProtoInstance(DEF='b19_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.2241,3.3892,0),(-0.0246,4.3368,0)])]),
      ProtoInstance(DEF='b20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.1706,-2.4081,0),(2.2855,-3.5118,0)])]),
      ProtoInstance(DEF='b21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.7071,0.3568,0),(-9.7662,-0.7804,0)])]),
      ProtoInstance(DEF='b22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.7271,0.3568,0),(-9.2288,1.8507,0)])]),
      ProtoInstance(DEF='b22_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-8.687100000000001,0.3568,0),(-9.1888,1.8507,0)])]),
      ProtoInstance(DEF='b23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-6.7226,-1.4382,0),(-7.7483,-2.5753,0)])]),
      ProtoInstance(DEF='b24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.3078,4.4929,0),(3.6902,5.1841,0)])]),
      ProtoInstance(DEF='b25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.3078,4.4929,0),(1.3936,5.7416,0)])]),
      ProtoInstance(DEF='b26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.2855,-3.5118,0),(3.6568,-4.2253,0)])]),
      ProtoInstance(DEF='b27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-9.7662,-0.7804,0),(-11.2825,-0.4459,0)])]),
      ProtoInstance(DEF='b28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.7483,-2.5753,0),(-7.2243,-4.0693,0)])]),
      ProtoInstance(DEF='b29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-7.7483,-2.5753,0),(-8.7963,-2.4081,0)])]),
      ProtoInstance(DEF='b30',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.6902,5.1841,0),(5.2064,5.4405,0)])]),
      ProtoInstance(DEF='b31',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3936,5.7416,0),(2.0291,7.1797,0)])]),
      ProtoInstance(DEF='b32',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.6568,-4.2253,0),(5.1841,-4.4818,0)])]),
      ProtoInstance(DEF='b33',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-11.2825,-0.4459,0),(-12.3304,-1.6054,0)])]),
      ProtoInstance(DEF='b34',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.2064,5.4405,0),(6.7561,5.1841,0)])]),
      ProtoInstance(DEF='b35',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.186400000000001,5.4405,0),(5.2199,6.9791,0)])]),
      ProtoInstance(DEF='b35_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.2264,5.4405,0),(5.259899999999999,6.9791,0)])]),
      ProtoInstance(DEF='b36',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.0291,7.1797,0),(1.126,8.4507,0)])]),
      ProtoInstance(DEF='b37',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.0091,7.1797,0),(3.5587,7.3135,0)])]),
      ProtoInstance(DEF='b37_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.0491,7.1797,0),(3.5987,7.3135,0)])]),
      ProtoInstance(DEF='b38',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1841,-4.4818,0),(6.7226,-4.2253,0)])]),
      ProtoInstance(DEF='b39',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1841,-4.4818,0),(5.1841,-6.0203,0)])]),
      ProtoInstance(DEF='b40',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.3304,-1.6054,0),(-13.8466,-1.2709,0)])]),
      ProtoInstance(DEF='b41',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.350399999999999,-1.6054,0),(-11.8822,-3.0659,0)])]),
      ProtoInstance(DEF='b41_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-12.3104,-1.6054,0),(-11.8422,-3.0659,0)])]),
      ProtoInstance(DEF='b42',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7561,5.1841,0),(8.1385,4.4706,0)])]),
      ProtoInstance(DEF='b43',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7561,5.1841,0),(7.2243,6.6781,0)])]),
      ProtoInstance(DEF='b44',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7226,-4.2253,0),(8.1051,-3.5341,0)])]),
      ProtoInstance(DEF='b45',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7026,-4.2253,0),(7.182,-5.7193,0)])]),
      ProtoInstance(DEF='b45_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7425999999999995,-4.2253,0),(7.2219999999999995,-5.7193,0)])]),
      ProtoInstance(DEF='b46',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.1385,4.4706,0),(9.2422,3.3669,0)])]),
      ProtoInstance(DEF='b47',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.2243,6.6781,0),(8.7406,6.9791,0)])]),
      ProtoInstance(DEF='b48',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.1051,-3.5341,0),(9.2088,-2.4304,0)])]),
      ProtoInstance(DEF='b49',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2422,3.3669,0),(9.9335,1.9845,0)])]),
      ProtoInstance(DEF='b50',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2222,3.3669,0),(10.4597,4.3034,0)])]),
      ProtoInstance(DEF='b50_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2622,3.3669,0),(10.499699999999999,4.3034,0)])]),
      ProtoInstance(DEF='b51',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.7406,6.9791,0),(9.2422,8.4507,0)])]),
      ProtoInstance(DEF='b52',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2088,-2.4304,0),(10.4797,-3.3446,0)])]),
      ProtoInstance(DEF='b53',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2088,-2.4304,0),(9.9335,-1.0591,0)])]),
      ProtoInstance(DEF='b54',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9335,1.9845,0),(10.1787,0.4682,0)])]),
      ProtoInstance(DEF='b55',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9335,1.9845,0),(11.4274,2.4862,0)])]),
      ProtoInstance(DEF='b56',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2422,8.4507,0),(10.7585,8.774,0)])]),
      ProtoInstance(DEF='b57',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2222,8.4507,0),(8.1966,9.6324,0)])]),
      ProtoInstance(DEF='b57_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.2622,8.4507,0),(8.2366,9.6324,0)])]),
      ProtoInstance(DEF='b58',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.4797,-3.3446,0),(10.3237,-4.8943,0)])]),
      ProtoInstance(DEF='b59',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9135,-1.0591,0),(11.4074,-1.5274,0)])]),
      ProtoInstance(DEF='b59_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9535,-1.0591,0),(11.4474,-1.5274,0)])]),
      ProtoInstance(DEF='b60',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.4274,2.4862,0),(12.5534,1.427,0)])]),
      ProtoInstance(DEF='b61',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.4274,2.4862,0),(11.7507,4.0024,0)])]),
      ProtoInstance(DEF='b62',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.3237,-4.8943,0),(8.8855,-5.5297,0)])]),
      ProtoInstance(DEF='b63',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.303700000000001,-4.8943,0),(11.5412,-5.8085,0)])]),
      ProtoInstance(DEF='b63_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.3437,-4.8943,0),(11.581199999999999,-5.8085,0)])]),
      ProtoInstance(DEF='b64',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(12.5534,1.427,0),(14.0473,1.9064,0)])]),
      ProtoInstance(DEF='b65',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.8655,-5.5297,0),(8.6983,-7.0794,0)])]),
      ProtoInstance(DEF='b65_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.9055,-5.5297,0),(8.738299999999999,-7.0794,0)])]),
      ProtoInstance(DEF='b66',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.5612,-5.8085,0),(11.3939,-7.347,0)])]),
      ProtoInstance(DEF='b67',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.7183,-7.0794,0),(9.9892,-7.9824,0)])]),
      ProtoInstance(DEF='b68',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9892,-7.9824,0),(9.7885,-9.5321,0)])]),
      ProtoInstance(DEF='b69',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.9355,3.5341,0),(-2.5753,4.3034,0)])]),
      ProtoInstance(DEF='b70',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.9335,-1.0591,0),(10.1787,0.4682,0)])]),
      ProtoInstance(DEF='b71',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.3739,-7.347,0),(9.9692,-7.9824,0)])]),
      ProtoInstance(DEF='b71_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.4139,-7.347,0),(10.0092,-7.9824,0)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Oxytocin.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Oxytocin.py load and self-test diagnostics complete.")
