package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of Oxytocin.x3d scene produced from Oxytocin.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/OxytocinIndex.html" target="_blank">Oxytocin</a>,  source <a href="../../../ChemicalMarkupLanguage/Oxytocin.java">Oxytocin.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Oxytocin.x3d">Oxytocin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of Oxytocin.x3d scene produced from Oxytocin.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Oxytocin.xml">Oxytocin.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Oxytocin.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Oxytocin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class Oxytocin
{
	/** Default constructor to create this object. */
	public Oxytocin ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Oxytocin.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of Oxytocin.x3d scene produced from Oxytocin.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Oxytocin.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Oxytocin.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect Oxytocin").setPosition(0.0,2.0,20.0))
    .addComments(" Copyright by the U.S. Sec. Commerce on behalf of U.S.A. All rights reserved. ")
    .addComments(" type=\"3D\" <date day=\"23\" month=\"11\" year=\"1995\"/> ")
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"Oxytocin: "})))))
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.0514,1.8507,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.601,1.9845,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.2821,0.4905,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.4159,3.2554,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.649,0.8473,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a6").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.9355,3.5341,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a7").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.2341,0.4905,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a8").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.0514,-0.8362,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a9").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.5753,4.3034,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a10").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.1764,1.1595,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a11").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.1585,-0.6132,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a12").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.4905,2.0402,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a13").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.4905,-1.0257,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a14").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.2243,0.0223,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a15").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.2041,3.3892,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Sulphur", "a16").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.1706,-2.4081,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a17").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.7071,0.3568,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a18").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-6.7226,-1.4382,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a19").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.3078,4.4929,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a20").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.0446,4.3368,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Sulphur", "a21").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2855,-3.5118,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a22").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.7662,-0.7804,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a23").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-9.2088,1.8507,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a24").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.7483,-2.5753,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a25").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.6902,5.1841,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a26").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.3936,5.7416,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a27").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.6568,-4.2253,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a28").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-11.2825,-0.4459,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a29").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-7.2243,-4.0693,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a30").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-8.7963,-2.4081,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a31").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.2064,5.4405,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a32").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.0291,7.1797,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a33").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.1841,-4.4818,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a34").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-12.3304,-1.6054,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a35").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.7561,5.1841,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a36").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.2399,6.9791,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a37").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.126,8.4507,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a38").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.5787,7.3135,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a39").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.7226,-4.2253,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a40").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.1841,-6.0203,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a41").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-13.8466,-1.2709,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a42").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-11.8622,-3.0659,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a43").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.1385,4.4706,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a44").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.2243,6.6781,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a45").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.1051,-3.5341,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a46").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.202,-5.7193,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a47").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.2422,3.3669,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a48").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.7406,6.9791,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a49").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.2088,-2.4304,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a50").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.9335,1.9845,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a51").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.4797,4.3034,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a52").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.2422,8.4507,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a53").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.4797,-3.3446,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a54").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.9335,-1.0591,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a55").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.1787,0.4682,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a56").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.4274,2.4862,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Nitrogen", "a57").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.7585,8.774,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a58").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.2166,9.6324,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a59").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.3237,-4.8943,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a60").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.4274,-1.5274,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a61").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(12.5534,1.427,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a62").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.7507,4.0024,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a63").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.8855,-5.5297,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a64").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.5612,-5.8085,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a65").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(14.0473,1.9064,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a66").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.7183,-7.0794,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a67").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.3939,-7.347,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "a68").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.9892,-7.9824,0.0)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "a69").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.7885,-9.5321,0.0))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "b1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.0514,1.8507,0.0,-3.601,1.9845,0.0})))))
      .addChild(new ProtoInstance("line", "b2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.0514,1.8507,0.0,-1.2821,0.4905,0.0})))))
      .addChild(new ProtoInstance("line", "b3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.0514,1.8507,0.0,-1.4159,3.2554,0.0})))))
      .addChild(new ProtoInstance("line", "b4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.601,1.9845,0.0,-4.649,0.8473,0.0})))))
      .addChild(new ProtoInstance("line", "b5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.601,1.9845,0.0,-3.9355,3.5341,0.0})))))
      .addChild(new ProtoInstance("line", "b6").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.2821,0.4905,0.0,0.2341,0.4905,0.0})))))
      .addChild(new ProtoInstance("line", "b7").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3021,0.4905,0.0,-2.0714,-0.8362,0.0})))))
      .addChild(new ProtoInstance("line", "b7_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.2621,0.4905,0.0,-2.0314,-0.8362,0.0})))))
      .addChild(new ProtoInstance("line", "b8").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4159,3.2554,0.0,-2.5753,4.3034,0.0})))))
      .addChild(new ProtoInstance("line", "b9").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.649,0.8473,0.0,-6.1764,1.1595,0.0})))))
      .addChild(new ProtoInstance("line", "b10").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.669,0.8473,0.0,-4.1785,-0.6132,0.0})))))
      .addChild(new ProtoInstance("line", "b10_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-4.6290000000000004,0.8473,0.0,-4.1385000000000005,-0.6132,0.0})))))
      .addChild(new ProtoInstance("line", "b11").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.2341,0.4905,0.0,0.4905,2.0402,0.0})))))
      .addChild(new ProtoInstance("line", "b12").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.2341,0.4905,0.0,0.4905,-1.0257,0.0})))))
      .addChild(new ProtoInstance("line", "b13").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.1764,1.1595,0.0,-7.2243,0.0223,0.0})))))
      .addChild(new ProtoInstance("line", "b14").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.4905,2.0402,0.0,1.2041,3.3892,0.0})))))
      .addChild(new ProtoInstance("line", "b15").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.4905,-1.0257,0.0,1.1706,-2.4081,0.0})))))
      .addChild(new ProtoInstance("line", "b16").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.2243,0.0223,0.0,-8.7071,0.3568,0.0})))))
      .addChild(new ProtoInstance("line", "b17").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.2243,0.0223,0.0,-6.7226,-1.4382,0.0})))))
      .addChild(new ProtoInstance("line", "b18").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2041,3.3892,0.0,2.3078,4.4929,0.0})))))
      .addChild(new ProtoInstance("line", "b19").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.1841,3.3892,0.0,-0.0646,4.3368,0.0})))))
      .addChild(new ProtoInstance("line", "b19_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.2241,3.3892,0.0,-0.0246,4.3368,0.0})))))
      .addChild(new ProtoInstance("line", "b20").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.1706,-2.4081,0.0,2.2855,-3.5118,0.0})))))
      .addChild(new ProtoInstance("line", "b21").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.7071,0.3568,0.0,-9.7662,-0.7804,0.0})))))
      .addChild(new ProtoInstance("line", "b22").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.7271,0.3568,0.0,-9.2288,1.8507,0.0})))))
      .addChild(new ProtoInstance("line", "b22_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-8.687100000000001,0.3568,0.0,-9.1888,1.8507,0.0})))))
      .addChild(new ProtoInstance("line", "b23").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-6.7226,-1.4382,0.0,-7.7483,-2.5753,0.0})))))
      .addChild(new ProtoInstance("line", "b24").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.3078,4.4929,0.0,3.6902,5.1841,0.0})))))
      .addChild(new ProtoInstance("line", "b25").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.3078,4.4929,0.0,1.3936,5.7416,0.0})))))
      .addChild(new ProtoInstance("line", "b26").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.2855,-3.5118,0.0,3.6568,-4.2253,0.0})))))
      .addChild(new ProtoInstance("line", "b27").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-9.7662,-0.7804,0.0,-11.2825,-0.4459,0.0})))))
      .addChild(new ProtoInstance("line", "b28").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.7483,-2.5753,0.0,-7.2243,-4.0693,0.0})))))
      .addChild(new ProtoInstance("line", "b29").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-7.7483,-2.5753,0.0,-8.7963,-2.4081,0.0})))))
      .addChild(new ProtoInstance("line", "b30").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.6902,5.1841,0.0,5.2064,5.4405,0.0})))))
      .addChild(new ProtoInstance("line", "b31").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3936,5.7416,0.0,2.0291,7.1797,0.0})))))
      .addChild(new ProtoInstance("line", "b32").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.6568,-4.2253,0.0,5.1841,-4.4818,0.0})))))
      .addChild(new ProtoInstance("line", "b33").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-11.2825,-0.4459,0.0,-12.3304,-1.6054,0.0})))))
      .addChild(new ProtoInstance("line", "b34").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.2064,5.4405,0.0,6.7561,5.1841,0.0})))))
      .addChild(new ProtoInstance("line", "b35").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.186400000000001,5.4405,0.0,5.2199,6.9791,0.0})))))
      .addChild(new ProtoInstance("line", "b35_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.2264,5.4405,0.0,5.259899999999999,6.9791,0.0})))))
      .addChild(new ProtoInstance("line", "b36").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.0291,7.1797,0.0,1.126,8.4507,0.0})))))
      .addChild(new ProtoInstance("line", "b37").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.0091,7.1797,0.0,3.5587,7.3135,0.0})))))
      .addChild(new ProtoInstance("line", "b37_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.0491,7.1797,0.0,3.5987,7.3135,0.0})))))
      .addChild(new ProtoInstance("line", "b38").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1841,-4.4818,0.0,6.7226,-4.2253,0.0})))))
      .addChild(new ProtoInstance("line", "b39").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1841,-4.4818,0.0,5.1841,-6.0203,0.0})))))
      .addChild(new ProtoInstance("line", "b40").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.3304,-1.6054,0.0,-13.8466,-1.2709,0.0})))))
      .addChild(new ProtoInstance("line", "b41").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.350399999999999,-1.6054,0.0,-11.8822,-3.0659,0.0})))))
      .addChild(new ProtoInstance("line", "b41_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-12.3104,-1.6054,0.0,-11.8422,-3.0659,0.0})))))
      .addChild(new ProtoInstance("line", "b42").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.7561,5.1841,0.0,8.1385,4.4706,0.0})))))
      .addChild(new ProtoInstance("line", "b43").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.7561,5.1841,0.0,7.2243,6.6781,0.0})))))
      .addChild(new ProtoInstance("line", "b44").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.7226,-4.2253,0.0,8.1051,-3.5341,0.0})))))
      .addChild(new ProtoInstance("line", "b45").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.7026,-4.2253,0.0,7.182,-5.7193,0.0})))))
      .addChild(new ProtoInstance("line", "b45_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.7425999999999995,-4.2253,0.0,7.2219999999999995,-5.7193,0.0})))))
      .addChild(new ProtoInstance("line", "b46").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.1385,4.4706,0.0,9.2422,3.3669,0.0})))))
      .addChild(new ProtoInstance("line", "b47").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.2243,6.6781,0.0,8.7406,6.9791,0.0})))))
      .addChild(new ProtoInstance("line", "b48").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.1051,-3.5341,0.0,9.2088,-2.4304,0.0})))))
      .addChild(new ProtoInstance("line", "b49").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2422,3.3669,0.0,9.9335,1.9845,0.0})))))
      .addChild(new ProtoInstance("line", "b50").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2222,3.3669,0.0,10.4597,4.3034,0.0})))))
      .addChild(new ProtoInstance("line", "b50_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2622,3.3669,0.0,10.499699999999999,4.3034,0.0})))))
      .addChild(new ProtoInstance("line", "b51").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.7406,6.9791,0.0,9.2422,8.4507,0.0})))))
      .addChild(new ProtoInstance("line", "b52").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2088,-2.4304,0.0,10.4797,-3.3446,0.0})))))
      .addChild(new ProtoInstance("line", "b53").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2088,-2.4304,0.0,9.9335,-1.0591,0.0})))))
      .addChild(new ProtoInstance("line", "b54").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9335,1.9845,0.0,10.1787,0.4682,0.0})))))
      .addChild(new ProtoInstance("line", "b55").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9335,1.9845,0.0,11.4274,2.4862,0.0})))))
      .addChild(new ProtoInstance("line", "b56").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2422,8.4507,0.0,10.7585,8.774,0.0})))))
      .addChild(new ProtoInstance("line", "b57").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2222,8.4507,0.0,8.1966,9.6324,0.0})))))
      .addChild(new ProtoInstance("line", "b57_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.2622,8.4507,0.0,8.2366,9.6324,0.0})))))
      .addChild(new ProtoInstance("line", "b58").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.4797,-3.3446,0.0,10.3237,-4.8943,0.0})))))
      .addChild(new ProtoInstance("line", "b59").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9135,-1.0591,0.0,11.4074,-1.5274,0.0})))))
      .addChild(new ProtoInstance("line", "b59_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9535,-1.0591,0.0,11.4474,-1.5274,0.0})))))
      .addChild(new ProtoInstance("line", "b60").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.4274,2.4862,0.0,12.5534,1.427,0.0})))))
      .addChild(new ProtoInstance("line", "b61").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.4274,2.4862,0.0,11.7507,4.0024,0.0})))))
      .addChild(new ProtoInstance("line", "b62").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.3237,-4.8943,0.0,8.8855,-5.5297,0.0})))))
      .addChild(new ProtoInstance("line", "b63").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.303700000000001,-4.8943,0.0,11.5412,-5.8085,0.0})))))
      .addChild(new ProtoInstance("line", "b63_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.3437,-4.8943,0.0,11.581199999999999,-5.8085,0.0})))))
      .addChild(new ProtoInstance("line", "b64").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {12.5534,1.427,0.0,14.0473,1.9064,0.0})))))
      .addChild(new ProtoInstance("line", "b65").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.8655,-5.5297,0.0,8.6983,-7.0794,0.0})))))
      .addChild(new ProtoInstance("line", "b65_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.9055,-5.5297,0.0,8.738299999999999,-7.0794,0.0})))))
      .addChild(new ProtoInstance("line", "b66").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.5612,-5.8085,0.0,11.3939,-7.347,0.0})))))
      .addChild(new ProtoInstance("line", "b67").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.7183,-7.0794,0.0,9.9892,-7.9824,0.0})))))
      .addChild(new ProtoInstance("line", "b68").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9892,-7.9824,0.0,9.7885,-9.5321,0.0})))))
      .addChild(new ProtoInstance("line", "b69").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.9355,3.5341,0.0,-2.5753,4.3034,0.0})))))
      .addChild(new ProtoInstance("line", "b70").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.9335,-1.0591,0.0,10.1787,0.4682,0.0})))))
      .addChild(new ProtoInstance("line", "b71").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.3739,-7.347,0.0,9.9692,-7.9824,0.0})))))
      .addChild(new ProtoInstance("line", "b71_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.4139,-7.347,0.0,10.0092,-7.9824,0.0})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Oxytocin model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Oxytocin().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.Oxytocin\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.Oxytocin self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/Oxytocin_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/Oxytocin_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/Oxytocin_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/Oxytocin_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
