####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Digitoxigenin.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='Digitoxigenin.x3d',name='title'),
    meta(content='Autogenerated version of Digitoxigenin.x3d scene produced from Digitoxigenin.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='Digitoxigenin.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Digitoxigenin.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect Digitoxigenin',position=(0,2,20)),
    #  <?xml-stylesheet type="text/xsl" href="generic.xsl" ?> 
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["Digitoxigenin: "])])])]),
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_1',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.1606,1.6552,-0.8847))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.1997,0.1524,-1.1623))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_3',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.3838,-0.6669,0.0977))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.4275,-0.2242,1.2059))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.4096,1.2976,1.4632))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.4098,1.6499,2.5708))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_7',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.0361,1.3738,2.1457))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_8',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.3916,2.0360,0.8039))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_9',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.3399,1.7901,-0.3008))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_10',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.1140,2.0931,0.1658))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_11',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.7681,2.5701,-1.5481))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_12',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.1105,2.0585,-2.0639))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_13',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.2569,2.2095,-1.0278))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.7981,1.6010,0.3349))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_15',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.9717,0.0748,0.1666))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_16',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.0160,-0.1450,-0.9304))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.4147,1.2521,-1.4990))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_18',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.6782,3.6838,-0.9321))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_19',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.3206,3.6128,0.3983))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_20',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.8099,1.6589,-1.1447))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_21',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.5388,1.3027,0.1169))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_22',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.6600,2.3309,-1.9293))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_23',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(7.9463,2.4238,-1.2600))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_24',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-3.1542,1.9631,-0.5268))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_25',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.9345,2.1719,-1.8290))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_26',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.2536,-0.1427,-1.6394))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_27',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-3.0361,-0.0583,-1.8450))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_28',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.1882,-1.7259,-0.1262))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_29',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.4104,-0.5380,0.9282))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_30',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-3.7698,-0.5088,0.5013))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_31',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(2.5002,2.7469,-3.2656))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_32',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(3.7691,1.9732,1.3470))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_33',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(7.8648,1.8507,-0.0582))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_34',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(9.0017,2.8700,-1.6562))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_35',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.7247,-0.7271,2.1379))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_36',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.4116,1.5894,1.8107))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_37',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.6396,1.0472,3.4618))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_38',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.5108,2.7178,2.8143))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_39',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.1744,0.2867,2.0503))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_40',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.7123,1.7627,2.9213))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_41',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.4233,3.1214,0.9800))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_42',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.3689,0.7204,-0.5556))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_43',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.8605,3.6364,-1.2942))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_44',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.0072,2.4446,-2.3325))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_45',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.9935,0.9892,-2.2941))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_46',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.0155,-0.3830,-0.1266))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_47',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.3176,-0.3713,1.1107))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_48',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.5912,-0.7674,-1.7317))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_49',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.9014,-0.6437,-0.5091))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_50',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.3825,1.2027,-2.5975))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_51',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.9871,4.0420,-1.9253))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_52',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.5193,3.7800,-0.2298))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_53',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.8300,4.2850,-0.5730))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_54',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.3543,3.7963,0.7265))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_55',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.1316,4.1562,-0.5392))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_56',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.6224,3.9636,1.1726))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_57',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(6.5840,0.2110,0.2438))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_58',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(6.0452,1.7533,0.9905))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_59',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(6.4259,2.7417,-2.9103))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_60',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-4.3394,-0.7908,-0.2048))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_61',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.8108,2.6665,-3.9143))])]),
      Transform(
        children=[
        ProtoInstance(DEF='digitoxigenin_karne_a_62',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.7194,2.9087,1.5046))])])]),
    Group(
      children=[
      ProtoInstance(DEF='digitoxigenin_karne_b_1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1606,1.6552,-0.8847),(-2.1997,0.1524,-1.1623)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1606,1.6552,-0.8847),(-1.1140,2.0931,0.1658)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1997,0.1524,-1.1623),(-2.3838,-0.6669,0.0977)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.3838,-0.6669,0.0977),(-1.4275,-0.2242,1.2059)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.3838,-0.6669,0.0977),(-3.7698,-0.5088,0.5013)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4096,1.2976,1.4632),(-1.4275,-0.2242,1.2059)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4096,1.2976,1.4632),(-0.4098,1.6499,2.5708)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.1140,2.0931,0.1658),(-1.4096,1.2976,1.4632)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.4098,1.6499,2.5708),(1.0361,1.3738,2.1457)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3916,2.0360,0.8039),(1.0361,1.3738,2.1457)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3399,1.7901,-0.3008),(1.3916,2.0360,0.8039)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3916,2.0360,0.8039),(2.7981,1.6010,0.3349)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.1140,2.0931,0.1658),(0.3399,1.7901,-0.3008)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3399,1.7901,-0.3008),(0.7681,2.5701,-1.5481)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.1140,2.0931,0.1658),(-1.3206,3.6128,0.3983)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7681,2.5701,-1.5481),(2.1105,2.0585,-2.0639)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1105,2.0585,-2.0639),(3.2569,2.2095,-1.0278)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1105,2.0585,-2.0639),(2.5002,2.7469,-3.2656)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2569,2.2095,-1.0278),(4.4147,1.2521,-1.4990)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2569,2.2095,-1.0278),(3.6782,3.6838,-0.9321)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7981,1.6010,0.3349),(3.2569,2.2095,-1.0278)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7981,1.6010,0.3349),(2.9717,0.0748,0.1666)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7981,1.6010,0.3349),(3.7691,1.9732,1.3470)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.9717,0.0748,0.1666),(4.0160,-0.1450,-0.9304)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.4147,1.2521,-1.4990),(4.0160,-0.1450,-0.9304)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.4147,1.2521,-1.4990),(5.8099,1.6589,-1.1447)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.8099,1.6589,-1.1447),(6.5388,1.3027,0.1169)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.7899,1.6589,-1.1447),(6.640000000000001,2.3309,-1.9293)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_28_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.829899999999999,1.6589,-1.1447),(6.68,2.3309,-1.9293)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.5388,1.3027,0.1169),(7.8648,1.8507,-0.0582)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_30',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.6600,2.3309,-1.9293),(7.9463,2.4238,-1.2600)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_31',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.9263,2.4238,-1.2600),(8.9817,2.8700,-1.6562)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_31_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.9662999999999995,2.4238,-1.2600),(9.0217,2.8700,-1.6562)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_32',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.9463,2.4238,-1.2600),(7.8648,1.8507,-0.0582)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_33',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1606,1.6552,-0.8847),(-3.1542,1.9631,-0.5268)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_34',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1606,1.6552,-0.8847),(-1.9345,2.1719,-1.8290)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_35',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1997,0.1524,-1.1623),(-1.2536,-0.1427,-1.6394)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_36',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1997,0.1524,-1.1623),(-3.0361,-0.0583,-1.8450)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_37',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.3838,-0.6669,0.0977),(-2.1882,-1.7259,-0.1262)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_38',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4275,-0.2242,1.2059),(-0.4104,-0.5380,0.9282)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_39',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4275,-0.2242,1.2059),(-1.7247,-0.7271,2.1379)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_40',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.4096,1.2976,1.4632),(-2.4116,1.5894,1.8107)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_41',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.4098,1.6499,2.5708),(-0.6396,1.0472,3.4618)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_42',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.4098,1.6499,2.5708),(-0.5108,2.7178,2.8143)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_43',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.0361,1.3738,2.1457),(1.1744,0.2867,2.0503)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_44',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.0361,1.3738,2.1457),(1.7123,1.7627,2.9213)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_45',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3916,2.0360,0.8039),(1.4233,3.1214,0.9800)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_46',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3399,1.7901,-0.3008),(0.3689,0.7204,-0.5556)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_47',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7681,2.5701,-1.5481),(0.8605,3.6364,-1.2942)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_48',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7681,2.5701,-1.5481),(0.0072,2.4446,-2.3325)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_49',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1105,2.0585,-2.0639),(1.9935,0.9892,-2.2941)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_50',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.9717,0.0748,0.1666),(2.0155,-0.3830,-0.1266)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_51',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.9717,0.0748,0.1666),(3.3176,-0.3713,1.1107)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_52',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.0160,-0.1450,-0.9304),(3.5912,-0.7674,-1.7317)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_53',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.0160,-0.1450,-0.9304),(4.9014,-0.6437,-0.5091)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_54',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.4147,1.2521,-1.4990),(4.3825,1.2027,-2.5975)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_55',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.6782,3.6838,-0.9321),(3.9871,4.0420,-1.9253)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_56',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.6782,3.6838,-0.9321),(4.5193,3.7800,-0.2298)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_57',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.6782,3.6838,-0.9321),(2.8300,4.2850,-0.5730)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_58',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3206,3.6128,0.3983),(-2.3543,3.7963,0.7265)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_59',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3206,3.6128,0.3983),(-1.1316,4.1562,-0.5392)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_60',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3206,3.6128,0.3983),(-0.6224,3.9636,1.1726)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_61',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.5388,1.3027,0.1169),(6.5840,0.2110,0.2438)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_62',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.5388,1.3027,0.1169),(6.0452,1.7533,0.9905)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_63',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.6600,2.3309,-1.9293),(6.4259,2.7417,-2.9103)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_64',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.7698,-0.5088,0.5013),(-4.3394,-0.7908,-0.2048)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_65',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5002,2.7469,-3.2656),(1.8108,2.6665,-3.9143)])]),
      ProtoInstance(DEF='digitoxigenin_karne_b_66',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.7691,1.9732,1.3470),(3.7194,2.9087,1.5046)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Digitoxigenin.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Digitoxigenin.py load and self-test diagnostics complete.")
