package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of Digitoxigenin.x3d scene produced from Digitoxigenin.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/DigitoxigeninIndex.html" target="_blank">Digitoxigenin</a>,  source <a href="../../../ChemicalMarkupLanguage/Digitoxigenin.java">Digitoxigenin.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Digitoxigenin.x3d">Digitoxigenin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of Digitoxigenin.x3d scene produced from Digitoxigenin.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Digitoxigenin.xml">Digitoxigenin.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Digitoxigenin.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Digitoxigenin.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class Digitoxigenin
{
	/** Default constructor to create this object. */
	public Digitoxigenin ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Digitoxigenin.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of Digitoxigenin.x3d scene produced from Digitoxigenin.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Digitoxigenin.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Digitoxigenin.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect Digitoxigenin").setPosition(0.0,2.0,20.0))
    .addComments(" <?xml-stylesheet type=\"text/xsl\" href=\"generic.xsl\" ?> ")
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"Digitoxigenin: "})))))
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1606,1.6552,-0.8847)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1997,0.1524,-1.1623)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.3838,-0.6669,0.0977)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.4275,-0.2242,1.2059)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.4096,1.2976,1.4632)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_6").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.4098,1.6499,2.5708)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_7").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.0361,1.3738,2.1457)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_8").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.3916,2.0360,0.8039)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_9").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.3399,1.7901,-0.3008)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_10").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.1140,2.0931,0.1658)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_11").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7681,2.5701,-1.5481)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_12").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.1105,2.0585,-2.0639)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_13").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.2569,2.2095,-1.0278)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_14").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.7981,1.6010,0.3349)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_15").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.9717,0.0748,0.1666)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_16").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.0160,-0.1450,-0.9304)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_17").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.4147,1.2521,-1.4990)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_18").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.6782,3.6838,-0.9321)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_19").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.3206,3.6128,0.3983)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_20").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.8099,1.6589,-1.1447)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_21").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.5388,1.3027,0.1169)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_22").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.6600,2.3309,-1.9293)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "digitoxigenin_karne_a_23").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.9463,2.4238,-1.2600)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_24").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.1542,1.9631,-0.5268)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_25").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.9345,2.1719,-1.8290)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_26").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.2536,-0.1427,-1.6394)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_27").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.0361,-0.0583,-1.8450)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_28").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1882,-1.7259,-0.1262)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_29").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.4104,-0.5380,0.9282)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "digitoxigenin_karne_a_30").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.7698,-0.5088,0.5013)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "digitoxigenin_karne_a_31").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.5002,2.7469,-3.2656)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "digitoxigenin_karne_a_32").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.7691,1.9732,1.3470)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "digitoxigenin_karne_a_33").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.8648,1.8507,-0.0582)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "digitoxigenin_karne_a_34").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.0017,2.8700,-1.6562)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_35").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.7247,-0.7271,2.1379)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_36").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.4116,1.5894,1.8107)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_37").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.6396,1.0472,3.4618)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_38").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.5108,2.7178,2.8143)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_39").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.1744,0.2867,2.0503)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_40").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.7123,1.7627,2.9213)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_41").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.4233,3.1214,0.9800)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_42").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.3689,0.7204,-0.5556)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_43").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.8605,3.6364,-1.2942)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_44").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0072,2.4446,-2.3325)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_45").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.9935,0.9892,-2.2941)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_46").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.0155,-0.3830,-0.1266)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_47").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.3176,-0.3713,1.1107)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_48").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.5912,-0.7674,-1.7317)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_49").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.9014,-0.6437,-0.5091)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_50").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.3825,1.2027,-2.5975)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_51").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.9871,4.0420,-1.9253)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_52").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.5193,3.7800,-0.2298)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_53").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.8300,4.2850,-0.5730)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_54").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.3543,3.7963,0.7265)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_55").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.1316,4.1562,-0.5392)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_56").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.6224,3.9636,1.1726)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_57").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.5840,0.2110,0.2438)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_58").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.0452,1.7533,0.9905)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_59").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.4259,2.7417,-2.9103)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_60").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.3394,-0.7908,-0.2048)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_61").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.8108,2.6665,-3.9143)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "digitoxigenin_karne_a_62").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.7194,2.9087,1.5046))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1606,1.6552,-0.8847,-2.1997,0.1524,-1.1623})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1606,1.6552,-0.8847,-1.1140,2.0931,0.1658})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1997,0.1524,-1.1623,-2.3838,-0.6669,0.0977})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.3838,-0.6669,0.0977,-1.4275,-0.2242,1.2059})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.3838,-0.6669,0.0977,-3.7698,-0.5088,0.5013})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_6").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4096,1.2976,1.4632,-1.4275,-0.2242,1.2059})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_7").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4096,1.2976,1.4632,-0.4098,1.6499,2.5708})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_8").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.1140,2.0931,0.1658,-1.4096,1.2976,1.4632})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_9").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.4098,1.6499,2.5708,1.0361,1.3738,2.1457})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_10").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3916,2.0360,0.8039,1.0361,1.3738,2.1457})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_11").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3399,1.7901,-0.3008,1.3916,2.0360,0.8039})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_12").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3916,2.0360,0.8039,2.7981,1.6010,0.3349})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_13").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.1140,2.0931,0.1658,0.3399,1.7901,-0.3008})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_14").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3399,1.7901,-0.3008,0.7681,2.5701,-1.5481})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_15").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.1140,2.0931,0.1658,-1.3206,3.6128,0.3983})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_16").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7681,2.5701,-1.5481,2.1105,2.0585,-2.0639})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_17").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1105,2.0585,-2.0639,3.2569,2.2095,-1.0278})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_18").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1105,2.0585,-2.0639,2.5002,2.7469,-3.2656})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_19").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2569,2.2095,-1.0278,4.4147,1.2521,-1.4990})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_20").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2569,2.2095,-1.0278,3.6782,3.6838,-0.9321})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_21").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7981,1.6010,0.3349,3.2569,2.2095,-1.0278})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_22").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7981,1.6010,0.3349,2.9717,0.0748,0.1666})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_23").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7981,1.6010,0.3349,3.7691,1.9732,1.3470})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_24").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.9717,0.0748,0.1666,4.0160,-0.1450,-0.9304})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_25").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.4147,1.2521,-1.4990,4.0160,-0.1450,-0.9304})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_26").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.4147,1.2521,-1.4990,5.8099,1.6589,-1.1447})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_27").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.8099,1.6589,-1.1447,6.5388,1.3027,0.1169})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_28").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.7899,1.6589,-1.1447,6.640000000000001,2.3309,-1.9293})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_28_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.829899999999999,1.6589,-1.1447,6.68,2.3309,-1.9293})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_29").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.5388,1.3027,0.1169,7.8648,1.8507,-0.0582})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_30").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.6600,2.3309,-1.9293,7.9463,2.4238,-1.2600})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_31").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.9263,2.4238,-1.2600,8.9817,2.8700,-1.6562})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_31_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.9662999999999995,2.4238,-1.2600,9.0217,2.8700,-1.6562})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_32").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.9463,2.4238,-1.2600,7.8648,1.8507,-0.0582})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_33").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1606,1.6552,-0.8847,-3.1542,1.9631,-0.5268})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_34").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1606,1.6552,-0.8847,-1.9345,2.1719,-1.8290})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_35").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1997,0.1524,-1.1623,-1.2536,-0.1427,-1.6394})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_36").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1997,0.1524,-1.1623,-3.0361,-0.0583,-1.8450})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_37").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.3838,-0.6669,0.0977,-2.1882,-1.7259,-0.1262})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_38").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4275,-0.2242,1.2059,-0.4104,-0.5380,0.9282})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_39").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4275,-0.2242,1.2059,-1.7247,-0.7271,2.1379})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_40").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.4096,1.2976,1.4632,-2.4116,1.5894,1.8107})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_41").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.4098,1.6499,2.5708,-0.6396,1.0472,3.4618})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_42").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.4098,1.6499,2.5708,-0.5108,2.7178,2.8143})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_43").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.0361,1.3738,2.1457,1.1744,0.2867,2.0503})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_44").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.0361,1.3738,2.1457,1.7123,1.7627,2.9213})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_45").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3916,2.0360,0.8039,1.4233,3.1214,0.9800})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_46").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3399,1.7901,-0.3008,0.3689,0.7204,-0.5556})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_47").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7681,2.5701,-1.5481,0.8605,3.6364,-1.2942})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_48").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7681,2.5701,-1.5481,0.0072,2.4446,-2.3325})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_49").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1105,2.0585,-2.0639,1.9935,0.9892,-2.2941})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_50").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.9717,0.0748,0.1666,2.0155,-0.3830,-0.1266})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_51").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.9717,0.0748,0.1666,3.3176,-0.3713,1.1107})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_52").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.0160,-0.1450,-0.9304,3.5912,-0.7674,-1.7317})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_53").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.0160,-0.1450,-0.9304,4.9014,-0.6437,-0.5091})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_54").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.4147,1.2521,-1.4990,4.3825,1.2027,-2.5975})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_55").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.6782,3.6838,-0.9321,3.9871,4.0420,-1.9253})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_56").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.6782,3.6838,-0.9321,4.5193,3.7800,-0.2298})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_57").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.6782,3.6838,-0.9321,2.8300,4.2850,-0.5730})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_58").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3206,3.6128,0.3983,-2.3543,3.7963,0.7265})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_59").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3206,3.6128,0.3983,-1.1316,4.1562,-0.5392})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_60").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3206,3.6128,0.3983,-0.6224,3.9636,1.1726})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_61").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.5388,1.3027,0.1169,6.5840,0.2110,0.2438})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_62").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.5388,1.3027,0.1169,6.0452,1.7533,0.9905})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_63").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {6.6600,2.3309,-1.9293,6.4259,2.7417,-2.9103})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_64").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.7698,-0.5088,0.5013,-4.3394,-0.7908,-0.2048})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_65").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.5002,2.7469,-3.2656,1.8108,2.6665,-3.9143})))))
      .addChild(new ProtoInstance("line", "digitoxigenin_karne_b_66").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.7691,1.9732,1.3470,3.7194,2.9087,1.5046})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Digitoxigenin model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Digitoxigenin().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.Digitoxigenin\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.Digitoxigenin self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/Digitoxigenin_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/Digitoxigenin_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/Digitoxigenin_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/Digitoxigenin_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
