####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Cortisone.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='Cortisone.x3d',name='title'),
    meta(content='Autogenerated version of Cortisone.x3d scene produced from Cortisone.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='Cortisone.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Cortisone.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect Cortisone',position=(0,2,20)),
    #  Copyright by the U.S. Sec. Commerce on behalf of U.S.A. All rights reserved. 
    #  type="3D" <date day="5" month="2" year="2010"/> 
    #  <?xml-stylesheet type="text/xsl" href="generic.xsl" ?> 
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["Cortisone: C21 H28 O5"])])]),
      Transform(translation=(0,5,0),
        children=[
        ProtoInstance(name='ano1_text',
          fieldValue=[
          fieldValue(name='txt',value=["molecular weight: 360.44"])])]),
      Transform(
        children=[
        ProtoInstance(name='ano2_text',
          fieldValue=[
          fieldValue(name='txt',value=["CAS: 53-06-5"])])])]),
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_1',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1880,4.0906,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1880,2.9931,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_3',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1880,1.9954,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.1358,3.2924,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.3400,3.4919,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.3400,1.4965,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_7',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.1358,1.6961,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_8',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.9340,3.8910,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_9',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(6.1358,4.2402,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_10',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(6.7345,2.4942,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_11',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.4421,2.9931,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_12',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.4421,1.9954,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_13',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.3400,0.4988,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(7.8818,3.4919,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_15',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(6.9340,4.8887,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_16',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(2.5940,3.4919,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.5940,1.4965,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_18',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.4421,0.0000,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_19',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(8.6800,4.0906,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_20',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.5940,2.4942,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_21',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.5940,0.4988,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_22',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.7460,1.9954,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_23',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.7460,0.0000,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_24',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.8979,1.4965,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_25',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.8979,0.4988,0))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cortisone_karne_a_26',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(0.0000,0.0000,0))])])]),
    Group(
      children=[
      ProtoInstance(DEF='cortisone_karne_b_1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1880,4.0906,0),(5.1880,2.9931,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1880,2.9931,0),(5.1880,1.9954,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1880,2.9931,0),(6.1358,3.2924,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.3400,3.4919,0),(5.1880,2.9931,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1880,1.9954,0),(4.3400,1.4965,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.1358,1.6961,0),(5.1880,1.9954,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.9340,3.8910,0),(6.1358,3.2924,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.1358,4.2402,0),(6.1358,3.2924,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.1358,3.2924,0),(6.7345,2.4942,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.7345,2.4942,0),(6.1358,1.6961,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.4421,2.9931,0),(4.3400,3.4919,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.4421,1.9954,0),(4.3400,1.4965,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.4421,1.9954,0),(3.4421,2.9931,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.3400,1.4965,0),(4.3400,0.4988,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.9340,3.8910,0),(7.8818,3.4919,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.914000000000001,4.8887,0),(6.914000000000001,3.8910,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_16_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(6.954,4.8887,0),(6.954,3.8910,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.574,3.4919,0),(3.4221,2.9931,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_17_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.614,3.4919,0),(3.4621,2.9931,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5940,1.4965,0),(3.4421,1.9954,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.3400,0.4988,0),(3.4421,0.0000,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.6800,4.0906,0),(7.8818,3.4919,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5940,2.4942,0),(2.5940,1.4965,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.5940,1.4965,0),(2.5940,0.4988,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.4421,0.0000,0),(2.5940,0.4988,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.7460,1.9954,0),(2.5940,1.4965,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.574,0.4988,0),(1.726,0.0000,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_25_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.614,0.4988,0),(1.766,0.0000,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.8979,1.4965,0),(1.7460,1.9954,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.7460,0.0000,0),(0.8979,0.4988,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.8979,0.4988,0),(0.8979,1.4965,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.8779,0.4988,0),(-0.02,0.0000,0)])]),
      ProtoInstance(DEF='cortisone_karne_b_29_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.9179,0.4988,0),(0.02,0.0000,0)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Cortisone.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Cortisone.py load and self-test diagnostics complete.")
