<?xml version="1.0"?>
<xsl:stylesheet version="2.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:saxon="http://icl.com/saxon"
                saxon:trace="no"
                extension-element-prefixes="saxon"
                xmlns:date="http://exslt.org/dates-and-times">
        
<!--
  Copyright (c) 1995-2025 held by the author(s).  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
    * Neither the names of the Naval Postgraduate School (NPS)
      Modeling Virtual Environments and Simulation (MOVES) Institute
      (https://www.nps.edu and https://MovesInstitute.nps.edu)
      nor the names of its contributors may be used to endorse or
      promote products derived from this software without specific
      prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
-->
    <!--
  <head>
    <meta name="filename"    content="cmlToX3d_3.xsl" />
    <meta name="author"      content="Nicholas F. Polys" />
    <meta name="revisions"   content="Don Brutzman" />
    <meta name="created"     content="September 2002" />
    <meta name="description" content="XSLT stylesheet to convert CML-XML files to X3D-XML files" />
  </head>

    Building examples:  use X3D examples: archive top levcml el, build.xml task convertCmlScenes
    
    Recommended XSLT tools:
    -  Gnome Libs and Perl Modules
    -  SAXON XML Toolkit (and Instant Saxon) https://saxonica.com/welcome/welcome.xml
    - Can also be used with Apache server, Xalan & Cocoon

    TODO:  add DTD or schema information to make CML files validatable
    -->
    <!-- <xsl:strip-space elements="*" />   -->
    <xsl:output method="xml" encoding="UTF-8" media-type="model/x3d+xml" cdata-section-elements="Script" indent="yes" doctype-public="ISO//Web3D//DTD X3D 4.0//EN" doctype-system="https://www.web3d.org/specifications/x3d-4.0.dtd"/>

    <xsl:variable name="filename">
        <!-- normalize naming: no embedded spaces, convert hyphen to underscore -->
        <xsl:value-of select="translate(translate(//molecule/@title,' ',''),'-','_')"/>
    </xsl:variable>
    
    <xsl:variable name="todaysDate">
        <xsl:text>2 JAN 2025</xsl:text>
        <xsl:message>*** warning, todaysDate value is currently hard coded</xsl:message>
       <!-- TODO <xsl:value-of select="current-date()"/> -->
            <!-- taken out of saxon HE :(
        <xsl:value-of select="date:day-in-month()"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="date:month-name()"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="date:year()"/>
            -->
    </xsl:variable>
    
    <xsl:template match="/">
        <X3D version="4.0" profile="Immersive" xsl:exclude-result-prefixes="date fn" xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='https://www.web3d.org/specifications/x3d-4.0.xsd'>
            <head>
                <meta name="title" content="{$filename}.x3d"/>
                <meta name="description" content="Autogenerated version of {$filename}.x3d scene produced from {$filename}.xml Chemical Markup Language (CML) version 1.0 source file."/>
                <meta name="creator" content="Nicholas F. Polys"/> <!--  using cml2x3d_sample.xsl -->
                <meta name="translator" content="Don Brutzman"/>
                <meta name="created" content="24 November 2005"/>
                <meta name="translated" content="{$todaysDate}"/>
                <meta name="modified" content="{$todaysDate}"/>
                <meta name="reference" content="{$filename}.xml"/>
                <meta name="reference" content="CML sources https://www.xml-cml.org"/>
                <meta name="reference" content="Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"/>
                <meta name="reference" content="JUMBO Chemical Format Conversion Tool"/>
                <meta name="reference" content="https://webbook.nist.gov/chemistry"/>
                <meta name="reference" content="Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"/>
                <meta name='reference' content='Originally Published in Proceedings of Web3D 2003, ACM Press'/> 
                <meta name="generator" content="CmlToX3d.xslt"/>
                <!-- TODO move to local directory, then add meta reference to corresponding build.xml -->
                <meta name="identifier" content="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/{$filename}.x3d"/>
                <meta name='license' content='../license.html'/> 
            </head>
            <Scene>
                <!-- Insert  EXTERN / PROTO declarations, if not otherwise provided

                # render-style prototypes
                # atom billboard sphere defs
                # bond line
                # Fonts- Formula
                #      - annotation 1
                #      - annotation 2  -->
                <ProtoDeclare name="Carbon">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoC">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoC_mat" diffuseColor="0 0 0" shininess=".8" specularColor=".29 .3 .29">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius=".77"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"C"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Hydrogen">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoH">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoH_mat" ambientIntensity=".0933" diffuseColor=".38 .38 .42" shininess="0.5" specularColor=".53 .53 .53">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius=".32"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"H"'>
                                        <FontStyle size=".4"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Nitrogen">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoN">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoN_mat" diffuseColor="0 0 .72" emissiveColor="0 0 .13" specularColor=".5 .5 .5">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius=".75"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"N"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Oxygen">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoO">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoO_mat" ambientIntensity=".487" diffuseColor=".54 .05 .25" shininess=".2" specularColor=".81 .77 .75">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius=".73"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"O"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Fluorine">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoF">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoF_mat" diffuseColor="1 .48 .79" emissiveColor=".09 .04 .07">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius=".72"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"F"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Silicon">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoSi">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoSi_mat" diffuseColor=".8 .8 .8">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.18"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"Si"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Phosphorus">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoP">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoP_mat" ambientIntensity=".11" diffuseColor=".9 .41 0" emissiveColor=".1 .04 0" shininess="0.8" specularColor=".1 .1 .1">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.1"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"P"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Sulphur">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoS">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoS_mat" ambientIntensity=".0467" diffuseColor=".25 .39 .25" emissiveColor=".05 .08 .05" shininess="0.6" specularColor=" .11 .12 .08">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.3"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"S"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Chlorine">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoCl">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoCl_mat" diffuseColor=".28 .7 0" emissiveColor=".06 .15 0" shininess="0.8" specularColor=".5 .5 .5">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.01"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"Cl"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Bromine">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoBr">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoBr_mat" ambientIntensity=".0833" diffuseColor=".5 .3 .19" emissiveColor=".12 .13 .08" shininess="0.17" specularColor=".08 .08 .05">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.14"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"Br"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="Iodine">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="atoI">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="atoI_mat" diffuseColor=".56 .37 .74" emissiveColor=".15 .1 .2" shininess=".09" specularColor=".12 .12 .12">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.33"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"I"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="unknown">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="position" type="SFVec3f" value="0 0 0"/>
                        <field accessType="inputOutput" name="materialTransparency" type="SFFloat" value=".6"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Transform DEF="ato_">
                                <IS>
                                    <connect nodeField="translation" protoField="position"/>
                                </IS>
                                <Shape>
                                    <Appearance>
                                        <Material DEF="ato__mat" diffuseColor="1 1 1" emissiveColor=".15 .1 .2" shininess=".09" specularColor=".12 .12 .12">
                                            <IS>
                                                <connect nodeField="transparency" protoField="materialTransparency"/>
                                            </IS>
                                        </Material>
                                    </Appearance>
                                    <Sphere radius="1.001"/>
                                </Shape>
                                <Shape>
                                    <Appearance>
                                        <Material diffuseColor="0.9 0.9 0.9"/>
                                    </Appearance>
                                    <Text string='"?"'>
                                        <FontStyle size=".8"/>
                                    </Text>
                                </Shape>
                            </Transform>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="line">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="bond_set" type="MFVec3f" value="-1 0 0, 1 0 0"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Group>
                            <Shape>
                                <Appearance>
                                    <Material diffuseColor="1 1 1" emissiveColor="1 1 1"/>
                                </Appearance>
                                <IndexedLineSet coordIndex="0, 1, -1 ">
                                    <Coordinate DEF="bondo">
                                        <IS>
                                            <connect nodeField="point" protoField="bond_set"/>
                                        </IS>
                                    </Coordinate>
                                </IndexedLineSet>
                            </Shape>
                        </Group>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="title_text">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="txt" type="MFString"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Transform>
                            <Group>
                                <Transform>
                                    <Shape>
                                        <Appearance>
                                            <Material diffuseColor="0.9 0.9 0.9"/>
                                        </Appearance>
                                        <Text DEF="cmpd_name">
                                            <IS>
                                                <connect nodeField="string" protoField="txt"/>
                                            </IS>
                                            <FontStyle/> <!--  size="1" -->
                                        </Text>
                                    </Shape>
                                </Transform>
                            </Group>
                        </Transform>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="ano1_text">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="txt" type="MFString"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Transform>
                            <Group>
                                <Transform>
                                    <Shape>
                                        <Appearance>
                                            <Material diffuseColor="0.9 0.9 0.9"/>
                                        </Appearance>
                                        <Text DEF="cmpd_name1">
                                            <IS>
                                                <connect nodeField="string" protoField="txt"/>
                                            </IS>
                                            <FontStyle size=".8"/>
                                        </Text>
                                    </Shape>
                                </Transform>
                            </Group>
                        </Transform>
                    </ProtoBody>
                </ProtoDeclare>
                <ProtoDeclare name="ano2_text">
                    <ProtoInterface>
                        <field accessType="inputOutput" name="txt" type="MFString"/>
                    </ProtoInterface>
                    <ProtoBody>
                        <Transform>
                            <Group>
                                <Transform>
                                    <Shape>
                                        <Appearance>
                                            <Material diffuseColor="0.9 0.9 0.9"/>
                                        </Appearance>
                                        <Text DEF="cmpd_name2">
                                            <IS>
                                                <connect nodeField="string" protoField="txt"/>
                                            </IS>
                                            <FontStyle size=".6"/>
                                        </Text>
                                    </Shape>
                                </Transform>
                            </Group>
                        </Transform>
                    </ProtoBody>
                </ProtoDeclare>
                <!-- 	# spectrum graphs
                # HUD interface & text screens? -->
                <!-- Insert NavigationInfo , Viewpoint, and Background if not otherwise provided -->
                <Background groundAngle="1.309, 1.570796" groundColor="0 0.5 0.7, 0 0.4 0.7, 0.6 0.5 0.7" skyAngle="1.309, 1.570796" skyColor="0 0.5 0.8, 0 0.6 .7, 0.6 0.6 0.7"/>
                <PointLight ambientIntensity="1" location="0 0 5" radius="30"/>
                <!--
                <Inline url="space/GridXY_20x20Movable.x3d"/>
                <Inline url="space/GridXZ_20x20Movable.x3d"/>
                <Inline url="space/GridYZ_20x20Movable.x3d"/>
                -->
                <NavigationInfo type='"EXAMINE" "FLY" "ANY"'/>
                <Viewpoint description="Inspect {$filename}" position="0 2 20"/>
                <xsl:apply-templates/>
            </Scene>
        </X3D>
    </xsl:template>

    <!-- ****** XML comments ****** -->
    <xsl:template match="comment() | comment"> <!-- 'comment' is an element name in CML -->
        <xsl:comment><xsl:value-of select="."/></xsl:comment>
    </xsl:template>
    
    <!-- <xsl:template match="cml">
    <xsl:call-template name="molecule"/>
    # <xsl:call-template name="chimeral:spectrum"/>
    </xsl:template> -->
    <xsl:template match="molecule" name="molecule">
        <!--         # manifest molecule info in scene via text nodes    -->
        <Transform DEF="infogroupa" translation="-8 2 -4" xsl:exclude-result-prefixes="date fn">
            <Transform translation="0 6 0">
                <Viewpoint description="title billboard" position="6 -2 10"/>
                <ProtoInstance name="title_text">
                    <xsl:variable name="fullname" select="concat(@title,': ', .//formula)"/>
                    <fieldValue>
                        <xsl:attribute name="name">txt</xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                            <xsl:value-of select="$fullname"/>
                            <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                        </xsl:attribute>
                    </fieldValue>
                </ProtoInstance>
            </Transform>
            <!-- #recurse text positioning           -->
            <xsl:variable name="begin1" select="6"/>
            <xsl:for-each select="./float">
                <xsl:variable name="place" select="position()"/>
                <xsl:variable name="tpl" select="$begin1 - $place"/>
                <xsl:variable name="txtPos" select="concat('0 ',$tpl,' 0')"/>
                <Transform>
                    <xsl:if test="($txtPos != '0 0 0') and ($txtPos != '0.0 0.0 0.0')">
                        <xsl:attribute name="translation"><xsl:value-of select="$txtPos"/></xsl:attribute>
                    </xsl:if>
                    <ProtoInstance name="ano1_text">
                        <fieldValue>
                            <xsl:attribute name="name">txt</xsl:attribute>
                            <xsl:attribute name="value">
                                <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                                <xsl:value-of select="concat (@*,': ',.)"/>
                                <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                            </xsl:attribute>
                        </fieldValue>
                        <!--  		# <float title="melting point" units="degC">238</float>      -->
                    </ProtoInstance>
                </Transform>
            </xsl:for-each>
            <!-- #recurse text positioning     -->
            <xsl:variable name="begin2" select="1"/>
            <xsl:for-each select="./string">
                <xsl:variable name="place" select="position()"/>
                <xsl:variable name="tpl" select="$begin2 - $place"/>
                <xsl:variable name="txtPos" select="concat('0 ',$tpl,' 0')"/>
                <Transform>
                    <xsl:if test="($txtPos != '0 0 0') and ($txtPos != '0.0 0.0 0.0')">
                        <xsl:attribute name="translation"><xsl:value-of select="$txtPos"/></xsl:attribute>
                    </xsl:if>
                    <ProtoInstance name="ano2_text">
                        <fieldValue>
                            <xsl:attribute name="name">txt</xsl:attribute>
                            <xsl:attribute name="value">
                                <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                                <xsl:value-of select="concat (@*,': ',.)"/>
                                <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
                            </xsl:attribute>
                        </fieldValue>
                        <!--                 # <string title="water solubility" units="g/100 mL" convention="g per 100 mL at 23 degC">1-5</string>     -->
                    </ProtoInstance>
                </Transform>
            </xsl:for-each>
        </Transform>
        <xsl:apply-templates/>
    </xsl:template>
    <!--  	 #</molecule>-->
    <xsl:template match="molecule/float">
    </xsl:template>
    <xsl:template match="molecule/string">
    </xsl:template>
    <xsl:template match="molecule/date">
    </xsl:template>
    <xsl:template match="molecule/formula">
    </xsl:template>
    <xsl:template match="molecule/list">
    </xsl:template>
    <xsl:template match="chimeral/*">
    </xsl:template>
    <xsl:template match="chimeral/spectrum">
    </xsl:template>
    <xsl:template match="chimeral/string">
    </xsl:template>
    <xsl:template match="chimeral/float">
    </xsl:template>
    <xsl:template match="chimeral/list">
    </xsl:template>
    <xsl:template match="atomArray">
        <!--       # manifest atom geometry in scene
        #<atomArray>
        #atoms                                    -->
        <Group xsl:exclude-result-prefixes="date fn">
            <xsl:for-each select="atom">
                <xsl:choose>
                    <xsl:when test=".//float[@builtin='x3']">
                        <!--    3D Molecule build                         -->
                        <xsl:variable name="elem" select=".//string[@builtin='elementType']"/>
                        <xsl:variable name="elemID" select="@id"/>
                        <xsl:variable name="elemX" select=".//float[@builtin='x3']"/>
                        <xsl:variable name="elemY" select=".//float[@builtin='y3']"/>
                        <xsl:variable name="elemZ" select=".//float[@builtin='z3']"/>
                        <xsl:variable name="elemPos" select="concat ($elemX,' ',$elemY,' ',$elemZ)"/>
                        <xsl:choose>
                            <xsl:when test="$elem = 'N'">
                                <Transform>
                                    <ProtoInstance name="Nitrogen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'H'">
                                <Transform>
                                    <ProtoInstance name="Hydrogen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'C'">
                                <Transform>
                                    <ProtoInstance name="Carbon">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'O'">
                                <Transform>
                                    <ProtoInstance name="Oxygen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'F'">
                                <Transform>
                                    <ProtoInstance name="Fluorine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Si'">
                                <Transform>
                                    <ProtoInstance name="Silicon">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'P'">
                                <Transform>
                                    <ProtoInstance name="Phosphorus">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'S'">
                                <Transform>
                                    <ProtoInstance name="Sulphur">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Cl'">
                                <Transform>
                                    <ProtoInstance name="Chlorine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Br'">
                                <Transform>
                                    <ProtoInstance name="Bromine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'I'">
                                <Transform>
                                    <ProtoInstance name="Iodine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:otherwise>
                                <Transform>
                                    <ProtoInstance DEF="unknown" name="unknown">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <!--     </xsl:when 3D>            -->
                    <xsl:otherwise>
                        <xsl:variable name="elem" select=".//string[@builtin='elementType']"/>
                        <xsl:variable name="elemID" select="@id"/>
                        <xsl:variable name="elemX" select=".//float[@builtin='x2']"/>
                        <xsl:variable name="elemY" select=".//float[@builtin='y2']"/>
                        <xsl:variable name="elemZ" select="0"/>
                        <xsl:variable name="elemPos" select="concat ($elemX,' ',$elemY,' ',$elemZ)"/>
                        <xsl:choose>
                            <xsl:when test="$elem = 'N'">
                                <Transform>
                                    <ProtoInstance name="Nitrogen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'H'">
                                <Transform>
                                    <ProtoInstance name="Hydrogen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'C'">
                                <Transform>
                                    <ProtoInstance name="Carbon">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'O'">
                                <Transform>
                                    <ProtoInstance name="Oxygen">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'F'">
                                <Transform>
                                    <ProtoInstance name="Fluorine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Si'">
                                <Transform>
                                    <ProtoInstance name="Silicon">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'P'">
                                <Transform>
                                    <ProtoInstance name="Phosphorus">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'S'">
                                <Transform>
                                    <ProtoInstance name="Sulphur">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Cl'">
                                <Transform>
                                    <ProtoInstance name="Chlorine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'Br'">
                                <Transform>
                                    <ProtoInstance name="Bromine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:when test="$elem = 'I'">
                                <Transform>
                                    <ProtoInstance name="Iodine">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:when>
                            <xsl:otherwise>
                                <Transform>
                                    <ProtoInstance DEF="unknown" name="unknown">
                                        <xsl:attribute name="DEF"><xsl:value-of select="$elemID"/></xsl:attribute>
                                        <fieldValue>
                                            <xsl:attribute name="name">position</xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="$elemPos"/></xsl:attribute>
                                        </fieldValue>
                                    </ProtoInstance>
                                </Transform>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </Group>
    </xsl:template>
    <!--    close atomArray template            -->
    <!--    close atomArray template            -->
    <xsl:template match="bondArray">
        <!--            # manifest bond geometry in scene
        #<bondArray>
        #bonds   -->
        <Group xsl:exclude-result-prefixes="date fn">
            <xsl:for-each select="bond">
                <xsl:variable name="ptA" select=".//string[@builtin='atomRef'][1]"/>
                <xsl:variable name="ptB" select=".//string[@builtin='atomRef'][2]"/>
                <xsl:variable name="order" select=".//string[@builtin='order']"/>
                <xsl:variable name="aNod" select="//atom[@id=$ptA]"/>
                <xsl:variable name="bNod" select="//atom[@id=$ptB]"/>
                <xsl:choose>
                    <xsl:when test="$order = 1">
                        <xsl:choose>
                            <xsl:when test="$aNod/float[@builtin='x3']">
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZa" select="$aNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosa" select="concat ($elemXa,' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZb" select="$bNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosb" select="concat ($elemXb,' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZa" select="0"/>
                                <xsl:variable name="elemPosa" select="concat ($elemXa,' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZb" select="0"/>
                                <xsl:variable name="elemPosb" select="concat ($elemXb,' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$order = 2">
                        <xsl:choose>
                            <xsl:when test="$aNod/float[@builtin='x3']">
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZa" select="$aNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosa" select="concat (($elemXa - .02),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa2" select="concat (($elemXa + .02),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZb" select="$bNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosb" select="concat (($elemXb - .02),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb2" select="concat (($elemXb + .02),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="pset2" select="concat($elemPosa2,', ',$elemPosb2)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_2')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset2"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZa" select="0"/>
                                <xsl:variable name="elemPosa" select="concat (($elemXa - .02),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa2" select="concat (($elemXa + .02),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZb" select="0"/>
                                <xsl:variable name="elemPosb" select="concat (($elemXb - .02),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb2" select="concat (($elemXb + .02),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="pset2" select="concat($elemPosa2,', ',$elemPosb2)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_2')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset2"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$order = 3">
                        <xsl:choose>
                            <xsl:when test="$aNod/float[@builtin='x3']">
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZa" select="$aNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosa" select="concat ($elemXa,' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa2" select="concat (($elemXa + .04),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa3" select="concat (($elemXa - .04),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x3']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y3']"/>
                                <xsl:variable name="elemZb" select="$bNod/float[@builtin='z3']"/>
                                <xsl:variable name="elemPosb" select="concat ($elemXb,' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb2" select="concat (($elemXb + .04),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb3" select="concat (($elemXb - .04),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="pset2" select="concat($elemPosa2,', ',$elemPosb2)"/>
                                <xsl:variable name="pset3" select="concat($elemPosa3,', ',$elemPosb3)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_2')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset2"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_3')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset3"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="elemXa" select="$aNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYa" select="$aNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZa" select="0"/>
                                <xsl:variable name="elemPosa" select="concat ($elemXa,' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa2" select="concat (($elemXa + .04),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemPosa3" select="concat (($elemXa - .04),' ',$elemYa,' ',$elemZa)"/>
                                <xsl:variable name="elemXb" select="$bNod/float[@builtin='x2']"/>
                                <xsl:variable name="elemYb" select="$bNod/float[@builtin='y2']"/>
                                <xsl:variable name="elemZb" select="0"/>
                                <xsl:variable name="elemPosb" select="concat ($elemXb,' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb2" select="concat (($elemXb + .04),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="elemPosb3" select="concat (($elemXb - .04),' ',$elemYb,' ',$elemZb)"/>
                                <xsl:variable name="pset" select="concat($elemPosa,', ',$elemPosb)"/>
                                <xsl:variable name="pset2" select="concat($elemPosa2,', ',$elemPosb2)"/>
                                <xsl:variable name="pset3" select="concat($elemPosa3,', ',$elemPosb3)"/>
                                <xsl:variable name="bondID" select="@id"/>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="$bondID"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_2')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset2"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                                <ProtoInstance name="line">
                                    <xsl:attribute name="DEF"><xsl:value-of select="concat($bondID,'_3')"/></xsl:attribute>
                                    <fieldValue>
                                        <xsl:attribute name="name">bond_set</xsl:attribute>
                                        <xsl:attribute name="value"><xsl:value-of select="$pset3"/></xsl:attribute>
                                    </fieldValue>
                                </ProtoInstance>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </Group>
    </xsl:template>
    <!--         #	<xsl:include href="CML_chim.xsl"/>           -->
</xsl:stylesheet>
