####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Cholesterol.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='Cholesterol.x3d',name='title'),
    meta(content='Autogenerated version of Cholesterol.x3d scene produced from Cholesterol.xml Chemical Markup Language (CML) version 1.0 source file.',name='description'),
    meta(content='Nicholas F. Polys',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='24 November 2005',name='created'),
    meta(content='2 JAN 2025',name='translated'),
    meta(content='2 JAN 2025',name='modified'),
    meta(content='Cholesterol.xml',name='reference'),
    meta(content='CML sources https://www.xml-cml.org',name='reference'),
    meta(content='Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language',name='reference'),
    meta(content='JUMBO Chemical Format Conversion Tool',name='reference'),
    meta(content='https://webbook.nist.gov/chemistry',name='reference'),
    meta(content='Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf',name='reference'),
    meta(content='Originally Published in Proceedings of Web3D 2003, ACM Press',name='reference'),
    meta(content='CmlToX3d.xslt',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Cholesterol.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    ProtoDeclare(name='Carbon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoC',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoC_mat',diffuseColor=(0,0,0),shininess=.8,specularColor=(.29,.3,.29),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.77)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["C"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Hydrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoH',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoH_mat',ambientIntensity=.0933,diffuseColor=(.38,.38,.42),shininess=0.5,specularColor=(.53,.53,.53),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.32)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["H"],
                fontStyle=FontStyle(size=.4)))])])])),
    ProtoDeclare(name='Nitrogen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoN',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoN_mat',diffuseColor=(0,0,.72),emissiveColor=(0,0,.13),specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.75)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["N"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Oxygen',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoO',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoO_mat',ambientIntensity=.487,diffuseColor=(.54,.05,.25),shininess=.2,specularColor=(.81,.77,.75),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.73)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["O"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Fluorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoF',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoF_mat',diffuseColor=(1,.48,.79),emissiveColor=(.09,.04,.07),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=.72)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["F"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Silicon',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoSi',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoSi_mat',diffuseColor=(.8,.8,.8),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.18)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Si"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Phosphorus',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoP',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoP_mat',ambientIntensity=.11,diffuseColor=(.9,.41,0),emissiveColor=(.1,.04,0),shininess=0.8,specularColor=(.1,.1,.1),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.1)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["P"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Sulphur',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoS',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoS_mat',ambientIntensity=.0467,diffuseColor=(.25,.39,.25),emissiveColor=(.05,.08,.05),shininess=0.6,specularColor=(.11,.12,.08),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.3)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["S"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Chlorine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoCl',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoCl_mat',diffuseColor=(.28,.7,0),emissiveColor=(.06,.15,0),shininess=0.8,specularColor=(.5,.5,.5),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.01)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Cl"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Bromine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoBr',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoBr_mat',ambientIntensity=.0833,diffuseColor=(.5,.3,.19),emissiveColor=(.12,.13,.08),shininess=0.17,specularColor=(.08,.08,.05),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.14)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["Br"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='Iodine',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='atoI',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='atoI_mat',diffuseColor=(.56,.37,.74),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.33)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["I"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='unknown',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='position',type='SFVec3f',value=(0,0,0)),
        field(accessType='inputOutput',name='materialTransparency',type='SFFloat',value=.6)]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Transform(DEF='ato_',
            IS=IS(
              connect=[
              connect(nodeField='translation',protoField='position')]),
            children=[
            Shape(
              appearance=Appearance(
                material=Material(DEF='ato__mat',diffuseColor=(1,1,1),emissiveColor=(.15,.1,.2),shininess=.09,specularColor=(.12,.12,.12),
                  IS=IS(
                    connect=[
                    connect(nodeField='transparency',protoField='materialTransparency')]))),
              geometry=Sphere(radius=1.001)),
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(0.9,0.9,0.9))),
              geometry=Text(string=["?"],
                fontStyle=FontStyle(size=.8)))])])])),
    ProtoDeclare(name='line',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='bond_set',type='MFVec3f',value=[(-1,0,0),(1,0,0)])]),
      ProtoBody=ProtoBody(
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),emissiveColor=(1,1,1))),
            geometry=IndexedLineSet(coordIndex=[0,1,-1],
              coord=Coordinate(DEF='bondo',
                IS=IS(
                  connect=[
                  connect(nodeField='point',protoField='bond_set')]))))])])),
    ProtoDeclare(name='title_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(),))])])])])),
    ProtoDeclare(name='ano1_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name1',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.8)))])])])])),
    ProtoDeclare(name='ano2_text',
      ProtoInterface=ProtoInterface(
        field=[
        field(accessType='inputOutput',name='txt',type='MFString')]),
      ProtoBody=ProtoBody(
        children=[
        Transform(
          children=[
          Group(
            children=[
            Transform(
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(0.9,0.9,0.9))),
                geometry=Text(DEF='cmpd_name2',
                  IS=IS(
                    connect=[
                    connect(nodeField='string',protoField='txt')]),
                  fontStyle=FontStyle(size=.6)))])])])])),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0.5,0.7),(0,0.4,0.7),(0.6,0.5,0.7)],skyAngle=[1.309,1.570796],skyColor=[(0,0.5,0.8),(0,0.6,.7),(0.6,0.6,0.7)]),
    PointLight(ambientIntensity=1,location=(0,0,5),radius=30),
    NavigationInfo(type='"EXAMINE" "FLY" "ANY"'),
    Viewpoint(description='Inspect Cholesterol',position=(0,2,20)),
    #  <?xml-stylesheet type="text/xsl" href="generic.xsl" ?> 
    #  Copyright by the U.S. Sec. Commerce on behalf of U.S.A. All rights reserved. 
    #  type="3D" <date day="5" month="2" year="2010"/> 
    #  CML document - cholesterol - karne - 7/8/00 
    #  file converted from: MDL .mol 
    Transform(DEF='infogroupa',translation=(-8,2,-4),
      children=[
      Transform(translation=(0,6,0),
        children=[
        Viewpoint(description='title billboard',position=(6,-2,10)),
        ProtoInstance(name='title_text',
          fieldValue=[
          fieldValue(name='txt',value=["Cholesterol: C27 H46 O"])])]),
      Transform(translation=(0,5,0),
        children=[
        ProtoInstance(name='ano1_text',
          fieldValue=[
          fieldValue(name='txt',value=["molecule weight: 386.6598"])])]),
      Transform(translation=(0,4,0),
        children=[
        ProtoInstance(name='ano1_text',
          fieldValue=[
          fieldValue(name='txt',value=["melting point: 148.5"])])]),
      Transform(translation=(0,3,0),
        children=[
        ProtoInstance(name='ano1_text',
          fieldValue=[
          fieldValue(name='txt',value=["boiling point: 360"])])]),
      Transform(translation=(0,2,0),
        children=[
        ProtoInstance(name='ano1_text',
          fieldValue=[
          fieldValue(name='txt',value=["specific gravity: 1.067"])])]),
      Transform(
        children=[
        ProtoInstance(name='ano2_text',
          fieldValue=[
          fieldValue(name='txt',value=["CAS: 57-88-5"])])]),
      Transform(translation=(0,-1,0),
        children=[
        ProtoInstance(name='ano2_text',
          fieldValue=[
          fieldValue(name='txt',value=["ACX: I1001660"])])]),
      Transform(translation=(0,-2,0),
        children=[
        ProtoInstance(name='ano2_text',
          fieldValue=[
          fieldValue(name='txt',value=["RTECS: FZ8400000"])])])]),
    #  molecule specific information 
    Group(
      children=[
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_1',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.9901,2.1889,-1.8776))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_2',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.1059,1.6157,-0.9459))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_3',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.5787,1.7234,-0.4719))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_4',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-3.7797,1.0607,0.8120))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_5',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-2.8482,1.6003,1.9235))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_6',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.3720,1.5412,1.5004))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_7',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-0.4702,1.0060,2.3207))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_8',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.0043,1.0283,1.9762))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_9',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(1.3614,1.8701,0.8105))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_10',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.3215,1.7261,-0.3221))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_11',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.0963,2.1783,0.1259))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_12',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(0.7503,2.4279,-1.6345))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_13',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.1677,2.0593,-2.0888))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_14',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.1972,2.3720,-0.9408))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_15',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(2.7895,1.5563,0.2449))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_16',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.9663,1.6453,1.2237))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_17',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1354,1.5087,0.2960))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_18',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(4.6487,1.7527,-1.1872))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_19',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(3.2450,3.8521,-0.6813))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_20',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(-1.3066,3.6419,0.2349))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_21',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.6329,2.5278,-2.0553))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_22',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(5.1180,2.8440,-3.4537))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_23',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(7.0185,1.8022,-2.1116))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_24',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(8.1314,2.6591,-2.5153))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_25',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(9.4748,1.9697,-2.5572))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_26',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(10.6837,2.8620,-2.8793))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_27',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(10.5656,3.6361,-4.1508))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_28',name='Carbon',
          fieldValue=[
          fieldValue(name='position',value=(11.9428,2.0228,-2.7290))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_29',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.8702,0.5579,-1.1345))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_30',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-4.2306,1.2525,-1.2225))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_31',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-3.8443,2.7860,-0.3705))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_32',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-3.5980,-0.0166,0.6840))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_33',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.9845,0.9926,2.8302))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_34',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-3.1166,2.6452,2.1386))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_35',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.7974,0.5460,3.2519))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_36',name='Oxygen',
          fieldValue=[
          fieldValue(name='position',value=(-5.1826,1.2861,1.2631))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_37',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.3205,-0.0033,1.7620))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_38',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.5536,1.4060,2.8511))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_39',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(1.3568,2.9171,1.1476))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_40',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.2550,0.6517,-0.5486))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_41',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.7064,3.5158,-1.4783))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_42',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(0.0447,2.1427,-2.4288))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_43',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.4284,2.6460,-2.9820))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_44',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.2058,0.9869,-2.3304))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_45',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.7354,0.5091,-0.0874))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_46',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.9396,0.8285,1.9599))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_47',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.9804,2.6119,1.7486))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_48',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(5.5588,0.4972,0.3832))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_49',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(5.9031,2.2515,0.5587))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_50',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.5225,0.7794,-1.6839))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_51',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.5516,4.3755,-1.5989))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_52',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(3.9698,4.0607,0.1194))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_53',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(2.2486,4.2030,-0.3745))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_54',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-2.3393,3.8408,0.5573))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_55',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-1.1313,4.1114,-0.7442))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_56',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-0.6054,4.0592,0.9725))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_57',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(5.7945,3.4951,-1.5571))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_58',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(5.8860,3.4016,-4.0098))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_59',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.2048,3.4527,-3.3792))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_60',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(4.8914,1.9061,-3.9818))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_61',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(6.9441,0.9731,-2.8306))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_62',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(7.2381,1.4013,-1.1111))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_63',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(8.1969,3.4944,-1.8026))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_64',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(7.9155,3.0506,-3.5203))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_65',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(9.4247,1.1825,-3.3239))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_66',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(9.6484,1.5118,-1.5723))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_67',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(10.7271,3.6239,-2.0872))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_68',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(11.4721,4.2419,-4.2967))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_69',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(9.6877,4.2967,-4.0977))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_70',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(10.4502,2.9399,-4.9946))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_71',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(11.9217,1.5002,-1.7613))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_72',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(12.8265,2.6762,-2.7736))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_73',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(11.9910,1.2847,-3.5432))])]),
      Transform(
        children=[
        ProtoInstance(DEF='cholesterol_karne_a_74',name='Hydrogen',
          fieldValue=[
          fieldValue(name='position',value=(-5.7836,0.9649,0.6011))])])]),
    Group(
      children=[
      ProtoInstance(DEF='cholesterol_karne_b_1',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1059,1.6157,-0.9459),(-1.9901,2.1889,-1.8776)])]),
      ProtoInstance(DEF='cholesterol_karne_b_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.5787,1.7234,-0.4719),(-2.1059,1.6157,-0.9459)])]),
      ProtoInstance(DEF='cholesterol_karne_b_3',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1059,1.6157,-0.9459),(-1.0963,2.1783,0.1259)])]),
      ProtoInstance(DEF='cholesterol_karne_b_4',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.7797,1.0607,0.8120),(-3.5787,1.7234,-0.4719)])]),
      ProtoInstance(DEF='cholesterol_karne_b_5',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.7797,1.0607,0.8120),(-2.8482,1.6003,1.9235)])]),
      ProtoInstance(DEF='cholesterol_karne_b_6',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.1826,1.2861,1.2631),(-3.7797,1.0607,0.8120)])]),
      ProtoInstance(DEF='cholesterol_karne_b_7',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.8482,1.6003,1.9235),(-1.3720,1.5412,1.5004)])]),
      ProtoInstance(DEF='cholesterol_karne_b_8',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3920000000000001,1.5412,1.5004),(-0.4902,1.0060,2.3207)])]),
      ProtoInstance(DEF='cholesterol_karne_b_8_2',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.352,1.5412,1.5004),(-0.4502,1.0060,2.3207)])]),
      ProtoInstance(DEF='cholesterol_karne_b_9',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3720,1.5412,1.5004),(-1.0963,2.1783,0.1259)])]),
      ProtoInstance(DEF='cholesterol_karne_b_10',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.4702,1.0060,2.3207),(1.0043,1.0283,1.9762)])]),
      ProtoInstance(DEF='cholesterol_karne_b_11',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.0043,1.0283,1.9762),(1.3614,1.8701,0.8105)])]),
      ProtoInstance(DEF='cholesterol_karne_b_12',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3215,1.7261,-0.3221),(1.3614,1.8701,0.8105)])]),
      ProtoInstance(DEF='cholesterol_karne_b_13',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3614,1.8701,0.8105),(2.7895,1.5563,0.2449)])]),
      ProtoInstance(DEF='cholesterol_karne_b_14',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.0963,2.1783,0.1259),(0.3215,1.7261,-0.3221)])]),
      ProtoInstance(DEF='cholesterol_karne_b_15',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3215,1.7261,-0.3221),(0.7503,2.4279,-1.6345)])]),
      ProtoInstance(DEF='cholesterol_karne_b_16',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.0963,2.1783,0.1259),(-1.3066,3.6419,0.2349)])]),
      ProtoInstance(DEF='cholesterol_karne_b_17',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7503,2.4279,-1.6345),(2.1677,2.0593,-2.0888)])]),
      ProtoInstance(DEF='cholesterol_karne_b_18',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1677,2.0593,-2.0888),(3.1972,2.3720,-0.9408)])]),
      ProtoInstance(DEF='cholesterol_karne_b_19',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.1972,2.3720,-0.9408),(4.6487,1.7527,-1.1872)])]),
      ProtoInstance(DEF='cholesterol_karne_b_20',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.1972,2.3720,-0.9408),(3.2450,3.8521,-0.6813)])]),
      ProtoInstance(DEF='cholesterol_karne_b_21',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7895,1.5563,0.2449),(3.1972,2.3720,-0.9408)])]),
      ProtoInstance(DEF='cholesterol_karne_b_22',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7895,1.5563,0.2449),(3.9663,1.6453,1.2237)])]),
      ProtoInstance(DEF='cholesterol_karne_b_23',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.9663,1.6453,1.2237),(5.1354,1.5087,0.2960)])]),
      ProtoInstance(DEF='cholesterol_karne_b_24',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.6487,1.7527,-1.1872),(5.1354,1.5087,0.2960)])]),
      ProtoInstance(DEF='cholesterol_karne_b_25',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.6487,1.7527,-1.1872),(5.6329,2.5278,-2.0553)])]),
      ProtoInstance(DEF='cholesterol_karne_b_26',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.6329,2.5278,-2.0553),(5.1180,2.8440,-3.4537)])]),
      ProtoInstance(DEF='cholesterol_karne_b_27',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.6329,2.5278,-2.0553),(7.0185,1.8022,-2.1116)])]),
      ProtoInstance(DEF='cholesterol_karne_b_28',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.0185,1.8022,-2.1116),(8.1314,2.6591,-2.5153)])]),
      ProtoInstance(DEF='cholesterol_karne_b_29',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.1314,2.6591,-2.5153),(9.4748,1.9697,-2.5572)])]),
      ProtoInstance(DEF='cholesterol_karne_b_30',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.4748,1.9697,-2.5572),(10.6837,2.8620,-2.8793)])]),
      ProtoInstance(DEF='cholesterol_karne_b_31',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.6837,2.8620,-2.8793),(10.5656,3.6361,-4.1508)])]),
      ProtoInstance(DEF='cholesterol_karne_b_32',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.6837,2.8620,-2.8793),(11.9428,2.0228,-2.7290)])]),
      ProtoInstance(DEF='cholesterol_karne_b_33',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.1059,1.6157,-0.9459),(-1.8702,0.5579,-1.1345)])]),
      ProtoInstance(DEF='cholesterol_karne_b_34',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.5787,1.7234,-0.4719),(-4.2306,1.2525,-1.2225)])]),
      ProtoInstance(DEF='cholesterol_karne_b_35',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.5787,1.7234,-0.4719),(-3.8443,2.7860,-0.3705)])]),
      ProtoInstance(DEF='cholesterol_karne_b_36',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-3.7797,1.0607,0.8120),(-3.5980,-0.0166,0.6840)])]),
      ProtoInstance(DEF='cholesterol_karne_b_37',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.8482,1.6003,1.9235),(-2.9845,0.9926,2.8302)])]),
      ProtoInstance(DEF='cholesterol_karne_b_38',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-2.8482,1.6003,1.9235),(-3.1166,2.6452,2.1386)])]),
      ProtoInstance(DEF='cholesterol_karne_b_39',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-0.4702,1.0060,2.3207),(-0.7974,0.5460,3.2519)])]),
      ProtoInstance(DEF='cholesterol_karne_b_40',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.0043,1.0283,1.9762),(1.3205,-0.0033,1.7620)])]),
      ProtoInstance(DEF='cholesterol_karne_b_41',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.0043,1.0283,1.9762),(1.5536,1.4060,2.8511)])]),
      ProtoInstance(DEF='cholesterol_karne_b_42',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(1.3614,1.8701,0.8105),(1.3568,2.9171,1.1476)])]),
      ProtoInstance(DEF='cholesterol_karne_b_43',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.3215,1.7261,-0.3221),(0.2550,0.6517,-0.5486)])]),
      ProtoInstance(DEF='cholesterol_karne_b_44',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7503,2.4279,-1.6345),(0.7064,3.5158,-1.4783)])]),
      ProtoInstance(DEF='cholesterol_karne_b_45',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(0.7503,2.4279,-1.6345),(0.0447,2.1427,-2.4288)])]),
      ProtoInstance(DEF='cholesterol_karne_b_46',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1677,2.0593,-2.0888),(2.4284,2.6460,-2.9820)])]),
      ProtoInstance(DEF='cholesterol_karne_b_47',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.1677,2.0593,-2.0888),(2.2058,0.9869,-2.3304)])]),
      ProtoInstance(DEF='cholesterol_karne_b_48',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(2.7895,1.5563,0.2449),(2.7354,0.5091,-0.0874)])]),
      ProtoInstance(DEF='cholesterol_karne_b_49',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.9663,1.6453,1.2237),(3.9396,0.8285,1.9599)])]),
      ProtoInstance(DEF='cholesterol_karne_b_50',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.9663,1.6453,1.2237),(3.9804,2.6119,1.7486)])]),
      ProtoInstance(DEF='cholesterol_karne_b_51',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1354,1.5087,0.2960),(5.5588,0.4972,0.3832)])]),
      ProtoInstance(DEF='cholesterol_karne_b_52',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1354,1.5087,0.2960),(5.9031,2.2515,0.5587)])]),
      ProtoInstance(DEF='cholesterol_karne_b_53',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(4.6487,1.7527,-1.1872),(4.5225,0.7794,-1.6839)])]),
      ProtoInstance(DEF='cholesterol_karne_b_54',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2450,3.8521,-0.6813),(3.5516,4.3755,-1.5989)])]),
      ProtoInstance(DEF='cholesterol_karne_b_55',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2450,3.8521,-0.6813),(3.9698,4.0607,0.1194)])]),
      ProtoInstance(DEF='cholesterol_karne_b_56',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(3.2450,3.8521,-0.6813),(2.2486,4.2030,-0.3745)])]),
      ProtoInstance(DEF='cholesterol_karne_b_57',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3066,3.6419,0.2349),(-2.3393,3.8408,0.5573)])]),
      ProtoInstance(DEF='cholesterol_karne_b_58',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3066,3.6419,0.2349),(-1.1313,4.1114,-0.7442)])]),
      ProtoInstance(DEF='cholesterol_karne_b_59',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-1.3066,3.6419,0.2349),(-0.6054,4.0592,0.9725)])]),
      ProtoInstance(DEF='cholesterol_karne_b_60',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.6329,2.5278,-2.0553),(5.7945,3.4951,-1.5571)])]),
      ProtoInstance(DEF='cholesterol_karne_b_61',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1180,2.8440,-3.4537),(5.8860,3.4016,-4.0098)])]),
      ProtoInstance(DEF='cholesterol_karne_b_62',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1180,2.8440,-3.4537),(4.2048,3.4527,-3.3792)])]),
      ProtoInstance(DEF='cholesterol_karne_b_63',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(5.1180,2.8440,-3.4537),(4.8914,1.9061,-3.9818)])]),
      ProtoInstance(DEF='cholesterol_karne_b_64',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.0185,1.8022,-2.1116),(6.9441,0.9731,-2.8306)])]),
      ProtoInstance(DEF='cholesterol_karne_b_65',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(7.0185,1.8022,-2.1116),(7.2381,1.4013,-1.1111)])]),
      ProtoInstance(DEF='cholesterol_karne_b_66',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.1314,2.6591,-2.5153),(8.1969,3.4944,-1.8026)])]),
      ProtoInstance(DEF='cholesterol_karne_b_67',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(8.1314,2.6591,-2.5153),(7.9155,3.0506,-3.5203)])]),
      ProtoInstance(DEF='cholesterol_karne_b_68',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.4748,1.9697,-2.5572),(9.4247,1.1825,-3.3239)])]),
      ProtoInstance(DEF='cholesterol_karne_b_69',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(9.4748,1.9697,-2.5572),(9.6484,1.5118,-1.5723)])]),
      ProtoInstance(DEF='cholesterol_karne_b_70',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.6837,2.8620,-2.8793),(10.7271,3.6239,-2.0872)])]),
      ProtoInstance(DEF='cholesterol_karne_b_71',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.5656,3.6361,-4.1508),(11.4721,4.2419,-4.2967)])]),
      ProtoInstance(DEF='cholesterol_karne_b_72',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.5656,3.6361,-4.1508),(9.6877,4.2967,-4.0977)])]),
      ProtoInstance(DEF='cholesterol_karne_b_73',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(10.5656,3.6361,-4.1508),(10.4502,2.9399,-4.9946)])]),
      ProtoInstance(DEF='cholesterol_karne_b_74',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.9428,2.0228,-2.7290),(11.9217,1.5002,-1.7613)])]),
      ProtoInstance(DEF='cholesterol_karne_b_75',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.9428,2.0228,-2.7290),(12.8265,2.6762,-2.7736)])]),
      ProtoInstance(DEF='cholesterol_karne_b_76',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(11.9428,2.0228,-2.7290),(11.9910,1.2847,-3.5432)])]),
      ProtoInstance(DEF='cholesterol_karne_b_77',name='line',
        fieldValue=[
        fieldValue(name='bond_set',value=[(-5.1826,1.2861,1.2631),(-5.7836,0.9649,0.6011)])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Cholesterol.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Cholesterol.py load and self-test diagnostics complete.")
