package Basic.ChemicalMarkupLanguage;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Autogenerated version of Cholesterol.x3d scene produced from Cholesterol.xml Chemical Markup Language (CML) version 1.0 source file. </p>
 <p> Related links: Catalog page <a href="../../../ChemicalMarkupLanguage/CholesterolIndex.html" target="_blank">Cholesterol</a>,  source <a href="../../../ChemicalMarkupLanguage/Cholesterol.java">Cholesterol.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Cholesterol.x3d">Cholesterol.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Autogenerated version of Cholesterol.x3d scene produced from Cholesterol.xml Chemical Markup Language (CML) version 1.0 source file. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nicholas F. Polys </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 24 November 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 JAN 2025 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Cholesterol.xml">Cholesterol.xml</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> CML sources <a href="https://www.xml-cml.org" target="_blank">https://www.xml-cml.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Wikipedia <a href="https://en.wikipedia.org/wiki/Chemical_Markup_Language" target="_blank">https://en.wikipedia.org/wiki/Chemical_Markup_Language</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> JUMBO Chemical Format Conversion Tool </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://webbook.nist.gov/chemistry" target="_blank">https://webbook.nist.gov/chemistry</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf">Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Originally Published in Proceedings of Web3D 2003, ACM Press </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> CmlToX3d.xslt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Cholesterol.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Cholesterol.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../ChemicalMarkupLanguage/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nicholas F. Polys
 */

public class Cholesterol
{
	/** Default constructor to create this object. */
	public Cholesterol ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Cholesterol.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Autogenerated version of Cholesterol.x3d scene produced from Cholesterol.xml Chemical Markup Language (CML) version 1.0 source file."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nicholas F. Polys"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("24 November 2005"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 JAN 2025"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Cholesterol.xml"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("CML sources https://www.xml-cml.org"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Wikipedia https://en.wikipedia.org/wiki/Chemical_Markup_Language"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("JUMBO Chemical Format Conversion Tool"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://webbook.nist.gov/chemistry"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Polys.StylesheetTransformationsInteractiveVisualization.Web3d2003Symposium.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Originally Published in Proceedings of Web3D 2003, ACM Press"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("CmlToX3d.xslt"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/ChemicalMarkupLanguage/Cholesterol.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new ProtoDeclare("Carbon").setName("Carbon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoC")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoC_mat").setDiffuseColor(0.0,0.0,0.0).setShininess(.8).setSpecularColor(.29,.3,.29)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.77)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"C"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Hydrogen").setName("Hydrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoH")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoH_mat").setAmbientIntensity(.0933).setDiffuseColor(.38,.38,.42).setShininess(0.5).setSpecularColor(.53,.53,.53)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.32)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"H"})
                .setFontStyle(new FontStyle().setSize(.4))))))))
    .addChild(new ProtoDeclare("Nitrogen").setName("Nitrogen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoN")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoN_mat").setDiffuseColor(0.0,0.0,.72).setEmissiveColor(0.0,0.0,.13).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.75)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"N"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Oxygen").setName("Oxygen")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoO")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoO_mat").setAmbientIntensity(.487).setDiffuseColor(.54,.05,.25).setShininess(.2).setSpecularColor(.81,.77,.75)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.73)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"O"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Fluorine").setName("Fluorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoF")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoF_mat").setDiffuseColor(1.0,.48,.79).setEmissiveColor(.09,.04,.07)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(.72)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"F"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Silicon").setName("Silicon")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoSi")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoSi_mat").setDiffuseColor(.8,.8,.8)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.18)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Si"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Phosphorus").setName("Phosphorus")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoP")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoP_mat").setAmbientIntensity(.11).setDiffuseColor(.9,.41,0.0).setEmissiveColor(.1,.04,0.0).setShininess(0.8).setSpecularColor(.1,.1,.1)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.1)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"P"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Sulphur").setName("Sulphur")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoS")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoS_mat").setAmbientIntensity(.0467).setDiffuseColor(.25,.39,.25).setEmissiveColor(.05,.08,.05).setShininess(0.6).setSpecularColor(.11,.12,.08)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.3)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"S"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Chlorine").setName("Chlorine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoCl")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoCl_mat").setDiffuseColor(.28,.7,0.0).setEmissiveColor(.06,.15,0.0).setShininess(0.8).setSpecularColor(.5,.5,.5)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.01)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Cl"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Bromine").setName("Bromine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoBr")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoBr_mat").setAmbientIntensity(.0833).setDiffuseColor(.5,.3,.19).setEmissiveColor(.12,.13,.08).setShininess(0.17).setSpecularColor(.08,.08,.05)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.14)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"Br"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("Iodine").setName("Iodine")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("atoI")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("atoI_mat").setDiffuseColor(.56,.37,.74).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.33)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"I"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("unknown").setName("unknown")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("position").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new SFVec3f(0.0,0.0,0.0)))
        .addField(new field().setName("materialTransparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(.6)))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Transform("ato_")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("translation").setProtoField("position")))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("ato__mat").setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(.15,.1,.2).setShininess(.09).setSpecularColor(.12,.12,.12)
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("transparency").setProtoField("materialTransparency")))))
              .setGeometry(new Sphere().setRadius(1.001)))
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
              .setGeometry(new Text().setString(new String[] {"?"})
                .setFontStyle(new FontStyle().setSize(.8))))))))
    .addChild(new ProtoDeclare("line").setName("line")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("bond_set").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setValue(new MFVec3f(new MFVec3f(new double[] {-1.0,0.0,0.0,1.0,0.0,0.0})))))
      .setProtoBody(new ProtoBody()
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,1.0,1.0).setEmissiveColor(1.0,1.0,1.0)))
            .setGeometry(new IndexedLineSet().setCoordIndex(new int[] {0,1,-1})
              .setCoord(new Coordinate("bondo")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("point").setProtoField("bond_set")))))))))
    .addChild(new ProtoDeclare("title_text").setName("title_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle()))))))))
    .addChild(new ProtoDeclare("ano1_text").setName("ano1_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name1")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.8)))))))))
    .addChild(new ProtoDeclare("ano2_text").setName("ano2_text")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("txt").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
      .setProtoBody(new ProtoBody()
        .addChild(new Transform()
          .addChild(new Group()
            .addChild(new Transform()
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setDiffuseColor(0.9,0.9,0.9)))
                .setGeometry(new Text("cmpd_name2")
                  .setIS(new IS()
                    .addConnect(new connect().setNodeField("string").setProtoField("txt")))
                  .setFontStyle(new FontStyle().setSize(.6)))))))))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.5,0.7,0.0,0.4,0.7,0.6,0.5,0.7})).setSkyAngle(new double[] {1.309,1.570796}).setSkyColor(new MFColor(new double[] {0.0,0.5,0.8,0.0,0.6,.7,0.6,0.6,0.7})))
    .addChild(new PointLight().setAmbientIntensity(1).setLocation(0.0,0.0,5.0).setRadius(30))
    .addChild(new NavigationInfo().setType("\"EXAMINE\" \"FLY\" \"ANY\""))
    .addChild(new Viewpoint().setDescription("Inspect Cholesterol").setPosition(0.0,2.0,20.0))
    .addComments(" <?xml-stylesheet type=\"text/xsl\" href=\"generic.xsl\" ?> ")
    .addComments(" Copyright by the U.S. Sec. Commerce on behalf of U.S.A. All rights reserved. ")
    .addComments(" type=\"3D\" <date day=\"5\" month=\"2\" year=\"2010\"/> ")
    .addComments(" CML document - cholesterol - karne - 7/8/00 ")
    .addComments(" file converted from: MDL .mol ")
    .addChild(new Transform("infogroupa").setTranslation(-8.0,2.0,-4.0)
      .addChild(new Transform().setTranslation(0.0,6.0,0.0)
        .addChild(new Viewpoint().setDescription("title billboard").setPosition(6.0,-2.0,10.0))
        .addChild(new ProtoInstance("title_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"Cholesterol: C27 H46 O"}))))
      .addChild(new Transform().setTranslation(0.0,5.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"molecule weight: 386.6598"}))))
      .addChild(new Transform().setTranslation(0.0,4.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"melting point: 148.5"}))))
      .addChild(new Transform().setTranslation(0.0,3.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"boiling point: 360"}))))
      .addChild(new Transform().setTranslation(0.0,2.0,0.0)
        .addChild(new ProtoInstance("ano1_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"specific gravity: 1.067"}))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"CAS: 57-88-5"}))))
      .addChild(new Transform().setTranslation(0.0,-1.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"ACX: I1001660"}))))
      .addChild(new Transform().setTranslation(0.0,-2.0,0.0)
        .addChild(new ProtoInstance("ano2_text").setContainerField("children")
          .addFieldValue(new fieldValue().setName("txt").setValue(new String[] {"RTECS: FZ8400000"})))))
    .addComments(" molecule specific information ")
    .addChild(new Group()
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_1").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.9901,2.1889,-1.8776)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_2").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.1059,1.6157,-0.9459)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_3").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.5787,1.7234,-0.4719)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_4").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.7797,1.0607,0.8120)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_5").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.8482,1.6003,1.9235)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_6").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.3720,1.5412,1.5004)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_7").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.4702,1.0060,2.3207)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_8").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.0043,1.0283,1.9762)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_9").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.3614,1.8701,0.8105)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_10").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.3215,1.7261,-0.3221)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_11").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.0963,2.1783,0.1259)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_12").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7503,2.4279,-1.6345)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_13").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.1677,2.0593,-2.0888)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_14").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.1972,2.3720,-0.9408)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_15").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.7895,1.5563,0.2449)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_16").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.9663,1.6453,1.2237)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_17").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.1354,1.5087,0.2960)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_18").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.6487,1.7527,-1.1872)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_19").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.2450,3.8521,-0.6813)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_20").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.3066,3.6419,0.2349)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_21").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.6329,2.5278,-2.0553)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_22").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.1180,2.8440,-3.4537)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_23").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.0185,1.8022,-2.1116)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_24").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.1314,2.6591,-2.5153)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_25").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.4748,1.9697,-2.5572)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_26").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.6837,2.8620,-2.8793)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_27").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.5656,3.6361,-4.1508)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Carbon", "cholesterol_karne_a_28").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.9428,2.0228,-2.7290)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_29").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.8702,0.5579,-1.1345)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_30").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-4.2306,1.2525,-1.2225)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_31").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.8443,2.7860,-0.3705)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_32").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.5980,-0.0166,0.6840)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_33").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.9845,0.9926,2.8302)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_34").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-3.1166,2.6452,2.1386)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_35").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.7974,0.5460,3.2519)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Oxygen", "cholesterol_karne_a_36").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.1826,1.2861,1.2631)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_37").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.3205,-0.0033,1.7620)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_38").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.5536,1.4060,2.8511)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_39").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(1.3568,2.9171,1.1476)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_40").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.2550,0.6517,-0.5486)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_41").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.7064,3.5158,-1.4783)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_42").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(0.0447,2.1427,-2.4288)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_43").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.4284,2.6460,-2.9820)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_44").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2058,0.9869,-2.3304)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_45").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.7354,0.5091,-0.0874)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_46").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.9396,0.8285,1.9599)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_47").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.9804,2.6119,1.7486)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_48").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.5588,0.4972,0.3832)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_49").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.9031,2.2515,0.5587)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_50").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.5225,0.7794,-1.6839)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_51").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.5516,4.3755,-1.5989)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_52").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(3.9698,4.0607,0.1194)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_53").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(2.2486,4.2030,-0.3745)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_54").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-2.3393,3.8408,0.5573)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_55").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-1.1313,4.1114,-0.7442)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_56").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-0.6054,4.0592,0.9725)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_57").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.7945,3.4951,-1.5571)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_58").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(5.8860,3.4016,-4.0098)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_59").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.2048,3.4527,-3.3792)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_60").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(4.8914,1.9061,-3.9818)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_61").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(6.9441,0.9731,-2.8306)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_62").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.2381,1.4013,-1.1111)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_63").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(8.1969,3.4944,-1.8026)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_64").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(7.9155,3.0506,-3.5203)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_65").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.4247,1.1825,-3.3239)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_66").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.6484,1.5118,-1.5723)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_67").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.7271,3.6239,-2.0872)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_68").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.4721,4.2419,-4.2967)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_69").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(9.6877,4.2967,-4.0977)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_70").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(10.4502,2.9399,-4.9946)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_71").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.9217,1.5002,-1.7613)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_72").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(12.8265,2.6762,-2.7736)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_73").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(11.9910,1.2847,-3.5432)))))
      .addChild(new Transform()
        .addChild(new ProtoInstance("Hydrogen", "cholesterol_karne_a_74").setContainerField("children")
          .addFieldValue(new fieldValue().setName("position").setValue(new SFVec3f(-5.7836,0.9649,0.6011))))))
    .addChild(new Group()
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_1").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1059,1.6157,-0.9459,-1.9901,2.1889,-1.8776})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.5787,1.7234,-0.4719,-2.1059,1.6157,-0.9459})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_3").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1059,1.6157,-0.9459,-1.0963,2.1783,0.1259})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_4").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.7797,1.0607,0.8120,-3.5787,1.7234,-0.4719})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_5").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.7797,1.0607,0.8120,-2.8482,1.6003,1.9235})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_6").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.1826,1.2861,1.2631,-3.7797,1.0607,0.8120})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_7").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.8482,1.6003,1.9235,-1.3720,1.5412,1.5004})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_8").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3920000000000001,1.5412,1.5004,-0.4902,1.0060,2.3207})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_8_2").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.352,1.5412,1.5004,-0.4502,1.0060,2.3207})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_9").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3720,1.5412,1.5004,-1.0963,2.1783,0.1259})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_10").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.4702,1.0060,2.3207,1.0043,1.0283,1.9762})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_11").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.0043,1.0283,1.9762,1.3614,1.8701,0.8105})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_12").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3215,1.7261,-0.3221,1.3614,1.8701,0.8105})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_13").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3614,1.8701,0.8105,2.7895,1.5563,0.2449})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_14").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.0963,2.1783,0.1259,0.3215,1.7261,-0.3221})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_15").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3215,1.7261,-0.3221,0.7503,2.4279,-1.6345})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_16").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.0963,2.1783,0.1259,-1.3066,3.6419,0.2349})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_17").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7503,2.4279,-1.6345,2.1677,2.0593,-2.0888})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_18").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1677,2.0593,-2.0888,3.1972,2.3720,-0.9408})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_19").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.1972,2.3720,-0.9408,4.6487,1.7527,-1.1872})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_20").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.1972,2.3720,-0.9408,3.2450,3.8521,-0.6813})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_21").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7895,1.5563,0.2449,3.1972,2.3720,-0.9408})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_22").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7895,1.5563,0.2449,3.9663,1.6453,1.2237})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_23").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.9663,1.6453,1.2237,5.1354,1.5087,0.2960})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_24").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.6487,1.7527,-1.1872,5.1354,1.5087,0.2960})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_25").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.6487,1.7527,-1.1872,5.6329,2.5278,-2.0553})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_26").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.6329,2.5278,-2.0553,5.1180,2.8440,-3.4537})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_27").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.6329,2.5278,-2.0553,7.0185,1.8022,-2.1116})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_28").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.0185,1.8022,-2.1116,8.1314,2.6591,-2.5153})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_29").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.1314,2.6591,-2.5153,9.4748,1.9697,-2.5572})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_30").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.4748,1.9697,-2.5572,10.6837,2.8620,-2.8793})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_31").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.6837,2.8620,-2.8793,10.5656,3.6361,-4.1508})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_32").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.6837,2.8620,-2.8793,11.9428,2.0228,-2.7290})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_33").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.1059,1.6157,-0.9459,-1.8702,0.5579,-1.1345})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_34").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.5787,1.7234,-0.4719,-4.2306,1.2525,-1.2225})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_35").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.5787,1.7234,-0.4719,-3.8443,2.7860,-0.3705})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_36").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-3.7797,1.0607,0.8120,-3.5980,-0.0166,0.6840})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_37").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.8482,1.6003,1.9235,-2.9845,0.9926,2.8302})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_38").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-2.8482,1.6003,1.9235,-3.1166,2.6452,2.1386})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_39").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-0.4702,1.0060,2.3207,-0.7974,0.5460,3.2519})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_40").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.0043,1.0283,1.9762,1.3205,-0.0033,1.7620})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_41").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.0043,1.0283,1.9762,1.5536,1.4060,2.8511})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_42").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {1.3614,1.8701,0.8105,1.3568,2.9171,1.1476})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_43").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.3215,1.7261,-0.3221,0.2550,0.6517,-0.5486})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_44").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7503,2.4279,-1.6345,0.7064,3.5158,-1.4783})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_45").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {0.7503,2.4279,-1.6345,0.0447,2.1427,-2.4288})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_46").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1677,2.0593,-2.0888,2.4284,2.6460,-2.9820})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_47").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.1677,2.0593,-2.0888,2.2058,0.9869,-2.3304})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_48").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {2.7895,1.5563,0.2449,2.7354,0.5091,-0.0874})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_49").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.9663,1.6453,1.2237,3.9396,0.8285,1.9599})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_50").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.9663,1.6453,1.2237,3.9804,2.6119,1.7486})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_51").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1354,1.5087,0.2960,5.5588,0.4972,0.3832})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_52").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1354,1.5087,0.2960,5.9031,2.2515,0.5587})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_53").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {4.6487,1.7527,-1.1872,4.5225,0.7794,-1.6839})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_54").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2450,3.8521,-0.6813,3.5516,4.3755,-1.5989})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_55").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2450,3.8521,-0.6813,3.9698,4.0607,0.1194})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_56").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {3.2450,3.8521,-0.6813,2.2486,4.2030,-0.3745})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_57").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3066,3.6419,0.2349,-2.3393,3.8408,0.5573})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_58").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3066,3.6419,0.2349,-1.1313,4.1114,-0.7442})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_59").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-1.3066,3.6419,0.2349,-0.6054,4.0592,0.9725})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_60").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.6329,2.5278,-2.0553,5.7945,3.4951,-1.5571})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_61").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1180,2.8440,-3.4537,5.8860,3.4016,-4.0098})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_62").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1180,2.8440,-3.4537,4.2048,3.4527,-3.3792})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_63").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {5.1180,2.8440,-3.4537,4.8914,1.9061,-3.9818})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_64").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.0185,1.8022,-2.1116,6.9441,0.9731,-2.8306})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_65").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {7.0185,1.8022,-2.1116,7.2381,1.4013,-1.1111})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_66").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.1314,2.6591,-2.5153,8.1969,3.4944,-1.8026})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_67").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {8.1314,2.6591,-2.5153,7.9155,3.0506,-3.5203})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_68").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.4748,1.9697,-2.5572,9.4247,1.1825,-3.3239})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_69").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {9.4748,1.9697,-2.5572,9.6484,1.5118,-1.5723})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_70").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.6837,2.8620,-2.8793,10.7271,3.6239,-2.0872})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_71").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.5656,3.6361,-4.1508,11.4721,4.2419,-4.2967})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_72").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.5656,3.6361,-4.1508,9.6877,4.2967,-4.0977})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_73").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {10.5656,3.6361,-4.1508,10.4502,2.9399,-4.9946})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_74").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.9428,2.0228,-2.7290,11.9217,1.5002,-1.7613})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_75").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.9428,2.0228,-2.7290,12.8265,2.6762,-2.7736})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_76").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {11.9428,2.0228,-2.7290,11.9910,1.2847,-3.5432})))))
      .addChild(new ProtoInstance("line", "cholesterol_karne_b_77").setContainerField("children")
        .addFieldValue(new fieldValue().setName("bond_set").setValue(new MFVec3f(new MFVec3f(new double[] {-5.1826,1.2861,1.2631,-5.7836,0.9649,0.6011})))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Cholesterol model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Cholesterol().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.ChemicalMarkupLanguage.Cholesterol\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.ChemicalMarkupLanguage.Cholesterol self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // ChemicalMarkupLanguage/Cholesterol_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "ChemicalMarkupLanguage/Cholesterol_JavaExport.x3d"; 
                String filenameX3DV = "ChemicalMarkupLanguage/Cholesterol_JavaExport.x3dv"; 
                String filenameJSON = "ChemicalMarkupLanguage/Cholesterol_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
