/**
 *<p>
 *	Computer Aided Design (CAD) aids in the creation, modification, analysis, or optimization of model design,
 *      with specialized support provided by the X3D CADGeometry component.
 *</p>
 *<p>
 *	The Computer Aided Design (CAD) examples
 *	illustrate simple concepts provided by the 
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/CADGeometry.html" target="_blank">X3D CAD Geometry Component</a>
 *	and
 *	<a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/CADInterchange.html" target="_blank">CADInterchange Profile</a>.
 *	Significant additional work is being pursued by the
 *	<a href="https://www.web3d.org/working-groups/computer-aided-design-cad" target="_blank">X3D CAD Working Group</a>
 *	and is documented on the
 *	<a href="https://www.web3d.org/wiki/index.php/X3D_CAD" target="_blank">X3D CAD Working Group Wiki</a>.
 *</p>
 *<p>
 *	A supporting
 *	<a href="http://x3dgraphics.com/slidesets/X3dForAdvancedModeling" target="X3dChapterSlideset">CAD chapter slideset</a>
 *	is available online via
 *	<a href="http://X3dGraphics.com">X3dGraphics.com</a>.
 *</p>
 *
 *<p>
 *	Technical capabilities are summarized by the
 *	<a href="../../../CAD/Tc184VisualizationRequirementsForX3dCad.May2009.pdf" target="_blank">SC-4&nbsp;TC-184 Visualization Requirements For X3D CAD</a>
 *	report, published May 2009.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/CAD" target="_blank">X3D Basic: CAD</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.CAD;

