####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python QuadSetColor.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='CADInterchange',version='3.3',
  head=head(
    children=[
    meta(content='QuadSetColor.x3d',name='title'),
    meta(content='Demonstrates QuadSet node of CADGeometry component, includes child nodes for normal vectors and color (per vertex).',name='description'),
    meta(content='Vincent Marchetti',name='creator'),
    meta(content='21 May 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/CAD/QuadSetColor.x3d',name='identifier'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Python script from http://kshell.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='QuadSetColor.x3d'),
    Viewpoint(description='Front view',fieldOfView=0.1,orientation=(1,0,0,1.571),position=(0,-80,0)),
    Shape(
      geometry=QuadSet(ccw=True,colorPerVertex=True,normalPerVertex=True,solid=False,
        coord=Coordinate(point=[(-2.9351,0.9537,-2.3504),(-2.8416,1.2041,-2.3504),(-2.6989,1.1437,-2.1430),(-2.7878,0.9058,-2.1430),(-2.8416,1.2041,-2.3504),(-2.7267,1.4456,-2.3504),(-2.5898,1.3730,-2.1430),(-2.6989,1.1437,-2.1430),(-2.7267,1.4456,-2.3504),(-2.5913,1.6762,-2.3504),(-2.4613,1.5920,-2.1430),(-2.5898,1.3730,-2.1430),(-2.5913,1.6762,-2.3504),(-2.4365,1.8942,-2.3504),(-2.3142,1.7991,-2.1430),(-2.4613,1.5920,-2.1430),(-2.4365,1.8942,-2.3504),(-2.2634,2.0980,-2.3504),(-2.1498,1.9927,-2.1430),(-2.3142,1.7991,-2.1430),(-2.2634,2.0980,-2.3504),(-2.0733,2.2860,-2.3504),(-1.9693,2.1713,-2.1430),(-2.1498,1.9927,-2.1430),(-2.0733,2.2860,-2.3504),(-1.8677,2.4569,-2.3504),(-1.7739,2.3336,-2.1430),(-1.9693,2.1713,-2.1430),(-1.8677,2.4569,-2.3504),(-1.6480,2.6093,-2.3504),(-1.5653,2.4784,-2.1430),(-1.7739,2.3336,-2.1430),(-1.6480,2.6093,-2.3504),(-1.4160,2.7422,-2.3504),(-1.3449,2.6045,-2.1430),(-1.5653,2.4784,-2.1430),(-1.4160,2.7422,-2.3504),(-1.1733,2.8544,-2.3504),(-1.1144,2.7112,-2.1430),(-1.3449,2.6045,-2.1430),(-1.1733,2.8544,-2.3504),(-0.9218,2.9453,-2.3504),(-0.8756,2.7975,-2.1430),(-1.1144,2.7112,-2.1430),(-0.9218,2.9453,-2.3504),(-0.6634,3.0140,-2.3504),(-0.6301,2.8627,-2.1430),(-0.8756,2.7975,-2.1430),(-0.6634,3.0140,-2.3504),(-0.4001,3.0601,-2.3504),(-0.3800,2.9065,-2.1430),(-0.6301,2.8627,-2.1430),(-0.4001,3.0601,-2.3504),(-0.1337,3.0833,-2.3504),(-0.1270,2.9285,-2.1430),(-0.3800,2.9065,-2.1430),(-0.1337,3.0833,-2.3504),(0.1337,3.0833,-2.3504),(0.1270,2.9285,-2.1430),(-0.1270,2.9285,-2.1430),(0.1337,3.0833,-2.3504),(0.4001,3.0601,-2.3504),(0.3800,2.9065,-2.1430),(0.1270,2.9285,-2.1430),(0.4001,3.0601,-2.3504),(0.6634,3.0140,-2.3504),(0.6301,2.8627,-2.1430),(0.3800,2.9065,-2.1430),(0.6634,3.0140,-2.3504),(0.9218,2.9453,-2.3504),(0.8756,2.7975,-2.1430),(0.6301,2.8627,-2.1430),(0.9218,2.9453,-2.3504),(1.1733,2.8544,-2.3504),(1.1144,2.7112,-2.1430),(0.8756,2.7975,-2.1430),(1.1733,2.8544,-2.3504),(1.4160,2.7422,-2.3504),(1.3449,2.6045,-2.1430),(1.1144,2.7112,-2.1430),(1.4160,2.7422,-2.3504),(1.6480,2.6093,-2.3504),(1.5653,2.4784,-2.1430),(1.3449,2.6045,-2.1430),(1.6480,2.6093,-2.3504),(1.8677,2.4569,-2.3504),(1.7739,2.3336,-2.1430),(1.5653,2.4784,-2.1430),(1.8677,2.4569,-2.3504),(2.0733,2.2860,-2.3504),(1.9693,2.1713,-2.1430),(1.7739,2.3336,-2.1430),(2.0733,2.2860,-2.3504),(2.2634,2.0980,-2.3504),(2.1498,1.9927,-2.1430),(1.9693,2.1713,-2.1430),(2.2634,2.0980,-2.3504),(2.4365,1.8942,-2.3504),(2.3142,1.7991,-2.1430),(2.1498,1.9927,-2.1430),(2.4365,1.8942,-2.3504),(2.5913,1.6762,-2.3504),(2.4613,1.5920,-2.1430),(2.3142,1.7991,-2.1430),(2.5913,1.6762,-2.3504),(2.7267,1.4456,-2.3504),(2.5898,1.3730,-2.1430),(2.4613,1.5920,-2.1430),(2.7267,1.4456,-2.3504),(2.8416,1.2041,-2.3504),(2.6989,1.1437,-2.1430),(2.5898,1.3730,-2.1430),(2.8416,1.2041,-2.3504),(2.9351,0.9537,-2.3504),(2.7878,0.9058,-2.1430),(2.6989,1.1437,-2.1430),(-2.7878,0.9058,-2.1430),(-2.6989,1.1437,-2.1430),(-2.5692,1.0887,-1.9458),(-2.6538,0.8623,-1.9458),(-2.6989,1.1437,-2.1430),(-2.5898,1.3730,-2.1430),(-2.4653,1.3070,-1.9458),(-2.5692,1.0887,-1.9458),(-2.5898,1.3730,-2.1430),(-2.4613,1.5920,-2.1430),(-2.3429,1.5155,-1.9458),(-2.4653,1.3070,-1.9458),(-2.4613,1.5920,-2.1430),(-2.3142,1.7991,-2.1430),(-2.2029,1.7126,-1.9458),(-2.3429,1.5155,-1.9458),(-2.3142,1.7991,-2.1430),(-2.1498,1.9927,-2.1430),(-2.0464,1.8969,-1.9458),(-2.2029,1.7126,-1.9458),(-2.1498,1.9927,-2.1430),(-1.9693,2.1713,-2.1430),(-1.8746,2.0669,-1.9458),(-2.0464,1.8969,-1.9458),(-1.9693,2.1713,-2.1430),(-1.7739,2.3336,-2.1430),(-1.6886,2.2214,-1.9458),(-1.8746,2.0669,-1.9458),(-1.7739,2.3336,-2.1430),(-1.5653,2.4784,-2.1430),(-1.4900,2.3592,-1.9458),(-1.6886,2.2214,-1.9458),(-1.5653,2.4784,-2.1430),(-1.3449,2.6045,-2.1430),(-1.2802,2.4793,-1.9458),(-1.4900,2.3592,-1.9458),(-1.3449,2.6045,-2.1430),(-1.1144,2.7112,-2.1430),(-1.0608,2.5808,-1.9458),(-1.2802,2.4793,-1.9458),(-1.1144,2.7112,-2.1430),(-0.8756,2.7975,-2.1430),(-0.8335,2.6630,-1.9458),(-1.0608,2.5808,-1.9458),(-0.8756,2.7975,-2.1430),(-0.6301,2.8627,-2.1430),(-0.5998,2.7251,-1.9458),(-0.8335,2.6630,-1.9458),(-0.6301,2.8627,-2.1430),(-0.3800,2.9065,-2.1430),(-0.3617,2.7668,-1.9458),(-0.5998,2.7251,-1.9458),(-0.3800,2.9065,-2.1430),(-0.1270,2.9285,-2.1430),(-0.1209,2.7877,-1.9458),(-0.3617,2.7668,-1.9458),(-0.1270,2.9285,-2.1430),(0.1270,2.9285,-2.1430),(0.1209,2.7877,-1.9458),(-0.1209,2.7877,-1.9458),(0.1270,2.9285,-2.1430),(0.3800,2.9065,-2.1430),(0.3617,2.7668,-1.9458),(0.1209,2.7877,-1.9458),(0.3800,2.9065,-2.1430),(0.6301,2.8627,-2.1430),(0.5998,2.7251,-1.9458),(0.3617,2.7668,-1.9458),(0.6301,2.8627,-2.1430),(0.8756,2.7975,-2.1430),(0.8335,2.6630,-1.9458),(0.5998,2.7251,-1.9458),(0.8756,2.7975,-2.1430),(1.1144,2.7112,-2.1430),(1.0608,2.5808,-1.9458),(0.8335,2.6630,-1.9458),(1.1144,2.7112,-2.1430),(1.3449,2.6045,-2.1430),(1.2802,2.4793,-1.9458),(1.0608,2.5808,-1.9458),(1.3449,2.6045,-2.1430),(1.5653,2.4784,-2.1430),(1.4900,2.3592,-1.9458),(1.2802,2.4793,-1.9458),(1.5653,2.4784,-2.1430),(1.7739,2.3336,-2.1430),(1.6886,2.2214,-1.9458),(1.4900,2.3592,-1.9458),(1.7739,2.3336,-2.1430),(1.9693,2.1713,-2.1430),(1.8746,2.0669,-1.9458),(1.6886,2.2214,-1.9458),(1.9693,2.1713,-2.1430),(2.1498,1.9927,-2.1430),(2.0464,1.8969,-1.9458),(1.8746,2.0669,-1.9458),(2.1498,1.9927,-2.1430),(2.3142,1.7991,-2.1430),(2.2029,1.7126,-1.9458),(2.0464,1.8969,-1.9458),(2.3142,1.7991,-2.1430),(2.4613,1.5920,-2.1430),(2.3429,1.5155,-1.9458),(2.2029,1.7126,-1.9458),(2.4613,1.5920,-2.1430),(2.5898,1.3730,-2.1430),(2.4653,1.3070,-1.9458),(2.3429,1.5155,-1.9458),(2.5898,1.3730,-2.1430),(2.6989,1.1437,-2.1430),(2.5692,1.0887,-1.9458),(2.4653,1.3070,-1.9458),(2.6989,1.1437,-2.1430),(2.7878,0.9058,-2.1430),(2.6538,0.8623,-1.9458),(2.5692,1.0887,-1.9458),(-2.6538,0.8623,-1.9458),(-2.5692,1.0887,-1.9458),(-2.4516,1.0389,-1.7578),(-2.5324,0.8228,-1.7578),(-2.5692,1.0887,-1.9458),(-2.4653,1.3070,-1.9458),(-2.3525,1.2472,-1.7578),(-2.4516,1.0389,-1.7578),(-2.4653,1.3070,-1.9458),(-2.3429,1.5155,-1.9458),(-2.2357,1.4462,-1.7578),(-2.3525,1.2472,-1.7578),(-2.3429,1.5155,-1.9458),(-2.2029,1.7126,-1.9458),(-2.1022,1.6343,-1.7578),(-2.2357,1.4462,-1.7578),(-2.2029,1.7126,-1.9458),(-2.0464,1.8969,-1.9458),(-1.9528,1.8101,-1.7578),(-2.1022,1.6343,-1.7578),(-2.0464,1.8969,-1.9458),(-1.8746,2.0669,-1.9458),(-1.7888,1.9723,-1.7578),(-1.9528,1.8101,-1.7578),(-1.8746,2.0669,-1.9458),(-1.6886,2.2214,-1.9458),(-1.6114,2.1197,-1.7578),(-1.7888,1.9723,-1.7578),(-1.6886,2.2214,-1.9458),(-1.4900,2.3592,-1.9458),(-1.4219,2.2513,-1.7578),(-1.6114,2.1197,-1.7578),(-1.4900,2.3592,-1.9458),(-1.2802,2.4793,-1.9458),(-1.2217,2.3659,-1.7578),(-1.4219,2.2513,-1.7578),(-1.2802,2.4793,-1.9458),(-1.0608,2.5808,-1.9458),(-1.0123,2.4627,-1.7578),(-1.2217,2.3659,-1.7578),(-1.0608,2.5808,-1.9458),(-0.8335,2.6630,-1.9458),(-0.7953,2.5411,-1.7578),(-1.0123,2.4627,-1.7578),(-0.8335,2.6630,-1.9458),(-0.5998,2.7251,-1.9458),(-0.5724,2.6004,-1.7578),(-0.7953,2.5411,-1.7578),(-0.5998,2.7251,-1.9458),(-0.3617,2.7668,-1.9458),(-0.3452,2.6402,-1.7578),(-0.5724,2.6004,-1.7578),(-0.3617,2.7668,-1.9458),(-0.1209,2.7877,-1.9458),(-0.1153,2.6602,-1.7578),(-0.3452,2.6402,-1.7578),(-0.1209,2.7877,-1.9458),(0.1209,2.7877,-1.9458),(0.1153,2.6602,-1.7578),(-0.1153,2.6602,-1.7578),(0.1209,2.7877,-1.9458),(0.3617,2.7668,-1.9458),(0.3452,2.6402,-1.7578),(0.1153,2.6602,-1.7578),(0.3617,2.7668,-1.9458),(0.5998,2.7251,-1.9458),(0.5724,2.6004,-1.7578),(0.3452,2.6402,-1.7578),(0.5998,2.7251,-1.9458),(0.8335,2.6630,-1.9458),(0.7953,2.5411,-1.7578),(0.5724,2.6004,-1.7578),(0.8335,2.6630,-1.9458),(1.0608,2.5808,-1.9458),(1.0123,2.4627,-1.7578),(0.7953,2.5411,-1.7578),(1.0608,2.5808,-1.9458),(1.2802,2.4793,-1.9458),(1.2217,2.3659,-1.7578),(1.0123,2.4627,-1.7578),(1.2802,2.4793,-1.9458),(1.4900,2.3592,-1.9458),(1.4219,2.2513,-1.7578),(1.2217,2.3659,-1.7578),(1.4900,2.3592,-1.9458),(1.6886,2.2214,-1.9458),(1.6114,2.1197,-1.7578),(1.4219,2.2513,-1.7578),(1.6886,2.2214,-1.9458),(1.8746,2.0669,-1.9458),(1.7888,1.9723,-1.7578),(1.6114,2.1197,-1.7578),(1.8746,2.0669,-1.9458),(2.0464,1.8969,-1.9458),(1.9528,1.8101,-1.7578),(1.7888,1.9723,-1.7578),(2.0464,1.8969,-1.9458),(2.2029,1.7126,-1.9458),(2.1022,1.6343,-1.7578),(1.9528,1.8101,-1.7578),(2.2029,1.7126,-1.9458),(2.3429,1.5155,-1.9458),(2.2357,1.4462,-1.7578),(2.1022,1.6343,-1.7578),(2.3429,1.5155,-1.9458),(2.4653,1.3070,-1.9458),(2.3525,1.2472,-1.7578),(2.2357,1.4462,-1.7578),(2.4653,1.3070,-1.9458),(2.5692,1.0887,-1.9458),(2.4516,1.0389,-1.7578),(2.3525,1.2472,-1.7578),(2.5692,1.0887,-1.9458),(2.6538,0.8623,-1.9458),(2.5324,0.8228,-1.7578),(2.4516,1.0389,-1.7578),(-2.5324,0.8228,-1.7578),(-2.4516,1.0389,-1.7578),(-2.3458,0.9941,-1.5782),(-2.4230,0.7873,-1.5782),(-2.4516,1.0389,-1.7578),(-2.3525,1.2472,-1.7578),(-2.2509,1.1934,-1.5782),(-2.3458,0.9941,-1.5782),(-2.3525,1.2472,-1.7578),(-2.2357,1.4462,-1.7578),(-2.1392,1.3837,-1.5782),(-2.2509,1.1934,-1.5782),(-2.2357,1.4462,-1.7578),(-2.1022,1.6343,-1.7578),(-2.0114,1.5637,-1.5782),(-2.1392,1.3837,-1.5782),(-2.1022,1.6343,-1.7578),(-1.9528,1.8101,-1.7578),(-1.8685,1.7319,-1.5782),(-2.0114,1.5637,-1.5782),(-1.9528,1.8101,-1.7578),(-1.7888,1.9723,-1.7578),(-1.7116,1.8871,-1.5782),(-1.8685,1.7319,-1.5782),(-1.7888,1.9723,-1.7578),(-1.6114,2.1197,-1.7578),(-1.5418,2.0282,-1.5782),(-1.7116,1.8871,-1.5782),(-1.6114,2.1197,-1.7578),(-1.4219,2.2513,-1.7578),(-1.3605,2.1540,-1.5782),(-1.5418,2.0282,-1.5782),(-1.4219,2.2513,-1.7578),(-1.2217,2.3659,-1.7578),(-1.1689,2.2637,-1.5782),(-1.3605,2.1540,-1.5782),(-1.2217,2.3659,-1.7578),(-1.0123,2.4627,-1.7578),(-0.9686,2.3564,-1.5782),(-1.1689,2.2637,-1.5782),(-1.0123,2.4627,-1.7578),(-0.7953,2.5411,-1.7578),(-0.7610,2.4314,-1.5782),(-0.9686,2.3564,-1.5782),(-0.7953,2.5411,-1.7578),(-0.5724,2.6004,-1.7578),(-0.5477,2.4881,-1.5782),(-0.7610,2.4314,-1.5782),(-0.5724,2.6004,-1.7578),(-0.3452,2.6402,-1.7578),(-0.3303,2.5262,-1.5782),(-0.5477,2.4881,-1.5782),(-0.3452,2.6402,-1.7578),(-0.1153,2.6602,-1.7578),(-0.1104,2.5453,-1.5782),(-0.3303,2.5262,-1.5782),(-0.1153,2.6602,-1.7578),(0.1153,2.6602,-1.7578),(0.1104,2.5453,-1.5782),(-0.1104,2.5453,-1.5782),(0.1153,2.6602,-1.7578),(0.3452,2.6402,-1.7578),(0.3303,2.5262,-1.5782),(0.1104,2.5453,-1.5782),(0.3452,2.6402,-1.7578),(0.5724,2.6004,-1.7578),(0.5477,2.4881,-1.5782),(0.3303,2.5262,-1.5782),(0.5724,2.6004,-1.7578),(0.7953,2.5411,-1.7578),(0.7610,2.4314,-1.5782),(0.5477,2.4881,-1.5782),(0.7953,2.5411,-1.7578),(1.0123,2.4627,-1.7578),(0.9686,2.3564,-1.5782),(0.7610,2.4314,-1.5782),(1.0123,2.4627,-1.7578),(1.2217,2.3659,-1.7578),(1.1689,2.2637,-1.5782),(0.9686,2.3564,-1.5782),(1.2217,2.3659,-1.7578),(1.4219,2.2513,-1.7578),(1.3605,2.1540,-1.5782),(1.1689,2.2637,-1.5782),(1.4219,2.2513,-1.7578),(1.6114,2.1197,-1.7578),(1.5418,2.0282,-1.5782),(1.3605,2.1540,-1.5782),(1.6114,2.1197,-1.7578),(1.7888,1.9723,-1.7578),(1.7116,1.8871,-1.5782),(1.5418,2.0282,-1.5782),(1.7888,1.9723,-1.7578),(1.9528,1.8101,-1.7578),(1.8685,1.7319,-1.5782),(1.7116,1.8871,-1.5782),(1.9528,1.8101,-1.7578),(2.1022,1.6343,-1.7578),(2.0114,1.5637,-1.5782),(1.8685,1.7319,-1.5782),(2.1022,1.6343,-1.7578),(2.2357,1.4462,-1.7578),(2.1392,1.3837,-1.5782),(2.0114,1.5637,-1.5782),(2.2357,1.4462,-1.7578),(2.3525,1.2472,-1.7578),(2.2509,1.1934,-1.5782),(2.1392,1.3837,-1.5782),(2.3525,1.2472,-1.7578),(2.4516,1.0389,-1.7578),(2.3458,0.9941,-1.5782),(2.2509,1.1934,-1.5782),(2.4516,1.0389,-1.7578),(2.5324,0.8228,-1.7578),(2.4230,0.7873,-1.5782),(2.3458,0.9941,-1.5782),(-2.4230,0.7873,-1.5782),(-2.3458,0.9941,-1.5782),(-2.2510,0.9539,-1.4061),(-2.3252,0.7555,-1.4061),(-2.3458,0.9941,-1.5782),(-2.2509,1.1934,-1.5782),(-2.1600,1.1452,-1.4061),(-2.2510,0.9539,-1.4061),(-2.2509,1.1934,-1.5782),(-2.1392,1.3837,-1.5782),(-2.0528,1.3278,-1.4061),(-2.1600,1.1452,-1.4061),(-2.1392,1.3837,-1.5782),(-2.0114,1.5637,-1.5782),(-1.9302,1.5005,-1.4061),(-2.0528,1.3278,-1.4061),(-2.0114,1.5637,-1.5782),(-1.8685,1.7319,-1.5782),(-1.7930,1.6620,-1.4061),(-1.9302,1.5005,-1.4061),(-1.8685,1.7319,-1.5782),(-1.7116,1.8871,-1.5782),(-1.6425,1.8109,-1.4061),(-1.7930,1.6620,-1.4061),(-1.7116,1.8871,-1.5782),(-1.5418,2.0282,-1.5782),(-1.4795,1.9463,-1.4061),(-1.6425,1.8109,-1.4061),(-1.5418,2.0282,-1.5782),(-1.3605,2.1540,-1.5782),(-1.3055,2.0671,-1.4061),(-1.4795,1.9463,-1.4061),(-1.3605,2.1540,-1.5782),(-1.1689,2.2637,-1.5782),(-1.1217,2.1723,-1.4061),(-1.3055,2.0671,-1.4061),(-1.1689,2.2637,-1.5782),(-0.9686,2.3564,-1.5782),(-0.9295,2.2613,-1.4061),(-1.1217,2.1723,-1.4061),(-0.9686,2.3564,-1.5782),(-0.7610,2.4314,-1.5782),(-0.7303,2.3332,-1.4061),(-0.9295,2.2613,-1.4061),(-0.7610,2.4314,-1.5782),(-0.5477,2.4881,-1.5782),(-0.5256,2.3877,-1.4061),(-0.7303,2.3332,-1.4061),(-0.5477,2.4881,-1.5782),(-0.3303,2.5262,-1.5782),(-0.3169,2.4242,-1.4061),(-0.5256,2.3877,-1.4061),(-0.3303,2.5262,-1.5782),(-0.1104,2.5453,-1.5782),(-0.1059,2.4425,-1.4061),(-0.3169,2.4242,-1.4061),(-0.1104,2.5453,-1.5782),(0.1104,2.5453,-1.5782),(0.1059,2.4425,-1.4061),(-0.1059,2.4425,-1.4061),(0.1104,2.5453,-1.5782),(0.3303,2.5262,-1.5782),(0.3169,2.4242,-1.4061),(0.1059,2.4425,-1.4061),(0.3303,2.5262,-1.5782),(0.5477,2.4881,-1.5782),(0.5256,2.3877,-1.4061),(0.3169,2.4242,-1.4061),(0.5477,2.4881,-1.5782),(0.7610,2.4314,-1.5782),(0.7303,2.3332,-1.4061),(0.5256,2.3877,-1.4061),(0.7610,2.4314,-1.5782),(0.9686,2.3564,-1.5782),(0.9295,2.2613,-1.4061),(0.7303,2.3332,-1.4061),(0.9686,2.3564,-1.5782),(1.1689,2.2637,-1.5782),(1.1217,2.1723,-1.4061),(0.9295,2.2613,-1.4061),(1.1689,2.2637,-1.5782),(1.3605,2.1540,-1.5782),(1.3055,2.0671,-1.4061),(1.1217,2.1723,-1.4061),(1.3605,2.1540,-1.5782),(1.5418,2.0282,-1.5782),(1.4795,1.9463,-1.4061),(1.3055,2.0671,-1.4061),(1.5418,2.0282,-1.5782),(1.7116,1.8871,-1.5782),(1.6425,1.8109,-1.4061),(1.4795,1.9463,-1.4061),(1.7116,1.8871,-1.5782),(1.8685,1.7319,-1.5782),(1.7930,1.6620,-1.4061),(1.6425,1.8109,-1.4061),(1.8685,1.7319,-1.5782),(2.0114,1.5637,-1.5782),(1.9302,1.5005,-1.4061),(1.7930,1.6620,-1.4061),(2.0114,1.5637,-1.5782),(2.1392,1.3837,-1.5782),(2.0528,1.3278,-1.4061),(1.9302,1.5005,-1.4061),(2.1392,1.3837,-1.5782),(2.2509,1.1934,-1.5782),(2.1600,1.1452,-1.4061),(2.0528,1.3278,-1.4061),(2.2509,1.1934,-1.5782),(2.3458,0.9941,-1.5782),(2.2510,0.9539,-1.4061),(2.1600,1.1452,-1.4061),(2.3458,0.9941,-1.5782),(2.4230,0.7873,-1.5782),(2.3252,0.7555,-1.4061),(2.2510,0.9539,-1.4061),(-2.3252,0.7555,-1.4061),(-2.2510,0.9539,-1.4061),(-2.1670,0.9183,-1.2407),(-2.2384,0.7273,-1.2407),(-2.2510,0.9539,-1.4061),(-2.1600,1.1452,-1.4061),(-2.0794,1.1024,-1.2407),(-2.1670,0.9183,-1.2407),(-2.1600,1.1452,-1.4061),(-2.0528,1.3278,-1.4061),(-1.9762,1.2783,-1.2407),(-2.0794,1.1024,-1.2407),(-2.0528,1.3278,-1.4061),(-1.9302,1.5005,-1.4061),(-1.8581,1.4445,-1.2407),(-1.9762,1.2783,-1.2407),(-1.9302,1.5005,-1.4061),(-1.7930,1.6620,-1.4061),(-1.7261,1.6000,-1.2407),(-1.8581,1.4445,-1.2407),(-1.7930,1.6620,-1.4061),(-1.6425,1.8109,-1.4061),(-1.5812,1.7434,-1.2407),(-1.7261,1.6000,-1.2407),(-1.6425,1.8109,-1.4061),(-1.4795,1.9463,-1.4061),(-1.4243,1.8737,-1.2407),(-1.5812,1.7434,-1.2407),(-1.4795,1.9463,-1.4061),(-1.3055,2.0671,-1.4061),(-1.2568,1.9899,-1.2407),(-1.4243,1.8737,-1.2407),(-1.3055,2.0671,-1.4061),(-1.1217,2.1723,-1.4061),(-1.0799,2.0912,-1.2407),(-1.2568,1.9899,-1.2407),(-1.1217,2.1723,-1.4061),(-0.9295,2.2613,-1.4061),(-0.8948,2.1769,-1.2407),(-1.0799,2.0912,-1.2407),(-0.9295,2.2613,-1.4061),(-0.7303,2.3332,-1.4061),(-0.7030,2.2461,-1.2407),(-0.8948,2.1769,-1.2407),(-0.7303,2.3332,-1.4061),(-0.5256,2.3877,-1.4061),(-0.5060,2.2986,-1.2407),(-0.7030,2.2461,-1.2407),(-0.5256,2.3877,-1.4061),(-0.3169,2.4242,-1.4061),(-0.3051,2.3337,-1.2407),(-0.5060,2.2986,-1.2407),(-0.3169,2.4242,-1.4061),(-0.1059,2.4425,-1.4061),(-0.1020,2.3514,-1.2407),(-0.3051,2.3337,-1.2407),(-0.1059,2.4425,-1.4061),(0.1059,2.4425,-1.4061),(0.1020,2.3514,-1.2407),(-0.1020,2.3514,-1.2407),(0.1059,2.4425,-1.4061),(0.3169,2.4242,-1.4061),(0.3051,2.3337,-1.2407),(0.1020,2.3514,-1.2407),(0.3169,2.4242,-1.4061),(0.5256,2.3877,-1.4061),(0.5060,2.2986,-1.2407),(0.3051,2.3337,-1.2407),(0.5256,2.3877,-1.4061),(0.7303,2.3332,-1.4061),(0.7030,2.2461,-1.2407),(0.5060,2.2986,-1.2407),(0.7303,2.3332,-1.4061),(0.9295,2.2613,-1.4061),(0.8948,2.1769,-1.2407),(0.7030,2.2461,-1.2407),(0.9295,2.2613,-1.4061),(1.1217,2.1723,-1.4061),(1.0799,2.0912,-1.2407),(0.8948,2.1769,-1.2407),(1.1217,2.1723,-1.4061),(1.3055,2.0671,-1.4061),(1.2568,1.9899,-1.2407),(1.0799,2.0912,-1.2407),(1.3055,2.0671,-1.4061),(1.4795,1.9463,-1.4061),(1.4243,1.8737,-1.2407),(1.2568,1.9899,-1.2407),(1.4795,1.9463,-1.4061),(1.6425,1.8109,-1.4061),(1.5812,1.7434,-1.2407),(1.4243,1.8737,-1.2407),(1.6425,1.8109,-1.4061),(1.7930,1.6620,-1.4061),(1.7261,1.6000,-1.2407),(1.5812,1.7434,-1.2407),(1.7930,1.6620,-1.4061),(1.9302,1.5005,-1.4061),(1.8581,1.4445,-1.2407),(1.7261,1.6000,-1.2407),(1.9302,1.5005,-1.4061),(2.0528,1.3278,-1.4061),(1.9762,1.2783,-1.2407),(1.8581,1.4445,-1.2407),(2.0528,1.3278,-1.4061),(2.1600,1.1452,-1.4061),(2.0794,1.1024,-1.2407),(1.9762,1.2783,-1.2407),(2.1600,1.1452,-1.4061),(2.2510,0.9539,-1.4061),(2.1670,0.9183,-1.2407),(2.0794,1.1024,-1.2407),(2.2510,0.9539,-1.4061),(2.3252,0.7555,-1.4061),(2.2384,0.7273,-1.2407),(2.1670,0.9183,-1.2407),(-2.2384,0.7273,-1.2407),(-2.1670,0.9183,-1.2407),(-2.0934,0.8871,-1.0812),(-2.1623,0.7026,-1.0812),(-2.1670,0.9183,-1.2407),(-2.0794,1.1024,-1.2407),(-2.0087,1.0650,-1.0812),(-2.0934,0.8871,-1.0812),(-2.0794,1.1024,-1.2407),(-1.9762,1.2783,-1.2407),(-1.9090,1.2348,-1.0812),(-2.0087,1.0650,-1.0812),(-1.9762,1.2783,-1.2407),(-1.8581,1.4445,-1.2407),(-1.7950,1.3954,-1.0812),(-1.9090,1.2348,-1.0812),(-1.8581,1.4445,-1.2407),(-1.7261,1.6000,-1.2407),(-1.6674,1.5456,-1.0812),(-1.7950,1.3954,-1.0812),(-1.7261,1.6000,-1.2407),(-1.5812,1.7434,-1.2407),(-1.5274,1.6841,-1.0812),(-1.6674,1.5456,-1.0812),(-1.5812,1.7434,-1.2407),(-1.4243,1.8737,-1.2407),(-1.3759,1.8100,-1.0812),(-1.5274,1.6841,-1.0812),(-1.4243,1.8737,-1.2407),(-1.2568,1.9899,-1.2407),(-1.2141,1.9223,-1.0812),(-1.3759,1.8100,-1.0812),(-1.2568,1.9899,-1.2407),(-1.0799,2.0912,-1.2407),(-1.0431,2.0201,-1.0812),(-1.2141,1.9223,-1.0812),(-1.0799,2.0912,-1.2407),(-0.8948,2.1769,-1.2407),(-0.8644,2.1028,-1.0812),(-1.0431,2.0201,-1.0812),(-0.8948,2.1769,-1.2407),(-0.7030,2.2461,-1.2407),(-0.6791,2.1698,-1.0812),(-0.8644,2.1028,-1.0812),(-0.7030,2.2461,-1.2407),(-0.5060,2.2986,-1.2407),(-0.4887,2.2204,-1.0812),(-0.6791,2.1698,-1.0812),(-0.5060,2.2986,-1.2407),(-0.3051,2.3337,-1.2407),(-0.2947,2.2544,-1.0812),(-0.4887,2.2204,-1.0812),(-0.3051,2.3337,-1.2407),(-0.1020,2.3514,-1.2407),(-0.0985,2.2714,-1.0812),(-0.2947,2.2544,-1.0812),(-0.1020,2.3514,-1.2407),(0.1020,2.3514,-1.2407),(0.0985,2.2714,-1.0812),(-0.0985,2.2714,-1.0812),(0.1020,2.3514,-1.2407),(0.3051,2.3337,-1.2407),(0.2947,2.2544,-1.0812),(0.0985,2.2714,-1.0812),(0.3051,2.3337,-1.2407),(0.5060,2.2986,-1.2407),(0.4887,2.2204,-1.0812),(0.2947,2.2544,-1.0812),(0.5060,2.2986,-1.2407),(0.7030,2.2461,-1.2407),(0.6791,2.1698,-1.0812),(0.4887,2.2204,-1.0812),(0.7030,2.2461,-1.2407),(0.8948,2.1769,-1.2407),(0.8644,2.1028,-1.0812),(0.6791,2.1698,-1.0812),(0.8948,2.1769,-1.2407),(1.0799,2.0912,-1.2407),(1.0431,2.0201,-1.0812),(0.8644,2.1028,-1.0812),(1.0799,2.0912,-1.2407),(1.2568,1.9899,-1.2407),(1.2141,1.9223,-1.0812),(1.0431,2.0201,-1.0812),(1.2568,1.9899,-1.2407),(1.4243,1.8737,-1.2407),(1.3759,1.8100,-1.0812),(1.2141,1.9223,-1.0812),(1.4243,1.8737,-1.2407),(1.5812,1.7434,-1.2407),(1.5274,1.6841,-1.0812),(1.3759,1.8100,-1.0812),(1.5812,1.7434,-1.2407),(1.7261,1.6000,-1.2407),(1.6674,1.5456,-1.0812),(1.5274,1.6841,-1.0812),(1.7261,1.6000,-1.2407),(1.8581,1.4445,-1.2407),(1.7950,1.3954,-1.0812),(1.6674,1.5456,-1.0812),(1.8581,1.4445,-1.2407),(1.9762,1.2783,-1.2407),(1.9090,1.2348,-1.0812),(1.7950,1.3954,-1.0812),(1.9762,1.2783,-1.2407),(2.0794,1.1024,-1.2407),(2.0087,1.0650,-1.0812),(1.9090,1.2348,-1.0812),(2.0794,1.1024,-1.2407),(2.1670,0.9183,-1.2407),(2.0934,0.8871,-1.0812),(2.0087,1.0650,-1.0812),(2.1670,0.9183,-1.2407),(2.2384,0.7273,-1.2407),(2.1623,0.7026,-1.0812),(2.0934,0.8871,-1.0812),(-2.1623,0.7026,-1.0812),(-2.0934,0.8871,-1.0812),(-2.0296,0.8601,-0.9269),(-2.0965,0.6812,-0.9269),(-2.0934,0.8871,-1.0812),(-2.0087,1.0650,-1.0812),(-1.9476,1.0325,-0.9269),(-2.0296,0.8601,-0.9269),(-2.0087,1.0650,-1.0812),(-1.9090,1.2348,-1.0812),(-1.8509,1.1972,-0.9269),(-1.9476,1.0325,-0.9269),(-1.9090,1.2348,-1.0812),(-1.7950,1.3954,-1.0812),(-1.7403,1.3529,-0.9269),(-1.8509,1.1972,-0.9269),(-1.7950,1.3954,-1.0812),(-1.6674,1.5456,-1.0812),(-1.6167,1.4985,-0.9269),(-1.7403,1.3529,-0.9269),(-1.6674,1.5456,-1.0812),(-1.5274,1.6841,-1.0812),(-1.4809,1.6328,-0.9269),(-1.6167,1.4985,-0.9269),(-1.5274,1.6841,-1.0812),(-1.3759,1.8100,-1.0812),(-1.3340,1.7549,-0.9269),(-1.4809,1.6328,-0.9269),(-1.3759,1.8100,-1.0812),(-1.2141,1.9223,-1.0812),(-1.1771,1.8637,-0.9269),(-1.3340,1.7549,-0.9269),(-1.2141,1.9223,-1.0812),(-1.0431,2.0201,-1.0812),(-1.0114,1.9586,-0.9269),(-1.1771,1.8637,-0.9269),(-1.0431,2.0201,-1.0812),(-0.8644,2.1028,-1.0812),(-0.8380,2.0388,-0.9269),(-1.0114,1.9586,-0.9269),(-0.8644,2.1028,-1.0812),(-0.6791,2.1698,-1.0812),(-0.6584,2.1037,-0.9269),(-0.8380,2.0388,-0.9269),(-0.6791,2.1698,-1.0812),(-0.4887,2.2204,-1.0812),(-0.4739,2.1528,-0.9269),(-0.6584,2.1037,-0.9269),(-0.4887,2.2204,-1.0812),(-0.2947,2.2544,-1.0812),(-0.2858,2.1857,-0.9269),(-0.4739,2.1528,-0.9269),(-0.2947,2.2544,-1.0812),(-0.0985,2.2714,-1.0812),(-0.0955,2.2023,-0.9269),(-0.2858,2.1857,-0.9269),(-0.0985,2.2714,-1.0812),(0.0985,2.2714,-1.0812),(0.0955,2.2023,-0.9269),(-0.0955,2.2023,-0.9269),(0.0985,2.2714,-1.0812),(0.2947,2.2544,-1.0812),(0.2858,2.1857,-0.9269),(0.0955,2.2023,-0.9269),(0.2947,2.2544,-1.0812),(0.4887,2.2204,-1.0812),(0.4739,2.1528,-0.9269),(0.2858,2.1857,-0.9269),(0.4887,2.2204,-1.0812),(0.6791,2.1698,-1.0812),(0.6584,2.1037,-0.9269),(0.4739,2.1528,-0.9269),(0.6791,2.1698,-1.0812),(0.8644,2.1028,-1.0812),(0.8380,2.0388,-0.9269),(0.6584,2.1037,-0.9269),(0.8644,2.1028,-1.0812),(1.0431,2.0201,-1.0812),(1.0114,1.9586,-0.9269),(0.8380,2.0388,-0.9269),(1.0431,2.0201,-1.0812),(1.2141,1.9223,-1.0812),(1.1771,1.8637,-0.9269),(1.0114,1.9586,-0.9269),(1.2141,1.9223,-1.0812),(1.3759,1.8100,-1.0812),(1.3340,1.7549,-0.9269),(1.1771,1.8637,-0.9269),(1.3759,1.8100,-1.0812),(1.5274,1.6841,-1.0812),(1.4809,1.6328,-0.9269),(1.3340,1.7549,-0.9269),(1.5274,1.6841,-1.0812),(1.6674,1.5456,-1.0812),(1.6167,1.4985,-0.9269),(1.4809,1.6328,-0.9269),(1.6674,1.5456,-1.0812),(1.7950,1.3954,-1.0812),(1.7403,1.3529,-0.9269),(1.6167,1.4985,-0.9269),(1.7950,1.3954,-1.0812),(1.9090,1.2348,-1.0812),(1.8509,1.1972,-0.9269),(1.7403,1.3529,-0.9269),(1.9090,1.2348,-1.0812),(2.0087,1.0650,-1.0812),(1.9476,1.0325,-0.9269),(1.8509,1.1972,-0.9269),(2.0087,1.0650,-1.0812),(2.0934,0.8871,-1.0812),(2.0296,0.8601,-0.9269),(1.9476,1.0325,-0.9269),(2.0934,0.8871,-1.0812),(2.1623,0.7026,-1.0812),(2.0965,0.6812,-0.9269),(2.0296,0.8601,-0.9269),(-2.0965,0.6812,-0.9269),(-2.0296,0.8601,-0.9269),(-1.9755,0.8372,-0.7769),(-2.0406,0.6630,-0.7769),(-2.0296,0.8601,-0.9269),(-1.9476,1.0325,-0.9269),(-1.8957,1.0050,-0.7769),(-1.9755,0.8372,-0.7769),(-1.9476,1.0325,-0.9269),(-1.8509,1.1972,-0.9269),(-1.8016,1.1653,-0.7769),(-1.8957,1.0050,-0.7769),(-1.8509,1.1972,-0.9269),(-1.7403,1.3529,-0.9269),(-1.6939,1.3169,-0.7769),(-1.8016,1.1653,-0.7769),(-1.7403,1.3529,-0.9269),(-1.6167,1.4985,-0.9269),(-1.5736,1.4586,-0.7769),(-1.6939,1.3169,-0.7769),(-1.6167,1.4985,-0.9269),(-1.4809,1.6328,-0.9269),(-1.4414,1.5893,-0.7769),(-1.5736,1.4586,-0.7769),(-1.4809,1.6328,-0.9269),(-1.3340,1.7549,-0.9269),(-1.2985,1.7081,-0.7769),(-1.4414,1.5893,-0.7769),(-1.3340,1.7549,-0.9269),(-1.1771,1.8637,-0.9269),(-1.1457,1.8141,-0.7769),(-1.2985,1.7081,-0.7769),(-1.1771,1.8637,-0.9269),(-1.0114,1.9586,-0.9269),(-0.9844,1.9064,-0.7769),(-1.1457,1.8141,-0.7769),(-1.0114,1.9586,-0.9269),(-0.8380,2.0388,-0.9269),(-0.8157,1.9845,-0.7769),(-0.9844,1.9064,-0.7769),(-0.8380,2.0388,-0.9269),(-0.6584,2.1037,-0.9269),(-0.6409,2.0477,-0.7769),(-0.8157,1.9845,-0.7769),(-0.6584,2.1037,-0.9269),(-0.4739,2.1528,-0.9269),(-0.4612,2.0954,-0.7769),(-0.6409,2.0477,-0.7769),(-0.4739,2.1528,-0.9269),(-0.2858,2.1857,-0.9269),(-0.2781,2.1275,-0.7769),(-0.4612,2.0954,-0.7769),(-0.2858,2.1857,-0.9269),(-0.0955,2.2023,-0.9269),(-0.0929,2.1436,-0.7769),(-0.2781,2.1275,-0.7769),(-0.0955,2.2023,-0.9269),(0.0955,2.2023,-0.9269),(0.0929,2.1436,-0.7769),(-0.0929,2.1436,-0.7769),(0.0955,2.2023,-0.9269),(0.2858,2.1857,-0.9269),(0.2781,2.1275,-0.7769),(0.0929,2.1436,-0.7769),(0.2858,2.1857,-0.9269),(0.4739,2.1528,-0.9269),(0.4612,2.0954,-0.7769),(0.2781,2.1275,-0.7769),(0.4739,2.1528,-0.9269),(0.6584,2.1037,-0.9269),(0.6409,2.0477,-0.7769),(0.4612,2.0954,-0.7769),(0.6584,2.1037,-0.9269),(0.8380,2.0388,-0.9269),(0.8157,1.9845,-0.7769),(0.6409,2.0477,-0.7769),(0.8380,2.0388,-0.9269),(1.0114,1.9586,-0.9269),(0.9844,1.9064,-0.7769),(0.8157,1.9845,-0.7769),(1.0114,1.9586,-0.9269),(1.1771,1.8637,-0.9269),(1.1457,1.8141,-0.7769),(0.9844,1.9064,-0.7769),(1.1771,1.8637,-0.9269),(1.3340,1.7549,-0.9269),(1.2985,1.7081,-0.7769),(1.1457,1.8141,-0.7769),(1.3340,1.7549,-0.9269),(1.4809,1.6328,-0.9269),(1.4414,1.5893,-0.7769),(1.2985,1.7081,-0.7769),(1.4809,1.6328,-0.9269),(1.6167,1.4985,-0.9269),(1.5736,1.4586,-0.7769),(1.4414,1.5893,-0.7769),(1.6167,1.4985,-0.9269),(1.7403,1.3529,-0.9269),(1.6939,1.3169,-0.7769),(1.5736,1.4586,-0.7769),(1.7403,1.3529,-0.9269),(1.8509,1.1972,-0.9269),(1.8016,1.1653,-0.7769),(1.6939,1.3169,-0.7769),(1.8509,1.1972,-0.9269),(1.9476,1.0325,-0.9269),(1.8957,1.0050,-0.7769),(1.8016,1.1653,-0.7769),(1.9476,1.0325,-0.9269),(2.0296,0.8601,-0.9269),(1.9755,0.8372,-0.7769),(1.8957,1.0050,-0.7769),(2.0296,0.8601,-0.9269),(2.0965,0.6812,-0.9269),(2.0406,0.6630,-0.7769),(1.9755,0.8372,-0.7769),(-2.0406,0.6630,-0.7769),(-1.9755,0.8372,-0.7769),(-1.9309,0.8182,-0.6307),(-1.9945,0.6480,-0.6307),(-1.9755,0.8372,-0.7769),(-1.8957,1.0050,-0.7769),(-1.8528,0.9823,-0.6307),(-1.9309,0.8182,-0.6307),(-1.8957,1.0050,-0.7769),(-1.8016,1.1653,-0.7769),(-1.7608,1.1390,-0.6307),(-1.8528,0.9823,-0.6307),(-1.8016,1.1653,-0.7769),(-1.6939,1.3169,-0.7769),(-1.6556,1.2871,-0.6307),(-1.7608,1.1390,-0.6307),(-1.6939,1.3169,-0.7769),(-1.5736,1.4586,-0.7769),(-1.5380,1.4256,-0.6307),(-1.6556,1.2871,-0.6307),(-1.5736,1.4586,-0.7769),(-1.4414,1.5893,-0.7769),(-1.4088,1.5534,-0.6307),(-1.5380,1.4256,-0.6307),(-1.4414,1.5893,-0.7769),(-1.2985,1.7081,-0.7769),(-1.2691,1.6695,-0.6307),(-1.4088,1.5534,-0.6307),(-1.2985,1.7081,-0.7769),(-1.1457,1.8141,-0.7769),(-1.1198,1.7731,-0.6307),(-1.2691,1.6695,-0.6307),(-1.1457,1.8141,-0.7769),(-0.9844,1.9064,-0.7769),(-0.9622,1.8633,-0.6307),(-1.1198,1.7731,-0.6307),(-0.9844,1.9064,-0.7769),(-0.8157,1.9845,-0.7769),(-0.7973,1.9396,-0.6307),(-0.9622,1.8633,-0.6307),(-0.8157,1.9845,-0.7769),(-0.6409,2.0477,-0.7769),(-0.6264,2.0014,-0.6307),(-0.7973,1.9396,-0.6307),(-0.6409,2.0477,-0.7769),(-0.4612,2.0954,-0.7769),(-0.4508,2.0481,-0.6307),(-0.6264,2.0014,-0.6307),(-0.4612,2.0954,-0.7769),(-0.2781,2.1275,-0.7769),(-0.2718,2.0794,-0.6307),(-0.4508,2.0481,-0.6307),(-0.2781,2.1275,-0.7769),(-0.0929,2.1436,-0.7769),(-0.0908,2.0951,-0.6307),(-0.2718,2.0794,-0.6307),(-0.0929,2.1436,-0.7769),(0.0929,2.1436,-0.7769),(0.0908,2.0951,-0.6307),(-0.0908,2.0951,-0.6307),(0.0929,2.1436,-0.7769),(0.2781,2.1275,-0.7769),(0.2718,2.0794,-0.6307),(0.0908,2.0951,-0.6307),(0.2781,2.1275,-0.7769),(0.4612,2.0954,-0.7769),(0.4508,2.0481,-0.6307),(0.2718,2.0794,-0.6307),(0.4612,2.0954,-0.7769),(0.6409,2.0477,-0.7769),(0.6264,2.0014,-0.6307),(0.4508,2.0481,-0.6307),(0.6409,2.0477,-0.7769),(0.8157,1.9845,-0.7769),(0.7973,1.9396,-0.6307),(0.6264,2.0014,-0.6307),(0.8157,1.9845,-0.7769),(0.9844,1.9064,-0.7769),(0.9622,1.8633,-0.6307),(0.7973,1.9396,-0.6307),(0.9844,1.9064,-0.7769),(1.1457,1.8141,-0.7769),(1.1198,1.7731,-0.6307),(0.9622,1.8633,-0.6307),(1.1457,1.8141,-0.7769),(1.2985,1.7081,-0.7769),(1.2691,1.6695,-0.6307),(1.1198,1.7731,-0.6307),(1.2985,1.7081,-0.7769),(1.4414,1.5893,-0.7769),(1.4088,1.5534,-0.6307),(1.2691,1.6695,-0.6307),(1.4414,1.5893,-0.7769),(1.5736,1.4586,-0.7769),(1.5380,1.4256,-0.6307),(1.4088,1.5534,-0.6307),(1.5736,1.4586,-0.7769),(1.6939,1.3169,-0.7769),(1.6556,1.2871,-0.6307),(1.5380,1.4256,-0.6307),(1.6939,1.3169,-0.7769),(1.8016,1.1653,-0.7769),(1.7608,1.1390,-0.6307),(1.6556,1.2871,-0.6307),(1.8016,1.1653,-0.7769),(1.8957,1.0050,-0.7769),(1.8528,0.9823,-0.6307),(1.7608,1.1390,-0.6307),(1.8957,1.0050,-0.7769),(1.9755,0.8372,-0.7769),(1.9309,0.8182,-0.6307),(1.8528,0.9823,-0.6307),(1.9755,0.8372,-0.7769),(2.0406,0.6630,-0.7769),(1.9945,0.6480,-0.6307),(1.9309,0.8182,-0.6307),(-1.9945,0.6480,-0.6307),(-1.9309,0.8182,-0.6307),(-1.8954,0.8032,-0.4875),(-1.9578,0.6361,-0.4875),(-1.9309,0.8182,-0.6307),(-1.8528,0.9823,-0.6307),(-1.8188,0.9642,-0.4875),(-1.8954,0.8032,-0.4875),(-1.8528,0.9823,-0.6307),(-1.7608,1.1390,-0.6307),(-1.7285,1.1180,-0.4875),(-1.8188,0.9642,-0.4875),(-1.7608,1.1390,-0.6307),(-1.6556,1.2871,-0.6307),(-1.6252,1.2635,-0.4875),(-1.7285,1.1180,-0.4875),(-1.6556,1.2871,-0.6307),(-1.5380,1.4256,-0.6307),(-1.5097,1.3994,-0.4875),(-1.6252,1.2635,-0.4875),(-1.5380,1.4256,-0.6307),(-1.4088,1.5534,-0.6307),(-1.3830,1.5248,-0.4875),(-1.5097,1.3994,-0.4875),(-1.4088,1.5534,-0.6307),(-1.2691,1.6695,-0.6307),(-1.2458,1.6388,-0.4875),(-1.3830,1.5248,-0.4875),(-1.2691,1.6695,-0.6307),(-1.1198,1.7731,-0.6307),(-1.0993,1.7405,-0.4875),(-1.2458,1.6388,-0.4875),(-1.1198,1.7731,-0.6307),(-0.9622,1.8633,-0.6307),(-0.9445,1.8291,-0.4875),(-1.0993,1.7405,-0.4875),(-0.9622,1.8633,-0.6307),(-0.7973,1.9396,-0.6307),(-0.7826,1.9040,-0.4875),(-0.9445,1.8291,-0.4875),(-0.7973,1.9396,-0.6307),(-0.6264,2.0014,-0.6307),(-0.6149,1.9646,-0.4875),(-0.7826,1.9040,-0.4875),(-0.6264,2.0014,-0.6307),(-0.4508,2.0481,-0.6307),(-0.4425,2.0104,-0.4875),(-0.6149,1.9646,-0.4875),(-0.4508,2.0481,-0.6307),(-0.2718,2.0794,-0.6307),(-0.2669,2.0412,-0.4875),(-0.4425,2.0104,-0.4875),(-0.2718,2.0794,-0.6307),(-0.0908,2.0951,-0.6307),(-0.0892,2.0566,-0.4875),(-0.2669,2.0412,-0.4875),(-0.0908,2.0951,-0.6307),(0.0908,2.0951,-0.6307),(0.0892,2.0566,-0.4875),(-0.0892,2.0566,-0.4875),(0.0908,2.0951,-0.6307),(0.2718,2.0794,-0.6307),(0.2669,2.0412,-0.4875),(0.0892,2.0566,-0.4875),(0.2718,2.0794,-0.6307),(0.4508,2.0481,-0.6307),(0.4425,2.0104,-0.4875),(0.2669,2.0412,-0.4875),(0.4508,2.0481,-0.6307),(0.6264,2.0014,-0.6307),(0.6149,1.9646,-0.4875),(0.4425,2.0104,-0.4875),(0.6264,2.0014,-0.6307),(0.7973,1.9396,-0.6307),(0.7826,1.9040,-0.4875),(0.6149,1.9646,-0.4875),(0.7973,1.9396,-0.6307),(0.9622,1.8633,-0.6307),(0.9445,1.8291,-0.4875),(0.7826,1.9040,-0.4875),(0.9622,1.8633,-0.6307),(1.1198,1.7731,-0.6307),(1.0993,1.7405,-0.4875),(0.9445,1.8291,-0.4875),(1.1198,1.7731,-0.6307),(1.2691,1.6695,-0.6307),(1.2458,1.6388,-0.4875),(1.0993,1.7405,-0.4875),(1.2691,1.6695,-0.6307),(1.4088,1.5534,-0.6307),(1.3830,1.5248,-0.4875),(1.2458,1.6388,-0.4875),(1.4088,1.5534,-0.6307),(1.5380,1.4256,-0.6307),(1.5097,1.3994,-0.4875),(1.3830,1.5248,-0.4875),(1.5380,1.4256,-0.6307),(1.6556,1.2871,-0.6307),(1.6252,1.2635,-0.4875),(1.5097,1.3994,-0.4875),(1.6556,1.2871,-0.6307),(1.7608,1.1390,-0.6307),(1.7285,1.1180,-0.4875),(1.6252,1.2635,-0.4875),(1.7608,1.1390,-0.6307),(1.8528,0.9823,-0.6307),(1.8188,0.9642,-0.4875),(1.7285,1.1180,-0.4875),(1.8528,0.9823,-0.6307),(1.9309,0.8182,-0.6307),(1.8954,0.8032,-0.4875),(1.8188,0.9642,-0.4875),(1.9309,0.8182,-0.6307),(1.9945,0.6480,-0.6307),(1.9578,0.6361,-0.4875),(1.8954,0.8032,-0.4875),(-1.9578,0.6361,-0.4875),(-1.8954,0.8032,-0.4875),(-1.8689,0.7920,-0.3465),(-1.9305,0.6272,-0.3465),(-1.8954,0.8032,-0.4875),(-1.8188,0.9642,-0.4875),(-1.7934,0.9508,-0.3465),(-1.8689,0.7920,-0.3465),(-1.8188,0.9642,-0.4875),(-1.7285,1.1180,-0.4875),(-1.7043,1.1024,-0.3465),(-1.7934,0.9508,-0.3465),(-1.7285,1.1180,-0.4875),(-1.6252,1.2635,-0.4875),(-1.6025,1.2458,-0.3465),(-1.7043,1.1024,-0.3465),(-1.6252,1.2635,-0.4875),(-1.5097,1.3994,-0.4875),(-1.4887,1.3798,-0.3465),(-1.6025,1.2458,-0.3465),(-1.5097,1.3994,-0.4875),(-1.3830,1.5248,-0.4875),(-1.3636,1.5035,-0.3465),(-1.4887,1.3798,-0.3465),(-1.3830,1.5248,-0.4875),(-1.2458,1.6388,-0.4875),(-1.2284,1.6159,-0.3465),(-1.3636,1.5035,-0.3465),(-1.2458,1.6388,-0.4875),(-1.0993,1.7405,-0.4875),(-1.0839,1.7162,-0.3465),(-1.2284,1.6159,-0.3465),(-1.0993,1.7405,-0.4875),(-0.9445,1.8291,-0.4875),(-0.9313,1.8035,-0.3465),(-1.0839,1.7162,-0.3465),(-0.9445,1.8291,-0.4875),(-0.7826,1.9040,-0.4875),(-0.7717,1.8774,-0.3465),(-0.9313,1.8035,-0.3465),(-0.7826,1.9040,-0.4875),(-0.6149,1.9646,-0.4875),(-0.6063,1.9371,-0.3465),(-0.7717,1.8774,-0.3465),(-0.6149,1.9646,-0.4875),(-0.4425,2.0104,-0.4875),(-0.4363,1.9823,-0.3465),(-0.6063,1.9371,-0.3465),(-0.4425,2.0104,-0.4875),(-0.2669,2.0412,-0.4875),(-0.2631,2.0127,-0.3465),(-0.4363,1.9823,-0.3465),(-0.2669,2.0412,-0.4875),(-0.0892,2.0566,-0.4875),(-0.0879,2.0279,-0.3465),(-0.2631,2.0127,-0.3465),(-0.0892,2.0566,-0.4875),(0.0892,2.0566,-0.4875),(0.0879,2.0279,-0.3465),(-0.0879,2.0279,-0.3465),(0.0892,2.0566,-0.4875),(0.2669,2.0412,-0.4875),(0.2631,2.0127,-0.3465),(0.0879,2.0279,-0.3465),(0.2669,2.0412,-0.4875),(0.4425,2.0104,-0.4875),(0.4363,1.9823,-0.3465),(0.2631,2.0127,-0.3465),(0.4425,2.0104,-0.4875),(0.6149,1.9646,-0.4875),(0.6063,1.9371,-0.3465),(0.4363,1.9823,-0.3465),(0.6149,1.9646,-0.4875),(0.7826,1.9040,-0.4875),(0.7717,1.8774,-0.3465),(0.6063,1.9371,-0.3465),(0.7826,1.9040,-0.4875),(0.9445,1.8291,-0.4875),(0.9313,1.8035,-0.3465),(0.7717,1.8774,-0.3465),(0.9445,1.8291,-0.4875),(1.0993,1.7405,-0.4875),(1.0839,1.7162,-0.3465),(0.9313,1.8035,-0.3465),(1.0993,1.7405,-0.4875),(1.2458,1.6388,-0.4875),(1.2284,1.6159,-0.3465),(1.0839,1.7162,-0.3465),(1.2458,1.6388,-0.4875),(1.3830,1.5248,-0.4875),(1.3636,1.5035,-0.3465),(1.2284,1.6159,-0.3465),(1.3830,1.5248,-0.4875),(1.5097,1.3994,-0.4875),(1.4887,1.3798,-0.3465),(1.3636,1.5035,-0.3465),(1.5097,1.3994,-0.4875),(1.6252,1.2635,-0.4875),(1.6025,1.2458,-0.3465),(1.4887,1.3798,-0.3465),(1.6252,1.2635,-0.4875),(1.7285,1.1180,-0.4875),(1.7043,1.1024,-0.3465),(1.6025,1.2458,-0.3465),(1.7285,1.1180,-0.4875),(1.8188,0.9642,-0.4875),(1.7934,0.9508,-0.3465),(1.7043,1.1024,-0.3465),(1.8188,0.9642,-0.4875),(1.8954,0.8032,-0.4875),(1.8689,0.7920,-0.3465),(1.7934,0.9508,-0.3465),(1.8954,0.8032,-0.4875),(1.9578,0.6361,-0.4875),(1.9305,0.6272,-0.3465),(1.8689,0.7920,-0.3465),(-1.9305,0.6272,-0.3465),(-1.8689,0.7920,-0.3465),(-1.8513,0.7845,-0.2073),(-1.9123,0.6213,-0.2073),(-1.8689,0.7920,-0.3465),(-1.7934,0.9508,-0.3465),(-1.7765,0.9418,-0.2073),(-1.8513,0.7845,-0.2073),(-1.7934,0.9508,-0.3465),(-1.7043,1.1024,-0.3465),(-1.6883,1.0921,-0.2073),(-1.7765,0.9418,-0.2073),(-1.7043,1.1024,-0.3465),(-1.6025,1.2458,-0.3465),(-1.5874,1.2341,-0.2073),(-1.6883,1.0921,-0.2073),(-1.6025,1.2458,-0.3465),(-1.4887,1.3798,-0.3465),(-1.4747,1.3669,-0.2073),(-1.5874,1.2341,-0.2073),(-1.4887,1.3798,-0.3465),(-1.3636,1.5035,-0.3465),(-1.3508,1.4894,-0.2073),(-1.4747,1.3669,-0.2073),(-1.3636,1.5035,-0.3465),(-1.2284,1.6159,-0.3465),(-1.2168,1.6007,-0.2073),(-1.3508,1.4894,-0.2073),(-1.2284,1.6159,-0.3465),(-1.0839,1.7162,-0.3465),(-1.0737,1.7000,-0.2073),(-1.2168,1.6007,-0.2073),(-1.0839,1.7162,-0.3465),(-0.9313,1.8035,-0.3465),(-0.9225,1.7866,-0.2073),(-1.0737,1.7000,-0.2073),(-0.9313,1.8035,-0.3465),(-0.7717,1.8774,-0.3465),(-0.7644,1.8597,-0.2073),(-0.9225,1.7866,-0.2073),(-0.7717,1.8774,-0.3465),(-0.6063,1.9371,-0.3465),(-0.6006,1.9189,-0.2073),(-0.7644,1.8597,-0.2073),(-0.6063,1.9371,-0.3465),(-0.4363,1.9823,-0.3465),(-0.4322,1.9637,-0.2073),(-0.6006,1.9189,-0.2073),(-0.4363,1.9823,-0.3465),(-0.2631,2.0127,-0.3465),(-0.2607,1.9937,-0.2073),(-0.4322,1.9637,-0.2073),(-0.2631,2.0127,-0.3465),(-0.0879,2.0279,-0.3465),(-0.0871,2.0088,-0.2073),(-0.2607,1.9937,-0.2073),(-0.0879,2.0279,-0.3465),(0.0879,2.0279,-0.3465),(0.0871,2.0088,-0.2073),(-0.0871,2.0088,-0.2073),(0.0879,2.0279,-0.3465),(0.2631,2.0127,-0.3465),(0.2607,1.9937,-0.2073),(0.0871,2.0088,-0.2073),(0.2631,2.0127,-0.3465),(0.4363,1.9823,-0.3465),(0.4322,1.9637,-0.2073),(0.2607,1.9937,-0.2073),(0.4363,1.9823,-0.3465),(0.6063,1.9371,-0.3465),(0.6006,1.9189,-0.2073),(0.4322,1.9637,-0.2073),(0.6063,1.9371,-0.3465),(0.7717,1.8774,-0.3465),(0.7644,1.8597,-0.2073),(0.6006,1.9189,-0.2073),(0.7717,1.8774,-0.3465),(0.9313,1.8035,-0.3465),(0.9225,1.7866,-0.2073),(0.7644,1.8597,-0.2073),(0.9313,1.8035,-0.3465),(1.0839,1.7162,-0.3465),(1.0737,1.7000,-0.2073),(0.9225,1.7866,-0.2073),(1.0839,1.7162,-0.3465),(1.2284,1.6159,-0.3465),(1.2168,1.6007,-0.2073),(1.0737,1.7000,-0.2073),(1.2284,1.6159,-0.3465),(1.3636,1.5035,-0.3465),(1.3508,1.4894,-0.2073),(1.2168,1.6007,-0.2073),(1.3636,1.5035,-0.3465),(1.4887,1.3798,-0.3465),(1.4747,1.3669,-0.2073),(1.3508,1.4894,-0.2073),(1.4887,1.3798,-0.3465),(1.6025,1.2458,-0.3465),(1.5874,1.2341,-0.2073),(1.4747,1.3669,-0.2073),(1.6025,1.2458,-0.3465),(1.7043,1.1024,-0.3465),(1.6883,1.0921,-0.2073),(1.5874,1.2341,-0.2073),(1.7043,1.1024,-0.3465),(1.7934,0.9508,-0.3465),(1.7765,0.9418,-0.2073),(1.6883,1.0921,-0.2073),(1.7934,0.9508,-0.3465),(1.8689,0.7920,-0.3465),(1.8513,0.7845,-0.2073),(1.7765,0.9418,-0.2073),(1.8689,0.7920,-0.3465),(1.9305,0.6272,-0.3465),(1.9123,0.6213,-0.2073),(1.8513,0.7845,-0.2073),(-1.9123,0.6213,-0.2073),(-1.8513,0.7845,-0.2073),(-1.8426,0.7808,-0.0690),(-1.9032,0.6184,-0.0690),(-1.8513,0.7845,-0.2073),(-1.7765,0.9418,-0.2073),(-1.7681,0.9374,-0.0690),(-1.8426,0.7808,-0.0690),(-1.7765,0.9418,-0.2073),(-1.6883,1.0921,-0.2073),(-1.6803,1.0869,-0.0690),(-1.7681,0.9374,-0.0690),(-1.6883,1.0921,-0.2073),(-1.5874,1.2341,-0.2073),(-1.5799,1.2283,-0.0690),(-1.6803,1.0869,-0.0690),(-1.5874,1.2341,-0.2073),(-1.4747,1.3669,-0.2073),(-1.4677,1.3604,-0.0690),(-1.5799,1.2283,-0.0690),(-1.4747,1.3669,-0.2073),(-1.3508,1.4894,-0.2073),(-1.3444,1.4823,-0.0690),(-1.4677,1.3604,-0.0690),(-1.3508,1.4894,-0.2073),(-1.2168,1.6007,-0.2073),(-1.2111,1.5931,-0.0690),(-1.3444,1.4823,-0.0690),(-1.2168,1.6007,-0.2073),(-1.0737,1.7000,-0.2073),(-1.0686,1.6920,-0.0690),(-1.2111,1.5931,-0.0690),(-1.0737,1.7000,-0.2073),(-0.9225,1.7866,-0.2073),(-0.9182,1.7781,-0.0690),(-1.0686,1.6920,-0.0690),(-0.9225,1.7866,-0.2073),(-0.7644,1.8597,-0.2073),(-0.7608,1.8509,-0.0690),(-0.9182,1.7781,-0.0690),(-0.7644,1.8597,-0.2073),(-0.6006,1.9189,-0.2073),(-0.5977,1.9098,-0.0690),(-0.7608,1.8509,-0.0690),(-0.6006,1.9189,-0.2073),(-0.4322,1.9637,-0.2073),(-0.4302,1.9544,-0.0690),(-0.5977,1.9098,-0.0690),(-0.4322,1.9637,-0.2073),(-0.2607,1.9937,-0.2073),(-0.2594,1.9843,-0.0690),(-0.4302,1.9544,-0.0690),(-0.2607,1.9937,-0.2073),(-0.0871,2.0088,-0.2073),(-0.0867,1.9993,-0.0690),(-0.2594,1.9843,-0.0690),(-0.0871,2.0088,-0.2073),(0.0871,2.0088,-0.2073),(0.0867,1.9993,-0.0690),(-0.0867,1.9993,-0.0690),(0.0871,2.0088,-0.2073),(0.2607,1.9937,-0.2073),(0.2594,1.9843,-0.0690),(0.0867,1.9993,-0.0690),(0.2607,1.9937,-0.2073),(0.4322,1.9637,-0.2073),(0.4302,1.9544,-0.0690),(0.2594,1.9843,-0.0690),(0.4322,1.9637,-0.2073),(0.6006,1.9189,-0.2073),(0.5977,1.9098,-0.0690),(0.4302,1.9544,-0.0690),(0.6006,1.9189,-0.2073),(0.7644,1.8597,-0.2073),(0.7608,1.8509,-0.0690),(0.5977,1.9098,-0.0690),(0.7644,1.8597,-0.2073),(0.9225,1.7866,-0.2073),(0.9182,1.7781,-0.0690),(0.7608,1.8509,-0.0690),(0.9225,1.7866,-0.2073),(1.0737,1.7000,-0.2073),(1.0686,1.6920,-0.0690),(0.9182,1.7781,-0.0690),(1.0737,1.7000,-0.2073),(1.2168,1.6007,-0.2073),(1.2111,1.5931,-0.0690),(1.0686,1.6920,-0.0690),(1.2168,1.6007,-0.2073),(1.3508,1.4894,-0.2073),(1.3444,1.4823,-0.0690),(1.2111,1.5931,-0.0690),(1.3508,1.4894,-0.2073),(1.4747,1.3669,-0.2073),(1.4677,1.3604,-0.0690),(1.3444,1.4823,-0.0690),(1.4747,1.3669,-0.2073),(1.5874,1.2341,-0.2073),(1.5799,1.2283,-0.0690),(1.4677,1.3604,-0.0690),(1.5874,1.2341,-0.2073),(1.6883,1.0921,-0.2073),(1.6803,1.0869,-0.0690),(1.5799,1.2283,-0.0690),(1.6883,1.0921,-0.2073),(1.7765,0.9418,-0.2073),(1.7681,0.9374,-0.0690),(1.6803,1.0869,-0.0690),(1.7765,0.9418,-0.2073),(1.8513,0.7845,-0.2073),(1.8426,0.7808,-0.0690),(1.7681,0.9374,-0.0690),(1.8513,0.7845,-0.2073),(1.9123,0.6213,-0.2073),(1.9032,0.6184,-0.0690),(1.8426,0.7808,-0.0690),(-1.9032,0.6184,-0.0690),(-1.8426,0.7808,-0.0690),(-1.8426,0.7808,0.0690),(-1.9032,0.6184,0.0690),(-1.8426,0.7808,-0.0690),(-1.7681,0.9374,-0.0690),(-1.7681,0.9374,0.0690),(-1.8426,0.7808,0.0690),(-1.7681,0.9374,-0.0690),(-1.6803,1.0869,-0.0690),(-1.6803,1.0869,0.0690),(-1.7681,0.9374,0.0690),(-1.6803,1.0869,-0.0690),(-1.5799,1.2283,-0.0690),(-1.5799,1.2283,0.0690),(-1.6803,1.0869,0.0690),(-1.5799,1.2283,-0.0690),(-1.4677,1.3604,-0.0690),(-1.4677,1.3604,0.0690),(-1.5799,1.2283,0.0690),(-1.4677,1.3604,-0.0690),(-1.3444,1.4823,-0.0690),(-1.3444,1.4823,0.0690),(-1.4677,1.3604,0.0690),(-1.3444,1.4823,-0.0690),(-1.2111,1.5931,-0.0690),(-1.2111,1.5931,0.0690),(-1.3444,1.4823,0.0690),(-1.2111,1.5931,-0.0690),(-1.0686,1.6920,-0.0690),(-1.0686,1.6920,0.0690),(-1.2111,1.5931,0.0690),(-1.0686,1.6920,-0.0690),(-0.9182,1.7781,-0.0690),(-0.9182,1.7781,0.0690),(-1.0686,1.6920,0.0690),(-0.9182,1.7781,-0.0690),(-0.7608,1.8509,-0.0690),(-0.7608,1.8509,0.0690),(-0.9182,1.7781,0.0690),(-0.7608,1.8509,-0.0690),(-0.5977,1.9098,-0.0690),(-0.5977,1.9098,0.0690),(-0.7608,1.8509,0.0690),(-0.5977,1.9098,-0.0690),(-0.4302,1.9544,-0.0690),(-0.4302,1.9544,0.0690),(-0.5977,1.9098,0.0690),(-0.4302,1.9544,-0.0690),(-0.2594,1.9843,-0.0690),(-0.2594,1.9843,0.0690),(-0.4302,1.9544,0.0690),(-0.2594,1.9843,-0.0690),(-0.0867,1.9993,-0.0690),(-0.0867,1.9993,0.0690),(-0.2594,1.9843,0.0690),(-0.0867,1.9993,-0.0690),(0.0867,1.9993,-0.0690),(0.0867,1.9993,0.0690),(-0.0867,1.9993,0.0690),(0.0867,1.9993,-0.0690),(0.2594,1.9843,-0.0690),(0.2594,1.9843,0.0690),(0.0867,1.9993,0.0690),(0.2594,1.9843,-0.0690),(0.4302,1.9544,-0.0690),(0.4302,1.9544,0.0690),(0.2594,1.9843,0.0690),(0.4302,1.9544,-0.0690),(0.5977,1.9098,-0.0690),(0.5977,1.9098,0.0690),(0.4302,1.9544,0.0690),(0.5977,1.9098,-0.0690),(0.7608,1.8509,-0.0690),(0.7608,1.8509,0.0690),(0.5977,1.9098,0.0690),(0.7608,1.8509,-0.0690),(0.9182,1.7781,-0.0690),(0.9182,1.7781,0.0690),(0.7608,1.8509,0.0690),(0.9182,1.7781,-0.0690),(1.0686,1.6920,-0.0690),(1.0686,1.6920,0.0690),(0.9182,1.7781,0.0690),(1.0686,1.6920,-0.0690),(1.2111,1.5931,-0.0690),(1.2111,1.5931,0.0690),(1.0686,1.6920,0.0690),(1.2111,1.5931,-0.0690),(1.3444,1.4823,-0.0690),(1.3444,1.4823,0.0690),(1.2111,1.5931,0.0690),(1.3444,1.4823,-0.0690),(1.4677,1.3604,-0.0690),(1.4677,1.3604,0.0690),(1.3444,1.4823,0.0690),(1.4677,1.3604,-0.0690),(1.5799,1.2283,-0.0690),(1.5799,1.2283,0.0690),(1.4677,1.3604,0.0690),(1.5799,1.2283,-0.0690),(1.6803,1.0869,-0.0690),(1.6803,1.0869,0.0690),(1.5799,1.2283,0.0690),(1.6803,1.0869,-0.0690),(1.7681,0.9374,-0.0690),(1.7681,0.9374,0.0690),(1.6803,1.0869,0.0690),(1.7681,0.9374,-0.0690),(1.8426,0.7808,-0.0690),(1.8426,0.7808,0.0690),(1.7681,0.9374,0.0690),(1.8426,0.7808,-0.0690),(1.9032,0.6184,-0.0690),(1.9032,0.6184,0.0690),(1.8426,0.7808,0.0690),(-1.9032,0.6184,0.0690),(-1.8426,0.7808,0.0690),(-1.8513,0.7845,0.2073),(-1.9123,0.6213,0.2073),(-1.8426,0.7808,0.0690),(-1.7681,0.9374,0.0690),(-1.7765,0.9418,0.2073),(-1.8513,0.7845,0.2073),(-1.7681,0.9374,0.0690),(-1.6803,1.0869,0.0690),(-1.6883,1.0921,0.2073),(-1.7765,0.9418,0.2073),(-1.6803,1.0869,0.0690),(-1.5799,1.2283,0.0690),(-1.5874,1.2341,0.2073),(-1.6883,1.0921,0.2073),(-1.5799,1.2283,0.0690),(-1.4677,1.3604,0.0690),(-1.4747,1.3669,0.2073),(-1.5874,1.2341,0.2073),(-1.4677,1.3604,0.0690),(-1.3444,1.4823,0.0690),(-1.3508,1.4894,0.2073),(-1.4747,1.3669,0.2073),(-1.3444,1.4823,0.0690),(-1.2111,1.5931,0.0690),(-1.2168,1.6007,0.2073),(-1.3508,1.4894,0.2073),(-1.2111,1.5931,0.0690),(-1.0686,1.6920,0.0690),(-1.0737,1.7000,0.2073),(-1.2168,1.6007,0.2073),(-1.0686,1.6920,0.0690),(-0.9182,1.7781,0.0690),(-0.9225,1.7866,0.2073),(-1.0737,1.7000,0.2073),(-0.9182,1.7781,0.0690),(-0.7608,1.8509,0.0690),(-0.7644,1.8597,0.2073),(-0.9225,1.7866,0.2073),(-0.7608,1.8509,0.0690),(-0.5977,1.9098,0.0690),(-0.6006,1.9189,0.2073),(-0.7644,1.8597,0.2073),(-0.5977,1.9098,0.0690),(-0.4302,1.9544,0.0690),(-0.4322,1.9637,0.2073),(-0.6006,1.9189,0.2073),(-0.4302,1.9544,0.0690),(-0.2594,1.9843,0.0690),(-0.2607,1.9937,0.2073),(-0.4322,1.9637,0.2073),(-0.2594,1.9843,0.0690),(-0.0867,1.9993,0.0690),(-0.0871,2.0088,0.2073),(-0.2607,1.9937,0.2073),(-0.0867,1.9993,0.0690),(0.0867,1.9993,0.0690),(0.0871,2.0088,0.2073),(-0.0871,2.0088,0.2073),(0.0867,1.9993,0.0690),(0.2594,1.9843,0.0690),(0.2607,1.9937,0.2073),(0.0871,2.0088,0.2073),(0.2594,1.9843,0.0690),(0.4302,1.9544,0.0690),(0.4322,1.9637,0.2073),(0.2607,1.9937,0.2073),(0.4302,1.9544,0.0690),(0.5977,1.9098,0.0690),(0.6006,1.9189,0.2073),(0.4322,1.9637,0.2073),(0.5977,1.9098,0.0690),(0.7608,1.8509,0.0690),(0.7644,1.8597,0.2073),(0.6006,1.9189,0.2073),(0.7608,1.8509,0.0690),(0.9182,1.7781,0.0690),(0.9225,1.7866,0.2073),(0.7644,1.8597,0.2073),(0.9182,1.7781,0.0690),(1.0686,1.6920,0.0690),(1.0737,1.7000,0.2073),(0.9225,1.7866,0.2073),(1.0686,1.6920,0.0690),(1.2111,1.5931,0.0690),(1.2168,1.6007,0.2073),(1.0737,1.7000,0.2073),(1.2111,1.5931,0.0690),(1.3444,1.4823,0.0690),(1.3508,1.4894,0.2073),(1.2168,1.6007,0.2073),(1.3444,1.4823,0.0690),(1.4677,1.3604,0.0690),(1.4747,1.3669,0.2073),(1.3508,1.4894,0.2073),(1.4677,1.3604,0.0690),(1.5799,1.2283,0.0690),(1.5874,1.2341,0.2073),(1.4747,1.3669,0.2073),(1.5799,1.2283,0.0690),(1.6803,1.0869,0.0690),(1.6883,1.0921,0.2073),(1.5874,1.2341,0.2073),(1.6803,1.0869,0.0690),(1.7681,0.9374,0.0690),(1.7765,0.9418,0.2073),(1.6883,1.0921,0.2073),(1.7681,0.9374,0.0690),(1.8426,0.7808,0.0690),(1.8513,0.7845,0.2073),(1.7765,0.9418,0.2073),(1.8426,0.7808,0.0690),(1.9032,0.6184,0.0690),(1.9123,0.6213,0.2073),(1.8513,0.7845,0.2073),(-1.9123,0.6213,0.2073),(-1.8513,0.7845,0.2073),(-1.8689,0.7920,0.3465),(-1.9305,0.6272,0.3465),(-1.8513,0.7845,0.2073),(-1.7765,0.9418,0.2073),(-1.7934,0.9508,0.3465),(-1.8689,0.7920,0.3465),(-1.7765,0.9418,0.2073),(-1.6883,1.0921,0.2073),(-1.7043,1.1024,0.3465),(-1.7934,0.9508,0.3465),(-1.6883,1.0921,0.2073),(-1.5874,1.2341,0.2073),(-1.6025,1.2458,0.3465),(-1.7043,1.1024,0.3465),(-1.5874,1.2341,0.2073),(-1.4747,1.3669,0.2073),(-1.4887,1.3798,0.3465),(-1.6025,1.2458,0.3465),(-1.4747,1.3669,0.2073),(-1.3508,1.4894,0.2073),(-1.3636,1.5035,0.3465),(-1.4887,1.3798,0.3465),(-1.3508,1.4894,0.2073),(-1.2168,1.6007,0.2073),(-1.2284,1.6159,0.3465),(-1.3636,1.5035,0.3465),(-1.2168,1.6007,0.2073),(-1.0737,1.7000,0.2073),(-1.0839,1.7162,0.3465),(-1.2284,1.6159,0.3465),(-1.0737,1.7000,0.2073),(-0.9225,1.7866,0.2073),(-0.9313,1.8035,0.3465),(-1.0839,1.7162,0.3465),(-0.9225,1.7866,0.2073),(-0.7644,1.8597,0.2073),(-0.7717,1.8774,0.3465),(-0.9313,1.8035,0.3465),(-0.7644,1.8597,0.2073),(-0.6006,1.9189,0.2073),(-0.6063,1.9371,0.3465),(-0.7717,1.8774,0.3465),(-0.6006,1.9189,0.2073),(-0.4322,1.9637,0.2073),(-0.4363,1.9823,0.3465),(-0.6063,1.9371,0.3465),(-0.4322,1.9637,0.2073),(-0.2607,1.9937,0.2073),(-0.2631,2.0127,0.3465),(-0.4363,1.9823,0.3465),(-0.2607,1.9937,0.2073),(-0.0871,2.0088,0.2073),(-0.0879,2.0279,0.3465),(-0.2631,2.0127,0.3465),(-0.0871,2.0088,0.2073),(0.0871,2.0088,0.2073),(0.0879,2.0279,0.3465),(-0.0879,2.0279,0.3465),(0.0871,2.0088,0.2073),(0.2607,1.9937,0.2073),(0.2631,2.0127,0.3465),(0.0879,2.0279,0.3465),(0.2607,1.9937,0.2073),(0.4322,1.9637,0.2073),(0.4363,1.9823,0.3465),(0.2631,2.0127,0.3465),(0.4322,1.9637,0.2073),(0.6006,1.9189,0.2073),(0.6063,1.9371,0.3465),(0.4363,1.9823,0.3465),(0.6006,1.9189,0.2073),(0.7644,1.8597,0.2073),(0.7717,1.8774,0.3465),(0.6063,1.9371,0.3465),(0.7644,1.8597,0.2073),(0.9225,1.7866,0.2073),(0.9313,1.8035,0.3465),(0.7717,1.8774,0.3465),(0.9225,1.7866,0.2073),(1.0737,1.7000,0.2073),(1.0839,1.7162,0.3465),(0.9313,1.8035,0.3465),(1.0737,1.7000,0.2073),(1.2168,1.6007,0.2073),(1.2284,1.6159,0.3465),(1.0839,1.7162,0.3465),(1.2168,1.6007,0.2073),(1.3508,1.4894,0.2073),(1.3636,1.5035,0.3465),(1.2284,1.6159,0.3465),(1.3508,1.4894,0.2073),(1.4747,1.3669,0.2073),(1.4887,1.3798,0.3465),(1.3636,1.5035,0.3465),(1.4747,1.3669,0.2073),(1.5874,1.2341,0.2073),(1.6025,1.2458,0.3465),(1.4887,1.3798,0.3465),(1.5874,1.2341,0.2073),(1.6883,1.0921,0.2073),(1.7043,1.1024,0.3465),(1.6025,1.2458,0.3465),(1.6883,1.0921,0.2073),(1.7765,0.9418,0.2073),(1.7934,0.9508,0.3465),(1.7043,1.1024,0.3465),(1.7765,0.9418,0.2073),(1.8513,0.7845,0.2073),(1.8689,0.7920,0.3465),(1.7934,0.9508,0.3465),(1.8513,0.7845,0.2073),(1.9123,0.6213,0.2073),(1.9305,0.6272,0.3465),(1.8689,0.7920,0.3465),(-1.9305,0.6272,0.3465),(-1.8689,0.7920,0.3465),(-1.8954,0.8032,0.4875),(-1.9578,0.6361,0.4875),(-1.8689,0.7920,0.3465),(-1.7934,0.9508,0.3465),(-1.8188,0.9642,0.4875),(-1.8954,0.8032,0.4875),(-1.7934,0.9508,0.3465),(-1.7043,1.1024,0.3465),(-1.7285,1.1180,0.4875),(-1.8188,0.9642,0.4875),(-1.7043,1.1024,0.3465),(-1.6025,1.2458,0.3465),(-1.6252,1.2635,0.4875),(-1.7285,1.1180,0.4875),(-1.6025,1.2458,0.3465),(-1.4887,1.3798,0.3465),(-1.5097,1.3994,0.4875),(-1.6252,1.2635,0.4875),(-1.4887,1.3798,0.3465),(-1.3636,1.5035,0.3465),(-1.3830,1.5248,0.4875),(-1.5097,1.3994,0.4875),(-1.3636,1.5035,0.3465),(-1.2284,1.6159,0.3465),(-1.2458,1.6388,0.4875),(-1.3830,1.5248,0.4875),(-1.2284,1.6159,0.3465),(-1.0839,1.7162,0.3465),(-1.0993,1.7405,0.4875),(-1.2458,1.6388,0.4875),(-1.0839,1.7162,0.3465),(-0.9313,1.8035,0.3465),(-0.9445,1.8291,0.4875),(-1.0993,1.7405,0.4875),(-0.9313,1.8035,0.3465),(-0.7717,1.8774,0.3465),(-0.7826,1.9040,0.4875),(-0.9445,1.8291,0.4875),(-0.7717,1.8774,0.3465),(-0.6063,1.9371,0.3465),(-0.6149,1.9646,0.4875),(-0.7826,1.9040,0.4875),(-0.6063,1.9371,0.3465),(-0.4363,1.9823,0.3465),(-0.4425,2.0104,0.4875),(-0.6149,1.9646,0.4875),(-0.4363,1.9823,0.3465),(-0.2631,2.0127,0.3465),(-0.2669,2.0412,0.4875),(-0.4425,2.0104,0.4875),(-0.2631,2.0127,0.3465),(-0.0879,2.0279,0.3465),(-0.0892,2.0566,0.4875),(-0.2669,2.0412,0.4875),(-0.0879,2.0279,0.3465),(0.0879,2.0279,0.3465),(0.0892,2.0566,0.4875),(-0.0892,2.0566,0.4875),(0.0879,2.0279,0.3465),(0.2631,2.0127,0.3465),(0.2669,2.0412,0.4875),(0.0892,2.0566,0.4875),(0.2631,2.0127,0.3465),(0.4363,1.9823,0.3465),(0.4425,2.0104,0.4875),(0.2669,2.0412,0.4875),(0.4363,1.9823,0.3465),(0.6063,1.9371,0.3465),(0.6149,1.9646,0.4875),(0.4425,2.0104,0.4875),(0.6063,1.9371,0.3465),(0.7717,1.8774,0.3465),(0.7826,1.9040,0.4875),(0.6149,1.9646,0.4875),(0.7717,1.8774,0.3465),(0.9313,1.8035,0.3465),(0.9445,1.8291,0.4875),(0.7826,1.9040,0.4875),(0.9313,1.8035,0.3465),(1.0839,1.7162,0.3465),(1.0993,1.7405,0.4875),(0.9445,1.8291,0.4875),(1.0839,1.7162,0.3465),(1.2284,1.6159,0.3465),(1.2458,1.6388,0.4875),(1.0993,1.7405,0.4875),(1.2284,1.6159,0.3465),(1.3636,1.5035,0.3465),(1.3830,1.5248,0.4875),(1.2458,1.6388,0.4875),(1.3636,1.5035,0.3465),(1.4887,1.3798,0.3465),(1.5097,1.3994,0.4875),(1.3830,1.5248,0.4875),(1.4887,1.3798,0.3465),(1.6025,1.2458,0.3465),(1.6252,1.2635,0.4875),(1.5097,1.3994,0.4875),(1.6025,1.2458,0.3465),(1.7043,1.1024,0.3465),(1.7285,1.1180,0.4875),(1.6252,1.2635,0.4875),(1.7043,1.1024,0.3465),(1.7934,0.9508,0.3465),(1.8188,0.9642,0.4875),(1.7285,1.1180,0.4875),(1.7934,0.9508,0.3465),(1.8689,0.7920,0.3465),(1.8954,0.8032,0.4875),(1.8188,0.9642,0.4875),(1.8689,0.7920,0.3465),(1.9305,0.6272,0.3465),(1.9578,0.6361,0.4875),(1.8954,0.8032,0.4875),(-1.9578,0.6361,0.4875),(-1.8954,0.8032,0.4875),(-1.9309,0.8182,0.6307),(-1.9945,0.6480,0.6307),(-1.8954,0.8032,0.4875),(-1.8188,0.9642,0.4875),(-1.8528,0.9823,0.6307),(-1.9309,0.8182,0.6307),(-1.8188,0.9642,0.4875),(-1.7285,1.1180,0.4875),(-1.7608,1.1390,0.6307),(-1.8528,0.9823,0.6307),(-1.7285,1.1180,0.4875),(-1.6252,1.2635,0.4875),(-1.6556,1.2871,0.6307),(-1.7608,1.1390,0.6307),(-1.6252,1.2635,0.4875),(-1.5097,1.3994,0.4875),(-1.5380,1.4256,0.6307),(-1.6556,1.2871,0.6307),(-1.5097,1.3994,0.4875),(-1.3830,1.5248,0.4875),(-1.4088,1.5534,0.6307),(-1.5380,1.4256,0.6307),(-1.3830,1.5248,0.4875),(-1.2458,1.6388,0.4875),(-1.2691,1.6695,0.6307),(-1.4088,1.5534,0.6307),(-1.2458,1.6388,0.4875),(-1.0993,1.7405,0.4875),(-1.1198,1.7731,0.6307),(-1.2691,1.6695,0.6307),(-1.0993,1.7405,0.4875),(-0.9445,1.8291,0.4875),(-0.9622,1.8633,0.6307),(-1.1198,1.7731,0.6307),(-0.9445,1.8291,0.4875),(-0.7826,1.9040,0.4875),(-0.7973,1.9396,0.6307),(-0.9622,1.8633,0.6307),(-0.7826,1.9040,0.4875),(-0.6149,1.9646,0.4875),(-0.6264,2.0014,0.6307),(-0.7973,1.9396,0.6307),(-0.6149,1.9646,0.4875),(-0.4425,2.0104,0.4875),(-0.4508,2.0481,0.6307),(-0.6264,2.0014,0.6307),(-0.4425,2.0104,0.4875),(-0.2669,2.0412,0.4875),(-0.2718,2.0794,0.6307),(-0.4508,2.0481,0.6307),(-0.2669,2.0412,0.4875),(-0.0892,2.0566,0.4875),(-0.0908,2.0951,0.6307),(-0.2718,2.0794,0.6307),(-0.0892,2.0566,0.4875),(0.0892,2.0566,0.4875),(0.0908,2.0951,0.6307),(-0.0908,2.0951,0.6307),(0.0892,2.0566,0.4875),(0.2669,2.0412,0.4875),(0.2718,2.0794,0.6307),(0.0908,2.0951,0.6307),(0.2669,2.0412,0.4875),(0.4425,2.0104,0.4875),(0.4508,2.0481,0.6307),(0.2718,2.0794,0.6307),(0.4425,2.0104,0.4875),(0.6149,1.9646,0.4875),(0.6264,2.0014,0.6307),(0.4508,2.0481,0.6307),(0.6149,1.9646,0.4875),(0.7826,1.9040,0.4875),(0.7973,1.9396,0.6307),(0.6264,2.0014,0.6307),(0.7826,1.9040,0.4875),(0.9445,1.8291,0.4875),(0.9622,1.8633,0.6307),(0.7973,1.9396,0.6307),(0.9445,1.8291,0.4875),(1.0993,1.7405,0.4875),(1.1198,1.7731,0.6307),(0.9622,1.8633,0.6307),(1.0993,1.7405,0.4875),(1.2458,1.6388,0.4875),(1.2691,1.6695,0.6307),(1.1198,1.7731,0.6307),(1.2458,1.6388,0.4875),(1.3830,1.5248,0.4875),(1.4088,1.5534,0.6307),(1.2691,1.6695,0.6307),(1.3830,1.5248,0.4875),(1.5097,1.3994,0.4875),(1.5380,1.4256,0.6307),(1.4088,1.5534,0.6307),(1.5097,1.3994,0.4875),(1.6252,1.2635,0.4875),(1.6556,1.2871,0.6307),(1.5380,1.4256,0.6307),(1.6252,1.2635,0.4875),(1.7285,1.1180,0.4875),(1.7608,1.1390,0.6307),(1.6556,1.2871,0.6307),(1.7285,1.1180,0.4875),(1.8188,0.9642,0.4875),(1.8528,0.9823,0.6307),(1.7608,1.1390,0.6307),(1.8188,0.9642,0.4875),(1.8954,0.8032,0.4875),(1.9309,0.8182,0.6307),(1.8528,0.9823,0.6307),(1.8954,0.8032,0.4875),(1.9578,0.6361,0.4875),(1.9945,0.6480,0.6307),(1.9309,0.8182,0.6307),(-1.9945,0.6480,0.6307),(-1.9309,0.8182,0.6307),(-1.9755,0.8372,0.7769),(-2.0406,0.6630,0.7769),(-1.9309,0.8182,0.6307),(-1.8528,0.9823,0.6307),(-1.8957,1.0050,0.7769),(-1.9755,0.8372,0.7769),(-1.8528,0.9823,0.6307),(-1.7608,1.1390,0.6307),(-1.8016,1.1653,0.7769),(-1.8957,1.0050,0.7769),(-1.7608,1.1390,0.6307),(-1.6556,1.2871,0.6307),(-1.6939,1.3169,0.7769),(-1.8016,1.1653,0.7769),(-1.6556,1.2871,0.6307),(-1.5380,1.4256,0.6307),(-1.5736,1.4586,0.7769),(-1.6939,1.3169,0.7769),(-1.5380,1.4256,0.6307),(-1.4088,1.5534,0.6307),(-1.4414,1.5893,0.7769),(-1.5736,1.4586,0.7769),(-1.4088,1.5534,0.6307),(-1.2691,1.6695,0.6307),(-1.2985,1.7081,0.7769),(-1.4414,1.5893,0.7769),(-1.2691,1.6695,0.6307),(-1.1198,1.7731,0.6307),(-1.1457,1.8141,0.7769),(-1.2985,1.7081,0.7769),(-1.1198,1.7731,0.6307),(-0.9622,1.8633,0.6307),(-0.9844,1.9064,0.7769),(-1.1457,1.8141,0.7769),(-0.9622,1.8633,0.6307),(-0.7973,1.9396,0.6307),(-0.8157,1.9845,0.7769),(-0.9844,1.9064,0.7769),(-0.7973,1.9396,0.6307),(-0.6264,2.0014,0.6307),(-0.6409,2.0477,0.7769),(-0.8157,1.9845,0.7769),(-0.6264,2.0014,0.6307),(-0.4508,2.0481,0.6307),(-0.4612,2.0954,0.7769),(-0.6409,2.0477,0.7769),(-0.4508,2.0481,0.6307),(-0.2718,2.0794,0.6307),(-0.2781,2.1275,0.7769),(-0.4612,2.0954,0.7769),(-0.2718,2.0794,0.6307),(-0.0908,2.0951,0.6307),(-0.0929,2.1436,0.7769),(-0.2781,2.1275,0.7769),(-0.0908,2.0951,0.6307),(0.0908,2.0951,0.6307),(0.0929,2.1436,0.7769),(-0.0929,2.1436,0.7769),(0.0908,2.0951,0.6307),(0.2718,2.0794,0.6307),(0.2781,2.1275,0.7769),(0.0929,2.1436,0.7769),(0.2718,2.0794,0.6307),(0.4508,2.0481,0.6307),(0.4612,2.0954,0.7769),(0.2781,2.1275,0.7769),(0.4508,2.0481,0.6307),(0.6264,2.0014,0.6307),(0.6409,2.0477,0.7769),(0.4612,2.0954,0.7769),(0.6264,2.0014,0.6307),(0.7973,1.9396,0.6307),(0.8157,1.9845,0.7769),(0.6409,2.0477,0.7769),(0.7973,1.9396,0.6307),(0.9622,1.8633,0.6307),(0.9844,1.9064,0.7769),(0.8157,1.9845,0.7769),(0.9622,1.8633,0.6307),(1.1198,1.7731,0.6307),(1.1457,1.8141,0.7769),(0.9844,1.9064,0.7769),(1.1198,1.7731,0.6307),(1.2691,1.6695,0.6307),(1.2985,1.7081,0.7769),(1.1457,1.8141,0.7769),(1.2691,1.6695,0.6307),(1.4088,1.5534,0.6307),(1.4414,1.5893,0.7769),(1.2985,1.7081,0.7769),(1.4088,1.5534,0.6307),(1.5380,1.4256,0.6307),(1.5736,1.4586,0.7769),(1.4414,1.5893,0.7769),(1.5380,1.4256,0.6307),(1.6556,1.2871,0.6307),(1.6939,1.3169,0.7769),(1.5736,1.4586,0.7769),(1.6556,1.2871,0.6307),(1.7608,1.1390,0.6307),(1.8016,1.1653,0.7769),(1.6939,1.3169,0.7769),(1.7608,1.1390,0.6307),(1.8528,0.9823,0.6307),(1.8957,1.0050,0.7769),(1.8016,1.1653,0.7769),(1.8528,0.9823,0.6307),(1.9309,0.8182,0.6307),(1.9755,0.8372,0.7769),(1.8957,1.0050,0.7769),(1.9309,0.8182,0.6307),(1.9945,0.6480,0.6307),(2.0406,0.6630,0.7769),(1.9755,0.8372,0.7769),(-2.0406,0.6630,0.7769),(-1.9755,0.8372,0.7769),(-2.0296,0.8601,0.9269),(-2.0965,0.6812,0.9269),(-1.9755,0.8372,0.7769),(-1.8957,1.0050,0.7769),(-1.9476,1.0325,0.9269),(-2.0296,0.8601,0.9269),(-1.8957,1.0050,0.7769),(-1.8016,1.1653,0.7769),(-1.8509,1.1972,0.9269),(-1.9476,1.0325,0.9269),(-1.8016,1.1653,0.7769),(-1.6939,1.3169,0.7769),(-1.7403,1.3529,0.9269),(-1.8509,1.1972,0.9269),(-1.6939,1.3169,0.7769),(-1.5736,1.4586,0.7769),(-1.6167,1.4985,0.9269),(-1.7403,1.3529,0.9269),(-1.5736,1.4586,0.7769),(-1.4414,1.5893,0.7769),(-1.4809,1.6328,0.9269),(-1.6167,1.4985,0.9269),(-1.4414,1.5893,0.7769),(-1.2985,1.7081,0.7769),(-1.3340,1.7549,0.9269),(-1.4809,1.6328,0.9269),(-1.2985,1.7081,0.7769),(-1.1457,1.8141,0.7769),(-1.1771,1.8637,0.9269),(-1.3340,1.7549,0.9269),(-1.1457,1.8141,0.7769),(-0.9844,1.9064,0.7769),(-1.0114,1.9586,0.9269),(-1.1771,1.8637,0.9269),(-0.9844,1.9064,0.7769),(-0.8157,1.9845,0.7769),(-0.8380,2.0388,0.9269),(-1.0114,1.9586,0.9269),(-0.8157,1.9845,0.7769),(-0.6409,2.0477,0.7769),(-0.6584,2.1037,0.9269),(-0.8380,2.0388,0.9269),(-0.6409,2.0477,0.7769),(-0.4612,2.0954,0.7769),(-0.4739,2.1528,0.9269),(-0.6584,2.1037,0.9269),(-0.4612,2.0954,0.7769),(-0.2781,2.1275,0.7769),(-0.2858,2.1857,0.9269),(-0.4739,2.1528,0.9269),(-0.2781,2.1275,0.7769),(-0.0929,2.1436,0.7769),(-0.0955,2.2023,0.9269),(-0.2858,2.1857,0.9269),(-0.0929,2.1436,0.7769),(0.0929,2.1436,0.7769),(0.0955,2.2023,0.9269),(-0.0955,2.2023,0.9269),(0.0929,2.1436,0.7769),(0.2781,2.1275,0.7769),(0.2858,2.1857,0.9269),(0.0955,2.2023,0.9269),(0.2781,2.1275,0.7769),(0.4612,2.0954,0.7769),(0.4739,2.1528,0.9269),(0.2858,2.1857,0.9269),(0.4612,2.0954,0.7769),(0.6409,2.0477,0.7769),(0.6584,2.1037,0.9269),(0.4739,2.1528,0.9269),(0.6409,2.0477,0.7769),(0.8157,1.9845,0.7769),(0.8380,2.0388,0.9269),(0.6584,2.1037,0.9269),(0.8157,1.9845,0.7769),(0.9844,1.9064,0.7769),(1.0114,1.9586,0.9269),(0.8380,2.0388,0.9269),(0.9844,1.9064,0.7769),(1.1457,1.8141,0.7769),(1.1771,1.8637,0.9269),(1.0114,1.9586,0.9269),(1.1457,1.8141,0.7769),(1.2985,1.7081,0.7769),(1.3340,1.7549,0.9269),(1.1771,1.8637,0.9269),(1.2985,1.7081,0.7769),(1.4414,1.5893,0.7769),(1.4809,1.6328,0.9269),(1.3340,1.7549,0.9269),(1.4414,1.5893,0.7769),(1.5736,1.4586,0.7769),(1.6167,1.4985,0.9269),(1.4809,1.6328,0.9269),(1.5736,1.4586,0.7769),(1.6939,1.3169,0.7769),(1.7403,1.3529,0.9269),(1.6167,1.4985,0.9269),(1.6939,1.3169,0.7769),(1.8016,1.1653,0.7769),(1.8509,1.1972,0.9269),(1.7403,1.3529,0.9269),(1.8016,1.1653,0.7769),(1.8957,1.0050,0.7769),(1.9476,1.0325,0.9269),(1.8509,1.1972,0.9269),(1.8957,1.0050,0.7769),(1.9755,0.8372,0.7769),(2.0296,0.8601,0.9269),(1.9476,1.0325,0.9269),(1.9755,0.8372,0.7769),(2.0406,0.6630,0.7769),(2.0965,0.6812,0.9269),(2.0296,0.8601,0.9269),(-2.0965,0.6812,0.9269),(-2.0296,0.8601,0.9269),(-2.0934,0.8871,1.0812),(-2.1623,0.7026,1.0812),(-2.0296,0.8601,0.9269),(-1.9476,1.0325,0.9269),(-2.0087,1.0650,1.0812),(-2.0934,0.8871,1.0812),(-1.9476,1.0325,0.9269),(-1.8509,1.1972,0.9269),(-1.9090,1.2348,1.0812),(-2.0087,1.0650,1.0812),(-1.8509,1.1972,0.9269),(-1.7403,1.3529,0.9269),(-1.7950,1.3954,1.0812),(-1.9090,1.2348,1.0812),(-1.7403,1.3529,0.9269),(-1.6167,1.4985,0.9269),(-1.6674,1.5456,1.0812),(-1.7950,1.3954,1.0812),(-1.6167,1.4985,0.9269),(-1.4809,1.6328,0.9269),(-1.5274,1.6841,1.0812),(-1.6674,1.5456,1.0812),(-1.4809,1.6328,0.9269),(-1.3340,1.7549,0.9269),(-1.3759,1.8100,1.0812),(-1.5274,1.6841,1.0812),(-1.3340,1.7549,0.9269),(-1.1771,1.8637,0.9269),(-1.2141,1.9223,1.0812),(-1.3759,1.8100,1.0812),(-1.1771,1.8637,0.9269),(-1.0114,1.9586,0.9269),(-1.0431,2.0201,1.0812),(-1.2141,1.9223,1.0812),(-1.0114,1.9586,0.9269),(-0.8380,2.0388,0.9269),(-0.8644,2.1028,1.0812),(-1.0431,2.0201,1.0812),(-0.8380,2.0388,0.9269),(-0.6584,2.1037,0.9269),(-0.6791,2.1698,1.0812),(-0.8644,2.1028,1.0812),(-0.6584,2.1037,0.9269),(-0.4739,2.1528,0.9269),(-0.4887,2.2204,1.0812),(-0.6791,2.1698,1.0812),(-0.4739,2.1528,0.9269),(-0.2858,2.1857,0.9269),(-0.2947,2.2544,1.0812),(-0.4887,2.2204,1.0812),(-0.2858,2.1857,0.9269),(-0.0955,2.2023,0.9269),(-0.0985,2.2714,1.0812),(-0.2947,2.2544,1.0812),(-0.0955,2.2023,0.9269),(0.0955,2.2023,0.9269),(0.0985,2.2714,1.0812),(-0.0985,2.2714,1.0812),(0.0955,2.2023,0.9269),(0.2858,2.1857,0.9269),(0.2947,2.2544,1.0812),(0.0985,2.2714,1.0812),(0.2858,2.1857,0.9269),(0.4739,2.1528,0.9269),(0.4887,2.2204,1.0812),(0.2947,2.2544,1.0812),(0.4739,2.1528,0.9269),(0.6584,2.1037,0.9269),(0.6791,2.1698,1.0812),(0.4887,2.2204,1.0812),(0.6584,2.1037,0.9269),(0.8380,2.0388,0.9269),(0.8644,2.1028,1.0812),(0.6791,2.1698,1.0812),(0.8380,2.0388,0.9269),(1.0114,1.9586,0.9269),(1.0431,2.0201,1.0812),(0.8644,2.1028,1.0812),(1.0114,1.9586,0.9269),(1.1771,1.8637,0.9269),(1.2141,1.9223,1.0812),(1.0431,2.0201,1.0812),(1.1771,1.8637,0.9269),(1.3340,1.7549,0.9269),(1.3759,1.8100,1.0812),(1.2141,1.9223,1.0812),(1.3340,1.7549,0.9269),(1.4809,1.6328,0.9269),(1.5274,1.6841,1.0812),(1.3759,1.8100,1.0812),(1.4809,1.6328,0.9269),(1.6167,1.4985,0.9269),(1.6674,1.5456,1.0812),(1.5274,1.6841,1.0812),(1.6167,1.4985,0.9269),(1.7403,1.3529,0.9269),(1.7950,1.3954,1.0812),(1.6674,1.5456,1.0812),(1.7403,1.3529,0.9269),(1.8509,1.1972,0.9269),(1.9090,1.2348,1.0812),(1.7950,1.3954,1.0812),(1.8509,1.1972,0.9269),(1.9476,1.0325,0.9269),(2.0087,1.0650,1.0812),(1.9090,1.2348,1.0812),(1.9476,1.0325,0.9269),(2.0296,0.8601,0.9269),(2.0934,0.8871,1.0812),(2.0087,1.0650,1.0812),(2.0296,0.8601,0.9269),(2.0965,0.6812,0.9269),(2.1623,0.7026,1.0812),(2.0934,0.8871,1.0812),(-2.1623,0.7026,1.0812),(-2.0934,0.8871,1.0812),(-2.1670,0.9183,1.2407),(-2.2384,0.7273,1.2407),(-2.0934,0.8871,1.0812),(-2.0087,1.0650,1.0812),(-2.0794,1.1024,1.2407),(-2.1670,0.9183,1.2407),(-2.0087,1.0650,1.0812),(-1.9090,1.2348,1.0812),(-1.9762,1.2783,1.2407),(-2.0794,1.1024,1.2407),(-1.9090,1.2348,1.0812),(-1.7950,1.3954,1.0812),(-1.8581,1.4445,1.2407),(-1.9762,1.2783,1.2407),(-1.7950,1.3954,1.0812),(-1.6674,1.5456,1.0812),(-1.7261,1.6000,1.2407),(-1.8581,1.4445,1.2407),(-1.6674,1.5456,1.0812),(-1.5274,1.6841,1.0812),(-1.5812,1.7434,1.2407),(-1.7261,1.6000,1.2407),(-1.5274,1.6841,1.0812),(-1.3759,1.8100,1.0812),(-1.4243,1.8737,1.2407),(-1.5812,1.7434,1.2407),(-1.3759,1.8100,1.0812),(-1.2141,1.9223,1.0812),(-1.2568,1.9899,1.2407),(-1.4243,1.8737,1.2407),(-1.2141,1.9223,1.0812),(-1.0431,2.0201,1.0812),(-1.0799,2.0912,1.2407),(-1.2568,1.9899,1.2407),(-1.0431,2.0201,1.0812),(-0.8644,2.1028,1.0812),(-0.8948,2.1769,1.2407),(-1.0799,2.0912,1.2407),(-0.8644,2.1028,1.0812),(-0.6791,2.1698,1.0812),(-0.7030,2.2461,1.2407),(-0.8948,2.1769,1.2407),(-0.6791,2.1698,1.0812),(-0.4887,2.2204,1.0812),(-0.5060,2.2986,1.2407),(-0.7030,2.2461,1.2407),(-0.4887,2.2204,1.0812),(-0.2947,2.2544,1.0812),(-0.3051,2.3337,1.2407),(-0.5060,2.2986,1.2407),(-0.2947,2.2544,1.0812),(-0.0985,2.2714,1.0812),(-0.1020,2.3514,1.2407),(-0.3051,2.3337,1.2407),(-0.0985,2.2714,1.0812),(0.0985,2.2714,1.0812),(0.1020,2.3514,1.2407),(-0.1020,2.3514,1.2407),(0.0985,2.2714,1.0812),(0.2947,2.2544,1.0812),(0.3051,2.3337,1.2407),(0.1020,2.3514,1.2407),(0.2947,2.2544,1.0812),(0.4887,2.2204,1.0812),(0.5060,2.2986,1.2407),(0.3051,2.3337,1.2407),(0.4887,2.2204,1.0812),(0.6791,2.1698,1.0812),(0.7030,2.2461,1.2407),(0.5060,2.2986,1.2407),(0.6791,2.1698,1.0812),(0.8644,2.1028,1.0812),(0.8948,2.1769,1.2407),(0.7030,2.2461,1.2407),(0.8644,2.1028,1.0812),(1.0431,2.0201,1.0812),(1.0799,2.0912,1.2407),(0.8948,2.1769,1.2407),(1.0431,2.0201,1.0812),(1.2141,1.9223,1.0812),(1.2568,1.9899,1.2407),(1.0799,2.0912,1.2407),(1.2141,1.9223,1.0812),(1.3759,1.8100,1.0812),(1.4243,1.8737,1.2407),(1.2568,1.9899,1.2407),(1.3759,1.8100,1.0812),(1.5274,1.6841,1.0812),(1.5812,1.7434,1.2407),(1.4243,1.8737,1.2407),(1.5274,1.6841,1.0812),(1.6674,1.5456,1.0812),(1.7261,1.6000,1.2407),(1.5812,1.7434,1.2407),(1.6674,1.5456,1.0812),(1.7950,1.3954,1.0812),(1.8581,1.4445,1.2407),(1.7261,1.6000,1.2407),(1.7950,1.3954,1.0812),(1.9090,1.2348,1.0812),(1.9762,1.2783,1.2407),(1.8581,1.4445,1.2407),(1.9090,1.2348,1.0812),(2.0087,1.0650,1.0812),(2.0794,1.1024,1.2407),(1.9762,1.2783,1.2407),(2.0087,1.0650,1.0812),(2.0934,0.8871,1.0812),(2.1670,0.9183,1.2407),(2.0794,1.1024,1.2407),(2.0934,0.8871,1.0812),(2.1623,0.7026,1.0812),(2.2384,0.7273,1.2407),(2.1670,0.9183,1.2407),(-2.2384,0.7273,1.2407),(-2.1670,0.9183,1.2407),(-2.2510,0.9539,1.4061),(-2.3252,0.7555,1.4061),(-2.1670,0.9183,1.2407),(-2.0794,1.1024,1.2407),(-2.1600,1.1452,1.4061),(-2.2510,0.9539,1.4061),(-2.0794,1.1024,1.2407),(-1.9762,1.2783,1.2407),(-2.0528,1.3278,1.4061),(-2.1600,1.1452,1.4061),(-1.9762,1.2783,1.2407),(-1.8581,1.4445,1.2407),(-1.9302,1.5005,1.4061),(-2.0528,1.3278,1.4061),(-1.8581,1.4445,1.2407),(-1.7261,1.6000,1.2407),(-1.7930,1.6620,1.4061),(-1.9302,1.5005,1.4061),(-1.7261,1.6000,1.2407),(-1.5812,1.7434,1.2407),(-1.6425,1.8109,1.4061),(-1.7930,1.6620,1.4061),(-1.5812,1.7434,1.2407),(-1.4243,1.8737,1.2407),(-1.4795,1.9463,1.4061),(-1.6425,1.8109,1.4061),(-1.4243,1.8737,1.2407),(-1.2568,1.9899,1.2407),(-1.3055,2.0671,1.4061),(-1.4795,1.9463,1.4061),(-1.2568,1.9899,1.2407),(-1.0799,2.0912,1.2407),(-1.1217,2.1723,1.4061),(-1.3055,2.0671,1.4061),(-1.0799,2.0912,1.2407),(-0.8948,2.1769,1.2407),(-0.9295,2.2613,1.4061),(-1.1217,2.1723,1.4061),(-0.8948,2.1769,1.2407),(-0.7030,2.2461,1.2407),(-0.7303,2.3332,1.4061),(-0.9295,2.2613,1.4061),(-0.7030,2.2461,1.2407),(-0.5060,2.2986,1.2407),(-0.5256,2.3877,1.4061),(-0.7303,2.3332,1.4061),(-0.5060,2.2986,1.2407),(-0.3051,2.3337,1.2407),(-0.3169,2.4242,1.4061),(-0.5256,2.3877,1.4061),(-0.3051,2.3337,1.2407),(-0.1020,2.3514,1.2407),(-0.1059,2.4425,1.4061),(-0.3169,2.4242,1.4061),(-0.1020,2.3514,1.2407),(0.1020,2.3514,1.2407),(0.1059,2.4425,1.4061),(-0.1059,2.4425,1.4061),(0.1020,2.3514,1.2407),(0.3051,2.3337,1.2407),(0.3169,2.4242,1.4061),(0.1059,2.4425,1.4061),(0.3051,2.3337,1.2407),(0.5060,2.2986,1.2407),(0.5256,2.3877,1.4061),(0.3169,2.4242,1.4061),(0.5060,2.2986,1.2407),(0.7030,2.2461,1.2407),(0.7303,2.3332,1.4061),(0.5256,2.3877,1.4061),(0.7030,2.2461,1.2407),(0.8948,2.1769,1.2407),(0.9295,2.2613,1.4061),(0.7303,2.3332,1.4061),(0.8948,2.1769,1.2407),(1.0799,2.0912,1.2407),(1.1217,2.1723,1.4061),(0.9295,2.2613,1.4061),(1.0799,2.0912,1.2407),(1.2568,1.9899,1.2407),(1.3055,2.0671,1.4061),(1.1217,2.1723,1.4061),(1.2568,1.9899,1.2407),(1.4243,1.8737,1.2407),(1.4795,1.9463,1.4061),(1.3055,2.0671,1.4061),(1.4243,1.8737,1.2407),(1.5812,1.7434,1.2407),(1.6425,1.8109,1.4061),(1.4795,1.9463,1.4061),(1.5812,1.7434,1.2407),(1.7261,1.6000,1.2407),(1.7930,1.6620,1.4061),(1.6425,1.8109,1.4061),(1.7261,1.6000,1.2407),(1.8581,1.4445,1.2407),(1.9302,1.5005,1.4061),(1.7930,1.6620,1.4061),(1.8581,1.4445,1.2407),(1.9762,1.2783,1.2407),(2.0528,1.3278,1.4061),(1.9302,1.5005,1.4061),(1.9762,1.2783,1.2407),(2.0794,1.1024,1.2407),(2.1600,1.1452,1.4061),(2.0528,1.3278,1.4061),(2.0794,1.1024,1.2407),(2.1670,0.9183,1.2407),(2.2510,0.9539,1.4061),(2.1600,1.1452,1.4061),(2.1670,0.9183,1.2407),(2.2384,0.7273,1.2407),(2.3252,0.7555,1.4061),(2.2510,0.9539,1.4061),(-2.3252,0.7555,1.4061),(-2.2510,0.9539,1.4061),(-2.3458,0.9941,1.5782),(-2.4230,0.7873,1.5782),(-2.2510,0.9539,1.4061),(-2.1600,1.1452,1.4061),(-2.2509,1.1934,1.5782),(-2.3458,0.9941,1.5782),(-2.1600,1.1452,1.4061),(-2.0528,1.3278,1.4061),(-2.1392,1.3837,1.5782),(-2.2509,1.1934,1.5782),(-2.0528,1.3278,1.4061),(-1.9302,1.5005,1.4061),(-2.0114,1.5637,1.5782),(-2.1392,1.3837,1.5782),(-1.9302,1.5005,1.4061),(-1.7930,1.6620,1.4061),(-1.8685,1.7319,1.5782),(-2.0114,1.5637,1.5782),(-1.7930,1.6620,1.4061),(-1.6425,1.8109,1.4061),(-1.7116,1.8871,1.5782),(-1.8685,1.7319,1.5782),(-1.6425,1.8109,1.4061),(-1.4795,1.9463,1.4061),(-1.5418,2.0282,1.5782),(-1.7116,1.8871,1.5782),(-1.4795,1.9463,1.4061),(-1.3055,2.0671,1.4061),(-1.3605,2.1540,1.5782),(-1.5418,2.0282,1.5782),(-1.3055,2.0671,1.4061),(-1.1217,2.1723,1.4061),(-1.1689,2.2637,1.5782),(-1.3605,2.1540,1.5782),(-1.1217,2.1723,1.4061),(-0.9295,2.2613,1.4061),(-0.9686,2.3564,1.5782),(-1.1689,2.2637,1.5782),(-0.9295,2.2613,1.4061),(-0.7303,2.3332,1.4061),(-0.7610,2.4314,1.5782),(-0.9686,2.3564,1.5782),(-0.7303,2.3332,1.4061),(-0.5256,2.3877,1.4061),(-0.5477,2.4881,1.5782),(-0.7610,2.4314,1.5782),(-0.5256,2.3877,1.4061),(-0.3169,2.4242,1.4061),(-0.3303,2.5262,1.5782),(-0.5477,2.4881,1.5782),(-0.3169,2.4242,1.4061),(-0.1059,2.4425,1.4061),(-0.1104,2.5453,1.5782),(-0.3303,2.5262,1.5782),(-0.1059,2.4425,1.4061),(0.1059,2.4425,1.4061),(0.1104,2.5453,1.5782),(-0.1104,2.5453,1.5782),(0.1059,2.4425,1.4061),(0.3169,2.4242,1.4061),(0.3303,2.5262,1.5782),(0.1104,2.5453,1.5782),(0.3169,2.4242,1.4061),(0.5256,2.3877,1.4061),(0.5477,2.4881,1.5782),(0.3303,2.5262,1.5782),(0.5256,2.3877,1.4061),(0.7303,2.3332,1.4061),(0.7610,2.4314,1.5782),(0.5477,2.4881,1.5782),(0.7303,2.3332,1.4061),(0.9295,2.2613,1.4061),(0.9686,2.3564,1.5782),(0.7610,2.4314,1.5782),(0.9295,2.2613,1.4061),(1.1217,2.1723,1.4061),(1.1689,2.2637,1.5782),(0.9686,2.3564,1.5782),(1.1217,2.1723,1.4061),(1.3055,2.0671,1.4061),(1.3605,2.1540,1.5782),(1.1689,2.2637,1.5782),(1.3055,2.0671,1.4061),(1.4795,1.9463,1.4061),(1.5418,2.0282,1.5782),(1.3605,2.1540,1.5782),(1.4795,1.9463,1.4061),(1.6425,1.8109,1.4061),(1.7116,1.8871,1.5782),(1.5418,2.0282,1.5782),(1.6425,1.8109,1.4061),(1.7930,1.6620,1.4061),(1.8685,1.7319,1.5782),(1.7116,1.8871,1.5782),(1.7930,1.6620,1.4061),(1.9302,1.5005,1.4061),(2.0114,1.5637,1.5782),(1.8685,1.7319,1.5782),(1.9302,1.5005,1.4061),(2.0528,1.3278,1.4061),(2.1392,1.3837,1.5782),(2.0114,1.5637,1.5782),(2.0528,1.3278,1.4061),(2.1600,1.1452,1.4061),(2.2509,1.1934,1.5782),(2.1392,1.3837,1.5782),(2.1600,1.1452,1.4061),(2.2510,0.9539,1.4061),(2.3458,0.9941,1.5782),(2.2509,1.1934,1.5782),(2.2510,0.9539,1.4061),(2.3252,0.7555,1.4061),(2.4230,0.7873,1.5782),(2.3458,0.9941,1.5782),(-2.4230,0.7873,1.5782),(-2.3458,0.9941,1.5782),(-2.4516,1.0389,1.7578),(-2.5324,0.8228,1.7578),(-2.3458,0.9941,1.5782),(-2.2509,1.1934,1.5782),(-2.3525,1.2472,1.7578),(-2.4516,1.0389,1.7578),(-2.2509,1.1934,1.5782),(-2.1392,1.3837,1.5782),(-2.2357,1.4462,1.7578),(-2.3525,1.2472,1.7578),(-2.1392,1.3837,1.5782),(-2.0114,1.5637,1.5782),(-2.1022,1.6343,1.7578),(-2.2357,1.4462,1.7578),(-2.0114,1.5637,1.5782),(-1.8685,1.7319,1.5782),(-1.9528,1.8101,1.7578),(-2.1022,1.6343,1.7578),(-1.8685,1.7319,1.5782),(-1.7116,1.8871,1.5782),(-1.7888,1.9723,1.7578),(-1.9528,1.8101,1.7578),(-1.7116,1.8871,1.5782),(-1.5418,2.0282,1.5782),(-1.6114,2.1197,1.7578),(-1.7888,1.9723,1.7578),(-1.5418,2.0282,1.5782),(-1.3605,2.1540,1.5782),(-1.4219,2.2513,1.7578),(-1.6114,2.1197,1.7578),(-1.3605,2.1540,1.5782),(-1.1689,2.2637,1.5782),(-1.2217,2.3659,1.7578),(-1.4219,2.2513,1.7578),(-1.1689,2.2637,1.5782),(-0.9686,2.3564,1.5782),(-1.0123,2.4627,1.7578),(-1.2217,2.3659,1.7578),(-0.9686,2.3564,1.5782),(-0.7610,2.4314,1.5782),(-0.7953,2.5411,1.7578),(-1.0123,2.4627,1.7578),(-0.7610,2.4314,1.5782),(-0.5477,2.4881,1.5782),(-0.5724,2.6004,1.7578),(-0.7953,2.5411,1.7578),(-0.5477,2.4881,1.5782),(-0.3303,2.5262,1.5782),(-0.3452,2.6402,1.7578),(-0.5724,2.6004,1.7578),(-0.3303,2.5262,1.5782),(-0.1104,2.5453,1.5782),(-0.1153,2.6602,1.7578),(-0.3452,2.6402,1.7578),(-0.1104,2.5453,1.5782),(0.1104,2.5453,1.5782),(0.1153,2.6602,1.7578),(-0.1153,2.6602,1.7578),(0.1104,2.5453,1.5782),(0.3303,2.5262,1.5782),(0.3452,2.6402,1.7578),(0.1153,2.6602,1.7578),(0.3303,2.5262,1.5782),(0.5477,2.4881,1.5782),(0.5724,2.6004,1.7578),(0.3452,2.6402,1.7578),(0.5477,2.4881,1.5782),(0.7610,2.4314,1.5782),(0.7953,2.5411,1.7578),(0.5724,2.6004,1.7578),(0.7610,2.4314,1.5782),(0.9686,2.3564,1.5782),(1.0123,2.4627,1.7578),(0.7953,2.5411,1.7578),(0.9686,2.3564,1.5782),(1.1689,2.2637,1.5782),(1.2217,2.3659,1.7578),(1.0123,2.4627,1.7578),(1.1689,2.2637,1.5782),(1.3605,2.1540,1.5782),(1.4219,2.2513,1.7578),(1.2217,2.3659,1.7578),(1.3605,2.1540,1.5782),(1.5418,2.0282,1.5782),(1.6114,2.1197,1.7578),(1.4219,2.2513,1.7578),(1.5418,2.0282,1.5782),(1.7116,1.8871,1.5782),(1.7888,1.9723,1.7578),(1.6114,2.1197,1.7578),(1.7116,1.8871,1.5782),(1.8685,1.7319,1.5782),(1.9528,1.8101,1.7578),(1.7888,1.9723,1.7578),(1.8685,1.7319,1.5782),(2.0114,1.5637,1.5782),(2.1022,1.6343,1.7578),(1.9528,1.8101,1.7578),(2.0114,1.5637,1.5782),(2.1392,1.3837,1.5782),(2.2357,1.4462,1.7578),(2.1022,1.6343,1.7578),(2.1392,1.3837,1.5782),(2.2509,1.1934,1.5782),(2.3525,1.2472,1.7578),(2.2357,1.4462,1.7578),(2.2509,1.1934,1.5782),(2.3458,0.9941,1.5782),(2.4516,1.0389,1.7578),(2.3525,1.2472,1.7578),(2.3458,0.9941,1.5782),(2.4230,0.7873,1.5782),(2.5324,0.8228,1.7578),(2.4516,1.0389,1.7578),(-2.5324,0.8228,1.7578),(-2.4516,1.0389,1.7578),(-2.5692,1.0887,1.9458),(-2.6538,0.8623,1.9458),(-2.4516,1.0389,1.7578),(-2.3525,1.2472,1.7578),(-2.4653,1.3070,1.9458),(-2.5692,1.0887,1.9458),(-2.3525,1.2472,1.7578),(-2.2357,1.4462,1.7578),(-2.3429,1.5155,1.9458),(-2.4653,1.3070,1.9458),(-2.2357,1.4462,1.7578),(-2.1022,1.6343,1.7578),(-2.2029,1.7126,1.9458),(-2.3429,1.5155,1.9458),(-2.1022,1.6343,1.7578),(-1.9528,1.8101,1.7578),(-2.0464,1.8969,1.9458),(-2.2029,1.7126,1.9458),(-1.9528,1.8101,1.7578),(-1.7888,1.9723,1.7578),(-1.8746,2.0669,1.9458),(-2.0464,1.8969,1.9458),(-1.7888,1.9723,1.7578),(-1.6114,2.1197,1.7578),(-1.6886,2.2214,1.9458),(-1.8746,2.0669,1.9458),(-1.6114,2.1197,1.7578),(-1.4219,2.2513,1.7578),(-1.4900,2.3592,1.9458),(-1.6886,2.2214,1.9458),(-1.4219,2.2513,1.7578),(-1.2217,2.3659,1.7578),(-1.2802,2.4793,1.9458),(-1.4900,2.3592,1.9458),(-1.2217,2.3659,1.7578),(-1.0123,2.4627,1.7578),(-1.0608,2.5808,1.9458),(-1.2802,2.4793,1.9458),(-1.0123,2.4627,1.7578),(-0.7953,2.5411,1.7578),(-0.8335,2.6630,1.9458),(-1.0608,2.5808,1.9458),(-0.7953,2.5411,1.7578),(-0.5724,2.6004,1.7578),(-0.5998,2.7251,1.9458),(-0.8335,2.6630,1.9458),(-0.5724,2.6004,1.7578),(-0.3452,2.6402,1.7578),(-0.3617,2.7668,1.9458),(-0.5998,2.7251,1.9458),(-0.3452,2.6402,1.7578),(-0.1153,2.6602,1.7578),(-0.1209,2.7877,1.9458),(-0.3617,2.7668,1.9458),(-0.1153,2.6602,1.7578),(0.1153,2.6602,1.7578),(0.1209,2.7877,1.9458),(-0.1209,2.7877,1.9458),(0.1153,2.6602,1.7578),(0.3452,2.6402,1.7578),(0.3617,2.7668,1.9458),(0.1209,2.7877,1.9458),(0.3452,2.6402,1.7578),(0.5724,2.6004,1.7578),(0.5998,2.7251,1.9458),(0.3617,2.7668,1.9458),(0.5724,2.6004,1.7578),(0.7953,2.5411,1.7578),(0.8335,2.6630,1.9458),(0.5998,2.7251,1.9458),(0.7953,2.5411,1.7578),(1.0123,2.4627,1.7578),(1.0608,2.5808,1.9458),(0.8335,2.6630,1.9458),(1.0123,2.4627,1.7578),(1.2217,2.3659,1.7578),(1.2802,2.4793,1.9458),(1.0608,2.5808,1.9458),(1.2217,2.3659,1.7578),(1.4219,2.2513,1.7578),(1.4900,2.3592,1.9458),(1.2802,2.4793,1.9458),(1.4219,2.2513,1.7578),(1.6114,2.1197,1.7578),(1.6886,2.2214,1.9458),(1.4900,2.3592,1.9458),(1.6114,2.1197,1.7578),(1.7888,1.9723,1.7578),(1.8746,2.0669,1.9458),(1.6886,2.2214,1.9458),(1.7888,1.9723,1.7578),(1.9528,1.8101,1.7578),(2.0464,1.8969,1.9458),(1.8746,2.0669,1.9458),(1.9528,1.8101,1.7578),(2.1022,1.6343,1.7578),(2.2029,1.7126,1.9458),(2.0464,1.8969,1.9458),(2.1022,1.6343,1.7578),(2.2357,1.4462,1.7578),(2.3429,1.5155,1.9458),(2.2029,1.7126,1.9458),(2.2357,1.4462,1.7578),(2.3525,1.2472,1.7578),(2.4653,1.3070,1.9458),(2.3429,1.5155,1.9458),(2.3525,1.2472,1.7578),(2.4516,1.0389,1.7578),(2.5692,1.0887,1.9458),(2.4653,1.3070,1.9458),(2.4516,1.0389,1.7578),(2.5324,0.8228,1.7578),(2.6538,0.8623,1.9458),(2.5692,1.0887,1.9458),(-2.6538,0.8623,1.9458),(-2.5692,1.0887,1.9458),(-2.6989,1.1437,2.1430),(-2.7878,0.9058,2.1430),(-2.5692,1.0887,1.9458),(-2.4653,1.3070,1.9458),(-2.5898,1.3730,2.1430),(-2.6989,1.1437,2.1430),(-2.4653,1.3070,1.9458),(-2.3429,1.5155,1.9458),(-2.4613,1.5920,2.1430),(-2.5898,1.3730,2.1430),(-2.3429,1.5155,1.9458),(-2.2029,1.7126,1.9458),(-2.3142,1.7991,2.1430),(-2.4613,1.5920,2.1430),(-2.2029,1.7126,1.9458),(-2.0464,1.8969,1.9458),(-2.1498,1.9927,2.1430),(-2.3142,1.7991,2.1430),(-2.0464,1.8969,1.9458),(-1.8746,2.0669,1.9458),(-1.9693,2.1713,2.1430),(-2.1498,1.9927,2.1430),(-1.8746,2.0669,1.9458),(-1.6886,2.2214,1.9458),(-1.7739,2.3336,2.1430),(-1.9693,2.1713,2.1430),(-1.6886,2.2214,1.9458),(-1.4900,2.3592,1.9458),(-1.5653,2.4784,2.1430),(-1.7739,2.3336,2.1430),(-1.4900,2.3592,1.9458),(-1.2802,2.4793,1.9458),(-1.3449,2.6045,2.1430),(-1.5653,2.4784,2.1430),(-1.2802,2.4793,1.9458),(-1.0608,2.5808,1.9458),(-1.1144,2.7112,2.1430),(-1.3449,2.6045,2.1430),(-1.0608,2.5808,1.9458),(-0.8335,2.6630,1.9458),(-0.8756,2.7975,2.1430),(-1.1144,2.7112,2.1430),(-0.8335,2.6630,1.9458),(-0.5998,2.7251,1.9458),(-0.6301,2.8627,2.1430),(-0.8756,2.7975,2.1430),(-0.5998,2.7251,1.9458),(-0.3617,2.7668,1.9458),(-0.3800,2.9065,2.1430),(-0.6301,2.8627,2.1430),(-0.3617,2.7668,1.9458),(-0.1209,2.7877,1.9458),(-0.1270,2.9285,2.1430),(-0.3800,2.9065,2.1430),(-0.1209,2.7877,1.9458),(0.1209,2.7877,1.9458),(0.1270,2.9285,2.1430),(-0.1270,2.9285,2.1430),(0.1209,2.7877,1.9458),(0.3617,2.7668,1.9458),(0.3800,2.9065,2.1430),(0.1270,2.9285,2.1430),(0.3617,2.7668,1.9458),(0.5998,2.7251,1.9458),(0.6301,2.8627,2.1430),(0.3800,2.9065,2.1430),(0.5998,2.7251,1.9458),(0.8335,2.6630,1.9458),(0.8756,2.7975,2.1430),(0.6301,2.8627,2.1430),(0.8335,2.6630,1.9458),(1.0608,2.5808,1.9458),(1.1144,2.7112,2.1430),(0.8756,2.7975,2.1430),(1.0608,2.5808,1.9458),(1.2802,2.4793,1.9458),(1.3449,2.6045,2.1430),(1.1144,2.7112,2.1430),(1.2802,2.4793,1.9458),(1.4900,2.3592,1.9458),(1.5653,2.4784,2.1430),(1.3449,2.6045,2.1430),(1.4900,2.3592,1.9458),(1.6886,2.2214,1.9458),(1.7739,2.3336,2.1430),(1.5653,2.4784,2.1430),(1.6886,2.2214,1.9458),(1.8746,2.0669,1.9458),(1.9693,2.1713,2.1430),(1.7739,2.3336,2.1430),(1.8746,2.0669,1.9458),(2.0464,1.8969,1.9458),(2.1498,1.9927,2.1430),(1.9693,2.1713,2.1430),(2.0464,1.8969,1.9458),(2.2029,1.7126,1.9458),(2.3142,1.7991,2.1430),(2.1498,1.9927,2.1430),(2.2029,1.7126,1.9458),(2.3429,1.5155,1.9458),(2.4613,1.5920,2.1430),(2.3142,1.7991,2.1430),(2.3429,1.5155,1.9458),(2.4653,1.3070,1.9458),(2.5898,1.3730,2.1430),(2.4613,1.5920,2.1430),(2.4653,1.3070,1.9458),(2.5692,1.0887,1.9458),(2.6989,1.1437,2.1430),(2.5898,1.3730,2.1430),(2.5692,1.0887,1.9458),(2.6538,0.8623,1.9458),(2.7878,0.9058,2.1430),(2.6989,1.1437,2.1430),(-2.7878,0.9058,2.1430),(-2.6989,1.1437,2.1430),(-2.8416,1.2041,2.3504),(-2.9351,0.9537,2.3504),(-2.6989,1.1437,2.1430),(-2.5898,1.3730,2.1430),(-2.7267,1.4456,2.3504),(-2.8416,1.2041,2.3504),(-2.5898,1.3730,2.1430),(-2.4613,1.5920,2.1430),(-2.5913,1.6762,2.3504),(-2.7267,1.4456,2.3504),(-2.4613,1.5920,2.1430),(-2.3142,1.7991,2.1430),(-2.4365,1.8942,2.3504),(-2.5913,1.6762,2.3504),(-2.3142,1.7991,2.1430),(-2.1498,1.9927,2.1430),(-2.2634,2.0980,2.3504),(-2.4365,1.8942,2.3504),(-2.1498,1.9927,2.1430),(-1.9693,2.1713,2.1430),(-2.0733,2.2860,2.3504),(-2.2634,2.0980,2.3504),(-1.9693,2.1713,2.1430),(-1.7739,2.3336,2.1430),(-1.8677,2.4569,2.3504),(-2.0733,2.2860,2.3504),(-1.7739,2.3336,2.1430),(-1.5653,2.4784,2.1430),(-1.6480,2.6093,2.3504),(-1.8677,2.4569,2.3504),(-1.5653,2.4784,2.1430),(-1.3449,2.6045,2.1430),(-1.4160,2.7422,2.3504),(-1.6480,2.6093,2.3504),(-1.3449,2.6045,2.1430),(-1.1144,2.7112,2.1430),(-1.1733,2.8544,2.3504),(-1.4160,2.7422,2.3504),(-1.1144,2.7112,2.1430),(-0.8756,2.7975,2.1430),(-0.9218,2.9453,2.3504),(-1.1733,2.8544,2.3504),(-0.8756,2.7975,2.1430),(-0.6301,2.8627,2.1430),(-0.6634,3.0140,2.3504),(-0.9218,2.9453,2.3504),(-0.6301,2.8627,2.1430),(-0.3800,2.9065,2.1430),(-0.4001,3.0601,2.3504),(-0.6634,3.0140,2.3504),(-0.3800,2.9065,2.1430),(-0.1270,2.9285,2.1430),(-0.1337,3.0833,2.3504),(-0.4001,3.0601,2.3504),(-0.1270,2.9285,2.1430),(0.1270,2.9285,2.1430),(0.1337,3.0833,2.3504),(-0.1337,3.0833,2.3504),(0.1270,2.9285,2.1430),(0.3800,2.9065,2.1430),(0.4001,3.0601,2.3504),(0.1337,3.0833,2.3504),(0.3800,2.9065,2.1430),(0.6301,2.8627,2.1430),(0.6634,3.0140,2.3504),(0.4001,3.0601,2.3504),(0.6301,2.8627,2.1430),(0.8756,2.7975,2.1430),(0.9218,2.9453,2.3504),(0.6634,3.0140,2.3504),(0.8756,2.7975,2.1430),(1.1144,2.7112,2.1430),(1.1733,2.8544,2.3504),(0.9218,2.9453,2.3504),(1.1144,2.7112,2.1430),(1.3449,2.6045,2.1430),(1.4160,2.7422,2.3504),(1.1733,2.8544,2.3504),(1.3449,2.6045,2.1430),(1.5653,2.4784,2.1430),(1.6480,2.6093,2.3504),(1.4160,2.7422,2.3504),(1.5653,2.4784,2.1430),(1.7739,2.3336,2.1430),(1.8677,2.4569,2.3504),(1.6480,2.6093,2.3504),(1.7739,2.3336,2.1430),(1.9693,2.1713,2.1430),(2.0733,2.2860,2.3504),(1.8677,2.4569,2.3504),(1.9693,2.1713,2.1430),(2.1498,1.9927,2.1430),(2.2634,2.0980,2.3504),(2.0733,2.2860,2.3504),(2.1498,1.9927,2.1430),(2.3142,1.7991,2.1430),(2.4365,1.8942,2.3504),(2.2634,2.0980,2.3504),(2.3142,1.7991,2.1430),(2.4613,1.5920,2.1430),(2.5913,1.6762,2.3504),(2.4365,1.8942,2.3504),(2.4613,1.5920,2.1430),(2.5898,1.3730,2.1430),(2.7267,1.4456,2.3504),(2.5913,1.6762,2.3504),(2.5898,1.3730,2.1430),(2.6989,1.1437,2.1430),(2.8416,1.2041,2.3504),(2.7267,1.4456,2.3504),(2.6989,1.1437,2.1430),(2.7878,0.9058,2.1430),(2.9351,0.9537,2.3504),(2.8416,1.2041,2.3504)]),
        normal=Normal(vector=[(0.7566,-0.2458,-0.6059),(0.7325,-0.3104,-0.6059),(0.7433,-0.3150,-0.5902),(0.7678,-0.2495,-0.5902),(0.7325,-0.3104,-0.6059),(0.7029,-0.3726,-0.6059),(0.7132,-0.3781,-0.5902),(0.7433,-0.3150,-0.5902),(0.7029,-0.3726,-0.6059),(0.6680,-0.4321,-0.6059),(0.6778,-0.4384,-0.5902),(0.7132,-0.3781,-0.5902),(0.6680,-0.4321,-0.6059),(0.6281,-0.4883,-0.6059),(0.6373,-0.4955,-0.5902),(0.6778,-0.4384,-0.5902),(0.6281,-0.4883,-0.6059),(0.5835,-0.5408,-0.6059),(0.5921,-0.5488,-0.5902),(0.6373,-0.4955,-0.5902),(0.5835,-0.5408,-0.6059),(0.5345,-0.5893,-0.6059),(0.5423,-0.5980,-0.5902),(0.5921,-0.5488,-0.5902),(0.5345,-0.5893,-0.6059),(0.4814,-0.6333,-0.6059),(0.4885,-0.6427,-0.5902),(0.5423,-0.5980,-0.5902),(0.4814,-0.6333,-0.6059),(0.4248,-0.6726,-0.6059),(0.4311,-0.6825,-0.5902),(0.4885,-0.6427,-0.5902),(0.4248,-0.6726,-0.6059),(0.3650,-0.7069,-0.6059),(0.3704,-0.7173,-0.5902),(0.4311,-0.6825,-0.5902),(0.3650,-0.7069,-0.6059),(0.3025,-0.7358,-0.6059),(0.3069,-0.7467,-0.5902),(0.3704,-0.7173,-0.5902),(0.3025,-0.7358,-0.6059),(0.2376,-0.7592,-0.6059),(0.2411,-0.7704,-0.5902),(0.3069,-0.7467,-0.5902),(0.2376,-0.7592,-0.6059),(0.1710,-0.7770,-0.6059),(0.1735,-0.7884,-0.5902),(0.2411,-0.7704,-0.5902),(0.1710,-0.7770,-0.6059),(0.1031,-0.7888,-0.6059),(0.1046,-0.8005,-0.5902),(0.1735,-0.7884,-0.5902),(0.1031,-0.7888,-0.6059),(0.0345,-0.7948,-0.6059),(0.0350,-0.8065,-0.5902),(0.1046,-0.8005,-0.5902),(0.0345,-0.7948,-0.6059),(-0.0345,-0.7948,-0.6059),(-0.0350,-0.8065,-0.5902),(0.0350,-0.8065,-0.5902),(-0.0345,-0.7948,-0.6059),(-0.1031,-0.7888,-0.6059),(-0.1046,-0.8005,-0.5902),(-0.0350,-0.8065,-0.5902),(-0.1031,-0.7888,-0.6059),(-0.1710,-0.7770,-0.6059),(-0.1735,-0.7884,-0.5902),(-0.1046,-0.8005,-0.5902),(-0.1710,-0.7770,-0.6059),(-0.2376,-0.7592,-0.6059),(-0.2411,-0.7704,-0.5902),(-0.1735,-0.7884,-0.5902),(-0.2376,-0.7592,-0.6059),(-0.3025,-0.7358,-0.6059),(-0.3069,-0.7467,-0.5902),(-0.2411,-0.7704,-0.5902),(-0.3025,-0.7358,-0.6059),(-0.3650,-0.7069,-0.6059),(-0.3704,-0.7173,-0.5902),(-0.3069,-0.7467,-0.5902),(-0.3650,-0.7069,-0.6059),(-0.4248,-0.6726,-0.6059),(-0.4311,-0.6825,-0.5902),(-0.3704,-0.7173,-0.5902),(-0.4248,-0.6726,-0.6059),(-0.4814,-0.6333,-0.6059),(-0.4885,-0.6427,-0.5902),(-0.4311,-0.6825,-0.5902),(-0.4814,-0.6333,-0.6059),(-0.5345,-0.5893,-0.6059),(-0.5423,-0.5980,-0.5902),(-0.4885,-0.6427,-0.5902),(-0.5345,-0.5893,-0.6059),(-0.5835,-0.5408,-0.6059),(-0.5921,-0.5488,-0.5902),(-0.5423,-0.5980,-0.5902),(-0.5835,-0.5408,-0.6059),(-0.6281,-0.4883,-0.6059),(-0.6373,-0.4955,-0.5902),(-0.5921,-0.5488,-0.5902),(-0.6281,-0.4883,-0.6059),(-0.6680,-0.4321,-0.6059),(-0.6778,-0.4384,-0.5902),(-0.6373,-0.4955,-0.5902),(-0.6680,-0.4321,-0.6059),(-0.7029,-0.3726,-0.6059),(-0.7132,-0.3781,-0.5902),(-0.6778,-0.4384,-0.5902),(-0.7029,-0.3726,-0.6059),(-0.7325,-0.3104,-0.6059),(-0.7433,-0.3150,-0.5902),(-0.7132,-0.3781,-0.5902),(-0.7325,-0.3104,-0.6059),(-0.7566,-0.2458,-0.6059),(-0.7678,-0.2495,-0.5902),(-0.7433,-0.3150,-0.5902),(0.7678,-0.2495,-0.5902),(0.7433,-0.3150,-0.5902),(0.7552,-0.3200,-0.5720),(0.7801,-0.2535,-0.5720),(0.7433,-0.3150,-0.5902),(0.7132,-0.3781,-0.5902),(0.7247,-0.3842,-0.5720),(0.7552,-0.3200,-0.5720),(0.7132,-0.3781,-0.5902),(0.6778,-0.4384,-0.5902),(0.6887,-0.4455,-0.5720),(0.7247,-0.3842,-0.5720),(0.6778,-0.4384,-0.5902),(0.6373,-0.4955,-0.5902),(0.6476,-0.5034,-0.5720),(0.6887,-0.4455,-0.5720),(0.6373,-0.4955,-0.5902),(0.5921,-0.5488,-0.5902),(0.6016,-0.5576,-0.5720),(0.6476,-0.5034,-0.5720),(0.5921,-0.5488,-0.5902),(0.5423,-0.5980,-0.5902),(0.5511,-0.6076,-0.5720),(0.6016,-0.5576,-0.5720),(0.5423,-0.5980,-0.5902),(0.4885,-0.6427,-0.5902),(0.4964,-0.6530,-0.5720),(0.5511,-0.6076,-0.5720),(0.4885,-0.6427,-0.5902),(0.4311,-0.6825,-0.5902),(0.4380,-0.6935,-0.5720),(0.4964,-0.6530,-0.5720),(0.4311,-0.6825,-0.5902),(0.3704,-0.7173,-0.5902),(0.3763,-0.7288,-0.5720),(0.4380,-0.6935,-0.5720),(0.3704,-0.7173,-0.5902),(0.3069,-0.7467,-0.5902),(0.3118,-0.7587,-0.5720),(0.3763,-0.7288,-0.5720),(0.3069,-0.7467,-0.5902),(0.2411,-0.7704,-0.5902),(0.2450,-0.7828,-0.5720),(0.3118,-0.7587,-0.5720),(0.2411,-0.7704,-0.5902),(0.1735,-0.7884,-0.5902),(0.1763,-0.8011,-0.5720),(0.2450,-0.7828,-0.5720),(0.1735,-0.7884,-0.5902),(0.1046,-0.8005,-0.5902),(0.1063,-0.8133,-0.5720),(0.1763,-0.8011,-0.5720),(0.1046,-0.8005,-0.5902),(0.0350,-0.8065,-0.5902),(0.0355,-0.8195,-0.5720),(0.1063,-0.8133,-0.5720),(0.0350,-0.8065,-0.5902),(-0.0350,-0.8065,-0.5902),(-0.0355,-0.8195,-0.5720),(0.0355,-0.8195,-0.5720),(-0.0350,-0.8065,-0.5902),(-0.1046,-0.8005,-0.5902),(-0.1063,-0.8133,-0.5720),(-0.0355,-0.8195,-0.5720),(-0.1046,-0.8005,-0.5902),(-0.1735,-0.7884,-0.5902),(-0.1763,-0.8011,-0.5720),(-0.1063,-0.8133,-0.5720),(-0.1735,-0.7884,-0.5902),(-0.2411,-0.7704,-0.5902),(-0.2450,-0.7828,-0.5720),(-0.1763,-0.8011,-0.5720),(-0.2411,-0.7704,-0.5902),(-0.3069,-0.7467,-0.5902),(-0.3118,-0.7587,-0.5720),(-0.2450,-0.7828,-0.5720),(-0.3069,-0.7467,-0.5902),(-0.3704,-0.7173,-0.5902),(-0.3763,-0.7288,-0.5720),(-0.3118,-0.7587,-0.5720),(-0.3704,-0.7173,-0.5902),(-0.4311,-0.6825,-0.5902),(-0.4380,-0.6935,-0.5720),(-0.3763,-0.7288,-0.5720),(-0.4311,-0.6825,-0.5902),(-0.4885,-0.6427,-0.5902),(-0.4964,-0.6530,-0.5720),(-0.4380,-0.6935,-0.5720),(-0.4885,-0.6427,-0.5902),(-0.5423,-0.5980,-0.5902),(-0.5511,-0.6076,-0.5720),(-0.4964,-0.6530,-0.5720),(-0.5423,-0.5980,-0.5902),(-0.5921,-0.5488,-0.5902),(-0.6016,-0.5576,-0.5720),(-0.5511,-0.6076,-0.5720),(-0.5921,-0.5488,-0.5902),(-0.6373,-0.4955,-0.5902),(-0.6476,-0.5034,-0.5720),(-0.6016,-0.5576,-0.5720),(-0.6373,-0.4955,-0.5902),(-0.6778,-0.4384,-0.5902),(-0.6887,-0.4455,-0.5720),(-0.6476,-0.5034,-0.5720),(-0.6778,-0.4384,-0.5902),(-0.7132,-0.3781,-0.5902),(-0.7247,-0.3842,-0.5720),(-0.6887,-0.4455,-0.5720),(-0.7132,-0.3781,-0.5902),(-0.7433,-0.3150,-0.5902),(-0.7552,-0.3200,-0.5720),(-0.7247,-0.3842,-0.5720),(-0.7433,-0.3150,-0.5902),(-0.7678,-0.2495,-0.5902),(-0.7801,-0.2535,-0.5720),(-0.7552,-0.3200,-0.5720),(0.7801,-0.2535,-0.5720),(0.7552,-0.3200,-0.5720),(0.7684,-0.3256,-0.5509),(0.7937,-0.2579,-0.5509),(0.7552,-0.3200,-0.5720),(0.7247,-0.3842,-0.5720),(0.7373,-0.3909,-0.5509),(0.7684,-0.3256,-0.5509),(0.7247,-0.3842,-0.5720),(0.6887,-0.4455,-0.5720),(0.7007,-0.4533,-0.5509),(0.7373,-0.3909,-0.5509),(0.6887,-0.4455,-0.5720),(0.6476,-0.5034,-0.5720),(0.6589,-0.5122,-0.5509),(0.7007,-0.4533,-0.5509),(0.6476,-0.5034,-0.5720),(0.6016,-0.5576,-0.5720),(0.6121,-0.5673,-0.5509),(0.6589,-0.5122,-0.5509),(0.6016,-0.5576,-0.5720),(0.5511,-0.6076,-0.5720),(0.5607,-0.6182,-0.5509),(0.6121,-0.5673,-0.5509),(0.5511,-0.6076,-0.5720),(0.4964,-0.6530,-0.5720),(0.5050,-0.6644,-0.5509),(0.5607,-0.6182,-0.5509),(0.4964,-0.6530,-0.5720),(0.4380,-0.6935,-0.5720),(0.4456,-0.7056,-0.5509),(0.5050,-0.6644,-0.5509),(0.4380,-0.6935,-0.5720),(0.3763,-0.7288,-0.5720),(0.3829,-0.7415,-0.5509),(0.4456,-0.7056,-0.5509),(0.3763,-0.7288,-0.5720),(0.3118,-0.7587,-0.5720),(0.3173,-0.7719,-0.5509),(0.3829,-0.7415,-0.5509),(0.3118,-0.7587,-0.5720),(0.2450,-0.7828,-0.5720),(0.2493,-0.7964,-0.5509),(0.3173,-0.7719,-0.5509),(0.2450,-0.7828,-0.5720),(0.1763,-0.8011,-0.5720),(0.1794,-0.8150,-0.5509),(0.2493,-0.7964,-0.5509),(0.1763,-0.8011,-0.5720),(0.1063,-0.8133,-0.5720),(0.1082,-0.8275,-0.5509),(0.1794,-0.8150,-0.5509),(0.1063,-0.8133,-0.5720),(0.0355,-0.8195,-0.5720),(0.0362,-0.8338,-0.5509),(0.1082,-0.8275,-0.5509),(0.0355,-0.8195,-0.5720),(-0.0355,-0.8195,-0.5720),(-0.0362,-0.8338,-0.5509),(0.0362,-0.8338,-0.5509),(-0.0355,-0.8195,-0.5720),(-0.1063,-0.8133,-0.5720),(-0.1082,-0.8275,-0.5509),(-0.0362,-0.8338,-0.5509),(-0.1063,-0.8133,-0.5720),(-0.1763,-0.8011,-0.5720),(-0.1794,-0.8150,-0.5509),(-0.1082,-0.8275,-0.5509),(-0.1763,-0.8011,-0.5720),(-0.2450,-0.7828,-0.5720),(-0.2493,-0.7964,-0.5509),(-0.1794,-0.8150,-0.5509),(-0.2450,-0.7828,-0.5720),(-0.3118,-0.7587,-0.5720),(-0.3173,-0.7719,-0.5509),(-0.2493,-0.7964,-0.5509),(-0.3118,-0.7587,-0.5720),(-0.3763,-0.7288,-0.5720),(-0.3829,-0.7415,-0.5509),(-0.3173,-0.7719,-0.5509),(-0.3763,-0.7288,-0.5720),(-0.4380,-0.6935,-0.5720),(-0.4456,-0.7056,-0.5509),(-0.3829,-0.7415,-0.5509),(-0.4380,-0.6935,-0.5720),(-0.4964,-0.6530,-0.5720),(-0.5050,-0.6644,-0.5509),(-0.4456,-0.7056,-0.5509),(-0.4964,-0.6530,-0.5720),(-0.5511,-0.6076,-0.5720),(-0.5607,-0.6182,-0.5509),(-0.5050,-0.6644,-0.5509),(-0.5511,-0.6076,-0.5720),(-0.6016,-0.5576,-0.5720),(-0.6121,-0.5673,-0.5509),(-0.5607,-0.6182,-0.5509),(-0.6016,-0.5576,-0.5720),(-0.6476,-0.5034,-0.5720),(-0.6589,-0.5122,-0.5509),(-0.6121,-0.5673,-0.5509),(-0.6476,-0.5034,-0.5720),(-0.6887,-0.4455,-0.5720),(-0.7007,-0.4533,-0.5509),(-0.6589,-0.5122,-0.5509),(-0.6887,-0.4455,-0.5720),(-0.7247,-0.3842,-0.5720),(-0.7373,-0.3909,-0.5509),(-0.7007,-0.4533,-0.5509),(-0.7247,-0.3842,-0.5720),(-0.7552,-0.3200,-0.5720),(-0.7684,-0.3256,-0.5509),(-0.7373,-0.3909,-0.5509),(-0.7552,-0.3200,-0.5720),(-0.7801,-0.2535,-0.5720),(-0.7937,-0.2579,-0.5509),(-0.7684,-0.3256,-0.5509),(0.7937,-0.2579,-0.5509),(0.7684,-0.3256,-0.5509),(0.7827,-0.3317,-0.5266),(0.8085,-0.2627,-0.5266),(0.7684,-0.3256,-0.5509),(0.7373,-0.3909,-0.5509),(0.7511,-0.3982,-0.5266),(0.7827,-0.3317,-0.5266),(0.7373,-0.3909,-0.5509),(0.7007,-0.4533,-0.5509),(0.7138,-0.4617,-0.5266),(0.7511,-0.3982,-0.5266),(0.7007,-0.4533,-0.5509),(0.6589,-0.5122,-0.5509),(0.6712,-0.5218,-0.5266),(0.7138,-0.4617,-0.5266),(0.6589,-0.5122,-0.5509),(0.6121,-0.5673,-0.5509),(0.6235,-0.5779,-0.5266),(0.6712,-0.5218,-0.5266),(0.6121,-0.5673,-0.5509),(0.5607,-0.6182,-0.5509),(0.5711,-0.6297,-0.5266),(0.6235,-0.5779,-0.5266),(0.5607,-0.6182,-0.5509),(0.5050,-0.6644,-0.5509),(0.5145,-0.6768,-0.5266),(0.5711,-0.6297,-0.5266),(0.5050,-0.6644,-0.5509),(0.4456,-0.7056,-0.5509),(0.4540,-0.7188,-0.5266),(0.5145,-0.6768,-0.5266),(0.4456,-0.7056,-0.5509),(0.3829,-0.7415,-0.5509),(0.3900,-0.7553,-0.5266),(0.4540,-0.7188,-0.5266),(0.3829,-0.7415,-0.5509),(0.3173,-0.7719,-0.5509),(0.3232,-0.7863,-0.5266),(0.3900,-0.7553,-0.5266),(0.3173,-0.7719,-0.5509),(0.2493,-0.7964,-0.5509),(0.2539,-0.8113,-0.5266),(0.3232,-0.7863,-0.5266),(0.2493,-0.7964,-0.5509),(0.1794,-0.8150,-0.5509),(0.1827,-0.8302,-0.5266),(0.2539,-0.8113,-0.5266),(0.1794,-0.8150,-0.5509),(0.1082,-0.8275,-0.5509),(0.1102,-0.8429,-0.5266),(0.1827,-0.8302,-0.5266),(0.1082,-0.8275,-0.5509),(0.0362,-0.8338,-0.5509),(0.0368,-0.8493,-0.5266),(0.1102,-0.8429,-0.5266),(0.0362,-0.8338,-0.5509),(-0.0362,-0.8338,-0.5509),(-0.0368,-0.8493,-0.5266),(0.0368,-0.8493,-0.5266),(-0.0362,-0.8338,-0.5509),(-0.1082,-0.8275,-0.5509),(-0.1102,-0.8429,-0.5266),(-0.0368,-0.8493,-0.5266),(-0.1082,-0.8275,-0.5509),(-0.1794,-0.8150,-0.5509),(-0.1827,-0.8302,-0.5266),(-0.1102,-0.8429,-0.5266),(-0.1794,-0.8150,-0.5509),(-0.2493,-0.7964,-0.5509),(-0.2539,-0.8113,-0.5266),(-0.1827,-0.8302,-0.5266),(-0.2493,-0.7964,-0.5509),(-0.3173,-0.7719,-0.5509),(-0.3232,-0.7863,-0.5266),(-0.2539,-0.8113,-0.5266),(-0.3173,-0.7719,-0.5509),(-0.3829,-0.7415,-0.5509),(-0.3900,-0.7553,-0.5266),(-0.3232,-0.7863,-0.5266),(-0.3829,-0.7415,-0.5509),(-0.4456,-0.7056,-0.5509),(-0.4540,-0.7188,-0.5266),(-0.3900,-0.7553,-0.5266),(-0.4456,-0.7056,-0.5509),(-0.5050,-0.6644,-0.5509),(-0.5145,-0.6768,-0.5266),(-0.4540,-0.7188,-0.5266),(-0.5050,-0.6644,-0.5509),(-0.5607,-0.6182,-0.5509),(-0.5711,-0.6297,-0.5266),(-0.5145,-0.6768,-0.5266),(-0.5607,-0.6182,-0.5509),(-0.6121,-0.5673,-0.5509),(-0.6235,-0.5779,-0.5266),(-0.5711,-0.6297,-0.5266),(-0.6121,-0.5673,-0.5509),(-0.6589,-0.5122,-0.5509),(-0.6712,-0.5218,-0.5266),(-0.6235,-0.5779,-0.5266),(-0.6589,-0.5122,-0.5509),(-0.7007,-0.4533,-0.5509),(-0.7138,-0.4617,-0.5266),(-0.6712,-0.5218,-0.5266),(-0.7007,-0.4533,-0.5509),(-0.7373,-0.3909,-0.5509),(-0.7511,-0.3982,-0.5266),(-0.7138,-0.4617,-0.5266),(-0.7373,-0.3909,-0.5509),(-0.7684,-0.3256,-0.5509),(-0.7827,-0.3317,-0.5266),(-0.7511,-0.3982,-0.5266),(-0.7684,-0.3256,-0.5509),(-0.7937,-0.2579,-0.5509),(-0.8085,-0.2627,-0.5266),(-0.7827,-0.3317,-0.5266),(0.8085,-0.2627,-0.5266),(0.7827,-0.3317,-0.5266),(0.7981,-0.3382,-0.4986),(0.8244,-0.2679,-0.4986),(0.7827,-0.3317,-0.5266),(0.7511,-0.3982,-0.5266),(0.7659,-0.4060,-0.4986),(0.7981,-0.3382,-0.4986),(0.7511,-0.3982,-0.5266),(0.7138,-0.4617,-0.5266),(0.7279,-0.4708,-0.4986),(0.7659,-0.4060,-0.4986),(0.7138,-0.4617,-0.5266),(0.6712,-0.5218,-0.5266),(0.6844,-0.5320,-0.4986),(0.7279,-0.4708,-0.4986),(0.6712,-0.5218,-0.5266),(0.6235,-0.5779,-0.5266),(0.6358,-0.5893,-0.4986),(0.6844,-0.5320,-0.4986),(0.6235,-0.5779,-0.5266),(0.5711,-0.6297,-0.5266),(0.5824,-0.6421,-0.4986),(0.6358,-0.5893,-0.4986),(0.5711,-0.6297,-0.5266),(0.5145,-0.6768,-0.5266),(0.5246,-0.6901,-0.4986),(0.5824,-0.6421,-0.4986),(0.5145,-0.6768,-0.5266),(0.4540,-0.7188,-0.5266),(0.4629,-0.7329,-0.4986),(0.5246,-0.6901,-0.4986),(0.4540,-0.7188,-0.5266),(0.3900,-0.7553,-0.5266),(0.3977,-0.7702,-0.4986),(0.4629,-0.7329,-0.4986),(0.3900,-0.7553,-0.5266),(0.3232,-0.7863,-0.5266),(0.3296,-0.8018,-0.4986),(0.3977,-0.7702,-0.4986),(0.3232,-0.7863,-0.5266),(0.2539,-0.8113,-0.5266),(0.2589,-0.8273,-0.4986),(0.3296,-0.8018,-0.4986),(0.2539,-0.8113,-0.5266),(0.1827,-0.8302,-0.5266),(0.1863,-0.8466,-0.4986),(0.2589,-0.8273,-0.4986),(0.1827,-0.8302,-0.5266),(0.1102,-0.8429,-0.5266),(0.1124,-0.8595,-0.4986),(0.1863,-0.8466,-0.4986),(0.1102,-0.8429,-0.5266),(0.0368,-0.8493,-0.5266),(0.0376,-0.8660,-0.4986),(0.1124,-0.8595,-0.4986),(0.0368,-0.8493,-0.5266),(-0.0368,-0.8493,-0.5266),(-0.0376,-0.8660,-0.4986),(0.0376,-0.8660,-0.4986),(-0.0368,-0.8493,-0.5266),(-0.1102,-0.8429,-0.5266),(-0.1124,-0.8595,-0.4986),(-0.0376,-0.8660,-0.4986),(-0.1102,-0.8429,-0.5266),(-0.1827,-0.8302,-0.5266),(-0.1863,-0.8466,-0.4986),(-0.1124,-0.8595,-0.4986),(-0.1827,-0.8302,-0.5266),(-0.2539,-0.8113,-0.5266),(-0.2589,-0.8273,-0.4986),(-0.1863,-0.8466,-0.4986),(-0.2539,-0.8113,-0.5266),(-0.3232,-0.7863,-0.5266),(-0.3296,-0.8018,-0.4986),(-0.2589,-0.8273,-0.4986),(-0.3232,-0.7863,-0.5266),(-0.3900,-0.7553,-0.5266),(-0.3977,-0.7702,-0.4986),(-0.3296,-0.8018,-0.4986),(-0.3900,-0.7553,-0.5266),(-0.4540,-0.7188,-0.5266),(-0.4629,-0.7329,-0.4986),(-0.3977,-0.7702,-0.4986),(-0.4540,-0.7188,-0.5266),(-0.5145,-0.6768,-0.5266),(-0.5246,-0.6901,-0.4986),(-0.4629,-0.7329,-0.4986),(-0.5145,-0.6768,-0.5266),(-0.5711,-0.6297,-0.5266),(-0.5824,-0.6421,-0.4986),(-0.5246,-0.6901,-0.4986),(-0.5711,-0.6297,-0.5266),(-0.6235,-0.5779,-0.5266),(-0.6358,-0.5893,-0.4986),(-0.5824,-0.6421,-0.4986),(-0.6235,-0.5779,-0.5266),(-0.6712,-0.5218,-0.5266),(-0.6844,-0.5320,-0.4986),(-0.6358,-0.5893,-0.4986),(-0.6712,-0.5218,-0.5266),(-0.7138,-0.4617,-0.5266),(-0.7279,-0.4708,-0.4986),(-0.6844,-0.5320,-0.4986),(-0.7138,-0.4617,-0.5266),(-0.7511,-0.3982,-0.5266),(-0.7659,-0.4060,-0.4986),(-0.7279,-0.4708,-0.4986),(-0.7511,-0.3982,-0.5266),(-0.7827,-0.3317,-0.5266),(-0.7981,-0.3382,-0.4986),(-0.7659,-0.4060,-0.4986),(-0.7827,-0.3317,-0.5266),(-0.8085,-0.2627,-0.5266),(-0.8244,-0.2679,-0.4986),(-0.7981,-0.3382,-0.4986),(0.8244,-0.2679,-0.4986),(0.7981,-0.3382,-0.4986),(0.8145,-0.3452,-0.4663),(0.8413,-0.2734,-0.4663),(0.7981,-0.3382,-0.4986),(0.7659,-0.4060,-0.4986),(0.7816,-0.4144,-0.4663),(0.8145,-0.3452,-0.4663),(0.7659,-0.4060,-0.4986),(0.7279,-0.4708,-0.4986),(0.7428,-0.4805,-0.4663),(0.7816,-0.4144,-0.4663),(0.7279,-0.4708,-0.4986),(0.6844,-0.5320,-0.4986),(0.6984,-0.5429,-0.4663),(0.7428,-0.4805,-0.4663),(0.6844,-0.5320,-0.4986),(0.6358,-0.5893,-0.4986),(0.6488,-0.6014,-0.4663),(0.6984,-0.5429,-0.4663),(0.6358,-0.5893,-0.4986),(0.5824,-0.6421,-0.4986),(0.5943,-0.6553,-0.4663),(0.6488,-0.6014,-0.4663),(0.5824,-0.6421,-0.4986),(0.5246,-0.6901,-0.4986),(0.5353,-0.7042,-0.4663),(0.5943,-0.6553,-0.4663),(0.5246,-0.6901,-0.4986),(0.4629,-0.7329,-0.4986),(0.4724,-0.7479,-0.4663),(0.5353,-0.7042,-0.4663),(0.4629,-0.7329,-0.4986),(0.3977,-0.7702,-0.4986),(0.4059,-0.7860,-0.4663),(0.4724,-0.7479,-0.4663),(0.3977,-0.7702,-0.4986),(0.3296,-0.8018,-0.4986),(0.3363,-0.8182,-0.4663),(0.4059,-0.7860,-0.4663),(0.3296,-0.8018,-0.4986),(0.2589,-0.8273,-0.4986),(0.2642,-0.8442,-0.4663),(0.3363,-0.8182,-0.4663),(0.2589,-0.8273,-0.4986),(0.1863,-0.8466,-0.4986),(0.1902,-0.8639,-0.4663),(0.2642,-0.8442,-0.4663),(0.1863,-0.8466,-0.4986),(0.1124,-0.8595,-0.4986),(0.1147,-0.8771,-0.4663),(0.1902,-0.8639,-0.4663),(0.1124,-0.8595,-0.4986),(0.0376,-0.8660,-0.4986),(0.0383,-0.8838,-0.4663),(0.1147,-0.8771,-0.4663),(0.0376,-0.8660,-0.4986),(-0.0376,-0.8660,-0.4986),(-0.0383,-0.8838,-0.4663),(0.0383,-0.8838,-0.4663),(-0.0376,-0.8660,-0.4986),(-0.1124,-0.8595,-0.4986),(-0.1147,-0.8771,-0.4663),(-0.0383,-0.8838,-0.4663),(-0.1124,-0.8595,-0.4986),(-0.1863,-0.8466,-0.4986),(-0.1902,-0.8639,-0.4663),(-0.1147,-0.8771,-0.4663),(-0.1863,-0.8466,-0.4986),(-0.2589,-0.8273,-0.4986),(-0.2642,-0.8442,-0.4663),(-0.1902,-0.8639,-0.4663),(-0.2589,-0.8273,-0.4986),(-0.3296,-0.8018,-0.4986),(-0.3363,-0.8182,-0.4663),(-0.2642,-0.8442,-0.4663),(-0.3296,-0.8018,-0.4986),(-0.3977,-0.7702,-0.4986),(-0.4059,-0.7860,-0.4663),(-0.3363,-0.8182,-0.4663),(-0.3977,-0.7702,-0.4986),(-0.4629,-0.7329,-0.4986),(-0.4724,-0.7479,-0.4663),(-0.4059,-0.7860,-0.4663),(-0.4629,-0.7329,-0.4986),(-0.5246,-0.6901,-0.4986),(-0.5353,-0.7042,-0.4663),(-0.4724,-0.7479,-0.4663),(-0.5246,-0.6901,-0.4986),(-0.5824,-0.6421,-0.4986),(-0.5943,-0.6553,-0.4663),(-0.5353,-0.7042,-0.4663),(-0.5824,-0.6421,-0.4986),(-0.6358,-0.5893,-0.4986),(-0.6488,-0.6014,-0.4663),(-0.5943,-0.6553,-0.4663),(-0.6358,-0.5893,-0.4986),(-0.6844,-0.5320,-0.4986),(-0.6984,-0.5429,-0.4663),(-0.6488,-0.6014,-0.4663),(-0.6844,-0.5320,-0.4986),(-0.7279,-0.4708,-0.4986),(-0.7428,-0.4805,-0.4663),(-0.6984,-0.5429,-0.4663),(-0.7279,-0.4708,-0.4986),(-0.7659,-0.4060,-0.4986),(-0.7816,-0.4144,-0.4663),(-0.7428,-0.4805,-0.4663),(-0.7659,-0.4060,-0.4986),(-0.7981,-0.3382,-0.4986),(-0.8145,-0.3452,-0.4663),(-0.7816,-0.4144,-0.4663),(-0.7981,-0.3382,-0.4986),(-0.8244,-0.2679,-0.4986),(-0.8413,-0.2734,-0.4663),(-0.8145,-0.3452,-0.4663),(0.8413,-0.2734,-0.4663),(0.8145,-0.3452,-0.4663),(0.8315,-0.3524,-0.4295),(0.8589,-0.2791,-0.4295),(0.8145,-0.3452,-0.4663),(0.7816,-0.4144,-0.4663),(0.7979,-0.4230,-0.4295),(0.8315,-0.3524,-0.4295),(0.7816,-0.4144,-0.4663),(0.7428,-0.4805,-0.4663),(0.7583,-0.4905,-0.4295),(0.7979,-0.4230,-0.4295),(0.7428,-0.4805,-0.4663),(0.6984,-0.5429,-0.4663),(0.7130,-0.5543,-0.4295),(0.7583,-0.4905,-0.4295),(0.6984,-0.5429,-0.4663),(0.6488,-0.6014,-0.4663),(0.6623,-0.6139,-0.4295),(0.7130,-0.5543,-0.4295),(0.6488,-0.6014,-0.4663),(0.5943,-0.6553,-0.4663),(0.6067,-0.6689,-0.4295),(0.6623,-0.6139,-0.4295),(0.5943,-0.6553,-0.4663),(0.5353,-0.7042,-0.4663),(0.5465,-0.7189,-0.4295),(0.6067,-0.6689,-0.4295),(0.5353,-0.7042,-0.4663),(0.4724,-0.7479,-0.4663),(0.4822,-0.7635,-0.4295),(0.5465,-0.7189,-0.4295),(0.4724,-0.7479,-0.4663),(0.4059,-0.7860,-0.4663),(0.4143,-0.8024,-0.4295),(0.4822,-0.7635,-0.4295),(0.4059,-0.7860,-0.4663),(0.3363,-0.8182,-0.4663),(0.3433,-0.8353,-0.4295),(0.4143,-0.8024,-0.4295),(0.3363,-0.8182,-0.4663),(0.2642,-0.8442,-0.4663),(0.2697,-0.8619,-0.4295),(0.3433,-0.8353,-0.4295),(0.2642,-0.8442,-0.4663),(0.1902,-0.8639,-0.4663),(0.1941,-0.8820,-0.4295),(0.2697,-0.8619,-0.4295),(0.1902,-0.8639,-0.4663),(0.1147,-0.8771,-0.4663),(0.1171,-0.8955,-0.4295),(0.1941,-0.8820,-0.4295),(0.1147,-0.8771,-0.4663),(0.0383,-0.8838,-0.4663),(0.0391,-0.9022,-0.4295),(0.1171,-0.8955,-0.4295),(0.0383,-0.8838,-0.4663),(-0.0383,-0.8838,-0.4663),(-0.0391,-0.9022,-0.4295),(0.0391,-0.9022,-0.4295),(-0.0383,-0.8838,-0.4663),(-0.1147,-0.8771,-0.4663),(-0.1171,-0.8955,-0.4295),(-0.0391,-0.9022,-0.4295),(-0.1147,-0.8771,-0.4663),(-0.1902,-0.8639,-0.4663),(-0.1941,-0.8820,-0.4295),(-0.1171,-0.8955,-0.4295),(-0.1902,-0.8639,-0.4663),(-0.2642,-0.8442,-0.4663),(-0.2697,-0.8619,-0.4295),(-0.1941,-0.8820,-0.4295),(-0.2642,-0.8442,-0.4663),(-0.3363,-0.8182,-0.4663),(-0.3433,-0.8353,-0.4295),(-0.2697,-0.8619,-0.4295),(-0.3363,-0.8182,-0.4663),(-0.4059,-0.7860,-0.4663),(-0.4143,-0.8024,-0.4295),(-0.3433,-0.8353,-0.4295),(-0.4059,-0.7860,-0.4663),(-0.4724,-0.7479,-0.4663),(-0.4822,-0.7635,-0.4295),(-0.4143,-0.8024,-0.4295),(-0.4724,-0.7479,-0.4663),(-0.5353,-0.7042,-0.4663),(-0.5465,-0.7189,-0.4295),(-0.4822,-0.7635,-0.4295),(-0.5353,-0.7042,-0.4663),(-0.5943,-0.6553,-0.4663),(-0.6067,-0.6689,-0.4295),(-0.5465,-0.7189,-0.4295),(-0.5943,-0.6553,-0.4663),(-0.6488,-0.6014,-0.4663),(-0.6623,-0.6139,-0.4295),(-0.6067,-0.6689,-0.4295),(-0.6488,-0.6014,-0.4663),(-0.6984,-0.5429,-0.4663),(-0.7130,-0.5543,-0.4295),(-0.6623,-0.6139,-0.4295),(-0.6984,-0.5429,-0.4663),(-0.7428,-0.4805,-0.4663),(-0.7583,-0.4905,-0.4295),(-0.7130,-0.5543,-0.4295),(-0.7428,-0.4805,-0.4663),(-0.7816,-0.4144,-0.4663),(-0.7979,-0.4230,-0.4295),(-0.7583,-0.4905,-0.4295),(-0.7816,-0.4144,-0.4663),(-0.8145,-0.3452,-0.4663),(-0.8315,-0.3524,-0.4295),(-0.7979,-0.4230,-0.4295),(-0.8145,-0.3452,-0.4663),(-0.8413,-0.2734,-0.4663),(-0.8589,-0.2791,-0.4295),(-0.8315,-0.3524,-0.4295),(0.8589,-0.2791,-0.4295),(0.8315,-0.3524,-0.4295),(0.8488,-0.3597,-0.3876),(0.8767,-0.2849,-0.3876),(0.8315,-0.3524,-0.4295),(0.7979,-0.4230,-0.4295),(0.8144,-0.4318,-0.3876),(0.8488,-0.3597,-0.3876),(0.7979,-0.4230,-0.4295),(0.7583,-0.4905,-0.4295),(0.7740,-0.5007,-0.3876),(0.8144,-0.4318,-0.3876),(0.7583,-0.4905,-0.4295),(0.7130,-0.5543,-0.4295),(0.7278,-0.5658,-0.3876),(0.7740,-0.5007,-0.3876),(0.7130,-0.5543,-0.4295),(0.6623,-0.6139,-0.4295),(0.6761,-0.6267,-0.3876),(0.7278,-0.5658,-0.3876),(0.6623,-0.6139,-0.4295),(0.6067,-0.6689,-0.4295),(0.6193,-0.6828,-0.3876),(0.6761,-0.6267,-0.3876),(0.6067,-0.6689,-0.4295),(0.5465,-0.7189,-0.4295),(0.5579,-0.7339,-0.3876),(0.6193,-0.6828,-0.3876),(0.5465,-0.7189,-0.4295),(0.4822,-0.7635,-0.4295),(0.4923,-0.7794,-0.3876),(0.5579,-0.7339,-0.3876),(0.4822,-0.7635,-0.4295),(0.4143,-0.8024,-0.4295),(0.4229,-0.8191,-0.3876),(0.4923,-0.7794,-0.3876),(0.4143,-0.8024,-0.4295),(0.3433,-0.8353,-0.4295),(0.3505,-0.8526,-0.3876),(0.4229,-0.8191,-0.3876),(0.3433,-0.8353,-0.4295),(0.2697,-0.8619,-0.4295),(0.2753,-0.8797,-0.3876),(0.3505,-0.8526,-0.3876),(0.2697,-0.8619,-0.4295),(0.1941,-0.8820,-0.4295),(0.1982,-0.9003,-0.3876),(0.2753,-0.8797,-0.3876),(0.1941,-0.8820,-0.4295),(0.1171,-0.8955,-0.4295),(0.1195,-0.9140,-0.3876),(0.1982,-0.9003,-0.3876),(0.1171,-0.8955,-0.4295),(0.0391,-0.9022,-0.4295),(0.0399,-0.9210,-0.3876),(0.1195,-0.9140,-0.3876),(0.0391,-0.9022,-0.4295),(-0.0391,-0.9022,-0.4295),(-0.0399,-0.9210,-0.3876),(0.0399,-0.9210,-0.3876),(-0.0391,-0.9022,-0.4295),(-0.1171,-0.8955,-0.4295),(-0.1195,-0.9140,-0.3876),(-0.0399,-0.9210,-0.3876),(-0.1171,-0.8955,-0.4295),(-0.1941,-0.8820,-0.4295),(-0.1982,-0.9003,-0.3876),(-0.1195,-0.9140,-0.3876),(-0.1941,-0.8820,-0.4295),(-0.2697,-0.8619,-0.4295),(-0.2753,-0.8797,-0.3876),(-0.1982,-0.9003,-0.3876),(-0.2697,-0.8619,-0.4295),(-0.3433,-0.8353,-0.4295),(-0.3505,-0.8526,-0.3876),(-0.2753,-0.8797,-0.3876),(-0.3433,-0.8353,-0.4295),(-0.4143,-0.8024,-0.4295),(-0.4229,-0.8191,-0.3876),(-0.3505,-0.8526,-0.3876),(-0.4143,-0.8024,-0.4295),(-0.4822,-0.7635,-0.4295),(-0.4923,-0.7794,-0.3876),(-0.4229,-0.8191,-0.3876),(-0.4822,-0.7635,-0.4295),(-0.5465,-0.7189,-0.4295),(-0.5579,-0.7339,-0.3876),(-0.4923,-0.7794,-0.3876),(-0.5465,-0.7189,-0.4295),(-0.6067,-0.6689,-0.4295),(-0.6193,-0.6828,-0.3876),(-0.5579,-0.7339,-0.3876),(-0.6067,-0.6689,-0.4295),(-0.6623,-0.6139,-0.4295),(-0.6761,-0.6267,-0.3876),(-0.6193,-0.6828,-0.3876),(-0.6623,-0.6139,-0.4295),(-0.7130,-0.5543,-0.4295),(-0.7278,-0.5658,-0.3876),(-0.6761,-0.6267,-0.3876),(-0.7130,-0.5543,-0.4295),(-0.7583,-0.4905,-0.4295),(-0.7740,-0.5007,-0.3876),(-0.7278,-0.5658,-0.3876),(-0.7583,-0.4905,-0.4295),(-0.7979,-0.4230,-0.4295),(-0.8144,-0.4318,-0.3876),(-0.7740,-0.5007,-0.3876),(-0.7979,-0.4230,-0.4295),(-0.8315,-0.3524,-0.4295),(-0.8488,-0.3597,-0.3876),(-0.8144,-0.4318,-0.3876),(-0.8315,-0.3524,-0.4295),(-0.8589,-0.2791,-0.4295),(-0.8767,-0.2849,-0.3876),(-0.8488,-0.3597,-0.3876),(0.8767,-0.2849,-0.3876),(0.8488,-0.3597,-0.3876),(0.8657,-0.3669,-0.3405),(0.8942,-0.2906,-0.3405),(0.8488,-0.3597,-0.3876),(0.8144,-0.4318,-0.3876),(0.8307,-0.4404,-0.3405),(0.8657,-0.3669,-0.3405),(0.8144,-0.4318,-0.3876),(0.7740,-0.5007,-0.3876),(0.7895,-0.5107,-0.3405),(0.8307,-0.4404,-0.3405),(0.7740,-0.5007,-0.3876),(0.7278,-0.5658,-0.3876),(0.7423,-0.5771,-0.3405),(0.7895,-0.5107,-0.3405),(0.7278,-0.5658,-0.3876),(0.6761,-0.6267,-0.3876),(0.6896,-0.6392,-0.3405),(0.7423,-0.5771,-0.3405),(0.6761,-0.6267,-0.3876),(0.6193,-0.6828,-0.3876),(0.6317,-0.6965,-0.3405),(0.6896,-0.6392,-0.3405),(0.6193,-0.6828,-0.3876),(0.5579,-0.7339,-0.3876),(0.5690,-0.7485,-0.3405),(0.6317,-0.6965,-0.3405),(0.5579,-0.7339,-0.3876),(0.4923,-0.7794,-0.3876),(0.5021,-0.7950,-0.3405),(0.5690,-0.7485,-0.3405),(0.4923,-0.7794,-0.3876),(0.4229,-0.8191,-0.3876),(0.4314,-0.8354,-0.3405),(0.5021,-0.7950,-0.3405),(0.4229,-0.8191,-0.3876),(0.3505,-0.8526,-0.3876),(0.3575,-0.8697,-0.3405),(0.4314,-0.8354,-0.3405),(0.3505,-0.8526,-0.3876),(0.2753,-0.8797,-0.3876),(0.2809,-0.8973,-0.3405),(0.3575,-0.8697,-0.3405),(0.2753,-0.8797,-0.3876),(0.1982,-0.9003,-0.3876),(0.2021,-0.9183,-0.3405),(0.2809,-0.8973,-0.3405),(0.1982,-0.9003,-0.3876),(0.1195,-0.9140,-0.3876),(0.1219,-0.9323,-0.3405),(0.2021,-0.9183,-0.3405),(0.1195,-0.9140,-0.3876),(0.0399,-0.9210,-0.3876),(0.0407,-0.9394,-0.3405),(0.1219,-0.9323,-0.3405),(0.0399,-0.9210,-0.3876),(-0.0399,-0.9210,-0.3876),(-0.0407,-0.9394,-0.3405),(0.0407,-0.9394,-0.3405),(-0.0399,-0.9210,-0.3876),(-0.1195,-0.9140,-0.3876),(-0.1219,-0.9323,-0.3405),(-0.0407,-0.9394,-0.3405),(-0.1195,-0.9140,-0.3876),(-0.1982,-0.9003,-0.3876),(-0.2021,-0.9183,-0.3405),(-0.1219,-0.9323,-0.3405),(-0.1982,-0.9003,-0.3876),(-0.2753,-0.8797,-0.3876),(-0.2809,-0.8973,-0.3405),(-0.2021,-0.9183,-0.3405),(-0.2753,-0.8797,-0.3876),(-0.3505,-0.8526,-0.3876),(-0.3575,-0.8697,-0.3405),(-0.2809,-0.8973,-0.3405),(-0.3505,-0.8526,-0.3876),(-0.4229,-0.8191,-0.3876),(-0.4314,-0.8354,-0.3405),(-0.3575,-0.8697,-0.3405),(-0.4229,-0.8191,-0.3876),(-0.4923,-0.7794,-0.3876),(-0.5021,-0.7950,-0.3405),(-0.4314,-0.8354,-0.3405),(-0.4923,-0.7794,-0.3876),(-0.5579,-0.7339,-0.3876),(-0.5690,-0.7485,-0.3405),(-0.5021,-0.7950,-0.3405),(-0.5579,-0.7339,-0.3876),(-0.6193,-0.6828,-0.3876),(-0.6317,-0.6965,-0.3405),(-0.5690,-0.7485,-0.3405),(-0.6193,-0.6828,-0.3876),(-0.6761,-0.6267,-0.3876),(-0.6896,-0.6392,-0.3405),(-0.6317,-0.6965,-0.3405),(-0.6761,-0.6267,-0.3876),(-0.7278,-0.5658,-0.3876),(-0.7423,-0.5771,-0.3405),(-0.6896,-0.6392,-0.3405),(-0.7278,-0.5658,-0.3876),(-0.7740,-0.5007,-0.3876),(-0.7895,-0.5107,-0.3405),(-0.7423,-0.5771,-0.3405),(-0.7740,-0.5007,-0.3876),(-0.8144,-0.4318,-0.3876),(-0.8307,-0.4404,-0.3405),(-0.7895,-0.5107,-0.3405),(-0.8144,-0.4318,-0.3876),(-0.8488,-0.3597,-0.3876),(-0.8657,-0.3669,-0.3405),(-0.8307,-0.4404,-0.3405),(-0.8488,-0.3597,-0.3876),(-0.8767,-0.2849,-0.3876),(-0.8942,-0.2906,-0.3405),(-0.8657,-0.3669,-0.3405),(0.8942,-0.2906,-0.3405),(0.8657,-0.3669,-0.3405),(0.8817,-0.3736,-0.2880),(0.9108,-0.2959,-0.2880),(0.8657,-0.3669,-0.3405),(0.8307,-0.4404,-0.3405),(0.8461,-0.4486,-0.2880),(0.8817,-0.3736,-0.2880),(0.8307,-0.4404,-0.3405),(0.7895,-0.5107,-0.3405),(0.8041,-0.5201,-0.2880),(0.8461,-0.4486,-0.2880),(0.7895,-0.5107,-0.3405),(0.7423,-0.5771,-0.3405),(0.7560,-0.5878,-0.2880),(0.8041,-0.5201,-0.2880),(0.7423,-0.5771,-0.3405),(0.6896,-0.6392,-0.3405),(0.7023,-0.6510,-0.2880),(0.7560,-0.5878,-0.2880),(0.6896,-0.6392,-0.3405),(0.6317,-0.6965,-0.3405),(0.6433,-0.7093,-0.2880),(0.7023,-0.6510,-0.2880),(0.6317,-0.6965,-0.3405),(0.5690,-0.7485,-0.3405),(0.5795,-0.7624,-0.2880),(0.6433,-0.7093,-0.2880),(0.5690,-0.7485,-0.3405),(0.5021,-0.7950,-0.3405),(0.5114,-0.8097,-0.2880),(0.5795,-0.7624,-0.2880),(0.5021,-0.7950,-0.3405),(0.4314,-0.8354,-0.3405),(0.4394,-0.8509,-0.2880),(0.5114,-0.8097,-0.2880),(0.4314,-0.8354,-0.3405),(0.3575,-0.8697,-0.3405),(0.3641,-0.8857,-0.2880),(0.4394,-0.8509,-0.2880),(0.3575,-0.8697,-0.3405),(0.2809,-0.8973,-0.3405),(0.2860,-0.9139,-0.2880),(0.3641,-0.8857,-0.2880),(0.2809,-0.8973,-0.3405),(0.2021,-0.9183,-0.3405),(0.2059,-0.9352,-0.2880),(0.2860,-0.9139,-0.2880),(0.2021,-0.9183,-0.3405),(0.1219,-0.9323,-0.3405),(0.1241,-0.9495,-0.2880),(0.2059,-0.9352,-0.2880),(0.1219,-0.9323,-0.3405),(0.0407,-0.9394,-0.3405),(0.0415,-0.9567,-0.2880),(0.1241,-0.9495,-0.2880),(0.0407,-0.9394,-0.3405),(-0.0407,-0.9394,-0.3405),(-0.0415,-0.9567,-0.2880),(0.0415,-0.9567,-0.2880),(-0.0407,-0.9394,-0.3405),(-0.1219,-0.9323,-0.3405),(-0.1241,-0.9495,-0.2880),(-0.0415,-0.9567,-0.2880),(-0.1219,-0.9323,-0.3405),(-0.2021,-0.9183,-0.3405),(-0.2059,-0.9352,-0.2880),(-0.1241,-0.9495,-0.2880),(-0.2021,-0.9183,-0.3405),(-0.2809,-0.8973,-0.3405),(-0.2860,-0.9139,-0.2880),(-0.2059,-0.9352,-0.2880),(-0.2809,-0.8973,-0.3405),(-0.3575,-0.8697,-0.3405),(-0.3641,-0.8857,-0.2880),(-0.2860,-0.9139,-0.2880),(-0.3575,-0.8697,-0.3405),(-0.4314,-0.8354,-0.3405),(-0.4394,-0.8509,-0.2880),(-0.3641,-0.8857,-0.2880),(-0.4314,-0.8354,-0.3405),(-0.5021,-0.7950,-0.3405),(-0.5114,-0.8097,-0.2880),(-0.4394,-0.8509,-0.2880),(-0.5021,-0.7950,-0.3405),(-0.5690,-0.7485,-0.3405),(-0.5795,-0.7624,-0.2880),(-0.5114,-0.8097,-0.2880),(-0.5690,-0.7485,-0.3405),(-0.6317,-0.6965,-0.3405),(-0.6433,-0.7093,-0.2880),(-0.5795,-0.7624,-0.2880),(-0.6317,-0.6965,-0.3405),(-0.6896,-0.6392,-0.3405),(-0.7023,-0.6510,-0.2880),(-0.6433,-0.7093,-0.2880),(-0.6896,-0.6392,-0.3405),(-0.7423,-0.5771,-0.3405),(-0.7560,-0.5878,-0.2880),(-0.7023,-0.6510,-0.2880),(-0.7423,-0.5771,-0.3405),(-0.7895,-0.5107,-0.3405),(-0.8041,-0.5201,-0.2880),(-0.7560,-0.5878,-0.2880),(-0.7895,-0.5107,-0.3405),(-0.8307,-0.4404,-0.3405),(-0.8461,-0.4486,-0.2880),(-0.8041,-0.5201,-0.2880),(-0.8307,-0.4404,-0.3405),(-0.8657,-0.3669,-0.3405),(-0.8817,-0.3736,-0.2880),(-0.8461,-0.4486,-0.2880),(-0.8657,-0.3669,-0.3405),(-0.8942,-0.2906,-0.3405),(-0.9108,-0.2959,-0.2880),(-0.8817,-0.3736,-0.2880),(0.9108,-0.2959,-0.2880),(0.8817,-0.3736,-0.2880),(0.8960,-0.3797,-0.2304),(0.9255,-0.3007,-0.2304),(0.8817,-0.3736,-0.2880),(0.8461,-0.4486,-0.2880),(0.8597,-0.4558,-0.2304),(0.8960,-0.3797,-0.2304),(0.8461,-0.4486,-0.2880),(0.8041,-0.5201,-0.2880),(0.8171,-0.5285,-0.2304),(0.8597,-0.4558,-0.2304),(0.8041,-0.5201,-0.2880),(0.7560,-0.5878,-0.2880),(0.7682,-0.5972,-0.2304),(0.8171,-0.5285,-0.2304),(0.7560,-0.5878,-0.2880),(0.7023,-0.6510,-0.2880),(0.7137,-0.6615,-0.2304),(0.7682,-0.5972,-0.2304),(0.7023,-0.6510,-0.2880),(0.6433,-0.7093,-0.2880),(0.6537,-0.7208,-0.2304),(0.7137,-0.6615,-0.2304),(0.6433,-0.7093,-0.2880),(0.5795,-0.7624,-0.2880),(0.5889,-0.7747,-0.2304),(0.6537,-0.7208,-0.2304),(0.5795,-0.7624,-0.2880),(0.5114,-0.8097,-0.2880),(0.5196,-0.8227,-0.2304),(0.5889,-0.7747,-0.2304),(0.5114,-0.8097,-0.2880),(0.4394,-0.8509,-0.2880),(0.4465,-0.8646,-0.2304),(0.5196,-0.8227,-0.2304),(0.4394,-0.8509,-0.2880),(0.3641,-0.8857,-0.2880),(0.3699,-0.9000,-0.2304),(0.4465,-0.8646,-0.2304),(0.3641,-0.8857,-0.2880),(0.2860,-0.9139,-0.2880),(0.2907,-0.9287,-0.2304),(0.3699,-0.9000,-0.2304),(0.2860,-0.9139,-0.2880),(0.2059,-0.9352,-0.2880),(0.2092,-0.9503,-0.2304),(0.2907,-0.9287,-0.2304),(0.2059,-0.9352,-0.2880),(0.1241,-0.9495,-0.2880),(0.1261,-0.9649,-0.2304),(0.2092,-0.9503,-0.2304),(0.1241,-0.9495,-0.2880),(0.0415,-0.9567,-0.2880),(0.0422,-0.9722,-0.2304),(0.1261,-0.9649,-0.2304),(0.0415,-0.9567,-0.2880),(-0.0415,-0.9567,-0.2880),(-0.0422,-0.9722,-0.2304),(0.0422,-0.9722,-0.2304),(-0.0415,-0.9567,-0.2880),(-0.1241,-0.9495,-0.2880),(-0.1261,-0.9649,-0.2304),(-0.0422,-0.9722,-0.2304),(-0.1241,-0.9495,-0.2880),(-0.2059,-0.9352,-0.2880),(-0.2092,-0.9503,-0.2304),(-0.1261,-0.9649,-0.2304),(-0.2059,-0.9352,-0.2880),(-0.2860,-0.9139,-0.2880),(-0.2907,-0.9287,-0.2304),(-0.2092,-0.9503,-0.2304),(-0.2860,-0.9139,-0.2880),(-0.3641,-0.8857,-0.2880),(-0.3699,-0.9000,-0.2304),(-0.2907,-0.9287,-0.2304),(-0.3641,-0.8857,-0.2880),(-0.4394,-0.8509,-0.2880),(-0.4465,-0.8646,-0.2304),(-0.3699,-0.9000,-0.2304),(-0.4394,-0.8509,-0.2880),(-0.5114,-0.8097,-0.2880),(-0.5196,-0.8227,-0.2304),(-0.4465,-0.8646,-0.2304),(-0.5114,-0.8097,-0.2880),(-0.5795,-0.7624,-0.2880),(-0.5889,-0.7747,-0.2304),(-0.5196,-0.8227,-0.2304),(-0.5795,-0.7624,-0.2880),(-0.6433,-0.7093,-0.2880),(-0.6537,-0.7208,-0.2304),(-0.5889,-0.7747,-0.2304),(-0.6433,-0.7093,-0.2880),(-0.7023,-0.6510,-0.2880),(-0.7137,-0.6615,-0.2304),(-0.6537,-0.7208,-0.2304),(-0.7023,-0.6510,-0.2880),(-0.7560,-0.5878,-0.2880),(-0.7682,-0.5972,-0.2304),(-0.7137,-0.6615,-0.2304),(-0.7560,-0.5878,-0.2880),(-0.8041,-0.5201,-0.2880),(-0.8171,-0.5285,-0.2304),(-0.7682,-0.5972,-0.2304),(-0.8041,-0.5201,-0.2880),(-0.8461,-0.4486,-0.2880),(-0.8597,-0.4558,-0.2304),(-0.8171,-0.5285,-0.2304),(-0.8461,-0.4486,-0.2880),(-0.8817,-0.3736,-0.2880),(-0.8960,-0.3797,-0.2304),(-0.8597,-0.4558,-0.2304),(-0.8817,-0.3736,-0.2880),(-0.9108,-0.2959,-0.2880),(-0.9255,-0.3007,-0.2304),(-0.8960,-0.3797,-0.2304),(0.9255,-0.3007,-0.2304),(0.8960,-0.3797,-0.2304),(0.9076,-0.3846,-0.1683),(0.9375,-0.3046,-0.1683),(0.8960,-0.3797,-0.2304),(0.8597,-0.4558,-0.2304),(0.8709,-0.4617,-0.1683),(0.9076,-0.3846,-0.1683),(0.8597,-0.4558,-0.2304),(0.8171,-0.5285,-0.2304),(0.8277,-0.5354,-0.1683),(0.8709,-0.4617,-0.1683),(0.8171,-0.5285,-0.2304),(0.7682,-0.5972,-0.2304),(0.7782,-0.6050,-0.1683),(0.8277,-0.5354,-0.1683),(0.7682,-0.5972,-0.2304),(0.7137,-0.6615,-0.2304),(0.7229,-0.6701,-0.1683),(0.7782,-0.6050,-0.1683),(0.7137,-0.6615,-0.2304),(0.6537,-0.7208,-0.2304),(0.6622,-0.7302,-0.1683),(0.7229,-0.6701,-0.1683),(0.6537,-0.7208,-0.2304),(0.5889,-0.7747,-0.2304),(0.5965,-0.7847,-0.1683),(0.6622,-0.7302,-0.1683),(0.5889,-0.7747,-0.2304),(0.5196,-0.8227,-0.2304),(0.5264,-0.8334,-0.1683),(0.5965,-0.7847,-0.1683),(0.5196,-0.8227,-0.2304),(0.4465,-0.8646,-0.2304),(0.4523,-0.8759,-0.1683),(0.5264,-0.8334,-0.1683),(0.4465,-0.8646,-0.2304),(0.3699,-0.9000,-0.2304),(0.3748,-0.9117,-0.1683),(0.4523,-0.8759,-0.1683),(0.3699,-0.9000,-0.2304),(0.2907,-0.9287,-0.2304),(0.2944,-0.9407,-0.1683),(0.3748,-0.9117,-0.1683),(0.2907,-0.9287,-0.2304),(0.2092,-0.9503,-0.2304),(0.2119,-0.9627,-0.1683),(0.2944,-0.9407,-0.1683),(0.2092,-0.9503,-0.2304),(0.1261,-0.9649,-0.2304),(0.1278,-0.9774,-0.1683),(0.2119,-0.9627,-0.1683),(0.1261,-0.9649,-0.2304),(0.0422,-0.9722,-0.2304),(0.0427,-0.9848,-0.1683),(0.1278,-0.9774,-0.1683),(0.0422,-0.9722,-0.2304),(-0.0422,-0.9722,-0.2304),(-0.0427,-0.9848,-0.1683),(0.0427,-0.9848,-0.1683),(-0.0422,-0.9722,-0.2304),(-0.1261,-0.9649,-0.2304),(-0.1278,-0.9774,-0.1683),(-0.0427,-0.9848,-0.1683),(-0.1261,-0.9649,-0.2304),(-0.2092,-0.9503,-0.2304),(-0.2119,-0.9627,-0.1683),(-0.1278,-0.9774,-0.1683),(-0.2092,-0.9503,-0.2304),(-0.2907,-0.9287,-0.2304),(-0.2944,-0.9407,-0.1683),(-0.2119,-0.9627,-0.1683),(-0.2907,-0.9287,-0.2304),(-0.3699,-0.9000,-0.2304),(-0.3748,-0.9117,-0.1683),(-0.2944,-0.9407,-0.1683),(-0.3699,-0.9000,-0.2304),(-0.4465,-0.8646,-0.2304),(-0.4523,-0.8759,-0.1683),(-0.3748,-0.9117,-0.1683),(-0.4465,-0.8646,-0.2304),(-0.5196,-0.8227,-0.2304),(-0.5264,-0.8334,-0.1683),(-0.4523,-0.8759,-0.1683),(-0.5196,-0.8227,-0.2304),(-0.5889,-0.7747,-0.2304),(-0.5965,-0.7847,-0.1683),(-0.5264,-0.8334,-0.1683),(-0.5889,-0.7747,-0.2304),(-0.6537,-0.7208,-0.2304),(-0.6622,-0.7302,-0.1683),(-0.5965,-0.7847,-0.1683),(-0.6537,-0.7208,-0.2304),(-0.7137,-0.6615,-0.2304),(-0.7229,-0.6701,-0.1683),(-0.6622,-0.7302,-0.1683),(-0.7137,-0.6615,-0.2304),(-0.7682,-0.5972,-0.2304),(-0.7782,-0.6050,-0.1683),(-0.7229,-0.6701,-0.1683),(-0.7682,-0.5972,-0.2304),(-0.8171,-0.5285,-0.2304),(-0.8277,-0.5354,-0.1683),(-0.7782,-0.6050,-0.1683),(-0.8171,-0.5285,-0.2304),(-0.8597,-0.4558,-0.2304),(-0.8709,-0.4617,-0.1683),(-0.8277,-0.5354,-0.1683),(-0.8597,-0.4558,-0.2304),(-0.8960,-0.3797,-0.2304),(-0.9076,-0.3846,-0.1683),(-0.8709,-0.4617,-0.1683),(-0.8960,-0.3797,-0.2304),(-0.9255,-0.3007,-0.2304),(-0.9375,-0.3046,-0.1683),(-0.9076,-0.3846,-0.1683),(0.9375,-0.3046,-0.1683),(0.9076,-0.3846,-0.1683),(0.9159,-0.3881,-0.1025),(0.9460,-0.3074,-0.1025),(0.9076,-0.3846,-0.1683),(0.8709,-0.4617,-0.1683),(0.8789,-0.4659,-0.1025),(0.9159,-0.3881,-0.1025),(0.8709,-0.4617,-0.1683),(0.8277,-0.5354,-0.1683),(0.8352,-0.5403,-0.1025),(0.8789,-0.4659,-0.1025),(0.8277,-0.5354,-0.1683),(0.7782,-0.6050,-0.1683),(0.7853,-0.6105,-0.1025),(0.8352,-0.5403,-0.1025),(0.7782,-0.6050,-0.1683),(0.7229,-0.6701,-0.1683),(0.7295,-0.6762,-0.1025),(0.7853,-0.6105,-0.1025),(0.7229,-0.6701,-0.1683),(0.6622,-0.7302,-0.1683),(0.6683,-0.7368,-0.1025),(0.7295,-0.6762,-0.1025),(0.6622,-0.7302,-0.1683),(0.5965,-0.7847,-0.1683),(0.6020,-0.7919,-0.1025),(0.6683,-0.7368,-0.1025),(0.5965,-0.7847,-0.1683),(0.5264,-0.8334,-0.1683),(0.5312,-0.8410,-0.1025),(0.6020,-0.7919,-0.1025),(0.5264,-0.8334,-0.1683),(0.4523,-0.8759,-0.1683),(0.4564,-0.8839,-0.1025),(0.5312,-0.8410,-0.1025),(0.4523,-0.8759,-0.1683),(0.3748,-0.9117,-0.1683),(0.3782,-0.9200,-0.1025),(0.4564,-0.8839,-0.1025),(0.3748,-0.9117,-0.1683),(0.2944,-0.9407,-0.1683),(0.2971,-0.9493,-0.1025),(0.3782,-0.9200,-0.1025),(0.2944,-0.9407,-0.1683),(0.2119,-0.9627,-0.1683),(0.2138,-0.9715,-0.1025),(0.2971,-0.9493,-0.1025),(0.2119,-0.9627,-0.1683),(0.1278,-0.9774,-0.1683),(0.1289,-0.9863,-0.1025),(0.2138,-0.9715,-0.1025),(0.1278,-0.9774,-0.1683),(0.0427,-0.9848,-0.1683),(0.0431,-0.9938,-0.1025),(0.1289,-0.9863,-0.1025),(0.0427,-0.9848,-0.1683),(-0.0427,-0.9848,-0.1683),(-0.0431,-0.9938,-0.1025),(0.0431,-0.9938,-0.1025),(-0.0427,-0.9848,-0.1683),(-0.1278,-0.9774,-0.1683),(-0.1289,-0.9863,-0.1025),(-0.0431,-0.9938,-0.1025),(-0.1278,-0.9774,-0.1683),(-0.2119,-0.9627,-0.1683),(-0.2138,-0.9715,-0.1025),(-0.1289,-0.9863,-0.1025),(-0.2119,-0.9627,-0.1683),(-0.2944,-0.9407,-0.1683),(-0.2971,-0.9493,-0.1025),(-0.2138,-0.9715,-0.1025),(-0.2944,-0.9407,-0.1683),(-0.3748,-0.9117,-0.1683),(-0.3782,-0.9200,-0.1025),(-0.2971,-0.9493,-0.1025),(-0.3748,-0.9117,-0.1683),(-0.4523,-0.8759,-0.1683),(-0.4564,-0.8839,-0.1025),(-0.3782,-0.9200,-0.1025),(-0.4523,-0.8759,-0.1683),(-0.5264,-0.8334,-0.1683),(-0.5312,-0.8410,-0.1025),(-0.4564,-0.8839,-0.1025),(-0.5264,-0.8334,-0.1683),(-0.5965,-0.7847,-0.1683),(-0.6020,-0.7919,-0.1025),(-0.5312,-0.8410,-0.1025),(-0.5965,-0.7847,-0.1683),(-0.6622,-0.7302,-0.1683),(-0.6683,-0.7368,-0.1025),(-0.6020,-0.7919,-0.1025),(-0.6622,-0.7302,-0.1683),(-0.7229,-0.6701,-0.1683),(-0.7295,-0.6762,-0.1025),(-0.6683,-0.7368,-0.1025),(-0.7229,-0.6701,-0.1683),(-0.7782,-0.6050,-0.1683),(-0.7853,-0.6105,-0.1025),(-0.7295,-0.6762,-0.1025),(-0.7782,-0.6050,-0.1683),(-0.8277,-0.5354,-0.1683),(-0.8352,-0.5403,-0.1025),(-0.7853,-0.6105,-0.1025),(-0.8277,-0.5354,-0.1683),(-0.8709,-0.4617,-0.1683),(-0.8789,-0.4659,-0.1025),(-0.8352,-0.5403,-0.1025),(-0.8709,-0.4617,-0.1683),(-0.9076,-0.3846,-0.1683),(-0.9159,-0.3881,-0.1025),(-0.8789,-0.4659,-0.1025),(-0.9076,-0.3846,-0.1683),(-0.9375,-0.3046,-0.1683),(-0.9460,-0.3074,-0.1025),(-0.9159,-0.3881,-0.1025),(0.9460,-0.3074,-0.1025),(0.9159,-0.3881,-0.1025),(0.9202,-0.3899,-0.0344),(0.9505,-0.3088,-0.0344),(0.9159,-0.3881,-0.1025),(0.8789,-0.4659,-0.1025),(0.8830,-0.4681,-0.0344),(0.9202,-0.3899,-0.0344),(0.8789,-0.4659,-0.1025),(0.8352,-0.5403,-0.1025),(0.8392,-0.5428,-0.0344),(0.8830,-0.4681,-0.0344),(0.8352,-0.5403,-0.1025),(0.7853,-0.6105,-0.1025),(0.7890,-0.6134,-0.0344),(0.8392,-0.5428,-0.0344),(0.7853,-0.6105,-0.1025),(0.7295,-0.6762,-0.1025),(0.7330,-0.6794,-0.0344),(0.7890,-0.6134,-0.0344),(0.7295,-0.6762,-0.1025),(0.6683,-0.7368,-0.1025),(0.6714,-0.7403,-0.0344),(0.7330,-0.6794,-0.0344),(0.6683,-0.7368,-0.1025),(0.6020,-0.7919,-0.1025),(0.6048,-0.7956,-0.0344),(0.6714,-0.7403,-0.0344),(0.6020,-0.7919,-0.1025),(0.5312,-0.8410,-0.1025),(0.5337,-0.8450,-0.0344),(0.6048,-0.7956,-0.0344),(0.5312,-0.8410,-0.1025),(0.4564,-0.8839,-0.1025),(0.4585,-0.8880,-0.0344),(0.5337,-0.8450,-0.0344),(0.4564,-0.8839,-0.1025),(0.3782,-0.9200,-0.1025),(0.3800,-0.9244,-0.0344),(0.4585,-0.8880,-0.0344),(0.3782,-0.9200,-0.1025),(0.2971,-0.9493,-0.1025),(0.2985,-0.9538,-0.0344),(0.3800,-0.9244,-0.0344),(0.2971,-0.9493,-0.1025),(0.2138,-0.9715,-0.1025),(0.2148,-0.9760,-0.0344),(0.2985,-0.9538,-0.0344),(0.2138,-0.9715,-0.1025),(0.1289,-0.9863,-0.1025),(0.1296,-0.9910,-0.0344),(0.2148,-0.9760,-0.0344),(0.1289,-0.9863,-0.1025),(0.0431,-0.9938,-0.1025),(0.0433,-0.9985,-0.0344),(0.1296,-0.9910,-0.0344),(0.0431,-0.9938,-0.1025),(-0.0431,-0.9938,-0.1025),(-0.0433,-0.9985,-0.0344),(0.0433,-0.9985,-0.0344),(-0.0431,-0.9938,-0.1025),(-0.1289,-0.9863,-0.1025),(-0.1296,-0.9910,-0.0344),(-0.0433,-0.9985,-0.0344),(-0.1289,-0.9863,-0.1025),(-0.2138,-0.9715,-0.1025),(-0.2148,-0.9760,-0.0344),(-0.1296,-0.9910,-0.0344),(-0.2138,-0.9715,-0.1025),(-0.2971,-0.9493,-0.1025),(-0.2985,-0.9538,-0.0344),(-0.2148,-0.9760,-0.0344),(-0.2971,-0.9493,-0.1025),(-0.3782,-0.9200,-0.1025),(-0.3800,-0.9244,-0.0344),(-0.2985,-0.9538,-0.0344),(-0.3782,-0.9200,-0.1025),(-0.4564,-0.8839,-0.1025),(-0.4585,-0.8880,-0.0344),(-0.3800,-0.9244,-0.0344),(-0.4564,-0.8839,-0.1025),(-0.5312,-0.8410,-0.1025),(-0.5337,-0.8450,-0.0344),(-0.4585,-0.8880,-0.0344),(-0.5312,-0.8410,-0.1025),(-0.6020,-0.7919,-0.1025),(-0.6048,-0.7956,-0.0344),(-0.5337,-0.8450,-0.0344),(-0.6020,-0.7919,-0.1025),(-0.6683,-0.7368,-0.1025),(-0.6714,-0.7403,-0.0344),(-0.6048,-0.7956,-0.0344),(-0.6683,-0.7368,-0.1025),(-0.7295,-0.6762,-0.1025),(-0.7330,-0.6794,-0.0344),(-0.6714,-0.7403,-0.0344),(-0.7295,-0.6762,-0.1025),(-0.7853,-0.6105,-0.1025),(-0.7890,-0.6134,-0.0344),(-0.7330,-0.6794,-0.0344),(-0.7853,-0.6105,-0.1025),(-0.8352,-0.5403,-0.1025),(-0.8392,-0.5428,-0.0344),(-0.7890,-0.6134,-0.0344),(-0.8352,-0.5403,-0.1025),(-0.8789,-0.4659,-0.1025),(-0.8830,-0.4681,-0.0344),(-0.8392,-0.5428,-0.0344),(-0.8789,-0.4659,-0.1025),(-0.9159,-0.3881,-0.1025),(-0.9202,-0.3899,-0.0344),(-0.8830,-0.4681,-0.0344),(-0.9159,-0.3881,-0.1025),(-0.9460,-0.3074,-0.1025),(-0.9505,-0.3088,-0.0344),(-0.9202,-0.3899,-0.0344),(0.9505,-0.3088,-0.0344),(0.9202,-0.3899,-0.0344),(0.9202,-0.3899,0.0344),(0.9505,-0.3088,0.0344),(0.9202,-0.3899,-0.0344),(0.8830,-0.4681,-0.0344),(0.8830,-0.4681,0.0344),(0.9202,-0.3899,0.0344),(0.8830,-0.4681,-0.0344),(0.8392,-0.5428,-0.0344),(0.8392,-0.5428,0.0344),(0.8830,-0.4681,0.0344),(0.8392,-0.5428,-0.0344),(0.7890,-0.6134,-0.0344),(0.7890,-0.6134,0.0344),(0.8392,-0.5428,0.0344),(0.7890,-0.6134,-0.0344),(0.7330,-0.6794,-0.0344),(0.7330,-0.6794,0.0344),(0.7890,-0.6134,0.0344),(0.7330,-0.6794,-0.0344),(0.6714,-0.7403,-0.0344),(0.6714,-0.7403,0.0344),(0.7330,-0.6794,0.0344),(0.6714,-0.7403,-0.0344),(0.6048,-0.7956,-0.0344),(0.6048,-0.7956,0.0344),(0.6714,-0.7403,0.0344),(0.6048,-0.7956,-0.0344),(0.5337,-0.8450,-0.0344),(0.5337,-0.8450,0.0344),(0.6048,-0.7956,0.0344),(0.5337,-0.8450,-0.0344),(0.4585,-0.8880,-0.0344),(0.4585,-0.8880,0.0344),(0.5337,-0.8450,0.0344),(0.4585,-0.8880,-0.0344),(0.3800,-0.9244,-0.0344),(0.3800,-0.9244,0.0344),(0.4585,-0.8880,0.0344),(0.3800,-0.9244,-0.0344),(0.2985,-0.9538,-0.0344),(0.2985,-0.9538,0.0344),(0.3800,-0.9244,0.0344),(0.2985,-0.9538,-0.0344),(0.2148,-0.9760,-0.0344),(0.2148,-0.9760,0.0344),(0.2985,-0.9538,0.0344),(0.2148,-0.9760,-0.0344),(0.1296,-0.9910,-0.0344),(0.1296,-0.9910,0.0344),(0.2148,-0.9760,0.0344),(0.1296,-0.9910,-0.0344),(0.0433,-0.9985,-0.0344),(0.0433,-0.9985,0.0344),(0.1296,-0.9910,0.0344),(0.0433,-0.9985,-0.0344),(-0.0433,-0.9985,-0.0344),(-0.0433,-0.9985,0.0344),(0.0433,-0.9985,0.0344),(-0.0433,-0.9985,-0.0344),(-0.1296,-0.9910,-0.0344),(-0.1296,-0.9910,0.0344),(-0.0433,-0.9985,0.0344),(-0.1296,-0.9910,-0.0344),(-0.2148,-0.9760,-0.0344),(-0.2148,-0.9760,0.0344),(-0.1296,-0.9910,0.0344),(-0.2148,-0.9760,-0.0344),(-0.2985,-0.9538,-0.0344),(-0.2985,-0.9538,0.0344),(-0.2148,-0.9760,0.0344),(-0.2985,-0.9538,-0.0344),(-0.3800,-0.9244,-0.0344),(-0.3800,-0.9244,0.0344),(-0.2985,-0.9538,0.0344),(-0.3800,-0.9244,-0.0344),(-0.4585,-0.8880,-0.0344),(-0.4585,-0.8880,0.0344),(-0.3800,-0.9244,0.0344),(-0.4585,-0.8880,-0.0344),(-0.5337,-0.8450,-0.0344),(-0.5337,-0.8450,0.0344),(-0.4585,-0.8880,0.0344),(-0.5337,-0.8450,-0.0344),(-0.6048,-0.7956,-0.0344),(-0.6048,-0.7956,0.0344),(-0.5337,-0.8450,0.0344),(-0.6048,-0.7956,-0.0344),(-0.6714,-0.7403,-0.0344),(-0.6714,-0.7403,0.0344),(-0.6048,-0.7956,0.0344),(-0.6714,-0.7403,-0.0344),(-0.7330,-0.6794,-0.0344),(-0.7330,-0.6794,0.0344),(-0.6714,-0.7403,0.0344),(-0.7330,-0.6794,-0.0344),(-0.7890,-0.6134,-0.0344),(-0.7890,-0.6134,0.0344),(-0.7330,-0.6794,0.0344),(-0.7890,-0.6134,-0.0344),(-0.8392,-0.5428,-0.0344),(-0.8392,-0.5428,0.0344),(-0.7890,-0.6134,0.0344),(-0.8392,-0.5428,-0.0344),(-0.8830,-0.4681,-0.0344),(-0.8830,-0.4681,0.0344),(-0.8392,-0.5428,0.0344),(-0.8830,-0.4681,-0.0344),(-0.9202,-0.3899,-0.0344),(-0.9202,-0.3899,0.0344),(-0.8830,-0.4681,0.0344),(-0.9202,-0.3899,-0.0344),(-0.9505,-0.3088,-0.0344),(-0.9505,-0.3088,0.0344),(-0.9202,-0.3899,0.0344),(0.9505,-0.3088,0.0344),(0.9202,-0.3899,0.0344),(0.9159,-0.3881,0.1025),(0.9460,-0.3074,0.1025),(0.9202,-0.3899,0.0344),(0.8830,-0.4681,0.0344),(0.8789,-0.4659,0.1025),(0.9159,-0.3881,0.1025),(0.8830,-0.4681,0.0344),(0.8392,-0.5428,0.0344),(0.8352,-0.5403,0.1025),(0.8789,-0.4659,0.1025),(0.8392,-0.5428,0.0344),(0.7890,-0.6134,0.0344),(0.7853,-0.6105,0.1025),(0.8352,-0.5403,0.1025),(0.7890,-0.6134,0.0344),(0.7330,-0.6794,0.0344),(0.7295,-0.6762,0.1025),(0.7853,-0.6105,0.1025),(0.7330,-0.6794,0.0344),(0.6714,-0.7403,0.0344),(0.6683,-0.7368,0.1025),(0.7295,-0.6762,0.1025),(0.6714,-0.7403,0.0344),(0.6048,-0.7956,0.0344),(0.6020,-0.7919,0.1025),(0.6683,-0.7368,0.1025),(0.6048,-0.7956,0.0344),(0.5337,-0.8450,0.0344),(0.5312,-0.8410,0.1025),(0.6020,-0.7919,0.1025),(0.5337,-0.8450,0.0344),(0.4585,-0.8880,0.0344),(0.4564,-0.8839,0.1025),(0.5312,-0.8410,0.1025),(0.4585,-0.8880,0.0344),(0.3800,-0.9244,0.0344),(0.3782,-0.9200,0.1025),(0.4564,-0.8839,0.1025),(0.3800,-0.9244,0.0344),(0.2985,-0.9538,0.0344),(0.2971,-0.9493,0.1025),(0.3782,-0.9200,0.1025),(0.2985,-0.9538,0.0344),(0.2148,-0.9760,0.0344),(0.2138,-0.9715,0.1025),(0.2971,-0.9493,0.1025),(0.2148,-0.9760,0.0344),(0.1296,-0.9910,0.0344),(0.1289,-0.9863,0.1025),(0.2138,-0.9715,0.1025),(0.1296,-0.9910,0.0344),(0.0433,-0.9985,0.0344),(0.0431,-0.9938,0.1025),(0.1289,-0.9863,0.1025),(0.0433,-0.9985,0.0344),(-0.0433,-0.9985,0.0344),(-0.0431,-0.9938,0.1025),(0.0431,-0.9938,0.1025),(-0.0433,-0.9985,0.0344),(-0.1296,-0.9910,0.0344),(-0.1289,-0.9863,0.1025),(-0.0431,-0.9938,0.1025),(-0.1296,-0.9910,0.0344),(-0.2148,-0.9760,0.0344),(-0.2138,-0.9715,0.1025),(-0.1289,-0.9863,0.1025),(-0.2148,-0.9760,0.0344),(-0.2985,-0.9538,0.0344),(-0.2971,-0.9493,0.1025),(-0.2138,-0.9715,0.1025),(-0.2985,-0.9538,0.0344),(-0.3800,-0.9244,0.0344),(-0.3782,-0.9200,0.1025),(-0.2971,-0.9493,0.1025),(-0.3800,-0.9244,0.0344),(-0.4585,-0.8880,0.0344),(-0.4564,-0.8839,0.1025),(-0.3782,-0.9200,0.1025),(-0.4585,-0.8880,0.0344),(-0.5337,-0.8450,0.0344),(-0.5312,-0.8410,0.1025),(-0.4564,-0.8839,0.1025),(-0.5337,-0.8450,0.0344),(-0.6048,-0.7956,0.0344),(-0.6020,-0.7919,0.1025),(-0.5312,-0.8410,0.1025),(-0.6048,-0.7956,0.0344),(-0.6714,-0.7403,0.0344),(-0.6683,-0.7368,0.1025),(-0.6020,-0.7919,0.1025),(-0.6714,-0.7403,0.0344),(-0.7330,-0.6794,0.0344),(-0.7295,-0.6762,0.1025),(-0.6683,-0.7368,0.1025),(-0.7330,-0.6794,0.0344),(-0.7890,-0.6134,0.0344),(-0.7853,-0.6105,0.1025),(-0.7295,-0.6762,0.1025),(-0.7890,-0.6134,0.0344),(-0.8392,-0.5428,0.0344),(-0.8352,-0.5403,0.1025),(-0.7853,-0.6105,0.1025),(-0.8392,-0.5428,0.0344),(-0.8830,-0.4681,0.0344),(-0.8789,-0.4659,0.1025),(-0.8352,-0.5403,0.1025),(-0.8830,-0.4681,0.0344),(-0.9202,-0.3899,0.0344),(-0.9159,-0.3881,0.1025),(-0.8789,-0.4659,0.1025),(-0.9202,-0.3899,0.0344),(-0.9505,-0.3088,0.0344),(-0.9460,-0.3074,0.1025),(-0.9159,-0.3881,0.1025),(0.9460,-0.3074,0.1025),(0.9159,-0.3881,0.1025),(0.9076,-0.3846,0.1683),(0.9375,-0.3046,0.1683),(0.9159,-0.3881,0.1025),(0.8789,-0.4659,0.1025),(0.8709,-0.4617,0.1683),(0.9076,-0.3846,0.1683),(0.8789,-0.4659,0.1025),(0.8352,-0.5403,0.1025),(0.8277,-0.5354,0.1683),(0.8709,-0.4617,0.1683),(0.8352,-0.5403,0.1025),(0.7853,-0.6105,0.1025),(0.7782,-0.6050,0.1683),(0.8277,-0.5354,0.1683),(0.7853,-0.6105,0.1025),(0.7295,-0.6762,0.1025),(0.7229,-0.6701,0.1683),(0.7782,-0.6050,0.1683),(0.7295,-0.6762,0.1025),(0.6683,-0.7368,0.1025),(0.6622,-0.7302,0.1683),(0.7229,-0.6701,0.1683),(0.6683,-0.7368,0.1025),(0.6020,-0.7919,0.1025),(0.5965,-0.7847,0.1683),(0.6622,-0.7302,0.1683),(0.6020,-0.7919,0.1025),(0.5312,-0.8410,0.1025),(0.5264,-0.8334,0.1683),(0.5965,-0.7847,0.1683),(0.5312,-0.8410,0.1025),(0.4564,-0.8839,0.1025),(0.4523,-0.8759,0.1683),(0.5264,-0.8334,0.1683),(0.4564,-0.8839,0.1025),(0.3782,-0.9200,0.1025),(0.3748,-0.9117,0.1683),(0.4523,-0.8759,0.1683),(0.3782,-0.9200,0.1025),(0.2971,-0.9493,0.1025),(0.2944,-0.9407,0.1683),(0.3748,-0.9117,0.1683),(0.2971,-0.9493,0.1025),(0.2138,-0.9715,0.1025),(0.2119,-0.9627,0.1683),(0.2944,-0.9407,0.1683),(0.2138,-0.9715,0.1025),(0.1289,-0.9863,0.1025),(0.1278,-0.9774,0.1683),(0.2119,-0.9627,0.1683),(0.1289,-0.9863,0.1025),(0.0431,-0.9938,0.1025),(0.0427,-0.9848,0.1683),(0.1278,-0.9774,0.1683),(0.0431,-0.9938,0.1025),(-0.0431,-0.9938,0.1025),(-0.0427,-0.9848,0.1683),(0.0427,-0.9848,0.1683),(-0.0431,-0.9938,0.1025),(-0.1289,-0.9863,0.1025),(-0.1278,-0.9774,0.1683),(-0.0427,-0.9848,0.1683),(-0.1289,-0.9863,0.1025),(-0.2138,-0.9715,0.1025),(-0.2119,-0.9627,0.1683),(-0.1278,-0.9774,0.1683),(-0.2138,-0.9715,0.1025),(-0.2971,-0.9493,0.1025),(-0.2944,-0.9407,0.1683),(-0.2119,-0.9627,0.1683),(-0.2971,-0.9493,0.1025),(-0.3782,-0.9200,0.1025),(-0.3748,-0.9117,0.1683),(-0.2944,-0.9407,0.1683),(-0.3782,-0.9200,0.1025),(-0.4564,-0.8839,0.1025),(-0.4523,-0.8759,0.1683),(-0.3748,-0.9117,0.1683),(-0.4564,-0.8839,0.1025),(-0.5312,-0.8410,0.1025),(-0.5264,-0.8334,0.1683),(-0.4523,-0.8759,0.1683),(-0.5312,-0.8410,0.1025),(-0.6020,-0.7919,0.1025),(-0.5965,-0.7847,0.1683),(-0.5264,-0.8334,0.1683),(-0.6020,-0.7919,0.1025),(-0.6683,-0.7368,0.1025),(-0.6622,-0.7302,0.1683),(-0.5965,-0.7847,0.1683),(-0.6683,-0.7368,0.1025),(-0.7295,-0.6762,0.1025),(-0.7229,-0.6701,0.1683),(-0.6622,-0.7302,0.1683),(-0.7295,-0.6762,0.1025),(-0.7853,-0.6105,0.1025),(-0.7782,-0.6050,0.1683),(-0.7229,-0.6701,0.1683),(-0.7853,-0.6105,0.1025),(-0.8352,-0.5403,0.1025),(-0.8277,-0.5354,0.1683),(-0.7782,-0.6050,0.1683),(-0.8352,-0.5403,0.1025),(-0.8789,-0.4659,0.1025),(-0.8709,-0.4617,0.1683),(-0.8277,-0.5354,0.1683),(-0.8789,-0.4659,0.1025),(-0.9159,-0.3881,0.1025),(-0.9076,-0.3846,0.1683),(-0.8709,-0.4617,0.1683),(-0.9159,-0.3881,0.1025),(-0.9460,-0.3074,0.1025),(-0.9375,-0.3046,0.1683),(-0.9076,-0.3846,0.1683),(0.9375,-0.3046,0.1683),(0.9076,-0.3846,0.1683),(0.8960,-0.3797,0.2304),(0.9255,-0.3007,0.2304),(0.9076,-0.3846,0.1683),(0.8709,-0.4617,0.1683),(0.8597,-0.4558,0.2304),(0.8960,-0.3797,0.2304),(0.8709,-0.4617,0.1683),(0.8277,-0.5354,0.1683),(0.8171,-0.5285,0.2304),(0.8597,-0.4558,0.2304),(0.8277,-0.5354,0.1683),(0.7782,-0.6050,0.1683),(0.7682,-0.5972,0.2304),(0.8171,-0.5285,0.2304),(0.7782,-0.6050,0.1683),(0.7229,-0.6701,0.1683),(0.7137,-0.6615,0.2304),(0.7682,-0.5972,0.2304),(0.7229,-0.6701,0.1683),(0.6622,-0.7302,0.1683),(0.6537,-0.7208,0.2304),(0.7137,-0.6615,0.2304),(0.6622,-0.7302,0.1683),(0.5965,-0.7847,0.1683),(0.5889,-0.7747,0.2304),(0.6537,-0.7208,0.2304),(0.5965,-0.7847,0.1683),(0.5264,-0.8334,0.1683),(0.5196,-0.8227,0.2304),(0.5889,-0.7747,0.2304),(0.5264,-0.8334,0.1683),(0.4523,-0.8759,0.1683),(0.4465,-0.8646,0.2304),(0.5196,-0.8227,0.2304),(0.4523,-0.8759,0.1683),(0.3748,-0.9117,0.1683),(0.3699,-0.9000,0.2304),(0.4465,-0.8646,0.2304),(0.3748,-0.9117,0.1683),(0.2944,-0.9407,0.1683),(0.2907,-0.9287,0.2304),(0.3699,-0.9000,0.2304),(0.2944,-0.9407,0.1683),(0.2119,-0.9627,0.1683),(0.2092,-0.9503,0.2304),(0.2907,-0.9287,0.2304),(0.2119,-0.9627,0.1683),(0.1278,-0.9774,0.1683),(0.1261,-0.9649,0.2304),(0.2092,-0.9503,0.2304),(0.1278,-0.9774,0.1683),(0.0427,-0.9848,0.1683),(0.0422,-0.9722,0.2304),(0.1261,-0.9649,0.2304),(0.0427,-0.9848,0.1683),(-0.0427,-0.9848,0.1683),(-0.0422,-0.9722,0.2304),(0.0422,-0.9722,0.2304),(-0.0427,-0.9848,0.1683),(-0.1278,-0.9774,0.1683),(-0.1261,-0.9649,0.2304),(-0.0422,-0.9722,0.2304),(-0.1278,-0.9774,0.1683),(-0.2119,-0.9627,0.1683),(-0.2092,-0.9503,0.2304),(-0.1261,-0.9649,0.2304),(-0.2119,-0.9627,0.1683),(-0.2944,-0.9407,0.1683),(-0.2907,-0.9287,0.2304),(-0.2092,-0.9503,0.2304),(-0.2944,-0.9407,0.1683),(-0.3748,-0.9117,0.1683),(-0.3699,-0.9000,0.2304),(-0.2907,-0.9287,0.2304),(-0.3748,-0.9117,0.1683),(-0.4523,-0.8759,0.1683),(-0.4465,-0.8646,0.2304),(-0.3699,-0.9000,0.2304),(-0.4523,-0.8759,0.1683),(-0.5264,-0.8334,0.1683),(-0.5196,-0.8227,0.2304),(-0.4465,-0.8646,0.2304),(-0.5264,-0.8334,0.1683),(-0.5965,-0.7847,0.1683),(-0.5889,-0.7747,0.2304),(-0.5196,-0.8227,0.2304),(-0.5965,-0.7847,0.1683),(-0.6622,-0.7302,0.1683),(-0.6537,-0.7208,0.2304),(-0.5889,-0.7747,0.2304),(-0.6622,-0.7302,0.1683),(-0.7229,-0.6701,0.1683),(-0.7137,-0.6615,0.2304),(-0.6537,-0.7208,0.2304),(-0.7229,-0.6701,0.1683),(-0.7782,-0.6050,0.1683),(-0.7682,-0.5972,0.2304),(-0.7137,-0.6615,0.2304),(-0.7782,-0.6050,0.1683),(-0.8277,-0.5354,0.1683),(-0.8171,-0.5285,0.2304),(-0.7682,-0.5972,0.2304),(-0.8277,-0.5354,0.1683),(-0.8709,-0.4617,0.1683),(-0.8597,-0.4558,0.2304),(-0.8171,-0.5285,0.2304),(-0.8709,-0.4617,0.1683),(-0.9076,-0.3846,0.1683),(-0.8960,-0.3797,0.2304),(-0.8597,-0.4558,0.2304),(-0.9076,-0.3846,0.1683),(-0.9375,-0.3046,0.1683),(-0.9255,-0.3007,0.2304),(-0.8960,-0.3797,0.2304),(0.9255,-0.3007,0.2304),(0.8960,-0.3797,0.2304),(0.8817,-0.3736,0.2880),(0.9108,-0.2959,0.2880),(0.8960,-0.3797,0.2304),(0.8597,-0.4558,0.2304),(0.8461,-0.4486,0.2880),(0.8817,-0.3736,0.2880),(0.8597,-0.4558,0.2304),(0.8171,-0.5285,0.2304),(0.8041,-0.5201,0.2880),(0.8461,-0.4486,0.2880),(0.8171,-0.5285,0.2304),(0.7682,-0.5972,0.2304),(0.7560,-0.5878,0.2880),(0.8041,-0.5201,0.2880),(0.7682,-0.5972,0.2304),(0.7137,-0.6615,0.2304),(0.7023,-0.6510,0.2880),(0.7560,-0.5878,0.2880),(0.7137,-0.6615,0.2304),(0.6537,-0.7208,0.2304),(0.6433,-0.7093,0.2880),(0.7023,-0.6510,0.2880),(0.6537,-0.7208,0.2304),(0.5889,-0.7747,0.2304),(0.5795,-0.7624,0.2880),(0.6433,-0.7093,0.2880),(0.5889,-0.7747,0.2304),(0.5196,-0.8227,0.2304),(0.5114,-0.8097,0.2880),(0.5795,-0.7624,0.2880),(0.5196,-0.8227,0.2304),(0.4465,-0.8646,0.2304),(0.4394,-0.8509,0.2880),(0.5114,-0.8097,0.2880),(0.4465,-0.8646,0.2304),(0.3699,-0.9000,0.2304),(0.3641,-0.8857,0.2880),(0.4394,-0.8509,0.2880),(0.3699,-0.9000,0.2304),(0.2907,-0.9287,0.2304),(0.2860,-0.9139,0.2880),(0.3641,-0.8857,0.2880),(0.2907,-0.9287,0.2304),(0.2092,-0.9503,0.2304),(0.2059,-0.9352,0.2880),(0.2860,-0.9139,0.2880),(0.2092,-0.9503,0.2304),(0.1261,-0.9649,0.2304),(0.1241,-0.9495,0.2880),(0.2059,-0.9352,0.2880),(0.1261,-0.9649,0.2304),(0.0422,-0.9722,0.2304),(0.0415,-0.9567,0.2880),(0.1241,-0.9495,0.2880),(0.0422,-0.9722,0.2304),(-0.0422,-0.9722,0.2304),(-0.0415,-0.9567,0.2880),(0.0415,-0.9567,0.2880),(-0.0422,-0.9722,0.2304),(-0.1261,-0.9649,0.2304),(-0.1241,-0.9495,0.2880),(-0.0415,-0.9567,0.2880),(-0.1261,-0.9649,0.2304),(-0.2092,-0.9503,0.2304),(-0.2059,-0.9352,0.2880),(-0.1241,-0.9495,0.2880),(-0.2092,-0.9503,0.2304),(-0.2907,-0.9287,0.2304),(-0.2860,-0.9139,0.2880),(-0.2059,-0.9352,0.2880),(-0.2907,-0.9287,0.2304),(-0.3699,-0.9000,0.2304),(-0.3641,-0.8857,0.2880),(-0.2860,-0.9139,0.2880),(-0.3699,-0.9000,0.2304),(-0.4465,-0.8646,0.2304),(-0.4394,-0.8509,0.2880),(-0.3641,-0.8857,0.2880),(-0.4465,-0.8646,0.2304),(-0.5196,-0.8227,0.2304),(-0.5114,-0.8097,0.2880),(-0.4394,-0.8509,0.2880),(-0.5196,-0.8227,0.2304),(-0.5889,-0.7747,0.2304),(-0.5795,-0.7624,0.2880),(-0.5114,-0.8097,0.2880),(-0.5889,-0.7747,0.2304),(-0.6537,-0.7208,0.2304),(-0.6433,-0.7093,0.2880),(-0.5795,-0.7624,0.2880),(-0.6537,-0.7208,0.2304),(-0.7137,-0.6615,0.2304),(-0.7023,-0.6510,0.2880),(-0.6433,-0.7093,0.2880),(-0.7137,-0.6615,0.2304),(-0.7682,-0.5972,0.2304),(-0.7560,-0.5878,0.2880),(-0.7023,-0.6510,0.2880),(-0.7682,-0.5972,0.2304),(-0.8171,-0.5285,0.2304),(-0.8041,-0.5201,0.2880),(-0.7560,-0.5878,0.2880),(-0.8171,-0.5285,0.2304),(-0.8597,-0.4558,0.2304),(-0.8461,-0.4486,0.2880),(-0.8041,-0.5201,0.2880),(-0.8597,-0.4558,0.2304),(-0.8960,-0.3797,0.2304),(-0.8817,-0.3736,0.2880),(-0.8461,-0.4486,0.2880),(-0.8960,-0.3797,0.2304),(-0.9255,-0.3007,0.2304),(-0.9108,-0.2959,0.2880),(-0.8817,-0.3736,0.2880),(0.9108,-0.2959,0.2880),(0.8817,-0.3736,0.2880),(0.8657,-0.3669,0.3405),(0.8942,-0.2906,0.3405),(0.8817,-0.3736,0.2880),(0.8461,-0.4486,0.2880),(0.8307,-0.4404,0.3405),(0.8657,-0.3669,0.3405),(0.8461,-0.4486,0.2880),(0.8041,-0.5201,0.2880),(0.7895,-0.5107,0.3405),(0.8307,-0.4404,0.3405),(0.8041,-0.5201,0.2880),(0.7560,-0.5878,0.2880),(0.7423,-0.5771,0.3405),(0.7895,-0.5107,0.3405),(0.7560,-0.5878,0.2880),(0.7023,-0.6510,0.2880),(0.6896,-0.6392,0.3405),(0.7423,-0.5771,0.3405),(0.7023,-0.6510,0.2880),(0.6433,-0.7093,0.2880),(0.6317,-0.6965,0.3405),(0.6896,-0.6392,0.3405),(0.6433,-0.7093,0.2880),(0.5795,-0.7624,0.2880),(0.5690,-0.7485,0.3405),(0.6317,-0.6965,0.3405),(0.5795,-0.7624,0.2880),(0.5114,-0.8097,0.2880),(0.5021,-0.7950,0.3405),(0.5690,-0.7485,0.3405),(0.5114,-0.8097,0.2880),(0.4394,-0.8509,0.2880),(0.4314,-0.8354,0.3405),(0.5021,-0.7950,0.3405),(0.4394,-0.8509,0.2880),(0.3641,-0.8857,0.2880),(0.3575,-0.8697,0.3405),(0.4314,-0.8354,0.3405),(0.3641,-0.8857,0.2880),(0.2860,-0.9139,0.2880),(0.2809,-0.8973,0.3405),(0.3575,-0.8697,0.3405),(0.2860,-0.9139,0.2880),(0.2059,-0.9352,0.2880),(0.2021,-0.9183,0.3405),(0.2809,-0.8973,0.3405),(0.2059,-0.9352,0.2880),(0.1241,-0.9495,0.2880),(0.1219,-0.9323,0.3405),(0.2021,-0.9183,0.3405),(0.1241,-0.9495,0.2880),(0.0415,-0.9567,0.2880),(0.0407,-0.9394,0.3405),(0.1219,-0.9323,0.3405),(0.0415,-0.9567,0.2880),(-0.0415,-0.9567,0.2880),(-0.0407,-0.9394,0.3405),(0.0407,-0.9394,0.3405),(-0.0415,-0.9567,0.2880),(-0.1241,-0.9495,0.2880),(-0.1219,-0.9323,0.3405),(-0.0407,-0.9394,0.3405),(-0.1241,-0.9495,0.2880),(-0.2059,-0.9352,0.2880),(-0.2021,-0.9183,0.3405),(-0.1219,-0.9323,0.3405),(-0.2059,-0.9352,0.2880),(-0.2860,-0.9139,0.2880),(-0.2809,-0.8973,0.3405),(-0.2021,-0.9183,0.3405),(-0.2860,-0.9139,0.2880),(-0.3641,-0.8857,0.2880),(-0.3575,-0.8697,0.3405),(-0.2809,-0.8973,0.3405),(-0.3641,-0.8857,0.2880),(-0.4394,-0.8509,0.2880),(-0.4314,-0.8354,0.3405),(-0.3575,-0.8697,0.3405),(-0.4394,-0.8509,0.2880),(-0.5114,-0.8097,0.2880),(-0.5021,-0.7950,0.3405),(-0.4314,-0.8354,0.3405),(-0.5114,-0.8097,0.2880),(-0.5795,-0.7624,0.2880),(-0.5690,-0.7485,0.3405),(-0.5021,-0.7950,0.3405),(-0.5795,-0.7624,0.2880),(-0.6433,-0.7093,0.2880),(-0.6317,-0.6965,0.3405),(-0.5690,-0.7485,0.3405),(-0.6433,-0.7093,0.2880),(-0.7023,-0.6510,0.2880),(-0.6896,-0.6392,0.3405),(-0.6317,-0.6965,0.3405),(-0.7023,-0.6510,0.2880),(-0.7560,-0.5878,0.2880),(-0.7423,-0.5771,0.3405),(-0.6896,-0.6392,0.3405),(-0.7560,-0.5878,0.2880),(-0.8041,-0.5201,0.2880),(-0.7895,-0.5107,0.3405),(-0.7423,-0.5771,0.3405),(-0.8041,-0.5201,0.2880),(-0.8461,-0.4486,0.2880),(-0.8307,-0.4404,0.3405),(-0.7895,-0.5107,0.3405),(-0.8461,-0.4486,0.2880),(-0.8817,-0.3736,0.2880),(-0.8657,-0.3669,0.3405),(-0.8307,-0.4404,0.3405),(-0.8817,-0.3736,0.2880),(-0.9108,-0.2959,0.2880),(-0.8942,-0.2906,0.3405),(-0.8657,-0.3669,0.3405),(0.8942,-0.2906,0.3405),(0.8657,-0.3669,0.3405),(0.8488,-0.3597,0.3876),(0.8767,-0.2849,0.3876),(0.8657,-0.3669,0.3405),(0.8307,-0.4404,0.3405),(0.8144,-0.4318,0.3876),(0.8488,-0.3597,0.3876),(0.8307,-0.4404,0.3405),(0.7895,-0.5107,0.3405),(0.7740,-0.5007,0.3876),(0.8144,-0.4318,0.3876),(0.7895,-0.5107,0.3405),(0.7423,-0.5771,0.3405),(0.7278,-0.5658,0.3876),(0.7740,-0.5007,0.3876),(0.7423,-0.5771,0.3405),(0.6896,-0.6392,0.3405),(0.6761,-0.6267,0.3876),(0.7278,-0.5658,0.3876),(0.6896,-0.6392,0.3405),(0.6317,-0.6965,0.3405),(0.6193,-0.6828,0.3876),(0.6761,-0.6267,0.3876),(0.6317,-0.6965,0.3405),(0.5690,-0.7485,0.3405),(0.5579,-0.7339,0.3876),(0.6193,-0.6828,0.3876),(0.5690,-0.7485,0.3405),(0.5021,-0.7950,0.3405),(0.4923,-0.7794,0.3876),(0.5579,-0.7339,0.3876),(0.5021,-0.7950,0.3405),(0.4314,-0.8354,0.3405),(0.4229,-0.8191,0.3876),(0.4923,-0.7794,0.3876),(0.4314,-0.8354,0.3405),(0.3575,-0.8697,0.3405),(0.3505,-0.8526,0.3876),(0.4229,-0.8191,0.3876),(0.3575,-0.8697,0.3405),(0.2809,-0.8973,0.3405),(0.2753,-0.8797,0.3876),(0.3505,-0.8526,0.3876),(0.2809,-0.8973,0.3405),(0.2021,-0.9183,0.3405),(0.1982,-0.9003,0.3876),(0.2753,-0.8797,0.3876),(0.2021,-0.9183,0.3405),(0.1219,-0.9323,0.3405),(0.1195,-0.9140,0.3876),(0.1982,-0.9003,0.3876),(0.1219,-0.9323,0.3405),(0.0407,-0.9394,0.3405),(0.0399,-0.9210,0.3876),(0.1195,-0.9140,0.3876),(0.0407,-0.9394,0.3405),(-0.0407,-0.9394,0.3405),(-0.0399,-0.9210,0.3876),(0.0399,-0.9210,0.3876),(-0.0407,-0.9394,0.3405),(-0.1219,-0.9323,0.3405),(-0.1195,-0.9140,0.3876),(-0.0399,-0.9210,0.3876),(-0.1219,-0.9323,0.3405),(-0.2021,-0.9183,0.3405),(-0.1982,-0.9003,0.3876),(-0.1195,-0.9140,0.3876),(-0.2021,-0.9183,0.3405),(-0.2809,-0.8973,0.3405),(-0.2753,-0.8797,0.3876),(-0.1982,-0.9003,0.3876),(-0.2809,-0.8973,0.3405),(-0.3575,-0.8697,0.3405),(-0.3505,-0.8526,0.3876),(-0.2753,-0.8797,0.3876),(-0.3575,-0.8697,0.3405),(-0.4314,-0.8354,0.3405),(-0.4229,-0.8191,0.3876),(-0.3505,-0.8526,0.3876),(-0.4314,-0.8354,0.3405),(-0.5021,-0.7950,0.3405),(-0.4923,-0.7794,0.3876),(-0.4229,-0.8191,0.3876),(-0.5021,-0.7950,0.3405),(-0.5690,-0.7485,0.3405),(-0.5579,-0.7339,0.3876),(-0.4923,-0.7794,0.3876),(-0.5690,-0.7485,0.3405),(-0.6317,-0.6965,0.3405),(-0.6193,-0.6828,0.3876),(-0.5579,-0.7339,0.3876),(-0.6317,-0.6965,0.3405),(-0.6896,-0.6392,0.3405),(-0.6761,-0.6267,0.3876),(-0.6193,-0.6828,0.3876),(-0.6896,-0.6392,0.3405),(-0.7423,-0.5771,0.3405),(-0.7278,-0.5658,0.3876),(-0.6761,-0.6267,0.3876),(-0.7423,-0.5771,0.3405),(-0.7895,-0.5107,0.3405),(-0.7740,-0.5007,0.3876),(-0.7278,-0.5658,0.3876),(-0.7895,-0.5107,0.3405),(-0.8307,-0.4404,0.3405),(-0.8144,-0.4318,0.3876),(-0.7740,-0.5007,0.3876),(-0.8307,-0.4404,0.3405),(-0.8657,-0.3669,0.3405),(-0.8488,-0.3597,0.3876),(-0.8144,-0.4318,0.3876),(-0.8657,-0.3669,0.3405),(-0.8942,-0.2906,0.3405),(-0.8767,-0.2849,0.3876),(-0.8488,-0.3597,0.3876),(0.8767,-0.2849,0.3876),(0.8488,-0.3597,0.3876),(0.8315,-0.3524,0.4295),(0.8589,-0.2791,0.4295),(0.8488,-0.3597,0.3876),(0.8144,-0.4318,0.3876),(0.7979,-0.4230,0.4295),(0.8315,-0.3524,0.4295),(0.8144,-0.4318,0.3876),(0.7740,-0.5007,0.3876),(0.7583,-0.4905,0.4295),(0.7979,-0.4230,0.4295),(0.7740,-0.5007,0.3876),(0.7278,-0.5658,0.3876),(0.7130,-0.5543,0.4295),(0.7583,-0.4905,0.4295),(0.7278,-0.5658,0.3876),(0.6761,-0.6267,0.3876),(0.6623,-0.6139,0.4295),(0.7130,-0.5543,0.4295),(0.6761,-0.6267,0.3876),(0.6193,-0.6828,0.3876),(0.6067,-0.6689,0.4295),(0.6623,-0.6139,0.4295),(0.6193,-0.6828,0.3876),(0.5579,-0.7339,0.3876),(0.5465,-0.7189,0.4295),(0.6067,-0.6689,0.4295),(0.5579,-0.7339,0.3876),(0.4923,-0.7794,0.3876),(0.4822,-0.7635,0.4295),(0.5465,-0.7189,0.4295),(0.4923,-0.7794,0.3876),(0.4229,-0.8191,0.3876),(0.4143,-0.8024,0.4295),(0.4822,-0.7635,0.4295),(0.4229,-0.8191,0.3876),(0.3505,-0.8526,0.3876),(0.3433,-0.8353,0.4295),(0.4143,-0.8024,0.4295),(0.3505,-0.8526,0.3876),(0.2753,-0.8797,0.3876),(0.2697,-0.8619,0.4295),(0.3433,-0.8353,0.4295),(0.2753,-0.8797,0.3876),(0.1982,-0.9003,0.3876),(0.1941,-0.8820,0.4295),(0.2697,-0.8619,0.4295),(0.1982,-0.9003,0.3876),(0.1195,-0.9140,0.3876),(0.1171,-0.8955,0.4295),(0.1941,-0.8820,0.4295),(0.1195,-0.9140,0.3876),(0.0399,-0.9210,0.3876),(0.0391,-0.9022,0.4295),(0.1171,-0.8955,0.4295),(0.0399,-0.9210,0.3876),(-0.0399,-0.9210,0.3876),(-0.0391,-0.9022,0.4295),(0.0391,-0.9022,0.4295),(-0.0399,-0.9210,0.3876),(-0.1195,-0.9140,0.3876),(-0.1171,-0.8955,0.4295),(-0.0391,-0.9022,0.4295),(-0.1195,-0.9140,0.3876),(-0.1982,-0.9003,0.3876),(-0.1941,-0.8820,0.4295),(-0.1171,-0.8955,0.4295),(-0.1982,-0.9003,0.3876),(-0.2753,-0.8797,0.3876),(-0.2697,-0.8619,0.4295),(-0.1941,-0.8820,0.4295),(-0.2753,-0.8797,0.3876),(-0.3505,-0.8526,0.3876),(-0.3433,-0.8353,0.4295),(-0.2697,-0.8619,0.4295),(-0.3505,-0.8526,0.3876),(-0.4229,-0.8191,0.3876),(-0.4143,-0.8024,0.4295),(-0.3433,-0.8353,0.4295),(-0.4229,-0.8191,0.3876),(-0.4923,-0.7794,0.3876),(-0.4822,-0.7635,0.4295),(-0.4143,-0.8024,0.4295),(-0.4923,-0.7794,0.3876),(-0.5579,-0.7339,0.3876),(-0.5465,-0.7189,0.4295),(-0.4822,-0.7635,0.4295),(-0.5579,-0.7339,0.3876),(-0.6193,-0.6828,0.3876),(-0.6067,-0.6689,0.4295),(-0.5465,-0.7189,0.4295),(-0.6193,-0.6828,0.3876),(-0.6761,-0.6267,0.3876),(-0.6623,-0.6139,0.4295),(-0.6067,-0.6689,0.4295),(-0.6761,-0.6267,0.3876),(-0.7278,-0.5658,0.3876),(-0.7130,-0.5543,0.4295),(-0.6623,-0.6139,0.4295),(-0.7278,-0.5658,0.3876),(-0.7740,-0.5007,0.3876),(-0.7583,-0.4905,0.4295),(-0.7130,-0.5543,0.4295),(-0.7740,-0.5007,0.3876),(-0.8144,-0.4318,0.3876),(-0.7979,-0.4230,0.4295),(-0.7583,-0.4905,0.4295),(-0.8144,-0.4318,0.3876),(-0.8488,-0.3597,0.3876),(-0.8315,-0.3524,0.4295),(-0.7979,-0.4230,0.4295),(-0.8488,-0.3597,0.3876),(-0.8767,-0.2849,0.3876),(-0.8589,-0.2791,0.4295),(-0.8315,-0.3524,0.4295),(0.8589,-0.2791,0.4295),(0.8315,-0.3524,0.4295),(0.8145,-0.3452,0.4663),(0.8413,-0.2734,0.4663),(0.8315,-0.3524,0.4295),(0.7979,-0.4230,0.4295),(0.7816,-0.4144,0.4663),(0.8145,-0.3452,0.4663),(0.7979,-0.4230,0.4295),(0.7583,-0.4905,0.4295),(0.7428,-0.4805,0.4663),(0.7816,-0.4144,0.4663),(0.7583,-0.4905,0.4295),(0.7130,-0.5543,0.4295),(0.6984,-0.5429,0.4663),(0.7428,-0.4805,0.4663),(0.7130,-0.5543,0.4295),(0.6623,-0.6139,0.4295),(0.6488,-0.6014,0.4663),(0.6984,-0.5429,0.4663),(0.6623,-0.6139,0.4295),(0.6067,-0.6689,0.4295),(0.5943,-0.6553,0.4663),(0.6488,-0.6014,0.4663),(0.6067,-0.6689,0.4295),(0.5465,-0.7189,0.4295),(0.5353,-0.7042,0.4663),(0.5943,-0.6553,0.4663),(0.5465,-0.7189,0.4295),(0.4822,-0.7635,0.4295),(0.4724,-0.7479,0.4663),(0.5353,-0.7042,0.4663),(0.4822,-0.7635,0.4295),(0.4143,-0.8024,0.4295),(0.4059,-0.7860,0.4663),(0.4724,-0.7479,0.4663),(0.4143,-0.8024,0.4295),(0.3433,-0.8353,0.4295),(0.3363,-0.8182,0.4663),(0.4059,-0.7860,0.4663),(0.3433,-0.8353,0.4295),(0.2697,-0.8619,0.4295),(0.2642,-0.8442,0.4663),(0.3363,-0.8182,0.4663),(0.2697,-0.8619,0.4295),(0.1941,-0.8820,0.4295),(0.1902,-0.8639,0.4663),(0.2642,-0.8442,0.4663),(0.1941,-0.8820,0.4295),(0.1171,-0.8955,0.4295),(0.1147,-0.8771,0.4663),(0.1902,-0.8639,0.4663),(0.1171,-0.8955,0.4295),(0.0391,-0.9022,0.4295),(0.0383,-0.8838,0.4663),(0.1147,-0.8771,0.4663),(0.0391,-0.9022,0.4295),(-0.0391,-0.9022,0.4295),(-0.0383,-0.8838,0.4663),(0.0383,-0.8838,0.4663),(-0.0391,-0.9022,0.4295),(-0.1171,-0.8955,0.4295),(-0.1147,-0.8771,0.4663),(-0.0383,-0.8838,0.4663),(-0.1171,-0.8955,0.4295),(-0.1941,-0.8820,0.4295),(-0.1902,-0.8639,0.4663),(-0.1147,-0.8771,0.4663),(-0.1941,-0.8820,0.4295),(-0.2697,-0.8619,0.4295),(-0.2642,-0.8442,0.4663),(-0.1902,-0.8639,0.4663),(-0.2697,-0.8619,0.4295),(-0.3433,-0.8353,0.4295),(-0.3363,-0.8182,0.4663),(-0.2642,-0.8442,0.4663),(-0.3433,-0.8353,0.4295),(-0.4143,-0.8024,0.4295),(-0.4059,-0.7860,0.4663),(-0.3363,-0.8182,0.4663),(-0.4143,-0.8024,0.4295),(-0.4822,-0.7635,0.4295),(-0.4724,-0.7479,0.4663),(-0.4059,-0.7860,0.4663),(-0.4822,-0.7635,0.4295),(-0.5465,-0.7189,0.4295),(-0.5353,-0.7042,0.4663),(-0.4724,-0.7479,0.4663),(-0.5465,-0.7189,0.4295),(-0.6067,-0.6689,0.4295),(-0.5943,-0.6553,0.4663),(-0.5353,-0.7042,0.4663),(-0.6067,-0.6689,0.4295),(-0.6623,-0.6139,0.4295),(-0.6488,-0.6014,0.4663),(-0.5943,-0.6553,0.4663),(-0.6623,-0.6139,0.4295),(-0.7130,-0.5543,0.4295),(-0.6984,-0.5429,0.4663),(-0.6488,-0.6014,0.4663),(-0.7130,-0.5543,0.4295),(-0.7583,-0.4905,0.4295),(-0.7428,-0.4805,0.4663),(-0.6984,-0.5429,0.4663),(-0.7583,-0.4905,0.4295),(-0.7979,-0.4230,0.4295),(-0.7816,-0.4144,0.4663),(-0.7428,-0.4805,0.4663),(-0.7979,-0.4230,0.4295),(-0.8315,-0.3524,0.4295),(-0.8145,-0.3452,0.4663),(-0.7816,-0.4144,0.4663),(-0.8315,-0.3524,0.4295),(-0.8589,-0.2791,0.4295),(-0.8413,-0.2734,0.4663),(-0.8145,-0.3452,0.4663),(0.8413,-0.2734,0.4663),(0.8145,-0.3452,0.4663),(0.7981,-0.3382,0.4986),(0.8244,-0.2679,0.4986),(0.8145,-0.3452,0.4663),(0.7816,-0.4144,0.4663),(0.7659,-0.4060,0.4986),(0.7981,-0.3382,0.4986),(0.7816,-0.4144,0.4663),(0.7428,-0.4805,0.4663),(0.7279,-0.4708,0.4986),(0.7659,-0.4060,0.4986),(0.7428,-0.4805,0.4663),(0.6984,-0.5429,0.4663),(0.6844,-0.5320,0.4986),(0.7279,-0.4708,0.4986),(0.6984,-0.5429,0.4663),(0.6488,-0.6014,0.4663),(0.6358,-0.5893,0.4986),(0.6844,-0.5320,0.4986),(0.6488,-0.6014,0.4663),(0.5943,-0.6553,0.4663),(0.5824,-0.6421,0.4986),(0.6358,-0.5893,0.4986),(0.5943,-0.6553,0.4663),(0.5353,-0.7042,0.4663),(0.5246,-0.6901,0.4986),(0.5824,-0.6421,0.4986),(0.5353,-0.7042,0.4663),(0.4724,-0.7479,0.4663),(0.4629,-0.7329,0.4986),(0.5246,-0.6901,0.4986),(0.4724,-0.7479,0.4663),(0.4059,-0.7860,0.4663),(0.3977,-0.7702,0.4986),(0.4629,-0.7329,0.4986),(0.4059,-0.7860,0.4663),(0.3363,-0.8182,0.4663),(0.3296,-0.8018,0.4986),(0.3977,-0.7702,0.4986),(0.3363,-0.8182,0.4663),(0.2642,-0.8442,0.4663),(0.2589,-0.8273,0.4986),(0.3296,-0.8018,0.4986),(0.2642,-0.8442,0.4663),(0.1902,-0.8639,0.4663),(0.1863,-0.8466,0.4986),(0.2589,-0.8273,0.4986),(0.1902,-0.8639,0.4663),(0.1147,-0.8771,0.4663),(0.1124,-0.8595,0.4986),(0.1863,-0.8466,0.4986),(0.1147,-0.8771,0.4663),(0.0383,-0.8838,0.4663),(0.0376,-0.8660,0.4986),(0.1124,-0.8595,0.4986),(0.0383,-0.8838,0.4663),(-0.0383,-0.8838,0.4663),(-0.0376,-0.8660,0.4986),(0.0376,-0.8660,0.4986),(-0.0383,-0.8838,0.4663),(-0.1147,-0.8771,0.4663),(-0.1124,-0.8595,0.4986),(-0.0376,-0.8660,0.4986),(-0.1147,-0.8771,0.4663),(-0.1902,-0.8639,0.4663),(-0.1863,-0.8466,0.4986),(-0.1124,-0.8595,0.4986),(-0.1902,-0.8639,0.4663),(-0.2642,-0.8442,0.4663),(-0.2589,-0.8273,0.4986),(-0.1863,-0.8466,0.4986),(-0.2642,-0.8442,0.4663),(-0.3363,-0.8182,0.4663),(-0.3296,-0.8018,0.4986),(-0.2589,-0.8273,0.4986),(-0.3363,-0.8182,0.4663),(-0.4059,-0.7860,0.4663),(-0.3977,-0.7702,0.4986),(-0.3296,-0.8018,0.4986),(-0.4059,-0.7860,0.4663),(-0.4724,-0.7479,0.4663),(-0.4629,-0.7329,0.4986),(-0.3977,-0.7702,0.4986),(-0.4724,-0.7479,0.4663),(-0.5353,-0.7042,0.4663),(-0.5246,-0.6901,0.4986),(-0.4629,-0.7329,0.4986),(-0.5353,-0.7042,0.4663),(-0.5943,-0.6553,0.4663),(-0.5824,-0.6421,0.4986),(-0.5246,-0.6901,0.4986),(-0.5943,-0.6553,0.4663),(-0.6488,-0.6014,0.4663),(-0.6358,-0.5893,0.4986),(-0.5824,-0.6421,0.4986),(-0.6488,-0.6014,0.4663),(-0.6984,-0.5429,0.4663),(-0.6844,-0.5320,0.4986),(-0.6358,-0.5893,0.4986),(-0.6984,-0.5429,0.4663),(-0.7428,-0.4805,0.4663),(-0.7279,-0.4708,0.4986),(-0.6844,-0.5320,0.4986),(-0.7428,-0.4805,0.4663),(-0.7816,-0.4144,0.4663),(-0.7659,-0.4060,0.4986),(-0.7279,-0.4708,0.4986),(-0.7816,-0.4144,0.4663),(-0.8145,-0.3452,0.4663),(-0.7981,-0.3382,0.4986),(-0.7659,-0.4060,0.4986),(-0.8145,-0.3452,0.4663),(-0.8413,-0.2734,0.4663),(-0.8244,-0.2679,0.4986),(-0.7981,-0.3382,0.4986),(0.8244,-0.2679,0.4986),(0.7981,-0.3382,0.4986),(0.7827,-0.3317,0.5266),(0.8085,-0.2627,0.5266),(0.7981,-0.3382,0.4986),(0.7659,-0.4060,0.4986),(0.7511,-0.3982,0.5266),(0.7827,-0.3317,0.5266),(0.7659,-0.4060,0.4986),(0.7279,-0.4708,0.4986),(0.7138,-0.4617,0.5266),(0.7511,-0.3982,0.5266),(0.7279,-0.4708,0.4986),(0.6844,-0.5320,0.4986),(0.6712,-0.5218,0.5266),(0.7138,-0.4617,0.5266),(0.6844,-0.5320,0.4986),(0.6358,-0.5893,0.4986),(0.6235,-0.5779,0.5266),(0.6712,-0.5218,0.5266),(0.6358,-0.5893,0.4986),(0.5824,-0.6421,0.4986),(0.5711,-0.6297,0.5266),(0.6235,-0.5779,0.5266),(0.5824,-0.6421,0.4986),(0.5246,-0.6901,0.4986),(0.5145,-0.6768,0.5266),(0.5711,-0.6297,0.5266),(0.5246,-0.6901,0.4986),(0.4629,-0.7329,0.4986),(0.4540,-0.7188,0.5266),(0.5145,-0.6768,0.5266),(0.4629,-0.7329,0.4986),(0.3977,-0.7702,0.4986),(0.3900,-0.7553,0.5266),(0.4540,-0.7188,0.5266),(0.3977,-0.7702,0.4986),(0.3296,-0.8018,0.4986),(0.3232,-0.7863,0.5266),(0.3900,-0.7553,0.5266),(0.3296,-0.8018,0.4986),(0.2589,-0.8273,0.4986),(0.2539,-0.8113,0.5266),(0.3232,-0.7863,0.5266),(0.2589,-0.8273,0.4986),(0.1863,-0.8466,0.4986),(0.1827,-0.8302,0.5266),(0.2539,-0.8113,0.5266),(0.1863,-0.8466,0.4986),(0.1124,-0.8595,0.4986),(0.1102,-0.8429,0.5266),(0.1827,-0.8302,0.5266),(0.1124,-0.8595,0.4986),(0.0376,-0.8660,0.4986),(0.0368,-0.8493,0.5266),(0.1102,-0.8429,0.5266),(0.0376,-0.8660,0.4986),(-0.0376,-0.8660,0.4986),(-0.0368,-0.8493,0.5266),(0.0368,-0.8493,0.5266),(-0.0376,-0.8660,0.4986),(-0.1124,-0.8595,0.4986),(-0.1102,-0.8429,0.5266),(-0.0368,-0.8493,0.5266),(-0.1124,-0.8595,0.4986),(-0.1863,-0.8466,0.4986),(-0.1827,-0.8302,0.5266),(-0.1102,-0.8429,0.5266),(-0.1863,-0.8466,0.4986),(-0.2589,-0.8273,0.4986),(-0.2539,-0.8113,0.5266),(-0.1827,-0.8302,0.5266),(-0.2589,-0.8273,0.4986),(-0.3296,-0.8018,0.4986),(-0.3232,-0.7863,0.5266),(-0.2539,-0.8113,0.5266),(-0.3296,-0.8018,0.4986),(-0.3977,-0.7702,0.4986),(-0.3900,-0.7553,0.5266),(-0.3232,-0.7863,0.5266),(-0.3977,-0.7702,0.4986),(-0.4629,-0.7329,0.4986),(-0.4540,-0.7188,0.5266),(-0.3900,-0.7553,0.5266),(-0.4629,-0.7329,0.4986),(-0.5246,-0.6901,0.4986),(-0.5145,-0.6768,0.5266),(-0.4540,-0.7188,0.5266),(-0.5246,-0.6901,0.4986),(-0.5824,-0.6421,0.4986),(-0.5711,-0.6297,0.5266),(-0.5145,-0.6768,0.5266),(-0.5824,-0.6421,0.4986),(-0.6358,-0.5893,0.4986),(-0.6235,-0.5779,0.5266),(-0.5711,-0.6297,0.5266),(-0.6358,-0.5893,0.4986),(-0.6844,-0.5320,0.4986),(-0.6712,-0.5218,0.5266),(-0.6235,-0.5779,0.5266),(-0.6844,-0.5320,0.4986),(-0.7279,-0.4708,0.4986),(-0.7138,-0.4617,0.5266),(-0.6712,-0.5218,0.5266),(-0.7279,-0.4708,0.4986),(-0.7659,-0.4060,0.4986),(-0.7511,-0.3982,0.5266),(-0.7138,-0.4617,0.5266),(-0.7659,-0.4060,0.4986),(-0.7981,-0.3382,0.4986),(-0.7827,-0.3317,0.5266),(-0.7511,-0.3982,0.5266),(-0.7981,-0.3382,0.4986),(-0.8244,-0.2679,0.4986),(-0.8085,-0.2627,0.5266),(-0.7827,-0.3317,0.5266),(0.8085,-0.2627,0.5266),(0.7827,-0.3317,0.5266),(0.7684,-0.3256,0.5509),(0.7937,-0.2579,0.5509),(0.7827,-0.3317,0.5266),(0.7511,-0.3982,0.5266),(0.7373,-0.3909,0.5509),(0.7684,-0.3256,0.5509),(0.7511,-0.3982,0.5266),(0.7138,-0.4617,0.5266),(0.7007,-0.4533,0.5509),(0.7373,-0.3909,0.5509),(0.7138,-0.4617,0.5266),(0.6712,-0.5218,0.5266),(0.6589,-0.5122,0.5509),(0.7007,-0.4533,0.5509),(0.6712,-0.5218,0.5266),(0.6235,-0.5779,0.5266),(0.6121,-0.5673,0.5509),(0.6589,-0.5122,0.5509),(0.6235,-0.5779,0.5266),(0.5711,-0.6297,0.5266),(0.5607,-0.6182,0.5509),(0.6121,-0.5673,0.5509),(0.5711,-0.6297,0.5266),(0.5145,-0.6768,0.5266),(0.5050,-0.6644,0.5509),(0.5607,-0.6182,0.5509),(0.5145,-0.6768,0.5266),(0.4540,-0.7188,0.5266),(0.4456,-0.7056,0.5509),(0.5050,-0.6644,0.5509),(0.4540,-0.7188,0.5266),(0.3900,-0.7553,0.5266),(0.3829,-0.7415,0.5509),(0.4456,-0.7056,0.5509),(0.3900,-0.7553,0.5266),(0.3232,-0.7863,0.5266),(0.3173,-0.7719,0.5509),(0.3829,-0.7415,0.5509),(0.3232,-0.7863,0.5266),(0.2539,-0.8113,0.5266),(0.2493,-0.7964,0.5509),(0.3173,-0.7719,0.5509),(0.2539,-0.8113,0.5266),(0.1827,-0.8302,0.5266),(0.1794,-0.8150,0.5509),(0.2493,-0.7964,0.5509),(0.1827,-0.8302,0.5266),(0.1102,-0.8429,0.5266),(0.1082,-0.8275,0.5509),(0.1794,-0.8150,0.5509),(0.1102,-0.8429,0.5266),(0.0368,-0.8493,0.5266),(0.0362,-0.8338,0.5509),(0.1082,-0.8275,0.5509),(0.0368,-0.8493,0.5266),(-0.0368,-0.8493,0.5266),(-0.0362,-0.8338,0.5509),(0.0362,-0.8338,0.5509),(-0.0368,-0.8493,0.5266),(-0.1102,-0.8429,0.5266),(-0.1082,-0.8275,0.5509),(-0.0362,-0.8338,0.5509),(-0.1102,-0.8429,0.5266),(-0.1827,-0.8302,0.5266),(-0.1794,-0.8150,0.5509),(-0.1082,-0.8275,0.5509),(-0.1827,-0.8302,0.5266),(-0.2539,-0.8113,0.5266),(-0.2493,-0.7964,0.5509),(-0.1794,-0.8150,0.5509),(-0.2539,-0.8113,0.5266),(-0.3232,-0.7863,0.5266),(-0.3173,-0.7719,0.5509),(-0.2493,-0.7964,0.5509),(-0.3232,-0.7863,0.5266),(-0.3900,-0.7553,0.5266),(-0.3829,-0.7415,0.5509),(-0.3173,-0.7719,0.5509),(-0.3900,-0.7553,0.5266),(-0.4540,-0.7188,0.5266),(-0.4456,-0.7056,0.5509),(-0.3829,-0.7415,0.5509),(-0.4540,-0.7188,0.5266),(-0.5145,-0.6768,0.5266),(-0.5050,-0.6644,0.5509),(-0.4456,-0.7056,0.5509),(-0.5145,-0.6768,0.5266),(-0.5711,-0.6297,0.5266),(-0.5607,-0.6182,0.5509),(-0.5050,-0.6644,0.5509),(-0.5711,-0.6297,0.5266),(-0.6235,-0.5779,0.5266),(-0.6121,-0.5673,0.5509),(-0.5607,-0.6182,0.5509),(-0.6235,-0.5779,0.5266),(-0.6712,-0.5218,0.5266),(-0.6589,-0.5122,0.5509),(-0.6121,-0.5673,0.5509),(-0.6712,-0.5218,0.5266),(-0.7138,-0.4617,0.5266),(-0.7007,-0.4533,0.5509),(-0.6589,-0.5122,0.5509),(-0.7138,-0.4617,0.5266),(-0.7511,-0.3982,0.5266),(-0.7373,-0.3909,0.5509),(-0.7007,-0.4533,0.5509),(-0.7511,-0.3982,0.5266),(-0.7827,-0.3317,0.5266),(-0.7684,-0.3256,0.5509),(-0.7373,-0.3909,0.5509),(-0.7827,-0.3317,0.5266),(-0.8085,-0.2627,0.5266),(-0.7937,-0.2579,0.5509),(-0.7684,-0.3256,0.5509),(0.7937,-0.2579,0.5509),(0.7684,-0.3256,0.5509),(0.7552,-0.3200,0.5720),(0.7801,-0.2535,0.5720),(0.7684,-0.3256,0.5509),(0.7373,-0.3909,0.5509),(0.7247,-0.3842,0.5720),(0.7552,-0.3200,0.5720),(0.7373,-0.3909,0.5509),(0.7007,-0.4533,0.5509),(0.6887,-0.4455,0.5720),(0.7247,-0.3842,0.5720),(0.7007,-0.4533,0.5509),(0.6589,-0.5122,0.5509),(0.6476,-0.5034,0.5720),(0.6887,-0.4455,0.5720),(0.6589,-0.5122,0.5509),(0.6121,-0.5673,0.5509),(0.6016,-0.5576,0.5720),(0.6476,-0.5034,0.5720),(0.6121,-0.5673,0.5509),(0.5607,-0.6182,0.5509),(0.5511,-0.6076,0.5720),(0.6016,-0.5576,0.5720),(0.5607,-0.6182,0.5509),(0.5050,-0.6644,0.5509),(0.4964,-0.6530,0.5720),(0.5511,-0.6076,0.5720),(0.5050,-0.6644,0.5509),(0.4456,-0.7056,0.5509),(0.4380,-0.6935,0.5720),(0.4964,-0.6530,0.5720),(0.4456,-0.7056,0.5509),(0.3829,-0.7415,0.5509),(0.3763,-0.7288,0.5720),(0.4380,-0.6935,0.5720),(0.3829,-0.7415,0.5509),(0.3173,-0.7719,0.5509),(0.3118,-0.7587,0.5720),(0.3763,-0.7288,0.5720),(0.3173,-0.7719,0.5509),(0.2493,-0.7964,0.5509),(0.2450,-0.7828,0.5720),(0.3118,-0.7587,0.5720),(0.2493,-0.7964,0.5509),(0.1794,-0.8150,0.5509),(0.1763,-0.8011,0.5720),(0.2450,-0.7828,0.5720),(0.1794,-0.8150,0.5509),(0.1082,-0.8275,0.5509),(0.1063,-0.8133,0.5720),(0.1763,-0.8011,0.5720),(0.1082,-0.8275,0.5509),(0.0362,-0.8338,0.5509),(0.0355,-0.8195,0.5720),(0.1063,-0.8133,0.5720),(0.0362,-0.8338,0.5509),(-0.0362,-0.8338,0.5509),(-0.0355,-0.8195,0.5720),(0.0355,-0.8195,0.5720),(-0.0362,-0.8338,0.5509),(-0.1082,-0.8275,0.5509),(-0.1063,-0.8133,0.5720),(-0.0355,-0.8195,0.5720),(-0.1082,-0.8275,0.5509),(-0.1794,-0.8150,0.5509),(-0.1763,-0.8011,0.5720),(-0.1063,-0.8133,0.5720),(-0.1794,-0.8150,0.5509),(-0.2493,-0.7964,0.5509),(-0.2450,-0.7828,0.5720),(-0.1763,-0.8011,0.5720),(-0.2493,-0.7964,0.5509),(-0.3173,-0.7719,0.5509),(-0.3118,-0.7587,0.5720),(-0.2450,-0.7828,0.5720),(-0.3173,-0.7719,0.5509),(-0.3829,-0.7415,0.5509),(-0.3763,-0.7288,0.5720),(-0.3118,-0.7587,0.5720),(-0.3829,-0.7415,0.5509),(-0.4456,-0.7056,0.5509),(-0.4380,-0.6935,0.5720),(-0.3763,-0.7288,0.5720),(-0.4456,-0.7056,0.5509),(-0.5050,-0.6644,0.5509),(-0.4964,-0.6530,0.5720),(-0.4380,-0.6935,0.5720),(-0.5050,-0.6644,0.5509),(-0.5607,-0.6182,0.5509),(-0.5511,-0.6076,0.5720),(-0.4964,-0.6530,0.5720),(-0.5607,-0.6182,0.5509),(-0.6121,-0.5673,0.5509),(-0.6016,-0.5576,0.5720),(-0.5511,-0.6076,0.5720),(-0.6121,-0.5673,0.5509),(-0.6589,-0.5122,0.5509),(-0.6476,-0.5034,0.5720),(-0.6016,-0.5576,0.5720),(-0.6589,-0.5122,0.5509),(-0.7007,-0.4533,0.5509),(-0.6887,-0.4455,0.5720),(-0.6476,-0.5034,0.5720),(-0.7007,-0.4533,0.5509),(-0.7373,-0.3909,0.5509),(-0.7247,-0.3842,0.5720),(-0.6887,-0.4455,0.5720),(-0.7373,-0.3909,0.5509),(-0.7684,-0.3256,0.5509),(-0.7552,-0.3200,0.5720),(-0.7247,-0.3842,0.5720),(-0.7684,-0.3256,0.5509),(-0.7937,-0.2579,0.5509),(-0.7801,-0.2535,0.5720),(-0.7552,-0.3200,0.5720),(0.7801,-0.2535,0.5720),(0.7552,-0.3200,0.5720),(0.7433,-0.3150,0.5902),(0.7678,-0.2495,0.5902),(0.7552,-0.3200,0.5720),(0.7247,-0.3842,0.5720),(0.7132,-0.3781,0.5902),(0.7433,-0.3150,0.5902),(0.7247,-0.3842,0.5720),(0.6887,-0.4455,0.5720),(0.6778,-0.4384,0.5902),(0.7132,-0.3781,0.5902),(0.6887,-0.4455,0.5720),(0.6476,-0.5034,0.5720),(0.6373,-0.4955,0.5902),(0.6778,-0.4384,0.5902),(0.6476,-0.5034,0.5720),(0.6016,-0.5576,0.5720),(0.5921,-0.5488,0.5902),(0.6373,-0.4955,0.5902),(0.6016,-0.5576,0.5720),(0.5511,-0.6076,0.5720),(0.5423,-0.5980,0.5902),(0.5921,-0.5488,0.5902),(0.5511,-0.6076,0.5720),(0.4964,-0.6530,0.5720),(0.4885,-0.6427,0.5902),(0.5423,-0.5980,0.5902),(0.4964,-0.6530,0.5720),(0.4380,-0.6935,0.5720),(0.4311,-0.6825,0.5902),(0.4885,-0.6427,0.5902),(0.4380,-0.6935,0.5720),(0.3763,-0.7288,0.5720),(0.3704,-0.7173,0.5902),(0.4311,-0.6825,0.5902),(0.3763,-0.7288,0.5720),(0.3118,-0.7587,0.5720),(0.3069,-0.7467,0.5902),(0.3704,-0.7173,0.5902),(0.3118,-0.7587,0.5720),(0.2450,-0.7828,0.5720),(0.2411,-0.7704,0.5902),(0.3069,-0.7467,0.5902),(0.2450,-0.7828,0.5720),(0.1763,-0.8011,0.5720),(0.1735,-0.7884,0.5902),(0.2411,-0.7704,0.5902),(0.1763,-0.8011,0.5720),(0.1063,-0.8133,0.5720),(0.1046,-0.8005,0.5902),(0.1735,-0.7884,0.5902),(0.1063,-0.8133,0.5720),(0.0355,-0.8195,0.5720),(0.0350,-0.8065,0.5902),(0.1046,-0.8005,0.5902),(0.0355,-0.8195,0.5720),(-0.0355,-0.8195,0.5720),(-0.0350,-0.8065,0.5902),(0.0350,-0.8065,0.5902),(-0.0355,-0.8195,0.5720),(-0.1063,-0.8133,0.5720),(-0.1046,-0.8005,0.5902),(-0.0350,-0.8065,0.5902),(-0.1063,-0.8133,0.5720),(-0.1763,-0.8011,0.5720),(-0.1735,-0.7884,0.5902),(-0.1046,-0.8005,0.5902),(-0.1763,-0.8011,0.5720),(-0.2450,-0.7828,0.5720),(-0.2411,-0.7704,0.5902),(-0.1735,-0.7884,0.5902),(-0.2450,-0.7828,0.5720),(-0.3118,-0.7587,0.5720),(-0.3069,-0.7467,0.5902),(-0.2411,-0.7704,0.5902),(-0.3118,-0.7587,0.5720),(-0.3763,-0.7288,0.5720),(-0.3704,-0.7173,0.5902),(-0.3069,-0.7467,0.5902),(-0.3763,-0.7288,0.5720),(-0.4380,-0.6935,0.5720),(-0.4311,-0.6825,0.5902),(-0.3704,-0.7173,0.5902),(-0.4380,-0.6935,0.5720),(-0.4964,-0.6530,0.5720),(-0.4885,-0.6427,0.5902),(-0.4311,-0.6825,0.5902),(-0.4964,-0.6530,0.5720),(-0.5511,-0.6076,0.5720),(-0.5423,-0.5980,0.5902),(-0.4885,-0.6427,0.5902),(-0.5511,-0.6076,0.5720),(-0.6016,-0.5576,0.5720),(-0.5921,-0.5488,0.5902),(-0.5423,-0.5980,0.5902),(-0.6016,-0.5576,0.5720),(-0.6476,-0.5034,0.5720),(-0.6373,-0.4955,0.5902),(-0.5921,-0.5488,0.5902),(-0.6476,-0.5034,0.5720),(-0.6887,-0.4455,0.5720),(-0.6778,-0.4384,0.5902),(-0.6373,-0.4955,0.5902),(-0.6887,-0.4455,0.5720),(-0.7247,-0.3842,0.5720),(-0.7132,-0.3781,0.5902),(-0.6778,-0.4384,0.5902),(-0.7247,-0.3842,0.5720),(-0.7552,-0.3200,0.5720),(-0.7433,-0.3150,0.5902),(-0.7132,-0.3781,0.5902),(-0.7552,-0.3200,0.5720),(-0.7801,-0.2535,0.5720),(-0.7678,-0.2495,0.5902),(-0.7433,-0.3150,0.5902),(0.7678,-0.2495,0.5902),(0.7433,-0.3150,0.5902),(0.7325,-0.3104,0.6059),(0.7566,-0.2458,0.6059),(0.7433,-0.3150,0.5902),(0.7132,-0.3781,0.5902),(0.7029,-0.3726,0.6059),(0.7325,-0.3104,0.6059),(0.7132,-0.3781,0.5902),(0.6778,-0.4384,0.5902),(0.6680,-0.4321,0.6059),(0.7029,-0.3726,0.6059),(0.6778,-0.4384,0.5902),(0.6373,-0.4955,0.5902),(0.6281,-0.4883,0.6059),(0.6680,-0.4321,0.6059),(0.6373,-0.4955,0.5902),(0.5921,-0.5488,0.5902),(0.5835,-0.5408,0.6059),(0.6281,-0.4883,0.6059),(0.5921,-0.5488,0.5902),(0.5423,-0.5980,0.5902),(0.5345,-0.5893,0.6059),(0.5835,-0.5408,0.6059),(0.5423,-0.5980,0.5902),(0.4885,-0.6427,0.5902),(0.4814,-0.6333,0.6059),(0.5345,-0.5893,0.6059),(0.4885,-0.6427,0.5902),(0.4311,-0.6825,0.5902),(0.4248,-0.6726,0.6059),(0.4814,-0.6333,0.6059),(0.4311,-0.6825,0.5902),(0.3704,-0.7173,0.5902),(0.3650,-0.7069,0.6059),(0.4248,-0.6726,0.6059),(0.3704,-0.7173,0.5902),(0.3069,-0.7467,0.5902),(0.3025,-0.7358,0.6059),(0.3650,-0.7069,0.6059),(0.3069,-0.7467,0.5902),(0.2411,-0.7704,0.5902),(0.2376,-0.7592,0.6059),(0.3025,-0.7358,0.6059),(0.2411,-0.7704,0.5902),(0.1735,-0.7884,0.5902),(0.1710,-0.7770,0.6059),(0.2376,-0.7592,0.6059),(0.1735,-0.7884,0.5902),(0.1046,-0.8005,0.5902),(0.1031,-0.7888,0.6059),(0.1710,-0.7770,0.6059),(0.1046,-0.8005,0.5902),(0.0350,-0.8065,0.5902),(0.0345,-0.7948,0.6059),(0.1031,-0.7888,0.6059),(0.0350,-0.8065,0.5902),(-0.0350,-0.8065,0.5902),(-0.0345,-0.7948,0.6059),(0.0345,-0.7948,0.6059),(-0.0350,-0.8065,0.5902),(-0.1046,-0.8005,0.5902),(-0.1031,-0.7888,0.6059),(-0.0345,-0.7948,0.6059),(-0.1046,-0.8005,0.5902),(-0.1735,-0.7884,0.5902),(-0.1710,-0.7770,0.6059),(-0.1031,-0.7888,0.6059),(-0.1735,-0.7884,0.5902),(-0.2411,-0.7704,0.5902),(-0.2376,-0.7592,0.6059),(-0.1710,-0.7770,0.6059),(-0.2411,-0.7704,0.5902),(-0.3069,-0.7467,0.5902),(-0.3025,-0.7358,0.6059),(-0.2376,-0.7592,0.6059),(-0.3069,-0.7467,0.5902),(-0.3704,-0.7173,0.5902),(-0.3650,-0.7069,0.6059),(-0.3025,-0.7358,0.6059),(-0.3704,-0.7173,0.5902),(-0.4311,-0.6825,0.5902),(-0.4248,-0.6726,0.6059),(-0.3650,-0.7069,0.6059),(-0.4311,-0.6825,0.5902),(-0.4885,-0.6427,0.5902),(-0.4814,-0.6333,0.6059),(-0.4248,-0.6726,0.6059),(-0.4885,-0.6427,0.5902),(-0.5423,-0.5980,0.5902),(-0.5345,-0.5893,0.6059),(-0.4814,-0.6333,0.6059),(-0.5423,-0.5980,0.5902),(-0.5921,-0.5488,0.5902),(-0.5835,-0.5408,0.6059),(-0.5345,-0.5893,0.6059),(-0.5921,-0.5488,0.5902),(-0.6373,-0.4955,0.5902),(-0.6281,-0.4883,0.6059),(-0.5835,-0.5408,0.6059),(-0.6373,-0.4955,0.5902),(-0.6778,-0.4384,0.5902),(-0.6680,-0.4321,0.6059),(-0.6281,-0.4883,0.6059),(-0.6778,-0.4384,0.5902),(-0.7132,-0.3781,0.5902),(-0.7029,-0.3726,0.6059),(-0.6680,-0.4321,0.6059),(-0.7132,-0.3781,0.5902),(-0.7433,-0.3150,0.5902),(-0.7325,-0.3104,0.6059),(-0.7029,-0.3726,0.6059),(-0.7433,-0.3150,0.5902),(-0.7678,-0.2495,0.5902),(-0.7566,-0.2458,0.6059),(-0.7325,-0.3104,0.6059)]),
        color=Color(color=[(0.0000,0.0000,0.7000),(0.9985,0.0000,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.0000,0.7000),(0.1081,0.0000,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.0000,0.7000),(0.9868,0.0000,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.0000,0.7000),(0.2150,0.0000,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.0000,0.7000),(0.9635,0.0000,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.0000,0.7000),(0.3193,0.0000,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.0000,0.7000),(0.9290,0.0000,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.0000,0.7000),(0.4199,0.0000,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.0000,0.7000),(0.8835,0.0000,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.0000,0.7000),(0.5156,0.0000,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.0000,0.7000),(0.8277,0.0000,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.0000,0.7000),(0.6052,0.0000,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.0000,0.7000),(0.7622,0.0000,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.0000,0.7000),(0.6877,0.0000,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.0000,0.7000),(0.6877,0.0000,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.0000,0.7000),(0.7622,0.0000,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.0000,0.7000),(0.6052,0.0000,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.0000,0.7000),(0.8277,0.0000,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.0000,0.7000),(0.5156,0.0000,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.0000,0.7000),(0.8835,0.0000,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.0000,0.7000),(0.4199,0.0000,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.0000,0.7000),(0.9290,0.0000,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.0000,0.7000),(0.3193,0.0000,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.0000,0.7000),(0.9635,0.0000,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.0000,0.7000),(0.2150,0.0000,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.0000,0.7000),(0.9868,0.0000,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.0000,0.7000),(0.1081,0.0000,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.0000,0.7000),(0.9985,0.0000,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.0000,0.7000),(0.0000,0.0000,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.7622,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.7622,0.7000),(0.7622,0.7622,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.7622,0.7000),(0.6052,0.7622,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.7622,0.7000),(0.8277,0.7622,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.7622,0.7000),(0.5156,0.7622,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.7622,0.7000),(0.8835,0.7622,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.7622,0.7000),(0.4199,0.7622,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.7622,0.7000),(0.9290,0.7622,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.7622,0.7000),(0.3193,0.7622,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.7622,0.7000),(0.9635,0.7622,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.7622,0.7000),(0.2150,0.7622,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.7622,0.7000),(0.9868,0.7622,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.7622,0.7000),(0.1081,0.7622,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.7622,0.7000),(0.9985,0.7622,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.7622,0.7000),(0.0000,0.7622,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.5156,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.5156,0.7000),(0.7622,0.5156,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.5156,0.7000),(0.6052,0.5156,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.5156,0.7000),(0.8277,0.5156,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.5156,0.7000),(0.5156,0.5156,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.5156,0.7000),(0.8835,0.5156,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.5156,0.7000),(0.4199,0.5156,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.5156,0.7000),(0.9290,0.5156,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.5156,0.7000),(0.3193,0.5156,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.5156,0.7000),(0.9635,0.5156,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.5156,0.7000),(0.2150,0.5156,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.5156,0.7000),(0.9868,0.5156,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.5156,0.7000),(0.1081,0.5156,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.5156,0.7000),(0.9985,0.5156,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.5156,0.7000),(0.0000,0.5156,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.9290,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9290,0.7000),(0.7622,0.9290,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.9290,0.7000),(0.6052,0.9290,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.9290,0.7000),(0.8277,0.9290,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.9290,0.7000),(0.5156,0.9290,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.9290,0.7000),(0.8835,0.9290,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.9290,0.7000),(0.4199,0.9290,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.9290,0.7000),(0.9290,0.9290,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.9290,0.7000),(0.3193,0.9290,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.9290,0.7000),(0.9635,0.9290,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.9290,0.7000),(0.2150,0.9290,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.9290,0.7000),(0.9868,0.9290,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.9290,0.7000),(0.1081,0.9290,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.9290,0.7000),(0.9985,0.9290,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.9290,0.7000),(0.0000,0.9290,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.2150,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.2150,0.7000),(0.7622,0.2150,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.2150,0.7000),(0.6052,0.2150,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.2150,0.7000),(0.8277,0.2150,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.2150,0.7000),(0.5156,0.2150,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.2150,0.7000),(0.8835,0.2150,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.2150,0.7000),(0.4199,0.2150,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.2150,0.7000),(0.9290,0.2150,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.2150,0.7000),(0.3193,0.2150,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.2150,0.7000),(0.9635,0.2150,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.2150,0.7000),(0.2150,0.2150,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.2150,0.7000),(0.9868,0.2150,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.2150,0.7000),(0.1081,0.2150,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.2150,0.7000),(0.9985,0.2150,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.2150,0.7000),(0.0000,0.2150,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.9985,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9985,0.7000),(0.7622,0.9985,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.9985,0.7000),(0.6052,0.9985,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.9985,0.7000),(0.8277,0.9985,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.9985,0.7000),(0.5156,0.9985,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.9985,0.7000),(0.8835,0.9985,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.9985,0.7000),(0.4199,0.9985,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.9985,0.7000),(0.9290,0.9985,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.9985,0.7000),(0.3193,0.9985,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.9985,0.7000),(0.9635,0.9985,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.9985,0.7000),(0.2150,0.9985,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.9985,0.7000),(0.9868,0.9985,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.9985,0.7000),(0.1081,0.9985,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.9985,0.7000),(0.9985,0.9985,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.9985,0.7000),(0.0000,0.9985,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.1081,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.1081,0.7000),(0.7622,0.1081,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.1081,0.7000),(0.6052,0.1081,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.1081,0.7000),(0.8277,0.1081,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.1081,0.7000),(0.5156,0.1081,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.1081,0.7000),(0.8835,0.1081,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.1081,0.7000),(0.4199,0.1081,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.1081,0.7000),(0.9290,0.1081,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.1081,0.7000),(0.3193,0.1081,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.1081,0.7000),(0.9635,0.1081,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.1081,0.7000),(0.2150,0.1081,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.1081,0.7000),(0.9868,0.1081,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.1081,0.7000),(0.1081,0.1081,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.1081,0.7000),(0.9985,0.1081,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.1081,0.7000),(0.0000,0.1081,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.9635,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.9635,0.7000),(0.7622,0.9635,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.9635,0.7000),(0.6052,0.9635,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.9635,0.7000),(0.8277,0.9635,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.9635,0.7000),(0.5156,0.9635,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.9635,0.7000),(0.8835,0.9635,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.9635,0.7000),(0.4199,0.9635,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.9635,0.7000),(0.9290,0.9635,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.9635,0.7000),(0.3193,0.9635,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.9635,0.7000),(0.9635,0.9635,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.9635,0.7000),(0.2150,0.9635,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.9635,0.7000),(0.9868,0.9635,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.9635,0.7000),(0.1081,0.9635,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.9635,0.7000),(0.9985,0.9635,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.9635,0.7000),(0.0000,0.9635,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.4199,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.4199,0.7000),(0.7622,0.4199,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.4199,0.7000),(0.6052,0.4199,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.4199,0.7000),(0.8277,0.4199,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.4199,0.7000),(0.5156,0.4199,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.4199,0.7000),(0.8835,0.4199,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.4199,0.7000),(0.4199,0.4199,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.4199,0.7000),(0.9290,0.4199,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.4199,0.7000),(0.3193,0.4199,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.4199,0.7000),(0.9635,0.4199,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.4199,0.7000),(0.2150,0.4199,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.4199,0.7000),(0.9868,0.4199,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.4199,0.7000),(0.1081,0.4199,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.4199,0.7000),(0.9985,0.4199,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.4199,0.7000),(0.0000,0.4199,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.8277,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.8277,0.7000),(0.7622,0.8277,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.8277,0.7000),(0.6052,0.8277,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.8277,0.7000),(0.8277,0.8277,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.8277,0.7000),(0.5156,0.8277,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.8277,0.7000),(0.8835,0.8277,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.8277,0.7000),(0.4199,0.8277,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.8277,0.7000),(0.9290,0.8277,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.8277,0.7000),(0.3193,0.8277,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.8277,0.7000),(0.9635,0.8277,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.8277,0.7000),(0.2150,0.8277,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.8277,0.7000),(0.9868,0.8277,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.8277,0.7000),(0.1081,0.8277,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.8277,0.7000),(0.9985,0.8277,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.8277,0.7000),(0.0000,0.8277,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6877,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6877,0.7000),(0.7622,0.6877,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.6877,0.7000),(0.6052,0.6877,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.6877,0.7000),(0.8277,0.6877,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.6877,0.7000),(0.5156,0.6877,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.6877,0.7000),(0.8835,0.6877,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.6877,0.7000),(0.4199,0.6877,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.6877,0.7000),(0.9290,0.6877,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.6877,0.7000),(0.3193,0.6877,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.6877,0.7000),(0.9635,0.6877,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.6877,0.7000),(0.2150,0.6877,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.6877,0.7000),(0.9868,0.6877,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.6877,0.7000),(0.1081,0.6877,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.6877,0.7000),(0.9985,0.6877,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.6877,0.7000),(0.0000,0.6877,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.6052,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.6052,0.7000),(0.7622,0.6052,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.6052,0.7000),(0.6052,0.6052,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.6052,0.7000),(0.8277,0.6052,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.6052,0.7000),(0.5156,0.6052,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.6052,0.7000),(0.8835,0.6052,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.6052,0.7000),(0.4199,0.6052,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.6052,0.7000),(0.9290,0.6052,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.6052,0.7000),(0.3193,0.6052,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.6052,0.7000),(0.9635,0.6052,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.6052,0.7000),(0.2150,0.6052,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.6052,0.7000),(0.9868,0.6052,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.6052,0.7000),(0.1081,0.6052,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.6052,0.7000),(0.9985,0.6052,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.6052,0.7000),(0.0000,0.6052,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.8835,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.8835,0.7000),(0.7622,0.8835,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.8835,0.7000),(0.6052,0.8835,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.8835,0.7000),(0.8277,0.8835,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.8835,0.7000),(0.5156,0.8835,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.8835,0.7000),(0.8835,0.8835,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.8835,0.7000),(0.4199,0.8835,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.8835,0.7000),(0.9290,0.8835,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.8835,0.7000),(0.3193,0.8835,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.8835,0.7000),(0.9635,0.8835,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.8835,0.7000),(0.2150,0.8835,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.8835,0.7000),(0.9868,0.8835,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.8835,0.7000),(0.1081,0.8835,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.8835,0.7000),(0.9985,0.8835,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.8835,0.7000),(0.0000,0.8835,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.3193,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.3193,0.7000),(0.7622,0.3193,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.3193,0.7000),(0.6052,0.3193,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.3193,0.7000),(0.8277,0.3193,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.3193,0.7000),(0.5156,0.3193,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.3193,0.7000),(0.8835,0.3193,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.3193,0.7000),(0.4199,0.3193,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.3193,0.7000),(0.9290,0.3193,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.3193,0.7000),(0.3193,0.3193,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.3193,0.7000),(0.9635,0.3193,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.3193,0.7000),(0.2150,0.3193,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.3193,0.7000),(0.9868,0.3193,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.3193,0.7000),(0.1081,0.3193,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.3193,0.7000),(0.9985,0.3193,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.3193,0.7000),(0.0000,0.3193,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.9985,0.0000,0.7000),(0.0000,0.0000,0.7000),(0.9985,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.1081,0.0000,0.7000),(0.9985,0.0000,0.7000),(0.1081,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.9868,0.0000,0.7000),(0.1081,0.0000,0.7000),(0.9868,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.2150,0.0000,0.7000),(0.9868,0.0000,0.7000),(0.2150,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.9635,0.0000,0.7000),(0.2150,0.0000,0.7000),(0.9635,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.3193,0.0000,0.7000),(0.9635,0.0000,0.7000),(0.3193,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.9290,0.0000,0.7000),(0.3193,0.0000,0.7000),(0.9290,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.4199,0.0000,0.7000),(0.9290,0.0000,0.7000),(0.4199,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.8835,0.0000,0.7000),(0.4199,0.0000,0.7000),(0.8835,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.5156,0.0000,0.7000),(0.8835,0.0000,0.7000),(0.5156,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.8277,0.0000,0.7000),(0.5156,0.0000,0.7000),(0.8277,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.6052,0.0000,0.7000),(0.8277,0.0000,0.7000),(0.6052,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.7622,0.0000,0.7000),(0.6052,0.0000,0.7000),(0.7622,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.0000,0.7000),(0.7622,0.0000,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.9868,0.7000),(0.6877,0.0000,0.7000),(0.6877,0.0000,0.7000),(0.6877,0.9868,0.7000),(0.7622,0.9868,0.7000),(0.7622,0.0000,0.7000),(0.6877,0.0000,0.7000),(0.7622,0.9868,0.7000),(0.6052,0.9868,0.7000),(0.6052,0.0000,0.7000),(0.7622,0.0000,0.7000),(0.6052,0.9868,0.7000),(0.8277,0.9868,0.7000),(0.8277,0.0000,0.7000),(0.6052,0.0000,0.7000),(0.8277,0.9868,0.7000),(0.5156,0.9868,0.7000),(0.5156,0.0000,0.7000),(0.8277,0.0000,0.7000),(0.5156,0.9868,0.7000),(0.8835,0.9868,0.7000),(0.8835,0.0000,0.7000),(0.5156,0.0000,0.7000),(0.8835,0.9868,0.7000),(0.4199,0.9868,0.7000),(0.4199,0.0000,0.7000),(0.8835,0.0000,0.7000),(0.4199,0.9868,0.7000),(0.9290,0.9868,0.7000),(0.9290,0.0000,0.7000),(0.4199,0.0000,0.7000),(0.9290,0.9868,0.7000),(0.3193,0.9868,0.7000),(0.3193,0.0000,0.7000),(0.9290,0.0000,0.7000),(0.3193,0.9868,0.7000),(0.9635,0.9868,0.7000),(0.9635,0.0000,0.7000),(0.3193,0.0000,0.7000),(0.9635,0.9868,0.7000),(0.2150,0.9868,0.7000),(0.2150,0.0000,0.7000),(0.9635,0.0000,0.7000),(0.2150,0.9868,0.7000),(0.9868,0.9868,0.7000),(0.9868,0.0000,0.7000),(0.2150,0.0000,0.7000),(0.9868,0.9868,0.7000),(0.1081,0.9868,0.7000),(0.1081,0.0000,0.7000),(0.9868,0.0000,0.7000),(0.1081,0.9868,0.7000),(0.9985,0.9868,0.7000),(0.9985,0.0000,0.7000),(0.1081,0.0000,0.7000),(0.9985,0.9868,0.7000),(0.0000,0.9868,0.7000),(0.0000,0.0000,0.7000),(0.9985,0.0000,0.7000)])))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for QuadSetColor.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python QuadSetColor.py load and self-test diagnostics complete.")
