package Basic.CAD;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.CADGeometry.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Demonstrates QuadSet node of CADGeometry component, includes child nodes for normal vectors and color (per vertex). </p>
 <p> Related links: Catalog page <a href="../../../CAD/QuadSetColorIndex.html" target="_blank">QuadSetColor</a>,  source <a href="../../../CAD/QuadSetColor.java">QuadSetColor.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../CAD/QuadSetColor.x3d">QuadSetColor.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Demonstrates QuadSet node of CADGeometry component, includes child nodes for normal vectors and color (per vertex). </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Vincent Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 21 May 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/CAD/QuadSetColor.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/CAD/QuadSetColor.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Python script from <a href="http://kshell.com" target="_blank">http://kshell.com</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../CAD/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Vincent Marchetti
 */

public class QuadSetColor
{
	/** Default constructor to create this object. */
	public QuadSetColor ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_CADINTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("QuadSetColor.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Demonstrates QuadSet node of CADGeometry component, includes child nodes for normal vectors and color (per vertex)."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Vincent Marchetti"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("21 May 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/CAD/QuadSetColor.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Python script from http://kshell.com"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("QuadSetColor.x3d"))
    .addChild(new Viewpoint().setDescription("Front view").setFieldOfView(0.1).setOrientation(1.0,0.0,0.0,1.571).setPosition(0.0,-80.0,0.0))
    .addChild(new Shape()
      .setGeometry(new QuadSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(false)
        .setCoord(new Coordinate().setPoint(getCoordinate_5_13_point()))
        .setNormal(new Normal().setVector(getNormal_5_14_vector()))
        .setColor(new Color().setColor(getColor_5_15_color())))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getCoordinate_5_13_point_1()
		{
			double[] value = {-2.9351,0.9537,-2.3504,-2.8416,1.2041,-2.3504,-2.6989,1.1437,-2.1430,-2.7878,0.9058,-2.1430,-2.8416,1.2041,-2.3504,-2.7267,1.4456,-2.3504,-2.5898,1.3730,-2.1430,-2.6989,1.1437,-2.1430,-2.7267,1.4456,-2.3504,-2.5913,1.6762,-2.3504,-2.4613,1.5920,-2.1430,-2.5898,1.3730,-2.1430,-2.5913,1.6762,-2.3504,-2.4365,1.8942,-2.3504,-2.3142,1.7991,-2.1430,-2.4613,1.5920,-2.1430,-2.4365,1.8942,-2.3504,-2.2634,2.0980,-2.3504,-2.1498,1.9927,-2.1430,-2.3142,1.7991,-2.1430,-2.2634,2.0980,-2.3504,-2.0733,2.2860,-2.3504,-1.9693,2.1713,-2.1430,-2.1498,1.9927,-2.1430,-2.0733,2.2860,-2.3504,-1.8677,2.4569,-2.3504,-1.7739,2.3336,-2.1430,-1.9693,2.1713,-2.1430,-1.8677,2.4569,-2.3504,-1.6480,2.6093,-2.3504,-1.5653,2.4784,-2.1430,-1.7739,2.3336,-2.1430,-1.6480,2.6093,-2.3504,-1.4160,2.7422,-2.3504,-1.3449,2.6045,-2.1430,-1.5653,2.4784,-2.1430,-1.4160,2.7422,-2.3504,-1.1733,2.8544,-2.3504,-1.1144,2.7112,-2.1430,-1.3449,2.6045,-2.1430,-1.1733,2.8544,-2.3504,-0.9218,2.9453,-2.3504,-0.8756,2.7975,-2.1430,-1.1144,2.7112,-2.1430,-0.9218,2.9453,-2.3504,-0.6634,3.0140,-2.3504,-0.6301,2.8627,-2.1430,-0.8756,2.7975,-2.1430,-0.6634,3.0140,-2.3504,-0.4001,3.0601,-2.3504,-0.3800,2.9065,-2.1430,-0.6301,2.8627,-2.1430,-0.4001,3.0601,-2.3504,-0.1337,3.0833,-2.3504,-0.1270,2.9285,-2.1430,-0.3800,2.9065,-2.1430,-0.1337,3.0833,-2.3504,0.1337,3.0833,-2.3504,0.1270,2.9285,-2.1430,-0.1270,2.9285,-2.1430,0.1337,3.0833,-2.3504,0.4001,3.0601,-2.3504,0.3800,2.9065,-2.1430,0.1270,2.9285,-2.1430,0.4001,3.0601,-2.3504,0.6634,3.0140,-2.3504,0.6301,2.8627,-2.1430,0.3800,2.9065,-2.1430,0.6634,3.0140,-2.3504,0.9218,2.9453,-2.3504,0.8756,2.7975,-2.1430,0.6301,2.8627,-2.1430,0.9218,2.9453,-2.3504,1.1733,2.8544,-2.3504,1.1144,2.7112,-2.1430,0.8756,2.7975,-2.1430,1.1733,2.8544,-2.3504,1.4160,2.7422,-2.3504,1.3449,2.6045,-2.1430,1.1144,2.7112,-2.1430,1.4160,2.7422,-2.3504,1.6480,2.6093,-2.3504,1.5653,2.4784,-2.1430,1.3449,2.6045,-2.1430,1.6480,2.6093,-2.3504,1.8677,2.4569,-2.3504,1.7739,2.3336,-2.1430,1.5653,2.4784,-2.1430,1.8677,2.4569,-2.3504,2.0733,2.2860,-2.3504,1.9693,2.1713,-2.1430,1.7739,2.3336,-2.1430,2.0733,2.2860,-2.3504,2.2634,2.0980,-2.3504,2.1498,1.9927,-2.1430,1.9693,2.1713,-2.1430,2.2634,2.0980,-2.3504,2.4365,1.8942,-2.3504,2.3142,1.7991,-2.1430,2.1498,1.9927,-2.1430};
			return value;
		}
		private double[] getCoordinate_5_13_point_2()
		{
			double[] value = {2.4365,1.8942,-2.3504,2.5913,1.6762,-2.3504,2.4613,1.5920,-2.1430,2.3142,1.7991,-2.1430,2.5913,1.6762,-2.3504,2.7267,1.4456,-2.3504,2.5898,1.3730,-2.1430,2.4613,1.5920,-2.1430,2.7267,1.4456,-2.3504,2.8416,1.2041,-2.3504,2.6989,1.1437,-2.1430,2.5898,1.3730,-2.1430,2.8416,1.2041,-2.3504,2.9351,0.9537,-2.3504,2.7878,0.9058,-2.1430,2.6989,1.1437,-2.1430,-2.7878,0.9058,-2.1430,-2.6989,1.1437,-2.1430,-2.5692,1.0887,-1.9458,-2.6538,0.8623,-1.9458,-2.6989,1.1437,-2.1430,-2.5898,1.3730,-2.1430,-2.4653,1.3070,-1.9458,-2.5692,1.0887,-1.9458,-2.5898,1.3730,-2.1430,-2.4613,1.5920,-2.1430,-2.3429,1.5155,-1.9458,-2.4653,1.3070,-1.9458,-2.4613,1.5920,-2.1430,-2.3142,1.7991,-2.1430,-2.2029,1.7126,-1.9458,-2.3429,1.5155,-1.9458,-2.3142,1.7991,-2.1430,-2.1498,1.9927,-2.1430,-2.0464,1.8969,-1.9458,-2.2029,1.7126,-1.9458,-2.1498,1.9927,-2.1430,-1.9693,2.1713,-2.1430,-1.8746,2.0669,-1.9458,-2.0464,1.8969,-1.9458,-1.9693,2.1713,-2.1430,-1.7739,2.3336,-2.1430,-1.6886,2.2214,-1.9458,-1.8746,2.0669,-1.9458,-1.7739,2.3336,-2.1430,-1.5653,2.4784,-2.1430,-1.4900,2.3592,-1.9458,-1.6886,2.2214,-1.9458,-1.5653,2.4784,-2.1430,-1.3449,2.6045,-2.1430,-1.2802,2.4793,-1.9458,-1.4900,2.3592,-1.9458,-1.3449,2.6045,-2.1430,-1.1144,2.7112,-2.1430,-1.0608,2.5808,-1.9458,-1.2802,2.4793,-1.9458,-1.1144,2.7112,-2.1430,-0.8756,2.7975,-2.1430,-0.8335,2.6630,-1.9458,-1.0608,2.5808,-1.9458,-0.8756,2.7975,-2.1430,-0.6301,2.8627,-2.1430,-0.5998,2.7251,-1.9458,-0.8335,2.6630,-1.9458,-0.6301,2.8627,-2.1430,-0.3800,2.9065,-2.1430,-0.3617,2.7668,-1.9458,-0.5998,2.7251,-1.9458,-0.3800,2.9065,-2.1430,-0.1270,2.9285,-2.1430,-0.1209,2.7877,-1.9458,-0.3617,2.7668,-1.9458,-0.1270,2.9285,-2.1430,0.1270,2.9285,-2.1430,0.1209,2.7877,-1.9458,-0.1209,2.7877,-1.9458,0.1270,2.9285,-2.1430,0.3800,2.9065,-2.1430,0.3617,2.7668,-1.9458,0.1209,2.7877,-1.9458,0.3800,2.9065,-2.1430,0.6301,2.8627,-2.1430,0.5998,2.7251,-1.9458,0.3617,2.7668,-1.9458,0.6301,2.8627,-2.1430,0.8756,2.7975,-2.1430,0.8335,2.6630,-1.9458,0.5998,2.7251,-1.9458,0.8756,2.7975,-2.1430,1.1144,2.7112,-2.1430,1.0608,2.5808,-1.9458,0.8335,2.6630,-1.9458,1.1144,2.7112,-2.1430,1.3449,2.6045,-2.1430,1.2802,2.4793,-1.9458,1.0608,2.5808,-1.9458,1.3449,2.6045,-2.1430,1.5653,2.4784,-2.1430,1.4900,2.3592,-1.9458,1.2802,2.4793,-1.9458};
			return value;
		}
		private double[] getCoordinate_5_13_point_3()
		{
			double[] value = {1.5653,2.4784,-2.1430,1.7739,2.3336,-2.1430,1.6886,2.2214,-1.9458,1.4900,2.3592,-1.9458,1.7739,2.3336,-2.1430,1.9693,2.1713,-2.1430,1.8746,2.0669,-1.9458,1.6886,2.2214,-1.9458,1.9693,2.1713,-2.1430,2.1498,1.9927,-2.1430,2.0464,1.8969,-1.9458,1.8746,2.0669,-1.9458,2.1498,1.9927,-2.1430,2.3142,1.7991,-2.1430,2.2029,1.7126,-1.9458,2.0464,1.8969,-1.9458,2.3142,1.7991,-2.1430,2.4613,1.5920,-2.1430,2.3429,1.5155,-1.9458,2.2029,1.7126,-1.9458,2.4613,1.5920,-2.1430,2.5898,1.3730,-2.1430,2.4653,1.3070,-1.9458,2.3429,1.5155,-1.9458,2.5898,1.3730,-2.1430,2.6989,1.1437,-2.1430,2.5692,1.0887,-1.9458,2.4653,1.3070,-1.9458,2.6989,1.1437,-2.1430,2.7878,0.9058,-2.1430,2.6538,0.8623,-1.9458,2.5692,1.0887,-1.9458,-2.6538,0.8623,-1.9458,-2.5692,1.0887,-1.9458,-2.4516,1.0389,-1.7578,-2.5324,0.8228,-1.7578,-2.5692,1.0887,-1.9458,-2.4653,1.3070,-1.9458,-2.3525,1.2472,-1.7578,-2.4516,1.0389,-1.7578,-2.4653,1.3070,-1.9458,-2.3429,1.5155,-1.9458,-2.2357,1.4462,-1.7578,-2.3525,1.2472,-1.7578,-2.3429,1.5155,-1.9458,-2.2029,1.7126,-1.9458,-2.1022,1.6343,-1.7578,-2.2357,1.4462,-1.7578,-2.2029,1.7126,-1.9458,-2.0464,1.8969,-1.9458,-1.9528,1.8101,-1.7578,-2.1022,1.6343,-1.7578,-2.0464,1.8969,-1.9458,-1.8746,2.0669,-1.9458,-1.7888,1.9723,-1.7578,-1.9528,1.8101,-1.7578,-1.8746,2.0669,-1.9458,-1.6886,2.2214,-1.9458,-1.6114,2.1197,-1.7578,-1.7888,1.9723,-1.7578,-1.6886,2.2214,-1.9458,-1.4900,2.3592,-1.9458,-1.4219,2.2513,-1.7578,-1.6114,2.1197,-1.7578,-1.4900,2.3592,-1.9458,-1.2802,2.4793,-1.9458,-1.2217,2.3659,-1.7578,-1.4219,2.2513,-1.7578,-1.2802,2.4793,-1.9458,-1.0608,2.5808,-1.9458,-1.0123,2.4627,-1.7578,-1.2217,2.3659,-1.7578,-1.0608,2.5808,-1.9458,-0.8335,2.6630,-1.9458,-0.7953,2.5411,-1.7578,-1.0123,2.4627,-1.7578,-0.8335,2.6630,-1.9458,-0.5998,2.7251,-1.9458,-0.5724,2.6004,-1.7578,-0.7953,2.5411,-1.7578,-0.5998,2.7251,-1.9458,-0.3617,2.7668,-1.9458,-0.3452,2.6402,-1.7578,-0.5724,2.6004,-1.7578,-0.3617,2.7668,-1.9458,-0.1209,2.7877,-1.9458,-0.1153,2.6602,-1.7578,-0.3452,2.6402,-1.7578,-0.1209,2.7877,-1.9458,0.1209,2.7877,-1.9458,0.1153,2.6602,-1.7578,-0.1153,2.6602,-1.7578,0.1209,2.7877,-1.9458,0.3617,2.7668,-1.9458,0.3452,2.6402,-1.7578,0.1153,2.6602,-1.7578,0.3617,2.7668,-1.9458,0.5998,2.7251,-1.9458,0.5724,2.6004,-1.7578,0.3452,2.6402,-1.7578};
			return value;
		}
		private double[] getCoordinate_5_13_point_4()
		{
			double[] value = {0.5998,2.7251,-1.9458,0.8335,2.6630,-1.9458,0.7953,2.5411,-1.7578,0.5724,2.6004,-1.7578,0.8335,2.6630,-1.9458,1.0608,2.5808,-1.9458,1.0123,2.4627,-1.7578,0.7953,2.5411,-1.7578,1.0608,2.5808,-1.9458,1.2802,2.4793,-1.9458,1.2217,2.3659,-1.7578,1.0123,2.4627,-1.7578,1.2802,2.4793,-1.9458,1.4900,2.3592,-1.9458,1.4219,2.2513,-1.7578,1.2217,2.3659,-1.7578,1.4900,2.3592,-1.9458,1.6886,2.2214,-1.9458,1.6114,2.1197,-1.7578,1.4219,2.2513,-1.7578,1.6886,2.2214,-1.9458,1.8746,2.0669,-1.9458,1.7888,1.9723,-1.7578,1.6114,2.1197,-1.7578,1.8746,2.0669,-1.9458,2.0464,1.8969,-1.9458,1.9528,1.8101,-1.7578,1.7888,1.9723,-1.7578,2.0464,1.8969,-1.9458,2.2029,1.7126,-1.9458,2.1022,1.6343,-1.7578,1.9528,1.8101,-1.7578,2.2029,1.7126,-1.9458,2.3429,1.5155,-1.9458,2.2357,1.4462,-1.7578,2.1022,1.6343,-1.7578,2.3429,1.5155,-1.9458,2.4653,1.3070,-1.9458,2.3525,1.2472,-1.7578,2.2357,1.4462,-1.7578,2.4653,1.3070,-1.9458,2.5692,1.0887,-1.9458,2.4516,1.0389,-1.7578,2.3525,1.2472,-1.7578,2.5692,1.0887,-1.9458,2.6538,0.8623,-1.9458,2.5324,0.8228,-1.7578,2.4516,1.0389,-1.7578,-2.5324,0.8228,-1.7578,-2.4516,1.0389,-1.7578,-2.3458,0.9941,-1.5782,-2.4230,0.7873,-1.5782,-2.4516,1.0389,-1.7578,-2.3525,1.2472,-1.7578,-2.2509,1.1934,-1.5782,-2.3458,0.9941,-1.5782,-2.3525,1.2472,-1.7578,-2.2357,1.4462,-1.7578,-2.1392,1.3837,-1.5782,-2.2509,1.1934,-1.5782,-2.2357,1.4462,-1.7578,-2.1022,1.6343,-1.7578,-2.0114,1.5637,-1.5782,-2.1392,1.3837,-1.5782,-2.1022,1.6343,-1.7578,-1.9528,1.8101,-1.7578,-1.8685,1.7319,-1.5782,-2.0114,1.5637,-1.5782,-1.9528,1.8101,-1.7578,-1.7888,1.9723,-1.7578,-1.7116,1.8871,-1.5782,-1.8685,1.7319,-1.5782,-1.7888,1.9723,-1.7578,-1.6114,2.1197,-1.7578,-1.5418,2.0282,-1.5782,-1.7116,1.8871,-1.5782,-1.6114,2.1197,-1.7578,-1.4219,2.2513,-1.7578,-1.3605,2.1540,-1.5782,-1.5418,2.0282,-1.5782,-1.4219,2.2513,-1.7578,-1.2217,2.3659,-1.7578,-1.1689,2.2637,-1.5782,-1.3605,2.1540,-1.5782,-1.2217,2.3659,-1.7578,-1.0123,2.4627,-1.7578,-0.9686,2.3564,-1.5782,-1.1689,2.2637,-1.5782,-1.0123,2.4627,-1.7578,-0.7953,2.5411,-1.7578,-0.7610,2.4314,-1.5782,-0.9686,2.3564,-1.5782,-0.7953,2.5411,-1.7578,-0.5724,2.6004,-1.7578,-0.5477,2.4881,-1.5782,-0.7610,2.4314,-1.5782,-0.5724,2.6004,-1.7578,-0.3452,2.6402,-1.7578,-0.3303,2.5262,-1.5782,-0.5477,2.4881,-1.5782};
			return value;
		}
		private double[] getCoordinate_5_13_point_5()
		{
			double[] value = {-0.3452,2.6402,-1.7578,-0.1153,2.6602,-1.7578,-0.1104,2.5453,-1.5782,-0.3303,2.5262,-1.5782,-0.1153,2.6602,-1.7578,0.1153,2.6602,-1.7578,0.1104,2.5453,-1.5782,-0.1104,2.5453,-1.5782,0.1153,2.6602,-1.7578,0.3452,2.6402,-1.7578,0.3303,2.5262,-1.5782,0.1104,2.5453,-1.5782,0.3452,2.6402,-1.7578,0.5724,2.6004,-1.7578,0.5477,2.4881,-1.5782,0.3303,2.5262,-1.5782,0.5724,2.6004,-1.7578,0.7953,2.5411,-1.7578,0.7610,2.4314,-1.5782,0.5477,2.4881,-1.5782,0.7953,2.5411,-1.7578,1.0123,2.4627,-1.7578,0.9686,2.3564,-1.5782,0.7610,2.4314,-1.5782,1.0123,2.4627,-1.7578,1.2217,2.3659,-1.7578,1.1689,2.2637,-1.5782,0.9686,2.3564,-1.5782,1.2217,2.3659,-1.7578,1.4219,2.2513,-1.7578,1.3605,2.1540,-1.5782,1.1689,2.2637,-1.5782,1.4219,2.2513,-1.7578,1.6114,2.1197,-1.7578,1.5418,2.0282,-1.5782,1.3605,2.1540,-1.5782,1.6114,2.1197,-1.7578,1.7888,1.9723,-1.7578,1.7116,1.8871,-1.5782,1.5418,2.0282,-1.5782,1.7888,1.9723,-1.7578,1.9528,1.8101,-1.7578,1.8685,1.7319,-1.5782,1.7116,1.8871,-1.5782,1.9528,1.8101,-1.7578,2.1022,1.6343,-1.7578,2.0114,1.5637,-1.5782,1.8685,1.7319,-1.5782,2.1022,1.6343,-1.7578,2.2357,1.4462,-1.7578,2.1392,1.3837,-1.5782,2.0114,1.5637,-1.5782,2.2357,1.4462,-1.7578,2.3525,1.2472,-1.7578,2.2509,1.1934,-1.5782,2.1392,1.3837,-1.5782,2.3525,1.2472,-1.7578,2.4516,1.0389,-1.7578,2.3458,0.9941,-1.5782,2.2509,1.1934,-1.5782,2.4516,1.0389,-1.7578,2.5324,0.8228,-1.7578,2.4230,0.7873,-1.5782,2.3458,0.9941,-1.5782,-2.4230,0.7873,-1.5782,-2.3458,0.9941,-1.5782,-2.2510,0.9539,-1.4061,-2.3252,0.7555,-1.4061,-2.3458,0.9941,-1.5782,-2.2509,1.1934,-1.5782,-2.1600,1.1452,-1.4061,-2.2510,0.9539,-1.4061,-2.2509,1.1934,-1.5782,-2.1392,1.3837,-1.5782,-2.0528,1.3278,-1.4061,-2.1600,1.1452,-1.4061,-2.1392,1.3837,-1.5782,-2.0114,1.5637,-1.5782,-1.9302,1.5005,-1.4061,-2.0528,1.3278,-1.4061,-2.0114,1.5637,-1.5782,-1.8685,1.7319,-1.5782,-1.7930,1.6620,-1.4061,-1.9302,1.5005,-1.4061,-1.8685,1.7319,-1.5782,-1.7116,1.8871,-1.5782,-1.6425,1.8109,-1.4061,-1.7930,1.6620,-1.4061,-1.7116,1.8871,-1.5782,-1.5418,2.0282,-1.5782,-1.4795,1.9463,-1.4061,-1.6425,1.8109,-1.4061,-1.5418,2.0282,-1.5782,-1.3605,2.1540,-1.5782,-1.3055,2.0671,-1.4061,-1.4795,1.9463,-1.4061,-1.3605,2.1540,-1.5782,-1.1689,2.2637,-1.5782,-1.1217,2.1723,-1.4061,-1.3055,2.0671,-1.4061};
			return value;
		}
		private double[] getCoordinate_5_13_point_6()
		{
			double[] value = {-1.1689,2.2637,-1.5782,-0.9686,2.3564,-1.5782,-0.9295,2.2613,-1.4061,-1.1217,2.1723,-1.4061,-0.9686,2.3564,-1.5782,-0.7610,2.4314,-1.5782,-0.7303,2.3332,-1.4061,-0.9295,2.2613,-1.4061,-0.7610,2.4314,-1.5782,-0.5477,2.4881,-1.5782,-0.5256,2.3877,-1.4061,-0.7303,2.3332,-1.4061,-0.5477,2.4881,-1.5782,-0.3303,2.5262,-1.5782,-0.3169,2.4242,-1.4061,-0.5256,2.3877,-1.4061,-0.3303,2.5262,-1.5782,-0.1104,2.5453,-1.5782,-0.1059,2.4425,-1.4061,-0.3169,2.4242,-1.4061,-0.1104,2.5453,-1.5782,0.1104,2.5453,-1.5782,0.1059,2.4425,-1.4061,-0.1059,2.4425,-1.4061,0.1104,2.5453,-1.5782,0.3303,2.5262,-1.5782,0.3169,2.4242,-1.4061,0.1059,2.4425,-1.4061,0.3303,2.5262,-1.5782,0.5477,2.4881,-1.5782,0.5256,2.3877,-1.4061,0.3169,2.4242,-1.4061,0.5477,2.4881,-1.5782,0.7610,2.4314,-1.5782,0.7303,2.3332,-1.4061,0.5256,2.3877,-1.4061,0.7610,2.4314,-1.5782,0.9686,2.3564,-1.5782,0.9295,2.2613,-1.4061,0.7303,2.3332,-1.4061,0.9686,2.3564,-1.5782,1.1689,2.2637,-1.5782,1.1217,2.1723,-1.4061,0.9295,2.2613,-1.4061,1.1689,2.2637,-1.5782,1.3605,2.1540,-1.5782,1.3055,2.0671,-1.4061,1.1217,2.1723,-1.4061,1.3605,2.1540,-1.5782,1.5418,2.0282,-1.5782,1.4795,1.9463,-1.4061,1.3055,2.0671,-1.4061,1.5418,2.0282,-1.5782,1.7116,1.8871,-1.5782,1.6425,1.8109,-1.4061,1.4795,1.9463,-1.4061,1.7116,1.8871,-1.5782,1.8685,1.7319,-1.5782,1.7930,1.6620,-1.4061,1.6425,1.8109,-1.4061,1.8685,1.7319,-1.5782,2.0114,1.5637,-1.5782,1.9302,1.5005,-1.4061,1.7930,1.6620,-1.4061,2.0114,1.5637,-1.5782,2.1392,1.3837,-1.5782,2.0528,1.3278,-1.4061,1.9302,1.5005,-1.4061,2.1392,1.3837,-1.5782,2.2509,1.1934,-1.5782,2.1600,1.1452,-1.4061,2.0528,1.3278,-1.4061,2.2509,1.1934,-1.5782,2.3458,0.9941,-1.5782,2.2510,0.9539,-1.4061,2.1600,1.1452,-1.4061,2.3458,0.9941,-1.5782,2.4230,0.7873,-1.5782,2.3252,0.7555,-1.4061,2.2510,0.9539,-1.4061,-2.3252,0.7555,-1.4061,-2.2510,0.9539,-1.4061,-2.1670,0.9183,-1.2407,-2.2384,0.7273,-1.2407,-2.2510,0.9539,-1.4061,-2.1600,1.1452,-1.4061,-2.0794,1.1024,-1.2407,-2.1670,0.9183,-1.2407,-2.1600,1.1452,-1.4061,-2.0528,1.3278,-1.4061,-1.9762,1.2783,-1.2407,-2.0794,1.1024,-1.2407,-2.0528,1.3278,-1.4061,-1.9302,1.5005,-1.4061,-1.8581,1.4445,-1.2407,-1.9762,1.2783,-1.2407,-1.9302,1.5005,-1.4061,-1.7930,1.6620,-1.4061,-1.7261,1.6000,-1.2407,-1.8581,1.4445,-1.2407};
			return value;
		}
		private double[] getCoordinate_5_13_point_7()
		{
			double[] value = {-1.7930,1.6620,-1.4061,-1.6425,1.8109,-1.4061,-1.5812,1.7434,-1.2407,-1.7261,1.6000,-1.2407,-1.6425,1.8109,-1.4061,-1.4795,1.9463,-1.4061,-1.4243,1.8737,-1.2407,-1.5812,1.7434,-1.2407,-1.4795,1.9463,-1.4061,-1.3055,2.0671,-1.4061,-1.2568,1.9899,-1.2407,-1.4243,1.8737,-1.2407,-1.3055,2.0671,-1.4061,-1.1217,2.1723,-1.4061,-1.0799,2.0912,-1.2407,-1.2568,1.9899,-1.2407,-1.1217,2.1723,-1.4061,-0.9295,2.2613,-1.4061,-0.8948,2.1769,-1.2407,-1.0799,2.0912,-1.2407,-0.9295,2.2613,-1.4061,-0.7303,2.3332,-1.4061,-0.7030,2.2461,-1.2407,-0.8948,2.1769,-1.2407,-0.7303,2.3332,-1.4061,-0.5256,2.3877,-1.4061,-0.5060,2.2986,-1.2407,-0.7030,2.2461,-1.2407,-0.5256,2.3877,-1.4061,-0.3169,2.4242,-1.4061,-0.3051,2.3337,-1.2407,-0.5060,2.2986,-1.2407,-0.3169,2.4242,-1.4061,-0.1059,2.4425,-1.4061,-0.1020,2.3514,-1.2407,-0.3051,2.3337,-1.2407,-0.1059,2.4425,-1.4061,0.1059,2.4425,-1.4061,0.1020,2.3514,-1.2407,-0.1020,2.3514,-1.2407,0.1059,2.4425,-1.4061,0.3169,2.4242,-1.4061,0.3051,2.3337,-1.2407,0.1020,2.3514,-1.2407,0.3169,2.4242,-1.4061,0.5256,2.3877,-1.4061,0.5060,2.2986,-1.2407,0.3051,2.3337,-1.2407,0.5256,2.3877,-1.4061,0.7303,2.3332,-1.4061,0.7030,2.2461,-1.2407,0.5060,2.2986,-1.2407,0.7303,2.3332,-1.4061,0.9295,2.2613,-1.4061,0.8948,2.1769,-1.2407,0.7030,2.2461,-1.2407,0.9295,2.2613,-1.4061,1.1217,2.1723,-1.4061,1.0799,2.0912,-1.2407,0.8948,2.1769,-1.2407,1.1217,2.1723,-1.4061,1.3055,2.0671,-1.4061,1.2568,1.9899,-1.2407,1.0799,2.0912,-1.2407,1.3055,2.0671,-1.4061,1.4795,1.9463,-1.4061,1.4243,1.8737,-1.2407,1.2568,1.9899,-1.2407,1.4795,1.9463,-1.4061,1.6425,1.8109,-1.4061,1.5812,1.7434,-1.2407,1.4243,1.8737,-1.2407,1.6425,1.8109,-1.4061,1.7930,1.6620,-1.4061,1.7261,1.6000,-1.2407,1.5812,1.7434,-1.2407,1.7930,1.6620,-1.4061,1.9302,1.5005,-1.4061,1.8581,1.4445,-1.2407,1.7261,1.6000,-1.2407,1.9302,1.5005,-1.4061,2.0528,1.3278,-1.4061,1.9762,1.2783,-1.2407,1.8581,1.4445,-1.2407,2.0528,1.3278,-1.4061,2.1600,1.1452,-1.4061,2.0794,1.1024,-1.2407,1.9762,1.2783,-1.2407,2.1600,1.1452,-1.4061,2.2510,0.9539,-1.4061,2.1670,0.9183,-1.2407,2.0794,1.1024,-1.2407,2.2510,0.9539,-1.4061,2.3252,0.7555,-1.4061,2.2384,0.7273,-1.2407,2.1670,0.9183,-1.2407,-2.2384,0.7273,-1.2407,-2.1670,0.9183,-1.2407,-2.0934,0.8871,-1.0812,-2.1623,0.7026,-1.0812};
			return value;
		}
		private double[] getCoordinate_5_13_point_8()
		{
			double[] value = {-2.1670,0.9183,-1.2407,-2.0794,1.1024,-1.2407,-2.0087,1.0650,-1.0812,-2.0934,0.8871,-1.0812,-2.0794,1.1024,-1.2407,-1.9762,1.2783,-1.2407,-1.9090,1.2348,-1.0812,-2.0087,1.0650,-1.0812,-1.9762,1.2783,-1.2407,-1.8581,1.4445,-1.2407,-1.7950,1.3954,-1.0812,-1.9090,1.2348,-1.0812,-1.8581,1.4445,-1.2407,-1.7261,1.6000,-1.2407,-1.6674,1.5456,-1.0812,-1.7950,1.3954,-1.0812,-1.7261,1.6000,-1.2407,-1.5812,1.7434,-1.2407,-1.5274,1.6841,-1.0812,-1.6674,1.5456,-1.0812,-1.5812,1.7434,-1.2407,-1.4243,1.8737,-1.2407,-1.3759,1.8100,-1.0812,-1.5274,1.6841,-1.0812,-1.4243,1.8737,-1.2407,-1.2568,1.9899,-1.2407,-1.2141,1.9223,-1.0812,-1.3759,1.8100,-1.0812,-1.2568,1.9899,-1.2407,-1.0799,2.0912,-1.2407,-1.0431,2.0201,-1.0812,-1.2141,1.9223,-1.0812,-1.0799,2.0912,-1.2407,-0.8948,2.1769,-1.2407,-0.8644,2.1028,-1.0812,-1.0431,2.0201,-1.0812,-0.8948,2.1769,-1.2407,-0.7030,2.2461,-1.2407,-0.6791,2.1698,-1.0812,-0.8644,2.1028,-1.0812,-0.7030,2.2461,-1.2407,-0.5060,2.2986,-1.2407,-0.4887,2.2204,-1.0812,-0.6791,2.1698,-1.0812,-0.5060,2.2986,-1.2407,-0.3051,2.3337,-1.2407,-0.2947,2.2544,-1.0812,-0.4887,2.2204,-1.0812,-0.3051,2.3337,-1.2407,-0.1020,2.3514,-1.2407,-0.0985,2.2714,-1.0812,-0.2947,2.2544,-1.0812,-0.1020,2.3514,-1.2407,0.1020,2.3514,-1.2407,0.0985,2.2714,-1.0812,-0.0985,2.2714,-1.0812,0.1020,2.3514,-1.2407,0.3051,2.3337,-1.2407,0.2947,2.2544,-1.0812,0.0985,2.2714,-1.0812,0.3051,2.3337,-1.2407,0.5060,2.2986,-1.2407,0.4887,2.2204,-1.0812,0.2947,2.2544,-1.0812,0.5060,2.2986,-1.2407,0.7030,2.2461,-1.2407,0.6791,2.1698,-1.0812,0.4887,2.2204,-1.0812,0.7030,2.2461,-1.2407,0.8948,2.1769,-1.2407,0.8644,2.1028,-1.0812,0.6791,2.1698,-1.0812,0.8948,2.1769,-1.2407,1.0799,2.0912,-1.2407,1.0431,2.0201,-1.0812,0.8644,2.1028,-1.0812,1.0799,2.0912,-1.2407,1.2568,1.9899,-1.2407,1.2141,1.9223,-1.0812,1.0431,2.0201,-1.0812,1.2568,1.9899,-1.2407,1.4243,1.8737,-1.2407,1.3759,1.8100,-1.0812,1.2141,1.9223,-1.0812,1.4243,1.8737,-1.2407,1.5812,1.7434,-1.2407,1.5274,1.6841,-1.0812,1.3759,1.8100,-1.0812,1.5812,1.7434,-1.2407,1.7261,1.6000,-1.2407,1.6674,1.5456,-1.0812,1.5274,1.6841,-1.0812,1.7261,1.6000,-1.2407,1.8581,1.4445,-1.2407,1.7950,1.3954,-1.0812,1.6674,1.5456,-1.0812,1.8581,1.4445,-1.2407,1.9762,1.2783,-1.2407,1.9090,1.2348,-1.0812,1.7950,1.3954,-1.0812};
			return value;
		}
		private double[] getCoordinate_5_13_point_9()
		{
			double[] value = {1.9762,1.2783,-1.2407,2.0794,1.1024,-1.2407,2.0087,1.0650,-1.0812,1.9090,1.2348,-1.0812,2.0794,1.1024,-1.2407,2.1670,0.9183,-1.2407,2.0934,0.8871,-1.0812,2.0087,1.0650,-1.0812,2.1670,0.9183,-1.2407,2.2384,0.7273,-1.2407,2.1623,0.7026,-1.0812,2.0934,0.8871,-1.0812,-2.1623,0.7026,-1.0812,-2.0934,0.8871,-1.0812,-2.0296,0.8601,-0.9269,-2.0965,0.6812,-0.9269,-2.0934,0.8871,-1.0812,-2.0087,1.0650,-1.0812,-1.9476,1.0325,-0.9269,-2.0296,0.8601,-0.9269,-2.0087,1.0650,-1.0812,-1.9090,1.2348,-1.0812,-1.8509,1.1972,-0.9269,-1.9476,1.0325,-0.9269,-1.9090,1.2348,-1.0812,-1.7950,1.3954,-1.0812,-1.7403,1.3529,-0.9269,-1.8509,1.1972,-0.9269,-1.7950,1.3954,-1.0812,-1.6674,1.5456,-1.0812,-1.6167,1.4985,-0.9269,-1.7403,1.3529,-0.9269,-1.6674,1.5456,-1.0812,-1.5274,1.6841,-1.0812,-1.4809,1.6328,-0.9269,-1.6167,1.4985,-0.9269,-1.5274,1.6841,-1.0812,-1.3759,1.8100,-1.0812,-1.3340,1.7549,-0.9269,-1.4809,1.6328,-0.9269,-1.3759,1.8100,-1.0812,-1.2141,1.9223,-1.0812,-1.1771,1.8637,-0.9269,-1.3340,1.7549,-0.9269,-1.2141,1.9223,-1.0812,-1.0431,2.0201,-1.0812,-1.0114,1.9586,-0.9269,-1.1771,1.8637,-0.9269,-1.0431,2.0201,-1.0812,-0.8644,2.1028,-1.0812,-0.8380,2.0388,-0.9269,-1.0114,1.9586,-0.9269,-0.8644,2.1028,-1.0812,-0.6791,2.1698,-1.0812,-0.6584,2.1037,-0.9269,-0.8380,2.0388,-0.9269,-0.6791,2.1698,-1.0812,-0.4887,2.2204,-1.0812,-0.4739,2.1528,-0.9269,-0.6584,2.1037,-0.9269,-0.4887,2.2204,-1.0812,-0.2947,2.2544,-1.0812,-0.2858,2.1857,-0.9269,-0.4739,2.1528,-0.9269,-0.2947,2.2544,-1.0812,-0.0985,2.2714,-1.0812,-0.0955,2.2023,-0.9269,-0.2858,2.1857,-0.9269,-0.0985,2.2714,-1.0812,0.0985,2.2714,-1.0812,0.0955,2.2023,-0.9269,-0.0955,2.2023,-0.9269,0.0985,2.2714,-1.0812,0.2947,2.2544,-1.0812,0.2858,2.1857,-0.9269,0.0955,2.2023,-0.9269,0.2947,2.2544,-1.0812,0.4887,2.2204,-1.0812,0.4739,2.1528,-0.9269,0.2858,2.1857,-0.9269,0.4887,2.2204,-1.0812,0.6791,2.1698,-1.0812,0.6584,2.1037,-0.9269,0.4739,2.1528,-0.9269,0.6791,2.1698,-1.0812,0.8644,2.1028,-1.0812,0.8380,2.0388,-0.9269,0.6584,2.1037,-0.9269,0.8644,2.1028,-1.0812,1.0431,2.0201,-1.0812,1.0114,1.9586,-0.9269,0.8380,2.0388,-0.9269,1.0431,2.0201,-1.0812,1.2141,1.9223,-1.0812,1.1771,1.8637,-0.9269,1.0114,1.9586,-0.9269,1.2141,1.9223,-1.0812,1.3759,1.8100,-1.0812,1.3340,1.7549,-0.9269,1.1771,1.8637,-0.9269};
			return value;
		}
		private double[] getCoordinate_5_13_point_10()
		{
			double[] value = {1.3759,1.8100,-1.0812,1.5274,1.6841,-1.0812,1.4809,1.6328,-0.9269,1.3340,1.7549,-0.9269,1.5274,1.6841,-1.0812,1.6674,1.5456,-1.0812,1.6167,1.4985,-0.9269,1.4809,1.6328,-0.9269,1.6674,1.5456,-1.0812,1.7950,1.3954,-1.0812,1.7403,1.3529,-0.9269,1.6167,1.4985,-0.9269,1.7950,1.3954,-1.0812,1.9090,1.2348,-1.0812,1.8509,1.1972,-0.9269,1.7403,1.3529,-0.9269,1.9090,1.2348,-1.0812,2.0087,1.0650,-1.0812,1.9476,1.0325,-0.9269,1.8509,1.1972,-0.9269,2.0087,1.0650,-1.0812,2.0934,0.8871,-1.0812,2.0296,0.8601,-0.9269,1.9476,1.0325,-0.9269,2.0934,0.8871,-1.0812,2.1623,0.7026,-1.0812,2.0965,0.6812,-0.9269,2.0296,0.8601,-0.9269,-2.0965,0.6812,-0.9269,-2.0296,0.8601,-0.9269,-1.9755,0.8372,-0.7769,-2.0406,0.6630,-0.7769,-2.0296,0.8601,-0.9269,-1.9476,1.0325,-0.9269,-1.8957,1.0050,-0.7769,-1.9755,0.8372,-0.7769,-1.9476,1.0325,-0.9269,-1.8509,1.1972,-0.9269,-1.8016,1.1653,-0.7769,-1.8957,1.0050,-0.7769,-1.8509,1.1972,-0.9269,-1.7403,1.3529,-0.9269,-1.6939,1.3169,-0.7769,-1.8016,1.1653,-0.7769,-1.7403,1.3529,-0.9269,-1.6167,1.4985,-0.9269,-1.5736,1.4586,-0.7769,-1.6939,1.3169,-0.7769,-1.6167,1.4985,-0.9269,-1.4809,1.6328,-0.9269,-1.4414,1.5893,-0.7769,-1.5736,1.4586,-0.7769,-1.4809,1.6328,-0.9269,-1.3340,1.7549,-0.9269,-1.2985,1.7081,-0.7769,-1.4414,1.5893,-0.7769,-1.3340,1.7549,-0.9269,-1.1771,1.8637,-0.9269,-1.1457,1.8141,-0.7769,-1.2985,1.7081,-0.7769,-1.1771,1.8637,-0.9269,-1.0114,1.9586,-0.9269,-0.9844,1.9064,-0.7769,-1.1457,1.8141,-0.7769,-1.0114,1.9586,-0.9269,-0.8380,2.0388,-0.9269,-0.8157,1.9845,-0.7769,-0.9844,1.9064,-0.7769,-0.8380,2.0388,-0.9269,-0.6584,2.1037,-0.9269,-0.6409,2.0477,-0.7769,-0.8157,1.9845,-0.7769,-0.6584,2.1037,-0.9269,-0.4739,2.1528,-0.9269,-0.4612,2.0954,-0.7769,-0.6409,2.0477,-0.7769,-0.4739,2.1528,-0.9269,-0.2858,2.1857,-0.9269,-0.2781,2.1275,-0.7769,-0.4612,2.0954,-0.7769,-0.2858,2.1857,-0.9269,-0.0955,2.2023,-0.9269,-0.0929,2.1436,-0.7769,-0.2781,2.1275,-0.7769,-0.0955,2.2023,-0.9269,0.0955,2.2023,-0.9269,0.0929,2.1436,-0.7769,-0.0929,2.1436,-0.7769,0.0955,2.2023,-0.9269,0.2858,2.1857,-0.9269,0.2781,2.1275,-0.7769,0.0929,2.1436,-0.7769,0.2858,2.1857,-0.9269,0.4739,2.1528,-0.9269,0.4612,2.0954,-0.7769,0.2781,2.1275,-0.7769,0.4739,2.1528,-0.9269,0.6584,2.1037,-0.9269,0.6409,2.0477,-0.7769,0.4612,2.0954,-0.7769};
			return value;
		}
		private double[] getCoordinate_5_13_point_11()
		{
			double[] value = {0.6584,2.1037,-0.9269,0.8380,2.0388,-0.9269,0.8157,1.9845,-0.7769,0.6409,2.0477,-0.7769,0.8380,2.0388,-0.9269,1.0114,1.9586,-0.9269,0.9844,1.9064,-0.7769,0.8157,1.9845,-0.7769,1.0114,1.9586,-0.9269,1.1771,1.8637,-0.9269,1.1457,1.8141,-0.7769,0.9844,1.9064,-0.7769,1.1771,1.8637,-0.9269,1.3340,1.7549,-0.9269,1.2985,1.7081,-0.7769,1.1457,1.8141,-0.7769,1.3340,1.7549,-0.9269,1.4809,1.6328,-0.9269,1.4414,1.5893,-0.7769,1.2985,1.7081,-0.7769,1.4809,1.6328,-0.9269,1.6167,1.4985,-0.9269,1.5736,1.4586,-0.7769,1.4414,1.5893,-0.7769,1.6167,1.4985,-0.9269,1.7403,1.3529,-0.9269,1.6939,1.3169,-0.7769,1.5736,1.4586,-0.7769,1.7403,1.3529,-0.9269,1.8509,1.1972,-0.9269,1.8016,1.1653,-0.7769,1.6939,1.3169,-0.7769,1.8509,1.1972,-0.9269,1.9476,1.0325,-0.9269,1.8957,1.0050,-0.7769,1.8016,1.1653,-0.7769,1.9476,1.0325,-0.9269,2.0296,0.8601,-0.9269,1.9755,0.8372,-0.7769,1.8957,1.0050,-0.7769,2.0296,0.8601,-0.9269,2.0965,0.6812,-0.9269,2.0406,0.6630,-0.7769,1.9755,0.8372,-0.7769,-2.0406,0.6630,-0.7769,-1.9755,0.8372,-0.7769,-1.9309,0.8182,-0.6307,-1.9945,0.6480,-0.6307,-1.9755,0.8372,-0.7769,-1.8957,1.0050,-0.7769,-1.8528,0.9823,-0.6307,-1.9309,0.8182,-0.6307,-1.8957,1.0050,-0.7769,-1.8016,1.1653,-0.7769,-1.7608,1.1390,-0.6307,-1.8528,0.9823,-0.6307,-1.8016,1.1653,-0.7769,-1.6939,1.3169,-0.7769,-1.6556,1.2871,-0.6307,-1.7608,1.1390,-0.6307,-1.6939,1.3169,-0.7769,-1.5736,1.4586,-0.7769,-1.5380,1.4256,-0.6307,-1.6556,1.2871,-0.6307,-1.5736,1.4586,-0.7769,-1.4414,1.5893,-0.7769,-1.4088,1.5534,-0.6307,-1.5380,1.4256,-0.6307,-1.4414,1.5893,-0.7769,-1.2985,1.7081,-0.7769,-1.2691,1.6695,-0.6307,-1.4088,1.5534,-0.6307,-1.2985,1.7081,-0.7769,-1.1457,1.8141,-0.7769,-1.1198,1.7731,-0.6307,-1.2691,1.6695,-0.6307,-1.1457,1.8141,-0.7769,-0.9844,1.9064,-0.7769,-0.9622,1.8633,-0.6307,-1.1198,1.7731,-0.6307,-0.9844,1.9064,-0.7769,-0.8157,1.9845,-0.7769,-0.7973,1.9396,-0.6307,-0.9622,1.8633,-0.6307,-0.8157,1.9845,-0.7769,-0.6409,2.0477,-0.7769,-0.6264,2.0014,-0.6307,-0.7973,1.9396,-0.6307,-0.6409,2.0477,-0.7769,-0.4612,2.0954,-0.7769,-0.4508,2.0481,-0.6307,-0.6264,2.0014,-0.6307,-0.4612,2.0954,-0.7769,-0.2781,2.1275,-0.7769,-0.2718,2.0794,-0.6307,-0.4508,2.0481,-0.6307,-0.2781,2.1275,-0.7769,-0.0929,2.1436,-0.7769,-0.0908,2.0951,-0.6307,-0.2718,2.0794,-0.6307};
			return value;
		}
		private double[] getCoordinate_5_13_point_12()
		{
			double[] value = {-0.0929,2.1436,-0.7769,0.0929,2.1436,-0.7769,0.0908,2.0951,-0.6307,-0.0908,2.0951,-0.6307,0.0929,2.1436,-0.7769,0.2781,2.1275,-0.7769,0.2718,2.0794,-0.6307,0.0908,2.0951,-0.6307,0.2781,2.1275,-0.7769,0.4612,2.0954,-0.7769,0.4508,2.0481,-0.6307,0.2718,2.0794,-0.6307,0.4612,2.0954,-0.7769,0.6409,2.0477,-0.7769,0.6264,2.0014,-0.6307,0.4508,2.0481,-0.6307,0.6409,2.0477,-0.7769,0.8157,1.9845,-0.7769,0.7973,1.9396,-0.6307,0.6264,2.0014,-0.6307,0.8157,1.9845,-0.7769,0.9844,1.9064,-0.7769,0.9622,1.8633,-0.6307,0.7973,1.9396,-0.6307,0.9844,1.9064,-0.7769,1.1457,1.8141,-0.7769,1.1198,1.7731,-0.6307,0.9622,1.8633,-0.6307,1.1457,1.8141,-0.7769,1.2985,1.7081,-0.7769,1.2691,1.6695,-0.6307,1.1198,1.7731,-0.6307,1.2985,1.7081,-0.7769,1.4414,1.5893,-0.7769,1.4088,1.5534,-0.6307,1.2691,1.6695,-0.6307,1.4414,1.5893,-0.7769,1.5736,1.4586,-0.7769,1.5380,1.4256,-0.6307,1.4088,1.5534,-0.6307,1.5736,1.4586,-0.7769,1.6939,1.3169,-0.7769,1.6556,1.2871,-0.6307,1.5380,1.4256,-0.6307,1.6939,1.3169,-0.7769,1.8016,1.1653,-0.7769,1.7608,1.1390,-0.6307,1.6556,1.2871,-0.6307,1.8016,1.1653,-0.7769,1.8957,1.0050,-0.7769,1.8528,0.9823,-0.6307,1.7608,1.1390,-0.6307,1.8957,1.0050,-0.7769,1.9755,0.8372,-0.7769,1.9309,0.8182,-0.6307,1.8528,0.9823,-0.6307,1.9755,0.8372,-0.7769,2.0406,0.6630,-0.7769,1.9945,0.6480,-0.6307,1.9309,0.8182,-0.6307,-1.9945,0.6480,-0.6307,-1.9309,0.8182,-0.6307,-1.8954,0.8032,-0.4875,-1.9578,0.6361,-0.4875,-1.9309,0.8182,-0.6307,-1.8528,0.9823,-0.6307,-1.8188,0.9642,-0.4875,-1.8954,0.8032,-0.4875,-1.8528,0.9823,-0.6307,-1.7608,1.1390,-0.6307,-1.7285,1.1180,-0.4875,-1.8188,0.9642,-0.4875,-1.7608,1.1390,-0.6307,-1.6556,1.2871,-0.6307,-1.6252,1.2635,-0.4875,-1.7285,1.1180,-0.4875,-1.6556,1.2871,-0.6307,-1.5380,1.4256,-0.6307,-1.5097,1.3994,-0.4875,-1.6252,1.2635,-0.4875,-1.5380,1.4256,-0.6307,-1.4088,1.5534,-0.6307,-1.3830,1.5248,-0.4875,-1.5097,1.3994,-0.4875,-1.4088,1.5534,-0.6307,-1.2691,1.6695,-0.6307,-1.2458,1.6388,-0.4875,-1.3830,1.5248,-0.4875,-1.2691,1.6695,-0.6307,-1.1198,1.7731,-0.6307,-1.0993,1.7405,-0.4875,-1.2458,1.6388,-0.4875,-1.1198,1.7731,-0.6307,-0.9622,1.8633,-0.6307,-0.9445,1.8291,-0.4875,-1.0993,1.7405,-0.4875,-0.9622,1.8633,-0.6307,-0.7973,1.9396,-0.6307,-0.7826,1.9040,-0.4875,-0.9445,1.8291,-0.4875};
			return value;
		}
		private double[] getCoordinate_5_13_point_13()
		{
			double[] value = {-0.7973,1.9396,-0.6307,-0.6264,2.0014,-0.6307,-0.6149,1.9646,-0.4875,-0.7826,1.9040,-0.4875,-0.6264,2.0014,-0.6307,-0.4508,2.0481,-0.6307,-0.4425,2.0104,-0.4875,-0.6149,1.9646,-0.4875,-0.4508,2.0481,-0.6307,-0.2718,2.0794,-0.6307,-0.2669,2.0412,-0.4875,-0.4425,2.0104,-0.4875,-0.2718,2.0794,-0.6307,-0.0908,2.0951,-0.6307,-0.0892,2.0566,-0.4875,-0.2669,2.0412,-0.4875,-0.0908,2.0951,-0.6307,0.0908,2.0951,-0.6307,0.0892,2.0566,-0.4875,-0.0892,2.0566,-0.4875,0.0908,2.0951,-0.6307,0.2718,2.0794,-0.6307,0.2669,2.0412,-0.4875,0.0892,2.0566,-0.4875,0.2718,2.0794,-0.6307,0.4508,2.0481,-0.6307,0.4425,2.0104,-0.4875,0.2669,2.0412,-0.4875,0.4508,2.0481,-0.6307,0.6264,2.0014,-0.6307,0.6149,1.9646,-0.4875,0.4425,2.0104,-0.4875,0.6264,2.0014,-0.6307,0.7973,1.9396,-0.6307,0.7826,1.9040,-0.4875,0.6149,1.9646,-0.4875,0.7973,1.9396,-0.6307,0.9622,1.8633,-0.6307,0.9445,1.8291,-0.4875,0.7826,1.9040,-0.4875,0.9622,1.8633,-0.6307,1.1198,1.7731,-0.6307,1.0993,1.7405,-0.4875,0.9445,1.8291,-0.4875,1.1198,1.7731,-0.6307,1.2691,1.6695,-0.6307,1.2458,1.6388,-0.4875,1.0993,1.7405,-0.4875,1.2691,1.6695,-0.6307,1.4088,1.5534,-0.6307,1.3830,1.5248,-0.4875,1.2458,1.6388,-0.4875,1.4088,1.5534,-0.6307,1.5380,1.4256,-0.6307,1.5097,1.3994,-0.4875,1.3830,1.5248,-0.4875,1.5380,1.4256,-0.6307,1.6556,1.2871,-0.6307,1.6252,1.2635,-0.4875,1.5097,1.3994,-0.4875,1.6556,1.2871,-0.6307,1.7608,1.1390,-0.6307,1.7285,1.1180,-0.4875,1.6252,1.2635,-0.4875,1.7608,1.1390,-0.6307,1.8528,0.9823,-0.6307,1.8188,0.9642,-0.4875,1.7285,1.1180,-0.4875,1.8528,0.9823,-0.6307,1.9309,0.8182,-0.6307,1.8954,0.8032,-0.4875,1.8188,0.9642,-0.4875,1.9309,0.8182,-0.6307,1.9945,0.6480,-0.6307,1.9578,0.6361,-0.4875,1.8954,0.8032,-0.4875,-1.9578,0.6361,-0.4875,-1.8954,0.8032,-0.4875,-1.8689,0.7920,-0.3465,-1.9305,0.6272,-0.3465,-1.8954,0.8032,-0.4875,-1.8188,0.9642,-0.4875,-1.7934,0.9508,-0.3465,-1.8689,0.7920,-0.3465,-1.8188,0.9642,-0.4875,-1.7285,1.1180,-0.4875,-1.7043,1.1024,-0.3465,-1.7934,0.9508,-0.3465,-1.7285,1.1180,-0.4875,-1.6252,1.2635,-0.4875,-1.6025,1.2458,-0.3465,-1.7043,1.1024,-0.3465,-1.6252,1.2635,-0.4875,-1.5097,1.3994,-0.4875,-1.4887,1.3798,-0.3465,-1.6025,1.2458,-0.3465,-1.5097,1.3994,-0.4875,-1.3830,1.5248,-0.4875,-1.3636,1.5035,-0.3465,-1.4887,1.3798,-0.3465};
			return value;
		}
		private double[] getCoordinate_5_13_point_14()
		{
			double[] value = {-1.3830,1.5248,-0.4875,-1.2458,1.6388,-0.4875,-1.2284,1.6159,-0.3465,-1.3636,1.5035,-0.3465,-1.2458,1.6388,-0.4875,-1.0993,1.7405,-0.4875,-1.0839,1.7162,-0.3465,-1.2284,1.6159,-0.3465,-1.0993,1.7405,-0.4875,-0.9445,1.8291,-0.4875,-0.9313,1.8035,-0.3465,-1.0839,1.7162,-0.3465,-0.9445,1.8291,-0.4875,-0.7826,1.9040,-0.4875,-0.7717,1.8774,-0.3465,-0.9313,1.8035,-0.3465,-0.7826,1.9040,-0.4875,-0.6149,1.9646,-0.4875,-0.6063,1.9371,-0.3465,-0.7717,1.8774,-0.3465,-0.6149,1.9646,-0.4875,-0.4425,2.0104,-0.4875,-0.4363,1.9823,-0.3465,-0.6063,1.9371,-0.3465,-0.4425,2.0104,-0.4875,-0.2669,2.0412,-0.4875,-0.2631,2.0127,-0.3465,-0.4363,1.9823,-0.3465,-0.2669,2.0412,-0.4875,-0.0892,2.0566,-0.4875,-0.0879,2.0279,-0.3465,-0.2631,2.0127,-0.3465,-0.0892,2.0566,-0.4875,0.0892,2.0566,-0.4875,0.0879,2.0279,-0.3465,-0.0879,2.0279,-0.3465,0.0892,2.0566,-0.4875,0.2669,2.0412,-0.4875,0.2631,2.0127,-0.3465,0.0879,2.0279,-0.3465,0.2669,2.0412,-0.4875,0.4425,2.0104,-0.4875,0.4363,1.9823,-0.3465,0.2631,2.0127,-0.3465,0.4425,2.0104,-0.4875,0.6149,1.9646,-0.4875,0.6063,1.9371,-0.3465,0.4363,1.9823,-0.3465,0.6149,1.9646,-0.4875,0.7826,1.9040,-0.4875,0.7717,1.8774,-0.3465,0.6063,1.9371,-0.3465,0.7826,1.9040,-0.4875,0.9445,1.8291,-0.4875,0.9313,1.8035,-0.3465,0.7717,1.8774,-0.3465,0.9445,1.8291,-0.4875,1.0993,1.7405,-0.4875,1.0839,1.7162,-0.3465,0.9313,1.8035,-0.3465,1.0993,1.7405,-0.4875,1.2458,1.6388,-0.4875,1.2284,1.6159,-0.3465,1.0839,1.7162,-0.3465,1.2458,1.6388,-0.4875,1.3830,1.5248,-0.4875,1.3636,1.5035,-0.3465,1.2284,1.6159,-0.3465,1.3830,1.5248,-0.4875,1.5097,1.3994,-0.4875,1.4887,1.3798,-0.3465,1.3636,1.5035,-0.3465,1.5097,1.3994,-0.4875,1.6252,1.2635,-0.4875,1.6025,1.2458,-0.3465,1.4887,1.3798,-0.3465,1.6252,1.2635,-0.4875,1.7285,1.1180,-0.4875,1.7043,1.1024,-0.3465,1.6025,1.2458,-0.3465,1.7285,1.1180,-0.4875,1.8188,0.9642,-0.4875,1.7934,0.9508,-0.3465,1.7043,1.1024,-0.3465,1.8188,0.9642,-0.4875,1.8954,0.8032,-0.4875,1.8689,0.7920,-0.3465,1.7934,0.9508,-0.3465,1.8954,0.8032,-0.4875,1.9578,0.6361,-0.4875,1.9305,0.6272,-0.3465,1.8689,0.7920,-0.3465,-1.9305,0.6272,-0.3465,-1.8689,0.7920,-0.3465,-1.8513,0.7845,-0.2073,-1.9123,0.6213,-0.2073,-1.8689,0.7920,-0.3465,-1.7934,0.9508,-0.3465,-1.7765,0.9418,-0.2073,-1.8513,0.7845,-0.2073};
			return value;
		}
		private double[] getCoordinate_5_13_point_15()
		{
			double[] value = {-1.7934,0.9508,-0.3465,-1.7043,1.1024,-0.3465,-1.6883,1.0921,-0.2073,-1.7765,0.9418,-0.2073,-1.7043,1.1024,-0.3465,-1.6025,1.2458,-0.3465,-1.5874,1.2341,-0.2073,-1.6883,1.0921,-0.2073,-1.6025,1.2458,-0.3465,-1.4887,1.3798,-0.3465,-1.4747,1.3669,-0.2073,-1.5874,1.2341,-0.2073,-1.4887,1.3798,-0.3465,-1.3636,1.5035,-0.3465,-1.3508,1.4894,-0.2073,-1.4747,1.3669,-0.2073,-1.3636,1.5035,-0.3465,-1.2284,1.6159,-0.3465,-1.2168,1.6007,-0.2073,-1.3508,1.4894,-0.2073,-1.2284,1.6159,-0.3465,-1.0839,1.7162,-0.3465,-1.0737,1.7000,-0.2073,-1.2168,1.6007,-0.2073,-1.0839,1.7162,-0.3465,-0.9313,1.8035,-0.3465,-0.9225,1.7866,-0.2073,-1.0737,1.7000,-0.2073,-0.9313,1.8035,-0.3465,-0.7717,1.8774,-0.3465,-0.7644,1.8597,-0.2073,-0.9225,1.7866,-0.2073,-0.7717,1.8774,-0.3465,-0.6063,1.9371,-0.3465,-0.6006,1.9189,-0.2073,-0.7644,1.8597,-0.2073,-0.6063,1.9371,-0.3465,-0.4363,1.9823,-0.3465,-0.4322,1.9637,-0.2073,-0.6006,1.9189,-0.2073,-0.4363,1.9823,-0.3465,-0.2631,2.0127,-0.3465,-0.2607,1.9937,-0.2073,-0.4322,1.9637,-0.2073,-0.2631,2.0127,-0.3465,-0.0879,2.0279,-0.3465,-0.0871,2.0088,-0.2073,-0.2607,1.9937,-0.2073,-0.0879,2.0279,-0.3465,0.0879,2.0279,-0.3465,0.0871,2.0088,-0.2073,-0.0871,2.0088,-0.2073,0.0879,2.0279,-0.3465,0.2631,2.0127,-0.3465,0.2607,1.9937,-0.2073,0.0871,2.0088,-0.2073,0.2631,2.0127,-0.3465,0.4363,1.9823,-0.3465,0.4322,1.9637,-0.2073,0.2607,1.9937,-0.2073,0.4363,1.9823,-0.3465,0.6063,1.9371,-0.3465,0.6006,1.9189,-0.2073,0.4322,1.9637,-0.2073,0.6063,1.9371,-0.3465,0.7717,1.8774,-0.3465,0.7644,1.8597,-0.2073,0.6006,1.9189,-0.2073,0.7717,1.8774,-0.3465,0.9313,1.8035,-0.3465,0.9225,1.7866,-0.2073,0.7644,1.8597,-0.2073,0.9313,1.8035,-0.3465,1.0839,1.7162,-0.3465,1.0737,1.7000,-0.2073,0.9225,1.7866,-0.2073,1.0839,1.7162,-0.3465,1.2284,1.6159,-0.3465,1.2168,1.6007,-0.2073,1.0737,1.7000,-0.2073,1.2284,1.6159,-0.3465,1.3636,1.5035,-0.3465,1.3508,1.4894,-0.2073,1.2168,1.6007,-0.2073,1.3636,1.5035,-0.3465,1.4887,1.3798,-0.3465,1.4747,1.3669,-0.2073,1.3508,1.4894,-0.2073,1.4887,1.3798,-0.3465,1.6025,1.2458,-0.3465,1.5874,1.2341,-0.2073,1.4747,1.3669,-0.2073,1.6025,1.2458,-0.3465,1.7043,1.1024,-0.3465,1.6883,1.0921,-0.2073,1.5874,1.2341,-0.2073,1.7043,1.1024,-0.3465,1.7934,0.9508,-0.3465,1.7765,0.9418,-0.2073,1.6883,1.0921,-0.2073};
			return value;
		}
		private double[] getCoordinate_5_13_point_16()
		{
			double[] value = {1.7934,0.9508,-0.3465,1.8689,0.7920,-0.3465,1.8513,0.7845,-0.2073,1.7765,0.9418,-0.2073,1.8689,0.7920,-0.3465,1.9305,0.6272,-0.3465,1.9123,0.6213,-0.2073,1.8513,0.7845,-0.2073,-1.9123,0.6213,-0.2073,-1.8513,0.7845,-0.2073,-1.8426,0.7808,-0.0690,-1.9032,0.6184,-0.0690,-1.8513,0.7845,-0.2073,-1.7765,0.9418,-0.2073,-1.7681,0.9374,-0.0690,-1.8426,0.7808,-0.0690,-1.7765,0.9418,-0.2073,-1.6883,1.0921,-0.2073,-1.6803,1.0869,-0.0690,-1.7681,0.9374,-0.0690,-1.6883,1.0921,-0.2073,-1.5874,1.2341,-0.2073,-1.5799,1.2283,-0.0690,-1.6803,1.0869,-0.0690,-1.5874,1.2341,-0.2073,-1.4747,1.3669,-0.2073,-1.4677,1.3604,-0.0690,-1.5799,1.2283,-0.0690,-1.4747,1.3669,-0.2073,-1.3508,1.4894,-0.2073,-1.3444,1.4823,-0.0690,-1.4677,1.3604,-0.0690,-1.3508,1.4894,-0.2073,-1.2168,1.6007,-0.2073,-1.2111,1.5931,-0.0690,-1.3444,1.4823,-0.0690,-1.2168,1.6007,-0.2073,-1.0737,1.7000,-0.2073,-1.0686,1.6920,-0.0690,-1.2111,1.5931,-0.0690,-1.0737,1.7000,-0.2073,-0.9225,1.7866,-0.2073,-0.9182,1.7781,-0.0690,-1.0686,1.6920,-0.0690,-0.9225,1.7866,-0.2073,-0.7644,1.8597,-0.2073,-0.7608,1.8509,-0.0690,-0.9182,1.7781,-0.0690,-0.7644,1.8597,-0.2073,-0.6006,1.9189,-0.2073,-0.5977,1.9098,-0.0690,-0.7608,1.8509,-0.0690,-0.6006,1.9189,-0.2073,-0.4322,1.9637,-0.2073,-0.4302,1.9544,-0.0690,-0.5977,1.9098,-0.0690,-0.4322,1.9637,-0.2073,-0.2607,1.9937,-0.2073,-0.2594,1.9843,-0.0690,-0.4302,1.9544,-0.0690,-0.2607,1.9937,-0.2073,-0.0871,2.0088,-0.2073,-0.0867,1.9993,-0.0690,-0.2594,1.9843,-0.0690,-0.0871,2.0088,-0.2073,0.0871,2.0088,-0.2073,0.0867,1.9993,-0.0690,-0.0867,1.9993,-0.0690,0.0871,2.0088,-0.2073,0.2607,1.9937,-0.2073,0.2594,1.9843,-0.0690,0.0867,1.9993,-0.0690,0.2607,1.9937,-0.2073,0.4322,1.9637,-0.2073,0.4302,1.9544,-0.0690,0.2594,1.9843,-0.0690,0.4322,1.9637,-0.2073,0.6006,1.9189,-0.2073,0.5977,1.9098,-0.0690,0.4302,1.9544,-0.0690,0.6006,1.9189,-0.2073,0.7644,1.8597,-0.2073,0.7608,1.8509,-0.0690,0.5977,1.9098,-0.0690,0.7644,1.8597,-0.2073,0.9225,1.7866,-0.2073,0.9182,1.7781,-0.0690,0.7608,1.8509,-0.0690,0.9225,1.7866,-0.2073,1.0737,1.7000,-0.2073,1.0686,1.6920,-0.0690,0.9182,1.7781,-0.0690,1.0737,1.7000,-0.2073,1.2168,1.6007,-0.2073,1.2111,1.5931,-0.0690,1.0686,1.6920,-0.0690,1.2168,1.6007,-0.2073,1.3508,1.4894,-0.2073,1.3444,1.4823,-0.0690,1.2111,1.5931,-0.0690};
			return value;
		}
		private double[] getCoordinate_5_13_point_17()
		{
			double[] value = {1.3508,1.4894,-0.2073,1.4747,1.3669,-0.2073,1.4677,1.3604,-0.0690,1.3444,1.4823,-0.0690,1.4747,1.3669,-0.2073,1.5874,1.2341,-0.2073,1.5799,1.2283,-0.0690,1.4677,1.3604,-0.0690,1.5874,1.2341,-0.2073,1.6883,1.0921,-0.2073,1.6803,1.0869,-0.0690,1.5799,1.2283,-0.0690,1.6883,1.0921,-0.2073,1.7765,0.9418,-0.2073,1.7681,0.9374,-0.0690,1.6803,1.0869,-0.0690,1.7765,0.9418,-0.2073,1.8513,0.7845,-0.2073,1.8426,0.7808,-0.0690,1.7681,0.9374,-0.0690,1.8513,0.7845,-0.2073,1.9123,0.6213,-0.2073,1.9032,0.6184,-0.0690,1.8426,0.7808,-0.0690,-1.9032,0.6184,-0.0690,-1.8426,0.7808,-0.0690,-1.8426,0.7808,0.0690,-1.9032,0.6184,0.0690,-1.8426,0.7808,-0.0690,-1.7681,0.9374,-0.0690,-1.7681,0.9374,0.0690,-1.8426,0.7808,0.0690,-1.7681,0.9374,-0.0690,-1.6803,1.0869,-0.0690,-1.6803,1.0869,0.0690,-1.7681,0.9374,0.0690,-1.6803,1.0869,-0.0690,-1.5799,1.2283,-0.0690,-1.5799,1.2283,0.0690,-1.6803,1.0869,0.0690,-1.5799,1.2283,-0.0690,-1.4677,1.3604,-0.0690,-1.4677,1.3604,0.0690,-1.5799,1.2283,0.0690,-1.4677,1.3604,-0.0690,-1.3444,1.4823,-0.0690,-1.3444,1.4823,0.0690,-1.4677,1.3604,0.0690,-1.3444,1.4823,-0.0690,-1.2111,1.5931,-0.0690,-1.2111,1.5931,0.0690,-1.3444,1.4823,0.0690,-1.2111,1.5931,-0.0690,-1.0686,1.6920,-0.0690,-1.0686,1.6920,0.0690,-1.2111,1.5931,0.0690,-1.0686,1.6920,-0.0690,-0.9182,1.7781,-0.0690,-0.9182,1.7781,0.0690,-1.0686,1.6920,0.0690,-0.9182,1.7781,-0.0690,-0.7608,1.8509,-0.0690,-0.7608,1.8509,0.0690,-0.9182,1.7781,0.0690,-0.7608,1.8509,-0.0690,-0.5977,1.9098,-0.0690,-0.5977,1.9098,0.0690,-0.7608,1.8509,0.0690,-0.5977,1.9098,-0.0690,-0.4302,1.9544,-0.0690,-0.4302,1.9544,0.0690,-0.5977,1.9098,0.0690,-0.4302,1.9544,-0.0690,-0.2594,1.9843,-0.0690,-0.2594,1.9843,0.0690,-0.4302,1.9544,0.0690,-0.2594,1.9843,-0.0690,-0.0867,1.9993,-0.0690,-0.0867,1.9993,0.0690,-0.2594,1.9843,0.0690,-0.0867,1.9993,-0.0690,0.0867,1.9993,-0.0690,0.0867,1.9993,0.0690,-0.0867,1.9993,0.0690,0.0867,1.9993,-0.0690,0.2594,1.9843,-0.0690,0.2594,1.9843,0.0690,0.0867,1.9993,0.0690,0.2594,1.9843,-0.0690,0.4302,1.9544,-0.0690,0.4302,1.9544,0.0690,0.2594,1.9843,0.0690,0.4302,1.9544,-0.0690,0.5977,1.9098,-0.0690,0.5977,1.9098,0.0690,0.4302,1.9544,0.0690,0.5977,1.9098,-0.0690,0.7608,1.8509,-0.0690,0.7608,1.8509,0.0690,0.5977,1.9098,0.0690};
			return value;
		}
		private double[] getCoordinate_5_13_point_18()
		{
			double[] value = {0.7608,1.8509,-0.0690,0.9182,1.7781,-0.0690,0.9182,1.7781,0.0690,0.7608,1.8509,0.0690,0.9182,1.7781,-0.0690,1.0686,1.6920,-0.0690,1.0686,1.6920,0.0690,0.9182,1.7781,0.0690,1.0686,1.6920,-0.0690,1.2111,1.5931,-0.0690,1.2111,1.5931,0.0690,1.0686,1.6920,0.0690,1.2111,1.5931,-0.0690,1.3444,1.4823,-0.0690,1.3444,1.4823,0.0690,1.2111,1.5931,0.0690,1.3444,1.4823,-0.0690,1.4677,1.3604,-0.0690,1.4677,1.3604,0.0690,1.3444,1.4823,0.0690,1.4677,1.3604,-0.0690,1.5799,1.2283,-0.0690,1.5799,1.2283,0.0690,1.4677,1.3604,0.0690,1.5799,1.2283,-0.0690,1.6803,1.0869,-0.0690,1.6803,1.0869,0.0690,1.5799,1.2283,0.0690,1.6803,1.0869,-0.0690,1.7681,0.9374,-0.0690,1.7681,0.9374,0.0690,1.6803,1.0869,0.0690,1.7681,0.9374,-0.0690,1.8426,0.7808,-0.0690,1.8426,0.7808,0.0690,1.7681,0.9374,0.0690,1.8426,0.7808,-0.0690,1.9032,0.6184,-0.0690,1.9032,0.6184,0.0690,1.8426,0.7808,0.0690,-1.9032,0.6184,0.0690,-1.8426,0.7808,0.0690,-1.8513,0.7845,0.2073,-1.9123,0.6213,0.2073,-1.8426,0.7808,0.0690,-1.7681,0.9374,0.0690,-1.7765,0.9418,0.2073,-1.8513,0.7845,0.2073,-1.7681,0.9374,0.0690,-1.6803,1.0869,0.0690,-1.6883,1.0921,0.2073,-1.7765,0.9418,0.2073,-1.6803,1.0869,0.0690,-1.5799,1.2283,0.0690,-1.5874,1.2341,0.2073,-1.6883,1.0921,0.2073,-1.5799,1.2283,0.0690,-1.4677,1.3604,0.0690,-1.4747,1.3669,0.2073,-1.5874,1.2341,0.2073,-1.4677,1.3604,0.0690,-1.3444,1.4823,0.0690,-1.3508,1.4894,0.2073,-1.4747,1.3669,0.2073,-1.3444,1.4823,0.0690,-1.2111,1.5931,0.0690,-1.2168,1.6007,0.2073,-1.3508,1.4894,0.2073,-1.2111,1.5931,0.0690,-1.0686,1.6920,0.0690,-1.0737,1.7000,0.2073,-1.2168,1.6007,0.2073,-1.0686,1.6920,0.0690,-0.9182,1.7781,0.0690,-0.9225,1.7866,0.2073,-1.0737,1.7000,0.2073,-0.9182,1.7781,0.0690,-0.7608,1.8509,0.0690,-0.7644,1.8597,0.2073,-0.9225,1.7866,0.2073,-0.7608,1.8509,0.0690,-0.5977,1.9098,0.0690,-0.6006,1.9189,0.2073,-0.7644,1.8597,0.2073,-0.5977,1.9098,0.0690,-0.4302,1.9544,0.0690,-0.4322,1.9637,0.2073,-0.6006,1.9189,0.2073,-0.4302,1.9544,0.0690,-0.2594,1.9843,0.0690,-0.2607,1.9937,0.2073,-0.4322,1.9637,0.2073,-0.2594,1.9843,0.0690,-0.0867,1.9993,0.0690,-0.0871,2.0088,0.2073,-0.2607,1.9937,0.2073,-0.0867,1.9993,0.0690,0.0867,1.9993,0.0690,0.0871,2.0088,0.2073,-0.0871,2.0088,0.2073};
			return value;
		}
		private double[] getCoordinate_5_13_point_19()
		{
			double[] value = {0.0867,1.9993,0.0690,0.2594,1.9843,0.0690,0.2607,1.9937,0.2073,0.0871,2.0088,0.2073,0.2594,1.9843,0.0690,0.4302,1.9544,0.0690,0.4322,1.9637,0.2073,0.2607,1.9937,0.2073,0.4302,1.9544,0.0690,0.5977,1.9098,0.0690,0.6006,1.9189,0.2073,0.4322,1.9637,0.2073,0.5977,1.9098,0.0690,0.7608,1.8509,0.0690,0.7644,1.8597,0.2073,0.6006,1.9189,0.2073,0.7608,1.8509,0.0690,0.9182,1.7781,0.0690,0.9225,1.7866,0.2073,0.7644,1.8597,0.2073,0.9182,1.7781,0.0690,1.0686,1.6920,0.0690,1.0737,1.7000,0.2073,0.9225,1.7866,0.2073,1.0686,1.6920,0.0690,1.2111,1.5931,0.0690,1.2168,1.6007,0.2073,1.0737,1.7000,0.2073,1.2111,1.5931,0.0690,1.3444,1.4823,0.0690,1.3508,1.4894,0.2073,1.2168,1.6007,0.2073,1.3444,1.4823,0.0690,1.4677,1.3604,0.0690,1.4747,1.3669,0.2073,1.3508,1.4894,0.2073,1.4677,1.3604,0.0690,1.5799,1.2283,0.0690,1.5874,1.2341,0.2073,1.4747,1.3669,0.2073,1.5799,1.2283,0.0690,1.6803,1.0869,0.0690,1.6883,1.0921,0.2073,1.5874,1.2341,0.2073,1.6803,1.0869,0.0690,1.7681,0.9374,0.0690,1.7765,0.9418,0.2073,1.6883,1.0921,0.2073,1.7681,0.9374,0.0690,1.8426,0.7808,0.0690,1.8513,0.7845,0.2073,1.7765,0.9418,0.2073,1.8426,0.7808,0.0690,1.9032,0.6184,0.0690,1.9123,0.6213,0.2073,1.8513,0.7845,0.2073,-1.9123,0.6213,0.2073,-1.8513,0.7845,0.2073,-1.8689,0.7920,0.3465,-1.9305,0.6272,0.3465,-1.8513,0.7845,0.2073,-1.7765,0.9418,0.2073,-1.7934,0.9508,0.3465,-1.8689,0.7920,0.3465,-1.7765,0.9418,0.2073,-1.6883,1.0921,0.2073,-1.7043,1.1024,0.3465,-1.7934,0.9508,0.3465,-1.6883,1.0921,0.2073,-1.5874,1.2341,0.2073,-1.6025,1.2458,0.3465,-1.7043,1.1024,0.3465,-1.5874,1.2341,0.2073,-1.4747,1.3669,0.2073,-1.4887,1.3798,0.3465,-1.6025,1.2458,0.3465,-1.4747,1.3669,0.2073,-1.3508,1.4894,0.2073,-1.3636,1.5035,0.3465,-1.4887,1.3798,0.3465,-1.3508,1.4894,0.2073,-1.2168,1.6007,0.2073,-1.2284,1.6159,0.3465,-1.3636,1.5035,0.3465,-1.2168,1.6007,0.2073,-1.0737,1.7000,0.2073,-1.0839,1.7162,0.3465,-1.2284,1.6159,0.3465,-1.0737,1.7000,0.2073,-0.9225,1.7866,0.2073,-0.9313,1.8035,0.3465,-1.0839,1.7162,0.3465,-0.9225,1.7866,0.2073,-0.7644,1.8597,0.2073,-0.7717,1.8774,0.3465,-0.9313,1.8035,0.3465,-0.7644,1.8597,0.2073,-0.6006,1.9189,0.2073,-0.6063,1.9371,0.3465,-0.7717,1.8774,0.3465};
			return value;
		}
		private double[] getCoordinate_5_13_point_20()
		{
			double[] value = {-0.6006,1.9189,0.2073,-0.4322,1.9637,0.2073,-0.4363,1.9823,0.3465,-0.6063,1.9371,0.3465,-0.4322,1.9637,0.2073,-0.2607,1.9937,0.2073,-0.2631,2.0127,0.3465,-0.4363,1.9823,0.3465,-0.2607,1.9937,0.2073,-0.0871,2.0088,0.2073,-0.0879,2.0279,0.3465,-0.2631,2.0127,0.3465,-0.0871,2.0088,0.2073,0.0871,2.0088,0.2073,0.0879,2.0279,0.3465,-0.0879,2.0279,0.3465,0.0871,2.0088,0.2073,0.2607,1.9937,0.2073,0.2631,2.0127,0.3465,0.0879,2.0279,0.3465,0.2607,1.9937,0.2073,0.4322,1.9637,0.2073,0.4363,1.9823,0.3465,0.2631,2.0127,0.3465,0.4322,1.9637,0.2073,0.6006,1.9189,0.2073,0.6063,1.9371,0.3465,0.4363,1.9823,0.3465,0.6006,1.9189,0.2073,0.7644,1.8597,0.2073,0.7717,1.8774,0.3465,0.6063,1.9371,0.3465,0.7644,1.8597,0.2073,0.9225,1.7866,0.2073,0.9313,1.8035,0.3465,0.7717,1.8774,0.3465,0.9225,1.7866,0.2073,1.0737,1.7000,0.2073,1.0839,1.7162,0.3465,0.9313,1.8035,0.3465,1.0737,1.7000,0.2073,1.2168,1.6007,0.2073,1.2284,1.6159,0.3465,1.0839,1.7162,0.3465,1.2168,1.6007,0.2073,1.3508,1.4894,0.2073,1.3636,1.5035,0.3465,1.2284,1.6159,0.3465,1.3508,1.4894,0.2073,1.4747,1.3669,0.2073,1.4887,1.3798,0.3465,1.3636,1.5035,0.3465,1.4747,1.3669,0.2073,1.5874,1.2341,0.2073,1.6025,1.2458,0.3465,1.4887,1.3798,0.3465,1.5874,1.2341,0.2073,1.6883,1.0921,0.2073,1.7043,1.1024,0.3465,1.6025,1.2458,0.3465,1.6883,1.0921,0.2073,1.7765,0.9418,0.2073,1.7934,0.9508,0.3465,1.7043,1.1024,0.3465,1.7765,0.9418,0.2073,1.8513,0.7845,0.2073,1.8689,0.7920,0.3465,1.7934,0.9508,0.3465,1.8513,0.7845,0.2073,1.9123,0.6213,0.2073,1.9305,0.6272,0.3465,1.8689,0.7920,0.3465,-1.9305,0.6272,0.3465,-1.8689,0.7920,0.3465,-1.8954,0.8032,0.4875,-1.9578,0.6361,0.4875,-1.8689,0.7920,0.3465,-1.7934,0.9508,0.3465,-1.8188,0.9642,0.4875,-1.8954,0.8032,0.4875,-1.7934,0.9508,0.3465,-1.7043,1.1024,0.3465,-1.7285,1.1180,0.4875,-1.8188,0.9642,0.4875,-1.7043,1.1024,0.3465,-1.6025,1.2458,0.3465,-1.6252,1.2635,0.4875,-1.7285,1.1180,0.4875,-1.6025,1.2458,0.3465,-1.4887,1.3798,0.3465,-1.5097,1.3994,0.4875,-1.6252,1.2635,0.4875,-1.4887,1.3798,0.3465,-1.3636,1.5035,0.3465,-1.3830,1.5248,0.4875,-1.5097,1.3994,0.4875,-1.3636,1.5035,0.3465,-1.2284,1.6159,0.3465,-1.2458,1.6388,0.4875,-1.3830,1.5248,0.4875};
			return value;
		}
		private double[] getCoordinate_5_13_point_21()
		{
			double[] value = {-1.2284,1.6159,0.3465,-1.0839,1.7162,0.3465,-1.0993,1.7405,0.4875,-1.2458,1.6388,0.4875,-1.0839,1.7162,0.3465,-0.9313,1.8035,0.3465,-0.9445,1.8291,0.4875,-1.0993,1.7405,0.4875,-0.9313,1.8035,0.3465,-0.7717,1.8774,0.3465,-0.7826,1.9040,0.4875,-0.9445,1.8291,0.4875,-0.7717,1.8774,0.3465,-0.6063,1.9371,0.3465,-0.6149,1.9646,0.4875,-0.7826,1.9040,0.4875,-0.6063,1.9371,0.3465,-0.4363,1.9823,0.3465,-0.4425,2.0104,0.4875,-0.6149,1.9646,0.4875,-0.4363,1.9823,0.3465,-0.2631,2.0127,0.3465,-0.2669,2.0412,0.4875,-0.4425,2.0104,0.4875,-0.2631,2.0127,0.3465,-0.0879,2.0279,0.3465,-0.0892,2.0566,0.4875,-0.2669,2.0412,0.4875,-0.0879,2.0279,0.3465,0.0879,2.0279,0.3465,0.0892,2.0566,0.4875,-0.0892,2.0566,0.4875,0.0879,2.0279,0.3465,0.2631,2.0127,0.3465,0.2669,2.0412,0.4875,0.0892,2.0566,0.4875,0.2631,2.0127,0.3465,0.4363,1.9823,0.3465,0.4425,2.0104,0.4875,0.2669,2.0412,0.4875,0.4363,1.9823,0.3465,0.6063,1.9371,0.3465,0.6149,1.9646,0.4875,0.4425,2.0104,0.4875,0.6063,1.9371,0.3465,0.7717,1.8774,0.3465,0.7826,1.9040,0.4875,0.6149,1.9646,0.4875,0.7717,1.8774,0.3465,0.9313,1.8035,0.3465,0.9445,1.8291,0.4875,0.7826,1.9040,0.4875,0.9313,1.8035,0.3465,1.0839,1.7162,0.3465,1.0993,1.7405,0.4875,0.9445,1.8291,0.4875,1.0839,1.7162,0.3465,1.2284,1.6159,0.3465,1.2458,1.6388,0.4875,1.0993,1.7405,0.4875,1.2284,1.6159,0.3465,1.3636,1.5035,0.3465,1.3830,1.5248,0.4875,1.2458,1.6388,0.4875,1.3636,1.5035,0.3465,1.4887,1.3798,0.3465,1.5097,1.3994,0.4875,1.3830,1.5248,0.4875,1.4887,1.3798,0.3465,1.6025,1.2458,0.3465,1.6252,1.2635,0.4875,1.5097,1.3994,0.4875,1.6025,1.2458,0.3465,1.7043,1.1024,0.3465,1.7285,1.1180,0.4875,1.6252,1.2635,0.4875,1.7043,1.1024,0.3465,1.7934,0.9508,0.3465,1.8188,0.9642,0.4875,1.7285,1.1180,0.4875,1.7934,0.9508,0.3465,1.8689,0.7920,0.3465,1.8954,0.8032,0.4875,1.8188,0.9642,0.4875,1.8689,0.7920,0.3465,1.9305,0.6272,0.3465,1.9578,0.6361,0.4875,1.8954,0.8032,0.4875,-1.9578,0.6361,0.4875,-1.8954,0.8032,0.4875,-1.9309,0.8182,0.6307,-1.9945,0.6480,0.6307,-1.8954,0.8032,0.4875,-1.8188,0.9642,0.4875,-1.8528,0.9823,0.6307,-1.9309,0.8182,0.6307,-1.8188,0.9642,0.4875,-1.7285,1.1180,0.4875,-1.7608,1.1390,0.6307,-1.8528,0.9823,0.6307};
			return value;
		}
		private double[] getCoordinate_5_13_point_22()
		{
			double[] value = {-1.7285,1.1180,0.4875,-1.6252,1.2635,0.4875,-1.6556,1.2871,0.6307,-1.7608,1.1390,0.6307,-1.6252,1.2635,0.4875,-1.5097,1.3994,0.4875,-1.5380,1.4256,0.6307,-1.6556,1.2871,0.6307,-1.5097,1.3994,0.4875,-1.3830,1.5248,0.4875,-1.4088,1.5534,0.6307,-1.5380,1.4256,0.6307,-1.3830,1.5248,0.4875,-1.2458,1.6388,0.4875,-1.2691,1.6695,0.6307,-1.4088,1.5534,0.6307,-1.2458,1.6388,0.4875,-1.0993,1.7405,0.4875,-1.1198,1.7731,0.6307,-1.2691,1.6695,0.6307,-1.0993,1.7405,0.4875,-0.9445,1.8291,0.4875,-0.9622,1.8633,0.6307,-1.1198,1.7731,0.6307,-0.9445,1.8291,0.4875,-0.7826,1.9040,0.4875,-0.7973,1.9396,0.6307,-0.9622,1.8633,0.6307,-0.7826,1.9040,0.4875,-0.6149,1.9646,0.4875,-0.6264,2.0014,0.6307,-0.7973,1.9396,0.6307,-0.6149,1.9646,0.4875,-0.4425,2.0104,0.4875,-0.4508,2.0481,0.6307,-0.6264,2.0014,0.6307,-0.4425,2.0104,0.4875,-0.2669,2.0412,0.4875,-0.2718,2.0794,0.6307,-0.4508,2.0481,0.6307,-0.2669,2.0412,0.4875,-0.0892,2.0566,0.4875,-0.0908,2.0951,0.6307,-0.2718,2.0794,0.6307,-0.0892,2.0566,0.4875,0.0892,2.0566,0.4875,0.0908,2.0951,0.6307,-0.0908,2.0951,0.6307,0.0892,2.0566,0.4875,0.2669,2.0412,0.4875,0.2718,2.0794,0.6307,0.0908,2.0951,0.6307,0.2669,2.0412,0.4875,0.4425,2.0104,0.4875,0.4508,2.0481,0.6307,0.2718,2.0794,0.6307,0.4425,2.0104,0.4875,0.6149,1.9646,0.4875,0.6264,2.0014,0.6307,0.4508,2.0481,0.6307,0.6149,1.9646,0.4875,0.7826,1.9040,0.4875,0.7973,1.9396,0.6307,0.6264,2.0014,0.6307,0.7826,1.9040,0.4875,0.9445,1.8291,0.4875,0.9622,1.8633,0.6307,0.7973,1.9396,0.6307,0.9445,1.8291,0.4875,1.0993,1.7405,0.4875,1.1198,1.7731,0.6307,0.9622,1.8633,0.6307,1.0993,1.7405,0.4875,1.2458,1.6388,0.4875,1.2691,1.6695,0.6307,1.1198,1.7731,0.6307,1.2458,1.6388,0.4875,1.3830,1.5248,0.4875,1.4088,1.5534,0.6307,1.2691,1.6695,0.6307,1.3830,1.5248,0.4875,1.5097,1.3994,0.4875,1.5380,1.4256,0.6307,1.4088,1.5534,0.6307,1.5097,1.3994,0.4875,1.6252,1.2635,0.4875,1.6556,1.2871,0.6307,1.5380,1.4256,0.6307,1.6252,1.2635,0.4875,1.7285,1.1180,0.4875,1.7608,1.1390,0.6307,1.6556,1.2871,0.6307,1.7285,1.1180,0.4875,1.8188,0.9642,0.4875,1.8528,0.9823,0.6307,1.7608,1.1390,0.6307,1.8188,0.9642,0.4875,1.8954,0.8032,0.4875,1.9309,0.8182,0.6307,1.8528,0.9823,0.6307};
			return value;
		}
		private double[] getCoordinate_5_13_point_23()
		{
			double[] value = {1.8954,0.8032,0.4875,1.9578,0.6361,0.4875,1.9945,0.6480,0.6307,1.9309,0.8182,0.6307,-1.9945,0.6480,0.6307,-1.9309,0.8182,0.6307,-1.9755,0.8372,0.7769,-2.0406,0.6630,0.7769,-1.9309,0.8182,0.6307,-1.8528,0.9823,0.6307,-1.8957,1.0050,0.7769,-1.9755,0.8372,0.7769,-1.8528,0.9823,0.6307,-1.7608,1.1390,0.6307,-1.8016,1.1653,0.7769,-1.8957,1.0050,0.7769,-1.7608,1.1390,0.6307,-1.6556,1.2871,0.6307,-1.6939,1.3169,0.7769,-1.8016,1.1653,0.7769,-1.6556,1.2871,0.6307,-1.5380,1.4256,0.6307,-1.5736,1.4586,0.7769,-1.6939,1.3169,0.7769,-1.5380,1.4256,0.6307,-1.4088,1.5534,0.6307,-1.4414,1.5893,0.7769,-1.5736,1.4586,0.7769,-1.4088,1.5534,0.6307,-1.2691,1.6695,0.6307,-1.2985,1.7081,0.7769,-1.4414,1.5893,0.7769,-1.2691,1.6695,0.6307,-1.1198,1.7731,0.6307,-1.1457,1.8141,0.7769,-1.2985,1.7081,0.7769,-1.1198,1.7731,0.6307,-0.9622,1.8633,0.6307,-0.9844,1.9064,0.7769,-1.1457,1.8141,0.7769,-0.9622,1.8633,0.6307,-0.7973,1.9396,0.6307,-0.8157,1.9845,0.7769,-0.9844,1.9064,0.7769,-0.7973,1.9396,0.6307,-0.6264,2.0014,0.6307,-0.6409,2.0477,0.7769,-0.8157,1.9845,0.7769,-0.6264,2.0014,0.6307,-0.4508,2.0481,0.6307,-0.4612,2.0954,0.7769,-0.6409,2.0477,0.7769,-0.4508,2.0481,0.6307,-0.2718,2.0794,0.6307,-0.2781,2.1275,0.7769,-0.4612,2.0954,0.7769,-0.2718,2.0794,0.6307,-0.0908,2.0951,0.6307,-0.0929,2.1436,0.7769,-0.2781,2.1275,0.7769,-0.0908,2.0951,0.6307,0.0908,2.0951,0.6307,0.0929,2.1436,0.7769,-0.0929,2.1436,0.7769,0.0908,2.0951,0.6307,0.2718,2.0794,0.6307,0.2781,2.1275,0.7769,0.0929,2.1436,0.7769,0.2718,2.0794,0.6307,0.4508,2.0481,0.6307,0.4612,2.0954,0.7769,0.2781,2.1275,0.7769,0.4508,2.0481,0.6307,0.6264,2.0014,0.6307,0.6409,2.0477,0.7769,0.4612,2.0954,0.7769,0.6264,2.0014,0.6307,0.7973,1.9396,0.6307,0.8157,1.9845,0.7769,0.6409,2.0477,0.7769,0.7973,1.9396,0.6307,0.9622,1.8633,0.6307,0.9844,1.9064,0.7769,0.8157,1.9845,0.7769,0.9622,1.8633,0.6307,1.1198,1.7731,0.6307,1.1457,1.8141,0.7769,0.9844,1.9064,0.7769,1.1198,1.7731,0.6307,1.2691,1.6695,0.6307,1.2985,1.7081,0.7769,1.1457,1.8141,0.7769,1.2691,1.6695,0.6307,1.4088,1.5534,0.6307,1.4414,1.5893,0.7769,1.2985,1.7081,0.7769,1.4088,1.5534,0.6307,1.5380,1.4256,0.6307,1.5736,1.4586,0.7769,1.4414,1.5893,0.7769};
			return value;
		}
		private double[] getCoordinate_5_13_point_24()
		{
			double[] value = {1.5380,1.4256,0.6307,1.6556,1.2871,0.6307,1.6939,1.3169,0.7769,1.5736,1.4586,0.7769,1.6556,1.2871,0.6307,1.7608,1.1390,0.6307,1.8016,1.1653,0.7769,1.6939,1.3169,0.7769,1.7608,1.1390,0.6307,1.8528,0.9823,0.6307,1.8957,1.0050,0.7769,1.8016,1.1653,0.7769,1.8528,0.9823,0.6307,1.9309,0.8182,0.6307,1.9755,0.8372,0.7769,1.8957,1.0050,0.7769,1.9309,0.8182,0.6307,1.9945,0.6480,0.6307,2.0406,0.6630,0.7769,1.9755,0.8372,0.7769,-2.0406,0.6630,0.7769,-1.9755,0.8372,0.7769,-2.0296,0.8601,0.9269,-2.0965,0.6812,0.9269,-1.9755,0.8372,0.7769,-1.8957,1.0050,0.7769,-1.9476,1.0325,0.9269,-2.0296,0.8601,0.9269,-1.8957,1.0050,0.7769,-1.8016,1.1653,0.7769,-1.8509,1.1972,0.9269,-1.9476,1.0325,0.9269,-1.8016,1.1653,0.7769,-1.6939,1.3169,0.7769,-1.7403,1.3529,0.9269,-1.8509,1.1972,0.9269,-1.6939,1.3169,0.7769,-1.5736,1.4586,0.7769,-1.6167,1.4985,0.9269,-1.7403,1.3529,0.9269,-1.5736,1.4586,0.7769,-1.4414,1.5893,0.7769,-1.4809,1.6328,0.9269,-1.6167,1.4985,0.9269,-1.4414,1.5893,0.7769,-1.2985,1.7081,0.7769,-1.3340,1.7549,0.9269,-1.4809,1.6328,0.9269,-1.2985,1.7081,0.7769,-1.1457,1.8141,0.7769,-1.1771,1.8637,0.9269,-1.3340,1.7549,0.9269,-1.1457,1.8141,0.7769,-0.9844,1.9064,0.7769,-1.0114,1.9586,0.9269,-1.1771,1.8637,0.9269,-0.9844,1.9064,0.7769,-0.8157,1.9845,0.7769,-0.8380,2.0388,0.9269,-1.0114,1.9586,0.9269,-0.8157,1.9845,0.7769,-0.6409,2.0477,0.7769,-0.6584,2.1037,0.9269,-0.8380,2.0388,0.9269,-0.6409,2.0477,0.7769,-0.4612,2.0954,0.7769,-0.4739,2.1528,0.9269,-0.6584,2.1037,0.9269,-0.4612,2.0954,0.7769,-0.2781,2.1275,0.7769,-0.2858,2.1857,0.9269,-0.4739,2.1528,0.9269,-0.2781,2.1275,0.7769,-0.0929,2.1436,0.7769,-0.0955,2.2023,0.9269,-0.2858,2.1857,0.9269,-0.0929,2.1436,0.7769,0.0929,2.1436,0.7769,0.0955,2.2023,0.9269,-0.0955,2.2023,0.9269,0.0929,2.1436,0.7769,0.2781,2.1275,0.7769,0.2858,2.1857,0.9269,0.0955,2.2023,0.9269,0.2781,2.1275,0.7769,0.4612,2.0954,0.7769,0.4739,2.1528,0.9269,0.2858,2.1857,0.9269,0.4612,2.0954,0.7769,0.6409,2.0477,0.7769,0.6584,2.1037,0.9269,0.4739,2.1528,0.9269,0.6409,2.0477,0.7769,0.8157,1.9845,0.7769,0.8380,2.0388,0.9269,0.6584,2.1037,0.9269,0.8157,1.9845,0.7769,0.9844,1.9064,0.7769,1.0114,1.9586,0.9269,0.8380,2.0388,0.9269};
			return value;
		}
		private double[] getCoordinate_5_13_point_25()
		{
			double[] value = {0.9844,1.9064,0.7769,1.1457,1.8141,0.7769,1.1771,1.8637,0.9269,1.0114,1.9586,0.9269,1.1457,1.8141,0.7769,1.2985,1.7081,0.7769,1.3340,1.7549,0.9269,1.1771,1.8637,0.9269,1.2985,1.7081,0.7769,1.4414,1.5893,0.7769,1.4809,1.6328,0.9269,1.3340,1.7549,0.9269,1.4414,1.5893,0.7769,1.5736,1.4586,0.7769,1.6167,1.4985,0.9269,1.4809,1.6328,0.9269,1.5736,1.4586,0.7769,1.6939,1.3169,0.7769,1.7403,1.3529,0.9269,1.6167,1.4985,0.9269,1.6939,1.3169,0.7769,1.8016,1.1653,0.7769,1.8509,1.1972,0.9269,1.7403,1.3529,0.9269,1.8016,1.1653,0.7769,1.8957,1.0050,0.7769,1.9476,1.0325,0.9269,1.8509,1.1972,0.9269,1.8957,1.0050,0.7769,1.9755,0.8372,0.7769,2.0296,0.8601,0.9269,1.9476,1.0325,0.9269,1.9755,0.8372,0.7769,2.0406,0.6630,0.7769,2.0965,0.6812,0.9269,2.0296,0.8601,0.9269,-2.0965,0.6812,0.9269,-2.0296,0.8601,0.9269,-2.0934,0.8871,1.0812,-2.1623,0.7026,1.0812,-2.0296,0.8601,0.9269,-1.9476,1.0325,0.9269,-2.0087,1.0650,1.0812,-2.0934,0.8871,1.0812,-1.9476,1.0325,0.9269,-1.8509,1.1972,0.9269,-1.9090,1.2348,1.0812,-2.0087,1.0650,1.0812,-1.8509,1.1972,0.9269,-1.7403,1.3529,0.9269,-1.7950,1.3954,1.0812,-1.9090,1.2348,1.0812,-1.7403,1.3529,0.9269,-1.6167,1.4985,0.9269,-1.6674,1.5456,1.0812,-1.7950,1.3954,1.0812,-1.6167,1.4985,0.9269,-1.4809,1.6328,0.9269,-1.5274,1.6841,1.0812,-1.6674,1.5456,1.0812,-1.4809,1.6328,0.9269,-1.3340,1.7549,0.9269,-1.3759,1.8100,1.0812,-1.5274,1.6841,1.0812,-1.3340,1.7549,0.9269,-1.1771,1.8637,0.9269,-1.2141,1.9223,1.0812,-1.3759,1.8100,1.0812,-1.1771,1.8637,0.9269,-1.0114,1.9586,0.9269,-1.0431,2.0201,1.0812,-1.2141,1.9223,1.0812,-1.0114,1.9586,0.9269,-0.8380,2.0388,0.9269,-0.8644,2.1028,1.0812,-1.0431,2.0201,1.0812,-0.8380,2.0388,0.9269,-0.6584,2.1037,0.9269,-0.6791,2.1698,1.0812,-0.8644,2.1028,1.0812,-0.6584,2.1037,0.9269,-0.4739,2.1528,0.9269,-0.4887,2.2204,1.0812,-0.6791,2.1698,1.0812,-0.4739,2.1528,0.9269,-0.2858,2.1857,0.9269,-0.2947,2.2544,1.0812,-0.4887,2.2204,1.0812,-0.2858,2.1857,0.9269,-0.0955,2.2023,0.9269,-0.0985,2.2714,1.0812,-0.2947,2.2544,1.0812,-0.0955,2.2023,0.9269,0.0955,2.2023,0.9269,0.0985,2.2714,1.0812,-0.0985,2.2714,1.0812,0.0955,2.2023,0.9269,0.2858,2.1857,0.9269,0.2947,2.2544,1.0812,0.0985,2.2714,1.0812};
			return value;
		}
		private double[] getCoordinate_5_13_point_26()
		{
			double[] value = {0.2858,2.1857,0.9269,0.4739,2.1528,0.9269,0.4887,2.2204,1.0812,0.2947,2.2544,1.0812,0.4739,2.1528,0.9269,0.6584,2.1037,0.9269,0.6791,2.1698,1.0812,0.4887,2.2204,1.0812,0.6584,2.1037,0.9269,0.8380,2.0388,0.9269,0.8644,2.1028,1.0812,0.6791,2.1698,1.0812,0.8380,2.0388,0.9269,1.0114,1.9586,0.9269,1.0431,2.0201,1.0812,0.8644,2.1028,1.0812,1.0114,1.9586,0.9269,1.1771,1.8637,0.9269,1.2141,1.9223,1.0812,1.0431,2.0201,1.0812,1.1771,1.8637,0.9269,1.3340,1.7549,0.9269,1.3759,1.8100,1.0812,1.2141,1.9223,1.0812,1.3340,1.7549,0.9269,1.4809,1.6328,0.9269,1.5274,1.6841,1.0812,1.3759,1.8100,1.0812,1.4809,1.6328,0.9269,1.6167,1.4985,0.9269,1.6674,1.5456,1.0812,1.5274,1.6841,1.0812,1.6167,1.4985,0.9269,1.7403,1.3529,0.9269,1.7950,1.3954,1.0812,1.6674,1.5456,1.0812,1.7403,1.3529,0.9269,1.8509,1.1972,0.9269,1.9090,1.2348,1.0812,1.7950,1.3954,1.0812,1.8509,1.1972,0.9269,1.9476,1.0325,0.9269,2.0087,1.0650,1.0812,1.9090,1.2348,1.0812,1.9476,1.0325,0.9269,2.0296,0.8601,0.9269,2.0934,0.8871,1.0812,2.0087,1.0650,1.0812,2.0296,0.8601,0.9269,2.0965,0.6812,0.9269,2.1623,0.7026,1.0812,2.0934,0.8871,1.0812,-2.1623,0.7026,1.0812,-2.0934,0.8871,1.0812,-2.1670,0.9183,1.2407,-2.2384,0.7273,1.2407,-2.0934,0.8871,1.0812,-2.0087,1.0650,1.0812,-2.0794,1.1024,1.2407,-2.1670,0.9183,1.2407,-2.0087,1.0650,1.0812,-1.9090,1.2348,1.0812,-1.9762,1.2783,1.2407,-2.0794,1.1024,1.2407,-1.9090,1.2348,1.0812,-1.7950,1.3954,1.0812,-1.8581,1.4445,1.2407,-1.9762,1.2783,1.2407,-1.7950,1.3954,1.0812,-1.6674,1.5456,1.0812,-1.7261,1.6000,1.2407,-1.8581,1.4445,1.2407,-1.6674,1.5456,1.0812,-1.5274,1.6841,1.0812,-1.5812,1.7434,1.2407,-1.7261,1.6000,1.2407,-1.5274,1.6841,1.0812,-1.3759,1.8100,1.0812,-1.4243,1.8737,1.2407,-1.5812,1.7434,1.2407,-1.3759,1.8100,1.0812,-1.2141,1.9223,1.0812,-1.2568,1.9899,1.2407,-1.4243,1.8737,1.2407,-1.2141,1.9223,1.0812,-1.0431,2.0201,1.0812,-1.0799,2.0912,1.2407,-1.2568,1.9899,1.2407,-1.0431,2.0201,1.0812,-0.8644,2.1028,1.0812,-0.8948,2.1769,1.2407,-1.0799,2.0912,1.2407,-0.8644,2.1028,1.0812,-0.6791,2.1698,1.0812,-0.7030,2.2461,1.2407,-0.8948,2.1769,1.2407,-0.6791,2.1698,1.0812,-0.4887,2.2204,1.0812,-0.5060,2.2986,1.2407,-0.7030,2.2461,1.2407};
			return value;
		}
		private double[] getCoordinate_5_13_point_27()
		{
			double[] value = {-0.4887,2.2204,1.0812,-0.2947,2.2544,1.0812,-0.3051,2.3337,1.2407,-0.5060,2.2986,1.2407,-0.2947,2.2544,1.0812,-0.0985,2.2714,1.0812,-0.1020,2.3514,1.2407,-0.3051,2.3337,1.2407,-0.0985,2.2714,1.0812,0.0985,2.2714,1.0812,0.1020,2.3514,1.2407,-0.1020,2.3514,1.2407,0.0985,2.2714,1.0812,0.2947,2.2544,1.0812,0.3051,2.3337,1.2407,0.1020,2.3514,1.2407,0.2947,2.2544,1.0812,0.4887,2.2204,1.0812,0.5060,2.2986,1.2407,0.3051,2.3337,1.2407,0.4887,2.2204,1.0812,0.6791,2.1698,1.0812,0.7030,2.2461,1.2407,0.5060,2.2986,1.2407,0.6791,2.1698,1.0812,0.8644,2.1028,1.0812,0.8948,2.1769,1.2407,0.7030,2.2461,1.2407,0.8644,2.1028,1.0812,1.0431,2.0201,1.0812,1.0799,2.0912,1.2407,0.8948,2.1769,1.2407,1.0431,2.0201,1.0812,1.2141,1.9223,1.0812,1.2568,1.9899,1.2407,1.0799,2.0912,1.2407,1.2141,1.9223,1.0812,1.3759,1.8100,1.0812,1.4243,1.8737,1.2407,1.2568,1.9899,1.2407,1.3759,1.8100,1.0812,1.5274,1.6841,1.0812,1.5812,1.7434,1.2407,1.4243,1.8737,1.2407,1.5274,1.6841,1.0812,1.6674,1.5456,1.0812,1.7261,1.6000,1.2407,1.5812,1.7434,1.2407,1.6674,1.5456,1.0812,1.7950,1.3954,1.0812,1.8581,1.4445,1.2407,1.7261,1.6000,1.2407,1.7950,1.3954,1.0812,1.9090,1.2348,1.0812,1.9762,1.2783,1.2407,1.8581,1.4445,1.2407,1.9090,1.2348,1.0812,2.0087,1.0650,1.0812,2.0794,1.1024,1.2407,1.9762,1.2783,1.2407,2.0087,1.0650,1.0812,2.0934,0.8871,1.0812,2.1670,0.9183,1.2407,2.0794,1.1024,1.2407,2.0934,0.8871,1.0812,2.1623,0.7026,1.0812,2.2384,0.7273,1.2407,2.1670,0.9183,1.2407,-2.2384,0.7273,1.2407,-2.1670,0.9183,1.2407,-2.2510,0.9539,1.4061,-2.3252,0.7555,1.4061,-2.1670,0.9183,1.2407,-2.0794,1.1024,1.2407,-2.1600,1.1452,1.4061,-2.2510,0.9539,1.4061,-2.0794,1.1024,1.2407,-1.9762,1.2783,1.2407,-2.0528,1.3278,1.4061,-2.1600,1.1452,1.4061,-1.9762,1.2783,1.2407,-1.8581,1.4445,1.2407,-1.9302,1.5005,1.4061,-2.0528,1.3278,1.4061,-1.8581,1.4445,1.2407,-1.7261,1.6000,1.2407,-1.7930,1.6620,1.4061,-1.9302,1.5005,1.4061,-1.7261,1.6000,1.2407,-1.5812,1.7434,1.2407,-1.6425,1.8109,1.4061,-1.7930,1.6620,1.4061,-1.5812,1.7434,1.2407,-1.4243,1.8737,1.2407,-1.4795,1.9463,1.4061,-1.6425,1.8109,1.4061,-1.4243,1.8737,1.2407,-1.2568,1.9899,1.2407,-1.3055,2.0671,1.4061,-1.4795,1.9463,1.4061};
			return value;
		}
		private double[] getCoordinate_5_13_point_28()
		{
			double[] value = {-1.2568,1.9899,1.2407,-1.0799,2.0912,1.2407,-1.1217,2.1723,1.4061,-1.3055,2.0671,1.4061,-1.0799,2.0912,1.2407,-0.8948,2.1769,1.2407,-0.9295,2.2613,1.4061,-1.1217,2.1723,1.4061,-0.8948,2.1769,1.2407,-0.7030,2.2461,1.2407,-0.7303,2.3332,1.4061,-0.9295,2.2613,1.4061,-0.7030,2.2461,1.2407,-0.5060,2.2986,1.2407,-0.5256,2.3877,1.4061,-0.7303,2.3332,1.4061,-0.5060,2.2986,1.2407,-0.3051,2.3337,1.2407,-0.3169,2.4242,1.4061,-0.5256,2.3877,1.4061,-0.3051,2.3337,1.2407,-0.1020,2.3514,1.2407,-0.1059,2.4425,1.4061,-0.3169,2.4242,1.4061,-0.1020,2.3514,1.2407,0.1020,2.3514,1.2407,0.1059,2.4425,1.4061,-0.1059,2.4425,1.4061,0.1020,2.3514,1.2407,0.3051,2.3337,1.2407,0.3169,2.4242,1.4061,0.1059,2.4425,1.4061,0.3051,2.3337,1.2407,0.5060,2.2986,1.2407,0.5256,2.3877,1.4061,0.3169,2.4242,1.4061,0.5060,2.2986,1.2407,0.7030,2.2461,1.2407,0.7303,2.3332,1.4061,0.5256,2.3877,1.4061,0.7030,2.2461,1.2407,0.8948,2.1769,1.2407,0.9295,2.2613,1.4061,0.7303,2.3332,1.4061,0.8948,2.1769,1.2407,1.0799,2.0912,1.2407,1.1217,2.1723,1.4061,0.9295,2.2613,1.4061,1.0799,2.0912,1.2407,1.2568,1.9899,1.2407,1.3055,2.0671,1.4061,1.1217,2.1723,1.4061,1.2568,1.9899,1.2407,1.4243,1.8737,1.2407,1.4795,1.9463,1.4061,1.3055,2.0671,1.4061,1.4243,1.8737,1.2407,1.5812,1.7434,1.2407,1.6425,1.8109,1.4061,1.4795,1.9463,1.4061,1.5812,1.7434,1.2407,1.7261,1.6000,1.2407,1.7930,1.6620,1.4061,1.6425,1.8109,1.4061,1.7261,1.6000,1.2407,1.8581,1.4445,1.2407,1.9302,1.5005,1.4061,1.7930,1.6620,1.4061,1.8581,1.4445,1.2407,1.9762,1.2783,1.2407,2.0528,1.3278,1.4061,1.9302,1.5005,1.4061,1.9762,1.2783,1.2407,2.0794,1.1024,1.2407,2.1600,1.1452,1.4061,2.0528,1.3278,1.4061,2.0794,1.1024,1.2407,2.1670,0.9183,1.2407,2.2510,0.9539,1.4061,2.1600,1.1452,1.4061,2.1670,0.9183,1.2407,2.2384,0.7273,1.2407,2.3252,0.7555,1.4061,2.2510,0.9539,1.4061,-2.3252,0.7555,1.4061,-2.2510,0.9539,1.4061,-2.3458,0.9941,1.5782,-2.4230,0.7873,1.5782,-2.2510,0.9539,1.4061,-2.1600,1.1452,1.4061,-2.2509,1.1934,1.5782,-2.3458,0.9941,1.5782,-2.1600,1.1452,1.4061,-2.0528,1.3278,1.4061,-2.1392,1.3837,1.5782,-2.2509,1.1934,1.5782,-2.0528,1.3278,1.4061,-1.9302,1.5005,1.4061,-2.0114,1.5637,1.5782,-2.1392,1.3837,1.5782};
			return value;
		}
		private double[] getCoordinate_5_13_point_29()
		{
			double[] value = {-1.9302,1.5005,1.4061,-1.7930,1.6620,1.4061,-1.8685,1.7319,1.5782,-2.0114,1.5637,1.5782,-1.7930,1.6620,1.4061,-1.6425,1.8109,1.4061,-1.7116,1.8871,1.5782,-1.8685,1.7319,1.5782,-1.6425,1.8109,1.4061,-1.4795,1.9463,1.4061,-1.5418,2.0282,1.5782,-1.7116,1.8871,1.5782,-1.4795,1.9463,1.4061,-1.3055,2.0671,1.4061,-1.3605,2.1540,1.5782,-1.5418,2.0282,1.5782,-1.3055,2.0671,1.4061,-1.1217,2.1723,1.4061,-1.1689,2.2637,1.5782,-1.3605,2.1540,1.5782,-1.1217,2.1723,1.4061,-0.9295,2.2613,1.4061,-0.9686,2.3564,1.5782,-1.1689,2.2637,1.5782,-0.9295,2.2613,1.4061,-0.7303,2.3332,1.4061,-0.7610,2.4314,1.5782,-0.9686,2.3564,1.5782,-0.7303,2.3332,1.4061,-0.5256,2.3877,1.4061,-0.5477,2.4881,1.5782,-0.7610,2.4314,1.5782,-0.5256,2.3877,1.4061,-0.3169,2.4242,1.4061,-0.3303,2.5262,1.5782,-0.5477,2.4881,1.5782,-0.3169,2.4242,1.4061,-0.1059,2.4425,1.4061,-0.1104,2.5453,1.5782,-0.3303,2.5262,1.5782,-0.1059,2.4425,1.4061,0.1059,2.4425,1.4061,0.1104,2.5453,1.5782,-0.1104,2.5453,1.5782,0.1059,2.4425,1.4061,0.3169,2.4242,1.4061,0.3303,2.5262,1.5782,0.1104,2.5453,1.5782,0.3169,2.4242,1.4061,0.5256,2.3877,1.4061,0.5477,2.4881,1.5782,0.3303,2.5262,1.5782,0.5256,2.3877,1.4061,0.7303,2.3332,1.4061,0.7610,2.4314,1.5782,0.5477,2.4881,1.5782,0.7303,2.3332,1.4061,0.9295,2.2613,1.4061,0.9686,2.3564,1.5782,0.7610,2.4314,1.5782,0.9295,2.2613,1.4061,1.1217,2.1723,1.4061,1.1689,2.2637,1.5782,0.9686,2.3564,1.5782,1.1217,2.1723,1.4061,1.3055,2.0671,1.4061,1.3605,2.1540,1.5782,1.1689,2.2637,1.5782,1.3055,2.0671,1.4061,1.4795,1.9463,1.4061,1.5418,2.0282,1.5782,1.3605,2.1540,1.5782,1.4795,1.9463,1.4061,1.6425,1.8109,1.4061,1.7116,1.8871,1.5782,1.5418,2.0282,1.5782,1.6425,1.8109,1.4061,1.7930,1.6620,1.4061,1.8685,1.7319,1.5782,1.7116,1.8871,1.5782,1.7930,1.6620,1.4061,1.9302,1.5005,1.4061,2.0114,1.5637,1.5782,1.8685,1.7319,1.5782,1.9302,1.5005,1.4061,2.0528,1.3278,1.4061,2.1392,1.3837,1.5782,2.0114,1.5637,1.5782,2.0528,1.3278,1.4061,2.1600,1.1452,1.4061,2.2509,1.1934,1.5782,2.1392,1.3837,1.5782,2.1600,1.1452,1.4061,2.2510,0.9539,1.4061,2.3458,0.9941,1.5782,2.2509,1.1934,1.5782,2.2510,0.9539,1.4061,2.3252,0.7555,1.4061,2.4230,0.7873,1.5782,2.3458,0.9941,1.5782};
			return value;
		}
		private double[] getCoordinate_5_13_point_30()
		{
			double[] value = {-2.4230,0.7873,1.5782,-2.3458,0.9941,1.5782,-2.4516,1.0389,1.7578,-2.5324,0.8228,1.7578,-2.3458,0.9941,1.5782,-2.2509,1.1934,1.5782,-2.3525,1.2472,1.7578,-2.4516,1.0389,1.7578,-2.2509,1.1934,1.5782,-2.1392,1.3837,1.5782,-2.2357,1.4462,1.7578,-2.3525,1.2472,1.7578,-2.1392,1.3837,1.5782,-2.0114,1.5637,1.5782,-2.1022,1.6343,1.7578,-2.2357,1.4462,1.7578,-2.0114,1.5637,1.5782,-1.8685,1.7319,1.5782,-1.9528,1.8101,1.7578,-2.1022,1.6343,1.7578,-1.8685,1.7319,1.5782,-1.7116,1.8871,1.5782,-1.7888,1.9723,1.7578,-1.9528,1.8101,1.7578,-1.7116,1.8871,1.5782,-1.5418,2.0282,1.5782,-1.6114,2.1197,1.7578,-1.7888,1.9723,1.7578,-1.5418,2.0282,1.5782,-1.3605,2.1540,1.5782,-1.4219,2.2513,1.7578,-1.6114,2.1197,1.7578,-1.3605,2.1540,1.5782,-1.1689,2.2637,1.5782,-1.2217,2.3659,1.7578,-1.4219,2.2513,1.7578,-1.1689,2.2637,1.5782,-0.9686,2.3564,1.5782,-1.0123,2.4627,1.7578,-1.2217,2.3659,1.7578,-0.9686,2.3564,1.5782,-0.7610,2.4314,1.5782,-0.7953,2.5411,1.7578,-1.0123,2.4627,1.7578,-0.7610,2.4314,1.5782,-0.5477,2.4881,1.5782,-0.5724,2.6004,1.7578,-0.7953,2.5411,1.7578,-0.5477,2.4881,1.5782,-0.3303,2.5262,1.5782,-0.3452,2.6402,1.7578,-0.5724,2.6004,1.7578,-0.3303,2.5262,1.5782,-0.1104,2.5453,1.5782,-0.1153,2.6602,1.7578,-0.3452,2.6402,1.7578,-0.1104,2.5453,1.5782,0.1104,2.5453,1.5782,0.1153,2.6602,1.7578,-0.1153,2.6602,1.7578,0.1104,2.5453,1.5782,0.3303,2.5262,1.5782,0.3452,2.6402,1.7578,0.1153,2.6602,1.7578,0.3303,2.5262,1.5782,0.5477,2.4881,1.5782,0.5724,2.6004,1.7578,0.3452,2.6402,1.7578,0.5477,2.4881,1.5782,0.7610,2.4314,1.5782,0.7953,2.5411,1.7578,0.5724,2.6004,1.7578,0.7610,2.4314,1.5782,0.9686,2.3564,1.5782,1.0123,2.4627,1.7578,0.7953,2.5411,1.7578,0.9686,2.3564,1.5782,1.1689,2.2637,1.5782,1.2217,2.3659,1.7578,1.0123,2.4627,1.7578,1.1689,2.2637,1.5782,1.3605,2.1540,1.5782,1.4219,2.2513,1.7578,1.2217,2.3659,1.7578,1.3605,2.1540,1.5782,1.5418,2.0282,1.5782,1.6114,2.1197,1.7578,1.4219,2.2513,1.7578,1.5418,2.0282,1.5782,1.7116,1.8871,1.5782,1.7888,1.9723,1.7578,1.6114,2.1197,1.7578,1.7116,1.8871,1.5782,1.8685,1.7319,1.5782,1.9528,1.8101,1.7578,1.7888,1.9723,1.7578,1.8685,1.7319,1.5782,2.0114,1.5637,1.5782,2.1022,1.6343,1.7578,1.9528,1.8101,1.7578};
			return value;
		}
		private double[] getCoordinate_5_13_point_31()
		{
			double[] value = {2.0114,1.5637,1.5782,2.1392,1.3837,1.5782,2.2357,1.4462,1.7578,2.1022,1.6343,1.7578,2.1392,1.3837,1.5782,2.2509,1.1934,1.5782,2.3525,1.2472,1.7578,2.2357,1.4462,1.7578,2.2509,1.1934,1.5782,2.3458,0.9941,1.5782,2.4516,1.0389,1.7578,2.3525,1.2472,1.7578,2.3458,0.9941,1.5782,2.4230,0.7873,1.5782,2.5324,0.8228,1.7578,2.4516,1.0389,1.7578,-2.5324,0.8228,1.7578,-2.4516,1.0389,1.7578,-2.5692,1.0887,1.9458,-2.6538,0.8623,1.9458,-2.4516,1.0389,1.7578,-2.3525,1.2472,1.7578,-2.4653,1.3070,1.9458,-2.5692,1.0887,1.9458,-2.3525,1.2472,1.7578,-2.2357,1.4462,1.7578,-2.3429,1.5155,1.9458,-2.4653,1.3070,1.9458,-2.2357,1.4462,1.7578,-2.1022,1.6343,1.7578,-2.2029,1.7126,1.9458,-2.3429,1.5155,1.9458,-2.1022,1.6343,1.7578,-1.9528,1.8101,1.7578,-2.0464,1.8969,1.9458,-2.2029,1.7126,1.9458,-1.9528,1.8101,1.7578,-1.7888,1.9723,1.7578,-1.8746,2.0669,1.9458,-2.0464,1.8969,1.9458,-1.7888,1.9723,1.7578,-1.6114,2.1197,1.7578,-1.6886,2.2214,1.9458,-1.8746,2.0669,1.9458,-1.6114,2.1197,1.7578,-1.4219,2.2513,1.7578,-1.4900,2.3592,1.9458,-1.6886,2.2214,1.9458,-1.4219,2.2513,1.7578,-1.2217,2.3659,1.7578,-1.2802,2.4793,1.9458,-1.4900,2.3592,1.9458,-1.2217,2.3659,1.7578,-1.0123,2.4627,1.7578,-1.0608,2.5808,1.9458,-1.2802,2.4793,1.9458,-1.0123,2.4627,1.7578,-0.7953,2.5411,1.7578,-0.8335,2.6630,1.9458,-1.0608,2.5808,1.9458,-0.7953,2.5411,1.7578,-0.5724,2.6004,1.7578,-0.5998,2.7251,1.9458,-0.8335,2.6630,1.9458,-0.5724,2.6004,1.7578,-0.3452,2.6402,1.7578,-0.3617,2.7668,1.9458,-0.5998,2.7251,1.9458,-0.3452,2.6402,1.7578,-0.1153,2.6602,1.7578,-0.1209,2.7877,1.9458,-0.3617,2.7668,1.9458,-0.1153,2.6602,1.7578,0.1153,2.6602,1.7578,0.1209,2.7877,1.9458,-0.1209,2.7877,1.9458,0.1153,2.6602,1.7578,0.3452,2.6402,1.7578,0.3617,2.7668,1.9458,0.1209,2.7877,1.9458,0.3452,2.6402,1.7578,0.5724,2.6004,1.7578,0.5998,2.7251,1.9458,0.3617,2.7668,1.9458,0.5724,2.6004,1.7578,0.7953,2.5411,1.7578,0.8335,2.6630,1.9458,0.5998,2.7251,1.9458,0.7953,2.5411,1.7578,1.0123,2.4627,1.7578,1.0608,2.5808,1.9458,0.8335,2.6630,1.9458,1.0123,2.4627,1.7578,1.2217,2.3659,1.7578,1.2802,2.4793,1.9458,1.0608,2.5808,1.9458,1.2217,2.3659,1.7578,1.4219,2.2513,1.7578,1.4900,2.3592,1.9458,1.2802,2.4793,1.9458};
			return value;
		}
		private double[] getCoordinate_5_13_point_32()
		{
			double[] value = {1.4219,2.2513,1.7578,1.6114,2.1197,1.7578,1.6886,2.2214,1.9458,1.4900,2.3592,1.9458,1.6114,2.1197,1.7578,1.7888,1.9723,1.7578,1.8746,2.0669,1.9458,1.6886,2.2214,1.9458,1.7888,1.9723,1.7578,1.9528,1.8101,1.7578,2.0464,1.8969,1.9458,1.8746,2.0669,1.9458,1.9528,1.8101,1.7578,2.1022,1.6343,1.7578,2.2029,1.7126,1.9458,2.0464,1.8969,1.9458,2.1022,1.6343,1.7578,2.2357,1.4462,1.7578,2.3429,1.5155,1.9458,2.2029,1.7126,1.9458,2.2357,1.4462,1.7578,2.3525,1.2472,1.7578,2.4653,1.3070,1.9458,2.3429,1.5155,1.9458,2.3525,1.2472,1.7578,2.4516,1.0389,1.7578,2.5692,1.0887,1.9458,2.4653,1.3070,1.9458,2.4516,1.0389,1.7578,2.5324,0.8228,1.7578,2.6538,0.8623,1.9458,2.5692,1.0887,1.9458,-2.6538,0.8623,1.9458,-2.5692,1.0887,1.9458,-2.6989,1.1437,2.1430,-2.7878,0.9058,2.1430,-2.5692,1.0887,1.9458,-2.4653,1.3070,1.9458,-2.5898,1.3730,2.1430,-2.6989,1.1437,2.1430,-2.4653,1.3070,1.9458,-2.3429,1.5155,1.9458,-2.4613,1.5920,2.1430,-2.5898,1.3730,2.1430,-2.3429,1.5155,1.9458,-2.2029,1.7126,1.9458,-2.3142,1.7991,2.1430,-2.4613,1.5920,2.1430,-2.2029,1.7126,1.9458,-2.0464,1.8969,1.9458,-2.1498,1.9927,2.1430,-2.3142,1.7991,2.1430,-2.0464,1.8969,1.9458,-1.8746,2.0669,1.9458,-1.9693,2.1713,2.1430,-2.1498,1.9927,2.1430,-1.8746,2.0669,1.9458,-1.6886,2.2214,1.9458,-1.7739,2.3336,2.1430,-1.9693,2.1713,2.1430,-1.6886,2.2214,1.9458,-1.4900,2.3592,1.9458,-1.5653,2.4784,2.1430,-1.7739,2.3336,2.1430,-1.4900,2.3592,1.9458,-1.2802,2.4793,1.9458,-1.3449,2.6045,2.1430,-1.5653,2.4784,2.1430,-1.2802,2.4793,1.9458,-1.0608,2.5808,1.9458,-1.1144,2.7112,2.1430,-1.3449,2.6045,2.1430,-1.0608,2.5808,1.9458,-0.8335,2.6630,1.9458,-0.8756,2.7975,2.1430,-1.1144,2.7112,2.1430,-0.8335,2.6630,1.9458,-0.5998,2.7251,1.9458,-0.6301,2.8627,2.1430,-0.8756,2.7975,2.1430,-0.5998,2.7251,1.9458,-0.3617,2.7668,1.9458,-0.3800,2.9065,2.1430,-0.6301,2.8627,2.1430,-0.3617,2.7668,1.9458,-0.1209,2.7877,1.9458,-0.1270,2.9285,2.1430,-0.3800,2.9065,2.1430,-0.1209,2.7877,1.9458,0.1209,2.7877,1.9458,0.1270,2.9285,2.1430,-0.1270,2.9285,2.1430,0.1209,2.7877,1.9458,0.3617,2.7668,1.9458,0.3800,2.9065,2.1430,0.1270,2.9285,2.1430,0.3617,2.7668,1.9458,0.5998,2.7251,1.9458,0.6301,2.8627,2.1430,0.3800,2.9065,2.1430};
			return value;
		}
		private double[] getCoordinate_5_13_point_33()
		{
			double[] value = {0.5998,2.7251,1.9458,0.8335,2.6630,1.9458,0.8756,2.7975,2.1430,0.6301,2.8627,2.1430,0.8335,2.6630,1.9458,1.0608,2.5808,1.9458,1.1144,2.7112,2.1430,0.8756,2.7975,2.1430,1.0608,2.5808,1.9458,1.2802,2.4793,1.9458,1.3449,2.6045,2.1430,1.1144,2.7112,2.1430,1.2802,2.4793,1.9458,1.4900,2.3592,1.9458,1.5653,2.4784,2.1430,1.3449,2.6045,2.1430,1.4900,2.3592,1.9458,1.6886,2.2214,1.9458,1.7739,2.3336,2.1430,1.5653,2.4784,2.1430,1.6886,2.2214,1.9458,1.8746,2.0669,1.9458,1.9693,2.1713,2.1430,1.7739,2.3336,2.1430,1.8746,2.0669,1.9458,2.0464,1.8969,1.9458,2.1498,1.9927,2.1430,1.9693,2.1713,2.1430,2.0464,1.8969,1.9458,2.2029,1.7126,1.9458,2.3142,1.7991,2.1430,2.1498,1.9927,2.1430,2.2029,1.7126,1.9458,2.3429,1.5155,1.9458,2.4613,1.5920,2.1430,2.3142,1.7991,2.1430,2.3429,1.5155,1.9458,2.4653,1.3070,1.9458,2.5898,1.3730,2.1430,2.4613,1.5920,2.1430,2.4653,1.3070,1.9458,2.5692,1.0887,1.9458,2.6989,1.1437,2.1430,2.5898,1.3730,2.1430,2.5692,1.0887,1.9458,2.6538,0.8623,1.9458,2.7878,0.9058,2.1430,2.6989,1.1437,2.1430,-2.7878,0.9058,2.1430,-2.6989,1.1437,2.1430,-2.8416,1.2041,2.3504,-2.9351,0.9537,2.3504,-2.6989,1.1437,2.1430,-2.5898,1.3730,2.1430,-2.7267,1.4456,2.3504,-2.8416,1.2041,2.3504,-2.5898,1.3730,2.1430,-2.4613,1.5920,2.1430,-2.5913,1.6762,2.3504,-2.7267,1.4456,2.3504,-2.4613,1.5920,2.1430,-2.3142,1.7991,2.1430,-2.4365,1.8942,2.3504,-2.5913,1.6762,2.3504,-2.3142,1.7991,2.1430,-2.1498,1.9927,2.1430,-2.2634,2.0980,2.3504,-2.4365,1.8942,2.3504,-2.1498,1.9927,2.1430,-1.9693,2.1713,2.1430,-2.0733,2.2860,2.3504,-2.2634,2.0980,2.3504,-1.9693,2.1713,2.1430,-1.7739,2.3336,2.1430,-1.8677,2.4569,2.3504,-2.0733,2.2860,2.3504,-1.7739,2.3336,2.1430,-1.5653,2.4784,2.1430,-1.6480,2.6093,2.3504,-1.8677,2.4569,2.3504,-1.5653,2.4784,2.1430,-1.3449,2.6045,2.1430,-1.4160,2.7422,2.3504,-1.6480,2.6093,2.3504,-1.3449,2.6045,2.1430,-1.1144,2.7112,2.1430,-1.1733,2.8544,2.3504,-1.4160,2.7422,2.3504,-1.1144,2.7112,2.1430,-0.8756,2.7975,2.1430,-0.9218,2.9453,2.3504,-1.1733,2.8544,2.3504,-0.8756,2.7975,2.1430,-0.6301,2.8627,2.1430,-0.6634,3.0140,2.3504,-0.9218,2.9453,2.3504,-0.6301,2.8627,2.1430,-0.3800,2.9065,2.1430,-0.4001,3.0601,2.3504,-0.6634,3.0140,2.3504};
			return value;
		}
		private double[] getCoordinate_5_13_point_34()
		{
			double[] value = {-0.3800,2.9065,2.1430,-0.1270,2.9285,2.1430,-0.1337,3.0833,2.3504,-0.4001,3.0601,2.3504,-0.1270,2.9285,2.1430,0.1270,2.9285,2.1430,0.1337,3.0833,2.3504,-0.1337,3.0833,2.3504,0.1270,2.9285,2.1430,0.3800,2.9065,2.1430,0.4001,3.0601,2.3504,0.1337,3.0833,2.3504,0.3800,2.9065,2.1430,0.6301,2.8627,2.1430,0.6634,3.0140,2.3504,0.4001,3.0601,2.3504,0.6301,2.8627,2.1430,0.8756,2.7975,2.1430,0.9218,2.9453,2.3504,0.6634,3.0140,2.3504,0.8756,2.7975,2.1430,1.1144,2.7112,2.1430,1.1733,2.8544,2.3504,0.9218,2.9453,2.3504,1.1144,2.7112,2.1430,1.3449,2.6045,2.1430,1.4160,2.7422,2.3504,1.1733,2.8544,2.3504,1.3449,2.6045,2.1430,1.5653,2.4784,2.1430,1.6480,2.6093,2.3504,1.4160,2.7422,2.3504,1.5653,2.4784,2.1430,1.7739,2.3336,2.1430,1.8677,2.4569,2.3504,1.6480,2.6093,2.3504,1.7739,2.3336,2.1430,1.9693,2.1713,2.1430,2.0733,2.2860,2.3504,1.8677,2.4569,2.3504,1.9693,2.1713,2.1430,2.1498,1.9927,2.1430,2.2634,2.0980,2.3504,2.0733,2.2860,2.3504,2.1498,1.9927,2.1430,2.3142,1.7991,2.1430,2.4365,1.8942,2.3504,2.2634,2.0980,2.3504,2.3142,1.7991,2.1430,2.4613,1.5920,2.1430,2.5913,1.6762,2.3504,2.4365,1.8942,2.3504,2.4613,1.5920,2.1430,2.5898,1.3730,2.1430,2.7267,1.4456,2.3504,2.5913,1.6762,2.3504,2.5898,1.3730,2.1430,2.6989,1.1437,2.1430,2.8416,1.2041,2.3504,2.7267,1.4456,2.3504,2.6989,1.1437,2.1430,2.7878,0.9058,2.1430,2.9351,0.9537,2.3504,2.8416,1.2041,2.3504};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getNormal_5_14_vector_1()
		{
			double[] value = {0.7566,-0.2458,-0.6059,0.7325,-0.3104,-0.6059,0.7433,-0.3150,-0.5902,0.7678,-0.2495,-0.5902,0.7325,-0.3104,-0.6059,0.7029,-0.3726,-0.6059,0.7132,-0.3781,-0.5902,0.7433,-0.3150,-0.5902,0.7029,-0.3726,-0.6059,0.6680,-0.4321,-0.6059,0.6778,-0.4384,-0.5902,0.7132,-0.3781,-0.5902,0.6680,-0.4321,-0.6059,0.6281,-0.4883,-0.6059,0.6373,-0.4955,-0.5902,0.6778,-0.4384,-0.5902,0.6281,-0.4883,-0.6059,0.5835,-0.5408,-0.6059,0.5921,-0.5488,-0.5902,0.6373,-0.4955,-0.5902,0.5835,-0.5408,-0.6059,0.5345,-0.5893,-0.6059,0.5423,-0.5980,-0.5902,0.5921,-0.5488,-0.5902,0.5345,-0.5893,-0.6059,0.4814,-0.6333,-0.6059,0.4885,-0.6427,-0.5902,0.5423,-0.5980,-0.5902,0.4814,-0.6333,-0.6059,0.4248,-0.6726,-0.6059,0.4311,-0.6825,-0.5902,0.4885,-0.6427,-0.5902,0.4248,-0.6726,-0.6059,0.3650,-0.7069,-0.6059,0.3704,-0.7173,-0.5902,0.4311,-0.6825,-0.5902,0.3650,-0.7069,-0.6059,0.3025,-0.7358,-0.6059,0.3069,-0.7467,-0.5902,0.3704,-0.7173,-0.5902,0.3025,-0.7358,-0.6059,0.2376,-0.7592,-0.6059,0.2411,-0.7704,-0.5902,0.3069,-0.7467,-0.5902,0.2376,-0.7592,-0.6059,0.1710,-0.7770,-0.6059,0.1735,-0.7884,-0.5902,0.2411,-0.7704,-0.5902,0.1710,-0.7770,-0.6059,0.1031,-0.7888,-0.6059,0.1046,-0.8005,-0.5902,0.1735,-0.7884,-0.5902,0.1031,-0.7888,-0.6059,0.0345,-0.7948,-0.6059,0.0350,-0.8065,-0.5902,0.1046,-0.8005,-0.5902,0.0345,-0.7948,-0.6059,-0.0345,-0.7948,-0.6059,-0.0350,-0.8065,-0.5902,0.0350,-0.8065,-0.5902,-0.0345,-0.7948,-0.6059,-0.1031,-0.7888,-0.6059,-0.1046,-0.8005,-0.5902,-0.0350,-0.8065,-0.5902,-0.1031,-0.7888,-0.6059,-0.1710,-0.7770,-0.6059,-0.1735,-0.7884,-0.5902,-0.1046,-0.8005,-0.5902,-0.1710,-0.7770,-0.6059,-0.2376,-0.7592,-0.6059,-0.2411,-0.7704,-0.5902,-0.1735,-0.7884,-0.5902,-0.2376,-0.7592,-0.6059,-0.3025,-0.7358,-0.6059,-0.3069,-0.7467,-0.5902,-0.2411,-0.7704,-0.5902,-0.3025,-0.7358,-0.6059,-0.3650,-0.7069,-0.6059,-0.3704,-0.7173,-0.5902,-0.3069,-0.7467,-0.5902,-0.3650,-0.7069,-0.6059,-0.4248,-0.6726,-0.6059,-0.4311,-0.6825,-0.5902,-0.3704,-0.7173,-0.5902,-0.4248,-0.6726,-0.6059,-0.4814,-0.6333,-0.6059,-0.4885,-0.6427,-0.5902,-0.4311,-0.6825,-0.5902,-0.4814,-0.6333,-0.6059,-0.5345,-0.5893,-0.6059,-0.5423,-0.5980,-0.5902,-0.4885,-0.6427,-0.5902,-0.5345,-0.5893,-0.6059,-0.5835,-0.5408,-0.6059,-0.5921,-0.5488,-0.5902,-0.5423,-0.5980,-0.5902,-0.5835,-0.5408,-0.6059,-0.6281,-0.4883,-0.6059,-0.6373,-0.4955,-0.5902,-0.5921,-0.5488,-0.5902};
			return value;
		}
		private double[] getNormal_5_14_vector_2()
		{
			double[] value = {-0.6281,-0.4883,-0.6059,-0.6680,-0.4321,-0.6059,-0.6778,-0.4384,-0.5902,-0.6373,-0.4955,-0.5902,-0.6680,-0.4321,-0.6059,-0.7029,-0.3726,-0.6059,-0.7132,-0.3781,-0.5902,-0.6778,-0.4384,-0.5902,-0.7029,-0.3726,-0.6059,-0.7325,-0.3104,-0.6059,-0.7433,-0.3150,-0.5902,-0.7132,-0.3781,-0.5902,-0.7325,-0.3104,-0.6059,-0.7566,-0.2458,-0.6059,-0.7678,-0.2495,-0.5902,-0.7433,-0.3150,-0.5902,0.7678,-0.2495,-0.5902,0.7433,-0.3150,-0.5902,0.7552,-0.3200,-0.5720,0.7801,-0.2535,-0.5720,0.7433,-0.3150,-0.5902,0.7132,-0.3781,-0.5902,0.7247,-0.3842,-0.5720,0.7552,-0.3200,-0.5720,0.7132,-0.3781,-0.5902,0.6778,-0.4384,-0.5902,0.6887,-0.4455,-0.5720,0.7247,-0.3842,-0.5720,0.6778,-0.4384,-0.5902,0.6373,-0.4955,-0.5902,0.6476,-0.5034,-0.5720,0.6887,-0.4455,-0.5720,0.6373,-0.4955,-0.5902,0.5921,-0.5488,-0.5902,0.6016,-0.5576,-0.5720,0.6476,-0.5034,-0.5720,0.5921,-0.5488,-0.5902,0.5423,-0.5980,-0.5902,0.5511,-0.6076,-0.5720,0.6016,-0.5576,-0.5720,0.5423,-0.5980,-0.5902,0.4885,-0.6427,-0.5902,0.4964,-0.6530,-0.5720,0.5511,-0.6076,-0.5720,0.4885,-0.6427,-0.5902,0.4311,-0.6825,-0.5902,0.4380,-0.6935,-0.5720,0.4964,-0.6530,-0.5720,0.4311,-0.6825,-0.5902,0.3704,-0.7173,-0.5902,0.3763,-0.7288,-0.5720,0.4380,-0.6935,-0.5720,0.3704,-0.7173,-0.5902,0.3069,-0.7467,-0.5902,0.3118,-0.7587,-0.5720,0.3763,-0.7288,-0.5720,0.3069,-0.7467,-0.5902,0.2411,-0.7704,-0.5902,0.2450,-0.7828,-0.5720,0.3118,-0.7587,-0.5720,0.2411,-0.7704,-0.5902,0.1735,-0.7884,-0.5902,0.1763,-0.8011,-0.5720,0.2450,-0.7828,-0.5720,0.1735,-0.7884,-0.5902,0.1046,-0.8005,-0.5902,0.1063,-0.8133,-0.5720,0.1763,-0.8011,-0.5720,0.1046,-0.8005,-0.5902,0.0350,-0.8065,-0.5902,0.0355,-0.8195,-0.5720,0.1063,-0.8133,-0.5720,0.0350,-0.8065,-0.5902,-0.0350,-0.8065,-0.5902,-0.0355,-0.8195,-0.5720,0.0355,-0.8195,-0.5720,-0.0350,-0.8065,-0.5902,-0.1046,-0.8005,-0.5902,-0.1063,-0.8133,-0.5720,-0.0355,-0.8195,-0.5720,-0.1046,-0.8005,-0.5902,-0.1735,-0.7884,-0.5902,-0.1763,-0.8011,-0.5720,-0.1063,-0.8133,-0.5720,-0.1735,-0.7884,-0.5902,-0.2411,-0.7704,-0.5902,-0.2450,-0.7828,-0.5720,-0.1763,-0.8011,-0.5720,-0.2411,-0.7704,-0.5902,-0.3069,-0.7467,-0.5902,-0.3118,-0.7587,-0.5720,-0.2450,-0.7828,-0.5720,-0.3069,-0.7467,-0.5902,-0.3704,-0.7173,-0.5902,-0.3763,-0.7288,-0.5720,-0.3118,-0.7587,-0.5720,-0.3704,-0.7173,-0.5902,-0.4311,-0.6825,-0.5902,-0.4380,-0.6935,-0.5720,-0.3763,-0.7288,-0.5720};
			return value;
		}
		private double[] getNormal_5_14_vector_3()
		{
			double[] value = {-0.4311,-0.6825,-0.5902,-0.4885,-0.6427,-0.5902,-0.4964,-0.6530,-0.5720,-0.4380,-0.6935,-0.5720,-0.4885,-0.6427,-0.5902,-0.5423,-0.5980,-0.5902,-0.5511,-0.6076,-0.5720,-0.4964,-0.6530,-0.5720,-0.5423,-0.5980,-0.5902,-0.5921,-0.5488,-0.5902,-0.6016,-0.5576,-0.5720,-0.5511,-0.6076,-0.5720,-0.5921,-0.5488,-0.5902,-0.6373,-0.4955,-0.5902,-0.6476,-0.5034,-0.5720,-0.6016,-0.5576,-0.5720,-0.6373,-0.4955,-0.5902,-0.6778,-0.4384,-0.5902,-0.6887,-0.4455,-0.5720,-0.6476,-0.5034,-0.5720,-0.6778,-0.4384,-0.5902,-0.7132,-0.3781,-0.5902,-0.7247,-0.3842,-0.5720,-0.6887,-0.4455,-0.5720,-0.7132,-0.3781,-0.5902,-0.7433,-0.3150,-0.5902,-0.7552,-0.3200,-0.5720,-0.7247,-0.3842,-0.5720,-0.7433,-0.3150,-0.5902,-0.7678,-0.2495,-0.5902,-0.7801,-0.2535,-0.5720,-0.7552,-0.3200,-0.5720,0.7801,-0.2535,-0.5720,0.7552,-0.3200,-0.5720,0.7684,-0.3256,-0.5509,0.7937,-0.2579,-0.5509,0.7552,-0.3200,-0.5720,0.7247,-0.3842,-0.5720,0.7373,-0.3909,-0.5509,0.7684,-0.3256,-0.5509,0.7247,-0.3842,-0.5720,0.6887,-0.4455,-0.5720,0.7007,-0.4533,-0.5509,0.7373,-0.3909,-0.5509,0.6887,-0.4455,-0.5720,0.6476,-0.5034,-0.5720,0.6589,-0.5122,-0.5509,0.7007,-0.4533,-0.5509,0.6476,-0.5034,-0.5720,0.6016,-0.5576,-0.5720,0.6121,-0.5673,-0.5509,0.6589,-0.5122,-0.5509,0.6016,-0.5576,-0.5720,0.5511,-0.6076,-0.5720,0.5607,-0.6182,-0.5509,0.6121,-0.5673,-0.5509,0.5511,-0.6076,-0.5720,0.4964,-0.6530,-0.5720,0.5050,-0.6644,-0.5509,0.5607,-0.6182,-0.5509,0.4964,-0.6530,-0.5720,0.4380,-0.6935,-0.5720,0.4456,-0.7056,-0.5509,0.5050,-0.6644,-0.5509,0.4380,-0.6935,-0.5720,0.3763,-0.7288,-0.5720,0.3829,-0.7415,-0.5509,0.4456,-0.7056,-0.5509,0.3763,-0.7288,-0.5720,0.3118,-0.7587,-0.5720,0.3173,-0.7719,-0.5509,0.3829,-0.7415,-0.5509,0.3118,-0.7587,-0.5720,0.2450,-0.7828,-0.5720,0.2493,-0.7964,-0.5509,0.3173,-0.7719,-0.5509,0.2450,-0.7828,-0.5720,0.1763,-0.8011,-0.5720,0.1794,-0.8150,-0.5509,0.2493,-0.7964,-0.5509,0.1763,-0.8011,-0.5720,0.1063,-0.8133,-0.5720,0.1082,-0.8275,-0.5509,0.1794,-0.8150,-0.5509,0.1063,-0.8133,-0.5720,0.0355,-0.8195,-0.5720,0.0362,-0.8338,-0.5509,0.1082,-0.8275,-0.5509,0.0355,-0.8195,-0.5720,-0.0355,-0.8195,-0.5720,-0.0362,-0.8338,-0.5509,0.0362,-0.8338,-0.5509,-0.0355,-0.8195,-0.5720,-0.1063,-0.8133,-0.5720,-0.1082,-0.8275,-0.5509,-0.0362,-0.8338,-0.5509,-0.1063,-0.8133,-0.5720,-0.1763,-0.8011,-0.5720,-0.1794,-0.8150,-0.5509,-0.1082,-0.8275,-0.5509};
			return value;
		}
		private double[] getNormal_5_14_vector_4()
		{
			double[] value = {-0.1763,-0.8011,-0.5720,-0.2450,-0.7828,-0.5720,-0.2493,-0.7964,-0.5509,-0.1794,-0.8150,-0.5509,-0.2450,-0.7828,-0.5720,-0.3118,-0.7587,-0.5720,-0.3173,-0.7719,-0.5509,-0.2493,-0.7964,-0.5509,-0.3118,-0.7587,-0.5720,-0.3763,-0.7288,-0.5720,-0.3829,-0.7415,-0.5509,-0.3173,-0.7719,-0.5509,-0.3763,-0.7288,-0.5720,-0.4380,-0.6935,-0.5720,-0.4456,-0.7056,-0.5509,-0.3829,-0.7415,-0.5509,-0.4380,-0.6935,-0.5720,-0.4964,-0.6530,-0.5720,-0.5050,-0.6644,-0.5509,-0.4456,-0.7056,-0.5509,-0.4964,-0.6530,-0.5720,-0.5511,-0.6076,-0.5720,-0.5607,-0.6182,-0.5509,-0.5050,-0.6644,-0.5509,-0.5511,-0.6076,-0.5720,-0.6016,-0.5576,-0.5720,-0.6121,-0.5673,-0.5509,-0.5607,-0.6182,-0.5509,-0.6016,-0.5576,-0.5720,-0.6476,-0.5034,-0.5720,-0.6589,-0.5122,-0.5509,-0.6121,-0.5673,-0.5509,-0.6476,-0.5034,-0.5720,-0.6887,-0.4455,-0.5720,-0.7007,-0.4533,-0.5509,-0.6589,-0.5122,-0.5509,-0.6887,-0.4455,-0.5720,-0.7247,-0.3842,-0.5720,-0.7373,-0.3909,-0.5509,-0.7007,-0.4533,-0.5509,-0.7247,-0.3842,-0.5720,-0.7552,-0.3200,-0.5720,-0.7684,-0.3256,-0.5509,-0.7373,-0.3909,-0.5509,-0.7552,-0.3200,-0.5720,-0.7801,-0.2535,-0.5720,-0.7937,-0.2579,-0.5509,-0.7684,-0.3256,-0.5509,0.7937,-0.2579,-0.5509,0.7684,-0.3256,-0.5509,0.7827,-0.3317,-0.5266,0.8085,-0.2627,-0.5266,0.7684,-0.3256,-0.5509,0.7373,-0.3909,-0.5509,0.7511,-0.3982,-0.5266,0.7827,-0.3317,-0.5266,0.7373,-0.3909,-0.5509,0.7007,-0.4533,-0.5509,0.7138,-0.4617,-0.5266,0.7511,-0.3982,-0.5266,0.7007,-0.4533,-0.5509,0.6589,-0.5122,-0.5509,0.6712,-0.5218,-0.5266,0.7138,-0.4617,-0.5266,0.6589,-0.5122,-0.5509,0.6121,-0.5673,-0.5509,0.6235,-0.5779,-0.5266,0.6712,-0.5218,-0.5266,0.6121,-0.5673,-0.5509,0.5607,-0.6182,-0.5509,0.5711,-0.6297,-0.5266,0.6235,-0.5779,-0.5266,0.5607,-0.6182,-0.5509,0.5050,-0.6644,-0.5509,0.5145,-0.6768,-0.5266,0.5711,-0.6297,-0.5266,0.5050,-0.6644,-0.5509,0.4456,-0.7056,-0.5509,0.4540,-0.7188,-0.5266,0.5145,-0.6768,-0.5266,0.4456,-0.7056,-0.5509,0.3829,-0.7415,-0.5509,0.3900,-0.7553,-0.5266,0.4540,-0.7188,-0.5266,0.3829,-0.7415,-0.5509,0.3173,-0.7719,-0.5509,0.3232,-0.7863,-0.5266,0.3900,-0.7553,-0.5266,0.3173,-0.7719,-0.5509,0.2493,-0.7964,-0.5509,0.2539,-0.8113,-0.5266,0.3232,-0.7863,-0.5266,0.2493,-0.7964,-0.5509,0.1794,-0.8150,-0.5509,0.1827,-0.8302,-0.5266,0.2539,-0.8113,-0.5266,0.1794,-0.8150,-0.5509,0.1082,-0.8275,-0.5509,0.1102,-0.8429,-0.5266,0.1827,-0.8302,-0.5266};
			return value;
		}
		private double[] getNormal_5_14_vector_5()
		{
			double[] value = {0.1082,-0.8275,-0.5509,0.0362,-0.8338,-0.5509,0.0368,-0.8493,-0.5266,0.1102,-0.8429,-0.5266,0.0362,-0.8338,-0.5509,-0.0362,-0.8338,-0.5509,-0.0368,-0.8493,-0.5266,0.0368,-0.8493,-0.5266,-0.0362,-0.8338,-0.5509,-0.1082,-0.8275,-0.5509,-0.1102,-0.8429,-0.5266,-0.0368,-0.8493,-0.5266,-0.1082,-0.8275,-0.5509,-0.1794,-0.8150,-0.5509,-0.1827,-0.8302,-0.5266,-0.1102,-0.8429,-0.5266,-0.1794,-0.8150,-0.5509,-0.2493,-0.7964,-0.5509,-0.2539,-0.8113,-0.5266,-0.1827,-0.8302,-0.5266,-0.2493,-0.7964,-0.5509,-0.3173,-0.7719,-0.5509,-0.3232,-0.7863,-0.5266,-0.2539,-0.8113,-0.5266,-0.3173,-0.7719,-0.5509,-0.3829,-0.7415,-0.5509,-0.3900,-0.7553,-0.5266,-0.3232,-0.7863,-0.5266,-0.3829,-0.7415,-0.5509,-0.4456,-0.7056,-0.5509,-0.4540,-0.7188,-0.5266,-0.3900,-0.7553,-0.5266,-0.4456,-0.7056,-0.5509,-0.5050,-0.6644,-0.5509,-0.5145,-0.6768,-0.5266,-0.4540,-0.7188,-0.5266,-0.5050,-0.6644,-0.5509,-0.5607,-0.6182,-0.5509,-0.5711,-0.6297,-0.5266,-0.5145,-0.6768,-0.5266,-0.5607,-0.6182,-0.5509,-0.6121,-0.5673,-0.5509,-0.6235,-0.5779,-0.5266,-0.5711,-0.6297,-0.5266,-0.6121,-0.5673,-0.5509,-0.6589,-0.5122,-0.5509,-0.6712,-0.5218,-0.5266,-0.6235,-0.5779,-0.5266,-0.6589,-0.5122,-0.5509,-0.7007,-0.4533,-0.5509,-0.7138,-0.4617,-0.5266,-0.6712,-0.5218,-0.5266,-0.7007,-0.4533,-0.5509,-0.7373,-0.3909,-0.5509,-0.7511,-0.3982,-0.5266,-0.7138,-0.4617,-0.5266,-0.7373,-0.3909,-0.5509,-0.7684,-0.3256,-0.5509,-0.7827,-0.3317,-0.5266,-0.7511,-0.3982,-0.5266,-0.7684,-0.3256,-0.5509,-0.7937,-0.2579,-0.5509,-0.8085,-0.2627,-0.5266,-0.7827,-0.3317,-0.5266,0.8085,-0.2627,-0.5266,0.7827,-0.3317,-0.5266,0.7981,-0.3382,-0.4986,0.8244,-0.2679,-0.4986,0.7827,-0.3317,-0.5266,0.7511,-0.3982,-0.5266,0.7659,-0.4060,-0.4986,0.7981,-0.3382,-0.4986,0.7511,-0.3982,-0.5266,0.7138,-0.4617,-0.5266,0.7279,-0.4708,-0.4986,0.7659,-0.4060,-0.4986,0.7138,-0.4617,-0.5266,0.6712,-0.5218,-0.5266,0.6844,-0.5320,-0.4986,0.7279,-0.4708,-0.4986,0.6712,-0.5218,-0.5266,0.6235,-0.5779,-0.5266,0.6358,-0.5893,-0.4986,0.6844,-0.5320,-0.4986,0.6235,-0.5779,-0.5266,0.5711,-0.6297,-0.5266,0.5824,-0.6421,-0.4986,0.6358,-0.5893,-0.4986,0.5711,-0.6297,-0.5266,0.5145,-0.6768,-0.5266,0.5246,-0.6901,-0.4986,0.5824,-0.6421,-0.4986,0.5145,-0.6768,-0.5266,0.4540,-0.7188,-0.5266,0.4629,-0.7329,-0.4986,0.5246,-0.6901,-0.4986,0.4540,-0.7188,-0.5266,0.3900,-0.7553,-0.5266,0.3977,-0.7702,-0.4986,0.4629,-0.7329,-0.4986};
			return value;
		}
		private double[] getNormal_5_14_vector_6()
		{
			double[] value = {0.3900,-0.7553,-0.5266,0.3232,-0.7863,-0.5266,0.3296,-0.8018,-0.4986,0.3977,-0.7702,-0.4986,0.3232,-0.7863,-0.5266,0.2539,-0.8113,-0.5266,0.2589,-0.8273,-0.4986,0.3296,-0.8018,-0.4986,0.2539,-0.8113,-0.5266,0.1827,-0.8302,-0.5266,0.1863,-0.8466,-0.4986,0.2589,-0.8273,-0.4986,0.1827,-0.8302,-0.5266,0.1102,-0.8429,-0.5266,0.1124,-0.8595,-0.4986,0.1863,-0.8466,-0.4986,0.1102,-0.8429,-0.5266,0.0368,-0.8493,-0.5266,0.0376,-0.8660,-0.4986,0.1124,-0.8595,-0.4986,0.0368,-0.8493,-0.5266,-0.0368,-0.8493,-0.5266,-0.0376,-0.8660,-0.4986,0.0376,-0.8660,-0.4986,-0.0368,-0.8493,-0.5266,-0.1102,-0.8429,-0.5266,-0.1124,-0.8595,-0.4986,-0.0376,-0.8660,-0.4986,-0.1102,-0.8429,-0.5266,-0.1827,-0.8302,-0.5266,-0.1863,-0.8466,-0.4986,-0.1124,-0.8595,-0.4986,-0.1827,-0.8302,-0.5266,-0.2539,-0.8113,-0.5266,-0.2589,-0.8273,-0.4986,-0.1863,-0.8466,-0.4986,-0.2539,-0.8113,-0.5266,-0.3232,-0.7863,-0.5266,-0.3296,-0.8018,-0.4986,-0.2589,-0.8273,-0.4986,-0.3232,-0.7863,-0.5266,-0.3900,-0.7553,-0.5266,-0.3977,-0.7702,-0.4986,-0.3296,-0.8018,-0.4986,-0.3900,-0.7553,-0.5266,-0.4540,-0.7188,-0.5266,-0.4629,-0.7329,-0.4986,-0.3977,-0.7702,-0.4986,-0.4540,-0.7188,-0.5266,-0.5145,-0.6768,-0.5266,-0.5246,-0.6901,-0.4986,-0.4629,-0.7329,-0.4986,-0.5145,-0.6768,-0.5266,-0.5711,-0.6297,-0.5266,-0.5824,-0.6421,-0.4986,-0.5246,-0.6901,-0.4986,-0.5711,-0.6297,-0.5266,-0.6235,-0.5779,-0.5266,-0.6358,-0.5893,-0.4986,-0.5824,-0.6421,-0.4986,-0.6235,-0.5779,-0.5266,-0.6712,-0.5218,-0.5266,-0.6844,-0.5320,-0.4986,-0.6358,-0.5893,-0.4986,-0.6712,-0.5218,-0.5266,-0.7138,-0.4617,-0.5266,-0.7279,-0.4708,-0.4986,-0.6844,-0.5320,-0.4986,-0.7138,-0.4617,-0.5266,-0.7511,-0.3982,-0.5266,-0.7659,-0.4060,-0.4986,-0.7279,-0.4708,-0.4986,-0.7511,-0.3982,-0.5266,-0.7827,-0.3317,-0.5266,-0.7981,-0.3382,-0.4986,-0.7659,-0.4060,-0.4986,-0.7827,-0.3317,-0.5266,-0.8085,-0.2627,-0.5266,-0.8244,-0.2679,-0.4986,-0.7981,-0.3382,-0.4986,0.8244,-0.2679,-0.4986,0.7981,-0.3382,-0.4986,0.8145,-0.3452,-0.4663,0.8413,-0.2734,-0.4663,0.7981,-0.3382,-0.4986,0.7659,-0.4060,-0.4986,0.7816,-0.4144,-0.4663,0.8145,-0.3452,-0.4663,0.7659,-0.4060,-0.4986,0.7279,-0.4708,-0.4986,0.7428,-0.4805,-0.4663,0.7816,-0.4144,-0.4663,0.7279,-0.4708,-0.4986,0.6844,-0.5320,-0.4986,0.6984,-0.5429,-0.4663,0.7428,-0.4805,-0.4663,0.6844,-0.5320,-0.4986,0.6358,-0.5893,-0.4986,0.6488,-0.6014,-0.4663,0.6984,-0.5429,-0.4663};
			return value;
		}
		private double[] getNormal_5_14_vector_7()
		{
			double[] value = {0.6358,-0.5893,-0.4986,0.5824,-0.6421,-0.4986,0.5943,-0.6553,-0.4663,0.6488,-0.6014,-0.4663,0.5824,-0.6421,-0.4986,0.5246,-0.6901,-0.4986,0.5353,-0.7042,-0.4663,0.5943,-0.6553,-0.4663,0.5246,-0.6901,-0.4986,0.4629,-0.7329,-0.4986,0.4724,-0.7479,-0.4663,0.5353,-0.7042,-0.4663,0.4629,-0.7329,-0.4986,0.3977,-0.7702,-0.4986,0.4059,-0.7860,-0.4663,0.4724,-0.7479,-0.4663,0.3977,-0.7702,-0.4986,0.3296,-0.8018,-0.4986,0.3363,-0.8182,-0.4663,0.4059,-0.7860,-0.4663,0.3296,-0.8018,-0.4986,0.2589,-0.8273,-0.4986,0.2642,-0.8442,-0.4663,0.3363,-0.8182,-0.4663,0.2589,-0.8273,-0.4986,0.1863,-0.8466,-0.4986,0.1902,-0.8639,-0.4663,0.2642,-0.8442,-0.4663,0.1863,-0.8466,-0.4986,0.1124,-0.8595,-0.4986,0.1147,-0.8771,-0.4663,0.1902,-0.8639,-0.4663,0.1124,-0.8595,-0.4986,0.0376,-0.8660,-0.4986,0.0383,-0.8838,-0.4663,0.1147,-0.8771,-0.4663,0.0376,-0.8660,-0.4986,-0.0376,-0.8660,-0.4986,-0.0383,-0.8838,-0.4663,0.0383,-0.8838,-0.4663,-0.0376,-0.8660,-0.4986,-0.1124,-0.8595,-0.4986,-0.1147,-0.8771,-0.4663,-0.0383,-0.8838,-0.4663,-0.1124,-0.8595,-0.4986,-0.1863,-0.8466,-0.4986,-0.1902,-0.8639,-0.4663,-0.1147,-0.8771,-0.4663,-0.1863,-0.8466,-0.4986,-0.2589,-0.8273,-0.4986,-0.2642,-0.8442,-0.4663,-0.1902,-0.8639,-0.4663,-0.2589,-0.8273,-0.4986,-0.3296,-0.8018,-0.4986,-0.3363,-0.8182,-0.4663,-0.2642,-0.8442,-0.4663,-0.3296,-0.8018,-0.4986,-0.3977,-0.7702,-0.4986,-0.4059,-0.7860,-0.4663,-0.3363,-0.8182,-0.4663,-0.3977,-0.7702,-0.4986,-0.4629,-0.7329,-0.4986,-0.4724,-0.7479,-0.4663,-0.4059,-0.7860,-0.4663,-0.4629,-0.7329,-0.4986,-0.5246,-0.6901,-0.4986,-0.5353,-0.7042,-0.4663,-0.4724,-0.7479,-0.4663,-0.5246,-0.6901,-0.4986,-0.5824,-0.6421,-0.4986,-0.5943,-0.6553,-0.4663,-0.5353,-0.7042,-0.4663,-0.5824,-0.6421,-0.4986,-0.6358,-0.5893,-0.4986,-0.6488,-0.6014,-0.4663,-0.5943,-0.6553,-0.4663,-0.6358,-0.5893,-0.4986,-0.6844,-0.5320,-0.4986,-0.6984,-0.5429,-0.4663,-0.6488,-0.6014,-0.4663,-0.6844,-0.5320,-0.4986,-0.7279,-0.4708,-0.4986,-0.7428,-0.4805,-0.4663,-0.6984,-0.5429,-0.4663,-0.7279,-0.4708,-0.4986,-0.7659,-0.4060,-0.4986,-0.7816,-0.4144,-0.4663,-0.7428,-0.4805,-0.4663,-0.7659,-0.4060,-0.4986,-0.7981,-0.3382,-0.4986,-0.8145,-0.3452,-0.4663,-0.7816,-0.4144,-0.4663,-0.7981,-0.3382,-0.4986,-0.8244,-0.2679,-0.4986,-0.8413,-0.2734,-0.4663,-0.8145,-0.3452,-0.4663,0.8413,-0.2734,-0.4663,0.8145,-0.3452,-0.4663,0.8315,-0.3524,-0.4295,0.8589,-0.2791,-0.4295};
			return value;
		}
		private double[] getNormal_5_14_vector_8()
		{
			double[] value = {0.8145,-0.3452,-0.4663,0.7816,-0.4144,-0.4663,0.7979,-0.4230,-0.4295,0.8315,-0.3524,-0.4295,0.7816,-0.4144,-0.4663,0.7428,-0.4805,-0.4663,0.7583,-0.4905,-0.4295,0.7979,-0.4230,-0.4295,0.7428,-0.4805,-0.4663,0.6984,-0.5429,-0.4663,0.7130,-0.5543,-0.4295,0.7583,-0.4905,-0.4295,0.6984,-0.5429,-0.4663,0.6488,-0.6014,-0.4663,0.6623,-0.6139,-0.4295,0.7130,-0.5543,-0.4295,0.6488,-0.6014,-0.4663,0.5943,-0.6553,-0.4663,0.6067,-0.6689,-0.4295,0.6623,-0.6139,-0.4295,0.5943,-0.6553,-0.4663,0.5353,-0.7042,-0.4663,0.5465,-0.7189,-0.4295,0.6067,-0.6689,-0.4295,0.5353,-0.7042,-0.4663,0.4724,-0.7479,-0.4663,0.4822,-0.7635,-0.4295,0.5465,-0.7189,-0.4295,0.4724,-0.7479,-0.4663,0.4059,-0.7860,-0.4663,0.4143,-0.8024,-0.4295,0.4822,-0.7635,-0.4295,0.4059,-0.7860,-0.4663,0.3363,-0.8182,-0.4663,0.3433,-0.8353,-0.4295,0.4143,-0.8024,-0.4295,0.3363,-0.8182,-0.4663,0.2642,-0.8442,-0.4663,0.2697,-0.8619,-0.4295,0.3433,-0.8353,-0.4295,0.2642,-0.8442,-0.4663,0.1902,-0.8639,-0.4663,0.1941,-0.8820,-0.4295,0.2697,-0.8619,-0.4295,0.1902,-0.8639,-0.4663,0.1147,-0.8771,-0.4663,0.1171,-0.8955,-0.4295,0.1941,-0.8820,-0.4295,0.1147,-0.8771,-0.4663,0.0383,-0.8838,-0.4663,0.0391,-0.9022,-0.4295,0.1171,-0.8955,-0.4295,0.0383,-0.8838,-0.4663,-0.0383,-0.8838,-0.4663,-0.0391,-0.9022,-0.4295,0.0391,-0.9022,-0.4295,-0.0383,-0.8838,-0.4663,-0.1147,-0.8771,-0.4663,-0.1171,-0.8955,-0.4295,-0.0391,-0.9022,-0.4295,-0.1147,-0.8771,-0.4663,-0.1902,-0.8639,-0.4663,-0.1941,-0.8820,-0.4295,-0.1171,-0.8955,-0.4295,-0.1902,-0.8639,-0.4663,-0.2642,-0.8442,-0.4663,-0.2697,-0.8619,-0.4295,-0.1941,-0.8820,-0.4295,-0.2642,-0.8442,-0.4663,-0.3363,-0.8182,-0.4663,-0.3433,-0.8353,-0.4295,-0.2697,-0.8619,-0.4295,-0.3363,-0.8182,-0.4663,-0.4059,-0.7860,-0.4663,-0.4143,-0.8024,-0.4295,-0.3433,-0.8353,-0.4295,-0.4059,-0.7860,-0.4663,-0.4724,-0.7479,-0.4663,-0.4822,-0.7635,-0.4295,-0.4143,-0.8024,-0.4295,-0.4724,-0.7479,-0.4663,-0.5353,-0.7042,-0.4663,-0.5465,-0.7189,-0.4295,-0.4822,-0.7635,-0.4295,-0.5353,-0.7042,-0.4663,-0.5943,-0.6553,-0.4663,-0.6067,-0.6689,-0.4295,-0.5465,-0.7189,-0.4295,-0.5943,-0.6553,-0.4663,-0.6488,-0.6014,-0.4663,-0.6623,-0.6139,-0.4295,-0.6067,-0.6689,-0.4295,-0.6488,-0.6014,-0.4663,-0.6984,-0.5429,-0.4663,-0.7130,-0.5543,-0.4295,-0.6623,-0.6139,-0.4295,-0.6984,-0.5429,-0.4663,-0.7428,-0.4805,-0.4663,-0.7583,-0.4905,-0.4295,-0.7130,-0.5543,-0.4295};
			return value;
		}
		private double[] getNormal_5_14_vector_9()
		{
			double[] value = {-0.7428,-0.4805,-0.4663,-0.7816,-0.4144,-0.4663,-0.7979,-0.4230,-0.4295,-0.7583,-0.4905,-0.4295,-0.7816,-0.4144,-0.4663,-0.8145,-0.3452,-0.4663,-0.8315,-0.3524,-0.4295,-0.7979,-0.4230,-0.4295,-0.8145,-0.3452,-0.4663,-0.8413,-0.2734,-0.4663,-0.8589,-0.2791,-0.4295,-0.8315,-0.3524,-0.4295,0.8589,-0.2791,-0.4295,0.8315,-0.3524,-0.4295,0.8488,-0.3597,-0.3876,0.8767,-0.2849,-0.3876,0.8315,-0.3524,-0.4295,0.7979,-0.4230,-0.4295,0.8144,-0.4318,-0.3876,0.8488,-0.3597,-0.3876,0.7979,-0.4230,-0.4295,0.7583,-0.4905,-0.4295,0.7740,-0.5007,-0.3876,0.8144,-0.4318,-0.3876,0.7583,-0.4905,-0.4295,0.7130,-0.5543,-0.4295,0.7278,-0.5658,-0.3876,0.7740,-0.5007,-0.3876,0.7130,-0.5543,-0.4295,0.6623,-0.6139,-0.4295,0.6761,-0.6267,-0.3876,0.7278,-0.5658,-0.3876,0.6623,-0.6139,-0.4295,0.6067,-0.6689,-0.4295,0.6193,-0.6828,-0.3876,0.6761,-0.6267,-0.3876,0.6067,-0.6689,-0.4295,0.5465,-0.7189,-0.4295,0.5579,-0.7339,-0.3876,0.6193,-0.6828,-0.3876,0.5465,-0.7189,-0.4295,0.4822,-0.7635,-0.4295,0.4923,-0.7794,-0.3876,0.5579,-0.7339,-0.3876,0.4822,-0.7635,-0.4295,0.4143,-0.8024,-0.4295,0.4229,-0.8191,-0.3876,0.4923,-0.7794,-0.3876,0.4143,-0.8024,-0.4295,0.3433,-0.8353,-0.4295,0.3505,-0.8526,-0.3876,0.4229,-0.8191,-0.3876,0.3433,-0.8353,-0.4295,0.2697,-0.8619,-0.4295,0.2753,-0.8797,-0.3876,0.3505,-0.8526,-0.3876,0.2697,-0.8619,-0.4295,0.1941,-0.8820,-0.4295,0.1982,-0.9003,-0.3876,0.2753,-0.8797,-0.3876,0.1941,-0.8820,-0.4295,0.1171,-0.8955,-0.4295,0.1195,-0.9140,-0.3876,0.1982,-0.9003,-0.3876,0.1171,-0.8955,-0.4295,0.0391,-0.9022,-0.4295,0.0399,-0.9210,-0.3876,0.1195,-0.9140,-0.3876,0.0391,-0.9022,-0.4295,-0.0391,-0.9022,-0.4295,-0.0399,-0.9210,-0.3876,0.0399,-0.9210,-0.3876,-0.0391,-0.9022,-0.4295,-0.1171,-0.8955,-0.4295,-0.1195,-0.9140,-0.3876,-0.0399,-0.9210,-0.3876,-0.1171,-0.8955,-0.4295,-0.1941,-0.8820,-0.4295,-0.1982,-0.9003,-0.3876,-0.1195,-0.9140,-0.3876,-0.1941,-0.8820,-0.4295,-0.2697,-0.8619,-0.4295,-0.2753,-0.8797,-0.3876,-0.1982,-0.9003,-0.3876,-0.2697,-0.8619,-0.4295,-0.3433,-0.8353,-0.4295,-0.3505,-0.8526,-0.3876,-0.2753,-0.8797,-0.3876,-0.3433,-0.8353,-0.4295,-0.4143,-0.8024,-0.4295,-0.4229,-0.8191,-0.3876,-0.3505,-0.8526,-0.3876,-0.4143,-0.8024,-0.4295,-0.4822,-0.7635,-0.4295,-0.4923,-0.7794,-0.3876,-0.4229,-0.8191,-0.3876,-0.4822,-0.7635,-0.4295,-0.5465,-0.7189,-0.4295,-0.5579,-0.7339,-0.3876,-0.4923,-0.7794,-0.3876};
			return value;
		}
		private double[] getNormal_5_14_vector_10()
		{
			double[] value = {-0.5465,-0.7189,-0.4295,-0.6067,-0.6689,-0.4295,-0.6193,-0.6828,-0.3876,-0.5579,-0.7339,-0.3876,-0.6067,-0.6689,-0.4295,-0.6623,-0.6139,-0.4295,-0.6761,-0.6267,-0.3876,-0.6193,-0.6828,-0.3876,-0.6623,-0.6139,-0.4295,-0.7130,-0.5543,-0.4295,-0.7278,-0.5658,-0.3876,-0.6761,-0.6267,-0.3876,-0.7130,-0.5543,-0.4295,-0.7583,-0.4905,-0.4295,-0.7740,-0.5007,-0.3876,-0.7278,-0.5658,-0.3876,-0.7583,-0.4905,-0.4295,-0.7979,-0.4230,-0.4295,-0.8144,-0.4318,-0.3876,-0.7740,-0.5007,-0.3876,-0.7979,-0.4230,-0.4295,-0.8315,-0.3524,-0.4295,-0.8488,-0.3597,-0.3876,-0.8144,-0.4318,-0.3876,-0.8315,-0.3524,-0.4295,-0.8589,-0.2791,-0.4295,-0.8767,-0.2849,-0.3876,-0.8488,-0.3597,-0.3876,0.8767,-0.2849,-0.3876,0.8488,-0.3597,-0.3876,0.8657,-0.3669,-0.3405,0.8942,-0.2906,-0.3405,0.8488,-0.3597,-0.3876,0.8144,-0.4318,-0.3876,0.8307,-0.4404,-0.3405,0.8657,-0.3669,-0.3405,0.8144,-0.4318,-0.3876,0.7740,-0.5007,-0.3876,0.7895,-0.5107,-0.3405,0.8307,-0.4404,-0.3405,0.7740,-0.5007,-0.3876,0.7278,-0.5658,-0.3876,0.7423,-0.5771,-0.3405,0.7895,-0.5107,-0.3405,0.7278,-0.5658,-0.3876,0.6761,-0.6267,-0.3876,0.6896,-0.6392,-0.3405,0.7423,-0.5771,-0.3405,0.6761,-0.6267,-0.3876,0.6193,-0.6828,-0.3876,0.6317,-0.6965,-0.3405,0.6896,-0.6392,-0.3405,0.6193,-0.6828,-0.3876,0.5579,-0.7339,-0.3876,0.5690,-0.7485,-0.3405,0.6317,-0.6965,-0.3405,0.5579,-0.7339,-0.3876,0.4923,-0.7794,-0.3876,0.5021,-0.7950,-0.3405,0.5690,-0.7485,-0.3405,0.4923,-0.7794,-0.3876,0.4229,-0.8191,-0.3876,0.4314,-0.8354,-0.3405,0.5021,-0.7950,-0.3405,0.4229,-0.8191,-0.3876,0.3505,-0.8526,-0.3876,0.3575,-0.8697,-0.3405,0.4314,-0.8354,-0.3405,0.3505,-0.8526,-0.3876,0.2753,-0.8797,-0.3876,0.2809,-0.8973,-0.3405,0.3575,-0.8697,-0.3405,0.2753,-0.8797,-0.3876,0.1982,-0.9003,-0.3876,0.2021,-0.9183,-0.3405,0.2809,-0.8973,-0.3405,0.1982,-0.9003,-0.3876,0.1195,-0.9140,-0.3876,0.1219,-0.9323,-0.3405,0.2021,-0.9183,-0.3405,0.1195,-0.9140,-0.3876,0.0399,-0.9210,-0.3876,0.0407,-0.9394,-0.3405,0.1219,-0.9323,-0.3405,0.0399,-0.9210,-0.3876,-0.0399,-0.9210,-0.3876,-0.0407,-0.9394,-0.3405,0.0407,-0.9394,-0.3405,-0.0399,-0.9210,-0.3876,-0.1195,-0.9140,-0.3876,-0.1219,-0.9323,-0.3405,-0.0407,-0.9394,-0.3405,-0.1195,-0.9140,-0.3876,-0.1982,-0.9003,-0.3876,-0.2021,-0.9183,-0.3405,-0.1219,-0.9323,-0.3405,-0.1982,-0.9003,-0.3876,-0.2753,-0.8797,-0.3876,-0.2809,-0.8973,-0.3405,-0.2021,-0.9183,-0.3405};
			return value;
		}
		private double[] getNormal_5_14_vector_11()
		{
			double[] value = {-0.2753,-0.8797,-0.3876,-0.3505,-0.8526,-0.3876,-0.3575,-0.8697,-0.3405,-0.2809,-0.8973,-0.3405,-0.3505,-0.8526,-0.3876,-0.4229,-0.8191,-0.3876,-0.4314,-0.8354,-0.3405,-0.3575,-0.8697,-0.3405,-0.4229,-0.8191,-0.3876,-0.4923,-0.7794,-0.3876,-0.5021,-0.7950,-0.3405,-0.4314,-0.8354,-0.3405,-0.4923,-0.7794,-0.3876,-0.5579,-0.7339,-0.3876,-0.5690,-0.7485,-0.3405,-0.5021,-0.7950,-0.3405,-0.5579,-0.7339,-0.3876,-0.6193,-0.6828,-0.3876,-0.6317,-0.6965,-0.3405,-0.5690,-0.7485,-0.3405,-0.6193,-0.6828,-0.3876,-0.6761,-0.6267,-0.3876,-0.6896,-0.6392,-0.3405,-0.6317,-0.6965,-0.3405,-0.6761,-0.6267,-0.3876,-0.7278,-0.5658,-0.3876,-0.7423,-0.5771,-0.3405,-0.6896,-0.6392,-0.3405,-0.7278,-0.5658,-0.3876,-0.7740,-0.5007,-0.3876,-0.7895,-0.5107,-0.3405,-0.7423,-0.5771,-0.3405,-0.7740,-0.5007,-0.3876,-0.8144,-0.4318,-0.3876,-0.8307,-0.4404,-0.3405,-0.7895,-0.5107,-0.3405,-0.8144,-0.4318,-0.3876,-0.8488,-0.3597,-0.3876,-0.8657,-0.3669,-0.3405,-0.8307,-0.4404,-0.3405,-0.8488,-0.3597,-0.3876,-0.8767,-0.2849,-0.3876,-0.8942,-0.2906,-0.3405,-0.8657,-0.3669,-0.3405,0.8942,-0.2906,-0.3405,0.8657,-0.3669,-0.3405,0.8817,-0.3736,-0.2880,0.9108,-0.2959,-0.2880,0.8657,-0.3669,-0.3405,0.8307,-0.4404,-0.3405,0.8461,-0.4486,-0.2880,0.8817,-0.3736,-0.2880,0.8307,-0.4404,-0.3405,0.7895,-0.5107,-0.3405,0.8041,-0.5201,-0.2880,0.8461,-0.4486,-0.2880,0.7895,-0.5107,-0.3405,0.7423,-0.5771,-0.3405,0.7560,-0.5878,-0.2880,0.8041,-0.5201,-0.2880,0.7423,-0.5771,-0.3405,0.6896,-0.6392,-0.3405,0.7023,-0.6510,-0.2880,0.7560,-0.5878,-0.2880,0.6896,-0.6392,-0.3405,0.6317,-0.6965,-0.3405,0.6433,-0.7093,-0.2880,0.7023,-0.6510,-0.2880,0.6317,-0.6965,-0.3405,0.5690,-0.7485,-0.3405,0.5795,-0.7624,-0.2880,0.6433,-0.7093,-0.2880,0.5690,-0.7485,-0.3405,0.5021,-0.7950,-0.3405,0.5114,-0.8097,-0.2880,0.5795,-0.7624,-0.2880,0.5021,-0.7950,-0.3405,0.4314,-0.8354,-0.3405,0.4394,-0.8509,-0.2880,0.5114,-0.8097,-0.2880,0.4314,-0.8354,-0.3405,0.3575,-0.8697,-0.3405,0.3641,-0.8857,-0.2880,0.4394,-0.8509,-0.2880,0.3575,-0.8697,-0.3405,0.2809,-0.8973,-0.3405,0.2860,-0.9139,-0.2880,0.3641,-0.8857,-0.2880,0.2809,-0.8973,-0.3405,0.2021,-0.9183,-0.3405,0.2059,-0.9352,-0.2880,0.2860,-0.9139,-0.2880,0.2021,-0.9183,-0.3405,0.1219,-0.9323,-0.3405,0.1241,-0.9495,-0.2880,0.2059,-0.9352,-0.2880,0.1219,-0.9323,-0.3405,0.0407,-0.9394,-0.3405,0.0415,-0.9567,-0.2880,0.1241,-0.9495,-0.2880};
			return value;
		}
		private double[] getNormal_5_14_vector_12()
		{
			double[] value = {0.0407,-0.9394,-0.3405,-0.0407,-0.9394,-0.3405,-0.0415,-0.9567,-0.2880,0.0415,-0.9567,-0.2880,-0.0407,-0.9394,-0.3405,-0.1219,-0.9323,-0.3405,-0.1241,-0.9495,-0.2880,-0.0415,-0.9567,-0.2880,-0.1219,-0.9323,-0.3405,-0.2021,-0.9183,-0.3405,-0.2059,-0.9352,-0.2880,-0.1241,-0.9495,-0.2880,-0.2021,-0.9183,-0.3405,-0.2809,-0.8973,-0.3405,-0.2860,-0.9139,-0.2880,-0.2059,-0.9352,-0.2880,-0.2809,-0.8973,-0.3405,-0.3575,-0.8697,-0.3405,-0.3641,-0.8857,-0.2880,-0.2860,-0.9139,-0.2880,-0.3575,-0.8697,-0.3405,-0.4314,-0.8354,-0.3405,-0.4394,-0.8509,-0.2880,-0.3641,-0.8857,-0.2880,-0.4314,-0.8354,-0.3405,-0.5021,-0.7950,-0.3405,-0.5114,-0.8097,-0.2880,-0.4394,-0.8509,-0.2880,-0.5021,-0.7950,-0.3405,-0.5690,-0.7485,-0.3405,-0.5795,-0.7624,-0.2880,-0.5114,-0.8097,-0.2880,-0.5690,-0.7485,-0.3405,-0.6317,-0.6965,-0.3405,-0.6433,-0.7093,-0.2880,-0.5795,-0.7624,-0.2880,-0.6317,-0.6965,-0.3405,-0.6896,-0.6392,-0.3405,-0.7023,-0.6510,-0.2880,-0.6433,-0.7093,-0.2880,-0.6896,-0.6392,-0.3405,-0.7423,-0.5771,-0.3405,-0.7560,-0.5878,-0.2880,-0.7023,-0.6510,-0.2880,-0.7423,-0.5771,-0.3405,-0.7895,-0.5107,-0.3405,-0.8041,-0.5201,-0.2880,-0.7560,-0.5878,-0.2880,-0.7895,-0.5107,-0.3405,-0.8307,-0.4404,-0.3405,-0.8461,-0.4486,-0.2880,-0.8041,-0.5201,-0.2880,-0.8307,-0.4404,-0.3405,-0.8657,-0.3669,-0.3405,-0.8817,-0.3736,-0.2880,-0.8461,-0.4486,-0.2880,-0.8657,-0.3669,-0.3405,-0.8942,-0.2906,-0.3405,-0.9108,-0.2959,-0.2880,-0.8817,-0.3736,-0.2880,0.9108,-0.2959,-0.2880,0.8817,-0.3736,-0.2880,0.8960,-0.3797,-0.2304,0.9255,-0.3007,-0.2304,0.8817,-0.3736,-0.2880,0.8461,-0.4486,-0.2880,0.8597,-0.4558,-0.2304,0.8960,-0.3797,-0.2304,0.8461,-0.4486,-0.2880,0.8041,-0.5201,-0.2880,0.8171,-0.5285,-0.2304,0.8597,-0.4558,-0.2304,0.8041,-0.5201,-0.2880,0.7560,-0.5878,-0.2880,0.7682,-0.5972,-0.2304,0.8171,-0.5285,-0.2304,0.7560,-0.5878,-0.2880,0.7023,-0.6510,-0.2880,0.7137,-0.6615,-0.2304,0.7682,-0.5972,-0.2304,0.7023,-0.6510,-0.2880,0.6433,-0.7093,-0.2880,0.6537,-0.7208,-0.2304,0.7137,-0.6615,-0.2304,0.6433,-0.7093,-0.2880,0.5795,-0.7624,-0.2880,0.5889,-0.7747,-0.2304,0.6537,-0.7208,-0.2304,0.5795,-0.7624,-0.2880,0.5114,-0.8097,-0.2880,0.5196,-0.8227,-0.2304,0.5889,-0.7747,-0.2304,0.5114,-0.8097,-0.2880,0.4394,-0.8509,-0.2880,0.4465,-0.8646,-0.2304,0.5196,-0.8227,-0.2304,0.4394,-0.8509,-0.2880,0.3641,-0.8857,-0.2880,0.3699,-0.9000,-0.2304,0.4465,-0.8646,-0.2304};
			return value;
		}
		private double[] getNormal_5_14_vector_13()
		{
			double[] value = {0.3641,-0.8857,-0.2880,0.2860,-0.9139,-0.2880,0.2907,-0.9287,-0.2304,0.3699,-0.9000,-0.2304,0.2860,-0.9139,-0.2880,0.2059,-0.9352,-0.2880,0.2092,-0.9503,-0.2304,0.2907,-0.9287,-0.2304,0.2059,-0.9352,-0.2880,0.1241,-0.9495,-0.2880,0.1261,-0.9649,-0.2304,0.2092,-0.9503,-0.2304,0.1241,-0.9495,-0.2880,0.0415,-0.9567,-0.2880,0.0422,-0.9722,-0.2304,0.1261,-0.9649,-0.2304,0.0415,-0.9567,-0.2880,-0.0415,-0.9567,-0.2880,-0.0422,-0.9722,-0.2304,0.0422,-0.9722,-0.2304,-0.0415,-0.9567,-0.2880,-0.1241,-0.9495,-0.2880,-0.1261,-0.9649,-0.2304,-0.0422,-0.9722,-0.2304,-0.1241,-0.9495,-0.2880,-0.2059,-0.9352,-0.2880,-0.2092,-0.9503,-0.2304,-0.1261,-0.9649,-0.2304,-0.2059,-0.9352,-0.2880,-0.2860,-0.9139,-0.2880,-0.2907,-0.9287,-0.2304,-0.2092,-0.9503,-0.2304,-0.2860,-0.9139,-0.2880,-0.3641,-0.8857,-0.2880,-0.3699,-0.9000,-0.2304,-0.2907,-0.9287,-0.2304,-0.3641,-0.8857,-0.2880,-0.4394,-0.8509,-0.2880,-0.4465,-0.8646,-0.2304,-0.3699,-0.9000,-0.2304,-0.4394,-0.8509,-0.2880,-0.5114,-0.8097,-0.2880,-0.5196,-0.8227,-0.2304,-0.4465,-0.8646,-0.2304,-0.5114,-0.8097,-0.2880,-0.5795,-0.7624,-0.2880,-0.5889,-0.7747,-0.2304,-0.5196,-0.8227,-0.2304,-0.5795,-0.7624,-0.2880,-0.6433,-0.7093,-0.2880,-0.6537,-0.7208,-0.2304,-0.5889,-0.7747,-0.2304,-0.6433,-0.7093,-0.2880,-0.7023,-0.6510,-0.2880,-0.7137,-0.6615,-0.2304,-0.6537,-0.7208,-0.2304,-0.7023,-0.6510,-0.2880,-0.7560,-0.5878,-0.2880,-0.7682,-0.5972,-0.2304,-0.7137,-0.6615,-0.2304,-0.7560,-0.5878,-0.2880,-0.8041,-0.5201,-0.2880,-0.8171,-0.5285,-0.2304,-0.7682,-0.5972,-0.2304,-0.8041,-0.5201,-0.2880,-0.8461,-0.4486,-0.2880,-0.8597,-0.4558,-0.2304,-0.8171,-0.5285,-0.2304,-0.8461,-0.4486,-0.2880,-0.8817,-0.3736,-0.2880,-0.8960,-0.3797,-0.2304,-0.8597,-0.4558,-0.2304,-0.8817,-0.3736,-0.2880,-0.9108,-0.2959,-0.2880,-0.9255,-0.3007,-0.2304,-0.8960,-0.3797,-0.2304,0.9255,-0.3007,-0.2304,0.8960,-0.3797,-0.2304,0.9076,-0.3846,-0.1683,0.9375,-0.3046,-0.1683,0.8960,-0.3797,-0.2304,0.8597,-0.4558,-0.2304,0.8709,-0.4617,-0.1683,0.9076,-0.3846,-0.1683,0.8597,-0.4558,-0.2304,0.8171,-0.5285,-0.2304,0.8277,-0.5354,-0.1683,0.8709,-0.4617,-0.1683,0.8171,-0.5285,-0.2304,0.7682,-0.5972,-0.2304,0.7782,-0.6050,-0.1683,0.8277,-0.5354,-0.1683,0.7682,-0.5972,-0.2304,0.7137,-0.6615,-0.2304,0.7229,-0.6701,-0.1683,0.7782,-0.6050,-0.1683,0.7137,-0.6615,-0.2304,0.6537,-0.7208,-0.2304,0.6622,-0.7302,-0.1683,0.7229,-0.6701,-0.1683};
			return value;
		}
		private double[] getNormal_5_14_vector_14()
		{
			double[] value = {0.6537,-0.7208,-0.2304,0.5889,-0.7747,-0.2304,0.5965,-0.7847,-0.1683,0.6622,-0.7302,-0.1683,0.5889,-0.7747,-0.2304,0.5196,-0.8227,-0.2304,0.5264,-0.8334,-0.1683,0.5965,-0.7847,-0.1683,0.5196,-0.8227,-0.2304,0.4465,-0.8646,-0.2304,0.4523,-0.8759,-0.1683,0.5264,-0.8334,-0.1683,0.4465,-0.8646,-0.2304,0.3699,-0.9000,-0.2304,0.3748,-0.9117,-0.1683,0.4523,-0.8759,-0.1683,0.3699,-0.9000,-0.2304,0.2907,-0.9287,-0.2304,0.2944,-0.9407,-0.1683,0.3748,-0.9117,-0.1683,0.2907,-0.9287,-0.2304,0.2092,-0.9503,-0.2304,0.2119,-0.9627,-0.1683,0.2944,-0.9407,-0.1683,0.2092,-0.9503,-0.2304,0.1261,-0.9649,-0.2304,0.1278,-0.9774,-0.1683,0.2119,-0.9627,-0.1683,0.1261,-0.9649,-0.2304,0.0422,-0.9722,-0.2304,0.0427,-0.9848,-0.1683,0.1278,-0.9774,-0.1683,0.0422,-0.9722,-0.2304,-0.0422,-0.9722,-0.2304,-0.0427,-0.9848,-0.1683,0.0427,-0.9848,-0.1683,-0.0422,-0.9722,-0.2304,-0.1261,-0.9649,-0.2304,-0.1278,-0.9774,-0.1683,-0.0427,-0.9848,-0.1683,-0.1261,-0.9649,-0.2304,-0.2092,-0.9503,-0.2304,-0.2119,-0.9627,-0.1683,-0.1278,-0.9774,-0.1683,-0.2092,-0.9503,-0.2304,-0.2907,-0.9287,-0.2304,-0.2944,-0.9407,-0.1683,-0.2119,-0.9627,-0.1683,-0.2907,-0.9287,-0.2304,-0.3699,-0.9000,-0.2304,-0.3748,-0.9117,-0.1683,-0.2944,-0.9407,-0.1683,-0.3699,-0.9000,-0.2304,-0.4465,-0.8646,-0.2304,-0.4523,-0.8759,-0.1683,-0.3748,-0.9117,-0.1683,-0.4465,-0.8646,-0.2304,-0.5196,-0.8227,-0.2304,-0.5264,-0.8334,-0.1683,-0.4523,-0.8759,-0.1683,-0.5196,-0.8227,-0.2304,-0.5889,-0.7747,-0.2304,-0.5965,-0.7847,-0.1683,-0.5264,-0.8334,-0.1683,-0.5889,-0.7747,-0.2304,-0.6537,-0.7208,-0.2304,-0.6622,-0.7302,-0.1683,-0.5965,-0.7847,-0.1683,-0.6537,-0.7208,-0.2304,-0.7137,-0.6615,-0.2304,-0.7229,-0.6701,-0.1683,-0.6622,-0.7302,-0.1683,-0.7137,-0.6615,-0.2304,-0.7682,-0.5972,-0.2304,-0.7782,-0.6050,-0.1683,-0.7229,-0.6701,-0.1683,-0.7682,-0.5972,-0.2304,-0.8171,-0.5285,-0.2304,-0.8277,-0.5354,-0.1683,-0.7782,-0.6050,-0.1683,-0.8171,-0.5285,-0.2304,-0.8597,-0.4558,-0.2304,-0.8709,-0.4617,-0.1683,-0.8277,-0.5354,-0.1683,-0.8597,-0.4558,-0.2304,-0.8960,-0.3797,-0.2304,-0.9076,-0.3846,-0.1683,-0.8709,-0.4617,-0.1683,-0.8960,-0.3797,-0.2304,-0.9255,-0.3007,-0.2304,-0.9375,-0.3046,-0.1683,-0.9076,-0.3846,-0.1683,0.9375,-0.3046,-0.1683,0.9076,-0.3846,-0.1683,0.9159,-0.3881,-0.1025,0.9460,-0.3074,-0.1025,0.9076,-0.3846,-0.1683,0.8709,-0.4617,-0.1683,0.8789,-0.4659,-0.1025,0.9159,-0.3881,-0.1025};
			return value;
		}
		private double[] getNormal_5_14_vector_15()
		{
			double[] value = {0.8709,-0.4617,-0.1683,0.8277,-0.5354,-0.1683,0.8352,-0.5403,-0.1025,0.8789,-0.4659,-0.1025,0.8277,-0.5354,-0.1683,0.7782,-0.6050,-0.1683,0.7853,-0.6105,-0.1025,0.8352,-0.5403,-0.1025,0.7782,-0.6050,-0.1683,0.7229,-0.6701,-0.1683,0.7295,-0.6762,-0.1025,0.7853,-0.6105,-0.1025,0.7229,-0.6701,-0.1683,0.6622,-0.7302,-0.1683,0.6683,-0.7368,-0.1025,0.7295,-0.6762,-0.1025,0.6622,-0.7302,-0.1683,0.5965,-0.7847,-0.1683,0.6020,-0.7919,-0.1025,0.6683,-0.7368,-0.1025,0.5965,-0.7847,-0.1683,0.5264,-0.8334,-0.1683,0.5312,-0.8410,-0.1025,0.6020,-0.7919,-0.1025,0.5264,-0.8334,-0.1683,0.4523,-0.8759,-0.1683,0.4564,-0.8839,-0.1025,0.5312,-0.8410,-0.1025,0.4523,-0.8759,-0.1683,0.3748,-0.9117,-0.1683,0.3782,-0.9200,-0.1025,0.4564,-0.8839,-0.1025,0.3748,-0.9117,-0.1683,0.2944,-0.9407,-0.1683,0.2971,-0.9493,-0.1025,0.3782,-0.9200,-0.1025,0.2944,-0.9407,-0.1683,0.2119,-0.9627,-0.1683,0.2138,-0.9715,-0.1025,0.2971,-0.9493,-0.1025,0.2119,-0.9627,-0.1683,0.1278,-0.9774,-0.1683,0.1289,-0.9863,-0.1025,0.2138,-0.9715,-0.1025,0.1278,-0.9774,-0.1683,0.0427,-0.9848,-0.1683,0.0431,-0.9938,-0.1025,0.1289,-0.9863,-0.1025,0.0427,-0.9848,-0.1683,-0.0427,-0.9848,-0.1683,-0.0431,-0.9938,-0.1025,0.0431,-0.9938,-0.1025,-0.0427,-0.9848,-0.1683,-0.1278,-0.9774,-0.1683,-0.1289,-0.9863,-0.1025,-0.0431,-0.9938,-0.1025,-0.1278,-0.9774,-0.1683,-0.2119,-0.9627,-0.1683,-0.2138,-0.9715,-0.1025,-0.1289,-0.9863,-0.1025,-0.2119,-0.9627,-0.1683,-0.2944,-0.9407,-0.1683,-0.2971,-0.9493,-0.1025,-0.2138,-0.9715,-0.1025,-0.2944,-0.9407,-0.1683,-0.3748,-0.9117,-0.1683,-0.3782,-0.9200,-0.1025,-0.2971,-0.9493,-0.1025,-0.3748,-0.9117,-0.1683,-0.4523,-0.8759,-0.1683,-0.4564,-0.8839,-0.1025,-0.3782,-0.9200,-0.1025,-0.4523,-0.8759,-0.1683,-0.5264,-0.8334,-0.1683,-0.5312,-0.8410,-0.1025,-0.4564,-0.8839,-0.1025,-0.5264,-0.8334,-0.1683,-0.5965,-0.7847,-0.1683,-0.6020,-0.7919,-0.1025,-0.5312,-0.8410,-0.1025,-0.5965,-0.7847,-0.1683,-0.6622,-0.7302,-0.1683,-0.6683,-0.7368,-0.1025,-0.6020,-0.7919,-0.1025,-0.6622,-0.7302,-0.1683,-0.7229,-0.6701,-0.1683,-0.7295,-0.6762,-0.1025,-0.6683,-0.7368,-0.1025,-0.7229,-0.6701,-0.1683,-0.7782,-0.6050,-0.1683,-0.7853,-0.6105,-0.1025,-0.7295,-0.6762,-0.1025,-0.7782,-0.6050,-0.1683,-0.8277,-0.5354,-0.1683,-0.8352,-0.5403,-0.1025,-0.7853,-0.6105,-0.1025,-0.8277,-0.5354,-0.1683,-0.8709,-0.4617,-0.1683,-0.8789,-0.4659,-0.1025,-0.8352,-0.5403,-0.1025};
			return value;
		}
		private double[] getNormal_5_14_vector_16()
		{
			double[] value = {-0.8709,-0.4617,-0.1683,-0.9076,-0.3846,-0.1683,-0.9159,-0.3881,-0.1025,-0.8789,-0.4659,-0.1025,-0.9076,-0.3846,-0.1683,-0.9375,-0.3046,-0.1683,-0.9460,-0.3074,-0.1025,-0.9159,-0.3881,-0.1025,0.9460,-0.3074,-0.1025,0.9159,-0.3881,-0.1025,0.9202,-0.3899,-0.0344,0.9505,-0.3088,-0.0344,0.9159,-0.3881,-0.1025,0.8789,-0.4659,-0.1025,0.8830,-0.4681,-0.0344,0.9202,-0.3899,-0.0344,0.8789,-0.4659,-0.1025,0.8352,-0.5403,-0.1025,0.8392,-0.5428,-0.0344,0.8830,-0.4681,-0.0344,0.8352,-0.5403,-0.1025,0.7853,-0.6105,-0.1025,0.7890,-0.6134,-0.0344,0.8392,-0.5428,-0.0344,0.7853,-0.6105,-0.1025,0.7295,-0.6762,-0.1025,0.7330,-0.6794,-0.0344,0.7890,-0.6134,-0.0344,0.7295,-0.6762,-0.1025,0.6683,-0.7368,-0.1025,0.6714,-0.7403,-0.0344,0.7330,-0.6794,-0.0344,0.6683,-0.7368,-0.1025,0.6020,-0.7919,-0.1025,0.6048,-0.7956,-0.0344,0.6714,-0.7403,-0.0344,0.6020,-0.7919,-0.1025,0.5312,-0.8410,-0.1025,0.5337,-0.8450,-0.0344,0.6048,-0.7956,-0.0344,0.5312,-0.8410,-0.1025,0.4564,-0.8839,-0.1025,0.4585,-0.8880,-0.0344,0.5337,-0.8450,-0.0344,0.4564,-0.8839,-0.1025,0.3782,-0.9200,-0.1025,0.3800,-0.9244,-0.0344,0.4585,-0.8880,-0.0344,0.3782,-0.9200,-0.1025,0.2971,-0.9493,-0.1025,0.2985,-0.9538,-0.0344,0.3800,-0.9244,-0.0344,0.2971,-0.9493,-0.1025,0.2138,-0.9715,-0.1025,0.2148,-0.9760,-0.0344,0.2985,-0.9538,-0.0344,0.2138,-0.9715,-0.1025,0.1289,-0.9863,-0.1025,0.1296,-0.9910,-0.0344,0.2148,-0.9760,-0.0344,0.1289,-0.9863,-0.1025,0.0431,-0.9938,-0.1025,0.0433,-0.9985,-0.0344,0.1296,-0.9910,-0.0344,0.0431,-0.9938,-0.1025,-0.0431,-0.9938,-0.1025,-0.0433,-0.9985,-0.0344,0.0433,-0.9985,-0.0344,-0.0431,-0.9938,-0.1025,-0.1289,-0.9863,-0.1025,-0.1296,-0.9910,-0.0344,-0.0433,-0.9985,-0.0344,-0.1289,-0.9863,-0.1025,-0.2138,-0.9715,-0.1025,-0.2148,-0.9760,-0.0344,-0.1296,-0.9910,-0.0344,-0.2138,-0.9715,-0.1025,-0.2971,-0.9493,-0.1025,-0.2985,-0.9538,-0.0344,-0.2148,-0.9760,-0.0344,-0.2971,-0.9493,-0.1025,-0.3782,-0.9200,-0.1025,-0.3800,-0.9244,-0.0344,-0.2985,-0.9538,-0.0344,-0.3782,-0.9200,-0.1025,-0.4564,-0.8839,-0.1025,-0.4585,-0.8880,-0.0344,-0.3800,-0.9244,-0.0344,-0.4564,-0.8839,-0.1025,-0.5312,-0.8410,-0.1025,-0.5337,-0.8450,-0.0344,-0.4585,-0.8880,-0.0344,-0.5312,-0.8410,-0.1025,-0.6020,-0.7919,-0.1025,-0.6048,-0.7956,-0.0344,-0.5337,-0.8450,-0.0344,-0.6020,-0.7919,-0.1025,-0.6683,-0.7368,-0.1025,-0.6714,-0.7403,-0.0344,-0.6048,-0.7956,-0.0344};
			return value;
		}
		private double[] getNormal_5_14_vector_17()
		{
			double[] value = {-0.6683,-0.7368,-0.1025,-0.7295,-0.6762,-0.1025,-0.7330,-0.6794,-0.0344,-0.6714,-0.7403,-0.0344,-0.7295,-0.6762,-0.1025,-0.7853,-0.6105,-0.1025,-0.7890,-0.6134,-0.0344,-0.7330,-0.6794,-0.0344,-0.7853,-0.6105,-0.1025,-0.8352,-0.5403,-0.1025,-0.8392,-0.5428,-0.0344,-0.7890,-0.6134,-0.0344,-0.8352,-0.5403,-0.1025,-0.8789,-0.4659,-0.1025,-0.8830,-0.4681,-0.0344,-0.8392,-0.5428,-0.0344,-0.8789,-0.4659,-0.1025,-0.9159,-0.3881,-0.1025,-0.9202,-0.3899,-0.0344,-0.8830,-0.4681,-0.0344,-0.9159,-0.3881,-0.1025,-0.9460,-0.3074,-0.1025,-0.9505,-0.3088,-0.0344,-0.9202,-0.3899,-0.0344,0.9505,-0.3088,-0.0344,0.9202,-0.3899,-0.0344,0.9202,-0.3899,0.0344,0.9505,-0.3088,0.0344,0.9202,-0.3899,-0.0344,0.8830,-0.4681,-0.0344,0.8830,-0.4681,0.0344,0.9202,-0.3899,0.0344,0.8830,-0.4681,-0.0344,0.8392,-0.5428,-0.0344,0.8392,-0.5428,0.0344,0.8830,-0.4681,0.0344,0.8392,-0.5428,-0.0344,0.7890,-0.6134,-0.0344,0.7890,-0.6134,0.0344,0.8392,-0.5428,0.0344,0.7890,-0.6134,-0.0344,0.7330,-0.6794,-0.0344,0.7330,-0.6794,0.0344,0.7890,-0.6134,0.0344,0.7330,-0.6794,-0.0344,0.6714,-0.7403,-0.0344,0.6714,-0.7403,0.0344,0.7330,-0.6794,0.0344,0.6714,-0.7403,-0.0344,0.6048,-0.7956,-0.0344,0.6048,-0.7956,0.0344,0.6714,-0.7403,0.0344,0.6048,-0.7956,-0.0344,0.5337,-0.8450,-0.0344,0.5337,-0.8450,0.0344,0.6048,-0.7956,0.0344,0.5337,-0.8450,-0.0344,0.4585,-0.8880,-0.0344,0.4585,-0.8880,0.0344,0.5337,-0.8450,0.0344,0.4585,-0.8880,-0.0344,0.3800,-0.9244,-0.0344,0.3800,-0.9244,0.0344,0.4585,-0.8880,0.0344,0.3800,-0.9244,-0.0344,0.2985,-0.9538,-0.0344,0.2985,-0.9538,0.0344,0.3800,-0.9244,0.0344,0.2985,-0.9538,-0.0344,0.2148,-0.9760,-0.0344,0.2148,-0.9760,0.0344,0.2985,-0.9538,0.0344,0.2148,-0.9760,-0.0344,0.1296,-0.9910,-0.0344,0.1296,-0.9910,0.0344,0.2148,-0.9760,0.0344,0.1296,-0.9910,-0.0344,0.0433,-0.9985,-0.0344,0.0433,-0.9985,0.0344,0.1296,-0.9910,0.0344,0.0433,-0.9985,-0.0344,-0.0433,-0.9985,-0.0344,-0.0433,-0.9985,0.0344,0.0433,-0.9985,0.0344,-0.0433,-0.9985,-0.0344,-0.1296,-0.9910,-0.0344,-0.1296,-0.9910,0.0344,-0.0433,-0.9985,0.0344,-0.1296,-0.9910,-0.0344,-0.2148,-0.9760,-0.0344,-0.2148,-0.9760,0.0344,-0.1296,-0.9910,0.0344,-0.2148,-0.9760,-0.0344,-0.2985,-0.9538,-0.0344,-0.2985,-0.9538,0.0344,-0.2148,-0.9760,0.0344,-0.2985,-0.9538,-0.0344,-0.3800,-0.9244,-0.0344,-0.3800,-0.9244,0.0344,-0.2985,-0.9538,0.0344};
			return value;
		}
		private double[] getNormal_5_14_vector_18()
		{
			double[] value = {-0.3800,-0.9244,-0.0344,-0.4585,-0.8880,-0.0344,-0.4585,-0.8880,0.0344,-0.3800,-0.9244,0.0344,-0.4585,-0.8880,-0.0344,-0.5337,-0.8450,-0.0344,-0.5337,-0.8450,0.0344,-0.4585,-0.8880,0.0344,-0.5337,-0.8450,-0.0344,-0.6048,-0.7956,-0.0344,-0.6048,-0.7956,0.0344,-0.5337,-0.8450,0.0344,-0.6048,-0.7956,-0.0344,-0.6714,-0.7403,-0.0344,-0.6714,-0.7403,0.0344,-0.6048,-0.7956,0.0344,-0.6714,-0.7403,-0.0344,-0.7330,-0.6794,-0.0344,-0.7330,-0.6794,0.0344,-0.6714,-0.7403,0.0344,-0.7330,-0.6794,-0.0344,-0.7890,-0.6134,-0.0344,-0.7890,-0.6134,0.0344,-0.7330,-0.6794,0.0344,-0.7890,-0.6134,-0.0344,-0.8392,-0.5428,-0.0344,-0.8392,-0.5428,0.0344,-0.7890,-0.6134,0.0344,-0.8392,-0.5428,-0.0344,-0.8830,-0.4681,-0.0344,-0.8830,-0.4681,0.0344,-0.8392,-0.5428,0.0344,-0.8830,-0.4681,-0.0344,-0.9202,-0.3899,-0.0344,-0.9202,-0.3899,0.0344,-0.8830,-0.4681,0.0344,-0.9202,-0.3899,-0.0344,-0.9505,-0.3088,-0.0344,-0.9505,-0.3088,0.0344,-0.9202,-0.3899,0.0344,0.9505,-0.3088,0.0344,0.9202,-0.3899,0.0344,0.9159,-0.3881,0.1025,0.9460,-0.3074,0.1025,0.9202,-0.3899,0.0344,0.8830,-0.4681,0.0344,0.8789,-0.4659,0.1025,0.9159,-0.3881,0.1025,0.8830,-0.4681,0.0344,0.8392,-0.5428,0.0344,0.8352,-0.5403,0.1025,0.8789,-0.4659,0.1025,0.8392,-0.5428,0.0344,0.7890,-0.6134,0.0344,0.7853,-0.6105,0.1025,0.8352,-0.5403,0.1025,0.7890,-0.6134,0.0344,0.7330,-0.6794,0.0344,0.7295,-0.6762,0.1025,0.7853,-0.6105,0.1025,0.7330,-0.6794,0.0344,0.6714,-0.7403,0.0344,0.6683,-0.7368,0.1025,0.7295,-0.6762,0.1025,0.6714,-0.7403,0.0344,0.6048,-0.7956,0.0344,0.6020,-0.7919,0.1025,0.6683,-0.7368,0.1025,0.6048,-0.7956,0.0344,0.5337,-0.8450,0.0344,0.5312,-0.8410,0.1025,0.6020,-0.7919,0.1025,0.5337,-0.8450,0.0344,0.4585,-0.8880,0.0344,0.4564,-0.8839,0.1025,0.5312,-0.8410,0.1025,0.4585,-0.8880,0.0344,0.3800,-0.9244,0.0344,0.3782,-0.9200,0.1025,0.4564,-0.8839,0.1025,0.3800,-0.9244,0.0344,0.2985,-0.9538,0.0344,0.2971,-0.9493,0.1025,0.3782,-0.9200,0.1025,0.2985,-0.9538,0.0344,0.2148,-0.9760,0.0344,0.2138,-0.9715,0.1025,0.2971,-0.9493,0.1025,0.2148,-0.9760,0.0344,0.1296,-0.9910,0.0344,0.1289,-0.9863,0.1025,0.2138,-0.9715,0.1025,0.1296,-0.9910,0.0344,0.0433,-0.9985,0.0344,0.0431,-0.9938,0.1025,0.1289,-0.9863,0.1025,0.0433,-0.9985,0.0344,-0.0433,-0.9985,0.0344,-0.0431,-0.9938,0.1025,0.0431,-0.9938,0.1025};
			return value;
		}
		private double[] getNormal_5_14_vector_19()
		{
			double[] value = {-0.0433,-0.9985,0.0344,-0.1296,-0.9910,0.0344,-0.1289,-0.9863,0.1025,-0.0431,-0.9938,0.1025,-0.1296,-0.9910,0.0344,-0.2148,-0.9760,0.0344,-0.2138,-0.9715,0.1025,-0.1289,-0.9863,0.1025,-0.2148,-0.9760,0.0344,-0.2985,-0.9538,0.0344,-0.2971,-0.9493,0.1025,-0.2138,-0.9715,0.1025,-0.2985,-0.9538,0.0344,-0.3800,-0.9244,0.0344,-0.3782,-0.9200,0.1025,-0.2971,-0.9493,0.1025,-0.3800,-0.9244,0.0344,-0.4585,-0.8880,0.0344,-0.4564,-0.8839,0.1025,-0.3782,-0.9200,0.1025,-0.4585,-0.8880,0.0344,-0.5337,-0.8450,0.0344,-0.5312,-0.8410,0.1025,-0.4564,-0.8839,0.1025,-0.5337,-0.8450,0.0344,-0.6048,-0.7956,0.0344,-0.6020,-0.7919,0.1025,-0.5312,-0.8410,0.1025,-0.6048,-0.7956,0.0344,-0.6714,-0.7403,0.0344,-0.6683,-0.7368,0.1025,-0.6020,-0.7919,0.1025,-0.6714,-0.7403,0.0344,-0.7330,-0.6794,0.0344,-0.7295,-0.6762,0.1025,-0.6683,-0.7368,0.1025,-0.7330,-0.6794,0.0344,-0.7890,-0.6134,0.0344,-0.7853,-0.6105,0.1025,-0.7295,-0.6762,0.1025,-0.7890,-0.6134,0.0344,-0.8392,-0.5428,0.0344,-0.8352,-0.5403,0.1025,-0.7853,-0.6105,0.1025,-0.8392,-0.5428,0.0344,-0.8830,-0.4681,0.0344,-0.8789,-0.4659,0.1025,-0.8352,-0.5403,0.1025,-0.8830,-0.4681,0.0344,-0.9202,-0.3899,0.0344,-0.9159,-0.3881,0.1025,-0.8789,-0.4659,0.1025,-0.9202,-0.3899,0.0344,-0.9505,-0.3088,0.0344,-0.9460,-0.3074,0.1025,-0.9159,-0.3881,0.1025,0.9460,-0.3074,0.1025,0.9159,-0.3881,0.1025,0.9076,-0.3846,0.1683,0.9375,-0.3046,0.1683,0.9159,-0.3881,0.1025,0.8789,-0.4659,0.1025,0.8709,-0.4617,0.1683,0.9076,-0.3846,0.1683,0.8789,-0.4659,0.1025,0.8352,-0.5403,0.1025,0.8277,-0.5354,0.1683,0.8709,-0.4617,0.1683,0.8352,-0.5403,0.1025,0.7853,-0.6105,0.1025,0.7782,-0.6050,0.1683,0.8277,-0.5354,0.1683,0.7853,-0.6105,0.1025,0.7295,-0.6762,0.1025,0.7229,-0.6701,0.1683,0.7782,-0.6050,0.1683,0.7295,-0.6762,0.1025,0.6683,-0.7368,0.1025,0.6622,-0.7302,0.1683,0.7229,-0.6701,0.1683,0.6683,-0.7368,0.1025,0.6020,-0.7919,0.1025,0.5965,-0.7847,0.1683,0.6622,-0.7302,0.1683,0.6020,-0.7919,0.1025,0.5312,-0.8410,0.1025,0.5264,-0.8334,0.1683,0.5965,-0.7847,0.1683,0.5312,-0.8410,0.1025,0.4564,-0.8839,0.1025,0.4523,-0.8759,0.1683,0.5264,-0.8334,0.1683,0.4564,-0.8839,0.1025,0.3782,-0.9200,0.1025,0.3748,-0.9117,0.1683,0.4523,-0.8759,0.1683,0.3782,-0.9200,0.1025,0.2971,-0.9493,0.1025,0.2944,-0.9407,0.1683,0.3748,-0.9117,0.1683};
			return value;
		}
		private double[] getNormal_5_14_vector_20()
		{
			double[] value = {0.2971,-0.9493,0.1025,0.2138,-0.9715,0.1025,0.2119,-0.9627,0.1683,0.2944,-0.9407,0.1683,0.2138,-0.9715,0.1025,0.1289,-0.9863,0.1025,0.1278,-0.9774,0.1683,0.2119,-0.9627,0.1683,0.1289,-0.9863,0.1025,0.0431,-0.9938,0.1025,0.0427,-0.9848,0.1683,0.1278,-0.9774,0.1683,0.0431,-0.9938,0.1025,-0.0431,-0.9938,0.1025,-0.0427,-0.9848,0.1683,0.0427,-0.9848,0.1683,-0.0431,-0.9938,0.1025,-0.1289,-0.9863,0.1025,-0.1278,-0.9774,0.1683,-0.0427,-0.9848,0.1683,-0.1289,-0.9863,0.1025,-0.2138,-0.9715,0.1025,-0.2119,-0.9627,0.1683,-0.1278,-0.9774,0.1683,-0.2138,-0.9715,0.1025,-0.2971,-0.9493,0.1025,-0.2944,-0.9407,0.1683,-0.2119,-0.9627,0.1683,-0.2971,-0.9493,0.1025,-0.3782,-0.9200,0.1025,-0.3748,-0.9117,0.1683,-0.2944,-0.9407,0.1683,-0.3782,-0.9200,0.1025,-0.4564,-0.8839,0.1025,-0.4523,-0.8759,0.1683,-0.3748,-0.9117,0.1683,-0.4564,-0.8839,0.1025,-0.5312,-0.8410,0.1025,-0.5264,-0.8334,0.1683,-0.4523,-0.8759,0.1683,-0.5312,-0.8410,0.1025,-0.6020,-0.7919,0.1025,-0.5965,-0.7847,0.1683,-0.5264,-0.8334,0.1683,-0.6020,-0.7919,0.1025,-0.6683,-0.7368,0.1025,-0.6622,-0.7302,0.1683,-0.5965,-0.7847,0.1683,-0.6683,-0.7368,0.1025,-0.7295,-0.6762,0.1025,-0.7229,-0.6701,0.1683,-0.6622,-0.7302,0.1683,-0.7295,-0.6762,0.1025,-0.7853,-0.6105,0.1025,-0.7782,-0.6050,0.1683,-0.7229,-0.6701,0.1683,-0.7853,-0.6105,0.1025,-0.8352,-0.5403,0.1025,-0.8277,-0.5354,0.1683,-0.7782,-0.6050,0.1683,-0.8352,-0.5403,0.1025,-0.8789,-0.4659,0.1025,-0.8709,-0.4617,0.1683,-0.8277,-0.5354,0.1683,-0.8789,-0.4659,0.1025,-0.9159,-0.3881,0.1025,-0.9076,-0.3846,0.1683,-0.8709,-0.4617,0.1683,-0.9159,-0.3881,0.1025,-0.9460,-0.3074,0.1025,-0.9375,-0.3046,0.1683,-0.9076,-0.3846,0.1683,0.9375,-0.3046,0.1683,0.9076,-0.3846,0.1683,0.8960,-0.3797,0.2304,0.9255,-0.3007,0.2304,0.9076,-0.3846,0.1683,0.8709,-0.4617,0.1683,0.8597,-0.4558,0.2304,0.8960,-0.3797,0.2304,0.8709,-0.4617,0.1683,0.8277,-0.5354,0.1683,0.8171,-0.5285,0.2304,0.8597,-0.4558,0.2304,0.8277,-0.5354,0.1683,0.7782,-0.6050,0.1683,0.7682,-0.5972,0.2304,0.8171,-0.5285,0.2304,0.7782,-0.6050,0.1683,0.7229,-0.6701,0.1683,0.7137,-0.6615,0.2304,0.7682,-0.5972,0.2304,0.7229,-0.6701,0.1683,0.6622,-0.7302,0.1683,0.6537,-0.7208,0.2304,0.7137,-0.6615,0.2304,0.6622,-0.7302,0.1683,0.5965,-0.7847,0.1683,0.5889,-0.7747,0.2304,0.6537,-0.7208,0.2304};
			return value;
		}
		private double[] getNormal_5_14_vector_21()
		{
			double[] value = {0.5965,-0.7847,0.1683,0.5264,-0.8334,0.1683,0.5196,-0.8227,0.2304,0.5889,-0.7747,0.2304,0.5264,-0.8334,0.1683,0.4523,-0.8759,0.1683,0.4465,-0.8646,0.2304,0.5196,-0.8227,0.2304,0.4523,-0.8759,0.1683,0.3748,-0.9117,0.1683,0.3699,-0.9000,0.2304,0.4465,-0.8646,0.2304,0.3748,-0.9117,0.1683,0.2944,-0.9407,0.1683,0.2907,-0.9287,0.2304,0.3699,-0.9000,0.2304,0.2944,-0.9407,0.1683,0.2119,-0.9627,0.1683,0.2092,-0.9503,0.2304,0.2907,-0.9287,0.2304,0.2119,-0.9627,0.1683,0.1278,-0.9774,0.1683,0.1261,-0.9649,0.2304,0.2092,-0.9503,0.2304,0.1278,-0.9774,0.1683,0.0427,-0.9848,0.1683,0.0422,-0.9722,0.2304,0.1261,-0.9649,0.2304,0.0427,-0.9848,0.1683,-0.0427,-0.9848,0.1683,-0.0422,-0.9722,0.2304,0.0422,-0.9722,0.2304,-0.0427,-0.9848,0.1683,-0.1278,-0.9774,0.1683,-0.1261,-0.9649,0.2304,-0.0422,-0.9722,0.2304,-0.1278,-0.9774,0.1683,-0.2119,-0.9627,0.1683,-0.2092,-0.9503,0.2304,-0.1261,-0.9649,0.2304,-0.2119,-0.9627,0.1683,-0.2944,-0.9407,0.1683,-0.2907,-0.9287,0.2304,-0.2092,-0.9503,0.2304,-0.2944,-0.9407,0.1683,-0.3748,-0.9117,0.1683,-0.3699,-0.9000,0.2304,-0.2907,-0.9287,0.2304,-0.3748,-0.9117,0.1683,-0.4523,-0.8759,0.1683,-0.4465,-0.8646,0.2304,-0.3699,-0.9000,0.2304,-0.4523,-0.8759,0.1683,-0.5264,-0.8334,0.1683,-0.5196,-0.8227,0.2304,-0.4465,-0.8646,0.2304,-0.5264,-0.8334,0.1683,-0.5965,-0.7847,0.1683,-0.5889,-0.7747,0.2304,-0.5196,-0.8227,0.2304,-0.5965,-0.7847,0.1683,-0.6622,-0.7302,0.1683,-0.6537,-0.7208,0.2304,-0.5889,-0.7747,0.2304,-0.6622,-0.7302,0.1683,-0.7229,-0.6701,0.1683,-0.7137,-0.6615,0.2304,-0.6537,-0.7208,0.2304,-0.7229,-0.6701,0.1683,-0.7782,-0.6050,0.1683,-0.7682,-0.5972,0.2304,-0.7137,-0.6615,0.2304,-0.7782,-0.6050,0.1683,-0.8277,-0.5354,0.1683,-0.8171,-0.5285,0.2304,-0.7682,-0.5972,0.2304,-0.8277,-0.5354,0.1683,-0.8709,-0.4617,0.1683,-0.8597,-0.4558,0.2304,-0.8171,-0.5285,0.2304,-0.8709,-0.4617,0.1683,-0.9076,-0.3846,0.1683,-0.8960,-0.3797,0.2304,-0.8597,-0.4558,0.2304,-0.9076,-0.3846,0.1683,-0.9375,-0.3046,0.1683,-0.9255,-0.3007,0.2304,-0.8960,-0.3797,0.2304,0.9255,-0.3007,0.2304,0.8960,-0.3797,0.2304,0.8817,-0.3736,0.2880,0.9108,-0.2959,0.2880,0.8960,-0.3797,0.2304,0.8597,-0.4558,0.2304,0.8461,-0.4486,0.2880,0.8817,-0.3736,0.2880,0.8597,-0.4558,0.2304,0.8171,-0.5285,0.2304,0.8041,-0.5201,0.2880,0.8461,-0.4486,0.2880};
			return value;
		}
		private double[] getNormal_5_14_vector_22()
		{
			double[] value = {0.8171,-0.5285,0.2304,0.7682,-0.5972,0.2304,0.7560,-0.5878,0.2880,0.8041,-0.5201,0.2880,0.7682,-0.5972,0.2304,0.7137,-0.6615,0.2304,0.7023,-0.6510,0.2880,0.7560,-0.5878,0.2880,0.7137,-0.6615,0.2304,0.6537,-0.7208,0.2304,0.6433,-0.7093,0.2880,0.7023,-0.6510,0.2880,0.6537,-0.7208,0.2304,0.5889,-0.7747,0.2304,0.5795,-0.7624,0.2880,0.6433,-0.7093,0.2880,0.5889,-0.7747,0.2304,0.5196,-0.8227,0.2304,0.5114,-0.8097,0.2880,0.5795,-0.7624,0.2880,0.5196,-0.8227,0.2304,0.4465,-0.8646,0.2304,0.4394,-0.8509,0.2880,0.5114,-0.8097,0.2880,0.4465,-0.8646,0.2304,0.3699,-0.9000,0.2304,0.3641,-0.8857,0.2880,0.4394,-0.8509,0.2880,0.3699,-0.9000,0.2304,0.2907,-0.9287,0.2304,0.2860,-0.9139,0.2880,0.3641,-0.8857,0.2880,0.2907,-0.9287,0.2304,0.2092,-0.9503,0.2304,0.2059,-0.9352,0.2880,0.2860,-0.9139,0.2880,0.2092,-0.9503,0.2304,0.1261,-0.9649,0.2304,0.1241,-0.9495,0.2880,0.2059,-0.9352,0.2880,0.1261,-0.9649,0.2304,0.0422,-0.9722,0.2304,0.0415,-0.9567,0.2880,0.1241,-0.9495,0.2880,0.0422,-0.9722,0.2304,-0.0422,-0.9722,0.2304,-0.0415,-0.9567,0.2880,0.0415,-0.9567,0.2880,-0.0422,-0.9722,0.2304,-0.1261,-0.9649,0.2304,-0.1241,-0.9495,0.2880,-0.0415,-0.9567,0.2880,-0.1261,-0.9649,0.2304,-0.2092,-0.9503,0.2304,-0.2059,-0.9352,0.2880,-0.1241,-0.9495,0.2880,-0.2092,-0.9503,0.2304,-0.2907,-0.9287,0.2304,-0.2860,-0.9139,0.2880,-0.2059,-0.9352,0.2880,-0.2907,-0.9287,0.2304,-0.3699,-0.9000,0.2304,-0.3641,-0.8857,0.2880,-0.2860,-0.9139,0.2880,-0.3699,-0.9000,0.2304,-0.4465,-0.8646,0.2304,-0.4394,-0.8509,0.2880,-0.3641,-0.8857,0.2880,-0.4465,-0.8646,0.2304,-0.5196,-0.8227,0.2304,-0.5114,-0.8097,0.2880,-0.4394,-0.8509,0.2880,-0.5196,-0.8227,0.2304,-0.5889,-0.7747,0.2304,-0.5795,-0.7624,0.2880,-0.5114,-0.8097,0.2880,-0.5889,-0.7747,0.2304,-0.6537,-0.7208,0.2304,-0.6433,-0.7093,0.2880,-0.5795,-0.7624,0.2880,-0.6537,-0.7208,0.2304,-0.7137,-0.6615,0.2304,-0.7023,-0.6510,0.2880,-0.6433,-0.7093,0.2880,-0.7137,-0.6615,0.2304,-0.7682,-0.5972,0.2304,-0.7560,-0.5878,0.2880,-0.7023,-0.6510,0.2880,-0.7682,-0.5972,0.2304,-0.8171,-0.5285,0.2304,-0.8041,-0.5201,0.2880,-0.7560,-0.5878,0.2880,-0.8171,-0.5285,0.2304,-0.8597,-0.4558,0.2304,-0.8461,-0.4486,0.2880,-0.8041,-0.5201,0.2880,-0.8597,-0.4558,0.2304,-0.8960,-0.3797,0.2304,-0.8817,-0.3736,0.2880,-0.8461,-0.4486,0.2880};
			return value;
		}
		private double[] getNormal_5_14_vector_23()
		{
			double[] value = {-0.8960,-0.3797,0.2304,-0.9255,-0.3007,0.2304,-0.9108,-0.2959,0.2880,-0.8817,-0.3736,0.2880,0.9108,-0.2959,0.2880,0.8817,-0.3736,0.2880,0.8657,-0.3669,0.3405,0.8942,-0.2906,0.3405,0.8817,-0.3736,0.2880,0.8461,-0.4486,0.2880,0.8307,-0.4404,0.3405,0.8657,-0.3669,0.3405,0.8461,-0.4486,0.2880,0.8041,-0.5201,0.2880,0.7895,-0.5107,0.3405,0.8307,-0.4404,0.3405,0.8041,-0.5201,0.2880,0.7560,-0.5878,0.2880,0.7423,-0.5771,0.3405,0.7895,-0.5107,0.3405,0.7560,-0.5878,0.2880,0.7023,-0.6510,0.2880,0.6896,-0.6392,0.3405,0.7423,-0.5771,0.3405,0.7023,-0.6510,0.2880,0.6433,-0.7093,0.2880,0.6317,-0.6965,0.3405,0.6896,-0.6392,0.3405,0.6433,-0.7093,0.2880,0.5795,-0.7624,0.2880,0.5690,-0.7485,0.3405,0.6317,-0.6965,0.3405,0.5795,-0.7624,0.2880,0.5114,-0.8097,0.2880,0.5021,-0.7950,0.3405,0.5690,-0.7485,0.3405,0.5114,-0.8097,0.2880,0.4394,-0.8509,0.2880,0.4314,-0.8354,0.3405,0.5021,-0.7950,0.3405,0.4394,-0.8509,0.2880,0.3641,-0.8857,0.2880,0.3575,-0.8697,0.3405,0.4314,-0.8354,0.3405,0.3641,-0.8857,0.2880,0.2860,-0.9139,0.2880,0.2809,-0.8973,0.3405,0.3575,-0.8697,0.3405,0.2860,-0.9139,0.2880,0.2059,-0.9352,0.2880,0.2021,-0.9183,0.3405,0.2809,-0.8973,0.3405,0.2059,-0.9352,0.2880,0.1241,-0.9495,0.2880,0.1219,-0.9323,0.3405,0.2021,-0.9183,0.3405,0.1241,-0.9495,0.2880,0.0415,-0.9567,0.2880,0.0407,-0.9394,0.3405,0.1219,-0.9323,0.3405,0.0415,-0.9567,0.2880,-0.0415,-0.9567,0.2880,-0.0407,-0.9394,0.3405,0.0407,-0.9394,0.3405,-0.0415,-0.9567,0.2880,-0.1241,-0.9495,0.2880,-0.1219,-0.9323,0.3405,-0.0407,-0.9394,0.3405,-0.1241,-0.9495,0.2880,-0.2059,-0.9352,0.2880,-0.2021,-0.9183,0.3405,-0.1219,-0.9323,0.3405,-0.2059,-0.9352,0.2880,-0.2860,-0.9139,0.2880,-0.2809,-0.8973,0.3405,-0.2021,-0.9183,0.3405,-0.2860,-0.9139,0.2880,-0.3641,-0.8857,0.2880,-0.3575,-0.8697,0.3405,-0.2809,-0.8973,0.3405,-0.3641,-0.8857,0.2880,-0.4394,-0.8509,0.2880,-0.4314,-0.8354,0.3405,-0.3575,-0.8697,0.3405,-0.4394,-0.8509,0.2880,-0.5114,-0.8097,0.2880,-0.5021,-0.7950,0.3405,-0.4314,-0.8354,0.3405,-0.5114,-0.8097,0.2880,-0.5795,-0.7624,0.2880,-0.5690,-0.7485,0.3405,-0.5021,-0.7950,0.3405,-0.5795,-0.7624,0.2880,-0.6433,-0.7093,0.2880,-0.6317,-0.6965,0.3405,-0.5690,-0.7485,0.3405,-0.6433,-0.7093,0.2880,-0.7023,-0.6510,0.2880,-0.6896,-0.6392,0.3405,-0.6317,-0.6965,0.3405};
			return value;
		}
		private double[] getNormal_5_14_vector_24()
		{
			double[] value = {-0.7023,-0.6510,0.2880,-0.7560,-0.5878,0.2880,-0.7423,-0.5771,0.3405,-0.6896,-0.6392,0.3405,-0.7560,-0.5878,0.2880,-0.8041,-0.5201,0.2880,-0.7895,-0.5107,0.3405,-0.7423,-0.5771,0.3405,-0.8041,-0.5201,0.2880,-0.8461,-0.4486,0.2880,-0.8307,-0.4404,0.3405,-0.7895,-0.5107,0.3405,-0.8461,-0.4486,0.2880,-0.8817,-0.3736,0.2880,-0.8657,-0.3669,0.3405,-0.8307,-0.4404,0.3405,-0.8817,-0.3736,0.2880,-0.9108,-0.2959,0.2880,-0.8942,-0.2906,0.3405,-0.8657,-0.3669,0.3405,0.8942,-0.2906,0.3405,0.8657,-0.3669,0.3405,0.8488,-0.3597,0.3876,0.8767,-0.2849,0.3876,0.8657,-0.3669,0.3405,0.8307,-0.4404,0.3405,0.8144,-0.4318,0.3876,0.8488,-0.3597,0.3876,0.8307,-0.4404,0.3405,0.7895,-0.5107,0.3405,0.7740,-0.5007,0.3876,0.8144,-0.4318,0.3876,0.7895,-0.5107,0.3405,0.7423,-0.5771,0.3405,0.7278,-0.5658,0.3876,0.7740,-0.5007,0.3876,0.7423,-0.5771,0.3405,0.6896,-0.6392,0.3405,0.6761,-0.6267,0.3876,0.7278,-0.5658,0.3876,0.6896,-0.6392,0.3405,0.6317,-0.6965,0.3405,0.6193,-0.6828,0.3876,0.6761,-0.6267,0.3876,0.6317,-0.6965,0.3405,0.5690,-0.7485,0.3405,0.5579,-0.7339,0.3876,0.6193,-0.6828,0.3876,0.5690,-0.7485,0.3405,0.5021,-0.7950,0.3405,0.4923,-0.7794,0.3876,0.5579,-0.7339,0.3876,0.5021,-0.7950,0.3405,0.4314,-0.8354,0.3405,0.4229,-0.8191,0.3876,0.4923,-0.7794,0.3876,0.4314,-0.8354,0.3405,0.3575,-0.8697,0.3405,0.3505,-0.8526,0.3876,0.4229,-0.8191,0.3876,0.3575,-0.8697,0.3405,0.2809,-0.8973,0.3405,0.2753,-0.8797,0.3876,0.3505,-0.8526,0.3876,0.2809,-0.8973,0.3405,0.2021,-0.9183,0.3405,0.1982,-0.9003,0.3876,0.2753,-0.8797,0.3876,0.2021,-0.9183,0.3405,0.1219,-0.9323,0.3405,0.1195,-0.9140,0.3876,0.1982,-0.9003,0.3876,0.1219,-0.9323,0.3405,0.0407,-0.9394,0.3405,0.0399,-0.9210,0.3876,0.1195,-0.9140,0.3876,0.0407,-0.9394,0.3405,-0.0407,-0.9394,0.3405,-0.0399,-0.9210,0.3876,0.0399,-0.9210,0.3876,-0.0407,-0.9394,0.3405,-0.1219,-0.9323,0.3405,-0.1195,-0.9140,0.3876,-0.0399,-0.9210,0.3876,-0.1219,-0.9323,0.3405,-0.2021,-0.9183,0.3405,-0.1982,-0.9003,0.3876,-0.1195,-0.9140,0.3876,-0.2021,-0.9183,0.3405,-0.2809,-0.8973,0.3405,-0.2753,-0.8797,0.3876,-0.1982,-0.9003,0.3876,-0.2809,-0.8973,0.3405,-0.3575,-0.8697,0.3405,-0.3505,-0.8526,0.3876,-0.2753,-0.8797,0.3876,-0.3575,-0.8697,0.3405,-0.4314,-0.8354,0.3405,-0.4229,-0.8191,0.3876,-0.3505,-0.8526,0.3876};
			return value;
		}
		private double[] getNormal_5_14_vector_25()
		{
			double[] value = {-0.4314,-0.8354,0.3405,-0.5021,-0.7950,0.3405,-0.4923,-0.7794,0.3876,-0.4229,-0.8191,0.3876,-0.5021,-0.7950,0.3405,-0.5690,-0.7485,0.3405,-0.5579,-0.7339,0.3876,-0.4923,-0.7794,0.3876,-0.5690,-0.7485,0.3405,-0.6317,-0.6965,0.3405,-0.6193,-0.6828,0.3876,-0.5579,-0.7339,0.3876,-0.6317,-0.6965,0.3405,-0.6896,-0.6392,0.3405,-0.6761,-0.6267,0.3876,-0.6193,-0.6828,0.3876,-0.6896,-0.6392,0.3405,-0.7423,-0.5771,0.3405,-0.7278,-0.5658,0.3876,-0.6761,-0.6267,0.3876,-0.7423,-0.5771,0.3405,-0.7895,-0.5107,0.3405,-0.7740,-0.5007,0.3876,-0.7278,-0.5658,0.3876,-0.7895,-0.5107,0.3405,-0.8307,-0.4404,0.3405,-0.8144,-0.4318,0.3876,-0.7740,-0.5007,0.3876,-0.8307,-0.4404,0.3405,-0.8657,-0.3669,0.3405,-0.8488,-0.3597,0.3876,-0.8144,-0.4318,0.3876,-0.8657,-0.3669,0.3405,-0.8942,-0.2906,0.3405,-0.8767,-0.2849,0.3876,-0.8488,-0.3597,0.3876,0.8767,-0.2849,0.3876,0.8488,-0.3597,0.3876,0.8315,-0.3524,0.4295,0.8589,-0.2791,0.4295,0.8488,-0.3597,0.3876,0.8144,-0.4318,0.3876,0.7979,-0.4230,0.4295,0.8315,-0.3524,0.4295,0.8144,-0.4318,0.3876,0.7740,-0.5007,0.3876,0.7583,-0.4905,0.4295,0.7979,-0.4230,0.4295,0.7740,-0.5007,0.3876,0.7278,-0.5658,0.3876,0.7130,-0.5543,0.4295,0.7583,-0.4905,0.4295,0.7278,-0.5658,0.3876,0.6761,-0.6267,0.3876,0.6623,-0.6139,0.4295,0.7130,-0.5543,0.4295,0.6761,-0.6267,0.3876,0.6193,-0.6828,0.3876,0.6067,-0.6689,0.4295,0.6623,-0.6139,0.4295,0.6193,-0.6828,0.3876,0.5579,-0.7339,0.3876,0.5465,-0.7189,0.4295,0.6067,-0.6689,0.4295,0.5579,-0.7339,0.3876,0.4923,-0.7794,0.3876,0.4822,-0.7635,0.4295,0.5465,-0.7189,0.4295,0.4923,-0.7794,0.3876,0.4229,-0.8191,0.3876,0.4143,-0.8024,0.4295,0.4822,-0.7635,0.4295,0.4229,-0.8191,0.3876,0.3505,-0.8526,0.3876,0.3433,-0.8353,0.4295,0.4143,-0.8024,0.4295,0.3505,-0.8526,0.3876,0.2753,-0.8797,0.3876,0.2697,-0.8619,0.4295,0.3433,-0.8353,0.4295,0.2753,-0.8797,0.3876,0.1982,-0.9003,0.3876,0.1941,-0.8820,0.4295,0.2697,-0.8619,0.4295,0.1982,-0.9003,0.3876,0.1195,-0.9140,0.3876,0.1171,-0.8955,0.4295,0.1941,-0.8820,0.4295,0.1195,-0.9140,0.3876,0.0399,-0.9210,0.3876,0.0391,-0.9022,0.4295,0.1171,-0.8955,0.4295,0.0399,-0.9210,0.3876,-0.0399,-0.9210,0.3876,-0.0391,-0.9022,0.4295,0.0391,-0.9022,0.4295,-0.0399,-0.9210,0.3876,-0.1195,-0.9140,0.3876,-0.1171,-0.8955,0.4295,-0.0391,-0.9022,0.4295};
			return value;
		}
		private double[] getNormal_5_14_vector_26()
		{
			double[] value = {-0.1195,-0.9140,0.3876,-0.1982,-0.9003,0.3876,-0.1941,-0.8820,0.4295,-0.1171,-0.8955,0.4295,-0.1982,-0.9003,0.3876,-0.2753,-0.8797,0.3876,-0.2697,-0.8619,0.4295,-0.1941,-0.8820,0.4295,-0.2753,-0.8797,0.3876,-0.3505,-0.8526,0.3876,-0.3433,-0.8353,0.4295,-0.2697,-0.8619,0.4295,-0.3505,-0.8526,0.3876,-0.4229,-0.8191,0.3876,-0.4143,-0.8024,0.4295,-0.3433,-0.8353,0.4295,-0.4229,-0.8191,0.3876,-0.4923,-0.7794,0.3876,-0.4822,-0.7635,0.4295,-0.4143,-0.8024,0.4295,-0.4923,-0.7794,0.3876,-0.5579,-0.7339,0.3876,-0.5465,-0.7189,0.4295,-0.4822,-0.7635,0.4295,-0.5579,-0.7339,0.3876,-0.6193,-0.6828,0.3876,-0.6067,-0.6689,0.4295,-0.5465,-0.7189,0.4295,-0.6193,-0.6828,0.3876,-0.6761,-0.6267,0.3876,-0.6623,-0.6139,0.4295,-0.6067,-0.6689,0.4295,-0.6761,-0.6267,0.3876,-0.7278,-0.5658,0.3876,-0.7130,-0.5543,0.4295,-0.6623,-0.6139,0.4295,-0.7278,-0.5658,0.3876,-0.7740,-0.5007,0.3876,-0.7583,-0.4905,0.4295,-0.7130,-0.5543,0.4295,-0.7740,-0.5007,0.3876,-0.8144,-0.4318,0.3876,-0.7979,-0.4230,0.4295,-0.7583,-0.4905,0.4295,-0.8144,-0.4318,0.3876,-0.8488,-0.3597,0.3876,-0.8315,-0.3524,0.4295,-0.7979,-0.4230,0.4295,-0.8488,-0.3597,0.3876,-0.8767,-0.2849,0.3876,-0.8589,-0.2791,0.4295,-0.8315,-0.3524,0.4295,0.8589,-0.2791,0.4295,0.8315,-0.3524,0.4295,0.8145,-0.3452,0.4663,0.8413,-0.2734,0.4663,0.8315,-0.3524,0.4295,0.7979,-0.4230,0.4295,0.7816,-0.4144,0.4663,0.8145,-0.3452,0.4663,0.7979,-0.4230,0.4295,0.7583,-0.4905,0.4295,0.7428,-0.4805,0.4663,0.7816,-0.4144,0.4663,0.7583,-0.4905,0.4295,0.7130,-0.5543,0.4295,0.6984,-0.5429,0.4663,0.7428,-0.4805,0.4663,0.7130,-0.5543,0.4295,0.6623,-0.6139,0.4295,0.6488,-0.6014,0.4663,0.6984,-0.5429,0.4663,0.6623,-0.6139,0.4295,0.6067,-0.6689,0.4295,0.5943,-0.6553,0.4663,0.6488,-0.6014,0.4663,0.6067,-0.6689,0.4295,0.5465,-0.7189,0.4295,0.5353,-0.7042,0.4663,0.5943,-0.6553,0.4663,0.5465,-0.7189,0.4295,0.4822,-0.7635,0.4295,0.4724,-0.7479,0.4663,0.5353,-0.7042,0.4663,0.4822,-0.7635,0.4295,0.4143,-0.8024,0.4295,0.4059,-0.7860,0.4663,0.4724,-0.7479,0.4663,0.4143,-0.8024,0.4295,0.3433,-0.8353,0.4295,0.3363,-0.8182,0.4663,0.4059,-0.7860,0.4663,0.3433,-0.8353,0.4295,0.2697,-0.8619,0.4295,0.2642,-0.8442,0.4663,0.3363,-0.8182,0.4663,0.2697,-0.8619,0.4295,0.1941,-0.8820,0.4295,0.1902,-0.8639,0.4663,0.2642,-0.8442,0.4663};
			return value;
		}
		private double[] getNormal_5_14_vector_27()
		{
			double[] value = {0.1941,-0.8820,0.4295,0.1171,-0.8955,0.4295,0.1147,-0.8771,0.4663,0.1902,-0.8639,0.4663,0.1171,-0.8955,0.4295,0.0391,-0.9022,0.4295,0.0383,-0.8838,0.4663,0.1147,-0.8771,0.4663,0.0391,-0.9022,0.4295,-0.0391,-0.9022,0.4295,-0.0383,-0.8838,0.4663,0.0383,-0.8838,0.4663,-0.0391,-0.9022,0.4295,-0.1171,-0.8955,0.4295,-0.1147,-0.8771,0.4663,-0.0383,-0.8838,0.4663,-0.1171,-0.8955,0.4295,-0.1941,-0.8820,0.4295,-0.1902,-0.8639,0.4663,-0.1147,-0.8771,0.4663,-0.1941,-0.8820,0.4295,-0.2697,-0.8619,0.4295,-0.2642,-0.8442,0.4663,-0.1902,-0.8639,0.4663,-0.2697,-0.8619,0.4295,-0.3433,-0.8353,0.4295,-0.3363,-0.8182,0.4663,-0.2642,-0.8442,0.4663,-0.3433,-0.8353,0.4295,-0.4143,-0.8024,0.4295,-0.4059,-0.7860,0.4663,-0.3363,-0.8182,0.4663,-0.4143,-0.8024,0.4295,-0.4822,-0.7635,0.4295,-0.4724,-0.7479,0.4663,-0.4059,-0.7860,0.4663,-0.4822,-0.7635,0.4295,-0.5465,-0.7189,0.4295,-0.5353,-0.7042,0.4663,-0.4724,-0.7479,0.4663,-0.5465,-0.7189,0.4295,-0.6067,-0.6689,0.4295,-0.5943,-0.6553,0.4663,-0.5353,-0.7042,0.4663,-0.6067,-0.6689,0.4295,-0.6623,-0.6139,0.4295,-0.6488,-0.6014,0.4663,-0.5943,-0.6553,0.4663,-0.6623,-0.6139,0.4295,-0.7130,-0.5543,0.4295,-0.6984,-0.5429,0.4663,-0.6488,-0.6014,0.4663,-0.7130,-0.5543,0.4295,-0.7583,-0.4905,0.4295,-0.7428,-0.4805,0.4663,-0.6984,-0.5429,0.4663,-0.7583,-0.4905,0.4295,-0.7979,-0.4230,0.4295,-0.7816,-0.4144,0.4663,-0.7428,-0.4805,0.4663,-0.7979,-0.4230,0.4295,-0.8315,-0.3524,0.4295,-0.8145,-0.3452,0.4663,-0.7816,-0.4144,0.4663,-0.8315,-0.3524,0.4295,-0.8589,-0.2791,0.4295,-0.8413,-0.2734,0.4663,-0.8145,-0.3452,0.4663,0.8413,-0.2734,0.4663,0.8145,-0.3452,0.4663,0.7981,-0.3382,0.4986,0.8244,-0.2679,0.4986,0.8145,-0.3452,0.4663,0.7816,-0.4144,0.4663,0.7659,-0.4060,0.4986,0.7981,-0.3382,0.4986,0.7816,-0.4144,0.4663,0.7428,-0.4805,0.4663,0.7279,-0.4708,0.4986,0.7659,-0.4060,0.4986,0.7428,-0.4805,0.4663,0.6984,-0.5429,0.4663,0.6844,-0.5320,0.4986,0.7279,-0.4708,0.4986,0.6984,-0.5429,0.4663,0.6488,-0.6014,0.4663,0.6358,-0.5893,0.4986,0.6844,-0.5320,0.4986,0.6488,-0.6014,0.4663,0.5943,-0.6553,0.4663,0.5824,-0.6421,0.4986,0.6358,-0.5893,0.4986,0.5943,-0.6553,0.4663,0.5353,-0.7042,0.4663,0.5246,-0.6901,0.4986,0.5824,-0.6421,0.4986,0.5353,-0.7042,0.4663,0.4724,-0.7479,0.4663,0.4629,-0.7329,0.4986,0.5246,-0.6901,0.4986};
			return value;
		}
		private double[] getNormal_5_14_vector_28()
		{
			double[] value = {0.4724,-0.7479,0.4663,0.4059,-0.7860,0.4663,0.3977,-0.7702,0.4986,0.4629,-0.7329,0.4986,0.4059,-0.7860,0.4663,0.3363,-0.8182,0.4663,0.3296,-0.8018,0.4986,0.3977,-0.7702,0.4986,0.3363,-0.8182,0.4663,0.2642,-0.8442,0.4663,0.2589,-0.8273,0.4986,0.3296,-0.8018,0.4986,0.2642,-0.8442,0.4663,0.1902,-0.8639,0.4663,0.1863,-0.8466,0.4986,0.2589,-0.8273,0.4986,0.1902,-0.8639,0.4663,0.1147,-0.8771,0.4663,0.1124,-0.8595,0.4986,0.1863,-0.8466,0.4986,0.1147,-0.8771,0.4663,0.0383,-0.8838,0.4663,0.0376,-0.8660,0.4986,0.1124,-0.8595,0.4986,0.0383,-0.8838,0.4663,-0.0383,-0.8838,0.4663,-0.0376,-0.8660,0.4986,0.0376,-0.8660,0.4986,-0.0383,-0.8838,0.4663,-0.1147,-0.8771,0.4663,-0.1124,-0.8595,0.4986,-0.0376,-0.8660,0.4986,-0.1147,-0.8771,0.4663,-0.1902,-0.8639,0.4663,-0.1863,-0.8466,0.4986,-0.1124,-0.8595,0.4986,-0.1902,-0.8639,0.4663,-0.2642,-0.8442,0.4663,-0.2589,-0.8273,0.4986,-0.1863,-0.8466,0.4986,-0.2642,-0.8442,0.4663,-0.3363,-0.8182,0.4663,-0.3296,-0.8018,0.4986,-0.2589,-0.8273,0.4986,-0.3363,-0.8182,0.4663,-0.4059,-0.7860,0.4663,-0.3977,-0.7702,0.4986,-0.3296,-0.8018,0.4986,-0.4059,-0.7860,0.4663,-0.4724,-0.7479,0.4663,-0.4629,-0.7329,0.4986,-0.3977,-0.7702,0.4986,-0.4724,-0.7479,0.4663,-0.5353,-0.7042,0.4663,-0.5246,-0.6901,0.4986,-0.4629,-0.7329,0.4986,-0.5353,-0.7042,0.4663,-0.5943,-0.6553,0.4663,-0.5824,-0.6421,0.4986,-0.5246,-0.6901,0.4986,-0.5943,-0.6553,0.4663,-0.6488,-0.6014,0.4663,-0.6358,-0.5893,0.4986,-0.5824,-0.6421,0.4986,-0.6488,-0.6014,0.4663,-0.6984,-0.5429,0.4663,-0.6844,-0.5320,0.4986,-0.6358,-0.5893,0.4986,-0.6984,-0.5429,0.4663,-0.7428,-0.4805,0.4663,-0.7279,-0.4708,0.4986,-0.6844,-0.5320,0.4986,-0.7428,-0.4805,0.4663,-0.7816,-0.4144,0.4663,-0.7659,-0.4060,0.4986,-0.7279,-0.4708,0.4986,-0.7816,-0.4144,0.4663,-0.8145,-0.3452,0.4663,-0.7981,-0.3382,0.4986,-0.7659,-0.4060,0.4986,-0.8145,-0.3452,0.4663,-0.8413,-0.2734,0.4663,-0.8244,-0.2679,0.4986,-0.7981,-0.3382,0.4986,0.8244,-0.2679,0.4986,0.7981,-0.3382,0.4986,0.7827,-0.3317,0.5266,0.8085,-0.2627,0.5266,0.7981,-0.3382,0.4986,0.7659,-0.4060,0.4986,0.7511,-0.3982,0.5266,0.7827,-0.3317,0.5266,0.7659,-0.4060,0.4986,0.7279,-0.4708,0.4986,0.7138,-0.4617,0.5266,0.7511,-0.3982,0.5266,0.7279,-0.4708,0.4986,0.6844,-0.5320,0.4986,0.6712,-0.5218,0.5266,0.7138,-0.4617,0.5266};
			return value;
		}
		private double[] getNormal_5_14_vector_29()
		{
			double[] value = {0.6844,-0.5320,0.4986,0.6358,-0.5893,0.4986,0.6235,-0.5779,0.5266,0.6712,-0.5218,0.5266,0.6358,-0.5893,0.4986,0.5824,-0.6421,0.4986,0.5711,-0.6297,0.5266,0.6235,-0.5779,0.5266,0.5824,-0.6421,0.4986,0.5246,-0.6901,0.4986,0.5145,-0.6768,0.5266,0.5711,-0.6297,0.5266,0.5246,-0.6901,0.4986,0.4629,-0.7329,0.4986,0.4540,-0.7188,0.5266,0.5145,-0.6768,0.5266,0.4629,-0.7329,0.4986,0.3977,-0.7702,0.4986,0.3900,-0.7553,0.5266,0.4540,-0.7188,0.5266,0.3977,-0.7702,0.4986,0.3296,-0.8018,0.4986,0.3232,-0.7863,0.5266,0.3900,-0.7553,0.5266,0.3296,-0.8018,0.4986,0.2589,-0.8273,0.4986,0.2539,-0.8113,0.5266,0.3232,-0.7863,0.5266,0.2589,-0.8273,0.4986,0.1863,-0.8466,0.4986,0.1827,-0.8302,0.5266,0.2539,-0.8113,0.5266,0.1863,-0.8466,0.4986,0.1124,-0.8595,0.4986,0.1102,-0.8429,0.5266,0.1827,-0.8302,0.5266,0.1124,-0.8595,0.4986,0.0376,-0.8660,0.4986,0.0368,-0.8493,0.5266,0.1102,-0.8429,0.5266,0.0376,-0.8660,0.4986,-0.0376,-0.8660,0.4986,-0.0368,-0.8493,0.5266,0.0368,-0.8493,0.5266,-0.0376,-0.8660,0.4986,-0.1124,-0.8595,0.4986,-0.1102,-0.8429,0.5266,-0.0368,-0.8493,0.5266,-0.1124,-0.8595,0.4986,-0.1863,-0.8466,0.4986,-0.1827,-0.8302,0.5266,-0.1102,-0.8429,0.5266,-0.1863,-0.8466,0.4986,-0.2589,-0.8273,0.4986,-0.2539,-0.8113,0.5266,-0.1827,-0.8302,0.5266,-0.2589,-0.8273,0.4986,-0.3296,-0.8018,0.4986,-0.3232,-0.7863,0.5266,-0.2539,-0.8113,0.5266,-0.3296,-0.8018,0.4986,-0.3977,-0.7702,0.4986,-0.3900,-0.7553,0.5266,-0.3232,-0.7863,0.5266,-0.3977,-0.7702,0.4986,-0.4629,-0.7329,0.4986,-0.4540,-0.7188,0.5266,-0.3900,-0.7553,0.5266,-0.4629,-0.7329,0.4986,-0.5246,-0.6901,0.4986,-0.5145,-0.6768,0.5266,-0.4540,-0.7188,0.5266,-0.5246,-0.6901,0.4986,-0.5824,-0.6421,0.4986,-0.5711,-0.6297,0.5266,-0.5145,-0.6768,0.5266,-0.5824,-0.6421,0.4986,-0.6358,-0.5893,0.4986,-0.6235,-0.5779,0.5266,-0.5711,-0.6297,0.5266,-0.6358,-0.5893,0.4986,-0.6844,-0.5320,0.4986,-0.6712,-0.5218,0.5266,-0.6235,-0.5779,0.5266,-0.6844,-0.5320,0.4986,-0.7279,-0.4708,0.4986,-0.7138,-0.4617,0.5266,-0.6712,-0.5218,0.5266,-0.7279,-0.4708,0.4986,-0.7659,-0.4060,0.4986,-0.7511,-0.3982,0.5266,-0.7138,-0.4617,0.5266,-0.7659,-0.4060,0.4986,-0.7981,-0.3382,0.4986,-0.7827,-0.3317,0.5266,-0.7511,-0.3982,0.5266,-0.7981,-0.3382,0.4986,-0.8244,-0.2679,0.4986,-0.8085,-0.2627,0.5266,-0.7827,-0.3317,0.5266};
			return value;
		}
		private double[] getNormal_5_14_vector_30()
		{
			double[] value = {0.8085,-0.2627,0.5266,0.7827,-0.3317,0.5266,0.7684,-0.3256,0.5509,0.7937,-0.2579,0.5509,0.7827,-0.3317,0.5266,0.7511,-0.3982,0.5266,0.7373,-0.3909,0.5509,0.7684,-0.3256,0.5509,0.7511,-0.3982,0.5266,0.7138,-0.4617,0.5266,0.7007,-0.4533,0.5509,0.7373,-0.3909,0.5509,0.7138,-0.4617,0.5266,0.6712,-0.5218,0.5266,0.6589,-0.5122,0.5509,0.7007,-0.4533,0.5509,0.6712,-0.5218,0.5266,0.6235,-0.5779,0.5266,0.6121,-0.5673,0.5509,0.6589,-0.5122,0.5509,0.6235,-0.5779,0.5266,0.5711,-0.6297,0.5266,0.5607,-0.6182,0.5509,0.6121,-0.5673,0.5509,0.5711,-0.6297,0.5266,0.5145,-0.6768,0.5266,0.5050,-0.6644,0.5509,0.5607,-0.6182,0.5509,0.5145,-0.6768,0.5266,0.4540,-0.7188,0.5266,0.4456,-0.7056,0.5509,0.5050,-0.6644,0.5509,0.4540,-0.7188,0.5266,0.3900,-0.7553,0.5266,0.3829,-0.7415,0.5509,0.4456,-0.7056,0.5509,0.3900,-0.7553,0.5266,0.3232,-0.7863,0.5266,0.3173,-0.7719,0.5509,0.3829,-0.7415,0.5509,0.3232,-0.7863,0.5266,0.2539,-0.8113,0.5266,0.2493,-0.7964,0.5509,0.3173,-0.7719,0.5509,0.2539,-0.8113,0.5266,0.1827,-0.8302,0.5266,0.1794,-0.8150,0.5509,0.2493,-0.7964,0.5509,0.1827,-0.8302,0.5266,0.1102,-0.8429,0.5266,0.1082,-0.8275,0.5509,0.1794,-0.8150,0.5509,0.1102,-0.8429,0.5266,0.0368,-0.8493,0.5266,0.0362,-0.8338,0.5509,0.1082,-0.8275,0.5509,0.0368,-0.8493,0.5266,-0.0368,-0.8493,0.5266,-0.0362,-0.8338,0.5509,0.0362,-0.8338,0.5509,-0.0368,-0.8493,0.5266,-0.1102,-0.8429,0.5266,-0.1082,-0.8275,0.5509,-0.0362,-0.8338,0.5509,-0.1102,-0.8429,0.5266,-0.1827,-0.8302,0.5266,-0.1794,-0.8150,0.5509,-0.1082,-0.8275,0.5509,-0.1827,-0.8302,0.5266,-0.2539,-0.8113,0.5266,-0.2493,-0.7964,0.5509,-0.1794,-0.8150,0.5509,-0.2539,-0.8113,0.5266,-0.3232,-0.7863,0.5266,-0.3173,-0.7719,0.5509,-0.2493,-0.7964,0.5509,-0.3232,-0.7863,0.5266,-0.3900,-0.7553,0.5266,-0.3829,-0.7415,0.5509,-0.3173,-0.7719,0.5509,-0.3900,-0.7553,0.5266,-0.4540,-0.7188,0.5266,-0.4456,-0.7056,0.5509,-0.3829,-0.7415,0.5509,-0.4540,-0.7188,0.5266,-0.5145,-0.6768,0.5266,-0.5050,-0.6644,0.5509,-0.4456,-0.7056,0.5509,-0.5145,-0.6768,0.5266,-0.5711,-0.6297,0.5266,-0.5607,-0.6182,0.5509,-0.5050,-0.6644,0.5509,-0.5711,-0.6297,0.5266,-0.6235,-0.5779,0.5266,-0.6121,-0.5673,0.5509,-0.5607,-0.6182,0.5509,-0.6235,-0.5779,0.5266,-0.6712,-0.5218,0.5266,-0.6589,-0.5122,0.5509,-0.6121,-0.5673,0.5509};
			return value;
		}
		private double[] getNormal_5_14_vector_31()
		{
			double[] value = {-0.6712,-0.5218,0.5266,-0.7138,-0.4617,0.5266,-0.7007,-0.4533,0.5509,-0.6589,-0.5122,0.5509,-0.7138,-0.4617,0.5266,-0.7511,-0.3982,0.5266,-0.7373,-0.3909,0.5509,-0.7007,-0.4533,0.5509,-0.7511,-0.3982,0.5266,-0.7827,-0.3317,0.5266,-0.7684,-0.3256,0.5509,-0.7373,-0.3909,0.5509,-0.7827,-0.3317,0.5266,-0.8085,-0.2627,0.5266,-0.7937,-0.2579,0.5509,-0.7684,-0.3256,0.5509,0.7937,-0.2579,0.5509,0.7684,-0.3256,0.5509,0.7552,-0.3200,0.5720,0.7801,-0.2535,0.5720,0.7684,-0.3256,0.5509,0.7373,-0.3909,0.5509,0.7247,-0.3842,0.5720,0.7552,-0.3200,0.5720,0.7373,-0.3909,0.5509,0.7007,-0.4533,0.5509,0.6887,-0.4455,0.5720,0.7247,-0.3842,0.5720,0.7007,-0.4533,0.5509,0.6589,-0.5122,0.5509,0.6476,-0.5034,0.5720,0.6887,-0.4455,0.5720,0.6589,-0.5122,0.5509,0.6121,-0.5673,0.5509,0.6016,-0.5576,0.5720,0.6476,-0.5034,0.5720,0.6121,-0.5673,0.5509,0.5607,-0.6182,0.5509,0.5511,-0.6076,0.5720,0.6016,-0.5576,0.5720,0.5607,-0.6182,0.5509,0.5050,-0.6644,0.5509,0.4964,-0.6530,0.5720,0.5511,-0.6076,0.5720,0.5050,-0.6644,0.5509,0.4456,-0.7056,0.5509,0.4380,-0.6935,0.5720,0.4964,-0.6530,0.5720,0.4456,-0.7056,0.5509,0.3829,-0.7415,0.5509,0.3763,-0.7288,0.5720,0.4380,-0.6935,0.5720,0.3829,-0.7415,0.5509,0.3173,-0.7719,0.5509,0.3118,-0.7587,0.5720,0.3763,-0.7288,0.5720,0.3173,-0.7719,0.5509,0.2493,-0.7964,0.5509,0.2450,-0.7828,0.5720,0.3118,-0.7587,0.5720,0.2493,-0.7964,0.5509,0.1794,-0.8150,0.5509,0.1763,-0.8011,0.5720,0.2450,-0.7828,0.5720,0.1794,-0.8150,0.5509,0.1082,-0.8275,0.5509,0.1063,-0.8133,0.5720,0.1763,-0.8011,0.5720,0.1082,-0.8275,0.5509,0.0362,-0.8338,0.5509,0.0355,-0.8195,0.5720,0.1063,-0.8133,0.5720,0.0362,-0.8338,0.5509,-0.0362,-0.8338,0.5509,-0.0355,-0.8195,0.5720,0.0355,-0.8195,0.5720,-0.0362,-0.8338,0.5509,-0.1082,-0.8275,0.5509,-0.1063,-0.8133,0.5720,-0.0355,-0.8195,0.5720,-0.1082,-0.8275,0.5509,-0.1794,-0.8150,0.5509,-0.1763,-0.8011,0.5720,-0.1063,-0.8133,0.5720,-0.1794,-0.8150,0.5509,-0.2493,-0.7964,0.5509,-0.2450,-0.7828,0.5720,-0.1763,-0.8011,0.5720,-0.2493,-0.7964,0.5509,-0.3173,-0.7719,0.5509,-0.3118,-0.7587,0.5720,-0.2450,-0.7828,0.5720,-0.3173,-0.7719,0.5509,-0.3829,-0.7415,0.5509,-0.3763,-0.7288,0.5720,-0.3118,-0.7587,0.5720,-0.3829,-0.7415,0.5509,-0.4456,-0.7056,0.5509,-0.4380,-0.6935,0.5720,-0.3763,-0.7288,0.5720};
			return value;
		}
		private double[] getNormal_5_14_vector_32()
		{
			double[] value = {-0.4456,-0.7056,0.5509,-0.5050,-0.6644,0.5509,-0.4964,-0.6530,0.5720,-0.4380,-0.6935,0.5720,-0.5050,-0.6644,0.5509,-0.5607,-0.6182,0.5509,-0.5511,-0.6076,0.5720,-0.4964,-0.6530,0.5720,-0.5607,-0.6182,0.5509,-0.6121,-0.5673,0.5509,-0.6016,-0.5576,0.5720,-0.5511,-0.6076,0.5720,-0.6121,-0.5673,0.5509,-0.6589,-0.5122,0.5509,-0.6476,-0.5034,0.5720,-0.6016,-0.5576,0.5720,-0.6589,-0.5122,0.5509,-0.7007,-0.4533,0.5509,-0.6887,-0.4455,0.5720,-0.6476,-0.5034,0.5720,-0.7007,-0.4533,0.5509,-0.7373,-0.3909,0.5509,-0.7247,-0.3842,0.5720,-0.6887,-0.4455,0.5720,-0.7373,-0.3909,0.5509,-0.7684,-0.3256,0.5509,-0.7552,-0.3200,0.5720,-0.7247,-0.3842,0.5720,-0.7684,-0.3256,0.5509,-0.7937,-0.2579,0.5509,-0.7801,-0.2535,0.5720,-0.7552,-0.3200,0.5720,0.7801,-0.2535,0.5720,0.7552,-0.3200,0.5720,0.7433,-0.3150,0.5902,0.7678,-0.2495,0.5902,0.7552,-0.3200,0.5720,0.7247,-0.3842,0.5720,0.7132,-0.3781,0.5902,0.7433,-0.3150,0.5902,0.7247,-0.3842,0.5720,0.6887,-0.4455,0.5720,0.6778,-0.4384,0.5902,0.7132,-0.3781,0.5902,0.6887,-0.4455,0.5720,0.6476,-0.5034,0.5720,0.6373,-0.4955,0.5902,0.6778,-0.4384,0.5902,0.6476,-0.5034,0.5720,0.6016,-0.5576,0.5720,0.5921,-0.5488,0.5902,0.6373,-0.4955,0.5902,0.6016,-0.5576,0.5720,0.5511,-0.6076,0.5720,0.5423,-0.5980,0.5902,0.5921,-0.5488,0.5902,0.5511,-0.6076,0.5720,0.4964,-0.6530,0.5720,0.4885,-0.6427,0.5902,0.5423,-0.5980,0.5902,0.4964,-0.6530,0.5720,0.4380,-0.6935,0.5720,0.4311,-0.6825,0.5902,0.4885,-0.6427,0.5902,0.4380,-0.6935,0.5720,0.3763,-0.7288,0.5720,0.3704,-0.7173,0.5902,0.4311,-0.6825,0.5902,0.3763,-0.7288,0.5720,0.3118,-0.7587,0.5720,0.3069,-0.7467,0.5902,0.3704,-0.7173,0.5902,0.3118,-0.7587,0.5720,0.2450,-0.7828,0.5720,0.2411,-0.7704,0.5902,0.3069,-0.7467,0.5902,0.2450,-0.7828,0.5720,0.1763,-0.8011,0.5720,0.1735,-0.7884,0.5902,0.2411,-0.7704,0.5902,0.1763,-0.8011,0.5720,0.1063,-0.8133,0.5720,0.1046,-0.8005,0.5902,0.1735,-0.7884,0.5902,0.1063,-0.8133,0.5720,0.0355,-0.8195,0.5720,0.0350,-0.8065,0.5902,0.1046,-0.8005,0.5902,0.0355,-0.8195,0.5720,-0.0355,-0.8195,0.5720,-0.0350,-0.8065,0.5902,0.0350,-0.8065,0.5902,-0.0355,-0.8195,0.5720,-0.1063,-0.8133,0.5720,-0.1046,-0.8005,0.5902,-0.0350,-0.8065,0.5902,-0.1063,-0.8133,0.5720,-0.1763,-0.8011,0.5720,-0.1735,-0.7884,0.5902,-0.1046,-0.8005,0.5902};
			return value;
		}
		private double[] getNormal_5_14_vector_33()
		{
			double[] value = {-0.1763,-0.8011,0.5720,-0.2450,-0.7828,0.5720,-0.2411,-0.7704,0.5902,-0.1735,-0.7884,0.5902,-0.2450,-0.7828,0.5720,-0.3118,-0.7587,0.5720,-0.3069,-0.7467,0.5902,-0.2411,-0.7704,0.5902,-0.3118,-0.7587,0.5720,-0.3763,-0.7288,0.5720,-0.3704,-0.7173,0.5902,-0.3069,-0.7467,0.5902,-0.3763,-0.7288,0.5720,-0.4380,-0.6935,0.5720,-0.4311,-0.6825,0.5902,-0.3704,-0.7173,0.5902,-0.4380,-0.6935,0.5720,-0.4964,-0.6530,0.5720,-0.4885,-0.6427,0.5902,-0.4311,-0.6825,0.5902,-0.4964,-0.6530,0.5720,-0.5511,-0.6076,0.5720,-0.5423,-0.5980,0.5902,-0.4885,-0.6427,0.5902,-0.5511,-0.6076,0.5720,-0.6016,-0.5576,0.5720,-0.5921,-0.5488,0.5902,-0.5423,-0.5980,0.5902,-0.6016,-0.5576,0.5720,-0.6476,-0.5034,0.5720,-0.6373,-0.4955,0.5902,-0.5921,-0.5488,0.5902,-0.6476,-0.5034,0.5720,-0.6887,-0.4455,0.5720,-0.6778,-0.4384,0.5902,-0.6373,-0.4955,0.5902,-0.6887,-0.4455,0.5720,-0.7247,-0.3842,0.5720,-0.7132,-0.3781,0.5902,-0.6778,-0.4384,0.5902,-0.7247,-0.3842,0.5720,-0.7552,-0.3200,0.5720,-0.7433,-0.3150,0.5902,-0.7132,-0.3781,0.5902,-0.7552,-0.3200,0.5720,-0.7801,-0.2535,0.5720,-0.7678,-0.2495,0.5902,-0.7433,-0.3150,0.5902,0.7678,-0.2495,0.5902,0.7433,-0.3150,0.5902,0.7325,-0.3104,0.6059,0.7566,-0.2458,0.6059,0.7433,-0.3150,0.5902,0.7132,-0.3781,0.5902,0.7029,-0.3726,0.6059,0.7325,-0.3104,0.6059,0.7132,-0.3781,0.5902,0.6778,-0.4384,0.5902,0.6680,-0.4321,0.6059,0.7029,-0.3726,0.6059,0.6778,-0.4384,0.5902,0.6373,-0.4955,0.5902,0.6281,-0.4883,0.6059,0.6680,-0.4321,0.6059,0.6373,-0.4955,0.5902,0.5921,-0.5488,0.5902,0.5835,-0.5408,0.6059,0.6281,-0.4883,0.6059,0.5921,-0.5488,0.5902,0.5423,-0.5980,0.5902,0.5345,-0.5893,0.6059,0.5835,-0.5408,0.6059,0.5423,-0.5980,0.5902,0.4885,-0.6427,0.5902,0.4814,-0.6333,0.6059,0.5345,-0.5893,0.6059,0.4885,-0.6427,0.5902,0.4311,-0.6825,0.5902,0.4248,-0.6726,0.6059,0.4814,-0.6333,0.6059,0.4311,-0.6825,0.5902,0.3704,-0.7173,0.5902,0.3650,-0.7069,0.6059,0.4248,-0.6726,0.6059,0.3704,-0.7173,0.5902,0.3069,-0.7467,0.5902,0.3025,-0.7358,0.6059,0.3650,-0.7069,0.6059,0.3069,-0.7467,0.5902,0.2411,-0.7704,0.5902,0.2376,-0.7592,0.6059,0.3025,-0.7358,0.6059,0.2411,-0.7704,0.5902,0.1735,-0.7884,0.5902,0.1710,-0.7770,0.6059,0.2376,-0.7592,0.6059,0.1735,-0.7884,0.5902,0.1046,-0.8005,0.5902,0.1031,-0.7888,0.6059,0.1710,-0.7770,0.6059};
			return value;
		}
		private double[] getNormal_5_14_vector_34()
		{
			double[] value = {0.1046,-0.8005,0.5902,0.0350,-0.8065,0.5902,0.0345,-0.7948,0.6059,0.1031,-0.7888,0.6059,0.0350,-0.8065,0.5902,-0.0350,-0.8065,0.5902,-0.0345,-0.7948,0.6059,0.0345,-0.7948,0.6059,-0.0350,-0.8065,0.5902,-0.1046,-0.8005,0.5902,-0.1031,-0.7888,0.6059,-0.0345,-0.7948,0.6059,-0.1046,-0.8005,0.5902,-0.1735,-0.7884,0.5902,-0.1710,-0.7770,0.6059,-0.1031,-0.7888,0.6059,-0.1735,-0.7884,0.5902,-0.2411,-0.7704,0.5902,-0.2376,-0.7592,0.6059,-0.1710,-0.7770,0.6059,-0.2411,-0.7704,0.5902,-0.3069,-0.7467,0.5902,-0.3025,-0.7358,0.6059,-0.2376,-0.7592,0.6059,-0.3069,-0.7467,0.5902,-0.3704,-0.7173,0.5902,-0.3650,-0.7069,0.6059,-0.3025,-0.7358,0.6059,-0.3704,-0.7173,0.5902,-0.4311,-0.6825,0.5902,-0.4248,-0.6726,0.6059,-0.3650,-0.7069,0.6059,-0.4311,-0.6825,0.5902,-0.4885,-0.6427,0.5902,-0.4814,-0.6333,0.6059,-0.4248,-0.6726,0.6059,-0.4885,-0.6427,0.5902,-0.5423,-0.5980,0.5902,-0.5345,-0.5893,0.6059,-0.4814,-0.6333,0.6059,-0.5423,-0.5980,0.5902,-0.5921,-0.5488,0.5902,-0.5835,-0.5408,0.6059,-0.5345,-0.5893,0.6059,-0.5921,-0.5488,0.5902,-0.6373,-0.4955,0.5902,-0.6281,-0.4883,0.6059,-0.5835,-0.5408,0.6059,-0.6373,-0.4955,0.5902,-0.6778,-0.4384,0.5902,-0.6680,-0.4321,0.6059,-0.6281,-0.4883,0.6059,-0.6778,-0.4384,0.5902,-0.7132,-0.3781,0.5902,-0.7029,-0.3726,0.6059,-0.6680,-0.4321,0.6059,-0.7132,-0.3781,0.5902,-0.7433,-0.3150,0.5902,-0.7325,-0.3104,0.6059,-0.7029,-0.3726,0.6059,-0.7433,-0.3150,0.5902,-0.7678,-0.2495,0.5902,-0.7566,-0.2458,0.6059,-0.7325,-0.3104,0.6059};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getColor_5_15_color_1()
		{
			double[] value = {0.0000,0.0000,0.7000,0.9985,0.0000,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.9985,0.0000,0.7000,0.1081,0.0000,0.7000,0.1081,0.9868,0.7000,0.9985,0.9868,0.7000,0.1081,0.0000,0.7000,0.9868,0.0000,0.7000,0.9868,0.9868,0.7000,0.1081,0.9868,0.7000,0.9868,0.0000,0.7000,0.2150,0.0000,0.7000,0.2150,0.9868,0.7000,0.9868,0.9868,0.7000,0.2150,0.0000,0.7000,0.9635,0.0000,0.7000,0.9635,0.9868,0.7000,0.2150,0.9868,0.7000,0.9635,0.0000,0.7000,0.3193,0.0000,0.7000,0.3193,0.9868,0.7000,0.9635,0.9868,0.7000,0.3193,0.0000,0.7000,0.9290,0.0000,0.7000,0.9290,0.9868,0.7000,0.3193,0.9868,0.7000,0.9290,0.0000,0.7000,0.4199,0.0000,0.7000,0.4199,0.9868,0.7000,0.9290,0.9868,0.7000,0.4199,0.0000,0.7000,0.8835,0.0000,0.7000,0.8835,0.9868,0.7000,0.4199,0.9868,0.7000,0.8835,0.0000,0.7000,0.5156,0.0000,0.7000,0.5156,0.9868,0.7000,0.8835,0.9868,0.7000,0.5156,0.0000,0.7000,0.8277,0.0000,0.7000,0.8277,0.9868,0.7000,0.5156,0.9868,0.7000,0.8277,0.0000,0.7000,0.6052,0.0000,0.7000,0.6052,0.9868,0.7000,0.8277,0.9868,0.7000,0.6052,0.0000,0.7000,0.7622,0.0000,0.7000,0.7622,0.9868,0.7000,0.6052,0.9868,0.7000,0.7622,0.0000,0.7000,0.6877,0.0000,0.7000,0.6877,0.9868,0.7000,0.7622,0.9868,0.7000,0.6877,0.0000,0.7000,0.6877,0.0000,0.7000,0.6877,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.0000,0.7000,0.7622,0.0000,0.7000,0.7622,0.9868,0.7000,0.6877,0.9868,0.7000,0.7622,0.0000,0.7000,0.6052,0.0000,0.7000,0.6052,0.9868,0.7000,0.7622,0.9868,0.7000,0.6052,0.0000,0.7000,0.8277,0.0000,0.7000,0.8277,0.9868,0.7000,0.6052,0.9868,0.7000,0.8277,0.0000,0.7000,0.5156,0.0000,0.7000,0.5156,0.9868,0.7000,0.8277,0.9868,0.7000,0.5156,0.0000,0.7000,0.8835,0.0000,0.7000,0.8835,0.9868,0.7000,0.5156,0.9868,0.7000,0.8835,0.0000,0.7000,0.4199,0.0000,0.7000,0.4199,0.9868,0.7000,0.8835,0.9868,0.7000,0.4199,0.0000,0.7000,0.9290,0.0000,0.7000,0.9290,0.9868,0.7000,0.4199,0.9868,0.7000,0.9290,0.0000,0.7000,0.3193,0.0000,0.7000,0.3193,0.9868,0.7000,0.9290,0.9868,0.7000,0.3193,0.0000,0.7000,0.9635,0.0000,0.7000,0.9635,0.9868,0.7000,0.3193,0.9868,0.7000,0.9635,0.0000,0.7000,0.2150,0.0000,0.7000,0.2150,0.9868,0.7000,0.9635,0.9868,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_2()
		{
			double[] value = {0.2150,0.0000,0.7000,0.9868,0.0000,0.7000,0.9868,0.9868,0.7000,0.2150,0.9868,0.7000,0.9868,0.0000,0.7000,0.1081,0.0000,0.7000,0.1081,0.9868,0.7000,0.9868,0.9868,0.7000,0.1081,0.0000,0.7000,0.9985,0.0000,0.7000,0.9985,0.9868,0.7000,0.1081,0.9868,0.7000,0.9985,0.0000,0.7000,0.0000,0.0000,0.7000,0.0000,0.9868,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.9985,0.9868,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.9985,0.9868,0.7000,0.1081,0.9868,0.7000,0.1081,0.3193,0.7000,0.9985,0.3193,0.7000,0.1081,0.9868,0.7000,0.9868,0.9868,0.7000,0.9868,0.3193,0.7000,0.1081,0.3193,0.7000,0.9868,0.9868,0.7000,0.2150,0.9868,0.7000,0.2150,0.3193,0.7000,0.9868,0.3193,0.7000,0.2150,0.9868,0.7000,0.9635,0.9868,0.7000,0.9635,0.3193,0.7000,0.2150,0.3193,0.7000,0.9635,0.9868,0.7000,0.3193,0.9868,0.7000,0.3193,0.3193,0.7000,0.9635,0.3193,0.7000,0.3193,0.9868,0.7000,0.9290,0.9868,0.7000,0.9290,0.3193,0.7000,0.3193,0.3193,0.7000,0.9290,0.9868,0.7000,0.4199,0.9868,0.7000,0.4199,0.3193,0.7000,0.9290,0.3193,0.7000,0.4199,0.9868,0.7000,0.8835,0.9868,0.7000,0.8835,0.3193,0.7000,0.4199,0.3193,0.7000,0.8835,0.9868,0.7000,0.5156,0.9868,0.7000,0.5156,0.3193,0.7000,0.8835,0.3193,0.7000,0.5156,0.9868,0.7000,0.8277,0.9868,0.7000,0.8277,0.3193,0.7000,0.5156,0.3193,0.7000,0.8277,0.9868,0.7000,0.6052,0.9868,0.7000,0.6052,0.3193,0.7000,0.8277,0.3193,0.7000,0.6052,0.9868,0.7000,0.7622,0.9868,0.7000,0.7622,0.3193,0.7000,0.6052,0.3193,0.7000,0.7622,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.3193,0.7000,0.7622,0.3193,0.7000,0.6877,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.9868,0.7000,0.7622,0.9868,0.7000,0.7622,0.3193,0.7000,0.6877,0.3193,0.7000,0.7622,0.9868,0.7000,0.6052,0.9868,0.7000,0.6052,0.3193,0.7000,0.7622,0.3193,0.7000,0.6052,0.9868,0.7000,0.8277,0.9868,0.7000,0.8277,0.3193,0.7000,0.6052,0.3193,0.7000,0.8277,0.9868,0.7000,0.5156,0.9868,0.7000,0.5156,0.3193,0.7000,0.8277,0.3193,0.7000,0.5156,0.9868,0.7000,0.8835,0.9868,0.7000,0.8835,0.3193,0.7000,0.5156,0.3193,0.7000,0.8835,0.9868,0.7000,0.4199,0.9868,0.7000,0.4199,0.3193,0.7000,0.8835,0.3193,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_3()
		{
			double[] value = {0.4199,0.9868,0.7000,0.9290,0.9868,0.7000,0.9290,0.3193,0.7000,0.4199,0.3193,0.7000,0.9290,0.9868,0.7000,0.3193,0.9868,0.7000,0.3193,0.3193,0.7000,0.9290,0.3193,0.7000,0.3193,0.9868,0.7000,0.9635,0.9868,0.7000,0.9635,0.3193,0.7000,0.3193,0.3193,0.7000,0.9635,0.9868,0.7000,0.2150,0.9868,0.7000,0.2150,0.3193,0.7000,0.9635,0.3193,0.7000,0.2150,0.9868,0.7000,0.9868,0.9868,0.7000,0.9868,0.3193,0.7000,0.2150,0.3193,0.7000,0.9868,0.9868,0.7000,0.1081,0.9868,0.7000,0.1081,0.3193,0.7000,0.9868,0.3193,0.7000,0.1081,0.9868,0.7000,0.9985,0.9868,0.7000,0.9985,0.3193,0.7000,0.1081,0.3193,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.0000,0.3193,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.9985,0.3193,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.9985,0.3193,0.7000,0.1081,0.3193,0.7000,0.1081,0.8835,0.7000,0.9985,0.8835,0.7000,0.1081,0.3193,0.7000,0.9868,0.3193,0.7000,0.9868,0.8835,0.7000,0.1081,0.8835,0.7000,0.9868,0.3193,0.7000,0.2150,0.3193,0.7000,0.2150,0.8835,0.7000,0.9868,0.8835,0.7000,0.2150,0.3193,0.7000,0.9635,0.3193,0.7000,0.9635,0.8835,0.7000,0.2150,0.8835,0.7000,0.9635,0.3193,0.7000,0.3193,0.3193,0.7000,0.3193,0.8835,0.7000,0.9635,0.8835,0.7000,0.3193,0.3193,0.7000,0.9290,0.3193,0.7000,0.9290,0.8835,0.7000,0.3193,0.8835,0.7000,0.9290,0.3193,0.7000,0.4199,0.3193,0.7000,0.4199,0.8835,0.7000,0.9290,0.8835,0.7000,0.4199,0.3193,0.7000,0.8835,0.3193,0.7000,0.8835,0.8835,0.7000,0.4199,0.8835,0.7000,0.8835,0.3193,0.7000,0.5156,0.3193,0.7000,0.5156,0.8835,0.7000,0.8835,0.8835,0.7000,0.5156,0.3193,0.7000,0.8277,0.3193,0.7000,0.8277,0.8835,0.7000,0.5156,0.8835,0.7000,0.8277,0.3193,0.7000,0.6052,0.3193,0.7000,0.6052,0.8835,0.7000,0.8277,0.8835,0.7000,0.6052,0.3193,0.7000,0.7622,0.3193,0.7000,0.7622,0.8835,0.7000,0.6052,0.8835,0.7000,0.7622,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.8835,0.7000,0.7622,0.8835,0.7000,0.6877,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.3193,0.7000,0.7622,0.3193,0.7000,0.7622,0.8835,0.7000,0.6877,0.8835,0.7000,0.7622,0.3193,0.7000,0.6052,0.3193,0.7000,0.6052,0.8835,0.7000,0.7622,0.8835,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_4()
		{
			double[] value = {0.6052,0.3193,0.7000,0.8277,0.3193,0.7000,0.8277,0.8835,0.7000,0.6052,0.8835,0.7000,0.8277,0.3193,0.7000,0.5156,0.3193,0.7000,0.5156,0.8835,0.7000,0.8277,0.8835,0.7000,0.5156,0.3193,0.7000,0.8835,0.3193,0.7000,0.8835,0.8835,0.7000,0.5156,0.8835,0.7000,0.8835,0.3193,0.7000,0.4199,0.3193,0.7000,0.4199,0.8835,0.7000,0.8835,0.8835,0.7000,0.4199,0.3193,0.7000,0.9290,0.3193,0.7000,0.9290,0.8835,0.7000,0.4199,0.8835,0.7000,0.9290,0.3193,0.7000,0.3193,0.3193,0.7000,0.3193,0.8835,0.7000,0.9290,0.8835,0.7000,0.3193,0.3193,0.7000,0.9635,0.3193,0.7000,0.9635,0.8835,0.7000,0.3193,0.8835,0.7000,0.9635,0.3193,0.7000,0.2150,0.3193,0.7000,0.2150,0.8835,0.7000,0.9635,0.8835,0.7000,0.2150,0.3193,0.7000,0.9868,0.3193,0.7000,0.9868,0.8835,0.7000,0.2150,0.8835,0.7000,0.9868,0.3193,0.7000,0.1081,0.3193,0.7000,0.1081,0.8835,0.7000,0.9868,0.8835,0.7000,0.1081,0.3193,0.7000,0.9985,0.3193,0.7000,0.9985,0.8835,0.7000,0.1081,0.8835,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.0000,0.8835,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.9985,0.8835,0.7000,0.9985,0.6052,0.7000,0.0000,0.6052,0.7000,0.9985,0.8835,0.7000,0.1081,0.8835,0.7000,0.1081,0.6052,0.7000,0.9985,0.6052,0.7000,0.1081,0.8835,0.7000,0.9868,0.8835,0.7000,0.9868,0.6052,0.7000,0.1081,0.6052,0.7000,0.9868,0.8835,0.7000,0.2150,0.8835,0.7000,0.2150,0.6052,0.7000,0.9868,0.6052,0.7000,0.2150,0.8835,0.7000,0.9635,0.8835,0.7000,0.9635,0.6052,0.7000,0.2150,0.6052,0.7000,0.9635,0.8835,0.7000,0.3193,0.8835,0.7000,0.3193,0.6052,0.7000,0.9635,0.6052,0.7000,0.3193,0.8835,0.7000,0.9290,0.8835,0.7000,0.9290,0.6052,0.7000,0.3193,0.6052,0.7000,0.9290,0.8835,0.7000,0.4199,0.8835,0.7000,0.4199,0.6052,0.7000,0.9290,0.6052,0.7000,0.4199,0.8835,0.7000,0.8835,0.8835,0.7000,0.8835,0.6052,0.7000,0.4199,0.6052,0.7000,0.8835,0.8835,0.7000,0.5156,0.8835,0.7000,0.5156,0.6052,0.7000,0.8835,0.6052,0.7000,0.5156,0.8835,0.7000,0.8277,0.8835,0.7000,0.8277,0.6052,0.7000,0.5156,0.6052,0.7000,0.8277,0.8835,0.7000,0.6052,0.8835,0.7000,0.6052,0.6052,0.7000,0.8277,0.6052,0.7000,0.6052,0.8835,0.7000,0.7622,0.8835,0.7000,0.7622,0.6052,0.7000,0.6052,0.6052,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_5()
		{
			double[] value = {0.7622,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.6052,0.7000,0.7622,0.6052,0.7000,0.6877,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.8835,0.7000,0.7622,0.8835,0.7000,0.7622,0.6052,0.7000,0.6877,0.6052,0.7000,0.7622,0.8835,0.7000,0.6052,0.8835,0.7000,0.6052,0.6052,0.7000,0.7622,0.6052,0.7000,0.6052,0.8835,0.7000,0.8277,0.8835,0.7000,0.8277,0.6052,0.7000,0.6052,0.6052,0.7000,0.8277,0.8835,0.7000,0.5156,0.8835,0.7000,0.5156,0.6052,0.7000,0.8277,0.6052,0.7000,0.5156,0.8835,0.7000,0.8835,0.8835,0.7000,0.8835,0.6052,0.7000,0.5156,0.6052,0.7000,0.8835,0.8835,0.7000,0.4199,0.8835,0.7000,0.4199,0.6052,0.7000,0.8835,0.6052,0.7000,0.4199,0.8835,0.7000,0.9290,0.8835,0.7000,0.9290,0.6052,0.7000,0.4199,0.6052,0.7000,0.9290,0.8835,0.7000,0.3193,0.8835,0.7000,0.3193,0.6052,0.7000,0.9290,0.6052,0.7000,0.3193,0.8835,0.7000,0.9635,0.8835,0.7000,0.9635,0.6052,0.7000,0.3193,0.6052,0.7000,0.9635,0.8835,0.7000,0.2150,0.8835,0.7000,0.2150,0.6052,0.7000,0.9635,0.6052,0.7000,0.2150,0.8835,0.7000,0.9868,0.8835,0.7000,0.9868,0.6052,0.7000,0.2150,0.6052,0.7000,0.9868,0.8835,0.7000,0.1081,0.8835,0.7000,0.1081,0.6052,0.7000,0.9868,0.6052,0.7000,0.1081,0.8835,0.7000,0.9985,0.8835,0.7000,0.9985,0.6052,0.7000,0.1081,0.6052,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.0000,0.6052,0.7000,0.9985,0.6052,0.7000,0.0000,0.6052,0.7000,0.9985,0.6052,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.9985,0.6052,0.7000,0.1081,0.6052,0.7000,0.1081,0.6877,0.7000,0.9985,0.6877,0.7000,0.1081,0.6052,0.7000,0.9868,0.6052,0.7000,0.9868,0.6877,0.7000,0.1081,0.6877,0.7000,0.9868,0.6052,0.7000,0.2150,0.6052,0.7000,0.2150,0.6877,0.7000,0.9868,0.6877,0.7000,0.2150,0.6052,0.7000,0.9635,0.6052,0.7000,0.9635,0.6877,0.7000,0.2150,0.6877,0.7000,0.9635,0.6052,0.7000,0.3193,0.6052,0.7000,0.3193,0.6877,0.7000,0.9635,0.6877,0.7000,0.3193,0.6052,0.7000,0.9290,0.6052,0.7000,0.9290,0.6877,0.7000,0.3193,0.6877,0.7000,0.9290,0.6052,0.7000,0.4199,0.6052,0.7000,0.4199,0.6877,0.7000,0.9290,0.6877,0.7000,0.4199,0.6052,0.7000,0.8835,0.6052,0.7000,0.8835,0.6877,0.7000,0.4199,0.6877,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_6()
		{
			double[] value = {0.8835,0.6052,0.7000,0.5156,0.6052,0.7000,0.5156,0.6877,0.7000,0.8835,0.6877,0.7000,0.5156,0.6052,0.7000,0.8277,0.6052,0.7000,0.8277,0.6877,0.7000,0.5156,0.6877,0.7000,0.8277,0.6052,0.7000,0.6052,0.6052,0.7000,0.6052,0.6877,0.7000,0.8277,0.6877,0.7000,0.6052,0.6052,0.7000,0.7622,0.6052,0.7000,0.7622,0.6877,0.7000,0.6052,0.6877,0.7000,0.7622,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.6877,0.7000,0.7622,0.6877,0.7000,0.6877,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.6052,0.7000,0.7622,0.6052,0.7000,0.7622,0.6877,0.7000,0.6877,0.6877,0.7000,0.7622,0.6052,0.7000,0.6052,0.6052,0.7000,0.6052,0.6877,0.7000,0.7622,0.6877,0.7000,0.6052,0.6052,0.7000,0.8277,0.6052,0.7000,0.8277,0.6877,0.7000,0.6052,0.6877,0.7000,0.8277,0.6052,0.7000,0.5156,0.6052,0.7000,0.5156,0.6877,0.7000,0.8277,0.6877,0.7000,0.5156,0.6052,0.7000,0.8835,0.6052,0.7000,0.8835,0.6877,0.7000,0.5156,0.6877,0.7000,0.8835,0.6052,0.7000,0.4199,0.6052,0.7000,0.4199,0.6877,0.7000,0.8835,0.6877,0.7000,0.4199,0.6052,0.7000,0.9290,0.6052,0.7000,0.9290,0.6877,0.7000,0.4199,0.6877,0.7000,0.9290,0.6052,0.7000,0.3193,0.6052,0.7000,0.3193,0.6877,0.7000,0.9290,0.6877,0.7000,0.3193,0.6052,0.7000,0.9635,0.6052,0.7000,0.9635,0.6877,0.7000,0.3193,0.6877,0.7000,0.9635,0.6052,0.7000,0.2150,0.6052,0.7000,0.2150,0.6877,0.7000,0.9635,0.6877,0.7000,0.2150,0.6052,0.7000,0.9868,0.6052,0.7000,0.9868,0.6877,0.7000,0.2150,0.6877,0.7000,0.9868,0.6052,0.7000,0.1081,0.6052,0.7000,0.1081,0.6877,0.7000,0.9868,0.6877,0.7000,0.1081,0.6052,0.7000,0.9985,0.6052,0.7000,0.9985,0.6877,0.7000,0.1081,0.6877,0.7000,0.9985,0.6052,0.7000,0.0000,0.6052,0.7000,0.0000,0.6877,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.9985,0.6877,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.9985,0.6877,0.7000,0.1081,0.6877,0.7000,0.1081,0.8277,0.7000,0.9985,0.8277,0.7000,0.1081,0.6877,0.7000,0.9868,0.6877,0.7000,0.9868,0.8277,0.7000,0.1081,0.8277,0.7000,0.9868,0.6877,0.7000,0.2150,0.6877,0.7000,0.2150,0.8277,0.7000,0.9868,0.8277,0.7000,0.2150,0.6877,0.7000,0.9635,0.6877,0.7000,0.9635,0.8277,0.7000,0.2150,0.8277,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_7()
		{
			double[] value = {0.9635,0.6877,0.7000,0.3193,0.6877,0.7000,0.3193,0.8277,0.7000,0.9635,0.8277,0.7000,0.3193,0.6877,0.7000,0.9290,0.6877,0.7000,0.9290,0.8277,0.7000,0.3193,0.8277,0.7000,0.9290,0.6877,0.7000,0.4199,0.6877,0.7000,0.4199,0.8277,0.7000,0.9290,0.8277,0.7000,0.4199,0.6877,0.7000,0.8835,0.6877,0.7000,0.8835,0.8277,0.7000,0.4199,0.8277,0.7000,0.8835,0.6877,0.7000,0.5156,0.6877,0.7000,0.5156,0.8277,0.7000,0.8835,0.8277,0.7000,0.5156,0.6877,0.7000,0.8277,0.6877,0.7000,0.8277,0.8277,0.7000,0.5156,0.8277,0.7000,0.8277,0.6877,0.7000,0.6052,0.6877,0.7000,0.6052,0.8277,0.7000,0.8277,0.8277,0.7000,0.6052,0.6877,0.7000,0.7622,0.6877,0.7000,0.7622,0.8277,0.7000,0.6052,0.8277,0.7000,0.7622,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.8277,0.7000,0.7622,0.8277,0.7000,0.6877,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.6877,0.7000,0.7622,0.6877,0.7000,0.7622,0.8277,0.7000,0.6877,0.8277,0.7000,0.7622,0.6877,0.7000,0.6052,0.6877,0.7000,0.6052,0.8277,0.7000,0.7622,0.8277,0.7000,0.6052,0.6877,0.7000,0.8277,0.6877,0.7000,0.8277,0.8277,0.7000,0.6052,0.8277,0.7000,0.8277,0.6877,0.7000,0.5156,0.6877,0.7000,0.5156,0.8277,0.7000,0.8277,0.8277,0.7000,0.5156,0.6877,0.7000,0.8835,0.6877,0.7000,0.8835,0.8277,0.7000,0.5156,0.8277,0.7000,0.8835,0.6877,0.7000,0.4199,0.6877,0.7000,0.4199,0.8277,0.7000,0.8835,0.8277,0.7000,0.4199,0.6877,0.7000,0.9290,0.6877,0.7000,0.9290,0.8277,0.7000,0.4199,0.8277,0.7000,0.9290,0.6877,0.7000,0.3193,0.6877,0.7000,0.3193,0.8277,0.7000,0.9290,0.8277,0.7000,0.3193,0.6877,0.7000,0.9635,0.6877,0.7000,0.9635,0.8277,0.7000,0.3193,0.8277,0.7000,0.9635,0.6877,0.7000,0.2150,0.6877,0.7000,0.2150,0.8277,0.7000,0.9635,0.8277,0.7000,0.2150,0.6877,0.7000,0.9868,0.6877,0.7000,0.9868,0.8277,0.7000,0.2150,0.8277,0.7000,0.9868,0.6877,0.7000,0.1081,0.6877,0.7000,0.1081,0.8277,0.7000,0.9868,0.8277,0.7000,0.1081,0.6877,0.7000,0.9985,0.6877,0.7000,0.9985,0.8277,0.7000,0.1081,0.8277,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.0000,0.8277,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.9985,0.8277,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_8()
		{
			double[] value = {0.9985,0.8277,0.7000,0.1081,0.8277,0.7000,0.1081,0.4199,0.7000,0.9985,0.4199,0.7000,0.1081,0.8277,0.7000,0.9868,0.8277,0.7000,0.9868,0.4199,0.7000,0.1081,0.4199,0.7000,0.9868,0.8277,0.7000,0.2150,0.8277,0.7000,0.2150,0.4199,0.7000,0.9868,0.4199,0.7000,0.2150,0.8277,0.7000,0.9635,0.8277,0.7000,0.9635,0.4199,0.7000,0.2150,0.4199,0.7000,0.9635,0.8277,0.7000,0.3193,0.8277,0.7000,0.3193,0.4199,0.7000,0.9635,0.4199,0.7000,0.3193,0.8277,0.7000,0.9290,0.8277,0.7000,0.9290,0.4199,0.7000,0.3193,0.4199,0.7000,0.9290,0.8277,0.7000,0.4199,0.8277,0.7000,0.4199,0.4199,0.7000,0.9290,0.4199,0.7000,0.4199,0.8277,0.7000,0.8835,0.8277,0.7000,0.8835,0.4199,0.7000,0.4199,0.4199,0.7000,0.8835,0.8277,0.7000,0.5156,0.8277,0.7000,0.5156,0.4199,0.7000,0.8835,0.4199,0.7000,0.5156,0.8277,0.7000,0.8277,0.8277,0.7000,0.8277,0.4199,0.7000,0.5156,0.4199,0.7000,0.8277,0.8277,0.7000,0.6052,0.8277,0.7000,0.6052,0.4199,0.7000,0.8277,0.4199,0.7000,0.6052,0.8277,0.7000,0.7622,0.8277,0.7000,0.7622,0.4199,0.7000,0.6052,0.4199,0.7000,0.7622,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.4199,0.7000,0.7622,0.4199,0.7000,0.6877,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.8277,0.7000,0.7622,0.8277,0.7000,0.7622,0.4199,0.7000,0.6877,0.4199,0.7000,0.7622,0.8277,0.7000,0.6052,0.8277,0.7000,0.6052,0.4199,0.7000,0.7622,0.4199,0.7000,0.6052,0.8277,0.7000,0.8277,0.8277,0.7000,0.8277,0.4199,0.7000,0.6052,0.4199,0.7000,0.8277,0.8277,0.7000,0.5156,0.8277,0.7000,0.5156,0.4199,0.7000,0.8277,0.4199,0.7000,0.5156,0.8277,0.7000,0.8835,0.8277,0.7000,0.8835,0.4199,0.7000,0.5156,0.4199,0.7000,0.8835,0.8277,0.7000,0.4199,0.8277,0.7000,0.4199,0.4199,0.7000,0.8835,0.4199,0.7000,0.4199,0.8277,0.7000,0.9290,0.8277,0.7000,0.9290,0.4199,0.7000,0.4199,0.4199,0.7000,0.9290,0.8277,0.7000,0.3193,0.8277,0.7000,0.3193,0.4199,0.7000,0.9290,0.4199,0.7000,0.3193,0.8277,0.7000,0.9635,0.8277,0.7000,0.9635,0.4199,0.7000,0.3193,0.4199,0.7000,0.9635,0.8277,0.7000,0.2150,0.8277,0.7000,0.2150,0.4199,0.7000,0.9635,0.4199,0.7000,0.2150,0.8277,0.7000,0.9868,0.8277,0.7000,0.9868,0.4199,0.7000,0.2150,0.4199,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_9()
		{
			double[] value = {0.9868,0.8277,0.7000,0.1081,0.8277,0.7000,0.1081,0.4199,0.7000,0.9868,0.4199,0.7000,0.1081,0.8277,0.7000,0.9985,0.8277,0.7000,0.9985,0.4199,0.7000,0.1081,0.4199,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.0000,0.4199,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000,0.9985,0.4199,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.9985,0.4199,0.7000,0.1081,0.4199,0.7000,0.1081,0.9635,0.7000,0.9985,0.9635,0.7000,0.1081,0.4199,0.7000,0.9868,0.4199,0.7000,0.9868,0.9635,0.7000,0.1081,0.9635,0.7000,0.9868,0.4199,0.7000,0.2150,0.4199,0.7000,0.2150,0.9635,0.7000,0.9868,0.9635,0.7000,0.2150,0.4199,0.7000,0.9635,0.4199,0.7000,0.9635,0.9635,0.7000,0.2150,0.9635,0.7000,0.9635,0.4199,0.7000,0.3193,0.4199,0.7000,0.3193,0.9635,0.7000,0.9635,0.9635,0.7000,0.3193,0.4199,0.7000,0.9290,0.4199,0.7000,0.9290,0.9635,0.7000,0.3193,0.9635,0.7000,0.9290,0.4199,0.7000,0.4199,0.4199,0.7000,0.4199,0.9635,0.7000,0.9290,0.9635,0.7000,0.4199,0.4199,0.7000,0.8835,0.4199,0.7000,0.8835,0.9635,0.7000,0.4199,0.9635,0.7000,0.8835,0.4199,0.7000,0.5156,0.4199,0.7000,0.5156,0.9635,0.7000,0.8835,0.9635,0.7000,0.5156,0.4199,0.7000,0.8277,0.4199,0.7000,0.8277,0.9635,0.7000,0.5156,0.9635,0.7000,0.8277,0.4199,0.7000,0.6052,0.4199,0.7000,0.6052,0.9635,0.7000,0.8277,0.9635,0.7000,0.6052,0.4199,0.7000,0.7622,0.4199,0.7000,0.7622,0.9635,0.7000,0.6052,0.9635,0.7000,0.7622,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.9635,0.7000,0.7622,0.9635,0.7000,0.6877,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.4199,0.7000,0.7622,0.4199,0.7000,0.7622,0.9635,0.7000,0.6877,0.9635,0.7000,0.7622,0.4199,0.7000,0.6052,0.4199,0.7000,0.6052,0.9635,0.7000,0.7622,0.9635,0.7000,0.6052,0.4199,0.7000,0.8277,0.4199,0.7000,0.8277,0.9635,0.7000,0.6052,0.9635,0.7000,0.8277,0.4199,0.7000,0.5156,0.4199,0.7000,0.5156,0.9635,0.7000,0.8277,0.9635,0.7000,0.5156,0.4199,0.7000,0.8835,0.4199,0.7000,0.8835,0.9635,0.7000,0.5156,0.9635,0.7000,0.8835,0.4199,0.7000,0.4199,0.4199,0.7000,0.4199,0.9635,0.7000,0.8835,0.9635,0.7000,0.4199,0.4199,0.7000,0.9290,0.4199,0.7000,0.9290,0.9635,0.7000,0.4199,0.9635,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_10()
		{
			double[] value = {0.9290,0.4199,0.7000,0.3193,0.4199,0.7000,0.3193,0.9635,0.7000,0.9290,0.9635,0.7000,0.3193,0.4199,0.7000,0.9635,0.4199,0.7000,0.9635,0.9635,0.7000,0.3193,0.9635,0.7000,0.9635,0.4199,0.7000,0.2150,0.4199,0.7000,0.2150,0.9635,0.7000,0.9635,0.9635,0.7000,0.2150,0.4199,0.7000,0.9868,0.4199,0.7000,0.9868,0.9635,0.7000,0.2150,0.9635,0.7000,0.9868,0.4199,0.7000,0.1081,0.4199,0.7000,0.1081,0.9635,0.7000,0.9868,0.9635,0.7000,0.1081,0.4199,0.7000,0.9985,0.4199,0.7000,0.9985,0.9635,0.7000,0.1081,0.9635,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000,0.0000,0.9635,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.9985,0.9635,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.9985,0.9635,0.7000,0.1081,0.9635,0.7000,0.1081,0.1081,0.7000,0.9985,0.1081,0.7000,0.1081,0.9635,0.7000,0.9868,0.9635,0.7000,0.9868,0.1081,0.7000,0.1081,0.1081,0.7000,0.9868,0.9635,0.7000,0.2150,0.9635,0.7000,0.2150,0.1081,0.7000,0.9868,0.1081,0.7000,0.2150,0.9635,0.7000,0.9635,0.9635,0.7000,0.9635,0.1081,0.7000,0.2150,0.1081,0.7000,0.9635,0.9635,0.7000,0.3193,0.9635,0.7000,0.3193,0.1081,0.7000,0.9635,0.1081,0.7000,0.3193,0.9635,0.7000,0.9290,0.9635,0.7000,0.9290,0.1081,0.7000,0.3193,0.1081,0.7000,0.9290,0.9635,0.7000,0.4199,0.9635,0.7000,0.4199,0.1081,0.7000,0.9290,0.1081,0.7000,0.4199,0.9635,0.7000,0.8835,0.9635,0.7000,0.8835,0.1081,0.7000,0.4199,0.1081,0.7000,0.8835,0.9635,0.7000,0.5156,0.9635,0.7000,0.5156,0.1081,0.7000,0.8835,0.1081,0.7000,0.5156,0.9635,0.7000,0.8277,0.9635,0.7000,0.8277,0.1081,0.7000,0.5156,0.1081,0.7000,0.8277,0.9635,0.7000,0.6052,0.9635,0.7000,0.6052,0.1081,0.7000,0.8277,0.1081,0.7000,0.6052,0.9635,0.7000,0.7622,0.9635,0.7000,0.7622,0.1081,0.7000,0.6052,0.1081,0.7000,0.7622,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.1081,0.7000,0.7622,0.1081,0.7000,0.6877,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9635,0.7000,0.7622,0.9635,0.7000,0.7622,0.1081,0.7000,0.6877,0.1081,0.7000,0.7622,0.9635,0.7000,0.6052,0.9635,0.7000,0.6052,0.1081,0.7000,0.7622,0.1081,0.7000,0.6052,0.9635,0.7000,0.8277,0.9635,0.7000,0.8277,0.1081,0.7000,0.6052,0.1081,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_11()
		{
			double[] value = {0.8277,0.9635,0.7000,0.5156,0.9635,0.7000,0.5156,0.1081,0.7000,0.8277,0.1081,0.7000,0.5156,0.9635,0.7000,0.8835,0.9635,0.7000,0.8835,0.1081,0.7000,0.5156,0.1081,0.7000,0.8835,0.9635,0.7000,0.4199,0.9635,0.7000,0.4199,0.1081,0.7000,0.8835,0.1081,0.7000,0.4199,0.9635,0.7000,0.9290,0.9635,0.7000,0.9290,0.1081,0.7000,0.4199,0.1081,0.7000,0.9290,0.9635,0.7000,0.3193,0.9635,0.7000,0.3193,0.1081,0.7000,0.9290,0.1081,0.7000,0.3193,0.9635,0.7000,0.9635,0.9635,0.7000,0.9635,0.1081,0.7000,0.3193,0.1081,0.7000,0.9635,0.9635,0.7000,0.2150,0.9635,0.7000,0.2150,0.1081,0.7000,0.9635,0.1081,0.7000,0.2150,0.9635,0.7000,0.9868,0.9635,0.7000,0.9868,0.1081,0.7000,0.2150,0.1081,0.7000,0.9868,0.9635,0.7000,0.1081,0.9635,0.7000,0.1081,0.1081,0.7000,0.9868,0.1081,0.7000,0.1081,0.9635,0.7000,0.9985,0.9635,0.7000,0.9985,0.1081,0.7000,0.1081,0.1081,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.0000,0.1081,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.9985,0.1081,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.9985,0.1081,0.7000,0.1081,0.1081,0.7000,0.1081,0.9985,0.7000,0.9985,0.9985,0.7000,0.1081,0.1081,0.7000,0.9868,0.1081,0.7000,0.9868,0.9985,0.7000,0.1081,0.9985,0.7000,0.9868,0.1081,0.7000,0.2150,0.1081,0.7000,0.2150,0.9985,0.7000,0.9868,0.9985,0.7000,0.2150,0.1081,0.7000,0.9635,0.1081,0.7000,0.9635,0.9985,0.7000,0.2150,0.9985,0.7000,0.9635,0.1081,0.7000,0.3193,0.1081,0.7000,0.3193,0.9985,0.7000,0.9635,0.9985,0.7000,0.3193,0.1081,0.7000,0.9290,0.1081,0.7000,0.9290,0.9985,0.7000,0.3193,0.9985,0.7000,0.9290,0.1081,0.7000,0.4199,0.1081,0.7000,0.4199,0.9985,0.7000,0.9290,0.9985,0.7000,0.4199,0.1081,0.7000,0.8835,0.1081,0.7000,0.8835,0.9985,0.7000,0.4199,0.9985,0.7000,0.8835,0.1081,0.7000,0.5156,0.1081,0.7000,0.5156,0.9985,0.7000,0.8835,0.9985,0.7000,0.5156,0.1081,0.7000,0.8277,0.1081,0.7000,0.8277,0.9985,0.7000,0.5156,0.9985,0.7000,0.8277,0.1081,0.7000,0.6052,0.1081,0.7000,0.6052,0.9985,0.7000,0.8277,0.9985,0.7000,0.6052,0.1081,0.7000,0.7622,0.1081,0.7000,0.7622,0.9985,0.7000,0.6052,0.9985,0.7000,0.7622,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9985,0.7000,0.7622,0.9985,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_12()
		{
			double[] value = {0.6877,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.1081,0.7000,0.7622,0.1081,0.7000,0.7622,0.9985,0.7000,0.6877,0.9985,0.7000,0.7622,0.1081,0.7000,0.6052,0.1081,0.7000,0.6052,0.9985,0.7000,0.7622,0.9985,0.7000,0.6052,0.1081,0.7000,0.8277,0.1081,0.7000,0.8277,0.9985,0.7000,0.6052,0.9985,0.7000,0.8277,0.1081,0.7000,0.5156,0.1081,0.7000,0.5156,0.9985,0.7000,0.8277,0.9985,0.7000,0.5156,0.1081,0.7000,0.8835,0.1081,0.7000,0.8835,0.9985,0.7000,0.5156,0.9985,0.7000,0.8835,0.1081,0.7000,0.4199,0.1081,0.7000,0.4199,0.9985,0.7000,0.8835,0.9985,0.7000,0.4199,0.1081,0.7000,0.9290,0.1081,0.7000,0.9290,0.9985,0.7000,0.4199,0.9985,0.7000,0.9290,0.1081,0.7000,0.3193,0.1081,0.7000,0.3193,0.9985,0.7000,0.9290,0.9985,0.7000,0.3193,0.1081,0.7000,0.9635,0.1081,0.7000,0.9635,0.9985,0.7000,0.3193,0.9985,0.7000,0.9635,0.1081,0.7000,0.2150,0.1081,0.7000,0.2150,0.9985,0.7000,0.9635,0.9985,0.7000,0.2150,0.1081,0.7000,0.9868,0.1081,0.7000,0.9868,0.9985,0.7000,0.2150,0.9985,0.7000,0.9868,0.1081,0.7000,0.1081,0.1081,0.7000,0.1081,0.9985,0.7000,0.9868,0.9985,0.7000,0.1081,0.1081,0.7000,0.9985,0.1081,0.7000,0.9985,0.9985,0.7000,0.1081,0.9985,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.0000,0.9985,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.9985,0.9985,0.7000,0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.9985,0.9985,0.7000,0.1081,0.9985,0.7000,0.1081,0.2150,0.7000,0.9985,0.2150,0.7000,0.1081,0.9985,0.7000,0.9868,0.9985,0.7000,0.9868,0.2150,0.7000,0.1081,0.2150,0.7000,0.9868,0.9985,0.7000,0.2150,0.9985,0.7000,0.2150,0.2150,0.7000,0.9868,0.2150,0.7000,0.2150,0.9985,0.7000,0.9635,0.9985,0.7000,0.9635,0.2150,0.7000,0.2150,0.2150,0.7000,0.9635,0.9985,0.7000,0.3193,0.9985,0.7000,0.3193,0.2150,0.7000,0.9635,0.2150,0.7000,0.3193,0.9985,0.7000,0.9290,0.9985,0.7000,0.9290,0.2150,0.7000,0.3193,0.2150,0.7000,0.9290,0.9985,0.7000,0.4199,0.9985,0.7000,0.4199,0.2150,0.7000,0.9290,0.2150,0.7000,0.4199,0.9985,0.7000,0.8835,0.9985,0.7000,0.8835,0.2150,0.7000,0.4199,0.2150,0.7000,0.8835,0.9985,0.7000,0.5156,0.9985,0.7000,0.5156,0.2150,0.7000,0.8835,0.2150,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_13()
		{
			double[] value = {0.5156,0.9985,0.7000,0.8277,0.9985,0.7000,0.8277,0.2150,0.7000,0.5156,0.2150,0.7000,0.8277,0.9985,0.7000,0.6052,0.9985,0.7000,0.6052,0.2150,0.7000,0.8277,0.2150,0.7000,0.6052,0.9985,0.7000,0.7622,0.9985,0.7000,0.7622,0.2150,0.7000,0.6052,0.2150,0.7000,0.7622,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.2150,0.7000,0.7622,0.2150,0.7000,0.6877,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9985,0.7000,0.7622,0.9985,0.7000,0.7622,0.2150,0.7000,0.6877,0.2150,0.7000,0.7622,0.9985,0.7000,0.6052,0.9985,0.7000,0.6052,0.2150,0.7000,0.7622,0.2150,0.7000,0.6052,0.9985,0.7000,0.8277,0.9985,0.7000,0.8277,0.2150,0.7000,0.6052,0.2150,0.7000,0.8277,0.9985,0.7000,0.5156,0.9985,0.7000,0.5156,0.2150,0.7000,0.8277,0.2150,0.7000,0.5156,0.9985,0.7000,0.8835,0.9985,0.7000,0.8835,0.2150,0.7000,0.5156,0.2150,0.7000,0.8835,0.9985,0.7000,0.4199,0.9985,0.7000,0.4199,0.2150,0.7000,0.8835,0.2150,0.7000,0.4199,0.9985,0.7000,0.9290,0.9985,0.7000,0.9290,0.2150,0.7000,0.4199,0.2150,0.7000,0.9290,0.9985,0.7000,0.3193,0.9985,0.7000,0.3193,0.2150,0.7000,0.9290,0.2150,0.7000,0.3193,0.9985,0.7000,0.9635,0.9985,0.7000,0.9635,0.2150,0.7000,0.3193,0.2150,0.7000,0.9635,0.9985,0.7000,0.2150,0.9985,0.7000,0.2150,0.2150,0.7000,0.9635,0.2150,0.7000,0.2150,0.9985,0.7000,0.9868,0.9985,0.7000,0.9868,0.2150,0.7000,0.2150,0.2150,0.7000,0.9868,0.9985,0.7000,0.1081,0.9985,0.7000,0.1081,0.2150,0.7000,0.9868,0.2150,0.7000,0.1081,0.9985,0.7000,0.9985,0.9985,0.7000,0.9985,0.2150,0.7000,0.1081,0.2150,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.0000,0.2150,0.7000,0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.9985,0.2150,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.9985,0.2150,0.7000,0.1081,0.2150,0.7000,0.1081,0.9290,0.7000,0.9985,0.9290,0.7000,0.1081,0.2150,0.7000,0.9868,0.2150,0.7000,0.9868,0.9290,0.7000,0.1081,0.9290,0.7000,0.9868,0.2150,0.7000,0.2150,0.2150,0.7000,0.2150,0.9290,0.7000,0.9868,0.9290,0.7000,0.2150,0.2150,0.7000,0.9635,0.2150,0.7000,0.9635,0.9290,0.7000,0.2150,0.9290,0.7000,0.9635,0.2150,0.7000,0.3193,0.2150,0.7000,0.3193,0.9290,0.7000,0.9635,0.9290,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_14()
		{
			double[] value = {0.3193,0.2150,0.7000,0.9290,0.2150,0.7000,0.9290,0.9290,0.7000,0.3193,0.9290,0.7000,0.9290,0.2150,0.7000,0.4199,0.2150,0.7000,0.4199,0.9290,0.7000,0.9290,0.9290,0.7000,0.4199,0.2150,0.7000,0.8835,0.2150,0.7000,0.8835,0.9290,0.7000,0.4199,0.9290,0.7000,0.8835,0.2150,0.7000,0.5156,0.2150,0.7000,0.5156,0.9290,0.7000,0.8835,0.9290,0.7000,0.5156,0.2150,0.7000,0.8277,0.2150,0.7000,0.8277,0.9290,0.7000,0.5156,0.9290,0.7000,0.8277,0.2150,0.7000,0.6052,0.2150,0.7000,0.6052,0.9290,0.7000,0.8277,0.9290,0.7000,0.6052,0.2150,0.7000,0.7622,0.2150,0.7000,0.7622,0.9290,0.7000,0.6052,0.9290,0.7000,0.7622,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9290,0.7000,0.7622,0.9290,0.7000,0.6877,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.2150,0.7000,0.7622,0.2150,0.7000,0.7622,0.9290,0.7000,0.6877,0.9290,0.7000,0.7622,0.2150,0.7000,0.6052,0.2150,0.7000,0.6052,0.9290,0.7000,0.7622,0.9290,0.7000,0.6052,0.2150,0.7000,0.8277,0.2150,0.7000,0.8277,0.9290,0.7000,0.6052,0.9290,0.7000,0.8277,0.2150,0.7000,0.5156,0.2150,0.7000,0.5156,0.9290,0.7000,0.8277,0.9290,0.7000,0.5156,0.2150,0.7000,0.8835,0.2150,0.7000,0.8835,0.9290,0.7000,0.5156,0.9290,0.7000,0.8835,0.2150,0.7000,0.4199,0.2150,0.7000,0.4199,0.9290,0.7000,0.8835,0.9290,0.7000,0.4199,0.2150,0.7000,0.9290,0.2150,0.7000,0.9290,0.9290,0.7000,0.4199,0.9290,0.7000,0.9290,0.2150,0.7000,0.3193,0.2150,0.7000,0.3193,0.9290,0.7000,0.9290,0.9290,0.7000,0.3193,0.2150,0.7000,0.9635,0.2150,0.7000,0.9635,0.9290,0.7000,0.3193,0.9290,0.7000,0.9635,0.2150,0.7000,0.2150,0.2150,0.7000,0.2150,0.9290,0.7000,0.9635,0.9290,0.7000,0.2150,0.2150,0.7000,0.9868,0.2150,0.7000,0.9868,0.9290,0.7000,0.2150,0.9290,0.7000,0.9868,0.2150,0.7000,0.1081,0.2150,0.7000,0.1081,0.9290,0.7000,0.9868,0.9290,0.7000,0.1081,0.2150,0.7000,0.9985,0.2150,0.7000,0.9985,0.9290,0.7000,0.1081,0.9290,0.7000,0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.0000,0.9290,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.9985,0.9290,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.9985,0.9290,0.7000,0.1081,0.9290,0.7000,0.1081,0.5156,0.7000,0.9985,0.5156,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_15()
		{
			double[] value = {0.1081,0.9290,0.7000,0.9868,0.9290,0.7000,0.9868,0.5156,0.7000,0.1081,0.5156,0.7000,0.9868,0.9290,0.7000,0.2150,0.9290,0.7000,0.2150,0.5156,0.7000,0.9868,0.5156,0.7000,0.2150,0.9290,0.7000,0.9635,0.9290,0.7000,0.9635,0.5156,0.7000,0.2150,0.5156,0.7000,0.9635,0.9290,0.7000,0.3193,0.9290,0.7000,0.3193,0.5156,0.7000,0.9635,0.5156,0.7000,0.3193,0.9290,0.7000,0.9290,0.9290,0.7000,0.9290,0.5156,0.7000,0.3193,0.5156,0.7000,0.9290,0.9290,0.7000,0.4199,0.9290,0.7000,0.4199,0.5156,0.7000,0.9290,0.5156,0.7000,0.4199,0.9290,0.7000,0.8835,0.9290,0.7000,0.8835,0.5156,0.7000,0.4199,0.5156,0.7000,0.8835,0.9290,0.7000,0.5156,0.9290,0.7000,0.5156,0.5156,0.7000,0.8835,0.5156,0.7000,0.5156,0.9290,0.7000,0.8277,0.9290,0.7000,0.8277,0.5156,0.7000,0.5156,0.5156,0.7000,0.8277,0.9290,0.7000,0.6052,0.9290,0.7000,0.6052,0.5156,0.7000,0.8277,0.5156,0.7000,0.6052,0.9290,0.7000,0.7622,0.9290,0.7000,0.7622,0.5156,0.7000,0.6052,0.5156,0.7000,0.7622,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.5156,0.7000,0.7622,0.5156,0.7000,0.6877,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.5156,0.7000,0.6877,0.5156,0.7000,0.6877,0.9290,0.7000,0.7622,0.9290,0.7000,0.7622,0.5156,0.7000,0.6877,0.5156,0.7000,0.7622,0.9290,0.7000,0.6052,0.9290,0.7000,0.6052,0.5156,0.7000,0.7622,0.5156,0.7000,0.6052,0.9290,0.7000,0.8277,0.9290,0.7000,0.8277,0.5156,0.7000,0.6052,0.5156,0.7000,0.8277,0.9290,0.7000,0.5156,0.9290,0.7000,0.5156,0.5156,0.7000,0.8277,0.5156,0.7000,0.5156,0.9290,0.7000,0.8835,0.9290,0.7000,0.8835,0.5156,0.7000,0.5156,0.5156,0.7000,0.8835,0.9290,0.7000,0.4199,0.9290,0.7000,0.4199,0.5156,0.7000,0.8835,0.5156,0.7000,0.4199,0.9290,0.7000,0.9290,0.9290,0.7000,0.9290,0.5156,0.7000,0.4199,0.5156,0.7000,0.9290,0.9290,0.7000,0.3193,0.9290,0.7000,0.3193,0.5156,0.7000,0.9290,0.5156,0.7000,0.3193,0.9290,0.7000,0.9635,0.9290,0.7000,0.9635,0.5156,0.7000,0.3193,0.5156,0.7000,0.9635,0.9290,0.7000,0.2150,0.9290,0.7000,0.2150,0.5156,0.7000,0.9635,0.5156,0.7000,0.2150,0.9290,0.7000,0.9868,0.9290,0.7000,0.9868,0.5156,0.7000,0.2150,0.5156,0.7000,0.9868,0.9290,0.7000,0.1081,0.9290,0.7000,0.1081,0.5156,0.7000,0.9868,0.5156,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_16()
		{
			double[] value = {0.1081,0.9290,0.7000,0.9985,0.9290,0.7000,0.9985,0.5156,0.7000,0.1081,0.5156,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.0000,0.5156,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.9985,0.5156,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.9985,0.5156,0.7000,0.1081,0.5156,0.7000,0.1081,0.7622,0.7000,0.9985,0.7622,0.7000,0.1081,0.5156,0.7000,0.9868,0.5156,0.7000,0.9868,0.7622,0.7000,0.1081,0.7622,0.7000,0.9868,0.5156,0.7000,0.2150,0.5156,0.7000,0.2150,0.7622,0.7000,0.9868,0.7622,0.7000,0.2150,0.5156,0.7000,0.9635,0.5156,0.7000,0.9635,0.7622,0.7000,0.2150,0.7622,0.7000,0.9635,0.5156,0.7000,0.3193,0.5156,0.7000,0.3193,0.7622,0.7000,0.9635,0.7622,0.7000,0.3193,0.5156,0.7000,0.9290,0.5156,0.7000,0.9290,0.7622,0.7000,0.3193,0.7622,0.7000,0.9290,0.5156,0.7000,0.4199,0.5156,0.7000,0.4199,0.7622,0.7000,0.9290,0.7622,0.7000,0.4199,0.5156,0.7000,0.8835,0.5156,0.7000,0.8835,0.7622,0.7000,0.4199,0.7622,0.7000,0.8835,0.5156,0.7000,0.5156,0.5156,0.7000,0.5156,0.7622,0.7000,0.8835,0.7622,0.7000,0.5156,0.5156,0.7000,0.8277,0.5156,0.7000,0.8277,0.7622,0.7000,0.5156,0.7622,0.7000,0.8277,0.5156,0.7000,0.6052,0.5156,0.7000,0.6052,0.7622,0.7000,0.8277,0.7622,0.7000,0.6052,0.5156,0.7000,0.7622,0.5156,0.7000,0.7622,0.7622,0.7000,0.6052,0.7622,0.7000,0.7622,0.5156,0.7000,0.6877,0.5156,0.7000,0.6877,0.7622,0.7000,0.7622,0.7622,0.7000,0.6877,0.5156,0.7000,0.6877,0.5156,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.5156,0.7000,0.7622,0.5156,0.7000,0.7622,0.7622,0.7000,0.6877,0.7622,0.7000,0.7622,0.5156,0.7000,0.6052,0.5156,0.7000,0.6052,0.7622,0.7000,0.7622,0.7622,0.7000,0.6052,0.5156,0.7000,0.8277,0.5156,0.7000,0.8277,0.7622,0.7000,0.6052,0.7622,0.7000,0.8277,0.5156,0.7000,0.5156,0.5156,0.7000,0.5156,0.7622,0.7000,0.8277,0.7622,0.7000,0.5156,0.5156,0.7000,0.8835,0.5156,0.7000,0.8835,0.7622,0.7000,0.5156,0.7622,0.7000,0.8835,0.5156,0.7000,0.4199,0.5156,0.7000,0.4199,0.7622,0.7000,0.8835,0.7622,0.7000,0.4199,0.5156,0.7000,0.9290,0.5156,0.7000,0.9290,0.7622,0.7000,0.4199,0.7622,0.7000,0.9290,0.5156,0.7000,0.3193,0.5156,0.7000,0.3193,0.7622,0.7000,0.9290,0.7622,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_17()
		{
			double[] value = {0.3193,0.5156,0.7000,0.9635,0.5156,0.7000,0.9635,0.7622,0.7000,0.3193,0.7622,0.7000,0.9635,0.5156,0.7000,0.2150,0.5156,0.7000,0.2150,0.7622,0.7000,0.9635,0.7622,0.7000,0.2150,0.5156,0.7000,0.9868,0.5156,0.7000,0.9868,0.7622,0.7000,0.2150,0.7622,0.7000,0.9868,0.5156,0.7000,0.1081,0.5156,0.7000,0.1081,0.7622,0.7000,0.9868,0.7622,0.7000,0.1081,0.5156,0.7000,0.9985,0.5156,0.7000,0.9985,0.7622,0.7000,0.1081,0.7622,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.0000,0.7622,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.9985,0.7622,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.9985,0.7622,0.7000,0.1081,0.7622,0.7000,0.1081,0.7622,0.7000,0.9985,0.7622,0.7000,0.1081,0.7622,0.7000,0.9868,0.7622,0.7000,0.9868,0.7622,0.7000,0.1081,0.7622,0.7000,0.9868,0.7622,0.7000,0.2150,0.7622,0.7000,0.2150,0.7622,0.7000,0.9868,0.7622,0.7000,0.2150,0.7622,0.7000,0.9635,0.7622,0.7000,0.9635,0.7622,0.7000,0.2150,0.7622,0.7000,0.9635,0.7622,0.7000,0.3193,0.7622,0.7000,0.3193,0.7622,0.7000,0.9635,0.7622,0.7000,0.3193,0.7622,0.7000,0.9290,0.7622,0.7000,0.9290,0.7622,0.7000,0.3193,0.7622,0.7000,0.9290,0.7622,0.7000,0.4199,0.7622,0.7000,0.4199,0.7622,0.7000,0.9290,0.7622,0.7000,0.4199,0.7622,0.7000,0.8835,0.7622,0.7000,0.8835,0.7622,0.7000,0.4199,0.7622,0.7000,0.8835,0.7622,0.7000,0.5156,0.7622,0.7000,0.5156,0.7622,0.7000,0.8835,0.7622,0.7000,0.5156,0.7622,0.7000,0.8277,0.7622,0.7000,0.8277,0.7622,0.7000,0.5156,0.7622,0.7000,0.8277,0.7622,0.7000,0.6052,0.7622,0.7000,0.6052,0.7622,0.7000,0.8277,0.7622,0.7000,0.6052,0.7622,0.7000,0.7622,0.7622,0.7000,0.7622,0.7622,0.7000,0.6052,0.7622,0.7000,0.7622,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.7622,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.7622,0.7622,0.7000,0.7622,0.7622,0.7000,0.6877,0.7622,0.7000,0.7622,0.7622,0.7000,0.6052,0.7622,0.7000,0.6052,0.7622,0.7000,0.7622,0.7622,0.7000,0.6052,0.7622,0.7000,0.8277,0.7622,0.7000,0.8277,0.7622,0.7000,0.6052,0.7622,0.7000,0.8277,0.7622,0.7000,0.5156,0.7622,0.7000,0.5156,0.7622,0.7000,0.8277,0.7622,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_18()
		{
			double[] value = {0.5156,0.7622,0.7000,0.8835,0.7622,0.7000,0.8835,0.7622,0.7000,0.5156,0.7622,0.7000,0.8835,0.7622,0.7000,0.4199,0.7622,0.7000,0.4199,0.7622,0.7000,0.8835,0.7622,0.7000,0.4199,0.7622,0.7000,0.9290,0.7622,0.7000,0.9290,0.7622,0.7000,0.4199,0.7622,0.7000,0.9290,0.7622,0.7000,0.3193,0.7622,0.7000,0.3193,0.7622,0.7000,0.9290,0.7622,0.7000,0.3193,0.7622,0.7000,0.9635,0.7622,0.7000,0.9635,0.7622,0.7000,0.3193,0.7622,0.7000,0.9635,0.7622,0.7000,0.2150,0.7622,0.7000,0.2150,0.7622,0.7000,0.9635,0.7622,0.7000,0.2150,0.7622,0.7000,0.9868,0.7622,0.7000,0.9868,0.7622,0.7000,0.2150,0.7622,0.7000,0.9868,0.7622,0.7000,0.1081,0.7622,0.7000,0.1081,0.7622,0.7000,0.9868,0.7622,0.7000,0.1081,0.7622,0.7000,0.9985,0.7622,0.7000,0.9985,0.7622,0.7000,0.1081,0.7622,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.0000,0.7622,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.9985,0.7622,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.9985,0.7622,0.7000,0.1081,0.7622,0.7000,0.1081,0.5156,0.7000,0.9985,0.5156,0.7000,0.1081,0.7622,0.7000,0.9868,0.7622,0.7000,0.9868,0.5156,0.7000,0.1081,0.5156,0.7000,0.9868,0.7622,0.7000,0.2150,0.7622,0.7000,0.2150,0.5156,0.7000,0.9868,0.5156,0.7000,0.2150,0.7622,0.7000,0.9635,0.7622,0.7000,0.9635,0.5156,0.7000,0.2150,0.5156,0.7000,0.9635,0.7622,0.7000,0.3193,0.7622,0.7000,0.3193,0.5156,0.7000,0.9635,0.5156,0.7000,0.3193,0.7622,0.7000,0.9290,0.7622,0.7000,0.9290,0.5156,0.7000,0.3193,0.5156,0.7000,0.9290,0.7622,0.7000,0.4199,0.7622,0.7000,0.4199,0.5156,0.7000,0.9290,0.5156,0.7000,0.4199,0.7622,0.7000,0.8835,0.7622,0.7000,0.8835,0.5156,0.7000,0.4199,0.5156,0.7000,0.8835,0.7622,0.7000,0.5156,0.7622,0.7000,0.5156,0.5156,0.7000,0.8835,0.5156,0.7000,0.5156,0.7622,0.7000,0.8277,0.7622,0.7000,0.8277,0.5156,0.7000,0.5156,0.5156,0.7000,0.8277,0.7622,0.7000,0.6052,0.7622,0.7000,0.6052,0.5156,0.7000,0.8277,0.5156,0.7000,0.6052,0.7622,0.7000,0.7622,0.7622,0.7000,0.7622,0.5156,0.7000,0.6052,0.5156,0.7000,0.7622,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.5156,0.7000,0.7622,0.5156,0.7000,0.6877,0.7622,0.7000,0.6877,0.7622,0.7000,0.6877,0.5156,0.7000,0.6877,0.5156,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_19()
		{
			double[] value = {0.6877,0.7622,0.7000,0.7622,0.7622,0.7000,0.7622,0.5156,0.7000,0.6877,0.5156,0.7000,0.7622,0.7622,0.7000,0.6052,0.7622,0.7000,0.6052,0.5156,0.7000,0.7622,0.5156,0.7000,0.6052,0.7622,0.7000,0.8277,0.7622,0.7000,0.8277,0.5156,0.7000,0.6052,0.5156,0.7000,0.8277,0.7622,0.7000,0.5156,0.7622,0.7000,0.5156,0.5156,0.7000,0.8277,0.5156,0.7000,0.5156,0.7622,0.7000,0.8835,0.7622,0.7000,0.8835,0.5156,0.7000,0.5156,0.5156,0.7000,0.8835,0.7622,0.7000,0.4199,0.7622,0.7000,0.4199,0.5156,0.7000,0.8835,0.5156,0.7000,0.4199,0.7622,0.7000,0.9290,0.7622,0.7000,0.9290,0.5156,0.7000,0.4199,0.5156,0.7000,0.9290,0.7622,0.7000,0.3193,0.7622,0.7000,0.3193,0.5156,0.7000,0.9290,0.5156,0.7000,0.3193,0.7622,0.7000,0.9635,0.7622,0.7000,0.9635,0.5156,0.7000,0.3193,0.5156,0.7000,0.9635,0.7622,0.7000,0.2150,0.7622,0.7000,0.2150,0.5156,0.7000,0.9635,0.5156,0.7000,0.2150,0.7622,0.7000,0.9868,0.7622,0.7000,0.9868,0.5156,0.7000,0.2150,0.5156,0.7000,0.9868,0.7622,0.7000,0.1081,0.7622,0.7000,0.1081,0.5156,0.7000,0.9868,0.5156,0.7000,0.1081,0.7622,0.7000,0.9985,0.7622,0.7000,0.9985,0.5156,0.7000,0.1081,0.5156,0.7000,0.9985,0.7622,0.7000,0.0000,0.7622,0.7000,0.0000,0.5156,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.9985,0.5156,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.9985,0.5156,0.7000,0.1081,0.5156,0.7000,0.1081,0.9290,0.7000,0.9985,0.9290,0.7000,0.1081,0.5156,0.7000,0.9868,0.5156,0.7000,0.9868,0.9290,0.7000,0.1081,0.9290,0.7000,0.9868,0.5156,0.7000,0.2150,0.5156,0.7000,0.2150,0.9290,0.7000,0.9868,0.9290,0.7000,0.2150,0.5156,0.7000,0.9635,0.5156,0.7000,0.9635,0.9290,0.7000,0.2150,0.9290,0.7000,0.9635,0.5156,0.7000,0.3193,0.5156,0.7000,0.3193,0.9290,0.7000,0.9635,0.9290,0.7000,0.3193,0.5156,0.7000,0.9290,0.5156,0.7000,0.9290,0.9290,0.7000,0.3193,0.9290,0.7000,0.9290,0.5156,0.7000,0.4199,0.5156,0.7000,0.4199,0.9290,0.7000,0.9290,0.9290,0.7000,0.4199,0.5156,0.7000,0.8835,0.5156,0.7000,0.8835,0.9290,0.7000,0.4199,0.9290,0.7000,0.8835,0.5156,0.7000,0.5156,0.5156,0.7000,0.5156,0.9290,0.7000,0.8835,0.9290,0.7000,0.5156,0.5156,0.7000,0.8277,0.5156,0.7000,0.8277,0.9290,0.7000,0.5156,0.9290,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_20()
		{
			double[] value = {0.8277,0.5156,0.7000,0.6052,0.5156,0.7000,0.6052,0.9290,0.7000,0.8277,0.9290,0.7000,0.6052,0.5156,0.7000,0.7622,0.5156,0.7000,0.7622,0.9290,0.7000,0.6052,0.9290,0.7000,0.7622,0.5156,0.7000,0.6877,0.5156,0.7000,0.6877,0.9290,0.7000,0.7622,0.9290,0.7000,0.6877,0.5156,0.7000,0.6877,0.5156,0.7000,0.6877,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.5156,0.7000,0.7622,0.5156,0.7000,0.7622,0.9290,0.7000,0.6877,0.9290,0.7000,0.7622,0.5156,0.7000,0.6052,0.5156,0.7000,0.6052,0.9290,0.7000,0.7622,0.9290,0.7000,0.6052,0.5156,0.7000,0.8277,0.5156,0.7000,0.8277,0.9290,0.7000,0.6052,0.9290,0.7000,0.8277,0.5156,0.7000,0.5156,0.5156,0.7000,0.5156,0.9290,0.7000,0.8277,0.9290,0.7000,0.5156,0.5156,0.7000,0.8835,0.5156,0.7000,0.8835,0.9290,0.7000,0.5156,0.9290,0.7000,0.8835,0.5156,0.7000,0.4199,0.5156,0.7000,0.4199,0.9290,0.7000,0.8835,0.9290,0.7000,0.4199,0.5156,0.7000,0.9290,0.5156,0.7000,0.9290,0.9290,0.7000,0.4199,0.9290,0.7000,0.9290,0.5156,0.7000,0.3193,0.5156,0.7000,0.3193,0.9290,0.7000,0.9290,0.9290,0.7000,0.3193,0.5156,0.7000,0.9635,0.5156,0.7000,0.9635,0.9290,0.7000,0.3193,0.9290,0.7000,0.9635,0.5156,0.7000,0.2150,0.5156,0.7000,0.2150,0.9290,0.7000,0.9635,0.9290,0.7000,0.2150,0.5156,0.7000,0.9868,0.5156,0.7000,0.9868,0.9290,0.7000,0.2150,0.9290,0.7000,0.9868,0.5156,0.7000,0.1081,0.5156,0.7000,0.1081,0.9290,0.7000,0.9868,0.9290,0.7000,0.1081,0.5156,0.7000,0.9985,0.5156,0.7000,0.9985,0.9290,0.7000,0.1081,0.9290,0.7000,0.9985,0.5156,0.7000,0.0000,0.5156,0.7000,0.0000,0.9290,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.9985,0.9290,0.7000,0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.9985,0.9290,0.7000,0.1081,0.9290,0.7000,0.1081,0.2150,0.7000,0.9985,0.2150,0.7000,0.1081,0.9290,0.7000,0.9868,0.9290,0.7000,0.9868,0.2150,0.7000,0.1081,0.2150,0.7000,0.9868,0.9290,0.7000,0.2150,0.9290,0.7000,0.2150,0.2150,0.7000,0.9868,0.2150,0.7000,0.2150,0.9290,0.7000,0.9635,0.9290,0.7000,0.9635,0.2150,0.7000,0.2150,0.2150,0.7000,0.9635,0.9290,0.7000,0.3193,0.9290,0.7000,0.3193,0.2150,0.7000,0.9635,0.2150,0.7000,0.3193,0.9290,0.7000,0.9290,0.9290,0.7000,0.9290,0.2150,0.7000,0.3193,0.2150,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_21()
		{
			double[] value = {0.9290,0.9290,0.7000,0.4199,0.9290,0.7000,0.4199,0.2150,0.7000,0.9290,0.2150,0.7000,0.4199,0.9290,0.7000,0.8835,0.9290,0.7000,0.8835,0.2150,0.7000,0.4199,0.2150,0.7000,0.8835,0.9290,0.7000,0.5156,0.9290,0.7000,0.5156,0.2150,0.7000,0.8835,0.2150,0.7000,0.5156,0.9290,0.7000,0.8277,0.9290,0.7000,0.8277,0.2150,0.7000,0.5156,0.2150,0.7000,0.8277,0.9290,0.7000,0.6052,0.9290,0.7000,0.6052,0.2150,0.7000,0.8277,0.2150,0.7000,0.6052,0.9290,0.7000,0.7622,0.9290,0.7000,0.7622,0.2150,0.7000,0.6052,0.2150,0.7000,0.7622,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.2150,0.7000,0.7622,0.2150,0.7000,0.6877,0.9290,0.7000,0.6877,0.9290,0.7000,0.6877,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9290,0.7000,0.7622,0.9290,0.7000,0.7622,0.2150,0.7000,0.6877,0.2150,0.7000,0.7622,0.9290,0.7000,0.6052,0.9290,0.7000,0.6052,0.2150,0.7000,0.7622,0.2150,0.7000,0.6052,0.9290,0.7000,0.8277,0.9290,0.7000,0.8277,0.2150,0.7000,0.6052,0.2150,0.7000,0.8277,0.9290,0.7000,0.5156,0.9290,0.7000,0.5156,0.2150,0.7000,0.8277,0.2150,0.7000,0.5156,0.9290,0.7000,0.8835,0.9290,0.7000,0.8835,0.2150,0.7000,0.5156,0.2150,0.7000,0.8835,0.9290,0.7000,0.4199,0.9290,0.7000,0.4199,0.2150,0.7000,0.8835,0.2150,0.7000,0.4199,0.9290,0.7000,0.9290,0.9290,0.7000,0.9290,0.2150,0.7000,0.4199,0.2150,0.7000,0.9290,0.9290,0.7000,0.3193,0.9290,0.7000,0.3193,0.2150,0.7000,0.9290,0.2150,0.7000,0.3193,0.9290,0.7000,0.9635,0.9290,0.7000,0.9635,0.2150,0.7000,0.3193,0.2150,0.7000,0.9635,0.9290,0.7000,0.2150,0.9290,0.7000,0.2150,0.2150,0.7000,0.9635,0.2150,0.7000,0.2150,0.9290,0.7000,0.9868,0.9290,0.7000,0.9868,0.2150,0.7000,0.2150,0.2150,0.7000,0.9868,0.9290,0.7000,0.1081,0.9290,0.7000,0.1081,0.2150,0.7000,0.9868,0.2150,0.7000,0.1081,0.9290,0.7000,0.9985,0.9290,0.7000,0.9985,0.2150,0.7000,0.1081,0.2150,0.7000,0.9985,0.9290,0.7000,0.0000,0.9290,0.7000,0.0000,0.2150,0.7000,0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.9985,0.2150,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.9985,0.2150,0.7000,0.1081,0.2150,0.7000,0.1081,0.9985,0.7000,0.9985,0.9985,0.7000,0.1081,0.2150,0.7000,0.9868,0.2150,0.7000,0.9868,0.9985,0.7000,0.1081,0.9985,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_22()
		{
			double[] value = {0.9868,0.2150,0.7000,0.2150,0.2150,0.7000,0.2150,0.9985,0.7000,0.9868,0.9985,0.7000,0.2150,0.2150,0.7000,0.9635,0.2150,0.7000,0.9635,0.9985,0.7000,0.2150,0.9985,0.7000,0.9635,0.2150,0.7000,0.3193,0.2150,0.7000,0.3193,0.9985,0.7000,0.9635,0.9985,0.7000,0.3193,0.2150,0.7000,0.9290,0.2150,0.7000,0.9290,0.9985,0.7000,0.3193,0.9985,0.7000,0.9290,0.2150,0.7000,0.4199,0.2150,0.7000,0.4199,0.9985,0.7000,0.9290,0.9985,0.7000,0.4199,0.2150,0.7000,0.8835,0.2150,0.7000,0.8835,0.9985,0.7000,0.4199,0.9985,0.7000,0.8835,0.2150,0.7000,0.5156,0.2150,0.7000,0.5156,0.9985,0.7000,0.8835,0.9985,0.7000,0.5156,0.2150,0.7000,0.8277,0.2150,0.7000,0.8277,0.9985,0.7000,0.5156,0.9985,0.7000,0.8277,0.2150,0.7000,0.6052,0.2150,0.7000,0.6052,0.9985,0.7000,0.8277,0.9985,0.7000,0.6052,0.2150,0.7000,0.7622,0.2150,0.7000,0.7622,0.9985,0.7000,0.6052,0.9985,0.7000,0.7622,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9985,0.7000,0.7622,0.9985,0.7000,0.6877,0.2150,0.7000,0.6877,0.2150,0.7000,0.6877,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.2150,0.7000,0.7622,0.2150,0.7000,0.7622,0.9985,0.7000,0.6877,0.9985,0.7000,0.7622,0.2150,0.7000,0.6052,0.2150,0.7000,0.6052,0.9985,0.7000,0.7622,0.9985,0.7000,0.6052,0.2150,0.7000,0.8277,0.2150,0.7000,0.8277,0.9985,0.7000,0.6052,0.9985,0.7000,0.8277,0.2150,0.7000,0.5156,0.2150,0.7000,0.5156,0.9985,0.7000,0.8277,0.9985,0.7000,0.5156,0.2150,0.7000,0.8835,0.2150,0.7000,0.8835,0.9985,0.7000,0.5156,0.9985,0.7000,0.8835,0.2150,0.7000,0.4199,0.2150,0.7000,0.4199,0.9985,0.7000,0.8835,0.9985,0.7000,0.4199,0.2150,0.7000,0.9290,0.2150,0.7000,0.9290,0.9985,0.7000,0.4199,0.9985,0.7000,0.9290,0.2150,0.7000,0.3193,0.2150,0.7000,0.3193,0.9985,0.7000,0.9290,0.9985,0.7000,0.3193,0.2150,0.7000,0.9635,0.2150,0.7000,0.9635,0.9985,0.7000,0.3193,0.9985,0.7000,0.9635,0.2150,0.7000,0.2150,0.2150,0.7000,0.2150,0.9985,0.7000,0.9635,0.9985,0.7000,0.2150,0.2150,0.7000,0.9868,0.2150,0.7000,0.9868,0.9985,0.7000,0.2150,0.9985,0.7000,0.9868,0.2150,0.7000,0.1081,0.2150,0.7000,0.1081,0.9985,0.7000,0.9868,0.9985,0.7000,0.1081,0.2150,0.7000,0.9985,0.2150,0.7000,0.9985,0.9985,0.7000,0.1081,0.9985,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_23()
		{
			double[] value = {0.9985,0.2150,0.7000,0.0000,0.2150,0.7000,0.0000,0.9985,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.9985,0.9985,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.9985,0.9985,0.7000,0.1081,0.9985,0.7000,0.1081,0.1081,0.7000,0.9985,0.1081,0.7000,0.1081,0.9985,0.7000,0.9868,0.9985,0.7000,0.9868,0.1081,0.7000,0.1081,0.1081,0.7000,0.9868,0.9985,0.7000,0.2150,0.9985,0.7000,0.2150,0.1081,0.7000,0.9868,0.1081,0.7000,0.2150,0.9985,0.7000,0.9635,0.9985,0.7000,0.9635,0.1081,0.7000,0.2150,0.1081,0.7000,0.9635,0.9985,0.7000,0.3193,0.9985,0.7000,0.3193,0.1081,0.7000,0.9635,0.1081,0.7000,0.3193,0.9985,0.7000,0.9290,0.9985,0.7000,0.9290,0.1081,0.7000,0.3193,0.1081,0.7000,0.9290,0.9985,0.7000,0.4199,0.9985,0.7000,0.4199,0.1081,0.7000,0.9290,0.1081,0.7000,0.4199,0.9985,0.7000,0.8835,0.9985,0.7000,0.8835,0.1081,0.7000,0.4199,0.1081,0.7000,0.8835,0.9985,0.7000,0.5156,0.9985,0.7000,0.5156,0.1081,0.7000,0.8835,0.1081,0.7000,0.5156,0.9985,0.7000,0.8277,0.9985,0.7000,0.8277,0.1081,0.7000,0.5156,0.1081,0.7000,0.8277,0.9985,0.7000,0.6052,0.9985,0.7000,0.6052,0.1081,0.7000,0.8277,0.1081,0.7000,0.6052,0.9985,0.7000,0.7622,0.9985,0.7000,0.7622,0.1081,0.7000,0.6052,0.1081,0.7000,0.7622,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.1081,0.7000,0.7622,0.1081,0.7000,0.6877,0.9985,0.7000,0.6877,0.9985,0.7000,0.6877,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9985,0.7000,0.7622,0.9985,0.7000,0.7622,0.1081,0.7000,0.6877,0.1081,0.7000,0.7622,0.9985,0.7000,0.6052,0.9985,0.7000,0.6052,0.1081,0.7000,0.7622,0.1081,0.7000,0.6052,0.9985,0.7000,0.8277,0.9985,0.7000,0.8277,0.1081,0.7000,0.6052,0.1081,0.7000,0.8277,0.9985,0.7000,0.5156,0.9985,0.7000,0.5156,0.1081,0.7000,0.8277,0.1081,0.7000,0.5156,0.9985,0.7000,0.8835,0.9985,0.7000,0.8835,0.1081,0.7000,0.5156,0.1081,0.7000,0.8835,0.9985,0.7000,0.4199,0.9985,0.7000,0.4199,0.1081,0.7000,0.8835,0.1081,0.7000,0.4199,0.9985,0.7000,0.9290,0.9985,0.7000,0.9290,0.1081,0.7000,0.4199,0.1081,0.7000,0.9290,0.9985,0.7000,0.3193,0.9985,0.7000,0.3193,0.1081,0.7000,0.9290,0.1081,0.7000,0.3193,0.9985,0.7000,0.9635,0.9985,0.7000,0.9635,0.1081,0.7000,0.3193,0.1081,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_24()
		{
			double[] value = {0.9635,0.9985,0.7000,0.2150,0.9985,0.7000,0.2150,0.1081,0.7000,0.9635,0.1081,0.7000,0.2150,0.9985,0.7000,0.9868,0.9985,0.7000,0.9868,0.1081,0.7000,0.2150,0.1081,0.7000,0.9868,0.9985,0.7000,0.1081,0.9985,0.7000,0.1081,0.1081,0.7000,0.9868,0.1081,0.7000,0.1081,0.9985,0.7000,0.9985,0.9985,0.7000,0.9985,0.1081,0.7000,0.1081,0.1081,0.7000,0.9985,0.9985,0.7000,0.0000,0.9985,0.7000,0.0000,0.1081,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.9985,0.1081,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.9985,0.1081,0.7000,0.1081,0.1081,0.7000,0.1081,0.9635,0.7000,0.9985,0.9635,0.7000,0.1081,0.1081,0.7000,0.9868,0.1081,0.7000,0.9868,0.9635,0.7000,0.1081,0.9635,0.7000,0.9868,0.1081,0.7000,0.2150,0.1081,0.7000,0.2150,0.9635,0.7000,0.9868,0.9635,0.7000,0.2150,0.1081,0.7000,0.9635,0.1081,0.7000,0.9635,0.9635,0.7000,0.2150,0.9635,0.7000,0.9635,0.1081,0.7000,0.3193,0.1081,0.7000,0.3193,0.9635,0.7000,0.9635,0.9635,0.7000,0.3193,0.1081,0.7000,0.9290,0.1081,0.7000,0.9290,0.9635,0.7000,0.3193,0.9635,0.7000,0.9290,0.1081,0.7000,0.4199,0.1081,0.7000,0.4199,0.9635,0.7000,0.9290,0.9635,0.7000,0.4199,0.1081,0.7000,0.8835,0.1081,0.7000,0.8835,0.9635,0.7000,0.4199,0.9635,0.7000,0.8835,0.1081,0.7000,0.5156,0.1081,0.7000,0.5156,0.9635,0.7000,0.8835,0.9635,0.7000,0.5156,0.1081,0.7000,0.8277,0.1081,0.7000,0.8277,0.9635,0.7000,0.5156,0.9635,0.7000,0.8277,0.1081,0.7000,0.6052,0.1081,0.7000,0.6052,0.9635,0.7000,0.8277,0.9635,0.7000,0.6052,0.1081,0.7000,0.7622,0.1081,0.7000,0.7622,0.9635,0.7000,0.6052,0.9635,0.7000,0.7622,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9635,0.7000,0.7622,0.9635,0.7000,0.6877,0.1081,0.7000,0.6877,0.1081,0.7000,0.6877,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.1081,0.7000,0.7622,0.1081,0.7000,0.7622,0.9635,0.7000,0.6877,0.9635,0.7000,0.7622,0.1081,0.7000,0.6052,0.1081,0.7000,0.6052,0.9635,0.7000,0.7622,0.9635,0.7000,0.6052,0.1081,0.7000,0.8277,0.1081,0.7000,0.8277,0.9635,0.7000,0.6052,0.9635,0.7000,0.8277,0.1081,0.7000,0.5156,0.1081,0.7000,0.5156,0.9635,0.7000,0.8277,0.9635,0.7000,0.5156,0.1081,0.7000,0.8835,0.1081,0.7000,0.8835,0.9635,0.7000,0.5156,0.9635,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_25()
		{
			double[] value = {0.8835,0.1081,0.7000,0.4199,0.1081,0.7000,0.4199,0.9635,0.7000,0.8835,0.9635,0.7000,0.4199,0.1081,0.7000,0.9290,0.1081,0.7000,0.9290,0.9635,0.7000,0.4199,0.9635,0.7000,0.9290,0.1081,0.7000,0.3193,0.1081,0.7000,0.3193,0.9635,0.7000,0.9290,0.9635,0.7000,0.3193,0.1081,0.7000,0.9635,0.1081,0.7000,0.9635,0.9635,0.7000,0.3193,0.9635,0.7000,0.9635,0.1081,0.7000,0.2150,0.1081,0.7000,0.2150,0.9635,0.7000,0.9635,0.9635,0.7000,0.2150,0.1081,0.7000,0.9868,0.1081,0.7000,0.9868,0.9635,0.7000,0.2150,0.9635,0.7000,0.9868,0.1081,0.7000,0.1081,0.1081,0.7000,0.1081,0.9635,0.7000,0.9868,0.9635,0.7000,0.1081,0.1081,0.7000,0.9985,0.1081,0.7000,0.9985,0.9635,0.7000,0.1081,0.9635,0.7000,0.9985,0.1081,0.7000,0.0000,0.1081,0.7000,0.0000,0.9635,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.9985,0.9635,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000,0.9985,0.9635,0.7000,0.1081,0.9635,0.7000,0.1081,0.4199,0.7000,0.9985,0.4199,0.7000,0.1081,0.9635,0.7000,0.9868,0.9635,0.7000,0.9868,0.4199,0.7000,0.1081,0.4199,0.7000,0.9868,0.9635,0.7000,0.2150,0.9635,0.7000,0.2150,0.4199,0.7000,0.9868,0.4199,0.7000,0.2150,0.9635,0.7000,0.9635,0.9635,0.7000,0.9635,0.4199,0.7000,0.2150,0.4199,0.7000,0.9635,0.9635,0.7000,0.3193,0.9635,0.7000,0.3193,0.4199,0.7000,0.9635,0.4199,0.7000,0.3193,0.9635,0.7000,0.9290,0.9635,0.7000,0.9290,0.4199,0.7000,0.3193,0.4199,0.7000,0.9290,0.9635,0.7000,0.4199,0.9635,0.7000,0.4199,0.4199,0.7000,0.9290,0.4199,0.7000,0.4199,0.9635,0.7000,0.8835,0.9635,0.7000,0.8835,0.4199,0.7000,0.4199,0.4199,0.7000,0.8835,0.9635,0.7000,0.5156,0.9635,0.7000,0.5156,0.4199,0.7000,0.8835,0.4199,0.7000,0.5156,0.9635,0.7000,0.8277,0.9635,0.7000,0.8277,0.4199,0.7000,0.5156,0.4199,0.7000,0.8277,0.9635,0.7000,0.6052,0.9635,0.7000,0.6052,0.4199,0.7000,0.8277,0.4199,0.7000,0.6052,0.9635,0.7000,0.7622,0.9635,0.7000,0.7622,0.4199,0.7000,0.6052,0.4199,0.7000,0.7622,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.4199,0.7000,0.7622,0.4199,0.7000,0.6877,0.9635,0.7000,0.6877,0.9635,0.7000,0.6877,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.9635,0.7000,0.7622,0.9635,0.7000,0.7622,0.4199,0.7000,0.6877,0.4199,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_26()
		{
			double[] value = {0.7622,0.9635,0.7000,0.6052,0.9635,0.7000,0.6052,0.4199,0.7000,0.7622,0.4199,0.7000,0.6052,0.9635,0.7000,0.8277,0.9635,0.7000,0.8277,0.4199,0.7000,0.6052,0.4199,0.7000,0.8277,0.9635,0.7000,0.5156,0.9635,0.7000,0.5156,0.4199,0.7000,0.8277,0.4199,0.7000,0.5156,0.9635,0.7000,0.8835,0.9635,0.7000,0.8835,0.4199,0.7000,0.5156,0.4199,0.7000,0.8835,0.9635,0.7000,0.4199,0.9635,0.7000,0.4199,0.4199,0.7000,0.8835,0.4199,0.7000,0.4199,0.9635,0.7000,0.9290,0.9635,0.7000,0.9290,0.4199,0.7000,0.4199,0.4199,0.7000,0.9290,0.9635,0.7000,0.3193,0.9635,0.7000,0.3193,0.4199,0.7000,0.9290,0.4199,0.7000,0.3193,0.9635,0.7000,0.9635,0.9635,0.7000,0.9635,0.4199,0.7000,0.3193,0.4199,0.7000,0.9635,0.9635,0.7000,0.2150,0.9635,0.7000,0.2150,0.4199,0.7000,0.9635,0.4199,0.7000,0.2150,0.9635,0.7000,0.9868,0.9635,0.7000,0.9868,0.4199,0.7000,0.2150,0.4199,0.7000,0.9868,0.9635,0.7000,0.1081,0.9635,0.7000,0.1081,0.4199,0.7000,0.9868,0.4199,0.7000,0.1081,0.9635,0.7000,0.9985,0.9635,0.7000,0.9985,0.4199,0.7000,0.1081,0.4199,0.7000,0.9985,0.9635,0.7000,0.0000,0.9635,0.7000,0.0000,0.4199,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000,0.9985,0.4199,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.9985,0.4199,0.7000,0.1081,0.4199,0.7000,0.1081,0.8277,0.7000,0.9985,0.8277,0.7000,0.1081,0.4199,0.7000,0.9868,0.4199,0.7000,0.9868,0.8277,0.7000,0.1081,0.8277,0.7000,0.9868,0.4199,0.7000,0.2150,0.4199,0.7000,0.2150,0.8277,0.7000,0.9868,0.8277,0.7000,0.2150,0.4199,0.7000,0.9635,0.4199,0.7000,0.9635,0.8277,0.7000,0.2150,0.8277,0.7000,0.9635,0.4199,0.7000,0.3193,0.4199,0.7000,0.3193,0.8277,0.7000,0.9635,0.8277,0.7000,0.3193,0.4199,0.7000,0.9290,0.4199,0.7000,0.9290,0.8277,0.7000,0.3193,0.8277,0.7000,0.9290,0.4199,0.7000,0.4199,0.4199,0.7000,0.4199,0.8277,0.7000,0.9290,0.8277,0.7000,0.4199,0.4199,0.7000,0.8835,0.4199,0.7000,0.8835,0.8277,0.7000,0.4199,0.8277,0.7000,0.8835,0.4199,0.7000,0.5156,0.4199,0.7000,0.5156,0.8277,0.7000,0.8835,0.8277,0.7000,0.5156,0.4199,0.7000,0.8277,0.4199,0.7000,0.8277,0.8277,0.7000,0.5156,0.8277,0.7000,0.8277,0.4199,0.7000,0.6052,0.4199,0.7000,0.6052,0.8277,0.7000,0.8277,0.8277,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_27()
		{
			double[] value = {0.6052,0.4199,0.7000,0.7622,0.4199,0.7000,0.7622,0.8277,0.7000,0.6052,0.8277,0.7000,0.7622,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.8277,0.7000,0.7622,0.8277,0.7000,0.6877,0.4199,0.7000,0.6877,0.4199,0.7000,0.6877,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.4199,0.7000,0.7622,0.4199,0.7000,0.7622,0.8277,0.7000,0.6877,0.8277,0.7000,0.7622,0.4199,0.7000,0.6052,0.4199,0.7000,0.6052,0.8277,0.7000,0.7622,0.8277,0.7000,0.6052,0.4199,0.7000,0.8277,0.4199,0.7000,0.8277,0.8277,0.7000,0.6052,0.8277,0.7000,0.8277,0.4199,0.7000,0.5156,0.4199,0.7000,0.5156,0.8277,0.7000,0.8277,0.8277,0.7000,0.5156,0.4199,0.7000,0.8835,0.4199,0.7000,0.8835,0.8277,0.7000,0.5156,0.8277,0.7000,0.8835,0.4199,0.7000,0.4199,0.4199,0.7000,0.4199,0.8277,0.7000,0.8835,0.8277,0.7000,0.4199,0.4199,0.7000,0.9290,0.4199,0.7000,0.9290,0.8277,0.7000,0.4199,0.8277,0.7000,0.9290,0.4199,0.7000,0.3193,0.4199,0.7000,0.3193,0.8277,0.7000,0.9290,0.8277,0.7000,0.3193,0.4199,0.7000,0.9635,0.4199,0.7000,0.9635,0.8277,0.7000,0.3193,0.8277,0.7000,0.9635,0.4199,0.7000,0.2150,0.4199,0.7000,0.2150,0.8277,0.7000,0.9635,0.8277,0.7000,0.2150,0.4199,0.7000,0.9868,0.4199,0.7000,0.9868,0.8277,0.7000,0.2150,0.8277,0.7000,0.9868,0.4199,0.7000,0.1081,0.4199,0.7000,0.1081,0.8277,0.7000,0.9868,0.8277,0.7000,0.1081,0.4199,0.7000,0.9985,0.4199,0.7000,0.9985,0.8277,0.7000,0.1081,0.8277,0.7000,0.9985,0.4199,0.7000,0.0000,0.4199,0.7000,0.0000,0.8277,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.9985,0.8277,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.9985,0.8277,0.7000,0.1081,0.8277,0.7000,0.1081,0.6877,0.7000,0.9985,0.6877,0.7000,0.1081,0.8277,0.7000,0.9868,0.8277,0.7000,0.9868,0.6877,0.7000,0.1081,0.6877,0.7000,0.9868,0.8277,0.7000,0.2150,0.8277,0.7000,0.2150,0.6877,0.7000,0.9868,0.6877,0.7000,0.2150,0.8277,0.7000,0.9635,0.8277,0.7000,0.9635,0.6877,0.7000,0.2150,0.6877,0.7000,0.9635,0.8277,0.7000,0.3193,0.8277,0.7000,0.3193,0.6877,0.7000,0.9635,0.6877,0.7000,0.3193,0.8277,0.7000,0.9290,0.8277,0.7000,0.9290,0.6877,0.7000,0.3193,0.6877,0.7000,0.9290,0.8277,0.7000,0.4199,0.8277,0.7000,0.4199,0.6877,0.7000,0.9290,0.6877,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_28()
		{
			double[] value = {0.4199,0.8277,0.7000,0.8835,0.8277,0.7000,0.8835,0.6877,0.7000,0.4199,0.6877,0.7000,0.8835,0.8277,0.7000,0.5156,0.8277,0.7000,0.5156,0.6877,0.7000,0.8835,0.6877,0.7000,0.5156,0.8277,0.7000,0.8277,0.8277,0.7000,0.8277,0.6877,0.7000,0.5156,0.6877,0.7000,0.8277,0.8277,0.7000,0.6052,0.8277,0.7000,0.6052,0.6877,0.7000,0.8277,0.6877,0.7000,0.6052,0.8277,0.7000,0.7622,0.8277,0.7000,0.7622,0.6877,0.7000,0.6052,0.6877,0.7000,0.7622,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.6877,0.7000,0.7622,0.6877,0.7000,0.6877,0.8277,0.7000,0.6877,0.8277,0.7000,0.6877,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.8277,0.7000,0.7622,0.8277,0.7000,0.7622,0.6877,0.7000,0.6877,0.6877,0.7000,0.7622,0.8277,0.7000,0.6052,0.8277,0.7000,0.6052,0.6877,0.7000,0.7622,0.6877,0.7000,0.6052,0.8277,0.7000,0.8277,0.8277,0.7000,0.8277,0.6877,0.7000,0.6052,0.6877,0.7000,0.8277,0.8277,0.7000,0.5156,0.8277,0.7000,0.5156,0.6877,0.7000,0.8277,0.6877,0.7000,0.5156,0.8277,0.7000,0.8835,0.8277,0.7000,0.8835,0.6877,0.7000,0.5156,0.6877,0.7000,0.8835,0.8277,0.7000,0.4199,0.8277,0.7000,0.4199,0.6877,0.7000,0.8835,0.6877,0.7000,0.4199,0.8277,0.7000,0.9290,0.8277,0.7000,0.9290,0.6877,0.7000,0.4199,0.6877,0.7000,0.9290,0.8277,0.7000,0.3193,0.8277,0.7000,0.3193,0.6877,0.7000,0.9290,0.6877,0.7000,0.3193,0.8277,0.7000,0.9635,0.8277,0.7000,0.9635,0.6877,0.7000,0.3193,0.6877,0.7000,0.9635,0.8277,0.7000,0.2150,0.8277,0.7000,0.2150,0.6877,0.7000,0.9635,0.6877,0.7000,0.2150,0.8277,0.7000,0.9868,0.8277,0.7000,0.9868,0.6877,0.7000,0.2150,0.6877,0.7000,0.9868,0.8277,0.7000,0.1081,0.8277,0.7000,0.1081,0.6877,0.7000,0.9868,0.6877,0.7000,0.1081,0.8277,0.7000,0.9985,0.8277,0.7000,0.9985,0.6877,0.7000,0.1081,0.6877,0.7000,0.9985,0.8277,0.7000,0.0000,0.8277,0.7000,0.0000,0.6877,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.9985,0.6877,0.7000,0.9985,0.6052,0.7000,0.0000,0.6052,0.7000,0.9985,0.6877,0.7000,0.1081,0.6877,0.7000,0.1081,0.6052,0.7000,0.9985,0.6052,0.7000,0.1081,0.6877,0.7000,0.9868,0.6877,0.7000,0.9868,0.6052,0.7000,0.1081,0.6052,0.7000,0.9868,0.6877,0.7000,0.2150,0.6877,0.7000,0.2150,0.6052,0.7000,0.9868,0.6052,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_29()
		{
			double[] value = {0.2150,0.6877,0.7000,0.9635,0.6877,0.7000,0.9635,0.6052,0.7000,0.2150,0.6052,0.7000,0.9635,0.6877,0.7000,0.3193,0.6877,0.7000,0.3193,0.6052,0.7000,0.9635,0.6052,0.7000,0.3193,0.6877,0.7000,0.9290,0.6877,0.7000,0.9290,0.6052,0.7000,0.3193,0.6052,0.7000,0.9290,0.6877,0.7000,0.4199,0.6877,0.7000,0.4199,0.6052,0.7000,0.9290,0.6052,0.7000,0.4199,0.6877,0.7000,0.8835,0.6877,0.7000,0.8835,0.6052,0.7000,0.4199,0.6052,0.7000,0.8835,0.6877,0.7000,0.5156,0.6877,0.7000,0.5156,0.6052,0.7000,0.8835,0.6052,0.7000,0.5156,0.6877,0.7000,0.8277,0.6877,0.7000,0.8277,0.6052,0.7000,0.5156,0.6052,0.7000,0.8277,0.6877,0.7000,0.6052,0.6877,0.7000,0.6052,0.6052,0.7000,0.8277,0.6052,0.7000,0.6052,0.6877,0.7000,0.7622,0.6877,0.7000,0.7622,0.6052,0.7000,0.6052,0.6052,0.7000,0.7622,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.6052,0.7000,0.7622,0.6052,0.7000,0.6877,0.6877,0.7000,0.6877,0.6877,0.7000,0.6877,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.6877,0.7000,0.7622,0.6877,0.7000,0.7622,0.6052,0.7000,0.6877,0.6052,0.7000,0.7622,0.6877,0.7000,0.6052,0.6877,0.7000,0.6052,0.6052,0.7000,0.7622,0.6052,0.7000,0.6052,0.6877,0.7000,0.8277,0.6877,0.7000,0.8277,0.6052,0.7000,0.6052,0.6052,0.7000,0.8277,0.6877,0.7000,0.5156,0.6877,0.7000,0.5156,0.6052,0.7000,0.8277,0.6052,0.7000,0.5156,0.6877,0.7000,0.8835,0.6877,0.7000,0.8835,0.6052,0.7000,0.5156,0.6052,0.7000,0.8835,0.6877,0.7000,0.4199,0.6877,0.7000,0.4199,0.6052,0.7000,0.8835,0.6052,0.7000,0.4199,0.6877,0.7000,0.9290,0.6877,0.7000,0.9290,0.6052,0.7000,0.4199,0.6052,0.7000,0.9290,0.6877,0.7000,0.3193,0.6877,0.7000,0.3193,0.6052,0.7000,0.9290,0.6052,0.7000,0.3193,0.6877,0.7000,0.9635,0.6877,0.7000,0.9635,0.6052,0.7000,0.3193,0.6052,0.7000,0.9635,0.6877,0.7000,0.2150,0.6877,0.7000,0.2150,0.6052,0.7000,0.9635,0.6052,0.7000,0.2150,0.6877,0.7000,0.9868,0.6877,0.7000,0.9868,0.6052,0.7000,0.2150,0.6052,0.7000,0.9868,0.6877,0.7000,0.1081,0.6877,0.7000,0.1081,0.6052,0.7000,0.9868,0.6052,0.7000,0.1081,0.6877,0.7000,0.9985,0.6877,0.7000,0.9985,0.6052,0.7000,0.1081,0.6052,0.7000,0.9985,0.6877,0.7000,0.0000,0.6877,0.7000,0.0000,0.6052,0.7000,0.9985,0.6052,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_30()
		{
			double[] value = {0.0000,0.6052,0.7000,0.9985,0.6052,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.9985,0.6052,0.7000,0.1081,0.6052,0.7000,0.1081,0.8835,0.7000,0.9985,0.8835,0.7000,0.1081,0.6052,0.7000,0.9868,0.6052,0.7000,0.9868,0.8835,0.7000,0.1081,0.8835,0.7000,0.9868,0.6052,0.7000,0.2150,0.6052,0.7000,0.2150,0.8835,0.7000,0.9868,0.8835,0.7000,0.2150,0.6052,0.7000,0.9635,0.6052,0.7000,0.9635,0.8835,0.7000,0.2150,0.8835,0.7000,0.9635,0.6052,0.7000,0.3193,0.6052,0.7000,0.3193,0.8835,0.7000,0.9635,0.8835,0.7000,0.3193,0.6052,0.7000,0.9290,0.6052,0.7000,0.9290,0.8835,0.7000,0.3193,0.8835,0.7000,0.9290,0.6052,0.7000,0.4199,0.6052,0.7000,0.4199,0.8835,0.7000,0.9290,0.8835,0.7000,0.4199,0.6052,0.7000,0.8835,0.6052,0.7000,0.8835,0.8835,0.7000,0.4199,0.8835,0.7000,0.8835,0.6052,0.7000,0.5156,0.6052,0.7000,0.5156,0.8835,0.7000,0.8835,0.8835,0.7000,0.5156,0.6052,0.7000,0.8277,0.6052,0.7000,0.8277,0.8835,0.7000,0.5156,0.8835,0.7000,0.8277,0.6052,0.7000,0.6052,0.6052,0.7000,0.6052,0.8835,0.7000,0.8277,0.8835,0.7000,0.6052,0.6052,0.7000,0.7622,0.6052,0.7000,0.7622,0.8835,0.7000,0.6052,0.8835,0.7000,0.7622,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.8835,0.7000,0.7622,0.8835,0.7000,0.6877,0.6052,0.7000,0.6877,0.6052,0.7000,0.6877,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.6052,0.7000,0.7622,0.6052,0.7000,0.7622,0.8835,0.7000,0.6877,0.8835,0.7000,0.7622,0.6052,0.7000,0.6052,0.6052,0.7000,0.6052,0.8835,0.7000,0.7622,0.8835,0.7000,0.6052,0.6052,0.7000,0.8277,0.6052,0.7000,0.8277,0.8835,0.7000,0.6052,0.8835,0.7000,0.8277,0.6052,0.7000,0.5156,0.6052,0.7000,0.5156,0.8835,0.7000,0.8277,0.8835,0.7000,0.5156,0.6052,0.7000,0.8835,0.6052,0.7000,0.8835,0.8835,0.7000,0.5156,0.8835,0.7000,0.8835,0.6052,0.7000,0.4199,0.6052,0.7000,0.4199,0.8835,0.7000,0.8835,0.8835,0.7000,0.4199,0.6052,0.7000,0.9290,0.6052,0.7000,0.9290,0.8835,0.7000,0.4199,0.8835,0.7000,0.9290,0.6052,0.7000,0.3193,0.6052,0.7000,0.3193,0.8835,0.7000,0.9290,0.8835,0.7000,0.3193,0.6052,0.7000,0.9635,0.6052,0.7000,0.9635,0.8835,0.7000,0.3193,0.8835,0.7000,0.9635,0.6052,0.7000,0.2150,0.6052,0.7000,0.2150,0.8835,0.7000,0.9635,0.8835,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_31()
		{
			double[] value = {0.2150,0.6052,0.7000,0.9868,0.6052,0.7000,0.9868,0.8835,0.7000,0.2150,0.8835,0.7000,0.9868,0.6052,0.7000,0.1081,0.6052,0.7000,0.1081,0.8835,0.7000,0.9868,0.8835,0.7000,0.1081,0.6052,0.7000,0.9985,0.6052,0.7000,0.9985,0.8835,0.7000,0.1081,0.8835,0.7000,0.9985,0.6052,0.7000,0.0000,0.6052,0.7000,0.0000,0.8835,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.9985,0.8835,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.9985,0.8835,0.7000,0.1081,0.8835,0.7000,0.1081,0.3193,0.7000,0.9985,0.3193,0.7000,0.1081,0.8835,0.7000,0.9868,0.8835,0.7000,0.9868,0.3193,0.7000,0.1081,0.3193,0.7000,0.9868,0.8835,0.7000,0.2150,0.8835,0.7000,0.2150,0.3193,0.7000,0.9868,0.3193,0.7000,0.2150,0.8835,0.7000,0.9635,0.8835,0.7000,0.9635,0.3193,0.7000,0.2150,0.3193,0.7000,0.9635,0.8835,0.7000,0.3193,0.8835,0.7000,0.3193,0.3193,0.7000,0.9635,0.3193,0.7000,0.3193,0.8835,0.7000,0.9290,0.8835,0.7000,0.9290,0.3193,0.7000,0.3193,0.3193,0.7000,0.9290,0.8835,0.7000,0.4199,0.8835,0.7000,0.4199,0.3193,0.7000,0.9290,0.3193,0.7000,0.4199,0.8835,0.7000,0.8835,0.8835,0.7000,0.8835,0.3193,0.7000,0.4199,0.3193,0.7000,0.8835,0.8835,0.7000,0.5156,0.8835,0.7000,0.5156,0.3193,0.7000,0.8835,0.3193,0.7000,0.5156,0.8835,0.7000,0.8277,0.8835,0.7000,0.8277,0.3193,0.7000,0.5156,0.3193,0.7000,0.8277,0.8835,0.7000,0.6052,0.8835,0.7000,0.6052,0.3193,0.7000,0.8277,0.3193,0.7000,0.6052,0.8835,0.7000,0.7622,0.8835,0.7000,0.7622,0.3193,0.7000,0.6052,0.3193,0.7000,0.7622,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.3193,0.7000,0.7622,0.3193,0.7000,0.6877,0.8835,0.7000,0.6877,0.8835,0.7000,0.6877,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.8835,0.7000,0.7622,0.8835,0.7000,0.7622,0.3193,0.7000,0.6877,0.3193,0.7000,0.7622,0.8835,0.7000,0.6052,0.8835,0.7000,0.6052,0.3193,0.7000,0.7622,0.3193,0.7000,0.6052,0.8835,0.7000,0.8277,0.8835,0.7000,0.8277,0.3193,0.7000,0.6052,0.3193,0.7000,0.8277,0.8835,0.7000,0.5156,0.8835,0.7000,0.5156,0.3193,0.7000,0.8277,0.3193,0.7000,0.5156,0.8835,0.7000,0.8835,0.8835,0.7000,0.8835,0.3193,0.7000,0.5156,0.3193,0.7000,0.8835,0.8835,0.7000,0.4199,0.8835,0.7000,0.4199,0.3193,0.7000,0.8835,0.3193,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_32()
		{
			double[] value = {0.4199,0.8835,0.7000,0.9290,0.8835,0.7000,0.9290,0.3193,0.7000,0.4199,0.3193,0.7000,0.9290,0.8835,0.7000,0.3193,0.8835,0.7000,0.3193,0.3193,0.7000,0.9290,0.3193,0.7000,0.3193,0.8835,0.7000,0.9635,0.8835,0.7000,0.9635,0.3193,0.7000,0.3193,0.3193,0.7000,0.9635,0.8835,0.7000,0.2150,0.8835,0.7000,0.2150,0.3193,0.7000,0.9635,0.3193,0.7000,0.2150,0.8835,0.7000,0.9868,0.8835,0.7000,0.9868,0.3193,0.7000,0.2150,0.3193,0.7000,0.9868,0.8835,0.7000,0.1081,0.8835,0.7000,0.1081,0.3193,0.7000,0.9868,0.3193,0.7000,0.1081,0.8835,0.7000,0.9985,0.8835,0.7000,0.9985,0.3193,0.7000,0.1081,0.3193,0.7000,0.9985,0.8835,0.7000,0.0000,0.8835,0.7000,0.0000,0.3193,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.9985,0.3193,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.9985,0.3193,0.7000,0.1081,0.3193,0.7000,0.1081,0.9868,0.7000,0.9985,0.9868,0.7000,0.1081,0.3193,0.7000,0.9868,0.3193,0.7000,0.9868,0.9868,0.7000,0.1081,0.9868,0.7000,0.9868,0.3193,0.7000,0.2150,0.3193,0.7000,0.2150,0.9868,0.7000,0.9868,0.9868,0.7000,0.2150,0.3193,0.7000,0.9635,0.3193,0.7000,0.9635,0.9868,0.7000,0.2150,0.9868,0.7000,0.9635,0.3193,0.7000,0.3193,0.3193,0.7000,0.3193,0.9868,0.7000,0.9635,0.9868,0.7000,0.3193,0.3193,0.7000,0.9290,0.3193,0.7000,0.9290,0.9868,0.7000,0.3193,0.9868,0.7000,0.9290,0.3193,0.7000,0.4199,0.3193,0.7000,0.4199,0.9868,0.7000,0.9290,0.9868,0.7000,0.4199,0.3193,0.7000,0.8835,0.3193,0.7000,0.8835,0.9868,0.7000,0.4199,0.9868,0.7000,0.8835,0.3193,0.7000,0.5156,0.3193,0.7000,0.5156,0.9868,0.7000,0.8835,0.9868,0.7000,0.5156,0.3193,0.7000,0.8277,0.3193,0.7000,0.8277,0.9868,0.7000,0.5156,0.9868,0.7000,0.8277,0.3193,0.7000,0.6052,0.3193,0.7000,0.6052,0.9868,0.7000,0.8277,0.9868,0.7000,0.6052,0.3193,0.7000,0.7622,0.3193,0.7000,0.7622,0.9868,0.7000,0.6052,0.9868,0.7000,0.7622,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.9868,0.7000,0.7622,0.9868,0.7000,0.6877,0.3193,0.7000,0.6877,0.3193,0.7000,0.6877,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.3193,0.7000,0.7622,0.3193,0.7000,0.7622,0.9868,0.7000,0.6877,0.9868,0.7000,0.7622,0.3193,0.7000,0.6052,0.3193,0.7000,0.6052,0.9868,0.7000,0.7622,0.9868,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_33()
		{
			double[] value = {0.6052,0.3193,0.7000,0.8277,0.3193,0.7000,0.8277,0.9868,0.7000,0.6052,0.9868,0.7000,0.8277,0.3193,0.7000,0.5156,0.3193,0.7000,0.5156,0.9868,0.7000,0.8277,0.9868,0.7000,0.5156,0.3193,0.7000,0.8835,0.3193,0.7000,0.8835,0.9868,0.7000,0.5156,0.9868,0.7000,0.8835,0.3193,0.7000,0.4199,0.3193,0.7000,0.4199,0.9868,0.7000,0.8835,0.9868,0.7000,0.4199,0.3193,0.7000,0.9290,0.3193,0.7000,0.9290,0.9868,0.7000,0.4199,0.9868,0.7000,0.9290,0.3193,0.7000,0.3193,0.3193,0.7000,0.3193,0.9868,0.7000,0.9290,0.9868,0.7000,0.3193,0.3193,0.7000,0.9635,0.3193,0.7000,0.9635,0.9868,0.7000,0.3193,0.9868,0.7000,0.9635,0.3193,0.7000,0.2150,0.3193,0.7000,0.2150,0.9868,0.7000,0.9635,0.9868,0.7000,0.2150,0.3193,0.7000,0.9868,0.3193,0.7000,0.9868,0.9868,0.7000,0.2150,0.9868,0.7000,0.9868,0.3193,0.7000,0.1081,0.3193,0.7000,0.1081,0.9868,0.7000,0.9868,0.9868,0.7000,0.1081,0.3193,0.7000,0.9985,0.3193,0.7000,0.9985,0.9868,0.7000,0.1081,0.9868,0.7000,0.9985,0.3193,0.7000,0.0000,0.3193,0.7000,0.0000,0.9868,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.9985,0.9868,0.7000,0.9985,0.0000,0.7000,0.0000,0.0000,0.7000,0.9985,0.9868,0.7000,0.1081,0.9868,0.7000,0.1081,0.0000,0.7000,0.9985,0.0000,0.7000,0.1081,0.9868,0.7000,0.9868,0.9868,0.7000,0.9868,0.0000,0.7000,0.1081,0.0000,0.7000,0.9868,0.9868,0.7000,0.2150,0.9868,0.7000,0.2150,0.0000,0.7000,0.9868,0.0000,0.7000,0.2150,0.9868,0.7000,0.9635,0.9868,0.7000,0.9635,0.0000,0.7000,0.2150,0.0000,0.7000,0.9635,0.9868,0.7000,0.3193,0.9868,0.7000,0.3193,0.0000,0.7000,0.9635,0.0000,0.7000,0.3193,0.9868,0.7000,0.9290,0.9868,0.7000,0.9290,0.0000,0.7000,0.3193,0.0000,0.7000,0.9290,0.9868,0.7000,0.4199,0.9868,0.7000,0.4199,0.0000,0.7000,0.9290,0.0000,0.7000,0.4199,0.9868,0.7000,0.8835,0.9868,0.7000,0.8835,0.0000,0.7000,0.4199,0.0000,0.7000,0.8835,0.9868,0.7000,0.5156,0.9868,0.7000,0.5156,0.0000,0.7000,0.8835,0.0000,0.7000,0.5156,0.9868,0.7000,0.8277,0.9868,0.7000,0.8277,0.0000,0.7000,0.5156,0.0000,0.7000,0.8277,0.9868,0.7000,0.6052,0.9868,0.7000,0.6052,0.0000,0.7000,0.8277,0.0000,0.7000,0.6052,0.9868,0.7000,0.7622,0.9868,0.7000,0.7622,0.0000,0.7000,0.6052,0.0000,0.7000};
			return value;
		}
		private double[] getColor_5_15_color_34()
		{
			double[] value = {0.7622,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.0000,0.7000,0.7622,0.0000,0.7000,0.6877,0.9868,0.7000,0.6877,0.9868,0.7000,0.6877,0.0000,0.7000,0.6877,0.0000,0.7000,0.6877,0.9868,0.7000,0.7622,0.9868,0.7000,0.7622,0.0000,0.7000,0.6877,0.0000,0.7000,0.7622,0.9868,0.7000,0.6052,0.9868,0.7000,0.6052,0.0000,0.7000,0.7622,0.0000,0.7000,0.6052,0.9868,0.7000,0.8277,0.9868,0.7000,0.8277,0.0000,0.7000,0.6052,0.0000,0.7000,0.8277,0.9868,0.7000,0.5156,0.9868,0.7000,0.5156,0.0000,0.7000,0.8277,0.0000,0.7000,0.5156,0.9868,0.7000,0.8835,0.9868,0.7000,0.8835,0.0000,0.7000,0.5156,0.0000,0.7000,0.8835,0.9868,0.7000,0.4199,0.9868,0.7000,0.4199,0.0000,0.7000,0.8835,0.0000,0.7000,0.4199,0.9868,0.7000,0.9290,0.9868,0.7000,0.9290,0.0000,0.7000,0.4199,0.0000,0.7000,0.9290,0.9868,0.7000,0.3193,0.9868,0.7000,0.3193,0.0000,0.7000,0.9290,0.0000,0.7000,0.3193,0.9868,0.7000,0.9635,0.9868,0.7000,0.9635,0.0000,0.7000,0.3193,0.0000,0.7000,0.9635,0.9868,0.7000,0.2150,0.9868,0.7000,0.2150,0.0000,0.7000,0.9635,0.0000,0.7000,0.2150,0.9868,0.7000,0.9868,0.9868,0.7000,0.9868,0.0000,0.7000,0.2150,0.0000,0.7000,0.9868,0.9868,0.7000,0.1081,0.9868,0.7000,0.1081,0.0000,0.7000,0.9868,0.0000,0.7000,0.1081,0.9868,0.7000,0.9985,0.9868,0.7000,0.9985,0.0000,0.7000,0.1081,0.0000,0.7000,0.9985,0.9868,0.7000,0.0000,0.9868,0.7000,0.0000,0.0000,0.7000,0.9985,0.0000,0.7000};
			return value;
		}

		/** Large attribute array: Coordinate point field, scene-graph level=5, element #13, 10092 total numbers made up of 3364 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_5_13_point()
		{
			MFVec3f Coordinate_5_13_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_5_13_point_1()))
				.append(new MFVec3f(getCoordinate_5_13_point_2()))
				.append(new MFVec3f(getCoordinate_5_13_point_3()))
				.append(new MFVec3f(getCoordinate_5_13_point_4()))
				.append(new MFVec3f(getCoordinate_5_13_point_5()))
				.append(new MFVec3f(getCoordinate_5_13_point_6()))
				.append(new MFVec3f(getCoordinate_5_13_point_7()))
				.append(new MFVec3f(getCoordinate_5_13_point_8()))
				.append(new MFVec3f(getCoordinate_5_13_point_9()))
				.append(new MFVec3f(getCoordinate_5_13_point_10()))
				.append(new MFVec3f(getCoordinate_5_13_point_11()))
				.append(new MFVec3f(getCoordinate_5_13_point_12()))
				.append(new MFVec3f(getCoordinate_5_13_point_13()))
				.append(new MFVec3f(getCoordinate_5_13_point_14()))
				.append(new MFVec3f(getCoordinate_5_13_point_15()))
				.append(new MFVec3f(getCoordinate_5_13_point_16()))
				.append(new MFVec3f(getCoordinate_5_13_point_17()))
				.append(new MFVec3f(getCoordinate_5_13_point_18()))
				.append(new MFVec3f(getCoordinate_5_13_point_19()))
				.append(new MFVec3f(getCoordinate_5_13_point_20()))
				.append(new MFVec3f(getCoordinate_5_13_point_21()))
				.append(new MFVec3f(getCoordinate_5_13_point_22()))
				.append(new MFVec3f(getCoordinate_5_13_point_23()))
				.append(new MFVec3f(getCoordinate_5_13_point_24()))
				.append(new MFVec3f(getCoordinate_5_13_point_25()))
				.append(new MFVec3f(getCoordinate_5_13_point_26()))
				.append(new MFVec3f(getCoordinate_5_13_point_27()))
				.append(new MFVec3f(getCoordinate_5_13_point_28()))
				.append(new MFVec3f(getCoordinate_5_13_point_29()))
				.append(new MFVec3f(getCoordinate_5_13_point_30()))
				.append(new MFVec3f(getCoordinate_5_13_point_31()))
				.append(new MFVec3f(getCoordinate_5_13_point_32()))
				.append(new MFVec3f(getCoordinate_5_13_point_33()))
				.append(new MFVec3f(getCoordinate_5_13_point_34()));
			return Coordinate_5_13_point;
		}
		/** Large attribute array: Normal vector field, scene-graph level=5, element #14, 10092 total numbers made up of 3364 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getNormal_5_14_vector()
		{
			MFVec3f Normal_5_14_vector = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getNormal_5_14_vector_1()))
				.append(new MFVec3f(getNormal_5_14_vector_2()))
				.append(new MFVec3f(getNormal_5_14_vector_3()))
				.append(new MFVec3f(getNormal_5_14_vector_4()))
				.append(new MFVec3f(getNormal_5_14_vector_5()))
				.append(new MFVec3f(getNormal_5_14_vector_6()))
				.append(new MFVec3f(getNormal_5_14_vector_7()))
				.append(new MFVec3f(getNormal_5_14_vector_8()))
				.append(new MFVec3f(getNormal_5_14_vector_9()))
				.append(new MFVec3f(getNormal_5_14_vector_10()))
				.append(new MFVec3f(getNormal_5_14_vector_11()))
				.append(new MFVec3f(getNormal_5_14_vector_12()))
				.append(new MFVec3f(getNormal_5_14_vector_13()))
				.append(new MFVec3f(getNormal_5_14_vector_14()))
				.append(new MFVec3f(getNormal_5_14_vector_15()))
				.append(new MFVec3f(getNormal_5_14_vector_16()))
				.append(new MFVec3f(getNormal_5_14_vector_17()))
				.append(new MFVec3f(getNormal_5_14_vector_18()))
				.append(new MFVec3f(getNormal_5_14_vector_19()))
				.append(new MFVec3f(getNormal_5_14_vector_20()))
				.append(new MFVec3f(getNormal_5_14_vector_21()))
				.append(new MFVec3f(getNormal_5_14_vector_22()))
				.append(new MFVec3f(getNormal_5_14_vector_23()))
				.append(new MFVec3f(getNormal_5_14_vector_24()))
				.append(new MFVec3f(getNormal_5_14_vector_25()))
				.append(new MFVec3f(getNormal_5_14_vector_26()))
				.append(new MFVec3f(getNormal_5_14_vector_27()))
				.append(new MFVec3f(getNormal_5_14_vector_28()))
				.append(new MFVec3f(getNormal_5_14_vector_29()))
				.append(new MFVec3f(getNormal_5_14_vector_30()))
				.append(new MFVec3f(getNormal_5_14_vector_31()))
				.append(new MFVec3f(getNormal_5_14_vector_32()))
				.append(new MFVec3f(getNormal_5_14_vector_33()))
				.append(new MFVec3f(getNormal_5_14_vector_34()));
			return Normal_5_14_vector;
		}
		/** Large attribute array: Color color field, scene-graph level=5, element #15, 10092 total numbers made up of 3364 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFColor getColor_5_15_color()
		{
			MFColor Color_5_15_color = new MFColor()/*2.finalize*/
				.append(new MFColor(getColor_5_15_color_1()))
				.append(new MFColor(getColor_5_15_color_2()))
				.append(new MFColor(getColor_5_15_color_3()))
				.append(new MFColor(getColor_5_15_color_4()))
				.append(new MFColor(getColor_5_15_color_5()))
				.append(new MFColor(getColor_5_15_color_6()))
				.append(new MFColor(getColor_5_15_color_7()))
				.append(new MFColor(getColor_5_15_color_8()))
				.append(new MFColor(getColor_5_15_color_9()))
				.append(new MFColor(getColor_5_15_color_10()))
				.append(new MFColor(getColor_5_15_color_11()))
				.append(new MFColor(getColor_5_15_color_12()))
				.append(new MFColor(getColor_5_15_color_13()))
				.append(new MFColor(getColor_5_15_color_14()))
				.append(new MFColor(getColor_5_15_color_15()))
				.append(new MFColor(getColor_5_15_color_16()))
				.append(new MFColor(getColor_5_15_color_17()))
				.append(new MFColor(getColor_5_15_color_18()))
				.append(new MFColor(getColor_5_15_color_19()))
				.append(new MFColor(getColor_5_15_color_20()))
				.append(new MFColor(getColor_5_15_color_21()))
				.append(new MFColor(getColor_5_15_color_22()))
				.append(new MFColor(getColor_5_15_color_23()))
				.append(new MFColor(getColor_5_15_color_24()))
				.append(new MFColor(getColor_5_15_color_25()))
				.append(new MFColor(getColor_5_15_color_26()))
				.append(new MFColor(getColor_5_15_color_27()))
				.append(new MFColor(getColor_5_15_color_28()))
				.append(new MFColor(getColor_5_15_color_29()))
				.append(new MFColor(getColor_5_15_color_30()))
				.append(new MFColor(getColor_5_15_color_31()))
				.append(new MFColor(getColor_5_15_color_32()))
				.append(new MFColor(getColor_5_15_color_33()))
				.append(new MFColor(getColor_5_15_color_34()));
			return Color_5_15_color;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return QuadSetColor model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new QuadSetColor().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.CAD.QuadSetColor\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.CAD.QuadSetColor self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // CAD/QuadSetColor_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "CAD/QuadSetColor_JavaExport.x3d"; 
                String filenameX3DV = "CAD/QuadSetColor_JavaExport.x3dv"; 
                String filenameJSON = "CAD/QuadSetColor_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
