####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python KeyFobWeb3d2013Spain.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='KeyFobWeb3d2013Spain.x3d',name='title'),
    meta(content='Model of a key chain fob with with WEB3D 2013 conference lettering, using the colors of the Spanish flag.',name='description'),
    meta(content='Vincent Marchetti',name='creator'),
    meta(content='6 May 2013',name='created'),
    meta(content='7 May 2013',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='KeyFobWeb3d2013Spain.png',name='Image'),
    meta(content='KeyFobWeb3d2013Closeup.jpg',name='photo'),
    meta(content='KeyFobWeb3d2013Compare.jpg',name='photo'),
    meta(content='Colored sandstone material is brittle and not suitable for daily use. Strong + Flexible white plastic is better material for 3D printing.',name='warning'),
    meta(content='http://www.shapeways.com/model/1127249/keyfobweb3d2013spain.html',name='reference'),
    meta(content='http://web3D2013.org',name='reference'),
    meta(content='KeyFobWeb3d2013BasqueCountry.x3d',name='reference'),
    meta(content='http://en.wikipedia.org/wiki/Keychain#Key_fob',name='reference'),
    meta(content='http://en.wikipedia.org/wiki/Spain',name='reference'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Ashlar-Vellum Argon (CAD) application',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/CAD/KeyFobWeb3d2013Spain.x3d',name='identifier'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='KeyFobWeb3d2013Spain.x3d'),
    Background(skyColor=[(0.858824,0.878431,0.858824)]),
    Viewpoint(description='WEB3D 2013 conference',fieldOfView=1.6628e-01,orientation=(0.890,-0.132,-0.435,0.657),position=(-6.1445e-02,-2.0256e-01,3.1679e-01)),
    #  The following transform converts the original coordinate space in inches (as prepared by the Ashlar-Vellum ARGON CAD application to meters 
    Transform(scale=(0.0254,0.0254,0.0254),
      children=[
      Shape(
        appearance=Appearance(DEF='charactersWebAppearance',
          material=Material(ambientIntensity=1.0,diffuseColor=(0.776,0.043,0.118),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.14408,0.06378,0.1),(-0.13208,0.06378,0.1),(-0.13208,0.06378,0),(-0.14408,0.06378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.13208,0.06378,0.1),(-0.13808,-0.01122,0.1),(-0.13808,-0.01122,0),(-0.13208,0.06378,0.0)]),
          normal=Normal(vector=[(0.99682,-0.07975,0),(0.99682,-0.07975,0),(0.99682,-0.07975,0),(0.99682,-0.07975,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.13808,-0.01122,0.1),(-0.34208,-0.01122,0.1),(-0.34208,-0.01122,0),(-0.13808,-0.01122,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.34208,-0.01122,0.1),(-0.34208,7.8E-4,0.1),(-0.34208,7.8E-4,0),(-0.34208,-0.01122,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.34208,7.8E-4,0.1),(-0.33608,7.8E-4,0.1),(-0.33008,7.8E-4,0.1),(-0.33008,7.8E-4,0),(-0.34208,7.8E-4,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.33008,7.8E-4,0.1),(-0.32688,8.4E-4,0.1),(-0.32524,9.6E-4,0.1),(-0.32363,0.00118,0.1),(-0.32207,0.00155,0.1),(-0.32132,0.00179,0.1),(-0.32061,0.00208,0.1),(-0.31992,0.00242,0.1),(-0.31926,0.00281,0.1),(-0.31865,0.00326,0.1),(-0.31808,0.00378,0.1),(-0.31808,0.00378,0),(-0.31865,0.00326,0),(-0.31926,0.00281,0),(-0.31992,0.00242,0),(-0.32061,0.00208,0),(-0.32132,0.00179,0),(-0.32207,0.00155,0),(-0.32363,0.00118,0),(-0.32524,9.6E-4,0),(-0.32688,8.4E-4,0),(-0.33008,7.8E-4,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.04898,0.9988,0),(-0.1029,0.99469,0),(-0.17892,0.98386,0),(-0.27976,0.96007,0),(-0.33996,0.94044,0),(-0.40641,0.91369,0),(-0.47828,0.87821,0),(-0.55403,0.8325,0),(-0.63131,0.77553,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.63131,0.77553,0),(-0.55403,0.8325,0),(-0.47828,0.87821,0),(-0.40641,0.91369,0),(-0.33996,0.94044,0),(-0.27976,0.96007,0),(-0.17892,0.98386,0),(-0.1029,0.99469,0),(-0.04898,0.9988,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,5,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1],solid=False,
          coord=Coordinate(point=[(-0.31808,0.00378,0.1),(-0.31333,0.00643,0.1),(-0.31111,0.00799,0.1),(-0.30908,0.00978,0.1),(-0.30908,0.00978,0),(-0.31111,0.00799,0),(-0.31333,0.00643,0),(-0.31808,0.00378,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,0),(-0.53972,0.84184,0),(-0.61587,0.78785,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.61587,0.78785,0),(-0.53972,0.84184,0),(-0.44721,0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[21,0,20,-1,20,0,1,-1,19,1,2,-1,3,19,2,-1,3,18,19,-1,3,4,18,-1,18,4,17,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,1,19,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.30908,0.00978,0.1),(-0.30857,0.01035,0.1),(-0.30811,0.01096,0.1),(-0.30772,0.01161,0.1),(-0.30738,0.0123,0.1),(-0.30709,0.01302,0.1),(-0.30685,0.01377,0.1),(-0.30649,0.01532,0.1),(-0.30626,0.01694,0.1),(-0.30614,0.01857,0.1),(-0.30608,0.02178,0.1),(-0.30608,0.02178,0),(-0.30614,0.01857,0),(-0.30626,0.01694,0),(-0.30649,0.01532,0),(-0.30685,0.01377,0),(-0.30709,0.01302,0),(-0.30738,0.0123,0),(-0.30772,0.01161,0),(-0.30811,0.01096,0),(-0.30857,0.01035,0),(-0.30908,0.00978,0.0)]),
          normal=Normal(vector=[(-0.7071,0.70711,0),(-0.77553,0.63132,0),(-0.8325,0.55403,0),(-0.87821,0.47828,0),(-0.91369,0.40641,0),(-0.94044,0.33996,0),(-0.96007,0.27976,0),(-0.98386,0.17892,0),(-0.99469,0.1029,0),(-0.9988,0.04898,0),(-1.0,0,0),(-1.0,0,0),(-0.9988,0.04898,0),(-0.99469,0.1029,0),(-0.98386,0.17892,0),(-0.96007,0.27976,0),(-0.94044,0.33996,0),(-0.91369,0.40641,0),(-0.87821,0.47828,0),(-0.8325,0.55403,0),(-0.77553,0.63132,0),(-0.7071,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.30608,0.02178,0.1),(-0.30608,0.20178,0.1),(-0.30608,0.20178,0),(-0.30608,0.02178,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.30608,0.20178,0.1),(-0.30612,0.20298,0.1),(-0.30623,0.2042,0.1),(-0.30644,0.20543,0.1),(-0.30674,0.20662,0.1),(-0.30715,0.20778,0.1),(-0.30767,0.20887,0.1),(-0.30831,0.20988,0.1),(-0.30908,0.21078,0.1),(-0.30908,0.21078,0),(-0.30831,0.20988,0),(-0.30767,0.20887,0),(-0.30715,0.20778,0),(-0.30674,0.20662,0),(-0.30644,0.20543,0),(-0.30623,0.2042,0),(-0.30612,0.20298,0),(-0.30608,0.20178,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99807,-0.06217,0),(-0.99161,-0.12929,0),(-0.9791,-0.20336,0),(-0.95817,-0.28619,0),(-0.92537,-0.37907,0),(-0.87609,-0.48215,0),(-0.80495,-0.59334,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.80495,-0.59334,0),(-0.87609,-0.48215,0),(-0.92537,-0.37907,0),(-0.95817,-0.28619,0),(-0.9791,-0.20336,0),(-0.99161,-0.12929,0),(-0.99807,-0.06217,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[23,0,22,-1,22,0,1,-1,2,22,1,-1,2,21,22,-1,2,3,21,-1,21,3,20,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(-0.30908,0.21078,0.1),(-0.30978,0.21196,0.1),(-0.3102,0.21253,0.1),(-0.31066,0.21308,0.1),(-0.31169,0.21409,0.1),(-0.31283,0.21499,0.1),(-0.31344,0.21538,0.1),(-0.31407,0.21573,0.1),(-0.31472,0.21604,0.1),(-0.31538,0.21629,0.1),(-0.31672,0.21665,0.1),(-0.31808,0.21678,0.1),(-0.31808,0.21678,0),(-0.31672,0.21665,0),(-0.31538,0.21629,0),(-0.31472,0.21604,0),(-0.31407,0.21573,0),(-0.31344,0.21538,0),(-0.31283,0.21499,0),(-0.31169,0.21409,0),(-0.31066,0.21308,0),(-0.3102,0.21253,0),(-0.30978,0.21196,0),(-0.30908,0.21078,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.82362,-0.56714,0),(-0.78549,-0.61888,0),(-0.74571,-0.66628,0),(-0.66063,-0.75071,0),(-0.56598,-0.82442,0),(-0.51385,-0.85788,0),(-0.45769,-0.88911,0),(-0.39682,-0.9179,0),(-0.33052,-0.9438,0),(-0.17903,-0.98384,0),(0,-1.0,0),(0,-1.0,0),(-0.17903,-0.98384,0),(-0.33052,-0.9438,0),(-0.39682,-0.9179,0),(-0.45769,-0.88911,0),(-0.51385,-0.85788,0),(-0.56598,-0.82442,0),(-0.66063,-0.75071,0),(-0.74571,-0.66628,0),(-0.78549,-0.61888,0),(-0.82362,-0.56714,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-0.31808,0.21678,0.1),(-0.31933,0.21789,0.1),(-0.32069,0.21885,0.1),(-0.32215,0.21969,0.1),(-0.32367,0.22043,0.1),(-0.33008,0.22278,0.1),(-0.33008,0.22278,0),(-0.32367,0.22043,0),(-0.32215,0.21969,0),(-0.32069,0.21885,0),(-0.31933,0.21789,0),(-0.31808,0.21678,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.61927,-0.78518,0),(-0.53747,-0.84328,0),(-0.46637,-0.88459,0),(-0.40834,-0.91283,0),(-0.31623,-0.94868,0),(-0.31623,-0.94868,0),(-0.40834,-0.91283,0),(-0.46637,-0.88459,0),(-0.53747,-0.84328,0),(-0.61927,-0.78518,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,15,-1,16,17,5,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,5,6,15,-1,15,6,14,-1,14,6,7,-1,13,7,8,-1,12,8,9,-1,11,9,10,-1,11,12,9,-1,14,7,13,-1,13,8,12,-1],solid=False,
          coord=Coordinate(point=[(-0.33008,0.22278,0.1),(-0.33328,0.22284,0.1),(-0.33492,0.22296,0.1),(-0.33653,0.22318,0.1),(-0.33809,0.22355,0.1),(-0.33884,0.22379,0.1),(-0.33955,0.22408,0.1),(-0.34024,0.22442,0.1),(-0.3409,0.22481,0.1),(-0.34151,0.22526,0.1),(-0.34208,0.22578,0.1),(-0.34208,0.22578,0),(-0.34151,0.22526,0),(-0.3409,0.22481,0),(-0.34024,0.22442,0),(-0.33955,0.22408,0),(-0.33884,0.22379,0),(-0.33809,0.22355,0),(-0.33653,0.22318,0),(-0.33492,0.22296,0),(-0.33328,0.22284,0),(-0.33008,0.22278,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.04898,-0.9988,0),(-0.1029,-0.99469,0),(-0.17892,-0.98386,0),(-0.27976,-0.96007,0),(-0.33996,-0.94044,0),(-0.40641,-0.91369,0),(-0.47828,-0.87821,0),(-0.55403,-0.8325,0),(-0.63131,-0.77553,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.63131,-0.77553,0),(-0.55403,-0.8325,0),(-0.47828,-0.87821,0),(-0.40641,-0.91369,0),(-0.33996,-0.94044,0),(-0.27976,-0.96007,0),(-0.17892,-0.98386,0),(-0.1029,-0.99469,0),(-0.04898,-0.9988,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.34208,0.22578,0.1),(-0.34208,0.23778,0.1),(-0.34208,0.23778,0),(-0.34208,0.22578,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.34208,0.23778,0.1),(-0.15008,0.23778,0.1),(-0.15008,0.23778,0),(-0.34208,0.23778,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.15008,0.23778,0.1),(-0.15008,0.17778,0.1),(-0.15008,0.17778,0),(-0.15008,0.23778,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.15008,0.17778,0.1),(-0.16208,0.17778,0.1),(-0.16208,0.17778,0),(-0.15008,0.17778,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1,6,1,5,-1],solid=False,
          coord=Coordinate(point=[(-0.16208,0.17778,0.1),(-0.16598,0.18489,0.1),(-0.17036,0.19174,0.1),(-0.18008,0.20478,0.1),(-0.18008,0.20478,0),(-0.17036,0.19174,0),(-0.16598,0.18489,0),(-0.16208,0.17778,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.85889,-0.51216,0),(-0.82684,-0.56243,0),(-0.78087,-0.6247,0),(-0.78087,-0.6247,0),(-0.82684,-0.56243,0),(-0.85889,-0.51216,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,15,-1,16,17,5,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,5,6,15,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,11,-1,12,13,9,-1,15,7,14,-1,14,8,13,-1,9,10,11,-1],solid=False,
          coord=Coordinate(point=[(-0.18008,0.20478,0.1),(-0.18442,0.20995,0.1),(-0.18682,0.21248,0.1),(-0.18937,0.2148,0.1),(-0.19207,0.2168,0.1),(-0.19348,0.21765,0.1),(-0.19493,0.21838,0.1),(-0.19641,0.21897,0.1),(-0.19793,0.21941,0.1),(-0.19949,0.21968,0.1),(-0.20108,0.21978,0.1),(-0.20108,0.21978,0),(-0.19949,0.21968,0),(-0.19793,0.21941,0),(-0.19641,0.21897,0),(-0.19493,0.21838,0),(-0.19348,0.21765,0),(-0.19207,0.2168,0),(-0.18937,0.2148,0),(-0.18682,0.21248,0),(-0.18442,0.20995,0),(-0.18008,0.20478,0.0)]),
          normal=Normal(vector=[(-0.78087,-0.62469,0),(-0.74338,-0.66886,0),(-0.70197,-0.7122,0),(-0.63904,-0.76917,0),(-0.54592,-0.83784,0),(-0.48458,-0.87475,0),(-0.41153,-0.9114,0),(-0.32583,-0.94543,0),(-0.22745,-0.97379,0),(-0.11778,-0.99304,0),(0,-1.0,0),(0,-1.0,0),(-0.11778,-0.99304,0),(-0.22745,-0.97379,0),(-0.32583,-0.94543,0),(-0.41153,-0.9114,0),(-0.48458,-0.87475,0),(-0.54592,-0.83784,0),(-0.63904,-0.76917,0),(-0.70197,-0.7122,0),(-0.74338,-0.66886,0),(-0.78087,-0.62469,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.20108,0.21978,0.1),(-0.20708,0.21978,0.1),(-0.21308,0.21978,0.1),(-0.21308,0.21978,0),(-0.20108,0.21978,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.21308,0.21978,0.1),(-0.21747,0.22106,0.1),(-0.22196,0.222,0.1),(-0.22651,0.22258,0.1),(-0.23108,0.22278,0.1),(-0.23108,0.22278,0),(-0.22651,0.22258,0),(-0.22196,0.222,0),(-0.21747,0.22106,0),(-0.21308,0.21978,0.0)]),
          normal=Normal(vector=[(-0.31623,-0.94868,0),(-0.24298,-0.97003,0),(-0.16647,-0.98605,0),(-0.08575,-0.99632,0),(0,-1.0,0),(0,-1.0,0),(-0.08575,-0.99632,0),(-0.16647,-0.98605,0),(-0.24298,-0.97003,0),(-0.31623,-0.94868,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.23108,0.22278,0.1),(-0.27008,0.22278,0.1),(-0.27008,0.22278,0),(-0.23108,0.22278,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.27008,0.22278,0.1),(-0.27008,0.12378,0.1),(-0.27008,0.12378,0),(-0.27008,0.22278,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.27008,0.12378,0.1),(-0.24308,0.12378,0.1),(-0.24308,0.12378,0),(-0.27008,0.12378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.24308,0.12378,0.1),(-0.23408,0.12378,0.1),(-0.22508,0.12378,0.1),(-0.22508,0.12378,0),(-0.24308,0.12378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.22508,0.12378,0.1),(-0.22329,0.12443,0.1),(-0.22152,0.12522,0.1),(-0.21979,0.12614,0.1),(-0.21814,0.12719,0.1),(-0.21661,0.12838,0.1),(-0.21523,0.12971,0.1),(-0.21461,0.13042,0.1),(-0.21404,0.13117,0.1),(-0.21353,0.13196,0.1),(-0.21308,0.13278,0.1),(-0.21308,0.13278,0),(-0.21353,0.13196,0),(-0.21404,0.13117,0),(-0.21461,0.13042,0),(-0.21523,0.12971,0),(-0.21661,0.12838,0),(-0.21814,0.12719,0),(-0.21979,0.12614,0),(-0.22152,0.12522,0),(-0.22329,0.12443,0),(-0.22508,0.12378,0.0)]),
          normal=Normal(vector=[(-0.31623,0.94868,0),(-0.37459,0.92719,0),(-0.43622,0.89984,0),(-0.50255,0.86455,0),(-0.57451,0.8185,0),(-0.65224,0.75801,0),(-0.73445,0.67867,0),(-0.77619,0.6305,0),(-0.81744,0.57601,0),(-0.85723,0.51493,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.85723,0.51493,0),(-0.81744,0.57601,0),(-0.77619,0.6305,0),(-0.73445,0.67867,0),(-0.65224,0.75801,0),(-0.57451,0.8185,0),(-0.50255,0.86455,0),(-0.43622,0.89984,0),(-0.37459,0.92719,0),(-0.31623,0.94868,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.21308,0.13278,0.1),(-0.20982,0.14017,0.1),(-0.20708,0.14778,0.1),(-0.20708,0.14778,0),(-0.20982,0.14017,0),(-0.21308,0.13278,0.0)]),
          normal=Normal(vector=[(-0.89443,0.44721,0),(-0.93071,0.36575,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.93071,0.36575,0),(-0.89443,0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.20708,0.14778,0.1),(-0.20408,0.15678,0.1),(-0.20108,0.16578,0.1),(-0.20108,0.16578,0),(-0.20408,0.15678,0),(-0.20708,0.14778,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.20108,0.16578,0.1),(-0.18908,0.16578,0.1),(-0.18908,0.16578,0),(-0.20108,0.16578,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.18908,0.16578,0.1),(-0.18908,0.06678,0.1),(-0.18908,0.06678,0),(-0.18908,0.16578,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.18908,0.06678,0.1),(-0.20108,0.06678,0.1),(-0.20108,0.06678,0),(-0.18908,0.06678,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.20108,0.06678,0.1),(-0.20434,0.07417,0.1),(-0.20708,0.08178,0.1),(-0.20708,0.08178,0),(-0.20434,0.07417,0),(-0.20108,0.06678,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.93072,-0.36575,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.93072,-0.36575,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.20708,0.08178,0.1),(-0.20982,0.08939,0.1),(-0.21308,0.09678,0.1),(-0.21308,0.09678,0),(-0.20982,0.08939,0),(-0.20708,0.08178,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.93072,-0.36575,0),(-0.89443,-0.44721,0),(-0.89443,-0.44721,0),(-0.93072,-0.36575,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.21308,0.09678,0.1),(-0.21582,0.09936,0.1),(-0.21873,0.10176,0.1),(-0.22182,0.10392,0.1),(-0.22508,0.10578,0.1),(-0.22508,0.10578,0),(-0.22182,0.10392,0),(-0.21873,0.10176,0),(-0.21582,0.09936,0),(-0.21308,0.09678,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.66349,-0.74818,0),(-0.60742,-0.79438,0),(-0.5362,-0.84409,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.5362,-0.84409,0),(-0.60742,-0.79438,0),(-0.66349,-0.74818,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,10,-1,11,12,2,-1,2,3,10,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.22508,0.10578,0.1),(-0.22717,0.10669,0.1),(-0.22933,0.10739,0.1),(-0.23156,0.10792,0.1),(-0.23384,0.1083,0.1),(-0.23847,0.10869,0.1),(-0.24308,0.10878,0.1),(-0.24308,0.10878,0),(-0.23847,0.10869,0),(-0.23384,0.1083,0),(-0.23156,0.10792,0),(-0.22933,0.10739,0),(-0.22717,0.10669,0),(-0.22508,0.10578,0.0)]),
          normal=Normal(vector=[(-0.44721,-0.89443,0),(-0.35328,-0.93552,0),(-0.26836,-0.96332,0),(-0.19461,-0.98088,0),(-0.13281,-0.99114,0),(-0.04437,-0.99902,0),(0,-1.0,0),(0,-1.0,0),(-0.04437,-0.99902,0),(-0.13281,-0.99114,0),(-0.19461,-0.98088,0),(-0.26836,-0.96332,0),(-0.35328,-0.93552,0),(-0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.24308,0.10878,0.1),(-0.27008,0.10878,0.1),(-0.27008,0.10878,0),(-0.24308,0.10878,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.27008,0.10878,0.1),(-0.27008,0.03378,0.1),(-0.27008,0.03378,0),(-0.27008,0.10878,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.27008,0.03378,0.1),(-0.27008,0.02478,0.1),(-0.27008,0.01578,0.1),(-0.27008,0.01578,0),(-0.27008,0.03378,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(1.0,0,-0.0),(1.0,0,0),(1.0,0,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.27008,0.01578,0.1),(-0.26743,0.01102,0.1),(-0.26587,0.00881,0.1),(-0.26408,0.00678,0.1),(-0.26408,0.00678,0),(-0.26587,0.00881,0),(-0.26743,0.01102,0),(-0.27008,0.01578,0.0)]),
          normal=Normal(vector=[(0.89443,0.44721,-0.0),(0.84184,0.53972,-0.0),(0.78785,0.61587,-0.0),(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0),(0.78785,0.61587,-0.0),(0.84184,0.53972,-0.0),(0.89443,0.44721,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-0.26408,0.00678,0.1),(-0.26123,0.00553,0.1),(-0.25824,0.00459,0.1),(-0.25518,0.00399,0.1),(-0.25363,0.00383,0.1),(-0.25208,0.00378,0.1),(-0.25208,0.00378,0),(-0.25363,0.00383,0),(-0.25518,0.00399,0),(-0.25824,0.00459,0),(-0.26123,0.00553,0),(-0.26408,0.00678,0.0)]),
          normal=Normal(vector=[(0.44721,0.89443,-0.0),(0.35262,0.93577,-0.0),(0.24866,0.96859,-0.0),(0.13201,0.99125,-0.0),(0.06804,0.99768,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0.06804,0.99768,-0.0),(0.13201,0.99125,-0.0),(0.24866,0.96859,-0.0),(0.35262,0.93577,-0.0),(0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.25208,0.00378,0.1),(-0.24008,0.00378,0.1),(-0.22808,0.00378,0.1),(-0.22808,0.00378,0),(-0.25208,0.00378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.22808,0.00378,0.1),(-0.22058,0.00378,0.1),(-0.21308,0.00378,0.1),(-0.21308,0.00378,0),(-0.22808,0.00378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.21308,0.00378,0.1),(-0.20558,0.00378,0.1),(-0.19808,0.00378,0.1),(-0.19808,0.00378,0),(-0.21308,0.00378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.19808,0.00378,0.1),(-0.19427,0.00402,0.1),(-0.19048,0.00467,0.1),(-0.18308,0.00678,0.1),(-0.18308,0.00678,0),(-0.19048,0.00467,0),(-0.19427,0.00402,0),(-0.19808,0.00378,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.12161,0.99258,0),(-0.21363,0.97691,0),(-0.31623,0.94868,0),(-0.31623,0.94868,0),(-0.21363,0.97691,0),(-0.12161,0.99258,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,11,-1,12,13,5,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,5,6,11,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.18308,0.00678,0.1),(-0.18188,0.00681,0.1),(-0.18065,0.00693,0.1),(-0.17943,0.00714,0.1),(-0.17823,0.00744,0.1),(-0.17708,0.00785,0.1),(-0.17599,0.00837,0.1),(-0.17498,0.00901,0.1),(-0.17408,0.00978,0.1),(-0.17408,0.00978,0),(-0.17498,0.00901,0),(-0.17599,0.00837,0),(-0.17708,0.00785,0),(-0.17823,0.00744,0),(-0.17943,0.00714,0),(-0.18065,0.00693,0),(-0.18188,0.00681,0),(-0.18308,0.00678,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.06216,0.99807,0),(-0.12928,0.99161,0),(-0.20336,0.9791,0),(-0.28619,0.95817,0),(-0.37907,0.92537,0),(-0.48214,0.87609,0),(-0.59334,0.80495,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.59334,0.80495,0),(-0.48214,0.87609,0),(-0.37907,0.92537,0),(-0.28619,0.95817,0),(-0.20336,0.9791,0),(-0.12928,0.99161,0),(-0.06216,0.99807,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.17408,0.00978,0.1),(-0.16872,0.01586,0.1),(-0.16403,0.02252,0.1),(-0.15608,0.03678,0.1),(-0.15608,0.03678,0),(-0.16403,0.02252,0),(-0.16872,0.01586,0),(-0.17408,0.00978,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.78785,0.61587,0),(-0.84184,0.53972,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.84184,0.53972,0),(-0.78785,0.61587,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.15608,0.03678,0.1),(-0.1496,0.05008,0.1),(-0.14408,0.06378,0.1),(-0.14408,0.06378,0),(-0.1496,0.05008,0),(-0.15608,0.03678,0.0)]),
          normal=Normal(vector=[(-0.89443,0.44721,0),(-0.90858,0.41772,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.90858,0.41772,0),(-0.89443,0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,156,-1,156,2,3,-1,4,156,3,-1,4,5,156,-1,156,5,6,-1,7,156,6,-1,7,8,156,-1,156,8,9,-1,10,156,9,-1,10,11,156,-1,156,11,12,-1,15,12,13,-1,14,15,13,-1,156,12,15,-1,16,156,15,-1,16,17,156,-1,156,17,18,-1,19,156,18,-1,19,20,156,-1,156,20,21,-1,22,156,21,-1,22,155,156,-1,22,23,155,-1,155,23,24,-1,25,155,24,-1,25,26,155,-1,155,26,27,-1,146,27,145,-1,146,155,27,-1,146,147,155,-1,155,147,148,-1,149,155,148,-1,149,150,155,-1,155,150,151,-1,152,155,151,-1,152,153,155,-1,155,153,154,-1,27,28,145,-1,145,28,144,-1,144,28,141,-1,143,141,142,-1,143,144,141,-1,29,139,28,-1,29,138,139,-1,29,30,138,-1,138,30,137,-1,137,30,136,-1,136,30,135,-1,135,30,31,-1,134,31,133,-1,134,135,31,-1,32,129,31,-1,32,33,129,-1,129,33,34,-1,128,34,69,-1,70,128,69,-1,70,127,128,-1,70,126,127,-1,70,125,126,-1,70,124,125,-1,70,123,124,-1,70,122,123,-1,70,121,122,-1,70,119,121,-1,70,118,119,-1,70,117,118,-1,70,116,117,-1,70,115,116,-1,70,114,115,-1,70,113,114,-1,70,112,113,-1,70,107,112,-1,70,106,107,-1,70,93,106,-1,70,71,93,-1,93,71,92,-1,92,71,72,-1,73,92,72,-1,73,74,92,-1,92,74,77,-1,78,92,77,-1,78,79,92,-1,92,79,80,-1,81,92,80,-1,81,82,92,-1,92,82,83,-1,84,92,83,-1,84,85,92,-1,92,85,86,-1,87,92,86,-1,87,88,92,-1,92,88,91,-1,91,88,89,-1,90,91,89,-1,34,35,69,-1,69,35,68,-1,68,35,36,-1,67,36,37,-1,38,67,37,-1,38,66,67,-1,38,39,66,-1,66,39,40,-1,41,66,40,-1,41,65,66,-1,41,42,65,-1,65,42,64,-1,64,42,63,-1,63,42,43,-1,62,43,61,-1,62,63,43,-1,68,36,67,-1,43,44,61,-1,61,44,60,-1,60,44,45,-1,59,45,58,-1,59,60,45,-1,46,56,45,-1,46,55,56,-1,46,50,55,-1,46,47,50,-1,50,47,48,-1,49,50,48,-1,50,51,55,-1,55,51,54,-1,54,51,53,-1,53,51,52,-1,56,57,45,-1,45,57,58,-1,75,76,74,-1,74,76,77,-1,94,95,93,-1,93,95,96,-1,97,93,96,-1,97,98,93,-1,93,98,99,-1,100,93,99,-1,100,101,93,-1,93,101,102,-1,103,93,102,-1,103,104,93,-1,93,104,105,-1,106,93,105,-1,108,110,107,-1,108,109,110,-1,110,111,107,-1,107,111,112,-1,119,120,121,-1,128,129,34,-1,129,130,31,-1,31,130,131,-1,132,31,131,-1,132,133,31,-1,139,140,28,-1,28,140,141,-1],solid=False,
          coord=Coordinate(point=[(-0.13208,0.06378,0.1),(-0.14408,0.06378,0.1),(-0.1496,0.05008,0.1),(-0.15608,0.03678,0.1),(-0.16403,0.02252,0.1),(-0.16872,0.01586,0.1),(-0.17408,0.00978,0.1),(-0.17498,0.00901,0.1),(-0.17599,0.00837,0.1),(-0.17708,0.00785,0.1),(-0.17823,0.00744,0.1),(-0.17943,0.00714,0.1),(-0.18065,0.00693,0.1),(-0.18188,0.00681,0.1),(-0.18308,0.00678,0.1),(-0.19048,0.00467,0.1),(-0.19427,0.00402,0.1),(-0.19808,0.00378,0.1),(-0.20558,0.00378,0.1),(-0.21308,0.00378,0.1),(-0.22058,0.00378,0.1),(-0.22808,0.00378,0.1),(-0.24008,0.00378,0.1),(-0.25208,0.00378,0.1),(-0.25363,0.00383,0.1),(-0.25518,0.00399,0.1),(-0.25824,0.00459,0.1),(-0.26123,0.00553,0.1),(-0.26408,0.00678,0.1),(-0.26587,0.00881,0.1),(-0.26743,0.01102,0.1),(-0.27008,0.01578,0.1),(-0.27008,0.02478,0.1),(-0.27008,0.03378,0.1),(-0.27008,0.10878,0.1),(-0.24308,0.10878,0.1),(-0.23847,0.10869,0.1),(-0.23384,0.1083,0.1),(-0.23156,0.10792,0.1),(-0.22933,0.10739,0.1),(-0.22717,0.10669,0.1),(-0.22508,0.10578,0.1),(-0.22182,0.10392,0.1),(-0.21873,0.10176,0.1),(-0.21582,0.09936,0.1),(-0.21308,0.09678,0.1),(-0.20982,0.08939,0.1),(-0.20708,0.08178,0.1),(-0.20434,0.07417,0.1),(-0.20108,0.06678,0.1),(-0.18908,0.06678,0.1),(-0.18908,0.16578,0.1),(-0.20108,0.16578,0.1),(-0.20408,0.15678,0.1),(-0.20708,0.14778,0.1),(-0.20982,0.14017,0.1),(-0.21308,0.13278,0.1),(-0.21353,0.13196,0.1),(-0.21404,0.13117,0.1),(-0.21461,0.13042,0.1),(-0.21523,0.12971,0.1),(-0.21661,0.12838,0.1),(-0.21814,0.12719,0.1),(-0.21979,0.12614,0.1),(-0.22152,0.12522,0.1),(-0.22329,0.12443,0.1),(-0.22508,0.12378,0.1),(-0.23408,0.12378,0.1),(-0.24308,0.12378,0.1),(-0.27008,0.12378,0.1),(-0.27008,0.22278,0.1),(-0.23108,0.22278,0.1),(-0.22651,0.22258,0.1),(-0.22196,0.222,0.1),(-0.21747,0.22106,0.1),(-0.21308,0.21978,0.1),(-0.20708,0.21978,0.1),(-0.20108,0.21978,0.1),(-0.19949,0.21968,0.1),(-0.19793,0.21941,0.1),(-0.19641,0.21897,0.1),(-0.19493,0.21838,0.1),(-0.19348,0.21765,0.1),(-0.19207,0.2168,0.1),(-0.18937,0.2148,0.1),(-0.18682,0.21248,0.1),(-0.18442,0.20995,0.1),(-0.18008,0.20478,0.1),(-0.17036,0.19174,0.1),(-0.16598,0.18489,0.1),(-0.16208,0.17778,0.1),(-0.15008,0.17778,0.1),(-0.15008,0.23778,0.1),(-0.34208,0.23778,0.1),(-0.34208,0.22578,0.1),(-0.34151,0.22526,0.1),(-0.3409,0.22481,0.1),(-0.34024,0.22442,0.1),(-0.33955,0.22408,0.1),(-0.33884,0.22379,0.1),(-0.33809,0.22355,0.1),(-0.33653,0.22318,0.1),(-0.33492,0.22296,0.1),(-0.33328,0.22284,0.1),(-0.33008,0.22278,0.1),(-0.32367,0.22043,0.1),(-0.32215,0.21969,0.1),(-0.32069,0.21885,0.1),(-0.31933,0.21789,0.1),(-0.31808,0.21678,0.1),(-0.31672,0.21665,0.1),(-0.31538,0.21629,0.1),(-0.31472,0.21604,0.1),(-0.31407,0.21573,0.1),(-0.31344,0.21538,0.1),(-0.31283,0.21499,0.1),(-0.31169,0.21409,0.1),(-0.31066,0.21308,0.1),(-0.3102,0.21253,0.1),(-0.30978,0.21196,0.1),(-0.30908,0.21078,0.1),(-0.30831,0.20988,0.1),(-0.30767,0.20887,0.1),(-0.30715,0.20778,0.1),(-0.30674,0.20662,0.1),(-0.30644,0.20543,0.1),(-0.30623,0.2042,0.1),(-0.30612,0.20298,0.1),(-0.30608,0.20178,0.1),(-0.30608,0.02178,0.1),(-0.30614,0.01857,0.1),(-0.30626,0.01694,0.1),(-0.30649,0.01532,0.1),(-0.30685,0.01377,0.1),(-0.30709,0.01302,0.1),(-0.30738,0.0123,0.1),(-0.30772,0.01161,0.1),(-0.30811,0.01096,0.1),(-0.30857,0.01035,0.1),(-0.30908,0.00978,0.1),(-0.31111,0.00799,0.1),(-0.31333,0.00643,0.1),(-0.31808,0.00378,0.1),(-0.31865,0.00326,0.1),(-0.31926,0.00281,0.1),(-0.31992,0.00242,0.1),(-0.32061,0.00208,0.1),(-0.32132,0.00179,0.1),(-0.32207,0.00155,0.1),(-0.32363,0.00118,0.1),(-0.32524,9.6E-4,0.1),(-0.32688,8.4E-4,0.1),(-0.33008,7.8E-4,0.1),(-0.33608,7.8E-4,0.1),(-0.34208,7.8E-4,0.1),(-0.34208,-0.01122,0.1),(-0.13808,-0.01122,0.1)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.35108,0.23778,0.1),(-0.35108,0.22578,0.1),(-0.35108,0.22578,0),(-0.35108,0.23778,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,6,-1,7,8,4,-1,10,2,9,-1,9,3,8,-1,4,5,6,-1],solid=False,
          coord=Coordinate(point=[(-0.35108,0.22578,0.1),(-0.35393,0.22453,0.1),(-0.35692,0.22359,0.1),(-0.35998,0.22299,0.1),(-0.36153,0.22283,0.1),(-0.36308,0.22278,0.1),(-0.36308,0.22278,0),(-0.36153,0.22283,0),(-0.35998,0.22299,0),(-0.35692,0.22359,0),(-0.35393,0.22453,0),(-0.35108,0.22578,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.35262,-0.93577,0),(0.24866,-0.96859,0),(0.13201,-0.99125,0),(0.06804,-0.99768,0),(0,-1.0,0),(0,-1.0,0),(0.06804,-0.99768,0),(0.13201,-0.99125,0),(0.24866,-0.96859,0),(0.35262,-0.93577,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,5,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1],solid=False,
          coord=Coordinate(point=[(-0.36308,0.22278,0.1),(-0.36783,0.22013,0.1),(-0.37005,0.21856,0.1),(-0.37208,0.21678,0.1),(-0.37208,0.21678,0),(-0.37005,0.21856,0),(-0.36783,0.22013,0),(-0.36308,0.22278,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.53972,-0.84184,0),(0.61587,-0.78785,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.61587,-0.78785,0),(0.53972,-0.84184,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,11,-1,12,13,9,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,9,10,11,-1],solid=False,
          coord=Coordinate(point=[(-0.37208,0.21678,0.1),(-0.37387,0.21612,0.1),(-0.37564,0.21533,0.1),(-0.37737,0.21441,0.1),(-0.37902,0.21336,0.1),(-0.38055,0.21217,0.1),(-0.38193,0.21085,0.1),(-0.38255,0.21013,0.1),(-0.38312,0.20938,0.1),(-0.38363,0.2086,0.1),(-0.38408,0.20778,0.1),(-0.38408,0.20778,0),(-0.38363,0.2086,0),(-0.38312,0.20938,0),(-0.38255,0.21013,0),(-0.38193,0.21085,0),(-0.38055,0.21217,0),(-0.37902,0.21336,0),(-0.37737,0.21441,0),(-0.37564,0.21533,0),(-0.37387,0.21612,0),(-0.37208,0.21678,0.0)]),
          normal=Normal(vector=[(0.31623,-0.94868,0),(0.37459,-0.92719,0),(0.43622,-0.89984,0),(0.50255,-0.86455,0),(0.57451,-0.8185,0),(0.65224,-0.75801,0),(0.73445,-0.67867,0),(0.77619,-0.6305,0),(0.81744,-0.57601,0),(0.85724,-0.51492,0),(0.89443,-0.44721,0),(0.89443,-0.44721,0),(0.85724,-0.51492,0),(0.81744,-0.57601,0),(0.77619,-0.6305,0),(0.73445,-0.67867,0),(0.65224,-0.75801,0),(0.57451,-0.8185,0),(0.50255,-0.86455,0),(0.43622,-0.89984,0),(0.37459,-0.92719,0),(0.31623,-0.94868,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-0.38408,0.20778,0.1),(-0.38519,0.20653,0.1),(-0.38615,0.20516,0.1),(-0.387,0.20371,0.1),(-0.38774,0.20218,0.1),(-0.39008,0.19578,0.1),(-0.39008,0.19578,0),(-0.38774,0.20218,0),(-0.387,0.20371,0),(-0.38615,0.20516,0),(-0.38519,0.20653,0),(-0.38408,0.20778,0.0)]),
          normal=Normal(vector=[(0.7071,-0.70711,0),(0.78518,-0.61927,0),(0.84328,-0.53747,0),(0.88459,-0.46637,0),(0.91283,-0.40834,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.91283,-0.40834,0),(0.88459,-0.46637,0),(0.84328,-0.53747,0),(0.78518,-0.61927,0),(0.7071,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.39008,0.19578,0.1),(-0.40456,0.14762,0.1),(-0.42008,0.09978,0.1),(-0.42008,0.09978,0),(-0.40456,0.14762,0),(-0.39008,0.19578,0.0)]),
          normal=Normal(vector=[(0.96152,-0.27472,0),(0.95405,-0.29964,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.95405,-0.29964,0),(0.96152,-0.27472,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(-0.42008,0.09978,0.1),(-0.43714,0.04248,0.1),(-0.45608,-0.01422,0.1),(-0.45608,-0.01422,0),(-0.43714,0.04248,0),(-0.42008,0.09978,0.0)]),
          normal=Normal(vector=[(0.96352,-0.26764,0),(0.95327,-0.30212,0),(0.94386,-0.33035,0),(0.94386,-0.33035,0),(0.95327,-0.30212,0),(0.96352,-0.26764,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.45608,-0.01422,0.1),(-0.47108,-0.01422,0.1),(-0.47108,-0.01422,0),(-0.45608,-0.01422,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.47108,-0.01422,0.1),(-0.53408,0.17478,0.1),(-0.53408,0.17478,0),(-0.47108,-0.01422,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.53408,0.17478,0.1),(-0.60008,-0.01422,0.1),(-0.60008,-0.01422,0),(-0.53408,0.17478,0.0)]),
          normal=Normal(vector=[(0.94409,-0.32968,0),(0.94409,-0.32968,0),(0.94409,-0.32968,0),(0.94409,-0.32968,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.60008,-0.01422,0.1),(-0.61508,-0.01422,0.1),(-0.61508,-0.01422,0),(-0.60008,-0.01422,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.61508,-0.01422,0.1),(-0.63348,0.04866,0.1),(-0.65108,0.11178,0.1),(-0.65108,0.11178,0),(-0.63348,0.04866,0),(-0.61508,-0.01422,0.0)]),
          normal=Normal(vector=[(-0.95783,-0.28735,0),(-0.9616,-0.27445,0),(-0.96476,-0.26312,0),(-0.96476,-0.26312,0),(-0.9616,-0.27445,0),(-0.95783,-0.28735,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(-0.65108,0.11178,0.1),(-0.66332,0.15671,0.1),(-0.67508,0.20178,0.1),(-0.67508,0.20178,0),(-0.66332,0.15671,0),(-0.65108,0.11178,0.0)]),
          normal=Normal(vector=[(-0.96476,-0.26312,0),(-0.96559,-0.26007,0),(-0.97014,-0.24253,0),(-0.97014,-0.24253,0),(-0.96559,-0.26007,0),(-0.96476,-0.26312,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.67508,0.20178,0.1),(-0.67687,0.20381,0.1),(-0.67843,0.20602,0.1),(-0.68108,0.21078,0.1),(-0.68108,0.21078,0),(-0.67843,0.20602,0),(-0.67687,0.20381,0),(-0.67508,0.20178,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.78785,-0.61587,0),(-0.84184,-0.53972,0),(-0.89443,-0.44721,0),(-0.89443,-0.44721,0),(-0.84184,-0.53972,0),(-0.78785,-0.61587,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.68108,0.21078,0.1),(-0.68311,0.21256,0.1),(-0.68533,0.21413,0.1),(-0.69008,0.21678,0.1),(-0.69008,0.21678,0),(-0.68533,0.21413,0),(-0.68311,0.21256,0),(-0.68108,0.21078,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.61587,-0.78785,0),(-0.53972,-0.84184,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.53972,-0.84184,0),(-0.61587,-0.78785,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.69008,0.21678,0.1),(-0.69211,0.21856,0.1),(-0.69433,0.22013,0.1),(-0.69908,0.22278,0.1),(-0.69908,0.22278,0),(-0.69433,0.22013,0),(-0.69211,0.21856,0),(-0.69008,0.21678,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.61587,-0.78785,0),(-0.53972,-0.84184,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.53972,-0.84184,0),(-0.61587,-0.78785,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.69908,0.22278,0.1),(-0.70028,0.22281,0.1),(-0.70151,0.22293,0.1),(-0.70273,0.22314,0.1),(-0.70393,0.22344,0.1),(-0.70508,0.22385,0.1),(-0.70618,0.22437,0.1),(-0.70718,0.22501,0.1),(-0.70808,0.22578,0.1),(-0.70808,0.22578,0),(-0.70718,0.22501,0),(-0.70618,0.22437,0),(-0.70508,0.22385,0),(-0.70393,0.22344,0),(-0.70273,0.22314,0),(-0.70151,0.22293,0),(-0.70028,0.22281,0),(-0.69908,0.22278,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.06216,-0.99807,0),(-0.12928,-0.99161,0),(-0.20336,-0.9791,0),(-0.28619,-0.95817,0),(-0.37907,-0.92537,0),(-0.48214,-0.87609,0),(-0.59334,-0.80495,0),(-0.70711,-0.7071,0),(-0.70711,-0.7071,0),(-0.59334,-0.80495,0),(-0.48214,-0.87609,0),(-0.37907,-0.92537,0),(-0.28619,-0.95817,0),(-0.20336,-0.9791,0),(-0.12928,-0.99161,0),(-0.06216,-0.99807,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.70808,0.22578,0.1),(-0.70808,0.23778,0.1),(-0.70808,0.23778,0),(-0.70808,0.22578,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.70808,0.23778,0.1),(-0.60908,0.23778,0.1),(-0.60908,0.23778,0),(-0.70808,0.23778,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.60908,0.23778,0.1),(-0.60908,0.22578,0.1),(-0.60908,0.22578,0),(-0.60908,0.23778,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,5,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1],solid=False,
          coord=Coordinate(point=[(-0.60908,0.22578,0.1),(-0.6195,0.22363,0.1),(-0.62478,0.223,0.1),(-0.63008,0.22278,0.1),(-0.63008,0.22278,0),(-0.62478,0.223,0),(-0.6195,0.22363,0),(-0.60908,0.22578,0.0)]),
          normal=Normal(vector=[(0.24254,-0.97014,0),(0.15091,-0.98855,0),(0.08318,-0.99653,0),(0,-1.0,0),(0,-1.0,0),(0.08318,-0.99653,0),(0.15091,-0.98855,0),(0.24254,-0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,12,-1,13,14,10,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,10,11,12,-1],solid=False,
          coord=Coordinate(point=[(-0.63008,0.22278,0.1),(-0.634,0.22156,0.1),(-0.63601,0.22072,0.1),(-0.6379,0.2197,0.1),(-0.63877,0.21912,0.1),(-0.63956,0.2185,0.1),(-0.64027,0.21784,0.1),(-0.64089,0.21712,0.1),(-0.64139,0.21636,0.1),(-0.64176,0.21555,0.1),(-0.642,0.21469,0.1),(-0.64208,0.21378,0.1),(-0.64208,0.21378,0),(-0.642,0.21469,0),(-0.64176,0.21555,0),(-0.64139,0.21636,0),(-0.64089,0.21712,0),(-0.64027,0.21784,0),(-0.63956,0.2185,0),(-0.63877,0.21912,0),(-0.6379,0.2197,0),(-0.63601,0.22072,0),(-0.634,0.22156,0),(-0.63008,0.22278,0.0)]),
          normal=Normal(vector=[(0.24253,-0.97014,0),(0.35284,-0.93568,0),(0.42786,-0.90384,0),(0.5242,-0.8516,0),(0.58238,-0.81292,0),(0.64785,-0.76177,0),(0.72007,-0.6939,0),(0.79668,-0.6044,0),(0.87242,-0.48875,0),(0.9385,-0.34528,0),(0.98396,-0.17838,0),(1.0,0,0),(1.0,0,0),(0.98396,-0.17838,0),(0.9385,-0.34528,0),(0.87242,-0.48875,0),(0.79668,-0.6044,0),(0.72007,-0.6939,0),(0.64785,-0.76177,0),(0.58238,-0.81292,0),(0.5242,-0.8516,0),(0.42786,-0.90384,0),(0.35284,-0.93568,0),(0.24253,-0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.64208,0.21378,0.1),(-0.64058,0.21228,0.1),(-0.63908,0.21078,0.1),(-0.63908,0.21078,0),(-0.64058,0.21228,0),(-0.64208,0.21378,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.63908,0.21078,0.1),(-0.63908,0.20778,0.1),(-0.63908,0.20478,0.1),(-0.63908,0.20478,0),(-0.63908,0.21078,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(1.0,0,-0.0),(1.0,0,0),(1.0,0,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.63908,0.20478,0.1),(-0.63238,0.17907,0.1),(-0.62408,0.15378,0.1),(-0.62408,0.15378,0),(-0.63238,0.17907,0),(-0.63908,0.20478,0.0)]),
          normal=Normal(vector=[(0.98058,0.19611,-0.0),(0.95556,0.2948,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.95556,0.2948,-0.0),(0.98058,0.19611,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(-0.62408,0.15378,0.1),(-0.60931,0.10121,0.1),(-0.59408,0.04878,0.1),(-0.59408,0.04878,0),(-0.60931,0.10121,0),(-0.62408,0.15378,0.0)]),
          normal=Normal(vector=[(0.96476,0.26312,-0.0),(0.96107,0.2763,-0.0),(0.96,0.28,-0.0),(0.96,0.28,-0.0),(0.96107,0.2763,-0.0),(0.96476,0.26312,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.59408,0.04878,0.1),(-0.53408,0.23478,0.1),(-0.53408,0.23478,0),(-0.59408,0.04878,0.0)]),
          normal=Normal(vector=[(-0.95171,0.307,0),(-0.95171,0.307,0),(-0.95171,0.307,0),(-0.95171,0.307,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.53408,0.23478,0.1),(-0.51608,0.23478,0.1),(-0.51608,0.23478,0),(-0.53408,0.23478,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.51608,0.23478,0.1),(-0.45008,0.04278,0.1),(-0.45008,0.04278,0),(-0.51608,0.23478,0.0)]),
          normal=Normal(vector=[(0.94569,0.32508,0),(0.94569,0.32508,0),(0.94569,0.32508,0),(0.94569,0.32508,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(-0.45008,0.04278,0.1),(-0.43964,0.08179,0.1),(-0.42908,0.12078,0.1),(-0.42908,0.12078,0),(-0.43964,0.08179,0),(-0.45008,0.04278,0.0)]),
          normal=Normal(vector=[(-0.96623,0.25766,0),(-0.96567,0.25976,0),(-0.96476,0.26312,0),(-0.96476,0.26312,0),(-0.96567,0.25976,0),(-0.96623,0.25766,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(-0.42908,0.12078,0.1),(-0.42166,0.1478,0.1),(-0.41408,0.17478,0.1),(-0.41408,0.17478,0),(-0.42166,0.1478,0),(-0.42908,0.12078,0.0)]),
          normal=Normal(vector=[(-0.96476,0.26312,0),(-0.9637,0.267,0),(-0.96152,0.27472,0),(-0.96152,0.27472,0),(-0.9637,0.267,0),(-0.96476,0.26312,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.41408,0.17478,0.1),(-0.4101,0.18662,0.1),(-0.40865,0.19265,0.1),(-0.40823,0.1957,0.1),(-0.40808,0.19878,0.1),(-0.40808,0.19878,0),(-0.40823,0.1957,0),(-0.40865,0.19265,0),(-0.4101,0.18662,0),(-0.41408,0.17478,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.95936,0.28219,0),(-0.98467,0.17442,0),(-0.99544,0.09537,0),(-1.0,0,0),(-1.0,0,0),(-0.99544,0.09537,0),(-0.98467,0.17442,0),(-0.95936,0.28219,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.40808,0.19878,0.1),(-0.40808,0.20328,0.1),(-0.40808,0.20778,0.1),(-0.40808,0.20778,0),(-0.40808,0.19878,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.40808,0.20778,0.1),(-0.40811,0.20861,0.1),(-0.40821,0.20945,0.1),(-0.40836,0.21027,0.1),(-0.40857,0.21109,0.1),(-0.40914,0.21271,0.1),(-0.40989,0.21427,0.1),(-0.41079,0.21577,0.1),(-0.41181,0.2172,0.1),(-0.41291,0.21854,0.1),(-0.41408,0.21978,0.1),(-0.41408,0.21978,0),(-0.41291,0.21854,0),(-0.41181,0.2172,0),(-0.41079,0.21577,0),(-0.40989,0.21427,0),(-0.40914,0.21271,0),(-0.40857,0.21109,0),(-0.40836,0.21027,0),(-0.40821,0.20945,0),(-0.40811,0.20861,0),(-0.40808,0.20778,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99702,-0.07719,0),(-0.98874,-0.14963,0),(-0.97621,-0.21681,0),(-0.96042,-0.27856,0),(-0.92238,-0.38629,0),(-0.8799,-0.47516,0),(-0.83613,-0.54853,0),(-0.79259,-0.60975,0),(-0.7497,-0.66178,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.7497,-0.66178,0),(-0.79259,-0.60975,0),(-0.83613,-0.54853,0),(-0.8799,-0.47516,0),(-0.92238,-0.38629,0),(-0.96042,-0.27856,0),(-0.97621,-0.21681,0),(-0.98874,-0.14963,0),(-0.99702,-0.07719,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.41408,0.21978,0.1),(-0.42745,0.2233,0.1),(-0.44108,0.22578,0.1),(-0.44108,0.22578,0),(-0.42745,0.2233,0),(-0.41408,0.21978,0.0)]),
          normal=Normal(vector=[(-0.31623,-0.94868,0),(-0.20488,-0.97879,0),(-0.1644,-0.98639,0),(-0.1644,-0.98639,0),(-0.20488,-0.97879,0),(-0.31623,-0.94868,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.44108,0.22578,0.1),(-0.44108,0.23778,0.1),(-0.44108,0.23778,0),(-0.44108,0.22578,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.44108,0.23778,0.1),(-0.35108,0.23778,0.1),(-0.35108,0.23778,0),(-0.44108,0.23778,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,104,-1,104,1,103,-1,103,1,102,-1,102,1,101,-1,101,1,100,-1,100,1,99,-1,99,1,5,-1,98,5,95,-1,96,98,95,-1,96,97,98,-1,1,2,5,-1,5,2,4,-1,4,2,3,-1,95,5,94,-1,94,5,6,-1,7,94,6,-1,7,93,94,-1,7,8,93,-1,93,8,92,-1,92,8,9,-1,91,9,10,-1,90,10,89,-1,90,91,10,-1,92,9,91,-1,10,11,89,-1,89,11,88,-1,88,11,12,-1,86,12,13,-1,14,86,13,-1,14,85,86,-1,14,15,85,-1,85,15,84,-1,84,15,16,-1,83,16,17,-1,82,17,18,-1,19,82,18,-1,19,20,82,-1,82,20,21,-1,81,21,22,-1,23,81,22,-1,23,80,81,-1,23,24,80,-1,80,24,79,-1,79,24,25,-1,78,25,77,-1,78,79,25,-1,88,12,86,-1,87,88,86,-1,84,16,83,-1,83,17,82,-1,82,21,81,-1,77,25,76,-1,76,25,26,-1,27,76,26,-1,27,28,76,-1,76,28,75,-1,75,28,74,-1,74,28,73,-1,73,28,29,-1,72,29,30,-1,71,30,31,-1,70,31,32,-1,33,70,32,-1,33,36,70,-1,33,35,36,-1,33,34,35,-1,73,29,72,-1,72,30,71,-1,71,31,70,-1,37,67,36,-1,37,38,67,-1,67,38,39,-1,66,39,40,-1,65,40,41,-1,42,65,41,-1,42,63,65,-1,42,43,63,-1,63,43,62,-1,62,43,44,-1,52,44,45,-1,46,52,45,-1,46,51,52,-1,46,47,51,-1,51,47,48,-1,49,51,48,-1,49,50,51,-1,67,39,66,-1,66,40,65,-1,62,44,52,-1,61,52,60,-1,61,62,52,-1,53,54,52,-1,52,54,55,-1,56,52,55,-1,56,57,52,-1,52,57,58,-1,59,52,58,-1,59,60,52,-1,63,64,65,-1,67,68,36,-1,36,68,69,-1,70,36,69,-1,98,99,5,-1],solid=False,
          coord=Coordinate(point=[(-0.35108,0.22578,0.1),(-0.35108,0.23778,0.1),(-0.44108,0.23778,0.1),(-0.44108,0.22578,0.1),(-0.42745,0.2233,0.1),(-0.41408,0.21978,0.1),(-0.41291,0.21854,0.1),(-0.41181,0.2172,0.1),(-0.41079,0.21577,0.1),(-0.40989,0.21427,0.1),(-0.40914,0.21271,0.1),(-0.40857,0.21109,0.1),(-0.40836,0.21027,0.1),(-0.40821,0.20945,0.1),(-0.40811,0.20861,0.1),(-0.40808,0.20778,0.1),(-0.40808,0.20328,0.1),(-0.40808,0.19878,0.1),(-0.40823,0.1957,0.1),(-0.40865,0.19265,0.1),(-0.4101,0.18662,0.1),(-0.41408,0.17478,0.1),(-0.42166,0.1478,0.1),(-0.42908,0.12078,0.1),(-0.43964,0.08179,0.1),(-0.45008,0.04278,0.1),(-0.51608,0.23478,0.1),(-0.53408,0.23478,0.1),(-0.59408,0.04878,0.1),(-0.60931,0.10121,0.1),(-0.62408,0.15378,0.1),(-0.63238,0.17907,0.1),(-0.63908,0.20478,0.1),(-0.63908,0.20778,0.1),(-0.63908,0.21078,0.1),(-0.64058,0.21228,0.1),(-0.64208,0.21378,0.1),(-0.642,0.21469,0.1),(-0.64176,0.21555,0.1),(-0.64139,0.21636,0.1),(-0.64089,0.21712,0.1),(-0.64027,0.21784,0.1),(-0.63956,0.2185,0.1),(-0.63877,0.21912,0.1),(-0.6379,0.2197,0.1),(-0.63601,0.22072,0.1),(-0.634,0.22156,0.1),(-0.63008,0.22278,0.1),(-0.62478,0.223,0.1),(-0.6195,0.22363,0.1),(-0.60908,0.22578,0.1),(-0.60908,0.23778,0.1),(-0.70808,0.23778,0.1),(-0.70808,0.22578,0.1),(-0.70718,0.22501,0.1),(-0.70618,0.22437,0.1),(-0.70508,0.22385,0.1),(-0.70393,0.22344,0.1),(-0.70273,0.22314,0.1),(-0.70151,0.22293,0.1),(-0.70028,0.22281,0.1),(-0.69908,0.22278,0.1),(-0.69433,0.22013,0.1),(-0.69211,0.21856,0.1),(-0.69008,0.21678,0.1),(-0.68533,0.21413,0.1),(-0.68311,0.21256,0.1),(-0.68108,0.21078,0.1),(-0.67843,0.20602,0.1),(-0.67687,0.20381,0.1),(-0.67508,0.20178,0.1),(-0.66332,0.15671,0.1),(-0.65108,0.11178,0.1),(-0.63348,0.04866,0.1),(-0.61508,-0.01422,0.1),(-0.60008,-0.01422,0.1),(-0.53408,0.17478,0.1),(-0.47108,-0.01422,0.1),(-0.45608,-0.01422,0.1),(-0.43714,0.04248,0.1),(-0.42008,0.09978,0.1),(-0.40456,0.14762,0.1),(-0.39008,0.19578,0.1),(-0.38774,0.20218,0.1),(-0.387,0.20371,0.1),(-0.38615,0.20516,0.1),(-0.38519,0.20653,0.1),(-0.38408,0.20778,0.1),(-0.38363,0.2086,0.1),(-0.38312,0.20938,0.1),(-0.38255,0.21013,0.1),(-0.38193,0.21085,0.1),(-0.38055,0.21217,0.1),(-0.37902,0.21336,0.1),(-0.37737,0.21441,0.1),(-0.37564,0.21533,0.1),(-0.37387,0.21612,0.1),(-0.37208,0.21678,0.1),(-0.37005,0.21856,0.1),(-0.36783,0.22013,0.1),(-0.36308,0.22278,0.1),(-0.36153,0.22283,0.1),(-0.35998,0.22299,0.1),(-0.35692,0.22359,0.1),(-0.35393,0.22453,0.1)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.00308,0.00378,0.1),(0.00803,0.00437,0.1),(0.01361,0.00518,0.1),(0.01912,0.00637,0.1),(0.02447,0.00798,0.1),(0.02961,0.01007,0.1),(0.03445,0.01265,0.1),(0.03673,0.01414,0.1),(0.03892,0.01578,0.1),(0.03892,0.01578,0),(0.03673,0.01414,0),(0.03445,0.01265,0),(0.02961,0.01007,0),(0.02447,0.00798,0),(0.01912,0.00637,0),(0.01361,0.00518,0),(0.00803,0.00437,0),(-0.00308,0.00378,0.0)]),
          normal=Normal(vector=[(-0.0,1.0,-0.0),(-0.11037,0.99389,-0.0),(-0.17542,0.98449,-0.0),(-0.2486,0.96861,-0.0),(-0.33076,0.94372,-0.0),(-0.42199,0.9066,-0.0),(-0.52106,0.85352,-0.0),(-0.57261,0.81983,-0.0),(-0.6247,0.78087,-0.0),(-0.6247,0.78087,-0.0),(-0.57261,0.81983,-0.0),(-0.52106,0.85352,-0.0),(-0.42199,0.9066,-0.0),(-0.33076,0.94372,-0.0),(-0.2486,0.96861,-0.0),(-0.17542,0.98449,-0.0),(-0.11037,0.99389,-0.0),(-0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,2,6,1,-1,2,5,6,-1,2,4,5,-1,2,3,4,-1],solid=False,
          coord=Coordinate(point=[(-0.02708,0.00678,0.1),(-0.02124,0.00523,0.1),(-0.01524,0.00432,0.1),(-0.00308,0.00378,0.1),(-0.00308,0.00378,0),(-0.01524,0.00432,0),(-0.02124,0.00523,0),(-0.02708,0.00678,0.0)]),
          normal=Normal(vector=[(0.31623,0.94868,-0.0),(0.19851,0.9801,-0.0),(0.10626,0.99434,-0.0),(-0.0,1.0,-0.0),(-0.0,1.0,-0.0),(0.10626,0.99434,-0.0),(0.19851,0.9801,-0.0),(0.31623,0.94868,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,16,-1,17,18,6,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,6,7,16,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,12,-1,13,14,10,-1,16,8,15,-1,15,9,14,-1,10,11,12,-1],solid=False,
          coord=Coordinate(point=[(-0.03608,0.02478,0.1),(-0.03592,0.02223,0.1),(-0.03546,0.01966,0.1),(-0.0347,0.01712,0.1),(-0.03367,0.01466,0.1),(-0.03238,0.01234,0.1),(-0.03164,0.01125,0.1),(-0.03084,0.01022,0.1),(-0.02998,0.00925,0.1),(-0.02907,0.00834,0.1),(-0.0281,0.00752,0.1),(-0.02708,0.00678,0.1),(-0.02708,0.00678,0),(-0.0281,0.00752,0),(-0.02907,0.00834,0),(-0.02998,0.00925,0),(-0.03084,0.01022,0),(-0.03164,0.01125,0),(-0.03238,0.01234,0),(-0.03367,0.01466,0),(-0.0347,0.01712,0),(-0.03546,0.01966,0),(-0.03592,0.02223,0),(-0.03608,0.02478,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(0.99265,0.121,-0.0),(0.97277,0.23176,-0.0),(0.94187,0.33598,-0.0),(0.89953,0.43686,-0.0),(0.84372,0.53678,-0.0),(0.80971,0.58683,-0.0),(0.7709,0.63695,-0.0),(0.72665,0.687,-0.0),(0.67629,0.73663,-0.0),(0.61916,0.78526,-0.0),(0.5547,0.83205,-0.0),(0.5547,0.83205,-0.0),(0.61916,0.78526,-0.0),(0.67629,0.73663,-0.0),(0.72665,0.687,-0.0),(0.7709,0.63695,-0.0),(0.80971,0.58683,-0.0),(0.84372,0.53678,-0.0),(0.89953,0.43686,-0.0),(0.94187,0.33598,-0.0),(0.97277,0.23176,-0.0),(0.99265,0.121,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.03608,0.11178,0.1),(-0.03608,0.02478,0.1),(-0.03608,0.02478,0),(-0.03608,0.11178,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.02708,0.11178,0.1),(-0.03608,0.11178,0.1),(-0.03608,0.11178,0),(-0.02708,0.11178,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.00608,0.11178,0.1),(-0.02708,0.11178,0.1),(-0.02708,0.11178,0),(-0.00608,0.11178,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(0.03592,0.09678,0.1),(0.03388,0.09868,0.1),(0.03171,0.10044,0.1),(0.02701,0.10356,0.1),(0.02193,0.10614,0.1),(0.01655,0.10822,0.1),(0.01097,0.1098,0.1),(0.00528,0.11091,0.1),(-4.4E-4,0.11156,0.1),(-0.00608,0.11178,0.1),(-0.00608,0.11178,0),(-4.4E-4,0.11156,0),(0.00528,0.11091,0),(0.01097,0.1098,0),(0.01655,0.10822,0),(0.02193,0.10614,0),(0.02701,0.10356,0),(0.03171,0.10044,0),(0.03388,0.09868,0),(0.03592,0.09678,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.65567,-0.75505,0),(-0.60395,-0.79702,0),(-0.50233,-0.86468,0),(-0.40576,-0.91398,0),(-0.31546,-0.94894,0),(-0.23115,-0.97292,0),(-0.15165,-0.98843,0),(-0.07527,-0.99716,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.07527,-0.99716,0),(-0.15165,-0.98843,0),(-0.23115,-0.97292,0),(-0.31546,-0.94894,0),(-0.40576,-0.91398,0),(-0.50233,-0.86468,0),(-0.60395,-0.79702,0),(-0.65567,-0.75505,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[21,0,20,-1,20,0,1,-1,19,1,2,-1,3,19,2,-1,3,18,19,-1,3,4,18,-1,18,4,17,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,1,19,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.05392,0.06078,0.1),(0.05383,0.0633,0.1),(0.05357,0.06582,0.1),(0.05314,0.06835,0.1),(0.05256,0.07085,0.1),(0.05094,0.0758,0.1),(0.04878,0.08059,0.1),(0.04614,0.08515,0.1),(0.04308,0.08942,0.1),(0.03965,0.09331,0.1),(0.03592,0.09678,0.1),(0.03592,0.09678,0),(0.03965,0.09331,0),(0.04308,0.08942,0),(0.04614,0.08515,0),(0.04878,0.08059,0),(0.05094,0.0758,0),(0.05256,0.07085,0),(0.05314,0.06835,0),(0.05357,0.06582,0),(0.05383,0.0633,0),(0.05392,0.06078,0.0)]),
          normal=Normal(vector=[(-1.0,-0.0,-0.0),(-0.99756,-0.06977,0),(-0.99076,-0.13565,0),(-0.98027,-0.19765,0),(-0.9667,-0.25591,0),(-0.93208,-0.36224,0),(-0.88942,-0.45709,0),(-0.8397,-0.54304,0),(-0.78267,-0.62243,0),(-0.71697,-0.6971,0),(-0.64018,-0.76822,0),(-0.64018,-0.76822,0),(-0.71697,-0.6971,0),(-0.78267,-0.62243,0),(-0.8397,-0.54304,0),(-0.88942,-0.45709,0),(-0.93208,-0.36224,0),(-0.9667,-0.25591,0),(-0.98027,-0.19765,0),(-0.99076,-0.13565,0),(-0.99756,-0.06977,0),(-1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[21,0,20,-1,20,0,1,-1,19,1,2,-1,3,19,2,-1,3,18,19,-1,3,4,18,-1,18,4,17,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,1,19,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.03892,0.01578,0.1),(0.04093,0.01795,0.1),(0.04277,0.02027,0.1),(0.04446,0.02273,0.1),(0.04598,0.0253,0.1),(0.04858,0.03076,0.1),(0.05061,0.03654,0.1),(0.05212,0.04254,0.1),(0.05315,0.04865,0.1),(0.05373,0.05476,0.1),(0.05392,0.06078,0.1),(0.05392,0.06078,0),(0.05373,0.05476,0),(0.05315,0.04865,0),(0.05212,0.04254,0),(0.05061,0.03654,0),(0.04858,0.03076,0),(0.04598,0.0253,0),(0.04446,0.02273,0),(0.04277,0.02027,0),(0.04093,0.01795,0),(0.03892,0.01578,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,-0.0),(-0.75958,0.65041,-0.0),(-0.80495,0.59334,-0.0),(-0.8436,0.53698,-0.0),(-0.87609,0.48214,-0.0),(-0.92537,0.37907,-0.0),(-0.95817,0.28619,-0.0),(-0.9791,0.20336,-0.0),(-0.99161,0.12928,-0.0),(-0.99807,0.06216,-0.0),(-1.0,-0.0,0),(-1.0,-0.0,0),(-0.99807,0.06216,-0.0),(-0.99161,0.12928,-0.0),(-0.9791,0.20336,-0.0),(-0.95817,0.28619,-0.0),(-0.92537,0.37907,-0.0),(-0.87609,0.48214,-0.0),(-0.8436,0.53698,-0.0),(-0.80495,0.59334,-0.0),(-0.75958,0.65041,-0.0),(-0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.01508,0.12678,0.1),(-0.00292,0.12732,0.1),(0.00308,0.12823,0.1),(0.00892,0.12978,0.1),(0.00892,0.12978,0),(0.00308,0.12823,0),(-0.00292,0.12732,0),(-0.01508,0.12678,0.0)]),
          normal=Normal(vector=[(-0.0,1.0,-0.0),(-0.10626,0.99434,-0.0),(-0.19851,0.9801,-0.0),(-0.31623,0.94868,-0.0),(-0.31623,0.94868,-0.0),(-0.19851,0.9801,-0.0),(-0.10626,0.99434,-0.0),(-0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.03608,0.12678,0.1),(-0.01508,0.12678,0.1),(-0.01508,0.12678,0),(-0.03608,0.12678,0.0)]),
          normal=Normal(vector=[(-0.0,1.0,-0.0),(-0.0,1.0,-0.0),(-0.0,1.0,-0.0),(-0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.03608,0.22278,0.1),(-0.03608,0.12678,0.1),(-0.03608,0.12678,0),(-0.03608,0.22278,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.02408,0.22278,0.1),(-0.03608,0.22278,0.1),(-0.03608,0.22278,0),(-0.02408,0.22278,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.00908,0.22278,0.1),(-0.02408,0.22278,0.1),(-0.02408,0.22278,0),(-0.00908,0.22278,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,18,-1,19,20,2,-1,2,3,18,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.02692,0.21078,0.1),(0.02518,0.21239,0.1),(0.02332,0.21386,0.1),(0.02136,0.21521,0.1),(0.0193,0.21643,0.1),(0.01493,0.2185,0.1),(0.01031,0.22013,0.1),(0.00551,0.22134,0.1),(6.2E-4,0.22216,0.1),(-0.00427,0.22263,0.1),(-0.00908,0.22278,0.1),(-0.00908,0.22278,0),(-0.00427,0.22263,0),(6.2E-4,0.22216,0),(0.00551,0.22134,0),(0.01031,0.22013,0),(0.01493,0.2185,0),(0.0193,0.21643,0),(0.02136,0.21521,0),(0.02332,0.21386,0),(0.02518,0.21239,0),(0.02692,0.21078,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.65041,-0.75958,0),(-0.59334,-0.80495,0),(-0.53698,-0.8436,0),(-0.48214,-0.87609,0),(-0.37907,-0.92537,0),(-0.28619,-0.95817,0),(-0.20336,-0.9791,0),(-0.12928,-0.99161,0),(-0.06216,-0.99807,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.06216,-0.99807,0),(-0.12928,-0.99161,0),(-0.20336,-0.9791,0),(-0.28619,-0.95817,0),(-0.37907,-0.92537,0),(-0.48214,-0.87609,0),(-0.53698,-0.8436,0),(-0.59334,-0.80495,0),(-0.65041,-0.75958,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(0.03892,0.17778,0.1),(0.03874,0.18222,0.1),(0.03821,0.18671,0.1),(0.03731,0.19118,0.1),(0.03602,0.19556,0.1),(0.03435,0.19979,0.1),(0.03229,0.20378,0.1),(0.02981,0.20746,0.1),(0.02842,0.20917,0.1),(0.02692,0.21078,0.1),(0.02692,0.21078,0),(0.02842,0.20917,0),(0.02981,0.20746,0),(0.03229,0.20378,0),(0.03435,0.19979,0),(0.03602,0.19556,0),(0.03731,0.19118,0),(0.03821,0.18671,0),(0.03874,0.18222,0),(0.03892,0.17778,0.0)]),
          normal=Normal(vector=[(-1.0,-0.0,-0.0),(-0.99689,-0.07881,0),(-0.98749,-0.15769,0),(-0.97111,-0.23864,0),(-0.94629,-0.32332,0),(-0.91078,-0.41289,0),(-0.86152,-0.50772,0),(-0.79485,-0.6068,0),(-0.75381,-0.65709,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.75381,-0.65709,0),(-0.79485,-0.6068,0),(-0.86152,-0.50772,0),(-0.91078,-0.41289,0),(-0.94629,-0.32332,0),(-0.97111,-0.23864,0),(-0.98749,-0.15769,0),(-0.99689,-0.07881,0),(-1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,6,-1,7,8,2,-1,2,3,6,-1,6,3,4,-1,5,6,4,-1],solid=False,
          coord=Coordinate(point=[(0.03592,0.15678,0.1),(0.03733,0.16189,0.1),(0.03826,0.16714,0.1),(0.03877,0.17246,0.1),(0.03892,0.17778,0.1),(0.03892,0.17778,0),(0.03877,0.17246,0),(0.03826,0.16714,0),(0.03733,0.16189,0),(0.03592,0.15678,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,-0.0),(-0.97601,0.21771,-0.0),(-0.99122,0.1322,-0.0),(-0.99821,0.05989,-0.0),(-1.0,-0.0,0),(-1.0,-0.0,0),(-0.99821,0.05989,-0.0),(-0.99122,0.1322,-0.0),(-0.97601,0.21771,-0.0),(-0.94868,0.31623,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.02692,0.13878,0.1),(0.03202,0.14748,0.1),(0.03414,0.15206,0.1),(0.03592,0.15678,0.1),(0.03592,0.15678,0),(0.03414,0.15206,0),(0.03202,0.14748,0),(0.02692,0.13878,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,-0.0),(-0.89248,0.45108,-0.0),(-0.92165,0.38803,-0.0),(-0.94868,0.31623,-0.0),(-0.94868,0.31623,-0.0),(-0.92165,0.38803,-0.0),(-0.89248,0.45108,-0.0),(-0.83205,0.5547,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.00892,0.12978,0.1),(0.01381,0.1312,0.1),(0.01858,0.13311,0.1),(0.02086,0.13427,0.1),(0.02302,0.1356,0.1),(0.02505,0.1371,0.1),(0.02692,0.13878,0.1),(0.02692,0.13878,0),(0.02505,0.1371,0),(0.02302,0.1356,0),(0.02086,0.13427,0),(0.01858,0.13311,0),(0.01381,0.1312,0),(0.00892,0.12978,0.0)]),
          normal=Normal(vector=[(-0.24253,0.97014,-0.0),(-0.32084,0.94713,-0.0),(-0.42529,0.90506,-0.0),(-0.48778,0.87297,-0.0),(-0.55663,0.83076,-0.0),(-0.63055,0.77615,-0.0),(-0.70711,0.70711,-0.0),(-0.70711,0.70711,-0.0),(-0.63055,0.77615,-0.0),(-0.55663,0.83076,-0.0),(-0.48778,0.87297,-0.0),(-0.42529,0.90506,-0.0),(-0.32084,0.94713,-0.0),(-0.24253,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,6,-1,7,8,2,-1,2,3,6,-1,6,3,4,-1,5,6,4,-1],solid=False,
          coord=Coordinate(point=[(0.06892,0.10278,0.1),(0.07393,0.09881,0.1),(0.0787,0.09452,0.1),(0.08308,0.08985,0.1),(0.08692,0.08478,0.1),(0.08692,0.08478,0),(0.08308,0.08985,0),(0.0787,0.09452,0),(0.07393,0.09881,0),(0.06892,0.10278,0.0)]),
          normal=Normal(vector=[(0.6,0.8,-0.0),(0.64283,0.76601,-0.0),(0.69744,0.71664,-0.0),(0.76189,0.6477,-0.0),(0.83205,0.5547,-0.0),(0.83205,0.5547,-0.0),(0.76189,0.6477,-0.0),(0.69744,0.71664,-0.0),(0.64283,0.76601,-0.0),(0.6,0.8,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,10,-1,11,12,6,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,6,7,10,-1,10,7,8,-1,9,10,8,-1],solid=False,
          coord=Coordinate(point=[(0.08692,0.08478,0.1),(0.08911,0.08152,0.1),(0.09097,0.07803,0.1),(0.09252,0.07437,0.1),(0.09377,0.07056,0.1),(0.09472,0.06666,0.1),(0.09539,0.06269,0.1),(0.09579,0.05872,0.1),(0.09592,0.05478,0.1),(0.09592,0.05478,0),(0.09579,0.05872,0),(0.09539,0.06269,0),(0.09472,0.06666,0),(0.09377,0.07056,0),(0.09252,0.07437,0),(0.09097,0.07803,0),(0.08911,0.08152,0),(0.08692,0.08478,0.0)]),
          normal=Normal(vector=[(0.8,0.6,-0.0),(0.85796,0.51371,-0.0),(0.90285,0.42995,-0.0),(0.93678,0.34991,-0.0),(0.96176,0.27391,-0.0),(0.97945,0.20168,-0.0),(0.99117,0.13257,-0.0),(0.99784,0.0657,-0.0),(1.0,0,0),(1.0,0,0),(0.99784,0.0657,-0.0),(0.99117,0.13257,-0.0),(0.97945,0.20168,-0.0),(0.96176,0.27391,-0.0),(0.93678,0.34991,-0.0),(0.90285,0.42995,-0.0),(0.85796,0.51371,-0.0),(0.8,0.6,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.09592,0.05478,0.1),(0.09579,0.05083,0.1),(0.09539,0.04686,0.1),(0.09472,0.0429,0.1),(0.09377,0.03899,0.1),(0.09252,0.03519,0.1),(0.09097,0.03152,0.1),(0.08911,0.02804,0.1),(0.08692,0.02478,0.1),(0.08692,0.02478,0),(0.08911,0.02804,0),(0.09097,0.03152,0),(0.09252,0.03519,0),(0.09377,0.03899,0),(0.09472,0.0429,0),(0.09539,0.04686,0),(0.09579,0.05083,0),(0.09592,0.05478,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99784,-0.0657,0),(0.99117,-0.13257,0),(0.97945,-0.20168,0),(0.96176,-0.27391,0),(0.93678,-0.34991,0),(0.90285,-0.42995,0),(0.85796,-0.51371,0),(0.8,-0.6,0),(0.8,-0.6,0),(0.85796,-0.51371,0),(0.90285,-0.42995,0),(0.93678,-0.34991,0),(0.96176,-0.27391,0),(0.97945,-0.20168,0),(0.99117,-0.13257,0),(0.99784,-0.0657,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(0.08692,0.02478,0.1),(0.08527,0.02173,0.1),(0.08341,0.0188,0.1),(0.07914,0.01326,0.1),(0.07426,0.00823,0.1),(0.06892,0.00378,0.1),(0.06892,0.00378,0),(0.07426,0.00823,0),(0.07914,0.01326,0),(0.08341,0.0188,0),(0.08527,0.02173,0),(0.08692,0.02478,0.0)]),
          normal=Normal(vector=[(0.89443,-0.44721,0),(0.86193,-0.50703,0),(0.82756,-0.56138,0),(0.75513,-0.65557,0),(0.67928,-0.73388,0),(0.6,-0.8,0),(0.6,-0.8,0),(0.67928,-0.73388,0),(0.75513,-0.65557,0),(0.82756,-0.56138,0),(0.86193,-0.50703,0),(0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.06892,0.00378,0.1),(0.06274,-3.2E-4,0.1),(0.05609,-0.00371,0.1),(0.0491,-0.00636,0.1),(0.04192,-0.00822,0.1),(0.04192,-0.00822,0),(0.0491,-0.00636,0),(0.05609,-0.00371,0),(0.06274,-3.2E-4,0),(0.06892,0.00378,0.0)]),
          normal=Normal(vector=[(0.6,-0.8,0),(0.50364,-0.86392,0),(0.40516,-0.91425,0),(0.30331,-0.95289,0),(0.19612,-0.98058,0),(0.19612,-0.98058,0),(0.30331,-0.95289,0),(0.40516,-0.91425,0),(0.50364,-0.86392,0),(0.6,-0.8,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.04192,-0.00822,0.1),(0.02699,-0.01046,0.1),(0.01192,-0.01122,0.1),(0.01192,-0.01122,0),(0.02699,-0.01046,0),(0.04192,-0.00822,0.0)]),
          normal=Normal(vector=[(0.19612,-0.98058,0),(0.09998,-0.99499,0),(0,-1.0,0),(0,-1.0,0),(0.09998,-0.99499,0),(0.19612,-0.98058,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.01192,-0.01122,0.1),(-0.10508,-0.01122,0.1),(-0.10508,-0.01122,0),(0.01192,-0.01122,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.10508,-0.01122,0.1),(-0.10508,7.8E-4,0.1),(-0.10508,7.8E-4,0),(-0.10508,-0.01122,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.10508,7.8E-4,0.1),(-0.10058,7.8E-4,0.1),(-0.09608,7.8E-4,0.1),(-0.09608,7.8E-4,0),(-0.10508,7.8E-4,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,15,-1,16,17,5,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,5,6,15,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.09608,7.8E-4,0.1),(-0.09288,8.4E-4,0.1),(-0.09124,9.6E-4,0.1),(-0.08963,0.00118,0.1),(-0.08807,0.00155,0.1),(-0.08732,0.00179,0.1),(-0.08661,0.00208,0.1),(-0.08592,0.00242,0.1),(-0.08526,0.00281,0.1),(-0.08465,0.00326,0.1),(-0.08408,0.00378,0.1),(-0.08408,0.00378,0),(-0.08465,0.00326,0),(-0.08526,0.00281,0),(-0.08592,0.00242,0),(-0.08661,0.00208,0),(-0.08732,0.00179,0),(-0.08807,0.00155,0),(-0.08963,0.00118,0),(-0.09124,9.6E-4,0),(-0.09288,8.4E-4,0),(-0.09608,7.8E-4,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.04898,0.9988,0),(-0.1029,0.99469,0),(-0.17892,0.98386,0),(-0.27976,0.96007,0),(-0.33996,0.94044,0),(-0.40641,0.91369,0),(-0.47828,0.87821,0),(-0.55403,0.8325,0),(-0.63131,0.77553,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.63131,0.77553,0),(-0.55403,0.8325,0),(-0.47828,0.87821,0),(-0.40641,0.91369,0),(-0.33996,0.94044,0),(-0.27976,0.96007,0),(-0.17892,0.98386,0),(-0.1029,0.99469,0),(-0.04898,0.9988,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.08408,0.00378,0.1),(-0.07933,0.00643,0.1),(-0.07711,0.00799,0.1),(-0.07508,0.00978,0.1),(-0.07508,0.00978,0),(-0.07711,0.00799,0),(-0.07933,0.00643,0),(-0.08408,0.00378,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,0),(-0.53972,0.84184,0),(-0.61587,0.78785,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.61587,0.78785,0),(-0.53972,0.84184,0),(-0.44721,0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[21,0,20,-1,20,0,1,-1,19,1,2,-1,3,19,2,-1,3,18,19,-1,3,4,18,-1,18,4,17,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,1,19,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(-0.07508,0.00978,0.1),(-0.07457,0.01035,0.1),(-0.07411,0.01096,0.1),(-0.07372,0.01161,0.1),(-0.07338,0.0123,0.1),(-0.07309,0.01302,0.1),(-0.07285,0.01377,0.1),(-0.07249,0.01532,0.1),(-0.07226,0.01694,0.1),(-0.07214,0.01857,0.1),(-0.07208,0.02178,0.1),(-0.07208,0.02178,0),(-0.07214,0.01857,0),(-0.07226,0.01694,0),(-0.07249,0.01532,0),(-0.07285,0.01377,0),(-0.07309,0.01302,0),(-0.07338,0.0123,0),(-0.07372,0.01161,0),(-0.07411,0.01096,0),(-0.07457,0.01035,0),(-0.07508,0.00978,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.77553,0.63131,0),(-0.8325,0.55403,0),(-0.87821,0.47828,0),(-0.91369,0.40641,0),(-0.94044,0.33996,0),(-0.96007,0.27976,0),(-0.98386,0.17892,0),(-0.99469,0.1029,0),(-0.9988,0.04898,0),(-1.0,0,0),(-1.0,0,0),(-0.9988,0.04898,0),(-0.99469,0.1029,0),(-0.98386,0.17892,0),(-0.96007,0.27976,0),(-0.94044,0.33996,0),(-0.91369,0.40641,0),(-0.87821,0.47828,0),(-0.8325,0.55403,0),(-0.77553,0.63131,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.07208,0.02178,0.1),(-0.07208,0.20178,0.1),(-0.07208,0.20178,0),(-0.07208,0.02178,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.07208,0.20178,0.1),(-0.07212,0.20298,0.1),(-0.07223,0.2042,0.1),(-0.07244,0.20543,0.1),(-0.07274,0.20662,0.1),(-0.07315,0.20778,0.1),(-0.07367,0.20887,0.1),(-0.07431,0.20988,0.1),(-0.07508,0.21078,0.1),(-0.07508,0.21078,0),(-0.07431,0.20988,0),(-0.07367,0.20887,0),(-0.07315,0.20778,0),(-0.07274,0.20662,0),(-0.07244,0.20543,0),(-0.07223,0.2042,0),(-0.07212,0.20298,0),(-0.07208,0.20178,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99807,-0.06217,0),(-0.99161,-0.12929,0),(-0.9791,-0.20336,0),(-0.95817,-0.28619,0),(-0.92537,-0.37907,0),(-0.87609,-0.48214,0),(-0.80495,-0.59334,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.80495,-0.59334,0),(-0.87609,-0.48214,0),(-0.92537,-0.37907,0),(-0.95817,-0.28619,0),(-0.9791,-0.20336,0),(-0.99161,-0.12929,0),(-0.99807,-0.06217,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,11,-1,12,13,5,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,5,6,11,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.07508,0.21078,0.1),(-0.07586,0.21218,0.1),(-0.07675,0.21352,0.1),(-0.07776,0.21479,0.1),(-0.07887,0.21599,0.1),(-0.08007,0.2171,0.1),(-0.08134,0.2181,0.1),(-0.08268,0.219,0.1),(-0.08408,0.21978,0.1),(-0.08408,0.21978,0),(-0.08268,0.219,0),(-0.08134,0.2181,0),(-0.08007,0.2171,0),(-0.07887,0.21599,0),(-0.07776,0.21479,0),(-0.07675,0.21352,0),(-0.07586,0.21218,0),(-0.07508,0.21078,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.85331,-0.52141,0),(-0.80828,-0.58879,0),(-0.75959,-0.6504,0),(-0.70711,-0.70711,0),(-0.6504,-0.75959,0),(-0.58879,-0.80828,0),(-0.52141,-0.85331,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.52141,-0.85331,0),(-0.58879,-0.80828,0),(-0.6504,-0.75959,0),(-0.70711,-0.70711,0),(-0.75959,-0.6504,0),(-0.80828,-0.58879,0),(-0.85331,-0.52141,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(-0.08408,0.21978,0.1),(-0.08563,0.21983,0.1),(-0.08718,0.21999,0.1),(-0.09024,0.22059,0.1),(-0.09323,0.22153,0.1),(-0.09608,0.22278,0.1),(-0.09608,0.22278,0),(-0.09323,0.22153,0),(-0.09024,0.22059,0),(-0.08718,0.21999,0),(-0.08563,0.21983,0),(-0.08408,0.21978,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.06804,-0.99768,0),(-0.13201,-0.99125,0),(-0.24866,-0.96859,0),(-0.35262,-0.93577,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.35262,-0.93577,0),(-0.24866,-0.96859,0),(-0.13201,-0.99125,0),(-0.06804,-0.99768,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.09608,0.22278,0.1),(-0.09728,0.22281,0.1),(-0.09851,0.22293,0.1),(-0.09973,0.22314,0.1),(-0.10093,0.22344,0.1),(-0.10208,0.22385,0.1),(-0.10318,0.22437,0.1),(-0.10418,0.22501,0.1),(-0.10508,0.22578,0.1),(-0.10508,0.22578,0),(-0.10418,0.22501,0),(-0.10318,0.22437,0),(-0.10208,0.22385,0),(-0.10093,0.22344,0),(-0.09973,0.22314,0),(-0.09851,0.22293,0),(-0.09728,0.22281,0),(-0.09608,0.22278,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.06217,-0.99807,0),(-0.12929,-0.99161,0),(-0.20336,-0.9791,0),(-0.28619,-0.95817,0),(-0.37907,-0.92537,0),(-0.48214,-0.87609,0),(-0.59334,-0.80495,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.59334,-0.80495,0),(-0.48214,-0.87609,0),(-0.37907,-0.92537,0),(-0.28619,-0.95817,0),(-0.20336,-0.9791,0),(-0.12929,-0.99161,0),(-0.06217,-0.99807,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.10508,0.22578,0.1),(-0.10508,0.23778,0.1),(-0.10508,0.23778,0),(-0.10508,0.22578,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.10508,0.23778,0.1),(0.00892,0.23778,0.1),(0.00892,0.23778,0),(-0.10508,0.23778,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1,6,1,5,-1],solid=False,
          coord=Coordinate(point=[(0.00892,0.23778,0.1),(0.01497,0.23758,0.1),(0.02101,0.23701,0.1),(0.03292,0.23478,0.1),(0.03292,0.23478,0),(0.02101,0.23701,0),(0.01497,0.23758,0),(0.00892,0.23778,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06358,0.99798,-0.0),(0.12495,0.99216,-0.0),(0.24253,0.97014,-0.0),(0.24253,0.97014,-0.0),(0.12495,0.99216,-0.0),(0.06358,0.99798,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.03292,0.23478,0.1),(0.04516,0.23093,0.1),(0.05692,0.22578,0.1),(0.05692,0.22578,0),(0.04516,0.23093,0),(0.03292,0.23478,0.0)]),
          normal=Normal(vector=[(0.24254,0.97014,-0.0),(0.35319,0.93555,-0.0),(0.44721,0.89443,-0.0),(0.44721,0.89443,-0.0),(0.35319,0.93555,-0.0),(0.24254,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.05692,0.22578,0.1),(0.06487,0.21714,0.1),(0.07192,0.20778,0.1),(0.07192,0.20778,0),(0.06487,0.21714,0),(0.05692,0.22578,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.76566,0.64324,-0.0),(0.83205,0.5547,-0.0),(0.83205,0.5547,-0.0),(0.76566,0.64324,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.07192,0.20778,0.1),(0.07394,0.20483,0.1),(0.07573,0.20169,0.1),(0.07727,0.1984,0.1),(0.07855,0.19499,0.1),(0.07957,0.19149,0.1),(0.08031,0.18793,0.1),(0.08077,0.18435,0.1),(0.08092,0.18078,0.1),(0.08092,0.18078,0),(0.08077,0.18435,0),(0.08031,0.18793,0),(0.07957,0.19149,0),(0.07855,0.19499,0),(0.07727,0.1984,0),(0.07573,0.20169,0),(0.07394,0.20483,0),(0.07192,0.20778,0.0)]),
          normal=Normal(vector=[(0.8,0.6,-0.0),(0.84797,0.53004,-0.0),(0.88811,0.45963,-0.0),(0.92143,0.38853,-0.0),(0.94868,0.31623,-0.0),(0.97027,0.24203,-0.0),(0.98627,0.16516,-0.0),(0.9964,0.08475,-0.0),(1.0,0,0),(1.0,0,0),(0.9964,0.08475,-0.0),(0.98627,0.16516,-0.0),(0.97027,0.24203,-0.0),(0.94868,0.31623,-0.0),(0.92143,0.38853,-0.0),(0.88811,0.45963,-0.0),(0.84797,0.53004,-0.0),(0.8,0.6,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.08092,0.18078,0.1),(0.08081,0.17768,0.1),(0.0805,0.17459,0.1),(0.0793,0.16845,0.1),(0.07741,0.16248,0.1),(0.07492,0.15678,0.1),(0.07492,0.15678,0),(0.07741,0.16248,0),(0.0793,0.16845,0),(0.0805,0.17459,0),(0.08081,0.17768,0),(0.08092,0.18078,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99768,-0.06804,0),(0.99125,-0.13201,0),(0.96859,-0.24866,0),(0.93577,-0.35262,0),(0.89443,-0.44721,0),(0.89443,-0.44721,0),(0.93577,-0.35262,0),(0.96859,-0.24866,0),(0.99125,-0.13201,0),(0.99768,-0.06804,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.07492,0.15678,0.1),(0.06929,0.14898,0.1),(0.06292,0.14178,0.1),(0.06292,0.14178,0),(0.06929,0.14898,0),(0.07492,0.15678,0.0)]),
          normal=Normal(vector=[(0.83205,-0.5547,0),(0.78456,-0.62005,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.78456,-0.62005,0),(0.83205,-0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.06292,0.14178,0.1),(0.0607,0.13971,0.1),(0.05833,0.13777,0.1),(0.05583,0.13599,0.1),(0.05322,0.13437,0.1),(0.0505,0.13293,0.1),(0.0477,0.13168,0.1),(0.04483,0.13062,0.1),(0.04192,0.12978,0.1),(0.04192,0.12978,0),(0.04483,0.13062,0),(0.0477,0.13168,0),(0.0505,0.13293,0),(0.05322,0.13437,0),(0.05583,0.13599,0),(0.05833,0.13777,0),(0.0607,0.13971,0),(0.06292,0.14178,0.0)]),
          normal=Normal(vector=[(0.70711,-0.70711,0),(0.65768,-0.7533,0),(0.60649,-0.79509,0),(0.5533,-0.83298,0),(0.49776,-0.86731,0),(0.43945,-0.89827,0),(0.37783,-0.92587,0),(0.31238,-0.94996,0),(0.24253,-0.97014,0),(0.24253,-0.97014,0),(0.31238,-0.94996,0),(0.37783,-0.92587,0),(0.43945,-0.89827,0),(0.49776,-0.86731,0),(0.5533,-0.83298,0),(0.60649,-0.79509,0),(0.65768,-0.7533,0),(0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.04192,0.12978,0.1),(0.037,0.12685,0.1),(0.03181,0.12439,0.1),(0.02643,0.12237,0.1),(0.02092,0.12078,0.1),(0.02092,0.12078,0),(0.02643,0.12237,0),(0.03181,0.12439,0),(0.037,0.12685,0),(0.04192,0.12978,0.0)]),
          normal=Normal(vector=[(0.5547,-0.83205,0),(0.46933,-0.88303,0),(0.3887,-0.92136,0),(0.31323,-0.94968,0),(0.24254,-0.97014,0),(0.24254,-0.97014,0),(0.31323,-0.94968,0),(0.3887,-0.92136,0),(0.46933,-0.88303,0),(0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(0.02092,0.12078,0.1),(0.03292,0.11778,0.1),(0.04492,0.11478,0.1),(0.04492,0.11478,0),(0.03292,0.11778,0),(0.02092,0.12078,0.0)]),
          normal=Normal(vector=[(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.04492,0.11478,0.1),(0.05724,0.10939,0.1),(0.0632,0.10628,0.1),(0.06892,0.10278,0.1),(0.06892,0.10278,0),(0.0632,0.10628,0),(0.05724,0.10939,0),(0.04492,0.11478,0.0)]),
          normal=Normal(vector=[(0.37139,0.92848,-0.0),(0.43805,0.89895,-0.0),(0.49065,0.87136,-0.0),(0.5547,0.83205,-0.0),(0.5547,0.83205,-0.0),(0.49065,0.87136,-0.0),(0.43805,0.89895,-0.0),(0.37139,0.92848,-0.0)]))),
      Shape(
        appearance=Appearance(USE='charactersWebAppearance'),
        geometry=IndexedFaceSet(coordIndex=[128,0,210,-1,211,128,210,-1,211,127,128,-1,211,126,127,-1,211,212,126,-1,126,212,125,-1,125,212,124,-1,124,212,123,-1,123,212,122,-1,122,212,213,-1,121,213,120,-1,121,122,213,-1,2,208,1,-1,2,3,208,-1,208,3,207,-1,207,3,4,-1,206,4,5,-1,205,5,6,-1,204,6,203,-1,204,205,6,-1,207,4,206,-1,206,5,205,-1,6,7,203,-1,203,7,202,-1,202,7,201,-1,201,7,200,-1,200,7,199,-1,199,7,198,-1,198,7,197,-1,197,7,196,-1,196,7,195,-1,195,7,194,-1,194,7,193,-1,193,7,8,-1,9,193,8,-1,9,133,193,-1,9,10,133,-1,133,10,11,-1,132,11,131,-1,132,133,11,-1,12,162,11,-1,12,161,162,-1,12,13,161,-1,161,13,14,-1,160,14,15,-1,16,160,15,-1,16,159,160,-1,16,17,159,-1,159,17,18,-1,19,159,18,-1,19,158,159,-1,19,20,158,-1,158,20,21,-1,157,21,22,-1,156,22,23,-1,24,156,23,-1,24,155,156,-1,24,25,155,-1,155,25,26,-1,27,155,26,-1,27,28,155,-1,155,28,29,-1,154,29,30,-1,31,154,30,-1,31,32,154,-1,154,32,33,-1,34,154,33,-1,34,153,154,-1,34,35,153,-1,153,35,36,-1,152,36,37,-1,151,37,38,-1,150,38,39,-1,149,39,148,-1,149,150,39,-1,161,14,160,-1,158,21,157,-1,157,22,156,-1,155,29,154,-1,153,36,152,-1,152,37,151,-1,151,38,150,-1,148,39,147,-1,147,39,40,-1,146,40,145,-1,146,147,40,-1,41,143,40,-1,41,142,143,-1,41,141,142,-1,41,42,141,-1,141,42,140,-1,140,42,43,-1,139,43,138,-1,139,140,43,-1,44,136,43,-1,44,52,136,-1,44,51,52,-1,44,50,51,-1,44,49,50,-1,44,48,49,-1,44,47,48,-1,44,46,47,-1,44,45,46,-1,53,134,52,-1,53,58,134,-1,53,54,58,-1,58,54,57,-1,57,54,56,-1,56,54,55,-1,58,59,134,-1,134,59,60,-1,61,134,60,-1,61,62,134,-1,134,62,63,-1,64,134,63,-1,64,65,134,-1,134,65,67,-1,68,134,67,-1,68,69,134,-1,134,69,70,-1,71,134,70,-1,71,72,134,-1,134,72,73,-1,74,134,73,-1,74,133,134,-1,74,191,133,-1,74,75,191,-1,191,75,190,-1,190,75,189,-1,189,75,76,-1,188,76,77,-1,78,188,77,-1,78,187,188,-1,78,79,187,-1,187,79,186,-1,186,79,80,-1,81,186,80,-1,81,185,186,-1,81,82,185,-1,185,82,83,-1,184,83,84,-1,183,84,85,-1,182,85,181,-1,182,183,85,-1,65,66,67,-1,189,76,188,-1,185,83,184,-1,184,84,183,-1,85,86,181,-1,181,86,180,-1,180,86,179,-1,179,86,87,-1,88,179,87,-1,88,178,179,-1,88,177,178,-1,88,176,177,-1,88,89,176,-1,176,89,90,-1,91,176,90,-1,91,101,176,-1,91,92,101,-1,101,92,93,-1,94,101,93,-1,94,95,101,-1,101,95,96,-1,97,101,96,-1,97,98,101,-1,101,98,99,-1,100,101,99,-1,102,103,101,-1,101,103,104,-1,176,104,175,-1,176,101,104,-1,105,168,104,-1,105,221,168,-1,105,106,221,-1,221,106,220,-1,220,106,219,-1,219,106,107,-1,218,107,108,-1,217,108,109,-1,216,109,110,-1,111,216,110,-1,111,215,216,-1,111,112,215,-1,215,112,113,-1,214,113,114,-1,115,214,114,-1,115,116,214,-1,214,116,117,-1,118,214,117,-1,118,213,214,-1,118,119,213,-1,213,119,120,-1,219,107,218,-1,218,108,217,-1,217,109,216,-1,215,113,214,-1,167,129,11,-1,166,11,165,-1,166,167,11,-1,129,130,11,-1,11,130,131,-1,134,135,52,-1,52,135,136,-1,136,137,43,-1,43,137,138,-1,143,144,40,-1,40,144,145,-1,162,163,11,-1,11,163,164,-1,165,11,164,-1,168,169,104,-1,104,169,170,-1,171,104,170,-1,171,172,104,-1,104,172,173,-1,174,104,173,-1,174,175,104,-1,191,192,133,-1,133,192,193,-1,208,209,1,-1,1,209,210,-1,0,1,210,-1],solid=False,
          coord=Coordinate(point=[(0.08692,0.08478,0.1),(0.08308,0.08985,0.1),(0.0787,0.09452,0.1),(0.07393,0.09881,0.1),(0.06892,0.10278,0.1),(0.0632,0.10628,0.1),(0.05724,0.10939,0.1),(0.04492,0.11478,0.1),(0.03292,0.11778,0.1),(0.02092,0.12078,0.1),(0.02643,0.12237,0.1),(0.03181,0.12439,0.1),(0.037,0.12685,0.1),(0.04192,0.12978,0.1),(0.04483,0.13062,0.1),(0.0477,0.13168,0.1),(0.0505,0.13293,0.1),(0.05322,0.13437,0.1),(0.05583,0.13599,0.1),(0.05833,0.13777,0.1),(0.0607,0.13971,0.1),(0.06292,0.14178,0.1),(0.06929,0.14898,0.1),(0.07492,0.15678,0.1),(0.07741,0.16248,0.1),(0.0793,0.16845,0.1),(0.0805,0.17459,0.1),(0.08081,0.17768,0.1),(0.08092,0.18078,0.1),(0.08077,0.18435,0.1),(0.08031,0.18793,0.1),(0.07957,0.19149,0.1),(0.07855,0.19499,0.1),(0.07727,0.1984,0.1),(0.07573,0.20169,0.1),(0.07394,0.20483,0.1),(0.07192,0.20778,0.1),(0.06487,0.21714,0.1),(0.05692,0.22578,0.1),(0.04516,0.23093,0.1),(0.03292,0.23478,0.1),(0.02101,0.23701,0.1),(0.01497,0.23758,0.1),(0.00892,0.23778,0.1),(-0.10508,0.23778,0.1),(-0.10508,0.22578,0.1),(-0.10418,0.22501,0.1),(-0.10318,0.22437,0.1),(-0.10208,0.22385,0.1),(-0.10093,0.22344,0.1),(-0.09973,0.22314,0.1),(-0.09851,0.22293,0.1),(-0.09728,0.22281,0.1),(-0.09608,0.22278,0.1),(-0.09323,0.22153,0.1),(-0.09024,0.22059,0.1),(-0.08718,0.21999,0.1),(-0.08563,0.21983,0.1),(-0.08408,0.21978,0.1),(-0.08268,0.219,0.1),(-0.08134,0.2181,0.1),(-0.08007,0.2171,0.1),(-0.07887,0.21599,0.1),(-0.07776,0.21479,0.1),(-0.07675,0.21352,0.1),(-0.07586,0.21218,0.1),(-0.07508,0.21078,0.1),(-0.07431,0.20988,0.1),(-0.07367,0.20887,0.1),(-0.07315,0.20778,0.1),(-0.07274,0.20662,0.1),(-0.07244,0.20543,0.1),(-0.07223,0.2042,0.1),(-0.07212,0.20298,0.1),(-0.07208,0.20178,0.1),(-0.07208,0.02178,0.1),(-0.07214,0.01857,0.1),(-0.07226,0.01694,0.1),(-0.07249,0.01532,0.1),(-0.07285,0.01377,0.1),(-0.07309,0.01302,0.1),(-0.07338,0.0123,0.1),(-0.07372,0.01161,0.1),(-0.07411,0.01096,0.1),(-0.07457,0.01035,0.1),(-0.07508,0.00978,0.1),(-0.07711,0.00799,0.1),(-0.07933,0.00643,0.1),(-0.08408,0.00378,0.1),(-0.08465,0.00326,0.1),(-0.08526,0.00281,0.1),(-0.08592,0.00242,0.1),(-0.08661,0.00208,0.1),(-0.08732,0.00179,0.1),(-0.08807,0.00155,0.1),(-0.08963,0.00118,0.1),(-0.09124,9.6E-4,0.1),(-0.09288,8.4E-4,0.1),(-0.09608,7.8E-4,0.1),(-0.10058,7.8E-4,0.1),(-0.10508,7.8E-4,0.1),(-0.10508,-0.01122,0.1),(0.01192,-0.01122,0.1),(0.02699,-0.01046,0.1),(0.04192,-0.00822,0.1),(0.0491,-0.00636,0.1),(0.05609,-0.00371,0.1),(0.06274,-3.2E-4,0.1),(0.06892,0.00378,0.1),(0.07426,0.00823,0.1),(0.07914,0.01326,0.1),(0.08341,0.0188,0.1),(0.08527,0.02173,0.1),(0.08692,0.02478,0.1),(0.08911,0.02804,0.1),(0.09097,0.03152,0.1),(0.09252,0.03519,0.1),(0.09377,0.03899,0.1),(0.09472,0.0429,0.1),(0.09539,0.04686,0.1),(0.09579,0.05083,0.1),(0.09592,0.05478,0.1),(0.09579,0.05872,0.1),(0.09539,0.06269,0.1),(0.09472,0.06666,0.1),(0.09377,0.07056,0.1),(0.09252,0.07437,0.1),(0.09097,0.07803,0.1),(0.08911,0.08152,0.1),(0.00892,0.12978,0.1),(0.00308,0.12823,0.1),(-0.00292,0.12732,0.1),(-0.01508,0.12678,0.1),(-0.03608,0.12678,0.1),(-0.03608,0.22278,0.1),(-0.02408,0.22278,0.1),(-0.00908,0.22278,0.1),(-0.00427,0.22263,0.1),(6.2E-4,0.22216,0.1),(0.00551,0.22134,0.1),(0.01031,0.22013,0.1),(0.01493,0.2185,0.1),(0.0193,0.21643,0.1),(0.02136,0.21521,0.1),(0.02332,0.21386,0.1),(0.02518,0.21239,0.1),(0.02692,0.21078,0.1),(0.02842,0.20917,0.1),(0.02981,0.20746,0.1),(0.03229,0.20378,0.1),(0.03435,0.19979,0.1),(0.03602,0.19556,0.1),(0.03731,0.19118,0.1),(0.03821,0.18671,0.1),(0.03874,0.18222,0.1),(0.03892,0.17778,0.1),(0.03877,0.17246,0.1),(0.03826,0.16714,0.1),(0.03733,0.16189,0.1),(0.03592,0.15678,0.1),(0.03414,0.15206,0.1),(0.03202,0.14748,0.1),(0.02692,0.13878,0.1),(0.02505,0.1371,0.1),(0.02302,0.1356,0.1),(0.02086,0.13427,0.1),(0.01858,0.13311,0.1),(0.01381,0.1312,0.1),(0.03892,0.01578,0.1),(0.03673,0.01414,0.1),(0.03445,0.01265,0.1),(0.02961,0.01007,0.1),(0.02447,0.00798,0.1),(0.01912,0.00637,0.1),(0.01361,0.00518,0.1),(0.00803,0.00437,0.1),(-0.00308,0.00378,0.1),(-0.01524,0.00432,0.1),(-0.02124,0.00523,0.1),(-0.02708,0.00678,0.1),(-0.0281,0.00752,0.1),(-0.02907,0.00834,0.1),(-0.02998,0.00925,0.1),(-0.03084,0.01022,0.1),(-0.03164,0.01125,0.1),(-0.03238,0.01234,0.1),(-0.03367,0.01466,0.1),(-0.0347,0.01712,0.1),(-0.03546,0.01966,0.1),(-0.03592,0.02223,0.1),(-0.03608,0.02478,0.1),(-0.03608,0.11178,0.1),(-0.02708,0.11178,0.1),(-0.00608,0.11178,0.1),(-4.4E-4,0.11156,0.1),(0.00528,0.11091,0.1),(0.01097,0.1098,0.1),(0.01655,0.10822,0.1),(0.02193,0.10614,0.1),(0.02701,0.10356,0.1),(0.03171,0.10044,0.1),(0.03388,0.09868,0.1),(0.03592,0.09678,0.1),(0.03965,0.09331,0.1),(0.04308,0.08942,0.1),(0.04614,0.08515,0.1),(0.04878,0.08059,0.1),(0.05094,0.0758,0.1),(0.05256,0.07085,0.1),(0.05314,0.06835,0.1),(0.05357,0.06582,0.1),(0.05383,0.0633,0.1),(0.05392,0.06078,0.1),(0.05373,0.05476,0.1),(0.05315,0.04865,0.1),(0.05212,0.04254,0.1),(0.05061,0.03654,0.1),(0.04858,0.03076,0.1),(0.04598,0.0253,0.1),(0.04446,0.02273,0.1),(0.04277,0.02027,0.1),(0.04093,0.01795,0.1)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(DEF='baseplateAppearance',
          material=Material(ambientIntensity=1.0,diffuseColor=(1.0,1.0,1.0),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[102,0,105,-1,101,105,100,-1,101,102,105,-1,2,104,1,-1,2,3,104,-1,104,3,4,-1,138,4,5,-1,137,5,6,-1,136,6,7,-1,135,7,8,-1,134,8,9,-1,133,9,10,-1,11,133,10,-1,11,132,133,-1,11,12,132,-1,132,12,131,-1,131,12,13,-1,130,13,14,-1,129,14,15,-1,128,15,16,-1,127,16,17,-1,18,127,17,-1,18,19,127,-1,127,19,1169,-1,500,1169,1170,-1,1171,500,1170,-1,1171,850,500,-1,500,850,499,-1,499,850,498,-1,498,850,497,-1,497,850,496,-1,496,850,851,-1,852,496,851,-1,852,853,496,-1,496,853,854,-1,832,854,831,-1,832,496,854,-1,832,495,496,-1,832,494,495,-1,832,493,494,-1,832,492,493,-1,832,491,492,-1,832,490,491,-1,832,489,490,-1,832,833,489,-1,489,833,488,-1,488,833,834,-1,835,488,834,-1,835,487,488,-1,835,486,487,-1,835,836,486,-1,486,836,485,-1,485,836,484,-1,484,836,483,-1,483,836,482,-1,482,836,481,-1,481,836,480,-1,480,836,479,-1,479,836,478,-1,478,836,477,-1,477,836,476,-1,476,836,475,-1,475,836,474,-1,474,836,837,-1,473,837,472,-1,473,474,837,-1,104,4,138,-1,139,104,138,-1,139,140,104,-1,104,140,141,-1,142,104,141,-1,142,143,104,-1,104,143,144,-1,145,104,144,-1,145,146,104,-1,104,146,147,-1,148,104,147,-1,148,149,104,-1,104,149,150,-1,151,104,150,-1,151,152,104,-1,104,152,153,-1,154,104,153,-1,154,155,104,-1,104,155,267,-1,268,104,267,-1,268,103,104,-1,268,269,103,-1,103,269,270,-1,597,270,596,-1,597,103,270,-1,597,637,103,-1,597,598,637,-1,637,598,599,-1,636,599,600,-1,601,636,600,-1,601,602,636,-1,636,602,603,-1,604,636,603,-1,604,635,636,-1,604,605,635,-1,635,605,606,-1,607,635,606,-1,607,608,635,-1,635,608,782,-1,783,635,782,-1,783,784,635,-1,635,784,785,-1,786,635,785,-1,786,787,635,-1,635,787,788,-1,789,635,788,-1,789,790,635,-1,635,790,791,-1,792,635,791,-1,138,5,137,-1,137,6,136,-1,136,7,135,-1,135,8,134,-1,134,9,133,-1,131,13,130,-1,130,14,129,-1,129,15,128,-1,128,16,127,-1,20,1163,19,-1,20,1162,1163,-1,20,1161,1162,-1,20,1160,1161,-1,20,1159,1160,-1,20,48,1159,-1,20,47,48,-1,20,46,47,-1,20,45,46,-1,20,44,45,-1,20,40,44,-1,20,29,40,-1,20,21,29,-1,29,21,22,-1,23,29,22,-1,23,24,29,-1,29,24,25,-1,26,29,25,-1,26,28,29,-1,26,27,28,-1,30,31,29,-1,29,31,32,-1,33,29,32,-1,33,34,29,-1,29,34,35,-1,36,29,35,-1,36,37,29,-1,29,37,38,-1,39,29,38,-1,39,40,29,-1,41,42,40,-1,40,42,43,-1,44,40,43,-1,49,1149,48,-1,49,1148,1149,-1,49,1147,1148,-1,49,1146,1147,-1,49,1145,1146,-1,49,1128,1145,-1,49,1127,1128,-1,49,1126,1127,-1,49,1125,1126,-1,49,1124,1125,-1,49,1123,1124,-1,49,1122,1123,-1,49,1121,1122,-1,49,1120,1121,-1,49,1119,1120,-1,49,73,1119,-1,49,72,73,-1,49,50,72,-1,72,50,57,-1,71,57,58,-1,59,71,58,-1,59,60,71,-1,71,60,61,-1,62,71,61,-1,62,63,71,-1,71,63,64,-1,65,71,64,-1,65,70,71,-1,65,66,70,-1,70,66,69,-1,69,66,68,-1,68,66,67,-1,50,51,57,-1,57,51,52,-1,53,57,52,-1,53,54,57,-1,57,54,55,-1,56,57,55,-1,72,57,71,-1,73,74,1119,-1,1119,74,1118,-1,1118,74,75,-1,1117,75,76,-1,1116,76,77,-1,1115,77,78,-1,1114,78,1113,-1,1114,1115,78,-1,1118,75,1117,-1,1117,76,1116,-1,1116,77,1115,-1,79,1111,78,-1,79,1110,1111,-1,79,1109,1110,-1,79,1107,1109,-1,79,1106,1107,-1,79,1105,1106,-1,79,1104,1105,-1,79,1103,1104,-1,79,1102,1103,-1,79,1101,1102,-1,79,1261,1101,-1,79,106,1261,-1,79,80,106,-1,106,80,105,-1,105,80,81,-1,82,105,81,-1,82,83,105,-1,105,83,85,-1,86,105,85,-1,86,87,105,-1,105,87,88,-1,89,105,88,-1,89,90,105,-1,105,90,91,-1,92,105,91,-1,92,93,105,-1,105,93,94,-1,95,105,94,-1,95,96,105,-1,105,96,97,-1,98,105,97,-1,98,99,105,-1,105,99,100,-1,83,84,85,-1,104,105,1,-1,1,105,0,-1,103,1353,106,-1,103,1333,1353,-1,103,1332,1333,-1,103,254,1332,-1,103,253,254,-1,103,252,253,-1,103,251,252,-1,103,250,251,-1,103,249,250,-1,103,248,249,-1,103,247,248,-1,103,246,247,-1,103,245,246,-1,103,244,245,-1,103,243,244,-1,103,242,243,-1,103,241,242,-1,103,240,241,-1,103,637,240,-1,240,637,638,-1,639,240,638,-1,639,640,240,-1,240,640,641,-1,642,240,641,-1,642,643,240,-1,240,643,645,-1,646,240,645,-1,646,649,240,-1,646,647,649,-1,649,647,648,-1,108,560,107,-1,108,559,560,-1,108,558,559,-1,108,109,558,-1,558,109,557,-1,557,109,556,-1,556,109,110,-1,555,110,554,-1,555,556,110,-1,110,111,554,-1,554,111,553,-1,553,111,552,-1,552,111,112,-1,551,112,550,-1,551,552,112,-1,550,112,185,-1,186,550,185,-1,186,549,550,-1,186,548,549,-1,186,547,548,-1,186,546,547,-1,186,545,546,-1,186,544,545,-1,186,543,544,-1,186,542,543,-1,186,541,542,-1,186,540,541,-1,186,539,540,-1,186,538,539,-1,186,537,538,-1,186,536,537,-1,186,535,536,-1,186,534,535,-1,186,533,534,-1,186,532,533,-1,186,187,532,-1,532,187,188,-1,189,532,188,-1,189,190,532,-1,532,190,530,-1,531,532,530,-1,112,113,185,-1,185,113,114,-1,184,114,183,-1,184,185,114,-1,183,114,182,-1,182,114,115,-1,181,115,180,-1,181,182,115,-1,116,176,115,-1,116,175,176,-1,116,174,175,-1,116,173,174,-1,116,172,173,-1,116,171,172,-1,116,170,171,-1,116,169,170,-1,116,117,169,-1,169,117,168,-1,168,117,167,-1,167,117,166,-1,166,117,165,-1,165,117,164,-1,164,117,163,-1,163,117,162,-1,162,117,161,-1,161,117,160,-1,160,117,159,-1,159,117,118,-1,119,159,118,-1,119,120,159,-1,159,120,509,-1,510,159,509,-1,510,511,159,-1,159,511,512,-1,212,512,513,-1,514,212,513,-1,514,515,212,-1,212,515,516,-1,517,212,516,-1,517,211,212,-1,517,518,211,-1,211,518,210,-1,210,518,519,-1,520,210,519,-1,520,209,210,-1,520,208,209,-1,520,521,208,-1,208,521,207,-1,207,521,522,-1,206,522,205,-1,206,207,522,-1,120,121,509,-1,509,121,508,-1,508,121,507,-1,507,121,122,-1,506,122,505,-1,506,507,122,-1,122,123,505,-1,505,123,504,-1,504,123,502,-1,503,504,502,-1,502,123,501,-1,501,123,124,-1,500,124,125,-1,126,500,125,-1,126,127,500,-1,500,127,1169,-1,501,124,500,-1,155,156,267,-1,267,156,157,-1,158,267,157,-1,158,107,267,-1,267,107,566,-1,566,107,565,-1,565,107,564,-1,564,107,563,-1,563,107,562,-1,562,107,561,-1,561,107,560,-1,176,177,115,-1,115,177,178,-1,179,115,178,-1,179,180,115,-1,530,190,529,-1,529,190,191,-1,528,191,192,-1,193,528,192,-1,193,194,528,-1,528,194,527,-1,527,194,195,-1,196,527,195,-1,196,526,527,-1,196,197,526,-1,526,197,198,-1,525,198,199,-1,200,525,199,-1,200,524,525,-1,200,201,524,-1,524,201,202,-1,523,202,203,-1,204,523,203,-1,204,205,523,-1,523,205,522,-1,529,191,528,-1,526,198,525,-1,524,202,523,-1,212,159,512,-1,214,657,213,-1,214,215,657,-1,657,215,216,-1,217,657,216,-1,217,218,657,-1,657,218,219,-1,220,657,219,-1,220,655,657,-1,220,653,655,-1,220,652,653,-1,220,221,652,-1,652,221,222,-1,223,652,222,-1,223,224,652,-1,652,224,225,-1,226,652,225,-1,226,227,652,-1,652,227,228,-1,229,652,228,-1,229,230,652,-1,652,230,231,-1,232,652,231,-1,232,233,652,-1,652,233,234,-1,235,652,234,-1,235,236,652,-1,652,236,237,-1,238,652,237,-1,238,239,652,-1,652,239,240,-1,651,240,650,-1,651,652,240,-1,254,255,1332,-1,1332,255,256,-1,257,1332,256,-1,257,258,1332,-1,1332,258,259,-1,260,1332,259,-1,260,261,1332,-1,1332,261,262,-1,263,1332,262,-1,263,264,1332,-1,1332,264,265,-1,266,1332,265,-1,266,213,1332,-1,1332,213,731,-1,732,1332,731,-1,732,734,1332,-1,732,733,734,-1,271,272,270,-1,270,272,596,-1,596,272,273,-1,274,596,273,-1,274,275,596,-1,596,275,276,-1,277,596,276,-1,277,278,596,-1,596,278,279,-1,280,596,279,-1,280,281,596,-1,596,281,282,-1,283,596,282,-1,283,284,596,-1,596,284,285,-1,286,596,285,-1,286,595,596,-1,286,795,595,-1,286,794,795,-1,286,287,794,-1,794,287,288,-1,289,794,288,-1,289,290,794,-1,794,290,291,-1,292,794,291,-1,292,793,794,-1,292,293,793,-1,793,293,294,-1,295,793,294,-1,295,296,793,-1,793,296,297,-1,298,793,297,-1,298,299,793,-1,793,299,300,-1,369,300,301,-1,302,369,301,-1,302,303,369,-1,369,303,304,-1,305,369,304,-1,305,306,369,-1,369,306,307,-1,308,369,307,-1,308,310,369,-1,308,309,310,-1,793,300,369,-1,370,793,369,-1,370,371,793,-1,793,371,392,-1,837,392,393,-1,472,393,471,-1,472,837,393,-1,310,311,369,-1,369,311,312,-1,313,369,312,-1,313,368,369,-1,313,314,368,-1,368,314,367,-1,367,314,315,-1,366,315,365,-1,366,367,315,-1,365,315,364,-1,364,315,316,-1,363,316,362,-1,363,364,316,-1,316,317,362,-1,362,317,318,-1,361,318,360,-1,361,362,318,-1,360,318,359,-1,359,318,319,-1,358,319,357,-1,358,359,319,-1,320,348,319,-1,320,334,348,-1,320,333,334,-1,320,321,333,-1,333,321,322,-1,332,322,323,-1,328,323,327,-1,328,332,323,-1,328,329,332,-1,332,329,331,-1,331,329,330,-1,333,322,332,-1,327,323,326,-1,326,323,324,-1,325,326,324,-1,334,335,348,-1,348,335,347,-1,347,335,346,-1,346,335,336,-1,337,346,336,-1,337,338,346,-1,346,338,339,-1,340,346,339,-1,340,345,346,-1,340,344,345,-1,340,341,344,-1,344,341,343,-1,343,341,342,-1,349,350,348,-1,348,350,351,-1,352,348,351,-1,352,353,348,-1,348,353,354,-1,355,348,354,-1,355,319,348,-1,355,356,319,-1,319,356,357,-1,371,372,392,-1,392,372,373,-1,374,392,373,-1,374,375,392,-1,392,375,376,-1,384,376,383,-1,384,392,376,-1,384,390,392,-1,384,389,390,-1,384,388,389,-1,384,387,388,-1,384,386,387,-1,384,385,386,-1,377,378,376,-1,376,378,379,-1,380,376,379,-1,380,381,376,-1,376,381,382,-1,383,376,382,-1,390,391,392,-1,793,392,837,-1,848,837,838,-1,839,848,838,-1,839,840,848,-1,848,840,847,-1,847,840,841,-1,842,847,841,-1,842,843,847,-1,847,843,844,-1,845,847,844,-1,845,846,847,-1,394,464,393,-1,394,395,464,-1,464,395,396,-1,397,464,396,-1,397,398,464,-1,464,398,399,-1,400,464,399,-1,400,401,464,-1,464,401,402,-1,403,464,402,-1,403,404,464,-1,464,404,405,-1,463,405,462,-1,463,464,405,-1,405,406,462,-1,462,406,407,-1,461,407,408,-1,460,408,409,-1,459,409,410,-1,458,410,457,-1,458,459,410,-1,462,407,461,-1,461,408,460,-1,460,409,459,-1,410,411,457,-1,457,411,456,-1,456,411,455,-1,455,411,412,-1,454,412,413,-1,453,413,414,-1,452,414,415,-1,451,415,416,-1,450,416,417,-1,449,417,418,-1,448,418,419,-1,441,419,420,-1,421,441,420,-1,421,422,441,-1,441,422,423,-1,424,441,423,-1,424,425,441,-1,441,425,426,-1,427,441,426,-1,427,440,441,-1,427,428,440,-1,440,428,439,-1,439,428,429,-1,430,439,429,-1,430,431,439,-1,439,431,432,-1,438,432,437,-1,438,439,432,-1,455,412,454,-1,454,413,453,-1,453,414,452,-1,452,415,451,-1,451,416,450,-1,450,417,449,-1,449,418,448,-1,448,419,441,-1,442,448,441,-1,442,443,448,-1,448,443,447,-1,447,443,444,-1,445,447,444,-1,445,446,447,-1,433,434,432,-1,432,434,435,-1,436,432,435,-1,436,437,432,-1,464,465,393,-1,393,465,466,-1,467,393,466,-1,467,468,393,-1,393,468,469,-1,470,393,469,-1,470,471,393,-1,634,567,821,-1,633,821,632,-1,633,634,821,-1,569,820,568,-1,569,570,820,-1,820,570,571,-1,572,820,571,-1,572,573,820,-1,820,573,819,-1,819,573,574,-1,575,819,574,-1,575,576,819,-1,819,576,818,-1,818,576,577,-1,578,818,577,-1,578,579,818,-1,818,579,580,-1,581,818,580,-1,581,582,818,-1,818,582,796,-1,797,818,796,-1,797,817,818,-1,797,816,817,-1,797,815,816,-1,797,814,815,-1,797,811,814,-1,797,803,811,-1,797,802,803,-1,797,801,802,-1,797,800,801,-1,797,799,800,-1,797,798,799,-1,582,583,796,-1,796,583,584,-1,585,796,584,-1,585,586,796,-1,796,586,587,-1,795,587,588,-1,589,795,588,-1,589,590,795,-1,795,590,591,-1,592,795,591,-1,592,593,795,-1,795,593,594,-1,595,795,594,-1,796,587,795,-1,637,599,636,-1,782,608,781,-1,781,608,609,-1,780,609,779,-1,780,781,609,-1,779,609,778,-1,778,609,610,-1,777,610,776,-1,777,778,610,-1,611,772,610,-1,611,771,772,-1,611,770,771,-1,611,769,770,-1,611,768,769,-1,611,767,768,-1,611,766,767,-1,611,612,766,-1,766,612,765,-1,765,612,764,-1,764,612,763,-1,763,612,613,-1,762,613,761,-1,762,763,613,-1,761,613,760,-1,760,613,614,-1,759,614,758,-1,759,760,614,-1,614,615,758,-1,758,615,757,-1,757,615,756,-1,756,615,616,-1,755,616,617,-1,754,617,753,-1,754,755,617,-1,756,616,755,-1,617,618,753,-1,753,618,752,-1,752,618,751,-1,751,618,750,-1,750,618,749,-1,749,618,619,-1,748,619,620,-1,747,620,621,-1,622,747,621,-1,622,746,747,-1,622,623,746,-1,746,623,745,-1,745,623,744,-1,744,623,624,-1,743,624,625,-1,742,625,854,-1,1332,854,1331,-1,1332,742,854,-1,1332,741,742,-1,1332,740,741,-1,1332,739,740,-1,1332,738,739,-1,1332,737,738,-1,1332,736,737,-1,1332,735,736,-1,1332,734,735,-1,749,619,748,-1,748,620,747,-1,744,624,743,-1,854,625,831,-1,831,625,626,-1,627,831,626,-1,627,628,831,-1,831,628,629,-1,630,831,629,-1,630,821,831,-1,630,631,821,-1,821,631,632,-1,643,644,645,-1,649,650,240,-1,653,654,655,-1,655,656,657,-1,213,657,712,-1,713,213,712,-1,713,714,213,-1,213,714,715,-1,716,213,715,-1,716,717,213,-1,213,717,718,-1,719,213,718,-1,719,720,213,-1,213,720,721,-1,722,213,721,-1,722,723,213,-1,213,723,724,-1,725,213,724,-1,725,726,213,-1,213,726,727,-1,728,213,727,-1,728,729,213,-1,213,729,730,-1,731,213,730,-1,657,658,712,-1,712,658,659,-1,711,659,710,-1,711,712,659,-1,660,701,659,-1,660,700,701,-1,660,699,700,-1,660,661,699,-1,699,661,698,-1,698,661,697,-1,697,661,662,-1,696,662,663,-1,695,663,664,-1,694,664,665,-1,693,665,666,-1,692,666,667,-1,668,692,667,-1,668,669,692,-1,692,669,670,-1,671,692,670,-1,671,672,692,-1,692,672,691,-1,691,672,688,-1,690,688,689,-1,690,691,688,-1,697,662,696,-1,696,663,695,-1,695,664,694,-1,694,665,693,-1,693,666,692,-1,672,673,688,-1,688,673,674,-1,687,674,675,-1,676,687,675,-1,676,686,687,-1,676,677,686,-1,686,677,678,-1,679,686,678,-1,679,680,686,-1,686,680,685,-1,685,680,684,-1,684,680,683,-1,683,680,681,-1,682,683,681,-1,688,674,687,-1,701,702,659,-1,659,702,703,-1,704,659,703,-1,704,705,659,-1,659,705,706,-1,707,659,706,-1,707,708,659,-1,659,708,709,-1,710,659,709,-1,742,743,625,-1,772,773,610,-1,610,773,774,-1,775,610,774,-1,775,776,610,-1,804,805,803,-1,803,805,806,-1,807,803,806,-1,807,808,803,-1,803,808,809,-1,810,803,809,-1,810,811,803,-1,812,813,811,-1,811,813,814,-1,820,821,568,-1,568,821,567,-1,822,829,821,-1,822,828,829,-1,822,827,828,-1,822,826,827,-1,822,823,826,-1,826,823,824,-1,825,826,824,-1,829,830,821,-1,821,830,831,-1,793,837,848,-1,849,793,848,-1,855,1406,854,-1,855,856,1406,-1,1406,856,1405,-1,1405,856,1204,-1,1205,1405,1204,-1,1205,1404,1405,-1,1205,1229,1404,-1,1205,1228,1229,-1,1205,1227,1228,-1,1205,1217,1227,-1,1205,1216,1217,-1,1205,1206,1216,-1,1216,1206,1207,-1,1208,1216,1207,-1,1208,1215,1216,-1,1208,1214,1215,-1,1208,1213,1214,-1,1208,1212,1213,-1,1208,1211,1212,-1,1208,1210,1211,-1,1208,1209,1210,-1,857,1200,856,-1,857,1199,1200,-1,857,858,1199,-1,1199,858,1198,-1,1198,858,859,-1,1197,859,860,-1,861,1197,860,-1,861,1196,1197,-1,861,862,1196,-1,1196,862,1195,-1,1195,862,863,-1,1194,863,1193,-1,1194,1195,863,-1,1198,859,1197,-1,863,864,1193,-1,1193,864,1192,-1,1192,864,1191,-1,1191,864,865,-1,1190,865,866,-1,1189,866,867,-1,1188,867,868,-1,1187,868,869,-1,870,1187,869,-1,870,1186,1187,-1,870,871,1186,-1,1186,871,872,-1,1185,872,873,-1,874,1185,873,-1,874,1184,1185,-1,874,875,1184,-1,1184,875,879,-1,1183,879,880,-1,881,1183,880,-1,881,1182,1183,-1,881,882,1182,-1,1182,882,883,-1,1181,883,884,-1,885,1181,884,-1,885,1180,1181,-1,885,886,1180,-1,1180,886,1179,-1,1179,886,887,-1,1178,887,888,-1,889,1178,888,-1,889,1177,1178,-1,889,991,1177,-1,889,890,991,-1,991,890,891,-1,892,991,891,-1,892,893,991,-1,991,893,989,-1,990,991,989,-1,1191,865,1190,-1,1190,866,1189,-1,1189,867,1188,-1,1188,868,1187,-1,1186,872,1185,-1,879,875,878,-1,878,875,876,-1,877,878,876,-1,1184,879,1183,-1,1182,883,1181,-1,1179,887,1178,-1,894,966,893,-1,894,895,966,-1,966,895,896,-1,897,966,896,-1,897,898,966,-1,966,898,899,-1,900,966,899,-1,900,901,966,-1,966,901,902,-1,904,902,903,-1,904,966,902,-1,904,905,966,-1,966,905,906,-1,907,966,906,-1,907,908,966,-1,966,908,965,-1,965,908,909,-1,910,965,909,-1,910,964,965,-1,910,911,964,-1,964,911,963,-1,963,911,912,-1,962,912,961,-1,962,963,912,-1,912,913,961,-1,961,913,960,-1,960,913,959,-1,959,913,914,-1,915,959,914,-1,915,958,959,-1,915,957,958,-1,915,956,957,-1,915,916,956,-1,956,916,955,-1,955,916,954,-1,954,916,953,-1,953,916,952,-1,952,916,945,-1,951,945,950,-1,951,952,945,-1,916,917,945,-1,945,917,931,-1,932,945,931,-1,932,944,945,-1,932,943,944,-1,932,933,943,-1,943,933,934,-1,935,943,934,-1,935,936,943,-1,943,936,937,-1,942,937,941,-1,942,943,937,-1,931,917,930,-1,930,917,918,-1,919,930,918,-1,919,929,930,-1,919,920,929,-1,929,920,925,-1,926,929,925,-1,926,928,929,-1,926,927,928,-1,921,923,920,-1,921,922,923,-1,923,924,920,-1,920,924,925,-1,937,938,941,-1,941,938,940,-1,940,938,939,-1,946,947,945,-1,945,947,948,-1,949,945,948,-1,949,950,945,-1,966,967,893,-1,893,967,968,-1,969,893,968,-1,969,970,893,-1,893,970,971,-1,972,893,971,-1,972,973,893,-1,893,973,983,-1,989,983,988,-1,989,893,983,-1,974,975,973,-1,973,975,976,-1,977,973,976,-1,977,978,973,-1,973,978,979,-1,980,973,979,-1,980,981,973,-1,973,981,982,-1,983,973,982,-1,984,985,983,-1,983,985,986,-1,987,983,986,-1,987,988,983,-1,992,1070,991,-1,992,1069,1070,-1,992,1068,1069,-1,992,1067,1068,-1,992,1066,1067,-1,992,1065,1066,-1,992,1064,1065,-1,992,993,1064,-1,1064,993,994,-1,995,1064,994,-1,995,996,1064,-1,1064,996,997,-1,998,1064,997,-1,998,999,1064,-1,1064,999,1000,-1,1001,1064,1000,-1,1001,1002,1064,-1,1064,1002,1003,-1,1004,1064,1003,-1,1004,1063,1064,-1,1004,1005,1063,-1,1063,1005,1006,-1,1062,1006,1007,-1,1061,1007,1008,-1,1060,1008,1009,-1,1059,1009,1058,-1,1059,1060,1009,-1,1063,1006,1062,-1,1062,1007,1061,-1,1061,1008,1060,-1,1009,1010,1058,-1,1058,1010,1057,-1,1057,1010,1056,-1,1056,1010,1055,-1,1055,1010,1011,-1,1054,1011,1053,-1,1054,1055,1011,-1,1011,1012,1053,-1,1053,1012,1052,-1,1052,1012,1013,-1,1051,1013,1014,-1,1050,1014,1015,-1,1049,1015,1016,-1,1048,1016,1017,-1,1047,1017,1018,-1,1040,1018,1019,-1,1020,1040,1019,-1,1020,1021,1040,-1,1040,1021,1022,-1,1023,1040,1022,-1,1023,1024,1040,-1,1040,1024,1025,-1,1026,1040,1025,-1,1026,1039,1040,-1,1026,1027,1039,-1,1039,1027,1038,-1,1038,1027,1028,-1,1029,1038,1028,-1,1029,1030,1038,-1,1038,1030,1031,-1,1037,1031,1036,-1,1037,1038,1031,-1,1052,1013,1051,-1,1051,1014,1050,-1,1050,1015,1049,-1,1049,1016,1048,-1,1048,1017,1047,-1,1047,1018,1040,-1,1041,1047,1040,-1,1041,1042,1047,-1,1047,1042,1046,-1,1046,1042,1043,-1,1044,1046,1043,-1,1044,1045,1046,-1,1032,1033,1031,-1,1031,1033,1034,-1,1035,1031,1034,-1,1035,1036,1031,-1,1071,1281,1070,-1,1071,1072,1281,-1,1281,1072,1073,-1,1074,1281,1073,-1,1074,1075,1281,-1,1281,1075,1076,-1,1077,1281,1076,-1,1077,1078,1281,-1,1281,1078,1079,-1,1080,1281,1079,-1,1080,1081,1281,-1,1281,1081,1280,-1,1280,1081,1082,-1,1083,1280,1082,-1,1083,1279,1280,-1,1083,1084,1279,-1,1279,1084,1085,-1,1086,1279,1085,-1,1086,1278,1279,-1,1086,1087,1278,-1,1278,1087,1277,-1,1277,1087,1088,-1,1276,1088,1275,-1,1276,1277,1088,-1,1088,1089,1275,-1,1275,1089,1274,-1,1274,1089,1090,-1,1273,1090,1091,-1,1272,1091,1092,-1,1271,1092,1270,-1,1271,1272,1092,-1,1274,1090,1273,-1,1273,1091,1272,-1,1270,1092,1269,-1,1269,1092,1093,-1,1268,1093,1267,-1,1268,1269,1093,-1,1093,1094,1267,-1,1267,1094,1266,-1,1266,1094,1095,-1,1096,1266,1095,-1,1096,1265,1266,-1,1096,1097,1265,-1,1265,1097,1264,-1,1264,1097,1098,-1,1099,1264,1098,-1,1099,1263,1264,-1,1099,1100,1263,-1,1263,1100,1262,-1,1262,1100,1101,-1,1261,1262,1101,-1,1107,1108,1109,-1,1111,1112,78,-1,78,1112,1113,-1,1128,1129,1145,-1,1145,1129,1144,-1,1144,1129,1143,-1,1143,1129,1130,-1,1131,1143,1130,-1,1131,1142,1143,-1,1131,1132,1142,-1,1142,1132,1141,-1,1141,1132,1133,-1,1140,1133,1134,-1,1139,1134,1135,-1,1138,1135,1136,-1,1137,1138,1136,-1,1141,1133,1140,-1,1140,1134,1139,-1,1139,1135,1138,-1,1149,1150,48,-1,48,1150,1151,-1,1152,48,1151,-1,1152,1153,48,-1,48,1153,1154,-1,1155,48,1154,-1,1155,1156,48,-1,48,1156,1157,-1,1158,48,1157,-1,1158,1159,48,-1,1163,1164,19,-1,19,1164,1165,-1,1166,19,1165,-1,1166,1167,19,-1,19,1167,1168,-1,1169,19,1168,-1,1173,1283,1172,-1,1173,1282,1283,-1,1173,1174,1282,-1,1282,1174,1070,-1,1281,1282,1070,-1,1174,1175,1070,-1,1070,1175,1176,-1,991,1176,1177,-1,991,1070,1176,-1,1200,1201,856,-1,856,1201,1202,-1,1203,856,1202,-1,1203,1204,856,-1,1218,1225,1217,-1,1218,1224,1225,-1,1218,1223,1224,-1,1218,1222,1223,-1,1218,1221,1222,-1,1218,1219,1221,-1,1221,1219,1220,-1,1225,1226,1217,-1,1217,1226,1227,-1,1229,1230,1404,-1,1404,1230,1469,-1,1507,1469,1470,-1,1471,1507,1470,-1,1471,1472,1507,-1,1507,1472,1506,-1,1506,1472,1473,-1,1484,1473,1474,-1,1475,1484,1474,-1,1475,1476,1484,-1,1484,1476,1477,-1,1483,1477,1478,-1,1479,1483,1478,-1,1479,1480,1483,-1,1483,1480,1481,-1,1482,1483,1481,-1,1231,1249,1230,-1,1231,1232,1249,-1,1249,1232,1238,-1,1239,1249,1238,-1,1239,1240,1249,-1,1249,1240,1241,-1,1248,1241,1242,-1,1243,1248,1242,-1,1243,1244,1248,-1,1248,1244,1247,-1,1247,1244,1245,-1,1246,1247,1245,-1,1232,1233,1238,-1,1238,1233,1234,-1,1235,1238,1234,-1,1235,1236,1238,-1,1238,1236,1237,-1,1249,1241,1248,-1,1249,1250,1230,-1,1230,1250,1254,-1,1469,1254,1255,-1,1256,1469,1255,-1,1256,1257,1469,-1,1469,1257,1258,-1,1468,1258,1259,-1,1260,1468,1259,-1,1260,106,1468,-1,1260,1261,106,-1,1251,1252,1250,-1,1250,1252,1253,-1,1254,1250,1253,-1,1230,1254,1469,-1,1469,1258,1468,-1,1283,1284,1172,-1,1172,1284,1299,-1,1299,1284,1285,-1,1286,1299,1285,-1,1286,1298,1299,-1,1286,1287,1298,-1,1298,1287,1288,-1,1297,1288,1289,-1,1290,1297,1289,-1,1290,1291,1297,-1,1297,1291,1292,-1,1296,1292,1293,-1,1294,1296,1293,-1,1294,1295,1296,-1,1298,1288,1297,-1,1297,1292,1296,-1,1301,1466,1300,-1,1301,1465,1466,-1,1301,1464,1465,-1,1301,1302,1464,-1,1464,1302,1463,-1,1463,1302,1462,-1,1462,1302,1461,-1,1461,1302,1303,-1,1460,1303,1459,-1,1460,1461,1303,-1,1459,1303,1309,-1,1451,1309,1432,-1,1433,1451,1432,-1,1433,1434,1451,-1,1451,1434,1435,-1,1436,1451,1435,-1,1436,1440,1451,-1,1436,1437,1440,-1,1440,1437,1438,-1,1439,1440,1438,-1,1305,1307,1304,-1,1305,1306,1307,-1,1307,1308,1304,-1,1304,1308,1309,-1,1303,1304,1309,-1,1432,1309,1319,-1,1322,1319,1321,-1,1322,1432,1319,-1,1322,1323,1432,-1,1432,1323,1324,-1,1325,1432,1324,-1,1325,1431,1432,-1,1325,1326,1431,-1,1431,1326,1327,-1,1407,1327,1328,-1,1406,1328,854,-1,1406,1407,1328,-1,1309,1310,1319,-1,1319,1310,1311,-1,1312,1319,1311,-1,1312,1313,1319,-1,1319,1313,1314,-1,1315,1319,1314,-1,1315,1316,1319,-1,1319,1316,1317,-1,1318,1319,1317,-1,1319,1320,1321,-1,1431,1327,1407,-1,1430,1407,1429,-1,1430,1431,1407,-1,1328,1329,854,-1,854,1329,1331,-1,1331,1329,1330,-1,1333,1334,1353,-1,1353,1334,1335,-1,1352,1335,1351,-1,1352,1353,1335,-1,1335,1336,1351,-1,1351,1336,1350,-1,1350,1336,1337,-1,1338,1350,1337,-1,1338,1349,1350,-1,1338,1342,1349,-1,1338,1341,1342,-1,1338,1340,1341,-1,1338,1339,1340,-1,1349,1342,1348,-1,1348,1342,1343,-1,1344,1348,1343,-1,1344,1347,1348,-1,1344,1346,1347,-1,1344,1345,1346,-1,1353,1354,106,-1,106,1354,1355,-1,1402,1355,1379,-1,1401,1379,1384,-1,1385,1401,1384,-1,1385,1386,1401,-1,1401,1386,1387,-1,1388,1401,1387,-1,1388,1400,1401,-1,1388,1389,1400,-1,1400,1389,1390,-1,1391,1400,1390,-1,1391,1392,1400,-1,1400,1392,1393,-1,1394,1400,1393,-1,1394,1395,1400,-1,1400,1395,1396,-1,1397,1400,1396,-1,1397,1398,1400,-1,1400,1398,1399,-1,1379,1355,1378,-1,1378,1355,1356,-1,1374,1356,1373,-1,1374,1378,1356,-1,1374,1375,1378,-1,1378,1375,1376,-1,1377,1378,1376,-1,1356,1357,1373,-1,1373,1357,1372,-1,1372,1357,1358,-1,1359,1372,1358,-1,1359,1360,1372,-1,1372,1360,1361,-1,1362,1372,1361,-1,1362,1363,1372,-1,1372,1363,1364,-1,1371,1364,1365,-1,1366,1371,1365,-1,1366,1367,1371,-1,1371,1367,1368,-1,1369,1371,1368,-1,1369,1370,1371,-1,1372,1364,1371,-1,1380,1381,1379,-1,1379,1381,1382,-1,1383,1379,1382,-1,1383,1384,1379,-1,1401,1402,1379,-1,1355,1402,106,-1,106,1402,1300,-1,1467,1300,1466,-1,1467,106,1300,-1,1467,1468,106,-1,1552,1403,1509,-1,1551,1509,1550,-1,1551,1552,1509,-1,1408,1418,1407,-1,1408,1409,1418,-1,1418,1409,1410,-1,1417,1410,1416,-1,1417,1418,1410,-1,1411,1412,1410,-1,1410,1412,1413,-1,1414,1410,1413,-1,1414,1415,1410,-1,1410,1415,1416,-1,1418,1419,1407,-1,1407,1419,1429,-1,1429,1419,1428,-1,1428,1419,1427,-1,1427,1419,1420,-1,1426,1420,1425,-1,1426,1427,1420,-1,1421,1423,1420,-1,1421,1422,1423,-1,1423,1424,1420,-1,1420,1424,1425,-1,1440,1441,1451,-1,1451,1441,1442,-1,1443,1451,1442,-1,1443,1444,1451,-1,1451,1444,1445,-1,1446,1451,1445,-1,1446,1447,1451,-1,1451,1447,1448,-1,1449,1451,1448,-1,1449,1450,1451,-1,1452,1457,1451,-1,1452,1453,1457,-1,1457,1453,1454,-1,1455,1457,1454,-1,1455,1456,1457,-1,1457,1458,1451,-1,1451,1458,1459,-1,1309,1451,1459,-1,1404,1469,1507,-1,1508,1404,1507,-1,1508,1509,1404,-1,1404,1509,1403,-1,1506,1473,1484,-1,1488,1484,1485,-1,1486,1488,1485,-1,1486,1487,1488,-1,1484,1477,1483,-1,1506,1484,1488,-1,1489,1506,1488,-1,1489,1490,1506,-1,1506,1490,1505,-1,1505,1490,1504,-1,1504,1490,1491,-1,1503,1491,1502,-1,1503,1504,1491,-1,1492,1493,1491,-1,1491,1493,1494,-1,1495,1491,1494,-1,1495,1496,1491,-1,1491,1496,1497,-1,1498,1491,1497,-1,1498,1499,1491,-1,1491,1499,1500,-1,1501,1491,1500,-1,1501,1502,1491,-1,1510,1525,1509,-1,1510,1511,1525,-1,1525,1511,1524,-1,1524,1511,1512,-1,1523,1512,1514,-1,1515,1523,1514,-1,1515,1522,1523,-1,1515,1516,1522,-1,1522,1516,1521,-1,1521,1516,1520,-1,1520,1516,1519,-1,1519,1516,1517,-1,1518,1519,1517,-1,1512,1513,1514,-1,1523,1524,1512,-1,1526,1535,1525,-1,1526,1534,1535,-1,1526,1527,1534,-1,1534,1527,1528,-1,1533,1528,1532,-1,1533,1534,1528,-1,1529,1530,1528,-1,1528,1530,1531,-1,1532,1528,1531,-1,1535,1536,1525,-1,1525,1536,1509,-1,1509,1536,1550,-1,1550,1536,1549,-1,1549,1536,1537,-1,1539,1537,1538,-1,1539,1549,1537,-1,1539,1540,1549,-1,1549,1540,1548,-1,1548,1540,1541,-1,1542,1548,1541,-1,1542,1543,1548,-1,1548,1543,1544,-1,1545,1548,1544,-1,1545,1547,1548,-1,1545,1546,1547,-1],solid=False,
          coord=Coordinate(point=[(0.66964,0.11214,0),(0.66899,0.09749,0),(0.6669,0.08287,0),(0.66526,0.07569,0),(0.66318,0.06865,0),(0.66065,0.06178,0),(0.65764,0.05514,0),(0.65122,0.04402,0),(0.64348,0.03364,0),(0.63457,0.02427,0),(0.62973,0.02004,0),(0.62464,0.01614,0),(0.61514,0.00917,0),(0.60483,0.00331,0),(0.59392,-0.00138,0),(0.58264,-0.00486,0),(0.55882,-0.00932,0),(0.54675,-0.01047,0),(0.53464,-0.01086,0),(0.43264,-0.01086,0),(0.43264,0.00114,0),(0.44464,0.00114,0),(0.44585,0.00118,0),(0.44707,0.0013,0),(0.44829,0.0015,0),(0.44949,0.0018,0),(0.45065,0.00221,0),(0.45174,0.00273,0),(0.45274,0.00337,0),(0.45364,0.00414,0),(0.455,0.00427,0),(0.45634,0.00463,0),(0.457,0.00489,0),(0.45765,0.00519,0),(0.45828,0.00554,0),(0.45889,0.00593,0),(0.46004,0.00683,0),(0.46106,0.00785,0),(0.46152,0.00839,0),(0.46194,0.00896,0),(0.46264,0.01014,0),(0.46341,0.01104,0),(0.46406,0.01205,0),(0.46458,0.01314,0),(0.46498,0.0143,0),(0.46528,0.0155,0),(0.46549,0.01672,0),(0.46561,0.01794,0),(0.46564,0.01914,0),(0.46564,0.20214,0),(0.46561,0.20335,0),(0.46549,0.20457,0),(0.46528,0.20579,0),(0.46498,0.20699,0),(0.46458,0.20815,0),(0.46406,0.20924,0),(0.46341,0.21024,0),(0.46264,0.21114,0),(0.46187,0.21254,0),(0.46097,0.21388,0),(0.45996,0.21516,0),(0.45885,0.21635,0),(0.45766,0.21746,0),(0.45638,0.21847,0),(0.45504,0.21937,0),(0.45364,0.22014,0),(0.45079,0.22139,0),(0.44781,0.22233,0),(0.44474,0.22293,0),(0.44319,0.22309,0),(0.44164,0.22314,0),(0.44044,0.22318,0),(0.43922,0.2233,0),(0.438,0.2235,0),(0.4368,0.2238,0),(0.43564,0.22421,0),(0.43455,0.22473,0),(0.43354,0.22537,0),(0.43264,0.22614,0),(0.43264,0.23814,0),(0.54064,0.23814,0),(0.5514,0.23753,0),(0.56208,0.23576,0),(0.57254,0.23293,0),(0.58264,0.22914,0),(0.59302,0.22612,0),(0.60316,0.2222,0),(0.61279,0.21724,0),(0.61733,0.21434,0),(0.62164,0.21114,0),(0.62692,0.20703,0),(0.63189,0.2025,0),(0.63654,0.1976,0),(0.64086,0.19236,0),(0.64484,0.18685,0),(0.64847,0.18111,0),(0.65464,0.16914,0),(0.65828,0.16272,0),(0.66138,0.15597,0),(0.66397,0.14897,0),(0.66605,0.14176,0),(0.66764,0.13442,0),(0.66876,0.127,0),(-0.75,-0.45,0),(0.75,-0.45,0),(0.75,0.45,0),(-0.75,0.45,0),(0.47443,-0.31008,0),(0.46642,-0.30104,0),(0.45956,-0.2911,0),(0.45395,-0.28041,0),(0.44967,-0.26912,0),(0.44678,-0.25739,0),(0.44532,-0.24541,0),(0.44532,-0.23333,0),(0.44678,-0.22134,0),(0.44967,-0.20962,0),(0.45395,-0.19833,0),(0.45956,-0.18763,0),(0.46642,-0.1777,0),(0.47443,-0.16866,0),(0.48347,-0.16065,0),(0.49341,-0.15379,0),(0.5041,-0.14818,0),(0.51539,-0.1439,0),(0.52711,-0.14101,0),(0.5391,-0.13955,0),(0.55118,-0.13955,0),(0.56316,-0.14101,0),(0.57489,-0.1439,0),(0.58618,-0.14818,0),(0.59687,-0.15379,0),(0.60681,-0.16065,0),(0.61585,-0.16866,0),(0.62386,-0.1777,0),(0.63072,-0.18763,0),(0.63633,-0.19833,0),(0.64061,-0.20962,0),(0.6435,-0.22134,0),(0.64496,-0.23333,0),(0.64496,-0.24541,0),(0.6435,-0.25739,0),(0.64061,-0.26912,0),(0.63633,-0.28041,0),(0.63072,-0.2911,0),(0.62386,-0.30104,0),(0.61585,-0.31008,0),(0.60681,-0.31809,0),(0.59687,-0.32495,0),(0.58618,-0.33056,0),(0.57489,-0.33484,0),(0.56316,-0.33773,0),(0.55118,-0.33918,0),(0.5391,-0.33918,0),(0.52711,-0.33773,0),(0.51539,-0.33484,0),(0.5041,-0.33056,0),(0.49341,-0.32495,0),(0.48347,-0.31809,0),(0.40463,-0.19956,0),(0.40553,-0.19961,0),(0.40642,-0.19977,0),(0.40729,-0.20004,0),(0.40811,-0.20042,0),(0.40889,-0.20088,0),(0.4096,-0.20144,0),(0.41024,-0.20208,0),(0.4108,-0.2028,0),(0.41127,-0.20357,0),(0.41164,-0.2044,0),(0.41191,-0.20526,0),(0.41207,-0.20615,0),(0.41213,-0.20706,0),(0.41207,-0.20796,0),(0.41191,-0.20885,0),(0.41164,-0.20972,0),(0.41127,-0.21054,0),(0.4108,-0.21132,0),(0.41024,-0.21203,0),(0.4096,-0.21267,0),(0.40889,-0.21323,0),(0.40811,-0.2137,0),(0.40729,-0.21407,0),(0.40642,-0.21434,0),(0.40553,-0.2145,0),(0.40463,-0.21456,0),(0.28941,-0.21456,0),(0.28851,-0.2145,0),(0.28762,-0.21434,0),(0.28675,-0.21407,0),(0.28593,-0.2137,0),(0.28515,-0.21323,0),(0.28444,-0.21267,0),(0.2838,-0.21203,0),(0.28324,-0.21132,0),(0.28277,-0.21054,0),(0.2824,-0.20972,0),(0.28213,-0.20885,0),(0.28197,-0.20796,0),(0.28191,-0.20706,0),(0.28197,-0.20615,0),(0.28213,-0.20526,0),(0.2824,-0.2044,0),(0.28277,-0.20357,0),(0.28324,-0.2028,0),(0.2838,-0.20208,0),(0.28444,-0.20144,0),(0.28515,-0.20088,0),(0.28593,-0.20042,0),(0.28675,-0.20004,0),(0.28762,-0.19977,0),(0.28851,-0.19961,0),(0.28941,-0.19956,0),(-0.30459,-0.19956,0),(-0.30368,-0.19961,0),(-0.30279,-0.19977,0),(-0.30193,-0.20004,0),(-0.3011,-0.20042,0),(-0.30033,-0.20088,0),(-0.29962,-0.20144,0),(-0.29898,-0.20208,0),(-0.29842,-0.2028,0),(-0.29795,-0.20357,0),(-0.29758,-0.2044,0),(-0.29731,-0.20526,0),(-0.29714,-0.20615,0),(-0.29709,-0.20706,0),(-0.29714,-0.20796,0),(-0.29731,-0.20885,0),(-0.29758,-0.20972,0),(-0.29795,-0.21054,0),(-0.29842,-0.21132,0),(-0.29898,-0.21203,0),(-0.29962,-0.21267,0),(-0.30033,-0.21323,0),(-0.3011,-0.2137,0),(-0.30193,-0.21407,0),(-0.30279,-0.21434,0),(-0.30368,-0.2145,0),(-0.30459,-0.21456,0),(-0.56642,-0.21456,0),(-0.56732,-0.2145,0),(-0.56822,-0.21434,0),(-0.56908,-0.21407,0),(-0.56991,-0.2137,0),(-0.57068,-0.21323,0),(-0.57139,-0.21267,0),(-0.57203,-0.21203,0),(-0.57259,-0.21132,0),(-0.57306,-0.21054,0),(-0.57343,-0.20972,0),(-0.5737,-0.20885,0),(-0.57387,-0.20796,0),(-0.57392,-0.20706,0),(-0.57387,-0.20615,0),(-0.5737,-0.20526,0),(-0.57343,-0.2044,0),(-0.57306,-0.20357,0),(-0.57259,-0.2028,0),(-0.57203,-0.20208,0),(-0.57139,-0.20144,0),(-0.57068,-0.20088,0),(-0.56991,-0.20042,0),(-0.56908,-0.20004,0),(-0.56822,-0.19977,0),(-0.56732,-0.19961,0),(-0.56642,-0.19956,0),(0.18261,-0.30602,0),(0.17759,-0.30575,0),(0.17259,-0.30498,0),(0.16768,-0.30375,0),(0.16293,-0.30208,0),(0.16081,-0.30148,0),(0.15872,-0.30075,0),(0.15468,-0.29893,0),(0.15082,-0.29672,0),(0.14718,-0.29421,0),(0.14437,-0.29213,0),(0.14177,-0.28977,0),(0.13941,-0.28717,0),(0.13733,-0.28436,0),(0.13649,-0.28148,0),(0.13587,-0.27853,0),(0.13549,-0.27555,0),(0.13536,-0.27255,0),(0.1354,-0.27045,0),(0.13548,-0.26937,0),(0.13563,-0.26832,0),(0.13587,-0.26729,0),(0.13622,-0.26633,0),(0.1367,-0.26545,0),(0.13733,-0.26467,0),(0.13783,-0.26353,0),(0.13854,-0.26244,0),(0.13941,-0.26144,0),(0.14043,-0.26055,0),(0.14155,-0.25982,0),(0.14274,-0.25925,0),(0.14397,-0.25889,0),(0.14521,-0.25877,0),(0.14679,-0.25882,0),(0.14839,-0.25897,0),(0.14999,-0.25924,0),(0.15157,-0.25964,0),(0.15309,-0.26017,0),(0.15452,-0.26085,0),(0.1552,-0.26125,0),(0.15584,-0.26169,0),(0.15645,-0.26218,0),(0.15702,-0.26271,0),(0.1578,-0.26317,0),(0.15853,-0.26374,0),(0.1592,-0.26442,0),(0.15978,-0.26517,0),(0.16027,-0.26598,0),(0.16064,-0.26684,0),(0.16087,-0.26772,0),(0.16096,-0.26861,0),(0.1608,-0.27112,0),(0.16037,-0.2736,0),(0.15899,-0.27846,0),(0.15817,-0.28033,0),(0.15755,-0.28229,0),(0.15716,-0.2843,0),(0.15705,-0.28532,0),(0.15702,-0.28633,0),(0.158,-0.28732,0),(0.15899,-0.2883,0),(0.16032,-0.28947,0),(0.16178,-0.2905,0),(0.16489,-0.29224,0),(0.16591,-0.29227,0),(0.16693,-0.29237,0),(0.16894,-0.29277,0),(0.1709,-0.29339,0),(0.17277,-0.29421,0),(0.17414,-0.2948,0),(0.17556,-0.29527,0),(0.17702,-0.29561,0),(0.17852,-0.29586,0),(0.18155,-0.29612,0),(0.18458,-0.29618,0),(0.18614,-0.2961,0),(0.18769,-0.29588,0),(0.18923,-0.29554,0),(0.19075,-0.29507,0),(0.19223,-0.2945,0),(0.19368,-0.29382,0),(0.19639,-0.29224,0),(0.1996,-0.2913,0),(0.20274,-0.29005,0),(0.20423,-0.28929,0),(0.20565,-0.28842,0),(0.20698,-0.28743,0),(0.20821,-0.28633,0),(0.20957,-0.28488,0),(0.21084,-0.28332,0),(0.212,-0.28168,0),(0.21307,-0.27996,0),(0.21401,-0.27818,0),(0.21484,-0.27634,0),(0.21553,-0.27446,0),(0.21608,-0.27255,0),(0.21711,-0.2708,0),(0.21796,-0.26895,0),(0.21865,-0.26701,0),(0.21918,-0.26502,0),(0.21957,-0.26297,0),(0.21983,-0.26091,0),(0.22002,-0.2568,0),(0.21989,-0.2538,0),(0.21951,-0.25082,0),(0.21889,-0.24787,0),(0.21805,-0.24499,0),(0.21688,-0.24189,0),(0.21549,-0.23889,0),(0.21214,-0.23317,0),(0.21151,-0.23212,0),(0.21073,-0.23116,0),(0.20983,-0.23029,0),(0.20882,-0.22951,0),(0.20774,-0.22882,0),(0.20661,-0.22822,0),(0.20544,-0.2277,0),(0.20427,-0.22727,0),(0.20252,-0.22624,0),(0.20067,-0.22539,0),(0.19873,-0.2247,0),(0.19674,-0.22417,0),(0.19469,-0.22379,0),(0.19263,-0.22352,0),(0.18852,-0.22333,0),(0.17474,-0.22333,0),(0.17474,-0.20955,0),(0.18458,-0.20955,0),(0.1875,-0.20943,0),(0.19044,-0.20908,0),(0.19338,-0.20849,0),(0.19625,-0.20765,0),(0.19902,-0.20655,0),(0.20164,-0.2052,0),(0.20406,-0.20357,0),(0.20518,-0.20266,0),(0.20624,-0.20167,0),(0.20737,-0.20045,0),(0.20839,-0.19913,0),(0.20931,-0.19773,0),(0.21013,-0.19627,0),(0.2115,-0.19316,0),(0.21254,-0.18986,0),(0.21329,-0.18644,0),(0.21377,-0.18296,0),(0.21411,-0.17608,0),(0.214,-0.17317,0),(0.21365,-0.17022,0),(0.21305,-0.16729,0),(0.21221,-0.16441,0),(0.21112,-0.16164,0),(0.20976,-0.15902,0),(0.20814,-0.1566,0),(0.20722,-0.15548,0),(0.20624,-0.15442,0),(0.2054,-0.1534,0),(0.20446,-0.15246,0),(0.20345,-0.1516,0),(0.20237,-0.15081,0),(0.20122,-0.15009,0),(0.20001,-0.14945,0),(0.19746,-0.14837,0),(0.19477,-0.14755,0),(0.19201,-0.14699,0),(0.18925,-0.14666,0),(0.18655,-0.14655,0),(0.18402,-0.14665,0),(0.1815,-0.14697,0),(0.18025,-0.14724,0),(0.17904,-0.14758,0),(0.17785,-0.148,0),(0.17671,-0.14852,0),(0.17359,-0.15026,0),(0.17213,-0.15128,0),(0.1708,-0.15246,0),(0.16768,-0.15419,0),(0.16623,-0.15522,0),(0.16489,-0.15639,0),(0.16391,-0.15738,0),(0.16293,-0.15836,0),(0.16308,-0.16087,0),(0.16351,-0.16335,0),(0.16489,-0.16821,0),(0.16541,-0.16935,0),(0.16583,-0.17054,0),(0.16618,-0.17175,0),(0.16644,-0.173,0),(0.16677,-0.17552,0),(0.16686,-0.17805,0),(0.16678,-0.17915,0),(0.16654,-0.18023,0),(0.16616,-0.18128,0),(0.16567,-0.18231,0),(0.16508,-0.1833,0),(0.16442,-0.18423,0),(0.16369,-0.18511,0),(0.16293,-0.18592,0),(0.16156,-0.18652,0),(0.16014,-0.18699,0),(0.15867,-0.18733,0),(0.15718,-0.18758,0),(0.15414,-0.18784,0),(0.15111,-0.18789,0),(0.14999,-0.18783,0),(0.14883,-0.18765,0),(0.14768,-0.18734,0),(0.14657,-0.18691,0),(0.14553,-0.18636,0),(0.14461,-0.18568,0),(0.14383,-0.18488,0),(0.14324,-0.18396,0),(0.14272,-0.18281,0),(0.1423,-0.18163,0),(0.14196,-0.18041,0),(0.14169,-0.17917,0),(0.14137,-0.17664,0),(0.14127,-0.17411,0),(0.1414,-0.17112,0),(0.14178,-0.16813,0),(0.1424,-0.16518,0),(0.14324,-0.1623,0),(0.14787,-0.15615,0),(0.15308,-0.15049,0),(0.16074,-0.14521,0),(0.16883,-0.14064,0),(0.17165,-0.13962,0),(0.17453,-0.13878,0),(0.18043,-0.13756,0),(0.18644,-0.1369,0),(0.19246,-0.13671,0),(0.19816,-0.137,0),(0.20102,-0.13739,0),(0.20385,-0.13798,0),(0.2066,-0.13877,0),(0.20926,-0.1398,0),(0.21177,-0.14107,0),(0.21411,-0.14261,0),(0.21838,-0.1445,0),(0.2225,-0.14675,0),(0.22636,-0.14939,0),(0.22817,-0.15087,0),(0.22986,-0.15246,0),(0.2323,-0.15508,0),(0.23449,-0.15793,0),(0.23547,-0.15944,0),(0.23635,-0.161,0),(0.23711,-0.16261,0),(0.23774,-0.16427,0),(0.23858,-0.16715,0),(0.2392,-0.1701,0),(0.23958,-0.17308,0),(0.23971,-0.17608,0),(0.23955,-0.17858,0),(0.23912,-0.18107,0),(0.23774,-0.18592,0),(0.23657,-0.18902,0),(0.23518,-0.19202,0),(0.23183,-0.19774,0),(0.22975,-0.20054,0),(0.22739,-0.20314,0),(0.22479,-0.2055,0),(0.22199,-0.20758,0),(0.21773,-0.20951,0),(0.21333,-0.21112,0),(0.20427,-0.21349,0),(0.20427,-0.21546,0),(0.21112,-0.21756,0),(0.21805,-0.21939,0),(0.22167,-0.22044,0),(0.2252,-0.22176,0),(0.22861,-0.22338,0),(0.23183,-0.2253,0),(0.2347,-0.22843,0),(0.2373,-0.23179,0),(0.23963,-0.23536,0),(0.24168,-0.23908,0),(0.24227,-0.24004,0),(0.24281,-0.24104,0),(0.24371,-0.24312,0),(0.2444,-0.2453,0),(0.2449,-0.24756,0),(0.24547,-0.25219,0),(0.24561,-0.2568,0),(0.24552,-0.25917,0),(0.24526,-0.26154,0),(0.24483,-0.26391,0),(0.24425,-0.26627,0),(0.24263,-0.27089,0),(0.24049,-0.27536,0),(0.23788,-0.2796,0),(0.23487,-0.28354,0),(0.23152,-0.28712,0),(0.22789,-0.29027,0),(0.22318,-0.29399,0),(0.21803,-0.29721,0),(0.21253,-0.29992,0),(0.20677,-0.30213,0),(0.20081,-0.30383,0),(0.19475,-0.30505,0),(0.18866,-0.30578,0),(-4.8E-4,-0.15836,0),(0.00148,-0.16046,0),(0.00331,-0.1627,0),(0.00655,-0.16751,0),(0.00923,-0.17267,0),(0.01133,-0.17805,0),(0.0131,-0.18429,0),(0.01432,-0.19068,0),(0.01504,-0.19715,0),(0.01527,-0.20364,0),(0.01494,-0.21073,0),(0.01389,-0.2178,0),(0.01206,-0.22468,0),(0.01082,-0.22799,0),(0.00936,-0.23121,0),(0.00738,-0.23711,0),(0.00479,-0.24282,0),(0.00325,-0.24554,0),(0.00153,-0.24814,0),(-3.6E-4,-0.25059,0),(-0.00245,-0.25286,0),(-0.00455,-0.25482,0),(-0.00679,-0.25665,0),(-0.0116,-0.25989,0),(-0.01676,-0.26257,0),(-0.02214,-0.26467,0),(-0.02838,-0.26644,0),(-0.03477,-0.26767,0),(-0.04124,-0.26838,0),(-0.04773,-0.26861,0),(-0.05422,-0.26838,0),(-0.06069,-0.26767,0),(-0.06708,-0.26644,0),(-0.07332,-0.26467,0),(-0.07863,-0.26181,0),(-0.08373,-0.25857,0),(-0.08855,-0.25493,0),(-0.09301,-0.25089,0),(-0.09666,-0.2459,0),(-0.09987,-0.24058,0),(-0.1026,-0.23501,0),(-0.10482,-0.22924,0),(-0.10634,-0.21648,0),(-0.10679,-0.20364,0),(-0.10634,-0.1908,0),(-0.10482,-0.17805,0),(-0.1026,-0.17228,0),(-0.09987,-0.1667,0),(-0.09666,-0.16139,0),(-0.09301,-0.15639,0),(-0.08855,-0.15235,0),(-0.08373,-0.14872,0),(-0.07863,-0.14548,0),(-0.07332,-0.14261,0),(-0.07011,-0.14115,0),(-0.06679,-0.13992,0),(-0.05991,-0.13808,0),(-0.05285,-0.13704,0),(-0.04576,-0.13671,0),(-0.03912,-0.137,0),(-0.0325,-0.13797,0),(-0.02926,-0.13876,0),(-0.0261,-0.13979,0),(-0.02306,-0.14107,0),(-0.02017,-0.14261,0),(-0.01466,-0.14574,0),(-0.00947,-0.14944,0),(-0.00471,-0.15366,0),(-0.13042,-0.24499,0),(-0.13042,-0.26467,0),(-0.2387,-0.26467,0),(-0.2387,-0.25089,0),(-0.23801,-0.24969,0),(-0.2372,-0.24855,0),(-0.23629,-0.24749,0),(-0.2353,-0.24648,0),(-0.23312,-0.24465,0),(-0.23082,-0.24302,0),(-0.2277,-0.24015,0),(-0.22433,-0.23755,0),(-0.22076,-0.23522,0),(-0.21704,-0.23317,0),(-0.21232,-0.229,0),(-0.2072,-0.2253,0),(-0.19932,-0.22136,0),(-0.19145,-0.21742,0),(-0.18443,-0.2137,0),(-0.17767,-0.20955,0),(-0.17275,-0.20463,0),(-0.16782,-0.19971,0),(-0.16586,-0.19577,0),(-0.16389,-0.19183,0),(-0.16287,-0.188,0),(-0.16227,-0.18406,0),(-0.16192,-0.17608,0),(-0.162,-0.17313,0),(-0.16228,-0.17011,0),(-0.16279,-0.16707,0),(-0.16355,-0.1641,0),(-0.1646,-0.16128,0),(-0.16524,-0.15994,0),(-0.16597,-0.15867,0),(-0.16678,-0.15748,0),(-0.16769,-0.15636,0),(-0.16869,-0.15534,0),(-0.16979,-0.15442,0),(-0.17085,-0.15344,0),(-0.17197,-0.15253,0),(-0.17439,-0.1509,0),(-0.17701,-0.14955,0),(-0.17978,-0.14845,0),(-0.18265,-0.14761,0),(-0.18559,-0.14702,0),(-0.18854,-0.14667,0),(-0.19145,-0.14655,0),(-0.19324,-0.14663,0),(-0.19502,-0.14686,0),(-0.19678,-0.14723,0),(-0.19853,-0.14772,0),(-0.20195,-0.14897,0),(-0.20523,-0.15049,0),(-0.21035,-0.15418,0),(-0.21507,-0.15836,0),(-0.21492,-0.16087,0),(-0.21449,-0.16335,0),(-0.21311,-0.16821,0),(-0.21259,-0.16935,0),(-0.21217,-0.17054,0),(-0.21182,-0.17175,0),(-0.21156,-0.173,0),(-0.21123,-0.17552,0),(-0.21114,-0.17805,0),(-0.21122,-0.17915,0),(-0.21146,-0.18023,0),(-0.21184,-0.18128,0),(-0.21233,-0.18231,0),(-0.21292,-0.1833,0),(-0.21358,-0.18423,0),(-0.21431,-0.18511,0),(-0.21507,-0.18592,0),(-0.21644,-0.18652,0),(-0.21786,-0.18699,0),(-0.21933,-0.18733,0),(-0.22082,-0.18758,0),(-0.22386,-0.18784,0),(-0.22689,-0.18789,0),(-0.22798,-0.18781,0),(-0.22906,-0.18757,0),(-0.23012,-0.1872,0),(-0.23115,-0.1867,0),(-0.23213,-0.18611,0),(-0.23307,-0.18545,0),(-0.23395,-0.18472,0),(-0.23476,-0.18396,0),(-0.23528,-0.18281,0),(-0.2357,-0.18163,0),(-0.23604,-0.18041,0),(-0.23631,-0.17917,0),(-0.23663,-0.17664,0),(-0.23673,-0.17411,0),(-0.23658,-0.17063,0),(-0.23617,-0.16717,0),(-0.23476,-0.16033,0),(-0.23268,-0.15753,0),(-0.23032,-0.15493,0),(-0.22772,-0.15257,0),(-0.22492,-0.15049,0),(-0.22322,-0.1489,0),(-0.22142,-0.14743,0),(-0.21756,-0.14479,0),(-0.21344,-0.14254,0),(-0.20917,-0.14064,0),(-0.20441,-0.13898,0),(-0.1995,-0.13774,0),(-0.19451,-0.13697,0),(-0.18948,-0.13671,0),(-0.18453,-0.13686,0),(-0.17952,-0.13736,0),(-0.17452,-0.1382,0),(-0.1696,-0.13942,0),(-0.16482,-0.14104,0),(-0.16027,-0.14308,0),(-0.156,-0.14557,0),(-0.15399,-0.14698,0),(-0.15207,-0.14852,0),(-0.15042,-0.14964,0),(-0.14882,-0.15088,0),(-0.14729,-0.15224,0),(-0.14583,-0.1537,0),(-0.14315,-0.15691,0),(-0.14083,-0.16043,0),(-0.13894,-0.16419,0),(-0.13817,-0.16613,0),(-0.13752,-0.1681,0),(-0.13701,-0.17009,0),(-0.13663,-0.17209,0),(-0.1364,-0.17409,0),(-0.13632,-0.17608,0),(-0.13652,-0.18019,0),(-0.13678,-0.18226,0),(-0.13717,-0.1843,0),(-0.1377,-0.1863,0),(-0.13838,-0.18823,0),(-0.13923,-0.19008,0),(-0.14026,-0.19183,0),(-0.14081,-0.19374,0),(-0.14151,-0.19562,0),(-0.14233,-0.19746,0),(-0.14328,-0.19924,0),(-0.14434,-0.20096,0),(-0.14551,-0.2026,0),(-0.14678,-0.20416,0),(-0.14814,-0.20561,0),(-0.15126,-0.20848,0),(-0.15463,-0.21108,0),(-0.1582,-0.21341,0),(-0.16192,-0.21546,0),(-0.17465,-0.22151,0),(-0.18751,-0.22727,0),(-0.19217,-0.2293,0),(-0.1967,-0.23161,0),(-0.20106,-0.23422,0),(-0.20523,-0.23711,0),(-0.21332,-0.24065,0),(-0.21723,-0.24269,0),(-0.22098,-0.24499,0),(0.11961,-0.2568,0),(0.11961,-0.26467,0),(0.04283,-0.26467,0),(0.04283,-0.2568,0),(0.05268,-0.2568,0),(0.0552,-0.2567,0),(0.05773,-0.25638,0),(0.05897,-0.25611,0),(0.06019,-0.25577,0),(0.06137,-0.25535,0),(0.06252,-0.25483,0),(0.06341,-0.25475,0),(0.06429,-0.25451,0),(0.06515,-0.25414,0),(0.06596,-0.25366,0),(0.06672,-0.25307,0),(0.06739,-0.2524,0),(0.06797,-0.25167,0),(0.06843,-0.25089,0),(0.06906,-0.25012,0),(0.06954,-0.24924,0),(0.06989,-0.24827,0),(0.07013,-0.24725,0),(0.07028,-0.2462,0),(0.07036,-0.24512,0),(0.07039,-0.24302,0),(0.07039,-0.16033,0),(0.04086,-0.16033,0),(0.04086,-0.15049,0),(0.04677,-0.15049,0),(0.05229,-0.15026,0),(0.05779,-0.14954,0),(0.0632,-0.14831,0),(0.06843,-0.14655,0),(0.0727,-0.14466,0),(0.07681,-0.14241,0),(0.08068,-0.13977,0),(0.08248,-0.13829,0),(0.08418,-0.13671,0),(0.09402,-0.13671,0),(0.0931,-0.14107,0),(0.09249,-0.1455,0),(0.09205,-0.15442,0),(0.09205,-0.17411,0),(0.09205,-0.24302,0),(0.09205,-0.24893,0),(0.09256,-0.24984,0),(0.09315,-0.25072,0),(0.09381,-0.25156,0),(0.09454,-0.25235,0),(0.09532,-0.25307,0),(0.09616,-0.25373,0),(0.09704,-0.25432,0),(0.09796,-0.25483,0),(0.10046,-0.25499,0),(0.10294,-0.25542,0),(0.1078,-0.2568,0),(0.29253,-0.02042,0),(0.28487,-0.02001,0),(0.27725,-0.01884,0),(0.26978,-0.01695,0),(0.26253,-0.01442,0),(0.2593,-0.0135,0),(0.25612,-0.01238,0),(0.24996,-0.00962,0),(0.24408,-0.00625,0),(0.23853,-0.00242,0),(0.23425,7.5E-4,0),(0.23029,0.00435,0),(0.2267,0.00831,0),(0.22353,0.01258,0),(0.22225,0.01697,0),(0.22131,0.02146,0),(0.22073,0.02601,0),(0.22053,0.03058,0),(0.22059,0.03379,0),(0.22071,0.03542,0),(0.22093,0.03703,0),(0.2213,0.03859,0),(0.22154,0.03934,0),(0.22183,0.04006,0),(0.22217,0.04074,0),(0.22256,0.0414,0),(0.22301,0.04201,0),(0.22353,0.04258,0),(0.22387,0.04346,0),(0.22429,0.04433,0),(0.22479,0.04517,0),(0.22537,0.04599,0),(0.226,0.04677,0),(0.2267,0.04751,0),(0.22745,0.04821,0),(0.22825,0.04886,0),(0.22908,0.04945,0),(0.22995,0.04998,0),(0.23085,0.05045,0),(0.23177,0.05084,0),(0.2327,0.05116,0),(0.23364,0.05139,0),(0.23459,0.05153,0),(0.23553,0.05158,0),(0.23793,0.05151,0),(0.24038,0.05127,0),(0.24282,0.05086,0),(0.24522,0.05026,0),(0.24753,0.04944,0),(0.24972,0.04841,0),(0.25075,0.0478,0),(0.25173,0.04712,0),(0.25266,0.04639,0),(0.25353,0.04558,0),(0.25471,0.04488,0),(0.25528,0.04446,0),(0.25583,0.044,0),(0.25684,0.04298,0),(0.25774,0.04183,0),(0.25813,0.04122,0),(0.25848,0.04059,0),(0.25879,0.03994,0),(0.25904,0.03928,0),(0.2594,0.03794,0),(0.25953,0.03658,0),(0.25929,0.03277,0),(0.25863,0.02898,0),(0.25653,0.02158,0),(0.25528,0.01873,0),(0.25434,0.01574,0),(0.25374,0.01268,0),(0.25358,0.01113,0),(0.25353,0.00958,0),(0.25503,0.00808,0),(0.25653,0.00658,0),(0.25856,0.00479,0),(0.26077,0.00323,0),(0.26553,5.8E-4,0),(0.26708,5.3E-4,0),(0.26862,3.7E-4,0),(0.27169,-2.3E-4,0),(0.27468,-0.00117,0),(0.27753,-0.00242,0),(0.27961,-0.00333,0),(0.28178,-0.00404,0),(0.28401,-0.00456,0),(0.28629,-0.00494,0),(0.29091,-0.00533,0),(0.29553,-0.00542,0),(0.2979,-0.00531,0),(0.30027,-0.00497,0),(0.30261,-0.00445,0),(0.30493,-0.00373,0),(0.30719,-0.00286,0),(0.30938,-0.00184,0),(0.31353,5.8E-4,0),(0.31842,0.00201,0),(0.32319,0.00391,0),(0.32546,0.00508,0),(0.32763,0.0064,0),(0.32966,0.0079,0),(0.33153,0.00958,0),(0.3336,0.0118,0),(0.33553,0.01417,0),(0.33731,0.01667,0),(0.33893,0.01929,0),(0.34037,0.022,0),(0.34163,0.0248,0),(0.34268,0.02767,0),(0.34353,0.03058,0),(0.3451,0.03324,0),(0.34639,0.03607,0),(0.34744,0.03902,0),(0.34824,0.04206,0),(0.34883,0.04517,0),(0.34923,0.04832,0),(0.34953,0.05458,0),(0.34933,0.05915,0),(0.34875,0.0637,0),(0.34781,0.06819,0),(0.34653,0.07258,0),(0.34475,0.07729,0),(0.34263,0.08187,0),(0.33753,0.09058,0),(0.33708,0.0914,0),(0.33656,0.09219,0),(0.336,0.09294,0),(0.33538,0.09365,0),(0.334,0.09498,0),(0.33247,0.09617,0),(0.33082,0.09722,0),(0.32909,0.09814,0),(0.32731,0.09892,0),(0.32553,0.09958,0),(0.32286,0.10115,0),(0.32004,0.10245,0),(0.31709,0.10349,0),(0.31405,0.1043,0),(0.31094,0.10489,0),(0.30779,0.10529,0),(0.30153,0.10558,0),(0.28053,0.10558,0),(0.28053,0.12658,0),(0.29553,0.12658,0),(0.29997,0.12676,0),(0.30446,0.12729,0),(0.30893,0.1282,0),(0.31331,0.12948,0),(0.31753,0.13115,0),(0.32153,0.13321,0),(0.32521,0.13569,0),(0.32692,0.13708,0),(0.32853,0.13858,0),(0.33025,0.14045,0),(0.3318,0.14246,0),(0.33321,0.14459,0),(0.33446,0.14682,0),(0.33655,0.15156,0),(0.33813,0.15659,0),(0.33927,0.1618,0),(0.34,0.1671,0),(0.34053,0.17758,0),(0.34035,0.18202,0),(0.33982,0.18651,0),(0.33891,0.19098,0),(0.33763,0.19537,0),(0.33596,0.19959,0),(0.33389,0.20358,0),(0.33142,0.20727,0),(0.33003,0.20898,0),(0.32853,0.21058,0),(0.32724,0.21214,0),(0.32582,0.21357,0),(0.32428,0.21489,0),(0.32263,0.21609,0),(0.32087,0.21718,0),(0.31903,0.21816,0),(0.31514,0.21981,0),(0.31105,0.22106,0),(0.30685,0.22192,0),(0.30264,0.22242,0),(0.29853,0.22258,0),(0.29467,0.22243,0),(0.29083,0.22194,0),(0.28893,0.22153,0),(0.28708,0.22101,0),(0.28527,0.22036,0),(0.28353,0.21958,0),(0.27877,0.21693,0),(0.27656,0.21537,0),(0.27453,0.21358,0),(0.26977,0.21093,0),(0.26756,0.20937,0),(0.26553,0.20758,0),(0.26403,0.20608,0),(0.26253,0.20458,0),(0.26277,0.20077,0),(0.26342,0.19698,0),(0.26553,0.18958,0),(0.26631,0.18784,0),(0.26696,0.18603,0),(0.26748,0.18418,0),(0.26788,0.18228,0),(0.26838,0.17843,0),(0.26853,0.17458,0),(0.26849,0.17374,0),(0.2684,0.17291,0),(0.26824,0.17208,0),(0.26803,0.17126,0),(0.26746,0.16965,0),(0.26671,0.16809,0),(0.26582,0.16659,0),(0.2648,0.16516,0),(0.26369,0.16382,0),(0.26253,0.16258,0),(0.26044,0.16167,0),(0.25827,0.16096,0),(0.25604,0.16044,0),(0.25377,0.16006,0),(0.24914,0.15967,0),(0.24453,0.15958,0),(0.24281,0.15967,0),(0.24105,0.15996,0),(0.23929,0.16042,0),(0.2376,0.16108,0),(0.23679,0.16148,0),(0.23602,0.16192,0),(0.2353,0.16242,0),(0.23462,0.16296,0),(0.23399,0.16354,0),(0.23343,0.16417,0),(0.23294,0.16485,0),(0.23253,0.16558,0),(0.23174,0.16733,0),(0.2311,0.16913,0),(0.23058,0.17099,0),(0.23017,0.17288,0),(0.22968,0.17673,0),(0.22953,0.18058,0),(0.22973,0.18515,0),(0.23031,0.1897,0),(0.23125,0.19419,0),(0.23253,0.19858,0),(0.23958,0.20795,0),(0.24753,0.21658,0),(0.25919,0.22462,0),(0.27153,0.23158,0),(0.27582,0.23314,0),(0.28021,0.23442,0),(0.2892,0.23628,0),(0.29836,0.23728,0),(0.30753,0.23758,0),(0.31621,0.23714,0),(0.32057,0.23654,0),(0.32488,0.23565,0),(0.32908,0.23443,0),(0.33313,0.23287,0),(0.33696,0.23093,0),(0.34053,0.22858,0),(0.34703,0.2257,0),(0.35331,0.22227,0),(0.35919,0.21825,0),(0.36194,0.216,0),(0.36453,0.21358,0),(0.36823,0.20958,0),(0.37158,0.20523,0),(0.37307,0.20294,0),(0.37441,0.20056,0),(0.37557,0.19811,0),(0.37653,0.19558,0),(0.37781,0.19119,0),(0.37875,0.1867,0),(0.37933,0.18215,0),(0.37953,0.17758,0),(0.37929,0.17377,0),(0.37863,0.16998,0),(0.37653,0.16258,0),(0.37475,0.15787,0),(0.37263,0.15329,0),(0.36753,0.14458,0),(0.36436,0.14031,0),(0.36076,0.13635,0),(0.3568,0.13275,0),(0.35253,0.12958,0),(0.34604,0.12665,0),(0.33933,0.12419,0),(0.32553,0.12058,0),(0.32553,0.11758,0),(0.33597,0.11438,0),(0.34653,0.11158,0),(0.35203,0.10999,0),(0.35742,0.10797,0),(0.36261,0.10551,0),(0.36753,0.10258,0),(0.3719,0.09782,0),(0.37587,0.09269,0),(0.37942,0.08725,0),(0.38253,0.08158,0),(0.38344,0.08011,0),(0.38425,0.0786,0),(0.38562,0.07542,0),(0.38667,0.0721,0),(0.38744,0.06866,0),(0.38831,0.06161,0),(0.38853,0.05458,0),(0.38839,0.05097,0),(0.38799,0.04735,0),(0.38734,0.04374,0),(0.38644,0.04016,0),(0.38399,0.0331,0),(0.38072,0.0263,0),(0.37674,0.01984,0),(0.37215,0.01383,0),(0.36705,0.00837,0),(0.36153,0.00358,0),(0.35434,-0.0021,0),(0.34649,-0.00699,0),(0.33812,-0.01112,0),(0.32933,-0.01449,0),(0.32026,-0.01709,0),(0.31102,-0.01894,0),(0.30174,-0.02005,0),(0.06892,0.10278,0),(0.07393,0.09881,0),(0.0787,0.09452,0),(0.08308,0.08985,0),(0.08692,0.08478,0),(0.08911,0.08152,0),(0.09097,0.07803,0),(0.09252,0.07437,0),(0.09377,0.07056,0),(0.09472,0.06666,0),(0.09539,0.06269,0),(0.09579,0.05872,0),(0.09592,0.05478,0),(0.09579,0.05083,0),(0.09539,0.04686,0),(0.09472,0.0429,0),(0.09377,0.03899,0),(0.09252,0.03519,0),(0.09097,0.03152,0),(0.08911,0.02804,0),(0.08692,0.02478,0),(0.08527,0.02173,0),(0.08341,0.0188,0),(0.07914,0.01326,0),(0.07426,0.00823,0),(0.06892,0.00378,0),(0.06274,-3.2E-4,0),(0.05609,-0.00371,0),(0.0491,-0.00636,0),(0.04192,-0.00822,0),(0.02699,-0.01046,0),(0.01192,-0.01122,0),(-0.10508,-0.01122,0),(-0.10508,7.8E-4,0),(-0.09608,7.8E-4,0),(-0.09288,8.4E-4,0),(-0.09124,9.6E-4,0),(-0.08963,0.00118,0),(-0.08807,0.00155,0),(-0.08732,0.00179,0),(-0.08661,0.00208,0),(-0.08592,0.00242,0),(-0.08526,0.00281,0),(-0.08465,0.00326,0),(-0.08408,0.00378,0),(-0.07933,0.00643,0),(-0.07711,0.00799,0),(-0.07508,0.00978,0),(-0.07457,0.01035,0),(-0.07411,0.01096,0),(-0.07372,0.01161,0),(-0.07338,0.0123,0),(-0.07309,0.01302,0),(-0.07285,0.01377,0),(-0.07249,0.01532,0),(-0.07226,0.01694,0),(-0.07214,0.01857,0),(-0.07208,0.02178,0),(-0.07208,0.20178,0),(-0.07212,0.20298,0),(-0.07223,0.2042,0),(-0.07244,0.20543,0),(-0.07274,0.20662,0),(-0.07315,0.20778,0),(-0.07367,0.20887,0),(-0.07431,0.20988,0),(-0.07508,0.21078,0),(-0.07586,0.21218,0),(-0.07675,0.21352,0),(-0.07776,0.21479,0),(-0.07887,0.21599,0),(-0.08007,0.2171,0),(-0.08134,0.2181,0),(-0.08268,0.219,0),(-0.08408,0.21978,0),(-0.08563,0.21983,0),(-0.08718,0.21999,0),(-0.09024,0.22059,0),(-0.09323,0.22153,0),(-0.09608,0.22278,0),(-0.09728,0.22281,0),(-0.09851,0.22293,0),(-0.09973,0.22314,0),(-0.10093,0.22344,0),(-0.10208,0.22385,0),(-0.10318,0.22437,0),(-0.10418,0.22501,0),(-0.10508,0.22578,0),(-0.10508,0.23778,0),(0.00892,0.23778,0),(0.01497,0.23758,0),(0.02101,0.23701,0),(0.03292,0.23478,0),(0.04516,0.23093,0),(0.05692,0.22578,0),(0.06487,0.21714,0),(0.07192,0.20778,0),(0.07394,0.20483,0),(0.07573,0.20169,0),(0.07727,0.1984,0),(0.07855,0.19499,0),(0.07957,0.19149,0),(0.08031,0.18793,0),(0.08077,0.18435,0),(0.08092,0.18078,0),(0.08081,0.17768,0),(0.0805,0.17459,0),(0.0793,0.16845,0),(0.07741,0.16248,0),(0.07492,0.15678,0),(0.06929,0.14898,0),(0.06292,0.14178,0),(0.0607,0.13971,0),(0.05833,0.13777,0),(0.05583,0.13599,0),(0.05322,0.13437,0),(0.0505,0.13293,0),(0.0477,0.13168,0),(0.04483,0.13062,0),(0.04192,0.12978,0),(0.037,0.12685,0),(0.03181,0.12439,0),(0.02643,0.12237,0),(0.02092,0.12078,0),(0.03292,0.11778,0),(0.04492,0.11478,0),(0.05724,0.10939,0),(0.0632,0.10628,0),(-0.35108,0.23778,0),(-0.35108,0.22578,0),(-0.35393,0.22453,0),(-0.35692,0.22359,0),(-0.35998,0.22299,0),(-0.36153,0.22283,0),(-0.36308,0.22278,0),(-0.36783,0.22013,0),(-0.37005,0.21856,0),(-0.37208,0.21678,0),(-0.37387,0.21612,0),(-0.37564,0.21533,0),(-0.37737,0.21441,0),(-0.37902,0.21336,0),(-0.38055,0.21217,0),(-0.38193,0.21085,0),(-0.38255,0.21013,0),(-0.38312,0.20938,0),(-0.38363,0.2086,0),(-0.38408,0.20778,0),(-0.38519,0.20653,0),(-0.38615,0.20516,0),(-0.387,0.20371,0),(-0.38774,0.20218,0),(-0.39008,0.19578,0),(-0.40456,0.14762,0),(-0.42008,0.09978,0),(-0.43714,0.04248,0),(-0.45608,-0.01422,0),(-0.47108,-0.01422,0),(-0.53408,0.17478,0),(-0.60008,-0.01422,0),(-0.61508,-0.01422,0),(-0.63348,0.04866,0),(-0.65108,0.11178,0),(-0.66332,0.15671,0),(-0.67508,0.20178,0),(-0.67687,0.20381,0),(-0.67843,0.20602,0),(-0.68108,0.21078,0),(-0.68311,0.21256,0),(-0.68533,0.21413,0),(-0.69008,0.21678,0),(-0.69211,0.21856,0),(-0.69433,0.22013,0),(-0.69908,0.22278,0),(-0.70028,0.22281,0),(-0.70151,0.22293,0),(-0.70273,0.22314,0),(-0.70393,0.22344,0),(-0.70508,0.22385,0),(-0.70618,0.22437,0),(-0.70718,0.22501,0),(-0.70808,0.22578,0),(-0.70808,0.23778,0),(-0.60908,0.23778,0),(-0.60908,0.22578,0),(-0.6195,0.22363,0),(-0.62478,0.223,0),(-0.63008,0.22278,0),(-0.634,0.22156,0),(-0.63601,0.22072,0),(-0.6379,0.2197,0),(-0.63877,0.21912,0),(-0.63956,0.2185,0),(-0.64027,0.21784,0),(-0.64089,0.21712,0),(-0.64139,0.21636,0),(-0.64176,0.21555,0),(-0.642,0.21469,0),(-0.64208,0.21378,0),(-0.64058,0.21228,0),(-0.63908,0.21078,0),(-0.63908,0.20478,0),(-0.63238,0.17907,0),(-0.62408,0.15378,0),(-0.60931,0.10121,0),(-0.59408,0.04878,0),(-0.53408,0.23478,0),(-0.51608,0.23478,0),(-0.45008,0.04278,0),(-0.43964,0.08179,0),(-0.42908,0.12078,0),(-0.42166,0.1478,0),(-0.41408,0.17478,0),(-0.4101,0.18662,0),(-0.40865,0.19265,0),(-0.40823,0.1957,0),(-0.40808,0.19878,0),(-0.40808,0.20778,0),(-0.40811,0.20861,0),(-0.40821,0.20945,0),(-0.40836,0.21027,0),(-0.40857,0.21109,0),(-0.40914,0.21271,0),(-0.40989,0.21427,0),(-0.41079,0.21577,0),(-0.41181,0.2172,0),(-0.41291,0.21854,0),(-0.41408,0.21978,0),(-0.42745,0.2233,0),(-0.44108,0.22578,0),(-0.44108,0.23778,0),(-0.14408,0.06378,0),(-0.13208,0.06378,0),(-0.13808,-0.01122,0),(-0.34208,-0.01122,0),(-0.34208,7.8E-4,0),(-0.33008,7.8E-4,0),(-0.32688,8.4E-4,0),(-0.32524,9.6E-4,0),(-0.32363,0.00118,0),(-0.32207,0.00155,0),(-0.32132,0.00179,0),(-0.32061,0.00208,0),(-0.31992,0.00242,0),(-0.31926,0.00281,0),(-0.31865,0.00326,0),(-0.31808,0.00378,0),(-0.31333,0.00643,0),(-0.31111,0.00799,0),(-0.30908,0.00978,0),(-0.30857,0.01035,0),(-0.30811,0.01096,0),(-0.30772,0.01161,0),(-0.30738,0.0123,0),(-0.30709,0.01302,0),(-0.30685,0.01377,0),(-0.30649,0.01532,0),(-0.30626,0.01694,0),(-0.30614,0.01857,0),(-0.30608,0.02178,0),(-0.30608,0.20178,0),(-0.30612,0.20298,0),(-0.30623,0.2042,0),(-0.30644,0.20543,0),(-0.30674,0.20662,0),(-0.30715,0.20778,0),(-0.30767,0.20887,0),(-0.30831,0.20988,0),(-0.30908,0.21078,0),(-0.30978,0.21196,0),(-0.3102,0.21253,0),(-0.31066,0.21308,0),(-0.31169,0.21409,0),(-0.31283,0.21499,0),(-0.31344,0.21538,0),(-0.31407,0.21573,0),(-0.31472,0.21604,0),(-0.31538,0.21629,0),(-0.31672,0.21665,0),(-0.31808,0.21678,0),(-0.31933,0.21789,0),(-0.32069,0.21885,0),(-0.32215,0.21969,0),(-0.32367,0.22043,0),(-0.33008,0.22278,0),(-0.33328,0.22284,0),(-0.33492,0.22296,0),(-0.33653,0.22318,0),(-0.33809,0.22355,0),(-0.33884,0.22379,0),(-0.33955,0.22408,0),(-0.34024,0.22442,0),(-0.3409,0.22481,0),(-0.34151,0.22526,0),(-0.34208,0.22578,0),(-0.34208,0.23778,0),(-0.15008,0.23778,0),(-0.15008,0.17778,0),(-0.16208,0.17778,0),(-0.16598,0.18489,0),(-0.17036,0.19174,0),(-0.18008,0.20478,0),(-0.18442,0.20995,0),(-0.18682,0.21248,0),(-0.18937,0.2148,0),(-0.19207,0.2168,0),(-0.19348,0.21765,0),(-0.19493,0.21838,0),(-0.19641,0.21897,0),(-0.19793,0.21941,0),(-0.19949,0.21968,0),(-0.20108,0.21978,0),(-0.21308,0.21978,0),(-0.21747,0.22106,0),(-0.22196,0.222,0),(-0.22651,0.22258,0),(-0.23108,0.22278,0),(-0.27008,0.22278,0),(-0.27008,0.12378,0),(-0.24308,0.12378,0),(-0.22508,0.12378,0),(-0.22329,0.12443,0),(-0.22152,0.12522,0),(-0.21979,0.12614,0),(-0.21814,0.12719,0),(-0.21661,0.12838,0),(-0.21523,0.12971,0),(-0.21461,0.13042,0),(-0.21404,0.13117,0),(-0.21353,0.13196,0),(-0.21308,0.13278,0),(-0.20982,0.14017,0),(-0.20708,0.14778,0),(-0.20408,0.15678,0),(-0.20108,0.16578,0),(-0.18908,0.16578,0),(-0.18908,0.06678,0),(-0.20108,0.06678,0),(-0.20434,0.07417,0),(-0.20708,0.08178,0),(-0.20982,0.08939,0),(-0.21308,0.09678,0),(-0.21582,0.09936,0),(-0.21873,0.10176,0),(-0.22182,0.10392,0),(-0.22508,0.10578,0),(-0.22717,0.10669,0),(-0.22933,0.10739,0),(-0.23156,0.10792,0),(-0.23384,0.1083,0),(-0.23847,0.10869,0),(-0.24308,0.10878,0),(-0.27008,0.10878,0),(-0.27008,0.03378,0),(-0.27008,0.01578,0),(-0.26743,0.01102,0),(-0.26587,0.00881,0),(-0.26408,0.00678,0),(-0.26123,0.00553,0),(-0.25824,0.00459,0),(-0.25518,0.00399,0),(-0.25363,0.00383,0),(-0.25208,0.00378,0),(-0.22808,0.00378,0),(-0.21308,0.00378,0),(-0.19808,0.00378,0),(-0.19427,0.00402,0),(-0.19048,0.00467,0),(-0.18308,0.00678,0),(-0.18188,0.00681,0),(-0.18065,0.00693,0),(-0.17943,0.00714,0),(-0.17823,0.00744,0),(-0.17708,0.00785,0),(-0.17599,0.00837,0),(-0.17498,0.00901,0),(-0.17408,0.00978,0),(-0.16872,0.01586,0),(-0.16403,0.02252,0),(-0.15608,0.03678,0),(-0.1496,0.05008,0.0)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[38,0,37,-1,37,0,1,-1,25,1,2,-1,3,25,2,-1,3,15,25,-1,3,14,15,-1,3,13,14,-1,3,12,13,-1,3,11,12,-1,3,4,11,-1,11,4,10,-1,10,4,5,-1,6,10,5,-1,6,7,10,-1,10,7,8,-1,9,10,8,-1,37,1,25,-1,26,37,25,-1,26,27,37,-1,37,27,28,-1,29,37,28,-1,29,30,37,-1,37,30,31,-1,32,37,31,-1,32,33,37,-1,37,33,34,-1,36,34,35,-1,36,37,34,-1,15,16,25,-1,25,16,17,-1,18,25,17,-1,18,19,25,-1,25,19,20,-1,21,25,20,-1,21,24,25,-1,21,23,24,-1,21,22,23,-1],solid=False,
          coord=Coordinate(point=[(-0.01508,0.12678,0),(-0.00292,0.12732,0),(0.00308,0.12823,0),(0.00892,0.12978,0),(0.01381,0.1312,0),(0.01858,0.13311,0),(0.02086,0.13427,0),(0.02302,0.1356,0),(0.02505,0.1371,0),(0.02692,0.13878,0),(0.03202,0.14748,0),(0.03414,0.15206,0),(0.03592,0.15678,0),(0.03733,0.16189,0),(0.03826,0.16714,0),(0.03877,0.17246,0),(0.03892,0.17778,0),(0.03874,0.18222,0),(0.03821,0.18671,0),(0.03731,0.19118,0),(0.03602,0.19556,0),(0.03435,0.19979,0),(0.03229,0.20378,0),(0.02981,0.20746,0),(0.02842,0.20917,0),(0.02692,0.21078,0),(0.02518,0.21239,0),(0.02332,0.21386,0),(0.02136,0.21521,0),(0.0193,0.21643,0),(0.01493,0.2185,0),(0.01031,0.22013,0),(0.00551,0.22134,0),(6.2E-4,0.22216,0),(-0.00427,0.22263,0),(-0.00908,0.22278,0),(-0.02408,0.22278,0),(-0.03608,0.22278,0),(-0.03608,0.12678,0.0)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(DEF='character3Appearance',
          material=Material(ambientIntensity=1.0,diffuseColor=(0.863,0.141,0.122),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.29253,-0.02042,0.1),(0.28487,-0.02001,0.1),(0.27725,-0.01884,0.1),(0.26978,-0.01695,0.1),(0.26253,-0.01442,0.1),(0.26253,-0.01442,0),(0.26978,-0.01695,0),(0.27725,-0.01884,0),(0.28487,-0.02001,0),(0.29253,-0.02042,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.10395,-0.99458,0),(-0.19952,-0.97989,0),(-0.28812,-0.9576,0),(-0.37139,-0.92848,0),(-0.37139,-0.92848,0),(-0.28812,-0.9576,0),(-0.19952,-0.97989,0),(-0.10395,-0.99458,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(0.26253,-0.01442,0.1),(0.2593,-0.0135,0.1),(0.25612,-0.01238,0.1),(0.24996,-0.00962,0.1),(0.24408,-0.00625,0.1),(0.23853,-0.00242,0.1),(0.23853,-0.00242,0),(0.24408,-0.00625,0),(0.24996,-0.00962,0),(0.25612,-0.01238,0),(0.2593,-0.0135,0),(0.26253,-0.01442,0.0)]),
          normal=Normal(vector=[(-0.24254,-0.97014,0),(-0.30355,-0.95282,0),(-0.35921,-0.93326,0),(-0.45562,-0.89018,0),(-0.53473,-0.84502,0),(-0.6,-0.8,0),(-0.6,-0.8,0),(-0.53473,-0.84502,0),(-0.45562,-0.89018,0),(-0.35921,-0.93326,0),(-0.30355,-0.95282,0),(-0.24254,-0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.23853,-0.00242,0.1),(0.23425,7.5E-4,0.1),(0.23029,0.00435,0.1),(0.2267,0.00831,0.1),(0.22353,0.01258,0.1),(0.22353,0.01258,0),(0.2267,0.00831,0),(0.23029,0.00435,0),(0.23425,7.5E-4,0),(0.23853,-0.00242,0.0)]),
          normal=Normal(vector=[(-0.5547,-0.83205,0),(-0.63491,-0.77259,0),(-0.70711,-0.70711,0),(-0.77259,-0.63491,0),(-0.83205,-0.5547,0),(-0.83205,-0.5547,0),(-0.77259,-0.63491,0),(-0.70711,-0.70711,0),(-0.63491,-0.77259,0),(-0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.22353,0.01258,0.1),(0.22225,0.01697,0.1),(0.22131,0.02146,0.1),(0.22073,0.02601,0.1),(0.22053,0.03058,0.1),(0.22053,0.03058,0),(0.22073,0.02601,0),(0.22131,0.02146,0),(0.22225,0.01697,0),(0.22353,0.01258,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.97003,-0.24298,0),(-0.98605,-0.16647,0),(-0.99632,-0.08575,0),(-1.0,0,0),(-1.0,0,0),(-0.99632,-0.08575,0),(-0.98605,-0.16647,0),(-0.97003,-0.24298,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.22053,0.03058,0.1),(0.22059,0.03379,0.1),(0.22071,0.03542,0.1),(0.22093,0.03703,0.1),(0.2213,0.03859,0.1),(0.22154,0.03934,0.1),(0.22183,0.04006,0.1),(0.22217,0.04074,0.1),(0.22256,0.0414,0.1),(0.22301,0.04201,0.1),(0.22353,0.04258,0.1),(0.22353,0.04258,0),(0.22301,0.04201,0),(0.22256,0.0414,0),(0.22217,0.04074,0),(0.22183,0.04006,0),(0.22154,0.03934,0),(0.2213,0.03859,0),(0.22093,0.03703,0),(0.22071,0.03542,0),(0.22059,0.03379,0),(0.22053,0.03058,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.9988,0.04898,0),(-0.99469,0.1029,0),(-0.98386,0.17892,0),(-0.96007,0.27976,0),(-0.94044,0.33996,0),(-0.91369,0.40641,0),(-0.87821,0.47828,0),(-0.8325,0.55403,0),(-0.77553,0.63131,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.77553,0.63131,0),(-0.8325,0.55403,0),(-0.87821,0.47828,0),(-0.91369,0.40641,0),(-0.94044,0.33996,0),(-0.96007,0.27976,0),(-0.98386,0.17892,0),(-0.99469,0.1029,0),(-0.9988,0.04898,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,33,-1,33,1,32,-1,32,1,2,-1,31,2,3,-1,30,3,4,-1,29,4,5,-1,28,5,6,-1,27,6,7,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,17,-1,18,19,15,-1,32,2,31,-1,31,3,30,-1,30,4,29,-1,29,5,28,-1,28,6,27,-1,27,7,26,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,15,16,17,-1],solid=False,
          coord=Coordinate(point=[(0.22353,0.04258,0.1),(0.22387,0.04346,0.1),(0.22429,0.04433,0.1),(0.22479,0.04517,0.1),(0.22537,0.04599,0.1),(0.226,0.04677,0.1),(0.2267,0.04751,0.1),(0.22745,0.04821,0.1),(0.22825,0.04886,0.1),(0.22908,0.04945,0.1),(0.22995,0.04998,0.1),(0.23085,0.05045,0.1),(0.23177,0.05084,0.1),(0.2327,0.05116,0.1),(0.23364,0.05139,0.1),(0.23459,0.05153,0.1),(0.23553,0.05158,0.1),(0.23553,0.05158,0),(0.23459,0.05153,0),(0.23364,0.05139,0),(0.2327,0.05116,0),(0.23177,0.05084,0),(0.23085,0.05045,0),(0.22995,0.04998,0),(0.22908,0.04945,0),(0.22825,0.04886,0),(0.22745,0.04821,0),(0.2267,0.04751,0),(0.226,0.04677,0),(0.22537,0.04599,0),(0.22479,0.04517,0),(0.22429,0.04433,0),(0.22387,0.04346,0),(0.22353,0.04258,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.91601,0.40116,0),(-0.87909,0.47666,0),(-0.83912,0.54395,0),(-0.79679,0.60426,0),(-0.7524,0.6587,0),(-0.70594,0.70827,0),(-0.65716,0.75375,0),(-0.60561,0.79576,0),(-0.55069,0.83471,0),(-0.49164,0.8708,0),(-0.42758,0.90398,0),(-0.35756,0.93389,0),(-0.28056,0.95984,0),(-0.19567,0.98067,0),(-0.1022,0.99476,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.1022,0.99476,0),(-0.19567,0.98067,0),(-0.28056,0.95984,0),(-0.35756,0.93389,0),(-0.42758,0.90398,0),(-0.49164,0.8708,0),(-0.55069,0.83471,0),(-0.60561,0.79576,0),(-0.65716,0.75375,0),(-0.70594,0.70827,0),(-0.7524,0.6587,0),(-0.79679,0.60426,0),(-0.83912,0.54395,0),(-0.87909,0.47666,0),(-0.91601,0.40116,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.23553,0.05158,0.1),(0.23793,0.05151,0.1),(0.24038,0.05127,0.1),(0.24282,0.05086,0.1),(0.24522,0.05026,0.1),(0.24753,0.04944,0.1),(0.24972,0.04841,0.1),(0.25075,0.0478,0.1),(0.25173,0.04712,0.1),(0.25266,0.04639,0.1),(0.25353,0.04558,0.1),(0.25353,0.04558,0),(0.25266,0.04639,0),(0.25173,0.04712,0),(0.25075,0.0478,0),(0.24972,0.04841,0),(0.24753,0.04944,0),(0.24522,0.05026,0),(0.24282,0.05086,0),(0.24038,0.05127,0),(0.23793,0.05151,0),(0.23553,0.05158,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06216,0.99807,-0.0),(0.12928,0.99161,-0.0),(0.20336,0.9791,-0.0),(0.28619,0.95817,-0.0),(0.37907,0.92537,-0.0),(0.48214,0.87609,-0.0),(0.53698,0.84359,-0.0),(0.59334,0.80495,-0.0),(0.65041,0.75958,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.65041,0.75958,-0.0),(0.59334,0.80495,-0.0),(0.53698,0.84359,-0.0),(0.48214,0.87609,-0.0),(0.37907,0.92537,-0.0),(0.28619,0.95817,-0.0),(0.20336,0.9791,-0.0),(0.12928,0.99161,-0.0),(0.06216,0.99807,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,19,-1,20,21,3,-1,22,2,21,-1,3,4,19,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.25353,0.04558,0.1),(0.25471,0.04488,0.1),(0.25528,0.04446,0.1),(0.25583,0.044,0.1),(0.25684,0.04298,0.1),(0.25774,0.04183,0.1),(0.25813,0.04122,0.1),(0.25848,0.04059,0.1),(0.25879,0.03994,0.1),(0.25904,0.03928,0.1),(0.2594,0.03794,0.1),(0.25953,0.03658,0.1),(0.25953,0.03658,0),(0.2594,0.03794,0),(0.25904,0.03928,0),(0.25879,0.03994,0),(0.25848,0.04059,0),(0.25813,0.04122,0),(0.25774,0.04183,0),(0.25684,0.04298,0),(0.25583,0.044,0),(0.25528,0.04446,0),(0.25471,0.04488,0),(0.25353,0.04558,0.0)]),
          normal=Normal(vector=[(0.44721,0.89443,-0.0),(0.56714,0.82362,-0.0),(0.61888,0.78549,-0.0),(0.66627,0.74571,-0.0),(0.75071,0.66063,-0.0),(0.82442,0.56598,-0.0),(0.85788,0.51385,-0.0),(0.88911,0.45769,-0.0),(0.9179,0.39682,-0.0),(0.9438,0.33052,-0.0),(0.98384,0.17903,-0.0),(1.0,0,0),(1.0,0,0),(0.98384,0.17903,-0.0),(0.9438,0.33052,-0.0),(0.9179,0.39682,-0.0),(0.88911,0.45769,-0.0),(0.85788,0.51385,-0.0),(0.82442,0.56598,-0.0),(0.75071,0.66063,-0.0),(0.66627,0.74571,-0.0),(0.61888,0.78549,-0.0),(0.56714,0.82362,-0.0),(0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.25953,0.03658,0.1),(0.25929,0.03277,0.1),(0.25863,0.02898,0.1),(0.25653,0.02158,0.1),(0.25653,0.02158,0),(0.25863,0.02898,0),(0.25929,0.03277,0),(0.25953,0.03658,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,-0.12161,0),(0.97691,-0.21363,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.97691,-0.21363,0),(0.99258,-0.12161,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.25653,0.02158,0.1),(0.25528,0.01873,0.1),(0.25434,0.01574,0.1),(0.25374,0.01268,0.1),(0.25358,0.01113,0.1),(0.25353,0.00958,0.1),(0.25353,0.00958,0),(0.25358,0.01113,0),(0.25374,0.01268,0),(0.25434,0.01574,0),(0.25528,0.01873,0),(0.25653,0.02158,0.0)]),
          normal=Normal(vector=[(0.89443,-0.44722,0),(0.93577,-0.35262,0),(0.96859,-0.24866,0),(0.99125,-0.13201,0),(0.99768,-0.06804,0),(1.0,0,0),(1.0,0,0),(0.99768,-0.06804,0),(0.99125,-0.13201,0),(0.96859,-0.24866,0),(0.93577,-0.35262,0),(0.89443,-0.44722,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(0.25353,0.00958,0.1),(0.25503,0.00808,0.1),(0.25653,0.00658,0.1),(0.25653,0.00658,0),(0.25503,0.00808,0),(0.25353,0.00958,0.0)]),
          normal=Normal(vector=[(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0),(0.7071,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.25653,0.00658,0.1),(0.25856,0.00479,0.1),(0.26077,0.00323,0.1),(0.26553,5.8E-4,0.1),(0.26553,5.8E-4,0),(0.26077,0.00323,0),(0.25856,0.00479,0),(0.25653,0.00658,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.61587,0.78785,-0.0),(0.53972,0.84184,-0.0),(0.44721,0.89443,-0.0),(0.44721,0.89443,-0.0),(0.53972,0.84184,-0.0),(0.61587,0.78785,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(0.26553,5.8E-4,0.1),(0.26708,5.3E-4,0.1),(0.26862,3.7E-4,0.1),(0.27169,-2.3E-4,0.1),(0.27468,-0.00117,0.1),(0.27753,-0.00242,0.1),(0.27753,-0.00242,0),(0.27468,-0.00117,0),(0.27169,-2.3E-4,0),(0.26862,3.7E-4,0),(0.26708,5.3E-4,0),(0.26553,5.8E-4,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06804,0.99768,-0.0),(0.13201,0.99125,-0.0),(0.24866,0.96859,-0.0),(0.35262,0.93577,-0.0),(0.44721,0.89443,-0.0),(0.44721,0.89443,-0.0),(0.35262,0.93577,-0.0),(0.24866,0.96859,-0.0),(0.13201,0.99125,-0.0),(0.06804,0.99768,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[13,0,12,-1,12,0,1,-1,11,1,2,-1,3,11,2,-1,3,10,11,-1,3,4,10,-1,10,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,1,11,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.27753,-0.00242,0.1),(0.27961,-0.00333,0.1),(0.28178,-0.00404,0.1),(0.28401,-0.00456,0.1),(0.28629,-0.00494,0.1),(0.29091,-0.00533,0.1),(0.29553,-0.00542,0.1),(0.29553,-0.00542,0),(0.29091,-0.00533,0),(0.28629,-0.00494,0),(0.28401,-0.00456,0),(0.28178,-0.00404,0),(0.27961,-0.00333,0),(0.27753,-0.00242,0.0)]),
          normal=Normal(vector=[(0.44721,0.89443,-0.0),(0.35328,0.93552,-0.0),(0.26836,0.96332,-0.0),(0.19461,0.98088,-0.0),(0.13281,0.99114,-0.0),(0.04437,0.99902,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0.04437,0.99902,-0.0),(0.13281,0.99114,-0.0),(0.19461,0.98088,-0.0),(0.26836,0.96332,-0.0),(0.35328,0.93552,-0.0),(0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.29553,-0.00542,0.1),(0.2979,-0.00531,0.1),(0.30027,-0.00497,0.1),(0.30261,-0.00445,0.1),(0.30493,-0.00373,0.1),(0.30719,-0.00286,0.1),(0.30938,-0.00184,0.1),(0.31353,5.8E-4,0.1),(0.31353,5.8E-4,0),(0.30938,-0.00184,0),(0.30719,-0.00286,0),(0.30493,-0.00373,0),(0.30261,-0.00445,0),(0.30027,-0.00497,0),(0.2979,-0.00531,0),(0.29553,-0.00542,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.09439,0.99554,0),(-0.18037,0.9836,0),(-0.25818,0.9661,0),(-0.32853,0.94449,0),(-0.39234,0.91982,0),(-0.45064,0.89271,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.45064,0.89271,0),(-0.39234,0.91982,0),(-0.32853,0.94449,0),(-0.25818,0.9661,0),(-0.18037,0.9836,0),(-0.09439,0.99554,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.31353,5.8E-4,0.1),(0.31842,0.00201,0.1),(0.32319,0.00391,0.1),(0.32546,0.00508,0.1),(0.32763,0.0064,0.1),(0.32966,0.0079,0.1),(0.33153,0.00958,0.1),(0.33153,0.00958,0),(0.32966,0.0079,0),(0.32763,0.0064,0),(0.32546,0.00508,0),(0.32319,0.00391,0),(0.31842,0.00201,0),(0.31353,5.8E-4,0.0)]),
          normal=Normal(vector=[(-0.24254,0.97014,0),(-0.32084,0.94713,0),(-0.42529,0.90506,0),(-0.48778,0.87297,0),(-0.55663,0.83076,0),(-0.63055,0.77615,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.63055,0.77615,0),(-0.55663,0.83076,0),(-0.48778,0.87297,0),(-0.42529,0.90506,0),(-0.32084,0.94713,0),(-0.24254,0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.33153,0.00958,0.1),(0.3336,0.0118,0.1),(0.33553,0.01417,0.1),(0.33731,0.01667,0.1),(0.33893,0.01929,0.1),(0.34037,0.022,0.1),(0.34163,0.0248,0.1),(0.34268,0.02767,0.1),(0.34353,0.03058,0.1),(0.34353,0.03058,0),(0.34268,0.02767,0),(0.34163,0.0248,0),(0.34037,0.022,0),(0.33893,0.01929,0),(0.33731,0.01667,0),(0.33553,0.01417,0),(0.3336,0.0118,0),(0.33153,0.00958,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.7533,0.65768,0),(-0.79509,0.60649,0),(-0.83298,0.5533,0),(-0.86731,0.49776,0),(-0.89827,0.43945,0),(-0.92587,0.37783,0),(-0.94996,0.31238,0),(-0.97014,0.24253,0),(-0.97014,0.24253,0),(-0.94996,0.31238,0),(-0.92587,0.37783,0),(-0.89827,0.43945,0),(-0.86731,0.49776,0),(-0.83298,0.5533,0),(-0.79509,0.60649,0),(-0.7533,0.65768,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.34353,0.03058,0.1),(0.3451,0.03324,0.1),(0.34639,0.03607,0.1),(0.34744,0.03902,0.1),(0.34824,0.04206,0.1),(0.34883,0.04517,0.1),(0.34923,0.04832,0.1),(0.34953,0.05458,0.1),(0.34953,0.05458,0),(0.34923,0.04832,0),(0.34883,0.04517,0),(0.34824,0.04206,0),(0.34744,0.03902,0),(0.34639,0.03607,0),(0.3451,0.03324,0),(0.34353,0.03058,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,0),(-0.88703,0.46172,0),(-0.92748,0.37386,0),(-0.95608,0.29311,0),(-0.97545,0.22022,0),(-0.9879,0.1551,0),(-0.99526,0.0972,0),(-1.0,0,0),(-1.0,0,0),(-0.99526,0.0972,0),(-0.9879,0.1551,0),(-0.97545,0.22022,0),(-0.95608,0.29311,0),(-0.92748,0.37386,0),(-0.88703,0.46172,0),(-0.83205,0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.34953,0.05458,0.1),(0.34933,0.05915,0.1),(0.34875,0.0637,0.1),(0.34781,0.06819,0.1),(0.34653,0.07258,0.1),(0.34653,0.07258,0),(0.34781,0.06819,0),(0.34875,0.0637,0),(0.34933,0.05915,0),(0.34953,0.05458,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99632,-0.08575,0),(-0.98605,-0.16647,0),(-0.97003,-0.24298,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.97003,-0.24298,0),(-0.98605,-0.16647,0),(-0.99632,-0.08575,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.34653,0.07258,0.1),(0.34475,0.07729,0.1),(0.34263,0.08187,0.1),(0.33753,0.09058,0.1),(0.33753,0.09058,0),(0.34263,0.08187,0),(0.34475,0.07729,0),(0.34653,0.07258,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.92164,-0.38803,0),(-0.89248,-0.45108,0),(-0.83205,-0.5547,0),(-0.83205,-0.5547,0),(-0.89248,-0.45108,0),(-0.92164,-0.38803,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,18,-1,19,20,2,-1,2,3,18,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.33753,0.09058,0.1),(0.33708,0.0914,0.1),(0.33656,0.09219,0.1),(0.336,0.09294,0.1),(0.33538,0.09365,0.1),(0.334,0.09498,0.1),(0.33247,0.09617,0.1),(0.33082,0.09722,0.1),(0.32909,0.09814,0.1),(0.32731,0.09892,0.1),(0.32553,0.09958,0.1),(0.32553,0.09958,0),(0.32731,0.09892,0),(0.32909,0.09814,0),(0.33082,0.09722,0),(0.33247,0.09617,0),(0.334,0.09498,0),(0.33538,0.09365,0),(0.336,0.09294,0),(0.33656,0.09219,0),(0.33708,0.0914,0),(0.33753,0.09058,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.85724,-0.51492,0),(-0.81744,-0.57601,0),(-0.77619,-0.6305,0),(-0.73445,-0.67867,0),(-0.65224,-0.75801,0),(-0.57451,-0.8185,0),(-0.50255,-0.86455,0),(-0.43622,-0.89984,0),(-0.37459,-0.92719,0),(-0.31623,-0.94868,0),(-0.31623,-0.94868,0),(-0.37459,-0.92719,0),(-0.43622,-0.89984,0),(-0.50255,-0.86455,0),(-0.57451,-0.8185,0),(-0.65224,-0.75801,0),(-0.73445,-0.67867,0),(-0.77619,-0.6305,0),(-0.81744,-0.57601,0),(-0.85724,-0.51492,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.32553,0.09958,0.1),(0.32286,0.10115,0.1),(0.32004,0.10245,0.1),(0.31709,0.10349,0.1),(0.31405,0.1043,0.1),(0.31094,0.10489,0.1),(0.30779,0.10529,0.1),(0.30153,0.10558,0.1),(0.30153,0.10558,0),(0.30779,0.10529,0),(0.31094,0.10489,0),(0.31405,0.1043,0),(0.31709,0.10349,0),(0.32004,0.10245,0),(0.32286,0.10115,0),(0.32553,0.09958,0.0)]),
          normal=Normal(vector=[(-0.5547,-0.83205,0),(-0.46172,-0.88703,0),(-0.37386,-0.92748,0),(-0.29311,-0.95608,0),(-0.22022,-0.97545,0),(-0.15509,-0.9879,0),(-0.0972,-0.99526,0),(0,-1.0,0),(0,-1.0,0),(-0.0972,-0.99526,0),(-0.15509,-0.9879,0),(-0.22022,-0.97545,0),(-0.29311,-0.95608,0),(-0.37386,-0.92748,0),(-0.46172,-0.88703,0),(-0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.30153,0.10558,0.1),(0.28053,0.10558,0.1),(0.28053,0.10558,0),(0.30153,0.10558,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.28053,0.10558,0.1),(0.28053,0.12658,0.1),(0.28053,0.12658,0),(0.28053,0.10558,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.28053,0.12658,0.1),(0.29553,0.12658,0.1),(0.29553,0.12658,0),(0.28053,0.12658,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(0.29553,0.12658,0.1),(0.29997,0.12676,0.1),(0.30446,0.12729,0.1),(0.30893,0.1282,0.1),(0.31331,0.12948,0.1),(0.31753,0.13115,0.1),(0.32153,0.13321,0.1),(0.32521,0.13569,0.1),(0.32692,0.13708,0.1),(0.32853,0.13858,0.1),(0.32853,0.13858,0),(0.32692,0.13708,0),(0.32521,0.13569,0),(0.32153,0.13321,0),(0.31753,0.13115,0),(0.31331,0.12948,0),(0.30893,0.1282,0),(0.30446,0.12729,0),(0.29997,0.12676,0),(0.29553,0.12658,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.07881,0.99689,0),(-0.15769,0.98749,0),(-0.23865,0.97111,0),(-0.32332,0.94629,0),(-0.4129,0.91078,0),(-0.50772,0.86152,0),(-0.6068,0.79485,0),(-0.65709,0.75381,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.65709,0.75381,0),(-0.6068,0.79485,0),(-0.50772,0.86152,0),(-0.4129,0.91078,0),(-0.32332,0.94629,0),(-0.23865,0.97111,0),(-0.15769,0.98749,0),(-0.07881,0.99689,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(0.32853,0.13858,0.1),(0.33025,0.14045,0.1),(0.3318,0.14246,0.1),(0.33321,0.14459,0.1),(0.33446,0.14682,0.1),(0.33655,0.15156,0.1),(0.33813,0.15659,0.1),(0.33927,0.1618,0.1),(0.34,0.1671,0.1),(0.34053,0.17758,0.1),(0.34053,0.17758,0),(0.34,0.1671,0),(0.33927,0.1618,0),(0.33813,0.15659,0),(0.33655,0.15156,0),(0.33446,0.14682,0),(0.33321,0.14459,0),(0.3318,0.14246,0),(0.33025,0.14045,0),(0.32853,0.13858,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.76448,0.64465,0),(-0.81347,0.5816,0),(-0.85444,0.51955,0),(-0.88809,0.45968,0),(-0.93695,0.34946,0),(-0.96722,0.25394,0),(-0.98493,0.17294,0),(-0.99448,0.10489,0),(-1.0,0,0),(-1.0,0,0),(-0.99448,0.10489,0),(-0.98493,0.17294,0),(-0.96722,0.25394,0),(-0.93695,0.34946,0),(-0.88809,0.45968,0),(-0.85444,0.51955,0),(-0.81347,0.5816,0),(-0.76448,0.64465,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,10,-1,11,12,8,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,8,9,10,-1],solid=False,
          coord=Coordinate(point=[(0.34053,0.17758,0.1),(0.34035,0.18202,0.1),(0.33982,0.18651,0.1),(0.33891,0.19098,0.1),(0.33763,0.19537,0.1),(0.33596,0.19959,0.1),(0.33389,0.20358,0.1),(0.33142,0.20727,0.1),(0.33003,0.20898,0.1),(0.32853,0.21058,0.1),(0.32853,0.21058,0),(0.33003,0.20898,0),(0.33142,0.20727,0),(0.33389,0.20358,0),(0.33596,0.19959,0),(0.33763,0.19537,0),(0.33891,0.19098,0),(0.33982,0.18651,0),(0.34035,0.18202,0),(0.34053,0.17758,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99689,-0.07881,0),(-0.98749,-0.15769,0),(-0.97111,-0.23864,0),(-0.94629,-0.32332,0),(-0.91078,-0.41289,0),(-0.86152,-0.50772,0),(-0.79485,-0.6068,0),(-0.75381,-0.65709,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.75381,-0.65709,0),(-0.79485,-0.6068,0),(-0.86152,-0.50772,0),(-0.91078,-0.41289,0),(-0.94629,-0.32332,0),(-0.97111,-0.23864,0),(-0.98749,-0.15769,0),(-0.99689,-0.07881,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[23,0,22,-1,22,0,1,-1,21,1,2,-1,3,21,2,-1,3,20,21,-1,3,4,20,-1,20,4,19,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,1,21,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.32853,0.21058,0.1),(0.32724,0.21214,0.1),(0.32582,0.21357,0.1),(0.32428,0.21489,0.1),(0.32263,0.21609,0.1),(0.32087,0.21718,0.1),(0.31903,0.21816,0.1),(0.31514,0.21981,0.1),(0.31105,0.22106,0.1),(0.30685,0.22192,0.1),(0.30264,0.22242,0.1),(0.29853,0.22258,0.1),(0.29853,0.22258,0),(0.30264,0.22242,0),(0.30685,0.22192,0),(0.31105,0.22106,0),(0.31514,0.21981,0),(0.31903,0.21816,0),(0.32087,0.21718,0),(0.32263,0.21609,0),(0.32428,0.21489,0),(0.32582,0.21357,0),(0.32724,0.21214,0),(0.32853,0.21058,0.0)]),
          normal=Normal(vector=[(-0.8,-0.6,0),(-0.74119,-0.6713,0),(-0.68011,-0.73311,0),(-0.61857,-0.78573,0),(-0.55795,-0.82987,0),(-0.49922,-0.86648,0),(-0.44292,-0.89656,0),(-0.33848,-0.94098,0),(-0.2444,-0.96968,0),(-0.15863,-0.98734,0),(-0.07829,-0.99693,0),(0,-1.0,0),(0,-1.0,0),(-0.07829,-0.99693,0),(-0.15863,-0.98734,0),(-0.2444,-0.96968,0),(-0.33848,-0.94098,0),(-0.44292,-0.89656,0),(-0.49922,-0.86648,0),(-0.55795,-0.82987,0),(-0.61857,-0.78573,0),(-0.68011,-0.73311,0),(-0.74119,-0.6713,0),(-0.8,-0.6,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.29853,0.22258,0.1),(0.29467,0.22243,0.1),(0.29083,0.22194,0.1),(0.28893,0.22153,0.1),(0.28708,0.22101,0.1),(0.28527,0.22036,0.1),(0.28353,0.21958,0.1),(0.28353,0.21958,0),(0.28527,0.22036,0),(0.28708,0.22101,0),(0.28893,0.22153,0),(0.29083,0.22194,0),(0.29467,0.22243,0),(0.29853,0.22258,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0.07973,-0.99682,0),(0.17989,-0.98369,0),(0.23845,-0.97116,0),(0.3028,-0.95305,0),(0.37265,-0.92797,0),(0.44721,-0.89443,0),(0.44721,-0.89443,0),(0.37265,-0.92797,0),(0.3028,-0.95305,0),(0.23845,-0.97116,0),(0.17989,-0.98369,0),(0.07973,-0.99682,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.28353,0.21958,0.1),(0.27877,0.21693,0.1),(0.27656,0.21537,0.1),(0.27453,0.21358,0.1),(0.27453,0.21358,0),(0.27656,0.21537,0),(0.27877,0.21693,0),(0.28353,0.21958,0.0)]),
          normal=Normal(vector=[(0.44722,-0.89443,0),(0.53972,-0.84184,0),(0.61587,-0.78785,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.61587,-0.78785,0),(0.53972,-0.84184,0),(0.44722,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,5,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1],solid=False,
          coord=Coordinate(point=[(0.27453,0.21358,0.1),(0.26977,0.21093,0.1),(0.26756,0.20937,0.1),(0.26553,0.20758,0.1),(0.26553,0.20758,0),(0.26756,0.20937,0),(0.26977,0.21093,0),(0.27453,0.21358,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.53972,-0.84184,0),(0.61587,-0.78785,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.61587,-0.78785,0),(0.53972,-0.84184,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(0.26553,0.20758,0.1),(0.26403,0.20608,0.1),(0.26253,0.20458,0.1),(0.26253,0.20458,0),(0.26403,0.20608,0),(0.26553,0.20758,0.0)]),
          normal=Normal(vector=[(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.26253,0.20458,0.1),(0.26277,0.20077,0.1),(0.26342,0.19698,0.1),(0.26553,0.18958,0.1),(0.26553,0.18958,0),(0.26342,0.19698,0),(0.26277,0.20077,0),(0.26253,0.20458,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,0.12161,-0.0),(0.97691,0.21363,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.97691,0.21363,-0.0),(0.99258,0.12161,-0.0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[13,0,12,-1,12,0,1,-1,11,1,2,-1,3,11,2,-1,3,10,11,-1,3,4,10,-1,10,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,1,11,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.26553,0.18958,0.1),(0.26631,0.18784,0.1),(0.26696,0.18603,0.1),(0.26748,0.18418,0.1),(0.26788,0.18228,0.1),(0.26838,0.17843,0.1),(0.26853,0.17458,0.1),(0.26853,0.17458,0),(0.26838,0.17843,0),(0.26788,0.18228,0),(0.26748,0.18418,0),(0.26696,0.18603,0),(0.26631,0.18784,0),(0.26553,0.18958,0.0)]),
          normal=Normal(vector=[(0.89443,0.44721,-0.0),(0.92797,0.37265,-0.0),(0.95305,0.3028,-0.0),(0.97116,0.23845,-0.0),(0.98369,0.17989,-0.0),(0.99682,0.07973,-0.0),(1.0,0,0),(1.0,0,0),(0.99682,0.07973,-0.0),(0.98369,0.17989,-0.0),(0.97116,0.23845,-0.0),(0.95305,0.3028,-0.0),(0.92797,0.37265,-0.0),(0.89443,0.44721,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,13,-1,14,15,7,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,7,8,13,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.26853,0.17458,0.1),(0.26849,0.17374,0.1),(0.2684,0.17291,0.1),(0.26824,0.17208,0.1),(0.26803,0.17126,0.1),(0.26746,0.16965,0.1),(0.26671,0.16809,0.1),(0.26582,0.16659,0.1),(0.2648,0.16516,0.1),(0.26369,0.16382,0.1),(0.26253,0.16258,0.1),(0.26253,0.16258,0),(0.26369,0.16382,0),(0.2648,0.16516,0),(0.26582,0.16659,0),(0.26671,0.16809,0),(0.26746,0.16965,0),(0.26803,0.17126,0),(0.26824,0.17208,0),(0.2684,0.17291,0),(0.26849,0.17374,0),(0.26853,0.17458,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99702,-0.0772,0),(0.98874,-0.14963,0),(0.97621,-0.21681,0),(0.96042,-0.27857,0),(0.92238,-0.38629,0),(0.8799,-0.47516,0),(0.83613,-0.54853,0),(0.79259,-0.60976,0),(0.7497,-0.66178,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.7497,-0.66178,0),(0.79259,-0.60976,0),(0.83613,-0.54853,0),(0.8799,-0.47516,0),(0.92238,-0.38629,0),(0.96042,-0.27857,0),(0.97621,-0.21681,0),(0.98874,-0.14963,0),(0.99702,-0.0772,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[13,0,12,-1,12,0,1,-1,11,1,2,-1,3,11,2,-1,3,10,11,-1,3,4,10,-1,10,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,1,11,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.26253,0.16258,0.1),(0.26044,0.16167,0.1),(0.25827,0.16096,0.1),(0.25604,0.16044,0.1),(0.25377,0.16006,0.1),(0.24914,0.15967,0.1),(0.24453,0.15958,0.1),(0.24453,0.15958,0),(0.24914,0.15967,0),(0.25377,0.16006,0),(0.25604,0.16044,0),(0.25827,0.16096,0),(0.26044,0.16167,0),(0.26253,0.16258,0.0)]),
          normal=Normal(vector=[(0.44722,-0.89443,0),(0.35328,-0.93552,0),(0.26836,-0.96332,0),(0.19461,-0.98088,0),(0.13281,-0.99114,0),(0.04437,-0.99902,0),(0,-1.0,0),(0,-1.0,0),(0.04437,-0.99902,0),(0.13281,-0.99114,0),(0.19461,-0.98088,0),(0.26836,-0.96332,0),(0.35328,-0.93552,0),(0.44722,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[25,0,24,-1,24,0,1,-1,23,1,2,-1,3,23,2,-1,3,22,23,-1,3,4,22,-1,22,4,21,-1,21,4,5,-1,20,5,6,-1,19,6,7,-1,18,7,8,-1,17,8,9,-1,16,9,10,-1,15,10,11,-1,14,11,12,-1,13,14,12,-1,24,1,23,-1,21,5,20,-1,20,6,19,-1,19,7,18,-1,18,8,17,-1,17,9,16,-1,16,10,15,-1,15,11,14,-1],solid=False,
          coord=Coordinate(point=[(0.24453,0.15958,0.1),(0.24281,0.15967,0.1),(0.24105,0.15996,0.1),(0.23929,0.16042,0.1),(0.2376,0.16108,0.1),(0.23679,0.16148,0.1),(0.23602,0.16192,0.1),(0.2353,0.16242,0.1),(0.23462,0.16296,0.1),(0.23399,0.16354,0.1),(0.23343,0.16417,0.1),(0.23294,0.16485,0.1),(0.23253,0.16558,0.1),(0.23253,0.16558,0),(0.23294,0.16485,0),(0.23343,0.16417,0),(0.23399,0.16354,0),(0.23462,0.16296,0),(0.2353,0.16242,0),(0.23602,0.16192,0),(0.23679,0.16148,0),(0.2376,0.16108,0),(0.23929,0.16042,0),(0.24105,0.15996,0),(0.24281,0.15967,0),(0.24453,0.15958,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.10658,-0.9943,0),(-0.20754,-0.97823,0),(-0.30884,-0.95111,0),(-0.41521,-0.90972,0),(-0.47139,-0.88193,0),(-0.52987,-0.84808,0),(-0.59062,-0.80695,0),(-0.65321,-0.75717,0),(-0.71677,-0.69731,0),(-0.77974,-0.6261,0),(-0.83992,-0.54271,0),(-0.89443,-0.44721,0),(-0.89443,-0.44721,0),(-0.83992,-0.54271,0),(-0.77974,-0.6261,0),(-0.71677,-0.69731,0),(-0.65321,-0.75717,0),(-0.59062,-0.80695,0),(-0.52987,-0.84808,0),(-0.47139,-0.88193,0),(-0.41521,-0.90972,0),(-0.30884,-0.95111,0),(-0.20754,-0.97823,0),(-0.10658,-0.9943,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[13,0,12,-1,12,0,1,-1,11,1,2,-1,3,11,2,-1,3,10,11,-1,3,4,10,-1,10,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,1,11,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.23253,0.16558,0.1),(0.23174,0.16733,0.1),(0.2311,0.16913,0.1),(0.23058,0.17099,0.1),(0.23017,0.17288,0.1),(0.22968,0.17673,0.1),(0.22953,0.18058,0.1),(0.22953,0.18058,0),(0.22968,0.17673,0),(0.23017,0.17288,0),(0.23058,0.17099,0),(0.2311,0.16913,0),(0.23174,0.16733,0),(0.23253,0.16558,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.92797,-0.37265,0),(-0.95305,-0.3028,0),(-0.97116,-0.23845,0),(-0.98369,-0.17989,0),(-0.99682,-0.07973,0),(-1.0,0,0),(-1.0,0,0),(-0.99682,-0.07973,0),(-0.98369,-0.17989,0),(-0.97116,-0.23845,0),(-0.95305,-0.3028,0),(-0.92797,-0.37265,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,6,-1,7,8,2,-1,2,3,6,-1,6,3,4,-1,5,6,4,-1],solid=False,
          coord=Coordinate(point=[(0.22953,0.18058,0.1),(0.22973,0.18515,0.1),(0.23031,0.1897,0.1),(0.23125,0.19419,0.1),(0.23253,0.19858,0.1),(0.23253,0.19858,0),(0.23125,0.19419,0),(0.23031,0.1897,0),(0.22973,0.18515,0),(0.22953,0.18058,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99632,0.08575,0),(-0.98605,0.16647,0),(-0.97003,0.24298,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.97003,0.24298,0),(-0.98605,0.16647,0),(-0.99632,0.08575,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.23253,0.19858,0.1),(0.23958,0.20795,0.1),(0.24753,0.21658,0.1),(0.24753,0.21658,0),(0.23958,0.20795,0),(0.23253,0.19858,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,0),(-0.76566,0.64324,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.76566,0.64324,0),(-0.83205,0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.24753,0.21658,0.1),(0.25919,0.22462,0.1),(0.27153,0.23158,0.1),(0.27153,0.23158,0),(0.25919,0.22462,0),(0.24753,0.21658,0.0)]),
          normal=Normal(vector=[(-0.6,0.8,0),(-0.53212,0.84667,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.53212,0.84667,0),(-0.6,0.8,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(0.27153,0.23158,0.1),(0.27582,0.23314,0.1),(0.28021,0.23442,0.1),(0.2892,0.23628,0.1),(0.29836,0.23728,0.1),(0.30753,0.23758,0.1),(0.30753,0.23758,0),(0.29836,0.23728,0),(0.2892,0.23628,0),(0.28021,0.23442,0),(0.27582,0.23314,0),(0.27153,0.23158,0.0)]),
          normal=Normal(vector=[(-0.37139,0.92848,0),(-0.31054,0.95056,0),(-0.25355,0.96732,0),(-0.15234,0.98833,0),(-0.06825,0.99767,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.06825,0.99767,0),(-0.15234,0.98833,0),(-0.25355,0.96732,0),(-0.31054,0.95056,0),(-0.37139,0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.30753,0.23758,0.1),(0.31621,0.23714,0.1),(0.32057,0.23654,0.1),(0.32488,0.23565,0.1),(0.32908,0.23443,0.1),(0.33313,0.23287,0.1),(0.33696,0.23093,0.1),(0.34053,0.22858,0.1),(0.34053,0.22858,0),(0.33696,0.23093,0),(0.33313,0.23287,0),(0.32908,0.23443,0),(0.32488,0.23565,0),(0.32057,0.23654,0),(0.31621,0.23714,0),(0.30753,0.23758,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.10549,0.99442,-0.0),(0.16797,0.98579,-0.0),(0.23831,0.97119,-0.0),(0.31721,0.94836,-0.0),(0.40477,0.91442,-0.0),(0.49996,0.86605,-0.0),(0.6,0.8,-0.0),(0.6,0.8,-0.0),(0.49996,0.86605,-0.0),(0.40477,0.91442,-0.0),(0.31721,0.94836,-0.0),(0.23831,0.97119,-0.0),(0.16797,0.98579,-0.0),(0.10549,0.99442,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.34053,0.22858,0.1),(0.34703,0.2257,0.1),(0.35331,0.22227,0.1),(0.35919,0.21825,0.1),(0.36194,0.216,0.1),(0.36453,0.21358,0.1),(0.36453,0.21358,0),(0.36194,0.216,0),(0.35919,0.21825,0),(0.35331,0.22227,0),(0.34703,0.2257,0),(0.34053,0.22858,0.0)]),
          normal=Normal(vector=[(0.37139,0.92848,-0.0),(0.44036,0.89782,-0.0),(0.51995,0.8542,-0.0),(0.60979,0.79256,-0.0),(0.65782,0.75317,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.65782,0.75317,-0.0),(0.60979,0.79256,-0.0),(0.51995,0.8542,-0.0),(0.44036,0.89782,-0.0),(0.37139,0.92848,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.36453,0.21358,0.1),(0.36823,0.20958,0.1),(0.37158,0.20523,0.1),(0.37307,0.20294,0.1),(0.37441,0.20056,0.1),(0.37557,0.19811,0.1),(0.37653,0.19558,0.1),(0.37653,0.19558,0),(0.37557,0.19811,0),(0.37441,0.20056,0),(0.37307,0.20294,0),(0.37158,0.20523,0),(0.36823,0.20958,0),(0.36453,0.21358,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.76123,0.64848,-0.0),(0.82277,0.56837,-0.0),(0.85532,0.5181,-0.0),(0.88802,0.4598,-0.0),(0.91968,0.39267,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.91968,0.39267,-0.0),(0.88802,0.4598,-0.0),(0.85532,0.5181,-0.0),(0.82277,0.56837,-0.0),(0.76123,0.64848,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.37653,0.19558,0.1),(0.37781,0.19119,0.1),(0.37875,0.1867,0.1),(0.37933,0.18215,0.1),(0.37953,0.17758,0.1),(0.37953,0.17758,0),(0.37933,0.18215,0),(0.37875,0.1867,0),(0.37781,0.19119,0),(0.37653,0.19558,0.0)]),
          normal=Normal(vector=[(0.94868,0.31623,-0.0),(0.97003,0.24298,-0.0),(0.98605,0.16647,-0.0),(0.99632,0.08575,-0.0),(1.0,0,0),(1.0,0,0),(0.99632,0.08575,-0.0),(0.98605,0.16647,-0.0),(0.97003,0.24298,-0.0),(0.94868,0.31623,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.37953,0.17758,0.1),(0.37929,0.17377,0.1),(0.37863,0.16998,0.1),(0.37653,0.16258,0.1),(0.37653,0.16258,0),(0.37863,0.16998,0),(0.37929,0.17377,0),(0.37953,0.17758,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,-0.12161,0),(0.97691,-0.21363,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.97691,-0.21363,0),(0.99258,-0.12161,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.37653,0.16258,0.1),(0.37475,0.15787,0.1),(0.37263,0.15329,0.1),(0.36753,0.14458,0.1),(0.36753,0.14458,0),(0.37263,0.15329,0),(0.37475,0.15787,0),(0.37653,0.16258,0.0)]),
          normal=Normal(vector=[(0.94868,-0.31623,0),(0.92164,-0.38803,0),(0.89248,-0.45108,0),(0.83205,-0.5547,0),(0.83205,-0.5547,0),(0.89248,-0.45108,0),(0.92164,-0.38803,0),(0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.36753,0.14458,0.1),(0.36436,0.14031,0.1),(0.36076,0.13635,0.1),(0.3568,0.13275,0.1),(0.35253,0.12958,0.1),(0.35253,0.12958,0),(0.3568,0.13275,0),(0.36076,0.13635,0),(0.36436,0.14031,0),(0.36753,0.14458,0.0)]),
          normal=Normal(vector=[(0.83205,-0.5547,0),(0.77259,-0.63491,0),(0.70711,-0.70711,0),(0.63491,-0.77259,0),(0.5547,-0.83205,0),(0.5547,-0.83205,0),(0.63491,-0.77259,0),(0.70711,-0.70711,0),(0.77259,-0.63491,0),(0.83205,-0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.35253,0.12958,0.1),(0.34604,0.12665,0.1),(0.33933,0.12419,0.1),(0.32553,0.12058,0.1),(0.32553,0.12058,0),(0.33933,0.12419,0),(0.34604,0.12665,0),(0.35253,0.12958,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.37732,-0.92608,0),(0.31212,-0.95004,0),(0.19612,-0.98058,0),(0.19612,-0.98058,0),(0.31212,-0.95004,0),(0.37732,-0.92608,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.32553,0.12058,0.1),(0.32553,0.11758,0.1),(0.32553,0.11758,0),(0.32553,0.12058,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[5,0,4,-1,4,0,1,-1,3,1,2,-1,3,4,1,-1],solid=False,
          coord=Coordinate(point=[(0.32553,0.11758,0.1),(0.33597,0.11438,0.1),(0.34653,0.11158,0.1),(0.34653,0.11158,0),(0.33597,0.11438,0),(0.32553,0.11758,0.0)]),
          normal=Normal(vector=[(0.31623,0.94868,-0.0),(0.27229,0.96222,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.27229,0.96222,-0.0),(0.31623,0.94868,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.34653,0.11158,0.1),(0.35203,0.10999,0.1),(0.35742,0.10797,0.1),(0.36261,0.10551,0.1),(0.36753,0.10258,0.1),(0.36753,0.10258,0),(0.36261,0.10551,0),(0.35742,0.10797,0),(0.35203,0.10999,0),(0.34653,0.11158,0.0)]),
          normal=Normal(vector=[(0.24254,0.97014,-0.0),(0.31323,0.94968,-0.0),(0.3887,0.92136,-0.0),(0.46933,0.88303,-0.0),(0.5547,0.83205,-0.0),(0.5547,0.83205,-0.0),(0.46933,0.88303,-0.0),(0.3887,0.92136,-0.0),(0.31323,0.94968,-0.0),(0.24254,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.36753,0.10258,0.1),(0.3719,0.09782,0.1),(0.37587,0.09269,0.1),(0.37942,0.08725,0.1),(0.38253,0.08158,0.1),(0.38253,0.08158,0),(0.37942,0.08725,0),(0.37587,0.09269,0),(0.3719,0.09782,0),(0.36753,0.10258,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.76514,0.64387,-0.0),(0.81495,0.57953,-0.0),(0.85773,0.5141,-0.0),(0.89443,0.44721,-0.0),(0.89443,0.44721,-0.0),(0.85773,0.5141,-0.0),(0.81495,0.57953,-0.0),(0.76514,0.64387,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.38253,0.08158,0.1),(0.38344,0.08011,0.1),(0.38425,0.0786,0.1),(0.38562,0.07542,0.1),(0.38667,0.0721,0.1),(0.38744,0.06866,0.1),(0.38831,0.06161,0.1),(0.38853,0.05458,0.1),(0.38853,0.05458,0),(0.38831,0.06161,0),(0.38744,0.06866,0),(0.38667,0.0721,0),(0.38562,0.07542,0),(0.38425,0.0786,0),(0.38344,0.08011,0),(0.38253,0.08158,0.0)]),
          normal=Normal(vector=[(0.83205,0.5547,-0.0),(0.86597,0.5001,-0.0),(0.89465,0.44677,-0.0),(0.93799,0.34667,-0.0),(0.96612,0.25811,-0.0),(0.98322,0.18244,-0.0),(0.99763,0.06877,-0.0),(1.0,0,0),(1.0,0,0),(0.99763,0.06877,-0.0),(0.98322,0.18244,-0.0),(0.96612,0.25811,-0.0),(0.93799,0.34667,-0.0),(0.89465,0.44677,-0.0),(0.86597,0.5001,-0.0),(0.83205,0.5547,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[21,0,20,-1,20,0,1,-1,19,1,2,-1,3,19,2,-1,3,18,19,-1,3,4,18,-1,18,4,17,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,1,19,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.38853,0.05458,0.1),(0.38839,0.05097,0.1),(0.38799,0.04735,0.1),(0.38734,0.04374,0.1),(0.38644,0.04016,0.1),(0.38399,0.0331,0.1),(0.38072,0.0263,0.1),(0.37674,0.01984,0.1),(0.37215,0.01383,0.1),(0.36705,0.00837,0.1),(0.36153,0.00358,0.1),(0.36153,0.00358,0),(0.36705,0.00837,0),(0.37215,0.01383,0),(0.37674,0.01984,0),(0.38072,0.0263,0),(0.38399,0.0331,0),(0.38644,0.04016,0),(0.38734,0.04374,0),(0.38799,0.04735,0),(0.38839,0.05097,0),(0.38853,0.05458,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99721,-0.07465,0),(0.98945,-0.14485,0),(0.97758,-0.21056,0),(0.96232,-0.27191,0),(0.92389,-0.38266,0),(0.8773,-0.47993,0),(0.82386,-0.5668,0),(0.76334,-0.646,0),(0.69427,-0.71972,0),(0.61394,-0.78935,0),(0.61394,-0.78935,0),(0.69427,-0.71972,0),(0.76334,-0.646,0),(0.82386,-0.5668,0),(0.8773,-0.47993,0),(0.92389,-0.38266,0),(0.96232,-0.27191,0),(0.97758,-0.21056,0),(0.98945,-0.14485,0),(0.99721,-0.07465,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.36153,0.00358,0.1),(0.35434,-0.0021,0.1),(0.34649,-0.00699,0.1),(0.33812,-0.01112,0.1),(0.32933,-0.01449,0.1),(0.32026,-0.01709,0.1),(0.31102,-0.01894,0.1),(0.30174,-0.02005,0.1),(0.29253,-0.02042,0.1),(0.29253,-0.02042,0),(0.30174,-0.02005,0),(0.31102,-0.01894,0),(0.32026,-0.01709,0),(0.32933,-0.01449,0),(0.33812,-0.01112,0),(0.34649,-0.00699,0),(0.35434,-0.0021,0),(0.36153,0.00358,0.0)]),
          normal=Normal(vector=[(0.66436,-0.74741,0),(0.5742,-0.81872,0),(0.48534,-0.87432,0),(0.39926,-0.91684,0),(0.31628,-0.94867,0),(0.23596,-0.97176,0),(0.15736,-0.98754,0),(0.07921,-0.99686,0),(0,-1.0,0),(0,-1.0,0),(0.07921,-0.99686,0),(0.15736,-0.98754,0),(0.23596,-0.97176,0),(0.31628,-0.94867,0),(0.39926,-0.91684,0),(0.48534,-0.87432,0),(0.5742,-0.81872,0),(0.66436,-0.74741,0.0)]))),
      Shape(
        appearance=Appearance(USE='character3Appearance'),
        geometry=IndexedFaceSet(coordIndex=[321,0,8,-1,320,8,9,-1,319,9,10,-1,318,10,238,-1,239,318,238,-1,239,240,318,-1,318,240,241,-1,242,318,241,-1,242,243,318,-1,318,243,244,-1,249,244,248,-1,249,318,244,-1,249,250,318,-1,318,250,251,-1,252,318,251,-1,252,253,318,-1,318,253,254,-1,317,254,255,-1,256,317,255,-1,256,316,317,-1,256,257,316,-1,316,257,315,-1,315,257,281,-1,282,315,281,-1,282,314,315,-1,282,312,314,-1,282,311,312,-1,282,283,311,-1,311,283,310,-1,310,283,284,-1,285,310,284,-1,285,286,310,-1,310,286,287,-1,288,310,287,-1,288,309,310,-1,288,299,309,-1,288,289,299,-1,299,289,290,-1,291,299,290,-1,291,292,299,-1,299,292,293,-1,294,299,293,-1,294,295,299,-1,299,295,296,-1,297,299,296,-1,297,298,299,-1,2,7,1,-1,2,6,7,-1,2,3,6,-1,6,3,5,-1,5,3,4,-1,7,8,1,-1,1,8,0,-1,321,8,320,-1,320,9,319,-1,11,233,10,-1,11,232,233,-1,11,231,232,-1,11,230,231,-1,11,12,230,-1,230,12,229,-1,229,12,228,-1,228,12,227,-1,227,12,226,-1,226,12,13,-1,225,13,224,-1,225,226,13,-1,13,14,224,-1,224,14,223,-1,223,14,222,-1,222,14,221,-1,221,14,15,-1,220,15,219,-1,220,221,15,-1,15,16,219,-1,219,16,218,-1,218,16,217,-1,217,16,17,-1,216,17,215,-1,216,217,17,-1,215,17,214,-1,214,17,18,-1,213,18,19,-1,212,19,20,-1,211,20,21,-1,210,21,22,-1,209,22,23,-1,208,23,207,-1,208,209,23,-1,214,18,213,-1,213,19,212,-1,212,20,211,-1,211,21,210,-1,210,22,209,-1,23,24,207,-1,207,24,25,-1,206,25,26,-1,205,26,27,-1,28,205,27,-1,28,29,205,-1,205,29,204,-1,204,29,30,-1,203,30,202,-1,203,204,30,-1,207,25,206,-1,206,26,205,-1,202,30,201,-1,201,30,31,-1,200,31,199,-1,200,201,31,-1,32,196,31,-1,32,195,196,-1,32,194,195,-1,32,193,194,-1,32,192,193,-1,32,191,192,-1,32,33,191,-1,191,33,190,-1,190,33,189,-1,189,33,188,-1,188,33,187,-1,187,33,34,-1,186,34,35,-1,185,35,36,-1,37,185,36,-1,37,38,185,-1,185,38,39,-1,40,185,39,-1,40,184,185,-1,40,41,184,-1,184,41,183,-1,183,41,42,-1,182,42,181,-1,182,183,42,-1,187,34,186,-1,186,35,185,-1,43,179,42,-1,43,178,179,-1,43,44,178,-1,178,44,177,-1,177,44,176,-1,176,44,45,-1,175,45,174,-1,175,176,45,-1,45,46,174,-1,174,46,173,-1,173,46,172,-1,172,46,47,-1,171,47,170,-1,171,172,47,-1,170,47,169,-1,169,47,48,-1,168,48,49,-1,167,49,50,-1,166,50,51,-1,52,166,51,-1,52,165,166,-1,52,53,165,-1,165,53,164,-1,164,53,54,-1,163,54,55,-1,162,55,56,-1,161,56,57,-1,58,161,57,-1,58,160,161,-1,58,59,160,-1,160,59,60,-1,159,60,61,-1,158,61,157,-1,158,159,61,-1,169,48,168,-1,168,49,167,-1,167,50,166,-1,164,54,163,-1,163,55,162,-1,162,56,161,-1,160,60,159,-1,61,62,157,-1,157,62,156,-1,156,62,155,-1,155,62,154,-1,154,62,63,-1,153,63,64,-1,152,64,151,-1,152,153,64,-1,154,63,153,-1,151,64,150,-1,150,64,65,-1,149,65,148,-1,149,150,65,-1,148,65,147,-1,147,65,66,-1,146,66,145,-1,146,147,66,-1,66,67,145,-1,145,67,68,-1,69,145,68,-1,69,70,145,-1,145,70,71,-1,72,145,71,-1,72,73,145,-1,145,73,74,-1,75,145,74,-1,75,76,145,-1,145,76,77,-1,78,145,77,-1,78,79,145,-1,145,79,80,-1,81,145,80,-1,81,144,145,-1,81,143,144,-1,81,142,143,-1,81,141,142,-1,81,140,141,-1,81,139,140,-1,81,138,139,-1,81,137,138,-1,81,136,137,-1,81,135,136,-1,81,134,135,-1,81,133,134,-1,81,132,133,-1,81,131,132,-1,81,82,131,-1,131,82,130,-1,130,82,83,-1,129,83,107,-1,108,129,107,-1,108,128,129,-1,108,109,128,-1,128,109,110,-1,127,110,126,-1,127,128,110,-1,84,85,83,-1,83,85,106,-1,107,83,106,-1,85,86,106,-1,106,86,87,-1,105,87,88,-1,104,88,89,-1,103,89,102,-1,103,104,89,-1,106,87,105,-1,105,88,104,-1,89,90,102,-1,102,90,91,-1,101,91,92,-1,100,92,99,-1,100,101,92,-1,102,91,101,-1,92,93,99,-1,99,93,98,-1,98,93,97,-1,97,93,96,-1,96,93,94,-1,95,96,94,-1,126,110,125,-1,125,110,111,-1,124,111,123,-1,124,125,111,-1,112,113,111,-1,111,113,114,-1,123,114,115,-1,116,123,115,-1,116,117,123,-1,123,117,118,-1,122,118,119,-1,120,122,119,-1,120,121,122,-1,111,114,123,-1,123,118,122,-1,129,130,83,-1,179,180,42,-1,42,180,181,-1,196,197,31,-1,31,197,198,-1,199,31,198,-1,233,234,10,-1,10,234,235,-1,236,10,235,-1,236,237,10,-1,10,237,238,-1,248,244,247,-1,247,244,245,-1,246,247,245,-1,318,254,317,-1,281,257,280,-1,280,257,258,-1,279,258,278,-1,279,280,258,-1,278,258,277,-1,277,258,259,-1,276,259,275,-1,276,277,259,-1,260,273,259,-1,260,272,273,-1,260,261,272,-1,272,261,271,-1,271,261,270,-1,270,261,269,-1,269,261,268,-1,268,261,267,-1,267,261,262,-1,266,262,265,-1,266,267,262,-1,263,264,262,-1,262,264,265,-1,273,274,259,-1,259,274,275,-1,300,302,299,-1,300,301,302,-1,302,303,299,-1,299,303,304,-1,305,299,304,-1,305,306,299,-1,299,306,307,-1,308,299,307,-1,308,309,299,-1,312,313,314,-1,318,319,10,-1],solid=False,
          coord=Coordinate(point=[(0.26253,-0.01442,0.1),(0.26978,-0.01695,0.1),(0.27725,-0.01884,0.1),(0.28487,-0.02001,0.1),(0.29253,-0.02042,0.1),(0.30174,-0.02005,0.1),(0.31102,-0.01894,0.1),(0.32026,-0.01709,0.1),(0.32933,-0.01449,0.1),(0.33812,-0.01112,0.1),(0.34649,-0.00699,0.1),(0.35434,-0.0021,0.1),(0.36153,0.00358,0.1),(0.36705,0.00837,0.1),(0.37215,0.01383,0.1),(0.37674,0.01984,0.1),(0.38072,0.0263,0.1),(0.38399,0.0331,0.1),(0.38644,0.04016,0.1),(0.38734,0.04374,0.1),(0.38799,0.04735,0.1),(0.38839,0.05097,0.1),(0.38853,0.05458,0.1),(0.38831,0.06161,0.1),(0.38744,0.06866,0.1),(0.38667,0.0721,0.1),(0.38562,0.07542,0.1),(0.38425,0.0786,0.1),(0.38344,0.08011,0.1),(0.38253,0.08158,0.1),(0.37942,0.08725,0.1),(0.37587,0.09269,0.1),(0.3719,0.09782,0.1),(0.36753,0.10258,0.1),(0.36261,0.10551,0.1),(0.35742,0.10797,0.1),(0.35203,0.10999,0.1),(0.34653,0.11158,0.1),(0.33597,0.11438,0.1),(0.32553,0.11758,0.1),(0.32553,0.12058,0.1),(0.33933,0.12419,0.1),(0.34604,0.12665,0.1),(0.35253,0.12958,0.1),(0.3568,0.13275,0.1),(0.36076,0.13635,0.1),(0.36436,0.14031,0.1),(0.36753,0.14458,0.1),(0.37263,0.15329,0.1),(0.37475,0.15787,0.1),(0.37653,0.16258,0.1),(0.37863,0.16998,0.1),(0.37929,0.17377,0.1),(0.37953,0.17758,0.1),(0.37933,0.18215,0.1),(0.37875,0.1867,0.1),(0.37781,0.19119,0.1),(0.37653,0.19558,0.1),(0.37557,0.19811,0.1),(0.37441,0.20056,0.1),(0.37307,0.20294,0.1),(0.37158,0.20523,0.1),(0.36823,0.20958,0.1),(0.36453,0.21358,0.1),(0.36194,0.216,0.1),(0.35919,0.21825,0.1),(0.35331,0.22227,0.1),(0.34703,0.2257,0.1),(0.34053,0.22858,0.1),(0.33696,0.23093,0.1),(0.33313,0.23287,0.1),(0.32908,0.23443,0.1),(0.32488,0.23565,0.1),(0.32057,0.23654,0.1),(0.31621,0.23714,0.1),(0.30753,0.23758,0.1),(0.29836,0.23728,0.1),(0.2892,0.23628,0.1),(0.28021,0.23442,0.1),(0.27582,0.23314,0.1),(0.27153,0.23158,0.1),(0.25919,0.22462,0.1),(0.24753,0.21658,0.1),(0.23958,0.20795,0.1),(0.23253,0.19858,0.1),(0.23125,0.19419,0.1),(0.23031,0.1897,0.1),(0.22973,0.18515,0.1),(0.22953,0.18058,0.1),(0.22968,0.17673,0.1),(0.23017,0.17288,0.1),(0.23058,0.17099,0.1),(0.2311,0.16913,0.1),(0.23174,0.16733,0.1),(0.23253,0.16558,0.1),(0.23294,0.16485,0.1),(0.23343,0.16417,0.1),(0.23399,0.16354,0.1),(0.23462,0.16296,0.1),(0.2353,0.16242,0.1),(0.23602,0.16192,0.1),(0.23679,0.16148,0.1),(0.2376,0.16108,0.1),(0.23929,0.16042,0.1),(0.24105,0.15996,0.1),(0.24281,0.15967,0.1),(0.24453,0.15958,0.1),(0.24914,0.15967,0.1),(0.25377,0.16006,0.1),(0.25604,0.16044,0.1),(0.25827,0.16096,0.1),(0.26044,0.16167,0.1),(0.26253,0.16258,0.1),(0.26369,0.16382,0.1),(0.2648,0.16516,0.1),(0.26582,0.16659,0.1),(0.26671,0.16809,0.1),(0.26746,0.16965,0.1),(0.26803,0.17126,0.1),(0.26824,0.17208,0.1),(0.2684,0.17291,0.1),(0.26849,0.17374,0.1),(0.26853,0.17458,0.1),(0.26838,0.17843,0.1),(0.26788,0.18228,0.1),(0.26748,0.18418,0.1),(0.26696,0.18603,0.1),(0.26631,0.18784,0.1),(0.26553,0.18958,0.1),(0.26342,0.19698,0.1),(0.26277,0.20077,0.1),(0.26253,0.20458,0.1),(0.26403,0.20608,0.1),(0.26553,0.20758,0.1),(0.26756,0.20937,0.1),(0.26977,0.21093,0.1),(0.27453,0.21358,0.1),(0.27656,0.21537,0.1),(0.27877,0.21693,0.1),(0.28353,0.21958,0.1),(0.28527,0.22036,0.1),(0.28708,0.22101,0.1),(0.28893,0.22153,0.1),(0.29083,0.22194,0.1),(0.29467,0.22243,0.1),(0.29853,0.22258,0.1),(0.30264,0.22242,0.1),(0.30685,0.22192,0.1),(0.31105,0.22106,0.1),(0.31514,0.21981,0.1),(0.31903,0.21816,0.1),(0.32087,0.21718,0.1),(0.32263,0.21609,0.1),(0.32428,0.21489,0.1),(0.32582,0.21357,0.1),(0.32724,0.21214,0.1),(0.32853,0.21058,0.1),(0.33003,0.20898,0.1),(0.33142,0.20727,0.1),(0.33389,0.20358,0.1),(0.33596,0.19959,0.1),(0.33763,0.19537,0.1),(0.33891,0.19098,0.1),(0.33982,0.18651,0.1),(0.34035,0.18202,0.1),(0.34053,0.17758,0.1),(0.34,0.1671,0.1),(0.33927,0.1618,0.1),(0.33813,0.15659,0.1),(0.33655,0.15156,0.1),(0.33446,0.14682,0.1),(0.33321,0.14459,0.1),(0.3318,0.14246,0.1),(0.33025,0.14045,0.1),(0.32853,0.13858,0.1),(0.32692,0.13708,0.1),(0.32521,0.13569,0.1),(0.32153,0.13321,0.1),(0.31753,0.13115,0.1),(0.31331,0.12948,0.1),(0.30893,0.1282,0.1),(0.30446,0.12729,0.1),(0.29997,0.12676,0.1),(0.29553,0.12658,0.1),(0.28053,0.12658,0.1),(0.28053,0.10558,0.1),(0.30153,0.10558,0.1),(0.30779,0.10529,0.1),(0.31094,0.10489,0.1),(0.31405,0.1043,0.1),(0.31709,0.10349,0.1),(0.32004,0.10245,0.1),(0.32286,0.10115,0.1),(0.32553,0.09958,0.1),(0.32731,0.09892,0.1),(0.32909,0.09814,0.1),(0.33082,0.09722,0.1),(0.33247,0.09617,0.1),(0.334,0.09498,0.1),(0.33538,0.09365,0.1),(0.336,0.09294,0.1),(0.33656,0.09219,0.1),(0.33708,0.0914,0.1),(0.33753,0.09058,0.1),(0.34263,0.08187,0.1),(0.34475,0.07729,0.1),(0.34653,0.07258,0.1),(0.34781,0.06819,0.1),(0.34875,0.0637,0.1),(0.34933,0.05915,0.1),(0.34953,0.05458,0.1),(0.34923,0.04832,0.1),(0.34883,0.04517,0.1),(0.34824,0.04206,0.1),(0.34744,0.03902,0.1),(0.34639,0.03607,0.1),(0.3451,0.03324,0.1),(0.34353,0.03058,0.1),(0.34268,0.02767,0.1),(0.34163,0.0248,0.1),(0.34037,0.022,0.1),(0.33893,0.01929,0.1),(0.33731,0.01667,0.1),(0.33553,0.01417,0.1),(0.3336,0.0118,0.1),(0.33153,0.00958,0.1),(0.32966,0.0079,0.1),(0.32763,0.0064,0.1),(0.32546,0.00508,0.1),(0.32319,0.00391,0.1),(0.31842,0.00201,0.1),(0.31353,5.8E-4,0.1),(0.30938,-0.00184,0.1),(0.30719,-0.00286,0.1),(0.30493,-0.00373,0.1),(0.30261,-0.00445,0.1),(0.30027,-0.00497,0.1),(0.2979,-0.00531,0.1),(0.29553,-0.00542,0.1),(0.29091,-0.00533,0.1),(0.28629,-0.00494,0.1),(0.28401,-0.00456,0.1),(0.28178,-0.00404,0.1),(0.27961,-0.00333,0.1),(0.27753,-0.00242,0.1),(0.27468,-0.00117,0.1),(0.27169,-2.3E-4,0.1),(0.26862,3.7E-4,0.1),(0.26708,5.3E-4,0.1),(0.26553,5.8E-4,0.1),(0.26077,0.00323,0.1),(0.25856,0.00479,0.1),(0.25653,0.00658,0.1),(0.25503,0.00808,0.1),(0.25353,0.00958,0.1),(0.25358,0.01113,0.1),(0.25374,0.01268,0.1),(0.25434,0.01574,0.1),(0.25528,0.01873,0.1),(0.25653,0.02158,0.1),(0.25863,0.02898,0.1),(0.25929,0.03277,0.1),(0.25953,0.03658,0.1),(0.2594,0.03794,0.1),(0.25904,0.03928,0.1),(0.25879,0.03994,0.1),(0.25848,0.04059,0.1),(0.25813,0.04122,0.1),(0.25774,0.04183,0.1),(0.25684,0.04298,0.1),(0.25583,0.044,0.1),(0.25528,0.04446,0.1),(0.25471,0.04488,0.1),(0.25353,0.04558,0.1),(0.25266,0.04639,0.1),(0.25173,0.04712,0.1),(0.25075,0.0478,0.1),(0.24972,0.04841,0.1),(0.24753,0.04944,0.1),(0.24522,0.05026,0.1),(0.24282,0.05086,0.1),(0.24038,0.05127,0.1),(0.23793,0.05151,0.1),(0.23553,0.05158,0.1),(0.23459,0.05153,0.1),(0.23364,0.05139,0.1),(0.2327,0.05116,0.1),(0.23177,0.05084,0.1),(0.23085,0.05045,0.1),(0.22995,0.04998,0.1),(0.22908,0.04945,0.1),(0.22825,0.04886,0.1),(0.22745,0.04821,0.1),(0.2267,0.04751,0.1),(0.226,0.04677,0.1),(0.22537,0.04599,0.1),(0.22479,0.04517,0.1),(0.22429,0.04433,0.1),(0.22387,0.04346,0.1),(0.22353,0.04258,0.1),(0.22301,0.04201,0.1),(0.22256,0.0414,0.1),(0.22217,0.04074,0.1),(0.22183,0.04006,0.1),(0.22154,0.03934,0.1),(0.2213,0.03859,0.1),(0.22093,0.03703,0.1),(0.22071,0.03542,0.1),(0.22059,0.03379,0.1),(0.22053,0.03058,0.1),(0.22073,0.02601,0.1),(0.22131,0.02146,0.1),(0.22225,0.01697,0.1),(0.22353,0.01258,0.1),(0.2267,0.00831,0.1),(0.23029,0.00435,0.1),(0.23425,7.5E-4,0.1),(0.23853,-0.00242,0.1),(0.24408,-0.00625,0.1),(0.24996,-0.00962,0.1),(0.25612,-0.01238,0.1),(0.2593,-0.0135,0.1)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(DEF='characterDAppearance',
          material=Material(ambientIntensity=1,diffuseColor=(0.863,0.141,0.122),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.60364,0.03114,0.1),(0.60947,0.03937,0.1),(0.6144,0.04823,0.1),(0.61845,0.05755,0.1),(0.62164,0.06714,0.1),(0.62164,0.06714,0),(0.61845,0.05755,0),(0.6144,0.04823,0),(0.60947,0.03937,0),(0.60364,0.03114,0.0)]),
          normal=Normal(vector=[(-0.78087,0.6247,-0.0),(-0.8472,0.53128,-0.0),(-0.8972,0.44162,-0.0),(-0.93437,0.35631,-0.0),(-0.96152,0.27472,-0.0),(-0.96152,0.27472,-0.0),(-0.93437,0.35631,-0.0),(-0.8972,0.44162,-0.0),(-0.8472,0.53128,-0.0),(-0.78087,0.6247,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.57664,0.01014,0.1),(0.5842,0.01429,0.1),(0.5914,0.01914,0.1),(0.59478,0.02183,0.1),(0.59797,0.02473,0.1),(0.60094,0.02783,0.1),(0.60364,0.03114,0.1),(0.60364,0.03114,0),(0.60094,0.02783,0),(0.59797,0.02473,0),(0.59478,0.02183,0),(0.5914,0.01914,0),(0.5842,0.01429,0),(0.57664,0.01014,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,-0.0),(-0.5171,0.85592,-0.0),(-0.60081,0.79939,-0.0),(-0.64759,0.76199,-0.0),(-0.69705,0.71702,-0.0),(-0.74831,0.66335,-0.0),(-0.8,0.6,-0.0),(-0.8,0.6,-0.0),(-0.74831,0.66335,-0.0),(-0.69705,0.71702,-0.0),(-0.64759,0.76199,-0.0),(-0.60081,0.79939,-0.0),(-0.5171,0.85592,-0.0),(-0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.53764,0.00414,0.1),(0.54757,0.00439,0.1),(0.5575,0.00531,0.1),(0.56725,0.00715,0.1),(0.572,0.00848,0.1),(0.57664,0.01014,0.1),(0.57664,0.01014,0),(0.572,0.00848,0),(0.56725,0.00715,0),(0.5575,0.00531,0),(0.54757,0.00439,0),(0.53764,0.00414,0.0)]),
          normal=Normal(vector=[(-0.0,1.0,-0.0),(-0.05442,0.99852,-0.0),(-0.13396,0.99099,-0.0),(-0.24002,0.97077,-0.0),(-0.30283,0.95305,-0.0),(-0.37139,0.92848,-0.0),(-0.37139,0.92848,-0.0),(-0.30283,0.95305,-0.0),(-0.24002,0.97077,-0.0),(-0.13396,0.99099,-0.0),(-0.05442,0.99852,-0.0),(-0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.51064,0.01014,0.1),(0.51211,0.00923,0.1),(0.51363,0.00842,0.1),(0.5168,0.00705,0.1),(0.52013,0.0060,0.1),(0.52356,0.00523,0.1),(0.53061,0.00436,0.1),(0.53764,0.00414,0.1),(0.53764,0.00414,0),(0.53061,0.00436,0),(0.52356,0.00523,0),(0.52013,0.0060,0),(0.5168,0.00705,0),(0.51363,0.00842,0),(0.51211,0.00923,0),(0.51064,0.01014,0.0)]),
          normal=Normal(vector=[(0.5547,0.83205,-0.0),(0.5001,0.86597,-0.0),(0.44677,0.89465,-0.0),(0.34667,0.93799,-0.0),(0.25811,0.96612,-0.0),(0.18244,0.98322,-0.0),(0.06877,0.99763,-0.0),(-0.0,1.0,-0.0),(-0.0,1.0,-0.0),(0.06877,0.99763,-0.0),(0.18244,0.98322,-0.0),(0.25811,0.96612,-0.0),(0.34667,0.93799,-0.0),(0.44677,0.89465,-0.0),(0.5001,0.86597,-0.0),(0.5547,0.83205,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,17,-1,18,19,5,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,5,6,17,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,13,-1,14,15,9,-1,17,7,16,-1,16,8,15,-1,9,10,13,-1,13,10,11,-1,12,13,11,-1],solid=False,
          coord=Coordinate(point=[(0.50164,0.03114,0.1),(0.50177,0.02823,0.1),(0.50216,0.02524,0.1),(0.50282,0.02227,0.1),(0.50377,0.01937,0.1),(0.50501,0.01664,0.1),(0.50575,0.01535,0.1),(0.50656,0.01414,0.1),(0.50746,0.013,0.1),(0.50844,0.01195,0.1),(0.5095,0.01099,0.1),(0.51064,0.01014,0.1),(0.51064,0.01014,0),(0.5095,0.01099,0),(0.50844,0.01195,0),(0.50746,0.013,0),(0.50656,0.01414,0),(0.50575,0.01535,0),(0.50501,0.01664,0),(0.50377,0.01937,0),(0.50282,0.02227,0),(0.50216,0.02524,0),(0.50177,0.02823,0),(0.50164,0.03114,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(0.9963,0.08595,-0.0),(0.98508,0.17212,-0.0),(0.96491,0.26257,-0.0),(0.93269,0.36069,-0.0),(0.88327,0.46887,-0.0),(0.84989,0.52696,-0.0),(0.80931,0.58738,-0.0),(0.76037,0.64949,-0.0),(0.70204,0.71214,-0.0),(0.63355,0.7737,-0.0),(0.5547,0.83205,-0.0),(0.5547,0.83205,-0.0),(0.63355,0.7737,-0.0),(0.70204,0.71214,-0.0),(0.76037,0.64949,-0.0),(0.80931,0.58738,-0.0),(0.84989,0.52696,-0.0),(0.88327,0.46887,-0.0),(0.93269,0.36069,-0.0),(0.96491,0.26257,-0.0),(0.98508,0.17212,-0.0),(0.9963,0.08595,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.50164,0.22014,0.1),(0.50164,0.03114,0.1),(0.50164,0.03114,0),(0.50164,0.22014,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.51364,0.22014,0.1),(0.50164,0.22014,0.1),(0.50164,0.22014,0),(0.51364,0.22014,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.52864,0.22314,0.1),(0.52483,0.2229,0.1),(0.52105,0.22225,0.1),(0.51364,0.22014,0.1),(0.51364,0.22014,0),(0.52105,0.22225,0),(0.52483,0.2229,0),(0.52864,0.22314,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(0.12161,-0.99258,-0.0),(0.21363,-0.97691,-0.0),(0.31623,-0.94868,-0.0),(0.31623,-0.94868,-0.0),(0.21363,-0.97691,-0.0),(0.12161,-0.99258,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[11,0,10,-1,10,0,1,-1,9,1,2,-1,3,9,2,-1,3,8,9,-1,3,4,8,-1,8,4,7,-1,7,4,5,-1,6,7,5,-1,10,1,9,-1],solid=False,
          coord=Coordinate(point=[(0.57064,0.21414,0.1),(0.56575,0.21637,0.1),(0.56069,0.21825,0.1),(0.55021,0.22104,0.1),(0.53945,0.22264,0.1),(0.52864,0.22314,0.1),(0.52864,0.22314,0),(0.53945,0.22264,0),(0.55021,0.22104,0),(0.56069,0.21825,0),(0.56575,0.21637,0),(0.57064,0.21414,0.0)]),
          normal=Normal(vector=[(-0.44721,-0.89443,0),(-0.38082,-0.92465,0),(-0.31727,-0.94834,0),(-0.19979,-0.97984,0),(-0.09477,-0.9955,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.09477,-0.9955,0),(-0.19979,-0.97984,0),(-0.31727,-0.94834,0),(-0.38082,-0.92465,0),(-0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.60064,0.19014,0.1),(0.59419,0.19731,0.1),(0.58694,0.20375,0.1),(0.57904,0.20938,0.1),(0.57064,0.21414,0.1),(0.57064,0.21414,0),(0.57904,0.20938,0),(0.58694,0.20375,0),(0.59419,0.19731,0),(0.60064,0.19014,0.0)]),
          normal=Normal(vector=[(-0.78087,-0.62469,0),(-0.7038,-0.7104,0),(-0.62277,-0.78241,0),(-0.53764,-0.84317,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.53764,-0.84317,0),(-0.62277,-0.78241,0),(-0.7038,-0.7104,0),(-0.78087,-0.62469,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,6,-1,7,8,2,-1,2,3,6,-1,6,3,4,-1,5,6,4,-1],solid=False,
          coord=Coordinate(point=[(0.61864,0.15714,0.1),(0.61526,0.16594,0.1),(0.61109,0.17443,0.1),(0.6062,0.18253,0.1),(0.60064,0.19014,0.1),(0.60064,0.19014,0),(0.6062,0.18253,0),(0.61109,0.17443,0),(0.61526,0.16594,0),(0.61864,0.15714,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.91629,-0.40051,0),(-0.87764,-0.47932,0),(-0.83268,-0.55376,0),(-0.78087,-0.6247,0),(-0.78087,-0.6247,0),(-0.83268,-0.55376,0),(-0.87764,-0.47932,0),(-0.91629,-0.40051,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.62764,0.11214,0.1),(0.62708,0.12365,0.1),(0.6254,0.13511,0.1),(0.62259,0.14633,0.1),(0.61864,0.15714,0.1),(0.61864,0.15714,0),(0.62259,0.14633,0),(0.6254,0.13511,0),(0.62708,0.12365,0),(0.62764,0.11214,0.0)]),
          normal=Normal(vector=[(-1.0,-0.0,-0.0),(-0.99531,-0.09674,0),(-0.98106,-0.19371,0),(-0.95628,-0.29244,0),(-0.91914,-0.39392,0),(-0.91914,-0.39392,0),(-0.95628,-0.29244,0),(-0.98106,-0.19371,0),(-0.99531,-0.09674,0),(-1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1,6,1,5,-1],solid=False,
          coord=Coordinate(point=[(0.62164,0.06714,0.1),(0.6246,0.0781,0.1),(0.62644,0.08935,0.1),(0.62764,0.11214,0.1),(0.62764,0.11214,0),(0.62644,0.08935,0),(0.6246,0.0781,0),(0.62164,0.06714,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,-0.0),(-0.97824,0.20749,-0.0),(-0.99297,0.11839,-0.0),(-1.0,-0.0,0),(-1.0,-0.0,0),(-0.99297,0.11839,-0.0),(-0.97824,0.20749,-0.0),(-0.94868,0.31623,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.66964,0.11214,0.1),(0.66899,0.09749,0.1),(0.6669,0.08287,0.1),(0.66526,0.07569,0.1),(0.66318,0.06865,0.1),(0.66065,0.06178,0.1),(0.65764,0.05514,0.1),(0.65764,0.05514,0),(0.66065,0.06178,0),(0.66318,0.06865,0),(0.66526,0.07569,0),(0.6669,0.08287,0),(0.66899,0.09749,0),(0.66964,0.11214,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99587,-0.09082,0),(0.98089,-0.19457,0),(0.96771,-0.25206,0),(0.9496,-0.31348,0),(0.92553,-0.37868,0),(0.89443,-0.44721,0),(0.89443,-0.44721,0),(0.92553,-0.37868,0),(0.9496,-0.31348,0),(0.96771,-0.25206,0),(0.98089,-0.19457,0),(0.99587,-0.09082,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,7,-1,8,9,3,-1,10,2,9,-1,3,4,7,-1,7,4,5,-1,6,7,5,-1],solid=False,
          coord=Coordinate(point=[(0.65764,0.05514,0.1),(0.65122,0.04402,0.1),(0.64348,0.03364,0.1),(0.63457,0.02427,0.1),(0.62973,0.02004,0.1),(0.62464,0.01614,0.1),(0.62464,0.01614,0),(0.62973,0.02004,0),(0.63457,0.02427,0),(0.64348,0.03364,0),(0.65122,0.04402,0),(0.65764,0.05514,0.0)]),
          normal=Normal(vector=[(0.89443,-0.44721,0),(0.83523,-0.5499,0),(0.76488,-0.64417,0),(0.6813,-0.732,0),(0.63357,-0.77369,0),(0.58124,-0.81373,0),(0.58124,-0.81373,0),(0.63357,-0.77369,0),(0.6813,-0.732,0),(0.76488,-0.64417,0),(0.83523,-0.5499,0),(0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.62464,0.01614,0.1),(0.61514,0.00917,0.1),(0.60483,0.00331,0.1),(0.59392,-0.00138,0.1),(0.58264,-0.00486,0.1),(0.58264,-0.00486,0),(0.59392,-0.00138,0),(0.60483,0.00331,0),(0.61514,0.00917,0),(0.62464,0.01614,0.0)]),
          normal=Normal(vector=[(0.64018,-0.76822,0),(0.54271,-0.83992,0),(0.44454,-0.89576,0),(0.34505,-0.93858,0),(0.24254,-0.97014,0),(0.24254,-0.97014,0),(0.34505,-0.93858,0),(0.44454,-0.89576,0),(0.54271,-0.83992,0),(0.64018,-0.76822,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.58264,-0.00486,0.1),(0.55882,-0.00932,0.1),(0.54675,-0.01047,0.1),(0.53464,-0.01086,0.1),(0.53464,-0.01086,0),(0.54675,-0.01047,0),(0.55882,-0.00932,0),(0.58264,-0.00486,0.0)]),
          normal=Normal(vector=[(0.24254,-0.97014,0),(0.12495,-0.99216,0),(0.06358,-0.99798,0),(0,-1.0,0),(0,-1.0,0),(0.06358,-0.99798,0),(0.12495,-0.99216,0),(0.24254,-0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.53464,-0.01086,0.1),(0.43264,-0.01086,0.1),(0.43264,-0.01086,0),(0.53464,-0.01086,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.43264,-0.01086,0.1),(0.43264,0.00114,0.1),(0.43264,0.00114,0),(0.43264,-0.01086,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.43264,0.00114,0.1),(0.43864,0.00114,0.1),(0.44464,0.00114,0.1),(0.44464,0.00114,0),(0.43264,0.00114,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,10,-1,11,12,6,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,6,7,10,-1,10,7,8,-1,9,10,8,-1],solid=False,
          coord=Coordinate(point=[(0.44464,0.00114,0.1),(0.44585,0.00118,0.1),(0.44707,0.0013,0.1),(0.44829,0.0015,0.1),(0.44949,0.0018,0.1),(0.45065,0.00221,0.1),(0.45174,0.00273,0.1),(0.45274,0.00337,0.1),(0.45364,0.00414,0.1),(0.45364,0.00414,0),(0.45274,0.00337,0),(0.45174,0.00273,0),(0.45065,0.00221,0),(0.44949,0.0018,0),(0.44829,0.0015,0),(0.44707,0.0013,0),(0.44585,0.00118,0),(0.44464,0.00114,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.06216,0.99807,0),(-0.12928,0.99161,0),(-0.20336,0.9791,0),(-0.28619,0.95817,0),(-0.37907,0.92537,0),(-0.48214,0.87609,0),(-0.59334,0.80495,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.59334,0.80495,0),(-0.48214,0.87609,0),(-0.37907,0.92537,0),(-0.28619,0.95817,0),(-0.20336,0.9791,0),(-0.12928,0.99161,0),(-0.06216,0.99807,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.45364,0.00414,0.1),(0.455,0.00427,0.1),(0.45634,0.00463,0.1),(0.457,0.00489,0.1),(0.45765,0.00519,0.1),(0.45828,0.00554,0.1),(0.45889,0.00593,0.1),(0.46004,0.00683,0.1),(0.46106,0.00785,0.1),(0.46152,0.00839,0.1),(0.46194,0.00896,0.1),(0.46264,0.01014,0.1),(0.46264,0.01014,0),(0.46194,0.00896,0),(0.46152,0.00839,0),(0.46106,0.00785,0),(0.46004,0.00683,0),(0.45889,0.00593,0),(0.45828,0.00554,0),(0.45765,0.00519,0),(0.457,0.00489,0),(0.45634,0.00463,0),(0.455,0.00427,0),(0.45364,0.00414,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.17903,0.98384,0),(-0.33052,0.9438,0),(-0.39682,0.9179,0),(-0.45769,0.88911,0),(-0.51385,0.85788,0),(-0.56598,0.82442,0),(-0.66063,0.75071,0),(-0.74571,0.66628,0),(-0.78549,0.61888,0),(-0.82362,0.56714,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.82362,0.56714,0),(-0.78549,0.61888,0),(-0.74571,0.66628,0),(-0.66063,0.75071,0),(-0.56598,0.82442,0),(-0.51385,0.85788,0),(-0.45769,0.88911,0),(-0.39682,0.9179,0),(-0.33052,0.9438,0),(-0.17903,0.98384,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.46264,0.01014,0.1),(0.46341,0.01104,0.1),(0.46406,0.01205,0.1),(0.46458,0.01314,0.1),(0.46498,0.0143,0.1),(0.46528,0.0155,0.1),(0.46549,0.01672,0.1),(0.46561,0.01794,0.1),(0.46564,0.01914,0.1),(0.46564,0.01914,0),(0.46561,0.01794,0),(0.46549,0.01672,0),(0.46528,0.0155,0),(0.46498,0.0143,0),(0.46458,0.01314,0),(0.46406,0.01205,0),(0.46341,0.01104,0),(0.46264,0.01014,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.80495,0.59334,0),(-0.87609,0.48214,0),(-0.92537,0.37907,0),(-0.95817,0.28619,0),(-0.9791,0.20336,0),(-0.99161,0.12928,0),(-0.99807,0.06216,0),(-1.0,0,0),(-1.0,0,0),(-0.99807,0.06216,0),(-0.99161,0.12928,0),(-0.9791,0.20336,0),(-0.95817,0.28619,0),(-0.92537,0.37907,0),(-0.87609,0.48214,0),(-0.80495,0.59334,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.46564,0.01914,0.1),(0.46564,0.20214,0.1),(0.46564,0.20214,0),(0.46564,0.01914,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.46564,0.20214,0.1),(0.46561,0.20335,0.1),(0.46549,0.20457,0.1),(0.46528,0.20579,0.1),(0.46498,0.20699,0.1),(0.46458,0.20815,0.1),(0.46406,0.20924,0.1),(0.46341,0.21024,0.1),(0.46264,0.21114,0.1),(0.46264,0.21114,0),(0.46341,0.21024,0),(0.46406,0.20924,0),(0.46458,0.20815,0),(0.46498,0.20699,0),(0.46528,0.20579,0),(0.46549,0.20457,0),(0.46561,0.20335,0),(0.46564,0.20214,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99807,-0.06216,0),(-0.99161,-0.12928,0),(-0.9791,-0.20336,0),(-0.95817,-0.28619,0),(-0.92537,-0.37907,0),(-0.87609,-0.48214,0),(-0.80495,-0.59334,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.80495,-0.59334,0),(-0.87609,-0.48214,0),(-0.92537,-0.37907,0),(-0.95817,-0.28619,0),(-0.9791,-0.20336,0),(-0.99161,-0.12928,0),(-0.99807,-0.06216,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,10,-1,11,12,6,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,6,7,10,-1,10,7,8,-1,9,10,8,-1],solid=False,
          coord=Coordinate(point=[(0.46264,0.21114,0.1),(0.46187,0.21254,0.1),(0.46097,0.21388,0.1),(0.45996,0.21516,0.1),(0.45885,0.21635,0.1),(0.45766,0.21746,0.1),(0.45638,0.21847,0.1),(0.45504,0.21937,0.1),(0.45364,0.22014,0.1),(0.45364,0.22014,0),(0.45504,0.21937,0),(0.45638,0.21847,0),(0.45766,0.21746,0),(0.45885,0.21635,0),(0.45996,0.21516,0),(0.46097,0.21388,0),(0.46187,0.21254,0),(0.46264,0.21114,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.85331,-0.52141,0),(-0.80828,-0.58879,0),(-0.75959,-0.6504,0),(-0.70711,-0.70711,0),(-0.6504,-0.75959,0),(-0.58879,-0.80828,0),(-0.52141,-0.85331,0),(-0.44721,-0.89443,0),(-0.44721,-0.89443,0),(-0.52141,-0.85331,0),(-0.58879,-0.80828,0),(-0.6504,-0.75959,0),(-0.70711,-0.70711,0),(-0.75959,-0.6504,0),(-0.80828,-0.58879,0),(-0.85331,-0.52141,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,8,-1,9,10,2,-1,2,3,8,-1,8,3,4,-1,7,4,6,-1,7,8,4,-1,4,5,6,-1],solid=False,
          coord=Coordinate(point=[(0.45364,0.22014,0.1),(0.45079,0.22139,0.1),(0.44781,0.22233,0.1),(0.44474,0.22293,0.1),(0.44319,0.22309,0.1),(0.44164,0.22314,0.1),(0.44164,0.22314,0),(0.44319,0.22309,0),(0.44474,0.22293,0),(0.44781,0.22233,0),(0.45079,0.22139,0),(0.45364,0.22014,0.0)]),
          normal=Normal(vector=[(-0.44722,-0.89443,0),(-0.35262,-0.93577,0),(-0.24866,-0.96859,0),(-0.13201,-0.99125,0),(-0.06804,-0.99768,0),(0,-1.0,0),(0,-1.0,0),(-0.06804,-0.99768,0),(-0.13201,-0.99125,0),(-0.24866,-0.96859,0),(-0.35262,-0.93577,0),(-0.44722,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.44164,0.22314,0.1),(0.44044,0.22318,0.1),(0.43922,0.2233,0.1),(0.438,0.2235,0.1),(0.4368,0.2238,0.1),(0.43564,0.22421,0.1),(0.43455,0.22473,0.1),(0.43354,0.22537,0.1),(0.43264,0.22614,0.1),(0.43264,0.22614,0),(0.43354,0.22537,0),(0.43455,0.22473,0),(0.43564,0.22421,0),(0.4368,0.2238,0),(0.438,0.2235,0),(0.43922,0.2233,0),(0.44044,0.22318,0),(0.44164,0.22314,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.06216,-0.99807,0),(-0.12928,-0.99161,0),(-0.20336,-0.9791,0),(-0.28619,-0.95817,0),(-0.37907,-0.92537,0),(-0.48214,-0.87609,0),(-0.59334,-0.80495,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.59334,-0.80495,0),(-0.48214,-0.87609,0),(-0.37907,-0.92537,0),(-0.28619,-0.95817,0),(-0.20336,-0.9791,0),(-0.12928,-0.99161,0),(-0.06216,-0.99807,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.43264,0.22614,0.1),(0.43264,0.23814,0.1),(0.43264,0.23814,0),(0.43264,0.22614,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.43264,0.23814,0.1),(0.54064,0.23814,0.1),(0.54064,0.23814,0),(0.43264,0.23814,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.54064,0.23814,0.1),(0.5514,0.23753,0.1),(0.56208,0.23576,0.1),(0.57254,0.23293,0.1),(0.58264,0.22914,0.1),(0.58264,0.22914,0),(0.57254,0.23293,0),(0.56208,0.23576,0),(0.5514,0.23753,0),(0.54064,0.23814,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.11188,0.99372,-0.0),(0.21363,0.97692,-0.0),(0.30695,0.95172,-0.0),(0.39392,0.91915,-0.0),(0.39392,0.91915,-0.0),(0.30695,0.95172,-0.0),(0.21363,0.97692,-0.0),(0.11188,0.99372,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.58264,0.22914,0.1),(0.59302,0.22612,0.1),(0.60316,0.2222,0.1),(0.61279,0.21724,0.1),(0.61733,0.21434,0.1),(0.62164,0.21114,0.1),(0.62164,0.21114,0),(0.61733,0.21434,0),(0.61279,0.21724,0),(0.60316,0.2222,0),(0.59302,0.22612,0),(0.58264,0.22914,0.0)]),
          normal=Normal(vector=[(0.24254,0.97014,-0.0),(0.31794,0.94811,-0.0),(0.40699,0.91343,-0.0),(0.51007,0.86013,-0.0),(0.56627,0.82422,-0.0),(0.6247,0.78087,-0.0),(0.6247,0.78087,-0.0),(0.56627,0.82422,-0.0),(0.51007,0.86013,-0.0),(0.40699,0.91343,-0.0),(0.31794,0.94811,-0.0),(0.24254,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.62164,0.21114,0.1),(0.62692,0.20703,0.1),(0.63189,0.2025,0.1),(0.63654,0.1976,0.1),(0.64086,0.19236,0.1),(0.64484,0.18685,0.1),(0.64847,0.18111,0.1),(0.65464,0.16914,0.1),(0.65464,0.16914,0),(0.64847,0.18111,0),(0.64484,0.18685,0),(0.64086,0.19236,0),(0.63654,0.1976,0),(0.63189,0.2025,0),(0.62692,0.20703,0),(0.62164,0.21114,0.0)]),
          normal=Normal(vector=[(0.58124,0.81373,-0.0),(0.64505,0.76414,-0.0),(0.7008,0.71336,-0.0),(0.74938,0.66214,-0.0),(0.79168,0.61093,-0.0),(0.82857,0.55989,-0.0),(0.86081,0.50893,-0.0),(0.91381,0.40614,-0.0),(0.91381,0.40614,-0.0),(0.86081,0.50893,-0.0),(0.82857,0.55989,-0.0),(0.79168,0.61093,-0.0),(0.74938,0.66214,-0.0),(0.7008,0.71336,-0.0),(0.64505,0.76414,-0.0),(0.58124,0.81373,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.65464,0.16914,0.1),(0.65828,0.16272,0.1),(0.66138,0.15597,0.1),(0.66397,0.14897,0.1),(0.66605,0.14176,0.1),(0.66764,0.13442,0.1),(0.66876,0.127,0.1),(0.66964,0.11214,0.1),(0.66964,0.11214,0),(0.66876,0.127,0),(0.66764,0.13442,0),(0.66605,0.14176,0),(0.66397,0.14897,0),(0.66138,0.15597,0),(0.65828,0.16272,0),(0.65464,0.16914,0.0)]),
          normal=Normal(vector=[(0.848,0.53,-0.0),(0.89073,0.45454,-0.0),(0.92436,0.38151,-0.0),(0.95026,0.31146,-0.0),(0.96966,0.24446,-0.0),(0.98361,0.18032,-0.0),(0.99294,0.11859,-0.0),(1.0,0,0),(1.0,0,0),(0.99294,0.11859,-0.0),(0.98361,0.18032,-0.0),(0.96966,0.24446,-0.0),(0.95026,0.31146,-0.0),(0.92436,0.38151,-0.0),(0.89073,0.45454,-0.0),(0.848,0.53,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characterDAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,161,0,-1,1,2,161,-1,161,2,3,-1,160,3,4,-1,5,160,4,-1,5,159,160,-1,5,6,159,-1,159,6,7,-1,158,7,8,-1,157,8,9,-1,10,157,9,-1,10,11,157,-1,157,11,156,-1,156,11,12,-1,13,156,12,-1,13,155,156,-1,13,14,155,-1,155,14,154,-1,154,14,15,-1,16,154,15,-1,16,153,154,-1,16,17,153,-1,153,17,18,-1,152,18,19,-1,151,19,20,-1,21,151,20,-1,21,22,151,-1,151,22,150,-1,150,22,23,-1,149,23,24,-1,148,24,25,-1,147,25,26,-1,146,26,145,-1,146,147,26,-1,161,3,160,-1,159,7,158,-1,158,8,157,-1,153,18,152,-1,152,19,151,-1,150,23,149,-1,149,24,148,-1,148,25,147,-1,26,27,145,-1,145,27,144,-1,144,27,28,-1,143,28,29,-1,142,29,141,-1,142,143,29,-1,144,28,143,-1,30,138,29,-1,30,44,138,-1,30,43,44,-1,30,42,43,-1,30,41,42,-1,30,40,41,-1,30,39,40,-1,30,38,39,-1,30,37,38,-1,30,36,37,-1,30,35,36,-1,30,34,35,-1,30,33,34,-1,30,32,33,-1,30,31,32,-1,44,45,138,-1,138,45,46,-1,47,138,46,-1,47,48,138,-1,138,48,49,-1,50,138,49,-1,50,51,138,-1,138,51,53,-1,54,138,53,-1,54,55,138,-1,138,55,56,-1,57,138,56,-1,57,58,138,-1,138,58,59,-1,60,138,59,-1,60,137,138,-1,60,61,137,-1,137,61,136,-1,136,61,135,-1,135,61,134,-1,134,61,62,-1,63,134,62,-1,63,133,134,-1,63,64,133,-1,133,64,65,-1,132,65,66,-1,131,66,67,-1,130,67,68,-1,129,68,70,-1,128,70,71,-1,72,128,71,-1,72,127,128,-1,72,73,127,-1,127,73,126,-1,126,73,125,-1,125,73,74,-1,124,74,92,-1,123,92,122,-1,123,124,92,-1,51,52,53,-1,133,65,132,-1,132,66,131,-1,131,67,130,-1,68,69,70,-1,129,70,128,-1,74,75,92,-1,92,75,76,-1,77,92,76,-1,77,91,92,-1,77,78,91,-1,91,78,83,-1,84,91,83,-1,84,85,91,-1,91,85,86,-1,87,91,86,-1,87,88,91,-1,91,88,89,-1,90,91,89,-1,83,78,82,-1,82,78,79,-1,81,79,80,-1,81,82,79,-1,93,119,92,-1,93,118,119,-1,93,94,118,-1,118,94,117,-1,117,94,116,-1,116,94,95,-1,115,95,114,-1,115,116,95,-1,114,95,113,-1,113,95,96,-1,112,96,97,-1,111,97,110,-1,111,112,97,-1,113,96,112,-1,97,98,110,-1,110,98,109,-1,109,98,108,-1,108,98,99,-1,107,99,100,-1,101,107,100,-1,101,106,107,-1,101,102,106,-1,106,102,105,-1,105,102,103,-1,104,103,0,-1,161,104,0,-1,108,99,107,-1,105,103,104,-1,119,120,92,-1,92,120,121,-1,122,92,121,-1,124,125,74,-1,129,130,68,-1,138,139,29,-1,29,139,140,-1,141,29,140,-1],solid=False,
          coord=Coordinate(point=[(0.65764,0.05514,0.1),(0.66065,0.06178,0.1),(0.66318,0.06865,0.1),(0.66526,0.07569,0.1),(0.6669,0.08287,0.1),(0.66899,0.09749,0.1),(0.66964,0.11214,0.1),(0.66876,0.127,0.1),(0.66764,0.13442,0.1),(0.66605,0.14176,0.1),(0.66397,0.14897,0.1),(0.66138,0.15597,0.1),(0.65828,0.16272,0.1),(0.65464,0.16914,0.1),(0.64847,0.18111,0.1),(0.64484,0.18685,0.1),(0.64086,0.19236,0.1),(0.63654,0.1976,0.1),(0.63189,0.2025,0.1),(0.62692,0.20703,0.1),(0.62164,0.21114,0.1),(0.61733,0.21434,0.1),(0.61279,0.21724,0.1),(0.60316,0.2222,0.1),(0.59302,0.22612,0.1),(0.58264,0.22914,0.1),(0.57254,0.23293,0.1),(0.56208,0.23576,0.1),(0.5514,0.23753,0.1),(0.54064,0.23814,0.1),(0.43264,0.23814,0.1),(0.43264,0.22614,0.1),(0.43354,0.22537,0.1),(0.43455,0.22473,0.1),(0.43564,0.22421,0.1),(0.4368,0.2238,0.1),(0.438,0.2235,0.1),(0.43922,0.2233,0.1),(0.44044,0.22318,0.1),(0.44164,0.22314,0.1),(0.44319,0.22309,0.1),(0.44474,0.22293,0.1),(0.44781,0.22233,0.1),(0.45079,0.22139,0.1),(0.45364,0.22014,0.1),(0.45504,0.21937,0.1),(0.45638,0.21847,0.1),(0.45766,0.21746,0.1),(0.45885,0.21635,0.1),(0.45996,0.21516,0.1),(0.46097,0.21388,0.1),(0.46187,0.21254,0.1),(0.46264,0.21114,0.1),(0.46341,0.21024,0.1),(0.46406,0.20924,0.1),(0.46458,0.20815,0.1),(0.46498,0.20699,0.1),(0.46528,0.20579,0.1),(0.46549,0.20457,0.1),(0.46561,0.20335,0.1),(0.46564,0.20214,0.1),(0.46564,0.01914,0.1),(0.46561,0.01794,0.1),(0.46549,0.01672,0.1),(0.46528,0.0155,0.1),(0.46498,0.0143,0.1),(0.46458,0.01314,0.1),(0.46406,0.01205,0.1),(0.46341,0.01104,0.1),(0.46264,0.01014,0.1),(0.46194,0.00896,0.1),(0.46152,0.00839,0.1),(0.46106,0.00785,0.1),(0.46004,0.00683,0.1),(0.45889,0.00593,0.1),(0.45828,0.00554,0.1),(0.45765,0.00519,0.1),(0.457,0.00489,0.1),(0.45634,0.00463,0.1),(0.455,0.00427,0.1),(0.45364,0.00414,0.1),(0.45274,0.00337,0.1),(0.45174,0.00273,0.1),(0.45065,0.00221,0.1),(0.44949,0.0018,0.1),(0.44829,0.0015,0.1),(0.44707,0.0013,0.1),(0.44585,0.00118,0.1),(0.44464,0.00114,0.1),(0.43864,0.00114,0.1),(0.43264,0.00114,0.1),(0.43264,-0.01086,0.1),(0.53464,-0.01086,0.1),(0.54675,-0.01047,0.1),(0.55882,-0.00932,0.1),(0.58264,-0.00486,0.1),(0.59392,-0.00138,0.1),(0.60483,0.00331,0.1),(0.61514,0.00917,0.1),(0.62464,0.01614,0.1),(0.62973,0.02004,0.1),(0.63457,0.02427,0.1),(0.64348,0.03364,0.1),(0.65122,0.04402,0.1),(0.62164,0.06714,0.1),(0.61845,0.05755,0.1),(0.6144,0.04823,0.1),(0.60947,0.03937,0.1),(0.60364,0.03114,0.1),(0.60094,0.02783,0.1),(0.59797,0.02473,0.1),(0.59478,0.02183,0.1),(0.5914,0.01914,0.1),(0.5842,0.01429,0.1),(0.57664,0.01014,0.1),(0.572,0.00848,0.1),(0.56725,0.00715,0.1),(0.5575,0.00531,0.1),(0.54757,0.00439,0.1),(0.53764,0.00414,0.1),(0.53061,0.00436,0.1),(0.52356,0.00523,0.1),(0.52013,0.0060,0.1),(0.5168,0.00705,0.1),(0.51363,0.00842,0.1),(0.51211,0.00923,0.1),(0.51064,0.01014,0.1),(0.5095,0.01099,0.1),(0.50844,0.01195,0.1),(0.50746,0.013,0.1),(0.50656,0.01414,0.1),(0.50575,0.01535,0.1),(0.50501,0.01664,0.1),(0.50377,0.01937,0.1),(0.50282,0.02227,0.1),(0.50216,0.02524,0.1),(0.50177,0.02823,0.1),(0.50164,0.03114,0.1),(0.50164,0.22014,0.1),(0.51364,0.22014,0.1),(0.52105,0.22225,0.1),(0.52483,0.2229,0.1),(0.52864,0.22314,0.1),(0.53945,0.22264,0.1),(0.55021,0.22104,0.1),(0.56069,0.21825,0.1),(0.56575,0.21637,0.1),(0.57064,0.21414,0.1),(0.57904,0.20938,0.1),(0.58694,0.20375,0.1),(0.59419,0.19731,0.1),(0.60064,0.19014,0.1),(0.6062,0.18253,0.1),(0.61109,0.17443,0.1),(0.61526,0.16594,0.1),(0.61864,0.15714,0.1),(0.62259,0.14633,0.1),(0.6254,0.13511,0.1),(0.62708,0.12365,0.1),(0.62764,0.11214,0.1),(0.62644,0.08935,0.1),(0.6246,0.0781,0.1)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[53,0,40,-1,41,53,40,-1,41,52,53,-1,41,42,52,-1,52,42,43,-1,44,52,43,-1,44,45,52,-1,52,45,46,-1,47,52,46,-1,47,48,52,-1,52,48,49,-1,50,52,49,-1,50,51,52,-1,0,1,40,-1,40,1,2,-1,11,2,3,-1,4,11,3,-1,4,5,11,-1,11,5,6,-1,10,6,7,-1,9,7,8,-1,9,10,7,-1,40,2,11,-1,12,40,11,-1,12,39,40,-1,12,13,39,-1,39,13,14,-1,15,39,14,-1,15,16,39,-1,39,16,17,-1,18,39,17,-1,18,19,39,-1,39,19,20,-1,21,39,20,-1,21,22,39,-1,39,22,23,-1,24,39,23,-1,24,25,39,-1,39,25,26,-1,27,39,26,-1,27,28,39,-1,39,28,29,-1,30,39,29,-1,30,31,39,-1,39,31,32,-1,33,39,32,-1,33,34,39,-1,39,34,35,-1,36,39,35,-1,36,38,39,-1,36,37,38,-1,11,6,10,-1],solid=False,
          coord=Coordinate(point=[(-0.00308,0.00378,0),(0.00803,0.00437,0),(0.01361,0.00518,0),(0.01912,0.00637,0),(0.02447,0.00798,0),(0.02961,0.01007,0),(0.03445,0.01265,0),(0.03673,0.01414,0),(0.03892,0.01578,0),(0.04093,0.01795,0),(0.04277,0.02027,0),(0.04446,0.02273,0),(0.04598,0.0253,0),(0.04858,0.03076,0),(0.05061,0.03654,0),(0.05212,0.04254,0),(0.05315,0.04865,0),(0.05373,0.05476,0),(0.05392,0.06078,0),(0.05383,0.0633,0),(0.05357,0.06582,0),(0.05314,0.06835,0),(0.05256,0.07085,0),(0.05094,0.0758,0),(0.04878,0.08059,0),(0.04614,0.08515,0),(0.04308,0.08942,0),(0.03965,0.09331,0),(0.03592,0.09678,0),(0.03388,0.09868,0),(0.03171,0.10044,0),(0.02701,0.10356,0),(0.02193,0.10614,0),(0.01655,0.10822,0),(0.01097,0.1098,0),(0.00528,0.11091,0),(-4.4E-4,0.11156,0),(-0.00608,0.11178,0),(-0.02708,0.11178,0),(-0.03608,0.11178,0),(-0.03608,0.02478,0),(-0.03592,0.02223,0),(-0.03546,0.01966,0),(-0.0347,0.01712,0),(-0.03367,0.01466,0),(-0.03238,0.01234,0),(-0.03164,0.01125,0),(-0.03084,0.01022,0),(-0.02998,0.00925,0),(-0.02907,0.00834,0),(-0.0281,0.00752,0),(-0.02708,0.00678,0),(-0.02124,0.00523,0),(-0.01524,0.00432,0.0)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(DEF='characters2013Appearance',
          material=Material(ambientIntensity=1.0,diffuseColor=(1,0.584,0),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.11961,-0.2568,0.07),(0.11961,-0.26467,0.07),(0.11961,-0.26467,0),(0.11961,-0.2568,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.11961,-0.26467,0.07),(0.04283,-0.26467,0.07),(0.04283,-0.26467,0),(0.11961,-0.26467,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.04283,-0.26467,0.07),(0.04283,-0.2568,0.07),(0.04283,-0.2568,0),(0.04283,-0.26467,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.04283,-0.2568,0.07),(0.04775,-0.2568,0.07),(0.05268,-0.2568,0.07),(0.05268,-0.2568,0),(0.04283,-0.2568,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.05268,-0.2568,0.07),(0.0552,-0.2567,0.07),(0.05773,-0.25638,0.07),(0.05897,-0.25611,0.07),(0.06019,-0.25577,0.07),(0.06137,-0.25535,0.07),(0.06252,-0.25483,0.07),(0.06252,-0.25483,0),(0.06137,-0.25535,0),(0.06019,-0.25577,0),(0.05897,-0.25611,0),(0.05773,-0.25638,0),(0.0552,-0.2567,0),(0.05268,-0.2568,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.07973,0.99682,0),(-0.17989,0.98369,0),(-0.23845,0.97116,0),(-0.3028,0.95306,0),(-0.37265,0.92797,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.37265,0.92797,0),(-0.3028,0.95306,0),(-0.23845,0.97116,0),(-0.17989,0.98369,0),(-0.07973,0.99682,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.06252,-0.25483,0.07),(0.06341,-0.25475,0.07),(0.06429,-0.25451,0.07),(0.06515,-0.25414,0.07),(0.06596,-0.25366,0.07),(0.06672,-0.25307,0.07),(0.06739,-0.2524,0.07),(0.06797,-0.25167,0.07),(0.06843,-0.25089,0.07),(0.06843,-0.25089,0),(0.06797,-0.25167,0),(0.06739,-0.2524,0),(0.06672,-0.25307,0),(0.06596,-0.25366,0),(0.06515,-0.25414,0),(0.06429,-0.25451,0),(0.06341,-0.25475,0),(0.06252,-0.25483,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.17903,0.98384,0),(-0.33052,0.9438,0),(-0.45769,0.88911,0),(-0.56598,0.82442,0),(-0.66063,0.75071,0),(-0.74571,0.66627,0),(-0.82362,0.56714,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.82362,0.56714,0),(-0.74571,0.66627,0),(-0.66063,0.75071,0),(-0.56598,0.82442,0),(-0.45769,0.88911,0),(-0.33052,0.9438,0),(-0.17903,0.98384,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.06843,-0.25089,0.07),(0.06906,-0.25012,0.07),(0.06954,-0.24924,0.07),(0.06989,-0.24827,0.07),(0.07013,-0.24725,0.07),(0.07028,-0.2462,0.07),(0.07036,-0.24512,0.07),(0.07039,-0.24302,0.07),(0.07039,-0.24302,0),(0.07036,-0.24512,0),(0.07028,-0.2462,0),(0.07013,-0.24725,0),(0.06989,-0.24827,0),(0.06954,-0.24924,0),(0.06906,-0.25012,0),(0.06843,-0.25089,0.0)]),
          normal=Normal(vector=[(-0.7071,0.70711,0),(-0.8325,0.55403,0),(-0.91369,0.40641,0),(-0.96007,0.27976,0),(-0.98386,0.17892,0),(-0.99469,0.1029,0),(-0.9988,0.04898,0),(-1.0,0,0),(-1.0,0,0),(-0.9988,0.04898,0),(-0.99469,0.1029,0),(-0.98386,0.17892,0),(-0.96007,0.27976,0),(-0.91369,0.40641,0),(-0.8325,0.55403,0),(-0.7071,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.07039,-0.24302,0.07),(0.07039,-0.16033,0.07),(0.07039,-0.16033,0),(0.07039,-0.24302,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.07039,-0.16033,0.07),(0.04086,-0.16033,0.07),(0.04086,-0.16033,0),(0.07039,-0.16033,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.04086,-0.16033,0.07),(0.04086,-0.15049,0.07),(0.04086,-0.15049,0),(0.04086,-0.16033,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.04086,-0.15049,0.07),(0.04677,-0.15049,0.07),(0.04677,-0.15049,0),(0.04086,-0.15049,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.04677,-0.15049,0.07),(0.05229,-0.15026,0.07),(0.05779,-0.14954,0.07),(0.0632,-0.14831,0.07),(0.06843,-0.14655,0.07),(0.06843,-0.14655,0),(0.0632,-0.14831,0),(0.05779,-0.14954,0),(0.05229,-0.15026,0),(0.04677,-0.15049,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.08453,0.99642,0),(-0.1739,0.98476,0),(-0.26937,0.96304,0),(-0.37139,0.92848,0),(-0.37139,0.92848,0),(-0.26937,0.96304,0),(-0.1739,0.98476,0),(-0.08453,0.99642,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.06843,-0.14655,0.07),(0.0727,-0.14466,0.07),(0.07681,-0.14241,0.07),(0.08068,-0.13977,0.07),(0.08248,-0.13829,0.07),(0.08418,-0.13671,0.07),(0.08418,-0.13671,0),(0.08248,-0.13829,0),(0.08068,-0.13977,0),(0.07681,-0.14241,0),(0.0727,-0.14466,0),(0.06843,-0.14655,0.0)]),
          normal=Normal(vector=[(-0.37139,0.92848,0),(-0.44036,0.89782,0),(-0.51995,0.8542,0),(-0.60979,0.79256,0),(-0.65782,0.75317,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.65782,0.75317,0),(-0.60979,0.79256,0),(-0.51995,0.8542,0),(-0.44036,0.89782,0),(-0.37139,0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.08418,-0.13671,0.07),(0.09402,-0.13671,0.07),(0.09402,-0.13671,0),(0.08418,-0.13671,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.09402,-0.13671,0.07),(0.0931,-0.14107,0.07),(0.09249,-0.1455,0.07),(0.09205,-0.15442,0.07),(0.09205,-0.15442,0),(0.09249,-0.1455,0),(0.0931,-0.14107,0),(0.09402,-0.13671,0.0)]),
          normal=Normal(vector=[(0.97014,-0.24254,0),(0.98555,-0.16937,0),(0.99451,-0.10462,0),(1.0,0,0),(1.0,0,0),(0.99451,-0.10462,0),(0.98555,-0.16937,0),(0.97014,-0.24254,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.09205,-0.15442,0.07),(0.09205,-0.16427,0.07),(0.09205,-0.17411,0.07),(0.09205,-0.17411,0),(0.09205,-0.15442,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(1.0,0,-0.0),(1.0,0,0),(1.0,0,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.09205,-0.17411,0.07),(0.09205,-0.24302,0.07),(0.09205,-0.24302,0),(0.09205,-0.17411,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.09205,-0.24302,0.07),(0.09205,-0.24597,0.07),(0.09205,-0.24893,0.07),(0.09205,-0.24893,0),(0.09205,-0.24302,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(1.0,0,-0.0),(1.0,0,0),(1.0,0,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[17,0,16,-1,16,0,1,-1,15,1,2,-1,3,15,2,-1,3,14,15,-1,3,4,14,-1,14,4,13,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,1,15,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.09205,-0.24893,0.07),(0.09256,-0.24984,0.07),(0.09315,-0.25072,0.07),(0.09381,-0.25156,0.07),(0.09454,-0.25235,0.07),(0.09532,-0.25307,0.07),(0.09616,-0.25373,0.07),(0.09704,-0.25432,0.07),(0.09796,-0.25483,0.07),(0.09796,-0.25483,0),(0.09704,-0.25432,0),(0.09616,-0.25373,0),(0.09532,-0.25307,0),(0.09454,-0.25235,0),(0.09381,-0.25156,0),(0.09315,-0.25072,0),(0.09256,-0.24984,0),(0.09205,-0.24893,0.0)]),
          normal=Normal(vector=[(0.89443,0.44722,-0.0),(0.85331,0.52141,-0.0),(0.80828,0.5888,-0.0),(0.75959,0.6504,-0.0),(0.70711,0.70711,-0.0),(0.6504,0.75959,-0.0),(0.5888,0.80828,-0.0),(0.52141,0.85331,-0.0),(0.44722,0.89443,-0.0),(0.44722,0.89443,-0.0),(0.52141,0.85331,-0.0),(0.5888,0.80828,-0.0),(0.6504,0.75959,-0.0),(0.70711,0.70711,-0.0),(0.75959,0.6504,-0.0),(0.80828,0.5888,-0.0),(0.85331,0.52141,-0.0),(0.89443,0.44722,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.09796,-0.25483,0.07),(0.10046,-0.25499,0.07),(0.10294,-0.25542,0.07),(0.1078,-0.2568,0.07),(0.1078,-0.2568,0),(0.10294,-0.25542,0),(0.10046,-0.25499,0),(0.09796,-0.25483,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.12161,0.99258,-0.0),(0.21363,0.97691,-0.0),(0.31623,0.94868,-0.0),(0.31623,0.94868,-0.0),(0.21363,0.97691,-0.0),(0.12161,0.99258,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,4,-1,4,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.1078,-0.2568,0.07),(0.11371,-0.2568,0.07),(0.11961,-0.2568,0.07),(0.11961,-0.2568,0),(0.1078,-0.2568,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1,4,0,3,-1,4,5,0,-1,0,5,6,-1,53,6,49,-1,50,53,49,-1,50,52,53,-1,50,51,52,-1,49,6,48,-1,48,6,7,-1,47,7,8,-1,46,8,9,-1,10,46,9,-1,10,45,46,-1,10,11,45,-1,45,11,44,-1,44,11,12,-1,42,12,13,-1,41,13,14,-1,40,14,39,-1,40,41,14,-1,48,7,47,-1,47,8,46,-1,44,12,42,-1,43,44,42,-1,42,13,41,-1,15,37,14,-1,15,36,37,-1,15,16,36,-1,36,16,17,-1,35,17,18,-1,19,35,18,-1,19,26,35,-1,19,25,26,-1,19,24,25,-1,19,20,24,-1,24,20,23,-1,23,20,21,-1,22,23,21,-1,36,17,35,-1,26,27,35,-1,35,27,28,-1,29,35,28,-1,29,30,35,-1,35,30,31,-1,34,31,32,-1,33,34,32,-1,35,31,34,-1,37,38,14,-1,14,38,39,-1,54,60,53,-1,54,55,60,-1,60,55,56,-1,57,60,56,-1,57,58,60,-1,60,58,59,-1,60,0,53,-1,53,0,6,-1],solid=False,
          coord=Coordinate(point=[(0.11961,-0.26467,0.07),(0.11961,-0.2568,0.07),(0.11371,-0.2568,0.07),(0.1078,-0.2568,0.07),(0.10294,-0.25542,0.07),(0.10046,-0.25499,0.07),(0.09796,-0.25483,0.07),(0.09704,-0.25432,0.07),(0.09616,-0.25373,0.07),(0.09532,-0.25307,0.07),(0.09454,-0.25235,0.07),(0.09381,-0.25156,0.07),(0.09315,-0.25072,0.07),(0.09256,-0.24984,0.07),(0.09205,-0.24893,0.07),(0.09205,-0.24597,0.07),(0.09205,-0.24302,0.07),(0.09205,-0.17411,0.07),(0.09205,-0.16427,0.07),(0.09205,-0.15442,0.07),(0.09249,-0.1455,0.07),(0.0931,-0.14107,0.07),(0.09402,-0.13671,0.07),(0.08418,-0.13671,0.07),(0.08248,-0.13829,0.07),(0.08068,-0.13977,0.07),(0.07681,-0.14241,0.07),(0.0727,-0.14466,0.07),(0.06843,-0.14655,0.07),(0.0632,-0.14831,0.07),(0.05779,-0.14954,0.07),(0.05229,-0.15026,0.07),(0.04677,-0.15049,0.07),(0.04086,-0.15049,0.07),(0.04086,-0.16033,0.07),(0.07039,-0.16033,0.07),(0.07039,-0.24302,0.07),(0.07036,-0.24512,0.07),(0.07028,-0.2462,0.07),(0.07013,-0.24725,0.07),(0.06989,-0.24827,0.07),(0.06954,-0.24924,0.07),(0.06906,-0.25012,0.07),(0.06843,-0.25089,0.07),(0.06797,-0.25167,0.07),(0.06739,-0.2524,0.07),(0.06672,-0.25307,0.07),(0.06596,-0.25366,0.07),(0.06515,-0.25414,0.07),(0.06429,-0.25451,0.07),(0.06341,-0.25475,0.07),(0.06252,-0.25483,0.07),(0.06137,-0.25535,0.07),(0.06019,-0.25577,0.07),(0.05897,-0.25611,0.07),(0.05773,-0.25638,0.07),(0.0552,-0.2567,0.07),(0.05268,-0.2568,0.07),(0.04775,-0.2568,0.07),(0.04283,-0.2568,0.07),(0.04283,-0.26467,0.07)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.13042,-0.24499,0.07),(-0.13042,-0.26467,0.07),(-0.13042,-0.26467,0),(-0.13042,-0.24499,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.13042,-0.26467,0.07),(-0.2387,-0.26467,0.07),(-0.2387,-0.26467,0),(-0.13042,-0.26467,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.2387,-0.26467,0.07),(-0.2387,-0.25089,0.07),(-0.2387,-0.25089,0),(-0.2387,-0.26467,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.2387,-0.25089,0.07),(-0.23801,-0.24969,0.07),(-0.2372,-0.24855,0.07),(-0.23629,-0.24749,0.07),(-0.2353,-0.24648,0.07),(-0.23312,-0.24465,0.07),(-0.23082,-0.24302,0.07),(-0.23082,-0.24302,0),(-0.23312,-0.24465,0),(-0.2353,-0.24648,0),(-0.23629,-0.24749,0),(-0.2372,-0.24855,0),(-0.23801,-0.24969,0),(-0.2387,-0.25089,0.0)]),
          normal=Normal(vector=[(-0.89443,0.44721,0),(-0.84151,0.54024,0),(-0.78693,0.61704,0),(-0.73429,0.67884,0),(-0.68594,0.72765,0),(-0.60698,0.79472,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.60698,0.79472,0),(-0.68594,0.72765,0),(-0.73429,0.67884,0),(-0.78693,0.61704,0),(-0.84151,0.54024,0),(-0.89443,0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[9,0,8,-1,8,0,1,-1,7,1,2,-1,3,7,2,-1,3,6,7,-1,3,4,6,-1,6,4,5,-1,8,1,7,-1],solid=False,
          coord=Coordinate(point=[(-0.23082,-0.24302,0.07),(-0.2277,-0.24015,0.07),(-0.22433,-0.23755,0.07),(-0.22076,-0.23522,0.07),(-0.21704,-0.23317,0.07),(-0.21704,-0.23317,0),(-0.22076,-0.23522,0),(-0.22433,-0.23755,0),(-0.2277,-0.24015,0),(-0.23082,-0.24302,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.64387,0.76514,0),(-0.57953,0.81495,0),(-0.5141,0.85773,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.5141,0.85773,0),(-0.57953,0.81495,0),(-0.64387,0.76514,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.21704,-0.23317,0.07),(-0.21232,-0.229,0.07),(-0.2072,-0.2253,0.07),(-0.2072,-0.2253,0),(-0.21232,-0.229,0),(-0.21704,-0.23317,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.62005,0.78456,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.62005,0.78456,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.2072,-0.2253,0.07),(-0.19932,-0.22136,0.07),(-0.19145,-0.21742,0.07),(-0.19145,-0.21742,0),(-0.19932,-0.22136,0),(-0.2072,-0.2253,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.19145,-0.21742,0.07),(-0.18443,-0.2137,0.07),(-0.17767,-0.20955,0.07),(-0.17767,-0.20955,0),(-0.18443,-0.2137,0),(-0.19145,-0.21742,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,0),(-0.49324,0.86989,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.49324,0.86989,0),(-0.44721,0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.17767,-0.20955,0.07),(-0.17275,-0.20463,0.07),(-0.16782,-0.19971,0.07),(-0.16782,-0.19971,0),(-0.17275,-0.20463,0),(-0.17767,-0.20955,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.16782,-0.19971,0.07),(-0.16586,-0.19577,0.07),(-0.16389,-0.19183,0.07),(-0.16389,-0.19183,0),(-0.16586,-0.19577,0),(-0.16782,-0.19971,0.0)]),
          normal=Normal(vector=[(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0),(-0.89443,0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.16389,-0.19183,0.07),(-0.16287,-0.188,0.07),(-0.16227,-0.18406,0.07),(-0.16192,-0.17608,0.07),(-0.16192,-0.17608,0),(-0.16227,-0.18406,0),(-0.16287,-0.188,0),(-0.16389,-0.19183,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.9801,0.19851,0),(-0.99434,0.10626,0),(-1.0,0,0),(-1.0,0,0),(-0.99434,0.10626,0),(-0.9801,0.19851,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,20,-1,21,22,2,-1,2,3,20,-1,20,3,19,-1,19,3,4,-1,18,4,5,-1,17,5,6,-1,16,6,7,-1,8,16,7,-1,8,15,16,-1,8,14,15,-1,8,9,14,-1,14,9,13,-1,13,9,10,-1,11,13,10,-1,11,12,13,-1,19,4,18,-1,18,5,17,-1,17,6,16,-1],solid=False,
          coord=Coordinate(point=[(-0.16192,-0.17608,0.07),(-0.162,-0.17313,0.07),(-0.16228,-0.17011,0.07),(-0.16279,-0.16707,0.07),(-0.16355,-0.1641,0.07),(-0.1646,-0.16128,0.07),(-0.16524,-0.15994,0.07),(-0.16597,-0.15867,0.07),(-0.16678,-0.15748,0.07),(-0.16769,-0.15636,0.07),(-0.16869,-0.15534,0.07),(-0.16979,-0.15442,0.07),(-0.16979,-0.15442,0),(-0.16869,-0.15534,0),(-0.16769,-0.15636,0),(-0.16678,-0.15748,0),(-0.16597,-0.15867,0),(-0.16524,-0.15994,0),(-0.1646,-0.16128,0),(-0.16355,-0.1641,0),(-0.16279,-0.16707,0),(-0.16228,-0.17011,0),(-0.162,-0.17313,0),(-0.16192,-0.17608,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99825,-0.05919,0),(-0.99201,-0.12616,0),(-0.97897,-0.20399,0),(-0.95526,-0.29576,0),(-0.91475,-0.40402,0),(-0.88553,-0.46458,0),(-0.84859,-0.52905,0),(-0.80255,-0.59658,0),(-0.74619,-0.66574,0),(-0.67868,-0.73443,0),(-0.6,-0.8,0),(-0.6,-0.8,0),(-0.67868,-0.73443,0),(-0.74619,-0.66574,0),(-0.80255,-0.59658,0),(-0.84859,-0.52905,0),(-0.88553,-0.46458,0),(-0.91475,-0.40402,0),(-0.95526,-0.29576,0),(-0.97897,-0.20399,0),(-0.99201,-0.12616,0),(-0.99825,-0.05919,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(-0.16979,-0.15442,0.07),(-0.17085,-0.15344,0.07),(-0.17197,-0.15253,0.07),(-0.17439,-0.1509,0.07),(-0.17701,-0.14955,0.07),(-0.17978,-0.14845,0.07),(-0.18265,-0.14761,0.07),(-0.18559,-0.14702,0.07),(-0.18854,-0.14667,0.07),(-0.19145,-0.14655,0.07),(-0.19145,-0.14655,0),(-0.18854,-0.14667,0),(-0.18559,-0.14702,0),(-0.18265,-0.14761,0),(-0.17978,-0.14845,0),(-0.17701,-0.14955,0),(-0.17439,-0.1509,0),(-0.17197,-0.15253,0),(-0.17085,-0.15344,0),(-0.16979,-0.15442,0.0)]),
          normal=Normal(vector=[(-0.70711,-0.70711,0),(-0.65709,-0.75381,0),(-0.6068,-0.79485,0),(-0.50772,-0.86152,0),(-0.4129,-0.91078,0),(-0.32332,-0.94629,0),(-0.23865,-0.97111,0),(-0.15769,-0.98749,0),(-0.07881,-0.99689,0),(0,-1.0,0),(0,-1.0,0),(-0.07881,-0.99689,0),(-0.15769,-0.98749,0),(-0.23865,-0.97111,0),(-0.32332,-0.94629,0),(-0.4129,-0.91078,0),(-0.50772,-0.86152,0),(-0.6068,-0.79485,0),(-0.65709,-0.75381,0),(-0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.19145,-0.14655,0.07),(-0.19324,-0.14663,0.07),(-0.19502,-0.14686,0.07),(-0.19678,-0.14723,0.07),(-0.19853,-0.14772,0.07),(-0.20195,-0.14897,0.07),(-0.20523,-0.15049,0.07),(-0.20523,-0.15049,0),(-0.20195,-0.14897,0),(-0.19853,-0.14772,0),(-0.19678,-0.14723,0),(-0.19502,-0.14686,0),(-0.19324,-0.14663,0),(-0.19145,-0.14655,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0.08943,-0.99599,0),(0.16862,-0.98568,0),(0.23736,-0.97142,0),(0.29609,-0.95516,0),(0.38674,-0.92219,0),(0.44721,-0.89443,0),(0.44721,-0.89443,0),(0.38674,-0.92219,0),(0.29609,-0.95516,0),(0.23736,-0.97142,0),(0.16862,-0.98568,0),(0.08943,-0.99599,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.20523,-0.15049,0.07),(-0.21035,-0.15418,0.07),(-0.21507,-0.15836,0.07),(-0.21507,-0.15836,0),(-0.21035,-0.15418,0),(-0.20523,-0.15049,0.0)]),
          normal=Normal(vector=[(0.5547,-0.83205,0),(0.62005,-0.78456,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.62005,-0.78456,0),(0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.21507,-0.15836,0.07),(-0.21492,-0.16087,0.07),(-0.21449,-0.16335,0.07),(-0.21311,-0.16821,0.07),(-0.21311,-0.16821,0),(-0.21449,-0.16335,0),(-0.21492,-0.16087,0),(-0.21507,-0.15836,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,0.12161,-0.0),(0.97691,0.21363,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.97691,0.21363,-0.0),(0.99258,0.12161,-0.0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.21311,-0.16821,0.07),(-0.21259,-0.16935,0.07),(-0.21217,-0.17054,0.07),(-0.21182,-0.17175,0.07),(-0.21156,-0.173,0.07),(-0.21123,-0.17552,0.07),(-0.21114,-0.17805,0.07),(-0.21114,-0.17805,0),(-0.21123,-0.17552,0),(-0.21156,-0.173,0),(-0.21182,-0.17175,0),(-0.21217,-0.17054,0),(-0.21259,-0.16935,0),(-0.21311,-0.16821,0.0)]),
          normal=Normal(vector=[(0.89443,0.44721,-0.0),(0.92797,0.37265,-0.0),(0.95305,0.3028,-0.0),(0.97116,0.23845,-0.0),(0.98369,0.17989,-0.0),(0.99682,0.07973,-0.0),(1.0,0,0),(1.0,0,0),(0.99682,0.07973,-0.0),(0.98369,0.17989,-0.0),(0.97116,0.23845,-0.0),(0.95305,0.3028,-0.0),(0.92797,0.37265,-0.0),(0.89443,0.44721,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.21114,-0.17805,0.07),(-0.21122,-0.17915,0.07),(-0.21146,-0.18023,0.07),(-0.21184,-0.18128,0.07),(-0.21233,-0.18231,0.07),(-0.21292,-0.1833,0.07),(-0.21358,-0.18423,0.07),(-0.21431,-0.18511,0.07),(-0.21507,-0.18592,0.07),(-0.21507,-0.18592,0),(-0.21431,-0.18511,0),(-0.21358,-0.18423,0),(-0.21292,-0.1833,0),(-0.21233,-0.18231,0),(-0.21184,-0.18128,0),(-0.21146,-0.18023,0),(-0.21122,-0.17915,0),(-0.21114,-0.17805,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.98874,-0.14963,0),(0.96042,-0.27856,0),(0.92238,-0.38629,0),(0.8799,-0.47516,0),(0.83613,-0.54853,0),(0.79259,-0.60975,0),(0.7497,-0.66178,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.7497,-0.66178,0),(0.79259,-0.60975,0),(0.83613,-0.54853,0),(0.8799,-0.47516,0),(0.92238,-0.38629,0),(0.96042,-0.27856,0),(0.98874,-0.14963,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.21507,-0.18592,0.07),(-0.21644,-0.18652,0.07),(-0.21786,-0.18699,0.07),(-0.21933,-0.18733,0.07),(-0.22082,-0.18758,0.07),(-0.22386,-0.18784,0.07),(-0.22689,-0.18789,0.07),(-0.22689,-0.18789,0),(-0.22386,-0.18784,0),(-0.22082,-0.18758,0),(-0.21933,-0.18733,0),(-0.21786,-0.18699,0),(-0.21644,-0.18652,0),(-0.21507,-0.18592,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.35328,-0.93552,0),(0.26836,-0.96332,0),(0.19461,-0.98088,0),(0.13281,-0.99114,0),(0.04437,-0.99902,0),(0,-1.0,0),(0,-1.0,0),(0.04437,-0.99902,0),(0.13281,-0.99114,0),(0.19461,-0.98088,0),(0.26836,-0.96332,0),(0.35328,-0.93552,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.22689,-0.18789,0.07),(-0.22798,-0.18781,0.07),(-0.22906,-0.18757,0.07),(-0.23012,-0.1872,0.07),(-0.23115,-0.1867,0.07),(-0.23213,-0.18611,0.07),(-0.23307,-0.18545,0.07),(-0.23395,-0.18472,0.07),(-0.23476,-0.18396,0.07),(-0.23476,-0.18396,0),(-0.23395,-0.18472,0),(-0.23307,-0.18545,0),(-0.23213,-0.18611,0),(-0.23115,-0.1867,0),(-0.23012,-0.1872,0),(-0.22906,-0.18757,0),(-0.22798,-0.18781,0),(-0.22689,-0.18789,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.14963,-0.98874,0),(-0.27856,-0.96042,0),(-0.38629,-0.92238,0),(-0.47516,-0.8799,0),(-0.54853,-0.83613,0),(-0.60975,-0.79259,0),(-0.66178,-0.7497,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.66178,-0.7497,0),(-0.60975,-0.79259,0),(-0.54853,-0.83613,0),(-0.47516,-0.8799,0),(-0.38629,-0.92238,0),(-0.27856,-0.96042,0),(-0.14963,-0.98874,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.23476,-0.18396,0.07),(-0.23528,-0.18281,0.07),(-0.2357,-0.18163,0.07),(-0.23604,-0.18041,0.07),(-0.23631,-0.17917,0.07),(-0.23663,-0.17664,0.07),(-0.23673,-0.17411,0.07),(-0.23673,-0.17411,0),(-0.23663,-0.17664,0),(-0.23631,-0.17917,0),(-0.23604,-0.18041,0),(-0.2357,-0.18163,0),(-0.23528,-0.18281,0),(-0.23476,-0.18396,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.92797,-0.37265,0),(-0.95305,-0.3028,0),(-0.97116,-0.23845,0),(-0.98369,-0.17989,0),(-0.99682,-0.07973,0),(-1.0,0,0),(-1.0,0,0),(-0.99682,-0.07973,0),(-0.98369,-0.17989,0),(-0.97116,-0.23845,0),(-0.95305,-0.3028,0),(-0.92797,-0.37265,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.23673,-0.17411,0.07),(-0.23658,-0.17063,0.07),(-0.23617,-0.16717,0.07),(-0.23476,-0.16033,0.07),(-0.23476,-0.16033,0),(-0.23617,-0.16717,0),(-0.23658,-0.17063,0),(-0.23673,-0.17411,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99653,0.08318,0),(-0.98855,0.15091,0),(-0.97014,0.24254,0),(-0.97014,0.24254,0),(-0.98855,0.15091,0),(-0.99653,0.08318,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.23476,-0.16033,0.07),(-0.23268,-0.15753,0.07),(-0.23032,-0.15493,0.07),(-0.22772,-0.15257,0.07),(-0.22492,-0.15049,0.07),(-0.22492,-0.15049,0),(-0.22772,-0.15257,0),(-0.23032,-0.15493,0),(-0.23268,-0.15753,0),(-0.23476,-0.16033,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,0),(-0.77259,0.63491,0),(-0.70711,0.70711,0),(-0.63491,0.77259,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.63491,0.77259,0),(-0.70711,0.70711,0),(-0.77259,0.63491,0),(-0.83205,0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-0.22492,-0.15049,0.07),(-0.22322,-0.1489,0.07),(-0.22142,-0.14743,0.07),(-0.21756,-0.14479,0.07),(-0.21344,-0.14254,0.07),(-0.20917,-0.14064,0.07),(-0.20917,-0.14064,0),(-0.21344,-0.14254,0),(-0.21756,-0.14479,0),(-0.22142,-0.14743,0),(-0.22322,-0.1489,0),(-0.22492,-0.15049,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.65782,0.75317,0),(-0.60979,0.79256,0),(-0.51995,0.85419,0),(-0.44036,0.89782,0),(-0.37139,0.92848,0),(-0.37139,0.92848,0),(-0.44036,0.89782,0),(-0.51995,0.85419,0),(-0.60979,0.79256,0),(-0.65782,0.75317,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.20917,-0.14064,0.07),(-0.20441,-0.13898,0.07),(-0.1995,-0.13774,0.07),(-0.19451,-0.13697,0.07),(-0.18948,-0.13671,0.07),(-0.18948,-0.13671,0),(-0.19451,-0.13697,0),(-0.1995,-0.13774,0),(-0.20441,-0.13898,0),(-0.20917,-0.14064,0.0)]),
          normal=Normal(vector=[(-0.37139,0.92848,0),(-0.28812,0.9576,0),(-0.19952,0.97989,0),(-0.10395,0.99458,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.10395,0.99458,0),(-0.19952,0.97989,0),(-0.28812,0.9576,0),(-0.37139,0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(-0.18948,-0.13671,0.07),(-0.18453,-0.13686,0.07),(-0.17952,-0.13736,0.07),(-0.17452,-0.1382,0.07),(-0.1696,-0.13942,0.07),(-0.16482,-0.14104,0.07),(-0.16027,-0.14308,0.07),(-0.156,-0.14557,0.07),(-0.15399,-0.14698,0.07),(-0.15207,-0.14852,0.07),(-0.15207,-0.14852,0),(-0.15399,-0.14698,0),(-0.156,-0.14557,0),(-0.16027,-0.14308,0),(-0.16482,-0.14104,0),(-0.1696,-0.13942,0),(-0.17452,-0.1382,0),(-0.17952,-0.13736,0),(-0.18453,-0.13686,0),(-0.18948,-0.13671,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06411,0.99794,-0.0),(0.13121,0.99135,-0.0),(0.20278,0.97922,-0.0),(0.28008,0.95998,-0.0),(0.36398,0.93141,-0.0),(0.45468,0.89066,-0.0),(0.5512,0.83437,-0.0),(0.60087,0.79935,-0.0),(0.65079,0.75926,-0.0),(0.65079,0.75926,-0.0),(0.60087,0.79935,-0.0),(0.5512,0.83437,-0.0),(0.45468,0.89066,-0.0),(0.36398,0.93141,-0.0),(0.28008,0.95998,-0.0),(0.20278,0.97922,-0.0),(0.13121,0.99135,-0.0),(0.06411,0.99794,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,27,-1,27,1,26,-1,26,1,2,-1,25,2,3,-1,24,3,23,-1,24,25,3,-1,26,2,25,-1,3,4,23,-1,23,4,5,-1,22,5,6,-1,21,6,7,-1,20,7,19,-1,20,21,7,-1,23,5,22,-1,22,6,21,-1,7,8,19,-1,19,8,18,-1,18,8,9,-1,10,18,9,-1,10,17,18,-1,10,11,17,-1,17,11,16,-1,16,11,12,-1,15,12,13,-1,14,15,13,-1,16,12,15,-1],solid=False,
          coord=Coordinate(point=[(-0.15207,-0.14852,0.07),(-0.15042,-0.14964,0.07),(-0.14882,-0.15088,0.07),(-0.14729,-0.15224,0.07),(-0.14583,-0.1537,0.07),(-0.14315,-0.15691,0.07),(-0.14083,-0.16043,0.07),(-0.13894,-0.16419,0.07),(-0.13817,-0.16613,0.07),(-0.13752,-0.1681,0.07),(-0.13701,-0.17009,0.07),(-0.13663,-0.17209,0.07),(-0.1364,-0.17409,0.07),(-0.13632,-0.17608,0.07),(-0.13632,-0.17608,0),(-0.1364,-0.17409,0),(-0.13663,-0.17209,0),(-0.13701,-0.17009,0),(-0.13752,-0.1681,0),(-0.13817,-0.16613,0),(-0.13894,-0.16419,0),(-0.14083,-0.16043,0),(-0.14315,-0.15691,0),(-0.14583,-0.1537,0),(-0.14729,-0.15224,0),(-0.14882,-0.15088,0),(-0.15042,-0.14964,0),(-0.15207,-0.14852,0.0)]),
          normal=Normal(vector=[(0.53,0.848,-0.0),(0.58756,0.80918,-0.0),(0.63945,0.76883,-0.0),(0.68637,0.72725,-0.0),(0.72895,0.68457,-0.0),(0.80322,0.59569,-0.0),(0.86557,0.50079,-0.0),(0.9177,0.39727,-0.0),(0.93999,0.34121,-0.0),(0.95951,0.28167,-0.0),(0.97591,0.21816,-0.0),(0.98865,0.15025,-0.0),(0.99699,0.07759,-0.0),(1.0,0,0),(1.0,0,0),(0.99699,0.07759,-0.0),(0.98865,0.15025,-0.0),(0.97591,0.21816,-0.0),(0.95951,0.28167,-0.0),(0.93999,0.34121,-0.0),(0.9177,0.39727,-0.0),(0.86557,0.50079,-0.0),(0.80322,0.59569,-0.0),(0.72895,0.68457,-0.0),(0.68637,0.72725,-0.0),(0.63945,0.76883,-0.0),(0.58756,0.80918,-0.0),(0.53,0.848,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,13,-1,13,1,2,-1,3,13,2,-1,3,12,13,-1,3,4,12,-1,12,4,11,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(-0.13632,-0.17608,0.07),(-0.13652,-0.18019,0.07),(-0.13678,-0.18226,0.07),(-0.13717,-0.1843,0.07),(-0.1377,-0.1863,0.07),(-0.13838,-0.18823,0.07),(-0.13923,-0.19008,0.07),(-0.14026,-0.19183,0.07),(-0.14026,-0.19183,0),(-0.13923,-0.19008,0),(-0.13838,-0.18823,0),(-0.1377,-0.1863,0),(-0.13717,-0.1843,0),(-0.13678,-0.18226,0),(-0.13652,-0.18019,0),(-0.13632,-0.17608,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99526,-0.0972,0),(0.9879,-0.15509,0),(0.97545,-0.22022,0),(0.95608,-0.29311,0),(0.92748,-0.37386,0),(0.88703,-0.46172,0),(0.83205,-0.5547,0),(0.83205,-0.5547,0),(0.88703,-0.46172,0),(0.92748,-0.37386,0),(0.95608,-0.29311,0),(0.97545,-0.22022,0),(0.9879,-0.15509,0),(0.99526,-0.0972,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,12,-1,13,14,4,-1,16,2,15,-1,15,3,14,-1,4,5,12,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.14026,-0.19183,0.07),(-0.14081,-0.19374,0.07),(-0.14151,-0.19562,0.07),(-0.14233,-0.19746,0.07),(-0.14328,-0.19924,0.07),(-0.14434,-0.20096,0.07),(-0.14551,-0.2026,0.07),(-0.14678,-0.20416,0.07),(-0.14814,-0.20561,0.07),(-0.14814,-0.20561,0),(-0.14678,-0.20416,0),(-0.14551,-0.2026,0),(-0.14434,-0.20096,0),(-0.14328,-0.19924,0),(-0.14233,-0.19746,0),(-0.14151,-0.19562,0),(-0.14081,-0.19374,0),(-0.14026,-0.19183,0.0)]),
          normal=Normal(vector=[(0.97014,-0.24254,0),(0.94996,-0.31238,0),(0.92587,-0.37783,0),(0.89827,-0.43945,0),(0.86731,-0.49776,0),(0.83298,-0.5533,0),(0.79509,-0.60649,0),(0.7533,-0.65768,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.7533,-0.65768,0),(0.79509,-0.60649,0),(0.83298,-0.5533,0),(0.86731,-0.49776,0),(0.89827,-0.43945,0),(0.92587,-0.37783,0),(0.94996,-0.31238,0),(0.97014,-0.24254,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.14814,-0.20561,0.07),(-0.15126,-0.20848,0.07),(-0.15463,-0.21108,0.07),(-0.1582,-0.21341,0.07),(-0.16192,-0.21546,0.07),(-0.16192,-0.21546,0),(-0.1582,-0.21341,0),(-0.15463,-0.21108,0),(-0.15126,-0.20848,0),(-0.14814,-0.20561,0.0)]),
          normal=Normal(vector=[(0.70711,-0.70711,0),(0.64387,-0.76514,0),(0.57953,-0.81495,0),(0.5141,-0.85773,0),(0.44721,-0.89443,0),(0.44721,-0.89443,0),(0.5141,-0.85773,0),(0.57953,-0.81495,0),(0.64387,-0.76514,0),(0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.16192,-0.21546,0.07),(-0.17465,-0.22151,0.07),(-0.18751,-0.22727,0.07),(-0.18751,-0.22727,0),(-0.17465,-0.22151,0),(-0.16192,-0.21546,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.41518,-0.90974,0),(0.40614,-0.91381,0),(0.40614,-0.91381,0),(0.41518,-0.90974,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.18751,-0.22727,0.07),(-0.19217,-0.2293,0.07),(-0.1967,-0.23161,0.07),(-0.20106,-0.23422,0.07),(-0.20523,-0.23711,0.07),(-0.20523,-0.23711,0),(-0.20106,-0.23422,0),(-0.1967,-0.23161,0),(-0.19217,-0.2293,0),(-0.18751,-0.22727,0.0)]),
          normal=Normal(vector=[(0.37139,-0.92848,0),(0.42695,-0.90427,0),(0.48353,-0.87533,0),(0.54124,-0.84087,0),(0.6,-0.8,0),(0.6,-0.8,0),(0.54124,-0.84087,0),(0.48353,-0.87533,0),(0.42695,-0.90427,0),(0.37139,-0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(-0.20523,-0.23711,0.07),(-0.21332,-0.24065,0.07),(-0.21723,-0.24269,0.07),(-0.22098,-0.24499,0.07),(-0.22098,-0.24499,0),(-0.21723,-0.24269,0),(-0.21332,-0.24065,0),(-0.20523,-0.23711,0.0)]),
          normal=Normal(vector=[(0.37139,-0.92848,0),(0.43805,-0.89895,0),(0.49065,-0.87136,0),(0.5547,-0.83205,0),(0.5547,-0.83205,0),(0.49065,-0.87136,0),(0.43805,-0.89895,0),(0.37139,-0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.22098,-0.24499,0.07),(-0.13042,-0.24499,0.07),(-0.13042,-0.24499,0),(-0.22098,-0.24499,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,152,-1,153,0,152,-1,153,154,0,-1,0,154,155,-1,156,0,155,-1,156,157,0,-1,3,150,2,-1,3,4,150,-1,150,4,149,-1,149,4,148,-1,148,4,5,-1,147,5,6,-1,146,6,7,-1,8,146,7,-1,8,145,146,-1,8,9,145,-1,145,9,144,-1,144,9,10,-1,143,10,142,-1,143,144,10,-1,148,5,147,-1,147,6,146,-1,10,11,142,-1,142,11,141,-1,141,11,12,-1,13,141,12,-1,13,140,141,-1,13,14,140,-1,140,14,15,-1,139,15,16,-1,17,139,16,-1,17,18,139,-1,139,18,138,-1,138,18,19,-1,20,138,19,-1,20,137,138,-1,20,21,137,-1,137,21,22,-1,136,22,23,-1,24,136,23,-1,24,25,136,-1,136,25,135,-1,135,25,26,-1,27,135,26,-1,27,134,135,-1,27,28,134,-1,134,28,29,-1,133,29,30,-1,31,133,30,-1,31,132,133,-1,31,32,132,-1,132,32,131,-1,131,32,33,-1,34,131,33,-1,34,130,131,-1,34,35,130,-1,130,35,36,-1,37,130,36,-1,37,38,130,-1,130,38,39,-1,40,130,39,-1,40,129,130,-1,40,41,129,-1,129,41,42,-1,43,129,42,-1,43,128,129,-1,43,44,128,-1,128,44,127,-1,127,44,45,-1,126,45,125,-1,126,127,45,-1,140,15,139,-1,137,22,136,-1,134,29,133,-1,46,113,45,-1,46,47,113,-1,113,47,48,-1,49,113,48,-1,49,50,113,-1,113,50,51,-1,52,113,51,-1,52,53,113,-1,113,53,112,-1,112,53,111,-1,111,53,54,-1,110,54,109,-1,110,111,54,-1,54,55,109,-1,109,55,108,-1,108,55,107,-1,107,55,56,-1,57,107,56,-1,57,106,107,-1,57,58,106,-1,106,58,105,-1,105,58,59,-1,60,105,59,-1,60,61,105,-1,105,61,62,-1,104,62,63,-1,103,63,64,-1,66,64,65,-1,66,103,64,-1,66,102,103,-1,66,67,102,-1,102,67,68,-1,83,68,69,-1,82,69,81,-1,82,83,69,-1,105,62,104,-1,104,63,103,-1,102,68,83,-1,84,102,83,-1,84,101,102,-1,84,100,101,-1,84,99,100,-1,84,98,99,-1,84,85,98,-1,98,85,97,-1,97,85,86,-1,91,86,90,-1,91,97,86,-1,91,92,97,-1,97,92,96,-1,96,92,93,-1,94,96,93,-1,94,95,96,-1,70,79,69,-1,70,78,79,-1,70,77,78,-1,70,71,77,-1,77,71,76,-1,76,71,72,-1,75,72,73,-1,74,75,73,-1,76,72,75,-1,79,80,69,-1,69,80,81,-1,86,87,90,-1,90,87,89,-1,89,87,88,-1,113,114,45,-1,45,114,115,-1,116,45,115,-1,116,117,45,-1,45,117,118,-1,119,45,118,-1,119,120,45,-1,45,120,121,-1,122,45,121,-1,122,123,45,-1,45,123,124,-1,125,45,124,-1,150,151,2,-1,2,151,152,-1],solid=False,
          coord=Coordinate(point=[(-0.13042,-0.26467,0.07),(-0.13042,-0.24499,0.07),(-0.22098,-0.24499,0.07),(-0.21723,-0.24269,0.07),(-0.21332,-0.24065,0.07),(-0.20523,-0.23711,0.07),(-0.20106,-0.23422,0.07),(-0.1967,-0.23161,0.07),(-0.19217,-0.2293,0.07),(-0.18751,-0.22727,0.07),(-0.17465,-0.22151,0.07),(-0.16192,-0.21546,0.07),(-0.1582,-0.21341,0.07),(-0.15463,-0.21108,0.07),(-0.15126,-0.20848,0.07),(-0.14814,-0.20561,0.07),(-0.14678,-0.20416,0.07),(-0.14551,-0.2026,0.07),(-0.14434,-0.20096,0.07),(-0.14328,-0.19924,0.07),(-0.14233,-0.19746,0.07),(-0.14151,-0.19562,0.07),(-0.14081,-0.19374,0.07),(-0.14026,-0.19183,0.07),(-0.13923,-0.19008,0.07),(-0.13838,-0.18823,0.07),(-0.1377,-0.1863,0.07),(-0.13717,-0.1843,0.07),(-0.13678,-0.18226,0.07),(-0.13652,-0.18019,0.07),(-0.13632,-0.17608,0.07),(-0.1364,-0.17409,0.07),(-0.13663,-0.17209,0.07),(-0.13701,-0.17009,0.07),(-0.13752,-0.1681,0.07),(-0.13817,-0.16613,0.07),(-0.13894,-0.16419,0.07),(-0.14083,-0.16043,0.07),(-0.14315,-0.15691,0.07),(-0.14583,-0.1537,0.07),(-0.14729,-0.15224,0.07),(-0.14882,-0.15088,0.07),(-0.15042,-0.14964,0.07),(-0.15207,-0.14852,0.07),(-0.15399,-0.14698,0.07),(-0.156,-0.14557,0.07),(-0.16027,-0.14308,0.07),(-0.16482,-0.14104,0.07),(-0.1696,-0.13942,0.07),(-0.17452,-0.1382,0.07),(-0.17952,-0.13736,0.07),(-0.18453,-0.13686,0.07),(-0.18948,-0.13671,0.07),(-0.19451,-0.13697,0.07),(-0.1995,-0.13774,0.07),(-0.20441,-0.13898,0.07),(-0.20917,-0.14064,0.07),(-0.21344,-0.14254,0.07),(-0.21756,-0.14479,0.07),(-0.22142,-0.14743,0.07),(-0.22322,-0.1489,0.07),(-0.22492,-0.15049,0.07),(-0.22772,-0.15257,0.07),(-0.23032,-0.15493,0.07),(-0.23268,-0.15753,0.07),(-0.23476,-0.16033,0.07),(-0.23617,-0.16717,0.07),(-0.23658,-0.17063,0.07),(-0.23673,-0.17411,0.07),(-0.23663,-0.17664,0.07),(-0.23631,-0.17917,0.07),(-0.23604,-0.18041,0.07),(-0.2357,-0.18163,0.07),(-0.23528,-0.18281,0.07),(-0.23476,-0.18396,0.07),(-0.23395,-0.18472,0.07),(-0.23307,-0.18545,0.07),(-0.23213,-0.18611,0.07),(-0.23115,-0.1867,0.07),(-0.23012,-0.1872,0.07),(-0.22906,-0.18757,0.07),(-0.22798,-0.18781,0.07),(-0.22689,-0.18789,0.07),(-0.22386,-0.18784,0.07),(-0.22082,-0.18758,0.07),(-0.21933,-0.18733,0.07),(-0.21786,-0.18699,0.07),(-0.21644,-0.18652,0.07),(-0.21507,-0.18592,0.07),(-0.21431,-0.18511,0.07),(-0.21358,-0.18423,0.07),(-0.21292,-0.1833,0.07),(-0.21233,-0.18231,0.07),(-0.21184,-0.18128,0.07),(-0.21146,-0.18023,0.07),(-0.21122,-0.17915,0.07),(-0.21114,-0.17805,0.07),(-0.21123,-0.17552,0.07),(-0.21156,-0.173,0.07),(-0.21182,-0.17175,0.07),(-0.21217,-0.17054,0.07),(-0.21259,-0.16935,0.07),(-0.21311,-0.16821,0.07),(-0.21449,-0.16335,0.07),(-0.21492,-0.16087,0.07),(-0.21507,-0.15836,0.07),(-0.21035,-0.15418,0.07),(-0.20523,-0.15049,0.07),(-0.20195,-0.14897,0.07),(-0.19853,-0.14772,0.07),(-0.19678,-0.14723,0.07),(-0.19502,-0.14686,0.07),(-0.19324,-0.14663,0.07),(-0.19145,-0.14655,0.07),(-0.18854,-0.14667,0.07),(-0.18559,-0.14702,0.07),(-0.18265,-0.14761,0.07),(-0.17978,-0.14845,0.07),(-0.17701,-0.14955,0.07),(-0.17439,-0.1509,0.07),(-0.17197,-0.15253,0.07),(-0.17085,-0.15344,0.07),(-0.16979,-0.15442,0.07),(-0.16869,-0.15534,0.07),(-0.16769,-0.15636,0.07),(-0.16678,-0.15748,0.07),(-0.16597,-0.15867,0.07),(-0.16524,-0.15994,0.07),(-0.1646,-0.16128,0.07),(-0.16355,-0.1641,0.07),(-0.16279,-0.16707,0.07),(-0.16228,-0.17011,0.07),(-0.162,-0.17313,0.07),(-0.16192,-0.17608,0.07),(-0.16227,-0.18406,0.07),(-0.16287,-0.188,0.07),(-0.16389,-0.19183,0.07),(-0.16586,-0.19577,0.07),(-0.16782,-0.19971,0.07),(-0.17275,-0.20463,0.07),(-0.17767,-0.20955,0.07),(-0.18443,-0.2137,0.07),(-0.19145,-0.21742,0.07),(-0.19932,-0.22136,0.07),(-0.2072,-0.2253,0.07),(-0.21232,-0.229,0.07),(-0.21704,-0.23317,0.07),(-0.22076,-0.23522,0.07),(-0.22433,-0.23755,0.07),(-0.2277,-0.24015,0.07),(-0.23082,-0.24302,0.07),(-0.23312,-0.24465,0.07),(-0.2353,-0.24648,0.07),(-0.23629,-0.24749,0.07),(-0.2372,-0.24855,0.07),(-0.23801,-0.24969,0.07),(-0.2387,-0.25089,0.07),(-0.2387,-0.26467,0.07)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(-0.04773,-0.25877,0.07),(-0.04579,-0.25871,0.07),(-0.04384,-0.25852,0.07),(-0.03993,-0.25779,0.07),(-0.03607,-0.25661,0.07),(-0.03234,-0.25501,0.07),(-0.0288,-0.25302,0.07),(-0.02555,-0.25067,0.07),(-0.02405,-0.24936,0.07),(-0.02264,-0.24798,0.07),(-0.02135,-0.24652,0.07),(-0.02017,-0.24499,0.07),(-0.02017,-0.24499,0),(-0.02135,-0.24652,0),(-0.02264,-0.24798,0),(-0.02405,-0.24936,0),(-0.02555,-0.25067,0),(-0.0288,-0.25302,0),(-0.03234,-0.25501,0),(-0.03607,-0.25661,0),(-0.03993,-0.25779,0),(-0.04384,-0.25852,0),(-0.04579,-0.25871,0),(-0.04773,-0.25877,0.0)]),
          normal=Normal(vector=[(-0.0,1.0,-0.0),(-0.06425,0.99793,-0.0),(-0.12521,0.99213,-0.0),(-0.23874,0.97108,-0.0),(-0.34365,0.9391,-0.0),(-0.44283,0.89661,-0.0),(-0.53865,0.84253,-0.0),(-0.63262,0.77447,-0.0),(-0.67904,0.7341,-0.0),(-0.72493,0.68882,-0.0),(-0.76999,0.63805,-0.0),(-0.81373,0.58124,-0.0),(-0.81373,0.58124,-0.0),(-0.76999,0.63805,-0.0),(-0.72493,0.68882,-0.0),(-0.67904,0.7341,-0.0),(-0.63262,0.77447,-0.0),(-0.53865,0.84253,-0.0),(-0.44283,0.89661,-0.0),(-0.34365,0.9391,-0.0),(-0.23874,0.97108,-0.0),(-0.12521,0.99213,-0.0),(-0.06425,0.99793,-0.0),(-0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,13,-1,14,15,7,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,7,8,13,-1,13,8,12,-1,12,8,9,-1,10,12,9,-1,10,11,12,-1],solid=False,
          coord=Coordinate(point=[(-0.07332,-0.24499,0.07),(-0.071,-0.24784,0.07),(-0.06831,-0.25047,0.07),(-0.06531,-0.25281,0.07),(-0.06205,-0.25483,0.07),(-0.0586,-0.25649,0.07),(-0.05502,-0.25772,0.07),(-0.05321,-0.25817,0.07),(-0.05138,-0.2585,0.07),(-0.04955,-0.2587,0.07),(-0.04773,-0.25877,0.07),(-0.04773,-0.25877,0),(-0.04955,-0.2587,0),(-0.05138,-0.2585,0),(-0.05321,-0.25817,0),(-0.05502,-0.25772,0),(-0.0586,-0.25649,0),(-0.06205,-0.25483,0),(-0.06531,-0.25281,0),(-0.06831,-0.25047,0),(-0.071,-0.24784,0),(-0.07332,-0.24499,0.0)]),
          normal=Normal(vector=[(0.81373,0.58124,-0.0),(0.73743,0.67542,-0.0),(0.65704,0.75386,-0.0),(0.57212,0.82017,-0.0),(0.48101,0.87672,-0.0),(0.38121,0.92449,-0.0),(0.2697,0.96294,-0.0),(0.20857,0.97801,-0.0),(0.14338,0.98967,-0.0),(0.07389,0.99727,-0.0),(-0.0,1.0,-0.0),(-0.0,1.0,-0.0),(0.07389,0.99727,-0.0),(0.14338,0.98967,-0.0),(0.20857,0.97801,-0.0),(0.2697,0.96294,-0.0),(0.38121,0.92449,-0.0),(0.48101,0.87672,-0.0),(0.57212,0.82017,-0.0),(0.65704,0.75386,-0.0),(0.73743,0.67542,-0.0),(0.81373,0.58124,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.0812,-0.20364,0.07),(-0.08085,-0.21426,0.07),(-0.07961,-0.22487,0.07),(-0.07857,-0.23009,0.07),(-0.0772,-0.23521,0.07),(-0.07546,-0.24018,0.07),(-0.07332,-0.24499,0.07),(-0.07332,-0.24499,0),(-0.07546,-0.24018,0),(-0.0772,-0.23521,0),(-0.07857,-0.23009,0),(-0.07961,-0.22487,0),(-0.08085,-0.21426,0),(-0.0812,-0.20364,0.0)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(0.99757,0.06966,-0.0),(0.98604,0.16652,-0.0),(0.97412,0.22603,-0.0),(0.9561,0.29305,-0.0),(0.93016,0.36716,-0.0),(0.89443,0.44721,-0.0),(0.89443,0.44721,-0.0),(0.93016,0.36716,-0.0),(0.9561,0.29305,-0.0),(0.97412,0.22603,-0.0),(0.98604,0.16652,-0.0),(0.99757,0.06966,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.07332,-0.1623,0.07),(-0.07566,-0.167,0.07),(-0.07749,-0.17193,0.07),(-0.07887,-0.17704,0.07),(-0.07987,-0.18228,0.07),(-0.08095,-0.19298,0.07),(-0.0812,-0.20364,0.07),(-0.0812,-0.20364,0),(-0.08095,-0.19298,0),(-0.07987,-0.18228,0),(-0.07887,-0.17704,0),(-0.07749,-0.17193,0),(-0.07566,-0.167,0),(-0.07332,-0.1623,0.0)]),
          normal=Normal(vector=[(0.86824,-0.49614,-0.0),(0.91864,-0.3951,-0.0),(0.95306,-0.30278,-0.0),(0.97505,-0.222,-0.0),(0.98811,-0.15378,-0.0),(0.99853,-0.05422,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(0.99853,-0.05422,-0.0),(0.98811,-0.15378,-0.0),(0.97505,-0.222,-0.0),(0.95306,-0.30278,-0.0),(0.91864,-0.3951,-0.0),(0.86824,-0.49614,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,27,-1,27,1,26,-1,26,1,2,-1,25,2,3,-1,24,3,23,-1,24,25,3,-1,26,2,25,-1,3,4,23,-1,23,4,5,-1,22,5,21,-1,22,23,5,-1,5,6,21,-1,21,6,7,-1,20,7,8,-1,19,8,9,-1,18,9,10,-1,17,10,11,-1,16,11,12,-1,15,12,13,-1,14,15,13,-1,21,7,20,-1,20,8,19,-1,19,9,18,-1,18,10,17,-1,17,11,16,-1,16,12,15,-1],solid=False,
          coord=Coordinate(point=[(-0.04576,-0.14655,0.07),(-0.04775,-0.14663,0.07),(-0.04975,-0.14686,0.07),(-0.05175,-0.14723,0.07),(-0.05374,-0.14775,0.07),(-0.05571,-0.1484,0.07),(-0.05765,-0.14917,0.07),(-0.06141,-0.15106,0.07),(-0.06493,-0.15337,0.07),(-0.06814,-0.15605,0.07),(-0.0696,-0.15751,0.07),(-0.07096,-0.15905,0.07),(-0.07221,-0.16064,0.07),(-0.07332,-0.1623,0.07),(-0.07332,-0.1623,0),(-0.07221,-0.16064,0),(-0.07096,-0.15905,0),(-0.0696,-0.15751,0),(-0.06814,-0.15605,0),(-0.06493,-0.15337,0),(-0.06141,-0.15106,0),(-0.05765,-0.14917,0),(-0.05571,-0.1484,0),(-0.05374,-0.14775,0),(-0.05175,-0.14723,0),(-0.04975,-0.14686,0),(-0.04775,-0.14663,0),(-0.04576,-0.14655,0.0)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(0.07759,-0.99699,-0.0),(0.15025,-0.98865,-0.0),(0.21816,-0.97591,-0.0),(0.28167,-0.95951,-0.0),(0.34121,-0.93999,-0.0),(0.39727,-0.9177,-0.0),(0.50079,-0.86557,-0.0),(0.59569,-0.80322,-0.0),(0.68457,-0.72895,-0.0),(0.72725,-0.68637,-0.0),(0.76883,-0.63945,-0.0),(0.80918,-0.58756,-0.0),(0.848,-0.53,-0.0),(0.848,-0.53,-0.0),(0.80918,-0.58756,-0.0),(0.76883,-0.63945,-0.0),(0.72725,-0.68637,-0.0),(0.68457,-0.72895,-0.0),(0.59569,-0.80322,-0.0),(0.50079,-0.86557,-0.0),(0.39727,-0.9177,-0.0),(0.34121,-0.93999,-0.0),(0.28167,-0.95951,-0.0),(0.21816,-0.97591,-0.0),(0.15025,-0.98865,-0.0),(0.07759,-0.99699,-0.0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(-0.02017,-0.1623,0.07),(-0.02238,-0.15918,0.07),(-0.025,-0.15626,0.07),(-0.02796,-0.15358,0.07),(-0.0312,-0.15124,0.07),(-0.03466,-0.14929,0.07),(-0.03646,-0.14849,0.07),(-0.03828,-0.14782,0.07),(-0.04013,-0.14728,0.07),(-0.042,-0.14688,0.07),(-0.04388,-0.14663,0.07),(-0.04576,-0.14655,0.07),(-0.04576,-0.14655,0),(-0.04388,-0.14663,0),(-0.042,-0.14688,0),(-0.04013,-0.14728,0),(-0.03828,-0.14782,0),(-0.03646,-0.14849,0),(-0.03466,-0.14929,0),(-0.0312,-0.15124,0),(-0.02796,-0.15358,0),(-0.025,-0.15626,0),(-0.02238,-0.15918,0),(-0.02017,-0.1623,0.0)]),
          normal=Normal(vector=[(-0.848,-0.53,0),(-0.78112,-0.62438,0),(-0.70882,-0.70539,0),(-0.62942,-0.77707,0),(-0.53996,-0.84169,0),(-0.43649,-0.89971,0),(-0.37808,-0.92577,0),(-0.31444,-0.94928,0),(-0.24504,-0.96951,0),(-0.16952,-0.98553,0),(-0.08775,-0.99614,0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.08775,-0.99614,0),(-0.16952,-0.98553,0),(-0.24504,-0.96951,0),(-0.31444,-0.94928,0),(-0.37808,-0.92577,0),(-0.43649,-0.89971,0),(-0.53996,-0.84169,0),(-0.62942,-0.77707,0),(-0.70882,-0.70539,0),(-0.78112,-0.62438,0),(-0.848,-0.53,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(-0.01032,-0.20364,0.07),(-0.0107,-0.19283,0.07),(-0.01216,-0.18198,0.07),(-0.01343,-0.17671,0.07),(-0.01516,-0.17163,0.07),(-0.01738,-0.16681,0.07),(-0.0187,-0.16451,0.07),(-0.02017,-0.1623,0.07),(-0.02017,-0.1623,0),(-0.0187,-0.16451,0),(-0.01738,-0.16681,0),(-0.01516,-0.17163,0),(-0.01343,-0.17671,0),(-0.01216,-0.18198,0),(-0.0107,-0.19283,0),(-0.01032,-0.20364,0.0)]),
          normal=Normal(vector=[(-1.0,-0.0,-0.0),(-0.99706,-0.07659,0),(-0.9804,-0.19702,0),(-0.96117,-0.27596,0),(-0.92992,-0.36775,0),(-0.8822,-0.47088,0),(-0.85077,-0.52554,0),(-0.81373,-0.58124,0),(-0.81373,-0.58124,0),(-0.85077,-0.52554,0),(-0.8822,-0.47088,0),(-0.92992,-0.36775,0),(-0.96117,-0.27596,0),(-0.9804,-0.19702,0),(-0.99706,-0.07659,0),(-1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.02017,-0.24499,0.07),(-0.01759,-0.24034,0.07),(-0.01546,-0.23545,0.07),(-0.01375,-0.23036,0.07),(-0.01243,-0.22512,0.07),(-0.01081,-0.21439,0.07),(-0.01032,-0.20364,0.07),(-0.01032,-0.20364,0),(-0.01081,-0.21439,0),(-0.01243,-0.22512,0),(-0.01375,-0.23036,0),(-0.01546,-0.23545,0),(-0.01759,-0.24034,0),(-0.02017,-0.24499,0.0)]),
          normal=Normal(vector=[(-0.848,0.53,-0.0),(-0.89747,0.44108,-0.0),(-0.93399,0.3573,-0.0),(-0.95991,0.2803,-0.0),(-0.97755,0.21069,-0.0),(-0.99567,0.09297,-0.0),(-1.0,-0.0,0),(-1.0,-0.0,0),(-0.99567,0.09297,-0.0),(-0.97755,0.21069,-0.0),(-0.95991,0.2803,-0.0),(-0.93399,0.3573,-0.0),(-0.89747,0.44108,-0.0),(-0.848,0.53,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-4.8E-4,-0.15836,0.07),(0.00148,-0.16046,0.07),(0.00331,-0.1627,0.07),(0.00655,-0.16751,0.07),(0.00923,-0.17267,0.07),(0.01133,-0.17805,0.07),(0.01133,-0.17805,0),(0.00923,-0.17267,0),(0.00655,-0.16751,0),(0.00331,-0.1627,0),(0.00148,-0.16046,0),(-4.8E-4,-0.15836,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.75358,0.65736,-0.0),(0.79427,0.60757,-0.0),(0.86073,0.50907,-0.0),(0.91103,0.41235,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.91103,0.41235,-0.0),(0.86073,0.50907,-0.0),(0.79427,0.60757,-0.0),(0.75358,0.65736,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.01133,-0.17805,0.07),(0.0131,-0.18429,0.07),(0.01432,-0.19068,0.07),(0.01504,-0.19715,0.07),(0.01527,-0.20364,0.07),(0.01527,-0.20364,0),(0.01504,-0.19715,0),(0.01432,-0.19068,0),(0.0131,-0.18429,0),(0.01133,-0.17805,0.0)]),
          normal=Normal(vector=[(0.94868,0.31623,-0.0),(0.97333,0.22942,-0.0),(0.98898,0.14807,-0.0),(0.99742,0.07184,-0.0),(1.0,0,0),(1.0,0,0),(0.99742,0.07184,-0.0),(0.98898,0.14807,-0.0),(0.97333,0.22942,-0.0),(0.94868,0.31623,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,6,-1,7,8,4,-1,10,2,9,-1,9,3,8,-1,4,5,6,-1],solid=False,
          coord=Coordinate(point=[(0.01527,-0.20364,0.07),(0.01494,-0.21073,0.07),(0.01389,-0.2178,0.07),(0.01206,-0.22468,0.07),(0.01082,-0.22799,0.07),(0.00936,-0.23121,0.07),(0.00936,-0.23121,0),(0.01082,-0.22799,0),(0.01206,-0.22468,0),(0.01389,-0.2178,0),(0.01494,-0.21073,0),(0.01527,-0.20364,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.9955,-0.09477,0),(0.97984,-0.19979,0),(0.94834,-0.31727,0),(0.92465,-0.38082,0),(0.89443,-0.44721,0),(0.89443,-0.44721,0),(0.92465,-0.38082,0),(0.94834,-0.31727,0),(0.97984,-0.19979,0),(0.9955,-0.09477,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.00936,-0.23121,0.07),(0.00738,-0.23711,0.07),(0.00479,-0.24282,0.07),(0.00325,-0.24554,0.07),(0.00153,-0.24814,0.07),(-3.6E-4,-0.25059,0.07),(-0.00245,-0.25286,0.07),(-0.00245,-0.25286,0),(-3.6E-4,-0.25059,0),(0.00153,-0.24814,0),(0.00325,-0.24554,0),(0.00479,-0.24282,0),(0.00738,-0.23711,0),(0.00936,-0.23121,0.0)]),
          normal=Normal(vector=[(0.96152,-0.27472,0),(0.93168,-0.36329,0),(0.8852,-0.46521,0),(0.85323,-0.52154,0),(0.81377,-0.58118,0),(0.76549,-0.64345,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.76549,-0.64345,0),(0.81377,-0.58118,0),(0.85323,-0.52154,0),(0.8852,-0.46521,0),(0.93168,-0.36329,0),(0.96152,-0.27472,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(-0.00245,-0.25286,0.07),(-0.00455,-0.25482,0.07),(-0.00679,-0.25665,0.07),(-0.0116,-0.25989,0.07),(-0.01676,-0.26257,0.07),(-0.02214,-0.26467,0.07),(-0.02214,-0.26467,0),(-0.01676,-0.26257,0),(-0.0116,-0.25989,0),(-0.00679,-0.25665,0),(-0.00455,-0.25482,0),(-0.00245,-0.25286,0.0)]),
          normal=Normal(vector=[(0.70711,-0.70711,0),(0.65736,-0.75358,0),(0.60757,-0.79426,0),(0.50907,-0.86073,0),(0.41235,-0.91103,0),(0.31623,-0.94868,0),(0.31623,-0.94868,0),(0.41235,-0.91103,0),(0.50907,-0.86073,0),(0.60757,-0.79426,0),(0.65736,-0.75358,0),(0.70711,-0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.02214,-0.26467,0.07),(-0.02838,-0.26644,0.07),(-0.03477,-0.26767,0.07),(-0.04124,-0.26838,0.07),(-0.04773,-0.26861,0.07),(-0.04773,-0.26861,0),(-0.04124,-0.26838,0),(-0.03477,-0.26767,0),(-0.02838,-0.26644,0),(-0.02214,-0.26467,0.0)]),
          normal=Normal(vector=[(0.31623,-0.94868,0),(0.22942,-0.97333,0),(0.14807,-0.98898,0),(0.07184,-0.99742,0),(0,-1.0,0),(0,-1.0,0),(0.07184,-0.99742,0),(0.14807,-0.98898,0),(0.22942,-0.97333,0),(0.31623,-0.94868,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.04773,-0.26861,0.07),(-0.05422,-0.26838,0.07),(-0.06069,-0.26767,0.07),(-0.06708,-0.26644,0.07),(-0.07332,-0.26467,0.07),(-0.07332,-0.26467,0),(-0.06708,-0.26644,0),(-0.06069,-0.26767,0),(-0.05422,-0.26838,0),(-0.04773,-0.26861,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.07184,-0.99742,0),(-0.14807,-0.98898,0),(-0.22942,-0.97333,0),(-0.31623,-0.94868,0),(-0.31623,-0.94868,0),(-0.22942,-0.97333,0),(-0.14807,-0.98898,0),(-0.07184,-0.99742,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.07332,-0.26467,0.07),(-0.07863,-0.26181,0.07),(-0.08373,-0.25857,0.07),(-0.08855,-0.25493,0.07),(-0.09301,-0.25089,0.07),(-0.09301,-0.25089,0),(-0.08855,-0.25493,0),(-0.08373,-0.25857,0),(-0.07863,-0.26181,0),(-0.07332,-0.26467,0.0)]),
          normal=Normal(vector=[(-0.44721,-0.89443,0),(-0.50497,-0.86314,0),(-0.56791,-0.82309,0),(-0.63569,-0.77194,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.63569,-0.77194,0),(-0.56791,-0.82309,0),(-0.50497,-0.86314,0),(-0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.09301,-0.25089,0.07),(-0.09666,-0.2459,0.07),(-0.09987,-0.24058,0.07),(-0.1026,-0.23501,0.07),(-0.10482,-0.22924,0.07),(-0.10482,-0.22924,0),(-0.1026,-0.23501,0),(-0.09987,-0.24058,0),(-0.09666,-0.2459,0),(-0.09301,-0.25089,0.0)]),
          normal=Normal(vector=[(-0.78087,-0.6247,0),(-0.83268,-0.55376,0),(-0.87764,-0.47932,0),(-0.91629,-0.40051,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.91629,-0.40051,0),(-0.87764,-0.47932,0),(-0.83268,-0.55376,0),(-0.78087,-0.6247,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.10482,-0.22924,0.07),(-0.10634,-0.21648,0.07),(-0.10679,-0.20364,0.07),(-0.10679,-0.20364,0),(-0.10634,-0.21648,0),(-0.10482,-0.22924,0.0)]),
          normal=Normal(vector=[(-0.98639,-0.1644,0),(-0.99727,-0.07382,0),(-1.0,0,0),(-1.0,0,0),(-0.99727,-0.07382,0),(-0.98639,-0.1644,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(-0.10679,-0.20364,0.07),(-0.10634,-0.1908,0.07),(-0.10482,-0.17805,0.07),(-0.10482,-0.17805,0),(-0.10634,-0.1908,0),(-0.10679,-0.20364,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99727,0.07382,0),(-0.98639,0.1644,0),(-0.98639,0.1644,0),(-0.99727,0.07382,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.10482,-0.17805,0.07),(-0.1026,-0.17228,0.07),(-0.09987,-0.1667,0.07),(-0.09666,-0.16139,0.07),(-0.09301,-0.15639,0.07),(-0.09301,-0.15639,0),(-0.09666,-0.16139,0),(-0.09987,-0.1667,0),(-0.1026,-0.17228,0),(-0.10482,-0.17805,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.91629,0.40051,0),(-0.87764,0.47932,0),(-0.83268,0.55376,0),(-0.78087,0.6247,0),(-0.78087,0.6247,0),(-0.83268,0.55376,0),(-0.87764,0.47932,0),(-0.91629,0.40051,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.09301,-0.15639,0.07),(-0.08855,-0.15235,0.07),(-0.08373,-0.14872,0.07),(-0.07863,-0.14548,0.07),(-0.07332,-0.14261,0.07),(-0.07332,-0.14261,0),(-0.07863,-0.14548,0),(-0.08373,-0.14872,0),(-0.08855,-0.15235,0),(-0.09301,-0.15639,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.63569,0.77194,0),(-0.56791,0.82309,0),(-0.50497,0.86314,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.50497,0.86314,0),(-0.56791,0.82309,0),(-0.63569,0.77194,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,7,-1,8,9,3,-1,10,2,9,-1,3,4,7,-1,7,4,6,-1,6,4,5,-1],solid=False,
          coord=Coordinate(point=[(-0.07332,-0.14261,0.07),(-0.07011,-0.14115,0.07),(-0.06679,-0.13992,0.07),(-0.05991,-0.13808,0.07),(-0.05285,-0.13704,0.07),(-0.04576,-0.13671,0.07),(-0.04576,-0.13671,0),(-0.05285,-0.13704,0),(-0.05991,-0.13808,0),(-0.06679,-0.13992,0),(-0.07011,-0.14115,0),(-0.07332,-0.14261,0.0)]),
          normal=Normal(vector=[(-0.44721,0.89443,0),(-0.38082,0.92465,0),(-0.31727,0.94834,0),(-0.19979,0.97984,0),(-0.09477,0.9955,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.09477,0.9955,0),(-0.19979,0.97984,0),(-0.31727,0.94834,0),(-0.38082,0.92465,0),(-0.44721,0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(-0.04576,-0.13671,0.07),(-0.03912,-0.137,0.07),(-0.0325,-0.13797,0.07),(-0.02926,-0.13876,0.07),(-0.0261,-0.13979,0.07),(-0.02306,-0.14107,0.07),(-0.02017,-0.14261,0.07),(-0.02017,-0.14261,0),(-0.02306,-0.14107,0),(-0.0261,-0.13979,0),(-0.02926,-0.13876,0),(-0.0325,-0.13797,0),(-0.03912,-0.137,0),(-0.04576,-0.13671,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.09039,0.99591,-0.0),(0.20481,0.9788,-0.0),(0.27236,0.9622,-0.0),(0.34699,0.93787,-0.0),(0.42819,0.90369,-0.0),(0.5145,0.85749,-0.0),(0.5145,0.85749,-0.0),(0.42819,0.90369,-0.0),(0.34699,0.93787,-0.0),(0.27236,0.9622,-0.0),(0.20481,0.9788,-0.0),(0.09039,0.99591,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(-0.02017,-0.14261,0.07),(-0.01466,-0.14574,0.07),(-0.00947,-0.14944,0.07),(-0.00471,-0.15366,0.07),(-4.8E-4,-0.15836,0.07),(-4.8E-4,-0.15836,0),(-0.00471,-0.15366,0),(-0.00947,-0.14944,0),(-0.01466,-0.14574,0),(-0.02017,-0.14261,0.0)]),
          normal=Normal(vector=[(0.44721,0.89443,-0.0),(0.53764,0.84317,-0.0),(0.62277,0.78241,-0.0),(0.7038,0.7104,-0.0),(0.78087,0.6247,-0.0),(0.78087,0.6247,-0.0),(0.7038,0.7104,-0.0),(0.62277,0.78241,-0.0),(0.53764,0.84317,-0.0),(0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[67,0,130,-1,131,67,130,-1,131,66,67,-1,131,65,66,-1,131,132,65,-1,65,132,64,-1,64,132,63,-1,63,132,133,-1,62,133,61,-1,62,63,133,-1,2,129,1,-1,2,3,129,-1,129,3,128,-1,128,3,4,-1,5,128,4,-1,5,127,128,-1,5,6,127,-1,127,6,126,-1,126,6,7,-1,125,7,124,-1,125,126,7,-1,7,8,124,-1,124,8,123,-1,123,8,122,-1,122,8,9,-1,121,9,120,-1,121,122,9,-1,10,114,9,-1,10,11,114,-1,114,11,12,-1,13,114,12,-1,13,14,114,-1,114,14,15,-1,113,15,16,-1,112,16,111,-1,112,113,16,-1,114,15,113,-1,111,16,110,-1,110,16,17,-1,109,17,108,-1,109,110,17,-1,17,18,108,-1,108,18,107,-1,107,18,106,-1,106,18,19,-1,20,106,19,-1,20,105,106,-1,20,21,105,-1,105,21,104,-1,104,21,103,-1,103,21,22,-1,102,22,101,-1,102,103,22,-1,22,23,101,-1,101,23,100,-1,100,23,24,-1,99,24,25,-1,26,99,25,-1,26,98,99,-1,26,27,98,-1,98,27,97,-1,97,27,28,-1,29,97,28,-1,29,96,97,-1,29,30,96,-1,96,30,95,-1,95,30,94,-1,94,30,31,-1,32,94,31,-1,32,93,94,-1,32,33,93,-1,93,33,92,-1,92,33,34,-1,91,34,35,-1,36,91,35,-1,36,90,91,-1,36,37,90,-1,90,37,89,-1,89,37,38,-1,88,38,39,-1,87,39,40,-1,86,40,41,-1,85,41,42,-1,84,42,83,-1,84,85,42,-1,100,24,99,-1,92,34,91,-1,89,38,88,-1,88,39,87,-1,87,40,86,-1,86,41,85,-1,42,43,83,-1,83,43,82,-1,82,43,81,-1,81,43,80,-1,80,43,44,-1,79,44,45,-1,46,79,45,-1,46,47,79,-1,79,47,48,-1,49,79,48,-1,49,50,79,-1,79,50,78,-1,78,50,77,-1,77,50,76,-1,76,50,75,-1,75,50,74,-1,74,50,73,-1,73,50,72,-1,72,50,71,-1,71,50,70,-1,70,50,69,-1,69,50,68,-1,68,50,51,-1,52,68,51,-1,52,137,68,-1,52,53,137,-1,137,53,54,-1,136,54,55,-1,56,136,55,-1,56,57,136,-1,136,57,135,-1,135,57,58,-1,134,58,59,-1,60,134,59,-1,60,133,134,-1,60,61,133,-1,80,44,79,-1,137,54,136,-1,135,58,134,-1,114,115,9,-1,9,115,116,-1,117,9,116,-1,117,118,9,-1,9,118,119,-1,120,9,119,-1,129,130,1,-1,1,130,0,-1],solid=False,
          coord=Coordinate(point=[(0.01133,-0.17805,0.07),(0.00923,-0.17267,0.07),(0.00655,-0.16751,0.07),(0.00331,-0.1627,0.07),(0.00148,-0.16046,0.07),(-4.8E-4,-0.15836,0.07),(-0.00471,-0.15366,0.07),(-0.00947,-0.14944,0.07),(-0.01466,-0.14574,0.07),(-0.02017,-0.14261,0.07),(-0.02306,-0.14107,0.07),(-0.0261,-0.13979,0.07),(-0.02926,-0.13876,0.07),(-0.0325,-0.13797,0.07),(-0.03912,-0.137,0.07),(-0.04576,-0.13671,0.07),(-0.05285,-0.13704,0.07),(-0.05991,-0.13808,0.07),(-0.06679,-0.13992,0.07),(-0.07011,-0.14115,0.07),(-0.07332,-0.14261,0.07),(-0.07863,-0.14548,0.07),(-0.08373,-0.14872,0.07),(-0.08855,-0.15235,0.07),(-0.09301,-0.15639,0.07),(-0.09666,-0.16139,0.07),(-0.09987,-0.1667,0.07),(-0.1026,-0.17228,0.07),(-0.10482,-0.17805,0.07),(-0.10634,-0.1908,0.07),(-0.10679,-0.20364,0.07),(-0.10634,-0.21648,0.07),(-0.10482,-0.22924,0.07),(-0.1026,-0.23501,0.07),(-0.09987,-0.24058,0.07),(-0.09666,-0.2459,0.07),(-0.09301,-0.25089,0.07),(-0.08855,-0.25493,0.07),(-0.08373,-0.25857,0.07),(-0.07863,-0.26181,0.07),(-0.07332,-0.26467,0.07),(-0.06708,-0.26644,0.07),(-0.06069,-0.26767,0.07),(-0.05422,-0.26838,0.07),(-0.04773,-0.26861,0.07),(-0.04124,-0.26838,0.07),(-0.03477,-0.26767,0.07),(-0.02838,-0.26644,0.07),(-0.02214,-0.26467,0.07),(-0.01676,-0.26257,0.07),(-0.0116,-0.25989,0.07),(-0.00679,-0.25665,0.07),(-0.00455,-0.25482,0.07),(-0.00245,-0.25286,0.07),(-3.6E-4,-0.25059,0.07),(0.00153,-0.24814,0.07),(0.00325,-0.24554,0.07),(0.00479,-0.24282,0.07),(0.00738,-0.23711,0.07),(0.00936,-0.23121,0.07),(0.01082,-0.22799,0.07),(0.01206,-0.22468,0.07),(0.01389,-0.2178,0.07),(0.01494,-0.21073,0.07),(0.01527,-0.20364,0.07),(0.01504,-0.19715,0.07),(0.01432,-0.19068,0.07),(0.0131,-0.18429,0.07),(-0.02017,-0.24499,0.07),(-0.02135,-0.24652,0.07),(-0.02264,-0.24798,0.07),(-0.02405,-0.24936,0.07),(-0.02555,-0.25067,0.07),(-0.0288,-0.25302,0.07),(-0.03234,-0.25501,0.07),(-0.03607,-0.25661,0.07),(-0.03993,-0.25779,0.07),(-0.04384,-0.25852,0.07),(-0.04579,-0.25871,0.07),(-0.04773,-0.25877,0.07),(-0.04955,-0.2587,0.07),(-0.05138,-0.2585,0.07),(-0.05321,-0.25817,0.07),(-0.05502,-0.25772,0.07),(-0.0586,-0.25649,0.07),(-0.06205,-0.25483,0.07),(-0.06531,-0.25281,0.07),(-0.06831,-0.25047,0.07),(-0.071,-0.24784,0.07),(-0.07332,-0.24499,0.07),(-0.07546,-0.24018,0.07),(-0.0772,-0.23521,0.07),(-0.07857,-0.23009,0.07),(-0.07961,-0.22487,0.07),(-0.08085,-0.21426,0.07),(-0.0812,-0.20364,0.07),(-0.08095,-0.19298,0.07),(-0.07987,-0.18228,0.07),(-0.07887,-0.17704,0.07),(-0.07749,-0.17193,0.07),(-0.07566,-0.167,0.07),(-0.07332,-0.1623,0.07),(-0.07221,-0.16064,0.07),(-0.07096,-0.15905,0.07),(-0.0696,-0.15751,0.07),(-0.06814,-0.15605,0.07),(-0.06493,-0.15337,0.07),(-0.06141,-0.15106,0.07),(-0.05765,-0.14917,0.07),(-0.05571,-0.1484,0.07),(-0.05374,-0.14775,0.07),(-0.05175,-0.14723,0.07),(-0.04975,-0.14686,0.07),(-0.04775,-0.14663,0.07),(-0.04576,-0.14655,0.07),(-0.04388,-0.14663,0.07),(-0.042,-0.14688,0.07),(-0.04013,-0.14728,0.07),(-0.03828,-0.14782,0.07),(-0.03646,-0.14849,0.07),(-0.03466,-0.14929,0.07),(-0.0312,-0.15124,0.07),(-0.02796,-0.15358,0.07),(-0.025,-0.15626,0.07),(-0.02238,-0.15918,0.07),(-0.02017,-0.1623,0.07),(-0.0187,-0.16451,0.07),(-0.01738,-0.16681,0.07),(-0.01516,-0.17163,0.07),(-0.01343,-0.17671,0.07),(-0.01216,-0.18198,0.07),(-0.0107,-0.19283,0.07),(-0.01032,-0.20364,0.07),(-0.01081,-0.21439,0.07),(-0.01243,-0.22512,0.07),(-0.01375,-0.23036,0.07),(-0.01546,-0.23545,0.07),(-0.01759,-0.24034,0.07)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.18261,-0.30602,0.07),(0.17759,-0.30575,0.07),(0.17259,-0.30498,0.07),(0.16768,-0.30375,0.07),(0.16293,-0.30208,0.07),(0.16293,-0.30208,0),(0.16768,-0.30375,0),(0.17259,-0.30498,0),(0.17759,-0.30575,0),(0.18261,-0.30602,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.10395,-0.99458,0),(-0.19952,-0.97989,0),(-0.28811,-0.9576,0),(-0.37139,-0.92848,0),(-0.37139,-0.92848,0),(-0.28811,-0.9576,0),(-0.19952,-0.97989,0),(-0.10395,-0.99458,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.16293,-0.30208,0.07),(0.16081,-0.30148,0.07),(0.15872,-0.30075,0.07),(0.15468,-0.29893,0.07),(0.15082,-0.29672,0.07),(0.14718,-0.29421,0.07),(0.14718,-0.29421,0),(0.15082,-0.29672,0),(0.15468,-0.29893,0),(0.15872,-0.30075,0),(0.16081,-0.30148,0),(0.16293,-0.30208,0.0)]),
          normal=Normal(vector=[(-0.24254,-0.97014,0),(-0.30355,-0.95282,0),(-0.35921,-0.93325,0),(-0.45562,-0.89018,0),(-0.53474,-0.84502,0),(-0.6,-0.8,0),(-0.6,-0.8,0),(-0.53474,-0.84502,0),(-0.45562,-0.89018,0),(-0.35921,-0.93325,0),(-0.30355,-0.95282,0),(-0.24254,-0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.14718,-0.29421,0.07),(0.14437,-0.29213,0.07),(0.14177,-0.28977,0.07),(0.13941,-0.28717,0.07),(0.13733,-0.28436,0.07),(0.13733,-0.28436,0),(0.13941,-0.28717,0),(0.14177,-0.28977,0),(0.14437,-0.29213,0),(0.14718,-0.29421,0.0)]),
          normal=Normal(vector=[(-0.5547,-0.83205,0),(-0.63491,-0.77259,0),(-0.70711,-0.70711,0),(-0.77259,-0.63491,0),(-0.83205,-0.5547,0),(-0.83205,-0.5547,0),(-0.77259,-0.63491,0),(-0.70711,-0.70711,0),(-0.63491,-0.77259,0),(-0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.13733,-0.28436,0.07),(0.13649,-0.28148,0.07),(0.13587,-0.27853,0.07),(0.13549,-0.27555,0.07),(0.13536,-0.27255,0.07),(0.13536,-0.27255,0),(0.13549,-0.27555,0),(0.13587,-0.27853,0),(0.13649,-0.28148,0),(0.13733,-0.28436,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.97003,-0.24298,0),(-0.98605,-0.16646,0),(-0.99632,-0.08575,0),(-1.0,0,0),(-1.0,0,0),(-0.99632,-0.08575,0),(-0.98605,-0.16646,0),(-0.97003,-0.24298,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.13536,-0.27255,0.07),(0.1354,-0.27045,0.07),(0.13548,-0.26937,0.07),(0.13563,-0.26832,0.07),(0.13587,-0.26729,0.07),(0.13622,-0.26633,0.07),(0.1367,-0.26545,0.07),(0.13733,-0.26467,0.07),(0.13733,-0.26467,0),(0.1367,-0.26545,0),(0.13622,-0.26633,0),(0.13587,-0.26729,0),(0.13563,-0.26832,0),(0.13548,-0.26937,0),(0.1354,-0.27045,0),(0.13536,-0.27255,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.9988,0.04898,0),(-0.99469,0.1029,0),(-0.98386,0.17892,0),(-0.96007,0.27975,0),(-0.91369,0.40641,0),(-0.8325,0.55403,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.8325,0.55403,0),(-0.91369,0.40641,0),(-0.96007,0.27975,0),(-0.98386,0.17892,0),(-0.99469,0.1029,0),(-0.9988,0.04898,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.13733,-0.26467,0.07),(0.13783,-0.26353,0.07),(0.13854,-0.26244,0.07),(0.13941,-0.26144,0.07),(0.14043,-0.26055,0.07),(0.14155,-0.25982,0.07),(0.14274,-0.25925,0.07),(0.14397,-0.25889,0.07),(0.14521,-0.25877,0.07),(0.14521,-0.25877,0),(0.14397,-0.25889,0),(0.14274,-0.25925,0),(0.14155,-0.25982,0),(0.14043,-0.26055,0),(0.13941,-0.26144,0),(0.13854,-0.26244,0),(0.13783,-0.26353,0),(0.13733,-0.26467,0.0)]),
          normal=Normal(vector=[(-0.94868,0.31623,0),(-0.87909,0.47666,0),(-0.79679,0.60426,0),(-0.70594,0.70827,0),(-0.60561,0.79576,0),(-0.49164,0.8708,0),(-0.35756,0.93389,0),(-0.19567,0.98067,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.19567,0.98067,0),(-0.35756,0.93389,0),(-0.49164,0.8708,0),(-0.60561,0.79576,0),(-0.70594,0.70827,0),(-0.79679,0.60426,0),(-0.87909,0.47666,0),(-0.94868,0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,12,-1,13,14,8,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,8,9,12,-1,12,9,10,-1,11,12,10,-1],solid=False,
          coord=Coordinate(point=[(0.14521,-0.25877,0.07),(0.14679,-0.25882,0.07),(0.14839,-0.25897,0.07),(0.14999,-0.25924,0.07),(0.15157,-0.25964,0.07),(0.15309,-0.26017,0.07),(0.15452,-0.26085,0.07),(0.1552,-0.26125,0.07),(0.15584,-0.26169,0.07),(0.15645,-0.26218,0.07),(0.15702,-0.26271,0.07),(0.15702,-0.26271,0),(0.15645,-0.26218,0),(0.15584,-0.26169,0),(0.1552,-0.26125,0),(0.15452,-0.26085,0),(0.15309,-0.26017,0),(0.15157,-0.25964,0),(0.14999,-0.25924,0),(0.14839,-0.25897,0),(0.14679,-0.25882,0),(0.14521,-0.25877,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06217,0.99807,-0.0),(0.12928,0.99161,-0.0),(0.20336,0.9791,-0.0),(0.28619,0.95817,-0.0),(0.37907,0.92537,-0.0),(0.48214,0.87609,-0.0),(0.53698,0.84359,-0.0),(0.59334,0.80495,-0.0),(0.65041,0.75958,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.65041,0.75958,-0.0),(0.59334,0.80495,-0.0),(0.53698,0.84359,-0.0),(0.48214,0.87609,-0.0),(0.37907,0.92537,-0.0),(0.28619,0.95817,-0.0),(0.20336,0.9791,-0.0),(0.12928,0.99161,-0.0),(0.06217,0.99807,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.15702,-0.26271,0.07),(0.1578,-0.26317,0.07),(0.15853,-0.26374,0.07),(0.1592,-0.26442,0.07),(0.15978,-0.26517,0.07),(0.16027,-0.26598,0.07),(0.16064,-0.26684,0.07),(0.16087,-0.26772,0.07),(0.16096,-0.26861,0.07),(0.16096,-0.26861,0),(0.16087,-0.26772,0),(0.16064,-0.26684,0),(0.16027,-0.26598,0),(0.15978,-0.26517,0),(0.1592,-0.26442,0),(0.15853,-0.26374,0),(0.1578,-0.26317,0),(0.15702,-0.26271,0.0)]),
          normal=Normal(vector=[(0.44721,0.89443,-0.0),(0.56714,0.82362,-0.0),(0.66628,0.74571,-0.0),(0.75071,0.66063,-0.0),(0.82442,0.56598,-0.0),(0.88911,0.45769,-0.0),(0.9438,0.33052,-0.0),(0.98384,0.17902,-0.0),(1.0,0,0),(1.0,0,0),(0.98384,0.17902,-0.0),(0.9438,0.33052,-0.0),(0.88911,0.45769,-0.0),(0.82442,0.56598,-0.0),(0.75071,0.66063,-0.0),(0.66628,0.74571,-0.0),(0.56714,0.82362,-0.0),(0.44721,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.16096,-0.26861,0.07),(0.1608,-0.27112,0.07),(0.16037,-0.2736,0.07),(0.15899,-0.27846,0.07),(0.15899,-0.27846,0),(0.16037,-0.2736,0),(0.1608,-0.27112,0),(0.16096,-0.26861,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,-0.12161,0),(0.97691,-0.21363,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.97691,-0.21363,0),(0.99258,-0.12161,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.15899,-0.27846,0.07),(0.15817,-0.28033,0.07),(0.15755,-0.28229,0.07),(0.15716,-0.2843,0.07),(0.15705,-0.28532,0.07),(0.15702,-0.28633,0.07),(0.15702,-0.28633,0),(0.15705,-0.28532,0),(0.15716,-0.2843,0),(0.15755,-0.28229,0),(0.15817,-0.28033,0),(0.15899,-0.27846,0.0)]),
          normal=Normal(vector=[(0.89443,-0.44721,0),(0.93577,-0.35262,0),(0.96859,-0.24866,0),(0.99125,-0.13201,0),(0.99768,-0.06804,0),(1.0,0,0),(1.0,0,0),(0.99768,-0.06804,0),(0.99125,-0.13201,0),(0.96859,-0.24866,0),(0.93577,-0.35262,0),(0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.15702,-0.28633,0.07),(0.158,-0.28732,0.07),(0.15899,-0.2883,0.07),(0.15899,-0.2883,0),(0.158,-0.28732,0),(0.15702,-0.28633,0.0)]),
          normal=Normal(vector=[(0.70711,0.7071,-0.0),(0.70711,0.7071,-0.0),(0.70711,0.7071,-0.0),(0.70711,0.7071,-0.0),(0.70711,0.7071,-0.0),(0.70711,0.7071,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.15899,-0.2883,0.07),(0.16032,-0.28947,0.07),(0.16178,-0.2905,0.07),(0.16489,-0.29224,0.07),(0.16489,-0.29224,0),(0.16178,-0.2905,0),(0.16032,-0.28947,0),(0.15899,-0.2883,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.61587,0.78785,-0.0),(0.53972,0.84184,-0.0),(0.44721,0.89443,-0.0),(0.44721,0.89443,-0.0),(0.53972,0.84184,-0.0),(0.61587,0.78785,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.16489,-0.29224,0.07),(0.16591,-0.29227,0.07),(0.16693,-0.29237,0.07),(0.16894,-0.29277,0.07),(0.1709,-0.29339,0.07),(0.17277,-0.29421,0.07),(0.17277,-0.29421,0),(0.1709,-0.29339,0),(0.16894,-0.29277,0),(0.16693,-0.29237,0),(0.16591,-0.29227,0),(0.16489,-0.29224,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.06804,0.99768,-0.0),(0.13201,0.99125,-0.0),(0.24866,0.96859,-0.0),(0.35262,0.93577,-0.0),(0.44721,0.89443,-0.0),(0.44721,0.89443,-0.0),(0.35262,0.93577,-0.0),(0.24866,0.96859,-0.0),(0.13201,0.99125,-0.0),(0.06804,0.99768,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,8,-1,9,10,4,-1,12,2,11,-1,11,3,10,-1,4,5,8,-1,8,5,7,-1,7,5,6,-1],solid=False,
          coord=Coordinate(point=[(0.17277,-0.29421,0.07),(0.17414,-0.2948,0.07),(0.17556,-0.29527,0.07),(0.17702,-0.29561,0.07),(0.17852,-0.29586,0.07),(0.18155,-0.29612,0.07),(0.18458,-0.29618,0.07),(0.18458,-0.29618,0),(0.18155,-0.29612,0),(0.17852,-0.29586,0),(0.17702,-0.29561,0),(0.17556,-0.29527,0),(0.17414,-0.2948,0),(0.17277,-0.29421,0.0)]),
          normal=Normal(vector=[(0.44722,0.89443,-0.0),(0.35328,0.93552,-0.0),(0.26836,0.96332,-0.0),(0.19462,0.98088,-0.0),(0.13281,0.99114,-0.0),(0.04437,0.99902,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0.04437,0.99902,-0.0),(0.13281,0.99114,-0.0),(0.19462,0.98088,-0.0),(0.26836,0.96332,-0.0),(0.35328,0.93552,-0.0),(0.44722,0.89443,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,10,-1,11,12,4,-1,14,2,13,-1,13,3,12,-1,4,5,10,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.18458,-0.29618,0.07),(0.18614,-0.2961,0.07),(0.18769,-0.29588,0.07),(0.18923,-0.29554,0.07),(0.19075,-0.29507,0.07),(0.19223,-0.2945,0.07),(0.19368,-0.29382,0.07),(0.19639,-0.29224,0.07),(0.19639,-0.29224,0),(0.19368,-0.29382,0),(0.19223,-0.2945,0),(0.19075,-0.29507,0),(0.18923,-0.29554,0),(0.18769,-0.29588,0),(0.18614,-0.2961,0),(0.18458,-0.29618,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.09439,0.99554,0),(-0.18037,0.9836,0),(-0.25818,0.9661,0),(-0.32853,0.94449,0),(-0.39234,0.91982,0),(-0.45064,0.89271,0),(-0.5547,0.83205,0),(-0.5547,0.83205,0),(-0.45064,0.89271,0),(-0.39234,0.91982,0),(-0.32853,0.94449,0),(-0.25818,0.9661,0),(-0.18037,0.9836,0),(-0.09439,0.99554,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,9,-1,10,11,3,-1,12,2,11,-1,3,4,9,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.19639,-0.29224,0.07),(0.1996,-0.2913,0.07),(0.20274,-0.29005,0.07),(0.20423,-0.28929,0.07),(0.20565,-0.28842,0.07),(0.20698,-0.28743,0.07),(0.20821,-0.28633,0.07),(0.20821,-0.28633,0),(0.20698,-0.28743,0),(0.20565,-0.28842,0),(0.20423,-0.28929,0),(0.20274,-0.29005,0),(0.1996,-0.2913,0),(0.19639,-0.29224,0.0)]),
          normal=Normal(vector=[(-0.24253,0.97014,0),(-0.32084,0.94713,0),(-0.42529,0.90506,0),(-0.48778,0.87296,0),(-0.55663,0.83076,0),(-0.63055,0.77615,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.63055,0.77615,0),(-0.55663,0.83076,0),(-0.48778,0.87296,0),(-0.42529,0.90506,0),(-0.32084,0.94713,0),(-0.24253,0.97014,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,12,-1,13,14,4,-1,16,2,15,-1,15,3,14,-1,4,5,12,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.20821,-0.28633,0.07),(0.20957,-0.28488,0.07),(0.21084,-0.28332,0.07),(0.212,-0.28168,0.07),(0.21307,-0.27996,0.07),(0.21401,-0.27818,0.07),(0.21484,-0.27634,0.07),(0.21553,-0.27446,0.07),(0.21608,-0.27255,0.07),(0.21608,-0.27255,0),(0.21553,-0.27446,0),(0.21484,-0.27634,0),(0.21401,-0.27818,0),(0.21307,-0.27996,0),(0.212,-0.28168,0),(0.21084,-0.28332,0),(0.20957,-0.28488,0),(0.20821,-0.28633,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.7533,0.65768,0),(-0.79509,0.60649,0),(-0.83298,0.5533,0),(-0.86731,0.49776,0),(-0.89827,0.43945,0),(-0.92587,0.37783,0),(-0.94996,0.31238,0),(-0.97014,0.24253,0),(-0.97014,0.24253,0),(-0.94996,0.31238,0),(-0.92587,0.37783,0),(-0.89827,0.43945,0),(-0.86731,0.49776,0),(-0.83298,0.5533,0),(-0.79509,0.60649,0),(-0.7533,0.65768,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,12,-1,13,14,2,-1,2,3,12,-1,12,3,11,-1,11,3,4,-1,5,11,4,-1,5,10,11,-1,5,6,10,-1,10,6,9,-1,9,6,7,-1,8,9,7,-1],solid=False,
          coord=Coordinate(point=[(0.21608,-0.27255,0.07),(0.21711,-0.2708,0.07),(0.21796,-0.26895,0.07),(0.21865,-0.26701,0.07),(0.21918,-0.26502,0.07),(0.21957,-0.26297,0.07),(0.21983,-0.26091,0.07),(0.22002,-0.2568,0.07),(0.22002,-0.2568,0),(0.21983,-0.26091,0),(0.21957,-0.26297,0),(0.21918,-0.26502,0),(0.21865,-0.26701,0),(0.21796,-0.26895,0),(0.21711,-0.2708,0),(0.21608,-0.27255,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,0),(-0.88703,0.46172,0),(-0.92748,0.37386,0),(-0.95608,0.29311,0),(-0.97545,0.22022,0),(-0.9879,0.1551,0),(-0.99526,0.0972,0),(-1.0,0,0),(-1.0,0,0),(-0.99526,0.0972,0),(-0.9879,0.1551,0),(-0.97545,0.22022,0),(-0.95608,0.29311,0),(-0.92748,0.37386,0),(-0.88703,0.46172,0),(-0.83205,0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[9,0,8,-1,8,0,1,-1,7,1,2,-1,3,7,2,-1,3,6,7,-1,3,4,6,-1,6,4,5,-1,8,1,7,-1],solid=False,
          coord=Coordinate(point=[(0.22002,-0.2568,0.07),(0.21989,-0.2538,0.07),(0.21951,-0.25082,0.07),(0.21889,-0.24787,0.07),(0.21805,-0.24499,0.07),(0.21805,-0.24499,0),(0.21889,-0.24787,0),(0.21951,-0.25082,0),(0.21989,-0.2538,0),(0.22002,-0.2568,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99632,-0.08575,0),(-0.98605,-0.16647,0),(-0.97003,-0.24298,0),(-0.94868,-0.31623,0),(-0.94868,-0.31623,0),(-0.97003,-0.24298,0),(-0.98605,-0.16647,0),(-0.99632,-0.08575,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.21805,-0.24499,0.07),(0.21688,-0.24189,0.07),(0.21549,-0.23889,0.07),(0.21214,-0.23317,0.07),(0.21214,-0.23317,0),(0.21549,-0.23889,0),(0.21688,-0.24189,0),(0.21805,-0.24499,0.0)]),
          normal=Normal(vector=[(-0.94868,-0.31623,0),(-0.92164,-0.38803,0),(-0.89248,-0.45108,0),(-0.83205,-0.5547,0),(-0.83205,-0.5547,0),(-0.89248,-0.45108,0),(-0.92164,-0.38803,0),(-0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.21214,-0.23317,0.07),(0.21151,-0.23212,0.07),(0.21073,-0.23116,0.07),(0.20983,-0.23029,0.07),(0.20882,-0.22951,0.07),(0.20774,-0.22882,0.07),(0.20661,-0.22822,0.07),(0.20544,-0.2277,0.07),(0.20427,-0.22727,0.07),(0.20427,-0.22727,0),(0.20544,-0.2277,0),(0.20661,-0.22822,0),(0.20774,-0.22882,0),(0.20882,-0.22951,0),(0.20983,-0.23029,0),(0.21073,-0.23116,0),(0.21151,-0.23212,0),(0.21214,-0.23317,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.81744,-0.57601,0),(-0.73445,-0.67867,0),(-0.65224,-0.75801,0),(-0.57451,-0.8185,0),(-0.50255,-0.86455,0),(-0.43622,-0.89984,0),(-0.37459,-0.92719,0),(-0.31623,-0.94868,0),(-0.31623,-0.94868,0),(-0.37459,-0.92719,0),(-0.43622,-0.89984,0),(-0.50255,-0.86455,0),(-0.57451,-0.8185,0),(-0.65224,-0.75801,0),(-0.73445,-0.67867,0),(-0.81744,-0.57601,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,11,-1,12,13,3,-1,14,2,13,-1,3,4,11,-1,11,4,5,-1,10,5,9,-1,10,11,5,-1,5,6,9,-1,9,6,7,-1,8,9,7,-1],solid=False,
          coord=Coordinate(point=[(0.20427,-0.22727,0.07),(0.20252,-0.22624,0.07),(0.20067,-0.22539,0.07),(0.19873,-0.2247,0.07),(0.19674,-0.22417,0.07),(0.19469,-0.22379,0.07),(0.19263,-0.22352,0.07),(0.18852,-0.22333,0.07),(0.18852,-0.22333,0),(0.19263,-0.22352,0),(0.19469,-0.22379,0),(0.19674,-0.22417,0),(0.19873,-0.2247,0),(0.20067,-0.22539,0),(0.20252,-0.22624,0),(0.20427,-0.22727,0.0)]),
          normal=Normal(vector=[(-0.5547,-0.83205,0),(-0.46172,-0.88703,0),(-0.37386,-0.92748,0),(-0.29311,-0.95608,0),(-0.22022,-0.97545,0),(-0.15509,-0.9879,0),(-0.0972,-0.99526,0),(0,-1.0,0),(0,-1.0,0),(-0.0972,-0.99526,0),(-0.15509,-0.9879,0),(-0.22022,-0.97545,0),(-0.29311,-0.95608,0),(-0.37386,-0.92748,0),(-0.46172,-0.88703,0),(-0.5547,-0.83205,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.18852,-0.22333,0.07),(0.17474,-0.22333,0.07),(0.17474,-0.22333,0),(0.18852,-0.22333,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0,-1.0,0),(0,-1.0,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.17474,-0.22333,0.07),(0.17474,-0.20955,0.07),(0.17474,-0.20955,0),(0.17474,-0.22333,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.17474,-0.20955,0.07),(0.18458,-0.20955,0.07),(0.18458,-0.20955,0),(0.17474,-0.20955,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,1.0,0),(0,1.0,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,10,-1,11,12,8,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,8,9,10,-1],solid=False,
          coord=Coordinate(point=[(0.18458,-0.20955,0.07),(0.1875,-0.20943,0.07),(0.19044,-0.20908,0.07),(0.19338,-0.20849,0.07),(0.19625,-0.20765,0.07),(0.19902,-0.20655,0.07),(0.20164,-0.2052,0.07),(0.20406,-0.20357,0.07),(0.20518,-0.20266,0.07),(0.20624,-0.20167,0.07),(0.20624,-0.20167,0),(0.20518,-0.20266,0),(0.20406,-0.20357,0),(0.20164,-0.2052,0),(0.19902,-0.20655,0),(0.19625,-0.20765,0),(0.19338,-0.20849,0),(0.19044,-0.20908,0),(0.1875,-0.20943,0),(0.18458,-0.20955,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(-0.07881,0.99689,0),(-0.15769,0.98749,0),(-0.23864,0.97111,0),(-0.32332,0.94629,0),(-0.41289,0.91078,0),(-0.50772,0.86152,0),(-0.6068,0.79485,0),(-0.65709,0.75381,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.65709,0.75381,0),(-0.6068,0.79485,0),(-0.50772,0.86152,0),(-0.41289,0.91078,0),(-0.32332,0.94629,0),(-0.23864,0.97111,0),(-0.15769,0.98749,0),(-0.07881,0.99689,0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,19,-1,19,1,18,-1,18,1,2,-1,17,2,3,-1,16,3,4,-1,15,4,5,-1,14,5,6,-1,13,6,7,-1,12,7,8,-1,11,8,9,-1,10,11,9,-1,18,2,17,-1,17,3,16,-1,16,4,15,-1,15,5,14,-1,14,6,13,-1,13,7,12,-1,12,8,11,-1],solid=False,
          coord=Coordinate(point=[(0.20624,-0.20167,0.07),(0.20737,-0.20045,0.07),(0.20839,-0.19913,0.07),(0.20931,-0.19773,0.07),(0.21013,-0.19627,0.07),(0.2115,-0.19316,0.07),(0.21254,-0.18986,0.07),(0.21329,-0.18644,0.07),(0.21377,-0.18296,0.07),(0.21411,-0.17608,0.07),(0.21411,-0.17608,0),(0.21377,-0.18296,0),(0.21329,-0.18644,0),(0.21254,-0.18986,0),(0.2115,-0.19316,0),(0.21013,-0.19627,0),(0.20931,-0.19773,0),(0.20839,-0.19913,0),(0.20737,-0.20045,0),(0.20624,-0.20167,0.0)]),
          normal=Normal(vector=[(-0.70711,0.70711,0),(-0.76448,0.64464,0),(-0.81347,0.5816,0),(-0.85444,0.51955,0),(-0.88809,0.45968,0),(-0.93695,0.34946,0),(-0.96722,0.25394,0),(-0.98493,0.17294,0),(-0.99448,0.10489,0),(-1.0,0,0),(-1.0,0,0),(-0.99448,0.10489,0),(-0.98493,0.17294,0),(-0.96722,0.25394,0),(-0.93695,0.34946,0),(-0.88809,0.45968,0),(-0.85444,0.51955,0),(-0.81347,0.5816,0),(-0.76448,0.64464,0),(-0.70711,0.70711,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[19,0,18,-1,18,0,1,-1,17,1,2,-1,16,2,3,-1,15,3,4,-1,14,4,5,-1,6,14,5,-1,6,13,14,-1,6,12,13,-1,6,7,12,-1,12,7,11,-1,11,7,8,-1,10,8,9,-1,10,11,8,-1,18,1,17,-1,17,2,16,-1,16,3,15,-1,15,4,14,-1],solid=False,
          coord=Coordinate(point=[(0.21411,-0.17608,0.07),(0.214,-0.17317,0.07),(0.21365,-0.17022,0.07),(0.21305,-0.16729,0.07),(0.21221,-0.16441,0.07),(0.21112,-0.16164,0.07),(0.20976,-0.15902,0.07),(0.20814,-0.1566,0.07),(0.20722,-0.15548,0.07),(0.20624,-0.15442,0.07),(0.20624,-0.15442,0),(0.20722,-0.15548,0),(0.20814,-0.1566,0),(0.20976,-0.15902,0),(0.21112,-0.16164,0),(0.21221,-0.16441,0),(0.21305,-0.16729,0),(0.21365,-0.17022,0),(0.214,-0.17317,0),(0.21411,-0.17608,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99689,-0.07881,0),(-0.98749,-0.15769,0),(-0.97111,-0.23864,0),(-0.94629,-0.32332,0),(-0.91078,-0.41289,0),(-0.86152,-0.50772,0),(-0.79485,-0.6068,0),(-0.75381,-0.65709,0),(-0.70711,-0.70711,0),(-0.70711,-0.70711,0),(-0.75381,-0.65709,0),(-0.79485,-0.6068,0),(-0.86152,-0.50772,0),(-0.91078,-0.41289,0),(-0.94629,-0.32332,0),(-0.97111,-0.23864,0),(-0.98749,-0.15769,0),(-0.99689,-0.07881,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,18,-1,19,20,4,-1,22,2,21,-1,21,3,20,-1,4,5,18,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.20624,-0.15442,0.07),(0.2054,-0.1534,0.07),(0.20446,-0.15246,0.07),(0.20345,-0.1516,0.07),(0.20237,-0.15081,0.07),(0.20122,-0.15009,0.07),(0.20001,-0.14945,0.07),(0.19746,-0.14837,0.07),(0.19477,-0.14755,0.07),(0.19201,-0.14699,0.07),(0.18925,-0.14666,0.07),(0.18655,-0.14655,0.07),(0.18655,-0.14655,0),(0.18925,-0.14666,0),(0.19201,-0.14699,0),(0.19477,-0.14755,0),(0.19746,-0.14837,0),(0.20001,-0.14945,0),(0.20122,-0.15009,0),(0.20237,-0.15081,0),(0.20345,-0.1516,0),(0.20446,-0.15246,0),(0.2054,-0.1534,0),(0.20624,-0.15442,0.0)]),
          normal=Normal(vector=[(-0.8,-0.6,0),(-0.74119,-0.6713,0),(-0.68011,-0.73311,0),(-0.61857,-0.78573,0),(-0.55796,-0.82987,0),(-0.49922,-0.86648,0),(-0.44292,-0.89656,0),(-0.33848,-0.94098,0),(-0.2444,-0.96968,0),(-0.15863,-0.98734,0),(-0.07829,-0.99693,0),(0,-1.0,0),(0,-1.0,0),(-0.07829,-0.99693,0),(-0.15863,-0.98734,0),(-0.2444,-0.96968,0),(-0.33848,-0.94098,0),(-0.44292,-0.89656,0),(-0.49922,-0.86648,0),(-0.55796,-0.82987,0),(-0.61857,-0.78573,0),(-0.68011,-0.73311,0),(-0.74119,-0.6713,0),(-0.8,-0.6,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,7,-1,8,9,5,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,5,6,7,-1],solid=False,
          coord=Coordinate(point=[(0.18655,-0.14655,0.07),(0.18402,-0.14665,0.07),(0.1815,-0.14697,0.07),(0.18025,-0.14724,0.07),(0.17904,-0.14758,0.07),(0.17785,-0.148,0.07),(0.17671,-0.14852,0.07),(0.17671,-0.14852,0),(0.17785,-0.148,0),(0.17904,-0.14758,0),(0.18025,-0.14724,0),(0.1815,-0.14697,0),(0.18402,-0.14665,0),(0.18655,-0.14655,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(0.07973,-0.99682,0),(0.17989,-0.98369,0),(0.23845,-0.97116,0),(0.3028,-0.95305,0),(0.37265,-0.92797,0),(0.44721,-0.89443,0),(0.44721,-0.89443,0),(0.37265,-0.92797,0),(0.3028,-0.95305,0),(0.23845,-0.97116,0),(0.17989,-0.98369,0),(0.07973,-0.99682,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.17671,-0.14852,0.07),(0.17359,-0.15026,0.07),(0.17213,-0.15128,0.07),(0.1708,-0.15246,0.07),(0.1708,-0.15246,0),(0.17213,-0.15128,0),(0.17359,-0.15026,0),(0.17671,-0.14852,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.53972,-0.84184,0),(0.61587,-0.78785,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.61587,-0.78785,0),(0.53972,-0.84184,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.1708,-0.15246,0.07),(0.16768,-0.15419,0.07),(0.16623,-0.15522,0.07),(0.16489,-0.15639,0.07),(0.16489,-0.15639,0),(0.16623,-0.15522,0),(0.16768,-0.15419,0),(0.1708,-0.15246,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.53972,-0.84184,0),(0.61586,-0.78785,0),(0.7071,-0.70711,0),(0.7071,-0.70711,0),(0.61586,-0.78785,0),(0.53972,-0.84184,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.16489,-0.15639,0.07),(0.16391,-0.15738,0.07),(0.16293,-0.15836,0.07),(0.16293,-0.15836,0),(0.16391,-0.15738,0),(0.16489,-0.15639,0.0)]),
          normal=Normal(vector=[(0.70711,-0.7071,0),(0.70711,-0.7071,0),(0.70711,-0.7071,0),(0.70711,-0.7071,0),(0.70711,-0.7071,0),(0.70711,-0.7071,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1,6,1,5,-1],solid=False,
          coord=Coordinate(point=[(0.16293,-0.15836,0.07),(0.16308,-0.16087,0.07),(0.16351,-0.16335,0.07),(0.16489,-0.16821,0.07),(0.16489,-0.16821,0),(0.16351,-0.16335,0),(0.16308,-0.16087,0),(0.16293,-0.15836,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,0.12161,-0.0),(0.97691,0.21363,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.97691,0.21363,-0.0),(0.99258,0.12161,-0.0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.16489,-0.16821,0.07),(0.16541,-0.16935,0.07),(0.16583,-0.17054,0.07),(0.16618,-0.17175,0.07),(0.16644,-0.173,0.07),(0.16677,-0.17552,0.07),(0.16686,-0.17805,0.07),(0.16686,-0.17805,0),(0.16677,-0.17552,0),(0.16644,-0.173,0),(0.16618,-0.17175,0),(0.16583,-0.17054,0),(0.16541,-0.16935,0),(0.16489,-0.16821,0.0)]),
          normal=Normal(vector=[(0.89443,0.44721,-0.0),(0.92797,0.37265,-0.0),(0.95305,0.3028,-0.0),(0.97116,0.23845,-0.0),(0.98369,0.17989,-0.0),(0.99682,0.07973,-0.0),(1.0,0,0),(1.0,0,0),(0.99682,0.07973,-0.0),(0.98369,0.17989,-0.0),(0.97116,0.23845,-0.0),(0.95305,0.3028,-0.0),(0.92797,0.37265,-0.0),(0.89443,0.44721,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.16686,-0.17805,0.07),(0.16678,-0.17915,0.07),(0.16654,-0.18023,0.07),(0.16616,-0.18128,0.07),(0.16567,-0.18231,0.07),(0.16508,-0.1833,0.07),(0.16442,-0.18423,0.07),(0.16369,-0.18511,0.07),(0.16293,-0.18592,0.07),(0.16293,-0.18592,0),(0.16369,-0.18511,0),(0.16442,-0.18423,0),(0.16508,-0.1833,0),(0.16567,-0.18231,0),(0.16616,-0.18128,0),(0.16654,-0.18023,0),(0.16678,-0.17915,0),(0.16686,-0.17805,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.98874,-0.14963,0),(0.96042,-0.27856,0),(0.92238,-0.38629,0),(0.8799,-0.47516,0),(0.83613,-0.54853,0),(0.79259,-0.60975,0),(0.7497,-0.66178,0),(0.70711,-0.70711,0),(0.70711,-0.70711,0),(0.7497,-0.66178,0),(0.79259,-0.60975,0),(0.83613,-0.54853,0),(0.8799,-0.47516,0),(0.92238,-0.38629,0),(0.96042,-0.27856,0),(0.98874,-0.14963,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.16293,-0.18592,0.07),(0.16156,-0.18652,0.07),(0.16014,-0.18699,0.07),(0.15867,-0.18733,0.07),(0.15718,-0.18758,0.07),(0.15414,-0.18784,0.07),(0.15111,-0.18789,0.07),(0.15111,-0.18789,0),(0.15414,-0.18784,0),(0.15718,-0.18758,0),(0.15867,-0.18733,0),(0.16014,-0.18699,0),(0.16156,-0.18652,0),(0.16293,-0.18592,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.35328,-0.93552,0),(0.26836,-0.96332,0),(0.19461,-0.98088,0),(0.13281,-0.99114,0),(0.04437,-0.99902,0),(0,-1.0,0),(0,-1.0,0),(0.04437,-0.99902,0),(0.13281,-0.99114,0),(0.19461,-0.98088,0),(0.26836,-0.96332,0),(0.35328,-0.93552,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.15111,-0.18789,0.07),(0.14999,-0.18783,0.07),(0.14883,-0.18765,0.07),(0.14768,-0.18734,0.07),(0.14657,-0.18691,0.07),(0.14553,-0.18636,0.07),(0.14461,-0.18568,0.07),(0.14383,-0.18488,0.07),(0.14324,-0.18396,0.07),(0.14324,-0.18396,0),(0.14383,-0.18488,0),(0.14461,-0.18568,0),(0.14553,-0.18636,0),(0.14657,-0.18691,0),(0.14768,-0.18734,0),(0.14883,-0.18765,0),(0.14999,-0.18783,0),(0.15111,-0.18789,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0),(-0.10658,-0.9943,0),(-0.20754,-0.97823,0),(-0.30884,-0.95111,0),(-0.41521,-0.90972,0),(-0.52987,-0.84808,0),(-0.65321,-0.75717,0),(-0.77974,-0.6261,0),(-0.89443,-0.44721,0),(-0.89443,-0.44721,0),(-0.77974,-0.6261,0),(-0.65321,-0.75717,0),(-0.52987,-0.84808,0),(-0.41521,-0.90972,0),(-0.30884,-0.95111,0),(-0.20754,-0.97823,0),(-0.10658,-0.9943,0),(0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.14324,-0.18396,0.07),(0.14272,-0.18281,0.07),(0.1423,-0.18163,0.07),(0.14196,-0.18041,0.07),(0.14169,-0.17917,0.07),(0.14137,-0.17664,0.07),(0.14127,-0.17411,0.07),(0.14127,-0.17411,0),(0.14137,-0.17664,0),(0.14169,-0.17917,0),(0.14196,-0.18041,0),(0.1423,-0.18163,0),(0.14272,-0.18281,0),(0.14324,-0.18396,0.0)]),
          normal=Normal(vector=[(-0.89443,-0.44721,0),(-0.92797,-0.37265,0),(-0.95305,-0.3028,0),(-0.97116,-0.23845,0),(-0.98369,-0.17989,0),(-0.99682,-0.07973,0),(-1.0,0,0),(-1.0,0,0),(-0.99682,-0.07973,0),(-0.98369,-0.17989,0),(-0.97116,-0.23845,0),(-0.95305,-0.3028,0),(-0.92797,-0.37265,0),(-0.89443,-0.44721,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.14127,-0.17411,0.07),(0.1414,-0.17112,0.07),(0.14178,-0.16813,0.07),(0.1424,-0.16518,0.07),(0.14324,-0.1623,0.07),(0.14324,-0.1623,0),(0.1424,-0.16518,0),(0.14178,-0.16813,0),(0.1414,-0.17112,0),(0.14127,-0.17411,0.0)]),
          normal=Normal(vector=[(-1.0,0,0),(-0.99632,0.08575,0),(-0.98605,0.16647,0),(-0.97003,0.24298,0),(-0.94868,0.31623,0),(-0.94868,0.31623,0),(-0.97003,0.24298,0),(-0.98605,0.16647,0),(-0.99632,0.08575,0),(-1.0,0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.14324,-0.1623,0.07),(0.14787,-0.15615,0.07),(0.15308,-0.15049,0.07),(0.15308,-0.15049,0),(0.14787,-0.15615,0),(0.14324,-0.1623,0.0)]),
          normal=Normal(vector=[(-0.83205,0.5547,0),(-0.76566,0.64324,0),(-0.70711,0.70711,0),(-0.70711,0.70711,0),(-0.76566,0.64324,0),(-0.83205,0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.15308,-0.15049,0.07),(0.16074,-0.14521,0.07),(0.16883,-0.14064,0.07),(0.16883,-0.14064,0),(0.16074,-0.14521,0),(0.15308,-0.15049,0.0)]),
          normal=Normal(vector=[(-0.6,0.8,0),(-0.53212,0.84667,0),(-0.44721,0.89443,0),(-0.44721,0.89443,0),(-0.53212,0.84667,0),(-0.6,0.8,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.16883,-0.14064,0.07),(0.17165,-0.13962,0.07),(0.17453,-0.13878,0.07),(0.18043,-0.13756,0.07),(0.18644,-0.1369,0.07),(0.19246,-0.13671,0.07),(0.19246,-0.13671,0),(0.18644,-0.1369,0),(0.18043,-0.13756,0),(0.17453,-0.13878,0),(0.17165,-0.13962,0),(0.16883,-0.14064,0.0)]),
          normal=Normal(vector=[(-0.37139,0.92848,0),(-0.31054,0.95056,0),(-0.25355,0.96732,0),(-0.15234,0.98833,0),(-0.06825,0.99767,0),(0,1.0,-0.0),(0,1.0,-0.0),(-0.06825,0.99767,0),(-0.15234,0.98833,0),(-0.25355,0.96732,0),(-0.31054,0.95056,0),(-0.37139,0.92848,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.19246,-0.13671,0.07),(0.19816,-0.137,0.07),(0.20102,-0.13739,0.07),(0.20385,-0.13798,0.07),(0.2066,-0.13877,0.07),(0.20926,-0.1398,0.07),(0.21177,-0.14107,0.07),(0.21411,-0.14261,0.07),(0.21411,-0.14261,0),(0.21177,-0.14107,0),(0.20926,-0.1398,0),(0.2066,-0.13877,0),(0.20385,-0.13798,0),(0.20102,-0.13739,0),(0.19816,-0.137,0),(0.19246,-0.13671,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.10549,0.99442,-0.0),(0.16797,0.98579,-0.0),(0.23831,0.97119,-0.0),(0.31721,0.94836,-0.0),(0.40477,0.91442,-0.0),(0.49996,0.86605,-0.0),(0.6,0.8,-0.0),(0.6,0.8,-0.0),(0.49996,0.86605,-0.0),(0.40477,0.91442,-0.0),(0.31721,0.94836,-0.0),(0.23831,0.97119,-0.0),(0.16797,0.98579,-0.0),(0.10549,0.99442,-0.0),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.21411,-0.14261,0.07),(0.21838,-0.1445,0.07),(0.2225,-0.14675,0.07),(0.22636,-0.14939,0.07),(0.22817,-0.15087,0.07),(0.22986,-0.15246,0.07),(0.22986,-0.15246,0),(0.22817,-0.15087,0),(0.22636,-0.14939,0),(0.2225,-0.14675,0),(0.21838,-0.1445,0),(0.21411,-0.14261,0.0)]),
          normal=Normal(vector=[(0.37139,0.92848,-0.0),(0.44036,0.89782,-0.0),(0.51995,0.8542,-0.0),(0.60979,0.79256,-0.0),(0.65782,0.75317,-0.0),(0.70711,0.70711,-0.0),(0.70711,0.70711,-0.0),(0.65782,0.75317,-0.0),(0.60979,0.79256,-0.0),(0.51995,0.8542,-0.0),(0.44036,0.89782,-0.0),(0.37139,0.92848,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,13,-1,13,1,12,-1,12,1,2,-1,11,2,3,-1,10,3,4,-1,9,4,5,-1,8,5,6,-1,7,8,6,-1,12,2,11,-1,11,3,10,-1,10,4,9,-1,9,5,8,-1],solid=False,
          coord=Coordinate(point=[(0.22986,-0.15246,0.07),(0.2323,-0.15508,0.07),(0.23449,-0.15793,0.07),(0.23547,-0.15944,0.07),(0.23635,-0.161,0.07),(0.23711,-0.16261,0.07),(0.23774,-0.16427,0.07),(0.23774,-0.16427,0),(0.23711,-0.16261,0),(0.23635,-0.161,0),(0.23547,-0.15944,0),(0.23449,-0.15793,0),(0.2323,-0.15508,0),(0.22986,-0.15246,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.76123,0.64848,-0.0),(0.82277,0.56837,-0.0),(0.85532,0.5181,-0.0),(0.88802,0.4598,-0.0),(0.91968,0.39267,-0.0),(0.94868,0.31623,-0.0),(0.94868,0.31623,-0.0),(0.91968,0.39267,-0.0),(0.88802,0.4598,-0.0),(0.85532,0.5181,-0.0),(0.82277,0.56837,-0.0),(0.76123,0.64848,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.23774,-0.16427,0.07),(0.23858,-0.16715,0.07),(0.2392,-0.1701,0.07),(0.23958,-0.17308,0.07),(0.23971,-0.17608,0.07),(0.23971,-0.17608,0),(0.23958,-0.17308,0),(0.2392,-0.1701,0),(0.23858,-0.16715,0),(0.23774,-0.16427,0.0)]),
          normal=Normal(vector=[(0.94868,0.31623,-0.0),(0.97003,0.24298,-0.0),(0.98605,0.16646,-0.0),(0.99632,0.08575,-0.0),(1.0,0,0),(1.0,0,0),(0.99632,0.08575,-0.0),(0.98605,0.16646,-0.0),(0.97003,0.24298,-0.0),(0.94868,0.31623,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[7,0,6,-1,6,0,1,-1,5,1,2,-1,3,5,2,-1,3,4,5,-1,6,1,5,-1],solid=False,
          coord=Coordinate(point=[(0.23971,-0.17608,0.07),(0.23955,-0.17858,0.07),(0.23912,-0.18107,0.07),(0.23774,-0.18592,0.07),(0.23774,-0.18592,0),(0.23912,-0.18107,0),(0.23955,-0.17858,0),(0.23971,-0.17608,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99258,-0.12161,0),(0.97691,-0.21363,0),(0.94868,-0.31623,0),(0.94868,-0.31623,0),(0.97691,-0.21363,0),(0.99258,-0.12161,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.23774,-0.18592,0.07),(0.23657,-0.18902,0.07),(0.23518,-0.19202,0.07),(0.23183,-0.19774,0.07),(0.23183,-0.19774,0),(0.23518,-0.19202,0),(0.23657,-0.18902,0),(0.23774,-0.18592,0.0)]),
          normal=Normal(vector=[(0.94868,-0.31623,0),(0.92164,-0.38803,0),(0.89248,-0.45108,0),(0.83205,-0.5547,0),(0.83205,-0.5547,0),(0.89248,-0.45108,0),(0.92164,-0.38803,0),(0.94868,-0.31623,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.23183,-0.19774,0.07),(0.22975,-0.20054,0.07),(0.22739,-0.20314,0.07),(0.22479,-0.2055,0.07),(0.22199,-0.20758,0.07),(0.22199,-0.20758,0),(0.22479,-0.2055,0),(0.22739,-0.20314,0),(0.22975,-0.20054,0),(0.23183,-0.19774,0.0)]),
          normal=Normal(vector=[(0.83205,-0.5547,0),(0.77259,-0.63491,0),(0.70711,-0.70711,0),(0.63491,-0.77259,0),(0.5547,-0.83205,0),(0.5547,-0.83205,0),(0.63491,-0.77259,0),(0.70711,-0.70711,0),(0.77259,-0.63491,0),(0.83205,-0.5547,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,7,-1,7,1,6,-1,6,1,2,-1,5,2,3,-1,4,5,3,-1,6,2,5,-1],solid=False,
          coord=Coordinate(point=[(0.22199,-0.20758,0.07),(0.21773,-0.20951,0.07),(0.21333,-0.21112,0.07),(0.20427,-0.21349,0.07),(0.20427,-0.21349,0),(0.21333,-0.21112,0),(0.21773,-0.20951,0),(0.22199,-0.20758,0.0)]),
          normal=Normal(vector=[(0.44721,-0.89443,0),(0.37732,-0.92608,0),(0.31212,-0.95004,0),(0.19612,-0.98058,0),(0.19612,-0.98058,0),(0.31212,-0.95004,0),(0.37732,-0.92608,0),(0.44721,-0.89443,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.20427,-0.21349,0.07),(0.20427,-0.21546,0.07),(0.20427,-0.21546,0),(0.20427,-0.21349,0.0)]),
          normal=Normal(vector=[(1,0,0),(1,0,0),(1,0,0),(1,0,0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,5,-1,5,1,4,-1,4,1,2,-1,3,4,2,-1],solid=False,
          coord=Coordinate(point=[(0.20427,-0.21546,0.07),(0.21112,-0.21756,0.07),(0.21805,-0.21939,0.07),(0.21805,-0.21939,0),(0.21112,-0.21756,0),(0.20427,-0.21546,0.0)]),
          normal=Normal(vector=[(0.31623,0.94868,-0.0),(0.27229,0.96222,-0.0),(0.24254,0.97014,-0.0),(0.24254,0.97014,-0.0),(0.27229,0.96222,-0.0),(0.31623,0.94868,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.21805,-0.21939,0.07),(0.22167,-0.22044,0.07),(0.2252,-0.22176,0.07),(0.22861,-0.22338,0.07),(0.23183,-0.2253,0.07),(0.23183,-0.2253,0),(0.22861,-0.22338,0),(0.2252,-0.22176,0),(0.22167,-0.22044,0),(0.21805,-0.21939,0.0)]),
          normal=Normal(vector=[(0.24253,0.97014,-0.0),(0.31323,0.94968,-0.0),(0.3887,0.92136,-0.0),(0.46933,0.88302,-0.0),(0.5547,0.83205,-0.0),(0.5547,0.83205,-0.0),(0.46933,0.88302,-0.0),(0.3887,0.92136,-0.0),(0.31323,0.94968,-0.0),(0.24253,0.97014,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,9,-1,9,1,8,-1,8,1,2,-1,7,2,3,-1,6,3,4,-1,5,6,4,-1,8,2,7,-1,7,3,6,-1],solid=False,
          coord=Coordinate(point=[(0.23183,-0.2253,0.07),(0.2347,-0.22843,0.07),(0.2373,-0.23179,0.07),(0.23963,-0.23536,0.07),(0.24168,-0.23908,0.07),(0.24168,-0.23908,0),(0.23963,-0.23536,0),(0.2373,-0.23179,0),(0.2347,-0.22843,0),(0.23183,-0.2253,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,-0.0),(0.76513,0.64387,-0.0),(0.81495,0.57953,-0.0),(0.85773,0.5141,-0.0),(0.89443,0.44721,-0.0),(0.89443,0.44721,-0.0),(0.85773,0.5141,-0.0),(0.81495,0.57953,-0.0),(0.76513,0.64387,-0.0),(0.70711,0.70711,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,15,-1,15,1,14,-1,14,1,2,-1,13,2,3,-1,12,3,4,-1,11,4,5,-1,10,5,6,-1,9,6,7,-1,8,9,7,-1,14,2,13,-1,13,3,12,-1,12,4,11,-1,11,5,10,-1,10,6,9,-1],solid=False,
          coord=Coordinate(point=[(0.24168,-0.23908,0.07),(0.24227,-0.24004,0.07),(0.24281,-0.24104,0.07),(0.24371,-0.24312,0.07),(0.2444,-0.2453,0.07),(0.2449,-0.24756,0.07),(0.24547,-0.25219,0.07),(0.24561,-0.2568,0.07),(0.24561,-0.2568,0),(0.24547,-0.25219,0),(0.2449,-0.24756,0),(0.2444,-0.2453,0),(0.24371,-0.24312,0),(0.24281,-0.24104,0),(0.24227,-0.24004,0),(0.24168,-0.23908,0.0)]),
          normal=Normal(vector=[(0.83205,0.5547,-0.0),(0.86597,0.5001,-0.0),(0.89465,0.44677,-0.0),(0.93799,0.34667,-0.0),(0.96612,0.25811,-0.0),(0.98322,0.18244,-0.0),(0.99763,0.06877,-0.0),(1.0,0,0),(1.0,0,0),(0.99763,0.06877,-0.0),(0.98322,0.18244,-0.0),(0.96612,0.25811,-0.0),(0.93799,0.34667,-0.0),(0.89465,0.44677,-0.0),(0.86597,0.5001,-0.0),(0.83205,0.5547,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,21,-1,21,1,20,-1,20,1,2,-1,19,2,3,-1,18,3,4,-1,17,4,5,-1,16,5,6,-1,15,6,7,-1,14,7,8,-1,13,8,9,-1,12,9,10,-1,11,12,10,-1,20,2,19,-1,19,3,18,-1,18,4,17,-1,17,5,16,-1,16,6,15,-1,15,7,14,-1,14,8,13,-1,13,9,12,-1],solid=False,
          coord=Coordinate(point=[(0.24561,-0.2568,0.07),(0.24552,-0.25917,0.07),(0.24526,-0.26154,0.07),(0.24483,-0.26391,0.07),(0.24425,-0.26627,0.07),(0.24263,-0.27089,0.07),(0.24049,-0.27536,0.07),(0.23788,-0.2796,0.07),(0.23487,-0.28354,0.07),(0.23152,-0.28712,0.07),(0.22789,-0.29027,0.07),(0.22789,-0.29027,0),(0.23152,-0.28712,0),(0.23487,-0.28354,0),(0.23788,-0.2796,0),(0.24049,-0.27536,0),(0.24263,-0.27089,0),(0.24425,-0.26627,0),(0.24483,-0.26391,0),(0.24526,-0.26154,0),(0.24552,-0.25917,0),(0.24561,-0.2568,0.0)]),
          normal=Normal(vector=[(1.0,0,-0.0),(0.99721,-0.07465,0),(0.98945,-0.14485,0),(0.97758,-0.21056,0),(0.96232,-0.27191,0),(0.92389,-0.38266,0),(0.8773,-0.47993,0),(0.82386,-0.5668,0),(0.76334,-0.646,0),(0.69427,-0.71972,0),(0.61394,-0.78935,0),(0.61394,-0.78935,0),(0.69427,-0.71972,0),(0.76334,-0.646,0),(0.82386,-0.5668,0),(0.8773,-0.47993,0),(0.92389,-0.38266,0),(0.96232,-0.27191,0),(0.97758,-0.21056,0),(0.98945,-0.14485,0),(0.99721,-0.07465,0),(1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,17,-1,17,1,16,-1,16,1,2,-1,15,2,3,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,2,15,-1,15,3,14,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(0.22789,-0.29027,0.07),(0.22318,-0.29399,0.07),(0.21803,-0.29721,0.07),(0.21253,-0.29992,0.07),(0.20677,-0.30213,0.07),(0.20081,-0.30383,0.07),(0.19475,-0.30505,0.07),(0.18866,-0.30578,0.07),(0.18261,-0.30602,0.07),(0.18261,-0.30602,0),(0.18866,-0.30578,0),(0.19475,-0.30505,0),(0.20081,-0.30383,0),(0.20677,-0.30213,0),(0.21253,-0.29992,0),(0.21803,-0.29721,0),(0.22318,-0.29399,0),(0.22789,-0.29027,0.0)]),
          normal=Normal(vector=[(0.66436,-0.74741,0),(0.5742,-0.81872,0),(0.48534,-0.87432,0),(0.39926,-0.91684,0),(0.31628,-0.94867,0),(0.23596,-0.97176,0),(0.15736,-0.98754,0),(0.07921,-0.99686,0),(0,-1.0,0),(0,-1.0,0),(0.07921,-0.99686,0),(0.15736,-0.98754,0),(0.23596,-0.97176,0),(0.31628,-0.94867,0),(0.39926,-0.91684,0),(0.48534,-0.87432,0),(0.5742,-0.81872,0),(0.66436,-0.74741,0.0)]))),
      Shape(
        appearance=Appearance(USE='characters2013Appearance'),
        geometry=IndexedFaceSet(coordIndex=[299,0,8,-1,298,8,9,-1,297,9,10,-1,296,10,230,-1,231,296,230,-1,231,232,296,-1,296,232,233,-1,234,296,233,-1,234,235,296,-1,296,235,236,-1,241,236,240,-1,241,296,236,-1,241,242,296,-1,296,242,243,-1,244,296,243,-1,244,245,296,-1,296,245,246,-1,295,246,247,-1,248,295,247,-1,248,294,295,-1,248,249,294,-1,294,249,293,-1,293,249,270,-1,271,293,270,-1,271,292,293,-1,271,290,292,-1,271,289,290,-1,271,272,289,-1,289,272,288,-1,288,272,273,-1,274,288,273,-1,274,275,288,-1,288,275,287,-1,287,275,280,-1,286,280,285,-1,286,287,280,-1,2,7,1,-1,2,6,7,-1,2,3,6,-1,6,3,5,-1,5,3,4,-1,7,8,1,-1,1,8,0,-1,299,8,298,-1,298,9,297,-1,11,225,10,-1,11,224,225,-1,11,223,224,-1,11,222,223,-1,11,12,222,-1,222,12,221,-1,221,12,220,-1,220,12,219,-1,219,12,218,-1,218,12,13,-1,217,13,216,-1,217,218,13,-1,13,14,216,-1,216,14,215,-1,215,14,214,-1,214,14,213,-1,213,14,15,-1,212,15,211,-1,212,213,15,-1,15,16,211,-1,211,16,210,-1,210,16,209,-1,209,16,17,-1,208,17,207,-1,208,209,17,-1,207,17,206,-1,206,17,18,-1,205,18,19,-1,204,19,20,-1,203,20,21,-1,202,21,22,-1,201,22,23,-1,200,23,199,-1,200,201,23,-1,206,18,205,-1,205,19,204,-1,204,20,203,-1,203,21,202,-1,202,22,201,-1,23,24,199,-1,199,24,25,-1,198,25,26,-1,197,26,27,-1,28,197,27,-1,28,29,197,-1,197,29,196,-1,196,29,30,-1,195,30,194,-1,195,196,30,-1,199,25,198,-1,198,26,197,-1,30,31,194,-1,194,31,193,-1,193,31,192,-1,192,31,191,-1,191,31,190,-1,190,31,32,-1,189,32,188,-1,189,190,32,-1,33,185,32,-1,33,184,185,-1,33,183,184,-1,33,182,183,-1,33,181,182,-1,33,34,181,-1,181,34,180,-1,180,34,35,-1,179,35,36,-1,37,179,36,-1,37,38,179,-1,179,38,39,-1,40,179,39,-1,40,178,179,-1,40,41,178,-1,178,41,177,-1,177,41,42,-1,176,42,175,-1,176,177,42,-1,180,35,179,-1,43,173,42,-1,43,172,173,-1,43,44,172,-1,172,44,171,-1,171,44,170,-1,170,44,45,-1,169,45,168,-1,169,170,45,-1,45,46,168,-1,168,46,167,-1,167,46,166,-1,166,46,47,-1,165,47,164,-1,165,166,47,-1,164,47,163,-1,163,47,48,-1,162,48,49,-1,161,49,50,-1,160,50,51,-1,52,160,51,-1,52,159,160,-1,52,53,159,-1,159,53,158,-1,158,53,54,-1,157,54,55,-1,156,55,56,-1,155,56,57,-1,58,155,57,-1,58,154,155,-1,58,59,154,-1,154,59,60,-1,153,60,61,-1,152,61,62,-1,63,152,62,-1,63,64,152,-1,152,64,65,-1,66,152,65,-1,66,67,152,-1,152,67,68,-1,151,68,69,-1,150,69,149,-1,150,151,69,-1,163,48,162,-1,162,49,161,-1,161,50,160,-1,158,54,157,-1,157,55,156,-1,156,56,155,-1,154,60,153,-1,153,61,152,-1,152,68,151,-1,69,70,149,-1,149,70,148,-1,148,70,71,-1,147,71,146,-1,147,148,71,-1,71,72,146,-1,146,72,145,-1,145,72,144,-1,144,72,73,-1,143,73,74,-1,142,74,75,-1,141,75,140,-1,141,142,75,-1,144,73,143,-1,143,74,142,-1,75,76,140,-1,140,76,139,-1,139,76,77,-1,78,139,77,-1,78,79,139,-1,139,79,80,-1,81,139,80,-1,81,138,139,-1,81,137,138,-1,81,136,137,-1,81,135,136,-1,81,134,135,-1,81,133,134,-1,81,132,133,-1,81,131,132,-1,81,130,131,-1,81,129,130,-1,81,128,129,-1,81,127,128,-1,81,126,127,-1,81,125,126,-1,81,82,125,-1,125,82,124,-1,124,82,83,-1,123,83,103,-1,104,123,103,-1,104,122,123,-1,104,105,122,-1,122,105,106,-1,121,106,120,-1,121,122,106,-1,84,85,83,-1,83,85,102,-1,103,83,102,-1,85,86,102,-1,102,86,87,-1,101,87,88,-1,100,88,89,-1,99,89,98,-1,99,100,89,-1,102,87,101,-1,101,88,100,-1,89,90,98,-1,98,90,91,-1,92,98,91,-1,92,97,98,-1,92,93,97,-1,97,93,96,-1,96,93,94,-1,95,96,94,-1,120,106,119,-1,119,106,107,-1,118,107,117,-1,118,119,107,-1,108,109,107,-1,107,109,110,-1,117,110,111,-1,112,117,111,-1,112,113,117,-1,117,113,114,-1,116,114,115,-1,116,117,114,-1,107,110,117,-1,123,124,83,-1,173,174,42,-1,42,174,175,-1,185,186,32,-1,32,186,187,-1,188,32,187,-1,225,226,10,-1,10,226,227,-1,228,10,227,-1,228,229,10,-1,10,229,230,-1,240,236,239,-1,239,236,237,-1,238,239,237,-1,296,246,295,-1,270,249,269,-1,269,249,250,-1,268,250,267,-1,268,269,250,-1,267,250,266,-1,266,250,251,-1,265,251,264,-1,265,266,251,-1,252,262,251,-1,252,261,262,-1,252,253,261,-1,261,253,260,-1,260,253,259,-1,259,253,258,-1,258,253,257,-1,257,253,256,-1,256,253,254,-1,255,256,254,-1,262,263,251,-1,251,263,264,-1,275,276,280,-1,280,276,277,-1,278,280,277,-1,278,279,280,-1,281,282,280,-1,280,282,283,-1,284,280,283,-1,284,285,280,-1,290,291,292,-1,296,297,10,-1],solid=False,
          coord=Coordinate(point=[(0.16293,-0.30208,0.07),(0.16768,-0.30375,0.07),(0.17259,-0.30498,0.07),(0.17759,-0.30575,0.07),(0.18261,-0.30602,0.07),(0.18866,-0.30578,0.07),(0.19475,-0.30505,0.07),(0.20081,-0.30383,0.07),(0.20677,-0.30213,0.07),(0.21253,-0.29992,0.07),(0.21803,-0.29721,0.07),(0.22318,-0.29399,0.07),(0.22789,-0.29027,0.07),(0.23152,-0.28712,0.07),(0.23487,-0.28354,0.07),(0.23788,-0.2796,0.07),(0.24049,-0.27536,0.07),(0.24263,-0.27089,0.07),(0.24425,-0.26627,0.07),(0.24483,-0.26391,0.07),(0.24526,-0.26154,0.07),(0.24552,-0.25917,0.07),(0.24561,-0.2568,0.07),(0.24547,-0.25219,0.07),(0.2449,-0.24756,0.07),(0.2444,-0.2453,0.07),(0.24371,-0.24312,0.07),(0.24281,-0.24104,0.07),(0.24227,-0.24004,0.07),(0.24168,-0.23908,0.07),(0.23963,-0.23536,0.07),(0.2373,-0.23179,0.07),(0.2347,-0.22843,0.07),(0.23183,-0.2253,0.07),(0.22861,-0.22338,0.07),(0.2252,-0.22176,0.07),(0.22167,-0.22044,0.07),(0.21805,-0.21939,0.07),(0.21112,-0.21756,0.07),(0.20427,-0.21546,0.07),(0.20427,-0.21349,0.07),(0.21333,-0.21112,0.07),(0.21773,-0.20951,0.07),(0.22199,-0.20758,0.07),(0.22479,-0.2055,0.07),(0.22739,-0.20314,0.07),(0.22975,-0.20054,0.07),(0.23183,-0.19774,0.07),(0.23518,-0.19202,0.07),(0.23657,-0.18902,0.07),(0.23774,-0.18592,0.07),(0.23912,-0.18107,0.07),(0.23955,-0.17858,0.07),(0.23971,-0.17608,0.07),(0.23958,-0.17308,0.07),(0.2392,-0.1701,0.07),(0.23858,-0.16715,0.07),(0.23774,-0.16427,0.07),(0.23711,-0.16261,0.07),(0.23635,-0.161,0.07),(0.23547,-0.15944,0.07),(0.23449,-0.15793,0.07),(0.2323,-0.15508,0.07),(0.22986,-0.15246,0.07),(0.22817,-0.15087,0.07),(0.22636,-0.14939,0.07),(0.2225,-0.14675,0.07),(0.21838,-0.1445,0.07),(0.21411,-0.14261,0.07),(0.21177,-0.14107,0.07),(0.20926,-0.1398,0.07),(0.2066,-0.13877,0.07),(0.20385,-0.13798,0.07),(0.20102,-0.13739,0.07),(0.19816,-0.137,0.07),(0.19246,-0.13671,0.07),(0.18644,-0.1369,0.07),(0.18043,-0.13756,0.07),(0.17453,-0.13878,0.07),(0.17165,-0.13962,0.07),(0.16883,-0.14064,0.07),(0.16074,-0.14521,0.07),(0.15308,-0.15049,0.07),(0.14787,-0.15615,0.07),(0.14324,-0.1623,0.07),(0.1424,-0.16518,0.07),(0.14178,-0.16813,0.07),(0.1414,-0.17112,0.07),(0.14127,-0.17411,0.07),(0.14137,-0.17664,0.07),(0.14169,-0.17917,0.07),(0.14196,-0.18041,0.07),(0.1423,-0.18163,0.07),(0.14272,-0.18281,0.07),(0.14324,-0.18396,0.07),(0.14383,-0.18488,0.07),(0.14461,-0.18568,0.07),(0.14553,-0.18636,0.07),(0.14657,-0.18691,0.07),(0.14768,-0.18734,0.07),(0.14883,-0.18765,0.07),(0.14999,-0.18783,0.07),(0.15111,-0.18789,0.07),(0.15414,-0.18784,0.07),(0.15718,-0.18758,0.07),(0.15867,-0.18733,0.07),(0.16014,-0.18699,0.07),(0.16156,-0.18652,0.07),(0.16293,-0.18592,0.07),(0.16369,-0.18511,0.07),(0.16442,-0.18423,0.07),(0.16508,-0.1833,0.07),(0.16567,-0.18231,0.07),(0.16616,-0.18128,0.07),(0.16654,-0.18023,0.07),(0.16678,-0.17915,0.07),(0.16686,-0.17805,0.07),(0.16677,-0.17552,0.07),(0.16644,-0.173,0.07),(0.16618,-0.17175,0.07),(0.16583,-0.17054,0.07),(0.16541,-0.16935,0.07),(0.16489,-0.16821,0.07),(0.16351,-0.16335,0.07),(0.16308,-0.16087,0.07),(0.16293,-0.15836,0.07),(0.16391,-0.15738,0.07),(0.16489,-0.15639,0.07),(0.16623,-0.15522,0.07),(0.16768,-0.15419,0.07),(0.1708,-0.15246,0.07),(0.17213,-0.15128,0.07),(0.17359,-0.15026,0.07),(0.17671,-0.14852,0.07),(0.17785,-0.148,0.07),(0.17904,-0.14758,0.07),(0.18025,-0.14724,0.07),(0.1815,-0.14697,0.07),(0.18402,-0.14665,0.07),(0.18655,-0.14655,0.07),(0.18925,-0.14666,0.07),(0.19201,-0.14699,0.07),(0.19477,-0.14755,0.07),(0.19746,-0.14837,0.07),(0.20001,-0.14945,0.07),(0.20122,-0.15009,0.07),(0.20237,-0.15081,0.07),(0.20345,-0.1516,0.07),(0.20446,-0.15246,0.07),(0.2054,-0.1534,0.07),(0.20624,-0.15442,0.07),(0.20722,-0.15548,0.07),(0.20814,-0.1566,0.07),(0.20976,-0.15902,0.07),(0.21112,-0.16164,0.07),(0.21221,-0.16441,0.07),(0.21305,-0.16729,0.07),(0.21365,-0.17022,0.07),(0.214,-0.17317,0.07),(0.21411,-0.17608,0.07),(0.21377,-0.18296,0.07),(0.21329,-0.18644,0.07),(0.21254,-0.18986,0.07),(0.2115,-0.19316,0.07),(0.21013,-0.19627,0.07),(0.20931,-0.19773,0.07),(0.20839,-0.19913,0.07),(0.20737,-0.20045,0.07),(0.20624,-0.20167,0.07),(0.20518,-0.20266,0.07),(0.20406,-0.20357,0.07),(0.20164,-0.2052,0.07),(0.19902,-0.20655,0.07),(0.19625,-0.20765,0.07),(0.19338,-0.20849,0.07),(0.19044,-0.20908,0.07),(0.1875,-0.20943,0.07),(0.18458,-0.20955,0.07),(0.17474,-0.20955,0.07),(0.17474,-0.22333,0.07),(0.18852,-0.22333,0.07),(0.19263,-0.22352,0.07),(0.19469,-0.22379,0.07),(0.19674,-0.22417,0.07),(0.19873,-0.2247,0.07),(0.20067,-0.22539,0.07),(0.20252,-0.22624,0.07),(0.20427,-0.22727,0.07),(0.20544,-0.2277,0.07),(0.20661,-0.22822,0.07),(0.20774,-0.22882,0.07),(0.20882,-0.22951,0.07),(0.20983,-0.23029,0.07),(0.21073,-0.23116,0.07),(0.21151,-0.23212,0.07),(0.21214,-0.23317,0.07),(0.21549,-0.23889,0.07),(0.21688,-0.24189,0.07),(0.21805,-0.24499,0.07),(0.21889,-0.24787,0.07),(0.21951,-0.25082,0.07),(0.21989,-0.2538,0.07),(0.22002,-0.2568,0.07),(0.21983,-0.26091,0.07),(0.21957,-0.26297,0.07),(0.21918,-0.26502,0.07),(0.21865,-0.26701,0.07),(0.21796,-0.26895,0.07),(0.21711,-0.2708,0.07),(0.21608,-0.27255,0.07),(0.21553,-0.27446,0.07),(0.21484,-0.27634,0.07),(0.21401,-0.27818,0.07),(0.21307,-0.27996,0.07),(0.212,-0.28168,0.07),(0.21084,-0.28332,0.07),(0.20957,-0.28488,0.07),(0.20821,-0.28633,0.07),(0.20698,-0.28743,0.07),(0.20565,-0.28842,0.07),(0.20423,-0.28929,0.07),(0.20274,-0.29005,0.07),(0.1996,-0.2913,0.07),(0.19639,-0.29224,0.07),(0.19368,-0.29382,0.07),(0.19223,-0.2945,0.07),(0.19075,-0.29507,0.07),(0.18923,-0.29554,0.07),(0.18769,-0.29588,0.07),(0.18614,-0.2961,0.07),(0.18458,-0.29618,0.07),(0.18155,-0.29612,0.07),(0.17852,-0.29586,0.07),(0.17702,-0.29561,0.07),(0.17556,-0.29527,0.07),(0.17414,-0.2948,0.07),(0.17277,-0.29421,0.07),(0.1709,-0.29339,0.07),(0.16894,-0.29277,0.07),(0.16693,-0.29237,0.07),(0.16591,-0.29227,0.07),(0.16489,-0.29224,0.07),(0.16178,-0.2905,0.07),(0.16032,-0.28947,0.07),(0.15899,-0.2883,0.07),(0.158,-0.28732,0.07),(0.15702,-0.28633,0.07),(0.15705,-0.28532,0.07),(0.15716,-0.2843,0.07),(0.15755,-0.28229,0.07),(0.15817,-0.28033,0.07),(0.15899,-0.27846,0.07),(0.16037,-0.2736,0.07),(0.1608,-0.27112,0.07),(0.16096,-0.26861,0.07),(0.16087,-0.26772,0.07),(0.16064,-0.26684,0.07),(0.16027,-0.26598,0.07),(0.15978,-0.26517,0.07),(0.1592,-0.26442,0.07),(0.15853,-0.26374,0.07),(0.1578,-0.26317,0.07),(0.15702,-0.26271,0.07),(0.15645,-0.26218,0.07),(0.15584,-0.26169,0.07),(0.1552,-0.26125,0.07),(0.15452,-0.26085,0.07),(0.15309,-0.26017,0.07),(0.15157,-0.25964,0.07),(0.14999,-0.25924,0.07),(0.14839,-0.25897,0.07),(0.14679,-0.25882,0.07),(0.14521,-0.25877,0.07),(0.14397,-0.25889,0.07),(0.14274,-0.25925,0.07),(0.14155,-0.25982,0.07),(0.14043,-0.26055,0.07),(0.13941,-0.26144,0.07),(0.13854,-0.26244,0.07),(0.13783,-0.26353,0.07),(0.13733,-0.26467,0.07),(0.1367,-0.26545,0.07),(0.13622,-0.26633,0.07),(0.13587,-0.26729,0.07),(0.13563,-0.26832,0.07),(0.13548,-0.26937,0.07),(0.1354,-0.27045,0.07),(0.13536,-0.27255,0.07),(0.13549,-0.27555,0.07),(0.13587,-0.27853,0.07),(0.13649,-0.28148,0.07),(0.13733,-0.28436,0.07),(0.13941,-0.28717,0.07),(0.14177,-0.28977,0.07),(0.14437,-0.29213,0.07),(0.14718,-0.29421,0.07),(0.15082,-0.29672,0.07),(0.15468,-0.29893,0.07),(0.15872,-0.30075,0.07),(0.16081,-0.30148,0.07)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,28,0,-1,1,2,28,-1,28,2,3,-1,4,28,3,-1,4,5,28,-1,28,5,6,-1,7,28,6,-1,7,8,28,-1,28,8,9,-1,10,28,9,-1,10,11,28,-1,28,11,12,-1,13,28,12,-1,13,14,28,-1,28,14,15,-1,16,28,15,-1,16,17,28,-1,28,17,18,-1,19,28,18,-1,19,20,28,-1,28,20,21,-1,27,21,22,-1,26,22,23,-1,25,23,24,-1,25,26,23,-1,28,21,27,-1,27,22,26,-1,28,29,0,-1,0,29,30,-1,57,30,31,-1,56,31,32,-1,55,32,49,-1,54,49,53,-1,54,55,49,-1,0,30,57,-1,57,31,56,-1,33,47,32,-1,33,46,47,-1,33,45,46,-1,33,44,45,-1,33,43,44,-1,33,42,43,-1,33,41,42,-1,33,40,41,-1,33,34,40,-1,40,34,35,-1,36,40,35,-1,36,37,40,-1,40,37,39,-1,39,37,38,-1,47,48,32,-1,32,48,49,-1,49,50,53,-1,53,50,51,-1,52,53,51,-1,55,56,32,-1],solid=False,
          coord=Coordinate(point=[(0.60364,0.03114,0),(0.60947,0.03937,0),(0.6144,0.04823,0),(0.61845,0.05755,0),(0.62164,0.06714,0),(0.6246,0.0781,0),(0.62644,0.08935,0),(0.62764,0.11214,0),(0.62708,0.12365,0),(0.6254,0.13511,0),(0.62259,0.14633,0),(0.61864,0.15714,0),(0.61526,0.16594,0),(0.61109,0.17443,0),(0.6062,0.18253,0),(0.60064,0.19014,0),(0.59419,0.19731,0),(0.58694,0.20375,0),(0.57904,0.20938,0),(0.57064,0.21414,0),(0.56575,0.21637,0),(0.56069,0.21825,0),(0.55021,0.22104,0),(0.53945,0.22264,0),(0.52864,0.22314,0),(0.52483,0.2229,0),(0.52105,0.22225,0),(0.51364,0.22014,0),(0.50164,0.22014,0),(0.50164,0.03114,0),(0.50177,0.02823,0),(0.50216,0.02524,0),(0.50282,0.02227,0),(0.50377,0.01937,0),(0.50501,0.01664,0),(0.50575,0.01535,0),(0.50656,0.01414,0),(0.50746,0.013,0),(0.50844,0.01195,0),(0.5095,0.01099,0),(0.51064,0.01014,0),(0.51211,0.00923,0),(0.51363,0.00842,0),(0.5168,0.00705,0),(0.52013,0.0060,0),(0.52356,0.00523,0),(0.53061,0.00436,0),(0.53764,0.00414,0),(0.54757,0.00439,0),(0.5575,0.00531,0),(0.56725,0.00715,0),(0.572,0.00848,0),(0.57664,0.01014,0),(0.5842,0.01429,0),(0.5914,0.01914,0),(0.59478,0.02183,0),(0.59797,0.02473,0),(0.60094,0.02783,0.0)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(DEF='sidebarAppearance',
          material=Material(ambientIntensity=1.0,diffuseColor=(1,0.584,0),shininess=1)),
        geometry=IndexedFaceSet(coordIndex=[53,0,52,-1,52,0,1,-1,51,1,2,-1,50,2,3,-1,49,3,4,-1,48,4,5,-1,47,5,6,-1,46,6,7,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,42,10,11,-1,41,11,12,-1,40,12,13,-1,39,13,14,-1,38,14,15,-1,37,15,16,-1,36,16,17,-1,35,17,18,-1,34,18,19,-1,33,19,20,-1,32,20,21,-1,31,21,22,-1,30,22,23,-1,29,23,24,-1,28,24,25,-1,27,25,26,-1,27,28,25,-1,52,1,51,-1,51,2,50,-1,50,3,49,-1,49,4,48,-1,48,5,47,-1,47,6,46,-1,46,7,45,-1,45,8,44,-1,44,9,43,-1,43,10,42,-1,42,11,41,-1,41,12,40,-1,40,13,39,-1,39,14,38,-1,38,15,37,-1,37,16,36,-1,36,17,35,-1,35,18,34,-1,34,19,33,-1,33,20,32,-1,32,21,31,-1,31,22,30,-1,30,23,29,-1,29,24,28,-1],solid=False,
          coord=Coordinate(point=[(0.40463,-0.19956,0.05),(0.40553,-0.19961,0.05),(0.40642,-0.19977,0.05),(0.40729,-0.20004,0.05),(0.40811,-0.20042,0.05),(0.40889,-0.20088,0.05),(0.4096,-0.20144,0.05),(0.41024,-0.20208,0.05),(0.4108,-0.2028,0.05),(0.41127,-0.20357,0.05),(0.41164,-0.2044,0.05),(0.41191,-0.20526,0.05),(0.41207,-0.20615,0.05),(0.41213,-0.20706,0.05),(0.41207,-0.20796,0.05),(0.41191,-0.20885,0.05),(0.41164,-0.20972,0.05),(0.41127,-0.21054,0.05),(0.4108,-0.21132,0.05),(0.41024,-0.21203,0.05),(0.4096,-0.21267,0.05),(0.40889,-0.21323,0.05),(0.40811,-0.2137,0.05),(0.40729,-0.21407,0.05),(0.40642,-0.21434,0.05),(0.40553,-0.2145,0.05),(0.40463,-0.21456,0.05),(0.40463,-0.21456,0.0),(0.40553,-0.2145,0.0),(0.40642,-0.21434,0.0),(0.40729,-0.21407,0.0),(0.40811,-0.2137,0.0),(0.40889,-0.21323,0.0),(0.4096,-0.21267,0.0),(0.41024,-0.21203,0.0),(0.4108,-0.21132,0.0),(0.41127,-0.21054,0.0),(0.41164,-0.20972,0.0),(0.41191,-0.20885,0.0),(0.41207,-0.20796,0.0),(0.41213,-0.20706,0.0),(0.41207,-0.20615,0.0),(0.41191,-0.20526,0.0),(0.41164,-0.2044,0.0),(0.41127,-0.20357,0.0),(0.4108,-0.2028,0.0),(0.41024,-0.20208,0.0),(0.4096,-0.20144,0.0),(0.40889,-0.20088,0.0),(0.40811,-0.20042,0.0),(0.40729,-0.20004,0.0),(0.40642,-0.19977,0.0),(0.40553,-0.19961,0.0),(0.40463,-0.19956,0.0)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0.12054,0.99271,-0.0),(0.23932,0.97094,-0.0),(0.3546,0.93502,-0.0),(0.46472,0.88546,-0.0),(0.56806,0.82298,-0.0),(0.66312,0.74851,-0.0),(0.74851,0.66312,-0.0),(0.82298,0.56806,-0.0),(0.88546,0.46472,-0.0),(0.93502,0.3546,-0.0),(0.97094,0.23932,-0.0),(0.99271,0.12054,-0.0),(1.0,-0.0,-0.0),(0.99271,-0.12054,-0.0),(0.97094,-0.23932,-0.0),(0.93502,-0.3546,-0.0),(0.88546,-0.46472,-0.0),(0.82298,-0.56806,-0.0),(0.74851,-0.66312,-0.0),(0.66312,-0.74851,-0.0),(0.56806,-0.82298,-0.0),(0.46472,-0.88546,-0.0),(0.3546,-0.93502,-0.0),(0.23932,-0.97094,-0.0),(0.12054,-0.99271,-0.0),(0.0,-1.0,-0.0),(0.0,-1.0,-0.0),(0.12054,-0.99271,-0.0),(0.23932,-0.97094,-0.0),(0.3546,-0.93502,-0.0),(0.46472,-0.88546,-0.0),(0.56806,-0.82298,-0.0),(0.66312,-0.74851,-0.0),(0.74851,-0.66312,-0.0),(0.82298,-0.56806,-0.0),(0.88546,-0.46472,-0.0),(0.93502,-0.3546,-0.0),(0.97094,-0.23932,-0.0),(0.99271,-0.12054,-0.0),(1.0,-0.0,-0.0),(0.99271,0.12054,-0.0),(0.97094,0.23932,-0.0),(0.93502,0.3546,-0.0),(0.88546,0.46472,-0.0),(0.82298,0.56806,-0.0),(0.74851,0.66312,-0.0),(0.66312,0.74851,-0.0),(0.56806,0.82298,-0.0),(0.46472,0.88546,-0.0),(0.3546,0.93502,-0.0),(0.23932,0.97094,-0.0),(0.12054,0.99271,-0.0),(0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.40463,-0.21456,0.05),(0.28941,-0.21456,0.05),(0.28941,-0.21456,0.0),(0.40463,-0.21456,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[53,0,52,-1,52,0,1,-1,51,1,2,-1,50,2,3,-1,49,3,4,-1,48,4,5,-1,47,5,6,-1,46,6,7,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,42,10,11,-1,41,11,12,-1,40,12,13,-1,39,13,14,-1,38,14,15,-1,37,15,16,-1,36,16,17,-1,35,17,18,-1,34,18,19,-1,33,19,20,-1,32,20,21,-1,31,21,22,-1,30,22,23,-1,29,23,24,-1,28,24,25,-1,27,25,26,-1,27,28,25,-1,52,1,51,-1,51,2,50,-1,50,3,49,-1,49,4,48,-1,48,5,47,-1,47,6,46,-1,46,7,45,-1,45,8,44,-1,44,9,43,-1,43,10,42,-1,42,11,41,-1,41,12,40,-1,40,13,39,-1,39,14,38,-1,38,15,37,-1,37,16,36,-1,36,17,35,-1,35,18,34,-1,34,19,33,-1,33,20,32,-1,32,21,31,-1,31,22,30,-1,30,23,29,-1,29,24,28,-1],solid=False,
          coord=Coordinate(point=[(0.28941,-0.21456,0.05),(0.28851,-0.2145,0.05),(0.28762,-0.21434,0.05),(0.28675,-0.21407,0.05),(0.28593,-0.2137,0.05),(0.28515,-0.21323,0.05),(0.28444,-0.21267,0.05),(0.2838,-0.21203,0.05),(0.28324,-0.21132,0.05),(0.28277,-0.21054,0.05),(0.2824,-0.20972,0.05),(0.28213,-0.20885,0.05),(0.28197,-0.20796,0.05),(0.28191,-0.20706,0.05),(0.28197,-0.20615,0.05),(0.28213,-0.20526,0.05),(0.2824,-0.2044,0.05),(0.28277,-0.20357,0.05),(0.28324,-0.2028,0.05),(0.2838,-0.20208,0.05),(0.28444,-0.20144,0.05),(0.28515,-0.20088,0.05),(0.28593,-0.20042,0.05),(0.28675,-0.20004,0.05),(0.28762,-0.19977,0.05),(0.28851,-0.19961,0.05),(0.28941,-0.19956,0.05),(0.28941,-0.19956,0.0),(0.28851,-0.19961,0.0),(0.28762,-0.19977,0.0),(0.28675,-0.20004,0.0),(0.28593,-0.20042,0.0),(0.28515,-0.20088,0.0),(0.28444,-0.20144,0.0),(0.2838,-0.20208,0.0),(0.28324,-0.2028,0.0),(0.28277,-0.20357,0.0),(0.2824,-0.2044,0.0),(0.28213,-0.20526,0.0),(0.28197,-0.20615,0.0),(0.28191,-0.20706,0.0),(0.28197,-0.20796,0.0),(0.28213,-0.20885,0.0),(0.2824,-0.20972,0.0),(0.28277,-0.21054,0.0),(0.28324,-0.21132,0.0),(0.2838,-0.21203,0.0),(0.28444,-0.21267,0.0),(0.28515,-0.21323,0.0),(0.28593,-0.2137,0.0),(0.28675,-0.21407,0.0),(0.28762,-0.21434,0.0),(0.28851,-0.2145,0.0),(0.28941,-0.21456,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,-0.0),(-0.12054,-0.99271,0.0),(-0.23932,-0.97094,0.0),(-0.3546,-0.93502,0.0),(-0.46472,-0.88546,0.0),(-0.56806,-0.82298,0.0),(-0.66312,-0.74851,0.0),(-0.74851,-0.66312,0.0),(-0.82298,-0.56806,0.0),(-0.88546,-0.46472,0.0),(-0.93502,-0.3546,0.0),(-0.97094,-0.23932,0.0),(-0.99271,-0.12054,0.0),(-1.0,-0.0,0.0),(-0.99271,0.12054,-0.0),(-0.97094,0.23932,-0.0),(-0.93502,0.3546,-0.0),(-0.88546,0.46472,-0.0),(-0.82298,0.56806,-0.0),(-0.74851,0.66312,-0.0),(-0.66312,0.74851,-0.0),(-0.56806,0.82298,-0.0),(-0.46472,0.88546,-0.0),(-0.3546,0.93502,-0.0),(-0.23932,0.97094,-0.0),(-0.12054,0.99271,-0.0),(0.0,1.0,-0.0),(0.0,1.0,-0.0),(-0.12054,0.99271,-0.0),(-0.23932,0.97094,-0.0),(-0.3546,0.93502,-0.0),(-0.46472,0.88546,-0.0),(-0.56806,0.82298,-0.0),(-0.66312,0.74851,-0.0),(-0.74851,0.66312,-0.0),(-0.82298,0.56806,-0.0),(-0.88546,0.46472,-0.0),(-0.93502,0.3546,-0.0),(-0.97094,0.23932,-0.0),(-0.99271,0.12054,-0.0),(-1.0,-0.0,0.0),(-0.99271,-0.12054,0.0),(-0.97094,-0.23932,0.0),(-0.93502,-0.3546,0.0),(-0.88546,-0.46472,0.0),(-0.82298,-0.56806,0.0),(-0.74851,-0.66312,0.0),(-0.66312,-0.74851,0.0),(-0.56806,-0.82298,0.0),(-0.46472,-0.88546,0.0),(-0.3546,-0.93502,0.0),(-0.23932,-0.97094,0.0),(-0.12054,-0.99271,0.0),(0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.28941,-0.19956,0.05),(0.40463,-0.19956,0.05),(0.40463,-0.19956,0.0),(0.28941,-0.19956,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1,4,0,3,-1,4,5,0,-1,0,5,6,-1,47,6,46,-1,47,0,6,-1,47,53,0,-1,47,48,53,-1,53,48,49,-1,50,53,49,-1,50,51,53,-1,53,51,52,-1,6,7,46,-1,46,7,45,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,11,43,10,-1,11,42,43,-1,11,41,42,-1,11,12,41,-1,41,12,13,-1,40,13,39,-1,40,41,13,-1,45,8,44,-1,44,9,43,-1,13,14,39,-1,39,14,15,-1,38,15,37,-1,38,39,15,-1,15,16,37,-1,37,16,17,-1,36,17,35,-1,36,37,17,-1,17,18,35,-1,35,18,34,-1,34,18,19,-1,33,19,20,-1,27,20,26,-1,27,33,20,-1,27,32,33,-1,27,31,32,-1,27,30,31,-1,27,29,30,-1,27,28,29,-1,34,19,33,-1,20,21,26,-1,26,21,22,-1,23,26,22,-1,23,24,26,-1,26,24,25,-1],solid=False,
          coord=Coordinate(point=[(0.40463,-0.21456,0.05),(0.40553,-0.2145,0.05),(0.40642,-0.21434,0.05),(0.40729,-0.21407,0.05),(0.40811,-0.2137,0.05),(0.40889,-0.21323,0.05),(0.4096,-0.21267,0.05),(0.41024,-0.21203,0.05),(0.4108,-0.21132,0.05),(0.41127,-0.21054,0.05),(0.41164,-0.20972,0.05),(0.41191,-0.20885,0.05),(0.41207,-0.20796,0.05),(0.41213,-0.20706,0.05),(0.41207,-0.20615,0.05),(0.41191,-0.20526,0.05),(0.41164,-0.2044,0.05),(0.41127,-0.20357,0.05),(0.4108,-0.2028,0.05),(0.41024,-0.20208,0.05),(0.4096,-0.20144,0.05),(0.40889,-0.20088,0.05),(0.40811,-0.20042,0.05),(0.40729,-0.20004,0.05),(0.40642,-0.19977,0.05),(0.40553,-0.19961,0.05),(0.40463,-0.19956,0.05),(0.28941,-0.19956,0.05),(0.28851,-0.19961,0.05),(0.28762,-0.19977,0.05),(0.28675,-0.20004,0.05),(0.28593,-0.20042,0.05),(0.28515,-0.20088,0.05),(0.28444,-0.20144,0.05),(0.2838,-0.20208,0.05),(0.28324,-0.2028,0.05),(0.28277,-0.20357,0.05),(0.2824,-0.2044,0.05),(0.28213,-0.20526,0.05),(0.28197,-0.20615,0.05),(0.28191,-0.20706,0.05),(0.28197,-0.20796,0.05),(0.28213,-0.20885,0.05),(0.2824,-0.20972,0.05),(0.28277,-0.21054,0.05),(0.28324,-0.21132,0.05),(0.2838,-0.21203,0.05),(0.28444,-0.21267,0.05),(0.28515,-0.21323,0.05),(0.28593,-0.2137,0.05),(0.28675,-0.21407,0.05),(0.28762,-0.21434,0.05),(0.28851,-0.2145,0.05),(0.28941,-0.21456,0.05)]),
          normal=Normal(vector=[(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[53,0,52,-1,52,0,1,-1,51,1,2,-1,50,2,3,-1,49,3,4,-1,48,4,5,-1,47,5,6,-1,46,6,7,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,42,10,11,-1,41,11,12,-1,40,12,13,-1,39,13,14,-1,38,14,15,-1,37,15,16,-1,36,16,17,-1,35,17,18,-1,34,18,19,-1,33,19,20,-1,32,20,21,-1,31,21,22,-1,30,22,23,-1,29,23,24,-1,28,24,25,-1,27,25,26,-1,27,28,25,-1,52,1,51,-1,51,2,50,-1,50,3,49,-1,49,4,48,-1,48,5,47,-1,47,6,46,-1,46,7,45,-1,45,8,44,-1,44,9,43,-1,43,10,42,-1,42,11,41,-1,41,12,40,-1,40,13,39,-1,39,14,38,-1,38,15,37,-1,37,16,36,-1,36,17,35,-1,35,18,34,-1,34,19,33,-1,33,20,32,-1,32,21,31,-1,31,22,30,-1,30,23,29,-1,29,24,28,-1],solid=False,
          coord=Coordinate(point=[(-0.29537,-0.19956,0.05),(-0.29447,-0.19961,0.05),(-0.29358,-0.19977,0.05),(-0.29271,-0.20004,0.05),(-0.29189,-0.20042,0.05),(-0.29111,-0.20088,0.05),(-0.2904,-0.20144,0.05),(-0.28976,-0.20208,0.05),(-0.2892,-0.2028,0.05),(-0.28873,-0.20357,0.05),(-0.28836,-0.2044,0.05),(-0.28809,-0.20526,0.05),(-0.28793,-0.20615,0.05),(-0.28787,-0.20706,0.05),(-0.28793,-0.20796,0.05),(-0.28809,-0.20885,0.05),(-0.28836,-0.20972,0.05),(-0.28873,-0.21054,0.05),(-0.2892,-0.21132,0.05),(-0.28976,-0.21203,0.05),(-0.2904,-0.21267,0.05),(-0.29111,-0.21323,0.05),(-0.29189,-0.2137,0.05),(-0.29271,-0.21407,0.05),(-0.29358,-0.21434,0.05),(-0.29447,-0.2145,0.05),(-0.29537,-0.21456,0.05),(-0.29537,-0.21456,0.0),(-0.29447,-0.2145,0.0),(-0.29358,-0.21434,0.0),(-0.29271,-0.21407,0.0),(-0.29189,-0.2137,0.0),(-0.29111,-0.21323,0.0),(-0.2904,-0.21267,0.0),(-0.28976,-0.21203,0.0),(-0.2892,-0.21132,0.0),(-0.28873,-0.21054,0.0),(-0.28836,-0.20972,0.0),(-0.28809,-0.20885,0.0),(-0.28793,-0.20796,0.0),(-0.28787,-0.20706,0.0),(-0.28793,-0.20615,0.0),(-0.28809,-0.20526,0.0),(-0.28836,-0.2044,0.0),(-0.28873,-0.20357,0.0),(-0.2892,-0.2028,0.0),(-0.28976,-0.20208,0.0),(-0.2904,-0.20144,0.0),(-0.29111,-0.20088,0.0),(-0.29189,-0.20042,0.0),(-0.29271,-0.20004,0.0),(-0.29358,-0.19977,0.0),(-0.29447,-0.19961,0.0),(-0.29537,-0.19956,0.0)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0.12054,0.99271,-0.0),(0.23932,0.97094,-0.0),(0.3546,0.93502,-0.0),(0.46472,0.88546,-0.0),(0.56806,0.82298,-0.0),(0.66312,0.74851,-0.0),(0.74851,0.66312,-0.0),(0.82298,0.56806,-0.0),(0.88546,0.46472,-0.0),(0.93502,0.3546,-0.0),(0.97094,0.23932,-0.0),(0.99271,0.12054,-0.0),(1.0,-0.0,-0.0),(0.99271,-0.12054,-0.0),(0.97094,-0.23932,-0.0),(0.93502,-0.3546,-0.0),(0.88546,-0.46472,-0.0),(0.82298,-0.56806,-0.0),(0.74851,-0.66312,-0.0),(0.66312,-0.74851,-0.0),(0.56806,-0.82298,-0.0),(0.46472,-0.88546,-0.0),(0.3546,-0.93502,-0.0),(0.23932,-0.97094,-0.0),(0.12054,-0.99271,-0.0),(0.0,-1.0,-0.0),(0.0,-1.0,-0.0),(0.12054,-0.99271,-0.0),(0.23932,-0.97094,-0.0),(0.3546,-0.93502,-0.0),(0.46472,-0.88546,-0.0),(0.56806,-0.82298,-0.0),(0.66312,-0.74851,-0.0),(0.74851,-0.66312,-0.0),(0.82298,-0.56806,-0.0),(0.88546,-0.46472,-0.0),(0.93502,-0.3546,-0.0),(0.97094,-0.23932,-0.0),(0.99271,-0.12054,-0.0),(1.0,-0.0,-0.0),(0.99271,0.12054,-0.0),(0.97094,0.23932,-0.0),(0.93502,0.3546,-0.0),(0.88546,0.46472,-0.0),(0.82298,0.56806,-0.0),(0.74851,0.66312,-0.0),(0.66312,0.74851,-0.0),(0.56806,0.82298,-0.0),(0.46472,0.88546,-0.0),(0.3546,0.93502,-0.0),(0.23932,0.97094,-0.0),(0.12054,0.99271,-0.0),(0.0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.29537,-0.21456,0.05),(-0.41059,-0.21456,0.05),(-0.41059,-0.21456,0.0),(-0.29537,-0.21456,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[53,0,52,-1,52,0,1,-1,51,1,2,-1,50,2,3,-1,49,3,4,-1,48,4,5,-1,47,5,6,-1,46,6,7,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,42,10,11,-1,41,11,12,-1,40,12,13,-1,39,13,14,-1,38,14,15,-1,37,15,16,-1,36,16,17,-1,35,17,18,-1,34,18,19,-1,33,19,20,-1,32,20,21,-1,31,21,22,-1,30,22,23,-1,29,23,24,-1,28,24,25,-1,27,25,26,-1,27,28,25,-1,52,1,51,-1,51,2,50,-1,50,3,49,-1,49,4,48,-1,48,5,47,-1,47,6,46,-1,46,7,45,-1,45,8,44,-1,44,9,43,-1,43,10,42,-1,42,11,41,-1,41,12,40,-1,40,13,39,-1,39,14,38,-1,38,15,37,-1,37,16,36,-1,36,17,35,-1,35,18,34,-1,34,19,33,-1,33,20,32,-1,32,21,31,-1,31,22,30,-1,30,23,29,-1,29,24,28,-1],solid=False,
          coord=Coordinate(point=[(-0.41059,-0.21456,0.05),(-0.41149,-0.2145,0.05),(-0.41238,-0.21434,0.05),(-0.41325,-0.21407,0.05),(-0.41407,-0.2137,0.05),(-0.41485,-0.21323,0.05),(-0.41556,-0.21267,0.05),(-0.4162,-0.21203,0.05),(-0.41676,-0.21132,0.05),(-0.41723,-0.21054,0.05),(-0.4176,-0.20972,0.05),(-0.41787,-0.20885,0.05),(-0.41803,-0.20796,0.05),(-0.41809,-0.20706,0.05),(-0.41803,-0.20615,0.05),(-0.41787,-0.20526,0.05),(-0.4176,-0.2044,0.05),(-0.41723,-0.20357,0.05),(-0.41676,-0.2028,0.05),(-0.4162,-0.20208,0.05),(-0.41556,-0.20144,0.05),(-0.41485,-0.20088,0.05),(-0.41407,-0.20042,0.05),(-0.41325,-0.20004,0.05),(-0.41238,-0.19977,0.05),(-0.41149,-0.19961,0.05),(-0.41059,-0.19956,0.05),(-0.41059,-0.19956,0.0),(-0.41149,-0.19961,0.0),(-0.41238,-0.19977,0.0),(-0.41325,-0.20004,0.0),(-0.41407,-0.20042,0.0),(-0.41485,-0.20088,0.0),(-0.41556,-0.20144,0.0),(-0.4162,-0.20208,0.0),(-0.41676,-0.2028,0.0),(-0.41723,-0.20357,0.0),(-0.4176,-0.2044,0.0),(-0.41787,-0.20526,0.0),(-0.41803,-0.20615,0.0),(-0.41809,-0.20706,0.0),(-0.41803,-0.20796,0.0),(-0.41787,-0.20885,0.0),(-0.4176,-0.20972,0.0),(-0.41723,-0.21054,0.0),(-0.41676,-0.21132,0.0),(-0.4162,-0.21203,0.0),(-0.41556,-0.21267,0.0),(-0.41485,-0.21323,0.0),(-0.41407,-0.2137,0.0),(-0.41325,-0.21407,0.0),(-0.41238,-0.21434,0.0),(-0.41149,-0.2145,0.0),(-0.41059,-0.21456,0.0)]),
          normal=Normal(vector=[(0.0,-1.0,-0.0),(-0.12054,-0.99271,0.0),(-0.23932,-0.97094,0.0),(-0.3546,-0.93502,0.0),(-0.46472,-0.88546,0.0),(-0.56806,-0.82298,0.0),(-0.66312,-0.74851,0.0),(-0.74851,-0.66312,0.0),(-0.82298,-0.56806,0.0),(-0.88546,-0.46472,0.0),(-0.93502,-0.3546,0.0),(-0.97094,-0.23932,0.0),(-0.99271,-0.12054,0.0),(-1.0,-0.0,0.0),(-0.99271,0.12054,-0.0),(-0.97094,0.23932,-0.0),(-0.93502,0.3546,-0.0),(-0.88546,0.46472,-0.0),(-0.82298,0.56806,-0.0),(-0.74851,0.66312,-0.0),(-0.66312,0.74851,-0.0),(-0.56806,0.82298,-0.0),(-0.46472,0.88546,-0.0),(-0.3546,0.93502,-0.0),(-0.23932,0.97094,-0.0),(-0.12054,0.99271,-0.0),(0.0,1.0,-0.0),(0.0,1.0,-0.0),(-0.12054,0.99271,-0.0),(-0.23932,0.97094,-0.0),(-0.3546,0.93502,-0.0),(-0.46472,0.88546,-0.0),(-0.56806,0.82298,-0.0),(-0.66312,0.74851,-0.0),(-0.74851,0.66312,-0.0),(-0.82298,0.56806,-0.0),(-0.88546,0.46472,-0.0),(-0.93502,0.3546,-0.0),(-0.97094,0.23932,-0.0),(-0.99271,0.12054,-0.0),(-1.0,-0.0,0.0),(-0.99271,-0.12054,0.0),(-0.97094,-0.23932,0.0),(-0.93502,-0.3546,0.0),(-0.88546,-0.46472,0.0),(-0.82298,-0.56806,0.0),(-0.74851,-0.66312,0.0),(-0.66312,-0.74851,0.0),(-0.56806,-0.82298,0.0),(-0.46472,-0.88546,0.0),(-0.3546,-0.93502,0.0),(-0.23932,-0.97094,0.0),(-0.12054,-0.99271,0.0),(0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.41059,-0.19956,0.05),(-0.29537,-0.19956,0.05),(-0.29537,-0.19956,0.0),(-0.41059,-0.19956,0.0)]),
          normal=Normal(vector=[(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='sidebarAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1,4,0,3,-1,4,5,0,-1,0,5,6,-1,47,6,46,-1,47,0,6,-1,47,53,0,-1,47,48,53,-1,53,48,49,-1,50,53,49,-1,50,51,53,-1,53,51,52,-1,6,7,46,-1,46,7,45,-1,45,7,8,-1,44,8,9,-1,43,9,10,-1,11,43,10,-1,11,42,43,-1,11,41,42,-1,11,12,41,-1,41,12,13,-1,40,13,39,-1,40,41,13,-1,45,8,44,-1,44,9,43,-1,13,14,39,-1,39,14,15,-1,38,15,37,-1,38,39,15,-1,15,16,37,-1,37,16,17,-1,36,17,35,-1,36,37,17,-1,17,18,35,-1,35,18,34,-1,34,18,19,-1,33,19,20,-1,27,20,26,-1,27,33,20,-1,27,32,33,-1,27,31,32,-1,27,30,31,-1,27,29,30,-1,27,28,29,-1,34,19,33,-1,20,21,26,-1,26,21,22,-1,23,26,22,-1,23,24,26,-1,26,24,25,-1],solid=False,
          coord=Coordinate(point=[(-0.29537,-0.21456,0.05),(-0.29447,-0.2145,0.05),(-0.29358,-0.21434,0.05),(-0.29271,-0.21407,0.05),(-0.29189,-0.2137,0.05),(-0.29111,-0.21323,0.05),(-0.2904,-0.21267,0.05),(-0.28976,-0.21203,0.05),(-0.2892,-0.21132,0.05),(-0.28873,-0.21054,0.05),(-0.28836,-0.20972,0.05),(-0.28809,-0.20885,0.05),(-0.28793,-0.20796,0.05),(-0.28787,-0.20706,0.05),(-0.28793,-0.20615,0.05),(-0.28809,-0.20526,0.05),(-0.28836,-0.2044,0.05),(-0.28873,-0.20357,0.05),(-0.2892,-0.2028,0.05),(-0.28976,-0.20208,0.05),(-0.2904,-0.20144,0.05),(-0.29111,-0.20088,0.05),(-0.29189,-0.20042,0.05),(-0.29271,-0.20004,0.05),(-0.29358,-0.19977,0.05),(-0.29447,-0.19961,0.05),(-0.29537,-0.19956,0.05),(-0.41059,-0.19956,0.05),(-0.41149,-0.19961,0.05),(-0.41238,-0.19977,0.05),(-0.41325,-0.20004,0.05),(-0.41407,-0.20042,0.05),(-0.41485,-0.20088,0.05),(-0.41556,-0.20144,0.05),(-0.4162,-0.20208,0.05),(-0.41676,-0.2028,0.05),(-0.41723,-0.20357,0.05),(-0.4176,-0.2044,0.05),(-0.41787,-0.20526,0.05),(-0.41803,-0.20615,0.05),(-0.41809,-0.20706,0.05),(-0.41803,-0.20796,0.05),(-0.41787,-0.20885,0.05),(-0.4176,-0.20972,0.05),(-0.41723,-0.21054,0.05),(-0.41676,-0.21132,0.05),(-0.4162,-0.21203,0.05),(-0.41556,-0.21267,0.05),(-0.41485,-0.21323,0.05),(-0.41407,-0.2137,0.05),(-0.41325,-0.21407,0.05),(-0.41238,-0.21434,0.05),(-0.41149,-0.2145,0.05),(-0.41059,-0.21456,0.05)]),
          normal=Normal(vector=[(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0),(0.0,0.0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,103,0,-1,1,102,103,-1,1,2,102,-1,102,2,101,-1,101,2,3,-1,100,3,4,-1,99,4,5,-1,98,5,6,-1,97,6,7,-1,96,7,8,-1,95,8,9,-1,94,9,10,-1,93,10,11,-1,92,11,12,-1,91,12,13,-1,90,13,14,-1,89,14,15,-1,88,15,16,-1,87,16,17,-1,86,17,18,-1,85,18,19,-1,84,19,20,-1,83,20,21,-1,82,21,22,-1,81,22,23,-1,80,23,24,-1,79,24,25,-1,78,25,26,-1,77,26,27,-1,76,27,28,-1,75,28,29,-1,74,29,30,-1,73,30,31,-1,72,31,32,-1,71,32,33,-1,70,33,34,-1,69,34,35,-1,68,35,36,-1,67,36,37,-1,66,37,38,-1,65,38,39,-1,64,39,40,-1,63,40,41,-1,62,41,42,-1,61,42,43,-1,60,43,44,-1,59,44,45,-1,58,45,46,-1,57,46,47,-1,56,47,48,-1,55,48,49,-1,54,49,50,-1,53,50,51,-1,52,51,0,-1,103,52,0,-1,101,3,100,-1,100,4,99,-1,99,5,98,-1,98,6,97,-1,97,7,96,-1,96,8,95,-1,95,9,94,-1,94,10,93,-1,93,11,92,-1,92,12,91,-1,91,13,90,-1,90,14,89,-1,89,15,88,-1,88,16,87,-1,87,17,86,-1,86,18,85,-1,85,19,84,-1,84,20,83,-1,83,21,82,-1,82,22,81,-1,81,23,80,-1,80,24,79,-1,79,25,78,-1,78,26,77,-1,77,27,76,-1,76,28,75,-1,75,29,74,-1,74,30,73,-1,73,31,72,-1,72,32,71,-1,71,33,70,-1,70,34,69,-1,69,35,68,-1,68,36,67,-1,67,37,66,-1,66,38,65,-1,65,39,64,-1,64,40,63,-1,63,41,62,-1,62,42,61,-1,61,43,60,-1,60,44,59,-1,59,45,58,-1,58,46,57,-1,57,47,56,-1,56,48,55,-1,55,49,54,-1,54,50,53,-1,53,51,52,-1],solid=False,
          coord=Coordinate(point=[(0.47443,-0.31008,-0.04),(0.46642,-0.30104,-0.04),(0.45956,-0.2911,-0.04),(0.45395,-0.28041,-0.04),(0.44967,-0.26912,-0.04),(0.44678,-0.25739,-0.04),(0.44532,-0.24541,-0.04),(0.44532,-0.23333,-0.04),(0.44678,-0.22134,-0.04),(0.44967,-0.20962,-0.04),(0.45395,-0.19833,-0.04),(0.45956,-0.18763,-0.04),(0.46642,-0.1777,-0.04),(0.47443,-0.16866,-0.04),(0.48347,-0.16065,-0.04),(0.49341,-0.15379,-0.04),(0.5041,-0.14818,-0.04),(0.51539,-0.1439,-0.04),(0.52711,-0.14101,-0.04),(0.5391,-0.13955,-0.04),(0.55118,-0.13955,-0.04),(0.56316,-0.14101,-0.04),(0.57489,-0.1439,-0.04),(0.58618,-0.14818,-0.04),(0.59687,-0.15379,-0.04),(0.60681,-0.16065,-0.04),(0.61585,-0.16866,-0.04),(0.62386,-0.1777,-0.04),(0.63072,-0.18763,-0.04),(0.63633,-0.19833,-0.04),(0.64061,-0.20962,-0.04),(0.6435,-0.22134,-0.04),(0.64496,-0.23333,-0.04),(0.64496,-0.24541,-0.04),(0.6435,-0.25739,-0.04),(0.64061,-0.26912,-0.04),(0.63633,-0.28041,-0.04),(0.63072,-0.2911,-0.04),(0.62386,-0.30104,-0.04),(0.61585,-0.31008,-0.04),(0.60681,-0.31809,-0.04),(0.59687,-0.32495,-0.04),(0.58618,-0.33056,-0.04),(0.57489,-0.33484,-0.04),(0.56316,-0.33773,-0.04),(0.55118,-0.33918,-0.04),(0.5391,-0.33918,-0.04),(0.52711,-0.33773,-0.04),(0.51539,-0.33484,-0.04),(0.5041,-0.33056,-0.04),(0.49341,-0.32495,-0.04),(0.48347,-0.31809,-0.04),(0.47443,-0.31008,0),(0.48347,-0.31809,0),(0.49341,-0.32495,0),(0.5041,-0.33056,0),(0.51539,-0.33484,0),(0.52711,-0.33773,0),(0.5391,-0.33918,0),(0.55118,-0.33918,0),(0.56316,-0.33773,0),(0.57489,-0.33484,0),(0.58618,-0.33056,0),(0.59687,-0.32495,0),(0.60681,-0.31809,0),(0.61585,-0.31008,0),(0.62386,-0.30104,0),(0.63072,-0.2911,0),(0.63633,-0.28041,0),(0.64061,-0.26912,0),(0.6435,-0.25739,0),(0.64496,-0.24541,0),(0.64496,-0.23333,0),(0.6435,-0.22134,0),(0.64061,-0.20962,0),(0.63633,-0.19833,0),(0.63072,-0.18763,0),(0.62386,-0.1777,0),(0.61585,-0.16866,0),(0.60681,-0.16065,0),(0.59687,-0.15379,0),(0.58618,-0.14818,0),(0.57489,-0.1439,0),(0.56316,-0.14101,0),(0.55118,-0.13955,0),(0.5391,-0.13955,0),(0.52711,-0.14101,0),(0.51539,-0.1439,0),(0.5041,-0.14818,0),(0.49341,-0.15379,0),(0.48347,-0.16065,0),(0.47443,-0.16866,0),(0.46642,-0.1777,0),(0.45956,-0.18763,0),(0.45395,-0.19833,0),(0.44967,-0.20962,0),(0.44678,-0.22134,0),(0.44532,-0.23333,0),(0.44532,-0.24541,0),(0.44678,-0.25739,0),(0.44967,-0.26912,0),(0.45395,-0.28041,0),(0.45956,-0.2911,0),(0.46642,-0.30104,0.0)]),
          normal=Normal(vector=[(0.70711,0.70711,0),(0.78718,0.61672,0),(0.85578,0.51734,0),(0.9119,0.41041,0),(0.95472,0.2975,0),(0.98362,0.18026,0),(0.99818,0.06038,0),(0.99818,-0.06038,-0.0),(0.98362,-0.18026,-0.0),(0.95472,-0.2975,-0.0),(0.9119,-0.41041,-0.0),(0.85578,-0.51734,-0.0),(0.78718,-0.61672,-0.0),(0.70711,-0.70711,-0.0),(0.61672,-0.78718,-0.0),(0.51734,-0.85578,-0.0),(0.41041,-0.9119,-0.0),(0.2975,-0.95472,-0.0),(0.18026,-0.98362,-0.0),(0.06038,-0.99818,-0.0),(-0.06038,-0.99818,-0.0),(-0.18026,-0.98362,-0.0),(-0.2975,-0.95472,-0.0),(-0.41041,-0.9119,-0.0),(-0.51734,-0.85578,-0.0),(-0.61672,-0.78718,-0.0),(-0.70711,-0.70711,-0.0),(-0.78718,-0.61672,-0.0),(-0.85578,-0.51734,-0.0),(-0.9119,-0.41041,-0.0),(-0.95472,-0.2975,-0.0),(-0.98362,-0.18026,-0.0),(-0.99818,-0.06038,-0.0),(-0.99818,0.06038,0),(-0.98362,0.18026,0),(-0.95472,0.2975,0),(-0.9119,0.41041,0),(-0.85578,0.51734,0),(-0.78718,0.61672,0),(-0.70711,0.70711,0),(-0.61672,0.78718,0),(-0.51734,0.85578,0),(-0.41041,0.9119,0),(-0.2975,0.95472,0),(-0.18026,0.98362,0),(-0.06038,0.99818,0),(0.06038,0.99818,0),(0.18026,0.98362,0),(0.2975,0.95472,0),(0.41041,0.9119,0),(0.51734,0.85578,0),(0.61672,0.78718,0),(0.70711,0.70711,0),(0.61672,0.78718,0),(0.51734,0.85578,0),(0.41041,0.9119,0),(0.2975,0.95472,0),(0.18026,0.98362,0),(0.06038,0.99818,0),(-0.06038,0.99818,0),(-0.18026,0.98362,0),(-0.2975,0.95472,0),(-0.41041,0.9119,0),(-0.51734,0.85578,0),(-0.61672,0.78718,0),(-0.70711,0.70711,0),(-0.78718,0.61672,0),(-0.85578,0.51734,0),(-0.9119,0.41041,0),(-0.95472,0.2975,0),(-0.98362,0.18026,0),(-0.99818,0.06038,0),(-0.99818,-0.06038,-0.0),(-0.98362,-0.18026,-0.0),(-0.95472,-0.2975,-0.0),(-0.9119,-0.41041,-0.0),(-0.85578,-0.51734,-0.0),(-0.78718,-0.61672,-0.0),(-0.70711,-0.70711,-0.0),(-0.61672,-0.78718,-0.0),(-0.51734,-0.85578,-0.0),(-0.41041,-0.9119,-0.0),(-0.2975,-0.95472,-0.0),(-0.18026,-0.98362,-0.0),(-0.06038,-0.99818,-0.0),(0.06038,-0.99818,-0.0),(0.18026,-0.98362,-0.0),(0.2975,-0.95472,-0.0),(0.41041,-0.9119,-0.0),(0.51734,-0.85578,-0.0),(0.61672,-0.78718,-0.0),(0.70711,-0.70711,-0.0),(0.78718,-0.61672,-0.0),(0.85578,-0.51734,-0.0),(0.9119,-0.41041,-0.0),(0.95472,-0.2975,-0.0),(0.98362,-0.18026,-0.0),(0.99818,-0.06038,-0.0),(0.99818,0.06038,0),(0.98362,0.18026,0),(0.95472,0.2975,0),(0.9119,0.41041,0),(0.85578,0.51734,0),(0.78718,0.61672,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,52,0,-1,1,103,52,-1,1,2,103,-1,103,2,102,-1,102,2,3,-1,101,3,4,-1,100,4,5,-1,99,5,6,-1,98,6,7,-1,97,7,8,-1,96,8,9,-1,95,9,10,-1,94,10,11,-1,93,11,12,-1,92,12,13,-1,91,13,14,-1,90,14,15,-1,89,15,16,-1,88,16,17,-1,87,17,18,-1,86,18,19,-1,85,19,20,-1,84,20,21,-1,83,21,22,-1,82,22,23,-1,81,23,24,-1,80,24,25,-1,79,25,26,-1,78,26,27,-1,77,27,28,-1,76,28,29,-1,75,29,30,-1,74,30,31,-1,73,31,32,-1,72,32,33,-1,71,33,34,-1,70,34,35,-1,69,35,36,-1,68,36,37,-1,67,37,38,-1,66,38,39,-1,65,39,40,-1,64,40,41,-1,63,41,42,-1,62,42,43,-1,61,43,44,-1,60,44,45,-1,59,45,46,-1,58,46,47,-1,57,47,48,-1,56,48,49,-1,55,49,50,-1,54,50,51,-1,53,51,0,-1,52,53,0,-1,102,3,101,-1,101,4,100,-1,100,5,99,-1,99,6,98,-1,98,7,97,-1,97,8,96,-1,96,9,95,-1,95,10,94,-1,94,11,93,-1,93,12,92,-1,92,13,91,-1,91,14,90,-1,90,15,89,-1,89,16,88,-1,88,17,87,-1,87,18,86,-1,86,19,85,-1,85,20,84,-1,84,21,83,-1,83,22,82,-1,82,23,81,-1,81,24,80,-1,80,25,79,-1,79,26,78,-1,78,27,77,-1,77,28,76,-1,76,29,75,-1,75,30,74,-1,74,31,73,-1,73,32,72,-1,72,33,71,-1,71,34,70,-1,70,35,69,-1,69,36,68,-1,68,37,67,-1,67,38,66,-1,66,39,65,-1,65,40,64,-1,64,41,63,-1,63,42,62,-1,62,43,61,-1,61,44,60,-1,60,45,59,-1,59,46,58,-1,58,47,57,-1,57,48,56,-1,56,49,55,-1,55,50,54,-1,54,51,53,-1],solid=False,
          coord=Coordinate(point=[(0.54514,-0.33937,-0.29819),(0.53309,-0.33864,-0.29841),(0.52121,-0.33646,-0.29906),(0.50968,-0.33287,-0.30014),(0.49867,-0.32791,-0.30163),(0.48833,-0.32167,-0.3035),(0.47883,-0.31422,-0.30573),(0.47029,-0.30568,-0.3083),(0.46284,-0.29617,-0.31115),(0.45659,-0.28584,-0.31425),(0.45164,-0.27483,-0.31755),(0.44804,-0.2633,-0.32101),(0.44587,-0.25142,-0.32457),(0.44514,-0.23937,-0.32819),(0.44587,-0.22731,-0.33181),(0.44804,-0.21544,-0.33537),(0.45164,-0.20391,-0.33883),(0.45659,-0.1929,-0.34213),(0.46284,-0.18256,-0.34523),(0.47029,-0.17306,-0.34808),(0.47883,-0.16452,-0.35065),(0.48833,-0.15707,-0.35288),(0.49867,-0.15082,-0.35475),(0.50968,-0.14587,-0.35624),(0.52121,-0.14227,-0.35732),(0.53309,-0.1401,-0.35797),(0.54514,-0.13937,-0.35819),(0.55719,-0.1401,-0.35797),(0.56907,-0.14227,-0.35732),(0.5806,-0.14587,-0.35624),(0.59161,-0.15082,-0.35475),(0.60195,-0.15707,-0.35288),(0.61145,-0.16452,-0.35065),(0.61999,-0.17306,-0.34808),(0.62744,-0.18256,-0.34523),(0.63368,-0.1929,-0.34213),(0.63864,-0.20391,-0.33883),(0.64223,-0.21544,-0.33537),(0.64441,-0.22731,-0.33181),(0.64514,-0.23937,-0.32819),(0.64441,-0.25142,-0.32457),(0.64223,-0.2633,-0.32101),(0.63864,-0.27483,-0.31755),(0.63368,-0.28584,-0.31425),(0.62744,-0.29617,-0.31115),(0.61999,-0.30568,-0.3083),(0.61145,-0.31422,-0.30573),(0.60195,-0.32167,-0.3035),(0.59161,-0.32791,-0.30163),(0.5806,-0.33287,-0.30014),(0.56907,-0.33646,-0.29906),(0.55719,-0.33864,-0.29841),(0.54514,-0.33937,-0.26951),(0.55719,-0.33864,-0.2697),(0.56907,-0.33646,-0.27028),(0.5806,-0.33287,-0.27124),(0.59161,-0.32791,-0.27256),(0.60195,-0.32167,-0.27423),(0.61145,-0.31422,-0.27621),(0.61999,-0.30568,-0.27849),(0.62744,-0.29617,-0.28102),(0.63368,-0.28584,-0.28378),(0.63864,-0.27483,-0.28672),(0.64223,-0.2633,-0.28979),(0.64441,-0.25142,-0.29296),(0.64514,-0.23937,-0.29617),(0.64441,-0.22731,-0.29939),(0.64223,-0.21544,-0.30256),(0.63864,-0.20391,-0.30563),(0.63368,-0.1929,-0.30857),(0.62744,-0.18256,-0.31132),(0.61999,-0.17306,-0.31386),(0.61145,-0.16452,-0.31613),(0.60195,-0.15707,-0.31812),(0.59161,-0.15082,-0.31979),(0.5806,-0.14587,-0.32111),(0.56907,-0.14227,-0.32207),(0.55719,-0.1401,-0.32265),(0.54514,-0.13937,-0.32284),(0.53309,-0.1401,-0.32265),(0.52121,-0.14227,-0.32207),(0.50968,-0.14587,-0.32111),(0.49867,-0.15082,-0.31979),(0.48833,-0.15707,-0.31812),(0.47883,-0.16452,-0.31613),(0.47029,-0.17306,-0.31386),(0.46284,-0.18256,-0.31132),(0.45659,-0.1929,-0.30857),(0.45164,-0.20391,-0.30563),(0.44804,-0.21544,-0.30256),(0.44587,-0.22731,-0.29939),(0.44514,-0.23937,-0.29617),(0.44587,-0.25142,-0.29296),(0.44804,-0.2633,-0.28979),(0.45164,-0.27483,-0.28672),(0.45659,-0.28584,-0.28378),(0.46284,-0.29617,-0.28102),(0.47029,-0.30568,-0.27849),(0.47883,-0.31422,-0.27621),(0.48833,-0.32167,-0.27423),(0.49867,-0.32791,-0.27256),(0.50968,-0.33287,-0.27124),(0.52121,-0.33646,-0.27028),(0.53309,-0.33864,-0.2697)]),
          normal=Normal(vector=[(0.0,1.0,0),(0.12054,0.99271,0),(0.23932,0.97094,0),(0.3546,0.93502,0),(0.46472,0.88546,0),(0.56806,0.82298,0),(0.66312,0.74851,0),(0.74851,0.66312,0),(0.82298,0.56806,0),(0.88546,0.46472,0),(0.93502,0.3546,0),(0.97094,0.23932,0),(0.99271,0.12054,0),(1.0,-0.0,-0.0),(0.99271,-0.12054,-0.0),(0.97094,-0.23932,-0.0),(0.93502,-0.3546,-0.0),(0.88546,-0.46472,-0.0),(0.82298,-0.56806,-0.0),(0.74851,-0.66312,-0.0),(0.66312,-0.74851,-0.0),(0.56806,-0.82298,-0.0),(0.46472,-0.88546,-0.0),(0.3546,-0.93502,-0.0),(0.23932,-0.97094,-0.0),(0.12054,-0.99271,-0.0),(0,-1.0,0),(-0.12054,-0.99271,-0.0),(-0.23932,-0.97094,-0.0),(-0.3546,-0.93502,-0.0),(-0.46472,-0.88546,-0.0),(-0.56806,-0.82298,-0.0),(-0.66312,-0.74851,-0.0),(-0.74851,-0.66312,-0.0),(-0.82298,-0.56806,-0.0),(-0.88546,-0.46472,-0.0),(-0.93502,-0.3546,-0.0),(-0.97094,-0.23932,-0.0),(-0.99271,-0.12054,-0.0),(-1.0,0,0),(-0.99271,0.12054,0),(-0.97094,0.23932,0),(-0.93502,0.3546,0),(-0.88546,0.46472,0),(-0.82298,0.56806,0),(-0.74851,0.66312,0),(-0.66312,0.74851,0),(-0.56806,0.82298,0),(-0.46472,0.88546,0),(-0.3546,0.93502,0),(-0.23932,0.97094,0),(-0.12054,0.99271,0),(0,1.0,0),(-0.12054,0.99271,0),(-0.23932,0.97094,0),(-0.3546,0.93502,0),(-0.46472,0.88546,0),(-0.56806,0.82298,0),(-0.66312,0.74851,0),(-0.74851,0.66312,0),(-0.82298,0.56806,0),(-0.88546,0.46472,0),(-0.93502,0.3546,0),(-0.97094,0.23932,0),(-0.99271,0.12054,0),(-1.0,0,0),(-0.99271,-0.12054,-0.0),(-0.97094,-0.23932,-0.0),(-0.93502,-0.3546,-0.0),(-0.88546,-0.46472,-0.0),(-0.82298,-0.56806,-0.0),(-0.74851,-0.66312,-0.0),(-0.66312,-0.74851,-0.0),(-0.56806,-0.82298,-0.0),(-0.46472,-0.88546,-0.0),(-0.3546,-0.93502,-0.0),(-0.23932,-0.97094,-0.0),(-0.12054,-0.99271,-0.0),(0,-1.0,0),(0.12054,-0.99271,-0.0),(0.23932,-0.97094,-0.0),(0.3546,-0.93502,-0.0),(0.46472,-0.88546,-0.0),(0.56806,-0.82298,-0.0),(0.66312,-0.74851,-0.0),(0.74851,-0.66312,-0.0),(0.82298,-0.56806,-0.0),(0.88546,-0.46472,-0.0),(0.93502,-0.3546,-0.0),(0.97094,-0.23932,-0.0),(0.99271,-0.12054,-0.0),(1.0,-0.0,-0.0),(0.99271,0.12054,0),(0.97094,0.23932,0),(0.93502,0.3546,0),(0.88546,0.46472,0),(0.82298,0.56806,0),(0.74851,0.66312,0),(0.66312,0.74851,0),(0.56806,0.82298,0),(0.46472,0.88546,0),(0.3546,0.93502,0),(0.23932,0.97094,0),(0.12054,0.99271,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,31,1,2,-1,30,2,3,-1,4,30,3,-1,4,29,30,-1,4,5,29,-1,29,5,28,-1,28,5,6,-1,27,6,7,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,32,1,31,-1,31,2,30,-1,28,6,27,-1,27,7,26,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(-0.75,0.405,-0.04),(-0.75,0.40919,-0.04018),(-0.75,0.41335,-0.0407),(-0.75,0.41745,-0.04157),(-0.75,0.42146,-0.04278),(-0.75,0.42535,-0.04433),(-0.75,0.42909,-0.04622),(-0.75,0.43263,-0.04843),(-0.75,0.43595,-0.05097),(-0.75,0.43901,-0.05381),(-0.75,0.44177,-0.05694),(-0.75,0.44418,-0.06033),(-0.75,0.44622,-0.06395),(-0.75,0.44785,-0.06779),(-0.75,0.44904,-0.07177),(-0.75,0.44976,-0.07585),(-0.75,0.45,-0.08),(-0.4,0.45,-0.08),(-0.4,0.44982,-0.07641),(-0.4,0.44925,-0.07273),(-0.4,0.44826,-0.069),(-0.4,0.44684,-0.06528),(-0.4,0.44497,-0.06163),(-0.4,0.44266,-0.05812),(-0.4,0.43994,-0.05479),(-0.4,0.43682,-0.05172),(-0.4,0.43336,-0.04895),(-0.4,0.42962,-0.04652),(-0.4,0.42567,-0.04447),(-0.4,0.42156,-0.04281),(-0.4,0.41738,-0.04155),(-0.4,0.41319,-0.04067),(-0.4,0.40904,-0.04017),(-0.4,0.405,-0.04)]),
          normal=Normal(vector=[(0.0,0,-1.0),(-0.0,-0.08281,-0.99657),(-0.0,-0.16549,-0.98621),(-0.0,-0.24789,-0.96879),(-0.0,-0.32979,-0.94405),(-0.0,-0.41092,-0.91167),(-0.0,-0.49075,-0.8713),(-0.0,-0.56869,-0.82255),(-0.0,-0.64408,-0.76496),(-0.0,-0.71606,-0.69804),(-0.0,-0.78315,-0.62184),(-0.0,-0.84391,-0.53649),(-0.0,-0.89696,-0.44211),(-0.0,-0.94066,-0.33936),(-0.0,-0.97311,-0.23036),(-0.0,-0.99317,-0.11667),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-0.99489,-0.10098),(-0.0,-0.97901,-0.20381),(-0.0,-0.95188,-0.30649),(-0.0,-0.9135,-0.40685),(-0.0,-0.8644,-0.50281),(-0.0,-0.80557,-0.5925),(-0.0,-0.73837,-0.67439),(-0.0,-0.66436,-0.74741),(-0.0,-0.58519,-0.81089),(-0.0,-0.50245,-0.8646),(-0.0,-0.41761,-0.90863),(-0.0,-0.33195,-0.9433),(-0.0,-0.24655,-0.96913),(-0.0,-0.16231,-0.98674),(-0.0,-0.07994,-0.9968),(0,0,-1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.405,-0.04),(-0.75,0.405,-0.04),(-0.4,0.405,-0.04),(-0.4,-0.405,-0.04)]),
          normal=Normal(vector=[(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,31,1,2,-1,30,2,3,-1,29,3,4,-1,28,4,5,-1,27,5,6,-1,26,6,7,-1,25,7,8,-1,24,8,9,-1,23,9,10,-1,22,10,11,-1,21,11,12,-1,20,12,13,-1,14,20,13,-1,14,19,20,-1,14,15,19,-1,19,15,18,-1,18,15,16,-1,17,18,16,-1,32,1,31,-1,31,2,30,-1,30,3,29,-1,29,4,28,-1,28,5,27,-1,27,6,26,-1,26,7,25,-1,25,8,24,-1,24,9,23,-1,23,10,22,-1,22,11,21,-1,21,12,20,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.45,-0.08),(-0.75,-0.44976,-0.07585),(-0.75,-0.44904,-0.07177),(-0.75,-0.44785,-0.06779),(-0.75,-0.44622,-0.06395),(-0.75,-0.44418,-0.06033),(-0.75,-0.44176,-0.05694),(-0.75,-0.43901,-0.05381),(-0.75,-0.43595,-0.05096),(-0.75,-0.43263,-0.04843),(-0.75,-0.42909,-0.04622),(-0.75,-0.42535,-0.04433),(-0.75,-0.42146,-0.04278),(-0.75,-0.41745,-0.04157),(-0.75,-0.41335,-0.0407),(-0.75,-0.40919,-0.04018),(-0.75,-0.405,-0.04),(-0.4,-0.405,-0.04),(-0.4,-0.40904,-0.04017),(-0.4,-0.41319,-0.04067),(-0.4,-0.41738,-0.04155),(-0.4,-0.42156,-0.04281),(-0.4,-0.42567,-0.04447),(-0.4,-0.42962,-0.04652),(-0.4,-0.43336,-0.04895),(-0.4,-0.43682,-0.05172),(-0.4,-0.43994,-0.05479),(-0.4,-0.44266,-0.05812),(-0.4,-0.44497,-0.06163),(-0.4,-0.44684,-0.06528),(-0.4,-0.44826,-0.069),(-0.4,-0.44925,-0.07273),(-0.4,-0.44982,-0.07641),(-0.4,-0.45,-0.08)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,0.99317,-0.11669),(0,0.97309,-0.23042),(0,0.94061,-0.33949),(0,0.8969,-0.44224),(0,0.84386,-0.53656),(0,0.78311,-0.62188),(0,0.71603,-0.69807),(0,0.64405,-0.76499),(0,0.56866,-0.82257),(0,0.49074,-0.87131),(0,0.41093,-0.91167),(0,0.32979,-0.94405),(0,0.24794,-0.96877),(0,0.1656,-0.98619),(0,0.0829,-0.99656),(0,0,-1.0),(0,0,-1.0),(0,0.07994,-0.9968),(0,0.16231,-0.98674),(0,0.24655,-0.96913),(0,0.33195,-0.9433),(0,0.41761,-0.90863),(0,0.50245,-0.8646),(0,0.58519,-0.81089),(0,0.66436,-0.74741),(0,0.73837,-0.67439),(0,0.80557,-0.5925),(0,0.8644,-0.50281),(0,0.9135,-0.40685),(0,0.95188,-0.30649),(0,0.97901,-0.20381),(0,0.99489,-0.10098),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.45,-0.21024),(-0.75,-0.45,-0.08),(-0.4,-0.45,-0.08),(-0.4,-0.45,-0.21024)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,2,32,1,-1,2,31,32,-1,2,3,31,-1,31,3,30,-1,30,3,4,-1,29,4,5,-1,28,5,6,-1,27,6,7,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,30,4,29,-1,29,5,28,-1,28,6,27,-1,27,7,26,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.41793,-0.24856),(-0.75,-0.42116,-0.24758),(-0.75,-0.4243,-0.24638),(-0.75,-0.42736,-0.24496),(-0.75,-0.43031,-0.24332),(-0.75,-0.43312,-0.24147),(-0.75,-0.43578,-0.23942),(-0.75,-0.43828,-0.23716),(-0.75,-0.44059,-0.23472),(-0.75,-0.44269,-0.2321),(-0.75,-0.44455,-0.22932),(-0.75,-0.44617,-0.22639),(-0.75,-0.44753,-0.22332),(-0.75,-0.4486,-0.22014),(-0.75,-0.44937,-0.2169),(-0.75,-0.44984,-0.21359),(-0.75,-0.45,-0.21024),(-0.4,-0.45,-0.21024),(-0.4,-0.44987,-0.21326),(-0.4,-0.44948,-0.21633),(-0.4,-0.4488,-0.21942),(-0.4,-0.44784,-0.2225),(-0.4,-0.44658,-0.22554),(-0.4,-0.44503,-0.22852),(-0.4,-0.4432,-0.23139),(-0.4,-0.4411,-0.23412),(-0.4,-0.43876,-0.23669),(-0.4,-0.43619,-0.23907),(-0.4,-0.43343,-0.24125),(-0.4,-0.43052,-0.24319),(-0.4,-0.42747,-0.2449),(-0.4,-0.42434,-0.24636),(-0.4,-0.42115,-0.24758),(-0.4,-0.41793,-0.24856)]),
          normal=Normal(vector=[(0.0,0.25766,0.96623),(0,0.32355,0.94621),(0,0.38891,0.92127),(0,0.45358,0.89121),(0,0.51733,0.85579),(0,0.57971,0.81482),(0,0.64034,0.76809),(0,0.69876,0.71535),(0,0.75431,0.65652),(0,0.80612,0.59175),(0,0.85351,0.52107),(0,0.89574,0.44457),(0,0.93196,0.36257),(0,0.96109,0.27624),(0,0.98246,0.18648),(0,0.99556,0.09409),(0,1.0,-0.0),(0,1.0,-0.0),(0,0.9964,0.08481),(0,0.98534,0.17062),(0,0.96661,0.25625),(0,0.94024,0.34052),(0,0.90649,0.42222),(0,0.86587,0.50027),(0,0.81904,0.57373),(0,0.76682,0.64186),(0,0.71011,0.7041),(0,0.6498,0.7601),(0,0.5868,0.80973),(0,0.52195,0.85298),(0,0.45599,0.88999),(0,0.38959,0.92099),(0,0.32332,0.94629),(0,0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.01293,-0.35656),(-0.75,-0.41793,-0.24856),(-0.4,-0.41793,-0.24856),(-0.4,-0.01293,-0.35656)]),
          normal=Normal(vector=[(0.0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[17,0,16,-1,16,0,1,-1,15,1,2,-1,14,2,3,-1,13,3,4,-1,5,13,4,-1,5,12,13,-1,5,6,12,-1,12,6,11,-1,11,6,7,-1,10,7,8,-1,9,10,8,-1,16,1,15,-1,15,2,14,-1,14,3,13,-1,11,7,10,-1],solid=False,
          coord=Coordinate(point=[(-0.75,0.01293,-0.35656),(-0.75,0.00975,-0.35729),(-0.75,0.00652,-0.35782),(-0.75,0.00327,-0.35814),(-0.75,0,-0.35824),(-0.75,-0.00327,-0.35814),(-0.75,-0.00652,-0.35782),(-0.75,-0.00975,-0.35729),(-0.75,-0.01293,-0.35656),(-0.4,-0.01293,-0.35656),(-0.4,-0.00979,-0.35729),(-0.4,-0.00657,-0.35781),(-0.4,-0.0033,-0.35814),(-0.4,0,-0.35824),(-0.4,0.0033,-0.35814),(-0.4,0.00657,-0.35781),(-0.4,0.00979,-0.35729),(-0.4,0.01293,-0.35656)]),
          normal=Normal(vector=[(-0.0,-0.25766,0.96623),(-0.0,-0.19347,0.98111),(-0.0,-0.12908,0.99163),(-0.0,-0.06458,0.99791),(-0.0,-0.0,1.0),(0,0.06458,0.99791),(0,0.12908,0.99163),(0,0.19347,0.98111),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.19432,0.98094),(0,0.13005,0.99151),(0,0.06518,0.99787),(-0.0,-0.0,1.0),(-0.0,-0.06518,0.99787),(-0.0,-0.13005,0.99151),(-0.0,-0.19432,0.98094),(-0.0,-0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.75,0.41793,-0.24856),(-0.75,0.01293,-0.35656),(-0.4,0.01293,-0.35656),(-0.4,0.41793,-0.24856)]),
          normal=Normal(vector=[(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,31,1,2,-1,30,2,3,-1,29,3,4,-1,28,4,5,-1,27,5,6,-1,26,6,7,-1,25,7,8,-1,24,8,9,-1,23,9,10,-1,22,10,11,-1,21,11,12,-1,20,12,13,-1,19,13,14,-1,18,14,15,-1,16,18,15,-1,16,17,18,-1,32,1,31,-1,31,2,30,-1,30,3,29,-1,29,4,28,-1,28,5,27,-1,27,6,26,-1,26,7,25,-1,25,8,24,-1,24,9,23,-1,23,10,22,-1,22,11,21,-1,21,12,20,-1,20,13,19,-1,19,14,18,-1],solid=False,
          coord=Coordinate(point=[(-0.75,0.45,-0.21024),(-0.75,0.44984,-0.21359),(-0.75,0.44937,-0.21691),(-0.75,0.44859,-0.22017),(-0.75,0.44752,-0.22335),(-0.75,0.44616,-0.22642),(-0.75,0.44453,-0.22935),(-0.75,0.44266,-0.23214),(-0.75,0.44057,-0.23475),(-0.75,0.43827,-0.23718),(-0.75,0.43577,-0.23943),(-0.75,0.4331,-0.24148),(-0.75,0.43029,-0.24333),(-0.75,0.42735,-0.24496),(-0.75,0.4243,-0.24638),(-0.75,0.42116,-0.24758),(-0.75,0.41793,-0.24856),(-0.4,0.41793,-0.24856),(-0.4,0.42115,-0.24758),(-0.4,0.42434,-0.24636),(-0.4,0.42747,-0.2449),(-0.4,0.43052,-0.24319),(-0.4,0.43343,-0.24125),(-0.4,0.43619,-0.23907),(-0.4,0.43876,-0.23669),(-0.4,0.4411,-0.23412),(-0.4,0.4432,-0.23139),(-0.4,0.44503,-0.22852),(-0.4,0.44658,-0.22554),(-0.4,0.44784,-0.2225),(-0.4,0.4488,-0.21942),(-0.4,0.44948,-0.21633),(-0.4,0.44987,-0.21326),(-0.4,0.45,-0.21024)]),
          normal=Normal(vector=[(-0.0,-1.0,-0.0),(-0.0,-0.99556,0.09415),(-0.0,-0.98239,0.18682),(-0.0,-0.96085,0.27707),(-0.0,-0.93159,0.36351),(-0.0,-0.89539,0.44529),(-0.0,-0.853,0.52191),(-0.0,-0.80547,0.59264),(-0.0,-0.75367,0.65725),(-0.0,-0.69833,0.71578),(-0.0,-0.64005,0.76833),(-0.0,-0.57938,0.81506),(-0.0,-0.51704,0.85596),(-0.0,-0.45344,0.89129),(-0.0,-0.38888,0.92129),(-0.0,-0.32356,0.94621),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.32332,0.94629),(-0.0,-0.38959,0.92099),(-0.0,-0.45599,0.88999),(-0.0,-0.52195,0.85298),(-0.0,-0.5868,0.80973),(-0.0,-0.6498,0.7601),(-0.0,-0.71011,0.7041),(-0.0,-0.76682,0.64186),(-0.0,-0.81904,0.57373),(-0.0,-0.86587,0.50027),(-0.0,-0.90649,0.42222),(-0.0,-0.94024,0.34052),(-0.0,-0.96661,0.25625),(-0.0,-0.98534,0.17062),(-0.0,-0.9964,0.08481),(-0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(-0.75,0.45,-0.08),(-0.75,0.45,-0.21024),(-0.4,0.45,-0.21024),(-0.4,0.45,-0.08)]),
          normal=Normal(vector=[(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[76,0,30,-1,31,76,30,-1,31,32,76,-1,76,32,33,-1,34,76,33,-1,34,75,76,-1,34,74,75,-1,34,73,74,-1,34,72,73,-1,34,71,72,-1,34,70,71,-1,34,69,70,-1,34,68,69,-1,34,67,68,-1,34,35,67,-1,67,35,36,-1,37,67,36,-1,37,38,67,-1,67,38,66,-1,66,38,65,-1,65,38,39,-1,64,39,40,-1,63,40,41,-1,62,41,42,-1,61,42,60,-1,61,62,42,-1,2,29,1,-1,2,28,29,-1,2,3,28,-1,28,3,17,-1,18,28,17,-1,18,19,28,-1,28,19,20,-1,21,28,20,-1,21,22,28,-1,28,22,23,-1,24,28,23,-1,24,25,28,-1,28,25,26,-1,27,28,26,-1,4,5,3,-1,3,5,6,-1,7,3,6,-1,7,8,3,-1,3,8,9,-1,10,3,9,-1,10,11,3,-1,3,11,12,-1,13,3,12,-1,13,14,3,-1,3,14,15,-1,16,3,15,-1,16,17,3,-1,29,30,1,-1,1,30,0,-1,65,39,64,-1,64,40,63,-1,63,41,62,-1,42,43,60,-1,60,43,59,-1,59,43,44,-1,58,44,45,-1,57,45,46,-1,56,46,55,-1,56,57,46,-1,59,44,58,-1,58,45,57,-1,46,47,55,-1,55,47,54,-1,54,47,48,-1,53,48,49,-1,52,49,50,-1,51,52,50,-1,54,48,53,-1,53,49,52,-1],solid=False,
          coord=Coordinate(point=[(-0.4,-0.41793,-0.24856),(-0.4,-0.42115,-0.24758),(-0.4,-0.42434,-0.24636),(-0.4,-0.42747,-0.2449),(-0.4,-0.43052,-0.24319),(-0.4,-0.43343,-0.24125),(-0.4,-0.43619,-0.23907),(-0.4,-0.43876,-0.23669),(-0.4,-0.4411,-0.23412),(-0.4,-0.4432,-0.23139),(-0.4,-0.44503,-0.22852),(-0.4,-0.44658,-0.22554),(-0.4,-0.44784,-0.2225),(-0.4,-0.4488,-0.21942),(-0.4,-0.44948,-0.21633),(-0.4,-0.44987,-0.21326),(-0.4,-0.45,-0.21024),(-0.4,-0.45,-0.08),(-0.4,-0.44982,-0.07641),(-0.4,-0.44925,-0.07273),(-0.4,-0.44826,-0.069),(-0.4,-0.44684,-0.06528),(-0.4,-0.44497,-0.06163),(-0.4,-0.44266,-0.05812),(-0.4,-0.43994,-0.05479),(-0.4,-0.43682,-0.05172),(-0.4,-0.43336,-0.04895),(-0.4,-0.42962,-0.04652),(-0.4,-0.42567,-0.04447),(-0.4,-0.42156,-0.04281),(-0.4,-0.41738,-0.04155),(-0.4,-0.41319,-0.04067),(-0.4,-0.40904,-0.04017),(-0.4,-0.405,-0.04),(-0.4,0.405,-0.04),(-0.4,0.40904,-0.04017),(-0.4,0.41319,-0.04067),(-0.4,0.41738,-0.04155),(-0.4,0.42156,-0.04281),(-0.4,0.42567,-0.04447),(-0.4,0.42962,-0.04652),(-0.4,0.43336,-0.04895),(-0.4,0.43682,-0.05172),(-0.4,0.43994,-0.05479),(-0.4,0.44266,-0.05812),(-0.4,0.44497,-0.06163),(-0.4,0.44684,-0.06528),(-0.4,0.44826,-0.069),(-0.4,0.44925,-0.07273),(-0.4,0.44982,-0.07641),(-0.4,0.45,-0.08),(-0.4,0.45,-0.21024),(-0.4,0.44987,-0.21326),(-0.4,0.44948,-0.21633),(-0.4,0.4488,-0.21942),(-0.4,0.44784,-0.2225),(-0.4,0.44658,-0.22554),(-0.4,0.44503,-0.22852),(-0.4,0.4432,-0.23139),(-0.4,0.4411,-0.23412),(-0.4,0.43876,-0.23669),(-0.4,0.43619,-0.23907),(-0.4,0.43343,-0.24125),(-0.4,0.43052,-0.24319),(-0.4,0.42747,-0.2449),(-0.4,0.42434,-0.24636),(-0.4,0.42115,-0.24758),(-0.4,0.41793,-0.24856),(-0.4,0.01293,-0.35656),(-0.4,0.00979,-0.35729),(-0.4,0.00657,-0.35781),(-0.4,0.0033,-0.35814),(-0.4,0,-0.35824),(-0.4,-0.0033,-0.35814),(-0.4,-0.00657,-0.35781),(-0.4,-0.00979,-0.35729),(-0.4,-0.01293,-0.35656)]),
          normal=Normal(vector=[(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0),(-1.0,0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,17,0,-1,1,16,17,-1,1,15,16,-1,1,14,15,-1,1,13,14,-1,1,12,13,-1,1,11,12,-1,1,10,11,-1,1,9,10,-1,1,8,9,-1,1,7,8,-1,1,6,7,-1,1,5,6,-1,1,4,5,-1,1,2,4,-1,4,2,55,-1,55,2,54,-1,54,2,53,-1,53,2,52,-1,52,2,51,-1,51,2,50,-1,50,2,49,-1,49,2,48,-1,48,2,47,-1,47,2,46,-1,46,2,45,-1,45,2,44,-1,44,2,43,-1,43,2,42,-1,42,2,3,-1,41,3,40,-1,41,42,3,-1,0,30,3,-1,0,29,30,-1,0,28,29,-1,0,27,28,-1,0,26,27,-1,0,25,26,-1,0,24,25,-1,0,23,24,-1,0,22,23,-1,0,21,22,-1,0,20,21,-1,0,19,20,-1,0,18,19,-1,0,17,18,-1,30,31,3,-1,3,31,32,-1,33,3,32,-1,33,34,3,-1,3,34,35,-1,36,3,35,-1,36,37,3,-1,3,37,38,-1,39,3,38,-1,39,40,3,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.01293,-0.35656),(0.375,-0.41793,-0.24856),(0.75,-0.41793,-0.24856),(0.75,-0.01293,-0.35656),(0.54514,-0.33937,-0.26951),(0.53309,-0.33864,-0.2697),(0.52121,-0.33646,-0.27028),(0.50968,-0.33287,-0.27124),(0.49867,-0.32791,-0.27256),(0.48833,-0.32167,-0.27423),(0.47883,-0.31422,-0.27621),(0.47029,-0.30568,-0.27849),(0.46284,-0.29617,-0.28102),(0.45659,-0.28584,-0.28378),(0.45164,-0.27483,-0.28672),(0.44804,-0.2633,-0.28979),(0.44587,-0.25142,-0.29296),(0.44514,-0.23937,-0.29617),(0.44587,-0.22731,-0.29939),(0.44804,-0.21544,-0.30256),(0.45164,-0.20391,-0.30563),(0.45659,-0.1929,-0.30857),(0.46284,-0.18256,-0.31132),(0.47029,-0.17306,-0.31386),(0.47883,-0.16452,-0.31613),(0.48833,-0.15707,-0.31812),(0.49867,-0.15082,-0.31979),(0.50968,-0.14587,-0.32111),(0.52121,-0.14227,-0.32207),(0.53309,-0.1401,-0.32265),(0.54514,-0.13937,-0.32284),(0.55719,-0.1401,-0.32265),(0.56907,-0.14227,-0.32207),(0.5806,-0.14587,-0.32111),(0.59161,-0.15082,-0.31979),(0.60195,-0.15707,-0.31812),(0.61145,-0.16452,-0.31613),(0.61999,-0.17306,-0.31386),(0.62744,-0.18256,-0.31132),(0.63368,-0.1929,-0.30857),(0.63864,-0.20391,-0.30563),(0.64223,-0.21544,-0.30256),(0.64441,-0.22731,-0.29939),(0.64514,-0.23937,-0.29617),(0.64441,-0.25142,-0.29296),(0.64223,-0.2633,-0.28979),(0.63864,-0.27483,-0.28672),(0.63368,-0.28584,-0.28378),(0.62744,-0.29617,-0.28102),(0.61999,-0.30568,-0.27849),(0.61145,-0.31422,-0.27621),(0.60195,-0.32167,-0.27423),(0.59161,-0.32791,-0.27256),(0.5806,-0.33287,-0.27124),(0.56907,-0.33646,-0.27028),(0.55719,-0.33864,-0.2697)]),
          normal=Normal(vector=[(0.0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[17,0,16,-1,16,0,1,-1,2,16,1,-1,2,15,16,-1,2,3,15,-1,15,3,14,-1,14,3,4,-1,13,4,5,-1,12,5,6,-1,11,6,7,-1,10,7,9,-1,10,11,7,-1,14,4,13,-1,13,5,12,-1,12,6,11,-1,7,8,9,-1],solid=False,
          coord=Coordinate(point=[(0.375,0.01293,-0.35656),(0.375,0.00979,-0.35729),(0.375,0.00657,-0.35781),(0.375,0.0033,-0.35814),(0.375,0,-0.35824),(0.375,-0.0033,-0.35814),(0.375,-0.00657,-0.35781),(0.375,-0.00979,-0.35729),(0.375,-0.01293,-0.35656),(0.75,-0.01293,-0.35656),(0.75,-0.00979,-0.35729),(0.75,-0.00657,-0.35781),(0.75,-0.0033,-0.35814),(0.75,0,-0.35824),(0.75,0.0033,-0.35814),(0.75,0.00657,-0.35781),(0.75,0.00979,-0.35729),(0.75,0.01293,-0.35656)]),
          normal=Normal(vector=[(-0.0,-0.25766,0.96623),(-0.0,-0.19432,0.98094),(-0.0,-0.13005,0.99151),(-0.0,-0.06518,0.99787),(-0.0,-0.0,1.0),(0,0.06518,0.99787),(0,0.13005,0.99151),(0,0.19432,0.98094),(0,0.25766,0.96623),(0,0.25766,0.96623),(0,0.19432,0.98094),(0,0.13005,0.99151),(0,0.06518,0.99787),(-0.0,-0.0,1.0),(-0.0,-0.06518,0.99787),(-0.0,-0.13005,0.99151),(-0.0,-0.19432,0.98094),(-0.0,-0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.375,0.41793,-0.24856),(0.375,0.01293,-0.35656),(0.75,0.01293,-0.35656),(0.75,0.41793,-0.24856)]),
          normal=Normal(vector=[(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,33,-1,33,1,32,-1,32,1,2,-1,31,2,3,-1,30,3,4,-1,29,4,5,-1,28,5,6,-1,27,6,7,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,32,2,31,-1,31,3,30,-1,30,4,29,-1,29,5,28,-1,28,6,27,-1,27,7,26,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(0.375,0.45,-0.21024),(0.375,0.44987,-0.21326),(0.375,0.44948,-0.21633),(0.375,0.4488,-0.21942),(0.375,0.44784,-0.2225),(0.375,0.44658,-0.22554),(0.375,0.44503,-0.22852),(0.375,0.4432,-0.23139),(0.375,0.4411,-0.23412),(0.375,0.43876,-0.23669),(0.375,0.43619,-0.23907),(0.375,0.43343,-0.24125),(0.375,0.43052,-0.24319),(0.375,0.42747,-0.2449),(0.375,0.42434,-0.24636),(0.375,0.42115,-0.24758),(0.375,0.41793,-0.24856),(0.75,0.41793,-0.24856),(0.75,0.42115,-0.24758),(0.75,0.42434,-0.24636),(0.75,0.42747,-0.2449),(0.75,0.43052,-0.24319),(0.75,0.43343,-0.24125),(0.75,0.43619,-0.23907),(0.75,0.43876,-0.23669),(0.75,0.4411,-0.23412),(0.75,0.4432,-0.23139),(0.75,0.44503,-0.22852),(0.75,0.44658,-0.22554),(0.75,0.44784,-0.2225),(0.75,0.4488,-0.21942),(0.75,0.44948,-0.21633),(0.75,0.44987,-0.21326),(0.75,0.45,-0.21024)]),
          normal=Normal(vector=[(-0.0,-1.0,-0.0),(-0.0,-0.9964,0.08481),(-0.0,-0.98534,0.17062),(-0.0,-0.96661,0.25625),(-0.0,-0.94024,0.34052),(-0.0,-0.90649,0.42222),(-0.0,-0.86587,0.50027),(-0.0,-0.81904,0.57373),(-0.0,-0.76682,0.64186),(-0.0,-0.71011,0.7041),(-0.0,-0.6498,0.7601),(-0.0,-0.5868,0.80973),(-0.0,-0.52195,0.85298),(-0.0,-0.45599,0.88999),(-0.0,-0.38959,0.92099),(-0.0,-0.32332,0.94629),(-0.0,-0.25766,0.96623),(-0.0,-0.25766,0.96623),(-0.0,-0.32332,0.94629),(-0.0,-0.38959,0.92099),(-0.0,-0.45599,0.88999),(-0.0,-0.52195,0.85298),(-0.0,-0.5868,0.80973),(-0.0,-0.6498,0.7601),(-0.0,-0.71011,0.7041),(-0.0,-0.76682,0.64186),(-0.0,-0.81904,0.57373),(-0.0,-0.86587,0.50027),(-0.0,-0.90649,0.42222),(-0.0,-0.94024,0.34052),(-0.0,-0.96661,0.25625),(-0.0,-0.98534,0.17062),(-0.0,-0.9964,0.08481),(-0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.375,0.45,-0.08),(0.375,0.45,-0.21024),(0.75,0.45,-0.21024),(0.75,0.45,-0.08)]),
          normal=Normal(vector=[(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,31,1,2,-1,3,31,2,-1,3,30,31,-1,3,4,30,-1,30,4,29,-1,29,4,5,-1,28,5,6,-1,27,6,26,-1,27,28,6,-1,32,1,31,-1,29,5,28,-1,6,7,26,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(0.375,0.405,-0.04),(0.375,0.40904,-0.04017),(0.375,0.41319,-0.04067),(0.375,0.41738,-0.04155),(0.375,0.42156,-0.04281),(0.375,0.42567,-0.04447),(0.375,0.42962,-0.04652),(0.375,0.43336,-0.04895),(0.375,0.43682,-0.05172),(0.375,0.43994,-0.05479),(0.375,0.44266,-0.05812),(0.375,0.44497,-0.06163),(0.375,0.44684,-0.06528),(0.375,0.44826,-0.069),(0.375,0.44925,-0.07273),(0.375,0.44982,-0.07641),(0.375,0.45,-0.08),(0.75,0.45,-0.08),(0.75,0.44982,-0.07641),(0.75,0.44925,-0.07273),(0.75,0.44826,-0.069),(0.75,0.44684,-0.06528),(0.75,0.44497,-0.06163),(0.75,0.44266,-0.05812),(0.75,0.43994,-0.05479),(0.75,0.43682,-0.05172),(0.75,0.43336,-0.04895),(0.75,0.42962,-0.04652),(0.75,0.42567,-0.04447),(0.75,0.42156,-0.04281),(0.75,0.41738,-0.04155),(0.75,0.41319,-0.04067),(0.75,0.40904,-0.04017),(0.75,0.405,-0.04)]),
          normal=Normal(vector=[(0.0,0,-1.0),(-0.0,-0.07994,-0.9968),(-0.0,-0.16231,-0.98674),(-0.0,-0.24655,-0.96913),(-0.0,-0.33195,-0.9433),(-0.0,-0.41761,-0.90863),(-0.0,-0.50245,-0.8646),(-0.0,-0.58519,-0.81089),(-0.0,-0.66436,-0.74741),(-0.0,-0.73837,-0.67439),(-0.0,-0.80557,-0.5925),(-0.0,-0.8644,-0.50281),(-0.0,-0.9135,-0.40685),(-0.0,-0.95188,-0.30649),(-0.0,-0.97901,-0.20381),(-0.0,-0.99489,-0.10098),(-0.0,-1.0,0),(-0.0,-1.0,0),(-0.0,-0.99489,-0.10098),(-0.0,-0.97901,-0.20381),(-0.0,-0.95188,-0.30649),(-0.0,-0.9135,-0.40685),(-0.0,-0.8644,-0.50281),(-0.0,-0.80557,-0.5925),(-0.0,-0.73837,-0.67439),(-0.0,-0.66436,-0.74741),(-0.0,-0.58519,-0.81089),(-0.0,-0.50245,-0.8646),(-0.0,-0.41761,-0.90863),(-0.0,-0.33195,-0.9433),(-0.0,-0.24655,-0.96913),(-0.0,-0.16231,-0.98674),(-0.0,-0.07994,-0.9968),(0,0,-1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,48,0,-1,1,47,48,-1,1,46,47,-1,1,45,46,-1,1,44,45,-1,1,43,44,-1,1,42,43,-1,1,41,42,-1,1,40,41,-1,1,39,40,-1,1,38,39,-1,1,37,38,-1,1,36,37,-1,1,2,36,-1,36,2,35,-1,35,2,34,-1,34,2,33,-1,33,2,32,-1,32,2,31,-1,31,2,30,-1,30,2,29,-1,29,2,28,-1,28,2,27,-1,27,2,26,-1,26,2,3,-1,25,3,24,-1,25,26,3,-1,0,11,3,-1,0,10,11,-1,0,9,10,-1,0,8,9,-1,0,7,8,-1,0,6,7,-1,0,5,6,-1,0,4,5,-1,0,55,4,-1,0,54,55,-1,0,53,54,-1,0,52,53,-1,0,51,52,-1,0,50,51,-1,0,49,50,-1,0,48,49,-1,11,12,3,-1,3,12,13,-1,14,3,13,-1,14,15,3,-1,3,15,16,-1,17,3,16,-1,17,18,3,-1,3,18,19,-1,20,3,19,-1,20,21,3,-1,3,21,22,-1,23,3,22,-1,23,24,3,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.405,-0.04),(0.375,0.405,-0.04),(0.75,0.405,-0.04),(0.75,-0.405,-0.04),(0.47443,-0.31008,-0.04),(0.48347,-0.31809,-0.04),(0.49341,-0.32495,-0.04),(0.5041,-0.33056,-0.04),(0.51539,-0.33484,-0.04),(0.52711,-0.33773,-0.04),(0.5391,-0.33918,-0.04),(0.55118,-0.33918,-0.04),(0.56316,-0.33773,-0.04),(0.57489,-0.33484,-0.04),(0.58618,-0.33056,-0.04),(0.59687,-0.32495,-0.04),(0.60681,-0.31809,-0.04),(0.61585,-0.31008,-0.04),(0.62386,-0.30104,-0.04),(0.63072,-0.2911,-0.04),(0.63633,-0.28041,-0.04),(0.64061,-0.26912,-0.04),(0.6435,-0.25739,-0.04),(0.64496,-0.24541,-0.04),(0.64496,-0.23333,-0.04),(0.6435,-0.22134,-0.04),(0.64061,-0.20962,-0.04),(0.63633,-0.19833,-0.04),(0.63072,-0.18763,-0.04),(0.62386,-0.1777,-0.04),(0.61585,-0.16866,-0.04),(0.60681,-0.16065,-0.04),(0.59687,-0.15379,-0.04),(0.58618,-0.14818,-0.04),(0.57489,-0.1439,-0.04),(0.56316,-0.14101,-0.04),(0.55118,-0.13955,-0.04),(0.5391,-0.13955,-0.04),(0.52711,-0.14101,-0.04),(0.51539,-0.1439,-0.04),(0.5041,-0.14818,-0.04),(0.49341,-0.15379,-0.04),(0.48347,-0.16065,-0.04),(0.47443,-0.16866,-0.04),(0.46642,-0.1777,-0.04),(0.45956,-0.18763,-0.04),(0.45395,-0.19833,-0.04),(0.44967,-0.20962,-0.04),(0.44678,-0.22134,-0.04),(0.44532,-0.23333,-0.04),(0.44532,-0.24541,-0.04),(0.44678,-0.25739,-0.04),(0.44967,-0.26912,-0.04),(0.45395,-0.28041,-0.04),(0.45956,-0.2911,-0.04),(0.46642,-0.30104,-0.04)]),
          normal=Normal(vector=[(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0),(-0.0,-0.0,-1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[33,0,32,-1,32,0,1,-1,31,1,2,-1,30,2,3,-1,29,3,4,-1,5,29,4,-1,5,28,29,-1,5,6,28,-1,28,6,27,-1,27,6,26,-1,26,6,7,-1,8,26,7,-1,8,25,26,-1,8,9,25,-1,25,9,24,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,19,-1,20,21,13,-1,32,1,31,-1,31,2,30,-1,30,3,29,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,13,14,19,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.45,-0.08),(0.375,-0.44982,-0.07641),(0.375,-0.44925,-0.07273),(0.375,-0.44826,-0.069),(0.375,-0.44684,-0.06528),(0.375,-0.44497,-0.06163),(0.375,-0.44266,-0.05812),(0.375,-0.43994,-0.05479),(0.375,-0.43682,-0.05172),(0.375,-0.43336,-0.04895),(0.375,-0.42962,-0.04652),(0.375,-0.42567,-0.04447),(0.375,-0.42156,-0.04281),(0.375,-0.41738,-0.04155),(0.375,-0.41319,-0.04067),(0.375,-0.40904,-0.04017),(0.375,-0.405,-0.04),(0.75,-0.405,-0.04),(0.75,-0.40904,-0.04017),(0.75,-0.41319,-0.04067),(0.75,-0.41738,-0.04155),(0.75,-0.42156,-0.04281),(0.75,-0.42567,-0.04447),(0.75,-0.42962,-0.04652),(0.75,-0.43336,-0.04895),(0.75,-0.43682,-0.05172),(0.75,-0.43994,-0.05479),(0.75,-0.44266,-0.05812),(0.75,-0.44497,-0.06163),(0.75,-0.44684,-0.06528),(0.75,-0.44826,-0.069),(0.75,-0.44925,-0.07273),(0.75,-0.44982,-0.07641),(0.75,-0.45,-0.08)]),
          normal=Normal(vector=[(0.0,1.0,0),(0,0.99489,-0.10098),(0,0.97901,-0.20381),(0,0.95188,-0.30649),(0,0.9135,-0.40685),(0,0.8644,-0.50281),(0,0.80557,-0.5925),(0,0.73837,-0.67439),(0,0.66436,-0.74741),(0,0.58519,-0.81089),(0,0.50245,-0.8646),(0,0.41761,-0.90863),(0,0.33195,-0.9433),(0,0.24655,-0.96913),(0,0.16231,-0.98674),(0,0.07994,-0.9968),(0,0,-1.0),(0,0,-1.0),(0,0.07994,-0.9968),(0,0.16231,-0.98674),(0,0.24655,-0.96913),(0,0.33195,-0.9433),(0,0.41761,-0.90863),(0,0.50245,-0.8646),(0,0.58519,-0.81089),(0,0.66436,-0.74741),(0,0.73837,-0.67439),(0,0.80557,-0.5925),(0,0.8644,-0.50281),(0,0.9135,-0.40685),(0,0.95188,-0.30649),(0,0.97901,-0.20381),(0,0.99489,-0.10098),(0,1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.45,-0.21024),(0.375,-0.45,-0.08),(0.75,-0.45,-0.08),(0.75,-0.45,-0.21024)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,33,-1,33,1,32,-1,32,1,2,-1,31,2,3,-1,30,3,4,-1,29,4,5,-1,28,5,6,-1,27,6,7,-1,26,7,8,-1,25,8,9,-1,24,9,10,-1,23,10,11,-1,22,11,12,-1,21,12,13,-1,20,13,14,-1,19,14,15,-1,18,15,16,-1,17,18,16,-1,32,2,31,-1,31,3,30,-1,30,4,29,-1,29,5,28,-1,28,6,27,-1,27,7,26,-1,26,8,25,-1,25,9,24,-1,24,10,23,-1,23,11,22,-1,22,12,21,-1,21,13,20,-1,20,14,19,-1,19,15,18,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.41793,-0.24856),(0.375,-0.42115,-0.24758),(0.375,-0.42434,-0.24636),(0.375,-0.42747,-0.2449),(0.375,-0.43052,-0.24319),(0.375,-0.43343,-0.24125),(0.375,-0.43619,-0.23907),(0.375,-0.43876,-0.23669),(0.375,-0.4411,-0.23412),(0.375,-0.4432,-0.23139),(0.375,-0.44503,-0.22852),(0.375,-0.44658,-0.22554),(0.375,-0.44784,-0.2225),(0.375,-0.4488,-0.21942),(0.375,-0.44948,-0.21633),(0.375,-0.44987,-0.21326),(0.375,-0.45,-0.21024),(0.75,-0.45,-0.21024),(0.75,-0.44987,-0.21326),(0.75,-0.44948,-0.21633),(0.75,-0.4488,-0.21942),(0.75,-0.44784,-0.2225),(0.75,-0.44658,-0.22554),(0.75,-0.44503,-0.22852),(0.75,-0.4432,-0.23139),(0.75,-0.4411,-0.23412),(0.75,-0.43876,-0.23669),(0.75,-0.43619,-0.23907),(0.75,-0.43343,-0.24125),(0.75,-0.43052,-0.24319),(0.75,-0.42747,-0.2449),(0.75,-0.42434,-0.24636),(0.75,-0.42115,-0.24758),(0.75,-0.41793,-0.24856)]),
          normal=Normal(vector=[(0.0,0.25766,0.96623),(0,0.32332,0.94629),(0,0.38959,0.92099),(0,0.45599,0.88999),(0,0.52195,0.85298),(0,0.5868,0.80973),(0,0.6498,0.7601),(0,0.71011,0.7041),(0,0.76682,0.64186),(0,0.81904,0.57373),(0,0.86587,0.50027),(0,0.90649,0.42222),(0,0.94024,0.34052),(0,0.96661,0.25625),(0,0.98534,0.17062),(0,0.9964,0.08481),(0,1.0,0),(0,1.0,0),(0,0.9964,0.08481),(0,0.98534,0.17062),(0,0.96661,0.25625),(0,0.94024,0.34052),(0,0.90649,0.42222),(0,0.86587,0.50027),(0,0.81904,0.57373),(0,0.76682,0.64186),(0,0.71011,0.7041),(0,0.6498,0.7601),(0,0.5868,0.80973),(0,0.52195,0.85298),(0,0.45599,0.88999),(0,0.38959,0.92099),(0,0.32332,0.94629),(0,0.25766,0.96623)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[76,0,47,-1,48,76,47,-1,48,75,76,-1,48,49,75,-1,75,49,74,-1,74,49,61,-1,62,74,61,-1,62,63,74,-1,74,63,64,-1,65,74,64,-1,65,66,74,-1,74,66,67,-1,68,74,67,-1,68,69,74,-1,74,69,70,-1,71,74,70,-1,71,72,74,-1,74,72,73,-1,2,43,1,-1,2,3,43,-1,43,3,4,-1,5,43,4,-1,5,6,43,-1,43,6,7,-1,8,43,7,-1,8,9,43,-1,43,9,10,-1,42,10,41,-1,42,43,10,-1,11,39,10,-1,11,12,39,-1,39,12,38,-1,38,12,13,-1,37,13,14,-1,36,14,15,-1,35,15,16,-1,17,35,16,-1,17,34,35,-1,17,18,34,-1,34,18,33,-1,33,18,19,-1,32,19,20,-1,31,20,21,-1,22,31,21,-1,22,30,31,-1,22,23,30,-1,30,23,29,-1,29,23,24,-1,28,24,25,-1,27,25,26,-1,27,28,25,-1,38,13,37,-1,37,14,36,-1,36,15,35,-1,33,19,32,-1,32,20,31,-1,29,24,28,-1,39,40,10,-1,10,40,41,-1,43,44,1,-1,1,44,45,-1,46,1,45,-1,46,47,1,-1,1,47,0,-1,50,52,49,-1,50,51,52,-1,52,53,49,-1,49,53,54,-1,55,49,54,-1,55,56,49,-1,49,56,57,-1,58,49,57,-1,58,59,49,-1,49,59,60,-1,61,49,60,-1],solid=False,
          coord=Coordinate(point=[(0.375,-0.41793,-0.24856),(0.375,-0.01293,-0.35656),(0.375,-0.00979,-0.35729),(0.375,-0.00657,-0.35781),(0.375,-0.0033,-0.35814),(0.375,0,-0.35824),(0.375,0.0033,-0.35814),(0.375,0.00657,-0.35781),(0.375,0.00979,-0.35729),(0.375,0.01293,-0.35656),(0.375,0.41793,-0.24856),(0.375,0.42115,-0.24758),(0.375,0.42434,-0.24636),(0.375,0.42747,-0.2449),(0.375,0.43052,-0.24319),(0.375,0.43343,-0.24125),(0.375,0.43619,-0.23907),(0.375,0.43876,-0.23669),(0.375,0.4411,-0.23412),(0.375,0.4432,-0.23139),(0.375,0.44503,-0.22852),(0.375,0.44658,-0.22554),(0.375,0.44784,-0.2225),(0.375,0.4488,-0.21942),(0.375,0.44948,-0.21633),(0.375,0.44987,-0.21326),(0.375,0.45,-0.21024),(0.375,0.45,-0.08),(0.375,0.44982,-0.07641),(0.375,0.44925,-0.07273),(0.375,0.44826,-0.069),(0.375,0.44684,-0.06528),(0.375,0.44497,-0.06163),(0.375,0.44266,-0.05812),(0.375,0.43994,-0.05479),(0.375,0.43682,-0.05172),(0.375,0.43336,-0.04895),(0.375,0.42962,-0.04652),(0.375,0.42567,-0.04447),(0.375,0.42156,-0.04281),(0.375,0.41738,-0.04155),(0.375,0.41319,-0.04067),(0.375,0.40904,-0.04017),(0.375,0.405,-0.04),(0.375,-0.405,-0.04),(0.375,-0.40904,-0.04017),(0.375,-0.41319,-0.04067),(0.375,-0.41738,-0.04155),(0.375,-0.42156,-0.04281),(0.375,-0.42567,-0.04447),(0.375,-0.42962,-0.04652),(0.375,-0.43336,-0.04895),(0.375,-0.43682,-0.05172),(0.375,-0.43994,-0.05479),(0.375,-0.44266,-0.05812),(0.375,-0.44497,-0.06163),(0.375,-0.44684,-0.06528),(0.375,-0.44826,-0.069),(0.375,-0.44925,-0.07273),(0.375,-0.44982,-0.07641),(0.375,-0.45,-0.08),(0.375,-0.45,-0.21024),(0.375,-0.44987,-0.21326),(0.375,-0.44948,-0.21633),(0.375,-0.4488,-0.21942),(0.375,-0.44784,-0.2225),(0.375,-0.44658,-0.22554),(0.375,-0.44503,-0.22852),(0.375,-0.4432,-0.23139),(0.375,-0.4411,-0.23412),(0.375,-0.43876,-0.23669),(0.375,-0.43619,-0.23907),(0.375,-0.43343,-0.24125),(0.375,-0.43052,-0.24319),(0.375,-0.42747,-0.2449),(0.375,-0.42434,-0.24636),(0.375,-0.42115,-0.24758)]),
          normal=Normal(vector=[(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0),(1.0,-0.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,54,0,-1,1,53,54,-1,1,52,53,-1,1,51,52,-1,1,50,51,-1,1,49,50,-1,1,48,49,-1,1,47,48,-1,1,46,47,-1,1,45,46,-1,1,44,45,-1,1,43,44,-1,1,2,43,-1,43,2,42,-1,42,2,41,-1,41,2,40,-1,40,2,39,-1,39,2,38,-1,38,2,37,-1,37,2,36,-1,36,2,35,-1,35,2,34,-1,34,2,33,-1,33,2,32,-1,32,2,3,-1,31,3,30,-1,31,32,3,-1,0,17,3,-1,0,16,17,-1,0,15,16,-1,0,14,15,-1,0,13,14,-1,0,12,13,-1,0,11,12,-1,0,10,11,-1,0,9,10,-1,0,8,9,-1,0,7,8,-1,0,6,7,-1,0,5,6,-1,0,4,5,-1,0,55,4,-1,0,54,55,-1,17,18,3,-1,3,18,19,-1,20,3,19,-1,20,21,3,-1,3,21,22,-1,23,3,22,-1,23,24,3,-1,3,24,25,-1,26,3,25,-1,26,27,3,-1,3,27,28,-1,29,3,28,-1,29,30,3,-1],solid=False,
          coord=Coordinate(point=[(0.75,-0.46437,-0.26069),(-0.75,-0.46437,-0.26069),(-0.75,-0.01437,-0.39569),(0.75,-0.01437,-0.39569),(0.54514,-0.33937,-0.29819),(0.55719,-0.33864,-0.29841),(0.56907,-0.33646,-0.29906),(0.5806,-0.33287,-0.30014),(0.59161,-0.32791,-0.30163),(0.60195,-0.32167,-0.3035),(0.61145,-0.31422,-0.30573),(0.61999,-0.30568,-0.3083),(0.62744,-0.29617,-0.31115),(0.63368,-0.28584,-0.31425),(0.63864,-0.27483,-0.31755),(0.64223,-0.2633,-0.32101),(0.64441,-0.25142,-0.32457),(0.64514,-0.23937,-0.32819),(0.64441,-0.22731,-0.33181),(0.64223,-0.21544,-0.33537),(0.63864,-0.20391,-0.33883),(0.63368,-0.1929,-0.34213),(0.62744,-0.18256,-0.34523),(0.61999,-0.17306,-0.34808),(0.61145,-0.16452,-0.35065),(0.60195,-0.15707,-0.35288),(0.59161,-0.15082,-0.35475),(0.5806,-0.14587,-0.35624),(0.56907,-0.14227,-0.35732),(0.55719,-0.1401,-0.35797),(0.54514,-0.13937,-0.35819),(0.53309,-0.1401,-0.35797),(0.52121,-0.14227,-0.35732),(0.50968,-0.14587,-0.35624),(0.49867,-0.15082,-0.35475),(0.48833,-0.15707,-0.35288),(0.47883,-0.16452,-0.35065),(0.47029,-0.17306,-0.34808),(0.46284,-0.18256,-0.34523),(0.45659,-0.1929,-0.34213),(0.45164,-0.20391,-0.33883),(0.44804,-0.21544,-0.33537),(0.44587,-0.22731,-0.33181),(0.44514,-0.23937,-0.32819),(0.44587,-0.25142,-0.32457),(0.44804,-0.2633,-0.32101),(0.45164,-0.27483,-0.31755),(0.45659,-0.28584,-0.31425),(0.46284,-0.29617,-0.31115),(0.47029,-0.30568,-0.3083),(0.47883,-0.31422,-0.30573),(0.48833,-0.32167,-0.3035),(0.49867,-0.32791,-0.30163),(0.50968,-0.33287,-0.30014),(0.52121,-0.33646,-0.29906),(0.53309,-0.33864,-0.29841)]),
          normal=Normal(vector=[(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.75,-0.46437,-0.26069),(0.75,-0.46983,-0.2587),(0.75,-0.47502,-0.25609),(0.75,-0.47987,-0.25289),(0.75,-0.48433,-0.24915),(0.75,-0.48831,-0.24493),(0.75,-0.49178,-0.24026),(0.75,-0.49469,-0.23523),(0.75,-0.49699,-0.22989),(0.75,-0.49865,-0.22432),(0.75,-0.49966,-0.2186),(0.75,-0.5,-0.2128),(-0.75,-0.5,-0.2128),(-0.75,-0.49966,-0.2186),(-0.75,-0.49865,-0.22432),(-0.75,-0.49699,-0.22989),(-0.75,-0.49469,-0.23523),(-0.75,-0.49178,-0.24026),(-0.75,-0.48831,-0.24493),(-0.75,-0.48433,-0.24915),(-0.75,-0.47987,-0.25289),(-0.75,-0.47502,-0.25609),(-0.75,-0.46983,-0.2587),(-0.75,-0.46437,-0.26069)]),
          normal=Normal(vector=[(-0.0,-0.28735,-0.95783),(-0.0,-0.39655,-0.91801),(-0.0,-0.5004,-0.86579),(-0.0,-0.59749,-0.80188),(-0.0,-0.6865,-0.72713),(-0.0,-0.76624,-0.64255),(-0.0,-0.83563,-0.54929),(-0.0,-0.89373,-0.44861),(-0.0,-0.93975,-0.34187),(-0.0,-0.97307,-0.23052),(-0.0,-0.99324,-0.11604),(-0.0,-1.0,-0.0),(-0.0,-1.0,-0.0),(-0.0,-0.99324,-0.11604),(-0.0,-0.97307,-0.23052),(-0.0,-0.93975,-0.34187),(-0.0,-0.89373,-0.44861),(-0.0,-0.83563,-0.54929),(-0.0,-0.76624,-0.64255),(-0.0,-0.6865,-0.72713),(-0.0,-0.59749,-0.80188),(-0.0,-0.5004,-0.86579),(-0.0,-0.39655,-0.91801),(-0.0,-0.28735,-0.95783)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,73,0,-1,1,72,73,-1,1,2,72,-1,72,2,71,-1,71,2,70,-1,70,2,3,-1,69,3,4,-1,68,4,5,-1,67,5,66,-1,67,68,5,-1,70,3,69,-1,69,4,68,-1,5,6,66,-1,66,6,65,-1,65,6,7,-1,64,7,8,-1,63,8,9,-1,62,9,10,-1,11,62,10,-1,11,61,62,-1,11,60,61,-1,11,12,60,-1,60,12,59,-1,59,12,58,-1,58,12,13,-1,134,13,133,-1,134,58,13,-1,65,7,64,-1,64,8,63,-1,63,9,62,-1,13,14,133,-1,133,14,132,-1,132,14,131,-1,131,14,15,-1,130,15,16,-1,129,16,128,-1,129,130,16,-1,131,15,130,-1,16,17,128,-1,128,17,127,-1,127,17,126,-1,126,17,18,-1,125,18,124,-1,125,126,18,-1,19,40,18,-1,19,39,40,-1,19,20,39,-1,39,20,38,-1,38,20,21,-1,37,21,22,-1,36,22,23,-1,35,23,24,-1,34,24,25,-1,33,25,26,-1,32,26,27,-1,31,27,28,-1,30,28,29,-1,30,31,28,-1,38,21,37,-1,37,22,36,-1,36,23,35,-1,35,24,34,-1,34,25,33,-1,33,26,32,-1,32,27,31,-1,40,41,18,-1,18,41,42,-1,110,42,109,-1,110,18,42,-1,110,111,18,-1,18,111,112,-1,113,18,112,-1,113,114,18,-1,18,114,115,-1,116,18,115,-1,116,117,18,-1,18,117,118,-1,119,18,118,-1,119,120,18,-1,18,120,121,-1,122,18,121,-1,122,123,18,-1,18,123,124,-1,43,96,42,-1,43,95,96,-1,43,94,95,-1,43,93,94,-1,43,92,93,-1,43,44,92,-1,92,44,91,-1,91,44,90,-1,90,44,89,-1,89,44,88,-1,88,44,87,-1,87,44,86,-1,86,44,85,-1,85,44,84,-1,84,44,83,-1,83,44,82,-1,82,44,81,-1,81,44,80,-1,80,44,79,-1,79,44,78,-1,78,44,77,-1,77,44,76,-1,76,44,45,-1,55,45,54,-1,55,76,45,-1,55,56,76,-1,76,56,57,-1,0,76,57,-1,0,75,76,-1,0,74,75,-1,0,73,74,-1,46,47,45,-1,45,47,48,-1,49,45,48,-1,49,50,45,-1,45,50,51,-1,52,45,51,-1,52,53,45,-1,45,53,54,-1,96,97,42,-1,42,97,98,-1,99,42,98,-1,99,100,42,-1,42,100,101,-1,102,42,101,-1,102,103,42,-1,42,103,104,-1,105,42,104,-1,105,106,42,-1,42,106,107,-1,108,42,107,-1,108,109,42,-1],solid=False,
          coord=Coordinate(point=[(0.75,-0.5,-0.2128),(0.75,-0.49966,-0.2186),(0.75,-0.49865,-0.22432),(0.75,-0.49699,-0.22989),(0.75,-0.49469,-0.23523),(0.75,-0.49178,-0.24026),(0.75,-0.48831,-0.24493),(0.75,-0.48433,-0.24915),(0.75,-0.47987,-0.25289),(0.75,-0.47502,-0.25609),(0.75,-0.46983,-0.2587),(0.75,-0.46437,-0.26069),(0.75,-0.01437,-0.39569),(0.75,-0.0087,-0.39704),(0.75,-0.00291,-0.39771),(0.75,0.00291,-0.39771),(0.75,0.0087,-0.39704),(0.75,0.01437,-0.39569),(0.75,0.46437,-0.26069),(0.75,0.46983,-0.2587),(0.75,0.47502,-0.25609),(0.75,0.47987,-0.25289),(0.75,0.48433,-0.24915),(0.75,0.48831,-0.24493),(0.75,0.49178,-0.24026),(0.75,0.49469,-0.23523),(0.75,0.49699,-0.22989),(0.75,0.49865,-0.22432),(0.75,0.49966,-0.2186),(0.75,0.5,-0.2128),(0.75,0.5,-0.05),(0.75,0.49964,-0.04397),(0.75,0.49855,-0.03803),(0.75,0.49675,-0.03227),(0.75,0.49427,-0.02676),(0.75,0.49115,-0.0216),(0.75,0.48743,-0.01684),(0.75,0.48316,-0.01257),(0.75,0.4784,-0.00885),(0.75,0.47324,-0.00573),(0.75,0.46773,-0.00325),(0.75,0.46197,-0.00145),(0.75,0.45603,-3.6E-4),(0.75,0.45,0),(0.75,-0.45,0),(0.75,-0.45603,-3.6E-4),(0.75,-0.46197,-0.00145),(0.75,-0.46773,-0.00325),(0.75,-0.47324,-0.00573),(0.75,-0.4784,-0.00885),(0.75,-0.48316,-0.01257),(0.75,-0.48743,-0.01684),(0.75,-0.49115,-0.0216),(0.75,-0.49427,-0.02676),(0.75,-0.49675,-0.03227),(0.75,-0.49855,-0.03803),(0.75,-0.49964,-0.04397),(0.75,-0.5,-0.05),(0.75,-0.01293,-0.35656),(0.75,-0.41793,-0.24856),(0.75,-0.42115,-0.24758),(0.75,-0.42434,-0.24636),(0.75,-0.42747,-0.2449),(0.75,-0.43052,-0.24319),(0.75,-0.43343,-0.24125),(0.75,-0.43619,-0.23907),(0.75,-0.43876,-0.23669),(0.75,-0.4411,-0.23412),(0.75,-0.4432,-0.23139),(0.75,-0.44503,-0.22852),(0.75,-0.44658,-0.22554),(0.75,-0.44784,-0.2225),(0.75,-0.4488,-0.21942),(0.75,-0.44948,-0.21633),(0.75,-0.44987,-0.21326),(0.75,-0.45,-0.21024),(0.75,-0.45,-0.08),(0.75,-0.44982,-0.07641),(0.75,-0.44925,-0.07273),(0.75,-0.44826,-0.069),(0.75,-0.44684,-0.06528),(0.75,-0.44497,-0.06163),(0.75,-0.44266,-0.05812),(0.75,-0.43994,-0.05479),(0.75,-0.43682,-0.05172),(0.75,-0.43336,-0.04895),(0.75,-0.42962,-0.04652),(0.75,-0.42567,-0.04447),(0.75,-0.42156,-0.04281),(0.75,-0.41738,-0.04155),(0.75,-0.41319,-0.04067),(0.75,-0.40904,-0.04017),(0.75,-0.405,-0.04),(0.75,0.405,-0.04),(0.75,0.40904,-0.04017),(0.75,0.41319,-0.04067),(0.75,0.41738,-0.04155),(0.75,0.42156,-0.04281),(0.75,0.42567,-0.04447),(0.75,0.42962,-0.04652),(0.75,0.43336,-0.04895),(0.75,0.43682,-0.05172),(0.75,0.43994,-0.05479),(0.75,0.44266,-0.05812),(0.75,0.44497,-0.06163),(0.75,0.44684,-0.06528),(0.75,0.44826,-0.069),(0.75,0.44925,-0.07273),(0.75,0.44982,-0.07641),(0.75,0.45,-0.08),(0.75,0.45,-0.21024),(0.75,0.44987,-0.21326),(0.75,0.44948,-0.21633),(0.75,0.4488,-0.21942),(0.75,0.44784,-0.2225),(0.75,0.44658,-0.22554),(0.75,0.44503,-0.22852),(0.75,0.4432,-0.23139),(0.75,0.4411,-0.23412),(0.75,0.43876,-0.23669),(0.75,0.43619,-0.23907),(0.75,0.43343,-0.24125),(0.75,0.43052,-0.24319),(0.75,0.42747,-0.2449),(0.75,0.42434,-0.24636),(0.75,0.42115,-0.24758),(0.75,0.41793,-0.24856),(0.75,0.01293,-0.35656),(0.75,0.00979,-0.35729),(0.75,0.00657,-0.35781),(0.75,0.0033,-0.35814),(0.75,0,-0.35824),(0.75,-0.0033,-0.35814),(0.75,-0.00657,-0.35781),(0.75,-0.00979,-0.35729)]),
          normal=Normal(vector=[(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0),(1.0,-0.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,11,-1,11,1,10,-1,10,1,2,-1,9,2,3,-1,8,3,4,-1,7,4,5,-1,6,7,5,-1,10,2,9,-1,9,3,8,-1,8,4,7,-1],solid=False,
          coord=Coordinate(point=[(0.75,0.01437,-0.39569),(0.75,0.0087,-0.39704),(0.75,0.00291,-0.39771),(0.75,-0.00291,-0.39771),(0.75,-0.0087,-0.39704),(0.75,-0.01437,-0.39569),(-0.75,-0.01437,-0.39569),(-0.75,-0.0087,-0.39704),(-0.75,-0.00291,-0.39771),(-0.75,0.00291,-0.39771),(-0.75,0.0087,-0.39704),(-0.75,0.01437,-0.39569)]),
          normal=Normal(vector=[(0.0,0.28735,-0.95783),(0,0.17398,-0.98475),(0,0.05826,-0.9983),(-0.0,-0.05826,-0.9983),(-0.0,-0.17398,-0.98475),(-0.0,-0.28735,-0.95783),(-0.0,-0.28735,-0.95783),(-0.0,-0.17398,-0.98475),(-0.0,-0.05826,-0.9983),(0,0.05826,-0.9983),(0,0.17398,-0.98475),(0,0.28735,-0.95783)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,27,-1,27,1,26,-1,26,1,2,-1,25,2,3,-1,24,3,4,-1,23,4,5,-1,22,5,6,-1,21,6,7,-1,20,7,8,-1,19,8,9,-1,18,9,10,-1,17,10,11,-1,16,11,12,-1,15,12,13,-1,14,15,13,-1,26,2,25,-1,25,3,24,-1,24,4,23,-1,23,5,22,-1,22,6,21,-1,21,7,20,-1,20,8,19,-1,19,9,18,-1,18,10,17,-1,17,11,16,-1,16,12,15,-1],solid=False,
          coord=Coordinate(point=[(0.75,-0.5,-0.05),(0.75,-0.49964,-0.04397),(0.75,-0.49855,-0.03803),(0.75,-0.49675,-0.03227),(0.75,-0.49427,-0.02676),(0.75,-0.49115,-0.0216),(0.75,-0.48743,-0.01684),(0.75,-0.48316,-0.01257),(0.75,-0.4784,-0.00885),(0.75,-0.47324,-0.00573),(0.75,-0.46773,-0.00325),(0.75,-0.46197,-0.00145),(0.75,-0.45603,-3.6E-4),(0.75,-0.45,0),(-0.75,-0.45,0),(-0.75,-0.45603,-3.6E-4),(-0.75,-0.46197,-0.00145),(-0.75,-0.46773,-0.00325),(-0.75,-0.47324,-0.00573),(-0.75,-0.4784,-0.00885),(-0.75,-0.48316,-0.01257),(-0.75,-0.48743,-0.01684),(-0.75,-0.49115,-0.0216),(-0.75,-0.49427,-0.02676),(-0.75,-0.49675,-0.03227),(-0.75,-0.49855,-0.03803),(-0.75,-0.49964,-0.04397),(-0.75,-0.5,-0.05)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-0.99271,0.12054),(-0.0,-0.97094,0.23932),(-0.0,-0.93502,0.3546),(-0.0,-0.88546,0.46472),(-0.0,-0.82298,0.56806),(-0.0,-0.74851,0.66312),(-0.0,-0.66312,0.74851),(-0.0,-0.56806,0.82298),(-0.0,-0.46472,0.88546),(-0.0,-0.3546,0.93502),(-0.0,-0.23932,0.97094),(-0.0,-0.12054,0.99271),(-0.0,-0.0,1.0),(0,0,1.0),(-0.0,-0.12054,0.99271),(-0.0,-0.23932,0.97094),(-0.0,-0.3546,0.93502),(-0.0,-0.46472,0.88546),(-0.0,-0.56806,0.82298),(-0.0,-0.66312,0.74851),(-0.0,-0.74851,0.66312),(-0.0,-0.82298,0.56806),(-0.0,-0.88546,0.46472),(-0.0,-0.93502,0.3546),(-0.0,-0.97094,0.23932),(-0.0,-0.99271,0.12054),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[69,0,54,-1,55,69,54,-1,55,68,69,-1,55,67,68,-1,55,66,67,-1,55,65,66,-1,55,56,65,-1,65,56,64,-1,64,56,57,-1,63,57,58,-1,62,58,59,-1,61,59,60,-1,61,62,59,-1,0,1,54,-1,54,1,2,-1,3,54,2,-1,3,17,54,-1,3,4,17,-1,17,4,16,-1,16,4,5,-1,15,5,14,-1,15,16,5,-1,5,6,14,-1,14,6,13,-1,13,6,7,-1,12,7,8,-1,9,12,8,-1,9,10,12,-1,12,10,11,-1,13,7,12,-1,54,17,53,-1,53,17,18,-1,52,18,19,-1,51,19,20,-1,50,20,21,-1,49,21,22,-1,48,22,23,-1,24,48,23,-1,24,47,48,-1,24,25,47,-1,47,25,46,-1,46,25,26,-1,45,26,44,-1,45,46,26,-1,53,18,52,-1,52,19,51,-1,51,20,50,-1,50,21,49,-1,49,22,48,-1,26,27,44,-1,44,27,43,-1,43,27,28,-1,42,28,29,-1,41,29,30,-1,40,30,31,-1,39,31,32,-1,38,32,33,-1,37,33,34,-1,36,34,35,-1,36,37,34,-1,43,28,42,-1,42,29,41,-1,41,30,40,-1,40,31,39,-1,39,32,38,-1,38,33,37,-1,64,57,63,-1,63,58,62,-1],solid=False,
          coord=Coordinate(point=[(-0.04773,-0.25877,0),(-0.04579,-0.25871,0),(-0.04384,-0.25852,0),(-0.03993,-0.25779,0),(-0.03607,-0.25661,0),(-0.03234,-0.25501,0),(-0.0288,-0.25302,0),(-0.02555,-0.25067,0),(-0.02405,-0.24936,0),(-0.02264,-0.24798,0),(-0.02135,-0.24652,0),(-0.02017,-0.24499,0),(-0.01759,-0.24034,0),(-0.01546,-0.23545,0),(-0.01375,-0.23036,0),(-0.01243,-0.22512,0),(-0.01081,-0.21439,0),(-0.01032,-0.20364,0),(-0.0107,-0.19283,0),(-0.01216,-0.18198,0),(-0.01343,-0.17671,0),(-0.01516,-0.17163,0),(-0.01738,-0.16681,0),(-0.0187,-0.16451,0),(-0.02017,-0.1623,0),(-0.02238,-0.15918,0),(-0.025,-0.15626,0),(-0.02796,-0.15358,0),(-0.0312,-0.15124,0),(-0.03466,-0.14929,0),(-0.03646,-0.14849,0),(-0.03828,-0.14782,0),(-0.04013,-0.14728,0),(-0.042,-0.14688,0),(-0.04388,-0.14663,0),(-0.04576,-0.14655,0),(-0.04775,-0.14663,0),(-0.04975,-0.14686,0),(-0.05175,-0.14723,0),(-0.05374,-0.14775,0),(-0.05571,-0.1484,0),(-0.05765,-0.14917,0),(-0.06141,-0.15106,0),(-0.06493,-0.15337,0),(-0.06814,-0.15605,0),(-0.0696,-0.15751,0),(-0.07096,-0.15905,0),(-0.07221,-0.16064,0),(-0.07332,-0.1623,0),(-0.07566,-0.167,0),(-0.07749,-0.17193,0),(-0.07887,-0.17704,0),(-0.07987,-0.18228,0),(-0.08095,-0.19298,0),(-0.0812,-0.20364,0),(-0.08085,-0.21426,0),(-0.07961,-0.22487,0),(-0.07857,-0.23009,0),(-0.0772,-0.23521,0),(-0.07546,-0.24018,0),(-0.07332,-0.24499,0),(-0.071,-0.24784,0),(-0.06831,-0.25047,0),(-0.06531,-0.25281,0),(-0.06205,-0.25483,0),(-0.0586,-0.25649,0),(-0.05502,-0.25772,0),(-0.05321,-0.25817,0),(-0.05138,-0.2585,0),(-0.04955,-0.2587,0.0)]),
          normal=Normal(vector=[(0.0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0),(0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,23,-1,23,1,22,-1,22,1,2,-1,21,2,3,-1,20,3,4,-1,19,4,5,-1,18,5,6,-1,17,6,7,-1,16,7,8,-1,15,8,9,-1,14,9,10,-1,13,10,11,-1,12,13,11,-1,22,2,21,-1,21,3,20,-1,20,4,19,-1,19,5,18,-1,18,6,17,-1,17,7,16,-1,16,8,15,-1,15,9,14,-1,14,10,13,-1],solid=False,
          coord=Coordinate(point=[(0.75,0.5,-0.2128),(0.75,0.49966,-0.2186),(0.75,0.49865,-0.22432),(0.75,0.49699,-0.22989),(0.75,0.49469,-0.23523),(0.75,0.49178,-0.24026),(0.75,0.48831,-0.24493),(0.75,0.48433,-0.24915),(0.75,0.47987,-0.25289),(0.75,0.47502,-0.25609),(0.75,0.46983,-0.2587),(0.75,0.46437,-0.26069),(-0.75,0.46437,-0.26069),(-0.75,0.46983,-0.2587),(-0.75,0.47502,-0.25609),(-0.75,0.47987,-0.25289),(-0.75,0.48433,-0.24915),(-0.75,0.48831,-0.24493),(-0.75,0.49178,-0.24026),(-0.75,0.49469,-0.23523),(-0.75,0.49699,-0.22989),(-0.75,0.49865,-0.22432),(-0.75,0.49966,-0.2186),(-0.75,0.5,-0.2128)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0,0.99324,-0.11604),(0,0.97307,-0.23052),(0,0.93975,-0.34187),(0,0.89373,-0.44861),(0,0.83563,-0.54929),(0,0.76624,-0.64255),(0,0.6865,-0.72713),(0,0.59749,-0.80188),(0,0.5004,-0.86579),(0,0.39655,-0.91801),(0,0.28735,-0.95783),(0,0.28735,-0.95783),(0,0.39655,-0.91801),(0,0.5004,-0.86579),(0,0.59749,-0.80188),(0,0.6865,-0.72713),(0,0.76624,-0.64255),(0,0.83563,-0.54929),(0,0.89373,-0.44861),(0,0.93975,-0.34187),(0,0.97307,-0.23052),(0,0.99324,-0.11604),(0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,3,-1,3,1,2,-1],solid=False,
          coord=Coordinate(point=[(0.75,0.01437,-0.39569),(-0.75,0.01437,-0.39569),(-0.75,0.46437,-0.26069),(0.75,0.46437,-0.26069)]),
          normal=Normal(vector=[(0.0,0.28735,-0.95783),(0,0.28735,-0.95783),(0,0.28735,-0.95783),(0,0.28735,-0.95783)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[0,1,27,-1,27,1,26,-1,26,1,2,-1,25,2,3,-1,24,3,4,-1,23,4,5,-1,22,5,6,-1,21,6,7,-1,20,7,8,-1,19,8,9,-1,18,9,10,-1,17,10,11,-1,16,11,12,-1,15,12,13,-1,14,15,13,-1,26,2,25,-1,25,3,24,-1,24,4,23,-1,23,5,22,-1,22,6,21,-1,21,7,20,-1,20,8,19,-1,19,9,18,-1,18,10,17,-1,17,11,16,-1,16,12,15,-1],solid=False,
          coord=Coordinate(point=[(0.75,0.45,0),(0.75,0.45603,-3.6E-4),(0.75,0.46197,-0.00145),(0.75,0.46773,-0.00325),(0.75,0.47324,-0.00573),(0.75,0.4784,-0.00885),(0.75,0.48316,-0.01257),(0.75,0.48743,-0.01684),(0.75,0.49115,-0.0216),(0.75,0.49427,-0.02676),(0.75,0.49675,-0.03227),(0.75,0.49855,-0.03803),(0.75,0.49964,-0.04397),(0.75,0.5,-0.05),(-0.75,0.5,-0.05),(-0.75,0.49964,-0.04397),(-0.75,0.49855,-0.03803),(-0.75,0.49675,-0.03227),(-0.75,0.49427,-0.02676),(-0.75,0.49115,-0.0216),(-0.75,0.48743,-0.01684),(-0.75,0.48316,-0.01257),(-0.75,0.4784,-0.00885),(-0.75,0.47324,-0.00573),(-0.75,0.46773,-0.00325),(-0.75,0.46197,-0.00145),(-0.75,0.45603,-3.6E-4),(-0.75,0.45,0.0)]),
          normal=Normal(vector=[(-0.0,-0.0,1.0),(0,0.12054,0.99271),(0,0.23932,0.97094),(0,0.3546,0.93502),(0,0.46472,0.88546),(0,0.56806,0.82298),(0,0.66312,0.74851),(0,0.74851,0.66312),(0,0.82298,0.56806),(0,0.88546,0.46472),(0,0.93502,0.3546),(0,0.97094,0.23932),(0,0.99271,0.12054),(0,1.0,-0.0),(0,1.0,-0.0),(0,0.99271,0.12054),(0,0.97094,0.23932),(0,0.93502,0.3546),(0,0.88546,0.46472),(0,0.82298,0.56806),(0,0.74851,0.66312),(0,0.66312,0.74851),(0,0.56806,0.82298),(0,0.46472,0.88546),(0,0.3546,0.93502),(0,0.23932,0.97094),(0,0.12054,0.99271),(-0.0,0,1.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(0.75,0.5,-0.2128),(-0.75,0.5,-0.2128),(-0.75,0.5,-0.05),(0.75,0.5,-0.05)]),
          normal=Normal(vector=[(0.0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0),(0,1.0,-0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,2,0,-1,0,2,3,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.5,-0.2128),(0.75,-0.5,-0.2128),(0.75,-0.5,-0.05),(-0.75,-0.5,-0.05)]),
          normal=Normal(vector=[(-0.0,-1.0,0),(-0.0,-1.0,0),(-0.0,-1.0,0),(-0.0,-1.0,0.0)]))),
      Shape(
        appearance=Appearance(USE='baseplateAppearance'),
        geometry=IndexedFaceSet(coordIndex=[1,132,0,-1,1,2,132,-1,132,2,131,-1,131,2,3,-1,130,3,4,-1,129,4,5,-1,128,5,127,-1,128,129,5,-1,131,3,130,-1,130,4,129,-1,5,6,127,-1,127,6,126,-1,126,6,7,-1,125,7,8,-1,124,8,123,-1,124,125,8,-1,126,7,125,-1,8,9,123,-1,123,9,122,-1,122,9,10,-1,121,10,120,-1,121,122,10,-1,10,11,120,-1,120,11,119,-1,119,11,12,-1,24,12,13,-1,14,24,13,-1,14,15,24,-1,24,15,16,-1,17,24,16,-1,17,18,24,-1,24,18,19,-1,20,24,19,-1,20,21,24,-1,24,21,22,-1,23,24,22,-1,119,12,24,-1,118,24,117,-1,118,119,24,-1,25,105,24,-1,25,104,105,-1,25,103,104,-1,25,102,103,-1,25,26,102,-1,102,26,101,-1,101,26,100,-1,100,26,99,-1,99,26,98,-1,98,26,97,-1,97,26,96,-1,96,26,95,-1,95,26,94,-1,94,26,93,-1,93,26,92,-1,92,26,91,-1,91,26,90,-1,90,26,89,-1,89,26,88,-1,88,26,87,-1,87,26,86,-1,86,26,85,-1,85,26,51,-1,84,51,83,-1,84,85,51,-1,26,27,51,-1,51,27,28,-1,29,51,28,-1,29,50,51,-1,29,30,50,-1,50,30,49,-1,49,30,31,-1,48,31,32,-1,47,32,33,-1,46,33,34,-1,45,34,35,-1,44,35,36,-1,43,36,37,-1,42,37,38,-1,41,38,39,-1,40,41,39,-1,49,31,48,-1,48,32,47,-1,47,33,46,-1,46,34,45,-1,45,35,44,-1,44,36,43,-1,43,37,42,-1,42,38,41,-1,52,68,51,-1,52,67,68,-1,52,66,67,-1,52,53,66,-1,66,53,65,-1,65,53,64,-1,64,53,54,-1,57,54,56,-1,57,64,54,-1,57,63,64,-1,57,62,63,-1,57,61,62,-1,57,60,61,-1,57,59,60,-1,57,0,59,-1,59,0,58,-1,58,0,134,-1,134,0,133,-1,133,0,132,-1,54,55,56,-1,68,69,51,-1,51,69,70,-1,71,51,70,-1,71,72,51,-1,51,72,73,-1,74,51,73,-1,74,75,51,-1,51,75,76,-1,77,51,76,-1,77,78,51,-1,51,78,79,-1,80,51,79,-1,80,81,51,-1,51,81,82,-1,83,51,82,-1,105,106,24,-1,24,106,107,-1,108,24,107,-1,108,109,24,-1,24,109,110,-1,111,24,110,-1,111,112,24,-1,24,112,113,-1,114,24,113,-1,114,115,24,-1,24,115,116,-1,117,24,116,-1],solid=False,
          coord=Coordinate(point=[(-0.75,-0.46437,-0.26069),(-0.75,-0.46983,-0.2587),(-0.75,-0.47502,-0.25609),(-0.75,-0.47987,-0.25289),(-0.75,-0.48433,-0.24915),(-0.75,-0.48831,-0.24493),(-0.75,-0.49178,-0.24026),(-0.75,-0.49469,-0.23523),(-0.75,-0.49699,-0.22989),(-0.75,-0.49865,-0.22432),(-0.75,-0.49966,-0.2186),(-0.75,-0.5,-0.2128),(-0.75,-0.5,-0.05),(-0.75,-0.49964,-0.04397),(-0.75,-0.49855,-0.03803),(-0.75,-0.49675,-0.03227),(-0.75,-0.49427,-0.02676),(-0.75,-0.49115,-0.0216),(-0.75,-0.48743,-0.01684),(-0.75,-0.48316,-0.01257),(-0.75,-0.4784,-0.00885),(-0.75,-0.47324,-0.00573),(-0.75,-0.46773,-0.00325),(-0.75,-0.46197,-0.00145),(-0.75,-0.45603,-3.6E-4),(-0.75,-0.45,0),(-0.75,0.45,0),(-0.75,0.45603,-3.6E-4),(-0.75,0.46197,-0.00145),(-0.75,0.46773,-0.00325),(-0.75,0.47324,-0.00573),(-0.75,0.4784,-0.00885),(-0.75,0.48316,-0.01257),(-0.75,0.48743,-0.01684),(-0.75,0.49115,-0.0216),(-0.75,0.49427,-0.02676),(-0.75,0.49675,-0.03227),(-0.75,0.49855,-0.03803),(-0.75,0.49964,-0.04397),(-0.75,0.5,-0.05),(-0.75,0.5,-0.2128),(-0.75,0.49966,-0.2186),(-0.75,0.49865,-0.22432),(-0.75,0.49699,-0.22989),(-0.75,0.49469,-0.23523),(-0.75,0.49178,-0.24026),(-0.75,0.48831,-0.24493),(-0.75,0.48433,-0.24915),(-0.75,0.47987,-0.25289),(-0.75,0.47502,-0.25609),(-0.75,0.46983,-0.2587),(-0.75,0.46437,-0.26069),(-0.75,0.01437,-0.39569),(-0.75,0.0087,-0.39704),(-0.75,0.00291,-0.39771),(-0.75,-0.00291,-0.39771),(-0.75,-0.0087,-0.39704),(-0.75,-0.01437,-0.39569),(-0.75,-0.41793,-0.24856),(-0.75,-0.01293,-0.35656),(-0.75,-0.00975,-0.35729),(-0.75,-0.00652,-0.35782),(-0.75,-0.00327,-0.35814),(-0.75,0,-0.35824),(-0.75,0.00327,-0.35814),(-0.75,0.00652,-0.35782),(-0.75,0.00975,-0.35729),(-0.75,0.01293,-0.35656),(-0.75,0.41793,-0.24856),(-0.75,0.42116,-0.24758),(-0.75,0.4243,-0.24638),(-0.75,0.42735,-0.24496),(-0.75,0.43029,-0.24333),(-0.75,0.4331,-0.24148),(-0.75,0.43577,-0.23943),(-0.75,0.43827,-0.23718),(-0.75,0.44057,-0.23475),(-0.75,0.44266,-0.23214),(-0.75,0.44453,-0.22935),(-0.75,0.44616,-0.22642),(-0.75,0.44752,-0.22335),(-0.75,0.44859,-0.22017),(-0.75,0.44937,-0.21691),(-0.75,0.44984,-0.21359),(-0.75,0.45,-0.21024),(-0.75,0.45,-0.08),(-0.75,0.44976,-0.07585),(-0.75,0.44904,-0.07177),(-0.75,0.44785,-0.06779),(-0.75,0.44622,-0.06395),(-0.75,0.44418,-0.06033),(-0.75,0.44177,-0.05694),(-0.75,0.43901,-0.05381),(-0.75,0.43595,-0.05097),(-0.75,0.43263,-0.04843),(-0.75,0.42909,-0.04622),(-0.75,0.42535,-0.04433),(-0.75,0.42146,-0.04278),(-0.75,0.41745,-0.04157),(-0.75,0.41335,-0.0407),(-0.75,0.40919,-0.04018),(-0.75,0.405,-0.04),(-0.75,-0.405,-0.04),(-0.75,-0.40919,-0.04018),(-0.75,-0.41335,-0.0407),(-0.75,-0.41745,-0.04157),(-0.75,-0.42146,-0.04278),(-0.75,-0.42535,-0.04433),(-0.75,-0.42909,-0.04622),(-0.75,-0.43263,-0.04843),(-0.75,-0.43595,-0.05096),(-0.75,-0.43901,-0.05381),(-0.75,-0.44176,-0.05694),(-0.75,-0.44418,-0.06033),(-0.75,-0.44622,-0.06395),(-0.75,-0.44785,-0.06779),(-0.75,-0.44904,-0.07177),(-0.75,-0.44976,-0.07585),(-0.75,-0.45,-0.08),(-0.75,-0.45,-0.21024),(-0.75,-0.44984,-0.21359),(-0.75,-0.44937,-0.2169),(-0.75,-0.4486,-0.22014),(-0.75,-0.44753,-0.22332),(-0.75,-0.44617,-0.22639),(-0.75,-0.44455,-0.22932),(-0.75,-0.44269,-0.2321),(-0.75,-0.44059,-0.23472),(-0.75,-0.43828,-0.23716),(-0.75,-0.43578,-0.23942),(-0.75,-0.43312,-0.24147),(-0.75,-0.43031,-0.24332),(-0.75,-0.42736,-0.24496),(-0.75,-0.4243,-0.24638),(-0.75,-0.42116,-0.24758)]),
          normal=Normal(vector=[(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0),(-1.0,0,0.0)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for KeyFobWeb3d2013Spain.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python KeyFobWeb3d2013Spain.py load and self-test diagnostics complete.")
