####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python IndexedQuadSetTexture.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='CADInterchange',version='3.3',
  head=head(
    children=[
    meta(content='IndexedQuadSetTexture.x3d',name='title'),
    meta(content='Demonstrates IndexedQuadSet node of CADGeometry component, includes child nodes for normal vectors and texture coordinates. Scene shows an image projected onto the inner surface of a patch of a spherical region.',name='description'),
    meta(content='Vincent Marchetti',name='creator'),
    meta(content='19 May 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='pumpkins.png',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/CAD/IndexedQuadSetTexture.x3d',name='identifier'),
    meta(content='X3D-Edit, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Python script from http://kshell.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='IndexedQuadSetTexture.x3d'),
    Viewpoint(description='IndexedQuadSet Texture',fieldOfView=3.0307e-01,orientation=(1.000,0.000,0.000,1.571),position=(0.0000e+00,-1.6371e+01,1.0025e-15)),
    Shape(
      geometry=IndexedQuadSet(ccw=True,colorPerVertex=True,index=[0,30,31,1,30,60,61,31,60,90,91,61,90,120,121,91,120,150,151,121,150,180,181,151,180,210,211,181,210,240,241,211,240,270,271,241,270,300,301,271,300,330,331,301,330,360,361,331,360,390,391,361,390,420,421,391,420,450,451,421,450,480,481,451,480,510,511,481,510,540,541,511,540,570,571,541,570,600,601,571,600,630,631,601,630,660,661,631,660,690,691,661,690,720,721,691,720,750,751,721,750,780,781,751,780,810,811,781,810,840,841,811,840,870,871,841,1,31,32,2,31,61,62,32,61,91,92,62,91,121,122,92,121,151,152,122,151,181,182,152,181,211,212,182,211,241,242,212,241,271,272,242,271,301,302,272,301,331,332,302,331,361,362,332,361,391,392,362,391,421,422,392,421,451,452,422,451,481,482,452,481,511,512,482,511,541,542,512,541,571,572,542,571,601,602,572,601,631,632,602,631,661,662,632,661,691,692,662,691,721,722,692,721,751,752,722,751,781,782,752,781,811,812,782,811,841,842,812,841,871,872,842,2,32,33,3,32,62,63,33,62,92,93,63,92,122,123,93,122,152,153,123,152,182,183,153,182,212,213,183,212,242,243,213,242,272,273,243,272,302,303,273,302,332,333,303,332,362,363,333,362,392,393,363,392,422,423,393,422,452,453,423,452,482,483,453,482,512,513,483,512,542,543,513,542,572,573,543,572,602,603,573,602,632,633,603,632,662,663,633,662,692,693,663,692,722,723,693,722,752,753,723,752,782,783,753,782,812,813,783,812,842,843,813,842,872,873,843,3,33,34,4,33,63,64,34,63,93,94,64,93,123,124,94,123,153,154,124,153,183,184,154,183,213,214,184,213,243,244,214,243,273,274,244,273,303,304,274,303,333,334,304,333,363,364,334,363,393,394,364,393,423,424,394,423,453,454,424,453,483,484,454,483,513,514,484,513,543,544,514,543,573,574,544,573,603,604,574,603,633,634,604,633,663,664,634,663,693,694,664,693,723,724,694,723,753,754,724,753,783,784,754,783,813,814,784,813,843,844,814,843,873,874,844,4,34,35,5,34,64,65,35,64,94,95,65,94,124,125,95,124,154,155,125,154,184,185,155,184,214,215,185,214,244,245,215,244,274,275,245,274,304,305,275,304,334,335,305,334,364,365,335,364,394,395,365,394,424,425,395,424,454,455,425,454,484,485,455,484,514,515,485,514,544,545,515,544,574,575,545,574,604,605,575,604,634,635,605,634,664,665,635,664,694,695,665,694,724,725,695,724,754,755,725,754,784,785,755,784,814,815,785,814,844,845,815,844,874,875,845,5,35,36,6,35,65,66,36,65,95,96,66,95,125,126,96,125,155,156,126,155,185,186,156,185,215,216,186,215,245,246,216,245,275,276,246,275,305,306,276,305,335,336,306,335,365,366,336,365,395,396,366,395,425,426,396,425,455,456,426,455,485,486,456,485,515,516,486,515,545,546,516,545,575,576,546,575,605,606,576,605,635,636,606,635,665,666,636,665,695,696,666,695,725,726,696,725,755,756,726,755,785,786,756,785,815,816,786,815,845,846,816,845,875,876,846,6,36,37,7,36,66,67,37,66,96,97,67,96,126,127,97,126,156,157,127,156,186,187,157,186,216,217,187,216,246,247,217,246,276,277,247,276,306,307,277,306,336,337,307,336,366,367,337,366,396,397,367,396,426,427,397,426,456,457,427,456,486,487,457,486,516,517,487,516,546,547,517,546,576,577,547,576,606,607,577,606,636,637,607,636,666,667,637,666,696,697,667,696,726,727,697,726,756,757,727,756,786,787,757,786,816,817,787,816,846,847,817,846,876,877,847,7,37,38,8,37,67,68,38,67,97,98,68,97,127,128,98,127,157,158,128,157,187,188,158,187,217,218,188,217,247,248,218,247,277,278,248,277,307,308,278,307,337,338,308,337,367,368,338,367,397,398,368,397,427,428,398,427,457,458,428,457,487,488,458,487,517,518,488,517,547,548,518,547,577,578,548,577,607,608,578,607,637,638,608,637,667,668,638,667,697,698,668,697,727,728,698,727,757,758,728,757,787,788,758,787,817,818,788,817,847,848,818,847,877,878,848,8,38,39,9,38,68,69,39,68,98,99,69,98,128,129,99,128,158,159,129,158,188,189,159,188,218,219,189,218,248,249,219,248,278,279,249,278,308,309,279,308,338,339,309,338,368,369,339,368,398,399,369,398,428,429,399,428,458,459,429,458,488,489,459,488,518,519,489,518,548,549,519,548,578,579,549,578,608,609,579,608,638,639,609,638,668,669,639,668,698,699,669,698,728,729,699,728,758,759,729,758,788,789,759,788,818,819,789,818,848,849,819,848,878,879,849,9,39,40,10,39,69,70,40,69,99,100,70,99,129,130,100,129,159,160,130,159,189,190,160,189,219,220,190,219,249,250,220,249,279,280,250,279,309,310,280,309,339,340,310,339,369,370,340,369,399,400,370,399,429,430,400,429,459,460,430,459,489,490,460,489,519,520,490,519,549,550,520,549,579,580,550,579,609,610,580,609,639,640,610,639,669,670,640,669,699,700,670,699,729,730,700,729,759,760,730,759,789,790,760,789,819,820,790,819,849,850,820,849,879,880,850,10,40,41,11,40,70,71,41,70,100,101,71,100,130,131,101,130,160,161,131,160,190,191,161,190,220,221,191,220,250,251,221,250,280,281,251,280,310,311,281,310,340,341,311,340,370,371,341,370,400,401,371,400,430,431,401,430,460,461,431,460,490,491,461,490,520,521,491,520,550,551,521,550,580,581,551,580,610,611,581,610,640,641,611,640,670,671,641,670,700,701,671,700,730,731,701,730,760,761,731,760,790,791,761,790,820,821,791,820,850,851,821,850,880,881,851,11,41,42,12,41,71,72,42,71,101,102,72,101,131,132,102,131,161,162,132,161,191,192,162,191,221,222,192,221,251,252,222,251,281,282,252,281,311,312,282,311,341,342,312,341,371,372,342,371,401,402,372,401,431,432,402,431,461,462,432,461,491,492,462,491,521,522,492,521,551,552,522,551,581,582,552,581,611,612,582,611,641,642,612,641,671,672,642,671,701,702,672,701,731,732,702,731,761,762,732,761,791,792,762,791,821,822,792,821,851,852,822,851,881,882,852,12,42,43,13,42,72,73,43,72,102,103,73,102,132,133,103,132,162,163,133,162,192,193,163,192,222,223,193,222,252,253,223,252,282,283,253,282,312,313,283,312,342,343,313,342,372,373,343,372,402,403,373,402,432,433,403,432,462,463,433,462,492,493,463,492,522,523,493,522,552,553,523,552,582,583,553,582,612,613,583,612,642,643,613,642,672,673,643,672,702,703,673,702,732,733,703,732,762,763,733,762,792,793,763,792,822,823,793,822,852,853,823,852,882,883,853,13,43,44,14,43,73,74,44,73,103,104,74,103,133,134,104,133,163,164,134,163,193,194,164,193,223,224,194,223,253,254,224,253,283,284,254,283,313,314,284,313,343,344,314,343,373,374,344,373,403,404,374,403,433,434,404,433,463,464,434,463,493,494,464,493,523,524,494,523,553,554,524,553,583,584,554,583,613,614,584,613,643,644,614,643,673,674,644,673,703,704,674,703,733,734,704,733,763,764,734,763,793,794,764,793,823,824,794,823,853,854,824,853,883,884,854,14,44,45,15,44,74,75,45,74,104,105,75,104,134,135,105,134,164,165,135,164,194,195,165,194,224,225,195,224,254,255,225,254,284,285,255,284,314,315,285,314,344,345,315,344,374,375,345,374,404,405,375,404,434,435,405,434,464,465,435,464,494,495,465,494,524,525,495,524,554,555,525,554,584,585,555,584,614,615,585,614,644,645,615,644,674,675,645,674,704,705,675,704,734,735,705,734,764,765,735,764,794,795,765,794,824,825,795,824,854,855,825,854,884,885,855,15,45,46,16,45,75,76,46,75,105,106,76,105,135,136,106,135,165,166,136,165,195,196,166,195,225,226,196,225,255,256,226,255,285,286,256,285,315,316,286,315,345,346,316,345,375,376,346,375,405,406,376,405,435,436,406,435,465,466,436,465,495,496,466,495,525,526,496,525,555,556,526,555,585,586,556,585,615,616,586,615,645,646,616,645,675,676,646,675,705,706,676,705,735,736,706,735,765,766,736,765,795,796,766,795,825,826,796,825,855,856,826,855,885,886,856,16,46,47,17,46,76,77,47,76,106,107,77,106,136,137,107,136,166,167,137,166,196,197,167,196,226,227,197,226,256,257,227,256,286,287,257,286,316,317,287,316,346,347,317,346,376,377,347,376,406,407,377,406,436,437,407,436,466,467,437,466,496,497,467,496,526,527,497,526,556,557,527,556,586,587,557,586,616,617,587,616,646,647,617,646,676,677,647,676,706,707,677,706,736,737,707,736,766,767,737,766,796,797,767,796,826,827,797,826,856,857,827,856,886,887,857,17,47,48,18,47,77,78,48,77,107,108,78,107,137,138,108,137,167,168,138,167,197,198,168,197,227,228,198,227,257,258,228,257,287,288,258,287,317,318,288,317,347,348,318,347,377,378,348,377,407,408,378,407,437,438,408,437,467,468,438,467,497,498,468,497,527,528,498,527,557,558,528,557,587,588,558,587,617,618,588,617,647,648,618,647,677,678,648,677,707,708,678,707,737,738,708,737,767,768,738,767,797,798,768,797,827,828,798,827,857,858,828,857,887,888,858,18,48,49,19,48,78,79,49,78,108,109,79,108,138,139,109,138,168,169,139,168,198,199,169,198,228,229,199,228,258,259,229,258,288,289,259,288,318,319,289,318,348,349,319,348,378,379,349,378,408,409,379,408,438,439,409,438,468,469,439,468,498,499,469,498,528,529,499,528,558,559,529,558,588,589,559,588,618,619,589,618,648,649,619,648,678,679,649,678,708,709,679,708,738,739,709,738,768,769,739,768,798,799,769,798,828,829,799,828,858,859,829,858,888,889,859,19,49,50,20,49,79,80,50,79,109,110,80,109,139,140,110,139,169,170,140,169,199,200,170,199,229,230,200,229,259,260,230,259,289,290,260,289,319,320,290,319,349,350,320,349,379,380,350,379,409,410,380,409,439,440,410,439,469,470,440,469,499,500,470,499,529,530,500,529,559,560,530,559,589,590,560,589,619,620,590,619,649,650,620,649,679,680,650,679,709,710,680,709,739,740,710,739,769,770,740,769,799,800,770,799,829,830,800,829,859,860,830,859,889,890,860,20,50,51,21,50,80,81,51,80,110,111,81,110,140,141,111,140,170,171,141,170,200,201,171,200,230,231,201,230,260,261,231,260,290,291,261,290,320,321,291,320,350,351,321,350,380,381,351,380,410,411,381,410,440,441,411,440,470,471,441,470,500,501,471,500,530,531,501,530,560,561,531,560,590,591,561,590,620,621,591,620,650,651,621,650,680,681,651,680,710,711,681,710,740,741,711,740,770,771,741,770,800,801,771,800,830,831,801,830,860,861,831,860,890,891,861,21,51,52,22,51,81,82,52,81,111,112,82,111,141,142,112,141,171,172,142,171,201,202,172,201,231,232,202,231,261,262,232,261,291,292,262,291,321,322,292,321,351,352,322,351,381,382,352,381,411,412,382,411,441,442,412,441,471,472,442,471,501,502,472,501,531,532,502,531,561,562,532,561,591,592,562,591,621,622,592,621,651,652,622,651,681,682,652,681,711,712,682,711,741,742,712,741,771,772,742,771,801,802,772,801,831,832,802,831,861,862,832,861,891,892,862,22,52,53,23,52,82,83,53,82,112,113,83,112,142,143,113,142,172,173,143,172,202,203,173,202,232,233,203,232,262,263,233,262,292,293,263,292,322,323,293,322,352,353,323,352,382,383,353,382,412,413,383,412,442,443,413,442,472,473,443,472,502,503,473,502,532,533,503,532,562,563,533,562,592,593,563,592,622,623,593,622,652,653,623,652,682,683,653,682,712,713,683,712,742,743,713,742,772,773,743,772,802,803,773,802,832,833,803,832,862,863,833,862,892,893,863,23,53,54,24,53,83,84,54,83,113,114,84,113,143,144,114,143,173,174,144,173,203,204,174,203,233,234,204,233,263,264,234,263,293,294,264,293,323,324,294,323,353,354,324,353,383,384,354,383,413,414,384,413,443,444,414,443,473,474,444,473,503,504,474,503,533,534,504,533,563,564,534,563,593,594,564,593,623,624,594,623,653,654,624,653,683,684,654,683,713,714,684,713,743,744,714,743,773,774,744,773,803,804,774,803,833,834,804,833,863,864,834,863,893,894,864,24,54,55,25,54,84,85,55,84,114,115,85,114,144,145,115,144,174,175,145,174,204,205,175,204,234,235,205,234,264,265,235,264,294,295,265,294,324,325,295,324,354,355,325,354,384,385,355,384,414,415,385,414,444,445,415,444,474,475,445,474,504,505,475,504,534,535,505,534,564,565,535,564,594,595,565,594,624,625,595,624,654,655,625,654,684,685,655,684,714,715,685,714,744,745,715,744,774,775,745,774,804,805,775,804,834,835,805,834,864,865,835,864,894,895,865,25,55,56,26,55,85,86,56,85,115,116,86,115,145,146,116,145,175,176,146,175,205,206,176,205,235,236,206,235,265,266,236,265,295,296,266,295,325,326,296,325,355,356,326,355,385,386,356,385,415,416,386,415,445,446,416,445,475,476,446,475,505,506,476,505,535,536,506,535,565,566,536,565,595,596,566,595,625,626,596,625,655,656,626,655,685,686,656,685,715,716,686,715,745,746,716,745,775,776,746,775,805,806,776,805,835,836,806,835,865,866,836,865,895,896,866,26,56,57,27,56,86,87,57,86,116,117,87,116,146,147,117,146,176,177,147,176,206,207,177,206,236,237,207,236,266,267,237,266,296,297,267,296,326,327,297,326,356,357,327,356,386,387,357,386,416,417,387,416,446,447,417,446,476,477,447,476,506,507,477,506,536,537,507,536,566,567,537,566,596,597,567,596,626,627,597,626,656,657,627,656,686,687,657,686,716,717,687,716,746,747,717,746,776,777,747,776,806,807,777,806,836,837,807,836,866,867,837,866,896,897,867,27,57,58,28,57,87,88,58,87,117,118,88,117,147,148,118,147,177,178,148,177,207,208,178,207,237,238,208,237,267,268,238,267,297,298,268,297,327,328,298,327,357,358,328,357,387,388,358,387,417,418,388,417,447,448,418,447,477,478,448,477,507,508,478,507,537,538,508,537,567,568,538,567,597,598,568,597,627,628,598,627,657,658,628,657,687,688,658,687,717,718,688,717,747,748,718,747,777,778,748,777,807,808,778,807,837,838,808,837,867,868,838,867,897,898,868,28,58,59,29,58,88,89,59,88,118,119,89,118,148,149,119,148,178,179,149,178,208,209,179,208,238,239,209,238,268,269,239,268,298,299,269,298,328,329,299,328,358,359,329,358,388,389,359,388,418,419,389,418,448,449,419,448,478,479,449,478,508,509,479,508,538,539,509,538,568,569,539,568,598,599,569,598,628,629,599,628,658,659,629,658,688,689,659,688,718,719,689,718,748,749,719,748,778,779,749,778,808,809,779,808,838,839,809,838,868,869,839,868,898,899,869],normalPerVertex=True,solid=False,
        coord=Coordinate(point=[(-1.6730,0.4483,-1.0000),(-1.7229,0.4616,-0.9048),(-1.7677,0.4736,-0.8069),(-1.8073,0.4843,-0.7066),(-1.8416,0.4934,-0.6043),(-1.8705,0.5012,-0.5002),(-1.8939,0.5075,-0.3946),(-1.9117,0.5122,-0.2879),(-1.9240,0.5155,-0.1803),(-1.9306,0.5173,-0.0722),(-1.9315,0.5176,0.0361),(-1.9268,0.5163,0.1443),(-1.9164,0.5135,0.2521),(-1.9004,0.5092,0.3591),(-1.8789,0.5034,0.4651),(-1.8518,0.4962,0.5698),(-1.8193,0.4875,0.6727),(-1.7814,0.4773,0.7737),(-1.7384,0.4658,0.8724),(-1.6902,0.4529,0.9686),(-1.6371,0.4387,1.0619),(-1.5791,0.4231,1.1521),(-1.5166,0.4064,1.2389),(-1.4496,0.3884,1.3221),(-1.3783,0.3693,1.4014),(-1.3030,0.3491,1.4766),(-1.2239,0.3279,1.5475),(-1.1412,0.3058,1.6138),(-1.0551,0.2827,1.6754),(-0.9659,0.2588,1.7321),(-1.6258,0.5973,-1.0000),(-1.6742,0.6151,-0.9048),(-1.7178,0.6311,-0.8069),(-1.7562,0.6452,-0.7066),(-1.7896,0.6575,-0.6043),(-1.8177,0.6678,-0.5002),(-1.8404,0.6761,-0.3946),(-1.8578,0.6825,-0.2879),(-1.8697,0.6869,-0.1803),(-1.8761,0.6892,-0.0722),(-1.8770,0.6896,0.0361),(-1.8724,0.6879,0.1443),(-1.8623,0.6842,0.2521),(-1.8468,0.6785,0.3591),(-1.8258,0.6708,0.4651),(-1.7995,0.6611,0.5698),(-1.7679,0.6495,0.6727),(-1.7312,0.6360,0.7737),(-1.6893,0.6206,0.8724),(-1.6425,0.6034,0.9686),(-1.5909,0.5845,1.0619),(-1.5346,0.5638,1.1521),(-1.4738,0.5414,1.2389),(-1.4086,0.5175,1.3221),(-1.3394,0.4921,1.4014),(-1.2662,0.4652,1.4766),(-1.1893,0.4369,1.5475),(-1.1089,0.4074,1.6138),(-1.0253,0.3767,1.6754),(-0.9387,0.3448,1.7321),(-1.5653,0.7414,-1.0000),(-1.6120,0.7635,-0.9048),(-1.6539,0.7834,-0.8069),(-1.6909,0.8009,-0.7066),(-1.7230,0.8161,-0.6043),(-1.7501,0.8289,-0.5002),(-1.7720,0.8393,-0.3946),(-1.7887,0.8472,-0.2879),(-1.8001,0.8526,-0.1803),(-1.8063,0.8556,-0.0722),(-1.8072,0.8560,0.0361),(-1.8028,0.8539,0.1443),(-1.7931,0.8493,0.2521),(-1.7781,0.8422,0.3591),(-1.7579,0.8327,0.4651),(-1.7326,0.8207,0.5698),(-1.7022,0.8062,0.6727),(-1.6668,0.7895,0.7737),(-1.6265,0.7704,0.8724),(-1.5814,0.7490,0.9686),(-1.5317,0.7255,1.0619),(-1.4775,0.6998,1.1521),(-1.4190,0.6721,1.2389),(-1.3563,0.6424,1.3221),(-1.2896,0.6108,1.4014),(-1.2191,0.5774,1.4766),(-1.1451,0.5424,1.5475),(-1.0677,0.5057,1.6138),(-0.9872,0.4676,1.6754),(-0.9037,0.4281,1.7321),(-1.4921,0.8795,-1.0000),(-1.5366,0.9057,-0.9048),(-1.5765,0.9293,-0.8069),(-1.6118,0.9501,-0.7066),(-1.6424,0.9681,-0.6043),(-1.6682,0.9833,-0.5002),(-1.6891,0.9956,-0.3946),(-1.7050,1.0050,-0.2879),(-1.7159,1.0115,-0.1803),(-1.7218,1.0149,-0.0722),(-1.7227,1.0154,0.0361),(-1.7185,1.0129,0.1443),(-1.7092,1.0075,0.2521),(-1.6949,0.9991,0.3591),(-1.6757,0.9877,0.4651),(-1.6516,0.9735,0.5698),(-1.6226,0.9564,0.6727),(-1.5888,0.9365,0.7737),(-1.5504,0.9139,0.8724),(-1.5074,0.8886,0.9686),(-1.4600,0.8606,1.0619),(-1.4084,0.8302,1.1521),(-1.3526,0.7973,1.2389),(-1.2928,0.7621,1.3221),(-1.2293,0.7246,1.4014),(-1.1621,0.6850,1.4766),(-1.0915,0.6434,1.5475),(-1.0178,0.5999,1.6138),(-0.9410,0.5547,1.6754),(-0.8615,0.5078,1.7321),(-1.4068,1.0105,-1.0000),(-1.4487,1.0406,-0.9048),(-1.4863,1.0676,-0.8069),(-1.5196,1.0915,-0.7066),(-1.5485,1.1123,-0.6043),(-1.5728,1.1297,-0.5002),(-1.5924,1.1439,-0.3946),(-1.6075,1.1546,-0.2879),(-1.6178,1.1620,-0.1803),(-1.6233,1.1660,-0.0722),(-1.6241,1.1666,0.0361),(-1.6201,1.1637,0.1443),(-1.6114,1.1575,0.2521),(-1.5980,1.1478,0.3591),(-1.5798,1.1348,0.4651),(-1.5571,1.1184,0.5698),(-1.5297,1.0988,0.6727),(-1.4979,1.0759,0.7737),(-1.4617,1.0499,0.8724),(-1.4212,1.0208,0.9686),(-1.3765,0.9887,1.0619),(-1.3278,0.9538,1.1521),(-1.2752,0.9160,1.2389),(-1.2189,0.8755,1.3221),(-1.1589,0.8325,1.4014),(-1.0956,0.7870,1.4766),(-1.0291,0.7392,1.5475),(-0.9595,0.6892,1.6138),(-0.8872,0.6372,1.6754),(-0.8122,0.5834,1.7321),(-1.3099,1.1332,-1.0000),(-1.3490,1.1669,-0.9048),(-1.3840,1.1973,-0.8069),(-1.4150,1.2241,-0.7066),(-1.4419,1.2473,-0.6043),(-1.4645,1.2669,-0.5002),(-1.4828,1.2828,-0.3946),(-1.4968,1.2949,-0.2879),(-1.5064,1.3032,-0.1803),(-1.5116,1.3076,-0.0722),(-1.5123,1.3083,0.0361),(-1.5086,1.3051,0.1443),(-1.5005,1.2980,0.2521),(-1.4880,1.2872,0.3591),(-1.4711,1.2726,0.4651),(-1.4499,1.2543,0.5698),(-1.4244,1.2322,0.6727),(-1.3948,1.2066,0.7737),(-1.3611,1.1774,0.8724),(-1.3234,1.1448,0.9686),(-1.2818,1.1088,1.0619),(-1.2364,1.0696,1.1521),(-1.1874,1.0272,1.2389),(-1.1350,0.9818,1.3221),(-1.0792,0.9336,1.4014),(-1.0202,0.8825,1.4766),(-0.9582,0.8289,1.5475),(-0.8935,0.7729,1.6138),(-0.8261,0.7146,1.6754),(-0.7563,0.6542,1.7321),(-1.2024,1.2467,-1.0000),(-1.2383,1.2838,-0.9048),(-1.2704,1.3172,-0.8069),(-1.2989,1.3467,-0.7066),(-1.3236,1.3722,-0.6043),(-1.3443,1.3938,-0.5002),(-1.3612,1.4112,-0.3946),(-1.3740,1.4245,-0.2879),(-1.3828,1.4337,-0.1803),(-1.3875,1.4386,-0.0722),(-1.3882,1.4393,0.0361),(-1.3848,1.4358,0.1443),(-1.3774,1.4280,0.2521),(-1.3659,1.4161,0.3591),(-1.3504,1.4000,0.4651),(-1.3309,1.3799,0.5698),(-1.3076,1.3556,0.6727),(-1.2803,1.3274,0.7737),(-1.2494,1.2953,0.8724),(-1.2148,1.2594,0.9686),(-1.1766,1.2199,1.0619),(-1.1350,1.1767,1.1521),(-1.0900,1.1301,1.2389),(-1.0418,1.0801,1.3221),(-0.9906,1.0270,1.4014),(-0.9365,0.9709,1.4766),(-0.8796,0.9120,1.5475),(-0.8202,0.8503,1.6138),(-0.7583,0.7862,1.6754),(-0.6942,0.7198,1.7321),(-1.0851,1.3500,-1.0000),(-1.1175,1.3902,-0.9048),(-1.1465,1.4263,-0.8069),(-1.1722,1.4583,-0.7066),(-1.1945,1.4860,-0.6043),(-1.2132,1.5093,-0.5002),(-1.2284,1.5282,-0.3946),(-1.2400,1.5426,-0.2879),(-1.2479,1.5525,-0.1803),(-1.2522,1.5578,-0.0722),(-1.2528,1.5586,0.0361),(-1.2498,1.5548,0.1443),(-1.2430,1.5464,0.2521),(-1.2327,1.5335,0.3591),(-1.2187,1.5161,0.4651),(-1.2011,1.4942,0.5698),(-1.1800,1.4680,0.6727),(-1.1555,1.4375,0.7737),(-1.1275,1.4027,0.8724),(-1.0963,1.3638,0.9686),(-1.0618,1.3210,1.0619),(-1.0242,1.2742,1.1521),(-0.9837,1.2237,1.2389),(-0.9402,1.1697,1.3221),(-0.8940,1.1122,1.4014),(-0.8451,1.0514,1.4766),(-0.7938,0.9875,1.5475),(-0.7402,0.9208,1.6138),(-0.6843,0.8514,1.6754),(-0.6265,0.7794,1.7321),(-0.9590,1.4423,-1.0000),(-0.9876,1.4853,-0.9048),(-1.0133,1.5239,-0.8069),(-1.0360,1.5580,-0.7066),(-1.0556,1.5876,-0.6043),(-1.0722,1.6125,-0.5002),(-1.0856,1.6327,-0.3946),(-1.0959,1.6481,-0.2879),(-1.1029,1.6587,-0.1803),(-1.1067,1.6644,-0.0722),(-1.1072,1.6652,0.0361),(-1.1045,1.6611,0.1443),(-1.0986,1.6522,0.2521),(-1.0894,1.6384,0.3591),(-1.0770,1.6198,0.4651),(-1.0615,1.5964,0.5698),(-1.0429,1.5684,0.6727),(-1.0212,1.5358,0.7737),(-0.9965,1.4986,0.8724),(-0.9689,1.4571,0.9686),(-0.9384,1.4113,1.0619),(-0.9052,1.3614,1.1521),(-0.8693,1.3074,1.2389),(-0.8309,1.2497,1.3221),(-0.7901,1.1882,1.4014),(-0.7469,1.1233,1.4766),(-0.7016,1.0551,1.5475),(-0.6541,0.9838,1.6138),(-0.6048,0.9096,1.6754),(-0.5537,0.8327,1.7321),(-0.8251,1.5229,-1.0000),(-0.8497,1.5683,-0.9048),(-0.8718,1.6090,-0.8069),(-0.8913,1.6451,-0.7066),(-0.9082,1.6763,-0.6043),(-0.9225,1.7026,-0.5002),(-0.9340,1.7239,-0.3946),(-0.9428,1.7402,-0.2879),(-0.9489,1.7513,-0.1803),(-0.9521,1.7573,-0.0722),(-0.9526,1.7582,0.0361),(-0.9502,1.7539,0.1443),(-0.9451,1.7445,0.2521),(-0.9372,1.7299,0.3591),(-0.9266,1.7103,0.4651),(-0.9133,1.6856,0.5698),(-0.8972,1.6560,0.6727),(-0.8786,1.6216,0.7737),(-0.8573,1.5824,0.8724),(-0.8336,1.5385,0.9686),(-0.8074,1.4902,1.0619),(-0.7788,1.4374,1.1521),(-0.7479,1.3805,1.2389),(-0.7149,1.3195,1.3221),(-0.6797,1.2546,1.4014),(-0.6426,1.1861,1.4766),(-0.6036,1.1140,1.5475),(-0.5628,1.0387,1.6138),(-0.5203,0.9604,1.6754),(-0.4764,0.8792,1.7321),(-0.6844,1.5911,-1.0000),(-0.7048,1.6385,-0.9048),(-0.7231,1.6811,-0.8069),(-0.7393,1.7187,-0.7066),(-0.7534,1.7514,-0.6043),(-0.7652,1.7788,-0.5002),(-0.7748,1.8011,-0.3946),(-0.7821,1.8181,-0.2879),(-0.7871,1.8297,-0.1803),(-0.7898,1.8360,-0.0722),(-0.7902,1.8369,0.0361),(-0.7883,1.8324,0.1443),(-0.7840,1.8226,0.2521),(-0.7775,1.8074,0.3591),(-0.7686,1.7868,0.4651),(-0.7576,1.7611,0.5698),(-0.7443,1.7302,0.6727),(-0.7288,1.6942,0.7737),(-0.7112,1.6532,0.8724),(-0.6915,1.6074,0.9686),(-0.6697,1.5569,1.0619),(-0.6460,1.5018,1.1521),(-0.6204,1.4423,1.2389),(-0.5930,1.3786,1.3221),(-0.5639,1.3108,1.4014),(-0.5331,1.2392,1.4766),(-0.5007,1.1639,1.5475),(-0.4668,1.0853,1.6138),(-0.4316,1.0034,1.6754),(-0.3952,0.9186,1.7321),(-0.5382,1.6463,-1.0000),(-0.5542,1.6954,-0.9048),(-0.5686,1.7394,-0.8069),(-0.5814,1.7784,-0.7066),(-0.5924,1.8121,-0.6043),(-0.6017,1.8406,-0.5002),(-0.6093,1.8636,-0.3946),(-0.6150,1.8812,-0.2879),(-0.6189,1.8933,-0.1803),(-0.6211,1.8998,-0.0722),(-0.6214,1.9007,0.0361),(-0.6198,1.8960,0.1443),(-0.6165,1.8858,0.2521),(-0.6114,1.8701,0.3591),(-0.6044,1.8489,0.4651),(-0.5957,1.8222,0.5698),(-0.5853,1.7902,0.6727),(-0.5731,1.7530,0.7737),(-0.5592,1.7106,0.8724),(-0.5437,1.6632,0.9686),(-0.5266,1.6109,1.0619),(-0.5080,1.5539,1.1521),(-0.4879,1.4924,1.2389),(-0.4663,1.4264,1.3221),(-0.4434,1.3563,1.4014),(-0.4192,1.2822,1.4766),(-0.3937,1.2043,1.5475),(-0.3671,1.1229,1.6138),(-0.3394,1.0382,1.6754),(-0.3107,0.9505,1.7321),(-0.3876,1.6881,-1.0000),(-0.3991,1.7384,-0.9048),(-0.4095,1.7836,-0.8069),(-0.4187,1.8236,-0.7066),(-0.4266,1.8582,-0.6043),(-0.4333,1.8873,-0.5002),(-0.4388,1.9110,-0.3946),(-0.4429,1.9290,-0.2879),(-0.4457,1.9413,-0.1803),(-0.4473,1.9480,-0.0722),(-0.4475,1.9490,0.0361),(-0.4464,1.9442,0.1443),(-0.4440,1.9337,0.2521),(-0.4403,1.9176,0.3591),(-0.4353,1.8958,0.4651),(-0.4290,1.8685,0.5698),(-0.4215,1.8357,0.6727),(-0.4127,1.7975,0.7737),(-0.4027,1.7541,0.8724),(-0.3916,1.7054,0.9686),(-0.3793,1.6518,1.0619),(-0.3658,1.5934,1.1521),(-0.3513,1.5303,1.2389),(-0.3358,1.4626,1.3221),(-0.3193,1.3907,1.4014),(-0.3019,1.3148,1.4766),(-0.2835,1.2349,1.5475),(-0.2644,1.1514,1.6138),(-0.2444,1.0646,1.6754),(-0.2238,0.9746,1.7321),(-0.2338,1.7162,-1.0000),(-0.2408,1.7673,-0.9048),(-0.2471,1.8133,-0.8069),(-0.2526,1.8539,-0.7066),(-0.2574,1.8891,-0.6043),(-0.2614,1.9187,-0.5002),(-0.2647,1.9427,-0.3946),(-0.2672,1.9611,-0.2879),(-0.2689,1.9736,-0.1803),(-0.2698,1.9804,-0.0722),(-0.2700,1.9814,0.0361),(-0.2693,1.9765,0.1443),(-0.2678,1.9659,0.2521),(-0.2656,1.9495,0.3591),(-0.2626,1.9274,0.4651),(-0.2588,1.8996,0.5698),(-0.2543,1.8662,0.6727),(-0.2490,1.8274,0.7737),(-0.2430,1.7832,0.8724),(-0.2362,1.7338,0.9686),(-0.2288,1.6793,1.0619),(-0.2207,1.6199,1.1521),(-0.2120,1.5557,1.2389),(-0.2026,1.4870,1.3221),(-0.1926,1.4139,1.4014),(-0.1821,1.3366,1.4766),(-0.1711,1.2554,1.5475),(-0.1595,1.1706,1.6138),(-0.1475,1.0823,1.6754),(-0.1350,0.9908,1.7321),(-0.0782,1.7303,-1.0000),(-0.0805,1.7818,-0.9048),(-0.0826,1.8282,-0.8069),(-0.0844,1.8691,-0.7066),(-0.0860,1.9046,-0.6043),(-0.0874,1.9345,-0.5002),(-0.0885,1.9587,-0.3946),(-0.0893,1.9772,-0.2879),(-0.0899,1.9898,-0.1803),(-0.0902,1.9967,-0.0722),(-0.0902,1.9976,0.0361),(-0.0900,1.9928,0.1443),(-0.0895,1.9820,0.2521),(-0.0888,1.9655,0.3591),(-0.0878,1.9432,0.4651),(-0.0865,1.9152,0.5698),(-0.0850,1.8815,0.6727),(-0.0832,1.8424,0.7737),(-0.0812,1.7979,0.8724),(-0.0790,1.7480,0.9686),(-0.0765,1.6931,1.0619),(-0.0738,1.6332,1.1521),(-0.0708,1.5685,1.2389),(-0.0677,1.4992,1.3221),(-0.0644,1.4255,1.4014),(-0.0609,1.3476,1.4766),(-0.0572,1.2658,1.5475),(-0.0533,1.1802,1.6138),(-0.0493,1.0912,1.6754),(-0.0451,0.9990,1.7321),(0.0782,1.7303,-1.0000),(0.0805,1.7818,-0.9048),(0.0826,1.8282,-0.8069),(0.0844,1.8691,-0.7066),(0.0860,1.9046,-0.6043),(0.0874,1.9345,-0.5002),(0.0885,1.9587,-0.3946),(0.0893,1.9772,-0.2879),(0.0899,1.9898,-0.1803),(0.0902,1.9967,-0.0722),(0.0902,1.9976,0.0361),(0.0900,1.9928,0.1443),(0.0895,1.9820,0.2521),(0.0888,1.9655,0.3591),(0.0878,1.9432,0.4651),(0.0865,1.9152,0.5698),(0.0850,1.8815,0.6727),(0.0832,1.8424,0.7737),(0.0812,1.7979,0.8724),(0.0790,1.7480,0.9686),(0.0765,1.6931,1.0619),(0.0738,1.6332,1.1521),(0.0708,1.5685,1.2389),(0.0677,1.4992,1.3221),(0.0644,1.4255,1.4014),(0.0609,1.3476,1.4766),(0.0572,1.2658,1.5475),(0.0533,1.1802,1.6138),(0.0493,1.0912,1.6754),(0.0451,0.9990,1.7321),(0.2338,1.7162,-1.0000),(0.2408,1.7673,-0.9048),(0.2471,1.8133,-0.8069),(0.2526,1.8539,-0.7066),(0.2574,1.8891,-0.6043),(0.2614,1.9187,-0.5002),(0.2647,1.9427,-0.3946),(0.2672,1.9611,-0.2879),(0.2689,1.9736,-0.1803),(0.2698,1.9804,-0.0722),(0.2700,1.9814,0.0361),(0.2693,1.9765,0.1443),(0.2678,1.9659,0.2521),(0.2656,1.9495,0.3591),(0.2626,1.9274,0.4651),(0.2588,1.8996,0.5698),(0.2543,1.8662,0.6727),(0.2490,1.8274,0.7737),(0.2430,1.7832,0.8724),(0.2362,1.7338,0.9686),(0.2288,1.6793,1.0619),(0.2207,1.6199,1.1521),(0.2120,1.5557,1.2389),(0.2026,1.4870,1.3221),(0.1926,1.4139,1.4014),(0.1821,1.3366,1.4766),(0.1711,1.2554,1.5475),(0.1595,1.1706,1.6138),(0.1475,1.0823,1.6754),(0.1350,0.9908,1.7321),(0.3876,1.6881,-1.0000),(0.3991,1.7384,-0.9048),(0.4095,1.7836,-0.8069),(0.4187,1.8236,-0.7066),(0.4266,1.8582,-0.6043),(0.4333,1.8873,-0.5002),(0.4388,1.9110,-0.3946),(0.4429,1.9290,-0.2879),(0.4457,1.9413,-0.1803),(0.4473,1.9480,-0.0722),(0.4475,1.9490,0.0361),(0.4464,1.9442,0.1443),(0.4440,1.9337,0.2521),(0.4403,1.9176,0.3591),(0.4353,1.8958,0.4651),(0.4290,1.8685,0.5698),(0.4215,1.8357,0.6727),(0.4127,1.7975,0.7737),(0.4027,1.7541,0.8724),(0.3916,1.7054,0.9686),(0.3793,1.6518,1.0619),(0.3658,1.5934,1.1521),(0.3513,1.5303,1.2389),(0.3358,1.4626,1.3221),(0.3193,1.3907,1.4014),(0.3019,1.3148,1.4766),(0.2835,1.2349,1.5475),(0.2644,1.1514,1.6138),(0.2444,1.0646,1.6754),(0.2238,0.9746,1.7321),(0.5382,1.6463,-1.0000),(0.5542,1.6954,-0.9048),(0.5686,1.7394,-0.8069),(0.5814,1.7784,-0.7066),(0.5924,1.8121,-0.6043),(0.6017,1.8406,-0.5002),(0.6093,1.8636,-0.3946),(0.6150,1.8812,-0.2879),(0.6189,1.8933,-0.1803),(0.6211,1.8998,-0.0722),(0.6214,1.9007,0.0361),(0.6198,1.8960,0.1443),(0.6165,1.8858,0.2521),(0.6114,1.8701,0.3591),(0.6044,1.8489,0.4651),(0.5957,1.8222,0.5698),(0.5853,1.7902,0.6727),(0.5731,1.7530,0.7737),(0.5592,1.7106,0.8724),(0.5437,1.6632,0.9686),(0.5266,1.6109,1.0619),(0.5080,1.5539,1.1521),(0.4879,1.4924,1.2389),(0.4663,1.4264,1.3221),(0.4434,1.3563,1.4014),(0.4192,1.2822,1.4766),(0.3937,1.2043,1.5475),(0.3671,1.1229,1.6138),(0.3394,1.0382,1.6754),(0.3107,0.9505,1.7321),(0.6844,1.5911,-1.0000),(0.7048,1.6385,-0.9048),(0.7231,1.6811,-0.8069),(0.7393,1.7187,-0.7066),(0.7534,1.7514,-0.6043),(0.7652,1.7788,-0.5002),(0.7748,1.8011,-0.3946),(0.7821,1.8181,-0.2879),(0.7871,1.8297,-0.1803),(0.7898,1.8360,-0.0722),(0.7902,1.8369,0.0361),(0.7883,1.8324,0.1443),(0.7840,1.8226,0.2521),(0.7775,1.8074,0.3591),(0.7686,1.7868,0.4651),(0.7576,1.7611,0.5698),(0.7443,1.7302,0.6727),(0.7288,1.6942,0.7737),(0.7112,1.6532,0.8724),(0.6915,1.6074,0.9686),(0.6697,1.5569,1.0619),(0.6460,1.5018,1.1521),(0.6204,1.4423,1.2389),(0.5930,1.3786,1.3221),(0.5639,1.3108,1.4014),(0.5331,1.2392,1.4766),(0.5007,1.1639,1.5475),(0.4668,1.0853,1.6138),(0.4316,1.0034,1.6754),(0.3952,0.9186,1.7321),(0.8251,1.5229,-1.0000),(0.8497,1.5683,-0.9048),(0.8718,1.6090,-0.8069),(0.8913,1.6451,-0.7066),(0.9082,1.6763,-0.6043),(0.9225,1.7026,-0.5002),(0.9340,1.7239,-0.3946),(0.9428,1.7402,-0.2879),(0.9489,1.7513,-0.1803),(0.9521,1.7573,-0.0722),(0.9526,1.7582,0.0361),(0.9502,1.7539,0.1443),(0.9451,1.7445,0.2521),(0.9372,1.7299,0.3591),(0.9266,1.7103,0.4651),(0.9133,1.6856,0.5698),(0.8972,1.6560,0.6727),(0.8786,1.6216,0.7737),(0.8573,1.5824,0.8724),(0.8336,1.5385,0.9686),(0.8074,1.4902,1.0619),(0.7788,1.4374,1.1521),(0.7479,1.3805,1.2389),(0.7149,1.3195,1.3221),(0.6797,1.2546,1.4014),(0.6426,1.1861,1.4766),(0.6036,1.1140,1.5475),(0.5628,1.0387,1.6138),(0.5203,0.9604,1.6754),(0.4764,0.8792,1.7321),(0.9590,1.4423,-1.0000),(0.9876,1.4853,-0.9048),(1.0133,1.5239,-0.8069),(1.0360,1.5580,-0.7066),(1.0556,1.5876,-0.6043),(1.0722,1.6125,-0.5002),(1.0856,1.6327,-0.3946),(1.0959,1.6481,-0.2879),(1.1029,1.6587,-0.1803),(1.1067,1.6644,-0.0722),(1.1072,1.6652,0.0361),(1.1045,1.6611,0.1443),(1.0986,1.6522,0.2521),(1.0894,1.6384,0.3591),(1.0770,1.6198,0.4651),(1.0615,1.5964,0.5698),(1.0429,1.5684,0.6727),(1.0212,1.5358,0.7737),(0.9965,1.4986,0.8724),(0.9689,1.4571,0.9686),(0.9384,1.4113,1.0619),(0.9052,1.3614,1.1521),(0.8693,1.3074,1.2389),(0.8309,1.2497,1.3221),(0.7901,1.1882,1.4014),(0.7469,1.1233,1.4766),(0.7016,1.0551,1.5475),(0.6541,0.9838,1.6138),(0.6048,0.9096,1.6754),(0.5537,0.8327,1.7321),(1.0851,1.3500,-1.0000),(1.1175,1.3902,-0.9048),(1.1465,1.4263,-0.8069),(1.1722,1.4583,-0.7066),(1.1945,1.4860,-0.6043),(1.2132,1.5093,-0.5002),(1.2284,1.5282,-0.3946),(1.2400,1.5426,-0.2879),(1.2479,1.5525,-0.1803),(1.2522,1.5578,-0.0722),(1.2528,1.5586,0.0361),(1.2498,1.5548,0.1443),(1.2430,1.5464,0.2521),(1.2327,1.5335,0.3591),(1.2187,1.5161,0.4651),(1.2011,1.4942,0.5698),(1.1800,1.4680,0.6727),(1.1555,1.4375,0.7737),(1.1275,1.4027,0.8724),(1.0963,1.3638,0.9686),(1.0618,1.3210,1.0619),(1.0242,1.2742,1.1521),(0.9837,1.2237,1.2389),(0.9402,1.1697,1.3221),(0.8940,1.1122,1.4014),(0.8451,1.0514,1.4766),(0.7938,0.9875,1.5475),(0.7402,0.9208,1.6138),(0.6843,0.8514,1.6754),(0.6265,0.7794,1.7321),(1.2024,1.2467,-1.0000),(1.2383,1.2838,-0.9048),(1.2704,1.3172,-0.8069),(1.2989,1.3467,-0.7066),(1.3236,1.3722,-0.6043),(1.3443,1.3938,-0.5002),(1.3612,1.4112,-0.3946),(1.3740,1.4245,-0.2879),(1.3828,1.4337,-0.1803),(1.3875,1.4386,-0.0722),(1.3882,1.4393,0.0361),(1.3848,1.4358,0.1443),(1.3774,1.4280,0.2521),(1.3659,1.4161,0.3591),(1.3504,1.4000,0.4651),(1.3309,1.3799,0.5698),(1.3076,1.3556,0.6727),(1.2803,1.3274,0.7737),(1.2494,1.2953,0.8724),(1.2148,1.2594,0.9686),(1.1766,1.2199,1.0619),(1.1350,1.1767,1.1521),(1.0900,1.1301,1.2389),(1.0418,1.0801,1.3221),(0.9906,1.0270,1.4014),(0.9365,0.9709,1.4766),(0.8796,0.9120,1.5475),(0.8202,0.8503,1.6138),(0.7583,0.7862,1.6754),(0.6942,0.7198,1.7321),(1.3099,1.1332,-1.0000),(1.3490,1.1669,-0.9048),(1.3840,1.1973,-0.8069),(1.4150,1.2241,-0.7066),(1.4419,1.2473,-0.6043),(1.4645,1.2669,-0.5002),(1.4828,1.2828,-0.3946),(1.4968,1.2949,-0.2879),(1.5064,1.3032,-0.1803),(1.5116,1.3076,-0.0722),(1.5123,1.3083,0.0361),(1.5086,1.3051,0.1443),(1.5005,1.2980,0.2521),(1.4880,1.2872,0.3591),(1.4711,1.2726,0.4651),(1.4499,1.2543,0.5698),(1.4244,1.2322,0.6727),(1.3948,1.2066,0.7737),(1.3611,1.1774,0.8724),(1.3234,1.1448,0.9686),(1.2818,1.1088,1.0619),(1.2364,1.0696,1.1521),(1.1874,1.0272,1.2389),(1.1350,0.9818,1.3221),(1.0792,0.9336,1.4014),(1.0202,0.8825,1.4766),(0.9582,0.8289,1.5475),(0.8935,0.7729,1.6138),(0.8261,0.7146,1.6754),(0.7563,0.6542,1.7321),(1.4068,1.0105,-1.0000),(1.4487,1.0406,-0.9048),(1.4863,1.0676,-0.8069),(1.5196,1.0915,-0.7066),(1.5485,1.1123,-0.6043),(1.5728,1.1297,-0.5002),(1.5924,1.1439,-0.3946),(1.6075,1.1546,-0.2879),(1.6178,1.1620,-0.1803),(1.6233,1.1660,-0.0722),(1.6241,1.1666,0.0361),(1.6201,1.1637,0.1443),(1.6114,1.1575,0.2521),(1.5980,1.1478,0.3591),(1.5798,1.1348,0.4651),(1.5571,1.1184,0.5698),(1.5297,1.0988,0.6727),(1.4979,1.0759,0.7737),(1.4617,1.0499,0.8724),(1.4212,1.0208,0.9686),(1.3765,0.9887,1.0619),(1.3278,0.9538,1.1521),(1.2752,0.9160,1.2389),(1.2189,0.8755,1.3221),(1.1589,0.8325,1.4014),(1.0956,0.7870,1.4766),(1.0291,0.7392,1.5475),(0.9595,0.6892,1.6138),(0.8872,0.6372,1.6754),(0.8122,0.5834,1.7321),(1.4921,0.8795,-1.0000),(1.5366,0.9057,-0.9048),(1.5765,0.9293,-0.8069),(1.6118,0.9501,-0.7066),(1.6424,0.9681,-0.6043),(1.6682,0.9833,-0.5002),(1.6891,0.9956,-0.3946),(1.7050,1.0050,-0.2879),(1.7159,1.0115,-0.1803),(1.7218,1.0149,-0.0722),(1.7227,1.0154,0.0361),(1.7185,1.0129,0.1443),(1.7092,1.0075,0.2521),(1.6949,0.9991,0.3591),(1.6757,0.9877,0.4651),(1.6516,0.9735,0.5698),(1.6226,0.9564,0.6727),(1.5888,0.9365,0.7737),(1.5504,0.9139,0.8724),(1.5074,0.8886,0.9686),(1.4600,0.8606,1.0619),(1.4084,0.8302,1.1521),(1.3526,0.7973,1.2389),(1.2928,0.7621,1.3221),(1.2293,0.7246,1.4014),(1.1621,0.6850,1.4766),(1.0915,0.6434,1.5475),(1.0178,0.5999,1.6138),(0.9410,0.5547,1.6754),(0.8615,0.5078,1.7321),(1.5653,0.7414,-1.0000),(1.6120,0.7635,-0.9048),(1.6539,0.7834,-0.8069),(1.6909,0.8009,-0.7066),(1.7230,0.8161,-0.6043),(1.7501,0.8289,-0.5002),(1.7720,0.8393,-0.3946),(1.7887,0.8472,-0.2879),(1.8001,0.8526,-0.1803),(1.8063,0.8556,-0.0722),(1.8072,0.8560,0.0361),(1.8028,0.8539,0.1443),(1.7931,0.8493,0.2521),(1.7781,0.8422,0.3591),(1.7579,0.8327,0.4651),(1.7326,0.8207,0.5698),(1.7022,0.8062,0.6727),(1.6668,0.7895,0.7737),(1.6265,0.7704,0.8724),(1.5814,0.7490,0.9686),(1.5317,0.7255,1.0619),(1.4775,0.6998,1.1521),(1.4190,0.6721,1.2389),(1.3563,0.6424,1.3221),(1.2896,0.6108,1.4014),(1.2191,0.5774,1.4766),(1.1451,0.5424,1.5475),(1.0677,0.5057,1.6138),(0.9872,0.4676,1.6754),(0.9037,0.4281,1.7321),(1.6258,0.5973,-1.0000),(1.6742,0.6151,-0.9048),(1.7178,0.6311,-0.8069),(1.7562,0.6452,-0.7066),(1.7896,0.6575,-0.6043),(1.8177,0.6678,-0.5002),(1.8404,0.6761,-0.3946),(1.8578,0.6825,-0.2879),(1.8697,0.6869,-0.1803),(1.8761,0.6892,-0.0722),(1.8770,0.6896,0.0361),(1.8724,0.6879,0.1443),(1.8623,0.6842,0.2521),(1.8468,0.6785,0.3591),(1.8258,0.6708,0.4651),(1.7995,0.6611,0.5698),(1.7679,0.6495,0.6727),(1.7312,0.6360,0.7737),(1.6893,0.6206,0.8724),(1.6425,0.6034,0.9686),(1.5909,0.5845,1.0619),(1.5346,0.5638,1.1521),(1.4738,0.5414,1.2389),(1.4086,0.5175,1.3221),(1.3394,0.4921,1.4014),(1.2662,0.4652,1.4766),(1.1893,0.4369,1.5475),(1.1089,0.4074,1.6138),(1.0253,0.3767,1.6754),(0.9387,0.3448,1.7321),(1.6730,0.4483,-1.0000),(1.7229,0.4616,-0.9048),(1.7677,0.4736,-0.8069),(1.8073,0.4843,-0.7066),(1.8416,0.4934,-0.6043),(1.8705,0.5012,-0.5002),(1.8939,0.5075,-0.3946),(1.9117,0.5122,-0.2879),(1.9240,0.5155,-0.1803),(1.9306,0.5173,-0.0722),(1.9315,0.5176,0.0361),(1.9268,0.5163,0.1443),(1.9164,0.5135,0.2521),(1.9004,0.5092,0.3591),(1.8789,0.5034,0.4651),(1.8518,0.4962,0.5698),(1.8193,0.4875,0.6727),(1.7814,0.4773,0.7737),(1.7384,0.4658,0.8724),(1.6902,0.4529,0.9686),(1.6371,0.4387,1.0619),(1.5791,0.4231,1.1521),(1.5166,0.4064,1.2389),(1.4496,0.3884,1.3221),(1.3783,0.3693,1.4014),(1.3030,0.3491,1.4766),(1.2239,0.3279,1.5475),(1.1412,0.3058,1.6138),(1.0551,0.2827,1.6754),(0.9659,0.2588,1.7321)]),
        normal=Normal(vector=[(0.8365,-0.2241,0.5000),(0.8614,-0.2308,0.4524),(0.8838,-0.2368,0.4034),(0.9036,-0.2421,0.3533),(0.9208,-0.2467,0.3021),(0.9352,-0.2506,0.2501),(0.9469,-0.2537,0.1973),(0.9559,-0.2561,0.1439),(0.9620,-0.2578,0.0902),(0.9653,-0.2587,0.0361),(0.9658,-0.2588,-0.0181),(0.9634,-0.2581,-0.0722),(0.9582,-0.2568,-0.1260),(0.9502,-0.2546,-0.1796),(0.9394,-0.2517,-0.2326),(0.9259,-0.2481,-0.2849),(0.9096,-0.2437,-0.3364),(0.8907,-0.2387,-0.3868),(0.8692,-0.2329,-0.4362),(0.8451,-0.2264,-0.4843),(0.8185,-0.2193,-0.5309),(0.7896,-0.2116,-0.5760),(0.7583,-0.2032,-0.6194),(0.7248,-0.1942,-0.6610),(0.6892,-0.1847,-0.7007),(0.6515,-0.1746,-0.7383),(0.6119,-0.1640,-0.7737),(0.5706,-0.1529,-0.8069),(0.5275,-0.1414,-0.8377),(0.4830,-0.1294,-0.8660),(0.8129,-0.2986,0.5000),(0.8371,-0.3075,0.4524),(0.8589,-0.3155,0.4034),(0.8781,-0.3226,0.3533),(0.8948,-0.3287,0.3021),(0.9088,-0.3339,0.2501),(0.9202,-0.3381,0.1973),(0.9289,-0.3413,0.1439),(0.9348,-0.3434,0.0902),(0.9380,-0.3446,0.0361),(0.9385,-0.3448,-0.0181),(0.9362,-0.3439,-0.0722),(0.9312,-0.3421,-0.1260),(0.9234,-0.3392,-0.1796),(0.9129,-0.3354,-0.2326),(0.8998,-0.3306,-0.2849),(0.8840,-0.3248,-0.3364),(0.8656,-0.3180,-0.3868),(0.8446,-0.3103,-0.4362),(0.8212,-0.3017,-0.4843),(0.7954,-0.2922,-0.5309),(0.7673,-0.2819,-0.5760),(0.7369,-0.2707,-0.6194),(0.7043,-0.2588,-0.6610),(0.6697,-0.2460,-0.7007),(0.6331,-0.2326,-0.7383),(0.5947,-0.2185,-0.7737),(0.5545,-0.2037,-0.8069),(0.5127,-0.1883,-0.8377),(0.4693,-0.1724,-0.8660),(0.7827,-0.3707,0.5000),(0.8060,-0.3818,0.4524),(0.8269,-0.3917,0.4034),(0.8455,-0.4005,0.3533),(0.8615,-0.4081,0.3021),(0.8750,-0.4145,0.2501),(0.8860,-0.4197,0.1973),(0.8943,-0.4236,0.1439),(0.9001,-0.4263,0.0902),(0.9032,-0.4278,0.0361),(0.9036,-0.4280,-0.0181),(0.9014,-0.4269,-0.0722),(0.8965,-0.4247,-0.1260),(0.8891,-0.4211,-0.1796),(0.8790,-0.4163,-0.2326),(0.8663,-0.4103,-0.2849),(0.8511,-0.4031,-0.3364),(0.8334,-0.3947,-0.3868),(0.8132,-0.3852,-0.4362),(0.7907,-0.3745,-0.4843),(0.7658,-0.3627,-0.5309),(0.7387,-0.3499,-0.5760),(0.7095,-0.3360,-0.6194),(0.6781,-0.3212,-0.6610),(0.6448,-0.3054,-0.7007),(0.6096,-0.2887,-0.7383),(0.5725,-0.2712,-0.7737),(0.5338,-0.2529,-0.8069),(0.4936,-0.2338,-0.8377),(0.4519,-0.2140,-0.8660),(0.7461,-0.4398,0.5000),(0.7683,-0.4529,0.4524),(0.7883,-0.4646,0.4034),(0.8059,-0.4750,0.3533),(0.8212,-0.4841,0.3021),(0.8341,-0.4917,0.2501),(0.8445,-0.4978,0.1973),(0.8525,-0.5025,0.1439),(0.8580,-0.5057,0.0902),(0.8609,-0.5075,0.0361),(0.8613,-0.5077,-0.0181),(0.8592,-0.5065,-0.0722),(0.8546,-0.5037,-0.1260),(0.8475,-0.4995,-0.1796),(0.8379,-0.4939,-0.2326),(0.8258,-0.4868,-0.2849),(0.8113,-0.4782,-0.3364),(0.7944,-0.4683,-0.3868),(0.7752,-0.4569,-0.4362),(0.7537,-0.4443,-0.4843),(0.7300,-0.4303,-0.5309),(0.7042,-0.4151,-0.5760),(0.6763,-0.3986,-0.6194),(0.6464,-0.3810,-0.6610),(0.6146,-0.3623,-0.7007),(0.5810,-0.3425,-0.7383),(0.5458,-0.3217,-0.7737),(0.5089,-0.3000,-0.8069),(0.4705,-0.2773,-0.8377),(0.4307,-0.2539,-0.8660),(0.7034,-0.5052,0.5000),(0.7243,-0.5203,0.4524),(0.7432,-0.5338,0.4034),(0.7598,-0.5458,0.3533),(0.7742,-0.5561,0.3021),(0.7864,-0.5649,0.2501),(0.7962,-0.5719,0.1973),(0.8037,-0.5773,0.1439),(0.8089,-0.5810,0.0902),(0.8117,-0.5830,0.0361),(0.8121,-0.5833,-0.0181),(0.8101,-0.5819,-0.0722),(0.8057,-0.5787,-0.1260),(0.7990,-0.5739,-0.1796),(0.7899,-0.5674,-0.2326),(0.7785,-0.5592,-0.2849),(0.7649,-0.5494,-0.3364),(0.7490,-0.5380,-0.3868),(0.7308,-0.5250,-0.4362),(0.7106,-0.5104,-0.4843),(0.6883,-0.4944,-0.5309),(0.6639,-0.4769,-0.5760),(0.6376,-0.4580,-0.6194),(0.6094,-0.4378,-0.6610),(0.5795,-0.4162,-0.7007),(0.5478,-0.3935,-0.7383),(0.5145,-0.3696,-0.7737),(0.4798,-0.3446,-0.8069),(0.4436,-0.3186,-0.8377),(0.4061,-0.2917,-0.8660),(0.6550,-0.5666,0.5000),(0.6745,-0.5835,0.4524),(0.6920,-0.5986,0.4034),(0.7075,-0.6120,0.3533),(0.7209,-0.6237,0.3021),(0.7323,-0.6335,0.2501),(0.7414,-0.6414,0.1973),(0.7484,-0.6474,0.1439),(0.7532,-0.6516,0.0902),(0.7558,-0.6538,0.0361),(0.7562,-0.6541,-0.0181),(0.7543,-0.6525,-0.0722),(0.7503,-0.6490,-0.1260),(0.7440,-0.6436,-0.1796),(0.7355,-0.6363,-0.2326),(0.7249,-0.6271,-0.2849),(0.7122,-0.6161,-0.3364),(0.6974,-0.6033,-0.3868),(0.6805,-0.5887,-0.4362),(0.6617,-0.5724,-0.4843),(0.6409,-0.5544,-0.5309),(0.6182,-0.5348,-0.5760),(0.5937,-0.5136,-0.6194),(0.5675,-0.4909,-0.6610),(0.5396,-0.4668,-0.7007),(0.5101,-0.4413,-0.7383),(0.4791,-0.4145,-0.7737),(0.4467,-0.3865,-0.8069),(0.4130,-0.3573,-0.8377),(0.3781,-0.3271,-0.8660),(0.6012,-0.6233,0.5000),(0.6191,-0.6419,0.4524),(0.6352,-0.6586,0.4034),(0.6495,-0.6733,0.3533),(0.6618,-0.6861,0.3021),(0.6722,-0.6969,0.2501),(0.6806,-0.7056,0.1973),(0.6870,-0.7123,0.1439),(0.6914,-0.7168,0.0902),(0.6938,-0.7193,0.0361),(0.6941,-0.7196,-0.0181),(0.6924,-0.7179,-0.0722),(0.6887,-0.7140,-0.1260),(0.6829,-0.7081,-0.1796),(0.6752,-0.7000,-0.2326),(0.6655,-0.6899,-0.2849),(0.6538,-0.6778,-0.3364),(0.6402,-0.6637,-0.3868),(0.6247,-0.6477,-0.4362),(0.6074,-0.6297,-0.4843),(0.5883,-0.6099,-0.5309),(0.5675,-0.5883,-0.5760),(0.5450,-0.5650,-0.6194),(0.5209,-0.5401,-0.6610),(0.4953,-0.5135,-0.7007),(0.4682,-0.4855,-0.7383),(0.4398,-0.4560,-0.7737),(0.4101,-0.4252,-0.8069),(0.3792,-0.3931,-0.8377),(0.3471,-0.3599,-0.8660),(0.5426,-0.6750,0.5000),(0.5587,-0.6951,0.4524),(0.5733,-0.7132,0.4034),(0.5861,-0.7291,0.3533),(0.5972,-0.7430,0.3021),(0.6066,-0.7546,0.2501),(0.6142,-0.7641,0.1973),(0.6200,-0.7713,0.1439),(0.6240,-0.7762,0.0902),(0.6261,-0.7789,0.0361),(0.6264,-0.7793,-0.0181),(0.6249,-0.7774,-0.0722),(0.6215,-0.7732,-0.1260),(0.6163,-0.7667,-0.1796),(0.6093,-0.7580,-0.2326),(0.6005,-0.7471,-0.2849),(0.5900,-0.7340,-0.3364),(0.5777,-0.7187,-0.3868),(0.5638,-0.7014,-0.4362),(0.5481,-0.6819,-0.4843),(0.5309,-0.6605,-0.5309),(0.5121,-0.6371,-0.5760),(0.4918,-0.6119,-0.6194),(0.4701,-0.5848,-0.6610),(0.4470,-0.5561,-0.7007),(0.4226,-0.5257,-0.7383),(0.3969,-0.4938,-0.7737),(0.3701,-0.4604,-0.8069),(0.3422,-0.4257,-0.8377),(0.3133,-0.3897,-0.8660),(0.4795,-0.7212,0.5000),(0.4938,-0.7426,0.4524),(0.5066,-0.7619,0.4034),(0.5180,-0.7790,0.3533),(0.5278,-0.7938,0.3021),(0.5361,-0.8063,0.2501),(0.5428,-0.8164,0.1973),(0.5479,-0.8240,0.1439),(0.5514,-0.8293,0.0902),(0.5533,-0.8322,0.0361),(0.5536,-0.8326,-0.0181),(0.5522,-0.8306,-0.0722),(0.5493,-0.8261,-0.1260),(0.5447,-0.8192,-0.1796),(0.5385,-0.8099,-0.2326),(0.5307,-0.7982,-0.2849),(0.5214,-0.7842,-0.3364),(0.5106,-0.7679,-0.3868),(0.4982,-0.7493,-0.4362),(0.4844,-0.7286,-0.4843),(0.4692,-0.7057,-0.5309),(0.4526,-0.6807,-0.5760),(0.4347,-0.6537,-0.6194),(0.4155,-0.6248,-0.6610),(0.3950,-0.5941,-0.7007),(0.3735,-0.5617,-0.7383),(0.3508,-0.5275,-0.7737),(0.3271,-0.4919,-0.8069),(0.3024,-0.4548,-0.8377),(0.2768,-0.4164,-0.8660),(0.4125,-0.7615,0.5000),(0.4248,-0.7841,0.4524),(0.4359,-0.8045,0.4034),(0.4456,-0.8225,0.3533),(0.4541,-0.8382,0.3021),(0.4612,-0.8513,0.2501),(0.4670,-0.8620,0.1973),(0.4714,-0.8701,0.1439),(0.4744,-0.8757,0.0902),(0.4761,-0.8787,0.0361),(0.4763,-0.8791,-0.0181),(0.4751,-0.8770,-0.0722),(0.4726,-0.8722,-0.1260),(0.4686,-0.8650,-0.1796),(0.4633,-0.8551,-0.2326),(0.4566,-0.8428,-0.2849),(0.4486,-0.8280,-0.3364),(0.4393,-0.8108,-0.3868),(0.4287,-0.7912,-0.4362),(0.4168,-0.7693,-0.4843),(0.4037,-0.7451,-0.5309),(0.3894,-0.7187,-0.5760),(0.3740,-0.6902,-0.6194),(0.3574,-0.6597,-0.6610),(0.3399,-0.6273,-0.7007),(0.3213,-0.5930,-0.7383),(0.3018,-0.5570,-0.7737),(0.2814,-0.5194,-0.8069),(0.2602,-0.4802,-0.8377),(0.2382,-0.4396,-0.8660),(0.3422,-0.7955,0.5000),(0.3524,-0.8192,0.4524),(0.3616,-0.8405,0.4034),(0.3697,-0.8594,0.3533),(0.3767,-0.8757,0.3021),(0.3826,-0.8894,0.2501),(0.3874,-0.9006,0.1973),(0.3910,-0.9090,0.1439),(0.3935,-0.9149,0.0902),(0.3949,-0.9180,0.0361),(0.3951,-0.9185,-0.0181),(0.3941,-0.9162,-0.0722),(0.3920,-0.9113,-0.1260),(0.3887,-0.9037,-0.1796),(0.3843,-0.8934,-0.2326),(0.3788,-0.8805,-0.2849),(0.3721,-0.8651,-0.3364),(0.3644,-0.8471,-0.3868),(0.3556,-0.8266,-0.4362),(0.3457,-0.8037,-0.4843),(0.3349,-0.7784,-0.5309),(0.3230,-0.7509,-0.5760),(0.3102,-0.7211,-0.6194),(0.2965,-0.6893,-0.6610),(0.2819,-0.6554,-0.7007),(0.2665,-0.6196,-0.7383),(0.2503,-0.5820,-0.7737),(0.2334,-0.5426,-0.8069),(0.2158,-0.5017,-0.8377),(0.1976,-0.4593,-0.8660),(0.2691,-0.8232,0.5000),(0.2771,-0.8477,0.4524),(0.2843,-0.8697,0.4034),(0.2907,-0.8892,0.3533),(0.2962,-0.9061,0.3021),(0.3009,-0.9203,0.2501),(0.3046,-0.9318,0.1973),(0.3075,-0.9406,0.1439),(0.3095,-0.9466,0.0902),(0.3105,-0.9499,0.0361),(0.3107,-0.9503,-0.0181),(0.3099,-0.9480,-0.0722),(0.3083,-0.9429,-0.1260),(0.3057,-0.9350,-0.1796),(0.3022,-0.9244,-0.2326),(0.2979,-0.9111,-0.2849),(0.2926,-0.8951,-0.3364),(0.2865,-0.8765,-0.3868),(0.2796,-0.8553,-0.4362),(0.2719,-0.8316,-0.4843),(0.2633,-0.8055,-0.5309),(0.2540,-0.7770,-0.5760),(0.2439,-0.7462,-0.6194),(0.2332,-0.7132,-0.6610),(0.2217,-0.6781,-0.7007),(0.2096,-0.6411,-0.7383),(0.1969,-0.6022,-0.7737),(0.1836,-0.5615,-0.8069),(0.1697,-0.5191,-0.8377),(0.1554,-0.4752,-0.8660),(0.1938,-0.8441,0.5000),(0.1996,-0.8692,0.4524),(0.2048,-0.8918,0.4034),(0.2093,-0.9118,0.3533),(0.2133,-0.9291,0.3021),(0.2167,-0.9437,0.2501),(0.2194,-0.9555,0.1973),(0.2214,-0.9645,0.1439),(0.2229,-0.9707,0.0902),(0.2236,-0.9740,0.0361),(0.2237,-0.9745,-0.0181),(0.2232,-0.9721,-0.0722),(0.2220,-0.9669,-0.1260),(0.2201,-0.9588,-0.1796),(0.2176,-0.9479,-0.2326),(0.2145,-0.9343,-0.2849),(0.2107,-0.9179,-0.3364),(0.2064,-0.8988,-0.3868),(0.2014,-0.8770,-0.4362),(0.1958,-0.8527,-0.4843),(0.1896,-0.8259,-0.5309),(0.1829,-0.7967,-0.5760),(0.1757,-0.7651,-0.6194),(0.1679,-0.7313,-0.6610),(0.1597,-0.6954,-0.7007),(0.1509,-0.6574,-0.7383),(0.1418,-0.6175,-0.7737),(0.1322,-0.5757,-0.8069),(0.1222,-0.5323,-0.8377),(0.1119,-0.4873,-0.8660),(0.1169,-0.8581,0.5000),(0.1204,-0.8837,0.4524),(0.1235,-0.9066,0.4034),(0.1263,-0.9269,0.3533),(0.1287,-0.9445,0.3021),(0.1307,-0.9594,0.2501),(0.1323,-0.9714,0.1973),(0.1336,-0.9805,0.1439),(0.1345,-0.9868,0.0902),(0.1349,-0.9902,0.0361),(0.1350,-0.9907,-0.0181),(0.1346,-0.9883,-0.0722),(0.1339,-0.9829,-0.1260),(0.1328,-0.9747,-0.1796),(0.1313,-0.9637,-0.2326),(0.1294,-0.9498,-0.2849),(0.1271,-0.9331,-0.3364),(0.1245,-0.9137,-0.3868),(0.1215,-0.8916,-0.4362),(0.1181,-0.8669,-0.4843),(0.1144,-0.8397,-0.5309),(0.1104,-0.8099,-0.5760),(0.1060,-0.7779,-0.6194),(0.1013,-0.7435,-0.6610),(0.0963,-0.7069,-0.7007),(0.0911,-0.6683,-0.7383),(0.0855,-0.6277,-0.7737),(0.0797,-0.5853,-0.8069),(0.0737,-0.5412,-0.8377),(0.0675,-0.4954,-0.8660),(0.0391,-0.8651,0.5000),(0.0402,-0.8909,0.4524),(0.0413,-0.9141,0.4034),(0.0422,-0.9346,0.3533),(0.0430,-0.9523,0.3021),(0.0437,-0.9672,0.2501),(0.0442,-0.9793,0.1973),(0.0447,-0.9886,0.1439),(0.0449,-0.9949,0.0902),(0.0451,-0.9983,0.0361),(0.0451,-0.9988,-0.0181),(0.0450,-0.9964,-0.0722),(0.0448,-0.9910,-0.1260),(0.0444,-0.9827,-0.1796),(0.0439,-0.9716,-0.2326),(0.0433,-0.9576,-0.2849),(0.0425,-0.9408,-0.3364),(0.0416,-0.9212,-0.3868),(0.0406,-0.8989,-0.4362),(0.0395,-0.8740,-0.4843),(0.0382,-0.8465,-0.5309),(0.0369,-0.8166,-0.5760),(0.0354,-0.7842,-0.6194),(0.0339,-0.7496,-0.6610),(0.0322,-0.7127,-0.7007),(0.0304,-0.6738,-0.7383),(0.0286,-0.6329,-0.7737),(0.0267,-0.5901,-0.8069),(0.0246,-0.5456,-0.8377),(0.0226,-0.4995,-0.8660),(-0.0391,-0.8651,0.5000),(-0.0402,-0.8909,0.4524),(-0.0413,-0.9141,0.4034),(-0.0422,-0.9346,0.3533),(-0.0430,-0.9523,0.3021),(-0.0437,-0.9672,0.2501),(-0.0442,-0.9793,0.1973),(-0.0447,-0.9886,0.1439),(-0.0449,-0.9949,0.0902),(-0.0451,-0.9983,0.0361),(-0.0451,-0.9988,-0.0181),(-0.0450,-0.9964,-0.0722),(-0.0448,-0.9910,-0.1260),(-0.0444,-0.9827,-0.1796),(-0.0439,-0.9716,-0.2326),(-0.0433,-0.9576,-0.2849),(-0.0425,-0.9408,-0.3364),(-0.0416,-0.9212,-0.3868),(-0.0406,-0.8989,-0.4362),(-0.0395,-0.8740,-0.4843),(-0.0382,-0.8465,-0.5309),(-0.0369,-0.8166,-0.5760),(-0.0354,-0.7842,-0.6194),(-0.0339,-0.7496,-0.6610),(-0.0322,-0.7127,-0.7007),(-0.0304,-0.6738,-0.7383),(-0.0286,-0.6329,-0.7737),(-0.0267,-0.5901,-0.8069),(-0.0246,-0.5456,-0.8377),(-0.0226,-0.4995,-0.8660),(-0.1169,-0.8581,0.5000),(-0.1204,-0.8837,0.4524),(-0.1235,-0.9066,0.4034),(-0.1263,-0.9269,0.3533),(-0.1287,-0.9445,0.3021),(-0.1307,-0.9594,0.2501),(-0.1323,-0.9714,0.1973),(-0.1336,-0.9805,0.1439),(-0.1345,-0.9868,0.0902),(-0.1349,-0.9902,0.0361),(-0.1350,-0.9907,-0.0181),(-0.1346,-0.9883,-0.0722),(-0.1339,-0.9829,-0.1260),(-0.1328,-0.9747,-0.1796),(-0.1313,-0.9637,-0.2326),(-0.1294,-0.9498,-0.2849),(-0.1271,-0.9331,-0.3364),(-0.1245,-0.9137,-0.3868),(-0.1215,-0.8916,-0.4362),(-0.1181,-0.8669,-0.4843),(-0.1144,-0.8397,-0.5309),(-0.1104,-0.8099,-0.5760),(-0.1060,-0.7779,-0.6194),(-0.1013,-0.7435,-0.6610),(-0.0963,-0.7069,-0.7007),(-0.0911,-0.6683,-0.7383),(-0.0855,-0.6277,-0.7737),(-0.0797,-0.5853,-0.8069),(-0.0737,-0.5412,-0.8377),(-0.0675,-0.4954,-0.8660),(-0.1938,-0.8441,0.5000),(-0.1996,-0.8692,0.4524),(-0.2048,-0.8918,0.4034),(-0.2093,-0.9118,0.3533),(-0.2133,-0.9291,0.3021),(-0.2167,-0.9437,0.2501),(-0.2194,-0.9555,0.1973),(-0.2214,-0.9645,0.1439),(-0.2229,-0.9707,0.0902),(-0.2236,-0.9740,0.0361),(-0.2237,-0.9745,-0.0181),(-0.2232,-0.9721,-0.0722),(-0.2220,-0.9669,-0.1260),(-0.2201,-0.9588,-0.1796),(-0.2176,-0.9479,-0.2326),(-0.2145,-0.9343,-0.2849),(-0.2107,-0.9179,-0.3364),(-0.2064,-0.8988,-0.3868),(-0.2014,-0.8770,-0.4362),(-0.1958,-0.8527,-0.4843),(-0.1896,-0.8259,-0.5309),(-0.1829,-0.7967,-0.5760),(-0.1757,-0.7651,-0.6194),(-0.1679,-0.7313,-0.6610),(-0.1597,-0.6954,-0.7007),(-0.1509,-0.6574,-0.7383),(-0.1418,-0.6175,-0.7737),(-0.1322,-0.5757,-0.8069),(-0.1222,-0.5323,-0.8377),(-0.1119,-0.4873,-0.8660),(-0.2691,-0.8232,0.5000),(-0.2771,-0.8477,0.4524),(-0.2843,-0.8697,0.4034),(-0.2907,-0.8892,0.3533),(-0.2962,-0.9061,0.3021),(-0.3009,-0.9203,0.2501),(-0.3046,-0.9318,0.1973),(-0.3075,-0.9406,0.1439),(-0.3095,-0.9466,0.0902),(-0.3105,-0.9499,0.0361),(-0.3107,-0.9503,-0.0181),(-0.3099,-0.9480,-0.0722),(-0.3083,-0.9429,-0.1260),(-0.3057,-0.9350,-0.1796),(-0.3022,-0.9244,-0.2326),(-0.2979,-0.9111,-0.2849),(-0.2926,-0.8951,-0.3364),(-0.2865,-0.8765,-0.3868),(-0.2796,-0.8553,-0.4362),(-0.2719,-0.8316,-0.4843),(-0.2633,-0.8055,-0.5309),(-0.2540,-0.7770,-0.5760),(-0.2439,-0.7462,-0.6194),(-0.2332,-0.7132,-0.6610),(-0.2217,-0.6781,-0.7007),(-0.2096,-0.6411,-0.7383),(-0.1969,-0.6022,-0.7737),(-0.1836,-0.5615,-0.8069),(-0.1697,-0.5191,-0.8377),(-0.1554,-0.4752,-0.8660),(-0.3422,-0.7955,0.5000),(-0.3524,-0.8192,0.4524),(-0.3616,-0.8405,0.4034),(-0.3697,-0.8594,0.3533),(-0.3767,-0.8757,0.3021),(-0.3826,-0.8894,0.2501),(-0.3874,-0.9006,0.1973),(-0.3910,-0.9090,0.1439),(-0.3935,-0.9149,0.0902),(-0.3949,-0.9180,0.0361),(-0.3951,-0.9185,-0.0181),(-0.3941,-0.9162,-0.0722),(-0.3920,-0.9113,-0.1260),(-0.3887,-0.9037,-0.1796),(-0.3843,-0.8934,-0.2326),(-0.3788,-0.8805,-0.2849),(-0.3721,-0.8651,-0.3364),(-0.3644,-0.8471,-0.3868),(-0.3556,-0.8266,-0.4362),(-0.3457,-0.8037,-0.4843),(-0.3349,-0.7784,-0.5309),(-0.3230,-0.7509,-0.5760),(-0.3102,-0.7211,-0.6194),(-0.2965,-0.6893,-0.6610),(-0.2819,-0.6554,-0.7007),(-0.2665,-0.6196,-0.7383),(-0.2503,-0.5820,-0.7737),(-0.2334,-0.5426,-0.8069),(-0.2158,-0.5017,-0.8377),(-0.1976,-0.4593,-0.8660),(-0.4125,-0.7615,0.5000),(-0.4248,-0.7841,0.4524),(-0.4359,-0.8045,0.4034),(-0.4456,-0.8225,0.3533),(-0.4541,-0.8382,0.3021),(-0.4612,-0.8513,0.2501),(-0.4670,-0.8620,0.1973),(-0.4714,-0.8701,0.1439),(-0.4744,-0.8757,0.0902),(-0.4761,-0.8787,0.0361),(-0.4763,-0.8791,-0.0181),(-0.4751,-0.8770,-0.0722),(-0.4726,-0.8722,-0.1260),(-0.4686,-0.8650,-0.1796),(-0.4633,-0.8551,-0.2326),(-0.4566,-0.8428,-0.2849),(-0.4486,-0.8280,-0.3364),(-0.4393,-0.8108,-0.3868),(-0.4287,-0.7912,-0.4362),(-0.4168,-0.7693,-0.4843),(-0.4037,-0.7451,-0.5309),(-0.3894,-0.7187,-0.5760),(-0.3740,-0.6902,-0.6194),(-0.3574,-0.6597,-0.6610),(-0.3399,-0.6273,-0.7007),(-0.3213,-0.5930,-0.7383),(-0.3018,-0.5570,-0.7737),(-0.2814,-0.5194,-0.8069),(-0.2602,-0.4802,-0.8377),(-0.2382,-0.4396,-0.8660),(-0.4795,-0.7212,0.5000),(-0.4938,-0.7426,0.4524),(-0.5066,-0.7619,0.4034),(-0.5180,-0.7790,0.3533),(-0.5278,-0.7938,0.3021),(-0.5361,-0.8063,0.2501),(-0.5428,-0.8164,0.1973),(-0.5479,-0.8240,0.1439),(-0.5514,-0.8293,0.0902),(-0.5533,-0.8322,0.0361),(-0.5536,-0.8326,-0.0181),(-0.5522,-0.8306,-0.0722),(-0.5493,-0.8261,-0.1260),(-0.5447,-0.8192,-0.1796),(-0.5385,-0.8099,-0.2326),(-0.5307,-0.7982,-0.2849),(-0.5214,-0.7842,-0.3364),(-0.5106,-0.7679,-0.3868),(-0.4982,-0.7493,-0.4362),(-0.4844,-0.7286,-0.4843),(-0.4692,-0.7057,-0.5309),(-0.4526,-0.6807,-0.5760),(-0.4347,-0.6537,-0.6194),(-0.4155,-0.6248,-0.6610),(-0.3950,-0.5941,-0.7007),(-0.3735,-0.5617,-0.7383),(-0.3508,-0.5275,-0.7737),(-0.3271,-0.4919,-0.8069),(-0.3024,-0.4548,-0.8377),(-0.2768,-0.4164,-0.8660),(-0.5426,-0.6750,0.5000),(-0.5587,-0.6951,0.4524),(-0.5733,-0.7132,0.4034),(-0.5861,-0.7291,0.3533),(-0.5972,-0.7430,0.3021),(-0.6066,-0.7546,0.2501),(-0.6142,-0.7641,0.1973),(-0.6200,-0.7713,0.1439),(-0.6240,-0.7762,0.0902),(-0.6261,-0.7789,0.0361),(-0.6264,-0.7793,-0.0181),(-0.6249,-0.7774,-0.0722),(-0.6215,-0.7732,-0.1260),(-0.6163,-0.7667,-0.1796),(-0.6093,-0.7580,-0.2326),(-0.6005,-0.7471,-0.2849),(-0.5900,-0.7340,-0.3364),(-0.5777,-0.7187,-0.3868),(-0.5638,-0.7014,-0.4362),(-0.5481,-0.6819,-0.4843),(-0.5309,-0.6605,-0.5309),(-0.5121,-0.6371,-0.5760),(-0.4918,-0.6119,-0.6194),(-0.4701,-0.5848,-0.6610),(-0.4470,-0.5561,-0.7007),(-0.4226,-0.5257,-0.7383),(-0.3969,-0.4938,-0.7737),(-0.3701,-0.4604,-0.8069),(-0.3422,-0.4257,-0.8377),(-0.3133,-0.3897,-0.8660),(-0.6012,-0.6233,0.5000),(-0.6191,-0.6419,0.4524),(-0.6352,-0.6586,0.4034),(-0.6495,-0.6733,0.3533),(-0.6618,-0.6861,0.3021),(-0.6722,-0.6969,0.2501),(-0.6806,-0.7056,0.1973),(-0.6870,-0.7123,0.1439),(-0.6914,-0.7168,0.0902),(-0.6938,-0.7193,0.0361),(-0.6941,-0.7196,-0.0181),(-0.6924,-0.7179,-0.0722),(-0.6887,-0.7140,-0.1260),(-0.6829,-0.7081,-0.1796),(-0.6752,-0.7000,-0.2326),(-0.6655,-0.6899,-0.2849),(-0.6538,-0.6778,-0.3364),(-0.6402,-0.6637,-0.3868),(-0.6247,-0.6477,-0.4362),(-0.6074,-0.6297,-0.4843),(-0.5883,-0.6099,-0.5309),(-0.5675,-0.5883,-0.5760),(-0.5450,-0.5650,-0.6194),(-0.5209,-0.5401,-0.6610),(-0.4953,-0.5135,-0.7007),(-0.4682,-0.4855,-0.7383),(-0.4398,-0.4560,-0.7737),(-0.4101,-0.4252,-0.8069),(-0.3792,-0.3931,-0.8377),(-0.3471,-0.3599,-0.8660),(-0.6550,-0.5666,0.5000),(-0.6745,-0.5835,0.4524),(-0.6920,-0.5986,0.4034),(-0.7075,-0.6120,0.3533),(-0.7209,-0.6237,0.3021),(-0.7323,-0.6335,0.2501),(-0.7414,-0.6414,0.1973),(-0.7484,-0.6474,0.1439),(-0.7532,-0.6516,0.0902),(-0.7558,-0.6538,0.0361),(-0.7562,-0.6541,-0.0181),(-0.7543,-0.6525,-0.0722),(-0.7503,-0.6490,-0.1260),(-0.7440,-0.6436,-0.1796),(-0.7355,-0.6363,-0.2326),(-0.7249,-0.6271,-0.2849),(-0.7122,-0.6161,-0.3364),(-0.6974,-0.6033,-0.3868),(-0.6805,-0.5887,-0.4362),(-0.6617,-0.5724,-0.4843),(-0.6409,-0.5544,-0.5309),(-0.6182,-0.5348,-0.5760),(-0.5937,-0.5136,-0.6194),(-0.5675,-0.4909,-0.6610),(-0.5396,-0.4668,-0.7007),(-0.5101,-0.4413,-0.7383),(-0.4791,-0.4145,-0.7737),(-0.4467,-0.3865,-0.8069),(-0.4130,-0.3573,-0.8377),(-0.3781,-0.3271,-0.8660),(-0.7034,-0.5052,0.5000),(-0.7243,-0.5203,0.4524),(-0.7432,-0.5338,0.4034),(-0.7598,-0.5458,0.3533),(-0.7742,-0.5561,0.3021),(-0.7864,-0.5649,0.2501),(-0.7962,-0.5719,0.1973),(-0.8037,-0.5773,0.1439),(-0.8089,-0.5810,0.0902),(-0.8117,-0.5830,0.0361),(-0.8121,-0.5833,-0.0181),(-0.8101,-0.5819,-0.0722),(-0.8057,-0.5787,-0.1260),(-0.7990,-0.5739,-0.1796),(-0.7899,-0.5674,-0.2326),(-0.7785,-0.5592,-0.2849),(-0.7649,-0.5494,-0.3364),(-0.7490,-0.5380,-0.3868),(-0.7308,-0.5250,-0.4362),(-0.7106,-0.5104,-0.4843),(-0.6883,-0.4944,-0.5309),(-0.6639,-0.4769,-0.5760),(-0.6376,-0.4580,-0.6194),(-0.6094,-0.4378,-0.6610),(-0.5795,-0.4162,-0.7007),(-0.5478,-0.3935,-0.7383),(-0.5145,-0.3696,-0.7737),(-0.4798,-0.3446,-0.8069),(-0.4436,-0.3186,-0.8377),(-0.4061,-0.2917,-0.8660),(-0.7461,-0.4398,0.5000),(-0.7683,-0.4529,0.4524),(-0.7883,-0.4646,0.4034),(-0.8059,-0.4750,0.3533),(-0.8212,-0.4841,0.3021),(-0.8341,-0.4917,0.2501),(-0.8445,-0.4978,0.1973),(-0.8525,-0.5025,0.1439),(-0.8580,-0.5057,0.0902),(-0.8609,-0.5075,0.0361),(-0.8613,-0.5077,-0.0181),(-0.8592,-0.5065,-0.0722),(-0.8546,-0.5037,-0.1260),(-0.8475,-0.4995,-0.1796),(-0.8379,-0.4939,-0.2326),(-0.8258,-0.4868,-0.2849),(-0.8113,-0.4782,-0.3364),(-0.7944,-0.4683,-0.3868),(-0.7752,-0.4569,-0.4362),(-0.7537,-0.4443,-0.4843),(-0.7300,-0.4303,-0.5309),(-0.7042,-0.4151,-0.5760),(-0.6763,-0.3986,-0.6194),(-0.6464,-0.3810,-0.6610),(-0.6146,-0.3623,-0.7007),(-0.5810,-0.3425,-0.7383),(-0.5458,-0.3217,-0.7737),(-0.5089,-0.3000,-0.8069),(-0.4705,-0.2773,-0.8377),(-0.4307,-0.2539,-0.8660),(-0.7827,-0.3707,0.5000),(-0.8060,-0.3818,0.4524),(-0.8269,-0.3917,0.4034),(-0.8455,-0.4005,0.3533),(-0.8615,-0.4081,0.3021),(-0.8750,-0.4145,0.2501),(-0.8860,-0.4197,0.1973),(-0.8943,-0.4236,0.1439),(-0.9001,-0.4263,0.0902),(-0.9032,-0.4278,0.0361),(-0.9036,-0.4280,-0.0181),(-0.9014,-0.4269,-0.0722),(-0.8965,-0.4247,-0.1260),(-0.8891,-0.4211,-0.1796),(-0.8790,-0.4163,-0.2326),(-0.8663,-0.4103,-0.2849),(-0.8511,-0.4031,-0.3364),(-0.8334,-0.3947,-0.3868),(-0.8132,-0.3852,-0.4362),(-0.7907,-0.3745,-0.4843),(-0.7658,-0.3627,-0.5309),(-0.7387,-0.3499,-0.5760),(-0.7095,-0.3360,-0.6194),(-0.6781,-0.3212,-0.6610),(-0.6448,-0.3054,-0.7007),(-0.6096,-0.2887,-0.7383),(-0.5725,-0.2712,-0.7737),(-0.5338,-0.2529,-0.8069),(-0.4936,-0.2338,-0.8377),(-0.4519,-0.2140,-0.8660),(-0.8129,-0.2986,0.5000),(-0.8371,-0.3075,0.4524),(-0.8589,-0.3155,0.4034),(-0.8781,-0.3226,0.3533),(-0.8948,-0.3287,0.3021),(-0.9088,-0.3339,0.2501),(-0.9202,-0.3381,0.1973),(-0.9289,-0.3413,0.1439),(-0.9348,-0.3434,0.0902),(-0.9380,-0.3446,0.0361),(-0.9385,-0.3448,-0.0181),(-0.9362,-0.3439,-0.0722),(-0.9312,-0.3421,-0.1260),(-0.9234,-0.3392,-0.1796),(-0.9129,-0.3354,-0.2326),(-0.8998,-0.3306,-0.2849),(-0.8840,-0.3248,-0.3364),(-0.8656,-0.3180,-0.3868),(-0.8446,-0.3103,-0.4362),(-0.8212,-0.3017,-0.4843),(-0.7954,-0.2922,-0.5309),(-0.7673,-0.2819,-0.5760),(-0.7369,-0.2707,-0.6194),(-0.7043,-0.2588,-0.6610),(-0.6697,-0.2460,-0.7007),(-0.6331,-0.2326,-0.7383),(-0.5947,-0.2185,-0.7737),(-0.5545,-0.2037,-0.8069),(-0.5127,-0.1883,-0.8377),(-0.4693,-0.1724,-0.8660),(-0.8365,-0.2241,0.5000),(-0.8614,-0.2308,0.4524),(-0.8838,-0.2368,0.4034),(-0.9036,-0.2421,0.3533),(-0.9208,-0.2467,0.3021),(-0.9352,-0.2506,0.2501),(-0.9469,-0.2537,0.1973),(-0.9559,-0.2561,0.1439),(-0.9620,-0.2578,0.0902),(-0.9653,-0.2587,0.0361),(-0.9658,-0.2588,-0.0181),(-0.9634,-0.2581,-0.0722),(-0.9582,-0.2568,-0.1260),(-0.9502,-0.2546,-0.1796),(-0.9394,-0.2517,-0.2326),(-0.9259,-0.2481,-0.2849),(-0.9096,-0.2437,-0.3364),(-0.8907,-0.2387,-0.3868),(-0.8692,-0.2329,-0.4362),(-0.8451,-0.2264,-0.4843),(-0.8185,-0.2193,-0.5309),(-0.7896,-0.2116,-0.5760),(-0.7583,-0.2032,-0.6194),(-0.7248,-0.1942,-0.6610),(-0.6892,-0.1847,-0.7007),(-0.6515,-0.1746,-0.7383),(-0.6119,-0.1640,-0.7737),(-0.5706,-0.1529,-0.8069),(-0.5275,-0.1414,-0.8377),(-0.4830,-0.1294,-0.8660)]),
        texCoord=TextureCoordinate(point=[(0.0000,0.0000),(0.0000,0.0345),(0.0000,0.0690),(0.0000,0.1034),(0.0000,0.1379),(0.0000,0.1724),(0.0000,0.2069),(0.0000,0.2414),(0.0000,0.2759),(0.0000,0.3103),(0.0000,0.3448),(0.0000,0.3793),(0.0000,0.4138),(0.0000,0.4483),(0.0000,0.4828),(0.0000,0.5172),(0.0000,0.5517),(0.0000,0.5862),(0.0000,0.6207),(0.0000,0.6552),(0.0000,0.6897),(0.0000,0.7241),(0.0000,0.7586),(0.0000,0.7931),(0.0000,0.8276),(0.0000,0.8621),(0.0000,0.8966),(0.0000,0.9310),(0.0000,0.9655),(0.0000,1.0000),(0.0345,0.0000),(0.0345,0.0345),(0.0345,0.0690),(0.0345,0.1034),(0.0345,0.1379),(0.0345,0.1724),(0.0345,0.2069),(0.0345,0.2414),(0.0345,0.2759),(0.0345,0.3103),(0.0345,0.3448),(0.0345,0.3793),(0.0345,0.4138),(0.0345,0.4483),(0.0345,0.4828),(0.0345,0.5172),(0.0345,0.5517),(0.0345,0.5862),(0.0345,0.6207),(0.0345,0.6552),(0.0345,0.6897),(0.0345,0.7241),(0.0345,0.7586),(0.0345,0.7931),(0.0345,0.8276),(0.0345,0.8621),(0.0345,0.8966),(0.0345,0.9310),(0.0345,0.9655),(0.0345,1.0000),(0.0690,0.0000),(0.0690,0.0345),(0.0690,0.0690),(0.0690,0.1034),(0.0690,0.1379),(0.0690,0.1724),(0.0690,0.2069),(0.0690,0.2414),(0.0690,0.2759),(0.0690,0.3103),(0.0690,0.3448),(0.0690,0.3793),(0.0690,0.4138),(0.0690,0.4483),(0.0690,0.4828),(0.0690,0.5172),(0.0690,0.5517),(0.0690,0.5862),(0.0690,0.6207),(0.0690,0.6552),(0.0690,0.6897),(0.0690,0.7241),(0.0690,0.7586),(0.0690,0.7931),(0.0690,0.8276),(0.0690,0.8621),(0.0690,0.8966),(0.0690,0.9310),(0.0690,0.9655),(0.0690,1.0000),(0.1034,0.0000),(0.1034,0.0345),(0.1034,0.0690),(0.1034,0.1034),(0.1034,0.1379),(0.1034,0.1724),(0.1034,0.2069),(0.1034,0.2414),(0.1034,0.2759),(0.1034,0.3103),(0.1034,0.3448),(0.1034,0.3793),(0.1034,0.4138),(0.1034,0.4483),(0.1034,0.4828),(0.1034,0.5172),(0.1034,0.5517),(0.1034,0.5862),(0.1034,0.6207),(0.1034,0.6552),(0.1034,0.6897),(0.1034,0.7241),(0.1034,0.7586),(0.1034,0.7931),(0.1034,0.8276),(0.1034,0.8621),(0.1034,0.8966),(0.1034,0.9310),(0.1034,0.9655),(0.1034,1.0000),(0.1379,0.0000),(0.1379,0.0345),(0.1379,0.0690),(0.1379,0.1034),(0.1379,0.1379),(0.1379,0.1724),(0.1379,0.2069),(0.1379,0.2414),(0.1379,0.2759),(0.1379,0.3103),(0.1379,0.3448),(0.1379,0.3793),(0.1379,0.4138),(0.1379,0.4483),(0.1379,0.4828),(0.1379,0.5172),(0.1379,0.5517),(0.1379,0.5862),(0.1379,0.6207),(0.1379,0.6552),(0.1379,0.6897),(0.1379,0.7241),(0.1379,0.7586),(0.1379,0.7931),(0.1379,0.8276),(0.1379,0.8621),(0.1379,0.8966),(0.1379,0.9310),(0.1379,0.9655),(0.1379,1.0000),(0.1724,0.0000),(0.1724,0.0345),(0.1724,0.0690),(0.1724,0.1034),(0.1724,0.1379),(0.1724,0.1724),(0.1724,0.2069),(0.1724,0.2414),(0.1724,0.2759),(0.1724,0.3103),(0.1724,0.3448),(0.1724,0.3793),(0.1724,0.4138),(0.1724,0.4483),(0.1724,0.4828),(0.1724,0.5172),(0.1724,0.5517),(0.1724,0.5862),(0.1724,0.6207),(0.1724,0.6552),(0.1724,0.6897),(0.1724,0.7241),(0.1724,0.7586),(0.1724,0.7931),(0.1724,0.8276),(0.1724,0.8621),(0.1724,0.8966),(0.1724,0.9310),(0.1724,0.9655),(0.1724,1.0000),(0.2069,0.0000),(0.2069,0.0345),(0.2069,0.0690),(0.2069,0.1034),(0.2069,0.1379),(0.2069,0.1724),(0.2069,0.2069),(0.2069,0.2414),(0.2069,0.2759),(0.2069,0.3103),(0.2069,0.3448),(0.2069,0.3793),(0.2069,0.4138),(0.2069,0.4483),(0.2069,0.4828),(0.2069,0.5172),(0.2069,0.5517),(0.2069,0.5862),(0.2069,0.6207),(0.2069,0.6552),(0.2069,0.6897),(0.2069,0.7241),(0.2069,0.7586),(0.2069,0.7931),(0.2069,0.8276),(0.2069,0.8621),(0.2069,0.8966),(0.2069,0.9310),(0.2069,0.9655),(0.2069,1.0000),(0.2414,0.0000),(0.2414,0.0345),(0.2414,0.0690),(0.2414,0.1034),(0.2414,0.1379),(0.2414,0.1724),(0.2414,0.2069),(0.2414,0.2414),(0.2414,0.2759),(0.2414,0.3103),(0.2414,0.3448),(0.2414,0.3793),(0.2414,0.4138),(0.2414,0.4483),(0.2414,0.4828),(0.2414,0.5172),(0.2414,0.5517),(0.2414,0.5862),(0.2414,0.6207),(0.2414,0.6552),(0.2414,0.6897),(0.2414,0.7241),(0.2414,0.7586),(0.2414,0.7931),(0.2414,0.8276),(0.2414,0.8621),(0.2414,0.8966),(0.2414,0.9310),(0.2414,0.9655),(0.2414,1.0000),(0.2759,0.0000),(0.2759,0.0345),(0.2759,0.0690),(0.2759,0.1034),(0.2759,0.1379),(0.2759,0.1724),(0.2759,0.2069),(0.2759,0.2414),(0.2759,0.2759),(0.2759,0.3103),(0.2759,0.3448),(0.2759,0.3793),(0.2759,0.4138),(0.2759,0.4483),(0.2759,0.4828),(0.2759,0.5172),(0.2759,0.5517),(0.2759,0.5862),(0.2759,0.6207),(0.2759,0.6552),(0.2759,0.6897),(0.2759,0.7241),(0.2759,0.7586),(0.2759,0.7931),(0.2759,0.8276),(0.2759,0.8621),(0.2759,0.8966),(0.2759,0.9310),(0.2759,0.9655),(0.2759,1.0000),(0.3103,0.0000),(0.3103,0.0345),(0.3103,0.0690),(0.3103,0.1034),(0.3103,0.1379),(0.3103,0.1724),(0.3103,0.2069),(0.3103,0.2414),(0.3103,0.2759),(0.3103,0.3103),(0.3103,0.3448),(0.3103,0.3793),(0.3103,0.4138),(0.3103,0.4483),(0.3103,0.4828),(0.3103,0.5172),(0.3103,0.5517),(0.3103,0.5862),(0.3103,0.6207),(0.3103,0.6552),(0.3103,0.6897),(0.3103,0.7241),(0.3103,0.7586),(0.3103,0.7931),(0.3103,0.8276),(0.3103,0.8621),(0.3103,0.8966),(0.3103,0.9310),(0.3103,0.9655),(0.3103,1.0000),(0.3448,0.0000),(0.3448,0.0345),(0.3448,0.0690),(0.3448,0.1034),(0.3448,0.1379),(0.3448,0.1724),(0.3448,0.2069),(0.3448,0.2414),(0.3448,0.2759),(0.3448,0.3103),(0.3448,0.3448),(0.3448,0.3793),(0.3448,0.4138),(0.3448,0.4483),(0.3448,0.4828),(0.3448,0.5172),(0.3448,0.5517),(0.3448,0.5862),(0.3448,0.6207),(0.3448,0.6552),(0.3448,0.6897),(0.3448,0.7241),(0.3448,0.7586),(0.3448,0.7931),(0.3448,0.8276),(0.3448,0.8621),(0.3448,0.8966),(0.3448,0.9310),(0.3448,0.9655),(0.3448,1.0000),(0.3793,0.0000),(0.3793,0.0345),(0.3793,0.0690),(0.3793,0.1034),(0.3793,0.1379),(0.3793,0.1724),(0.3793,0.2069),(0.3793,0.2414),(0.3793,0.2759),(0.3793,0.3103),(0.3793,0.3448),(0.3793,0.3793),(0.3793,0.4138),(0.3793,0.4483),(0.3793,0.4828),(0.3793,0.5172),(0.3793,0.5517),(0.3793,0.5862),(0.3793,0.6207),(0.3793,0.6552),(0.3793,0.6897),(0.3793,0.7241),(0.3793,0.7586),(0.3793,0.7931),(0.3793,0.8276),(0.3793,0.8621),(0.3793,0.8966),(0.3793,0.9310),(0.3793,0.9655),(0.3793,1.0000),(0.4138,0.0000),(0.4138,0.0345),(0.4138,0.0690),(0.4138,0.1034),(0.4138,0.1379),(0.4138,0.1724),(0.4138,0.2069),(0.4138,0.2414),(0.4138,0.2759),(0.4138,0.3103),(0.4138,0.3448),(0.4138,0.3793),(0.4138,0.4138),(0.4138,0.4483),(0.4138,0.4828),(0.4138,0.5172),(0.4138,0.5517),(0.4138,0.5862),(0.4138,0.6207),(0.4138,0.6552),(0.4138,0.6897),(0.4138,0.7241),(0.4138,0.7586),(0.4138,0.7931),(0.4138,0.8276),(0.4138,0.8621),(0.4138,0.8966),(0.4138,0.9310),(0.4138,0.9655),(0.4138,1.0000),(0.4483,0.0000),(0.4483,0.0345),(0.4483,0.0690),(0.4483,0.1034),(0.4483,0.1379),(0.4483,0.1724),(0.4483,0.2069),(0.4483,0.2414),(0.4483,0.2759),(0.4483,0.3103),(0.4483,0.3448),(0.4483,0.3793),(0.4483,0.4138),(0.4483,0.4483),(0.4483,0.4828),(0.4483,0.5172),(0.4483,0.5517),(0.4483,0.5862),(0.4483,0.6207),(0.4483,0.6552),(0.4483,0.6897),(0.4483,0.7241),(0.4483,0.7586),(0.4483,0.7931),(0.4483,0.8276),(0.4483,0.8621),(0.4483,0.8966),(0.4483,0.9310),(0.4483,0.9655),(0.4483,1.0000),(0.4828,0.0000),(0.4828,0.0345),(0.4828,0.0690),(0.4828,0.1034),(0.4828,0.1379),(0.4828,0.1724),(0.4828,0.2069),(0.4828,0.2414),(0.4828,0.2759),(0.4828,0.3103),(0.4828,0.3448),(0.4828,0.3793),(0.4828,0.4138),(0.4828,0.4483),(0.4828,0.4828),(0.4828,0.5172),(0.4828,0.5517),(0.4828,0.5862),(0.4828,0.6207),(0.4828,0.6552),(0.4828,0.6897),(0.4828,0.7241),(0.4828,0.7586),(0.4828,0.7931),(0.4828,0.8276),(0.4828,0.8621),(0.4828,0.8966),(0.4828,0.9310),(0.4828,0.9655),(0.4828,1.0000),(0.5172,0.0000),(0.5172,0.0345),(0.5172,0.0690),(0.5172,0.1034),(0.5172,0.1379),(0.5172,0.1724),(0.5172,0.2069),(0.5172,0.2414),(0.5172,0.2759),(0.5172,0.3103),(0.5172,0.3448),(0.5172,0.3793),(0.5172,0.4138),(0.5172,0.4483),(0.5172,0.4828),(0.5172,0.5172),(0.5172,0.5517),(0.5172,0.5862),(0.5172,0.6207),(0.5172,0.6552),(0.5172,0.6897),(0.5172,0.7241),(0.5172,0.7586),(0.5172,0.7931),(0.5172,0.8276),(0.5172,0.8621),(0.5172,0.8966),(0.5172,0.9310),(0.5172,0.9655),(0.5172,1.0000),(0.5517,0.0000),(0.5517,0.0345),(0.5517,0.0690),(0.5517,0.1034),(0.5517,0.1379),(0.5517,0.1724),(0.5517,0.2069),(0.5517,0.2414),(0.5517,0.2759),(0.5517,0.3103),(0.5517,0.3448),(0.5517,0.3793),(0.5517,0.4138),(0.5517,0.4483),(0.5517,0.4828),(0.5517,0.5172),(0.5517,0.5517),(0.5517,0.5862),(0.5517,0.6207),(0.5517,0.6552),(0.5517,0.6897),(0.5517,0.7241),(0.5517,0.7586),(0.5517,0.7931),(0.5517,0.8276),(0.5517,0.8621),(0.5517,0.8966),(0.5517,0.9310),(0.5517,0.9655),(0.5517,1.0000),(0.5862,0.0000),(0.5862,0.0345),(0.5862,0.0690),(0.5862,0.1034),(0.5862,0.1379),(0.5862,0.1724),(0.5862,0.2069),(0.5862,0.2414),(0.5862,0.2759),(0.5862,0.3103),(0.5862,0.3448),(0.5862,0.3793),(0.5862,0.4138),(0.5862,0.4483),(0.5862,0.4828),(0.5862,0.5172),(0.5862,0.5517),(0.5862,0.5862),(0.5862,0.6207),(0.5862,0.6552),(0.5862,0.6897),(0.5862,0.7241),(0.5862,0.7586),(0.5862,0.7931),(0.5862,0.8276),(0.5862,0.8621),(0.5862,0.8966),(0.5862,0.9310),(0.5862,0.9655),(0.5862,1.0000),(0.6207,0.0000),(0.6207,0.0345),(0.6207,0.0690),(0.6207,0.1034),(0.6207,0.1379),(0.6207,0.1724),(0.6207,0.2069),(0.6207,0.2414),(0.6207,0.2759),(0.6207,0.3103),(0.6207,0.3448),(0.6207,0.3793),(0.6207,0.4138),(0.6207,0.4483),(0.6207,0.4828),(0.6207,0.5172),(0.6207,0.5517),(0.6207,0.5862),(0.6207,0.6207),(0.6207,0.6552),(0.6207,0.6897),(0.6207,0.7241),(0.6207,0.7586),(0.6207,0.7931),(0.6207,0.8276),(0.6207,0.8621),(0.6207,0.8966),(0.6207,0.9310),(0.6207,0.9655),(0.6207,1.0000),(0.6552,0.0000),(0.6552,0.0345),(0.6552,0.0690),(0.6552,0.1034),(0.6552,0.1379),(0.6552,0.1724),(0.6552,0.2069),(0.6552,0.2414),(0.6552,0.2759),(0.6552,0.3103),(0.6552,0.3448),(0.6552,0.3793),(0.6552,0.4138),(0.6552,0.4483),(0.6552,0.4828),(0.6552,0.5172),(0.6552,0.5517),(0.6552,0.5862),(0.6552,0.6207),(0.6552,0.6552),(0.6552,0.6897),(0.6552,0.7241),(0.6552,0.7586),(0.6552,0.7931),(0.6552,0.8276),(0.6552,0.8621),(0.6552,0.8966),(0.6552,0.9310),(0.6552,0.9655),(0.6552,1.0000),(0.6897,0.0000),(0.6897,0.0345),(0.6897,0.0690),(0.6897,0.1034),(0.6897,0.1379),(0.6897,0.1724),(0.6897,0.2069),(0.6897,0.2414),(0.6897,0.2759),(0.6897,0.3103),(0.6897,0.3448),(0.6897,0.3793),(0.6897,0.4138),(0.6897,0.4483),(0.6897,0.4828),(0.6897,0.5172),(0.6897,0.5517),(0.6897,0.5862),(0.6897,0.6207),(0.6897,0.6552),(0.6897,0.6897),(0.6897,0.7241),(0.6897,0.7586),(0.6897,0.7931),(0.6897,0.8276),(0.6897,0.8621),(0.6897,0.8966),(0.6897,0.9310),(0.6897,0.9655),(0.6897,1.0000),(0.7241,0.0000),(0.7241,0.0345),(0.7241,0.0690),(0.7241,0.1034),(0.7241,0.1379),(0.7241,0.1724),(0.7241,0.2069),(0.7241,0.2414),(0.7241,0.2759),(0.7241,0.3103),(0.7241,0.3448),(0.7241,0.3793),(0.7241,0.4138),(0.7241,0.4483),(0.7241,0.4828),(0.7241,0.5172),(0.7241,0.5517),(0.7241,0.5862),(0.7241,0.6207),(0.7241,0.6552),(0.7241,0.6897),(0.7241,0.7241),(0.7241,0.7586),(0.7241,0.7931),(0.7241,0.8276),(0.7241,0.8621),(0.7241,0.8966),(0.7241,0.9310),(0.7241,0.9655),(0.7241,1.0000),(0.7586,0.0000),(0.7586,0.0345),(0.7586,0.0690),(0.7586,0.1034),(0.7586,0.1379),(0.7586,0.1724),(0.7586,0.2069),(0.7586,0.2414),(0.7586,0.2759),(0.7586,0.3103),(0.7586,0.3448),(0.7586,0.3793),(0.7586,0.4138),(0.7586,0.4483),(0.7586,0.4828),(0.7586,0.5172),(0.7586,0.5517),(0.7586,0.5862),(0.7586,0.6207),(0.7586,0.6552),(0.7586,0.6897),(0.7586,0.7241),(0.7586,0.7586),(0.7586,0.7931),(0.7586,0.8276),(0.7586,0.8621),(0.7586,0.8966),(0.7586,0.9310),(0.7586,0.9655),(0.7586,1.0000),(0.7931,0.0000),(0.7931,0.0345),(0.7931,0.0690),(0.7931,0.1034),(0.7931,0.1379),(0.7931,0.1724),(0.7931,0.2069),(0.7931,0.2414),(0.7931,0.2759),(0.7931,0.3103),(0.7931,0.3448),(0.7931,0.3793),(0.7931,0.4138),(0.7931,0.4483),(0.7931,0.4828),(0.7931,0.5172),(0.7931,0.5517),(0.7931,0.5862),(0.7931,0.6207),(0.7931,0.6552),(0.7931,0.6897),(0.7931,0.7241),(0.7931,0.7586),(0.7931,0.7931),(0.7931,0.8276),(0.7931,0.8621),(0.7931,0.8966),(0.7931,0.9310),(0.7931,0.9655),(0.7931,1.0000),(0.8276,0.0000),(0.8276,0.0345),(0.8276,0.0690),(0.8276,0.1034),(0.8276,0.1379),(0.8276,0.1724),(0.8276,0.2069),(0.8276,0.2414),(0.8276,0.2759),(0.8276,0.3103),(0.8276,0.3448),(0.8276,0.3793),(0.8276,0.4138),(0.8276,0.4483),(0.8276,0.4828),(0.8276,0.5172),(0.8276,0.5517),(0.8276,0.5862),(0.8276,0.6207),(0.8276,0.6552),(0.8276,0.6897),(0.8276,0.7241),(0.8276,0.7586),(0.8276,0.7931),(0.8276,0.8276),(0.8276,0.8621),(0.8276,0.8966),(0.8276,0.9310),(0.8276,0.9655),(0.8276,1.0000),(0.8621,0.0000),(0.8621,0.0345),(0.8621,0.0690),(0.8621,0.1034),(0.8621,0.1379),(0.8621,0.1724),(0.8621,0.2069),(0.8621,0.2414),(0.8621,0.2759),(0.8621,0.3103),(0.8621,0.3448),(0.8621,0.3793),(0.8621,0.4138),(0.8621,0.4483),(0.8621,0.4828),(0.8621,0.5172),(0.8621,0.5517),(0.8621,0.5862),(0.8621,0.6207),(0.8621,0.6552),(0.8621,0.6897),(0.8621,0.7241),(0.8621,0.7586),(0.8621,0.7931),(0.8621,0.8276),(0.8621,0.8621),(0.8621,0.8966),(0.8621,0.9310),(0.8621,0.9655),(0.8621,1.0000),(0.8966,0.0000),(0.8966,0.0345),(0.8966,0.0690),(0.8966,0.1034),(0.8966,0.1379),(0.8966,0.1724),(0.8966,0.2069),(0.8966,0.2414),(0.8966,0.2759),(0.8966,0.3103),(0.8966,0.3448),(0.8966,0.3793),(0.8966,0.4138),(0.8966,0.4483),(0.8966,0.4828),(0.8966,0.5172),(0.8966,0.5517),(0.8966,0.5862),(0.8966,0.6207),(0.8966,0.6552),(0.8966,0.6897),(0.8966,0.7241),(0.8966,0.7586),(0.8966,0.7931),(0.8966,0.8276),(0.8966,0.8621),(0.8966,0.8966),(0.8966,0.9310),(0.8966,0.9655),(0.8966,1.0000),(0.9310,0.0000),(0.9310,0.0345),(0.9310,0.0690),(0.9310,0.1034),(0.9310,0.1379),(0.9310,0.1724),(0.9310,0.2069),(0.9310,0.2414),(0.9310,0.2759),(0.9310,0.3103),(0.9310,0.3448),(0.9310,0.3793),(0.9310,0.4138),(0.9310,0.4483),(0.9310,0.4828),(0.9310,0.5172),(0.9310,0.5517),(0.9310,0.5862),(0.9310,0.6207),(0.9310,0.6552),(0.9310,0.6897),(0.9310,0.7241),(0.9310,0.7586),(0.9310,0.7931),(0.9310,0.8276),(0.9310,0.8621),(0.9310,0.8966),(0.9310,0.9310),(0.9310,0.9655),(0.9310,1.0000),(0.9655,0.0000),(0.9655,0.0345),(0.9655,0.0690),(0.9655,0.1034),(0.9655,0.1379),(0.9655,0.1724),(0.9655,0.2069),(0.9655,0.2414),(0.9655,0.2759),(0.9655,0.3103),(0.9655,0.3448),(0.9655,0.3793),(0.9655,0.4138),(0.9655,0.4483),(0.9655,0.4828),(0.9655,0.5172),(0.9655,0.5517),(0.9655,0.5862),(0.9655,0.6207),(0.9655,0.6552),(0.9655,0.6897),(0.9655,0.7241),(0.9655,0.7586),(0.9655,0.7931),(0.9655,0.8276),(0.9655,0.8621),(0.9655,0.8966),(0.9655,0.9310),(0.9655,0.9655),(0.9655,1.0000),(1.0000,0.0000),(1.0000,0.0345),(1.0000,0.0690),(1.0000,0.1034),(1.0000,0.1379),(1.0000,0.1724),(1.0000,0.2069),(1.0000,0.2414),(1.0000,0.2759),(1.0000,0.3103),(1.0000,0.3448),(1.0000,0.3793),(1.0000,0.4138),(1.0000,0.4483),(1.0000,0.4828),(1.0000,0.5172),(1.0000,0.5517),(1.0000,0.5862),(1.0000,0.6207),(1.0000,0.6552),(1.0000,0.6897),(1.0000,0.7241),(1.0000,0.7586),(1.0000,0.7931),(1.0000,0.8276),(1.0000,0.8621),(1.0000,0.8966),(1.0000,0.9310),(1.0000,0.9655),(1.0000,1.0000)])),
      appearance=Appearance(
        texture=ImageTexture(url=["pumpkins.png","https://www.web3d.org/x3d/content/examples/Basic/CAD/pumpkins.png"])))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for IndexedQuadSetTexture.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python IndexedQuadSetTexture.py load and self-test diagnostics complete.")
