####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python CatiaHubGasket.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='CatiaHubGasket.x3d',name='title'),
    meta(content='Provide a Gasket part for use by CatiaHubAssemblyInline using CADAssembly and Inline nodes.',name='description'),
    meta(content='Hyokwang Lee, PartDB Co., Ltd.',name='creator'),
    meta(content='Xj3D, http://www.xj3d.org',name='translator'),
    meta(content='25 July 2012',name='created'),
    meta(content='28 November 2019',name='modified'),
    meta(content='https://www.web3d.org/x3d/specifications/ISO-IEC-19775-Amendment1-X3DAbstractSpecification/Part01/components/CADGeometry.html',name='reference'),
    meta(content='X3D CAD CADInterchange profile',name='subject'),
    meta(content='CATIA V5 R18 and PartDB Converter with Xj3D',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/CAD/CatiaHubGasket.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["File created using CATIA"],title='CatiaHubGasket.x3d'),
    NavigationInfo(type='"EXAMINE" "WALK" "FLY"'),
    Background(skyColor=[(1.0,1.0,1.0)]),
    Viewpoint(description='Main Viewpoint',fieldOfView=0.471225,orientation=(0.326678,0.502925,0.800218,2.185925),position=(0.411502,0.183945,0.216403)),
    Viewpoint(description='Iso View',fieldOfView=0.471225,orientation=(0.187053,0.451587,0.872399,2.448076),position=(0.288675,0.288675,0.288675)),
    Viewpoint(description='Front View',fieldOfView=0.471225,orientation=(0.57735,0.57735,0.57735,2.094395),position=(0.5,0.0,0.0)),
    Viewpoint(description='Back View',fieldOfView=0.471225,orientation=(0.57735,-0.57735,-0.57735,2.094395),position=(-0.5,0.0,0.0)),
    Viewpoint(description='Left View',fieldOfView=0.471225,orientation=(1.0,-1.73E-4,1.73E-4,1.570796),position=(0.0,-0.5,0.0)),
    Viewpoint(description='Right View',fieldOfView=0.471225,orientation=(-1.22E-4,-0.707107,-0.707107,3.141348),position=(0.0,0.5,0.0)),
    Viewpoint(description='Top View',fieldOfView=0.471225,orientation=(0.0,0.0,1.0,1.570796),position=(0.0,0.0,0.5)),
    Viewpoint(description='Bottom View',fieldOfView=0.471225,orientation=(0.707107,0.707107,0.0,3.141593),position=(0.0,0.0,-0.5)),
    Transform(scale=(0.001,0.001,0.001),
      children=[
      Group(
        children=[
        Group(
          children=[
          Group(
            children=[
            Group(DEF='_025EA748',
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(DEF='_material0',diffuseColor=(0.0,1.0,0.0))),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1,28,29,30,-1,29,31,30,-1,30,31,32,-1,31,33,32,-1,32,33,34,-1,33,35,34,-1],solid=False,
                  coord=Coordinate(point=[(-45.0,0,0.0),(-45.0,0,35.0),(-44.2338,8.26873,0.0),(-44.2338,8.26873,35.0),(-41.9613,16.2559,0.0),(-41.9613,16.2559,35.0),(-38.2598,23.6894,0.0),(-38.2598,23.6894,35.0),(-33.2554,30.3163,0.0),(-33.2554,30.3163,35.0),(-27.1186,35.9108,0.0),(-27.1186,35.9108,35.0),(-20.0582,40.2823,0.0),(-20.0582,40.2823,35.0),(-12.3148,43.2822,0.0),(-12.3148,43.2822,35.0),(-4.15208,44.808,0.0),(-4.15208,44.808,35.0),(4.15208,44.808,0.0),(4.15208,44.808,35.0),(12.3148,43.2822,0.0),(12.3148,43.2822,35.0),(20.0582,40.2823,0.0),(20.0582,40.2823,35.0),(27.1186,35.9108,0.0),(27.1186,35.9108,35.0),(33.2554,30.3163,0.0),(33.2554,30.3163,35.0),(38.2598,23.6894,0.0),(38.2598,23.6894,35.0),(41.9613,16.2559,0.0),(41.9613,16.2559,35.0),(44.2338,8.26873,0.0),(44.2338,8.26873,35.0),(45.0,0.0,0.0),(45.0,0.0,35.0)]),
                  normal=Normal(vector=[(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-0.982978,0.183721,0.0),(-0.982978,0.183721,0.0),(-0.932482,0.361217,0.0),(-0.932482,0.361217,0.0),(-0.850228,0.526414,0.0),(-0.850228,0.526414,0.0),(-0.739036,0.673666,0.0),(-0.739036,0.673666,0.0),(-0.602619,0.798029,0.0),(-0.602619,0.798029,0.0),(-0.445723,0.895171,0.0),(-0.445723,0.895171,0.0),(-0.273659,0.961827,0.0),(-0.273659,0.961827,0.0),(-0.0922575,0.995735,0.0),(-0.0922575,0.995735,0.0),(0.0922575,0.995735,0.0),(0.0922575,0.995735,0.0),(0.273659,0.961827,0.0),(0.273659,0.961827,0.0),(0.445723,0.895171,0.0),(0.445723,0.895171,0.0),(0.602619,0.798029,0.0),(0.602619,0.798029,0.0),(0.739036,0.673666,0.0),(0.739036,0.673666,0.0),(0.850228,0.526414,0.0),(0.850228,0.526414,0.0),(0.932482,0.361217,0.0),(0.932482,0.361217,0.0),(0.982978,0.183721,0.0),(0.982978,0.183721,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1,28,29,30,-1,29,31,30,-1,30,31,32,-1,31,33,32,-1,32,33,34,-1,33,35,34,-1],solid=False,
                  coord=Coordinate(point=[(45.0,0.0,0.0),(45.0,0.0,35.0),(44.2338,-8.26873,0.0),(44.2338,-8.26873,35.0),(41.9613,-16.2559,0.0),(41.9613,-16.2559,35.0),(38.2598,-23.6894,0.0),(38.2598,-23.6894,35.0),(33.2554,-30.3163,0.0),(33.2554,-30.3163,35.0),(27.1186,-35.9108,0.0),(27.1186,-35.9108,35.0),(20.0582,-40.2823,0.0),(20.0582,-40.2823,35.0),(12.3148,-43.2822,0.0),(12.3148,-43.2822,35.0),(4.15208,-44.808,0.0),(4.15208,-44.808,35.0),(-4.15208,-44.808,0.0),(-4.15208,-44.808,35.0),(-12.3148,-43.2822,0.0),(-12.3148,-43.2822,35.0),(-20.0582,-40.2823,0.0),(-20.0582,-40.2823,35.0),(-27.1186,-35.9108,0.0),(-27.1186,-35.9108,35.0),(-33.2554,-30.3163,0.0),(-33.2554,-30.3163,35.0),(-38.2598,-23.6894,0.0),(-38.2598,-23.6894,35.0),(-41.9613,-16.2559,0.0),(-41.9613,-16.2559,35.0),(-44.2338,-8.26873,0.0),(-44.2338,-8.26873,35.0),(-45.0,0,0.0),(-45.0,0,35.0)]),
                  normal=Normal(vector=[(1.0,0.0,0.0),(1.0,0.0,0.0),(0.982978,-0.183721,0.0),(0.982978,-0.183721,0.0),(0.932482,-0.361217,0.0),(0.932482,-0.361217,0.0),(0.850228,-0.526414,0.0),(0.850228,-0.526414,0.0),(0.739036,-0.673666,0.0),(0.739036,-0.673666,0.0),(0.602619,-0.798029,0.0),(0.602619,-0.798029,0.0),(0.445723,-0.895171,0.0),(0.445723,-0.895171,0.0),(0.273659,-0.961827,0.0),(0.273659,-0.961827,0.0),(0.0922575,-0.995735,0.0),(0.0922575,-0.995735,0.0),(-0.0922575,-0.995735,0.0),(-0.0922575,-0.995735,0.0),(-0.273659,-0.961827,0.0),(-0.273659,-0.961827,0.0),(-0.445723,-0.895171,0.0),(-0.445723,-0.895171,0.0),(-0.602619,-0.798029,0.0),(-0.602619,-0.798029,0.0),(-0.739036,-0.673666,0.0),(-0.739036,-0.673666,0.0),(-0.850228,-0.526414,0.0),(-0.850228,-0.526414,0.0),(-0.932482,-0.361217,0.0),(-0.932482,-0.361217,0.0),(-0.982978,-0.183721,0.0),(-0.982978,-0.183721,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1],solid=False,
                  coord=Coordinate(point=[(30.0,0.0,35.0),(30.0,0.0,0.0),(29.2478,-6.67563,35.0),(29.2478,-6.67563,0.0),(27.0291,-13.0165,35.0),(27.0291,-13.0165,0.0),(23.4549,-18.7047,35.0),(23.4549,-18.7047,0.0),(18.7047,-23.4549,35.0),(18.7047,-23.4549,0.0),(13.0165,-27.0291,35.0),(13.0165,-27.0291,0.0),(6.67563,-29.2478,35.0),(6.67563,-29.2478,0.0),(0,-30.0,35.0),(0,-30.0,0.0),(-6.67563,-29.2478,35.0),(-6.67563,-29.2478,0.0),(-13.0165,-27.0291,35.0),(-13.0165,-27.0291,0.0),(-18.7047,-23.4549,35.0),(-18.7047,-23.4549,0.0),(-23.4549,-18.7047,35.0),(-23.4549,-18.7047,0.0),(-27.0291,-13.0165,35.0),(-27.0291,-13.0165,0.0),(-29.2478,-6.67563,35.0),(-29.2478,-6.67563,0.0),(-30.0,0,35.0),(-30.0,0,0.0)]),
                  normal=Normal(vector=[(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-0.97493,0.22251,0.0),(-0.97493,0.22251,0.0),(-0.90097,0.433882,0.0),(-0.90097,0.433882,0.0),(-0.781853,0.623463,0.0),(-0.781853,0.623463,0.0),(-0.623463,0.781853,0.0),(-0.623463,0.781853,0.0),(-0.433882,0.90097,0.0),(-0.433882,0.90097,0.0),(-0.22251,0.97493,0.0),(-0.22251,0.97493,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.22251,0.97493,0.0),(0.22251,0.97493,0.0),(0.433882,0.90097,0.0),(0.433882,0.90097,0.0),(0.623463,0.781853,0.0),(0.623463,0.781853,0.0),(0.781853,0.623463,0.0),(0.781853,0.623463,0.0),(0.90097,0.433882,0.0),(0.90097,0.433882,0.0),(0.97493,0.22251,0.0),(0.97493,0.22251,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1],solid=False,
                  coord=Coordinate(point=[(-30.0,0,35.0),(-30.0,0,0.0),(-29.2478,6.67563,35.0),(-29.2478,6.67563,0.0),(-27.0291,13.0165,35.0),(-27.0291,13.0165,0.0),(-23.4549,18.7047,35.0),(-23.4549,18.7047,0.0),(-18.7047,23.4549,35.0),(-18.7047,23.4549,0.0),(-13.0165,27.0291,35.0),(-13.0165,27.0291,0.0),(-6.67563,29.2478,35.0),(-6.67563,29.2478,0.0),(0,30.0,35.0),(0,30.0,0.0),(6.67563,29.2478,35.0),(6.67563,29.2478,0.0),(13.0165,27.0291,35.0),(13.0165,27.0291,0.0),(18.7047,23.4549,35.0),(18.7047,23.4549,0.0),(23.4549,18.7047,35.0),(23.4549,18.7047,0.0),(27.0291,13.0165,35.0),(27.0291,13.0165,0.0),(29.2478,6.67563,35.0),(29.2478,6.67563,0.0),(30.0,0.0,35.0),(30.0,0.0,0.0)]),
                  normal=Normal(vector=[(1.0,0.0,0.0),(1.0,0.0,0.0),(0.97493,-0.22251,0.0),(0.97493,-0.22251,0.0),(0.90097,-0.433882,0.0),(0.90097,-0.433882,0.0),(0.781853,-0.623463,0.0),(0.781853,-0.623463,0.0),(0.623463,-0.781853,0.0),(0.623463,-0.781853,0.0),(0.433882,-0.90097,0.0),(0.433882,-0.90097,0.0),(0.22251,-0.97493,0.0),(0.22251,-0.97493,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(-0.22251,-0.97493,0.0),(-0.22251,-0.97493,0.0),(-0.433882,-0.90097,0.0),(-0.433882,-0.90097,0.0),(-0.623463,-0.781853,0.0),(-0.623463,-0.781853,0.0),(-0.781853,-0.623463,0.0),(-0.781853,-0.623463,0.0),(-0.90097,-0.433882,0.0),(-0.90097,-0.433882,0.0),(-0.97493,-0.22251,0.0),(-0.97493,-0.22251,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,2,4,5,-1,4,6,5,-1,5,6,7,-1,6,8,7,-1,7,8,9,-1,7,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,17,18,16,-1,18,14,16,-1,19,20,21,-1,20,22,21,-1,21,22,23,-1,23,22,24,-1,22,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,28,27,29,-1,27,30,29,-1,29,30,31,-1,30,32,31,-1,31,32,33,-1,32,34,33,-1,33,34,35,-1,35,34,36,-1,34,37,36,-1,36,37,38,-1,37,39,38,-1,38,39,40,-1,41,18,17,-1,41,17,42,-1,41,42,43,-1,41,43,44,-1,41,44,45,-1,41,45,46,-1,41,46,47,-1,41,47,48,-1,41,48,49,-1,44,40,39,-1,44,39,50,-1,44,50,51,-1,44,51,52,-1,44,52,45,-1,53,1,0,-1,53,0,54,-1,53,54,55,-1,53,55,56,-1,53,56,57,-1,53,57,58,-1,53,58,59,-1,53,59,60,-1,53,60,61,-1,53,61,20,-1,53,20,19,-1],solid=False,
                  coord=Coordinate(point=[(-33.2554,30.3163,0.0),(-6.67563,29.2478,0.0),(-38.2598,23.6894,0.0),(-13.0165,27.0291,0.0),(-18.7047,23.4549,0.0),(-41.9613,16.2559,0.0),(-23.4549,18.7047,0.0),(-44.2338,8.26873,0.0),(-27.0291,13.0165,0.0),(-29.2478,6.67563,0.0),(-45.0,0,0.0),(-30.0,0,0.0),(-44.2338,-8.26873,0.0),(-29.2478,-6.67563,0.0),(-41.9613,-16.2559,0.0),(-27.0291,-13.0165,0.0),(-23.4549,-18.7047,0.0),(-18.7047,-23.4549,0.0),(-38.2598,-23.6894,0.0),(6.67563,29.2478,0.0),(33.2554,30.3163,0.0),(13.0165,27.0291,0.0),(38.2598,23.6894,0.0),(18.7047,23.4549,0.0),(23.4549,18.7047,0.0),(41.9613,16.2559,0.0),(27.0291,13.0165,0.0),(44.2338,8.26873,0.0),(29.2478,6.67563,0.0),(30.0,0.0,0.0),(45.0,0.0,0.0),(29.2478,-6.67563,0.0),(44.2338,-8.26873,0.0),(27.0291,-13.0165,0.0),(41.9613,-16.2559,0.0),(23.4549,-18.7047,0.0),(18.7047,-23.4549,0.0),(38.2598,-23.6894,0.0),(13.0165,-27.0291,0.0),(33.2554,-30.3163,0.0),(6.67563,-29.2478,0.0),(-33.2554,-30.3163,0.0),(-13.0165,-27.0291,0.0),(-6.67563,-29.2478,0.0),(0,-30.0,0.0),(4.15208,-44.808,0.0),(-4.15208,-44.808,0.0),(-12.3148,-43.2822,0.0),(-20.0582,-40.2823,0.0),(-27.1186,-35.9108,0.0),(27.1186,-35.9108,0.0),(20.0582,-40.2823,0.0),(12.3148,-43.2822,0.0),(0,30.0,0.0),(-27.1186,35.9108,0.0),(-20.0582,40.2823,0.0),(-12.3148,43.2822,0.0),(-4.15208,44.808,0.0),(4.15208,44.808,0.0),(12.3148,43.2822,0.0),(20.0582,40.2823,0.0),(27.1186,35.9108,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,4,3,5,-1,3,6,5,-1,5,6,7,-1,6,8,7,-1,7,8,9,-1,9,8,10,-1,8,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,17,18,15,-1,18,16,15,-1,19,20,21,-1,20,22,21,-1,21,22,23,-1,21,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,26,28,29,-1,28,30,29,-1,29,30,31,-1,30,32,31,-1,31,32,33,-1,32,34,33,-1,33,34,35,-1,33,35,36,-1,35,37,36,-1,36,37,38,-1,37,39,38,-1,38,39,40,-1,41,42,43,-1,41,43,44,-1,41,44,45,-1,41,45,46,-1,41,46,47,-1,41,47,48,-1,41,48,49,-1,41,49,18,-1,41,18,17,-1,47,46,50,-1,47,50,51,-1,47,51,52,-1,47,52,38,-1,47,38,40,-1,53,20,19,-1,53,19,54,-1,53,54,55,-1,53,55,56,-1,53,56,57,-1,53,57,58,-1,53,58,59,-1,53,59,60,-1,53,60,61,-1,53,61,1,-1,53,1,0,-1],solid=False,
                  coord=Coordinate(point=[(-6.67563,29.2478,35.0),(-33.2554,30.3163,35.0),(-13.0165,27.0291,35.0),(-38.2598,23.6894,35.0),(-18.7047,23.4549,35.0),(-23.4549,18.7047,35.0),(-41.9613,16.2559,35.0),(-27.0291,13.0165,35.0),(-44.2338,8.26873,35.0),(-29.2478,6.67563,35.0),(-30.0,0,35.0),(-45.0,0,35.0),(-29.2478,-6.67563,35.0),(-44.2338,-8.26873,35.0),(-27.0291,-13.0165,35.0),(-41.9613,-16.2559,35.0),(-23.4549,-18.7047,35.0),(-38.2598,-23.6894,35.0),(-18.7047,-23.4549,35.0),(33.2554,30.3163,35.0),(6.67563,29.2478,35.0),(38.2598,23.6894,35.0),(13.0165,27.0291,35.0),(18.7047,23.4549,35.0),(41.9613,16.2559,35.0),(23.4549,18.7047,35.0),(44.2338,8.26873,35.0),(27.0291,13.0165,35.0),(29.2478,6.67563,35.0),(45.0,0.0,35.0),(30.0,0.0,35.0),(44.2338,-8.26873,35.0),(29.2478,-6.67563,35.0),(41.9613,-16.2559,35.0),(27.0291,-13.0165,35.0),(23.4549,-18.7047,35.0),(38.2598,-23.6894,35.0),(18.7047,-23.4549,35.0),(33.2554,-30.3163,35.0),(13.0165,-27.0291,35.0),(6.67563,-29.2478,35.0),(-33.2554,-30.3163,35.0),(-27.1186,-35.9108,35.0),(-20.0582,-40.2823,35.0),(-12.3148,-43.2822,35.0),(-4.15208,-44.808,35.0),(4.15208,-44.808,35.0),(0,-30.0,35.0),(-6.67563,-29.2478,35.0),(-13.0165,-27.0291,35.0),(12.3148,-43.2822,35.0),(20.0582,-40.2823,35.0),(27.1186,-35.9108,35.0),(0,30.0,35.0),(27.1186,35.9108,35.0),(20.0582,40.2823,35.0),(12.3148,43.2822,35.0),(4.15208,44.808,35.0),(-4.15208,44.808,35.0),(-12.3148,43.2822,35.0),(-20.0582,40.2823,35.0),(-27.1186,35.9108,35.0)])))])])])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for CatiaHubGasket.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python CatiaHubGasket.py load and self-test diagnostics complete.")
