####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python CatiaHubCap.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.0',
  head=head(
    children=[
    meta(content='CatiaHubCap.x3d',name='title'),
    meta(content='Provide a Cap part for use by CatiaHubAssemblyInline using CADAssembly and Inline nodes.',name='description'),
    meta(content='Hyokwang Lee, PartDB Co., Ltd.',name='creator'),
    meta(content='Xj3D, http://www.xj3d.org',name='translator'),
    meta(content='25 July 2012',name='created'),
    meta(content='28 November 2019',name='modified'),
    meta(content='https://www.web3d.org/x3d/specifications/ISO-IEC-19775-Amendment1-X3DAbstractSpecification/Part01/components/CADGeometry.html',name='reference'),
    meta(content='X3D CAD CADInterchange profile',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/CAD/CatiaHubCap.x3d',name='identifier'),
    meta(content='CATIA V5 R18 and PartDB Converter with Xj3D',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(info=["File created using CATIA"],title='CatiaHubCap.x3d'),
    NavigationInfo(type='"EXAMINE" "WALK" "FLY"'),
    Background(skyColor=[(1.0,1.0,1.0)]),
    Viewpoint(description='Main Viewpoint',fieldOfView=0.471225,orientation=(0.326678,0.502925,0.800218,2.185925),position=(0.411502,0.183945,0.216403)),
    Viewpoint(description='Iso View',fieldOfView=0.471225,orientation=(0.187053,0.451587,0.872399,2.448076),position=(0.288675,0.288675,0.288675)),
    Viewpoint(description='Front View',fieldOfView=0.471225,orientation=(0.57735,0.57735,0.57735,2.094395),position=(0.5,0.0,0.0)),
    Viewpoint(description='Back View',fieldOfView=0.471225,orientation=(0.57735,-0.57735,-0.57735,2.094395),position=(-0.5,0.0,0.0)),
    Viewpoint(description='Left View',fieldOfView=0.471225,orientation=(1.0,-1.73E-4,1.73E-4,1.570796),position=(0.0,-0.5,0.0)),
    Viewpoint(description='Right View',fieldOfView=0.471225,orientation=(-1.22E-4,-0.707107,-0.707107,3.141348),position=(0.0,0.5,0.0)),
    Viewpoint(description='Top View',fieldOfView=0.471225,orientation=(0.0,0.0,1.0,1.570796),position=(0.0,0.0,0.5)),
    Viewpoint(description='Bottom View',fieldOfView=0.471225,orientation=(0.707107,0.707107,0.0,3.141593),position=(0.0,0.0,-0.5)),
    Transform(scale=(0.001,0.001,0.001),
      children=[
      Group(
        children=[
        Group(
          children=[
          Group(
            children=[
            Group(DEF='_03E3C7E8',
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(DEF='_material0',diffuseColor=(0.94902,0.635294,0.341176))),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1,28,29,30,-1,29,31,30,-1,30,31,32,-1,31,33,32,-1,32,33,34,-1,33,35,34,-1,34,35,36,-1,35,37,36,-1,36,37,38,-1,37,39,38,-1,38,39,40,-1,39,41,40,-1,40,41,42,-1,41,43,42,-1,42,43,44,-1,43,45,44,-1],solid=False,
                  coord=Coordinate(point=[(-75.0,0,0.0),(-75.0,0,20.0),(-74.2366,10.6736,0.0),(-74.2366,10.6736,20.0),(-71.962,21.1299,0.0),(-71.962,21.1299,20.0),(-68.2224,31.1561,0.0),(-68.2224,31.1561,20.0),(-63.094,40.5481,0.0),(-63.094,40.5481,20.0),(-56.6812,49.1146,0.0),(-56.6812,49.1146,20.0),(-49.1146,56.6812,0.0),(-49.1146,56.6812,20.0),(-40.5481,63.094,0.0),(-40.5481,63.094,20.0),(-31.1561,68.2224,0.0),(-31.1561,68.2224,20.0),(-21.1299,71.962,0.0),(-21.1299,71.962,20.0),(-10.6736,74.2366,0.0),(-10.6736,74.2366,20.0),(0,75.0,0.0),(0,75.0,20.0),(10.6736,74.2366,0.0),(10.6736,74.2366,20.0),(21.1299,71.962,0.0),(21.1299,71.962,20.0),(31.1561,68.2224,0.0),(31.1561,68.2224,20.0),(40.5481,63.094,0.0),(40.5481,63.094,20.0),(49.1146,56.6812,0.0),(49.1146,56.6812,20.0),(56.6812,49.1146,0.0),(56.6812,49.1146,20.0),(63.094,40.5481,0.0),(63.094,40.5481,20.0),(68.2224,31.1561,0.0),(68.2224,31.1561,20.0),(71.962,21.1299,0.0),(71.962,21.1299,20.0),(74.2366,10.6736,0.0),(74.2366,10.6736,20.0),(75.0,0.0,0.0),(75.0,0.0,20.0)]),
                  normal=Normal(vector=[(-1.0,0.0,0.0),(-1.0,0.0,0.0),(-0.989822,0.142308,0.0),(-0.989822,0.142308,0.0),(-0.959498,0.281716,0.0),(-0.959498,0.281716,0.0),(-0.909645,0.415387,0.0),(-0.909645,0.415387,0.0),(-0.841257,0.540635,0.0),(-0.841257,0.540635,0.0),(-0.755771,0.654836,0.0),(-0.755771,0.654836,0.0),(-0.654836,0.755771,0.0),(-0.654836,0.755771,0.0),(-0.540635,0.841257,0.0),(-0.540635,0.841257,0.0),(-0.415387,0.909645,0.0),(-0.415387,0.909645,0.0),(-0.281716,0.959498,0.0),(-0.281716,0.959498,0.0),(-0.142308,0.989822,0.0),(-0.142308,0.989822,0.0),(0.0,1.0,0.0),(0.0,1.0,0.0),(0.142308,0.989822,0.0),(0.142308,0.989822,0.0),(0.281716,0.959498,0.0),(0.281716,0.959498,0.0),(0.415387,0.909645,0.0),(0.415387,0.909645,0.0),(0.540635,0.841257,0.0),(0.540635,0.841257,0.0),(0.654836,0.755771,0.0),(0.654836,0.755771,0.0),(0.755771,0.654836,0.0),(0.755771,0.654836,0.0),(0.841257,0.540635,0.0),(0.841257,0.540635,0.0),(0.909645,0.415387,0.0),(0.909645,0.415387,0.0),(0.959498,0.281716,0.0),(0.959498,0.281716,0.0),(0.989822,0.142308,0.0),(0.989822,0.142308,0.0),(1.0,0.0,0.0),(1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,-1,1,3,2,-1,2,3,4,-1,3,5,4,-1,4,5,6,-1,5,7,6,-1,6,7,8,-1,7,9,8,-1,8,9,10,-1,9,11,10,-1,10,11,12,-1,11,13,12,-1,12,13,14,-1,13,15,14,-1,14,15,16,-1,15,17,16,-1,16,17,18,-1,17,19,18,-1,18,19,20,-1,19,21,20,-1,20,21,22,-1,21,23,22,-1,22,23,24,-1,23,25,24,-1,24,25,26,-1,25,27,26,-1,26,27,28,-1,27,29,28,-1,28,29,30,-1,29,31,30,-1,30,31,32,-1,31,33,32,-1,32,33,34,-1,33,35,34,-1,34,35,36,-1,35,37,36,-1,36,37,38,-1,37,39,38,-1,38,39,40,-1,39,41,40,-1,40,41,42,-1,41,43,42,-1,42,43,44,-1,43,45,44,-1],solid=False,
                  coord=Coordinate(point=[(75.0,0.0,0.0),(75.0,0.0,20.0),(74.2366,-10.6736,0.0),(74.2366,-10.6736,20.0),(71.962,-21.1299,0.0),(71.962,-21.1299,20.0),(68.2224,-31.1561,0.0),(68.2224,-31.1561,20.0),(63.094,-40.5481,0.0),(63.094,-40.5481,20.0),(56.6812,-49.1146,0.0),(56.6812,-49.1146,20.0),(49.1146,-56.6812,0.0),(49.1146,-56.6812,20.0),(40.5481,-63.094,0.0),(40.5481,-63.094,20.0),(31.1561,-68.2224,0.0),(31.1561,-68.2224,20.0),(21.1299,-71.962,0.0),(21.1299,-71.962,20.0),(10.6736,-74.2366,0.0),(10.6736,-74.2366,20.0),(0,-75.0,0.0),(0,-75.0,20.0),(-10.6736,-74.2366,0.0),(-10.6736,-74.2366,20.0),(-21.1299,-71.962,0.0),(-21.1299,-71.962,20.0),(-31.1561,-68.2224,0.0),(-31.1561,-68.2224,20.0),(-40.5481,-63.094,0.0),(-40.5481,-63.094,20.0),(-49.1146,-56.6812,0.0),(-49.1146,-56.6812,20.0),(-56.6812,-49.1146,0.0),(-56.6812,-49.1146,20.0),(-63.094,-40.5481,0.0),(-63.094,-40.5481,20.0),(-68.2224,-31.1561,0.0),(-68.2224,-31.1561,20.0),(-71.962,-21.1299,0.0),(-71.962,-21.1299,20.0),(-74.2366,-10.6736,0.0),(-74.2366,-10.6736,20.0),(-75.0,0,0.0),(-75.0,0,20.0)]),
                  normal=Normal(vector=[(1.0,0.0,0.0),(1.0,0.0,0.0),(0.989822,-0.142308,0.0),(0.989822,-0.142308,0.0),(0.959498,-0.281716,0.0),(0.959498,-0.281716,0.0),(0.909645,-0.415387,0.0),(0.909645,-0.415387,0.0),(0.841257,-0.540635,0.0),(0.841257,-0.540635,0.0),(0.755771,-0.654836,0.0),(0.755771,-0.654836,0.0),(0.654836,-0.755771,0.0),(0.654836,-0.755771,0.0),(0.540635,-0.841257,0.0),(0.540635,-0.841257,0.0),(0.415387,-0.909645,0.0),(0.415387,-0.909645,0.0),(0.281716,-0.959498,0.0),(0.281716,-0.959498,0.0),(0.142308,-0.989822,0.0),(0.142308,-0.989822,0.0),(0.0,-1.0,0.0),(0.0,-1.0,0.0),(-0.142308,-0.989822,0.0),(-0.142308,-0.989822,0.0),(-0.281716,-0.959498,0.0),(-0.281716,-0.959498,0.0),(-0.415387,-0.909645,0.0),(-0.415387,-0.909645,0.0),(-0.540635,-0.841257,0.0),(-0.540635,-0.841257,0.0),(-0.654836,-0.755771,0.0),(-0.654836,-0.755771,0.0),(-0.755771,-0.654836,0.0),(-0.755771,-0.654836,0.0),(-0.841257,-0.540635,0.0),(-0.841257,-0.540635,0.0),(-0.909645,-0.415387,0.0),(-0.909645,-0.415387,0.0),(-0.959498,-0.281716,0.0),(-0.959498,-0.281716,0.0),(-0.989822,-0.142308,0.0),(-0.989822,-0.142308,0.0),(-1.0,0.0,0.0),(-1.0,0.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[2,1,3,-1,1,4,3,-1,3,4,5,-1,4,6,5,-1,5,6,7,-1,6,8,7,-1,7,8,9,-1,8,10,9,-1,9,10,11,-1,10,12,11,-1,11,12,13,-1,12,14,13,-1,13,14,15,-1,14,16,15,-1,15,16,17,-1,16,18,17,-1,17,18,19,-1,18,20,19,-1,19,20,21,-1,20,22,21,-1,21,22,23,-1,22,24,23,-1,23,24,25,-1,24,26,25,-1,25,26,27,-1,26,28,27,-1,27,28,29,-1,28,30,29,-1,29,30,31,-1,30,32,31,-1,31,32,33,-1,32,34,33,-1,33,34,35,-1,34,36,35,-1,35,36,37,-1,36,38,37,-1,37,38,39,-1,38,40,39,-1,39,40,41,-1,40,42,41,-1,41,42,43,-1,0,1,2,-1],solid=False,
                  coord=Coordinate(point=[(0,75.0,0.0),(10.6736,74.2366,0.0),(-10.6736,74.2366,0.0),(-21.1299,71.962,0.0),(21.1299,71.962,0.0),(-31.1561,68.2224,0.0),(31.1561,68.2224,0.0),(-40.5481,63.094,0.0),(40.5481,63.094,0.0),(-49.1146,56.6812,0.0),(49.1146,56.6812,0.0),(-56.6812,49.1146,0.0),(56.6812,49.1146,0.0),(-63.094,40.5481,0.0),(63.094,40.5481,0.0),(-68.2224,31.1561,0.0),(68.2224,31.1561,0.0),(-71.962,21.1299,0.0),(71.962,21.1299,0.0),(-74.2366,10.6736,0.0),(74.2366,10.6736,0.0),(-75.0,0,0.0),(75.0,0.0,0.0),(-74.2366,-10.6736,0.0),(74.2366,-10.6736,0.0),(-71.962,-21.1299,0.0),(71.962,-21.1299,0.0),(-68.2224,-31.1561,0.0),(68.2224,-31.1561,0.0),(-63.094,-40.5481,0.0),(63.094,-40.5481,0.0),(-56.6812,-49.1146,0.0),(56.6812,-49.1146,0.0),(-49.1146,-56.6812,0.0),(49.1146,-56.6812,0.0),(-40.5481,-63.094,0.0),(40.5481,-63.094,0.0),(-31.1561,-68.2224,0.0),(31.1561,-68.2224,0.0),(-21.1299,-71.962,0.0),(21.1299,-71.962,0.0),(-10.6736,-74.2366,0.0),(10.6736,-74.2366,0.0),(0,-75.0,0.0)]))),
              Shape(
                appearance=Appearance(
                  material=Material(USE='_material0')),
                geometry=IndexedFaceSet(coordIndex=[1,0,3,-1,0,4,3,-1,3,4,5,-1,4,6,5,-1,5,6,7,-1,6,8,7,-1,7,8,9,-1,8,10,9,-1,9,10,11,-1,10,12,11,-1,11,12,13,-1,12,14,13,-1,13,14,15,-1,14,16,15,-1,15,16,17,-1,16,18,17,-1,17,18,19,-1,18,20,19,-1,19,20,21,-1,20,22,21,-1,21,22,23,-1,22,24,23,-1,23,24,25,-1,24,26,25,-1,25,26,27,-1,26,28,27,-1,27,28,29,-1,28,30,29,-1,29,30,31,-1,30,32,31,-1,31,32,33,-1,32,34,33,-1,33,34,35,-1,34,36,35,-1,35,36,37,-1,36,38,37,-1,37,38,39,-1,38,40,39,-1,39,40,41,-1,40,42,41,-1,41,42,43,-1,0,1,2,-1],solid=False,
                  coord=Coordinate(point=[(-10.6736,74.2366,20.0),(10.6736,74.2366,20.0),(0,75.0,20.0),(21.1299,71.962,20.0),(-21.1299,71.962,20.0),(31.1561,68.2224,20.0),(-31.1561,68.2224,20.0),(40.5481,63.094,20.0),(-40.5481,63.094,20.0),(49.1146,56.6812,20.0),(-49.1146,56.6812,20.0),(56.6812,49.1146,20.0),(-56.6812,49.1146,20.0),(63.094,40.5481,20.0),(-63.094,40.5481,20.0),(68.2224,31.1561,20.0),(-68.2224,31.1561,20.0),(71.962,21.1299,20.0),(-71.962,21.1299,20.0),(74.2366,10.6736,20.0),(-74.2366,10.6736,20.0),(75.0,0.0,20.0),(-75.0,0,20.0),(74.2366,-10.6736,20.0),(-74.2366,-10.6736,20.0),(71.962,-21.1299,20.0),(-71.962,-21.1299,20.0),(68.2224,-31.1561,20.0),(-68.2224,-31.1561,20.0),(63.094,-40.5481,20.0),(-63.094,-40.5481,20.0),(56.6812,-49.1146,20.0),(-56.6812,-49.1146,20.0),(49.1146,-56.6812,20.0),(-49.1146,-56.6812,20.0),(40.5481,-63.094,20.0),(-40.5481,-63.094,20.0),(31.1561,-68.2224,20.0),(-31.1561,-68.2224,20.0),(21.1299,-71.962,20.0),(-21.1299,-71.962,20.0),(10.6736,-74.2366,20.0),(-10.6736,-74.2366,20.0),(0,-75.0,20.0)])))])])])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for CatiaHubCap.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python CatiaHubCap.py load and self-test diagnostics complete.")
