package Basic.CAD;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.CADGeometry.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Teapot model demonstrating proper hierarchy of CAD nodes: CADLayer, CADAssembly, CADPart, and then CADFace. </p>
 <p> Related links: Catalog page <a href="../../../CAD/CadTeapotIndex.html" target="_blank">CadTeapot</a>,  source <a href="../../../CAD/CadTeapot.java">CadTeapot.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../CAD/CadTeapot.x3d">CadTeapot.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Teapot model demonstrating proper hierarchy of CAD nodes: CADLayer, CADAssembly, CADPart, and then CADFace. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Alan Hudson, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Xj3D, <a href="http://www.xj3d.org" target="_blank">http://www.xj3d.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 December 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-19775-Amendment1-X3DAbstractSpecification/Part01/components/CADGeometry.html" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-19775-Amendment1-X3DAbstractSpecification/Part01/components/CADGeometry.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../CAD/TeapotOriginal.x3dv">TeapotOriginal.x3dv</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../CAD/CadTeapot.png">CadTeapot.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D CAD CADInterchange profile </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/CAD/CadTeapot.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/CAD/CadTeapot.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../CAD/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Alan Hudson, Don Brutzman
 */

public class CadTeapot
{
	/** Default constructor to create this object. */
	public CadTeapot ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_CADINTERCHANGE).setVersion(X3D.VERSION_3_1)
  .setHead(new head()
    .addComments(" superfluous for CADInterchange profile: <component level='2' name='CADGeometry'/> ")
    .addComponent(new component().setName("EnvironmentalEffects").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("CadTeapot.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Teapot model demonstrating proper hierarchy of CAD nodes: CADLayer, CADAssembly, CADPart, and then CADFace."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Alan Hudson, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Xj3D, http://www.xj3d.org"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 December 2005"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-19775-Amendment1-X3DAbstractSpecification/Part01/components/CADGeometry.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("TeapotOriginal.x3dv"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("CadTeapot.png"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D CAD CADInterchange profile"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/CAD/CadTeapot.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("CadTeapot.x3d"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {0.9607843,1.0,0.9607843})))
    .addChild(new Viewpoint().setDescription("Hello CAD teapot").setPosition(0.0,0.0,35.0))
    .addChild(new CADLayer("TopLayer").setName("Single topmost CADLayer for this model")
      .addChild(new CADAssembly().setName("Assembled Teapot")
        .addChild(new CADPart().setName("Body")
          .addChild(new CADFace().setName("Teapot body IFS mesh")
            .setShape(new Shape()
              .setAppearance(new Appearance("APP01")
                .setMaterial(new Material().setDiffuseColor(0.3451,0.5608,0.8824)))
              .setGeometry(new IndexedFaceSet().setCreaseAngle(1.0).setCoordIndex(getIndexedFaceSet_8_21_coordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_21_point()))))))
        .addChild(new CADPart().setName("Spout")
          .addChild(new CADFace().setName("Teapot spout IFS mesh")
            .setShape(new Shape()
              .setAppearance(new Appearance().setUSE("APP01"))
              .setGeometry(new IndexedFaceSet().setCreaseAngle(1).setSolid(false).setCoordIndex(getIndexedFaceSet_8_27_coordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_27_point()))))))
        .addChild(new CADPart().setName("Handle")
          .addChild(new CADFace().setName("Teapot handle IFS mesh")
            .setShape(new Shape()
              .setAppearance(new Appearance().setUSE("APP01"))
              .setGeometry(new IndexedFaceSet().setCreaseAngle(1.0).setCoordIndex(getIndexedFaceSet_8_33_coordIndex())
                .setCoord(new Coordinate().setPoint(getCoordinate_9_33_point()))))))
        .addChild(new CADPart().setName("Lid")
          .addChild(new CADFace().setName("Teapot lid IFS mesh")
            .setShape(new Shape()
              .setAppearance(new Appearance().setUSE("APP01"))
              .setGeometry(new IndexedFaceSet().setCreaseAngle(1.0).setCoordIndex(getIndexedFaceSet_8_39_coordIndex())
                .setCoord(new Coordinate("Teapot01-COORD").setPoint(getTeapot01_COORD_9_39_point()))))))
        .addComments(" TODO: want to add <Inline/> <CADPart DEF='InlineAnotherPart' name='BringInAnotherModel'> <CADFace name='HoldInline'> </CADFace> </CADPart> "))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_8_21_coordIndex_1()
		{
			int[] value = {0,5,6,-1,6,1,0,-1,1,6,7,-1,7,2,1,-1,2,7,8,-1,8,3,2,-1,3,8,9,-1,9,4,3,-1,5,10,11,-1,11,6,5,-1,6,11,12,-1,12,7,6,-1,7,12,13,-1,13,8,7,-1,8,13,14,-1,14,9,8,-1,10,15,16,-1,16,11,10,-1,11,16,17,-1,17,12,11,-1,12,17,18,-1,18,13,12,-1,13,18,19,-1,19,14,13,-1,15,20,21,-1,21,16,15,-1,16,21,22,-1,22,17,16,-1,17,22,23,-1,23,18,17,-1,18,23,24,-1,24,19,18,-1,20,25,26,-1,26,21,20,-1,21,26,27,-1,27,22,21,-1,22,27,28,-1,28,23,22,-1,23,28,29,-1,29,24,23,-1,25,30,31,-1,31,26,25,-1,26,31,32,-1,32,27,26,-1,27,32,33,-1,33,28,27,-1,28,33,34,-1,34,29,28,-1,30,35,36,-1,36,31,30,-1,31,36,37,-1,37,32,31,-1,32,37,38,-1,38,33,32,-1,33,38,39,-1,39,34,33,-1,35,40,41,-1,41,36,35,-1,36,41,42,-1,42,37,36,-1,37,42,43,-1,43,38,37,-1,38,43,44,-1,44,39,38,-1,40,45,46,-1,46,41,40,-1,41,46,47,-1,47,42,41,-1,42,47,48,-1,48,43,42,-1,43,48,49,-1,49,44,43,-1,45,50,51,-1,51,46,45,-1,46,51,52,-1,52,47,46,-1,47,52,53,-1,53,48,47,-1,48,53,54,-1,54,49,48,-1,50,55,56,-1,56,51,50,-1,51,56,57,-1,57,52,51,-1,52,57,58,-1,58,53,52,-1,53,58,59,-1,59,54,53,-1,55,60,61,-1,61,56,55,-1,56,61,62,-1,62,57,56,-1,57,62,63,-1,63,58,57,-1,58,63,64,-1,64,59,58,-1,60,65,66,-1,66,61,60,-1,61,66,67,-1,67,62,61,-1,62,67,68,-1,68,63,62,-1,63,68,69,-1,69,64,63,-1,65,70,71,-1,71,66,65,-1,66,71,72,-1,72,67,66,-1,67,72,73,-1,73,68,67,-1,68,73,74,-1,74,69,68,-1,70,75,76,-1,76,71,70,-1,71,76,77,-1,77,72,71,-1,72,77,78,-1,78,73,72,-1,73,78,79,-1,79,74,73,-1,75,0,1,-1,1,76,75,-1,76,1,2,-1,2,77,76,-1,77,2,3,-1,3,78,77,-1,78,3,4,-1,4,79,78,-1,4,9,84,-1,84,80,4,-1,80,84,85,-1,85,81,80,-1,81,85,86,-1,86,82,81,-1,82,86,87,-1,87,83,82,-1,9,14,88,-1,88,84,9,-1,84,88,89,-1,89,85,84,-1,85,89,90,-1,90,86,85,-1,86,90,91,-1,91,87,86,-1,14,19,92,-1,92,88,14,-1,88,92,93,-1,93,89,88,-1,89,93,94,-1,94,90,89,-1,90,94,95,-1,95,91,90,-1,19,24,96,-1,96,92,19,-1,92,96,97,-1,97,93,92,-1,93,97,98,-1,98,94,93,-1,94,98,99,-1,99,95,94,-1,24,29,100,-1,100,96,24,-1,96,100,101,-1,101,97,96,-1,97,101,102,-1,102,98,97,-1,98,102,103,-1,103,99,98,-1,29,34,104,-1,104,100,29,-1,100,104,105,-1,105,101,100,-1,101,105,106,-1,106,102,101,-1,102,106,107,-1,107,103,102,-1,34,39,108,-1,108,104,34,-1,104,108,109,-1,109,105,104,-1,105,109,110,-1,110,106,105,-1,106,110,111,-1,111,107,106,-1,39,44,112,-1,112,108,39,-1,108,112,113,-1,113,109,108,-1,109,113,114,-1,114,110,109,-1,110,114,115,-1,115,111,110,-1,44,49,116,-1,116,112,44,-1,112,116,117,-1,117,113,112,-1,113,117,118,-1,118,114,113,-1,114,118,119,-1,119,115,114,-1,49,54,120,-1,120,116,49,-1,116,120,121,-1,121,117,116,-1,117,121,122,-1,122,118,117,-1,118,122,123,-1,123,119,118,-1,54,59,124,-1,124,120,54,-1,120,124,125,-1,125,121,120,-1,121,125,126,-1,126,122,121,-1,122,126,127,-1,127,123,122,-1,59,64,128,-1,128,124,59,-1,124,128,129,-1,129,125,124,-1,125,129,130,-1,130,126,125,-1,126,130,131,-1,131,127,126,-1,64,69,132,-1,132,128,64,-1,128,132,133,-1,133,129,128,-1,129,133,134,-1,134,130,129,-1,130,134,135,-1,135,131,130,-1,69,74,136,-1,136,132,69,-1,132,136,137,-1,137,133,132,-1,133,137,138,-1,138,134,133,-1,134,138,139,-1,139,135,134,-1,74,79,140,-1,140,136,74,-1,136,140,141,-1,141,137,136,-1,137,141,142,-1,142,138,137,-1,138,142,143,-1,143,139,138,-1,79,4,80,-1,80,140,79,-1};
			return value;
		}
		private int[] getIndexedFaceSet_8_21_coordIndex_2()
		{
			int[] value = {140,80,81,-1,81,141,140,-1,141,81,82,-1,82,142,141,-1,142,82,83,-1,83,143,142,-1,83,87,148,-1,148,144,83,-1,144,148,149,-1,149,145,144,-1,145,149,150,-1,150,146,145,-1,146,150,151,-1,151,147,146,-1,87,91,152,-1,152,148,87,-1,148,152,153,-1,153,149,148,-1,149,153,154,-1,154,150,149,-1,150,154,155,-1,155,151,150,-1,91,95,156,-1,156,152,91,-1,152,156,157,-1,157,153,152,-1,153,157,158,-1,158,154,153,-1,154,158,159,-1,159,155,154,-1,95,99,160,-1,160,156,95,-1,156,160,161,-1,161,157,156,-1,157,161,162,-1,162,158,157,-1,158,162,163,-1,163,159,158,-1,99,103,164,-1,164,160,99,-1,160,164,165,-1,165,161,160,-1,161,165,166,-1,166,162,161,-1,162,166,167,-1,167,163,162,-1,103,107,168,-1,168,164,103,-1,164,168,169,-1,169,165,164,-1,165,169,170,-1,170,166,165,-1,166,170,171,-1,171,167,166,-1,107,111,172,-1,172,168,107,-1,168,172,173,-1,173,169,168,-1,169,173,174,-1,174,170,169,-1,170,174,175,-1,175,171,170,-1,111,115,176,-1,176,172,111,-1,172,176,177,-1,177,173,172,-1,173,177,178,-1,178,174,173,-1,174,178,179,-1,179,175,174,-1,115,119,180,-1,180,176,115,-1,176,180,181,-1,181,177,176,-1,177,181,182,-1,182,178,177,-1,178,182,183,-1,183,179,178,-1,119,123,184,-1,184,180,119,-1,180,184,185,-1,185,181,180,-1,181,185,186,-1,186,182,181,-1,182,186,187,-1,187,183,182,-1,123,127,188,-1,188,184,123,-1,184,188,189,-1,189,185,184,-1,185,189,190,-1,190,186,185,-1,186,190,191,-1,191,187,186,-1,127,131,192,-1,192,188,127,-1,188,192,193,-1,193,189,188,-1,189,193,194,-1,194,190,189,-1,190,194,195,-1,195,191,190,-1,131,135,196,-1,196,192,131,-1,192,196,197,-1,197,193,192,-1,193,197,198,-1,198,194,193,-1,194,198,199,-1,199,195,194,-1,135,139,200,-1,200,196,135,-1,196,200,201,-1,201,197,196,-1,197,201,202,-1,202,198,197,-1,198,202,203,-1,203,199,198,-1,139,143,204,-1,204,200,139,-1,200,204,205,-1,205,201,200,-1,201,205,206,-1,206,202,201,-1,202,206,207,-1,207,203,202,-1,143,83,144,-1,144,204,143,-1,204,144,145,-1,145,205,204,-1,205,145,146,-1,146,206,205,-1,206,146,147,-1,147,207,206,-1,147,151,212,-1,212,208,147,-1,208,212,213,-1,213,209,208,-1,209,213,214,-1,214,210,209,-1,210,214,211,-1,211,211,210,-1,151,155,215,-1,215,212,151,-1,212,215,216,-1,216,213,212,-1,213,216,217,-1,217,214,213,-1,214,217,211,-1,211,211,214,-1,155,159,218,-1,218,215,155,-1,215,218,219,-1,219,216,215,-1,216,219,220,-1,220,217,216,-1,217,220,211,-1,211,211,217,-1,159,163,221,-1,221,218,159,-1,218,221,222,-1,222,219,218,-1,219,222,223,-1,223,220,219,-1,220,223,211,-1,211,211,220,-1,163,167,224,-1,224,221,163,-1,221,224,225,-1,225,222,221,-1,222,225,226,-1,226,223,222,-1,223,226,211,-1,211,211,223,-1,167,171,227,-1,227,224,167,-1,224,227,228,-1,228,225,224,-1,225,228,229,-1,229,226,225,-1,226,229,211,-1,211,211,226,-1,171,175,230,-1,230,227,171,-1,227,230,231,-1,231,228,227,-1,228,231,232,-1,232,229,228,-1,229,232,211,-1,211,211,229,-1,175,179,233,-1,233,230,175,-1,230,233,234,-1,234,231,230,-1,231,234,235,-1,235,232,231,-1,232,235,211,-1,211,211,232,-1,179,183,236,-1,236,233,179,-1,233,236,237,-1,237,234,233,-1,234,237,238,-1,238,235,234,-1,235,238,211,-1,211,211,235,-1,183,187,239,-1,239,236,183,-1,236,239,240,-1,240,237,236,-1,237,240,241,-1,241,238,237,-1,238,241,211,-1,211,211,238,-1,187,191,242,-1,242,239,187,-1,239,242,243,-1,243,240,239,-1,240,243,244,-1,244,241,240,-1,241,244,211,-1,211,211,241,-1,191,195,245,-1,245,242,191,-1,242,245,246,-1,246,243,242,-1,243,246,247,-1,247,244,243,-1,244,247,211,-1,211,211,244,-1,195,199,248,-1,248,245,195,-1,245,248,249,-1,249,246,245,-1,246,249,250,-1,250,247,246,-1,247,250,211,-1,211,211,247,-1,199,203,251,-1,251,248,199,-1,248,251,252,-1,252,249,248,-1,249,252,253,-1,253,250,249,-1,250,253,211,-1,211,211,250,-1,203,207,254,-1,254,251,203,-1,251,254,255,-1,255,252,251,-1};
			return value;
		}
		private int[] getIndexedFaceSet_8_21_coordIndex_3()
		{
			int[] value = {252,255,256,-1,256,253,252,-1,253,256,211,-1,211,211,253,-1,207,147,208,-1,208,254,207,-1,254,208,209,-1,209,255,254,-1,255,209,210,-1,210,256,255,-1,256,210,211,-1,211,211,256,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_21_point_1()
		{
			double[] value = {4.548,7.797,0.0,4.485,8.037,0.0,4.558,8.116,0.0,4.708,8.037,0.0,4.873,7.797,0.0,4.196,7.797,1.785,4.137,8.037,1.76,4.205,8.116,1.789,4.343,8.037,1.848,4.495,7.797,1.913,3.229,7.797,3.229,3.184,8.037,3.184,3.236,8.116,3.236,3.343,8.037,3.343,3.46,7.797,3.46,1.785,7.797,4.196,1.76,8.037,4.137,1.789,8.116,4.205,1.848,8.037,4.343,1.913,7.797,4.495,0.0,7.797,4.548,0.0,8.037,4.485,0.0,8.116,4.558,0.0,8.037,4.708,0.0,7.797,4.873,-1.908,7.797,4.196,-1.812,8.037,4.137,-1.805,8.116,4.205,-1.85,8.037,4.343,-1.913,7.797,4.495,-3.339,7.797,3.229,-3.23,8.037,3.184,-3.25,8.116,3.236,-3.344,8.037,3.343,-3.46,7.797,3.46,-4.237,7.797,1.785,-4.154,8.037,1.76,-4.21,8.116,1.789,-4.344,8.037,1.848,-4.495,7.797,1.913,-4.548,7.797,0.0,-4.485,8.037,0.0,-4.558,8.116,0.0,-4.708,8.037,0.0,-4.873,7.797,0.0,-4.196,7.797,-1.785,-4.137,8.037,-1.76,-4.205,8.116,-1.789,-4.343,8.037,-1.848,-4.495,7.797,-1.913,-3.229,7.797,-3.229,-3.184,8.037,-3.184,-3.236,8.116,-3.236,-3.343,8.037,-3.343,-3.46,7.797,-3.46,-1.785,7.797,-4.196,-1.76,8.037,-4.137,-1.789,8.116,-4.205,-1.848,8.037,-4.343,-1.913,7.797,-4.495,0.0,7.797,-4.548,0.0,8.037,-4.485,0.0,8.116,-4.558,0.0,8.037,-4.708,0.0,7.797,-4.873,1.785,7.797,-4.196,1.76,8.037,-4.137,1.789,8.116,-4.205,1.848,8.037,-4.343,1.913,7.797,-4.495,3.229,7.797,-3.229,3.184,8.037,-3.184,3.236,8.116,-3.236,3.343,8.037,-3.343,3.46,7.797,-3.46,4.196,7.797,-1.785,4.137,8.037,-1.76,4.205,8.116,-1.789,4.343,8.037,-1.848,4.495,7.797,-1.913,5.469,6.521,0.0,5.99,5.269,0.0,6.358,4.062,0.0,6.497,2.924,0.0,5.045,6.521,2.147,5.525,5.269,2.351,5.865,4.062,2.495,5.994,2.924,2.55,3.883,6.521,3.883,4.253,5.269,4.253,4.514,4.062,4.514,4.613,2.924,4.613,2.147,6.521,5.045,2.351,5.269,5.525,2.495,4.062,5.865,2.55,2.924,5.994,0.0,6.521,5.469,0.0,5.269,5.99,0.0,4.062,6.358,0.0,2.924,6.497};
			return value;
		}
		private double[] getCoordinate_9_21_point_2()
		{
			double[] value = {-2.147,6.521,5.045,-2.351,5.269,5.525,-2.495,4.062,5.865,-2.55,2.924,5.994,-3.883,6.521,3.883,-4.253,5.269,4.253,-4.514,4.062,4.514,-4.613,2.924,4.613,-5.045,6.521,2.147,-5.525,5.269,2.351,-5.865,4.062,2.495,-5.994,2.924,2.55,-5.469,6.521,0.0,-5.99,5.269,0.0,-6.358,4.062,0.0,-6.497,2.924,0.0,-5.045,6.521,-2.147,-5.525,5.269,-2.351,-5.865,4.062,-2.495,-5.994,2.924,-2.55,-3.883,6.521,-3.883,-4.253,5.269,-4.253,-4.514,4.062,-4.514,-4.613,2.924,-4.613,-2.147,6.521,-5.045,-2.351,5.269,-5.525,-2.495,4.062,-5.865,-2.55,2.924,-5.994,0.0,6.521,-5.469,0.0,5.269,-5.99,0.0,4.062,-6.358,0.0,2.924,-6.497,2.147,6.521,-5.045,2.351,5.269,-5.525,2.495,4.062,-5.865,2.55,2.924,-5.994,3.883,6.521,-3.883,4.253,5.269,-4.253,4.514,4.062,-4.514,4.613,2.924,-4.613,5.045,6.521,-2.147,5.525,5.269,-2.351,5.865,4.062,-2.495,5.994,2.924,-2.55,6.243,1.961,0.0,5.685,1.249,0.0,5.127,0.7652,0.0,4.873,0.4873,0.0,5.76,1.961,2.451,5.244,1.249,2.231,4.729,0.7652,2.012,4.495,0.4873,1.913,4.433,1.961,4.433,4.036,1.249,4.036,3.64,0.7652,3.64,3.46,0.4873,3.46,2.451,1.961,5.76,2.231,1.249,5.244,2.012,0.7652,4.729,1.913,0.4873,4.495,0.0,1.961,6.243,0.0,1.249,5.685,0.0,0.7652,5.127,0.0,0.4873,4.873,-2.451,1.961,5.76,-2.231,1.249,5.244,-2.012,0.7652,4.729,-1.913,0.4873,4.495,-4.433,1.961,4.433,-4.036,1.249,4.036,-3.64,0.7652,3.64,-3.46,0.4873,3.46,-5.76,1.961,2.451,-5.244,1.249,2.231,-4.729,0.7652,2.012,-4.495,0.4873,1.913,-6.243,1.961,0.0,-5.685,1.249,0.0,-5.127,0.7652,0.0,-4.873,0.4873,0.0,-5.76,1.961,-2.451,-5.244,1.249,-2.231,-4.729,0.7652,-2.012,-4.495,0.4873,-1.913,-4.433,1.961,-4.433,-4.036,1.249,-4.036,-3.64,0.7652,-3.64,-3.46,0.4873,-3.46,-2.451,1.961,-5.76,-2.231,1.249,-5.244,-2.012,0.7652,-4.729,-1.913,0.4873,-4.495,0.0,1.961,-6.243,0.0,1.249,-5.685,0.0,0.7652,-5.127,0.0,0.4873,-4.873,2.451,1.961,-5.76,2.231,1.249,-5.244,2.012,0.7652,-4.729,1.913,0.4873,-4.495};
			return value;
		}
		private double[] getCoordinate_9_21_point_3()
		{
			double[] value = {4.433,1.961,-4.433,4.036,1.249,-4.036,3.64,0.7652,-3.64,3.46,0.4873,-3.46,5.76,1.961,-2.451,5.244,1.249,-2.231,4.729,0.7652,-2.012,4.495,0.4873,-1.913,4.763,0.3084,0.0,4.172,0.1523,0.0,2.714,0.04188,0.0,0.0,0.0,0.0,4.393,0.3084,1.869,3.849,0.1523,1.638,2.504,0.04188,1.065,3.381,0.3084,3.381,2.962,0.1523,2.962,1.927,0.04188,1.927,1.869,0.3084,4.393,1.638,0.1523,3.849,1.065,0.04188,2.504,0.0,0.3084,4.763,0.0,0.1523,4.172,0.0,0.04188,2.714,-1.869,0.3084,4.393,-1.638,0.1523,3.849,-1.065,0.04188,2.504,-3.381,0.3084,3.381,-2.962,0.1523,2.962,-1.927,0.04188,1.927,-4.393,0.3084,1.869,-3.849,0.1523,1.638,-2.504,0.04188,1.065,-4.763,0.3084,0.0,-4.172,0.1523,0.0,-2.714,0.04188,0.0,-4.393,0.3084,-1.869,-3.849,0.1523,-1.638,-2.504,0.04188,-1.065,-3.381,0.3084,-3.381,-2.962,0.1523,-2.962,-1.927,0.04188,-1.927,-1.869,0.3084,-4.393,-1.638,0.1523,-3.849,-1.065,0.04188,-2.504,0.0,0.3084,-4.763,0.0,0.1523,-4.172,0.0,0.04188,-2.714,1.869,0.3084,-4.393,1.638,0.1523,-3.849,1.065,0.04188,-2.504,3.381,0.3084,-3.381,2.962,0.1523,-2.962,1.927,0.04188,-1.927,4.393,0.3084,-1.869,3.849,0.1523,-1.638,2.504,0.04188,-1.065};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_8_27_coordIndex_1()
		{
			int[] value = {0,5,6,-1,6,1,0,-1,1,6,7,-1,7,2,1,-1,2,7,8,-1,8,3,2,-1,3,8,9,-1,9,4,3,-1,5,10,11,-1,11,6,5,-1,6,11,12,-1,12,7,6,-1,7,12,13,-1,13,8,7,-1,8,13,14,-1,14,9,8,-1,10,15,16,-1,16,11,10,-1,11,16,17,-1,17,12,11,-1,12,17,18,-1,18,13,12,-1,13,18,19,-1,19,14,13,-1,15,20,21,-1,21,16,15,-1,16,21,22,-1,22,17,16,-1,17,22,23,-1,23,18,17,-1,18,23,24,-1,24,19,18,-1,20,25,26,-1,26,21,20,-1,21,26,27,-1,27,22,21,-1,22,27,28,-1,28,23,22,-1,23,28,29,-1,29,24,23,-1,25,30,31,-1,31,26,25,-1,26,31,32,-1,32,27,26,-1,27,32,33,-1,33,28,27,-1,28,33,34,-1,34,29,28,-1,30,35,36,-1,36,31,30,-1,31,36,37,-1,37,32,31,-1,32,37,38,-1,38,33,32,-1,33,38,39,-1,39,34,33,-1,35,0,1,-1,1,36,35,-1,36,1,2,-1,2,37,36,-1,37,2,3,-1,3,38,37,-1,38,3,4,-1,4,39,38,-1,4,9,44,-1,44,40,4,-1,40,44,45,-1,45,41,40,-1,41,45,46,-1,46,42,41,-1,42,46,47,-1,47,43,42,-1,9,14,48,-1,48,44,9,-1,44,48,49,-1,49,45,44,-1,45,49,50,-1,50,46,45,-1,46,50,51,-1,51,47,46,-1,14,19,52,-1,52,48,14,-1,48,52,53,-1,53,49,48,-1,49,53,54,-1,54,50,49,-1,50,54,55,-1,55,51,50,-1,19,24,56,-1,56,52,19,-1,52,56,57,-1,57,53,52,-1,53,57,58,-1,58,54,53,-1,54,58,59,-1,59,55,54,-1,24,29,60,-1,60,56,24,-1,56,60,61,-1,61,57,56,-1,57,61,62,-1,62,58,57,-1,58,62,63,-1,63,59,58,-1,29,34,64,-1,64,60,29,-1,60,64,65,-1,65,61,60,-1,61,65,66,-1,66,62,61,-1,62,66,67,-1,67,63,62,-1,34,39,68,-1,68,64,34,-1,64,68,69,-1,69,65,64,-1,65,69,70,-1,70,66,65,-1,66,70,71,-1,71,67,66,-1,39,4,40,-1,40,68,39,-1,68,40,41,-1,41,69,68,-1,69,41,42,-1,42,70,69,-1,70,42,43,-1,43,71,70,-1};
			return value;
		}



		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_8_33_coordIndex_1()
		{
			int[] value = {0,5,6,-1,6,1,0,-1,1,6,7,-1,7,2,1,-1,2,7,8,-1,8,3,2,-1,3,8,9,-1,9,4,3,-1,5,10,11,-1,11,6,5,-1,6,11,12,-1,12,7,6,-1,7,12,13,-1,13,8,7,-1,8,13,14,-1,14,9,8,-1,10,15,16,-1,16,11,10,-1,11,16,17,-1,17,12,11,-1,12,17,18,-1,18,13,12,-1,13,18,19,-1,19,14,13,-1,15,20,21,-1,21,16,15,-1,16,21,22,-1,22,17,16,-1,17,22,23,-1,23,18,17,-1,18,23,24,-1,24,19,18,-1,20,25,26,-1,26,21,20,-1,21,26,27,-1,27,22,21,-1,22,27,28,-1,28,23,22,-1,23,28,29,-1,29,24,23,-1,25,30,31,-1,31,26,25,-1,26,31,32,-1,32,27,26,-1,27,32,33,-1,33,28,27,-1,28,33,34,-1,34,29,28,-1,30,35,36,-1,36,31,30,-1,31,36,37,-1,37,32,31,-1,32,37,38,-1,38,33,32,-1,33,38,39,-1,39,34,33,-1,35,0,1,-1,1,36,35,-1,36,1,2,-1,2,37,36,-1,37,2,3,-1,3,38,37,-1,38,3,4,-1,4,39,38,-1,4,9,44,-1,44,40,4,-1,40,44,45,-1,45,41,40,-1,41,45,46,-1,46,42,41,-1,42,46,47,-1,47,43,42,-1,9,14,48,-1,48,44,9,-1,44,48,49,-1,49,45,44,-1,45,49,50,-1,50,46,45,-1,46,50,51,-1,51,47,46,-1,14,19,52,-1,52,48,14,-1,48,52,53,-1,53,49,48,-1,49,53,54,-1,54,50,49,-1,50,54,55,-1,55,51,50,-1,19,24,56,-1,56,52,19,-1,52,56,57,-1,57,53,52,-1,53,57,58,-1,58,54,53,-1,54,58,59,-1,59,55,54,-1,24,29,60,-1,60,56,24,-1,56,60,61,-1,61,57,56,-1,57,61,62,-1,62,58,57,-1,58,62,63,-1,63,59,58,-1,29,34,64,-1,64,60,29,-1,60,64,65,-1,65,61,60,-1,61,65,66,-1,66,62,61,-1,62,66,67,-1,67,63,62,-1,34,39,68,-1,68,64,34,-1,64,68,69,-1,69,65,64,-1,65,69,70,-1,70,66,65,-1,66,70,71,-1,71,67,66,-1,39,4,40,-1,40,68,39,-1,68,40,41,-1,41,69,68,-1,69,41,42,-1,42,70,69,-1,70,42,43,-1,43,71,70,-1};
			return value;
		}



		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_8_39_coordIndex_1()
		{
			int[] value = {0,0,5,-1,5,1,0,-1,1,5,6,-1,6,2,1,-1,2,6,7,-1,7,3,2,-1,3,7,8,-1,8,4,3,-1,0,0,9,-1,9,5,0,-1,5,9,10,-1,10,6,5,-1,6,10,11,-1,11,7,6,-1,7,11,12,-1,12,8,7,-1,0,0,13,-1,13,9,0,-1,9,13,14,-1,14,10,9,-1,10,14,15,-1,15,11,10,-1,11,15,16,-1,16,12,11,-1,0,0,17,-1,17,13,0,-1,13,17,18,-1,18,14,13,-1,14,18,19,-1,19,15,14,-1,15,19,20,-1,20,16,15,-1,0,0,21,-1,21,17,0,-1,17,21,22,-1,22,18,17,-1,18,22,23,-1,23,19,18,-1,19,23,24,-1,24,20,19,-1,0,0,25,-1,25,21,0,-1,21,25,26,-1,26,22,21,-1,22,26,27,-1,27,23,22,-1,23,27,28,-1,28,24,23,-1,0,0,29,-1,29,25,0,-1,25,29,30,-1,30,26,25,-1,26,30,31,-1,31,27,26,-1,27,31,32,-1,32,28,27,-1,0,0,33,-1,33,29,0,-1,29,33,34,-1,34,30,29,-1,30,34,35,-1,35,31,30,-1,31,35,36,-1,36,32,31,-1,0,0,37,-1,37,33,0,-1,33,37,38,-1,38,34,33,-1,34,38,39,-1,39,35,34,-1,35,39,40,-1,40,36,35,-1,0,0,41,-1,41,37,0,-1,37,41,42,-1,42,38,37,-1,38,42,43,-1,43,39,38,-1,39,43,44,-1,44,40,39,-1,0,0,45,-1,45,41,0,-1,41,45,46,-1,46,42,41,-1,42,46,47,-1,47,43,42,-1,43,47,48,-1,48,44,43,-1,0,0,49,-1,49,45,0,-1,45,49,50,-1,50,46,45,-1,46,50,51,-1,51,47,46,-1,47,51,52,-1,52,48,47,-1,0,0,53,-1,53,49,0,-1,49,53,54,-1,54,50,49,-1,50,54,55,-1,55,51,50,-1,51,55,56,-1,56,52,51,-1,0,0,57,-1,57,53,0,-1,53,57,58,-1,58,54,53,-1,54,58,59,-1,59,55,54,-1,55,59,60,-1,60,56,55,-1,0,0,61,-1,61,57,0,-1,57,61,62,-1,62,58,57,-1,58,62,63,-1,63,59,58,-1,59,63,64,-1,64,60,59,-1,0,0,1,-1,1,61,0,-1,61,1,2,-1,2,62,61,-1,62,2,3,-1,3,63,62,-1,63,3,4,-1,4,64,63,-1,4,8,69,-1,69,65,4,-1,65,69,70,-1,70,66,65,-1,66,70,71,-1,71,67,66,-1,67,71,72,-1,72,68,67,-1,8,12,73,-1,73,69,8,-1,69,73,74,-1,74,70,69,-1,70,74,75,-1,75,71,70,-1,71,75,76,-1,76,72,71,-1,12,16,77,-1,77,73,12,-1,73,77,78,-1,78,74,73,-1,74,78,79,-1,79,75,74,-1,75,79,80,-1,80,76,75,-1,16,20,81,-1,81,77,16,-1,77,81,82,-1,82,78,77,-1,78,82,83,-1,83,79,78,-1,79,83,84,-1,84,80,79,-1,20,24,85,-1,85,81,20,-1,81,85,86,-1,86,82,81,-1,82,86,87,-1,87,83,82,-1,83,87,88,-1,88,84,83,-1,24,28,89,-1,89,85,24,-1,85,89,90,-1,90,86,85,-1,86,90,91,-1,91,87,86,-1,87,91,92,-1,92,88,87,-1,28,32,93,-1,93,89,28,-1,89,93,94,-1,94,90,89,-1,90,94,95,-1,95,91,90,-1,91,95,96,-1,96,92,91,-1,32,36,97,-1,97,93,32,-1,93,97,98,-1,98,94,93,-1,94,98,99,-1,99,95,94,-1,95,99,100,-1,100,96,95,-1,36,40,101,-1,101,97,36,-1,97,101,102,-1,102,98,97,-1,98,102,103,-1,103,99,98,-1,99,103,104,-1,104,100,99,-1,40,44,105,-1,105,101,40,-1,101,105,106,-1,106,102,101,-1,102,106,107,-1,107,103,102,-1,103,107,108,-1,108,104,103,-1,44,48,109,-1,109,105,44,-1,105,109,110,-1,110,106,105,-1,106,110,111,-1,111,107,106,-1,107,111,112,-1,112,108,107,-1,48,52,113,-1,113,109,48,-1,109,113,114,-1,114,110,109,-1,110,114,115,-1,115,111,110,-1,111,115,116,-1,116,112,111,-1,52,56,117,-1,117,113,52,-1,113,117,118,-1,118,114,113,-1,114,118,119,-1,119,115,114,-1,115,119,120,-1,120,116,115,-1,56,60,121,-1,121,117,56,-1,117,121,122,-1,122,118,117,-1,118,122,123,-1,123,119,118,-1,119,123,124,-1,124,120,119,-1,60,64,125,-1,125,121,60,-1,121,125,126,-1,126,122,121,-1,122,126,127,-1,127,123,122,-1,123,127,128,-1,128,124,123,-1,64,4,65,-1,65,125,64,-1};
			return value;
		}
		private int[] getIndexedFaceSet_8_39_coordIndex_2()
		{
			int[] value = {125,65,66,-1,66,126,125,-1,126,66,67,-1,67,127,126,-1,127,67,68,-1,68,128,127,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTeapot01_COORD_9_39_point_1()
		{
			double[] value = {0.0,10.23,0.0,1.107,10.07,0.0,1.056,9.685,0.0,0.6396,9.205,0.0,0.6497,8.771,0.0,1.021,10.07,0.4355,0.9743,9.685,0.4154,0.5901,9.205,0.2514,0.5994,8.771,0.255,0.7867,10.07,0.7867,0.7505,9.685,0.7505,0.4544,9.205,0.4544,0.4613,8.771,0.4613,0.4355,10.07,1.021,0.4154,9.685,0.9743,0.2514,9.205,0.5901,0.255,8.771,0.5994,0.0,10.07,1.107,0.0,9.685,1.056,0.0,9.205,0.6396,0.0,8.771,0.6497,-0.4355,10.07,1.021,-0.4154,9.685,0.9743,-0.2514,9.205,0.5901,-0.255,8.771,0.5994,-0.7867,10.07,0.7867,-0.7505,9.685,0.7505,-0.4544,9.205,0.4544,-0.4613,8.771,0.4613,-1.021,10.07,0.4355,-0.9743,9.685,0.4154,-0.5901,9.205,0.2514,-0.5994,8.771,0.255,-1.107,10.07,0.0,-1.056,9.685,0.0,-0.6396,9.205,0.0,-0.6497,8.771,0.0,-1.021,10.07,-0.4355,-0.9743,9.685,-0.4154,-0.5901,9.205,-0.2514,-0.5994,8.771,-0.255,-0.7867,10.07,-0.7867,-0.7505,9.685,-0.7505,-0.4544,9.205,-0.4544,-0.4613,8.771,-0.4613,-0.4355,10.07,-1.021,-0.4154,9.685,-0.9743,-0.2514,9.205,-0.5901,-0.255,8.771,-0.5994,0.0,10.07,-1.107,0.0,9.685,-1.056,0.0,9.205,-0.6396,0.0,8.771,-0.6497,0.4355,10.07,-1.021,0.4154,9.685,-0.9743,0.2514,9.205,-0.5901,0.255,8.771,-0.5994,0.7867,10.07,-0.7867,0.7505,9.685,-0.7505,0.4544,9.205,-0.4544,0.4613,8.771,-0.4613,1.021,10.07,-0.4355,0.9743,9.685,-0.4154,0.5901,9.205,-0.2514,0.5994,8.771,-0.255,1.482,8.482,0.0,2.68,8.284,0.0,3.756,8.086,0.0,4.223,7.797,0.0,1.367,8.482,0.5818,2.472,8.284,1.052,3.465,8.086,1.474,3.896,7.797,1.658,1.052,8.482,1.052,1.903,8.284,1.903,2.667,8.086,2.667,2.998,7.797,2.998,0.5818,8.482,1.367,1.052,8.284,2.472,1.474,8.086,3.465,1.658,7.797,3.896,0.0,8.482,1.482,0.0,8.284,2.68,0.0,8.086,3.756,0.0,7.797,4.223,-0.5818,8.482,1.367,-1.052,8.284,2.472,-1.474,8.086,3.465,-1.658,7.797,3.896,-1.052,8.482,1.052,-1.903,8.284,1.903,-2.667,8.086,2.667,-2.998,7.797,2.998,-1.367,8.482,0.5818,-2.472,8.284,1.052,-3.465,8.086,1.474,-3.896,7.797,1.658,-1.482,8.482,0.0,-2.68,8.284,0.0,-3.756,8.086,0.0};
			return value;
		}
		private double[] getTeapot01_COORD_9_39_point_2()
		{
			double[] value = {-4.223,7.797,0.0,-1.367,8.482,-0.5818,-2.472,8.284,-1.052,-3.465,8.086,-1.474,-3.896,7.797,-1.658,-1.052,8.482,-1.052,-1.903,8.284,-1.903,-2.667,8.086,-2.667,-2.998,7.797,-2.998,-0.5818,8.482,-1.367,-1.052,8.284,-2.472,-1.474,8.086,-3.465,-1.658,7.797,-3.896,0.0,8.482,-1.482,0.0,8.284,-2.68,0.0,8.086,-3.756,0.0,7.797,-4.223,0.5818,8.482,-1.367,1.052,8.284,-2.472,1.474,8.086,-3.465,1.658,7.797,-3.896,1.052,8.482,-1.052,1.903,8.284,-1.903,2.667,8.086,-2.667,2.998,7.797,-2.998,1.367,8.482,-0.5818,2.472,8.284,-1.052,3.465,8.086,-1.474,3.896,7.797,-1.658};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=8, element #21, 2048 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_8_21_coordIndex()
		{
			MFInt32 IndexedFaceSet_8_21_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_8_21_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_8_21_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_8_21_coordIndex_3()));
			return IndexedFaceSet_8_21_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #21, 771 total numbers made up of 257 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_21_point()
		{
			MFVec3f Coordinate_9_21_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_9_21_point_1()))
				.append(new MFVec3f(getCoordinate_9_21_point_2()))
				.append(new MFVec3f(getCoordinate_9_21_point_3()));
			return Coordinate_9_21_point;
		}
		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=8, element #27, 512 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_8_27_coordIndex()
		{
			MFInt32 IndexedFaceSet_8_27_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_8_27_coordIndex_1()));
			return IndexedFaceSet_8_27_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #27, 216 total numbers made up of 72 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_27_point()
		{
			MFVec3f Coordinate_9_27_point = new MFVec3f(new double[] {5.523,4.629,0.0,7.081,4.987,0.0,7.756,5.848,0.0,8.127,6.891,0.0,8.771,7.797,0.0,5.523,4.211,1.206,7.2,4.677,1.089,7.908,5.667,0.8314,8.312,6.825,0.5739,9.076,7.797,0.4568,5.523,3.289,1.608,7.462,3.994,1.452,8.243,5.269,1.109,8.72,6.681,0.7652,9.746,7.797,0.6091,5.523,2.368,1.206,7.723,3.31,1.089,8.578,4.871,0.8314,9.129,6.537,0.5739,10.42,7.797,0.4568,5.523,1.949,0.0,7.842,3.0,0.0,8.731,4.69,0.0,9.314,6.472,0.0,10.72,7.797,0.0,5.523,2.368,-1.206,7.723,3.31,-1.089,8.578,4.871,-0.8314,9.129,6.537,-0.5739,10.42,7.797,-0.4568,5.523,3.289,-1.608,7.462,3.994,-1.452,8.243,5.269,-1.109,8.72,6.681,-0.7652,9.746,7.797,-0.6091,5.523,4.211,-1.206,7.2,4.677,-1.089,7.908,5.667,-0.8314,8.312,6.825,-0.5739,9.076,7.797,-0.4568,9.005,7.934,0.0,9.177,7.979,0.0,9.228,7.934,0.0,9.096,7.797,0.0,9.331,7.94,0.4283,9.483,7.99,0.3655,9.488,7.943,0.3027,9.299,7.797,0.2741,10.05,7.955,0.571,10.16,8.014,0.4873,10.06,7.964,0.4035,9.746,7.797,0.3655,10.77,7.97,0.4283,10.83,8.037,0.3655,10.63,7.984,0.3027,10.19,7.797,0.2741,11.09,7.977,0.0,11.14,8.048,0.0,10.89,7.994,0.0,10.4,7.797,0.0,10.77,7.97,-0.4283,10.83,8.037,-0.3655,10.63,7.984,-0.3027,10.19,7.797,-0.2741,10.05,7.955,-0.571,10.16,8.014,-0.4873,10.06,7.964,-0.4035,9.746,7.797,-0.3655,9.331,7.94,-0.4283,9.483,7.99,-0.3655,9.488,7.943,-0.3027,9.299,7.797,-0.2741});
			return Coordinate_9_27_point;
		}
		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=8, element #33, 512 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_8_33_coordIndex()
		{
			MFInt32 IndexedFaceSet_8_33_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_8_33_coordIndex_1()));
			return IndexedFaceSet_8_33_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=9, element #33, 216 total numbers made up of 72 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_9_33_point()
		{
			MFVec3f Coordinate_9_33_point = new MFVec3f(new double[] {-5.198,6.578,0.0,-6.715,6.567,0.0,-7.837,6.487,0.0,-8.533,6.27,0.0,-8.771,5.848,0.0,-5.147,6.693,0.5482,-6.761,6.679,0.5482,-7.945,6.587,0.5482,-8.675,6.336,0.5482,-8.924,5.848,0.5482,-5.035,6.944,0.7309,-6.86,6.927,0.7309,-8.182,6.807,0.7309,-8.987,6.481,0.7309,-9.259,5.848,0.7309,-4.924,7.195,0.5482,-6.96,7.174,0.5482,-8.42,7.027,0.5482,-9.299,6.627,0.5482,-9.594,5.848,0.5482,-4.873,7.309,0.0,-7.005,7.287,0.0,-8.528,7.127,0.0,-9.441,6.693,0.0,-9.746,5.848,0.0,-4.924,7.195,-0.5482,-6.96,7.174,-0.5482,-8.42,7.027,-0.5482,-9.299,6.627,-0.5482,-9.594,5.848,-0.5482,-5.035,6.944,-0.7309,-6.86,6.927,-0.7309,-8.182,6.807,-0.7309,-8.987,6.481,-0.7309,-9.259,5.848,-0.7309,-5.147,6.693,-0.5482,-6.761,6.679,-0.5482,-7.945,6.587,-0.5482,-8.675,6.336,-0.5482,-8.924,5.848,-0.5482,-8.644,5.185,0.0,-8.243,4.386,0.0,-7.538,3.586,0.0,-6.497,2.924,0.0,-8.783,5.121,0.5482,-8.342,4.288,0.5482,-7.572,3.466,0.5482,-6.446,2.771,0.5482,-9.087,4.98,0.7309,-8.558,4.073,0.7309,-7.648,3.201,0.7309,-6.335,2.436,0.7309,-9.392,4.84,0.5482,-8.774,3.859,0.5482,-7.724,2.936,0.5482,-6.223,2.101,0.5482,-9.53,4.776,0.0,-8.873,3.761,0.0,-7.759,2.815,0.0,-6.172,1.949,0.0,-9.392,4.84,-0.5482,-8.774,3.859,-0.5482,-7.724,2.936,-0.5482,-6.223,2.101,-0.5482,-9.087,4.98,-0.7309,-8.558,4.073,-0.7309,-7.648,3.201,-0.7309,-6.335,2.436,-0.7309,-8.783,5.121,-0.5482,-8.342,4.288,-0.5482,-7.572,3.466,-0.5482,-6.446,2.771,-0.5482});
			return Coordinate_9_33_point;
		}
		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=8, element #39, 1024 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_8_39_coordIndex()
		{
			MFInt32 IndexedFaceSet_8_39_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_8_39_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_8_39_coordIndex_2()));
			return IndexedFaceSet_8_39_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='Teapot01-COORD' point field, scene-graph level=9, element #39, 387 total numbers made up of 129 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getTeapot01_COORD_9_39_point()
		{
			MFVec3f Teapot01_COORD_9_39_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getTeapot01_COORD_9_39_point_1()))
				.append(new MFVec3f(getTeapot01_COORD_9_39_point_2()));
			return Teapot01_COORD_9_39_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return CadTeapot model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new CadTeapot().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.CAD.CadTeapot\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.CAD.CadTeapot self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // CAD/CadTeapot_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "CAD/CadTeapot_JavaExport.x3d"; 
                String filenameX3DV = "CAD/CadTeapot_JavaExport.x3dv"; 
                String filenameJSON = "CAD/CadTeapot_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
