/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vProcessor.parse;

import java.io.InputStream;
import java.util.Hashtable;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vProcessor.com.x3pGlobal;
import jp.co.lattice.vProcessor.com.x3pRoot;
import jp.co.lattice.vProcessor.node.x3pContent;
import jp.co.lattice.vProcessor.node.x3pCoordinate;
import jp.co.lattice.vProcessor.node.x3pElement;
import jp.co.lattice.vProcessor.node.x3pFieldColor;
import jp.co.lattice.vProcessor.node.x3pFieldRotation;
import jp.co.lattice.vProcessor.node.x3pFieldUV;
import jp.co.lattice.vProcessor.node.x3pFieldVec3f;
import jp.co.lattice.vProcessor.node.x3pImageTexture;
import jp.co.lattice.vProcessor.node.x3pMaterial;
import jp.co.lattice.vProcessor.node.x3pTextureCoordinate;
import jp.co.lattice.vProcessor.node.x3pTransform;
import jp.co.lattice.vProcessor.node.x3pUseElm;
import jp.co.lattice.vProcessor.node.x3pXvlEdge;
import jp.co.lattice.vProcessor.node.x3pXvlFace;
import jp.co.lattice.vProcessor.node.x3pXvlShape;
import jp.co.lattice.vProcessor.node.x3pXvlVertex;
import jp.co.lattice.vProcessor.parse.x3pKeyword;
import jp.co.lattice.vProcessor.parse.x3pLex;

public class x3pParse
extends x3pRoot
implements x3pKeyword {
    private static final x3pElement elmUnknown = new x3pElement(64);
    protected static final x3pElement elmEmpty = new x3pElement(65);
    private static final Boolean boolFalse = new Boolean(false);
    private static final Boolean boolTrue = new Boolean(true);
    protected x3pLex lexer;
    protected x3pElement[] topElms;
    protected Hashtable xmlIdTable;
    private int id;

    public x3pParse(x3pGlobal x3pGlobal2, InputStream inputStream) throws lvThrowable {
        super(x3pGlobal2);
        this.lexer = new x3pLex(x3pGlobal2, inputStream);
        this.xmlIdTable = new Hashtable(150);
    }

    public final int GetLineNo() {
        int n = 0;
        if (this.lexer != null) {
            n = this.lexer.GetLineNo();
        }
        return n;
    }

    public final void Parse() throws lvThrowable {
        this.GetToken();
        this.topElms = this.PsDeclarations();
    }

    public final x3pElement[] GetTopElms() {
        return this.topElms;
    }

    public Hashtable GetXmlIdTable() {
        return this.xmlIdTable;
    }

    protected final void GetToken() throws lvThrowable {
        this.id = this.lexer.GetToken();
    }

    protected final void SkipToken(int n) throws lvThrowable {
        for (int i = 0; i < n; ++i) {
            this.id = this.lexer.GetToken();
        }
    }

    protected final x3pElement[] PsDeclarations() throws lvThrowable {
        int n;
        x3pElement[] x3pElementArray;
        x3pElement x3pElement2;
        x3pElement[] x3pElementArray2 = new x3pElement[32];
        int n2 = 32;
        int n3 = 0;
        while ((x3pElement2 = this.PsDeclaration()) != null) {
            x3pElementArray2[n3] = x3pElement2;
            if (++n3 < n2) continue;
            x3pElementArray = new x3pElement[n2 + 32];
            for (n = 0; n < n3; ++n) {
                x3pElementArray[n] = x3pElementArray2[n];
            }
            x3pElementArray2 = x3pElementArray;
            n2 += 32;
        }
        x3pElementArray = new x3pElement[n3];
        for (n = 0; n < n3; ++n) {
            x3pElementArray[n] = x3pElementArray2[n];
        }
        x3pElementArray2 = x3pElementArray;
        return x3pElementArray2;
    }

    protected final x3pElement PsDeclaration() throws lvThrowable {
        x3pElement x3pElement2 = null;
        while (true) {
            if (this.id == 259) {
                boolean bl;
                this.GetToken();
                if (this.lexer.IsElement(this.id)) {
                    int n = this.id;
                    this.GetToken();
                    x3pElement2 = this.PsElement(n);
                    if (x3pElement2 == null) {
                        return null;
                    }
                    if (x3pElement2.type == 64) {
                        bl = this.SkipBlockForWord(n);
                        if (!bl) continue;
                        return null;
                    }
                    if (x3pElement2.type == 65) continue;
                    break;
                }
                if (this.id == 263) {
                    this.GetToken();
                    boolean bl2 = this.GetQuestionElm();
                    if (!bl2) continue;
                    return null;
                }
                if (this.id == 262) {
                    this.GetToken();
                    boolean bl3 = this.SkipTag();
                    if (!bl3) continue;
                    return null;
                }
                if (this.id == 384) {
                    String string = this.lexer.GetUnknown();
                    this.GetToken();
                    bl = this.SkipBlockForUnknown(string);
                    if (!bl) continue;
                    return null;
                }
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 0) {
                return null;
            }
            this.GetToken();
        }
        return x3pElement2;
    }

    protected final boolean GetQuestionElm() throws lvThrowable {
        while (true) {
            if (this.id == 263) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 789) {
                this.SkipToken(3);
                if (this.id == 1031 || this.id == 1032) {
                    this.lexer.SetEncodingId(this.id);
                } else {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.AssertSyntaxError(this.id == 260);
        this.GetToken();
        return false;
    }

    protected final x3pElement PsElement(int n) throws lvThrowable {
        x3pElement x3pElement2 = null;
        switch (n) {
            case 512: {
                x3pElement2 = this.PsElmX3D();
                break;
            }
            case 513: {
                x3pElement2 = this.PsElmScene();
                break;
            }
            case 514: {
                x3pElement2 = this.PsElmTransform();
                break;
            }
            case 515: {
                x3pElement2 = this.PsElmXvlShape();
                break;
            }
            case 516: {
                x3pElement2 = this.PsElmXvlFaces();
                break;
            }
            case 517: {
                x3pElement2 = this.PsElmXvlEdges();
                break;
            }
            case 518: {
                x3pElement2 = this.PsElmXvlVertices();
                break;
            }
            case 519: {
                x3pElement2 = this.PsElmXvlFace();
                break;
            }
            case 520: {
                x3pElement2 = this.PsElmXvlEdge();
                break;
            }
            case 521: {
                x3pElement2 = this.PsElmXvlVertex();
                break;
            }
            case 522: {
                x3pElement2 = this.PsElmMaterial();
                break;
            }
            case 523: {
                x3pElement2 = this.PsElmImageTexture();
                break;
            }
            case 524: {
                x3pElement2 = this.PsElmCoordinate();
                break;
            }
            case 525: {
                x3pElement2 = this.PsElmTextureCoordinate();
            }
        }
        return x3pElement2;
    }

    protected final x3pElement PsElmX3D() throws lvThrowable {
        x3pContent x3pContent2 = this.NewX3D();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(512, x3pContent2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pContent2.content = x3pElementArray;
        return x3pContent2;
    }

    protected final x3pElement PsElmScene() throws lvThrowable {
        x3pContent x3pContent2 = this.NewScene();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(513, x3pContent2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pContent2.content = x3pElementArray;
        return x3pContent2;
    }

    protected final x3pElement PsElmTransform() throws lvThrowable {
        Object object;
        x3pTransform x3pTransform2 = this.NewTransform();
        x3pUseElm x3pUseElm2 = this.NewUseElm(258);
        boolean bl = false;
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                if (bl) {
                    return x3pUseElm2;
                }
                return elmEmpty;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 769) {
                this.SkipToken(3);
                this.PsSfVec3f(x3pTransform2.translation);
                this.GetToken();
                continue;
            }
            if (this.id == 770) {
                this.SkipToken(3);
                this.PsSfRotation(x3pTransform2.rotation);
                this.GetToken();
                continue;
            }
            if (this.id == 768) {
                this.SkipToken(3);
                this.PsSfVec3f(x3pTransform2.scale);
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                object = this.lexer.GetStringToken();
                this.xmlIdTable.put(object, x3pTransform2);
                this.GetToken();
                continue;
            }
            if (this.id == 772) {
                this.SkipToken(2);
                x3pUseElm2.use = this.lexer.GetStringToken();
                bl = true;
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        object = this.PsMfElement(514, x3pTransform2.defContType);
        if (bl) {
            return x3pUseElm2;
        }
        if (object == null) {
            return null;
        }
        if (((x3pElement[])object).length == 0) {
            return elmEmpty;
        }
        x3pTransform2.content = object;
        return x3pTransform2;
    }

    protected final x3pElement PsElmXvlShape() throws lvThrowable {
        x3pXvlShape x3pXvlShape2 = this.NewXvlShape();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 773) {
                this.SkipToken(3);
                if (this.id == 1028) {
                    x3pXvlShape2.typeXvlShape = 2;
                } else if (this.id == 1029) {
                    x3pXvlShape2.typeXvlShape = 3;
                } else if (this.id == 1030) {
                    x3pXvlShape2.typeXvlShape = 4;
                } else {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                this.lexer.GetStringToken();
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(515, x3pXvlShape2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pXvlShape2.content = x3pElementArray;
        return x3pXvlShape2;
    }

    protected final x3pElement PsElmXvlFaces() throws lvThrowable {
        x3pContent x3pContent2 = this.NewXvlFaces();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(516, x3pContent2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pContent2.content = x3pElementArray;
        return x3pContent2;
    }

    protected final x3pElement PsElmXvlEdges() throws lvThrowable {
        x3pContent x3pContent2 = this.NewXvlEdges();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(517, x3pContent2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pContent2.content = x3pElementArray;
        return x3pContent2;
    }

    protected final x3pElement PsElmXvlVertices() throws lvThrowable {
        x3pContent x3pContent2 = this.NewXvlVertices();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return elmEmpty;
            }
            if (this.id == 260) break;
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(518, x3pContent2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pContent2.content = x3pElementArray;
        return x3pContent2;
    }

    protected final x3pElement PsElmXvlFace() throws lvThrowable {
        Object[] objectArray;
        x3pXvlFace x3pXvlFace2 = this.NewXvlFace();
        int n = Integer.MIN_VALUE;
        int[] nArray = null;
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                this.PsElmXvlFaceTexCoordIndex(x3pXvlFace2, n, nArray);
                return x3pXvlFace2;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 774) {
                this.SkipToken(3);
                objectArray = this.PsMfIntForAtt();
                n = objectArray.length;
                if (objectArray.length < 3) {
                    this.AssertSyntaxError(false);
                } else if (objectArray[objectArray.length - 1] == -1 && objectArray.length < 4) {
                    this.AssertSyntaxError(false);
                } else if (objectArray[objectArray.length - 1] != -1) {
                    int[] nArray2 = new int[objectArray.length + 1];
                    for (int i = 0; i < objectArray.length; ++i) {
                        nArray2[i] = objectArray[i];
                    }
                    nArray2[objectArray.length] = -1;
                    objectArray = nArray2;
                }
                x3pXvlFace2.coordIndex = objectArray;
                this.GetToken();
                continue;
            }
            if (this.id == 775) {
                this.SkipToken(2);
                this.lexer.GetStringToken();
                this.GetToken();
                x3pXvlFace2.empty = true;
                continue;
            }
            if (this.id == 776) {
                this.SkipToken(3);
                nArray = this.PsMfIntForAtt();
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                this.lexer.GetStringToken();
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.PsElmXvlFaceTexCoordIndex(x3pXvlFace2, n, nArray);
        objectArray = this.PsMfElement(519, x3pXvlFace2.defContType);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return elmEmpty;
        }
        x3pXvlFace2.content = (x3pElement[])objectArray;
        return x3pXvlFace2;
    }

    private final void PsElmXvlFaceTexCoordIndex(x3pXvlFace x3pXvlFace2, int n, int[] nArray) throws lvThrowable {
        if (nArray != null) {
            this.AssertSyntaxError(nArray.length == n);
            if (x3pXvlFace2.coordIndex.length == n + 1) {
                int[] nArray2 = new int[nArray.length + 1];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = nArray[i];
                }
                nArray2[nArray.length] = -1;
                nArray = nArray2;
            }
            x3pXvlFace2.texCoordIndex = nArray;
        }
    }

    protected final x3pElement PsElmXvlEdge() throws lvThrowable {
        Object[] objectArray;
        x3pXvlEdge x3pXvlEdge2 = this.NewXvlEdge();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return x3pXvlEdge2;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 774) {
                this.SkipToken(3);
                objectArray = this.PsMfIntForAtt();
                this.AssertSyntaxError(objectArray.length == 2);
                x3pXvlEdge2.coordIndex = (int[])objectArray;
                this.GetToken();
                continue;
            }
            if (this.id == 778) {
                this.SkipToken(3);
                x3pXvlEdge2.roundingWeight = this.PsSfFloat();
                this.GetToken();
                continue;
            }
            if (this.id == 777) {
                this.SkipToken(3);
                objectArray = this.PsMfIntForAtt();
                this.AssertSyntaxError(objectArray.length == 2);
                x3pXvlEdge2.vectorStartEnd = (int[])objectArray;
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                this.lexer.GetStringToken();
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        objectArray = this.PsMfElement(520, x3pXvlEdge2.defContType);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return elmEmpty;
        }
        x3pXvlEdge2.content = objectArray;
        return x3pXvlEdge2;
    }

    protected final x3pElement PsElmXvlVertex() throws lvThrowable {
        x3pXvlVertex x3pXvlVertex2 = this.NewXvlVertex();
        while (true) {
            if (this.id == 264) {
                this.GetToken();
                this.AssertSyntaxError(this.id == 260);
                return x3pXvlVertex2;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 774) {
                this.SkipToken(3);
                x3pXvlVertex2.coordIndex = this.PsSfInt();
                this.GetToken();
                continue;
            }
            if (this.id == 778) {
                this.SkipToken(3);
                x3pXvlVertex2.roundingWeight = this.PsSfFloat();
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                this.lexer.GetStringToken();
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        x3pElement[] x3pElementArray = this.PsMfElement(521, x3pXvlVertex2.defContType);
        if (x3pElementArray == null) {
            return null;
        }
        if (x3pElementArray.length == 0) {
            return elmEmpty;
        }
        x3pXvlVertex2.content = x3pElementArray;
        return x3pXvlVertex2;
    }

    protected final x3pElement PsElmMaterial() throws lvThrowable {
        x3pMaterial x3pMaterial2 = this.NewMaterial();
        x3pUseElm x3pUseElm2 = this.NewUseElm(266);
        boolean bl = false;
        while (true) {
            if (this.id == 264) break;
            if (this.id == 260) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 780) {
                this.SkipToken(3);
                x3pMaterial2.ambientIntensity = this.PsSfFloat();
                this.GetToken();
                continue;
            }
            if (this.id == 781) {
                this.SkipToken(3);
                this.PsSfColor(x3pMaterial2.diffuseColor);
                this.GetToken();
                continue;
            }
            if (this.id == 782) {
                this.SkipToken(3);
                this.PsSfColor(x3pMaterial2.emissiveColor);
                this.GetToken();
                continue;
            }
            if (this.id == 783) {
                this.SkipToken(3);
                x3pMaterial2.shininess = this.PsSfFloat();
                this.GetToken();
                continue;
            }
            if (this.id == 784) {
                this.SkipToken(3);
                this.PsSfColor(x3pMaterial2.specularColor);
                this.GetToken();
                continue;
            }
            if (this.id == 785) {
                this.SkipToken(3);
                x3pMaterial2.transparency = this.PsSfFloat();
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                String string = this.lexer.GetStringToken();
                this.xmlIdTable.put(string, x3pMaterial2);
                this.GetToken();
                continue;
            }
            if (this.id == 772) {
                this.SkipToken(2);
                x3pUseElm2.use = this.lexer.GetStringToken();
                bl = true;
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.AssertSyntaxError(this.id == 260);
        if (bl) {
            return x3pUseElm2;
        }
        return x3pMaterial2;
    }

    protected final x3pElement PsElmImageTexture() throws lvThrowable {
        x3pImageTexture x3pImageTexture2 = this.NewImageTexture();
        x3pUseElm x3pUseElm2 = this.NewUseElm(267);
        boolean bl = false;
        while (true) {
            if (this.id == 264) break;
            if (this.id == 260) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 786) {
                this.SkipToken(2);
                x3pImageTexture2.url = this.lexer.GetStringToken();
                this.GetToken();
                continue;
            }
            if (this.id == 787) {
                this.SkipToken(3);
                x3pImageTexture2.repeatS = this.PsSfBool();
                this.GetToken();
                continue;
            }
            if (this.id == 788) {
                this.SkipToken(3);
                x3pImageTexture2.repeatT = this.PsSfBool();
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                String string = this.lexer.GetStringToken();
                this.xmlIdTable.put(string, x3pImageTexture2);
                this.GetToken();
                continue;
            }
            if (this.id == 772) {
                this.SkipToken(2);
                x3pUseElm2.use = this.lexer.GetStringToken();
                bl = true;
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.AssertSyntaxError(this.id == 260);
        if (bl) {
            return x3pUseElm2;
        }
        return x3pImageTexture2;
    }

    protected final x3pElement PsElmCoordinate() throws lvThrowable {
        x3pCoordinate x3pCoordinate2 = this.NewCoordinate();
        x3pUseElm x3pUseElm2 = this.NewUseElm(268);
        boolean bl = false;
        while (true) {
            Object object;
            if (this.id == 264) break;
            if (this.id == 260) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 790) {
                this.SkipToken(3);
                object = this.PsMfVec3fForAtt();
                if (object == null) {
                    return null;
                }
                if (((x3pFieldVec3f[])object).length == 0) {
                    return elmEmpty;
                }
                x3pCoordinate2.data = object;
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                object = this.lexer.GetStringToken();
                this.xmlIdTable.put(object, x3pCoordinate2);
                this.GetToken();
                continue;
            }
            if (this.id == 772) {
                this.SkipToken(2);
                x3pUseElm2.use = this.lexer.GetStringToken();
                bl = true;
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.AssertSyntaxError(this.id == 260);
        if (bl) {
            return x3pUseElm2;
        }
        return x3pCoordinate2;
    }

    protected final x3pElement PsElmTextureCoordinate() throws lvThrowable {
        x3pTextureCoordinate x3pTextureCoordinate2 = this.NewTextureCoordinate();
        x3pUseElm x3pUseElm2 = this.NewUseElm(269);
        boolean bl = false;
        while (true) {
            Object object;
            if (this.id == 264) break;
            if (this.id == 260) {
                this.AssertSyntaxError(false);
                continue;
            }
            if (this.id == 790) {
                this.SkipToken(3);
                object = this.PsMfUVForAtt();
                if (object == null) {
                    return null;
                }
                if (((x3pFieldUV[])object).length == 0) {
                    return elmEmpty;
                }
                x3pTextureCoordinate2.data = object;
                this.GetToken();
                continue;
            }
            if (this.id == 771) {
                this.SkipToken(2);
                object = this.lexer.GetStringToken();
                this.xmlIdTable.put(object, x3pTextureCoordinate2);
                this.GetToken();
                continue;
            }
            if (this.id == 772) {
                this.SkipToken(2);
                x3pUseElm2.use = this.lexer.GetStringToken();
                bl = true;
                this.GetToken();
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        this.AssertSyntaxError(this.id == 260);
        if (bl) {
            return x3pUseElm2;
        }
        return x3pTextureCoordinate2;
    }

    protected x3pContent NewX3D() {
        int[] nArray = new int[]{1};
        return new x3pContent(0, nArray);
    }

    protected x3pContent NewScene() {
        int[] nArray = new int[]{2, 3};
        return new x3pContent(1, nArray);
    }

    protected x3pTransform NewTransform() {
        return new x3pTransform();
    }

    protected x3pXvlShape NewXvlShape() {
        return new x3pXvlShape();
    }

    protected x3pContent NewXvlFaces() {
        int[] nArray = new int[]{12, 13, 10, 11, 7};
        return new x3pContent(4, nArray);
    }

    protected x3pContent NewXvlEdges() {
        int[] nArray = new int[]{12, 10, 8};
        return new x3pContent(5, nArray);
    }

    protected x3pContent NewXvlVertices() {
        int[] nArray = new int[]{12, 10, 9};
        return new x3pContent(6, nArray);
    }

    protected x3pXvlFace NewXvlFace() {
        return new x3pXvlFace();
    }

    protected x3pXvlEdge NewXvlEdge() {
        return new x3pXvlEdge();
    }

    protected x3pXvlVertex NewXvlVertex() {
        return new x3pXvlVertex();
    }

    protected x3pMaterial NewMaterial() {
        return new x3pMaterial();
    }

    protected x3pImageTexture NewImageTexture() {
        return new x3pImageTexture();
    }

    protected x3pCoordinate NewCoordinate() {
        return new x3pCoordinate();
    }

    protected x3pTextureCoordinate NewTextureCoordinate() {
        return new x3pTextureCoordinate();
    }

    protected x3pUseElm NewUseElm(int n) {
        return new x3pUseElm(n);
    }

    protected final x3pElement[] PsMfElement(int n, int[] nArray) throws lvThrowable {
        int n2;
        int n3 = 32;
        int n4 = 0;
        x3pElement[] x3pElementArray = new x3pElement[n3];
        while (true) {
            int n5 = Integer.MIN_VALUE;
            boolean bl = false;
            while (true) {
                if (this.id == 259) {
                    this.GetToken();
                    if (this.id == 264) {
                        this.GetToken();
                        if (this.id == n) {
                            this.SkipTag();
                            bl = true;
                            break;
                        }
                    } else if (this.lexer.IsElement(this.id) && this.ChkDefContType(this.id, nArray)) {
                        n5 = this.id;
                        this.GetToken();
                        break;
                    }
                } else if (this.id == 0) {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
            }
            if (bl) break;
            x3pElement x3pElement2 = this.PsElement(n5);
            this.AssertSyntaxError(x3pElement2.type != 64);
            x3pElementArray[n4] = x3pElement2;
            if (++n4 >= n3) {
                x3pElement[] x3pElementArray2 = new x3pElement[n3 + 32];
                for (n2 = 0; n2 < n4; ++n2) {
                    x3pElementArray2[n2] = x3pElementArray[n2];
                }
                x3pElementArray = x3pElementArray2;
                n3 += 32;
            }
            x3pElementArray[n4] = null;
        }
        if (n4 == 0) {
            x3pElement[] x3pElementArray3 = new x3pElement[]{};
            return x3pElementArray3;
        }
        x3pElement[] x3pElementArray4 = new x3pElement[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            x3pElementArray4[n2] = x3pElementArray[n2];
        }
        return x3pElementArray4;
    }

    protected final x3pFieldVec3f[] PsMfVec3fForAtt() throws lvThrowable {
        int n;
        int n2 = 32;
        int n3 = 0;
        x3pFieldVec3f[] x3pFieldVec3fArray = new x3pFieldVec3f[n2];
        while (true) {
            boolean bl = false;
            while (true) {
                if (this.id == 265) {
                    bl = true;
                    break;
                }
                if (this.id == 257 || this.id == 256) break;
                if (this.id == 0) {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
            }
            if (bl) break;
            x3pFieldVec3fArray[n3] = new x3pFieldVec3f();
            this.PsSfVec3f(x3pFieldVec3fArray[n3]);
            if (++n3 >= n2) {
                x3pFieldVec3f[] x3pFieldVec3fArray2 = new x3pFieldVec3f[n2 + 32];
                for (n = 0; n < n3; ++n) {
                    x3pFieldVec3fArray2[n] = x3pFieldVec3fArray[n];
                }
                x3pFieldVec3fArray = x3pFieldVec3fArray2;
                n2 += 32;
            }
            x3pFieldVec3fArray[n3] = null;
            if (this.id != 261) continue;
            this.GetToken();
        }
        if (n3 == 0) {
            x3pFieldVec3f[] x3pFieldVec3fArray3 = new x3pFieldVec3f[]{};
            return x3pFieldVec3fArray3;
        }
        x3pFieldVec3f[] x3pFieldVec3fArray4 = new x3pFieldVec3f[n3];
        for (n = 0; n < n3; ++n) {
            x3pFieldVec3fArray4[n] = x3pFieldVec3fArray[n];
        }
        return x3pFieldVec3fArray4;
    }

    protected final x3pFieldUV[] PsMfUVForAtt() throws lvThrowable {
        int n;
        int n2 = 32;
        int n3 = 0;
        x3pFieldUV[] x3pFieldUVArray = new x3pFieldUV[n2];
        while (true) {
            boolean bl = false;
            while (true) {
                if (this.id == 265) {
                    bl = true;
                    break;
                }
                if (this.id == 257 || this.id == 256) break;
                if (this.id == 0) {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
            }
            if (bl) break;
            x3pFieldUVArray[n3] = new x3pFieldUV();
            this.PsSfUV(x3pFieldUVArray[n3]);
            if (++n3 >= n2) {
                x3pFieldUV[] x3pFieldUVArray2 = new x3pFieldUV[n2 + 32];
                for (n = 0; n < n3; ++n) {
                    x3pFieldUVArray2[n] = x3pFieldUVArray[n];
                }
                x3pFieldUVArray = x3pFieldUVArray2;
                n2 += 32;
            }
            x3pFieldUVArray[n3] = null;
            if (this.id != 261) continue;
            this.GetToken();
        }
        if (n3 == 0) {
            x3pFieldUV[] x3pFieldUVArray3 = new x3pFieldUV[]{};
            return x3pFieldUVArray3;
        }
        x3pFieldUV[] x3pFieldUVArray4 = new x3pFieldUV[n3];
        for (n = 0; n < n3; ++n) {
            x3pFieldUVArray4[n] = x3pFieldUVArray[n];
        }
        return x3pFieldUVArray4;
    }

    protected final int[] PsMfIntForAtt() throws lvThrowable {
        int n;
        int n2 = 32;
        int n3 = 0;
        int[] nArray = new int[n2];
        while (true) {
            boolean bl = false;
            while (true) {
                if (this.id == 265) {
                    bl = true;
                    break;
                }
                if (this.id == 256) break;
                if (this.id == 0) {
                    this.AssertSyntaxError(false);
                }
                this.GetToken();
            }
            if (bl) break;
            nArray[n3] = this.lexer.GetIntValue();
            if (++n3 >= n2) {
                int[] nArray2 = new int[n2 + 32];
                for (n = 0; n < n3; ++n) {
                    nArray2[n] = nArray[n];
                }
                nArray = nArray2;
                n2 += 32;
            }
            nArray[n3] = 0;
            this.GetToken();
        }
        if (n3 == 0) {
            int[] nArray3 = new int[]{};
            return nArray3;
        }
        int[] nArray4 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray4[n] = nArray[n];
        }
        return nArray4;
    }

    protected final void PsSfVec3f(x3pFieldVec3f x3pFieldVec3f2) throws lvThrowable {
        if (this.id == 256 || this.id == 257) {
            x3pFieldVec3f2.x = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldVec3f2.y = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldVec3f2.z = this.lexer.GetFloatValue();
        }
        this.GetToken();
    }

    protected final void PsSfRotation(x3pFieldRotation x3pFieldRotation2) throws lvThrowable {
        if (this.id == 256 || this.id == 257) {
            x3pFieldRotation2.x = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldRotation2.y = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldRotation2.z = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldRotation2.r = this.lexer.GetFloatValue();
        }
        this.GetToken();
    }

    protected final void PsSfUV(x3pFieldUV x3pFieldUV2) throws lvThrowable {
        if (this.id == 256 || this.id == 257) {
            x3pFieldUV2.u = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldUV2.v = this.lexer.GetFloatValue();
        }
        this.GetToken();
    }

    protected final boolean PsSfBool() throws lvThrowable {
        if (this.id == 1025) {
            this.GetToken();
            return true;
        }
        if (this.id == 1024) {
            this.GetToken();
            return false;
        }
        this.AssertSyntaxError(false);
        return false;
    }

    protected final int PsSfInt() throws lvThrowable {
        this.AssertSyntaxError(this.id == 256);
        int n = this.lexer.GetIntValue();
        this.GetToken();
        return n;
    }

    protected final double PsSfFloat() throws lvThrowable {
        this.AssertSyntaxError(this.id == 256 || this.id == 257);
        double d = this.lexer.GetFloatValue();
        this.GetToken();
        return d;
    }

    protected final void PsSfColor(x3pFieldColor x3pFieldColor2) throws lvThrowable {
        if (this.id == 256 || this.id == 257) {
            x3pFieldColor2.r = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldColor2.g = this.lexer.GetFloatValue();
        }
        this.GetToken();
        if (this.id == 256 || this.id == 257) {
            x3pFieldColor2.b = this.lexer.GetFloatValue();
        }
        this.GetToken();
    }

    protected final char[] PsSfCharForContent(int n) throws lvThrowable {
        int n2;
        int n3;
        int n4 = 1024;
        int n5 = 0;
        byte[] byArray = null;
        char[] cArray = new char[n4];
        while ((n3 = this.lexer.ReadBase64Line()) != 0) {
            byArray = this.lexer.GetBase64Line();
            if (n5 + n3 > n4) {
                n4 = n5 + n3 + 1024;
                char[] cArray2 = new char[n4];
                for (n2 = 0; n2 < n5; ++n2) {
                    cArray2[n2] = cArray[n2];
                }
                cArray = cArray2;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n5 + n2] = (char)byArray[n2];
            }
            n5 += n3;
        }
        this.AssertSyntaxError(n5 > 0);
        boolean bl = false;
        this.GetToken();
        if (this.id == 259) {
            this.GetToken();
            if (this.id == 264) {
                this.GetToken();
                if (this.id == n) {
                    this.SkipTag();
                    bl = true;
                }
            }
        }
        this.AssertSyntaxError(bl);
        char[] cArray3 = new char[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            cArray3[n2] = cArray[n2];
        }
        return cArray3;
    }

    protected final boolean SkipTag() throws lvThrowable {
        while (true) {
            if (this.id == 259) {
                this.GetToken();
                this.SkipTag();
                continue;
            }
            if (this.id == 260) break;
            if (this.id == 0) {
                this.AssertSyntaxError(false);
                continue;
            }
            this.GetToken();
        }
        this.GetToken();
        return false;
    }

    protected final boolean SkipBlockForWord(int n) throws lvThrowable {
        Boolean bl = null;
        boolean bl2 = this.SkipTagAndChkEmpty(bl);
        if (bl2) {
            return true;
        }
        if (bl.booleanValue()) {
            return false;
        }
        int n2 = 1;
        while (true) {
            if (this.id == 259) {
                this.GetToken();
                if (this.id == n) {
                    bl2 = this.SkipTagAndChkEmpty(bl);
                    if (bl2) {
                        return true;
                    }
                    if (!bl.booleanValue()) {
                        ++n2;
                    }
                } else if (this.id == 264) {
                    this.GetToken();
                    if (this.id == n) {
                        --n2;
                    }
                }
            } else if (this.id == 0) {
                this.AssertSyntaxError(false);
            }
            if (n2 == 0) break;
            this.GetToken();
        }
        this.SkipTag();
        return false;
    }

    protected final boolean SkipBlockForUnknown(String string) throws lvThrowable {
        Boolean bl = null;
        boolean bl2 = this.SkipTagAndChkEmpty(bl);
        if (bl2) {
            return true;
        }
        if (bl.booleanValue()) {
            return false;
        }
        int n = 1;
        while (true) {
            if (this.id == 259) {
                this.GetToken();
                String string2 = this.lexer.GetUnknown();
                if (string.equalsIgnoreCase(string2)) {
                    bl2 = this.SkipTagAndChkEmpty(bl);
                    if (bl2) {
                        return true;
                    }
                    if (!bl.booleanValue()) {
                        ++n;
                    }
                } else if (this.id == 264) {
                    this.GetToken();
                    string2 = this.lexer.GetUnknown();
                    if (string.equalsIgnoreCase(string2)) {
                        --n;
                    }
                }
            } else if (this.id == 0) {
                this.AssertSyntaxError(false);
            }
            if (n == 0) break;
            this.GetToken();
        }
        this.SkipTag();
        return false;
    }

    protected final boolean SkipTagAndChkEmpty(Boolean bl) throws lvThrowable {
        boolean bl2 = false;
        while (true) {
            if (this.id == 264) {
                bl2 = true;
            } else if (this.id == 259) {
                this.GetToken();
                this.SkipTag();
            } else {
                if (this.id == 260) break;
                if (this.id == 0) {
                    return true;
                }
                bl2 = false;
            }
            this.GetToken();
        }
        this.GetToken();
        bl = !bl2 ? boolFalse : boolTrue;
        return false;
    }

    protected final boolean ChkDefContType(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        int n2 = this.GetElementType(n);
        if (n2 == 64) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    protected final int GetElementType(int n) {
        switch (n) {
            case 512: {
                return 0;
            }
            case 513: {
                return 1;
            }
            case 514: {
                return 2;
            }
            case 515: {
                return 3;
            }
            case 516: {
                return 4;
            }
            case 517: {
                return 5;
            }
            case 518: {
                return 6;
            }
            case 519: {
                return 7;
            }
            case 520: {
                return 8;
            }
            case 521: {
                return 9;
            }
            case 522: {
                return 10;
            }
            case 523: {
                return 11;
            }
            case 524: {
                return 12;
            }
            case 525: {
                return 13;
            }
        }
        return 64;
    }

    private final void AssertSyntaxError(boolean bl) throws lvThrowable {
        this.lexer.AssertEx(bl, "Syntax Error!");
    }
}

