/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.tex.a0g;

import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvUVdt;
import jp.co.lattice.vKernel.greg.c0g.lvDivFaceType;
import jp.co.lattice.vKernel.greg.c0g.lvDivFaceUVtype;
import jp.co.lattice.vKernel.tex.a0g.lv0AttGGblElm;
import jp.co.lattice.vKernel.tex.a0g.lvTessellateUV;

public class lv0TessellateUV
extends lvTessellateUV {
    private static final int maxNumVertex = 256;
    private static final int maxNumUVspaceOfs = 256;

    private final Global Gbl() {
        return ((lv0AttGGblElm)this.global.GAttG()).gTessellateUV;
    }

    private final lvDivFaceType.DownDivFace DownDivFace() {
        return this.Gbl().downDivFace;
    }

    private final lvDivFaceType.DeriveDivFace DeriveDivFace() {
        return this.Gbl().deriveDivFace;
    }

    private final lvDivFaceType.UpDivFace UpDivFace() {
        return this.Gbl().upDivFace;
    }

    private final lvDivFaceUVtype.DownDivFaceUV DownDivFaceUV() {
        return this.Gbl().downDivFaceUV;
    }

    private final lvDivFaceUVtype.UpDivFaceUV UpDivFaceUV() {
        return this.Gbl().upDivFaceUV;
    }

    private final lvTessellateUV.DownTessellateUV DownTessUV() {
        return this.Gbl().downTessUV;
    }

    private final lvTessellateUV.UpTessellateUV UpTessUV() {
        return this.Gbl().upTessUV;
    }

    public lv0TessellateUV(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public void Init(lvDivFaceType.DownDivFace downDivFace, lvDivFaceType.DeriveDivFace deriveDivFace, lvDivFaceType.UpDivFace upDivFace, lvTessellateUV.DownTessellateUV downTessellateUV, lvTessellateUV.UpTessellateUV upTessellateUV) {
        this.Gbl().downDivFace = downDivFace;
        this.Gbl().deriveDivFace = deriveDivFace;
        this.Gbl().upDivFace = upDivFace;
        this.Gbl().downDivFaceUV = downDivFace.divFaceUV;
        this.Gbl().upDivFaceUV = upDivFace.divFaceUV;
        this.Gbl().downTessUV = downTessellateUV;
        this.Gbl().upTessUV = upTessellateUV;
    }

    public void NewUpDivFaceUV(int n) {
        this.UpDivFaceUV().uvSpace = null;
        if (this.DownDivFaceUV().uvSpace == null) {
            return;
        }
        int n2 = this.DownDivFaceUV().uvSpace.length;
        this.UpDivFaceUV().uvSpace = new lvDivFaceUVtype.UpDivFaceUVone[n2];
        for (int i = 0; i < n2; ++i) {
            this.UpDivFaceUV().uvSpace[i] = new lvDivFaceUVtype.UpDivFaceUVone();
            this.UpDivFaceUV().uvSpace[i].uv = new lvUVdt[n];
            for (int j = 0; j < n; ++j) {
                this.UpDivFaceUV().uvSpace[i].uv[j] = new lvUVdt();
            }
        }
    }

    public void NewUpTessellateUV(lvRec.SeqPart seqPart) {
        int n;
        this.UpTessUV().uvSpace = null;
        if (this.UpDivFaceUV().uvSpace == null) {
            return;
        }
        if (this.UpDivFaceUV().uvSpace.length > 1) {
            this.UpTessUV().uvSpace = new lvTessellateUV.UpTessellateUVone[this.UpDivFaceUV().uvSpace.length];
            for (n = 0; n < this.UpDivFaceUV().uvSpace.length; ++n) {
                this.UpTessUV().uvSpace[n] = new lvTessellateUV.UpTessellateUVone();
            }
        } else {
            this.UpTessUV().uvSpace = this.Gbl().staticUpUVspace;
        }
        for (n = 0; n < this.UpDivFaceUV().uvSpace.length; ++n) {
            this.UpTessUV().uvSpace[n].uv = n >= 1 ? new lvUVdt[seqPart.num] : (seqPart.num > 256 ? new lvUVdt[seqPart.num] : this.Gbl().staticUV);
            for (int i = 0; i < seqPart.num; ++i) {
                this.UpTessUV().uvSpace[n].uv[i] = this.UpDivFaceUV().uvSpace[n].uv[seqPart.start + i];
            }
        }
    }

    public void SetQuad() {
        this.DownTessUV().uvSpace = null;
        if (this.DownDivFaceUV().uvSpace == null) {
            return;
        }
        this.NewDownTessUV();
        for (int i = 0; i < this.DownDivFaceUV().uvSpace.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                lvUVdt.Copy(this.DownDivFaceUV().uvSpace[i].vtxUV[j], this.DownTessUV().uvSpace[i].uv[j]);
            }
        }
    }

    private final void NewDownTessUV() {
        if (this.DownDivFaceUV().uvSpace == null) {
            this.DownTessUV().numUVspace = 0;
            return;
        }
        this.DownTessUV().numUVspace = this.DownDivFaceUV().uvSpace.length;
        if (this.DownDivFaceUV().uvSpace.length > 256) {
            int n;
            this.DownTessUV().uvSpace = new lvTessellateUV.DownTessellateUVone[this.DownDivFaceUV().uvSpace.length];
            for (n = 0; n < 256; ++n) {
                this.DownTessUV().uvSpace[n] = this.Gbl().staticDownUVspace[n];
            }
            for (n = 256; n < this.DownDivFaceUV().uvSpace.length; ++n) {
                this.DownTessUV().uvSpace[n] = new lvTessellateUV.DownTessellateUVone();
            }
        } else {
            this.DownTessUV().uvSpace = this.Gbl().staticDownUVspace;
        }
    }

    public void SetGtQuad(int n, int n2) throws lvThrowable {
        this.DownTessUV().uvSpace = null;
        if (this.DownDivFaceUV().uvSpace == null) {
            return;
        }
        this.NewDownTessUV();
        for (int i = 0; i < this.DownDivFaceUV().uvSpace.length; ++i) {
            this.SetGtQuadStd(i, n, n2);
        }
    }

    private final void SetGtQuadStd(int n, int n2, int n3) throws lvThrowable {
        int n4 = (n2 + 1) % n3;
        this.SetGtQuadInner(n, n2, this.DownTessUV().uvSpace[n].uv[0], true);
        this.SetGtQuadOuter(n, n2, this.DownTessUV().uvSpace[n].uv[1], true);
        this.SetGtQuadOuter(n, n4, this.DownTessUV().uvSpace[n].uv[2], false);
        this.SetGtQuadInner(n, n4, this.DownTessUV().uvSpace[n].uv[3], false);
    }

    private final void SetGtQuadInner(int n, int n2, lvUVdt lvUVdt2, boolean bl) {
        int n3 = (n2 + 1) % this.DownDivFace().numHalf;
        lvUVdt lvUVdt3 = this.Gbl().tuSetGtQuadInner[0];
        lvUVdt lvUVdt4 = this.Gbl().tuSetGtQuadInner[1];
        if (!bl) {
            lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].vtxUV[n2], lvUVdt3);
            lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].vtxUV[n3], lvUVdt4);
            lvUVdt2.u = (lvUVdt3.u + lvUVdt4.u) / 2.0;
            lvUVdt2.v = (lvUVdt3.v + lvUVdt4.v) / 2.0;
        } else {
            lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].center, lvUVdt2);
        }
    }

    private final void SetGtQuadOuter(int n, int n2, lvUVdt lvUVdt2, boolean bl) throws lvThrowable {
        if (!bl) {
            this.SetGtQuadOuterFirst(n, n2, lvUVdt2);
        } else {
            this.SetGtQuadOuterLast(n, n2, lvUVdt2);
        }
    }

    private final void SetGtQuadOuterFirst(int n, int n2, lvUVdt lvUVdt2) {
        lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].vtxUV[n2], lvUVdt2);
    }

    private final void SetGtQuadOuterLast(int n, int n2, lvUVdt lvUVdt2) {
        int n3 = (n2 + 1) % this.DownDivFace().numHalf;
        lvUVdt lvUVdt3 = this.Gbl().tuSetGtQuadOuterLast[0];
        lvUVdt lvUVdt4 = this.Gbl().tuSetGtQuadOuterLast[1];
        lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].vtxUV[n2], lvUVdt3);
        lvUVdt.Copy(this.DownDivFaceUV().uvSpace[n].vtxUV[n3], lvUVdt4);
        lvUVdt2.u = (lvUVdt3.u + lvUVdt4.u) / 2.0;
        lvUVdt2.v = (lvUVdt3.v + lvUVdt4.v) / 2.0;
    }

    public void Finish() {
        this.UpTessUV().uvSpace = null;
    }

    public static class Global {
        lvDivFaceType.DownDivFace downDivFace = null;
        lvDivFaceType.DeriveDivFace deriveDivFace = null;
        lvDivFaceType.UpDivFace upDivFace = null;
        lvDivFaceUVtype.DownDivFaceUV downDivFaceUV = null;
        lvDivFaceUVtype.UpDivFaceUV upDivFaceUV = null;
        lvTessellateUV.DownTessellateUV downTessUV = null;
        lvTessellateUV.UpTessellateUV upTessUV = null;
        private lvUVdt[] tuSetGtQuadInner = null;
        private lvUVdt[] tuSetGtQuadOuterLast = null;
        private lvTessellateUV.DownTessellateUVone[] staticDownUVspace = null;
        private lvTessellateUV.UpTessellateUVone[] staticUpUVspace = null;
        private lvUVdt[] staticUV = new lvUVdt[256];

        public Global(lvGlobal lvGlobal2) {
            this.GlobalTmp(lvGlobal2);
            this.GlobalStatic();
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tuSetGtQuadInner = new lvUVdt[4];
            for (n = 0; n < 4; ++n) {
                this.tuSetGtQuadInner[n] = new lvUVdt();
            }
            this.tuSetGtQuadOuterLast = new lvUVdt[4];
            for (n = 0; n < 4; ++n) {
                this.tuSetGtQuadOuterLast[n] = new lvUVdt();
            }
        }

        private final void GlobalStatic() {
            this.staticDownUVspace = new lvTessellateUV.DownTessellateUVone[256];
            for (int i = 0; i < 256; ++i) {
                this.staticDownUVspace[i] = new lvTessellateUV.DownTessellateUVone();
            }
            this.staticUpUVspace = new lvTessellateUV.UpTessellateUVone[1];
            this.staticUpUVspace[0] = new lvTessellateUV.UpTessellateUVone();
        }
    }
}

