/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.greg.g0g;

import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.greg.c0g.lvBezLine;
import jp.co.lattice.vKernel.greg.c0g.lvDivFaceType;
import jp.co.lattice.vKernel.greg.g0g.lv0GeomGGblElm;
import jp.co.lattice.vKernel.greg.g0g.lvDivFaceLow;
import jp.co.lattice.vKernel.greg.g0g.lvMakeCbd;
import jp.co.lattice.vKernel.greg.g0g.lvTessellateLow;
import jp.co.lattice.vKernel.tex.a0g.lv0AttGGblElm;
import jp.co.lattice.vKernel.tex.a0g.lv0TessellateUV;
import jp.co.lattice.vKernel.tex.a0g.lvTessellateUV;

public class lvTessellate
extends lvRoot {
    private static final int maxNumPatch = 256;
    private static final int maxNumVertex = 256;
    private static final int maxNumTriIndex = 256;

    private final Global Gbl() {
        return ((lv0GeomGGblElm)this.global.GGeomG()).gTessellate;
    }

    private final lvTessellateLow.DownTessellate DownTessellate() {
        return this.Gbl().downTessellate;
    }

    private final lvTessellateLow.UpTessellate UpTessellate() {
        return this.Gbl().upTessellate;
    }

    private final lvDivFaceType.DownDivFace DownDivFace() {
        return this.Gbl().curDownDivFace;
    }

    private final lvDivFaceType.DeriveDivFace DeriveDivFace() {
        return this.Gbl().curDeriveDivFace;
    }

    private final lvDivFaceType.UpDivFace UpDivFace() {
        return this.Gbl().curUpDivFace;
    }

    public lvTessellate(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public final void Exec(lvDivFaceType.DownDivFace downDivFace, lvDivFaceType.DeriveDivFace deriveDivFace, lvDivFaceType.UpDivFace upDivFace) throws lvThrowable {
        this.Gbl().curDownDivFace = downDivFace;
        this.Gbl().curDeriveDivFace = deriveDivFace;
        this.Gbl().curUpDivFace = upDivFace;
        this.NewTmpTessellate();
        this.SetPatchInfo();
        this.SeqPartUpDivFace();
        if (!this.Gbl().attGGblElm.IsDmy()) {
            this.Gbl().tessellateUV.Init(this.DownDivFace(), this.DeriveDivFace(), this.UpDivFace(), this.DownTessellate().uvInfo, this.UpTessellate().uvInfo);
        }
        this.NewUpDivFace();
        if (this.DownDivFace().numHalf == 4) {
            this.ExecQuad();
        } else {
            this.ExecMain();
        }
        this.Finish();
        if (!this.Gbl().attGGblElm.IsDmy()) {
            this.Gbl().tessellateUV.Finish();
        }
    }

    private final void NewTmpTessellate() {
        int n = this.DownDivFace().numHalf == 4 ? 1 : this.DownDivFace().numHalf;
        this.Gbl().tmpTessellate.numPatch = n;
        if (n > 256) {
            int n2;
            TmpTessellate.access$1102(this.Gbl().tmpTessellate, new TmpPatch[n]);
            for (n2 = 0; n2 < 256; ++n2) {
                ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n2] = this.Gbl().staticPatch[n2];
            }
            for (n2 = 256; n2 < n; ++n2) {
                ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n2] = new TmpPatch();
            }
        } else {
            TmpTessellate.access$1102(this.Gbl().tmpTessellate, this.Gbl().staticPatch);
        }
    }

    private final void SetPatchInfo() {
        if (this.DownDivFace().numHalf == 4) {
            ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[0].numDivU = this.DownDivFace().attr.numDiv;
            ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[0].numDivV = this.DownDivFace().attr.numDiv;
            return;
        }
        for (int i = 0; i < this.DownDivFace().numHalf; ++i) {
            ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i].numDivU = this.DownDivFace().attr.numDiv / 2;
            ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i].numDivV = this.DownDivFace().attr.numDiv / 2;
        }
    }

    private final void SeqPartUpDivFace() {
        this.SeqPartUpDivFaceVertex();
        this.SeqPartUpDivFaceTriIndex();
    }

    private final void SeqPartUpDivFaceVertex() {
        int n;
        for (n = 0; n < this.Gbl().tmpTessellate.numPatch; ++n) {
            lvRec.SeqPart seqPart = this.Gbl().tmpTessellate.patch[n].infoVertex;
            int n2 = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n].numDivU;
            int n3 = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n].numDivV;
            seqPart.num = lvTessellateLow.NumVertexStd(n2, n3);
        }
        n = 0;
        for (int i = 0; i < this.Gbl().tmpTessellate.numPatch; ++i) {
            ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i]).infoVertex.start = n;
            n += ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i]).infoVertex.num;
        }
    }

    private final void SeqPartUpDivFaceTriIndex() {
        int n;
        for (n = 0; n < this.Gbl().tmpTessellate.numPatch; ++n) {
            lvRec.SeqPart seqPart = this.Gbl().tmpTessellate.patch[n].infoTriIndex;
            int n2 = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n].numDivU;
            int n3 = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n].numDivV;
            seqPart.num = lvTessellateLow.NumTriIndexStd(n2, n3);
        }
        n = 0;
        for (int i = 0; i < this.Gbl().tmpTessellate.numPatch; ++i) {
            ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i]).infoTriIndex.start = n;
            n += ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i]).infoTriIndex.num;
        }
    }

    private final void NewUpDivFace() {
        this.NewUpDivFaceVertex();
        this.NewUpDivFaceTriIndex();
    }

    private final void NewUpDivFaceVertex() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.Gbl().tmpTessellate.numPatch; ++n) {
            n2 += ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n]).infoVertex.num;
        }
        this.UpDivFace().vertex = new lvRec.PosNorHi[n2];
        for (n = 0; n < n2; ++n) {
            this.UpDivFace().vertex[n] = new lvRec.PosNorHi(this.global);
        }
        if (!this.Gbl().attGGblElm.IsDmy()) {
            this.Gbl().tessellateUV.NewUpDivFaceUV(n2);
        }
    }

    private final void NewUpDivFaceTriIndex() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.Gbl().tmpTessellate.numPatch; ++n) {
            n2 += ((TmpPatch)((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[n]).infoTriIndex.num;
        }
        this.UpDivFace().triIndex = new lvRec.TriIndex[n2];
        for (n = 0; n < n2; ++n) {
            this.UpDivFace().triIndex[n] = new lvRec.TriIndex();
        }
    }

    private final void ExecQuad() throws lvThrowable {
        int n;
        this.NewUpTessellate(0);
        this.DownTessellate().numDivU = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[0].numDivU;
        this.DownTessellate().numDivV = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[0].numDivV;
        for (n = 0; n < 4; ++n) {
            this.DownTessellate().half[n].pos.Assign(this.DownDivFace().half[n].pos);
            for (int i = 0; i < 2; ++i) {
                this.DownTessellate().half[n].handVec[i].Assign(this.DownDivFace().half[n].handVec[i]);
            }
        }
        for (n = 0; n < 4; ++n) {
            this.GetBCbdOuter(n, this.DownTessellate().half[n].bCbd);
        }
        if (!this.Gbl().attGGblElm.IsDmy()) {
            this.Gbl().tessellateUV.SetQuad();
        }
        this.Gbl().tessellateLow.Exec(this.DownTessellate(), this.UpTessellate());
        this.CorrectTriIndexNo(0);
    }

    private final void NewUpTessellate(int n) {
        lvRec.SeqPart seqPart = this.Gbl().tmpTessellate.patch[n].infoVertex;
        this.NewUpTessellateVertex(seqPart);
        this.NewUpTessellateTriIndex(this.Gbl().tmpTessellate.patch[n].infoTriIndex);
        if (!this.Gbl().attGGblElm.IsDmy()) {
            this.Gbl().tessellateUV.NewUpTessellateUV(seqPart);
        }
    }

    private final void NewUpTessellateVertex(lvRec.SeqPart seqPart) {
        this.UpTessellate().numVertex = seqPart.num;
        this.UpTessellate().vertex = seqPart.num > 256 ? new lvRec.PosNorHi[seqPart.num] : this.Gbl().staticVertex;
        for (int i = 0; i < seqPart.num; ++i) {
            this.UpTessellate().vertex[i] = this.UpDivFace().vertex[seqPart.start + i];
        }
    }

    private final void NewUpTessellateTriIndex(lvRec.SeqPart seqPart) {
        this.UpTessellate().numTriIndex = seqPart.num;
        this.UpTessellate().triIndex = seqPart.num > 256 ? new lvRec.TriIndex[seqPart.num] : this.Gbl().staticTriIndex;
        for (int i = 0; i < seqPart.num; ++i) {
            this.UpTessellate().triIndex[i] = this.UpDivFace().triIndex[seqPart.start + i];
        }
    }

    private final void GetBCbdOuter(int n, lvVector[] lvVectorArray) throws lvThrowable {
        lvMakeCbd.DownCbd downCbd = this.Gbl().tdGetBCbdOuter[0];
        lvMakeCbd.UpCbd upCbd = this.Gbl().tuGetBCbdOuter[0];
        this.SetDownCbdOuter(n, downCbd);
        this.Gbl().makeCbd.Exec(downCbd, upCbd);
        this.GetBCbdMain(downCbd, upCbd, lvVectorArray);
    }

    private final void SetDownCbdOuter(int n, lvMakeCbd.DownCbd downCbd) {
        int n2 = (n + this.DownDivFace().numHalf - 1) % this.DownDivFace().numHalf;
        int n3 = (n + 1) % this.DownDivFace().numHalf;
        int n4 = (n + 2) % this.DownDivFace().numHalf;
        downCbd.info[0].vtx.Assign(this.DownDivFace().half[n].pos);
        downCbd.info[1].vtx.Assign(this.DownDivFace().half[n3].pos);
        downCbd.info[0].cVec.Assign(this.DownDivFace().half[n].handVec[0]);
        downCbd.info[1].cVec.Assign(this.DownDivFace().half[n].handVec[1].Neg());
        downCbd.info[0].bCbd.Assign(this.DownDivFace().half[n2].handVec[1]);
        downCbd.info[1].bCbd.Assign(this.DownDivFace().half[n3].handVec[0]);
        downCbd.faceNormal.Assign(this.DownDivFace().center.normal);
        if (this.DownDivFace().numHalf == 3) {
            downCbd.antiCenter = this.Gbl().antiCenter;
            downCbd.antiCenter.Assign(this.DownDivFace().half[n2].pos);
            downCbd.info[0].antiVtx = this.Gbl().antiVtx0;
            downCbd.info[1].antiVtx = this.Gbl().antiVtx1;
            downCbd.info[0].antiVtx.Assign(downCbd.antiCenter);
            downCbd.info[1].antiVtx.Assign(downCbd.antiCenter);
        } else if (this.DownDivFace().numHalf == 4) {
            downCbd.antiCenter = this.Gbl().antiCenter;
            lvDivFaceLow.Position(n4, 0.5, downCbd.antiCenter);
            downCbd.info[0].antiVtx = this.Gbl().antiVtx0;
            downCbd.info[1].antiVtx = this.Gbl().antiVtx1;
            downCbd.info[0].antiVtx.Assign(this.DownDivFace().half[n2].pos);
            downCbd.info[1].antiVtx.Assign(this.DownDivFace().half[n4].pos);
        } else {
            downCbd.antiCenter = null;
            downCbd.info[0].antiVtx = null;
            downCbd.info[1].antiVtx = null;
        }
    }

    private final void GetBCbdMain(lvMakeCbd.DownCbd downCbd, lvMakeCbd.UpCbd upCbd, lvVector[] lvVectorArray) throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvGetBCbdMain[0];
        lvVector lvVector3 = upCbd.cbd[0].aCbd;
        lvVector lvVector4 = upCbd.cbd[1].aCbd;
        lvVector lvVector5 = downCbd.info[0].cVec;
        lvVector lvVector6 = downCbd.info[1].cVec;
        lvVector2.Assign(downCbd.info[1].vtx.Sub(lvVector6).Sub(downCbd.info[0].vtx.Add(lvVector5)));
        double d = upCbd.cbd[0].k;
        double d2 = upCbd.k1;
        double d3 = upCbd.cbd[1].k;
        double d4 = upCbd.cbd[0].h;
        double d5 = upCbd.cbd[1].h;
        lvVector lvVector7 = lvVectorArray[0];
        lvVector lvVector8 = lvVectorArray[1];
        lvVector7.Assign(lvVector4.Mul(0.3333333333333333 * d).Add(lvVector3.Mul(0.6666666666666666 * d2)));
        lvVector7.AddAssign(lvVector2.Mul(0.6666666666666666 * d4).Add(lvVector5.Mul(0.3333333333333333 * d5)));
        lvVector8.Assign(lvVector4.Mul(0.6666666666666666 * d2).Add(lvVector3.Mul(0.3333333333333333 * d3)));
        lvVector8.AddAssign(lvVector6.Mul(0.3333333333333333 * d4).Add(lvVector2.Mul(0.6666666666666666 * d5)));
    }

    private final void CorrectTriIndexNo(int n) {
        lvRec.SeqPart seqPart = this.Gbl().tmpTessellate.patch[n].infoVertex;
        lvRec.SeqPart seqPart2 = this.Gbl().tmpTessellate.patch[n].infoTriIndex;
        for (int i = 0; i < seqPart2.num; ++i) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = n2++;
                this.UpTessellate().triIndex[i].vtxNo[n3] = this.UpTessellate().triIndex[i].vtxNo[n3] + seqPart.start;
            }
        }
    }

    private final void ExecMain() throws lvThrowable {
        for (int i = 0; i < this.Gbl().tmpTessellate.numPatch; ++i) {
            this.NewUpTessellate(i);
            this.DownTessellate().numDivU = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i].numDivU;
            this.DownTessellate().numDivV = ((TmpTessellate)((Global)this.Gbl()).tmpTessellate).patch[i].numDivV;
            this.SetDownTessellate(i);
            if (!this.Gbl().attGGblElm.IsDmy()) {
                this.Gbl().tessellateUV.SetGtQuad(i, this.Gbl().tmpTessellate.numPatch);
            }
            this.Gbl().tessellateLow.Exec(this.DownTessellate(), this.UpTessellate());
            this.CorrectTriIndexNo(i);
        }
    }

    private final void SetDownTessellate(int n) throws lvThrowable {
        int n2 = (n + 1) % this.Gbl().tmpTessellate.numPatch;
        this.SetDownTessellateInner(n, this.DownTessellate().half[0], true);
        this.SetDownTessellateOuter(n, this.DownTessellate().half[1], true);
        this.SetDownTessellateOuter(n2, this.DownTessellate().half[2], false);
        this.SetDownTessellateInner(n2, this.DownTessellate().half[3], false);
        this.GetBCbdInner(0, this.DownTessellate().half);
        this.GetBCbdHalfEdgeLast(n, this.DownTessellate().half[1].bCbd);
        this.GetBCbdHalfEdgeFirst(n2, this.DownTessellate().half[2].bCbd);
        this.GetBCbdInner(3, this.DownTessellate().half);
    }

    private final void SetDownTessellateInner(int n, lvTessellateLow.DownHalf downHalf, boolean bl) throws lvThrowable {
        if (!bl) {
            lvDivFaceLow.Position(n, 0.5, downHalf.pos);
            for (int i = 0; i < 2; ++i) {
                downHalf.handVec[i].Assign(this.DeriveDivFace().inner[n].handVec[i]);
            }
        } else {
            downHalf.pos.Assign(this.DeriveDivFace().center.pos);
            for (int i = 0; i < 2; ++i) {
                downHalf.handVec[i].Assign(this.DeriveDivFace().inner[n].handVec[1 - i]);
            }
        }
    }

    private final void SetDownTessellateOuter(int n, lvTessellateLow.DownHalf downHalf, boolean bl) throws lvThrowable {
        if (!bl) {
            this.SetDownTessellateOuterFirst(n, downHalf);
        } else {
            this.SetDownTessellateOuterLast(n, downHalf);
        }
    }

    private final void SetDownTessellateOuterFirst(int n, lvTessellateLow.DownHalf downHalf) throws lvThrowable {
        lvVector[] lvVectorArray = this.Gbl().tvSetDownTessellateOuterFirst0;
        lvVector[] lvVectorArray2 = this.Gbl().tvSetDownTessellateOuterFirst1;
        this.GetOuterCurve(n, lvVectorArray);
        lvBezLine.DivideBezier(lvVectorArray, 0.5, lvVectorArray2, null);
        downHalf.pos.Assign(this.DownDivFace().half[n].pos);
        downHalf.handVec[0].Assign(lvVectorArray2[1].Sub(lvVectorArray2[0]));
        downHalf.handVec[1].Assign(lvVectorArray2[2].Sub(lvVectorArray2[3]));
    }

    private final void GetOuterCurve(int n, lvVector[] lvVectorArray) {
        int n2 = (n + 1) % this.DownDivFace().numHalf;
        lvVectorArray[0].Assign(this.DownDivFace().half[n].pos);
        lvVectorArray[1].Assign(this.DownDivFace().half[n].handVec[0]);
        lvVectorArray[2].Assign(this.DownDivFace().half[n].handVec[1]);
        lvVectorArray[3].Assign(this.DownDivFace().half[n2].pos);
        lvVectorArray[1].AddAssign(lvVectorArray[0]);
        lvVectorArray[2].AddAssign(lvVectorArray[3]);
    }

    private final void SetDownTessellateOuterLast(int n, lvTessellateLow.DownHalf downHalf) throws lvThrowable {
        lvVector[] lvVectorArray = this.Gbl().tvSetDownTessellateOuterLast0;
        lvVector[] lvVectorArray2 = this.Gbl().tvSetDownTessellateOuterLast1;
        this.GetOuterCurve(n, lvVectorArray);
        lvBezLine.DivideBezier(lvVectorArray, 0.5, null, lvVectorArray2);
        downHalf.pos.Assign(lvVectorArray2[0]);
        downHalf.handVec[0].Assign(lvVectorArray2[1].Sub(lvVectorArray2[0]));
        downHalf.handVec[1].Assign(lvVectorArray2[2].Sub(lvVectorArray2[3]));
    }

    private final void GetBCbdInner(int n, lvTessellateLow.DownHalf[] downHalfArray) throws lvThrowable {
        lvMakeCbd.DownCbd downCbd = this.Gbl().tdGetBCbdInner[0];
        lvMakeCbd.UpCbd upCbd = this.Gbl().tuGetBCbdInner[0];
        this.SetDownCbdInner(n, downHalfArray, downCbd);
        this.Gbl().makeCbd.Exec(downCbd, upCbd);
        this.GetBCbdMain(downCbd, upCbd, downHalfArray[n].bCbd);
    }

    private final void SetDownCbdInner(int n, lvTessellateLow.DownHalf[] downHalfArray, lvMakeCbd.DownCbd downCbd) {
        int n2 = (n + 4 - 1) % 4;
        int n3 = (n + 1) % 4;
        downCbd.info[0].vtx.Assign(downHalfArray[n].pos);
        downCbd.info[1].vtx.Assign(downHalfArray[n3].pos);
        downCbd.info[0].cVec.Assign(downHalfArray[n].handVec[0]);
        downCbd.info[1].cVec.Assign(downHalfArray[n].handVec[1].Neg());
        downCbd.info[0].bCbd.Assign(downHalfArray[n2].handVec[1]);
        downCbd.info[1].bCbd.Assign(downHalfArray[n3].handVec[0]);
        downCbd.faceNormal.Assign(this.DownDivFace().center.normal);
        downCbd.antiCenter = null;
        downCbd.info[0].antiVtx = null;
        downCbd.info[1].antiVtx = null;
    }

    private final void GetBCbdHalfEdgeFirst(int n, lvVector[] lvVectorArray) throws lvThrowable {
        lvMakeCbd.DownCbd downCbd = this.Gbl().tdGetBCbdHalfEdgeFirst[0];
        lvMakeCbd.UpHalfCbd upHalfCbd = this.Gbl().tuGetBCbdHalfEdgeFirst[0];
        this.SetDownCbdOuter(n, downCbd);
        this.Gbl().makeCbd.ExecHalf(downCbd, upHalfCbd);
        this.GetBCbdHalfEdgeFirstMain(n, downCbd, upHalfCbd, lvVectorArray);
    }

    private final void GetBCbdHalfEdgeFirstMain(int n, lvMakeCbd.DownCbd downCbd, lvMakeCbd.UpHalfCbd upHalfCbd, lvVector[] lvVectorArray) throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvGetBCbdHalfEdgeFirstMain[0];
        lvVector lvVector3 = this.Gbl().tvGetBCbdHalfEdgeFirstMain[1];
        lvVector lvVector4 = this.Gbl().tvGetBCbdHalfEdgeFirstMain[2];
        lvVector lvVector5 = this.Gbl().tvGetBCbdHalfEdgeFirstMain[3];
        lvVector lvVector6 = upHalfCbd.cbd[0].aCbd;
        lvVector lvVector7 = upHalfCbd.cbd[1].aCbd;
        lvDivFaceLow.Position(n, 0.5, lvVector5);
        lvVector2.Assign(downCbd.info[0].cVec.Div(2.0));
        lvDivFaceLow.Derivative(n, 0.5, lvVector4);
        lvVector4.DivAssign(6.0);
        lvVector3.Assign(lvVector5.Sub(lvVector4).Sub(downCbd.info[0].vtx.Add(lvVector2)));
        double d = upHalfCbd.cbd[0].k;
        double d2 = upHalfCbd.k1[0];
        double d3 = upHalfCbd.cbd[1].k;
        double d4 = upHalfCbd.cbd[0].h;
        double d5 = upHalfCbd.cbd[1].h;
        lvVector lvVector8 = lvVectorArray[0];
        lvVector lvVector9 = lvVectorArray[1];
        lvVector8.Assign(lvVector7.Mul(0.3333333333333333 * d).Add(lvVector6.Mul(0.6666666666666666 * d2)));
        lvVector8.AddAssign(lvVector3.Mul(0.6666666666666666 * d4).Add(lvVector2.Mul(0.3333333333333333 * d5)));
        lvVector9.Assign(lvVector7.Mul(0.6666666666666666 * d2).Add(lvVector6.Mul(0.3333333333333333 * d3)));
        lvVector9.AddAssign(lvVector4.Mul(0.3333333333333333 * d4).Add(lvVector3.Mul(0.6666666666666666 * d5)));
    }

    private final void GetBCbdHalfEdgeLast(int n, lvVector[] lvVectorArray) throws lvThrowable {
        lvMakeCbd.DownCbd downCbd = this.Gbl().tdGetBCbdHalfEdgeLast[0];
        lvMakeCbd.UpHalfCbd upHalfCbd = this.Gbl().tuGetBCbdHalfEdgeLast[0];
        this.SetDownCbdOuter(n, downCbd);
        this.Gbl().makeCbd.ExecHalf(downCbd, upHalfCbd);
        this.GetBCbdHalfEdgeLastMain(n, downCbd, upHalfCbd, lvVectorArray);
    }

    private final void GetBCbdHalfEdgeLastMain(int n, lvMakeCbd.DownCbd downCbd, lvMakeCbd.UpHalfCbd upHalfCbd, lvVector[] lvVectorArray) throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvGetBCbdHalfEdgeLastMain[0];
        lvVector lvVector3 = this.Gbl().tvGetBCbdHalfEdgeLastMain[1];
        lvVector lvVector4 = this.Gbl().tvGetBCbdHalfEdgeLastMain[2];
        lvVector lvVector5 = this.Gbl().tvGetBCbdHalfEdgeLastMain[3];
        lvVector lvVector6 = upHalfCbd.cbd[1].aCbd;
        lvVector lvVector7 = upHalfCbd.cbd[2].aCbd;
        lvDivFaceLow.Position(n, 0.5, lvVector5);
        lvDivFaceLow.Derivative(n, 0.5, lvVector2);
        lvVector2.DivAssign(6.0);
        lvVector4.Assign(downCbd.info[1].cVec.Div(2.0));
        lvVector3.Assign(downCbd.info[1].vtx.Sub(lvVector4).Sub(lvVector5.Add(lvVector2)));
        double d = upHalfCbd.cbd[1].k;
        double d2 = upHalfCbd.k1[1];
        double d3 = upHalfCbd.cbd[2].k;
        double d4 = upHalfCbd.cbd[1].h;
        double d5 = upHalfCbd.cbd[2].h;
        lvVector lvVector8 = lvVectorArray[0];
        lvVector lvVector9 = lvVectorArray[1];
        lvVector8.Assign(lvVector7.Mul(0.3333333333333333 * d).Add(lvVector6.Mul(0.6666666666666666 * d2)));
        lvVector8.AddAssign(lvVector3.Mul(0.6666666666666666 * d4).Add(lvVector2.Mul(0.3333333333333333 * d5)));
        lvVector9.Assign(lvVector7.Mul(0.6666666666666666 * d2).Add(lvVector6.Mul(0.3333333333333333 * d3)));
        lvVector9.AddAssign(lvVector4.Mul(0.3333333333333333 * d4).Add(lvVector3.Mul(0.6666666666666666 * d5)));
    }

    private final void Finish() {
        this.UpTessellate().vertex = null;
        this.UpTessellate().triIndex = null;
        TmpTessellate.access$1102(this.Gbl().tmpTessellate, null);
    }

    public static class Global {
        private lvTessellateLow tessellateLow = null;
        private lvTessellateUV tessellateUV = null;
        private lv0AttGGblElm attGGblElm = null;
        private lvTessellateLow.DownTessellate downTessellate = null;
        private lvTessellateLow.UpTessellate upTessellate = null;
        private lvDivFaceType.DownDivFace curDownDivFace = null;
        private lvDivFaceType.DeriveDivFace curDeriveDivFace = null;
        private lvDivFaceType.UpDivFace curUpDivFace = null;
        private TmpTessellate tmpTessellate = null;
        private lvMakeCbd makeCbd = null;
        private lvVector antiCenter = null;
        private lvVector antiVtx0 = null;
        private lvVector antiVtx1 = null;
        private lvMakeCbd.DownCbd[] tdGetBCbdOuter = null;
        private lvMakeCbd.UpCbd[] tuGetBCbdOuter = null;
        private lvMakeCbd.DownCbd[] tdGetBCbdInner = null;
        private lvMakeCbd.UpCbd[] tuGetBCbdInner = null;
        private lvVector[] tvGetBCbdMain = null;
        private lvMakeCbd.DownCbd[] tdGetBCbdHalfEdgeFirst = null;
        private lvMakeCbd.UpHalfCbd[] tuGetBCbdHalfEdgeFirst = null;
        private lvMakeCbd.DownCbd[] tdGetBCbdHalfEdgeLast = null;
        private lvMakeCbd.UpHalfCbd[] tuGetBCbdHalfEdgeLast = null;
        private lvVector[] tvGetBCbdHalfEdgeFirstMain = null;
        private lvVector[] tvGetBCbdHalfEdgeLastMain = null;
        private lvVector[] tvSetDownTessellateOuterFirst0 = null;
        private lvVector[] tvSetDownTessellateOuterFirst1 = null;
        private lvVector[] tvSetDownTessellateOuterLast0 = null;
        private lvVector[] tvSetDownTessellateOuterLast1 = null;
        private TmpPatch[] staticPatch = null;
        private lvRec.PosNorHi[] staticVertex = new lvRec.PosNorHi[256];
        private lvRec.TriIndex[] staticTriIndex = new lvRec.TriIndex[256];

        public Global(lvGlobal lvGlobal2) {
            this.tessellateLow = new lvTessellateLow(lvGlobal2);
            this.tessellateUV = new lv0TessellateUV(lvGlobal2);
            this.attGGblElm = new lv0AttGGblElm(lvGlobal2);
            this.downTessellate = new lvTessellateLow.DownTessellate(lvGlobal2);
            this.upTessellate = new lvTessellateLow.UpTessellate();
            this.curDownDivFace = new lvDivFaceType.DownDivFace(lvGlobal2);
            this.curDeriveDivFace = new lvDivFaceType.DeriveDivFace(lvGlobal2);
            this.curUpDivFace = new lvDivFaceType.UpDivFace();
            this.tmpTessellate = new TmpTessellate();
            this.makeCbd = new lvMakeCbd(lvGlobal2);
            this.antiCenter = new lvVector(lvGlobal2);
            this.antiVtx0 = new lvVector(lvGlobal2);
            this.antiVtx1 = new lvVector(lvGlobal2);
            this.GlobalTmp(lvGlobal2);
            this.GlobalStatic(lvGlobal2);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tdGetBCbdOuter = new lvMakeCbd.DownCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tdGetBCbdOuter[n] = new lvMakeCbd.DownCbd(lvGlobal2);
            }
            this.tuGetBCbdOuter = new lvMakeCbd.UpCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tuGetBCbdOuter[n] = new lvMakeCbd.UpCbd(lvGlobal2);
            }
            this.tdGetBCbdInner = new lvMakeCbd.DownCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tdGetBCbdInner[n] = new lvMakeCbd.DownCbd(lvGlobal2);
            }
            this.tuGetBCbdInner = new lvMakeCbd.UpCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tuGetBCbdInner[n] = new lvMakeCbd.UpCbd(lvGlobal2);
            }
            this.tvGetBCbdMain = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvGetBCbdMain[n] = new lvVector(lvGlobal2);
            }
            this.tdGetBCbdHalfEdgeFirst = new lvMakeCbd.DownCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tdGetBCbdHalfEdgeFirst[n] = new lvMakeCbd.DownCbd(lvGlobal2);
            }
            this.tuGetBCbdHalfEdgeFirst = new lvMakeCbd.UpHalfCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tuGetBCbdHalfEdgeFirst[n] = new lvMakeCbd.UpHalfCbd(lvGlobal2);
            }
            this.tdGetBCbdHalfEdgeLast = new lvMakeCbd.DownCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tdGetBCbdHalfEdgeLast[n] = new lvMakeCbd.DownCbd(lvGlobal2);
            }
            this.tuGetBCbdHalfEdgeLast = new lvMakeCbd.UpHalfCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tuGetBCbdHalfEdgeLast[n] = new lvMakeCbd.UpHalfCbd(lvGlobal2);
            }
            this.tvGetBCbdHalfEdgeFirstMain = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvGetBCbdHalfEdgeFirstMain[n] = new lvVector(lvGlobal2);
            }
            this.tvGetBCbdHalfEdgeLastMain = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvGetBCbdHalfEdgeLastMain[n] = new lvVector(lvGlobal2);
            }
            this.tvSetDownTessellateOuterFirst0 = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetDownTessellateOuterFirst0[n] = new lvVector(lvGlobal2);
            }
            this.tvSetDownTessellateOuterFirst1 = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetDownTessellateOuterFirst1[n] = new lvVector(lvGlobal2);
            }
            this.tvSetDownTessellateOuterLast0 = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetDownTessellateOuterLast0[n] = new lvVector(lvGlobal2);
            }
            this.tvSetDownTessellateOuterLast1 = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetDownTessellateOuterLast1[n] = new lvVector(lvGlobal2);
            }
        }

        private final void GlobalStatic(lvGlobal lvGlobal2) {
            this.staticPatch = new TmpPatch[256];
            for (int i = 0; i < 256; ++i) {
                this.staticPatch[i] = new TmpPatch();
            }
        }
    }

    private static class TmpTessellate {
        private int numPatch;
        private TmpPatch[] patch = null;

        private TmpTessellate() {
        }

        static /* synthetic */ TmpPatch[] access$1102(TmpTessellate tmpTessellate, TmpPatch[] tmpPatchArray) {
            tmpTessellate.patch = tmpPatchArray;
            return tmpPatchArray;
        }
    }

    private static class TmpPatch {
        public int numDivV;
        public int numDivU;
        private lvRec.SeqPart infoVertex = new lvRec.SeqPart();
        private lvRec.SeqPart infoTriIndex = new lvRec.SeqPart();

        private TmpPatch() {
        }
    }
}

