/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.core.c0;

import jp.co.lattice.vKernel.core.c0.lvComGblElm;
import jp.co.lattice.vKernel.core.c0.lvDouble;
import jp.co.lattice.vKernel.core.c0.lvEps;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVector;

public class lvVecCalc
extends lvRoot {
    public static final byte LV_ANGSTAT_ZEROVEC = 0;
    public static final byte LV_ANGSTAT_ZEROANG = 1;
    public static final byte LV_ANGSTAT_G1 = 2;
    public static final byte LV_ANGSTAT_OTHER = 3;
    public double x;
    public double y;
    public double z;

    private final Global Gbl() {
        return ((lvComGblElm)this.global.GCom()).gVecCalc;
    }

    public lvVecCalc(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public lvVecCalc(lvGlobal lvGlobal2, lvVecCalc lvVecCalc2) {
        super(lvGlobal2);
        this.x = lvVecCalc2.x;
        this.y = lvVecCalc2.y;
        this.z = lvVecCalc2.z;
    }

    public lvVecCalc(lvGlobal lvGlobal2, double d, double d2, double d3) {
        super(lvGlobal2);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public final lvVecCalc Copy_Local(lvVecCalc lvVecCalc2) {
        this.x = lvVecCalc2.x;
        this.y = lvVecCalc2.y;
        this.z = lvVecCalc2.z;
        return this;
    }

    private lvVecCalc SetXYZ_Local(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    private final void IncResultBufV() {
        this.Gbl().cnt_resultBufV = (this.Gbl().cnt_resultBufV + 1) % 128;
    }

    private final void IncResultBufD() {
        this.Gbl().cnt_resultBufD = (this.Gbl().cnt_resultBufD + 1) % 128;
    }

    public final lvVecCalc Add(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3) {
        lvVecCalc3.SetXYZ_Local(this.x + lvVecCalc2.x, this.y + lvVecCalc2.y, this.z + lvVecCalc2.z);
        return lvVecCalc3;
    }

    public final lvVecCalc Add(lvVecCalc lvVecCalc2) {
        lvVecCalc lvVecCalc3 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Add(lvVecCalc2, lvVecCalc3);
    }

    public final lvVecCalc Sub(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3) {
        lvVecCalc3.SetXYZ_Local(this.x - lvVecCalc2.x, this.y - lvVecCalc2.y, this.z - lvVecCalc2.z);
        return lvVecCalc3;
    }

    public final lvVecCalc Sub(lvVecCalc lvVecCalc2) {
        lvVecCalc lvVecCalc3 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Sub(lvVecCalc2, lvVecCalc3);
    }

    public final lvVecCalc Mul(double d, lvVecCalc lvVecCalc2) {
        lvVecCalc2.SetXYZ_Local(this.x * d, this.y * d, this.z * d);
        return lvVecCalc2;
    }

    public final lvVecCalc Mul(double d) {
        lvVecCalc lvVecCalc2 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Mul(d, lvVecCalc2);
    }

    public final lvVecCalc Div(double d, lvVecCalc lvVecCalc2) throws lvThrowable {
        this.Err().Assert(d != 0.0, "lvVecCalc.Div(0)");
        lvVecCalc2.SetXYZ_Local(this.x / d, this.y / d, this.z / d);
        return lvVecCalc2;
    }

    public final lvVecCalc Div(double d) throws lvThrowable {
        lvVecCalc lvVecCalc2 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Div(d, lvVecCalc2);
    }

    public final double Dot(lvVecCalc lvVecCalc2) {
        return this.x * lvVecCalc2.x + this.y * lvVecCalc2.y + this.z * lvVecCalc2.z;
    }

    public final lvDouble DotR(lvVecCalc lvVecCalc2, lvDouble lvDouble2) {
        lvDouble2.val = this.Dot(lvVecCalc2);
        return lvDouble2;
    }

    public final lvDouble DotR(lvVecCalc lvVecCalc2) {
        lvDouble lvDouble2 = this.Gbl().resultBufD[this.Gbl().cnt_resultBufD];
        this.IncResultBufD();
        return this.DotR(lvVecCalc2, lvDouble2);
    }

    public final lvVecCalc Cross(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3) {
        lvVecCalc3.SetXYZ_Local(this.y * lvVecCalc2.z - this.z * lvVecCalc2.y, this.z * lvVecCalc2.x - this.x * lvVecCalc2.z, this.x * lvVecCalc2.y - this.y * lvVecCalc2.x);
        return lvVecCalc3;
    }

    public final lvVecCalc Cross(lvVecCalc lvVecCalc2) {
        lvVecCalc lvVecCalc3 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Cross(lvVecCalc2, lvVecCalc3);
    }

    public final lvVecCalc Neg(lvVecCalc lvVecCalc2) {
        lvVecCalc2.SetXYZ_Local(-this.x, -this.y, -this.z);
        return lvVecCalc2;
    }

    public final lvVecCalc Neg() {
        lvVecCalc lvVecCalc2 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Neg(lvVecCalc2);
    }

    public final lvVecCalc Unit(lvVecCalc lvVecCalc2, double d) throws lvThrowable {
        this.Err().Assert(d >= 0.0, "lvVector.Unit(0)");
        double d2 = this.Length2();
        this.Eps();
        if (lvEps.IsZero2(d2, d)) {
            lvVecCalc2.z = 0.0;
            lvVecCalc2.y = 0.0;
            lvVecCalc2.x = 0.0;
        } else {
            double d3 = Math.sqrt(d2);
            lvVecCalc2.SetXYZ_Local(this.x / d3, this.y / d3, this.z / d3);
        }
        return lvVecCalc2;
    }

    public final lvVecCalc Unit(double d) throws lvThrowable {
        lvVecCalc lvVecCalc2 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Unit(lvVecCalc2, d);
    }

    public final lvVecCalc Unit() throws lvThrowable {
        lvVecCalc lvVecCalc2 = this.Gbl().resultBufV[this.Gbl().cnt_resultBufV];
        this.IncResultBufV();
        return this.Unit(lvVecCalc2, 1.0E-6);
    }

    public final boolean IsZero(double d) throws lvThrowable {
        double d2;
        this.Err().Assert(this.Dot(this) >= 0.0, "lvVecCalc.IsZero(0)");
        this.Err().Assert(d >= 0.0, "lvVecCalc.IsZero(1)");
        if (this.x < -d || this.x > d) {
            return false;
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return true;
        }
        if (this.y < -d || this.y > d) {
            return false;
        }
        if (this.z < -d || this.z > d) {
            return false;
        }
        this.Err().Assert(d > 0.0, "lvVecCalc.IsZero(2)");
        double d3 = d2 = d == 1.0E-6 ? 5.773502691896258E-7 : d * 0.5773502691896257;
        if (-d2 <= this.x && this.x <= d2 && -d2 <= this.y && this.y <= d2 && -d2 <= this.z && this.z <= d2) {
            return true;
        }
        this.Eps();
        return lvEps.IsZero2(this.Dot(this), d);
    }

    public final boolean IsZero() throws lvThrowable {
        return this.IsZero(1.0E-6);
    }

    public final boolean IsSame(lvVecCalc lvVecCalc2, double d) throws lvThrowable {
        this.Err().Assert(d >= 0.0, "lvVecCalc.IsSame(0)");
        return lvVecCalc2.Sub(this).IsZero(d);
    }

    public final boolean IsSame(lvVecCalc lvVecCalc2) throws lvThrowable {
        return this.IsSame(lvVecCalc2, 1.0E-6);
    }

    public final double Length() throws lvThrowable {
        return Math.sqrt(this.Length2());
    }

    public final double Length2() throws lvThrowable {
        this.Err().Assert(this.Dot(this) >= 0.0, "lvVecCalc.Length2(0)");
        return this.Dot(this);
    }

    public final int AngleStatus(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, double d) throws lvThrowable {
        lvVector lvVector2;
        lvVector lvVector3;
        this.Err().Assert(d >= 0.0, "lvVecCalc.AngleStatus(0)");
        lvVector lvVector4 = this.Gbl().tvAngleStatus[0];
        lvVector4.Assign(this.Sub(lvVecCalc2));
        if (lvVector4.IsZero(d)) {
            return 0;
        }
        lvVector lvVector5 = this.Gbl().tvAngleStatus[1];
        lvVector5.Assign(this.Sub(lvVecCalc3));
        if (lvVector5.IsZero(d)) {
            return 0;
        }
        lvVector lvVector6 = this.Gbl().tvAngleStatus[2];
        lvVector6.Assign(lvVecCalc3.Sub(lvVecCalc2));
        if (lvVector6.IsZero(d)) {
            return 1;
        }
        lvDouble lvDouble2 = this.Gbl().tdAngleStatus[0];
        lvVector lvVector7 = this.Gbl().tvAngleStatus[3];
        double d2 = lvVector6.Dot(lvVector4) / lvVector6.Dot(lvVector6);
        if (0.0 <= d2 && d2 <= 1.0) {
            lvDouble2.val = d2;
            lvVector7.Assign(lvVecCalc2.Add(lvDouble2.Mul(lvVector6)));
            boolean bl = this.IsSame(lvVector7, d);
            if (bl) {
                return 2;
            }
            return 3;
        }
        lvVector lvVector8 = this.Gbl().tvAngleStatus[4];
        lvVector lvVector9 = this.Gbl().tvAngleStatus[5];
        if (lvVector4.Length2() >= lvVector5.Length2()) {
            lvVector9.Assign(lvVecCalc2);
            lvVector3 = lvVector4;
            lvVector8.Assign(lvVecCalc3);
            lvVector2 = lvVector5;
        } else {
            lvVector9.Assign(lvVecCalc3);
            lvVector3 = lvVector5;
            lvVector8.Assign(lvVecCalc2);
            lvVector2 = lvVector4;
        }
        lvVector3.NegAssign();
        lvVector2.NegAssign();
        d2 = lvVector3.Dot(lvVector2) / lvVector3.Dot(lvVector3);
        if (0.0 <= d2 && d2 <= 1.0) {
            lvDouble2.val = d2;
            lvVector7.Assign(this.Add(lvDouble2.Mul(lvVector3)));
            boolean bl = lvVector8.IsSame(lvVector7, d);
            if (bl) {
                return 1;
            }
            return 3;
        }
        return 3;
    }

    public final int AngleStatus(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3) throws lvThrowable {
        return this.AngleStatus(lvVecCalc2, lvVecCalc3, 1.0E-6);
    }

    public final int IntersecLinePlane(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, lvVecCalc lvVecCalc4, double d, lvVector lvVector2, lvDouble lvDouble2) throws lvThrowable {
        lvVector lvVector3 = this.Gbl().tvIntersecLinePlane[0];
        lvVector3.Assign(lvVecCalc2.Sub(this));
        if (lvVector3.IsZero(d)) {
            lvVector lvVector4 = this.Gbl().tvIntersecLinePlane[1];
            lvVector4.Assign(this.Add(lvVecCalc2).Div(2.0).Sub(lvVecCalc3));
            this.Eps();
            if (lvEps.IsZero(lvVector4.Dot(lvVecCalc4), d)) {
                return 1;
            }
            return 0;
        }
        double d2 = lvVecCalc4.Dot(lvVector3);
        this.Eps();
        if (lvEps.IsZero(d2, d)) {
            this.Eps();
            if (lvEps.IsZero(this.Sub(lvVecCalc3).Dot(lvVecCalc4), d)) {
                return 1;
            }
            return 0;
        }
        lvDouble2.val = -lvVecCalc4.Dot(this.Sub(lvVecCalc3)) / lvVecCalc4.Dot(lvVector3);
        lvVector2.Assign(this.Add(lvVector3.Mul(lvDouble2.val)));
        return 2;
    }

    public final int IntersecLinePlane(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, lvVecCalc lvVecCalc4, lvVector lvVector2, lvDouble lvDouble2) throws lvThrowable {
        return this.IntersecLinePlane(lvVecCalc2, lvVecCalc3, lvVecCalc4, 1.0E-6, lvVector2, lvDouble2);
    }

    public final boolean IsPara(lvVecCalc lvVecCalc2, double d) throws lvThrowable {
        this.Err().Assert(this.Eps().IsSame21(this.Length2(), 1.0, 1.0E-15), "lvVecCalc.IsPara(0)");
        this.Err().Assert(this.Eps().IsSame21(lvVecCalc2.Length2(), 1.0, 1.0E-15), "lvVecCalc.IsPara(1)");
        this.Err().Assert(0.0 <= d && d < 1.0, "lvVecCalc.IsPara(2)");
        return this.IsSame(lvVecCalc2, d) || this.IsSame(lvVecCalc2.Neg(), d);
    }

    public final boolean IsPara(lvVecCalc lvVecCalc2) throws lvThrowable {
        return this.IsPara(lvVecCalc2, 1.0E-8);
    }

    public final double Angle(lvVecCalc lvVecCalc2) throws lvThrowable {
        this.Err().Assert(this.Eps().IsSame21(this.Length2(), 1.0, 1.0E-15), "lvVecCalc.Angle(00)");
        this.Err().Assert(this.Eps().IsSame21(lvVecCalc2.Length2(), 1.0, 1.0E-15), "lvVecCalc.Angle(01)");
        double d = this.Dot(lvVecCalc2);
        if (d < -0.999999999999) {
            d = this.Add(lvVecCalc2).Length() / 2.0;
            return Math.PI - 2.0 * Math.asin(d);
        }
        if (d > 0.999999999999) {
            d = this.Sub(lvVecCalc2).Length() / 2.0;
            return 2.0 * Math.asin(d);
        }
        return Math.acos(d);
    }

    public final boolean Divide(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, lvDouble lvDouble2, lvDouble lvDouble3, double d, double d2) throws lvThrowable {
        double d3;
        this.Err().Assert(d >= 0.0, "lvVecCalc.Divide(00)");
        this.Err().Assert(0.0 <= d2 && d2 < 1.0, "lvVecCalc.Divide(01)");
        double d4 = this.Dot(lvVecCalc2);
        double d5 = this.Dot(lvVecCalc3);
        double d6 = lvVecCalc2.Dot(lvVecCalc2);
        double d7 = lvVecCalc2.Dot(lvVecCalc3);
        double d8 = lvVecCalc3.Dot(lvVecCalc3);
        double d9 = d3 = d == 1.0E-6 ? 1.0E-12 : d * d;
        if (d6 <= d3) {
            if (d8 <= d3) {
                lvDouble2.val = 0.0;
                lvDouble3.val = 0.0;
                return false;
            }
            lvDouble2.val = 0.0;
            lvDouble3.val = d5 / d8;
            return this.IsSame(lvDouble2.Mul(lvVecCalc2).Add(lvDouble3.Mul(lvVecCalc3)), d);
        }
        if (d8 <= d3) {
            lvDouble2.val = d4 / d6;
            lvDouble3.val = 0.0;
            return this.IsSame(lvDouble2.Mul(lvVecCalc2).Add(lvDouble3.Mul(lvVecCalc3)), d);
        }
        double d10 = d6 * d8 - d7 * d7;
        if (d10 <= d6 * d8 * d2 * d2) {
            lvDouble2.val = d6 >= d8 ? d4 / d6 : d5 / d8;
            lvDouble3.val = 0.0;
            return this.IsSame(lvDouble2.Mul(lvVecCalc2).Add(lvDouble3.Mul(lvVecCalc3)), d);
        }
        lvDouble2.val = (d4 * d8 - d7 * d5) / d10;
        lvDouble3.val = (d6 * d5 - d4 * d7) / d10;
        return true;
    }

    public final boolean OnPlane(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, double d) throws lvThrowable {
        this.Err().Assert(this.Eps().IsSame21(lvVecCalc3.Length2(), 1.0, 1.0E-15), "lvVecCalc.OnPlane(0)");
        this.Err().Assert(d >= 0.0, "lvVecCalc.OnPlane(1)");
        return Math.abs(this.Sub(lvVecCalc2).Dot(lvVecCalc3)) <= d;
    }

    public final boolean IsLine(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, double d) throws lvThrowable {
        this.Err().Assert(d >= 0.0, "lvVecCalc.IsLine(0)");
        lvDouble lvDouble2 = this.Gbl().tdIsLine[0];
        lvVector lvVector2 = this.Gbl().tvIsLine[0];
        lvVector2.Assign(this);
        lvVector2.NormalAssign(lvVecCalc2, lvVecCalc3, lvDouble2, d);
        return lvDouble2.val == 0.0;
    }

    public final boolean IsLine(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3) throws lvThrowable {
        return this.IsLine(lvVecCalc2, lvVecCalc3, 1.0E-6);
    }

    public final boolean IsPlane(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, lvVecCalc lvVecCalc4, double d) throws lvThrowable {
        this.Err().Assert(d >= 0.0, "lvVecCalc.IsPlane(0)");
        lvDouble lvDouble2 = this.Gbl().tdIsPlane[0];
        lvVector lvVector2 = this.Gbl().tvIsPlane[0];
        lvVector2.Assign(this);
        lvVector2.NormalAssign(lvVecCalc2, lvVecCalc3, lvVecCalc4, lvDouble2, d);
        if (lvDouble2.val == 0.0) {
            return true;
        }
        lvVector lvVector3 = this.Gbl().tvIsPlane[1];
        lvVector3.Assign(this.Add(lvVecCalc2).Add(lvVecCalc3).Add(lvVecCalc4).Mul(0.25));
        return this.OnPlane(lvVector3, lvVector2, d) && lvVecCalc2.OnPlane(lvVector3, lvVector2, d) && lvVecCalc3.OnPlane(lvVector3, lvVector2, d) && lvVecCalc4.OnPlane(lvVector3, lvVector2, d);
    }

    public final boolean IsPlane(lvVecCalc lvVecCalc2, lvVecCalc lvVecCalc3, lvVecCalc lvVecCalc4) throws lvThrowable {
        return this.IsPlane(lvVecCalc2, lvVecCalc3, lvVecCalc4, 1.0E-6);
    }

    public static class Global {
        private static final int num_resultBufV = 128;
        private lvVecCalc[] resultBufV = null;
        private int cnt_resultBufV = 0;
        private static final int num_resultBufD = 128;
        private lvDouble[] resultBufD = null;
        private int cnt_resultBufD = 0;
        private lvVector[] tvAngleStatus = null;
        private lvDouble[] tdAngleStatus = null;
        private lvVector[] tvIntersecLinePlane = null;
        private lvDouble[] tdIsLine = null;
        private lvVector[] tvIsLine = null;
        private lvVector[] tvIsPlane = null;
        private lvDouble[] tdIsPlane = null;

        public Global(lvGlobal lvGlobal2) {
            this.GlobalBuf(lvGlobal2);
            this.GlobalTmp(lvGlobal2);
        }

        private final void GlobalBuf(lvGlobal lvGlobal2) {
            int n;
            this.resultBufV = new lvVecCalc[128];
            for (n = 0; n < 128; ++n) {
                this.resultBufV[n] = new lvVecCalc(lvGlobal2);
            }
            this.resultBufD = new lvDouble[128];
            for (n = 0; n < 128; ++n) {
                this.resultBufD[n] = new lvDouble(lvGlobal2);
            }
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tvAngleStatus = new lvVector[12];
            for (n = 0; n < 12; ++n) {
                this.tvAngleStatus[n] = new lvVector(lvGlobal2);
            }
            this.tdAngleStatus = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdAngleStatus[n] = new lvDouble(lvGlobal2);
            }
            this.tvIntersecLinePlane = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvIntersecLinePlane[n] = new lvVector(lvGlobal2);
            }
            this.tdIsLine = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdIsLine[n] = new lvDouble(lvGlobal2);
            }
            this.tvIsLine = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvIsLine[n] = new lvVector(lvGlobal2);
            }
            this.tvIsPlane = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvIsPlane[n] = new lvVector(lvGlobal2);
            }
            this.tdIsPlane = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdIsPlane[n] = new lvDouble(lvGlobal2);
            }
        }
    }
}

