/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vApplet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import jp.co.lattice.vApplet.xvBBox;
import jp.co.lattice.vApplet.xvDraw;
import jp.co.lattice.vApplet.xvGlobal;
import jp.co.lattice.vApplet.xvRend;
import jp.co.lattice.vApplet.xvTexFileToImage;
import jp.co.lattice.vKernel.core.b0.lvToKernel;
import jp.co.lattice.vKernel.core.c0.lvComGblElm;
import jp.co.lattice.vKernel.core.c0.lvError;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvToKernelType;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vProcessor.base.x3pFromProcessor;
import jp.co.lattice.vProcessor.base.x3pToProcessor;
import jp.co.lattice.vProcessor.base.x3pWorld;
import jp.co.lattice.vProcessor.com.x3pGlobal;

public class xvMain {
    private Thread runner;
    private Init initThread;
    private boolean initialized = false;
    private long startTime = -1L;
    private int cntForPaintInit = 0;
    private int cntForPaintMain = 0;
    private int sleepTime = 100;
    private int xPressed;
    private int yPressed;
    private long timePressed;
    private static final int PAINTSTAT_ORG = 0;
    private static final int PAINTSTAT_PREPAINT_NOW = 1;
    private static final int PAINTSTAT_PREPAINT_FINISH = 2;
    private static final int PAINTSTAT_PAINT_NOW = 3;
    private int paintStat = 0;
    private String errorMessage = null;
    private xvDraw view;
    private lvVector boundMin = null;
    private lvVector boundMax = null;
    public xvGlobal mXvGlobal = new xvGlobal();
    public static final int PAN = 0;
    public static final int EXAMIN = 1;
    public static final int ZOOM = 2;
    private int mode = 1;
    private int prevx;
    private int prevy;
    private boolean mouseDragInit = true;
    private boolean viewFitFlag = false;
    private int numDivForPress = 0;

    private x3pGlobal Processor() {
        return this.mXvGlobal.processor;
    }

    private final lvError.Global ErrProc() {
        return ((lvComGblElm)this.Processor().GCom()).gError;
    }

    private xvRend Rend() {
        return this.mXvGlobal.rend;
    }

    private final void Initialize(Applet applet, MouseListener mouseListener, MouseMotionListener mouseMotionListener, KeyListener keyListener) {
        boolean bl;
        String string;
        String string2;
        this.mXvGlobal.processor = x3pWorld.Init();
        String string3 = applet.getParameter("FileName");
        URL uRL = this.GetXvl3FileUrl(applet, string3);
        if (uRL == null) {
            this.SetError("XVL3 file not found.");
            return;
        }
        URL uRL2 = this.MakeXvl3Base(uRL);
        this.mXvGlobal.rend = new xvRend(this.mXvGlobal, applet.getSize().width, applet.getSize().height, applet);
        int n = 0;
        String string4 = applet.getParameter("DivNum");
        if (string4 != null) {
            n = Integer.valueOf(string4);
            if (n % 2 != 0) {
                ++n;
            }
            if (n > 8) {
                n = 8;
            }
            if (n < 2) {
                n = 2;
            }
        }
        if ((string2 = applet.getParameter("BgColor")) != null) {
            this.Rend().SetBgColor(string2);
        }
        if ((string = applet.getParameter("BgTex")) != null && (bl = this.Rend().SetBgTex(string))) {
            return;
        }
        String string5 = applet.getParameter("AutoRotate");
        if (string5 != null) {
            int n2 = Integer.valueOf(string5);
            if (n2 > 10) {
                n2 = 10;
            } else if (n2 < -10) {
                n2 = -10;
            } else if (n2 == 0) {
                n2 = 1;
            }
            this.Rend().SetAutoRotate(n2);
        }
        if (bl = this.ToProcessor(uRL, n)) {
            return;
        }
        bl = this.FromProcessor();
        if (bl) {
            return;
        }
        bl = this.TexFileToImage(uRL2);
        if (bl) {
            return;
        }
        this.view = new xvDraw(this.mXvGlobal);
        this.boundMin = new lvVector(this.mXvGlobal.processor);
        this.boundMax = new lvVector(this.mXvGlobal.processor);
        xvBBox xvBBox2 = new xvBBox(this.mXvGlobal, this.Rend(), this.mXvGlobal.fromProcess);
        bl = xvBBox2.GetBBox(this.boundMin, this.boundMax);
        if (bl) {
            this.SetError("BoundBox Error");
            return;
        }
        this.Rend().view.ViewFit(this.boundMin, this.boundMax);
        applet.addKeyListener(keyListener);
        applet.addMouseListener(mouseListener);
        applet.addMouseMotionListener(mouseMotionListener);
        this.initialized = true;
        this.cntForPaintMain = 0;
    }

    private final URL GetXvl3FileUrl(Applet applet, String string) {
        URL uRL = null;
        uRL = this.GetXvl3FileUrlForIE(applet, string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.GetXvl3FileUrlForNC(applet, string);
        if (uRL != null) {
            return uRL;
        }
        return null;
    }

    private final URL GetXvl3FileUrlForIE(Applet applet, String string) {
        URL uRL;
        try {
            uRL = new URL(applet.getDocumentBase(), string);
            uRL.openStream();
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private final URL GetXvl3FileUrlForNC(Applet applet, String string) {
        URL uRL;
        String string2 = URLEncoder.encode(string);
        try {
            uRL = new URL(applet.getDocumentBase(), string2);
            uRL.openStream();
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private final URL MakeXvl3Base(URL uRL) {
        URL uRL2;
        String string = uRL.toString();
        int n = string.lastIndexOf("/");
        String string2 = string.substring(0, n + 1);
        try {
            uRL2 = new URL(string2);
        }
        catch (Exception exception) {
            this.SetError(exception.getMessage());
            return null;
        }
        return uRL2;
    }

    private final boolean ToProcessor(URL uRL, int n) {
        boolean bl;
        x3pToProcessor x3pToProcessor2 = new x3pToProcessor(this.mXvGlobal.processor);
        x3pToProcessor2.xvl3FileUrl = uRL;
        if (n > 0) {
            x3pToProcessor2.numDivEdgeOnGreg = n;
        }
        if (bl = x3pToProcessor2.SetData()) {
            this.SetError(lvError.Message(this.mXvGlobal.processor));
            return true;
        }
        x3pToProcessor2 = null;
        return false;
    }

    private final boolean FromProcessor() {
        this.mXvGlobal.fromProcess = new x3pFromProcessor(this.mXvGlobal.processor);
        boolean bl = this.mXvGlobal.fromProcess.GetData();
        if (bl) {
            this.SetError(lvError.Message(this.mXvGlobal.processor));
            return true;
        }
        return false;
    }

    private final boolean TexFileToImage(URL uRL) {
        try {
            this.ErrProc().BeginThrowMode();
            this.TexFileToImageMain(uRL);
            this.ErrProc().EndThrowMode();
            return false;
        }
        catch (lvThrowable lvThrowable2) {
            this.ErrProc().EndThrowMode();
            this.SetError(lvError.Message(this.mXvGlobal.processor));
            return true;
        }
    }

    private final void TexFileToImageMain(URL uRL) throws lvThrowable {
        xvTexFileToImage xvTexFileToImage2 = new xvTexFileToImage(this.mXvGlobal, this.Rend(), uRL);
        xvTexFileToImage2.Exec();
        xvTexFileToImage2 = null;
    }

    public final void Start(Applet applet, Runnable runnable, MouseListener mouseListener, MouseMotionListener mouseMotionListener, KeyListener keyListener) {
        this.runner = new Thread(runnable);
        this.runner.start();
        this.initThread = new Init(applet, mouseListener, mouseMotionListener, keyListener);
        this.initThread.start();
        applet.requestFocus();
    }

    public final void Stop() {
        this.runner = null;
    }

    public final void Run(Applet applet) {
        while (this.runner != null) {
            this.PostKeyPressed();
            this.PrePaint();
            applet.repaint();
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.SetError(interruptedException.getMessage());
                return;
            }
        }
    }

    private final void PrePaint() {
        boolean bl;
        if (this.paintStat != 0) {
            return;
        }
        this.paintStat = 1;
        if (this.initialized && (bl = this.view.DrawScene())) {
            this.SetError(lvError.Message(this.mXvGlobal.processor));
            this.paintStat = 0;
            return;
        }
        this.paintStat = 2;
    }

    public final void Paint(Applet applet, Graphics graphics) {
        if (this.errorMessage != null) {
            this.PrintError(graphics);
            return;
        }
        if (this.paintStat != 2) {
            return;
        }
        this.paintStat = 3;
        if (!this.initialized) {
            this.PaintInit(applet, graphics);
        } else {
            this.PaintMain(applet, graphics);
        }
        this.paintStat = 0;
    }

    private final void PaintInit(Applet applet, Graphics graphics) {
        String[] stringArray = new String[]{"-", " ", "|", "/"};
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, applet.getSize().width, applet.getSize().height);
        graphics.setColor(new Color(0, 255, 0));
        graphics.drawLine(10, 26, 160, 26);
        graphics.setColor(new Color(0, 255, 0));
        graphics.drawString(stringArray[this.cntForPaintInit % 4], 10, 40);
        graphics.drawString("Now Initializing", 20, 40);
        graphics.setColor(new Color(0, 255, 0));
        long l = new Date().getTime();
        if (this.startTime < 0L) {
            this.startTime = l;
        }
        graphics.drawString(String.valueOf(l - this.startTime), 10, 52);
        ++this.cntForPaintInit;
    }

    private final void PaintMain(Applet applet, Graphics graphics) {
        Image image = this.Rend().image;
        if (image != null) {
            graphics.drawImage(image, 0, 0, applet);
        }
        if (this.cntForPaintMain > 30) {
            this.sleepTime = 10;
        } else {
            ++this.cntForPaintMain;
        }
    }

    private final void SetError(String string) {
        this.errorMessage = string;
    }

    private final void PrintError(Graphics graphics) {
        graphics.setColor(new Color(255, 0, 0));
        graphics.drawString(this.errorMessage, 10, 10);
    }

    public final void Update(Applet applet, Graphics graphics) {
        applet.paint(graphics);
    }

    public final void MousePressed(MouseEvent mouseEvent) {
        this.mouseDragInit = true;
        if (this.Rend().autoRotMat != null && this.mode == 1) {
            this.xPressed = mouseEvent.getX();
            this.yPressed = mouseEvent.getY();
            this.timePressed = new Date().getTime();
        }
    }

    public final void MouseReleased(Applet applet, MouseEvent mouseEvent) {
        if (this.Rend().autoRotMat != null && this.mode == 1) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            long l = new Date().getTime();
            if (this.xPressed == n && this.yPressed == n2) {
                this.Rend().autoRotMat.SetUnit();
                return;
            }
            int n3 = (int)(l - this.timePressed);
            double d = (double)(n - this.xPressed) / (double)n3 * 300.0;
            double d2 = (double)(n2 - this.yPressed) / (double)n3 * 300.0;
            double d3 = d2 * Math.PI / (double)applet.getSize().width * 1.5;
            double d4 = d * Math.PI / (double)applet.getSize().width * 1.5;
            this.Rend().autoRotMat.SetRotateZXY(d3, d4, 0.0);
        }
    }

    public final void MouseDragged(Applet applet, MouseEvent mouseEvent) {
        if (this.mouseDragInit) {
            this.mouseDragInit = false;
            this.prevx = mouseEvent.getX();
            this.prevy = mouseEvent.getY();
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.mode == 1) {
            double d = (double)(n2 - this.prevy) * Math.PI / (double)applet.getSize().width * 1.5;
            double d2 = (double)(n - this.prevx) * Math.PI / (double)applet.getSize().width * 1.5;
            this.Rend().view.ViewRotateDir(d, d2, 0.0);
        } else if (this.mode == 0) {
            double d = (double)(-(n - this.prevx)) * 3.0 / (double)applet.getSize().width * 1.3;
            double d3 = (double)(n2 - this.prevy) * 3.0 / (double)applet.getSize().height * 1.3;
            this.Rend().view.ViewMove(d, d3, 0.0);
        } else if (this.mode == 2) {
            lvVector lvVector2 = this.boundMin;
            lvVector lvVector3 = this.boundMax;
            double d = lvVector3.x - lvVector2.x;
            double d4 = lvVector3.y - lvVector2.y;
            double d5 = lvVector3.z - lvVector2.z;
            double d6 = (d + d4 + d5) / 3.0;
            double d7 = d6 * (double)(n - this.prevx) * 5.0 / (double)applet.getSize().width;
            double d8 = d6 * (double)(n2 - this.prevy) * 5.0 / (double)applet.getSize().height;
            this.Rend().view.ViewZoom(-d7, d8, 0.0);
        }
        this.prevx = n;
        this.prevy = n2;
    }

    public final void KeyPressed(Applet applet, KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == 'x') {
            this.mode = 1;
        } else if (c == 'z') {
            this.mode = 0;
        } else if (c == 'c') {
            this.mode = 2;
        } else if (c == 'a') {
            this.viewFitFlag = true;
        } else if (c == '2') {
            this.numDivForPress = 2;
        } else if (c == '4') {
            this.numDivForPress = 4;
        } else if (c == '6') {
            this.numDivForPress = 6;
        } else if (c == '8') {
            this.numDivForPress = 8;
        }
        if (this.numDivForPress > 0) {
            if (this.Rend().autoRotMat != null) {
                this.Rend().autoRotMat.SetUnit();
            }
            this.sleepTime = 1000;
        }
    }

    private final void PostKeyPressed() {
        this.PostKeyPressedViewFit();
        this.PostKeyPressedNumDiv();
    }

    private final void PostKeyPressedViewFit() {
        if (this.viewFitFlag) {
            this.viewFitFlag = false;
            this.Rend().view.ViewFit(this.boundMin, this.boundMax);
            if (this.Rend().autoRotMat != null) {
                this.Rend().autoRotMat.SetUnit();
            }
        }
    }

    private final void PostKeyPressedNumDiv() {
        if (this.numDivForPress > 0) {
            int n = this.numDivForPress;
            this.numDivForPress = 0;
            this.PostKeyPressedNumDivMain(n);
            boolean bl = this.FromProcessor();
            if (bl) {
                return;
            }
            xvBBox xvBBox2 = new xvBBox(this.mXvGlobal, this.Rend(), this.mXvGlobal.fromProcess);
            bl = xvBBox2.GetBBox(this.boundMin, this.boundMax);
            if (bl) {
                this.SetError("BoundBox Error");
                return;
            }
            this.sleepTime = 100;
            this.cntForPaintMain = 0;
        }
    }

    private final void PostKeyPressedNumDivMain(int n) {
        lvToKernel lvToKernel2 = new lvToKernel(this.mXvGlobal.processor);
        for (int i = 0; i < this.mXvGlobal.fromProcess.shellInfo.length; ++i) {
            lvToKernelType.Attr attr = lvToKernel2.GetAttr(i);
            attr.numDiv = n;
            boolean bl = lvToKernel2.SetAttr(i, attr);
            if (!bl) continue;
            this.SetError(lvError.Message(this.mXvGlobal.processor));
            return;
        }
        lvToKernel2 = null;
    }

    class Init
    extends Thread {
        Applet app;
        MouseListener mouse;
        MouseMotionListener mMotion;
        KeyListener key;

        public Init(Applet applet, MouseListener mouseListener, MouseMotionListener mouseMotionListener, KeyListener keyListener) {
            this.app = applet;
            this.mouse = mouseListener;
            this.mMotion = mouseMotionListener;
            this.key = keyListener;
        }

        public void run() {
            xvMain.this.Initialize(this.app, this.mouse, this.mMotion, this.key);
        }
    }
}

