/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.security.AppletSecurity;
import netscape.security.ForbiddenTargetException;
import netscape.security.ParameterizedTarget;
import netscape.security.Principal;
import netscape.security.Privilege;
import netscape.security.PrivilegeTable;
import netscape.security.SystemPrivilegeTable;
import netscape.security.Target;
import netscape.util.Archive;
import netscape.util.Archiver;
import netscape.util.CodingException;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Unarchiver;

public final class PrivilegeManager {
    public static final int PROPER_SUBSET = -1;
    public static final int EQUAL = 0;
    public static final int NO_SUBSET = 1;
    public static final int SIGNED_APPLET_DBNAME = 1;
    public static final int TEMP_FILENAME = 2;
    private Hashtable itsPrinToPrivTable = new Hashtable();
    private Hashtable itsPrinToMacroTargetPrivTable = new Hashtable();
    private static Principal theSystemPrincipal;
    private static Principal[] theSystemPrincipalAry;
    private static Target theSystemTarget;
    private static boolean theSecurityInited;
    private static Principal theUnsignedPrincipal;
    private static Principal[] theUnsignedPrincipalAry;
    private static Principal theUnknownPrincipal;
    private static Principal[] theUnknownPrincipalAry;
    static Object UpdateLock;
    private static String SignedAppletDBName;

    private static native void initClass();

    private static void init() {
        try {
            theSystemPrincipal = Principal.createSystemPrincipal();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            theSystemPrincipal = new Principal(12, "52:54:45:4e:4e:45:54:49");
        }
        theSystemPrincipalAry = new Principal[1];
        PrivilegeManager.theSystemPrincipalAry[0] = theSystemPrincipal;
        theSystemTarget = Target.findTarget("SuperUser", theSystemPrincipal);
        theUnsignedPrincipal = new Principal(12, "4a:52:4f:53:4b:49:4e:44");
        theUnsignedPrincipalAry = new Principal[1];
        PrivilegeManager.theUnsignedPrincipalAry[0] = theUnsignedPrincipal;
        theUnknownPrincipal = new Principal(12, "52:4f:53:4b:49:4e:44:4a");
        theUnknownPrincipalAry = new Principal[1];
        PrivilegeManager.theUnknownPrincipalAry[0] = theUnknownPrincipal;
    }

    public PrivilegeManager() {
        this.itsPrinToPrivTable.put((Object)PrivilegeManager.getSystemPrincipal(), (Object)new SystemPrivilegeTable());
        this.itsPrinToMacroTargetPrivTable.put((Object)PrivilegeManager.getSystemPrincipal(), (Object)new SystemPrivilegeTable());
        PrivilegeManager.initClass();
        this.load();
        if (this.isJavaSecurityDefaultTo30Enabled()) {
            Target target = Target.findTarget("30Capabilities", PrivilegeManager.getSystemPrincipal());
            Privilege privilege = Privilege.findPrivilege((int)1, (int)1);
            this.registerPrincipalAndSetPrivileges(theUnsignedPrincipal, target, privilege);
        }
    }

    private void registerPrincipal(Principal principal) {
        Hashtable hashtable = this.itsPrinToPrivTable;
        synchronized (hashtable) {
            if (this.itsPrinToPrivTable.get((Object)principal) == null) {
                this.itsPrinToPrivTable.put((Object)principal, (Object)new PrivilegeTable());
            }
        }
        hashtable = this.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            if (this.itsPrinToMacroTargetPrivTable.get((Object)principal) == null) {
                this.itsPrinToMacroTargetPrivTable.put((Object)principal, (Object)new PrivilegeTable());
            }
            return;
        }
    }

    private void unregisterPrincipal(Principal principal) {
        Object object;
        if (PrivilegeManager.getSystemPrincipal().equals((Object)principal)) {
            throw new ForbiddenTargetException("Can not delete system principal");
        }
        Hashtable hashtable = this.itsPrinToPrivTable;
        synchronized (hashtable) {
            object = this.itsPrinToPrivTable.remove((Object)principal);
            if (object == null) {
                throw new ForbiddenTargetException("Couldn't delete principal");
            }
        }
        hashtable = this.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            object = this.itsPrinToMacroTargetPrivTable.remove((Object)principal);
            if (object == null) {
                throw new ForbiddenTargetException("Couldn't delete principal");
            }
            return;
        }
    }

    private native boolean checkPrivilegeEnabled(Target[] var1, int var2, Object var3, boolean var4);

    public void checkPrivilegeEnabled(Target target) {
        Target[] targetArray = new Target[]{target};
        this.checkPrivilegeEnabled(targetArray, 1, null, true);
    }

    public void checkPrivilegeEnabled(Target target, Object object) {
        Target[] targetArray = new Target[]{target};
        this.checkPrivilegeEnabled(targetArray, 1, object, true);
    }

    public static void checkPrivilegeEnabled(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            throw new ForbiddenTargetException("access to target denied");
        }
        Target[] targetArray = new Target[]{Target.findTarget(string)};
        if (targetArray[0] == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        privilegeManager.checkPrivilegeEnabled(targetArray, 1, null, true);
    }

    boolean isPrivilegeEnabled(Target target, int n) {
        Target[] targetArray = new Target[]{target};
        return this.isPrivilegeEnabled(targetArray, n + 1, null);
    }

    boolean isPrivilegeEnabled(Target[] targetArray, int n, Object object) {
        int n2 = targetArray.length;
        while (n2-- > 0) {
            if (targetArray[n2] != null) continue;
            throw new ForbiddenTargetException("Null target is passed.");
        }
        return this.checkPrivilegeEnabled(targetArray, n + 1, object, false);
    }

    public static void enablePrivilege(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            throw new ForbiddenTargetException("access to target denied");
        }
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        privilegeManager.enablePrincipalPrivilegeHelper(target, 1, null, null);
        privilegeManager.enableScopePrivilegeHelper(target, 1, null, false, null);
    }

    public void enablePrivilege(Target target) {
        this.enablePrincipalPrivilegeHelper(target, 1, null, null);
        this.enableScopePrivilegeHelper(target, 1, null, false, null);
    }

    public void enablePrivilege(Target target, Principal principal) {
        this.enablePrincipalPrivilegeHelper(target, 1, principal, null);
        this.enableScopePrivilegeHelper(target, 1, null, false, principal);
    }

    public void enablePrivilege(Target target, Principal principal, Object object) {
        this.enablePrincipalPrivilegeHelper(target, 1, principal, object);
        this.enableScopePrivilegeHelper(target, 1, object, false, principal);
    }

    void enablePrivilege(String string, int n) {
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        this.enablePrincipalPrivilegeHelper(target, n + 1, null, null);
        this.enableScopePrivilegeHelper(target, n + 1, null, false, null);
    }

    Object setScopePrivilegeAssistant(int n) {
        return this.enableScopePrivilegeHelper(theSystemTarget, n + 1, null, true, null);
    }

    Object setScopePrivilegeAssistant(int n, String string) {
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        this.enablePrincipalPrivilegeHelper(target, n + 1, null, null);
        return this.enableScopePrivilegeHelper(target, n + 1, null, true, null);
    }

    private void enablePrincipalPrivilegeHelper(Target target, int n, Principal principal, Object object) {
        Object object2;
        Principal principal2 = null;
        Principal[] principalArray = this.getClassPrincipalsFromStackUnsafeJava(n + 1);
        if (principal != null) {
            int n2 = principalArray.length;
            while (n2-- > 0) {
                if (!principalArray[n2].equals((Object)principal) || !principalArray[n2].isCert() && !principalArray[n2].isCertFingerprint()) continue;
                principal2 = principalArray[n2];
                break;
            }
            if (principal2 == null) {
                object2 = Target.findTarget("Impersonator");
                this.checkPrivilegeEnabled((Target)object2);
                principal2 = principal;
                principalArray = new Principal[]{principal};
            }
        }
        if (this.isPermissionGranted(target, principalArray, object)) {
            return;
        }
        if (principal2 == null) {
            if (principalArray.length == 0) {
                throw new ForbiddenTargetException("request's caller has no principal!");
            }
            principal2 = principalArray[0];
        }
        object2 = UpdateLock;
        synchronized (object2) {
            if (this.isPermissionGranted(target, principalArray, object)) {
                Object var9_10 = null;
                return;
            }
            Privilege privilege = target.enablePrivilege(principal2, object);
            if (!privilege.isAllowed() && privilege.getDuration() == 1) {
                throw new ForbiddenTargetException("User didn't grant the " + target.getName() + " privilege.");
            }
            this.registerPrincipalAndSetPrivileges(principal2, target, privilege);
            if (principal2.savePrincipalPermanently() && privilege.getDuration() == 2 && !principal2.equals((Object)theUnsignedPrincipal)) {
                this.save();
            }
            if (privilege.isForbidden()) {
                throw new ForbiddenTargetException("User didn't grant the " + target.getName() + " privilege.");
            }
            return;
        }
    }

    private boolean isPermissionGranted(Target target, Principal[] principalArray, Object object) {
        int n = this.getPrincipalPrivilege(target, principalArray, object);
        switch (n) {
            case 1: {
                return true;
            }
            default: {
                throw new ForbiddenTargetException("access to target denied");
            }
            case 2: 
        }
        return false;
    }

    private Object enableScopePrivilegeHelper(Target target, int n, Object object, boolean bl, Principal principal) {
        if (principal != null) {
            this.checkPrivilegeGranted(target, principal, object);
        } else {
            this.checkPrivilegeGranted(target, n + 1, object);
        }
        PrivilegeTable privilegeTable = this.getPrivilegeTableFromStackUnsafe(n + 1, !bl);
        if (bl) {
            privilegeTable = privilegeTable != null ? (PrivilegeTable)privilegeTable.clone() : new PrivilegeTable();
        }
        Privilege privilege = Privilege.findPrivilege((int)1, (int)0);
        this.updatePrivilegeTable(target, privilegeTable, privilege);
        return privilegeTable;
    }

    private void registerPrincipalAndSetPrivileges(Principal principal, Target target, Privilege privilege) {
        this.registerPrincipal(principal);
        PrivilegeTable privilegeTable = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
        privilegeTable.put(target, privilege);
        privilegeTable = (PrivilegeTable)this.itsPrinToPrivTable.get((Object)principal);
        this.updatePrivilegeTable(target, privilegeTable, privilege);
    }

    private void updatePrivilegeTable(Target target, PrivilegeTable privilegeTable, Privilege privilege) {
        Target[] targetArray = target.getFlattenedTargetAryUnsafe();
        PrivilegeTable privilegeTable2 = privilegeTable;
        synchronized (privilegeTable2) {
            int n = targetArray.length;
            while (n-- > 0) {
                Privilege privilege2 = privilegeTable.get(targetArray[n]);
                if (privilege2 != null) {
                    privilege = Privilege.add((Privilege)privilege2, (Privilege)privilege);
                }
                privilegeTable.put(targetArray[n], privilege);
            }
            return;
        }
    }

    public void revertPrivilege(Target target) {
        this.revertPrivilege(target, 1);
    }

    public static void revertPrivilege(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            throw new ForbiddenTargetException("access to target denied");
        }
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        privilegeManager.revertPrivilege(target, 1);
    }

    void revertPrivilege() {
        PrivilegeTable privilegeTable;
        PrivilegeTable privilegeTable2 = privilegeTable = this.getPrivilegeTableFromStackUnsafe(1, true);
        synchronized (privilegeTable2) {
            privilegeTable.clear();
            return;
        }
    }

    private void revertPrivilege(Target target, int n) {
        PrivilegeTable privilegeTable;
        PrivilegeTable privilegeTable2 = privilegeTable = this.getPrivilegeTableFromStackUnsafe(n + 1, true);
        synchronized (privilegeTable2) {
            privilegeTable.put(target, Privilege.findPrivilege((int)2, (int)0));
            return;
        }
    }

    public void disablePrivilege(Target target) {
        this.disablePrivilege(target, 1);
    }

    public static void disablePrivilege(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            throw new ForbiddenTargetException("access to target denied");
        }
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        privilegeManager.disablePrivilege(target, 1);
    }

    private void disablePrivilege(Target target, int n) {
        PrivilegeTable privilegeTable = this.getPrivilegeTableFromStackUnsafe(n + 1, true);
        privilegeTable.put(target, Privilege.findPrivilege((int)0, (int)0));
    }

    private int getPrincipalPrivilege(Target target, int n) {
        return this.getPrincipalPrivilege(target, n + 1, null);
    }

    private int getPrincipalPrivilege(Target target, Principal[] principalArray) {
        return this.getPrincipalPrivilege(target, principalArray, null);
    }

    private int getPrincipalPrivilege(Target target, int n, Object object) {
        Principal[] principalArray = this.getClassPrincipalsFromStackUnsafeJava(n + 1);
        return this.getPrincipalPrivilege(target, principalArray, object);
    }

    private int getPrincipalPrivilege(Target target, Principal[] principalArray, Object object) {
        boolean bl = false;
        int n = principalArray.length;
        while (n-- > 0) {
            Privilege privilege = this.getPrincipalPrivilege(target, principalArray[n], object);
            if (privilege == null) continue;
            switch (privilege.getPermission()) {
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    return 0;
                }
                case 2: 
            }
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    Privilege getPrincipalPrivilege(Target target, Principal principal, Object object) {
        Privilege privilege;
        PrivilegeTable privilegeTable = (PrivilegeTable)this.itsPrinToPrivTable.get((Object)principal);
        if (privilegeTable == null) {
            return null;
        }
        if (target instanceof ParameterizedTarget) {
            ParameterizedTarget parameterizedTarget = (ParameterizedTarget)target;
            privilege = parameterizedTarget.getPrincipalPrivilege(principal, object);
        } else {
            privilege = privilegeTable.get(target);
        }
        return privilege;
    }

    public static void checkPrivilegeGranted(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            throw new ForbiddenTargetException("access to target denied");
        }
        Target target = Target.findTarget(string);
        if (target == null) {
            throw new ForbiddenTargetException(String.valueOf(string) + " target not found");
        }
        privilegeManager.checkPrivilegeGranted(target, 1, null);
    }

    public void checkPrivilegeGranted(Target target) {
        this.checkPrivilegeGranted(target, 1, null);
    }

    private void checkPrivilegeGranted(Target target, int n) {
        this.checkPrivilegeGranted(target, n + 1, null);
    }

    public void checkPrivilegeGranted(Target target, Object object) {
        this.checkPrivilegeGranted(target, 1, object);
    }

    private void checkPrivilegeGranted(Target target, int n, Object object) {
        int n2 = this.getPrincipalPrivilege(target, n + 1, object);
        if (n2 != 1) {
            throw new ForbiddenTargetException("access to target denied");
        }
    }

    public void checkPrivilegeGranted(Target target, Principal principal, Object object) {
        Principal[] principalArray = new Principal[]{principal};
        int n = this.getPrincipalPrivilege(target, principalArray, object);
        if (n != 1) {
            throw new ForbiddenTargetException("access to target denied");
        }
    }

    public boolean isCalledByPrincipal(Principal principal, int n) {
        Principal[] principalArray = this.getClassPrincipalsFromStackUnsafeJava(n + 1);
        int n2 = principalArray.length;
        while (n2-- > 0) {
            if (!principalArray[n2].equals((Object)principal)) continue;
            return true;
        }
        return false;
    }

    public boolean isCalledByPrincipal(Principal principal) {
        return this.isCalledByPrincipal(principal, 2);
    }

    public static Principal getSystemPrincipal() {
        if (theSystemPrincipal == null) {
            PrivilegeManager.init();
        }
        return theSystemPrincipal;
    }

    public static PrivilegeManager getPrivilegeManager() {
        return AppletSecurity.getPrivilegeManager();
    }

    private static Principal[] getSystemPrincipals() {
        try {
            return (Principal[])theSystemPrincipalAry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone System Principal");
        }
    }

    private static Principal[] getSystemPrincipalsUnsafe() {
        return theSystemPrincipalAry;
    }

    private static Principal[] getUnsignedPrincipalArray() {
        try {
            return (Principal[])theUnsignedPrincipalAry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Unsigned Principal");
        }
    }

    private static Principal[] getUnsignedPrincipalsUnsafe() {
        return theUnsignedPrincipalAry;
    }

    static Principal getUnsignedPrincipal() {
        return theUnsignedPrincipal;
    }

    private static Principal[] getUnknownPrincipalArrayUnsafe() {
        return theUnknownPrincipalAry;
    }

    static Principal[] getUnknownPrincipalArray() {
        try {
            return (Principal[])theUnknownPrincipalAry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Unknown Principal");
        }
    }

    static Principal getUnknownPrincipal() {
        return theUnknownPrincipal;
    }

    public static Principal[] getMyPrincipals() {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return null;
        }
        return privilegeManager.getClassPrincipalsFromStack(1);
    }

    public Principal[] getClassPrincipals(Class clazz) {
        Principal[] principalArray = this.getClassPrincipalsUnsafeJava(clazz);
        try {
            return (Principal[])principalArray.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Principal");
        }
    }

    public boolean hasPrincipal(Class clazz, Principal principal) {
        Principal[] principalArray = this.getClassPrincipalsUnsafeJava(clazz);
        int n = principalArray.length;
        while (n-- > 0) {
            if (!principalArray[n].equals((Object)principal)) continue;
            return true;
        }
        return false;
    }

    public int comparePrincipalArray(Principal[] principalArray, Principal[] principalArray2) {
        Integer n;
        Object object;
        Hashtable hashtable = new Hashtable();
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(0);
        int n4 = principalArray2.length;
        while (n4-- > 0) {
            hashtable.put((Object)principalArray2[n4], (Object)n2);
        }
        int n5 = principalArray.length;
        while (n5-- > 0) {
            object = principalArray[n5];
            n = (Integer)hashtable.get(object);
            if (n == null) {
                return 1;
            }
            if (n != n2) continue;
            hashtable.put(object, (Object)n3);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            n = (Integer)hashtable.get(object);
            if (n != n2) continue;
            return -1;
        }
        return 0;
    }

    public Principal[] intersectPrincipalArray(Principal[] principalArray, Principal[] principalArray2) {
        boolean[] blArray = new boolean[principalArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < principalArray.length) {
            int n3 = 0;
            while (n3 < principalArray2.length) {
                if (principalArray[n2].equals((Object)principalArray2[n3])) {
                    blArray[n2] = true;
                    ++n;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        Principal[] principalArray3 = new Principal[n];
        int n4 = 0;
        int n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5]) {
                principalArray3[n4++] = principalArray[n5];
            }
            ++n5;
        }
        return principalArray3;
    }

    public boolean canExtendTrust(Principal[] principalArray, Principal[] principalArray2) {
        Principal[] principalArray3 = this.intersectPrincipalArray(principalArray, principalArray2);
        if (principalArray3.length == principalArray.length) {
            return true;
        }
        if (principalArray3.length == 0 || principalArray3.length != principalArray.length - 1) {
            return false;
        }
        int n = 0;
        while (n < principalArray3.length) {
            if (principalArray3[n].isCodebase()) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < principalArray.length) {
            if (principalArray[n3].isCodebase()) {
                ++n2;
            }
            ++n3;
        }
        return n2 == true;
    }

    public boolean checkMatchPrincipal(Class clazz, int n) {
        return this.comparePrincipalArray(this.getClassPrincipalsFromStack(n + 1), this.getClassPrincipalsUnsafeJava(clazz)) != 1;
    }

    public boolean checkMatchPrincipal(Principal principal, int n) {
        Principal[] principalArray = new Principal[]{principal};
        return this.comparePrincipalArray(principalArray, this.getClassPrincipalsFromStack(n + 1)) != 1;
    }

    public boolean checkMatchPrincipal(Class clazz) {
        return this.checkMatchPrincipal(clazz, 1);
    }

    public boolean checkMatchPrincipalAlways() {
        return SecurityManager.checksMatchPrincipalAlways((int)1);
    }

    public Principal[] getClassPrincipalsFromStack(int n) {
        Principal[] principalArray = this.getClassPrincipalsFromStackUnsafeJava(n + 1);
        try {
            return (Principal[])principalArray.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ForbiddenTargetException("internal error: unable to clone Principal");
        }
    }

    private Principal[] getClassPrincipalsFromStackUnsafeJava(int n) {
        Principal[] principalArray = this.getClassPrincipalsFromStackUnsafe(n + 1);
        if (principalArray == null) {
            if (!this.getJavaSecurityEnabled()) {
                System.out.println("Java Navigator Beta internal error message: Defaulting to system principal");
                return PrivilegeManager.getSystemPrincipalsUnsafe();
            }
            return PrivilegeManager.getUnknownPrincipalArray();
        }
        return principalArray;
    }

    private Principal[] getClassPrincipalsUnsafeJava(Class clazz) {
        Principal[] principalArray = this.getClassPrincipalsUnsafe(clazz);
        if (principalArray == null) {
            if (!this.getJavaSecurityEnabled()) {
                System.out.println("Java Navigator Beta internal error message: Defaulting to system principal");
                return PrivilegeManager.getSystemPrincipalsUnsafe();
            }
            return PrivilegeManager.getUnknownPrincipalArray();
        }
        return principalArray;
    }

    PrivilegeTable getPrivilegeTableFromStack(int n) {
        PrivilegeTable privilegeTable = this.getPrivilegeTableFromStackUnsafe(n + 1, false);
        if (privilegeTable == null) {
            return null;
        }
        return (PrivilegeTable)privilegeTable.clone();
    }

    public PrivilegeTable getPrivilegeTableFromStack() {
        return this.getPrivilegeTableFromStack(2);
    }

    private native Principal[] getClassPrincipalsFromStackUnsafe(int var1);

    private native Principal[] getClassPrincipalsUnsafe(Class var1);

    private native PrivilegeTable getPrivilegeTableFromStackUnsafe(int var1, boolean var2);

    native boolean getJavaSecurityEnabled();

    synchronized native int getPrivilegeFromUser(String var1, String var2, String var3, boolean var4);

    native boolean showDocument(String var1, String var2);

    native boolean isJavaSecurityDefaultTo30Enabled();

    native boolean getBoolPref(String var1);

    private native String getWHFileName(String var1, int var2);

    native boolean picsCanUserEnableAdditionalJavaCapabilities();

    Principal[] getAllPrincipals() {
        Principal[] principalArray;
        int n = 0;
        Hashtable hashtable = this.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            int n2 = this.itsPrinToMacroTargetPrivTable.size();
            if (n2 == 0) {
                Principal[] principalArray2 = null;
                Object var7_5 = null;
                return principalArray2;
            }
            principalArray = new Principal[n2];
            Enumeration enumeration = this.itsPrinToMacroTargetPrivTable.keys();
            while (enumeration.hasMoreElements()) {
                Principal principal = (Principal)enumeration.nextElement();
                principalArray[n++] = principal;
            }
        }
        return principalArray;
    }

    static String getAllPrincipalsString() {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return null;
        }
        Principal[] principalArray = privilegeManager.getAllPrincipals();
        if (principalArray == null) {
            return null;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        int n = principalArray.length;
        while (n-- > 0) {
            if (!privilegeManager.principalHasPrivileges(principalArray[n])) continue;
            if (bl) {
                stringBuffer.append("\"" + principalArray[n].toString() + "\"");
                bl = false;
                continue;
            }
            stringBuffer.append(",\"" + principalArray[n].toString() + "\"");
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    private Principal getPrincipalFromString(String string) {
        Principal[] principalArray = this.getAllPrincipals();
        if (principalArray == null) {
            return null;
        }
        int n = principalArray.length;
        while (n-- > 0) {
            if (!string.equals(principalArray[n].toString())) continue;
            return principalArray[n];
        }
        return null;
    }

    boolean principalHasPrivileges(Principal principal) {
        PrivilegeTable privilegeTable;
        Hashtable hashtable = this.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            privilegeTable = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
        }
        return privilegeTable != null && privilegeTable.size() != 0;
    }

    static String[] getTargetsWithPrivileges(String string) {
        PrivilegeTable privilegeTable;
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return null;
        }
        Principal principal = privilegeManager.getPrincipalFromString(string);
        if (principal == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String[] stringArray = new String[3];
        Hashtable hashtable = privilegeManager.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            privilegeTable = (PrivilegeTable)privilegeManager.itsPrinToMacroTargetPrivTable.get((Object)principal);
        }
        Enumeration enumeration = privilegeTable.keys();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            Privilege privilege = privilegeTable.get(target);
            String string2 = target.getDescription();
            if (privilege.isAllowed()) {
                if (privilege.getDuration() == 2) {
                    stringBuffer.append("<option>" + string2);
                    continue;
                }
                stringBuffer2.append("<option>" + string2);
                continue;
            }
            if (!privilege.isForbidden()) continue;
            stringBuffer3.append("<option>" + string2);
        }
        stringArray[0] = stringBuffer.toString();
        stringArray[1] = stringBuffer2.toString();
        stringArray[2] = stringBuffer3.toString();
        return stringArray;
    }

    private Target getTargetFromString(Principal principal, String string) {
        PrivilegeTable privilegeTable = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
        Enumeration enumeration = privilegeTable.keys();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (!string.equals(target.getDescription())) continue;
            return target;
        }
        return null;
    }

    static String[] getTargetDetails(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return null;
        }
        Target target = Target.getTargetFromDescription(string);
        if (target == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Target[] targetArray = target.getFlattenedTargetAryUnsafe();
        int n = targetArray.length;
        while (n-- > 0) {
            stringBuffer.append("<option>" + targetArray[n].getDescription() + " (" + targetArray[n].getRisk() + ")");
        }
        String[] stringArray = new String[]{stringBuffer.toString(), target.getRisk()};
        return stringArray;
    }

    static boolean removePrincipal(String string) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return false;
        }
        Principal principal = privilegeManager.getPrincipalFromString(string);
        if (principal == null) {
            return false;
        }
        try {
            privilegeManager.removeAllParameterizedTargets(principal);
            privilegeManager.unregisterPrincipal(principal);
        }
        catch (Exception exception) {
            System.out.println("Unable to delete principal " + principal + " " + exception);
            exception.printStackTrace(System.out);
            return false;
        }
        privilegeManager.save();
        return true;
    }

    static boolean removePrincipalsPrivilege(String string, String string2) {
        ParameterizedTarget parameterizedTarget;
        PrivilegeTable privilegeTable;
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager == null) {
            return false;
        }
        Principal principal = privilegeManager.getPrincipalFromString(string);
        if (principal == null) {
            return false;
        }
        Target target = privilegeManager.getTargetFromString(principal, string2);
        if (target == null) {
            return false;
        }
        Hashtable hashtable = privilegeManager.itsPrinToMacroTargetPrivTable;
        synchronized (hashtable) {
            privilegeTable = (PrivilegeTable)privilegeManager.itsPrinToMacroTargetPrivTable.get((Object)principal);
            if (target instanceof ParameterizedTarget) {
                parameterizedTarget = (ParameterizedTarget)target;
                parameterizedTarget.unregisterPrincipal(principal);
            }
            privilegeTable.remove(target);
        }
        hashtable = privilegeManager.itsPrinToPrivTable;
        synchronized (hashtable) {
            parameterizedTarget = new PrivilegeTable();
            privilegeManager.itsPrinToPrivTable.put((Object)principal, (Object)parameterizedTarget);
            Enumeration enumeration = privilegeTable.keys();
            while (enumeration.hasMoreElements()) {
                Target target2 = (Target)enumeration.nextElement();
                Privilege privilege = privilegeTable.get(target2);
                privilegeManager.updatePrivilegeTable(target2, (PrivilegeTable)parameterizedTarget, privilege);
            }
        }
        privilegeManager.save();
        return true;
    }

    void removeAllParameterizedTargets(Principal principal) {
        Hashtable hashtable = this.itsPrinToPrivTable;
        synchronized (hashtable) {
            PrivilegeTable privilegeTable = (PrivilegeTable)this.itsPrinToPrivTable.get((Object)principal);
            Enumeration enumeration = privilegeTable.keys();
            while (enumeration.hasMoreElements()) {
                Target target = (Target)enumeration.nextElement();
                if (!(target instanceof ParameterizedTarget)) continue;
                ParameterizedTarget parameterizedTarget = (ParameterizedTarget)target;
                parameterizedTarget.unregisterPrincipal(principal);
            }
            return;
        }
    }

    String getArchiveFileName() {
        if (SignedAppletDBName == null) {
            SignedAppletDBName = this.getWHFileName("", 1);
        }
        return SignedAppletDBName;
    }

    String getArchiveFileName(String string) {
        return this.getWHFileName(string, 1);
    }

    private synchronized void save() {
        FileOutputStream fileOutputStream;
        SecurityManager.enablePrivilege((String)"UniversalFileWrite");
        String string = this.getArchiveFileName();
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error1: can't open <" + string + "> to save java capabilities list");
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error2: can't open <" + string + "> to save java capabilities list");
            return;
        }
        try {
            this.save(fileOutputStream);
        }
        catch (Exception exception) {
            System.err.println("Error: unable to save java capabilities list into <" + string + "> " + exception);
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error while saving java capabilities list into <" + string + ">");
            return;
        }
    }

    private void save(OutputStream outputStream) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.itsPrinToMacroTargetPrivTable.keys();
        while (enumeration.hasMoreElements()) {
            PrivilegeTable privilegeTable;
            Principal principal = (Principal)enumeration.nextElement();
            PrivilegeTable privilegeTable2 = privilegeTable = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
            synchronized (privilegeTable2) {
                PrivilegeTable privilegeTable3 = new PrivilegeTable();
                Enumeration enumeration2 = privilegeTable.keys();
                while (enumeration2.hasMoreElements()) {
                    Target target = (Target)enumeration2.nextElement();
                    Privilege privilege = privilegeTable.get(target);
                    switch (privilege.getDuration()) {
                        case 2: {
                            privilegeTable3.put(target, privilege);
                        }
                    }
                }
                if (privilegeTable3.size() > 0) {
                    hashtable.put((Object)principal, (Object)privilegeTable3);
                }
            }
        }
        Archive archive = new Archive();
        Archiver archiver = new Archiver(archive);
        try {
            archiver.archiveRootObject((Object)hashtable);
        }
        catch (CodingException codingException) {
            System.err.println("Internal error during archiving of Capabilities");
            codingException.printStackTrace(System.out);
            return;
        }
        try {
            archive.write(outputStream);
            return;
        }
        catch (Exception exception) {
            System.err.println("Error during serializing java Capabilities " + exception);
            return;
        }
    }

    boolean isSecurityInited() {
        return theSecurityInited;
    }

    private synchronized void load() {
        if (theSecurityInited) {
            return;
        }
        FileInputStream fileInputStream = null;
        String string = this.getArchiveFileName();
        SecurityManager.enablePrivilege((String)"UniversalFileRead");
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            fileInputStream = null;
        }
        if (fileInputStream == null) {
            string = this.getArchiveFileName("0");
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                return;
            }
        }
        this.load(fileInputStream);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error while reading java Capabilities file <" + string + ">");
            return;
        }
        theSecurityInited = true;
    }

    private void load(InputStream inputStream) {
        Object object;
        int[] nArray = null;
        Archive archive = new Archive();
        try {
            archive.read(inputStream);
        }
        catch (Exception exception) {
            System.err.println("Error: unable to read java Capabilities from archive " + exception);
            return;
        }
        nArray = archive.rootIdentifiers();
        Unarchiver unarchiver = new Unarchiver(archive);
        try {
            object = unarchiver.unarchiveIdentifier(nArray[0]);
        }
        catch (Exception exception) {
            System.err.println("Error: old java capabilites list was lost " + exception);
            return;
        }
        if (object == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)object;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            PrivilegeTable privilegeTable = (PrivilegeTable)hashtable.get((Object)principal);
            this.registerPrincipal(principal);
            PrivilegeTable privilegeTable2 = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
            Enumeration enumeration2 = privilegeTable.keys();
            while (enumeration2.hasMoreElements()) {
                Target target = (Target)enumeration2.nextElement();
                Privilege privilege = privilegeTable.get(target);
                Target target2 = Target.findTarget(target);
                if (target2 == null) {
                    target2 = target.registerTarget();
                }
                privilege = Privilege.findPrivilege((int)privilege.getPermission(), (int)privilege.getDuration());
                privilegeTable2.put(target2, privilege);
            }
        }
        this.explodePrivilege();
    }

    private void explodePrivilege() {
        Enumeration enumeration = this.itsPrinToMacroTargetPrivTable.keys();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            PrivilegeTable privilegeTable = (PrivilegeTable)this.itsPrinToMacroTargetPrivTable.get((Object)principal);
            PrivilegeTable privilegeTable2 = (PrivilegeTable)this.itsPrinToPrivTable.get((Object)principal);
            Enumeration enumeration2 = privilegeTable.keys();
            while (enumeration2.hasMoreElements()) {
                Target target = (Target)enumeration2.nextElement();
                Privilege privilege = privilegeTable.get(target);
                this.updatePrivilegeTable(target, privilegeTable2, privilege);
            }
        }
    }

    static {
        UpdateLock = new Object();
        SignedAppletDBName = null;
    }
}

