/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import netscape.applet.CastanetChannelInfo;
import netscape.security.AppletSecurityException;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.security.UserTarget;

public class AppletSecurity
extends SecurityManager {
    private static final boolean MARIMBA_ENABLED = true;
    private static boolean debug;
    static final int NETWORK_NONE = 1;
    static final int NETWORK_HOST = 2;
    static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    int networkMode;
    private static Target UniversalThreadAccessTarget;
    private static Target UniversalThreadGroupAccessTarget;
    private static Target UniversalExitAccessTarget;
    private static Target UniversalExecAccessTarget;
    private static Target UniversalLinkAccessTarget;
    private static Target UniversalPropertyWriteTarget;
    private static Target UniversalPropertyReadTarget;
    private static Target UniversalFileReadTarget;
    private static Target ParamFileReadTarget;
    private static Target UniversalFileWriteTarget;
    private static Target UniversalFileDeleteTarget;
    private static Target ParamFileWriteTarget;
    private static Target UniversalFdReadTarget;
    private static Target UniversalFdWriteTarget;
    private static Target UniversalListenTarget;
    private static Target UniversalAcceptTarget;
    private static Target UniversalConnectTarget;
    private static Target UniversalMulticastTarget;
    private static Target UniversalTopLevelWindowTarget;
    private static Target UniversalPackageAccessTarget;
    private static Target UniversalPackageDefinitionTarget;
    private static Target UniversalSetFactoryTarget;
    private static Target UniversalMemberAccessTarget;
    private static Target UniversalPrintJobAccessTarget;
    private static Target UniversalSystemClipboardAccessTarget;
    private static Target UniversalAwtEventQueueAccessTarget;
    private static Target UniversalSecurityProviderTarget;
    private static Target CreateSecurityManagerTarget;
    private static Target SuperUserTarget;
    private static PrivilegeManager privMgr;
    private static Class atg;

    public AppletSecurity() {
        this.reset();
        this.initTargets();
        UserTarget.createAwtDialog();
    }

    void reset() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        String string = System.getProperty("appletviewer.security.mode");
        if (string == null) {
            string = "host";
        }
        if (string.equals("unrestricted")) {
            this.networkMode = 3;
            return;
        }
        if (string.equals("none")) {
            this.networkMode = 1;
            return;
        }
        this.networkMode = 2;
    }

    private void initTargets() {
        UniversalThreadAccessTarget = Target.findTarget("UniversalThreadAccess");
        UniversalThreadGroupAccessTarget = Target.findTarget("UniversalThreadGroupAccess");
        UniversalExitAccessTarget = Target.findTarget("UniversalExitAccess");
        UniversalExecAccessTarget = Target.findTarget("UniversalExecAccess");
        UniversalLinkAccessTarget = Target.findTarget("UniversalLinkAccess");
        UniversalPropertyWriteTarget = Target.findTarget("UniversalPropertyWrite");
        UniversalPropertyReadTarget = Target.findTarget("UniversalPropertyRead");
        UniversalFileReadTarget = Target.findTarget("UniversalFileRead");
        ParamFileReadTarget = Target.findTarget("FileRead");
        UniversalFileWriteTarget = Target.findTarget("UniversalFileWrite");
        UniversalFileDeleteTarget = Target.findTarget("UniversalFileDelete");
        ParamFileWriteTarget = Target.findTarget("FileWrite");
        UniversalFdReadTarget = Target.findTarget("UniversalFdRead");
        UniversalFdWriteTarget = Target.findTarget("UniversalFdWrite");
        UniversalListenTarget = Target.findTarget("UniversalListen");
        UniversalAcceptTarget = Target.findTarget("UniversalAccept");
        UniversalConnectTarget = Target.findTarget("UniversalConnect");
        UniversalMulticastTarget = Target.findTarget("UniversalMulticast");
        UniversalTopLevelWindowTarget = Target.findTarget("UniversalTopLevelWindow");
        UniversalPackageAccessTarget = Target.findTarget("UniversalPackageAccess");
        UniversalPackageDefinitionTarget = Target.findTarget("UniversalPackageDefinition");
        UniversalSetFactoryTarget = Target.findTarget("UniversalSetFactory");
        UniversalMemberAccessTarget = Target.findTarget("UniversalMemberAccess");
        UniversalPrintJobAccessTarget = Target.findTarget("UniversalPrintJobAccess");
        UniversalSystemClipboardAccessTarget = Target.findTarget("UniversalSystemClipboardAccess");
        UniversalAwtEventQueueAccessTarget = Target.findTarget("UniversalAwtEventQueueAccess");
        UniversalSecurityProviderTarget = Target.findTarget("UniversalSecurityProvider");
        CreateSecurityManagerTarget = Target.findTarget("CreateSecurityManager");
        SuperUserTarget = Target.findTarget("SuperUser");
    }

    boolean fromApplet() {
        return this.checkClassLoader(1);
    }

    boolean inApplet() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return null;
        }
        return classLoader.getCodeBase();
    }

    public static void setPrivilegeManager(PrivilegeManager privilegeManager) {
        if (privMgr != null) {
            throw new SecurityException("PrivilegeManager already set");
        }
        privMgr = privilegeManager;
    }

    public static PrivilegeManager getPrivilegeManager() {
        return privMgr;
    }

    public static void enablePrivilege(String string) {
        privMgr.enablePrivilege(string, 1);
    }

    protected synchronized void checkCreateClassLoader(int n) {
        if (privMgr == null) {
            return;
        }
        Target target = Target.findTarget("MarimbaInternalTarget");
        if (privMgr.isPrivilegeEnabled(target, n + 1)) {
            return;
        }
        if (this.checkClassLoader(n + 1)) {
            throw new AppletSecurityException("checkcreateclassloader");
        }
    }

    private boolean isAppletThreadGroup(ThreadGroup threadGroup) {
        if (atg == null) {
            try {
                atg = Class.forName("netscape.applet.AppletThreadGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        if (threadGroup == null) {
            return false;
        }
        Class<?> clazz = threadGroup.getClass();
        while (clazz != null) {
            if (clazz == atg) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    protected synchronized void checkAccess(Thread thread, int n) {
        if (privMgr != null) {
            if (this.isAppletThreadGroup(thread.getThreadGroup())) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadAccessTarget, n + 1)) {
                if (this.marimbaCheckThreadGroup(thread.getThreadGroup())) {
                    return;
                }
                throw new AppletSecurityException(UniversalThreadAccessTarget, "thread");
            }
        }
    }

    protected synchronized void checkAccess(Thread thread, Throwable throwable, int n) {
        if (privMgr != null) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadAccessTarget, n + 1)) {
                throw new AppletSecurityException(UniversalThreadAccessTarget, "thread can't send exception");
            }
        }
    }

    public synchronized void checkAccess(ThreadGroup threadGroup, int n) {
        if (privMgr != null) {
            if (this.isAppletThreadGroup(threadGroup)) {
                return;
            }
            if (!privMgr.isPrivilegeEnabled(UniversalThreadGroupAccessTarget, n + 1)) {
                if (this.marimbaCheckThreadGroup(threadGroup)) {
                    return;
                }
                throw new AppletSecurityException(UniversalThreadGroupAccessTarget, "threadgroup", threadGroup.toString());
            }
        }
    }

    protected synchronized void checkExit(int n, int n2) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalExitAccessTarget, n2 + 1)) {
            throw new AppletSecurityException(UniversalExitAccessTarget, "checkexit", String.valueOf(n));
        }
    }

    protected synchronized void checkExec(String string, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalExecAccessTarget, n + 1)) {
            throw new AppletSecurityException(UniversalExecAccessTarget, "checkexec", string);
        }
    }

    protected synchronized void checkLink(String string, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalLinkAccessTarget, n + 1)) {
            throw new AppletSecurityException(UniversalLinkAccessTarget, "checklink", string);
        }
    }

    protected synchronized void checkPropertiesAccess(int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyWriteTarget, n + 1)) {
            throw new AppletSecurityException(UniversalPropertyWriteTarget, "checkpropsaccess");
        }
    }

    protected synchronized void checkPropertyAccess(String string, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPropertyReadTarget, n + 1)) {
            throw new AppletSecurityException(UniversalPropertyReadTarget, "checkpropsaccess.key");
        }
    }

    protected synchronized void checkRead(String string, int n) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null) {
            this.checkRead(string, classLoader.getCodeBase(), n + 1);
            return;
        }
        this.checkRead(string, null, n + 1);
    }

    private static boolean directoryContainsFile(String string, String string2) {
        SecurityManager.enablePrivilege((String)"UniversalFileRead");
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        try {
            string2 = new File(string2).getCanonicalPath();
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        if (string2.equals(string)) {
            return true;
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n = string.length();
        if (string2.charAt(n) == File.separatorChar) {
            return true;
        }
        return n > 0 && string.charAt(n - 1) == File.separatorChar;
    }

    private static String unEscapeFileSpecificChars(String string) {
        int n;
        String string2 = string;
        int n2 = 0;
        while ((n = string2.indexOf(37, n2)) >= 0) {
            n2 = n + 1;
            String string3 = null;
            int n3 = n + 3;
            if (n3 > string2.length()) continue;
            String string4 = string2.substring(n + 1, n3);
            try {
                string3 = new Character((char)Integer.parseInt(string4, 16)).toString();
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (":/.\\|".indexOf(string3) == -1) continue;
            string2 = String.valueOf(string2.substring(0, n)) + string3 + string2.substring(n3);
        }
        if (File.separatorChar == '\\') {
            if (string2.charAt(0) == '/' && (string2.charAt(2) == '|' || string2.charAt(2) == ':')) {
                string2 = string2.substring(1);
            }
            if (string2.charAt(1) == '|') {
                string2 = String.valueOf(string2.substring(0, 1)) + ":" + string2.substring(2);
            }
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    protected synchronized void checkRead(String string, URL uRL, int n) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFileReadTarget, n + 1)) {
            return;
        }
        Target[] targetArray = new Target[]{ParamFileReadTarget};
        if (privMgr.isPrivilegeEnabled(targetArray, n + 1, string)) {
            return;
        }
        String string2 = null;
        if (uRL != null && uRL.getProtocol().equals("file") && AppletSecurity.directoryContainsFile(string2 = AppletSecurity.unEscapeFileSpecificChars(uRL.getFile()), string)) {
            return;
        }
        if (this.marimbaCheckAccess(string, true)) {
            return;
        }
        if (string2 != null) {
            throw new AppletSecurityException(UniversalFileReadTarget, "checkread", "Codebase '" + string2 + "' does not include '" + string + "'");
        }
        throw new AppletSecurityException(UniversalFileReadTarget, "checkread", "Read of '" + string + "' not permitted");
    }

    protected void checkRead(String string, Object object, int n) {
        this.checkRead(string);
        if (object != null) {
            this.checkRead(string, (URL)object, n + 1);
        }
    }

    protected synchronized void checkWrite(String string, int n) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFileWriteTarget, n + 1)) {
            return;
        }
        Target[] targetArray = new Target[]{ParamFileWriteTarget};
        if (privMgr.isPrivilegeEnabled(targetArray, n + 1, string)) {
            return;
        }
        if (this.marimbaCheckAccess(string, false)) {
            return;
        }
        throw new AppletSecurityException(UniversalFileWriteTarget, "checkwrite", string);
    }

    protected synchronized void checkRead(FileDescriptor fileDescriptor, int n) {
        if (!fileDescriptor.valid()) {
            throw new AppletSecurityException("checkread", "invalid file descriptor");
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFdReadTarget, n + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalFdReadTarget, "checkread");
    }

    protected synchronized void checkWrite(FileDescriptor fileDescriptor, int n) {
        if (!fileDescriptor.valid()) {
            throw new AppletSecurityException("checkwrite.fd", "invalid file descriptor");
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalFdWriteTarget, n + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalFdWriteTarget, "fd.write");
    }

    protected synchronized void checkDelete(String string, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalFileDeleteTarget, n + 1)) {
            if (this.marimbaCheckAccess(string, false)) {
                return;
            }
            throw new AppletSecurityException(UniversalFileDeleteTarget, "checkdelete", string);
        }
    }

    protected synchronized void checkListen(int n, int n2) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalListenTarget, n2 + 1)) {
            return;
        }
        if (n > 0 && n < 1024) {
            throw new AppletSecurityException(UniversalListenTarget, "checklisten", String.valueOf(n));
        }
    }

    protected synchronized void checkAccept(String string, int n, int n2) {
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalAcceptTarget, n2 + 1)) {
            return;
        }
        if (n > 0 && n < 1024) {
            throw new AppletSecurityException(UniversalAcceptTarget, "checkaccept", string, String.valueOf(n));
        }
        this.checkConnect(string, n, n2 + 1);
    }

    protected synchronized void checkConnect(String string, int n, int n2) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, n2 + 1)) {
                return;
            }
            if (privMgr.getBoolPref("signed.applets.low_security_for_local_classes")) {
                return;
            }
            throw new AppletSecurityException(UniversalConnectTarget, AppletSecurity.connectErrorString("local-classpath-classes", string));
        }
        String string2 = CastanetChannelInfo.marimbaGetHost((ClassLoader)classLoader);
        if (string2 == null) {
            string2 = classLoader.getCodeBase().getHost();
        }
        this.checkConnect(string2, string, n2 + 1);
    }

    protected void checkConnect(String string, int n, Object object, int n2) {
        this.checkConnect(string, n, n2 + 1);
        if (object != null) {
            this.checkConnect(((URL)object).getHost(), string, n2 + 1);
        }
    }

    private static String connectErrorString(String string, String string2) {
        return "Couldn't connect to '" + string2 + "' with origin from '" + string + "'.";
    }

    /*
     * Exception decompiling
     */
    protected synchronized void checkConnect(String var1_1, String var2_2, boolean var3_3, int var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized void checkConnect(String string, String string2, int n) {
        this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"), n + 1);
    }

    protected synchronized void checkURLConnect(URL uRL, int n) {
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, n + 1)) {
            return;
        }
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            if (privMgr.getBoolPref("signed.applets.low_security_for_local_classes")) {
                return;
            }
            throw new AppletSecurityException(UniversalConnectTarget, "class from local disk trying to access url", uRL.toExternalForm());
        }
        this.checkURLConnectHelper(classLoader.getCodeBase(), uRL, n + 1);
    }

    protected synchronized void checkURLConnect(URL uRL, URL uRL2, int n) {
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalConnectTarget, n + 1)) {
            return;
        }
        this.checkURLConnectHelper(uRL, uRL2, n + 1);
    }

    private synchronized void checkURLConnectHelper(URL uRL, URL uRL2, int n) {
        String string = uRL2.getProtocol();
        String string2 = null;
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null) {
            string2 = CastanetChannelInfo.marimbaGetHost((ClassLoader)classLoader);
        }
        if (string2 == null) {
            string2 = uRL.getHost();
        }
        this.checkConnect(string2, uRL2.getHost(), n + 1);
        String string3 = uRL.getProtocol();
        if (string.equals("http") || string.equals("https") || string.equals("tuner") || string.equals("ftp") || string.equals("gopher")) {
            if (string3.equals("http") || string3.equals("https") || string3.equals("tuner")) {
                return;
            }
            throw new AppletSecurityException("protocol", "Cannot access '" + string + "' from a codebase protocol of '" + string3 + "'");
        }
        if (string.equals("file") && string3.equals("file")) {
            String string4 = AppletSecurity.unEscapeFileSpecificChars(uRL2.getFile());
            this.checkRead(string4, uRL, n + 1);
            return;
        }
        throw new AppletSecurityException("protocol", string);
    }

    protected void checkMulticast(InetAddress inetAddress, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalMulticastTarget, n + 1)) {
            throw new AppletSecurityException(UniversalMulticastTarget, "can not access IP multicast");
        }
    }

    protected void checkMulticast(InetAddress inetAddress, byte by, int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalMulticastTarget, n + 1)) {
            throw new AppletSecurityException(UniversalMulticastTarget, "can not access IP multicast");
        }
    }

    public synchronized boolean checkTopLevelWindow(Object object) {
        this.marimbaCheckTopLevelWindow(object);
        return privMgr == null || privMgr.isPrivilegeEnabled(UniversalTopLevelWindowTarget, 2);
    }

    public synchronized void checkPackageAccess(String string) {
        if (!this.inClassLoader()) {
            return;
        }
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalPackageAccessTarget, 2)) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.access." + string2)) {
                throw new AppletSecurityException(UniversalPackageAccessTarget, "checkpackageaccess", string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkPackageDefinition(String string) {
        if (!this.inClassLoader()) {
            return;
        }
        if (privMgr == null || privMgr.isPrivilegeEnabled(UniversalPackageDefinitionTarget, 2)) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.definition." + string2)) {
                throw new AppletSecurityException(UniversalPackageDefinitionTarget, "cannot define package:" + string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkSetFactory() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSetFactoryTarget, 2)) {
            throw new AppletSecurityException(UniversalSetFactoryTarget, "cannot set factory");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        this.checkMemberAccess(clazz, n, 2);
    }

    protected void checkMemberAccess(Class clazz, int n, int n2) {
        if (n == 0) {
            return;
        }
        if (privMgr == null) {
            return;
        }
        if (privMgr.isPrivilegeEnabled(UniversalMemberAccessTarget, n2 + 1)) {
            return;
        }
        throw new AppletSecurityException(UniversalMemberAccessTarget, "member access");
    }

    public void checkPrintJobAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalPrintJobAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalPrintJobAccessTarget, "checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSystemClipboardAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalSystemClipboardAccessTarget, "checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalAwtEventQueueAccessTarget, 2)) {
            throw new AppletSecurityException(UniversalAwtEventQueueAccessTarget, "checkawteventqueueaccess");
        }
    }

    public void checkSecurityAccess(String string) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(UniversalSecurityProviderTarget, 2)) {
            throw new AppletSecurityException(UniversalSecurityProviderTarget, "security operation: " + string);
        }
    }

    protected void checkCreateSecurityManagerAccess(int n) {
        if (privMgr != null && !privMgr.isPrivilegeEnabled(CreateSecurityManagerTarget, n + 1)) {
            throw new AppletSecurityException(CreateSecurityManagerTarget, "can't create SecurityManager");
        }
    }

    protected void unknownLoaderException(String string) {
        throw new SecurityException("unknown class loader type.unable to check for " + string);
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    protected boolean isPrivilegeEnabled(String string, int n) {
        if (privMgr != null) {
            Target target = Target.findTarget(string);
            if (target == null) {
                return false;
            }
            return privMgr.isPrivilegeEnabled(target, n + 1);
        }
        return true;
    }

    protected boolean securityCheckScopePermission(int n) {
        if (privMgr != null) {
            return privMgr.isPrivilegeEnabled(SuperUserTarget, n + 1);
        }
        return true;
    }

    protected Object securitySetScopePermission(int n) {
        if (privMgr != null) {
            return privMgr.setScopePrivilegeAssistant(n + 1);
        }
        return null;
    }

    protected Object securitySetScopePermission(int n, String string) {
        if (privMgr != null) {
            return privMgr.setScopePrivilegeAssistant(n + 1, string);
        }
        return null;
    }

    public boolean checkMatchPrincipalAlways(int n) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return true;
        }
        return classLoader.checkMatchPrincipalAlways(n + 1);
    }

    private boolean marimbaCheckThreadGroup(ThreadGroup threadGroup) {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            return false;
        }
        return CastanetChannelInfo.checkThreadGroup((ClassLoader)classLoader, (ThreadGroup)threadGroup);
    }

    private void marimbaCheckTopLevelWindow(Object object) {
        ClassLoader classLoader = this.currentClassLoader();
        CastanetChannelInfo.checkTopLevelWindow((ClassLoader)classLoader, (Object)object);
    }

    private boolean marimbaCheckAccess(String string, boolean bl) {
        Object object;
        boolean bl2 = false;
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        if (privilegeManager != null) {
            try {
                object = Target.findTarget("MarimbaAppContextTarget");
                if (object != null) {
                    privilegeManager.checkPrivilegeEnabled((Target)object);
                    bl2 = true;
                }
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                bl2 = false;
            }
        }
        object = this.currentClassLoader();
        if (!bl2 && object == null) {
            return false;
        }
        return CastanetChannelInfo.marimbaCheckAccess((String)string, (ClassLoader)object, (boolean)bl, (boolean)bl2);
    }

    public ClassLoader getCurrentClassLoader() {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        Target target = Target.findTarget("MarimbaAppContextTarget");
        privilegeManager.checkPrivilegeEnabled(target);
        return this.currentClassLoader();
    }
}

