/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.DataInput;
import java.io.IOException;

public final class PlywoodClassConstant {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    private final int tag;
    private final Object value;

    public final boolean isUtf8() {
        return 1 == this.tag;
    }

    public PlywoodClassConstant(DataInput dataInput) throws ClassFormatError, IOException {
        this.tag = dataInput.readUnsignedByte();
        switch (this.tag) {
            case 7: 
            case 8: {
                int n = dataInput.readUnsignedShort();
                this.value = new Integer(n);
                return;
            }
            case 9: 
            case 10: 
            case 11: {
                int n = dataInput.readUnsignedShort();
                int n2 = dataInput.readUnsignedShort();
                int[] nArray = new int[]{n, n2};
                this.value = nArray;
                return;
            }
            case 3: {
                int n = dataInput.readInt();
                this.value = new Integer(n);
                return;
            }
            case 4: {
                float f = dataInput.readFloat();
                this.value = new Float(f);
                return;
            }
            case 5: {
                long l = dataInput.readLong();
                this.value = new Long(l);
                return;
            }
            case 6: {
                double d = dataInput.readDouble();
                this.value = new Double(d);
                return;
            }
            case 12: {
                int n = dataInput.readUnsignedShort();
                int n3 = dataInput.readUnsignedShort();
                int[] nArray = new int[]{n, n3};
                this.value = nArray;
                return;
            }
            case 1: {
                String string = dataInput.readUTF();
                this.value = string;
                return;
            }
        }
        throw new ClassFormatError("invalid constant tag value: " + this.tag);
    }

    public final boolean isClass() {
        return 7 == this.tag;
    }

    public final String getUtf8String() {
        if (1 != this.tag) {
            throw new ClassCastException("not an instance of CONSTANT_Utf8");
        }
        String string = (String)this.value;
        return string;
    }

    public final boolean isLong() {
        return 5 == this.tag;
    }

    public final int getClassNameIndex() {
        if (7 != this.tag) {
            throw new ClassCastException("not an instance of CONSTANT_Class");
        }
        Integer n = (Integer)this.value;
        return n;
    }

    public final boolean isDouble() {
        return 6 == this.tag;
    }
}

