/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.applet.PlywoodClassConstant;

public final class PlywoodClass {
    private final String className;

    public PlywoodClass(InputStream inputStream) throws ClassFormatError, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            this.className = PlywoodClass.parseClassFile(dataInputStream);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dataInputStream.close();
            throw throwable;
        }
        Object var4_3 = null;
        dataInputStream.close();
    }

    private static final String parseClassFile(DataInput dataInput) throws ClassFormatError, IOException {
        int n = dataInput.readInt();
        if (-889275714 != n) {
            throw new ClassFormatError("invalid magic number: 0x" + Integer.toString(n, 16));
        }
        int n2 = dataInput.readUnsignedShort();
        if (3 < n2) {
            throw new ClassFormatError("invalid minor version: " + n2);
        }
        int n3 = dataInput.readUnsignedShort();
        if (45 != n3) {
            throw new ClassFormatError("invalid major version: " + n3);
        }
        int n4 = dataInput.readUnsignedShort();
        PlywoodClassConstant[] plywoodClassConstantArray = new PlywoodClassConstant[n4];
        int n5 = 1;
        while (n4 > n5) {
            PlywoodClassConstant plywoodClassConstant;
            plywoodClassConstantArray[n5] = plywoodClassConstant = new PlywoodClassConstant(dataInput);
            if (plywoodClassConstant.isLong() || plywoodClassConstant.isDouble()) {
                ++n5;
            }
            ++n5;
        }
        dataInput.readUnsignedShort();
        n5 = dataInput.readUnsignedShort();
        if (1 > n5 || n4 <= n5 || !plywoodClassConstantArray[n5].isClass()) {
            throw new ClassFormatError("invalid this_class constant index: " + n5);
        }
        int n6 = dataInput.readUnsignedShort();
        if (1 > n6 || n4 <= n6 || !plywoodClassConstantArray[n6].isClass()) {
            throw new ClassFormatError("invalid super_class constant index: " + n6);
        }
        int n7 = plywoodClassConstantArray[n5].getClassNameIndex();
        if (1 > n7 || n4 <= n7 || !plywoodClassConstantArray[n7].isUtf8()) {
            throw new ClassFormatError("invalid class name constant index: " + n7);
        }
        String string = plywoodClassConstantArray[n7].getUtf8String();
        return string.replace('/', '.');
    }

    public final String getClassName() {
        return this.className;
    }
}

