/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vProcessor.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vProcessor.com.x3pGlobal;
import jp.co.lattice.vProcessor.com.x3pRoot;
import jp.co.lattice.vProcessor.parse.x3pKeyword;

public class x3pLex
extends x3pRoot
implements x3pKeyword {
    private GetCharInfo getCharInfo;
    private GetTokenInfo getStringToken = new GetTokenInfo();
    private GetTokenInfo getWordToken = new GetTokenInfo();
    private GetTokenInfo getBase64Token = new GetTokenInfo();
    private int lineNo = 0;
    private char c = '\u0000';
    private byte byteChar = 0;
    private double floatValue;
    private int intValue;
    private String string;
    private Hashtable keyWordTable;
    private int encodingId = 1031;

    public x3pLex(x3pGlobal x3pGlobal2, InputStream inputStream) throws lvThrowable {
        super(x3pGlobal2);
        Integer n;
        int n2;
        this.getCharInfo = new GetCharInfo(inputStream);
        this.keyWordTable = new Hashtable(128);
        for (n2 = 0; n2 < 14; ++n2) {
            n = new Integer(0x200 | n2);
            this.keyWordTable.put(ElmStr[n2].toLowerCase(), n);
        }
        for (n2 = 0; n2 < 23; ++n2) {
            n = new Integer(0x300 | n2);
            this.keyWordTable.put(AttStr[n2].toLowerCase(), n);
        }
        for (n2 = 0; n2 < 9; ++n2) {
            n = new Integer(0x400 | n2);
            this.keyWordTable.put(TypeStr[n2].toLowerCase(), n);
        }
        this.GetChar();
    }

    public final int GetToken() throws lvThrowable {
        this.SkipWhiteSpace();
        if (this.c == '\u0000') {
            return 0;
        }
        if ('0' <= this.c && this.c <= '9' || this.c == '+' || this.c == '-' || this.c == '.') {
            int n = this.GetValueToken();
            return n;
        }
        if (this.c == '<') {
            this.GetChar();
            return 259;
        }
        if (this.c == '>') {
            this.GetChar();
            return 260;
        }
        if (this.c == ',') {
            this.GetChar();
            return 261;
        }
        if (this.c == '!') {
            this.GetChar();
            return 262;
        }
        if (this.c == '?') {
            this.GetChar();
            return 263;
        }
        if (this.c == '/') {
            this.GetChar();
            return 264;
        }
        if (this.c == '\"') {
            this.GetChar();
            return 265;
        }
        if (this.c == '=') {
            this.GetChar();
            return 266;
        }
        this.GetWordToken();
        Integer n = (Integer)this.keyWordTable.get(this.string.toLowerCase());
        if (n == null) {
            this.GetChar();
            return 384;
        }
        int n2 = n;
        return n2;
    }

    public final boolean IsElement(int n) {
        return (n &= 0xFFFFFF00) == 512;
    }

    public final double GetFloatValue() {
        return this.floatValue;
    }

    public final int GetIntValue() {
        return this.intValue;
    }

    public final int GetLineNo() {
        return this.lineNo;
    }

    public final String GetUnknown() {
        String string = new String(this.string);
        return string;
    }

    public final void SetEncodingId(int n) {
        this.encodingId = n;
    }

    public final String GetStringToken() throws lvThrowable {
        Object object;
        int n = 0;
        while (this.c != '\u0000' && (this.c != '\"' || n != 0 && this.getStringToken.buff[n - 1] == 92)) {
            ((GetTokenInfo)this.getStringToken).buff[n] = this.byteChar;
            if (++n >= this.getStringToken.buff_size) {
                object = new byte[this.getStringToken.buff_size + 256];
                for (int i = 0; i < this.getStringToken.buff_size; ++i) {
                    object[i] = this.getStringToken.buff[i];
                }
                this.getStringToken.buff_size += 256;
            }
            this.GetChar();
        }
        this.AssertEx(this.c != '\u0000', "Not close string");
        object = null;
        try {
            switch (this.encodingId) {
                case 1031: {
                    object = new String(this.getStringToken.buff, 0, n);
                    break;
                }
                case 1032: {
                    object = new String(this.getStringToken.buff, 0, n, "SJIS");
                    break;
                }
                default: {
                    this.Err().Assert(false, "x3pLex.GetStringToken(0)");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.Err().Assert(false, "x3pLex.GetStringToken(1)");
        }
        this.GetToken();
        return object;
    }

    public final int ReadBase64Line() throws lvThrowable {
        this.SkipWhiteSpace();
        if (this.c == '\u0000' || this.c == '<') {
            return 0;
        }
        int n = 0;
        while ('a' <= this.c && this.c <= 'z' || 'A' <= this.c && this.c <= 'Z' || '0' <= this.c && this.c <= '9' || this.c == '+' || this.c == '/' || this.c == '=') {
            ((GetTokenInfo)this.getBase64Token).buff[n] = this.byteChar;
            if (++n >= this.getBase64Token.buff_size) {
                byte[] byArray = new byte[this.getBase64Token.buff_size + 256];
                for (int i = 0; i < this.getBase64Token.buff_size; ++i) {
                    byArray[i] = this.getBase64Token.buff[i];
                }
                this.getBase64Token.buff_size += 256;
            }
            this.GetChar();
        }
        return n;
    }

    public final byte[] GetBase64Line() {
        return this.getBase64Token.buff;
    }

    public final void AssertEx(boolean bl, String string) throws lvThrowable {
        if (!bl) {
            String string2 = String.valueOf(this.lineNo);
            this.Err().Assert(bl, string2 + "  " + string);
        }
    }

    private final void GetChar() throws lvThrowable {
        if (this.getCharInfo.rsize == -1) {
            this.c = '\u0000';
            return;
        }
        if (this.getCharInfo.buffPos >= this.getCharInfo.rsize) {
            try {
                this.getCharInfo.rsize = this.getCharInfo.inStream.read(this.getCharInfo.buff);
            }
            catch (IOException iOException) {
                this.Err().Assert(false, "x3pLex.GetChar(0)");
            }
            this.getCharInfo.buffPos = 0;
            if (this.getCharInfo.rsize == -1) {
                try {
                    this.getCharInfo.inStream.close();
                }
                catch (IOException iOException) {
                    this.Err().Assert(false, "x3pLex.GetChar(1)");
                }
                this.c = '\u0000';
                return;
            }
        }
        this.byteChar = this.getCharInfo.buff[this.getCharInfo.buffPos];
        this.c = (char)this.byteChar;
        this.getCharInfo.buffPos++;
        if (this.c == '\n') {
            ++this.lineNo;
        }
    }

    private final void SkipWhiteSpace() throws lvThrowable {
        while (this.c == ' ' || this.c == '\t' || this.c == '\n' || this.c == '\r') {
            this.GetChar();
        }
    }

    private final int GetValueToken() throws lvThrowable {
        double d = 1.0;
        int n = 0;
        if (this.c == '+') {
            d = 1.0;
            this.GetChar();
        } else if (this.c == '-') {
            d = -1.0;
            this.GetChar();
        }
        if (this.c == '0') {
            this.GetChar();
            if (this.c == 'x' || this.c == 'X') {
                this.intValue = this.GetHexToken();
                this.intValue = (int)((double)this.intValue * d);
                return 256;
            }
        }
        if ('0' <= this.c && this.c <= '9') {
            n = this.GetIntToken();
        }
        if (this.c == '.') {
            this.floatValue = this.GetDecimalToken(n);
            if (this.c == 'e' || this.c == 'E') {
                this.floatValue = this.GetExpToken(this.floatValue);
            }
            this.floatValue *= d;
            return 257;
        }
        if (this.c == 'e' || this.c == 'E') {
            this.floatValue = this.GetExpToken(n);
            this.floatValue *= d;
            return 257;
        }
        this.intValue = n;
        this.intValue *= (int)d;
        this.floatValue = this.intValue;
        return 256;
    }

    private final int GetHexToken() throws lvThrowable {
        int n = 0;
        this.GetChar();
        while (true) {
            if ('0' <= this.c && this.c <= '9') {
                n *= 16;
                n += this.c - 48;
            } else if ('A' <= this.c && this.c <= 'F') {
                n *= 16;
                n += this.c - 65 + 10;
            } else {
                if ('a' > this.c || this.c > 'f') break;
                n *= 16;
                n += this.c - 65 + 10;
            }
            this.GetChar();
        }
        return n;
    }

    private final int GetIntToken() throws lvThrowable {
        int n = 0;
        while ('0' <= this.c && this.c <= '9') {
            n *= 10;
            n += this.c - 48;
            this.GetChar();
        }
        return n;
    }

    private final double GetDecimalToken(int n) throws lvThrowable {
        double d = 0.0;
        double d2 = 0.1;
        this.GetChar();
        while ('0' <= this.c && this.c <= '9') {
            d += (double)(this.c - 48) * d2;
            d2 *= 0.1;
            this.GetChar();
        }
        return d += (double)n;
    }

    private final double GetExpToken(double d) throws lvThrowable {
        double d2;
        block3: {
            int n;
            block2: {
                d2 = d;
                n = 0;
                this.GetChar();
                if (this.c != '+') break block2;
                this.GetChar();
                n = this.GetIntToken();
                for (int i = 0; i < n; ++i) {
                    d2 *= 10.0;
                }
                break block3;
            }
            if (this.c != '-') break block3;
            this.GetChar();
            n = this.GetIntToken();
            for (int i = 0; i < n; ++i) {
                d2 *= 0.1;
            }
        }
        return d2;
    }

    private final boolean GetWordToken() throws lvThrowable {
        int n = 0;
        if ('a' <= this.c && this.c <= 'z' || 'A' <= this.c && this.c <= 'Z' || this.c == '_') {
            ((GetTokenInfo)this.getWordToken).buff[n] = this.byteChar;
            ++n;
            this.GetChar();
        } else {
            return false;
        }
        while ('a' <= this.c && this.c <= 'z' || 'A' <= this.c && this.c <= 'Z' || '0' <= this.c && this.c <= '9' || this.c == '_' || this.c == '-' || this.c == ':') {
            ((GetTokenInfo)this.getWordToken).buff[n] = this.byteChar;
            if (++n >= this.getWordToken.buff_size) {
                byte[] byArray = new byte[this.getWordToken.buff_size + 256];
                for (int i = 0; i < this.getWordToken.buff_size; ++i) {
                    byArray[i] = this.getWordToken.buff[i];
                }
                this.getWordToken.buff_size += 256;
            }
            this.GetChar();
        }
        this.string = new String(this.getWordToken.buff, 0, n);
        return true;
    }

    class GetTokenInfo {
        private int buff_size = 256;
        private byte[] buff = new byte[this.buff_size];

        GetTokenInfo() {
        }
    }

    class GetCharInfo {
        private static final int buffSize = 4096;
        private int buffPos = 4096;
        private int rsize = 0;
        private byte[] buff = new byte[4096];
        private InputStream inStream;

        private GetCharInfo(InputStream inputStream) {
            this.inStream = inputStream;
        }
    }
}

