/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vProcessor.com;

import jp.co.lattice.vKernel.core.c0.lvEps;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVecCalc;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vProcessor.com.x3pComGblElm;
import jp.co.lattice.vProcessor.com.x3pGlobal;
import jp.co.lattice.vProcessor.com.x3pRoot;

public class x3pMatrix
extends x3pRoot {
    public double[][] m = new double[4][4];

    private final Global Gbl() {
        return ((x3pComGblElm)this.global.GComX3p()).gMatrix;
    }

    public x3pMatrix(x3pGlobal x3pGlobal2) {
        super(x3pGlobal2);
        this.SetUnit();
    }

    public x3pMatrix(x3pGlobal x3pGlobal2, x3pMatrix x3pMatrix2) {
        super(x3pGlobal2);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m[i][j] = x3pMatrix2.m[i][j];
            }
        }
    }

    public final void Set(x3pMatrix x3pMatrix2) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m[i][j] = x3pMatrix2.m[i][j];
            }
        }
    }

    public final x3pMatrix SetTranslate(lvVector lvVector2) {
        this.m[0][0] = 1.0;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = 1.0;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = 1.0;
        this.m[2][3] = 0.0;
        this.m[3][0] = lvVector2.x;
        this.m[3][1] = lvVector2.y;
        this.m[3][2] = lvVector2.z;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetScale(lvVector lvVector2) {
        this.m[0][0] = lvVector2.x;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = lvVector2.y;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = lvVector2.z;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetScale(double d) {
        this.m[0][0] = d;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = d;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = d;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetRotateX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.m[0][0] = 1.0;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = d3;
        this.m[1][2] = d2;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = -d2;
        this.m[2][2] = d3;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetRotateY(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m[0][0] = d2 = Math.cos(d);
        this.m[0][1] = 0.0;
        this.m[0][2] = -d3;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = 1.0;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = d3;
        this.m[2][1] = 0.0;
        this.m[2][2] = d2;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetRotateZ(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m[0][0] = d2 = Math.cos(d);
        this.m[0][1] = d3;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = -d3;
        this.m[1][1] = d2;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = 1.0;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        return this;
    }

    public final x3pMatrix SetRotateZXY(double d, double d2, double d3) {
        x3pMatrix x3pMatrix2 = this.Gbl().tmSetRotateZXY[0];
        x3pMatrix x3pMatrix3 = this.Gbl().tmSetRotateZXY[1];
        x3pMatrix2.SetRotateZ(d3);
        x3pMatrix3.SetRotateX(d);
        x3pMatrix2.Mul(x3pMatrix3);
        x3pMatrix3.SetRotateY(d2);
        this.Set(x3pMatrix2.Mul(x3pMatrix3));
        return this;
    }

    public final x3pMatrix SetRotateYXZ(double d, double d2, double d3) {
        x3pMatrix x3pMatrix2 = this.Gbl().tmSetRotateYXZ[0];
        x3pMatrix x3pMatrix3 = this.Gbl().tmSetRotateYXZ[1];
        x3pMatrix2.SetRotateY(d2);
        x3pMatrix3.SetRotateX(d);
        x3pMatrix2.Mul(x3pMatrix3);
        x3pMatrix3.SetRotateZ(d3);
        this.Set(x3pMatrix2.Mul(x3pMatrix3));
        return this;
    }

    public final x3pMatrix SetRotateV(lvVector lvVector2, double d) {
        lvVector lvVector3 = this.Gbl().tvSetRotateV[0];
        lvVector3.SetXYZ(0.0, 0.0, 0.0);
        lvVector lvVector4 = this.Gbl().tvSetRotateV[1];
        lvVector4.SetXYZ(1.0, 0.0, 0.0);
        lvVector lvVector5 = this.Gbl().tvSetRotateV[2];
        lvVector5.SetXYZ(0.0, 1.0, 0.0);
        lvVector lvVector6 = this.Gbl().tvSetRotateV[3];
        lvVector6.SetXYZ(0.0, 0.0, 1.0);
        lvVector4.Rotate(lvVector2, d);
        lvVector5.Rotate(lvVector2, d);
        lvVector6.Rotate(lvVector2, d);
        this.SetVector(lvVector3, lvVector4, lvVector5, lvVector6);
        return this;
    }

    public final x3pMatrix SetVector(lvVector lvVector2, lvVector lvVector3, lvVector lvVector4, lvVector lvVector5) {
        this.m[0][0] = lvVector3.x;
        this.m[0][1] = lvVector3.y;
        this.m[0][2] = lvVector3.z;
        this.m[0][3] = 0.0;
        this.m[1][0] = lvVector4.x;
        this.m[1][1] = lvVector4.y;
        this.m[1][2] = lvVector4.z;
        this.m[1][3] = 0.0;
        this.m[2][0] = lvVector5.x;
        this.m[2][1] = lvVector5.y;
        this.m[2][2] = lvVector5.z;
        this.m[2][3] = 0.0;
        this.m[3][0] = lvVector2.x;
        this.m[3][1] = lvVector2.y;
        this.m[3][2] = lvVector2.z;
        this.m[3][3] = 1.0;
        return this;
    }

    public final void SetUnit() {
        this.m[0][0] = 1.0;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = 0.0;
        this.m[1][0] = 0.0;
        this.m[1][1] = 1.0;
        this.m[1][2] = 0.0;
        this.m[1][3] = 0.0;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = 1.0;
        this.m[2][3] = 0.0;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
    }

    public final x3pMatrix Mul(x3pMatrix x3pMatrix2) {
        x3pMatrix x3pMatrix3 = this.Gbl().tmMul0[0];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                x3pMatrix3.m[i][j] = this.m[i][0] * x3pMatrix2.m[0][j];
                double[] dArray = x3pMatrix3.m[i];
                int n = j;
                dArray[n] = dArray[n] + this.m[i][1] * x3pMatrix2.m[1][j];
                double[] dArray2 = x3pMatrix3.m[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.m[i][2] * x3pMatrix2.m[2][j];
                double[] dArray3 = x3pMatrix3.m[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + this.m[i][3] * x3pMatrix2.m[3][j];
            }
        }
        this.Set(x3pMatrix3);
        return this;
    }

    public final lvVecCalc Mul(lvVector lvVector2) {
        lvVector lvVector3 = this.Gbl().tvMul1[0];
        lvVector3.x = lvVector2.x * this.m[0][0];
        lvVector3.x += lvVector2.y * this.m[1][0];
        lvVector3.x += lvVector2.z * this.m[2][0];
        lvVector3.x += this.m[3][0];
        lvVector3.y = lvVector2.x * this.m[0][1];
        lvVector3.y += lvVector2.y * this.m[1][1];
        lvVector3.y += lvVector2.z * this.m[2][1];
        lvVector3.y += this.m[3][1];
        lvVector3.z = lvVector2.x * this.m[0][2];
        lvVector3.z += lvVector2.y * this.m[1][2];
        lvVector3.z += lvVector2.z * this.m[2][2];
        lvVector3.z += this.m[3][2];
        return lvVector3;
    }

    public final lvVector MatResoluteRot() {
        x3pMatrix x3pMatrix2 = this;
        lvVector lvVector2 = this.Gbl().tvMATresoluteRot[0];
        lvVector2.SetXYZ(0.0, 0.0, 1.0);
        lvVector lvVector3 = this.Gbl().tvMATresoluteRot[1];
        lvVector3.SetXYZ(0.0, 1.0, 0.0);
        lvVector lvVector4 = this.Gbl().tvMATresoluteRot[2];
        lvVector4.SetXYZ(1.0, 0.0, 0.0);
        x3pMatrix x3pMatrix3 = this.Gbl().tmMATresoluteRot[0];
        x3pMatrix x3pMatrix4 = this.Gbl().tmMATresoluteRot[1];
        lvVector lvVector5 = new lvVector(this.global);
        lvVector2.Assign(x3pMatrix2.Mul(lvVector2));
        lvVector4.Assign(x3pMatrix2.Mul(lvVector4));
        lvVector3.Assign(x3pMatrix2.Mul(lvVector3));
        if (-0.001 < lvVector2.x && lvVector2.x < 0.001) {
            lvVector2.x = 0.0;
        }
        if (-0.001 < lvVector2.z && lvVector2.z < 0.001) {
            lvVector2.z = 0.0;
        }
        lvVector5.y = lvVector2.z != 0.0 ? Math.atan(lvVector2.x / lvVector2.z) : (lvVector2.z == 0.0 && lvVector2.x != 0.0 ? 1.5707963267948966 : 0.0);
        if (lvVector2.z < 0.0) {
            lvVector5.y += Math.PI;
        }
        if (lvVector5.y < 0.0) {
            lvVector5.y += Math.PI * 2;
        }
        x3pMatrix4.SetRotateY(-lvVector5.y);
        lvVector4.Assign(x3pMatrix4.Mul(lvVector4));
        lvVector2.Assign(x3pMatrix4.Mul(lvVector2));
        lvVector3.Assign(x3pMatrix4.Mul(lvVector3));
        if (-0.001 < lvVector2.y && lvVector2.y < 0.001) {
            lvVector2.y = 0.0;
        }
        if (-0.001 < lvVector2.z && lvVector2.z < 0.001) {
            lvVector2.z = 0.0;
        }
        lvVector5.x = lvVector2.y != 0.0 ? Math.atan(lvVector2.z / lvVector2.y) - 1.5707963267948966 : (lvVector2.y == 0.0 && lvVector2.z != 0.0 ? 0.0 : -1.5707963267948966);
        if (lvVector2.y < 0.0) {
            lvVector5.x += Math.PI;
        }
        if (lvVector5.x < 0.0) {
            lvVector5.x += Math.PI * 2;
        }
        x3pMatrix3.SetRotateX(-lvVector5.x);
        lvVector4.Assign(x3pMatrix3.Mul(lvVector4));
        lvVector3.Assign(x3pMatrix3.Mul(lvVector3));
        lvVector2.Assign(x3pMatrix3.Mul(lvVector2));
        if (-0.001 < lvVector4.x && lvVector4.x < 0.001) {
            lvVector4.x = 0.0;
        }
        if (-0.001 < lvVector4.y && lvVector4.y < 0.001) {
            lvVector4.y = 0.0;
        }
        lvVector5.z = lvVector4.x != 0.0 ? Math.atan(lvVector4.y / lvVector4.x) : (lvVector4.x == 0.0 && lvVector4.y != 0.0 ? (lvVector4.y >= 0.0 ? 1.5707963267948966 : -1.5707963267948966) : 0.0);
        if (lvVector4.x < 0.0) {
            lvVector5.z += Math.PI;
        }
        if (lvVector5.z < 0.0) {
            lvVector5.z += Math.PI * 2;
        }
        return lvVector5;
    }

    public final void Invert33() throws lvThrowable {
        double d = 1.0E-8;
        x3pMatrix x3pMatrix2 = this.Gbl().tmInvert33[0];
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2 = i;
            double d2 = this.m[i][i];
            for (n = i + 1; n < 3; ++n) {
                if (!(Math.abs(this.m[n][i]) > Math.abs(d2))) continue;
                n2 = n;
                d2 = this.m[n][i];
            }
            if (n2 != i) {
                for (n = 0; n < 3; ++n) {
                    d2 = this.m[i][n];
                    this.m[i][n] = this.m[n2][n];
                    this.m[n2][n] = d2;
                    d2 = x3pMatrix2.m[i][n];
                    x3pMatrix2.m[i][n] = x3pMatrix2.m[n2][n];
                    x3pMatrix2.m[n2][n] = d2;
                }
            }
            d2 = this.m[i][i];
            this.Eps();
            if (lvEps.IsZero(d2, d)) {
                this.Err().Assert(false, "x3pMatrix.invert33(0)");
            }
            n = 0;
            while (n < 3) {
                double[] dArray = this.m[i];
                int n3 = n;
                dArray[n3] = dArray[n3] / d2;
                double[] dArray2 = x3pMatrix2.m[i];
                int n4 = n++;
                dArray2[n4] = dArray2[n4] / d2;
            }
            for (n = 0; n < 3; ++n) {
                if (n == i) continue;
                d2 = this.m[n][i];
                for (int j = 0; j < 3; ++j) {
                    double[] dArray = this.m[n];
                    int n5 = j;
                    dArray[n5] = dArray[n5] - d2 * this.m[i][j];
                    double[] dArray3 = x3pMatrix2.m[n];
                    int n6 = j;
                    dArray3[n6] = dArray3[n6] - d2 * x3pMatrix2.m[i][j];
                }
            }
        }
        this.Set(x3pMatrix2);
    }

    public final void Transpose() {
        x3pMatrix x3pMatrix2 = this.Gbl().tmTranspose[0];
        x3pMatrix2.Set(this);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m[j][i] = x3pMatrix2.m[i][j];
            }
        }
    }

    public static class Global {
        private x3pMatrix[] tmSetRotateZXY = null;
        private x3pMatrix[] tmSetRotateYXZ = null;
        private lvVector[] tvSetRotateV = null;
        private x3pMatrix[] tmMul0 = null;
        private lvVector[] tvMul1 = null;
        private lvVector[] tvMATresoluteRot = null;
        private x3pMatrix[] tmMATresoluteRot = null;
        private x3pMatrix[] tmInvert33 = null;
        private x3pMatrix[] tmTranspose = null;

        public Global(x3pGlobal x3pGlobal2) {
            this.GlobalTmp(x3pGlobal2);
        }

        private final void GlobalTmp(x3pGlobal x3pGlobal2) {
            int n;
            this.tmSetRotateZXY = new x3pMatrix[4];
            for (n = 0; n < 4; ++n) {
                this.tmSetRotateZXY[n] = new x3pMatrix(x3pGlobal2);
            }
            this.tmSetRotateYXZ = new x3pMatrix[4];
            for (n = 0; n < 4; ++n) {
                this.tmSetRotateYXZ[n] = new x3pMatrix(x3pGlobal2);
            }
            this.tvSetRotateV = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvSetRotateV[n] = new lvVector(x3pGlobal2);
            }
            this.tmMul0 = new x3pMatrix[2];
            for (n = 0; n < 2; ++n) {
                this.tmMul0[n] = new x3pMatrix(x3pGlobal2);
            }
            this.tvMul1 = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvMul1[n] = new lvVector(x3pGlobal2);
            }
            this.tvMATresoluteRot = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvMATresoluteRot[n] = new lvVector(x3pGlobal2);
            }
            this.tmMATresoluteRot = new x3pMatrix[4];
            for (n = 0; n < 4; ++n) {
                this.tmMATresoluteRot[n] = new x3pMatrix(x3pGlobal2);
            }
            this.tmInvert33 = new x3pMatrix[2];
            for (n = 0; n < 2; ++n) {
                this.tmInvert33[n] = new x3pMatrix(x3pGlobal2);
            }
            this.tmTranspose = new x3pMatrix[2];
            for (n = 0; n < 2; ++n) {
                this.tmTranspose[n] = new x3pMatrix(x3pGlobal2);
            }
        }
    }
}

