/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vProcessor.base;

import jp.co.lattice.vKernel.core.b0.lvToKernel;
import jp.co.lattice.vKernel.core.c0.lvError;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvToKernelType;
import jp.co.lattice.vKernel.core.c0.lvUVdt;
import jp.co.lattice.vKernel.core.c0.lvVecDt;
import jp.co.lattice.vKernel.tex.c0a.lvToKernelUV;
import jp.co.lattice.vProcessor.base.x3pTmpDtTrv;
import jp.co.lattice.vProcessor.base.x3pXvlFacesEx;
import jp.co.lattice.vProcessor.base.x3pXvlShapeEx;
import jp.co.lattice.vProcessor.com.x3pGlobal;
import jp.co.lattice.vProcessor.node.x3pContent;
import jp.co.lattice.vProcessor.node.x3pCoordinate;
import jp.co.lattice.vProcessor.node.x3pElement;
import jp.co.lattice.vProcessor.node.x3pTraverse;
import jp.co.lattice.vProcessor.node.x3pXvlEdge;
import jp.co.lattice.vProcessor.node.x3pXvlFace;
import jp.co.lattice.vProcessor.node.x3pXvlVertex;

public class x3pTrvToKernel
extends x3pTraverse {
    private lvToKernel toKernel = null;
    private int numDiv = 4;
    private int currentShlNo = 0;
    private x3pXvlShapeEx currentShell = null;
    private int cntVertex = 0;
    private int cntEdge = 0;
    private int cntGsNumVtx = 0;
    private int cntGsVtxSeq = 0;
    private int cntNgNumVtx = 0;
    private int cntNgVtxSeq = 0;
    private int cntUVspaceNo = 0;
    private int cntGsUVseq = 0;
    private boolean existTexture = false;
    private int cntEachFace = 0;

    public x3pTrvToKernel(x3pGlobal x3pGlobal2) {
        super(x3pGlobal2);
    }

    private final x3pGlobal Processor() {
        return this.global;
    }

    private final void Clear() {
        this.cntVertex = 0;
        this.cntEdge = 0;
        this.cntGsNumVtx = 0;
        this.cntGsVtxSeq = 0;
        this.cntNgNumVtx = 0;
        this.cntNgVtxSeq = 0;
        this.cntUVspaceNo = 0;
        this.cntGsUVseq = 0;
    }

    public final void ToKernel(x3pElement[] x3pElementArray, int n) throws lvThrowable {
        this.Err().Assert(x3pElementArray != null, "x3pTrvToKernel.toKernel(0)");
        this.toKernel = new lvToKernel(this.Processor());
        this.numDiv = n;
        this.TraverseMFElement(x3pElementArray, dmyTrvData);
        this.toKernel = null;
    }

    protected void TraverseXvlShape(x3pContent x3pContent2, x3pTraverse.TrvData trvData) throws lvThrowable {
        int n;
        x3pXvlShapeEx x3pXvlShapeEx2 = (x3pXvlShapeEx)x3pContent2;
        this.Err().Assert(x3pXvlShapeEx2.content != null, "x3pTrvToKernel.TraverseXvlShape(0)");
        this.Err().Assert(x3pXvlShapeEx2.typeXvlShape != Integer.MIN_VALUE, "x3pTrvToKernel.TraverseXvlShape(1)");
        this.currentShell = x3pXvlShapeEx2;
        this.Clear();
        if (this.currentShell.uvSpace != null) {
            for (n = 0; n < this.currentShell.tmpVtxUV.length; ++n) {
                this.currentShell.tmpVtxUV[n].currentUVoffset = -1;
                this.currentShell.tmpVtxUV[n].currentUVspaceNo = -1;
            }
        }
        this.TraverseMFElement(x3pXvlShapeEx2.content, trvData);
        if (this.currentShell.uvSpace != null) {
            for (n = 0; n < this.currentShell.uvSpace.vtxNumUV.length; ++n) {
                this.currentShell.uvSpace.vtxNumUV[n] = this.currentShell.tmpVtxUV[n].vtxNumUV.num;
            }
        }
        lvToKernelType.Attr attr = new lvToKernelType.Attr();
        attr.numDiv = this.numDiv;
        if (x3pXvlShapeEx2.typeXvlShape == 2) {
            attr.type = 0;
        } else if (x3pXvlShapeEx2.typeXvlShape == 3) {
            attr.type = 1;
        } else if (x3pXvlShapeEx2.typeXvlShape == 4) {
            attr.type = 2;
        } else {
            this.Err().Assert(false, "x3pTrvToKernel.traverseShell(2)");
        }
        boolean bl = this.toKernel.SetAttr(this.currentShlNo, attr);
        this.Err().Assert(!bl, lvError.Message(this.Processor()));
        this.toKernel.gsNumVtx = this.currentShell.gsNumVtx;
        this.toKernel.gsVtxSeq = this.currentShell.gsVtxSeq;
        this.toKernel.ngNumVtx = this.currentShell.ngNumVtx;
        this.toKernel.ngVtxSeq = this.currentShell.ngVtxSeq;
        this.toKernel.edge = this.currentShell.edge;
        this.toKernel.vertex = this.currentShell.vertex;
        this.toKernel.uvSpace = this.currentShell.uvSpace;
        bl = this.toKernel.SetData(this.currentShlNo);
        this.Err().Assert(!bl, lvError.Message(this.Processor()));
        ++this.currentShlNo;
    }

    protected void TraverseCoordinate(x3pElement x3pElement2, x3pTraverse.TrvData trvData) throws lvThrowable {
        x3pCoordinate x3pCoordinate2 = (x3pCoordinate)x3pElement2;
        this.Err().Assert(x3pCoordinate2.data != null, "x3pTrvToKernel.TraverseCoordinate(0)");
        this.Err().Assert(x3pCoordinate2.data.length >= 3, "x3pTrvToKernel.TraverseCoordinate(1)");
        for (int i = 0; i < x3pCoordinate2.data.length; ++i) {
            int n = this.cntVertex + i;
            x3pTmpDtTrv.ToKernelVtxGs toKernelVtxGs = this.currentShell.tmpVtxGs[n];
            if (!toKernelVtxGs.onFace) continue;
            lvToKernelType.Vertex vertex = this.currentShell.vertex[toKernelVtxGs.newVtxNo];
            vertex.pos.x = x3pCoordinate2.data[i].x;
            vertex.pos.y = x3pCoordinate2.data[i].y;
            vertex.pos.z = x3pCoordinate2.data[i].z;
        }
        this.cntVertex += x3pCoordinate2.data.length;
    }

    protected void TraverseUseCoordinate(x3pElement x3pElement2, x3pTraverse.TrvData trvData) throws lvThrowable {
    }

    protected void TraverseXvlFaces(x3pContent x3pContent2, x3pTraverse.TrvData trvData) throws lvThrowable {
        x3pXvlFacesEx x3pXvlFacesEx2 = (x3pXvlFacesEx)x3pContent2;
        this.Err().Assert(x3pXvlFacesEx2.content != null, "x3pTrvAddElm1.TraverseXvlFaces(0)");
        this.existTexture = x3pXvlFacesEx2.existTexture;
        this.cntEachFace = 0;
        this.TraverseMFElement(x3pXvlFacesEx2.content, trvData);
        if (this.existTexture) {
            if (x3pXvlFacesEx2.numGs - x3pXvlFacesEx2.numEachFace > 0) {
                ++this.cntUVspaceNo;
            }
            if (x3pXvlFacesEx2.numEachFace > 0) {
                this.cntUVspaceNo += x3pXvlFacesEx2.numEachFace;
            }
        }
    }

    protected void TraverseXvlFace(x3pContent x3pContent2, x3pTraverse.TrvData trvData) throws lvThrowable {
        int n;
        x3pXvlFace x3pXvlFace2 = (x3pXvlFace)x3pContent2;
        this.Err().Assert(x3pXvlFace2.coordIndex != null, "x3pTrvToKernel.TraverseXvlFace(0)");
        int n2 = 0;
        for (n = 0; n < x3pXvlFace2.coordIndex.length && x3pXvlFace2.coordIndex[n] != -1; ++n) {
            ++n2;
        }
        if (n2 < 3) {
            return;
        }
        if (!x3pXvlFace2.empty) {
            for (n = 0; n < n2; ++n) {
                int n3;
                int n4 = x3pXvlFace2.coordIndex[n];
                this.currentShell.gsVtxSeq[this.cntGsVtxSeq] = n3 = this.currentShell.tmpVtxGs[n4].newVtxNo;
                ++this.cntGsVtxSeq;
            }
            this.currentShell.gsNumVtx[this.cntGsNumVtx] = n2;
        } else {
            for (n = 0; n < n2; ++n) {
                int n5;
                int n6 = x3pXvlFace2.coordIndex[n];
                this.currentShell.ngVtxSeq[this.cntNgVtxSeq] = n5 = this.currentShell.tmpVtxGs[n6].newVtxNo;
                ++this.cntNgVtxSeq;
            }
            this.currentShell.ngNumVtx[this.cntNgNumVtx] = n2;
            ++this.cntNgNumVtx;
        }
        if (!x3pXvlFace2.empty) {
            this.ProcTraverseXvlFaceUV(x3pXvlFace2);
        }
        if (!x3pXvlFace2.empty) {
            ++this.cntGsNumVtx;
        }
    }

    private void ProcTraverseXvlFaceUV(x3pXvlFace x3pXvlFace2) throws lvThrowable {
        if (this.currentShell.uvSpace == null) {
            return;
        }
        this.currentShell.uvSpace.gsNumUV[this.cntGsNumVtx] = 0;
        if (this.existTexture) {
            this.currentShell.uvSpace.gsNumUV[this.cntGsNumVtx] = 1;
            lvToKernelUV.GsUV gsUV = this.currentShell.uvSpace.gsUVseq[this.cntGsUVseq];
            gsUV.uvSpaceNo = this.cntEachFace;
            ++this.cntGsUVseq;
            if (x3pXvlFace2.texCoordIndex != null) {
                for (int i = 0; i < x3pXvlFace2.coordIndex.length && x3pXvlFace2.coordIndex[i] != -1; ++i) {
                    if (x3pXvlFace2.texCoordIndex[i] < 0) continue;
                    this.ProcTraverseFaceUVvtx(x3pXvlFace2, x3pXvlFace2.coordIndex[i], x3pXvlFace2.texCoordIndex[i], gsUV.uvSpaceNo);
                }
            }
            ++this.cntEachFace;
        }
    }

    private void ProcTraverseFaceUVvtx(x3pXvlFace x3pXvlFace2, int n, int n2, int n3) throws lvThrowable {
        int n4 = this.currentShell.tmpVtxGs[n].newVtxNo;
        int n5 = this.currentShell.tmpVtxUV[n4].vtxNumUV.start;
        ++this.currentShell.tmpVtxUV[n4].currentUVoffset;
        int n6 = this.currentShell.tmpVtxUV[n4].currentUVoffset;
        this.Err().Assert(n6 < this.currentShell.tmpVtxUV[n4].vtxNumUV.num, "x3pTrvToKernel.ProcTraverseFaceUVvtx(0)");
        lvToKernelUV.VtxUV vtxUV = this.currentShell.uvSpace.vtxUVseq[n5 + n6];
        vtxUV.uvSpaceNo = n3;
        lvUVdt.Copy(this.currentShell.tmpUVcoord[n2], vtxUV.uv);
    }

    protected void TraverseXvlEdge(x3pContent x3pContent2, x3pTraverse.TrvData trvData) throws lvThrowable {
        int n;
        x3pXvlEdge x3pXvlEdge2 = (x3pXvlEdge)x3pContent2;
        this.Err().Assert(x3pXvlEdge2.coordIndex != null, "x3pTrvToKernel.TraverseXvlEdge(0)");
        lvToKernelType.Edge edge = this.currentShell.edge[this.cntEdge];
        int n2 = x3pXvlEdge2.coordIndex[0];
        edge.v0 = n = this.currentShell.tmpVtxGs[n2].newVtxNo;
        n2 = x3pXvlEdge2.coordIndex[1];
        edge.v1 = n = this.currentShell.tmpVtxGs[n2].newVtxNo;
        if (x3pXvlEdge2.roundingWeight != -1.0E-149) {
            edge.enableAll = true;
            edge.allRound = x3pXvlEdge2.roundingWeight;
        }
        if (x3pXvlEdge2.vectorStartEnd != null) {
            edge.vec0 = new lvVecDt();
            lvVecDt lvVecDt2 = this.currentShell.tmpVtxGs[x3pXvlEdge2.vectorStartEnd[0]].xyz;
            lvVecDt.Copy(lvVecDt2, edge.vec0);
            edge.vec1 = new lvVecDt();
            lvVecDt2 = this.currentShell.tmpVtxGs[x3pXvlEdge2.vectorStartEnd[1]].xyz;
            lvVecDt.Copy(lvVecDt2, edge.vec1);
            edge.vec1.x = -edge.vec1.x;
            edge.vec1.y = -edge.vec1.y;
            edge.vec1.z = -edge.vec1.z;
        }
        ++this.cntEdge;
    }

    protected void TraverseXvlVertex(x3pContent x3pContent2, x3pTraverse.TrvData trvData) throws lvThrowable {
        x3pXvlVertex x3pXvlVertex2 = (x3pXvlVertex)x3pContent2;
        this.Err().Assert(x3pXvlVertex2.coordIndex != Integer.MIN_VALUE, "x3pTrvToKernel.TraverseXvlVertex(0)");
        int n = x3pXvlVertex2.coordIndex;
        int n2 = this.currentShell.tmpVtxGs[n].newVtxNo;
        lvToKernelType.Vertex vertex = this.currentShell.vertex[n2];
        if (x3pXvlVertex2.roundingWeight != -1.0E-149) {
            vertex.enable = true;
            vertex.round = x3pXvlVertex2.roundingWeight;
        }
    }
}

