/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.greg.t0g;

import jp.co.lattice.vKernel.core.c0.lvComGblElm;
import jp.co.lattice.vKernel.core.c0.lvDouble;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvPolygon;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.greg.c0g.lv0ComGGblElm;
import jp.co.lattice.vKernel.greg.c0g.lvBezLine;
import jp.co.lattice.vKernel.greg.c0g.lvPolyDerive;
import jp.co.lattice.vKernel.greg.g0g.lvRoundLow;
import jp.co.lattice.vKernel.greg.t0g.lv0TopoGGblElm;

public class lvRound
extends lvRoot {
    private static final int maxNumVtxForCenter = 256;
    private static final int maxNumHalfEdge = 256;

    private final Global Gbl() {
        return ((lv0TopoGGblElm)this.global.GTopoG()).gRound;
    }

    private final lvPolygon Polygon() {
        return ((lvComGblElm)this.global.GCom()).gModelPoly.shell[((Global)this.Gbl()).curShellNo].poly;
    }

    private final lvPolygon Polygon(int n) {
        return ((lvComGblElm)this.global.GCom()).gModelPoly.shell[n].poly;
    }

    private final lvPolyDerive.PolyCenter PolyCenter() {
        return ((lv0ComGGblElm)this.global.GComG()).gModelGreg.shell[((Global)this.Gbl()).curShellNo].center;
    }

    private final lvPolyDerive.Bezgon Bezgon() {
        return ((lv0ComGGblElm)this.global.GComG()).gModelGreg.shell[((Global)this.Gbl()).curShellNo].bez;
    }

    private final lvPolyDerive.Bezgon Bezgon(int n) {
        return ((lv0ComGGblElm)this.global.GComG()).gModelGreg.shell[n].bez;
    }

    private final lvRoundLow.DownRound DownRound() {
        return this.Gbl().downRound;
    }

    private final lvRoundLow.UpRound UpRound() {
        return this.Gbl().upRound;
    }

    private static final lvRound Local(lvGlobal lvGlobal2) {
        return ((lv0TopoGGblElm)lvGlobal2.GTopoG()).gRound.local;
    }

    public lvRound(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public void Exec(int n) throws lvThrowable {
        this.Gbl().curShellNo = n;
        this.SetPolyCenter();
        this.NewBezgon();
        int n2 = this.GetMaxRadial();
        this.NewDownRadial(n2);
        this.NewUpRadial(n2);
        this.ExecMain();
        this.FaceProc();
        this.Finish();
    }

    private final void SetPolyCenter() throws lvThrowable {
        int n = this.Polygon().ngStartNo;
        this.PolyCenter().NewLattice(n);
        int n2 = this.Polygon().face.length - this.Polygon().ngStartNo;
        this.PolyCenter().NewNG(n2);
        this.SetPolyCenterPos();
        this.SetPolyCenterNormal();
    }

    private final void SetPolyCenterPos() throws lvThrowable {
        int n;
        int n2;
        lvVector lvVector2 = this.Gbl().tvSetPolyCenterPos[0];
        lvVector lvVector3 = this.Gbl().tvSetPolyCenterPos[1];
        int n3 = this.Polygon().ngStartNo;
        for (n2 = 0; n2 < n3; ++n2) {
            lvVector2.SetXYZ(0.0, 0.0, 0.0);
            lvRec.SeqPart seqPart = this.Polygon().face[n2];
            for (int i = 0; i < seqPart.num; ++i) {
                n = this.Polygon().faceHalfSeq[seqPart.start + i].vtxNo;
                lvVector3.VecDt2Vector(this.Polygon().vertex[n].pos);
                lvVector2.AddAssign(lvVector3);
            }
            lvVector2.DivAssign(seqPart.num);
            lvVector2.Vector2VecDt(this.PolyCenter().lattice[n2].center.pos);
        }
        n2 = this.Polygon().face.length - this.Polygon().ngStartNo;
        for (int i = 0; i < n2; ++i) {
            lvVector2.SetXYZ(0.0, 0.0, 0.0);
            lvRec.SeqPart seqPart = this.Polygon().face[this.Polygon().ngStartNo + i];
            for (n = 0; n < seqPart.num; ++n) {
                int n4 = this.Polygon().faceHalfSeq[seqPart.start + n].vtxNo;
                lvVector3.VecDt2Vector(this.Polygon().vertex[n4].pos);
                lvVector2.AddAssign(lvVector3);
            }
            lvVector2.DivAssign(seqPart.num);
            lvVector2.Vector2VecDt(this.PolyCenter().centerNG[i]);
        }
    }

    private final void SetPolyCenterNormal() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetPolyCenterNormal[0];
        lvDouble lvDouble2 = this.Gbl().tdSetPolyCenterNormal[0];
        int n = this.Polygon().ngStartNo;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            lvRec.SeqPart seqPart = this.Polygon().face[i];
            if (n2 >= seqPart.num) continue;
            n2 = seqPart.num;
        }
        lvVector[] lvVectorArray = this.NewFaceVtx(n2);
        for (int i = 0; i < n; ++i) {
            lvRec.SeqPart seqPart = this.Polygon().face[i];
            for (int j = 0; j < seqPart.num; ++j) {
                int n3 = this.Polygon().faceHalfSeq[seqPart.start + j].vtxNo;
                lvVectorArray[j].VecDt2Vector(this.Polygon().vertex[n3].pos);
            }
            lvVector2.Normal(lvVectorArray, seqPart.num, lvDouble2);
            lvVector2.Vector2VecDt(this.PolyCenter().lattice[i].center.normal);
            this.PolyCenter().lattice[i].area = lvDouble2.val;
        }
    }

    private final lvVector[] NewFaceVtx(int n) {
        lvVector[] lvVectorArray;
        if (n > 256) {
            int n2;
            lvVectorArray = new lvVector[n];
            for (n2 = 0; n2 < 256; ++n2) {
                lvVectorArray[n2] = this.Gbl().svVtxForCenter[n2];
            }
            for (n2 = 256; n2 < n; ++n2) {
                lvVectorArray[n2] = new lvVector(this.global);
            }
        } else {
            lvVectorArray = this.Gbl().svVtxForCenter;
        }
        return lvVectorArray;
    }

    private final void NewBezgon() {
        this.Bezgon().NewVertex(this.Polygon().vertex.length);
        this.Bezgon().NewEdge(this.Polygon().edge.length);
        this.Bezgon().NewFace(this.Polygon().ngStartNo);
    }

    private final int GetMaxRadial() {
        int n = 0;
        int n2 = this.Polygon().vertex.length;
        for (int i = 0; i < n2; ++i) {
            if (n >= this.Polygon().vertex[i].vtxFace.num) continue;
            n = this.Polygon().vertex[i].vtxFace.num;
        }
        return n;
    }

    private final void NewDownRadial(int n) {
        this.DownRound().radial = new lvRoundLow.DownRadial[n];
        for (int i = 0; i < n; ++i) {
            this.DownRound().radial[i] = new lvRoundLow.DownRadial(this.global);
        }
    }

    private final void NewUpRadial(int n) {
        this.UpRound().radial = new lvRoundLow.UpRadial[n];
        for (int i = 0; i < n; ++i) {
            this.UpRound().radial[i] = new lvRoundLow.UpRadial(this.global);
        }
    }

    private final void ExecMain() throws lvThrowable {
        boolean bl = true;
        int n = this.Polygon().vertex.length;
        for (int i = 0; i < n; ++i) {
            this.SetDownRound(i);
            this.Gbl().roundLow.Exec(bl, this.DownRound(), this.UpRound());
            this.SetUpRound(i);
            bl = false;
        }
        this.Gbl().roundLow.Finish();
    }

    private final void SetDownRound(int n) {
        this.DownRound().vtxPos.VecDt2Vector(this.Polygon().vertex[n].pos);
        this.DownRound().vtxRound = this.Polygon().vertex[n].round;
        lvRec.SeqPart seqPart = this.Polygon().vertex[n].vtxFace;
        this.DownRound().numRadial = seqPart.num;
        for (int i = 0; i < seqPart.num; ++i) {
            lvVector lvVector2;
            lvPolygon.InfoFaceHalf infoFaceHalf = this.Polygon().vtxFaceSeq[seqPart.start + i];
            lvRec.SeqPart seqPart2 = this.Polygon().face[infoFaceHalf.faceNo];
            lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart2.start + infoFaceHalf.halfNo];
            int n2 = (infoFaceHalf.halfNo + 1) % seqPart2.num;
            lvPolygon.FaceHalf faceHalf2 = this.Polygon().faceHalfSeq[seqPart2.start + n2];
            lvVector lvVector3 = this.DownRound().radial[i].mateVtxPos;
            lvVector3.VecDt2Vector(this.Polygon().vertex[faceHalf2.vtxNo].pos);
            this.DownRound().radial[i].edgeRound = this.Polygon().edge[faceHalf.edgeNo].allRound;
            lvVector lvVector4 = this.DownRound().radial[i].roundVec;
            lvVector4.VecDt2Vector(this.Polygon().edge[faceHalf.edgeNo].vec[faceHalf.edgeIdx]);
            if (infoFaceHalf.faceNo >= this.Polygon().ngStartNo) {
                this.DownRound().radial[i].isNG = true;
                lvVector2 = this.DownRound().radial[i].centerNG;
                lvVector2.VecDt2Vector(this.PolyCenter().centerNG[infoFaceHalf.faceNo - this.Polygon().ngStartNo]);
            } else {
                this.DownRound().radial[i].isNG = false;
                lvVector2 = this.DownRound().radial[i].center.pos;
                lvVector2.VecDt2Vector(this.PolyCenter().lattice[infoFaceHalf.faceNo].center.pos);
                lvVector lvVector5 = this.DownRound().radial[i].center.normal;
                lvVector5.VecDt2Vector(this.PolyCenter().lattice[infoFaceHalf.faceNo].center.normal);
                this.DownRound().radial[i].area = this.PolyCenter().lattice[infoFaceHalf.faceNo].area;
            }
            this.DownRound().radial[i].numINode = this.GetNumINode(seqPart2, infoFaceHalf.halfNo);
        }
    }

    private final int GetNumINode(lvRec.SeqPart seqPart, int n) {
        int n2 = 1;
        for (int i = 1; i < seqPart.num; ++i) {
            int n3 = (n + i) % seqPart.num;
            int n4 = this.Polygon().faceHalfSeq[seqPart.start + n3].vtxNo;
            int n5 = this.Polygon().vertex[n4].vtxFace.num;
            if (n5 != 2) break;
            ++n2;
        }
        return n2;
    }

    private final void SetUpRound(int n) {
        lvRec.SeqPart seqPart = this.Polygon().vertex[n].vtxFace;
        this.UpRound().vtxPos.Vector2VecDt(this.Bezgon().vertex[n].pos);
        for (int i = 0; i < seqPart.num; ++i) {
            lvPolygon.InfoFaceHalf infoFaceHalf = this.Polygon().vtxFaceSeq[seqPart.start + i];
            lvRec.SeqPart seqPart2 = this.Polygon().face[infoFaceHalf.faceNo];
            lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart2.start + infoFaceHalf.halfNo];
            lvVector lvVector2 = this.UpRound().radial[i].handVec;
            lvVector2.Vector2VecDt(this.Bezgon().edge[faceHalf.edgeNo].handVec[faceHalf.edgeIdx]);
        }
    }

    private final void FaceProc() throws lvThrowable {
        this.FaceCenterProc();
        this.FaceNormalProc();
    }

    private final void FaceCenterProc() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvFaceCenterProc[0];
        lvVector lvVector3 = this.Gbl().tvFaceCenterProc[1];
        int n = this.Polygon().ngStartNo;
        for (int i = 0; i < n; ++i) {
            lvVector2.SetXYZ(0.0, 0.0, 0.0);
            lvRec.SeqPart seqPart = this.Polygon().face[i];
            for (int j = 0; j < seqPart.num; ++j) {
                lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart.start + j];
                lvVector3.VecDt2Vector(this.Bezgon().vertex[faceHalf.vtxNo].pos);
                lvVector2.AddAssign(lvVector3);
            }
            lvVector2.DivAssign(seqPart.num);
            lvVector2.Vector2VecDt(this.Bezgon().face[i].center.pos);
        }
    }

    private final void FaceNormalProc() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvFaceNormalProc[0];
        int n = this.Polygon().ngStartNo;
        for (int i = 0; i < n; ++i) {
            this.NormalFace(i, lvVector2);
            lvVector2.Vector2VecDt(this.Bezgon().face[i].center.normal);
        }
    }

    private final void NormalFace(int n, lvVector lvVector2) throws lvThrowable {
        lvVector lvVector3 = this.Gbl().tvNormalFace[0];
        lvRec.SeqPart seqPart = this.Polygon().face[n];
        lvVector[] lvVectorArray = this.NewCtlPoint(seqPart.num * 3);
        for (int i = 0; i < seqPart.num; ++i) {
            int n2 = (i + 1) % seqPart.num;
            lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart.start + i];
            lvPolygon.FaceHalf faceHalf2 = this.Polygon().faceHalfSeq[seqPart.start + n2];
            lvVectorArray[i * 3 + 0].VecDt2Vector(this.Bezgon().vertex[faceHalf.vtxNo].pos);
            lvVectorArray[i * 3 + 1].VecDt2Vector(this.Bezgon().edge[faceHalf.edgeNo].handVec[faceHalf.edgeIdx]);
            lvVectorArray[i * 3 + 2].VecDt2Vector(this.Bezgon().edge[faceHalf.edgeNo].handVec[1 - faceHalf.edgeIdx]);
            lvVector3.VecDt2Vector(this.Bezgon().vertex[faceHalf2.vtxNo].pos);
            lvVectorArray[i * 3 + 1].AddAssign(lvVectorArray[i * 3 + 0]);
            lvVectorArray[i * 3 + 2].AddAssign(lvVector3);
        }
        lvBezLine.NormalBound(lvVectorArray, seqPart.num * 3, lvVector2);
    }

    private final lvVector[] NewCtlPoint(int n) {
        lvVector[] lvVectorArray;
        if (n > 768) {
            int n2;
            lvVectorArray = new lvVector[n];
            for (n2 = 0; n2 < 768; ++n2) {
                lvVectorArray[n2] = this.Gbl().svCtlPoint[n2];
            }
            for (n2 = 768; n2 < n; ++n2) {
                lvVectorArray[n2] = new lvVector(this.global);
            }
        } else {
            lvVectorArray = this.Gbl().svCtlPoint;
        }
        return lvVectorArray;
    }

    public static final void Position(int n, int n2, int n3, double d, lvVector lvVector2) {
        lvGlobal lvGlobal2 = lvVector2.global;
        lvRound.Local(lvGlobal2).PositionLocal(n, n2, n3, d, lvVector2);
    }

    private final void PositionLocal(int n, int n2, int n3, double d, lvVector lvVector2) {
        lvVector[] lvVectorArray = this.Gbl().tvAryPosition;
        lvPolygon.InfoFaceHalf infoFaceHalf = this.Polygon((int)n).edge[n2].face[n3];
        lvRec.SeqPart seqPart = this.Polygon((int)n).face[infoFaceHalf.faceNo];
        int n4 = this.Polygon((int)n).faceHalfSeq[seqPart.start + infoFaceHalf.halfNo].vtxNo;
        lvPolygon.InfoFaceHalf infoFaceHalf2 = this.Polygon((int)n).edge[n2].face[1 - n3];
        lvRec.SeqPart seqPart2 = this.Polygon((int)n).face[infoFaceHalf2.faceNo];
        int n5 = this.Polygon((int)n).faceHalfSeq[seqPart2.start + infoFaceHalf2.halfNo].vtxNo;
        lvVectorArray[0].VecDt2Vector(this.Bezgon((int)n).vertex[n4].pos);
        lvVectorArray[1].VecDt2Vector(this.Bezgon((int)n).edge[n2].handVec[n3]);
        lvVectorArray[2].VecDt2Vector(this.Bezgon((int)n).edge[n2].handVec[1 - n3]);
        lvVectorArray[3].VecDt2Vector(this.Bezgon((int)n).vertex[n5].pos);
        lvVectorArray[1].AddAssign(lvVectorArray[0]);
        lvVectorArray[2].AddAssign(lvVectorArray[3]);
        lvBezLine.Position(lvVectorArray, d, lvVector2);
    }

    private final void Finish() {
        this.DownRound().radial = null;
        this.UpRound().radial = null;
    }

    public static class Global {
        private int curShellNo = 0;
        private lvRoundLow roundLow = null;
        private lvRoundLow.DownRound downRound = null;
        private lvRoundLow.UpRound upRound = null;
        private lvRound local = null;
        private lvVector[] tvSetPolyCenterPos = null;
        private lvVector[] tvSetPolyCenterNormal = null;
        private lvDouble[] tdSetPolyCenterNormal = null;
        private lvVector[] tvFaceCenterProc = null;
        private lvVector[] tvFaceNormalProc = null;
        private lvVector[] tvNormalFace = null;
        private lvVector[] tvAryPosition = null;
        private lvVector[] tvAryDerivative = null;
        private lvVector[] svVtxForCenter = null;
        private lvVector[] svCtlPoint = null;

        public Global(lvGlobal lvGlobal2) {
            this.roundLow = new lvRoundLow(lvGlobal2);
            this.downRound = new lvRoundLow.DownRound(lvGlobal2);
            this.upRound = new lvRoundLow.UpRound(lvGlobal2);
            this.local = new lvRound(lvGlobal2);
            this.GlobalTmp(lvGlobal2);
            this.GlobalStatic(lvGlobal2);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tvSetPolyCenterPos = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetPolyCenterPos[n] = new lvVector(lvGlobal2);
            }
            this.tvSetPolyCenterNormal = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvSetPolyCenterNormal[n] = new lvVector(lvGlobal2);
            }
            this.tdSetPolyCenterNormal = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdSetPolyCenterNormal[n] = new lvDouble(lvGlobal2);
            }
            this.tvFaceCenterProc = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvFaceCenterProc[n] = new lvVector(lvGlobal2);
            }
            this.tvFaceNormalProc = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvFaceNormalProc[n] = new lvVector(lvGlobal2);
            }
            this.tvNormalFace = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvNormalFace[n] = new lvVector(lvGlobal2);
            }
            this.tvAryPosition = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvAryPosition[n] = new lvVector(lvGlobal2);
            }
            this.tvAryDerivative = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvAryDerivative[n] = new lvVector(lvGlobal2);
            }
        }

        private final void GlobalStatic(lvGlobal lvGlobal2) {
            int n;
            this.svVtxForCenter = new lvVector[256];
            for (n = 0; n < 256; ++n) {
                this.svVtxForCenter[n] = new lvVector(lvGlobal2);
            }
            this.svCtlPoint = new lvVector[768];
            for (n = 0; n < 768; ++n) {
                this.svCtlPoint[n] = new lvVector(lvGlobal2);
            }
        }
    }
}

