/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.greg.t0g;

import jp.co.lattice.vKernel.core.c0.lvComGblElm;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvPolygon;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVecDt;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.greg.c0g.lv0ComGGblElm;
import jp.co.lattice.vKernel.greg.c0g.lvBezLine;
import jp.co.lattice.vKernel.greg.c0g.lvPolyDerive;
import jp.co.lattice.vKernel.greg.t0g.lv0TopoGGblElm;

public class lvConvGreg
extends lvRoot {
    private static final int maxNumHalfEdge = 256;

    private final Global Gbl() {
        return ((lv0TopoGGblElm)this.global.GTopoG()).gConvGreg;
    }

    private final lvPolygon Polygon() {
        return ((lvComGblElm)this.global.GCom()).gModelPoly.shell[((Global)this.Gbl()).curShellNo].poly;
    }

    private final lvPolyDerive.Bezgon Bezgon() {
        return ((lv0ComGGblElm)this.global.GComG()).gModelGreg.shell[((Global)this.Gbl()).curShellNo].bez;
    }

    public lvConvGreg(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public void Exec(int n) throws lvThrowable {
        this.Gbl().curShellNo = n;
        this.NewBezgon();
        this.ExecMain();
        this.FaceProc();
    }

    private final void NewBezgon() {
        this.Bezgon().NewVertex(this.Polygon().vertex.length);
        this.Bezgon().NewEdge(this.Polygon().edge.length);
        this.Bezgon().NewFace(this.Polygon().ngStartNo);
    }

    private final void ExecMain() throws lvThrowable {
        this.ExecVertex();
        this.ExecEdge();
    }

    private final void ExecVertex() throws lvThrowable {
        int n = this.Polygon().vertex.length;
        for (int i = 0; i < n; ++i) {
            lvVecDt.Copy(this.Polygon().vertex[i].pos, this.Bezgon().vertex[i].pos);
        }
    }

    private final void ExecEdge() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvExecMain[0];
        int n = this.Polygon().edge.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                lvVector2.VecDt2Vector(this.Polygon().edge[i].vec[j]);
                lvVector2.DivAssign(3.0);
                lvVector2.Vector2VecDt(this.Bezgon().edge[i].handVec[j]);
            }
        }
    }

    private final void FaceProc() throws lvThrowable {
        this.FaceCenterProc();
        this.FaceNormalProc();
    }

    private final void FaceCenterProc() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvFaceCenterProc[0];
        lvVector lvVector3 = this.Gbl().tvFaceCenterProc[1];
        int n = this.Polygon().ngStartNo;
        for (int i = 0; i < n; ++i) {
            lvVector2.SetXYZ(0.0, 0.0, 0.0);
            lvRec.SeqPart seqPart = this.Polygon().face[i];
            for (int j = 0; j < seqPart.num; ++j) {
                lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart.start + j];
                lvVector3.VecDt2Vector(this.Bezgon().vertex[faceHalf.vtxNo].pos);
                lvVector2.AddAssign(lvVector3);
            }
            lvVector2.DivAssign(seqPart.num);
            lvVector2.Vector2VecDt(this.Bezgon().face[i].center.pos);
        }
    }

    private final void FaceNormalProc() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvFaceNormalProc[0];
        int n = this.Polygon().ngStartNo;
        for (int i = 0; i < n; ++i) {
            this.NormalFace(i, lvVector2);
            lvVector2.Vector2VecDt(this.Bezgon().face[i].center.normal);
        }
    }

    private final void NormalFace(int n, lvVector lvVector2) throws lvThrowable {
        lvVector lvVector3 = this.Gbl().tvNormalFace[0];
        lvRec.SeqPart seqPart = this.Polygon().face[n];
        lvVector[] lvVectorArray = this.NewCtlPoint(seqPart.num * 3);
        for (int i = 0; i < seqPart.num; ++i) {
            int n2 = (i + 1) % seqPart.num;
            lvPolygon.FaceHalf faceHalf = this.Polygon().faceHalfSeq[seqPart.start + i];
            lvPolygon.FaceHalf faceHalf2 = this.Polygon().faceHalfSeq[seqPart.start + n2];
            lvVectorArray[i * 3 + 0].VecDt2Vector(this.Bezgon().vertex[faceHalf.vtxNo].pos);
            lvVectorArray[i * 3 + 1].VecDt2Vector(this.Bezgon().edge[faceHalf.edgeNo].handVec[faceHalf.edgeIdx]);
            lvVectorArray[i * 3 + 2].VecDt2Vector(this.Bezgon().edge[faceHalf.edgeNo].handVec[1 - faceHalf.edgeIdx]);
            lvVector3.VecDt2Vector(this.Bezgon().vertex[faceHalf2.vtxNo].pos);
            lvVectorArray[i * 3 + 1].AddAssign(lvVectorArray[i * 3 + 0]);
            lvVectorArray[i * 3 + 2].AddAssign(lvVector3);
        }
        lvBezLine.NormalBound(lvVectorArray, seqPart.num * 3, lvVector2);
    }

    private final lvVector[] NewCtlPoint(int n) {
        lvVector[] lvVectorArray;
        if (n > 768) {
            int n2;
            lvVectorArray = new lvVector[n];
            for (n2 = 0; n2 < 768; ++n2) {
                lvVectorArray[n2] = this.Gbl().svCtlPoint[n2];
            }
            for (n2 = 768; n2 < n; ++n2) {
                lvVectorArray[n2] = new lvVector(this.global);
            }
        } else {
            lvVectorArray = this.Gbl().svCtlPoint;
        }
        return lvVectorArray;
    }

    public static class Global {
        private int curShellNo = 0;
        private lvVector[] tvExecMain = null;
        private lvVector[] tvFaceCenterProc = null;
        private lvVector[] tvFaceNormalProc = null;
        private lvVector[] tvNormalFace = null;
        private lvVector[] svCtlPoint = null;

        public Global(lvGlobal lvGlobal2) {
            this.GlobalTmp(lvGlobal2);
            this.GlobalStatic(lvGlobal2);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tvExecMain = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvExecMain[n] = new lvVector(lvGlobal2);
            }
            this.tvFaceCenterProc = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvFaceCenterProc[n] = new lvVector(lvGlobal2);
            }
            this.tvFaceNormalProc = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvFaceNormalProc[n] = new lvVector(lvGlobal2);
            }
            this.tvNormalFace = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvNormalFace[n] = new lvVector(lvGlobal2);
            }
        }

        private final void GlobalStatic(lvGlobal lvGlobal2) {
            this.svCtlPoint = new lvVector[768];
            for (int i = 0; i < 768; ++i) {
                this.svCtlPoint[i] = new lvVector(lvGlobal2);
            }
        }
    }
}

