/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.greg.g0g;

import jp.co.lattice.vKernel.core.c0.lvDouble;
import jp.co.lattice.vKernel.core.c0.lvEps;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVecCalc;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.greg.g0g.lv0GeomGGblElm;

public class lvRoundLow
extends lvRoot {
    private static final double def_fact = 0.585786437626905;
    private static final double min_fact = 0.25;
    private static final double max_fact = 0.75;
    private static final double vx3_fact = 1.2122200273534458;

    private final Global Gbl() {
        return ((lv0GeomGGblElm)this.global.GGeomG()).gRoundLow;
    }

    private final DownRound DownRound() {
        return this.Gbl().curDownRound;
    }

    private final UpRound UpRound() {
        return this.Gbl().curUpRound;
    }

    private final TmpRound0 TmpRound0() {
        return this.Gbl().tmpRound0;
    }

    private final TmpRound1 TmpRound1() {
        return this.Gbl().tmpRound1;
    }

    public lvRoundLow(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public final void Exec(boolean bl, DownRound downRound, UpRound upRound) throws lvThrowable {
        this.Gbl().curDownRound = downRound;
        this.Gbl().curUpRound = upRound;
        if (bl) {
            int n = this.DownRound().radial.length;
            this.NewTmpRadial0(n);
            this.NewTmpRadial1(n);
            this.NewTmpRadial1a(n);
            this.Gbl().NewCorrectEdgeCenter(this.global, n);
            this.Gbl().NewSetEdgeNormal(n);
            this.Gbl().NewSetEdgeNormalMain(this.global, n + 1);
        }
        this.SetTmpRound0();
        this.SetTmpRound1();
    }

    private final void NewTmpRadial0(int n) {
        TmpRound0.access$802(this.TmpRound0(), new TmpRadial0[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpRound0)this.TmpRound0()).radial[i] = new TmpRadial0();
        }
    }

    private final void NewTmpRadial1(int n) {
        TmpRound1.access$1002(this.TmpRound1(), new TmpRadial1[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpRound1)this.TmpRound1()).radial[i] = new TmpRadial1(this.global);
        }
    }

    private final void NewTmpRadial1a(int n) {
        TmpRound1.access$1102(this.TmpRound1(), new TmpRadial1a[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpRound1)this.TmpRound1()).radialA[i] = new TmpRadial1a();
        }
    }

    private final void SetTmpRound0() throws lvThrowable {
        this.SetRoundVtx();
        this.SetTmpRadial0();
        this.GetCorrectVtxRound();
        this.SetTmpRound0Main();
        this.Err().Assert(0 <= this.TmpRound0().numRoundEdge && this.TmpRound0().numRoundEdge <= this.DownRound().numRadial, "lvRoundLow.SetTmpRound0(0)");
    }

    private final void SetRoundVtx() {
        if (this.DownRound().vtxRound > 1.0E-8) {
            this.TmpRound0().enableVtx = true;
        } else {
            this.TmpRound0().enableVtx = false;
        }
    }

    private final void SetTmpRadial0() throws lvThrowable {
        int n;
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            int n2 = (n + this.DownRound().numRadial - 1) % this.DownRound().numRadial;
            if (!this.TmpRound0().enableVtx) {
                this.TmpRound0().radial[n].enableEdge = false;
                continue;
            }
            if (this.DownRound().radial[n].isNG) {
                this.TmpRound0().radial[n].enableEdge = false;
                continue;
            }
            if (this.DownRound().radial[n2].isNG) {
                this.TmpRound0().radial[n].enableEdge = false;
                continue;
            }
            if (this.DownRound().radial[n].edgeRound <= 1.0E-8) {
                this.TmpRound0().radial[n].enableEdge = false;
                continue;
            }
            this.TmpRound0().radial[n].enableEdge = true;
        }
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            if (this.TmpRound0().radial[n].enableEdge) {
                this.TmpRound0().radial[n].tmpNewEdgeRound = this.DownRound().radial[n].edgeRound;
            } else {
                this.TmpRound0().radial[n].tmpNewEdgeRound = 0.0;
            }
            this.Err().Assert(this.TmpRound0().radial[n].tmpNewEdgeRound >= 0.0, "lvRoundLow.SetTmpRadial0(0)");
        }
        this.TmpRound0().numRoundEdge = 0;
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            if (!this.TmpRound0().radial[n].enableEdge) continue;
            this.TmpRound0().numRoundEdge++;
        }
    }

    private final void GetCorrectVtxRound() {
        this.TmpRound0().newVtxRound = 1.0;
        if (this.TmpRound0().enableVtx) {
            this.TmpRound0().newVtxRound = this.DownRound().vtxRound;
        }
        if (this.DownRound().numRadial == 3 && this.TmpRound0().numRoundEdge == this.DownRound().numRadial) {
            this.TmpRound0().newVtxRound *= 1.2122200273534458;
        }
    }

    private final void SetTmpRound0Main() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            int n = (i + this.DownRound().numRadial - 1) % this.DownRound().numRadial;
            int n2 = (i + 1) % this.DownRound().numRadial;
            if (this.TmpRound0().radial[n].enableEdge && this.TmpRound0().radial[n2].enableEdge) {
                d = this.TmpRound0().radial[n].tmpNewEdgeRound * 0.585786437626905;
                d2 = this.TmpRound0().radial[n2].tmpNewEdgeRound * 0.585786437626905;
            } else if (this.TmpRound0().radial[n].enableEdge) {
                d = d2 = this.TmpRound0().radial[n].tmpNewEdgeRound * 0.585786437626905;
            } else if (this.TmpRound0().radial[n2].enableEdge) {
                d = d2 = this.TmpRound0().radial[n2].tmpNewEdgeRound * 0.585786437626905;
            } else if (this.DownRound().numRadial > 2) {
                d2 = 0.5;
                d = 0.5;
            } else {
                d2 = 0.585786437626905;
                d = 0.585786437626905;
            }
            double d3 = this.TmpRound0().newVtxRound * (d + d2) * 0.5;
            if (d3 < 0.25) {
                d3 = 0.25;
            } else if (d3 > 0.75) {
                d3 = 0.75;
            }
            this.TmpRound0().radial[i].newEdgeRound = d3;
        }
    }

    private final void SetTmpRound1() throws lvThrowable {
        this.SetFaceCenter();
        this.SetEdgeCenter();
        this.SetNewVtxPos();
        this.CorrectEdgeCenter();
        this.SetEdgeNormal();
        this.SetHandVec();
    }

    private final void SetFaceCenter() {
        lvVector lvVector2 = this.Gbl().tvSetFaceCenter[0];
        lvVector lvVector3 = this.Gbl().tvSetFaceCenter[1];
        lvVector lvVector4 = this.Gbl().tvSetFaceCenter[2];
        lvDouble lvDouble2 = this.Gbl().tdSetFaceCenter[0];
        lvVector lvVector5 = this.DownRound().vtxPos;
        this.TmpRound1().hasNG = false;
        this.TmpRound1().numRoundEdgeA = 0;
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            boolean bl;
            int n = (i + 1) % this.DownRound().numRadial;
            lvVector2.Assign(lvVector5.Add(this.DownRound().radial[i].mateVtxPos).Mul(0.5));
            lvVector3.Assign(lvVector5.Add(this.DownRound().radial[n].mateVtxPos).Mul(0.5));
            lvVector lvVector6 = this.DownRound().radial[i].isNG ? this.DownRound().radial[i].centerNG : this.DownRound().radial[i].center.pos;
            double d = this.TmpRound0().radial[i].newEdgeRound;
            double d2 = this.TmpRound0().radial[n].newEdgeRound;
            lvVector4.SetXYZ(0.0, 0.0, 0.0);
            lvVector4.AddAssign(lvDouble2.Set((1.0 - d) * (1.0 - d2)).Mul(lvVector5));
            lvVector4.AddAssign(lvDouble2.Set(d * (1.0 - d2)).Mul(lvVector2));
            lvVector4.AddAssign(lvDouble2.Set((1.0 - d) * d2).Mul(lvVector3));
            lvVector4.AddAssign(lvDouble2.Set(d * d2).Mul(lvVector6));
            if (this.DownRound().radial[i].isNG) {
                this.TmpRound1().radial[i].faceCenterNG.Assign(lvVector4);
            } else {
                this.TmpRound1().radial[i].faceCenter.Assign(lvVector4);
            }
            if (this.DownRound().radial[i].isNG) {
                this.TmpRound1().hasNG = true;
            }
            if (this.DownRound().radial[i].isNG) {
                bl = false;
            } else if (this.DownRound().radial[n].isNG) {
                bl = false;
            }
            bl = !(this.DownRound().radial[i].edgeRound <= 1.0E-8);
            if (!bl) continue;
            this.TmpRound1().numRoundEdgeA++;
        }
    }

    private final void SetEdgeCenter() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetEdgeCenter[0];
        lvVector lvVector3 = this.Gbl().tvSetEdgeCenter[1];
        lvDouble lvDouble2 = this.Gbl().tdSetEdgeCenter[0];
        lvDouble lvDouble3 = this.Gbl().tdSetEdgeCenter[1];
        lvVector lvVector4 = this.DownRound().vtxPos;
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            int n = (i + this.DownRound().numRadial - 1) % this.DownRound().numRadial;
            if (this.TmpRound0().radial[i].enableEdge) {
                this.Err().Assert(!this.DownRound().radial[n].isNG, "lvRoundLow.SetEdgeCenter(0)");
                this.Err().Assert(!this.DownRound().radial[i].isNG, "lvRoundLow.SetEdgeCenter(1)");
                lvVector lvVector5 = this.TmpRound1().radial[i].edgeCenter;
                lvVector5.Assign(this.TmpRound1().radial[n].faceCenter.Add(this.TmpRound1().radial[i].faceCenter).Mul(0.5));
                if (this.DownRound().numRadial != 2) continue;
                lvVector2.Assign(lvVector4.Add(this.DownRound().radial[n].mateVtxPos).Mul(0.5));
                lvVector3.Assign(lvVector4.Add(this.DownRound().radial[i].mateVtxPos).Mul(0.5));
                lvVector5.AddAssign(lvVector3.Sub(lvVector2).Div(6.0));
                continue;
            }
            double d = this.TmpRound0().radial[i].newEdgeRound * 0.5;
            lvVector lvVector6 = this.DownRound().radial[i].mateVtxPos;
            lvVector lvVector7 = this.TmpRound1().radial[i].edgeCenter;
            lvVector7.Assign(lvDouble2.Set(1.0 - d).Mul(lvVector4).Add(lvDouble3.Set(d).Mul(lvVector6)));
        }
    }

    private final void SetNewVtxPos() throws lvThrowable {
        if (this.TmpRound0().numRoundEdge == this.DownRound().numRadial || this.TmpRound0().numRoundEdge == this.DownRound().numRadial - 1) {
            this.UpRound().vtxPos.SetXYZ(0.0, 0.0, 0.0);
            for (int i = 0; i < this.DownRound().numRadial; ++i) {
                this.UpRound().vtxPos.AddAssign(this.TmpRound1().radial[i].faceCenter);
            }
            this.UpRound().vtxPos.DivAssign(this.DownRound().numRadial);
        } else if (this.TmpRound0().numRoundEdge == this.DownRound().numRadial - 2 && this.TmpRound0().enableVtx) {
            this.UpRound().vtxPos.SetXYZ(0.0, 0.0, 0.0);
            int n = 0;
            for (int i = 0; i < this.DownRound().numRadial; ++i) {
                if (this.TmpRound0().radial[i].enableEdge) continue;
                this.UpRound().vtxPos.AddAssign(this.TmpRound1().radial[i].edgeCenter);
                ++n;
            }
            this.Err().Assert(n == 2, "lvRoundLow.SetNewVtxPos(0)");
            this.UpRound().vtxPos.DivAssign(2.0);
        } else {
            this.UpRound().vtxPos.Assign(this.DownRound().vtxPos);
        }
    }

    private final void CorrectEdgeCenter() throws lvThrowable {
        int n;
        lvVector lvVector2 = this.Gbl().tvCorrectEdgeCenter[0];
        lvVector lvVector3 = this.Gbl().tvCorrectEdgeCenter[1];
        lvVector lvVector4 = this.Gbl().tvCorrectEdgeCenter[2];
        lvVector[] lvVectorArray = this.Gbl().tvAryCorrectEdgeCenter0;
        lvVector[] lvVectorArray2 = this.Gbl().tvAryCorrectEdgeCenter1;
        lvVector[] lvVectorArray3 = this.Gbl().tvAryCorrectEdgeCenter2;
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            lvVectorArray[n] = this.DownRound().radial[n].isNG ? this.TmpRound1().radial[n].faceCenterNG : this.TmpRound1().radial[n].faceCenter;
            lvVectorArray2[n].Assign(this.DownRound().radial[n].center.normal);
            lvVectorArray2[n].MulAssign(Math.sqrt(this.DownRound().radial[n].area) * 0.5);
        }
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            if (!this.SetFaceCoordSys(n, lvVectorArray, lvVectorArray2, lvVector2, lvVector3, lvVector4)) continue;
            lvVector lvVector5 = this.DownRound().radial[n].roundVec;
            lvVectorArray3[n].Assign(this.UpRound().vtxPos);
            lvVectorArray3[n].AddAssign(lvVector2.Mul(lvVector5.x));
            lvVectorArray3[n].AddAssign(lvVector3.Mul(lvVector5.y));
            lvVectorArray3[n].AddAssign(lvVector4.Mul(lvVector5.z));
        }
        for (n = 0; n < this.DownRound().numRadial; ++n) {
            this.TmpRound1().radial[n].edgeCenter.Assign(lvVectorArray3[n]);
        }
    }

    private final boolean SetFaceCoordSys(int n, lvVector[] lvVectorArray, lvVector[] lvVectorArray2, lvVector lvVector2, lvVector lvVector3, lvVector lvVector4) throws lvThrowable {
        double d;
        double d2;
        lvVector lvVector5;
        block18: {
            block17: {
                int n2;
                lvDouble lvDouble2;
                block16: {
                    block15: {
                        lvDouble2 = this.Gbl().tdSetFaceCoordSys[0];
                        int n3 = (n + this.DownRound().numRadial - 1) % this.DownRound().numRadial;
                        int n4 = (n3 + this.DownRound().numRadial - 1) % this.DownRound().numRadial;
                        n2 = (n3 + 1) % this.DownRound().numRadial;
                        int n5 = (n3 + 2) % this.DownRound().numRadial;
                        if (this.DownRound().numRadial > 2) {
                            lvVector2.Assign(lvVectorArray[n3].Add(lvVectorArray[n4]).Mul(0.5));
                            lvVector2.SubAssign(lvVectorArray[n2].Add(lvVectorArray[n5]).Mul(0.5));
                            lvVector2.MulAssign(0.5);
                            lvVector3.Assign(lvVectorArray[n2].Add(lvVectorArray[n3]).Mul(0.5));
                            lvVector3.SubAssign(this.UpRound().vtxPos);
                            lvVector4.Normal(lvVectorArray, this.DownRound().numRadial, lvDouble2);
                            lvVector4.NegAssign();
                            lvVector4.MulAssign(lvDouble2.val);
                        } else {
                            lvVector2.Assign(lvVectorArray[n3].Sub(lvVectorArray[n2]).Mul(0.5));
                            if (!lvVector2.IsZero()) {
                                lvVector3.Assign(this.TmpRound1().radial[n2].edgeCenter.Sub(this.UpRound().vtxPos));
                                lvVector4.Assign(lvVectorArray[1]);
                                lvVector4.NormalAssign((lvVecCalc)this.TmpRound1().radial[1].edgeCenter, (lvVecCalc)lvVectorArray[0], this.TmpRound1().radial[0].edgeCenter, lvDouble2);
                            } else {
                                lvVector5 = lvVectorArray2[n3];
                                lvVector lvVector6 = lvVectorArray2[n2];
                                if (lvVector5.IsZero() == lvVector6.IsZero()) {
                                    return false;
                                }
                                if (lvVector6.IsZero()) {
                                    lvVector2.Assign(lvVector5.Neg());
                                } else {
                                    lvVector2.Assign(lvVector6.Neg());
                                }
                                lvVector3.Assign(this.TmpRound1().radial[n2].edgeCenter.Sub(this.UpRound().vtxPos));
                                lvVector4.Assign(lvVector2.Cross(lvVector3));
                                lvDouble2.val = lvVector4.Length();
                            }
                        }
                        if (lvVector2.IsZero() || lvVector3.IsZero()) break block15;
                        this.Eps();
                        if (!lvEps.IsZero(lvDouble2.val)) break block16;
                    }
                    return false;
                }
                lvVector4.DivAssign(Math.sqrt(lvDouble2.val));
                lvVector5 = this.Gbl().tvSetFaceCoordSys[0];
                lvVector5.Assign(this.TmpRound1().radial[n2].edgeCenter.Sub(this.UpRound().vtxPos));
                if (lvVector3.IsSame(lvVector5)) {
                    return true;
                }
                d2 = lvVector3.Length();
                d = lvVector5.Length();
                this.Eps();
                if (lvEps.IsZero(d2)) break block17;
                this.Eps();
                if (!lvEps.IsZero(d)) break block18;
            }
            return false;
        }
        double d3 = d / d2;
        lvVector lvVector7 = this.Gbl().tvSetFaceCoordSys[1];
        lvVector lvVector8 = this.Gbl().tvSetFaceCoordSys[2];
        lvVector lvVector9 = this.Gbl().tvSetFaceCoordSys[3];
        lvVector7.Assign(lvVector3.Div(d2));
        lvVector8.Assign(lvVector5.Div(d));
        lvVector9.Assign(lvVector7.Cross(lvVector8).Unit(1.0E-8));
        if (!lvVector9.IsZero()) {
            double d4 = lvVector7.Angle(lvVector8);
            lvVector2.Rotate(lvVector9, d4);
            lvVector3.Rotate(lvVector9, d4);
            lvVector4.Rotate(lvVector9, d4);
        }
        lvVector2.MulAssign(d3);
        lvVector3.MulAssign(d3);
        lvVector4.MulAssign(d3);
        this.Err().Assert(lvVector5.IsSame(lvVector3), "lvRoundLow.SetFaceCoordSys(0)");
        return true;
    }

    private final void SetEdgeNormal() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetEdgeNormal[0];
        lvVector[] lvVectorArray = this.Gbl().tvArySetEdgeNormal;
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            lvVectorArray[i] = this.TmpRound1().radial[i].edgeCenter;
        }
        if (this.TmpRound0().numRoundEdge >= this.DownRound().numRadial - 1) {
            lvVector2.Normal(lvVectorArray, this.DownRound().numRadial);
            this.TmpRound1().edgeNormalPoly.Assign(lvVector2);
        } else {
            if (this.TmpRound0().numRoundEdge == this.DownRound().numRadial - 2 && this.TmpRound0().enableVtx) {
                this.SetEdgeNormal2();
            }
            if (!this.TmpRound0().enableVtx && this.TmpRound1().hasNG && this.TmpRound1().numRoundEdgeA == this.DownRound().numRadial - 2) {
                this.SetEdgeNormalNG();
            }
            this.SetFactForEdgeNormal();
            this.SetEdgeNormalMain();
        }
    }

    private final void SetEdgeNormal2() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetEdgeNormal2[0];
        lvVector lvVector3 = this.Gbl().tvSetEdgeNormal2[1];
        lvVector lvVector4 = this.Gbl().tvSetEdgeNormal2[2];
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            if (this.TmpRound0().radial[i].enableEdge) continue;
            if (n < 0) {
                n = i;
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
            break;
        }
        this.Err().Assert(n >= 0 && n2 >= 0, "lvRoundLow.SetEdgeNormal2(0)");
        lvVector3.Assign(this.TmpRound1().radial[n].edgeCenter.Sub(this.UpRound().vtxPos));
        lvVector4.Assign(this.TmpRound1().radial[n2].edgeCenter.Sub(this.UpRound().vtxPos));
        lvVector2.Assign(lvVector4.Sub(lvVector3).Unit());
        lvVector lvVector5 = this.TmpRound1().radial[n].edgeCenter;
        lvVector lvVector6 = this.TmpRound1().radial[n2].edgeCenter;
        if (!lvVector2.IsZero(1.0E-15)) {
            lvVector5.Assign(this.UpRound().vtxPos.Add(lvVector2.DotR(lvVector3).Mul(lvVector2)));
            lvVector6.Assign(this.UpRound().vtxPos.Add(lvVector2.DotR(lvVector4).Mul(lvVector2)));
        }
    }

    private final void SetEdgeNormalNG() throws lvThrowable {
        for (int i = 0; i < this.DownRound().numRadial; ++i) {
            boolean bl;
            this.Err().Assert(!this.TmpRound0().radial[i].enableEdge, "lvRoundLow.SetEdgeNormalNG(0)");
            int n = (i + 1) % this.DownRound().numRadial;
            if (this.DownRound().radial[i].isNG) {
                bl = false;
            } else if (this.DownRound().radial[n].isNG) {
                bl = false;
            }
            bl = !(this.DownRound().radial[i].edgeRound <= 1.0E-8);
            if (!bl) continue;
            this.TmpRound0().radial[i].enableEdge = true;
            this.TmpRound0().numRoundEdge++;
        }
        this.Err().Assert(this.TmpRound0().numRoundEdge <= this.DownRound().numRadial - 2, "lvRoundLow.SetEdgeNormalNG(0)");
    }

    private final void SetFactForEdgeNormal() throws lvThrowable {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        this.TmpRound1().tmpRadialNoOrg = 0;
        for (n3 = 0; n3 < this.DownRound().numRadial; ++n3) {
            if (this.TmpRound0().radial[n3].enableEdge) continue;
            this.TmpRound1().tmpRadialNoOrg = n3;
            bl = true;
            break;
        }
        this.Err().Assert(bl, "lvRoundLow.SetFactForEdgeNormal(0)");
        n3 = this.DownRound().numRadial - this.TmpRound0().numRoundEdge;
        int n4 = (this.TmpRound1().tmpRadialNoOrg + 1) % this.DownRound().numRadial;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = 0;
            int n6 = (n5 + n4) % this.DownRound().numRadial;
            while (this.TmpRound0().radial[n6].enableEdge) {
                ++n;
                n6 = (++n5 + n4) % this.DownRound().numRadial;
            }
            ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[n2]).numSharpToSharp.num = n + 1;
            ++n5;
        }
        this.Err().Assert(n5 == this.DownRound().numRadial, "lvRoundLow.SetFactForEdgeNormal(1)");
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[n]).numSharpToSharp.start = n2;
            n2 += ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[n]).numSharpToSharp.num;
        }
        this.Err().Assert(n2 == this.DownRound().numRadial, "lvRoundLow.SetFactForEdgeNormal(2)");
    }

    private final void SetEdgeNormalMain() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetEdgeNormalMain[0];
        lvVector lvVector3 = this.Gbl().tvSetEdgeNormalMain[1];
        lvVector lvVector4 = this.Gbl().tvSetEdgeNormalMain[2];
        lvVector[] lvVectorArray = this.Gbl().tvArySetEdgeNormalMain;
        int n = this.DownRound().numRadial - this.TmpRound0().numRoundEdge;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            lvVectorArray[0].Assign(this.UpRound().vtxPos);
            int n4 = this.TmpRound1().tmpRadialNoOrg + ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[i]).numSharpToSharp.start;
            for (n3 = 0; n3 < ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[i]).numSharpToSharp.num + 1; ++n3) {
                n2 = (n4 + n3) % this.DownRound().numRadial;
                lvVectorArray[n3 + 1].Assign(this.TmpRound1().radial[n2].edgeCenter);
            }
            lvVector2.Normal(lvVectorArray, ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[i]).numSharpToSharp.num + 2);
            n3 = ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[i]).numSharpToSharp.num + 1;
            if (lvVectorArray[0].IsLine(lvVectorArray[1], lvVectorArray[n3])) {
                lvVector3.Assign(lvVectorArray[n3].Sub(lvVectorArray[1]).Unit());
                if (!(lvVector2.IsZero() || lvVector3.IsZero() || lvVector2.IsPara(lvVector3))) {
                    lvVector2.SubAssign(lvVector2.DotR(lvVector3).Mul(lvVector3));
                    lvVector2.UnitAssign();
                }
                lvVector4.Assign(lvVector2.Neg());
            } else {
                lvVector4.Assign(lvVectorArray[0]);
                lvVector4.NormalAssign(lvVectorArray[1], lvVectorArray[n3]);
                if (lvVector2.Dot(lvVector4) < 0.0) {
                    lvVector4.NegAssign();
                }
                lvVector4.NegAssign();
            }
            for (n2 = 0; n2 < ((TmpRadial1a)((TmpRound1)this.TmpRound1()).radialA[i]).numSharpToSharp.num; ++n2) {
                int n5 = (n4 + n2) % this.DownRound().numRadial;
                this.TmpRound1().radial[n5].edgeNormal.Assign(lvVector4);
            }
        }
    }

    private final void SetHandVec() {
        lvVector lvVector2 = this.Gbl().tvSetHandVec[0];
        if (this.TmpRound0().numRoundEdge >= this.DownRound().numRadial - 1) {
            for (int i = 0; i < this.DownRound().numRadial; ++i) {
                lvVector2.Assign(this.TmpRound1().radial[i].edgeCenter.Sub(this.UpRound().vtxPos).Mul(1.3333333333333333));
                lvVector2.MulAssign(this.GetMulFactForHandVec(i));
                lvVector2.SubAssign(lvVector2.DotR(this.TmpRound1().edgeNormalPoly).Mul(this.TmpRound1().edgeNormalPoly));
                this.UpRound().radial[i].handVec.Assign(lvVector2);
            }
        } else {
            for (int i = 0; i < this.DownRound().numRadial; ++i) {
                lvVector2.Assign(this.TmpRound1().radial[i].edgeCenter.Sub(this.UpRound().vtxPos).Mul(1.3333333333333333));
                lvVector2.MulAssign(this.GetMulFactForHandVec(i));
                if (this.TmpRound0().radial[i].enableEdge) {
                    lvVector2.SubAssign(lvVector2.DotR(this.TmpRound1().radial[i].edgeNormal).Mul(this.TmpRound1().radial[i].edgeNormal));
                }
                this.UpRound().radial[i].handVec.Assign(lvVector2);
            }
        }
    }

    private final double GetMulFactForHandVec(int n) {
        if (this.DownRound().numRadial <= 2) {
            return 1.0;
        }
        if (this.DownRound().radial[n].numINode <= 1) {
            return 1.0;
        }
        return 4.0 / (3.0 * (double)this.DownRound().radial[n].numINode);
    }

    public final void Finish() {
        this.Gbl().curDownRound = null;
        TmpRound0.access$802(this.TmpRound0(), null);
        TmpRound1.access$1002(this.TmpRound1(), null);
        TmpRound1.access$1102(this.TmpRound1(), null);
    }

    public static class Global {
        private DownRound curDownRound = null;
        private UpRound curUpRound = null;
        private TmpRound0 tmpRound0 = new TmpRound0();
        private TmpRound1 tmpRound1 = null;
        private lvVector[] tvSetFaceCenter = null;
        private lvDouble[] tdSetFaceCenter = null;
        private lvVector[] tvSetEdgeCenter = null;
        private lvDouble[] tdSetEdgeCenter = null;
        private lvVector[] tvCorrectEdgeCenter = null;
        private lvVector[] tvAryCorrectEdgeCenter0 = null;
        private lvVector[] tvAryCorrectEdgeCenter1 = null;
        private lvVector[] tvAryCorrectEdgeCenter2 = null;
        private lvVector[] tvSetFaceCoordSys = null;
        private lvDouble[] tdSetFaceCoordSys = null;
        private lvVector[] tvArySetEdgeNormal = null;
        private lvVector[] tvSetEdgeNormal = null;
        private lvVector[] tvSetEdgeNormal2 = null;
        private lvVector[] tvSetEdgeNormalMain = null;
        private lvVector[] tvArySetEdgeNormalMain = null;
        private lvVector[] tvSetHandVec = null;

        public Global(lvGlobal lvGlobal2) {
            this.tmpRound1 = new TmpRound1(lvGlobal2);
            this.GlobalTmp(lvGlobal2);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tvSetFaceCenter = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetFaceCenter[n] = new lvVector(lvGlobal2);
            }
            this.tdSetFaceCenter = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdSetFaceCenter[n] = new lvDouble(lvGlobal2);
            }
            this.tvSetEdgeCenter = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetEdgeCenter[n] = new lvVector(lvGlobal2);
            }
            this.tdSetEdgeCenter = new lvDouble[4];
            for (n = 0; n < 4; ++n) {
                this.tdSetEdgeCenter[n] = new lvDouble(lvGlobal2);
            }
            this.tvCorrectEdgeCenter = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvCorrectEdgeCenter[n] = new lvVector(lvGlobal2);
            }
            this.tvSetFaceCoordSys = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvSetFaceCoordSys[n] = new lvVector(lvGlobal2);
            }
            this.tdSetFaceCoordSys = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdSetFaceCoordSys[n] = new lvDouble(lvGlobal2);
            }
            this.tvSetEdgeNormal = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvSetEdgeNormal[n] = new lvVector(lvGlobal2);
            }
            this.tvSetEdgeNormal2 = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetEdgeNormal2[n] = new lvVector(lvGlobal2);
            }
            this.tvSetEdgeNormalMain = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetEdgeNormalMain[n] = new lvVector(lvGlobal2);
            }
            this.tvSetHandVec = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvSetHandVec[n] = new lvVector(lvGlobal2);
            }
        }

        private final void NewCorrectEdgeCenter(lvGlobal lvGlobal2, int n) {
            int n2;
            this.tvAryCorrectEdgeCenter0 = new lvVector[n];
            this.tvAryCorrectEdgeCenter1 = new lvVector[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.tvAryCorrectEdgeCenter1[n2] = new lvVector(lvGlobal2);
            }
            this.tvAryCorrectEdgeCenter2 = new lvVector[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.tvAryCorrectEdgeCenter2[n2] = new lvVector(lvGlobal2);
            }
        }

        private final void NewSetEdgeNormal(int n) {
            this.tvArySetEdgeNormal = new lvVector[n];
        }

        private final void NewSetEdgeNormalMain(lvGlobal lvGlobal2, int n) {
            this.tvArySetEdgeNormalMain = new lvVector[n];
            for (int i = 0; i < n; ++i) {
                this.tvArySetEdgeNormalMain[i] = new lvVector(lvGlobal2);
            }
        }
    }

    private static class TmpRound1 {
        private int numRoundEdgeA;
        private TmpRadial1[] radial = null;
        private TmpRadial1a[] radialA = null;
        private boolean hasNG;
        private int tmpRadialNoOrg;
        private lvVector edgeNormalPoly = null;

        public TmpRound1(lvGlobal lvGlobal2) {
            this.edgeNormalPoly = new lvVector(lvGlobal2);
        }

        static /* synthetic */ TmpRadial1[] access$1002(TmpRound1 tmpRound1, TmpRadial1[] tmpRadial1Array) {
            tmpRound1.radial = tmpRadial1Array;
            return tmpRadial1Array;
        }

        static /* synthetic */ TmpRadial1a[] access$1102(TmpRound1 tmpRound1, TmpRadial1a[] tmpRadial1aArray) {
            tmpRound1.radialA = tmpRadial1aArray;
            return tmpRadial1aArray;
        }
    }

    private static class TmpRadial1a {
        private lvRec.SeqPart numSharpToSharp = new lvRec.SeqPart();

        private TmpRadial1a() {
        }
    }

    private static class TmpRadial1 {
        private lvVector faceCenter = null;
        private lvVector faceCenterNG = null;
        private lvVector edgeCenter = null;
        private lvVector edgeNormal = null;

        public TmpRadial1(lvGlobal lvGlobal2) {
            this.faceCenter = new lvVector(lvGlobal2);
            this.faceCenterNG = new lvVector(lvGlobal2);
            this.edgeCenter = new lvVector(lvGlobal2);
            this.edgeNormal = new lvVector(lvGlobal2);
        }
    }

    private static class TmpRound0 {
        private int numRoundEdge;
        private TmpRadial0[] radial = null;
        private boolean enableVtx;
        private double newVtxRound;

        private TmpRound0() {
        }

        static /* synthetic */ TmpRadial0[] access$802(TmpRound0 tmpRound0, TmpRadial0[] tmpRadial0Array) {
            tmpRound0.radial = tmpRadial0Array;
            return tmpRadial0Array;
        }
    }

    private static class TmpRadial0 {
        private boolean enableEdge;
        private double tmpNewEdgeRound;
        private double newEdgeRound;

        private TmpRadial0() {
        }
    }

    public static class UpRound {
        public lvVector vtxPos = null;
        public UpRadial[] radial = null;

        public UpRound(lvGlobal lvGlobal2) {
            this.vtxPos = new lvVector(lvGlobal2);
        }
    }

    public static class UpRadial {
        public lvVector handVec = null;

        public UpRadial(lvGlobal lvGlobal2) {
            this.handVec = new lvVector(lvGlobal2);
        }
    }

    public static class DownRound {
        public lvVector vtxPos = null;
        public double vtxRound;
        public int numRadial;
        public DownRadial[] radial = null;

        public DownRound(lvGlobal lvGlobal2) {
            this.vtxPos = new lvVector(lvGlobal2);
        }
    }

    public static class DownRadial {
        public lvVector mateVtxPos = null;
        public double edgeRound;
        public lvVector roundVec = null;
        public boolean isNG = false;
        public lvRec.PosNorHi center = null;
        public lvVector centerNG = null;
        public double area;
        public int numINode = 1;

        public DownRadial(lvGlobal lvGlobal2) {
            this.mateVtxPos = new lvVector(lvGlobal2);
            this.roundVec = new lvVector(lvGlobal2);
            this.center = new lvRec.PosNorHi(lvGlobal2);
            this.centerNG = new lvVector(lvGlobal2);
        }
    }
}

