/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.greg.g0g;

import jp.co.lattice.vKernel.core.c0.lvDouble;
import jp.co.lattice.vKernel.core.c0.lvEps;
import jp.co.lattice.vKernel.core.c0.lvError;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.greg.c0g.lvBezLine;
import jp.co.lattice.vKernel.greg.g0g.lv0GeomGGblElm;

public class lvMakeCbd
extends lvRoot {
    private static final int TYPE1 = 1;
    private static final int TYPE2 = 2;
    private static final int TYPE3 = 3;
    private static final int TYPE4 = 4;
    private static final int TYPE5 = 5;
    private static final int TYPE6 = 6;
    private static final int TYPE7 = 7;
    private static final int TYPE8 = 8;
    private static final int TYPE9 = 9;

    private final Global Gbl() {
        return ((lv0GeomGGblElm)this.global.GGeomG()).gMakeCbd;
    }

    private final DownCbd DownCbd() {
        return this.Gbl().curDownCbd;
    }

    private final UpCbd UpCbd() {
        return this.Gbl().curUpCbd;
    }

    private final UpHalfCbd UpHalfCbd() {
        return this.Gbl().curUpHalfCbd;
    }

    public lvMakeCbd(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public final double Alpha() {
        return 0.05;
    }

    public final double Beta() {
        return 2.0 * Math.sin(0.04363323129985824);
    }

    public final void Exec(DownCbd downCbd, UpCbd upCbd) throws lvThrowable {
        this.Gbl().curDownCbd = downCbd;
        this.Gbl().curUpCbd = upCbd;
        for (int i = 0; i < 2; ++i) {
            this.ExecMain(i);
        }
        this.Exec3or4();
    }

    private final void ExecMain(int n) throws lvThrowable {
        int n2 = this.GetType(n);
        double d = this.GetAlen(n2, n);
        lvVector lvVector2 = this.Gbl().tvExecMain[0];
        this.GetAdir(n2, n, lvVector2);
        this.UpCbd().cbd[n].aCbd.Assign(lvVector2.Mul(d));
        if (n2 == 4 || n2 == 5 || n2 == 6 || n2 == 8 || n2 == 9) {
            lvDouble lvDouble2 = this.Gbl().tdExecMain[0];
            lvDouble lvDouble3 = this.Gbl().tdExecMain[1];
            this.GetKH45689(n, lvDouble2, lvDouble3);
            this.UpCbd().cbd[n].k = lvDouble2.val;
            this.UpCbd().cbd[n].h = lvDouble3.val;
        } else {
            this.UpCbd().cbd[n].k = this.GetK(n2, n);
            this.UpCbd().cbd[n].h = this.GetH(n2, n);
        }
        ((Global)this.Gbl()).lenRatio[n] = this.LenRatio(n2, n);
    }

    private final int GetType(int n) throws lvThrowable {
        double d = this.DownCbd().info[0].vtx.Sub(this.DownCbd().info[1].vtx).Length();
        double d2 = this.DownCbd().info[n].bCbd.Length();
        if (lvEps.IsZero(d2)) {
            return 1;
        }
        if (d2 < this.Alpha() * d) {
            return 2;
        }
        double d3 = this.DownCbd().info[n].cVec.Length();
        if (lvEps.IsZero(d3)) {
            return 3;
        }
        lvVector lvVector2 = this.Gbl().tvGetType[0];
        lvVector lvVector3 = this.Gbl().tvGetType[1];
        lvVector2.Assign(this.DownCbd().info[n].bCbd.Div(d2));
        lvVector3.Assign(this.DownCbd().info[n].cVec.Div(d3));
        double d4 = lvVector2.Cross(lvVector3).Length();
        if (d3 < this.Alpha() * d) {
            if (lvEps.IsZero(d4)) {
                return 4;
            }
            if (d4 < this.Beta()) {
                return 5;
            }
            return 6;
        }
        if (lvEps.IsZero(d4)) {
            return 7;
        }
        if (d4 < this.Beta()) {
            return 8;
        }
        return 9;
    }

    private final double GetAlen(int n, int n2) throws lvThrowable {
        double d = this.DownCbd().info[0].vtx.Sub(this.DownCbd().info[1].vtx).Length();
        double d2 = this.DownCbd().info[n2].bCbd.Length();
        switch (n) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return d2 / (3.0 * this.Alpha());
            }
        }
        return 0.3333333333333333 * d;
    }

    private final void GetAdir(int n, int n2, lvVector lvVector2) throws lvThrowable {
        double d = this.DownCbd().info[n2].bCbd.Length();
        lvVector lvVector3 = this.Gbl().tvGetAdir[0];
        lvVector lvVector4 = this.Gbl().tvGetAdir[1];
        lvVector lvVector5 = this.Gbl().tvGetAdir[2];
        lvVector lvVector6 = this.Gbl().tvGetAdir[3];
        lvVector lvVector7 = this.Gbl().tvGetAdir[4];
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                lvVector5.Assign(this.DownCbd().faceNormal.Cross(this.DownCbd().info[n2].cVec));
                lvVector5.UnitAssign();
                double d4 = this.DownCbd().info[0].vtx.Sub(this.DownCbd().info[1].vtx).Length();
                double d5 = this.DownCbd().info[n2].cVec.Length();
                d2 = d5 / (this.Alpha() * d4);
                lvVector3.Assign(this.DownCbd().info[n2].bCbd.Div(d));
                lvVector4.Assign(this.DownCbd().info[n2].cVec.Div(d5));
                double d6 = lvVector3.Cross(lvVector4).Length();
                d3 = d6 / this.Beta();
                lvVector6.Assign(lvVector4.Cross(lvVector3.Cross(lvVector4)));
                lvVector6.UnitAssign();
            }
        }
        switch (n) {
            case 1: {
                lvVector2.SetXYZ(0.0, 0.0, 0.0);
                break;
            }
            case 2: 
            case 3: {
                lvVector2.Assign(this.DownCbd().info[n2].bCbd.Div(d));
                break;
            }
            case 4: {
                lvVector2.Assign(lvVector3.Mul(1.0 - d2).Add(lvVector5.Mul(d2)));
                lvVector2.UnitAssign();
                break;
            }
            case 5: {
                lvVector7.Assign(lvVector3.Mul(1.0 - d2).Add(lvVector5.Mul(d2)));
                lvVector7.UnitAssign();
                lvVector2.Assign(lvVector7.Mul(1.0 - d3).Add(lvVector6.Mul(d3)));
                lvVector2.UnitAssign();
                break;
            }
            case 6: {
                lvVector2.Assign(lvVector6);
                break;
            }
            case 7: {
                lvVector2.Assign(lvVector5);
                break;
            }
            case 8: {
                lvVector2.Assign(lvVector5.Mul(1.0 - d3).Add(lvVector6.Mul(d3)));
                lvVector2.UnitAssign();
                break;
            }
            default: {
                lvVector2.Assign(lvVector6);
            }
        }
    }

    private final void GetKH45689(int n, lvDouble lvDouble2, lvDouble lvDouble3) throws lvThrowable {
        lvVector lvVector2 = this.UpCbd().cbd[n].aCbd;
        lvVector lvVector3 = this.DownCbd().info[n].bCbd;
        lvVector lvVector4 = this.DownCbd().info[n].cVec;
        boolean bl = lvVector3.Divide(lvVector2, lvVector4, lvDouble2, lvDouble3, 1.0E-6, 1.0E-6);
        this.Err().Assert(bl, "lvMakeCbd.GetKH45689(0)");
    }

    private final double GetK(int n, int n2) throws lvThrowable {
        switch (n) {
            case 1: 
            case 2: {
                return 3.0 * this.Alpha();
            }
            case 3: {
                double d = this.UpCbd().cbd[n2].aCbd.Length();
                double d2 = this.DownCbd().info[n2].bCbd.Length();
                return d2 / d;
            }
        }
        return 0.0;
    }

    private final double GetH(int n, int n2) throws lvThrowable {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 0.0;
            }
        }
        double d = this.UpCbd().cbd[n2].aCbd.Length();
        double d2 = this.DownCbd().info[n2].cVec.Length();
        return d2 / d;
    }

    private final double LenRatio(int n, int n2) throws lvThrowable {
        double d;
        double d2;
        double d3;
        lvVector lvVector2 = this.Gbl().tvLenRatio[0];
        lvVector lvVector3 = this.Gbl().tvLenRatio[1];
        lvVector lvVector4 = this.Gbl().tvLenRatio[2];
        if (this.DownCbd().antiCenter == null) {
            return 1.0;
        }
        lvVector lvVector5 = this.DownCbd().info[n2].vtx;
        lvVector lvVector6 = this.DownCbd().info[n2].antiVtx;
        lvVector2.Assign(lvVector6.Sub(lvVector5));
        lvVector lvVector7 = this.DownCbd().info[n2].bCbd;
        double d4 = lvVector2.Length();
        lvError lvError2 = this.Err();
        this.Eps();
        lvError2.Assert(!lvEps.IsZero(d4), "lvMakeCbd.LenRatio(0)");
        double d5 = lvVector7.Length();
        double d6 = 1.0;
        this.Eps();
        if (!lvEps.IsZero(d5)) {
            lvVector3.Assign(lvVector2.Div(d4));
            lvVector4.Assign(lvVector7.Div(d5));
            d3 = lvVector3.Dot(lvVector4);
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            d2 = d4 * 2.0 / (3.0 * (1.0 + d3));
            d6 = d5 / d2;
        }
        d3 = this.DownCbd().info[0].vtx.Sub(this.DownCbd().info[1].vtx).Length();
        d2 = this.DownCbd().info[n2].bCbd.Length();
        switch (n) {
            case 1: {
                d = 1.0;
                break;
            }
            case 2: {
                double d7 = d2 / (this.Alpha() * d3);
                d = (1.0 - d7) * 1.0 + d7 * d6;
                break;
            }
            default: {
                d = d6;
            }
        }
        return d;
    }

    private final void Exec3or4() throws lvThrowable {
        if (this.DownCbd().antiCenter == null) {
            double d;
            double d2;
            this.UpCbd().k1 = (this.UpCbd().cbd[0].k + this.UpCbd().cbd[1].k) / 2.0;
            double d3 = this.UpCbd().cbd[0].k;
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if ((d2 = this.UpCbd().cbd[1].k) < 0.0) {
                d2 = -d2;
            }
            if (this.UpCbd().k1 < 0.3333333333333333 * (d = (d3 + d2) / 2.0)) {
                this.UpCbd().k1 = 0.3333333333333333 * d;
            }
            return;
        }
        this.Exec3or4Main();
    }

    private final void Exec3or4Main() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvExec3or4Main[0];
        lvVector lvVector3 = this.Gbl().tvExec3or4Main[1];
        this.Position(0.5, lvVector2);
        lvVector lvVector4 = this.DownCbd().antiCenter;
        double d = this.Gbl().lenRatio[0];
        double d2 = this.Gbl().lenRatio[1];
        lvVector lvVector5 = this.UpCbd().cbd[0].aCbd;
        lvVector lvVector6 = this.UpCbd().cbd[1].aCbd;
        lvVector3.Assign(lvVector5.Add(lvVector6).Div(2.0));
        double d3 = this.HandLenCenter(lvVector2, lvVector4, lvVector3);
        double d4 = d3 * ((d + d2) / 2.0);
        this.Exec3or4K1(lvVector3, d4);
    }

    private final void Position(double d, lvVector lvVector2) {
        lvVector[] lvVectorArray = this.Gbl().tvAryPosition;
        lvVectorArray[0].Assign(this.DownCbd().info[0].vtx);
        lvVectorArray[1].Assign(this.DownCbd().info[0].vtx.Add(this.DownCbd().info[0].cVec));
        lvVectorArray[2].Assign(this.DownCbd().info[1].vtx.Sub(this.DownCbd().info[1].cVec));
        lvVectorArray[3].Assign(this.DownCbd().info[1].vtx);
        lvBezLine.Position(lvVectorArray, d, lvVector2);
    }

    private final double HandLenCenter(lvVector lvVector2, lvVector lvVector3, lvVector lvVector4) throws lvThrowable {
        lvVector lvVector5 = this.Gbl().tvHandLenCenter[0];
        lvVector lvVector6 = this.Gbl().tvHandLenCenter[1];
        lvVector lvVector7 = this.Gbl().tvHandLenCenter[2];
        lvVector5.Assign(lvVector3.Sub(lvVector2));
        double d = lvVector5.Length();
        lvError lvError2 = this.Err();
        this.Eps();
        lvError2.Assert(!lvEps.IsZero(d), "lvMakeCbd.HandLenCenter(0)");
        double d2 = lvVector4.Length();
        double d3 = 0.0;
        this.Eps();
        if (lvEps.IsZero(d2)) {
            return d3;
        }
        lvVector6.Assign(lvVector5.Div(d));
        lvVector7.Assign(lvVector4.Div(d2));
        double d4 = lvVector6.Dot(lvVector7);
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        d3 = d * 2.0 / (3.0 * (1.0 + d4));
        if (this.DownCbd().info[0].antiVtx.IsSame(this.DownCbd().info[1].antiVtx)) {
            d3 *= (Math.sqrt(6.0) - 2.0) * (2.0 + Math.sqrt(2.0)) / 2.0;
        }
        if (d2 < this.Alpha() * d) {
            double d5 = d2 / (this.Alpha() * d);
            d3 *= d5;
        }
        return d3;
    }

    private final void Exec3or4K1(lvVector lvVector2, double d) throws lvThrowable {
        double d2;
        double d3 = this.UpCbd().cbd[0].k;
        double d4 = this.UpCbd().cbd[1].k;
        double d5 = (d3 + d4) / 2.0;
        double d6 = lvVector2.Length();
        if (2.0 * d > (3.0 * d5 + d5) * d6) {
            d2 = 3.0 * d5;
        } else if (2.0 * d < (0.3333333333333333 * d5 + d5) * d6) {
            d2 = 0.3333333333333333 * d5;
        } else {
            this.Eps();
            d2 = lvEps.IsZero(d6) ? d5 : 2.0 * d / d6 - d5;
        }
        this.UpCbd().k1 = d2;
    }

    public final void ExecHalf(DownCbd downCbd, UpHalfCbd upHalfCbd) throws lvThrowable {
        UpCbd upCbd = this.Gbl().tuExecHalf[0];
        this.Exec(downCbd, upCbd);
        this.ExecHalfMain(downCbd, upCbd, upHalfCbd);
    }

    private final void ExecHalfMain(DownCbd downCbd, UpCbd upCbd, UpHalfCbd upHalfCbd) throws lvThrowable {
        this.Gbl().curDownCbd = downCbd;
        this.Gbl().curUpCbd = upCbd;
        this.Gbl().curUpHalfCbd = upHalfCbd;
        this.SetACbd();
        this.SetK();
        this.SetH();
    }

    private final void SetACbd() throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSetACbd[0];
        lvVector lvVector3 = this.Gbl().tvSetACbd[1];
        lvVector2.Assign(this.UpCbd().cbd[0].aCbd.Div(2.0));
        lvVector3.Assign(this.UpCbd().cbd[1].aCbd.Div(2.0));
        this.UpHalfCbd().cbd[0].aCbd.Assign(this.UpCbd().cbd[0].aCbd);
        this.UpHalfCbd().cbd[2].aCbd.Assign(this.UpCbd().cbd[1].aCbd);
        this.UpHalfCbd().cbd[1].aCbd.Assign(lvVector2.Add(lvVector3).Div(2.0));
    }

    private final void SetK() {
        double d = this.UpCbd().cbd[0].k;
        double d2 = this.UpCbd().k1;
        double d3 = this.UpCbd().cbd[1].k;
        this.UpHalfCbd().cbd[0].k = d;
        this.UpHalfCbd().cbd[2].k = d3;
        this.UpHalfCbd().k1[0] = (d + d2) / 2.0;
        this.UpHalfCbd().k1[1] = (d2 + d3) / 2.0;
        this.UpHalfCbd().cbd[1].k = (this.UpHalfCbd().k1[0] + this.UpHalfCbd().k1[1]) / 2.0;
    }

    private final void SetH() {
        double d = this.UpCbd().cbd[0].h;
        double d2 = this.UpCbd().cbd[1].h;
        this.UpHalfCbd().cbd[0].h = d;
        this.UpHalfCbd().cbd[2].h = d2;
        this.UpHalfCbd().cbd[1].h = (d + d2) / 2.0;
    }

    public static class Global {
        private DownCbd curDownCbd = null;
        private UpCbd curUpCbd = null;
        private UpHalfCbd curUpHalfCbd = null;
        private double[] lenRatio = new double[2];
        private lvDouble[] tdExecMain = null;
        private lvVector[] tvExecMain = null;
        private lvVector[] tvGetType = null;
        private lvVector[] tvGetAdir = null;
        private lvVector[] tvExec3or4Main = null;
        private lvVector[] tvLenRatio = null;
        private lvVector[] tvHandLenCenter = null;
        private lvVector[] tvAryPosition = null;
        private UpCbd[] tuExecHalf = null;
        private lvVector[] tvSetACbd = null;

        public Global(lvGlobal lvGlobal2) {
            this.GlobalTmp(lvGlobal2);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tdExecMain = new lvDouble[4];
            for (n = 0; n < 4; ++n) {
                this.tdExecMain[n] = new lvDouble(lvGlobal2);
            }
            this.tvExecMain = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvExecMain[n] = new lvVector(lvGlobal2);
            }
            this.tvGetType = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvGetType[n] = new lvVector(lvGlobal2);
            }
            this.tvGetAdir = new lvVector[8];
            for (n = 0; n < 8; ++n) {
                this.tvGetAdir[n] = new lvVector(lvGlobal2);
            }
            this.tvExec3or4Main = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvExec3or4Main[n] = new lvVector(lvGlobal2);
            }
            this.tvLenRatio = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvLenRatio[n] = new lvVector(lvGlobal2);
            }
            this.tvHandLenCenter = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvHandLenCenter[n] = new lvVector(lvGlobal2);
            }
            this.tvAryPosition = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvAryPosition[n] = new lvVector(lvGlobal2);
            }
            this.tuExecHalf = new UpCbd[2];
            for (n = 0; n < 2; ++n) {
                this.tuExecHalf[n] = new UpCbd(lvGlobal2);
            }
            this.tvSetACbd = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSetACbd[n] = new lvVector(lvGlobal2);
            }
        }
    }

    public static class UpHalfCbd {
        public UpCbdOne[] cbd = null;
        public double[] k1 = new double[2];

        public UpHalfCbd(lvGlobal lvGlobal2) {
            this.cbd = new UpCbdOne[3];
            for (int i = 0; i < 3; ++i) {
                this.cbd[i] = new UpCbdOne(lvGlobal2);
            }
        }
    }

    public static class UpCbd {
        public UpCbdOne[] cbd = new UpCbdOne[2];
        public double k1;

        public UpCbd(lvGlobal lvGlobal2) {
            for (int i = 0; i < 2; ++i) {
                this.cbd[i] = new UpCbdOne(lvGlobal2);
            }
        }
    }

    public static class UpCbdOne {
        public lvVector aCbd = null;
        double k;
        double h;

        public UpCbdOne(lvGlobal lvGlobal2) {
            this.aCbd = new lvVector(lvGlobal2);
        }
    }

    public static class DownCbd {
        public DownCbdOne[] info = new DownCbdOne[2];
        public lvVector faceNormal = null;
        public lvVector antiCenter = null;

        public DownCbd(lvGlobal lvGlobal2) {
            for (int i = 0; i < 2; ++i) {
                this.info[i] = new DownCbdOne(lvGlobal2);
            }
            this.faceNormal = new lvVector(lvGlobal2);
        }
    }

    public static class DownCbdOne {
        public lvVector vtx = null;
        public lvVector cVec = null;
        public lvVector bCbd = null;
        public lvVector antiVtx = null;

        public DownCbdOne(lvGlobal lvGlobal2) {
            this.vtx = new lvVector(lvGlobal2);
            this.cVec = new lvVector(lvGlobal2);
            this.bCbd = new lvVector(lvGlobal2);
        }
    }
}

