/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.core.t0;

import jp.co.lattice.vKernel.core.c0.lvComGblElm;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvPolygon;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVecDt;
import jp.co.lattice.vKernel.core.t0.lvToKernelLow;
import jp.co.lattice.vKernel.core.t0.lvTopoGblElm;

public class lvMakePoly
extends lvRoot {
    private final Global Gbl() {
        return ((lvTopoGblElm)this.global.GTopo()).gMakePoly;
    }

    private final TmpPoly TmpPoly() {
        return this.Gbl().tmpPoly;
    }

    private final lvToKernelLow CurSrc() {
        return this.Gbl().curSrc;
    }

    private final lvPolygon CurDst() {
        return ((lvComGblElm)this.global.GCom()).gModelPoly.shell[((Global)this.Gbl()).curShellNo].poly;
    }

    public lvMakePoly(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public final void Exec(int n, lvToKernelLow lvToKernelLow2) throws lvThrowable {
        this.Gbl().curShellNo = n;
        this.Gbl().curSrc = lvToKernelLow2;
        this.VertexProc0();
        this.RadialProc0();
        this.FaceProc0();
        this.RadialProc1();
        this.EdgeProc0();
        this.FaceProc1();
        this.EdgeProc1();
        this.Finish();
    }

    private final void VertexProc0() throws lvThrowable {
        int n = this.CurSrc().vertex.length;
        this.Err().Assert(n >= 3, "lvMakePoly.VertexProc0(0)");
        this.CurDst().NewVertex(n);
        this.SetVetrexInfo();
    }

    private final void SetVetrexInfo() {
        int n = this.CurSrc().vertex.length;
        for (int i = 0; i < n; ++i) {
            lvVecDt.Copy(this.CurSrc().vertex[i].pos, this.CurDst().vertex[i].pos);
            this.CurDst().vertex[i].round = this.CurSrc().vertex[i].enable ? this.CurSrc().vertex[i].round : 1.0;
        }
    }

    private final void RadialProc0() throws lvThrowable {
        this.Err().Assert(this.CurSrc().gsNumVtx.length >= 1, "lvMakePoly.RadialProc0(0)");
        int n = this.CurSrc().ngNumVtx == null ? 0 : this.CurSrc().ngNumVtx.length;
        int n2 = this.CurSrc().gsNumVtx.length + n;
        this.NewTmpFace(n2);
        this.SetTmpFace();
        int n3 = this.CurSrc().ngVtxSeq == null ? 0 : this.CurSrc().ngVtxSeq.length;
        n2 = this.CurSrc().gsVtxSeq.length + n3;
        this.NewTmpFaceVtxSeq(n2);
        this.SetTmpFaceVtxSeq();
        n2 = this.CurSrc().vertex.length;
        this.NewTmpVertex(n2);
        this.SetTmpVertex();
        n2 = this.GetNumTmpRadialSeq();
        this.NewTmpRadialSeq(n2);
        this.SetTmpRadialSeq0();
        n2 = this.GetMaxTmpRadialSeq();
        this.NewTmpRadialOneVtx(n2);
        this.NewTmpAlreadyExecOneVtx(n2 / 2);
        this.CorrectRadialInfo0();
        this.SetVtxFace();
    }

    private final void NewTmpFace(int n) {
        TmpPoly.access$402(this.TmpPoly(), new TmpFace[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).face[i] = new TmpFace();
        }
    }

    private final void SetTmpFace() throws lvThrowable {
        int n;
        int n2 = 0;
        int n3 = this.CurSrc().gsNumVtx.length;
        for (n = 0; n < n3; ++n) {
            this.Err().Assert(this.CurSrc().gsNumVtx[n] >= 3, "lvMakePoly.SetTmpFace(0)");
            ((TmpFace)((TmpPoly)this.TmpPoly()).face[n2]).vertex.num = this.CurSrc().gsNumVtx[n];
            ++n2;
        }
        n3 = this.CurSrc().ngNumVtx == null ? 0 : this.CurSrc().ngNumVtx.length;
        for (n = 0; n < n3; ++n) {
            this.Err().Assert(this.CurSrc().ngNumVtx[n] >= 3, "lvMakePoly.SetTmpFace(1)");
            ((TmpFace)((TmpPoly)this.TmpPoly()).face[n2]).vertex.num = this.CurSrc().ngNumVtx[n];
            ++n2;
        }
        n2 = 0;
        n3 = this.TmpPoly().face.length;
        for (n = 0; n < n3; ++n) {
            ((TmpFace)((TmpPoly)this.TmpPoly()).face[n]).vertex.start = n2;
            n2 += ((TmpFace)((TmpPoly)this.TmpPoly()).face[n]).vertex.num;
        }
    }

    private final void NewTmpFaceVtxSeq(int n) {
        TmpPoly.access$702(this.TmpPoly(), new int[n]);
    }

    private final void SetTmpFaceVtxSeq() {
        int n = 0;
        for (int ((TmpPoly)this.TmpPoly()).faceVtxSeq[n] : this.CurSrc().gsVtxSeq) {
            ++n;
        }
        int n2 = this.CurSrc().ngVtxSeq == null ? 0 : this.CurSrc().ngVtxSeq.length;
        for (int i = 0; i < n2; ++i) {
            ((TmpPoly)this.TmpPoly()).faceVtxSeq[n] = this.CurSrc().ngVtxSeq[i];
            ++n;
        }
    }

    private final void NewTmpVertex(int n) {
        TmpPoly.access$802(this.TmpPoly(), new TmpVertex[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).vertex[i] = new TmpVertex();
        }
    }

    private final void SetTmpVertex() throws lvThrowable {
        int n;
        int n2;
        int n3 = this.TmpPoly().vertex.length;
        for (n2 = 0; n2 < n3; ++n2) {
            ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n2]).radial.num = 0;
        }
        n2 = this.TmpPoly().face.length;
        for (n = 0; n < n2; ++n) {
            int n4 = ((TmpFace)((TmpPoly)this.TmpPoly()).face[n]).vertex.num;
            int n5 = ((TmpFace)((TmpPoly)this.TmpPoly()).face[n]).vertex.start;
            for (int i = 0; i < n4; ++i) {
                int n6 = this.TmpPoly().faceVtxSeq[n5];
                ++n5;
                ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n6]).radial.num += 2;
            }
        }
        int n7 = 0;
        n3 = this.TmpPoly().vertex.length;
        for (n = 0; n < n3; ++n) {
            ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n]).radial.start = n7;
            this.Err().Assert(((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n]).radial.num >= 2, "lvMakePoly.SetTmpVertex(0)");
            n7 += ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n]).radial.num;
        }
    }

    private final int GetNumTmpRadialSeq() {
        int n = 0;
        int n2 = this.TmpPoly().vertex.length;
        for (int i = 0; i < n2; ++i) {
            n += ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[i]).radial.num;
        }
        return n;
    }

    private final void NewTmpRadialSeq(int n) {
        TmpPoly.access$1102(this.TmpPoly(), new TmpRadial[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).radialSeq[i] = new TmpRadial();
        }
    }

    private final void SetTmpRadialSeq0() {
        int n;
        int n2 = this.TmpPoly().vertex.length;
        for (n = 0; n < n2; ++n) {
            this.TmpPoly().vertex[n].tmpCnt = 0;
        }
        n = this.TmpPoly().face.length;
        for (int i = 0; i < n; ++i) {
            int n3 = ((TmpFace)((TmpPoly)this.TmpPoly()).face[i]).vertex.num;
            int n4 = ((TmpFace)((TmpPoly)this.TmpPoly()).face[i]).vertex.start;
            for (int j = 0; j < n3; ++j) {
                int n5 = this.TmpPoly().faceVtxSeq[n4 + (j + n3 - 1) % n3];
                int n6 = this.TmpPoly().faceVtxSeq[n4 + j];
                int n7 = this.TmpPoly().faceVtxSeq[n4 + (j + 1) % n3];
                int n8 = ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n6]).radial.start + this.TmpPoly().vertex[n6].tmpCnt;
                this.TmpPoly().radialSeq[n8].mateVtxNo = n7;
                this.TmpPoly().radialSeq[n8 + 1].mateVtxNo = n5;
                this.TmpPoly().vertex[n6].tmpCnt += 2;
            }
        }
    }

    private final int GetMaxTmpRadialSeq() {
        int n = 0;
        int n2 = this.TmpPoly().vertex.length;
        for (int i = 0; i < n2; ++i) {
            if (n >= ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[i]).radial.num) continue;
            n = ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[i]).radial.num;
        }
        return n;
    }

    private final void NewTmpRadialOneVtx(int n) {
        TmpPoly.access$1502(this.TmpPoly(), new TmpRadial[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).radialOneVtx[i] = new TmpRadial();
        }
    }

    private final void NewTmpAlreadyExecOneVtx(int n) {
        TmpPoly.access$1602(this.TmpPoly(), new boolean[n]);
    }

    private final void CorrectRadialInfo0() throws lvThrowable {
        int n = this.TmpPoly().vertex.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[i].radial;
            int n3 = this.CorrectRadialMain(seqPart, n2 = this.SchRadialFirstPosition(seqPart));
            boolean bl = this.HasNg(n3);
            if (!bl) {
                // empty if block
            }
            ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[i]).radial.num = --n3;
            this.TmpPoly().vertex[i].hasNg = bl;
            this.RadialOneVtxToSeq(seqPart.start, n3);
        }
    }

    private final int SchRadialFirstPosition(lvRec.SeqPart seqPart) throws lvThrowable {
        int n = seqPart.num / 2;
        this.Err().Assert(n > 0, "lvMakePoly.SchRadialFirstPosition(0)");
        if (n <= 1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                int n3;
                if (i == j) continue;
                int n4 = i * 2;
                int n5 = j * 2 + 1;
                int n6 = this.TmpPoly().radialSeq[seqPart.start + n4].mateVtxNo;
                if (n6 != (n3 = this.TmpPoly().radialSeq[seqPart.start + n5].mateVtxNo)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private final int CorrectRadialMain(lvRec.SeqPart seqPart, int n) throws lvThrowable {
        int n2;
        int n3 = seqPart.num / 2;
        for (n2 = 0; n2 < n3; ++n2) {
            ((TmpPoly)this.TmpPoly()).alreadyExecOneVtx[n2] = false;
        }
        TmpRadial.Copy(this.TmpPoly().radialSeq[seqPart.start + n * 2], this.TmpPoly().radialOneVtx[0]);
        TmpRadial.Copy(this.TmpPoly().radialSeq[seqPart.start + (n * 2 + 1)], this.TmpPoly().radialOneVtx[1]);
        ((TmpPoly)this.TmpPoly()).alreadyExecOneVtx[n] = true;
        int n4 = n;
        for (int i = 1; i < n3; ++i) {
            n2 = 0;
            for (int j = 0; j < n3; ++j) {
                int n5;
                if (n4 == j || this.TmpPoly().alreadyExecOneVtx[j]) continue;
                int n6 = n4 * 2 + 1;
                int n7 = j * 2;
                int n8 = this.TmpPoly().radialSeq[seqPart.start + n6].mateVtxNo;
                if (n8 != (n5 = this.TmpPoly().radialSeq[seqPart.start + n7].mateVtxNo)) continue;
                n4 = j;
                n2 = 1;
                break;
            }
            this.Err().Assert(n2 == 1, "lvMakePoly.CorrectRadialMain(0)");
            TmpRadial.Copy(this.TmpPoly().radialSeq[seqPart.start + (n4 * 2 + 1)], this.TmpPoly().radialOneVtx[i + 1]);
            ((TmpPoly)this.TmpPoly()).alreadyExecOneVtx[n4] = true;
        }
        return n3 + 1;
    }

    private final boolean HasNg(int n) {
        return this.TmpPoly().radialOneVtx[0].mateVtxNo != this.TmpPoly().radialOneVtx[n - 1].mateVtxNo;
    }

    private final void RadialOneVtxToSeq(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            TmpRadial.Copy(this.TmpPoly().radialOneVtx[i], this.TmpPoly().radialSeq[n + i]);
        }
    }

    private final void SetVtxFace() {
        int n;
        int n2 = this.TmpPoly().vertex.length;
        for (n = 0; n < n2; ++n) {
            this.CurDst().vertex[n].vtxFace.num = ((TmpVertex)((TmpPoly)this.TmpPoly()).vertex[n]).radial.num;
        }
        int n3 = 0;
        n2 = this.CurDst().vertex.length;
        for (n = 0; n < n2; ++n) {
            this.CurDst().vertex[n].vtxFace.start = n3;
            n3 += this.CurDst().vertex[n].vtxFace.num;
        }
    }

    private final void FaceProc0() throws lvThrowable {
        this.MakeNg();
        this.CurDst().ngStartNo = this.CurSrc().gsNumVtx.length;
        int n = this.TmpPoly().face.length + this.TmpPoly().numNgFace;
        this.CurDst().NewFace(n);
        this.SetFaceInfo();
        int n2 = this.TmpPoly().dstNgVtxSeq == null ? 0 : this.TmpPoly().dstNgVtxSeq.length;
        n = this.TmpPoly().faceVtxSeq.length + n2;
        this.CurDst().NewFaceHalfSeq(n);
        this.SetFaceHalfSeq();
        this.SetFaceHalfRadial();
    }

    private final void MakeNg() throws lvThrowable {
        int n = this.GetNumTmpNgVtxSeq();
        if (n == 0) {
            return;
        }
        this.NewTmpNgFace(n / 3);
        this.NewTmpDstNgVtxSeq(n);
        this.NewTmpSrcNgVtxSeq(n);
        this.InitTmpSrcNgVtxSeq();
        this.TmpPoly().numNgFace = this.MakeNgMain();
    }

    private final int GetNumTmpNgVtxSeq() {
        int n = 0;
        int n2 = this.TmpPoly().vertex.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.TmpPoly().vertex[i].hasNg) continue;
            ++n;
        }
        return n;
    }

    private final void NewTmpNgFace(int n) {
        TmpPoly.access$2102(this.TmpPoly(), new TmpFace[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).ngFace[i] = new TmpFace();
        }
    }

    private final void NewTmpDstNgVtxSeq(int n) {
        TmpPoly.access$2002(this.TmpPoly(), new int[n]);
    }

    private final void NewTmpSrcNgVtxSeq(int n) {
        TmpPoly.access$2202(this.TmpPoly(), new TmpNgVertex[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).srcNgVtxSeq[i] = new TmpNgVertex();
        }
    }

    private final int InitTmpSrcNgVtxSeq() {
        int n = 0;
        int n2 = this.TmpPoly().vertex.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.TmpPoly().vertex[i].hasNg) continue;
            this.TmpPoly().srcNgVtxSeq[n].vertexNo = i;
            this.TmpPoly().srcNgVtxSeq[n].alreadyExec = false;
            ++n;
        }
        return n;
    }

    private final int MakeNgMain() throws lvThrowable {
        int n = 0;
        int n2 = 0;
        int n3 = this.TmpPoly().srcNgVtxSeq.length;
        for (int i = 0; i < n3; ++i) {
            if (this.TmpPoly().srcNgVtxSeq[i].alreadyExec) continue;
            this.Err().Assert(n2 < this.TmpPoly().ngFace.length, "lvMakePoly.MakeNgMain(0)");
            n = this.MakeNgOne(i, n, n2);
            ++n2;
        }
        return n2;
    }

    private final int MakeNgOne(int n, int n2, int n3) throws lvThrowable {
        int n4 = 0;
        int n5 = n2;
        int n6 = 0;
        int n7 = n;
        int n8 = this.TmpPoly().srcNgVtxSeq[n].vertexNo;
        boolean bl = false;
        int n9 = this.TmpPoly().srcNgVtxSeq.length;
        for (int i = 0; i < n9; ++i) {
            int n10;
            ((TmpPoly)this.TmpPoly()).dstNgVtxSeq[n5] = n10 = this.TmpPoly().srcNgVtxSeq[n7].vertexNo;
            ++n5;
            ++n6;
            this.TmpPoly().srcNgVtxSeq[n7].alreadyExec = true;
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[n10].radial;
            int n11 = this.TmpPoly().radialSeq[seqPart.start + (seqPart.num - 1)].mateVtxNo;
            boolean bl2 = false;
            for (int j = 0; j < n9; ++j) {
                if (n7 == j || this.TmpPoly().srcNgVtxSeq[j].alreadyExec && n != j) continue;
                n4 = this.TmpPoly().srcNgVtxSeq[j].vertexNo;
                seqPart = this.TmpPoly().vertex[n4].radial;
                int n12 = this.TmpPoly().radialSeq[seqPart.start + 0].mateVtxNo;
                if (n11 != n4) continue;
                this.Err().Assert(n12 == n10, "lvMakePoly.MakeNgOne(0)");
                n7 = j;
                bl2 = true;
                break;
            }
            this.Err().Assert(bl2, "lvMakePoly.MakeNgOne(1)");
            if (!bl2 || n4 != n8) continue;
            bl = true;
            break;
        }
        this.Err().Assert(bl, "lvMakePoly.MakeNgOne(2)");
        this.Err().Assert(n6 >= 3, "lvMakePoly.MakeNgOne(3)");
        ((TmpFace)((TmpPoly)this.TmpPoly()).ngFace[n3]).vertex.num = n6;
        return n5;
    }

    private final void SetFaceInfo() {
        int n;
        int n2 = 0;
        int n3 = this.TmpPoly().face.length;
        for (n = 0; n < n3; ++n) {
            this.CurDst().face[n2].num = ((TmpFace)((TmpPoly)this.TmpPoly()).face[n]).vertex.num;
            ++n2;
        }
        n3 = this.TmpPoly().numNgFace;
        for (n = 0; n < n3; ++n) {
            this.CurDst().face[n2].num = ((TmpFace)((TmpPoly)this.TmpPoly()).ngFace[n]).vertex.num;
            ++n2;
        }
        n2 = 0;
        n3 = this.CurDst().face.length;
        for (n = 0; n < n3; ++n) {
            this.CurDst().face[n].start = n2;
            n2 += this.CurDst().face[n].num;
        }
    }

    private final void SetFaceHalfSeq() {
        int n;
        int n2 = 0;
        int n3 = this.TmpPoly().faceVtxSeq.length;
        for (n = 0; n < n3; ++n) {
            this.CurDst().faceHalfSeq[n2].vtxNo = this.TmpPoly().faceVtxSeq[n];
            ++n2;
        }
        n3 = this.TmpPoly().dstNgVtxSeq == null ? 0 : this.TmpPoly().dstNgVtxSeq.length;
        for (n = 0; n < n3; ++n) {
            this.CurDst().faceHalfSeq[n2].vtxNo = this.TmpPoly().dstNgVtxSeq[n];
            ++n2;
        }
    }

    private final void SetFaceHalfRadial() throws lvThrowable {
        for (lvRec.SeqPart seqPart : this.CurDst().face) {
            for (int i = 0; i < seqPart.num; ++i) {
                int n = this.CurDst().faceHalfSeq[seqPart.start + i].vtxNo;
                int n2 = this.CurDst().faceHalfSeq[seqPart.start + (i + 1) % seqPart.num].vtxNo;
                this.CurDst().faceHalfSeq[seqPart.start + i].radialNo = this.SetFaceHalfRadialMain(n, n2);
            }
        }
    }

    private final int SetFaceHalfRadialMain(int n, int n2) throws lvThrowable {
        int n3 = 0;
        boolean bl = false;
        lvRec.SeqPart seqPart = this.TmpPoly().vertex[n].radial;
        for (int i = 0; i < seqPart.num; ++i) {
            if (n2 != this.TmpPoly().radialSeq[seqPart.start + i].mateVtxNo) continue;
            n3 = i;
            bl = true;
            break;
        }
        this.Err().Assert(bl, "lvMakePoly.SetFaceHalfRadialMain(0)");
        return n3;
    }

    private final void RadialProc1() {
        int n = this.GetNumVtxFaceSeq();
        this.CurDst().NewVtxFaceSeq(n);
        this.SetVtxFaceSeq();
    }

    private final int GetNumVtxFaceSeq() {
        int n = 0;
        int n2 = this.CurDst().vertex.length;
        for (int i = 0; i < n2; ++i) {
            n += this.CurDst().vertex[i].vtxFace.num;
        }
        return n;
    }

    private final void SetVtxFaceSeq() {
        int n = this.CurDst().face.length;
        for (int i = 0; i < n; ++i) {
            lvRec.SeqPart seqPart = this.CurDst().face[i];
            int n2 = 0;
            while (n2 < seqPart.num) {
                int n3 = this.CurDst().faceHalfSeq[seqPart.start + n2].vtxNo;
                int n4 = this.CurDst().faceHalfSeq[seqPart.start + n2].radialNo;
                int n5 = this.CurDst().vertex[n3].vtxFace.start;
                this.CurDst().vtxFaceSeq[n5 + n4].faceNo = i;
                this.CurDst().vtxFaceSeq[n5 + n4].halfNo = n2++;
            }
        }
    }

    private final void EdgeProc0() throws lvThrowable {
        int n = this.CurDst().vtxFaceSeq.length / 2;
        this.CurDst().NewEdge(n);
        this.NewTmpEdge(n);
        this.SetTmpEdge();
        this.SetSrcEdgeNo();
        this.SetDstEdgeNo();
        this.SetEdgeInit();
        this.SetEdgeInfo();
    }

    private final void NewTmpEdge(int n) {
        TmpPoly.access$2602(this.TmpPoly(), new TmpEdge[n]);
        for (int i = 0; i < n; ++i) {
            ((TmpPoly)this.TmpPoly()).edge[i] = new TmpEdge();
        }
    }

    private final void SetTmpEdge() throws lvThrowable {
        int n;
        int n2 = this.TmpPoly().radialSeq.length;
        for (n = 0; n < n2; ++n) {
            this.TmpPoly().radialSeq[n].firstLook = false;
        }
        n = 0;
        int n3 = this.TmpPoly().vertex.length;
        for (int i = 0; i < n3; ++i) {
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[i].radial;
            for (int j = 0; j < seqPart.num; ++j) {
                if (this.TmpPoly().radialSeq[seqPart.start + j].firstLook) continue;
                this.Err().Assert(n < this.TmpPoly().edge.length, "lvMakePoly.SetTmpEdge(0)");
                this.TmpPoly().edge[n].v0 = i;
                this.TmpPoly().edge[n].v1 = this.TmpPoly().radialSeq[seqPart.start + j].mateVtxNo;
                this.TmpPoly().radialSeq[seqPart.start + j].firstLook = true;
                this.SetMateFirstLook(this.TmpPoly().edge[n].v1, this.TmpPoly().edge[n].v0);
                ++n;
            }
        }
    }

    private final void SetMateFirstLook(int n, int n2) throws lvThrowable {
        boolean bl = false;
        int n3 = 0;
        lvRec.SeqPart seqPart = this.TmpPoly().vertex[n].radial;
        for (int i = 0; i < seqPart.num; ++i) {
            if (n2 != this.TmpPoly().radialSeq[seqPart.start + i].mateVtxNo) continue;
            bl = true;
            n3 = i;
            break;
        }
        this.Err().Assert(bl, "lvMakePoly.SetMateFirstLook(0)");
        this.TmpPoly().radialSeq[seqPart.start + n3].firstLook = true;
    }

    private final void SetSrcEdgeNo() throws lvThrowable {
        int n;
        int n2 = this.TmpPoly().radialSeq.length;
        for (n = 0; n < n2; ++n) {
            this.TmpPoly().radialSeq[n].srcEdgeNo = -1;
        }
        n = 0;
        int n3 = 0;
        int n4 = this.CurSrc().edge == null ? 0 : this.CurSrc().edge.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = this.CurSrc().edge[i].v0;
            int n6 = this.CurSrc().edge[i].v1;
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[n5].radial;
            for (int j = 0; j < seqPart.num; ++j) {
                if (n6 != this.TmpPoly().radialSeq[seqPart.start + j].mateVtxNo) continue;
                n = 1;
                n3 = j;
                break;
            }
            this.Err().Assert(n == 1, "lvMakePoly.SetSrcEdgeNo(0)");
            this.Err().Assert(this.TmpPoly().radialSeq[seqPart.start + n3].srcEdgeNo < 0, "lvMakePoly.SetSrcEdgeNo(1)");
            this.TmpPoly().radialSeq[seqPart.start + n3].srcEdgeNo = i;
        }
    }

    private final void SetDstEdgeNo() throws lvThrowable {
        int n = this.TmpPoly().radialSeq.length;
        for (int i = 0; i < n; ++i) {
            this.TmpPoly().radialSeq[i].dstEdgeNo = -1;
        }
        this.SetDstEdgeNo0();
        this.SetDstEdgeNo1();
    }

    private final void SetDstEdgeNo0() throws lvThrowable {
        boolean bl = false;
        int n = 0;
        int n2 = this.TmpPoly().edge.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.TmpPoly().edge[i].v0;
            int n4 = this.TmpPoly().edge[i].v1;
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[n3].radial;
            for (int j = 0; j < seqPart.num; ++j) {
                if (n4 != this.TmpPoly().radialSeq[seqPart.start + j].mateVtxNo) continue;
                bl = true;
                n = j;
                break;
            }
            this.Err().Assert(bl, "lvMakePoly.SetDstEdgeNo0(0)");
            this.Err().Assert(this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeNo < 0, "lvMakePoly.SetDstEdgeNo0(1)");
            this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeNo = i;
            this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeReverse = false;
        }
    }

    private final void SetDstEdgeNo1() throws lvThrowable {
        boolean bl = false;
        int n = 0;
        int n2 = this.TmpPoly().edge.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.TmpPoly().edge[i].v0;
            int n4 = this.TmpPoly().edge[i].v1;
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[n4].radial;
            for (int j = 0; j < seqPart.num; ++j) {
                if (n3 != this.TmpPoly().radialSeq[seqPart.start + j].mateVtxNo) continue;
                bl = true;
                n = j;
                break;
            }
            this.Err().Assert(bl, "lvMakePoly.SetDstEdgeNo1(0)");
            this.Err().Assert(this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeNo < 0, "lvMakePoly.SetDstEdgeNo1(1)");
            this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeNo = i;
            this.TmpPoly().radialSeq[seqPart.start + n].dstEdgeReverse = true;
        }
    }

    private final void SetEdgeInit() {
        int n = this.CurDst().edge.length;
        for (int i = 0; i < n; ++i) {
            this.CurDst().edge[i].allRound = 1.0;
            for (int j = 0; j < 2; ++j) {
                lvVecDt.SetXYZ(0.0, 1.0, 0.0, this.CurDst().edge[i].vec[j]);
            }
        }
    }

    private final void SetEdgeInfo() throws lvThrowable {
        int n = this.TmpPoly().vertex.length;
        for (int i = 0; i < n; ++i) {
            lvRec.SeqPart seqPart = this.TmpPoly().vertex[i].radial;
            for (int j = 0; j < seqPart.num; ++j) {
                int n2 = this.TmpPoly().radialSeq[seqPart.start + j].srcEdgeNo;
                int n3 = this.TmpPoly().radialSeq[seqPart.start + j].dstEdgeNo;
                this.Err().Assert(n3 >= 0, "lvMakePoly.SetEdgeInfo(0)");
                boolean bl = this.TmpPoly().radialSeq[seqPart.start + j].dstEdgeReverse;
                this.SetEdgeMain(n2, n3, bl);
            }
        }
    }

    private final void SetEdgeMain(int n, int n2, boolean bl) {
        if (n < 0) {
            return;
        }
        if (this.CurSrc().edge[n].enableAll) {
            this.CurDst().edge[n2].allRound = this.CurSrc().edge[n].allRound;
        }
        if (!bl) {
            if (this.CurSrc().edge[n].vec0 != null) {
                lvVecDt.Copy(this.CurSrc().edge[n].vec0, this.CurDst().edge[n2].vec[0]);
            }
            if (this.CurSrc().edge[n].vec1 != null) {
                lvVecDt.Copy(this.CurSrc().edge[n].vec1, this.CurDst().edge[n2].vec[1]);
            }
        } else {
            if (this.CurSrc().edge[n].vec0 != null) {
                lvVecDt.Copy(this.CurSrc().edge[n].vec0, this.CurDst().edge[n2].vec[1]);
            }
            if (this.CurSrc().edge[n].vec1 != null) {
                lvVecDt.Copy(this.CurSrc().edge[n].vec1, this.CurDst().edge[n2].vec[0]);
            }
        }
    }

    private final void FaceProc1() throws lvThrowable {
        this.SetFaceHalfSeqEdge();
    }

    private final void SetFaceHalfSeqEdge() throws lvThrowable {
        int n = this.CurDst().faceHalfSeq.length;
        for (int i = 0; i < n; ++i) {
            this.CurDst().faceHalfSeq[i].edgeNo = -1;
        }
        for (lvRec.SeqPart seqPart : this.CurDst().face) {
            for (int i = 0; i < seqPart.num; ++i) {
                int n2 = this.CurDst().faceHalfSeq[seqPart.start + i].vtxNo;
                int n3 = this.CurDst().faceHalfSeq[seqPart.start + i].radialNo;
                lvRec.SeqPart seqPart2 = this.TmpPoly().vertex[n2].radial;
                int n4 = this.TmpPoly().radialSeq[seqPart2.start + n3].dstEdgeNo;
                boolean bl = this.TmpPoly().radialSeq[seqPart2.start + n3].dstEdgeReverse;
                this.Err().Assert(this.CurDst().faceHalfSeq[seqPart.start + i].edgeNo < 0, "lvMakePoly.SetFaceHalfSeqEdge(0)");
                this.CurDst().faceHalfSeq[seqPart.start + i].edgeNo = n4;
                this.CurDst().faceHalfSeq[seqPart.start + i].edgeIdx = !bl ? (byte)0 : 1;
            }
        }
    }

    private final void EdgeProc1() throws lvThrowable {
        this.SetEdgeFace();
    }

    private final void SetEdgeFace() throws lvThrowable {
        int n;
        int n2;
        int n3 = this.CurDst().edge.length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.CurDst().edge[n2].face[n].faceNo = -1;
            }
        }
        n2 = this.CurDst().face.length;
        for (n = 0; n < n2; ++n) {
            lvRec.SeqPart seqPart = this.CurDst().face[n];
            int n4 = 0;
            while (n4 < seqPart.num) {
                int n5 = this.CurDst().faceHalfSeq[seqPart.start + n4].edgeNo;
                byte by = this.CurDst().faceHalfSeq[seqPart.start + n4].edgeIdx;
                this.Err().Assert(this.CurDst().edge[n5].face[by].faceNo < 0, "lvMakePoly.SetEdgeFace(0)");
                this.CurDst().edge[n5].face[by].faceNo = n;
                this.CurDst().edge[n5].face[by].halfNo = n4++;
            }
        }
    }

    private final void Finish() {
        TmpPoly.access$802(this.TmpPoly(), null);
        TmpPoly.access$1102(this.TmpPoly(), null);
        TmpPoly.access$1502(this.TmpPoly(), null);
        TmpPoly.access$1602(this.TmpPoly(), null);
        TmpPoly.access$402(this.TmpPoly(), null);
        TmpPoly.access$702(this.TmpPoly(), null);
        TmpPoly.access$2202(this.TmpPoly(), null);
        this.TmpPoly().numNgFace = 0;
        TmpPoly.access$2102(this.TmpPoly(), null);
        TmpPoly.access$2002(this.TmpPoly(), null);
        TmpPoly.access$2602(this.TmpPoly(), null);
        this.Gbl().curSrc = null;
    }

    public static class Global {
        private TmpPoly tmpPoly = new TmpPoly();
        private int curShellNo = 0;
        private lvToKernelLow curSrc = null;

        public Global(lvGlobal lvGlobal2) {
        }
    }

    private static class TmpPoly {
        private TmpVertex[] vertex = null;
        private TmpRadial[] radialSeq = null;
        private TmpRadial[] radialOneVtx = null;
        private boolean[] alreadyExecOneVtx = null;
        private TmpFace[] face = null;
        private int[] faceVtxSeq = null;
        private TmpNgVertex[] srcNgVtxSeq = null;
        private int numNgFace = 0;
        private TmpFace[] ngFace = null;
        private int[] dstNgVtxSeq = null;
        private TmpEdge[] edge = null;

        private TmpPoly() {
        }

        static /* synthetic */ TmpFace[] access$402(TmpPoly tmpPoly, TmpFace[] tmpFaceArray) {
            tmpPoly.face = tmpFaceArray;
            return tmpFaceArray;
        }

        static /* synthetic */ int[] access$702(TmpPoly tmpPoly, int[] nArray) {
            tmpPoly.faceVtxSeq = nArray;
            return nArray;
        }

        static /* synthetic */ TmpVertex[] access$802(TmpPoly tmpPoly, TmpVertex[] tmpVertexArray) {
            tmpPoly.vertex = tmpVertexArray;
            return tmpVertexArray;
        }

        static /* synthetic */ TmpRadial[] access$1102(TmpPoly tmpPoly, TmpRadial[] tmpRadialArray) {
            tmpPoly.radialSeq = tmpRadialArray;
            return tmpRadialArray;
        }

        static /* synthetic */ TmpRadial[] access$1502(TmpPoly tmpPoly, TmpRadial[] tmpRadialArray) {
            tmpPoly.radialOneVtx = tmpRadialArray;
            return tmpRadialArray;
        }

        static /* synthetic */ boolean[] access$1602(TmpPoly tmpPoly, boolean[] blArray) {
            tmpPoly.alreadyExecOneVtx = blArray;
            return blArray;
        }

        static /* synthetic */ TmpFace[] access$2102(TmpPoly tmpPoly, TmpFace[] tmpFaceArray) {
            tmpPoly.ngFace = tmpFaceArray;
            return tmpFaceArray;
        }

        static /* synthetic */ int[] access$2002(TmpPoly tmpPoly, int[] nArray) {
            tmpPoly.dstNgVtxSeq = nArray;
            return nArray;
        }

        static /* synthetic */ TmpNgVertex[] access$2202(TmpPoly tmpPoly, TmpNgVertex[] tmpNgVertexArray) {
            tmpPoly.srcNgVtxSeq = tmpNgVertexArray;
            return tmpNgVertexArray;
        }

        static /* synthetic */ TmpEdge[] access$2602(TmpPoly tmpPoly, TmpEdge[] tmpEdgeArray) {
            tmpPoly.edge = tmpEdgeArray;
            return tmpEdgeArray;
        }
    }

    private static class TmpEdge {
        private int v0;
        private int v1;

        private TmpEdge() {
        }
    }

    private static class TmpNgVertex {
        private int vertexNo;
        private boolean alreadyExec;

        private TmpNgVertex() {
        }
    }

    private static class TmpFace {
        private lvRec.SeqPart vertex = new lvRec.SeqPart();

        private TmpFace() {
        }
    }

    private static class TmpRadial {
        private int mateVtxNo;
        private boolean firstLook;
        private int srcEdgeNo;
        private int dstEdgeNo;
        private boolean dstEdgeReverse;

        private TmpRadial() {
        }

        private static final void Copy(TmpRadial tmpRadial, TmpRadial tmpRadial2) {
            tmpRadial2.mateVtxNo = tmpRadial.mateVtxNo;
            tmpRadial2.firstLook = tmpRadial.firstLook;
            tmpRadial2.srcEdgeNo = tmpRadial.srcEdgeNo;
            tmpRadial2.dstEdgeNo = tmpRadial.dstEdgeNo;
            tmpRadial2.dstEdgeReverse = tmpRadial.dstEdgeReverse;
        }
    }

    private static class TmpVertex {
        private lvRec.SeqPart radial = new lvRec.SeqPart();
        private int tmpCnt;
        private boolean hasNg;

        private TmpVertex() {
        }
    }
}

